// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Elasticsearch Service
///
/// Client for invoking operations on Amazon Elasticsearch Service. Each operation on Amazon Elasticsearch Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_elasticsearch::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_elasticsearch::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_elasticsearch::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AcceptInboundCrossClusterSearchConnection`](crate::client::fluent_builders::AcceptInboundCrossClusterSearchConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cross_cluster_search_connection_id(impl Into<String>)`](crate::client::fluent_builders::AcceptInboundCrossClusterSearchConnection::cross_cluster_search_connection_id) / [`set_cross_cluster_search_connection_id(Option<String>)`](crate::client::fluent_builders::AcceptInboundCrossClusterSearchConnection::set_cross_cluster_search_connection_id): <p>The id of the inbound connection that you want to accept.</p>
    /// - On success, responds with [`AcceptInboundCrossClusterSearchConnectionOutput`](crate::output::AcceptInboundCrossClusterSearchConnectionOutput) with field(s):
    ///   - [`cross_cluster_search_connection(Option<InboundCrossClusterSearchConnection>)`](crate::output::AcceptInboundCrossClusterSearchConnectionOutput::cross_cluster_search_connection): <p>Specifies the <code><code>InboundCrossClusterSearchConnection</code></code> of accepted inbound connection. </p>
    /// - On failure, responds with [`SdkError<AcceptInboundCrossClusterSearchConnectionError>`](crate::error::AcceptInboundCrossClusterSearchConnectionError)
    pub fn accept_inbound_cross_cluster_search_connection(
        &self,
    ) -> fluent_builders::AcceptInboundCrossClusterSearchConnection {
        fluent_builders::AcceptInboundCrossClusterSearchConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddTags`](crate::client::fluent_builders::AddTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::AddTags::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::AddTags::set_arn): <p> Specify the <code>ARN</code> for which you want to add the tags.</p>
    ///   - [`tag_list(Vec<Tag>)`](crate::client::fluent_builders::AddTags::tag_list) / [`set_tag_list(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTags::set_tag_list): <p> List of <code>Tag</code> that need to be added for the Elasticsearch domain. </p>
    /// - On success, responds with [`AddTagsOutput`](crate::output::AddTagsOutput)

    /// - On failure, responds with [`SdkError<AddTagsError>`](crate::error::AddTagsError)
    pub fn add_tags(&self) -> fluent_builders::AddTags {
        fluent_builders::AddTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociatePackage`](crate::client::fluent_builders::AssociatePackage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_id(impl Into<String>)`](crate::client::fluent_builders::AssociatePackage::package_id) / [`set_package_id(Option<String>)`](crate::client::fluent_builders::AssociatePackage::set_package_id): <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::AssociatePackage::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::AssociatePackage::set_domain_name): <p>Name of the domain that you want to associate the package with.</p>
    /// - On success, responds with [`AssociatePackageOutput`](crate::output::AssociatePackageOutput) with field(s):
    ///   - [`domain_package_details(Option<DomainPackageDetails>)`](crate::output::AssociatePackageOutput::domain_package_details): <p><code>DomainPackageDetails</code></p>
    /// - On failure, responds with [`SdkError<AssociatePackageError>`](crate::error::AssociatePackageError)
    pub fn associate_package(&self) -> fluent_builders::AssociatePackage {
        fluent_builders::AssociatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelElasticsearchServiceSoftwareUpdate`](crate::client::fluent_builders::CancelElasticsearchServiceSoftwareUpdate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CancelElasticsearchServiceSoftwareUpdate::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CancelElasticsearchServiceSoftwareUpdate::set_domain_name): <p>The name of the domain that you want to stop the latest service software update on.</p>
    /// - On success, responds with [`CancelElasticsearchServiceSoftwareUpdateOutput`](crate::output::CancelElasticsearchServiceSoftwareUpdateOutput) with field(s):
    ///   - [`service_software_options(Option<ServiceSoftwareOptions>)`](crate::output::CancelElasticsearchServiceSoftwareUpdateOutput::service_software_options): <p>The current status of the Elasticsearch service software update.</p>
    /// - On failure, responds with [`SdkError<CancelElasticsearchServiceSoftwareUpdateError>`](crate::error::CancelElasticsearchServiceSoftwareUpdateError)
    pub fn cancel_elasticsearch_service_software_update(
        &self,
    ) -> fluent_builders::CancelElasticsearchServiceSoftwareUpdate {
        fluent_builders::CancelElasticsearchServiceSoftwareUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateElasticsearchDomain`](crate::client::fluent_builders::CreateElasticsearchDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateElasticsearchDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_domain_name): <p>The name of the Elasticsearch domain that you are creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    ///   - [`elasticsearch_version(impl Into<String>)`](crate::client::fluent_builders::CreateElasticsearchDomain::elasticsearch_version) / [`set_elasticsearch_version(Option<String>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_elasticsearch_version): <p>String of format X.Y to specify version for the Elasticsearch domain eg. "1.5" or "2.3". For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>
    ///   - [`elasticsearch_cluster_config(ElasticsearchClusterConfig)`](crate::client::fluent_builders::CreateElasticsearchDomain::elasticsearch_cluster_config) / [`set_elasticsearch_cluster_config(Option<ElasticsearchClusterConfig>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_elasticsearch_cluster_config): <p>Configuration options for an Elasticsearch domain. Specifies the instance type and number of instances in the domain cluster. </p>
    ///   - [`ebs_options(EbsOptions)`](crate::client::fluent_builders::CreateElasticsearchDomain::ebs_options) / [`set_ebs_options(Option<EbsOptions>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_ebs_options): <p>Options to enable, disable and specify the type and size of EBS storage volumes. </p>
    ///   - [`access_policies(impl Into<String>)`](crate::client::fluent_builders::CreateElasticsearchDomain::access_policies) / [`set_access_policies(Option<String>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_access_policies): <p> IAM access policy as a JSON-formatted string.</p>
    ///   - [`snapshot_options(SnapshotOptions)`](crate::client::fluent_builders::CreateElasticsearchDomain::snapshot_options) / [`set_snapshot_options(Option<SnapshotOptions>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_snapshot_options): <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours. </p>
    ///   - [`vpc_options(VpcOptions)`](crate::client::fluent_builders::CreateElasticsearchDomain::vpc_options) / [`set_vpc_options(Option<VpcOptions>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_vpc_options): <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
    ///   - [`cognito_options(CognitoOptions)`](crate::client::fluent_builders::CreateElasticsearchDomain::cognito_options) / [`set_cognito_options(Option<CognitoOptions>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_cognito_options): <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
    ///   - [`encryption_at_rest_options(EncryptionAtRestOptions)`](crate::client::fluent_builders::CreateElasticsearchDomain::encryption_at_rest_options) / [`set_encryption_at_rest_options(Option<EncryptionAtRestOptions>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_encryption_at_rest_options): <p>Specifies the Encryption At Rest Options.</p>
    ///   - [`node_to_node_encryption_options(NodeToNodeEncryptionOptions)`](crate::client::fluent_builders::CreateElasticsearchDomain::node_to_node_encryption_options) / [`set_node_to_node_encryption_options(Option<NodeToNodeEncryptionOptions>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_node_to_node_encryption_options): <p>Specifies the NodeToNodeEncryptionOptions.</p>
    ///   - [`advanced_options(HashMap<String, String>)`](crate::client::fluent_builders::CreateElasticsearchDomain::advanced_options) / [`set_advanced_options(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_advanced_options): <p> Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
    ///   - [`log_publishing_options(HashMap<LogType, LogPublishingOption>)`](crate::client::fluent_builders::CreateElasticsearchDomain::log_publishing_options) / [`set_log_publishing_options(Option<HashMap<LogType, LogPublishingOption>>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_log_publishing_options): <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
    ///   - [`domain_endpoint_options(DomainEndpointOptions)`](crate::client::fluent_builders::CreateElasticsearchDomain::domain_endpoint_options) / [`set_domain_endpoint_options(Option<DomainEndpointOptions>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_domain_endpoint_options): <p>Options to specify configuration that will be applied to the domain endpoint.</p>
    ///   - [`advanced_security_options(AdvancedSecurityOptionsInput)`](crate::client::fluent_builders::CreateElasticsearchDomain::advanced_security_options) / [`set_advanced_security_options(Option<AdvancedSecurityOptionsInput>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_advanced_security_options): <p>Specifies advanced security options.</p>
    ///   - [`auto_tune_options(AutoTuneOptionsInput)`](crate::client::fluent_builders::CreateElasticsearchDomain::auto_tune_options) / [`set_auto_tune_options(Option<AutoTuneOptionsInput>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_auto_tune_options): <p>Specifies Auto-Tune options.</p>
    ///   - [`tag_list(Vec<Tag>)`](crate::client::fluent_builders::CreateElasticsearchDomain::tag_list) / [`set_tag_list(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateElasticsearchDomain::set_tag_list): <p>A list of <code>Tag</code> added during domain creation.</p>
    /// - On success, responds with [`CreateElasticsearchDomainOutput`](crate::output::CreateElasticsearchDomainOutput) with field(s):
    ///   - [`domain_status(Option<ElasticsearchDomainStatus>)`](crate::output::CreateElasticsearchDomainOutput::domain_status): <p>The status of the newly created Elasticsearch domain. </p>
    /// - On failure, responds with [`SdkError<CreateElasticsearchDomainError>`](crate::error::CreateElasticsearchDomainError)
    pub fn create_elasticsearch_domain(&self) -> fluent_builders::CreateElasticsearchDomain {
        fluent_builders::CreateElasticsearchDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOutboundCrossClusterSearchConnection`](crate::client::fluent_builders::CreateOutboundCrossClusterSearchConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_domain_info(DomainInformation)`](crate::client::fluent_builders::CreateOutboundCrossClusterSearchConnection::source_domain_info) / [`set_source_domain_info(Option<DomainInformation>)`](crate::client::fluent_builders::CreateOutboundCrossClusterSearchConnection::set_source_domain_info): <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
    ///   - [`destination_domain_info(DomainInformation)`](crate::client::fluent_builders::CreateOutboundCrossClusterSearchConnection::destination_domain_info) / [`set_destination_domain_info(Option<DomainInformation>)`](crate::client::fluent_builders::CreateOutboundCrossClusterSearchConnection::set_destination_domain_info): <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
    ///   - [`connection_alias(impl Into<String>)`](crate::client::fluent_builders::CreateOutboundCrossClusterSearchConnection::connection_alias) / [`set_connection_alias(Option<String>)`](crate::client::fluent_builders::CreateOutboundCrossClusterSearchConnection::set_connection_alias): <p>Specifies the connection alias that will be used by the customer for this connection.</p>
    /// - On success, responds with [`CreateOutboundCrossClusterSearchConnectionOutput`](crate::output::CreateOutboundCrossClusterSearchConnectionOutput) with field(s):
    ///   - [`source_domain_info(Option<DomainInformation>)`](crate::output::CreateOutboundCrossClusterSearchConnectionOutput::source_domain_info): <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
    ///   - [`destination_domain_info(Option<DomainInformation>)`](crate::output::CreateOutboundCrossClusterSearchConnectionOutput::destination_domain_info): <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
    ///   - [`connection_alias(Option<String>)`](crate::output::CreateOutboundCrossClusterSearchConnectionOutput::connection_alias): <p>Specifies the connection alias provided during the create connection request.</p>
    ///   - [`connection_status(Option<OutboundCrossClusterSearchConnectionStatus>)`](crate::output::CreateOutboundCrossClusterSearchConnectionOutput::connection_status): <p>Specifies the <code><code>OutboundCrossClusterSearchConnectionStatus</code></code> for the newly created connection.</p>
    ///   - [`cross_cluster_search_connection_id(Option<String>)`](crate::output::CreateOutboundCrossClusterSearchConnectionOutput::cross_cluster_search_connection_id): <p>Unique id for the created outbound connection, which is used for subsequent operations on connection.</p>
    /// - On failure, responds with [`SdkError<CreateOutboundCrossClusterSearchConnectionError>`](crate::error::CreateOutboundCrossClusterSearchConnectionError)
    pub fn create_outbound_cross_cluster_search_connection(
        &self,
    ) -> fluent_builders::CreateOutboundCrossClusterSearchConnection {
        fluent_builders::CreateOutboundCrossClusterSearchConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePackage`](crate::client::fluent_builders::CreatePackage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_name(impl Into<String>)`](crate::client::fluent_builders::CreatePackage::package_name) / [`set_package_name(Option<String>)`](crate::client::fluent_builders::CreatePackage::set_package_name): <p>Unique identifier for the package.</p>
    ///   - [`package_type(PackageType)`](crate::client::fluent_builders::CreatePackage::package_type) / [`set_package_type(Option<PackageType>)`](crate::client::fluent_builders::CreatePackage::set_package_type): <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
    ///   - [`package_description(impl Into<String>)`](crate::client::fluent_builders::CreatePackage::package_description) / [`set_package_description(Option<String>)`](crate::client::fluent_builders::CreatePackage::set_package_description): <p>Description of the package.</p>
    ///   - [`package_source(PackageSource)`](crate::client::fluent_builders::CreatePackage::package_source) / [`set_package_source(Option<PackageSource>)`](crate::client::fluent_builders::CreatePackage::set_package_source): <p>The customer S3 location <code>PackageSource</code> for importing the package.</p>
    /// - On success, responds with [`CreatePackageOutput`](crate::output::CreatePackageOutput) with field(s):
    ///   - [`package_details(Option<PackageDetails>)`](crate::output::CreatePackageOutput::package_details): <p>Information about the package <code>PackageDetails</code>.</p>
    /// - On failure, responds with [`SdkError<CreatePackageError>`](crate::error::CreatePackageError)
    pub fn create_package(&self) -> fluent_builders::CreatePackage {
        fluent_builders::CreatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteElasticsearchDomain`](crate::client::fluent_builders::DeleteElasticsearchDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteElasticsearchDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteElasticsearchDomain::set_domain_name): <p>The name of the Elasticsearch domain that you want to permanently delete.</p>
    /// - On success, responds with [`DeleteElasticsearchDomainOutput`](crate::output::DeleteElasticsearchDomainOutput) with field(s):
    ///   - [`domain_status(Option<ElasticsearchDomainStatus>)`](crate::output::DeleteElasticsearchDomainOutput::domain_status): <p>The status of the Elasticsearch domain being deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteElasticsearchDomainError>`](crate::error::DeleteElasticsearchDomainError)
    pub fn delete_elasticsearch_domain(&self) -> fluent_builders::DeleteElasticsearchDomain {
        fluent_builders::DeleteElasticsearchDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteElasticsearchServiceRole`](crate::client::fluent_builders::DeleteElasticsearchServiceRole) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DeleteElasticsearchServiceRole::send) it.

    /// - On success, responds with [`DeleteElasticsearchServiceRoleOutput`](crate::output::DeleteElasticsearchServiceRoleOutput)

    /// - On failure, responds with [`SdkError<DeleteElasticsearchServiceRoleError>`](crate::error::DeleteElasticsearchServiceRoleError)
    pub fn delete_elasticsearch_service_role(
        &self,
    ) -> fluent_builders::DeleteElasticsearchServiceRole {
        fluent_builders::DeleteElasticsearchServiceRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInboundCrossClusterSearchConnection`](crate::client::fluent_builders::DeleteInboundCrossClusterSearchConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cross_cluster_search_connection_id(impl Into<String>)`](crate::client::fluent_builders::DeleteInboundCrossClusterSearchConnection::cross_cluster_search_connection_id) / [`set_cross_cluster_search_connection_id(Option<String>)`](crate::client::fluent_builders::DeleteInboundCrossClusterSearchConnection::set_cross_cluster_search_connection_id): <p>The id of the inbound connection that you want to permanently delete.</p>
    /// - On success, responds with [`DeleteInboundCrossClusterSearchConnectionOutput`](crate::output::DeleteInboundCrossClusterSearchConnectionOutput) with field(s):
    ///   - [`cross_cluster_search_connection(Option<InboundCrossClusterSearchConnection>)`](crate::output::DeleteInboundCrossClusterSearchConnectionOutput::cross_cluster_search_connection): <p>Specifies the <code><code>InboundCrossClusterSearchConnection</code></code> of deleted inbound connection. </p>
    /// - On failure, responds with [`SdkError<DeleteInboundCrossClusterSearchConnectionError>`](crate::error::DeleteInboundCrossClusterSearchConnectionError)
    pub fn delete_inbound_cross_cluster_search_connection(
        &self,
    ) -> fluent_builders::DeleteInboundCrossClusterSearchConnection {
        fluent_builders::DeleteInboundCrossClusterSearchConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOutboundCrossClusterSearchConnection`](crate::client::fluent_builders::DeleteOutboundCrossClusterSearchConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cross_cluster_search_connection_id(impl Into<String>)`](crate::client::fluent_builders::DeleteOutboundCrossClusterSearchConnection::cross_cluster_search_connection_id) / [`set_cross_cluster_search_connection_id(Option<String>)`](crate::client::fluent_builders::DeleteOutboundCrossClusterSearchConnection::set_cross_cluster_search_connection_id): <p>The id of the outbound connection that you want to permanently delete.</p>
    /// - On success, responds with [`DeleteOutboundCrossClusterSearchConnectionOutput`](crate::output::DeleteOutboundCrossClusterSearchConnectionOutput) with field(s):
    ///   - [`cross_cluster_search_connection(Option<OutboundCrossClusterSearchConnection>)`](crate::output::DeleteOutboundCrossClusterSearchConnectionOutput::cross_cluster_search_connection): <p>Specifies the <code><code>OutboundCrossClusterSearchConnection</code></code> of deleted outbound connection. </p>
    /// - On failure, responds with [`SdkError<DeleteOutboundCrossClusterSearchConnectionError>`](crate::error::DeleteOutboundCrossClusterSearchConnectionError)
    pub fn delete_outbound_cross_cluster_search_connection(
        &self,
    ) -> fluent_builders::DeleteOutboundCrossClusterSearchConnection {
        fluent_builders::DeleteOutboundCrossClusterSearchConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePackage`](crate::client::fluent_builders::DeletePackage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_id(impl Into<String>)`](crate::client::fluent_builders::DeletePackage::package_id) / [`set_package_id(Option<String>)`](crate::client::fluent_builders::DeletePackage::set_package_id): <p>Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this value.</p>
    /// - On success, responds with [`DeletePackageOutput`](crate::output::DeletePackageOutput) with field(s):
    ///   - [`package_details(Option<PackageDetails>)`](crate::output::DeletePackageOutput::package_details): <p><code>PackageDetails</code></p>
    /// - On failure, responds with [`SdkError<DeletePackageError>`](crate::error::DeletePackageError)
    pub fn delete_package(&self) -> fluent_builders::DeletePackage {
        fluent_builders::DeletePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDomainAutoTunes`](crate::client::fluent_builders::DescribeDomainAutoTunes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDomainAutoTunes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDomainAutoTunes::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DescribeDomainAutoTunes::set_domain_name): <p>Specifies the domain name for which you want Auto-Tune action details.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeDomainAutoTunes::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeDomainAutoTunes::set_max_results): <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDomainAutoTunes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDomainAutoTunes::set_next_token): <p>NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
    /// - On success, responds with [`DescribeDomainAutoTunesOutput`](crate::output::DescribeDomainAutoTunesOutput) with field(s):
    ///   - [`auto_tunes(Option<Vec<AutoTune>>)`](crate::output::DescribeDomainAutoTunesOutput::auto_tunes): <p>Specifies the list of setting adjustments that Auto-Tune has made to the domain. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDomainAutoTunesOutput::next_token): <p>Specifies an identifier to allow retrieval of paginated results.</p>
    /// - On failure, responds with [`SdkError<DescribeDomainAutoTunesError>`](crate::error::DescribeDomainAutoTunesError)
    pub fn describe_domain_auto_tunes(&self) -> fluent_builders::DescribeDomainAutoTunes {
        fluent_builders::DescribeDomainAutoTunes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDomainChangeProgress`](crate::client::fluent_builders::DescribeDomainChangeProgress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDomainChangeProgress::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DescribeDomainChangeProgress::set_domain_name): <p>The domain you want to get the progress information about.</p>
    ///   - [`change_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDomainChangeProgress::change_id) / [`set_change_id(Option<String>)`](crate::client::fluent_builders::DescribeDomainChangeProgress::set_change_id): <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
    /// - On success, responds with [`DescribeDomainChangeProgressOutput`](crate::output::DescribeDomainChangeProgressOutput) with field(s):
    ///   - [`change_progress_status(Option<ChangeProgressStatusDetails>)`](crate::output::DescribeDomainChangeProgressOutput::change_progress_status): <p>Progress information for the configuration change that is requested in the <code>DescribeDomainChangeProgress</code> request. </p>
    /// - On failure, responds with [`SdkError<DescribeDomainChangeProgressError>`](crate::error::DescribeDomainChangeProgressError)
    pub fn describe_domain_change_progress(&self) -> fluent_builders::DescribeDomainChangeProgress {
        fluent_builders::DescribeDomainChangeProgress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeElasticsearchDomain`](crate::client::fluent_builders::DescribeElasticsearchDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DescribeElasticsearchDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DescribeElasticsearchDomain::set_domain_name): <p>The name of the Elasticsearch domain for which you want information.</p>
    /// - On success, responds with [`DescribeElasticsearchDomainOutput`](crate::output::DescribeElasticsearchDomainOutput) with field(s):
    ///   - [`domain_status(Option<ElasticsearchDomainStatus>)`](crate::output::DescribeElasticsearchDomainOutput::domain_status): <p>The current status of the Elasticsearch domain.</p>
    /// - On failure, responds with [`SdkError<DescribeElasticsearchDomainError>`](crate::error::DescribeElasticsearchDomainError)
    pub fn describe_elasticsearch_domain(&self) -> fluent_builders::DescribeElasticsearchDomain {
        fluent_builders::DescribeElasticsearchDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeElasticsearchDomainConfig`](crate::client::fluent_builders::DescribeElasticsearchDomainConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DescribeElasticsearchDomainConfig::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DescribeElasticsearchDomainConfig::set_domain_name): <p>The Elasticsearch domain that you want to get information about.</p>
    /// - On success, responds with [`DescribeElasticsearchDomainConfigOutput`](crate::output::DescribeElasticsearchDomainConfigOutput) with field(s):
    ///   - [`domain_config(Option<ElasticsearchDomainConfig>)`](crate::output::DescribeElasticsearchDomainConfigOutput::domain_config): <p>The configuration information of the domain requested in the <code>DescribeElasticsearchDomainConfig</code> request.</p>
    /// - On failure, responds with [`SdkError<DescribeElasticsearchDomainConfigError>`](crate::error::DescribeElasticsearchDomainConfigError)
    pub fn describe_elasticsearch_domain_config(
        &self,
    ) -> fluent_builders::DescribeElasticsearchDomainConfig {
        fluent_builders::DescribeElasticsearchDomainConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeElasticsearchDomains`](crate::client::fluent_builders::DescribeElasticsearchDomains) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_names(Vec<String>)`](crate::client::fluent_builders::DescribeElasticsearchDomains::domain_names) / [`set_domain_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeElasticsearchDomains::set_domain_names): <p>The Elasticsearch domains for which you want information.</p>
    /// - On success, responds with [`DescribeElasticsearchDomainsOutput`](crate::output::DescribeElasticsearchDomainsOutput) with field(s):
    ///   - [`domain_status_list(Option<Vec<ElasticsearchDomainStatus>>)`](crate::output::DescribeElasticsearchDomainsOutput::domain_status_list): <p>The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.</p>
    /// - On failure, responds with [`SdkError<DescribeElasticsearchDomainsError>`](crate::error::DescribeElasticsearchDomainsError)
    pub fn describe_elasticsearch_domains(&self) -> fluent_builders::DescribeElasticsearchDomains {
        fluent_builders::DescribeElasticsearchDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeElasticsearchInstanceTypeLimits`](crate::client::fluent_builders::DescribeElasticsearchInstanceTypeLimits) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DescribeElasticsearchInstanceTypeLimits::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DescribeElasticsearchInstanceTypeLimits::set_domain_name): <p> DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for Elasticsearch <code> <code>Limits</code> </code> for existing domain. </p>
    ///   - [`instance_type(EsPartitionInstanceType)`](crate::client::fluent_builders::DescribeElasticsearchInstanceTypeLimits::instance_type) / [`set_instance_type(Option<EsPartitionInstanceType>)`](crate::client::fluent_builders::DescribeElasticsearchInstanceTypeLimits::set_instance_type): <p> The instance type for an Elasticsearch cluster for which Elasticsearch <code> <code>Limits</code> </code> are needed. </p>
    ///   - [`elasticsearch_version(impl Into<String>)`](crate::client::fluent_builders::DescribeElasticsearchInstanceTypeLimits::elasticsearch_version) / [`set_elasticsearch_version(Option<String>)`](crate::client::fluent_builders::DescribeElasticsearchInstanceTypeLimits::set_elasticsearch_version): <p> Version of Elasticsearch for which <code> <code>Limits</code> </code> are needed. </p>
    /// - On success, responds with [`DescribeElasticsearchInstanceTypeLimitsOutput`](crate::output::DescribeElasticsearchInstanceTypeLimitsOutput) with field(s):
    ///   - [`limits_by_role(Option<HashMap<String, Limits>>)`](crate::output::DescribeElasticsearchInstanceTypeLimitsOutput::limits_by_role): <p> Map of Role of the Instance and Limits that are applicable. Role performed by given Instance in Elasticsearch can be one of the following: </p> <ul>   <li>data: If the given InstanceType is used as data node</li>   <li>master: If the given InstanceType is used as master node</li>   <li>ultra_warm: If the given InstanceType is used as warm node</li>  </ul>  <p></p>
    /// - On failure, responds with [`SdkError<DescribeElasticsearchInstanceTypeLimitsError>`](crate::error::DescribeElasticsearchInstanceTypeLimitsError)
    pub fn describe_elasticsearch_instance_type_limits(
        &self,
    ) -> fluent_builders::DescribeElasticsearchInstanceTypeLimits {
        fluent_builders::DescribeElasticsearchInstanceTypeLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInboundCrossClusterSearchConnections`](crate::client::fluent_builders::DescribeInboundCrossClusterSearchConnections) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInboundCrossClusterSearchConnections::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeInboundCrossClusterSearchConnections::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeInboundCrossClusterSearchConnections::set_filters): <p> A list of filters used to match properties for inbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p> <ul>   <li>cross-cluster-search-connection-id</li>   <li>source-domain-info.domain-name</li>   <li>source-domain-info.owner-id</li>   <li>source-domain-info.region</li>   <li>destination-domain-info.domain-name</li>  </ul>  <p></p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInboundCrossClusterSearchConnections::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeInboundCrossClusterSearchConnections::set_max_results): <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInboundCrossClusterSearchConnections::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInboundCrossClusterSearchConnections::set_next_token): <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
    /// - On success, responds with [`DescribeInboundCrossClusterSearchConnectionsOutput`](crate::output::DescribeInboundCrossClusterSearchConnectionsOutput) with field(s):
    ///   - [`cross_cluster_search_connections(Option<Vec<InboundCrossClusterSearchConnection>>)`](crate::output::DescribeInboundCrossClusterSearchConnectionsOutput::cross_cluster_search_connections): <p>Consists of list of <code><code>InboundCrossClusterSearchConnection</code></code> matching the specified filter criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInboundCrossClusterSearchConnectionsOutput::next_token): <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results. </p>
    /// - On failure, responds with [`SdkError<DescribeInboundCrossClusterSearchConnectionsError>`](crate::error::DescribeInboundCrossClusterSearchConnectionsError)
    pub fn describe_inbound_cross_cluster_search_connections(
        &self,
    ) -> fluent_builders::DescribeInboundCrossClusterSearchConnections {
        fluent_builders::DescribeInboundCrossClusterSearchConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOutboundCrossClusterSearchConnections`](crate::client::fluent_builders::DescribeOutboundCrossClusterSearchConnections) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeOutboundCrossClusterSearchConnections::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeOutboundCrossClusterSearchConnections::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeOutboundCrossClusterSearchConnections::set_filters): <p> A list of filters used to match properties for outbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p> <ul>   <li>cross-cluster-search-connection-id</li>   <li>destination-domain-info.domain-name</li>   <li>destination-domain-info.owner-id</li>   <li>destination-domain-info.region</li>   <li>source-domain-info.domain-name</li>  </ul>  <p></p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeOutboundCrossClusterSearchConnections::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeOutboundCrossClusterSearchConnections::set_max_results): <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeOutboundCrossClusterSearchConnections::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeOutboundCrossClusterSearchConnections::set_next_token): <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
    /// - On success, responds with [`DescribeOutboundCrossClusterSearchConnectionsOutput`](crate::output::DescribeOutboundCrossClusterSearchConnectionsOutput) with field(s):
    ///   - [`cross_cluster_search_connections(Option<Vec<OutboundCrossClusterSearchConnection>>)`](crate::output::DescribeOutboundCrossClusterSearchConnectionsOutput::cross_cluster_search_connections): <p>Consists of list of <code><code>OutboundCrossClusterSearchConnection</code></code> matching the specified filter criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeOutboundCrossClusterSearchConnectionsOutput::next_token): <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results. </p>
    /// - On failure, responds with [`SdkError<DescribeOutboundCrossClusterSearchConnectionsError>`](crate::error::DescribeOutboundCrossClusterSearchConnectionsError)
    pub fn describe_outbound_cross_cluster_search_connections(
        &self,
    ) -> fluent_builders::DescribeOutboundCrossClusterSearchConnections {
        fluent_builders::DescribeOutboundCrossClusterSearchConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePackages`](crate::client::fluent_builders::DescribePackages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePackages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<DescribePackagesFilter>)`](crate::client::fluent_builders::DescribePackages::filters) / [`set_filters(Option<Vec<DescribePackagesFilter>>)`](crate::client::fluent_builders::DescribePackages::set_filters): <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribePackages::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribePackages::set_max_results): <p>Limits results to a maximum number of packages.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribePackages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribePackages::set_next_token): <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
    /// - On success, responds with [`DescribePackagesOutput`](crate::output::DescribePackagesOutput) with field(s):
    ///   - [`package_details_list(Option<Vec<PackageDetails>>)`](crate::output::DescribePackagesOutput::package_details_list): <p>List of <code>PackageDetails</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribePackagesOutput::next_token): (undocumented)
    /// - On failure, responds with [`SdkError<DescribePackagesError>`](crate::error::DescribePackagesError)
    pub fn describe_packages(&self) -> fluent_builders::DescribePackages {
        fluent_builders::DescribePackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedElasticsearchInstanceOfferings`](crate::client::fluent_builders::DescribeReservedElasticsearchInstanceOfferings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedElasticsearchInstanceOfferings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_elasticsearch_instance_offering_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedElasticsearchInstanceOfferings::reserved_elasticsearch_instance_offering_id) / [`set_reserved_elasticsearch_instance_offering_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedElasticsearchInstanceOfferings::set_reserved_elasticsearch_instance_offering_id): <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeReservedElasticsearchInstanceOfferings::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeReservedElasticsearchInstanceOfferings::set_max_results): <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedElasticsearchInstanceOfferings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeReservedElasticsearchInstanceOfferings::set_next_token): <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
    /// - On success, responds with [`DescribeReservedElasticsearchInstanceOfferingsOutput`](crate::output::DescribeReservedElasticsearchInstanceOfferingsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeReservedElasticsearchInstanceOfferingsOutput::next_token): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`reserved_elasticsearch_instance_offerings(Option<Vec<ReservedElasticsearchInstanceOffering>>)`](crate::output::DescribeReservedElasticsearchInstanceOfferingsOutput::reserved_elasticsearch_instance_offerings): <p>List of reserved Elasticsearch instance offerings</p>
    /// - On failure, responds with [`SdkError<DescribeReservedElasticsearchInstanceOfferingsError>`](crate::error::DescribeReservedElasticsearchInstanceOfferingsError)
    pub fn describe_reserved_elasticsearch_instance_offerings(
        &self,
    ) -> fluent_builders::DescribeReservedElasticsearchInstanceOfferings {
        fluent_builders::DescribeReservedElasticsearchInstanceOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedElasticsearchInstances`](crate::client::fluent_builders::DescribeReservedElasticsearchInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedElasticsearchInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_elasticsearch_instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedElasticsearchInstances::reserved_elasticsearch_instance_id) / [`set_reserved_elasticsearch_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedElasticsearchInstances::set_reserved_elasticsearch_instance_id): <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved Elasticsearch instance ID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeReservedElasticsearchInstances::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeReservedElasticsearchInstances::set_max_results): <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedElasticsearchInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeReservedElasticsearchInstances::set_next_token): <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
    /// - On success, responds with [`DescribeReservedElasticsearchInstancesOutput`](crate::output::DescribeReservedElasticsearchInstancesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeReservedElasticsearchInstancesOutput::next_token): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`reserved_elasticsearch_instances(Option<Vec<ReservedElasticsearchInstance>>)`](crate::output::DescribeReservedElasticsearchInstancesOutput::reserved_elasticsearch_instances): <p>List of reserved Elasticsearch instances.</p>
    /// - On failure, responds with [`SdkError<DescribeReservedElasticsearchInstancesError>`](crate::error::DescribeReservedElasticsearchInstancesError)
    pub fn describe_reserved_elasticsearch_instances(
        &self,
    ) -> fluent_builders::DescribeReservedElasticsearchInstances {
        fluent_builders::DescribeReservedElasticsearchInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DissociatePackage`](crate::client::fluent_builders::DissociatePackage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_id(impl Into<String>)`](crate::client::fluent_builders::DissociatePackage::package_id) / [`set_package_id(Option<String>)`](crate::client::fluent_builders::DissociatePackage::set_package_id): <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DissociatePackage::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DissociatePackage::set_domain_name): <p>Name of the domain that you want to associate the package with.</p>
    /// - On success, responds with [`DissociatePackageOutput`](crate::output::DissociatePackageOutput) with field(s):
    ///   - [`domain_package_details(Option<DomainPackageDetails>)`](crate::output::DissociatePackageOutput::domain_package_details): <p><code>DomainPackageDetails</code></p>
    /// - On failure, responds with [`SdkError<DissociatePackageError>`](crate::error::DissociatePackageError)
    pub fn dissociate_package(&self) -> fluent_builders::DissociatePackage {
        fluent_builders::DissociatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCompatibleElasticsearchVersions`](crate::client::fluent_builders::GetCompatibleElasticsearchVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetCompatibleElasticsearchVersions::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetCompatibleElasticsearchVersions::set_domain_name): <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    /// - On success, responds with [`GetCompatibleElasticsearchVersionsOutput`](crate::output::GetCompatibleElasticsearchVersionsOutput) with field(s):
    ///   - [`compatible_elasticsearch_versions(Option<Vec<CompatibleVersionsMap>>)`](crate::output::GetCompatibleElasticsearchVersionsOutput::compatible_elasticsearch_versions): <p> A map of compatible Elasticsearch versions returned as part of the <code> <code>GetCompatibleElasticsearchVersions</code> </code> operation. </p>
    /// - On failure, responds with [`SdkError<GetCompatibleElasticsearchVersionsError>`](crate::error::GetCompatibleElasticsearchVersionsError)
    pub fn get_compatible_elasticsearch_versions(
        &self,
    ) -> fluent_builders::GetCompatibleElasticsearchVersions {
        fluent_builders::GetCompatibleElasticsearchVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPackageVersionHistory`](crate::client::fluent_builders::GetPackageVersionHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetPackageVersionHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_id(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionHistory::package_id) / [`set_package_id(Option<String>)`](crate::client::fluent_builders::GetPackageVersionHistory::set_package_id): <p>Returns an audit history of versions of the package.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetPackageVersionHistory::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetPackageVersionHistory::set_max_results): <p>Limits results to a maximum number of versions.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetPackageVersionHistory::set_next_token): <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
    /// - On success, responds with [`GetPackageVersionHistoryOutput`](crate::output::GetPackageVersionHistoryOutput) with field(s):
    ///   - [`package_id(Option<String>)`](crate::output::GetPackageVersionHistoryOutput::package_id): (undocumented)
    ///   - [`package_version_history_list(Option<Vec<PackageVersionHistory>>)`](crate::output::GetPackageVersionHistoryOutput::package_version_history_list): <p>List of <code>PackageVersionHistory</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetPackageVersionHistoryOutput::next_token): (undocumented)
    /// - On failure, responds with [`SdkError<GetPackageVersionHistoryError>`](crate::error::GetPackageVersionHistoryError)
    pub fn get_package_version_history(&self) -> fluent_builders::GetPackageVersionHistory {
        fluent_builders::GetPackageVersionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUpgradeHistory`](crate::client::fluent_builders::GetUpgradeHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetUpgradeHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetUpgradeHistory::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetUpgradeHistory::set_domain_name): <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetUpgradeHistory::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetUpgradeHistory::set_max_results): <p> Set this value to limit the number of results returned. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetUpgradeHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetUpgradeHistory::set_next_token): <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
    /// - On success, responds with [`GetUpgradeHistoryOutput`](crate::output::GetUpgradeHistoryOutput) with field(s):
    ///   - [`upgrade_histories(Option<Vec<UpgradeHistory>>)`](crate::output::GetUpgradeHistoryOutput::upgrade_histories): <p> A list of <code> <code>UpgradeHistory</code> </code> objects corresponding to each Upgrade or Upgrade Eligibility Check performed on a domain returned as part of <code> <code>GetUpgradeHistoryResponse</code> </code> object. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetUpgradeHistoryOutput::next_token): <p>Pagination token that needs to be supplied to the next call to get the next page of results</p>
    /// - On failure, responds with [`SdkError<GetUpgradeHistoryError>`](crate::error::GetUpgradeHistoryError)
    pub fn get_upgrade_history(&self) -> fluent_builders::GetUpgradeHistory {
        fluent_builders::GetUpgradeHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUpgradeStatus`](crate::client::fluent_builders::GetUpgradeStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetUpgradeStatus::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetUpgradeStatus::set_domain_name): <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    /// - On success, responds with [`GetUpgradeStatusOutput`](crate::output::GetUpgradeStatusOutput) with field(s):
    ///   - [`upgrade_step(Option<UpgradeStep>)`](crate::output::GetUpgradeStatusOutput::upgrade_step): <p> Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does through: </p> <ul>   <li>PreUpgradeCheck</li>   <li>Snapshot</li>   <li>Upgrade</li>  </ul>  <p></p>
    ///   - [`step_status(Option<UpgradeStatus>)`](crate::output::GetUpgradeStatusOutput::step_status): <p> One of 4 statuses that a step can go through returned as part of the <code> <code>GetUpgradeStatusResponse</code> </code> object. The status can take one of the following values: </p> <ul>   <li>In Progress</li>   <li>Succeeded</li>   <li>Succeeded with Issues</li>   <li>Failed</li>  </ul>  <p></p>
    ///   - [`upgrade_name(Option<String>)`](crate::output::GetUpgradeStatusOutput::upgrade_name): <p>A string that describes the update briefly</p>
    /// - On failure, responds with [`SdkError<GetUpgradeStatusError>`](crate::error::GetUpgradeStatusError)
    pub fn get_upgrade_status(&self) -> fluent_builders::GetUpgradeStatus {
        fluent_builders::GetUpgradeStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomainNames`](crate::client::fluent_builders::ListDomainNames) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine_type(EngineType)`](crate::client::fluent_builders::ListDomainNames::engine_type) / [`set_engine_type(Option<EngineType>)`](crate::client::fluent_builders::ListDomainNames::set_engine_type): <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
    /// - On success, responds with [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput) with field(s):
    ///   - [`domain_names(Option<Vec<DomainInfo>>)`](crate::output::ListDomainNamesOutput::domain_names): <p>List of domain names and respective engine types.</p>
    /// - On failure, responds with [`SdkError<ListDomainNamesError>`](crate::error::ListDomainNamesError)
    pub fn list_domain_names(&self) -> fluent_builders::ListDomainNames {
        fluent_builders::ListDomainNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomainsForPackage`](crate::client::fluent_builders::ListDomainsForPackage) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDomainsForPackage::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_id(impl Into<String>)`](crate::client::fluent_builders::ListDomainsForPackage::package_id) / [`set_package_id(Option<String>)`](crate::client::fluent_builders::ListDomainsForPackage::set_package_id): <p>The package for which to list domains.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDomainsForPackage::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListDomainsForPackage::set_max_results): <p>Limits results to a maximum number of domains.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDomainsForPackage::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDomainsForPackage::set_next_token): <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
    /// - On success, responds with [`ListDomainsForPackageOutput`](crate::output::ListDomainsForPackageOutput) with field(s):
    ///   - [`domain_package_details_list(Option<Vec<DomainPackageDetails>>)`](crate::output::ListDomainsForPackageOutput::domain_package_details_list): <p>List of <code>DomainPackageDetails</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDomainsForPackageOutput::next_token): (undocumented)
    /// - On failure, responds with [`SdkError<ListDomainsForPackageError>`](crate::error::ListDomainsForPackageError)
    pub fn list_domains_for_package(&self) -> fluent_builders::ListDomainsForPackage {
        fluent_builders::ListDomainsForPackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListElasticsearchInstanceTypes`](crate::client::fluent_builders::ListElasticsearchInstanceTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListElasticsearchInstanceTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`elasticsearch_version(impl Into<String>)`](crate::client::fluent_builders::ListElasticsearchInstanceTypes::elasticsearch_version) / [`set_elasticsearch_version(Option<String>)`](crate::client::fluent_builders::ListElasticsearchInstanceTypes::set_elasticsearch_version): <p>Version of Elasticsearch for which list of supported elasticsearch instance types are needed. </p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::ListElasticsearchInstanceTypes::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::ListElasticsearchInstanceTypes::set_domain_name): <p>DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for list of available Elasticsearch instance types when modifying existing domain. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListElasticsearchInstanceTypes::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListElasticsearchInstanceTypes::set_max_results): <p> Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont be honored. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListElasticsearchInstanceTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListElasticsearchInstanceTypes::set_next_token): <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. </p>
    /// - On success, responds with [`ListElasticsearchInstanceTypesOutput`](crate::output::ListElasticsearchInstanceTypesOutput) with field(s):
    ///   - [`elasticsearch_instance_types(Option<Vec<EsPartitionInstanceType>>)`](crate::output::ListElasticsearchInstanceTypesOutput::elasticsearch_instance_types): <p> List of instance types supported by Amazon Elasticsearch service for given <code> <code>ElasticsearchVersion</code> </code> </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListElasticsearchInstanceTypesOutput::next_token): <p>In case if there are more results available NextToken would be present, make further request to the same API with received NextToken to paginate remaining results. </p>
    /// - On failure, responds with [`SdkError<ListElasticsearchInstanceTypesError>`](crate::error::ListElasticsearchInstanceTypesError)
    pub fn list_elasticsearch_instance_types(
        &self,
    ) -> fluent_builders::ListElasticsearchInstanceTypes {
        fluent_builders::ListElasticsearchInstanceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListElasticsearchVersions`](crate::client::fluent_builders::ListElasticsearchVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListElasticsearchVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListElasticsearchVersions::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListElasticsearchVersions::set_max_results): <p> Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListElasticsearchVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListElasticsearchVersions::set_next_token): <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
    /// - On success, responds with [`ListElasticsearchVersionsOutput`](crate::output::ListElasticsearchVersionsOutput) with field(s):
    ///   - [`elasticsearch_versions(Option<Vec<String>>)`](crate::output::ListElasticsearchVersionsOutput::elasticsearch_versions): <p>List of supported elastic search versions. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListElasticsearchVersionsOutput::next_token): <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
    /// - On failure, responds with [`SdkError<ListElasticsearchVersionsError>`](crate::error::ListElasticsearchVersionsError)
    pub fn list_elasticsearch_versions(&self) -> fluent_builders::ListElasticsearchVersions {
        fluent_builders::ListElasticsearchVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPackagesForDomain`](crate::client::fluent_builders::ListPackagesForDomain) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPackagesForDomain::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::ListPackagesForDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::ListPackagesForDomain::set_domain_name): <p>The name of the domain for which you want to list associated packages.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPackagesForDomain::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListPackagesForDomain::set_max_results): <p>Limits results to a maximum number of packages.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPackagesForDomain::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPackagesForDomain::set_next_token): <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
    /// - On success, responds with [`ListPackagesForDomainOutput`](crate::output::ListPackagesForDomainOutput) with field(s):
    ///   - [`domain_package_details_list(Option<Vec<DomainPackageDetails>>)`](crate::output::ListPackagesForDomainOutput::domain_package_details_list): <p>List of <code>DomainPackageDetails</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPackagesForDomainOutput::next_token): <p>Pagination token that needs to be supplied to the next call to get the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListPackagesForDomainError>`](crate::error::ListPackagesForDomainError)
    pub fn list_packages_for_domain(&self) -> fluent_builders::ListPackagesForDomain {
        fluent_builders::ListPackagesForDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTags`](crate::client::fluent_builders::ListTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::ListTags::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::ListTags::set_arn): <p> Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view.</p>
    /// - On success, responds with [`ListTagsOutput`](crate::output::ListTagsOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ListTagsOutput::tag_list): <p> List of <code>Tag</code> for the requested Elasticsearch domain.</p>
    /// - On failure, responds with [`SdkError<ListTagsError>`](crate::error::ListTagsError)
    pub fn list_tags(&self) -> fluent_builders::ListTags {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PurchaseReservedElasticsearchInstanceOffering`](crate::client::fluent_builders::PurchaseReservedElasticsearchInstanceOffering) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_elasticsearch_instance_offering_id(impl Into<String>)`](crate::client::fluent_builders::PurchaseReservedElasticsearchInstanceOffering::reserved_elasticsearch_instance_offering_id) / [`set_reserved_elasticsearch_instance_offering_id(Option<String>)`](crate::client::fluent_builders::PurchaseReservedElasticsearchInstanceOffering::set_reserved_elasticsearch_instance_offering_id): <p>The ID of the reserved Elasticsearch instance offering to purchase.</p>
    ///   - [`reservation_name(impl Into<String>)`](crate::client::fluent_builders::PurchaseReservedElasticsearchInstanceOffering::reservation_name) / [`set_reservation_name(Option<String>)`](crate::client::fluent_builders::PurchaseReservedElasticsearchInstanceOffering::set_reservation_name): <p>A customer-specified identifier to track this reservation.</p>
    ///   - [`instance_count(i32)`](crate::client::fluent_builders::PurchaseReservedElasticsearchInstanceOffering::instance_count) / [`set_instance_count(i32)`](crate::client::fluent_builders::PurchaseReservedElasticsearchInstanceOffering::set_instance_count): <p>The number of Elasticsearch instances to reserve.</p>
    /// - On success, responds with [`PurchaseReservedElasticsearchInstanceOfferingOutput`](crate::output::PurchaseReservedElasticsearchInstanceOfferingOutput) with field(s):
    ///   - [`reserved_elasticsearch_instance_id(Option<String>)`](crate::output::PurchaseReservedElasticsearchInstanceOfferingOutput::reserved_elasticsearch_instance_id): <p>Details of the reserved Elasticsearch instance which was purchased.</p>
    ///   - [`reservation_name(Option<String>)`](crate::output::PurchaseReservedElasticsearchInstanceOfferingOutput::reservation_name): <p>The customer-specified identifier used to track this reservation.</p>
    /// - On failure, responds with [`SdkError<PurchaseReservedElasticsearchInstanceOfferingError>`](crate::error::PurchaseReservedElasticsearchInstanceOfferingError)
    pub fn purchase_reserved_elasticsearch_instance_offering(
        &self,
    ) -> fluent_builders::PurchaseReservedElasticsearchInstanceOffering {
        fluent_builders::PurchaseReservedElasticsearchInstanceOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectInboundCrossClusterSearchConnection`](crate::client::fluent_builders::RejectInboundCrossClusterSearchConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cross_cluster_search_connection_id(impl Into<String>)`](crate::client::fluent_builders::RejectInboundCrossClusterSearchConnection::cross_cluster_search_connection_id) / [`set_cross_cluster_search_connection_id(Option<String>)`](crate::client::fluent_builders::RejectInboundCrossClusterSearchConnection::set_cross_cluster_search_connection_id): <p>The id of the inbound connection that you want to reject.</p>
    /// - On success, responds with [`RejectInboundCrossClusterSearchConnectionOutput`](crate::output::RejectInboundCrossClusterSearchConnectionOutput) with field(s):
    ///   - [`cross_cluster_search_connection(Option<InboundCrossClusterSearchConnection>)`](crate::output::RejectInboundCrossClusterSearchConnectionOutput::cross_cluster_search_connection): <p>Specifies the <code><code>InboundCrossClusterSearchConnection</code></code> of rejected inbound connection. </p>
    /// - On failure, responds with [`SdkError<RejectInboundCrossClusterSearchConnectionError>`](crate::error::RejectInboundCrossClusterSearchConnectionError)
    pub fn reject_inbound_cross_cluster_search_connection(
        &self,
    ) -> fluent_builders::RejectInboundCrossClusterSearchConnection {
        fluent_builders::RejectInboundCrossClusterSearchConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTags`](crate::client::fluent_builders::RemoveTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::RemoveTags::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::RemoveTags::set_arn): <p>Specifies the <code>ARN</code> for the Elasticsearch domain from which you want to delete the specified tags.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::RemoveTags::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTags::set_tag_keys): <p>Specifies the <code>TagKey</code> list which you want to remove from the Elasticsearch domain.</p>
    /// - On success, responds with [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)

    /// - On failure, responds with [`SdkError<RemoveTagsError>`](crate::error::RemoveTagsError)
    pub fn remove_tags(&self) -> fluent_builders::RemoveTags {
        fluent_builders::RemoveTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartElasticsearchServiceSoftwareUpdate`](crate::client::fluent_builders::StartElasticsearchServiceSoftwareUpdate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::StartElasticsearchServiceSoftwareUpdate::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::StartElasticsearchServiceSoftwareUpdate::set_domain_name): <p>The name of the domain that you want to update to the latest service software.</p>
    /// - On success, responds with [`StartElasticsearchServiceSoftwareUpdateOutput`](crate::output::StartElasticsearchServiceSoftwareUpdateOutput) with field(s):
    ///   - [`service_software_options(Option<ServiceSoftwareOptions>)`](crate::output::StartElasticsearchServiceSoftwareUpdateOutput::service_software_options): <p>The current status of the Elasticsearch service software update.</p>
    /// - On failure, responds with [`SdkError<StartElasticsearchServiceSoftwareUpdateError>`](crate::error::StartElasticsearchServiceSoftwareUpdateError)
    pub fn start_elasticsearch_service_software_update(
        &self,
    ) -> fluent_builders::StartElasticsearchServiceSoftwareUpdate {
        fluent_builders::StartElasticsearchServiceSoftwareUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateElasticsearchDomainConfig`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_domain_name): <p>The name of the Elasticsearch domain that you are updating. </p>
    ///   - [`elasticsearch_cluster_config(ElasticsearchClusterConfig)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::elasticsearch_cluster_config) / [`set_elasticsearch_cluster_config(Option<ElasticsearchClusterConfig>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_elasticsearch_cluster_config): <p>The type and number of instances to instantiate for the domain cluster.</p>
    ///   - [`ebs_options(EbsOptions)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::ebs_options) / [`set_ebs_options(Option<EbsOptions>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_ebs_options): <p>Specify the type and size of the EBS volume that you want to use. </p>
    ///   - [`snapshot_options(SnapshotOptions)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::snapshot_options) / [`set_snapshot_options(Option<SnapshotOptions>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_snapshot_options): <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
    ///   - [`vpc_options(VpcOptions)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::vpc_options) / [`set_vpc_options(Option<VpcOptions>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_vpc_options): <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
    ///   - [`cognito_options(CognitoOptions)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::cognito_options) / [`set_cognito_options(Option<CognitoOptions>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_cognito_options): <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
    ///   - [`advanced_options(HashMap<String, String>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::advanced_options) / [`set_advanced_options(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_advanced_options): <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
    ///   - [`access_policies(impl Into<String>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::access_policies) / [`set_access_policies(Option<String>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_access_policies): <p>IAM access policy as a JSON-formatted string.</p>
    ///   - [`log_publishing_options(HashMap<LogType, LogPublishingOption>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::log_publishing_options) / [`set_log_publishing_options(Option<HashMap<LogType, LogPublishingOption>>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_log_publishing_options): <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
    ///   - [`domain_endpoint_options(DomainEndpointOptions)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::domain_endpoint_options) / [`set_domain_endpoint_options(Option<DomainEndpointOptions>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_domain_endpoint_options): <p>Options to specify configuration that will be applied to the domain endpoint.</p>
    ///   - [`advanced_security_options(AdvancedSecurityOptionsInput)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::advanced_security_options) / [`set_advanced_security_options(Option<AdvancedSecurityOptionsInput>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_advanced_security_options): <p>Specifies advanced security options.</p>
    ///   - [`node_to_node_encryption_options(NodeToNodeEncryptionOptions)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::node_to_node_encryption_options) / [`set_node_to_node_encryption_options(Option<NodeToNodeEncryptionOptions>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_node_to_node_encryption_options): <p>Specifies the NodeToNodeEncryptionOptions.</p>
    ///   - [`encryption_at_rest_options(EncryptionAtRestOptions)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::encryption_at_rest_options) / [`set_encryption_at_rest_options(Option<EncryptionAtRestOptions>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_encryption_at_rest_options): <p>Specifies the Encryption At Rest Options.</p>
    ///   - [`auto_tune_options(AutoTuneOptions)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::auto_tune_options) / [`set_auto_tune_options(Option<AutoTuneOptions>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_auto_tune_options): <p>Specifies Auto-Tune options.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig::set_dry_run): <p> This flag, when set to True, specifies whether the <code>UpdateElasticsearchDomain</code> request should return the results of validation checks without actually applying the change. This flag, when set to True, specifies the deployment mechanism through which the update shall be applied on the domain. This will not actually perform the Update. </p>
    /// - On success, responds with [`UpdateElasticsearchDomainConfigOutput`](crate::output::UpdateElasticsearchDomainConfigOutput) with field(s):
    ///   - [`domain_config(Option<ElasticsearchDomainConfig>)`](crate::output::UpdateElasticsearchDomainConfigOutput::domain_config): <p>The status of the updated Elasticsearch domain. </p>
    ///   - [`dry_run_results(Option<DryRunResults>)`](crate::output::UpdateElasticsearchDomainConfigOutput::dry_run_results): <p>Contains result of DryRun. </p>
    /// - On failure, responds with [`SdkError<UpdateElasticsearchDomainConfigError>`](crate::error::UpdateElasticsearchDomainConfigError)
    pub fn update_elasticsearch_domain_config(
        &self,
    ) -> fluent_builders::UpdateElasticsearchDomainConfig {
        fluent_builders::UpdateElasticsearchDomainConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePackage`](crate::client::fluent_builders::UpdatePackage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`package_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePackage::package_id) / [`set_package_id(Option<String>)`](crate::client::fluent_builders::UpdatePackage::set_package_id): <p>Unique identifier for the package.</p>
    ///   - [`package_source(PackageSource)`](crate::client::fluent_builders::UpdatePackage::package_source) / [`set_package_source(Option<PackageSource>)`](crate::client::fluent_builders::UpdatePackage::set_package_source): <p>The S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code></p>
    ///   - [`package_description(impl Into<String>)`](crate::client::fluent_builders::UpdatePackage::package_description) / [`set_package_description(Option<String>)`](crate::client::fluent_builders::UpdatePackage::set_package_description): <p>New description of the package.</p>
    ///   - [`commit_message(impl Into<String>)`](crate::client::fluent_builders::UpdatePackage::commit_message) / [`set_commit_message(Option<String>)`](crate::client::fluent_builders::UpdatePackage::set_commit_message): <p>An info message for the new version which will be shown as part of <code>GetPackageVersionHistoryResponse</code>.</p>
    /// - On success, responds with [`UpdatePackageOutput`](crate::output::UpdatePackageOutput) with field(s):
    ///   - [`package_details(Option<PackageDetails>)`](crate::output::UpdatePackageOutput::package_details): <p>Information about the package <code>PackageDetails</code>.</p>
    /// - On failure, responds with [`SdkError<UpdatePackageError>`](crate::error::UpdatePackageError)
    pub fn update_package(&self) -> fluent_builders::UpdatePackage {
        fluent_builders::UpdatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpgradeElasticsearchDomain`](crate::client::fluent_builders::UpgradeElasticsearchDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpgradeElasticsearchDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpgradeElasticsearchDomain::set_domain_name): <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    ///   - [`target_version(impl Into<String>)`](crate::client::fluent_builders::UpgradeElasticsearchDomain::target_version) / [`set_target_version(Option<String>)`](crate::client::fluent_builders::UpgradeElasticsearchDomain::set_target_version): <p>The version of Elasticsearch that you intend to upgrade the domain to.</p>
    ///   - [`perform_check_only(bool)`](crate::client::fluent_builders::UpgradeElasticsearchDomain::perform_check_only) / [`set_perform_check_only(Option<bool>)`](crate::client::fluent_builders::UpgradeElasticsearchDomain::set_perform_check_only): <p> This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not actually perform the Upgrade. </p>
    /// - On success, responds with [`UpgradeElasticsearchDomainOutput`](crate::output::UpgradeElasticsearchDomainOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::UpgradeElasticsearchDomainOutput::domain_name): <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    ///   - [`target_version(Option<String>)`](crate::output::UpgradeElasticsearchDomainOutput::target_version): <p>The version of Elasticsearch that you intend to upgrade the domain to.</p>
    ///   - [`perform_check_only(Option<bool>)`](crate::output::UpgradeElasticsearchDomainOutput::perform_check_only): <p> This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not actually perform the Upgrade. </p>
    ///   - [`change_progress_details(Option<ChangeProgressDetails>)`](crate::output::UpgradeElasticsearchDomainOutput::change_progress_details): <p>Specifies change details of the domain configuration change.</p>
    /// - On failure, responds with [`SdkError<UpgradeElasticsearchDomainError>`](crate::error::UpgradeElasticsearchDomainError)
    pub fn upgrade_elasticsearch_domain(&self) -> fluent_builders::UpgradeElasticsearchDomain {
        fluent_builders::UpgradeElasticsearchDomain::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptInboundCrossClusterSearchConnection`.
    ///
    /// <p>Allows the destination domain owner to accept an inbound cross-cluster search connection request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptInboundCrossClusterSearchConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::accept_inbound_cross_cluster_search_connection_input::Builder,
    }
    impl AcceptInboundCrossClusterSearchConnection {
        /// Creates a new `AcceptInboundCrossClusterSearchConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptInboundCrossClusterSearchConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AcceptInboundCrossClusterSearchConnectionError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The id of the inbound connection that you want to accept.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cross_cluster_search_connection_id(input.into());
            self
        }
        /// <p>The id of the inbound connection that you want to accept.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_cluster_search_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTags`.
    ///
    /// <p>Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An Elasticsearch domain may have up to 10 tags. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging" target="_blank"> Tagging Amazon Elasticsearch Service Domains for more information.</a></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_tags_input::Builder,
    }
    impl AddTags {
        /// Creates a new `AddTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Specify the <code>ARN</code> for which you want to add the tags.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> Specify the <code>ARN</code> for which you want to add the tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p> List of <code>Tag</code> that need to be added for the Elasticsearch domain. </p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p> List of <code>Tag</code> that need to be added for the Elasticsearch domain. </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociatePackage`.
    ///
    /// <p>Associates a package with an Amazon ES domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociatePackage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_package_input::Builder,
    }
    impl AssociatePackage {
        /// Creates a new `AssociatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociatePackageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>Name of the domain that you want to associate the package with.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>Name of the domain that you want to associate the package with.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelElasticsearchServiceSoftwareUpdate`.
    ///
    /// <p>Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the <code>PENDING_UPDATE</code> state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelElasticsearchServiceSoftwareUpdate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_elasticsearch_service_software_update_input::Builder,
    }
    impl CancelElasticsearchServiceSoftwareUpdate {
        /// Creates a new `CancelElasticsearchServiceSoftwareUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelElasticsearchServiceSoftwareUpdateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CancelElasticsearchServiceSoftwareUpdateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to stop the latest service software update on.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to stop the latest service software update on.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateElasticsearchDomain`.
    ///
    /// <p>Creates a new Elasticsearch domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateElasticsearchDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_elasticsearch_domain_input::Builder,
    }
    impl CreateElasticsearchDomain {
        /// Creates a new `CreateElasticsearchDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateElasticsearchDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateElasticsearchDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Elasticsearch domain that you are creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the Elasticsearch domain that you are creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>String of format X.Y to specify version for the Elasticsearch domain eg. "1.5" or "2.3". For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>
        pub fn elasticsearch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.elasticsearch_version(input.into());
            self
        }
        /// <p>String of format X.Y to specify version for the Elasticsearch domain eg. "1.5" or "2.3". For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>
        pub fn set_elasticsearch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_version(input);
            self
        }
        /// <p>Configuration options for an Elasticsearch domain. Specifies the instance type and number of instances in the domain cluster. </p>
        pub fn elasticsearch_cluster_config(
            mut self,
            input: crate::model::ElasticsearchClusterConfig,
        ) -> Self {
            self.inner = self.inner.elasticsearch_cluster_config(input);
            self
        }
        /// <p>Configuration options for an Elasticsearch domain. Specifies the instance type and number of instances in the domain cluster. </p>
        pub fn set_elasticsearch_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchClusterConfig>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_cluster_config(input);
            self
        }
        /// <p>Options to enable, disable and specify the type and size of EBS storage volumes. </p>
        pub fn ebs_options(mut self, input: crate::model::EbsOptions) -> Self {
            self.inner = self.inner.ebs_options(input);
            self
        }
        /// <p>Options to enable, disable and specify the type and size of EBS storage volumes. </p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptions>,
        ) -> Self {
            self.inner = self.inner.set_ebs_options(input);
            self
        }
        /// <p> IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policies(input.into());
            self
        }
        /// <p> IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policies(input);
            self
        }
        /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours. </p>
        pub fn snapshot_options(mut self, input: crate::model::SnapshotOptions) -> Self {
            self.inner = self.inner.snapshot_options(input);
            self
        }
        /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours. </p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
        pub fn vpc_options(mut self, input: crate::model::VpcOptions) -> Self {
            self.inner = self.inner.vpc_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcOptions>,
        ) -> Self {
            self.inner = self.inner.set_vpc_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn cognito_options(mut self, input: crate::model::CognitoOptions) -> Self {
            self.inner = self.inner.cognito_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.inner = self.inner.set_cognito_options(input);
            self
        }
        /// <p>Specifies the Encryption At Rest Options.</p>
        pub fn encryption_at_rest_options(
            mut self,
            input: crate::model::EncryptionAtRestOptions,
        ) -> Self {
            self.inner = self.inner.encryption_at_rest_options(input);
            self
        }
        /// <p>Specifies the Encryption At Rest Options.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.inner = self.inner.set_encryption_at_rest_options(input);
            self
        }
        /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            input: crate::model::NodeToNodeEncryptionOptions,
        ) -> Self {
            self.inner = self.inner.node_to_node_encryption_options(input);
            self
        }
        /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.inner = self.inner.set_node_to_node_encryption_options(input);
            self
        }
        /// Adds a key-value pair to `AdvancedOptions`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p> Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.advanced_options(k.into(), v.into());
            self
        }
        /// <p> Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_advanced_options(input);
            self
        }
        /// Adds a key-value pair to `LogPublishingOptions`.
        ///
        /// To override the contents of this collection use [`set_log_publishing_options`](Self::set_log_publishing_options).
        ///
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
        pub fn log_publishing_options(
            mut self,
            k: crate::model::LogType,
            v: crate::model::LogPublishingOption,
        ) -> Self {
            self.inner = self.inner.log_publishing_options(k, v);
            self
        }
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.inner = self.inner.set_log_publishing_options(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptions,
        ) -> Self {
            self.inner = self.inner.domain_endpoint_options(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.inner = self.inner.set_domain_endpoint_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn advanced_security_options(
            mut self,
            input: crate::model::AdvancedSecurityOptionsInput,
        ) -> Self {
            self.inner = self.inner.advanced_security_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        ) -> Self {
            self.inner = self.inner.set_advanced_security_options(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn auto_tune_options(mut self, input: crate::model::AutoTuneOptionsInput) -> Self {
            self.inner = self.inner.auto_tune_options(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptionsInput>,
        ) -> Self {
            self.inner = self.inner.set_auto_tune_options(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of <code>Tag</code> added during domain creation.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p>A list of <code>Tag</code> added during domain creation.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOutboundCrossClusterSearchConnection`.
    ///
    /// <p>Creates a new cross-cluster search connection from a source domain to a destination domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOutboundCrossClusterSearchConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_outbound_cross_cluster_search_connection_input::Builder,
    }
    impl CreateOutboundCrossClusterSearchConnection {
        /// Creates a new `CreateOutboundCrossClusterSearchConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOutboundCrossClusterSearchConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateOutboundCrossClusterSearchConnectionError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
        pub fn source_domain_info(mut self, input: crate::model::DomainInformation) -> Self {
            self.inner = self.inner.source_domain_info(input);
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
        pub fn set_source_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformation>,
        ) -> Self {
            self.inner = self.inner.set_source_domain_info(input);
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
        pub fn destination_domain_info(mut self, input: crate::model::DomainInformation) -> Self {
            self.inner = self.inner.destination_domain_info(input);
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
        pub fn set_destination_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformation>,
        ) -> Self {
            self.inner = self.inner.set_destination_domain_info(input);
            self
        }
        /// <p>Specifies the connection alias that will be used by the customer for this connection.</p>
        pub fn connection_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_alias(input.into());
            self
        }
        /// <p>Specifies the connection alias that will be used by the customer for this connection.</p>
        pub fn set_connection_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePackage`.
    ///
    /// <p>Create a package for use with Amazon ES domains.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePackage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_package_input::Builder,
    }
    impl CreatePackage {
        /// Creates a new `CreatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePackageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique identifier for the package.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_name(input.into());
            self
        }
        /// <p>Unique identifier for the package.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_name(input);
            self
        }
        /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.inner = self.inner.package_type(input);
            self
        }
        /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.inner = self.inner.set_package_type(input);
            self
        }
        /// <p>Description of the package.</p>
        pub fn package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_description(input.into());
            self
        }
        /// <p>Description of the package.</p>
        pub fn set_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_description(input);
            self
        }
        /// <p>The customer S3 location <code>PackageSource</code> for importing the package.</p>
        pub fn package_source(mut self, input: crate::model::PackageSource) -> Self {
            self.inner = self.inner.package_source(input);
            self
        }
        /// <p>The customer S3 location <code>PackageSource</code> for importing the package.</p>
        pub fn set_package_source(
            mut self,
            input: std::option::Option<crate::model::PackageSource>,
        ) -> Self {
            self.inner = self.inner.set_package_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteElasticsearchDomain`.
    ///
    /// <p>Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot be recovered.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteElasticsearchDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_elasticsearch_domain_input::Builder,
    }
    impl DeleteElasticsearchDomain {
        /// Creates a new `DeleteElasticsearchDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteElasticsearchDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteElasticsearchDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Elasticsearch domain that you want to permanently delete.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the Elasticsearch domain that you want to permanently delete.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteElasticsearchServiceRole`.
    ///
    /// <p>Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before deleting the role. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr" target="_blank">Deleting Elasticsearch Service Role</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteElasticsearchServiceRole {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_elasticsearch_service_role_input::Builder,
    }
    impl DeleteElasticsearchServiceRole {
        /// Creates a new `DeleteElasticsearchServiceRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteElasticsearchServiceRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteElasticsearchServiceRoleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteInboundCrossClusterSearchConnection`.
    ///
    /// <p>Allows the destination domain owner to delete an existing inbound cross-cluster search connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInboundCrossClusterSearchConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_inbound_cross_cluster_search_connection_input::Builder,
    }
    impl DeleteInboundCrossClusterSearchConnection {
        /// Creates a new `DeleteInboundCrossClusterSearchConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInboundCrossClusterSearchConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteInboundCrossClusterSearchConnectionError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The id of the inbound connection that you want to permanently delete.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cross_cluster_search_connection_id(input.into());
            self
        }
        /// <p>The id of the inbound connection that you want to permanently delete.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_cluster_search_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOutboundCrossClusterSearchConnection`.
    ///
    /// <p>Allows the source domain owner to delete an existing outbound cross-cluster search connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOutboundCrossClusterSearchConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_outbound_cross_cluster_search_connection_input::Builder,
    }
    impl DeleteOutboundCrossClusterSearchConnection {
        /// Creates a new `DeleteOutboundCrossClusterSearchConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOutboundCrossClusterSearchConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteOutboundCrossClusterSearchConnectionError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The id of the outbound connection that you want to permanently delete.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cross_cluster_search_connection_id(input.into());
            self
        }
        /// <p>The id of the outbound connection that you want to permanently delete.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_cluster_search_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePackage`.
    ///
    /// <p>Delete the package.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePackage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_package_input::Builder,
    }
    impl DeletePackage {
        /// Creates a new `DeletePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePackageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this value.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this value.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomainAutoTunes`.
    ///
    /// <p>Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type, description, severity, and scheduled date.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomainAutoTunes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_domain_auto_tunes_input::Builder,
    }
    impl DescribeDomainAutoTunes {
        /// Creates a new `DescribeDomainAutoTunes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainAutoTunesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainAutoTunesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDomainAutoTunesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDomainAutoTunesPaginator {
            crate::paginator::DescribeDomainAutoTunesPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the domain name for which you want Auto-Tune action details.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>Specifies the domain name for which you want Auto-Tune action details.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomainChangeProgress`.
    ///
    /// <p>Returns information about the current blue/green deployment happening on a domain, including a change ID, status, and progress stages.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomainChangeProgress {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_domain_change_progress_input::Builder,
    }
    impl DescribeDomainChangeProgress {
        /// Creates a new `DescribeDomainChangeProgress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainChangeProgressOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainChangeProgressError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain you want to get the progress information about.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain you want to get the progress information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
        pub fn change_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_id(input.into());
            self
        }
        /// <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
        pub fn set_change_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeElasticsearchDomain`.
    ///
    /// <p>Returns domain configuration information about the specified Elasticsearch domain, including the domain ID, domain endpoint, and domain ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeElasticsearchDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_elasticsearch_domain_input::Builder,
    }
    impl DescribeElasticsearchDomain {
        /// Creates a new `DescribeElasticsearchDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeElasticsearchDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeElasticsearchDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Elasticsearch domain for which you want information.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the Elasticsearch domain for which you want information.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeElasticsearchDomainConfig`.
    ///
    /// <p>Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation date, update version, and update date for cluster options.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeElasticsearchDomainConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_elasticsearch_domain_config_input::Builder,
    }
    impl DescribeElasticsearchDomainConfig {
        /// Creates a new `DescribeElasticsearchDomainConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeElasticsearchDomainConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeElasticsearchDomainConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Elasticsearch domain that you want to get information about.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The Elasticsearch domain that you want to get information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeElasticsearchDomains`.
    ///
    /// <p>Returns domain configuration information about the specified Elasticsearch domains, including the domain ID, domain endpoint, and domain ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeElasticsearchDomains {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_elasticsearch_domains_input::Builder,
    }
    impl DescribeElasticsearchDomains {
        /// Creates a new `DescribeElasticsearchDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeElasticsearchDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeElasticsearchDomainsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DomainNames`.
        ///
        /// To override the contents of this collection use [`set_domain_names`](Self::set_domain_names).
        ///
        /// <p>The Elasticsearch domains for which you want information.</p>
        pub fn domain_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_names(input.into());
            self
        }
        /// <p>The Elasticsearch domains for which you want information.</p>
        pub fn set_domain_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_domain_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeElasticsearchInstanceTypeLimits`.
    ///
    /// <p> Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain, specify the <code> <code>DomainName</code> </code> to know what Limits are supported for modifying. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeElasticsearchInstanceTypeLimits {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_elasticsearch_instance_type_limits_input::Builder,
    }
    impl DescribeElasticsearchInstanceTypeLimits {
        /// Creates a new `DescribeElasticsearchInstanceTypeLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeElasticsearchInstanceTypeLimitsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeElasticsearchInstanceTypeLimitsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for Elasticsearch <code> <code>Limits</code> </code> for existing domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p> DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for Elasticsearch <code> <code>Limits</code> </code> for existing domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> The instance type for an Elasticsearch cluster for which Elasticsearch <code> <code>Limits</code> </code> are needed. </p>
        pub fn instance_type(mut self, input: crate::model::EsPartitionInstanceType) -> Self {
            self.inner = self.inner.instance_type(input);
            self
        }
        /// <p> The instance type for an Elasticsearch cluster for which Elasticsearch <code> <code>Limits</code> </code> are needed. </p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::EsPartitionInstanceType>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p> Version of Elasticsearch for which <code> <code>Limits</code> </code> are needed. </p>
        pub fn elasticsearch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.elasticsearch_version(input.into());
            self
        }
        /// <p> Version of Elasticsearch for which <code> <code>Limits</code> </code> are needed. </p>
        pub fn set_elasticsearch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInboundCrossClusterSearchConnections`.
    ///
    /// <p>Lists all the inbound cross-cluster search connections for a destination domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInboundCrossClusterSearchConnections {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_inbound_cross_cluster_search_connections_input::Builder,
    }
    impl DescribeInboundCrossClusterSearchConnections {
        /// Creates a new `DescribeInboundCrossClusterSearchConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInboundCrossClusterSearchConnectionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeInboundCrossClusterSearchConnectionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeInboundCrossClusterSearchConnectionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeInboundCrossClusterSearchConnectionsPaginator {
            crate::paginator::DescribeInboundCrossClusterSearchConnectionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p> A list of filters used to match properties for inbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
        /// <ul>
        /// <li>cross-cluster-search-connection-id</li>
        /// <li>source-domain-info.domain-name</li>
        /// <li>source-domain-info.owner-id</li>
        /// <li>source-domain-info.region</li>
        /// <li>destination-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p> A list of filters used to match properties for inbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
        /// <ul>
        /// <li>cross-cluster-search-connection-id</li>
        /// <li>source-domain-info.domain-name</li>
        /// <li>source-domain-info.owner-id</li>
        /// <li>source-domain-info.region</li>
        /// <li>destination-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOutboundCrossClusterSearchConnections`.
    ///
    /// <p>Lists all the outbound cross-cluster search connections for a source domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOutboundCrossClusterSearchConnections {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_outbound_cross_cluster_search_connections_input::Builder,
    }
    impl DescribeOutboundCrossClusterSearchConnections {
        /// Creates a new `DescribeOutboundCrossClusterSearchConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOutboundCrossClusterSearchConnectionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeOutboundCrossClusterSearchConnectionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOutboundCrossClusterSearchConnectionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeOutboundCrossClusterSearchConnectionsPaginator {
            crate::paginator::DescribeOutboundCrossClusterSearchConnectionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p> A list of filters used to match properties for outbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
        /// <ul>
        /// <li>cross-cluster-search-connection-id</li>
        /// <li>destination-domain-info.domain-name</li>
        /// <li>destination-domain-info.owner-id</li>
        /// <li>destination-domain-info.region</li>
        /// <li>source-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p> A list of filters used to match properties for outbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
        /// <ul>
        /// <li>cross-cluster-search-connection-id</li>
        /// <li>destination-domain-info.domain-name</li>
        /// <li>destination-domain-info.owner-id</li>
        /// <li>destination-domain-info.region</li>
        /// <li>source-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePackages`.
    ///
    /// <p>Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results, and pagination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePackages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_packages_input::Builder,
    }
    impl DescribePackages {
        /// Creates a new `DescribePackages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePackagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePackagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePackagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribePackagesPaginator {
            crate::paginator::DescribePackagesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values.</p>
        pub fn filters(mut self, input: crate::model::DescribePackagesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DescribePackagesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedElasticsearchInstanceOfferings`.
    ///
    /// <p>Lists available reserved Elasticsearch instance offerings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReservedElasticsearchInstanceOfferings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_reserved_elasticsearch_instance_offerings_input::Builder,
    }
    impl DescribeReservedElasticsearchInstanceOfferings {
        /// Creates a new `DescribeReservedElasticsearchInstanceOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedElasticsearchInstanceOfferingsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReservedElasticsearchInstanceOfferingsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReservedElasticsearchInstanceOfferingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReservedElasticsearchInstanceOfferingsPaginator {
            crate::paginator::DescribeReservedElasticsearchInstanceOfferingsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
        pub fn reserved_elasticsearch_instance_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .reserved_elasticsearch_instance_offering_id(input.into());
            self
        }
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
        pub fn set_reserved_elasticsearch_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_reserved_elasticsearch_instance_offering_id(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedElasticsearchInstances`.
    ///
    /// <p>Returns information about reserved Elasticsearch instances for this account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReservedElasticsearchInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_reserved_elasticsearch_instances_input::Builder,
    }
    impl DescribeReservedElasticsearchInstances {
        /// Creates a new `DescribeReservedElasticsearchInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedElasticsearchInstancesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReservedElasticsearchInstancesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReservedElasticsearchInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReservedElasticsearchInstancesPaginator {
            crate::paginator::DescribeReservedElasticsearchInstancesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved Elasticsearch instance ID.</p>
        pub fn reserved_elasticsearch_instance_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.reserved_elasticsearch_instance_id(input.into());
            self
        }
        /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved Elasticsearch instance ID.</p>
        pub fn set_reserved_elasticsearch_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_elasticsearch_instance_id(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DissociatePackage`.
    ///
    /// <p>Dissociates a package from the Amazon ES domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DissociatePackage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::dissociate_package_input::Builder,
    }
    impl DissociatePackage {
        /// Creates a new `DissociatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DissociatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::DissociatePackageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>Name of the domain that you want to associate the package with.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>Name of the domain that you want to associate the package with.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCompatibleElasticsearchVersions`.
    ///
    /// <p> Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a <code> <code>DomainName</code> </code> to get all upgrade compatible Elasticsearch versions for that specific domain. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCompatibleElasticsearchVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_compatible_elasticsearch_versions_input::Builder,
    }
    impl GetCompatibleElasticsearchVersions {
        /// Creates a new `GetCompatibleElasticsearchVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCompatibleElasticsearchVersionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetCompatibleElasticsearchVersionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPackageVersionHistory`.
    ///
    /// <p>Returns a list of versions of the package, along with their creation time and commit message.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPackageVersionHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_package_version_history_input::Builder,
    }
    impl GetPackageVersionHistory {
        /// Creates a new `GetPackageVersionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPackageVersionHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPackageVersionHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetPackageVersionHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetPackageVersionHistoryPaginator {
            crate::paginator::GetPackageVersionHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>Returns an audit history of versions of the package.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>Returns an audit history of versions of the package.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>Limits results to a maximum number of versions.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits results to a maximum number of versions.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUpgradeHistory`.
    ///
    /// <p>Retrieves the complete history of the last 10 upgrades that were performed on the domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUpgradeHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_upgrade_history_input::Builder,
    }
    impl GetUpgradeHistory {
        /// Creates a new `GetUpgradeHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUpgradeHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUpgradeHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetUpgradeHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetUpgradeHistoryPaginator {
            crate::paginator::GetUpgradeHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUpgradeStatus`.
    ///
    /// <p>Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUpgradeStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_upgrade_status_input::Builder,
    }
    impl GetUpgradeStatus {
        /// Creates a new `GetUpgradeStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUpgradeStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUpgradeStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainNames`.
    ///
    /// <p>Returns the name of all Elasticsearch domains owned by the current user's account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomainNames {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_domain_names_input::Builder,
    }
    impl ListDomainNames {
        /// Creates a new `ListDomainNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainNamesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.inner = self.inner.engine_type(input);
            self
        }
        /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.inner = self.inner.set_engine_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainsForPackage`.
    ///
    /// <p>Lists all Amazon ES domains associated with the package.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomainsForPackage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_domains_for_package_input::Builder,
    }
    impl ListDomainsForPackage {
        /// Creates a new `ListDomainsForPackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsForPackageOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsForPackageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDomainsForPackagePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDomainsForPackagePaginator {
            crate::paginator::ListDomainsForPackagePaginator::new(self.handle, self.inner)
        }
        /// <p>The package for which to list domains.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>The package for which to list domains.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>Limits results to a maximum number of domains.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits results to a maximum number of domains.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListElasticsearchInstanceTypes`.
    ///
    /// <p>List all Elasticsearch instance types that are supported for given ElasticsearchVersion</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListElasticsearchInstanceTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_elasticsearch_instance_types_input::Builder,
    }
    impl ListElasticsearchInstanceTypes {
        /// Creates a new `ListElasticsearchInstanceTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListElasticsearchInstanceTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListElasticsearchInstanceTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListElasticsearchInstanceTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListElasticsearchInstanceTypesPaginator {
            crate::paginator::ListElasticsearchInstanceTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>Version of Elasticsearch for which list of supported elasticsearch instance types are needed. </p>
        pub fn elasticsearch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.elasticsearch_version(input.into());
            self
        }
        /// <p>Version of Elasticsearch for which list of supported elasticsearch instance types are needed. </p>
        pub fn set_elasticsearch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_version(input);
            self
        }
        /// <p>DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for list of available Elasticsearch instance types when modifying existing domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for list of available Elasticsearch instance types when modifying existing domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont be honored. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont be honored. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListElasticsearchVersions`.
    ///
    /// <p>List all supported Elasticsearch versions</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListElasticsearchVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_elasticsearch_versions_input::Builder,
    }
    impl ListElasticsearchVersions {
        /// Creates a new `ListElasticsearchVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListElasticsearchVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListElasticsearchVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListElasticsearchVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListElasticsearchVersionsPaginator {
            crate::paginator::ListElasticsearchVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p> Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackagesForDomain`.
    ///
    /// <p>Lists all packages associated with the Amazon ES domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPackagesForDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_packages_for_domain_input::Builder,
    }
    impl ListPackagesForDomain {
        /// Creates a new `ListPackagesForDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackagesForDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackagesForDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPackagesForDomainPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPackagesForDomainPaginator {
            crate::paginator::ListPackagesForDomainPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the domain for which you want to list associated packages.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain for which you want to list associated packages.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Returns all tags for the given Elasticsearch domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl ListTags {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PurchaseReservedElasticsearchInstanceOffering`.
    ///
    /// <p>Allows you to purchase reserved Elasticsearch instances.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PurchaseReservedElasticsearchInstanceOffering {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::purchase_reserved_elasticsearch_instance_offering_input::Builder,
    }
    impl PurchaseReservedElasticsearchInstanceOffering {
        /// Creates a new `PurchaseReservedElasticsearchInstanceOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PurchaseReservedElasticsearchInstanceOfferingOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PurchaseReservedElasticsearchInstanceOfferingError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the reserved Elasticsearch instance offering to purchase.</p>
        pub fn reserved_elasticsearch_instance_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .reserved_elasticsearch_instance_offering_id(input.into());
            self
        }
        /// <p>The ID of the reserved Elasticsearch instance offering to purchase.</p>
        pub fn set_reserved_elasticsearch_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_reserved_elasticsearch_instance_offering_id(input);
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p>
        pub fn reservation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reservation_name(input.into());
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p>
        pub fn set_reservation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reservation_name(input);
            self
        }
        /// <p>The number of Elasticsearch instances to reserve.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.inner = self.inner.instance_count(input);
            self
        }
        /// <p>The number of Elasticsearch instances to reserve.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_instance_count(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectInboundCrossClusterSearchConnection`.
    ///
    /// <p>Allows the destination domain owner to reject an inbound cross-cluster search connection request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectInboundCrossClusterSearchConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reject_inbound_cross_cluster_search_connection_input::Builder,
    }
    impl RejectInboundCrossClusterSearchConnection {
        /// Creates a new `RejectInboundCrossClusterSearchConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectInboundCrossClusterSearchConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RejectInboundCrossClusterSearchConnectionError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The id of the inbound connection that you want to reject.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cross_cluster_search_connection_id(input.into());
            self
        }
        /// <p>The id of the inbound connection that you want to reject.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_cluster_search_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTags`.
    ///
    /// <p>Removes the specified set of tags from the specified Elasticsearch domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_tags_input::Builder,
    }
    impl RemoveTags {
        /// Creates a new `RemoveTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <code>ARN</code> for the Elasticsearch domain from which you want to delete the specified tags.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>Specifies the <code>ARN</code> for the Elasticsearch domain from which you want to delete the specified tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Specifies the <code>TagKey</code> list which you want to remove from the Elasticsearch domain.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Specifies the <code>TagKey</code> list which you want to remove from the Elasticsearch domain.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartElasticsearchServiceSoftwareUpdate`.
    ///
    /// <p>Schedules a service software update for an Amazon ES domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartElasticsearchServiceSoftwareUpdate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_elasticsearch_service_software_update_input::Builder,
    }
    impl StartElasticsearchServiceSoftwareUpdate {
        /// Creates a new `StartElasticsearchServiceSoftwareUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartElasticsearchServiceSoftwareUpdateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::StartElasticsearchServiceSoftwareUpdateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to update to the latest service software.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to update to the latest service software.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateElasticsearchDomainConfig`.
    ///
    /// <p>Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type and the number of instances. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateElasticsearchDomainConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_elasticsearch_domain_config_input::Builder,
    }
    impl UpdateElasticsearchDomainConfig {
        /// Creates a new `UpdateElasticsearchDomainConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateElasticsearchDomainConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateElasticsearchDomainConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Elasticsearch domain that you are updating. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the Elasticsearch domain that you are updating. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The type and number of instances to instantiate for the domain cluster.</p>
        pub fn elasticsearch_cluster_config(
            mut self,
            input: crate::model::ElasticsearchClusterConfig,
        ) -> Self {
            self.inner = self.inner.elasticsearch_cluster_config(input);
            self
        }
        /// <p>The type and number of instances to instantiate for the domain cluster.</p>
        pub fn set_elasticsearch_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchClusterConfig>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_cluster_config(input);
            self
        }
        /// <p>Specify the type and size of the EBS volume that you want to use. </p>
        pub fn ebs_options(mut self, input: crate::model::EbsOptions) -> Self {
            self.inner = self.inner.ebs_options(input);
            self
        }
        /// <p>Specify the type and size of the EBS volume that you want to use. </p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptions>,
        ) -> Self {
            self.inner = self.inner.set_ebs_options(input);
            self
        }
        /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
        pub fn snapshot_options(mut self, input: crate::model::SnapshotOptions) -> Self {
            self.inner = self.inner.snapshot_options(input);
            self
        }
        /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
        pub fn vpc_options(mut self, input: crate::model::VpcOptions) -> Self {
            self.inner = self.inner.vpc_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcOptions>,
        ) -> Self {
            self.inner = self.inner.set_vpc_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn cognito_options(mut self, input: crate::model::CognitoOptions) -> Self {
            self.inner = self.inner.cognito_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.inner = self.inner.set_cognito_options(input);
            self
        }
        /// Adds a key-value pair to `AdvancedOptions`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.advanced_options(k.into(), v.into());
            self
        }
        /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_advanced_options(input);
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policies(input.into());
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policies(input);
            self
        }
        /// Adds a key-value pair to `LogPublishingOptions`.
        ///
        /// To override the contents of this collection use [`set_log_publishing_options`](Self::set_log_publishing_options).
        ///
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
        pub fn log_publishing_options(
            mut self,
            k: crate::model::LogType,
            v: crate::model::LogPublishingOption,
        ) -> Self {
            self.inner = self.inner.log_publishing_options(k, v);
            self
        }
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.inner = self.inner.set_log_publishing_options(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptions,
        ) -> Self {
            self.inner = self.inner.domain_endpoint_options(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.inner = self.inner.set_domain_endpoint_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn advanced_security_options(
            mut self,
            input: crate::model::AdvancedSecurityOptionsInput,
        ) -> Self {
            self.inner = self.inner.advanced_security_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        ) -> Self {
            self.inner = self.inner.set_advanced_security_options(input);
            self
        }
        /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            input: crate::model::NodeToNodeEncryptionOptions,
        ) -> Self {
            self.inner = self.inner.node_to_node_encryption_options(input);
            self
        }
        /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.inner = self.inner.set_node_to_node_encryption_options(input);
            self
        }
        /// <p>Specifies the Encryption At Rest Options.</p>
        pub fn encryption_at_rest_options(
            mut self,
            input: crate::model::EncryptionAtRestOptions,
        ) -> Self {
            self.inner = self.inner.encryption_at_rest_options(input);
            self
        }
        /// <p>Specifies the Encryption At Rest Options.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.inner = self.inner.set_encryption_at_rest_options(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn auto_tune_options(mut self, input: crate::model::AutoTuneOptions) -> Self {
            self.inner = self.inner.auto_tune_options(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptions>,
        ) -> Self {
            self.inner = self.inner.set_auto_tune_options(input);
            self
        }
        /// <p> This flag, when set to True, specifies whether the <code>UpdateElasticsearchDomain</code> request should return the results of validation checks without actually applying the change. This flag, when set to True, specifies the deployment mechanism through which the update shall be applied on the domain. This will not actually perform the Update. </p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p> This flag, when set to True, specifies whether the <code>UpdateElasticsearchDomain</code> request should return the results of validation checks without actually applying the change. This flag, when set to True, specifies the deployment mechanism through which the update shall be applied on the domain. This will not actually perform the Update. </p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePackage`.
    ///
    /// <p>Updates a package for use with Amazon ES domains.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePackage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_package_input::Builder,
    }
    impl UpdatePackage {
        /// Creates a new `UpdatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePackageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique identifier for the package.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>Unique identifier for the package.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>The S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code></p>
        pub fn package_source(mut self, input: crate::model::PackageSource) -> Self {
            self.inner = self.inner.package_source(input);
            self
        }
        /// <p>The S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code></p>
        pub fn set_package_source(
            mut self,
            input: std::option::Option<crate::model::PackageSource>,
        ) -> Self {
            self.inner = self.inner.set_package_source(input);
            self
        }
        /// <p>New description of the package.</p>
        pub fn package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_description(input.into());
            self
        }
        /// <p>New description of the package.</p>
        pub fn set_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_description(input);
            self
        }
        /// <p>An info message for the new version which will be shown as part of <code>GetPackageVersionHistoryResponse</code>.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(input.into());
            self
        }
        /// <p>An info message for the new version which will be shown as part of <code>GetPackageVersionHistoryResponse</code>.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpgradeElasticsearchDomain`.
    ///
    /// <p>Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpgradeElasticsearchDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::upgrade_elasticsearch_domain_input::Builder,
    }
    impl UpgradeElasticsearchDomain {
        /// Creates a new `UpgradeElasticsearchDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpgradeElasticsearchDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UpgradeElasticsearchDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The version of Elasticsearch that you intend to upgrade the domain to.</p>
        pub fn target_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_version(input.into());
            self
        }
        /// <p>The version of Elasticsearch that you intend to upgrade the domain to.</p>
        pub fn set_target_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_version(input);
            self
        }
        /// <p> This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not actually perform the Upgrade. </p>
        pub fn perform_check_only(mut self, input: bool) -> Self {
            self.inner = self.inner.perform_check_only(input);
            self
        }
        /// <p> This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not actually perform the Upgrade. </p>
        pub fn set_perform_check_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_perform_check_only(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
