// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptInboundCrossClusterSearchConnectionInput`](crate::input::AcceptInboundCrossClusterSearchConnectionInput)
pub mod accept_inbound_cross_cluster_search_connection_input {
    /// A builder for [`AcceptInboundCrossClusterSearchConnectionInput`](crate::input::AcceptInboundCrossClusterSearchConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_cluster_search_connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The id of the inbound connection that you want to accept.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = Some(input.into());
            self
        }
        /// <p>The id of the inbound connection that you want to accept.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptInboundCrossClusterSearchConnectionInput`](crate::input::AcceptInboundCrossClusterSearchConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptInboundCrossClusterSearchConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::AcceptInboundCrossClusterSearchConnectionInput {
                    cross_cluster_search_connection_id: self.cross_cluster_search_connection_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type AcceptInboundCrossClusterSearchConnectionInputOperationOutputAlias =
    crate::operation::AcceptInboundCrossClusterSearchConnection;
#[doc(hidden)]
pub type AcceptInboundCrossClusterSearchConnectionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AcceptInboundCrossClusterSearchConnectionInput {
    /// Consumes the builder and constructs an Operation<[`AcceptInboundCrossClusterSearchConnection`](crate::operation::AcceptInboundCrossClusterSearchConnection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptInboundCrossClusterSearchConnection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AcceptInboundCrossClusterSearchConnectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.cross_cluster_search_connection_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "cross_cluster_search_connection_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let cross_cluster_search_connection_id =
                    aws_smithy_http::label::fmt_string(input_1, false);
                if cross_cluster_search_connection_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "cross_cluster_search_connection_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/ccs/inboundConnection/{CrossClusterSearchConnectionId}/accept",
                    CrossClusterSearchConnectionId = cross_cluster_search_connection_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AcceptInboundCrossClusterSearchConnectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptInboundCrossClusterSearchConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptInboundCrossClusterSearchConnection",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AcceptInboundCrossClusterSearchConnectionInput`](crate::input::AcceptInboundCrossClusterSearchConnectionInput)
    pub fn builder() -> crate::input::accept_inbound_cross_cluster_search_connection_input::Builder
    {
        crate::input::accept_inbound_cross_cluster_search_connection_input::Builder::default()
    }
}

/// See [`AddTagsInput`](crate::input::AddTagsInput)
pub mod add_tags_input {
    /// A builder for [`AddTagsInput`](crate::input::AddTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p> Specify the <code>ARN</code> for which you want to add the tags.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> Specify the <code>ARN</code> for which you want to add the tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p> List of <code>Tag</code> that need to be added for the Elasticsearch domain. </p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input);
            self.tag_list = Some(v);
            self
        }
        /// <p> List of <code>Tag</code> that need to be added for the Elasticsearch domain. </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsInput`](crate::input::AddTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::AddTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::AddTagsInput {
                arn: self.arn,
                tag_list: self.tag_list,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsInputOperationOutputAlias = crate::operation::AddTags;
#[doc(hidden)]
pub type AddTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddTagsInput {
    /// Consumes the builder and constructs an Operation<[`AddTags`](crate::operation::AddTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/tags").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_tags(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::AddTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "AddTags",
                    "elasticsearchservice",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
}

/// See [`AssociatePackageInput`](crate::input::AssociatePackageInput)
pub mod associate_package_input {
    /// A builder for [`AssociatePackageInput`](crate::input::AssociatePackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>Name of the domain that you want to associate the package with.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>Name of the domain that you want to associate the package with.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatePackageInput`](crate::input::AssociatePackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociatePackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociatePackageInput {
                package_id: self.package_id,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociatePackageInputOperationOutputAlias = crate::operation::AssociatePackage;
#[doc(hidden)]
pub type AssociatePackageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociatePackageInput {
    /// Consumes the builder and constructs an Operation<[`AssociatePackage`](crate::operation::AssociatePackage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociatePackage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociatePackageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.package_id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let package_id = aws_smithy_http::label::fmt_string(input_2, false);
                if package_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_3 = &_input.domain_name;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_3, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/packages/associate/{PackageID}/{DomainName}",
                    PackageID = package_id,
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociatePackageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociatePackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociatePackage",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociatePackageInput`](crate::input::AssociatePackageInput)
    pub fn builder() -> crate::input::associate_package_input::Builder {
        crate::input::associate_package_input::Builder::default()
    }
}

/// See [`CancelElasticsearchServiceSoftwareUpdateInput`](crate::input::CancelElasticsearchServiceSoftwareUpdateInput)
pub mod cancel_elasticsearch_service_software_update_input {
    /// A builder for [`CancelElasticsearchServiceSoftwareUpdateInput`](crate::input::CancelElasticsearchServiceSoftwareUpdateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to stop the latest service software update on.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to stop the latest service software update on.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelElasticsearchServiceSoftwareUpdateInput`](crate::input::CancelElasticsearchServiceSoftwareUpdateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelElasticsearchServiceSoftwareUpdateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::CancelElasticsearchServiceSoftwareUpdateInput {
                    domain_name: self.domain_name,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type CancelElasticsearchServiceSoftwareUpdateInputOperationOutputAlias =
    crate::operation::CancelElasticsearchServiceSoftwareUpdate;
#[doc(hidden)]
pub type CancelElasticsearchServiceSoftwareUpdateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CancelElasticsearchServiceSoftwareUpdateInput {
    /// Consumes the builder and constructs an Operation<[`CancelElasticsearchServiceSoftwareUpdate`](crate::operation::CancelElasticsearchServiceSoftwareUpdate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelElasticsearchServiceSoftwareUpdate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelElasticsearchServiceSoftwareUpdateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/serviceSoftwareUpdate/cancel")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelElasticsearchServiceSoftwareUpdateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_elasticsearch_service_software_update(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelElasticsearchServiceSoftwareUpdate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelElasticsearchServiceSoftwareUpdate",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelElasticsearchServiceSoftwareUpdateInput`](crate::input::CancelElasticsearchServiceSoftwareUpdateInput)
    pub fn builder() -> crate::input::cancel_elasticsearch_service_software_update_input::Builder {
        crate::input::cancel_elasticsearch_service_software_update_input::Builder::default()
    }
}

/// See [`CreateElasticsearchDomainInput`](crate::input::CreateElasticsearchDomainInput)
pub mod create_elasticsearch_domain_input {
    /// A builder for [`CreateElasticsearchDomainInput`](crate::input::CreateElasticsearchDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) elasticsearch_version: std::option::Option<std::string::String>,
        pub(crate) elasticsearch_cluster_config:
            std::option::Option<crate::model::ElasticsearchClusterConfig>,
        pub(crate) ebs_options: std::option::Option<crate::model::EbsOptions>,
        pub(crate) access_policies: std::option::Option<std::string::String>,
        pub(crate) snapshot_options: std::option::Option<crate::model::SnapshotOptions>,
        pub(crate) vpc_options: std::option::Option<crate::model::VpcOptions>,
        pub(crate) cognito_options: std::option::Option<crate::model::CognitoOptions>,
        pub(crate) encryption_at_rest_options:
            std::option::Option<crate::model::EncryptionAtRestOptions>,
        pub(crate) node_to_node_encryption_options:
            std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        pub(crate) advanced_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) log_publishing_options: std::option::Option<
            std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
        >,
        pub(crate) domain_endpoint_options:
            std::option::Option<crate::model::DomainEndpointOptions>,
        pub(crate) advanced_security_options:
            std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        pub(crate) auto_tune_options: std::option::Option<crate::model::AutoTuneOptionsInput>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the Elasticsearch domain that you are creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the Elasticsearch domain that you are creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>String of format X.Y to specify version for the Elasticsearch domain eg. "1.5" or "2.3". For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>
        pub fn elasticsearch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.elasticsearch_version = Some(input.into());
            self
        }
        /// <p>String of format X.Y to specify version for the Elasticsearch domain eg. "1.5" or "2.3". For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>
        pub fn set_elasticsearch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elasticsearch_version = input;
            self
        }
        /// <p>Configuration options for an Elasticsearch domain. Specifies the instance type and number of instances in the domain cluster. </p>
        pub fn elasticsearch_cluster_config(
            mut self,
            input: crate::model::ElasticsearchClusterConfig,
        ) -> Self {
            self.elasticsearch_cluster_config = Some(input);
            self
        }
        /// <p>Configuration options for an Elasticsearch domain. Specifies the instance type and number of instances in the domain cluster. </p>
        pub fn set_elasticsearch_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchClusterConfig>,
        ) -> Self {
            self.elasticsearch_cluster_config = input;
            self
        }
        /// <p>Options to enable, disable and specify the type and size of EBS storage volumes. </p>
        pub fn ebs_options(mut self, input: crate::model::EbsOptions) -> Self {
            self.ebs_options = Some(input);
            self
        }
        /// <p>Options to enable, disable and specify the type and size of EBS storage volumes. </p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptions>,
        ) -> Self {
            self.ebs_options = input;
            self
        }
        /// <p> IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policies = Some(input.into());
            self
        }
        /// <p> IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policies = input;
            self
        }
        /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours. </p>
        pub fn snapshot_options(mut self, input: crate::model::SnapshotOptions) -> Self {
            self.snapshot_options = Some(input);
            self
        }
        /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours. </p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.snapshot_options = input;
            self
        }
        /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
        pub fn vpc_options(mut self, input: crate::model::VpcOptions) -> Self {
            self.vpc_options = Some(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcOptions>,
        ) -> Self {
            self.vpc_options = input;
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn cognito_options(mut self, input: crate::model::CognitoOptions) -> Self {
            self.cognito_options = Some(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.cognito_options = input;
            self
        }
        /// <p>Specifies the Encryption At Rest Options.</p>
        pub fn encryption_at_rest_options(
            mut self,
            input: crate::model::EncryptionAtRestOptions,
        ) -> Self {
            self.encryption_at_rest_options = Some(input);
            self
        }
        /// <p>Specifies the Encryption At Rest Options.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.encryption_at_rest_options = input;
            self
        }
        /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            input: crate::model::NodeToNodeEncryptionOptions,
        ) -> Self {
            self.node_to_node_encryption_options = Some(input);
            self
        }
        /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.node_to_node_encryption_options = input;
            self
        }
        /// Adds a key-value pair to `advanced_options`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p> Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.advanced_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.advanced_options = Some(hash_map);
            self
        }
        /// <p> Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.advanced_options = input;
            self
        }
        /// Adds a key-value pair to `log_publishing_options`.
        ///
        /// To override the contents of this collection use [`set_log_publishing_options`](Self::set_log_publishing_options).
        ///
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
        pub fn log_publishing_options(
            mut self,
            k: crate::model::LogType,
            v: crate::model::LogPublishingOption,
        ) -> Self {
            let mut hash_map = self.log_publishing_options.unwrap_or_default();
            hash_map.insert(k, v);
            self.log_publishing_options = Some(hash_map);
            self
        }
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.log_publishing_options = input;
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptions,
        ) -> Self {
            self.domain_endpoint_options = Some(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.domain_endpoint_options = input;
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn advanced_security_options(
            mut self,
            input: crate::model::AdvancedSecurityOptionsInput,
        ) -> Self {
            self.advanced_security_options = Some(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        ) -> Self {
            self.advanced_security_options = input;
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn auto_tune_options(mut self, input: crate::model::AutoTuneOptionsInput) -> Self {
            self.auto_tune_options = Some(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptionsInput>,
        ) -> Self {
            self.auto_tune_options = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of <code>Tag</code> added during domain creation.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input);
            self.tag_list = Some(v);
            self
        }
        /// <p>A list of <code>Tag</code> added during domain creation.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateElasticsearchDomainInput`](crate::input::CreateElasticsearchDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateElasticsearchDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateElasticsearchDomainInput {
                domain_name: self.domain_name,
                elasticsearch_version: self.elasticsearch_version,
                elasticsearch_cluster_config: self.elasticsearch_cluster_config,
                ebs_options: self.ebs_options,
                access_policies: self.access_policies,
                snapshot_options: self.snapshot_options,
                vpc_options: self.vpc_options,
                cognito_options: self.cognito_options,
                encryption_at_rest_options: self.encryption_at_rest_options,
                node_to_node_encryption_options: self.node_to_node_encryption_options,
                advanced_options: self.advanced_options,
                log_publishing_options: self.log_publishing_options,
                domain_endpoint_options: self.domain_endpoint_options,
                advanced_security_options: self.advanced_security_options,
                auto_tune_options: self.auto_tune_options,
                tag_list: self.tag_list,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateElasticsearchDomainInputOperationOutputAlias =
    crate::operation::CreateElasticsearchDomain;
#[doc(hidden)]
pub type CreateElasticsearchDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateElasticsearchDomainInput {
    /// Consumes the builder and constructs an Operation<[`CreateElasticsearchDomain`](crate::operation::CreateElasticsearchDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateElasticsearchDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateElasticsearchDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/domain").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateElasticsearchDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_elasticsearch_domain(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateElasticsearchDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateElasticsearchDomain",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateElasticsearchDomainInput`](crate::input::CreateElasticsearchDomainInput)
    pub fn builder() -> crate::input::create_elasticsearch_domain_input::Builder {
        crate::input::create_elasticsearch_domain_input::Builder::default()
    }
}

/// See [`CreateOutboundCrossClusterSearchConnectionInput`](crate::input::CreateOutboundCrossClusterSearchConnectionInput)
pub mod create_outbound_cross_cluster_search_connection_input {
    /// A builder for [`CreateOutboundCrossClusterSearchConnectionInput`](crate::input::CreateOutboundCrossClusterSearchConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_domain_info: std::option::Option<crate::model::DomainInformation>,
        pub(crate) destination_domain_info: std::option::Option<crate::model::DomainInformation>,
        pub(crate) connection_alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
        pub fn source_domain_info(mut self, input: crate::model::DomainInformation) -> Self {
            self.source_domain_info = Some(input);
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
        pub fn set_source_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformation>,
        ) -> Self {
            self.source_domain_info = input;
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
        pub fn destination_domain_info(mut self, input: crate::model::DomainInformation) -> Self {
            self.destination_domain_info = Some(input);
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
        pub fn set_destination_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformation>,
        ) -> Self {
            self.destination_domain_info = input;
            self
        }
        /// <p>Specifies the connection alias that will be used by the customer for this connection.</p>
        pub fn connection_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_alias = Some(input.into());
            self
        }
        /// <p>Specifies the connection alias that will be used by the customer for this connection.</p>
        pub fn set_connection_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_alias = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOutboundCrossClusterSearchConnectionInput`](crate::input::CreateOutboundCrossClusterSearchConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOutboundCrossClusterSearchConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::CreateOutboundCrossClusterSearchConnectionInput {
                    source_domain_info: self.source_domain_info,
                    destination_domain_info: self.destination_domain_info,
                    connection_alias: self.connection_alias,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type CreateOutboundCrossClusterSearchConnectionInputOperationOutputAlias =
    crate::operation::CreateOutboundCrossClusterSearchConnection;
#[doc(hidden)]
pub type CreateOutboundCrossClusterSearchConnectionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateOutboundCrossClusterSearchConnectionInput {
    /// Consumes the builder and constructs an Operation<[`CreateOutboundCrossClusterSearchConnection`](crate::operation::CreateOutboundCrossClusterSearchConnection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOutboundCrossClusterSearchConnection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateOutboundCrossClusterSearchConnectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/ccs/outboundConnection")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateOutboundCrossClusterSearchConnectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_outbound_cross_cluster_search_connection(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOutboundCrossClusterSearchConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOutboundCrossClusterSearchConnection",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateOutboundCrossClusterSearchConnectionInput`](crate::input::CreateOutboundCrossClusterSearchConnectionInput)
    pub fn builder() -> crate::input::create_outbound_cross_cluster_search_connection_input::Builder
    {
        crate::input::create_outbound_cross_cluster_search_connection_input::Builder::default()
    }
}

/// See [`CreatePackageInput`](crate::input::CreatePackageInput)
pub mod create_package_input {
    /// A builder for [`CreatePackageInput`](crate::input::CreatePackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) package_type: std::option::Option<crate::model::PackageType>,
        pub(crate) package_description: std::option::Option<std::string::String>,
        pub(crate) package_source: std::option::Option<crate::model::PackageSource>,
    }
    impl Builder {
        /// <p>Unique identifier for the package.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>Unique identifier for the package.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.package_type = Some(input);
            self
        }
        /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.package_type = input;
            self
        }
        /// <p>Description of the package.</p>
        pub fn package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_description = Some(input.into());
            self
        }
        /// <p>Description of the package.</p>
        pub fn set_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_description = input;
            self
        }
        /// <p>The customer S3 location <code>PackageSource</code> for importing the package.</p>
        pub fn package_source(mut self, input: crate::model::PackageSource) -> Self {
            self.package_source = Some(input);
            self
        }
        /// <p>The customer S3 location <code>PackageSource</code> for importing the package.</p>
        pub fn set_package_source(
            mut self,
            input: std::option::Option<crate::model::PackageSource>,
        ) -> Self {
            self.package_source = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePackageInput`](crate::input::CreatePackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePackageInput {
                package_name: self.package_name,
                package_type: self.package_type,
                package_description: self.package_description,
                package_source: self.package_source,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePackageInputOperationOutputAlias = crate::operation::CreatePackage;
#[doc(hidden)]
pub type CreatePackageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePackageInput {
    /// Consumes the builder and constructs an Operation<[`CreatePackage`](crate::operation::CreatePackage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePackage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePackageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/packages").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePackageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_package(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePackage",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePackageInput`](crate::input::CreatePackageInput)
    pub fn builder() -> crate::input::create_package_input::Builder {
        crate::input::create_package_input::Builder::default()
    }
}

/// See [`DeleteElasticsearchDomainInput`](crate::input::DeleteElasticsearchDomainInput)
pub mod delete_elasticsearch_domain_input {
    /// A builder for [`DeleteElasticsearchDomainInput`](crate::input::DeleteElasticsearchDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Elasticsearch domain that you want to permanently delete.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the Elasticsearch domain that you want to permanently delete.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteElasticsearchDomainInput`](crate::input::DeleteElasticsearchDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteElasticsearchDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteElasticsearchDomainInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteElasticsearchDomainInputOperationOutputAlias =
    crate::operation::DeleteElasticsearchDomain;
#[doc(hidden)]
pub type DeleteElasticsearchDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteElasticsearchDomainInput {
    /// Consumes the builder and constructs an Operation<[`DeleteElasticsearchDomain`](crate::operation::DeleteElasticsearchDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteElasticsearchDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteElasticsearchDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.domain_name;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_4, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/domain/{DomainName}",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteElasticsearchDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteElasticsearchDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteElasticsearchDomain",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteElasticsearchDomainInput`](crate::input::DeleteElasticsearchDomainInput)
    pub fn builder() -> crate::input::delete_elasticsearch_domain_input::Builder {
        crate::input::delete_elasticsearch_domain_input::Builder::default()
    }
}

/// See [`DeleteElasticsearchServiceRoleInput`](crate::input::DeleteElasticsearchServiceRoleInput)
pub mod delete_elasticsearch_service_role_input {
    /// A builder for [`DeleteElasticsearchServiceRoleInput`](crate::input::DeleteElasticsearchServiceRoleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteElasticsearchServiceRoleInput`](crate::input::DeleteElasticsearchServiceRoleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteElasticsearchServiceRoleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteElasticsearchServiceRoleInput {})
        }
    }
}
#[doc(hidden)]
pub type DeleteElasticsearchServiceRoleInputOperationOutputAlias =
    crate::operation::DeleteElasticsearchServiceRole;
#[doc(hidden)]
pub type DeleteElasticsearchServiceRoleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteElasticsearchServiceRoleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteElasticsearchServiceRole`](crate::operation::DeleteElasticsearchServiceRole)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteElasticsearchServiceRole,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteElasticsearchServiceRoleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/role").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteElasticsearchServiceRoleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteElasticsearchServiceRole::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteElasticsearchServiceRole",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteElasticsearchServiceRoleInput`](crate::input::DeleteElasticsearchServiceRoleInput)
    pub fn builder() -> crate::input::delete_elasticsearch_service_role_input::Builder {
        crate::input::delete_elasticsearch_service_role_input::Builder::default()
    }
}

/// See [`DeleteInboundCrossClusterSearchConnectionInput`](crate::input::DeleteInboundCrossClusterSearchConnectionInput)
pub mod delete_inbound_cross_cluster_search_connection_input {
    /// A builder for [`DeleteInboundCrossClusterSearchConnectionInput`](crate::input::DeleteInboundCrossClusterSearchConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_cluster_search_connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The id of the inbound connection that you want to permanently delete.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = Some(input.into());
            self
        }
        /// <p>The id of the inbound connection that you want to permanently delete.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInboundCrossClusterSearchConnectionInput`](crate::input::DeleteInboundCrossClusterSearchConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInboundCrossClusterSearchConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DeleteInboundCrossClusterSearchConnectionInput {
                    cross_cluster_search_connection_id: self.cross_cluster_search_connection_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DeleteInboundCrossClusterSearchConnectionInputOperationOutputAlias =
    crate::operation::DeleteInboundCrossClusterSearchConnection;
#[doc(hidden)]
pub type DeleteInboundCrossClusterSearchConnectionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInboundCrossClusterSearchConnectionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInboundCrossClusterSearchConnection`](crate::operation::DeleteInboundCrossClusterSearchConnection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInboundCrossClusterSearchConnection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteInboundCrossClusterSearchConnectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.cross_cluster_search_connection_id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "cross_cluster_search_connection_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let cross_cluster_search_connection_id =
                    aws_smithy_http::label::fmt_string(input_5, false);
                if cross_cluster_search_connection_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "cross_cluster_search_connection_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/ccs/inboundConnection/{CrossClusterSearchConnectionId}",
                    CrossClusterSearchConnectionId = cross_cluster_search_connection_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteInboundCrossClusterSearchConnectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInboundCrossClusterSearchConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInboundCrossClusterSearchConnection",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteInboundCrossClusterSearchConnectionInput`](crate::input::DeleteInboundCrossClusterSearchConnectionInput)
    pub fn builder() -> crate::input::delete_inbound_cross_cluster_search_connection_input::Builder
    {
        crate::input::delete_inbound_cross_cluster_search_connection_input::Builder::default()
    }
}

/// See [`DeleteOutboundCrossClusterSearchConnectionInput`](crate::input::DeleteOutboundCrossClusterSearchConnectionInput)
pub mod delete_outbound_cross_cluster_search_connection_input {
    /// A builder for [`DeleteOutboundCrossClusterSearchConnectionInput`](crate::input::DeleteOutboundCrossClusterSearchConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_cluster_search_connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The id of the outbound connection that you want to permanently delete.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = Some(input.into());
            self
        }
        /// <p>The id of the outbound connection that you want to permanently delete.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOutboundCrossClusterSearchConnectionInput`](crate::input::DeleteOutboundCrossClusterSearchConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOutboundCrossClusterSearchConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DeleteOutboundCrossClusterSearchConnectionInput {
                    cross_cluster_search_connection_id: self.cross_cluster_search_connection_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DeleteOutboundCrossClusterSearchConnectionInputOperationOutputAlias =
    crate::operation::DeleteOutboundCrossClusterSearchConnection;
#[doc(hidden)]
pub type DeleteOutboundCrossClusterSearchConnectionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteOutboundCrossClusterSearchConnectionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOutboundCrossClusterSearchConnection`](crate::operation::DeleteOutboundCrossClusterSearchConnection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOutboundCrossClusterSearchConnection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteOutboundCrossClusterSearchConnectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.cross_cluster_search_connection_id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "cross_cluster_search_connection_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let cross_cluster_search_connection_id =
                    aws_smithy_http::label::fmt_string(input_6, false);
                if cross_cluster_search_connection_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "cross_cluster_search_connection_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/ccs/outboundConnection/{CrossClusterSearchConnectionId}",
                    CrossClusterSearchConnectionId = cross_cluster_search_connection_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteOutboundCrossClusterSearchConnectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOutboundCrossClusterSearchConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOutboundCrossClusterSearchConnection",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteOutboundCrossClusterSearchConnectionInput`](crate::input::DeleteOutboundCrossClusterSearchConnectionInput)
    pub fn builder() -> crate::input::delete_outbound_cross_cluster_search_connection_input::Builder
    {
        crate::input::delete_outbound_cross_cluster_search_connection_input::Builder::default()
    }
}

/// See [`DeletePackageInput`](crate::input::DeletePackageInput)
pub mod delete_package_input {
    /// A builder for [`DeletePackageInput`](crate::input::DeletePackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this value.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this value.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePackageInput`](crate::input::DeletePackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePackageInput {
                package_id: self.package_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePackageInputOperationOutputAlias = crate::operation::DeletePackage;
#[doc(hidden)]
pub type DeletePackageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePackageInput {
    /// Consumes the builder and constructs an Operation<[`DeletePackage`](crate::operation::DeletePackage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePackage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePackageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.package_id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let package_id = aws_smithy_http::label::fmt_string(input_7, false);
                if package_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/packages/{PackageID}",
                    PackageID = package_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePackageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePackage",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePackageInput`](crate::input::DeletePackageInput)
    pub fn builder() -> crate::input::delete_package_input::Builder {
        crate::input::delete_package_input::Builder::default()
    }
}

/// See [`DescribeDomainAutoTunesInput`](crate::input::DescribeDomainAutoTunesInput)
pub mod describe_domain_auto_tunes_input {
    /// A builder for [`DescribeDomainAutoTunesInput`](crate::input::DescribeDomainAutoTunesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the domain name for which you want Auto-Tune action details.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>Specifies the domain name for which you want Auto-Tune action details.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainAutoTunesInput`](crate::input::DescribeDomainAutoTunesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDomainAutoTunesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDomainAutoTunesInput {
                domain_name: self.domain_name,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDomainAutoTunesInputOperationOutputAlias =
    crate::operation::DescribeDomainAutoTunes;
#[doc(hidden)]
pub type DescribeDomainAutoTunesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDomainAutoTunesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDomainAutoTunes`](crate::operation::DescribeDomainAutoTunes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDomainAutoTunes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDomainAutoTunesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.domain_name;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_8, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/domain/{DomainName}/autoTunes",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDomainAutoTunesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_domain_auto_tunes(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDomainAutoTunes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDomainAutoTunes",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDomainAutoTunesInput`](crate::input::DescribeDomainAutoTunesInput)
    pub fn builder() -> crate::input::describe_domain_auto_tunes_input::Builder {
        crate::input::describe_domain_auto_tunes_input::Builder::default()
    }
}

/// See [`DescribeDomainChangeProgressInput`](crate::input::DescribeDomainChangeProgressInput)
pub mod describe_domain_change_progress_input {
    /// A builder for [`DescribeDomainChangeProgressInput`](crate::input::DescribeDomainChangeProgressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) change_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain you want to get the progress information about.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain you want to get the progress information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
        pub fn change_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_id = Some(input.into());
            self
        }
        /// <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
        pub fn set_change_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainChangeProgressInput`](crate::input::DescribeDomainChangeProgressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDomainChangeProgressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDomainChangeProgressInput {
                domain_name: self.domain_name,
                change_id: self.change_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDomainChangeProgressInputOperationOutputAlias =
    crate::operation::DescribeDomainChangeProgress;
#[doc(hidden)]
pub type DescribeDomainChangeProgressInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDomainChangeProgressInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDomainChangeProgress`](crate::operation::DescribeDomainChangeProgress)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDomainChangeProgress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDomainChangeProgressInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.domain_name;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_9, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/domain/{DomainName}/progress",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeDomainChangeProgressInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_10) = &_input.change_id {
                    query.push_kv("changeid", &aws_smithy_http::query::fmt_string(&inner_10));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDomainChangeProgressInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDomainChangeProgress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDomainChangeProgress",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDomainChangeProgressInput`](crate::input::DescribeDomainChangeProgressInput)
    pub fn builder() -> crate::input::describe_domain_change_progress_input::Builder {
        crate::input::describe_domain_change_progress_input::Builder::default()
    }
}

/// See [`DescribeElasticsearchDomainInput`](crate::input::DescribeElasticsearchDomainInput)
pub mod describe_elasticsearch_domain_input {
    /// A builder for [`DescribeElasticsearchDomainInput`](crate::input::DescribeElasticsearchDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Elasticsearch domain for which you want information.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the Elasticsearch domain for which you want information.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeElasticsearchDomainInput`](crate::input::DescribeElasticsearchDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeElasticsearchDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeElasticsearchDomainInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeElasticsearchDomainInputOperationOutputAlias =
    crate::operation::DescribeElasticsearchDomain;
#[doc(hidden)]
pub type DescribeElasticsearchDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeElasticsearchDomainInput {
    /// Consumes the builder and constructs an Operation<[`DescribeElasticsearchDomain`](crate::operation::DescribeElasticsearchDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeElasticsearchDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeElasticsearchDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.domain_name;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_11, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/domain/{DomainName}",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeElasticsearchDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeElasticsearchDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeElasticsearchDomain",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeElasticsearchDomainInput`](crate::input::DescribeElasticsearchDomainInput)
    pub fn builder() -> crate::input::describe_elasticsearch_domain_input::Builder {
        crate::input::describe_elasticsearch_domain_input::Builder::default()
    }
}

/// See [`DescribeElasticsearchDomainConfigInput`](crate::input::DescribeElasticsearchDomainConfigInput)
pub mod describe_elasticsearch_domain_config_input {
    /// A builder for [`DescribeElasticsearchDomainConfigInput`](crate::input::DescribeElasticsearchDomainConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Elasticsearch domain that you want to get information about.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The Elasticsearch domain that you want to get information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeElasticsearchDomainConfigInput`](crate::input::DescribeElasticsearchDomainConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeElasticsearchDomainConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeElasticsearchDomainConfigInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeElasticsearchDomainConfigInputOperationOutputAlias =
    crate::operation::DescribeElasticsearchDomainConfig;
#[doc(hidden)]
pub type DescribeElasticsearchDomainConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeElasticsearchDomainConfigInput {
    /// Consumes the builder and constructs an Operation<[`DescribeElasticsearchDomainConfig`](crate::operation::DescribeElasticsearchDomainConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeElasticsearchDomainConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeElasticsearchDomainConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.domain_name;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_12, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/domain/{DomainName}/config",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeElasticsearchDomainConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeElasticsearchDomainConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeElasticsearchDomainConfig",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeElasticsearchDomainConfigInput`](crate::input::DescribeElasticsearchDomainConfigInput)
    pub fn builder() -> crate::input::describe_elasticsearch_domain_config_input::Builder {
        crate::input::describe_elasticsearch_domain_config_input::Builder::default()
    }
}

/// See [`DescribeElasticsearchDomainsInput`](crate::input::DescribeElasticsearchDomainsInput)
pub mod describe_elasticsearch_domains_input {
    /// A builder for [`DescribeElasticsearchDomainsInput`](crate::input::DescribeElasticsearchDomainsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `domain_names`.
        ///
        /// To override the contents of this collection use [`set_domain_names`](Self::set_domain_names).
        ///
        /// <p>The Elasticsearch domains for which you want information.</p>
        pub fn domain_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.domain_names.unwrap_or_default();
            v.push(input.into());
            self.domain_names = Some(v);
            self
        }
        /// <p>The Elasticsearch domains for which you want information.</p>
        pub fn set_domain_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.domain_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeElasticsearchDomainsInput`](crate::input::DescribeElasticsearchDomainsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeElasticsearchDomainsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeElasticsearchDomainsInput {
                domain_names: self.domain_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeElasticsearchDomainsInputOperationOutputAlias =
    crate::operation::DescribeElasticsearchDomains;
#[doc(hidden)]
pub type DescribeElasticsearchDomainsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeElasticsearchDomainsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeElasticsearchDomains`](crate::operation::DescribeElasticsearchDomains)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeElasticsearchDomains,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeElasticsearchDomainsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/domain-info").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeElasticsearchDomainsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_elasticsearch_domains(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeElasticsearchDomains::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeElasticsearchDomains",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeElasticsearchDomainsInput`](crate::input::DescribeElasticsearchDomainsInput)
    pub fn builder() -> crate::input::describe_elasticsearch_domains_input::Builder {
        crate::input::describe_elasticsearch_domains_input::Builder::default()
    }
}

/// See [`DescribeElasticsearchInstanceTypeLimitsInput`](crate::input::DescribeElasticsearchInstanceTypeLimitsInput)
pub mod describe_elasticsearch_instance_type_limits_input {
    /// A builder for [`DescribeElasticsearchInstanceTypeLimitsInput`](crate::input::DescribeElasticsearchInstanceTypeLimitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<crate::model::EsPartitionInstanceType>,
        pub(crate) elasticsearch_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for Elasticsearch <code> <code>Limits</code> </code> for existing domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p> DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for Elasticsearch <code> <code>Limits</code> </code> for existing domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p> The instance type for an Elasticsearch cluster for which Elasticsearch <code> <code>Limits</code> </code> are needed. </p>
        pub fn instance_type(mut self, input: crate::model::EsPartitionInstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p> The instance type for an Elasticsearch cluster for which Elasticsearch <code> <code>Limits</code> </code> are needed. </p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::EsPartitionInstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p> Version of Elasticsearch for which <code> <code>Limits</code> </code> are needed. </p>
        pub fn elasticsearch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.elasticsearch_version = Some(input.into());
            self
        }
        /// <p> Version of Elasticsearch for which <code> <code>Limits</code> </code> are needed. </p>
        pub fn set_elasticsearch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elasticsearch_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeElasticsearchInstanceTypeLimitsInput`](crate::input::DescribeElasticsearchInstanceTypeLimitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeElasticsearchInstanceTypeLimitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeElasticsearchInstanceTypeLimitsInput {
                domain_name: self.domain_name,
                instance_type: self.instance_type,
                elasticsearch_version: self.elasticsearch_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeElasticsearchInstanceTypeLimitsInputOperationOutputAlias =
    crate::operation::DescribeElasticsearchInstanceTypeLimits;
#[doc(hidden)]
pub type DescribeElasticsearchInstanceTypeLimitsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeElasticsearchInstanceTypeLimitsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeElasticsearchInstanceTypeLimits`](crate::operation::DescribeElasticsearchInstanceTypeLimits)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeElasticsearchInstanceTypeLimits,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeElasticsearchInstanceTypeLimitsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.elasticsearch_version;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "elasticsearch_version",
                        details: "cannot be empty or unset",
                    },
                )?;
                let elasticsearch_version = aws_smithy_http::label::fmt_string(input_13, false);
                if elasticsearch_version.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "elasticsearch_version",
                        details: "cannot be empty or unset",
                    });
                }
                let input_14 = &_input.instance_type;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_type",
                        details: "cannot be empty or unset",
                    },
                )?;
                let instance_type = aws_smithy_http::label::fmt_string(input_14, false);
                if instance_type.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_type",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/instanceTypeLimits/{ElasticsearchVersion}/{InstanceType}",
                    ElasticsearchVersion = elasticsearch_version,
                    InstanceType = instance_type
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeElasticsearchInstanceTypeLimitsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_15) = &_input.domain_name {
                    query.push_kv("domainName", &aws_smithy_http::query::fmt_string(&inner_15));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeElasticsearchInstanceTypeLimitsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeElasticsearchInstanceTypeLimits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeElasticsearchInstanceTypeLimits",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeElasticsearchInstanceTypeLimitsInput`](crate::input::DescribeElasticsearchInstanceTypeLimitsInput)
    pub fn builder() -> crate::input::describe_elasticsearch_instance_type_limits_input::Builder {
        crate::input::describe_elasticsearch_instance_type_limits_input::Builder::default()
    }
}

/// See [`DescribeInboundCrossClusterSearchConnectionsInput`](crate::input::DescribeInboundCrossClusterSearchConnectionsInput)
pub mod describe_inbound_cross_cluster_search_connections_input {
    /// A builder for [`DescribeInboundCrossClusterSearchConnectionsInput`](crate::input::DescribeInboundCrossClusterSearchConnectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p> A list of filters used to match properties for inbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
        /// <ul>
        /// <li>cross-cluster-search-connection-id</li>
        /// <li>source-domain-info.domain-name</li>
        /// <li>source-domain-info.owner-id</li>
        /// <li>source-domain-info.region</li>
        /// <li>destination-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p> A list of filters used to match properties for inbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
        /// <ul>
        /// <li>cross-cluster-search-connection-id</li>
        /// <li>source-domain-info.domain-name</li>
        /// <li>source-domain-info.owner-id</li>
        /// <li>source-domain-info.region</li>
        /// <li>destination-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInboundCrossClusterSearchConnectionsInput`](crate::input::DescribeInboundCrossClusterSearchConnectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInboundCrossClusterSearchConnectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeInboundCrossClusterSearchConnectionsInput {
                    filters: self.filters,
                    max_results: self.max_results.unwrap_or_default(),
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeInboundCrossClusterSearchConnectionsInputOperationOutputAlias =
    crate::operation::DescribeInboundCrossClusterSearchConnections;
#[doc(hidden)]
pub type DescribeInboundCrossClusterSearchConnectionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInboundCrossClusterSearchConnectionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInboundCrossClusterSearchConnections`](crate::operation::DescribeInboundCrossClusterSearchConnections)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInboundCrossClusterSearchConnections,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeInboundCrossClusterSearchConnectionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/ccs/inboundConnection/search")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeInboundCrossClusterSearchConnectionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_inbound_cross_cluster_search_connections(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInboundCrossClusterSearchConnections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInboundCrossClusterSearchConnections",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeInboundCrossClusterSearchConnectionsInput`](crate::input::DescribeInboundCrossClusterSearchConnectionsInput)
    pub fn builder(
    ) -> crate::input::describe_inbound_cross_cluster_search_connections_input::Builder {
        crate::input::describe_inbound_cross_cluster_search_connections_input::Builder::default()
    }
}

/// See [`DescribeOutboundCrossClusterSearchConnectionsInput`](crate::input::DescribeOutboundCrossClusterSearchConnectionsInput)
pub mod describe_outbound_cross_cluster_search_connections_input {
    /// A builder for [`DescribeOutboundCrossClusterSearchConnectionsInput`](crate::input::DescribeOutboundCrossClusterSearchConnectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p> A list of filters used to match properties for outbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
        /// <ul>
        /// <li>cross-cluster-search-connection-id</li>
        /// <li>destination-domain-info.domain-name</li>
        /// <li>destination-domain-info.owner-id</li>
        /// <li>destination-domain-info.region</li>
        /// <li>source-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p> A list of filters used to match properties for outbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
        /// <ul>
        /// <li>cross-cluster-search-connection-id</li>
        /// <li>destination-domain-info.domain-name</li>
        /// <li>destination-domain-info.owner-id</li>
        /// <li>destination-domain-info.region</li>
        /// <li>source-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOutboundCrossClusterSearchConnectionsInput`](crate::input::DescribeOutboundCrossClusterSearchConnectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOutboundCrossClusterSearchConnectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeOutboundCrossClusterSearchConnectionsInput {
                    filters: self.filters,
                    max_results: self.max_results.unwrap_or_default(),
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeOutboundCrossClusterSearchConnectionsInputOperationOutputAlias =
    crate::operation::DescribeOutboundCrossClusterSearchConnections;
#[doc(hidden)]
pub type DescribeOutboundCrossClusterSearchConnectionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOutboundCrossClusterSearchConnectionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOutboundCrossClusterSearchConnections`](crate::operation::DescribeOutboundCrossClusterSearchConnections)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOutboundCrossClusterSearchConnections,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeOutboundCrossClusterSearchConnectionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/ccs/outboundConnection/search")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeOutboundCrossClusterSearchConnectionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_outbound_cross_cluster_search_connections(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOutboundCrossClusterSearchConnections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOutboundCrossClusterSearchConnections",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeOutboundCrossClusterSearchConnectionsInput`](crate::input::DescribeOutboundCrossClusterSearchConnectionsInput)
    pub fn builder(
    ) -> crate::input::describe_outbound_cross_cluster_search_connections_input::Builder {
        crate::input::describe_outbound_cross_cluster_search_connections_input::Builder::default()
    }
}

/// See [`DescribePackagesInput`](crate::input::DescribePackagesInput)
pub mod describe_packages_input {
    /// A builder for [`DescribePackagesInput`](crate::input::DescribePackagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::DescribePackagesFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values.</p>
        pub fn filters(mut self, input: crate::model::DescribePackagesFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DescribePackagesFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackagesInput`](crate::input::DescribePackagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePackagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePackagesInput {
                filters: self.filters,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePackagesInputOperationOutputAlias = crate::operation::DescribePackages;
#[doc(hidden)]
pub type DescribePackagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePackagesInput {
    /// Consumes the builder and constructs an Operation<[`DescribePackages`](crate::operation::DescribePackages)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePackages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribePackagesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/packages/describe").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribePackagesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_packages(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePackages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePackages",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribePackagesInput`](crate::input::DescribePackagesInput)
    pub fn builder() -> crate::input::describe_packages_input::Builder {
        crate::input::describe_packages_input::Builder::default()
    }
}

/// See [`DescribeReservedElasticsearchInstanceOfferingsInput`](crate::input::DescribeReservedElasticsearchInstanceOfferingsInput)
pub mod describe_reserved_elasticsearch_instance_offerings_input {
    /// A builder for [`DescribeReservedElasticsearchInstanceOfferingsInput`](crate::input::DescribeReservedElasticsearchInstanceOfferingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_elasticsearch_instance_offering_id:
            std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
        pub fn reserved_elasticsearch_instance_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_offering_id = Some(input.into());
            self
        }
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
        pub fn set_reserved_elasticsearch_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_offering_id = input;
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedElasticsearchInstanceOfferingsInput`](crate::input::DescribeReservedElasticsearchInstanceOfferingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReservedElasticsearchInstanceOfferingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeReservedElasticsearchInstanceOfferingsInput {
                    reserved_elasticsearch_instance_offering_id: self
                        .reserved_elasticsearch_instance_offering_id,
                    max_results: self.max_results.unwrap_or_default(),
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeReservedElasticsearchInstanceOfferingsInputOperationOutputAlias =
    crate::operation::DescribeReservedElasticsearchInstanceOfferings;
#[doc(hidden)]
pub type DescribeReservedElasticsearchInstanceOfferingsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeReservedElasticsearchInstanceOfferingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReservedElasticsearchInstanceOfferings`](crate::operation::DescribeReservedElasticsearchInstanceOfferings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReservedElasticsearchInstanceOfferings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeReservedElasticsearchInstanceOfferingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/reservedInstanceOfferings")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeReservedElasticsearchInstanceOfferingsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_16) = &_input.reserved_elasticsearch_instance_offering_id {
                    query.push_kv("offeringId", &aws_smithy_http::query::fmt_string(&inner_16));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_17) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_17));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeReservedElasticsearchInstanceOfferingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReservedElasticsearchInstanceOfferings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReservedElasticsearchInstanceOfferings",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeReservedElasticsearchInstanceOfferingsInput`](crate::input::DescribeReservedElasticsearchInstanceOfferingsInput)
    pub fn builder(
    ) -> crate::input::describe_reserved_elasticsearch_instance_offerings_input::Builder {
        crate::input::describe_reserved_elasticsearch_instance_offerings_input::Builder::default()
    }
}

/// See [`DescribeReservedElasticsearchInstancesInput`](crate::input::DescribeReservedElasticsearchInstancesInput)
pub mod describe_reserved_elasticsearch_instances_input {
    /// A builder for [`DescribeReservedElasticsearchInstancesInput`](crate::input::DescribeReservedElasticsearchInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_elasticsearch_instance_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved Elasticsearch instance ID.</p>
        pub fn reserved_elasticsearch_instance_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_id = Some(input.into());
            self
        }
        /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved Elasticsearch instance ID.</p>
        pub fn set_reserved_elasticsearch_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_id = input;
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedElasticsearchInstancesInput`](crate::input::DescribeReservedElasticsearchInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReservedElasticsearchInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReservedElasticsearchInstancesInput {
                reserved_elasticsearch_instance_id: self.reserved_elasticsearch_instance_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReservedElasticsearchInstancesInputOperationOutputAlias =
    crate::operation::DescribeReservedElasticsearchInstances;
#[doc(hidden)]
pub type DescribeReservedElasticsearchInstancesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeReservedElasticsearchInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReservedElasticsearchInstances`](crate::operation::DescribeReservedElasticsearchInstances)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReservedElasticsearchInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeReservedElasticsearchInstancesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/reservedInstances")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeReservedElasticsearchInstancesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_18) = &_input.reserved_elasticsearch_instance_id {
                    query.push_kv(
                        "reservationId",
                        &aws_smithy_http::query::fmt_string(&inner_18),
                    );
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_19) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_19));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeReservedElasticsearchInstancesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReservedElasticsearchInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReservedElasticsearchInstances",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeReservedElasticsearchInstancesInput`](crate::input::DescribeReservedElasticsearchInstancesInput)
    pub fn builder() -> crate::input::describe_reserved_elasticsearch_instances_input::Builder {
        crate::input::describe_reserved_elasticsearch_instances_input::Builder::default()
    }
}

/// See [`DissociatePackageInput`](crate::input::DissociatePackageInput)
pub mod dissociate_package_input {
    /// A builder for [`DissociatePackageInput`](crate::input::DissociatePackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>Name of the domain that you want to associate the package with.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>Name of the domain that you want to associate the package with.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DissociatePackageInput`](crate::input::DissociatePackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DissociatePackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DissociatePackageInput {
                package_id: self.package_id,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DissociatePackageInputOperationOutputAlias = crate::operation::DissociatePackage;
#[doc(hidden)]
pub type DissociatePackageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DissociatePackageInput {
    /// Consumes the builder and constructs an Operation<[`DissociatePackage`](crate::operation::DissociatePackage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DissociatePackage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DissociatePackageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.package_id;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let package_id = aws_smithy_http::label::fmt_string(input_20, false);
                if package_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_21 = &_input.domain_name;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_21, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/packages/dissociate/{PackageID}/{DomainName}",
                    PackageID = package_id,
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DissociatePackageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DissociatePackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DissociatePackage",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DissociatePackageInput`](crate::input::DissociatePackageInput)
    pub fn builder() -> crate::input::dissociate_package_input::Builder {
        crate::input::dissociate_package_input::Builder::default()
    }
}

/// See [`GetCompatibleElasticsearchVersionsInput`](crate::input::GetCompatibleElasticsearchVersionsInput)
pub mod get_compatible_elasticsearch_versions_input {
    /// A builder for [`GetCompatibleElasticsearchVersionsInput`](crate::input::GetCompatibleElasticsearchVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCompatibleElasticsearchVersionsInput`](crate::input::GetCompatibleElasticsearchVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCompatibleElasticsearchVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCompatibleElasticsearchVersionsInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCompatibleElasticsearchVersionsInputOperationOutputAlias =
    crate::operation::GetCompatibleElasticsearchVersions;
#[doc(hidden)]
pub type GetCompatibleElasticsearchVersionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetCompatibleElasticsearchVersionsInput {
    /// Consumes the builder and constructs an Operation<[`GetCompatibleElasticsearchVersions`](crate::operation::GetCompatibleElasticsearchVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCompatibleElasticsearchVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCompatibleElasticsearchVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/compatibleVersions")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetCompatibleElasticsearchVersionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_22) = &_input.domain_name {
                    query.push_kv("domainName", &aws_smithy_http::query::fmt_string(&inner_22));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCompatibleElasticsearchVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCompatibleElasticsearchVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCompatibleElasticsearchVersions",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCompatibleElasticsearchVersionsInput`](crate::input::GetCompatibleElasticsearchVersionsInput)
    pub fn builder() -> crate::input::get_compatible_elasticsearch_versions_input::Builder {
        crate::input::get_compatible_elasticsearch_versions_input::Builder::default()
    }
}

/// See [`GetPackageVersionHistoryInput`](crate::input::GetPackageVersionHistoryInput)
pub mod get_package_version_history_input {
    /// A builder for [`GetPackageVersionHistoryInput`](crate::input::GetPackageVersionHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns an audit history of versions of the package.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>Returns an audit history of versions of the package.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>Limits results to a maximum number of versions.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Limits results to a maximum number of versions.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPackageVersionHistoryInput`](crate::input::GetPackageVersionHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPackageVersionHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPackageVersionHistoryInput {
                package_id: self.package_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPackageVersionHistoryInputOperationOutputAlias =
    crate::operation::GetPackageVersionHistory;
#[doc(hidden)]
pub type GetPackageVersionHistoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPackageVersionHistoryInput {
    /// Consumes the builder and constructs an Operation<[`GetPackageVersionHistory`](crate::operation::GetPackageVersionHistory)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPackageVersionHistory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPackageVersionHistoryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.package_id;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let package_id = aws_smithy_http::label::fmt_string(input_23, false);
                if package_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/packages/{PackageID}/history",
                    PackageID = package_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetPackageVersionHistoryInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_24) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_24));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPackageVersionHistoryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPackageVersionHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPackageVersionHistory",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPackageVersionHistoryInput`](crate::input::GetPackageVersionHistoryInput)
    pub fn builder() -> crate::input::get_package_version_history_input::Builder {
        crate::input::get_package_version_history_input::Builder::default()
    }
}

/// See [`GetUpgradeHistoryInput`](crate::input::GetUpgradeHistoryInput)
pub mod get_upgrade_history_input {
    /// A builder for [`GetUpgradeHistoryInput`](crate::input::GetUpgradeHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUpgradeHistoryInput`](crate::input::GetUpgradeHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUpgradeHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUpgradeHistoryInput {
                domain_name: self.domain_name,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUpgradeHistoryInputOperationOutputAlias = crate::operation::GetUpgradeHistory;
#[doc(hidden)]
pub type GetUpgradeHistoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUpgradeHistoryInput {
    /// Consumes the builder and constructs an Operation<[`GetUpgradeHistory`](crate::operation::GetUpgradeHistory)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUpgradeHistory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetUpgradeHistoryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.domain_name;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_25, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/upgradeDomain/{DomainName}/history",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetUpgradeHistoryInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_26) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_26));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetUpgradeHistoryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUpgradeHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUpgradeHistory",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetUpgradeHistoryInput`](crate::input::GetUpgradeHistoryInput)
    pub fn builder() -> crate::input::get_upgrade_history_input::Builder {
        crate::input::get_upgrade_history_input::Builder::default()
    }
}

/// See [`GetUpgradeStatusInput`](crate::input::GetUpgradeStatusInput)
pub mod get_upgrade_status_input {
    /// A builder for [`GetUpgradeStatusInput`](crate::input::GetUpgradeStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUpgradeStatusInput`](crate::input::GetUpgradeStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUpgradeStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUpgradeStatusInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUpgradeStatusInputOperationOutputAlias = crate::operation::GetUpgradeStatus;
#[doc(hidden)]
pub type GetUpgradeStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUpgradeStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetUpgradeStatus`](crate::operation::GetUpgradeStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUpgradeStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetUpgradeStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.domain_name;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_27, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/upgradeDomain/{DomainName}/status",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetUpgradeStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUpgradeStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUpgradeStatus",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetUpgradeStatusInput`](crate::input::GetUpgradeStatusInput)
    pub fn builder() -> crate::input::get_upgrade_status_input::Builder {
        crate::input::get_upgrade_status_input::Builder::default()
    }
}

/// See [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
pub mod list_domain_names_input {
    /// A builder for [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_type: std::option::Option<crate::model::EngineType>,
    }
    impl Builder {
        /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.engine_type = Some(input);
            self
        }
        /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.engine_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDomainNamesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDomainNamesInput {
                engine_type: self.engine_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDomainNamesInputOperationOutputAlias = crate::operation::ListDomainNames;
#[doc(hidden)]
pub type ListDomainNamesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDomainNamesInput {
    /// Consumes the builder and constructs an Operation<[`ListDomainNames`](crate::operation::ListDomainNames)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDomainNames,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDomainNamesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/domain").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDomainNamesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_28) = &_input.engine_type {
                    query.push_kv("engineType", &aws_smithy_http::query::fmt_string(&inner_28));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDomainNamesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDomainNames::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDomainNames",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
    pub fn builder() -> crate::input::list_domain_names_input::Builder {
        crate::input::list_domain_names_input::Builder::default()
    }
}

/// See [`ListDomainsForPackageInput`](crate::input::ListDomainsForPackageInput)
pub mod list_domains_for_package_input {
    /// A builder for [`ListDomainsForPackageInput`](crate::input::ListDomainsForPackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The package for which to list domains.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>The package for which to list domains.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>Limits results to a maximum number of domains.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Limits results to a maximum number of domains.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainsForPackageInput`](crate::input::ListDomainsForPackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDomainsForPackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDomainsForPackageInput {
                package_id: self.package_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDomainsForPackageInputOperationOutputAlias = crate::operation::ListDomainsForPackage;
#[doc(hidden)]
pub type ListDomainsForPackageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDomainsForPackageInput {
    /// Consumes the builder and constructs an Operation<[`ListDomainsForPackage`](crate::operation::ListDomainsForPackage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDomainsForPackage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDomainsForPackageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_29 = &_input.package_id;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let package_id = aws_smithy_http::label::fmt_string(input_29, false);
                if package_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "package_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/packages/{PackageID}/domains",
                    PackageID = package_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDomainsForPackageInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_30) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_30));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDomainsForPackageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDomainsForPackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDomainsForPackage",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDomainsForPackageInput`](crate::input::ListDomainsForPackageInput)
    pub fn builder() -> crate::input::list_domains_for_package_input::Builder {
        crate::input::list_domains_for_package_input::Builder::default()
    }
}

/// See [`ListElasticsearchInstanceTypesInput`](crate::input::ListElasticsearchInstanceTypesInput)
pub mod list_elasticsearch_instance_types_input {
    /// A builder for [`ListElasticsearchInstanceTypesInput`](crate::input::ListElasticsearchInstanceTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elasticsearch_version: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Version of Elasticsearch for which list of supported elasticsearch instance types are needed. </p>
        pub fn elasticsearch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.elasticsearch_version = Some(input.into());
            self
        }
        /// <p>Version of Elasticsearch for which list of supported elasticsearch instance types are needed. </p>
        pub fn set_elasticsearch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elasticsearch_version = input;
            self
        }
        /// <p>DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for list of available Elasticsearch instance types when modifying existing domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for list of available Elasticsearch instance types when modifying existing domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p> Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont be honored. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont be honored. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListElasticsearchInstanceTypesInput`](crate::input::ListElasticsearchInstanceTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListElasticsearchInstanceTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListElasticsearchInstanceTypesInput {
                elasticsearch_version: self.elasticsearch_version,
                domain_name: self.domain_name,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListElasticsearchInstanceTypesInputOperationOutputAlias =
    crate::operation::ListElasticsearchInstanceTypes;
#[doc(hidden)]
pub type ListElasticsearchInstanceTypesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListElasticsearchInstanceTypesInput {
    /// Consumes the builder and constructs an Operation<[`ListElasticsearchInstanceTypes`](crate::operation::ListElasticsearchInstanceTypes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListElasticsearchInstanceTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListElasticsearchInstanceTypesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_31 = &_input.elasticsearch_version;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "elasticsearch_version",
                        details: "cannot be empty or unset",
                    },
                )?;
                let elasticsearch_version = aws_smithy_http::label::fmt_string(input_31, false);
                if elasticsearch_version.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "elasticsearch_version",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/instanceTypes/{ElasticsearchVersion}",
                    ElasticsearchVersion = elasticsearch_version
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListElasticsearchInstanceTypesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_32) = &_input.domain_name {
                    query.push_kv("domainName", &aws_smithy_http::query::fmt_string(&inner_32));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_33) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_33));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListElasticsearchInstanceTypesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListElasticsearchInstanceTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListElasticsearchInstanceTypes",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListElasticsearchInstanceTypesInput`](crate::input::ListElasticsearchInstanceTypesInput)
    pub fn builder() -> crate::input::list_elasticsearch_instance_types_input::Builder {
        crate::input::list_elasticsearch_instance_types_input::Builder::default()
    }
}

/// See [`ListElasticsearchVersionsInput`](crate::input::ListElasticsearchVersionsInput)
pub mod list_elasticsearch_versions_input {
    /// A builder for [`ListElasticsearchVersionsInput`](crate::input::ListElasticsearchVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListElasticsearchVersionsInput`](crate::input::ListElasticsearchVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListElasticsearchVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListElasticsearchVersionsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListElasticsearchVersionsInputOperationOutputAlias =
    crate::operation::ListElasticsearchVersions;
#[doc(hidden)]
pub type ListElasticsearchVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListElasticsearchVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListElasticsearchVersions`](crate::operation::ListElasticsearchVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListElasticsearchVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListElasticsearchVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/versions").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListElasticsearchVersionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_34) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_34));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListElasticsearchVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListElasticsearchVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListElasticsearchVersions",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListElasticsearchVersionsInput`](crate::input::ListElasticsearchVersionsInput)
    pub fn builder() -> crate::input::list_elasticsearch_versions_input::Builder {
        crate::input::list_elasticsearch_versions_input::Builder::default()
    }
}

/// See [`ListPackagesForDomainInput`](crate::input::ListPackagesForDomainInput)
pub mod list_packages_for_domain_input {
    /// A builder for [`ListPackagesForDomainInput`](crate::input::ListPackagesForDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain for which you want to list associated packages.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain for which you want to list associated packages.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackagesForDomainInput`](crate::input::ListPackagesForDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPackagesForDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPackagesForDomainInput {
                domain_name: self.domain_name,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPackagesForDomainInputOperationOutputAlias = crate::operation::ListPackagesForDomain;
#[doc(hidden)]
pub type ListPackagesForDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPackagesForDomainInput {
    /// Consumes the builder and constructs an Operation<[`ListPackagesForDomain`](crate::operation::ListPackagesForDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPackagesForDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPackagesForDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_35 = &_input.domain_name;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_35, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/domain/{DomainName}/packages",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListPackagesForDomainInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_36) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_36));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPackagesForDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPackagesForDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPackagesForDomain",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPackagesForDomainInput`](crate::input::ListPackagesForDomainInput)
    pub fn builder() -> crate::input::list_packages_for_domain_input::Builder {
        crate::input::list_packages_for_domain_input::Builder::default()
    }
}

/// See [`ListTagsInput`](crate::input::ListTagsInput)
pub mod list_tags_input {
    /// A builder for [`ListTagsInput`](crate::input::ListTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsInput`](crate::input::ListTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTagsInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type ListTagsInputOperationOutputAlias = crate::operation::ListTags;
#[doc(hidden)]
pub type ListTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListTags`](crate::operation::ListTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/tags").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListTagsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_37) = &_input.arn {
                    query.push_kv("arn", &aws_smithy_http::query::fmt_string(&inner_37));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTags",
                    "elasticsearchservice",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
}

/// See [`PurchaseReservedElasticsearchInstanceOfferingInput`](crate::input::PurchaseReservedElasticsearchInstanceOfferingInput)
pub mod purchase_reserved_elasticsearch_instance_offering_input {
    /// A builder for [`PurchaseReservedElasticsearchInstanceOfferingInput`](crate::input::PurchaseReservedElasticsearchInstanceOfferingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_elasticsearch_instance_offering_id:
            std::option::Option<std::string::String>,
        pub(crate) reservation_name: std::option::Option<std::string::String>,
        pub(crate) instance_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the reserved Elasticsearch instance offering to purchase.</p>
        pub fn reserved_elasticsearch_instance_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_offering_id = Some(input.into());
            self
        }
        /// <p>The ID of the reserved Elasticsearch instance offering to purchase.</p>
        pub fn set_reserved_elasticsearch_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_offering_id = input;
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p>
        pub fn reservation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_name = Some(input.into());
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p>
        pub fn set_reservation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_name = input;
            self
        }
        /// <p>The number of Elasticsearch instances to reserve.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>The number of Elasticsearch instances to reserve.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseReservedElasticsearchInstanceOfferingInput`](crate::input::PurchaseReservedElasticsearchInstanceOfferingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PurchaseReservedElasticsearchInstanceOfferingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::PurchaseReservedElasticsearchInstanceOfferingInput {
                    reserved_elasticsearch_instance_offering_id: self
                        .reserved_elasticsearch_instance_offering_id,
                    reservation_name: self.reservation_name,
                    instance_count: self.instance_count.unwrap_or_default(),
                },
            )
        }
    }
}
#[doc(hidden)]
pub type PurchaseReservedElasticsearchInstanceOfferingInputOperationOutputAlias =
    crate::operation::PurchaseReservedElasticsearchInstanceOffering;
#[doc(hidden)]
pub type PurchaseReservedElasticsearchInstanceOfferingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PurchaseReservedElasticsearchInstanceOfferingInput {
    /// Consumes the builder and constructs an Operation<[`PurchaseReservedElasticsearchInstanceOffering`](crate::operation::PurchaseReservedElasticsearchInstanceOffering)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PurchaseReservedElasticsearchInstanceOffering,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PurchaseReservedElasticsearchInstanceOfferingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/purchaseReservedInstanceOffering")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PurchaseReservedElasticsearchInstanceOfferingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_purchase_reserved_elasticsearch_instance_offering(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PurchaseReservedElasticsearchInstanceOffering::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PurchaseReservedElasticsearchInstanceOffering",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PurchaseReservedElasticsearchInstanceOfferingInput`](crate::input::PurchaseReservedElasticsearchInstanceOfferingInput)
    pub fn builder(
    ) -> crate::input::purchase_reserved_elasticsearch_instance_offering_input::Builder {
        crate::input::purchase_reserved_elasticsearch_instance_offering_input::Builder::default()
    }
}

/// See [`RejectInboundCrossClusterSearchConnectionInput`](crate::input::RejectInboundCrossClusterSearchConnectionInput)
pub mod reject_inbound_cross_cluster_search_connection_input {
    /// A builder for [`RejectInboundCrossClusterSearchConnectionInput`](crate::input::RejectInboundCrossClusterSearchConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_cluster_search_connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The id of the inbound connection that you want to reject.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = Some(input.into());
            self
        }
        /// <p>The id of the inbound connection that you want to reject.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectInboundCrossClusterSearchConnectionInput`](crate::input::RejectInboundCrossClusterSearchConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RejectInboundCrossClusterSearchConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::RejectInboundCrossClusterSearchConnectionInput {
                    cross_cluster_search_connection_id: self.cross_cluster_search_connection_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type RejectInboundCrossClusterSearchConnectionInputOperationOutputAlias =
    crate::operation::RejectInboundCrossClusterSearchConnection;
#[doc(hidden)]
pub type RejectInboundCrossClusterSearchConnectionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl RejectInboundCrossClusterSearchConnectionInput {
    /// Consumes the builder and constructs an Operation<[`RejectInboundCrossClusterSearchConnection`](crate::operation::RejectInboundCrossClusterSearchConnection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RejectInboundCrossClusterSearchConnection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RejectInboundCrossClusterSearchConnectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_38 = &_input.cross_cluster_search_connection_id;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "cross_cluster_search_connection_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let cross_cluster_search_connection_id =
                    aws_smithy_http::label::fmt_string(input_38, false);
                if cross_cluster_search_connection_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "cross_cluster_search_connection_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/ccs/inboundConnection/{CrossClusterSearchConnectionId}/reject",
                    CrossClusterSearchConnectionId = cross_cluster_search_connection_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RejectInboundCrossClusterSearchConnectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RejectInboundCrossClusterSearchConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RejectInboundCrossClusterSearchConnection",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RejectInboundCrossClusterSearchConnectionInput`](crate::input::RejectInboundCrossClusterSearchConnectionInput)
    pub fn builder() -> crate::input::reject_inbound_cross_cluster_search_connection_input::Builder
    {
        crate::input::reject_inbound_cross_cluster_search_connection_input::Builder::default()
    }
}

/// See [`RemoveTagsInput`](crate::input::RemoveTagsInput)
pub mod remove_tags_input {
    /// A builder for [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Specifies the <code>ARN</code> for the Elasticsearch domain from which you want to delete the specified tags.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Specifies the <code>ARN</code> for the Elasticsearch domain from which you want to delete the specified tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Specifies the <code>TagKey</code> list which you want to remove from the Elasticsearch domain.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>Specifies the <code>TagKey</code> list which you want to remove from the Elasticsearch domain.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsInput`](crate::input::RemoveTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsInput {
                arn: self.arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsInputOperationOutputAlias = crate::operation::RemoveTags;
#[doc(hidden)]
pub type RemoveTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RemoveTagsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTags`](crate::operation::RemoveTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RemoveTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/tags-removal").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RemoveTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_remove_tags(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTags",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    pub fn builder() -> crate::input::remove_tags_input::Builder {
        crate::input::remove_tags_input::Builder::default()
    }
}

/// See [`StartElasticsearchServiceSoftwareUpdateInput`](crate::input::StartElasticsearchServiceSoftwareUpdateInput)
pub mod start_elasticsearch_service_software_update_input {
    /// A builder for [`StartElasticsearchServiceSoftwareUpdateInput`](crate::input::StartElasticsearchServiceSoftwareUpdateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to update to the latest service software.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to update to the latest service software.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartElasticsearchServiceSoftwareUpdateInput`](crate::input::StartElasticsearchServiceSoftwareUpdateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartElasticsearchServiceSoftwareUpdateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartElasticsearchServiceSoftwareUpdateInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type StartElasticsearchServiceSoftwareUpdateInputOperationOutputAlias =
    crate::operation::StartElasticsearchServiceSoftwareUpdate;
#[doc(hidden)]
pub type StartElasticsearchServiceSoftwareUpdateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl StartElasticsearchServiceSoftwareUpdateInput {
    /// Consumes the builder and constructs an Operation<[`StartElasticsearchServiceSoftwareUpdate`](crate::operation::StartElasticsearchServiceSoftwareUpdate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartElasticsearchServiceSoftwareUpdate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartElasticsearchServiceSoftwareUpdateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/serviceSoftwareUpdate/start")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartElasticsearchServiceSoftwareUpdateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_elasticsearch_service_software_update(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartElasticsearchServiceSoftwareUpdate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartElasticsearchServiceSoftwareUpdate",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartElasticsearchServiceSoftwareUpdateInput`](crate::input::StartElasticsearchServiceSoftwareUpdateInput)
    pub fn builder() -> crate::input::start_elasticsearch_service_software_update_input::Builder {
        crate::input::start_elasticsearch_service_software_update_input::Builder::default()
    }
}

/// See [`UpdateElasticsearchDomainConfigInput`](crate::input::UpdateElasticsearchDomainConfigInput)
pub mod update_elasticsearch_domain_config_input {
    /// A builder for [`UpdateElasticsearchDomainConfigInput`](crate::input::UpdateElasticsearchDomainConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) elasticsearch_cluster_config:
            std::option::Option<crate::model::ElasticsearchClusterConfig>,
        pub(crate) ebs_options: std::option::Option<crate::model::EbsOptions>,
        pub(crate) snapshot_options: std::option::Option<crate::model::SnapshotOptions>,
        pub(crate) vpc_options: std::option::Option<crate::model::VpcOptions>,
        pub(crate) cognito_options: std::option::Option<crate::model::CognitoOptions>,
        pub(crate) advanced_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) access_policies: std::option::Option<std::string::String>,
        pub(crate) log_publishing_options: std::option::Option<
            std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
        >,
        pub(crate) domain_endpoint_options:
            std::option::Option<crate::model::DomainEndpointOptions>,
        pub(crate) advanced_security_options:
            std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        pub(crate) node_to_node_encryption_options:
            std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        pub(crate) encryption_at_rest_options:
            std::option::Option<crate::model::EncryptionAtRestOptions>,
        pub(crate) auto_tune_options: std::option::Option<crate::model::AutoTuneOptions>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Elasticsearch domain that you are updating. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the Elasticsearch domain that you are updating. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The type and number of instances to instantiate for the domain cluster.</p>
        pub fn elasticsearch_cluster_config(
            mut self,
            input: crate::model::ElasticsearchClusterConfig,
        ) -> Self {
            self.elasticsearch_cluster_config = Some(input);
            self
        }
        /// <p>The type and number of instances to instantiate for the domain cluster.</p>
        pub fn set_elasticsearch_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchClusterConfig>,
        ) -> Self {
            self.elasticsearch_cluster_config = input;
            self
        }
        /// <p>Specify the type and size of the EBS volume that you want to use. </p>
        pub fn ebs_options(mut self, input: crate::model::EbsOptions) -> Self {
            self.ebs_options = Some(input);
            self
        }
        /// <p>Specify the type and size of the EBS volume that you want to use. </p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptions>,
        ) -> Self {
            self.ebs_options = input;
            self
        }
        /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
        pub fn snapshot_options(mut self, input: crate::model::SnapshotOptions) -> Self {
            self.snapshot_options = Some(input);
            self
        }
        /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.snapshot_options = input;
            self
        }
        /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
        pub fn vpc_options(mut self, input: crate::model::VpcOptions) -> Self {
            self.vpc_options = Some(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcOptions>,
        ) -> Self {
            self.vpc_options = input;
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn cognito_options(mut self, input: crate::model::CognitoOptions) -> Self {
            self.cognito_options = Some(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.cognito_options = input;
            self
        }
        /// Adds a key-value pair to `advanced_options`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.advanced_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.advanced_options = Some(hash_map);
            self
        }
        /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.advanced_options = input;
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policies = Some(input.into());
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policies = input;
            self
        }
        /// Adds a key-value pair to `log_publishing_options`.
        ///
        /// To override the contents of this collection use [`set_log_publishing_options`](Self::set_log_publishing_options).
        ///
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
        pub fn log_publishing_options(
            mut self,
            k: crate::model::LogType,
            v: crate::model::LogPublishingOption,
        ) -> Self {
            let mut hash_map = self.log_publishing_options.unwrap_or_default();
            hash_map.insert(k, v);
            self.log_publishing_options = Some(hash_map);
            self
        }
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.log_publishing_options = input;
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptions,
        ) -> Self {
            self.domain_endpoint_options = Some(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.domain_endpoint_options = input;
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn advanced_security_options(
            mut self,
            input: crate::model::AdvancedSecurityOptionsInput,
        ) -> Self {
            self.advanced_security_options = Some(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        ) -> Self {
            self.advanced_security_options = input;
            self
        }
        /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            input: crate::model::NodeToNodeEncryptionOptions,
        ) -> Self {
            self.node_to_node_encryption_options = Some(input);
            self
        }
        /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.node_to_node_encryption_options = input;
            self
        }
        /// <p>Specifies the Encryption At Rest Options.</p>
        pub fn encryption_at_rest_options(
            mut self,
            input: crate::model::EncryptionAtRestOptions,
        ) -> Self {
            self.encryption_at_rest_options = Some(input);
            self
        }
        /// <p>Specifies the Encryption At Rest Options.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.encryption_at_rest_options = input;
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn auto_tune_options(mut self, input: crate::model::AutoTuneOptions) -> Self {
            self.auto_tune_options = Some(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptions>,
        ) -> Self {
            self.auto_tune_options = input;
            self
        }
        /// <p> This flag, when set to True, specifies whether the <code>UpdateElasticsearchDomain</code> request should return the results of validation checks without actually applying the change. This flag, when set to True, specifies the deployment mechanism through which the update shall be applied on the domain. This will not actually perform the Update. </p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p> This flag, when set to True, specifies whether the <code>UpdateElasticsearchDomain</code> request should return the results of validation checks without actually applying the change. This flag, when set to True, specifies the deployment mechanism through which the update shall be applied on the domain. This will not actually perform the Update. </p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateElasticsearchDomainConfigInput`](crate::input::UpdateElasticsearchDomainConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateElasticsearchDomainConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateElasticsearchDomainConfigInput {
                domain_name: self.domain_name,
                elasticsearch_cluster_config: self.elasticsearch_cluster_config,
                ebs_options: self.ebs_options,
                snapshot_options: self.snapshot_options,
                vpc_options: self.vpc_options,
                cognito_options: self.cognito_options,
                advanced_options: self.advanced_options,
                access_policies: self.access_policies,
                log_publishing_options: self.log_publishing_options,
                domain_endpoint_options: self.domain_endpoint_options,
                advanced_security_options: self.advanced_security_options,
                node_to_node_encryption_options: self.node_to_node_encryption_options,
                encryption_at_rest_options: self.encryption_at_rest_options,
                auto_tune_options: self.auto_tune_options,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateElasticsearchDomainConfigInputOperationOutputAlias =
    crate::operation::UpdateElasticsearchDomainConfig;
#[doc(hidden)]
pub type UpdateElasticsearchDomainConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateElasticsearchDomainConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateElasticsearchDomainConfig`](crate::operation::UpdateElasticsearchDomainConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateElasticsearchDomainConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateElasticsearchDomainConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_39 = &_input.domain_name;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_39, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-01-01/es/domain/{DomainName}/config",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateElasticsearchDomainConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_elasticsearch_domain_config(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateElasticsearchDomainConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateElasticsearchDomainConfig",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateElasticsearchDomainConfigInput`](crate::input::UpdateElasticsearchDomainConfigInput)
    pub fn builder() -> crate::input::update_elasticsearch_domain_config_input::Builder {
        crate::input::update_elasticsearch_domain_config_input::Builder::default()
    }
}

/// See [`UpdatePackageInput`](crate::input::UpdatePackageInput)
pub mod update_package_input {
    /// A builder for [`UpdatePackageInput`](crate::input::UpdatePackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_source: std::option::Option<crate::model::PackageSource>,
        pub(crate) package_description: std::option::Option<std::string::String>,
        pub(crate) commit_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique identifier for the package.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>Unique identifier for the package.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>The S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code></p>
        pub fn package_source(mut self, input: crate::model::PackageSource) -> Self {
            self.package_source = Some(input);
            self
        }
        /// <p>The S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code></p>
        pub fn set_package_source(
            mut self,
            input: std::option::Option<crate::model::PackageSource>,
        ) -> Self {
            self.package_source = input;
            self
        }
        /// <p>New description of the package.</p>
        pub fn package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_description = Some(input.into());
            self
        }
        /// <p>New description of the package.</p>
        pub fn set_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_description = input;
            self
        }
        /// <p>An info message for the new version which will be shown as part of <code>GetPackageVersionHistoryResponse</code>.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_message = Some(input.into());
            self
        }
        /// <p>An info message for the new version which will be shown as part of <code>GetPackageVersionHistoryResponse</code>.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_message = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePackageInput`](crate::input::UpdatePackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePackageInput {
                package_id: self.package_id,
                package_source: self.package_source,
                package_description: self.package_description,
                commit_message: self.commit_message,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePackageInputOperationOutputAlias = crate::operation::UpdatePackage;
#[doc(hidden)]
pub type UpdatePackageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePackageInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePackage`](crate::operation::UpdatePackage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePackage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePackageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/packages/update").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePackageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_package(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePackage",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePackageInput`](crate::input::UpdatePackageInput)
    pub fn builder() -> crate::input::update_package_input::Builder {
        crate::input::update_package_input::Builder::default()
    }
}

/// See [`UpgradeElasticsearchDomainInput`](crate::input::UpgradeElasticsearchDomainInput)
pub mod upgrade_elasticsearch_domain_input {
    /// A builder for [`UpgradeElasticsearchDomainInput`](crate::input::UpgradeElasticsearchDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) target_version: std::option::Option<std::string::String>,
        pub(crate) perform_check_only: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The version of Elasticsearch that you intend to upgrade the domain to.</p>
        pub fn target_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_version = Some(input.into());
            self
        }
        /// <p>The version of Elasticsearch that you intend to upgrade the domain to.</p>
        pub fn set_target_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_version = input;
            self
        }
        /// <p> This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not actually perform the Upgrade. </p>
        pub fn perform_check_only(mut self, input: bool) -> Self {
            self.perform_check_only = Some(input);
            self
        }
        /// <p> This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not actually perform the Upgrade. </p>
        pub fn set_perform_check_only(mut self, input: std::option::Option<bool>) -> Self {
            self.perform_check_only = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradeElasticsearchDomainInput`](crate::input::UpgradeElasticsearchDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpgradeElasticsearchDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpgradeElasticsearchDomainInput {
                domain_name: self.domain_name,
                target_version: self.target_version,
                perform_check_only: self.perform_check_only,
            })
        }
    }
}
#[doc(hidden)]
pub type UpgradeElasticsearchDomainInputOperationOutputAlias =
    crate::operation::UpgradeElasticsearchDomain;
#[doc(hidden)]
pub type UpgradeElasticsearchDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpgradeElasticsearchDomainInput {
    /// Consumes the builder and constructs an Operation<[`UpgradeElasticsearchDomain`](crate::operation::UpgradeElasticsearchDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpgradeElasticsearchDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpgradeElasticsearchDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-01-01/es/upgradeDomain").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpgradeElasticsearchDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_upgrade_elasticsearch_domain(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpgradeElasticsearchDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpgradeElasticsearchDomain",
            "elasticsearchservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpgradeElasticsearchDomainInput`](crate::input::UpgradeElasticsearchDomainInput)
    pub fn builder() -> crate::input::upgrade_elasticsearch_domain_input::Builder {
        crate::input::upgrade_elasticsearch_domain_input::Builder::default()
    }
}

/// <p> Container for request parameters to <code> <code>UpgradeElasticsearchDomain</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeElasticsearchDomainInput {
    /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The version of Elasticsearch that you intend to upgrade the domain to.</p>
    pub target_version: std::option::Option<std::string::String>,
    /// <p> This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not actually perform the Upgrade. </p>
    pub perform_check_only: std::option::Option<bool>,
}
impl UpgradeElasticsearchDomainInput {
    /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The version of Elasticsearch that you intend to upgrade the domain to.</p>
    pub fn target_version(&self) -> std::option::Option<&str> {
        self.target_version.as_deref()
    }
    /// <p> This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not actually perform the Upgrade. </p>
    pub fn perform_check_only(&self) -> std::option::Option<bool> {
        self.perform_check_only
    }
}
impl std::fmt::Debug for UpgradeElasticsearchDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeElasticsearchDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("target_version", &self.target_version);
        formatter.field("perform_check_only", &self.perform_check_only);
        formatter.finish()
    }
}

/// <p> Container for request parameters to <code> <code>UpdatePackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePackageInput {
    /// <p>Unique identifier for the package.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>The S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code></p>
    pub package_source: std::option::Option<crate::model::PackageSource>,
    /// <p>New description of the package.</p>
    pub package_description: std::option::Option<std::string::String>,
    /// <p>An info message for the new version which will be shown as part of <code>GetPackageVersionHistoryResponse</code>.</p>
    pub commit_message: std::option::Option<std::string::String>,
}
impl UpdatePackageInput {
    /// <p>Unique identifier for the package.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>The S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code></p>
    pub fn package_source(&self) -> std::option::Option<&crate::model::PackageSource> {
        self.package_source.as_ref()
    }
    /// <p>New description of the package.</p>
    pub fn package_description(&self) -> std::option::Option<&str> {
        self.package_description.as_deref()
    }
    /// <p>An info message for the new version which will be shown as part of <code>GetPackageVersionHistoryResponse</code>.</p>
    pub fn commit_message(&self) -> std::option::Option<&str> {
        self.commit_message.as_deref()
    }
}
impl std::fmt::Debug for UpdatePackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePackageInput");
        formatter.field("package_id", &self.package_id);
        formatter.field("package_source", &self.package_source);
        formatter.field("package_description", &self.package_description);
        formatter.field("commit_message", &self.commit_message);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>UpdateElasticsearchDomain</code></code> operation. Specifies the type and number of instances in the domain cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateElasticsearchDomainConfigInput {
    /// <p>The name of the Elasticsearch domain that you are updating. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The type and number of instances to instantiate for the domain cluster.</p>
    pub elasticsearch_cluster_config: std::option::Option<crate::model::ElasticsearchClusterConfig>,
    /// <p>Specify the type and size of the EBS volume that you want to use. </p>
    pub ebs_options: std::option::Option<crate::model::EbsOptions>,
    /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
    pub snapshot_options: std::option::Option<crate::model::SnapshotOptions>,
    /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
    pub vpc_options: std::option::Option<crate::model::VpcOptions>,
    /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
    pub cognito_options: std::option::Option<crate::model::CognitoOptions>,
    /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
    pub advanced_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>IAM access policy as a JSON-formatted string.</p>
    pub access_policies: std::option::Option<std::string::String>,
    /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
    pub log_publishing_options: std::option::Option<
        std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
    >,
    /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
    pub domain_endpoint_options: std::option::Option<crate::model::DomainEndpointOptions>,
    /// <p>Specifies advanced security options.</p>
    pub advanced_security_options: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
    /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
    pub node_to_node_encryption_options:
        std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
    /// <p>Specifies the Encryption At Rest Options.</p>
    pub encryption_at_rest_options: std::option::Option<crate::model::EncryptionAtRestOptions>,
    /// <p>Specifies Auto-Tune options.</p>
    pub auto_tune_options: std::option::Option<crate::model::AutoTuneOptions>,
    /// <p> This flag, when set to True, specifies whether the <code>UpdateElasticsearchDomain</code> request should return the results of validation checks without actually applying the change. This flag, when set to True, specifies the deployment mechanism through which the update shall be applied on the domain. This will not actually perform the Update. </p>
    pub dry_run: std::option::Option<bool>,
}
impl UpdateElasticsearchDomainConfigInput {
    /// <p>The name of the Elasticsearch domain that you are updating. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The type and number of instances to instantiate for the domain cluster.</p>
    pub fn elasticsearch_cluster_config(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchClusterConfig> {
        self.elasticsearch_cluster_config.as_ref()
    }
    /// <p>Specify the type and size of the EBS volume that you want to use. </p>
    pub fn ebs_options(&self) -> std::option::Option<&crate::model::EbsOptions> {
        self.ebs_options.as_ref()
    }
    /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
    pub fn snapshot_options(&self) -> std::option::Option<&crate::model::SnapshotOptions> {
        self.snapshot_options.as_ref()
    }
    /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
    pub fn vpc_options(&self) -> std::option::Option<&crate::model::VpcOptions> {
        self.vpc_options.as_ref()
    }
    /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
    pub fn cognito_options(&self) -> std::option::Option<&crate::model::CognitoOptions> {
        self.cognito_options.as_ref()
    }
    /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
    pub fn advanced_options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.advanced_options.as_ref()
    }
    /// <p>IAM access policy as a JSON-formatted string.</p>
    pub fn access_policies(&self) -> std::option::Option<&str> {
        self.access_policies.as_deref()
    }
    /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
    pub fn log_publishing_options(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
    > {
        self.log_publishing_options.as_ref()
    }
    /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
    pub fn domain_endpoint_options(
        &self,
    ) -> std::option::Option<&crate::model::DomainEndpointOptions> {
        self.domain_endpoint_options.as_ref()
    }
    /// <p>Specifies advanced security options.</p>
    pub fn advanced_security_options(
        &self,
    ) -> std::option::Option<&crate::model::AdvancedSecurityOptionsInput> {
        self.advanced_security_options.as_ref()
    }
    /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
    pub fn node_to_node_encryption_options(
        &self,
    ) -> std::option::Option<&crate::model::NodeToNodeEncryptionOptions> {
        self.node_to_node_encryption_options.as_ref()
    }
    /// <p>Specifies the Encryption At Rest Options.</p>
    pub fn encryption_at_rest_options(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionAtRestOptions> {
        self.encryption_at_rest_options.as_ref()
    }
    /// <p>Specifies Auto-Tune options.</p>
    pub fn auto_tune_options(&self) -> std::option::Option<&crate::model::AutoTuneOptions> {
        self.auto_tune_options.as_ref()
    }
    /// <p> This flag, when set to True, specifies whether the <code>UpdateElasticsearchDomain</code> request should return the results of validation checks without actually applying the change. This flag, when set to True, specifies the deployment mechanism through which the update shall be applied on the domain. This will not actually perform the Update. </p>
    pub fn dry_run(&self) -> std::option::Option<bool> {
        self.dry_run
    }
}
impl std::fmt::Debug for UpdateElasticsearchDomainConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateElasticsearchDomainConfigInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field(
            "elasticsearch_cluster_config",
            &self.elasticsearch_cluster_config,
        );
        formatter.field("ebs_options", &self.ebs_options);
        formatter.field("snapshot_options", &self.snapshot_options);
        formatter.field("vpc_options", &self.vpc_options);
        formatter.field("cognito_options", &self.cognito_options);
        formatter.field("advanced_options", &self.advanced_options);
        formatter.field("access_policies", &self.access_policies);
        formatter.field("log_publishing_options", &self.log_publishing_options);
        formatter.field("domain_endpoint_options", &self.domain_endpoint_options);
        formatter.field("advanced_security_options", &self.advanced_security_options);
        formatter.field(
            "node_to_node_encryption_options",
            &self.node_to_node_encryption_options,
        );
        formatter.field(
            "encryption_at_rest_options",
            &self.encryption_at_rest_options,
        );
        formatter.field("auto_tune_options", &self.auto_tune_options);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>StartElasticsearchServiceSoftwareUpdate</code></code> operation. Specifies the name of the Elasticsearch domain that you wish to schedule a service software update on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartElasticsearchServiceSoftwareUpdateInput {
    /// <p>The name of the domain that you want to update to the latest service software.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl StartElasticsearchServiceSoftwareUpdateInput {
    /// <p>The name of the domain that you want to update to the latest service software.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for StartElasticsearchServiceSoftwareUpdateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartElasticsearchServiceSoftwareUpdateInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>RemoveTags</code></code> operation. Specify the <code>ARN</code> for the Elasticsearch domain from which you want to remove the specified <code>TagKey</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsInput {
    /// <p>Specifies the <code>ARN</code> for the Elasticsearch domain from which you want to delete the specified tags.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Specifies the <code>TagKey</code> list which you want to remove from the Elasticsearch domain.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RemoveTagsInput {
    /// <p>Specifies the <code>ARN</code> for the Elasticsearch domain from which you want to delete the specified tags.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Specifies the <code>TagKey</code> list which you want to remove from the Elasticsearch domain.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsInput");
        formatter.field("arn", &self.arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>RejectInboundCrossClusterSearchConnection</code></code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectInboundCrossClusterSearchConnectionInput {
    /// <p>The id of the inbound connection that you want to reject.</p>
    pub cross_cluster_search_connection_id: std::option::Option<std::string::String>,
}
impl RejectInboundCrossClusterSearchConnectionInput {
    /// <p>The id of the inbound connection that you want to reject.</p>
    pub fn cross_cluster_search_connection_id(&self) -> std::option::Option<&str> {
        self.cross_cluster_search_connection_id.as_deref()
    }
}
impl std::fmt::Debug for RejectInboundCrossClusterSearchConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectInboundCrossClusterSearchConnectionInput");
        formatter.field(
            "cross_cluster_search_connection_id",
            &self.cross_cluster_search_connection_id,
        );
        formatter.finish()
    }
}

/// <p>Container for parameters to <code>PurchaseReservedElasticsearchInstanceOffering</code></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseReservedElasticsearchInstanceOfferingInput {
    /// <p>The ID of the reserved Elasticsearch instance offering to purchase.</p>
    pub reserved_elasticsearch_instance_offering_id: std::option::Option<std::string::String>,
    /// <p>A customer-specified identifier to track this reservation.</p>
    pub reservation_name: std::option::Option<std::string::String>,
    /// <p>The number of Elasticsearch instances to reserve.</p>
    pub instance_count: i32,
}
impl PurchaseReservedElasticsearchInstanceOfferingInput {
    /// <p>The ID of the reserved Elasticsearch instance offering to purchase.</p>
    pub fn reserved_elasticsearch_instance_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_elasticsearch_instance_offering_id.as_deref()
    }
    /// <p>A customer-specified identifier to track this reservation.</p>
    pub fn reservation_name(&self) -> std::option::Option<&str> {
        self.reservation_name.as_deref()
    }
    /// <p>The number of Elasticsearch instances to reserve.</p>
    pub fn instance_count(&self) -> i32 {
        self.instance_count
    }
}
impl std::fmt::Debug for PurchaseReservedElasticsearchInstanceOfferingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseReservedElasticsearchInstanceOfferingInput");
        formatter.field(
            "reserved_elasticsearch_instance_offering_id",
            &self.reserved_elasticsearch_instance_offering_id,
        );
        formatter.field("reservation_name", &self.reservation_name);
        formatter.field("instance_count", &self.instance_count);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>ListTags</code></code> operation. Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view are attached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsInput {
    /// <p> Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl ListTagsInput {
    /// <p> Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p> Container for request parameters to <code> <code>ListPackagesForDomain</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackagesForDomainInput {
    /// <p>The name of the domain for which you want to list associated packages.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Limits results to a maximum number of packages.</p>
    pub max_results: i32,
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPackagesForDomainInput {
    /// <p>The name of the domain for which you want to list associated packages.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Limits results to a maximum number of packages.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPackagesForDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackagesForDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for the parameters to the <code> <code>ListElasticsearchVersions</code> </code> operation. </p>
/// <p> Use <code> <code>MaxResults</code> </code> to control the maximum number of results to retrieve in a single call. </p>
/// <p> Use <code> <code>NextToken</code> </code> in response to retrieve more results. If the received response does not contain a NextToken, then there are no more results to retrieve. </p>
/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListElasticsearchVersionsInput {
    /// <p> Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored. </p>
    pub max_results: i32,
    /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListElasticsearchVersionsInput {
    /// <p> Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListElasticsearchVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListElasticsearchVersionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for the parameters to the <code> <code>ListElasticsearchInstanceTypes</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListElasticsearchInstanceTypesInput {
    /// <p>Version of Elasticsearch for which list of supported elasticsearch instance types are needed. </p>
    pub elasticsearch_version: std::option::Option<std::string::String>,
    /// <p>DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for list of available Elasticsearch instance types when modifying existing domain. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p> Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont be honored. </p>
    pub max_results: i32,
    /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListElasticsearchInstanceTypesInput {
    /// <p>Version of Elasticsearch for which list of supported elasticsearch instance types are needed. </p>
    pub fn elasticsearch_version(&self) -> std::option::Option<&str> {
        self.elasticsearch_version.as_deref()
    }
    /// <p>DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for list of available Elasticsearch instance types when modifying existing domain. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p> Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont be honored. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListElasticsearchInstanceTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListElasticsearchInstanceTypesInput");
        formatter.field("elasticsearch_version", &self.elasticsearch_version);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for request parameters to <code> <code>ListDomainsForPackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainsForPackageInput {
    /// <p>The package for which to list domains.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>Limits results to a maximum number of domains.</p>
    pub max_results: i32,
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDomainsForPackageInput {
    /// <p>The package for which to list domains.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>Limits results to a maximum number of domains.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDomainsForPackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainsForPackageInput");
        formatter.field("package_id", &self.package_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for the parameters to the <code><code>ListDomainNames</code></code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainNamesInput {
    /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
    pub engine_type: std::option::Option<crate::model::EngineType>,
}
impl ListDomainNamesInput {
    /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
    pub fn engine_type(&self) -> std::option::Option<&crate::model::EngineType> {
        self.engine_type.as_ref()
    }
}
impl std::fmt::Debug for ListDomainNamesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainNamesInput");
        formatter.field("engine_type", &self.engine_type);
        formatter.finish()
    }
}

/// <p> Container for request parameters to <code> <code>GetUpgradeStatus</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUpgradeStatusInput {
    /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetUpgradeStatusInput {
    /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetUpgradeStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUpgradeStatusInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p> Container for request parameters to <code> <code>GetUpgradeHistory</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUpgradeHistoryInput {
    /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p> Set this value to limit the number of results returned. </p>
    pub max_results: i32,
    /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetUpgradeHistoryInput {
    /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p> Set this value to limit the number of results returned. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetUpgradeHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUpgradeHistoryInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for request parameters to <code> <code>GetPackageVersionHistory</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPackageVersionHistoryInput {
    /// <p>Returns an audit history of versions of the package.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>Limits results to a maximum number of versions.</p>
    pub max_results: i32,
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetPackageVersionHistoryInput {
    /// <p>Returns an audit history of versions of the package.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>Limits results to a maximum number of versions.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetPackageVersionHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPackageVersionHistoryInput");
        formatter.field("package_id", &self.package_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for request parameters to <code> <code>GetCompatibleElasticsearchVersions</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCompatibleElasticsearchVersionsInput {
    /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetCompatibleElasticsearchVersionsInput {
    /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetCompatibleElasticsearchVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCompatibleElasticsearchVersionsInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p> Container for request parameters to <code> <code>DissociatePackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DissociatePackageInput {
    /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>Name of the domain that you want to associate the package with.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DissociatePackageInput {
    /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>Name of the domain that you want to associate the package with.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DissociatePackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DissociatePackageInput");
        formatter.field("package_id", &self.package_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>Container for parameters to <code>DescribeReservedElasticsearchInstances</code></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedElasticsearchInstancesInput {
    /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved Elasticsearch instance ID.</p>
    pub reserved_elasticsearch_instance_id: std::option::Option<std::string::String>,
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub max_results: i32,
    /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeReservedElasticsearchInstancesInput {
    /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved Elasticsearch instance ID.</p>
    pub fn reserved_elasticsearch_instance_id(&self) -> std::option::Option<&str> {
        self.reserved_elasticsearch_instance_id.as_deref()
    }
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservedElasticsearchInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedElasticsearchInstancesInput");
        formatter.field(
            "reserved_elasticsearch_instance_id",
            &self.reserved_elasticsearch_instance_id,
        );
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Container for parameters to <code>DescribeReservedElasticsearchInstanceOfferings</code></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedElasticsearchInstanceOfferingsInput {
    /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
    pub reserved_elasticsearch_instance_offering_id: std::option::Option<std::string::String>,
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub max_results: i32,
    /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeReservedElasticsearchInstanceOfferingsInput {
    /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
    pub fn reserved_elasticsearch_instance_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_elasticsearch_instance_offering_id.as_deref()
    }
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservedElasticsearchInstanceOfferingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedElasticsearchInstanceOfferingsInput");
        formatter.field(
            "reserved_elasticsearch_instance_offering_id",
            &self.reserved_elasticsearch_instance_offering_id,
        );
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for request parameters to <code> <code>DescribePackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackagesInput {
    /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::DescribePackagesFilter>>,
    /// <p>Limits results to a maximum number of packages.</p>
    pub max_results: i32,
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribePackagesInput {
    /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::DescribePackagesFilter]> {
        self.filters.as_deref()
    }
    /// <p>Limits results to a maximum number of packages.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribePackagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackagesInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>DescribeOutboundCrossClusterSearchConnections</code></code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOutboundCrossClusterSearchConnectionsInput {
    /// <p> A list of filters used to match properties for outbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
    /// <ul>
    /// <li>cross-cluster-search-connection-id</li>
    /// <li>destination-domain-info.domain-name</li>
    /// <li>destination-domain-info.owner-id</li>
    /// <li>destination-domain-info.region</li>
    /// <li>source-domain-info.domain-name</li>
    /// </ul>
    /// <p></p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub max_results: i32,
    /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeOutboundCrossClusterSearchConnectionsInput {
    /// <p> A list of filters used to match properties for outbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
    /// <ul>
    /// <li>cross-cluster-search-connection-id</li>
    /// <li>destination-domain-info.domain-name</li>
    /// <li>destination-domain-info.owner-id</li>
    /// <li>destination-domain-info.region</li>
    /// <li>source-domain-info.domain-name</li>
    /// </ul>
    /// <p></p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeOutboundCrossClusterSearchConnectionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOutboundCrossClusterSearchConnectionsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>DescribeInboundCrossClusterSearchConnections</code></code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInboundCrossClusterSearchConnectionsInput {
    /// <p> A list of filters used to match properties for inbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
    /// <ul>
    /// <li>cross-cluster-search-connection-id</li>
    /// <li>source-domain-info.domain-name</li>
    /// <li>source-domain-info.owner-id</li>
    /// <li>source-domain-info.region</li>
    /// <li>destination-domain-info.domain-name</li>
    /// </ul>
    /// <p></p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub max_results: i32,
    /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeInboundCrossClusterSearchConnectionsInput {
    /// <p> A list of filters used to match properties for inbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
    /// <ul>
    /// <li>cross-cluster-search-connection-id</li>
    /// <li>source-domain-info.domain-name</li>
    /// <li>source-domain-info.owner-id</li>
    /// <li>source-domain-info.region</li>
    /// <li>destination-domain-info.domain-name</li>
    /// </ul>
    /// <p></p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeInboundCrossClusterSearchConnectionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInboundCrossClusterSearchConnectionsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for the parameters to <code> <code>DescribeElasticsearchInstanceTypeLimits</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeElasticsearchInstanceTypeLimitsInput {
    /// <p> DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for Elasticsearch <code> <code>Limits</code> </code> for existing domain. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p> The instance type for an Elasticsearch cluster for which Elasticsearch <code> <code>Limits</code> </code> are needed. </p>
    pub instance_type: std::option::Option<crate::model::EsPartitionInstanceType>,
    /// <p> Version of Elasticsearch for which <code> <code>Limits</code> </code> are needed. </p>
    pub elasticsearch_version: std::option::Option<std::string::String>,
}
impl DescribeElasticsearchInstanceTypeLimitsInput {
    /// <p> DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for Elasticsearch <code> <code>Limits</code> </code> for existing domain. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p> The instance type for an Elasticsearch cluster for which Elasticsearch <code> <code>Limits</code> </code> are needed. </p>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::EsPartitionInstanceType> {
        self.instance_type.as_ref()
    }
    /// <p> Version of Elasticsearch for which <code> <code>Limits</code> </code> are needed. </p>
    pub fn elasticsearch_version(&self) -> std::option::Option<&str> {
        self.elasticsearch_version.as_deref()
    }
}
impl std::fmt::Debug for DescribeElasticsearchInstanceTypeLimitsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeElasticsearchInstanceTypeLimitsInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("elasticsearch_version", &self.elasticsearch_version);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>DescribeElasticsearchDomains</code></code> operation. By default, the API returns the status of all Elasticsearch domains.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeElasticsearchDomainsInput {
    /// <p>The Elasticsearch domains for which you want information.</p>
    pub domain_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeElasticsearchDomainsInput {
    /// <p>The Elasticsearch domains for which you want information.</p>
    pub fn domain_names(&self) -> std::option::Option<&[std::string::String]> {
        self.domain_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeElasticsearchDomainsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeElasticsearchDomainsInput");
        formatter.field("domain_names", &self.domain_names);
        formatter.finish()
    }
}

/// <p> Container for the parameters to the <code>DescribeElasticsearchDomainConfig</code> operation. Specifies the domain name for which you want configuration information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeElasticsearchDomainConfigInput {
    /// <p>The Elasticsearch domain that you want to get information about.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DescribeElasticsearchDomainConfigInput {
    /// <p>The Elasticsearch domain that you want to get information about.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeElasticsearchDomainConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeElasticsearchDomainConfigInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>DescribeElasticsearchDomain</code></code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeElasticsearchDomainInput {
    /// <p>The name of the Elasticsearch domain for which you want information.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DescribeElasticsearchDomainInput {
    /// <p>The name of the Elasticsearch domain for which you want information.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeElasticsearchDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeElasticsearchDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code>DescribeDomainChangeProgress</code> operation. Specifies the domain name and optional change specific identity for which you want progress information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainChangeProgressInput {
    /// <p>The domain you want to get the progress information about.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
    pub change_id: std::option::Option<std::string::String>,
}
impl DescribeDomainChangeProgressInput {
    /// <p>The domain you want to get the progress information about.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>
    pub fn change_id(&self) -> std::option::Option<&str> {
        self.change_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeDomainChangeProgressInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainChangeProgressInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("change_id", &self.change_id);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainAutoTunesInput {
    /// <p>Specifies the domain name for which you want Auto-Tune action details.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub max_results: i32,
    /// <p>NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDomainAutoTunesInput {
    /// <p>Specifies the domain name for which you want Auto-Tune action details.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDomainAutoTunesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainAutoTunesInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Container for request parameters to <code> <code>DeletePackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePackageInput {
    /// <p>Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this value.</p>
    pub package_id: std::option::Option<std::string::String>,
}
impl DeletePackageInput {
    /// <p>Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this value.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
}
impl std::fmt::Debug for DeletePackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePackageInput");
        formatter.field("package_id", &self.package_id);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>DeleteOutboundCrossClusterSearchConnection</code></code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOutboundCrossClusterSearchConnectionInput {
    /// <p>The id of the outbound connection that you want to permanently delete.</p>
    pub cross_cluster_search_connection_id: std::option::Option<std::string::String>,
}
impl DeleteOutboundCrossClusterSearchConnectionInput {
    /// <p>The id of the outbound connection that you want to permanently delete.</p>
    pub fn cross_cluster_search_connection_id(&self) -> std::option::Option<&str> {
        self.cross_cluster_search_connection_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteOutboundCrossClusterSearchConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOutboundCrossClusterSearchConnectionInput");
        formatter.field(
            "cross_cluster_search_connection_id",
            &self.cross_cluster_search_connection_id,
        );
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>DeleteInboundCrossClusterSearchConnection</code></code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInboundCrossClusterSearchConnectionInput {
    /// <p>The id of the inbound connection that you want to permanently delete.</p>
    pub cross_cluster_search_connection_id: std::option::Option<std::string::String>,
}
impl DeleteInboundCrossClusterSearchConnectionInput {
    /// <p>The id of the inbound connection that you want to permanently delete.</p>
    pub fn cross_cluster_search_connection_id(&self) -> std::option::Option<&str> {
        self.cross_cluster_search_connection_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteInboundCrossClusterSearchConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInboundCrossClusterSearchConnectionInput");
        formatter.field(
            "cross_cluster_search_connection_id",
            &self.cross_cluster_search_connection_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteElasticsearchServiceRoleInput {}
impl std::fmt::Debug for DeleteElasticsearchServiceRoleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteElasticsearchServiceRoleInput");
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>DeleteElasticsearchDomain</code></code> operation. Specifies the name of the Elasticsearch domain that you want to delete.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteElasticsearchDomainInput {
    /// <p>The name of the Elasticsearch domain that you want to permanently delete.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DeleteElasticsearchDomainInput {
    /// <p>The name of the Elasticsearch domain that you want to permanently delete.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteElasticsearchDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteElasticsearchDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p> Container for request parameters to <code> <code>CreatePackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePackageInput {
    /// <p>Unique identifier for the package.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
    pub package_type: std::option::Option<crate::model::PackageType>,
    /// <p>Description of the package.</p>
    pub package_description: std::option::Option<std::string::String>,
    /// <p>The customer S3 location <code>PackageSource</code> for importing the package.</p>
    pub package_source: std::option::Option<crate::model::PackageSource>,
}
impl CreatePackageInput {
    /// <p>Unique identifier for the package.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
    pub fn package_type(&self) -> std::option::Option<&crate::model::PackageType> {
        self.package_type.as_ref()
    }
    /// <p>Description of the package.</p>
    pub fn package_description(&self) -> std::option::Option<&str> {
        self.package_description.as_deref()
    }
    /// <p>The customer S3 location <code>PackageSource</code> for importing the package.</p>
    pub fn package_source(&self) -> std::option::Option<&crate::model::PackageSource> {
        self.package_source.as_ref()
    }
}
impl std::fmt::Debug for CreatePackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePackageInput");
        formatter.field("package_name", &self.package_name);
        formatter.field("package_type", &self.package_type);
        formatter.field("package_description", &self.package_description);
        formatter.field("package_source", &self.package_source);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>CreateOutboundCrossClusterSearchConnection</code></code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOutboundCrossClusterSearchConnectionInput {
    /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
    pub source_domain_info: std::option::Option<crate::model::DomainInformation>,
    /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
    pub destination_domain_info: std::option::Option<crate::model::DomainInformation>,
    /// <p>Specifies the connection alias that will be used by the customer for this connection.</p>
    pub connection_alias: std::option::Option<std::string::String>,
}
impl CreateOutboundCrossClusterSearchConnectionInput {
    /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
    pub fn source_domain_info(&self) -> std::option::Option<&crate::model::DomainInformation> {
        self.source_domain_info.as_ref()
    }
    /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
    pub fn destination_domain_info(&self) -> std::option::Option<&crate::model::DomainInformation> {
        self.destination_domain_info.as_ref()
    }
    /// <p>Specifies the connection alias that will be used by the customer for this connection.</p>
    pub fn connection_alias(&self) -> std::option::Option<&str> {
        self.connection_alias.as_deref()
    }
}
impl std::fmt::Debug for CreateOutboundCrossClusterSearchConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOutboundCrossClusterSearchConnectionInput");
        formatter.field("source_domain_info", &self.source_domain_info);
        formatter.field("destination_domain_info", &self.destination_domain_info);
        formatter.field("connection_alias", &self.connection_alias);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateElasticsearchDomainInput {
    /// <p>The name of the Elasticsearch domain that you are creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>String of format X.Y to specify version for the Elasticsearch domain eg. "1.5" or "2.3". For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>
    pub elasticsearch_version: std::option::Option<std::string::String>,
    /// <p>Configuration options for an Elasticsearch domain. Specifies the instance type and number of instances in the domain cluster. </p>
    pub elasticsearch_cluster_config: std::option::Option<crate::model::ElasticsearchClusterConfig>,
    /// <p>Options to enable, disable and specify the type and size of EBS storage volumes. </p>
    pub ebs_options: std::option::Option<crate::model::EbsOptions>,
    /// <p> IAM access policy as a JSON-formatted string.</p>
    pub access_policies: std::option::Option<std::string::String>,
    /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours. </p>
    pub snapshot_options: std::option::Option<crate::model::SnapshotOptions>,
    /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
    pub vpc_options: std::option::Option<crate::model::VpcOptions>,
    /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
    pub cognito_options: std::option::Option<crate::model::CognitoOptions>,
    /// <p>Specifies the Encryption At Rest Options.</p>
    pub encryption_at_rest_options: std::option::Option<crate::model::EncryptionAtRestOptions>,
    /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
    pub node_to_node_encryption_options:
        std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
    /// <p> Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
    pub advanced_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
    pub log_publishing_options: std::option::Option<
        std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
    >,
    /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
    pub domain_endpoint_options: std::option::Option<crate::model::DomainEndpointOptions>,
    /// <p>Specifies advanced security options.</p>
    pub advanced_security_options: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
    /// <p>Specifies Auto-Tune options.</p>
    pub auto_tune_options: std::option::Option<crate::model::AutoTuneOptionsInput>,
    /// <p>A list of <code>Tag</code> added during domain creation.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateElasticsearchDomainInput {
    /// <p>The name of the Elasticsearch domain that you are creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>String of format X.Y to specify version for the Elasticsearch domain eg. "1.5" or "2.3". For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>
    pub fn elasticsearch_version(&self) -> std::option::Option<&str> {
        self.elasticsearch_version.as_deref()
    }
    /// <p>Configuration options for an Elasticsearch domain. Specifies the instance type and number of instances in the domain cluster. </p>
    pub fn elasticsearch_cluster_config(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchClusterConfig> {
        self.elasticsearch_cluster_config.as_ref()
    }
    /// <p>Options to enable, disable and specify the type and size of EBS storage volumes. </p>
    pub fn ebs_options(&self) -> std::option::Option<&crate::model::EbsOptions> {
        self.ebs_options.as_ref()
    }
    /// <p> IAM access policy as a JSON-formatted string.</p>
    pub fn access_policies(&self) -> std::option::Option<&str> {
        self.access_policies.as_deref()
    }
    /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours. </p>
    pub fn snapshot_options(&self) -> std::option::Option<&crate::model::SnapshotOptions> {
        self.snapshot_options.as_ref()
    }
    /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
    pub fn vpc_options(&self) -> std::option::Option<&crate::model::VpcOptions> {
        self.vpc_options.as_ref()
    }
    /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
    pub fn cognito_options(&self) -> std::option::Option<&crate::model::CognitoOptions> {
        self.cognito_options.as_ref()
    }
    /// <p>Specifies the Encryption At Rest Options.</p>
    pub fn encryption_at_rest_options(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionAtRestOptions> {
        self.encryption_at_rest_options.as_ref()
    }
    /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
    pub fn node_to_node_encryption_options(
        &self,
    ) -> std::option::Option<&crate::model::NodeToNodeEncryptionOptions> {
        self.node_to_node_encryption_options.as_ref()
    }
    /// <p> Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
    pub fn advanced_options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.advanced_options.as_ref()
    }
    /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
    pub fn log_publishing_options(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
    > {
        self.log_publishing_options.as_ref()
    }
    /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
    pub fn domain_endpoint_options(
        &self,
    ) -> std::option::Option<&crate::model::DomainEndpointOptions> {
        self.domain_endpoint_options.as_ref()
    }
    /// <p>Specifies advanced security options.</p>
    pub fn advanced_security_options(
        &self,
    ) -> std::option::Option<&crate::model::AdvancedSecurityOptionsInput> {
        self.advanced_security_options.as_ref()
    }
    /// <p>Specifies Auto-Tune options.</p>
    pub fn auto_tune_options(&self) -> std::option::Option<&crate::model::AutoTuneOptionsInput> {
        self.auto_tune_options.as_ref()
    }
    /// <p>A list of <code>Tag</code> added during domain creation.</p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for CreateElasticsearchDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateElasticsearchDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("elasticsearch_version", &self.elasticsearch_version);
        formatter.field(
            "elasticsearch_cluster_config",
            &self.elasticsearch_cluster_config,
        );
        formatter.field("ebs_options", &self.ebs_options);
        formatter.field("access_policies", &self.access_policies);
        formatter.field("snapshot_options", &self.snapshot_options);
        formatter.field("vpc_options", &self.vpc_options);
        formatter.field("cognito_options", &self.cognito_options);
        formatter.field(
            "encryption_at_rest_options",
            &self.encryption_at_rest_options,
        );
        formatter.field(
            "node_to_node_encryption_options",
            &self.node_to_node_encryption_options,
        );
        formatter.field("advanced_options", &self.advanced_options);
        formatter.field("log_publishing_options", &self.log_publishing_options);
        formatter.field("domain_endpoint_options", &self.domain_endpoint_options);
        formatter.field("advanced_security_options", &self.advanced_security_options);
        formatter.field("auto_tune_options", &self.auto_tune_options);
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>CancelElasticsearchServiceSoftwareUpdate</code></code> operation. Specifies the name of the Elasticsearch domain that you wish to cancel a service software update on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelElasticsearchServiceSoftwareUpdateInput {
    /// <p>The name of the domain that you want to stop the latest service software update on.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl CancelElasticsearchServiceSoftwareUpdateInput {
    /// <p>The name of the domain that you want to stop the latest service software update on.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for CancelElasticsearchServiceSoftwareUpdateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelElasticsearchServiceSoftwareUpdateInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p> Container for request parameters to <code> <code>AssociatePackage</code> </code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatePackageInput {
    /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>Name of the domain that you want to associate the package with.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl AssociatePackageInput {
    /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>Name of the domain that you want to associate the package with.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for AssociatePackageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatePackageInput");
        formatter.field("package_id", &self.package_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>AddTags</code></code> operation. Specify the tags that you want to attach to the Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsInput {
    /// <p> Specify the <code>ARN</code> for which you want to add the tags.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> List of <code>Tag</code> that need to be added for the Elasticsearch domain. </p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl AddTagsInput {
    /// <p> Specify the <code>ARN</code> for which you want to add the tags.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> List of <code>Tag</code> that need to be added for the Elasticsearch domain. </p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for AddTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsInput");
        formatter.field("arn", &self.arn);
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}

/// <p>Container for the parameters to the <code><code>AcceptInboundCrossClusterSearchConnection</code></code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptInboundCrossClusterSearchConnectionInput {
    /// <p>The id of the inbound connection that you want to accept.</p>
    pub cross_cluster_search_connection_id: std::option::Option<std::string::String>,
}
impl AcceptInboundCrossClusterSearchConnectionInput {
    /// <p>The id of the inbound connection that you want to accept.</p>
    pub fn cross_cluster_search_connection_id(&self) -> std::option::Option<&str> {
        self.cross_cluster_search_connection_id.as_deref()
    }
}
impl std::fmt::Debug for AcceptInboundCrossClusterSearchConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptInboundCrossClusterSearchConnectionInput");
        formatter.field(
            "cross_cluster_search_connection_id",
            &self.cross_cluster_search_connection_id,
        );
        formatter.finish()
    }
}
