// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptInboundCrossClusterSearchConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptInboundCrossClusterSearchConnectionError {
    /// Kind of error that occurred.
    pub kind: AcceptInboundCrossClusterSearchConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptInboundCrossClusterSearchConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptInboundCrossClusterSearchConnectionErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptInboundCrossClusterSearchConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(
                _inner,
            ) => _inner.fmt(f),
            AcceptInboundCrossClusterSearchConnectionErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            AcceptInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            AcceptInboundCrossClusterSearchConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptInboundCrossClusterSearchConnectionError {
    fn code(&self) -> Option<&str> {
        AcceptInboundCrossClusterSearchConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptInboundCrossClusterSearchConnectionError {
    /// Creates a new `AcceptInboundCrossClusterSearchConnectionError`.
    pub fn new(
        kind: AcceptInboundCrossClusterSearchConnectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptInboundCrossClusterSearchConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptInboundCrossClusterSearchConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptInboundCrossClusterSearchConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptInboundCrossClusterSearchConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInboundCrossClusterSearchConnectionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInboundCrossClusterSearchConnectionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AcceptInboundCrossClusterSearchConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(
                _inner,
            ) => Some(_inner),
            AcceptInboundCrossClusterSearchConnectionErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            AcceptInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            AcceptInboundCrossClusterSearchConnectionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsError {
    /// Kind of error that occurred.
    pub kind: AddTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsErrorKind::BaseException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::InternalException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsError {
    fn code(&self) -> Option<&str> {
        AddTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsError {
    /// Creates a new `AddTagsError`.
    pub fn new(kind: AddTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AddTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsErrorKind::BaseException(_inner) => Some(_inner),
            AddTagsErrorKind::InternalException(_inner) => Some(_inner),
            AddTagsErrorKind::LimitExceededException(_inner) => Some(_inner),
            AddTagsErrorKind::ValidationException(_inner) => Some(_inner),
            AddTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociatePackageError {
    /// Kind of error that occurred.
    pub kind: AssociatePackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociatePackageErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP status code 409.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociatePackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociatePackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociatePackageErrorKind::BaseException(_inner) => _inner.fmt(f),
            AssociatePackageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociatePackageErrorKind::InternalException(_inner) => _inner.fmt(f),
            AssociatePackageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociatePackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociatePackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociatePackageError {
    fn code(&self) -> Option<&str> {
        AssociatePackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociatePackageError {
    /// Creates a new `AssociatePackageError`.
    pub fn new(kind: AssociatePackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociatePackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociatePackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociatePackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociatePackageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociatePackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePackageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePackageErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, AssociatePackageErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `AssociatePackageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, AssociatePackageErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `AssociatePackageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, AssociatePackageErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `AssociatePackageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePackageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePackageErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociatePackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociatePackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociatePackageErrorKind::BaseException(_inner) => Some(_inner),
            AssociatePackageErrorKind::ConflictException(_inner) => Some(_inner),
            AssociatePackageErrorKind::InternalException(_inner) => Some(_inner),
            AssociatePackageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociatePackageErrorKind::ValidationException(_inner) => Some(_inner),
            AssociatePackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelElasticsearchServiceSoftwareUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelElasticsearchServiceSoftwareUpdateError {
    /// Kind of error that occurred.
    pub kind: CancelElasticsearchServiceSoftwareUpdateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelElasticsearchServiceSoftwareUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelElasticsearchServiceSoftwareUpdateErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelElasticsearchServiceSoftwareUpdateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelElasticsearchServiceSoftwareUpdateErrorKind::BaseException(_inner) => {
                _inner.fmt(f)
            }
            CancelElasticsearchServiceSoftwareUpdateErrorKind::InternalException(_inner) => {
                _inner.fmt(f)
            }
            CancelElasticsearchServiceSoftwareUpdateErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            CancelElasticsearchServiceSoftwareUpdateErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            CancelElasticsearchServiceSoftwareUpdateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelElasticsearchServiceSoftwareUpdateError {
    fn code(&self) -> Option<&str> {
        CancelElasticsearchServiceSoftwareUpdateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelElasticsearchServiceSoftwareUpdateError {
    /// Creates a new `CancelElasticsearchServiceSoftwareUpdateError`.
    pub fn new(
        kind: CancelElasticsearchServiceSoftwareUpdateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelElasticsearchServiceSoftwareUpdateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelElasticsearchServiceSoftwareUpdateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelElasticsearchServiceSoftwareUpdateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelElasticsearchServiceSoftwareUpdateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelElasticsearchServiceSoftwareUpdateErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelElasticsearchServiceSoftwareUpdateErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelElasticsearchServiceSoftwareUpdateErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelElasticsearchServiceSoftwareUpdateErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelElasticsearchServiceSoftwareUpdateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelElasticsearchServiceSoftwareUpdateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelElasticsearchServiceSoftwareUpdateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelElasticsearchServiceSoftwareUpdateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CancelElasticsearchServiceSoftwareUpdateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelElasticsearchServiceSoftwareUpdateErrorKind::BaseException(_inner) => {
                Some(_inner)
            }
            CancelElasticsearchServiceSoftwareUpdateErrorKind::InternalException(_inner) => {
                Some(_inner)
            }
            CancelElasticsearchServiceSoftwareUpdateErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            CancelElasticsearchServiceSoftwareUpdateErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            CancelElasticsearchServiceSoftwareUpdateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateElasticsearchDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateElasticsearchDomainError {
    /// Kind of error that occurred.
    pub kind: CreateElasticsearchDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateElasticsearchDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateElasticsearchDomainErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for creating a resource that already exists. Gives http status code of 400.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateElasticsearchDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateElasticsearchDomainErrorKind::BaseException(_inner) => _inner.fmt(f),
            CreateElasticsearchDomainErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            CreateElasticsearchDomainErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateElasticsearchDomainErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            CreateElasticsearchDomainErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateElasticsearchDomainErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateElasticsearchDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateElasticsearchDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateElasticsearchDomainError {
    fn code(&self) -> Option<&str> {
        CreateElasticsearchDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateElasticsearchDomainError {
    /// Creates a new `CreateElasticsearchDomainError`.
    pub fn new(kind: CreateElasticsearchDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateElasticsearchDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateElasticsearchDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateElasticsearchDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateElasticsearchDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateElasticsearchDomainErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateElasticsearchDomainErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateElasticsearchDomainErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateElasticsearchDomainErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateElasticsearchDomainErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateElasticsearchDomainErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateElasticsearchDomainErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateElasticsearchDomainErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateElasticsearchDomainErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateElasticsearchDomainErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateElasticsearchDomainErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateElasticsearchDomainErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateElasticsearchDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateElasticsearchDomainErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateElasticsearchDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateElasticsearchDomainErrorKind::BaseException(_inner) => Some(_inner),
            CreateElasticsearchDomainErrorKind::DisabledOperationException(_inner) => Some(_inner),
            CreateElasticsearchDomainErrorKind::InternalException(_inner) => Some(_inner),
            CreateElasticsearchDomainErrorKind::InvalidTypeException(_inner) => Some(_inner),
            CreateElasticsearchDomainErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateElasticsearchDomainErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateElasticsearchDomainErrorKind::ValidationException(_inner) => Some(_inner),
            CreateElasticsearchDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateOutboundCrossClusterSearchConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateOutboundCrossClusterSearchConnectionError {
    /// Kind of error that occurred.
    pub kind: CreateOutboundCrossClusterSearchConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateOutboundCrossClusterSearchConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateOutboundCrossClusterSearchConnectionErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for creating a resource that already exists. Gives http status code of 400.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateOutboundCrossClusterSearchConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateOutboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(
                _inner,
            ) => _inner.fmt(f),
            CreateOutboundCrossClusterSearchConnectionErrorKind::InternalException(_inner) => {
                _inner.fmt(f)
            }
            CreateOutboundCrossClusterSearchConnectionErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateOutboundCrossClusterSearchConnectionErrorKind::ResourceAlreadyExistsException(
                _inner,
            ) => _inner.fmt(f),
            CreateOutboundCrossClusterSearchConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateOutboundCrossClusterSearchConnectionError {
    fn code(&self) -> Option<&str> {
        CreateOutboundCrossClusterSearchConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateOutboundCrossClusterSearchConnectionError {
    /// Creates a new `CreateOutboundCrossClusterSearchConnectionError`.
    pub fn new(
        kind: CreateOutboundCrossClusterSearchConnectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateOutboundCrossClusterSearchConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateOutboundCrossClusterSearchConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateOutboundCrossClusterSearchConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateOutboundCrossClusterSearchConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateOutboundCrossClusterSearchConnectionErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOutboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOutboundCrossClusterSearchConnectionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOutboundCrossClusterSearchConnectionErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOutboundCrossClusterSearchConnectionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOutboundCrossClusterSearchConnectionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOutboundCrossClusterSearchConnectionErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOutboundCrossClusterSearchConnectionErrorKind::ResourceAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateOutboundCrossClusterSearchConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateOutboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(
                _inner,
            ) => Some(_inner),
            CreateOutboundCrossClusterSearchConnectionErrorKind::InternalException(_inner) => {
                Some(_inner)
            }
            CreateOutboundCrossClusterSearchConnectionErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateOutboundCrossClusterSearchConnectionErrorKind::ResourceAlreadyExistsException(
                _inner,
            ) => Some(_inner),
            CreateOutboundCrossClusterSearchConnectionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePackageError {
    /// Kind of error that occurred.
    pub kind: CreatePackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePackageErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for creating a resource that already exists. Gives http status code of 400.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::BaseException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePackageError {
    fn code(&self) -> Option<&str> {
        CreatePackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePackageError {
    /// Creates a new `CreatePackageError`.
    pub fn new(kind: CreatePackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePackageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreatePackageErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreatePackageErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, CreatePackageErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `CreatePackageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreatePackageErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `CreatePackageErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(&self.kind, CreatePackageErrorKind::InvalidTypeException(_))
    }
    /// Returns `true` if the error kind is `CreatePackageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackageErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackageErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackageErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreatePackageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreatePackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePackageErrorKind::BaseException(_inner) => Some(_inner),
            CreatePackageErrorKind::InternalException(_inner) => Some(_inner),
            CreatePackageErrorKind::InvalidTypeException(_inner) => Some(_inner),
            CreatePackageErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePackageErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreatePackageErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteElasticsearchDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteElasticsearchDomainError {
    /// Kind of error that occurred.
    pub kind: DeleteElasticsearchDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteElasticsearchDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteElasticsearchDomainErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteElasticsearchDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteElasticsearchDomainErrorKind::BaseException(_inner) => _inner.fmt(f),
            DeleteElasticsearchDomainErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteElasticsearchDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteElasticsearchDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteElasticsearchDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteElasticsearchDomainError {
    fn code(&self) -> Option<&str> {
        DeleteElasticsearchDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteElasticsearchDomainError {
    /// Creates a new `DeleteElasticsearchDomainError`.
    pub fn new(kind: DeleteElasticsearchDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteElasticsearchDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteElasticsearchDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteElasticsearchDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteElasticsearchDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteElasticsearchDomainErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteElasticsearchDomainErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteElasticsearchDomainErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteElasticsearchDomainErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteElasticsearchDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteElasticsearchDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteElasticsearchDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteElasticsearchDomainErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteElasticsearchDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteElasticsearchDomainErrorKind::BaseException(_inner) => Some(_inner),
            DeleteElasticsearchDomainErrorKind::InternalException(_inner) => Some(_inner),
            DeleteElasticsearchDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteElasticsearchDomainErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteElasticsearchDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteElasticsearchServiceRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteElasticsearchServiceRoleError {
    /// Kind of error that occurred.
    pub kind: DeleteElasticsearchServiceRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteElasticsearchServiceRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteElasticsearchServiceRoleErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteElasticsearchServiceRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteElasticsearchServiceRoleErrorKind::BaseException(_inner) => _inner.fmt(f),
            DeleteElasticsearchServiceRoleErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteElasticsearchServiceRoleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteElasticsearchServiceRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteElasticsearchServiceRoleError {
    fn code(&self) -> Option<&str> {
        DeleteElasticsearchServiceRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteElasticsearchServiceRoleError {
    /// Creates a new `DeleteElasticsearchServiceRoleError`.
    pub fn new(
        kind: DeleteElasticsearchServiceRoleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteElasticsearchServiceRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteElasticsearchServiceRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteElasticsearchServiceRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteElasticsearchServiceRoleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteElasticsearchServiceRoleErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteElasticsearchServiceRoleErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteElasticsearchServiceRoleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteElasticsearchServiceRoleErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteElasticsearchServiceRoleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteElasticsearchServiceRoleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteElasticsearchServiceRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteElasticsearchServiceRoleErrorKind::BaseException(_inner) => Some(_inner),
            DeleteElasticsearchServiceRoleErrorKind::InternalException(_inner) => Some(_inner),
            DeleteElasticsearchServiceRoleErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteElasticsearchServiceRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInboundCrossClusterSearchConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInboundCrossClusterSearchConnectionError {
    /// Kind of error that occurred.
    pub kind: DeleteInboundCrossClusterSearchConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInboundCrossClusterSearchConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInboundCrossClusterSearchConnectionErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInboundCrossClusterSearchConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(
                _inner,
            ) => _inner.fmt(f),
            DeleteInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DeleteInboundCrossClusterSearchConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInboundCrossClusterSearchConnectionError {
    fn code(&self) -> Option<&str> {
        DeleteInboundCrossClusterSearchConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInboundCrossClusterSearchConnectionError {
    /// Creates a new `DeleteInboundCrossClusterSearchConnectionError`.
    pub fn new(
        kind: DeleteInboundCrossClusterSearchConnectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInboundCrossClusterSearchConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInboundCrossClusterSearchConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInboundCrossClusterSearchConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInboundCrossClusterSearchConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteInboundCrossClusterSearchConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(
                _inner,
            ) => Some(_inner),
            DeleteInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            DeleteInboundCrossClusterSearchConnectionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteOutboundCrossClusterSearchConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOutboundCrossClusterSearchConnectionError {
    /// Kind of error that occurred.
    pub kind: DeleteOutboundCrossClusterSearchConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOutboundCrossClusterSearchConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOutboundCrossClusterSearchConnectionErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOutboundCrossClusterSearchConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOutboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(
                _inner,
            ) => _inner.fmt(f),
            DeleteOutboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DeleteOutboundCrossClusterSearchConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOutboundCrossClusterSearchConnectionError {
    fn code(&self) -> Option<&str> {
        DeleteOutboundCrossClusterSearchConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteOutboundCrossClusterSearchConnectionError {
    /// Creates a new `DeleteOutboundCrossClusterSearchConnectionError`.
    pub fn new(
        kind: DeleteOutboundCrossClusterSearchConnectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOutboundCrossClusterSearchConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOutboundCrossClusterSearchConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOutboundCrossClusterSearchConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOutboundCrossClusterSearchConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteOutboundCrossClusterSearchConnectionErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOutboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOutboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOutboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteOutboundCrossClusterSearchConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOutboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(
                _inner,
            ) => Some(_inner),
            DeleteOutboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            DeleteOutboundCrossClusterSearchConnectionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeletePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePackageError {
    /// Kind of error that occurred.
    pub kind: DeletePackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePackageErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP status code 409.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::BaseException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePackageError {
    fn code(&self) -> Option<&str> {
        DeletePackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePackageError {
    /// Creates a new `DeletePackageError`.
    pub fn new(kind: DeletePackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePackageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeletePackageErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeletePackageErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DeletePackageErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `DeletePackageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeletePackageErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeletePackageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeletePackageErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DeletePackageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeletePackageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeletePackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePackageErrorKind::BaseException(_inner) => Some(_inner),
            DeletePackageErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePackageErrorKind::InternalException(_inner) => Some(_inner),
            DeletePackageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePackageErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDomainAutoTunes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDomainAutoTunesError {
    /// Kind of error that occurred.
    pub kind: DescribeDomainAutoTunesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDomainAutoTunes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDomainAutoTunesErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDomainAutoTunesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDomainAutoTunesErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeDomainAutoTunesErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeDomainAutoTunesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDomainAutoTunesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeDomainAutoTunesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDomainAutoTunesError {
    fn code(&self) -> Option<&str> {
        DescribeDomainAutoTunesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDomainAutoTunesError {
    /// Creates a new `DescribeDomainAutoTunesError`.
    pub fn new(kind: DescribeDomainAutoTunesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDomainAutoTunesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDomainAutoTunesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDomainAutoTunesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDomainAutoTunesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDomainAutoTunesErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainAutoTunesErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainAutoTunesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainAutoTunesErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainAutoTunesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainAutoTunesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainAutoTunesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainAutoTunesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeDomainAutoTunesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDomainAutoTunesErrorKind::BaseException(_inner) => Some(_inner),
            DescribeDomainAutoTunesErrorKind::InternalException(_inner) => Some(_inner),
            DescribeDomainAutoTunesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDomainAutoTunesErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeDomainAutoTunesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeElasticsearchDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeElasticsearchDomainError {
    /// Kind of error that occurred.
    pub kind: DescribeElasticsearchDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeElasticsearchDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeElasticsearchDomainErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeElasticsearchDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeElasticsearchDomainErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeElasticsearchDomainErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeElasticsearchDomainErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeElasticsearchDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeElasticsearchDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeElasticsearchDomainError {
    fn code(&self) -> Option<&str> {
        DescribeElasticsearchDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeElasticsearchDomainError {
    /// Creates a new `DescribeElasticsearchDomainError`.
    pub fn new(kind: DescribeElasticsearchDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeElasticsearchDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeElasticsearchDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeElasticsearchDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeElasticsearchDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchDomainErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchDomainErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchDomainErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchDomainErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchDomainErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeElasticsearchDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeElasticsearchDomainErrorKind::BaseException(_inner) => Some(_inner),
            DescribeElasticsearchDomainErrorKind::InternalException(_inner) => Some(_inner),
            DescribeElasticsearchDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeElasticsearchDomainErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeElasticsearchDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeElasticsearchDomainConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeElasticsearchDomainConfigError {
    /// Kind of error that occurred.
    pub kind: DescribeElasticsearchDomainConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeElasticsearchDomainConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeElasticsearchDomainConfigErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeElasticsearchDomainConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeElasticsearchDomainConfigErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeElasticsearchDomainConfigErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeElasticsearchDomainConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeElasticsearchDomainConfigErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeElasticsearchDomainConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeElasticsearchDomainConfigError {
    fn code(&self) -> Option<&str> {
        DescribeElasticsearchDomainConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeElasticsearchDomainConfigError {
    /// Creates a new `DescribeElasticsearchDomainConfigError`.
    pub fn new(
        kind: DescribeElasticsearchDomainConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeElasticsearchDomainConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeElasticsearchDomainConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeElasticsearchDomainConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeElasticsearchDomainConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchDomainConfigErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchDomainConfigErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchDomainConfigErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchDomainConfigErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchDomainConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchDomainConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchDomainConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchDomainConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeElasticsearchDomainConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeElasticsearchDomainConfigErrorKind::BaseException(_inner) => Some(_inner),
            DescribeElasticsearchDomainConfigErrorKind::InternalException(_inner) => Some(_inner),
            DescribeElasticsearchDomainConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeElasticsearchDomainConfigErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeElasticsearchDomainConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeElasticsearchDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeElasticsearchDomainsError {
    /// Kind of error that occurred.
    pub kind: DescribeElasticsearchDomainsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeElasticsearchDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeElasticsearchDomainsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeElasticsearchDomainsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeElasticsearchDomainsErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeElasticsearchDomainsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeElasticsearchDomainsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeElasticsearchDomainsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeElasticsearchDomainsError {
    fn code(&self) -> Option<&str> {
        DescribeElasticsearchDomainsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeElasticsearchDomainsError {
    /// Creates a new `DescribeElasticsearchDomainsError`.
    pub fn new(kind: DescribeElasticsearchDomainsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeElasticsearchDomainsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeElasticsearchDomainsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeElasticsearchDomainsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeElasticsearchDomainsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchDomainsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchDomainsErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchDomainsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchDomainsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchDomainsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchDomainsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeElasticsearchDomainsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeElasticsearchDomainsErrorKind::BaseException(_inner) => Some(_inner),
            DescribeElasticsearchDomainsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeElasticsearchDomainsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeElasticsearchDomainsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeElasticsearchInstanceTypeLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeElasticsearchInstanceTypeLimitsError {
    /// Kind of error that occurred.
    pub kind: DescribeElasticsearchInstanceTypeLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeElasticsearchInstanceTypeLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeElasticsearchInstanceTypeLimitsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeElasticsearchInstanceTypeLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeElasticsearchInstanceTypeLimitsErrorKind::BaseException(_inner) => {
                _inner.fmt(f)
            }
            DescribeElasticsearchInstanceTypeLimitsErrorKind::InternalException(_inner) => {
                _inner.fmt(f)
            }
            DescribeElasticsearchInstanceTypeLimitsErrorKind::InvalidTypeException(_inner) => {
                _inner.fmt(f)
            }
            DescribeElasticsearchInstanceTypeLimitsErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            DescribeElasticsearchInstanceTypeLimitsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeElasticsearchInstanceTypeLimitsErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeElasticsearchInstanceTypeLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeElasticsearchInstanceTypeLimitsError {
    fn code(&self) -> Option<&str> {
        DescribeElasticsearchInstanceTypeLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeElasticsearchInstanceTypeLimitsError {
    /// Creates a new `DescribeElasticsearchInstanceTypeLimitsError`.
    pub fn new(
        kind: DescribeElasticsearchInstanceTypeLimitsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeElasticsearchInstanceTypeLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeElasticsearchInstanceTypeLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeElasticsearchInstanceTypeLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeElasticsearchInstanceTypeLimitsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchInstanceTypeLimitsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchInstanceTypeLimitsErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchInstanceTypeLimitsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchInstanceTypeLimitsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchInstanceTypeLimitsErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchInstanceTypeLimitsErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchInstanceTypeLimitsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchInstanceTypeLimitsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchInstanceTypeLimitsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchInstanceTypeLimitsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeElasticsearchInstanceTypeLimitsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeElasticsearchInstanceTypeLimitsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeElasticsearchInstanceTypeLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeElasticsearchInstanceTypeLimitsErrorKind::BaseException(_inner) => Some(_inner),
            DescribeElasticsearchInstanceTypeLimitsErrorKind::InternalException(_inner) => {
                Some(_inner)
            }
            DescribeElasticsearchInstanceTypeLimitsErrorKind::InvalidTypeException(_inner) => {
                Some(_inner)
            }
            DescribeElasticsearchInstanceTypeLimitsErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            DescribeElasticsearchInstanceTypeLimitsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeElasticsearchInstanceTypeLimitsErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DescribeElasticsearchInstanceTypeLimitsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeInboundCrossClusterSearchConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInboundCrossClusterSearchConnectionsError {
    /// Kind of error that occurred.
    pub kind: DescribeInboundCrossClusterSearchConnectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInboundCrossClusterSearchConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInboundCrossClusterSearchConnectionsErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of invalid pagination token provided by customer. Returns an HTTP status code of 400. </p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInboundCrossClusterSearchConnectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInboundCrossClusterSearchConnectionsErrorKind::DisabledOperationException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeInboundCrossClusterSearchConnectionsErrorKind::InvalidPaginationTokenException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeInboundCrossClusterSearchConnectionsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DescribeInboundCrossClusterSearchConnectionsError
{
    fn code(&self) -> Option<&str> {
        DescribeInboundCrossClusterSearchConnectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInboundCrossClusterSearchConnectionsError {
    /// Creates a new `DescribeInboundCrossClusterSearchConnectionsError`.
    pub fn new(
        kind: DescribeInboundCrossClusterSearchConnectionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInboundCrossClusterSearchConnectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInboundCrossClusterSearchConnectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInboundCrossClusterSearchConnectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInboundCrossClusterSearchConnectionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInboundCrossClusterSearchConnectionsErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInboundCrossClusterSearchConnectionsErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInboundCrossClusterSearchConnectionsErrorKind::InvalidPaginationTokenException`.
    pub fn is_invalid_pagination_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInboundCrossClusterSearchConnectionsErrorKind::InvalidPaginationTokenException(
                _
            )
        )
    }
}
impl std::error::Error for DescribeInboundCrossClusterSearchConnectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInboundCrossClusterSearchConnectionsErrorKind::DisabledOperationException(_inner) =>
            Some(_inner)
            ,
            DescribeInboundCrossClusterSearchConnectionsErrorKind::InvalidPaginationTokenException(_inner) =>
            Some(_inner)
            ,
            DescribeInboundCrossClusterSearchConnectionsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeOutboundCrossClusterSearchConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOutboundCrossClusterSearchConnectionsError {
    /// Kind of error that occurred.
    pub kind: DescribeOutboundCrossClusterSearchConnectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOutboundCrossClusterSearchConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOutboundCrossClusterSearchConnectionsErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of invalid pagination token provided by customer. Returns an HTTP status code of 400. </p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOutboundCrossClusterSearchConnectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOutboundCrossClusterSearchConnectionsErrorKind::DisabledOperationException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOutboundCrossClusterSearchConnectionsErrorKind::InvalidPaginationTokenException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOutboundCrossClusterSearchConnectionsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DescribeOutboundCrossClusterSearchConnectionsError
{
    fn code(&self) -> Option<&str> {
        DescribeOutboundCrossClusterSearchConnectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOutboundCrossClusterSearchConnectionsError {
    /// Creates a new `DescribeOutboundCrossClusterSearchConnectionsError`.
    pub fn new(
        kind: DescribeOutboundCrossClusterSearchConnectionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOutboundCrossClusterSearchConnectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOutboundCrossClusterSearchConnectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOutboundCrossClusterSearchConnectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOutboundCrossClusterSearchConnectionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOutboundCrossClusterSearchConnectionsErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOutboundCrossClusterSearchConnectionsErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOutboundCrossClusterSearchConnectionsErrorKind::InvalidPaginationTokenException`.
    pub fn is_invalid_pagination_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOutboundCrossClusterSearchConnectionsErrorKind::InvalidPaginationTokenException(
                _
            )
        )
    }
}
impl std::error::Error for DescribeOutboundCrossClusterSearchConnectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOutboundCrossClusterSearchConnectionsErrorKind::DisabledOperationException(_inner) =>
            Some(_inner)
            ,
            DescribeOutboundCrossClusterSearchConnectionsErrorKind::InvalidPaginationTokenException(_inner) =>
            Some(_inner)
            ,
            DescribeOutboundCrossClusterSearchConnectionsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribePackages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePackagesError {
    /// Kind of error that occurred.
    pub kind: DescribePackagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePackages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePackagesErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePackagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePackagesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribePackagesErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribePackagesErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribePackagesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePackagesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribePackagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePackagesError {
    fn code(&self) -> Option<&str> {
        DescribePackagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePackagesError {
    /// Creates a new `DescribePackagesError`.
    pub fn new(kind: DescribePackagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePackagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePackagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePackagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePackagesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePackagesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackagesErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DescribePackagesErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `DescribePackagesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DescribePackagesErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DescribePackagesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackagesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribePackagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePackagesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribePackagesErrorKind::BaseException(_inner) => Some(_inner),
            DescribePackagesErrorKind::InternalException(_inner) => Some(_inner),
            DescribePackagesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePackagesErrorKind::ValidationException(_inner) => Some(_inner),
            DescribePackagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReservedElasticsearchInstanceOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReservedElasticsearchInstanceOfferingsError {
    /// Kind of error that occurred.
    pub kind: DescribeReservedElasticsearchInstanceOfferingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReservedElasticsearchInstanceOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReservedElasticsearchInstanceOfferingsErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReservedElasticsearchInstanceOfferingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::DisabledOperationException(
                _inner,
            ) => _inner.fmt(f),
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::InternalException(_inner) => {
                _inner.fmt(f)
            }
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::ValidationException(
                _inner,
            ) => _inner.fmt(f),
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DescribeReservedElasticsearchInstanceOfferingsError
{
    fn code(&self) -> Option<&str> {
        DescribeReservedElasticsearchInstanceOfferingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReservedElasticsearchInstanceOfferingsError {
    /// Creates a new `DescribeReservedElasticsearchInstanceOfferingsError`.
    pub fn new(
        kind: DescribeReservedElasticsearchInstanceOfferingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReservedElasticsearchInstanceOfferingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReservedElasticsearchInstanceOfferingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReservedElasticsearchInstanceOfferingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReservedElasticsearchInstanceOfferingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReservedElasticsearchInstanceOfferingsErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservedElasticsearchInstanceOfferingsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservedElasticsearchInstanceOfferingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservedElasticsearchInstanceOfferingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeReservedElasticsearchInstanceOfferingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::DisabledOperationException(
                _inner,
            ) => Some(_inner),
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::InternalException(_inner) => {
                Some(_inner)
            }
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::ValidationException(
                _inner,
            ) => Some(_inner),
            DescribeReservedElasticsearchInstanceOfferingsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeReservedElasticsearchInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReservedElasticsearchInstancesError {
    /// Kind of error that occurred.
    pub kind: DescribeReservedElasticsearchInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReservedElasticsearchInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReservedElasticsearchInstancesErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReservedElasticsearchInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReservedElasticsearchInstancesErrorKind::DisabledOperationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeReservedElasticsearchInstancesErrorKind::InternalException(_inner) => {
                _inner.fmt(f)
            }
            DescribeReservedElasticsearchInstancesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeReservedElasticsearchInstancesErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeReservedElasticsearchInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReservedElasticsearchInstancesError {
    fn code(&self) -> Option<&str> {
        DescribeReservedElasticsearchInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReservedElasticsearchInstancesError {
    /// Creates a new `DescribeReservedElasticsearchInstancesError`.
    pub fn new(
        kind: DescribeReservedElasticsearchInstancesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReservedElasticsearchInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReservedElasticsearchInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReservedElasticsearchInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReservedElasticsearchInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReservedElasticsearchInstancesErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedElasticsearchInstancesErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservedElasticsearchInstancesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedElasticsearchInstancesErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservedElasticsearchInstancesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedElasticsearchInstancesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservedElasticsearchInstancesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedElasticsearchInstancesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeReservedElasticsearchInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReservedElasticsearchInstancesErrorKind::DisabledOperationException(_inner) => {
                Some(_inner)
            }
            DescribeReservedElasticsearchInstancesErrorKind::InternalException(_inner) => {
                Some(_inner)
            }
            DescribeReservedElasticsearchInstancesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeReservedElasticsearchInstancesErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DescribeReservedElasticsearchInstancesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DissociatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DissociatePackageError {
    /// Kind of error that occurred.
    pub kind: DissociatePackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DissociatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DissociatePackageErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP status code 409.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DissociatePackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DissociatePackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DissociatePackageErrorKind::BaseException(_inner) => _inner.fmt(f),
            DissociatePackageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DissociatePackageErrorKind::InternalException(_inner) => _inner.fmt(f),
            DissociatePackageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DissociatePackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DissociatePackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DissociatePackageError {
    fn code(&self) -> Option<&str> {
        DissociatePackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DissociatePackageError {
    /// Creates a new `DissociatePackageError`.
    pub fn new(kind: DissociatePackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DissociatePackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DissociatePackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DissociatePackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DissociatePackageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DissociatePackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DissociatePackageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DissociatePackageErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DissociatePackageErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `DissociatePackageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DissociatePackageErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DissociatePackageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DissociatePackageErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DissociatePackageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DissociatePackageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DissociatePackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DissociatePackageErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DissociatePackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DissociatePackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DissociatePackageErrorKind::BaseException(_inner) => Some(_inner),
            DissociatePackageErrorKind::ConflictException(_inner) => Some(_inner),
            DissociatePackageErrorKind::InternalException(_inner) => Some(_inner),
            DissociatePackageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DissociatePackageErrorKind::ValidationException(_inner) => Some(_inner),
            DissociatePackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCompatibleElasticsearchVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCompatibleElasticsearchVersionsError {
    /// Kind of error that occurred.
    pub kind: GetCompatibleElasticsearchVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCompatibleElasticsearchVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCompatibleElasticsearchVersionsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCompatibleElasticsearchVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCompatibleElasticsearchVersionsErrorKind::BaseException(_inner) => _inner.fmt(f),
            GetCompatibleElasticsearchVersionsErrorKind::DisabledOperationException(_inner) => {
                _inner.fmt(f)
            }
            GetCompatibleElasticsearchVersionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetCompatibleElasticsearchVersionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetCompatibleElasticsearchVersionsErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            GetCompatibleElasticsearchVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCompatibleElasticsearchVersionsError {
    fn code(&self) -> Option<&str> {
        GetCompatibleElasticsearchVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCompatibleElasticsearchVersionsError {
    /// Creates a new `GetCompatibleElasticsearchVersionsError`.
    pub fn new(
        kind: GetCompatibleElasticsearchVersionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCompatibleElasticsearchVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCompatibleElasticsearchVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCompatibleElasticsearchVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCompatibleElasticsearchVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCompatibleElasticsearchVersionsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCompatibleElasticsearchVersionsErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCompatibleElasticsearchVersionsErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCompatibleElasticsearchVersionsErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCompatibleElasticsearchVersionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCompatibleElasticsearchVersionsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCompatibleElasticsearchVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCompatibleElasticsearchVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCompatibleElasticsearchVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCompatibleElasticsearchVersionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetCompatibleElasticsearchVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCompatibleElasticsearchVersionsErrorKind::BaseException(_inner) => Some(_inner),
            GetCompatibleElasticsearchVersionsErrorKind::DisabledOperationException(_inner) => {
                Some(_inner)
            }
            GetCompatibleElasticsearchVersionsErrorKind::InternalException(_inner) => Some(_inner),
            GetCompatibleElasticsearchVersionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetCompatibleElasticsearchVersionsErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            GetCompatibleElasticsearchVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPackageVersionHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPackageVersionHistoryError {
    /// Kind of error that occurred.
    pub kind: GetPackageVersionHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPackageVersionHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPackageVersionHistoryErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPackageVersionHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPackageVersionHistoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetPackageVersionHistoryErrorKind::BaseException(_inner) => _inner.fmt(f),
            GetPackageVersionHistoryErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetPackageVersionHistoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPackageVersionHistoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPackageVersionHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPackageVersionHistoryError {
    fn code(&self) -> Option<&str> {
        GetPackageVersionHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPackageVersionHistoryError {
    /// Creates a new `GetPackageVersionHistoryError`.
    pub fn new(kind: GetPackageVersionHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPackageVersionHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPackageVersionHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPackageVersionHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPackageVersionHistoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPackageVersionHistoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionHistoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPackageVersionHistoryErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionHistoryErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPackageVersionHistoryErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionHistoryErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPackageVersionHistoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionHistoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPackageVersionHistoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionHistoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetPackageVersionHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPackageVersionHistoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetPackageVersionHistoryErrorKind::BaseException(_inner) => Some(_inner),
            GetPackageVersionHistoryErrorKind::InternalException(_inner) => Some(_inner),
            GetPackageVersionHistoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPackageVersionHistoryErrorKind::ValidationException(_inner) => Some(_inner),
            GetPackageVersionHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUpgradeHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUpgradeHistoryError {
    /// Kind of error that occurred.
    pub kind: GetUpgradeHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUpgradeHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUpgradeHistoryErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUpgradeHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUpgradeHistoryErrorKind::BaseException(_inner) => _inner.fmt(f),
            GetUpgradeHistoryErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            GetUpgradeHistoryErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetUpgradeHistoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetUpgradeHistoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetUpgradeHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUpgradeHistoryError {
    fn code(&self) -> Option<&str> {
        GetUpgradeHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUpgradeHistoryError {
    /// Creates a new `GetUpgradeHistoryError`.
    pub fn new(kind: GetUpgradeHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUpgradeHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUpgradeHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUpgradeHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUpgradeHistoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUpgradeHistoryErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, GetUpgradeHistoryErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `GetUpgradeHistoryErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUpgradeHistoryErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUpgradeHistoryErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, GetUpgradeHistoryErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `GetUpgradeHistoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUpgradeHistoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUpgradeHistoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUpgradeHistoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetUpgradeHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUpgradeHistoryErrorKind::BaseException(_inner) => Some(_inner),
            GetUpgradeHistoryErrorKind::DisabledOperationException(_inner) => Some(_inner),
            GetUpgradeHistoryErrorKind::InternalException(_inner) => Some(_inner),
            GetUpgradeHistoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetUpgradeHistoryErrorKind::ValidationException(_inner) => Some(_inner),
            GetUpgradeHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUpgradeStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUpgradeStatusError {
    /// Kind of error that occurred.
    pub kind: GetUpgradeStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUpgradeStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUpgradeStatusErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUpgradeStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUpgradeStatusErrorKind::BaseException(_inner) => _inner.fmt(f),
            GetUpgradeStatusErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            GetUpgradeStatusErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetUpgradeStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetUpgradeStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetUpgradeStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUpgradeStatusError {
    fn code(&self) -> Option<&str> {
        GetUpgradeStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUpgradeStatusError {
    /// Creates a new `GetUpgradeStatusError`.
    pub fn new(kind: GetUpgradeStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUpgradeStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUpgradeStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUpgradeStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUpgradeStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUpgradeStatusErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, GetUpgradeStatusErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `GetUpgradeStatusErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUpgradeStatusErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUpgradeStatusErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, GetUpgradeStatusErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `GetUpgradeStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUpgradeStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUpgradeStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUpgradeStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetUpgradeStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUpgradeStatusErrorKind::BaseException(_inner) => Some(_inner),
            GetUpgradeStatusErrorKind::DisabledOperationException(_inner) => Some(_inner),
            GetUpgradeStatusErrorKind::InternalException(_inner) => Some(_inner),
            GetUpgradeStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetUpgradeStatusErrorKind::ValidationException(_inner) => Some(_inner),
            GetUpgradeStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomainNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainNamesError {
    /// Kind of error that occurred.
    pub kind: ListDomainNamesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomainNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainNamesErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainNamesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainNamesErrorKind::BaseException(_inner) => _inner.fmt(f),
            ListDomainNamesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDomainNamesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainNamesError {
    fn code(&self) -> Option<&str> {
        ListDomainNamesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainNamesError {
    /// Creates a new `ListDomainNamesError`.
    pub fn new(kind: ListDomainNamesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainNamesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainNamesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainNamesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainNamesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDomainNamesErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, ListDomainNamesErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `ListDomainNamesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListDomainNamesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListDomainNamesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainNamesErrorKind::BaseException(_inner) => Some(_inner),
            ListDomainNamesErrorKind::ValidationException(_inner) => Some(_inner),
            ListDomainNamesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomainsForPackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainsForPackageError {
    /// Kind of error that occurred.
    pub kind: ListDomainsForPackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomainsForPackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainsForPackageErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainsForPackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainsForPackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDomainsForPackageErrorKind::BaseException(_inner) => _inner.fmt(f),
            ListDomainsForPackageErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListDomainsForPackageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDomainsForPackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDomainsForPackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainsForPackageError {
    fn code(&self) -> Option<&str> {
        ListDomainsForPackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainsForPackageError {
    /// Creates a new `ListDomainsForPackageError`.
    pub fn new(kind: ListDomainsForPackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainsForPackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainsForPackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainsForPackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainsForPackageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDomainsForPackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainsForPackageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainsForPackageErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsForPackageErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `ListDomainsForPackageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainsForPackageErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainsForPackageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainsForPackageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainsForPackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainsForPackageErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListDomainsForPackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainsForPackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDomainsForPackageErrorKind::BaseException(_inner) => Some(_inner),
            ListDomainsForPackageErrorKind::InternalException(_inner) => Some(_inner),
            ListDomainsForPackageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDomainsForPackageErrorKind::ValidationException(_inner) => Some(_inner),
            ListDomainsForPackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListElasticsearchInstanceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListElasticsearchInstanceTypesError {
    /// Kind of error that occurred.
    pub kind: ListElasticsearchInstanceTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListElasticsearchInstanceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListElasticsearchInstanceTypesErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListElasticsearchInstanceTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListElasticsearchInstanceTypesErrorKind::BaseException(_inner) => _inner.fmt(f),
            ListElasticsearchInstanceTypesErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListElasticsearchInstanceTypesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListElasticsearchInstanceTypesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListElasticsearchInstanceTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListElasticsearchInstanceTypesError {
    fn code(&self) -> Option<&str> {
        ListElasticsearchInstanceTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListElasticsearchInstanceTypesError {
    /// Creates a new `ListElasticsearchInstanceTypesError`.
    pub fn new(
        kind: ListElasticsearchInstanceTypesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListElasticsearchInstanceTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListElasticsearchInstanceTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListElasticsearchInstanceTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListElasticsearchInstanceTypesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListElasticsearchInstanceTypesErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListElasticsearchInstanceTypesErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListElasticsearchInstanceTypesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListElasticsearchInstanceTypesErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListElasticsearchInstanceTypesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListElasticsearchInstanceTypesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListElasticsearchInstanceTypesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListElasticsearchInstanceTypesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListElasticsearchInstanceTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListElasticsearchInstanceTypesErrorKind::BaseException(_inner) => Some(_inner),
            ListElasticsearchInstanceTypesErrorKind::InternalException(_inner) => Some(_inner),
            ListElasticsearchInstanceTypesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListElasticsearchInstanceTypesErrorKind::ValidationException(_inner) => Some(_inner),
            ListElasticsearchInstanceTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListElasticsearchVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListElasticsearchVersionsError {
    /// Kind of error that occurred.
    pub kind: ListElasticsearchVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListElasticsearchVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListElasticsearchVersionsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListElasticsearchVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListElasticsearchVersionsErrorKind::BaseException(_inner) => _inner.fmt(f),
            ListElasticsearchVersionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListElasticsearchVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListElasticsearchVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListElasticsearchVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListElasticsearchVersionsError {
    fn code(&self) -> Option<&str> {
        ListElasticsearchVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListElasticsearchVersionsError {
    /// Creates a new `ListElasticsearchVersionsError`.
    pub fn new(kind: ListElasticsearchVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListElasticsearchVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListElasticsearchVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListElasticsearchVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListElasticsearchVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListElasticsearchVersionsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListElasticsearchVersionsErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListElasticsearchVersionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListElasticsearchVersionsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListElasticsearchVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListElasticsearchVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListElasticsearchVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListElasticsearchVersionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListElasticsearchVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListElasticsearchVersionsErrorKind::BaseException(_inner) => Some(_inner),
            ListElasticsearchVersionsErrorKind::InternalException(_inner) => Some(_inner),
            ListElasticsearchVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListElasticsearchVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListElasticsearchVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPackagesForDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPackagesForDomainError {
    /// Kind of error that occurred.
    pub kind: ListPackagesForDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPackagesForDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPackagesForDomainErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPackagesForDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPackagesForDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPackagesForDomainErrorKind::BaseException(_inner) => _inner.fmt(f),
            ListPackagesForDomainErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListPackagesForDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPackagesForDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPackagesForDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPackagesForDomainError {
    fn code(&self) -> Option<&str> {
        ListPackagesForDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPackagesForDomainError {
    /// Creates a new `ListPackagesForDomainError`.
    pub fn new(kind: ListPackagesForDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPackagesForDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPackagesForDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPackagesForDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPackagesForDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPackagesForDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagesForDomainErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagesForDomainErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, ListPackagesForDomainErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `ListPackagesForDomainErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagesForDomainErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagesForDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagesForDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagesForDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagesForDomainErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPackagesForDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPackagesForDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPackagesForDomainErrorKind::BaseException(_inner) => Some(_inner),
            ListPackagesForDomainErrorKind::InternalException(_inner) => Some(_inner),
            ListPackagesForDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPackagesForDomainErrorKind::ValidationException(_inner) => Some(_inner),
            ListPackagesForDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsError {
    /// Kind of error that occurred.
    pub kind: ListTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsErrorKind::BaseException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsError {
    fn code(&self) -> Option<&str> {
        ListTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsError {
    /// Creates a new `ListTagsError`.
    pub fn new(kind: ListTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsErrorKind::BaseException(_inner) => Some(_inner),
            ListTagsErrorKind::InternalException(_inner) => Some(_inner),
            ListTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PurchaseReservedElasticsearchInstanceOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PurchaseReservedElasticsearchInstanceOfferingError {
    /// Kind of error that occurred.
    pub kind: PurchaseReservedElasticsearchInstanceOfferingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PurchaseReservedElasticsearchInstanceOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PurchaseReservedElasticsearchInstanceOfferingErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for creating a resource that already exists. Gives http status code of 400.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PurchaseReservedElasticsearchInstanceOfferingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::DisabledOperationException(_inner) =>
            _inner.fmt(f)
            ,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::InternalException(_inner) =>
            _inner.fmt(f)
            ,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::LimitExceededException(_inner) =>
            _inner.fmt(f)
            ,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::ResourceAlreadyExistsException(_inner) =>
            _inner.fmt(f)
            ,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::ResourceNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for PurchaseReservedElasticsearchInstanceOfferingError
{
    fn code(&self) -> Option<&str> {
        PurchaseReservedElasticsearchInstanceOfferingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PurchaseReservedElasticsearchInstanceOfferingError {
    /// Creates a new `PurchaseReservedElasticsearchInstanceOfferingError`.
    pub fn new(
        kind: PurchaseReservedElasticsearchInstanceOfferingErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PurchaseReservedElasticsearchInstanceOfferingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PurchaseReservedElasticsearchInstanceOfferingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PurchaseReservedElasticsearchInstanceOfferingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PurchaseReservedElasticsearchInstanceOfferingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PurchaseReservedElasticsearchInstanceOfferingErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseReservedElasticsearchInstanceOfferingErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseReservedElasticsearchInstanceOfferingErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseReservedElasticsearchInstanceOfferingErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::ResourceAlreadyExistsException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `PurchaseReservedElasticsearchInstanceOfferingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseReservedElasticsearchInstanceOfferingErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PurchaseReservedElasticsearchInstanceOfferingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::DisabledOperationException(_inner) =>
            Some(_inner)
            ,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::InternalException(_inner) =>
            Some(_inner)
            ,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::LimitExceededException(_inner) =>
            Some(_inner)
            ,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::ResourceAlreadyExistsException(_inner) =>
            Some(_inner)
            ,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::ResourceNotFoundException(_inner) =>
            Some(_inner)
            ,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            PurchaseReservedElasticsearchInstanceOfferingErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `RejectInboundCrossClusterSearchConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectInboundCrossClusterSearchConnectionError {
    /// Kind of error that occurred.
    pub kind: RejectInboundCrossClusterSearchConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectInboundCrossClusterSearchConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectInboundCrossClusterSearchConnectionErrorKind {
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectInboundCrossClusterSearchConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(
                _inner,
            ) => _inner.fmt(f),
            RejectInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            RejectInboundCrossClusterSearchConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectInboundCrossClusterSearchConnectionError {
    fn code(&self) -> Option<&str> {
        RejectInboundCrossClusterSearchConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectInboundCrossClusterSearchConnectionError {
    /// Creates a new `RejectInboundCrossClusterSearchConnectionError`.
    pub fn new(
        kind: RejectInboundCrossClusterSearchConnectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectInboundCrossClusterSearchConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectInboundCrossClusterSearchConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectInboundCrossClusterSearchConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectInboundCrossClusterSearchConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RejectInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RejectInboundCrossClusterSearchConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(
                _inner,
            ) => Some(_inner),
            RejectInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            RejectInboundCrossClusterSearchConnectionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `RemoveTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsErrorKind::BaseException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::InternalException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsError {
    fn code(&self) -> Option<&str> {
        RemoveTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsError {
    /// Creates a new `RemoveTagsError`.
    pub fn new(kind: RemoveTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, RemoveTagsErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, RemoveTagsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, RemoveTagsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for RemoveTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsErrorKind::BaseException(_inner) => Some(_inner),
            RemoveTagsErrorKind::InternalException(_inner) => Some(_inner),
            RemoveTagsErrorKind::ValidationException(_inner) => Some(_inner),
            RemoveTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartElasticsearchServiceSoftwareUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartElasticsearchServiceSoftwareUpdateError {
    /// Kind of error that occurred.
    pub kind: StartElasticsearchServiceSoftwareUpdateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartElasticsearchServiceSoftwareUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartElasticsearchServiceSoftwareUpdateErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartElasticsearchServiceSoftwareUpdateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartElasticsearchServiceSoftwareUpdateErrorKind::BaseException(_inner) => {
                _inner.fmt(f)
            }
            StartElasticsearchServiceSoftwareUpdateErrorKind::InternalException(_inner) => {
                _inner.fmt(f)
            }
            StartElasticsearchServiceSoftwareUpdateErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StartElasticsearchServiceSoftwareUpdateErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            StartElasticsearchServiceSoftwareUpdateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartElasticsearchServiceSoftwareUpdateError {
    fn code(&self) -> Option<&str> {
        StartElasticsearchServiceSoftwareUpdateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartElasticsearchServiceSoftwareUpdateError {
    /// Creates a new `StartElasticsearchServiceSoftwareUpdateError`.
    pub fn new(
        kind: StartElasticsearchServiceSoftwareUpdateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartElasticsearchServiceSoftwareUpdateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartElasticsearchServiceSoftwareUpdateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartElasticsearchServiceSoftwareUpdateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartElasticsearchServiceSoftwareUpdateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartElasticsearchServiceSoftwareUpdateErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartElasticsearchServiceSoftwareUpdateErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `StartElasticsearchServiceSoftwareUpdateErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartElasticsearchServiceSoftwareUpdateErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `StartElasticsearchServiceSoftwareUpdateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartElasticsearchServiceSoftwareUpdateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartElasticsearchServiceSoftwareUpdateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartElasticsearchServiceSoftwareUpdateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartElasticsearchServiceSoftwareUpdateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartElasticsearchServiceSoftwareUpdateErrorKind::BaseException(_inner) => Some(_inner),
            StartElasticsearchServiceSoftwareUpdateErrorKind::InternalException(_inner) => {
                Some(_inner)
            }
            StartElasticsearchServiceSoftwareUpdateErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            StartElasticsearchServiceSoftwareUpdateErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            StartElasticsearchServiceSoftwareUpdateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateElasticsearchDomainConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateElasticsearchDomainConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateElasticsearchDomainConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateElasticsearchDomainConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateElasticsearchDomainConfigErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateElasticsearchDomainConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateElasticsearchDomainConfigErrorKind::BaseException(_inner) => _inner.fmt(f),
            UpdateElasticsearchDomainConfigErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateElasticsearchDomainConfigErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            UpdateElasticsearchDomainConfigErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateElasticsearchDomainConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateElasticsearchDomainConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateElasticsearchDomainConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateElasticsearchDomainConfigError {
    fn code(&self) -> Option<&str> {
        UpdateElasticsearchDomainConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateElasticsearchDomainConfigError {
    /// Creates a new `UpdateElasticsearchDomainConfigError`.
    pub fn new(
        kind: UpdateElasticsearchDomainConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateElasticsearchDomainConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateElasticsearchDomainConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateElasticsearchDomainConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateElasticsearchDomainConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateElasticsearchDomainConfigErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateElasticsearchDomainConfigErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateElasticsearchDomainConfigErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateElasticsearchDomainConfigErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateElasticsearchDomainConfigErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateElasticsearchDomainConfigErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateElasticsearchDomainConfigErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateElasticsearchDomainConfigErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateElasticsearchDomainConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateElasticsearchDomainConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateElasticsearchDomainConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateElasticsearchDomainConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateElasticsearchDomainConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateElasticsearchDomainConfigErrorKind::BaseException(_inner) => Some(_inner),
            UpdateElasticsearchDomainConfigErrorKind::InternalException(_inner) => Some(_inner),
            UpdateElasticsearchDomainConfigErrorKind::InvalidTypeException(_inner) => Some(_inner),
            UpdateElasticsearchDomainConfigErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            UpdateElasticsearchDomainConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateElasticsearchDomainConfigErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateElasticsearchDomainConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePackageError {
    /// Kind of error that occurred.
    pub kind: UpdatePackageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePackage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePackageErrorKind {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePackageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePackageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePackageErrorKind::BaseException(_inner) => _inner.fmt(f),
            UpdatePackageErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdatePackageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdatePackageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePackageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePackageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePackageError {
    fn code(&self) -> Option<&str> {
        UpdatePackageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePackageError {
    /// Creates a new `UpdatePackageError`.
    pub fn new(kind: UpdatePackageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePackageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePackageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePackageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePackageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePackageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdatePackageErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdatePackageErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, UpdatePackageErrorKind::BaseException(_))
    }
    /// Returns `true` if the error kind is `UpdatePackageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, UpdatePackageErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `UpdatePackageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackageErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePackageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePackageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdatePackageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdatePackageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePackageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePackageErrorKind::BaseException(_inner) => Some(_inner),
            UpdatePackageErrorKind::InternalException(_inner) => Some(_inner),
            UpdatePackageErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdatePackageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePackageErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePackageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpgradeElasticsearchDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpgradeElasticsearchDomainError {
    /// Kind of error that occurred.
    pub kind: UpgradeElasticsearchDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpgradeElasticsearchDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpgradeElasticsearchDomainErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>An exception for creating a resource that already exists. Gives http status code of 400.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpgradeElasticsearchDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpgradeElasticsearchDomainErrorKind::BaseException(_inner) => _inner.fmt(f),
            UpgradeElasticsearchDomainErrorKind::DisabledOperationException(_inner) => {
                _inner.fmt(f)
            }
            UpgradeElasticsearchDomainErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpgradeElasticsearchDomainErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            UpgradeElasticsearchDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpgradeElasticsearchDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpgradeElasticsearchDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpgradeElasticsearchDomainError {
    fn code(&self) -> Option<&str> {
        UpgradeElasticsearchDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpgradeElasticsearchDomainError {
    /// Creates a new `UpgradeElasticsearchDomainError`.
    pub fn new(kind: UpgradeElasticsearchDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpgradeElasticsearchDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpgradeElasticsearchDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpgradeElasticsearchDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpgradeElasticsearchDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpgradeElasticsearchDomainErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeElasticsearchDomainErrorKind::BaseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpgradeElasticsearchDomainErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeElasticsearchDomainErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpgradeElasticsearchDomainErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeElasticsearchDomainErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `UpgradeElasticsearchDomainErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeElasticsearchDomainErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpgradeElasticsearchDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeElasticsearchDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpgradeElasticsearchDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeElasticsearchDomainErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpgradeElasticsearchDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpgradeElasticsearchDomainErrorKind::BaseException(_inner) => Some(_inner),
            UpgradeElasticsearchDomainErrorKind::DisabledOperationException(_inner) => Some(_inner),
            UpgradeElasticsearchDomainErrorKind::InternalException(_inner) => Some(_inner),
            UpgradeElasticsearchDomainErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            UpgradeElasticsearchDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpgradeElasticsearchDomainErrorKind::ValidationException(_inner) => Some(_inner),
            UpgradeElasticsearchDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>An exception for creating a resource that already exists. Gives http status code of 400.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}

/// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalException {}
/// See [`InternalException`](crate::error::InternalException)
pub mod internal_exception {
    /// A builder for [`InternalException`](crate::error::InternalException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalException`](crate::error::InternalException)
        pub fn build(self) -> crate::error::InternalException {
            crate::error::InternalException {
                message: self.message,
            }
        }
    }
}
impl InternalException {
    /// Creates a new builder-style object to manufacture [`InternalException`](crate::error::InternalException)
    pub fn builder() -> crate::error::internal_exception::Builder {
        crate::error::internal_exception::Builder::default()
    }
}

/// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisabledOperationException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisabledOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisabledOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DisabledOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DisabledOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DisabledOperationException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for DisabledOperationException {}
/// See [`DisabledOperationException`](crate::error::DisabledOperationException)
pub mod disabled_operation_exception {
    /// A builder for [`DisabledOperationException`](crate::error::DisabledOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DisabledOperationException`](crate::error::DisabledOperationException)
        pub fn build(self) -> crate::error::DisabledOperationException {
            crate::error::DisabledOperationException {
                message: self.message,
            }
        }
    }
}
impl DisabledOperationException {
    /// Creates a new builder-style object to manufacture [`DisabledOperationException`](crate::error::DisabledOperationException)
    pub fn builder() -> crate::error::disabled_operation_exception::Builder {
        crate::error::disabled_operation_exception::Builder::default()
    }
}

/// <p>An error occurred while processing the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BaseException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BaseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BaseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BaseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BaseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BaseException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BaseException {}
/// See [`BaseException`](crate::error::BaseException)
pub mod base_exception {
    /// A builder for [`BaseException`](crate::error::BaseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BaseException`](crate::error::BaseException)
        pub fn build(self) -> crate::error::BaseException {
            crate::error::BaseException {
                message: self.message,
            }
        }
    }
}
impl BaseException {
    /// Creates a new builder-style object to manufacture [`BaseException`](crate::error::BaseException)
    pub fn builder() -> crate::error::base_exception::Builder {
        crate::error::base_exception::Builder::default()
    }
}

/// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTypeException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTypeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTypeException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTypeException {}
/// See [`InvalidTypeException`](crate::error::InvalidTypeException)
pub mod invalid_type_exception {
    /// A builder for [`InvalidTypeException`](crate::error::InvalidTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTypeException`](crate::error::InvalidTypeException)
        pub fn build(self) -> crate::error::InvalidTypeException {
            crate::error::InvalidTypeException {
                message: self.message,
            }
        }
    }
}
impl InvalidTypeException {
    /// Creates a new builder-style object to manufacture [`InvalidTypeException`](crate::error::InvalidTypeException)
    pub fn builder() -> crate::error::invalid_type_exception::Builder {
        crate::error::invalid_type_exception::Builder::default()
    }
}

/// <p>An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP status code 409.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The request processing has failed because of invalid pagination token provided by customer. Returns an HTTP status code of 400. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPaginationTokenException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPaginationTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPaginationTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPaginationTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPaginationTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPaginationTokenException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPaginationTokenException {}
/// See [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
pub mod invalid_pagination_token_exception {
    /// A builder for [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
        pub fn build(self) -> crate::error::InvalidPaginationTokenException {
            crate::error::InvalidPaginationTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidPaginationTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
    pub fn builder() -> crate::error::invalid_pagination_token_exception::Builder {
        crate::error::invalid_pagination_token_exception::Builder::default()
    }
}
