// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Basic information about a package.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageDetails {
    /// <p>Internal ID of the package.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>User specified name of the package.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>Currently supports only TXT-DICTIONARY.</p>
    pub package_type: std::option::Option<crate::model::PackageType>,
    /// <p>User-specified description of the package.</p>
    pub package_description: std::option::Option<std::string::String>,
    /// <p>Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED</p>
    pub package_status: std::option::Option<crate::model::PackageStatus>,
    /// <p>Timestamp which tells creation date of the package.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    #[allow(missing_docs)] // documentation missing in model
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    #[allow(missing_docs)] // documentation missing in model
    pub available_package_version: std::option::Option<std::string::String>,
    /// <p>Additional information if the package is in an error state. Null otherwise.</p>
    pub error_details: std::option::Option<crate::model::ErrorDetails>,
}
impl PackageDetails {
    /// <p>Internal ID of the package.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>User specified name of the package.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>Currently supports only TXT-DICTIONARY.</p>
    pub fn package_type(&self) -> std::option::Option<&crate::model::PackageType> {
        self.package_type.as_ref()
    }
    /// <p>User-specified description of the package.</p>
    pub fn package_description(&self) -> std::option::Option<&str> {
        self.package_description.as_deref()
    }
    /// <p>Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED</p>
    pub fn package_status(&self) -> std::option::Option<&crate::model::PackageStatus> {
        self.package_status.as_ref()
    }
    /// <p>Timestamp which tells creation date of the package.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn available_package_version(&self) -> std::option::Option<&str> {
        self.available_package_version.as_deref()
    }
    /// <p>Additional information if the package is in an error state. Null otherwise.</p>
    pub fn error_details(&self) -> std::option::Option<&crate::model::ErrorDetails> {
        self.error_details.as_ref()
    }
}
impl std::fmt::Debug for PackageDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageDetails");
        formatter.field("package_id", &self.package_id);
        formatter.field("package_name", &self.package_name);
        formatter.field("package_type", &self.package_type);
        formatter.field("package_description", &self.package_description);
        formatter.field("package_status", &self.package_status);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("available_package_version", &self.available_package_version);
        formatter.field("error_details", &self.error_details);
        formatter.finish()
    }
}
/// See [`PackageDetails`](crate::model::PackageDetails)
pub mod package_details {
    /// A builder for [`PackageDetails`](crate::model::PackageDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) package_type: std::option::Option<crate::model::PackageType>,
        pub(crate) package_description: std::option::Option<std::string::String>,
        pub(crate) package_status: std::option::Option<crate::model::PackageStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) available_package_version: std::option::Option<std::string::String>,
        pub(crate) error_details: std::option::Option<crate::model::ErrorDetails>,
    }
    impl Builder {
        /// <p>Internal ID of the package.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>Internal ID of the package.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>User specified name of the package.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>User specified name of the package.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>Currently supports only TXT-DICTIONARY.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.package_type = Some(input);
            self
        }
        /// <p>Currently supports only TXT-DICTIONARY.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.package_type = input;
            self
        }
        /// <p>User-specified description of the package.</p>
        pub fn package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_description = Some(input.into());
            self
        }
        /// <p>User-specified description of the package.</p>
        pub fn set_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_description = input;
            self
        }
        /// <p>Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED</p>
        pub fn package_status(mut self, input: crate::model::PackageStatus) -> Self {
            self.package_status = Some(input);
            self
        }
        /// <p>Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED</p>
        pub fn set_package_status(
            mut self,
            input: std::option::Option<crate::model::PackageStatus>,
        ) -> Self {
            self.package_status = input;
            self
        }
        /// <p>Timestamp which tells creation date of the package.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>Timestamp which tells creation date of the package.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn available_package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.available_package_version = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_available_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.available_package_version = input;
            self
        }
        /// <p>Additional information if the package is in an error state. Null otherwise.</p>
        pub fn error_details(mut self, input: crate::model::ErrorDetails) -> Self {
            self.error_details = Some(input);
            self
        }
        /// <p>Additional information if the package is in an error state. Null otherwise.</p>
        pub fn set_error_details(
            mut self,
            input: std::option::Option<crate::model::ErrorDetails>,
        ) -> Self {
            self.error_details = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageDetails`](crate::model::PackageDetails)
        pub fn build(self) -> crate::model::PackageDetails {
            crate::model::PackageDetails {
                package_id: self.package_id,
                package_name: self.package_name,
                package_type: self.package_type,
                package_description: self.package_description,
                package_status: self.package_status,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                available_package_version: self.available_package_version,
                error_details: self.error_details,
            }
        }
    }
}
impl PackageDetails {
    /// Creates a new builder-style object to manufacture [`PackageDetails`](crate::model::PackageDetails)
    pub fn builder() -> crate::model::package_details::Builder {
        crate::model::package_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorDetails {
    #[allow(missing_docs)] // documentation missing in model
    pub error_type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_message: std::option::Option<std::string::String>,
}
impl ErrorDetails {
    #[allow(missing_docs)] // documentation missing in model
    pub fn error_type(&self) -> std::option::Option<&str> {
        self.error_type.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for ErrorDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorDetails");
        formatter.field("error_type", &self.error_type);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`ErrorDetails`](crate::model::ErrorDetails)
pub mod error_details {
    /// A builder for [`ErrorDetails`](crate::model::ErrorDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_type: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorDetails`](crate::model::ErrorDetails)
        pub fn build(self) -> crate::model::ErrorDetails {
            crate::model::ErrorDetails {
                error_type: self.error_type,
                error_message: self.error_message,
            }
        }
    }
}
impl ErrorDetails {
    /// Creates a new builder-style object to manufacture [`ErrorDetails`](crate::model::ErrorDetails)
    pub fn builder() -> crate::model::error_details::Builder {
        crate::model::error_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PackageStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Copying,
    #[allow(missing_docs)] // documentation missing in model
    CopyFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Validating,
    #[allow(missing_docs)] // documentation missing in model
    ValidationFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PackageStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => PackageStatus::Available,
            "COPYING" => PackageStatus::Copying,
            "COPY_FAILED" => PackageStatus::CopyFailed,
            "DELETED" => PackageStatus::Deleted,
            "DELETE_FAILED" => PackageStatus::DeleteFailed,
            "DELETING" => PackageStatus::Deleting,
            "VALIDATING" => PackageStatus::Validating,
            "VALIDATION_FAILED" => PackageStatus::ValidationFailed,
            other => PackageStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PackageStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PackageStatus::from(s))
    }
}
impl PackageStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PackageStatus::Available => "AVAILABLE",
            PackageStatus::Copying => "COPYING",
            PackageStatus::CopyFailed => "COPY_FAILED",
            PackageStatus::Deleted => "DELETED",
            PackageStatus::DeleteFailed => "DELETE_FAILED",
            PackageStatus::Deleting => "DELETING",
            PackageStatus::Validating => "VALIDATING",
            PackageStatus::ValidationFailed => "VALIDATION_FAILED",
            PackageStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "COPYING",
            "COPY_FAILED",
            "DELETED",
            "DELETE_FAILED",
            "DELETING",
            "VALIDATING",
            "VALIDATION_FAILED",
        ]
    }
}
impl AsRef<str> for PackageStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PackageType {
    #[allow(missing_docs)] // documentation missing in model
    TxtDictionary,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PackageType {
    fn from(s: &str) -> Self {
        match s {
            "TXT-DICTIONARY" => PackageType::TxtDictionary,
            other => PackageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PackageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PackageType::from(s))
    }
}
impl PackageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PackageType::TxtDictionary => "TXT-DICTIONARY",
            PackageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TXT-DICTIONARY"]
    }
}
impl AsRef<str> for PackageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageSource {
    /// <p>Name of the bucket containing the package.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>Key (file name) of the package.</p>
    pub s3_key: std::option::Option<std::string::String>,
}
impl PackageSource {
    /// <p>Name of the bucket containing the package.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>Key (file name) of the package.</p>
    pub fn s3_key(&self) -> std::option::Option<&str> {
        self.s3_key.as_deref()
    }
}
impl std::fmt::Debug for PackageSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageSource");
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key", &self.s3_key);
        formatter.finish()
    }
}
/// See [`PackageSource`](crate::model::PackageSource)
pub mod package_source {
    /// A builder for [`PackageSource`](crate::model::PackageSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the bucket containing the package.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>Name of the bucket containing the package.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>Key (file name) of the package.</p>
        pub fn s3_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key = Some(input.into());
            self
        }
        /// <p>Key (file name) of the package.</p>
        pub fn set_s3_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_key = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageSource`](crate::model::PackageSource)
        pub fn build(self) -> crate::model::PackageSource {
            crate::model::PackageSource {
                s3_bucket_name: self.s3_bucket_name,
                s3_key: self.s3_key,
            }
        }
    }
}
impl PackageSource {
    /// Creates a new builder-style object to manufacture [`PackageSource`](crate::model::PackageSource)
    pub fn builder() -> crate::model::package_source::Builder {
        crate::model::package_source::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DryRunResults {
    /// <p> Specifies the deployment mechanism through which the update shall be applied on the domain. Possible responses are <code>Blue/Green</code> (The update will require a blue/green deployment.) <code>DynamicUpdate</code> (The update can be applied in-place without a Blue/Green deployment required.) <code>Undetermined</code> (The domain is undergoing an update which needs to complete before the deployment type can be predicted.) <code>None</code> (The configuration change matches the current configuration and will not result in any update.) </p>
    pub deployment_type: std::option::Option<std::string::String>,
    /// <p>Contains an optional message associated with the DryRunResults.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DryRunResults {
    /// <p> Specifies the deployment mechanism through which the update shall be applied on the domain. Possible responses are <code>Blue/Green</code> (The update will require a blue/green deployment.) <code>DynamicUpdate</code> (The update can be applied in-place without a Blue/Green deployment required.) <code>Undetermined</code> (The domain is undergoing an update which needs to complete before the deployment type can be predicted.) <code>None</code> (The configuration change matches the current configuration and will not result in any update.) </p>
    pub fn deployment_type(&self) -> std::option::Option<&str> {
        self.deployment_type.as_deref()
    }
    /// <p>Contains an optional message associated with the DryRunResults.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DryRunResults {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DryRunResults");
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DryRunResults`](crate::model::DryRunResults)
pub mod dry_run_results {
    /// A builder for [`DryRunResults`](crate::model::DryRunResults)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Specifies the deployment mechanism through which the update shall be applied on the domain. Possible responses are <code>Blue/Green</code> (The update will require a blue/green deployment.) <code>DynamicUpdate</code> (The update can be applied in-place without a Blue/Green deployment required.) <code>Undetermined</code> (The domain is undergoing an update which needs to complete before the deployment type can be predicted.) <code>None</code> (The configuration change matches the current configuration and will not result in any update.) </p>
        pub fn deployment_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_type = Some(input.into());
            self
        }
        /// <p> Specifies the deployment mechanism through which the update shall be applied on the domain. Possible responses are <code>Blue/Green</code> (The update will require a blue/green deployment.) <code>DynamicUpdate</code> (The update can be applied in-place without a Blue/Green deployment required.) <code>Undetermined</code> (The domain is undergoing an update which needs to complete before the deployment type can be predicted.) <code>None</code> (The configuration change matches the current configuration and will not result in any update.) </p>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// <p>Contains an optional message associated with the DryRunResults.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Contains an optional message associated with the DryRunResults.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DryRunResults`](crate::model::DryRunResults)
        pub fn build(self) -> crate::model::DryRunResults {
            crate::model::DryRunResults {
                deployment_type: self.deployment_type,
                message: self.message,
            }
        }
    }
}
impl DryRunResults {
    /// Creates a new builder-style object to manufacture [`DryRunResults`](crate::model::DryRunResults)
    pub fn builder() -> crate::model::dry_run_results::Builder {
        crate::model::dry_run_results::Builder::default()
    }
}

/// <p>The configuration of an Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticsearchDomainConfig {
    /// <p>String of format X.Y to specify version for the Elasticsearch domain.</p>
    pub elasticsearch_version: std::option::Option<crate::model::ElasticsearchVersionStatus>,
    /// <p>Specifies the <code>ElasticsearchClusterConfig</code> for the Elasticsearch domain.</p>
    pub elasticsearch_cluster_config:
        std::option::Option<crate::model::ElasticsearchClusterConfigStatus>,
    /// <p>Specifies the <code>EBSOptions</code> for the Elasticsearch domain.</p>
    pub ebs_options: std::option::Option<crate::model::EbsOptionsStatus>,
    /// <p>IAM access policy as a JSON-formatted string.</p>
    pub access_policies: std::option::Option<crate::model::AccessPoliciesStatus>,
    /// <p>Specifies the <code>SnapshotOptions</code> for the Elasticsearch domain.</p>
    pub snapshot_options: std::option::Option<crate::model::SnapshotOptionsStatus>,
    /// <p>The <code>VPCOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank">VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>
    pub vpc_options: std::option::Option<crate::model::VpcDerivedInfoStatus>,
    /// <p>The <code>CognitoOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
    pub cognito_options: std::option::Option<crate::model::CognitoOptionsStatus>,
    /// <p>Specifies the <code>EncryptionAtRestOptions</code> for the Elasticsearch domain.</p>
    pub encryption_at_rest_options:
        std::option::Option<crate::model::EncryptionAtRestOptionsStatus>,
    /// <p>Specifies the <code>NodeToNodeEncryptionOptions</code> for the Elasticsearch domain.</p>
    pub node_to_node_encryption_options:
        std::option::Option<crate::model::NodeToNodeEncryptionOptionsStatus>,
    /// <p>Specifies the <code>AdvancedOptions</code> for the domain. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuring Advanced Options</a> for more information.</p>
    pub advanced_options: std::option::Option<crate::model::AdvancedOptionsStatus>,
    /// <p>Log publishing options for the given domain.</p>
    pub log_publishing_options: std::option::Option<crate::model::LogPublishingOptionsStatus>,
    /// <p>Specifies the <code>DomainEndpointOptions</code> for the Elasticsearch domain.</p>
    pub domain_endpoint_options: std::option::Option<crate::model::DomainEndpointOptionsStatus>,
    /// <p>Specifies <code>AdvancedSecurityOptions</code> for the domain. </p>
    pub advanced_security_options: std::option::Option<crate::model::AdvancedSecurityOptionsStatus>,
    /// <p>Specifies <code>AutoTuneOptions</code> for the domain. </p>
    pub auto_tune_options: std::option::Option<crate::model::AutoTuneOptionsStatus>,
}
impl ElasticsearchDomainConfig {
    /// <p>String of format X.Y to specify version for the Elasticsearch domain.</p>
    pub fn elasticsearch_version(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchVersionStatus> {
        self.elasticsearch_version.as_ref()
    }
    /// <p>Specifies the <code>ElasticsearchClusterConfig</code> for the Elasticsearch domain.</p>
    pub fn elasticsearch_cluster_config(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchClusterConfigStatus> {
        self.elasticsearch_cluster_config.as_ref()
    }
    /// <p>Specifies the <code>EBSOptions</code> for the Elasticsearch domain.</p>
    pub fn ebs_options(&self) -> std::option::Option<&crate::model::EbsOptionsStatus> {
        self.ebs_options.as_ref()
    }
    /// <p>IAM access policy as a JSON-formatted string.</p>
    pub fn access_policies(&self) -> std::option::Option<&crate::model::AccessPoliciesStatus> {
        self.access_policies.as_ref()
    }
    /// <p>Specifies the <code>SnapshotOptions</code> for the Elasticsearch domain.</p>
    pub fn snapshot_options(&self) -> std::option::Option<&crate::model::SnapshotOptionsStatus> {
        self.snapshot_options.as_ref()
    }
    /// <p>The <code>VPCOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank">VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>
    pub fn vpc_options(&self) -> std::option::Option<&crate::model::VpcDerivedInfoStatus> {
        self.vpc_options.as_ref()
    }
    /// <p>The <code>CognitoOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
    pub fn cognito_options(&self) -> std::option::Option<&crate::model::CognitoOptionsStatus> {
        self.cognito_options.as_ref()
    }
    /// <p>Specifies the <code>EncryptionAtRestOptions</code> for the Elasticsearch domain.</p>
    pub fn encryption_at_rest_options(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionAtRestOptionsStatus> {
        self.encryption_at_rest_options.as_ref()
    }
    /// <p>Specifies the <code>NodeToNodeEncryptionOptions</code> for the Elasticsearch domain.</p>
    pub fn node_to_node_encryption_options(
        &self,
    ) -> std::option::Option<&crate::model::NodeToNodeEncryptionOptionsStatus> {
        self.node_to_node_encryption_options.as_ref()
    }
    /// <p>Specifies the <code>AdvancedOptions</code> for the domain. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuring Advanced Options</a> for more information.</p>
    pub fn advanced_options(&self) -> std::option::Option<&crate::model::AdvancedOptionsStatus> {
        self.advanced_options.as_ref()
    }
    /// <p>Log publishing options for the given domain.</p>
    pub fn log_publishing_options(
        &self,
    ) -> std::option::Option<&crate::model::LogPublishingOptionsStatus> {
        self.log_publishing_options.as_ref()
    }
    /// <p>Specifies the <code>DomainEndpointOptions</code> for the Elasticsearch domain.</p>
    pub fn domain_endpoint_options(
        &self,
    ) -> std::option::Option<&crate::model::DomainEndpointOptionsStatus> {
        self.domain_endpoint_options.as_ref()
    }
    /// <p>Specifies <code>AdvancedSecurityOptions</code> for the domain. </p>
    pub fn advanced_security_options(
        &self,
    ) -> std::option::Option<&crate::model::AdvancedSecurityOptionsStatus> {
        self.advanced_security_options.as_ref()
    }
    /// <p>Specifies <code>AutoTuneOptions</code> for the domain. </p>
    pub fn auto_tune_options(&self) -> std::option::Option<&crate::model::AutoTuneOptionsStatus> {
        self.auto_tune_options.as_ref()
    }
}
impl std::fmt::Debug for ElasticsearchDomainConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticsearchDomainConfig");
        formatter.field("elasticsearch_version", &self.elasticsearch_version);
        formatter.field(
            "elasticsearch_cluster_config",
            &self.elasticsearch_cluster_config,
        );
        formatter.field("ebs_options", &self.ebs_options);
        formatter.field("access_policies", &self.access_policies);
        formatter.field("snapshot_options", &self.snapshot_options);
        formatter.field("vpc_options", &self.vpc_options);
        formatter.field("cognito_options", &self.cognito_options);
        formatter.field(
            "encryption_at_rest_options",
            &self.encryption_at_rest_options,
        );
        formatter.field(
            "node_to_node_encryption_options",
            &self.node_to_node_encryption_options,
        );
        formatter.field("advanced_options", &self.advanced_options);
        formatter.field("log_publishing_options", &self.log_publishing_options);
        formatter.field("domain_endpoint_options", &self.domain_endpoint_options);
        formatter.field("advanced_security_options", &self.advanced_security_options);
        formatter.field("auto_tune_options", &self.auto_tune_options);
        formatter.finish()
    }
}
/// See [`ElasticsearchDomainConfig`](crate::model::ElasticsearchDomainConfig)
pub mod elasticsearch_domain_config {
    /// A builder for [`ElasticsearchDomainConfig`](crate::model::ElasticsearchDomainConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elasticsearch_version:
            std::option::Option<crate::model::ElasticsearchVersionStatus>,
        pub(crate) elasticsearch_cluster_config:
            std::option::Option<crate::model::ElasticsearchClusterConfigStatus>,
        pub(crate) ebs_options: std::option::Option<crate::model::EbsOptionsStatus>,
        pub(crate) access_policies: std::option::Option<crate::model::AccessPoliciesStatus>,
        pub(crate) snapshot_options: std::option::Option<crate::model::SnapshotOptionsStatus>,
        pub(crate) vpc_options: std::option::Option<crate::model::VpcDerivedInfoStatus>,
        pub(crate) cognito_options: std::option::Option<crate::model::CognitoOptionsStatus>,
        pub(crate) encryption_at_rest_options:
            std::option::Option<crate::model::EncryptionAtRestOptionsStatus>,
        pub(crate) node_to_node_encryption_options:
            std::option::Option<crate::model::NodeToNodeEncryptionOptionsStatus>,
        pub(crate) advanced_options: std::option::Option<crate::model::AdvancedOptionsStatus>,
        pub(crate) log_publishing_options:
            std::option::Option<crate::model::LogPublishingOptionsStatus>,
        pub(crate) domain_endpoint_options:
            std::option::Option<crate::model::DomainEndpointOptionsStatus>,
        pub(crate) advanced_security_options:
            std::option::Option<crate::model::AdvancedSecurityOptionsStatus>,
        pub(crate) auto_tune_options: std::option::Option<crate::model::AutoTuneOptionsStatus>,
    }
    impl Builder {
        /// <p>String of format X.Y to specify version for the Elasticsearch domain.</p>
        pub fn elasticsearch_version(
            mut self,
            input: crate::model::ElasticsearchVersionStatus,
        ) -> Self {
            self.elasticsearch_version = Some(input);
            self
        }
        /// <p>String of format X.Y to specify version for the Elasticsearch domain.</p>
        pub fn set_elasticsearch_version(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchVersionStatus>,
        ) -> Self {
            self.elasticsearch_version = input;
            self
        }
        /// <p>Specifies the <code>ElasticsearchClusterConfig</code> for the Elasticsearch domain.</p>
        pub fn elasticsearch_cluster_config(
            mut self,
            input: crate::model::ElasticsearchClusterConfigStatus,
        ) -> Self {
            self.elasticsearch_cluster_config = Some(input);
            self
        }
        /// <p>Specifies the <code>ElasticsearchClusterConfig</code> for the Elasticsearch domain.</p>
        pub fn set_elasticsearch_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchClusterConfigStatus>,
        ) -> Self {
            self.elasticsearch_cluster_config = input;
            self
        }
        /// <p>Specifies the <code>EBSOptions</code> for the Elasticsearch domain.</p>
        pub fn ebs_options(mut self, input: crate::model::EbsOptionsStatus) -> Self {
            self.ebs_options = Some(input);
            self
        }
        /// <p>Specifies the <code>EBSOptions</code> for the Elasticsearch domain.</p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptionsStatus>,
        ) -> Self {
            self.ebs_options = input;
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, input: crate::model::AccessPoliciesStatus) -> Self {
            self.access_policies = Some(input);
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<crate::model::AccessPoliciesStatus>,
        ) -> Self {
            self.access_policies = input;
            self
        }
        /// <p>Specifies the <code>SnapshotOptions</code> for the Elasticsearch domain.</p>
        pub fn snapshot_options(mut self, input: crate::model::SnapshotOptionsStatus) -> Self {
            self.snapshot_options = Some(input);
            self
        }
        /// <p>Specifies the <code>SnapshotOptions</code> for the Elasticsearch domain.</p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptionsStatus>,
        ) -> Self {
            self.snapshot_options = input;
            self
        }
        /// <p>The <code>VPCOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank">VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>
        pub fn vpc_options(mut self, input: crate::model::VpcDerivedInfoStatus) -> Self {
            self.vpc_options = Some(input);
            self
        }
        /// <p>The <code>VPCOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank">VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcDerivedInfoStatus>,
        ) -> Self {
            self.vpc_options = input;
            self
        }
        /// <p>The <code>CognitoOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn cognito_options(mut self, input: crate::model::CognitoOptionsStatus) -> Self {
            self.cognito_options = Some(input);
            self
        }
        /// <p>The <code>CognitoOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptionsStatus>,
        ) -> Self {
            self.cognito_options = input;
            self
        }
        /// <p>Specifies the <code>EncryptionAtRestOptions</code> for the Elasticsearch domain.</p>
        pub fn encryption_at_rest_options(
            mut self,
            input: crate::model::EncryptionAtRestOptionsStatus,
        ) -> Self {
            self.encryption_at_rest_options = Some(input);
            self
        }
        /// <p>Specifies the <code>EncryptionAtRestOptions</code> for the Elasticsearch domain.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptionsStatus>,
        ) -> Self {
            self.encryption_at_rest_options = input;
            self
        }
        /// <p>Specifies the <code>NodeToNodeEncryptionOptions</code> for the Elasticsearch domain.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            input: crate::model::NodeToNodeEncryptionOptionsStatus,
        ) -> Self {
            self.node_to_node_encryption_options = Some(input);
            self
        }
        /// <p>Specifies the <code>NodeToNodeEncryptionOptions</code> for the Elasticsearch domain.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptionsStatus>,
        ) -> Self {
            self.node_to_node_encryption_options = input;
            self
        }
        /// <p>Specifies the <code>AdvancedOptions</code> for the domain. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuring Advanced Options</a> for more information.</p>
        pub fn advanced_options(mut self, input: crate::model::AdvancedOptionsStatus) -> Self {
            self.advanced_options = Some(input);
            self
        }
        /// <p>Specifies the <code>AdvancedOptions</code> for the domain. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuring Advanced Options</a> for more information.</p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedOptionsStatus>,
        ) -> Self {
            self.advanced_options = input;
            self
        }
        /// <p>Log publishing options for the given domain.</p>
        pub fn log_publishing_options(
            mut self,
            input: crate::model::LogPublishingOptionsStatus,
        ) -> Self {
            self.log_publishing_options = Some(input);
            self
        }
        /// <p>Log publishing options for the given domain.</p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<crate::model::LogPublishingOptionsStatus>,
        ) -> Self {
            self.log_publishing_options = input;
            self
        }
        /// <p>Specifies the <code>DomainEndpointOptions</code> for the Elasticsearch domain.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptionsStatus,
        ) -> Self {
            self.domain_endpoint_options = Some(input);
            self
        }
        /// <p>Specifies the <code>DomainEndpointOptions</code> for the Elasticsearch domain.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptionsStatus>,
        ) -> Self {
            self.domain_endpoint_options = input;
            self
        }
        /// <p>Specifies <code>AdvancedSecurityOptions</code> for the domain. </p>
        pub fn advanced_security_options(
            mut self,
            input: crate::model::AdvancedSecurityOptionsStatus,
        ) -> Self {
            self.advanced_security_options = Some(input);
            self
        }
        /// <p>Specifies <code>AdvancedSecurityOptions</code> for the domain. </p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptionsStatus>,
        ) -> Self {
            self.advanced_security_options = input;
            self
        }
        /// <p>Specifies <code>AutoTuneOptions</code> for the domain. </p>
        pub fn auto_tune_options(mut self, input: crate::model::AutoTuneOptionsStatus) -> Self {
            self.auto_tune_options = Some(input);
            self
        }
        /// <p>Specifies <code>AutoTuneOptions</code> for the domain. </p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptionsStatus>,
        ) -> Self {
            self.auto_tune_options = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticsearchDomainConfig`](crate::model::ElasticsearchDomainConfig)
        pub fn build(self) -> crate::model::ElasticsearchDomainConfig {
            crate::model::ElasticsearchDomainConfig {
                elasticsearch_version: self.elasticsearch_version,
                elasticsearch_cluster_config: self.elasticsearch_cluster_config,
                ebs_options: self.ebs_options,
                access_policies: self.access_policies,
                snapshot_options: self.snapshot_options,
                vpc_options: self.vpc_options,
                cognito_options: self.cognito_options,
                encryption_at_rest_options: self.encryption_at_rest_options,
                node_to_node_encryption_options: self.node_to_node_encryption_options,
                advanced_options: self.advanced_options,
                log_publishing_options: self.log_publishing_options,
                domain_endpoint_options: self.domain_endpoint_options,
                advanced_security_options: self.advanced_security_options,
                auto_tune_options: self.auto_tune_options,
            }
        }
    }
}
impl ElasticsearchDomainConfig {
    /// Creates a new builder-style object to manufacture [`ElasticsearchDomainConfig`](crate::model::ElasticsearchDomainConfig)
    pub fn builder() -> crate::model::elasticsearch_domain_config::Builder {
        crate::model::elasticsearch_domain_config::Builder::default()
    }
}

/// <p> Specifies the status of Auto-Tune options for the specified Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoTuneOptionsStatus {
    /// <p> Specifies Auto-Tune options for the specified Elasticsearch domain.</p>
    pub options: std::option::Option<crate::model::AutoTuneOptions>,
    /// <p> Specifies Status of the Auto-Tune options for the specified Elasticsearch domain.</p>
    pub status: std::option::Option<crate::model::AutoTuneStatus>,
}
impl AutoTuneOptionsStatus {
    /// <p> Specifies Auto-Tune options for the specified Elasticsearch domain.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::AutoTuneOptions> {
        self.options.as_ref()
    }
    /// <p> Specifies Status of the Auto-Tune options for the specified Elasticsearch domain.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AutoTuneStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AutoTuneOptionsStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoTuneOptionsStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AutoTuneOptionsStatus`](crate::model::AutoTuneOptionsStatus)
pub mod auto_tune_options_status {
    /// A builder for [`AutoTuneOptionsStatus`](crate::model::AutoTuneOptionsStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::AutoTuneOptions>,
        pub(crate) status: std::option::Option<crate::model::AutoTuneStatus>,
    }
    impl Builder {
        /// <p> Specifies Auto-Tune options for the specified Elasticsearch domain.</p>
        pub fn options(mut self, input: crate::model::AutoTuneOptions) -> Self {
            self.options = Some(input);
            self
        }
        /// <p> Specifies Auto-Tune options for the specified Elasticsearch domain.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptions>,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p> Specifies Status of the Auto-Tune options for the specified Elasticsearch domain.</p>
        pub fn status(mut self, input: crate::model::AutoTuneStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> Specifies Status of the Auto-Tune options for the specified Elasticsearch domain.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AutoTuneStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoTuneOptionsStatus`](crate::model::AutoTuneOptionsStatus)
        pub fn build(self) -> crate::model::AutoTuneOptionsStatus {
            crate::model::AutoTuneOptionsStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl AutoTuneOptionsStatus {
    /// Creates a new builder-style object to manufacture [`AutoTuneOptionsStatus`](crate::model::AutoTuneOptionsStatus)
    pub fn builder() -> crate::model::auto_tune_options_status::Builder {
        crate::model::auto_tune_options_status::Builder::default()
    }
}

/// <p>Provides the current status of the Auto-Tune options. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoTuneStatus {
    /// <p>Timestamp which tells Auto-Tune options creation date .</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Timestamp which tells Auto-Tune options last updated time.</p>
    pub update_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the Auto-Tune options latest version.</p>
    pub update_version: i32,
    /// <p>Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.</p>
    pub state: std::option::Option<crate::model::AutoTuneState>,
    /// <p>Specifies the error message while enabling or disabling the Auto-Tune options.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>Indicates whether the Elasticsearch domain is being deleted.</p>
    pub pending_deletion: std::option::Option<bool>,
}
impl AutoTuneStatus {
    /// <p>Timestamp which tells Auto-Tune options creation date .</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>Timestamp which tells Auto-Tune options last updated time.</p>
    pub fn update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date.as_ref()
    }
    /// <p>Specifies the Auto-Tune options latest version.</p>
    pub fn update_version(&self) -> i32 {
        self.update_version
    }
    /// <p>Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::AutoTuneState> {
        self.state.as_ref()
    }
    /// <p>Specifies the error message while enabling or disabling the Auto-Tune options.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>Indicates whether the Elasticsearch domain is being deleted.</p>
    pub fn pending_deletion(&self) -> std::option::Option<bool> {
        self.pending_deletion
    }
}
impl std::fmt::Debug for AutoTuneStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoTuneStatus");
        formatter.field("creation_date", &self.creation_date);
        formatter.field("update_date", &self.update_date);
        formatter.field("update_version", &self.update_version);
        formatter.field("state", &self.state);
        formatter.field("error_message", &self.error_message);
        formatter.field("pending_deletion", &self.pending_deletion);
        formatter.finish()
    }
}
/// See [`AutoTuneStatus`](crate::model::AutoTuneStatus)
pub mod auto_tune_status {
    /// A builder for [`AutoTuneStatus`](crate::model::AutoTuneStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_version: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::AutoTuneState>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) pending_deletion: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Timestamp which tells Auto-Tune options creation date .</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>Timestamp which tells Auto-Tune options creation date .</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>Timestamp which tells Auto-Tune options last updated time.</p>
        pub fn update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date = Some(input);
            self
        }
        /// <p>Timestamp which tells Auto-Tune options last updated time.</p>
        pub fn set_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date = input;
            self
        }
        /// <p>Specifies the Auto-Tune options latest version.</p>
        pub fn update_version(mut self, input: i32) -> Self {
            self.update_version = Some(input);
            self
        }
        /// <p>Specifies the Auto-Tune options latest version.</p>
        pub fn set_update_version(mut self, input: std::option::Option<i32>) -> Self {
            self.update_version = input;
            self
        }
        /// <p>Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.</p>
        pub fn state(mut self, input: crate::model::AutoTuneState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AutoTuneState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>Specifies the error message while enabling or disabling the Auto-Tune options.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>Specifies the error message while enabling or disabling the Auto-Tune options.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>Indicates whether the Elasticsearch domain is being deleted.</p>
        pub fn pending_deletion(mut self, input: bool) -> Self {
            self.pending_deletion = Some(input);
            self
        }
        /// <p>Indicates whether the Elasticsearch domain is being deleted.</p>
        pub fn set_pending_deletion(mut self, input: std::option::Option<bool>) -> Self {
            self.pending_deletion = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoTuneStatus`](crate::model::AutoTuneStatus)
        pub fn build(self) -> crate::model::AutoTuneStatus {
            crate::model::AutoTuneStatus {
                creation_date: self.creation_date,
                update_date: self.update_date,
                update_version: self.update_version.unwrap_or_default(),
                state: self.state,
                error_message: self.error_message,
                pending_deletion: self.pending_deletion,
            }
        }
    }
}
impl AutoTuneStatus {
    /// Creates a new builder-style object to manufacture [`AutoTuneStatus`](crate::model::AutoTuneStatus)
    pub fn builder() -> crate::model::auto_tune_status::Builder {
        crate::model::auto_tune_status::Builder::default()
    }
}

/// <p>Specifies the Auto-Tune state for the Elasticsearch domain. For valid states see the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoTuneState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    DisabledAndRollbackComplete,
    #[allow(missing_docs)] // documentation missing in model
    DisabledAndRollbackError,
    #[allow(missing_docs)] // documentation missing in model
    DisabledAndRollbackInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DisabledAndRollbackScheduled,
    #[allow(missing_docs)] // documentation missing in model
    DisableInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    EnableInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoTuneState {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => AutoTuneState::Disabled,
            "DISABLED_AND_ROLLBACK_COMPLETE" => AutoTuneState::DisabledAndRollbackComplete,
            "DISABLED_AND_ROLLBACK_ERROR" => AutoTuneState::DisabledAndRollbackError,
            "DISABLED_AND_ROLLBACK_IN_PROGRESS" => AutoTuneState::DisabledAndRollbackInProgress,
            "DISABLED_AND_ROLLBACK_SCHEDULED" => AutoTuneState::DisabledAndRollbackScheduled,
            "DISABLE_IN_PROGRESS" => AutoTuneState::DisableInProgress,
            "ENABLED" => AutoTuneState::Enabled,
            "ENABLE_IN_PROGRESS" => AutoTuneState::EnableInProgress,
            "ERROR" => AutoTuneState::Error,
            other => AutoTuneState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoTuneState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoTuneState::from(s))
    }
}
impl AutoTuneState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoTuneState::Disabled => "DISABLED",
            AutoTuneState::DisabledAndRollbackComplete => "DISABLED_AND_ROLLBACK_COMPLETE",
            AutoTuneState::DisabledAndRollbackError => "DISABLED_AND_ROLLBACK_ERROR",
            AutoTuneState::DisabledAndRollbackInProgress => "DISABLED_AND_ROLLBACK_IN_PROGRESS",
            AutoTuneState::DisabledAndRollbackScheduled => "DISABLED_AND_ROLLBACK_SCHEDULED",
            AutoTuneState::DisableInProgress => "DISABLE_IN_PROGRESS",
            AutoTuneState::Enabled => "ENABLED",
            AutoTuneState::EnableInProgress => "ENABLE_IN_PROGRESS",
            AutoTuneState::Error => "ERROR",
            AutoTuneState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DISABLED",
            "DISABLED_AND_ROLLBACK_COMPLETE",
            "DISABLED_AND_ROLLBACK_ERROR",
            "DISABLED_AND_ROLLBACK_IN_PROGRESS",
            "DISABLED_AND_ROLLBACK_SCHEDULED",
            "DISABLE_IN_PROGRESS",
            "ENABLED",
            "ENABLE_IN_PROGRESS",
            "ERROR",
        ]
    }
}
impl AsRef<str> for AutoTuneState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the Auto-Tune options: the Auto-Tune desired state for the domain, rollback state when disabling Auto-Tune options and list of maintenance schedules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoTuneOptions {
    /// <p>Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED. </p>
    pub desired_state: std::option::Option<crate::model::AutoTuneDesiredState>,
    /// <p>Specifies the rollback state while disabling Auto-Tune for the domain. Valid values are NO_ROLLBACK, DEFAULT_ROLLBACK. </p>
    pub rollback_on_disable: std::option::Option<crate::model::RollbackOnDisable>,
    /// <p>Specifies list of maitenance schedules. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    pub maintenance_schedules:
        std::option::Option<std::vec::Vec<crate::model::AutoTuneMaintenanceSchedule>>,
}
impl AutoTuneOptions {
    /// <p>Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED. </p>
    pub fn desired_state(&self) -> std::option::Option<&crate::model::AutoTuneDesiredState> {
        self.desired_state.as_ref()
    }
    /// <p>Specifies the rollback state while disabling Auto-Tune for the domain. Valid values are NO_ROLLBACK, DEFAULT_ROLLBACK. </p>
    pub fn rollback_on_disable(&self) -> std::option::Option<&crate::model::RollbackOnDisable> {
        self.rollback_on_disable.as_ref()
    }
    /// <p>Specifies list of maitenance schedules. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    pub fn maintenance_schedules(
        &self,
    ) -> std::option::Option<&[crate::model::AutoTuneMaintenanceSchedule]> {
        self.maintenance_schedules.as_deref()
    }
}
impl std::fmt::Debug for AutoTuneOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoTuneOptions");
        formatter.field("desired_state", &self.desired_state);
        formatter.field("rollback_on_disable", &self.rollback_on_disable);
        formatter.field("maintenance_schedules", &self.maintenance_schedules);
        formatter.finish()
    }
}
/// See [`AutoTuneOptions`](crate::model::AutoTuneOptions)
pub mod auto_tune_options {
    /// A builder for [`AutoTuneOptions`](crate::model::AutoTuneOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) desired_state: std::option::Option<crate::model::AutoTuneDesiredState>,
        pub(crate) rollback_on_disable: std::option::Option<crate::model::RollbackOnDisable>,
        pub(crate) maintenance_schedules:
            std::option::Option<std::vec::Vec<crate::model::AutoTuneMaintenanceSchedule>>,
    }
    impl Builder {
        /// <p>Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED. </p>
        pub fn desired_state(mut self, input: crate::model::AutoTuneDesiredState) -> Self {
            self.desired_state = Some(input);
            self
        }
        /// <p>Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED. </p>
        pub fn set_desired_state(
            mut self,
            input: std::option::Option<crate::model::AutoTuneDesiredState>,
        ) -> Self {
            self.desired_state = input;
            self
        }
        /// <p>Specifies the rollback state while disabling Auto-Tune for the domain. Valid values are NO_ROLLBACK, DEFAULT_ROLLBACK. </p>
        pub fn rollback_on_disable(mut self, input: crate::model::RollbackOnDisable) -> Self {
            self.rollback_on_disable = Some(input);
            self
        }
        /// <p>Specifies the rollback state while disabling Auto-Tune for the domain. Valid values are NO_ROLLBACK, DEFAULT_ROLLBACK. </p>
        pub fn set_rollback_on_disable(
            mut self,
            input: std::option::Option<crate::model::RollbackOnDisable>,
        ) -> Self {
            self.rollback_on_disable = input;
            self
        }
        /// Appends an item to `maintenance_schedules`.
        ///
        /// To override the contents of this collection use [`set_maintenance_schedules`](Self::set_maintenance_schedules).
        ///
        /// <p>Specifies list of maitenance schedules. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn maintenance_schedules(
            mut self,
            input: crate::model::AutoTuneMaintenanceSchedule,
        ) -> Self {
            let mut v = self.maintenance_schedules.unwrap_or_default();
            v.push(input);
            self.maintenance_schedules = Some(v);
            self
        }
        /// <p>Specifies list of maitenance schedules. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn set_maintenance_schedules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoTuneMaintenanceSchedule>>,
        ) -> Self {
            self.maintenance_schedules = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoTuneOptions`](crate::model::AutoTuneOptions)
        pub fn build(self) -> crate::model::AutoTuneOptions {
            crate::model::AutoTuneOptions {
                desired_state: self.desired_state,
                rollback_on_disable: self.rollback_on_disable,
                maintenance_schedules: self.maintenance_schedules,
            }
        }
    }
}
impl AutoTuneOptions {
    /// Creates a new builder-style object to manufacture [`AutoTuneOptions`](crate::model::AutoTuneOptions)
    pub fn builder() -> crate::model::auto_tune_options::Builder {
        crate::model::auto_tune_options::Builder::default()
    }
}

/// <p>Specifies Auto-Tune maitenance schedule. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoTuneMaintenanceSchedule {
    /// <p>Specifies timestamp at which Auto-Tune maintenance schedule start. </p>
    pub start_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies maintenance schedule duration: duration value and duration unit. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    pub duration: std::option::Option<crate::model::Duration>,
    /// <p>Specifies cron expression for a recurring maintenance schedule. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    pub cron_expression_for_recurrence: std::option::Option<std::string::String>,
}
impl AutoTuneMaintenanceSchedule {
    /// <p>Specifies timestamp at which Auto-Tune maintenance schedule start. </p>
    pub fn start_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_at.as_ref()
    }
    /// <p>Specifies maintenance schedule duration: duration value and duration unit. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    pub fn duration(&self) -> std::option::Option<&crate::model::Duration> {
        self.duration.as_ref()
    }
    /// <p>Specifies cron expression for a recurring maintenance schedule. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    pub fn cron_expression_for_recurrence(&self) -> std::option::Option<&str> {
        self.cron_expression_for_recurrence.as_deref()
    }
}
impl std::fmt::Debug for AutoTuneMaintenanceSchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoTuneMaintenanceSchedule");
        formatter.field("start_at", &self.start_at);
        formatter.field("duration", &self.duration);
        formatter.field(
            "cron_expression_for_recurrence",
            &self.cron_expression_for_recurrence,
        );
        formatter.finish()
    }
}
/// See [`AutoTuneMaintenanceSchedule`](crate::model::AutoTuneMaintenanceSchedule)
pub mod auto_tune_maintenance_schedule {
    /// A builder for [`AutoTuneMaintenanceSchedule`](crate::model::AutoTuneMaintenanceSchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) duration: std::option::Option<crate::model::Duration>,
        pub(crate) cron_expression_for_recurrence: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies timestamp at which Auto-Tune maintenance schedule start. </p>
        pub fn start_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_at = Some(input);
            self
        }
        /// <p>Specifies timestamp at which Auto-Tune maintenance schedule start. </p>
        pub fn set_start_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_at = input;
            self
        }
        /// <p>Specifies maintenance schedule duration: duration value and duration unit. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn duration(mut self, input: crate::model::Duration) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>Specifies maintenance schedule duration: duration value and duration unit. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn set_duration(mut self, input: std::option::Option<crate::model::Duration>) -> Self {
            self.duration = input;
            self
        }
        /// <p>Specifies cron expression for a recurring maintenance schedule. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn cron_expression_for_recurrence(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cron_expression_for_recurrence = Some(input.into());
            self
        }
        /// <p>Specifies cron expression for a recurring maintenance schedule. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn set_cron_expression_for_recurrence(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cron_expression_for_recurrence = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoTuneMaintenanceSchedule`](crate::model::AutoTuneMaintenanceSchedule)
        pub fn build(self) -> crate::model::AutoTuneMaintenanceSchedule {
            crate::model::AutoTuneMaintenanceSchedule {
                start_at: self.start_at,
                duration: self.duration,
                cron_expression_for_recurrence: self.cron_expression_for_recurrence,
            }
        }
    }
}
impl AutoTuneMaintenanceSchedule {
    /// Creates a new builder-style object to manufacture [`AutoTuneMaintenanceSchedule`](crate::model::AutoTuneMaintenanceSchedule)
    pub fn builder() -> crate::model::auto_tune_maintenance_schedule::Builder {
        crate::model::auto_tune_maintenance_schedule::Builder::default()
    }
}

/// <p>Specifies maintenance schedule duration: duration value and duration unit. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Duration {
    /// <p> Integer to specify the value of a maintenance schedule duration. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    pub value: i64,
    /// <p>Specifies the unit of a maintenance schedule duration. Valid value is HOURS. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    pub unit: std::option::Option<crate::model::TimeUnit>,
}
impl Duration {
    /// <p> Integer to specify the value of a maintenance schedule duration. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    pub fn value(&self) -> i64 {
        self.value
    }
    /// <p>Specifies the unit of a maintenance schedule duration. Valid value is HOURS. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    pub fn unit(&self) -> std::option::Option<&crate::model::TimeUnit> {
        self.unit.as_ref()
    }
}
impl std::fmt::Debug for Duration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Duration");
        formatter.field("value", &self.value);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`Duration`](crate::model::Duration)
pub mod duration {
    /// A builder for [`Duration`](crate::model::Duration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<i64>,
        pub(crate) unit: std::option::Option<crate::model::TimeUnit>,
    }
    impl Builder {
        /// <p> Integer to specify the value of a maintenance schedule duration. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn value(mut self, input: i64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p> Integer to specify the value of a maintenance schedule duration. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn set_value(mut self, input: std::option::Option<i64>) -> Self {
            self.value = input;
            self
        }
        /// <p>Specifies the unit of a maintenance schedule duration. Valid value is HOURS. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn unit(mut self, input: crate::model::TimeUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>Specifies the unit of a maintenance schedule duration. Valid value is HOURS. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::TimeUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`Duration`](crate::model::Duration)
        pub fn build(self) -> crate::model::Duration {
            crate::model::Duration {
                value: self.value.unwrap_or_default(),
                unit: self.unit,
            }
        }
    }
}
impl Duration {
    /// Creates a new builder-style object to manufacture [`Duration`](crate::model::Duration)
    pub fn builder() -> crate::model::duration::Builder {
        crate::model::duration::Builder::default()
    }
}

/// <p>Specifies the unit of a maintenance schedule duration. Valid value is HOUR. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimeUnit {
    #[allow(missing_docs)] // documentation missing in model
    Hours,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimeUnit {
    fn from(s: &str) -> Self {
        match s {
            "HOURS" => TimeUnit::Hours,
            other => TimeUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimeUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimeUnit::from(s))
    }
}
impl TimeUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimeUnit::Hours => "HOURS",
            TimeUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HOURS"]
    }
}
impl AsRef<str> for TimeUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the rollback state while disabling Auto-Tune for the domain. Valid values are NO_ROLLBACK, DEFAULT_ROLLBACK.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RollbackOnDisable {
    #[allow(missing_docs)] // documentation missing in model
    DefaultRollback,
    #[allow(missing_docs)] // documentation missing in model
    NoRollback,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RollbackOnDisable {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT_ROLLBACK" => RollbackOnDisable::DefaultRollback,
            "NO_ROLLBACK" => RollbackOnDisable::NoRollback,
            other => RollbackOnDisable::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RollbackOnDisable {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RollbackOnDisable::from(s))
    }
}
impl RollbackOnDisable {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RollbackOnDisable::DefaultRollback => "DEFAULT_ROLLBACK",
            RollbackOnDisable::NoRollback => "NO_ROLLBACK",
            RollbackOnDisable::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT_ROLLBACK", "NO_ROLLBACK"]
    }
}
impl AsRef<str> for RollbackOnDisable {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoTuneDesiredState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoTuneDesiredState {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => AutoTuneDesiredState::Disabled,
            "ENABLED" => AutoTuneDesiredState::Enabled,
            other => AutoTuneDesiredState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoTuneDesiredState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoTuneDesiredState::from(s))
    }
}
impl AutoTuneDesiredState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoTuneDesiredState::Disabled => "DISABLED",
            AutoTuneDesiredState::Enabled => "ENABLED",
            AutoTuneDesiredState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for AutoTuneDesiredState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Specifies the status of advanced security options for the specified Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdvancedSecurityOptionsStatus {
    /// <p> Specifies advanced security options for the specified Elasticsearch domain.</p>
    pub options: std::option::Option<crate::model::AdvancedSecurityOptions>,
    /// <p> Status of the advanced security options for the specified Elasticsearch domain.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl AdvancedSecurityOptionsStatus {
    /// <p> Specifies advanced security options for the specified Elasticsearch domain.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::AdvancedSecurityOptions> {
        self.options.as_ref()
    }
    /// <p> Status of the advanced security options for the specified Elasticsearch domain.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AdvancedSecurityOptionsStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdvancedSecurityOptionsStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AdvancedSecurityOptionsStatus`](crate::model::AdvancedSecurityOptionsStatus)
pub mod advanced_security_options_status {
    /// A builder for [`AdvancedSecurityOptionsStatus`](crate::model::AdvancedSecurityOptionsStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::AdvancedSecurityOptions>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p> Specifies advanced security options for the specified Elasticsearch domain.</p>
        pub fn options(mut self, input: crate::model::AdvancedSecurityOptions) -> Self {
            self.options = Some(input);
            self
        }
        /// <p> Specifies advanced security options for the specified Elasticsearch domain.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptions>,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p> Status of the advanced security options for the specified Elasticsearch domain.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> Status of the advanced security options for the specified Elasticsearch domain.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AdvancedSecurityOptionsStatus`](crate::model::AdvancedSecurityOptionsStatus)
        pub fn build(self) -> crate::model::AdvancedSecurityOptionsStatus {
            crate::model::AdvancedSecurityOptionsStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl AdvancedSecurityOptionsStatus {
    /// Creates a new builder-style object to manufacture [`AdvancedSecurityOptionsStatus`](crate::model::AdvancedSecurityOptionsStatus)
    pub fn builder() -> crate::model::advanced_security_options_status::Builder {
        crate::model::advanced_security_options_status::Builder::default()
    }
}

/// <p>Provides the current status of the entity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionStatus {
    /// <p>Timestamp which tells the creation date for the entity.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Timestamp which tells the last updated time for the entity.</p>
    pub update_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the latest version for the entity.</p>
    pub update_version: i32,
    /// <p>Provides the <code>OptionState</code> for the Elasticsearch domain.</p>
    pub state: std::option::Option<crate::model::OptionState>,
    /// <p>Indicates whether the Elasticsearch domain is being deleted.</p>
    pub pending_deletion: std::option::Option<bool>,
}
impl OptionStatus {
    /// <p>Timestamp which tells the creation date for the entity.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>Timestamp which tells the last updated time for the entity.</p>
    pub fn update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date.as_ref()
    }
    /// <p>Specifies the latest version for the entity.</p>
    pub fn update_version(&self) -> i32 {
        self.update_version
    }
    /// <p>Provides the <code>OptionState</code> for the Elasticsearch domain.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::OptionState> {
        self.state.as_ref()
    }
    /// <p>Indicates whether the Elasticsearch domain is being deleted.</p>
    pub fn pending_deletion(&self) -> std::option::Option<bool> {
        self.pending_deletion
    }
}
impl std::fmt::Debug for OptionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionStatus");
        formatter.field("creation_date", &self.creation_date);
        formatter.field("update_date", &self.update_date);
        formatter.field("update_version", &self.update_version);
        formatter.field("state", &self.state);
        formatter.field("pending_deletion", &self.pending_deletion);
        formatter.finish()
    }
}
/// See [`OptionStatus`](crate::model::OptionStatus)
pub mod option_status {
    /// A builder for [`OptionStatus`](crate::model::OptionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_version: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::OptionState>,
        pub(crate) pending_deletion: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Timestamp which tells the creation date for the entity.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>Timestamp which tells the creation date for the entity.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>Timestamp which tells the last updated time for the entity.</p>
        pub fn update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date = Some(input);
            self
        }
        /// <p>Timestamp which tells the last updated time for the entity.</p>
        pub fn set_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date = input;
            self
        }
        /// <p>Specifies the latest version for the entity.</p>
        pub fn update_version(mut self, input: i32) -> Self {
            self.update_version = Some(input);
            self
        }
        /// <p>Specifies the latest version for the entity.</p>
        pub fn set_update_version(mut self, input: std::option::Option<i32>) -> Self {
            self.update_version = input;
            self
        }
        /// <p>Provides the <code>OptionState</code> for the Elasticsearch domain.</p>
        pub fn state(mut self, input: crate::model::OptionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Provides the <code>OptionState</code> for the Elasticsearch domain.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::OptionState>) -> Self {
            self.state = input;
            self
        }
        /// <p>Indicates whether the Elasticsearch domain is being deleted.</p>
        pub fn pending_deletion(mut self, input: bool) -> Self {
            self.pending_deletion = Some(input);
            self
        }
        /// <p>Indicates whether the Elasticsearch domain is being deleted.</p>
        pub fn set_pending_deletion(mut self, input: std::option::Option<bool>) -> Self {
            self.pending_deletion = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionStatus`](crate::model::OptionStatus)
        pub fn build(self) -> crate::model::OptionStatus {
            crate::model::OptionStatus {
                creation_date: self.creation_date,
                update_date: self.update_date,
                update_version: self.update_version.unwrap_or_default(),
                state: self.state,
                pending_deletion: self.pending_deletion,
            }
        }
    }
}
impl OptionStatus {
    /// Creates a new builder-style object to manufacture [`OptionStatus`](crate::model::OptionStatus)
    pub fn builder() -> crate::model::option_status::Builder {
        crate::model::option_status::Builder::default()
    }
}

/// <p>The state of a requested change. One of the following:</p>
/// <ul>
/// <li>Processing: The request change is still in-process.</li>
/// <li>Active: The request change is processed and deployed to the Elasticsearch domain.</li>
/// </ul>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OptionState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    #[allow(missing_docs)] // documentation missing in model
    RequiresIndexDocuments,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OptionState {
    fn from(s: &str) -> Self {
        match s {
            "Active" => OptionState::Active,
            "Processing" => OptionState::Processing,
            "RequiresIndexDocuments" => OptionState::RequiresIndexDocuments,
            other => OptionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OptionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OptionState::from(s))
    }
}
impl OptionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OptionState::Active => "Active",
            OptionState::Processing => "Processing",
            OptionState::RequiresIndexDocuments => "RequiresIndexDocuments",
            OptionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Processing", "RequiresIndexDocuments"]
    }
}
impl AsRef<str> for OptionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the advanced security configuration: whether advanced security is enabled, whether the internal database option is enabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdvancedSecurityOptions {
    /// <p>True if advanced security is enabled.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>True if the internal user database is enabled.</p>
    pub internal_user_database_enabled: std::option::Option<bool>,
    /// <p>Describes the SAML application configured for a domain.</p>
    pub saml_options: std::option::Option<crate::model::SamlOptionsOutput>,
}
impl AdvancedSecurityOptions {
    /// <p>True if advanced security is enabled.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>True if the internal user database is enabled.</p>
    pub fn internal_user_database_enabled(&self) -> std::option::Option<bool> {
        self.internal_user_database_enabled
    }
    /// <p>Describes the SAML application configured for a domain.</p>
    pub fn saml_options(&self) -> std::option::Option<&crate::model::SamlOptionsOutput> {
        self.saml_options.as_ref()
    }
}
impl std::fmt::Debug for AdvancedSecurityOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdvancedSecurityOptions");
        formatter.field("enabled", &self.enabled);
        formatter.field(
            "internal_user_database_enabled",
            &self.internal_user_database_enabled,
        );
        formatter.field("saml_options", &self.saml_options);
        formatter.finish()
    }
}
/// See [`AdvancedSecurityOptions`](crate::model::AdvancedSecurityOptions)
pub mod advanced_security_options {
    /// A builder for [`AdvancedSecurityOptions`](crate::model::AdvancedSecurityOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) internal_user_database_enabled: std::option::Option<bool>,
        pub(crate) saml_options: std::option::Option<crate::model::SamlOptionsOutput>,
    }
    impl Builder {
        /// <p>True if advanced security is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>True if advanced security is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>True if the internal user database is enabled.</p>
        pub fn internal_user_database_enabled(mut self, input: bool) -> Self {
            self.internal_user_database_enabled = Some(input);
            self
        }
        /// <p>True if the internal user database is enabled.</p>
        pub fn set_internal_user_database_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.internal_user_database_enabled = input;
            self
        }
        /// <p>Describes the SAML application configured for a domain.</p>
        pub fn saml_options(mut self, input: crate::model::SamlOptionsOutput) -> Self {
            self.saml_options = Some(input);
            self
        }
        /// <p>Describes the SAML application configured for a domain.</p>
        pub fn set_saml_options(
            mut self,
            input: std::option::Option<crate::model::SamlOptionsOutput>,
        ) -> Self {
            self.saml_options = input;
            self
        }
        /// Consumes the builder and constructs a [`AdvancedSecurityOptions`](crate::model::AdvancedSecurityOptions)
        pub fn build(self) -> crate::model::AdvancedSecurityOptions {
            crate::model::AdvancedSecurityOptions {
                enabled: self.enabled,
                internal_user_database_enabled: self.internal_user_database_enabled,
                saml_options: self.saml_options,
            }
        }
    }
}
impl AdvancedSecurityOptions {
    /// Creates a new builder-style object to manufacture [`AdvancedSecurityOptions`](crate::model::AdvancedSecurityOptions)
    pub fn builder() -> crate::model::advanced_security_options::Builder {
        crate::model::advanced_security_options::Builder::default()
    }
}

/// <p>Describes the SAML application configured for the domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SamlOptionsOutput {
    /// <p>True if SAML is enabled.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>Describes the SAML Identity Provider's information.</p>
    pub idp: std::option::Option<crate::model::SamlIdp>,
    /// <p>The key used for matching the SAML Subject attribute.</p>
    pub subject_key: std::option::Option<std::string::String>,
    /// <p>The key used for matching the SAML Roles attribute.</p>
    pub roles_key: std::option::Option<std::string::String>,
    /// <p>The duration, in minutes, after which a user session becomes inactive.</p>
    pub session_timeout_minutes: std::option::Option<i32>,
}
impl SamlOptionsOutput {
    /// <p>True if SAML is enabled.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>Describes the SAML Identity Provider's information.</p>
    pub fn idp(&self) -> std::option::Option<&crate::model::SamlIdp> {
        self.idp.as_ref()
    }
    /// <p>The key used for matching the SAML Subject attribute.</p>
    pub fn subject_key(&self) -> std::option::Option<&str> {
        self.subject_key.as_deref()
    }
    /// <p>The key used for matching the SAML Roles attribute.</p>
    pub fn roles_key(&self) -> std::option::Option<&str> {
        self.roles_key.as_deref()
    }
    /// <p>The duration, in minutes, after which a user session becomes inactive.</p>
    pub fn session_timeout_minutes(&self) -> std::option::Option<i32> {
        self.session_timeout_minutes
    }
}
impl std::fmt::Debug for SamlOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SamlOptionsOutput");
        formatter.field("enabled", &self.enabled);
        formatter.field("idp", &self.idp);
        formatter.field("subject_key", &self.subject_key);
        formatter.field("roles_key", &self.roles_key);
        formatter.field("session_timeout_minutes", &self.session_timeout_minutes);
        formatter.finish()
    }
}
/// See [`SamlOptionsOutput`](crate::model::SamlOptionsOutput)
pub mod saml_options_output {
    /// A builder for [`SamlOptionsOutput`](crate::model::SamlOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) idp: std::option::Option<crate::model::SamlIdp>,
        pub(crate) subject_key: std::option::Option<std::string::String>,
        pub(crate) roles_key: std::option::Option<std::string::String>,
        pub(crate) session_timeout_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>True if SAML is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>True if SAML is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Describes the SAML Identity Provider's information.</p>
        pub fn idp(mut self, input: crate::model::SamlIdp) -> Self {
            self.idp = Some(input);
            self
        }
        /// <p>Describes the SAML Identity Provider's information.</p>
        pub fn set_idp(mut self, input: std::option::Option<crate::model::SamlIdp>) -> Self {
            self.idp = input;
            self
        }
        /// <p>The key used for matching the SAML Subject attribute.</p>
        pub fn subject_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject_key = Some(input.into());
            self
        }
        /// <p>The key used for matching the SAML Subject attribute.</p>
        pub fn set_subject_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject_key = input;
            self
        }
        /// <p>The key used for matching the SAML Roles attribute.</p>
        pub fn roles_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.roles_key = Some(input.into());
            self
        }
        /// <p>The key used for matching the SAML Roles attribute.</p>
        pub fn set_roles_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.roles_key = input;
            self
        }
        /// <p>The duration, in minutes, after which a user session becomes inactive.</p>
        pub fn session_timeout_minutes(mut self, input: i32) -> Self {
            self.session_timeout_minutes = Some(input);
            self
        }
        /// <p>The duration, in minutes, after which a user session becomes inactive.</p>
        pub fn set_session_timeout_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.session_timeout_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`SamlOptionsOutput`](crate::model::SamlOptionsOutput)
        pub fn build(self) -> crate::model::SamlOptionsOutput {
            crate::model::SamlOptionsOutput {
                enabled: self.enabled,
                idp: self.idp,
                subject_key: self.subject_key,
                roles_key: self.roles_key,
                session_timeout_minutes: self.session_timeout_minutes,
            }
        }
    }
}
impl SamlOptionsOutput {
    /// Creates a new builder-style object to manufacture [`SamlOptionsOutput`](crate::model::SamlOptionsOutput)
    pub fn builder() -> crate::model::saml_options_output::Builder {
        crate::model::saml_options_output::Builder::default()
    }
}

/// <p>Specifies the SAML Identity Provider's information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SamlIdp {
    /// <p>The Metadata of the SAML application in xml format.</p>
    pub metadata_content: std::option::Option<std::string::String>,
    /// <p>The unique Entity ID of the application in SAML Identity Provider.</p>
    pub entity_id: std::option::Option<std::string::String>,
}
impl SamlIdp {
    /// <p>The Metadata of the SAML application in xml format.</p>
    pub fn metadata_content(&self) -> std::option::Option<&str> {
        self.metadata_content.as_deref()
    }
    /// <p>The unique Entity ID of the application in SAML Identity Provider.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
}
impl std::fmt::Debug for SamlIdp {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SamlIdp");
        formatter.field("metadata_content", &self.metadata_content);
        formatter.field("entity_id", &self.entity_id);
        formatter.finish()
    }
}
/// See [`SamlIdp`](crate::model::SamlIdp)
pub mod saml_idp {
    /// A builder for [`SamlIdp`](crate::model::SamlIdp)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata_content: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Metadata of the SAML application in xml format.</p>
        pub fn metadata_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata_content = Some(input.into());
            self
        }
        /// <p>The Metadata of the SAML application in xml format.</p>
        pub fn set_metadata_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metadata_content = input;
            self
        }
        /// <p>The unique Entity ID of the application in SAML Identity Provider.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The unique Entity ID of the application in SAML Identity Provider.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SamlIdp`](crate::model::SamlIdp)
        pub fn build(self) -> crate::model::SamlIdp {
            crate::model::SamlIdp {
                metadata_content: self.metadata_content,
                entity_id: self.entity_id,
            }
        }
    }
}
impl SamlIdp {
    /// Creates a new builder-style object to manufacture [`SamlIdp`](crate::model::SamlIdp)
    pub fn builder() -> crate::model::saml_idp::Builder {
        crate::model::saml_idp::Builder::default()
    }
}

/// <p>The configured endpoint options for the domain and their current status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainEndpointOptionsStatus {
    /// <p>Options to configure endpoint for the Elasticsearch domain.</p>
    pub options: std::option::Option<crate::model::DomainEndpointOptions>,
    /// <p>The status of the endpoint options for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that's included. </p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl DomainEndpointOptionsStatus {
    /// <p>Options to configure endpoint for the Elasticsearch domain.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::DomainEndpointOptions> {
        self.options.as_ref()
    }
    /// <p>The status of the endpoint options for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that's included. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DomainEndpointOptionsStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainEndpointOptionsStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DomainEndpointOptionsStatus`](crate::model::DomainEndpointOptionsStatus)
pub mod domain_endpoint_options_status {
    /// A builder for [`DomainEndpointOptionsStatus`](crate::model::DomainEndpointOptionsStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::DomainEndpointOptions>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p>Options to configure endpoint for the Elasticsearch domain.</p>
        pub fn options(mut self, input: crate::model::DomainEndpointOptions) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>Options to configure endpoint for the Elasticsearch domain.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p>The status of the endpoint options for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that's included. </p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the endpoint options for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that's included. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainEndpointOptionsStatus`](crate::model::DomainEndpointOptionsStatus)
        pub fn build(self) -> crate::model::DomainEndpointOptionsStatus {
            crate::model::DomainEndpointOptionsStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl DomainEndpointOptionsStatus {
    /// Creates a new builder-style object to manufacture [`DomainEndpointOptionsStatus`](crate::model::DomainEndpointOptionsStatus)
    pub fn builder() -> crate::model::domain_endpoint_options_status::Builder {
        crate::model::domain_endpoint_options_status::Builder::default()
    }
}

/// <p>Options to configure endpoint for the Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainEndpointOptions {
    /// <p>Specify if only HTTPS endpoint should be enabled for the Elasticsearch domain.</p>
    pub enforce_https: std::option::Option<bool>,
    /// <p>Specify the TLS security policy that needs to be applied to the HTTPS endpoint of Elasticsearch domain. <br><br> It can be one of the following values: </p>
    /// <ul>
    /// <li><b>Policy-Min-TLS-1-0-2019-07: </b> TLS security policy which supports TLSv1.0 and higher.</li>
    /// <li><b>Policy-Min-TLS-1-2-2019-07: </b> TLS security policy which supports only TLSv1.2</li>
    /// </ul>
    /// <p></p>
    pub tls_security_policy: std::option::Option<crate::model::TlsSecurityPolicy>,
    /// <p>Specify if custom endpoint should be enabled for the Elasticsearch domain.</p>
    pub custom_endpoint_enabled: std::option::Option<bool>,
    /// <p>Specify the fully qualified domain for your custom endpoint.</p>
    pub custom_endpoint: std::option::Option<std::string::String>,
    /// <p>Specify ACM certificate ARN for your custom endpoint.</p>
    pub custom_endpoint_certificate_arn: std::option::Option<std::string::String>,
}
impl DomainEndpointOptions {
    /// <p>Specify if only HTTPS endpoint should be enabled for the Elasticsearch domain.</p>
    pub fn enforce_https(&self) -> std::option::Option<bool> {
        self.enforce_https
    }
    /// <p>Specify the TLS security policy that needs to be applied to the HTTPS endpoint of Elasticsearch domain. <br><br> It can be one of the following values: </p>
    /// <ul>
    /// <li><b>Policy-Min-TLS-1-0-2019-07: </b> TLS security policy which supports TLSv1.0 and higher.</li>
    /// <li><b>Policy-Min-TLS-1-2-2019-07: </b> TLS security policy which supports only TLSv1.2</li>
    /// </ul>
    /// <p></p>
    pub fn tls_security_policy(&self) -> std::option::Option<&crate::model::TlsSecurityPolicy> {
        self.tls_security_policy.as_ref()
    }
    /// <p>Specify if custom endpoint should be enabled for the Elasticsearch domain.</p>
    pub fn custom_endpoint_enabled(&self) -> std::option::Option<bool> {
        self.custom_endpoint_enabled
    }
    /// <p>Specify the fully qualified domain for your custom endpoint.</p>
    pub fn custom_endpoint(&self) -> std::option::Option<&str> {
        self.custom_endpoint.as_deref()
    }
    /// <p>Specify ACM certificate ARN for your custom endpoint.</p>
    pub fn custom_endpoint_certificate_arn(&self) -> std::option::Option<&str> {
        self.custom_endpoint_certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for DomainEndpointOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainEndpointOptions");
        formatter.field("enforce_https", &self.enforce_https);
        formatter.field("tls_security_policy", &self.tls_security_policy);
        formatter.field("custom_endpoint_enabled", &self.custom_endpoint_enabled);
        formatter.field("custom_endpoint", &self.custom_endpoint);
        formatter.field(
            "custom_endpoint_certificate_arn",
            &self.custom_endpoint_certificate_arn,
        );
        formatter.finish()
    }
}
/// See [`DomainEndpointOptions`](crate::model::DomainEndpointOptions)
pub mod domain_endpoint_options {
    /// A builder for [`DomainEndpointOptions`](crate::model::DomainEndpointOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enforce_https: std::option::Option<bool>,
        pub(crate) tls_security_policy: std::option::Option<crate::model::TlsSecurityPolicy>,
        pub(crate) custom_endpoint_enabled: std::option::Option<bool>,
        pub(crate) custom_endpoint: std::option::Option<std::string::String>,
        pub(crate) custom_endpoint_certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specify if only HTTPS endpoint should be enabled for the Elasticsearch domain.</p>
        pub fn enforce_https(mut self, input: bool) -> Self {
            self.enforce_https = Some(input);
            self
        }
        /// <p>Specify if only HTTPS endpoint should be enabled for the Elasticsearch domain.</p>
        pub fn set_enforce_https(mut self, input: std::option::Option<bool>) -> Self {
            self.enforce_https = input;
            self
        }
        /// <p>Specify the TLS security policy that needs to be applied to the HTTPS endpoint of Elasticsearch domain. <br><br> It can be one of the following values: </p>
        /// <ul>
        /// <li><b>Policy-Min-TLS-1-0-2019-07: </b> TLS security policy which supports TLSv1.0 and higher.</li>
        /// <li><b>Policy-Min-TLS-1-2-2019-07: </b> TLS security policy which supports only TLSv1.2</li>
        /// </ul>
        /// <p></p>
        pub fn tls_security_policy(mut self, input: crate::model::TlsSecurityPolicy) -> Self {
            self.tls_security_policy = Some(input);
            self
        }
        /// <p>Specify the TLS security policy that needs to be applied to the HTTPS endpoint of Elasticsearch domain. <br><br> It can be one of the following values: </p>
        /// <ul>
        /// <li><b>Policy-Min-TLS-1-0-2019-07: </b> TLS security policy which supports TLSv1.0 and higher.</li>
        /// <li><b>Policy-Min-TLS-1-2-2019-07: </b> TLS security policy which supports only TLSv1.2</li>
        /// </ul>
        /// <p></p>
        pub fn set_tls_security_policy(
            mut self,
            input: std::option::Option<crate::model::TlsSecurityPolicy>,
        ) -> Self {
            self.tls_security_policy = input;
            self
        }
        /// <p>Specify if custom endpoint should be enabled for the Elasticsearch domain.</p>
        pub fn custom_endpoint_enabled(mut self, input: bool) -> Self {
            self.custom_endpoint_enabled = Some(input);
            self
        }
        /// <p>Specify if custom endpoint should be enabled for the Elasticsearch domain.</p>
        pub fn set_custom_endpoint_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.custom_endpoint_enabled = input;
            self
        }
        /// <p>Specify the fully qualified domain for your custom endpoint.</p>
        pub fn custom_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_endpoint = Some(input.into());
            self
        }
        /// <p>Specify the fully qualified domain for your custom endpoint.</p>
        pub fn set_custom_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_endpoint = input;
            self
        }
        /// <p>Specify ACM certificate ARN for your custom endpoint.</p>
        pub fn custom_endpoint_certificate_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_endpoint_certificate_arn = Some(input.into());
            self
        }
        /// <p>Specify ACM certificate ARN for your custom endpoint.</p>
        pub fn set_custom_endpoint_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_endpoint_certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainEndpointOptions`](crate::model::DomainEndpointOptions)
        pub fn build(self) -> crate::model::DomainEndpointOptions {
            crate::model::DomainEndpointOptions {
                enforce_https: self.enforce_https,
                tls_security_policy: self.tls_security_policy,
                custom_endpoint_enabled: self.custom_endpoint_enabled,
                custom_endpoint: self.custom_endpoint,
                custom_endpoint_certificate_arn: self.custom_endpoint_certificate_arn,
            }
        }
    }
}
impl DomainEndpointOptions {
    /// Creates a new builder-style object to manufacture [`DomainEndpointOptions`](crate::model::DomainEndpointOptions)
    pub fn builder() -> crate::model::domain_endpoint_options::Builder {
        crate::model::domain_endpoint_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TlsSecurityPolicy {
    #[allow(missing_docs)] // documentation missing in model
    PolicyMinTls10201907,
    #[allow(missing_docs)] // documentation missing in model
    PolicyMinTls12201907,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TlsSecurityPolicy {
    fn from(s: &str) -> Self {
        match s {
            "Policy-Min-TLS-1-0-2019-07" => TlsSecurityPolicy::PolicyMinTls10201907,
            "Policy-Min-TLS-1-2-2019-07" => TlsSecurityPolicy::PolicyMinTls12201907,
            other => TlsSecurityPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TlsSecurityPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TlsSecurityPolicy::from(s))
    }
}
impl TlsSecurityPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TlsSecurityPolicy::PolicyMinTls10201907 => "Policy-Min-TLS-1-0-2019-07",
            TlsSecurityPolicy::PolicyMinTls12201907 => "Policy-Min-TLS-1-2-2019-07",
            TlsSecurityPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Policy-Min-TLS-1-0-2019-07", "Policy-Min-TLS-1-2-2019-07"]
    }
}
impl AsRef<str> for TlsSecurityPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configured log publishing options for the domain and their current status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogPublishingOptionsStatus {
    /// <p>The log publishing options configured for the Elasticsearch domain.</p>
    pub options: std::option::Option<
        std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
    >,
    /// <p>The status of the log publishing options for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that's included. </p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl LogPublishingOptionsStatus {
    /// <p>The log publishing options configured for the Elasticsearch domain.</p>
    pub fn options(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
    > {
        self.options.as_ref()
    }
    /// <p>The status of the log publishing options for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that's included. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for LogPublishingOptionsStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogPublishingOptionsStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`LogPublishingOptionsStatus`](crate::model::LogPublishingOptionsStatus)
pub mod log_publishing_options_status {
    /// A builder for [`LogPublishingOptionsStatus`](crate::model::LogPublishingOptionsStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<
            std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
        >,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// Adds a key-value pair to `options`.
        ///
        /// To override the contents of this collection use [`set_options`](Self::set_options).
        ///
        /// <p>The log publishing options configured for the Elasticsearch domain.</p>
        pub fn options(
            mut self,
            k: crate::model::LogType,
            v: crate::model::LogPublishingOption,
        ) -> Self {
            let mut hash_map = self.options.unwrap_or_default();
            hash_map.insert(k, v);
            self.options = Some(hash_map);
            self
        }
        /// <p>The log publishing options configured for the Elasticsearch domain.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p>The status of the log publishing options for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that's included. </p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the log publishing options for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that's included. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`LogPublishingOptionsStatus`](crate::model::LogPublishingOptionsStatus)
        pub fn build(self) -> crate::model::LogPublishingOptionsStatus {
            crate::model::LogPublishingOptionsStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl LogPublishingOptionsStatus {
    /// Creates a new builder-style object to manufacture [`LogPublishingOptionsStatus`](crate::model::LogPublishingOptionsStatus)
    pub fn builder() -> crate::model::log_publishing_options_status::Builder {
        crate::model::log_publishing_options_status::Builder::default()
    }
}

/// <p>Log Publishing option that is set for given domain. <br><br>Attributes and their details: </p>
/// <ul>
/// <li>CloudWatchLogsLogGroupArn: ARN of the Cloudwatch log group to which log needs to be published.</li>
/// <li>Enabled: Whether the log publishing for given log type is enabled or not</li>
/// </ul>
/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogPublishingOption {
    /// <p>ARN of the Cloudwatch log group to which log needs to be published.</p>
    pub cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
    /// <p> Specifies whether given log publishing option is enabled or not.</p>
    pub enabled: std::option::Option<bool>,
}
impl LogPublishingOption {
    /// <p>ARN of the Cloudwatch log group to which log needs to be published.</p>
    pub fn cloud_watch_logs_log_group_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_log_group_arn.as_deref()
    }
    /// <p> Specifies whether given log publishing option is enabled or not.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for LogPublishingOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogPublishingOption");
        formatter.field(
            "cloud_watch_logs_log_group_arn",
            &self.cloud_watch_logs_log_group_arn,
        );
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`LogPublishingOption`](crate::model::LogPublishingOption)
pub mod log_publishing_option {
    /// A builder for [`LogPublishingOption`](crate::model::LogPublishingOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>ARN of the Cloudwatch log group to which log needs to be published.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = Some(input.into());
            self
        }
        /// <p>ARN of the Cloudwatch log group to which log needs to be published.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = input;
            self
        }
        /// <p> Specifies whether given log publishing option is enabled or not.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p> Specifies whether given log publishing option is enabled or not.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`LogPublishingOption`](crate::model::LogPublishingOption)
        pub fn build(self) -> crate::model::LogPublishingOption {
            crate::model::LogPublishingOption {
                cloud_watch_logs_log_group_arn: self.cloud_watch_logs_log_group_arn,
                enabled: self.enabled,
            }
        }
    }
}
impl LogPublishingOption {
    /// Creates a new builder-style object to manufacture [`LogPublishingOption`](crate::model::LogPublishingOption)
    pub fn builder() -> crate::model::log_publishing_option::Builder {
        crate::model::log_publishing_option::Builder::default()
    }
}

/// <p>Type of Log File, it can be one of the following:
/// <ul>
/// <li>INDEX_SLOW_LOGS: Index slow logs contain insert requests that took more time than configured index query log threshold to execute.</li>
/// <li>SEARCH_SLOW_LOGS: Search slow logs contain search queries that took more time than configured search query log threshold to execute.</li>
/// <li>ES_APPLICATION_LOGS: Elasticsearch application logs contain information about errors and warnings raised during the operation of the service and can be useful for troubleshooting.</li>
/// <li>AUDIT_LOGS: Audit logs contain records of user requests for access from the domain.</li>
/// </ul>
/// </p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogType {
    #[allow(missing_docs)] // documentation missing in model
    AuditLogs,
    #[allow(missing_docs)] // documentation missing in model
    EsApplicationLogs,
    #[allow(missing_docs)] // documentation missing in model
    IndexSlowLogs,
    #[allow(missing_docs)] // documentation missing in model
    SearchSlowLogs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogType {
    fn from(s: &str) -> Self {
        match s {
            "AUDIT_LOGS" => LogType::AuditLogs,
            "ES_APPLICATION_LOGS" => LogType::EsApplicationLogs,
            "INDEX_SLOW_LOGS" => LogType::IndexSlowLogs,
            "SEARCH_SLOW_LOGS" => LogType::SearchSlowLogs,
            other => LogType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogType::from(s))
    }
}
impl LogType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogType::AuditLogs => "AUDIT_LOGS",
            LogType::EsApplicationLogs => "ES_APPLICATION_LOGS",
            LogType::IndexSlowLogs => "INDEX_SLOW_LOGS",
            LogType::SearchSlowLogs => "SEARCH_SLOW_LOGS",
            LogType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AUDIT_LOGS",
            "ES_APPLICATION_LOGS",
            "INDEX_SLOW_LOGS",
            "SEARCH_SLOW_LOGS",
        ]
    }
}
impl AsRef<str> for LogType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Status of the advanced options for the specified Elasticsearch domain. Currently, the following advanced options are available:</p>
/// <ul>
/// <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</li>
/// <li>Option to specify the percentage of heap space that is allocated to field data. By default, this setting is unbounded.</li>
/// </ul>
/// <p>For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options">Configuring Advanced Options</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdvancedOptionsStatus {
    /// <p> Specifies the status of advanced options for the specified Elasticsearch domain.</p>
    pub options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> Specifies the status of <code>OptionStatus</code> for advanced options for the specified Elasticsearch domain.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl AdvancedOptionsStatus {
    /// <p> Specifies the status of advanced options for the specified Elasticsearch domain.</p>
    pub fn options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.options.as_ref()
    }
    /// <p> Specifies the status of <code>OptionStatus</code> for advanced options for the specified Elasticsearch domain.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AdvancedOptionsStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdvancedOptionsStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AdvancedOptionsStatus`](crate::model::AdvancedOptionsStatus)
pub mod advanced_options_status {
    /// A builder for [`AdvancedOptionsStatus`](crate::model::AdvancedOptionsStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// Adds a key-value pair to `options`.
        ///
        /// To override the contents of this collection use [`set_options`](Self::set_options).
        ///
        /// <p> Specifies the status of advanced options for the specified Elasticsearch domain.</p>
        pub fn options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.options = Some(hash_map);
            self
        }
        /// <p> Specifies the status of advanced options for the specified Elasticsearch domain.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p> Specifies the status of <code>OptionStatus</code> for advanced options for the specified Elasticsearch domain.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> Specifies the status of <code>OptionStatus</code> for advanced options for the specified Elasticsearch domain.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AdvancedOptionsStatus`](crate::model::AdvancedOptionsStatus)
        pub fn build(self) -> crate::model::AdvancedOptionsStatus {
            crate::model::AdvancedOptionsStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl AdvancedOptionsStatus {
    /// Creates a new builder-style object to manufacture [`AdvancedOptionsStatus`](crate::model::AdvancedOptionsStatus)
    pub fn builder() -> crate::model::advanced_options_status::Builder {
        crate::model::advanced_options_status::Builder::default()
    }
}

/// <p>Status of the node-to-node encryption options for the specified Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeToNodeEncryptionOptionsStatus {
    /// <p>Specifies the node-to-node encryption options for the specified Elasticsearch domain.</p>
    pub options: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
    /// <p>Specifies the status of the node-to-node encryption options for the specified Elasticsearch domain.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl NodeToNodeEncryptionOptionsStatus {
    /// <p>Specifies the node-to-node encryption options for the specified Elasticsearch domain.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::NodeToNodeEncryptionOptions> {
        self.options.as_ref()
    }
    /// <p>Specifies the status of the node-to-node encryption options for the specified Elasticsearch domain.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for NodeToNodeEncryptionOptionsStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeToNodeEncryptionOptionsStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`NodeToNodeEncryptionOptionsStatus`](crate::model::NodeToNodeEncryptionOptionsStatus)
pub mod node_to_node_encryption_options_status {
    /// A builder for [`NodeToNodeEncryptionOptionsStatus`](crate::model::NodeToNodeEncryptionOptionsStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p>Specifies the node-to-node encryption options for the specified Elasticsearch domain.</p>
        pub fn options(mut self, input: crate::model::NodeToNodeEncryptionOptions) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>Specifies the node-to-node encryption options for the specified Elasticsearch domain.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p>Specifies the status of the node-to-node encryption options for the specified Elasticsearch domain.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies the status of the node-to-node encryption options for the specified Elasticsearch domain.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeToNodeEncryptionOptionsStatus`](crate::model::NodeToNodeEncryptionOptionsStatus)
        pub fn build(self) -> crate::model::NodeToNodeEncryptionOptionsStatus {
            crate::model::NodeToNodeEncryptionOptionsStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl NodeToNodeEncryptionOptionsStatus {
    /// Creates a new builder-style object to manufacture [`NodeToNodeEncryptionOptionsStatus`](crate::model::NodeToNodeEncryptionOptionsStatus)
    pub fn builder() -> crate::model::node_to_node_encryption_options_status::Builder {
        crate::model::node_to_node_encryption_options_status::Builder::default()
    }
}

/// <p>Specifies the node-to-node encryption options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeToNodeEncryptionOptions {
    /// <p>Specify true to enable node-to-node encryption.</p>
    pub enabled: std::option::Option<bool>,
}
impl NodeToNodeEncryptionOptions {
    /// <p>Specify true to enable node-to-node encryption.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for NodeToNodeEncryptionOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeToNodeEncryptionOptions");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`NodeToNodeEncryptionOptions`](crate::model::NodeToNodeEncryptionOptions)
pub mod node_to_node_encryption_options {
    /// A builder for [`NodeToNodeEncryptionOptions`](crate::model::NodeToNodeEncryptionOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specify true to enable node-to-node encryption.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specify true to enable node-to-node encryption.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeToNodeEncryptionOptions`](crate::model::NodeToNodeEncryptionOptions)
        pub fn build(self) -> crate::model::NodeToNodeEncryptionOptions {
            crate::model::NodeToNodeEncryptionOptions {
                enabled: self.enabled,
            }
        }
    }
}
impl NodeToNodeEncryptionOptions {
    /// Creates a new builder-style object to manufacture [`NodeToNodeEncryptionOptions`](crate::model::NodeToNodeEncryptionOptions)
    pub fn builder() -> crate::model::node_to_node_encryption_options::Builder {
        crate::model::node_to_node_encryption_options::Builder::default()
    }
}

/// <p> Status of the Encryption At Rest options for the specified Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionAtRestOptionsStatus {
    /// <p> Specifies the Encryption At Rest options for the specified Elasticsearch domain.</p>
    pub options: std::option::Option<crate::model::EncryptionAtRestOptions>,
    /// <p> Specifies the status of the Encryption At Rest options for the specified Elasticsearch domain.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl EncryptionAtRestOptionsStatus {
    /// <p> Specifies the Encryption At Rest options for the specified Elasticsearch domain.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::EncryptionAtRestOptions> {
        self.options.as_ref()
    }
    /// <p> Specifies the status of the Encryption At Rest options for the specified Elasticsearch domain.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for EncryptionAtRestOptionsStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionAtRestOptionsStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`EncryptionAtRestOptionsStatus`](crate::model::EncryptionAtRestOptionsStatus)
pub mod encryption_at_rest_options_status {
    /// A builder for [`EncryptionAtRestOptionsStatus`](crate::model::EncryptionAtRestOptionsStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::EncryptionAtRestOptions>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p> Specifies the Encryption At Rest options for the specified Elasticsearch domain.</p>
        pub fn options(mut self, input: crate::model::EncryptionAtRestOptions) -> Self {
            self.options = Some(input);
            self
        }
        /// <p> Specifies the Encryption At Rest options for the specified Elasticsearch domain.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p> Specifies the status of the Encryption At Rest options for the specified Elasticsearch domain.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> Specifies the status of the Encryption At Rest options for the specified Elasticsearch domain.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionAtRestOptionsStatus`](crate::model::EncryptionAtRestOptionsStatus)
        pub fn build(self) -> crate::model::EncryptionAtRestOptionsStatus {
            crate::model::EncryptionAtRestOptionsStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl EncryptionAtRestOptionsStatus {
    /// Creates a new builder-style object to manufacture [`EncryptionAtRestOptionsStatus`](crate::model::EncryptionAtRestOptionsStatus)
    pub fn builder() -> crate::model::encryption_at_rest_options_status::Builder {
        crate::model::encryption_at_rest_options_status::Builder::default()
    }
}

/// <p>Specifies the Encryption At Rest Options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionAtRestOptions {
    /// <p>Specifies the option to enable Encryption At Rest.</p>
    pub enabled: std::option::Option<bool>,
    /// <p> Specifies the KMS Key ID for Encryption At Rest options.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl EncryptionAtRestOptions {
    /// <p>Specifies the option to enable Encryption At Rest.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p> Specifies the KMS Key ID for Encryption At Rest options.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for EncryptionAtRestOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionAtRestOptions");
        formatter.field("enabled", &self.enabled);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`EncryptionAtRestOptions`](crate::model::EncryptionAtRestOptions)
pub mod encryption_at_rest_options {
    /// A builder for [`EncryptionAtRestOptions`](crate::model::EncryptionAtRestOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the option to enable Encryption At Rest.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies the option to enable Encryption At Rest.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p> Specifies the KMS Key ID for Encryption At Rest options.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p> Specifies the KMS Key ID for Encryption At Rest options.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionAtRestOptions`](crate::model::EncryptionAtRestOptions)
        pub fn build(self) -> crate::model::EncryptionAtRestOptions {
            crate::model::EncryptionAtRestOptions {
                enabled: self.enabled,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl EncryptionAtRestOptions {
    /// Creates a new builder-style object to manufacture [`EncryptionAtRestOptions`](crate::model::EncryptionAtRestOptions)
    pub fn builder() -> crate::model::encryption_at_rest_options::Builder {
        crate::model::encryption_at_rest_options::Builder::default()
    }
}

/// <p>Status of the Cognito options for the specified Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CognitoOptionsStatus {
    /// <p>Specifies the Cognito options for the specified Elasticsearch domain.</p>
    pub options: std::option::Option<crate::model::CognitoOptions>,
    /// <p>Specifies the status of the Cognito options for the specified Elasticsearch domain.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl CognitoOptionsStatus {
    /// <p>Specifies the Cognito options for the specified Elasticsearch domain.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::CognitoOptions> {
        self.options.as_ref()
    }
    /// <p>Specifies the status of the Cognito options for the specified Elasticsearch domain.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for CognitoOptionsStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CognitoOptionsStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CognitoOptionsStatus`](crate::model::CognitoOptionsStatus)
pub mod cognito_options_status {
    /// A builder for [`CognitoOptionsStatus`](crate::model::CognitoOptionsStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::CognitoOptions>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p>Specifies the Cognito options for the specified Elasticsearch domain.</p>
        pub fn options(mut self, input: crate::model::CognitoOptions) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>Specifies the Cognito options for the specified Elasticsearch domain.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p>Specifies the status of the Cognito options for the specified Elasticsearch domain.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies the status of the Cognito options for the specified Elasticsearch domain.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CognitoOptionsStatus`](crate::model::CognitoOptionsStatus)
        pub fn build(self) -> crate::model::CognitoOptionsStatus {
            crate::model::CognitoOptionsStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl CognitoOptionsStatus {
    /// Creates a new builder-style object to manufacture [`CognitoOptionsStatus`](crate::model::CognitoOptionsStatus)
    pub fn builder() -> crate::model::cognito_options_status::Builder {
        crate::model::cognito_options_status::Builder::default()
    }
}

/// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CognitoOptions {
    /// <p>Specifies the option to enable Cognito for Kibana authentication.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>Specifies the Cognito user pool ID for Kibana authentication.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>Specifies the Cognito identity pool ID for Kibana authentication.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>Specifies the role ARN that provides Elasticsearch permissions for accessing Cognito resources.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl CognitoOptions {
    /// <p>Specifies the option to enable Cognito for Kibana authentication.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>Specifies the Cognito user pool ID for Kibana authentication.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>Specifies the Cognito identity pool ID for Kibana authentication.</p>
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
    /// <p>Specifies the role ARN that provides Elasticsearch permissions for accessing Cognito resources.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for CognitoOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CognitoOptions");
        formatter.field("enabled", &self.enabled);
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`CognitoOptions`](crate::model::CognitoOptions)
pub mod cognito_options {
    /// A builder for [`CognitoOptions`](crate::model::CognitoOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the option to enable Cognito for Kibana authentication.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies the option to enable Cognito for Kibana authentication.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Specifies the Cognito user pool ID for Kibana authentication.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>Specifies the Cognito user pool ID for Kibana authentication.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>Specifies the Cognito identity pool ID for Kibana authentication.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>Specifies the Cognito identity pool ID for Kibana authentication.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>Specifies the role ARN that provides Elasticsearch permissions for accessing Cognito resources.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the role ARN that provides Elasticsearch permissions for accessing Cognito resources.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CognitoOptions`](crate::model::CognitoOptions)
        pub fn build(self) -> crate::model::CognitoOptions {
            crate::model::CognitoOptions {
                enabled: self.enabled,
                user_pool_id: self.user_pool_id,
                identity_pool_id: self.identity_pool_id,
                role_arn: self.role_arn,
            }
        }
    }
}
impl CognitoOptions {
    /// Creates a new builder-style object to manufacture [`CognitoOptions`](crate::model::CognitoOptions)
    pub fn builder() -> crate::model::cognito_options::Builder {
        crate::model::cognito_options::Builder::default()
    }
}

/// <p> Status of the VPC options for the specified Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcDerivedInfoStatus {
    /// <p> Specifies the VPC options for the specified Elasticsearch domain.</p>
    pub options: std::option::Option<crate::model::VpcDerivedInfo>,
    /// <p> Specifies the status of the VPC options for the specified Elasticsearch domain.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl VpcDerivedInfoStatus {
    /// <p> Specifies the VPC options for the specified Elasticsearch domain.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::VpcDerivedInfo> {
        self.options.as_ref()
    }
    /// <p> Specifies the status of the VPC options for the specified Elasticsearch domain.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for VpcDerivedInfoStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcDerivedInfoStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VpcDerivedInfoStatus`](crate::model::VpcDerivedInfoStatus)
pub mod vpc_derived_info_status {
    /// A builder for [`VpcDerivedInfoStatus`](crate::model::VpcDerivedInfoStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::VpcDerivedInfo>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p> Specifies the VPC options for the specified Elasticsearch domain.</p>
        pub fn options(mut self, input: crate::model::VpcDerivedInfo) -> Self {
            self.options = Some(input);
            self
        }
        /// <p> Specifies the VPC options for the specified Elasticsearch domain.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::VpcDerivedInfo>,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p> Specifies the status of the VPC options for the specified Elasticsearch domain.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> Specifies the status of the VPC options for the specified Elasticsearch domain.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcDerivedInfoStatus`](crate::model::VpcDerivedInfoStatus)
        pub fn build(self) -> crate::model::VpcDerivedInfoStatus {
            crate::model::VpcDerivedInfoStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl VpcDerivedInfoStatus {
    /// Creates a new builder-style object to manufacture [`VpcDerivedInfoStatus`](crate::model::VpcDerivedInfoStatus)
    pub fn builder() -> crate::model::vpc_derived_info_status::Builder {
        crate::model::vpc_derived_info_status::Builder::default()
    }
}

/// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank"> VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcDerivedInfo {
    /// <p>The VPC Id for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Specifies the subnets for VPC endpoint.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The availability zones for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the security groups for VPC endpoint.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VpcDerivedInfo {
    /// <p>The VPC Id for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>Specifies the subnets for VPC endpoint.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The availability zones for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>Specifies the security groups for VPC endpoint.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for VpcDerivedInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcDerivedInfo");
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`VpcDerivedInfo`](crate::model::VpcDerivedInfo)
pub mod vpc_derived_info {
    /// A builder for [`VpcDerivedInfo`](crate::model::VpcDerivedInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The VPC Id for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC Id for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>Specifies the subnets for VPC endpoint.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>Specifies the subnets for VPC endpoint.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The availability zones for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>The availability zones for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>Specifies the security groups for VPC endpoint.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>Specifies the security groups for VPC endpoint.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcDerivedInfo`](crate::model::VpcDerivedInfo)
        pub fn build(self) -> crate::model::VpcDerivedInfo {
            crate::model::VpcDerivedInfo {
                vpc_id: self.vpc_id,
                subnet_ids: self.subnet_ids,
                availability_zones: self.availability_zones,
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl VpcDerivedInfo {
    /// Creates a new builder-style object to manufacture [`VpcDerivedInfo`](crate::model::VpcDerivedInfo)
    pub fn builder() -> crate::model::vpc_derived_info::Builder {
        crate::model::vpc_derived_info::Builder::default()
    }
}

/// <p>Status of a daily automated snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotOptionsStatus {
    /// <p>Specifies the daily snapshot options specified for the Elasticsearch domain.</p>
    pub options: std::option::Option<crate::model::SnapshotOptions>,
    /// <p>Specifies the status of a daily automated snapshot.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl SnapshotOptionsStatus {
    /// <p>Specifies the daily snapshot options specified for the Elasticsearch domain.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::SnapshotOptions> {
        self.options.as_ref()
    }
    /// <p>Specifies the status of a daily automated snapshot.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for SnapshotOptionsStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotOptionsStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`SnapshotOptionsStatus`](crate::model::SnapshotOptionsStatus)
pub mod snapshot_options_status {
    /// A builder for [`SnapshotOptionsStatus`](crate::model::SnapshotOptionsStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::SnapshotOptions>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p>Specifies the daily snapshot options specified for the Elasticsearch domain.</p>
        pub fn options(mut self, input: crate::model::SnapshotOptions) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>Specifies the daily snapshot options specified for the Elasticsearch domain.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p>Specifies the status of a daily automated snapshot.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies the status of a daily automated snapshot.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotOptionsStatus`](crate::model::SnapshotOptionsStatus)
        pub fn build(self) -> crate::model::SnapshotOptionsStatus {
            crate::model::SnapshotOptionsStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl SnapshotOptionsStatus {
    /// Creates a new builder-style object to manufacture [`SnapshotOptionsStatus`](crate::model::SnapshotOptionsStatus)
    pub fn builder() -> crate::model::snapshot_options_status::Builder {
        crate::model::snapshot_options_status::Builder::default()
    }
}

/// <p>Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified Elasticsearch domain. Default value is <code>0</code> hours.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotOptions {
    /// <p>Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified Elasticsearch domain. Default value is <code>0</code> hours.</p>
    pub automated_snapshot_start_hour: std::option::Option<i32>,
}
impl SnapshotOptions {
    /// <p>Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified Elasticsearch domain. Default value is <code>0</code> hours.</p>
    pub fn automated_snapshot_start_hour(&self) -> std::option::Option<i32> {
        self.automated_snapshot_start_hour
    }
}
impl std::fmt::Debug for SnapshotOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotOptions");
        formatter.field(
            "automated_snapshot_start_hour",
            &self.automated_snapshot_start_hour,
        );
        formatter.finish()
    }
}
/// See [`SnapshotOptions`](crate::model::SnapshotOptions)
pub mod snapshot_options {
    /// A builder for [`SnapshotOptions`](crate::model::SnapshotOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automated_snapshot_start_hour: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified Elasticsearch domain. Default value is <code>0</code> hours.</p>
        pub fn automated_snapshot_start_hour(mut self, input: i32) -> Self {
            self.automated_snapshot_start_hour = Some(input);
            self
        }
        /// <p>Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified Elasticsearch domain. Default value is <code>0</code> hours.</p>
        pub fn set_automated_snapshot_start_hour(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automated_snapshot_start_hour = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotOptions`](crate::model::SnapshotOptions)
        pub fn build(self) -> crate::model::SnapshotOptions {
            crate::model::SnapshotOptions {
                automated_snapshot_start_hour: self.automated_snapshot_start_hour,
            }
        }
    }
}
impl SnapshotOptions {
    /// Creates a new builder-style object to manufacture [`SnapshotOptions`](crate::model::SnapshotOptions)
    pub fn builder() -> crate::model::snapshot_options::Builder {
        crate::model::snapshot_options::Builder::default()
    }
}

/// <p>The configured access rules for the domain's document and search endpoints, and the current status of those rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessPoliciesStatus {
    /// <p>The access policy configured for the Elasticsearch domain. Access policies may be resource-based, IP-based, or IAM-based. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies" target="_blank"> Configuring Access Policies</a>for more information.</p>
    pub options: std::option::Option<std::string::String>,
    /// <p>The status of the access policy for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that's included. </p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl AccessPoliciesStatus {
    /// <p>The access policy configured for the Elasticsearch domain. Access policies may be resource-based, IP-based, or IAM-based. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies" target="_blank"> Configuring Access Policies</a>for more information.</p>
    pub fn options(&self) -> std::option::Option<&str> {
        self.options.as_deref()
    }
    /// <p>The status of the access policy for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that's included. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AccessPoliciesStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessPoliciesStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AccessPoliciesStatus`](crate::model::AccessPoliciesStatus)
pub mod access_policies_status {
    /// A builder for [`AccessPoliciesStatus`](crate::model::AccessPoliciesStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p>The access policy configured for the Elasticsearch domain. Access policies may be resource-based, IP-based, or IAM-based. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies" target="_blank"> Configuring Access Policies</a>for more information.</p>
        pub fn options(mut self, input: impl Into<std::string::String>) -> Self {
            self.options = Some(input.into());
            self
        }
        /// <p>The access policy configured for the Elasticsearch domain. Access policies may be resource-based, IP-based, or IAM-based. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies" target="_blank"> Configuring Access Policies</a>for more information.</p>
        pub fn set_options(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.options = input;
            self
        }
        /// <p>The status of the access policy for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that's included. </p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the access policy for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that's included. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessPoliciesStatus`](crate::model::AccessPoliciesStatus)
        pub fn build(self) -> crate::model::AccessPoliciesStatus {
            crate::model::AccessPoliciesStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl AccessPoliciesStatus {
    /// Creates a new builder-style object to manufacture [`AccessPoliciesStatus`](crate::model::AccessPoliciesStatus)
    pub fn builder() -> crate::model::access_policies_status::Builder {
        crate::model::access_policies_status::Builder::default()
    }
}

/// <p> Status of the EBS options for the specified Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsOptionsStatus {
    /// <p> Specifies the EBS options for the specified Elasticsearch domain.</p>
    pub options: std::option::Option<crate::model::EbsOptions>,
    /// <p> Specifies the status of the EBS options for the specified Elasticsearch domain.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl EbsOptionsStatus {
    /// <p> Specifies the EBS options for the specified Elasticsearch domain.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::EbsOptions> {
        self.options.as_ref()
    }
    /// <p> Specifies the status of the EBS options for the specified Elasticsearch domain.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for EbsOptionsStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsOptionsStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`EbsOptionsStatus`](crate::model::EbsOptionsStatus)
pub mod ebs_options_status {
    /// A builder for [`EbsOptionsStatus`](crate::model::EbsOptionsStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::EbsOptions>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p> Specifies the EBS options for the specified Elasticsearch domain.</p>
        pub fn options(mut self, input: crate::model::EbsOptions) -> Self {
            self.options = Some(input);
            self
        }
        /// <p> Specifies the EBS options for the specified Elasticsearch domain.</p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::EbsOptions>) -> Self {
            self.options = input;
            self
        }
        /// <p> Specifies the status of the EBS options for the specified Elasticsearch domain.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> Specifies the status of the EBS options for the specified Elasticsearch domain.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsOptionsStatus`](crate::model::EbsOptionsStatus)
        pub fn build(self) -> crate::model::EbsOptionsStatus {
            crate::model::EbsOptionsStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl EbsOptionsStatus {
    /// Creates a new builder-style object to manufacture [`EbsOptionsStatus`](crate::model::EbsOptionsStatus)
    pub fn builder() -> crate::model::ebs_options_status::Builder {
        crate::model::ebs_options_status::Builder::default()
    }
}

/// <p>Options to enable, disable, and specify the properties of EBS storage volumes. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs" target="_blank"> Configuring EBS-based Storage</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsOptions {
    /// <p>Specifies whether EBS-based storage is enabled.</p>
    pub ebs_enabled: std::option::Option<bool>,
    /// <p> Specifies the volume type for EBS-based storage.</p>
    pub volume_type: std::option::Option<crate::model::VolumeType>,
    /// <p> Integer to specify the size of an EBS volume.</p>
    pub volume_size: std::option::Option<i32>,
    /// <p>Specifies the IOPD for a Provisioned IOPS EBS volume (SSD).</p>
    pub iops: std::option::Option<i32>,
}
impl EbsOptions {
    /// <p>Specifies whether EBS-based storage is enabled.</p>
    pub fn ebs_enabled(&self) -> std::option::Option<bool> {
        self.ebs_enabled
    }
    /// <p> Specifies the volume type for EBS-based storage.</p>
    pub fn volume_type(&self) -> std::option::Option<&crate::model::VolumeType> {
        self.volume_type.as_ref()
    }
    /// <p> Integer to specify the size of an EBS volume.</p>
    pub fn volume_size(&self) -> std::option::Option<i32> {
        self.volume_size
    }
    /// <p>Specifies the IOPD for a Provisioned IOPS EBS volume (SSD).</p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
}
impl std::fmt::Debug for EbsOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsOptions");
        formatter.field("ebs_enabled", &self.ebs_enabled);
        formatter.field("volume_type", &self.volume_type);
        formatter.field("volume_size", &self.volume_size);
        formatter.field("iops", &self.iops);
        formatter.finish()
    }
}
/// See [`EbsOptions`](crate::model::EbsOptions)
pub mod ebs_options {
    /// A builder for [`EbsOptions`](crate::model::EbsOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ebs_enabled: std::option::Option<bool>,
        pub(crate) volume_type: std::option::Option<crate::model::VolumeType>,
        pub(crate) volume_size: std::option::Option<i32>,
        pub(crate) iops: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies whether EBS-based storage is enabled.</p>
        pub fn ebs_enabled(mut self, input: bool) -> Self {
            self.ebs_enabled = Some(input);
            self
        }
        /// <p>Specifies whether EBS-based storage is enabled.</p>
        pub fn set_ebs_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_enabled = input;
            self
        }
        /// <p> Specifies the volume type for EBS-based storage.</p>
        pub fn volume_type(mut self, input: crate::model::VolumeType) -> Self {
            self.volume_type = Some(input);
            self
        }
        /// <p> Specifies the volume type for EBS-based storage.</p>
        pub fn set_volume_type(
            mut self,
            input: std::option::Option<crate::model::VolumeType>,
        ) -> Self {
            self.volume_type = input;
            self
        }
        /// <p> Integer to specify the size of an EBS volume.</p>
        pub fn volume_size(mut self, input: i32) -> Self {
            self.volume_size = Some(input);
            self
        }
        /// <p> Integer to specify the size of an EBS volume.</p>
        pub fn set_volume_size(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_size = input;
            self
        }
        /// <p>Specifies the IOPD for a Provisioned IOPS EBS volume (SSD).</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>Specifies the IOPD for a Provisioned IOPS EBS volume (SSD).</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsOptions`](crate::model::EbsOptions)
        pub fn build(self) -> crate::model::EbsOptions {
            crate::model::EbsOptions {
                ebs_enabled: self.ebs_enabled,
                volume_type: self.volume_type,
                volume_size: self.volume_size,
                iops: self.iops,
            }
        }
    }
}
impl EbsOptions {
    /// Creates a new builder-style object to manufacture [`EbsOptions`](crate::model::EbsOptions)
    pub fn builder() -> crate::model::ebs_options::Builder {
        crate::model::ebs_options::Builder::default()
    }
}

/// <p> The type of EBS volume, standard, gp2, or io1. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs" target="_blank">Configuring EBS-based Storage</a>for more information.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VolumeType {
    #[allow(missing_docs)] // documentation missing in model
    Gp2,
    #[allow(missing_docs)] // documentation missing in model
    Io1,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VolumeType {
    fn from(s: &str) -> Self {
        match s {
            "gp2" => VolumeType::Gp2,
            "io1" => VolumeType::Io1,
            "standard" => VolumeType::Standard,
            other => VolumeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VolumeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VolumeType::from(s))
    }
}
impl VolumeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VolumeType::Gp2 => "gp2",
            VolumeType::Io1 => "io1",
            VolumeType::Standard => "standard",
            VolumeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["gp2", "io1", "standard"]
    }
}
impl AsRef<str> for VolumeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Specifies the configuration status for the specified Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticsearchClusterConfigStatus {
    /// <p> Specifies the cluster configuration for the specified Elasticsearch domain.</p>
    pub options: std::option::Option<crate::model::ElasticsearchClusterConfig>,
    /// <p> Specifies the status of the configuration for the specified Elasticsearch domain.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl ElasticsearchClusterConfigStatus {
    /// <p> Specifies the cluster configuration for the specified Elasticsearch domain.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::ElasticsearchClusterConfig> {
        self.options.as_ref()
    }
    /// <p> Specifies the status of the configuration for the specified Elasticsearch domain.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ElasticsearchClusterConfigStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticsearchClusterConfigStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ElasticsearchClusterConfigStatus`](crate::model::ElasticsearchClusterConfigStatus)
pub mod elasticsearch_cluster_config_status {
    /// A builder for [`ElasticsearchClusterConfigStatus`](crate::model::ElasticsearchClusterConfigStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::ElasticsearchClusterConfig>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p> Specifies the cluster configuration for the specified Elasticsearch domain.</p>
        pub fn options(mut self, input: crate::model::ElasticsearchClusterConfig) -> Self {
            self.options = Some(input);
            self
        }
        /// <p> Specifies the cluster configuration for the specified Elasticsearch domain.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchClusterConfig>,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p> Specifies the status of the configuration for the specified Elasticsearch domain.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> Specifies the status of the configuration for the specified Elasticsearch domain.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticsearchClusterConfigStatus`](crate::model::ElasticsearchClusterConfigStatus)
        pub fn build(self) -> crate::model::ElasticsearchClusterConfigStatus {
            crate::model::ElasticsearchClusterConfigStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl ElasticsearchClusterConfigStatus {
    /// Creates a new builder-style object to manufacture [`ElasticsearchClusterConfigStatus`](crate::model::ElasticsearchClusterConfigStatus)
    pub fn builder() -> crate::model::elasticsearch_cluster_config_status::Builder {
        crate::model::elasticsearch_cluster_config_status::Builder::default()
    }
}

/// <p>Specifies the configuration for the domain cluster, such as the type and number of instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticsearchClusterConfig {
    /// <p>The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data instances.</p>
    pub instance_type: std::option::Option<crate::model::EsPartitionInstanceType>,
    /// <p>The number of instances in the specified domain cluster.</p>
    pub instance_count: std::option::Option<i32>,
    /// <p>A boolean value to indicate whether a dedicated master node is enabled. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes" target="_blank">About Dedicated Master Nodes</a> for more information.</p>
    pub dedicated_master_enabled: std::option::Option<bool>,
    /// <p>A boolean value to indicate whether zone awareness is enabled. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness" target="_blank">About Zone Awareness</a> for more information.</p>
    pub zone_awareness_enabled: std::option::Option<bool>,
    /// <p>Specifies the zone awareness configuration for a domain when zone awareness is enabled.</p>
    pub zone_awareness_config: std::option::Option<crate::model::ZoneAwarenessConfig>,
    /// <p>The instance type for a dedicated master node.</p>
    pub dedicated_master_type: std::option::Option<crate::model::EsPartitionInstanceType>,
    /// <p>Total number of dedicated master nodes, active and on standby, for the cluster.</p>
    pub dedicated_master_count: std::option::Option<i32>,
    /// <p>True to enable warm storage.</p>
    pub warm_enabled: std::option::Option<bool>,
    /// <p>The instance type for the Elasticsearch cluster's warm nodes.</p>
    pub warm_type: std::option::Option<crate::model::EsWarmPartitionInstanceType>,
    /// <p>The number of warm nodes in the cluster.</p>
    pub warm_count: std::option::Option<i32>,
    /// <p>Specifies the <code>ColdStorageOptions</code> config for Elasticsearch Domain</p>
    pub cold_storage_options: std::option::Option<crate::model::ColdStorageOptions>,
}
impl ElasticsearchClusterConfig {
    /// <p>The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data instances.</p>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::EsPartitionInstanceType> {
        self.instance_type.as_ref()
    }
    /// <p>The number of instances in the specified domain cluster.</p>
    pub fn instance_count(&self) -> std::option::Option<i32> {
        self.instance_count
    }
    /// <p>A boolean value to indicate whether a dedicated master node is enabled. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes" target="_blank">About Dedicated Master Nodes</a> for more information.</p>
    pub fn dedicated_master_enabled(&self) -> std::option::Option<bool> {
        self.dedicated_master_enabled
    }
    /// <p>A boolean value to indicate whether zone awareness is enabled. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness" target="_blank">About Zone Awareness</a> for more information.</p>
    pub fn zone_awareness_enabled(&self) -> std::option::Option<bool> {
        self.zone_awareness_enabled
    }
    /// <p>Specifies the zone awareness configuration for a domain when zone awareness is enabled.</p>
    pub fn zone_awareness_config(&self) -> std::option::Option<&crate::model::ZoneAwarenessConfig> {
        self.zone_awareness_config.as_ref()
    }
    /// <p>The instance type for a dedicated master node.</p>
    pub fn dedicated_master_type(
        &self,
    ) -> std::option::Option<&crate::model::EsPartitionInstanceType> {
        self.dedicated_master_type.as_ref()
    }
    /// <p>Total number of dedicated master nodes, active and on standby, for the cluster.</p>
    pub fn dedicated_master_count(&self) -> std::option::Option<i32> {
        self.dedicated_master_count
    }
    /// <p>True to enable warm storage.</p>
    pub fn warm_enabled(&self) -> std::option::Option<bool> {
        self.warm_enabled
    }
    /// <p>The instance type for the Elasticsearch cluster's warm nodes.</p>
    pub fn warm_type(&self) -> std::option::Option<&crate::model::EsWarmPartitionInstanceType> {
        self.warm_type.as_ref()
    }
    /// <p>The number of warm nodes in the cluster.</p>
    pub fn warm_count(&self) -> std::option::Option<i32> {
        self.warm_count
    }
    /// <p>Specifies the <code>ColdStorageOptions</code> config for Elasticsearch Domain</p>
    pub fn cold_storage_options(&self) -> std::option::Option<&crate::model::ColdStorageOptions> {
        self.cold_storage_options.as_ref()
    }
}
impl std::fmt::Debug for ElasticsearchClusterConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticsearchClusterConfig");
        formatter.field("instance_type", &self.instance_type);
        formatter.field("instance_count", &self.instance_count);
        formatter.field("dedicated_master_enabled", &self.dedicated_master_enabled);
        formatter.field("zone_awareness_enabled", &self.zone_awareness_enabled);
        formatter.field("zone_awareness_config", &self.zone_awareness_config);
        formatter.field("dedicated_master_type", &self.dedicated_master_type);
        formatter.field("dedicated_master_count", &self.dedicated_master_count);
        formatter.field("warm_enabled", &self.warm_enabled);
        formatter.field("warm_type", &self.warm_type);
        formatter.field("warm_count", &self.warm_count);
        formatter.field("cold_storage_options", &self.cold_storage_options);
        formatter.finish()
    }
}
/// See [`ElasticsearchClusterConfig`](crate::model::ElasticsearchClusterConfig)
pub mod elasticsearch_cluster_config {
    /// A builder for [`ElasticsearchClusterConfig`](crate::model::ElasticsearchClusterConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_type: std::option::Option<crate::model::EsPartitionInstanceType>,
        pub(crate) instance_count: std::option::Option<i32>,
        pub(crate) dedicated_master_enabled: std::option::Option<bool>,
        pub(crate) zone_awareness_enabled: std::option::Option<bool>,
        pub(crate) zone_awareness_config: std::option::Option<crate::model::ZoneAwarenessConfig>,
        pub(crate) dedicated_master_type:
            std::option::Option<crate::model::EsPartitionInstanceType>,
        pub(crate) dedicated_master_count: std::option::Option<i32>,
        pub(crate) warm_enabled: std::option::Option<bool>,
        pub(crate) warm_type: std::option::Option<crate::model::EsWarmPartitionInstanceType>,
        pub(crate) warm_count: std::option::Option<i32>,
        pub(crate) cold_storage_options: std::option::Option<crate::model::ColdStorageOptions>,
    }
    impl Builder {
        /// <p>The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data instances.</p>
        pub fn instance_type(mut self, input: crate::model::EsPartitionInstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p>The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data instances.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::EsPartitionInstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The number of instances in the specified domain cluster.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>The number of instances in the specified domain cluster.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// <p>A boolean value to indicate whether a dedicated master node is enabled. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes" target="_blank">About Dedicated Master Nodes</a> for more information.</p>
        pub fn dedicated_master_enabled(mut self, input: bool) -> Self {
            self.dedicated_master_enabled = Some(input);
            self
        }
        /// <p>A boolean value to indicate whether a dedicated master node is enabled. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes" target="_blank">About Dedicated Master Nodes</a> for more information.</p>
        pub fn set_dedicated_master_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.dedicated_master_enabled = input;
            self
        }
        /// <p>A boolean value to indicate whether zone awareness is enabled. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness" target="_blank">About Zone Awareness</a> for more information.</p>
        pub fn zone_awareness_enabled(mut self, input: bool) -> Self {
            self.zone_awareness_enabled = Some(input);
            self
        }
        /// <p>A boolean value to indicate whether zone awareness is enabled. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness" target="_blank">About Zone Awareness</a> for more information.</p>
        pub fn set_zone_awareness_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.zone_awareness_enabled = input;
            self
        }
        /// <p>Specifies the zone awareness configuration for a domain when zone awareness is enabled.</p>
        pub fn zone_awareness_config(mut self, input: crate::model::ZoneAwarenessConfig) -> Self {
            self.zone_awareness_config = Some(input);
            self
        }
        /// <p>Specifies the zone awareness configuration for a domain when zone awareness is enabled.</p>
        pub fn set_zone_awareness_config(
            mut self,
            input: std::option::Option<crate::model::ZoneAwarenessConfig>,
        ) -> Self {
            self.zone_awareness_config = input;
            self
        }
        /// <p>The instance type for a dedicated master node.</p>
        pub fn dedicated_master_type(
            mut self,
            input: crate::model::EsPartitionInstanceType,
        ) -> Self {
            self.dedicated_master_type = Some(input);
            self
        }
        /// <p>The instance type for a dedicated master node.</p>
        pub fn set_dedicated_master_type(
            mut self,
            input: std::option::Option<crate::model::EsPartitionInstanceType>,
        ) -> Self {
            self.dedicated_master_type = input;
            self
        }
        /// <p>Total number of dedicated master nodes, active and on standby, for the cluster.</p>
        pub fn dedicated_master_count(mut self, input: i32) -> Self {
            self.dedicated_master_count = Some(input);
            self
        }
        /// <p>Total number of dedicated master nodes, active and on standby, for the cluster.</p>
        pub fn set_dedicated_master_count(mut self, input: std::option::Option<i32>) -> Self {
            self.dedicated_master_count = input;
            self
        }
        /// <p>True to enable warm storage.</p>
        pub fn warm_enabled(mut self, input: bool) -> Self {
            self.warm_enabled = Some(input);
            self
        }
        /// <p>True to enable warm storage.</p>
        pub fn set_warm_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.warm_enabled = input;
            self
        }
        /// <p>The instance type for the Elasticsearch cluster's warm nodes.</p>
        pub fn warm_type(mut self, input: crate::model::EsWarmPartitionInstanceType) -> Self {
            self.warm_type = Some(input);
            self
        }
        /// <p>The instance type for the Elasticsearch cluster's warm nodes.</p>
        pub fn set_warm_type(
            mut self,
            input: std::option::Option<crate::model::EsWarmPartitionInstanceType>,
        ) -> Self {
            self.warm_type = input;
            self
        }
        /// <p>The number of warm nodes in the cluster.</p>
        pub fn warm_count(mut self, input: i32) -> Self {
            self.warm_count = Some(input);
            self
        }
        /// <p>The number of warm nodes in the cluster.</p>
        pub fn set_warm_count(mut self, input: std::option::Option<i32>) -> Self {
            self.warm_count = input;
            self
        }
        /// <p>Specifies the <code>ColdStorageOptions</code> config for Elasticsearch Domain</p>
        pub fn cold_storage_options(mut self, input: crate::model::ColdStorageOptions) -> Self {
            self.cold_storage_options = Some(input);
            self
        }
        /// <p>Specifies the <code>ColdStorageOptions</code> config for Elasticsearch Domain</p>
        pub fn set_cold_storage_options(
            mut self,
            input: std::option::Option<crate::model::ColdStorageOptions>,
        ) -> Self {
            self.cold_storage_options = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticsearchClusterConfig`](crate::model::ElasticsearchClusterConfig)
        pub fn build(self) -> crate::model::ElasticsearchClusterConfig {
            crate::model::ElasticsearchClusterConfig {
                instance_type: self.instance_type,
                instance_count: self.instance_count,
                dedicated_master_enabled: self.dedicated_master_enabled,
                zone_awareness_enabled: self.zone_awareness_enabled,
                zone_awareness_config: self.zone_awareness_config,
                dedicated_master_type: self.dedicated_master_type,
                dedicated_master_count: self.dedicated_master_count,
                warm_enabled: self.warm_enabled,
                warm_type: self.warm_type,
                warm_count: self.warm_count,
                cold_storage_options: self.cold_storage_options,
            }
        }
    }
}
impl ElasticsearchClusterConfig {
    /// Creates a new builder-style object to manufacture [`ElasticsearchClusterConfig`](crate::model::ElasticsearchClusterConfig)
    pub fn builder() -> crate::model::elasticsearch_cluster_config::Builder {
        crate::model::elasticsearch_cluster_config::Builder::default()
    }
}

/// <p>Specifies the configuration for cold storage options such as enabled</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColdStorageOptions {
    /// <p>Enable cold storage option. Accepted values true or false</p>
    pub enabled: std::option::Option<bool>,
}
impl ColdStorageOptions {
    /// <p>Enable cold storage option. Accepted values true or false</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for ColdStorageOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColdStorageOptions");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`ColdStorageOptions`](crate::model::ColdStorageOptions)
pub mod cold_storage_options {
    /// A builder for [`ColdStorageOptions`](crate::model::ColdStorageOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Enable cold storage option. Accepted values true or false</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Enable cold storage option. Accepted values true or false</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`ColdStorageOptions`](crate::model::ColdStorageOptions)
        pub fn build(self) -> crate::model::ColdStorageOptions {
            crate::model::ColdStorageOptions {
                enabled: self.enabled,
            }
        }
    }
}
impl ColdStorageOptions {
    /// Creates a new builder-style object to manufacture [`ColdStorageOptions`](crate::model::ColdStorageOptions)
    pub fn builder() -> crate::model::cold_storage_options::Builder {
        crate::model::cold_storage_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EsWarmPartitionInstanceType {
    #[allow(missing_docs)] // documentation missing in model
    Ultrawarm1LargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    Ultrawarm1MediumElasticsearch,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EsWarmPartitionInstanceType {
    fn from(s: &str) -> Self {
        match s {
            "ultrawarm1.large.elasticsearch" => {
                EsWarmPartitionInstanceType::Ultrawarm1LargeElasticsearch
            }
            "ultrawarm1.medium.elasticsearch" => {
                EsWarmPartitionInstanceType::Ultrawarm1MediumElasticsearch
            }
            other => EsWarmPartitionInstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EsWarmPartitionInstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EsWarmPartitionInstanceType::from(s))
    }
}
impl EsWarmPartitionInstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EsWarmPartitionInstanceType::Ultrawarm1LargeElasticsearch => {
                "ultrawarm1.large.elasticsearch"
            }
            EsWarmPartitionInstanceType::Ultrawarm1MediumElasticsearch => {
                "ultrawarm1.medium.elasticsearch"
            }
            EsWarmPartitionInstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ultrawarm1.large.elasticsearch",
            "ultrawarm1.medium.elasticsearch",
        ]
    }
}
impl AsRef<str> for EsWarmPartitionInstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EsPartitionInstanceType {
    #[allow(missing_docs)] // documentation missing in model
    C42xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    C44xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    C48xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    C4LargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    C4XlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    C518xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    C52xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    C54xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    C59xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    C5LargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    C5XlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    D22xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    D24xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    D28xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    D2XlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    I22xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    I2XlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    I316xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    I32xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    I34xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    I38xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    I3LargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    I3XlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M32xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M3LargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M3MediumElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M3XlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M410xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M42xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M44xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M4LargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M4XlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M512xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M52xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M54xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M5LargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    M5XlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R32xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R34xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R38xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R3LargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R3XlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R416xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R42xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R44xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R48xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R4LargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R4XlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R512xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R52xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R54xlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R5LargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    R5XlargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    T2MediumElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    T2MicroElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    T2SmallElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    Ultrawarm1LargeElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    Ultrawarm1MediumElasticsearch,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EsPartitionInstanceType {
    fn from(s: &str) -> Self {
        match s {
            "c4.2xlarge.elasticsearch" => EsPartitionInstanceType::C42xlargeElasticsearch,
            "c4.4xlarge.elasticsearch" => EsPartitionInstanceType::C44xlargeElasticsearch,
            "c4.8xlarge.elasticsearch" => EsPartitionInstanceType::C48xlargeElasticsearch,
            "c4.large.elasticsearch" => EsPartitionInstanceType::C4LargeElasticsearch,
            "c4.xlarge.elasticsearch" => EsPartitionInstanceType::C4XlargeElasticsearch,
            "c5.18xlarge.elasticsearch" => EsPartitionInstanceType::C518xlargeElasticsearch,
            "c5.2xlarge.elasticsearch" => EsPartitionInstanceType::C52xlargeElasticsearch,
            "c5.4xlarge.elasticsearch" => EsPartitionInstanceType::C54xlargeElasticsearch,
            "c5.9xlarge.elasticsearch" => EsPartitionInstanceType::C59xlargeElasticsearch,
            "c5.large.elasticsearch" => EsPartitionInstanceType::C5LargeElasticsearch,
            "c5.xlarge.elasticsearch" => EsPartitionInstanceType::C5XlargeElasticsearch,
            "d2.2xlarge.elasticsearch" => EsPartitionInstanceType::D22xlargeElasticsearch,
            "d2.4xlarge.elasticsearch" => EsPartitionInstanceType::D24xlargeElasticsearch,
            "d2.8xlarge.elasticsearch" => EsPartitionInstanceType::D28xlargeElasticsearch,
            "d2.xlarge.elasticsearch" => EsPartitionInstanceType::D2XlargeElasticsearch,
            "i2.2xlarge.elasticsearch" => EsPartitionInstanceType::I22xlargeElasticsearch,
            "i2.xlarge.elasticsearch" => EsPartitionInstanceType::I2XlargeElasticsearch,
            "i3.16xlarge.elasticsearch" => EsPartitionInstanceType::I316xlargeElasticsearch,
            "i3.2xlarge.elasticsearch" => EsPartitionInstanceType::I32xlargeElasticsearch,
            "i3.4xlarge.elasticsearch" => EsPartitionInstanceType::I34xlargeElasticsearch,
            "i3.8xlarge.elasticsearch" => EsPartitionInstanceType::I38xlargeElasticsearch,
            "i3.large.elasticsearch" => EsPartitionInstanceType::I3LargeElasticsearch,
            "i3.xlarge.elasticsearch" => EsPartitionInstanceType::I3XlargeElasticsearch,
            "m3.2xlarge.elasticsearch" => EsPartitionInstanceType::M32xlargeElasticsearch,
            "m3.large.elasticsearch" => EsPartitionInstanceType::M3LargeElasticsearch,
            "m3.medium.elasticsearch" => EsPartitionInstanceType::M3MediumElasticsearch,
            "m3.xlarge.elasticsearch" => EsPartitionInstanceType::M3XlargeElasticsearch,
            "m4.10xlarge.elasticsearch" => EsPartitionInstanceType::M410xlargeElasticsearch,
            "m4.2xlarge.elasticsearch" => EsPartitionInstanceType::M42xlargeElasticsearch,
            "m4.4xlarge.elasticsearch" => EsPartitionInstanceType::M44xlargeElasticsearch,
            "m4.large.elasticsearch" => EsPartitionInstanceType::M4LargeElasticsearch,
            "m4.xlarge.elasticsearch" => EsPartitionInstanceType::M4XlargeElasticsearch,
            "m5.12xlarge.elasticsearch" => EsPartitionInstanceType::M512xlargeElasticsearch,
            "m5.2xlarge.elasticsearch" => EsPartitionInstanceType::M52xlargeElasticsearch,
            "m5.4xlarge.elasticsearch" => EsPartitionInstanceType::M54xlargeElasticsearch,
            "m5.large.elasticsearch" => EsPartitionInstanceType::M5LargeElasticsearch,
            "m5.xlarge.elasticsearch" => EsPartitionInstanceType::M5XlargeElasticsearch,
            "r3.2xlarge.elasticsearch" => EsPartitionInstanceType::R32xlargeElasticsearch,
            "r3.4xlarge.elasticsearch" => EsPartitionInstanceType::R34xlargeElasticsearch,
            "r3.8xlarge.elasticsearch" => EsPartitionInstanceType::R38xlargeElasticsearch,
            "r3.large.elasticsearch" => EsPartitionInstanceType::R3LargeElasticsearch,
            "r3.xlarge.elasticsearch" => EsPartitionInstanceType::R3XlargeElasticsearch,
            "r4.16xlarge.elasticsearch" => EsPartitionInstanceType::R416xlargeElasticsearch,
            "r4.2xlarge.elasticsearch" => EsPartitionInstanceType::R42xlargeElasticsearch,
            "r4.4xlarge.elasticsearch" => EsPartitionInstanceType::R44xlargeElasticsearch,
            "r4.8xlarge.elasticsearch" => EsPartitionInstanceType::R48xlargeElasticsearch,
            "r4.large.elasticsearch" => EsPartitionInstanceType::R4LargeElasticsearch,
            "r4.xlarge.elasticsearch" => EsPartitionInstanceType::R4XlargeElasticsearch,
            "r5.12xlarge.elasticsearch" => EsPartitionInstanceType::R512xlargeElasticsearch,
            "r5.2xlarge.elasticsearch" => EsPartitionInstanceType::R52xlargeElasticsearch,
            "r5.4xlarge.elasticsearch" => EsPartitionInstanceType::R54xlargeElasticsearch,
            "r5.large.elasticsearch" => EsPartitionInstanceType::R5LargeElasticsearch,
            "r5.xlarge.elasticsearch" => EsPartitionInstanceType::R5XlargeElasticsearch,
            "t2.medium.elasticsearch" => EsPartitionInstanceType::T2MediumElasticsearch,
            "t2.micro.elasticsearch" => EsPartitionInstanceType::T2MicroElasticsearch,
            "t2.small.elasticsearch" => EsPartitionInstanceType::T2SmallElasticsearch,
            "ultrawarm1.large.elasticsearch" => {
                EsPartitionInstanceType::Ultrawarm1LargeElasticsearch
            }
            "ultrawarm1.medium.elasticsearch" => {
                EsPartitionInstanceType::Ultrawarm1MediumElasticsearch
            }
            other => EsPartitionInstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EsPartitionInstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EsPartitionInstanceType::from(s))
    }
}
impl EsPartitionInstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EsPartitionInstanceType::C42xlargeElasticsearch => "c4.2xlarge.elasticsearch",
            EsPartitionInstanceType::C44xlargeElasticsearch => "c4.4xlarge.elasticsearch",
            EsPartitionInstanceType::C48xlargeElasticsearch => "c4.8xlarge.elasticsearch",
            EsPartitionInstanceType::C4LargeElasticsearch => "c4.large.elasticsearch",
            EsPartitionInstanceType::C4XlargeElasticsearch => "c4.xlarge.elasticsearch",
            EsPartitionInstanceType::C518xlargeElasticsearch => "c5.18xlarge.elasticsearch",
            EsPartitionInstanceType::C52xlargeElasticsearch => "c5.2xlarge.elasticsearch",
            EsPartitionInstanceType::C54xlargeElasticsearch => "c5.4xlarge.elasticsearch",
            EsPartitionInstanceType::C59xlargeElasticsearch => "c5.9xlarge.elasticsearch",
            EsPartitionInstanceType::C5LargeElasticsearch => "c5.large.elasticsearch",
            EsPartitionInstanceType::C5XlargeElasticsearch => "c5.xlarge.elasticsearch",
            EsPartitionInstanceType::D22xlargeElasticsearch => "d2.2xlarge.elasticsearch",
            EsPartitionInstanceType::D24xlargeElasticsearch => "d2.4xlarge.elasticsearch",
            EsPartitionInstanceType::D28xlargeElasticsearch => "d2.8xlarge.elasticsearch",
            EsPartitionInstanceType::D2XlargeElasticsearch => "d2.xlarge.elasticsearch",
            EsPartitionInstanceType::I22xlargeElasticsearch => "i2.2xlarge.elasticsearch",
            EsPartitionInstanceType::I2XlargeElasticsearch => "i2.xlarge.elasticsearch",
            EsPartitionInstanceType::I316xlargeElasticsearch => "i3.16xlarge.elasticsearch",
            EsPartitionInstanceType::I32xlargeElasticsearch => "i3.2xlarge.elasticsearch",
            EsPartitionInstanceType::I34xlargeElasticsearch => "i3.4xlarge.elasticsearch",
            EsPartitionInstanceType::I38xlargeElasticsearch => "i3.8xlarge.elasticsearch",
            EsPartitionInstanceType::I3LargeElasticsearch => "i3.large.elasticsearch",
            EsPartitionInstanceType::I3XlargeElasticsearch => "i3.xlarge.elasticsearch",
            EsPartitionInstanceType::M32xlargeElasticsearch => "m3.2xlarge.elasticsearch",
            EsPartitionInstanceType::M3LargeElasticsearch => "m3.large.elasticsearch",
            EsPartitionInstanceType::M3MediumElasticsearch => "m3.medium.elasticsearch",
            EsPartitionInstanceType::M3XlargeElasticsearch => "m3.xlarge.elasticsearch",
            EsPartitionInstanceType::M410xlargeElasticsearch => "m4.10xlarge.elasticsearch",
            EsPartitionInstanceType::M42xlargeElasticsearch => "m4.2xlarge.elasticsearch",
            EsPartitionInstanceType::M44xlargeElasticsearch => "m4.4xlarge.elasticsearch",
            EsPartitionInstanceType::M4LargeElasticsearch => "m4.large.elasticsearch",
            EsPartitionInstanceType::M4XlargeElasticsearch => "m4.xlarge.elasticsearch",
            EsPartitionInstanceType::M512xlargeElasticsearch => "m5.12xlarge.elasticsearch",
            EsPartitionInstanceType::M52xlargeElasticsearch => "m5.2xlarge.elasticsearch",
            EsPartitionInstanceType::M54xlargeElasticsearch => "m5.4xlarge.elasticsearch",
            EsPartitionInstanceType::M5LargeElasticsearch => "m5.large.elasticsearch",
            EsPartitionInstanceType::M5XlargeElasticsearch => "m5.xlarge.elasticsearch",
            EsPartitionInstanceType::R32xlargeElasticsearch => "r3.2xlarge.elasticsearch",
            EsPartitionInstanceType::R34xlargeElasticsearch => "r3.4xlarge.elasticsearch",
            EsPartitionInstanceType::R38xlargeElasticsearch => "r3.8xlarge.elasticsearch",
            EsPartitionInstanceType::R3LargeElasticsearch => "r3.large.elasticsearch",
            EsPartitionInstanceType::R3XlargeElasticsearch => "r3.xlarge.elasticsearch",
            EsPartitionInstanceType::R416xlargeElasticsearch => "r4.16xlarge.elasticsearch",
            EsPartitionInstanceType::R42xlargeElasticsearch => "r4.2xlarge.elasticsearch",
            EsPartitionInstanceType::R44xlargeElasticsearch => "r4.4xlarge.elasticsearch",
            EsPartitionInstanceType::R48xlargeElasticsearch => "r4.8xlarge.elasticsearch",
            EsPartitionInstanceType::R4LargeElasticsearch => "r4.large.elasticsearch",
            EsPartitionInstanceType::R4XlargeElasticsearch => "r4.xlarge.elasticsearch",
            EsPartitionInstanceType::R512xlargeElasticsearch => "r5.12xlarge.elasticsearch",
            EsPartitionInstanceType::R52xlargeElasticsearch => "r5.2xlarge.elasticsearch",
            EsPartitionInstanceType::R54xlargeElasticsearch => "r5.4xlarge.elasticsearch",
            EsPartitionInstanceType::R5LargeElasticsearch => "r5.large.elasticsearch",
            EsPartitionInstanceType::R5XlargeElasticsearch => "r5.xlarge.elasticsearch",
            EsPartitionInstanceType::T2MediumElasticsearch => "t2.medium.elasticsearch",
            EsPartitionInstanceType::T2MicroElasticsearch => "t2.micro.elasticsearch",
            EsPartitionInstanceType::T2SmallElasticsearch => "t2.small.elasticsearch",
            EsPartitionInstanceType::Ultrawarm1LargeElasticsearch => {
                "ultrawarm1.large.elasticsearch"
            }
            EsPartitionInstanceType::Ultrawarm1MediumElasticsearch => {
                "ultrawarm1.medium.elasticsearch"
            }
            EsPartitionInstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "c4.2xlarge.elasticsearch",
            "c4.4xlarge.elasticsearch",
            "c4.8xlarge.elasticsearch",
            "c4.large.elasticsearch",
            "c4.xlarge.elasticsearch",
            "c5.18xlarge.elasticsearch",
            "c5.2xlarge.elasticsearch",
            "c5.4xlarge.elasticsearch",
            "c5.9xlarge.elasticsearch",
            "c5.large.elasticsearch",
            "c5.xlarge.elasticsearch",
            "d2.2xlarge.elasticsearch",
            "d2.4xlarge.elasticsearch",
            "d2.8xlarge.elasticsearch",
            "d2.xlarge.elasticsearch",
            "i2.2xlarge.elasticsearch",
            "i2.xlarge.elasticsearch",
            "i3.16xlarge.elasticsearch",
            "i3.2xlarge.elasticsearch",
            "i3.4xlarge.elasticsearch",
            "i3.8xlarge.elasticsearch",
            "i3.large.elasticsearch",
            "i3.xlarge.elasticsearch",
            "m3.2xlarge.elasticsearch",
            "m3.large.elasticsearch",
            "m3.medium.elasticsearch",
            "m3.xlarge.elasticsearch",
            "m4.10xlarge.elasticsearch",
            "m4.2xlarge.elasticsearch",
            "m4.4xlarge.elasticsearch",
            "m4.large.elasticsearch",
            "m4.xlarge.elasticsearch",
            "m5.12xlarge.elasticsearch",
            "m5.2xlarge.elasticsearch",
            "m5.4xlarge.elasticsearch",
            "m5.large.elasticsearch",
            "m5.xlarge.elasticsearch",
            "r3.2xlarge.elasticsearch",
            "r3.4xlarge.elasticsearch",
            "r3.8xlarge.elasticsearch",
            "r3.large.elasticsearch",
            "r3.xlarge.elasticsearch",
            "r4.16xlarge.elasticsearch",
            "r4.2xlarge.elasticsearch",
            "r4.4xlarge.elasticsearch",
            "r4.8xlarge.elasticsearch",
            "r4.large.elasticsearch",
            "r4.xlarge.elasticsearch",
            "r5.12xlarge.elasticsearch",
            "r5.2xlarge.elasticsearch",
            "r5.4xlarge.elasticsearch",
            "r5.large.elasticsearch",
            "r5.xlarge.elasticsearch",
            "t2.medium.elasticsearch",
            "t2.micro.elasticsearch",
            "t2.small.elasticsearch",
            "ultrawarm1.large.elasticsearch",
            "ultrawarm1.medium.elasticsearch",
        ]
    }
}
impl AsRef<str> for EsPartitionInstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the zone awareness configuration for the domain cluster, such as the number of availability zones.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ZoneAwarenessConfig {
    /// <p>An integer value to indicate the number of availability zones for a domain when zone awareness is enabled. This should be equal to number of subnets if VPC endpoints is enabled</p>
    pub availability_zone_count: std::option::Option<i32>,
}
impl ZoneAwarenessConfig {
    /// <p>An integer value to indicate the number of availability zones for a domain when zone awareness is enabled. This should be equal to number of subnets if VPC endpoints is enabled</p>
    pub fn availability_zone_count(&self) -> std::option::Option<i32> {
        self.availability_zone_count
    }
}
impl std::fmt::Debug for ZoneAwarenessConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ZoneAwarenessConfig");
        formatter.field("availability_zone_count", &self.availability_zone_count);
        formatter.finish()
    }
}
/// See [`ZoneAwarenessConfig`](crate::model::ZoneAwarenessConfig)
pub mod zone_awareness_config {
    /// A builder for [`ZoneAwarenessConfig`](crate::model::ZoneAwarenessConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An integer value to indicate the number of availability zones for a domain when zone awareness is enabled. This should be equal to number of subnets if VPC endpoints is enabled</p>
        pub fn availability_zone_count(mut self, input: i32) -> Self {
            self.availability_zone_count = Some(input);
            self
        }
        /// <p>An integer value to indicate the number of availability zones for a domain when zone awareness is enabled. This should be equal to number of subnets if VPC endpoints is enabled</p>
        pub fn set_availability_zone_count(mut self, input: std::option::Option<i32>) -> Self {
            self.availability_zone_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ZoneAwarenessConfig`](crate::model::ZoneAwarenessConfig)
        pub fn build(self) -> crate::model::ZoneAwarenessConfig {
            crate::model::ZoneAwarenessConfig {
                availability_zone_count: self.availability_zone_count,
            }
        }
    }
}
impl ZoneAwarenessConfig {
    /// Creates a new builder-style object to manufacture [`ZoneAwarenessConfig`](crate::model::ZoneAwarenessConfig)
    pub fn builder() -> crate::model::zone_awareness_config::Builder {
        crate::model::zone_awareness_config::Builder::default()
    }
}

/// <p> Status of the Elasticsearch version options for the specified Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticsearchVersionStatus {
    /// <p> Specifies the Elasticsearch version for the specified Elasticsearch domain.</p>
    pub options: std::option::Option<std::string::String>,
    /// <p> Specifies the status of the Elasticsearch version options for the specified Elasticsearch domain.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl ElasticsearchVersionStatus {
    /// <p> Specifies the Elasticsearch version for the specified Elasticsearch domain.</p>
    pub fn options(&self) -> std::option::Option<&str> {
        self.options.as_deref()
    }
    /// <p> Specifies the status of the Elasticsearch version options for the specified Elasticsearch domain.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ElasticsearchVersionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticsearchVersionStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ElasticsearchVersionStatus`](crate::model::ElasticsearchVersionStatus)
pub mod elasticsearch_version_status {
    /// A builder for [`ElasticsearchVersionStatus`](crate::model::ElasticsearchVersionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p> Specifies the Elasticsearch version for the specified Elasticsearch domain.</p>
        pub fn options(mut self, input: impl Into<std::string::String>) -> Self {
            self.options = Some(input.into());
            self
        }
        /// <p> Specifies the Elasticsearch version for the specified Elasticsearch domain.</p>
        pub fn set_options(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.options = input;
            self
        }
        /// <p> Specifies the status of the Elasticsearch version options for the specified Elasticsearch domain.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> Specifies the status of the Elasticsearch version options for the specified Elasticsearch domain.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticsearchVersionStatus`](crate::model::ElasticsearchVersionStatus)
        pub fn build(self) -> crate::model::ElasticsearchVersionStatus {
            crate::model::ElasticsearchVersionStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl ElasticsearchVersionStatus {
    /// Creates a new builder-style object to manufacture [`ElasticsearchVersionStatus`](crate::model::ElasticsearchVersionStatus)
    pub fn builder() -> crate::model::elasticsearch_version_status::Builder {
        crate::model::elasticsearch_version_status::Builder::default()
    }
}

/// <p>Specifies the advanced security configuration: whether advanced security is enabled, whether the internal database option is enabled, master username and password (if internal database is enabled), and master user ARN (if IAM is enabled).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdvancedSecurityOptionsInput {
    /// <p>True if advanced security is enabled.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>True if the internal user database is enabled.</p>
    pub internal_user_database_enabled: std::option::Option<bool>,
    /// <p>Credentials for the master user: username and password, ARN, or both.</p>
    pub master_user_options: std::option::Option<crate::model::MasterUserOptions>,
    /// <p>Specifies the SAML application configuration for the domain.</p>
    pub saml_options: std::option::Option<crate::model::SamlOptionsInput>,
}
impl AdvancedSecurityOptionsInput {
    /// <p>True if advanced security is enabled.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>True if the internal user database is enabled.</p>
    pub fn internal_user_database_enabled(&self) -> std::option::Option<bool> {
        self.internal_user_database_enabled
    }
    /// <p>Credentials for the master user: username and password, ARN, or both.</p>
    pub fn master_user_options(&self) -> std::option::Option<&crate::model::MasterUserOptions> {
        self.master_user_options.as_ref()
    }
    /// <p>Specifies the SAML application configuration for the domain.</p>
    pub fn saml_options(&self) -> std::option::Option<&crate::model::SamlOptionsInput> {
        self.saml_options.as_ref()
    }
}
impl std::fmt::Debug for AdvancedSecurityOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdvancedSecurityOptionsInput");
        formatter.field("enabled", &self.enabled);
        formatter.field(
            "internal_user_database_enabled",
            &self.internal_user_database_enabled,
        );
        formatter.field("master_user_options", &self.master_user_options);
        formatter.field("saml_options", &self.saml_options);
        formatter.finish()
    }
}
/// See [`AdvancedSecurityOptionsInput`](crate::model::AdvancedSecurityOptionsInput)
pub mod advanced_security_options_input {
    /// A builder for [`AdvancedSecurityOptionsInput`](crate::model::AdvancedSecurityOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) internal_user_database_enabled: std::option::Option<bool>,
        pub(crate) master_user_options: std::option::Option<crate::model::MasterUserOptions>,
        pub(crate) saml_options: std::option::Option<crate::model::SamlOptionsInput>,
    }
    impl Builder {
        /// <p>True if advanced security is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>True if advanced security is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>True if the internal user database is enabled.</p>
        pub fn internal_user_database_enabled(mut self, input: bool) -> Self {
            self.internal_user_database_enabled = Some(input);
            self
        }
        /// <p>True if the internal user database is enabled.</p>
        pub fn set_internal_user_database_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.internal_user_database_enabled = input;
            self
        }
        /// <p>Credentials for the master user: username and password, ARN, or both.</p>
        pub fn master_user_options(mut self, input: crate::model::MasterUserOptions) -> Self {
            self.master_user_options = Some(input);
            self
        }
        /// <p>Credentials for the master user: username and password, ARN, or both.</p>
        pub fn set_master_user_options(
            mut self,
            input: std::option::Option<crate::model::MasterUserOptions>,
        ) -> Self {
            self.master_user_options = input;
            self
        }
        /// <p>Specifies the SAML application configuration for the domain.</p>
        pub fn saml_options(mut self, input: crate::model::SamlOptionsInput) -> Self {
            self.saml_options = Some(input);
            self
        }
        /// <p>Specifies the SAML application configuration for the domain.</p>
        pub fn set_saml_options(
            mut self,
            input: std::option::Option<crate::model::SamlOptionsInput>,
        ) -> Self {
            self.saml_options = input;
            self
        }
        /// Consumes the builder and constructs a [`AdvancedSecurityOptionsInput`](crate::model::AdvancedSecurityOptionsInput)
        pub fn build(self) -> crate::model::AdvancedSecurityOptionsInput {
            crate::model::AdvancedSecurityOptionsInput {
                enabled: self.enabled,
                internal_user_database_enabled: self.internal_user_database_enabled,
                master_user_options: self.master_user_options,
                saml_options: self.saml_options,
            }
        }
    }
}
impl AdvancedSecurityOptionsInput {
    /// Creates a new builder-style object to manufacture [`AdvancedSecurityOptionsInput`](crate::model::AdvancedSecurityOptionsInput)
    pub fn builder() -> crate::model::advanced_security_options_input::Builder {
        crate::model::advanced_security_options_input::Builder::default()
    }
}

/// <p>Specifies the SAML application configuration for the domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SamlOptionsInput {
    /// <p>True if SAML is enabled.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>Specifies the SAML Identity Provider's information.</p>
    pub idp: std::option::Option<crate::model::SamlIdp>,
    /// <p>The SAML master username, which is stored in the Amazon Elasticsearch Service domain's internal database.</p>
    pub master_user_name: std::option::Option<std::string::String>,
    /// <p>The backend role to which the SAML master user is mapped to.</p>
    pub master_backend_role: std::option::Option<std::string::String>,
    /// <p>The key to use for matching the SAML Subject attribute.</p>
    pub subject_key: std::option::Option<std::string::String>,
    /// <p>The key to use for matching the SAML Roles attribute.</p>
    pub roles_key: std::option::Option<std::string::String>,
    /// <p>The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60.</p>
    pub session_timeout_minutes: std::option::Option<i32>,
}
impl SamlOptionsInput {
    /// <p>True if SAML is enabled.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>Specifies the SAML Identity Provider's information.</p>
    pub fn idp(&self) -> std::option::Option<&crate::model::SamlIdp> {
        self.idp.as_ref()
    }
    /// <p>The SAML master username, which is stored in the Amazon Elasticsearch Service domain's internal database.</p>
    pub fn master_user_name(&self) -> std::option::Option<&str> {
        self.master_user_name.as_deref()
    }
    /// <p>The backend role to which the SAML master user is mapped to.</p>
    pub fn master_backend_role(&self) -> std::option::Option<&str> {
        self.master_backend_role.as_deref()
    }
    /// <p>The key to use for matching the SAML Subject attribute.</p>
    pub fn subject_key(&self) -> std::option::Option<&str> {
        self.subject_key.as_deref()
    }
    /// <p>The key to use for matching the SAML Roles attribute.</p>
    pub fn roles_key(&self) -> std::option::Option<&str> {
        self.roles_key.as_deref()
    }
    /// <p>The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60.</p>
    pub fn session_timeout_minutes(&self) -> std::option::Option<i32> {
        self.session_timeout_minutes
    }
}
impl std::fmt::Debug for SamlOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SamlOptionsInput");
        formatter.field("enabled", &self.enabled);
        formatter.field("idp", &self.idp);
        formatter.field("master_user_name", &"*** Sensitive Data Redacted ***");
        formatter.field("master_backend_role", &self.master_backend_role);
        formatter.field("subject_key", &self.subject_key);
        formatter.field("roles_key", &self.roles_key);
        formatter.field("session_timeout_minutes", &self.session_timeout_minutes);
        formatter.finish()
    }
}
/// See [`SamlOptionsInput`](crate::model::SamlOptionsInput)
pub mod saml_options_input {
    /// A builder for [`SamlOptionsInput`](crate::model::SamlOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) idp: std::option::Option<crate::model::SamlIdp>,
        pub(crate) master_user_name: std::option::Option<std::string::String>,
        pub(crate) master_backend_role: std::option::Option<std::string::String>,
        pub(crate) subject_key: std::option::Option<std::string::String>,
        pub(crate) roles_key: std::option::Option<std::string::String>,
        pub(crate) session_timeout_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>True if SAML is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>True if SAML is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Specifies the SAML Identity Provider's information.</p>
        pub fn idp(mut self, input: crate::model::SamlIdp) -> Self {
            self.idp = Some(input);
            self
        }
        /// <p>Specifies the SAML Identity Provider's information.</p>
        pub fn set_idp(mut self, input: std::option::Option<crate::model::SamlIdp>) -> Self {
            self.idp = input;
            self
        }
        /// <p>The SAML master username, which is stored in the Amazon Elasticsearch Service domain's internal database.</p>
        pub fn master_user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_name = Some(input.into());
            self
        }
        /// <p>The SAML master username, which is stored in the Amazon Elasticsearch Service domain's internal database.</p>
        pub fn set_master_user_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_name = input;
            self
        }
        /// <p>The backend role to which the SAML master user is mapped to.</p>
        pub fn master_backend_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_backend_role = Some(input.into());
            self
        }
        /// <p>The backend role to which the SAML master user is mapped to.</p>
        pub fn set_master_backend_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_backend_role = input;
            self
        }
        /// <p>The key to use for matching the SAML Subject attribute.</p>
        pub fn subject_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject_key = Some(input.into());
            self
        }
        /// <p>The key to use for matching the SAML Subject attribute.</p>
        pub fn set_subject_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject_key = input;
            self
        }
        /// <p>The key to use for matching the SAML Roles attribute.</p>
        pub fn roles_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.roles_key = Some(input.into());
            self
        }
        /// <p>The key to use for matching the SAML Roles attribute.</p>
        pub fn set_roles_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.roles_key = input;
            self
        }
        /// <p>The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60.</p>
        pub fn session_timeout_minutes(mut self, input: i32) -> Self {
            self.session_timeout_minutes = Some(input);
            self
        }
        /// <p>The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60.</p>
        pub fn set_session_timeout_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.session_timeout_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`SamlOptionsInput`](crate::model::SamlOptionsInput)
        pub fn build(self) -> crate::model::SamlOptionsInput {
            crate::model::SamlOptionsInput {
                enabled: self.enabled,
                idp: self.idp,
                master_user_name: self.master_user_name,
                master_backend_role: self.master_backend_role,
                subject_key: self.subject_key,
                roles_key: self.roles_key,
                session_timeout_minutes: self.session_timeout_minutes,
            }
        }
    }
}
impl SamlOptionsInput {
    /// Creates a new builder-style object to manufacture [`SamlOptionsInput`](crate::model::SamlOptionsInput)
    pub fn builder() -> crate::model::saml_options_input::Builder {
        crate::model::saml_options_input::Builder::default()
    }
}

/// <p>Credentials for the master user: username and password, ARN, or both.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MasterUserOptions {
    /// <p>ARN for the master user (if IAM is enabled).</p>
    pub master_user_arn: std::option::Option<std::string::String>,
    /// <p>The master user's username, which is stored in the Amazon Elasticsearch Service domain's internal database.</p>
    pub master_user_name: std::option::Option<std::string::String>,
    /// <p>The master user's password, which is stored in the Amazon Elasticsearch Service domain's internal database.</p>
    pub master_user_password: std::option::Option<std::string::String>,
}
impl MasterUserOptions {
    /// <p>ARN for the master user (if IAM is enabled).</p>
    pub fn master_user_arn(&self) -> std::option::Option<&str> {
        self.master_user_arn.as_deref()
    }
    /// <p>The master user's username, which is stored in the Amazon Elasticsearch Service domain's internal database.</p>
    pub fn master_user_name(&self) -> std::option::Option<&str> {
        self.master_user_name.as_deref()
    }
    /// <p>The master user's password, which is stored in the Amazon Elasticsearch Service domain's internal database.</p>
    pub fn master_user_password(&self) -> std::option::Option<&str> {
        self.master_user_password.as_deref()
    }
}
impl std::fmt::Debug for MasterUserOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MasterUserOptions");
        formatter.field("master_user_arn", &self.master_user_arn);
        formatter.field("master_user_name", &"*** Sensitive Data Redacted ***");
        formatter.field("master_user_password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`MasterUserOptions`](crate::model::MasterUserOptions)
pub mod master_user_options {
    /// A builder for [`MasterUserOptions`](crate::model::MasterUserOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) master_user_arn: std::option::Option<std::string::String>,
        pub(crate) master_user_name: std::option::Option<std::string::String>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ARN for the master user (if IAM is enabled).</p>
        pub fn master_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_arn = Some(input.into());
            self
        }
        /// <p>ARN for the master user (if IAM is enabled).</p>
        pub fn set_master_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_arn = input;
            self
        }
        /// <p>The master user's username, which is stored in the Amazon Elasticsearch Service domain's internal database.</p>
        pub fn master_user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_name = Some(input.into());
            self
        }
        /// <p>The master user's username, which is stored in the Amazon Elasticsearch Service domain's internal database.</p>
        pub fn set_master_user_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_name = input;
            self
        }
        /// <p>The master user's password, which is stored in the Amazon Elasticsearch Service domain's internal database.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>The master user's password, which is stored in the Amazon Elasticsearch Service domain's internal database.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// Consumes the builder and constructs a [`MasterUserOptions`](crate::model::MasterUserOptions)
        pub fn build(self) -> crate::model::MasterUserOptions {
            crate::model::MasterUserOptions {
                master_user_arn: self.master_user_arn,
                master_user_name: self.master_user_name,
                master_user_password: self.master_user_password,
            }
        }
    }
}
impl MasterUserOptions {
    /// Creates a new builder-style object to manufacture [`MasterUserOptions`](crate::model::MasterUserOptions)
    pub fn builder() -> crate::model::master_user_options::Builder {
        crate::model::master_user_options::Builder::default()
    }
}

/// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank"> VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcOptions {
    /// <p>Specifies the subnets for VPC endpoint.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the security groups for VPC endpoint.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VpcOptions {
    /// <p>Specifies the subnets for VPC endpoint.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>Specifies the security groups for VPC endpoint.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for VpcOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcOptions");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`VpcOptions`](crate::model::VpcOptions)
pub mod vpc_options {
    /// A builder for [`VpcOptions`](crate::model::VpcOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>Specifies the subnets for VPC endpoint.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>Specifies the subnets for VPC endpoint.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>Specifies the security groups for VPC endpoint.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>Specifies the security groups for VPC endpoint.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcOptions`](crate::model::VpcOptions)
        pub fn build(self) -> crate::model::VpcOptions {
            crate::model::VpcOptions {
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl VpcOptions {
    /// Creates a new builder-style object to manufacture [`VpcOptions`](crate::model::VpcOptions)
    pub fn builder() -> crate::model::vpc_options::Builder {
        crate::model::vpc_options::Builder::default()
    }
}

/// <p>The current options of an Elasticsearch domain service software options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceSoftwareOptions {
    /// <p>The current service software version that is present on the domain.</p>
    pub current_version: std::option::Option<std::string::String>,
    /// <p>The new service software version if one is available.</p>
    pub new_version: std::option::Option<std::string::String>,
    /// <p><code>True</code> if you are able to update you service software version. <code>False</code> if you are not able to update your service software version. </p>
    pub update_available: std::option::Option<bool>,
    /// <p><code>True</code> if you are able to cancel your service software version update. <code>False</code> if you are not able to cancel your service software version. </p>
    pub cancellable: std::option::Option<bool>,
    /// <p>The status of your service software update. This field can take the following values: <code>ELIGIBLE</code>, <code>PENDING_UPDATE</code>, <code>IN_PROGRESS</code>, <code>COMPLETED</code>, and <code>NOT_ELIGIBLE</code>.</p>
    pub update_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>The description of the <code>UpdateStatus</code>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Timestamp, in Epoch time, until which you can manually request a service software update. After this date, we automatically update your service software.</p>
    pub automated_update_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p><code>True</code> if a service software is never automatically updated. <code>False</code> if a service software is automatically updated after <code>AutomatedUpdateDate</code>. </p>
    pub optional_deployment: std::option::Option<bool>,
}
impl ServiceSoftwareOptions {
    /// <p>The current service software version that is present on the domain.</p>
    pub fn current_version(&self) -> std::option::Option<&str> {
        self.current_version.as_deref()
    }
    /// <p>The new service software version if one is available.</p>
    pub fn new_version(&self) -> std::option::Option<&str> {
        self.new_version.as_deref()
    }
    /// <p><code>True</code> if you are able to update you service software version. <code>False</code> if you are not able to update your service software version. </p>
    pub fn update_available(&self) -> std::option::Option<bool> {
        self.update_available
    }
    /// <p><code>True</code> if you are able to cancel your service software version update. <code>False</code> if you are not able to cancel your service software version. </p>
    pub fn cancellable(&self) -> std::option::Option<bool> {
        self.cancellable
    }
    /// <p>The status of your service software update. This field can take the following values: <code>ELIGIBLE</code>, <code>PENDING_UPDATE</code>, <code>IN_PROGRESS</code>, <code>COMPLETED</code>, and <code>NOT_ELIGIBLE</code>.</p>
    pub fn update_status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.update_status.as_ref()
    }
    /// <p>The description of the <code>UpdateStatus</code>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Timestamp, in Epoch time, until which you can manually request a service software update. After this date, we automatically update your service software.</p>
    pub fn automated_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.automated_update_date.as_ref()
    }
    /// <p><code>True</code> if a service software is never automatically updated. <code>False</code> if a service software is automatically updated after <code>AutomatedUpdateDate</code>. </p>
    pub fn optional_deployment(&self) -> std::option::Option<bool> {
        self.optional_deployment
    }
}
impl std::fmt::Debug for ServiceSoftwareOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceSoftwareOptions");
        formatter.field("current_version", &self.current_version);
        formatter.field("new_version", &self.new_version);
        formatter.field("update_available", &self.update_available);
        formatter.field("cancellable", &self.cancellable);
        formatter.field("update_status", &self.update_status);
        formatter.field("description", &self.description);
        formatter.field("automated_update_date", &self.automated_update_date);
        formatter.field("optional_deployment", &self.optional_deployment);
        formatter.finish()
    }
}
/// See [`ServiceSoftwareOptions`](crate::model::ServiceSoftwareOptions)
pub mod service_software_options {
    /// A builder for [`ServiceSoftwareOptions`](crate::model::ServiceSoftwareOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) current_version: std::option::Option<std::string::String>,
        pub(crate) new_version: std::option::Option<std::string::String>,
        pub(crate) update_available: std::option::Option<bool>,
        pub(crate) cancellable: std::option::Option<bool>,
        pub(crate) update_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) automated_update_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) optional_deployment: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The current service software version that is present on the domain.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_version = Some(input.into());
            self
        }
        /// <p>The current service software version that is present on the domain.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// <p>The new service software version if one is available.</p>
        pub fn new_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_version = Some(input.into());
            self
        }
        /// <p>The new service software version if one is available.</p>
        pub fn set_new_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.new_version = input;
            self
        }
        /// <p><code>True</code> if you are able to update you service software version. <code>False</code> if you are not able to update your service software version. </p>
        pub fn update_available(mut self, input: bool) -> Self {
            self.update_available = Some(input);
            self
        }
        /// <p><code>True</code> if you are able to update you service software version. <code>False</code> if you are not able to update your service software version. </p>
        pub fn set_update_available(mut self, input: std::option::Option<bool>) -> Self {
            self.update_available = input;
            self
        }
        /// <p><code>True</code> if you are able to cancel your service software version update. <code>False</code> if you are not able to cancel your service software version. </p>
        pub fn cancellable(mut self, input: bool) -> Self {
            self.cancellable = Some(input);
            self
        }
        /// <p><code>True</code> if you are able to cancel your service software version update. <code>False</code> if you are not able to cancel your service software version. </p>
        pub fn set_cancellable(mut self, input: std::option::Option<bool>) -> Self {
            self.cancellable = input;
            self
        }
        /// <p>The status of your service software update. This field can take the following values: <code>ELIGIBLE</code>, <code>PENDING_UPDATE</code>, <code>IN_PROGRESS</code>, <code>COMPLETED</code>, and <code>NOT_ELIGIBLE</code>.</p>
        pub fn update_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.update_status = Some(input);
            self
        }
        /// <p>The status of your service software update. This field can take the following values: <code>ELIGIBLE</code>, <code>PENDING_UPDATE</code>, <code>IN_PROGRESS</code>, <code>COMPLETED</code>, and <code>NOT_ELIGIBLE</code>.</p>
        pub fn set_update_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.update_status = input;
            self
        }
        /// <p>The description of the <code>UpdateStatus</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the <code>UpdateStatus</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Timestamp, in Epoch time, until which you can manually request a service software update. After this date, we automatically update your service software.</p>
        pub fn automated_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.automated_update_date = Some(input);
            self
        }
        /// <p>Timestamp, in Epoch time, until which you can manually request a service software update. After this date, we automatically update your service software.</p>
        pub fn set_automated_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.automated_update_date = input;
            self
        }
        /// <p><code>True</code> if a service software is never automatically updated. <code>False</code> if a service software is automatically updated after <code>AutomatedUpdateDate</code>. </p>
        pub fn optional_deployment(mut self, input: bool) -> Self {
            self.optional_deployment = Some(input);
            self
        }
        /// <p><code>True</code> if a service software is never automatically updated. <code>False</code> if a service software is automatically updated after <code>AutomatedUpdateDate</code>. </p>
        pub fn set_optional_deployment(mut self, input: std::option::Option<bool>) -> Self {
            self.optional_deployment = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceSoftwareOptions`](crate::model::ServiceSoftwareOptions)
        pub fn build(self) -> crate::model::ServiceSoftwareOptions {
            crate::model::ServiceSoftwareOptions {
                current_version: self.current_version,
                new_version: self.new_version,
                update_available: self.update_available,
                cancellable: self.cancellable,
                update_status: self.update_status,
                description: self.description,
                automated_update_date: self.automated_update_date,
                optional_deployment: self.optional_deployment,
            }
        }
    }
}
impl ServiceSoftwareOptions {
    /// Creates a new builder-style object to manufacture [`ServiceSoftwareOptions`](crate::model::ServiceSoftwareOptions)
    pub fn builder() -> crate::model::service_software_options::Builder {
        crate::model::service_software_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Eligible,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotEligible,
    #[allow(missing_docs)] // documentation missing in model
    PendingUpdate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => DeploymentStatus::Completed,
            "ELIGIBLE" => DeploymentStatus::Eligible,
            "IN_PROGRESS" => DeploymentStatus::InProgress,
            "NOT_ELIGIBLE" => DeploymentStatus::NotEligible,
            "PENDING_UPDATE" => DeploymentStatus::PendingUpdate,
            other => DeploymentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentStatus::from(s))
    }
}
impl DeploymentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentStatus::Completed => "COMPLETED",
            DeploymentStatus::Eligible => "ELIGIBLE",
            DeploymentStatus::InProgress => "IN_PROGRESS",
            DeploymentStatus::NotEligible => "NOT_ELIGIBLE",
            DeploymentStatus::PendingUpdate => "PENDING_UPDATE",
            DeploymentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "ELIGIBLE",
            "IN_PROGRESS",
            "NOT_ELIGIBLE",
            "PENDING_UPDATE",
        ]
    }
}
impl AsRef<str> for DeploymentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies details of an inbound connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InboundCrossClusterSearchConnection {
    /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
    pub source_domain_info: std::option::Option<crate::model::DomainInformation>,
    /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
    pub destination_domain_info: std::option::Option<crate::model::DomainInformation>,
    /// <p>Specifies the connection id for the inbound cross-cluster search connection.</p>
    pub cross_cluster_search_connection_id: std::option::Option<std::string::String>,
    /// <p>Specifies the <code><code>InboundCrossClusterSearchConnectionStatus</code></code> for the outbound connection.</p>
    pub connection_status:
        std::option::Option<crate::model::InboundCrossClusterSearchConnectionStatus>,
}
impl InboundCrossClusterSearchConnection {
    /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
    pub fn source_domain_info(&self) -> std::option::Option<&crate::model::DomainInformation> {
        self.source_domain_info.as_ref()
    }
    /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
    pub fn destination_domain_info(&self) -> std::option::Option<&crate::model::DomainInformation> {
        self.destination_domain_info.as_ref()
    }
    /// <p>Specifies the connection id for the inbound cross-cluster search connection.</p>
    pub fn cross_cluster_search_connection_id(&self) -> std::option::Option<&str> {
        self.cross_cluster_search_connection_id.as_deref()
    }
    /// <p>Specifies the <code><code>InboundCrossClusterSearchConnectionStatus</code></code> for the outbound connection.</p>
    pub fn connection_status(
        &self,
    ) -> std::option::Option<&crate::model::InboundCrossClusterSearchConnectionStatus> {
        self.connection_status.as_ref()
    }
}
impl std::fmt::Debug for InboundCrossClusterSearchConnection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InboundCrossClusterSearchConnection");
        formatter.field("source_domain_info", &self.source_domain_info);
        formatter.field("destination_domain_info", &self.destination_domain_info);
        formatter.field(
            "cross_cluster_search_connection_id",
            &self.cross_cluster_search_connection_id,
        );
        formatter.field("connection_status", &self.connection_status);
        formatter.finish()
    }
}
/// See [`InboundCrossClusterSearchConnection`](crate::model::InboundCrossClusterSearchConnection)
pub mod inbound_cross_cluster_search_connection {
    /// A builder for [`InboundCrossClusterSearchConnection`](crate::model::InboundCrossClusterSearchConnection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_domain_info: std::option::Option<crate::model::DomainInformation>,
        pub(crate) destination_domain_info: std::option::Option<crate::model::DomainInformation>,
        pub(crate) cross_cluster_search_connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_status:
            std::option::Option<crate::model::InboundCrossClusterSearchConnectionStatus>,
    }
    impl Builder {
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
        pub fn source_domain_info(mut self, input: crate::model::DomainInformation) -> Self {
            self.source_domain_info = Some(input);
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
        pub fn set_source_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformation>,
        ) -> Self {
            self.source_domain_info = input;
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
        pub fn destination_domain_info(mut self, input: crate::model::DomainInformation) -> Self {
            self.destination_domain_info = Some(input);
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
        pub fn set_destination_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformation>,
        ) -> Self {
            self.destination_domain_info = input;
            self
        }
        /// <p>Specifies the connection id for the inbound cross-cluster search connection.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = Some(input.into());
            self
        }
        /// <p>Specifies the connection id for the inbound cross-cluster search connection.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = input;
            self
        }
        /// <p>Specifies the <code><code>InboundCrossClusterSearchConnectionStatus</code></code> for the outbound connection.</p>
        pub fn connection_status(
            mut self,
            input: crate::model::InboundCrossClusterSearchConnectionStatus,
        ) -> Self {
            self.connection_status = Some(input);
            self
        }
        /// <p>Specifies the <code><code>InboundCrossClusterSearchConnectionStatus</code></code> for the outbound connection.</p>
        pub fn set_connection_status(
            mut self,
            input: std::option::Option<crate::model::InboundCrossClusterSearchConnectionStatus>,
        ) -> Self {
            self.connection_status = input;
            self
        }
        /// Consumes the builder and constructs a [`InboundCrossClusterSearchConnection`](crate::model::InboundCrossClusterSearchConnection)
        pub fn build(self) -> crate::model::InboundCrossClusterSearchConnection {
            crate::model::InboundCrossClusterSearchConnection {
                source_domain_info: self.source_domain_info,
                destination_domain_info: self.destination_domain_info,
                cross_cluster_search_connection_id: self.cross_cluster_search_connection_id,
                connection_status: self.connection_status,
            }
        }
    }
}
impl InboundCrossClusterSearchConnection {
    /// Creates a new builder-style object to manufacture [`InboundCrossClusterSearchConnection`](crate::model::InboundCrossClusterSearchConnection)
    pub fn builder() -> crate::model::inbound_cross_cluster_search_connection::Builder {
        crate::model::inbound_cross_cluster_search_connection::Builder::default()
    }
}

/// <p>Specifies the coonection status of an inbound cross-cluster search connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InboundCrossClusterSearchConnectionStatus {
    /// <p>The state code for inbound connection. This can be one of the following:</p>
    /// <ul>
    /// <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination domain owner.</li>
    /// <li>APPROVED: Inbound connection is pending acceptance by destination domain owner.</li>
    /// <li>REJECTING: Inbound connection rejection is in process.</li>
    /// <li>REJECTED: Inbound connection is rejected.</li>
    /// <li>DELETING: Inbound connection deletion is in progress.</li>
    /// <li>DELETED: Inbound connection is deleted and cannot be used further.</li>
    /// </ul>
    pub status_code:
        std::option::Option<crate::model::InboundCrossClusterSearchConnectionStatusCode>,
    /// <p>Specifies verbose information for the inbound connection status.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InboundCrossClusterSearchConnectionStatus {
    /// <p>The state code for inbound connection. This can be one of the following:</p>
    /// <ul>
    /// <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination domain owner.</li>
    /// <li>APPROVED: Inbound connection is pending acceptance by destination domain owner.</li>
    /// <li>REJECTING: Inbound connection rejection is in process.</li>
    /// <li>REJECTED: Inbound connection is rejected.</li>
    /// <li>DELETING: Inbound connection deletion is in progress.</li>
    /// <li>DELETED: Inbound connection is deleted and cannot be used further.</li>
    /// </ul>
    pub fn status_code(
        &self,
    ) -> std::option::Option<&crate::model::InboundCrossClusterSearchConnectionStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>Specifies verbose information for the inbound connection status.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for InboundCrossClusterSearchConnectionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InboundCrossClusterSearchConnectionStatus");
        formatter.field("status_code", &self.status_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`InboundCrossClusterSearchConnectionStatus`](crate::model::InboundCrossClusterSearchConnectionStatus)
pub mod inbound_cross_cluster_search_connection_status {
    /// A builder for [`InboundCrossClusterSearchConnectionStatus`](crate::model::InboundCrossClusterSearchConnectionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code:
            std::option::Option<crate::model::InboundCrossClusterSearchConnectionStatusCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state code for inbound connection. This can be one of the following:</p>
        /// <ul>
        /// <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination domain owner.</li>
        /// <li>APPROVED: Inbound connection is pending acceptance by destination domain owner.</li>
        /// <li>REJECTING: Inbound connection rejection is in process.</li>
        /// <li>REJECTED: Inbound connection is rejected.</li>
        /// <li>DELETING: Inbound connection deletion is in progress.</li>
        /// <li>DELETED: Inbound connection is deleted and cannot be used further.</li>
        /// </ul>
        pub fn status_code(
            mut self,
            input: crate::model::InboundCrossClusterSearchConnectionStatusCode,
        ) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The state code for inbound connection. This can be one of the following:</p>
        /// <ul>
        /// <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination domain owner.</li>
        /// <li>APPROVED: Inbound connection is pending acceptance by destination domain owner.</li>
        /// <li>REJECTING: Inbound connection rejection is in process.</li>
        /// <li>REJECTED: Inbound connection is rejected.</li>
        /// <li>DELETING: Inbound connection deletion is in progress.</li>
        /// <li>DELETED: Inbound connection is deleted and cannot be used further.</li>
        /// </ul>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::InboundCrossClusterSearchConnectionStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>Specifies verbose information for the inbound connection status.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Specifies verbose information for the inbound connection status.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InboundCrossClusterSearchConnectionStatus`](crate::model::InboundCrossClusterSearchConnectionStatus)
        pub fn build(self) -> crate::model::InboundCrossClusterSearchConnectionStatus {
            crate::model::InboundCrossClusterSearchConnectionStatus {
                status_code: self.status_code,
                message: self.message,
            }
        }
    }
}
impl InboundCrossClusterSearchConnectionStatus {
    /// Creates a new builder-style object to manufacture [`InboundCrossClusterSearchConnectionStatus`](crate::model::InboundCrossClusterSearchConnectionStatus)
    pub fn builder() -> crate::model::inbound_cross_cluster_search_connection_status::Builder {
        crate::model::inbound_cross_cluster_search_connection_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InboundCrossClusterSearchConnectionStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Approved,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    PendingAcceptance,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    Rejecting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InboundCrossClusterSearchConnectionStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "APPROVED" => InboundCrossClusterSearchConnectionStatusCode::Approved,
            "DELETED" => InboundCrossClusterSearchConnectionStatusCode::Deleted,
            "DELETING" => InboundCrossClusterSearchConnectionStatusCode::Deleting,
            "PENDING_ACCEPTANCE" => {
                InboundCrossClusterSearchConnectionStatusCode::PendingAcceptance
            }
            "REJECTED" => InboundCrossClusterSearchConnectionStatusCode::Rejected,
            "REJECTING" => InboundCrossClusterSearchConnectionStatusCode::Rejecting,
            other => InboundCrossClusterSearchConnectionStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InboundCrossClusterSearchConnectionStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InboundCrossClusterSearchConnectionStatusCode::from(s))
    }
}
impl InboundCrossClusterSearchConnectionStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InboundCrossClusterSearchConnectionStatusCode::Approved => "APPROVED",
            InboundCrossClusterSearchConnectionStatusCode::Deleted => "DELETED",
            InboundCrossClusterSearchConnectionStatusCode::Deleting => "DELETING",
            InboundCrossClusterSearchConnectionStatusCode::PendingAcceptance => {
                "PENDING_ACCEPTANCE"
            }
            InboundCrossClusterSearchConnectionStatusCode::Rejected => "REJECTED",
            InboundCrossClusterSearchConnectionStatusCode::Rejecting => "REJECTING",
            InboundCrossClusterSearchConnectionStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "APPROVED",
            "DELETED",
            "DELETING",
            "PENDING_ACCEPTANCE",
            "REJECTED",
            "REJECTING",
        ]
    }
}
impl AsRef<str> for InboundCrossClusterSearchConnectionStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainInformation {
    #[allow(missing_docs)] // documentation missing in model
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub domain_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub region: std::option::Option<std::string::String>,
}
impl DomainInformation {
    #[allow(missing_docs)] // documentation missing in model
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
    /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
}
impl std::fmt::Debug for DomainInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainInformation");
        formatter.field("owner_id", &self.owner_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`DomainInformation`](crate::model::DomainInformation)
pub mod domain_information {
    /// A builder for [`DomainInformation`](crate::model::DomainInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainInformation`](crate::model::DomainInformation)
        pub fn build(self) -> crate::model::DomainInformation {
            crate::model::DomainInformation {
                owner_id: self.owner_id,
                domain_name: self.domain_name,
                region: self.region,
            }
        }
    }
}
impl DomainInformation {
    /// Creates a new builder-style object to manufacture [`DomainInformation`](crate::model::DomainInformation)
    pub fn builder() -> crate::model::domain_information::Builder {
        crate::model::domain_information::Builder::default()
    }
}

/// <p>Specifies a key value pair for a resource tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>Specifies the <code>TagKey</code>, the name of the tag. Tag keys must be unique for the Elasticsearch domain to which they are attached.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Specifies the <code>TagValue</code>, the value assigned to the corresponding tag key. Tag values can be null and do not have to be unique in a tag set. For example, you can have a key value pair in a tag set of <code>project : Trinity</code> and <code>cost-center : Trinity</code></p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>Specifies the <code>TagKey</code>, the name of the tag. Tag keys must be unique for the Elasticsearch domain to which they are attached.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Specifies the <code>TagValue</code>, the value assigned to the corresponding tag key. Tag values can be null and do not have to be unique in a tag set. For example, you can have a key value pair in a tag set of <code>project : Trinity</code> and <code>cost-center : Trinity</code></p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the <code>TagKey</code>, the name of the tag. Tag keys must be unique for the Elasticsearch domain to which they are attached.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Specifies the <code>TagKey</code>, the name of the tag. Tag keys must be unique for the Elasticsearch domain to which they are attached.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Specifies the <code>TagValue</code>, the value assigned to the corresponding tag key. Tag values can be null and do not have to be unique in a tag set. For example, you can have a key value pair in a tag set of <code>project : Trinity</code> and <code>cost-center : Trinity</code></p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Specifies the <code>TagValue</code>, the value assigned to the corresponding tag key. Tag values can be null and do not have to be unique in a tag set. For example, you can have a key value pair in a tag set of <code>project : Trinity</code> and <code>cost-center : Trinity</code></p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Information on a package that is associated with a domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainPackageDetails {
    /// <p>Internal ID of the package.</p>
    pub package_id: std::option::Option<std::string::String>,
    /// <p>User specified name of the package.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>Currently supports only TXT-DICTIONARY.</p>
    pub package_type: std::option::Option<crate::model::PackageType>,
    /// <p>Timestamp of the most-recent update to the association status.</p>
    pub last_updated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Name of the domain you've associated a package with.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>State of the association. Values are ASSOCIATING/ASSOCIATION_FAILED/ACTIVE/DISSOCIATING/DISSOCIATION_FAILED.</p>
    pub domain_package_status: std::option::Option<crate::model::DomainPackageStatus>,
    #[allow(missing_docs)] // documentation missing in model
    pub package_version: std::option::Option<std::string::String>,
    /// <p>The relative path on Amazon ES nodes, which can be used as synonym_path when the package is synonym file.</p>
    pub reference_path: std::option::Option<std::string::String>,
    /// <p>Additional information if the package is in an error state. Null otherwise.</p>
    pub error_details: std::option::Option<crate::model::ErrorDetails>,
}
impl DomainPackageDetails {
    /// <p>Internal ID of the package.</p>
    pub fn package_id(&self) -> std::option::Option<&str> {
        self.package_id.as_deref()
    }
    /// <p>User specified name of the package.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>Currently supports only TXT-DICTIONARY.</p>
    pub fn package_type(&self) -> std::option::Option<&crate::model::PackageType> {
        self.package_type.as_ref()
    }
    /// <p>Timestamp of the most-recent update to the association status.</p>
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated.as_ref()
    }
    /// <p>Name of the domain you've associated a package with.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>State of the association. Values are ASSOCIATING/ASSOCIATION_FAILED/ACTIVE/DISSOCIATING/DISSOCIATION_FAILED.</p>
    pub fn domain_package_status(&self) -> std::option::Option<&crate::model::DomainPackageStatus> {
        self.domain_package_status.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>The relative path on Amazon ES nodes, which can be used as synonym_path when the package is synonym file.</p>
    pub fn reference_path(&self) -> std::option::Option<&str> {
        self.reference_path.as_deref()
    }
    /// <p>Additional information if the package is in an error state. Null otherwise.</p>
    pub fn error_details(&self) -> std::option::Option<&crate::model::ErrorDetails> {
        self.error_details.as_ref()
    }
}
impl std::fmt::Debug for DomainPackageDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainPackageDetails");
        formatter.field("package_id", &self.package_id);
        formatter.field("package_name", &self.package_name);
        formatter.field("package_type", &self.package_type);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("domain_package_status", &self.domain_package_status);
        formatter.field("package_version", &self.package_version);
        formatter.field("reference_path", &self.reference_path);
        formatter.field("error_details", &self.error_details);
        formatter.finish()
    }
}
/// See [`DomainPackageDetails`](crate::model::DomainPackageDetails)
pub mod domain_package_details {
    /// A builder for [`DomainPackageDetails`](crate::model::DomainPackageDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) package_type: std::option::Option<crate::model::PackageType>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) domain_package_status: std::option::Option<crate::model::DomainPackageStatus>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) reference_path: std::option::Option<std::string::String>,
        pub(crate) error_details: std::option::Option<crate::model::ErrorDetails>,
    }
    impl Builder {
        /// <p>Internal ID of the package.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        /// <p>Internal ID of the package.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// <p>User specified name of the package.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>User specified name of the package.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>Currently supports only TXT-DICTIONARY.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.package_type = Some(input);
            self
        }
        /// <p>Currently supports only TXT-DICTIONARY.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.package_type = input;
            self
        }
        /// <p>Timestamp of the most-recent update to the association status.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>Timestamp of the most-recent update to the association status.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p>Name of the domain you've associated a package with.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>Name of the domain you've associated a package with.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>State of the association. Values are ASSOCIATING/ASSOCIATION_FAILED/ACTIVE/DISSOCIATING/DISSOCIATION_FAILED.</p>
        pub fn domain_package_status(mut self, input: crate::model::DomainPackageStatus) -> Self {
            self.domain_package_status = Some(input);
            self
        }
        /// <p>State of the association. Values are ASSOCIATING/ASSOCIATION_FAILED/ACTIVE/DISSOCIATING/DISSOCIATION_FAILED.</p>
        pub fn set_domain_package_status(
            mut self,
            input: std::option::Option<crate::model::DomainPackageStatus>,
        ) -> Self {
            self.domain_package_status = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>The relative path on Amazon ES nodes, which can be used as synonym_path when the package is synonym file.</p>
        pub fn reference_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_path = Some(input.into());
            self
        }
        /// <p>The relative path on Amazon ES nodes, which can be used as synonym_path when the package is synonym file.</p>
        pub fn set_reference_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reference_path = input;
            self
        }
        /// <p>Additional information if the package is in an error state. Null otherwise.</p>
        pub fn error_details(mut self, input: crate::model::ErrorDetails) -> Self {
            self.error_details = Some(input);
            self
        }
        /// <p>Additional information if the package is in an error state. Null otherwise.</p>
        pub fn set_error_details(
            mut self,
            input: std::option::Option<crate::model::ErrorDetails>,
        ) -> Self {
            self.error_details = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainPackageDetails`](crate::model::DomainPackageDetails)
        pub fn build(self) -> crate::model::DomainPackageDetails {
            crate::model::DomainPackageDetails {
                package_id: self.package_id,
                package_name: self.package_name,
                package_type: self.package_type,
                last_updated: self.last_updated,
                domain_name: self.domain_name,
                domain_package_status: self.domain_package_status,
                package_version: self.package_version,
                reference_path: self.reference_path,
                error_details: self.error_details,
            }
        }
    }
}
impl DomainPackageDetails {
    /// Creates a new builder-style object to manufacture [`DomainPackageDetails`](crate::model::DomainPackageDetails)
    pub fn builder() -> crate::model::domain_package_details::Builder {
        crate::model::domain_package_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DomainPackageStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Associating,
    #[allow(missing_docs)] // documentation missing in model
    AssociationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Dissociating,
    #[allow(missing_docs)] // documentation missing in model
    DissociationFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DomainPackageStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DomainPackageStatus::Active,
            "ASSOCIATING" => DomainPackageStatus::Associating,
            "ASSOCIATION_FAILED" => DomainPackageStatus::AssociationFailed,
            "DISSOCIATING" => DomainPackageStatus::Dissociating,
            "DISSOCIATION_FAILED" => DomainPackageStatus::DissociationFailed,
            other => DomainPackageStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DomainPackageStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DomainPackageStatus::from(s))
    }
}
impl DomainPackageStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DomainPackageStatus::Active => "ACTIVE",
            DomainPackageStatus::Associating => "ASSOCIATING",
            DomainPackageStatus::AssociationFailed => "ASSOCIATION_FAILED",
            DomainPackageStatus::Dissociating => "DISSOCIATING",
            DomainPackageStatus::DissociationFailed => "DISSOCIATION_FAILED",
            DomainPackageStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "ASSOCIATING",
            "ASSOCIATION_FAILED",
            "DISSOCIATING",
            "DISSOCIATION_FAILED",
        ]
    }
}
impl AsRef<str> for DomainPackageStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainInfo {
    /// <p> Specifies the <code>DomainName</code>.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p> Specifies the <code>EngineType</code> of the domain.</p>
    pub engine_type: std::option::Option<crate::model::EngineType>,
}
impl DomainInfo {
    /// <p> Specifies the <code>DomainName</code>.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p> Specifies the <code>EngineType</code> of the domain.</p>
    pub fn engine_type(&self) -> std::option::Option<&crate::model::EngineType> {
        self.engine_type.as_ref()
    }
}
impl std::fmt::Debug for DomainInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainInfo");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("engine_type", &self.engine_type);
        formatter.finish()
    }
}
/// See [`DomainInfo`](crate::model::DomainInfo)
pub mod domain_info {
    /// A builder for [`DomainInfo`](crate::model::DomainInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) engine_type: std::option::Option<crate::model::EngineType>,
    }
    impl Builder {
        /// <p> Specifies the <code>DomainName</code>.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p> Specifies the <code>DomainName</code>.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p> Specifies the <code>EngineType</code> of the domain.</p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.engine_type = Some(input);
            self
        }
        /// <p> Specifies the <code>EngineType</code> of the domain.</p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.engine_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainInfo`](crate::model::DomainInfo)
        pub fn build(self) -> crate::model::DomainInfo {
            crate::model::DomainInfo {
                domain_name: self.domain_name,
                engine_type: self.engine_type,
            }
        }
    }
}
impl DomainInfo {
    /// Creates a new builder-style object to manufacture [`DomainInfo`](crate::model::DomainInfo)
    pub fn builder() -> crate::model::domain_info::Builder {
        crate::model::domain_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EngineType {
    #[allow(missing_docs)] // documentation missing in model
    Elasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    OpenSearch,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EngineType {
    fn from(s: &str) -> Self {
        match s {
            "Elasticsearch" => EngineType::Elasticsearch,
            "OpenSearch" => EngineType::OpenSearch,
            other => EngineType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EngineType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EngineType::from(s))
    }
}
impl EngineType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EngineType::Elasticsearch => "Elasticsearch",
            EngineType::OpenSearch => "OpenSearch",
            EngineType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Elasticsearch", "OpenSearch"]
    }
}
impl AsRef<str> for EngineType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpgradeStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    #[allow(missing_docs)] // documentation missing in model
    SucceededWithIssues,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpgradeStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => UpgradeStatus::Failed,
            "IN_PROGRESS" => UpgradeStatus::InProgress,
            "SUCCEEDED" => UpgradeStatus::Succeeded,
            "SUCCEEDED_WITH_ISSUES" => UpgradeStatus::SucceededWithIssues,
            other => UpgradeStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpgradeStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpgradeStatus::from(s))
    }
}
impl UpgradeStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpgradeStatus::Failed => "FAILED",
            UpgradeStatus::InProgress => "IN_PROGRESS",
            UpgradeStatus::Succeeded => "SUCCEEDED",
            UpgradeStatus::SucceededWithIssues => "SUCCEEDED_WITH_ISSUES",
            UpgradeStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "IN_PROGRESS",
            "SUCCEEDED",
            "SUCCEEDED_WITH_ISSUES",
        ]
    }
}
impl AsRef<str> for UpgradeStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpgradeStep {
    #[allow(missing_docs)] // documentation missing in model
    PreUpgradeCheck,
    #[allow(missing_docs)] // documentation missing in model
    Snapshot,
    #[allow(missing_docs)] // documentation missing in model
    Upgrade,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpgradeStep {
    fn from(s: &str) -> Self {
        match s {
            "PRE_UPGRADE_CHECK" => UpgradeStep::PreUpgradeCheck,
            "SNAPSHOT" => UpgradeStep::Snapshot,
            "UPGRADE" => UpgradeStep::Upgrade,
            other => UpgradeStep::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpgradeStep {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpgradeStep::from(s))
    }
}
impl UpgradeStep {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpgradeStep::PreUpgradeCheck => "PRE_UPGRADE_CHECK",
            UpgradeStep::Snapshot => "SNAPSHOT",
            UpgradeStep::Upgrade => "UPGRADE",
            UpgradeStep::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRE_UPGRADE_CHECK", "SNAPSHOT", "UPGRADE"]
    }
}
impl AsRef<str> for UpgradeStep {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>History of the last 10 Upgrades and Upgrade Eligibility Checks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeHistory {
    /// <p>A string that describes the update briefly</p>
    pub upgrade_name: std::option::Option<std::string::String>,
    /// <p>UTC Timestamp at which the Upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ" format.</p>
    pub start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The overall status of the update. The status can take one of the following values: </p>
    /// <ul>
    /// <li>In Progress</li>
    /// <li>Succeeded</li>
    /// <li>Succeeded with Issues</li>
    /// <li>Failed</li>
    /// </ul>
    /// <p></p>
    pub upgrade_status: std::option::Option<crate::model::UpgradeStatus>,
    /// <p> A list of <code> <code>UpgradeStepItem</code> </code> s representing information about each step performed as pard of a specific Upgrade or Upgrade Eligibility Check. </p>
    pub steps_list: std::option::Option<std::vec::Vec<crate::model::UpgradeStepItem>>,
}
impl UpgradeHistory {
    /// <p>A string that describes the update briefly</p>
    pub fn upgrade_name(&self) -> std::option::Option<&str> {
        self.upgrade_name.as_deref()
    }
    /// <p>UTC Timestamp at which the Upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ" format.</p>
    pub fn start_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_timestamp.as_ref()
    }
    /// <p> The overall status of the update. The status can take one of the following values: </p>
    /// <ul>
    /// <li>In Progress</li>
    /// <li>Succeeded</li>
    /// <li>Succeeded with Issues</li>
    /// <li>Failed</li>
    /// </ul>
    /// <p></p>
    pub fn upgrade_status(&self) -> std::option::Option<&crate::model::UpgradeStatus> {
        self.upgrade_status.as_ref()
    }
    /// <p> A list of <code> <code>UpgradeStepItem</code> </code> s representing information about each step performed as pard of a specific Upgrade or Upgrade Eligibility Check. </p>
    pub fn steps_list(&self) -> std::option::Option<&[crate::model::UpgradeStepItem]> {
        self.steps_list.as_deref()
    }
}
impl std::fmt::Debug for UpgradeHistory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeHistory");
        formatter.field("upgrade_name", &self.upgrade_name);
        formatter.field("start_timestamp", &self.start_timestamp);
        formatter.field("upgrade_status", &self.upgrade_status);
        formatter.field("steps_list", &self.steps_list);
        formatter.finish()
    }
}
/// See [`UpgradeHistory`](crate::model::UpgradeHistory)
pub mod upgrade_history {
    /// A builder for [`UpgradeHistory`](crate::model::UpgradeHistory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upgrade_name: std::option::Option<std::string::String>,
        pub(crate) start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) upgrade_status: std::option::Option<crate::model::UpgradeStatus>,
        pub(crate) steps_list: std::option::Option<std::vec::Vec<crate::model::UpgradeStepItem>>,
    }
    impl Builder {
        /// <p>A string that describes the update briefly</p>
        pub fn upgrade_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.upgrade_name = Some(input.into());
            self
        }
        /// <p>A string that describes the update briefly</p>
        pub fn set_upgrade_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upgrade_name = input;
            self
        }
        /// <p>UTC Timestamp at which the Upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ" format.</p>
        pub fn start_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_timestamp = Some(input);
            self
        }
        /// <p>UTC Timestamp at which the Upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ" format.</p>
        pub fn set_start_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_timestamp = input;
            self
        }
        /// <p> The overall status of the update. The status can take one of the following values: </p>
        /// <ul>
        /// <li>In Progress</li>
        /// <li>Succeeded</li>
        /// <li>Succeeded with Issues</li>
        /// <li>Failed</li>
        /// </ul>
        /// <p></p>
        pub fn upgrade_status(mut self, input: crate::model::UpgradeStatus) -> Self {
            self.upgrade_status = Some(input);
            self
        }
        /// <p> The overall status of the update. The status can take one of the following values: </p>
        /// <ul>
        /// <li>In Progress</li>
        /// <li>Succeeded</li>
        /// <li>Succeeded with Issues</li>
        /// <li>Failed</li>
        /// </ul>
        /// <p></p>
        pub fn set_upgrade_status(
            mut self,
            input: std::option::Option<crate::model::UpgradeStatus>,
        ) -> Self {
            self.upgrade_status = input;
            self
        }
        /// Appends an item to `steps_list`.
        ///
        /// To override the contents of this collection use [`set_steps_list`](Self::set_steps_list).
        ///
        /// <p> A list of <code> <code>UpgradeStepItem</code> </code> s representing information about each step performed as pard of a specific Upgrade or Upgrade Eligibility Check. </p>
        pub fn steps_list(mut self, input: crate::model::UpgradeStepItem) -> Self {
            let mut v = self.steps_list.unwrap_or_default();
            v.push(input);
            self.steps_list = Some(v);
            self
        }
        /// <p> A list of <code> <code>UpgradeStepItem</code> </code> s representing information about each step performed as pard of a specific Upgrade or Upgrade Eligibility Check. </p>
        pub fn set_steps_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpgradeStepItem>>,
        ) -> Self {
            self.steps_list = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradeHistory`](crate::model::UpgradeHistory)
        pub fn build(self) -> crate::model::UpgradeHistory {
            crate::model::UpgradeHistory {
                upgrade_name: self.upgrade_name,
                start_timestamp: self.start_timestamp,
                upgrade_status: self.upgrade_status,
                steps_list: self.steps_list,
            }
        }
    }
}
impl UpgradeHistory {
    /// Creates a new builder-style object to manufacture [`UpgradeHistory`](crate::model::UpgradeHistory)
    pub fn builder() -> crate::model::upgrade_history::Builder {
        crate::model::upgrade_history::Builder::default()
    }
}

/// <p>Represents a single step of the Upgrade or Upgrade Eligibility Check workflow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeStepItem {
    /// <p> Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does through: </p>
    /// <ul>
    /// <li>PreUpgradeCheck</li>
    /// <li>Snapshot</li>
    /// <li>Upgrade</li>
    /// </ul>
    /// <p></p>
    pub upgrade_step: std::option::Option<crate::model::UpgradeStep>,
    /// <p> The status of a particular step during an upgrade. The status can take one of the following values: </p>
    /// <ul>
    /// <li>In Progress</li>
    /// <li>Succeeded</li>
    /// <li>Succeeded with Issues</li>
    /// <li>Failed</li>
    /// </ul>
    /// <p></p>
    pub upgrade_step_status: std::option::Option<crate::model::UpgradeStatus>,
    /// <p>A list of strings containing detailed information about the errors encountered in a particular step.</p>
    pub issues: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Floating point value representing progress percentage of a particular step.</p>
    pub progress_percent: std::option::Option<f64>,
}
impl UpgradeStepItem {
    /// <p> Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does through: </p>
    /// <ul>
    /// <li>PreUpgradeCheck</li>
    /// <li>Snapshot</li>
    /// <li>Upgrade</li>
    /// </ul>
    /// <p></p>
    pub fn upgrade_step(&self) -> std::option::Option<&crate::model::UpgradeStep> {
        self.upgrade_step.as_ref()
    }
    /// <p> The status of a particular step during an upgrade. The status can take one of the following values: </p>
    /// <ul>
    /// <li>In Progress</li>
    /// <li>Succeeded</li>
    /// <li>Succeeded with Issues</li>
    /// <li>Failed</li>
    /// </ul>
    /// <p></p>
    pub fn upgrade_step_status(&self) -> std::option::Option<&crate::model::UpgradeStatus> {
        self.upgrade_step_status.as_ref()
    }
    /// <p>A list of strings containing detailed information about the errors encountered in a particular step.</p>
    pub fn issues(&self) -> std::option::Option<&[std::string::String]> {
        self.issues.as_deref()
    }
    /// <p>The Floating point value representing progress percentage of a particular step.</p>
    pub fn progress_percent(&self) -> std::option::Option<f64> {
        self.progress_percent
    }
}
impl std::fmt::Debug for UpgradeStepItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeStepItem");
        formatter.field("upgrade_step", &self.upgrade_step);
        formatter.field("upgrade_step_status", &self.upgrade_step_status);
        formatter.field("issues", &self.issues);
        formatter.field("progress_percent", &self.progress_percent);
        formatter.finish()
    }
}
/// See [`UpgradeStepItem`](crate::model::UpgradeStepItem)
pub mod upgrade_step_item {
    /// A builder for [`UpgradeStepItem`](crate::model::UpgradeStepItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upgrade_step: std::option::Option<crate::model::UpgradeStep>,
        pub(crate) upgrade_step_status: std::option::Option<crate::model::UpgradeStatus>,
        pub(crate) issues: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) progress_percent: std::option::Option<f64>,
    }
    impl Builder {
        /// <p> Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does through: </p>
        /// <ul>
        /// <li>PreUpgradeCheck</li>
        /// <li>Snapshot</li>
        /// <li>Upgrade</li>
        /// </ul>
        /// <p></p>
        pub fn upgrade_step(mut self, input: crate::model::UpgradeStep) -> Self {
            self.upgrade_step = Some(input);
            self
        }
        /// <p> Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does through: </p>
        /// <ul>
        /// <li>PreUpgradeCheck</li>
        /// <li>Snapshot</li>
        /// <li>Upgrade</li>
        /// </ul>
        /// <p></p>
        pub fn set_upgrade_step(
            mut self,
            input: std::option::Option<crate::model::UpgradeStep>,
        ) -> Self {
            self.upgrade_step = input;
            self
        }
        /// <p> The status of a particular step during an upgrade. The status can take one of the following values: </p>
        /// <ul>
        /// <li>In Progress</li>
        /// <li>Succeeded</li>
        /// <li>Succeeded with Issues</li>
        /// <li>Failed</li>
        /// </ul>
        /// <p></p>
        pub fn upgrade_step_status(mut self, input: crate::model::UpgradeStatus) -> Self {
            self.upgrade_step_status = Some(input);
            self
        }
        /// <p> The status of a particular step during an upgrade. The status can take one of the following values: </p>
        /// <ul>
        /// <li>In Progress</li>
        /// <li>Succeeded</li>
        /// <li>Succeeded with Issues</li>
        /// <li>Failed</li>
        /// </ul>
        /// <p></p>
        pub fn set_upgrade_step_status(
            mut self,
            input: std::option::Option<crate::model::UpgradeStatus>,
        ) -> Self {
            self.upgrade_step_status = input;
            self
        }
        /// Appends an item to `issues`.
        ///
        /// To override the contents of this collection use [`set_issues`](Self::set_issues).
        ///
        /// <p>A list of strings containing detailed information about the errors encountered in a particular step.</p>
        pub fn issues(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.issues.unwrap_or_default();
            v.push(input.into());
            self.issues = Some(v);
            self
        }
        /// <p>A list of strings containing detailed information about the errors encountered in a particular step.</p>
        pub fn set_issues(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.issues = input;
            self
        }
        /// <p>The Floating point value representing progress percentage of a particular step.</p>
        pub fn progress_percent(mut self, input: f64) -> Self {
            self.progress_percent = Some(input);
            self
        }
        /// <p>The Floating point value representing progress percentage of a particular step.</p>
        pub fn set_progress_percent(mut self, input: std::option::Option<f64>) -> Self {
            self.progress_percent = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradeStepItem`](crate::model::UpgradeStepItem)
        pub fn build(self) -> crate::model::UpgradeStepItem {
            crate::model::UpgradeStepItem {
                upgrade_step: self.upgrade_step,
                upgrade_step_status: self.upgrade_step_status,
                issues: self.issues,
                progress_percent: self.progress_percent,
            }
        }
    }
}
impl UpgradeStepItem {
    /// Creates a new builder-style object to manufacture [`UpgradeStepItem`](crate::model::UpgradeStepItem)
    pub fn builder() -> crate::model::upgrade_step_item::Builder {
        crate::model::upgrade_step_item::Builder::default()
    }
}

/// <p>Details of a package version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageVersionHistory {
    /// <p>Version of the package.</p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>A message associated with the version.</p>
    pub commit_message: std::option::Option<std::string::String>,
    /// <p>Timestamp which tells creation time of the package version.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl PackageVersionHistory {
    /// <p>Version of the package.</p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>A message associated with the version.</p>
    pub fn commit_message(&self) -> std::option::Option<&str> {
        self.commit_message.as_deref()
    }
    /// <p>Timestamp which tells creation time of the package version.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for PackageVersionHistory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageVersionHistory");
        formatter.field("package_version", &self.package_version);
        formatter.field("commit_message", &self.commit_message);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`PackageVersionHistory`](crate::model::PackageVersionHistory)
pub mod package_version_history {
    /// A builder for [`PackageVersionHistory`](crate::model::PackageVersionHistory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) commit_message: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Version of the package.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>Version of the package.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>A message associated with the version.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_message = Some(input.into());
            self
        }
        /// <p>A message associated with the version.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_message = input;
            self
        }
        /// <p>Timestamp which tells creation time of the package version.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>Timestamp which tells creation time of the package version.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageVersionHistory`](crate::model::PackageVersionHistory)
        pub fn build(self) -> crate::model::PackageVersionHistory {
            crate::model::PackageVersionHistory {
                package_version: self.package_version,
                commit_message: self.commit_message,
                created_at: self.created_at,
            }
        }
    }
}
impl PackageVersionHistory {
    /// Creates a new builder-style object to manufacture [`PackageVersionHistory`](crate::model::PackageVersionHistory)
    pub fn builder() -> crate::model::package_version_history::Builder {
        crate::model::package_version_history::Builder::default()
    }
}

/// <p> A map from an <code> <code>ElasticsearchVersion</code> </code> to a list of compatible <code> <code>ElasticsearchVersion</code> </code> s to which the domain can be upgraded. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompatibleVersionsMap {
    /// <p>The current version of Elasticsearch on which a domain is.</p>
    pub source_version: std::option::Option<std::string::String>,
    /// <p>List of supported elastic search versions. </p>
    pub target_versions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CompatibleVersionsMap {
    /// <p>The current version of Elasticsearch on which a domain is.</p>
    pub fn source_version(&self) -> std::option::Option<&str> {
        self.source_version.as_deref()
    }
    /// <p>List of supported elastic search versions. </p>
    pub fn target_versions(&self) -> std::option::Option<&[std::string::String]> {
        self.target_versions.as_deref()
    }
}
impl std::fmt::Debug for CompatibleVersionsMap {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompatibleVersionsMap");
        formatter.field("source_version", &self.source_version);
        formatter.field("target_versions", &self.target_versions);
        formatter.finish()
    }
}
/// See [`CompatibleVersionsMap`](crate::model::CompatibleVersionsMap)
pub mod compatible_versions_map {
    /// A builder for [`CompatibleVersionsMap`](crate::model::CompatibleVersionsMap)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_version: std::option::Option<std::string::String>,
        pub(crate) target_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The current version of Elasticsearch on which a domain is.</p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_version = Some(input.into());
            self
        }
        /// <p>The current version of Elasticsearch on which a domain is.</p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_version = input;
            self
        }
        /// Appends an item to `target_versions`.
        ///
        /// To override the contents of this collection use [`set_target_versions`](Self::set_target_versions).
        ///
        /// <p>List of supported elastic search versions. </p>
        pub fn target_versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_versions.unwrap_or_default();
            v.push(input.into());
            self.target_versions = Some(v);
            self
        }
        /// <p>List of supported elastic search versions. </p>
        pub fn set_target_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`CompatibleVersionsMap`](crate::model::CompatibleVersionsMap)
        pub fn build(self) -> crate::model::CompatibleVersionsMap {
            crate::model::CompatibleVersionsMap {
                source_version: self.source_version,
                target_versions: self.target_versions,
            }
        }
    }
}
impl CompatibleVersionsMap {
    /// Creates a new builder-style object to manufacture [`CompatibleVersionsMap`](crate::model::CompatibleVersionsMap)
    pub fn builder() -> crate::model::compatible_versions_map::Builder {
        crate::model::compatible_versions_map::Builder::default()
    }
}

/// <p>Details of a reserved Elasticsearch instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedElasticsearchInstance {
    /// <p>The customer-specified identifier to track this reservation.</p>
    pub reservation_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the reservation.</p>
    pub reserved_elasticsearch_instance_id: std::option::Option<std::string::String>,
    /// <p>The offering identifier.</p>
    pub reserved_elasticsearch_instance_offering_id: std::option::Option<std::string::String>,
    /// <p>The Elasticsearch instance type offered by the reserved instance offering.</p>
    pub elasticsearch_instance_type: std::option::Option<crate::model::EsPartitionInstanceType>,
    /// <p>The time the reservation started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The duration, in seconds, for which the Elasticsearch instance is reserved.</p>
    pub duration: i32,
    /// <p>The upfront fixed charge you will paid to purchase the specific reserved Elasticsearch instance offering. </p>
    pub fixed_price: std::option::Option<f64>,
    /// <p>The rate you are charged for each hour for the domain that is using this reserved instance.</p>
    pub usage_price: std::option::Option<f64>,
    /// <p>The currency code for the reserved Elasticsearch instance offering.</p>
    pub currency_code: std::option::Option<std::string::String>,
    /// <p>The number of Elasticsearch instances that have been reserved.</p>
    pub elasticsearch_instance_count: i32,
    /// <p>The state of the reserved Elasticsearch instance.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>The payment option as defined in the reserved Elasticsearch instance offering.</p>
    pub payment_option:
        std::option::Option<crate::model::ReservedElasticsearchInstancePaymentOption>,
    /// <p>The charge to your account regardless of whether you are creating any domains using the instance offering.</p>
    pub recurring_charges: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
}
impl ReservedElasticsearchInstance {
    /// <p>The customer-specified identifier to track this reservation.</p>
    pub fn reservation_name(&self) -> std::option::Option<&str> {
        self.reservation_name.as_deref()
    }
    /// <p>The unique identifier for the reservation.</p>
    pub fn reserved_elasticsearch_instance_id(&self) -> std::option::Option<&str> {
        self.reserved_elasticsearch_instance_id.as_deref()
    }
    /// <p>The offering identifier.</p>
    pub fn reserved_elasticsearch_instance_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_elasticsearch_instance_offering_id.as_deref()
    }
    /// <p>The Elasticsearch instance type offered by the reserved instance offering.</p>
    pub fn elasticsearch_instance_type(
        &self,
    ) -> std::option::Option<&crate::model::EsPartitionInstanceType> {
        self.elasticsearch_instance_type.as_ref()
    }
    /// <p>The time the reservation started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The duration, in seconds, for which the Elasticsearch instance is reserved.</p>
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// <p>The upfront fixed charge you will paid to purchase the specific reserved Elasticsearch instance offering. </p>
    pub fn fixed_price(&self) -> std::option::Option<f64> {
        self.fixed_price
    }
    /// <p>The rate you are charged for each hour for the domain that is using this reserved instance.</p>
    pub fn usage_price(&self) -> std::option::Option<f64> {
        self.usage_price
    }
    /// <p>The currency code for the reserved Elasticsearch instance offering.</p>
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
    /// <p>The number of Elasticsearch instances that have been reserved.</p>
    pub fn elasticsearch_instance_count(&self) -> i32 {
        self.elasticsearch_instance_count
    }
    /// <p>The state of the reserved Elasticsearch instance.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>The payment option as defined in the reserved Elasticsearch instance offering.</p>
    pub fn payment_option(
        &self,
    ) -> std::option::Option<&crate::model::ReservedElasticsearchInstancePaymentOption> {
        self.payment_option.as_ref()
    }
    /// <p>The charge to your account regardless of whether you are creating any domains using the instance offering.</p>
    pub fn recurring_charges(&self) -> std::option::Option<&[crate::model::RecurringCharge]> {
        self.recurring_charges.as_deref()
    }
}
impl std::fmt::Debug for ReservedElasticsearchInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedElasticsearchInstance");
        formatter.field("reservation_name", &self.reservation_name);
        formatter.field(
            "reserved_elasticsearch_instance_id",
            &self.reserved_elasticsearch_instance_id,
        );
        formatter.field(
            "reserved_elasticsearch_instance_offering_id",
            &self.reserved_elasticsearch_instance_offering_id,
        );
        formatter.field(
            "elasticsearch_instance_type",
            &self.elasticsearch_instance_type,
        );
        formatter.field("start_time", &self.start_time);
        formatter.field("duration", &self.duration);
        formatter.field("fixed_price", &self.fixed_price);
        formatter.field("usage_price", &self.usage_price);
        formatter.field("currency_code", &self.currency_code);
        formatter.field(
            "elasticsearch_instance_count",
            &self.elasticsearch_instance_count,
        );
        formatter.field("state", &self.state);
        formatter.field("payment_option", &self.payment_option);
        formatter.field("recurring_charges", &self.recurring_charges);
        formatter.finish()
    }
}
/// See [`ReservedElasticsearchInstance`](crate::model::ReservedElasticsearchInstance)
pub mod reserved_elasticsearch_instance {
    /// A builder for [`ReservedElasticsearchInstance`](crate::model::ReservedElasticsearchInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reservation_name: std::option::Option<std::string::String>,
        pub(crate) reserved_elasticsearch_instance_id: std::option::Option<std::string::String>,
        pub(crate) reserved_elasticsearch_instance_offering_id:
            std::option::Option<std::string::String>,
        pub(crate) elasticsearch_instance_type:
            std::option::Option<crate::model::EsPartitionInstanceType>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) fixed_price: std::option::Option<f64>,
        pub(crate) usage_price: std::option::Option<f64>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) elasticsearch_instance_count: std::option::Option<i32>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) payment_option:
            std::option::Option<crate::model::ReservedElasticsearchInstancePaymentOption>,
        pub(crate) recurring_charges:
            std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
    }
    impl Builder {
        /// <p>The customer-specified identifier to track this reservation.</p>
        pub fn reservation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_name = Some(input.into());
            self
        }
        /// <p>The customer-specified identifier to track this reservation.</p>
        pub fn set_reservation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_name = input;
            self
        }
        /// <p>The unique identifier for the reservation.</p>
        pub fn reserved_elasticsearch_instance_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the reservation.</p>
        pub fn set_reserved_elasticsearch_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_id = input;
            self
        }
        /// <p>The offering identifier.</p>
        pub fn reserved_elasticsearch_instance_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_offering_id = Some(input.into());
            self
        }
        /// <p>The offering identifier.</p>
        pub fn set_reserved_elasticsearch_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_offering_id = input;
            self
        }
        /// <p>The Elasticsearch instance type offered by the reserved instance offering.</p>
        pub fn elasticsearch_instance_type(
            mut self,
            input: crate::model::EsPartitionInstanceType,
        ) -> Self {
            self.elasticsearch_instance_type = Some(input);
            self
        }
        /// <p>The Elasticsearch instance type offered by the reserved instance offering.</p>
        pub fn set_elasticsearch_instance_type(
            mut self,
            input: std::option::Option<crate::model::EsPartitionInstanceType>,
        ) -> Self {
            self.elasticsearch_instance_type = input;
            self
        }
        /// <p>The time the reservation started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time the reservation started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The duration, in seconds, for which the Elasticsearch instance is reserved.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The duration, in seconds, for which the Elasticsearch instance is reserved.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The upfront fixed charge you will paid to purchase the specific reserved Elasticsearch instance offering. </p>
        pub fn fixed_price(mut self, input: f64) -> Self {
            self.fixed_price = Some(input);
            self
        }
        /// <p>The upfront fixed charge you will paid to purchase the specific reserved Elasticsearch instance offering. </p>
        pub fn set_fixed_price(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_price = input;
            self
        }
        /// <p>The rate you are charged for each hour for the domain that is using this reserved instance.</p>
        pub fn usage_price(mut self, input: f64) -> Self {
            self.usage_price = Some(input);
            self
        }
        /// <p>The rate you are charged for each hour for the domain that is using this reserved instance.</p>
        pub fn set_usage_price(mut self, input: std::option::Option<f64>) -> Self {
            self.usage_price = input;
            self
        }
        /// <p>The currency code for the reserved Elasticsearch instance offering.</p>
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// <p>The currency code for the reserved Elasticsearch instance offering.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// <p>The number of Elasticsearch instances that have been reserved.</p>
        pub fn elasticsearch_instance_count(mut self, input: i32) -> Self {
            self.elasticsearch_instance_count = Some(input);
            self
        }
        /// <p>The number of Elasticsearch instances that have been reserved.</p>
        pub fn set_elasticsearch_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.elasticsearch_instance_count = input;
            self
        }
        /// <p>The state of the reserved Elasticsearch instance.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the reserved Elasticsearch instance.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>The payment option as defined in the reserved Elasticsearch instance offering.</p>
        pub fn payment_option(
            mut self,
            input: crate::model::ReservedElasticsearchInstancePaymentOption,
        ) -> Self {
            self.payment_option = Some(input);
            self
        }
        /// <p>The payment option as defined in the reserved Elasticsearch instance offering.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::ReservedElasticsearchInstancePaymentOption>,
        ) -> Self {
            self.payment_option = input;
            self
        }
        /// Appends an item to `recurring_charges`.
        ///
        /// To override the contents of this collection use [`set_recurring_charges`](Self::set_recurring_charges).
        ///
        /// <p>The charge to your account regardless of whether you are creating any domains using the instance offering.</p>
        pub fn recurring_charges(mut self, input: crate::model::RecurringCharge) -> Self {
            let mut v = self.recurring_charges.unwrap_or_default();
            v.push(input);
            self.recurring_charges = Some(v);
            self
        }
        /// <p>The charge to your account regardless of whether you are creating any domains using the instance offering.</p>
        pub fn set_recurring_charges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
        ) -> Self {
            self.recurring_charges = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedElasticsearchInstance`](crate::model::ReservedElasticsearchInstance)
        pub fn build(self) -> crate::model::ReservedElasticsearchInstance {
            crate::model::ReservedElasticsearchInstance {
                reservation_name: self.reservation_name,
                reserved_elasticsearch_instance_id: self.reserved_elasticsearch_instance_id,
                reserved_elasticsearch_instance_offering_id: self
                    .reserved_elasticsearch_instance_offering_id,
                elasticsearch_instance_type: self.elasticsearch_instance_type,
                start_time: self.start_time,
                duration: self.duration.unwrap_or_default(),
                fixed_price: self.fixed_price,
                usage_price: self.usage_price,
                currency_code: self.currency_code,
                elasticsearch_instance_count: self.elasticsearch_instance_count.unwrap_or_default(),
                state: self.state,
                payment_option: self.payment_option,
                recurring_charges: self.recurring_charges,
            }
        }
    }
}
impl ReservedElasticsearchInstance {
    /// Creates a new builder-style object to manufacture [`ReservedElasticsearchInstance`](crate::model::ReservedElasticsearchInstance)
    pub fn builder() -> crate::model::reserved_elasticsearch_instance::Builder {
        crate::model::reserved_elasticsearch_instance::Builder::default()
    }
}

/// <p>Contains the specific price and frequency of a recurring charges for a reserved Elasticsearch instance, or for a reserved Elasticsearch instance offering.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecurringCharge {
    /// <p>The monetary amount of the recurring charge.</p>
    pub recurring_charge_amount: std::option::Option<f64>,
    /// <p>The frequency of the recurring charge.</p>
    pub recurring_charge_frequency: std::option::Option<std::string::String>,
}
impl RecurringCharge {
    /// <p>The monetary amount of the recurring charge.</p>
    pub fn recurring_charge_amount(&self) -> std::option::Option<f64> {
        self.recurring_charge_amount
    }
    /// <p>The frequency of the recurring charge.</p>
    pub fn recurring_charge_frequency(&self) -> std::option::Option<&str> {
        self.recurring_charge_frequency.as_deref()
    }
}
impl std::fmt::Debug for RecurringCharge {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecurringCharge");
        formatter.field("recurring_charge_amount", &self.recurring_charge_amount);
        formatter.field(
            "recurring_charge_frequency",
            &self.recurring_charge_frequency,
        );
        formatter.finish()
    }
}
/// See [`RecurringCharge`](crate::model::RecurringCharge)
pub mod recurring_charge {
    /// A builder for [`RecurringCharge`](crate::model::RecurringCharge)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recurring_charge_amount: std::option::Option<f64>,
        pub(crate) recurring_charge_frequency: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The monetary amount of the recurring charge.</p>
        pub fn recurring_charge_amount(mut self, input: f64) -> Self {
            self.recurring_charge_amount = Some(input);
            self
        }
        /// <p>The monetary amount of the recurring charge.</p>
        pub fn set_recurring_charge_amount(mut self, input: std::option::Option<f64>) -> Self {
            self.recurring_charge_amount = input;
            self
        }
        /// <p>The frequency of the recurring charge.</p>
        pub fn recurring_charge_frequency(mut self, input: impl Into<std::string::String>) -> Self {
            self.recurring_charge_frequency = Some(input.into());
            self
        }
        /// <p>The frequency of the recurring charge.</p>
        pub fn set_recurring_charge_frequency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recurring_charge_frequency = input;
            self
        }
        /// Consumes the builder and constructs a [`RecurringCharge`](crate::model::RecurringCharge)
        pub fn build(self) -> crate::model::RecurringCharge {
            crate::model::RecurringCharge {
                recurring_charge_amount: self.recurring_charge_amount,
                recurring_charge_frequency: self.recurring_charge_frequency,
            }
        }
    }
}
impl RecurringCharge {
    /// Creates a new builder-style object to manufacture [`RecurringCharge`](crate::model::RecurringCharge)
    pub fn builder() -> crate::model::recurring_charge::Builder {
        crate::model::recurring_charge::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservedElasticsearchInstancePaymentOption {
    #[allow(missing_docs)] // documentation missing in model
    AllUpfront,
    #[allow(missing_docs)] // documentation missing in model
    NoUpfront,
    #[allow(missing_docs)] // documentation missing in model
    PartialUpfront,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservedElasticsearchInstancePaymentOption {
    fn from(s: &str) -> Self {
        match s {
            "ALL_UPFRONT" => ReservedElasticsearchInstancePaymentOption::AllUpfront,
            "NO_UPFRONT" => ReservedElasticsearchInstancePaymentOption::NoUpfront,
            "PARTIAL_UPFRONT" => ReservedElasticsearchInstancePaymentOption::PartialUpfront,
            other => ReservedElasticsearchInstancePaymentOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservedElasticsearchInstancePaymentOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservedElasticsearchInstancePaymentOption::from(s))
    }
}
impl ReservedElasticsearchInstancePaymentOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservedElasticsearchInstancePaymentOption::AllUpfront => "ALL_UPFRONT",
            ReservedElasticsearchInstancePaymentOption::NoUpfront => "NO_UPFRONT",
            ReservedElasticsearchInstancePaymentOption::PartialUpfront => "PARTIAL_UPFRONT",
            ReservedElasticsearchInstancePaymentOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL_UPFRONT", "NO_UPFRONT", "PARTIAL_UPFRONT"]
    }
}
impl AsRef<str> for ReservedElasticsearchInstancePaymentOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details of a reserved Elasticsearch instance offering.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedElasticsearchInstanceOffering {
    /// <p>The Elasticsearch reserved instance offering identifier.</p>
    pub reserved_elasticsearch_instance_offering_id: std::option::Option<std::string::String>,
    /// <p>The Elasticsearch instance type offered by the reserved instance offering.</p>
    pub elasticsearch_instance_type: std::option::Option<crate::model::EsPartitionInstanceType>,
    /// <p>The duration, in seconds, for which the offering will reserve the Elasticsearch instance.</p>
    pub duration: i32,
    /// <p>The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch instance offering. </p>
    pub fixed_price: std::option::Option<f64>,
    /// <p>The rate you are charged for each hour the domain that is using the offering is running.</p>
    pub usage_price: std::option::Option<f64>,
    /// <p>The currency code for the reserved Elasticsearch instance offering.</p>
    pub currency_code: std::option::Option<std::string::String>,
    /// <p>Payment option for the reserved Elasticsearch instance offering</p>
    pub payment_option:
        std::option::Option<crate::model::ReservedElasticsearchInstancePaymentOption>,
    /// <p>The charge to your account regardless of whether you are creating any domains using the instance offering.</p>
    pub recurring_charges: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
}
impl ReservedElasticsearchInstanceOffering {
    /// <p>The Elasticsearch reserved instance offering identifier.</p>
    pub fn reserved_elasticsearch_instance_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_elasticsearch_instance_offering_id.as_deref()
    }
    /// <p>The Elasticsearch instance type offered by the reserved instance offering.</p>
    pub fn elasticsearch_instance_type(
        &self,
    ) -> std::option::Option<&crate::model::EsPartitionInstanceType> {
        self.elasticsearch_instance_type.as_ref()
    }
    /// <p>The duration, in seconds, for which the offering will reserve the Elasticsearch instance.</p>
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// <p>The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch instance offering. </p>
    pub fn fixed_price(&self) -> std::option::Option<f64> {
        self.fixed_price
    }
    /// <p>The rate you are charged for each hour the domain that is using the offering is running.</p>
    pub fn usage_price(&self) -> std::option::Option<f64> {
        self.usage_price
    }
    /// <p>The currency code for the reserved Elasticsearch instance offering.</p>
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
    /// <p>Payment option for the reserved Elasticsearch instance offering</p>
    pub fn payment_option(
        &self,
    ) -> std::option::Option<&crate::model::ReservedElasticsearchInstancePaymentOption> {
        self.payment_option.as_ref()
    }
    /// <p>The charge to your account regardless of whether you are creating any domains using the instance offering.</p>
    pub fn recurring_charges(&self) -> std::option::Option<&[crate::model::RecurringCharge]> {
        self.recurring_charges.as_deref()
    }
}
impl std::fmt::Debug for ReservedElasticsearchInstanceOffering {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedElasticsearchInstanceOffering");
        formatter.field(
            "reserved_elasticsearch_instance_offering_id",
            &self.reserved_elasticsearch_instance_offering_id,
        );
        formatter.field(
            "elasticsearch_instance_type",
            &self.elasticsearch_instance_type,
        );
        formatter.field("duration", &self.duration);
        formatter.field("fixed_price", &self.fixed_price);
        formatter.field("usage_price", &self.usage_price);
        formatter.field("currency_code", &self.currency_code);
        formatter.field("payment_option", &self.payment_option);
        formatter.field("recurring_charges", &self.recurring_charges);
        formatter.finish()
    }
}
/// See [`ReservedElasticsearchInstanceOffering`](crate::model::ReservedElasticsearchInstanceOffering)
pub mod reserved_elasticsearch_instance_offering {
    /// A builder for [`ReservedElasticsearchInstanceOffering`](crate::model::ReservedElasticsearchInstanceOffering)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_elasticsearch_instance_offering_id:
            std::option::Option<std::string::String>,
        pub(crate) elasticsearch_instance_type:
            std::option::Option<crate::model::EsPartitionInstanceType>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) fixed_price: std::option::Option<f64>,
        pub(crate) usage_price: std::option::Option<f64>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) payment_option:
            std::option::Option<crate::model::ReservedElasticsearchInstancePaymentOption>,
        pub(crate) recurring_charges:
            std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
    }
    impl Builder {
        /// <p>The Elasticsearch reserved instance offering identifier.</p>
        pub fn reserved_elasticsearch_instance_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_offering_id = Some(input.into());
            self
        }
        /// <p>The Elasticsearch reserved instance offering identifier.</p>
        pub fn set_reserved_elasticsearch_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_offering_id = input;
            self
        }
        /// <p>The Elasticsearch instance type offered by the reserved instance offering.</p>
        pub fn elasticsearch_instance_type(
            mut self,
            input: crate::model::EsPartitionInstanceType,
        ) -> Self {
            self.elasticsearch_instance_type = Some(input);
            self
        }
        /// <p>The Elasticsearch instance type offered by the reserved instance offering.</p>
        pub fn set_elasticsearch_instance_type(
            mut self,
            input: std::option::Option<crate::model::EsPartitionInstanceType>,
        ) -> Self {
            self.elasticsearch_instance_type = input;
            self
        }
        /// <p>The duration, in seconds, for which the offering will reserve the Elasticsearch instance.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The duration, in seconds, for which the offering will reserve the Elasticsearch instance.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch instance offering. </p>
        pub fn fixed_price(mut self, input: f64) -> Self {
            self.fixed_price = Some(input);
            self
        }
        /// <p>The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch instance offering. </p>
        pub fn set_fixed_price(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_price = input;
            self
        }
        /// <p>The rate you are charged for each hour the domain that is using the offering is running.</p>
        pub fn usage_price(mut self, input: f64) -> Self {
            self.usage_price = Some(input);
            self
        }
        /// <p>The rate you are charged for each hour the domain that is using the offering is running.</p>
        pub fn set_usage_price(mut self, input: std::option::Option<f64>) -> Self {
            self.usage_price = input;
            self
        }
        /// <p>The currency code for the reserved Elasticsearch instance offering.</p>
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// <p>The currency code for the reserved Elasticsearch instance offering.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// <p>Payment option for the reserved Elasticsearch instance offering</p>
        pub fn payment_option(
            mut self,
            input: crate::model::ReservedElasticsearchInstancePaymentOption,
        ) -> Self {
            self.payment_option = Some(input);
            self
        }
        /// <p>Payment option for the reserved Elasticsearch instance offering</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::ReservedElasticsearchInstancePaymentOption>,
        ) -> Self {
            self.payment_option = input;
            self
        }
        /// Appends an item to `recurring_charges`.
        ///
        /// To override the contents of this collection use [`set_recurring_charges`](Self::set_recurring_charges).
        ///
        /// <p>The charge to your account regardless of whether you are creating any domains using the instance offering.</p>
        pub fn recurring_charges(mut self, input: crate::model::RecurringCharge) -> Self {
            let mut v = self.recurring_charges.unwrap_or_default();
            v.push(input);
            self.recurring_charges = Some(v);
            self
        }
        /// <p>The charge to your account regardless of whether you are creating any domains using the instance offering.</p>
        pub fn set_recurring_charges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
        ) -> Self {
            self.recurring_charges = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedElasticsearchInstanceOffering`](crate::model::ReservedElasticsearchInstanceOffering)
        pub fn build(self) -> crate::model::ReservedElasticsearchInstanceOffering {
            crate::model::ReservedElasticsearchInstanceOffering {
                reserved_elasticsearch_instance_offering_id: self
                    .reserved_elasticsearch_instance_offering_id,
                elasticsearch_instance_type: self.elasticsearch_instance_type,
                duration: self.duration.unwrap_or_default(),
                fixed_price: self.fixed_price,
                usage_price: self.usage_price,
                currency_code: self.currency_code,
                payment_option: self.payment_option,
                recurring_charges: self.recurring_charges,
            }
        }
    }
}
impl ReservedElasticsearchInstanceOffering {
    /// Creates a new builder-style object to manufacture [`ReservedElasticsearchInstanceOffering`](crate::model::ReservedElasticsearchInstanceOffering)
    pub fn builder() -> crate::model::reserved_elasticsearch_instance_offering::Builder {
        crate::model::reserved_elasticsearch_instance_offering::Builder::default()
    }
}

/// <p>Filter to apply in <code>DescribePackage</code> response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackagesFilter {
    /// <p>Any field from <code>PackageDetails</code>.</p>
    pub name: std::option::Option<crate::model::DescribePackagesFilterName>,
    /// <p>A list of values for the specified field.</p>
    pub value: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribePackagesFilter {
    /// <p>Any field from <code>PackageDetails</code>.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::DescribePackagesFilterName> {
        self.name.as_ref()
    }
    /// <p>A list of values for the specified field.</p>
    pub fn value(&self) -> std::option::Option<&[std::string::String]> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for DescribePackagesFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackagesFilter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`DescribePackagesFilter`](crate::model::DescribePackagesFilter)
pub mod describe_packages_filter {
    /// A builder for [`DescribePackagesFilter`](crate::model::DescribePackagesFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::DescribePackagesFilterName>,
        pub(crate) value: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Any field from <code>PackageDetails</code>.</p>
        pub fn name(mut self, input: crate::model::DescribePackagesFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>Any field from <code>PackageDetails</code>.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::DescribePackagesFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `value`.
        ///
        /// To override the contents of this collection use [`set_value`](Self::set_value).
        ///
        /// <p>A list of values for the specified field.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.value.unwrap_or_default();
            v.push(input.into());
            self.value = Some(v);
            self
        }
        /// <p>A list of values for the specified field.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackagesFilter`](crate::model::DescribePackagesFilter)
        pub fn build(self) -> crate::model::DescribePackagesFilter {
            crate::model::DescribePackagesFilter {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl DescribePackagesFilter {
    /// Creates a new builder-style object to manufacture [`DescribePackagesFilter`](crate::model::DescribePackagesFilter)
    pub fn builder() -> crate::model::describe_packages_filter::Builder {
        crate::model::describe_packages_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DescribePackagesFilterName {
    #[allow(missing_docs)] // documentation missing in model
    PackageId,
    #[allow(missing_docs)] // documentation missing in model
    PackageName,
    #[allow(missing_docs)] // documentation missing in model
    PackageStatus,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DescribePackagesFilterName {
    fn from(s: &str) -> Self {
        match s {
            "PackageID" => DescribePackagesFilterName::PackageId,
            "PackageName" => DescribePackagesFilterName::PackageName,
            "PackageStatus" => DescribePackagesFilterName::PackageStatus,
            other => DescribePackagesFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DescribePackagesFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DescribePackagesFilterName::from(s))
    }
}
impl DescribePackagesFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DescribePackagesFilterName::PackageId => "PackageID",
            DescribePackagesFilterName::PackageName => "PackageName",
            DescribePackagesFilterName::PackageStatus => "PackageStatus",
            DescribePackagesFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PackageID", "PackageName", "PackageStatus"]
    }
}
impl AsRef<str> for DescribePackagesFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies details of an outbound connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutboundCrossClusterSearchConnection {
    /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
    pub source_domain_info: std::option::Option<crate::model::DomainInformation>,
    /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
    pub destination_domain_info: std::option::Option<crate::model::DomainInformation>,
    /// <p>Specifies the connection id for the outbound cross-cluster search connection.</p>
    pub cross_cluster_search_connection_id: std::option::Option<std::string::String>,
    /// <p>Specifies the connection alias for the outbound cross-cluster search connection.</p>
    pub connection_alias: std::option::Option<std::string::String>,
    /// <p>Specifies the <code><code>OutboundCrossClusterSearchConnectionStatus</code></code> for the outbound connection.</p>
    pub connection_status:
        std::option::Option<crate::model::OutboundCrossClusterSearchConnectionStatus>,
}
impl OutboundCrossClusterSearchConnection {
    /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
    pub fn source_domain_info(&self) -> std::option::Option<&crate::model::DomainInformation> {
        self.source_domain_info.as_ref()
    }
    /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
    pub fn destination_domain_info(&self) -> std::option::Option<&crate::model::DomainInformation> {
        self.destination_domain_info.as_ref()
    }
    /// <p>Specifies the connection id for the outbound cross-cluster search connection.</p>
    pub fn cross_cluster_search_connection_id(&self) -> std::option::Option<&str> {
        self.cross_cluster_search_connection_id.as_deref()
    }
    /// <p>Specifies the connection alias for the outbound cross-cluster search connection.</p>
    pub fn connection_alias(&self) -> std::option::Option<&str> {
        self.connection_alias.as_deref()
    }
    /// <p>Specifies the <code><code>OutboundCrossClusterSearchConnectionStatus</code></code> for the outbound connection.</p>
    pub fn connection_status(
        &self,
    ) -> std::option::Option<&crate::model::OutboundCrossClusterSearchConnectionStatus> {
        self.connection_status.as_ref()
    }
}
impl std::fmt::Debug for OutboundCrossClusterSearchConnection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutboundCrossClusterSearchConnection");
        formatter.field("source_domain_info", &self.source_domain_info);
        formatter.field("destination_domain_info", &self.destination_domain_info);
        formatter.field(
            "cross_cluster_search_connection_id",
            &self.cross_cluster_search_connection_id,
        );
        formatter.field("connection_alias", &self.connection_alias);
        formatter.field("connection_status", &self.connection_status);
        formatter.finish()
    }
}
/// See [`OutboundCrossClusterSearchConnection`](crate::model::OutboundCrossClusterSearchConnection)
pub mod outbound_cross_cluster_search_connection {
    /// A builder for [`OutboundCrossClusterSearchConnection`](crate::model::OutboundCrossClusterSearchConnection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_domain_info: std::option::Option<crate::model::DomainInformation>,
        pub(crate) destination_domain_info: std::option::Option<crate::model::DomainInformation>,
        pub(crate) cross_cluster_search_connection_id: std::option::Option<std::string::String>,
        pub(crate) connection_alias: std::option::Option<std::string::String>,
        pub(crate) connection_status:
            std::option::Option<crate::model::OutboundCrossClusterSearchConnectionStatus>,
    }
    impl Builder {
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
        pub fn source_domain_info(mut self, input: crate::model::DomainInformation) -> Self {
            self.source_domain_info = Some(input);
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
        pub fn set_source_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformation>,
        ) -> Self {
            self.source_domain_info = input;
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
        pub fn destination_domain_info(mut self, input: crate::model::DomainInformation) -> Self {
            self.destination_domain_info = Some(input);
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
        pub fn set_destination_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformation>,
        ) -> Self {
            self.destination_domain_info = input;
            self
        }
        /// <p>Specifies the connection id for the outbound cross-cluster search connection.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = Some(input.into());
            self
        }
        /// <p>Specifies the connection id for the outbound cross-cluster search connection.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = input;
            self
        }
        /// <p>Specifies the connection alias for the outbound cross-cluster search connection.</p>
        pub fn connection_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_alias = Some(input.into());
            self
        }
        /// <p>Specifies the connection alias for the outbound cross-cluster search connection.</p>
        pub fn set_connection_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_alias = input;
            self
        }
        /// <p>Specifies the <code><code>OutboundCrossClusterSearchConnectionStatus</code></code> for the outbound connection.</p>
        pub fn connection_status(
            mut self,
            input: crate::model::OutboundCrossClusterSearchConnectionStatus,
        ) -> Self {
            self.connection_status = Some(input);
            self
        }
        /// <p>Specifies the <code><code>OutboundCrossClusterSearchConnectionStatus</code></code> for the outbound connection.</p>
        pub fn set_connection_status(
            mut self,
            input: std::option::Option<crate::model::OutboundCrossClusterSearchConnectionStatus>,
        ) -> Self {
            self.connection_status = input;
            self
        }
        /// Consumes the builder and constructs a [`OutboundCrossClusterSearchConnection`](crate::model::OutboundCrossClusterSearchConnection)
        pub fn build(self) -> crate::model::OutboundCrossClusterSearchConnection {
            crate::model::OutboundCrossClusterSearchConnection {
                source_domain_info: self.source_domain_info,
                destination_domain_info: self.destination_domain_info,
                cross_cluster_search_connection_id: self.cross_cluster_search_connection_id,
                connection_alias: self.connection_alias,
                connection_status: self.connection_status,
            }
        }
    }
}
impl OutboundCrossClusterSearchConnection {
    /// Creates a new builder-style object to manufacture [`OutboundCrossClusterSearchConnection`](crate::model::OutboundCrossClusterSearchConnection)
    pub fn builder() -> crate::model::outbound_cross_cluster_search_connection::Builder {
        crate::model::outbound_cross_cluster_search_connection::Builder::default()
    }
}

/// <p>Specifies the connection status of an outbound cross-cluster search connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutboundCrossClusterSearchConnectionStatus {
    /// <p>The state code for outbound connection. This can be one of the following:</p>
    /// <ul>
    /// <li>VALIDATING: The outbound connection request is being validated.</li>
    /// <li>VALIDATION_FAILED: Validation failed for the connection request.</li>
    /// <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by destination domain owner.</li>
    /// <li>PROVISIONING: Outbound connection request is in process.</li>
    /// <li>ACTIVE: Outbound connection is active and ready to use.</li>
    /// <li>REJECTED: Outbound connection request is rejected by destination domain owner.</li>
    /// <li>DELETING: Outbound connection deletion is in progress.</li>
    /// <li>DELETED: Outbound connection is deleted and cannot be used further.</li>
    /// </ul>
    pub status_code:
        std::option::Option<crate::model::OutboundCrossClusterSearchConnectionStatusCode>,
    /// <p>Specifies verbose information for the outbound connection status.</p>
    pub message: std::option::Option<std::string::String>,
}
impl OutboundCrossClusterSearchConnectionStatus {
    /// <p>The state code for outbound connection. This can be one of the following:</p>
    /// <ul>
    /// <li>VALIDATING: The outbound connection request is being validated.</li>
    /// <li>VALIDATION_FAILED: Validation failed for the connection request.</li>
    /// <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by destination domain owner.</li>
    /// <li>PROVISIONING: Outbound connection request is in process.</li>
    /// <li>ACTIVE: Outbound connection is active and ready to use.</li>
    /// <li>REJECTED: Outbound connection request is rejected by destination domain owner.</li>
    /// <li>DELETING: Outbound connection deletion is in progress.</li>
    /// <li>DELETED: Outbound connection is deleted and cannot be used further.</li>
    /// </ul>
    pub fn status_code(
        &self,
    ) -> std::option::Option<&crate::model::OutboundCrossClusterSearchConnectionStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>Specifies verbose information for the outbound connection status.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for OutboundCrossClusterSearchConnectionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutboundCrossClusterSearchConnectionStatus");
        formatter.field("status_code", &self.status_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`OutboundCrossClusterSearchConnectionStatus`](crate::model::OutboundCrossClusterSearchConnectionStatus)
pub mod outbound_cross_cluster_search_connection_status {
    /// A builder for [`OutboundCrossClusterSearchConnectionStatus`](crate::model::OutboundCrossClusterSearchConnectionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code:
            std::option::Option<crate::model::OutboundCrossClusterSearchConnectionStatusCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state code for outbound connection. This can be one of the following:</p>
        /// <ul>
        /// <li>VALIDATING: The outbound connection request is being validated.</li>
        /// <li>VALIDATION_FAILED: Validation failed for the connection request.</li>
        /// <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by destination domain owner.</li>
        /// <li>PROVISIONING: Outbound connection request is in process.</li>
        /// <li>ACTIVE: Outbound connection is active and ready to use.</li>
        /// <li>REJECTED: Outbound connection request is rejected by destination domain owner.</li>
        /// <li>DELETING: Outbound connection deletion is in progress.</li>
        /// <li>DELETED: Outbound connection is deleted and cannot be used further.</li>
        /// </ul>
        pub fn status_code(
            mut self,
            input: crate::model::OutboundCrossClusterSearchConnectionStatusCode,
        ) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The state code for outbound connection. This can be one of the following:</p>
        /// <ul>
        /// <li>VALIDATING: The outbound connection request is being validated.</li>
        /// <li>VALIDATION_FAILED: Validation failed for the connection request.</li>
        /// <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by destination domain owner.</li>
        /// <li>PROVISIONING: Outbound connection request is in process.</li>
        /// <li>ACTIVE: Outbound connection is active and ready to use.</li>
        /// <li>REJECTED: Outbound connection request is rejected by destination domain owner.</li>
        /// <li>DELETING: Outbound connection deletion is in progress.</li>
        /// <li>DELETED: Outbound connection is deleted and cannot be used further.</li>
        /// </ul>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<
                crate::model::OutboundCrossClusterSearchConnectionStatusCode,
            >,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>Specifies verbose information for the outbound connection status.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Specifies verbose information for the outbound connection status.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OutboundCrossClusterSearchConnectionStatus`](crate::model::OutboundCrossClusterSearchConnectionStatus)
        pub fn build(self) -> crate::model::OutboundCrossClusterSearchConnectionStatus {
            crate::model::OutboundCrossClusterSearchConnectionStatus {
                status_code: self.status_code,
                message: self.message,
            }
        }
    }
}
impl OutboundCrossClusterSearchConnectionStatus {
    /// Creates a new builder-style object to manufacture [`OutboundCrossClusterSearchConnectionStatus`](crate::model::OutboundCrossClusterSearchConnectionStatus)
    pub fn builder() -> crate::model::outbound_cross_cluster_search_connection_status::Builder {
        crate::model::outbound_cross_cluster_search_connection_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OutboundCrossClusterSearchConnectionStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    PendingAcceptance,
    #[allow(missing_docs)] // documentation missing in model
    Provisioning,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    Validating,
    #[allow(missing_docs)] // documentation missing in model
    ValidationFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OutboundCrossClusterSearchConnectionStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => OutboundCrossClusterSearchConnectionStatusCode::Active,
            "DELETED" => OutboundCrossClusterSearchConnectionStatusCode::Deleted,
            "DELETING" => OutboundCrossClusterSearchConnectionStatusCode::Deleting,
            "PENDING_ACCEPTANCE" => {
                OutboundCrossClusterSearchConnectionStatusCode::PendingAcceptance
            }
            "PROVISIONING" => OutboundCrossClusterSearchConnectionStatusCode::Provisioning,
            "REJECTED" => OutboundCrossClusterSearchConnectionStatusCode::Rejected,
            "VALIDATING" => OutboundCrossClusterSearchConnectionStatusCode::Validating,
            "VALIDATION_FAILED" => OutboundCrossClusterSearchConnectionStatusCode::ValidationFailed,
            other => OutboundCrossClusterSearchConnectionStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OutboundCrossClusterSearchConnectionStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OutboundCrossClusterSearchConnectionStatusCode::from(s))
    }
}
impl OutboundCrossClusterSearchConnectionStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OutboundCrossClusterSearchConnectionStatusCode::Active => "ACTIVE",
            OutboundCrossClusterSearchConnectionStatusCode::Deleted => "DELETED",
            OutboundCrossClusterSearchConnectionStatusCode::Deleting => "DELETING",
            OutboundCrossClusterSearchConnectionStatusCode::PendingAcceptance => {
                "PENDING_ACCEPTANCE"
            }
            OutboundCrossClusterSearchConnectionStatusCode::Provisioning => "PROVISIONING",
            OutboundCrossClusterSearchConnectionStatusCode::Rejected => "REJECTED",
            OutboundCrossClusterSearchConnectionStatusCode::Validating => "VALIDATING",
            OutboundCrossClusterSearchConnectionStatusCode::ValidationFailed => "VALIDATION_FAILED",
            OutboundCrossClusterSearchConnectionStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "DELETED",
            "DELETING",
            "PENDING_ACCEPTANCE",
            "PROVISIONING",
            "REJECTED",
            "VALIDATING",
            "VALIDATION_FAILED",
        ]
    }
}
impl AsRef<str> for OutboundCrossClusterSearchConnectionStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A filter used to limit results when describing inbound or outbound cross-cluster search connections. Multiple values can be specified per filter. A cross-cluster search connection must match at least one of the specified values for it to be returned from an operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p> Specifies the name of the filter. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> Contains one or more values for the filter. </p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Filter {
    /// <p> Specifies the name of the filter. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> Contains one or more values for the filter. </p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> Specifies the name of the filter. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> Specifies the name of the filter. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p> Contains one or more values for the filter. </p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p> Contains one or more values for the filter. </p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p> Limits for given InstanceType and for each of it's role. <br><br> Limits contains following <code> <code>StorageTypes,</code> </code> <code> <code>InstanceLimits</code> </code> and <code> <code>AdditionalLimits</code> </code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Limits {
    /// <p>StorageType represents the list of storage related types and attributes that are available for given InstanceType. </p>
    pub storage_types: std::option::Option<std::vec::Vec<crate::model::StorageType>>,
    /// <p>InstanceLimits represents the list of instance related attributes that are available for given InstanceType. </p>
    pub instance_limits: std::option::Option<crate::model::InstanceLimits>,
    /// <p> List of additional limits that are specific to a given InstanceType and for each of it's <code> <code>InstanceRole</code> </code> . </p>
    pub additional_limits: std::option::Option<std::vec::Vec<crate::model::AdditionalLimit>>,
}
impl Limits {
    /// <p>StorageType represents the list of storage related types and attributes that are available for given InstanceType. </p>
    pub fn storage_types(&self) -> std::option::Option<&[crate::model::StorageType]> {
        self.storage_types.as_deref()
    }
    /// <p>InstanceLimits represents the list of instance related attributes that are available for given InstanceType. </p>
    pub fn instance_limits(&self) -> std::option::Option<&crate::model::InstanceLimits> {
        self.instance_limits.as_ref()
    }
    /// <p> List of additional limits that are specific to a given InstanceType and for each of it's <code> <code>InstanceRole</code> </code> . </p>
    pub fn additional_limits(&self) -> std::option::Option<&[crate::model::AdditionalLimit]> {
        self.additional_limits.as_deref()
    }
}
impl std::fmt::Debug for Limits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Limits");
        formatter.field("storage_types", &self.storage_types);
        formatter.field("instance_limits", &self.instance_limits);
        formatter.field("additional_limits", &self.additional_limits);
        formatter.finish()
    }
}
/// See [`Limits`](crate::model::Limits)
pub mod limits {
    /// A builder for [`Limits`](crate::model::Limits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_types: std::option::Option<std::vec::Vec<crate::model::StorageType>>,
        pub(crate) instance_limits: std::option::Option<crate::model::InstanceLimits>,
        pub(crate) additional_limits:
            std::option::Option<std::vec::Vec<crate::model::AdditionalLimit>>,
    }
    impl Builder {
        /// Appends an item to `storage_types`.
        ///
        /// To override the contents of this collection use [`set_storage_types`](Self::set_storage_types).
        ///
        /// <p>StorageType represents the list of storage related types and attributes that are available for given InstanceType. </p>
        pub fn storage_types(mut self, input: crate::model::StorageType) -> Self {
            let mut v = self.storage_types.unwrap_or_default();
            v.push(input);
            self.storage_types = Some(v);
            self
        }
        /// <p>StorageType represents the list of storage related types and attributes that are available for given InstanceType. </p>
        pub fn set_storage_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageType>>,
        ) -> Self {
            self.storage_types = input;
            self
        }
        /// <p>InstanceLimits represents the list of instance related attributes that are available for given InstanceType. </p>
        pub fn instance_limits(mut self, input: crate::model::InstanceLimits) -> Self {
            self.instance_limits = Some(input);
            self
        }
        /// <p>InstanceLimits represents the list of instance related attributes that are available for given InstanceType. </p>
        pub fn set_instance_limits(
            mut self,
            input: std::option::Option<crate::model::InstanceLimits>,
        ) -> Self {
            self.instance_limits = input;
            self
        }
        /// Appends an item to `additional_limits`.
        ///
        /// To override the contents of this collection use [`set_additional_limits`](Self::set_additional_limits).
        ///
        /// <p> List of additional limits that are specific to a given InstanceType and for each of it's <code> <code>InstanceRole</code> </code> . </p>
        pub fn additional_limits(mut self, input: crate::model::AdditionalLimit) -> Self {
            let mut v = self.additional_limits.unwrap_or_default();
            v.push(input);
            self.additional_limits = Some(v);
            self
        }
        /// <p> List of additional limits that are specific to a given InstanceType and for each of it's <code> <code>InstanceRole</code> </code> . </p>
        pub fn set_additional_limits(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdditionalLimit>>,
        ) -> Self {
            self.additional_limits = input;
            self
        }
        /// Consumes the builder and constructs a [`Limits`](crate::model::Limits)
        pub fn build(self) -> crate::model::Limits {
            crate::model::Limits {
                storage_types: self.storage_types,
                instance_limits: self.instance_limits,
                additional_limits: self.additional_limits,
            }
        }
    }
}
impl Limits {
    /// Creates a new builder-style object to manufacture [`Limits`](crate::model::Limits)
    pub fn builder() -> crate::model::limits::Builder {
        crate::model::limits::Builder::default()
    }
}

/// <p> List of limits that are specific to a given InstanceType and for each of it's <code> <code>InstanceRole</code> </code> . </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdditionalLimit {
    /// <p> Name of Additional Limit is specific to a given InstanceType and for each of it's <code> <code>InstanceRole</code> </code> etc. <br><br> Attributes and their details: <br><br> </p>
    /// <ul>
    /// <li>MaximumNumberOfDataNodesSupported</li> This attribute will be present in Master node only to specify how much data nodes upto which given <code> <code>ESPartitionInstanceType</code> </code> can support as master node.
    /// <li>MaximumNumberOfDataNodesWithoutMasterNode</li> This attribute will be present in Data node only to specify how much data nodes of given <code> <code>ESPartitionInstanceType</code> </code> upto which you don't need any master nodes to govern them.
    /// </ul>
    /// <p></p>
    pub limit_name: std::option::Option<std::string::String>,
    /// <p> Value for given <code> <code>AdditionalLimit$LimitName</code> </code> . </p>
    pub limit_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AdditionalLimit {
    /// <p> Name of Additional Limit is specific to a given InstanceType and for each of it's <code> <code>InstanceRole</code> </code> etc. <br><br> Attributes and their details: <br><br> </p>
    /// <ul>
    /// <li>MaximumNumberOfDataNodesSupported</li> This attribute will be present in Master node only to specify how much data nodes upto which given <code> <code>ESPartitionInstanceType</code> </code> can support as master node.
    /// <li>MaximumNumberOfDataNodesWithoutMasterNode</li> This attribute will be present in Data node only to specify how much data nodes of given <code> <code>ESPartitionInstanceType</code> </code> upto which you don't need any master nodes to govern them.
    /// </ul>
    /// <p></p>
    pub fn limit_name(&self) -> std::option::Option<&str> {
        self.limit_name.as_deref()
    }
    /// <p> Value for given <code> <code>AdditionalLimit$LimitName</code> </code> . </p>
    pub fn limit_values(&self) -> std::option::Option<&[std::string::String]> {
        self.limit_values.as_deref()
    }
}
impl std::fmt::Debug for AdditionalLimit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdditionalLimit");
        formatter.field("limit_name", &self.limit_name);
        formatter.field("limit_values", &self.limit_values);
        formatter.finish()
    }
}
/// See [`AdditionalLimit`](crate::model::AdditionalLimit)
pub mod additional_limit {
    /// A builder for [`AdditionalLimit`](crate::model::AdditionalLimit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit_name: std::option::Option<std::string::String>,
        pub(crate) limit_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> Name of Additional Limit is specific to a given InstanceType and for each of it's <code> <code>InstanceRole</code> </code> etc. <br><br> Attributes and their details: <br><br> </p>
        /// <ul>
        /// <li>MaximumNumberOfDataNodesSupported</li> This attribute will be present in Master node only to specify how much data nodes upto which given <code> <code>ESPartitionInstanceType</code> </code> can support as master node.
        /// <li>MaximumNumberOfDataNodesWithoutMasterNode</li> This attribute will be present in Data node only to specify how much data nodes of given <code> <code>ESPartitionInstanceType</code> </code> upto which you don't need any master nodes to govern them.
        /// </ul>
        /// <p></p>
        pub fn limit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.limit_name = Some(input.into());
            self
        }
        /// <p> Name of Additional Limit is specific to a given InstanceType and for each of it's <code> <code>InstanceRole</code> </code> etc. <br><br> Attributes and their details: <br><br> </p>
        /// <ul>
        /// <li>MaximumNumberOfDataNodesSupported</li> This attribute will be present in Master node only to specify how much data nodes upto which given <code> <code>ESPartitionInstanceType</code> </code> can support as master node.
        /// <li>MaximumNumberOfDataNodesWithoutMasterNode</li> This attribute will be present in Data node only to specify how much data nodes of given <code> <code>ESPartitionInstanceType</code> </code> upto which you don't need any master nodes to govern them.
        /// </ul>
        /// <p></p>
        pub fn set_limit_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.limit_name = input;
            self
        }
        /// Appends an item to `limit_values`.
        ///
        /// To override the contents of this collection use [`set_limit_values`](Self::set_limit_values).
        ///
        /// <p> Value for given <code> <code>AdditionalLimit$LimitName</code> </code> . </p>
        pub fn limit_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.limit_values.unwrap_or_default();
            v.push(input.into());
            self.limit_values = Some(v);
            self
        }
        /// <p> Value for given <code> <code>AdditionalLimit$LimitName</code> </code> . </p>
        pub fn set_limit_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.limit_values = input;
            self
        }
        /// Consumes the builder and constructs a [`AdditionalLimit`](crate::model::AdditionalLimit)
        pub fn build(self) -> crate::model::AdditionalLimit {
            crate::model::AdditionalLimit {
                limit_name: self.limit_name,
                limit_values: self.limit_values,
            }
        }
    }
}
impl AdditionalLimit {
    /// Creates a new builder-style object to manufacture [`AdditionalLimit`](crate::model::AdditionalLimit)
    pub fn builder() -> crate::model::additional_limit::Builder {
        crate::model::additional_limit::Builder::default()
    }
}

/// <p>InstanceLimits represents the list of instance related attributes that are available for given InstanceType. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceLimits {
    /// <p> InstanceCountLimits represents the limits on number of instances that be created in Amazon Elasticsearch for given InstanceType. </p>
    pub instance_count_limits: std::option::Option<crate::model::InstanceCountLimits>,
}
impl InstanceLimits {
    /// <p> InstanceCountLimits represents the limits on number of instances that be created in Amazon Elasticsearch for given InstanceType. </p>
    pub fn instance_count_limits(&self) -> std::option::Option<&crate::model::InstanceCountLimits> {
        self.instance_count_limits.as_ref()
    }
}
impl std::fmt::Debug for InstanceLimits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceLimits");
        formatter.field("instance_count_limits", &self.instance_count_limits);
        formatter.finish()
    }
}
/// See [`InstanceLimits`](crate::model::InstanceLimits)
pub mod instance_limits {
    /// A builder for [`InstanceLimits`](crate::model::InstanceLimits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_count_limits: std::option::Option<crate::model::InstanceCountLimits>,
    }
    impl Builder {
        /// <p> InstanceCountLimits represents the limits on number of instances that be created in Amazon Elasticsearch for given InstanceType. </p>
        pub fn instance_count_limits(mut self, input: crate::model::InstanceCountLimits) -> Self {
            self.instance_count_limits = Some(input);
            self
        }
        /// <p> InstanceCountLimits represents the limits on number of instances that be created in Amazon Elasticsearch for given InstanceType. </p>
        pub fn set_instance_count_limits(
            mut self,
            input: std::option::Option<crate::model::InstanceCountLimits>,
        ) -> Self {
            self.instance_count_limits = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceLimits`](crate::model::InstanceLimits)
        pub fn build(self) -> crate::model::InstanceLimits {
            crate::model::InstanceLimits {
                instance_count_limits: self.instance_count_limits,
            }
        }
    }
}
impl InstanceLimits {
    /// Creates a new builder-style object to manufacture [`InstanceLimits`](crate::model::InstanceLimits)
    pub fn builder() -> crate::model::instance_limits::Builder {
        crate::model::instance_limits::Builder::default()
    }
}

/// <p> InstanceCountLimits represents the limits on number of instances that be created in Amazon Elasticsearch for given InstanceType. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceCountLimits {
    /// <p> Minimum number of Instances that can be instantiated for given InstanceType. </p>
    pub minimum_instance_count: i32,
    /// <p> Maximum number of Instances that can be instantiated for given InstanceType. </p>
    pub maximum_instance_count: i32,
}
impl InstanceCountLimits {
    /// <p> Minimum number of Instances that can be instantiated for given InstanceType. </p>
    pub fn minimum_instance_count(&self) -> i32 {
        self.minimum_instance_count
    }
    /// <p> Maximum number of Instances that can be instantiated for given InstanceType. </p>
    pub fn maximum_instance_count(&self) -> i32 {
        self.maximum_instance_count
    }
}
impl std::fmt::Debug for InstanceCountLimits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceCountLimits");
        formatter.field("minimum_instance_count", &self.minimum_instance_count);
        formatter.field("maximum_instance_count", &self.maximum_instance_count);
        formatter.finish()
    }
}
/// See [`InstanceCountLimits`](crate::model::InstanceCountLimits)
pub mod instance_count_limits {
    /// A builder for [`InstanceCountLimits`](crate::model::InstanceCountLimits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) minimum_instance_count: std::option::Option<i32>,
        pub(crate) maximum_instance_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> Minimum number of Instances that can be instantiated for given InstanceType. </p>
        pub fn minimum_instance_count(mut self, input: i32) -> Self {
            self.minimum_instance_count = Some(input);
            self
        }
        /// <p> Minimum number of Instances that can be instantiated for given InstanceType. </p>
        pub fn set_minimum_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_instance_count = input;
            self
        }
        /// <p> Maximum number of Instances that can be instantiated for given InstanceType. </p>
        pub fn maximum_instance_count(mut self, input: i32) -> Self {
            self.maximum_instance_count = Some(input);
            self
        }
        /// <p> Maximum number of Instances that can be instantiated for given InstanceType. </p>
        pub fn set_maximum_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_instance_count = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceCountLimits`](crate::model::InstanceCountLimits)
        pub fn build(self) -> crate::model::InstanceCountLimits {
            crate::model::InstanceCountLimits {
                minimum_instance_count: self.minimum_instance_count.unwrap_or_default(),
                maximum_instance_count: self.maximum_instance_count.unwrap_or_default(),
            }
        }
    }
}
impl InstanceCountLimits {
    /// Creates a new builder-style object to manufacture [`InstanceCountLimits`](crate::model::InstanceCountLimits)
    pub fn builder() -> crate::model::instance_count_limits::Builder {
        crate::model::instance_count_limits::Builder::default()
    }
}

/// <p>StorageTypes represents the list of storage related types and their attributes that are available for given InstanceType. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageType {
    /// <p> Type of the storage. List of available storage options: </p>
    /// <ol>
    /// <li>instance</li> Inbuilt storage available for the given Instance
    /// <li>ebs</li> Elastic block storage that would be attached to the given Instance
    /// </ol>
    /// <p></p>
    pub storage_type_name: std::option::Option<std::string::String>,
    /// <p> SubType of the given storage type. List of available sub-storage options: For "instance" storageType we wont have any storageSubType, in case of "ebs" storageType we will have following valid storageSubTypes </p>
    /// <ol>
    /// <li>standard</li>
    /// <li>gp2</li>
    /// <li>io1</li>
    /// </ol> Refer <code><code>VolumeType</code></code> for more information regarding above EBS storage options.
    /// <p></p>
    pub storage_sub_type_name: std::option::Option<std::string::String>,
    /// <p>List of limits that are applicable for given storage type. </p>
    pub storage_type_limits: std::option::Option<std::vec::Vec<crate::model::StorageTypeLimit>>,
}
impl StorageType {
    /// <p> Type of the storage. List of available storage options: </p>
    /// <ol>
    /// <li>instance</li> Inbuilt storage available for the given Instance
    /// <li>ebs</li> Elastic block storage that would be attached to the given Instance
    /// </ol>
    /// <p></p>
    pub fn storage_type_name(&self) -> std::option::Option<&str> {
        self.storage_type_name.as_deref()
    }
    /// <p> SubType of the given storage type. List of available sub-storage options: For "instance" storageType we wont have any storageSubType, in case of "ebs" storageType we will have following valid storageSubTypes </p>
    /// <ol>
    /// <li>standard</li>
    /// <li>gp2</li>
    /// <li>io1</li>
    /// </ol> Refer <code><code>VolumeType</code></code> for more information regarding above EBS storage options.
    /// <p></p>
    pub fn storage_sub_type_name(&self) -> std::option::Option<&str> {
        self.storage_sub_type_name.as_deref()
    }
    /// <p>List of limits that are applicable for given storage type. </p>
    pub fn storage_type_limits(&self) -> std::option::Option<&[crate::model::StorageTypeLimit]> {
        self.storage_type_limits.as_deref()
    }
}
impl std::fmt::Debug for StorageType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageType");
        formatter.field("storage_type_name", &self.storage_type_name);
        formatter.field("storage_sub_type_name", &self.storage_sub_type_name);
        formatter.field("storage_type_limits", &self.storage_type_limits);
        formatter.finish()
    }
}
/// See [`StorageType`](crate::model::StorageType)
pub mod storage_type {
    /// A builder for [`StorageType`](crate::model::StorageType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_type_name: std::option::Option<std::string::String>,
        pub(crate) storage_sub_type_name: std::option::Option<std::string::String>,
        pub(crate) storage_type_limits:
            std::option::Option<std::vec::Vec<crate::model::StorageTypeLimit>>,
    }
    impl Builder {
        /// <p> Type of the storage. List of available storage options: </p>
        /// <ol>
        /// <li>instance</li> Inbuilt storage available for the given Instance
        /// <li>ebs</li> Elastic block storage that would be attached to the given Instance
        /// </ol>
        /// <p></p>
        pub fn storage_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type_name = Some(input.into());
            self
        }
        /// <p> Type of the storage. List of available storage options: </p>
        /// <ol>
        /// <li>instance</li> Inbuilt storage available for the given Instance
        /// <li>ebs</li> Elastic block storage that would be attached to the given Instance
        /// </ol>
        /// <p></p>
        pub fn set_storage_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.storage_type_name = input;
            self
        }
        /// <p> SubType of the given storage type. List of available sub-storage options: For "instance" storageType we wont have any storageSubType, in case of "ebs" storageType we will have following valid storageSubTypes </p>
        /// <ol>
        /// <li>standard</li>
        /// <li>gp2</li>
        /// <li>io1</li>
        /// </ol> Refer <code><code>VolumeType</code></code> for more information regarding above EBS storage options.
        /// <p></p>
        pub fn storage_sub_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_sub_type_name = Some(input.into());
            self
        }
        /// <p> SubType of the given storage type. List of available sub-storage options: For "instance" storageType we wont have any storageSubType, in case of "ebs" storageType we will have following valid storageSubTypes </p>
        /// <ol>
        /// <li>standard</li>
        /// <li>gp2</li>
        /// <li>io1</li>
        /// </ol> Refer <code><code>VolumeType</code></code> for more information regarding above EBS storage options.
        /// <p></p>
        pub fn set_storage_sub_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.storage_sub_type_name = input;
            self
        }
        /// Appends an item to `storage_type_limits`.
        ///
        /// To override the contents of this collection use [`set_storage_type_limits`](Self::set_storage_type_limits).
        ///
        /// <p>List of limits that are applicable for given storage type. </p>
        pub fn storage_type_limits(mut self, input: crate::model::StorageTypeLimit) -> Self {
            let mut v = self.storage_type_limits.unwrap_or_default();
            v.push(input);
            self.storage_type_limits = Some(v);
            self
        }
        /// <p>List of limits that are applicable for given storage type. </p>
        pub fn set_storage_type_limits(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageTypeLimit>>,
        ) -> Self {
            self.storage_type_limits = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageType`](crate::model::StorageType)
        pub fn build(self) -> crate::model::StorageType {
            crate::model::StorageType {
                storage_type_name: self.storage_type_name,
                storage_sub_type_name: self.storage_sub_type_name,
                storage_type_limits: self.storage_type_limits,
            }
        }
    }
}
impl StorageType {
    /// Creates a new builder-style object to manufacture [`StorageType`](crate::model::StorageType)
    pub fn builder() -> crate::model::storage_type::Builder {
        crate::model::storage_type::Builder::default()
    }
}

/// <p>Limits that are applicable for given storage type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageTypeLimit {
    /// <p> Name of storage limits that are applicable for given storage type. If <code> <code>StorageType</code> </code> is ebs, following storage options are applicable </p>
    /// <ol>
    /// <li>MinimumVolumeSize</li> Minimum amount of volume size that is applicable for given storage type.It can be empty if it is not applicable.
    /// <li>MaximumVolumeSize</li> Maximum amount of volume size that is applicable for given storage type.It can be empty if it is not applicable.
    /// <li>MaximumIops</li> Maximum amount of Iops that is applicable for given storage type.It can be empty if it is not applicable.
    /// <li>MinimumIops</li> Minimum amount of Iops that is applicable for given storage type.It can be empty if it is not applicable.
    /// </ol>
    /// <p></p>
    pub limit_name: std::option::Option<std::string::String>,
    /// <p> Values for the <code> <code>StorageTypeLimit$LimitName</code> </code> . </p>
    pub limit_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl StorageTypeLimit {
    /// <p> Name of storage limits that are applicable for given storage type. If <code> <code>StorageType</code> </code> is ebs, following storage options are applicable </p>
    /// <ol>
    /// <li>MinimumVolumeSize</li> Minimum amount of volume size that is applicable for given storage type.It can be empty if it is not applicable.
    /// <li>MaximumVolumeSize</li> Maximum amount of volume size that is applicable for given storage type.It can be empty if it is not applicable.
    /// <li>MaximumIops</li> Maximum amount of Iops that is applicable for given storage type.It can be empty if it is not applicable.
    /// <li>MinimumIops</li> Minimum amount of Iops that is applicable for given storage type.It can be empty if it is not applicable.
    /// </ol>
    /// <p></p>
    pub fn limit_name(&self) -> std::option::Option<&str> {
        self.limit_name.as_deref()
    }
    /// <p> Values for the <code> <code>StorageTypeLimit$LimitName</code> </code> . </p>
    pub fn limit_values(&self) -> std::option::Option<&[std::string::String]> {
        self.limit_values.as_deref()
    }
}
impl std::fmt::Debug for StorageTypeLimit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageTypeLimit");
        formatter.field("limit_name", &self.limit_name);
        formatter.field("limit_values", &self.limit_values);
        formatter.finish()
    }
}
/// See [`StorageTypeLimit`](crate::model::StorageTypeLimit)
pub mod storage_type_limit {
    /// A builder for [`StorageTypeLimit`](crate::model::StorageTypeLimit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit_name: std::option::Option<std::string::String>,
        pub(crate) limit_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> Name of storage limits that are applicable for given storage type. If <code> <code>StorageType</code> </code> is ebs, following storage options are applicable </p>
        /// <ol>
        /// <li>MinimumVolumeSize</li> Minimum amount of volume size that is applicable for given storage type.It can be empty if it is not applicable.
        /// <li>MaximumVolumeSize</li> Maximum amount of volume size that is applicable for given storage type.It can be empty if it is not applicable.
        /// <li>MaximumIops</li> Maximum amount of Iops that is applicable for given storage type.It can be empty if it is not applicable.
        /// <li>MinimumIops</li> Minimum amount of Iops that is applicable for given storage type.It can be empty if it is not applicable.
        /// </ol>
        /// <p></p>
        pub fn limit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.limit_name = Some(input.into());
            self
        }
        /// <p> Name of storage limits that are applicable for given storage type. If <code> <code>StorageType</code> </code> is ebs, following storage options are applicable </p>
        /// <ol>
        /// <li>MinimumVolumeSize</li> Minimum amount of volume size that is applicable for given storage type.It can be empty if it is not applicable.
        /// <li>MaximumVolumeSize</li> Maximum amount of volume size that is applicable for given storage type.It can be empty if it is not applicable.
        /// <li>MaximumIops</li> Maximum amount of Iops that is applicable for given storage type.It can be empty if it is not applicable.
        /// <li>MinimumIops</li> Minimum amount of Iops that is applicable for given storage type.It can be empty if it is not applicable.
        /// </ol>
        /// <p></p>
        pub fn set_limit_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.limit_name = input;
            self
        }
        /// Appends an item to `limit_values`.
        ///
        /// To override the contents of this collection use [`set_limit_values`](Self::set_limit_values).
        ///
        /// <p> Values for the <code> <code>StorageTypeLimit$LimitName</code> </code> . </p>
        pub fn limit_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.limit_values.unwrap_or_default();
            v.push(input.into());
            self.limit_values = Some(v);
            self
        }
        /// <p> Values for the <code> <code>StorageTypeLimit$LimitName</code> </code> . </p>
        pub fn set_limit_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.limit_values = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageTypeLimit`](crate::model::StorageTypeLimit)
        pub fn build(self) -> crate::model::StorageTypeLimit {
            crate::model::StorageTypeLimit {
                limit_name: self.limit_name,
                limit_values: self.limit_values,
            }
        }
    }
}
impl StorageTypeLimit {
    /// Creates a new builder-style object to manufacture [`StorageTypeLimit`](crate::model::StorageTypeLimit)
    pub fn builder() -> crate::model::storage_type_limit::Builder {
        crate::model::storage_type_limit::Builder::default()
    }
}

/// <p>The current status of an Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticsearchDomainStatus {
    /// <p>The unique identifier for the specified Elasticsearch domain.</p>
    pub domain_id: std::option::Option<std::string::String>,
    /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) of an Elasticsearch domain. See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities</a> in <i>Using AWS Identity and Access Management</i> for more information.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The domain creation status. <code>True</code> if the creation of an Elasticsearch domain is complete. <code>False</code> if domain creation is still in progress.</p>
    pub created: std::option::Option<bool>,
    /// <p>The domain deletion status. <code>True</code> if a delete request has been received for the domain but resource cleanup is still in progress. <code>False</code> if the domain has not been deleted. Once domain deletion is complete, the status of the domain is no longer returned.</p>
    pub deleted: std::option::Option<bool>,
    /// <p>The Elasticsearch domain endpoint that you use to submit index and search requests.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>Map containing the Elasticsearch domain endpoints used to submit index and search requests. Example <code>key, value</code>: <code>'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'</code>.</p>
    pub endpoints:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The status of the Elasticsearch domain configuration. <code>True</code> if Amazon Elasticsearch Service is processing configuration changes. <code>False</code> if the configuration is active.</p>
    pub processing: std::option::Option<bool>,
    /// <p>The status of an Elasticsearch domain version upgrade. <code>True</code> if Amazon Elasticsearch Service is undergoing a version upgrade. <code>False</code> if the configuration is active.</p>
    pub upgrade_processing: std::option::Option<bool>,
    #[allow(missing_docs)] // documentation missing in model
    pub elasticsearch_version: std::option::Option<std::string::String>,
    /// <p>The type and number of instances in the domain cluster.</p>
    pub elasticsearch_cluster_config: std::option::Option<crate::model::ElasticsearchClusterConfig>,
    /// <p>The <code>EBSOptions</code> for the specified domain. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs" target="_blank">Configuring EBS-based Storage</a> for more information.</p>
    pub ebs_options: std::option::Option<crate::model::EbsOptions>,
    /// <p> IAM access policy as a JSON-formatted string.</p>
    pub access_policies: std::option::Option<std::string::String>,
    /// <p>Specifies the status of the <code>SnapshotOptions</code></p>
    pub snapshot_options: std::option::Option<crate::model::SnapshotOptions>,
    /// <p>The <code>VPCOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank">VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>
    pub vpc_options: std::option::Option<crate::model::VpcDerivedInfo>,
    /// <p>The <code>CognitoOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
    pub cognito_options: std::option::Option<crate::model::CognitoOptions>,
    /// <p> Specifies the status of the <code>EncryptionAtRestOptions</code>.</p>
    pub encryption_at_rest_options: std::option::Option<crate::model::EncryptionAtRestOptions>,
    /// <p>Specifies the status of the <code>NodeToNodeEncryptionOptions</code>.</p>
    pub node_to_node_encryption_options:
        std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
    /// <p>Specifies the status of the <code>AdvancedOptions</code></p>
    pub advanced_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Log publishing options for the given domain.</p>
    pub log_publishing_options: std::option::Option<
        std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
    >,
    /// <p>The current status of the Elasticsearch domain's service software.</p>
    pub service_software_options: std::option::Option<crate::model::ServiceSoftwareOptions>,
    /// <p>The current status of the Elasticsearch domain's endpoint options.</p>
    pub domain_endpoint_options: std::option::Option<crate::model::DomainEndpointOptions>,
    /// <p>The current status of the Elasticsearch domain's advanced security options.</p>
    pub advanced_security_options: std::option::Option<crate::model::AdvancedSecurityOptions>,
    /// <p>The current status of the Elasticsearch domain's Auto-Tune options.</p>
    pub auto_tune_options: std::option::Option<crate::model::AutoTuneOptionsOutput>,
}
impl ElasticsearchDomainStatus {
    /// <p>The unique identifier for the specified Elasticsearch domain.</p>
    pub fn domain_id(&self) -> std::option::Option<&str> {
        self.domain_id.as_deref()
    }
    /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The Amazon resource name (ARN) of an Elasticsearch domain. See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities</a> in <i>Using AWS Identity and Access Management</i> for more information.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The domain creation status. <code>True</code> if the creation of an Elasticsearch domain is complete. <code>False</code> if domain creation is still in progress.</p>
    pub fn created(&self) -> std::option::Option<bool> {
        self.created
    }
    /// <p>The domain deletion status. <code>True</code> if a delete request has been received for the domain but resource cleanup is still in progress. <code>False</code> if the domain has not been deleted. Once domain deletion is complete, the status of the domain is no longer returned.</p>
    pub fn deleted(&self) -> std::option::Option<bool> {
        self.deleted
    }
    /// <p>The Elasticsearch domain endpoint that you use to submit index and search requests.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>Map containing the Elasticsearch domain endpoints used to submit index and search requests. Example <code>key, value</code>: <code>'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'</code>.</p>
    pub fn endpoints(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.endpoints.as_ref()
    }
    /// <p>The status of the Elasticsearch domain configuration. <code>True</code> if Amazon Elasticsearch Service is processing configuration changes. <code>False</code> if the configuration is active.</p>
    pub fn processing(&self) -> std::option::Option<bool> {
        self.processing
    }
    /// <p>The status of an Elasticsearch domain version upgrade. <code>True</code> if Amazon Elasticsearch Service is undergoing a version upgrade. <code>False</code> if the configuration is active.</p>
    pub fn upgrade_processing(&self) -> std::option::Option<bool> {
        self.upgrade_processing
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn elasticsearch_version(&self) -> std::option::Option<&str> {
        self.elasticsearch_version.as_deref()
    }
    /// <p>The type and number of instances in the domain cluster.</p>
    pub fn elasticsearch_cluster_config(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchClusterConfig> {
        self.elasticsearch_cluster_config.as_ref()
    }
    /// <p>The <code>EBSOptions</code> for the specified domain. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs" target="_blank">Configuring EBS-based Storage</a> for more information.</p>
    pub fn ebs_options(&self) -> std::option::Option<&crate::model::EbsOptions> {
        self.ebs_options.as_ref()
    }
    /// <p> IAM access policy as a JSON-formatted string.</p>
    pub fn access_policies(&self) -> std::option::Option<&str> {
        self.access_policies.as_deref()
    }
    /// <p>Specifies the status of the <code>SnapshotOptions</code></p>
    pub fn snapshot_options(&self) -> std::option::Option<&crate::model::SnapshotOptions> {
        self.snapshot_options.as_ref()
    }
    /// <p>The <code>VPCOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank">VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>
    pub fn vpc_options(&self) -> std::option::Option<&crate::model::VpcDerivedInfo> {
        self.vpc_options.as_ref()
    }
    /// <p>The <code>CognitoOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
    pub fn cognito_options(&self) -> std::option::Option<&crate::model::CognitoOptions> {
        self.cognito_options.as_ref()
    }
    /// <p> Specifies the status of the <code>EncryptionAtRestOptions</code>.</p>
    pub fn encryption_at_rest_options(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionAtRestOptions> {
        self.encryption_at_rest_options.as_ref()
    }
    /// <p>Specifies the status of the <code>NodeToNodeEncryptionOptions</code>.</p>
    pub fn node_to_node_encryption_options(
        &self,
    ) -> std::option::Option<&crate::model::NodeToNodeEncryptionOptions> {
        self.node_to_node_encryption_options.as_ref()
    }
    /// <p>Specifies the status of the <code>AdvancedOptions</code></p>
    pub fn advanced_options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.advanced_options.as_ref()
    }
    /// <p>Log publishing options for the given domain.</p>
    pub fn log_publishing_options(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
    > {
        self.log_publishing_options.as_ref()
    }
    /// <p>The current status of the Elasticsearch domain's service software.</p>
    pub fn service_software_options(
        &self,
    ) -> std::option::Option<&crate::model::ServiceSoftwareOptions> {
        self.service_software_options.as_ref()
    }
    /// <p>The current status of the Elasticsearch domain's endpoint options.</p>
    pub fn domain_endpoint_options(
        &self,
    ) -> std::option::Option<&crate::model::DomainEndpointOptions> {
        self.domain_endpoint_options.as_ref()
    }
    /// <p>The current status of the Elasticsearch domain's advanced security options.</p>
    pub fn advanced_security_options(
        &self,
    ) -> std::option::Option<&crate::model::AdvancedSecurityOptions> {
        self.advanced_security_options.as_ref()
    }
    /// <p>The current status of the Elasticsearch domain's Auto-Tune options.</p>
    pub fn auto_tune_options(&self) -> std::option::Option<&crate::model::AutoTuneOptionsOutput> {
        self.auto_tune_options.as_ref()
    }
}
impl std::fmt::Debug for ElasticsearchDomainStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticsearchDomainStatus");
        formatter.field("domain_id", &self.domain_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("arn", &self.arn);
        formatter.field("created", &self.created);
        formatter.field("deleted", &self.deleted);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("endpoints", &self.endpoints);
        formatter.field("processing", &self.processing);
        formatter.field("upgrade_processing", &self.upgrade_processing);
        formatter.field("elasticsearch_version", &self.elasticsearch_version);
        formatter.field(
            "elasticsearch_cluster_config",
            &self.elasticsearch_cluster_config,
        );
        formatter.field("ebs_options", &self.ebs_options);
        formatter.field("access_policies", &self.access_policies);
        formatter.field("snapshot_options", &self.snapshot_options);
        formatter.field("vpc_options", &self.vpc_options);
        formatter.field("cognito_options", &self.cognito_options);
        formatter.field(
            "encryption_at_rest_options",
            &self.encryption_at_rest_options,
        );
        formatter.field(
            "node_to_node_encryption_options",
            &self.node_to_node_encryption_options,
        );
        formatter.field("advanced_options", &self.advanced_options);
        formatter.field("log_publishing_options", &self.log_publishing_options);
        formatter.field("service_software_options", &self.service_software_options);
        formatter.field("domain_endpoint_options", &self.domain_endpoint_options);
        formatter.field("advanced_security_options", &self.advanced_security_options);
        formatter.field("auto_tune_options", &self.auto_tune_options);
        formatter.finish()
    }
}
/// See [`ElasticsearchDomainStatus`](crate::model::ElasticsearchDomainStatus)
pub mod elasticsearch_domain_status {
    /// A builder for [`ElasticsearchDomainStatus`](crate::model::ElasticsearchDomainStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<bool>,
        pub(crate) deleted: std::option::Option<bool>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) endpoints: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) processing: std::option::Option<bool>,
        pub(crate) upgrade_processing: std::option::Option<bool>,
        pub(crate) elasticsearch_version: std::option::Option<std::string::String>,
        pub(crate) elasticsearch_cluster_config:
            std::option::Option<crate::model::ElasticsearchClusterConfig>,
        pub(crate) ebs_options: std::option::Option<crate::model::EbsOptions>,
        pub(crate) access_policies: std::option::Option<std::string::String>,
        pub(crate) snapshot_options: std::option::Option<crate::model::SnapshotOptions>,
        pub(crate) vpc_options: std::option::Option<crate::model::VpcDerivedInfo>,
        pub(crate) cognito_options: std::option::Option<crate::model::CognitoOptions>,
        pub(crate) encryption_at_rest_options:
            std::option::Option<crate::model::EncryptionAtRestOptions>,
        pub(crate) node_to_node_encryption_options:
            std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        pub(crate) advanced_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) log_publishing_options: std::option::Option<
            std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
        >,
        pub(crate) service_software_options:
            std::option::Option<crate::model::ServiceSoftwareOptions>,
        pub(crate) domain_endpoint_options:
            std::option::Option<crate::model::DomainEndpointOptions>,
        pub(crate) advanced_security_options:
            std::option::Option<crate::model::AdvancedSecurityOptions>,
        pub(crate) auto_tune_options: std::option::Option<crate::model::AutoTuneOptionsOutput>,
    }
    impl Builder {
        /// <p>The unique identifier for the specified Elasticsearch domain.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the specified Elasticsearch domain.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The Amazon resource name (ARN) of an Elasticsearch domain. See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities</a> in <i>Using AWS Identity and Access Management</i> for more information.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) of an Elasticsearch domain. See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities</a> in <i>Using AWS Identity and Access Management</i> for more information.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The domain creation status. <code>True</code> if the creation of an Elasticsearch domain is complete. <code>False</code> if domain creation is still in progress.</p>
        pub fn created(mut self, input: bool) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The domain creation status. <code>True</code> if the creation of an Elasticsearch domain is complete. <code>False</code> if domain creation is still in progress.</p>
        pub fn set_created(mut self, input: std::option::Option<bool>) -> Self {
            self.created = input;
            self
        }
        /// <p>The domain deletion status. <code>True</code> if a delete request has been received for the domain but resource cleanup is still in progress. <code>False</code> if the domain has not been deleted. Once domain deletion is complete, the status of the domain is no longer returned.</p>
        pub fn deleted(mut self, input: bool) -> Self {
            self.deleted = Some(input);
            self
        }
        /// <p>The domain deletion status. <code>True</code> if a delete request has been received for the domain but resource cleanup is still in progress. <code>False</code> if the domain has not been deleted. Once domain deletion is complete, the status of the domain is no longer returned.</p>
        pub fn set_deleted(mut self, input: std::option::Option<bool>) -> Self {
            self.deleted = input;
            self
        }
        /// <p>The Elasticsearch domain endpoint that you use to submit index and search requests.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The Elasticsearch domain endpoint that you use to submit index and search requests.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// Adds a key-value pair to `endpoints`.
        ///
        /// To override the contents of this collection use [`set_endpoints`](Self::set_endpoints).
        ///
        /// <p>Map containing the Elasticsearch domain endpoints used to submit index and search requests. Example <code>key, value</code>: <code>'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'</code>.</p>
        pub fn endpoints(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.endpoints.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.endpoints = Some(hash_map);
            self
        }
        /// <p>Map containing the Elasticsearch domain endpoints used to submit index and search requests. Example <code>key, value</code>: <code>'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'</code>.</p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.endpoints = input;
            self
        }
        /// <p>The status of the Elasticsearch domain configuration. <code>True</code> if Amazon Elasticsearch Service is processing configuration changes. <code>False</code> if the configuration is active.</p>
        pub fn processing(mut self, input: bool) -> Self {
            self.processing = Some(input);
            self
        }
        /// <p>The status of the Elasticsearch domain configuration. <code>True</code> if Amazon Elasticsearch Service is processing configuration changes. <code>False</code> if the configuration is active.</p>
        pub fn set_processing(mut self, input: std::option::Option<bool>) -> Self {
            self.processing = input;
            self
        }
        /// <p>The status of an Elasticsearch domain version upgrade. <code>True</code> if Amazon Elasticsearch Service is undergoing a version upgrade. <code>False</code> if the configuration is active.</p>
        pub fn upgrade_processing(mut self, input: bool) -> Self {
            self.upgrade_processing = Some(input);
            self
        }
        /// <p>The status of an Elasticsearch domain version upgrade. <code>True</code> if Amazon Elasticsearch Service is undergoing a version upgrade. <code>False</code> if the configuration is active.</p>
        pub fn set_upgrade_processing(mut self, input: std::option::Option<bool>) -> Self {
            self.upgrade_processing = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn elasticsearch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.elasticsearch_version = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_elasticsearch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elasticsearch_version = input;
            self
        }
        /// <p>The type and number of instances in the domain cluster.</p>
        pub fn elasticsearch_cluster_config(
            mut self,
            input: crate::model::ElasticsearchClusterConfig,
        ) -> Self {
            self.elasticsearch_cluster_config = Some(input);
            self
        }
        /// <p>The type and number of instances in the domain cluster.</p>
        pub fn set_elasticsearch_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchClusterConfig>,
        ) -> Self {
            self.elasticsearch_cluster_config = input;
            self
        }
        /// <p>The <code>EBSOptions</code> for the specified domain. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs" target="_blank">Configuring EBS-based Storage</a> for more information.</p>
        pub fn ebs_options(mut self, input: crate::model::EbsOptions) -> Self {
            self.ebs_options = Some(input);
            self
        }
        /// <p>The <code>EBSOptions</code> for the specified domain. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs" target="_blank">Configuring EBS-based Storage</a> for more information.</p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptions>,
        ) -> Self {
            self.ebs_options = input;
            self
        }
        /// <p> IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policies = Some(input.into());
            self
        }
        /// <p> IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policies = input;
            self
        }
        /// <p>Specifies the status of the <code>SnapshotOptions</code></p>
        pub fn snapshot_options(mut self, input: crate::model::SnapshotOptions) -> Self {
            self.snapshot_options = Some(input);
            self
        }
        /// <p>Specifies the status of the <code>SnapshotOptions</code></p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.snapshot_options = input;
            self
        }
        /// <p>The <code>VPCOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank">VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>
        pub fn vpc_options(mut self, input: crate::model::VpcDerivedInfo) -> Self {
            self.vpc_options = Some(input);
            self
        }
        /// <p>The <code>VPCOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank">VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcDerivedInfo>,
        ) -> Self {
            self.vpc_options = input;
            self
        }
        /// <p>The <code>CognitoOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn cognito_options(mut self, input: crate::model::CognitoOptions) -> Self {
            self.cognito_options = Some(input);
            self
        }
        /// <p>The <code>CognitoOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.cognito_options = input;
            self
        }
        /// <p> Specifies the status of the <code>EncryptionAtRestOptions</code>.</p>
        pub fn encryption_at_rest_options(
            mut self,
            input: crate::model::EncryptionAtRestOptions,
        ) -> Self {
            self.encryption_at_rest_options = Some(input);
            self
        }
        /// <p> Specifies the status of the <code>EncryptionAtRestOptions</code>.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.encryption_at_rest_options = input;
            self
        }
        /// <p>Specifies the status of the <code>NodeToNodeEncryptionOptions</code>.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            input: crate::model::NodeToNodeEncryptionOptions,
        ) -> Self {
            self.node_to_node_encryption_options = Some(input);
            self
        }
        /// <p>Specifies the status of the <code>NodeToNodeEncryptionOptions</code>.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.node_to_node_encryption_options = input;
            self
        }
        /// Adds a key-value pair to `advanced_options`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Specifies the status of the <code>AdvancedOptions</code></p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.advanced_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.advanced_options = Some(hash_map);
            self
        }
        /// <p>Specifies the status of the <code>AdvancedOptions</code></p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.advanced_options = input;
            self
        }
        /// Adds a key-value pair to `log_publishing_options`.
        ///
        /// To override the contents of this collection use [`set_log_publishing_options`](Self::set_log_publishing_options).
        ///
        /// <p>Log publishing options for the given domain.</p>
        pub fn log_publishing_options(
            mut self,
            k: crate::model::LogType,
            v: crate::model::LogPublishingOption,
        ) -> Self {
            let mut hash_map = self.log_publishing_options.unwrap_or_default();
            hash_map.insert(k, v);
            self.log_publishing_options = Some(hash_map);
            self
        }
        /// <p>Log publishing options for the given domain.</p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.log_publishing_options = input;
            self
        }
        /// <p>The current status of the Elasticsearch domain's service software.</p>
        pub fn service_software_options(
            mut self,
            input: crate::model::ServiceSoftwareOptions,
        ) -> Self {
            self.service_software_options = Some(input);
            self
        }
        /// <p>The current status of the Elasticsearch domain's service software.</p>
        pub fn set_service_software_options(
            mut self,
            input: std::option::Option<crate::model::ServiceSoftwareOptions>,
        ) -> Self {
            self.service_software_options = input;
            self
        }
        /// <p>The current status of the Elasticsearch domain's endpoint options.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptions,
        ) -> Self {
            self.domain_endpoint_options = Some(input);
            self
        }
        /// <p>The current status of the Elasticsearch domain's endpoint options.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.domain_endpoint_options = input;
            self
        }
        /// <p>The current status of the Elasticsearch domain's advanced security options.</p>
        pub fn advanced_security_options(
            mut self,
            input: crate::model::AdvancedSecurityOptions,
        ) -> Self {
            self.advanced_security_options = Some(input);
            self
        }
        /// <p>The current status of the Elasticsearch domain's advanced security options.</p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptions>,
        ) -> Self {
            self.advanced_security_options = input;
            self
        }
        /// <p>The current status of the Elasticsearch domain's Auto-Tune options.</p>
        pub fn auto_tune_options(mut self, input: crate::model::AutoTuneOptionsOutput) -> Self {
            self.auto_tune_options = Some(input);
            self
        }
        /// <p>The current status of the Elasticsearch domain's Auto-Tune options.</p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptionsOutput>,
        ) -> Self {
            self.auto_tune_options = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticsearchDomainStatus`](crate::model::ElasticsearchDomainStatus)
        pub fn build(self) -> crate::model::ElasticsearchDomainStatus {
            crate::model::ElasticsearchDomainStatus {
                domain_id: self.domain_id,
                domain_name: self.domain_name,
                arn: self.arn,
                created: self.created,
                deleted: self.deleted,
                endpoint: self.endpoint,
                endpoints: self.endpoints,
                processing: self.processing,
                upgrade_processing: self.upgrade_processing,
                elasticsearch_version: self.elasticsearch_version,
                elasticsearch_cluster_config: self.elasticsearch_cluster_config,
                ebs_options: self.ebs_options,
                access_policies: self.access_policies,
                snapshot_options: self.snapshot_options,
                vpc_options: self.vpc_options,
                cognito_options: self.cognito_options,
                encryption_at_rest_options: self.encryption_at_rest_options,
                node_to_node_encryption_options: self.node_to_node_encryption_options,
                advanced_options: self.advanced_options,
                log_publishing_options: self.log_publishing_options,
                service_software_options: self.service_software_options,
                domain_endpoint_options: self.domain_endpoint_options,
                advanced_security_options: self.advanced_security_options,
                auto_tune_options: self.auto_tune_options,
            }
        }
    }
}
impl ElasticsearchDomainStatus {
    /// Creates a new builder-style object to manufacture [`ElasticsearchDomainStatus`](crate::model::ElasticsearchDomainStatus)
    pub fn builder() -> crate::model::elasticsearch_domain_status::Builder {
        crate::model::elasticsearch_domain_status::Builder::default()
    }
}

/// <p>Specifies the Auto-Tune options: the Auto-Tune desired state for the domain and list of maintenance schedules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoTuneOptionsOutput {
    /// <p>Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.</p>
    pub state: std::option::Option<crate::model::AutoTuneState>,
    /// <p>Specifies the error message while enabling or disabling the Auto-Tune.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl AutoTuneOptionsOutput {
    /// <p>Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::AutoTuneState> {
        self.state.as_ref()
    }
    /// <p>Specifies the error message while enabling or disabling the Auto-Tune.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for AutoTuneOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoTuneOptionsOutput");
        formatter.field("state", &self.state);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`AutoTuneOptionsOutput`](crate::model::AutoTuneOptionsOutput)
pub mod auto_tune_options_output {
    /// A builder for [`AutoTuneOptionsOutput`](crate::model::AutoTuneOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::AutoTuneState>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.</p>
        pub fn state(mut self, input: crate::model::AutoTuneState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AutoTuneState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>Specifies the error message while enabling or disabling the Auto-Tune.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>Specifies the error message while enabling or disabling the Auto-Tune.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoTuneOptionsOutput`](crate::model::AutoTuneOptionsOutput)
        pub fn build(self) -> crate::model::AutoTuneOptionsOutput {
            crate::model::AutoTuneOptionsOutput {
                state: self.state,
                error_message: self.error_message,
            }
        }
    }
}
impl AutoTuneOptionsOutput {
    /// Creates a new builder-style object to manufacture [`AutoTuneOptionsOutput`](crate::model::AutoTuneOptionsOutput)
    pub fn builder() -> crate::model::auto_tune_options_output::Builder {
        crate::model::auto_tune_options_output::Builder::default()
    }
}

/// <p>Specifies Auto-Tune type and Auto-Tune action details. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoTune {
    /// <p>Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION. </p>
    pub auto_tune_type: std::option::Option<crate::model::AutoTuneType>,
    /// <p>Specifies details of the Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>
    pub auto_tune_details: std::option::Option<crate::model::AutoTuneDetails>,
}
impl AutoTune {
    /// <p>Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION. </p>
    pub fn auto_tune_type(&self) -> std::option::Option<&crate::model::AutoTuneType> {
        self.auto_tune_type.as_ref()
    }
    /// <p>Specifies details of the Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>
    pub fn auto_tune_details(&self) -> std::option::Option<&crate::model::AutoTuneDetails> {
        self.auto_tune_details.as_ref()
    }
}
impl std::fmt::Debug for AutoTune {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoTune");
        formatter.field("auto_tune_type", &self.auto_tune_type);
        formatter.field("auto_tune_details", &self.auto_tune_details);
        formatter.finish()
    }
}
/// See [`AutoTune`](crate::model::AutoTune)
pub mod auto_tune {
    /// A builder for [`AutoTune`](crate::model::AutoTune)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_tune_type: std::option::Option<crate::model::AutoTuneType>,
        pub(crate) auto_tune_details: std::option::Option<crate::model::AutoTuneDetails>,
    }
    impl Builder {
        /// <p>Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION. </p>
        pub fn auto_tune_type(mut self, input: crate::model::AutoTuneType) -> Self {
            self.auto_tune_type = Some(input);
            self
        }
        /// <p>Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION. </p>
        pub fn set_auto_tune_type(
            mut self,
            input: std::option::Option<crate::model::AutoTuneType>,
        ) -> Self {
            self.auto_tune_type = input;
            self
        }
        /// <p>Specifies details of the Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>
        pub fn auto_tune_details(mut self, input: crate::model::AutoTuneDetails) -> Self {
            self.auto_tune_details = Some(input);
            self
        }
        /// <p>Specifies details of the Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>
        pub fn set_auto_tune_details(
            mut self,
            input: std::option::Option<crate::model::AutoTuneDetails>,
        ) -> Self {
            self.auto_tune_details = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoTune`](crate::model::AutoTune)
        pub fn build(self) -> crate::model::AutoTune {
            crate::model::AutoTune {
                auto_tune_type: self.auto_tune_type,
                auto_tune_details: self.auto_tune_details,
            }
        }
    }
}
impl AutoTune {
    /// Creates a new builder-style object to manufacture [`AutoTune`](crate::model::AutoTune)
    pub fn builder() -> crate::model::auto_tune::Builder {
        crate::model::auto_tune::Builder::default()
    }
}

/// <p>Specifies details of the Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoTuneDetails {
    /// <p>Specifies details of the scheduled Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>
    pub scheduled_auto_tune_details: std::option::Option<crate::model::ScheduledAutoTuneDetails>,
}
impl AutoTuneDetails {
    /// <p>Specifies details of the scheduled Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>
    pub fn scheduled_auto_tune_details(
        &self,
    ) -> std::option::Option<&crate::model::ScheduledAutoTuneDetails> {
        self.scheduled_auto_tune_details.as_ref()
    }
}
impl std::fmt::Debug for AutoTuneDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoTuneDetails");
        formatter.field(
            "scheduled_auto_tune_details",
            &self.scheduled_auto_tune_details,
        );
        formatter.finish()
    }
}
/// See [`AutoTuneDetails`](crate::model::AutoTuneDetails)
pub mod auto_tune_details {
    /// A builder for [`AutoTuneDetails`](crate::model::AutoTuneDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_auto_tune_details:
            std::option::Option<crate::model::ScheduledAutoTuneDetails>,
    }
    impl Builder {
        /// <p>Specifies details of the scheduled Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>
        pub fn scheduled_auto_tune_details(
            mut self,
            input: crate::model::ScheduledAutoTuneDetails,
        ) -> Self {
            self.scheduled_auto_tune_details = Some(input);
            self
        }
        /// <p>Specifies details of the scheduled Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>
        pub fn set_scheduled_auto_tune_details(
            mut self,
            input: std::option::Option<crate::model::ScheduledAutoTuneDetails>,
        ) -> Self {
            self.scheduled_auto_tune_details = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoTuneDetails`](crate::model::AutoTuneDetails)
        pub fn build(self) -> crate::model::AutoTuneDetails {
            crate::model::AutoTuneDetails {
                scheduled_auto_tune_details: self.scheduled_auto_tune_details,
            }
        }
    }
}
impl AutoTuneDetails {
    /// Creates a new builder-style object to manufacture [`AutoTuneDetails`](crate::model::AutoTuneDetails)
    pub fn builder() -> crate::model::auto_tune_details::Builder {
        crate::model::auto_tune_details::Builder::default()
    }
}

/// <p>Specifies details of the scheduled Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledAutoTuneDetails {
    /// <p>Specifies timestamp for the Auto-Tune action scheduled for the domain. </p>
    pub date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING. </p>
    pub action_type: std::option::Option<crate::model::ScheduledAutoTuneActionType>,
    /// <p>Specifies Auto-Tune action description. </p>
    pub action: std::option::Option<std::string::String>,
    /// <p>Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH. </p>
    pub severity: std::option::Option<crate::model::ScheduledAutoTuneSeverityType>,
}
impl ScheduledAutoTuneDetails {
    /// <p>Specifies timestamp for the Auto-Tune action scheduled for the domain. </p>
    pub fn date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date.as_ref()
    }
    /// <p>Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING. </p>
    pub fn action_type(&self) -> std::option::Option<&crate::model::ScheduledAutoTuneActionType> {
        self.action_type.as_ref()
    }
    /// <p>Specifies Auto-Tune action description. </p>
    pub fn action(&self) -> std::option::Option<&str> {
        self.action.as_deref()
    }
    /// <p>Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH. </p>
    pub fn severity(&self) -> std::option::Option<&crate::model::ScheduledAutoTuneSeverityType> {
        self.severity.as_ref()
    }
}
impl std::fmt::Debug for ScheduledAutoTuneDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledAutoTuneDetails");
        formatter.field("date", &self.date);
        formatter.field("action_type", &self.action_type);
        formatter.field("action", &self.action);
        formatter.field("severity", &self.severity);
        formatter.finish()
    }
}
/// See [`ScheduledAutoTuneDetails`](crate::model::ScheduledAutoTuneDetails)
pub mod scheduled_auto_tune_details {
    /// A builder for [`ScheduledAutoTuneDetails`](crate::model::ScheduledAutoTuneDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) action_type: std::option::Option<crate::model::ScheduledAutoTuneActionType>,
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::ScheduledAutoTuneSeverityType>,
    }
    impl Builder {
        /// <p>Specifies timestamp for the Auto-Tune action scheduled for the domain. </p>
        pub fn date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>Specifies timestamp for the Auto-Tune action scheduled for the domain. </p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.date = input;
            self
        }
        /// <p>Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING. </p>
        pub fn action_type(mut self, input: crate::model::ScheduledAutoTuneActionType) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING. </p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ScheduledAutoTuneActionType>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// <p>Specifies Auto-Tune action description. </p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>Specifies Auto-Tune action description. </p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH. </p>
        pub fn severity(mut self, input: crate::model::ScheduledAutoTuneSeverityType) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH. </p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::ScheduledAutoTuneSeverityType>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledAutoTuneDetails`](crate::model::ScheduledAutoTuneDetails)
        pub fn build(self) -> crate::model::ScheduledAutoTuneDetails {
            crate::model::ScheduledAutoTuneDetails {
                date: self.date,
                action_type: self.action_type,
                action: self.action,
                severity: self.severity,
            }
        }
    }
}
impl ScheduledAutoTuneDetails {
    /// Creates a new builder-style object to manufacture [`ScheduledAutoTuneDetails`](crate::model::ScheduledAutoTuneDetails)
    pub fn builder() -> crate::model::scheduled_auto_tune_details::Builder {
        crate::model::scheduled_auto_tune_details::Builder::default()
    }
}

/// <p>Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH. </p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScheduledAutoTuneSeverityType {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScheduledAutoTuneSeverityType {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => ScheduledAutoTuneSeverityType::High,
            "LOW" => ScheduledAutoTuneSeverityType::Low,
            "MEDIUM" => ScheduledAutoTuneSeverityType::Medium,
            other => ScheduledAutoTuneSeverityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScheduledAutoTuneSeverityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScheduledAutoTuneSeverityType::from(s))
    }
}
impl ScheduledAutoTuneSeverityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScheduledAutoTuneSeverityType::High => "HIGH",
            ScheduledAutoTuneSeverityType::Low => "LOW",
            ScheduledAutoTuneSeverityType::Medium => "MEDIUM",
            ScheduledAutoTuneSeverityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM"]
    }
}
impl AsRef<str> for ScheduledAutoTuneSeverityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING. </p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScheduledAutoTuneActionType {
    #[allow(missing_docs)] // documentation missing in model
    JvmHeapSizeTuning,
    #[allow(missing_docs)] // documentation missing in model
    JvmYoungGenTuning,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScheduledAutoTuneActionType {
    fn from(s: &str) -> Self {
        match s {
            "JVM_HEAP_SIZE_TUNING" => ScheduledAutoTuneActionType::JvmHeapSizeTuning,
            "JVM_YOUNG_GEN_TUNING" => ScheduledAutoTuneActionType::JvmYoungGenTuning,
            other => ScheduledAutoTuneActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScheduledAutoTuneActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScheduledAutoTuneActionType::from(s))
    }
}
impl ScheduledAutoTuneActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScheduledAutoTuneActionType::JvmHeapSizeTuning => "JVM_HEAP_SIZE_TUNING",
            ScheduledAutoTuneActionType::JvmYoungGenTuning => "JVM_YOUNG_GEN_TUNING",
            ScheduledAutoTuneActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JVM_HEAP_SIZE_TUNING", "JVM_YOUNG_GEN_TUNING"]
    }
}
impl AsRef<str> for ScheduledAutoTuneActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION. </p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoTuneType {
    #[allow(missing_docs)] // documentation missing in model
    ScheduledAction,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoTuneType {
    fn from(s: &str) -> Self {
        match s {
            "SCHEDULED_ACTION" => AutoTuneType::ScheduledAction,
            other => AutoTuneType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoTuneType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoTuneType::from(s))
    }
}
impl AutoTuneType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoTuneType::ScheduledAction => "SCHEDULED_ACTION",
            AutoTuneType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SCHEDULED_ACTION"]
    }
}
impl AsRef<str> for AutoTuneType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the Auto-Tune options: the Auto-Tune desired state for the domain and list of maintenance schedules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoTuneOptionsInput {
    /// <p>Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED. </p>
    pub desired_state: std::option::Option<crate::model::AutoTuneDesiredState>,
    /// <p>Specifies list of maitenance schedules. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    pub maintenance_schedules:
        std::option::Option<std::vec::Vec<crate::model::AutoTuneMaintenanceSchedule>>,
}
impl AutoTuneOptionsInput {
    /// <p>Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED. </p>
    pub fn desired_state(&self) -> std::option::Option<&crate::model::AutoTuneDesiredState> {
        self.desired_state.as_ref()
    }
    /// <p>Specifies list of maitenance schedules. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    pub fn maintenance_schedules(
        &self,
    ) -> std::option::Option<&[crate::model::AutoTuneMaintenanceSchedule]> {
        self.maintenance_schedules.as_deref()
    }
}
impl std::fmt::Debug for AutoTuneOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoTuneOptionsInput");
        formatter.field("desired_state", &self.desired_state);
        formatter.field("maintenance_schedules", &self.maintenance_schedules);
        formatter.finish()
    }
}
/// See [`AutoTuneOptionsInput`](crate::model::AutoTuneOptionsInput)
pub mod auto_tune_options_input {
    /// A builder for [`AutoTuneOptionsInput`](crate::model::AutoTuneOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) desired_state: std::option::Option<crate::model::AutoTuneDesiredState>,
        pub(crate) maintenance_schedules:
            std::option::Option<std::vec::Vec<crate::model::AutoTuneMaintenanceSchedule>>,
    }
    impl Builder {
        /// <p>Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED. </p>
        pub fn desired_state(mut self, input: crate::model::AutoTuneDesiredState) -> Self {
            self.desired_state = Some(input);
            self
        }
        /// <p>Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED. </p>
        pub fn set_desired_state(
            mut self,
            input: std::option::Option<crate::model::AutoTuneDesiredState>,
        ) -> Self {
            self.desired_state = input;
            self
        }
        /// Appends an item to `maintenance_schedules`.
        ///
        /// To override the contents of this collection use [`set_maintenance_schedules`](Self::set_maintenance_schedules).
        ///
        /// <p>Specifies list of maitenance schedules. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn maintenance_schedules(
            mut self,
            input: crate::model::AutoTuneMaintenanceSchedule,
        ) -> Self {
            let mut v = self.maintenance_schedules.unwrap_or_default();
            v.push(input);
            self.maintenance_schedules = Some(v);
            self
        }
        /// <p>Specifies list of maitenance schedules. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn set_maintenance_schedules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoTuneMaintenanceSchedule>>,
        ) -> Self {
            self.maintenance_schedules = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoTuneOptionsInput`](crate::model::AutoTuneOptionsInput)
        pub fn build(self) -> crate::model::AutoTuneOptionsInput {
            crate::model::AutoTuneOptionsInput {
                desired_state: self.desired_state,
                maintenance_schedules: self.maintenance_schedules,
            }
        }
    }
}
impl AutoTuneOptionsInput {
    /// Creates a new builder-style object to manufacture [`AutoTuneOptionsInput`](crate::model::AutoTuneOptionsInput)
    pub fn builder() -> crate::model::auto_tune_options_input::Builder {
        crate::model::auto_tune_options_input::Builder::default()
    }
}
