// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP status code 409.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request processing has failed because of invalid pagination token provided by customer. Returns an HTTP status code of 400. </p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// <p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception for creating a resource that already exists. Gives http status code of 400.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception for missing / invalid input fields. Gives http status code of 400.</p>
    ValidationException(crate::error::ValidationException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::BaseException(inner) => inner.fmt(f),
            Error::ConflictException(inner) => inner.fmt(f),
            Error::DisabledOperationException(inner) => inner.fmt(f),
            Error::InternalException(inner) => inner.fmt(f),
            Error::InvalidPaginationTokenException(inner) => inner.fmt(f),
            Error::InvalidTypeException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::ResourceAlreadyExistsException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ValidationException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::AcceptInboundCrossClusterSearchConnectionError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AcceptInboundCrossClusterSearchConnectionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AcceptInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(inner) => Error::DisabledOperationException(inner),
                crate::error::AcceptInboundCrossClusterSearchConnectionErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::AcceptInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::AcceptInboundCrossClusterSearchConnectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AddTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddTagsErrorKind::BaseException(inner) => Error::BaseException(inner),
                crate::error::AddTagsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::AddTagsErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::AddTagsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::AddTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociatePackageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociatePackageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociatePackageErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::AssociatePackageErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::AssociatePackageErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::AssociatePackageErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::AssociatePackageErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::AssociatePackageErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::AssociatePackageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::CancelElasticsearchServiceSoftwareUpdateError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CancelElasticsearchServiceSoftwareUpdateError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CancelElasticsearchServiceSoftwareUpdateErrorKind::BaseException(inner) => Error::BaseException(inner),
                crate::error::CancelElasticsearchServiceSoftwareUpdateErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::CancelElasticsearchServiceSoftwareUpdateErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::CancelElasticsearchServiceSoftwareUpdateErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::CancelElasticsearchServiceSoftwareUpdateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateElasticsearchDomainError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateElasticsearchDomainError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateElasticsearchDomainErrorKind::BaseException(inner) => Error::BaseException(inner),
                crate::error::CreateElasticsearchDomainErrorKind::DisabledOperationException(inner) => Error::DisabledOperationException(inner),
                crate::error::CreateElasticsearchDomainErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::CreateElasticsearchDomainErrorKind::InvalidTypeException(inner) => Error::InvalidTypeException(inner),
                crate::error::CreateElasticsearchDomainErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::CreateElasticsearchDomainErrorKind::ResourceAlreadyExistsException(inner) => Error::ResourceAlreadyExistsException(inner),
                crate::error::CreateElasticsearchDomainErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::CreateElasticsearchDomainErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::CreateOutboundCrossClusterSearchConnectionError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateOutboundCrossClusterSearchConnectionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateOutboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(inner) => Error::DisabledOperationException(inner),
                crate::error::CreateOutboundCrossClusterSearchConnectionErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::CreateOutboundCrossClusterSearchConnectionErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::CreateOutboundCrossClusterSearchConnectionErrorKind::ResourceAlreadyExistsException(inner) => Error::ResourceAlreadyExistsException(inner),
                crate::error::CreateOutboundCrossClusterSearchConnectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreatePackageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreatePackageError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreatePackageErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreatePackageErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::CreatePackageErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::CreatePackageErrorKind::InvalidTypeException(inner) => {
                    Error::InvalidTypeException(inner)
                }
                crate::error::CreatePackageErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreatePackageErrorKind::ResourceAlreadyExistsException(inner) => {
                    Error::ResourceAlreadyExistsException(inner)
                }
                crate::error::CreatePackageErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::CreatePackageErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteElasticsearchDomainError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteElasticsearchDomainError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteElasticsearchDomainErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::DeleteElasticsearchDomainErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DeleteElasticsearchDomainErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteElasticsearchDomainErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DeleteElasticsearchDomainErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteElasticsearchServiceRoleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteElasticsearchServiceRoleError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteElasticsearchServiceRoleErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::DeleteElasticsearchServiceRoleErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DeleteElasticsearchServiceRoleErrorKind::ValidationException(
                    inner,
                ) => Error::ValidationException(inner),
                crate::error::DeleteElasticsearchServiceRoleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DeleteInboundCrossClusterSearchConnectionError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteInboundCrossClusterSearchConnectionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(inner) => Error::DisabledOperationException(inner),
                crate::error::DeleteInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteInboundCrossClusterSearchConnectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DeleteOutboundCrossClusterSearchConnectionError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteOutboundCrossClusterSearchConnectionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteOutboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(inner) => Error::DisabledOperationException(inner),
                crate::error::DeleteOutboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteOutboundCrossClusterSearchConnectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeletePackageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeletePackageError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeletePackageErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeletePackageErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::DeletePackageErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeletePackageErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DeletePackageErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeletePackageErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DeletePackageErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDomainAutoTunesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDomainAutoTunesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDomainAutoTunesErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::DescribeDomainAutoTunesErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DescribeDomainAutoTunesErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeDomainAutoTunesErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DescribeDomainAutoTunesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeElasticsearchDomainError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeElasticsearchDomainError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeElasticsearchDomainErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::DescribeElasticsearchDomainErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DescribeElasticsearchDomainErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeElasticsearchDomainErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DescribeElasticsearchDomainErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeElasticsearchDomainConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeElasticsearchDomainConfigError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeElasticsearchDomainConfigErrorKind::BaseException(inner) => Error::BaseException(inner),
                crate::error::DescribeElasticsearchDomainConfigErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::DescribeElasticsearchDomainConfigErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeElasticsearchDomainConfigErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::DescribeElasticsearchDomainConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeElasticsearchDomainsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeElasticsearchDomainsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeElasticsearchDomainsErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::DescribeElasticsearchDomainsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DescribeElasticsearchDomainsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DescribeElasticsearchDomainsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeElasticsearchInstanceTypeLimitsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeElasticsearchInstanceTypeLimitsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeElasticsearchInstanceTypeLimitsErrorKind::BaseException(inner) => Error::BaseException(inner),
                crate::error::DescribeElasticsearchInstanceTypeLimitsErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::DescribeElasticsearchInstanceTypeLimitsErrorKind::InvalidTypeException(inner) => Error::InvalidTypeException(inner),
                crate::error::DescribeElasticsearchInstanceTypeLimitsErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::DescribeElasticsearchInstanceTypeLimitsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeElasticsearchInstanceTypeLimitsErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::DescribeElasticsearchInstanceTypeLimitsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeInboundCrossClusterSearchConnectionsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeInboundCrossClusterSearchConnectionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeInboundCrossClusterSearchConnectionsErrorKind::DisabledOperationException(inner) => Error::DisabledOperationException(inner),
                crate::error::DescribeInboundCrossClusterSearchConnectionsErrorKind::InvalidPaginationTokenException(inner) => Error::InvalidPaginationTokenException(inner),
                crate::error::DescribeInboundCrossClusterSearchConnectionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeOutboundCrossClusterSearchConnectionsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeOutboundCrossClusterSearchConnectionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeOutboundCrossClusterSearchConnectionsErrorKind::DisabledOperationException(inner) => Error::DisabledOperationException(inner),
                crate::error::DescribeOutboundCrossClusterSearchConnectionsErrorKind::InvalidPaginationTokenException(inner) => Error::InvalidPaginationTokenException(inner),
                crate::error::DescribeOutboundCrossClusterSearchConnectionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribePackagesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribePackagesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribePackagesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribePackagesErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::DescribePackagesErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DescribePackagesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribePackagesErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DescribePackagesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeReservedElasticsearchInstanceOfferingsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeReservedElasticsearchInstanceOfferingsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeReservedElasticsearchInstanceOfferingsErrorKind::DisabledOperationException(inner) => Error::DisabledOperationException(inner),
                crate::error::DescribeReservedElasticsearchInstanceOfferingsErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::DescribeReservedElasticsearchInstanceOfferingsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeReservedElasticsearchInstanceOfferingsErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::DescribeReservedElasticsearchInstanceOfferingsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeReservedElasticsearchInstancesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeReservedElasticsearchInstancesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeReservedElasticsearchInstancesErrorKind::DisabledOperationException(inner) => Error::DisabledOperationException(inner),
                crate::error::DescribeReservedElasticsearchInstancesErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::DescribeReservedElasticsearchInstancesErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeReservedElasticsearchInstancesErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::DescribeReservedElasticsearchInstancesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DissociatePackageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DissociatePackageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DissociatePackageErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DissociatePackageErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::DissociatePackageErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DissociatePackageErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DissociatePackageErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DissociatePackageErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DissociatePackageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::GetCompatibleElasticsearchVersionsError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetCompatibleElasticsearchVersionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetCompatibleElasticsearchVersionsErrorKind::BaseException(inner) => Error::BaseException(inner),
                crate::error::GetCompatibleElasticsearchVersionsErrorKind::DisabledOperationException(inner) => Error::DisabledOperationException(inner),
                crate::error::GetCompatibleElasticsearchVersionsErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::GetCompatibleElasticsearchVersionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetCompatibleElasticsearchVersionsErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::GetCompatibleElasticsearchVersionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPackageVersionHistoryError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetPackageVersionHistoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPackageVersionHistoryErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetPackageVersionHistoryErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::GetPackageVersionHistoryErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::GetPackageVersionHistoryErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::GetPackageVersionHistoryErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetPackageVersionHistoryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetUpgradeHistoryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetUpgradeHistoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetUpgradeHistoryErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::GetUpgradeHistoryErrorKind::DisabledOperationException(inner) => {
                    Error::DisabledOperationException(inner)
                }
                crate::error::GetUpgradeHistoryErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::GetUpgradeHistoryErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetUpgradeHistoryErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetUpgradeHistoryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetUpgradeStatusError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetUpgradeStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetUpgradeStatusErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::GetUpgradeStatusErrorKind::DisabledOperationException(inner) => {
                    Error::DisabledOperationException(inner)
                }
                crate::error::GetUpgradeStatusErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::GetUpgradeStatusErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetUpgradeStatusErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetUpgradeStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDomainNamesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListDomainNamesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDomainNamesErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::ListDomainNamesErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListDomainNamesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDomainsForPackageError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDomainsForPackageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDomainsForPackageErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListDomainsForPackageErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::ListDomainsForPackageErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::ListDomainsForPackageErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListDomainsForPackageErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListDomainsForPackageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListElasticsearchInstanceTypesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListElasticsearchInstanceTypesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListElasticsearchInstanceTypesErrorKind::BaseException(inner) => Error::BaseException(inner),
                crate::error::ListElasticsearchInstanceTypesErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::ListElasticsearchInstanceTypesErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::ListElasticsearchInstanceTypesErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::ListElasticsearchInstanceTypesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListElasticsearchVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListElasticsearchVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListElasticsearchVersionsErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::ListElasticsearchVersionsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::ListElasticsearchVersionsErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::ListElasticsearchVersionsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListElasticsearchVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListPackagesForDomainError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListPackagesForDomainError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListPackagesForDomainErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListPackagesForDomainErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::ListPackagesForDomainErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::ListPackagesForDomainErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListPackagesForDomainErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListPackagesForDomainErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::ListTagsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::ListTagsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListTagsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::PurchaseReservedElasticsearchInstanceOfferingError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::PurchaseReservedElasticsearchInstanceOfferingError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PurchaseReservedElasticsearchInstanceOfferingErrorKind::DisabledOperationException(inner) => Error::DisabledOperationException(inner),
                crate::error::PurchaseReservedElasticsearchInstanceOfferingErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::PurchaseReservedElasticsearchInstanceOfferingErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::PurchaseReservedElasticsearchInstanceOfferingErrorKind::ResourceAlreadyExistsException(inner) => Error::ResourceAlreadyExistsException(inner),
                crate::error::PurchaseReservedElasticsearchInstanceOfferingErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::PurchaseReservedElasticsearchInstanceOfferingErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::PurchaseReservedElasticsearchInstanceOfferingErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::RejectInboundCrossClusterSearchConnectionError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RejectInboundCrossClusterSearchConnectionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RejectInboundCrossClusterSearchConnectionErrorKind::DisabledOperationException(inner) => Error::DisabledOperationException(inner),
                crate::error::RejectInboundCrossClusterSearchConnectionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::RejectInboundCrossClusterSearchConnectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RemoveTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveTagsErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::RemoveTagsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::RemoveTagsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::RemoveTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::StartElasticsearchServiceSoftwareUpdateError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::StartElasticsearchServiceSoftwareUpdateError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartElasticsearchServiceSoftwareUpdateErrorKind::BaseException(inner) => Error::BaseException(inner),
                crate::error::StartElasticsearchServiceSoftwareUpdateErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::StartElasticsearchServiceSoftwareUpdateErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::StartElasticsearchServiceSoftwareUpdateErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::StartElasticsearchServiceSoftwareUpdateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateElasticsearchDomainConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateElasticsearchDomainConfigError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateElasticsearchDomainConfigErrorKind::BaseException(inner) => Error::BaseException(inner),
                crate::error::UpdateElasticsearchDomainConfigErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::UpdateElasticsearchDomainConfigErrorKind::InvalidTypeException(inner) => Error::InvalidTypeException(inner),
                crate::error::UpdateElasticsearchDomainConfigErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::UpdateElasticsearchDomainConfigErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateElasticsearchDomainConfigErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::UpdateElasticsearchDomainConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdatePackageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdatePackageError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdatePackageErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdatePackageErrorKind::BaseException(inner) => {
                    Error::BaseException(inner)
                }
                crate::error::UpdatePackageErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::UpdatePackageErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdatePackageErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdatePackageErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::UpdatePackageErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpgradeElasticsearchDomainError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpgradeElasticsearchDomainError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpgradeElasticsearchDomainErrorKind::BaseException(inner) => Error::BaseException(inner),
                crate::error::UpgradeElasticsearchDomainErrorKind::DisabledOperationException(inner) => Error::DisabledOperationException(inner),
                crate::error::UpgradeElasticsearchDomainErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::UpgradeElasticsearchDomainErrorKind::ResourceAlreadyExistsException(inner) => Error::ResourceAlreadyExistsException(inner),
                crate::error::UpgradeElasticsearchDomainErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpgradeElasticsearchDomainErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::UpgradeElasticsearchDomainErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
