// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Elasticsearch Service
///
/// Client for invoking operations on Amazon Elasticsearch Service. Each operation on Amazon Elasticsearch Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_elasticsearch::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_elasticsearch::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_elasticsearch::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptInboundCrossClusterSearchConnection` operation.
    ///
    /// See [`AcceptInboundCrossClusterSearchConnection`](crate::client::fluent_builders::AcceptInboundCrossClusterSearchConnection) for more information about the
    /// operation and its arguments.
    pub fn accept_inbound_cross_cluster_search_connection(
        &self,
    ) -> fluent_builders::AcceptInboundCrossClusterSearchConnection<C, M, R> {
        fluent_builders::AcceptInboundCrossClusterSearchConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddTags` operation.
    ///
    /// See [`AddTags`](crate::client::fluent_builders::AddTags) for more information about the
    /// operation and its arguments.
    pub fn add_tags(&self) -> fluent_builders::AddTags<C, M, R> {
        fluent_builders::AddTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociatePackage` operation.
    ///
    /// See [`AssociatePackage`](crate::client::fluent_builders::AssociatePackage) for more information about the
    /// operation and its arguments.
    pub fn associate_package(&self) -> fluent_builders::AssociatePackage<C, M, R> {
        fluent_builders::AssociatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelElasticsearchServiceSoftwareUpdate` operation.
    ///
    /// See [`CancelElasticsearchServiceSoftwareUpdate`](crate::client::fluent_builders::CancelElasticsearchServiceSoftwareUpdate) for more information about the
    /// operation and its arguments.
    pub fn cancel_elasticsearch_service_software_update(
        &self,
    ) -> fluent_builders::CancelElasticsearchServiceSoftwareUpdate<C, M, R> {
        fluent_builders::CancelElasticsearchServiceSoftwareUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateElasticsearchDomain` operation.
    ///
    /// See [`CreateElasticsearchDomain`](crate::client::fluent_builders::CreateElasticsearchDomain) for more information about the
    /// operation and its arguments.
    pub fn create_elasticsearch_domain(
        &self,
    ) -> fluent_builders::CreateElasticsearchDomain<C, M, R> {
        fluent_builders::CreateElasticsearchDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateOutboundCrossClusterSearchConnection` operation.
    ///
    /// See [`CreateOutboundCrossClusterSearchConnection`](crate::client::fluent_builders::CreateOutboundCrossClusterSearchConnection) for more information about the
    /// operation and its arguments.
    pub fn create_outbound_cross_cluster_search_connection(
        &self,
    ) -> fluent_builders::CreateOutboundCrossClusterSearchConnection<C, M, R> {
        fluent_builders::CreateOutboundCrossClusterSearchConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePackage` operation.
    ///
    /// See [`CreatePackage`](crate::client::fluent_builders::CreatePackage) for more information about the
    /// operation and its arguments.
    pub fn create_package(&self) -> fluent_builders::CreatePackage<C, M, R> {
        fluent_builders::CreatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteElasticsearchDomain` operation.
    ///
    /// See [`DeleteElasticsearchDomain`](crate::client::fluent_builders::DeleteElasticsearchDomain) for more information about the
    /// operation and its arguments.
    pub fn delete_elasticsearch_domain(
        &self,
    ) -> fluent_builders::DeleteElasticsearchDomain<C, M, R> {
        fluent_builders::DeleteElasticsearchDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteElasticsearchServiceRole` operation.
    ///
    /// See [`DeleteElasticsearchServiceRole`](crate::client::fluent_builders::DeleteElasticsearchServiceRole) for more information about the
    /// operation and its arguments.
    pub fn delete_elasticsearch_service_role(
        &self,
    ) -> fluent_builders::DeleteElasticsearchServiceRole<C, M, R> {
        fluent_builders::DeleteElasticsearchServiceRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInboundCrossClusterSearchConnection` operation.
    ///
    /// See [`DeleteInboundCrossClusterSearchConnection`](crate::client::fluent_builders::DeleteInboundCrossClusterSearchConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_inbound_cross_cluster_search_connection(
        &self,
    ) -> fluent_builders::DeleteInboundCrossClusterSearchConnection<C, M, R> {
        fluent_builders::DeleteInboundCrossClusterSearchConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOutboundCrossClusterSearchConnection` operation.
    ///
    /// See [`DeleteOutboundCrossClusterSearchConnection`](crate::client::fluent_builders::DeleteOutboundCrossClusterSearchConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_outbound_cross_cluster_search_connection(
        &self,
    ) -> fluent_builders::DeleteOutboundCrossClusterSearchConnection<C, M, R> {
        fluent_builders::DeleteOutboundCrossClusterSearchConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePackage` operation.
    ///
    /// See [`DeletePackage`](crate::client::fluent_builders::DeletePackage) for more information about the
    /// operation and its arguments.
    pub fn delete_package(&self) -> fluent_builders::DeletePackage<C, M, R> {
        fluent_builders::DeletePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDomainAutoTunes` operation.
    ///
    /// See [`DescribeDomainAutoTunes`](crate::client::fluent_builders::DescribeDomainAutoTunes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeDomainAutoTunes::into_paginator).
    pub fn describe_domain_auto_tunes(&self) -> fluent_builders::DescribeDomainAutoTunes<C, M, R> {
        fluent_builders::DescribeDomainAutoTunes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeElasticsearchDomain` operation.
    ///
    /// See [`DescribeElasticsearchDomain`](crate::client::fluent_builders::DescribeElasticsearchDomain) for more information about the
    /// operation and its arguments.
    pub fn describe_elasticsearch_domain(
        &self,
    ) -> fluent_builders::DescribeElasticsearchDomain<C, M, R> {
        fluent_builders::DescribeElasticsearchDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeElasticsearchDomainConfig` operation.
    ///
    /// See [`DescribeElasticsearchDomainConfig`](crate::client::fluent_builders::DescribeElasticsearchDomainConfig) for more information about the
    /// operation and its arguments.
    pub fn describe_elasticsearch_domain_config(
        &self,
    ) -> fluent_builders::DescribeElasticsearchDomainConfig<C, M, R> {
        fluent_builders::DescribeElasticsearchDomainConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeElasticsearchDomains` operation.
    ///
    /// See [`DescribeElasticsearchDomains`](crate::client::fluent_builders::DescribeElasticsearchDomains) for more information about the
    /// operation and its arguments.
    pub fn describe_elasticsearch_domains(
        &self,
    ) -> fluent_builders::DescribeElasticsearchDomains<C, M, R> {
        fluent_builders::DescribeElasticsearchDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeElasticsearchInstanceTypeLimits` operation.
    ///
    /// See [`DescribeElasticsearchInstanceTypeLimits`](crate::client::fluent_builders::DescribeElasticsearchInstanceTypeLimits) for more information about the
    /// operation and its arguments.
    pub fn describe_elasticsearch_instance_type_limits(
        &self,
    ) -> fluent_builders::DescribeElasticsearchInstanceTypeLimits<C, M, R> {
        fluent_builders::DescribeElasticsearchInstanceTypeLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInboundCrossClusterSearchConnections` operation.
    ///
    /// See [`DescribeInboundCrossClusterSearchConnections`](crate::client::fluent_builders::DescribeInboundCrossClusterSearchConnections) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeInboundCrossClusterSearchConnections::into_paginator).
    pub fn describe_inbound_cross_cluster_search_connections(
        &self,
    ) -> fluent_builders::DescribeInboundCrossClusterSearchConnections<C, M, R> {
        fluent_builders::DescribeInboundCrossClusterSearchConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOutboundCrossClusterSearchConnections` operation.
    ///
    /// See [`DescribeOutboundCrossClusterSearchConnections`](crate::client::fluent_builders::DescribeOutboundCrossClusterSearchConnections) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeOutboundCrossClusterSearchConnections::into_paginator).
    pub fn describe_outbound_cross_cluster_search_connections(
        &self,
    ) -> fluent_builders::DescribeOutboundCrossClusterSearchConnections<C, M, R> {
        fluent_builders::DescribeOutboundCrossClusterSearchConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePackages` operation.
    ///
    /// See [`DescribePackages`](crate::client::fluent_builders::DescribePackages) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribePackages::into_paginator).
    pub fn describe_packages(&self) -> fluent_builders::DescribePackages<C, M, R> {
        fluent_builders::DescribePackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservedElasticsearchInstanceOfferings` operation.
    ///
    /// See [`DescribeReservedElasticsearchInstanceOfferings`](crate::client::fluent_builders::DescribeReservedElasticsearchInstanceOfferings) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedElasticsearchInstanceOfferings::into_paginator).
    pub fn describe_reserved_elasticsearch_instance_offerings(
        &self,
    ) -> fluent_builders::DescribeReservedElasticsearchInstanceOfferings<C, M, R> {
        fluent_builders::DescribeReservedElasticsearchInstanceOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservedElasticsearchInstances` operation.
    ///
    /// See [`DescribeReservedElasticsearchInstances`](crate::client::fluent_builders::DescribeReservedElasticsearchInstances) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedElasticsearchInstances::into_paginator).
    pub fn describe_reserved_elasticsearch_instances(
        &self,
    ) -> fluent_builders::DescribeReservedElasticsearchInstances<C, M, R> {
        fluent_builders::DescribeReservedElasticsearchInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DissociatePackage` operation.
    ///
    /// See [`DissociatePackage`](crate::client::fluent_builders::DissociatePackage) for more information about the
    /// operation and its arguments.
    pub fn dissociate_package(&self) -> fluent_builders::DissociatePackage<C, M, R> {
        fluent_builders::DissociatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCompatibleElasticsearchVersions` operation.
    ///
    /// See [`GetCompatibleElasticsearchVersions`](crate::client::fluent_builders::GetCompatibleElasticsearchVersions) for more information about the
    /// operation and its arguments.
    pub fn get_compatible_elasticsearch_versions(
        &self,
    ) -> fluent_builders::GetCompatibleElasticsearchVersions<C, M, R> {
        fluent_builders::GetCompatibleElasticsearchVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPackageVersionHistory` operation.
    ///
    /// See [`GetPackageVersionHistory`](crate::client::fluent_builders::GetPackageVersionHistory) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetPackageVersionHistory::into_paginator).
    pub fn get_package_version_history(
        &self,
    ) -> fluent_builders::GetPackageVersionHistory<C, M, R> {
        fluent_builders::GetPackageVersionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUpgradeHistory` operation.
    ///
    /// See [`GetUpgradeHistory`](crate::client::fluent_builders::GetUpgradeHistory) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetUpgradeHistory::into_paginator).
    pub fn get_upgrade_history(&self) -> fluent_builders::GetUpgradeHistory<C, M, R> {
        fluent_builders::GetUpgradeHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUpgradeStatus` operation.
    ///
    /// See [`GetUpgradeStatus`](crate::client::fluent_builders::GetUpgradeStatus) for more information about the
    /// operation and its arguments.
    pub fn get_upgrade_status(&self) -> fluent_builders::GetUpgradeStatus<C, M, R> {
        fluent_builders::GetUpgradeStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomainNames` operation.
    ///
    /// See [`ListDomainNames`](crate::client::fluent_builders::ListDomainNames) for more information about the
    /// operation and its arguments.
    pub fn list_domain_names(&self) -> fluent_builders::ListDomainNames<C, M, R> {
        fluent_builders::ListDomainNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomainsForPackage` operation.
    ///
    /// See [`ListDomainsForPackage`](crate::client::fluent_builders::ListDomainsForPackage) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDomainsForPackage::into_paginator).
    pub fn list_domains_for_package(&self) -> fluent_builders::ListDomainsForPackage<C, M, R> {
        fluent_builders::ListDomainsForPackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListElasticsearchInstanceTypes` operation.
    ///
    /// See [`ListElasticsearchInstanceTypes`](crate::client::fluent_builders::ListElasticsearchInstanceTypes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListElasticsearchInstanceTypes::into_paginator).
    pub fn list_elasticsearch_instance_types(
        &self,
    ) -> fluent_builders::ListElasticsearchInstanceTypes<C, M, R> {
        fluent_builders::ListElasticsearchInstanceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListElasticsearchVersions` operation.
    ///
    /// See [`ListElasticsearchVersions`](crate::client::fluent_builders::ListElasticsearchVersions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListElasticsearchVersions::into_paginator).
    pub fn list_elasticsearch_versions(
        &self,
    ) -> fluent_builders::ListElasticsearchVersions<C, M, R> {
        fluent_builders::ListElasticsearchVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPackagesForDomain` operation.
    ///
    /// See [`ListPackagesForDomain`](crate::client::fluent_builders::ListPackagesForDomain) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListPackagesForDomain::into_paginator).
    pub fn list_packages_for_domain(&self) -> fluent_builders::ListPackagesForDomain<C, M, R> {
        fluent_builders::ListPackagesForDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTags` operation.
    ///
    /// See [`ListTags`](crate::client::fluent_builders::ListTags) for more information about the
    /// operation and its arguments.
    pub fn list_tags(&self) -> fluent_builders::ListTags<C, M, R> {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PurchaseReservedElasticsearchInstanceOffering` operation.
    ///
    /// See [`PurchaseReservedElasticsearchInstanceOffering`](crate::client::fluent_builders::PurchaseReservedElasticsearchInstanceOffering) for more information about the
    /// operation and its arguments.
    pub fn purchase_reserved_elasticsearch_instance_offering(
        &self,
    ) -> fluent_builders::PurchaseReservedElasticsearchInstanceOffering<C, M, R> {
        fluent_builders::PurchaseReservedElasticsearchInstanceOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectInboundCrossClusterSearchConnection` operation.
    ///
    /// See [`RejectInboundCrossClusterSearchConnection`](crate::client::fluent_builders::RejectInboundCrossClusterSearchConnection) for more information about the
    /// operation and its arguments.
    pub fn reject_inbound_cross_cluster_search_connection(
        &self,
    ) -> fluent_builders::RejectInboundCrossClusterSearchConnection<C, M, R> {
        fluent_builders::RejectInboundCrossClusterSearchConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTags` operation.
    ///
    /// See [`RemoveTags`](crate::client::fluent_builders::RemoveTags) for more information about the
    /// operation and its arguments.
    pub fn remove_tags(&self) -> fluent_builders::RemoveTags<C, M, R> {
        fluent_builders::RemoveTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartElasticsearchServiceSoftwareUpdate` operation.
    ///
    /// See [`StartElasticsearchServiceSoftwareUpdate`](crate::client::fluent_builders::StartElasticsearchServiceSoftwareUpdate) for more information about the
    /// operation and its arguments.
    pub fn start_elasticsearch_service_software_update(
        &self,
    ) -> fluent_builders::StartElasticsearchServiceSoftwareUpdate<C, M, R> {
        fluent_builders::StartElasticsearchServiceSoftwareUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateElasticsearchDomainConfig` operation.
    ///
    /// See [`UpdateElasticsearchDomainConfig`](crate::client::fluent_builders::UpdateElasticsearchDomainConfig) for more information about the
    /// operation and its arguments.
    pub fn update_elasticsearch_domain_config(
        &self,
    ) -> fluent_builders::UpdateElasticsearchDomainConfig<C, M, R> {
        fluent_builders::UpdateElasticsearchDomainConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePackage` operation.
    ///
    /// See [`UpdatePackage`](crate::client::fluent_builders::UpdatePackage) for more information about the
    /// operation and its arguments.
    pub fn update_package(&self) -> fluent_builders::UpdatePackage<C, M, R> {
        fluent_builders::UpdatePackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpgradeElasticsearchDomain` operation.
    ///
    /// See [`UpgradeElasticsearchDomain`](crate::client::fluent_builders::UpgradeElasticsearchDomain) for more information about the
    /// operation and its arguments.
    pub fn upgrade_elasticsearch_domain(
        &self,
    ) -> fluent_builders::UpgradeElasticsearchDomain<C, M, R> {
        fluent_builders::UpgradeElasticsearchDomain::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptInboundCrossClusterSearchConnection`.
    ///
    /// <p>Allows the destination domain owner to accept an inbound cross-cluster search connection request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptInboundCrossClusterSearchConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_inbound_cross_cluster_search_connection_input::Builder,
    }
    impl<C, M, R> AcceptInboundCrossClusterSearchConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptInboundCrossClusterSearchConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptInboundCrossClusterSearchConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AcceptInboundCrossClusterSearchConnectionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptInboundCrossClusterSearchConnectionInputOperationOutputAlias,
                crate::output::AcceptInboundCrossClusterSearchConnectionOutput,
                crate::error::AcceptInboundCrossClusterSearchConnectionError,
                crate::input::AcceptInboundCrossClusterSearchConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The id of the inbound connection that you want to accept.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cross_cluster_search_connection_id(input.into());
            self
        }
        /// <p>The id of the inbound connection that you want to accept.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_cluster_search_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTags`.
    ///
    /// <p>Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An Elasticsearch domain may have up to 10 tags. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging" target="_blank"> Tagging Amazon Elasticsearch Service Domains for more information.</a></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_input::Builder,
    }
    impl<C, M, R> AddTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsInputOperationOutputAlias,
                crate::output::AddTagsOutput,
                crate::error::AddTagsError,
                crate::input::AddTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Specify the <code>ARN</code> for which you want to add the tags.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> Specify the <code>ARN</code> for which you want to add the tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p> List of <code>Tag</code> that need to be added for the Elasticsearch domain. </p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p> List of <code>Tag</code> that need to be added for the Elasticsearch domain. </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociatePackage`.
    ///
    /// <p>Associates a package with an Amazon ES domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociatePackage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_package_input::Builder,
    }
    impl<C, M, R> AssociatePackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociatePackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociatePackageInputOperationOutputAlias,
                crate::output::AssociatePackageOutput,
                crate::error::AssociatePackageError,
                crate::input::AssociatePackageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>Name of the domain that you want to associate the package with.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>Name of the domain that you want to associate the package with.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelElasticsearchServiceSoftwareUpdate`.
    ///
    /// <p>Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the <code>PENDING_UPDATE</code> state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelElasticsearchServiceSoftwareUpdate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_elasticsearch_service_software_update_input::Builder,
    }
    impl<C, M, R> CancelElasticsearchServiceSoftwareUpdate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelElasticsearchServiceSoftwareUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelElasticsearchServiceSoftwareUpdateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CancelElasticsearchServiceSoftwareUpdateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelElasticsearchServiceSoftwareUpdateInputOperationOutputAlias,
                crate::output::CancelElasticsearchServiceSoftwareUpdateOutput,
                crate::error::CancelElasticsearchServiceSoftwareUpdateError,
                crate::input::CancelElasticsearchServiceSoftwareUpdateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to stop the latest service software update on.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to stop the latest service software update on.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateElasticsearchDomain`.
    ///
    /// <p>Creates a new Elasticsearch domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateElasticsearchDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_elasticsearch_domain_input::Builder,
    }
    impl<C, M, R> CreateElasticsearchDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateElasticsearchDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateElasticsearchDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateElasticsearchDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateElasticsearchDomainInputOperationOutputAlias,
                crate::output::CreateElasticsearchDomainOutput,
                crate::error::CreateElasticsearchDomainError,
                crate::input::CreateElasticsearchDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Elasticsearch domain that you are creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the Elasticsearch domain that you are creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>String of format X.Y to specify version for the Elasticsearch domain eg. "1.5" or "2.3". For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>
        pub fn elasticsearch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.elasticsearch_version(input.into());
            self
        }
        /// <p>String of format X.Y to specify version for the Elasticsearch domain eg. "1.5" or "2.3". For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>
        pub fn set_elasticsearch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_version(input);
            self
        }
        /// <p>Configuration options for an Elasticsearch domain. Specifies the instance type and number of instances in the domain cluster. </p>
        pub fn elasticsearch_cluster_config(
            mut self,
            input: crate::model::ElasticsearchClusterConfig,
        ) -> Self {
            self.inner = self.inner.elasticsearch_cluster_config(input);
            self
        }
        /// <p>Configuration options for an Elasticsearch domain. Specifies the instance type and number of instances in the domain cluster. </p>
        pub fn set_elasticsearch_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchClusterConfig>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_cluster_config(input);
            self
        }
        /// <p>Options to enable, disable and specify the type and size of EBS storage volumes. </p>
        pub fn ebs_options(mut self, input: crate::model::EbsOptions) -> Self {
            self.inner = self.inner.ebs_options(input);
            self
        }
        /// <p>Options to enable, disable and specify the type and size of EBS storage volumes. </p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptions>,
        ) -> Self {
            self.inner = self.inner.set_ebs_options(input);
            self
        }
        /// <p> IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policies(input.into());
            self
        }
        /// <p> IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policies(input);
            self
        }
        /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours. </p>
        pub fn snapshot_options(mut self, input: crate::model::SnapshotOptions) -> Self {
            self.inner = self.inner.snapshot_options(input);
            self
        }
        /// <p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours. </p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
        pub fn vpc_options(mut self, input: crate::model::VpcOptions) -> Self {
            self.inner = self.inner.vpc_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcOptions>,
        ) -> Self {
            self.inner = self.inner.set_vpc_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn cognito_options(mut self, input: crate::model::CognitoOptions) -> Self {
            self.inner = self.inner.cognito_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.inner = self.inner.set_cognito_options(input);
            self
        }
        /// <p>Specifies the Encryption At Rest Options.</p>
        pub fn encryption_at_rest_options(
            mut self,
            input: crate::model::EncryptionAtRestOptions,
        ) -> Self {
            self.inner = self.inner.encryption_at_rest_options(input);
            self
        }
        /// <p>Specifies the Encryption At Rest Options.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.inner = self.inner.set_encryption_at_rest_options(input);
            self
        }
        /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            input: crate::model::NodeToNodeEncryptionOptions,
        ) -> Self {
            self.inner = self.inner.node_to_node_encryption_options(input);
            self
        }
        /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.inner = self.inner.set_node_to_node_encryption_options(input);
            self
        }
        /// Adds a key-value pair to `AdvancedOptions`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p> Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.advanced_options(k.into(), v.into());
            self
        }
        /// <p> Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_advanced_options(input);
            self
        }
        /// Adds a key-value pair to `LogPublishingOptions`.
        ///
        /// To override the contents of this collection use [`set_log_publishing_options`](Self::set_log_publishing_options).
        ///
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
        pub fn log_publishing_options(
            mut self,
            k: crate::model::LogType,
            v: crate::model::LogPublishingOption,
        ) -> Self {
            self.inner = self.inner.log_publishing_options(k, v);
            self
        }
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.inner = self.inner.set_log_publishing_options(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptions,
        ) -> Self {
            self.inner = self.inner.domain_endpoint_options(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.inner = self.inner.set_domain_endpoint_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn advanced_security_options(
            mut self,
            input: crate::model::AdvancedSecurityOptionsInput,
        ) -> Self {
            self.inner = self.inner.advanced_security_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        ) -> Self {
            self.inner = self.inner.set_advanced_security_options(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn auto_tune_options(mut self, input: crate::model::AutoTuneOptionsInput) -> Self {
            self.inner = self.inner.auto_tune_options(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptionsInput>,
        ) -> Self {
            self.inner = self.inner.set_auto_tune_options(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of <code>Tag</code> added during domain creation.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p>A list of <code>Tag</code> added during domain creation.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOutboundCrossClusterSearchConnection`.
    ///
    /// <p>Creates a new cross-cluster search connection from a source domain to a destination domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOutboundCrossClusterSearchConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_outbound_cross_cluster_search_connection_input::Builder,
    }
    impl<C, M, R> CreateOutboundCrossClusterSearchConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateOutboundCrossClusterSearchConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOutboundCrossClusterSearchConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateOutboundCrossClusterSearchConnectionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateOutboundCrossClusterSearchConnectionInputOperationOutputAlias,
                crate::output::CreateOutboundCrossClusterSearchConnectionOutput,
                crate::error::CreateOutboundCrossClusterSearchConnectionError,
                crate::input::CreateOutboundCrossClusterSearchConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
        pub fn source_domain_info(mut self, input: crate::model::DomainInformation) -> Self {
            self.inner = self.inner.source_domain_info(input);
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the source Elasticsearch domain.</p>
        pub fn set_source_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformation>,
        ) -> Self {
            self.inner = self.inner.set_source_domain_info(input);
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
        pub fn destination_domain_info(mut self, input: crate::model::DomainInformation) -> Self {
            self.inner = self.inner.destination_domain_info(input);
            self
        }
        /// <p>Specifies the <code><code>DomainInformation</code></code> for the destination Elasticsearch domain.</p>
        pub fn set_destination_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformation>,
        ) -> Self {
            self.inner = self.inner.set_destination_domain_info(input);
            self
        }
        /// <p>Specifies the connection alias that will be used by the customer for this connection.</p>
        pub fn connection_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_alias(input.into());
            self
        }
        /// <p>Specifies the connection alias that will be used by the customer for this connection.</p>
        pub fn set_connection_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePackage`.
    ///
    /// <p>Create a package for use with Amazon ES domains.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePackage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_package_input::Builder,
    }
    impl<C, M, R> CreatePackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePackageInputOperationOutputAlias,
                crate::output::CreatePackageOutput,
                crate::error::CreatePackageError,
                crate::input::CreatePackageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique identifier for the package.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_name(input.into());
            self
        }
        /// <p>Unique identifier for the package.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_name(input);
            self
        }
        /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.inner = self.inner.package_type(input);
            self
        }
        /// <p>Type of package. Currently supports only TXT-DICTIONARY.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.inner = self.inner.set_package_type(input);
            self
        }
        /// <p>Description of the package.</p>
        pub fn package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_description(input.into());
            self
        }
        /// <p>Description of the package.</p>
        pub fn set_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_description(input);
            self
        }
        /// <p>The customer S3 location <code>PackageSource</code> for importing the package.</p>
        pub fn package_source(mut self, input: crate::model::PackageSource) -> Self {
            self.inner = self.inner.package_source(input);
            self
        }
        /// <p>The customer S3 location <code>PackageSource</code> for importing the package.</p>
        pub fn set_package_source(
            mut self,
            input: std::option::Option<crate::model::PackageSource>,
        ) -> Self {
            self.inner = self.inner.set_package_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteElasticsearchDomain`.
    ///
    /// <p>Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot be recovered.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteElasticsearchDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_elasticsearch_domain_input::Builder,
    }
    impl<C, M, R> DeleteElasticsearchDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteElasticsearchDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteElasticsearchDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteElasticsearchDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteElasticsearchDomainInputOperationOutputAlias,
                crate::output::DeleteElasticsearchDomainOutput,
                crate::error::DeleteElasticsearchDomainError,
                crate::input::DeleteElasticsearchDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Elasticsearch domain that you want to permanently delete.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the Elasticsearch domain that you want to permanently delete.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteElasticsearchServiceRole`.
    ///
    /// <p>Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before deleting the role. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr" target="_blank">Deleting Elasticsearch Service Role</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteElasticsearchServiceRole<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_elasticsearch_service_role_input::Builder,
    }
    impl<C, M, R> DeleteElasticsearchServiceRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteElasticsearchServiceRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteElasticsearchServiceRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteElasticsearchServiceRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteElasticsearchServiceRoleInputOperationOutputAlias,
                crate::output::DeleteElasticsearchServiceRoleOutput,
                crate::error::DeleteElasticsearchServiceRoleError,
                crate::input::DeleteElasticsearchServiceRoleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteInboundCrossClusterSearchConnection`.
    ///
    /// <p>Allows the destination domain owner to delete an existing inbound cross-cluster search connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInboundCrossClusterSearchConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_inbound_cross_cluster_search_connection_input::Builder,
    }
    impl<C, M, R> DeleteInboundCrossClusterSearchConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInboundCrossClusterSearchConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInboundCrossClusterSearchConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteInboundCrossClusterSearchConnectionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInboundCrossClusterSearchConnectionInputOperationOutputAlias,
                crate::output::DeleteInboundCrossClusterSearchConnectionOutput,
                crate::error::DeleteInboundCrossClusterSearchConnectionError,
                crate::input::DeleteInboundCrossClusterSearchConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The id of the inbound connection that you want to permanently delete.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cross_cluster_search_connection_id(input.into());
            self
        }
        /// <p>The id of the inbound connection that you want to permanently delete.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_cluster_search_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOutboundCrossClusterSearchConnection`.
    ///
    /// <p>Allows the source domain owner to delete an existing outbound cross-cluster search connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOutboundCrossClusterSearchConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_outbound_cross_cluster_search_connection_input::Builder,
    }
    impl<C, M, R> DeleteOutboundCrossClusterSearchConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOutboundCrossClusterSearchConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOutboundCrossClusterSearchConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteOutboundCrossClusterSearchConnectionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOutboundCrossClusterSearchConnectionInputOperationOutputAlias,
                crate::output::DeleteOutboundCrossClusterSearchConnectionOutput,
                crate::error::DeleteOutboundCrossClusterSearchConnectionError,
                crate::input::DeleteOutboundCrossClusterSearchConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The id of the outbound connection that you want to permanently delete.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cross_cluster_search_connection_id(input.into());
            self
        }
        /// <p>The id of the outbound connection that you want to permanently delete.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_cluster_search_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePackage`.
    ///
    /// <p>Delete the package.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePackage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_package_input::Builder,
    }
    impl<C, M, R> DeletePackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePackageInputOperationOutputAlias,
                crate::output::DeletePackageOutput,
                crate::error::DeletePackageError,
                crate::input::DeletePackageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this value.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this value.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomainAutoTunes`.
    ///
    /// <p>Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type, description, severity, and scheduled date.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomainAutoTunes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_auto_tunes_input::Builder,
    }
    impl<C, M, R> DescribeDomainAutoTunes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomainAutoTunes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainAutoTunesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainAutoTunesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainAutoTunesInputOperationOutputAlias,
                crate::output::DescribeDomainAutoTunesOutput,
                crate::error::DescribeDomainAutoTunesError,
                crate::input::DescribeDomainAutoTunesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDomainAutoTunesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDomainAutoTunesPaginator<C, M, R> {
            crate::paginator::DescribeDomainAutoTunesPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the domain name for which you want Auto-Tune action details.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>Specifies the domain name for which you want Auto-Tune action details.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeElasticsearchDomain`.
    ///
    /// <p>Returns domain configuration information about the specified Elasticsearch domain, including the domain ID, domain endpoint, and domain ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeElasticsearchDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_elasticsearch_domain_input::Builder,
    }
    impl<C, M, R> DescribeElasticsearchDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeElasticsearchDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeElasticsearchDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeElasticsearchDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeElasticsearchDomainInputOperationOutputAlias,
                crate::output::DescribeElasticsearchDomainOutput,
                crate::error::DescribeElasticsearchDomainError,
                crate::input::DescribeElasticsearchDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Elasticsearch domain for which you want information.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the Elasticsearch domain for which you want information.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeElasticsearchDomainConfig`.
    ///
    /// <p>Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation date, update version, and update date for cluster options.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeElasticsearchDomainConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_elasticsearch_domain_config_input::Builder,
    }
    impl<C, M, R> DescribeElasticsearchDomainConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeElasticsearchDomainConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeElasticsearchDomainConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeElasticsearchDomainConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeElasticsearchDomainConfigInputOperationOutputAlias,
                crate::output::DescribeElasticsearchDomainConfigOutput,
                crate::error::DescribeElasticsearchDomainConfigError,
                crate::input::DescribeElasticsearchDomainConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Elasticsearch domain that you want to get information about.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The Elasticsearch domain that you want to get information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeElasticsearchDomains`.
    ///
    /// <p>Returns domain configuration information about the specified Elasticsearch domains, including the domain ID, domain endpoint, and domain ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeElasticsearchDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_elasticsearch_domains_input::Builder,
    }
    impl<C, M, R> DescribeElasticsearchDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeElasticsearchDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeElasticsearchDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeElasticsearchDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeElasticsearchDomainsInputOperationOutputAlias,
                crate::output::DescribeElasticsearchDomainsOutput,
                crate::error::DescribeElasticsearchDomainsError,
                crate::input::DescribeElasticsearchDomainsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DomainNames`.
        ///
        /// To override the contents of this collection use [`set_domain_names`](Self::set_domain_names).
        ///
        /// <p>The Elasticsearch domains for which you want information.</p>
        pub fn domain_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_names(input.into());
            self
        }
        /// <p>The Elasticsearch domains for which you want information.</p>
        pub fn set_domain_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_domain_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeElasticsearchInstanceTypeLimits`.
    ///
    /// <p> Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain, specify the <code> <code>DomainName</code> </code> to know what Limits are supported for modifying. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeElasticsearchInstanceTypeLimits<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_elasticsearch_instance_type_limits_input::Builder,
    }
    impl<C, M, R> DescribeElasticsearchInstanceTypeLimits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeElasticsearchInstanceTypeLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeElasticsearchInstanceTypeLimitsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeElasticsearchInstanceTypeLimitsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeElasticsearchInstanceTypeLimitsInputOperationOutputAlias,
                crate::output::DescribeElasticsearchInstanceTypeLimitsOutput,
                crate::error::DescribeElasticsearchInstanceTypeLimitsError,
                crate::input::DescribeElasticsearchInstanceTypeLimitsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for Elasticsearch <code> <code>Limits</code> </code> for existing domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p> DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for Elasticsearch <code> <code>Limits</code> </code> for existing domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> The instance type for an Elasticsearch cluster for which Elasticsearch <code> <code>Limits</code> </code> are needed. </p>
        pub fn instance_type(mut self, input: crate::model::EsPartitionInstanceType) -> Self {
            self.inner = self.inner.instance_type(input);
            self
        }
        /// <p> The instance type for an Elasticsearch cluster for which Elasticsearch <code> <code>Limits</code> </code> are needed. </p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::EsPartitionInstanceType>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p> Version of Elasticsearch for which <code> <code>Limits</code> </code> are needed. </p>
        pub fn elasticsearch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.elasticsearch_version(input.into());
            self
        }
        /// <p> Version of Elasticsearch for which <code> <code>Limits</code> </code> are needed. </p>
        pub fn set_elasticsearch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInboundCrossClusterSearchConnections`.
    ///
    /// <p>Lists all the inbound cross-cluster search connections for a destination domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInboundCrossClusterSearchConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_inbound_cross_cluster_search_connections_input::Builder,
    }
    impl<C, M, R> DescribeInboundCrossClusterSearchConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInboundCrossClusterSearchConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInboundCrossClusterSearchConnectionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeInboundCrossClusterSearchConnectionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInboundCrossClusterSearchConnectionsInputOperationOutputAlias,
                crate::output::DescribeInboundCrossClusterSearchConnectionsOutput,
                crate::error::DescribeInboundCrossClusterSearchConnectionsError,
                crate::input::DescribeInboundCrossClusterSearchConnectionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeInboundCrossClusterSearchConnectionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeInboundCrossClusterSearchConnectionsPaginator<C, M, R>
        {
            crate::paginator::DescribeInboundCrossClusterSearchConnectionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p> A list of filters used to match properties for inbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
        /// <ul>
        /// <li>cross-cluster-search-connection-id</li>
        /// <li>source-domain-info.domain-name</li>
        /// <li>source-domain-info.owner-id</li>
        /// <li>source-domain-info.region</li>
        /// <li>destination-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p> A list of filters used to match properties for inbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
        /// <ul>
        /// <li>cross-cluster-search-connection-id</li>
        /// <li>source-domain-info.domain-name</li>
        /// <li>source-domain-info.owner-id</li>
        /// <li>source-domain-info.region</li>
        /// <li>destination-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOutboundCrossClusterSearchConnections`.
    ///
    /// <p>Lists all the outbound cross-cluster search connections for a source domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOutboundCrossClusterSearchConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_outbound_cross_cluster_search_connections_input::Builder,
    }
    impl<C, M, R> DescribeOutboundCrossClusterSearchConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOutboundCrossClusterSearchConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DescribeOutboundCrossClusterSearchConnectionsOutput, aws_smithy_http::result::SdkError<crate::error::DescribeOutboundCrossClusterSearchConnectionsError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DescribeOutboundCrossClusterSearchConnectionsInputOperationOutputAlias,
                                    crate::output::DescribeOutboundCrossClusterSearchConnectionsOutput,
                                    crate::error::DescribeOutboundCrossClusterSearchConnectionsError,
                                    crate::input::DescribeOutboundCrossClusterSearchConnectionsInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOutboundCrossClusterSearchConnectionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeOutboundCrossClusterSearchConnectionsPaginator<C, M, R>
        {
            crate::paginator::DescribeOutboundCrossClusterSearchConnectionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p> A list of filters used to match properties for outbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
        /// <ul>
        /// <li>cross-cluster-search-connection-id</li>
        /// <li>destination-domain-info.domain-name</li>
        /// <li>destination-domain-info.owner-id</li>
        /// <li>destination-domain-info.region</li>
        /// <li>source-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p> A list of filters used to match properties for outbound cross-cluster search connection. Available <code><code>Filter</code></code> names for this operation are: </p>
        /// <ul>
        /// <li>cross-cluster-search-connection-id</li>
        /// <li>destination-domain-info.domain-name</li>
        /// <li>destination-domain-info.owner-id</li>
        /// <li>destination-domain-info.region</li>
        /// <li>source-domain-info.domain-name</li>
        /// </ul>
        /// <p></p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePackages`.
    ///
    /// <p>Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results, and pagination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePackages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_packages_input::Builder,
    }
    impl<C, M, R> DescribePackages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePackages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePackagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePackagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePackagesInputOperationOutputAlias,
                crate::output::DescribePackagesOutput,
                crate::error::DescribePackagesError,
                crate::input::DescribePackagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePackagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribePackagesPaginator<C, M, R> {
            crate::paginator::DescribePackagesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values.</p>
        pub fn filters(mut self, input: crate::model::DescribePackagesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Only returns packages that match the <code>DescribePackagesFilterList</code> values.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DescribePackagesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedElasticsearchInstanceOfferings`.
    ///
    /// <p>Lists available reserved Elasticsearch instance offerings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReservedElasticsearchInstanceOfferings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_reserved_elasticsearch_instance_offerings_input::Builder,
    }
    impl<C, M, R> DescribeReservedElasticsearchInstanceOfferings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReservedElasticsearchInstanceOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DescribeReservedElasticsearchInstanceOfferingsOutput, aws_smithy_http::result::SdkError<crate::error::DescribeReservedElasticsearchInstanceOfferingsError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DescribeReservedElasticsearchInstanceOfferingsInputOperationOutputAlias,
                                    crate::output::DescribeReservedElasticsearchInstanceOfferingsOutput,
                                    crate::error::DescribeReservedElasticsearchInstanceOfferingsError,
                                    crate::input::DescribeReservedElasticsearchInstanceOfferingsInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReservedElasticsearchInstanceOfferingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReservedElasticsearchInstanceOfferingsPaginator<C, M, R>
        {
            crate::paginator::DescribeReservedElasticsearchInstanceOfferingsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
        pub fn reserved_elasticsearch_instance_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .reserved_elasticsearch_instance_offering_id(input.into());
            self
        }
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
        pub fn set_reserved_elasticsearch_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_reserved_elasticsearch_instance_offering_id(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedElasticsearchInstances`.
    ///
    /// <p>Returns information about reserved Elasticsearch instances for this account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReservedElasticsearchInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_reserved_elasticsearch_instances_input::Builder,
    }
    impl<C, M, R> DescribeReservedElasticsearchInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReservedElasticsearchInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedElasticsearchInstancesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReservedElasticsearchInstancesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReservedElasticsearchInstancesInputOperationOutputAlias,
                crate::output::DescribeReservedElasticsearchInstancesOutput,
                crate::error::DescribeReservedElasticsearchInstancesError,
                crate::input::DescribeReservedElasticsearchInstancesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReservedElasticsearchInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReservedElasticsearchInstancesPaginator<C, M, R> {
            crate::paginator::DescribeReservedElasticsearchInstancesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved Elasticsearch instance ID.</p>
        pub fn reserved_elasticsearch_instance_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.reserved_elasticsearch_instance_id(input.into());
            self
        }
        /// <p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved Elasticsearch instance ID.</p>
        pub fn set_reserved_elasticsearch_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_elasticsearch_instance_id(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DissociatePackage`.
    ///
    /// <p>Dissociates a package from the Amazon ES domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DissociatePackage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::dissociate_package_input::Builder,
    }
    impl<C, M, R> DissociatePackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DissociatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DissociatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::DissociatePackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DissociatePackageInputOperationOutputAlias,
                crate::output::DissociatePackageOutput,
                crate::error::DissociatePackageError,
                crate::input::DissociatePackageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>Name of the domain that you want to associate the package with.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>Name of the domain that you want to associate the package with.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCompatibleElasticsearchVersions`.
    ///
    /// <p> Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a <code> <code>DomainName</code> </code> to get all upgrade compatible Elasticsearch versions for that specific domain. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCompatibleElasticsearchVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_compatible_elasticsearch_versions_input::Builder,
    }
    impl<C, M, R> GetCompatibleElasticsearchVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCompatibleElasticsearchVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCompatibleElasticsearchVersionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetCompatibleElasticsearchVersionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCompatibleElasticsearchVersionsInputOperationOutputAlias,
                crate::output::GetCompatibleElasticsearchVersionsOutput,
                crate::error::GetCompatibleElasticsearchVersionsError,
                crate::input::GetCompatibleElasticsearchVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPackageVersionHistory`.
    ///
    /// <p>Returns a list of versions of the package, along with their creation time and commit message.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPackageVersionHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_package_version_history_input::Builder,
    }
    impl<C, M, R> GetPackageVersionHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPackageVersionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPackageVersionHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPackageVersionHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPackageVersionHistoryInputOperationOutputAlias,
                crate::output::GetPackageVersionHistoryOutput,
                crate::error::GetPackageVersionHistoryError,
                crate::input::GetPackageVersionHistoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetPackageVersionHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetPackageVersionHistoryPaginator<C, M, R> {
            crate::paginator::GetPackageVersionHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>Returns an audit history of versions of the package.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>Returns an audit history of versions of the package.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>Limits results to a maximum number of versions.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits results to a maximum number of versions.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUpgradeHistory`.
    ///
    /// <p>Retrieves the complete history of the last 10 upgrades that were performed on the domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUpgradeHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_upgrade_history_input::Builder,
    }
    impl<C, M, R> GetUpgradeHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUpgradeHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUpgradeHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUpgradeHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUpgradeHistoryInputOperationOutputAlias,
                crate::output::GetUpgradeHistoryOutput,
                crate::error::GetUpgradeHistoryError,
                crate::input::GetUpgradeHistoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetUpgradeHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetUpgradeHistoryPaginator<C, M, R> {
            crate::paginator::GetUpgradeHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUpgradeStatus`.
    ///
    /// <p>Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUpgradeStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_upgrade_status_input::Builder,
    }
    impl<C, M, R> GetUpgradeStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUpgradeStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUpgradeStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUpgradeStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUpgradeStatusInputOperationOutputAlias,
                crate::output::GetUpgradeStatusOutput,
                crate::error::GetUpgradeStatusError,
                crate::input::GetUpgradeStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainNames`.
    ///
    /// <p>Returns the name of all Elasticsearch domains owned by the current user's account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomainNames<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domain_names_input::Builder,
    }
    impl<C, M, R> ListDomainNames<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomainNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainNamesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainNamesInputOperationOutputAlias,
                crate::output::ListDomainNamesOutput,
                crate::error::ListDomainNamesError,
                crate::input::ListDomainNamesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.inner = self.inner.engine_type(input);
            self
        }
        /// <p> Optional parameter to filter the output by domain engine type. Acceptable values are 'Elasticsearch' and 'OpenSearch'. </p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.inner = self.inner.set_engine_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainsForPackage`.
    ///
    /// <p>Lists all Amazon ES domains associated with the package.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomainsForPackage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domains_for_package_input::Builder,
    }
    impl<C, M, R> ListDomainsForPackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomainsForPackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsForPackageOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsForPackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainsForPackageInputOperationOutputAlias,
                crate::output::ListDomainsForPackageOutput,
                crate::error::ListDomainsForPackageError,
                crate::input::ListDomainsForPackageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDomainsForPackagePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDomainsForPackagePaginator<C, M, R> {
            crate::paginator::ListDomainsForPackagePaginator::new(self.handle, self.inner)
        }
        /// <p>The package for which to list domains.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>The package for which to list domains.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>Limits results to a maximum number of domains.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits results to a maximum number of domains.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListElasticsearchInstanceTypes`.
    ///
    /// <p>List all Elasticsearch instance types that are supported for given ElasticsearchVersion</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListElasticsearchInstanceTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_elasticsearch_instance_types_input::Builder,
    }
    impl<C, M, R> ListElasticsearchInstanceTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListElasticsearchInstanceTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListElasticsearchInstanceTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListElasticsearchInstanceTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListElasticsearchInstanceTypesInputOperationOutputAlias,
                crate::output::ListElasticsearchInstanceTypesOutput,
                crate::error::ListElasticsearchInstanceTypesError,
                crate::input::ListElasticsearchInstanceTypesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListElasticsearchInstanceTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListElasticsearchInstanceTypesPaginator<C, M, R> {
            crate::paginator::ListElasticsearchInstanceTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>Version of Elasticsearch for which list of supported elasticsearch instance types are needed. </p>
        pub fn elasticsearch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.elasticsearch_version(input.into());
            self
        }
        /// <p>Version of Elasticsearch for which list of supported elasticsearch instance types are needed. </p>
        pub fn set_elasticsearch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_version(input);
            self
        }
        /// <p>DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for list of available Elasticsearch instance types when modifying existing domain. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for list of available Elasticsearch instance types when modifying existing domain. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont be honored. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont be honored. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListElasticsearchVersions`.
    ///
    /// <p>List all supported Elasticsearch versions</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListElasticsearchVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_elasticsearch_versions_input::Builder,
    }
    impl<C, M, R> ListElasticsearchVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListElasticsearchVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListElasticsearchVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListElasticsearchVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListElasticsearchVersionsInputOperationOutputAlias,
                crate::output::ListElasticsearchVersionsOutput,
                crate::error::ListElasticsearchVersionsError,
                crate::input::ListElasticsearchVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListElasticsearchVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListElasticsearchVersionsPaginator<C, M, R> {
            crate::paginator::ListElasticsearchVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p> Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackagesForDomain`.
    ///
    /// <p>Lists all packages associated with the Amazon ES domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPackagesForDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_packages_for_domain_input::Builder,
    }
    impl<C, M, R> ListPackagesForDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPackagesForDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackagesForDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackagesForDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPackagesForDomainInputOperationOutputAlias,
                crate::output::ListPackagesForDomainOutput,
                crate::error::ListPackagesForDomainError,
                crate::input::ListPackagesForDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPackagesForDomainPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPackagesForDomainPaginator<C, M, R> {
            crate::paginator::ListPackagesForDomainPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the domain for which you want to list associated packages.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain for which you want to list associated packages.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits results to a maximum number of packages.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Returns all tags for the given Elasticsearch domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl<C, M, R> ListTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsInputOperationOutputAlias,
                crate::output::ListTagsOutput,
                crate::error::ListTagsError,
                crate::input::ListTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PurchaseReservedElasticsearchInstanceOffering`.
    ///
    /// <p>Allows you to purchase reserved Elasticsearch instances.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PurchaseReservedElasticsearchInstanceOffering<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::purchase_reserved_elasticsearch_instance_offering_input::Builder,
    }
    impl<C, M, R> PurchaseReservedElasticsearchInstanceOffering<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PurchaseReservedElasticsearchInstanceOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::PurchaseReservedElasticsearchInstanceOfferingOutput, aws_smithy_http::result::SdkError<crate::error::PurchaseReservedElasticsearchInstanceOfferingError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::PurchaseReservedElasticsearchInstanceOfferingInputOperationOutputAlias,
                                    crate::output::PurchaseReservedElasticsearchInstanceOfferingOutput,
                                    crate::error::PurchaseReservedElasticsearchInstanceOfferingError,
                                    crate::input::PurchaseReservedElasticsearchInstanceOfferingInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the reserved Elasticsearch instance offering to purchase.</p>
        pub fn reserved_elasticsearch_instance_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .reserved_elasticsearch_instance_offering_id(input.into());
            self
        }
        /// <p>The ID of the reserved Elasticsearch instance offering to purchase.</p>
        pub fn set_reserved_elasticsearch_instance_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_reserved_elasticsearch_instance_offering_id(input);
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p>
        pub fn reservation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reservation_name(input.into());
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p>
        pub fn set_reservation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reservation_name(input);
            self
        }
        /// <p>The number of Elasticsearch instances to reserve.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.inner = self.inner.instance_count(input);
            self
        }
        /// <p>The number of Elasticsearch instances to reserve.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_instance_count(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectInboundCrossClusterSearchConnection`.
    ///
    /// <p>Allows the destination domain owner to reject an inbound cross-cluster search connection request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectInboundCrossClusterSearchConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_inbound_cross_cluster_search_connection_input::Builder,
    }
    impl<C, M, R> RejectInboundCrossClusterSearchConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectInboundCrossClusterSearchConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectInboundCrossClusterSearchConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RejectInboundCrossClusterSearchConnectionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectInboundCrossClusterSearchConnectionInputOperationOutputAlias,
                crate::output::RejectInboundCrossClusterSearchConnectionOutput,
                crate::error::RejectInboundCrossClusterSearchConnectionError,
                crate::input::RejectInboundCrossClusterSearchConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The id of the inbound connection that you want to reject.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cross_cluster_search_connection_id(input.into());
            self
        }
        /// <p>The id of the inbound connection that you want to reject.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_cluster_search_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTags`.
    ///
    /// <p>Removes the specified set of tags from the specified Elasticsearch domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_input::Builder,
    }
    impl<C, M, R> RemoveTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsInputOperationOutputAlias,
                crate::output::RemoveTagsOutput,
                crate::error::RemoveTagsError,
                crate::input::RemoveTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <code>ARN</code> for the Elasticsearch domain from which you want to delete the specified tags.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>Specifies the <code>ARN</code> for the Elasticsearch domain from which you want to delete the specified tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Specifies the <code>TagKey</code> list which you want to remove from the Elasticsearch domain.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Specifies the <code>TagKey</code> list which you want to remove from the Elasticsearch domain.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartElasticsearchServiceSoftwareUpdate`.
    ///
    /// <p>Schedules a service software update for an Amazon ES domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartElasticsearchServiceSoftwareUpdate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_elasticsearch_service_software_update_input::Builder,
    }
    impl<C, M, R> StartElasticsearchServiceSoftwareUpdate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartElasticsearchServiceSoftwareUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartElasticsearchServiceSoftwareUpdateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::StartElasticsearchServiceSoftwareUpdateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartElasticsearchServiceSoftwareUpdateInputOperationOutputAlias,
                crate::output::StartElasticsearchServiceSoftwareUpdateOutput,
                crate::error::StartElasticsearchServiceSoftwareUpdateError,
                crate::input::StartElasticsearchServiceSoftwareUpdateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to update to the latest service software.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to update to the latest service software.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateElasticsearchDomainConfig`.
    ///
    /// <p>Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type and the number of instances. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateElasticsearchDomainConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_elasticsearch_domain_config_input::Builder,
    }
    impl<C, M, R> UpdateElasticsearchDomainConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateElasticsearchDomainConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateElasticsearchDomainConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateElasticsearchDomainConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateElasticsearchDomainConfigInputOperationOutputAlias,
                crate::output::UpdateElasticsearchDomainConfigOutput,
                crate::error::UpdateElasticsearchDomainConfigError,
                crate::input::UpdateElasticsearchDomainConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Elasticsearch domain that you are updating. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the Elasticsearch domain that you are updating. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The type and number of instances to instantiate for the domain cluster.</p>
        pub fn elasticsearch_cluster_config(
            mut self,
            input: crate::model::ElasticsearchClusterConfig,
        ) -> Self {
            self.inner = self.inner.elasticsearch_cluster_config(input);
            self
        }
        /// <p>The type and number of instances to instantiate for the domain cluster.</p>
        pub fn set_elasticsearch_cluster_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchClusterConfig>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_cluster_config(input);
            self
        }
        /// <p>Specify the type and size of the EBS volume that you want to use. </p>
        pub fn ebs_options(mut self, input: crate::model::EbsOptions) -> Self {
            self.inner = self.inner.ebs_options(input);
            self
        }
        /// <p>Specify the type and size of the EBS volume that you want to use. </p>
        pub fn set_ebs_options(
            mut self,
            input: std::option::Option<crate::model::EbsOptions>,
        ) -> Self {
            self.inner = self.inner.set_ebs_options(input);
            self
        }
        /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
        pub fn snapshot_options(mut self, input: crate::model::SnapshotOptions) -> Self {
            self.inner = self.inner.snapshot_options(input);
            self
        }
        /// <p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>
        pub fn set_snapshot_options(
            mut self,
            input: std::option::Option<crate::model::SnapshotOptions>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
        pub fn vpc_options(mut self, input: crate::model::VpcOptions) -> Self {
            self.inner = self.inner.vpc_options(input);
            self
        }
        /// <p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::VpcOptions>,
        ) -> Self {
            self.inner = self.inner.set_vpc_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn cognito_options(mut self, input: crate::model::CognitoOptions) -> Self {
            self.inner = self.inner.cognito_options(input);
            self
        }
        /// <p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>
        pub fn set_cognito_options(
            mut self,
            input: std::option::Option<crate::model::CognitoOptions>,
        ) -> Self {
            self.inner = self.inner.set_cognito_options(input);
            self
        }
        /// Adds a key-value pair to `AdvancedOptions`.
        ///
        /// To override the contents of this collection use [`set_advanced_options`](Self::set_advanced_options).
        ///
        /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
        pub fn advanced_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.advanced_options(k.into(), v.into());
            self
        }
        /// <p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>
        pub fn set_advanced_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_advanced_options(input);
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn access_policies(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policies(input.into());
            self
        }
        /// <p>IAM access policy as a JSON-formatted string.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policies(input);
            self
        }
        /// Adds a key-value pair to `LogPublishingOptions`.
        ///
        /// To override the contents of this collection use [`set_log_publishing_options`](Self::set_log_publishing_options).
        ///
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
        pub fn log_publishing_options(
            mut self,
            k: crate::model::LogType,
            v: crate::model::LogPublishingOption,
        ) -> Self {
            self.inner = self.inner.log_publishing_options(k, v);
            self
        }
        /// <p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::LogType, crate::model::LogPublishingOption>,
            >,
        ) -> Self {
            self.inner = self.inner.set_log_publishing_options(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptions,
        ) -> Self {
            self.inner = self.inner.domain_endpoint_options(input);
            self
        }
        /// <p>Options to specify configuration that will be applied to the domain endpoint.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.inner = self.inner.set_domain_endpoint_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn advanced_security_options(
            mut self,
            input: crate::model::AdvancedSecurityOptionsInput,
        ) -> Self {
            self.inner = self.inner.advanced_security_options(input);
            self
        }
        /// <p>Specifies advanced security options.</p>
        pub fn set_advanced_security_options(
            mut self,
            input: std::option::Option<crate::model::AdvancedSecurityOptionsInput>,
        ) -> Self {
            self.inner = self.inner.set_advanced_security_options(input);
            self
        }
        /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            input: crate::model::NodeToNodeEncryptionOptions,
        ) -> Self {
            self.inner = self.inner.node_to_node_encryption_options(input);
            self
        }
        /// <p>Specifies the NodeToNodeEncryptionOptions.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<crate::model::NodeToNodeEncryptionOptions>,
        ) -> Self {
            self.inner = self.inner.set_node_to_node_encryption_options(input);
            self
        }
        /// <p>Specifies the Encryption At Rest Options.</p>
        pub fn encryption_at_rest_options(
            mut self,
            input: crate::model::EncryptionAtRestOptions,
        ) -> Self {
            self.inner = self.inner.encryption_at_rest_options(input);
            self
        }
        /// <p>Specifies the Encryption At Rest Options.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRestOptions>,
        ) -> Self {
            self.inner = self.inner.set_encryption_at_rest_options(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn auto_tune_options(mut self, input: crate::model::AutoTuneOptions) -> Self {
            self.inner = self.inner.auto_tune_options(input);
            self
        }
        /// <p>Specifies Auto-Tune options.</p>
        pub fn set_auto_tune_options(
            mut self,
            input: std::option::Option<crate::model::AutoTuneOptions>,
        ) -> Self {
            self.inner = self.inner.set_auto_tune_options(input);
            self
        }
        /// <p> This flag, when set to True, specifies whether the <code>UpdateElasticsearchDomain</code> request should return the results of validation checks without actually applying the change. This flag, when set to True, specifies the deployment mechanism through which the update shall be applied on the domain. This will not actually perform the Update. </p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p> This flag, when set to True, specifies whether the <code>UpdateElasticsearchDomain</code> request should return the results of validation checks without actually applying the change. This flag, when set to True, specifies the deployment mechanism through which the update shall be applied on the domain. This will not actually perform the Update. </p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePackage`.
    ///
    /// <p>Updates a package for use with Amazon ES domains.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePackage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_package_input::Builder,
    }
    impl<C, M, R> UpdatePackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePackageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePackageInputOperationOutputAlias,
                crate::output::UpdatePackageOutput,
                crate::error::UpdatePackageError,
                crate::input::UpdatePackageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique identifier for the package.</p>
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_id(input.into());
            self
        }
        /// <p>Unique identifier for the package.</p>
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package_id(input);
            self
        }
        /// <p>The S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code></p>
        pub fn package_source(mut self, input: crate::model::PackageSource) -> Self {
            self.inner = self.inner.package_source(input);
            self
        }
        /// <p>The S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code></p>
        pub fn set_package_source(
            mut self,
            input: std::option::Option<crate::model::PackageSource>,
        ) -> Self {
            self.inner = self.inner.set_package_source(input);
            self
        }
        /// <p>New description of the package.</p>
        pub fn package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_description(input.into());
            self
        }
        /// <p>New description of the package.</p>
        pub fn set_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_description(input);
            self
        }
        /// <p>An info message for the new version which will be shown as part of <code>GetPackageVersionHistoryResponse</code>.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(input.into());
            self
        }
        /// <p>An info message for the new version which will be shown as part of <code>GetPackageVersionHistoryResponse</code>.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpgradeElasticsearchDomain`.
    ///
    /// <p>Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpgradeElasticsearchDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::upgrade_elasticsearch_domain_input::Builder,
    }
    impl<C, M, R> UpgradeElasticsearchDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpgradeElasticsearchDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpgradeElasticsearchDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UpgradeElasticsearchDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpgradeElasticsearchDomainInputOperationOutputAlias,
                crate::output::UpgradeElasticsearchDomainOutput,
                crate::error::UpgradeElasticsearchDomainError,
                crate::input::UpgradeElasticsearchDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The version of Elasticsearch that you intend to upgrade the domain to.</p>
        pub fn target_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_version(input.into());
            self
        }
        /// <p>The version of Elasticsearch that you intend to upgrade the domain to.</p>
        pub fn set_target_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_version(input);
            self
        }
        /// <p> This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not actually perform the Upgrade. </p>
        pub fn perform_check_only(mut self, input: bool) -> Self {
            self.inner = self.inner.perform_check_only(input);
            self
        }
        /// <p> This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not actually perform the Upgrade. </p>
        pub fn set_perform_check_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_perform_check_only(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
