// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptInboundCrossClusterSearchConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_inbound_cross_cluster_search_connection`](crate::client::Client::accept_inbound_cross_cluster_search_connection).
///
/// See [`crate::client::fluent_builders::AcceptInboundCrossClusterSearchConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptInboundCrossClusterSearchConnection {
    _private: (),
}
impl AcceptInboundCrossClusterSearchConnection {
    /// Creates a new builder-style object to manufacture [`AcceptInboundCrossClusterSearchConnectionInput`](crate::input::AcceptInboundCrossClusterSearchConnectionInput)
    pub fn builder() -> crate::input::accept_inbound_cross_cluster_search_connection_input::Builder
    {
        crate::input::accept_inbound_cross_cluster_search_connection_input::Builder::default()
    }
    /// Creates a new `AcceptInboundCrossClusterSearchConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptInboundCrossClusterSearchConnection {
    type Output = std::result::Result<
        crate::output::AcceptInboundCrossClusterSearchConnectionOutput,
        crate::error::AcceptInboundCrossClusterSearchConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_inbound_cross_cluster_search_connection_error(
                response,
            )
        } else {
            crate::operation_deser::parse_accept_inbound_cross_cluster_search_connection_response(
                response,
            )
        }
    }
}

/// Operation shape for `AddTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags`](crate::client::Client::add_tags).
///
/// See [`crate::client::fluent_builders::AddTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTags {
    _private: (),
}
impl AddTags {
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
    /// Creates a new `AddTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTags {
    type Output = std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_tags_error(response)
        } else {
            crate::operation_deser::parse_add_tags_response(response)
        }
    }
}

/// Operation shape for `AssociatePackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_package`](crate::client::Client::associate_package).
///
/// See [`crate::client::fluent_builders::AssociatePackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociatePackage {
    _private: (),
}
impl AssociatePackage {
    /// Creates a new builder-style object to manufacture [`AssociatePackageInput`](crate::input::AssociatePackageInput)
    pub fn builder() -> crate::input::associate_package_input::Builder {
        crate::input::associate_package_input::Builder::default()
    }
    /// Creates a new `AssociatePackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociatePackage {
    type Output = std::result::Result<
        crate::output::AssociatePackageOutput,
        crate::error::AssociatePackageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_package_error(response)
        } else {
            crate::operation_deser::parse_associate_package_response(response)
        }
    }
}

/// Operation shape for `CancelElasticsearchServiceSoftwareUpdate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_elasticsearch_service_software_update`](crate::client::Client::cancel_elasticsearch_service_software_update).
///
/// See [`crate::client::fluent_builders::CancelElasticsearchServiceSoftwareUpdate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelElasticsearchServiceSoftwareUpdate {
    _private: (),
}
impl CancelElasticsearchServiceSoftwareUpdate {
    /// Creates a new builder-style object to manufacture [`CancelElasticsearchServiceSoftwareUpdateInput`](crate::input::CancelElasticsearchServiceSoftwareUpdateInput)
    pub fn builder() -> crate::input::cancel_elasticsearch_service_software_update_input::Builder {
        crate::input::cancel_elasticsearch_service_software_update_input::Builder::default()
    }
    /// Creates a new `CancelElasticsearchServiceSoftwareUpdate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelElasticsearchServiceSoftwareUpdate {
    type Output = std::result::Result<
        crate::output::CancelElasticsearchServiceSoftwareUpdateOutput,
        crate::error::CancelElasticsearchServiceSoftwareUpdateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_elasticsearch_service_software_update_error(
                response,
            )
        } else {
            crate::operation_deser::parse_cancel_elasticsearch_service_software_update_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateElasticsearchDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_elasticsearch_domain`](crate::client::Client::create_elasticsearch_domain).
///
/// See [`crate::client::fluent_builders::CreateElasticsearchDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateElasticsearchDomain {
    _private: (),
}
impl CreateElasticsearchDomain {
    /// Creates a new builder-style object to manufacture [`CreateElasticsearchDomainInput`](crate::input::CreateElasticsearchDomainInput)
    pub fn builder() -> crate::input::create_elasticsearch_domain_input::Builder {
        crate::input::create_elasticsearch_domain_input::Builder::default()
    }
    /// Creates a new `CreateElasticsearchDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateElasticsearchDomain {
    type Output = std::result::Result<
        crate::output::CreateElasticsearchDomainOutput,
        crate::error::CreateElasticsearchDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_elasticsearch_domain_error(response)
        } else {
            crate::operation_deser::parse_create_elasticsearch_domain_response(response)
        }
    }
}

/// Operation shape for `CreateOutboundCrossClusterSearchConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_outbound_cross_cluster_search_connection`](crate::client::Client::create_outbound_cross_cluster_search_connection).
///
/// See [`crate::client::fluent_builders::CreateOutboundCrossClusterSearchConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOutboundCrossClusterSearchConnection {
    _private: (),
}
impl CreateOutboundCrossClusterSearchConnection {
    /// Creates a new builder-style object to manufacture [`CreateOutboundCrossClusterSearchConnectionInput`](crate::input::CreateOutboundCrossClusterSearchConnectionInput)
    pub fn builder() -> crate::input::create_outbound_cross_cluster_search_connection_input::Builder
    {
        crate::input::create_outbound_cross_cluster_search_connection_input::Builder::default()
    }
    /// Creates a new `CreateOutboundCrossClusterSearchConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOutboundCrossClusterSearchConnection {
    type Output = std::result::Result<
        crate::output::CreateOutboundCrossClusterSearchConnectionOutput,
        crate::error::CreateOutboundCrossClusterSearchConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_outbound_cross_cluster_search_connection_error(
                response,
            )
        } else {
            crate::operation_deser::parse_create_outbound_cross_cluster_search_connection_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreatePackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_package`](crate::client::Client::create_package).
///
/// See [`crate::client::fluent_builders::CreatePackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePackage {
    _private: (),
}
impl CreatePackage {
    /// Creates a new builder-style object to manufacture [`CreatePackageInput`](crate::input::CreatePackageInput)
    pub fn builder() -> crate::input::create_package_input::Builder {
        crate::input::create_package_input::Builder::default()
    }
    /// Creates a new `CreatePackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePackage {
    type Output =
        std::result::Result<crate::output::CreatePackageOutput, crate::error::CreatePackageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_package_error(response)
        } else {
            crate::operation_deser::parse_create_package_response(response)
        }
    }
}

/// Operation shape for `DeleteElasticsearchDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_elasticsearch_domain`](crate::client::Client::delete_elasticsearch_domain).
///
/// See [`crate::client::fluent_builders::DeleteElasticsearchDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteElasticsearchDomain {
    _private: (),
}
impl DeleteElasticsearchDomain {
    /// Creates a new builder-style object to manufacture [`DeleteElasticsearchDomainInput`](crate::input::DeleteElasticsearchDomainInput)
    pub fn builder() -> crate::input::delete_elasticsearch_domain_input::Builder {
        crate::input::delete_elasticsearch_domain_input::Builder::default()
    }
    /// Creates a new `DeleteElasticsearchDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteElasticsearchDomain {
    type Output = std::result::Result<
        crate::output::DeleteElasticsearchDomainOutput,
        crate::error::DeleteElasticsearchDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_elasticsearch_domain_error(response)
        } else {
            crate::operation_deser::parse_delete_elasticsearch_domain_response(response)
        }
    }
}

/// Operation shape for `DeleteElasticsearchServiceRole`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_elasticsearch_service_role`](crate::client::Client::delete_elasticsearch_service_role).
///
/// See [`crate::client::fluent_builders::DeleteElasticsearchServiceRole`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteElasticsearchServiceRole {
    _private: (),
}
impl DeleteElasticsearchServiceRole {
    /// Creates a new builder-style object to manufacture [`DeleteElasticsearchServiceRoleInput`](crate::input::DeleteElasticsearchServiceRoleInput)
    pub fn builder() -> crate::input::delete_elasticsearch_service_role_input::Builder {
        crate::input::delete_elasticsearch_service_role_input::Builder::default()
    }
    /// Creates a new `DeleteElasticsearchServiceRole` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteElasticsearchServiceRole {
    type Output = std::result::Result<
        crate::output::DeleteElasticsearchServiceRoleOutput,
        crate::error::DeleteElasticsearchServiceRoleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_elasticsearch_service_role_error(response)
        } else {
            crate::operation_deser::parse_delete_elasticsearch_service_role_response(response)
        }
    }
}

/// Operation shape for `DeleteInboundCrossClusterSearchConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_inbound_cross_cluster_search_connection`](crate::client::Client::delete_inbound_cross_cluster_search_connection).
///
/// See [`crate::client::fluent_builders::DeleteInboundCrossClusterSearchConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInboundCrossClusterSearchConnection {
    _private: (),
}
impl DeleteInboundCrossClusterSearchConnection {
    /// Creates a new builder-style object to manufacture [`DeleteInboundCrossClusterSearchConnectionInput`](crate::input::DeleteInboundCrossClusterSearchConnectionInput)
    pub fn builder() -> crate::input::delete_inbound_cross_cluster_search_connection_input::Builder
    {
        crate::input::delete_inbound_cross_cluster_search_connection_input::Builder::default()
    }
    /// Creates a new `DeleteInboundCrossClusterSearchConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInboundCrossClusterSearchConnection {
    type Output = std::result::Result<
        crate::output::DeleteInboundCrossClusterSearchConnectionOutput,
        crate::error::DeleteInboundCrossClusterSearchConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_inbound_cross_cluster_search_connection_error(
                response,
            )
        } else {
            crate::operation_deser::parse_delete_inbound_cross_cluster_search_connection_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteOutboundCrossClusterSearchConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_outbound_cross_cluster_search_connection`](crate::client::Client::delete_outbound_cross_cluster_search_connection).
///
/// See [`crate::client::fluent_builders::DeleteOutboundCrossClusterSearchConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOutboundCrossClusterSearchConnection {
    _private: (),
}
impl DeleteOutboundCrossClusterSearchConnection {
    /// Creates a new builder-style object to manufacture [`DeleteOutboundCrossClusterSearchConnectionInput`](crate::input::DeleteOutboundCrossClusterSearchConnectionInput)
    pub fn builder() -> crate::input::delete_outbound_cross_cluster_search_connection_input::Builder
    {
        crate::input::delete_outbound_cross_cluster_search_connection_input::Builder::default()
    }
    /// Creates a new `DeleteOutboundCrossClusterSearchConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOutboundCrossClusterSearchConnection {
    type Output = std::result::Result<
        crate::output::DeleteOutboundCrossClusterSearchConnectionOutput,
        crate::error::DeleteOutboundCrossClusterSearchConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_outbound_cross_cluster_search_connection_error(
                response,
            )
        } else {
            crate::operation_deser::parse_delete_outbound_cross_cluster_search_connection_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeletePackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_package`](crate::client::Client::delete_package).
///
/// See [`crate::client::fluent_builders::DeletePackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePackage {
    _private: (),
}
impl DeletePackage {
    /// Creates a new builder-style object to manufacture [`DeletePackageInput`](crate::input::DeletePackageInput)
    pub fn builder() -> crate::input::delete_package_input::Builder {
        crate::input::delete_package_input::Builder::default()
    }
    /// Creates a new `DeletePackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePackage {
    type Output =
        std::result::Result<crate::output::DeletePackageOutput, crate::error::DeletePackageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_package_error(response)
        } else {
            crate::operation_deser::parse_delete_package_response(response)
        }
    }
}

/// Operation shape for `DescribeDomainAutoTunes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_domain_auto_tunes`](crate::client::Client::describe_domain_auto_tunes).
///
/// See [`crate::client::fluent_builders::DescribeDomainAutoTunes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDomainAutoTunes {
    _private: (),
}
impl DescribeDomainAutoTunes {
    /// Creates a new builder-style object to manufacture [`DescribeDomainAutoTunesInput`](crate::input::DescribeDomainAutoTunesInput)
    pub fn builder() -> crate::input::describe_domain_auto_tunes_input::Builder {
        crate::input::describe_domain_auto_tunes_input::Builder::default()
    }
    /// Creates a new `DescribeDomainAutoTunes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDomainAutoTunes {
    type Output = std::result::Result<
        crate::output::DescribeDomainAutoTunesOutput,
        crate::error::DescribeDomainAutoTunesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_domain_auto_tunes_error(response)
        } else {
            crate::operation_deser::parse_describe_domain_auto_tunes_response(response)
        }
    }
}

/// Operation shape for `DescribeElasticsearchDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_elasticsearch_domain`](crate::client::Client::describe_elasticsearch_domain).
///
/// See [`crate::client::fluent_builders::DescribeElasticsearchDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeElasticsearchDomain {
    _private: (),
}
impl DescribeElasticsearchDomain {
    /// Creates a new builder-style object to manufacture [`DescribeElasticsearchDomainInput`](crate::input::DescribeElasticsearchDomainInput)
    pub fn builder() -> crate::input::describe_elasticsearch_domain_input::Builder {
        crate::input::describe_elasticsearch_domain_input::Builder::default()
    }
    /// Creates a new `DescribeElasticsearchDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeElasticsearchDomain {
    type Output = std::result::Result<
        crate::output::DescribeElasticsearchDomainOutput,
        crate::error::DescribeElasticsearchDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_elasticsearch_domain_error(response)
        } else {
            crate::operation_deser::parse_describe_elasticsearch_domain_response(response)
        }
    }
}

/// Operation shape for `DescribeElasticsearchDomainConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_elasticsearch_domain_config`](crate::client::Client::describe_elasticsearch_domain_config).
///
/// See [`crate::client::fluent_builders::DescribeElasticsearchDomainConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeElasticsearchDomainConfig {
    _private: (),
}
impl DescribeElasticsearchDomainConfig {
    /// Creates a new builder-style object to manufacture [`DescribeElasticsearchDomainConfigInput`](crate::input::DescribeElasticsearchDomainConfigInput)
    pub fn builder() -> crate::input::describe_elasticsearch_domain_config_input::Builder {
        crate::input::describe_elasticsearch_domain_config_input::Builder::default()
    }
    /// Creates a new `DescribeElasticsearchDomainConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeElasticsearchDomainConfig {
    type Output = std::result::Result<
        crate::output::DescribeElasticsearchDomainConfigOutput,
        crate::error::DescribeElasticsearchDomainConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_elasticsearch_domain_config_error(response)
        } else {
            crate::operation_deser::parse_describe_elasticsearch_domain_config_response(response)
        }
    }
}

/// Operation shape for `DescribeElasticsearchDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_elasticsearch_domains`](crate::client::Client::describe_elasticsearch_domains).
///
/// See [`crate::client::fluent_builders::DescribeElasticsearchDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeElasticsearchDomains {
    _private: (),
}
impl DescribeElasticsearchDomains {
    /// Creates a new builder-style object to manufacture [`DescribeElasticsearchDomainsInput`](crate::input::DescribeElasticsearchDomainsInput)
    pub fn builder() -> crate::input::describe_elasticsearch_domains_input::Builder {
        crate::input::describe_elasticsearch_domains_input::Builder::default()
    }
    /// Creates a new `DescribeElasticsearchDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeElasticsearchDomains {
    type Output = std::result::Result<
        crate::output::DescribeElasticsearchDomainsOutput,
        crate::error::DescribeElasticsearchDomainsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_elasticsearch_domains_error(response)
        } else {
            crate::operation_deser::parse_describe_elasticsearch_domains_response(response)
        }
    }
}

/// Operation shape for `DescribeElasticsearchInstanceTypeLimits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_elasticsearch_instance_type_limits`](crate::client::Client::describe_elasticsearch_instance_type_limits).
///
/// See [`crate::client::fluent_builders::DescribeElasticsearchInstanceTypeLimits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeElasticsearchInstanceTypeLimits {
    _private: (),
}
impl DescribeElasticsearchInstanceTypeLimits {
    /// Creates a new builder-style object to manufacture [`DescribeElasticsearchInstanceTypeLimitsInput`](crate::input::DescribeElasticsearchInstanceTypeLimitsInput)
    pub fn builder() -> crate::input::describe_elasticsearch_instance_type_limits_input::Builder {
        crate::input::describe_elasticsearch_instance_type_limits_input::Builder::default()
    }
    /// Creates a new `DescribeElasticsearchInstanceTypeLimits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeElasticsearchInstanceTypeLimits {
    type Output = std::result::Result<
        crate::output::DescribeElasticsearchInstanceTypeLimitsOutput,
        crate::error::DescribeElasticsearchInstanceTypeLimitsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_elasticsearch_instance_type_limits_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_elasticsearch_instance_type_limits_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeInboundCrossClusterSearchConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_inbound_cross_cluster_search_connections`](crate::client::Client::describe_inbound_cross_cluster_search_connections).
///
/// See [`crate::client::fluent_builders::DescribeInboundCrossClusterSearchConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInboundCrossClusterSearchConnections {
    _private: (),
}
impl DescribeInboundCrossClusterSearchConnections {
    /// Creates a new builder-style object to manufacture [`DescribeInboundCrossClusterSearchConnectionsInput`](crate::input::DescribeInboundCrossClusterSearchConnectionsInput)
    pub fn builder(
    ) -> crate::input::describe_inbound_cross_cluster_search_connections_input::Builder {
        crate::input::describe_inbound_cross_cluster_search_connections_input::Builder::default()
    }
    /// Creates a new `DescribeInboundCrossClusterSearchConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeInboundCrossClusterSearchConnections
{
    type Output = std::result::Result<
        crate::output::DescribeInboundCrossClusterSearchConnectionsOutput,
        crate::error::DescribeInboundCrossClusterSearchConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_inbound_cross_cluster_search_connections_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_inbound_cross_cluster_search_connections_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeOutboundCrossClusterSearchConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_outbound_cross_cluster_search_connections`](crate::client::Client::describe_outbound_cross_cluster_search_connections).
///
/// See [`crate::client::fluent_builders::DescribeOutboundCrossClusterSearchConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOutboundCrossClusterSearchConnections {
    _private: (),
}
impl DescribeOutboundCrossClusterSearchConnections {
    /// Creates a new builder-style object to manufacture [`DescribeOutboundCrossClusterSearchConnectionsInput`](crate::input::DescribeOutboundCrossClusterSearchConnectionsInput)
    pub fn builder(
    ) -> crate::input::describe_outbound_cross_cluster_search_connections_input::Builder {
        crate::input::describe_outbound_cross_cluster_search_connections_input::Builder::default()
    }
    /// Creates a new `DescribeOutboundCrossClusterSearchConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeOutboundCrossClusterSearchConnections
{
    type Output = std::result::Result<
        crate::output::DescribeOutboundCrossClusterSearchConnectionsOutput,
        crate::error::DescribeOutboundCrossClusterSearchConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_outbound_cross_cluster_search_connections_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_outbound_cross_cluster_search_connections_response(response)
        }
    }
}

/// Operation shape for `DescribePackages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_packages`](crate::client::Client::describe_packages).
///
/// See [`crate::client::fluent_builders::DescribePackages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePackages {
    _private: (),
}
impl DescribePackages {
    /// Creates a new builder-style object to manufacture [`DescribePackagesInput`](crate::input::DescribePackagesInput)
    pub fn builder() -> crate::input::describe_packages_input::Builder {
        crate::input::describe_packages_input::Builder::default()
    }
    /// Creates a new `DescribePackages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePackages {
    type Output = std::result::Result<
        crate::output::DescribePackagesOutput,
        crate::error::DescribePackagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_packages_error(response)
        } else {
            crate::operation_deser::parse_describe_packages_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedElasticsearchInstanceOfferings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_elasticsearch_instance_offerings`](crate::client::Client::describe_reserved_elasticsearch_instance_offerings).
///
/// See [`crate::client::fluent_builders::DescribeReservedElasticsearchInstanceOfferings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedElasticsearchInstanceOfferings {
    _private: (),
}
impl DescribeReservedElasticsearchInstanceOfferings {
    /// Creates a new builder-style object to manufacture [`DescribeReservedElasticsearchInstanceOfferingsInput`](crate::input::DescribeReservedElasticsearchInstanceOfferingsInput)
    pub fn builder(
    ) -> crate::input::describe_reserved_elasticsearch_instance_offerings_input::Builder {
        crate::input::describe_reserved_elasticsearch_instance_offerings_input::Builder::default()
    }
    /// Creates a new `DescribeReservedElasticsearchInstanceOfferings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeReservedElasticsearchInstanceOfferings
{
    type Output = std::result::Result<
        crate::output::DescribeReservedElasticsearchInstanceOfferingsOutput,
        crate::error::DescribeReservedElasticsearchInstanceOfferingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_elasticsearch_instance_offerings_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_reserved_elasticsearch_instance_offerings_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedElasticsearchInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_elasticsearch_instances`](crate::client::Client::describe_reserved_elasticsearch_instances).
///
/// See [`crate::client::fluent_builders::DescribeReservedElasticsearchInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedElasticsearchInstances {
    _private: (),
}
impl DescribeReservedElasticsearchInstances {
    /// Creates a new builder-style object to manufacture [`DescribeReservedElasticsearchInstancesInput`](crate::input::DescribeReservedElasticsearchInstancesInput)
    pub fn builder() -> crate::input::describe_reserved_elasticsearch_instances_input::Builder {
        crate::input::describe_reserved_elasticsearch_instances_input::Builder::default()
    }
    /// Creates a new `DescribeReservedElasticsearchInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedElasticsearchInstances {
    type Output = std::result::Result<
        crate::output::DescribeReservedElasticsearchInstancesOutput,
        crate::error::DescribeReservedElasticsearchInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_elasticsearch_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_elasticsearch_instances_response(
                response,
            )
        }
    }
}

/// Operation shape for `DissociatePackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`dissociate_package`](crate::client::Client::dissociate_package).
///
/// See [`crate::client::fluent_builders::DissociatePackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DissociatePackage {
    _private: (),
}
impl DissociatePackage {
    /// Creates a new builder-style object to manufacture [`DissociatePackageInput`](crate::input::DissociatePackageInput)
    pub fn builder() -> crate::input::dissociate_package_input::Builder {
        crate::input::dissociate_package_input::Builder::default()
    }
    /// Creates a new `DissociatePackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DissociatePackage {
    type Output = std::result::Result<
        crate::output::DissociatePackageOutput,
        crate::error::DissociatePackageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_dissociate_package_error(response)
        } else {
            crate::operation_deser::parse_dissociate_package_response(response)
        }
    }
}

/// Operation shape for `GetCompatibleElasticsearchVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_compatible_elasticsearch_versions`](crate::client::Client::get_compatible_elasticsearch_versions).
///
/// See [`crate::client::fluent_builders::GetCompatibleElasticsearchVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCompatibleElasticsearchVersions {
    _private: (),
}
impl GetCompatibleElasticsearchVersions {
    /// Creates a new builder-style object to manufacture [`GetCompatibleElasticsearchVersionsInput`](crate::input::GetCompatibleElasticsearchVersionsInput)
    pub fn builder() -> crate::input::get_compatible_elasticsearch_versions_input::Builder {
        crate::input::get_compatible_elasticsearch_versions_input::Builder::default()
    }
    /// Creates a new `GetCompatibleElasticsearchVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCompatibleElasticsearchVersions {
    type Output = std::result::Result<
        crate::output::GetCompatibleElasticsearchVersionsOutput,
        crate::error::GetCompatibleElasticsearchVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_compatible_elasticsearch_versions_error(response)
        } else {
            crate::operation_deser::parse_get_compatible_elasticsearch_versions_response(response)
        }
    }
}

/// Operation shape for `GetPackageVersionHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_package_version_history`](crate::client::Client::get_package_version_history).
///
/// See [`crate::client::fluent_builders::GetPackageVersionHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPackageVersionHistory {
    _private: (),
}
impl GetPackageVersionHistory {
    /// Creates a new builder-style object to manufacture [`GetPackageVersionHistoryInput`](crate::input::GetPackageVersionHistoryInput)
    pub fn builder() -> crate::input::get_package_version_history_input::Builder {
        crate::input::get_package_version_history_input::Builder::default()
    }
    /// Creates a new `GetPackageVersionHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPackageVersionHistory {
    type Output = std::result::Result<
        crate::output::GetPackageVersionHistoryOutput,
        crate::error::GetPackageVersionHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_package_version_history_error(response)
        } else {
            crate::operation_deser::parse_get_package_version_history_response(response)
        }
    }
}

/// Operation shape for `GetUpgradeHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_upgrade_history`](crate::client::Client::get_upgrade_history).
///
/// See [`crate::client::fluent_builders::GetUpgradeHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUpgradeHistory {
    _private: (),
}
impl GetUpgradeHistory {
    /// Creates a new builder-style object to manufacture [`GetUpgradeHistoryInput`](crate::input::GetUpgradeHistoryInput)
    pub fn builder() -> crate::input::get_upgrade_history_input::Builder {
        crate::input::get_upgrade_history_input::Builder::default()
    }
    /// Creates a new `GetUpgradeHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUpgradeHistory {
    type Output = std::result::Result<
        crate::output::GetUpgradeHistoryOutput,
        crate::error::GetUpgradeHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_upgrade_history_error(response)
        } else {
            crate::operation_deser::parse_get_upgrade_history_response(response)
        }
    }
}

/// Operation shape for `GetUpgradeStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_upgrade_status`](crate::client::Client::get_upgrade_status).
///
/// See [`crate::client::fluent_builders::GetUpgradeStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUpgradeStatus {
    _private: (),
}
impl GetUpgradeStatus {
    /// Creates a new builder-style object to manufacture [`GetUpgradeStatusInput`](crate::input::GetUpgradeStatusInput)
    pub fn builder() -> crate::input::get_upgrade_status_input::Builder {
        crate::input::get_upgrade_status_input::Builder::default()
    }
    /// Creates a new `GetUpgradeStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUpgradeStatus {
    type Output = std::result::Result<
        crate::output::GetUpgradeStatusOutput,
        crate::error::GetUpgradeStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_upgrade_status_error(response)
        } else {
            crate::operation_deser::parse_get_upgrade_status_response(response)
        }
    }
}

/// Operation shape for `ListDomainNames`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_domain_names`](crate::client::Client::list_domain_names).
///
/// See [`crate::client::fluent_builders::ListDomainNames`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDomainNames {
    _private: (),
}
impl ListDomainNames {
    /// Creates a new builder-style object to manufacture [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
    pub fn builder() -> crate::input::list_domain_names_input::Builder {
        crate::input::list_domain_names_input::Builder::default()
    }
    /// Creates a new `ListDomainNames` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDomainNames {
    type Output = std::result::Result<
        crate::output::ListDomainNamesOutput,
        crate::error::ListDomainNamesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_domain_names_error(response)
        } else {
            crate::operation_deser::parse_list_domain_names_response(response)
        }
    }
}

/// Operation shape for `ListDomainsForPackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_domains_for_package`](crate::client::Client::list_domains_for_package).
///
/// See [`crate::client::fluent_builders::ListDomainsForPackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDomainsForPackage {
    _private: (),
}
impl ListDomainsForPackage {
    /// Creates a new builder-style object to manufacture [`ListDomainsForPackageInput`](crate::input::ListDomainsForPackageInput)
    pub fn builder() -> crate::input::list_domains_for_package_input::Builder {
        crate::input::list_domains_for_package_input::Builder::default()
    }
    /// Creates a new `ListDomainsForPackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDomainsForPackage {
    type Output = std::result::Result<
        crate::output::ListDomainsForPackageOutput,
        crate::error::ListDomainsForPackageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_domains_for_package_error(response)
        } else {
            crate::operation_deser::parse_list_domains_for_package_response(response)
        }
    }
}

/// Operation shape for `ListElasticsearchInstanceTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_elasticsearch_instance_types`](crate::client::Client::list_elasticsearch_instance_types).
///
/// See [`crate::client::fluent_builders::ListElasticsearchInstanceTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListElasticsearchInstanceTypes {
    _private: (),
}
impl ListElasticsearchInstanceTypes {
    /// Creates a new builder-style object to manufacture [`ListElasticsearchInstanceTypesInput`](crate::input::ListElasticsearchInstanceTypesInput)
    pub fn builder() -> crate::input::list_elasticsearch_instance_types_input::Builder {
        crate::input::list_elasticsearch_instance_types_input::Builder::default()
    }
    /// Creates a new `ListElasticsearchInstanceTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListElasticsearchInstanceTypes {
    type Output = std::result::Result<
        crate::output::ListElasticsearchInstanceTypesOutput,
        crate::error::ListElasticsearchInstanceTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_elasticsearch_instance_types_error(response)
        } else {
            crate::operation_deser::parse_list_elasticsearch_instance_types_response(response)
        }
    }
}

/// Operation shape for `ListElasticsearchVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_elasticsearch_versions`](crate::client::Client::list_elasticsearch_versions).
///
/// See [`crate::client::fluent_builders::ListElasticsearchVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListElasticsearchVersions {
    _private: (),
}
impl ListElasticsearchVersions {
    /// Creates a new builder-style object to manufacture [`ListElasticsearchVersionsInput`](crate::input::ListElasticsearchVersionsInput)
    pub fn builder() -> crate::input::list_elasticsearch_versions_input::Builder {
        crate::input::list_elasticsearch_versions_input::Builder::default()
    }
    /// Creates a new `ListElasticsearchVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListElasticsearchVersions {
    type Output = std::result::Result<
        crate::output::ListElasticsearchVersionsOutput,
        crate::error::ListElasticsearchVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_elasticsearch_versions_error(response)
        } else {
            crate::operation_deser::parse_list_elasticsearch_versions_response(response)
        }
    }
}

/// Operation shape for `ListPackagesForDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_packages_for_domain`](crate::client::Client::list_packages_for_domain).
///
/// See [`crate::client::fluent_builders::ListPackagesForDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPackagesForDomain {
    _private: (),
}
impl ListPackagesForDomain {
    /// Creates a new builder-style object to manufacture [`ListPackagesForDomainInput`](crate::input::ListPackagesForDomainInput)
    pub fn builder() -> crate::input::list_packages_for_domain_input::Builder {
        crate::input::list_packages_for_domain_input::Builder::default()
    }
    /// Creates a new `ListPackagesForDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPackagesForDomain {
    type Output = std::result::Result<
        crate::output::ListPackagesForDomainOutput,
        crate::error::ListPackagesForDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_packages_for_domain_error(response)
        } else {
            crate::operation_deser::parse_list_packages_for_domain_response(response)
        }
    }
}

/// Operation shape for `ListTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags`](crate::client::Client::list_tags).
///
/// See [`crate::client::fluent_builders::ListTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTags {
    _private: (),
}
impl ListTags {
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
    /// Creates a new `ListTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTags {
    type Output = std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_error(response)
        } else {
            crate::operation_deser::parse_list_tags_response(response)
        }
    }
}

/// Operation shape for `PurchaseReservedElasticsearchInstanceOffering`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`purchase_reserved_elasticsearch_instance_offering`](crate::client::Client::purchase_reserved_elasticsearch_instance_offering).
///
/// See [`crate::client::fluent_builders::PurchaseReservedElasticsearchInstanceOffering`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PurchaseReservedElasticsearchInstanceOffering {
    _private: (),
}
impl PurchaseReservedElasticsearchInstanceOffering {
    /// Creates a new builder-style object to manufacture [`PurchaseReservedElasticsearchInstanceOfferingInput`](crate::input::PurchaseReservedElasticsearchInstanceOfferingInput)
    pub fn builder(
    ) -> crate::input::purchase_reserved_elasticsearch_instance_offering_input::Builder {
        crate::input::purchase_reserved_elasticsearch_instance_offering_input::Builder::default()
    }
    /// Creates a new `PurchaseReservedElasticsearchInstanceOffering` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for PurchaseReservedElasticsearchInstanceOffering
{
    type Output = std::result::Result<
        crate::output::PurchaseReservedElasticsearchInstanceOfferingOutput,
        crate::error::PurchaseReservedElasticsearchInstanceOfferingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_purchase_reserved_elasticsearch_instance_offering_error(
                response,
            )
        } else {
            crate::operation_deser::parse_purchase_reserved_elasticsearch_instance_offering_response(
                response,
            )
        }
    }
}

/// Operation shape for `RejectInboundCrossClusterSearchConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_inbound_cross_cluster_search_connection`](crate::client::Client::reject_inbound_cross_cluster_search_connection).
///
/// See [`crate::client::fluent_builders::RejectInboundCrossClusterSearchConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectInboundCrossClusterSearchConnection {
    _private: (),
}
impl RejectInboundCrossClusterSearchConnection {
    /// Creates a new builder-style object to manufacture [`RejectInboundCrossClusterSearchConnectionInput`](crate::input::RejectInboundCrossClusterSearchConnectionInput)
    pub fn builder() -> crate::input::reject_inbound_cross_cluster_search_connection_input::Builder
    {
        crate::input::reject_inbound_cross_cluster_search_connection_input::Builder::default()
    }
    /// Creates a new `RejectInboundCrossClusterSearchConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectInboundCrossClusterSearchConnection {
    type Output = std::result::Result<
        crate::output::RejectInboundCrossClusterSearchConnectionOutput,
        crate::error::RejectInboundCrossClusterSearchConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_inbound_cross_cluster_search_connection_error(
                response,
            )
        } else {
            crate::operation_deser::parse_reject_inbound_cross_cluster_search_connection_response(
                response,
            )
        }
    }
}

/// Operation shape for `RemoveTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_tags`](crate::client::Client::remove_tags).
///
/// See [`crate::client::fluent_builders::RemoveTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTags {
    _private: (),
}
impl RemoveTags {
    /// Creates a new builder-style object to manufacture [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    pub fn builder() -> crate::input::remove_tags_input::Builder {
        crate::input::remove_tags_input::Builder::default()
    }
    /// Creates a new `RemoveTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTags {
    type Output =
        std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_tags_error(response)
        } else {
            crate::operation_deser::parse_remove_tags_response(response)
        }
    }
}

/// Operation shape for `StartElasticsearchServiceSoftwareUpdate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_elasticsearch_service_software_update`](crate::client::Client::start_elasticsearch_service_software_update).
///
/// See [`crate::client::fluent_builders::StartElasticsearchServiceSoftwareUpdate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartElasticsearchServiceSoftwareUpdate {
    _private: (),
}
impl StartElasticsearchServiceSoftwareUpdate {
    /// Creates a new builder-style object to manufacture [`StartElasticsearchServiceSoftwareUpdateInput`](crate::input::StartElasticsearchServiceSoftwareUpdateInput)
    pub fn builder() -> crate::input::start_elasticsearch_service_software_update_input::Builder {
        crate::input::start_elasticsearch_service_software_update_input::Builder::default()
    }
    /// Creates a new `StartElasticsearchServiceSoftwareUpdate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartElasticsearchServiceSoftwareUpdate {
    type Output = std::result::Result<
        crate::output::StartElasticsearchServiceSoftwareUpdateOutput,
        crate::error::StartElasticsearchServiceSoftwareUpdateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_elasticsearch_service_software_update_error(
                response,
            )
        } else {
            crate::operation_deser::parse_start_elasticsearch_service_software_update_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateElasticsearchDomainConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_elasticsearch_domain_config`](crate::client::Client::update_elasticsearch_domain_config).
///
/// See [`crate::client::fluent_builders::UpdateElasticsearchDomainConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateElasticsearchDomainConfig {
    _private: (),
}
impl UpdateElasticsearchDomainConfig {
    /// Creates a new builder-style object to manufacture [`UpdateElasticsearchDomainConfigInput`](crate::input::UpdateElasticsearchDomainConfigInput)
    pub fn builder() -> crate::input::update_elasticsearch_domain_config_input::Builder {
        crate::input::update_elasticsearch_domain_config_input::Builder::default()
    }
    /// Creates a new `UpdateElasticsearchDomainConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateElasticsearchDomainConfig {
    type Output = std::result::Result<
        crate::output::UpdateElasticsearchDomainConfigOutput,
        crate::error::UpdateElasticsearchDomainConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_elasticsearch_domain_config_error(response)
        } else {
            crate::operation_deser::parse_update_elasticsearch_domain_config_response(response)
        }
    }
}

/// Operation shape for `UpdatePackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_package`](crate::client::Client::update_package).
///
/// See [`crate::client::fluent_builders::UpdatePackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePackage {
    _private: (),
}
impl UpdatePackage {
    /// Creates a new builder-style object to manufacture [`UpdatePackageInput`](crate::input::UpdatePackageInput)
    pub fn builder() -> crate::input::update_package_input::Builder {
        crate::input::update_package_input::Builder::default()
    }
    /// Creates a new `UpdatePackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePackage {
    type Output =
        std::result::Result<crate::output::UpdatePackageOutput, crate::error::UpdatePackageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_package_error(response)
        } else {
            crate::operation_deser::parse_update_package_response(response)
        }
    }
}

/// Operation shape for `UpgradeElasticsearchDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`upgrade_elasticsearch_domain`](crate::client::Client::upgrade_elasticsearch_domain).
///
/// See [`crate::client::fluent_builders::UpgradeElasticsearchDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpgradeElasticsearchDomain {
    _private: (),
}
impl UpgradeElasticsearchDomain {
    /// Creates a new builder-style object to manufacture [`UpgradeElasticsearchDomainInput`](crate::input::UpgradeElasticsearchDomainInput)
    pub fn builder() -> crate::input::upgrade_elasticsearch_domain_input::Builder {
        crate::input::upgrade_elasticsearch_domain_input::Builder::default()
    }
    /// Creates a new `UpgradeElasticsearchDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpgradeElasticsearchDomain {
    type Output = std::result::Result<
        crate::output::UpgradeElasticsearchDomainOutput,
        crate::error::UpgradeElasticsearchDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_upgrade_elasticsearch_domain_error(response)
        } else {
            crate::operation_deser::parse_upgrade_elasticsearch_domain_response(response)
        }
    }
}
