// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>
/// Container for response returned by
/// <code>
/// <a>UpgradeElasticsearchDomain</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeElasticsearchDomainOutput {
    /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The version of Elasticsearch that you intend to upgrade the domain to.</p>
    pub target_version: std::option::Option<std::string::String>,
    /// <p>
    /// This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed.
    /// This will not actually perform the Upgrade.
    /// </p>
    pub perform_check_only: std::option::Option<bool>,
}
impl std::fmt::Debug for UpgradeElasticsearchDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeElasticsearchDomainOutput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("target_version", &self.target_version);
        formatter.field("perform_check_only", &self.perform_check_only);
        formatter.finish()
    }
}
/// See [`UpgradeElasticsearchDomainOutput`](crate::output::UpgradeElasticsearchDomainOutput)
pub mod upgrade_elasticsearch_domain_output {
    /// A builder for [`UpgradeElasticsearchDomainOutput`](crate::output::UpgradeElasticsearchDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) target_version: std::option::Option<std::string::String>,
        pub(crate) perform_check_only: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The version of Elasticsearch that you intend to upgrade the domain to.</p>
        pub fn target_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_version = Some(input.into());
            self
        }
        /// <p>The version of Elasticsearch that you intend to upgrade the domain to.</p>
        pub fn set_target_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_version = input;
            self
        }
        /// <p>
        /// This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed.
        /// This will not actually perform the Upgrade.
        /// </p>
        pub fn perform_check_only(mut self, input: bool) -> Self {
            self.perform_check_only = Some(input);
            self
        }
        /// <p>
        /// This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed.
        /// This will not actually perform the Upgrade.
        /// </p>
        pub fn set_perform_check_only(mut self, input: std::option::Option<bool>) -> Self {
            self.perform_check_only = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradeElasticsearchDomainOutput`](crate::output::UpgradeElasticsearchDomainOutput)
        pub fn build(self) -> crate::output::UpgradeElasticsearchDomainOutput {
            crate::output::UpgradeElasticsearchDomainOutput {
                domain_name: self.domain_name,
                target_version: self.target_version,
                perform_check_only: self.perform_check_only,
            }
        }
    }
}
impl UpgradeElasticsearchDomainOutput {
    /// Creates a new builder-style object to manufacture [`UpgradeElasticsearchDomainOutput`](crate::output::UpgradeElasticsearchDomainOutput)
    pub fn builder() -> crate::output::upgrade_elasticsearch_domain_output::Builder {
        crate::output::upgrade_elasticsearch_domain_output::Builder::default()
    }
}

/// <p>
/// Container for response returned by
/// <code>
/// <a>UpdatePackage</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePackageOutput {
    /// <p>Information about the package <code>PackageDetails</code>.</p>
    pub package_details: std::option::Option<crate::model::PackageDetails>,
}
impl std::fmt::Debug for UpdatePackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePackageOutput");
        formatter.field("package_details", &self.package_details);
        formatter.finish()
    }
}
/// See [`UpdatePackageOutput`](crate::output::UpdatePackageOutput)
pub mod update_package_output {
    /// A builder for [`UpdatePackageOutput`](crate::output::UpdatePackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_details: std::option::Option<crate::model::PackageDetails>,
    }
    impl Builder {
        /// <p>Information about the package <code>PackageDetails</code>.</p>
        pub fn package_details(mut self, input: crate::model::PackageDetails) -> Self {
            self.package_details = Some(input);
            self
        }
        /// <p>Information about the package <code>PackageDetails</code>.</p>
        pub fn set_package_details(
            mut self,
            input: std::option::Option<crate::model::PackageDetails>,
        ) -> Self {
            self.package_details = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePackageOutput`](crate::output::UpdatePackageOutput)
        pub fn build(self) -> crate::output::UpdatePackageOutput {
            crate::output::UpdatePackageOutput {
                package_details: self.package_details,
            }
        }
    }
}
impl UpdatePackageOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePackageOutput`](crate::output::UpdatePackageOutput)
    pub fn builder() -> crate::output::update_package_output::Builder {
        crate::output::update_package_output::Builder::default()
    }
}

/// <p>The result of an <code>UpdateElasticsearchDomain</code> request. Contains the status of the Elasticsearch domain being updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateElasticsearchDomainConfigOutput {
    /// <p>The status of the updated Elasticsearch domain. </p>
    pub domain_config: std::option::Option<crate::model::ElasticsearchDomainConfig>,
}
impl std::fmt::Debug for UpdateElasticsearchDomainConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateElasticsearchDomainConfigOutput");
        formatter.field("domain_config", &self.domain_config);
        formatter.finish()
    }
}
/// See [`UpdateElasticsearchDomainConfigOutput`](crate::output::UpdateElasticsearchDomainConfigOutput)
pub mod update_elasticsearch_domain_config_output {
    /// A builder for [`UpdateElasticsearchDomainConfigOutput`](crate::output::UpdateElasticsearchDomainConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_config: std::option::Option<crate::model::ElasticsearchDomainConfig>,
    }
    impl Builder {
        /// <p>The status of the updated Elasticsearch domain. </p>
        pub fn domain_config(mut self, input: crate::model::ElasticsearchDomainConfig) -> Self {
            self.domain_config = Some(input);
            self
        }
        /// <p>The status of the updated Elasticsearch domain. </p>
        pub fn set_domain_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDomainConfig>,
        ) -> Self {
            self.domain_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateElasticsearchDomainConfigOutput`](crate::output::UpdateElasticsearchDomainConfigOutput)
        pub fn build(self) -> crate::output::UpdateElasticsearchDomainConfigOutput {
            crate::output::UpdateElasticsearchDomainConfigOutput {
                domain_config: self.domain_config,
            }
        }
    }
}
impl UpdateElasticsearchDomainConfigOutput {
    /// Creates a new builder-style object to manufacture [`UpdateElasticsearchDomainConfigOutput`](crate::output::UpdateElasticsearchDomainConfigOutput)
    pub fn builder() -> crate::output::update_elasticsearch_domain_config_output::Builder {
        crate::output::update_elasticsearch_domain_config_output::Builder::default()
    }
}

/// <p>The result of a <code>StartElasticsearchServiceSoftwareUpdate</code> operation. Contains the status of the update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartElasticsearchServiceSoftwareUpdateOutput {
    /// <p>The current status of the Elasticsearch service software update.</p>
    pub service_software_options: std::option::Option<crate::model::ServiceSoftwareOptions>,
}
impl std::fmt::Debug for StartElasticsearchServiceSoftwareUpdateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartElasticsearchServiceSoftwareUpdateOutput");
        formatter.field("service_software_options", &self.service_software_options);
        formatter.finish()
    }
}
/// See [`StartElasticsearchServiceSoftwareUpdateOutput`](crate::output::StartElasticsearchServiceSoftwareUpdateOutput)
pub mod start_elasticsearch_service_software_update_output {
    /// A builder for [`StartElasticsearchServiceSoftwareUpdateOutput`](crate::output::StartElasticsearchServiceSoftwareUpdateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_software_options:
            std::option::Option<crate::model::ServiceSoftwareOptions>,
    }
    impl Builder {
        /// <p>The current status of the Elasticsearch service software update.</p>
        pub fn service_software_options(
            mut self,
            input: crate::model::ServiceSoftwareOptions,
        ) -> Self {
            self.service_software_options = Some(input);
            self
        }
        /// <p>The current status of the Elasticsearch service software update.</p>
        pub fn set_service_software_options(
            mut self,
            input: std::option::Option<crate::model::ServiceSoftwareOptions>,
        ) -> Self {
            self.service_software_options = input;
            self
        }
        /// Consumes the builder and constructs a [`StartElasticsearchServiceSoftwareUpdateOutput`](crate::output::StartElasticsearchServiceSoftwareUpdateOutput)
        pub fn build(self) -> crate::output::StartElasticsearchServiceSoftwareUpdateOutput {
            crate::output::StartElasticsearchServiceSoftwareUpdateOutput {
                service_software_options: self.service_software_options,
            }
        }
    }
}
impl StartElasticsearchServiceSoftwareUpdateOutput {
    /// Creates a new builder-style object to manufacture [`StartElasticsearchServiceSoftwareUpdateOutput`](crate::output::StartElasticsearchServiceSoftwareUpdateOutput)
    pub fn builder() -> crate::output::start_elasticsearch_service_software_update_output::Builder {
        crate::output::start_elasticsearch_service_software_update_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsOutput {}
impl std::fmt::Debug for RemoveTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsOutput");
        formatter.finish()
    }
}
/// See [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
pub mod remove_tags_output {
    /// A builder for [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
        pub fn build(self) -> crate::output::RemoveTagsOutput {
            crate::output::RemoveTagsOutput {}
        }
    }
}
impl RemoveTagsOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
    pub fn builder() -> crate::output::remove_tags_output::Builder {
        crate::output::remove_tags_output::Builder::default()
    }
}

/// <p>The result of a <code><a>RejectInboundCrossClusterSearchConnection</a></code> operation. Contains details of rejected inbound connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectInboundCrossClusterSearchConnectionOutput {
    /// <p>Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of rejected inbound connection. </p>
    pub cross_cluster_search_connection:
        std::option::Option<crate::model::InboundCrossClusterSearchConnection>,
}
impl std::fmt::Debug for RejectInboundCrossClusterSearchConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectInboundCrossClusterSearchConnectionOutput");
        formatter.field(
            "cross_cluster_search_connection",
            &self.cross_cluster_search_connection,
        );
        formatter.finish()
    }
}
/// See [`RejectInboundCrossClusterSearchConnectionOutput`](crate::output::RejectInboundCrossClusterSearchConnectionOutput)
pub mod reject_inbound_cross_cluster_search_connection_output {
    /// A builder for [`RejectInboundCrossClusterSearchConnectionOutput`](crate::output::RejectInboundCrossClusterSearchConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_cluster_search_connection:
            std::option::Option<crate::model::InboundCrossClusterSearchConnection>,
    }
    impl Builder {
        /// <p>Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of rejected inbound connection. </p>
        pub fn cross_cluster_search_connection(
            mut self,
            input: crate::model::InboundCrossClusterSearchConnection,
        ) -> Self {
            self.cross_cluster_search_connection = Some(input);
            self
        }
        /// <p>Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of rejected inbound connection. </p>
        pub fn set_cross_cluster_search_connection(
            mut self,
            input: std::option::Option<crate::model::InboundCrossClusterSearchConnection>,
        ) -> Self {
            self.cross_cluster_search_connection = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectInboundCrossClusterSearchConnectionOutput`](crate::output::RejectInboundCrossClusterSearchConnectionOutput)
        pub fn build(self) -> crate::output::RejectInboundCrossClusterSearchConnectionOutput {
            crate::output::RejectInboundCrossClusterSearchConnectionOutput {
                cross_cluster_search_connection: self.cross_cluster_search_connection,
            }
        }
    }
}
impl RejectInboundCrossClusterSearchConnectionOutput {
    /// Creates a new builder-style object to manufacture [`RejectInboundCrossClusterSearchConnectionOutput`](crate::output::RejectInboundCrossClusterSearchConnectionOutput)
    pub fn builder() -> crate::output::reject_inbound_cross_cluster_search_connection_output::Builder
    {
        crate::output::reject_inbound_cross_cluster_search_connection_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>PurchaseReservedElasticsearchInstanceOffering</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseReservedElasticsearchInstanceOfferingOutput {
    /// <p>Details of the reserved Elasticsearch instance which was purchased.</p>
    pub reserved_elasticsearch_instance_id: std::option::Option<std::string::String>,
    /// <p>The customer-specified identifier used to track this reservation.</p>
    pub reservation_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PurchaseReservedElasticsearchInstanceOfferingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseReservedElasticsearchInstanceOfferingOutput");
        formatter.field(
            "reserved_elasticsearch_instance_id",
            &self.reserved_elasticsearch_instance_id,
        );
        formatter.field("reservation_name", &self.reservation_name);
        formatter.finish()
    }
}
/// See [`PurchaseReservedElasticsearchInstanceOfferingOutput`](crate::output::PurchaseReservedElasticsearchInstanceOfferingOutput)
pub mod purchase_reserved_elasticsearch_instance_offering_output {
    /// A builder for [`PurchaseReservedElasticsearchInstanceOfferingOutput`](crate::output::PurchaseReservedElasticsearchInstanceOfferingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_elasticsearch_instance_id: std::option::Option<std::string::String>,
        pub(crate) reservation_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Details of the reserved Elasticsearch instance which was purchased.</p>
        pub fn reserved_elasticsearch_instance_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_id = Some(input.into());
            self
        }
        /// <p>Details of the reserved Elasticsearch instance which was purchased.</p>
        pub fn set_reserved_elasticsearch_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_elasticsearch_instance_id = input;
            self
        }
        /// <p>The customer-specified identifier used to track this reservation.</p>
        pub fn reservation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_name = Some(input.into());
            self
        }
        /// <p>The customer-specified identifier used to track this reservation.</p>
        pub fn set_reservation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseReservedElasticsearchInstanceOfferingOutput`](crate::output::PurchaseReservedElasticsearchInstanceOfferingOutput)
        pub fn build(self) -> crate::output::PurchaseReservedElasticsearchInstanceOfferingOutput {
            crate::output::PurchaseReservedElasticsearchInstanceOfferingOutput {
                reserved_elasticsearch_instance_id: self.reserved_elasticsearch_instance_id,
                reservation_name: self.reservation_name,
            }
        }
    }
}
impl PurchaseReservedElasticsearchInstanceOfferingOutput {
    /// Creates a new builder-style object to manufacture [`PurchaseReservedElasticsearchInstanceOfferingOutput`](crate::output::PurchaseReservedElasticsearchInstanceOfferingOutput)
    pub fn builder(
    ) -> crate::output::purchase_reserved_elasticsearch_instance_offering_output::Builder {
        crate::output::purchase_reserved_elasticsearch_instance_offering_output::Builder::default()
    }
}

/// <p>The result of a <code>ListTags</code> operation. Contains tags for all requested Elasticsearch domains.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsOutput {
    /// <p> List of <code>Tag</code> for the requested Elasticsearch domain.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for ListTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsOutput");
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`ListTagsOutput`](crate::output::ListTagsOutput)
pub mod list_tags_output {
    /// A builder for [`ListTagsOutput`](crate::output::ListTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p> List of <code>Tag</code> for the requested Elasticsearch domain.</p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p> List of <code>Tag</code> for the requested Elasticsearch domain.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsOutput`](crate::output::ListTagsOutput)
        pub fn build(self) -> crate::output::ListTagsOutput {
            crate::output::ListTagsOutput {
                tag_list: self.tag_list,
            }
        }
    }
}
impl ListTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsOutput`](crate::output::ListTagsOutput)
    pub fn builder() -> crate::output::list_tags_output::Builder {
        crate::output::list_tags_output::Builder::default()
    }
}

/// <p>
/// Container for response parameters to
/// <code>
/// <a>ListPackagesForDomain</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackagesForDomainOutput {
    /// <p>List of <code>DomainPackageDetails</code> objects.</p>
    pub domain_package_details_list:
        std::option::Option<std::vec::Vec<crate::model::DomainPackageDetails>>,
    /// <p>Pagination token that needs to be supplied to the next call to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListPackagesForDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackagesForDomainOutput");
        formatter.field(
            "domain_package_details_list",
            &self.domain_package_details_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPackagesForDomainOutput`](crate::output::ListPackagesForDomainOutput)
pub mod list_packages_for_domain_output {
    /// A builder for [`ListPackagesForDomainOutput`](crate::output::ListPackagesForDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_package_details_list:
            std::option::Option<std::vec::Vec<crate::model::DomainPackageDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `domain_package_details_list`.
        ///
        /// To override the contents of this collection use [`set_domain_package_details_list`](Self::set_domain_package_details_list).
        ///
        /// <p>List of <code>DomainPackageDetails</code> objects.</p>
        pub fn domain_package_details_list(
            mut self,
            input: impl Into<crate::model::DomainPackageDetails>,
        ) -> Self {
            let mut v = self.domain_package_details_list.unwrap_or_default();
            v.push(input.into());
            self.domain_package_details_list = Some(v);
            self
        }
        /// <p>List of <code>DomainPackageDetails</code> objects.</p>
        pub fn set_domain_package_details_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainPackageDetails>>,
        ) -> Self {
            self.domain_package_details_list = input;
            self
        }
        /// <p>Pagination token that needs to be supplied to the next call to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token that needs to be supplied to the next call to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackagesForDomainOutput`](crate::output::ListPackagesForDomainOutput)
        pub fn build(self) -> crate::output::ListPackagesForDomainOutput {
            crate::output::ListPackagesForDomainOutput {
                domain_package_details_list: self.domain_package_details_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPackagesForDomainOutput {
    /// Creates a new builder-style object to manufacture [`ListPackagesForDomainOutput`](crate::output::ListPackagesForDomainOutput)
    pub fn builder() -> crate::output::list_packages_for_domain_output::Builder {
        crate::output::list_packages_for_domain_output::Builder::default()
    }
}

/// <p>
/// Container for the parameters for response received from
/// <code>
/// <a>ListElasticsearchVersions</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListElasticsearchVersionsOutput {
    /// <p>List of supported elastic search versions.
    /// </p>
    pub elasticsearch_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// Paginated APIs accepts NextToken input to returns next page results and provides
    /// a NextToken output in the response which can be used by the client to retrieve more results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListElasticsearchVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListElasticsearchVersionsOutput");
        formatter.field("elasticsearch_versions", &self.elasticsearch_versions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListElasticsearchVersionsOutput`](crate::output::ListElasticsearchVersionsOutput)
pub mod list_elasticsearch_versions_output {
    /// A builder for [`ListElasticsearchVersionsOutput`](crate::output::ListElasticsearchVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elasticsearch_versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `elasticsearch_versions`.
        ///
        /// To override the contents of this collection use [`set_elasticsearch_versions`](Self::set_elasticsearch_versions).
        ///
        /// <p>List of supported elastic search versions.
        /// </p>
        pub fn elasticsearch_versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.elasticsearch_versions.unwrap_or_default();
            v.push(input.into());
            self.elasticsearch_versions = Some(v);
            self
        }
        /// <p>List of supported elastic search versions.
        /// </p>
        pub fn set_elasticsearch_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.elasticsearch_versions = input;
            self
        }
        /// <p>
        /// Paginated APIs accepts NextToken input to returns next page results and provides
        /// a NextToken output in the response which can be used by the client to retrieve more results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// Paginated APIs accepts NextToken input to returns next page results and provides
        /// a NextToken output in the response which can be used by the client to retrieve more results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListElasticsearchVersionsOutput`](crate::output::ListElasticsearchVersionsOutput)
        pub fn build(self) -> crate::output::ListElasticsearchVersionsOutput {
            crate::output::ListElasticsearchVersionsOutput {
                elasticsearch_versions: self.elasticsearch_versions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListElasticsearchVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListElasticsearchVersionsOutput`](crate::output::ListElasticsearchVersionsOutput)
    pub fn builder() -> crate::output::list_elasticsearch_versions_output::Builder {
        crate::output::list_elasticsearch_versions_output::Builder::default()
    }
}

/// <p>
/// Container for the parameters returned by
/// <code>
/// <a>ListElasticsearchInstanceTypes</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListElasticsearchInstanceTypesOutput {
    /// <p>
    /// List of instance types supported by Amazon Elasticsearch service for
    /// given
    /// <code>
    /// <a>ElasticsearchVersion</a>
    /// </code>
    /// </p>
    pub elasticsearch_instance_types:
        std::option::Option<std::vec::Vec<crate::model::EsPartitionInstanceType>>,
    /// <p>In case if there are more results available NextToken would be
    /// present, make further request to the same API with
    /// received NextToken to paginate remaining results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListElasticsearchInstanceTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListElasticsearchInstanceTypesOutput");
        formatter.field(
            "elasticsearch_instance_types",
            &self.elasticsearch_instance_types,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListElasticsearchInstanceTypesOutput`](crate::output::ListElasticsearchInstanceTypesOutput)
pub mod list_elasticsearch_instance_types_output {
    /// A builder for [`ListElasticsearchInstanceTypesOutput`](crate::output::ListElasticsearchInstanceTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elasticsearch_instance_types:
            std::option::Option<std::vec::Vec<crate::model::EsPartitionInstanceType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `elasticsearch_instance_types`.
        ///
        /// To override the contents of this collection use [`set_elasticsearch_instance_types`](Self::set_elasticsearch_instance_types).
        ///
        /// <p>
        /// List of instance types supported by Amazon Elasticsearch service for
        /// given
        /// <code>
        /// <a>ElasticsearchVersion</a>
        /// </code>
        /// </p>
        pub fn elasticsearch_instance_types(
            mut self,
            input: impl Into<crate::model::EsPartitionInstanceType>,
        ) -> Self {
            let mut v = self.elasticsearch_instance_types.unwrap_or_default();
            v.push(input.into());
            self.elasticsearch_instance_types = Some(v);
            self
        }
        /// <p>
        /// List of instance types supported by Amazon Elasticsearch service for
        /// given
        /// <code>
        /// <a>ElasticsearchVersion</a>
        /// </code>
        /// </p>
        pub fn set_elasticsearch_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EsPartitionInstanceType>>,
        ) -> Self {
            self.elasticsearch_instance_types = input;
            self
        }
        /// <p>In case if there are more results available NextToken would be
        /// present, make further request to the same API with
        /// received NextToken to paginate remaining results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>In case if there are more results available NextToken would be
        /// present, make further request to the same API with
        /// received NextToken to paginate remaining results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListElasticsearchInstanceTypesOutput`](crate::output::ListElasticsearchInstanceTypesOutput)
        pub fn build(self) -> crate::output::ListElasticsearchInstanceTypesOutput {
            crate::output::ListElasticsearchInstanceTypesOutput {
                elasticsearch_instance_types: self.elasticsearch_instance_types,
                next_token: self.next_token,
            }
        }
    }
}
impl ListElasticsearchInstanceTypesOutput {
    /// Creates a new builder-style object to manufacture [`ListElasticsearchInstanceTypesOutput`](crate::output::ListElasticsearchInstanceTypesOutput)
    pub fn builder() -> crate::output::list_elasticsearch_instance_types_output::Builder {
        crate::output::list_elasticsearch_instance_types_output::Builder::default()
    }
}

/// <p>
/// Container for response parameters to
/// <code>
/// <a>ListDomainsForPackage</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainsForPackageOutput {
    /// <p>List of <code>DomainPackageDetails</code> objects.</p>
    pub domain_package_details_list:
        std::option::Option<std::vec::Vec<crate::model::DomainPackageDetails>>,
    #[allow(missing_docs)] // documentation missing in model
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDomainsForPackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainsForPackageOutput");
        formatter.field(
            "domain_package_details_list",
            &self.domain_package_details_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDomainsForPackageOutput`](crate::output::ListDomainsForPackageOutput)
pub mod list_domains_for_package_output {
    /// A builder for [`ListDomainsForPackageOutput`](crate::output::ListDomainsForPackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_package_details_list:
            std::option::Option<std::vec::Vec<crate::model::DomainPackageDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `domain_package_details_list`.
        ///
        /// To override the contents of this collection use [`set_domain_package_details_list`](Self::set_domain_package_details_list).
        ///
        /// <p>List of <code>DomainPackageDetails</code> objects.</p>
        pub fn domain_package_details_list(
            mut self,
            input: impl Into<crate::model::DomainPackageDetails>,
        ) -> Self {
            let mut v = self.domain_package_details_list.unwrap_or_default();
            v.push(input.into());
            self.domain_package_details_list = Some(v);
            self
        }
        /// <p>List of <code>DomainPackageDetails</code> objects.</p>
        pub fn set_domain_package_details_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainPackageDetails>>,
        ) -> Self {
            self.domain_package_details_list = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainsForPackageOutput`](crate::output::ListDomainsForPackageOutput)
        pub fn build(self) -> crate::output::ListDomainsForPackageOutput {
            crate::output::ListDomainsForPackageOutput {
                domain_package_details_list: self.domain_package_details_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDomainsForPackageOutput {
    /// Creates a new builder-style object to manufacture [`ListDomainsForPackageOutput`](crate::output::ListDomainsForPackageOutput)
    pub fn builder() -> crate::output::list_domains_for_package_output::Builder {
        crate::output::list_domains_for_package_output::Builder::default()
    }
}

/// <p>The result of a <code>ListDomainNames</code> operation. Contains the names of all domains owned by this account and their respective engine types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainNamesOutput {
    /// <p>List of domain names and respective engine types.</p>
    pub domain_names: std::option::Option<std::vec::Vec<crate::model::DomainInfo>>,
}
impl std::fmt::Debug for ListDomainNamesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainNamesOutput");
        formatter.field("domain_names", &self.domain_names);
        formatter.finish()
    }
}
/// See [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput)
pub mod list_domain_names_output {
    /// A builder for [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_names: std::option::Option<std::vec::Vec<crate::model::DomainInfo>>,
    }
    impl Builder {
        /// Appends an item to `domain_names`.
        ///
        /// To override the contents of this collection use [`set_domain_names`](Self::set_domain_names).
        ///
        /// <p>List of domain names and respective engine types.</p>
        pub fn domain_names(mut self, input: impl Into<crate::model::DomainInfo>) -> Self {
            let mut v = self.domain_names.unwrap_or_default();
            v.push(input.into());
            self.domain_names = Some(v);
            self
        }
        /// <p>List of domain names and respective engine types.</p>
        pub fn set_domain_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainInfo>>,
        ) -> Self {
            self.domain_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput)
        pub fn build(self) -> crate::output::ListDomainNamesOutput {
            crate::output::ListDomainNamesOutput {
                domain_names: self.domain_names,
            }
        }
    }
}
impl ListDomainNamesOutput {
    /// Creates a new builder-style object to manufacture [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput)
    pub fn builder() -> crate::output::list_domain_names_output::Builder {
        crate::output::list_domain_names_output::Builder::default()
    }
}

/// <p>
/// Container for response returned by
/// <code>
/// <a>GetUpgradeStatus</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUpgradeStatusOutput {
    /// <p>
    /// Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does through:
    /// <ul>
    /// <li>PreUpgradeCheck</li>
    /// <li>Snapshot</li>
    /// <li>Upgrade</li>
    /// </ul>
    /// </p>
    pub upgrade_step: std::option::Option<crate::model::UpgradeStep>,
    /// <p>
    /// One of 4 statuses that a step can go through returned as part of the
    /// <code>
    /// <a>GetUpgradeStatusResponse</a>
    /// </code>
    /// object. The status can take one of the following values:
    /// <ul>
    /// <li>In Progress</li>
    /// <li>Succeeded</li>
    /// <li>Succeeded with Issues</li>
    /// <li>Failed</li>
    /// </ul>
    /// </p>
    pub step_status: std::option::Option<crate::model::UpgradeStatus>,
    /// <p>A string that describes the update briefly</p>
    pub upgrade_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetUpgradeStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUpgradeStatusOutput");
        formatter.field("upgrade_step", &self.upgrade_step);
        formatter.field("step_status", &self.step_status);
        formatter.field("upgrade_name", &self.upgrade_name);
        formatter.finish()
    }
}
/// See [`GetUpgradeStatusOutput`](crate::output::GetUpgradeStatusOutput)
pub mod get_upgrade_status_output {
    /// A builder for [`GetUpgradeStatusOutput`](crate::output::GetUpgradeStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upgrade_step: std::option::Option<crate::model::UpgradeStep>,
        pub(crate) step_status: std::option::Option<crate::model::UpgradeStatus>,
        pub(crate) upgrade_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does through:
        /// <ul>
        /// <li>PreUpgradeCheck</li>
        /// <li>Snapshot</li>
        /// <li>Upgrade</li>
        /// </ul>
        /// </p>
        pub fn upgrade_step(mut self, input: crate::model::UpgradeStep) -> Self {
            self.upgrade_step = Some(input);
            self
        }
        /// <p>
        /// Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does through:
        /// <ul>
        /// <li>PreUpgradeCheck</li>
        /// <li>Snapshot</li>
        /// <li>Upgrade</li>
        /// </ul>
        /// </p>
        pub fn set_upgrade_step(
            mut self,
            input: std::option::Option<crate::model::UpgradeStep>,
        ) -> Self {
            self.upgrade_step = input;
            self
        }
        /// <p>
        /// One of 4 statuses that a step can go through returned as part of the
        /// <code>
        /// <a>GetUpgradeStatusResponse</a>
        /// </code>
        /// object. The status can take one of the following values:
        /// <ul>
        /// <li>In Progress</li>
        /// <li>Succeeded</li>
        /// <li>Succeeded with Issues</li>
        /// <li>Failed</li>
        /// </ul>
        /// </p>
        pub fn step_status(mut self, input: crate::model::UpgradeStatus) -> Self {
            self.step_status = Some(input);
            self
        }
        /// <p>
        /// One of 4 statuses that a step can go through returned as part of the
        /// <code>
        /// <a>GetUpgradeStatusResponse</a>
        /// </code>
        /// object. The status can take one of the following values:
        /// <ul>
        /// <li>In Progress</li>
        /// <li>Succeeded</li>
        /// <li>Succeeded with Issues</li>
        /// <li>Failed</li>
        /// </ul>
        /// </p>
        pub fn set_step_status(
            mut self,
            input: std::option::Option<crate::model::UpgradeStatus>,
        ) -> Self {
            self.step_status = input;
            self
        }
        /// <p>A string that describes the update briefly</p>
        pub fn upgrade_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.upgrade_name = Some(input.into());
            self
        }
        /// <p>A string that describes the update briefly</p>
        pub fn set_upgrade_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upgrade_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUpgradeStatusOutput`](crate::output::GetUpgradeStatusOutput)
        pub fn build(self) -> crate::output::GetUpgradeStatusOutput {
            crate::output::GetUpgradeStatusOutput {
                upgrade_step: self.upgrade_step,
                step_status: self.step_status,
                upgrade_name: self.upgrade_name,
            }
        }
    }
}
impl GetUpgradeStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetUpgradeStatusOutput`](crate::output::GetUpgradeStatusOutput)
    pub fn builder() -> crate::output::get_upgrade_status_output::Builder {
        crate::output::get_upgrade_status_output::Builder::default()
    }
}

/// <p>
/// Container for response returned by
/// <code>
/// <a>GetUpgradeHistory</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUpgradeHistoryOutput {
    /// <p>
    /// A list of
    /// <code>
    /// <a>UpgradeHistory</a>
    /// </code>
    /// objects corresponding to each Upgrade or Upgrade Eligibility Check performed on a domain returned as part of
    /// <code>
    /// <a>GetUpgradeHistoryResponse</a>
    /// </code>
    /// object.
    /// </p>
    pub upgrade_histories: std::option::Option<std::vec::Vec<crate::model::UpgradeHistory>>,
    /// <p>Pagination token that needs to be supplied to the next call to get the next page of results</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetUpgradeHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUpgradeHistoryOutput");
        formatter.field("upgrade_histories", &self.upgrade_histories);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetUpgradeHistoryOutput`](crate::output::GetUpgradeHistoryOutput)
pub mod get_upgrade_history_output {
    /// A builder for [`GetUpgradeHistoryOutput`](crate::output::GetUpgradeHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upgrade_histories:
            std::option::Option<std::vec::Vec<crate::model::UpgradeHistory>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `upgrade_histories`.
        ///
        /// To override the contents of this collection use [`set_upgrade_histories`](Self::set_upgrade_histories).
        ///
        /// <p>
        /// A list of
        /// <code>
        /// <a>UpgradeHistory</a>
        /// </code>
        /// objects corresponding to each Upgrade or Upgrade Eligibility Check performed on a domain returned as part of
        /// <code>
        /// <a>GetUpgradeHistoryResponse</a>
        /// </code>
        /// object.
        /// </p>
        pub fn upgrade_histories(mut self, input: impl Into<crate::model::UpgradeHistory>) -> Self {
            let mut v = self.upgrade_histories.unwrap_or_default();
            v.push(input.into());
            self.upgrade_histories = Some(v);
            self
        }
        /// <p>
        /// A list of
        /// <code>
        /// <a>UpgradeHistory</a>
        /// </code>
        /// objects corresponding to each Upgrade or Upgrade Eligibility Check performed on a domain returned as part of
        /// <code>
        /// <a>GetUpgradeHistoryResponse</a>
        /// </code>
        /// object.
        /// </p>
        pub fn set_upgrade_histories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpgradeHistory>>,
        ) -> Self {
            self.upgrade_histories = input;
            self
        }
        /// <p>Pagination token that needs to be supplied to the next call to get the next page of results</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token that needs to be supplied to the next call to get the next page of results</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUpgradeHistoryOutput`](crate::output::GetUpgradeHistoryOutput)
        pub fn build(self) -> crate::output::GetUpgradeHistoryOutput {
            crate::output::GetUpgradeHistoryOutput {
                upgrade_histories: self.upgrade_histories,
                next_token: self.next_token,
            }
        }
    }
}
impl GetUpgradeHistoryOutput {
    /// Creates a new builder-style object to manufacture [`GetUpgradeHistoryOutput`](crate::output::GetUpgradeHistoryOutput)
    pub fn builder() -> crate::output::get_upgrade_history_output::Builder {
        crate::output::get_upgrade_history_output::Builder::default()
    }
}

/// <p>
/// Container for response returned by
/// <code>
/// <a>GetPackageVersionHistory</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPackageVersionHistoryOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub package_id: std::option::Option<std::string::String>,
    /// <p>List of <code>PackageVersionHistory</code> objects.</p>
    pub package_version_history_list:
        std::option::Option<std::vec::Vec<crate::model::PackageVersionHistory>>,
    #[allow(missing_docs)] // documentation missing in model
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetPackageVersionHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPackageVersionHistoryOutput");
        formatter.field("package_id", &self.package_id);
        formatter.field(
            "package_version_history_list",
            &self.package_version_history_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetPackageVersionHistoryOutput`](crate::output::GetPackageVersionHistoryOutput)
pub mod get_package_version_history_output {
    /// A builder for [`GetPackageVersionHistoryOutput`](crate::output::GetPackageVersionHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_id: std::option::Option<std::string::String>,
        pub(crate) package_version_history_list:
            std::option::Option<std::vec::Vec<crate::model::PackageVersionHistory>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn package_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_id = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_package_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_id = input;
            self
        }
        /// Appends an item to `package_version_history_list`.
        ///
        /// To override the contents of this collection use [`set_package_version_history_list`](Self::set_package_version_history_list).
        ///
        /// <p>List of <code>PackageVersionHistory</code> objects.</p>
        pub fn package_version_history_list(
            mut self,
            input: impl Into<crate::model::PackageVersionHistory>,
        ) -> Self {
            let mut v = self.package_version_history_list.unwrap_or_default();
            v.push(input.into());
            self.package_version_history_list = Some(v);
            self
        }
        /// <p>List of <code>PackageVersionHistory</code> objects.</p>
        pub fn set_package_version_history_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PackageVersionHistory>>,
        ) -> Self {
            self.package_version_history_list = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPackageVersionHistoryOutput`](crate::output::GetPackageVersionHistoryOutput)
        pub fn build(self) -> crate::output::GetPackageVersionHistoryOutput {
            crate::output::GetPackageVersionHistoryOutput {
                package_id: self.package_id,
                package_version_history_list: self.package_version_history_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetPackageVersionHistoryOutput {
    /// Creates a new builder-style object to manufacture [`GetPackageVersionHistoryOutput`](crate::output::GetPackageVersionHistoryOutput)
    pub fn builder() -> crate::output::get_package_version_history_output::Builder {
        crate::output::get_package_version_history_output::Builder::default()
    }
}

/// <p>
/// Container for response returned by
/// <code>
/// <a>GetCompatibleElasticsearchVersions</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCompatibleElasticsearchVersionsOutput {
    /// <p>
    /// A map of compatible Elasticsearch versions returned as part of the
    /// <code>
    /// <a>GetCompatibleElasticsearchVersions</a>
    /// </code>
    /// operation.
    /// </p>
    pub compatible_elasticsearch_versions:
        std::option::Option<std::vec::Vec<crate::model::CompatibleVersionsMap>>,
}
impl std::fmt::Debug for GetCompatibleElasticsearchVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCompatibleElasticsearchVersionsOutput");
        formatter.field(
            "compatible_elasticsearch_versions",
            &self.compatible_elasticsearch_versions,
        );
        formatter.finish()
    }
}
/// See [`GetCompatibleElasticsearchVersionsOutput`](crate::output::GetCompatibleElasticsearchVersionsOutput)
pub mod get_compatible_elasticsearch_versions_output {
    /// A builder for [`GetCompatibleElasticsearchVersionsOutput`](crate::output::GetCompatibleElasticsearchVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compatible_elasticsearch_versions:
            std::option::Option<std::vec::Vec<crate::model::CompatibleVersionsMap>>,
    }
    impl Builder {
        /// Appends an item to `compatible_elasticsearch_versions`.
        ///
        /// To override the contents of this collection use [`set_compatible_elasticsearch_versions`](Self::set_compatible_elasticsearch_versions).
        ///
        /// <p>
        /// A map of compatible Elasticsearch versions returned as part of the
        /// <code>
        /// <a>GetCompatibleElasticsearchVersions</a>
        /// </code>
        /// operation.
        /// </p>
        pub fn compatible_elasticsearch_versions(
            mut self,
            input: impl Into<crate::model::CompatibleVersionsMap>,
        ) -> Self {
            let mut v = self.compatible_elasticsearch_versions.unwrap_or_default();
            v.push(input.into());
            self.compatible_elasticsearch_versions = Some(v);
            self
        }
        /// <p>
        /// A map of compatible Elasticsearch versions returned as part of the
        /// <code>
        /// <a>GetCompatibleElasticsearchVersions</a>
        /// </code>
        /// operation.
        /// </p>
        pub fn set_compatible_elasticsearch_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CompatibleVersionsMap>>,
        ) -> Self {
            self.compatible_elasticsearch_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCompatibleElasticsearchVersionsOutput`](crate::output::GetCompatibleElasticsearchVersionsOutput)
        pub fn build(self) -> crate::output::GetCompatibleElasticsearchVersionsOutput {
            crate::output::GetCompatibleElasticsearchVersionsOutput {
                compatible_elasticsearch_versions: self.compatible_elasticsearch_versions,
            }
        }
    }
}
impl GetCompatibleElasticsearchVersionsOutput {
    /// Creates a new builder-style object to manufacture [`GetCompatibleElasticsearchVersionsOutput`](crate::output::GetCompatibleElasticsearchVersionsOutput)
    pub fn builder() -> crate::output::get_compatible_elasticsearch_versions_output::Builder {
        crate::output::get_compatible_elasticsearch_versions_output::Builder::default()
    }
}

/// <p>
/// Container for response returned by
/// <code>
/// <a>DissociatePackage</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DissociatePackageOutput {
    /// <p><code>DomainPackageDetails</code></p>
    pub domain_package_details: std::option::Option<crate::model::DomainPackageDetails>,
}
impl std::fmt::Debug for DissociatePackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DissociatePackageOutput");
        formatter.field("domain_package_details", &self.domain_package_details);
        formatter.finish()
    }
}
/// See [`DissociatePackageOutput`](crate::output::DissociatePackageOutput)
pub mod dissociate_package_output {
    /// A builder for [`DissociatePackageOutput`](crate::output::DissociatePackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_package_details: std::option::Option<crate::model::DomainPackageDetails>,
    }
    impl Builder {
        /// <p><code>DomainPackageDetails</code></p>
        pub fn domain_package_details(mut self, input: crate::model::DomainPackageDetails) -> Self {
            self.domain_package_details = Some(input);
            self
        }
        /// <p><code>DomainPackageDetails</code></p>
        pub fn set_domain_package_details(
            mut self,
            input: std::option::Option<crate::model::DomainPackageDetails>,
        ) -> Self {
            self.domain_package_details = input;
            self
        }
        /// Consumes the builder and constructs a [`DissociatePackageOutput`](crate::output::DissociatePackageOutput)
        pub fn build(self) -> crate::output::DissociatePackageOutput {
            crate::output::DissociatePackageOutput {
                domain_package_details: self.domain_package_details,
            }
        }
    }
}
impl DissociatePackageOutput {
    /// Creates a new builder-style object to manufacture [`DissociatePackageOutput`](crate::output::DissociatePackageOutput)
    pub fn builder() -> crate::output::dissociate_package_output::Builder {
        crate::output::dissociate_package_output::Builder::default()
    }
}

/// <p>Container for results from <code>DescribeReservedElasticsearchInstances</code></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedElasticsearchInstancesOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>List of reserved Elasticsearch instances.</p>
    pub reserved_elasticsearch_instances:
        std::option::Option<std::vec::Vec<crate::model::ReservedElasticsearchInstance>>,
}
impl std::fmt::Debug for DescribeReservedElasticsearchInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedElasticsearchInstancesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field(
            "reserved_elasticsearch_instances",
            &self.reserved_elasticsearch_instances,
        );
        formatter.finish()
    }
}
/// See [`DescribeReservedElasticsearchInstancesOutput`](crate::output::DescribeReservedElasticsearchInstancesOutput)
pub mod describe_reserved_elasticsearch_instances_output {
    /// A builder for [`DescribeReservedElasticsearchInstancesOutput`](crate::output::DescribeReservedElasticsearchInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) reserved_elasticsearch_instances:
            std::option::Option<std::vec::Vec<crate::model::ReservedElasticsearchInstance>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `reserved_elasticsearch_instances`.
        ///
        /// To override the contents of this collection use [`set_reserved_elasticsearch_instances`](Self::set_reserved_elasticsearch_instances).
        ///
        /// <p>List of reserved Elasticsearch instances.</p>
        pub fn reserved_elasticsearch_instances(
            mut self,
            input: impl Into<crate::model::ReservedElasticsearchInstance>,
        ) -> Self {
            let mut v = self.reserved_elasticsearch_instances.unwrap_or_default();
            v.push(input.into());
            self.reserved_elasticsearch_instances = Some(v);
            self
        }
        /// <p>List of reserved Elasticsearch instances.</p>
        pub fn set_reserved_elasticsearch_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReservedElasticsearchInstance>>,
        ) -> Self {
            self.reserved_elasticsearch_instances = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedElasticsearchInstancesOutput`](crate::output::DescribeReservedElasticsearchInstancesOutput)
        pub fn build(self) -> crate::output::DescribeReservedElasticsearchInstancesOutput {
            crate::output::DescribeReservedElasticsearchInstancesOutput {
                next_token: self.next_token,
                reserved_elasticsearch_instances: self.reserved_elasticsearch_instances,
            }
        }
    }
}
impl DescribeReservedElasticsearchInstancesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReservedElasticsearchInstancesOutput`](crate::output::DescribeReservedElasticsearchInstancesOutput)
    pub fn builder() -> crate::output::describe_reserved_elasticsearch_instances_output::Builder {
        crate::output::describe_reserved_elasticsearch_instances_output::Builder::default()
    }
}

/// <p>Container for results from <code>DescribeReservedElasticsearchInstanceOfferings</code></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedElasticsearchInstanceOfferingsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>List of reserved Elasticsearch instance offerings</p>
    pub reserved_elasticsearch_instance_offerings:
        std::option::Option<std::vec::Vec<crate::model::ReservedElasticsearchInstanceOffering>>,
}
impl std::fmt::Debug for DescribeReservedElasticsearchInstanceOfferingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedElasticsearchInstanceOfferingsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field(
            "reserved_elasticsearch_instance_offerings",
            &self.reserved_elasticsearch_instance_offerings,
        );
        formatter.finish()
    }
}
/// See [`DescribeReservedElasticsearchInstanceOfferingsOutput`](crate::output::DescribeReservedElasticsearchInstanceOfferingsOutput)
pub mod describe_reserved_elasticsearch_instance_offerings_output {
    /// A builder for [`DescribeReservedElasticsearchInstanceOfferingsOutput`](crate::output::DescribeReservedElasticsearchInstanceOfferingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) reserved_elasticsearch_instance_offerings:
            std::option::Option<std::vec::Vec<crate::model::ReservedElasticsearchInstanceOffering>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `reserved_elasticsearch_instance_offerings`.
        ///
        /// To override the contents of this collection use [`set_reserved_elasticsearch_instance_offerings`](Self::set_reserved_elasticsearch_instance_offerings).
        ///
        /// <p>List of reserved Elasticsearch instance offerings</p>
        pub fn reserved_elasticsearch_instance_offerings(
            mut self,
            input: impl Into<crate::model::ReservedElasticsearchInstanceOffering>,
        ) -> Self {
            let mut v = self
                .reserved_elasticsearch_instance_offerings
                .unwrap_or_default();
            v.push(input.into());
            self.reserved_elasticsearch_instance_offerings = Some(v);
            self
        }
        /// <p>List of reserved Elasticsearch instance offerings</p>
        pub fn set_reserved_elasticsearch_instance_offerings(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReservedElasticsearchInstanceOffering>,
            >,
        ) -> Self {
            self.reserved_elasticsearch_instance_offerings = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedElasticsearchInstanceOfferingsOutput`](crate::output::DescribeReservedElasticsearchInstanceOfferingsOutput)
        pub fn build(self) -> crate::output::DescribeReservedElasticsearchInstanceOfferingsOutput {
            crate::output::DescribeReservedElasticsearchInstanceOfferingsOutput {
                next_token: self.next_token,
                reserved_elasticsearch_instance_offerings: self
                    .reserved_elasticsearch_instance_offerings,
            }
        }
    }
}
impl DescribeReservedElasticsearchInstanceOfferingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReservedElasticsearchInstanceOfferingsOutput`](crate::output::DescribeReservedElasticsearchInstanceOfferingsOutput)
    pub fn builder(
    ) -> crate::output::describe_reserved_elasticsearch_instance_offerings_output::Builder {
        crate::output::describe_reserved_elasticsearch_instance_offerings_output::Builder::default()
    }
}

/// <p>
/// Container for response returned by
/// <code>
/// <a>DescribePackages</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackagesOutput {
    /// <p>List of <code>PackageDetails</code> objects.</p>
    pub package_details_list: std::option::Option<std::vec::Vec<crate::model::PackageDetails>>,
    #[allow(missing_docs)] // documentation missing in model
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribePackagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackagesOutput");
        formatter.field("package_details_list", &self.package_details_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribePackagesOutput`](crate::output::DescribePackagesOutput)
pub mod describe_packages_output {
    /// A builder for [`DescribePackagesOutput`](crate::output::DescribePackagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_details_list:
            std::option::Option<std::vec::Vec<crate::model::PackageDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `package_details_list`.
        ///
        /// To override the contents of this collection use [`set_package_details_list`](Self::set_package_details_list).
        ///
        /// <p>List of <code>PackageDetails</code> objects.</p>
        pub fn package_details_list(
            mut self,
            input: impl Into<crate::model::PackageDetails>,
        ) -> Self {
            let mut v = self.package_details_list.unwrap_or_default();
            v.push(input.into());
            self.package_details_list = Some(v);
            self
        }
        /// <p>List of <code>PackageDetails</code> objects.</p>
        pub fn set_package_details_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PackageDetails>>,
        ) -> Self {
            self.package_details_list = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackagesOutput`](crate::output::DescribePackagesOutput)
        pub fn build(self) -> crate::output::DescribePackagesOutput {
            crate::output::DescribePackagesOutput {
                package_details_list: self.package_details_list,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribePackagesOutput {
    /// Creates a new builder-style object to manufacture [`DescribePackagesOutput`](crate::output::DescribePackagesOutput)
    pub fn builder() -> crate::output::describe_packages_output::Builder {
        crate::output::describe_packages_output::Builder::default()
    }
}

/// <p>The result of a <code><a>DescribeOutboundCrossClusterSearchConnections</a></code> request. Contains the list of connections matching the filter criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOutboundCrossClusterSearchConnectionsOutput {
    /// <p>Consists of list of <code><a>OutboundCrossClusterSearchConnection</a></code> matching the specified filter criteria.</p>
    pub cross_cluster_search_connections:
        std::option::Option<std::vec::Vec<crate::model::OutboundCrossClusterSearchConnection>>,
    /// <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeOutboundCrossClusterSearchConnectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOutboundCrossClusterSearchConnectionsOutput");
        formatter.field(
            "cross_cluster_search_connections",
            &self.cross_cluster_search_connections,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeOutboundCrossClusterSearchConnectionsOutput`](crate::output::DescribeOutboundCrossClusterSearchConnectionsOutput)
pub mod describe_outbound_cross_cluster_search_connections_output {
    /// A builder for [`DescribeOutboundCrossClusterSearchConnectionsOutput`](crate::output::DescribeOutboundCrossClusterSearchConnectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_cluster_search_connections:
            std::option::Option<std::vec::Vec<crate::model::OutboundCrossClusterSearchConnection>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `cross_cluster_search_connections`.
        ///
        /// To override the contents of this collection use [`set_cross_cluster_search_connections`](Self::set_cross_cluster_search_connections).
        ///
        /// <p>Consists of list of <code><a>OutboundCrossClusterSearchConnection</a></code> matching the specified filter criteria.</p>
        pub fn cross_cluster_search_connections(
            mut self,
            input: impl Into<crate::model::OutboundCrossClusterSearchConnection>,
        ) -> Self {
            let mut v = self.cross_cluster_search_connections.unwrap_or_default();
            v.push(input.into());
            self.cross_cluster_search_connections = Some(v);
            self
        }
        /// <p>Consists of list of <code><a>OutboundCrossClusterSearchConnection</a></code> matching the specified filter criteria.</p>
        pub fn set_cross_cluster_search_connections(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::OutboundCrossClusterSearchConnection>,
            >,
        ) -> Self {
            self.cross_cluster_search_connections = input;
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOutboundCrossClusterSearchConnectionsOutput`](crate::output::DescribeOutboundCrossClusterSearchConnectionsOutput)
        pub fn build(self) -> crate::output::DescribeOutboundCrossClusterSearchConnectionsOutput {
            crate::output::DescribeOutboundCrossClusterSearchConnectionsOutput {
                cross_cluster_search_connections: self.cross_cluster_search_connections,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeOutboundCrossClusterSearchConnectionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOutboundCrossClusterSearchConnectionsOutput`](crate::output::DescribeOutboundCrossClusterSearchConnectionsOutput)
    pub fn builder(
    ) -> crate::output::describe_outbound_cross_cluster_search_connections_output::Builder {
        crate::output::describe_outbound_cross_cluster_search_connections_output::Builder::default()
    }
}

/// <p>The result of a <code><a>DescribeInboundCrossClusterSearchConnections</a></code> request. Contains the list of connections matching the filter criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInboundCrossClusterSearchConnectionsOutput {
    /// <p>Consists of list of <code><a>InboundCrossClusterSearchConnection</a></code> matching the specified filter criteria.</p>
    pub cross_cluster_search_connections:
        std::option::Option<std::vec::Vec<crate::model::InboundCrossClusterSearchConnection>>,
    /// <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeInboundCrossClusterSearchConnectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInboundCrossClusterSearchConnectionsOutput");
        formatter.field(
            "cross_cluster_search_connections",
            &self.cross_cluster_search_connections,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeInboundCrossClusterSearchConnectionsOutput`](crate::output::DescribeInboundCrossClusterSearchConnectionsOutput)
pub mod describe_inbound_cross_cluster_search_connections_output {
    /// A builder for [`DescribeInboundCrossClusterSearchConnectionsOutput`](crate::output::DescribeInboundCrossClusterSearchConnectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_cluster_search_connections:
            std::option::Option<std::vec::Vec<crate::model::InboundCrossClusterSearchConnection>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `cross_cluster_search_connections`.
        ///
        /// To override the contents of this collection use [`set_cross_cluster_search_connections`](Self::set_cross_cluster_search_connections).
        ///
        /// <p>Consists of list of <code><a>InboundCrossClusterSearchConnection</a></code> matching the specified filter criteria.</p>
        pub fn cross_cluster_search_connections(
            mut self,
            input: impl Into<crate::model::InboundCrossClusterSearchConnection>,
        ) -> Self {
            let mut v = self.cross_cluster_search_connections.unwrap_or_default();
            v.push(input.into());
            self.cross_cluster_search_connections = Some(v);
            self
        }
        /// <p>Consists of list of <code><a>InboundCrossClusterSearchConnection</a></code> matching the specified filter criteria.</p>
        pub fn set_cross_cluster_search_connections(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::InboundCrossClusterSearchConnection>,
            >,
        ) -> Self {
            self.cross_cluster_search_connections = input;
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInboundCrossClusterSearchConnectionsOutput`](crate::output::DescribeInboundCrossClusterSearchConnectionsOutput)
        pub fn build(self) -> crate::output::DescribeInboundCrossClusterSearchConnectionsOutput {
            crate::output::DescribeInboundCrossClusterSearchConnectionsOutput {
                cross_cluster_search_connections: self.cross_cluster_search_connections,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeInboundCrossClusterSearchConnectionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInboundCrossClusterSearchConnectionsOutput`](crate::output::DescribeInboundCrossClusterSearchConnectionsOutput)
    pub fn builder(
    ) -> crate::output::describe_inbound_cross_cluster_search_connections_output::Builder {
        crate::output::describe_inbound_cross_cluster_search_connections_output::Builder::default()
    }
}

/// <p>
/// Container for the parameters received from
/// <code>
/// <a>DescribeElasticsearchInstanceTypeLimits</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeElasticsearchInstanceTypeLimitsOutput {
    /// <p>
    /// Map of Role of the Instance and Limits that are applicable.
    /// Role performed by given Instance in Elasticsearch
    /// can be one of the following:
    /// <ul>
    /// <li>data: If the given InstanceType is used as data node</li>
    /// <li>master: If the given InstanceType is used as master node</li>
    /// <li>ultra_warm: If the given InstanceType is used as warm node</li>
    /// </ul>
    /// </p>
    pub limits_by_role:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Limits>>,
}
impl std::fmt::Debug for DescribeElasticsearchInstanceTypeLimitsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeElasticsearchInstanceTypeLimitsOutput");
        formatter.field("limits_by_role", &self.limits_by_role);
        formatter.finish()
    }
}
/// See [`DescribeElasticsearchInstanceTypeLimitsOutput`](crate::output::DescribeElasticsearchInstanceTypeLimitsOutput)
pub mod describe_elasticsearch_instance_type_limits_output {
    /// A builder for [`DescribeElasticsearchInstanceTypeLimitsOutput`](crate::output::DescribeElasticsearchInstanceTypeLimitsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limits_by_role: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Limits>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `limits_by_role`.
        ///
        /// To override the contents of this collection use [`set_limits_by_role`](Self::set_limits_by_role).
        ///
        /// <p>
        /// Map of Role of the Instance and Limits that are applicable.
        /// Role performed by given Instance in Elasticsearch
        /// can be one of the following:
        /// <ul>
        /// <li>data: If the given InstanceType is used as data node</li>
        /// <li>master: If the given InstanceType is used as master node</li>
        /// <li>ultra_warm: If the given InstanceType is used as warm node</li>
        /// </ul>
        /// </p>
        pub fn limits_by_role(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Limits>,
        ) -> Self {
            let mut hash_map = self.limits_by_role.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.limits_by_role = Some(hash_map);
            self
        }
        /// <p>
        /// Map of Role of the Instance and Limits that are applicable.
        /// Role performed by given Instance in Elasticsearch
        /// can be one of the following:
        /// <ul>
        /// <li>data: If the given InstanceType is used as data node</li>
        /// <li>master: If the given InstanceType is used as master node</li>
        /// <li>ultra_warm: If the given InstanceType is used as warm node</li>
        /// </ul>
        /// </p>
        pub fn set_limits_by_role(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Limits>,
            >,
        ) -> Self {
            self.limits_by_role = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeElasticsearchInstanceTypeLimitsOutput`](crate::output::DescribeElasticsearchInstanceTypeLimitsOutput)
        pub fn build(self) -> crate::output::DescribeElasticsearchInstanceTypeLimitsOutput {
            crate::output::DescribeElasticsearchInstanceTypeLimitsOutput {
                limits_by_role: self.limits_by_role,
            }
        }
    }
}
impl DescribeElasticsearchInstanceTypeLimitsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeElasticsearchInstanceTypeLimitsOutput`](crate::output::DescribeElasticsearchInstanceTypeLimitsOutput)
    pub fn builder() -> crate::output::describe_elasticsearch_instance_type_limits_output::Builder {
        crate::output::describe_elasticsearch_instance_type_limits_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeElasticsearchDomains</code> request. Contains the status of the specified domains or all domains owned by the account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeElasticsearchDomainsOutput {
    /// <p>The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.</p>
    pub domain_status_list:
        std::option::Option<std::vec::Vec<crate::model::ElasticsearchDomainStatus>>,
}
impl std::fmt::Debug for DescribeElasticsearchDomainsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeElasticsearchDomainsOutput");
        formatter.field("domain_status_list", &self.domain_status_list);
        formatter.finish()
    }
}
/// See [`DescribeElasticsearchDomainsOutput`](crate::output::DescribeElasticsearchDomainsOutput)
pub mod describe_elasticsearch_domains_output {
    /// A builder for [`DescribeElasticsearchDomainsOutput`](crate::output::DescribeElasticsearchDomainsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_status_list:
            std::option::Option<std::vec::Vec<crate::model::ElasticsearchDomainStatus>>,
    }
    impl Builder {
        /// Appends an item to `domain_status_list`.
        ///
        /// To override the contents of this collection use [`set_domain_status_list`](Self::set_domain_status_list).
        ///
        /// <p>The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.</p>
        pub fn domain_status_list(
            mut self,
            input: impl Into<crate::model::ElasticsearchDomainStatus>,
        ) -> Self {
            let mut v = self.domain_status_list.unwrap_or_default();
            v.push(input.into());
            self.domain_status_list = Some(v);
            self
        }
        /// <p>The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.</p>
        pub fn set_domain_status_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ElasticsearchDomainStatus>>,
        ) -> Self {
            self.domain_status_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeElasticsearchDomainsOutput`](crate::output::DescribeElasticsearchDomainsOutput)
        pub fn build(self) -> crate::output::DescribeElasticsearchDomainsOutput {
            crate::output::DescribeElasticsearchDomainsOutput {
                domain_status_list: self.domain_status_list,
            }
        }
    }
}
impl DescribeElasticsearchDomainsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeElasticsearchDomainsOutput`](crate::output::DescribeElasticsearchDomainsOutput)
    pub fn builder() -> crate::output::describe_elasticsearch_domains_output::Builder {
        crate::output::describe_elasticsearch_domains_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeElasticsearchDomainConfig</code> request. Contains the configuration information of the requested domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeElasticsearchDomainConfigOutput {
    /// <p>The configuration information of the domain requested in the <code>DescribeElasticsearchDomainConfig</code> request.</p>
    pub domain_config: std::option::Option<crate::model::ElasticsearchDomainConfig>,
}
impl std::fmt::Debug for DescribeElasticsearchDomainConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeElasticsearchDomainConfigOutput");
        formatter.field("domain_config", &self.domain_config);
        formatter.finish()
    }
}
/// See [`DescribeElasticsearchDomainConfigOutput`](crate::output::DescribeElasticsearchDomainConfigOutput)
pub mod describe_elasticsearch_domain_config_output {
    /// A builder for [`DescribeElasticsearchDomainConfigOutput`](crate::output::DescribeElasticsearchDomainConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_config: std::option::Option<crate::model::ElasticsearchDomainConfig>,
    }
    impl Builder {
        /// <p>The configuration information of the domain requested in the <code>DescribeElasticsearchDomainConfig</code> request.</p>
        pub fn domain_config(mut self, input: crate::model::ElasticsearchDomainConfig) -> Self {
            self.domain_config = Some(input);
            self
        }
        /// <p>The configuration information of the domain requested in the <code>DescribeElasticsearchDomainConfig</code> request.</p>
        pub fn set_domain_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDomainConfig>,
        ) -> Self {
            self.domain_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeElasticsearchDomainConfigOutput`](crate::output::DescribeElasticsearchDomainConfigOutput)
        pub fn build(self) -> crate::output::DescribeElasticsearchDomainConfigOutput {
            crate::output::DescribeElasticsearchDomainConfigOutput {
                domain_config: self.domain_config,
            }
        }
    }
}
impl DescribeElasticsearchDomainConfigOutput {
    /// Creates a new builder-style object to manufacture [`DescribeElasticsearchDomainConfigOutput`](crate::output::DescribeElasticsearchDomainConfigOutput)
    pub fn builder() -> crate::output::describe_elasticsearch_domain_config_output::Builder {
        crate::output::describe_elasticsearch_domain_config_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeElasticsearchDomain</code> request. Contains the status of the domain specified in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeElasticsearchDomainOutput {
    /// <p>The current status of the Elasticsearch domain.</p>
    pub domain_status: std::option::Option<crate::model::ElasticsearchDomainStatus>,
}
impl std::fmt::Debug for DescribeElasticsearchDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeElasticsearchDomainOutput");
        formatter.field("domain_status", &self.domain_status);
        formatter.finish()
    }
}
/// See [`DescribeElasticsearchDomainOutput`](crate::output::DescribeElasticsearchDomainOutput)
pub mod describe_elasticsearch_domain_output {
    /// A builder for [`DescribeElasticsearchDomainOutput`](crate::output::DescribeElasticsearchDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_status: std::option::Option<crate::model::ElasticsearchDomainStatus>,
    }
    impl Builder {
        /// <p>The current status of the Elasticsearch domain.</p>
        pub fn domain_status(mut self, input: crate::model::ElasticsearchDomainStatus) -> Self {
            self.domain_status = Some(input);
            self
        }
        /// <p>The current status of the Elasticsearch domain.</p>
        pub fn set_domain_status(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDomainStatus>,
        ) -> Self {
            self.domain_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeElasticsearchDomainOutput`](crate::output::DescribeElasticsearchDomainOutput)
        pub fn build(self) -> crate::output::DescribeElasticsearchDomainOutput {
            crate::output::DescribeElasticsearchDomainOutput {
                domain_status: self.domain_status,
            }
        }
    }
}
impl DescribeElasticsearchDomainOutput {
    /// Creates a new builder-style object to manufacture [`DescribeElasticsearchDomainOutput`](crate::output::DescribeElasticsearchDomainOutput)
    pub fn builder() -> crate::output::describe_elasticsearch_domain_output::Builder {
        crate::output::describe_elasticsearch_domain_output::Builder::default()
    }
}

/// <p>The result of <code>DescribeDomainAutoTunes</code> request. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainAutoTunesOutput {
    /// <p>Specifies the list of setting adjustments that Auto-Tune has made to the domain. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
    pub auto_tunes: std::option::Option<std::vec::Vec<crate::model::AutoTune>>,
    /// <p>Specifies an identifier to allow retrieval of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDomainAutoTunesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainAutoTunesOutput");
        formatter.field("auto_tunes", &self.auto_tunes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDomainAutoTunesOutput`](crate::output::DescribeDomainAutoTunesOutput)
pub mod describe_domain_auto_tunes_output {
    /// A builder for [`DescribeDomainAutoTunesOutput`](crate::output::DescribeDomainAutoTunesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_tunes: std::option::Option<std::vec::Vec<crate::model::AutoTune>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `auto_tunes`.
        ///
        /// To override the contents of this collection use [`set_auto_tunes`](Self::set_auto_tunes).
        ///
        /// <p>Specifies the list of setting adjustments that Auto-Tune has made to the domain. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn auto_tunes(mut self, input: impl Into<crate::model::AutoTune>) -> Self {
            let mut v = self.auto_tunes.unwrap_or_default();
            v.push(input.into());
            self.auto_tunes = Some(v);
            self
        }
        /// <p>Specifies the list of setting adjustments that Auto-Tune has made to the domain. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>
        pub fn set_auto_tunes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoTune>>,
        ) -> Self {
            self.auto_tunes = input;
            self
        }
        /// <p>Specifies an identifier to allow retrieval of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specifies an identifier to allow retrieval of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainAutoTunesOutput`](crate::output::DescribeDomainAutoTunesOutput)
        pub fn build(self) -> crate::output::DescribeDomainAutoTunesOutput {
            crate::output::DescribeDomainAutoTunesOutput {
                auto_tunes: self.auto_tunes,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDomainAutoTunesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDomainAutoTunesOutput`](crate::output::DescribeDomainAutoTunesOutput)
    pub fn builder() -> crate::output::describe_domain_auto_tunes_output::Builder {
        crate::output::describe_domain_auto_tunes_output::Builder::default()
    }
}

/// <p>
/// Container for response parameters to
/// <code>
/// <a>DeletePackage</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePackageOutput {
    /// <p><code>PackageDetails</code></p>
    pub package_details: std::option::Option<crate::model::PackageDetails>,
}
impl std::fmt::Debug for DeletePackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePackageOutput");
        formatter.field("package_details", &self.package_details);
        formatter.finish()
    }
}
/// See [`DeletePackageOutput`](crate::output::DeletePackageOutput)
pub mod delete_package_output {
    /// A builder for [`DeletePackageOutput`](crate::output::DeletePackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_details: std::option::Option<crate::model::PackageDetails>,
    }
    impl Builder {
        /// <p><code>PackageDetails</code></p>
        pub fn package_details(mut self, input: crate::model::PackageDetails) -> Self {
            self.package_details = Some(input);
            self
        }
        /// <p><code>PackageDetails</code></p>
        pub fn set_package_details(
            mut self,
            input: std::option::Option<crate::model::PackageDetails>,
        ) -> Self {
            self.package_details = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePackageOutput`](crate::output::DeletePackageOutput)
        pub fn build(self) -> crate::output::DeletePackageOutput {
            crate::output::DeletePackageOutput {
                package_details: self.package_details,
            }
        }
    }
}
impl DeletePackageOutput {
    /// Creates a new builder-style object to manufacture [`DeletePackageOutput`](crate::output::DeletePackageOutput)
    pub fn builder() -> crate::output::delete_package_output::Builder {
        crate::output::delete_package_output::Builder::default()
    }
}

/// <p>The result of a <code><a>DeleteOutboundCrossClusterSearchConnection</a></code> operation. Contains details of deleted outbound connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOutboundCrossClusterSearchConnectionOutput {
    /// <p>Specifies the <code><a>OutboundCrossClusterSearchConnection</a></code> of deleted outbound connection. </p>
    pub cross_cluster_search_connection:
        std::option::Option<crate::model::OutboundCrossClusterSearchConnection>,
}
impl std::fmt::Debug for DeleteOutboundCrossClusterSearchConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOutboundCrossClusterSearchConnectionOutput");
        formatter.field(
            "cross_cluster_search_connection",
            &self.cross_cluster_search_connection,
        );
        formatter.finish()
    }
}
/// See [`DeleteOutboundCrossClusterSearchConnectionOutput`](crate::output::DeleteOutboundCrossClusterSearchConnectionOutput)
pub mod delete_outbound_cross_cluster_search_connection_output {
    /// A builder for [`DeleteOutboundCrossClusterSearchConnectionOutput`](crate::output::DeleteOutboundCrossClusterSearchConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_cluster_search_connection:
            std::option::Option<crate::model::OutboundCrossClusterSearchConnection>,
    }
    impl Builder {
        /// <p>Specifies the <code><a>OutboundCrossClusterSearchConnection</a></code> of deleted outbound connection. </p>
        pub fn cross_cluster_search_connection(
            mut self,
            input: crate::model::OutboundCrossClusterSearchConnection,
        ) -> Self {
            self.cross_cluster_search_connection = Some(input);
            self
        }
        /// <p>Specifies the <code><a>OutboundCrossClusterSearchConnection</a></code> of deleted outbound connection. </p>
        pub fn set_cross_cluster_search_connection(
            mut self,
            input: std::option::Option<crate::model::OutboundCrossClusterSearchConnection>,
        ) -> Self {
            self.cross_cluster_search_connection = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOutboundCrossClusterSearchConnectionOutput`](crate::output::DeleteOutboundCrossClusterSearchConnectionOutput)
        pub fn build(self) -> crate::output::DeleteOutboundCrossClusterSearchConnectionOutput {
            crate::output::DeleteOutboundCrossClusterSearchConnectionOutput {
                cross_cluster_search_connection: self.cross_cluster_search_connection,
            }
        }
    }
}
impl DeleteOutboundCrossClusterSearchConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteOutboundCrossClusterSearchConnectionOutput`](crate::output::DeleteOutboundCrossClusterSearchConnectionOutput)
    pub fn builder(
    ) -> crate::output::delete_outbound_cross_cluster_search_connection_output::Builder {
        crate::output::delete_outbound_cross_cluster_search_connection_output::Builder::default()
    }
}

/// <p>The result of a <code><a>DeleteInboundCrossClusterSearchConnection</a></code> operation. Contains details of deleted inbound connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInboundCrossClusterSearchConnectionOutput {
    /// <p>Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of deleted inbound connection. </p>
    pub cross_cluster_search_connection:
        std::option::Option<crate::model::InboundCrossClusterSearchConnection>,
}
impl std::fmt::Debug for DeleteInboundCrossClusterSearchConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInboundCrossClusterSearchConnectionOutput");
        formatter.field(
            "cross_cluster_search_connection",
            &self.cross_cluster_search_connection,
        );
        formatter.finish()
    }
}
/// See [`DeleteInboundCrossClusterSearchConnectionOutput`](crate::output::DeleteInboundCrossClusterSearchConnectionOutput)
pub mod delete_inbound_cross_cluster_search_connection_output {
    /// A builder for [`DeleteInboundCrossClusterSearchConnectionOutput`](crate::output::DeleteInboundCrossClusterSearchConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_cluster_search_connection:
            std::option::Option<crate::model::InboundCrossClusterSearchConnection>,
    }
    impl Builder {
        /// <p>Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of deleted inbound connection. </p>
        pub fn cross_cluster_search_connection(
            mut self,
            input: crate::model::InboundCrossClusterSearchConnection,
        ) -> Self {
            self.cross_cluster_search_connection = Some(input);
            self
        }
        /// <p>Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of deleted inbound connection. </p>
        pub fn set_cross_cluster_search_connection(
            mut self,
            input: std::option::Option<crate::model::InboundCrossClusterSearchConnection>,
        ) -> Self {
            self.cross_cluster_search_connection = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInboundCrossClusterSearchConnectionOutput`](crate::output::DeleteInboundCrossClusterSearchConnectionOutput)
        pub fn build(self) -> crate::output::DeleteInboundCrossClusterSearchConnectionOutput {
            crate::output::DeleteInboundCrossClusterSearchConnectionOutput {
                cross_cluster_search_connection: self.cross_cluster_search_connection,
            }
        }
    }
}
impl DeleteInboundCrossClusterSearchConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteInboundCrossClusterSearchConnectionOutput`](crate::output::DeleteInboundCrossClusterSearchConnectionOutput)
    pub fn builder() -> crate::output::delete_inbound_cross_cluster_search_connection_output::Builder
    {
        crate::output::delete_inbound_cross_cluster_search_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteElasticsearchServiceRoleOutput {}
impl std::fmt::Debug for DeleteElasticsearchServiceRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteElasticsearchServiceRoleOutput");
        formatter.finish()
    }
}
/// See [`DeleteElasticsearchServiceRoleOutput`](crate::output::DeleteElasticsearchServiceRoleOutput)
pub mod delete_elasticsearch_service_role_output {
    /// A builder for [`DeleteElasticsearchServiceRoleOutput`](crate::output::DeleteElasticsearchServiceRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteElasticsearchServiceRoleOutput`](crate::output::DeleteElasticsearchServiceRoleOutput)
        pub fn build(self) -> crate::output::DeleteElasticsearchServiceRoleOutput {
            crate::output::DeleteElasticsearchServiceRoleOutput {}
        }
    }
}
impl DeleteElasticsearchServiceRoleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteElasticsearchServiceRoleOutput`](crate::output::DeleteElasticsearchServiceRoleOutput)
    pub fn builder() -> crate::output::delete_elasticsearch_service_role_output::Builder {
        crate::output::delete_elasticsearch_service_role_output::Builder::default()
    }
}

/// <p>The result of a <code>DeleteElasticsearchDomain</code> request. Contains the status of the pending deletion, or no status if the domain and all of its resources have been deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteElasticsearchDomainOutput {
    /// <p>The status of the Elasticsearch domain being deleted.</p>
    pub domain_status: std::option::Option<crate::model::ElasticsearchDomainStatus>,
}
impl std::fmt::Debug for DeleteElasticsearchDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteElasticsearchDomainOutput");
        formatter.field("domain_status", &self.domain_status);
        formatter.finish()
    }
}
/// See [`DeleteElasticsearchDomainOutput`](crate::output::DeleteElasticsearchDomainOutput)
pub mod delete_elasticsearch_domain_output {
    /// A builder for [`DeleteElasticsearchDomainOutput`](crate::output::DeleteElasticsearchDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_status: std::option::Option<crate::model::ElasticsearchDomainStatus>,
    }
    impl Builder {
        /// <p>The status of the Elasticsearch domain being deleted.</p>
        pub fn domain_status(mut self, input: crate::model::ElasticsearchDomainStatus) -> Self {
            self.domain_status = Some(input);
            self
        }
        /// <p>The status of the Elasticsearch domain being deleted.</p>
        pub fn set_domain_status(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDomainStatus>,
        ) -> Self {
            self.domain_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteElasticsearchDomainOutput`](crate::output::DeleteElasticsearchDomainOutput)
        pub fn build(self) -> crate::output::DeleteElasticsearchDomainOutput {
            crate::output::DeleteElasticsearchDomainOutput {
                domain_status: self.domain_status,
            }
        }
    }
}
impl DeleteElasticsearchDomainOutput {
    /// Creates a new builder-style object to manufacture [`DeleteElasticsearchDomainOutput`](crate::output::DeleteElasticsearchDomainOutput)
    pub fn builder() -> crate::output::delete_elasticsearch_domain_output::Builder {
        crate::output::delete_elasticsearch_domain_output::Builder::default()
    }
}

/// <p>
/// Container for response returned by
/// <code>
/// <a>CreatePackage</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePackageOutput {
    /// <p>Information about the package <code>PackageDetails</code>.</p>
    pub package_details: std::option::Option<crate::model::PackageDetails>,
}
impl std::fmt::Debug for CreatePackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePackageOutput");
        formatter.field("package_details", &self.package_details);
        formatter.finish()
    }
}
/// See [`CreatePackageOutput`](crate::output::CreatePackageOutput)
pub mod create_package_output {
    /// A builder for [`CreatePackageOutput`](crate::output::CreatePackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_details: std::option::Option<crate::model::PackageDetails>,
    }
    impl Builder {
        /// <p>Information about the package <code>PackageDetails</code>.</p>
        pub fn package_details(mut self, input: crate::model::PackageDetails) -> Self {
            self.package_details = Some(input);
            self
        }
        /// <p>Information about the package <code>PackageDetails</code>.</p>
        pub fn set_package_details(
            mut self,
            input: std::option::Option<crate::model::PackageDetails>,
        ) -> Self {
            self.package_details = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePackageOutput`](crate::output::CreatePackageOutput)
        pub fn build(self) -> crate::output::CreatePackageOutput {
            crate::output::CreatePackageOutput {
                package_details: self.package_details,
            }
        }
    }
}
impl CreatePackageOutput {
    /// Creates a new builder-style object to manufacture [`CreatePackageOutput`](crate::output::CreatePackageOutput)
    pub fn builder() -> crate::output::create_package_output::Builder {
        crate::output::create_package_output::Builder::default()
    }
}

/// <p>The result of a <code><a>CreateOutboundCrossClusterSearchConnection</a></code> request. Contains the details of the newly created cross-cluster search connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOutboundCrossClusterSearchConnectionOutput {
    /// <p>Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.</p>
    pub source_domain_info: std::option::Option<crate::model::DomainInformation>,
    /// <p>Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.</p>
    pub destination_domain_info: std::option::Option<crate::model::DomainInformation>,
    /// <p>Specifies the connection alias provided during the create connection request.</p>
    pub connection_alias: std::option::Option<std::string::String>,
    /// <p>Specifies the <code><a>OutboundCrossClusterSearchConnectionStatus</a></code> for the newly created connection.</p>
    pub connection_status:
        std::option::Option<crate::model::OutboundCrossClusterSearchConnectionStatus>,
    /// <p>Unique id for the created outbound connection, which is used for subsequent operations on connection.</p>
    pub cross_cluster_search_connection_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateOutboundCrossClusterSearchConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOutboundCrossClusterSearchConnectionOutput");
        formatter.field("source_domain_info", &self.source_domain_info);
        formatter.field("destination_domain_info", &self.destination_domain_info);
        formatter.field("connection_alias", &self.connection_alias);
        formatter.field("connection_status", &self.connection_status);
        formatter.field(
            "cross_cluster_search_connection_id",
            &self.cross_cluster_search_connection_id,
        );
        formatter.finish()
    }
}
/// See [`CreateOutboundCrossClusterSearchConnectionOutput`](crate::output::CreateOutboundCrossClusterSearchConnectionOutput)
pub mod create_outbound_cross_cluster_search_connection_output {
    /// A builder for [`CreateOutboundCrossClusterSearchConnectionOutput`](crate::output::CreateOutboundCrossClusterSearchConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_domain_info: std::option::Option<crate::model::DomainInformation>,
        pub(crate) destination_domain_info: std::option::Option<crate::model::DomainInformation>,
        pub(crate) connection_alias: std::option::Option<std::string::String>,
        pub(crate) connection_status:
            std::option::Option<crate::model::OutboundCrossClusterSearchConnectionStatus>,
        pub(crate) cross_cluster_search_connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.</p>
        pub fn source_domain_info(mut self, input: crate::model::DomainInformation) -> Self {
            self.source_domain_info = Some(input);
            self
        }
        /// <p>Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.</p>
        pub fn set_source_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformation>,
        ) -> Self {
            self.source_domain_info = input;
            self
        }
        /// <p>Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.</p>
        pub fn destination_domain_info(mut self, input: crate::model::DomainInformation) -> Self {
            self.destination_domain_info = Some(input);
            self
        }
        /// <p>Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.</p>
        pub fn set_destination_domain_info(
            mut self,
            input: std::option::Option<crate::model::DomainInformation>,
        ) -> Self {
            self.destination_domain_info = input;
            self
        }
        /// <p>Specifies the connection alias provided during the create connection request.</p>
        pub fn connection_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_alias = Some(input.into());
            self
        }
        /// <p>Specifies the connection alias provided during the create connection request.</p>
        pub fn set_connection_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_alias = input;
            self
        }
        /// <p>Specifies the <code><a>OutboundCrossClusterSearchConnectionStatus</a></code> for the newly created connection.</p>
        pub fn connection_status(
            mut self,
            input: crate::model::OutboundCrossClusterSearchConnectionStatus,
        ) -> Self {
            self.connection_status = Some(input);
            self
        }
        /// <p>Specifies the <code><a>OutboundCrossClusterSearchConnectionStatus</a></code> for the newly created connection.</p>
        pub fn set_connection_status(
            mut self,
            input: std::option::Option<crate::model::OutboundCrossClusterSearchConnectionStatus>,
        ) -> Self {
            self.connection_status = input;
            self
        }
        /// <p>Unique id for the created outbound connection, which is used for subsequent operations on connection.</p>
        pub fn cross_cluster_search_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = Some(input.into());
            self
        }
        /// <p>Unique id for the created outbound connection, which is used for subsequent operations on connection.</p>
        pub fn set_cross_cluster_search_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cross_cluster_search_connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOutboundCrossClusterSearchConnectionOutput`](crate::output::CreateOutboundCrossClusterSearchConnectionOutput)
        pub fn build(self) -> crate::output::CreateOutboundCrossClusterSearchConnectionOutput {
            crate::output::CreateOutboundCrossClusterSearchConnectionOutput {
                source_domain_info: self.source_domain_info,
                destination_domain_info: self.destination_domain_info,
                connection_alias: self.connection_alias,
                connection_status: self.connection_status,
                cross_cluster_search_connection_id: self.cross_cluster_search_connection_id,
            }
        }
    }
}
impl CreateOutboundCrossClusterSearchConnectionOutput {
    /// Creates a new builder-style object to manufacture [`CreateOutboundCrossClusterSearchConnectionOutput`](crate::output::CreateOutboundCrossClusterSearchConnectionOutput)
    pub fn builder(
    ) -> crate::output::create_outbound_cross_cluster_search_connection_output::Builder {
        crate::output::create_outbound_cross_cluster_search_connection_output::Builder::default()
    }
}

/// <p>The result of a <code>CreateElasticsearchDomain</code> operation. Contains the status of the newly created Elasticsearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateElasticsearchDomainOutput {
    /// <p>The status of the newly created Elasticsearch domain. </p>
    pub domain_status: std::option::Option<crate::model::ElasticsearchDomainStatus>,
}
impl std::fmt::Debug for CreateElasticsearchDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateElasticsearchDomainOutput");
        formatter.field("domain_status", &self.domain_status);
        formatter.finish()
    }
}
/// See [`CreateElasticsearchDomainOutput`](crate::output::CreateElasticsearchDomainOutput)
pub mod create_elasticsearch_domain_output {
    /// A builder for [`CreateElasticsearchDomainOutput`](crate::output::CreateElasticsearchDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_status: std::option::Option<crate::model::ElasticsearchDomainStatus>,
    }
    impl Builder {
        /// <p>The status of the newly created Elasticsearch domain. </p>
        pub fn domain_status(mut self, input: crate::model::ElasticsearchDomainStatus) -> Self {
            self.domain_status = Some(input);
            self
        }
        /// <p>The status of the newly created Elasticsearch domain. </p>
        pub fn set_domain_status(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDomainStatus>,
        ) -> Self {
            self.domain_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateElasticsearchDomainOutput`](crate::output::CreateElasticsearchDomainOutput)
        pub fn build(self) -> crate::output::CreateElasticsearchDomainOutput {
            crate::output::CreateElasticsearchDomainOutput {
                domain_status: self.domain_status,
            }
        }
    }
}
impl CreateElasticsearchDomainOutput {
    /// Creates a new builder-style object to manufacture [`CreateElasticsearchDomainOutput`](crate::output::CreateElasticsearchDomainOutput)
    pub fn builder() -> crate::output::create_elasticsearch_domain_output::Builder {
        crate::output::create_elasticsearch_domain_output::Builder::default()
    }
}

/// <p>The result of a <code>CancelElasticsearchServiceSoftwareUpdate</code> operation. Contains the status of the update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelElasticsearchServiceSoftwareUpdateOutput {
    /// <p>The current status of the Elasticsearch service software update.</p>
    pub service_software_options: std::option::Option<crate::model::ServiceSoftwareOptions>,
}
impl std::fmt::Debug for CancelElasticsearchServiceSoftwareUpdateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelElasticsearchServiceSoftwareUpdateOutput");
        formatter.field("service_software_options", &self.service_software_options);
        formatter.finish()
    }
}
/// See [`CancelElasticsearchServiceSoftwareUpdateOutput`](crate::output::CancelElasticsearchServiceSoftwareUpdateOutput)
pub mod cancel_elasticsearch_service_software_update_output {
    /// A builder for [`CancelElasticsearchServiceSoftwareUpdateOutput`](crate::output::CancelElasticsearchServiceSoftwareUpdateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_software_options:
            std::option::Option<crate::model::ServiceSoftwareOptions>,
    }
    impl Builder {
        /// <p>The current status of the Elasticsearch service software update.</p>
        pub fn service_software_options(
            mut self,
            input: crate::model::ServiceSoftwareOptions,
        ) -> Self {
            self.service_software_options = Some(input);
            self
        }
        /// <p>The current status of the Elasticsearch service software update.</p>
        pub fn set_service_software_options(
            mut self,
            input: std::option::Option<crate::model::ServiceSoftwareOptions>,
        ) -> Self {
            self.service_software_options = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelElasticsearchServiceSoftwareUpdateOutput`](crate::output::CancelElasticsearchServiceSoftwareUpdateOutput)
        pub fn build(self) -> crate::output::CancelElasticsearchServiceSoftwareUpdateOutput {
            crate::output::CancelElasticsearchServiceSoftwareUpdateOutput {
                service_software_options: self.service_software_options,
            }
        }
    }
}
impl CancelElasticsearchServiceSoftwareUpdateOutput {
    /// Creates a new builder-style object to manufacture [`CancelElasticsearchServiceSoftwareUpdateOutput`](crate::output::CancelElasticsearchServiceSoftwareUpdateOutput)
    pub fn builder() -> crate::output::cancel_elasticsearch_service_software_update_output::Builder
    {
        crate::output::cancel_elasticsearch_service_software_update_output::Builder::default()
    }
}

/// <p>
/// Container for response returned by
/// <code>
/// <a>AssociatePackage</a>
/// </code>
/// operation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatePackageOutput {
    /// <p><code>DomainPackageDetails</code></p>
    pub domain_package_details: std::option::Option<crate::model::DomainPackageDetails>,
}
impl std::fmt::Debug for AssociatePackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatePackageOutput");
        formatter.field("domain_package_details", &self.domain_package_details);
        formatter.finish()
    }
}
/// See [`AssociatePackageOutput`](crate::output::AssociatePackageOutput)
pub mod associate_package_output {
    /// A builder for [`AssociatePackageOutput`](crate::output::AssociatePackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_package_details: std::option::Option<crate::model::DomainPackageDetails>,
    }
    impl Builder {
        /// <p><code>DomainPackageDetails</code></p>
        pub fn domain_package_details(mut self, input: crate::model::DomainPackageDetails) -> Self {
            self.domain_package_details = Some(input);
            self
        }
        /// <p><code>DomainPackageDetails</code></p>
        pub fn set_domain_package_details(
            mut self,
            input: std::option::Option<crate::model::DomainPackageDetails>,
        ) -> Self {
            self.domain_package_details = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatePackageOutput`](crate::output::AssociatePackageOutput)
        pub fn build(self) -> crate::output::AssociatePackageOutput {
            crate::output::AssociatePackageOutput {
                domain_package_details: self.domain_package_details,
            }
        }
    }
}
impl AssociatePackageOutput {
    /// Creates a new builder-style object to manufacture [`AssociatePackageOutput`](crate::output::AssociatePackageOutput)
    pub fn builder() -> crate::output::associate_package_output::Builder {
        crate::output::associate_package_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsOutput {}
impl std::fmt::Debug for AddTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsOutput");
        formatter.finish()
    }
}
/// See [`AddTagsOutput`](crate::output::AddTagsOutput)
pub mod add_tags_output {
    /// A builder for [`AddTagsOutput`](crate::output::AddTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddTagsOutput`](crate::output::AddTagsOutput)
        pub fn build(self) -> crate::output::AddTagsOutput {
            crate::output::AddTagsOutput {}
        }
    }
}
impl AddTagsOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsOutput`](crate::output::AddTagsOutput)
    pub fn builder() -> crate::output::add_tags_output::Builder {
        crate::output::add_tags_output::Builder::default()
    }
}

/// <p>The result of a <code><a>AcceptInboundCrossClusterSearchConnection</a></code> operation. Contains details of accepted inbound connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptInboundCrossClusterSearchConnectionOutput {
    /// <p>Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of accepted inbound connection. </p>
    pub cross_cluster_search_connection:
        std::option::Option<crate::model::InboundCrossClusterSearchConnection>,
}
impl std::fmt::Debug for AcceptInboundCrossClusterSearchConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptInboundCrossClusterSearchConnectionOutput");
        formatter.field(
            "cross_cluster_search_connection",
            &self.cross_cluster_search_connection,
        );
        formatter.finish()
    }
}
/// See [`AcceptInboundCrossClusterSearchConnectionOutput`](crate::output::AcceptInboundCrossClusterSearchConnectionOutput)
pub mod accept_inbound_cross_cluster_search_connection_output {
    /// A builder for [`AcceptInboundCrossClusterSearchConnectionOutput`](crate::output::AcceptInboundCrossClusterSearchConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_cluster_search_connection:
            std::option::Option<crate::model::InboundCrossClusterSearchConnection>,
    }
    impl Builder {
        /// <p>Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of accepted inbound connection. </p>
        pub fn cross_cluster_search_connection(
            mut self,
            input: crate::model::InboundCrossClusterSearchConnection,
        ) -> Self {
            self.cross_cluster_search_connection = Some(input);
            self
        }
        /// <p>Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of accepted inbound connection. </p>
        pub fn set_cross_cluster_search_connection(
            mut self,
            input: std::option::Option<crate::model::InboundCrossClusterSearchConnection>,
        ) -> Self {
            self.cross_cluster_search_connection = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptInboundCrossClusterSearchConnectionOutput`](crate::output::AcceptInboundCrossClusterSearchConnectionOutput)
        pub fn build(self) -> crate::output::AcceptInboundCrossClusterSearchConnectionOutput {
            crate::output::AcceptInboundCrossClusterSearchConnectionOutput {
                cross_cluster_search_connection: self.cross_cluster_search_connection,
            }
        }
    }
}
impl AcceptInboundCrossClusterSearchConnectionOutput {
    /// Creates a new builder-style object to manufacture [`AcceptInboundCrossClusterSearchConnectionOutput`](crate::output::AcceptInboundCrossClusterSearchConnectionOutput)
    pub fn builder() -> crate::output::accept_inbound_cross_cluster_search_connection_output::Builder
    {
        crate::output::accept_inbound_cross_cluster_search_connection_output::Builder::default()
    }
}
