// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddListenerCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddListenerCertificatesError {
    /// Kind of error that occurred.
    pub kind: AddListenerCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddListenerCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddListenerCertificatesErrorKind {
    /// <p>The specified certificate does not exist.</p>
    CertificateNotFoundException(crate::error::CertificateNotFoundException),
    /// <p>The specified listener does not exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// <p>You've reached the limit on the number of certificates per load balancer.</p>
    TooManyCertificatesException(crate::error::TooManyCertificatesException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddListenerCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddListenerCertificatesErrorKind::CertificateNotFoundException(_inner) => _inner.fmt(f),
            AddListenerCertificatesErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            AddListenerCertificatesErrorKind::TooManyCertificatesException(_inner) => _inner.fmt(f),
            AddListenerCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddListenerCertificatesError {
    fn code(&self) -> Option<&str> {
        AddListenerCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddListenerCertificatesError {
    /// Creates a new `AddListenerCertificatesError`.
    pub fn new(kind: AddListenerCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddListenerCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddListenerCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddListenerCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddListenerCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddListenerCertificatesErrorKind::CertificateNotFoundException`.
    pub fn is_certificate_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddListenerCertificatesErrorKind::CertificateNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddListenerCertificatesErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddListenerCertificatesErrorKind::ListenerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddListenerCertificatesErrorKind::TooManyCertificatesException`.
    pub fn is_too_many_certificates_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddListenerCertificatesErrorKind::TooManyCertificatesException(_)
        )
    }
}
impl std::error::Error for AddListenerCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddListenerCertificatesErrorKind::CertificateNotFoundException(_inner) => Some(_inner),
            AddListenerCertificatesErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            AddListenerCertificatesErrorKind::TooManyCertificatesException(_inner) => Some(_inner),
            AddListenerCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsError {
    /// Kind of error that occurred.
    pub kind: AddTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsErrorKind {
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>The specified listener does not exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// <p>The specified rule does not exist.</p>
    RuleNotFoundException(crate::error::RuleNotFoundException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// <p>You've reached the limit on the number of tags per load balancer.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsErrorKind::DuplicateTagKeysException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::LoadBalancerNotFoundException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::RuleNotFoundException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::TargetGroupNotFoundException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsError {
    fn code(&self) -> Option<&str> {
        AddTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsError {
    /// Creates a new `AddTagsError`.
    pub fn new(kind: AddTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::DuplicateTagKeysException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::ListenerNotFoundException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::LoadBalancerNotFoundException`.
    pub fn is_load_balancer_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsErrorKind::LoadBalancerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::RuleNotFoundException`.
    pub fn is_rule_not_found_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::RuleNotFoundException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsErrorKind::TargetGroupNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for AddTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsErrorKind::DuplicateTagKeysException(_inner) => Some(_inner),
            AddTagsErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            AddTagsErrorKind::LoadBalancerNotFoundException(_inner) => Some(_inner),
            AddTagsErrorKind::RuleNotFoundException(_inner) => Some(_inner),
            AddTagsErrorKind::TargetGroupNotFoundException(_inner) => Some(_inner),
            AddTagsErrorKind::TooManyTagsException(_inner) => Some(_inner),
            AddTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateListenerError {
    /// Kind of error that occurred.
    pub kind: CreateListenerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateListenerErrorKind {
    /// <p>The specified ALPN policy is not supported.</p>
    AlpnPolicyNotSupportedException(crate::error::AlpnPolicyNotSupportedException),
    /// <p>The specified certificate does not exist.</p>
    CertificateNotFoundException(crate::error::CertificateNotFoundException),
    /// <p>A listener with the specified port already exists.</p>
    DuplicateListenerException(crate::error::DuplicateListenerException),
    /// <p>The specified configuration is not valid with this protocol.</p>
    IncompatibleProtocolsException(crate::error::IncompatibleProtocolsException),
    /// <p>The requested configuration is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The requested action is not valid.</p>
    InvalidLoadBalancerActionException(crate::error::InvalidLoadBalancerActionException),
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// <p>The specified SSL policy does not exist.</p>
    SslPolicyNotFoundException(crate::error::SslPolicyNotFoundException),
    /// <p>You've reached the limit on the number of load balancers per target group.</p>
    TargetGroupAssociationLimitException(crate::error::TargetGroupAssociationLimitException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// <p>You've reached the limit on the number of actions per rule.</p>
    TooManyActionsException(crate::error::TooManyActionsException),
    /// <p>You've reached the limit on the number of certificates per load balancer.</p>
    TooManyCertificatesException(crate::error::TooManyCertificatesException),
    /// <p>You've reached the limit on the number of listeners per load balancer.</p>
    TooManyListenersException(crate::error::TooManyListenersException),
    /// <p>You've reached the limit on the number of times a target can be registered with a load balancer.</p>
    TooManyRegistrationsForTargetIdException(
        crate::error::TooManyRegistrationsForTargetIdException,
    ),
    /// <p>You've reached the limit on the number of tags per load balancer.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>You've reached the limit on the number of targets.</p>
    TooManyTargetsException(crate::error::TooManyTargetsException),
    /// <p>You've reached the limit on the number of unique target groups per load balancer across all listeners. If a target group is used by multiple actions for a load balancer, it is counted as only one use.</p>
    TooManyUniqueTargetGroupsPerLoadBalancerException(
        crate::error::TooManyUniqueTargetGroupsPerLoadBalancerException,
    ),
    /// <p>The specified protocol is not supported.</p>
    UnsupportedProtocolException(crate::error::UnsupportedProtocolException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateListenerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateListenerErrorKind::AlpnPolicyNotSupportedException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::CertificateNotFoundException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::DuplicateListenerException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::IncompatibleProtocolsException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::InvalidConfigurationRequestException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::InvalidLoadBalancerActionException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::LoadBalancerNotFoundException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::SslPolicyNotFoundException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::TargetGroupAssociationLimitException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::TargetGroupNotFoundException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::TooManyActionsException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::TooManyCertificatesException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::TooManyListenersException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::TooManyRegistrationsForTargetIdException(_inner) => {
                _inner.fmt(f)
            }
            CreateListenerErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::TooManyTargetsException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(_inner) => {
                _inner.fmt(f)
            }
            CreateListenerErrorKind::UnsupportedProtocolException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateListenerError {
    fn code(&self) -> Option<&str> {
        CreateListenerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateListenerError {
    /// Creates a new `CreateListenerError`.
    pub fn new(kind: CreateListenerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateListenerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateListenerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateListenerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateListenerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::AlpnPolicyNotSupportedException`.
    pub fn is_alpn_policy_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::AlpnPolicyNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::CertificateNotFoundException`.
    pub fn is_certificate_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::CertificateNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::DuplicateListenerException`.
    pub fn is_duplicate_listener_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::DuplicateListenerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::IncompatibleProtocolsException`.
    pub fn is_incompatible_protocols_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::IncompatibleProtocolsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::InvalidLoadBalancerActionException`.
    pub fn is_invalid_load_balancer_action_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::InvalidLoadBalancerActionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::LoadBalancerNotFoundException`.
    pub fn is_load_balancer_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::LoadBalancerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::SslPolicyNotFoundException`.
    pub fn is_ssl_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::SslPolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::TargetGroupAssociationLimitException`.
    pub fn is_target_group_association_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::TargetGroupAssociationLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::TargetGroupNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::TooManyActionsException`.
    pub fn is_too_many_actions_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::TooManyActionsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::TooManyCertificatesException`.
    pub fn is_too_many_certificates_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::TooManyCertificatesException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::TooManyListenersException`.
    pub fn is_too_many_listeners_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::TooManyListenersException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::TooManyRegistrationsForTargetIdException`.
    pub fn is_too_many_registrations_for_target_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::TooManyRegistrationsForTargetIdException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreateListenerErrorKind::TooManyTagsException(_))
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::TooManyTargetsException`.
    pub fn is_too_many_targets_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::TooManyTargetsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException`.
    pub fn is_too_many_unique_target_groups_per_load_balancer_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateListenerErrorKind::UnsupportedProtocolException`.
    pub fn is_unsupported_protocol_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::UnsupportedProtocolException(_)
        )
    }
}
impl std::error::Error for CreateListenerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateListenerErrorKind::AlpnPolicyNotSupportedException(_inner) => Some(_inner),
            CreateListenerErrorKind::CertificateNotFoundException(_inner) => Some(_inner),
            CreateListenerErrorKind::DuplicateListenerException(_inner) => Some(_inner),
            CreateListenerErrorKind::IncompatibleProtocolsException(_inner) => Some(_inner),
            CreateListenerErrorKind::InvalidConfigurationRequestException(_inner) => Some(_inner),
            CreateListenerErrorKind::InvalidLoadBalancerActionException(_inner) => Some(_inner),
            CreateListenerErrorKind::LoadBalancerNotFoundException(_inner) => Some(_inner),
            CreateListenerErrorKind::SslPolicyNotFoundException(_inner) => Some(_inner),
            CreateListenerErrorKind::TargetGroupAssociationLimitException(_inner) => Some(_inner),
            CreateListenerErrorKind::TargetGroupNotFoundException(_inner) => Some(_inner),
            CreateListenerErrorKind::TooManyActionsException(_inner) => Some(_inner),
            CreateListenerErrorKind::TooManyCertificatesException(_inner) => Some(_inner),
            CreateListenerErrorKind::TooManyListenersException(_inner) => Some(_inner),
            CreateListenerErrorKind::TooManyRegistrationsForTargetIdException(_inner) => {
                Some(_inner)
            }
            CreateListenerErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateListenerErrorKind::TooManyTargetsException(_inner) => Some(_inner),
            CreateListenerErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(_inner) => {
                Some(_inner)
            }
            CreateListenerErrorKind::UnsupportedProtocolException(_inner) => Some(_inner),
            CreateListenerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: CreateLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLoadBalancerErrorKind {
    /// <p>The specified allocation ID does not exist.</p>
    AllocationIdNotFoundException(crate::error::AllocationIdNotFoundException),
    /// <p>The specified Availability Zone is not supported.</p>
    AvailabilityZoneNotSupportedException(crate::error::AvailabilityZoneNotSupportedException),
    /// <p>A load balancer with the specified name already exists.</p>
    DuplicateLoadBalancerNameException(crate::error::DuplicateLoadBalancerNameException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>The requested configuration is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The requested scheme is not valid.</p>
    InvalidSchemeException(crate::error::InvalidSchemeException),
    /// <p>The specified security group does not exist.</p>
    InvalidSecurityGroupException(crate::error::InvalidSecurityGroupException),
    /// <p>The specified subnet is out of available addresses.</p>
    InvalidSubnetException(crate::error::InvalidSubnetException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>A specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified subnet does not exist.</p>
    SubnetNotFoundException(crate::error::SubnetNotFoundException),
    /// <p>You've reached the limit on the number of load balancers for your Amazon Web Services account.</p>
    TooManyLoadBalancersException(crate::error::TooManyLoadBalancersException),
    /// <p>You've reached the limit on the number of tags per load balancer.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLoadBalancerErrorKind::AllocationIdNotFoundException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::AvailabilityZoneNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerErrorKind::DuplicateLoadBalancerNameException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerErrorKind::DuplicateTagKeysException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::InvalidConfigurationRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerErrorKind::InvalidSchemeException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::InvalidSecurityGroupException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::InvalidSubnetException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::SubnetNotFoundException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::TooManyLoadBalancersException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLoadBalancerError {
    fn code(&self) -> Option<&str> {
        CreateLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLoadBalancerError {
    /// Creates a new `CreateLoadBalancerError`.
    pub fn new(kind: CreateLoadBalancerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::AllocationIdNotFoundException`.
    pub fn is_allocation_id_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::AllocationIdNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::AvailabilityZoneNotSupportedException`.
    pub fn is_availability_zone_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::AvailabilityZoneNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::DuplicateLoadBalancerNameException`.
    pub fn is_duplicate_load_balancer_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::DuplicateLoadBalancerNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::DuplicateTagKeysException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::InvalidSchemeException`.
    pub fn is_invalid_scheme_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::InvalidSchemeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::InvalidSecurityGroupException`.
    pub fn is_invalid_security_group_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::InvalidSecurityGroupException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::InvalidSubnetException`.
    pub fn is_invalid_subnet_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::InvalidSubnetException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::SubnetNotFoundException`.
    pub fn is_subnet_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::SubnetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::TooManyLoadBalancersException`.
    pub fn is_too_many_load_balancers_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::TooManyLoadBalancersException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLoadBalancerErrorKind::AllocationIdNotFoundException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::AvailabilityZoneNotSupportedException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerErrorKind::DuplicateLoadBalancerNameException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::DuplicateTagKeysException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::InvalidConfigurationRequestException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerErrorKind::InvalidSchemeException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::InvalidSecurityGroupException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::InvalidSubnetException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::SubnetNotFoundException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::TooManyLoadBalancersException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRuleError {
    /// Kind of error that occurred.
    pub kind: CreateRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRuleErrorKind {
    /// <p>The specified configuration is not valid with this protocol.</p>
    IncompatibleProtocolsException(crate::error::IncompatibleProtocolsException),
    /// <p>The requested configuration is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The requested action is not valid.</p>
    InvalidLoadBalancerActionException(crate::error::InvalidLoadBalancerActionException),
    /// <p>The specified listener does not exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// <p>The specified priority is in use.</p>
    PriorityInUseException(crate::error::PriorityInUseException),
    /// <p>You've reached the limit on the number of load balancers per target group.</p>
    TargetGroupAssociationLimitException(crate::error::TargetGroupAssociationLimitException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// <p>You've reached the limit on the number of actions per rule.</p>
    TooManyActionsException(crate::error::TooManyActionsException),
    /// <p>You've reached the limit on the number of times a target can be registered with a load balancer.</p>
    TooManyRegistrationsForTargetIdException(
        crate::error::TooManyRegistrationsForTargetIdException,
    ),
    /// <p>You've reached the limit on the number of rules per load balancer.</p>
    TooManyRulesException(crate::error::TooManyRulesException),
    /// <p>You've reached the limit on the number of tags per load balancer.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>You've reached the limit on the number of target groups for your Amazon Web Services account.</p>
    TooManyTargetGroupsException(crate::error::TooManyTargetGroupsException),
    /// <p>You've reached the limit on the number of targets.</p>
    TooManyTargetsException(crate::error::TooManyTargetsException),
    /// <p>You've reached the limit on the number of unique target groups per load balancer across all listeners. If a target group is used by multiple actions for a load balancer, it is counted as only one use.</p>
    TooManyUniqueTargetGroupsPerLoadBalancerException(
        crate::error::TooManyUniqueTargetGroupsPerLoadBalancerException,
    ),
    /// <p>The specified protocol is not supported.</p>
    UnsupportedProtocolException(crate::error::UnsupportedProtocolException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRuleErrorKind::IncompatibleProtocolsException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::InvalidConfigurationRequestException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::InvalidLoadBalancerActionException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::PriorityInUseException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::TargetGroupAssociationLimitException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::TargetGroupNotFoundException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::TooManyActionsException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::TooManyRegistrationsForTargetIdException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::TooManyRulesException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::TooManyTargetGroupsException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::TooManyTargetsException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(_inner) => {
                _inner.fmt(f)
            }
            CreateRuleErrorKind::UnsupportedProtocolException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRuleError {
    fn code(&self) -> Option<&str> {
        CreateRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRuleError {
    /// Creates a new `CreateRuleError`.
    pub fn new(kind: CreateRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::IncompatibleProtocolsException`.
    pub fn is_incompatible_protocols_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::IncompatibleProtocolsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::InvalidLoadBalancerActionException`.
    pub fn is_invalid_load_balancer_action_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::InvalidLoadBalancerActionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::ListenerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::PriorityInUseException`.
    pub fn is_priority_in_use_exception(&self) -> bool {
        matches!(&self.kind, CreateRuleErrorKind::PriorityInUseException(_))
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::TargetGroupAssociationLimitException`.
    pub fn is_target_group_association_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::TargetGroupAssociationLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::TargetGroupNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::TooManyActionsException`.
    pub fn is_too_many_actions_exception(&self) -> bool {
        matches!(&self.kind, CreateRuleErrorKind::TooManyActionsException(_))
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::TooManyRegistrationsForTargetIdException`.
    pub fn is_too_many_registrations_for_target_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::TooManyRegistrationsForTargetIdException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::TooManyRulesException`.
    pub fn is_too_many_rules_exception(&self) -> bool {
        matches!(&self.kind, CreateRuleErrorKind::TooManyRulesException(_))
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreateRuleErrorKind::TooManyTagsException(_))
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::TooManyTargetGroupsException`.
    pub fn is_too_many_target_groups_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::TooManyTargetGroupsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::TooManyTargetsException`.
    pub fn is_too_many_targets_exception(&self) -> bool {
        matches!(&self.kind, CreateRuleErrorKind::TooManyTargetsException(_))
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException`.
    pub fn is_too_many_unique_target_groups_per_load_balancer_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::UnsupportedProtocolException`.
    pub fn is_unsupported_protocol_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::UnsupportedProtocolException(_)
        )
    }
}
impl std::error::Error for CreateRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRuleErrorKind::IncompatibleProtocolsException(_inner) => Some(_inner),
            CreateRuleErrorKind::InvalidConfigurationRequestException(_inner) => Some(_inner),
            CreateRuleErrorKind::InvalidLoadBalancerActionException(_inner) => Some(_inner),
            CreateRuleErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            CreateRuleErrorKind::PriorityInUseException(_inner) => Some(_inner),
            CreateRuleErrorKind::TargetGroupAssociationLimitException(_inner) => Some(_inner),
            CreateRuleErrorKind::TargetGroupNotFoundException(_inner) => Some(_inner),
            CreateRuleErrorKind::TooManyActionsException(_inner) => Some(_inner),
            CreateRuleErrorKind::TooManyRegistrationsForTargetIdException(_inner) => Some(_inner),
            CreateRuleErrorKind::TooManyRulesException(_inner) => Some(_inner),
            CreateRuleErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateRuleErrorKind::TooManyTargetGroupsException(_inner) => Some(_inner),
            CreateRuleErrorKind::TooManyTargetsException(_inner) => Some(_inner),
            CreateRuleErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(_inner) => {
                Some(_inner)
            }
            CreateRuleErrorKind::UnsupportedProtocolException(_inner) => Some(_inner),
            CreateRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTargetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTargetGroupError {
    /// Kind of error that occurred.
    pub kind: CreateTargetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTargetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTargetGroupErrorKind {
    /// <p>A target group with the specified name already exists.</p>
    DuplicateTargetGroupNameException(crate::error::DuplicateTargetGroupNameException),
    /// <p>The requested configuration is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>You've reached the limit on the number of tags per load balancer.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>You've reached the limit on the number of target groups for your Amazon Web Services account.</p>
    TooManyTargetGroupsException(crate::error::TooManyTargetGroupsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTargetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTargetGroupErrorKind::DuplicateTargetGroupNameException(_inner) => _inner.fmt(f),
            CreateTargetGroupErrorKind::InvalidConfigurationRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreateTargetGroupErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateTargetGroupErrorKind::TooManyTargetGroupsException(_inner) => _inner.fmt(f),
            CreateTargetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTargetGroupError {
    fn code(&self) -> Option<&str> {
        CreateTargetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTargetGroupError {
    /// Creates a new `CreateTargetGroupError`.
    pub fn new(kind: CreateTargetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTargetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTargetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTargetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTargetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTargetGroupErrorKind::DuplicateTargetGroupNameException`.
    pub fn is_duplicate_target_group_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTargetGroupErrorKind::DuplicateTargetGroupNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTargetGroupErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTargetGroupErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTargetGroupErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTargetGroupErrorKind::TooManyTagsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTargetGroupErrorKind::TooManyTargetGroupsException`.
    pub fn is_too_many_target_groups_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTargetGroupErrorKind::TooManyTargetGroupsException(_)
        )
    }
}
impl std::error::Error for CreateTargetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTargetGroupErrorKind::DuplicateTargetGroupNameException(_inner) => Some(_inner),
            CreateTargetGroupErrorKind::InvalidConfigurationRequestException(_inner) => {
                Some(_inner)
            }
            CreateTargetGroupErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateTargetGroupErrorKind::TooManyTargetGroupsException(_inner) => Some(_inner),
            CreateTargetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteListenerError {
    /// Kind of error that occurred.
    pub kind: DeleteListenerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteListenerErrorKind {
    /// <p>The specified listener does not exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// <p>A specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteListenerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteListenerErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            DeleteListenerErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteListenerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteListenerError {
    fn code(&self) -> Option<&str> {
        DeleteListenerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteListenerError {
    /// Creates a new `DeleteListenerError`.
    pub fn new(kind: DeleteListenerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteListenerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteListenerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteListenerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteListenerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteListenerErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteListenerErrorKind::ListenerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteListenerErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteListenerErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteListenerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteListenerErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            DeleteListenerErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteListenerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: DeleteLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLoadBalancerErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>A specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLoadBalancerErrorKind::LoadBalancerNotFoundException(_inner) => _inner.fmt(f),
            DeleteLoadBalancerErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DeleteLoadBalancerErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteLoadBalancerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLoadBalancerError {
    fn code(&self) -> Option<&str> {
        DeleteLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLoadBalancerError {
    /// Creates a new `DeleteLoadBalancerError`.
    pub fn new(kind: DeleteLoadBalancerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerErrorKind::LoadBalancerNotFoundException`.
    pub fn is_load_balancer_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerErrorKind::LoadBalancerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLoadBalancerErrorKind::LoadBalancerNotFoundException(_inner) => Some(_inner),
            DeleteLoadBalancerErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DeleteLoadBalancerErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteLoadBalancerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRuleErrorKind {
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified rule does not exist.</p>
    RuleNotFoundException(crate::error::RuleNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRuleErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::RuleNotFoundException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRuleError {
    fn code(&self) -> Option<&str> {
        DeleteRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRuleError {
    /// Creates a new `DeleteRuleError`.
    pub fn new(kind: DeleteRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::RuleNotFoundException`.
    pub fn is_rule_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteRuleErrorKind::RuleNotFoundException(_))
    }
}
impl std::error::Error for DeleteRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRuleErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DeleteRuleErrorKind::RuleNotFoundException(_inner) => Some(_inner),
            DeleteRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTargetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTargetGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteTargetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTargetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTargetGroupErrorKind {
    /// <p>A specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTargetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTargetGroupErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteTargetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTargetGroupError {
    fn code(&self) -> Option<&str> {
        DeleteTargetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTargetGroupError {
    /// Creates a new `DeleteTargetGroupError`.
    pub fn new(kind: DeleteTargetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTargetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTargetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTargetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTargetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTargetGroupErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTargetGroupErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteTargetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTargetGroupErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteTargetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterTargetsError {
    /// Kind of error that occurred.
    pub kind: DeregisterTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterTargetsErrorKind {
    /// <p>The specified target does not exist, is not in the same VPC as the target group, or has an unsupported instance type.</p>
    InvalidTargetException(crate::error::InvalidTargetException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterTargetsErrorKind::InvalidTargetException(_inner) => _inner.fmt(f),
            DeregisterTargetsErrorKind::TargetGroupNotFoundException(_inner) => _inner.fmt(f),
            DeregisterTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterTargetsError {
    fn code(&self) -> Option<&str> {
        DeregisterTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterTargetsError {
    /// Creates a new `DeregisterTargetsError`.
    pub fn new(kind: DeregisterTargetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterTargetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterTargetsErrorKind::InvalidTargetException`.
    pub fn is_invalid_target_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTargetsErrorKind::InvalidTargetException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterTargetsErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTargetsErrorKind::TargetGroupNotFoundException(_)
        )
    }
}
impl std::error::Error for DeregisterTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterTargetsErrorKind::InvalidTargetException(_inner) => Some(_inner),
            DeregisterTargetsErrorKind::TargetGroupNotFoundException(_inner) => Some(_inner),
            DeregisterTargetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountLimitsError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountLimitsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountLimitsError {
    fn code(&self) -> Option<&str> {
        DescribeAccountLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountLimitsError {
    /// Creates a new `DescribeAccountLimitsError`.
    pub fn new(kind: DescribeAccountLimitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountLimitsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeAccountLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountLimitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeListenerCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeListenerCertificatesError {
    /// Kind of error that occurred.
    pub kind: DescribeListenerCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeListenerCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeListenerCertificatesErrorKind {
    /// <p>The specified listener does not exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeListenerCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeListenerCertificatesErrorKind::ListenerNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeListenerCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeListenerCertificatesError {
    fn code(&self) -> Option<&str> {
        DescribeListenerCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeListenerCertificatesError {
    /// Creates a new `DescribeListenerCertificatesError`.
    pub fn new(kind: DescribeListenerCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeListenerCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeListenerCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeListenerCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeListenerCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeListenerCertificatesErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeListenerCertificatesErrorKind::ListenerNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeListenerCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeListenerCertificatesErrorKind::ListenerNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeListenerCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeListeners` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeListenersError {
    /// Kind of error that occurred.
    pub kind: DescribeListenersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeListeners` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeListenersErrorKind {
    /// <p>The specified listener does not exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// <p>The specified protocol is not supported.</p>
    UnsupportedProtocolException(crate::error::UnsupportedProtocolException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeListenersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeListenersErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            DescribeListenersErrorKind::LoadBalancerNotFoundException(_inner) => _inner.fmt(f),
            DescribeListenersErrorKind::UnsupportedProtocolException(_inner) => _inner.fmt(f),
            DescribeListenersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeListenersError {
    fn code(&self) -> Option<&str> {
        DescribeListenersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeListenersError {
    /// Creates a new `DescribeListenersError`.
    pub fn new(kind: DescribeListenersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeListenersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeListenersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeListenersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeListenersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeListenersErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeListenersErrorKind::ListenerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeListenersErrorKind::LoadBalancerNotFoundException`.
    pub fn is_load_balancer_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeListenersErrorKind::LoadBalancerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeListenersErrorKind::UnsupportedProtocolException`.
    pub fn is_unsupported_protocol_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeListenersErrorKind::UnsupportedProtocolException(_)
        )
    }
}
impl std::error::Error for DescribeListenersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeListenersErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            DescribeListenersErrorKind::LoadBalancerNotFoundException(_inner) => Some(_inner),
            DescribeListenersErrorKind::UnsupportedProtocolException(_inner) => Some(_inner),
            DescribeListenersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLoadBalancerAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLoadBalancerAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeLoadBalancerAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLoadBalancerAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLoadBalancerAttributesErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLoadBalancerAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLoadBalancerAttributesErrorKind::LoadBalancerNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeLoadBalancerAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLoadBalancerAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeLoadBalancerAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLoadBalancerAttributesError {
    /// Creates a new `DescribeLoadBalancerAttributesError`.
    pub fn new(
        kind: DescribeLoadBalancerAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLoadBalancerAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLoadBalancerAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLoadBalancerAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLoadBalancerAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLoadBalancerAttributesErrorKind::LoadBalancerNotFoundException`.
    pub fn is_load_balancer_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoadBalancerAttributesErrorKind::LoadBalancerNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeLoadBalancerAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLoadBalancerAttributesErrorKind::LoadBalancerNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeLoadBalancerAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLoadBalancers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLoadBalancersError {
    /// Kind of error that occurred.
    pub kind: DescribeLoadBalancersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLoadBalancers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLoadBalancersErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLoadBalancersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLoadBalancersErrorKind::LoadBalancerNotFoundException(_inner) => _inner.fmt(f),
            DescribeLoadBalancersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLoadBalancersError {
    fn code(&self) -> Option<&str> {
        DescribeLoadBalancersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLoadBalancersError {
    /// Creates a new `DescribeLoadBalancersError`.
    pub fn new(kind: DescribeLoadBalancersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLoadBalancersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLoadBalancersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLoadBalancersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLoadBalancersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLoadBalancersErrorKind::LoadBalancerNotFoundException`.
    pub fn is_load_balancer_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoadBalancersErrorKind::LoadBalancerNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeLoadBalancersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLoadBalancersErrorKind::LoadBalancerNotFoundException(_inner) => Some(_inner),
            DescribeLoadBalancersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRulesError {
    /// Kind of error that occurred.
    pub kind: DescribeRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRulesErrorKind {
    /// <p>The specified listener does not exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// <p>The specified rule does not exist.</p>
    RuleNotFoundException(crate::error::RuleNotFoundException),
    /// <p>The specified protocol is not supported.</p>
    UnsupportedProtocolException(crate::error::UnsupportedProtocolException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRulesErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            DescribeRulesErrorKind::RuleNotFoundException(_inner) => _inner.fmt(f),
            DescribeRulesErrorKind::UnsupportedProtocolException(_inner) => _inner.fmt(f),
            DescribeRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRulesError {
    fn code(&self) -> Option<&str> {
        DescribeRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRulesError {
    /// Creates a new `DescribeRulesError`.
    pub fn new(kind: DescribeRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRulesErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRulesErrorKind::ListenerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRulesErrorKind::RuleNotFoundException`.
    pub fn is_rule_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeRulesErrorKind::RuleNotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeRulesErrorKind::UnsupportedProtocolException`.
    pub fn is_unsupported_protocol_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRulesErrorKind::UnsupportedProtocolException(_)
        )
    }
}
impl std::error::Error for DescribeRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRulesErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            DescribeRulesErrorKind::RuleNotFoundException(_inner) => Some(_inner),
            DescribeRulesErrorKind::UnsupportedProtocolException(_inner) => Some(_inner),
            DescribeRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSSLPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSSLPoliciesError {
    /// Kind of error that occurred.
    pub kind: DescribeSSLPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSSLPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSSLPoliciesErrorKind {
    /// <p>The specified SSL policy does not exist.</p>
    SslPolicyNotFoundException(crate::error::SslPolicyNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSSLPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSSLPoliciesErrorKind::SslPolicyNotFoundException(_inner) => _inner.fmt(f),
            DescribeSSLPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSSLPoliciesError {
    fn code(&self) -> Option<&str> {
        DescribeSSLPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSSLPoliciesError {
    /// Creates a new `DescribeSSLPoliciesError`.
    pub fn new(kind: DescribeSSLPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSSLPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSSLPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSSLPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSSLPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSSLPoliciesErrorKind::SslPolicyNotFoundException`.
    pub fn is_ssl_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSSLPoliciesErrorKind::SslPolicyNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeSSLPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSSLPoliciesErrorKind::SslPolicyNotFoundException(_inner) => Some(_inner),
            DescribeSSLPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTagsError {
    /// Kind of error that occurred.
    pub kind: DescribeTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTagsErrorKind {
    /// <p>The specified listener does not exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// <p>The specified rule does not exist.</p>
    RuleNotFoundException(crate::error::RuleNotFoundException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTagsErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::LoadBalancerNotFoundException(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::RuleNotFoundException(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::TargetGroupNotFoundException(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTagsError {
    fn code(&self) -> Option<&str> {
        DescribeTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTagsError {
    /// Creates a new `DescribeTagsError`.
    pub fn new(kind: DescribeTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTagsErrorKind::ListenerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::LoadBalancerNotFoundException`.
    pub fn is_load_balancer_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTagsErrorKind::LoadBalancerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::RuleNotFoundException`.
    pub fn is_rule_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeTagsErrorKind::RuleNotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTagsErrorKind::TargetGroupNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTagsErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            DescribeTagsErrorKind::LoadBalancerNotFoundException(_inner) => Some(_inner),
            DescribeTagsErrorKind::RuleNotFoundException(_inner) => Some(_inner),
            DescribeTagsErrorKind::TargetGroupNotFoundException(_inner) => Some(_inner),
            DescribeTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTargetGroupAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTargetGroupAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeTargetGroupAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTargetGroupAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTargetGroupAttributesErrorKind {
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTargetGroupAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTargetGroupAttributesErrorKind::TargetGroupNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeTargetGroupAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTargetGroupAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeTargetGroupAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTargetGroupAttributesError {
    /// Creates a new `DescribeTargetGroupAttributesError`.
    pub fn new(
        kind: DescribeTargetGroupAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTargetGroupAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTargetGroupAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTargetGroupAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTargetGroupAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTargetGroupAttributesErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTargetGroupAttributesErrorKind::TargetGroupNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeTargetGroupAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTargetGroupAttributesErrorKind::TargetGroupNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeTargetGroupAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTargetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTargetGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeTargetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTargetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTargetGroupsErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTargetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTargetGroupsErrorKind::LoadBalancerNotFoundException(_inner) => _inner.fmt(f),
            DescribeTargetGroupsErrorKind::TargetGroupNotFoundException(_inner) => _inner.fmt(f),
            DescribeTargetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTargetGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeTargetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTargetGroupsError {
    /// Creates a new `DescribeTargetGroupsError`.
    pub fn new(kind: DescribeTargetGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTargetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTargetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTargetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTargetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTargetGroupsErrorKind::LoadBalancerNotFoundException`.
    pub fn is_load_balancer_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTargetGroupsErrorKind::LoadBalancerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTargetGroupsErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTargetGroupsErrorKind::TargetGroupNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeTargetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTargetGroupsErrorKind::LoadBalancerNotFoundException(_inner) => Some(_inner),
            DescribeTargetGroupsErrorKind::TargetGroupNotFoundException(_inner) => Some(_inner),
            DescribeTargetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTargetHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTargetHealthError {
    /// Kind of error that occurred.
    pub kind: DescribeTargetHealthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTargetHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTargetHealthErrorKind {
    /// <p>The health of the specified targets could not be retrieved due to an internal error.</p>
    HealthUnavailableException(crate::error::HealthUnavailableException),
    /// <p>The specified target does not exist, is not in the same VPC as the target group, or has an unsupported instance type.</p>
    InvalidTargetException(crate::error::InvalidTargetException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTargetHealthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTargetHealthErrorKind::HealthUnavailableException(_inner) => _inner.fmt(f),
            DescribeTargetHealthErrorKind::InvalidTargetException(_inner) => _inner.fmt(f),
            DescribeTargetHealthErrorKind::TargetGroupNotFoundException(_inner) => _inner.fmt(f),
            DescribeTargetHealthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTargetHealthError {
    fn code(&self) -> Option<&str> {
        DescribeTargetHealthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTargetHealthError {
    /// Creates a new `DescribeTargetHealthError`.
    pub fn new(kind: DescribeTargetHealthErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTargetHealthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTargetHealthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTargetHealthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTargetHealthErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTargetHealthErrorKind::HealthUnavailableException`.
    pub fn is_health_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTargetHealthErrorKind::HealthUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTargetHealthErrorKind::InvalidTargetException`.
    pub fn is_invalid_target_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTargetHealthErrorKind::InvalidTargetException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTargetHealthErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTargetHealthErrorKind::TargetGroupNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeTargetHealthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTargetHealthErrorKind::HealthUnavailableException(_inner) => Some(_inner),
            DescribeTargetHealthErrorKind::InvalidTargetException(_inner) => Some(_inner),
            DescribeTargetHealthErrorKind::TargetGroupNotFoundException(_inner) => Some(_inner),
            DescribeTargetHealthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyListenerError {
    /// Kind of error that occurred.
    pub kind: ModifyListenerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyListenerErrorKind {
    /// <p>The specified ALPN policy is not supported.</p>
    AlpnPolicyNotSupportedException(crate::error::AlpnPolicyNotSupportedException),
    /// <p>The specified certificate does not exist.</p>
    CertificateNotFoundException(crate::error::CertificateNotFoundException),
    /// <p>A listener with the specified port already exists.</p>
    DuplicateListenerException(crate::error::DuplicateListenerException),
    /// <p>The specified configuration is not valid with this protocol.</p>
    IncompatibleProtocolsException(crate::error::IncompatibleProtocolsException),
    /// <p>The requested configuration is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The requested action is not valid.</p>
    InvalidLoadBalancerActionException(crate::error::InvalidLoadBalancerActionException),
    /// <p>The specified listener does not exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// <p>The specified SSL policy does not exist.</p>
    SslPolicyNotFoundException(crate::error::SslPolicyNotFoundException),
    /// <p>You've reached the limit on the number of load balancers per target group.</p>
    TargetGroupAssociationLimitException(crate::error::TargetGroupAssociationLimitException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// <p>You've reached the limit on the number of actions per rule.</p>
    TooManyActionsException(crate::error::TooManyActionsException),
    /// <p>You've reached the limit on the number of certificates per load balancer.</p>
    TooManyCertificatesException(crate::error::TooManyCertificatesException),
    /// <p>You've reached the limit on the number of listeners per load balancer.</p>
    TooManyListenersException(crate::error::TooManyListenersException),
    /// <p>You've reached the limit on the number of times a target can be registered with a load balancer.</p>
    TooManyRegistrationsForTargetIdException(
        crate::error::TooManyRegistrationsForTargetIdException,
    ),
    /// <p>You've reached the limit on the number of targets.</p>
    TooManyTargetsException(crate::error::TooManyTargetsException),
    /// <p>You've reached the limit on the number of unique target groups per load balancer across all listeners. If a target group is used by multiple actions for a load balancer, it is counted as only one use.</p>
    TooManyUniqueTargetGroupsPerLoadBalancerException(
        crate::error::TooManyUniqueTargetGroupsPerLoadBalancerException,
    ),
    /// <p>The specified protocol is not supported.</p>
    UnsupportedProtocolException(crate::error::UnsupportedProtocolException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyListenerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyListenerErrorKind::AlpnPolicyNotSupportedException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::CertificateNotFoundException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::DuplicateListenerException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::IncompatibleProtocolsException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::InvalidConfigurationRequestException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::InvalidLoadBalancerActionException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::SslPolicyNotFoundException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::TargetGroupAssociationLimitException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::TargetGroupNotFoundException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::TooManyActionsException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::TooManyCertificatesException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::TooManyListenersException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::TooManyRegistrationsForTargetIdException(_inner) => {
                _inner.fmt(f)
            }
            ModifyListenerErrorKind::TooManyTargetsException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(_inner) => {
                _inner.fmt(f)
            }
            ModifyListenerErrorKind::UnsupportedProtocolException(_inner) => _inner.fmt(f),
            ModifyListenerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyListenerError {
    fn code(&self) -> Option<&str> {
        ModifyListenerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyListenerError {
    /// Creates a new `ModifyListenerError`.
    pub fn new(kind: ModifyListenerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyListenerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyListenerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyListenerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyListenerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::AlpnPolicyNotSupportedException`.
    pub fn is_alpn_policy_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::AlpnPolicyNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::CertificateNotFoundException`.
    pub fn is_certificate_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::CertificateNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::DuplicateListenerException`.
    pub fn is_duplicate_listener_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::DuplicateListenerException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::IncompatibleProtocolsException`.
    pub fn is_incompatible_protocols_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::IncompatibleProtocolsException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::InvalidLoadBalancerActionException`.
    pub fn is_invalid_load_balancer_action_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::InvalidLoadBalancerActionException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::ListenerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::SslPolicyNotFoundException`.
    pub fn is_ssl_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::SslPolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::TargetGroupAssociationLimitException`.
    pub fn is_target_group_association_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::TargetGroupAssociationLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::TargetGroupNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::TooManyActionsException`.
    pub fn is_too_many_actions_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::TooManyActionsException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::TooManyCertificatesException`.
    pub fn is_too_many_certificates_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::TooManyCertificatesException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::TooManyListenersException`.
    pub fn is_too_many_listeners_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::TooManyListenersException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::TooManyRegistrationsForTargetIdException`.
    pub fn is_too_many_registrations_for_target_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::TooManyRegistrationsForTargetIdException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::TooManyTargetsException`.
    pub fn is_too_many_targets_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::TooManyTargetsException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException`.
    pub fn is_too_many_unique_target_groups_per_load_balancer_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyListenerErrorKind::UnsupportedProtocolException`.
    pub fn is_unsupported_protocol_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyListenerErrorKind::UnsupportedProtocolException(_)
        )
    }
}
impl std::error::Error for ModifyListenerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyListenerErrorKind::AlpnPolicyNotSupportedException(_inner) => Some(_inner),
            ModifyListenerErrorKind::CertificateNotFoundException(_inner) => Some(_inner),
            ModifyListenerErrorKind::DuplicateListenerException(_inner) => Some(_inner),
            ModifyListenerErrorKind::IncompatibleProtocolsException(_inner) => Some(_inner),
            ModifyListenerErrorKind::InvalidConfigurationRequestException(_inner) => Some(_inner),
            ModifyListenerErrorKind::InvalidLoadBalancerActionException(_inner) => Some(_inner),
            ModifyListenerErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            ModifyListenerErrorKind::SslPolicyNotFoundException(_inner) => Some(_inner),
            ModifyListenerErrorKind::TargetGroupAssociationLimitException(_inner) => Some(_inner),
            ModifyListenerErrorKind::TargetGroupNotFoundException(_inner) => Some(_inner),
            ModifyListenerErrorKind::TooManyActionsException(_inner) => Some(_inner),
            ModifyListenerErrorKind::TooManyCertificatesException(_inner) => Some(_inner),
            ModifyListenerErrorKind::TooManyListenersException(_inner) => Some(_inner),
            ModifyListenerErrorKind::TooManyRegistrationsForTargetIdException(_inner) => {
                Some(_inner)
            }
            ModifyListenerErrorKind::TooManyTargetsException(_inner) => Some(_inner),
            ModifyListenerErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(_inner) => {
                Some(_inner)
            }
            ModifyListenerErrorKind::UnsupportedProtocolException(_inner) => Some(_inner),
            ModifyListenerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyLoadBalancerAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyLoadBalancerAttributesError {
    /// Kind of error that occurred.
    pub kind: ModifyLoadBalancerAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyLoadBalancerAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyLoadBalancerAttributesErrorKind {
    /// <p>The requested configuration is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyLoadBalancerAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyLoadBalancerAttributesErrorKind::InvalidConfigurationRequestException(_inner) => {
                _inner.fmt(f)
            }
            ModifyLoadBalancerAttributesErrorKind::LoadBalancerNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ModifyLoadBalancerAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyLoadBalancerAttributesError {
    fn code(&self) -> Option<&str> {
        ModifyLoadBalancerAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyLoadBalancerAttributesError {
    /// Creates a new `ModifyLoadBalancerAttributesError`.
    pub fn new(kind: ModifyLoadBalancerAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyLoadBalancerAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyLoadBalancerAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyLoadBalancerAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyLoadBalancerAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyLoadBalancerAttributesErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyLoadBalancerAttributesErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyLoadBalancerAttributesErrorKind::LoadBalancerNotFoundException`.
    pub fn is_load_balancer_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyLoadBalancerAttributesErrorKind::LoadBalancerNotFoundException(_)
        )
    }
}
impl std::error::Error for ModifyLoadBalancerAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyLoadBalancerAttributesErrorKind::InvalidConfigurationRequestException(_inner) => {
                Some(_inner)
            }
            ModifyLoadBalancerAttributesErrorKind::LoadBalancerNotFoundException(_inner) => {
                Some(_inner)
            }
            ModifyLoadBalancerAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyRuleError {
    /// Kind of error that occurred.
    pub kind: ModifyRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyRuleErrorKind {
    /// <p>The specified configuration is not valid with this protocol.</p>
    IncompatibleProtocolsException(crate::error::IncompatibleProtocolsException),
    /// <p>The requested action is not valid.</p>
    InvalidLoadBalancerActionException(crate::error::InvalidLoadBalancerActionException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified rule does not exist.</p>
    RuleNotFoundException(crate::error::RuleNotFoundException),
    /// <p>You've reached the limit on the number of load balancers per target group.</p>
    TargetGroupAssociationLimitException(crate::error::TargetGroupAssociationLimitException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// <p>You've reached the limit on the number of actions per rule.</p>
    TooManyActionsException(crate::error::TooManyActionsException),
    /// <p>You've reached the limit on the number of times a target can be registered with a load balancer.</p>
    TooManyRegistrationsForTargetIdException(
        crate::error::TooManyRegistrationsForTargetIdException,
    ),
    /// <p>You've reached the limit on the number of targets.</p>
    TooManyTargetsException(crate::error::TooManyTargetsException),
    /// <p>You've reached the limit on the number of unique target groups per load balancer across all listeners. If a target group is used by multiple actions for a load balancer, it is counted as only one use.</p>
    TooManyUniqueTargetGroupsPerLoadBalancerException(
        crate::error::TooManyUniqueTargetGroupsPerLoadBalancerException,
    ),
    /// <p>The specified protocol is not supported.</p>
    UnsupportedProtocolException(crate::error::UnsupportedProtocolException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyRuleErrorKind::IncompatibleProtocolsException(_inner) => _inner.fmt(f),
            ModifyRuleErrorKind::InvalidLoadBalancerActionException(_inner) => _inner.fmt(f),
            ModifyRuleErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            ModifyRuleErrorKind::RuleNotFoundException(_inner) => _inner.fmt(f),
            ModifyRuleErrorKind::TargetGroupAssociationLimitException(_inner) => _inner.fmt(f),
            ModifyRuleErrorKind::TargetGroupNotFoundException(_inner) => _inner.fmt(f),
            ModifyRuleErrorKind::TooManyActionsException(_inner) => _inner.fmt(f),
            ModifyRuleErrorKind::TooManyRegistrationsForTargetIdException(_inner) => _inner.fmt(f),
            ModifyRuleErrorKind::TooManyTargetsException(_inner) => _inner.fmt(f),
            ModifyRuleErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(_inner) => {
                _inner.fmt(f)
            }
            ModifyRuleErrorKind::UnsupportedProtocolException(_inner) => _inner.fmt(f),
            ModifyRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyRuleError {
    fn code(&self) -> Option<&str> {
        ModifyRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyRuleError {
    /// Creates a new `ModifyRuleError`.
    pub fn new(kind: ModifyRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyRuleErrorKind::IncompatibleProtocolsException`.
    pub fn is_incompatible_protocols_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyRuleErrorKind::IncompatibleProtocolsException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyRuleErrorKind::InvalidLoadBalancerActionException`.
    pub fn is_invalid_load_balancer_action_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyRuleErrorKind::InvalidLoadBalancerActionException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyRuleErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyRuleErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyRuleErrorKind::RuleNotFoundException`.
    pub fn is_rule_not_found_exception(&self) -> bool {
        matches!(&self.kind, ModifyRuleErrorKind::RuleNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ModifyRuleErrorKind::TargetGroupAssociationLimitException`.
    pub fn is_target_group_association_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyRuleErrorKind::TargetGroupAssociationLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyRuleErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyRuleErrorKind::TargetGroupNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyRuleErrorKind::TooManyActionsException`.
    pub fn is_too_many_actions_exception(&self) -> bool {
        matches!(&self.kind, ModifyRuleErrorKind::TooManyActionsException(_))
    }
    /// Returns `true` if the error kind is `ModifyRuleErrorKind::TooManyRegistrationsForTargetIdException`.
    pub fn is_too_many_registrations_for_target_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyRuleErrorKind::TooManyRegistrationsForTargetIdException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyRuleErrorKind::TooManyTargetsException`.
    pub fn is_too_many_targets_exception(&self) -> bool {
        matches!(&self.kind, ModifyRuleErrorKind::TooManyTargetsException(_))
    }
    /// Returns `true` if the error kind is `ModifyRuleErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException`.
    pub fn is_too_many_unique_target_groups_per_load_balancer_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyRuleErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyRuleErrorKind::UnsupportedProtocolException`.
    pub fn is_unsupported_protocol_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyRuleErrorKind::UnsupportedProtocolException(_)
        )
    }
}
impl std::error::Error for ModifyRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyRuleErrorKind::IncompatibleProtocolsException(_inner) => Some(_inner),
            ModifyRuleErrorKind::InvalidLoadBalancerActionException(_inner) => Some(_inner),
            ModifyRuleErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            ModifyRuleErrorKind::RuleNotFoundException(_inner) => Some(_inner),
            ModifyRuleErrorKind::TargetGroupAssociationLimitException(_inner) => Some(_inner),
            ModifyRuleErrorKind::TargetGroupNotFoundException(_inner) => Some(_inner),
            ModifyRuleErrorKind::TooManyActionsException(_inner) => Some(_inner),
            ModifyRuleErrorKind::TooManyRegistrationsForTargetIdException(_inner) => Some(_inner),
            ModifyRuleErrorKind::TooManyTargetsException(_inner) => Some(_inner),
            ModifyRuleErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(_inner) => {
                Some(_inner)
            }
            ModifyRuleErrorKind::UnsupportedProtocolException(_inner) => Some(_inner),
            ModifyRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyTargetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyTargetGroupError {
    /// Kind of error that occurred.
    pub kind: ModifyTargetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyTargetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyTargetGroupErrorKind {
    /// <p>The requested configuration is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyTargetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyTargetGroupErrorKind::InvalidConfigurationRequestException(_inner) => {
                _inner.fmt(f)
            }
            ModifyTargetGroupErrorKind::TargetGroupNotFoundException(_inner) => _inner.fmt(f),
            ModifyTargetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyTargetGroupError {
    fn code(&self) -> Option<&str> {
        ModifyTargetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyTargetGroupError {
    /// Creates a new `ModifyTargetGroupError`.
    pub fn new(kind: ModifyTargetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyTargetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyTargetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyTargetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyTargetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyTargetGroupErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyTargetGroupErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyTargetGroupErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyTargetGroupErrorKind::TargetGroupNotFoundException(_)
        )
    }
}
impl std::error::Error for ModifyTargetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyTargetGroupErrorKind::InvalidConfigurationRequestException(_inner) => {
                Some(_inner)
            }
            ModifyTargetGroupErrorKind::TargetGroupNotFoundException(_inner) => Some(_inner),
            ModifyTargetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyTargetGroupAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyTargetGroupAttributesError {
    /// Kind of error that occurred.
    pub kind: ModifyTargetGroupAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyTargetGroupAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyTargetGroupAttributesErrorKind {
    /// <p>The requested configuration is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyTargetGroupAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyTargetGroupAttributesErrorKind::InvalidConfigurationRequestException(_inner) => {
                _inner.fmt(f)
            }
            ModifyTargetGroupAttributesErrorKind::TargetGroupNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ModifyTargetGroupAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyTargetGroupAttributesError {
    fn code(&self) -> Option<&str> {
        ModifyTargetGroupAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyTargetGroupAttributesError {
    /// Creates a new `ModifyTargetGroupAttributesError`.
    pub fn new(kind: ModifyTargetGroupAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyTargetGroupAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyTargetGroupAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyTargetGroupAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyTargetGroupAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyTargetGroupAttributesErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyTargetGroupAttributesErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyTargetGroupAttributesErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyTargetGroupAttributesErrorKind::TargetGroupNotFoundException(_)
        )
    }
}
impl std::error::Error for ModifyTargetGroupAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyTargetGroupAttributesErrorKind::InvalidConfigurationRequestException(_inner) => {
                Some(_inner)
            }
            ModifyTargetGroupAttributesErrorKind::TargetGroupNotFoundException(_inner) => {
                Some(_inner)
            }
            ModifyTargetGroupAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterTargetsError {
    /// Kind of error that occurred.
    pub kind: RegisterTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterTargetsErrorKind {
    /// <p>The specified target does not exist, is not in the same VPC as the target group, or has an unsupported instance type.</p>
    InvalidTargetException(crate::error::InvalidTargetException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// <p>You've reached the limit on the number of times a target can be registered with a load balancer.</p>
    TooManyRegistrationsForTargetIdException(
        crate::error::TooManyRegistrationsForTargetIdException,
    ),
    /// <p>You've reached the limit on the number of targets.</p>
    TooManyTargetsException(crate::error::TooManyTargetsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterTargetsErrorKind::InvalidTargetException(_inner) => _inner.fmt(f),
            RegisterTargetsErrorKind::TargetGroupNotFoundException(_inner) => _inner.fmt(f),
            RegisterTargetsErrorKind::TooManyRegistrationsForTargetIdException(_inner) => {
                _inner.fmt(f)
            }
            RegisterTargetsErrorKind::TooManyTargetsException(_inner) => _inner.fmt(f),
            RegisterTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterTargetsError {
    fn code(&self) -> Option<&str> {
        RegisterTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterTargetsError {
    /// Creates a new `RegisterTargetsError`.
    pub fn new(kind: RegisterTargetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterTargetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterTargetsErrorKind::InvalidTargetException`.
    pub fn is_invalid_target_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTargetsErrorKind::InvalidTargetException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTargetsErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTargetsErrorKind::TargetGroupNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTargetsErrorKind::TooManyRegistrationsForTargetIdException`.
    pub fn is_too_many_registrations_for_target_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTargetsErrorKind::TooManyRegistrationsForTargetIdException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTargetsErrorKind::TooManyTargetsException`.
    pub fn is_too_many_targets_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTargetsErrorKind::TooManyTargetsException(_)
        )
    }
}
impl std::error::Error for RegisterTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterTargetsErrorKind::InvalidTargetException(_inner) => Some(_inner),
            RegisterTargetsErrorKind::TargetGroupNotFoundException(_inner) => Some(_inner),
            RegisterTargetsErrorKind::TooManyRegistrationsForTargetIdException(_inner) => {
                Some(_inner)
            }
            RegisterTargetsErrorKind::TooManyTargetsException(_inner) => Some(_inner),
            RegisterTargetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveListenerCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveListenerCertificatesError {
    /// Kind of error that occurred.
    pub kind: RemoveListenerCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveListenerCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveListenerCertificatesErrorKind {
    /// <p>The specified listener does not exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveListenerCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveListenerCertificatesErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            RemoveListenerCertificatesErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            RemoveListenerCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveListenerCertificatesError {
    fn code(&self) -> Option<&str> {
        RemoveListenerCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveListenerCertificatesError {
    /// Creates a new `RemoveListenerCertificatesError`.
    pub fn new(kind: RemoveListenerCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveListenerCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveListenerCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveListenerCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveListenerCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveListenerCertificatesErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveListenerCertificatesErrorKind::ListenerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveListenerCertificatesErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveListenerCertificatesErrorKind::OperationNotPermittedException(_)
        )
    }
}
impl std::error::Error for RemoveListenerCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveListenerCertificatesErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            RemoveListenerCertificatesErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            RemoveListenerCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsErrorKind {
    /// <p>The specified listener does not exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// <p>The specified rule does not exist.</p>
    RuleNotFoundException(crate::error::RuleNotFoundException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// <p>You've reached the limit on the number of tags per load balancer.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::LoadBalancerNotFoundException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::RuleNotFoundException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::TargetGroupNotFoundException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsError {
    fn code(&self) -> Option<&str> {
        RemoveTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsError {
    /// Creates a new `RemoveTagsError`.
    pub fn new(kind: RemoveTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::ListenerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::LoadBalancerNotFoundException`.
    pub fn is_load_balancer_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::LoadBalancerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::RuleNotFoundException`.
    pub fn is_rule_not_found_exception(&self) -> bool {
        matches!(&self.kind, RemoveTagsErrorKind::RuleNotFoundException(_))
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::TargetGroupNotFoundException`.
    pub fn is_target_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::TargetGroupNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, RemoveTagsErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for RemoveTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            RemoveTagsErrorKind::LoadBalancerNotFoundException(_inner) => Some(_inner),
            RemoveTagsErrorKind::RuleNotFoundException(_inner) => Some(_inner),
            RemoveTagsErrorKind::TargetGroupNotFoundException(_inner) => Some(_inner),
            RemoveTagsErrorKind::TooManyTagsException(_inner) => Some(_inner),
            RemoveTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetIpAddressType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetIpAddressTypeError {
    /// Kind of error that occurred.
    pub kind: SetIpAddressTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetIpAddressType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetIpAddressTypeErrorKind {
    /// <p>The requested configuration is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The specified subnet is out of available addresses.</p>
    InvalidSubnetException(crate::error::InvalidSubnetException),
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetIpAddressTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetIpAddressTypeErrorKind::InvalidConfigurationRequestException(_inner) => {
                _inner.fmt(f)
            }
            SetIpAddressTypeErrorKind::InvalidSubnetException(_inner) => _inner.fmt(f),
            SetIpAddressTypeErrorKind::LoadBalancerNotFoundException(_inner) => _inner.fmt(f),
            SetIpAddressTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetIpAddressTypeError {
    fn code(&self) -> Option<&str> {
        SetIpAddressTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetIpAddressTypeError {
    /// Creates a new `SetIpAddressTypeError`.
    pub fn new(kind: SetIpAddressTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetIpAddressTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetIpAddressTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetIpAddressTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetIpAddressTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetIpAddressTypeErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetIpAddressTypeErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `SetIpAddressTypeErrorKind::InvalidSubnetException`.
    pub fn is_invalid_subnet_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetIpAddressTypeErrorKind::InvalidSubnetException(_)
        )
    }
    /// Returns `true` if the error kind is `SetIpAddressTypeErrorKind::LoadBalancerNotFoundException`.
    pub fn is_load_balancer_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetIpAddressTypeErrorKind::LoadBalancerNotFoundException(_)
        )
    }
}
impl std::error::Error for SetIpAddressTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetIpAddressTypeErrorKind::InvalidConfigurationRequestException(_inner) => Some(_inner),
            SetIpAddressTypeErrorKind::InvalidSubnetException(_inner) => Some(_inner),
            SetIpAddressTypeErrorKind::LoadBalancerNotFoundException(_inner) => Some(_inner),
            SetIpAddressTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetRulePriorities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetRulePrioritiesError {
    /// Kind of error that occurred.
    pub kind: SetRulePrioritiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetRulePriorities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetRulePrioritiesErrorKind {
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified priority is in use.</p>
    PriorityInUseException(crate::error::PriorityInUseException),
    /// <p>The specified rule does not exist.</p>
    RuleNotFoundException(crate::error::RuleNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetRulePrioritiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetRulePrioritiesErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            SetRulePrioritiesErrorKind::PriorityInUseException(_inner) => _inner.fmt(f),
            SetRulePrioritiesErrorKind::RuleNotFoundException(_inner) => _inner.fmt(f),
            SetRulePrioritiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetRulePrioritiesError {
    fn code(&self) -> Option<&str> {
        SetRulePrioritiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetRulePrioritiesError {
    /// Creates a new `SetRulePrioritiesError`.
    pub fn new(kind: SetRulePrioritiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetRulePrioritiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetRulePrioritiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetRulePrioritiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetRulePrioritiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetRulePrioritiesErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRulePrioritiesErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetRulePrioritiesErrorKind::PriorityInUseException`.
    pub fn is_priority_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRulePrioritiesErrorKind::PriorityInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `SetRulePrioritiesErrorKind::RuleNotFoundException`.
    pub fn is_rule_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRulePrioritiesErrorKind::RuleNotFoundException(_)
        )
    }
}
impl std::error::Error for SetRulePrioritiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetRulePrioritiesErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            SetRulePrioritiesErrorKind::PriorityInUseException(_inner) => Some(_inner),
            SetRulePrioritiesErrorKind::RuleNotFoundException(_inner) => Some(_inner),
            SetRulePrioritiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetSecurityGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetSecurityGroupsError {
    /// Kind of error that occurred.
    pub kind: SetSecurityGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetSecurityGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetSecurityGroupsErrorKind {
    /// <p>The requested configuration is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The specified security group does not exist.</p>
    InvalidSecurityGroupException(crate::error::InvalidSecurityGroupException),
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetSecurityGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetSecurityGroupsErrorKind::InvalidConfigurationRequestException(_inner) => {
                _inner.fmt(f)
            }
            SetSecurityGroupsErrorKind::InvalidSecurityGroupException(_inner) => _inner.fmt(f),
            SetSecurityGroupsErrorKind::LoadBalancerNotFoundException(_inner) => _inner.fmt(f),
            SetSecurityGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetSecurityGroupsError {
    fn code(&self) -> Option<&str> {
        SetSecurityGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetSecurityGroupsError {
    /// Creates a new `SetSecurityGroupsError`.
    pub fn new(kind: SetSecurityGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetSecurityGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetSecurityGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetSecurityGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetSecurityGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetSecurityGroupsErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSecurityGroupsErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `SetSecurityGroupsErrorKind::InvalidSecurityGroupException`.
    pub fn is_invalid_security_group_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSecurityGroupsErrorKind::InvalidSecurityGroupException(_)
        )
    }
    /// Returns `true` if the error kind is `SetSecurityGroupsErrorKind::LoadBalancerNotFoundException`.
    pub fn is_load_balancer_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSecurityGroupsErrorKind::LoadBalancerNotFoundException(_)
        )
    }
}
impl std::error::Error for SetSecurityGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetSecurityGroupsErrorKind::InvalidConfigurationRequestException(_inner) => {
                Some(_inner)
            }
            SetSecurityGroupsErrorKind::InvalidSecurityGroupException(_inner) => Some(_inner),
            SetSecurityGroupsErrorKind::LoadBalancerNotFoundException(_inner) => Some(_inner),
            SetSecurityGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetSubnets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetSubnetsError {
    /// Kind of error that occurred.
    pub kind: SetSubnetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetSubnets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetSubnetsErrorKind {
    /// <p>The specified allocation ID does not exist.</p>
    AllocationIdNotFoundException(crate::error::AllocationIdNotFoundException),
    /// <p>The specified Availability Zone is not supported.</p>
    AvailabilityZoneNotSupportedException(crate::error::AvailabilityZoneNotSupportedException),
    /// <p>The requested configuration is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The specified subnet is out of available addresses.</p>
    InvalidSubnetException(crate::error::InvalidSubnetException),
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// <p>The specified subnet does not exist.</p>
    SubnetNotFoundException(crate::error::SubnetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetSubnetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetSubnetsErrorKind::AllocationIdNotFoundException(_inner) => _inner.fmt(f),
            SetSubnetsErrorKind::AvailabilityZoneNotSupportedException(_inner) => _inner.fmt(f),
            SetSubnetsErrorKind::InvalidConfigurationRequestException(_inner) => _inner.fmt(f),
            SetSubnetsErrorKind::InvalidSubnetException(_inner) => _inner.fmt(f),
            SetSubnetsErrorKind::LoadBalancerNotFoundException(_inner) => _inner.fmt(f),
            SetSubnetsErrorKind::SubnetNotFoundException(_inner) => _inner.fmt(f),
            SetSubnetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetSubnetsError {
    fn code(&self) -> Option<&str> {
        SetSubnetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetSubnetsError {
    /// Creates a new `SetSubnetsError`.
    pub fn new(kind: SetSubnetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetSubnetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetSubnetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetSubnetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetSubnetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetSubnetsErrorKind::AllocationIdNotFoundException`.
    pub fn is_allocation_id_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSubnetsErrorKind::AllocationIdNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetSubnetsErrorKind::AvailabilityZoneNotSupportedException`.
    pub fn is_availability_zone_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSubnetsErrorKind::AvailabilityZoneNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetSubnetsErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSubnetsErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `SetSubnetsErrorKind::InvalidSubnetException`.
    pub fn is_invalid_subnet_exception(&self) -> bool {
        matches!(&self.kind, SetSubnetsErrorKind::InvalidSubnetException(_))
    }
    /// Returns `true` if the error kind is `SetSubnetsErrorKind::LoadBalancerNotFoundException`.
    pub fn is_load_balancer_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSubnetsErrorKind::LoadBalancerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetSubnetsErrorKind::SubnetNotFoundException`.
    pub fn is_subnet_not_found_exception(&self) -> bool {
        matches!(&self.kind, SetSubnetsErrorKind::SubnetNotFoundException(_))
    }
}
impl std::error::Error for SetSubnetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetSubnetsErrorKind::AllocationIdNotFoundException(_inner) => Some(_inner),
            SetSubnetsErrorKind::AvailabilityZoneNotSupportedException(_inner) => Some(_inner),
            SetSubnetsErrorKind::InvalidConfigurationRequestException(_inner) => Some(_inner),
            SetSubnetsErrorKind::InvalidSubnetException(_inner) => Some(_inner),
            SetSubnetsErrorKind::LoadBalancerNotFoundException(_inner) => Some(_inner),
            SetSubnetsErrorKind::SubnetNotFoundException(_inner) => Some(_inner),
            SetSubnetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified subnet does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetNotFoundException {}
/// See [`SubnetNotFoundException`](crate::error::SubnetNotFoundException)
pub mod subnet_not_found_exception {
    /// A builder for [`SubnetNotFoundException`](crate::error::SubnetNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetNotFoundException`](crate::error::SubnetNotFoundException)
        pub fn build(self) -> crate::error::SubnetNotFoundException {
            crate::error::SubnetNotFoundException {
                message: self.message,
            }
        }
    }
}
impl SubnetNotFoundException {
    /// Creates a new builder-style object to manufacture [`SubnetNotFoundException`](crate::error::SubnetNotFoundException)
    pub fn builder() -> crate::error::subnet_not_found_exception::Builder {
        crate::error::subnet_not_found_exception::Builder::default()
    }
}

/// <p>The specified load balancer does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancerNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LoadBalancerNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancerNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LoadBalancerNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LoadBalancerNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LoadBalancerNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for LoadBalancerNotFoundException {}
/// See [`LoadBalancerNotFoundException`](crate::error::LoadBalancerNotFoundException)
pub mod load_balancer_not_found_exception {
    /// A builder for [`LoadBalancerNotFoundException`](crate::error::LoadBalancerNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancerNotFoundException`](crate::error::LoadBalancerNotFoundException)
        pub fn build(self) -> crate::error::LoadBalancerNotFoundException {
            crate::error::LoadBalancerNotFoundException {
                message: self.message,
            }
        }
    }
}
impl LoadBalancerNotFoundException {
    /// Creates a new builder-style object to manufacture [`LoadBalancerNotFoundException`](crate::error::LoadBalancerNotFoundException)
    pub fn builder() -> crate::error::load_balancer_not_found_exception::Builder {
        crate::error::load_balancer_not_found_exception::Builder::default()
    }
}

/// <p>The specified subnet is out of available addresses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSubnetException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSubnetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSubnetException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSubnetException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSubnetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSubnetException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSubnetException {}
/// See [`InvalidSubnetException`](crate::error::InvalidSubnetException)
pub mod invalid_subnet_exception {
    /// A builder for [`InvalidSubnetException`](crate::error::InvalidSubnetException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSubnetException`](crate::error::InvalidSubnetException)
        pub fn build(self) -> crate::error::InvalidSubnetException {
            crate::error::InvalidSubnetException {
                message: self.message,
            }
        }
    }
}
impl InvalidSubnetException {
    /// Creates a new builder-style object to manufacture [`InvalidSubnetException`](crate::error::InvalidSubnetException)
    pub fn builder() -> crate::error::invalid_subnet_exception::Builder {
        crate::error::invalid_subnet_exception::Builder::default()
    }
}

/// <p>The requested configuration is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidConfigurationRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidConfigurationRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidConfigurationRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidConfigurationRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidConfigurationRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidConfigurationRequestException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidConfigurationRequestException {}
/// See [`InvalidConfigurationRequestException`](crate::error::InvalidConfigurationRequestException)
pub mod invalid_configuration_request_exception {
    /// A builder for [`InvalidConfigurationRequestException`](crate::error::InvalidConfigurationRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidConfigurationRequestException`](crate::error::InvalidConfigurationRequestException)
        pub fn build(self) -> crate::error::InvalidConfigurationRequestException {
            crate::error::InvalidConfigurationRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidConfigurationRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidConfigurationRequestException`](crate::error::InvalidConfigurationRequestException)
    pub fn builder() -> crate::error::invalid_configuration_request_exception::Builder {
        crate::error::invalid_configuration_request_exception::Builder::default()
    }
}

/// <p>The specified Availability Zone is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailabilityZoneNotSupportedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AvailabilityZoneNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailabilityZoneNotSupportedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AvailabilityZoneNotSupportedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AvailabilityZoneNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AvailabilityZoneNotSupportedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AvailabilityZoneNotSupportedException {}
/// See [`AvailabilityZoneNotSupportedException`](crate::error::AvailabilityZoneNotSupportedException)
pub mod availability_zone_not_supported_exception {
    /// A builder for [`AvailabilityZoneNotSupportedException`](crate::error::AvailabilityZoneNotSupportedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailabilityZoneNotSupportedException`](crate::error::AvailabilityZoneNotSupportedException)
        pub fn build(self) -> crate::error::AvailabilityZoneNotSupportedException {
            crate::error::AvailabilityZoneNotSupportedException {
                message: self.message,
            }
        }
    }
}
impl AvailabilityZoneNotSupportedException {
    /// Creates a new builder-style object to manufacture [`AvailabilityZoneNotSupportedException`](crate::error::AvailabilityZoneNotSupportedException)
    pub fn builder() -> crate::error::availability_zone_not_supported_exception::Builder {
        crate::error::availability_zone_not_supported_exception::Builder::default()
    }
}

/// <p>The specified allocation ID does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllocationIdNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AllocationIdNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllocationIdNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AllocationIdNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AllocationIdNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AllocationIdNotFoundException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AllocationIdNotFoundException {}
/// See [`AllocationIdNotFoundException`](crate::error::AllocationIdNotFoundException)
pub mod allocation_id_not_found_exception {
    /// A builder for [`AllocationIdNotFoundException`](crate::error::AllocationIdNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocationIdNotFoundException`](crate::error::AllocationIdNotFoundException)
        pub fn build(self) -> crate::error::AllocationIdNotFoundException {
            crate::error::AllocationIdNotFoundException {
                message: self.message,
            }
        }
    }
}
impl AllocationIdNotFoundException {
    /// Creates a new builder-style object to manufacture [`AllocationIdNotFoundException`](crate::error::AllocationIdNotFoundException)
    pub fn builder() -> crate::error::allocation_id_not_found_exception::Builder {
        crate::error::allocation_id_not_found_exception::Builder::default()
    }
}

/// <p>The specified security group does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSecurityGroupException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSecurityGroupException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSecurityGroupException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSecurityGroupException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSecurityGroupException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSecurityGroupException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSecurityGroupException {}
/// See [`InvalidSecurityGroupException`](crate::error::InvalidSecurityGroupException)
pub mod invalid_security_group_exception {
    /// A builder for [`InvalidSecurityGroupException`](crate::error::InvalidSecurityGroupException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSecurityGroupException`](crate::error::InvalidSecurityGroupException)
        pub fn build(self) -> crate::error::InvalidSecurityGroupException {
            crate::error::InvalidSecurityGroupException {
                message: self.message,
            }
        }
    }
}
impl InvalidSecurityGroupException {
    /// Creates a new builder-style object to manufacture [`InvalidSecurityGroupException`](crate::error::InvalidSecurityGroupException)
    pub fn builder() -> crate::error::invalid_security_group_exception::Builder {
        crate::error::invalid_security_group_exception::Builder::default()
    }
}

/// <p>The specified rule does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RuleNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RuleNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RuleNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RuleNotFoundException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for RuleNotFoundException {}
/// See [`RuleNotFoundException`](crate::error::RuleNotFoundException)
pub mod rule_not_found_exception {
    /// A builder for [`RuleNotFoundException`](crate::error::RuleNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleNotFoundException`](crate::error::RuleNotFoundException)
        pub fn build(self) -> crate::error::RuleNotFoundException {
            crate::error::RuleNotFoundException {
                message: self.message,
            }
        }
    }
}
impl RuleNotFoundException {
    /// Creates a new builder-style object to manufacture [`RuleNotFoundException`](crate::error::RuleNotFoundException)
    pub fn builder() -> crate::error::rule_not_found_exception::Builder {
        crate::error::rule_not_found_exception::Builder::default()
    }
}

/// <p>The specified priority is in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PriorityInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PriorityInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PriorityInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PriorityInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PriorityInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PriorityInUseException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for PriorityInUseException {}
/// See [`PriorityInUseException`](crate::error::PriorityInUseException)
pub mod priority_in_use_exception {
    /// A builder for [`PriorityInUseException`](crate::error::PriorityInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PriorityInUseException`](crate::error::PriorityInUseException)
        pub fn build(self) -> crate::error::PriorityInUseException {
            crate::error::PriorityInUseException {
                message: self.message,
            }
        }
    }
}
impl PriorityInUseException {
    /// Creates a new builder-style object to manufacture [`PriorityInUseException`](crate::error::PriorityInUseException)
    pub fn builder() -> crate::error::priority_in_use_exception::Builder {
        crate::error::priority_in_use_exception::Builder::default()
    }
}

/// <p>This operation is not allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationNotPermittedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationNotPermittedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationNotPermittedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationNotPermittedException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationNotPermittedException {}
/// See [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
pub mod operation_not_permitted_exception {
    /// A builder for [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
        pub fn build(self) -> crate::error::OperationNotPermittedException {
            crate::error::OperationNotPermittedException {
                message: self.message,
            }
        }
    }
}
impl OperationNotPermittedException {
    /// Creates a new builder-style object to manufacture [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
    pub fn builder() -> crate::error::operation_not_permitted_exception::Builder {
        crate::error::operation_not_permitted_exception::Builder::default()
    }
}

/// <p>You've reached the limit on the number of tags per load balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The specified target group does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetGroupNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TargetGroupNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetGroupNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TargetGroupNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TargetGroupNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TargetGroupNotFoundException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for TargetGroupNotFoundException {}
/// See [`TargetGroupNotFoundException`](crate::error::TargetGroupNotFoundException)
pub mod target_group_not_found_exception {
    /// A builder for [`TargetGroupNotFoundException`](crate::error::TargetGroupNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetGroupNotFoundException`](crate::error::TargetGroupNotFoundException)
        pub fn build(self) -> crate::error::TargetGroupNotFoundException {
            crate::error::TargetGroupNotFoundException {
                message: self.message,
            }
        }
    }
}
impl TargetGroupNotFoundException {
    /// Creates a new builder-style object to manufacture [`TargetGroupNotFoundException`](crate::error::TargetGroupNotFoundException)
    pub fn builder() -> crate::error::target_group_not_found_exception::Builder {
        crate::error::target_group_not_found_exception::Builder::default()
    }
}

/// <p>The specified listener does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListenerNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListenerNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListenerNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ListenerNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ListenerNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ListenerNotFoundException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for ListenerNotFoundException {}
/// See [`ListenerNotFoundException`](crate::error::ListenerNotFoundException)
pub mod listener_not_found_exception {
    /// A builder for [`ListenerNotFoundException`](crate::error::ListenerNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ListenerNotFoundException`](crate::error::ListenerNotFoundException)
        pub fn build(self) -> crate::error::ListenerNotFoundException {
            crate::error::ListenerNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ListenerNotFoundException {
    /// Creates a new builder-style object to manufacture [`ListenerNotFoundException`](crate::error::ListenerNotFoundException)
    pub fn builder() -> crate::error::listener_not_found_exception::Builder {
        crate::error::listener_not_found_exception::Builder::default()
    }
}

/// <p>You've reached the limit on the number of targets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTargetsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTargetsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTargetsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTargetsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTargetsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTargetsException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTargetsException {}
/// See [`TooManyTargetsException`](crate::error::TooManyTargetsException)
pub mod too_many_targets_exception {
    /// A builder for [`TooManyTargetsException`](crate::error::TooManyTargetsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTargetsException`](crate::error::TooManyTargetsException)
        pub fn build(self) -> crate::error::TooManyTargetsException {
            crate::error::TooManyTargetsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTargetsException {
    /// Creates a new builder-style object to manufacture [`TooManyTargetsException`](crate::error::TooManyTargetsException)
    pub fn builder() -> crate::error::too_many_targets_exception::Builder {
        crate::error::too_many_targets_exception::Builder::default()
    }
}

/// <p>You've reached the limit on the number of times a target can be registered with a load balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRegistrationsForTargetIdException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRegistrationsForTargetIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRegistrationsForTargetIdException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRegistrationsForTargetIdException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRegistrationsForTargetIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRegistrationsForTargetIdException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRegistrationsForTargetIdException {}
/// See [`TooManyRegistrationsForTargetIdException`](crate::error::TooManyRegistrationsForTargetIdException)
pub mod too_many_registrations_for_target_id_exception {
    /// A builder for [`TooManyRegistrationsForTargetIdException`](crate::error::TooManyRegistrationsForTargetIdException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRegistrationsForTargetIdException`](crate::error::TooManyRegistrationsForTargetIdException)
        pub fn build(self) -> crate::error::TooManyRegistrationsForTargetIdException {
            crate::error::TooManyRegistrationsForTargetIdException {
                message: self.message,
            }
        }
    }
}
impl TooManyRegistrationsForTargetIdException {
    /// Creates a new builder-style object to manufacture [`TooManyRegistrationsForTargetIdException`](crate::error::TooManyRegistrationsForTargetIdException)
    pub fn builder() -> crate::error::too_many_registrations_for_target_id_exception::Builder {
        crate::error::too_many_registrations_for_target_id_exception::Builder::default()
    }
}

/// <p>The specified target does not exist, is not in the same VPC as the target group, or has an unsupported instance type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTargetException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTargetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTargetException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTargetException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTargetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTargetException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTargetException {}
/// See [`InvalidTargetException`](crate::error::InvalidTargetException)
pub mod invalid_target_exception {
    /// A builder for [`InvalidTargetException`](crate::error::InvalidTargetException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTargetException`](crate::error::InvalidTargetException)
        pub fn build(self) -> crate::error::InvalidTargetException {
            crate::error::InvalidTargetException {
                message: self.message,
            }
        }
    }
}
impl InvalidTargetException {
    /// Creates a new builder-style object to manufacture [`InvalidTargetException`](crate::error::InvalidTargetException)
    pub fn builder() -> crate::error::invalid_target_exception::Builder {
        crate::error::invalid_target_exception::Builder::default()
    }
}

/// <p>The specified protocol is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedProtocolException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedProtocolException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedProtocolException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedProtocolException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedProtocolException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedProtocolException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedProtocolException {}
/// See [`UnsupportedProtocolException`](crate::error::UnsupportedProtocolException)
pub mod unsupported_protocol_exception {
    /// A builder for [`UnsupportedProtocolException`](crate::error::UnsupportedProtocolException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedProtocolException`](crate::error::UnsupportedProtocolException)
        pub fn build(self) -> crate::error::UnsupportedProtocolException {
            crate::error::UnsupportedProtocolException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedProtocolException {
    /// Creates a new builder-style object to manufacture [`UnsupportedProtocolException`](crate::error::UnsupportedProtocolException)
    pub fn builder() -> crate::error::unsupported_protocol_exception::Builder {
        crate::error::unsupported_protocol_exception::Builder::default()
    }
}

/// <p>You've reached the limit on the number of unique target groups per load balancer across all listeners. If a target group is used by multiple actions for a load balancer, it is counted as only one use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyUniqueTargetGroupsPerLoadBalancerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyUniqueTargetGroupsPerLoadBalancerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyUniqueTargetGroupsPerLoadBalancerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyUniqueTargetGroupsPerLoadBalancerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyUniqueTargetGroupsPerLoadBalancerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyUniqueTargetGroupsPerLoadBalancerException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyUniqueTargetGroupsPerLoadBalancerException {}
/// See [`TooManyUniqueTargetGroupsPerLoadBalancerException`](crate::error::TooManyUniqueTargetGroupsPerLoadBalancerException)
pub mod too_many_unique_target_groups_per_load_balancer_exception {
    /// A builder for [`TooManyUniqueTargetGroupsPerLoadBalancerException`](crate::error::TooManyUniqueTargetGroupsPerLoadBalancerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyUniqueTargetGroupsPerLoadBalancerException`](crate::error::TooManyUniqueTargetGroupsPerLoadBalancerException)
        pub fn build(self) -> crate::error::TooManyUniqueTargetGroupsPerLoadBalancerException {
            crate::error::TooManyUniqueTargetGroupsPerLoadBalancerException {
                message: self.message,
            }
        }
    }
}
impl TooManyUniqueTargetGroupsPerLoadBalancerException {
    /// Creates a new builder-style object to manufacture [`TooManyUniqueTargetGroupsPerLoadBalancerException`](crate::error::TooManyUniqueTargetGroupsPerLoadBalancerException)
    pub fn builder(
    ) -> crate::error::too_many_unique_target_groups_per_load_balancer_exception::Builder {
        crate::error::too_many_unique_target_groups_per_load_balancer_exception::Builder::default()
    }
}

/// <p>You've reached the limit on the number of actions per rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyActionsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyActionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyActionsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyActionsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyActionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyActionsException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyActionsException {}
/// See [`TooManyActionsException`](crate::error::TooManyActionsException)
pub mod too_many_actions_exception {
    /// A builder for [`TooManyActionsException`](crate::error::TooManyActionsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyActionsException`](crate::error::TooManyActionsException)
        pub fn build(self) -> crate::error::TooManyActionsException {
            crate::error::TooManyActionsException {
                message: self.message,
            }
        }
    }
}
impl TooManyActionsException {
    /// Creates a new builder-style object to manufacture [`TooManyActionsException`](crate::error::TooManyActionsException)
    pub fn builder() -> crate::error::too_many_actions_exception::Builder {
        crate::error::too_many_actions_exception::Builder::default()
    }
}

/// <p>You've reached the limit on the number of load balancers per target group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetGroupAssociationLimitException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TargetGroupAssociationLimitException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetGroupAssociationLimitException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TargetGroupAssociationLimitException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TargetGroupAssociationLimitException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TargetGroupAssociationLimitException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for TargetGroupAssociationLimitException {}
/// See [`TargetGroupAssociationLimitException`](crate::error::TargetGroupAssociationLimitException)
pub mod target_group_association_limit_exception {
    /// A builder for [`TargetGroupAssociationLimitException`](crate::error::TargetGroupAssociationLimitException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetGroupAssociationLimitException`](crate::error::TargetGroupAssociationLimitException)
        pub fn build(self) -> crate::error::TargetGroupAssociationLimitException {
            crate::error::TargetGroupAssociationLimitException {
                message: self.message,
            }
        }
    }
}
impl TargetGroupAssociationLimitException {
    /// Creates a new builder-style object to manufacture [`TargetGroupAssociationLimitException`](crate::error::TargetGroupAssociationLimitException)
    pub fn builder() -> crate::error::target_group_association_limit_exception::Builder {
        crate::error::target_group_association_limit_exception::Builder::default()
    }
}

/// <p>The requested action is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLoadBalancerActionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidLoadBalancerActionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLoadBalancerActionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidLoadBalancerActionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLoadBalancerActionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidLoadBalancerActionException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLoadBalancerActionException {}
/// See [`InvalidLoadBalancerActionException`](crate::error::InvalidLoadBalancerActionException)
pub mod invalid_load_balancer_action_exception {
    /// A builder for [`InvalidLoadBalancerActionException`](crate::error::InvalidLoadBalancerActionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLoadBalancerActionException`](crate::error::InvalidLoadBalancerActionException)
        pub fn build(self) -> crate::error::InvalidLoadBalancerActionException {
            crate::error::InvalidLoadBalancerActionException {
                message: self.message,
            }
        }
    }
}
impl InvalidLoadBalancerActionException {
    /// Creates a new builder-style object to manufacture [`InvalidLoadBalancerActionException`](crate::error::InvalidLoadBalancerActionException)
    pub fn builder() -> crate::error::invalid_load_balancer_action_exception::Builder {
        crate::error::invalid_load_balancer_action_exception::Builder::default()
    }
}

/// <p>The specified configuration is not valid with this protocol.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncompatibleProtocolsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IncompatibleProtocolsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncompatibleProtocolsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncompatibleProtocolsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncompatibleProtocolsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncompatibleProtocolsException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncompatibleProtocolsException {}
/// See [`IncompatibleProtocolsException`](crate::error::IncompatibleProtocolsException)
pub mod incompatible_protocols_exception {
    /// A builder for [`IncompatibleProtocolsException`](crate::error::IncompatibleProtocolsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncompatibleProtocolsException`](crate::error::IncompatibleProtocolsException)
        pub fn build(self) -> crate::error::IncompatibleProtocolsException {
            crate::error::IncompatibleProtocolsException {
                message: self.message,
            }
        }
    }
}
impl IncompatibleProtocolsException {
    /// Creates a new builder-style object to manufacture [`IncompatibleProtocolsException`](crate::error::IncompatibleProtocolsException)
    pub fn builder() -> crate::error::incompatible_protocols_exception::Builder {
        crate::error::incompatible_protocols_exception::Builder::default()
    }
}

/// <p>You've reached the limit on the number of listeners per load balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyListenersException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyListenersException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyListenersException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyListenersException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyListenersException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyListenersException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyListenersException {}
/// See [`TooManyListenersException`](crate::error::TooManyListenersException)
pub mod too_many_listeners_exception {
    /// A builder for [`TooManyListenersException`](crate::error::TooManyListenersException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyListenersException`](crate::error::TooManyListenersException)
        pub fn build(self) -> crate::error::TooManyListenersException {
            crate::error::TooManyListenersException {
                message: self.message,
            }
        }
    }
}
impl TooManyListenersException {
    /// Creates a new builder-style object to manufacture [`TooManyListenersException`](crate::error::TooManyListenersException)
    pub fn builder() -> crate::error::too_many_listeners_exception::Builder {
        crate::error::too_many_listeners_exception::Builder::default()
    }
}

/// <p>You've reached the limit on the number of certificates per load balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyCertificatesException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyCertificatesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyCertificatesException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyCertificatesException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyCertificatesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyCertificatesException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyCertificatesException {}
/// See [`TooManyCertificatesException`](crate::error::TooManyCertificatesException)
pub mod too_many_certificates_exception {
    /// A builder for [`TooManyCertificatesException`](crate::error::TooManyCertificatesException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyCertificatesException`](crate::error::TooManyCertificatesException)
        pub fn build(self) -> crate::error::TooManyCertificatesException {
            crate::error::TooManyCertificatesException {
                message: self.message,
            }
        }
    }
}
impl TooManyCertificatesException {
    /// Creates a new builder-style object to manufacture [`TooManyCertificatesException`](crate::error::TooManyCertificatesException)
    pub fn builder() -> crate::error::too_many_certificates_exception::Builder {
        crate::error::too_many_certificates_exception::Builder::default()
    }
}

/// <p>The specified SSL policy does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SslPolicyNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SslPolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SslPolicyNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SslPolicyNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SslPolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SslPolicyNotFoundException [SSLPolicyNotFoundException]")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for SslPolicyNotFoundException {}
/// See [`SslPolicyNotFoundException`](crate::error::SslPolicyNotFoundException)
pub mod ssl_policy_not_found_exception {
    /// A builder for [`SslPolicyNotFoundException`](crate::error::SslPolicyNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SslPolicyNotFoundException`](crate::error::SslPolicyNotFoundException)
        pub fn build(self) -> crate::error::SslPolicyNotFoundException {
            crate::error::SslPolicyNotFoundException {
                message: self.message,
            }
        }
    }
}
impl SslPolicyNotFoundException {
    /// Creates a new builder-style object to manufacture [`SslPolicyNotFoundException`](crate::error::SslPolicyNotFoundException)
    pub fn builder() -> crate::error::ssl_policy_not_found_exception::Builder {
        crate::error::ssl_policy_not_found_exception::Builder::default()
    }
}

/// <p>A listener with the specified port already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateListenerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateListenerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateListenerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateListenerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateListenerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateListenerException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateListenerException {}
/// See [`DuplicateListenerException`](crate::error::DuplicateListenerException)
pub mod duplicate_listener_exception {
    /// A builder for [`DuplicateListenerException`](crate::error::DuplicateListenerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateListenerException`](crate::error::DuplicateListenerException)
        pub fn build(self) -> crate::error::DuplicateListenerException {
            crate::error::DuplicateListenerException {
                message: self.message,
            }
        }
    }
}
impl DuplicateListenerException {
    /// Creates a new builder-style object to manufacture [`DuplicateListenerException`](crate::error::DuplicateListenerException)
    pub fn builder() -> crate::error::duplicate_listener_exception::Builder {
        crate::error::duplicate_listener_exception::Builder::default()
    }
}

/// <p>The specified certificate does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CertificateNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CertificateNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CertificateNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CertificateNotFoundException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for CertificateNotFoundException {}
/// See [`CertificateNotFoundException`](crate::error::CertificateNotFoundException)
pub mod certificate_not_found_exception {
    /// A builder for [`CertificateNotFoundException`](crate::error::CertificateNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateNotFoundException`](crate::error::CertificateNotFoundException)
        pub fn build(self) -> crate::error::CertificateNotFoundException {
            crate::error::CertificateNotFoundException {
                message: self.message,
            }
        }
    }
}
impl CertificateNotFoundException {
    /// Creates a new builder-style object to manufacture [`CertificateNotFoundException`](crate::error::CertificateNotFoundException)
    pub fn builder() -> crate::error::certificate_not_found_exception::Builder {
        crate::error::certificate_not_found_exception::Builder::default()
    }
}

/// <p>The specified ALPN policy is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlpnPolicyNotSupportedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AlpnPolicyNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlpnPolicyNotSupportedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AlpnPolicyNotSupportedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlpnPolicyNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "AlpnPolicyNotSupportedException [ALPNPolicyNotSupportedException]"
        )?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlpnPolicyNotSupportedException {}
/// See [`AlpnPolicyNotSupportedException`](crate::error::AlpnPolicyNotSupportedException)
pub mod alpn_policy_not_supported_exception {
    /// A builder for [`AlpnPolicyNotSupportedException`](crate::error::AlpnPolicyNotSupportedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlpnPolicyNotSupportedException`](crate::error::AlpnPolicyNotSupportedException)
        pub fn build(self) -> crate::error::AlpnPolicyNotSupportedException {
            crate::error::AlpnPolicyNotSupportedException {
                message: self.message,
            }
        }
    }
}
impl AlpnPolicyNotSupportedException {
    /// Creates a new builder-style object to manufacture [`AlpnPolicyNotSupportedException`](crate::error::AlpnPolicyNotSupportedException)
    pub fn builder() -> crate::error::alpn_policy_not_supported_exception::Builder {
        crate::error::alpn_policy_not_supported_exception::Builder::default()
    }
}

/// <p>The health of the specified targets could not be retrieved due to an internal error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealthUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HealthUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealthUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HealthUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HealthUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HealthUnavailableException")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for HealthUnavailableException {}
/// See [`HealthUnavailableException`](crate::error::HealthUnavailableException)
pub mod health_unavailable_exception {
    /// A builder for [`HealthUnavailableException`](crate::error::HealthUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HealthUnavailableException`](crate::error::HealthUnavailableException)
        pub fn build(self) -> crate::error::HealthUnavailableException {
            crate::error::HealthUnavailableException {
                message: self.message,
            }
        }
    }
}
impl HealthUnavailableException {
    /// Creates a new builder-style object to manufacture [`HealthUnavailableException`](crate::error::HealthUnavailableException)
    pub fn builder() -> crate::error::health_unavailable_exception::Builder {
        crate::error::health_unavailable_exception::Builder::default()
    }
}

/// <p>A specified resource is in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>You've reached the limit on the number of target groups for your Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTargetGroupsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTargetGroupsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTargetGroupsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTargetGroupsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTargetGroupsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTargetGroupsException")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTargetGroupsException {}
/// See [`TooManyTargetGroupsException`](crate::error::TooManyTargetGroupsException)
pub mod too_many_target_groups_exception {
    /// A builder for [`TooManyTargetGroupsException`](crate::error::TooManyTargetGroupsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTargetGroupsException`](crate::error::TooManyTargetGroupsException)
        pub fn build(self) -> crate::error::TooManyTargetGroupsException {
            crate::error::TooManyTargetGroupsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTargetGroupsException {
    /// Creates a new builder-style object to manufacture [`TooManyTargetGroupsException`](crate::error::TooManyTargetGroupsException)
    pub fn builder() -> crate::error::too_many_target_groups_exception::Builder {
        crate::error::too_many_target_groups_exception::Builder::default()
    }
}

/// <p>A target group with the specified name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateTargetGroupNameException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateTargetGroupNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateTargetGroupNameException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateTargetGroupNameException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateTargetGroupNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateTargetGroupNameException")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateTargetGroupNameException {}
/// See [`DuplicateTargetGroupNameException`](crate::error::DuplicateTargetGroupNameException)
pub mod duplicate_target_group_name_exception {
    /// A builder for [`DuplicateTargetGroupNameException`](crate::error::DuplicateTargetGroupNameException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateTargetGroupNameException`](crate::error::DuplicateTargetGroupNameException)
        pub fn build(self) -> crate::error::DuplicateTargetGroupNameException {
            crate::error::DuplicateTargetGroupNameException {
                message: self.message,
            }
        }
    }
}
impl DuplicateTargetGroupNameException {
    /// Creates a new builder-style object to manufacture [`DuplicateTargetGroupNameException`](crate::error::DuplicateTargetGroupNameException)
    pub fn builder() -> crate::error::duplicate_target_group_name_exception::Builder {
        crate::error::duplicate_target_group_name_exception::Builder::default()
    }
}

/// <p>You've reached the limit on the number of rules per load balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRulesException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRulesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRulesException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRulesException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRulesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRulesException")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRulesException {}
/// See [`TooManyRulesException`](crate::error::TooManyRulesException)
pub mod too_many_rules_exception {
    /// A builder for [`TooManyRulesException`](crate::error::TooManyRulesException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRulesException`](crate::error::TooManyRulesException)
        pub fn build(self) -> crate::error::TooManyRulesException {
            crate::error::TooManyRulesException {
                message: self.message,
            }
        }
    }
}
impl TooManyRulesException {
    /// Creates a new builder-style object to manufacture [`TooManyRulesException`](crate::error::TooManyRulesException)
    pub fn builder() -> crate::error::too_many_rules_exception::Builder {
        crate::error::too_many_rules_exception::Builder::default()
    }
}

/// <p>You've reached the limit on the number of load balancers for your Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyLoadBalancersException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyLoadBalancersException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyLoadBalancersException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyLoadBalancersException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyLoadBalancersException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyLoadBalancersException")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyLoadBalancersException {}
/// See [`TooManyLoadBalancersException`](crate::error::TooManyLoadBalancersException)
pub mod too_many_load_balancers_exception {
    /// A builder for [`TooManyLoadBalancersException`](crate::error::TooManyLoadBalancersException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyLoadBalancersException`](crate::error::TooManyLoadBalancersException)
        pub fn build(self) -> crate::error::TooManyLoadBalancersException {
            crate::error::TooManyLoadBalancersException {
                message: self.message,
            }
        }
    }
}
impl TooManyLoadBalancersException {
    /// Creates a new builder-style object to manufacture [`TooManyLoadBalancersException`](crate::error::TooManyLoadBalancersException)
    pub fn builder() -> crate::error::too_many_load_balancers_exception::Builder {
        crate::error::too_many_load_balancers_exception::Builder::default()
    }
}

/// <p>The requested scheme is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSchemeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSchemeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSchemeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSchemeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSchemeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSchemeException")?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSchemeException {}
/// See [`InvalidSchemeException`](crate::error::InvalidSchemeException)
pub mod invalid_scheme_exception {
    /// A builder for [`InvalidSchemeException`](crate::error::InvalidSchemeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSchemeException`](crate::error::InvalidSchemeException)
        pub fn build(self) -> crate::error::InvalidSchemeException {
            crate::error::InvalidSchemeException {
                message: self.message,
            }
        }
    }
}
impl InvalidSchemeException {
    /// Creates a new builder-style object to manufacture [`InvalidSchemeException`](crate::error::InvalidSchemeException)
    pub fn builder() -> crate::error::invalid_scheme_exception::Builder {
        crate::error::invalid_scheme_exception::Builder::default()
    }
}

/// <p>A tag key was specified more than once.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateTagKeysException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateTagKeysException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateTagKeysException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateTagKeysException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateTagKeysException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateTagKeysException")?;
        if let Some(inner_36) = &self.message {
            write!(f, ": {}", inner_36)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateTagKeysException {}
/// See [`DuplicateTagKeysException`](crate::error::DuplicateTagKeysException)
pub mod duplicate_tag_keys_exception {
    /// A builder for [`DuplicateTagKeysException`](crate::error::DuplicateTagKeysException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateTagKeysException`](crate::error::DuplicateTagKeysException)
        pub fn build(self) -> crate::error::DuplicateTagKeysException {
            crate::error::DuplicateTagKeysException {
                message: self.message,
            }
        }
    }
}
impl DuplicateTagKeysException {
    /// Creates a new builder-style object to manufacture [`DuplicateTagKeysException`](crate::error::DuplicateTagKeysException)
    pub fn builder() -> crate::error::duplicate_tag_keys_exception::Builder {
        crate::error::duplicate_tag_keys_exception::Builder::default()
    }
}

/// <p>A load balancer with the specified name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateLoadBalancerNameException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateLoadBalancerNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateLoadBalancerNameException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateLoadBalancerNameException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateLoadBalancerNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateLoadBalancerNameException")?;
        if let Some(inner_37) = &self.message {
            write!(f, ": {}", inner_37)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateLoadBalancerNameException {}
/// See [`DuplicateLoadBalancerNameException`](crate::error::DuplicateLoadBalancerNameException)
pub mod duplicate_load_balancer_name_exception {
    /// A builder for [`DuplicateLoadBalancerNameException`](crate::error::DuplicateLoadBalancerNameException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateLoadBalancerNameException`](crate::error::DuplicateLoadBalancerNameException)
        pub fn build(self) -> crate::error::DuplicateLoadBalancerNameException {
            crate::error::DuplicateLoadBalancerNameException {
                message: self.message,
            }
        }
    }
}
impl DuplicateLoadBalancerNameException {
    /// Creates a new builder-style object to manufacture [`DuplicateLoadBalancerNameException`](crate::error::DuplicateLoadBalancerNameException)
    pub fn builder() -> crate::error::duplicate_load_balancer_name_exception::Builder {
        crate::error::duplicate_load_balancer_name_exception::Builder::default()
    }
}
