// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_listener_certificates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddListenerCertificatesOutput,
    crate::error::AddListenerCertificatesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddListenerCertificatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AddListenerCertificatesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CertificateNotFound" => crate::error::AddListenerCertificatesError {
            meta: generic,
            kind: crate::error::AddListenerCertificatesErrorKind::CertificateNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::certificate_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_certificate_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddListenerCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ListenerNotFound" => crate::error::AddListenerCertificatesError {
            meta: generic,
            kind: crate::error::AddListenerCertificatesErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_listener_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddListenerCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyCertificates" => crate::error::AddListenerCertificatesError {
            meta: generic,
            kind: crate::error::AddListenerCertificatesErrorKind::TooManyCertificatesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_certificates_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_certificates_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddListenerCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddListenerCertificatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_listener_certificates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddListenerCertificatesOutput,
    crate::error::AddListenerCertificatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_listener_certificates_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_add_listener_certificates(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AddListenerCertificatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateTagKeys" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::DuplicateTagKeysException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_tag_keys_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_tag_keys_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ListenerNotFound" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_listener_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LoadBalancerNotFound" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::LoadBalancerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::load_balancer_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleNotFound" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::RuleNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::rule_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TargetGroupNotFound" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::TargetGroupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::target_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTags" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_tags_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_listener_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateListenerOutput, crate::error::CreateListenerError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateListenerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateListenerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ALPNPolicyNotFound" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::AlpnPolicyNotSupportedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::alpn_policy_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_alpn_policy_not_supported_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CertificateNotFound" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::CertificateNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::certificate_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_certificate_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DuplicateListener" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::DuplicateListenerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::duplicate_listener_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_listener_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "IncompatibleProtocols" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::IncompatibleProtocolsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::incompatible_protocols_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_incompatible_protocols_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLoadBalancerAction" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::InvalidLoadBalancerActionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_load_balancer_action_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_load_balancer_action_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LoadBalancerNotFound" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::LoadBalancerNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::load_balancer_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SSLPolicyNotFound" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::SslPolicyNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::ssl_policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_ssl_policy_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TargetGroupAssociationLimit" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::TargetGroupAssociationLimitException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::target_group_association_limit_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_association_limit_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TargetGroupNotFound" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::TargetGroupNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::target_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyActions" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::TooManyActionsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_actions_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_actions_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCertificates" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::TooManyCertificatesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_certificates_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_certificates_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyListeners" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::TooManyListenersException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_listeners_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_listeners_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRegistrationsForTargetId" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::TooManyRegistrationsForTargetIdException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_registrations_for_target_id_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_registrations_for_target_id_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyTags" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::TooManyTagsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_tags_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyTargets" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::TooManyTargetsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_targets_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_targets_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyUniqueTargetGroupsPerLoadBalancer" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_unique_target_groups_per_load_balancer_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_unique_target_groups_per_load_balancer_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedProtocol" => crate::error::CreateListenerError { meta: generic, kind: crate::error::CreateListenerErrorKind::UnsupportedProtocolException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_protocol_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_protocol_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateListenerError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_listener_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateListenerOutput, crate::error::CreateListenerError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_listener_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_listener(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateListenerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoadBalancerOutput,
    crate::error::CreateLoadBalancerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLoadBalancerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateLoadBalancerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AllocationIdNotFound" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::AllocationIdNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::allocation_id_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_allocation_id_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AvailabilityZoneNotSupported" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::AvailabilityZoneNotSupportedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::availability_zone_not_supported_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_availability_zone_not_supported_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "DuplicateLoadBalancerName" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::DuplicateLoadBalancerNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::duplicate_load_balancer_name_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_load_balancer_name_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateTagKeys" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::DuplicateTagKeysException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_tag_keys_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_tag_keys_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidConfigurationRequest" => {
            crate::error::CreateLoadBalancerError {
                meta: generic,
                kind:
                    crate::error::CreateLoadBalancerErrorKind::InvalidConfigurationRequestException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InvalidScheme" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::InvalidSchemeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_scheme_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_scheme_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSecurityGroup" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::InvalidSecurityGroupException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_security_group_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_security_group_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::InvalidSubnetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermitted" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_not_permitted_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_in_use_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubnetNotFound" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::SubnetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::subnet_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subnet_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyLoadBalancers" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::TooManyLoadBalancersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_load_balancers_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_load_balancers_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTags" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_tags_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLoadBalancerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoadBalancerOutput,
    crate::error::CreateLoadBalancerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_load_balancer_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_load_balancer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateLoadBalancerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRuleOutput, crate::error::CreateRuleError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "IncompatibleProtocols" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::IncompatibleProtocolsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incompatible_protocols_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_incompatible_protocols_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidConfigurationRequest" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::InvalidConfigurationRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLoadBalancerAction" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::InvalidLoadBalancerActionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_load_balancer_action_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_load_balancer_action_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ListenerNotFound" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_listener_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PriorityInUse" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::PriorityInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::priority_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_priority_in_use_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TargetGroupAssociationLimit" => {
            crate::error::CreateRuleError {
                meta: generic,
                kind: crate::error::CreateRuleErrorKind::TargetGroupAssociationLimitException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::target_group_association_limit_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_target_group_association_limit_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TargetGroupNotFound" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::TargetGroupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::target_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyActions" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::TooManyActionsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_actions_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_actions_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRegistrationsForTargetId" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::TooManyRegistrationsForTargetIdException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_registrations_for_target_id_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_registrations_for_target_id_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRules" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::TooManyRulesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_rules_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_rules_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTags" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_tags_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTargetGroups" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::TooManyTargetGroupsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_target_groups_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_target_groups_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTargets" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::TooManyTargetsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_targets_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_targets_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyUniqueTargetGroupsPerLoadBalancer" => crate::error::CreateRuleError {
            meta: generic,
            kind:
                crate::error::CreateRuleErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::too_many_unique_target_groups_per_load_balancer_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_too_many_unique_target_groups_per_load_balancer_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "UnsupportedProtocol" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::UnsupportedProtocolException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_protocol_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_protocol_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRuleOutput, crate::error::CreateRuleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_rule_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_target_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTargetGroupOutput, crate::error::CreateTargetGroupError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTargetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTargetGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateTargetGroupName" => crate::error::CreateTargetGroupError {
            meta: generic,
            kind: crate::error::CreateTargetGroupErrorKind::DuplicateTargetGroupNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::duplicate_target_group_name_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_target_group_name_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTargetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidConfigurationRequest" => crate::error::CreateTargetGroupError {
            meta: generic,
            kind: crate::error::CreateTargetGroupErrorKind::InvalidConfigurationRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTargetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTags" => crate::error::CreateTargetGroupError {
            meta: generic,
            kind: crate::error::CreateTargetGroupErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_tags_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTargetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTargetGroups" => crate::error::CreateTargetGroupError {
            meta: generic,
            kind: crate::error::CreateTargetGroupErrorKind::TooManyTargetGroupsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_target_groups_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_target_groups_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTargetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTargetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_target_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTargetGroupOutput, crate::error::CreateTargetGroupError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_target_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_target_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTargetGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_listener_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteListenerOutput, crate::error::DeleteListenerError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteListenerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteListenerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ListenerNotFound" => crate::error::DeleteListenerError {
            meta: generic,
            kind: crate::error::DeleteListenerErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_listener_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => crate::error::DeleteListenerError {
            meta: generic,
            kind: crate::error::DeleteListenerErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_in_use_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteListenerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_listener_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteListenerOutput, crate::error::DeleteListenerError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_listener_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoadBalancerOutput,
    crate::error::DeleteLoadBalancerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteLoadBalancerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DeleteLoadBalancerError {
            meta: generic,
            kind: crate::error::DeleteLoadBalancerErrorKind::LoadBalancerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::load_balancer_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermitted" => crate::error::DeleteLoadBalancerError {
            meta: generic,
            kind: crate::error::DeleteLoadBalancerErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_not_permitted_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => crate::error::DeleteLoadBalancerError {
            meta: generic,
            kind: crate::error::DeleteLoadBalancerErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_in_use_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteLoadBalancerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoadBalancerOutput,
    crate::error::DeleteLoadBalancerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_load_balancer_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRuleOutput, crate::error::DeleteRuleError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OperationNotPermitted" => crate::error::DeleteRuleError {
            meta: generic,
            kind: crate::error::DeleteRuleErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_not_permitted_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleNotFound" => crate::error::DeleteRuleError {
            meta: generic,
            kind: crate::error::DeleteRuleErrorKind::RuleNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::rule_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRuleOutput, crate::error::DeleteRuleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_rule_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_target_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTargetGroupOutput, crate::error::DeleteTargetGroupError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTargetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTargetGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => crate::error::DeleteTargetGroupError {
            meta: generic,
            kind: crate::error::DeleteTargetGroupErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_in_use_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteTargetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTargetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_target_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTargetGroupOutput, crate::error::DeleteTargetGroupError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_target_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_targets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeregisterTargetsOutput, crate::error::DeregisterTargetsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterTargetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeregisterTargetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidTarget" => crate::error::DeregisterTargetsError {
            meta: generic,
            kind: crate::error::DeregisterTargetsErrorKind::InvalidTargetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_target_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_target_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeregisterTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TargetGroupNotFound" => crate::error::DeregisterTargetsError {
            meta: generic,
            kind: crate::error::DeregisterTargetsErrorKind::TargetGroupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::target_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeregisterTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeregisterTargetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_targets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeregisterTargetsOutput, crate::error::DeregisterTargetsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deregister_targets_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_limits_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountLimitsOutput,
    crate::error::DescribeAccountLimitsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAccountLimitsError::unhandled)?;
    Err(crate::error::DescribeAccountLimitsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_limits_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountLimitsOutput,
    crate::error::DescribeAccountLimitsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_account_limits_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_account_limits(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAccountLimitsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_listener_certificates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeListenerCertificatesOutput,
    crate::error::DescribeListenerCertificatesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeListenerCertificatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeListenerCertificatesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ListenerNotFound" => crate::error::DescribeListenerCertificatesError {
            meta: generic,
            kind: crate::error::DescribeListenerCertificatesErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_listener_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeListenerCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeListenerCertificatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_listener_certificates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeListenerCertificatesOutput,
    crate::error::DescribeListenerCertificatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_listener_certificates_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_listener_certificates(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeListenerCertificatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_listeners_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeListenersOutput, crate::error::DescribeListenersError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeListenersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeListenersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ListenerNotFound" => crate::error::DescribeListenersError {
            meta: generic,
            kind: crate::error::DescribeListenersErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_listener_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeListenersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LoadBalancerNotFound" => crate::error::DescribeListenersError {
            meta: generic,
            kind: crate::error::DescribeListenersErrorKind::LoadBalancerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::load_balancer_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeListenersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedProtocol" => crate::error::DescribeListenersError {
            meta: generic,
            kind: crate::error::DescribeListenersErrorKind::UnsupportedProtocolException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_protocol_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_protocol_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeListenersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeListenersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_listeners_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeListenersOutput, crate::error::DescribeListenersError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_listeners_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_listeners(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeListenersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancer_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancerAttributesOutput,
    crate::error::DescribeLoadBalancerAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLoadBalancerAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLoadBalancerAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DescribeLoadBalancerAttributesError {
            meta: generic,
            kind:
                crate::error::DescribeLoadBalancerAttributesErrorKind::LoadBalancerNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::load_balancer_not_found_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_load_balancer_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoadBalancerAttributesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeLoadBalancerAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancer_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancerAttributesOutput,
    crate::error::DescribeLoadBalancerAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_load_balancer_attributes_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_load_balancer_attributes(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeLoadBalancerAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancersOutput,
    crate::error::DescribeLoadBalancersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLoadBalancersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLoadBalancersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DescribeLoadBalancersError {
            meta: generic,
            kind: crate::error::DescribeLoadBalancersErrorKind::LoadBalancerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::load_balancer_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoadBalancersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLoadBalancersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancersOutput,
    crate::error::DescribeLoadBalancersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_load_balancers_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_load_balancers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLoadBalancersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_rules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeRulesOutput, crate::error::DescribeRulesError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeRulesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeRulesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ListenerNotFound" => crate::error::DescribeRulesError {
            meta: generic,
            kind: crate::error::DescribeRulesErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_listener_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleNotFound" => crate::error::DescribeRulesError {
            meta: generic,
            kind: crate::error::DescribeRulesErrorKind::RuleNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::rule_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedProtocol" => crate::error::DescribeRulesError {
            meta: generic,
            kind: crate::error::DescribeRulesErrorKind::UnsupportedProtocolException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_protocol_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_protocol_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeRulesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_rules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeRulesOutput, crate::error::DescribeRulesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_rules_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_rules(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeRulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_ssl_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSslPoliciesOutput,
    crate::error::DescribeSSLPoliciesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSSLPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeSSLPoliciesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "SSLPolicyNotFound" => crate::error::DescribeSSLPoliciesError {
            meta: generic,
            kind: crate::error::DescribeSSLPoliciesErrorKind::SslPolicyNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::ssl_policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_ssl_policy_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeSSLPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeSSLPoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_ssl_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSslPoliciesOutput,
    crate::error::DescribeSSLPoliciesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_ssl_policies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_ssl_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSSLPoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ListenerNotFound" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_listener_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LoadBalancerNotFound" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::LoadBalancerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::load_balancer_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleNotFound" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::RuleNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::rule_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TargetGroupNotFound" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::TargetGroupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::target_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_tags_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_target_group_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTargetGroupAttributesOutput,
    crate::error::DescribeTargetGroupAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTargetGroupAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeTargetGroupAttributesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "TargetGroupNotFound" => crate::error::DescribeTargetGroupAttributesError {
            meta: generic,
            kind:
                crate::error::DescribeTargetGroupAttributesErrorKind::TargetGroupNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::target_group_not_found_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTargetGroupAttributesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeTargetGroupAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_target_group_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTargetGroupAttributesOutput,
    crate::error::DescribeTargetGroupAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_target_group_attributes_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_target_group_attributes(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeTargetGroupAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_target_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTargetGroupsOutput,
    crate::error::DescribeTargetGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTargetGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTargetGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DescribeTargetGroupsError {
            meta: generic,
            kind: crate::error::DescribeTargetGroupsErrorKind::LoadBalancerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::load_balancer_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTargetGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TargetGroupNotFound" => crate::error::DescribeTargetGroupsError {
            meta: generic,
            kind: crate::error::DescribeTargetGroupsErrorKind::TargetGroupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::target_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTargetGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTargetGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_target_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTargetGroupsOutput,
    crate::error::DescribeTargetGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_target_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_target_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTargetGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_target_health_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTargetHealthOutput,
    crate::error::DescribeTargetHealthError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTargetHealthError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTargetHealthError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "HealthUnavailable" => crate::error::DescribeTargetHealthError {
            meta: generic,
            kind: crate::error::DescribeTargetHealthErrorKind::HealthUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::health_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_health_unavailable_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTargetHealthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTarget" => crate::error::DescribeTargetHealthError {
            meta: generic,
            kind: crate::error::DescribeTargetHealthErrorKind::InvalidTargetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_target_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_target_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTargetHealthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TargetGroupNotFound" => crate::error::DescribeTargetHealthError {
            meta: generic,
            kind: crate::error::DescribeTargetHealthErrorKind::TargetGroupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::target_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTargetHealthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTargetHealthError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_target_health_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTargetHealthOutput,
    crate::error::DescribeTargetHealthError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_target_health_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_target_health(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTargetHealthError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_listener_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyListenerOutput, crate::error::ModifyListenerError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyListenerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyListenerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ALPNPolicyNotFound" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::AlpnPolicyNotSupportedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::alpn_policy_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_alpn_policy_not_supported_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CertificateNotFound" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::CertificateNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::certificate_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_certificate_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DuplicateListener" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::DuplicateListenerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::duplicate_listener_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_listener_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "IncompatibleProtocols" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::IncompatibleProtocolsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::incompatible_protocols_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_incompatible_protocols_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLoadBalancerAction" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::InvalidLoadBalancerActionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_load_balancer_action_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_load_balancer_action_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ListenerNotFound" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::ListenerNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_listener_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SSLPolicyNotFound" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::SslPolicyNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::ssl_policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_ssl_policy_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TargetGroupAssociationLimit" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::TargetGroupAssociationLimitException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::target_group_association_limit_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_association_limit_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TargetGroupNotFound" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::TargetGroupNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::target_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyActions" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::TooManyActionsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_actions_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_actions_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCertificates" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::TooManyCertificatesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_certificates_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_certificates_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyListeners" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::TooManyListenersException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_listeners_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_listeners_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRegistrationsForTargetId" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::TooManyRegistrationsForTargetIdException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_registrations_for_target_id_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_registrations_for_target_id_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyTargets" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::TooManyTargetsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_targets_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_targets_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyUniqueTargetGroupsPerLoadBalancer" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_unique_target_groups_per_load_balancer_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_unique_target_groups_per_load_balancer_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedProtocol" => crate::error::ModifyListenerError { meta: generic, kind: crate::error::ModifyListenerErrorKind::UnsupportedProtocolException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_protocol_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_protocol_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyListenerError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_listener_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyListenerOutput, crate::error::ModifyListenerError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_listener_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_listener(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyListenerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_load_balancer_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyLoadBalancerAttributesOutput,
    crate::error::ModifyLoadBalancerAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyLoadBalancerAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyLoadBalancerAttributesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidConfigurationRequest" => crate::error::ModifyLoadBalancerAttributesError { meta: generic, kind: crate::error::ModifyLoadBalancerAttributesErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyLoadBalancerAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LoadBalancerNotFound" => crate::error::ModifyLoadBalancerAttributesError { meta: generic, kind: crate::error::ModifyLoadBalancerAttributesErrorKind::LoadBalancerNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::load_balancer_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyLoadBalancerAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyLoadBalancerAttributesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_load_balancer_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyLoadBalancerAttributesOutput,
    crate::error::ModifyLoadBalancerAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_load_balancer_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_load_balancer_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyLoadBalancerAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyRuleOutput, crate::error::ModifyRuleError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "IncompatibleProtocols" => crate::error::ModifyRuleError {
            meta: generic,
            kind: crate::error::ModifyRuleErrorKind::IncompatibleProtocolsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incompatible_protocols_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_incompatible_protocols_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLoadBalancerAction" => crate::error::ModifyRuleError {
            meta: generic,
            kind: crate::error::ModifyRuleErrorKind::InvalidLoadBalancerActionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_load_balancer_action_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_load_balancer_action_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermitted" => crate::error::ModifyRuleError {
            meta: generic,
            kind: crate::error::ModifyRuleErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_not_permitted_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleNotFound" => crate::error::ModifyRuleError {
            meta: generic,
            kind: crate::error::ModifyRuleErrorKind::RuleNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::rule_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TargetGroupAssociationLimit" => {
            crate::error::ModifyRuleError {
                meta: generic,
                kind: crate::error::ModifyRuleErrorKind::TargetGroupAssociationLimitException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::target_group_association_limit_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_target_group_association_limit_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyRuleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TargetGroupNotFound" => crate::error::ModifyRuleError {
            meta: generic,
            kind: crate::error::ModifyRuleErrorKind::TargetGroupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::target_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyActions" => crate::error::ModifyRuleError {
            meta: generic,
            kind: crate::error::ModifyRuleErrorKind::TooManyActionsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_actions_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_actions_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRegistrationsForTargetId" => crate::error::ModifyRuleError {
            meta: generic,
            kind: crate::error::ModifyRuleErrorKind::TooManyRegistrationsForTargetIdException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_registrations_for_target_id_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_registrations_for_target_id_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTargets" => crate::error::ModifyRuleError {
            meta: generic,
            kind: crate::error::ModifyRuleErrorKind::TooManyTargetsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_targets_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_targets_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyUniqueTargetGroupsPerLoadBalancer" => crate::error::ModifyRuleError {
            meta: generic,
            kind:
                crate::error::ModifyRuleErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::too_many_unique_target_groups_per_load_balancer_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_too_many_unique_target_groups_per_load_balancer_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyRuleError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "UnsupportedProtocol" => crate::error::ModifyRuleError {
            meta: generic,
            kind: crate::error::ModifyRuleErrorKind::UnsupportedProtocolException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_protocol_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_protocol_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyRuleOutput, crate::error::ModifyRuleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_rule_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_target_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyTargetGroupOutput, crate::error::ModifyTargetGroupError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyTargetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyTargetGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidConfigurationRequest" => crate::error::ModifyTargetGroupError {
            meta: generic,
            kind: crate::error::ModifyTargetGroupErrorKind::InvalidConfigurationRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyTargetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TargetGroupNotFound" => crate::error::ModifyTargetGroupError {
            meta: generic,
            kind: crate::error::ModifyTargetGroupErrorKind::TargetGroupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::target_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyTargetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyTargetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_target_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyTargetGroupOutput, crate::error::ModifyTargetGroupError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_target_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_target_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyTargetGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_target_group_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyTargetGroupAttributesOutput,
    crate::error::ModifyTargetGroupAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyTargetGroupAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyTargetGroupAttributesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidConfigurationRequest" => crate::error::ModifyTargetGroupAttributesError { meta: generic, kind: crate::error::ModifyTargetGroupAttributesErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyTargetGroupAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TargetGroupNotFound" => crate::error::ModifyTargetGroupAttributesError { meta: generic, kind: crate::error::ModifyTargetGroupAttributesErrorKind::TargetGroupNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::target_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyTargetGroupAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyTargetGroupAttributesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_target_group_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyTargetGroupAttributesOutput,
    crate::error::ModifyTargetGroupAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_target_group_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_target_group_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyTargetGroupAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_targets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterTargetsOutput, crate::error::RegisterTargetsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterTargetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RegisterTargetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidTarget" => crate::error::RegisterTargetsError {
            meta: generic,
            kind: crate::error::RegisterTargetsErrorKind::InvalidTargetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_target_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_target_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TargetGroupNotFound" => crate::error::RegisterTargetsError {
            meta: generic,
            kind: crate::error::RegisterTargetsErrorKind::TargetGroupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::target_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRegistrationsForTargetId" => crate::error::RegisterTargetsError {
            meta: generic,
            kind: crate::error::RegisterTargetsErrorKind::TooManyRegistrationsForTargetIdException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::too_many_registrations_for_target_id_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_too_many_registrations_for_target_id_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterTargetsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "TooManyTargets" => crate::error::RegisterTargetsError {
            meta: generic,
            kind: crate::error::RegisterTargetsErrorKind::TooManyTargetsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_targets_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_targets_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RegisterTargetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_targets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterTargetsOutput, crate::error::RegisterTargetsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_targets_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_listener_certificates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveListenerCertificatesOutput,
    crate::error::RemoveListenerCertificatesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveListenerCertificatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveListenerCertificatesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ListenerNotFound" => crate::error::RemoveListenerCertificatesError {
            meta: generic,
            kind: crate::error::RemoveListenerCertificatesErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_listener_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveListenerCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermitted" => crate::error::RemoveListenerCertificatesError {
            meta: generic,
            kind: crate::error::RemoveListenerCertificatesErrorKind::OperationNotPermittedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_not_permitted_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_operation_not_permitted_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveListenerCertificatesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::RemoveListenerCertificatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_listener_certificates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveListenerCertificatesOutput,
    crate::error::RemoveListenerCertificatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_listener_certificates_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RemoveTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ListenerNotFound" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_listener_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LoadBalancerNotFound" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::LoadBalancerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::load_balancer_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleNotFound" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::RuleNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::rule_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TargetGroupNotFound" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::TargetGroupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::target_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_target_group_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTags" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_tags_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_ip_address_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetIpAddressTypeOutput, crate::error::SetIpAddressTypeError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetIpAddressTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetIpAddressTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidConfigurationRequest" => crate::error::SetIpAddressTypeError {
            meta: generic,
            kind: crate::error::SetIpAddressTypeErrorKind::InvalidConfigurationRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetIpAddressTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::SetIpAddressTypeError {
            meta: generic,
            kind: crate::error::SetIpAddressTypeErrorKind::InvalidSubnetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetIpAddressTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LoadBalancerNotFound" => crate::error::SetIpAddressTypeError {
            meta: generic,
            kind: crate::error::SetIpAddressTypeErrorKind::LoadBalancerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::load_balancer_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetIpAddressTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetIpAddressTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_ip_address_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetIpAddressTypeOutput, crate::error::SetIpAddressTypeError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_ip_address_type_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_set_ip_address_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SetIpAddressTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_rule_priorities_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetRulePrioritiesOutput, crate::error::SetRulePrioritiesError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetRulePrioritiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetRulePrioritiesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OperationNotPermitted" => crate::error::SetRulePrioritiesError {
            meta: generic,
            kind: crate::error::SetRulePrioritiesErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_not_permitted_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetRulePrioritiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PriorityInUse" => crate::error::SetRulePrioritiesError {
            meta: generic,
            kind: crate::error::SetRulePrioritiesErrorKind::PriorityInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::priority_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_priority_in_use_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetRulePrioritiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleNotFound" => crate::error::SetRulePrioritiesError {
            meta: generic,
            kind: crate::error::SetRulePrioritiesErrorKind::RuleNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::rule_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetRulePrioritiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetRulePrioritiesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_rule_priorities_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetRulePrioritiesOutput, crate::error::SetRulePrioritiesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_rule_priorities_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_set_rule_priorities(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SetRulePrioritiesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_security_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetSecurityGroupsOutput, crate::error::SetSecurityGroupsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetSecurityGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetSecurityGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidConfigurationRequest" => crate::error::SetSecurityGroupsError {
            meta: generic,
            kind: crate::error::SetSecurityGroupsErrorKind::InvalidConfigurationRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSecurityGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSecurityGroup" => crate::error::SetSecurityGroupsError {
            meta: generic,
            kind: crate::error::SetSecurityGroupsErrorKind::InvalidSecurityGroupException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_security_group_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_security_group_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSecurityGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LoadBalancerNotFound" => crate::error::SetSecurityGroupsError {
            meta: generic,
            kind: crate::error::SetSecurityGroupsErrorKind::LoadBalancerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::load_balancer_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSecurityGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetSecurityGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_security_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetSecurityGroupsOutput, crate::error::SetSecurityGroupsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_security_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_set_security_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SetSecurityGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_subnets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetSubnetsOutput, crate::error::SetSubnetsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetSubnetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetSubnetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AllocationIdNotFound" => crate::error::SetSubnetsError {
            meta: generic,
            kind: crate::error::SetSubnetsErrorKind::AllocationIdNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::allocation_id_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_allocation_id_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSubnetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AvailabilityZoneNotSupported" => {
            crate::error::SetSubnetsError {
                meta: generic,
                kind: crate::error::SetSubnetsErrorKind::AvailabilityZoneNotSupportedException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::availability_zone_not_supported_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_availability_zone_not_supported_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSubnetsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidConfigurationRequest" => crate::error::SetSubnetsError {
            meta: generic,
            kind: crate::error::SetSubnetsErrorKind::InvalidConfigurationRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSubnetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::SetSubnetsError {
            meta: generic,
            kind: crate::error::SetSubnetsErrorKind::InvalidSubnetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSubnetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LoadBalancerNotFound" => crate::error::SetSubnetsError {
            meta: generic,
            kind: crate::error::SetSubnetsErrorKind::LoadBalancerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::load_balancer_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSubnetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubnetNotFound" => crate::error::SetSubnetsError {
            meta: generic,
            kind: crate::error::SetSubnetsErrorKind::SubnetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::subnet_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subnet_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSubnetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetSubnetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_subnets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetSubnetsOutput, crate::error::SetSubnetsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_subnets_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_set_subnets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SetSubnetsError::unhandled)?;
        output.build()
    })
}
