// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddListenerCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_listener_certificates`](crate::client::Client::add_listener_certificates).
///
/// See [`crate::client::fluent_builders::AddListenerCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddListenerCertificates {
    _private: (),
}
impl AddListenerCertificates {
    /// Creates a new builder-style object to manufacture [`AddListenerCertificatesInput`](crate::input::AddListenerCertificatesInput)
    pub fn builder() -> crate::input::add_listener_certificates_input::Builder {
        crate::input::add_listener_certificates_input::Builder::default()
    }
    /// Creates a new `AddListenerCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddListenerCertificates {
    type Output = std::result::Result<
        crate::output::AddListenerCertificatesOutput,
        crate::error::AddListenerCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_listener_certificates_error(response)
        } else {
            crate::operation_deser::parse_add_listener_certificates_response(response)
        }
    }
}

/// Operation shape for `AddTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags`](crate::client::Client::add_tags).
///
/// See [`crate::client::fluent_builders::AddTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTags {
    _private: (),
}
impl AddTags {
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
    /// Creates a new `AddTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTags {
    type Output = std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_tags_error(response)
        } else {
            crate::operation_deser::parse_add_tags_response(response)
        }
    }
}

/// Operation shape for `CreateListener`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_listener`](crate::client::Client::create_listener).
///
/// See [`crate::client::fluent_builders::CreateListener`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateListener {
    _private: (),
}
impl CreateListener {
    /// Creates a new builder-style object to manufacture [`CreateListenerInput`](crate::input::CreateListenerInput)
    pub fn builder() -> crate::input::create_listener_input::Builder {
        crate::input::create_listener_input::Builder::default()
    }
    /// Creates a new `CreateListener` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateListener {
    type Output =
        std::result::Result<crate::output::CreateListenerOutput, crate::error::CreateListenerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_listener_error(response)
        } else {
            crate::operation_deser::parse_create_listener_response(response)
        }
    }
}

/// Operation shape for `CreateLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_load_balancer`](crate::client::Client::create_load_balancer).
///
/// See [`crate::client::fluent_builders::CreateLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLoadBalancer {
    _private: (),
}
impl CreateLoadBalancer {
    /// Creates a new builder-style object to manufacture [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
    pub fn builder() -> crate::input::create_load_balancer_input::Builder {
        crate::input::create_load_balancer_input::Builder::default()
    }
    /// Creates a new `CreateLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLoadBalancer {
    type Output = std::result::Result<
        crate::output::CreateLoadBalancerOutput,
        crate::error::CreateLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_create_load_balancer_response(response)
        }
    }
}

/// Operation shape for `CreateRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_rule`](crate::client::Client::create_rule).
///
/// See [`crate::client::fluent_builders::CreateRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRule {
    _private: (),
}
impl CreateRule {
    /// Creates a new builder-style object to manufacture [`CreateRuleInput`](crate::input::CreateRuleInput)
    pub fn builder() -> crate::input::create_rule_input::Builder {
        crate::input::create_rule_input::Builder::default()
    }
    /// Creates a new `CreateRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRule {
    type Output =
        std::result::Result<crate::output::CreateRuleOutput, crate::error::CreateRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_rule_error(response)
        } else {
            crate::operation_deser::parse_create_rule_response(response)
        }
    }
}

/// Operation shape for `CreateTargetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_target_group`](crate::client::Client::create_target_group).
///
/// See [`crate::client::fluent_builders::CreateTargetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTargetGroup {
    _private: (),
}
impl CreateTargetGroup {
    /// Creates a new builder-style object to manufacture [`CreateTargetGroupInput`](crate::input::CreateTargetGroupInput)
    pub fn builder() -> crate::input::create_target_group_input::Builder {
        crate::input::create_target_group_input::Builder::default()
    }
    /// Creates a new `CreateTargetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTargetGroup {
    type Output = std::result::Result<
        crate::output::CreateTargetGroupOutput,
        crate::error::CreateTargetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_target_group_error(response)
        } else {
            crate::operation_deser::parse_create_target_group_response(response)
        }
    }
}

/// Operation shape for `DeleteListener`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_listener`](crate::client::Client::delete_listener).
///
/// See [`crate::client::fluent_builders::DeleteListener`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteListener {
    _private: (),
}
impl DeleteListener {
    /// Creates a new builder-style object to manufacture [`DeleteListenerInput`](crate::input::DeleteListenerInput)
    pub fn builder() -> crate::input::delete_listener_input::Builder {
        crate::input::delete_listener_input::Builder::default()
    }
    /// Creates a new `DeleteListener` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteListener {
    type Output =
        std::result::Result<crate::output::DeleteListenerOutput, crate::error::DeleteListenerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_listener_error(response)
        } else {
            crate::operation_deser::parse_delete_listener_response(response)
        }
    }
}

/// Operation shape for `DeleteLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_load_balancer`](crate::client::Client::delete_load_balancer).
///
/// See [`crate::client::fluent_builders::DeleteLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLoadBalancer {
    _private: (),
}
impl DeleteLoadBalancer {
    /// Creates a new builder-style object to manufacture [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
    pub fn builder() -> crate::input::delete_load_balancer_input::Builder {
        crate::input::delete_load_balancer_input::Builder::default()
    }
    /// Creates a new `DeleteLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLoadBalancer {
    type Output = std::result::Result<
        crate::output::DeleteLoadBalancerOutput,
        crate::error::DeleteLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_delete_load_balancer_response(response)
        }
    }
}

/// Operation shape for `DeleteRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_rule`](crate::client::Client::delete_rule).
///
/// See [`crate::client::fluent_builders::DeleteRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRule {
    _private: (),
}
impl DeleteRule {
    /// Creates a new builder-style object to manufacture [`DeleteRuleInput`](crate::input::DeleteRuleInput)
    pub fn builder() -> crate::input::delete_rule_input::Builder {
        crate::input::delete_rule_input::Builder::default()
    }
    /// Creates a new `DeleteRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRule {
    type Output =
        std::result::Result<crate::output::DeleteRuleOutput, crate::error::DeleteRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteTargetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_target_group`](crate::client::Client::delete_target_group).
///
/// See [`crate::client::fluent_builders::DeleteTargetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTargetGroup {
    _private: (),
}
impl DeleteTargetGroup {
    /// Creates a new builder-style object to manufacture [`DeleteTargetGroupInput`](crate::input::DeleteTargetGroupInput)
    pub fn builder() -> crate::input::delete_target_group_input::Builder {
        crate::input::delete_target_group_input::Builder::default()
    }
    /// Creates a new `DeleteTargetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTargetGroup {
    type Output = std::result::Result<
        crate::output::DeleteTargetGroupOutput,
        crate::error::DeleteTargetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_target_group_error(response)
        } else {
            crate::operation_deser::parse_delete_target_group_response(response)
        }
    }
}

/// Operation shape for `DeregisterTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_targets`](crate::client::Client::deregister_targets).
///
/// See [`crate::client::fluent_builders::DeregisterTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterTargets {
    _private: (),
}
impl DeregisterTargets {
    /// Creates a new builder-style object to manufacture [`DeregisterTargetsInput`](crate::input::DeregisterTargetsInput)
    pub fn builder() -> crate::input::deregister_targets_input::Builder {
        crate::input::deregister_targets_input::Builder::default()
    }
    /// Creates a new `DeregisterTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterTargets {
    type Output = std::result::Result<
        crate::output::DeregisterTargetsOutput,
        crate::error::DeregisterTargetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_targets_error(response)
        } else {
            crate::operation_deser::parse_deregister_targets_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountLimits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_limits`](crate::client::Client::describe_account_limits).
///
/// See [`crate::client::fluent_builders::DescribeAccountLimits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountLimits {
    _private: (),
}
impl DescribeAccountLimits {
    /// Creates a new builder-style object to manufacture [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    pub fn builder() -> crate::input::describe_account_limits_input::Builder {
        crate::input::describe_account_limits_input::Builder::default()
    }
    /// Creates a new `DescribeAccountLimits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountLimits {
    type Output = std::result::Result<
        crate::output::DescribeAccountLimitsOutput,
        crate::error::DescribeAccountLimitsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_limits_error(response)
        } else {
            crate::operation_deser::parse_describe_account_limits_response(response)
        }
    }
}

/// Operation shape for `DescribeListenerCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_listener_certificates`](crate::client::Client::describe_listener_certificates).
///
/// See [`crate::client::fluent_builders::DescribeListenerCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeListenerCertificates {
    _private: (),
}
impl DescribeListenerCertificates {
    /// Creates a new builder-style object to manufacture [`DescribeListenerCertificatesInput`](crate::input::DescribeListenerCertificatesInput)
    pub fn builder() -> crate::input::describe_listener_certificates_input::Builder {
        crate::input::describe_listener_certificates_input::Builder::default()
    }
    /// Creates a new `DescribeListenerCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeListenerCertificates {
    type Output = std::result::Result<
        crate::output::DescribeListenerCertificatesOutput,
        crate::error::DescribeListenerCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_listener_certificates_error(response)
        } else {
            crate::operation_deser::parse_describe_listener_certificates_response(response)
        }
    }
}

/// Operation shape for `DescribeListeners`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_listeners`](crate::client::Client::describe_listeners).
///
/// See [`crate::client::fluent_builders::DescribeListeners`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeListeners {
    _private: (),
}
impl DescribeListeners {
    /// Creates a new builder-style object to manufacture [`DescribeListenersInput`](crate::input::DescribeListenersInput)
    pub fn builder() -> crate::input::describe_listeners_input::Builder {
        crate::input::describe_listeners_input::Builder::default()
    }
    /// Creates a new `DescribeListeners` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeListeners {
    type Output = std::result::Result<
        crate::output::DescribeListenersOutput,
        crate::error::DescribeListenersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_listeners_error(response)
        } else {
            crate::operation_deser::parse_describe_listeners_response(response)
        }
    }
}

/// Operation shape for `DescribeLoadBalancerAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_load_balancer_attributes`](crate::client::Client::describe_load_balancer_attributes).
///
/// See [`crate::client::fluent_builders::DescribeLoadBalancerAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLoadBalancerAttributes {
    _private: (),
}
impl DescribeLoadBalancerAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancerAttributesInput`](crate::input::DescribeLoadBalancerAttributesInput)
    pub fn builder() -> crate::input::describe_load_balancer_attributes_input::Builder {
        crate::input::describe_load_balancer_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeLoadBalancerAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLoadBalancerAttributes {
    type Output = std::result::Result<
        crate::output::DescribeLoadBalancerAttributesOutput,
        crate::error::DescribeLoadBalancerAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_load_balancer_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_load_balancer_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeLoadBalancers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_load_balancers`](crate::client::Client::describe_load_balancers).
///
/// See [`crate::client::fluent_builders::DescribeLoadBalancers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLoadBalancers {
    _private: (),
}
impl DescribeLoadBalancers {
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
    pub fn builder() -> crate::input::describe_load_balancers_input::Builder {
        crate::input::describe_load_balancers_input::Builder::default()
    }
    /// Creates a new `DescribeLoadBalancers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLoadBalancers {
    type Output = std::result::Result<
        crate::output::DescribeLoadBalancersOutput,
        crate::error::DescribeLoadBalancersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_load_balancers_error(response)
        } else {
            crate::operation_deser::parse_describe_load_balancers_response(response)
        }
    }
}

/// Operation shape for `DescribeRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_rules`](crate::client::Client::describe_rules).
///
/// See [`crate::client::fluent_builders::DescribeRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRules {
    _private: (),
}
impl DescribeRules {
    /// Creates a new builder-style object to manufacture [`DescribeRulesInput`](crate::input::DescribeRulesInput)
    pub fn builder() -> crate::input::describe_rules_input::Builder {
        crate::input::describe_rules_input::Builder::default()
    }
    /// Creates a new `DescribeRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRules {
    type Output =
        std::result::Result<crate::output::DescribeRulesOutput, crate::error::DescribeRulesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_rules_error(response)
        } else {
            crate::operation_deser::parse_describe_rules_response(response)
        }
    }
}

/// Operation shape for `DescribeSSLPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ssl_policies`](crate::client::Client::describe_ssl_policies).
///
/// See [`crate::client::fluent_builders::DescribeSSLPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSSLPolicies {
    _private: (),
}
impl DescribeSSLPolicies {
    /// Creates a new builder-style object to manufacture [`DescribeSslPoliciesInput`](crate::input::DescribeSslPoliciesInput)
    pub fn builder() -> crate::input::describe_ssl_policies_input::Builder {
        crate::input::describe_ssl_policies_input::Builder::default()
    }
    /// Creates a new `DescribeSSLPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSSLPolicies {
    type Output = std::result::Result<
        crate::output::DescribeSslPoliciesOutput,
        crate::error::DescribeSSLPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ssl_policies_error(response)
        } else {
            crate::operation_deser::parse_describe_ssl_policies_response(response)
        }
    }
}

/// Operation shape for `DescribeTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_tags`](crate::client::Client::describe_tags).
///
/// See [`crate::client::fluent_builders::DescribeTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTags {
    _private: (),
}
impl DescribeTags {
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
    /// Creates a new `DescribeTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTags {
    type Output =
        std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_tags_error(response)
        } else {
            crate::operation_deser::parse_describe_tags_response(response)
        }
    }
}

/// Operation shape for `DescribeTargetGroupAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_target_group_attributes`](crate::client::Client::describe_target_group_attributes).
///
/// See [`crate::client::fluent_builders::DescribeTargetGroupAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTargetGroupAttributes {
    _private: (),
}
impl DescribeTargetGroupAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeTargetGroupAttributesInput`](crate::input::DescribeTargetGroupAttributesInput)
    pub fn builder() -> crate::input::describe_target_group_attributes_input::Builder {
        crate::input::describe_target_group_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeTargetGroupAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTargetGroupAttributes {
    type Output = std::result::Result<
        crate::output::DescribeTargetGroupAttributesOutput,
        crate::error::DescribeTargetGroupAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_target_group_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_target_group_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeTargetGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_target_groups`](crate::client::Client::describe_target_groups).
///
/// See [`crate::client::fluent_builders::DescribeTargetGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTargetGroups {
    _private: (),
}
impl DescribeTargetGroups {
    /// Creates a new builder-style object to manufacture [`DescribeTargetGroupsInput`](crate::input::DescribeTargetGroupsInput)
    pub fn builder() -> crate::input::describe_target_groups_input::Builder {
        crate::input::describe_target_groups_input::Builder::default()
    }
    /// Creates a new `DescribeTargetGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTargetGroups {
    type Output = std::result::Result<
        crate::output::DescribeTargetGroupsOutput,
        crate::error::DescribeTargetGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_target_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_target_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeTargetHealth`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_target_health`](crate::client::Client::describe_target_health).
///
/// See [`crate::client::fluent_builders::DescribeTargetHealth`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTargetHealth {
    _private: (),
}
impl DescribeTargetHealth {
    /// Creates a new builder-style object to manufacture [`DescribeTargetHealthInput`](crate::input::DescribeTargetHealthInput)
    pub fn builder() -> crate::input::describe_target_health_input::Builder {
        crate::input::describe_target_health_input::Builder::default()
    }
    /// Creates a new `DescribeTargetHealth` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTargetHealth {
    type Output = std::result::Result<
        crate::output::DescribeTargetHealthOutput,
        crate::error::DescribeTargetHealthError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_target_health_error(response)
        } else {
            crate::operation_deser::parse_describe_target_health_response(response)
        }
    }
}

/// Operation shape for `ModifyListener`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_listener`](crate::client::Client::modify_listener).
///
/// See [`crate::client::fluent_builders::ModifyListener`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyListener {
    _private: (),
}
impl ModifyListener {
    /// Creates a new builder-style object to manufacture [`ModifyListenerInput`](crate::input::ModifyListenerInput)
    pub fn builder() -> crate::input::modify_listener_input::Builder {
        crate::input::modify_listener_input::Builder::default()
    }
    /// Creates a new `ModifyListener` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyListener {
    type Output =
        std::result::Result<crate::output::ModifyListenerOutput, crate::error::ModifyListenerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_listener_error(response)
        } else {
            crate::operation_deser::parse_modify_listener_response(response)
        }
    }
}

/// Operation shape for `ModifyLoadBalancerAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_load_balancer_attributes`](crate::client::Client::modify_load_balancer_attributes).
///
/// See [`crate::client::fluent_builders::ModifyLoadBalancerAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyLoadBalancerAttributes {
    _private: (),
}
impl ModifyLoadBalancerAttributes {
    /// Creates a new builder-style object to manufacture [`ModifyLoadBalancerAttributesInput`](crate::input::ModifyLoadBalancerAttributesInput)
    pub fn builder() -> crate::input::modify_load_balancer_attributes_input::Builder {
        crate::input::modify_load_balancer_attributes_input::Builder::default()
    }
    /// Creates a new `ModifyLoadBalancerAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyLoadBalancerAttributes {
    type Output = std::result::Result<
        crate::output::ModifyLoadBalancerAttributesOutput,
        crate::error::ModifyLoadBalancerAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_load_balancer_attributes_error(response)
        } else {
            crate::operation_deser::parse_modify_load_balancer_attributes_response(response)
        }
    }
}

/// Operation shape for `ModifyRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_rule`](crate::client::Client::modify_rule).
///
/// See [`crate::client::fluent_builders::ModifyRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyRule {
    _private: (),
}
impl ModifyRule {
    /// Creates a new builder-style object to manufacture [`ModifyRuleInput`](crate::input::ModifyRuleInput)
    pub fn builder() -> crate::input::modify_rule_input::Builder {
        crate::input::modify_rule_input::Builder::default()
    }
    /// Creates a new `ModifyRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyRule {
    type Output =
        std::result::Result<crate::output::ModifyRuleOutput, crate::error::ModifyRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_rule_error(response)
        } else {
            crate::operation_deser::parse_modify_rule_response(response)
        }
    }
}

/// Operation shape for `ModifyTargetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_target_group`](crate::client::Client::modify_target_group).
///
/// See [`crate::client::fluent_builders::ModifyTargetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyTargetGroup {
    _private: (),
}
impl ModifyTargetGroup {
    /// Creates a new builder-style object to manufacture [`ModifyTargetGroupInput`](crate::input::ModifyTargetGroupInput)
    pub fn builder() -> crate::input::modify_target_group_input::Builder {
        crate::input::modify_target_group_input::Builder::default()
    }
    /// Creates a new `ModifyTargetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyTargetGroup {
    type Output = std::result::Result<
        crate::output::ModifyTargetGroupOutput,
        crate::error::ModifyTargetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_target_group_error(response)
        } else {
            crate::operation_deser::parse_modify_target_group_response(response)
        }
    }
}

/// Operation shape for `ModifyTargetGroupAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_target_group_attributes`](crate::client::Client::modify_target_group_attributes).
///
/// See [`crate::client::fluent_builders::ModifyTargetGroupAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyTargetGroupAttributes {
    _private: (),
}
impl ModifyTargetGroupAttributes {
    /// Creates a new builder-style object to manufacture [`ModifyTargetGroupAttributesInput`](crate::input::ModifyTargetGroupAttributesInput)
    pub fn builder() -> crate::input::modify_target_group_attributes_input::Builder {
        crate::input::modify_target_group_attributes_input::Builder::default()
    }
    /// Creates a new `ModifyTargetGroupAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyTargetGroupAttributes {
    type Output = std::result::Result<
        crate::output::ModifyTargetGroupAttributesOutput,
        crate::error::ModifyTargetGroupAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_target_group_attributes_error(response)
        } else {
            crate::operation_deser::parse_modify_target_group_attributes_response(response)
        }
    }
}

/// Operation shape for `RegisterTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_targets`](crate::client::Client::register_targets).
///
/// See [`crate::client::fluent_builders::RegisterTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterTargets {
    _private: (),
}
impl RegisterTargets {
    /// Creates a new builder-style object to manufacture [`RegisterTargetsInput`](crate::input::RegisterTargetsInput)
    pub fn builder() -> crate::input::register_targets_input::Builder {
        crate::input::register_targets_input::Builder::default()
    }
    /// Creates a new `RegisterTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterTargets {
    type Output = std::result::Result<
        crate::output::RegisterTargetsOutput,
        crate::error::RegisterTargetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_targets_error(response)
        } else {
            crate::operation_deser::parse_register_targets_response(response)
        }
    }
}

/// Operation shape for `RemoveListenerCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_listener_certificates`](crate::client::Client::remove_listener_certificates).
///
/// See [`crate::client::fluent_builders::RemoveListenerCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveListenerCertificates {
    _private: (),
}
impl RemoveListenerCertificates {
    /// Creates a new builder-style object to manufacture [`RemoveListenerCertificatesInput`](crate::input::RemoveListenerCertificatesInput)
    pub fn builder() -> crate::input::remove_listener_certificates_input::Builder {
        crate::input::remove_listener_certificates_input::Builder::default()
    }
    /// Creates a new `RemoveListenerCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveListenerCertificates {
    type Output = std::result::Result<
        crate::output::RemoveListenerCertificatesOutput,
        crate::error::RemoveListenerCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_listener_certificates_error(response)
        } else {
            crate::operation_deser::parse_remove_listener_certificates_response(response)
        }
    }
}

/// Operation shape for `RemoveTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_tags`](crate::client::Client::remove_tags).
///
/// See [`crate::client::fluent_builders::RemoveTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTags {
    _private: (),
}
impl RemoveTags {
    /// Creates a new builder-style object to manufacture [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    pub fn builder() -> crate::input::remove_tags_input::Builder {
        crate::input::remove_tags_input::Builder::default()
    }
    /// Creates a new `RemoveTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTags {
    type Output =
        std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_tags_error(response)
        } else {
            crate::operation_deser::parse_remove_tags_response(response)
        }
    }
}

/// Operation shape for `SetIpAddressType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_ip_address_type`](crate::client::Client::set_ip_address_type).
///
/// See [`crate::client::fluent_builders::SetIpAddressType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetIpAddressType {
    _private: (),
}
impl SetIpAddressType {
    /// Creates a new builder-style object to manufacture [`SetIpAddressTypeInput`](crate::input::SetIpAddressTypeInput)
    pub fn builder() -> crate::input::set_ip_address_type_input::Builder {
        crate::input::set_ip_address_type_input::Builder::default()
    }
    /// Creates a new `SetIpAddressType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetIpAddressType {
    type Output = std::result::Result<
        crate::output::SetIpAddressTypeOutput,
        crate::error::SetIpAddressTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_ip_address_type_error(response)
        } else {
            crate::operation_deser::parse_set_ip_address_type_response(response)
        }
    }
}

/// Operation shape for `SetRulePriorities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_rule_priorities`](crate::client::Client::set_rule_priorities).
///
/// See [`crate::client::fluent_builders::SetRulePriorities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetRulePriorities {
    _private: (),
}
impl SetRulePriorities {
    /// Creates a new builder-style object to manufacture [`SetRulePrioritiesInput`](crate::input::SetRulePrioritiesInput)
    pub fn builder() -> crate::input::set_rule_priorities_input::Builder {
        crate::input::set_rule_priorities_input::Builder::default()
    }
    /// Creates a new `SetRulePriorities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetRulePriorities {
    type Output = std::result::Result<
        crate::output::SetRulePrioritiesOutput,
        crate::error::SetRulePrioritiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_rule_priorities_error(response)
        } else {
            crate::operation_deser::parse_set_rule_priorities_response(response)
        }
    }
}

/// Operation shape for `SetSecurityGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_security_groups`](crate::client::Client::set_security_groups).
///
/// See [`crate::client::fluent_builders::SetSecurityGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetSecurityGroups {
    _private: (),
}
impl SetSecurityGroups {
    /// Creates a new builder-style object to manufacture [`SetSecurityGroupsInput`](crate::input::SetSecurityGroupsInput)
    pub fn builder() -> crate::input::set_security_groups_input::Builder {
        crate::input::set_security_groups_input::Builder::default()
    }
    /// Creates a new `SetSecurityGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetSecurityGroups {
    type Output = std::result::Result<
        crate::output::SetSecurityGroupsOutput,
        crate::error::SetSecurityGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_security_groups_error(response)
        } else {
            crate::operation_deser::parse_set_security_groups_response(response)
        }
    }
}

/// Operation shape for `SetSubnets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_subnets`](crate::client::Client::set_subnets).
///
/// See [`crate::client::fluent_builders::SetSubnets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetSubnets {
    _private: (),
}
impl SetSubnets {
    /// Creates a new builder-style object to manufacture [`SetSubnetsInput`](crate::input::SetSubnetsInput)
    pub fn builder() -> crate::input::set_subnets_input::Builder {
        crate::input::set_subnets_input::Builder::default()
    }
    /// Creates a new `SetSubnets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetSubnets {
    type Output =
        std::result::Result<crate::output::SetSubnetsOutput, crate::error::SetSubnetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_subnets_error(response)
        } else {
            crate::operation_deser::parse_set_subnets_response(response)
        }
    }
}
