// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The specified ALPN policy is not supported.</p>
    AlpnPolicyNotSupportedException(crate::error::AlpnPolicyNotSupportedException),
    /// <p>The specified allocation ID does not exist.</p>
    AllocationIdNotFoundException(crate::error::AllocationIdNotFoundException),
    /// <p>The specified Availability Zone is not supported.</p>
    AvailabilityZoneNotSupportedException(crate::error::AvailabilityZoneNotSupportedException),
    /// <p>The specified certificate does not exist.</p>
    CertificateNotFoundException(crate::error::CertificateNotFoundException),
    /// <p>A listener with the specified port already exists.</p>
    DuplicateListenerException(crate::error::DuplicateListenerException),
    /// <p>A load balancer with the specified name already exists.</p>
    DuplicateLoadBalancerNameException(crate::error::DuplicateLoadBalancerNameException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>A target group with the specified name already exists.</p>
    DuplicateTargetGroupNameException(crate::error::DuplicateTargetGroupNameException),
    /// <p>The health of the specified targets could not be retrieved due to an internal error.</p>
    HealthUnavailableException(crate::error::HealthUnavailableException),
    /// <p>The specified configuration is not valid with this protocol.</p>
    IncompatibleProtocolsException(crate::error::IncompatibleProtocolsException),
    /// <p>The requested configuration is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The requested action is not valid.</p>
    InvalidLoadBalancerActionException(crate::error::InvalidLoadBalancerActionException),
    /// <p>The requested scheme is not valid.</p>
    InvalidSchemeException(crate::error::InvalidSchemeException),
    /// <p>The specified security group does not exist.</p>
    InvalidSecurityGroupException(crate::error::InvalidSecurityGroupException),
    /// <p>The specified subnet is out of available addresses.</p>
    InvalidSubnetException(crate::error::InvalidSubnetException),
    /// <p>The specified target does not exist, is not in the same VPC as the target group, or has an unsupported instance type.</p>
    InvalidTargetException(crate::error::InvalidTargetException),
    /// <p>The specified listener does not exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// <p>The specified load balancer does not exist.</p>
    LoadBalancerNotFoundException(crate::error::LoadBalancerNotFoundException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified priority is in use.</p>
    PriorityInUseException(crate::error::PriorityInUseException),
    /// <p>A specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified rule does not exist.</p>
    RuleNotFoundException(crate::error::RuleNotFoundException),
    /// <p>The specified SSL policy does not exist.</p>
    SslPolicyNotFoundException(crate::error::SslPolicyNotFoundException),
    /// <p>The specified subnet does not exist.</p>
    SubnetNotFoundException(crate::error::SubnetNotFoundException),
    /// <p>You've reached the limit on the number of load balancers per target group.</p>
    TargetGroupAssociationLimitException(crate::error::TargetGroupAssociationLimitException),
    /// <p>The specified target group does not exist.</p>
    TargetGroupNotFoundException(crate::error::TargetGroupNotFoundException),
    /// <p>You've reached the limit on the number of actions per rule.</p>
    TooManyActionsException(crate::error::TooManyActionsException),
    /// <p>You've reached the limit on the number of certificates per load balancer.</p>
    TooManyCertificatesException(crate::error::TooManyCertificatesException),
    /// <p>You've reached the limit on the number of listeners per load balancer.</p>
    TooManyListenersException(crate::error::TooManyListenersException),
    /// <p>You've reached the limit on the number of load balancers for your Amazon Web Services account.</p>
    TooManyLoadBalancersException(crate::error::TooManyLoadBalancersException),
    /// <p>You've reached the limit on the number of times a target can be registered with a load balancer.</p>
    TooManyRegistrationsForTargetIdException(
        crate::error::TooManyRegistrationsForTargetIdException,
    ),
    /// <p>You've reached the limit on the number of rules per load balancer.</p>
    TooManyRulesException(crate::error::TooManyRulesException),
    /// <p>You've reached the limit on the number of tags per load balancer.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>You've reached the limit on the number of target groups for your Amazon Web Services account.</p>
    TooManyTargetGroupsException(crate::error::TooManyTargetGroupsException),
    /// <p>You've reached the limit on the number of targets.</p>
    TooManyTargetsException(crate::error::TooManyTargetsException),
    /// <p>You've reached the limit on the number of unique target groups per load balancer across all listeners. If a target group is used by multiple actions for a load balancer, it is counted as only one use.</p>
    TooManyUniqueTargetGroupsPerLoadBalancerException(
        crate::error::TooManyUniqueTargetGroupsPerLoadBalancerException,
    ),
    /// <p>The specified protocol is not supported.</p>
    UnsupportedProtocolException(crate::error::UnsupportedProtocolException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AlpnPolicyNotSupportedException(inner) => inner.fmt(f),
            Error::AllocationIdNotFoundException(inner) => inner.fmt(f),
            Error::AvailabilityZoneNotSupportedException(inner) => inner.fmt(f),
            Error::CertificateNotFoundException(inner) => inner.fmt(f),
            Error::DuplicateListenerException(inner) => inner.fmt(f),
            Error::DuplicateLoadBalancerNameException(inner) => inner.fmt(f),
            Error::DuplicateTagKeysException(inner) => inner.fmt(f),
            Error::DuplicateTargetGroupNameException(inner) => inner.fmt(f),
            Error::HealthUnavailableException(inner) => inner.fmt(f),
            Error::IncompatibleProtocolsException(inner) => inner.fmt(f),
            Error::InvalidConfigurationRequestException(inner) => inner.fmt(f),
            Error::InvalidLoadBalancerActionException(inner) => inner.fmt(f),
            Error::InvalidSchemeException(inner) => inner.fmt(f),
            Error::InvalidSecurityGroupException(inner) => inner.fmt(f),
            Error::InvalidSubnetException(inner) => inner.fmt(f),
            Error::InvalidTargetException(inner) => inner.fmt(f),
            Error::ListenerNotFoundException(inner) => inner.fmt(f),
            Error::LoadBalancerNotFoundException(inner) => inner.fmt(f),
            Error::OperationNotPermittedException(inner) => inner.fmt(f),
            Error::PriorityInUseException(inner) => inner.fmt(f),
            Error::ResourceInUseException(inner) => inner.fmt(f),
            Error::RuleNotFoundException(inner) => inner.fmt(f),
            Error::SslPolicyNotFoundException(inner) => inner.fmt(f),
            Error::SubnetNotFoundException(inner) => inner.fmt(f),
            Error::TargetGroupAssociationLimitException(inner) => inner.fmt(f),
            Error::TargetGroupNotFoundException(inner) => inner.fmt(f),
            Error::TooManyActionsException(inner) => inner.fmt(f),
            Error::TooManyCertificatesException(inner) => inner.fmt(f),
            Error::TooManyListenersException(inner) => inner.fmt(f),
            Error::TooManyLoadBalancersException(inner) => inner.fmt(f),
            Error::TooManyRegistrationsForTargetIdException(inner) => inner.fmt(f),
            Error::TooManyRulesException(inner) => inner.fmt(f),
            Error::TooManyTagsException(inner) => inner.fmt(f),
            Error::TooManyTargetGroupsException(inner) => inner.fmt(f),
            Error::TooManyTargetsException(inner) => inner.fmt(f),
            Error::TooManyUniqueTargetGroupsPerLoadBalancerException(inner) => inner.fmt(f),
            Error::UnsupportedProtocolException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddListenerCertificatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddListenerCertificatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddListenerCertificatesErrorKind::CertificateNotFoundException(
                    inner,
                ) => Error::CertificateNotFoundException(inner),
                crate::error::AddListenerCertificatesErrorKind::ListenerNotFoundException(
                    inner,
                ) => Error::ListenerNotFoundException(inner),
                crate::error::AddListenerCertificatesErrorKind::TooManyCertificatesException(
                    inner,
                ) => Error::TooManyCertificatesException(inner),
                crate::error::AddListenerCertificatesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AddTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddTagsErrorKind::DuplicateTagKeysException(inner) => {
                    Error::DuplicateTagKeysException(inner)
                }
                crate::error::AddTagsErrorKind::ListenerNotFoundException(inner) => {
                    Error::ListenerNotFoundException(inner)
                }
                crate::error::AddTagsErrorKind::LoadBalancerNotFoundException(inner) => {
                    Error::LoadBalancerNotFoundException(inner)
                }
                crate::error::AddTagsErrorKind::RuleNotFoundException(inner) => {
                    Error::RuleNotFoundException(inner)
                }
                crate::error::AddTagsErrorKind::TargetGroupNotFoundException(inner) => {
                    Error::TargetGroupNotFoundException(inner)
                }
                crate::error::AddTagsErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::AddTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateListenerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateListenerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateListenerErrorKind::AlpnPolicyNotSupportedException(inner) => Error::AlpnPolicyNotSupportedException(inner),
                crate::error::CreateListenerErrorKind::CertificateNotFoundException(inner) => Error::CertificateNotFoundException(inner),
                crate::error::CreateListenerErrorKind::DuplicateListenerException(inner) => Error::DuplicateListenerException(inner),
                crate::error::CreateListenerErrorKind::IncompatibleProtocolsException(inner) => Error::IncompatibleProtocolsException(inner),
                crate::error::CreateListenerErrorKind::InvalidConfigurationRequestException(inner) => Error::InvalidConfigurationRequestException(inner),
                crate::error::CreateListenerErrorKind::InvalidLoadBalancerActionException(inner) => Error::InvalidLoadBalancerActionException(inner),
                crate::error::CreateListenerErrorKind::LoadBalancerNotFoundException(inner) => Error::LoadBalancerNotFoundException(inner),
                crate::error::CreateListenerErrorKind::SslPolicyNotFoundException(inner) => Error::SslPolicyNotFoundException(inner),
                crate::error::CreateListenerErrorKind::TargetGroupAssociationLimitException(inner) => Error::TargetGroupAssociationLimitException(inner),
                crate::error::CreateListenerErrorKind::TargetGroupNotFoundException(inner) => Error::TargetGroupNotFoundException(inner),
                crate::error::CreateListenerErrorKind::TooManyActionsException(inner) => Error::TooManyActionsException(inner),
                crate::error::CreateListenerErrorKind::TooManyCertificatesException(inner) => Error::TooManyCertificatesException(inner),
                crate::error::CreateListenerErrorKind::TooManyListenersException(inner) => Error::TooManyListenersException(inner),
                crate::error::CreateListenerErrorKind::TooManyRegistrationsForTargetIdException(inner) => Error::TooManyRegistrationsForTargetIdException(inner),
                crate::error::CreateListenerErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::CreateListenerErrorKind::TooManyTargetsException(inner) => Error::TooManyTargetsException(inner),
                crate::error::CreateListenerErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(inner) => Error::TooManyUniqueTargetGroupsPerLoadBalancerException(inner),
                crate::error::CreateListenerErrorKind::UnsupportedProtocolException(inner) => Error::UnsupportedProtocolException(inner),
                crate::error::CreateListenerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateLoadBalancerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateLoadBalancerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateLoadBalancerErrorKind::AllocationIdNotFoundException(inner) => Error::AllocationIdNotFoundException(inner),
                crate::error::CreateLoadBalancerErrorKind::AvailabilityZoneNotSupportedException(inner) => Error::AvailabilityZoneNotSupportedException(inner),
                crate::error::CreateLoadBalancerErrorKind::DuplicateLoadBalancerNameException(inner) => Error::DuplicateLoadBalancerNameException(inner),
                crate::error::CreateLoadBalancerErrorKind::DuplicateTagKeysException(inner) => Error::DuplicateTagKeysException(inner),
                crate::error::CreateLoadBalancerErrorKind::InvalidConfigurationRequestException(inner) => Error::InvalidConfigurationRequestException(inner),
                crate::error::CreateLoadBalancerErrorKind::InvalidSchemeException(inner) => Error::InvalidSchemeException(inner),
                crate::error::CreateLoadBalancerErrorKind::InvalidSecurityGroupException(inner) => Error::InvalidSecurityGroupException(inner),
                crate::error::CreateLoadBalancerErrorKind::InvalidSubnetException(inner) => Error::InvalidSubnetException(inner),
                crate::error::CreateLoadBalancerErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::CreateLoadBalancerErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::CreateLoadBalancerErrorKind::SubnetNotFoundException(inner) => Error::SubnetNotFoundException(inner),
                crate::error::CreateLoadBalancerErrorKind::TooManyLoadBalancersException(inner) => Error::TooManyLoadBalancersException(inner),
                crate::error::CreateLoadBalancerErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::CreateLoadBalancerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateRuleError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateRuleErrorKind::IncompatibleProtocolsException(inner) => Error::IncompatibleProtocolsException(inner),
                crate::error::CreateRuleErrorKind::InvalidConfigurationRequestException(inner) => Error::InvalidConfigurationRequestException(inner),
                crate::error::CreateRuleErrorKind::InvalidLoadBalancerActionException(inner) => Error::InvalidLoadBalancerActionException(inner),
                crate::error::CreateRuleErrorKind::ListenerNotFoundException(inner) => Error::ListenerNotFoundException(inner),
                crate::error::CreateRuleErrorKind::PriorityInUseException(inner) => Error::PriorityInUseException(inner),
                crate::error::CreateRuleErrorKind::TargetGroupAssociationLimitException(inner) => Error::TargetGroupAssociationLimitException(inner),
                crate::error::CreateRuleErrorKind::TargetGroupNotFoundException(inner) => Error::TargetGroupNotFoundException(inner),
                crate::error::CreateRuleErrorKind::TooManyActionsException(inner) => Error::TooManyActionsException(inner),
                crate::error::CreateRuleErrorKind::TooManyRegistrationsForTargetIdException(inner) => Error::TooManyRegistrationsForTargetIdException(inner),
                crate::error::CreateRuleErrorKind::TooManyRulesException(inner) => Error::TooManyRulesException(inner),
                crate::error::CreateRuleErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::CreateRuleErrorKind::TooManyTargetGroupsException(inner) => Error::TooManyTargetGroupsException(inner),
                crate::error::CreateRuleErrorKind::TooManyTargetsException(inner) => Error::TooManyTargetsException(inner),
                crate::error::CreateRuleErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(inner) => Error::TooManyUniqueTargetGroupsPerLoadBalancerException(inner),
                crate::error::CreateRuleErrorKind::UnsupportedProtocolException(inner) => Error::UnsupportedProtocolException(inner),
                crate::error::CreateRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTargetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateTargetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTargetGroupErrorKind::DuplicateTargetGroupNameException(
                    inner,
                ) => Error::DuplicateTargetGroupNameException(inner),
                crate::error::CreateTargetGroupErrorKind::InvalidConfigurationRequestException(
                    inner,
                ) => Error::InvalidConfigurationRequestException(inner),
                crate::error::CreateTargetGroupErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::CreateTargetGroupErrorKind::TooManyTargetGroupsException(inner) => {
                    Error::TooManyTargetGroupsException(inner)
                }
                crate::error::CreateTargetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteListenerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteListenerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteListenerErrorKind::ListenerNotFoundException(inner) => {
                    Error::ListenerNotFoundException(inner)
                }
                crate::error::DeleteListenerErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::DeleteListenerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteLoadBalancerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteLoadBalancerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteLoadBalancerErrorKind::LoadBalancerNotFoundException(inner) => {
                    Error::LoadBalancerNotFoundException(inner)
                }
                crate::error::DeleteLoadBalancerErrorKind::OperationNotPermittedException(
                    inner,
                ) => Error::OperationNotPermittedException(inner),
                crate::error::DeleteLoadBalancerErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::DeleteLoadBalancerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteRuleError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteRuleErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::DeleteRuleErrorKind::RuleNotFoundException(inner) => {
                    Error::RuleNotFoundException(inner)
                }
                crate::error::DeleteRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTargetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteTargetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTargetGroupErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::DeleteTargetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeregisterTargetsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeregisterTargetsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeregisterTargetsErrorKind::InvalidTargetException(inner) => {
                    Error::InvalidTargetException(inner)
                }
                crate::error::DeregisterTargetsErrorKind::TargetGroupNotFoundException(inner) => {
                    Error::TargetGroupNotFoundException(inner)
                }
                crate::error::DeregisterTargetsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAccountLimitsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAccountLimitsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAccountLimitsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeListenerCertificatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeListenerCertificatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeListenerCertificatesErrorKind::ListenerNotFoundException(
                    inner,
                ) => Error::ListenerNotFoundException(inner),
                crate::error::DescribeListenerCertificatesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeListenersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeListenersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeListenersErrorKind::ListenerNotFoundException(inner) => {
                    Error::ListenerNotFoundException(inner)
                }
                crate::error::DescribeListenersErrorKind::LoadBalancerNotFoundException(inner) => {
                    Error::LoadBalancerNotFoundException(inner)
                }
                crate::error::DescribeListenersErrorKind::UnsupportedProtocolException(inner) => {
                    Error::UnsupportedProtocolException(inner)
                }
                crate::error::DescribeListenersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancerAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeLoadBalancerAttributesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeLoadBalancerAttributesErrorKind::LoadBalancerNotFoundException(inner) => Error::LoadBalancerNotFoundException(inner),
                crate::error::DescribeLoadBalancerAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeLoadBalancersErrorKind::LoadBalancerNotFoundException(
                    inner,
                ) => Error::LoadBalancerNotFoundException(inner),
                crate::error::DescribeLoadBalancersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeRulesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeRulesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeRulesErrorKind::ListenerNotFoundException(inner) => {
                    Error::ListenerNotFoundException(inner)
                }
                crate::error::DescribeRulesErrorKind::RuleNotFoundException(inner) => {
                    Error::RuleNotFoundException(inner)
                }
                crate::error::DescribeRulesErrorKind::UnsupportedProtocolException(inner) => {
                    Error::UnsupportedProtocolException(inner)
                }
                crate::error::DescribeRulesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSSLPoliciesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeSSLPoliciesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeSSLPoliciesErrorKind::SslPolicyNotFoundException(inner) => {
                    Error::SslPolicyNotFoundException(inner)
                }
                crate::error::DescribeSSLPoliciesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTagsErrorKind::ListenerNotFoundException(inner) => {
                    Error::ListenerNotFoundException(inner)
                }
                crate::error::DescribeTagsErrorKind::LoadBalancerNotFoundException(inner) => {
                    Error::LoadBalancerNotFoundException(inner)
                }
                crate::error::DescribeTagsErrorKind::RuleNotFoundException(inner) => {
                    Error::RuleNotFoundException(inner)
                }
                crate::error::DescribeTagsErrorKind::TargetGroupNotFoundException(inner) => {
                    Error::TargetGroupNotFoundException(inner)
                }
                crate::error::DescribeTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTargetGroupAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTargetGroupAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeTargetGroupAttributesErrorKind::TargetGroupNotFoundException(inner) => Error::TargetGroupNotFoundException(inner),
                crate::error::DescribeTargetGroupAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTargetGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTargetGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTargetGroupsErrorKind::LoadBalancerNotFoundException(
                    inner,
                ) => Error::LoadBalancerNotFoundException(inner),
                crate::error::DescribeTargetGroupsErrorKind::TargetGroupNotFoundException(
                    inner,
                ) => Error::TargetGroupNotFoundException(inner),
                crate::error::DescribeTargetGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTargetHealthError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTargetHealthError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTargetHealthErrorKind::HealthUnavailableException(inner) => {
                    Error::HealthUnavailableException(inner)
                }
                crate::error::DescribeTargetHealthErrorKind::InvalidTargetException(inner) => {
                    Error::InvalidTargetException(inner)
                }
                crate::error::DescribeTargetHealthErrorKind::TargetGroupNotFoundException(
                    inner,
                ) => Error::TargetGroupNotFoundException(inner),
                crate::error::DescribeTargetHealthErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyListenerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ModifyListenerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyListenerErrorKind::AlpnPolicyNotSupportedException(inner) => Error::AlpnPolicyNotSupportedException(inner),
                crate::error::ModifyListenerErrorKind::CertificateNotFoundException(inner) => Error::CertificateNotFoundException(inner),
                crate::error::ModifyListenerErrorKind::DuplicateListenerException(inner) => Error::DuplicateListenerException(inner),
                crate::error::ModifyListenerErrorKind::IncompatibleProtocolsException(inner) => Error::IncompatibleProtocolsException(inner),
                crate::error::ModifyListenerErrorKind::InvalidConfigurationRequestException(inner) => Error::InvalidConfigurationRequestException(inner),
                crate::error::ModifyListenerErrorKind::InvalidLoadBalancerActionException(inner) => Error::InvalidLoadBalancerActionException(inner),
                crate::error::ModifyListenerErrorKind::ListenerNotFoundException(inner) => Error::ListenerNotFoundException(inner),
                crate::error::ModifyListenerErrorKind::SslPolicyNotFoundException(inner) => Error::SslPolicyNotFoundException(inner),
                crate::error::ModifyListenerErrorKind::TargetGroupAssociationLimitException(inner) => Error::TargetGroupAssociationLimitException(inner),
                crate::error::ModifyListenerErrorKind::TargetGroupNotFoundException(inner) => Error::TargetGroupNotFoundException(inner),
                crate::error::ModifyListenerErrorKind::TooManyActionsException(inner) => Error::TooManyActionsException(inner),
                crate::error::ModifyListenerErrorKind::TooManyCertificatesException(inner) => Error::TooManyCertificatesException(inner),
                crate::error::ModifyListenerErrorKind::TooManyListenersException(inner) => Error::TooManyListenersException(inner),
                crate::error::ModifyListenerErrorKind::TooManyRegistrationsForTargetIdException(inner) => Error::TooManyRegistrationsForTargetIdException(inner),
                crate::error::ModifyListenerErrorKind::TooManyTargetsException(inner) => Error::TooManyTargetsException(inner),
                crate::error::ModifyListenerErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(inner) => Error::TooManyUniqueTargetGroupsPerLoadBalancerException(inner),
                crate::error::ModifyListenerErrorKind::UnsupportedProtocolException(inner) => Error::UnsupportedProtocolException(inner),
                crate::error::ModifyListenerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyLoadBalancerAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyLoadBalancerAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyLoadBalancerAttributesErrorKind::InvalidConfigurationRequestException(inner) => Error::InvalidConfigurationRequestException(inner),
                crate::error::ModifyLoadBalancerAttributesErrorKind::LoadBalancerNotFoundException(inner) => Error::LoadBalancerNotFoundException(inner),
                crate::error::ModifyLoadBalancerAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ModifyRuleError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyRuleErrorKind::IncompatibleProtocolsException(inner) => Error::IncompatibleProtocolsException(inner),
                crate::error::ModifyRuleErrorKind::InvalidLoadBalancerActionException(inner) => Error::InvalidLoadBalancerActionException(inner),
                crate::error::ModifyRuleErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::ModifyRuleErrorKind::RuleNotFoundException(inner) => Error::RuleNotFoundException(inner),
                crate::error::ModifyRuleErrorKind::TargetGroupAssociationLimitException(inner) => Error::TargetGroupAssociationLimitException(inner),
                crate::error::ModifyRuleErrorKind::TargetGroupNotFoundException(inner) => Error::TargetGroupNotFoundException(inner),
                crate::error::ModifyRuleErrorKind::TooManyActionsException(inner) => Error::TooManyActionsException(inner),
                crate::error::ModifyRuleErrorKind::TooManyRegistrationsForTargetIdException(inner) => Error::TooManyRegistrationsForTargetIdException(inner),
                crate::error::ModifyRuleErrorKind::TooManyTargetsException(inner) => Error::TooManyTargetsException(inner),
                crate::error::ModifyRuleErrorKind::TooManyUniqueTargetGroupsPerLoadBalancerException(inner) => Error::TooManyUniqueTargetGroupsPerLoadBalancerException(inner),
                crate::error::ModifyRuleErrorKind::UnsupportedProtocolException(inner) => Error::UnsupportedProtocolException(inner),
                crate::error::ModifyRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyTargetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyTargetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyTargetGroupErrorKind::InvalidConfigurationRequestException(
                    inner,
                ) => Error::InvalidConfigurationRequestException(inner),
                crate::error::ModifyTargetGroupErrorKind::TargetGroupNotFoundException(inner) => {
                    Error::TargetGroupNotFoundException(inner)
                }
                crate::error::ModifyTargetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyTargetGroupAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyTargetGroupAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyTargetGroupAttributesErrorKind::InvalidConfigurationRequestException(inner) => Error::InvalidConfigurationRequestException(inner),
                crate::error::ModifyTargetGroupAttributesErrorKind::TargetGroupNotFoundException(inner) => Error::TargetGroupNotFoundException(inner),
                crate::error::ModifyTargetGroupAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterTargetsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RegisterTargetsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RegisterTargetsErrorKind::InvalidTargetException(inner) => Error::InvalidTargetException(inner),
                crate::error::RegisterTargetsErrorKind::TargetGroupNotFoundException(inner) => Error::TargetGroupNotFoundException(inner),
                crate::error::RegisterTargetsErrorKind::TooManyRegistrationsForTargetIdException(inner) => Error::TooManyRegistrationsForTargetIdException(inner),
                crate::error::RegisterTargetsErrorKind::TooManyTargetsException(inner) => Error::TooManyTargetsException(inner),
                crate::error::RegisterTargetsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveListenerCertificatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveListenerCertificatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RemoveListenerCertificatesErrorKind::ListenerNotFoundException(inner) => Error::ListenerNotFoundException(inner),
                crate::error::RemoveListenerCertificatesErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::RemoveListenerCertificatesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RemoveTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveTagsErrorKind::ListenerNotFoundException(inner) => {
                    Error::ListenerNotFoundException(inner)
                }
                crate::error::RemoveTagsErrorKind::LoadBalancerNotFoundException(inner) => {
                    Error::LoadBalancerNotFoundException(inner)
                }
                crate::error::RemoveTagsErrorKind::RuleNotFoundException(inner) => {
                    Error::RuleNotFoundException(inner)
                }
                crate::error::RemoveTagsErrorKind::TargetGroupNotFoundException(inner) => {
                    Error::TargetGroupNotFoundException(inner)
                }
                crate::error::RemoveTagsErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::RemoveTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetIpAddressTypeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetIpAddressTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetIpAddressTypeErrorKind::InvalidConfigurationRequestException(
                    inner,
                ) => Error::InvalidConfigurationRequestException(inner),
                crate::error::SetIpAddressTypeErrorKind::InvalidSubnetException(inner) => {
                    Error::InvalidSubnetException(inner)
                }
                crate::error::SetIpAddressTypeErrorKind::LoadBalancerNotFoundException(inner) => {
                    Error::LoadBalancerNotFoundException(inner)
                }
                crate::error::SetIpAddressTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetRulePrioritiesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetRulePrioritiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetRulePrioritiesErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::SetRulePrioritiesErrorKind::PriorityInUseException(inner) => {
                    Error::PriorityInUseException(inner)
                }
                crate::error::SetRulePrioritiesErrorKind::RuleNotFoundException(inner) => {
                    Error::RuleNotFoundException(inner)
                }
                crate::error::SetRulePrioritiesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetSecurityGroupsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetSecurityGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetSecurityGroupsErrorKind::InvalidConfigurationRequestException(
                    inner,
                ) => Error::InvalidConfigurationRequestException(inner),
                crate::error::SetSecurityGroupsErrorKind::InvalidSecurityGroupException(inner) => {
                    Error::InvalidSecurityGroupException(inner)
                }
                crate::error::SetSecurityGroupsErrorKind::LoadBalancerNotFoundException(inner) => {
                    Error::LoadBalancerNotFoundException(inner)
                }
                crate::error::SetSecurityGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetSubnetsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::SetSubnetsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetSubnetsErrorKind::AllocationIdNotFoundException(inner) => {
                    Error::AllocationIdNotFoundException(inner)
                }
                crate::error::SetSubnetsErrorKind::AvailabilityZoneNotSupportedException(inner) => {
                    Error::AvailabilityZoneNotSupportedException(inner)
                }
                crate::error::SetSubnetsErrorKind::InvalidConfigurationRequestException(inner) => {
                    Error::InvalidConfigurationRequestException(inner)
                }
                crate::error::SetSubnetsErrorKind::InvalidSubnetException(inner) => {
                    Error::InvalidSubnetException(inner)
                }
                crate::error::SetSubnetsErrorKind::LoadBalancerNotFoundException(inner) => {
                    Error::LoadBalancerNotFoundException(inner)
                }
                crate::error::SetSubnetsErrorKind::SubnetNotFoundException(inner) => {
                    Error::SubnetNotFoundException(inner)
                }
                crate::error::SetSubnetsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
