// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Elastic Load Balancing
///
/// Client for invoking operations on Elastic Load Balancing. Each operation on Elastic Load Balancing is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_elasticloadbalancingv2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_elasticloadbalancingv2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_elasticloadbalancingv2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddListenerCertificates` operation.
    ///
    /// See [`AddListenerCertificates`](crate::client::fluent_builders::AddListenerCertificates) for more information about the
    /// operation and its arguments.
    pub fn add_listener_certificates(&self) -> fluent_builders::AddListenerCertificates<C, M, R> {
        fluent_builders::AddListenerCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddTags` operation.
    ///
    /// See [`AddTags`](crate::client::fluent_builders::AddTags) for more information about the
    /// operation and its arguments.
    pub fn add_tags(&self) -> fluent_builders::AddTags<C, M, R> {
        fluent_builders::AddTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateListener` operation.
    ///
    /// See [`CreateListener`](crate::client::fluent_builders::CreateListener) for more information about the
    /// operation and its arguments.
    pub fn create_listener(&self) -> fluent_builders::CreateListener<C, M, R> {
        fluent_builders::CreateListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLoadBalancer` operation.
    ///
    /// See [`CreateLoadBalancer`](crate::client::fluent_builders::CreateLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn create_load_balancer(&self) -> fluent_builders::CreateLoadBalancer<C, M, R> {
        fluent_builders::CreateLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRule` operation.
    ///
    /// See [`CreateRule`](crate::client::fluent_builders::CreateRule) for more information about the
    /// operation and its arguments.
    pub fn create_rule(&self) -> fluent_builders::CreateRule<C, M, R> {
        fluent_builders::CreateRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTargetGroup` operation.
    ///
    /// See [`CreateTargetGroup`](crate::client::fluent_builders::CreateTargetGroup) for more information about the
    /// operation and its arguments.
    pub fn create_target_group(&self) -> fluent_builders::CreateTargetGroup<C, M, R> {
        fluent_builders::CreateTargetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteListener` operation.
    ///
    /// See [`DeleteListener`](crate::client::fluent_builders::DeleteListener) for more information about the
    /// operation and its arguments.
    pub fn delete_listener(&self) -> fluent_builders::DeleteListener<C, M, R> {
        fluent_builders::DeleteListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLoadBalancer` operation.
    ///
    /// See [`DeleteLoadBalancer`](crate::client::fluent_builders::DeleteLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn delete_load_balancer(&self) -> fluent_builders::DeleteLoadBalancer<C, M, R> {
        fluent_builders::DeleteLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRule` operation.
    ///
    /// See [`DeleteRule`](crate::client::fluent_builders::DeleteRule) for more information about the
    /// operation and its arguments.
    pub fn delete_rule(&self) -> fluent_builders::DeleteRule<C, M, R> {
        fluent_builders::DeleteRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTargetGroup` operation.
    ///
    /// See [`DeleteTargetGroup`](crate::client::fluent_builders::DeleteTargetGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_target_group(&self) -> fluent_builders::DeleteTargetGroup<C, M, R> {
        fluent_builders::DeleteTargetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterTargets` operation.
    ///
    /// See [`DeregisterTargets`](crate::client::fluent_builders::DeregisterTargets) for more information about the
    /// operation and its arguments.
    pub fn deregister_targets(&self) -> fluent_builders::DeregisterTargets<C, M, R> {
        fluent_builders::DeregisterTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountLimits` operation.
    ///
    /// See [`DescribeAccountLimits`](crate::client::fluent_builders::DescribeAccountLimits) for more information about the
    /// operation and its arguments.
    pub fn describe_account_limits(&self) -> fluent_builders::DescribeAccountLimits<C, M, R> {
        fluent_builders::DescribeAccountLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeListenerCertificates` operation.
    ///
    /// See [`DescribeListenerCertificates`](crate::client::fluent_builders::DescribeListenerCertificates) for more information about the
    /// operation and its arguments.
    pub fn describe_listener_certificates(
        &self,
    ) -> fluent_builders::DescribeListenerCertificates<C, M, R> {
        fluent_builders::DescribeListenerCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeListeners` operation.
    ///
    /// See [`DescribeListeners`](crate::client::fluent_builders::DescribeListeners) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeListeners::into_paginator).
    pub fn describe_listeners(&self) -> fluent_builders::DescribeListeners<C, M, R> {
        fluent_builders::DescribeListeners::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLoadBalancerAttributes` operation.
    ///
    /// See [`DescribeLoadBalancerAttributes`](crate::client::fluent_builders::DescribeLoadBalancerAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_load_balancer_attributes(
        &self,
    ) -> fluent_builders::DescribeLoadBalancerAttributes<C, M, R> {
        fluent_builders::DescribeLoadBalancerAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLoadBalancers` operation.
    ///
    /// See [`DescribeLoadBalancers`](crate::client::fluent_builders::DescribeLoadBalancers) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeLoadBalancers::into_paginator).
    pub fn describe_load_balancers(&self) -> fluent_builders::DescribeLoadBalancers<C, M, R> {
        fluent_builders::DescribeLoadBalancers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRules` operation.
    ///
    /// See [`DescribeRules`](crate::client::fluent_builders::DescribeRules) for more information about the
    /// operation and its arguments.
    pub fn describe_rules(&self) -> fluent_builders::DescribeRules<C, M, R> {
        fluent_builders::DescribeRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSSLPolicies` operation.
    ///
    /// See [`DescribeSSLPolicies`](crate::client::fluent_builders::DescribeSSLPolicies) for more information about the
    /// operation and its arguments.
    pub fn describe_ssl_policies(&self) -> fluent_builders::DescribeSSLPolicies<C, M, R> {
        fluent_builders::DescribeSSLPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTags` operation.
    ///
    /// See [`DescribeTags`](crate::client::fluent_builders::DescribeTags) for more information about the
    /// operation and its arguments.
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags<C, M, R> {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTargetGroupAttributes` operation.
    ///
    /// See [`DescribeTargetGroupAttributes`](crate::client::fluent_builders::DescribeTargetGroupAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_target_group_attributes(
        &self,
    ) -> fluent_builders::DescribeTargetGroupAttributes<C, M, R> {
        fluent_builders::DescribeTargetGroupAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTargetGroups` operation.
    ///
    /// See [`DescribeTargetGroups`](crate::client::fluent_builders::DescribeTargetGroups) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTargetGroups::into_paginator).
    pub fn describe_target_groups(&self) -> fluent_builders::DescribeTargetGroups<C, M, R> {
        fluent_builders::DescribeTargetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTargetHealth` operation.
    ///
    /// See [`DescribeTargetHealth`](crate::client::fluent_builders::DescribeTargetHealth) for more information about the
    /// operation and its arguments.
    pub fn describe_target_health(&self) -> fluent_builders::DescribeTargetHealth<C, M, R> {
        fluent_builders::DescribeTargetHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyListener` operation.
    ///
    /// See [`ModifyListener`](crate::client::fluent_builders::ModifyListener) for more information about the
    /// operation and its arguments.
    pub fn modify_listener(&self) -> fluent_builders::ModifyListener<C, M, R> {
        fluent_builders::ModifyListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyLoadBalancerAttributes` operation.
    ///
    /// See [`ModifyLoadBalancerAttributes`](crate::client::fluent_builders::ModifyLoadBalancerAttributes) for more information about the
    /// operation and its arguments.
    pub fn modify_load_balancer_attributes(
        &self,
    ) -> fluent_builders::ModifyLoadBalancerAttributes<C, M, R> {
        fluent_builders::ModifyLoadBalancerAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyRule` operation.
    ///
    /// See [`ModifyRule`](crate::client::fluent_builders::ModifyRule) for more information about the
    /// operation and its arguments.
    pub fn modify_rule(&self) -> fluent_builders::ModifyRule<C, M, R> {
        fluent_builders::ModifyRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyTargetGroup` operation.
    ///
    /// See [`ModifyTargetGroup`](crate::client::fluent_builders::ModifyTargetGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_target_group(&self) -> fluent_builders::ModifyTargetGroup<C, M, R> {
        fluent_builders::ModifyTargetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyTargetGroupAttributes` operation.
    ///
    /// See [`ModifyTargetGroupAttributes`](crate::client::fluent_builders::ModifyTargetGroupAttributes) for more information about the
    /// operation and its arguments.
    pub fn modify_target_group_attributes(
        &self,
    ) -> fluent_builders::ModifyTargetGroupAttributes<C, M, R> {
        fluent_builders::ModifyTargetGroupAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterTargets` operation.
    ///
    /// See [`RegisterTargets`](crate::client::fluent_builders::RegisterTargets) for more information about the
    /// operation and its arguments.
    pub fn register_targets(&self) -> fluent_builders::RegisterTargets<C, M, R> {
        fluent_builders::RegisterTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveListenerCertificates` operation.
    ///
    /// See [`RemoveListenerCertificates`](crate::client::fluent_builders::RemoveListenerCertificates) for more information about the
    /// operation and its arguments.
    pub fn remove_listener_certificates(
        &self,
    ) -> fluent_builders::RemoveListenerCertificates<C, M, R> {
        fluent_builders::RemoveListenerCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTags` operation.
    ///
    /// See [`RemoveTags`](crate::client::fluent_builders::RemoveTags) for more information about the
    /// operation and its arguments.
    pub fn remove_tags(&self) -> fluent_builders::RemoveTags<C, M, R> {
        fluent_builders::RemoveTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetIpAddressType` operation.
    ///
    /// See [`SetIpAddressType`](crate::client::fluent_builders::SetIpAddressType) for more information about the
    /// operation and its arguments.
    pub fn set_ip_address_type(&self) -> fluent_builders::SetIpAddressType<C, M, R> {
        fluent_builders::SetIpAddressType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetRulePriorities` operation.
    ///
    /// See [`SetRulePriorities`](crate::client::fluent_builders::SetRulePriorities) for more information about the
    /// operation and its arguments.
    pub fn set_rule_priorities(&self) -> fluent_builders::SetRulePriorities<C, M, R> {
        fluent_builders::SetRulePriorities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetSecurityGroups` operation.
    ///
    /// See [`SetSecurityGroups`](crate::client::fluent_builders::SetSecurityGroups) for more information about the
    /// operation and its arguments.
    pub fn set_security_groups(&self) -> fluent_builders::SetSecurityGroups<C, M, R> {
        fluent_builders::SetSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetSubnets` operation.
    ///
    /// See [`SetSubnets`](crate::client::fluent_builders::SetSubnets) for more information about the
    /// operation and its arguments.
    pub fn set_subnets(&self) -> fluent_builders::SetSubnets<C, M, R> {
        fluent_builders::SetSubnets::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddListenerCertificates`.
    ///
    /// <p>Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.</p>
    /// <p>If the certificate in already in the certificate list, the call is successful but the certificate is not added again.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html">HTTPS listeners</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html">TLS listeners</a> in the <i>Network Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddListenerCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_listener_certificates_input::Builder,
    }
    impl<C, M, R> AddListenerCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddListenerCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddListenerCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::AddListenerCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddListenerCertificatesInputOperationOutputAlias,
                crate::output::AddListenerCertificatesOutput,
                crate::error::AddListenerCertificatesError,
                crate::input::AddListenerCertificatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// Appends an item to `Certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>The certificate to add. You can specify one certificate per call. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn certificates(mut self, input: crate::model::Certificate) -> Self {
            self.inner = self.inner.certificates(input);
            self
        }
        /// <p>The certificate to add. You can specify one certificate per call. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.inner = self.inner.set_certificates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTags`.
    ///
    /// <p>Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, and rules.</p>
    /// <p>Each tag consists of a key and an optional value. If a resource already has a tag with the same key, <code>AddTags</code> updates its value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_input::Builder,
    }
    impl<C, M, R> AddTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsInputOperationOutputAlias,
                crate::output::AddTagsOutput,
                crate::error::AddTagsError,
                crate::input::AddTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateListener`.
    ///
    /// <p>Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.</p>
    /// <p>For more information, see the following:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html">Listeners for your Application Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html">Listeners for your Network Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html">Listeners for your Gateway Load Balancers</a> </p> </li>
    /// </ul>
    /// <p>This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple listeners with the same settings, each call succeeds.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateListener<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_listener_input::Builder,
    }
    impl<C, M, R> CreateListener<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateListenerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateListenerInputOperationOutputAlias,
                crate::output::CreateListenerOutput,
                crate::error::CreateListenerError,
                crate::input::CreateListenerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// <p>The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>
        pub fn protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.inner = self.inner.protocol(input);
            self
        }
        /// <p>The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>The port on which the load balancer is listening. You cannot specify a port for a Gateway Load Balancer.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port on which the load balancer is listening. You cannot specify a port for a Gateway Load Balancer.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> and <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn ssl_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssl_policy(input.into());
            self
        }
        /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> and <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn set_ssl_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ssl_policy(input);
            self
        }
        /// Appends an item to `Certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn certificates(mut self, input: crate::model::Certificate) -> Self {
            self.inner = self.inner.certificates(input);
            self
        }
        /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.inner = self.inner.set_certificates(input);
            self
        }
        /// Appends an item to `DefaultActions`.
        ///
        /// To override the contents of this collection use [`set_default_actions`](Self::set_default_actions).
        ///
        /// <p>The actions for the default rule.</p>
        pub fn default_actions(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.default_actions(input);
            self
        }
        /// <p>The actions for the default rule.</p>
        pub fn set_default_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.inner = self.inner.set_default_actions(input);
            self
        }
        /// Appends an item to `AlpnPolicy`.
        ///
        /// To override the contents of this collection use [`set_alpn_policy`](Self::set_alpn_policy).
        ///
        /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:</p>
        /// <ul>
        /// <li> <p> <code>HTTP1Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Optional</code> </p> </li>
        /// <li> <p> <code>HTTP2Preferred</code> </p> </li>
        /// <li> <p> <code>None</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn alpn_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alpn_policy(input.into());
            self
        }
        /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:</p>
        /// <ul>
        /// <li> <p> <code>HTTP1Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Optional</code> </p> </li>
        /// <li> <p> <code>HTTP2Preferred</code> </p> </li>
        /// <li> <p> <code>None</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn set_alpn_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_alpn_policy(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the listener.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to assign to the listener.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLoadBalancer`.
    ///
    /// <p>Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.</p>
    /// <p>For more information, see the following:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html">Application Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html">Network Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html">Gateway Load Balancers</a> </p> </li>
    /// </ul>
    /// <p>This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple load balancers with the same settings, each call succeeds.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_load_balancer_input::Builder,
    }
    impl<C, M, R> CreateLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLoadBalancerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLoadBalancerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLoadBalancerInputOperationOutputAlias,
                crate::output::CreateLoadBalancerOutput,
                crate::error::CreateLoadBalancerError,
                crate::input::CreateLoadBalancerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones.</p>
        /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnets(input.into());
            self
        }
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones.</p>
        /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnets(input);
            self
        }
        /// Appends an item to `SubnetMappings`.
        ///
        /// To override the contents of this collection use [`set_subnet_mappings`](Self::set_subnet_mappings).
        ///
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.</p>
        /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        pub fn subnet_mappings(mut self, input: crate::model::SubnetMapping) -> Self {
            self.inner = self.inner.subnet_mappings(input);
            self
        }
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.</p>
        /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        pub fn set_subnet_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_mappings(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>[Application Load Balancers] The IDs of the security groups for the load balancer.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(input.into());
            self
        }
        /// <p>[Application Load Balancers] The IDs of the security groups for the load balancer.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
        /// <p>The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.</p>
        /// <p>The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.</p>
        /// <p>The default is an Internet-facing load balancer.</p>
        /// <p>You cannot specify a scheme for a Gateway Load Balancer.</p>
        pub fn scheme(mut self, input: crate::model::LoadBalancerSchemeEnum) -> Self {
            self.inner = self.inner.scheme(input);
            self
        }
        /// <p>The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.</p>
        /// <p>The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.</p>
        /// <p>The default is an Internet-facing load balancer.</p>
        /// <p>You cannot specify a scheme for a Gateway Load Balancer.</p>
        pub fn set_scheme(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerSchemeEnum>,
        ) -> Self {
            self.inner = self.inner.set_scheme(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the load balancer.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to assign to the load balancer.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The type of load balancer. The default is <code>application</code>.</p>
        pub fn r#type(mut self, input: crate::model::LoadBalancerTypeEnum) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of load balancer. The default is <code>application</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). </p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(input);
            self
        }
        /// <p>The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). </p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
        /// <p>[Application Load Balancers on Outposts] The ID of the customer-owned address pool (CoIP pool).</p>
        pub fn customer_owned_ipv4_pool(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_owned_ipv4_pool(input.into());
            self
        }
        /// <p>[Application Load Balancers on Outposts] The ID of the customer-owned address pool (CoIP pool).</p>
        pub fn set_customer_owned_ipv4_pool(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_customer_owned_ipv4_pool(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRule`.
    ///
    /// <p>Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.</p>
    /// <p>Each rule consists of a priority, one or more actions, and one or more conditions. Rules are evaluated in priority order, from the lowest value to the highest value. When the conditions for a rule are met, its actions are performed. If the conditions for no rules are met, the actions for the default rule are performed. For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules">Listener rules</a> in the <i>Application Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_rule_input::Builder,
    }
    impl<C, M, R> CreateRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRuleInputOperationOutputAlias,
                crate::output::CreateRuleOutput,
                crate::error::CreateRuleError,
                crate::input::CreateRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// Appends an item to `Conditions`.
        ///
        /// To override the contents of this collection use [`set_conditions`](Self::set_conditions).
        ///
        /// <p>The conditions.</p>
        pub fn conditions(mut self, input: crate::model::RuleCondition) -> Self {
            self.inner = self.inner.conditions(input);
            self
        }
        /// <p>The conditions.</p>
        pub fn set_conditions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleCondition>>,
        ) -> Self {
            self.inner = self.inner.set_conditions(input);
            self
        }
        /// <p>The rule priority. A listener can't have multiple rules with the same priority.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.inner = self.inner.priority(input);
            self
        }
        /// <p>The rule priority. A listener can't have multiple rules with the same priority.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// Appends an item to `Actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions.</p>
        pub fn actions(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.actions(input);
            self
        }
        /// <p>The actions.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the rule.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to assign to the rule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTargetGroup`.
    ///
    /// <p>Creates a target group.</p>
    /// <p>For more information, see the following:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html">Target groups for your Application Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html">Target groups for your Network Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html">Target groups for your Gateway Load Balancers</a> </p> </li>
    /// </ul>
    /// <p>This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple target groups with the same settings, each call succeeds.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTargetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_target_group_input::Builder,
    }
    impl<C, M, R> CreateTargetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTargetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTargetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTargetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTargetGroupInputOperationOutputAlias,
                crate::output::CreateTargetGroupOutput,
                crate::error::CreateTargetGroupError,
                crate::input::CreateTargetGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the target group.</p>
        /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the target group.</p>
        /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.</p>
        pub fn protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.inner = self.inner.protocol(input);
            self
        }
        /// <p>The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>[HTTP/HTTPS protocol] The protocol version. Specify <code>GRPC</code> to send requests to targets using gRPC. Specify <code>HTTP2</code> to send requests to targets using HTTP/2. The default is <code>HTTP1</code>, which sends requests to targets using HTTP/1.1.</p>
        pub fn protocol_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protocol_version(input.into());
            self
        }
        /// <p>[HTTP/HTTPS protocol] The protocol version. Specify <code>GRPC</code> to send requests to targets using gRPC. Specify <code>HTTP2</code> to send requests to targets using HTTP/2. The default is <code>HTTP1</code>, which sends requests to targets using HTTP/1.1.</p>
        pub fn set_protocol_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protocol_version(input);
            self
        }
        /// <p>The port on which the targets receive traffic. This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port on which the targets receive traffic. This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The identifier of the virtual private cloud (VPC). If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The identifier of the virtual private cloud (VPC). If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>
        pub fn health_check_protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.inner = self.inner.health_check_protocol(input);
            self
        }
        /// <p>The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>
        pub fn set_health_check_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.inner = self.inner.set_health_check_protocol(input);
            self
        }
        /// <p>The port the load balancer uses when performing health checks on targets. If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code>, which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.</p>
        pub fn health_check_port(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_port(input.into());
            self
        }
        /// <p>The port the load balancer uses when performing health checks on targets. If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code>, which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.</p>
        pub fn set_health_check_port(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_port(input);
            self
        }
        /// <p>Indicates whether health checks are enabled. If the target type is <code>lambda</code>, health checks are disabled by default but can be enabled. If the target type is <code>instance</code>, <code>ip</code>, or <code>alb</code>, health checks are always enabled and cannot be disabled.</p>
        pub fn health_check_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.health_check_enabled(input);
            self
        }
        /// <p>Indicates whether health checks are enabled. If the target type is <code>lambda</code>, health checks are disabled by default but can be enabled. If the target type is <code>instance</code>, <code>ip</code>, or <code>alb</code>, health checks are always enabled and cannot be disabled.</p>
        pub fn set_health_check_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_health_check_enabled(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
        /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
        /// <p>[GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
        pub fn health_check_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_path(input.into());
            self
        }
        /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
        /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
        /// <p>[GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_path(input);
            self
        }
        /// <p>The approximate amount of time, in seconds, between health checks of an individual target. If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30 seconds. If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is <code>lambda</code>, the default is 35 seconds.</p>
        pub fn health_check_interval_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_interval_seconds(input);
            self
        }
        /// <p>The approximate amount of time, in seconds, between health checks of an individual target. If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30 seconds. If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is <code>lambda</code>, the default is 35 seconds.</p>
        pub fn set_health_check_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_health_check_interval_seconds(input);
            self
        }
        /// <p>The amount of time, in seconds, during which no response from a target means a failed health check. For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is <code>lambda</code>, the default is 30 seconds.</p>
        pub fn health_check_timeout_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_timeout_seconds(input);
            self
        }
        /// <p>The amount of time, in seconds, during which no response from a target means a failed health check. For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is <code>lambda</code>, the default is 30 seconds.</p>
        pub fn set_health_check_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_health_check_timeout_seconds(input);
            self
        }
        /// <p>The number of consecutive health checks successes required before considering an unhealthy target healthy. For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is <code>lambda</code>, the default is 5.</p>
        pub fn healthy_threshold_count(mut self, input: i32) -> Self {
            self.inner = self.inner.healthy_threshold_count(input);
            self
        }
        /// <p>The number of consecutive health checks successes required before considering an unhealthy target healthy. For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is <code>lambda</code>, the default is 5.</p>
        pub fn set_healthy_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_healthy_threshold_count(input);
            self
        }
        /// <p>The number of consecutive health check failures required before considering a target unhealthy. If the target group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If the target group protocol is GENEVE, the default is 3. If the target type is <code>lambda</code>, the default is 2.</p>
        pub fn unhealthy_threshold_count(mut self, input: i32) -> Self {
            self.inner = self.inner.unhealthy_threshold_count(input);
            self
        }
        /// <p>The number of consecutive health check failures required before considering a target unhealthy. If the target group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If the target group protocol is GENEVE, the default is 3. If the target type is <code>lambda</code>, the default is 2.</p>
        pub fn set_unhealthy_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_unhealthy_threshold_count(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.</p>
        pub fn matcher(mut self, input: crate::model::Matcher) -> Self {
            self.inner = self.inner.matcher(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.</p>
        pub fn set_matcher(mut self, input: std::option::Option<crate::model::Matcher>) -> Self {
            self.inner = self.inner.set_matcher(input);
            self
        }
        /// <p>The type of target that you must specify when registering targets with this target group. You can't specify targets for a target group using more than one target type.</p>
        /// <ul>
        /// <li> <p> <code>instance</code> - Register targets by instance ID. This is the default value.</p> </li>
        /// <li> <p> <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.</p> </li>
        /// <li> <p> <code>lambda</code> - Register a single Lambda function as a target.</p> </li>
        /// <li> <p> <code>alb</code> - Register a single Application Load Balancer as a target.</p> </li>
        /// </ul>
        pub fn target_type(mut self, input: crate::model::TargetTypeEnum) -> Self {
            self.inner = self.inner.target_type(input);
            self
        }
        /// <p>The type of target that you must specify when registering targets with this target group. You can't specify targets for a target group using more than one target type.</p>
        /// <ul>
        /// <li> <p> <code>instance</code> - Register targets by instance ID. This is the default value.</p> </li>
        /// <li> <p> <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.</p> </li>
        /// <li> <p> <code>lambda</code> - Register a single Lambda function as a target.</p> </li>
        /// <li> <p> <code>alb</code> - Register a single Application Load Balancer as a target.</p> </li>
        /// </ul>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the target group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to assign to the target group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The type of IP address used for this target group. The possible values are <code>ipv4</code> and <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code>.</p>
        pub fn ip_address_type(
            mut self,
            input: crate::model::TargetGroupIpAddressTypeEnum,
        ) -> Self {
            self.inner = self.inner.ip_address_type(input);
            self
        }
        /// <p>The type of IP address used for this target group. The possible values are <code>ipv4</code> and <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code>.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::TargetGroupIpAddressTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteListener`.
    ///
    /// <p>Deletes the specified listener.</p>
    /// <p>Alternatively, your listener is deleted when you delete the load balancer to which it is attached.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteListener<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_listener_input::Builder,
    }
    impl<C, M, R> DeleteListener<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteListenerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteListenerInputOperationOutputAlias,
                crate::output::DeleteListenerOutput,
                crate::error::DeleteListenerError,
                crate::input::DeleteListenerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLoadBalancer`.
    ///
    /// <p>Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load balancer also deletes its listeners.</p>
    /// <p>You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has already been deleted, the call succeeds.</p>
    /// <p>Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or terminate them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_load_balancer_input::Builder,
    }
    impl<C, M, R> DeleteLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLoadBalancerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLoadBalancerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLoadBalancerInputOperationOutputAlias,
                crate::output::DeleteLoadBalancerOutput,
                crate::error::DeleteLoadBalancerError,
                crate::input::DeleteLoadBalancerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRule`.
    ///
    /// <p>Deletes the specified rule.</p>
    /// <p>You can't delete the default rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_rule_input::Builder,
    }
    impl<C, M, R> DeleteRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRuleInputOperationOutputAlias,
                crate::output::DeleteRuleOutput,
                crate::error::DeleteRuleError,
                crate::input::DeleteRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTargetGroup`.
    ///
    /// <p>Deletes the specified target group.</p>
    /// <p>You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2 instances continue to run until you stop or terminate them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTargetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_target_group_input::Builder,
    }
    impl<C, M, R> DeleteTargetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTargetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTargetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTargetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTargetGroupInputOperationOutputAlias,
                crate::output::DeleteTargetGroupOutput,
                crate::error::DeleteTargetGroupError,
                crate::input::DeleteTargetGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterTargets`.
    ///
    /// <p>Deregisters the specified targets from the specified target group. After the targets are deregistered, they no longer receive traffic from the load balancer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_targets_input::Builder,
    }
    impl<C, M, R> DeregisterTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterTargetsInputOperationOutputAlias,
                crate::output::DeregisterTargetsOutput,
                crate::error::DeregisterTargetsError,
                crate::input::DeregisterTargetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets. If you specified a port override when you registered a target, you must specify both the target ID and the port when you deregister it.</p>
        pub fn targets(mut self, input: crate::model::TargetDescription) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>The targets. If you specified a port override when you registered a target, you must specify both the target ID and the port when you deregister it.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountLimits`.
    ///
    /// <p>Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.</p>
    /// <p>For more information, see the following:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas for your Application Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Quotas for your Network Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html">Quotas for your Gateway Load Balancers</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountLimits<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_limits_input::Builder,
    }
    impl<C, M, R> DescribeAccountLimits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountLimitsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountLimitsInputOperationOutputAlias,
                crate::output::DescribeAccountLimitsOutput,
                crate::error::DescribeAccountLimitsError,
                crate::input::DescribeAccountLimitsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeListenerCertificates`.
    ///
    /// <p>Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.</p>
    /// <p>If the default certificate is also in the certificate list, it appears twice in the results (once with <code>IsDefault</code> set to true and once with <code>IsDefault</code> set to false).</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates">SSL certificates</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#tls-listener-certificate">Server certificates</a> in the <i>Network Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeListenerCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_listener_certificates_input::Builder,
    }
    impl<C, M, R> DescribeListenerCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeListenerCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeListenerCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeListenerCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeListenerCertificatesInputOperationOutputAlias,
                crate::output::DescribeListenerCertificatesOutput,
                crate::error::DescribeListenerCertificatesError,
                crate::input::DescribeListenerCertificatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Names (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeListeners`.
    ///
    /// <p>Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeListeners<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_listeners_input::Builder,
    }
    impl<C, M, R> DescribeListeners<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeListeners`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeListenersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeListenersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeListenersInputOperationOutputAlias,
                crate::output::DescribeListenersOutput,
                crate::error::DescribeListenersError,
                crate::input::DescribeListenersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeListenersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeListenersPaginator<C, M, R> {
            crate::paginator::DescribeListenersPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// Appends an item to `ListenerArns`.
        ///
        /// To override the contents of this collection use [`set_listener_arns`](Self::set_listener_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the listeners.</p>
        pub fn listener_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the listeners.</p>
        pub fn set_listener_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_listener_arns(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoadBalancerAttributes`.
    ///
    /// <p>Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.</p>
    /// <p>For more information, see the following:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes">Load balancer attributes</a> in the <i>Application Load Balancers Guide</i> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes">Load balancer attributes</a> in the <i>Network Load Balancers Guide</i> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes">Load balancer attributes</a> in the <i>Gateway Load Balancers Guide</i> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoadBalancerAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_load_balancer_attributes_input::Builder,
    }
    impl<C, M, R> DescribeLoadBalancerAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLoadBalancerAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoadBalancerAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancerAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLoadBalancerAttributesInputOperationOutputAlias,
                crate::output::DescribeLoadBalancerAttributesOutput,
                crate::error::DescribeLoadBalancerAttributesError,
                crate::input::DescribeLoadBalancerAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoadBalancers`.
    ///
    /// <p>Describes the specified load balancers or all of your load balancers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoadBalancers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_load_balancers_input::Builder,
    }
    impl<C, M, R> DescribeLoadBalancers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLoadBalancers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoadBalancersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLoadBalancersInputOperationOutputAlias,
                crate::output::DescribeLoadBalancersOutput,
                crate::error::DescribeLoadBalancersError,
                crate::input::DescribeLoadBalancersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeLoadBalancersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeLoadBalancersPaginator<C, M, R> {
            crate::paginator::DescribeLoadBalancersPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `LoadBalancerArns`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_arns`](Self::set_load_balancer_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the load balancers. You can specify up to 20 load balancers in a single call.</p>
        pub fn load_balancer_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the load balancers. You can specify up to 20 load balancers in a single call.</p>
        pub fn set_load_balancer_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arns(input);
            self
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the load balancers.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>The names of the load balancers.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRules`.
    ///
    /// <p>Describes the specified rules or the rules for the specified listener. You must specify either a listener or one or more rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_rules_input::Builder,
    }
    impl<C, M, R> DescribeRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRulesInputOperationOutputAlias,
                crate::output::DescribeRulesOutput,
                crate::error::DescribeRulesError,
                crate::input::DescribeRulesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// Appends an item to `RuleArns`.
        ///
        /// To override the contents of this collection use [`set_rule_arns`](Self::set_rule_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the rules.</p>
        pub fn rule_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the rules.</p>
        pub fn set_rule_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_rule_arns(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSSLPolicies`.
    ///
    /// <p>Describes the specified policies or all policies used for SSL negotiation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSSLPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ssl_policies_input::Builder,
    }
    impl<C, M, R> DescribeSSLPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSSLPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSslPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSSLPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSslPoliciesInputOperationOutputAlias,
                crate::output::DescribeSslPoliciesOutput,
                crate::error::DescribeSSLPoliciesError,
                crate::input::DescribeSslPoliciesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the policies.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>The names of the policies.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p> The type of load balancer. The default lists the SSL policies for all load balancers.</p>
        pub fn load_balancer_type(mut self, input: crate::model::LoadBalancerTypeEnum) -> Self {
            self.inner = self.inner.load_balancer_type(input);
            self
        }
        /// <p> The type of load balancer. The default lists the SSL policies for all load balancers.</p>
        pub fn set_load_balancer_type(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <p>Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl<C, M, R> DescribeTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTagsInputOperationOutputAlias,
                crate::output::DescribeTagsOutput,
                crate::error::DescribeTagsError,
                crate::input::DescribeTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the resources. You can specify up to 20 resources in a single call.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the resources. You can specify up to 20 resources in a single call.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTargetGroupAttributes`.
    ///
    /// <p>Describes the attributes for the specified target group.</p>
    /// <p>For more information, see the following:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes">Target group attributes</a> in the <i>Application Load Balancers Guide</i> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes">Target group attributes</a> in the <i>Network Load Balancers Guide</i> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes">Target group attributes</a> in the <i>Gateway Load Balancers Guide</i> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTargetGroupAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_target_group_attributes_input::Builder,
    }
    impl<C, M, R> DescribeTargetGroupAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTargetGroupAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTargetGroupAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTargetGroupAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTargetGroupAttributesInputOperationOutputAlias,
                crate::output::DescribeTargetGroupAttributesOutput,
                crate::error::DescribeTargetGroupAttributesError,
                crate::input::DescribeTargetGroupAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTargetGroups`.
    ///
    /// <p>Describes the specified target groups or all of your target groups. By default, all target groups are described. Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the names of one or more target groups, or the ARNs of one or more target groups.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTargetGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_target_groups_input::Builder,
    }
    impl<C, M, R> DescribeTargetGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTargetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTargetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTargetGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTargetGroupsInputOperationOutputAlias,
                crate::output::DescribeTargetGroupsOutput,
                crate::error::DescribeTargetGroupsError,
                crate::input::DescribeTargetGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeTargetGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeTargetGroupsPaginator<C, M, R> {
            crate::paginator::DescribeTargetGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// Appends an item to `TargetGroupArns`.
        ///
        /// To override the contents of this collection use [`set_target_group_arns`](Self::set_target_group_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the target groups.</p>
        pub fn target_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the target groups.</p>
        pub fn set_target_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arns(input);
            self
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the target groups.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>The names of the target groups.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTargetHealth`.
    ///
    /// <p>Describes the health of the specified targets or all of your targets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTargetHealth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_target_health_input::Builder,
    }
    impl<C, M, R> DescribeTargetHealth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTargetHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTargetHealthOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTargetHealthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTargetHealthInputOperationOutputAlias,
                crate::output::DescribeTargetHealthOutput,
                crate::error::DescribeTargetHealthError,
                crate::input::DescribeTargetHealthInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets.</p>
        pub fn targets(mut self, input: crate::model::TargetDescription) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>The targets.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyListener`.
    ///
    /// <p>Replaces the specified properties of the specified listener. Any properties that you do not specify remain unchanged.</p>
    /// <p>Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy and default certificate properties.</p>
    /// <p>To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyListener<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_listener_input::Builder,
    }
    impl<C, M, R> ModifyListener<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyListenerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyListenerInputOperationOutputAlias,
                crate::output::ModifyListenerOutput,
                crate::error::ModifyListenerError,
                crate::input::ModifyListenerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// <p>The port for connections from clients to the load balancer. You cannot specify a port for a Gateway Load Balancer.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port for connections from clients to the load balancer. You cannot specify a port for a Gateway Load Balancer.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The protocol for connections from clients to the load balancer. Application Load Balancers support the HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You can’t change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>
        pub fn protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.inner = self.inner.protocol(input);
            self
        }
        /// <p>The protocol for connections from clients to the load balancer. Application Load Balancers support the HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You can’t change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn ssl_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssl_policy(input.into());
            self
        }
        /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn set_ssl_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ssl_policy(input);
            self
        }
        /// Appends an item to `Certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn certificates(mut self, input: crate::model::Certificate) -> Self {
            self.inner = self.inner.certificates(input);
            self
        }
        /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.inner = self.inner.set_certificates(input);
            self
        }
        /// Appends an item to `DefaultActions`.
        ///
        /// To override the contents of this collection use [`set_default_actions`](Self::set_default_actions).
        ///
        /// <p>The actions for the default rule.</p>
        pub fn default_actions(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.default_actions(input);
            self
        }
        /// <p>The actions for the default rule.</p>
        pub fn set_default_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.inner = self.inner.set_default_actions(input);
            self
        }
        /// Appends an item to `AlpnPolicy`.
        ///
        /// To override the contents of this collection use [`set_alpn_policy`](Self::set_alpn_policy).
        ///
        /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:</p>
        /// <ul>
        /// <li> <p> <code>HTTP1Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Optional</code> </p> </li>
        /// <li> <p> <code>HTTP2Preferred</code> </p> </li>
        /// <li> <p> <code>None</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn alpn_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alpn_policy(input.into());
            self
        }
        /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:</p>
        /// <ul>
        /// <li> <p> <code>HTTP1Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Optional</code> </p> </li>
        /// <li> <p> <code>HTTP2Preferred</code> </p> </li>
        /// <li> <p> <code>None</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn set_alpn_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_alpn_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyLoadBalancerAttributes`.
    ///
    /// <p>Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.</p>
    /// <p>If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that you do not modify retain their current values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyLoadBalancerAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_load_balancer_attributes_input::Builder,
    }
    impl<C, M, R> ModifyLoadBalancerAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyLoadBalancerAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyLoadBalancerAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyLoadBalancerAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyLoadBalancerAttributesInputOperationOutputAlias,
                crate::output::ModifyLoadBalancerAttributesOutput,
                crate::error::ModifyLoadBalancerAttributesError,
                crate::input::ModifyLoadBalancerAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// Appends an item to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The load balancer attributes.</p>
        pub fn attributes(mut self, input: crate::model::LoadBalancerAttribute) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// <p>The load balancer attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancerAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyRule`.
    ///
    /// <p>Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.</p>
    /// <p>To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_rule_input::Builder,
    }
    impl<C, M, R> ModifyRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyRuleInputOperationOutputAlias,
                crate::output::ModifyRuleOutput,
                crate::error::ModifyRuleError,
                crate::input::ModifyRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_arn(input);
            self
        }
        /// Appends an item to `Conditions`.
        ///
        /// To override the contents of this collection use [`set_conditions`](Self::set_conditions).
        ///
        /// <p>The conditions.</p>
        pub fn conditions(mut self, input: crate::model::RuleCondition) -> Self {
            self.inner = self.inner.conditions(input);
            self
        }
        /// <p>The conditions.</p>
        pub fn set_conditions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleCondition>>,
        ) -> Self {
            self.inner = self.inner.set_conditions(input);
            self
        }
        /// Appends an item to `Actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions.</p>
        pub fn actions(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.actions(input);
            self
        }
        /// <p>The actions.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyTargetGroup`.
    ///
    /// <p>Modifies the health checks used when evaluating the health state of the targets in the specified target group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyTargetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_target_group_input::Builder,
    }
    impl<C, M, R> ModifyTargetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyTargetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyTargetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyTargetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyTargetGroupInputOperationOutputAlias,
                crate::output::ModifyTargetGroupOutput,
                crate::error::ModifyTargetGroupError,
                crate::input::ModifyTargetGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
        /// <p>The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. It is supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn health_check_protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.inner = self.inner.health_check_protocol(input);
            self
        }
        /// <p>The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. It is supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn set_health_check_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.inner = self.inner.set_health_check_protocol(input);
            self
        }
        /// <p>The port the load balancer uses when performing health checks on targets.</p>
        pub fn health_check_port(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_port(input.into());
            self
        }
        /// <p>The port the load balancer uses when performing health checks on targets.</p>
        pub fn set_health_check_port(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_port(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
        /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
        /// <p>[GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
        pub fn health_check_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_path(input.into());
            self
        }
        /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
        /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
        /// <p>[GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_path(input);
            self
        }
        /// <p>Indicates whether health checks are enabled.</p>
        pub fn health_check_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.health_check_enabled(input);
            self
        }
        /// <p>Indicates whether health checks are enabled.</p>
        pub fn set_health_check_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_health_check_enabled(input);
            self
        }
        /// <p>The approximate amount of time, in seconds, between health checks of an individual target. For TCP health checks, the supported values are 10 or 30 seconds.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn health_check_interval_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_interval_seconds(input);
            self
        }
        /// <p>The approximate amount of time, in seconds, between health checks of an individual target. For TCP health checks, the supported values are 10 or 30 seconds.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn set_health_check_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_health_check_interval_seconds(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means a failed health check.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn health_check_timeout_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_timeout_seconds(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means a failed health check.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn set_health_check_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_health_check_timeout_seconds(input);
            self
        }
        /// <p>The number of consecutive health checks successes required before considering an unhealthy target healthy.</p>
        pub fn healthy_threshold_count(mut self, input: i32) -> Self {
            self.inner = self.inner.healthy_threshold_count(input);
            self
        }
        /// <p>The number of consecutive health checks successes required before considering an unhealthy target healthy.</p>
        pub fn set_healthy_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_healthy_threshold_count(input);
            self
        }
        /// <p>The number of consecutive health check failures required before considering the target unhealthy. For target groups with a protocol of TCP or TLS, this value must be the same as the healthy threshold count.</p>
        pub fn unhealthy_threshold_count(mut self, input: i32) -> Self {
            self.inner = self.inner.unhealthy_threshold_count(input);
            self
        }
        /// <p>The number of consecutive health check failures required before considering the target unhealthy. For target groups with a protocol of TCP or TLS, this value must be the same as the healthy threshold count.</p>
        pub fn set_unhealthy_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_unhealthy_threshold_count(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn matcher(mut self, input: crate::model::Matcher) -> Self {
            self.inner = self.inner.matcher(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn set_matcher(mut self, input: std::option::Option<crate::model::Matcher>) -> Self {
            self.inner = self.inner.set_matcher(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyTargetGroupAttributes`.
    ///
    /// <p>Modifies the specified attributes of the specified target group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyTargetGroupAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_target_group_attributes_input::Builder,
    }
    impl<C, M, R> ModifyTargetGroupAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyTargetGroupAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyTargetGroupAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyTargetGroupAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyTargetGroupAttributesInputOperationOutputAlias,
                crate::output::ModifyTargetGroupAttributesOutput,
                crate::error::ModifyTargetGroupAttributesError,
                crate::input::ModifyTargetGroupAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
        /// Appends an item to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes.</p>
        pub fn attributes(mut self, input: crate::model::TargetGroupAttribute) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// <p>The attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetGroupAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterTargets`.
    ///
    /// <p>Registers the specified targets with the specified target group.</p>
    /// <p>If the target is an EC2 instance, it must be in the <code>running</code> state when you register it.</p>
    /// <p>By default, the load balancer routes requests to registered targets using the protocol and port for the target group. Alternatively, you can override the port for a target when you register it. You can register each EC2 instance or IP address with the same target group multiple times using different ports.</p>
    /// <p>With a Network Load Balancer, you cannot register instances by instance ID if they have the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1. You can register instances of these types by IP address.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_targets_input::Builder,
    }
    impl<C, M, R> RegisterTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterTargetsInputOperationOutputAlias,
                crate::output::RegisterTargetsOutput,
                crate::error::RegisterTargetsError,
                crate::input::RegisterTargetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets.</p>
        pub fn targets(mut self, input: crate::model::TargetDescription) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>The targets.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveListenerCertificates`.
    ///
    /// <p>Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveListenerCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_listener_certificates_input::Builder,
    }
    impl<C, M, R> RemoveListenerCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveListenerCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveListenerCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveListenerCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveListenerCertificatesInputOperationOutputAlias,
                crate::output::RemoveListenerCertificatesOutput,
                crate::error::RemoveListenerCertificatesError,
                crate::input::RemoveListenerCertificatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// Appends an item to `Certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>The certificate to remove. You can specify one certificate per call. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn certificates(mut self, input: crate::model::Certificate) -> Self {
            self.inner = self.inner.certificates(input);
            self
        }
        /// <p>The certificate to remove. You can specify one certificate per call. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.inner = self.inner.set_certificates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTags`.
    ///
    /// <p>Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_input::Builder,
    }
    impl<C, M, R> RemoveTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsInputOperationOutputAlias,
                crate::output::RemoveTagsOutput,
                crate::error::RemoveTagsError,
                crate::input::RemoveTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys for the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys for the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIpAddressType`.
    ///
    /// <p>Sets the type of IP addresses used by the subnets of the specified Application Load Balancer or Network Load Balancer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetIpAddressType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_ip_address_type_input::Builder,
    }
    impl<C, M, R> SetIpAddressType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetIpAddressType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIpAddressTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::SetIpAddressTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetIpAddressTypeInputOperationOutputAlias,
                crate::output::SetIpAddressTypeOutput,
                crate::error::SetIpAddressTypeError,
                crate::input::SetIpAddressTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// <p>The IP address type. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(input);
            self
        }
        /// <p>The IP address type. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetRulePriorities`.
    ///
    /// <p>Sets the priorities of the specified rules.</p>
    /// <p>You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that you do not specify retain their current priority.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetRulePriorities<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_rule_priorities_input::Builder,
    }
    impl<C, M, R> SetRulePriorities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetRulePriorities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetRulePrioritiesOutput,
            aws_smithy_http::result::SdkError<crate::error::SetRulePrioritiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetRulePrioritiesInputOperationOutputAlias,
                crate::output::SetRulePrioritiesOutput,
                crate::error::SetRulePrioritiesError,
                crate::input::SetRulePrioritiesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `RulePriorities`.
        ///
        /// To override the contents of this collection use [`set_rule_priorities`](Self::set_rule_priorities).
        ///
        /// <p>The rule priorities.</p>
        pub fn rule_priorities(mut self, input: crate::model::RulePriorityPair) -> Self {
            self.inner = self.inner.rule_priorities(input);
            self
        }
        /// <p>The rule priorities.</p>
        pub fn set_rule_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RulePriorityPair>>,
        ) -> Self {
            self.inner = self.inner.set_rule_priorities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetSecurityGroups`.
    ///
    /// <p>Associates the specified security groups with the specified Application Load Balancer. The specified security groups override the previously associated security groups.</p>
    /// <p>You can't specify a security group for a Network Load Balancer or Gateway Load Balancer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetSecurityGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_security_groups_input::Builder,
    }
    impl<C, M, R> SetSecurityGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetSecurityGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetSecurityGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::SetSecurityGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetSecurityGroupsInputOperationOutputAlias,
                crate::output::SetSecurityGroupsOutput,
                crate::error::SetSecurityGroupsError,
                crate::input::SetSecurityGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The IDs of the security groups.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(input.into());
            self
        }
        /// <p>The IDs of the security groups.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetSubnets`.
    ///
    /// <p>Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer or Network Load Balancer. The specified subnets replace the previously enabled subnets.</p>
    /// <p>When you specify subnets for a Network Load Balancer, you must include all subnets that were enabled previously, with their existing configurations, plus any additional subnets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetSubnets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_subnets_input::Builder,
    }
    impl<C, M, R> SetSubnets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetSubnets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetSubnetsOutput,
            aws_smithy_http::result::SdkError<crate::error::SetSubnetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetSubnetsInputOperationOutputAlias,
                crate::output::SetSubnetsOutput,
                crate::error::SetSubnetsError,
                crate::input::SetSubnetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// Appends an item to `Subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnets(input.into());
            self
        }
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnets(input);
            self
        }
        /// Appends an item to `SubnetMappings`.
        ///
        /// To override the contents of this collection use [`set_subnet_mappings`](Self::set_subnet_mappings).
        ///
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.</p>
        pub fn subnet_mappings(mut self, input: crate::model::SubnetMapping) -> Self {
            self.inner = self.inner.subnet_mappings(input);
            self
        }
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.</p>
        pub fn set_subnet_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_mappings(input);
            self
        }
        /// <p>[Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener. .</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(input);
            self
        }
        /// <p>[Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener. .</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
