// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Elastic Load Balancing
///
/// Client for invoking operations on Elastic Load Balancing. Each operation on Elastic Load Balancing is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_elasticloadbalancingv2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_elasticloadbalancingv2::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_elasticloadbalancingv2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddListenerCertificates`](crate::client::fluent_builders::AddListenerCertificates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::AddListenerCertificates::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::AddListenerCertificates::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener.</p>
    ///   - [`certificates(Vec<Certificate>)`](crate::client::fluent_builders::AddListenerCertificates::certificates) / [`set_certificates(Option<Vec<Certificate>>)`](crate::client::fluent_builders::AddListenerCertificates::set_certificates): <p>The certificate to add. You can specify one certificate per call. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
    /// - On success, responds with [`AddListenerCertificatesOutput`](crate::output::AddListenerCertificatesOutput) with field(s):
    ///   - [`certificates(Option<Vec<Certificate>>)`](crate::output::AddListenerCertificatesOutput::certificates): <p>Information about the certificates in the certificate list.</p>
    /// - On failure, responds with [`SdkError<AddListenerCertificatesError>`](crate::error::AddListenerCertificatesError)
    pub fn add_listener_certificates(&self) -> fluent_builders::AddListenerCertificates {
        fluent_builders::AddListenerCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddTags`](crate::client::fluent_builders::AddTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::AddTags::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::AddTags::set_resource_arns): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AddTags::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTags::set_tags): <p>The tags.</p>
    /// - On success, responds with [`AddTagsOutput`](crate::output::AddTagsOutput)

    /// - On failure, responds with [`SdkError<AddTagsError>`](crate::error::AddTagsError)
    pub fn add_tags(&self) -> fluent_builders::AddTags {
        fluent_builders::AddTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateListener`](crate::client::fluent_builders::CreateListener) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`load_balancer_arn(impl Into<String>)`](crate::client::fluent_builders::CreateListener::load_balancer_arn) / [`set_load_balancer_arn(Option<String>)`](crate::client::fluent_builders::CreateListener::set_load_balancer_arn): <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    ///   - [`protocol(ProtocolEnum)`](crate::client::fluent_builders::CreateListener::protocol) / [`set_protocol(Option<ProtocolEnum>)`](crate::client::fluent_builders::CreateListener::set_protocol): <p>The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::CreateListener::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::CreateListener::set_port): <p>The port on which the load balancer is listening. You cannot specify a port for a Gateway Load Balancer.</p>
    ///   - [`ssl_policy(impl Into<String>)`](crate::client::fluent_builders::CreateListener::ssl_policy) / [`set_ssl_policy(Option<String>)`](crate::client::fluent_builders::CreateListener::set_ssl_policy): <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> and <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
    ///   - [`certificates(Vec<Certificate>)`](crate::client::fluent_builders::CreateListener::certificates) / [`set_certificates(Option<Vec<Certificate>>)`](crate::client::fluent_builders::CreateListener::set_certificates): <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
    ///   - [`default_actions(Vec<Action>)`](crate::client::fluent_builders::CreateListener::default_actions) / [`set_default_actions(Option<Vec<Action>>)`](crate::client::fluent_builders::CreateListener::set_default_actions): <p>The actions for the default rule.</p>
    ///   - [`alpn_policy(Vec<String>)`](crate::client::fluent_builders::CreateListener::alpn_policy) / [`set_alpn_policy(Option<Vec<String>>)`](crate::client::fluent_builders::CreateListener::set_alpn_policy): <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:</p>  <ul>   <li> <p> <code>HTTP1Only</code> </p> </li>   <li> <p> <code>HTTP2Only</code> </p> </li>   <li> <p> <code>HTTP2Optional</code> </p> </li>   <li> <p> <code>HTTP2Preferred</code> </p> </li>   <li> <p> <code>None</code> </p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN policies</a> in the <i>Network Load Balancers Guide</i>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateListener::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateListener::set_tags): <p>The tags to assign to the listener.</p>
    /// - On success, responds with [`CreateListenerOutput`](crate::output::CreateListenerOutput) with field(s):
    ///   - [`listeners(Option<Vec<Listener>>)`](crate::output::CreateListenerOutput::listeners): <p>Information about the listener.</p>
    /// - On failure, responds with [`SdkError<CreateListenerError>`](crate::error::CreateListenerError)
    pub fn create_listener(&self) -> fluent_builders::CreateListener {
        fluent_builders::CreateListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLoadBalancer`](crate::client::fluent_builders::CreateLoadBalancer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateLoadBalancer::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateLoadBalancer::set_name): <p>The name of the load balancer.</p>  <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".</p>
    ///   - [`subnets(Vec<String>)`](crate::client::fluent_builders::CreateLoadBalancer::subnets) / [`set_subnets(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLoadBalancer::set_subnets): <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>  <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones.</p>  <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>  <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>  <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones.</p>  <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones.</p>
    ///   - [`subnet_mappings(Vec<SubnetMapping>)`](crate::client::fluent_builders::CreateLoadBalancer::subnet_mappings) / [`set_subnet_mappings(Option<Vec<SubnetMapping>>)`](crate::client::fluent_builders::CreateLoadBalancer::set_subnet_mappings): <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>  <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>  <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>  <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>  <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.</p>  <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>
    ///   - [`security_groups(Vec<String>)`](crate::client::fluent_builders::CreateLoadBalancer::security_groups) / [`set_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLoadBalancer::set_security_groups): <p>[Application Load Balancers] The IDs of the security groups for the load balancer.</p>
    ///   - [`scheme(LoadBalancerSchemeEnum)`](crate::client::fluent_builders::CreateLoadBalancer::scheme) / [`set_scheme(Option<LoadBalancerSchemeEnum>)`](crate::client::fluent_builders::CreateLoadBalancer::set_scheme): <p>The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.</p>  <p>The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.</p>  <p>The default is an Internet-facing load balancer.</p>  <p>You cannot specify a scheme for a Gateway Load Balancer.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateLoadBalancer::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateLoadBalancer::set_tags): <p>The tags to assign to the load balancer.</p>
    ///   - [`r#type(LoadBalancerTypeEnum)`](crate::client::fluent_builders::CreateLoadBalancer::type) / [`set_type(Option<LoadBalancerTypeEnum>)`](crate::client::fluent_builders::CreateLoadBalancer::set_type): <p>The type of load balancer. The default is <code>application</code>.</p>
    ///   - [`ip_address_type(IpAddressType)`](crate::client::fluent_builders::CreateLoadBalancer::ip_address_type) / [`set_ip_address_type(Option<IpAddressType>)`](crate::client::fluent_builders::CreateLoadBalancer::set_ip_address_type): <p>The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). </p>
    ///   - [`customer_owned_ipv4_pool(impl Into<String>)`](crate::client::fluent_builders::CreateLoadBalancer::customer_owned_ipv4_pool) / [`set_customer_owned_ipv4_pool(Option<String>)`](crate::client::fluent_builders::CreateLoadBalancer::set_customer_owned_ipv4_pool): <p>[Application Load Balancers on Outposts] The ID of the customer-owned address pool (CoIP pool).</p>
    /// - On success, responds with [`CreateLoadBalancerOutput`](crate::output::CreateLoadBalancerOutput) with field(s):
    ///   - [`load_balancers(Option<Vec<LoadBalancer>>)`](crate::output::CreateLoadBalancerOutput::load_balancers): <p>Information about the load balancer.</p>
    /// - On failure, responds with [`SdkError<CreateLoadBalancerError>`](crate::error::CreateLoadBalancerError)
    pub fn create_load_balancer(&self) -> fluent_builders::CreateLoadBalancer {
        fluent_builders::CreateLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRule`](crate::client::fluent_builders::CreateRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::CreateRule::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::CreateRule::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener.</p>
    ///   - [`conditions(Vec<RuleCondition>)`](crate::client::fluent_builders::CreateRule::conditions) / [`set_conditions(Option<Vec<RuleCondition>>)`](crate::client::fluent_builders::CreateRule::set_conditions): <p>The conditions.</p>
    ///   - [`priority(i32)`](crate::client::fluent_builders::CreateRule::priority) / [`set_priority(Option<i32>)`](crate::client::fluent_builders::CreateRule::set_priority): <p>The rule priority. A listener can't have multiple rules with the same priority.</p>
    ///   - [`actions(Vec<Action>)`](crate::client::fluent_builders::CreateRule::actions) / [`set_actions(Option<Vec<Action>>)`](crate::client::fluent_builders::CreateRule::set_actions): <p>The actions.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateRule::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateRule::set_tags): <p>The tags to assign to the rule.</p>
    /// - On success, responds with [`CreateRuleOutput`](crate::output::CreateRuleOutput) with field(s):
    ///   - [`rules(Option<Vec<Rule>>)`](crate::output::CreateRuleOutput::rules): <p>Information about the rule.</p>
    /// - On failure, responds with [`SdkError<CreateRuleError>`](crate::error::CreateRuleError)
    pub fn create_rule(&self) -> fluent_builders::CreateRule {
        fluent_builders::CreateRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTargetGroup`](crate::client::fluent_builders::CreateTargetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateTargetGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateTargetGroup::set_name): <p>The name of the target group.</p>  <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.</p>
    ///   - [`protocol(ProtocolEnum)`](crate::client::fluent_builders::CreateTargetGroup::protocol) / [`set_protocol(Option<ProtocolEnum>)`](crate::client::fluent_builders::CreateTargetGroup::set_protocol): <p>The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.</p>
    ///   - [`protocol_version(impl Into<String>)`](crate::client::fluent_builders::CreateTargetGroup::protocol_version) / [`set_protocol_version(Option<String>)`](crate::client::fluent_builders::CreateTargetGroup::set_protocol_version): <p>[HTTP/HTTPS protocol] The protocol version. Specify <code>GRPC</code> to send requests to targets using gRPC. Specify <code>HTTP2</code> to send requests to targets using HTTP/2. The default is <code>HTTP1</code>, which sends requests to targets using HTTP/1.1.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::CreateTargetGroup::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::CreateTargetGroup::set_port): <p>The port on which the targets receive traffic. This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateTargetGroup::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateTargetGroup::set_vpc_id): <p>The identifier of the virtual private cloud (VPC). If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required.</p>
    ///   - [`health_check_protocol(ProtocolEnum)`](crate::client::fluent_builders::CreateTargetGroup::health_check_protocol) / [`set_health_check_protocol(Option<ProtocolEnum>)`](crate::client::fluent_builders::CreateTargetGroup::set_health_check_protocol): <p>The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>
    ///   - [`health_check_port(impl Into<String>)`](crate::client::fluent_builders::CreateTargetGroup::health_check_port) / [`set_health_check_port(Option<String>)`](crate::client::fluent_builders::CreateTargetGroup::set_health_check_port): <p>The port the load balancer uses when performing health checks on targets. If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code>, which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.</p>
    ///   - [`health_check_enabled(bool)`](crate::client::fluent_builders::CreateTargetGroup::health_check_enabled) / [`set_health_check_enabled(Option<bool>)`](crate::client::fluent_builders::CreateTargetGroup::set_health_check_enabled): <p>Indicates whether health checks are enabled. If the target type is <code>lambda</code>, health checks are disabled by default but can be enabled. If the target type is <code>instance</code>, <code>ip</code>, or <code>alb</code>, health checks are always enabled and cannot be disabled.</p>
    ///   - [`health_check_path(impl Into<String>)`](crate::client::fluent_builders::CreateTargetGroup::health_check_path) / [`set_health_check_path(Option<String>)`](crate::client::fluent_builders::CreateTargetGroup::set_health_check_path): <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>  <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>  <p>[GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
    ///   - [`health_check_interval_seconds(i32)`](crate::client::fluent_builders::CreateTargetGroup::health_check_interval_seconds) / [`set_health_check_interval_seconds(Option<i32>)`](crate::client::fluent_builders::CreateTargetGroup::set_health_check_interval_seconds): <p>The approximate amount of time, in seconds, between health checks of an individual target. If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30 seconds. If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is <code>lambda</code>, the default is 35 seconds.</p>
    ///   - [`health_check_timeout_seconds(i32)`](crate::client::fluent_builders::CreateTargetGroup::health_check_timeout_seconds) / [`set_health_check_timeout_seconds(Option<i32>)`](crate::client::fluent_builders::CreateTargetGroup::set_health_check_timeout_seconds): <p>The amount of time, in seconds, during which no response from a target means a failed health check. For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is <code>lambda</code>, the default is 30 seconds.</p>
    ///   - [`healthy_threshold_count(i32)`](crate::client::fluent_builders::CreateTargetGroup::healthy_threshold_count) / [`set_healthy_threshold_count(Option<i32>)`](crate::client::fluent_builders::CreateTargetGroup::set_healthy_threshold_count): <p>The number of consecutive health checks successes required before considering an unhealthy target healthy. For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is <code>lambda</code>, the default is 5.</p>
    ///   - [`unhealthy_threshold_count(i32)`](crate::client::fluent_builders::CreateTargetGroup::unhealthy_threshold_count) / [`set_unhealthy_threshold_count(Option<i32>)`](crate::client::fluent_builders::CreateTargetGroup::set_unhealthy_threshold_count): <p>The number of consecutive health check failures required before considering a target unhealthy. If the target group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If the target group protocol is GENEVE, the default is 3. If the target type is <code>lambda</code>, the default is 2.</p>
    ///   - [`matcher(Matcher)`](crate::client::fluent_builders::CreateTargetGroup::matcher) / [`set_matcher(Option<Matcher>)`](crate::client::fluent_builders::CreateTargetGroup::set_matcher): <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.</p>
    ///   - [`target_type(TargetTypeEnum)`](crate::client::fluent_builders::CreateTargetGroup::target_type) / [`set_target_type(Option<TargetTypeEnum>)`](crate::client::fluent_builders::CreateTargetGroup::set_target_type): <p>The type of target that you must specify when registering targets with this target group. You can't specify targets for a target group using more than one target type.</p>  <ul>   <li> <p> <code>instance</code> - Register targets by instance ID. This is the default value.</p> </li>   <li> <p> <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.</p> </li>   <li> <p> <code>lambda</code> - Register a single Lambda function as a target.</p> </li>   <li> <p> <code>alb</code> - Register a single Application Load Balancer as a target.</p> </li>  </ul>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTargetGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTargetGroup::set_tags): <p>The tags to assign to the target group.</p>
    ///   - [`ip_address_type(TargetGroupIpAddressTypeEnum)`](crate::client::fluent_builders::CreateTargetGroup::ip_address_type) / [`set_ip_address_type(Option<TargetGroupIpAddressTypeEnum>)`](crate::client::fluent_builders::CreateTargetGroup::set_ip_address_type): <p>The type of IP address used for this target group. The possible values are <code>ipv4</code> and <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code>.</p>
    /// - On success, responds with [`CreateTargetGroupOutput`](crate::output::CreateTargetGroupOutput) with field(s):
    ///   - [`target_groups(Option<Vec<TargetGroup>>)`](crate::output::CreateTargetGroupOutput::target_groups): <p>Information about the target group.</p>
    /// - On failure, responds with [`SdkError<CreateTargetGroupError>`](crate::error::CreateTargetGroupError)
    pub fn create_target_group(&self) -> fluent_builders::CreateTargetGroup {
        fluent_builders::CreateTargetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteListener`](crate::client::fluent_builders::DeleteListener) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteListener::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::DeleteListener::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener.</p>
    /// - On success, responds with [`DeleteListenerOutput`](crate::output::DeleteListenerOutput)

    /// - On failure, responds with [`SdkError<DeleteListenerError>`](crate::error::DeleteListenerError)
    pub fn delete_listener(&self) -> fluent_builders::DeleteListener {
        fluent_builders::DeleteListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLoadBalancer`](crate::client::fluent_builders::DeleteLoadBalancer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`load_balancer_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteLoadBalancer::load_balancer_arn) / [`set_load_balancer_arn(Option<String>)`](crate::client::fluent_builders::DeleteLoadBalancer::set_load_balancer_arn): <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    /// - On success, responds with [`DeleteLoadBalancerOutput`](crate::output::DeleteLoadBalancerOutput)

    /// - On failure, responds with [`SdkError<DeleteLoadBalancerError>`](crate::error::DeleteLoadBalancerError)
    pub fn delete_load_balancer(&self) -> fluent_builders::DeleteLoadBalancer {
        fluent_builders::DeleteLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRule`](crate::client::fluent_builders::DeleteRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteRule::rule_arn) / [`set_rule_arn(Option<String>)`](crate::client::fluent_builders::DeleteRule::set_rule_arn): <p>The Amazon Resource Name (ARN) of the rule.</p>
    /// - On success, responds with [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)

    /// - On failure, responds with [`SdkError<DeleteRuleError>`](crate::error::DeleteRuleError)
    pub fn delete_rule(&self) -> fluent_builders::DeleteRule {
        fluent_builders::DeleteRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTargetGroup`](crate::client::fluent_builders::DeleteTargetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_group_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteTargetGroup::target_group_arn) / [`set_target_group_arn(Option<String>)`](crate::client::fluent_builders::DeleteTargetGroup::set_target_group_arn): <p>The Amazon Resource Name (ARN) of the target group.</p>
    /// - On success, responds with [`DeleteTargetGroupOutput`](crate::output::DeleteTargetGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteTargetGroupError>`](crate::error::DeleteTargetGroupError)
    pub fn delete_target_group(&self) -> fluent_builders::DeleteTargetGroup {
        fluent_builders::DeleteTargetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterTargets`](crate::client::fluent_builders::DeregisterTargets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_group_arn(impl Into<String>)`](crate::client::fluent_builders::DeregisterTargets::target_group_arn) / [`set_target_group_arn(Option<String>)`](crate::client::fluent_builders::DeregisterTargets::set_target_group_arn): <p>The Amazon Resource Name (ARN) of the target group.</p>
    ///   - [`targets(Vec<TargetDescription>)`](crate::client::fluent_builders::DeregisterTargets::targets) / [`set_targets(Option<Vec<TargetDescription>>)`](crate::client::fluent_builders::DeregisterTargets::set_targets): <p>The targets. If you specified a port override when you registered a target, you must specify both the target ID and the port when you deregister it.</p>
    /// - On success, responds with [`DeregisterTargetsOutput`](crate::output::DeregisterTargetsOutput)

    /// - On failure, responds with [`SdkError<DeregisterTargetsError>`](crate::error::DeregisterTargetsError)
    pub fn deregister_targets(&self) -> fluent_builders::DeregisterTargets {
        fluent_builders::DeregisterTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountLimits`](crate::client::fluent_builders::DescribeAccountLimits) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeAccountLimits::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeAccountLimits::set_marker): <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::DescribeAccountLimits::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::DescribeAccountLimits::set_page_size): <p>The maximum number of results to return with this call.</p>
    /// - On success, responds with [`DescribeAccountLimitsOutput`](crate::output::DescribeAccountLimitsOutput) with field(s):
    ///   - [`limits(Option<Vec<Limit>>)`](crate::output::DescribeAccountLimitsOutput::limits): <p>Information about the limits.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::DescribeAccountLimitsOutput::next_marker): <p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountLimitsError>`](crate::error::DescribeAccountLimitsError)
    pub fn describe_account_limits(&self) -> fluent_builders::DescribeAccountLimits {
        fluent_builders::DescribeAccountLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeListenerCertificates`](crate::client::fluent_builders::DescribeListenerCertificates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeListenerCertificates::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::DescribeListenerCertificates::set_listener_arn): <p>The Amazon Resource Names (ARN) of the listener.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeListenerCertificates::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeListenerCertificates::set_marker): <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::DescribeListenerCertificates::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::DescribeListenerCertificates::set_page_size): <p>The maximum number of results to return with this call.</p>
    /// - On success, responds with [`DescribeListenerCertificatesOutput`](crate::output::DescribeListenerCertificatesOutput) with field(s):
    ///   - [`certificates(Option<Vec<Certificate>>)`](crate::output::DescribeListenerCertificatesOutput::certificates): <p>Information about the certificates.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::DescribeListenerCertificatesOutput::next_marker): <p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>
    /// - On failure, responds with [`SdkError<DescribeListenerCertificatesError>`](crate::error::DescribeListenerCertificatesError)
    pub fn describe_listener_certificates(&self) -> fluent_builders::DescribeListenerCertificates {
        fluent_builders::DescribeListenerCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeListeners`](crate::client::fluent_builders::DescribeListeners) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeListeners::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`load_balancer_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeListeners::load_balancer_arn) / [`set_load_balancer_arn(Option<String>)`](crate::client::fluent_builders::DescribeListeners::set_load_balancer_arn): <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    ///   - [`listener_arns(Vec<String>)`](crate::client::fluent_builders::DescribeListeners::listener_arns) / [`set_listener_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeListeners::set_listener_arns): <p>The Amazon Resource Names (ARN) of the listeners.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeListeners::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeListeners::set_marker): <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::DescribeListeners::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::DescribeListeners::set_page_size): <p>The maximum number of results to return with this call.</p>
    /// - On success, responds with [`DescribeListenersOutput`](crate::output::DescribeListenersOutput) with field(s):
    ///   - [`listeners(Option<Vec<Listener>>)`](crate::output::DescribeListenersOutput::listeners): <p>Information about the listeners.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::DescribeListenersOutput::next_marker): <p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>
    /// - On failure, responds with [`SdkError<DescribeListenersError>`](crate::error::DescribeListenersError)
    pub fn describe_listeners(&self) -> fluent_builders::DescribeListeners {
        fluent_builders::DescribeListeners::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLoadBalancerAttributes`](crate::client::fluent_builders::DescribeLoadBalancerAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`load_balancer_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeLoadBalancerAttributes::load_balancer_arn) / [`set_load_balancer_arn(Option<String>)`](crate::client::fluent_builders::DescribeLoadBalancerAttributes::set_load_balancer_arn): <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    /// - On success, responds with [`DescribeLoadBalancerAttributesOutput`](crate::output::DescribeLoadBalancerAttributesOutput) with field(s):
    ///   - [`attributes(Option<Vec<LoadBalancerAttribute>>)`](crate::output::DescribeLoadBalancerAttributesOutput::attributes): <p>Information about the load balancer attributes.</p>
    /// - On failure, responds with [`SdkError<DescribeLoadBalancerAttributesError>`](crate::error::DescribeLoadBalancerAttributesError)
    pub fn describe_load_balancer_attributes(
        &self,
    ) -> fluent_builders::DescribeLoadBalancerAttributes {
        fluent_builders::DescribeLoadBalancerAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLoadBalancers`](crate::client::fluent_builders::DescribeLoadBalancers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeLoadBalancers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`load_balancer_arns(Vec<String>)`](crate::client::fluent_builders::DescribeLoadBalancers::load_balancer_arns) / [`set_load_balancer_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeLoadBalancers::set_load_balancer_arns): <p>The Amazon Resource Names (ARN) of the load balancers. You can specify up to 20 load balancers in a single call.</p>
    ///   - [`names(Vec<String>)`](crate::client::fluent_builders::DescribeLoadBalancers::names) / [`set_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeLoadBalancers::set_names): <p>The names of the load balancers.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeLoadBalancers::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeLoadBalancers::set_marker): <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::DescribeLoadBalancers::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::DescribeLoadBalancers::set_page_size): <p>The maximum number of results to return with this call.</p>
    /// - On success, responds with [`DescribeLoadBalancersOutput`](crate::output::DescribeLoadBalancersOutput) with field(s):
    ///   - [`load_balancers(Option<Vec<LoadBalancer>>)`](crate::output::DescribeLoadBalancersOutput::load_balancers): <p>Information about the load balancers.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::DescribeLoadBalancersOutput::next_marker): <p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>
    /// - On failure, responds with [`SdkError<DescribeLoadBalancersError>`](crate::error::DescribeLoadBalancersError)
    pub fn describe_load_balancers(&self) -> fluent_builders::DescribeLoadBalancers {
        fluent_builders::DescribeLoadBalancers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRules`](crate::client::fluent_builders::DescribeRules) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeRules::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::DescribeRules::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener.</p>
    ///   - [`rule_arns(Vec<String>)`](crate::client::fluent_builders::DescribeRules::rule_arns) / [`set_rule_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeRules::set_rule_arns): <p>The Amazon Resource Names (ARN) of the rules.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeRules::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeRules::set_marker): <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::DescribeRules::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::DescribeRules::set_page_size): <p>The maximum number of results to return with this call.</p>
    /// - On success, responds with [`DescribeRulesOutput`](crate::output::DescribeRulesOutput) with field(s):
    ///   - [`rules(Option<Vec<Rule>>)`](crate::output::DescribeRulesOutput::rules): <p>Information about the rules.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::DescribeRulesOutput::next_marker): <p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>
    /// - On failure, responds with [`SdkError<DescribeRulesError>`](crate::error::DescribeRulesError)
    pub fn describe_rules(&self) -> fluent_builders::DescribeRules {
        fluent_builders::DescribeRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSSLPolicies`](crate::client::fluent_builders::DescribeSSLPolicies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`names(Vec<String>)`](crate::client::fluent_builders::DescribeSSLPolicies::names) / [`set_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSSLPolicies::set_names): <p>The names of the policies.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeSSLPolicies::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeSSLPolicies::set_marker): <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::DescribeSSLPolicies::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::DescribeSSLPolicies::set_page_size): <p>The maximum number of results to return with this call.</p>
    ///   - [`load_balancer_type(LoadBalancerTypeEnum)`](crate::client::fluent_builders::DescribeSSLPolicies::load_balancer_type) / [`set_load_balancer_type(Option<LoadBalancerTypeEnum>)`](crate::client::fluent_builders::DescribeSSLPolicies::set_load_balancer_type): <p> The type of load balancer. The default lists the SSL policies for all load balancers.</p>
    /// - On success, responds with [`DescribeSslPoliciesOutput`](crate::output::DescribeSslPoliciesOutput) with field(s):
    ///   - [`ssl_policies(Option<Vec<SslPolicy>>)`](crate::output::DescribeSslPoliciesOutput::ssl_policies): <p>Information about the security policies.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::DescribeSslPoliciesOutput::next_marker): <p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>
    /// - On failure, responds with [`SdkError<DescribeSSLPoliciesError>`](crate::error::DescribeSSLPoliciesError)
    pub fn describe_ssl_policies(&self) -> fluent_builders::DescribeSSLPolicies {
        fluent_builders::DescribeSSLPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTags`](crate::client::fluent_builders::DescribeTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::DescribeTags::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTags::set_resource_arns): <p>The Amazon Resource Names (ARN) of the resources. You can specify up to 20 resources in a single call.</p>
    /// - On success, responds with [`DescribeTagsOutput`](crate::output::DescribeTagsOutput) with field(s):
    ///   - [`tag_descriptions(Option<Vec<TagDescription>>)`](crate::output::DescribeTagsOutput::tag_descriptions): <p>Information about the tags.</p>
    /// - On failure, responds with [`SdkError<DescribeTagsError>`](crate::error::DescribeTagsError)
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTargetGroupAttributes`](crate::client::fluent_builders::DescribeTargetGroupAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_group_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeTargetGroupAttributes::target_group_arn) / [`set_target_group_arn(Option<String>)`](crate::client::fluent_builders::DescribeTargetGroupAttributes::set_target_group_arn): <p>The Amazon Resource Name (ARN) of the target group.</p>
    /// - On success, responds with [`DescribeTargetGroupAttributesOutput`](crate::output::DescribeTargetGroupAttributesOutput) with field(s):
    ///   - [`attributes(Option<Vec<TargetGroupAttribute>>)`](crate::output::DescribeTargetGroupAttributesOutput::attributes): <p>Information about the target group attributes</p>
    /// - On failure, responds with [`SdkError<DescribeTargetGroupAttributesError>`](crate::error::DescribeTargetGroupAttributesError)
    pub fn describe_target_group_attributes(
        &self,
    ) -> fluent_builders::DescribeTargetGroupAttributes {
        fluent_builders::DescribeTargetGroupAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTargetGroups`](crate::client::fluent_builders::DescribeTargetGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTargetGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`load_balancer_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeTargetGroups::load_balancer_arn) / [`set_load_balancer_arn(Option<String>)`](crate::client::fluent_builders::DescribeTargetGroups::set_load_balancer_arn): <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    ///   - [`target_group_arns(Vec<String>)`](crate::client::fluent_builders::DescribeTargetGroups::target_group_arns) / [`set_target_group_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTargetGroups::set_target_group_arns): <p>The Amazon Resource Names (ARN) of the target groups.</p>
    ///   - [`names(Vec<String>)`](crate::client::fluent_builders::DescribeTargetGroups::names) / [`set_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTargetGroups::set_names): <p>The names of the target groups.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeTargetGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeTargetGroups::set_marker): <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::DescribeTargetGroups::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::DescribeTargetGroups::set_page_size): <p>The maximum number of results to return with this call.</p>
    /// - On success, responds with [`DescribeTargetGroupsOutput`](crate::output::DescribeTargetGroupsOutput) with field(s):
    ///   - [`target_groups(Option<Vec<TargetGroup>>)`](crate::output::DescribeTargetGroupsOutput::target_groups): <p>Information about the target groups.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::DescribeTargetGroupsOutput::next_marker): <p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>
    /// - On failure, responds with [`SdkError<DescribeTargetGroupsError>`](crate::error::DescribeTargetGroupsError)
    pub fn describe_target_groups(&self) -> fluent_builders::DescribeTargetGroups {
        fluent_builders::DescribeTargetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTargetHealth`](crate::client::fluent_builders::DescribeTargetHealth) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_group_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeTargetHealth::target_group_arn) / [`set_target_group_arn(Option<String>)`](crate::client::fluent_builders::DescribeTargetHealth::set_target_group_arn): <p>The Amazon Resource Name (ARN) of the target group.</p>
    ///   - [`targets(Vec<TargetDescription>)`](crate::client::fluent_builders::DescribeTargetHealth::targets) / [`set_targets(Option<Vec<TargetDescription>>)`](crate::client::fluent_builders::DescribeTargetHealth::set_targets): <p>The targets.</p>
    /// - On success, responds with [`DescribeTargetHealthOutput`](crate::output::DescribeTargetHealthOutput) with field(s):
    ///   - [`target_health_descriptions(Option<Vec<TargetHealthDescription>>)`](crate::output::DescribeTargetHealthOutput::target_health_descriptions): <p>Information about the health of the targets.</p>
    /// - On failure, responds with [`SdkError<DescribeTargetHealthError>`](crate::error::DescribeTargetHealthError)
    pub fn describe_target_health(&self) -> fluent_builders::DescribeTargetHealth {
        fluent_builders::DescribeTargetHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyListener`](crate::client::fluent_builders::ModifyListener) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyListener::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::ModifyListener::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::ModifyListener::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::ModifyListener::set_port): <p>The port for connections from clients to the load balancer. You cannot specify a port for a Gateway Load Balancer.</p>
    ///   - [`protocol(ProtocolEnum)`](crate::client::fluent_builders::ModifyListener::protocol) / [`set_protocol(Option<ProtocolEnum>)`](crate::client::fluent_builders::ModifyListener::set_protocol): <p>The protocol for connections from clients to the load balancer. Application Load Balancers support the HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You can’t change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>
    ///   - [`ssl_policy(impl Into<String>)`](crate::client::fluent_builders::ModifyListener::ssl_policy) / [`set_ssl_policy(Option<String>)`](crate::client::fluent_builders::ModifyListener::set_ssl_policy): <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
    ///   - [`certificates(Vec<Certificate>)`](crate::client::fluent_builders::ModifyListener::certificates) / [`set_certificates(Option<Vec<Certificate>>)`](crate::client::fluent_builders::ModifyListener::set_certificates): <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
    ///   - [`default_actions(Vec<Action>)`](crate::client::fluent_builders::ModifyListener::default_actions) / [`set_default_actions(Option<Vec<Action>>)`](crate::client::fluent_builders::ModifyListener::set_default_actions): <p>The actions for the default rule.</p>
    ///   - [`alpn_policy(Vec<String>)`](crate::client::fluent_builders::ModifyListener::alpn_policy) / [`set_alpn_policy(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyListener::set_alpn_policy): <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:</p>  <ul>   <li> <p> <code>HTTP1Only</code> </p> </li>   <li> <p> <code>HTTP2Only</code> </p> </li>   <li> <p> <code>HTTP2Optional</code> </p> </li>   <li> <p> <code>HTTP2Preferred</code> </p> </li>   <li> <p> <code>None</code> </p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN policies</a> in the <i>Network Load Balancers Guide</i>.</p>
    /// - On success, responds with [`ModifyListenerOutput`](crate::output::ModifyListenerOutput) with field(s):
    ///   - [`listeners(Option<Vec<Listener>>)`](crate::output::ModifyListenerOutput::listeners): <p>Information about the modified listener.</p>
    /// - On failure, responds with [`SdkError<ModifyListenerError>`](crate::error::ModifyListenerError)
    pub fn modify_listener(&self) -> fluent_builders::ModifyListener {
        fluent_builders::ModifyListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyLoadBalancerAttributes`](crate::client::fluent_builders::ModifyLoadBalancerAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`load_balancer_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyLoadBalancerAttributes::load_balancer_arn) / [`set_load_balancer_arn(Option<String>)`](crate::client::fluent_builders::ModifyLoadBalancerAttributes::set_load_balancer_arn): <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    ///   - [`attributes(Vec<LoadBalancerAttribute>)`](crate::client::fluent_builders::ModifyLoadBalancerAttributes::attributes) / [`set_attributes(Option<Vec<LoadBalancerAttribute>>)`](crate::client::fluent_builders::ModifyLoadBalancerAttributes::set_attributes): <p>The load balancer attributes.</p>
    /// - On success, responds with [`ModifyLoadBalancerAttributesOutput`](crate::output::ModifyLoadBalancerAttributesOutput) with field(s):
    ///   - [`attributes(Option<Vec<LoadBalancerAttribute>>)`](crate::output::ModifyLoadBalancerAttributesOutput::attributes): <p>Information about the load balancer attributes.</p>
    /// - On failure, responds with [`SdkError<ModifyLoadBalancerAttributesError>`](crate::error::ModifyLoadBalancerAttributesError)
    pub fn modify_load_balancer_attributes(&self) -> fluent_builders::ModifyLoadBalancerAttributes {
        fluent_builders::ModifyLoadBalancerAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyRule`](crate::client::fluent_builders::ModifyRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyRule::rule_arn) / [`set_rule_arn(Option<String>)`](crate::client::fluent_builders::ModifyRule::set_rule_arn): <p>The Amazon Resource Name (ARN) of the rule.</p>
    ///   - [`conditions(Vec<RuleCondition>)`](crate::client::fluent_builders::ModifyRule::conditions) / [`set_conditions(Option<Vec<RuleCondition>>)`](crate::client::fluent_builders::ModifyRule::set_conditions): <p>The conditions.</p>
    ///   - [`actions(Vec<Action>)`](crate::client::fluent_builders::ModifyRule::actions) / [`set_actions(Option<Vec<Action>>)`](crate::client::fluent_builders::ModifyRule::set_actions): <p>The actions.</p>
    /// - On success, responds with [`ModifyRuleOutput`](crate::output::ModifyRuleOutput) with field(s):
    ///   - [`rules(Option<Vec<Rule>>)`](crate::output::ModifyRuleOutput::rules): <p>Information about the modified rule.</p>
    /// - On failure, responds with [`SdkError<ModifyRuleError>`](crate::error::ModifyRuleError)
    pub fn modify_rule(&self) -> fluent_builders::ModifyRule {
        fluent_builders::ModifyRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyTargetGroup`](crate::client::fluent_builders::ModifyTargetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_group_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyTargetGroup::target_group_arn) / [`set_target_group_arn(Option<String>)`](crate::client::fluent_builders::ModifyTargetGroup::set_target_group_arn): <p>The Amazon Resource Name (ARN) of the target group.</p>
    ///   - [`health_check_protocol(ProtocolEnum)`](crate::client::fluent_builders::ModifyTargetGroup::health_check_protocol) / [`set_health_check_protocol(Option<ProtocolEnum>)`](crate::client::fluent_builders::ModifyTargetGroup::set_health_check_protocol): <p>The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. It is supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>  <p>With Network Load Balancers, you can't modify this setting.</p>
    ///   - [`health_check_port(impl Into<String>)`](crate::client::fluent_builders::ModifyTargetGroup::health_check_port) / [`set_health_check_port(Option<String>)`](crate::client::fluent_builders::ModifyTargetGroup::set_health_check_port): <p>The port the load balancer uses when performing health checks on targets.</p>
    ///   - [`health_check_path(impl Into<String>)`](crate::client::fluent_builders::ModifyTargetGroup::health_check_path) / [`set_health_check_path(Option<String>)`](crate::client::fluent_builders::ModifyTargetGroup::set_health_check_path): <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>  <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>  <p>[GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
    ///   - [`health_check_enabled(bool)`](crate::client::fluent_builders::ModifyTargetGroup::health_check_enabled) / [`set_health_check_enabled(Option<bool>)`](crate::client::fluent_builders::ModifyTargetGroup::set_health_check_enabled): <p>Indicates whether health checks are enabled.</p>
    ///   - [`health_check_interval_seconds(i32)`](crate::client::fluent_builders::ModifyTargetGroup::health_check_interval_seconds) / [`set_health_check_interval_seconds(Option<i32>)`](crate::client::fluent_builders::ModifyTargetGroup::set_health_check_interval_seconds): <p>The approximate amount of time, in seconds, between health checks of an individual target. For TCP health checks, the supported values are 10 or 30 seconds.</p>  <p>With Network Load Balancers, you can't modify this setting.</p>
    ///   - [`health_check_timeout_seconds(i32)`](crate::client::fluent_builders::ModifyTargetGroup::health_check_timeout_seconds) / [`set_health_check_timeout_seconds(Option<i32>)`](crate::client::fluent_builders::ModifyTargetGroup::set_health_check_timeout_seconds): <p>[HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means a failed health check.</p>  <p>With Network Load Balancers, you can't modify this setting.</p>
    ///   - [`healthy_threshold_count(i32)`](crate::client::fluent_builders::ModifyTargetGroup::healthy_threshold_count) / [`set_healthy_threshold_count(Option<i32>)`](crate::client::fluent_builders::ModifyTargetGroup::set_healthy_threshold_count): <p>The number of consecutive health checks successes required before considering an unhealthy target healthy.</p>
    ///   - [`unhealthy_threshold_count(i32)`](crate::client::fluent_builders::ModifyTargetGroup::unhealthy_threshold_count) / [`set_unhealthy_threshold_count(Option<i32>)`](crate::client::fluent_builders::ModifyTargetGroup::set_unhealthy_threshold_count): <p>The number of consecutive health check failures required before considering the target unhealthy. For target groups with a protocol of TCP or TLS, this value must be the same as the healthy threshold count.</p>
    ///   - [`matcher(Matcher)`](crate::client::fluent_builders::ModifyTargetGroup::matcher) / [`set_matcher(Option<Matcher>)`](crate::client::fluent_builders::ModifyTargetGroup::set_matcher): <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.</p>  <p>With Network Load Balancers, you can't modify this setting.</p>
    /// - On success, responds with [`ModifyTargetGroupOutput`](crate::output::ModifyTargetGroupOutput) with field(s):
    ///   - [`target_groups(Option<Vec<TargetGroup>>)`](crate::output::ModifyTargetGroupOutput::target_groups): <p>Information about the modified target group.</p>
    /// - On failure, responds with [`SdkError<ModifyTargetGroupError>`](crate::error::ModifyTargetGroupError)
    pub fn modify_target_group(&self) -> fluent_builders::ModifyTargetGroup {
        fluent_builders::ModifyTargetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyTargetGroupAttributes`](crate::client::fluent_builders::ModifyTargetGroupAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_group_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyTargetGroupAttributes::target_group_arn) / [`set_target_group_arn(Option<String>)`](crate::client::fluent_builders::ModifyTargetGroupAttributes::set_target_group_arn): <p>The Amazon Resource Name (ARN) of the target group.</p>
    ///   - [`attributes(Vec<TargetGroupAttribute>)`](crate::client::fluent_builders::ModifyTargetGroupAttributes::attributes) / [`set_attributes(Option<Vec<TargetGroupAttribute>>)`](crate::client::fluent_builders::ModifyTargetGroupAttributes::set_attributes): <p>The attributes.</p>
    /// - On success, responds with [`ModifyTargetGroupAttributesOutput`](crate::output::ModifyTargetGroupAttributesOutput) with field(s):
    ///   - [`attributes(Option<Vec<TargetGroupAttribute>>)`](crate::output::ModifyTargetGroupAttributesOutput::attributes): <p>Information about the attributes.</p>
    /// - On failure, responds with [`SdkError<ModifyTargetGroupAttributesError>`](crate::error::ModifyTargetGroupAttributesError)
    pub fn modify_target_group_attributes(&self) -> fluent_builders::ModifyTargetGroupAttributes {
        fluent_builders::ModifyTargetGroupAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterTargets`](crate::client::fluent_builders::RegisterTargets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_group_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterTargets::target_group_arn) / [`set_target_group_arn(Option<String>)`](crate::client::fluent_builders::RegisterTargets::set_target_group_arn): <p>The Amazon Resource Name (ARN) of the target group.</p>
    ///   - [`targets(Vec<TargetDescription>)`](crate::client::fluent_builders::RegisterTargets::targets) / [`set_targets(Option<Vec<TargetDescription>>)`](crate::client::fluent_builders::RegisterTargets::set_targets): <p>The targets.</p>
    /// - On success, responds with [`RegisterTargetsOutput`](crate::output::RegisterTargetsOutput)

    /// - On failure, responds with [`SdkError<RegisterTargetsError>`](crate::error::RegisterTargetsError)
    pub fn register_targets(&self) -> fluent_builders::RegisterTargets {
        fluent_builders::RegisterTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveListenerCertificates`](crate::client::fluent_builders::RemoveListenerCertificates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveListenerCertificates::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::RemoveListenerCertificates::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener.</p>
    ///   - [`certificates(Vec<Certificate>)`](crate::client::fluent_builders::RemoveListenerCertificates::certificates) / [`set_certificates(Option<Vec<Certificate>>)`](crate::client::fluent_builders::RemoveListenerCertificates::set_certificates): <p>The certificate to remove. You can specify one certificate per call. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
    /// - On success, responds with [`RemoveListenerCertificatesOutput`](crate::output::RemoveListenerCertificatesOutput)

    /// - On failure, responds with [`SdkError<RemoveListenerCertificatesError>`](crate::error::RemoveListenerCertificatesError)
    pub fn remove_listener_certificates(&self) -> fluent_builders::RemoveListenerCertificates {
        fluent_builders::RemoveListenerCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTags`](crate::client::fluent_builders::RemoveTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::RemoveTags::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTags::set_resource_arns): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::RemoveTags::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTags::set_tag_keys): <p>The tag keys for the tags to remove.</p>
    /// - On success, responds with [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)

    /// - On failure, responds with [`SdkError<RemoveTagsError>`](crate::error::RemoveTagsError)
    pub fn remove_tags(&self) -> fluent_builders::RemoveTags {
        fluent_builders::RemoveTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetIpAddressType`](crate::client::fluent_builders::SetIpAddressType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`load_balancer_arn(impl Into<String>)`](crate::client::fluent_builders::SetIpAddressType::load_balancer_arn) / [`set_load_balancer_arn(Option<String>)`](crate::client::fluent_builders::SetIpAddressType::set_load_balancer_arn): <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    ///   - [`ip_address_type(IpAddressType)`](crate::client::fluent_builders::SetIpAddressType::ip_address_type) / [`set_ip_address_type(Option<IpAddressType>)`](crate::client::fluent_builders::SetIpAddressType::set_ip_address_type): <p>The IP address type. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener.</p>
    /// - On success, responds with [`SetIpAddressTypeOutput`](crate::output::SetIpAddressTypeOutput) with field(s):
    ///   - [`ip_address_type(Option<IpAddressType>)`](crate::output::SetIpAddressTypeOutput::ip_address_type): <p>The IP address type.</p>
    /// - On failure, responds with [`SdkError<SetIpAddressTypeError>`](crate::error::SetIpAddressTypeError)
    pub fn set_ip_address_type(&self) -> fluent_builders::SetIpAddressType {
        fluent_builders::SetIpAddressType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetRulePriorities`](crate::client::fluent_builders::SetRulePriorities) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_priorities(Vec<RulePriorityPair>)`](crate::client::fluent_builders::SetRulePriorities::rule_priorities) / [`set_rule_priorities(Option<Vec<RulePriorityPair>>)`](crate::client::fluent_builders::SetRulePriorities::set_rule_priorities): <p>The rule priorities.</p>
    /// - On success, responds with [`SetRulePrioritiesOutput`](crate::output::SetRulePrioritiesOutput) with field(s):
    ///   - [`rules(Option<Vec<Rule>>)`](crate::output::SetRulePrioritiesOutput::rules): <p>Information about the rules.</p>
    /// - On failure, responds with [`SdkError<SetRulePrioritiesError>`](crate::error::SetRulePrioritiesError)
    pub fn set_rule_priorities(&self) -> fluent_builders::SetRulePriorities {
        fluent_builders::SetRulePriorities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetSecurityGroups`](crate::client::fluent_builders::SetSecurityGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`load_balancer_arn(impl Into<String>)`](crate::client::fluent_builders::SetSecurityGroups::load_balancer_arn) / [`set_load_balancer_arn(Option<String>)`](crate::client::fluent_builders::SetSecurityGroups::set_load_balancer_arn): <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    ///   - [`security_groups(Vec<String>)`](crate::client::fluent_builders::SetSecurityGroups::security_groups) / [`set_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::SetSecurityGroups::set_security_groups): <p>The IDs of the security groups.</p>
    /// - On success, responds with [`SetSecurityGroupsOutput`](crate::output::SetSecurityGroupsOutput) with field(s):
    ///   - [`security_group_ids(Option<Vec<String>>)`](crate::output::SetSecurityGroupsOutput::security_group_ids): <p>The IDs of the security groups associated with the load balancer.</p>
    /// - On failure, responds with [`SdkError<SetSecurityGroupsError>`](crate::error::SetSecurityGroupsError)
    pub fn set_security_groups(&self) -> fluent_builders::SetSecurityGroups {
        fluent_builders::SetSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetSubnets`](crate::client::fluent_builders::SetSubnets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`load_balancer_arn(impl Into<String>)`](crate::client::fluent_builders::SetSubnets::load_balancer_arn) / [`set_load_balancer_arn(Option<String>)`](crate::client::fluent_builders::SetSubnets::set_load_balancer_arn): <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    ///   - [`subnets(Vec<String>)`](crate::client::fluent_builders::SetSubnets::subnets) / [`set_subnets(Option<Vec<String>>)`](crate::client::fluent_builders::SetSubnets::set_subnets): <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>  <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones.</p>  <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>  <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>  <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones.</p>
    ///   - [`subnet_mappings(Vec<SubnetMapping>)`](crate::client::fluent_builders::SetSubnets::subnet_mappings) / [`set_subnet_mappings(Option<Vec<SubnetMapping>>)`](crate::client::fluent_builders::SetSubnets::set_subnet_mappings): <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>  <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>  <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>  <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>  <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.</p>
    ///   - [`ip_address_type(IpAddressType)`](crate::client::fluent_builders::SetSubnets::ip_address_type) / [`set_ip_address_type(Option<IpAddressType>)`](crate::client::fluent_builders::SetSubnets::set_ip_address_type): <p>[Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener. .</p>
    /// - On success, responds with [`SetSubnetsOutput`](crate::output::SetSubnetsOutput) with field(s):
    ///   - [`availability_zones(Option<Vec<AvailabilityZone>>)`](crate::output::SetSubnetsOutput::availability_zones): <p>Information about the subnets.</p>
    ///   - [`ip_address_type(Option<IpAddressType>)`](crate::output::SetSubnetsOutput::ip_address_type): <p>[Network Load Balancers] The IP address type.</p>
    /// - On failure, responds with [`SdkError<SetSubnetsError>`](crate::error::SetSubnetsError)
    pub fn set_subnets(&self) -> fluent_builders::SetSubnets {
        fluent_builders::SetSubnets::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddListenerCertificates`.
    ///
    /// <p>Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.</p>
    /// <p>If the certificate in already in the certificate list, the call is successful but the certificate is not added again.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html">HTTPS listeners</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html">TLS listeners</a> in the <i>Network Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddListenerCertificates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_listener_certificates_input::Builder,
    }
    impl AddListenerCertificates {
        /// Creates a new `AddListenerCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddListenerCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::AddListenerCertificatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// Appends an item to `Certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>The certificate to add. You can specify one certificate per call. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn certificates(mut self, input: crate::model::Certificate) -> Self {
            self.inner = self.inner.certificates(input);
            self
        }
        /// <p>The certificate to add. You can specify one certificate per call. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.inner = self.inner.set_certificates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTags`.
    ///
    /// <p>Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, and rules.</p>
    /// <p>Each tag consists of a key and an optional value. If a resource already has a tag with the same key, <code>AddTags</code> updates its value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_tags_input::Builder,
    }
    impl AddTags {
        /// Creates a new `AddTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateListener`.
    ///
    /// <p>Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.</p>
    /// <p>For more information, see the following:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html">Listeners for your Application Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html">Listeners for your Network Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html">Listeners for your Gateway Load Balancers</a> </p> </li>
    /// </ul>
    /// <p>This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple listeners with the same settings, each call succeeds.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateListener {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_listener_input::Builder,
    }
    impl CreateListener {
        /// Creates a new `CreateListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateListenerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// <p>The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>
        pub fn protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.inner = self.inner.protocol(input);
            self
        }
        /// <p>The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>The port on which the load balancer is listening. You cannot specify a port for a Gateway Load Balancer.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port on which the load balancer is listening. You cannot specify a port for a Gateway Load Balancer.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> and <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn ssl_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssl_policy(input.into());
            self
        }
        /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> and <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn set_ssl_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ssl_policy(input);
            self
        }
        /// Appends an item to `Certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn certificates(mut self, input: crate::model::Certificate) -> Self {
            self.inner = self.inner.certificates(input);
            self
        }
        /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.inner = self.inner.set_certificates(input);
            self
        }
        /// Appends an item to `DefaultActions`.
        ///
        /// To override the contents of this collection use [`set_default_actions`](Self::set_default_actions).
        ///
        /// <p>The actions for the default rule.</p>
        pub fn default_actions(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.default_actions(input);
            self
        }
        /// <p>The actions for the default rule.</p>
        pub fn set_default_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.inner = self.inner.set_default_actions(input);
            self
        }
        /// Appends an item to `AlpnPolicy`.
        ///
        /// To override the contents of this collection use [`set_alpn_policy`](Self::set_alpn_policy).
        ///
        /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:</p>
        /// <ul>
        /// <li> <p> <code>HTTP1Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Optional</code> </p> </li>
        /// <li> <p> <code>HTTP2Preferred</code> </p> </li>
        /// <li> <p> <code>None</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn alpn_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alpn_policy(input.into());
            self
        }
        /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:</p>
        /// <ul>
        /// <li> <p> <code>HTTP1Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Optional</code> </p> </li>
        /// <li> <p> <code>HTTP2Preferred</code> </p> </li>
        /// <li> <p> <code>None</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn set_alpn_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_alpn_policy(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the listener.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to assign to the listener.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLoadBalancer`.
    ///
    /// <p>Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.</p>
    /// <p>For more information, see the following:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html">Application Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html">Network Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html">Gateway Load Balancers</a> </p> </li>
    /// </ul>
    /// <p>This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple load balancers with the same settings, each call succeeds.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLoadBalancer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_load_balancer_input::Builder,
    }
    impl CreateLoadBalancer {
        /// Creates a new `CreateLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLoadBalancerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLoadBalancerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones.</p>
        /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnets(input.into());
            self
        }
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones.</p>
        /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnets(input);
            self
        }
        /// Appends an item to `SubnetMappings`.
        ///
        /// To override the contents of this collection use [`set_subnet_mappings`](Self::set_subnet_mappings).
        ///
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.</p>
        /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        pub fn subnet_mappings(mut self, input: crate::model::SubnetMapping) -> Self {
            self.inner = self.inner.subnet_mappings(input);
            self
        }
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.</p>
        /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        pub fn set_subnet_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_mappings(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>[Application Load Balancers] The IDs of the security groups for the load balancer.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(input.into());
            self
        }
        /// <p>[Application Load Balancers] The IDs of the security groups for the load balancer.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
        /// <p>The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.</p>
        /// <p>The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.</p>
        /// <p>The default is an Internet-facing load balancer.</p>
        /// <p>You cannot specify a scheme for a Gateway Load Balancer.</p>
        pub fn scheme(mut self, input: crate::model::LoadBalancerSchemeEnum) -> Self {
            self.inner = self.inner.scheme(input);
            self
        }
        /// <p>The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.</p>
        /// <p>The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.</p>
        /// <p>The default is an Internet-facing load balancer.</p>
        /// <p>You cannot specify a scheme for a Gateway Load Balancer.</p>
        pub fn set_scheme(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerSchemeEnum>,
        ) -> Self {
            self.inner = self.inner.set_scheme(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the load balancer.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to assign to the load balancer.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The type of load balancer. The default is <code>application</code>.</p>
        pub fn r#type(mut self, input: crate::model::LoadBalancerTypeEnum) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of load balancer. The default is <code>application</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). </p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(input);
            self
        }
        /// <p>The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). </p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
        /// <p>[Application Load Balancers on Outposts] The ID of the customer-owned address pool (CoIP pool).</p>
        pub fn customer_owned_ipv4_pool(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_owned_ipv4_pool(input.into());
            self
        }
        /// <p>[Application Load Balancers on Outposts] The ID of the customer-owned address pool (CoIP pool).</p>
        pub fn set_customer_owned_ipv4_pool(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_customer_owned_ipv4_pool(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRule`.
    ///
    /// <p>Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.</p>
    /// <p>Each rule consists of a priority, one or more actions, and one or more conditions. Rules are evaluated in priority order, from the lowest value to the highest value. When the conditions for a rule are met, its actions are performed. If the conditions for no rules are met, the actions for the default rule are performed. For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules">Listener rules</a> in the <i>Application Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_rule_input::Builder,
    }
    impl CreateRule {
        /// Creates a new `CreateRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// Appends an item to `Conditions`.
        ///
        /// To override the contents of this collection use [`set_conditions`](Self::set_conditions).
        ///
        /// <p>The conditions.</p>
        pub fn conditions(mut self, input: crate::model::RuleCondition) -> Self {
            self.inner = self.inner.conditions(input);
            self
        }
        /// <p>The conditions.</p>
        pub fn set_conditions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleCondition>>,
        ) -> Self {
            self.inner = self.inner.set_conditions(input);
            self
        }
        /// <p>The rule priority. A listener can't have multiple rules with the same priority.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.inner = self.inner.priority(input);
            self
        }
        /// <p>The rule priority. A listener can't have multiple rules with the same priority.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// Appends an item to `Actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions.</p>
        pub fn actions(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.actions(input);
            self
        }
        /// <p>The actions.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the rule.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to assign to the rule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTargetGroup`.
    ///
    /// <p>Creates a target group.</p>
    /// <p>For more information, see the following:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html">Target groups for your Application Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html">Target groups for your Network Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html">Target groups for your Gateway Load Balancers</a> </p> </li>
    /// </ul>
    /// <p>This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple target groups with the same settings, each call succeeds.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTargetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_target_group_input::Builder,
    }
    impl CreateTargetGroup {
        /// Creates a new `CreateTargetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTargetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTargetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the target group.</p>
        /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the target group.</p>
        /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.</p>
        pub fn protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.inner = self.inner.protocol(input);
            self
        }
        /// <p>The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>[HTTP/HTTPS protocol] The protocol version. Specify <code>GRPC</code> to send requests to targets using gRPC. Specify <code>HTTP2</code> to send requests to targets using HTTP/2. The default is <code>HTTP1</code>, which sends requests to targets using HTTP/1.1.</p>
        pub fn protocol_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protocol_version(input.into());
            self
        }
        /// <p>[HTTP/HTTPS protocol] The protocol version. Specify <code>GRPC</code> to send requests to targets using gRPC. Specify <code>HTTP2</code> to send requests to targets using HTTP/2. The default is <code>HTTP1</code>, which sends requests to targets using HTTP/1.1.</p>
        pub fn set_protocol_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protocol_version(input);
            self
        }
        /// <p>The port on which the targets receive traffic. This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port on which the targets receive traffic. This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The identifier of the virtual private cloud (VPC). If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The identifier of the virtual private cloud (VPC). If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>
        pub fn health_check_protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.inner = self.inner.health_check_protocol(input);
            self
        }
        /// <p>The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>
        pub fn set_health_check_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.inner = self.inner.set_health_check_protocol(input);
            self
        }
        /// <p>The port the load balancer uses when performing health checks on targets. If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code>, which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.</p>
        pub fn health_check_port(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_port(input.into());
            self
        }
        /// <p>The port the load balancer uses when performing health checks on targets. If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code>, which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.</p>
        pub fn set_health_check_port(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_port(input);
            self
        }
        /// <p>Indicates whether health checks are enabled. If the target type is <code>lambda</code>, health checks are disabled by default but can be enabled. If the target type is <code>instance</code>, <code>ip</code>, or <code>alb</code>, health checks are always enabled and cannot be disabled.</p>
        pub fn health_check_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.health_check_enabled(input);
            self
        }
        /// <p>Indicates whether health checks are enabled. If the target type is <code>lambda</code>, health checks are disabled by default but can be enabled. If the target type is <code>instance</code>, <code>ip</code>, or <code>alb</code>, health checks are always enabled and cannot be disabled.</p>
        pub fn set_health_check_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_health_check_enabled(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
        /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
        /// <p>[GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
        pub fn health_check_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_path(input.into());
            self
        }
        /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
        /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
        /// <p>[GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_path(input);
            self
        }
        /// <p>The approximate amount of time, in seconds, between health checks of an individual target. If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30 seconds. If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is <code>lambda</code>, the default is 35 seconds.</p>
        pub fn health_check_interval_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_interval_seconds(input);
            self
        }
        /// <p>The approximate amount of time, in seconds, between health checks of an individual target. If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30 seconds. If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is <code>lambda</code>, the default is 35 seconds.</p>
        pub fn set_health_check_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_health_check_interval_seconds(input);
            self
        }
        /// <p>The amount of time, in seconds, during which no response from a target means a failed health check. For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is <code>lambda</code>, the default is 30 seconds.</p>
        pub fn health_check_timeout_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_timeout_seconds(input);
            self
        }
        /// <p>The amount of time, in seconds, during which no response from a target means a failed health check. For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is <code>lambda</code>, the default is 30 seconds.</p>
        pub fn set_health_check_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_health_check_timeout_seconds(input);
            self
        }
        /// <p>The number of consecutive health checks successes required before considering an unhealthy target healthy. For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is <code>lambda</code>, the default is 5.</p>
        pub fn healthy_threshold_count(mut self, input: i32) -> Self {
            self.inner = self.inner.healthy_threshold_count(input);
            self
        }
        /// <p>The number of consecutive health checks successes required before considering an unhealthy target healthy. For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is <code>lambda</code>, the default is 5.</p>
        pub fn set_healthy_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_healthy_threshold_count(input);
            self
        }
        /// <p>The number of consecutive health check failures required before considering a target unhealthy. If the target group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If the target group protocol is GENEVE, the default is 3. If the target type is <code>lambda</code>, the default is 2.</p>
        pub fn unhealthy_threshold_count(mut self, input: i32) -> Self {
            self.inner = self.inner.unhealthy_threshold_count(input);
            self
        }
        /// <p>The number of consecutive health check failures required before considering a target unhealthy. If the target group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If the target group protocol is GENEVE, the default is 3. If the target type is <code>lambda</code>, the default is 2.</p>
        pub fn set_unhealthy_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_unhealthy_threshold_count(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.</p>
        pub fn matcher(mut self, input: crate::model::Matcher) -> Self {
            self.inner = self.inner.matcher(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.</p>
        pub fn set_matcher(mut self, input: std::option::Option<crate::model::Matcher>) -> Self {
            self.inner = self.inner.set_matcher(input);
            self
        }
        /// <p>The type of target that you must specify when registering targets with this target group. You can't specify targets for a target group using more than one target type.</p>
        /// <ul>
        /// <li> <p> <code>instance</code> - Register targets by instance ID. This is the default value.</p> </li>
        /// <li> <p> <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.</p> </li>
        /// <li> <p> <code>lambda</code> - Register a single Lambda function as a target.</p> </li>
        /// <li> <p> <code>alb</code> - Register a single Application Load Balancer as a target.</p> </li>
        /// </ul>
        pub fn target_type(mut self, input: crate::model::TargetTypeEnum) -> Self {
            self.inner = self.inner.target_type(input);
            self
        }
        /// <p>The type of target that you must specify when registering targets with this target group. You can't specify targets for a target group using more than one target type.</p>
        /// <ul>
        /// <li> <p> <code>instance</code> - Register targets by instance ID. This is the default value.</p> </li>
        /// <li> <p> <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.</p> </li>
        /// <li> <p> <code>lambda</code> - Register a single Lambda function as a target.</p> </li>
        /// <li> <p> <code>alb</code> - Register a single Application Load Balancer as a target.</p> </li>
        /// </ul>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the target group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to assign to the target group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The type of IP address used for this target group. The possible values are <code>ipv4</code> and <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code>.</p>
        pub fn ip_address_type(
            mut self,
            input: crate::model::TargetGroupIpAddressTypeEnum,
        ) -> Self {
            self.inner = self.inner.ip_address_type(input);
            self
        }
        /// <p>The type of IP address used for this target group. The possible values are <code>ipv4</code> and <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code>.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::TargetGroupIpAddressTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteListener`.
    ///
    /// <p>Deletes the specified listener.</p>
    /// <p>Alternatively, your listener is deleted when you delete the load balancer to which it is attached.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteListener {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_listener_input::Builder,
    }
    impl DeleteListener {
        /// Creates a new `DeleteListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteListenerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLoadBalancer`.
    ///
    /// <p>Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load balancer also deletes its listeners.</p>
    /// <p>You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has already been deleted, the call succeeds.</p>
    /// <p>Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or terminate them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLoadBalancer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_load_balancer_input::Builder,
    }
    impl DeleteLoadBalancer {
        /// Creates a new `DeleteLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLoadBalancerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLoadBalancerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRule`.
    ///
    /// <p>Deletes the specified rule.</p>
    /// <p>You can't delete the default rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_rule_input::Builder,
    }
    impl DeleteRule {
        /// Creates a new `DeleteRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTargetGroup`.
    ///
    /// <p>Deletes the specified target group.</p>
    /// <p>You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2 instances continue to run until you stop or terminate them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTargetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_target_group_input::Builder,
    }
    impl DeleteTargetGroup {
        /// Creates a new `DeleteTargetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTargetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTargetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterTargets`.
    ///
    /// <p>Deregisters the specified targets from the specified target group. After the targets are deregistered, they no longer receive traffic from the load balancer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterTargets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_targets_input::Builder,
    }
    impl DeregisterTargets {
        /// Creates a new `DeregisterTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterTargetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets. If you specified a port override when you registered a target, you must specify both the target ID and the port when you deregister it.</p>
        pub fn targets(mut self, input: crate::model::TargetDescription) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>The targets. If you specified a port override when you registered a target, you must specify both the target ID and the port when you deregister it.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountLimits`.
    ///
    /// <p>Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.</p>
    /// <p>For more information, see the following:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas for your Application Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Quotas for your Network Load Balancers</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html">Quotas for your Gateway Load Balancers</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountLimits {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_limits_input::Builder,
    }
    impl DescribeAccountLimits {
        /// Creates a new `DescribeAccountLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountLimitsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeListenerCertificates`.
    ///
    /// <p>Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.</p>
    /// <p>If the default certificate is also in the certificate list, it appears twice in the results (once with <code>IsDefault</code> set to true and once with <code>IsDefault</code> set to false).</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates">SSL certificates</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#tls-listener-certificate">Server certificates</a> in the <i>Network Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeListenerCertificates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_listener_certificates_input::Builder,
    }
    impl DescribeListenerCertificates {
        /// Creates a new `DescribeListenerCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeListenerCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeListenerCertificatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Names (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeListeners`.
    ///
    /// <p>Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeListeners {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_listeners_input::Builder,
    }
    impl DescribeListeners {
        /// Creates a new `DescribeListeners`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeListenersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeListenersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeListenersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeListenersPaginator {
            crate::paginator::DescribeListenersPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// Appends an item to `ListenerArns`.
        ///
        /// To override the contents of this collection use [`set_listener_arns`](Self::set_listener_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the listeners.</p>
        pub fn listener_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the listeners.</p>
        pub fn set_listener_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_listener_arns(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoadBalancerAttributes`.
    ///
    /// <p>Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.</p>
    /// <p>For more information, see the following:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes">Load balancer attributes</a> in the <i>Application Load Balancers Guide</i> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes">Load balancer attributes</a> in the <i>Network Load Balancers Guide</i> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes">Load balancer attributes</a> in the <i>Gateway Load Balancers Guide</i> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoadBalancerAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_load_balancer_attributes_input::Builder,
    }
    impl DescribeLoadBalancerAttributes {
        /// Creates a new `DescribeLoadBalancerAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoadBalancerAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancerAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoadBalancers`.
    ///
    /// <p>Describes the specified load balancers or all of your load balancers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoadBalancers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_load_balancers_input::Builder,
    }
    impl DescribeLoadBalancers {
        /// Creates a new `DescribeLoadBalancers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoadBalancersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeLoadBalancersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeLoadBalancersPaginator {
            crate::paginator::DescribeLoadBalancersPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `LoadBalancerArns`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_arns`](Self::set_load_balancer_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the load balancers. You can specify up to 20 load balancers in a single call.</p>
        pub fn load_balancer_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the load balancers. You can specify up to 20 load balancers in a single call.</p>
        pub fn set_load_balancer_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arns(input);
            self
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the load balancers.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>The names of the load balancers.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRules`.
    ///
    /// <p>Describes the specified rules or the rules for the specified listener. You must specify either a listener or one or more rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_rules_input::Builder,
    }
    impl DescribeRules {
        /// Creates a new `DescribeRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// Appends an item to `RuleArns`.
        ///
        /// To override the contents of this collection use [`set_rule_arns`](Self::set_rule_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the rules.</p>
        pub fn rule_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the rules.</p>
        pub fn set_rule_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_rule_arns(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSSLPolicies`.
    ///
    /// <p>Describes the specified policies or all policies used for SSL negotiation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSSLPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_ssl_policies_input::Builder,
    }
    impl DescribeSSLPolicies {
        /// Creates a new `DescribeSSLPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSslPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSSLPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the policies.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>The names of the policies.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p> The type of load balancer. The default lists the SSL policies for all load balancers.</p>
        pub fn load_balancer_type(mut self, input: crate::model::LoadBalancerTypeEnum) -> Self {
            self.inner = self.inner.load_balancer_type(input);
            self
        }
        /// <p> The type of load balancer. The default lists the SSL policies for all load balancers.</p>
        pub fn set_load_balancer_type(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <p>Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl DescribeTags {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the resources. You can specify up to 20 resources in a single call.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the resources. You can specify up to 20 resources in a single call.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTargetGroupAttributes`.
    ///
    /// <p>Describes the attributes for the specified target group.</p>
    /// <p>For more information, see the following:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes">Target group attributes</a> in the <i>Application Load Balancers Guide</i> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes">Target group attributes</a> in the <i>Network Load Balancers Guide</i> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes">Target group attributes</a> in the <i>Gateway Load Balancers Guide</i> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTargetGroupAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_target_group_attributes_input::Builder,
    }
    impl DescribeTargetGroupAttributes {
        /// Creates a new `DescribeTargetGroupAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTargetGroupAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTargetGroupAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTargetGroups`.
    ///
    /// <p>Describes the specified target groups or all of your target groups. By default, all target groups are described. Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the names of one or more target groups, or the ARNs of one or more target groups.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTargetGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_target_groups_input::Builder,
    }
    impl DescribeTargetGroups {
        /// Creates a new `DescribeTargetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTargetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTargetGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeTargetGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeTargetGroupsPaginator {
            crate::paginator::DescribeTargetGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// Appends an item to `TargetGroupArns`.
        ///
        /// To override the contents of this collection use [`set_target_group_arns`](Self::set_target_group_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the target groups.</p>
        pub fn target_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the target groups.</p>
        pub fn set_target_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arns(input);
            self
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the target groups.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>The names of the target groups.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTargetHealth`.
    ///
    /// <p>Describes the health of the specified targets or all of your targets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTargetHealth {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_target_health_input::Builder,
    }
    impl DescribeTargetHealth {
        /// Creates a new `DescribeTargetHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTargetHealthOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTargetHealthError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets.</p>
        pub fn targets(mut self, input: crate::model::TargetDescription) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>The targets.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyListener`.
    ///
    /// <p>Replaces the specified properties of the specified listener. Any properties that you do not specify remain unchanged.</p>
    /// <p>Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy and default certificate properties.</p>
    /// <p>To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyListener {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_listener_input::Builder,
    }
    impl ModifyListener {
        /// Creates a new `ModifyListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyListenerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// <p>The port for connections from clients to the load balancer. You cannot specify a port for a Gateway Load Balancer.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port for connections from clients to the load balancer. You cannot specify a port for a Gateway Load Balancer.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The protocol for connections from clients to the load balancer. Application Load Balancers support the HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You can’t change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>
        pub fn protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.inner = self.inner.protocol(input);
            self
        }
        /// <p>The protocol for connections from clients to the load balancer. Application Load Balancers support the HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You can’t change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn ssl_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssl_policy(input.into());
            self
        }
        /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn set_ssl_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ssl_policy(input);
            self
        }
        /// Appends an item to `Certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn certificates(mut self, input: crate::model::Certificate) -> Self {
            self.inner = self.inner.certificates(input);
            self
        }
        /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.inner = self.inner.set_certificates(input);
            self
        }
        /// Appends an item to `DefaultActions`.
        ///
        /// To override the contents of this collection use [`set_default_actions`](Self::set_default_actions).
        ///
        /// <p>The actions for the default rule.</p>
        pub fn default_actions(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.default_actions(input);
            self
        }
        /// <p>The actions for the default rule.</p>
        pub fn set_default_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.inner = self.inner.set_default_actions(input);
            self
        }
        /// Appends an item to `AlpnPolicy`.
        ///
        /// To override the contents of this collection use [`set_alpn_policy`](Self::set_alpn_policy).
        ///
        /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:</p>
        /// <ul>
        /// <li> <p> <code>HTTP1Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Optional</code> </p> </li>
        /// <li> <p> <code>HTTP2Preferred</code> </p> </li>
        /// <li> <p> <code>None</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn alpn_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alpn_policy(input.into());
            self
        }
        /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:</p>
        /// <ul>
        /// <li> <p> <code>HTTP1Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Only</code> </p> </li>
        /// <li> <p> <code>HTTP2Optional</code> </p> </li>
        /// <li> <p> <code>HTTP2Preferred</code> </p> </li>
        /// <li> <p> <code>None</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn set_alpn_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_alpn_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyLoadBalancerAttributes`.
    ///
    /// <p>Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.</p>
    /// <p>If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that you do not modify retain their current values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyLoadBalancerAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_load_balancer_attributes_input::Builder,
    }
    impl ModifyLoadBalancerAttributes {
        /// Creates a new `ModifyLoadBalancerAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyLoadBalancerAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyLoadBalancerAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// Appends an item to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The load balancer attributes.</p>
        pub fn attributes(mut self, input: crate::model::LoadBalancerAttribute) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// <p>The load balancer attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancerAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyRule`.
    ///
    /// <p>Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.</p>
    /// <p>To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_rule_input::Builder,
    }
    impl ModifyRule {
        /// Creates a new `ModifyRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_arn(input);
            self
        }
        /// Appends an item to `Conditions`.
        ///
        /// To override the contents of this collection use [`set_conditions`](Self::set_conditions).
        ///
        /// <p>The conditions.</p>
        pub fn conditions(mut self, input: crate::model::RuleCondition) -> Self {
            self.inner = self.inner.conditions(input);
            self
        }
        /// <p>The conditions.</p>
        pub fn set_conditions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleCondition>>,
        ) -> Self {
            self.inner = self.inner.set_conditions(input);
            self
        }
        /// Appends an item to `Actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions.</p>
        pub fn actions(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.actions(input);
            self
        }
        /// <p>The actions.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyTargetGroup`.
    ///
    /// <p>Modifies the health checks used when evaluating the health state of the targets in the specified target group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyTargetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_target_group_input::Builder,
    }
    impl ModifyTargetGroup {
        /// Creates a new `ModifyTargetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyTargetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyTargetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
        /// <p>The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. It is supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn health_check_protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.inner = self.inner.health_check_protocol(input);
            self
        }
        /// <p>The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. It is supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn set_health_check_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.inner = self.inner.set_health_check_protocol(input);
            self
        }
        /// <p>The port the load balancer uses when performing health checks on targets.</p>
        pub fn health_check_port(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_port(input.into());
            self
        }
        /// <p>The port the load balancer uses when performing health checks on targets.</p>
        pub fn set_health_check_port(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_port(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
        /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
        /// <p>[GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
        pub fn health_check_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_path(input.into());
            self
        }
        /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
        /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
        /// <p>[GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_path(input);
            self
        }
        /// <p>Indicates whether health checks are enabled.</p>
        pub fn health_check_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.health_check_enabled(input);
            self
        }
        /// <p>Indicates whether health checks are enabled.</p>
        pub fn set_health_check_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_health_check_enabled(input);
            self
        }
        /// <p>The approximate amount of time, in seconds, between health checks of an individual target. For TCP health checks, the supported values are 10 or 30 seconds.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn health_check_interval_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_interval_seconds(input);
            self
        }
        /// <p>The approximate amount of time, in seconds, between health checks of an individual target. For TCP health checks, the supported values are 10 or 30 seconds.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn set_health_check_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_health_check_interval_seconds(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means a failed health check.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn health_check_timeout_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_timeout_seconds(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means a failed health check.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn set_health_check_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_health_check_timeout_seconds(input);
            self
        }
        /// <p>The number of consecutive health checks successes required before considering an unhealthy target healthy.</p>
        pub fn healthy_threshold_count(mut self, input: i32) -> Self {
            self.inner = self.inner.healthy_threshold_count(input);
            self
        }
        /// <p>The number of consecutive health checks successes required before considering an unhealthy target healthy.</p>
        pub fn set_healthy_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_healthy_threshold_count(input);
            self
        }
        /// <p>The number of consecutive health check failures required before considering the target unhealthy. For target groups with a protocol of TCP or TLS, this value must be the same as the healthy threshold count.</p>
        pub fn unhealthy_threshold_count(mut self, input: i32) -> Self {
            self.inner = self.inner.unhealthy_threshold_count(input);
            self
        }
        /// <p>The number of consecutive health check failures required before considering the target unhealthy. For target groups with a protocol of TCP or TLS, this value must be the same as the healthy threshold count.</p>
        pub fn set_unhealthy_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_unhealthy_threshold_count(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn matcher(mut self, input: crate::model::Matcher) -> Self {
            self.inner = self.inner.matcher(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn set_matcher(mut self, input: std::option::Option<crate::model::Matcher>) -> Self {
            self.inner = self.inner.set_matcher(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyTargetGroupAttributes`.
    ///
    /// <p>Modifies the specified attributes of the specified target group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyTargetGroupAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_target_group_attributes_input::Builder,
    }
    impl ModifyTargetGroupAttributes {
        /// Creates a new `ModifyTargetGroupAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyTargetGroupAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyTargetGroupAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
        /// Appends an item to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes.</p>
        pub fn attributes(mut self, input: crate::model::TargetGroupAttribute) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// <p>The attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetGroupAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterTargets`.
    ///
    /// <p>Registers the specified targets with the specified target group.</p>
    /// <p>If the target is an EC2 instance, it must be in the <code>running</code> state when you register it.</p>
    /// <p>By default, the load balancer routes requests to registered targets using the protocol and port for the target group. Alternatively, you can override the port for a target when you register it. You can register each EC2 instance or IP address with the same target group multiple times using different ports.</p>
    /// <p>With a Network Load Balancer, you cannot register instances by instance ID if they have the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1. You can register instances of these types by IP address.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterTargets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_targets_input::Builder,
    }
    impl RegisterTargets {
        /// Creates a new `RegisterTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterTargetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_arn(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets.</p>
        pub fn targets(mut self, input: crate::model::TargetDescription) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>The targets.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveListenerCertificates`.
    ///
    /// <p>Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveListenerCertificates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_listener_certificates_input::Builder,
    }
    impl RemoveListenerCertificates {
        /// Creates a new `RemoveListenerCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveListenerCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveListenerCertificatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// Appends an item to `Certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>The certificate to remove. You can specify one certificate per call. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn certificates(mut self, input: crate::model::Certificate) -> Self {
            self.inner = self.inner.certificates(input);
            self
        }
        /// <p>The certificate to remove. You can specify one certificate per call. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.inner = self.inner.set_certificates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTags`.
    ///
    /// <p>Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_tags_input::Builder,
    }
    impl RemoveTags {
        /// Creates a new `RemoveTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys for the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys for the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIpAddressType`.
    ///
    /// <p>Sets the type of IP addresses used by the subnets of the specified Application Load Balancer or Network Load Balancer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetIpAddressType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_ip_address_type_input::Builder,
    }
    impl SetIpAddressType {
        /// Creates a new `SetIpAddressType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIpAddressTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::SetIpAddressTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// <p>The IP address type. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(input);
            self
        }
        /// <p>The IP address type. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetRulePriorities`.
    ///
    /// <p>Sets the priorities of the specified rules.</p>
    /// <p>You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that you do not specify retain their current priority.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetRulePriorities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_rule_priorities_input::Builder,
    }
    impl SetRulePriorities {
        /// Creates a new `SetRulePriorities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetRulePrioritiesOutput,
            aws_smithy_http::result::SdkError<crate::error::SetRulePrioritiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `RulePriorities`.
        ///
        /// To override the contents of this collection use [`set_rule_priorities`](Self::set_rule_priorities).
        ///
        /// <p>The rule priorities.</p>
        pub fn rule_priorities(mut self, input: crate::model::RulePriorityPair) -> Self {
            self.inner = self.inner.rule_priorities(input);
            self
        }
        /// <p>The rule priorities.</p>
        pub fn set_rule_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RulePriorityPair>>,
        ) -> Self {
            self.inner = self.inner.set_rule_priorities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetSecurityGroups`.
    ///
    /// <p>Associates the specified security groups with the specified Application Load Balancer. The specified security groups override the previously associated security groups.</p>
    /// <p>You can't specify a security group for a Network Load Balancer or Gateway Load Balancer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetSecurityGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_security_groups_input::Builder,
    }
    impl SetSecurityGroups {
        /// Creates a new `SetSecurityGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetSecurityGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::SetSecurityGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The IDs of the security groups.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(input.into());
            self
        }
        /// <p>The IDs of the security groups.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetSubnets`.
    ///
    /// <p>Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer or Network Load Balancer. The specified subnets replace the previously enabled subnets.</p>
    /// <p>When you specify subnets for a Network Load Balancer, you must include all subnets that were enabled previously, with their existing configurations, plus any additional subnets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetSubnets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_subnets_input::Builder,
    }
    impl SetSubnets {
        /// Creates a new `SetSubnets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetSubnetsOutput,
            aws_smithy_http::result::SdkError<crate::error::SetSubnetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_arn(input);
            self
        }
        /// Appends an item to `Subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnets(input.into());
            self
        }
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnets(input);
            self
        }
        /// Appends an item to `SubnetMappings`.
        ///
        /// To override the contents of this collection use [`set_subnet_mappings`](Self::set_subnet_mappings).
        ///
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.</p>
        pub fn subnet_mappings(mut self, input: crate::model::SubnetMapping) -> Self {
            self.inner = self.inner.subnet_mappings(input);
            self
        }
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.</p>
        pub fn set_subnet_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_mappings(input);
            self
        }
        /// <p>[Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener. .</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(input);
            self
        }
        /// <p>[Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener. .</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
