// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetSubnetsOutput {
    /// <p>Information about the subnets.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
    /// <p>[Network Load Balancers] The IP address type.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
}
impl std::fmt::Debug for SetSubnetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetSubnetsOutput");
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.finish()
    }
}
/// See [`SetSubnetsOutput`](crate::output::SetSubnetsOutput)
pub mod set_subnets_output {
    /// A builder for [`SetSubnetsOutput`](crate::output::SetSubnetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zones:
            std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
    }
    impl Builder {
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>Information about the subnets.</p>
        pub fn availability_zones(
            mut self,
            input: impl Into<crate::model::AvailabilityZone>,
        ) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>Information about the subnets.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>[Network Load Balancers] The IP address type.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>[Network Load Balancers] The IP address type.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SetSubnetsOutput`](crate::output::SetSubnetsOutput)
        pub fn build(self) -> crate::output::SetSubnetsOutput {
            crate::output::SetSubnetsOutput {
                availability_zones: self.availability_zones,
                ip_address_type: self.ip_address_type,
            }
        }
    }
}
impl SetSubnetsOutput {
    /// Creates a new builder-style object to manufacture [`SetSubnetsOutput`](crate::output::SetSubnetsOutput)
    pub fn builder() -> crate::output::set_subnets_output::Builder {
        crate::output::set_subnets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetSecurityGroupsOutput {
    /// <p>The IDs of the security groups associated with the load balancer.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for SetSecurityGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetSecurityGroupsOutput");
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`SetSecurityGroupsOutput`](crate::output::SetSecurityGroupsOutput)
pub mod set_security_groups_output {
    /// A builder for [`SetSecurityGroupsOutput`](crate::output::SetSecurityGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The IDs of the security groups associated with the load balancer.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The IDs of the security groups associated with the load balancer.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`SetSecurityGroupsOutput`](crate::output::SetSecurityGroupsOutput)
        pub fn build(self) -> crate::output::SetSecurityGroupsOutput {
            crate::output::SetSecurityGroupsOutput {
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl SetSecurityGroupsOutput {
    /// Creates a new builder-style object to manufacture [`SetSecurityGroupsOutput`](crate::output::SetSecurityGroupsOutput)
    pub fn builder() -> crate::output::set_security_groups_output::Builder {
        crate::output::set_security_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetRulePrioritiesOutput {
    /// <p>Information about the rules.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
}
impl std::fmt::Debug for SetRulePrioritiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetRulePrioritiesOutput");
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`SetRulePrioritiesOutput`](crate::output::SetRulePrioritiesOutput)
pub mod set_rule_priorities_output {
    /// A builder for [`SetRulePrioritiesOutput`](crate::output::SetRulePrioritiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Information about the rules.</p>
        pub fn rules(mut self, input: impl Into<crate::model::Rule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>Information about the rules.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`SetRulePrioritiesOutput`](crate::output::SetRulePrioritiesOutput)
        pub fn build(self) -> crate::output::SetRulePrioritiesOutput {
            crate::output::SetRulePrioritiesOutput { rules: self.rules }
        }
    }
}
impl SetRulePrioritiesOutput {
    /// Creates a new builder-style object to manufacture [`SetRulePrioritiesOutput`](crate::output::SetRulePrioritiesOutput)
    pub fn builder() -> crate::output::set_rule_priorities_output::Builder {
        crate::output::set_rule_priorities_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIpAddressTypeOutput {
    /// <p>The IP address type.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
}
impl std::fmt::Debug for SetIpAddressTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIpAddressTypeOutput");
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.finish()
    }
}
/// See [`SetIpAddressTypeOutput`](crate::output::SetIpAddressTypeOutput)
pub mod set_ip_address_type_output {
    /// A builder for [`SetIpAddressTypeOutput`](crate::output::SetIpAddressTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
    }
    impl Builder {
        /// <p>The IP address type.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The IP address type.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SetIpAddressTypeOutput`](crate::output::SetIpAddressTypeOutput)
        pub fn build(self) -> crate::output::SetIpAddressTypeOutput {
            crate::output::SetIpAddressTypeOutput {
                ip_address_type: self.ip_address_type,
            }
        }
    }
}
impl SetIpAddressTypeOutput {
    /// Creates a new builder-style object to manufacture [`SetIpAddressTypeOutput`](crate::output::SetIpAddressTypeOutput)
    pub fn builder() -> crate::output::set_ip_address_type_output::Builder {
        crate::output::set_ip_address_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsOutput {}
impl std::fmt::Debug for RemoveTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsOutput");
        formatter.finish()
    }
}
/// See [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
pub mod remove_tags_output {
    /// A builder for [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
        pub fn build(self) -> crate::output::RemoveTagsOutput {
            crate::output::RemoveTagsOutput {}
        }
    }
}
impl RemoveTagsOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
    pub fn builder() -> crate::output::remove_tags_output::Builder {
        crate::output::remove_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveListenerCertificatesOutput {}
impl std::fmt::Debug for RemoveListenerCertificatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveListenerCertificatesOutput");
        formatter.finish()
    }
}
/// See [`RemoveListenerCertificatesOutput`](crate::output::RemoveListenerCertificatesOutput)
pub mod remove_listener_certificates_output {
    /// A builder for [`RemoveListenerCertificatesOutput`](crate::output::RemoveListenerCertificatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveListenerCertificatesOutput`](crate::output::RemoveListenerCertificatesOutput)
        pub fn build(self) -> crate::output::RemoveListenerCertificatesOutput {
            crate::output::RemoveListenerCertificatesOutput {}
        }
    }
}
impl RemoveListenerCertificatesOutput {
    /// Creates a new builder-style object to manufacture [`RemoveListenerCertificatesOutput`](crate::output::RemoveListenerCertificatesOutput)
    pub fn builder() -> crate::output::remove_listener_certificates_output::Builder {
        crate::output::remove_listener_certificates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterTargetsOutput {}
impl std::fmt::Debug for RegisterTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterTargetsOutput");
        formatter.finish()
    }
}
/// See [`RegisterTargetsOutput`](crate::output::RegisterTargetsOutput)
pub mod register_targets_output {
    /// A builder for [`RegisterTargetsOutput`](crate::output::RegisterTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RegisterTargetsOutput`](crate::output::RegisterTargetsOutput)
        pub fn build(self) -> crate::output::RegisterTargetsOutput {
            crate::output::RegisterTargetsOutput {}
        }
    }
}
impl RegisterTargetsOutput {
    /// Creates a new builder-style object to manufacture [`RegisterTargetsOutput`](crate::output::RegisterTargetsOutput)
    pub fn builder() -> crate::output::register_targets_output::Builder {
        crate::output::register_targets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyTargetGroupAttributesOutput {
    /// <p>Information about the attributes.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::TargetGroupAttribute>>,
}
impl std::fmt::Debug for ModifyTargetGroupAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyTargetGroupAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`ModifyTargetGroupAttributesOutput`](crate::output::ModifyTargetGroupAttributesOutput)
pub mod modify_target_group_attributes_output {
    /// A builder for [`ModifyTargetGroupAttributesOutput`](crate::output::ModifyTargetGroupAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::TargetGroupAttribute>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Information about the attributes.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::TargetGroupAttribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>Information about the attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetGroupAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyTargetGroupAttributesOutput`](crate::output::ModifyTargetGroupAttributesOutput)
        pub fn build(self) -> crate::output::ModifyTargetGroupAttributesOutput {
            crate::output::ModifyTargetGroupAttributesOutput {
                attributes: self.attributes,
            }
        }
    }
}
impl ModifyTargetGroupAttributesOutput {
    /// Creates a new builder-style object to manufacture [`ModifyTargetGroupAttributesOutput`](crate::output::ModifyTargetGroupAttributesOutput)
    pub fn builder() -> crate::output::modify_target_group_attributes_output::Builder {
        crate::output::modify_target_group_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyTargetGroupOutput {
    /// <p>Information about the modified target group.</p>
    pub target_groups: std::option::Option<std::vec::Vec<crate::model::TargetGroup>>,
}
impl std::fmt::Debug for ModifyTargetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyTargetGroupOutput");
        formatter.field("target_groups", &self.target_groups);
        formatter.finish()
    }
}
/// See [`ModifyTargetGroupOutput`](crate::output::ModifyTargetGroupOutput)
pub mod modify_target_group_output {
    /// A builder for [`ModifyTargetGroupOutput`](crate::output::ModifyTargetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_groups: std::option::Option<std::vec::Vec<crate::model::TargetGroup>>,
    }
    impl Builder {
        /// Appends an item to `target_groups`.
        ///
        /// To override the contents of this collection use [`set_target_groups`](Self::set_target_groups).
        ///
        /// <p>Information about the modified target group.</p>
        pub fn target_groups(mut self, input: impl Into<crate::model::TargetGroup>) -> Self {
            let mut v = self.target_groups.unwrap_or_default();
            v.push(input.into());
            self.target_groups = Some(v);
            self
        }
        /// <p>Information about the modified target group.</p>
        pub fn set_target_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetGroup>>,
        ) -> Self {
            self.target_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyTargetGroupOutput`](crate::output::ModifyTargetGroupOutput)
        pub fn build(self) -> crate::output::ModifyTargetGroupOutput {
            crate::output::ModifyTargetGroupOutput {
                target_groups: self.target_groups,
            }
        }
    }
}
impl ModifyTargetGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyTargetGroupOutput`](crate::output::ModifyTargetGroupOutput)
    pub fn builder() -> crate::output::modify_target_group_output::Builder {
        crate::output::modify_target_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyRuleOutput {
    /// <p>Information about the modified rule.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
}
impl std::fmt::Debug for ModifyRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyRuleOutput");
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`ModifyRuleOutput`](crate::output::ModifyRuleOutput)
pub mod modify_rule_output {
    /// A builder for [`ModifyRuleOutput`](crate::output::ModifyRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Information about the modified rule.</p>
        pub fn rules(mut self, input: impl Into<crate::model::Rule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>Information about the modified rule.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyRuleOutput`](crate::output::ModifyRuleOutput)
        pub fn build(self) -> crate::output::ModifyRuleOutput {
            crate::output::ModifyRuleOutput { rules: self.rules }
        }
    }
}
impl ModifyRuleOutput {
    /// Creates a new builder-style object to manufacture [`ModifyRuleOutput`](crate::output::ModifyRuleOutput)
    pub fn builder() -> crate::output::modify_rule_output::Builder {
        crate::output::modify_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyLoadBalancerAttributesOutput {
    /// <p>Information about the load balancer attributes.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::LoadBalancerAttribute>>,
}
impl std::fmt::Debug for ModifyLoadBalancerAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyLoadBalancerAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`ModifyLoadBalancerAttributesOutput`](crate::output::ModifyLoadBalancerAttributesOutput)
pub mod modify_load_balancer_attributes_output {
    /// A builder for [`ModifyLoadBalancerAttributesOutput`](crate::output::ModifyLoadBalancerAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::LoadBalancerAttribute>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Information about the load balancer attributes.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::LoadBalancerAttribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>Information about the load balancer attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancerAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyLoadBalancerAttributesOutput`](crate::output::ModifyLoadBalancerAttributesOutput)
        pub fn build(self) -> crate::output::ModifyLoadBalancerAttributesOutput {
            crate::output::ModifyLoadBalancerAttributesOutput {
                attributes: self.attributes,
            }
        }
    }
}
impl ModifyLoadBalancerAttributesOutput {
    /// Creates a new builder-style object to manufacture [`ModifyLoadBalancerAttributesOutput`](crate::output::ModifyLoadBalancerAttributesOutput)
    pub fn builder() -> crate::output::modify_load_balancer_attributes_output::Builder {
        crate::output::modify_load_balancer_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyListenerOutput {
    /// <p>Information about the modified listener.</p>
    pub listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
}
impl std::fmt::Debug for ModifyListenerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyListenerOutput");
        formatter.field("listeners", &self.listeners);
        formatter.finish()
    }
}
/// See [`ModifyListenerOutput`](crate::output::ModifyListenerOutput)
pub mod modify_listener_output {
    /// A builder for [`ModifyListenerOutput`](crate::output::ModifyListenerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
    }
    impl Builder {
        /// Appends an item to `listeners`.
        ///
        /// To override the contents of this collection use [`set_listeners`](Self::set_listeners).
        ///
        /// <p>Information about the modified listener.</p>
        pub fn listeners(mut self, input: impl Into<crate::model::Listener>) -> Self {
            let mut v = self.listeners.unwrap_or_default();
            v.push(input.into());
            self.listeners = Some(v);
            self
        }
        /// <p>Information about the modified listener.</p>
        pub fn set_listeners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Listener>>,
        ) -> Self {
            self.listeners = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyListenerOutput`](crate::output::ModifyListenerOutput)
        pub fn build(self) -> crate::output::ModifyListenerOutput {
            crate::output::ModifyListenerOutput {
                listeners: self.listeners,
            }
        }
    }
}
impl ModifyListenerOutput {
    /// Creates a new builder-style object to manufacture [`ModifyListenerOutput`](crate::output::ModifyListenerOutput)
    pub fn builder() -> crate::output::modify_listener_output::Builder {
        crate::output::modify_listener_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTargetHealthOutput {
    /// <p>Information about the health of the targets.</p>
    pub target_health_descriptions:
        std::option::Option<std::vec::Vec<crate::model::TargetHealthDescription>>,
}
impl std::fmt::Debug for DescribeTargetHealthOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTargetHealthOutput");
        formatter.field(
            "target_health_descriptions",
            &self.target_health_descriptions,
        );
        formatter.finish()
    }
}
/// See [`DescribeTargetHealthOutput`](crate::output::DescribeTargetHealthOutput)
pub mod describe_target_health_output {
    /// A builder for [`DescribeTargetHealthOutput`](crate::output::DescribeTargetHealthOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_health_descriptions:
            std::option::Option<std::vec::Vec<crate::model::TargetHealthDescription>>,
    }
    impl Builder {
        /// Appends an item to `target_health_descriptions`.
        ///
        /// To override the contents of this collection use [`set_target_health_descriptions`](Self::set_target_health_descriptions).
        ///
        /// <p>Information about the health of the targets.</p>
        pub fn target_health_descriptions(
            mut self,
            input: impl Into<crate::model::TargetHealthDescription>,
        ) -> Self {
            let mut v = self.target_health_descriptions.unwrap_or_default();
            v.push(input.into());
            self.target_health_descriptions = Some(v);
            self
        }
        /// <p>Information about the health of the targets.</p>
        pub fn set_target_health_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetHealthDescription>>,
        ) -> Self {
            self.target_health_descriptions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTargetHealthOutput`](crate::output::DescribeTargetHealthOutput)
        pub fn build(self) -> crate::output::DescribeTargetHealthOutput {
            crate::output::DescribeTargetHealthOutput {
                target_health_descriptions: self.target_health_descriptions,
            }
        }
    }
}
impl DescribeTargetHealthOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTargetHealthOutput`](crate::output::DescribeTargetHealthOutput)
    pub fn builder() -> crate::output::describe_target_health_output::Builder {
        crate::output::describe_target_health_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTargetGroupsOutput {
    /// <p>Information about the target groups.</p>
    pub target_groups: std::option::Option<std::vec::Vec<crate::model::TargetGroup>>,
    /// <p>If there are additional results, this is the marker for the next set of results.
    /// Otherwise, this is null.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeTargetGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTargetGroupsOutput");
        formatter.field("target_groups", &self.target_groups);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`DescribeTargetGroupsOutput`](crate::output::DescribeTargetGroupsOutput)
pub mod describe_target_groups_output {
    /// A builder for [`DescribeTargetGroupsOutput`](crate::output::DescribeTargetGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_groups: std::option::Option<std::vec::Vec<crate::model::TargetGroup>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `target_groups`.
        ///
        /// To override the contents of this collection use [`set_target_groups`](Self::set_target_groups).
        ///
        /// <p>Information about the target groups.</p>
        pub fn target_groups(mut self, input: impl Into<crate::model::TargetGroup>) -> Self {
            let mut v = self.target_groups.unwrap_or_default();
            v.push(input.into());
            self.target_groups = Some(v);
            self
        }
        /// <p>Information about the target groups.</p>
        pub fn set_target_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetGroup>>,
        ) -> Self {
            self.target_groups = input;
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTargetGroupsOutput`](crate::output::DescribeTargetGroupsOutput)
        pub fn build(self) -> crate::output::DescribeTargetGroupsOutput {
            crate::output::DescribeTargetGroupsOutput {
                target_groups: self.target_groups,
                next_marker: self.next_marker,
            }
        }
    }
}
impl DescribeTargetGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTargetGroupsOutput`](crate::output::DescribeTargetGroupsOutput)
    pub fn builder() -> crate::output::describe_target_groups_output::Builder {
        crate::output::describe_target_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTargetGroupAttributesOutput {
    /// <p>Information about the target group attributes</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::TargetGroupAttribute>>,
}
impl std::fmt::Debug for DescribeTargetGroupAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTargetGroupAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`DescribeTargetGroupAttributesOutput`](crate::output::DescribeTargetGroupAttributesOutput)
pub mod describe_target_group_attributes_output {
    /// A builder for [`DescribeTargetGroupAttributesOutput`](crate::output::DescribeTargetGroupAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::TargetGroupAttribute>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Information about the target group attributes</p>
        pub fn attributes(mut self, input: impl Into<crate::model::TargetGroupAttribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>Information about the target group attributes</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetGroupAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTargetGroupAttributesOutput`](crate::output::DescribeTargetGroupAttributesOutput)
        pub fn build(self) -> crate::output::DescribeTargetGroupAttributesOutput {
            crate::output::DescribeTargetGroupAttributesOutput {
                attributes: self.attributes,
            }
        }
    }
}
impl DescribeTargetGroupAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTargetGroupAttributesOutput`](crate::output::DescribeTargetGroupAttributesOutput)
    pub fn builder() -> crate::output::describe_target_group_attributes_output::Builder {
        crate::output::describe_target_group_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagsOutput {
    /// <p>Information about the tags.</p>
    pub tag_descriptions: std::option::Option<std::vec::Vec<crate::model::TagDescription>>,
}
impl std::fmt::Debug for DescribeTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagsOutput");
        formatter.field("tag_descriptions", &self.tag_descriptions);
        formatter.finish()
    }
}
/// See [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
pub mod describe_tags_output {
    /// A builder for [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_descriptions:
            std::option::Option<std::vec::Vec<crate::model::TagDescription>>,
    }
    impl Builder {
        /// Appends an item to `tag_descriptions`.
        ///
        /// To override the contents of this collection use [`set_tag_descriptions`](Self::set_tag_descriptions).
        ///
        /// <p>Information about the tags.</p>
        pub fn tag_descriptions(mut self, input: impl Into<crate::model::TagDescription>) -> Self {
            let mut v = self.tag_descriptions.unwrap_or_default();
            v.push(input.into());
            self.tag_descriptions = Some(v);
            self
        }
        /// <p>Information about the tags.</p>
        pub fn set_tag_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagDescription>>,
        ) -> Self {
            self.tag_descriptions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
        pub fn build(self) -> crate::output::DescribeTagsOutput {
            crate::output::DescribeTagsOutput {
                tag_descriptions: self.tag_descriptions,
            }
        }
    }
}
impl DescribeTagsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
    pub fn builder() -> crate::output::describe_tags_output::Builder {
        crate::output::describe_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSslPoliciesOutput {
    /// <p>Information about the security policies.</p>
    pub ssl_policies: std::option::Option<std::vec::Vec<crate::model::SslPolicy>>,
    /// <p>If there are additional results, this is the marker for the next set of results.
    /// Otherwise, this is null.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeSslPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSslPoliciesOutput");
        formatter.field("ssl_policies", &self.ssl_policies);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`DescribeSslPoliciesOutput`](crate::output::DescribeSslPoliciesOutput)
pub mod describe_ssl_policies_output {
    /// A builder for [`DescribeSslPoliciesOutput`](crate::output::DescribeSslPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ssl_policies: std::option::Option<std::vec::Vec<crate::model::SslPolicy>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ssl_policies`.
        ///
        /// To override the contents of this collection use [`set_ssl_policies`](Self::set_ssl_policies).
        ///
        /// <p>Information about the security policies.</p>
        pub fn ssl_policies(mut self, input: impl Into<crate::model::SslPolicy>) -> Self {
            let mut v = self.ssl_policies.unwrap_or_default();
            v.push(input.into());
            self.ssl_policies = Some(v);
            self
        }
        /// <p>Information about the security policies.</p>
        pub fn set_ssl_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SslPolicy>>,
        ) -> Self {
            self.ssl_policies = input;
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSslPoliciesOutput`](crate::output::DescribeSslPoliciesOutput)
        pub fn build(self) -> crate::output::DescribeSslPoliciesOutput {
            crate::output::DescribeSslPoliciesOutput {
                ssl_policies: self.ssl_policies,
                next_marker: self.next_marker,
            }
        }
    }
}
impl DescribeSslPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSslPoliciesOutput`](crate::output::DescribeSslPoliciesOutput)
    pub fn builder() -> crate::output::describe_ssl_policies_output::Builder {
        crate::output::describe_ssl_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRulesOutput {
    /// <p>Information about the rules.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    /// <p>If there are additional results, this is the marker for the next set of results.
    /// Otherwise, this is null.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRulesOutput");
        formatter.field("rules", &self.rules);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`DescribeRulesOutput`](crate::output::DescribeRulesOutput)
pub mod describe_rules_output {
    /// A builder for [`DescribeRulesOutput`](crate::output::DescribeRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Information about the rules.</p>
        pub fn rules(mut self, input: impl Into<crate::model::Rule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>Information about the rules.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRulesOutput`](crate::output::DescribeRulesOutput)
        pub fn build(self) -> crate::output::DescribeRulesOutput {
            crate::output::DescribeRulesOutput {
                rules: self.rules,
                next_marker: self.next_marker,
            }
        }
    }
}
impl DescribeRulesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRulesOutput`](crate::output::DescribeRulesOutput)
    pub fn builder() -> crate::output::describe_rules_output::Builder {
        crate::output::describe_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoadBalancersOutput {
    /// <p>Information about the load balancers.</p>
    pub load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
    /// <p>If there are additional results, this is the marker for the next set of results.
    /// Otherwise, this is null.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeLoadBalancersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoadBalancersOutput");
        formatter.field("load_balancers", &self.load_balancers);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`DescribeLoadBalancersOutput`](crate::output::DescribeLoadBalancersOutput)
pub mod describe_load_balancers_output {
    /// A builder for [`DescribeLoadBalancersOutput`](crate::output::DescribeLoadBalancersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `load_balancers`.
        ///
        /// To override the contents of this collection use [`set_load_balancers`](Self::set_load_balancers).
        ///
        /// <p>Information about the load balancers.</p>
        pub fn load_balancers(mut self, input: impl Into<crate::model::LoadBalancer>) -> Self {
            let mut v = self.load_balancers.unwrap_or_default();
            v.push(input.into());
            self.load_balancers = Some(v);
            self
        }
        /// <p>Information about the load balancers.</p>
        pub fn set_load_balancers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        ) -> Self {
            self.load_balancers = input;
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoadBalancersOutput`](crate::output::DescribeLoadBalancersOutput)
        pub fn build(self) -> crate::output::DescribeLoadBalancersOutput {
            crate::output::DescribeLoadBalancersOutput {
                load_balancers: self.load_balancers,
                next_marker: self.next_marker,
            }
        }
    }
}
impl DescribeLoadBalancersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancersOutput`](crate::output::DescribeLoadBalancersOutput)
    pub fn builder() -> crate::output::describe_load_balancers_output::Builder {
        crate::output::describe_load_balancers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoadBalancerAttributesOutput {
    /// <p>Information about the load balancer attributes.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::LoadBalancerAttribute>>,
}
impl std::fmt::Debug for DescribeLoadBalancerAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoadBalancerAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`DescribeLoadBalancerAttributesOutput`](crate::output::DescribeLoadBalancerAttributesOutput)
pub mod describe_load_balancer_attributes_output {
    /// A builder for [`DescribeLoadBalancerAttributesOutput`](crate::output::DescribeLoadBalancerAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::LoadBalancerAttribute>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Information about the load balancer attributes.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::LoadBalancerAttribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>Information about the load balancer attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancerAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoadBalancerAttributesOutput`](crate::output::DescribeLoadBalancerAttributesOutput)
        pub fn build(self) -> crate::output::DescribeLoadBalancerAttributesOutput {
            crate::output::DescribeLoadBalancerAttributesOutput {
                attributes: self.attributes,
            }
        }
    }
}
impl DescribeLoadBalancerAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancerAttributesOutput`](crate::output::DescribeLoadBalancerAttributesOutput)
    pub fn builder() -> crate::output::describe_load_balancer_attributes_output::Builder {
        crate::output::describe_load_balancer_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeListenersOutput {
    /// <p>Information about the listeners.</p>
    pub listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
    /// <p>If there are additional results, this is the marker for the next set of results.
    /// Otherwise, this is null.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeListenersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeListenersOutput");
        formatter.field("listeners", &self.listeners);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`DescribeListenersOutput`](crate::output::DescribeListenersOutput)
pub mod describe_listeners_output {
    /// A builder for [`DescribeListenersOutput`](crate::output::DescribeListenersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `listeners`.
        ///
        /// To override the contents of this collection use [`set_listeners`](Self::set_listeners).
        ///
        /// <p>Information about the listeners.</p>
        pub fn listeners(mut self, input: impl Into<crate::model::Listener>) -> Self {
            let mut v = self.listeners.unwrap_or_default();
            v.push(input.into());
            self.listeners = Some(v);
            self
        }
        /// <p>Information about the listeners.</p>
        pub fn set_listeners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Listener>>,
        ) -> Self {
            self.listeners = input;
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeListenersOutput`](crate::output::DescribeListenersOutput)
        pub fn build(self) -> crate::output::DescribeListenersOutput {
            crate::output::DescribeListenersOutput {
                listeners: self.listeners,
                next_marker: self.next_marker,
            }
        }
    }
}
impl DescribeListenersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeListenersOutput`](crate::output::DescribeListenersOutput)
    pub fn builder() -> crate::output::describe_listeners_output::Builder {
        crate::output::describe_listeners_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeListenerCertificatesOutput {
    /// <p>Information about the certificates.</p>
    pub certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
    /// <p>If there are additional results, this is the marker for the next set of results.
    /// Otherwise, this is null.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeListenerCertificatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeListenerCertificatesOutput");
        formatter.field("certificates", &self.certificates);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`DescribeListenerCertificatesOutput`](crate::output::DescribeListenerCertificatesOutput)
pub mod describe_listener_certificates_output {
    /// A builder for [`DescribeListenerCertificatesOutput`](crate::output::DescribeListenerCertificatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>Information about the certificates.</p>
        pub fn certificates(mut self, input: impl Into<crate::model::Certificate>) -> Self {
            let mut v = self.certificates.unwrap_or_default();
            v.push(input.into());
            self.certificates = Some(v);
            self
        }
        /// <p>Information about the certificates.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.certificates = input;
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeListenerCertificatesOutput`](crate::output::DescribeListenerCertificatesOutput)
        pub fn build(self) -> crate::output::DescribeListenerCertificatesOutput {
            crate::output::DescribeListenerCertificatesOutput {
                certificates: self.certificates,
                next_marker: self.next_marker,
            }
        }
    }
}
impl DescribeListenerCertificatesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeListenerCertificatesOutput`](crate::output::DescribeListenerCertificatesOutput)
    pub fn builder() -> crate::output::describe_listener_certificates_output::Builder {
        crate::output::describe_listener_certificates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountLimitsOutput {
    /// <p>Information about the limits.</p>
    pub limits: std::option::Option<std::vec::Vec<crate::model::Limit>>,
    /// <p>If there are additional results, this is the marker for the next set of results.
    /// Otherwise, this is null.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeAccountLimitsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountLimitsOutput");
        formatter.field("limits", &self.limits);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`DescribeAccountLimitsOutput`](crate::output::DescribeAccountLimitsOutput)
pub mod describe_account_limits_output {
    /// A builder for [`DescribeAccountLimitsOutput`](crate::output::DescribeAccountLimitsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limits: std::option::Option<std::vec::Vec<crate::model::Limit>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `limits`.
        ///
        /// To override the contents of this collection use [`set_limits`](Self::set_limits).
        ///
        /// <p>Information about the limits.</p>
        pub fn limits(mut self, input: impl Into<crate::model::Limit>) -> Self {
            let mut v = self.limits.unwrap_or_default();
            v.push(input.into());
            self.limits = Some(v);
            self
        }
        /// <p>Information about the limits.</p>
        pub fn set_limits(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Limit>>,
        ) -> Self {
            self.limits = input;
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the marker for the next set of results.
        /// Otherwise, this is null.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountLimitsOutput`](crate::output::DescribeAccountLimitsOutput)
        pub fn build(self) -> crate::output::DescribeAccountLimitsOutput {
            crate::output::DescribeAccountLimitsOutput {
                limits: self.limits,
                next_marker: self.next_marker,
            }
        }
    }
}
impl DescribeAccountLimitsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccountLimitsOutput`](crate::output::DescribeAccountLimitsOutput)
    pub fn builder() -> crate::output::describe_account_limits_output::Builder {
        crate::output::describe_account_limits_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterTargetsOutput {}
impl std::fmt::Debug for DeregisterTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterTargetsOutput");
        formatter.finish()
    }
}
/// See [`DeregisterTargetsOutput`](crate::output::DeregisterTargetsOutput)
pub mod deregister_targets_output {
    /// A builder for [`DeregisterTargetsOutput`](crate::output::DeregisterTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterTargetsOutput`](crate::output::DeregisterTargetsOutput)
        pub fn build(self) -> crate::output::DeregisterTargetsOutput {
            crate::output::DeregisterTargetsOutput {}
        }
    }
}
impl DeregisterTargetsOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterTargetsOutput`](crate::output::DeregisterTargetsOutput)
    pub fn builder() -> crate::output::deregister_targets_output::Builder {
        crate::output::deregister_targets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTargetGroupOutput {}
impl std::fmt::Debug for DeleteTargetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTargetGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteTargetGroupOutput`](crate::output::DeleteTargetGroupOutput)
pub mod delete_target_group_output {
    /// A builder for [`DeleteTargetGroupOutput`](crate::output::DeleteTargetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTargetGroupOutput`](crate::output::DeleteTargetGroupOutput)
        pub fn build(self) -> crate::output::DeleteTargetGroupOutput {
            crate::output::DeleteTargetGroupOutput {}
        }
    }
}
impl DeleteTargetGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTargetGroupOutput`](crate::output::DeleteTargetGroupOutput)
    pub fn builder() -> crate::output::delete_target_group_output::Builder {
        crate::output::delete_target_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRuleOutput {}
impl std::fmt::Debug for DeleteRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRuleOutput");
        formatter.finish()
    }
}
/// See [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
pub mod delete_rule_output {
    /// A builder for [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
        pub fn build(self) -> crate::output::DeleteRuleOutput {
            crate::output::DeleteRuleOutput {}
        }
    }
}
impl DeleteRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
    pub fn builder() -> crate::output::delete_rule_output::Builder {
        crate::output::delete_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLoadBalancerOutput {}
impl std::fmt::Debug for DeleteLoadBalancerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLoadBalancerOutput");
        formatter.finish()
    }
}
/// See [`DeleteLoadBalancerOutput`](crate::output::DeleteLoadBalancerOutput)
pub mod delete_load_balancer_output {
    /// A builder for [`DeleteLoadBalancerOutput`](crate::output::DeleteLoadBalancerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteLoadBalancerOutput`](crate::output::DeleteLoadBalancerOutput)
        pub fn build(self) -> crate::output::DeleteLoadBalancerOutput {
            crate::output::DeleteLoadBalancerOutput {}
        }
    }
}
impl DeleteLoadBalancerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLoadBalancerOutput`](crate::output::DeleteLoadBalancerOutput)
    pub fn builder() -> crate::output::delete_load_balancer_output::Builder {
        crate::output::delete_load_balancer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteListenerOutput {}
impl std::fmt::Debug for DeleteListenerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteListenerOutput");
        formatter.finish()
    }
}
/// See [`DeleteListenerOutput`](crate::output::DeleteListenerOutput)
pub mod delete_listener_output {
    /// A builder for [`DeleteListenerOutput`](crate::output::DeleteListenerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteListenerOutput`](crate::output::DeleteListenerOutput)
        pub fn build(self) -> crate::output::DeleteListenerOutput {
            crate::output::DeleteListenerOutput {}
        }
    }
}
impl DeleteListenerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteListenerOutput`](crate::output::DeleteListenerOutput)
    pub fn builder() -> crate::output::delete_listener_output::Builder {
        crate::output::delete_listener_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTargetGroupOutput {
    /// <p>Information about the target group.</p>
    pub target_groups: std::option::Option<std::vec::Vec<crate::model::TargetGroup>>,
}
impl std::fmt::Debug for CreateTargetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTargetGroupOutput");
        formatter.field("target_groups", &self.target_groups);
        formatter.finish()
    }
}
/// See [`CreateTargetGroupOutput`](crate::output::CreateTargetGroupOutput)
pub mod create_target_group_output {
    /// A builder for [`CreateTargetGroupOutput`](crate::output::CreateTargetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_groups: std::option::Option<std::vec::Vec<crate::model::TargetGroup>>,
    }
    impl Builder {
        /// Appends an item to `target_groups`.
        ///
        /// To override the contents of this collection use [`set_target_groups`](Self::set_target_groups).
        ///
        /// <p>Information about the target group.</p>
        pub fn target_groups(mut self, input: impl Into<crate::model::TargetGroup>) -> Self {
            let mut v = self.target_groups.unwrap_or_default();
            v.push(input.into());
            self.target_groups = Some(v);
            self
        }
        /// <p>Information about the target group.</p>
        pub fn set_target_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetGroup>>,
        ) -> Self {
            self.target_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTargetGroupOutput`](crate::output::CreateTargetGroupOutput)
        pub fn build(self) -> crate::output::CreateTargetGroupOutput {
            crate::output::CreateTargetGroupOutput {
                target_groups: self.target_groups,
            }
        }
    }
}
impl CreateTargetGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateTargetGroupOutput`](crate::output::CreateTargetGroupOutput)
    pub fn builder() -> crate::output::create_target_group_output::Builder {
        crate::output::create_target_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRuleOutput {
    /// <p>Information about the rule.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
}
impl std::fmt::Debug for CreateRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRuleOutput");
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`CreateRuleOutput`](crate::output::CreateRuleOutput)
pub mod create_rule_output {
    /// A builder for [`CreateRuleOutput`](crate::output::CreateRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Information about the rule.</p>
        pub fn rules(mut self, input: impl Into<crate::model::Rule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>Information about the rule.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRuleOutput`](crate::output::CreateRuleOutput)
        pub fn build(self) -> crate::output::CreateRuleOutput {
            crate::output::CreateRuleOutput { rules: self.rules }
        }
    }
}
impl CreateRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreateRuleOutput`](crate::output::CreateRuleOutput)
    pub fn builder() -> crate::output::create_rule_output::Builder {
        crate::output::create_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLoadBalancerOutput {
    /// <p>Information about the load balancer.</p>
    pub load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
}
impl std::fmt::Debug for CreateLoadBalancerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLoadBalancerOutput");
        formatter.field("load_balancers", &self.load_balancers);
        formatter.finish()
    }
}
/// See [`CreateLoadBalancerOutput`](crate::output::CreateLoadBalancerOutput)
pub mod create_load_balancer_output {
    /// A builder for [`CreateLoadBalancerOutput`](crate::output::CreateLoadBalancerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
    }
    impl Builder {
        /// Appends an item to `load_balancers`.
        ///
        /// To override the contents of this collection use [`set_load_balancers`](Self::set_load_balancers).
        ///
        /// <p>Information about the load balancer.</p>
        pub fn load_balancers(mut self, input: impl Into<crate::model::LoadBalancer>) -> Self {
            let mut v = self.load_balancers.unwrap_or_default();
            v.push(input.into());
            self.load_balancers = Some(v);
            self
        }
        /// <p>Information about the load balancer.</p>
        pub fn set_load_balancers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        ) -> Self {
            self.load_balancers = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLoadBalancerOutput`](crate::output::CreateLoadBalancerOutput)
        pub fn build(self) -> crate::output::CreateLoadBalancerOutput {
            crate::output::CreateLoadBalancerOutput {
                load_balancers: self.load_balancers,
            }
        }
    }
}
impl CreateLoadBalancerOutput {
    /// Creates a new builder-style object to manufacture [`CreateLoadBalancerOutput`](crate::output::CreateLoadBalancerOutput)
    pub fn builder() -> crate::output::create_load_balancer_output::Builder {
        crate::output::create_load_balancer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateListenerOutput {
    /// <p>Information about the listener.</p>
    pub listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
}
impl std::fmt::Debug for CreateListenerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateListenerOutput");
        formatter.field("listeners", &self.listeners);
        formatter.finish()
    }
}
/// See [`CreateListenerOutput`](crate::output::CreateListenerOutput)
pub mod create_listener_output {
    /// A builder for [`CreateListenerOutput`](crate::output::CreateListenerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
    }
    impl Builder {
        /// Appends an item to `listeners`.
        ///
        /// To override the contents of this collection use [`set_listeners`](Self::set_listeners).
        ///
        /// <p>Information about the listener.</p>
        pub fn listeners(mut self, input: impl Into<crate::model::Listener>) -> Self {
            let mut v = self.listeners.unwrap_or_default();
            v.push(input.into());
            self.listeners = Some(v);
            self
        }
        /// <p>Information about the listener.</p>
        pub fn set_listeners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Listener>>,
        ) -> Self {
            self.listeners = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateListenerOutput`](crate::output::CreateListenerOutput)
        pub fn build(self) -> crate::output::CreateListenerOutput {
            crate::output::CreateListenerOutput {
                listeners: self.listeners,
            }
        }
    }
}
impl CreateListenerOutput {
    /// Creates a new builder-style object to manufacture [`CreateListenerOutput`](crate::output::CreateListenerOutput)
    pub fn builder() -> crate::output::create_listener_output::Builder {
        crate::output::create_listener_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsOutput {}
impl std::fmt::Debug for AddTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsOutput");
        formatter.finish()
    }
}
/// See [`AddTagsOutput`](crate::output::AddTagsOutput)
pub mod add_tags_output {
    /// A builder for [`AddTagsOutput`](crate::output::AddTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddTagsOutput`](crate::output::AddTagsOutput)
        pub fn build(self) -> crate::output::AddTagsOutput {
            crate::output::AddTagsOutput {}
        }
    }
}
impl AddTagsOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsOutput`](crate::output::AddTagsOutput)
    pub fn builder() -> crate::output::add_tags_output::Builder {
        crate::output::add_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddListenerCertificatesOutput {
    /// <p>Information about the certificates in the certificate list.</p>
    pub certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
}
impl std::fmt::Debug for AddListenerCertificatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddListenerCertificatesOutput");
        formatter.field("certificates", &self.certificates);
        formatter.finish()
    }
}
/// See [`AddListenerCertificatesOutput`](crate::output::AddListenerCertificatesOutput)
pub mod add_listener_certificates_output {
    /// A builder for [`AddListenerCertificatesOutput`](crate::output::AddListenerCertificatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
    }
    impl Builder {
        /// Appends an item to `certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>Information about the certificates in the certificate list.</p>
        pub fn certificates(mut self, input: impl Into<crate::model::Certificate>) -> Self {
            let mut v = self.certificates.unwrap_or_default();
            v.push(input.into());
            self.certificates = Some(v);
            self
        }
        /// <p>Information about the certificates in the certificate list.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.certificates = input;
            self
        }
        /// Consumes the builder and constructs a [`AddListenerCertificatesOutput`](crate::output::AddListenerCertificatesOutput)
        pub fn build(self) -> crate::output::AddListenerCertificatesOutput {
            crate::output::AddListenerCertificatesOutput {
                certificates: self.certificates,
            }
        }
    }
}
impl AddListenerCertificatesOutput {
    /// Creates a new builder-style object to manufacture [`AddListenerCertificatesOutput`](crate::output::AddListenerCertificatesOutput)
    pub fn builder() -> crate::output::add_listener_certificates_output::Builder {
        crate::output::add_listener_certificates_output::Builder::default()
    }
}
