// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddListenerCertificatesInput`](crate::input::AddListenerCertificatesInput)
pub mod add_listener_certificates_input {
    /// A builder for [`AddListenerCertificatesInput`](crate::input::AddListenerCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// Appends an item to `certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>The certificate to add. You can specify one certificate per call. Set
        /// <code>CertificateArn</code> to the certificate ARN but do not set
        /// <code>IsDefault</code>.</p>
        pub fn certificates(mut self, input: impl Into<crate::model::Certificate>) -> Self {
            let mut v = self.certificates.unwrap_or_default();
            v.push(input.into());
            self.certificates = Some(v);
            self
        }
        /// <p>The certificate to add. You can specify one certificate per call. Set
        /// <code>CertificateArn</code> to the certificate ARN but do not set
        /// <code>IsDefault</code>.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.certificates = input;
            self
        }
        /// Consumes the builder and constructs a [`AddListenerCertificatesInput`](crate::input::AddListenerCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddListenerCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddListenerCertificatesInput {
                listener_arn: self.listener_arn,
                certificates: self.certificates,
            })
        }
    }
}
#[doc(hidden)]
pub type AddListenerCertificatesInputOperationOutputAlias =
    crate::operation::AddListenerCertificates;
#[doc(hidden)]
pub type AddListenerCertificatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddListenerCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`AddListenerCertificates`](crate::operation::AddListenerCertificates)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddListenerCertificates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddListenerCertificatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddListenerCertificatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddListenerCertificatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_listener_certificates(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddListenerCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddListenerCertificates",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddListenerCertificatesInput`](crate::input::AddListenerCertificatesInput)
    pub fn builder() -> crate::input::add_listener_certificates_input::Builder {
        crate::input::add_listener_certificates_input::Builder::default()
    }
}

/// See [`AddTagsInput`](crate::input::AddTagsInput)
pub mod add_tags_input {
    /// A builder for [`AddTagsInput`](crate::input::AddTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsInput`](crate::input::AddTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::AddTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::AddTagsInput {
                resource_arns: self.resource_arns,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsInputOperationOutputAlias = crate::operation::AddTags;
#[doc(hidden)]
pub type AddTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsInput {
    /// Consumes the builder and constructs an Operation<[`AddTags`](crate::operation::AddTags)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_add_tags(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::AddTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "AddTags",
                    "elasticloadbalancingv2",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
}

/// See [`CreateListenerInput`](crate::input::CreateListenerInput)
pub mod create_listener_input {
    /// A builder for [`CreateListenerInput`](crate::input::CreateListenerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_arn: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<crate::model::ProtocolEnum>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) ssl_policy: std::option::Option<std::string::String>,
        pub(crate) certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        pub(crate) default_actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
        pub(crate) alpn_policy: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_arn = input;
            self
        }
        /// <p>The protocol for connections from clients to the load balancer. For Application Load
        /// Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the
        /// supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP
        /// protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load
        /// Balancer.</p>
        pub fn protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol for connections from clients to the load balancer. For Application Load
        /// Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the
        /// supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP
        /// protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load
        /// Balancer.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The port on which the load balancer is listening. You cannot specify a port for a Gateway
        /// Load Balancer.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port on which the load balancer is listening. You cannot specify a port for a Gateway
        /// Load Balancer.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are
        /// supported.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> and
        /// <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn ssl_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssl_policy = Some(input.into());
            self
        }
        /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are
        /// supported.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> and
        /// <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn set_ssl_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssl_policy = input;
            self
        }
        /// Appends an item to `certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide
        /// exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set
        /// <code>IsDefault</code>.</p>
        pub fn certificates(mut self, input: impl Into<crate::model::Certificate>) -> Self {
            let mut v = self.certificates.unwrap_or_default();
            v.push(input.into());
            self.certificates = Some(v);
            self
        }
        /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide
        /// exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set
        /// <code>IsDefault</code>.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.certificates = input;
            self
        }
        /// Appends an item to `default_actions`.
        ///
        /// To override the contents of this collection use [`set_default_actions`](Self::set_default_actions).
        ///
        /// <p>The actions for the default rule.</p>
        pub fn default_actions(mut self, input: impl Into<crate::model::Action>) -> Self {
            let mut v = self.default_actions.unwrap_or_default();
            v.push(input.into());
            self.default_actions = Some(v);
            self
        }
        /// <p>The actions for the default rule.</p>
        pub fn set_default_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.default_actions = input;
            self
        }
        /// Appends an item to `alpn_policy`.
        ///
        /// To override the contents of this collection use [`set_alpn_policy`](Self::set_alpn_policy).
        ///
        /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You
        /// can specify one policy name. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HTTP1Only</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HTTP2Only</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HTTP2Optional</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HTTP2Preferred</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>None</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN
        /// policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn alpn_policy(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.alpn_policy.unwrap_or_default();
            v.push(input.into());
            self.alpn_policy = Some(v);
            self
        }
        /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You
        /// can specify one policy name. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HTTP1Only</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HTTP2Only</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HTTP2Optional</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HTTP2Preferred</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>None</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN
        /// policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn set_alpn_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.alpn_policy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the listener.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to assign to the listener.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateListenerInput`](crate::input::CreateListenerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateListenerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateListenerInput {
                load_balancer_arn: self.load_balancer_arn,
                protocol: self.protocol,
                port: self.port,
                ssl_policy: self.ssl_policy,
                certificates: self.certificates,
                default_actions: self.default_actions,
                alpn_policy: self.alpn_policy,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateListenerInputOperationOutputAlias = crate::operation::CreateListener;
#[doc(hidden)]
pub type CreateListenerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateListenerInput {
    /// Consumes the builder and constructs an Operation<[`CreateListener`](crate::operation::CreateListener)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateListener,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateListenerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateListenerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateListenerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_listener(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateListener::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateListener",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateListenerInput`](crate::input::CreateListenerInput)
    pub fn builder() -> crate::input::create_listener_input::Builder {
        crate::input::create_listener_input::Builder::default()
    }
}

/// See [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
pub mod create_load_balancer_input {
    /// A builder for [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_mappings: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) scheme: std::option::Option<crate::model::LoadBalancerSchemeEnum>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) r#type: std::option::Option<crate::model::LoadBalancerTypeEnum>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
        pub(crate) customer_owned_ipv4_pool: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must
        /// contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must
        /// not begin with "internal-".</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must
        /// contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must
        /// not begin with "internal-".</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You
        /// must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability
        /// Zones.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local
        /// Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability
        /// Zones.</p>
        /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability
        /// Zones.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You
        /// must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability
        /// Zones.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local
        /// Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability
        /// Zones.</p>
        /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability
        /// Zones.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Appends an item to `subnet_mappings`.
        ///
        /// To override the contents of this collection use [`set_subnet_mappings`](Self::set_subnet_mappings).
        ///
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You
        /// must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability
        /// Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local
        /// Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You
        /// can specify one Elastic IP address per subnet if you need static IP addresses for your
        /// internet-facing load balancer. For internal load balancers, you can specify one private IP
        /// address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you
        /// can specify one IPv6 address per subnet.</p>
        /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You
        /// cannot specify Elastic IP addresses for your subnets.</p>
        pub fn subnet_mappings(mut self, input: impl Into<crate::model::SubnetMapping>) -> Self {
            let mut v = self.subnet_mappings.unwrap_or_default();
            v.push(input.into());
            self.subnet_mappings = Some(v);
            self
        }
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You
        /// must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability
        /// Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local
        /// Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You
        /// can specify one Elastic IP address per subnet if you need static IP addresses for your
        /// internet-facing load balancer. For internal load balancers, you can specify one private IP
        /// address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you
        /// can specify one IPv6 address per subnet.</p>
        /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You
        /// cannot specify Elastic IP addresses for your subnets.</p>
        pub fn set_subnet_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        ) -> Self {
            self.subnet_mappings = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>[Application Load Balancers] The IDs of the security groups for the load balancer.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>[Application Load Balancers] The IDs of the security groups for the load balancer.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an
        /// Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes.
        /// Therefore, Internet-facing load balancers can route requests from clients over the
        /// internet.</p>
        /// <p>The nodes of an internal load balancer have only private IP addresses. The DNS name of an
        /// internal load balancer is publicly resolvable to the private IP addresses of the nodes.
        /// Therefore, internal load balancers can route requests only from clients with access to the VPC
        /// for the load balancer.</p>
        /// <p>The default is an Internet-facing load balancer.</p>
        /// <p>You cannot specify a scheme for a Gateway Load Balancer.</p>
        pub fn scheme(mut self, input: crate::model::LoadBalancerSchemeEnum) -> Self {
            self.scheme = Some(input);
            self
        }
        /// <p>The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an
        /// Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes.
        /// Therefore, Internet-facing load balancers can route requests from clients over the
        /// internet.</p>
        /// <p>The nodes of an internal load balancer have only private IP addresses. The DNS name of an
        /// internal load balancer is publicly resolvable to the private IP addresses of the nodes.
        /// Therefore, internal load balancers can route requests only from clients with access to the VPC
        /// for the load balancer.</p>
        /// <p>The default is an Internet-facing load balancer.</p>
        /// <p>You cannot specify a scheme for a Gateway Load Balancer.</p>
        pub fn set_scheme(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerSchemeEnum>,
        ) -> Self {
            self.scheme = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the load balancer.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to assign to the load balancer.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The type of load balancer. The default is <code>application</code>.</p>
        pub fn r#type(mut self, input: crate::model::LoadBalancerTypeEnum) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of load balancer. The default is <code>application</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerTypeEnum>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The type of IP addresses used by the subnets for your load balancer. The possible values
        /// are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6
        /// addresses). Internal load balancers must use <code>ipv4</code>.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The type of IP addresses used by the subnets for your load balancer. The possible values
        /// are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6
        /// addresses). Internal load balancers must use <code>ipv4</code>.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// <p>[Application Load Balancers on Outposts] The ID of the customer-owned address pool (CoIP
        /// pool).</p>
        pub fn customer_owned_ipv4_pool(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_owned_ipv4_pool = Some(input.into());
            self
        }
        /// <p>[Application Load Balancers on Outposts] The ID of the customer-owned address pool (CoIP
        /// pool).</p>
        pub fn set_customer_owned_ipv4_pool(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_owned_ipv4_pool = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLoadBalancerInput {
                name: self.name,
                subnets: self.subnets,
                subnet_mappings: self.subnet_mappings,
                security_groups: self.security_groups,
                scheme: self.scheme,
                tags: self.tags,
                r#type: self.r#type,
                ip_address_type: self.ip_address_type,
                customer_owned_ipv4_pool: self.customer_owned_ipv4_pool,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLoadBalancerInputOperationOutputAlias = crate::operation::CreateLoadBalancer;
#[doc(hidden)]
pub type CreateLoadBalancerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`CreateLoadBalancer`](crate::operation::CreateLoadBalancer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLoadBalancer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLoadBalancerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLoadBalancerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLoadBalancerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_load_balancer(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLoadBalancer",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
    pub fn builder() -> crate::input::create_load_balancer_input::Builder {
        crate::input::create_load_balancer_input::Builder::default()
    }
}

/// See [`CreateRuleInput`](crate::input::CreateRuleInput)
pub mod create_rule_input {
    /// A builder for [`CreateRuleInput`](crate::input::CreateRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) conditions: std::option::Option<std::vec::Vec<crate::model::RuleCondition>>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// Appends an item to `conditions`.
        ///
        /// To override the contents of this collection use [`set_conditions`](Self::set_conditions).
        ///
        /// <p>The conditions.</p>
        pub fn conditions(mut self, input: impl Into<crate::model::RuleCondition>) -> Self {
            let mut v = self.conditions.unwrap_or_default();
            v.push(input.into());
            self.conditions = Some(v);
            self
        }
        /// <p>The conditions.</p>
        pub fn set_conditions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleCondition>>,
        ) -> Self {
            self.conditions = input;
            self
        }
        /// <p>The rule priority. A listener can't have multiple rules with the same priority.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The rule priority. A listener can't have multiple rules with the same priority.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions.</p>
        pub fn actions(mut self, input: impl Into<crate::model::Action>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The actions.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the rule.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to assign to the rule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRuleInput`](crate::input::CreateRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRuleInput {
                listener_arn: self.listener_arn,
                conditions: self.conditions,
                priority: self.priority,
                actions: self.actions,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRuleInputOperationOutputAlias = crate::operation::CreateRule;
#[doc(hidden)]
pub type CreateRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreateRule`](crate::operation::CreateRule)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_rule(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRule",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRuleInput`](crate::input::CreateRuleInput)
    pub fn builder() -> crate::input::create_rule_input::Builder {
        crate::input::create_rule_input::Builder::default()
    }
}

/// See [`CreateTargetGroupInput`](crate::input::CreateTargetGroupInput)
pub mod create_target_group_input {
    /// A builder for [`CreateTargetGroupInput`](crate::input::CreateTargetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<crate::model::ProtocolEnum>,
        pub(crate) protocol_version: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) health_check_protocol: std::option::Option<crate::model::ProtocolEnum>,
        pub(crate) health_check_port: std::option::Option<std::string::String>,
        pub(crate) health_check_enabled: std::option::Option<bool>,
        pub(crate) health_check_path: std::option::Option<std::string::String>,
        pub(crate) health_check_interval_seconds: std::option::Option<i32>,
        pub(crate) health_check_timeout_seconds: std::option::Option<i32>,
        pub(crate) healthy_threshold_count: std::option::Option<i32>,
        pub(crate) unhealthy_threshold_count: std::option::Option<i32>,
        pub(crate) matcher: std::option::Option<crate::model::Matcher>,
        pub(crate) target_type: std::option::Option<crate::model::TargetTypeEnum>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) ip_address_type: std::option::Option<crate::model::TargetGroupIpAddressTypeEnum>,
    }
    impl Builder {
        /// <p>The name of the target group.</p>
        /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must
        /// contain only alphanumeric characters or hyphens, and must not begin or end with a
        /// hyphen.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the target group.</p>
        /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must
        /// contain only alphanumeric characters or hyphens, and must not begin or end with a
        /// hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The protocol to use for routing traffic to the targets. For Application Load Balancers,
        /// the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported
        /// protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is
        /// GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a
        /// Lambda function, this parameter does not apply.</p>
        pub fn protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol to use for routing traffic to the targets. For Application Load Balancers,
        /// the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported
        /// protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is
        /// GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a
        /// Lambda function, this parameter does not apply.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>[HTTP/HTTPS protocol] The protocol version. Specify <code>GRPC</code> to send requests to
        /// targets using gRPC. Specify <code>HTTP2</code> to send requests to targets using HTTP/2. The
        /// default is <code>HTTP1</code>, which sends requests to targets using HTTP/1.1.</p>
        pub fn protocol_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol_version = Some(input.into());
            self
        }
        /// <p>[HTTP/HTTPS protocol] The protocol version. Specify <code>GRPC</code> to send requests to
        /// targets using gRPC. Specify <code>HTTP2</code> to send requests to targets using HTTP/2. The
        /// default is <code>HTTP1</code>, which sends requests to targets using HTTP/1.1.</p>
        pub fn set_protocol_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.protocol_version = input;
            self
        }
        /// <p>The port on which the targets receive traffic. This port is used unless you specify a port
        /// override when registering the target. If the target is a Lambda function, this parameter does
        /// not apply. If the protocol is GENEVE, the supported port is 6081.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port on which the targets receive traffic. This port is used unless you specify a port
        /// override when registering the target. If the target is a Lambda function, this parameter does
        /// not apply. If the protocol is GENEVE, the supported port is 6081.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The identifier of the virtual private cloud (VPC). If the target is a Lambda function,
        /// this parameter does not apply. Otherwise, this parameter is required.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The identifier of the virtual private cloud (VPC). If the target is a Lambda function,
        /// this parameter does not apply. Otherwise, this parameter is required.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The protocol the load balancer uses when performing health checks on targets. For
        /// Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load
        /// Balancers, the default is TCP. The TCP protocol is not supported for health checks if the
        /// protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are
        /// not supported for health checks.</p>
        pub fn health_check_protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.health_check_protocol = Some(input);
            self
        }
        /// <p>The protocol the load balancer uses when performing health checks on targets. For
        /// Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load
        /// Balancers, the default is TCP. The TCP protocol is not supported for health checks if the
        /// protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are
        /// not supported for health checks.</p>
        pub fn set_health_check_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.health_check_protocol = input;
            self
        }
        /// <p>The port the load balancer uses when performing health checks on targets. If the protocol
        /// is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code>, which is
        /// the port on which each target receives traffic from the load balancer. If the protocol is
        /// GENEVE, the default is port 80.</p>
        pub fn health_check_port(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_port = Some(input.into());
            self
        }
        /// <p>The port the load balancer uses when performing health checks on targets. If the protocol
        /// is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code>, which is
        /// the port on which each target receives traffic from the load balancer. If the protocol is
        /// GENEVE, the default is port 80.</p>
        pub fn set_health_check_port(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_port = input;
            self
        }
        /// <p>Indicates whether health checks are enabled. If the target type is <code>lambda</code>,
        /// health checks are disabled by default but can be enabled. If the target type is
        /// <code>instance</code>, <code>ip</code>, or <code>alb</code>, health checks are always
        /// enabled and cannot be disabled.</p>
        pub fn health_check_enabled(mut self, input: bool) -> Self {
            self.health_check_enabled = Some(input);
            self
        }
        /// <p>Indicates whether health checks are enabled. If the target type is <code>lambda</code>,
        /// health checks are disabled by default but can be enabled. If the target type is
        /// <code>instance</code>, <code>ip</code>, or <code>alb</code>, health checks are always
        /// enabled and cannot be disabled.</p>
        pub fn set_health_check_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.health_check_enabled = input;
            self
        }
        /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
        /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
        /// <p>[GRPC protocol version] The path of a custom health check method with the format
        /// /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
        pub fn health_check_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_path = Some(input.into());
            self
        }
        /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
        /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
        /// <p>[GRPC protocol version] The path of a custom health check method with the format
        /// /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_path = input;
            self
        }
        /// <p>The approximate amount of time, in seconds, between health checks of an individual target.
        /// If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30
        /// seconds. If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the
        /// target group protocol is GENEVE, the default is 10 seconds. If the target type is
        /// <code>lambda</code>, the default is 35 seconds.</p>
        pub fn health_check_interval_seconds(mut self, input: i32) -> Self {
            self.health_check_interval_seconds = Some(input);
            self
        }
        /// <p>The approximate amount of time, in seconds, between health checks of an individual target.
        /// If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30
        /// seconds. If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the
        /// target group protocol is GENEVE, the default is 10 seconds. If the target type is
        /// <code>lambda</code>, the default is 35 seconds.</p>
        pub fn set_health_check_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.health_check_interval_seconds = input;
            self
        }
        /// <p>The amount of time, in seconds, during which no response from a target means a failed
        /// health check. For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5
        /// seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for
        /// HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is
        /// <code>lambda</code>, the default is 30 seconds.</p>
        pub fn health_check_timeout_seconds(mut self, input: i32) -> Self {
            self.health_check_timeout_seconds = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, during which no response from a target means a failed
        /// health check. For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5
        /// seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for
        /// HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is
        /// <code>lambda</code>, the default is 30 seconds.</p>
        pub fn set_health_check_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.health_check_timeout_seconds = input;
            self
        }
        /// <p>The number of consecutive health checks successes required before considering an unhealthy
        /// target healthy. For target groups with a protocol of HTTP or HTTPS, the default is 5. For
        /// target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is
        /// <code>lambda</code>, the default is 5.</p>
        pub fn healthy_threshold_count(mut self, input: i32) -> Self {
            self.healthy_threshold_count = Some(input);
            self
        }
        /// <p>The number of consecutive health checks successes required before considering an unhealthy
        /// target healthy. For target groups with a protocol of HTTP or HTTPS, the default is 5. For
        /// target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is
        /// <code>lambda</code>, the default is 5.</p>
        pub fn set_healthy_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.healthy_threshold_count = input;
            self
        }
        /// <p>The number of consecutive health check failures required before considering a target
        /// unhealthy. If the target group protocol is HTTP or HTTPS, the default is 2. If the target
        /// group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If
        /// the target group protocol is GENEVE, the default is 3. If the target type is
        /// <code>lambda</code>, the default is 2.</p>
        pub fn unhealthy_threshold_count(mut self, input: i32) -> Self {
            self.unhealthy_threshold_count = Some(input);
            self
        }
        /// <p>The number of consecutive health check failures required before considering a target
        /// unhealthy. If the target group protocol is HTTP or HTTPS, the default is 2. If the target
        /// group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If
        /// the target group protocol is GENEVE, the default is 3. If the target type is
        /// <code>lambda</code>, the default is 2.</p>
        pub fn set_unhealthy_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.unhealthy_threshold_count = input;
            self
        }
        /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful
        /// response from a target.</p>
        pub fn matcher(mut self, input: crate::model::Matcher) -> Self {
            self.matcher = Some(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful
        /// response from a target.</p>
        pub fn set_matcher(mut self, input: std::option::Option<crate::model::Matcher>) -> Self {
            self.matcher = input;
            self
        }
        /// <p>The type of target that you must specify when registering targets with this target group.
        /// You can't specify targets for a target group using more than one target type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>instance</code> - Register targets by instance ID. This is the default
        /// value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ip</code> - Register targets by IP address. You can specify IP addresses from
        /// the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range
        /// (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10).
        /// You can't specify publicly routable IP addresses.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>lambda</code> - Register a single Lambda function as a target.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>alb</code> - Register a single Application Load Balancer as a target.</p>
        /// </li>
        /// </ul>
        pub fn target_type(mut self, input: crate::model::TargetTypeEnum) -> Self {
            self.target_type = Some(input);
            self
        }
        /// <p>The type of target that you must specify when registering targets with this target group.
        /// You can't specify targets for a target group using more than one target type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>instance</code> - Register targets by instance ID. This is the default
        /// value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ip</code> - Register targets by IP address. You can specify IP addresses from
        /// the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range
        /// (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10).
        /// You can't specify publicly routable IP addresses.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>lambda</code> - Register a single Lambda function as a target.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>alb</code> - Register a single Application Load Balancer as a target.</p>
        /// </li>
        /// </ul>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetTypeEnum>,
        ) -> Self {
            self.target_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the target group.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to assign to the target group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The type of IP address used for this target group. The possible values are
        /// <code>ipv4</code> and <code>ipv6</code>. This is an optional parameter. If not specified,
        /// the IP address type defaults to <code>ipv4</code>.</p>
        pub fn ip_address_type(
            mut self,
            input: crate::model::TargetGroupIpAddressTypeEnum,
        ) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The type of IP address used for this target group. The possible values are
        /// <code>ipv4</code> and <code>ipv6</code>. This is an optional parameter. If not specified,
        /// the IP address type defaults to <code>ipv4</code>.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::TargetGroupIpAddressTypeEnum>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTargetGroupInput`](crate::input::CreateTargetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTargetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTargetGroupInput {
                name: self.name,
                protocol: self.protocol,
                protocol_version: self.protocol_version,
                port: self.port,
                vpc_id: self.vpc_id,
                health_check_protocol: self.health_check_protocol,
                health_check_port: self.health_check_port,
                health_check_enabled: self.health_check_enabled,
                health_check_path: self.health_check_path,
                health_check_interval_seconds: self.health_check_interval_seconds,
                health_check_timeout_seconds: self.health_check_timeout_seconds,
                healthy_threshold_count: self.healthy_threshold_count,
                unhealthy_threshold_count: self.unhealthy_threshold_count,
                matcher: self.matcher,
                target_type: self.target_type,
                tags: self.tags,
                ip_address_type: self.ip_address_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTargetGroupInputOperationOutputAlias = crate::operation::CreateTargetGroup;
#[doc(hidden)]
pub type CreateTargetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTargetGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateTargetGroup`](crate::operation::CreateTargetGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTargetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTargetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTargetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTargetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_target_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTargetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTargetGroup",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTargetGroupInput`](crate::input::CreateTargetGroupInput)
    pub fn builder() -> crate::input::create_target_group_input::Builder {
        crate::input::create_target_group_input::Builder::default()
    }
}

/// See [`DeleteListenerInput`](crate::input::DeleteListenerInput)
pub mod delete_listener_input {
    /// A builder for [`DeleteListenerInput`](crate::input::DeleteListenerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteListenerInput`](crate::input::DeleteListenerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteListenerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteListenerInput {
                listener_arn: self.listener_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteListenerInputOperationOutputAlias = crate::operation::DeleteListener;
#[doc(hidden)]
pub type DeleteListenerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteListenerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteListener`](crate::operation::DeleteListener)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteListener,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteListenerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteListenerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteListenerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_listener(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteListener::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteListener",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteListenerInput`](crate::input::DeleteListenerInput)
    pub fn builder() -> crate::input::delete_listener_input::Builder {
        crate::input::delete_listener_input::Builder::default()
    }
}

/// See [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
pub mod delete_load_balancer_input {
    /// A builder for [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLoadBalancerInput {
                load_balancer_arn: self.load_balancer_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLoadBalancerInputOperationOutputAlias = crate::operation::DeleteLoadBalancer;
#[doc(hidden)]
pub type DeleteLoadBalancerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLoadBalancer`](crate::operation::DeleteLoadBalancer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLoadBalancer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLoadBalancerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLoadBalancerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLoadBalancerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_load_balancer(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLoadBalancer",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
    pub fn builder() -> crate::input::delete_load_balancer_input::Builder {
        crate::input::delete_load_balancer_input::Builder::default()
    }
}

/// See [`DeleteRuleInput`](crate::input::DeleteRuleInput)
pub mod delete_rule_input {
    /// A builder for [`DeleteRuleInput`](crate::input::DeleteRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRuleInput`](crate::input::DeleteRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRuleInput {
                rule_arn: self.rule_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRuleInputOperationOutputAlias = crate::operation::DeleteRule;
#[doc(hidden)]
pub type DeleteRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRule`](crate::operation::DeleteRule)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_rule(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRule",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRuleInput`](crate::input::DeleteRuleInput)
    pub fn builder() -> crate::input::delete_rule_input::Builder {
        crate::input::delete_rule_input::Builder::default()
    }
}

/// See [`DeleteTargetGroupInput`](crate::input::DeleteTargetGroupInput)
pub mod delete_target_group_input {
    /// A builder for [`DeleteTargetGroupInput`](crate::input::DeleteTargetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTargetGroupInput`](crate::input::DeleteTargetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTargetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTargetGroupInput {
                target_group_arn: self.target_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTargetGroupInputOperationOutputAlias = crate::operation::DeleteTargetGroup;
#[doc(hidden)]
pub type DeleteTargetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTargetGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTargetGroup`](crate::operation::DeleteTargetGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTargetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTargetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTargetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTargetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_target_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTargetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTargetGroup",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTargetGroupInput`](crate::input::DeleteTargetGroupInput)
    pub fn builder() -> crate::input::delete_target_group_input::Builder {
        crate::input::delete_target_group_input::Builder::default()
    }
}

/// See [`DeregisterTargetsInput`](crate::input::DeregisterTargetsInput)
pub mod deregister_targets_input {
    /// A builder for [`DeregisterTargetsInput`](crate::input::DeregisterTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_group_arn: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_arn = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets. If you specified a port override when you registered a target, you must
        /// specify both the target ID and the port when you deregister it.</p>
        pub fn targets(mut self, input: impl Into<crate::model::TargetDescription>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The targets. If you specified a port override when you registered a target, you must
        /// specify both the target ID and the port when you deregister it.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterTargetsInput`](crate::input::DeregisterTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterTargetsInput {
                target_group_arn: self.target_group_arn,
                targets: self.targets,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterTargetsInputOperationOutputAlias = crate::operation::DeregisterTargets;
#[doc(hidden)]
pub type DeregisterTargetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterTargetsInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterTargets`](crate::operation::DeregisterTargets)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterTargets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_targets(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterTargets",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterTargetsInput`](crate::input::DeregisterTargetsInput)
    pub fn builder() -> crate::input::deregister_targets_input::Builder {
        crate::input::deregister_targets_input::Builder::default()
    }
}

/// See [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
pub mod describe_account_limits_input {
    /// A builder for [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountLimitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountLimitsInput {
                marker: self.marker,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountLimitsInputOperationOutputAlias = crate::operation::DescribeAccountLimits;
#[doc(hidden)]
pub type DescribeAccountLimitsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAccountLimitsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountLimits`](crate::operation::DescribeAccountLimits)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountLimits,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccountLimitsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccountLimitsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccountLimitsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_account_limits(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountLimits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountLimits",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    pub fn builder() -> crate::input::describe_account_limits_input::Builder {
        crate::input::describe_account_limits_input::Builder::default()
    }
}

/// See [`DescribeListenerCertificatesInput`](crate::input::DescribeListenerCertificatesInput)
pub mod describe_listener_certificates_input {
    /// A builder for [`DescribeListenerCertificatesInput`](crate::input::DescribeListenerCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Names (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeListenerCertificatesInput`](crate::input::DescribeListenerCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeListenerCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeListenerCertificatesInput {
                listener_arn: self.listener_arn,
                marker: self.marker,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeListenerCertificatesInputOperationOutputAlias =
    crate::operation::DescribeListenerCertificates;
#[doc(hidden)]
pub type DescribeListenerCertificatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeListenerCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeListenerCertificates`](crate::operation::DescribeListenerCertificates)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeListenerCertificates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeListenerCertificatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeListenerCertificatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeListenerCertificatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_listener_certificates(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeListenerCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeListenerCertificates",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeListenerCertificatesInput`](crate::input::DescribeListenerCertificatesInput)
    pub fn builder() -> crate::input::describe_listener_certificates_input::Builder {
        crate::input::describe_listener_certificates_input::Builder::default()
    }
}

/// See [`DescribeListenersInput`](crate::input::DescribeListenersInput)
pub mod describe_listeners_input {
    /// A builder for [`DescribeListenersInput`](crate::input::DescribeListenersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_arn: std::option::Option<std::string::String>,
        pub(crate) listener_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_arn = input;
            self
        }
        /// Appends an item to `listener_arns`.
        ///
        /// To override the contents of this collection use [`set_listener_arns`](Self::set_listener_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the listeners.</p>
        pub fn listener_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.listener_arns.unwrap_or_default();
            v.push(input.into());
            self.listener_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the listeners.</p>
        pub fn set_listener_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.listener_arns = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeListenersInput`](crate::input::DescribeListenersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeListenersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeListenersInput {
                load_balancer_arn: self.load_balancer_arn,
                listener_arns: self.listener_arns,
                marker: self.marker,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeListenersInputOperationOutputAlias = crate::operation::DescribeListeners;
#[doc(hidden)]
pub type DescribeListenersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeListenersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeListeners`](crate::operation::DescribeListeners)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeListeners,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeListenersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeListenersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeListenersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_listeners(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeListeners::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeListeners",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeListenersInput`](crate::input::DescribeListenersInput)
    pub fn builder() -> crate::input::describe_listeners_input::Builder {
        crate::input::describe_listeners_input::Builder::default()
    }
}

/// See [`DescribeLoadBalancerAttributesInput`](crate::input::DescribeLoadBalancerAttributesInput)
pub mod describe_load_balancer_attributes_input {
    /// A builder for [`DescribeLoadBalancerAttributesInput`](crate::input::DescribeLoadBalancerAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoadBalancerAttributesInput`](crate::input::DescribeLoadBalancerAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLoadBalancerAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLoadBalancerAttributesInput {
                load_balancer_arn: self.load_balancer_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLoadBalancerAttributesInputOperationOutputAlias =
    crate::operation::DescribeLoadBalancerAttributes;
#[doc(hidden)]
pub type DescribeLoadBalancerAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLoadBalancerAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLoadBalancerAttributes`](crate::operation::DescribeLoadBalancerAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLoadBalancerAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLoadBalancerAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLoadBalancerAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLoadBalancerAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_load_balancer_attributes(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLoadBalancerAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLoadBalancerAttributes",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancerAttributesInput`](crate::input::DescribeLoadBalancerAttributesInput)
    pub fn builder() -> crate::input::describe_load_balancer_attributes_input::Builder {
        crate::input::describe_load_balancer_attributes_input::Builder::default()
    }
}

/// See [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
pub mod describe_load_balancers_input {
    /// A builder for [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `load_balancer_arns`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_arns`](Self::set_load_balancer_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the load balancers. You can specify up to 20 load
        /// balancers in a single call.</p>
        pub fn load_balancer_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.load_balancer_arns.unwrap_or_default();
            v.push(input.into());
            self.load_balancer_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the load balancers. You can specify up to 20 load
        /// balancers in a single call.</p>
        pub fn set_load_balancer_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.load_balancer_arns = input;
            self
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the load balancers.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>The names of the load balancers.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLoadBalancersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLoadBalancersInput {
                load_balancer_arns: self.load_balancer_arns,
                names: self.names,
                marker: self.marker,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLoadBalancersInputOperationOutputAlias = crate::operation::DescribeLoadBalancers;
#[doc(hidden)]
pub type DescribeLoadBalancersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLoadBalancersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLoadBalancers`](crate::operation::DescribeLoadBalancers)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLoadBalancers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLoadBalancersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLoadBalancersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLoadBalancersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_load_balancers(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLoadBalancers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLoadBalancers",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
    pub fn builder() -> crate::input::describe_load_balancers_input::Builder {
        crate::input::describe_load_balancers_input::Builder::default()
    }
}

/// See [`DescribeRulesInput`](crate::input::DescribeRulesInput)
pub mod describe_rules_input {
    /// A builder for [`DescribeRulesInput`](crate::input::DescribeRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) rule_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// Appends an item to `rule_arns`.
        ///
        /// To override the contents of this collection use [`set_rule_arns`](Self::set_rule_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the rules.</p>
        pub fn rule_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rule_arns.unwrap_or_default();
            v.push(input.into());
            self.rule_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the rules.</p>
        pub fn set_rule_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rule_arns = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRulesInput`](crate::input::DescribeRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRulesInput {
                listener_arn: self.listener_arn,
                rule_arns: self.rule_arns,
                marker: self.marker,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRulesInputOperationOutputAlias = crate::operation::DescribeRules;
#[doc(hidden)]
pub type DescribeRulesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRulesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRules`](crate::operation::DescribeRules)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRules,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_rules(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRules",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRulesInput`](crate::input::DescribeRulesInput)
    pub fn builder() -> crate::input::describe_rules_input::Builder {
        crate::input::describe_rules_input::Builder::default()
    }
}

/// See [`DescribeSslPoliciesInput`](crate::input::DescribeSslPoliciesInput)
pub mod describe_ssl_policies_input {
    /// A builder for [`DescribeSslPoliciesInput`](crate::input::DescribeSslPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) load_balancer_type: std::option::Option<crate::model::LoadBalancerTypeEnum>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the policies.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>The names of the policies.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p> The type of load balancer. The default lists the SSL policies for all load
        /// balancers.</p>
        pub fn load_balancer_type(mut self, input: crate::model::LoadBalancerTypeEnum) -> Self {
            self.load_balancer_type = Some(input);
            self
        }
        /// <p> The type of load balancer. The default lists the SSL policies for all load
        /// balancers.</p>
        pub fn set_load_balancer_type(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerTypeEnum>,
        ) -> Self {
            self.load_balancer_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSslPoliciesInput`](crate::input::DescribeSslPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSslPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSslPoliciesInput {
                names: self.names,
                marker: self.marker,
                page_size: self.page_size,
                load_balancer_type: self.load_balancer_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSslPoliciesInputOperationOutputAlias = crate::operation::DescribeSSLPolicies;
#[doc(hidden)]
pub type DescribeSslPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSslPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSSLPolicies`](crate::operation::DescribeSSLPolicies)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSSLPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSslPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSslPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSslPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_ssl_policies(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSSLPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSSLPolicies",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSslPoliciesInput`](crate::input::DescribeSslPoliciesInput)
    pub fn builder() -> crate::input::describe_ssl_policies_input::Builder {
        crate::input::describe_ssl_policies_input::Builder::default()
    }
}

/// See [`DescribeTagsInput`](crate::input::DescribeTagsInput)
pub mod describe_tags_input {
    /// A builder for [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the resources. You can specify up to 20 resources in a
        /// single call.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the resources. You can specify up to 20 resources in a
        /// single call.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsInput`](crate::input::DescribeTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTagsInput {
                resource_arns: self.resource_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTagsInputOperationOutputAlias = crate::operation::DescribeTags;
#[doc(hidden)]
pub type DescribeTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTagsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTags`](crate::operation::DescribeTags)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_tags(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTags",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
}

/// See [`DescribeTargetGroupAttributesInput`](crate::input::DescribeTargetGroupAttributesInput)
pub mod describe_target_group_attributes_input {
    /// A builder for [`DescribeTargetGroupAttributesInput`](crate::input::DescribeTargetGroupAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTargetGroupAttributesInput`](crate::input::DescribeTargetGroupAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTargetGroupAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTargetGroupAttributesInput {
                target_group_arn: self.target_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTargetGroupAttributesInputOperationOutputAlias =
    crate::operation::DescribeTargetGroupAttributes;
#[doc(hidden)]
pub type DescribeTargetGroupAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTargetGroupAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTargetGroupAttributes`](crate::operation::DescribeTargetGroupAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTargetGroupAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTargetGroupAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTargetGroupAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTargetGroupAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_target_group_attributes(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTargetGroupAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTargetGroupAttributes",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTargetGroupAttributesInput`](crate::input::DescribeTargetGroupAttributesInput)
    pub fn builder() -> crate::input::describe_target_group_attributes_input::Builder {
        crate::input::describe_target_group_attributes_input::Builder::default()
    }
}

/// See [`DescribeTargetGroupsInput`](crate::input::DescribeTargetGroupsInput)
pub mod describe_target_groups_input {
    /// A builder for [`DescribeTargetGroupsInput`](crate::input::DescribeTargetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_arn: std::option::Option<std::string::String>,
        pub(crate) target_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_arn = input;
            self
        }
        /// Appends an item to `target_group_arns`.
        ///
        /// To override the contents of this collection use [`set_target_group_arns`](Self::set_target_group_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the target groups.</p>
        pub fn target_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_group_arns.unwrap_or_default();
            v.push(input.into());
            self.target_group_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the target groups.</p>
        pub fn set_target_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_group_arns = input;
            self
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the target groups.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>The names of the target groups.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTargetGroupsInput`](crate::input::DescribeTargetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTargetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTargetGroupsInput {
                load_balancer_arn: self.load_balancer_arn,
                target_group_arns: self.target_group_arns,
                names: self.names,
                marker: self.marker,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTargetGroupsInputOperationOutputAlias = crate::operation::DescribeTargetGroups;
#[doc(hidden)]
pub type DescribeTargetGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTargetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTargetGroups`](crate::operation::DescribeTargetGroups)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTargetGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTargetGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTargetGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTargetGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_target_groups(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTargetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTargetGroups",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTargetGroupsInput`](crate::input::DescribeTargetGroupsInput)
    pub fn builder() -> crate::input::describe_target_groups_input::Builder {
        crate::input::describe_target_groups_input::Builder::default()
    }
}

/// See [`DescribeTargetHealthInput`](crate::input::DescribeTargetHealthInput)
pub mod describe_target_health_input {
    /// A builder for [`DescribeTargetHealthInput`](crate::input::DescribeTargetHealthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_group_arn: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_arn = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets.</p>
        pub fn targets(mut self, input: impl Into<crate::model::TargetDescription>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The targets.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTargetHealthInput`](crate::input::DescribeTargetHealthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTargetHealthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTargetHealthInput {
                target_group_arn: self.target_group_arn,
                targets: self.targets,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTargetHealthInputOperationOutputAlias = crate::operation::DescribeTargetHealth;
#[doc(hidden)]
pub type DescribeTargetHealthInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTargetHealthInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTargetHealth`](crate::operation::DescribeTargetHealth)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTargetHealth,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTargetHealthInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTargetHealthInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTargetHealthInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_target_health(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTargetHealth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTargetHealth",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTargetHealthInput`](crate::input::DescribeTargetHealthInput)
    pub fn builder() -> crate::input::describe_target_health_input::Builder {
        crate::input::describe_target_health_input::Builder::default()
    }
}

/// See [`ModifyListenerInput`](crate::input::ModifyListenerInput)
pub mod modify_listener_input {
    /// A builder for [`ModifyListenerInput`](crate::input::ModifyListenerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<crate::model::ProtocolEnum>,
        pub(crate) ssl_policy: std::option::Option<std::string::String>,
        pub(crate) certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        pub(crate) default_actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
        pub(crate) alpn_policy: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// <p>The port for connections from clients to the load balancer. You cannot specify a port for
        /// a Gateway Load Balancer.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port for connections from clients to the load balancer. You cannot specify a port for
        /// a Gateway Load Balancer.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The protocol for connections from clients to the load balancer. Application Load Balancers
        /// support the HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and
        /// TCP_UDP protocols. You can’t change the protocol to UDP or TCP_UDP if dual-stack mode is
        /// enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>
        pub fn protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol for connections from clients to the load balancer. Application Load Balancers
        /// support the HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and
        /// TCP_UDP protocols. You can’t change the protocol to UDP or TCP_UDP if dual-stack mode is
        /// enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are
        /// supported.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> or
        /// <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn ssl_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssl_policy = Some(input.into());
            self
        }
        /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are
        /// supported.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> or
        /// <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn set_ssl_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssl_policy = input;
            self
        }
        /// Appends an item to `certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide
        /// exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set
        /// <code>IsDefault</code>.</p>
        pub fn certificates(mut self, input: impl Into<crate::model::Certificate>) -> Self {
            let mut v = self.certificates.unwrap_or_default();
            v.push(input.into());
            self.certificates = Some(v);
            self
        }
        /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide
        /// exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set
        /// <code>IsDefault</code>.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.certificates = input;
            self
        }
        /// Appends an item to `default_actions`.
        ///
        /// To override the contents of this collection use [`set_default_actions`](Self::set_default_actions).
        ///
        /// <p>The actions for the default rule.</p>
        pub fn default_actions(mut self, input: impl Into<crate::model::Action>) -> Self {
            let mut v = self.default_actions.unwrap_or_default();
            v.push(input.into());
            self.default_actions = Some(v);
            self
        }
        /// <p>The actions for the default rule.</p>
        pub fn set_default_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.default_actions = input;
            self
        }
        /// Appends an item to `alpn_policy`.
        ///
        /// To override the contents of this collection use [`set_alpn_policy`](Self::set_alpn_policy).
        ///
        /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You
        /// can specify one policy name. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HTTP1Only</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HTTP2Only</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HTTP2Optional</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HTTP2Preferred</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>None</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN
        /// policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn alpn_policy(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.alpn_policy.unwrap_or_default();
            v.push(input.into());
            self.alpn_policy = Some(v);
            self
        }
        /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You
        /// can specify one policy name. The following are the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HTTP1Only</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HTTP2Only</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HTTP2Optional</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HTTP2Preferred</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>None</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN
        /// policies</a> in the <i>Network Load Balancers Guide</i>.</p>
        pub fn set_alpn_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.alpn_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyListenerInput`](crate::input::ModifyListenerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyListenerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyListenerInput {
                listener_arn: self.listener_arn,
                port: self.port,
                protocol: self.protocol,
                ssl_policy: self.ssl_policy,
                certificates: self.certificates,
                default_actions: self.default_actions,
                alpn_policy: self.alpn_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyListenerInputOperationOutputAlias = crate::operation::ModifyListener;
#[doc(hidden)]
pub type ModifyListenerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyListenerInput {
    /// Consumes the builder and constructs an Operation<[`ModifyListener`](crate::operation::ModifyListener)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyListener,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyListenerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyListenerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyListenerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_modify_listener(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyListener::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyListener",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyListenerInput`](crate::input::ModifyListenerInput)
    pub fn builder() -> crate::input::modify_listener_input::Builder {
        crate::input::modify_listener_input::Builder::default()
    }
}

/// See [`ModifyLoadBalancerAttributesInput`](crate::input::ModifyLoadBalancerAttributesInput)
pub mod modify_load_balancer_attributes_input {
    /// A builder for [`ModifyLoadBalancerAttributesInput`](crate::input::ModifyLoadBalancerAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_arn: std::option::Option<std::string::String>,
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::LoadBalancerAttribute>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_arn = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The load balancer attributes.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::LoadBalancerAttribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The load balancer attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancerAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyLoadBalancerAttributesInput`](crate::input::ModifyLoadBalancerAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyLoadBalancerAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyLoadBalancerAttributesInput {
                load_balancer_arn: self.load_balancer_arn,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyLoadBalancerAttributesInputOperationOutputAlias =
    crate::operation::ModifyLoadBalancerAttributes;
#[doc(hidden)]
pub type ModifyLoadBalancerAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyLoadBalancerAttributesInput {
    /// Consumes the builder and constructs an Operation<[`ModifyLoadBalancerAttributes`](crate::operation::ModifyLoadBalancerAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyLoadBalancerAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyLoadBalancerAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyLoadBalancerAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyLoadBalancerAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_load_balancer_attributes(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyLoadBalancerAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyLoadBalancerAttributes",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyLoadBalancerAttributesInput`](crate::input::ModifyLoadBalancerAttributesInput)
    pub fn builder() -> crate::input::modify_load_balancer_attributes_input::Builder {
        crate::input::modify_load_balancer_attributes_input::Builder::default()
    }
}

/// See [`ModifyRuleInput`](crate::input::ModifyRuleInput)
pub mod modify_rule_input {
    /// A builder for [`ModifyRuleInput`](crate::input::ModifyRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_arn: std::option::Option<std::string::String>,
        pub(crate) conditions: std::option::Option<std::vec::Vec<crate::model::RuleCondition>>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_arn = input;
            self
        }
        /// Appends an item to `conditions`.
        ///
        /// To override the contents of this collection use [`set_conditions`](Self::set_conditions).
        ///
        /// <p>The conditions.</p>
        pub fn conditions(mut self, input: impl Into<crate::model::RuleCondition>) -> Self {
            let mut v = self.conditions.unwrap_or_default();
            v.push(input.into());
            self.conditions = Some(v);
            self
        }
        /// <p>The conditions.</p>
        pub fn set_conditions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleCondition>>,
        ) -> Self {
            self.conditions = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions.</p>
        pub fn actions(mut self, input: impl Into<crate::model::Action>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The actions.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyRuleInput`](crate::input::ModifyRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyRuleInput {
                rule_arn: self.rule_arn,
                conditions: self.conditions,
                actions: self.actions,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyRuleInputOperationOutputAlias = crate::operation::ModifyRule;
#[doc(hidden)]
pub type ModifyRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyRuleInput {
    /// Consumes the builder and constructs an Operation<[`ModifyRule`](crate::operation::ModifyRule)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_modify_rule(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyRule",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyRuleInput`](crate::input::ModifyRuleInput)
    pub fn builder() -> crate::input::modify_rule_input::Builder {
        crate::input::modify_rule_input::Builder::default()
    }
}

/// See [`ModifyTargetGroupInput`](crate::input::ModifyTargetGroupInput)
pub mod modify_target_group_input {
    /// A builder for [`ModifyTargetGroupInput`](crate::input::ModifyTargetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_group_arn: std::option::Option<std::string::String>,
        pub(crate) health_check_protocol: std::option::Option<crate::model::ProtocolEnum>,
        pub(crate) health_check_port: std::option::Option<std::string::String>,
        pub(crate) health_check_path: std::option::Option<std::string::String>,
        pub(crate) health_check_enabled: std::option::Option<bool>,
        pub(crate) health_check_interval_seconds: std::option::Option<i32>,
        pub(crate) health_check_timeout_seconds: std::option::Option<i32>,
        pub(crate) healthy_threshold_count: std::option::Option<i32>,
        pub(crate) unhealthy_threshold_count: std::option::Option<i32>,
        pub(crate) matcher: std::option::Option<crate::model::Matcher>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_arn = input;
            self
        }
        /// <p>The protocol the load balancer uses when performing health checks on targets. For
        /// Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load
        /// Balancers, the default is TCP. The TCP protocol is not supported for health checks if the
        /// protocol of the target group is HTTP or HTTPS. It is supported for health checks only if the
        /// protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The GENEVE, TLS, UDP, and TCP_UDP
        /// protocols are not supported for health checks.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn health_check_protocol(mut self, input: crate::model::ProtocolEnum) -> Self {
            self.health_check_protocol = Some(input);
            self
        }
        /// <p>The protocol the load balancer uses when performing health checks on targets. For
        /// Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load
        /// Balancers, the default is TCP. The TCP protocol is not supported for health checks if the
        /// protocol of the target group is HTTP or HTTPS. It is supported for health checks only if the
        /// protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The GENEVE, TLS, UDP, and TCP_UDP
        /// protocols are not supported for health checks.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn set_health_check_protocol(
            mut self,
            input: std::option::Option<crate::model::ProtocolEnum>,
        ) -> Self {
            self.health_check_protocol = input;
            self
        }
        /// <p>The port the load balancer uses when performing health checks on targets.</p>
        pub fn health_check_port(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_port = Some(input.into());
            self
        }
        /// <p>The port the load balancer uses when performing health checks on targets.</p>
        pub fn set_health_check_port(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_port = input;
            self
        }
        /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
        /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
        /// <p>[GRPC protocol version] The path of a custom health check method with the format
        /// /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
        pub fn health_check_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_path = Some(input.into());
            self
        }
        /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
        /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
        /// <p>[GRPC protocol version] The path of a custom health check method with the format
        /// /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_path = input;
            self
        }
        /// <p>Indicates whether health checks are enabled.</p>
        pub fn health_check_enabled(mut self, input: bool) -> Self {
            self.health_check_enabled = Some(input);
            self
        }
        /// <p>Indicates whether health checks are enabled.</p>
        pub fn set_health_check_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.health_check_enabled = input;
            self
        }
        /// <p>The approximate amount of time, in seconds, between health checks of an individual target.
        /// For TCP health checks, the supported values are 10 or 30 seconds.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn health_check_interval_seconds(mut self, input: i32) -> Self {
            self.health_check_interval_seconds = Some(input);
            self
        }
        /// <p>The approximate amount of time, in seconds, between health checks of an individual target.
        /// For TCP health checks, the supported values are 10 or 30 seconds.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn set_health_check_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.health_check_interval_seconds = input;
            self
        }
        /// <p>[HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means
        /// a failed health check.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn health_check_timeout_seconds(mut self, input: i32) -> Self {
            self.health_check_timeout_seconds = Some(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means
        /// a failed health check.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn set_health_check_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.health_check_timeout_seconds = input;
            self
        }
        /// <p>The number of consecutive health checks successes required before considering an unhealthy
        /// target healthy.</p>
        pub fn healthy_threshold_count(mut self, input: i32) -> Self {
            self.healthy_threshold_count = Some(input);
            self
        }
        /// <p>The number of consecutive health checks successes required before considering an unhealthy
        /// target healthy.</p>
        pub fn set_healthy_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.healthy_threshold_count = input;
            self
        }
        /// <p>The number of consecutive health check failures required before considering the target
        /// unhealthy. For target groups with a protocol of TCP or TLS, this value must be the same as the
        /// healthy threshold count.</p>
        pub fn unhealthy_threshold_count(mut self, input: i32) -> Self {
            self.unhealthy_threshold_count = Some(input);
            self
        }
        /// <p>The number of consecutive health check failures required before considering the target
        /// unhealthy. For target groups with a protocol of TCP or TLS, this value must be the same as the
        /// healthy threshold count.</p>
        pub fn set_unhealthy_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.unhealthy_threshold_count = input;
            self
        }
        /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful
        /// response from a target.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn matcher(mut self, input: crate::model::Matcher) -> Self {
            self.matcher = Some(input);
            self
        }
        /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful
        /// response from a target.</p>
        /// <p>With Network Load Balancers, you can't modify this setting.</p>
        pub fn set_matcher(mut self, input: std::option::Option<crate::model::Matcher>) -> Self {
            self.matcher = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyTargetGroupInput`](crate::input::ModifyTargetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyTargetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyTargetGroupInput {
                target_group_arn: self.target_group_arn,
                health_check_protocol: self.health_check_protocol,
                health_check_port: self.health_check_port,
                health_check_path: self.health_check_path,
                health_check_enabled: self.health_check_enabled,
                health_check_interval_seconds: self.health_check_interval_seconds,
                health_check_timeout_seconds: self.health_check_timeout_seconds,
                healthy_threshold_count: self.healthy_threshold_count,
                unhealthy_threshold_count: self.unhealthy_threshold_count,
                matcher: self.matcher,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyTargetGroupInputOperationOutputAlias = crate::operation::ModifyTargetGroup;
#[doc(hidden)]
pub type ModifyTargetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyTargetGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyTargetGroup`](crate::operation::ModifyTargetGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyTargetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyTargetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyTargetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyTargetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_target_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyTargetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyTargetGroup",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyTargetGroupInput`](crate::input::ModifyTargetGroupInput)
    pub fn builder() -> crate::input::modify_target_group_input::Builder {
        crate::input::modify_target_group_input::Builder::default()
    }
}

/// See [`ModifyTargetGroupAttributesInput`](crate::input::ModifyTargetGroupAttributesInput)
pub mod modify_target_group_attributes_input {
    /// A builder for [`ModifyTargetGroupAttributesInput`](crate::input::ModifyTargetGroupAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_group_arn: std::option::Option<std::string::String>,
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::TargetGroupAttribute>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_arn = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::TargetGroupAttribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetGroupAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyTargetGroupAttributesInput`](crate::input::ModifyTargetGroupAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyTargetGroupAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyTargetGroupAttributesInput {
                target_group_arn: self.target_group_arn,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyTargetGroupAttributesInputOperationOutputAlias =
    crate::operation::ModifyTargetGroupAttributes;
#[doc(hidden)]
pub type ModifyTargetGroupAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyTargetGroupAttributesInput {
    /// Consumes the builder and constructs an Operation<[`ModifyTargetGroupAttributes`](crate::operation::ModifyTargetGroupAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyTargetGroupAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyTargetGroupAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyTargetGroupAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyTargetGroupAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_target_group_attributes(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyTargetGroupAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyTargetGroupAttributes",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyTargetGroupAttributesInput`](crate::input::ModifyTargetGroupAttributesInput)
    pub fn builder() -> crate::input::modify_target_group_attributes_input::Builder {
        crate::input::modify_target_group_attributes_input::Builder::default()
    }
}

/// See [`RegisterTargetsInput`](crate::input::RegisterTargetsInput)
pub mod register_targets_input {
    /// A builder for [`RegisterTargetsInput`](crate::input::RegisterTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_group_arn: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_arn = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets.</p>
        pub fn targets(mut self, input: impl Into<crate::model::TargetDescription>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The targets.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterTargetsInput`](crate::input::RegisterTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterTargetsInput {
                target_group_arn: self.target_group_arn,
                targets: self.targets,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterTargetsInputOperationOutputAlias = crate::operation::RegisterTargets;
#[doc(hidden)]
pub type RegisterTargetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterTargetsInput {
    /// Consumes the builder and constructs an Operation<[`RegisterTargets`](crate::operation::RegisterTargets)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterTargets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_targets(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterTargets",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterTargetsInput`](crate::input::RegisterTargetsInput)
    pub fn builder() -> crate::input::register_targets_input::Builder {
        crate::input::register_targets_input::Builder::default()
    }
}

/// See [`RemoveListenerCertificatesInput`](crate::input::RemoveListenerCertificatesInput)
pub mod remove_listener_certificates_input {
    /// A builder for [`RemoveListenerCertificatesInput`](crate::input::RemoveListenerCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// Appends an item to `certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>The certificate to remove. You can specify one certificate per call. Set
        /// <code>CertificateArn</code> to the certificate ARN but do not set
        /// <code>IsDefault</code>.</p>
        pub fn certificates(mut self, input: impl Into<crate::model::Certificate>) -> Self {
            let mut v = self.certificates.unwrap_or_default();
            v.push(input.into());
            self.certificates = Some(v);
            self
        }
        /// <p>The certificate to remove. You can specify one certificate per call. Set
        /// <code>CertificateArn</code> to the certificate ARN but do not set
        /// <code>IsDefault</code>.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.certificates = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveListenerCertificatesInput`](crate::input::RemoveListenerCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveListenerCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveListenerCertificatesInput {
                listener_arn: self.listener_arn,
                certificates: self.certificates,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveListenerCertificatesInputOperationOutputAlias =
    crate::operation::RemoveListenerCertificates;
#[doc(hidden)]
pub type RemoveListenerCertificatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveListenerCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`RemoveListenerCertificates`](crate::operation::RemoveListenerCertificates)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveListenerCertificates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveListenerCertificatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveListenerCertificatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveListenerCertificatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_listener_certificates(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveListenerCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveListenerCertificates",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveListenerCertificatesInput`](crate::input::RemoveListenerCertificatesInput)
    pub fn builder() -> crate::input::remove_listener_certificates_input::Builder {
        crate::input::remove_listener_certificates_input::Builder::default()
    }
}

/// See [`RemoveTagsInput`](crate::input::RemoveTagsInput)
pub mod remove_tags_input {
    /// A builder for [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys for the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys for the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsInput`](crate::input::RemoveTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsInput {
                resource_arns: self.resource_arns,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsInputOperationOutputAlias = crate::operation::RemoveTags;
#[doc(hidden)]
pub type RemoveTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveTagsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTags`](crate::operation::RemoveTags)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_remove_tags(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTags",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    pub fn builder() -> crate::input::remove_tags_input::Builder {
        crate::input::remove_tags_input::Builder::default()
    }
}

/// See [`SetIpAddressTypeInput`](crate::input::SetIpAddressTypeInput)
pub mod set_ip_address_type_input {
    /// A builder for [`SetIpAddressTypeInput`](crate::input::SetIpAddressTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_arn: std::option::Option<std::string::String>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_arn = input;
            self
        }
        /// <p>The IP address type. The possible values are <code>ipv4</code> (for IPv4 addresses) and
        /// <code>dualstack</code> (for IPv4 and IPv6 addresses). Internal load balancers must use
        /// <code>ipv4</code>. You can’t specify <code>dualstack</code> for a load balancer with a UDP
        /// or TCP_UDP listener.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The IP address type. The possible values are <code>ipv4</code> (for IPv4 addresses) and
        /// <code>dualstack</code> (for IPv4 and IPv6 addresses). Internal load balancers must use
        /// <code>ipv4</code>. You can’t specify <code>dualstack</code> for a load balancer with a UDP
        /// or TCP_UDP listener.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SetIpAddressTypeInput`](crate::input::SetIpAddressTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetIpAddressTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetIpAddressTypeInput {
                load_balancer_arn: self.load_balancer_arn,
                ip_address_type: self.ip_address_type,
            })
        }
    }
}
#[doc(hidden)]
pub type SetIpAddressTypeInputOperationOutputAlias = crate::operation::SetIpAddressType;
#[doc(hidden)]
pub type SetIpAddressTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetIpAddressTypeInput {
    /// Consumes the builder and constructs an Operation<[`SetIpAddressType`](crate::operation::SetIpAddressType)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetIpAddressType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetIpAddressTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetIpAddressTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetIpAddressTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_ip_address_type(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetIpAddressType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetIpAddressType",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetIpAddressTypeInput`](crate::input::SetIpAddressTypeInput)
    pub fn builder() -> crate::input::set_ip_address_type_input::Builder {
        crate::input::set_ip_address_type_input::Builder::default()
    }
}

/// See [`SetRulePrioritiesInput`](crate::input::SetRulePrioritiesInput)
pub mod set_rule_priorities_input {
    /// A builder for [`SetRulePrioritiesInput`](crate::input::SetRulePrioritiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_priorities:
            std::option::Option<std::vec::Vec<crate::model::RulePriorityPair>>,
    }
    impl Builder {
        /// Appends an item to `rule_priorities`.
        ///
        /// To override the contents of this collection use [`set_rule_priorities`](Self::set_rule_priorities).
        ///
        /// <p>The rule priorities.</p>
        pub fn rule_priorities(mut self, input: impl Into<crate::model::RulePriorityPair>) -> Self {
            let mut v = self.rule_priorities.unwrap_or_default();
            v.push(input.into());
            self.rule_priorities = Some(v);
            self
        }
        /// <p>The rule priorities.</p>
        pub fn set_rule_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RulePriorityPair>>,
        ) -> Self {
            self.rule_priorities = input;
            self
        }
        /// Consumes the builder and constructs a [`SetRulePrioritiesInput`](crate::input::SetRulePrioritiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetRulePrioritiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetRulePrioritiesInput {
                rule_priorities: self.rule_priorities,
            })
        }
    }
}
#[doc(hidden)]
pub type SetRulePrioritiesInputOperationOutputAlias = crate::operation::SetRulePriorities;
#[doc(hidden)]
pub type SetRulePrioritiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetRulePrioritiesInput {
    /// Consumes the builder and constructs an Operation<[`SetRulePriorities`](crate::operation::SetRulePriorities)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetRulePriorities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetRulePrioritiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetRulePrioritiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetRulePrioritiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_rule_priorities(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetRulePriorities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetRulePriorities",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetRulePrioritiesInput`](crate::input::SetRulePrioritiesInput)
    pub fn builder() -> crate::input::set_rule_priorities_input::Builder {
        crate::input::set_rule_priorities_input::Builder::default()
    }
}

/// See [`SetSecurityGroupsInput`](crate::input::SetSecurityGroupsInput)
pub mod set_security_groups_input {
    /// A builder for [`SetSecurityGroupsInput`](crate::input::SetSecurityGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_arn: std::option::Option<std::string::String>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_arn = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The IDs of the security groups.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The IDs of the security groups.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`SetSecurityGroupsInput`](crate::input::SetSecurityGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetSecurityGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetSecurityGroupsInput {
                load_balancer_arn: self.load_balancer_arn,
                security_groups: self.security_groups,
            })
        }
    }
}
#[doc(hidden)]
pub type SetSecurityGroupsInputOperationOutputAlias = crate::operation::SetSecurityGroups;
#[doc(hidden)]
pub type SetSecurityGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetSecurityGroupsInput {
    /// Consumes the builder and constructs an Operation<[`SetSecurityGroups`](crate::operation::SetSecurityGroups)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetSecurityGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetSecurityGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetSecurityGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetSecurityGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_security_groups(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetSecurityGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetSecurityGroups",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetSecurityGroupsInput`](crate::input::SetSecurityGroupsInput)
    pub fn builder() -> crate::input::set_security_groups_input::Builder {
        crate::input::set_security_groups_input::Builder::default()
    }
}

/// See [`SetSubnetsInput`](crate::input::SetSubnetsInput)
pub mod set_subnets_input {
    /// A builder for [`SetSubnetsInput`](crate::input::SetSubnetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_arn: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_mappings: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_arn = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You
        /// must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability
        /// Zones.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local
        /// Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability
        /// Zones.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You
        /// must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability
        /// Zones.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local
        /// Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability
        /// Zones.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Appends an item to `subnet_mappings`.
        ///
        /// To override the contents of this collection use [`set_subnet_mappings`](Self::set_subnet_mappings).
        ///
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You
        /// must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability
        /// Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local
        /// Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You
        /// can specify one Elastic IP address per subnet if you need static IP addresses for your
        /// internet-facing load balancer. For internal load balancers, you can specify one private IP
        /// address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you
        /// can specify one IPv6 address per subnet.</p>
        pub fn subnet_mappings(mut self, input: impl Into<crate::model::SubnetMapping>) -> Self {
            let mut v = self.subnet_mappings.unwrap_or_default();
            v.push(input.into());
            self.subnet_mappings = Some(v);
            self
        }
        /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You
        /// must specify either subnets or subnet mappings.</p>
        /// <p>[Application Load Balancers] You must specify subnets from at least two Availability
        /// Zones. You cannot specify Elastic IP addresses for your subnets.</p>
        /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
        /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local
        /// Zones.</p>
        /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You
        /// can specify one Elastic IP address per subnet if you need static IP addresses for your
        /// internet-facing load balancer. For internal load balancers, you can specify one private IP
        /// address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you
        /// can specify one IPv6 address per subnet.</p>
        pub fn set_subnet_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
        ) -> Self {
            self.subnet_mappings = input;
            self
        }
        /// <p>[Network Load Balancers] The type of IP addresses used by the subnets for your load
        /// balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and
        /// <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify
        /// <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener. Internal load
        /// balancers must use <code>ipv4</code>.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>[Network Load Balancers] The type of IP addresses used by the subnets for your load
        /// balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and
        /// <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify
        /// <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener. Internal load
        /// balancers must use <code>ipv4</code>.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SetSubnetsInput`](crate::input::SetSubnetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetSubnetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetSubnetsInput {
                load_balancer_arn: self.load_balancer_arn,
                subnets: self.subnets,
                subnet_mappings: self.subnet_mappings,
                ip_address_type: self.ip_address_type,
            })
        }
    }
}
#[doc(hidden)]
pub type SetSubnetsInputOperationOutputAlias = crate::operation::SetSubnets;
#[doc(hidden)]
pub type SetSubnetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetSubnetsInput {
    /// Consumes the builder and constructs an Operation<[`SetSubnets`](crate::operation::SetSubnets)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetSubnets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetSubnetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetSubnetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetSubnetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_set_subnets(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetSubnets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetSubnets",
            "elasticloadbalancingv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetSubnetsInput`](crate::input::SetSubnetsInput)
    pub fn builder() -> crate::input::set_subnets_input::Builder {
        crate::input::set_subnets_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetSubnetsInput {
    /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    pub load_balancer_arn: std::option::Option<std::string::String>,
    /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You
    /// must specify either subnets or subnet mappings.</p>
    /// <p>[Application Load Balancers] You must specify subnets from at least two Availability
    /// Zones.</p>
    /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
    /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local
    /// Zones.</p>
    /// <p>[Network Load Balancers] You can specify subnets from one or more Availability
    /// Zones.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You
    /// must specify either subnets or subnet mappings.</p>
    /// <p>[Application Load Balancers] You must specify subnets from at least two Availability
    /// Zones. You cannot specify Elastic IP addresses for your subnets.</p>
    /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
    /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local
    /// Zones.</p>
    /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You
    /// can specify one Elastic IP address per subnet if you need static IP addresses for your
    /// internet-facing load balancer. For internal load balancers, you can specify one private IP
    /// address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you
    /// can specify one IPv6 address per subnet.</p>
    pub subnet_mappings: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
    /// <p>[Network Load Balancers] The type of IP addresses used by the subnets for your load
    /// balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and
    /// <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify
    /// <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener. Internal load
    /// balancers must use <code>ipv4</code>.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
}
impl std::fmt::Debug for SetSubnetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetSubnetsInput");
        formatter.field("load_balancer_arn", &self.load_balancer_arn);
        formatter.field("subnets", &self.subnets);
        formatter.field("subnet_mappings", &self.subnet_mappings);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetSecurityGroupsInput {
    /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    pub load_balancer_arn: std::option::Option<std::string::String>,
    /// <p>The IDs of the security groups.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for SetSecurityGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetSecurityGroupsInput");
        formatter.field("load_balancer_arn", &self.load_balancer_arn);
        formatter.field("security_groups", &self.security_groups);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetRulePrioritiesInput {
    /// <p>The rule priorities.</p>
    pub rule_priorities: std::option::Option<std::vec::Vec<crate::model::RulePriorityPair>>,
}
impl std::fmt::Debug for SetRulePrioritiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetRulePrioritiesInput");
        formatter.field("rule_priorities", &self.rule_priorities);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIpAddressTypeInput {
    /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    pub load_balancer_arn: std::option::Option<std::string::String>,
    /// <p>The IP address type. The possible values are <code>ipv4</code> (for IPv4 addresses) and
    /// <code>dualstack</code> (for IPv4 and IPv6 addresses). Internal load balancers must use
    /// <code>ipv4</code>. You can’t specify <code>dualstack</code> for a load balancer with a UDP
    /// or TCP_UDP listener.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
}
impl std::fmt::Debug for SetIpAddressTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIpAddressTypeInput");
        formatter.field("load_balancer_arn", &self.load_balancer_arn);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tag keys for the tags to remove.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for RemoveTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsInput");
        formatter.field("resource_arns", &self.resource_arns);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveListenerCertificatesInput {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The certificate to remove. You can specify one certificate per call. Set
    /// <code>CertificateArn</code> to the certificate ARN but do not set
    /// <code>IsDefault</code>.</p>
    pub certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
}
impl std::fmt::Debug for RemoveListenerCertificatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveListenerCertificatesInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("certificates", &self.certificates);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterTargetsInput {
    /// <p>The Amazon Resource Name (ARN) of the target group.</p>
    pub target_group_arn: std::option::Option<std::string::String>,
    /// <p>The targets.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
}
impl std::fmt::Debug for RegisterTargetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterTargetsInput");
        formatter.field("target_group_arn", &self.target_group_arn);
        formatter.field("targets", &self.targets);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyTargetGroupAttributesInput {
    /// <p>The Amazon Resource Name (ARN) of the target group.</p>
    pub target_group_arn: std::option::Option<std::string::String>,
    /// <p>The attributes.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::TargetGroupAttribute>>,
}
impl std::fmt::Debug for ModifyTargetGroupAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyTargetGroupAttributesInput");
        formatter.field("target_group_arn", &self.target_group_arn);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyTargetGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the target group.</p>
    pub target_group_arn: std::option::Option<std::string::String>,
    /// <p>The protocol the load balancer uses when performing health checks on targets. For
    /// Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load
    /// Balancers, the default is TCP. The TCP protocol is not supported for health checks if the
    /// protocol of the target group is HTTP or HTTPS. It is supported for health checks only if the
    /// protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The GENEVE, TLS, UDP, and TCP_UDP
    /// protocols are not supported for health checks.</p>
    /// <p>With Network Load Balancers, you can't modify this setting.</p>
    pub health_check_protocol: std::option::Option<crate::model::ProtocolEnum>,
    /// <p>The port the load balancer uses when performing health checks on targets.</p>
    pub health_check_port: std::option::Option<std::string::String>,
    /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
    /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
    /// <p>[GRPC protocol version] The path of a custom health check method with the format
    /// /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
    pub health_check_path: std::option::Option<std::string::String>,
    /// <p>Indicates whether health checks are enabled.</p>
    pub health_check_enabled: std::option::Option<bool>,
    /// <p>The approximate amount of time, in seconds, between health checks of an individual target.
    /// For TCP health checks, the supported values are 10 or 30 seconds.</p>
    /// <p>With Network Load Balancers, you can't modify this setting.</p>
    pub health_check_interval_seconds: std::option::Option<i32>,
    /// <p>[HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means
    /// a failed health check.</p>
    /// <p>With Network Load Balancers, you can't modify this setting.</p>
    pub health_check_timeout_seconds: std::option::Option<i32>,
    /// <p>The number of consecutive health checks successes required before considering an unhealthy
    /// target healthy.</p>
    pub healthy_threshold_count: std::option::Option<i32>,
    /// <p>The number of consecutive health check failures required before considering the target
    /// unhealthy. For target groups with a protocol of TCP or TLS, this value must be the same as the
    /// healthy threshold count.</p>
    pub unhealthy_threshold_count: std::option::Option<i32>,
    /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful
    /// response from a target.</p>
    /// <p>With Network Load Balancers, you can't modify this setting.</p>
    pub matcher: std::option::Option<crate::model::Matcher>,
}
impl std::fmt::Debug for ModifyTargetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyTargetGroupInput");
        formatter.field("target_group_arn", &self.target_group_arn);
        formatter.field("health_check_protocol", &self.health_check_protocol);
        formatter.field("health_check_port", &self.health_check_port);
        formatter.field("health_check_path", &self.health_check_path);
        formatter.field("health_check_enabled", &self.health_check_enabled);
        formatter.field(
            "health_check_interval_seconds",
            &self.health_check_interval_seconds,
        );
        formatter.field(
            "health_check_timeout_seconds",
            &self.health_check_timeout_seconds,
        );
        formatter.field("healthy_threshold_count", &self.healthy_threshold_count);
        formatter.field("unhealthy_threshold_count", &self.unhealthy_threshold_count);
        formatter.field("matcher", &self.matcher);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyRuleInput {
    /// <p>The Amazon Resource Name (ARN) of the rule.</p>
    pub rule_arn: std::option::Option<std::string::String>,
    /// <p>The conditions.</p>
    pub conditions: std::option::Option<std::vec::Vec<crate::model::RuleCondition>>,
    /// <p>The actions.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
}
impl std::fmt::Debug for ModifyRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyRuleInput");
        formatter.field("rule_arn", &self.rule_arn);
        formatter.field("conditions", &self.conditions);
        formatter.field("actions", &self.actions);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyLoadBalancerAttributesInput {
    /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    pub load_balancer_arn: std::option::Option<std::string::String>,
    /// <p>The load balancer attributes.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::LoadBalancerAttribute>>,
}
impl std::fmt::Debug for ModifyLoadBalancerAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyLoadBalancerAttributesInput");
        formatter.field("load_balancer_arn", &self.load_balancer_arn);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The port for connections from clients to the load balancer. You cannot specify a port for
    /// a Gateway Load Balancer.</p>
    pub port: std::option::Option<i32>,
    /// <p>The protocol for connections from clients to the load balancer. Application Load Balancers
    /// support the HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and
    /// TCP_UDP protocols. You can’t change the protocol to UDP or TCP_UDP if dual-stack mode is
    /// enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>
    pub protocol: std::option::Option<crate::model::ProtocolEnum>,
    /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are
    /// supported.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> or
    /// <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
    pub ssl_policy: std::option::Option<std::string::String>,
    /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide
    /// exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set
    /// <code>IsDefault</code>.</p>
    pub certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
    /// <p>The actions for the default rule.</p>
    pub default_actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You
    /// can specify one policy name. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HTTP1Only</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HTTP2Only</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HTTP2Optional</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HTTP2Preferred</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>None</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN
    /// policies</a> in the <i>Network Load Balancers Guide</i>.</p>
    pub alpn_policy: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ModifyListenerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyListenerInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("port", &self.port);
        formatter.field("protocol", &self.protocol);
        formatter.field("ssl_policy", &self.ssl_policy);
        formatter.field("certificates", &self.certificates);
        formatter.field("default_actions", &self.default_actions);
        formatter.field("alpn_policy", &self.alpn_policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTargetHealthInput {
    /// <p>The Amazon Resource Name (ARN) of the target group.</p>
    pub target_group_arn: std::option::Option<std::string::String>,
    /// <p>The targets.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
}
impl std::fmt::Debug for DescribeTargetHealthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTargetHealthInput");
        formatter.field("target_group_arn", &self.target_group_arn);
        formatter.field("targets", &self.targets);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTargetGroupsInput {
    /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    pub load_balancer_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARN) of the target groups.</p>
    pub target_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of the target groups.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The marker for the next set of results. (You received this marker from a previous
    /// call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with this call.</p>
    pub page_size: std::option::Option<i32>,
}
impl std::fmt::Debug for DescribeTargetGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTargetGroupsInput");
        formatter.field("load_balancer_arn", &self.load_balancer_arn);
        formatter.field("target_group_arns", &self.target_group_arns);
        formatter.field("names", &self.names);
        formatter.field("marker", &self.marker);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTargetGroupAttributesInput {
    /// <p>The Amazon Resource Name (ARN) of the target group.</p>
    pub target_group_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeTargetGroupAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTargetGroupAttributesInput");
        formatter.field("target_group_arn", &self.target_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagsInput {
    /// <p>The Amazon Resource Names (ARN) of the resources. You can specify up to 20 resources in a
    /// single call.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for DescribeTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagsInput");
        formatter.field("resource_arns", &self.resource_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSslPoliciesInput {
    /// <p>The names of the policies.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The marker for the next set of results. (You received this marker from a previous
    /// call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with this call.</p>
    pub page_size: std::option::Option<i32>,
    /// <p> The type of load balancer. The default lists the SSL policies for all load
    /// balancers.</p>
    pub load_balancer_type: std::option::Option<crate::model::LoadBalancerTypeEnum>,
}
impl std::fmt::Debug for DescribeSslPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSslPoliciesInput");
        formatter.field("names", &self.names);
        formatter.field("marker", &self.marker);
        formatter.field("page_size", &self.page_size);
        formatter.field("load_balancer_type", &self.load_balancer_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRulesInput {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARN) of the rules.</p>
    pub rule_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The marker for the next set of results. (You received this marker from a previous
    /// call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with this call.</p>
    pub page_size: std::option::Option<i32>,
}
impl std::fmt::Debug for DescribeRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRulesInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("rule_arns", &self.rule_arns);
        formatter.field("marker", &self.marker);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoadBalancersInput {
    /// <p>The Amazon Resource Names (ARN) of the load balancers. You can specify up to 20 load
    /// balancers in a single call.</p>
    pub load_balancer_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of the load balancers.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The marker for the next set of results. (You received this marker from a previous
    /// call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with this call.</p>
    pub page_size: std::option::Option<i32>,
}
impl std::fmt::Debug for DescribeLoadBalancersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoadBalancersInput");
        formatter.field("load_balancer_arns", &self.load_balancer_arns);
        formatter.field("names", &self.names);
        formatter.field("marker", &self.marker);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoadBalancerAttributesInput {
    /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    pub load_balancer_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeLoadBalancerAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoadBalancerAttributesInput");
        formatter.field("load_balancer_arn", &self.load_balancer_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeListenersInput {
    /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    pub load_balancer_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARN) of the listeners.</p>
    pub listener_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The marker for the next set of results. (You received this marker from a previous
    /// call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with this call.</p>
    pub page_size: std::option::Option<i32>,
}
impl std::fmt::Debug for DescribeListenersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeListenersInput");
        formatter.field("load_balancer_arn", &self.load_balancer_arn);
        formatter.field("listener_arns", &self.listener_arns);
        formatter.field("marker", &self.marker);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeListenerCertificatesInput {
    /// <p>The Amazon Resource Names (ARN) of the listener.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The marker for the next set of results. (You received this marker from a previous
    /// call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with this call.</p>
    pub page_size: std::option::Option<i32>,
}
impl std::fmt::Debug for DescribeListenerCertificatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeListenerCertificatesInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("marker", &self.marker);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountLimitsInput {
    /// <p>The marker for the next set of results. (You received this marker from a previous
    /// call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with this call.</p>
    pub page_size: std::option::Option<i32>,
}
impl std::fmt::Debug for DescribeAccountLimitsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountLimitsInput");
        formatter.field("marker", &self.marker);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterTargetsInput {
    /// <p>The Amazon Resource Name (ARN) of the target group.</p>
    pub target_group_arn: std::option::Option<std::string::String>,
    /// <p>The targets. If you specified a port override when you registered a target, you must
    /// specify both the target ID and the port when you deregister it.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::TargetDescription>>,
}
impl std::fmt::Debug for DeregisterTargetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterTargetsInput");
        formatter.field("target_group_arn", &self.target_group_arn);
        formatter.field("targets", &self.targets);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTargetGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the target group.</p>
    pub target_group_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteTargetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTargetGroupInput");
        formatter.field("target_group_arn", &self.target_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRuleInput {
    /// <p>The Amazon Resource Name (ARN) of the rule.</p>
    pub rule_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRuleInput");
        formatter.field("rule_arn", &self.rule_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLoadBalancerInput {
    /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    pub load_balancer_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteLoadBalancerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLoadBalancerInput");
        formatter.field("load_balancer_arn", &self.load_balancer_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub listener_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteListenerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteListenerInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTargetGroupInput {
    /// <p>The name of the target group.</p>
    /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must
    /// contain only alphanumeric characters or hyphens, and must not begin or end with a
    /// hyphen.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The protocol to use for routing traffic to the targets. For Application Load Balancers,
    /// the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported
    /// protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is
    /// GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a
    /// Lambda function, this parameter does not apply.</p>
    pub protocol: std::option::Option<crate::model::ProtocolEnum>,
    /// <p>[HTTP/HTTPS protocol] The protocol version. Specify <code>GRPC</code> to send requests to
    /// targets using gRPC. Specify <code>HTTP2</code> to send requests to targets using HTTP/2. The
    /// default is <code>HTTP1</code>, which sends requests to targets using HTTP/1.1.</p>
    pub protocol_version: std::option::Option<std::string::String>,
    /// <p>The port on which the targets receive traffic. This port is used unless you specify a port
    /// override when registering the target. If the target is a Lambda function, this parameter does
    /// not apply. If the protocol is GENEVE, the supported port is 6081.</p>
    pub port: std::option::Option<i32>,
    /// <p>The identifier of the virtual private cloud (VPC). If the target is a Lambda function,
    /// this parameter does not apply. Otherwise, this parameter is required.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The protocol the load balancer uses when performing health checks on targets. For
    /// Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load
    /// Balancers, the default is TCP. The TCP protocol is not supported for health checks if the
    /// protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are
    /// not supported for health checks.</p>
    pub health_check_protocol: std::option::Option<crate::model::ProtocolEnum>,
    /// <p>The port the load balancer uses when performing health checks on targets. If the protocol
    /// is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code>, which is
    /// the port on which each target receives traffic from the load balancer. If the protocol is
    /// GENEVE, the default is port 80.</p>
    pub health_check_port: std::option::Option<std::string::String>,
    /// <p>Indicates whether health checks are enabled. If the target type is <code>lambda</code>,
    /// health checks are disabled by default but can be enabled. If the target type is
    /// <code>instance</code>, <code>ip</code>, or <code>alb</code>, health checks are always
    /// enabled and cannot be disabled.</p>
    pub health_check_enabled: std::option::Option<bool>,
    /// <p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p>
    /// <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p>
    /// <p>[GRPC protocol version] The path of a custom health check method with the format
    /// /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>
    pub health_check_path: std::option::Option<std::string::String>,
    /// <p>The approximate amount of time, in seconds, between health checks of an individual target.
    /// If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30
    /// seconds. If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the
    /// target group protocol is GENEVE, the default is 10 seconds. If the target type is
    /// <code>lambda</code>, the default is 35 seconds.</p>
    pub health_check_interval_seconds: std::option::Option<i32>,
    /// <p>The amount of time, in seconds, during which no response from a target means a failed
    /// health check. For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5
    /// seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for
    /// HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is
    /// <code>lambda</code>, the default is 30 seconds.</p>
    pub health_check_timeout_seconds: std::option::Option<i32>,
    /// <p>The number of consecutive health checks successes required before considering an unhealthy
    /// target healthy. For target groups with a protocol of HTTP or HTTPS, the default is 5. For
    /// target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is
    /// <code>lambda</code>, the default is 5.</p>
    pub healthy_threshold_count: std::option::Option<i32>,
    /// <p>The number of consecutive health check failures required before considering a target
    /// unhealthy. If the target group protocol is HTTP or HTTPS, the default is 2. If the target
    /// group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If
    /// the target group protocol is GENEVE, the default is 3. If the target type is
    /// <code>lambda</code>, the default is 2.</p>
    pub unhealthy_threshold_count: std::option::Option<i32>,
    /// <p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful
    /// response from a target.</p>
    pub matcher: std::option::Option<crate::model::Matcher>,
    /// <p>The type of target that you must specify when registering targets with this target group.
    /// You can't specify targets for a target group using more than one target type.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>instance</code> - Register targets by instance ID. This is the default
    /// value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ip</code> - Register targets by IP address. You can specify IP addresses from
    /// the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range
    /// (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10).
    /// You can't specify publicly routable IP addresses.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>lambda</code> - Register a single Lambda function as a target.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>alb</code> - Register a single Application Load Balancer as a target.</p>
    /// </li>
    /// </ul>
    pub target_type: std::option::Option<crate::model::TargetTypeEnum>,
    /// <p>The tags to assign to the target group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The type of IP address used for this target group. The possible values are
    /// <code>ipv4</code> and <code>ipv6</code>. This is an optional parameter. If not specified,
    /// the IP address type defaults to <code>ipv4</code>.</p>
    pub ip_address_type: std::option::Option<crate::model::TargetGroupIpAddressTypeEnum>,
}
impl std::fmt::Debug for CreateTargetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTargetGroupInput");
        formatter.field("name", &self.name);
        formatter.field("protocol", &self.protocol);
        formatter.field("protocol_version", &self.protocol_version);
        formatter.field("port", &self.port);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("health_check_protocol", &self.health_check_protocol);
        formatter.field("health_check_port", &self.health_check_port);
        formatter.field("health_check_enabled", &self.health_check_enabled);
        formatter.field("health_check_path", &self.health_check_path);
        formatter.field(
            "health_check_interval_seconds",
            &self.health_check_interval_seconds,
        );
        formatter.field(
            "health_check_timeout_seconds",
            &self.health_check_timeout_seconds,
        );
        formatter.field("healthy_threshold_count", &self.healthy_threshold_count);
        formatter.field("unhealthy_threshold_count", &self.unhealthy_threshold_count);
        formatter.field("matcher", &self.matcher);
        formatter.field("target_type", &self.target_type);
        formatter.field("tags", &self.tags);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRuleInput {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The conditions.</p>
    pub conditions: std::option::Option<std::vec::Vec<crate::model::RuleCondition>>,
    /// <p>The rule priority. A listener can't have multiple rules with the same priority.</p>
    pub priority: std::option::Option<i32>,
    /// <p>The actions.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    /// <p>The tags to assign to the rule.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRuleInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("conditions", &self.conditions);
        formatter.field("priority", &self.priority);
        formatter.field("actions", &self.actions);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    /// <p>This name must be unique per region per account, can have a maximum of 32 characters, must
    /// contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must
    /// not begin with "internal-".</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You
    /// must specify either subnets or subnet mappings.</p>
    /// <p>[Application Load Balancers] You must specify subnets from at least two Availability
    /// Zones.</p>
    /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
    /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local
    /// Zones.</p>
    /// <p>[Network Load Balancers] You can specify subnets from one or more Availability
    /// Zones.</p>
    /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability
    /// Zones.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You
    /// must specify either subnets or subnet mappings.</p>
    /// <p>[Application Load Balancers] You must specify subnets from at least two Availability
    /// Zones. You cannot specify Elastic IP addresses for your subnets.</p>
    /// <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p>
    /// <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local
    /// Zones.</p>
    /// <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You
    /// can specify one Elastic IP address per subnet if you need static IP addresses for your
    /// internet-facing load balancer. For internal load balancers, you can specify one private IP
    /// address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you
    /// can specify one IPv6 address per subnet.</p>
    /// <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You
    /// cannot specify Elastic IP addresses for your subnets.</p>
    pub subnet_mappings: std::option::Option<std::vec::Vec<crate::model::SubnetMapping>>,
    /// <p>[Application Load Balancers] The IDs of the security groups for the load balancer.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an
    /// Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes.
    /// Therefore, Internet-facing load balancers can route requests from clients over the
    /// internet.</p>
    /// <p>The nodes of an internal load balancer have only private IP addresses. The DNS name of an
    /// internal load balancer is publicly resolvable to the private IP addresses of the nodes.
    /// Therefore, internal load balancers can route requests only from clients with access to the VPC
    /// for the load balancer.</p>
    /// <p>The default is an Internet-facing load balancer.</p>
    /// <p>You cannot specify a scheme for a Gateway Load Balancer.</p>
    pub scheme: std::option::Option<crate::model::LoadBalancerSchemeEnum>,
    /// <p>The tags to assign to the load balancer.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The type of load balancer. The default is <code>application</code>.</p>
    pub r#type: std::option::Option<crate::model::LoadBalancerTypeEnum>,
    /// <p>The type of IP addresses used by the subnets for your load balancer. The possible values
    /// are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6
    /// addresses). Internal load balancers must use <code>ipv4</code>.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
    /// <p>[Application Load Balancers on Outposts] The ID of the customer-owned address pool (CoIP
    /// pool).</p>
    pub customer_owned_ipv4_pool: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateLoadBalancerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLoadBalancerInput");
        formatter.field("name", &self.name);
        formatter.field("subnets", &self.subnets);
        formatter.field("subnet_mappings", &self.subnet_mappings);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("scheme", &self.scheme);
        formatter.field("tags", &self.tags);
        formatter.field("r#type", &self.r#type);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.field("customer_owned_ipv4_pool", &self.customer_owned_ipv4_pool);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    pub load_balancer_arn: std::option::Option<std::string::String>,
    /// <p>The protocol for connections from clients to the load balancer. For Application Load
    /// Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the
    /// supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP
    /// protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load
    /// Balancer.</p>
    pub protocol: std::option::Option<crate::model::ProtocolEnum>,
    /// <p>The port on which the load balancer is listening. You cannot specify a port for a Gateway
    /// Load Balancer.</p>
    pub port: std::option::Option<i32>,
    /// <p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are
    /// supported.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> and
    /// <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>
    pub ssl_policy: std::option::Option<std::string::String>,
    /// <p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide
    /// exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set
    /// <code>IsDefault</code>.</p>
    pub certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
    /// <p>The actions for the default rule.</p>
    pub default_actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    /// <p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You
    /// can specify one policy name. The following are the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HTTP1Only</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HTTP2Only</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HTTP2Optional</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HTTP2Preferred</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>None</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN
    /// policies</a> in the <i>Network Load Balancers Guide</i>.</p>
    pub alpn_policy: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to assign to the listener.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateListenerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateListenerInput");
        formatter.field("load_balancer_arn", &self.load_balancer_arn);
        formatter.field("protocol", &self.protocol);
        formatter.field("port", &self.port);
        formatter.field("ssl_policy", &self.ssl_policy);
        formatter.field("certificates", &self.certificates);
        formatter.field("default_actions", &self.default_actions);
        formatter.field("alpn_policy", &self.alpn_policy);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for AddTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsInput");
        formatter.field("resource_arns", &self.resource_arns);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddListenerCertificatesInput {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The certificate to add. You can specify one certificate per call. Set
    /// <code>CertificateArn</code> to the certificate ARN but do not set
    /// <code>IsDefault</code>.</p>
    pub certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
}
impl std::fmt::Debug for AddListenerCertificatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddListenerCertificatesInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("certificates", &self.certificates);
        formatter.finish()
    }
}
