// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::AccessPointNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateTagKeys" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::DuplicateTagKeysException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_tag_keys_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_tag_keys_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTags" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_tags_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_apply_security_groups_to_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ApplySecurityGroupsToLoadBalancerOutput,
    crate::error::ApplySecurityGroupsToLoadBalancerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ApplySecurityGroupsToLoadBalancerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ApplySecurityGroupsToLoadBalancerError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::ApplySecurityGroupsToLoadBalancerError { meta: generic, kind: crate::error::ApplySecurityGroupsToLoadBalancerErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ApplySecurityGroupsToLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::ApplySecurityGroupsToLoadBalancerError { meta: generic, kind: crate::error::ApplySecurityGroupsToLoadBalancerErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ApplySecurityGroupsToLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSecurityGroup" => crate::error::ApplySecurityGroupsToLoadBalancerError { meta: generic, kind: crate::error::ApplySecurityGroupsToLoadBalancerErrorKind::InvalidSecurityGroupException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_security_group_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_security_group_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ApplySecurityGroupsToLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ApplySecurityGroupsToLoadBalancerError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_apply_security_groups_to_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ApplySecurityGroupsToLoadBalancerOutput,
    crate::error::ApplySecurityGroupsToLoadBalancerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::apply_security_groups_to_load_balancer_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_apply_security_groups_to_load_balancer(response.body().as_ref(), output).map_err(crate::error::ApplySecurityGroupsToLoadBalancerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_load_balancer_to_subnets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AttachLoadBalancerToSubnetsOutput,
    crate::error::AttachLoadBalancerToSubnetsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachLoadBalancerToSubnetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AttachLoadBalancerToSubnetsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::AttachLoadBalancerToSubnetsError { meta: generic, kind: crate::error::AttachLoadBalancerToSubnetsErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerToSubnetsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::AttachLoadBalancerToSubnetsError { meta: generic, kind: crate::error::AttachLoadBalancerToSubnetsErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerToSubnetsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSubnet" => crate::error::AttachLoadBalancerToSubnetsError { meta: generic, kind: crate::error::AttachLoadBalancerToSubnetsErrorKind::InvalidSubnetException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_subnet_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerToSubnetsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SubnetNotFound" => crate::error::AttachLoadBalancerToSubnetsError { meta: generic, kind: crate::error::AttachLoadBalancerToSubnetsErrorKind::SubnetNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::subnet_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subnet_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerToSubnetsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AttachLoadBalancerToSubnetsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_load_balancer_to_subnets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AttachLoadBalancerToSubnetsOutput,
    crate::error::AttachLoadBalancerToSubnetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::attach_load_balancer_to_subnets_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_attach_load_balancer_to_subnets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AttachLoadBalancerToSubnetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_configure_health_check_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ConfigureHealthCheckOutput,
    crate::error::ConfigureHealthCheckError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ConfigureHealthCheckError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ConfigureHealthCheckError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::ConfigureHealthCheckError {
            meta: generic,
            kind: crate::error::ConfigureHealthCheckErrorKind::AccessPointNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ConfigureHealthCheckError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ConfigureHealthCheckError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_configure_health_check_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ConfigureHealthCheckOutput,
    crate::error::ConfigureHealthCheckError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::configure_health_check_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_configure_health_check(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ConfigureHealthCheckError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_app_cookie_stickiness_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAppCookieStickinessPolicyOutput,
    crate::error::CreateAppCookieStickinessPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAppCookieStickinessPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAppCookieStickinessPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::CreateAppCookieStickinessPolicyError { meta: generic, kind: crate::error::CreateAppCookieStickinessPolicyErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAppCookieStickinessPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DuplicatePolicyName" => crate::error::CreateAppCookieStickinessPolicyError { meta: generic, kind: crate::error::CreateAppCookieStickinessPolicyErrorKind::DuplicatePolicyNameException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::duplicate_policy_name_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_policy_name_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAppCookieStickinessPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::CreateAppCookieStickinessPolicyError { meta: generic, kind: crate::error::CreateAppCookieStickinessPolicyErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAppCookieStickinessPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyPolicies" => crate::error::CreateAppCookieStickinessPolicyError { meta: generic, kind: crate::error::CreateAppCookieStickinessPolicyErrorKind::TooManyPoliciesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_policies_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_policies_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAppCookieStickinessPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateAppCookieStickinessPolicyError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_app_cookie_stickiness_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAppCookieStickinessPolicyOutput,
    crate::error::CreateAppCookieStickinessPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_app_cookie_stickiness_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_lb_cookie_stickiness_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLbCookieStickinessPolicyOutput,
    crate::error::CreateLBCookieStickinessPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLBCookieStickinessPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateLBCookieStickinessPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::CreateLBCookieStickinessPolicyError { meta: generic, kind: crate::error::CreateLBCookieStickinessPolicyErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLBCookieStickinessPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DuplicatePolicyName" => crate::error::CreateLBCookieStickinessPolicyError { meta: generic, kind: crate::error::CreateLBCookieStickinessPolicyErrorKind::DuplicatePolicyNameException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::duplicate_policy_name_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_policy_name_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLBCookieStickinessPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::CreateLBCookieStickinessPolicyError { meta: generic, kind: crate::error::CreateLBCookieStickinessPolicyErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLBCookieStickinessPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyPolicies" => crate::error::CreateLBCookieStickinessPolicyError { meta: generic, kind: crate::error::CreateLBCookieStickinessPolicyErrorKind::TooManyPoliciesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_policies_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_policies_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLBCookieStickinessPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateLBCookieStickinessPolicyError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_lb_cookie_stickiness_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLbCookieStickinessPolicyOutput,
    crate::error::CreateLBCookieStickinessPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_lb_cookie_stickiness_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoadBalancerOutput,
    crate::error::CreateLoadBalancerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLoadBalancerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateLoadBalancerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CertificateNotFound" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::CertificateNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::certificate_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_certificate_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateLoadBalancerName" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::DuplicateAccessPointNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::duplicate_access_point_name_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_access_point_name_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateTagKeys" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::DuplicateTagKeysException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_tag_keys_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_tag_keys_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidConfigurationRequest" => {
            crate::error::CreateLoadBalancerError {
                meta: generic,
                kind:
                    crate::error::CreateLoadBalancerErrorKind::InvalidConfigurationRequestException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InvalidScheme" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::InvalidSchemeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_scheme_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_scheme_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSecurityGroup" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::InvalidSecurityGroupException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_security_group_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_security_group_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::InvalidSubnetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermitted" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_not_permitted_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubnetNotFound" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::SubnetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::subnet_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subnet_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyLoadBalancers" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::TooManyAccessPointsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_access_points_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_access_points_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTags" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_tags_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedProtocol" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::UnsupportedProtocolException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_protocol_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_protocol_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLoadBalancerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoadBalancerOutput,
    crate::error::CreateLoadBalancerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_load_balancer_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_load_balancer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateLoadBalancerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_load_balancer_listeners_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoadBalancerListenersOutput,
    crate::error::CreateLoadBalancerListenersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLoadBalancerListenersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateLoadBalancerListenersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::CreateLoadBalancerListenersError { meta: generic, kind: crate::error::CreateLoadBalancerListenersErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerListenersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CertificateNotFound" => crate::error::CreateLoadBalancerListenersError { meta: generic, kind: crate::error::CreateLoadBalancerListenersErrorKind::CertificateNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::certificate_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_certificate_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerListenersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DuplicateListener" => crate::error::CreateLoadBalancerListenersError { meta: generic, kind: crate::error::CreateLoadBalancerListenersErrorKind::DuplicateListenerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::duplicate_listener_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_listener_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerListenersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::CreateLoadBalancerListenersError { meta: generic, kind: crate::error::CreateLoadBalancerListenersErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerListenersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedProtocol" => crate::error::CreateLoadBalancerListenersError { meta: generic, kind: crate::error::CreateLoadBalancerListenersErrorKind::UnsupportedProtocolException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_protocol_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_protocol_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerListenersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateLoadBalancerListenersError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_load_balancer_listeners_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoadBalancerListenersOutput,
    crate::error::CreateLoadBalancerListenersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_load_balancer_listeners_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_load_balancer_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoadBalancerPolicyOutput,
    crate::error::CreateLoadBalancerPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLoadBalancerPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateLoadBalancerPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::CreateLoadBalancerPolicyError { meta: generic, kind: crate::error::CreateLoadBalancerPolicyErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DuplicatePolicyName" => crate::error::CreateLoadBalancerPolicyError { meta: generic, kind: crate::error::CreateLoadBalancerPolicyErrorKind::DuplicatePolicyNameException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::duplicate_policy_name_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_policy_name_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::CreateLoadBalancerPolicyError { meta: generic, kind: crate::error::CreateLoadBalancerPolicyErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PolicyTypeNotFound" => crate::error::CreateLoadBalancerPolicyError { meta: generic, kind: crate::error::CreateLoadBalancerPolicyErrorKind::PolicyTypeNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::policy_type_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_policy_type_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyPolicies" => crate::error::CreateLoadBalancerPolicyError { meta: generic, kind: crate::error::CreateLoadBalancerPolicyErrorKind::TooManyPoliciesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_policies_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_policies_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateLoadBalancerPolicyError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_load_balancer_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoadBalancerPolicyOutput,
    crate::error::CreateLoadBalancerPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_load_balancer_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoadBalancerOutput,
    crate::error::DeleteLoadBalancerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
    Err(crate::error::DeleteLoadBalancerError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoadBalancerOutput,
    crate::error::DeleteLoadBalancerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_load_balancer_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_load_balancer_listeners_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoadBalancerListenersOutput,
    crate::error::DeleteLoadBalancerListenersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLoadBalancerListenersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteLoadBalancerListenersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DeleteLoadBalancerListenersError {
            meta: generic,
            kind: crate::error::DeleteLoadBalancerListenersErrorKind::AccessPointNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::access_point_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerListenersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteLoadBalancerListenersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_load_balancer_listeners_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoadBalancerListenersOutput,
    crate::error::DeleteLoadBalancerListenersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_load_balancer_listeners_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_load_balancer_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoadBalancerPolicyOutput,
    crate::error::DeleteLoadBalancerPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLoadBalancerPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteLoadBalancerPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DeleteLoadBalancerPolicyError { meta: generic, kind: crate::error::DeleteLoadBalancerPolicyErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::DeleteLoadBalancerPolicyError { meta: generic, kind: crate::error::DeleteLoadBalancerPolicyErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteLoadBalancerPolicyError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_load_balancer_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoadBalancerPolicyOutput,
    crate::error::DeleteLoadBalancerPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_load_balancer_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_instances_from_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterInstancesFromLoadBalancerOutput,
    crate::error::DeregisterInstancesFromLoadBalancerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterInstancesFromLoadBalancerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeregisterInstancesFromLoadBalancerError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DeregisterInstancesFromLoadBalancerError { meta: generic, kind: crate::error::DeregisterInstancesFromLoadBalancerErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeregisterInstancesFromLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInstance" => crate::error::DeregisterInstancesFromLoadBalancerError { meta: generic, kind: crate::error::DeregisterInstancesFromLoadBalancerErrorKind::InvalidEndPointException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_end_point_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_end_point_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeregisterInstancesFromLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeregisterInstancesFromLoadBalancerError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_instances_from_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterInstancesFromLoadBalancerOutput,
    crate::error::DeregisterInstancesFromLoadBalancerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::deregister_instances_from_load_balancer_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_deregister_instances_from_load_balancer(response.body().as_ref(), output).map_err(crate::error::DeregisterInstancesFromLoadBalancerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_limits_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountLimitsOutput,
    crate::error::DescribeAccountLimitsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAccountLimitsError::unhandled)?;
    Err(crate::error::DescribeAccountLimitsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_limits_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountLimitsOutput,
    crate::error::DescribeAccountLimitsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_account_limits_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_account_limits(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAccountLimitsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_instance_health_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInstanceHealthOutput,
    crate::error::DescribeInstanceHealthError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeInstanceHealthError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeInstanceHealthError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DescribeInstanceHealthError {
            meta: generic,
            kind: crate::error::DescribeInstanceHealthErrorKind::AccessPointNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeInstanceHealthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInstance" => crate::error::DescribeInstanceHealthError {
            meta: generic,
            kind: crate::error::DescribeInstanceHealthErrorKind::InvalidEndPointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_end_point_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_end_point_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeInstanceHealthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeInstanceHealthError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_instance_health_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInstanceHealthOutput,
    crate::error::DescribeInstanceHealthError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_instance_health_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_instance_health(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeInstanceHealthError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancer_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancerAttributesOutput,
    crate::error::DescribeLoadBalancerAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLoadBalancerAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLoadBalancerAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DescribeLoadBalancerAttributesError { meta: generic, kind: crate::error::DescribeLoadBalancerAttributesErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoadBalancerAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LoadBalancerAttributeNotFound" => crate::error::DescribeLoadBalancerAttributesError { meta: generic, kind: crate::error::DescribeLoadBalancerAttributesErrorKind::LoadBalancerAttributeNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::load_balancer_attribute_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_attribute_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoadBalancerAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeLoadBalancerAttributesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancer_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancerAttributesOutput,
    crate::error::DescribeLoadBalancerAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_load_balancer_attributes_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_load_balancer_attributes(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeLoadBalancerAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancer_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancerPoliciesOutput,
    crate::error::DescribeLoadBalancerPoliciesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLoadBalancerPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeLoadBalancerPoliciesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DescribeLoadBalancerPoliciesError {
            meta: generic,
            kind: crate::error::DescribeLoadBalancerPoliciesErrorKind::AccessPointNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::access_point_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoadBalancerPoliciesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "PolicyNotFound" => crate::error::DescribeLoadBalancerPoliciesError {
            meta: generic,
            kind: crate::error::DescribeLoadBalancerPoliciesErrorKind::PolicyNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_policy_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoadBalancerPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLoadBalancerPoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancer_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancerPoliciesOutput,
    crate::error::DescribeLoadBalancerPoliciesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_load_balancer_policies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_load_balancer_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLoadBalancerPoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancer_policy_types_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancerPolicyTypesOutput,
    crate::error::DescribeLoadBalancerPolicyTypesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLoadBalancerPolicyTypesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLoadBalancerPolicyTypesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "PolicyTypeNotFound" => crate::error::DescribeLoadBalancerPolicyTypesError {
            meta: generic,
            kind:
                crate::error::DescribeLoadBalancerPolicyTypesErrorKind::PolicyTypeNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::policy_type_not_found_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_policy_type_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoadBalancerPolicyTypesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeLoadBalancerPolicyTypesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancer_policy_types_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancerPolicyTypesOutput,
    crate::error::DescribeLoadBalancerPolicyTypesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_load_balancer_policy_types_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_load_balancer_policy_types(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeLoadBalancerPolicyTypesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancersOutput,
    crate::error::DescribeLoadBalancersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLoadBalancersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLoadBalancersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DescribeLoadBalancersError {
            meta: generic,
            kind: crate::error::DescribeLoadBalancersErrorKind::AccessPointNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoadBalancersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DependencyThrottle" => crate::error::DescribeLoadBalancersError {
            meta: generic,
            kind: crate::error::DescribeLoadBalancersErrorKind::DependencyThrottleException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::dependency_throttle_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dependency_throttle_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoadBalancersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLoadBalancersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancersOutput,
    crate::error::DescribeLoadBalancersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_load_balancers_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_load_balancers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLoadBalancersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::AccessPointNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_tags_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_load_balancer_from_subnets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetachLoadBalancerFromSubnetsOutput,
    crate::error::DetachLoadBalancerFromSubnetsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetachLoadBalancerFromSubnetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DetachLoadBalancerFromSubnetsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DetachLoadBalancerFromSubnetsError { meta: generic, kind: crate::error::DetachLoadBalancerFromSubnetsErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachLoadBalancerFromSubnetsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::DetachLoadBalancerFromSubnetsError { meta: generic, kind: crate::error::DetachLoadBalancerFromSubnetsErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachLoadBalancerFromSubnetsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DetachLoadBalancerFromSubnetsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_load_balancer_from_subnets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetachLoadBalancerFromSubnetsOutput,
    crate::error::DetachLoadBalancerFromSubnetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::detach_load_balancer_from_subnets_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_detach_load_balancer_from_subnets(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DetachLoadBalancerFromSubnetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_availability_zones_for_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableAvailabilityZonesForLoadBalancerOutput,
    crate::error::DisableAvailabilityZonesForLoadBalancerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableAvailabilityZonesForLoadBalancerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DisableAvailabilityZonesForLoadBalancerError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::DisableAvailabilityZonesForLoadBalancerError { meta: generic, kind: crate::error::DisableAvailabilityZonesForLoadBalancerErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DisableAvailabilityZonesForLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::DisableAvailabilityZonesForLoadBalancerError { meta: generic, kind: crate::error::DisableAvailabilityZonesForLoadBalancerErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DisableAvailabilityZonesForLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DisableAvailabilityZonesForLoadBalancerError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_availability_zones_for_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableAvailabilityZonesForLoadBalancerOutput,
    crate::error::DisableAvailabilityZonesForLoadBalancerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::disable_availability_zones_for_load_balancer_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_disable_availability_zones_for_load_balancer(response.body().as_ref(), output).map_err(crate::error::DisableAvailabilityZonesForLoadBalancerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_availability_zones_for_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableAvailabilityZonesForLoadBalancerOutput,
    crate::error::EnableAvailabilityZonesForLoadBalancerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableAvailabilityZonesForLoadBalancerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::EnableAvailabilityZonesForLoadBalancerError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::EnableAvailabilityZonesForLoadBalancerError { meta: generic, kind: crate::error::EnableAvailabilityZonesForLoadBalancerErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableAvailabilityZonesForLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::EnableAvailabilityZonesForLoadBalancerError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_availability_zones_for_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableAvailabilityZonesForLoadBalancerOutput,
    crate::error::EnableAvailabilityZonesForLoadBalancerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::enable_availability_zones_for_load_balancer_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_enable_availability_zones_for_load_balancer(response.body().as_ref(), output).map_err(crate::error::EnableAvailabilityZonesForLoadBalancerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_load_balancer_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyLoadBalancerAttributesOutput,
    crate::error::ModifyLoadBalancerAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyLoadBalancerAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyLoadBalancerAttributesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::ModifyLoadBalancerAttributesError { meta: generic, kind: crate::error::ModifyLoadBalancerAttributesErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyLoadBalancerAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::ModifyLoadBalancerAttributesError { meta: generic, kind: crate::error::ModifyLoadBalancerAttributesErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyLoadBalancerAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LoadBalancerAttributeNotFound" => crate::error::ModifyLoadBalancerAttributesError { meta: generic, kind: crate::error::ModifyLoadBalancerAttributesErrorKind::LoadBalancerAttributeNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::load_balancer_attribute_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_load_balancer_attribute_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyLoadBalancerAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyLoadBalancerAttributesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_load_balancer_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyLoadBalancerAttributesOutput,
    crate::error::ModifyLoadBalancerAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_load_balancer_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_load_balancer_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyLoadBalancerAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_instances_with_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterInstancesWithLoadBalancerOutput,
    crate::error::RegisterInstancesWithLoadBalancerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterInstancesWithLoadBalancerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RegisterInstancesWithLoadBalancerError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::RegisterInstancesWithLoadBalancerError { meta: generic, kind: crate::error::RegisterInstancesWithLoadBalancerErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterInstancesWithLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInstance" => crate::error::RegisterInstancesWithLoadBalancerError { meta: generic, kind: crate::error::RegisterInstancesWithLoadBalancerErrorKind::InvalidEndPointException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_end_point_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_end_point_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterInstancesWithLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RegisterInstancesWithLoadBalancerError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_instances_with_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterInstancesWithLoadBalancerOutput,
    crate::error::RegisterInstancesWithLoadBalancerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::register_instances_with_load_balancer_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_register_instances_with_load_balancer(response.body().as_ref(), output).map_err(crate::error::RegisterInstancesWithLoadBalancerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RemoveTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::AccessPointNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_load_balancer_listener_ssl_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetLoadBalancerListenerSslCertificateOutput,
    crate::error::SetLoadBalancerListenerSSLCertificateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetLoadBalancerListenerSSLCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::SetLoadBalancerListenerSSLCertificateError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::SetLoadBalancerListenerSSLCertificateError { meta: generic, kind: crate::error::SetLoadBalancerListenerSSLCertificateErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetLoadBalancerListenerSSLCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CertificateNotFound" => crate::error::SetLoadBalancerListenerSSLCertificateError { meta: generic, kind: crate::error::SetLoadBalancerListenerSSLCertificateErrorKind::CertificateNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::certificate_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_certificate_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetLoadBalancerListenerSSLCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::SetLoadBalancerListenerSSLCertificateError { meta: generic, kind: crate::error::SetLoadBalancerListenerSSLCertificateErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetLoadBalancerListenerSSLCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ListenerNotFound" => crate::error::SetLoadBalancerListenerSSLCertificateError { meta: generic, kind: crate::error::SetLoadBalancerListenerSSLCertificateErrorKind::ListenerNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_listener_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetLoadBalancerListenerSSLCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedProtocol" => crate::error::SetLoadBalancerListenerSSLCertificateError { meta: generic, kind: crate::error::SetLoadBalancerListenerSSLCertificateErrorKind::UnsupportedProtocolException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_protocol_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_protocol_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetLoadBalancerListenerSSLCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::SetLoadBalancerListenerSSLCertificateError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_load_balancer_listener_ssl_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetLoadBalancerListenerSslCertificateOutput,
    crate::error::SetLoadBalancerListenerSSLCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::set_load_balancer_listener_ssl_certificate_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_load_balancer_policies_for_backend_server_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetLoadBalancerPoliciesForBackendServerOutput,
    crate::error::SetLoadBalancerPoliciesForBackendServerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetLoadBalancerPoliciesForBackendServerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::SetLoadBalancerPoliciesForBackendServerError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::SetLoadBalancerPoliciesForBackendServerError { meta: generic, kind: crate::error::SetLoadBalancerPoliciesForBackendServerErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetLoadBalancerPoliciesForBackendServerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::SetLoadBalancerPoliciesForBackendServerError { meta: generic, kind: crate::error::SetLoadBalancerPoliciesForBackendServerErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetLoadBalancerPoliciesForBackendServerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PolicyNotFound" => crate::error::SetLoadBalancerPoliciesForBackendServerError { meta: generic, kind: crate::error::SetLoadBalancerPoliciesForBackendServerErrorKind::PolicyNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_policy_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetLoadBalancerPoliciesForBackendServerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::SetLoadBalancerPoliciesForBackendServerError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_load_balancer_policies_for_backend_server_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetLoadBalancerPoliciesForBackendServerOutput,
    crate::error::SetLoadBalancerPoliciesForBackendServerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::set_load_balancer_policies_for_backend_server_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_load_balancer_policies_of_listener_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetLoadBalancerPoliciesOfListenerOutput,
    crate::error::SetLoadBalancerPoliciesOfListenerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetLoadBalancerPoliciesOfListenerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SetLoadBalancerPoliciesOfListenerError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LoadBalancerNotFound" => crate::error::SetLoadBalancerPoliciesOfListenerError { meta: generic, kind: crate::error::SetLoadBalancerPoliciesOfListenerErrorKind::AccessPointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_point_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_point_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetLoadBalancerPoliciesOfListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationRequest" => crate::error::SetLoadBalancerPoliciesOfListenerError { meta: generic, kind: crate::error::SetLoadBalancerPoliciesOfListenerErrorKind::InvalidConfigurationRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetLoadBalancerPoliciesOfListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ListenerNotFound" => crate::error::SetLoadBalancerPoliciesOfListenerError { meta: generic, kind: crate::error::SetLoadBalancerPoliciesOfListenerErrorKind::ListenerNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_listener_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetLoadBalancerPoliciesOfListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PolicyNotFound" => crate::error::SetLoadBalancerPoliciesOfListenerError { meta: generic, kind: crate::error::SetLoadBalancerPoliciesOfListenerErrorKind::PolicyNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_policy_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetLoadBalancerPoliciesOfListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::SetLoadBalancerPoliciesOfListenerError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_load_balancer_policies_of_listener_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetLoadBalancerPoliciesOfListenerOutput,
    crate::error::SetLoadBalancerPoliciesOfListenerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::set_load_balancer_policies_of_listener_output::Builder::default();
        let _ = response;
        output.build()
    })
}
