// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags`](crate::client::Client::add_tags).
///
/// See [`crate::client::fluent_builders::AddTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTags {
    _private: (),
}
impl AddTags {
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
    /// Creates a new `AddTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTags {
    type Output = std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_tags_error(response)
        } else {
            crate::operation_deser::parse_add_tags_response(response)
        }
    }
}

/// Operation shape for `ApplySecurityGroupsToLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`apply_security_groups_to_load_balancer`](crate::client::Client::apply_security_groups_to_load_balancer).
///
/// See [`crate::client::fluent_builders::ApplySecurityGroupsToLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ApplySecurityGroupsToLoadBalancer {
    _private: (),
}
impl ApplySecurityGroupsToLoadBalancer {
    /// Creates a new builder-style object to manufacture [`ApplySecurityGroupsToLoadBalancerInput`](crate::input::ApplySecurityGroupsToLoadBalancerInput)
    pub fn builder() -> crate::input::apply_security_groups_to_load_balancer_input::Builder {
        crate::input::apply_security_groups_to_load_balancer_input::Builder::default()
    }
    /// Creates a new `ApplySecurityGroupsToLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ApplySecurityGroupsToLoadBalancer {
    type Output = std::result::Result<
        crate::output::ApplySecurityGroupsToLoadBalancerOutput,
        crate::error::ApplySecurityGroupsToLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_apply_security_groups_to_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_apply_security_groups_to_load_balancer_response(response)
        }
    }
}

/// Operation shape for `AttachLoadBalancerToSubnets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_load_balancer_to_subnets`](crate::client::Client::attach_load_balancer_to_subnets).
///
/// See [`crate::client::fluent_builders::AttachLoadBalancerToSubnets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachLoadBalancerToSubnets {
    _private: (),
}
impl AttachLoadBalancerToSubnets {
    /// Creates a new builder-style object to manufacture [`AttachLoadBalancerToSubnetsInput`](crate::input::AttachLoadBalancerToSubnetsInput)
    pub fn builder() -> crate::input::attach_load_balancer_to_subnets_input::Builder {
        crate::input::attach_load_balancer_to_subnets_input::Builder::default()
    }
    /// Creates a new `AttachLoadBalancerToSubnets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachLoadBalancerToSubnets {
    type Output = std::result::Result<
        crate::output::AttachLoadBalancerToSubnetsOutput,
        crate::error::AttachLoadBalancerToSubnetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_load_balancer_to_subnets_error(response)
        } else {
            crate::operation_deser::parse_attach_load_balancer_to_subnets_response(response)
        }
    }
}

/// Operation shape for `ConfigureHealthCheck`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`configure_health_check`](crate::client::Client::configure_health_check).
///
/// See [`crate::client::fluent_builders::ConfigureHealthCheck`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ConfigureHealthCheck {
    _private: (),
}
impl ConfigureHealthCheck {
    /// Creates a new builder-style object to manufacture [`ConfigureHealthCheckInput`](crate::input::ConfigureHealthCheckInput)
    pub fn builder() -> crate::input::configure_health_check_input::Builder {
        crate::input::configure_health_check_input::Builder::default()
    }
    /// Creates a new `ConfigureHealthCheck` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ConfigureHealthCheck {
    type Output = std::result::Result<
        crate::output::ConfigureHealthCheckOutput,
        crate::error::ConfigureHealthCheckError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_configure_health_check_error(response)
        } else {
            crate::operation_deser::parse_configure_health_check_response(response)
        }
    }
}

/// Operation shape for `CreateAppCookieStickinessPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_app_cookie_stickiness_policy`](crate::client::Client::create_app_cookie_stickiness_policy).
///
/// See [`crate::client::fluent_builders::CreateAppCookieStickinessPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAppCookieStickinessPolicy {
    _private: (),
}
impl CreateAppCookieStickinessPolicy {
    /// Creates a new builder-style object to manufacture [`CreateAppCookieStickinessPolicyInput`](crate::input::CreateAppCookieStickinessPolicyInput)
    pub fn builder() -> crate::input::create_app_cookie_stickiness_policy_input::Builder {
        crate::input::create_app_cookie_stickiness_policy_input::Builder::default()
    }
    /// Creates a new `CreateAppCookieStickinessPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAppCookieStickinessPolicy {
    type Output = std::result::Result<
        crate::output::CreateAppCookieStickinessPolicyOutput,
        crate::error::CreateAppCookieStickinessPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_app_cookie_stickiness_policy_error(response)
        } else {
            crate::operation_deser::parse_create_app_cookie_stickiness_policy_response(response)
        }
    }
}

/// Operation shape for `CreateLBCookieStickinessPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_lb_cookie_stickiness_policy`](crate::client::Client::create_lb_cookie_stickiness_policy).
///
/// See [`crate::client::fluent_builders::CreateLBCookieStickinessPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLBCookieStickinessPolicy {
    _private: (),
}
impl CreateLBCookieStickinessPolicy {
    /// Creates a new builder-style object to manufacture [`CreateLbCookieStickinessPolicyInput`](crate::input::CreateLbCookieStickinessPolicyInput)
    pub fn builder() -> crate::input::create_lb_cookie_stickiness_policy_input::Builder {
        crate::input::create_lb_cookie_stickiness_policy_input::Builder::default()
    }
    /// Creates a new `CreateLBCookieStickinessPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLBCookieStickinessPolicy {
    type Output = std::result::Result<
        crate::output::CreateLbCookieStickinessPolicyOutput,
        crate::error::CreateLBCookieStickinessPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_lb_cookie_stickiness_policy_error(response)
        } else {
            crate::operation_deser::parse_create_lb_cookie_stickiness_policy_response(response)
        }
    }
}

/// Operation shape for `CreateLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_load_balancer`](crate::client::Client::create_load_balancer).
///
/// See [`crate::client::fluent_builders::CreateLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLoadBalancer {
    _private: (),
}
impl CreateLoadBalancer {
    /// Creates a new builder-style object to manufacture [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
    pub fn builder() -> crate::input::create_load_balancer_input::Builder {
        crate::input::create_load_balancer_input::Builder::default()
    }
    /// Creates a new `CreateLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLoadBalancer {
    type Output = std::result::Result<
        crate::output::CreateLoadBalancerOutput,
        crate::error::CreateLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_create_load_balancer_response(response)
        }
    }
}

/// Operation shape for `CreateLoadBalancerListeners`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_load_balancer_listeners`](crate::client::Client::create_load_balancer_listeners).
///
/// See [`crate::client::fluent_builders::CreateLoadBalancerListeners`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLoadBalancerListeners {
    _private: (),
}
impl CreateLoadBalancerListeners {
    /// Creates a new builder-style object to manufacture [`CreateLoadBalancerListenersInput`](crate::input::CreateLoadBalancerListenersInput)
    pub fn builder() -> crate::input::create_load_balancer_listeners_input::Builder {
        crate::input::create_load_balancer_listeners_input::Builder::default()
    }
    /// Creates a new `CreateLoadBalancerListeners` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLoadBalancerListeners {
    type Output = std::result::Result<
        crate::output::CreateLoadBalancerListenersOutput,
        crate::error::CreateLoadBalancerListenersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_load_balancer_listeners_error(response)
        } else {
            crate::operation_deser::parse_create_load_balancer_listeners_response(response)
        }
    }
}

/// Operation shape for `CreateLoadBalancerPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_load_balancer_policy`](crate::client::Client::create_load_balancer_policy).
///
/// See [`crate::client::fluent_builders::CreateLoadBalancerPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLoadBalancerPolicy {
    _private: (),
}
impl CreateLoadBalancerPolicy {
    /// Creates a new builder-style object to manufacture [`CreateLoadBalancerPolicyInput`](crate::input::CreateLoadBalancerPolicyInput)
    pub fn builder() -> crate::input::create_load_balancer_policy_input::Builder {
        crate::input::create_load_balancer_policy_input::Builder::default()
    }
    /// Creates a new `CreateLoadBalancerPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLoadBalancerPolicy {
    type Output = std::result::Result<
        crate::output::CreateLoadBalancerPolicyOutput,
        crate::error::CreateLoadBalancerPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_load_balancer_policy_error(response)
        } else {
            crate::operation_deser::parse_create_load_balancer_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_load_balancer`](crate::client::Client::delete_load_balancer).
///
/// See [`crate::client::fluent_builders::DeleteLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLoadBalancer {
    _private: (),
}
impl DeleteLoadBalancer {
    /// Creates a new builder-style object to manufacture [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
    pub fn builder() -> crate::input::delete_load_balancer_input::Builder {
        crate::input::delete_load_balancer_input::Builder::default()
    }
    /// Creates a new `DeleteLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLoadBalancer {
    type Output = std::result::Result<
        crate::output::DeleteLoadBalancerOutput,
        crate::error::DeleteLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_delete_load_balancer_response(response)
        }
    }
}

/// Operation shape for `DeleteLoadBalancerListeners`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_load_balancer_listeners`](crate::client::Client::delete_load_balancer_listeners).
///
/// See [`crate::client::fluent_builders::DeleteLoadBalancerListeners`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLoadBalancerListeners {
    _private: (),
}
impl DeleteLoadBalancerListeners {
    /// Creates a new builder-style object to manufacture [`DeleteLoadBalancerListenersInput`](crate::input::DeleteLoadBalancerListenersInput)
    pub fn builder() -> crate::input::delete_load_balancer_listeners_input::Builder {
        crate::input::delete_load_balancer_listeners_input::Builder::default()
    }
    /// Creates a new `DeleteLoadBalancerListeners` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLoadBalancerListeners {
    type Output = std::result::Result<
        crate::output::DeleteLoadBalancerListenersOutput,
        crate::error::DeleteLoadBalancerListenersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_load_balancer_listeners_error(response)
        } else {
            crate::operation_deser::parse_delete_load_balancer_listeners_response(response)
        }
    }
}

/// Operation shape for `DeleteLoadBalancerPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_load_balancer_policy`](crate::client::Client::delete_load_balancer_policy).
///
/// See [`crate::client::fluent_builders::DeleteLoadBalancerPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLoadBalancerPolicy {
    _private: (),
}
impl DeleteLoadBalancerPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteLoadBalancerPolicyInput`](crate::input::DeleteLoadBalancerPolicyInput)
    pub fn builder() -> crate::input::delete_load_balancer_policy_input::Builder {
        crate::input::delete_load_balancer_policy_input::Builder::default()
    }
    /// Creates a new `DeleteLoadBalancerPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLoadBalancerPolicy {
    type Output = std::result::Result<
        crate::output::DeleteLoadBalancerPolicyOutput,
        crate::error::DeleteLoadBalancerPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_load_balancer_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_load_balancer_policy_response(response)
        }
    }
}

/// Operation shape for `DeregisterInstancesFromLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_instances_from_load_balancer`](crate::client::Client::deregister_instances_from_load_balancer).
///
/// See [`crate::client::fluent_builders::DeregisterInstancesFromLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterInstancesFromLoadBalancer {
    _private: (),
}
impl DeregisterInstancesFromLoadBalancer {
    /// Creates a new builder-style object to manufacture [`DeregisterInstancesFromLoadBalancerInput`](crate::input::DeregisterInstancesFromLoadBalancerInput)
    pub fn builder() -> crate::input::deregister_instances_from_load_balancer_input::Builder {
        crate::input::deregister_instances_from_load_balancer_input::Builder::default()
    }
    /// Creates a new `DeregisterInstancesFromLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterInstancesFromLoadBalancer {
    type Output = std::result::Result<
        crate::output::DeregisterInstancesFromLoadBalancerOutput,
        crate::error::DeregisterInstancesFromLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_instances_from_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_deregister_instances_from_load_balancer_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountLimits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_limits`](crate::client::Client::describe_account_limits).
///
/// See [`crate::client::fluent_builders::DescribeAccountLimits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountLimits {
    _private: (),
}
impl DescribeAccountLimits {
    /// Creates a new builder-style object to manufacture [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    pub fn builder() -> crate::input::describe_account_limits_input::Builder {
        crate::input::describe_account_limits_input::Builder::default()
    }
    /// Creates a new `DescribeAccountLimits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountLimits {
    type Output = std::result::Result<
        crate::output::DescribeAccountLimitsOutput,
        crate::error::DescribeAccountLimitsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_limits_error(response)
        } else {
            crate::operation_deser::parse_describe_account_limits_response(response)
        }
    }
}

/// Operation shape for `DescribeInstanceHealth`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_health`](crate::client::Client::describe_instance_health).
///
/// See [`crate::client::fluent_builders::DescribeInstanceHealth`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceHealth {
    _private: (),
}
impl DescribeInstanceHealth {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceHealthInput`](crate::input::DescribeInstanceHealthInput)
    pub fn builder() -> crate::input::describe_instance_health_input::Builder {
        crate::input::describe_instance_health_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceHealth` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstanceHealth {
    type Output = std::result::Result<
        crate::output::DescribeInstanceHealthOutput,
        crate::error::DescribeInstanceHealthError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_health_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_health_response(response)
        }
    }
}

/// Operation shape for `DescribeLoadBalancerAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_load_balancer_attributes`](crate::client::Client::describe_load_balancer_attributes).
///
/// See [`crate::client::fluent_builders::DescribeLoadBalancerAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLoadBalancerAttributes {
    _private: (),
}
impl DescribeLoadBalancerAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancerAttributesInput`](crate::input::DescribeLoadBalancerAttributesInput)
    pub fn builder() -> crate::input::describe_load_balancer_attributes_input::Builder {
        crate::input::describe_load_balancer_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeLoadBalancerAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLoadBalancerAttributes {
    type Output = std::result::Result<
        crate::output::DescribeLoadBalancerAttributesOutput,
        crate::error::DescribeLoadBalancerAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_load_balancer_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_load_balancer_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeLoadBalancerPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_load_balancer_policies`](crate::client::Client::describe_load_balancer_policies).
///
/// See [`crate::client::fluent_builders::DescribeLoadBalancerPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLoadBalancerPolicies {
    _private: (),
}
impl DescribeLoadBalancerPolicies {
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancerPoliciesInput`](crate::input::DescribeLoadBalancerPoliciesInput)
    pub fn builder() -> crate::input::describe_load_balancer_policies_input::Builder {
        crate::input::describe_load_balancer_policies_input::Builder::default()
    }
    /// Creates a new `DescribeLoadBalancerPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLoadBalancerPolicies {
    type Output = std::result::Result<
        crate::output::DescribeLoadBalancerPoliciesOutput,
        crate::error::DescribeLoadBalancerPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_load_balancer_policies_error(response)
        } else {
            crate::operation_deser::parse_describe_load_balancer_policies_response(response)
        }
    }
}

/// Operation shape for `DescribeLoadBalancerPolicyTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_load_balancer_policy_types`](crate::client::Client::describe_load_balancer_policy_types).
///
/// See [`crate::client::fluent_builders::DescribeLoadBalancerPolicyTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLoadBalancerPolicyTypes {
    _private: (),
}
impl DescribeLoadBalancerPolicyTypes {
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancerPolicyTypesInput`](crate::input::DescribeLoadBalancerPolicyTypesInput)
    pub fn builder() -> crate::input::describe_load_balancer_policy_types_input::Builder {
        crate::input::describe_load_balancer_policy_types_input::Builder::default()
    }
    /// Creates a new `DescribeLoadBalancerPolicyTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLoadBalancerPolicyTypes {
    type Output = std::result::Result<
        crate::output::DescribeLoadBalancerPolicyTypesOutput,
        crate::error::DescribeLoadBalancerPolicyTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_load_balancer_policy_types_error(response)
        } else {
            crate::operation_deser::parse_describe_load_balancer_policy_types_response(response)
        }
    }
}

/// Operation shape for `DescribeLoadBalancers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_load_balancers`](crate::client::Client::describe_load_balancers).
///
/// See [`crate::client::fluent_builders::DescribeLoadBalancers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLoadBalancers {
    _private: (),
}
impl DescribeLoadBalancers {
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
    pub fn builder() -> crate::input::describe_load_balancers_input::Builder {
        crate::input::describe_load_balancers_input::Builder::default()
    }
    /// Creates a new `DescribeLoadBalancers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLoadBalancers {
    type Output = std::result::Result<
        crate::output::DescribeLoadBalancersOutput,
        crate::error::DescribeLoadBalancersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_load_balancers_error(response)
        } else {
            crate::operation_deser::parse_describe_load_balancers_response(response)
        }
    }
}

/// Operation shape for `DescribeTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_tags`](crate::client::Client::describe_tags).
///
/// See [`crate::client::fluent_builders::DescribeTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTags {
    _private: (),
}
impl DescribeTags {
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
    /// Creates a new `DescribeTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTags {
    type Output =
        std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_tags_error(response)
        } else {
            crate::operation_deser::parse_describe_tags_response(response)
        }
    }
}

/// Operation shape for `DetachLoadBalancerFromSubnets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_load_balancer_from_subnets`](crate::client::Client::detach_load_balancer_from_subnets).
///
/// See [`crate::client::fluent_builders::DetachLoadBalancerFromSubnets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachLoadBalancerFromSubnets {
    _private: (),
}
impl DetachLoadBalancerFromSubnets {
    /// Creates a new builder-style object to manufacture [`DetachLoadBalancerFromSubnetsInput`](crate::input::DetachLoadBalancerFromSubnetsInput)
    pub fn builder() -> crate::input::detach_load_balancer_from_subnets_input::Builder {
        crate::input::detach_load_balancer_from_subnets_input::Builder::default()
    }
    /// Creates a new `DetachLoadBalancerFromSubnets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachLoadBalancerFromSubnets {
    type Output = std::result::Result<
        crate::output::DetachLoadBalancerFromSubnetsOutput,
        crate::error::DetachLoadBalancerFromSubnetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_load_balancer_from_subnets_error(response)
        } else {
            crate::operation_deser::parse_detach_load_balancer_from_subnets_response(response)
        }
    }
}

/// Operation shape for `DisableAvailabilityZonesForLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_availability_zones_for_load_balancer`](crate::client::Client::disable_availability_zones_for_load_balancer).
///
/// See [`crate::client::fluent_builders::DisableAvailabilityZonesForLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableAvailabilityZonesForLoadBalancer {
    _private: (),
}
impl DisableAvailabilityZonesForLoadBalancer {
    /// Creates a new builder-style object to manufacture [`DisableAvailabilityZonesForLoadBalancerInput`](crate::input::DisableAvailabilityZonesForLoadBalancerInput)
    pub fn builder() -> crate::input::disable_availability_zones_for_load_balancer_input::Builder {
        crate::input::disable_availability_zones_for_load_balancer_input::Builder::default()
    }
    /// Creates a new `DisableAvailabilityZonesForLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableAvailabilityZonesForLoadBalancer {
    type Output = std::result::Result<
        crate::output::DisableAvailabilityZonesForLoadBalancerOutput,
        crate::error::DisableAvailabilityZonesForLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_availability_zones_for_load_balancer_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disable_availability_zones_for_load_balancer_response(
                response,
            )
        }
    }
}

/// Operation shape for `EnableAvailabilityZonesForLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_availability_zones_for_load_balancer`](crate::client::Client::enable_availability_zones_for_load_balancer).
///
/// See [`crate::client::fluent_builders::EnableAvailabilityZonesForLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableAvailabilityZonesForLoadBalancer {
    _private: (),
}
impl EnableAvailabilityZonesForLoadBalancer {
    /// Creates a new builder-style object to manufacture [`EnableAvailabilityZonesForLoadBalancerInput`](crate::input::EnableAvailabilityZonesForLoadBalancerInput)
    pub fn builder() -> crate::input::enable_availability_zones_for_load_balancer_input::Builder {
        crate::input::enable_availability_zones_for_load_balancer_input::Builder::default()
    }
    /// Creates a new `EnableAvailabilityZonesForLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableAvailabilityZonesForLoadBalancer {
    type Output = std::result::Result<
        crate::output::EnableAvailabilityZonesForLoadBalancerOutput,
        crate::error::EnableAvailabilityZonesForLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_availability_zones_for_load_balancer_error(
                response,
            )
        } else {
            crate::operation_deser::parse_enable_availability_zones_for_load_balancer_response(
                response,
            )
        }
    }
}

/// Operation shape for `ModifyLoadBalancerAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_load_balancer_attributes`](crate::client::Client::modify_load_balancer_attributes).
///
/// See [`crate::client::fluent_builders::ModifyLoadBalancerAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyLoadBalancerAttributes {
    _private: (),
}
impl ModifyLoadBalancerAttributes {
    /// Creates a new builder-style object to manufacture [`ModifyLoadBalancerAttributesInput`](crate::input::ModifyLoadBalancerAttributesInput)
    pub fn builder() -> crate::input::modify_load_balancer_attributes_input::Builder {
        crate::input::modify_load_balancer_attributes_input::Builder::default()
    }
    /// Creates a new `ModifyLoadBalancerAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyLoadBalancerAttributes {
    type Output = std::result::Result<
        crate::output::ModifyLoadBalancerAttributesOutput,
        crate::error::ModifyLoadBalancerAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_load_balancer_attributes_error(response)
        } else {
            crate::operation_deser::parse_modify_load_balancer_attributes_response(response)
        }
    }
}

/// Operation shape for `RegisterInstancesWithLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_instances_with_load_balancer`](crate::client::Client::register_instances_with_load_balancer).
///
/// See [`crate::client::fluent_builders::RegisterInstancesWithLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterInstancesWithLoadBalancer {
    _private: (),
}
impl RegisterInstancesWithLoadBalancer {
    /// Creates a new builder-style object to manufacture [`RegisterInstancesWithLoadBalancerInput`](crate::input::RegisterInstancesWithLoadBalancerInput)
    pub fn builder() -> crate::input::register_instances_with_load_balancer_input::Builder {
        crate::input::register_instances_with_load_balancer_input::Builder::default()
    }
    /// Creates a new `RegisterInstancesWithLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterInstancesWithLoadBalancer {
    type Output = std::result::Result<
        crate::output::RegisterInstancesWithLoadBalancerOutput,
        crate::error::RegisterInstancesWithLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_instances_with_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_register_instances_with_load_balancer_response(response)
        }
    }
}

/// Operation shape for `RemoveTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_tags`](crate::client::Client::remove_tags).
///
/// See [`crate::client::fluent_builders::RemoveTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTags {
    _private: (),
}
impl RemoveTags {
    /// Creates a new builder-style object to manufacture [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    pub fn builder() -> crate::input::remove_tags_input::Builder {
        crate::input::remove_tags_input::Builder::default()
    }
    /// Creates a new `RemoveTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTags {
    type Output =
        std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_tags_error(response)
        } else {
            crate::operation_deser::parse_remove_tags_response(response)
        }
    }
}

/// Operation shape for `SetLoadBalancerListenerSSLCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_load_balancer_listener_ssl_certificate`](crate::client::Client::set_load_balancer_listener_ssl_certificate).
///
/// See [`crate::client::fluent_builders::SetLoadBalancerListenerSSLCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetLoadBalancerListenerSSLCertificate {
    _private: (),
}
impl SetLoadBalancerListenerSSLCertificate {
    /// Creates a new builder-style object to manufacture [`SetLoadBalancerListenerSslCertificateInput`](crate::input::SetLoadBalancerListenerSslCertificateInput)
    pub fn builder() -> crate::input::set_load_balancer_listener_ssl_certificate_input::Builder {
        crate::input::set_load_balancer_listener_ssl_certificate_input::Builder::default()
    }
    /// Creates a new `SetLoadBalancerListenerSSLCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetLoadBalancerListenerSSLCertificate {
    type Output = std::result::Result<
        crate::output::SetLoadBalancerListenerSslCertificateOutput,
        crate::error::SetLoadBalancerListenerSSLCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_load_balancer_listener_ssl_certificate_error(response)
        } else {
            crate::operation_deser::parse_set_load_balancer_listener_ssl_certificate_response(
                response,
            )
        }
    }
}

/// Operation shape for `SetLoadBalancerPoliciesForBackendServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_load_balancer_policies_for_backend_server`](crate::client::Client::set_load_balancer_policies_for_backend_server).
///
/// See [`crate::client::fluent_builders::SetLoadBalancerPoliciesForBackendServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetLoadBalancerPoliciesForBackendServer {
    _private: (),
}
impl SetLoadBalancerPoliciesForBackendServer {
    /// Creates a new builder-style object to manufacture [`SetLoadBalancerPoliciesForBackendServerInput`](crate::input::SetLoadBalancerPoliciesForBackendServerInput)
    pub fn builder() -> crate::input::set_load_balancer_policies_for_backend_server_input::Builder {
        crate::input::set_load_balancer_policies_for_backend_server_input::Builder::default()
    }
    /// Creates a new `SetLoadBalancerPoliciesForBackendServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetLoadBalancerPoliciesForBackendServer {
    type Output = std::result::Result<
        crate::output::SetLoadBalancerPoliciesForBackendServerOutput,
        crate::error::SetLoadBalancerPoliciesForBackendServerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_load_balancer_policies_for_backend_server_error(
                response,
            )
        } else {
            crate::operation_deser::parse_set_load_balancer_policies_for_backend_server_response(
                response,
            )
        }
    }
}

/// Operation shape for `SetLoadBalancerPoliciesOfListener`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_load_balancer_policies_of_listener`](crate::client::Client::set_load_balancer_policies_of_listener).
///
/// See [`crate::client::fluent_builders::SetLoadBalancerPoliciesOfListener`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetLoadBalancerPoliciesOfListener {
    _private: (),
}
impl SetLoadBalancerPoliciesOfListener {
    /// Creates a new builder-style object to manufacture [`SetLoadBalancerPoliciesOfListenerInput`](crate::input::SetLoadBalancerPoliciesOfListenerInput)
    pub fn builder() -> crate::input::set_load_balancer_policies_of_listener_input::Builder {
        crate::input::set_load_balancer_policies_of_listener_input::Builder::default()
    }
    /// Creates a new `SetLoadBalancerPoliciesOfListener` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetLoadBalancerPoliciesOfListener {
    type Output = std::result::Result<
        crate::output::SetLoadBalancerPoliciesOfListenerOutput,
        crate::error::SetLoadBalancerPoliciesOfListenerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_load_balancer_policies_of_listener_error(response)
        } else {
            crate::operation_deser::parse_set_load_balancer_policies_of_listener_response(response)
        }
    }
}
