// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Elastic Load Balancing
///
/// Client for invoking operations on Elastic Load Balancing. Each operation on Elastic Load Balancing is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_elasticloadbalancing::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_elasticloadbalancing::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_elasticloadbalancing::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddTags` operation.
    ///
    /// See [`AddTags`](crate::client::fluent_builders::AddTags) for more information about the
    /// operation and its arguments.
    pub fn add_tags(&self) -> fluent_builders::AddTags<C, M, R> {
        fluent_builders::AddTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ApplySecurityGroupsToLoadBalancer` operation.
    ///
    /// See [`ApplySecurityGroupsToLoadBalancer`](crate::client::fluent_builders::ApplySecurityGroupsToLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn apply_security_groups_to_load_balancer(
        &self,
    ) -> fluent_builders::ApplySecurityGroupsToLoadBalancer<C, M, R> {
        fluent_builders::ApplySecurityGroupsToLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachLoadBalancerToSubnets` operation.
    ///
    /// See [`AttachLoadBalancerToSubnets`](crate::client::fluent_builders::AttachLoadBalancerToSubnets) for more information about the
    /// operation and its arguments.
    pub fn attach_load_balancer_to_subnets(
        &self,
    ) -> fluent_builders::AttachLoadBalancerToSubnets<C, M, R> {
        fluent_builders::AttachLoadBalancerToSubnets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ConfigureHealthCheck` operation.
    ///
    /// See [`ConfigureHealthCheck`](crate::client::fluent_builders::ConfigureHealthCheck) for more information about the
    /// operation and its arguments.
    pub fn configure_health_check(&self) -> fluent_builders::ConfigureHealthCheck<C, M, R> {
        fluent_builders::ConfigureHealthCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAppCookieStickinessPolicy` operation.
    ///
    /// See [`CreateAppCookieStickinessPolicy`](crate::client::fluent_builders::CreateAppCookieStickinessPolicy) for more information about the
    /// operation and its arguments.
    pub fn create_app_cookie_stickiness_policy(
        &self,
    ) -> fluent_builders::CreateAppCookieStickinessPolicy<C, M, R> {
        fluent_builders::CreateAppCookieStickinessPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLBCookieStickinessPolicy` operation.
    ///
    /// See [`CreateLBCookieStickinessPolicy`](crate::client::fluent_builders::CreateLBCookieStickinessPolicy) for more information about the
    /// operation and its arguments.
    pub fn create_lb_cookie_stickiness_policy(
        &self,
    ) -> fluent_builders::CreateLBCookieStickinessPolicy<C, M, R> {
        fluent_builders::CreateLBCookieStickinessPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLoadBalancer` operation.
    ///
    /// See [`CreateLoadBalancer`](crate::client::fluent_builders::CreateLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn create_load_balancer(&self) -> fluent_builders::CreateLoadBalancer<C, M, R> {
        fluent_builders::CreateLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLoadBalancerListeners` operation.
    ///
    /// See [`CreateLoadBalancerListeners`](crate::client::fluent_builders::CreateLoadBalancerListeners) for more information about the
    /// operation and its arguments.
    pub fn create_load_balancer_listeners(
        &self,
    ) -> fluent_builders::CreateLoadBalancerListeners<C, M, R> {
        fluent_builders::CreateLoadBalancerListeners::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLoadBalancerPolicy` operation.
    ///
    /// See [`CreateLoadBalancerPolicy`](crate::client::fluent_builders::CreateLoadBalancerPolicy) for more information about the
    /// operation and its arguments.
    pub fn create_load_balancer_policy(
        &self,
    ) -> fluent_builders::CreateLoadBalancerPolicy<C, M, R> {
        fluent_builders::CreateLoadBalancerPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLoadBalancer` operation.
    ///
    /// See [`DeleteLoadBalancer`](crate::client::fluent_builders::DeleteLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn delete_load_balancer(&self) -> fluent_builders::DeleteLoadBalancer<C, M, R> {
        fluent_builders::DeleteLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLoadBalancerListeners` operation.
    ///
    /// See [`DeleteLoadBalancerListeners`](crate::client::fluent_builders::DeleteLoadBalancerListeners) for more information about the
    /// operation and its arguments.
    pub fn delete_load_balancer_listeners(
        &self,
    ) -> fluent_builders::DeleteLoadBalancerListeners<C, M, R> {
        fluent_builders::DeleteLoadBalancerListeners::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLoadBalancerPolicy` operation.
    ///
    /// See [`DeleteLoadBalancerPolicy`](crate::client::fluent_builders::DeleteLoadBalancerPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_load_balancer_policy(
        &self,
    ) -> fluent_builders::DeleteLoadBalancerPolicy<C, M, R> {
        fluent_builders::DeleteLoadBalancerPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterInstancesFromLoadBalancer` operation.
    ///
    /// See [`DeregisterInstancesFromLoadBalancer`](crate::client::fluent_builders::DeregisterInstancesFromLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn deregister_instances_from_load_balancer(
        &self,
    ) -> fluent_builders::DeregisterInstancesFromLoadBalancer<C, M, R> {
        fluent_builders::DeregisterInstancesFromLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountLimits` operation.
    ///
    /// See [`DescribeAccountLimits`](crate::client::fluent_builders::DescribeAccountLimits) for more information about the
    /// operation and its arguments.
    pub fn describe_account_limits(&self) -> fluent_builders::DescribeAccountLimits<C, M, R> {
        fluent_builders::DescribeAccountLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceHealth` operation.
    ///
    /// See [`DescribeInstanceHealth`](crate::client::fluent_builders::DescribeInstanceHealth) for more information about the
    /// operation and its arguments.
    pub fn describe_instance_health(&self) -> fluent_builders::DescribeInstanceHealth<C, M, R> {
        fluent_builders::DescribeInstanceHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLoadBalancerAttributes` operation.
    ///
    /// See [`DescribeLoadBalancerAttributes`](crate::client::fluent_builders::DescribeLoadBalancerAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_load_balancer_attributes(
        &self,
    ) -> fluent_builders::DescribeLoadBalancerAttributes<C, M, R> {
        fluent_builders::DescribeLoadBalancerAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLoadBalancerPolicies` operation.
    ///
    /// See [`DescribeLoadBalancerPolicies`](crate::client::fluent_builders::DescribeLoadBalancerPolicies) for more information about the
    /// operation and its arguments.
    pub fn describe_load_balancer_policies(
        &self,
    ) -> fluent_builders::DescribeLoadBalancerPolicies<C, M, R> {
        fluent_builders::DescribeLoadBalancerPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLoadBalancerPolicyTypes` operation.
    ///
    /// See [`DescribeLoadBalancerPolicyTypes`](crate::client::fluent_builders::DescribeLoadBalancerPolicyTypes) for more information about the
    /// operation and its arguments.
    pub fn describe_load_balancer_policy_types(
        &self,
    ) -> fluent_builders::DescribeLoadBalancerPolicyTypes<C, M, R> {
        fluent_builders::DescribeLoadBalancerPolicyTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLoadBalancers` operation.
    ///
    /// See [`DescribeLoadBalancers`](crate::client::fluent_builders::DescribeLoadBalancers) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeLoadBalancers::into_paginator).
    pub fn describe_load_balancers(&self) -> fluent_builders::DescribeLoadBalancers<C, M, R> {
        fluent_builders::DescribeLoadBalancers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTags` operation.
    ///
    /// See [`DescribeTags`](crate::client::fluent_builders::DescribeTags) for more information about the
    /// operation and its arguments.
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags<C, M, R> {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachLoadBalancerFromSubnets` operation.
    ///
    /// See [`DetachLoadBalancerFromSubnets`](crate::client::fluent_builders::DetachLoadBalancerFromSubnets) for more information about the
    /// operation and its arguments.
    pub fn detach_load_balancer_from_subnets(
        &self,
    ) -> fluent_builders::DetachLoadBalancerFromSubnets<C, M, R> {
        fluent_builders::DetachLoadBalancerFromSubnets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableAvailabilityZonesForLoadBalancer` operation.
    ///
    /// See [`DisableAvailabilityZonesForLoadBalancer`](crate::client::fluent_builders::DisableAvailabilityZonesForLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn disable_availability_zones_for_load_balancer(
        &self,
    ) -> fluent_builders::DisableAvailabilityZonesForLoadBalancer<C, M, R> {
        fluent_builders::DisableAvailabilityZonesForLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableAvailabilityZonesForLoadBalancer` operation.
    ///
    /// See [`EnableAvailabilityZonesForLoadBalancer`](crate::client::fluent_builders::EnableAvailabilityZonesForLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn enable_availability_zones_for_load_balancer(
        &self,
    ) -> fluent_builders::EnableAvailabilityZonesForLoadBalancer<C, M, R> {
        fluent_builders::EnableAvailabilityZonesForLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyLoadBalancerAttributes` operation.
    ///
    /// See [`ModifyLoadBalancerAttributes`](crate::client::fluent_builders::ModifyLoadBalancerAttributes) for more information about the
    /// operation and its arguments.
    pub fn modify_load_balancer_attributes(
        &self,
    ) -> fluent_builders::ModifyLoadBalancerAttributes<C, M, R> {
        fluent_builders::ModifyLoadBalancerAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterInstancesWithLoadBalancer` operation.
    ///
    /// See [`RegisterInstancesWithLoadBalancer`](crate::client::fluent_builders::RegisterInstancesWithLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn register_instances_with_load_balancer(
        &self,
    ) -> fluent_builders::RegisterInstancesWithLoadBalancer<C, M, R> {
        fluent_builders::RegisterInstancesWithLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTags` operation.
    ///
    /// See [`RemoveTags`](crate::client::fluent_builders::RemoveTags) for more information about the
    /// operation and its arguments.
    pub fn remove_tags(&self) -> fluent_builders::RemoveTags<C, M, R> {
        fluent_builders::RemoveTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetLoadBalancerListenerSSLCertificate` operation.
    ///
    /// See [`SetLoadBalancerListenerSSLCertificate`](crate::client::fluent_builders::SetLoadBalancerListenerSSLCertificate) for more information about the
    /// operation and its arguments.
    pub fn set_load_balancer_listener_ssl_certificate(
        &self,
    ) -> fluent_builders::SetLoadBalancerListenerSSLCertificate<C, M, R> {
        fluent_builders::SetLoadBalancerListenerSSLCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetLoadBalancerPoliciesForBackendServer` operation.
    ///
    /// See [`SetLoadBalancerPoliciesForBackendServer`](crate::client::fluent_builders::SetLoadBalancerPoliciesForBackendServer) for more information about the
    /// operation and its arguments.
    pub fn set_load_balancer_policies_for_backend_server(
        &self,
    ) -> fluent_builders::SetLoadBalancerPoliciesForBackendServer<C, M, R> {
        fluent_builders::SetLoadBalancerPoliciesForBackendServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetLoadBalancerPoliciesOfListener` operation.
    ///
    /// See [`SetLoadBalancerPoliciesOfListener`](crate::client::fluent_builders::SetLoadBalancerPoliciesOfListener) for more information about the
    /// operation and its arguments.
    pub fn set_load_balancer_policies_of_listener(
        &self,
    ) -> fluent_builders::SetLoadBalancerPoliciesOfListener<C, M, R> {
        fluent_builders::SetLoadBalancerPoliciesOfListener::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddTags`.
    ///
    /// <p>Adds the specified tags to the specified load balancer. Each load balancer can have a maximum of 10 tags.</p>
    /// <p>Each tag consists of a key and an optional value. If a tag with the same key is already associated with the load balancer, <code>AddTags</code> updates its value.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_input::Builder,
    }
    impl<C, M, R> AddTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsInputOperationOutputAlias,
                crate::output::AddTagsOutput,
                crate::error::AddTagsError,
                crate::input::AddTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `LoadBalancerNames`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_names`](Self::set_load_balancer_names).
        ///
        /// <p>The name of the load balancer. You can specify one load balancer only.</p>
        pub fn load_balancer_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_names(input.into());
            self
        }
        /// <p>The name of the load balancer. You can specify one load balancer only.</p>
        pub fn set_load_balancer_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_names(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApplySecurityGroupsToLoadBalancer`.
    ///
    /// <p>Associates one or more security groups with your load balancer in a virtual private cloud (VPC). The specified security groups override the previously associated security groups.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-security-groups.html#elb-vpc-security-groups">Security Groups for Load Balancers in a VPC</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ApplySecurityGroupsToLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::apply_security_groups_to_load_balancer_input::Builder,
    }
    impl<C, M, R> ApplySecurityGroupsToLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ApplySecurityGroupsToLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplySecurityGroupsToLoadBalancerOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplySecurityGroupsToLoadBalancerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ApplySecurityGroupsToLoadBalancerInputOperationOutputAlias,
                crate::output::ApplySecurityGroupsToLoadBalancerOutput,
                crate::error::ApplySecurityGroupsToLoadBalancerError,
                crate::input::ApplySecurityGroupsToLoadBalancerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The IDs of the security groups to associate with the load balancer. Note that you cannot specify the name of the security group.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(input.into());
            self
        }
        /// <p>The IDs of the security groups to associate with the load balancer. Note that you cannot specify the name of the security group.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachLoadBalancerToSubnets`.
    ///
    /// <p>Adds one or more subnets to the set of configured subnets for the specified load balancer.</p>
    /// <p>The load balancer evenly distributes requests across all registered subnets. For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-manage-subnets.html">Add or Remove Subnets for Your Load Balancer in a VPC</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachLoadBalancerToSubnets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_load_balancer_to_subnets_input::Builder,
    }
    impl<C, M, R> AttachLoadBalancerToSubnets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachLoadBalancerToSubnets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachLoadBalancerToSubnetsOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachLoadBalancerToSubnetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachLoadBalancerToSubnetsInputOperationOutputAlias,
                crate::output::AttachLoadBalancerToSubnetsOutput,
                crate::error::AttachLoadBalancerToSubnetsError,
                crate::input::AttachLoadBalancerToSubnetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `Subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the subnets to add. You can add only one subnet per Availability Zone.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnets(input.into());
            self
        }
        /// <p>The IDs of the subnets to add. You can add only one subnet per Availability Zone.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfigureHealthCheck`.
    ///
    /// <p>Specifies the health check settings to use when evaluating the health state of your EC2 instances.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-healthchecks.html">Configure Health Checks for Your Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfigureHealthCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::configure_health_check_input::Builder,
    }
    impl<C, M, R> ConfigureHealthCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfigureHealthCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfigureHealthCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfigureHealthCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfigureHealthCheckInputOperationOutputAlias,
                crate::output::ConfigureHealthCheckOutput,
                crate::error::ConfigureHealthCheckError,
                crate::input::ConfigureHealthCheckInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The configuration information.</p>
        pub fn health_check(mut self, input: crate::model::HealthCheck) -> Self {
            self.inner = self.inner.health_check(input);
            self
        }
        /// <p>The configuration information.</p>
        pub fn set_health_check(
            mut self,
            input: std::option::Option<crate::model::HealthCheck>,
        ) -> Self {
            self.inner = self.inner.set_health_check(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAppCookieStickinessPolicy`.
    ///
    /// <p>Generates a stickiness policy with sticky session lifetimes that follow that of an application-generated cookie. This policy can be associated only with HTTP/HTTPS listeners.</p>
    /// <p>This policy is similar to the policy created by <code>CreateLBCookieStickinessPolicy</code>, except that the lifetime of the special Elastic Load Balancing cookie, <code>AWSELB</code>, follows the lifetime of the application-generated cookie specified in the policy configuration. The load balancer only inserts a new stickiness cookie when the application response includes a new application cookie.</p>
    /// <p>If the application cookie is explicitly removed or expires, the session stops being sticky until a new application cookie is issued.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application">Application-Controlled Session Stickiness</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAppCookieStickinessPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_cookie_stickiness_policy_input::Builder,
    }
    impl<C, M, R> CreateAppCookieStickinessPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAppCookieStickinessPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppCookieStickinessPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppCookieStickinessPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppCookieStickinessPolicyInputOperationOutputAlias,
                crate::output::CreateAppCookieStickinessPolicyOutput,
                crate::error::CreateAppCookieStickinessPolicyError,
                crate::input::CreateAppCookieStickinessPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The name of the application cookie used for stickiness.</p>
        pub fn cookie_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cookie_name(input.into());
            self
        }
        /// <p>The name of the application cookie used for stickiness.</p>
        pub fn set_cookie_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cookie_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLBCookieStickinessPolicy`.
    ///
    /// <p>Generates a stickiness policy with sticky session lifetimes controlled by the lifetime of the browser (user-agent) or a specified expiration period. This policy can be associated only with HTTP/HTTPS listeners.</p>
    /// <p>When a load balancer implements this policy, the load balancer uses a special cookie to track the instance for each request. When the load balancer receives a request, it first checks to see if this cookie is present in the request. If so, the load balancer sends the request to the application server specified in the cookie. If not, the load balancer sends the request to a server that is chosen based on the existing load-balancing algorithm.</p>
    /// <p>A cookie is inserted into the response for binding subsequent requests from the same user to that server. The validity of the cookie is based on the cookie expiration time, which is specified in the policy configuration.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration">Duration-Based Session Stickiness</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLBCookieStickinessPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_lb_cookie_stickiness_policy_input::Builder,
    }
    impl<C, M, R> CreateLBCookieStickinessPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLBCookieStickinessPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLbCookieStickinessPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLBCookieStickinessPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLbCookieStickinessPolicyInputOperationOutputAlias,
                crate::output::CreateLbCookieStickinessPolicyOutput,
                crate::error::CreateLBCookieStickinessPolicyError,
                crate::input::CreateLbCookieStickinessPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The time period, in seconds, after which the cookie should be considered stale. If you do not specify this parameter, the default value is 0, which indicates that the sticky session should last for the duration of the browser session.</p>
        pub fn cookie_expiration_period(mut self, input: i64) -> Self {
            self.inner = self.inner.cookie_expiration_period(input);
            self
        }
        /// <p>The time period, in seconds, after which the cookie should be considered stale. If you do not specify this parameter, the default value is 0, which indicates that the sticky session should last for the duration of the browser session.</p>
        pub fn set_cookie_expiration_period(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_cookie_expiration_period(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLoadBalancer`.
    ///
    /// <p>Creates a Classic Load Balancer.</p>
    /// <p>You can add listeners, security groups, subnets, and tags when you create your load balancer, or you can add them later using <code>CreateLoadBalancerListeners</code>, <code>ApplySecurityGroupsToLoadBalancer</code>, <code>AttachLoadBalancerToSubnets</code>, and <code>AddTags</code>.</p>
    /// <p>To describe your current load balancers, see <code>DescribeLoadBalancers</code>. When you are finished with a load balancer, you can delete it using <code>DeleteLoadBalancer</code>.</p>
    /// <p>You can create up to 20 load balancers per region per account. You can request an increase for the number of load balancers for your account. For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html">Limits for Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_load_balancer_input::Builder,
    }
    impl<C, M, R> CreateLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLoadBalancerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLoadBalancerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLoadBalancerInputOperationOutputAlias,
                crate::output::CreateLoadBalancerOutput,
                crate::error::CreateLoadBalancerError,
                crate::input::CreateLoadBalancerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        /// <p>This name must be unique within your set of load balancers for the region, must have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        /// <p>This name must be unique within your set of load balancers for the region, must have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `Listeners`.
        ///
        /// To override the contents of this collection use [`set_listeners`](Self::set_listeners).
        ///
        /// <p>The listeners.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn listeners(mut self, input: crate::model::Listener) -> Self {
            self.inner = self.inner.listeners(input);
            self
        }
        /// <p>The listeners.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn set_listeners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Listener>>,
        ) -> Self {
            self.inner = self.inner.set_listeners(input);
            self
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>One or more Availability Zones from the same region as the load balancer.</p>
        /// <p>You must specify at least one Availability Zone.</p>
        /// <p>You can add more Availability Zones after you create the load balancer using <code>EnableAvailabilityZonesForLoadBalancer</code>.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(input.into());
            self
        }
        /// <p>One or more Availability Zones from the same region as the load balancer.</p>
        /// <p>You must specify at least one Availability Zone.</p>
        /// <p>You can add more Availability Zones after you create the load balancer using <code>EnableAvailabilityZonesForLoadBalancer</code>.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
        /// Appends an item to `Subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the subnets in your VPC to attach to the load balancer. Specify one subnet per Availability Zone specified in <code>AvailabilityZones</code>.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnets(input.into());
            self
        }
        /// <p>The IDs of the subnets in your VPC to attach to the load balancer. Specify one subnet per Availability Zone specified in <code>AvailabilityZones</code>.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnets(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The IDs of the security groups to assign to the load balancer.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(input.into());
            self
        }
        /// <p>The IDs of the security groups to assign to the load balancer.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
        /// <p>The type of a load balancer. Valid only for load balancers in a VPC.</p>
        /// <p>By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that resolves to public IP addresses. For more information about Internet-facing and Internal load balancers, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme">Load Balancer Scheme</a> in the <i>Elastic Load Balancing User Guide</i>.</p>
        /// <p>Specify <code>internal</code> to create a load balancer with a DNS name that resolves to private IP addresses.</p>
        pub fn scheme(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheme(input.into());
            self
        }
        /// <p>The type of a load balancer. Valid only for load balancers in a VPC.</p>
        /// <p>By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that resolves to public IP addresses. For more information about Internet-facing and Internal load balancers, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme">Load Balancer Scheme</a> in the <i>Elastic Load Balancing User Guide</i>.</p>
        /// <p>Specify <code>internal</code> to create a load balancer with a DNS name that resolves to private IP addresses.</p>
        pub fn set_scheme(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_scheme(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to assign to the load balancer.</p>
        /// <p>For more information about tagging your load balancer, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to assign to the load balancer.</p>
        /// <p>For more information about tagging your load balancer, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLoadBalancerListeners`.
    ///
    /// <p>Creates one or more listeners for the specified load balancer. If a listener with the specified port does not already exist, it is created; otherwise, the properties of the new listener must match the properties of the existing listener.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLoadBalancerListeners<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_load_balancer_listeners_input::Builder,
    }
    impl<C, M, R> CreateLoadBalancerListeners<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLoadBalancerListeners`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLoadBalancerListenersOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLoadBalancerListenersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLoadBalancerListenersInputOperationOutputAlias,
                crate::output::CreateLoadBalancerListenersOutput,
                crate::error::CreateLoadBalancerListenersError,
                crate::input::CreateLoadBalancerListenersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `Listeners`.
        ///
        /// To override the contents of this collection use [`set_listeners`](Self::set_listeners).
        ///
        /// <p>The listeners.</p>
        pub fn listeners(mut self, input: crate::model::Listener) -> Self {
            self.inner = self.inner.listeners(input);
            self
        }
        /// <p>The listeners.</p>
        pub fn set_listeners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Listener>>,
        ) -> Self {
            self.inner = self.inner.set_listeners(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLoadBalancerPolicy`.
    ///
    /// <p>Creates a policy with the specified attributes for the specified load balancer.</p>
    /// <p>Policies are settings that are saved for your load balancer and that can be applied to the listener or the application server, depending on the policy type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLoadBalancerPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_load_balancer_policy_input::Builder,
    }
    impl<C, M, R> CreateLoadBalancerPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLoadBalancerPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLoadBalancerPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLoadBalancerPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLoadBalancerPolicyInputOperationOutputAlias,
                crate::output::CreateLoadBalancerPolicyOutput,
                crate::error::CreateLoadBalancerPolicyError,
                crate::input::CreateLoadBalancerPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The name of the load balancer policy to be created. This name must be unique within the set of policies for this load balancer.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the load balancer policy to be created. This name must be unique within the set of policies for this load balancer.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The name of the base policy type. To get the list of policy types, use <code>DescribeLoadBalancerPolicyTypes</code>.</p>
        pub fn policy_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_type_name(input.into());
            self
        }
        /// <p>The name of the base policy type. To get the list of policy types, use <code>DescribeLoadBalancerPolicyTypes</code>.</p>
        pub fn set_policy_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_type_name(input);
            self
        }
        /// Appends an item to `PolicyAttributes`.
        ///
        /// To override the contents of this collection use [`set_policy_attributes`](Self::set_policy_attributes).
        ///
        /// <p>The policy attributes.</p>
        pub fn policy_attributes(mut self, input: crate::model::PolicyAttribute) -> Self {
            self.inner = self.inner.policy_attributes(input);
            self
        }
        /// <p>The policy attributes.</p>
        pub fn set_policy_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_policy_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLoadBalancer`.
    ///
    /// <p>Deletes the specified load balancer.</p>
    /// <p>If you are attempting to recreate a load balancer, you must reconfigure all settings. The DNS name associated with a deleted load balancer are no longer usable. The name and associated DNS record of the deleted load balancer no longer exist and traffic sent to any of its IP addresses is no longer delivered to your instances.</p>
    /// <p>If the load balancer does not exist or has already been deleted, the call to <code>DeleteLoadBalancer</code> still succeeds.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_load_balancer_input::Builder,
    }
    impl<C, M, R> DeleteLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLoadBalancerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLoadBalancerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLoadBalancerInputOperationOutputAlias,
                crate::output::DeleteLoadBalancerOutput,
                crate::error::DeleteLoadBalancerError,
                crate::input::DeleteLoadBalancerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLoadBalancerListeners`.
    ///
    /// <p>Deletes the specified listeners from the specified load balancer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLoadBalancerListeners<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_load_balancer_listeners_input::Builder,
    }
    impl<C, M, R> DeleteLoadBalancerListeners<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLoadBalancerListeners`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLoadBalancerListenersOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLoadBalancerListenersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLoadBalancerListenersInputOperationOutputAlias,
                crate::output::DeleteLoadBalancerListenersOutput,
                crate::error::DeleteLoadBalancerListenersError,
                crate::input::DeleteLoadBalancerListenersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `LoadBalancerPorts`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_ports`](Self::set_load_balancer_ports).
        ///
        /// <p>The client port numbers of the listeners.</p>
        pub fn load_balancer_ports(mut self, input: i32) -> Self {
            self.inner = self.inner.load_balancer_ports(input);
            self
        }
        /// <p>The client port numbers of the listeners.</p>
        pub fn set_load_balancer_ports(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_ports(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLoadBalancerPolicy`.
    ///
    /// <p>Deletes the specified policy from the specified load balancer. This policy must not be enabled for any listeners.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLoadBalancerPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_load_balancer_policy_input::Builder,
    }
    impl<C, M, R> DeleteLoadBalancerPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLoadBalancerPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLoadBalancerPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLoadBalancerPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLoadBalancerPolicyInputOperationOutputAlias,
                crate::output::DeleteLoadBalancerPolicyOutput,
                crate::error::DeleteLoadBalancerPolicyError,
                crate::input::DeleteLoadBalancerPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterInstancesFromLoadBalancer`.
    ///
    /// <p>Deregisters the specified instances from the specified load balancer. After the instance is deregistered, it no longer receives traffic from the load balancer.</p>
    /// <p>You can use <code>DescribeLoadBalancers</code> to verify that the instance is deregistered from the load balancer.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html">Register or De-Register EC2 Instances</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterInstancesFromLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_instances_from_load_balancer_input::Builder,
    }
    impl<C, M, R> DeregisterInstancesFromLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterInstancesFromLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterInstancesFromLoadBalancerOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeregisterInstancesFromLoadBalancerError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterInstancesFromLoadBalancerInputOperationOutputAlias,
                crate::output::DeregisterInstancesFromLoadBalancerOutput,
                crate::error::DeregisterInstancesFromLoadBalancerError,
                crate::input::DeregisterInstancesFromLoadBalancerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `Instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>The IDs of the instances.</p>
        pub fn instances(mut self, input: crate::model::Instance) -> Self {
            self.inner = self.inner.instances(input);
            self
        }
        /// <p>The IDs of the instances.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        ) -> Self {
            self.inner = self.inner.set_instances(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountLimits`.
    ///
    /// <p>Describes the current Elastic Load Balancing resource limits for your AWS account.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html">Limits for Your Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountLimits<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_limits_input::Builder,
    }
    impl<C, M, R> DescribeAccountLimits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountLimitsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountLimitsInputOperationOutputAlias,
                crate::output::DescribeAccountLimitsOutput,
                crate::error::DescribeAccountLimitsError,
                crate::input::DescribeAccountLimitsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstanceHealth`.
    ///
    /// <p>Describes the state of the specified instances with respect to the specified load balancer. If no instances are specified, the call describes the state of all instances that are currently registered with the load balancer. If instances are specified, their state is returned even if they are no longer registered with the load balancer. The state of terminated instances is not returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInstanceHealth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instance_health_input::Builder,
    }
    impl<C, M, R> DescribeInstanceHealth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstanceHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceHealthOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstanceHealthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstanceHealthInputOperationOutputAlias,
                crate::output::DescribeInstanceHealthOutput,
                crate::error::DescribeInstanceHealthError,
                crate::input::DescribeInstanceHealthInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `Instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>The IDs of the instances.</p>
        pub fn instances(mut self, input: crate::model::Instance) -> Self {
            self.inner = self.inner.instances(input);
            self
        }
        /// <p>The IDs of the instances.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        ) -> Self {
            self.inner = self.inner.set_instances(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoadBalancerAttributes`.
    ///
    /// <p>Describes the attributes for the specified load balancer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoadBalancerAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_load_balancer_attributes_input::Builder,
    }
    impl<C, M, R> DescribeLoadBalancerAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLoadBalancerAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoadBalancerAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancerAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLoadBalancerAttributesInputOperationOutputAlias,
                crate::output::DescribeLoadBalancerAttributesOutput,
                crate::error::DescribeLoadBalancerAttributesError,
                crate::input::DescribeLoadBalancerAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoadBalancerPolicies`.
    ///
    /// <p>Describes the specified policies.</p>
    /// <p>If you specify a load balancer name, the action returns the descriptions of all policies created for the load balancer. If you specify a policy name associated with your load balancer, the action returns the description of that policy. If you don't specify a load balancer name, the action returns descriptions of the specified sample policies, or descriptions of all sample policies. The names of the sample policies have the <code>ELBSample-</code> prefix.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoadBalancerPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_load_balancer_policies_input::Builder,
    }
    impl<C, M, R> DescribeLoadBalancerPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLoadBalancerPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoadBalancerPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancerPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLoadBalancerPoliciesInputOperationOutputAlias,
                crate::output::DescribeLoadBalancerPoliciesOutput,
                crate::error::DescribeLoadBalancerPoliciesError,
                crate::input::DescribeLoadBalancerPoliciesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `PolicyNames`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>The names of the policies.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_names(input.into());
            self
        }
        /// <p>The names of the policies.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_policy_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoadBalancerPolicyTypes`.
    ///
    /// <p>Describes the specified load balancer policy types or all load balancer policy types.</p>
    /// <p>The description of each type indicates how it can be used. For example, some policies can be used only with layer 7 listeners, some policies can be used only with layer 4 listeners, and some policies can be used only with your EC2 instances.</p>
    /// <p>You can use <code>CreateLoadBalancerPolicy</code> to create a policy configuration for any of these policy types. Then, depending on the policy type, use either <code>SetLoadBalancerPoliciesOfListener</code> or <code>SetLoadBalancerPoliciesForBackendServer</code> to set the policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoadBalancerPolicyTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_load_balancer_policy_types_input::Builder,
    }
    impl<C, M, R> DescribeLoadBalancerPolicyTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLoadBalancerPolicyTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoadBalancerPolicyTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancerPolicyTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLoadBalancerPolicyTypesInputOperationOutputAlias,
                crate::output::DescribeLoadBalancerPolicyTypesOutput,
                crate::error::DescribeLoadBalancerPolicyTypesError,
                crate::input::DescribeLoadBalancerPolicyTypesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `PolicyTypeNames`.
        ///
        /// To override the contents of this collection use [`set_policy_type_names`](Self::set_policy_type_names).
        ///
        /// <p>The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load Balancing.</p>
        pub fn policy_type_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_type_names(input.into());
            self
        }
        /// <p>The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load Balancing.</p>
        pub fn set_policy_type_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_policy_type_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoadBalancers`.
    ///
    /// <p>Describes the specified the load balancers. If no load balancers are specified, the call describes all of your load balancers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoadBalancers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_load_balancers_input::Builder,
    }
    impl<C, M, R> DescribeLoadBalancers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLoadBalancers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoadBalancersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLoadBalancersInputOperationOutputAlias,
                crate::output::DescribeLoadBalancersOutput,
                crate::error::DescribeLoadBalancersError,
                crate::input::DescribeLoadBalancersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeLoadBalancersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeLoadBalancersPaginator<C, M, R> {
            crate::paginator::DescribeLoadBalancersPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `LoadBalancerNames`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_names`](Self::set_load_balancer_names).
        ///
        /// <p>The names of the load balancers.</p>
        pub fn load_balancer_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_names(input.into());
            self
        }
        /// <p>The names of the load balancers.</p>
        pub fn set_load_balancer_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_names(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return with this call (a number from 1 to 400). The default is 400.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return with this call (a number from 1 to 400). The default is 400.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <p>Describes the tags associated with the specified load balancers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl<C, M, R> DescribeTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTagsInputOperationOutputAlias,
                crate::output::DescribeTagsOutput,
                crate::error::DescribeTagsError,
                crate::input::DescribeTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `LoadBalancerNames`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_names`](Self::set_load_balancer_names).
        ///
        /// <p>The names of the load balancers.</p>
        pub fn load_balancer_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_names(input.into());
            self
        }
        /// <p>The names of the load balancers.</p>
        pub fn set_load_balancer_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachLoadBalancerFromSubnets`.
    ///
    /// <p>Removes the specified subnets from the set of configured subnets for the load balancer.</p>
    /// <p>After a subnet is removed, all EC2 instances registered with the load balancer in the removed subnet go into the <code>OutOfService</code> state. Then, the load balancer balances the traffic among the remaining routable subnets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachLoadBalancerFromSubnets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_load_balancer_from_subnets_input::Builder,
    }
    impl<C, M, R> DetachLoadBalancerFromSubnets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachLoadBalancerFromSubnets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachLoadBalancerFromSubnetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachLoadBalancerFromSubnetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachLoadBalancerFromSubnetsInputOperationOutputAlias,
                crate::output::DetachLoadBalancerFromSubnetsOutput,
                crate::error::DetachLoadBalancerFromSubnetsError,
                crate::input::DetachLoadBalancerFromSubnetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `Subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the subnets.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnets(input.into());
            self
        }
        /// <p>The IDs of the subnets.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableAvailabilityZonesForLoadBalancer`.
    ///
    /// <p>Removes the specified Availability Zones from the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC.</p>
    /// <p>For load balancers in a non-default VPC, use <code>DetachLoadBalancerFromSubnets</code>.</p>
    /// <p>There must be at least one Availability Zone registered with a load balancer at all times. After an Availability Zone is removed, all instances registered with the load balancer that are in the removed Availability Zone go into the <code>OutOfService</code> state. Then, the load balancer attempts to equally balance the traffic among its remaining Availability Zones.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html">Add or Remove Availability Zones</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableAvailabilityZonesForLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_availability_zones_for_load_balancer_input::Builder,
    }
    impl<C, M, R> DisableAvailabilityZonesForLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableAvailabilityZonesForLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableAvailabilityZonesForLoadBalancerOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisableAvailabilityZonesForLoadBalancerError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableAvailabilityZonesForLoadBalancerInputOperationOutputAlias,
                crate::output::DisableAvailabilityZonesForLoadBalancerOutput,
                crate::error::DisableAvailabilityZonesForLoadBalancerError,
                crate::input::DisableAvailabilityZonesForLoadBalancerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zones.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(input.into());
            self
        }
        /// <p>The Availability Zones.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableAvailabilityZonesForLoadBalancer`.
    ///
    /// <p>Adds the specified Availability Zones to the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC.</p>
    /// <p>For load balancers in a non-default VPC, use <code>AttachLoadBalancerToSubnets</code>.</p>
    /// <p>The load balancer evenly distributes requests across all its registered Availability Zones that contain instances. For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html">Add or Remove Availability Zones</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableAvailabilityZonesForLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_availability_zones_for_load_balancer_input::Builder,
    }
    impl<C, M, R> EnableAvailabilityZonesForLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableAvailabilityZonesForLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableAvailabilityZonesForLoadBalancerOutput,
            aws_smithy_http::result::SdkError<
                crate::error::EnableAvailabilityZonesForLoadBalancerError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableAvailabilityZonesForLoadBalancerInputOperationOutputAlias,
                crate::output::EnableAvailabilityZonesForLoadBalancerOutput,
                crate::error::EnableAvailabilityZonesForLoadBalancerError,
                crate::input::EnableAvailabilityZonesForLoadBalancerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zones. These must be in the same region as the load balancer.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(input.into());
            self
        }
        /// <p>The Availability Zones. These must be in the same region as the load balancer.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyLoadBalancerAttributes`.
    ///
    /// <p>Modifies the attributes of the specified load balancer.</p>
    /// <p>You can modify the load balancer attributes, such as <code>AccessLogs</code>, <code>ConnectionDraining</code>, and <code>CrossZoneLoadBalancing</code> by either enabling or disabling them. Or, you can modify the load balancer attribute <code>ConnectionSettings</code> by specifying an idle connection timeout value for your load balancer.</p>
    /// <p>For more information, see the following in the <i>Classic Load Balancers Guide</i>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Cross-Zone Load Balancing</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Connection Draining</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/access-log-collection.html">Access Logs</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Idle Connection Timeout</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyLoadBalancerAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_load_balancer_attributes_input::Builder,
    }
    impl<C, M, R> ModifyLoadBalancerAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyLoadBalancerAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyLoadBalancerAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyLoadBalancerAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyLoadBalancerAttributesInputOperationOutputAlias,
                crate::output::ModifyLoadBalancerAttributesOutput,
                crate::error::ModifyLoadBalancerAttributesError,
                crate::input::ModifyLoadBalancerAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The attributes for the load balancer.</p>
        pub fn load_balancer_attributes(
            mut self,
            input: crate::model::LoadBalancerAttributes,
        ) -> Self {
            self.inner = self.inner.load_balancer_attributes(input);
            self
        }
        /// <p>The attributes for the load balancer.</p>
        pub fn set_load_balancer_attributes(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerAttributes>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterInstancesWithLoadBalancer`.
    ///
    /// <p>Adds the specified instances to the specified load balancer.</p>
    /// <p>The instance must be a running instance in the same network as the load balancer (EC2-Classic or the same VPC). If you have EC2-Classic instances and a load balancer in a VPC with ClassicLink enabled, you can link the EC2-Classic instances to that VPC and then register the linked EC2-Classic instances with the load balancer in the VPC.</p>
    /// <p>Note that <code>RegisterInstanceWithLoadBalancer</code> completes when the request has been registered. Instance registration takes a little time to complete. To check the state of the registered instances, use <code>DescribeLoadBalancers</code> or <code>DescribeInstanceHealth</code>.</p>
    /// <p>After the instance is registered, it starts receiving traffic and requests from the load balancer. Any instance that is not in one of the Availability Zones registered for the load balancer is moved to the <code>OutOfService</code> state. If an Availability Zone is added to the load balancer later, any instances registered with the load balancer move to the <code>InService</code> state.</p>
    /// <p>To deregister instances from a load balancer, use <code>DeregisterInstancesFromLoadBalancer</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html">Register or De-Register EC2 Instances</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterInstancesWithLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_instances_with_load_balancer_input::Builder,
    }
    impl<C, M, R> RegisterInstancesWithLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterInstancesWithLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterInstancesWithLoadBalancerOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterInstancesWithLoadBalancerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterInstancesWithLoadBalancerInputOperationOutputAlias,
                crate::output::RegisterInstancesWithLoadBalancerOutput,
                crate::error::RegisterInstancesWithLoadBalancerError,
                crate::input::RegisterInstancesWithLoadBalancerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `Instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>The IDs of the instances.</p>
        pub fn instances(mut self, input: crate::model::Instance) -> Self {
            self.inner = self.inner.instances(input);
            self
        }
        /// <p>The IDs of the instances.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        ) -> Self {
            self.inner = self.inner.set_instances(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTags`.
    ///
    /// <p>Removes one or more tags from the specified load balancer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_input::Builder,
    }
    impl<C, M, R> RemoveTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsInputOperationOutputAlias,
                crate::output::RemoveTagsOutput,
                crate::error::RemoveTagsError,
                crate::input::RemoveTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `LoadBalancerNames`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_names`](Self::set_load_balancer_names).
        ///
        /// <p>The name of the load balancer. You can specify a maximum of one load balancer name.</p>
        pub fn load_balancer_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_names(input.into());
            self
        }
        /// <p>The name of the load balancer. You can specify a maximum of one load balancer name.</p>
        pub fn set_load_balancer_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_names(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tag keys to remove.</p>
        pub fn tags(mut self, input: crate::model::TagKeyOnly) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The list of tag keys to remove.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagKeyOnly>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetLoadBalancerListenerSSLCertificate`.
    ///
    /// <p>Sets the certificate that terminates the specified listener's SSL connections. The specified certificate replaces any prior certificate that was used on the same load balancer and port.</p>
    /// <p>For more information about updating your SSL certificate, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-update-ssl-cert.html">Replace the SSL Certificate for Your Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetLoadBalancerListenerSSLCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_load_balancer_listener_ssl_certificate_input::Builder,
    }
    impl<C, M, R> SetLoadBalancerListenerSSLCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetLoadBalancerListenerSSLCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetLoadBalancerListenerSslCertificateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::SetLoadBalancerListenerSSLCertificateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetLoadBalancerListenerSslCertificateInputOperationOutputAlias,
                crate::output::SetLoadBalancerListenerSslCertificateOutput,
                crate::error::SetLoadBalancerListenerSSLCertificateError,
                crate::input::SetLoadBalancerListenerSslCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The port that uses the specified SSL certificate.</p>
        pub fn load_balancer_port(mut self, input: i32) -> Self {
            self.inner = self.inner.load_balancer_port(input);
            self
        }
        /// <p>The port that uses the specified SSL certificate.</p>
        pub fn set_load_balancer_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_load_balancer_port(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SSL certificate.</p>
        pub fn ssl_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssl_certificate_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SSL certificate.</p>
        pub fn set_ssl_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssl_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetLoadBalancerPoliciesForBackendServer`.
    ///
    /// <p>Replaces the set of policies associated with the specified port on which the EC2 instance is listening with a new set of policies. At this time, only the back-end server authentication policy type can be applied to the instance ports; this policy type is composed of multiple public key policies.</p>
    /// <p>Each time you use <code>SetLoadBalancerPoliciesForBackendServer</code> to enable the policies, use the <code>PolicyNames</code> parameter to list the policies that you want to enable.</p>
    /// <p>You can use <code>DescribeLoadBalancers</code> or <code>DescribeLoadBalancerPolicies</code> to verify that the policy is associated with the EC2 instance.</p>
    /// <p>For more information about enabling back-end instance authentication, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-create-https-ssl-load-balancer.html#configure_backendauth_clt">Configure Back-end Instance Authentication</a> in the <i>Classic Load Balancers Guide</i>. For more information about Proxy Protocol, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-proxy-protocol.html">Configure Proxy Protocol Support</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetLoadBalancerPoliciesForBackendServer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_load_balancer_policies_for_backend_server_input::Builder,
    }
    impl<C, M, R> SetLoadBalancerPoliciesForBackendServer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetLoadBalancerPoliciesForBackendServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetLoadBalancerPoliciesForBackendServerOutput,
            aws_smithy_http::result::SdkError<
                crate::error::SetLoadBalancerPoliciesForBackendServerError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetLoadBalancerPoliciesForBackendServerInputOperationOutputAlias,
                crate::output::SetLoadBalancerPoliciesForBackendServerOutput,
                crate::error::SetLoadBalancerPoliciesForBackendServerError,
                crate::input::SetLoadBalancerPoliciesForBackendServerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The port number associated with the EC2 instance.</p>
        pub fn instance_port(mut self, input: i32) -> Self {
            self.inner = self.inner.instance_port(input);
            self
        }
        /// <p>The port number associated with the EC2 instance.</p>
        pub fn set_instance_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_instance_port(input);
            self
        }
        /// Appends an item to `PolicyNames`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>The names of the policies. If the list is empty, then all current polices are removed from the EC2 instance.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_names(input.into());
            self
        }
        /// <p>The names of the policies. If the list is empty, then all current polices are removed from the EC2 instance.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_policy_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetLoadBalancerPoliciesOfListener`.
    ///
    /// <p>Replaces the current set of policies for the specified load balancer port with the specified set of policies.</p>
    /// <p>To enable back-end server authentication, use <code>SetLoadBalancerPoliciesForBackendServer</code>.</p>
    /// <p>For more information about setting policies, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/ssl-config-update.html">Update the SSL Negotiation Configuration</a>, <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration">Duration-Based Session Stickiness</a>, and <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application">Application-Controlled Session Stickiness</a> in the <i>Classic Load Balancers Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetLoadBalancerPoliciesOfListener<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_load_balancer_policies_of_listener_input::Builder,
    }
    impl<C, M, R> SetLoadBalancerPoliciesOfListener<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetLoadBalancerPoliciesOfListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetLoadBalancerPoliciesOfListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::SetLoadBalancerPoliciesOfListenerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetLoadBalancerPoliciesOfListenerInputOperationOutputAlias,
                crate::output::SetLoadBalancerPoliciesOfListenerOutput,
                crate::error::SetLoadBalancerPoliciesOfListenerError,
                crate::input::SetLoadBalancerPoliciesOfListenerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The external port of the load balancer.</p>
        pub fn load_balancer_port(mut self, input: i32) -> Self {
            self.inner = self.inner.load_balancer_port(input);
            self
        }
        /// <p>The external port of the load balancer.</p>
        pub fn set_load_balancer_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_load_balancer_port(input);
            self
        }
        /// Appends an item to `PolicyNames`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>The names of the policies. This list must include all policies to be enabled. If you omit a policy that is currently enabled, it is disabled. If the list is empty, all current policies are disabled.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_names(input.into());
            self
        }
        /// <p>The names of the policies. This list must include all policies to be enabled. If you omit a policy that is currently enabled, it is disabled. If the list is empty, all current policies are disabled.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_policy_names(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
