// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The key of a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagKeyOnly {
    /// <p>The name of the key.</p>
    pub key: std::option::Option<std::string::String>,
}
impl TagKeyOnly {
    /// <p>The name of the key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
}
impl std::fmt::Debug for TagKeyOnly {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagKeyOnly");
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`TagKeyOnly`](crate::model::TagKeyOnly)
pub mod tag_key_only {
    /// A builder for [`TagKeyOnly`](crate::model::TagKeyOnly)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`TagKeyOnly`](crate::model::TagKeyOnly)
        pub fn build(self) -> crate::model::TagKeyOnly {
            crate::model::TagKeyOnly { key: self.key }
        }
    }
}
impl TagKeyOnly {
    /// Creates a new builder-style object to manufacture [`TagKeyOnly`](crate::model::TagKeyOnly)
    pub fn builder() -> crate::model::tag_key_only::Builder {
        crate::model::tag_key_only::Builder::default()
    }
}

/// <p>The ID of an EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Instance {
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
}
impl Instance {
    /// <p>The instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
}
impl std::fmt::Debug for Instance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Instance");
        formatter.field("instance_id", &self.instance_id);
        formatter.finish()
    }
}
/// See [`Instance`](crate::model::Instance)
pub mod instance {
    /// A builder for [`Instance`](crate::model::Instance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Instance`](crate::model::Instance)
        pub fn build(self) -> crate::model::Instance {
            crate::model::Instance {
                instance_id: self.instance_id,
            }
        }
    }
}
impl Instance {
    /// Creates a new builder-style object to manufacture [`Instance`](crate::model::Instance)
    pub fn builder() -> crate::model::instance::Builder {
        crate::model::instance::Builder::default()
    }
}

/// <p>The attributes for a load balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancerAttributes {
    /// <p>If enabled, the load balancer routes the request traffic evenly across all instances regardless of the Availability Zones.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Configure Cross-Zone Load Balancing</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub cross_zone_load_balancing: std::option::Option<crate::model::CrossZoneLoadBalancing>,
    /// <p>If enabled, the load balancer captures detailed information of all requests and delivers the information to the Amazon S3 bucket that you specify.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html">Enable Access Logs</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub access_log: std::option::Option<crate::model::AccessLog>,
    /// <p>If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic away from a deregistered or unhealthy instance.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure Connection Draining</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub connection_draining: std::option::Option<crate::model::ConnectionDraining>,
    /// <p>If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection) for the specified duration.</p>
    /// <p>By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and back-end connections of your load balancer.
    /// For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure Idle Connection Timeout</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub connection_settings: std::option::Option<crate::model::ConnectionSettings>,
    /// <p>Any additional attributes.</p>
    pub additional_attributes:
        std::option::Option<std::vec::Vec<crate::model::AdditionalAttribute>>,
}
impl LoadBalancerAttributes {
    /// <p>If enabled, the load balancer routes the request traffic evenly across all instances regardless of the Availability Zones.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Configure Cross-Zone Load Balancing</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub fn cross_zone_load_balancing(
        &self,
    ) -> std::option::Option<&crate::model::CrossZoneLoadBalancing> {
        self.cross_zone_load_balancing.as_ref()
    }
    /// <p>If enabled, the load balancer captures detailed information of all requests and delivers the information to the Amazon S3 bucket that you specify.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html">Enable Access Logs</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub fn access_log(&self) -> std::option::Option<&crate::model::AccessLog> {
        self.access_log.as_ref()
    }
    /// <p>If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic away from a deregistered or unhealthy instance.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure Connection Draining</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub fn connection_draining(&self) -> std::option::Option<&crate::model::ConnectionDraining> {
        self.connection_draining.as_ref()
    }
    /// <p>If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection) for the specified duration.</p>
    /// <p>By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and back-end connections of your load balancer.
    /// For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure Idle Connection Timeout</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub fn connection_settings(&self) -> std::option::Option<&crate::model::ConnectionSettings> {
        self.connection_settings.as_ref()
    }
    /// <p>Any additional attributes.</p>
    pub fn additional_attributes(
        &self,
    ) -> std::option::Option<&[crate::model::AdditionalAttribute]> {
        self.additional_attributes.as_deref()
    }
}
impl std::fmt::Debug for LoadBalancerAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancerAttributes");
        formatter.field("cross_zone_load_balancing", &self.cross_zone_load_balancing);
        formatter.field("access_log", &self.access_log);
        formatter.field("connection_draining", &self.connection_draining);
        formatter.field("connection_settings", &self.connection_settings);
        formatter.field("additional_attributes", &self.additional_attributes);
        formatter.finish()
    }
}
/// See [`LoadBalancerAttributes`](crate::model::LoadBalancerAttributes)
pub mod load_balancer_attributes {
    /// A builder for [`LoadBalancerAttributes`](crate::model::LoadBalancerAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_zone_load_balancing:
            std::option::Option<crate::model::CrossZoneLoadBalancing>,
        pub(crate) access_log: std::option::Option<crate::model::AccessLog>,
        pub(crate) connection_draining: std::option::Option<crate::model::ConnectionDraining>,
        pub(crate) connection_settings: std::option::Option<crate::model::ConnectionSettings>,
        pub(crate) additional_attributes:
            std::option::Option<std::vec::Vec<crate::model::AdditionalAttribute>>,
    }
    impl Builder {
        /// <p>If enabled, the load balancer routes the request traffic evenly across all instances regardless of the Availability Zones.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Configure Cross-Zone Load Balancing</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn cross_zone_load_balancing(
            mut self,
            input: crate::model::CrossZoneLoadBalancing,
        ) -> Self {
            self.cross_zone_load_balancing = Some(input);
            self
        }
        /// <p>If enabled, the load balancer routes the request traffic evenly across all instances regardless of the Availability Zones.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Configure Cross-Zone Load Balancing</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn set_cross_zone_load_balancing(
            mut self,
            input: std::option::Option<crate::model::CrossZoneLoadBalancing>,
        ) -> Self {
            self.cross_zone_load_balancing = input;
            self
        }
        /// <p>If enabled, the load balancer captures detailed information of all requests and delivers the information to the Amazon S3 bucket that you specify.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html">Enable Access Logs</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn access_log(mut self, input: crate::model::AccessLog) -> Self {
            self.access_log = Some(input);
            self
        }
        /// <p>If enabled, the load balancer captures detailed information of all requests and delivers the information to the Amazon S3 bucket that you specify.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html">Enable Access Logs</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn set_access_log(
            mut self,
            input: std::option::Option<crate::model::AccessLog>,
        ) -> Self {
            self.access_log = input;
            self
        }
        /// <p>If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic away from a deregistered or unhealthy instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure Connection Draining</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn connection_draining(mut self, input: crate::model::ConnectionDraining) -> Self {
            self.connection_draining = Some(input);
            self
        }
        /// <p>If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic away from a deregistered or unhealthy instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure Connection Draining</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn set_connection_draining(
            mut self,
            input: std::option::Option<crate::model::ConnectionDraining>,
        ) -> Self {
            self.connection_draining = input;
            self
        }
        /// <p>If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection) for the specified duration.</p>
        /// <p>By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and back-end connections of your load balancer.
        /// For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure Idle Connection Timeout</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn connection_settings(mut self, input: crate::model::ConnectionSettings) -> Self {
            self.connection_settings = Some(input);
            self
        }
        /// <p>If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection) for the specified duration.</p>
        /// <p>By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and back-end connections of your load balancer.
        /// For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure Idle Connection Timeout</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn set_connection_settings(
            mut self,
            input: std::option::Option<crate::model::ConnectionSettings>,
        ) -> Self {
            self.connection_settings = input;
            self
        }
        /// Appends an item to `additional_attributes`.
        ///
        /// To override the contents of this collection use [`set_additional_attributes`](Self::set_additional_attributes).
        ///
        /// <p>Any additional attributes.</p>
        pub fn additional_attributes(
            mut self,
            input: impl Into<crate::model::AdditionalAttribute>,
        ) -> Self {
            let mut v = self.additional_attributes.unwrap_or_default();
            v.push(input.into());
            self.additional_attributes = Some(v);
            self
        }
        /// <p>Any additional attributes.</p>
        pub fn set_additional_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdditionalAttribute>>,
        ) -> Self {
            self.additional_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancerAttributes`](crate::model::LoadBalancerAttributes)
        pub fn build(self) -> crate::model::LoadBalancerAttributes {
            crate::model::LoadBalancerAttributes {
                cross_zone_load_balancing: self.cross_zone_load_balancing,
                access_log: self.access_log,
                connection_draining: self.connection_draining,
                connection_settings: self.connection_settings,
                additional_attributes: self.additional_attributes,
            }
        }
    }
}
impl LoadBalancerAttributes {
    /// Creates a new builder-style object to manufacture [`LoadBalancerAttributes`](crate::model::LoadBalancerAttributes)
    pub fn builder() -> crate::model::load_balancer_attributes::Builder {
        crate::model::load_balancer_attributes::Builder::default()
    }
}

/// <p>Information about additional load balancer attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdditionalAttribute {
    /// <p>The name of the attribute.</p>
    /// <p>The following attribute is supported.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>elb.http.desyncmitigationmode</code> - Determines how the load balancer handles requests that  
    /// might pose a security risk to your application. The possible values are <code>monitor</code>,
    /// <code>defensive</code>, and <code>strictest</code>. The default is <code>defensive</code>.</p>
    /// </li>
    /// </ul>
    pub key: std::option::Option<std::string::String>,
    /// <p>This value of the attribute.</p>
    pub value: std::option::Option<std::string::String>,
}
impl AdditionalAttribute {
    /// <p>The name of the attribute.</p>
    /// <p>The following attribute is supported.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>elb.http.desyncmitigationmode</code> - Determines how the load balancer handles requests that  
    /// might pose a security risk to your application. The possible values are <code>monitor</code>,
    /// <code>defensive</code>, and <code>strictest</code>. The default is <code>defensive</code>.</p>
    /// </li>
    /// </ul>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>This value of the attribute.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for AdditionalAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdditionalAttribute");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AdditionalAttribute`](crate::model::AdditionalAttribute)
pub mod additional_attribute {
    /// A builder for [`AdditionalAttribute`](crate::model::AdditionalAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the attribute.</p>
        /// <p>The following attribute is supported.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>elb.http.desyncmitigationmode</code> - Determines how the load balancer handles requests that  
        /// might pose a security risk to your application. The possible values are <code>monitor</code>,
        /// <code>defensive</code>, and <code>strictest</code>. The default is <code>defensive</code>.</p>
        /// </li>
        /// </ul>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the attribute.</p>
        /// <p>The following attribute is supported.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>elb.http.desyncmitigationmode</code> - Determines how the load balancer handles requests that  
        /// might pose a security risk to your application. The possible values are <code>monitor</code>,
        /// <code>defensive</code>, and <code>strictest</code>. The default is <code>defensive</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>This value of the attribute.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>This value of the attribute.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AdditionalAttribute`](crate::model::AdditionalAttribute)
        pub fn build(self) -> crate::model::AdditionalAttribute {
            crate::model::AdditionalAttribute {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl AdditionalAttribute {
    /// Creates a new builder-style object to manufacture [`AdditionalAttribute`](crate::model::AdditionalAttribute)
    pub fn builder() -> crate::model::additional_attribute::Builder {
        crate::model::additional_attribute::Builder::default()
    }
}

/// <p>Information about the <code>ConnectionSettings</code> attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionSettings {
    /// <p>The time, in seconds, that the connection is allowed to be idle (no data has been sent over the connection) before it is closed by the load balancer.</p>
    pub idle_timeout: std::option::Option<i32>,
}
impl ConnectionSettings {
    /// <p>The time, in seconds, that the connection is allowed to be idle (no data has been sent over the connection) before it is closed by the load balancer.</p>
    pub fn idle_timeout(&self) -> std::option::Option<i32> {
        self.idle_timeout
    }
}
impl std::fmt::Debug for ConnectionSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionSettings");
        formatter.field("idle_timeout", &self.idle_timeout);
        formatter.finish()
    }
}
/// See [`ConnectionSettings`](crate::model::ConnectionSettings)
pub mod connection_settings {
    /// A builder for [`ConnectionSettings`](crate::model::ConnectionSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) idle_timeout: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The time, in seconds, that the connection is allowed to be idle (no data has been sent over the connection) before it is closed by the load balancer.</p>
        pub fn idle_timeout(mut self, input: i32) -> Self {
            self.idle_timeout = Some(input);
            self
        }
        /// <p>The time, in seconds, that the connection is allowed to be idle (no data has been sent over the connection) before it is closed by the load balancer.</p>
        pub fn set_idle_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionSettings`](crate::model::ConnectionSettings)
        pub fn build(self) -> crate::model::ConnectionSettings {
            crate::model::ConnectionSettings {
                idle_timeout: self.idle_timeout,
            }
        }
    }
}
impl ConnectionSettings {
    /// Creates a new builder-style object to manufacture [`ConnectionSettings`](crate::model::ConnectionSettings)
    pub fn builder() -> crate::model::connection_settings::Builder {
        crate::model::connection_settings::Builder::default()
    }
}

/// <p>Information about the <code>ConnectionDraining</code> attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionDraining {
    /// <p>Specifies whether connection draining is enabled for the load balancer.</p>
    pub enabled: bool,
    /// <p>The maximum time, in seconds, to keep the existing connections open before deregistering the instances.</p>
    pub timeout: std::option::Option<i32>,
}
impl ConnectionDraining {
    /// <p>Specifies whether connection draining is enabled for the load balancer.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The maximum time, in seconds, to keep the existing connections open before deregistering the instances.</p>
    pub fn timeout(&self) -> std::option::Option<i32> {
        self.timeout
    }
}
impl std::fmt::Debug for ConnectionDraining {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionDraining");
        formatter.field("enabled", &self.enabled);
        formatter.field("timeout", &self.timeout);
        formatter.finish()
    }
}
/// See [`ConnectionDraining`](crate::model::ConnectionDraining)
pub mod connection_draining {
    /// A builder for [`ConnectionDraining`](crate::model::ConnectionDraining)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) timeout: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies whether connection draining is enabled for the load balancer.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether connection draining is enabled for the load balancer.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The maximum time, in seconds, to keep the existing connections open before deregistering the instances.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The maximum time, in seconds, to keep the existing connections open before deregistering the instances.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionDraining`](crate::model::ConnectionDraining)
        pub fn build(self) -> crate::model::ConnectionDraining {
            crate::model::ConnectionDraining {
                enabled: self.enabled.unwrap_or_default(),
                timeout: self.timeout,
            }
        }
    }
}
impl ConnectionDraining {
    /// Creates a new builder-style object to manufacture [`ConnectionDraining`](crate::model::ConnectionDraining)
    pub fn builder() -> crate::model::connection_draining::Builder {
        crate::model::connection_draining::Builder::default()
    }
}

/// <p>Information about the <code>AccessLog</code> attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessLog {
    /// <p>Specifies whether access logs are enabled for the load balancer.</p>
    pub enabled: bool,
    /// <p>The name of the Amazon S3 bucket where the access logs are stored.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The interval for publishing the access logs. You can specify an interval of either 5 minutes or 60 minutes.</p>
    /// <p>Default: 60 minutes</p>
    pub emit_interval: std::option::Option<i32>,
    /// <p>The logical hierarchy you created for your Amazon S3 bucket, for example <code>my-bucket-prefix/prod</code>.  
    /// If the prefix is not provided, the log is placed at the root level of the bucket.</p>
    pub s3_bucket_prefix: std::option::Option<std::string::String>,
}
impl AccessLog {
    /// <p>Specifies whether access logs are enabled for the load balancer.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The name of the Amazon S3 bucket where the access logs are stored.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>The interval for publishing the access logs. You can specify an interval of either 5 minutes or 60 minutes.</p>
    /// <p>Default: 60 minutes</p>
    pub fn emit_interval(&self) -> std::option::Option<i32> {
        self.emit_interval
    }
    /// <p>The logical hierarchy you created for your Amazon S3 bucket, for example <code>my-bucket-prefix/prod</code>.  
    /// If the prefix is not provided, the log is placed at the root level of the bucket.</p>
    pub fn s3_bucket_prefix(&self) -> std::option::Option<&str> {
        self.s3_bucket_prefix.as_deref()
    }
}
impl std::fmt::Debug for AccessLog {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessLog");
        formatter.field("enabled", &self.enabled);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("emit_interval", &self.emit_interval);
        formatter.field("s3_bucket_prefix", &self.s3_bucket_prefix);
        formatter.finish()
    }
}
/// See [`AccessLog`](crate::model::AccessLog)
pub mod access_log {
    /// A builder for [`AccessLog`](crate::model::AccessLog)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) emit_interval: std::option::Option<i32>,
        pub(crate) s3_bucket_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether access logs are enabled for the load balancer.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether access logs are enabled for the load balancer.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket where the access logs are stored.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket where the access logs are stored.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>The interval for publishing the access logs. You can specify an interval of either 5 minutes or 60 minutes.</p>
        /// <p>Default: 60 minutes</p>
        pub fn emit_interval(mut self, input: i32) -> Self {
            self.emit_interval = Some(input);
            self
        }
        /// <p>The interval for publishing the access logs. You can specify an interval of either 5 minutes or 60 minutes.</p>
        /// <p>Default: 60 minutes</p>
        pub fn set_emit_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.emit_interval = input;
            self
        }
        /// <p>The logical hierarchy you created for your Amazon S3 bucket, for example <code>my-bucket-prefix/prod</code>.  
        /// If the prefix is not provided, the log is placed at the root level of the bucket.</p>
        pub fn s3_bucket_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_prefix = Some(input.into());
            self
        }
        /// <p>The logical hierarchy you created for your Amazon S3 bucket, for example <code>my-bucket-prefix/prod</code>.  
        /// If the prefix is not provided, the log is placed at the root level of the bucket.</p>
        pub fn set_s3_bucket_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessLog`](crate::model::AccessLog)
        pub fn build(self) -> crate::model::AccessLog {
            crate::model::AccessLog {
                enabled: self.enabled.unwrap_or_default(),
                s3_bucket_name: self.s3_bucket_name,
                emit_interval: self.emit_interval,
                s3_bucket_prefix: self.s3_bucket_prefix,
            }
        }
    }
}
impl AccessLog {
    /// Creates a new builder-style object to manufacture [`AccessLog`](crate::model::AccessLog)
    pub fn builder() -> crate::model::access_log::Builder {
        crate::model::access_log::Builder::default()
    }
}

/// <p>Information about the <code>CrossZoneLoadBalancing</code> attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CrossZoneLoadBalancing {
    /// <p>Specifies whether cross-zone load balancing is enabled for the load balancer.</p>
    pub enabled: bool,
}
impl CrossZoneLoadBalancing {
    /// <p>Specifies whether cross-zone load balancing is enabled for the load balancer.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for CrossZoneLoadBalancing {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CrossZoneLoadBalancing");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`CrossZoneLoadBalancing`](crate::model::CrossZoneLoadBalancing)
pub mod cross_zone_load_balancing {
    /// A builder for [`CrossZoneLoadBalancing`](crate::model::CrossZoneLoadBalancing)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether cross-zone load balancing is enabled for the load balancer.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether cross-zone load balancing is enabled for the load balancer.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`CrossZoneLoadBalancing`](crate::model::CrossZoneLoadBalancing)
        pub fn build(self) -> crate::model::CrossZoneLoadBalancing {
            crate::model::CrossZoneLoadBalancing {
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl CrossZoneLoadBalancing {
    /// Creates a new builder-style object to manufacture [`CrossZoneLoadBalancing`](crate::model::CrossZoneLoadBalancing)
    pub fn builder() -> crate::model::cross_zone_load_balancing::Builder {
        crate::model::cross_zone_load_balancing::Builder::default()
    }
}

/// <p>The tags associated with a load balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagDescription {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagDescription {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagDescription");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`TagDescription`](crate::model::TagDescription)
pub mod tag_description {
    /// A builder for [`TagDescription`](crate::model::TagDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagDescription`](crate::model::TagDescription)
        pub fn build(self) -> crate::model::TagDescription {
            crate::model::TagDescription {
                load_balancer_name: self.load_balancer_name,
                tags: self.tags,
            }
        }
    }
}
impl TagDescription {
    /// Creates a new builder-style object to manufacture [`TagDescription`](crate::model::TagDescription)
    pub fn builder() -> crate::model::tag_description::Builder {
        crate::model::tag_description::Builder::default()
    }
}

/// <p>Information about a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Information about a load balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancerDescription {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The DNS name of the load balancer.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>The DNS name of the load balancer.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/using-domain-names-with-elb.html">Configure a Custom Domain Name</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub canonical_hosted_zone_name: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Route 53 hosted zone for the load balancer.</p>
    pub canonical_hosted_zone_name_id: std::option::Option<std::string::String>,
    /// <p>The listeners for the load balancer.</p>
    pub listener_descriptions:
        std::option::Option<std::vec::Vec<crate::model::ListenerDescription>>,
    /// <p>The policies defined for the load balancer.</p>
    pub policies: std::option::Option<crate::model::Policies>,
    /// <p>Information about your EC2 instances.</p>
    pub backend_server_descriptions:
        std::option::Option<std::vec::Vec<crate::model::BackendServerDescription>>,
    /// <p>The Availability Zones for the load balancer.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IDs of the subnets for the load balancer.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the VPC for the load balancer.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The IDs of the instances for the load balancer.</p>
    pub instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
    /// <p>Information about the health checks conducted on the load balancer.</p>
    pub health_check: std::option::Option<crate::model::HealthCheck>,
    /// <p>The security group for the load balancer, which you can use as part of your inbound rules for your registered instances.
    /// To only allow traffic from load balancers, add a security group rule that specifies this source security group as the inbound source.</p>
    pub source_security_group: std::option::Option<crate::model::SourceSecurityGroup>,
    /// <p>The security groups for the load balancer. Valid only for load balancers in a VPC.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date and time the load balancer was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The type of load balancer. Valid only for load balancers in a VPC.</p>
    /// <p>If <code>Scheme</code> is <code>internet-facing</code>, the load balancer
    /// has a public DNS name that resolves to a public IP address.</p>
    /// <p>If <code>Scheme</code> is <code>internal</code>, the load balancer has a public
    /// DNS name that resolves to a private IP address.</p>
    pub scheme: std::option::Option<std::string::String>,
}
impl LoadBalancerDescription {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The DNS name of the load balancer.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>The DNS name of the load balancer.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/using-domain-names-with-elb.html">Configure a Custom Domain Name</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub fn canonical_hosted_zone_name(&self) -> std::option::Option<&str> {
        self.canonical_hosted_zone_name.as_deref()
    }
    /// <p>The ID of the Amazon Route 53 hosted zone for the load balancer.</p>
    pub fn canonical_hosted_zone_name_id(&self) -> std::option::Option<&str> {
        self.canonical_hosted_zone_name_id.as_deref()
    }
    /// <p>The listeners for the load balancer.</p>
    pub fn listener_descriptions(
        &self,
    ) -> std::option::Option<&[crate::model::ListenerDescription]> {
        self.listener_descriptions.as_deref()
    }
    /// <p>The policies defined for the load balancer.</p>
    pub fn policies(&self) -> std::option::Option<&crate::model::Policies> {
        self.policies.as_ref()
    }
    /// <p>Information about your EC2 instances.</p>
    pub fn backend_server_descriptions(
        &self,
    ) -> std::option::Option<&[crate::model::BackendServerDescription]> {
        self.backend_server_descriptions.as_deref()
    }
    /// <p>The Availability Zones for the load balancer.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>The IDs of the subnets for the load balancer.</p>
    pub fn subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.subnets.as_deref()
    }
    /// <p>The ID of the VPC for the load balancer.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The IDs of the instances for the load balancer.</p>
    pub fn instances(&self) -> std::option::Option<&[crate::model::Instance]> {
        self.instances.as_deref()
    }
    /// <p>Information about the health checks conducted on the load balancer.</p>
    pub fn health_check(&self) -> std::option::Option<&crate::model::HealthCheck> {
        self.health_check.as_ref()
    }
    /// <p>The security group for the load balancer, which you can use as part of your inbound rules for your registered instances.
    /// To only allow traffic from load balancers, add a security group rule that specifies this source security group as the inbound source.</p>
    pub fn source_security_group(&self) -> std::option::Option<&crate::model::SourceSecurityGroup> {
        self.source_security_group.as_ref()
    }
    /// <p>The security groups for the load balancer. Valid only for load balancers in a VPC.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>The date and time the load balancer was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The type of load balancer. Valid only for load balancers in a VPC.</p>
    /// <p>If <code>Scheme</code> is <code>internet-facing</code>, the load balancer
    /// has a public DNS name that resolves to a public IP address.</p>
    /// <p>If <code>Scheme</code> is <code>internal</code>, the load balancer has a public
    /// DNS name that resolves to a private IP address.</p>
    pub fn scheme(&self) -> std::option::Option<&str> {
        self.scheme.as_deref()
    }
}
impl std::fmt::Debug for LoadBalancerDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancerDescription");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("dns_name", &self.dns_name);
        formatter.field(
            "canonical_hosted_zone_name",
            &self.canonical_hosted_zone_name,
        );
        formatter.field(
            "canonical_hosted_zone_name_id",
            &self.canonical_hosted_zone_name_id,
        );
        formatter.field("listener_descriptions", &self.listener_descriptions);
        formatter.field("policies", &self.policies);
        formatter.field(
            "backend_server_descriptions",
            &self.backend_server_descriptions,
        );
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("subnets", &self.subnets);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("instances", &self.instances);
        formatter.field("health_check", &self.health_check);
        formatter.field("source_security_group", &self.source_security_group);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("created_time", &self.created_time);
        formatter.field("scheme", &self.scheme);
        formatter.finish()
    }
}
/// See [`LoadBalancerDescription`](crate::model::LoadBalancerDescription)
pub mod load_balancer_description {
    /// A builder for [`LoadBalancerDescription`](crate::model::LoadBalancerDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) canonical_hosted_zone_name: std::option::Option<std::string::String>,
        pub(crate) canonical_hosted_zone_name_id: std::option::Option<std::string::String>,
        pub(crate) listener_descriptions:
            std::option::Option<std::vec::Vec<crate::model::ListenerDescription>>,
        pub(crate) policies: std::option::Option<crate::model::Policies>,
        pub(crate) backend_server_descriptions:
            std::option::Option<std::vec::Vec<crate::model::BackendServerDescription>>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        pub(crate) health_check: std::option::Option<crate::model::HealthCheck>,
        pub(crate) source_security_group: std::option::Option<crate::model::SourceSecurityGroup>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) scheme: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The DNS name of the load balancer.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>The DNS name of the load balancer.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>The DNS name of the load balancer.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/using-domain-names-with-elb.html">Configure a Custom Domain Name</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn canonical_hosted_zone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.canonical_hosted_zone_name = Some(input.into());
            self
        }
        /// <p>The DNS name of the load balancer.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/using-domain-names-with-elb.html">Configure a Custom Domain Name</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn set_canonical_hosted_zone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.canonical_hosted_zone_name = input;
            self
        }
        /// <p>The ID of the Amazon Route 53 hosted zone for the load balancer.</p>
        pub fn canonical_hosted_zone_name_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.canonical_hosted_zone_name_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Route 53 hosted zone for the load balancer.</p>
        pub fn set_canonical_hosted_zone_name_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.canonical_hosted_zone_name_id = input;
            self
        }
        /// Appends an item to `listener_descriptions`.
        ///
        /// To override the contents of this collection use [`set_listener_descriptions`](Self::set_listener_descriptions).
        ///
        /// <p>The listeners for the load balancer.</p>
        pub fn listener_descriptions(
            mut self,
            input: impl Into<crate::model::ListenerDescription>,
        ) -> Self {
            let mut v = self.listener_descriptions.unwrap_or_default();
            v.push(input.into());
            self.listener_descriptions = Some(v);
            self
        }
        /// <p>The listeners for the load balancer.</p>
        pub fn set_listener_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListenerDescription>>,
        ) -> Self {
            self.listener_descriptions = input;
            self
        }
        /// <p>The policies defined for the load balancer.</p>
        pub fn policies(mut self, input: crate::model::Policies) -> Self {
            self.policies = Some(input);
            self
        }
        /// <p>The policies defined for the load balancer.</p>
        pub fn set_policies(mut self, input: std::option::Option<crate::model::Policies>) -> Self {
            self.policies = input;
            self
        }
        /// Appends an item to `backend_server_descriptions`.
        ///
        /// To override the contents of this collection use [`set_backend_server_descriptions`](Self::set_backend_server_descriptions).
        ///
        /// <p>Information about your EC2 instances.</p>
        pub fn backend_server_descriptions(
            mut self,
            input: impl Into<crate::model::BackendServerDescription>,
        ) -> Self {
            let mut v = self.backend_server_descriptions.unwrap_or_default();
            v.push(input.into());
            self.backend_server_descriptions = Some(v);
            self
        }
        /// <p>Information about your EC2 instances.</p>
        pub fn set_backend_server_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackendServerDescription>>,
        ) -> Self {
            self.backend_server_descriptions = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zones for the load balancer.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>The Availability Zones for the load balancer.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the subnets for the load balancer.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The IDs of the subnets for the load balancer.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// <p>The ID of the VPC for the load balancer.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC for the load balancer.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>The IDs of the instances for the load balancer.</p>
        pub fn instances(mut self, input: impl Into<crate::model::Instance>) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input.into());
            self.instances = Some(v);
            self
        }
        /// <p>The IDs of the instances for the load balancer.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// <p>Information about the health checks conducted on the load balancer.</p>
        pub fn health_check(mut self, input: crate::model::HealthCheck) -> Self {
            self.health_check = Some(input);
            self
        }
        /// <p>Information about the health checks conducted on the load balancer.</p>
        pub fn set_health_check(
            mut self,
            input: std::option::Option<crate::model::HealthCheck>,
        ) -> Self {
            self.health_check = input;
            self
        }
        /// <p>The security group for the load balancer, which you can use as part of your inbound rules for your registered instances.
        /// To only allow traffic from load balancers, add a security group rule that specifies this source security group as the inbound source.</p>
        pub fn source_security_group(mut self, input: crate::model::SourceSecurityGroup) -> Self {
            self.source_security_group = Some(input);
            self
        }
        /// <p>The security group for the load balancer, which you can use as part of your inbound rules for your registered instances.
        /// To only allow traffic from load balancers, add a security group rule that specifies this source security group as the inbound source.</p>
        pub fn set_source_security_group(
            mut self,
            input: std::option::Option<crate::model::SourceSecurityGroup>,
        ) -> Self {
            self.source_security_group = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The security groups for the load balancer. Valid only for load balancers in a VPC.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The security groups for the load balancer. Valid only for load balancers in a VPC.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The date and time the load balancer was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time the load balancer was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The type of load balancer. Valid only for load balancers in a VPC.</p>
        /// <p>If <code>Scheme</code> is <code>internet-facing</code>, the load balancer
        /// has a public DNS name that resolves to a public IP address.</p>
        /// <p>If <code>Scheme</code> is <code>internal</code>, the load balancer has a public
        /// DNS name that resolves to a private IP address.</p>
        pub fn scheme(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheme = Some(input.into());
            self
        }
        /// <p>The type of load balancer. Valid only for load balancers in a VPC.</p>
        /// <p>If <code>Scheme</code> is <code>internet-facing</code>, the load balancer
        /// has a public DNS name that resolves to a public IP address.</p>
        /// <p>If <code>Scheme</code> is <code>internal</code>, the load balancer has a public
        /// DNS name that resolves to a private IP address.</p>
        pub fn set_scheme(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scheme = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancerDescription`](crate::model::LoadBalancerDescription)
        pub fn build(self) -> crate::model::LoadBalancerDescription {
            crate::model::LoadBalancerDescription {
                load_balancer_name: self.load_balancer_name,
                dns_name: self.dns_name,
                canonical_hosted_zone_name: self.canonical_hosted_zone_name,
                canonical_hosted_zone_name_id: self.canonical_hosted_zone_name_id,
                listener_descriptions: self.listener_descriptions,
                policies: self.policies,
                backend_server_descriptions: self.backend_server_descriptions,
                availability_zones: self.availability_zones,
                subnets: self.subnets,
                vpc_id: self.vpc_id,
                instances: self.instances,
                health_check: self.health_check,
                source_security_group: self.source_security_group,
                security_groups: self.security_groups,
                created_time: self.created_time,
                scheme: self.scheme,
            }
        }
    }
}
impl LoadBalancerDescription {
    /// Creates a new builder-style object to manufacture [`LoadBalancerDescription`](crate::model::LoadBalancerDescription)
    pub fn builder() -> crate::model::load_balancer_description::Builder {
        crate::model::load_balancer_description::Builder::default()
    }
}

/// <p>Information about a source security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceSecurityGroup {
    /// <p>The owner of the security group.</p>
    pub owner_alias: std::option::Option<std::string::String>,
    /// <p>The name of the security group.</p>
    pub group_name: std::option::Option<std::string::String>,
}
impl SourceSecurityGroup {
    /// <p>The owner of the security group.</p>
    pub fn owner_alias(&self) -> std::option::Option<&str> {
        self.owner_alias.as_deref()
    }
    /// <p>The name of the security group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
}
impl std::fmt::Debug for SourceSecurityGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceSecurityGroup");
        formatter.field("owner_alias", &self.owner_alias);
        formatter.field("group_name", &self.group_name);
        formatter.finish()
    }
}
/// See [`SourceSecurityGroup`](crate::model::SourceSecurityGroup)
pub mod source_security_group {
    /// A builder for [`SourceSecurityGroup`](crate::model::SourceSecurityGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_alias: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The owner of the security group.</p>
        pub fn owner_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_alias = Some(input.into());
            self
        }
        /// <p>The owner of the security group.</p>
        pub fn set_owner_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_alias = input;
            self
        }
        /// <p>The name of the security group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the security group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceSecurityGroup`](crate::model::SourceSecurityGroup)
        pub fn build(self) -> crate::model::SourceSecurityGroup {
            crate::model::SourceSecurityGroup {
                owner_alias: self.owner_alias,
                group_name: self.group_name,
            }
        }
    }
}
impl SourceSecurityGroup {
    /// Creates a new builder-style object to manufacture [`SourceSecurityGroup`](crate::model::SourceSecurityGroup)
    pub fn builder() -> crate::model::source_security_group::Builder {
        crate::model::source_security_group::Builder::default()
    }
}

/// <p>Information about a health check.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealthCheck {
    /// <p>The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL. The range of valid ports is one (1) through 65535.</p>
    /// <p>TCP is the default, specified as a TCP: port pair, for example "TCP:5000". In this case, a health check simply attempts to open a TCP connection to the instance on the specified port. Failure to connect within the configured timeout is considered unhealthy.</p>
    /// <p>SSL is also specified as SSL: port pair, for example, SSL:5000.</p>
    /// <p>For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified as a HTTP:port;/;PathToPing; grouping, for example "HTTP:80/weather/us/wa/seattle". In this case, a HTTP GET request is issued to the instance on the given port and path. Any answer other than "200 OK" within the timeout period is considered unhealthy.</p>
    /// <p>The total length of the HTTP ping target must be 1024 16-bit Unicode characters or less.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>The approximate interval, in seconds, between health checks of an individual instance.</p>
    pub interval: i32,
    /// <p>The amount of time, in seconds, during which no response means a failed health check.</p>
    /// <p>This value must be less than the <code>Interval</code> value.</p>
    pub timeout: i32,
    /// <p>The number of consecutive health check failures required before moving the instance to the <code>Unhealthy</code> state.</p>
    pub unhealthy_threshold: i32,
    /// <p>The number of consecutive health checks successes required before moving the instance to the <code>Healthy</code> state.</p>
    pub healthy_threshold: i32,
}
impl HealthCheck {
    /// <p>The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL. The range of valid ports is one (1) through 65535.</p>
    /// <p>TCP is the default, specified as a TCP: port pair, for example "TCP:5000". In this case, a health check simply attempts to open a TCP connection to the instance on the specified port. Failure to connect within the configured timeout is considered unhealthy.</p>
    /// <p>SSL is also specified as SSL: port pair, for example, SSL:5000.</p>
    /// <p>For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified as a HTTP:port;/;PathToPing; grouping, for example "HTTP:80/weather/us/wa/seattle". In this case, a HTTP GET request is issued to the instance on the given port and path. Any answer other than "200 OK" within the timeout period is considered unhealthy.</p>
    /// <p>The total length of the HTTP ping target must be 1024 16-bit Unicode characters or less.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
    /// <p>The approximate interval, in seconds, between health checks of an individual instance.</p>
    pub fn interval(&self) -> i32 {
        self.interval
    }
    /// <p>The amount of time, in seconds, during which no response means a failed health check.</p>
    /// <p>This value must be less than the <code>Interval</code> value.</p>
    pub fn timeout(&self) -> i32 {
        self.timeout
    }
    /// <p>The number of consecutive health check failures required before moving the instance to the <code>Unhealthy</code> state.</p>
    pub fn unhealthy_threshold(&self) -> i32 {
        self.unhealthy_threshold
    }
    /// <p>The number of consecutive health checks successes required before moving the instance to the <code>Healthy</code> state.</p>
    pub fn healthy_threshold(&self) -> i32 {
        self.healthy_threshold
    }
}
impl std::fmt::Debug for HealthCheck {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealthCheck");
        formatter.field("target", &self.target);
        formatter.field("interval", &self.interval);
        formatter.field("timeout", &self.timeout);
        formatter.field("unhealthy_threshold", &self.unhealthy_threshold);
        formatter.field("healthy_threshold", &self.healthy_threshold);
        formatter.finish()
    }
}
/// See [`HealthCheck`](crate::model::HealthCheck)
pub mod health_check {
    /// A builder for [`HealthCheck`](crate::model::HealthCheck)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) interval: std::option::Option<i32>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) unhealthy_threshold: std::option::Option<i32>,
        pub(crate) healthy_threshold: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL. The range of valid ports is one (1) through 65535.</p>
        /// <p>TCP is the default, specified as a TCP: port pair, for example "TCP:5000". In this case, a health check simply attempts to open a TCP connection to the instance on the specified port. Failure to connect within the configured timeout is considered unhealthy.</p>
        /// <p>SSL is also specified as SSL: port pair, for example, SSL:5000.</p>
        /// <p>For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified as a HTTP:port;/;PathToPing; grouping, for example "HTTP:80/weather/us/wa/seattle". In this case, a HTTP GET request is issued to the instance on the given port and path. Any answer other than "200 OK" within the timeout period is considered unhealthy.</p>
        /// <p>The total length of the HTTP ping target must be 1024 16-bit Unicode characters or less.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL. The range of valid ports is one (1) through 65535.</p>
        /// <p>TCP is the default, specified as a TCP: port pair, for example "TCP:5000". In this case, a health check simply attempts to open a TCP connection to the instance on the specified port. Failure to connect within the configured timeout is considered unhealthy.</p>
        /// <p>SSL is also specified as SSL: port pair, for example, SSL:5000.</p>
        /// <p>For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified as a HTTP:port;/;PathToPing; grouping, for example "HTTP:80/weather/us/wa/seattle". In this case, a HTTP GET request is issued to the instance on the given port and path. Any answer other than "200 OK" within the timeout period is considered unhealthy.</p>
        /// <p>The total length of the HTTP ping target must be 1024 16-bit Unicode characters or less.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>The approximate interval, in seconds, between health checks of an individual instance.</p>
        pub fn interval(mut self, input: i32) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>The approximate interval, in seconds, between health checks of an individual instance.</p>
        pub fn set_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.interval = input;
            self
        }
        /// <p>The amount of time, in seconds, during which no response means a failed health check.</p>
        /// <p>This value must be less than the <code>Interval</code> value.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, during which no response means a failed health check.</p>
        /// <p>This value must be less than the <code>Interval</code> value.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The number of consecutive health check failures required before moving the instance to the <code>Unhealthy</code> state.</p>
        pub fn unhealthy_threshold(mut self, input: i32) -> Self {
            self.unhealthy_threshold = Some(input);
            self
        }
        /// <p>The number of consecutive health check failures required before moving the instance to the <code>Unhealthy</code> state.</p>
        pub fn set_unhealthy_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.unhealthy_threshold = input;
            self
        }
        /// <p>The number of consecutive health checks successes required before moving the instance to the <code>Healthy</code> state.</p>
        pub fn healthy_threshold(mut self, input: i32) -> Self {
            self.healthy_threshold = Some(input);
            self
        }
        /// <p>The number of consecutive health checks successes required before moving the instance to the <code>Healthy</code> state.</p>
        pub fn set_healthy_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.healthy_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`HealthCheck`](crate::model::HealthCheck)
        pub fn build(self) -> crate::model::HealthCheck {
            crate::model::HealthCheck {
                target: self.target,
                interval: self.interval.unwrap_or_default(),
                timeout: self.timeout.unwrap_or_default(),
                unhealthy_threshold: self.unhealthy_threshold.unwrap_or_default(),
                healthy_threshold: self.healthy_threshold.unwrap_or_default(),
            }
        }
    }
}
impl HealthCheck {
    /// Creates a new builder-style object to manufacture [`HealthCheck`](crate::model::HealthCheck)
    pub fn builder() -> crate::model::health_check::Builder {
        crate::model::health_check::Builder::default()
    }
}

/// <p>Information about the configuration of an EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackendServerDescription {
    /// <p>The port on which the EC2 instance is listening.</p>
    pub instance_port: i32,
    /// <p>The names of the policies enabled for the EC2 instance.</p>
    pub policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BackendServerDescription {
    /// <p>The port on which the EC2 instance is listening.</p>
    pub fn instance_port(&self) -> i32 {
        self.instance_port
    }
    /// <p>The names of the policies enabled for the EC2 instance.</p>
    pub fn policy_names(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_names.as_deref()
    }
}
impl std::fmt::Debug for BackendServerDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackendServerDescription");
        formatter.field("instance_port", &self.instance_port);
        formatter.field("policy_names", &self.policy_names);
        formatter.finish()
    }
}
/// See [`BackendServerDescription`](crate::model::BackendServerDescription)
pub mod backend_server_description {
    /// A builder for [`BackendServerDescription`](crate::model::BackendServerDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_port: std::option::Option<i32>,
        pub(crate) policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The port on which the EC2 instance is listening.</p>
        pub fn instance_port(mut self, input: i32) -> Self {
            self.instance_port = Some(input);
            self
        }
        /// <p>The port on which the EC2 instance is listening.</p>
        pub fn set_instance_port(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_port = input;
            self
        }
        /// Appends an item to `policy_names`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>The names of the policies enabled for the EC2 instance.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_names.unwrap_or_default();
            v.push(input.into());
            self.policy_names = Some(v);
            self
        }
        /// <p>The names of the policies enabled for the EC2 instance.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_names = input;
            self
        }
        /// Consumes the builder and constructs a [`BackendServerDescription`](crate::model::BackendServerDescription)
        pub fn build(self) -> crate::model::BackendServerDescription {
            crate::model::BackendServerDescription {
                instance_port: self.instance_port.unwrap_or_default(),
                policy_names: self.policy_names,
            }
        }
    }
}
impl BackendServerDescription {
    /// Creates a new builder-style object to manufacture [`BackendServerDescription`](crate::model::BackendServerDescription)
    pub fn builder() -> crate::model::backend_server_description::Builder {
        crate::model::backend_server_description::Builder::default()
    }
}

/// <p>The policies for a load balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Policies {
    /// <p>The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.</p>
    pub app_cookie_stickiness_policies:
        std::option::Option<std::vec::Vec<crate::model::AppCookieStickinessPolicy>>,
    /// <p>The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.</p>
    pub lb_cookie_stickiness_policies:
        std::option::Option<std::vec::Vec<crate::model::LbCookieStickinessPolicy>>,
    /// <p>The policies other than the stickiness policies.</p>
    pub other_policies: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Policies {
    /// <p>The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.</p>
    pub fn app_cookie_stickiness_policies(
        &self,
    ) -> std::option::Option<&[crate::model::AppCookieStickinessPolicy]> {
        self.app_cookie_stickiness_policies.as_deref()
    }
    /// <p>The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.</p>
    pub fn lb_cookie_stickiness_policies(
        &self,
    ) -> std::option::Option<&[crate::model::LbCookieStickinessPolicy]> {
        self.lb_cookie_stickiness_policies.as_deref()
    }
    /// <p>The policies other than the stickiness policies.</p>
    pub fn other_policies(&self) -> std::option::Option<&[std::string::String]> {
        self.other_policies.as_deref()
    }
}
impl std::fmt::Debug for Policies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Policies");
        formatter.field(
            "app_cookie_stickiness_policies",
            &self.app_cookie_stickiness_policies,
        );
        formatter.field(
            "lb_cookie_stickiness_policies",
            &self.lb_cookie_stickiness_policies,
        );
        formatter.field("other_policies", &self.other_policies);
        formatter.finish()
    }
}
/// See [`Policies`](crate::model::Policies)
pub mod policies {
    /// A builder for [`Policies`](crate::model::Policies)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_cookie_stickiness_policies:
            std::option::Option<std::vec::Vec<crate::model::AppCookieStickinessPolicy>>,
        pub(crate) lb_cookie_stickiness_policies:
            std::option::Option<std::vec::Vec<crate::model::LbCookieStickinessPolicy>>,
        pub(crate) other_policies: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `app_cookie_stickiness_policies`.
        ///
        /// To override the contents of this collection use [`set_app_cookie_stickiness_policies`](Self::set_app_cookie_stickiness_policies).
        ///
        /// <p>The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.</p>
        pub fn app_cookie_stickiness_policies(
            mut self,
            input: impl Into<crate::model::AppCookieStickinessPolicy>,
        ) -> Self {
            let mut v = self.app_cookie_stickiness_policies.unwrap_or_default();
            v.push(input.into());
            self.app_cookie_stickiness_policies = Some(v);
            self
        }
        /// <p>The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.</p>
        pub fn set_app_cookie_stickiness_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppCookieStickinessPolicy>>,
        ) -> Self {
            self.app_cookie_stickiness_policies = input;
            self
        }
        /// Appends an item to `lb_cookie_stickiness_policies`.
        ///
        /// To override the contents of this collection use [`set_lb_cookie_stickiness_policies`](Self::set_lb_cookie_stickiness_policies).
        ///
        /// <p>The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.</p>
        pub fn lb_cookie_stickiness_policies(
            mut self,
            input: impl Into<crate::model::LbCookieStickinessPolicy>,
        ) -> Self {
            let mut v = self.lb_cookie_stickiness_policies.unwrap_or_default();
            v.push(input.into());
            self.lb_cookie_stickiness_policies = Some(v);
            self
        }
        /// <p>The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.</p>
        pub fn set_lb_cookie_stickiness_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LbCookieStickinessPolicy>>,
        ) -> Self {
            self.lb_cookie_stickiness_policies = input;
            self
        }
        /// Appends an item to `other_policies`.
        ///
        /// To override the contents of this collection use [`set_other_policies`](Self::set_other_policies).
        ///
        /// <p>The policies other than the stickiness policies.</p>
        pub fn other_policies(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.other_policies.unwrap_or_default();
            v.push(input.into());
            self.other_policies = Some(v);
            self
        }
        /// <p>The policies other than the stickiness policies.</p>
        pub fn set_other_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.other_policies = input;
            self
        }
        /// Consumes the builder and constructs a [`Policies`](crate::model::Policies)
        pub fn build(self) -> crate::model::Policies {
            crate::model::Policies {
                app_cookie_stickiness_policies: self.app_cookie_stickiness_policies,
                lb_cookie_stickiness_policies: self.lb_cookie_stickiness_policies,
                other_policies: self.other_policies,
            }
        }
    }
}
impl Policies {
    /// Creates a new builder-style object to manufacture [`Policies`](crate::model::Policies)
    pub fn builder() -> crate::model::policies::Builder {
        crate::model::policies::Builder::default()
    }
}

/// <p>Information about a policy for duration-based session stickiness.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LbCookieStickinessPolicy {
    /// <p>The name of the policy. This name must be unique within the set of policies for this load balancer.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The time period, in seconds, after which the cookie should be considered stale. If this parameter is not specified, the stickiness session lasts for the duration of the browser session.</p>
    pub cookie_expiration_period: std::option::Option<i64>,
}
impl LbCookieStickinessPolicy {
    /// <p>The name of the policy. This name must be unique within the set of policies for this load balancer.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The time period, in seconds, after which the cookie should be considered stale. If this parameter is not specified, the stickiness session lasts for the duration of the browser session.</p>
    pub fn cookie_expiration_period(&self) -> std::option::Option<i64> {
        self.cookie_expiration_period
    }
}
impl std::fmt::Debug for LbCookieStickinessPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LbCookieStickinessPolicy");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("cookie_expiration_period", &self.cookie_expiration_period);
        formatter.finish()
    }
}
/// See [`LbCookieStickinessPolicy`](crate::model::LbCookieStickinessPolicy)
pub mod lb_cookie_stickiness_policy {
    /// A builder for [`LbCookieStickinessPolicy`](crate::model::LbCookieStickinessPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) cookie_expiration_period: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the policy. This name must be unique within the set of policies for this load balancer.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy. This name must be unique within the set of policies for this load balancer.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The time period, in seconds, after which the cookie should be considered stale. If this parameter is not specified, the stickiness session lasts for the duration of the browser session.</p>
        pub fn cookie_expiration_period(mut self, input: i64) -> Self {
            self.cookie_expiration_period = Some(input);
            self
        }
        /// <p>The time period, in seconds, after which the cookie should be considered stale. If this parameter is not specified, the stickiness session lasts for the duration of the browser session.</p>
        pub fn set_cookie_expiration_period(mut self, input: std::option::Option<i64>) -> Self {
            self.cookie_expiration_period = input;
            self
        }
        /// Consumes the builder and constructs a [`LbCookieStickinessPolicy`](crate::model::LbCookieStickinessPolicy)
        pub fn build(self) -> crate::model::LbCookieStickinessPolicy {
            crate::model::LbCookieStickinessPolicy {
                policy_name: self.policy_name,
                cookie_expiration_period: self.cookie_expiration_period,
            }
        }
    }
}
impl LbCookieStickinessPolicy {
    /// Creates a new builder-style object to manufacture [`LbCookieStickinessPolicy`](crate::model::LbCookieStickinessPolicy)
    pub fn builder() -> crate::model::lb_cookie_stickiness_policy::Builder {
        crate::model::lb_cookie_stickiness_policy::Builder::default()
    }
}

/// <p>Information about a policy for application-controlled session stickiness.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppCookieStickinessPolicy {
    /// <p>The mnemonic name for the policy being created. The name must be unique within a set of policies for this load balancer.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The name of the application cookie used for stickiness.</p>
    pub cookie_name: std::option::Option<std::string::String>,
}
impl AppCookieStickinessPolicy {
    /// <p>The mnemonic name for the policy being created. The name must be unique within a set of policies for this load balancer.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The name of the application cookie used for stickiness.</p>
    pub fn cookie_name(&self) -> std::option::Option<&str> {
        self.cookie_name.as_deref()
    }
}
impl std::fmt::Debug for AppCookieStickinessPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppCookieStickinessPolicy");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("cookie_name", &self.cookie_name);
        formatter.finish()
    }
}
/// See [`AppCookieStickinessPolicy`](crate::model::AppCookieStickinessPolicy)
pub mod app_cookie_stickiness_policy {
    /// A builder for [`AppCookieStickinessPolicy`](crate::model::AppCookieStickinessPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) cookie_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The mnemonic name for the policy being created. The name must be unique within a set of policies for this load balancer.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The mnemonic name for the policy being created. The name must be unique within a set of policies for this load balancer.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The name of the application cookie used for stickiness.</p>
        pub fn cookie_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cookie_name = Some(input.into());
            self
        }
        /// <p>The name of the application cookie used for stickiness.</p>
        pub fn set_cookie_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cookie_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AppCookieStickinessPolicy`](crate::model::AppCookieStickinessPolicy)
        pub fn build(self) -> crate::model::AppCookieStickinessPolicy {
            crate::model::AppCookieStickinessPolicy {
                policy_name: self.policy_name,
                cookie_name: self.cookie_name,
            }
        }
    }
}
impl AppCookieStickinessPolicy {
    /// Creates a new builder-style object to manufacture [`AppCookieStickinessPolicy`](crate::model::AppCookieStickinessPolicy)
    pub fn builder() -> crate::model::app_cookie_stickiness_policy::Builder {
        crate::model::app_cookie_stickiness_policy::Builder::default()
    }
}

/// <p>The policies enabled for a listener.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListenerDescription {
    /// <p>The listener.</p>
    pub listener: std::option::Option<crate::model::Listener>,
    /// <p>The policies. If there are no policies enabled, the list is empty.</p>
    pub policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListenerDescription {
    /// <p>The listener.</p>
    pub fn listener(&self) -> std::option::Option<&crate::model::Listener> {
        self.listener.as_ref()
    }
    /// <p>The policies. If there are no policies enabled, the list is empty.</p>
    pub fn policy_names(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_names.as_deref()
    }
}
impl std::fmt::Debug for ListenerDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListenerDescription");
        formatter.field("listener", &self.listener);
        formatter.field("policy_names", &self.policy_names);
        formatter.finish()
    }
}
/// See [`ListenerDescription`](crate::model::ListenerDescription)
pub mod listener_description {
    /// A builder for [`ListenerDescription`](crate::model::ListenerDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener: std::option::Option<crate::model::Listener>,
        pub(crate) policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The listener.</p>
        pub fn listener(mut self, input: crate::model::Listener) -> Self {
            self.listener = Some(input);
            self
        }
        /// <p>The listener.</p>
        pub fn set_listener(mut self, input: std::option::Option<crate::model::Listener>) -> Self {
            self.listener = input;
            self
        }
        /// Appends an item to `policy_names`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>The policies. If there are no policies enabled, the list is empty.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_names.unwrap_or_default();
            v.push(input.into());
            self.policy_names = Some(v);
            self
        }
        /// <p>The policies. If there are no policies enabled, the list is empty.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ListenerDescription`](crate::model::ListenerDescription)
        pub fn build(self) -> crate::model::ListenerDescription {
            crate::model::ListenerDescription {
                listener: self.listener,
                policy_names: self.policy_names,
            }
        }
    }
}
impl ListenerDescription {
    /// Creates a new builder-style object to manufacture [`ListenerDescription`](crate::model::ListenerDescription)
    pub fn builder() -> crate::model::listener_description::Builder {
        crate::model::listener_description::Builder::default()
    }
}

/// <p>Information about a listener.</p>
/// <p>For information about the protocols and the ports supported by Elastic Load Balancing, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer</a>
/// in the <i>Classic Load Balancers Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Listener {
    /// <p>The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP, or SSL.</p>
    pub protocol: std::option::Option<std::string::String>,
    /// <p>The port on which the load balancer is listening. On EC2-VPC, you can specify any port from the range 1-65535. On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.</p>
    pub load_balancer_port: i32,
    /// <p>The protocol to use for routing traffic to instances: HTTP, HTTPS, TCP, or SSL.</p>
    /// <p>If the front-end protocol is TCP or SSL, the back-end protocol must be TCP or SSL.
    /// If the front-end protocol is HTTP or HTTPS, the back-end protocol must be HTTP or HTTPS.</p>
    /// <p>If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is secure,
    /// (HTTPS or SSL), the listener's <code>InstanceProtocol</code> must also be secure.</p>
    /// <p>If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is HTTP or TCP,
    /// the listener's <code>InstanceProtocol</code> must be HTTP or TCP.</p>
    pub instance_protocol: std::option::Option<std::string::String>,
    /// <p>The port on which the instance is listening.</p>
    pub instance_port: i32,
    /// <p>The Amazon Resource Name (ARN) of the server certificate.</p>
    pub ssl_certificate_id: std::option::Option<std::string::String>,
}
impl Listener {
    /// <p>The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP, or SSL.</p>
    pub fn protocol(&self) -> std::option::Option<&str> {
        self.protocol.as_deref()
    }
    /// <p>The port on which the load balancer is listening. On EC2-VPC, you can specify any port from the range 1-65535. On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.</p>
    pub fn load_balancer_port(&self) -> i32 {
        self.load_balancer_port
    }
    /// <p>The protocol to use for routing traffic to instances: HTTP, HTTPS, TCP, or SSL.</p>
    /// <p>If the front-end protocol is TCP or SSL, the back-end protocol must be TCP or SSL.
    /// If the front-end protocol is HTTP or HTTPS, the back-end protocol must be HTTP or HTTPS.</p>
    /// <p>If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is secure,
    /// (HTTPS or SSL), the listener's <code>InstanceProtocol</code> must also be secure.</p>
    /// <p>If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is HTTP or TCP,
    /// the listener's <code>InstanceProtocol</code> must be HTTP or TCP.</p>
    pub fn instance_protocol(&self) -> std::option::Option<&str> {
        self.instance_protocol.as_deref()
    }
    /// <p>The port on which the instance is listening.</p>
    pub fn instance_port(&self) -> i32 {
        self.instance_port
    }
    /// <p>The Amazon Resource Name (ARN) of the server certificate.</p>
    pub fn ssl_certificate_id(&self) -> std::option::Option<&str> {
        self.ssl_certificate_id.as_deref()
    }
}
impl std::fmt::Debug for Listener {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Listener");
        formatter.field("protocol", &self.protocol);
        formatter.field("load_balancer_port", &self.load_balancer_port);
        formatter.field("instance_protocol", &self.instance_protocol);
        formatter.field("instance_port", &self.instance_port);
        formatter.field("ssl_certificate_id", &self.ssl_certificate_id);
        formatter.finish()
    }
}
/// See [`Listener`](crate::model::Listener)
pub mod listener {
    /// A builder for [`Listener`](crate::model::Listener)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) protocol: std::option::Option<std::string::String>,
        pub(crate) load_balancer_port: std::option::Option<i32>,
        pub(crate) instance_protocol: std::option::Option<std::string::String>,
        pub(crate) instance_port: std::option::Option<i32>,
        pub(crate) ssl_certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP, or SSL.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP, or SSL.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The port on which the load balancer is listening. On EC2-VPC, you can specify any port from the range 1-65535. On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.</p>
        pub fn load_balancer_port(mut self, input: i32) -> Self {
            self.load_balancer_port = Some(input);
            self
        }
        /// <p>The port on which the load balancer is listening. On EC2-VPC, you can specify any port from the range 1-65535. On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.</p>
        pub fn set_load_balancer_port(mut self, input: std::option::Option<i32>) -> Self {
            self.load_balancer_port = input;
            self
        }
        /// <p>The protocol to use for routing traffic to instances: HTTP, HTTPS, TCP, or SSL.</p>
        /// <p>If the front-end protocol is TCP or SSL, the back-end protocol must be TCP or SSL.
        /// If the front-end protocol is HTTP or HTTPS, the back-end protocol must be HTTP or HTTPS.</p>
        /// <p>If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is secure,
        /// (HTTPS or SSL), the listener's <code>InstanceProtocol</code> must also be secure.</p>
        /// <p>If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is HTTP or TCP,
        /// the listener's <code>InstanceProtocol</code> must be HTTP or TCP.</p>
        pub fn instance_protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_protocol = Some(input.into());
            self
        }
        /// <p>The protocol to use for routing traffic to instances: HTTP, HTTPS, TCP, or SSL.</p>
        /// <p>If the front-end protocol is TCP or SSL, the back-end protocol must be TCP or SSL.
        /// If the front-end protocol is HTTP or HTTPS, the back-end protocol must be HTTP or HTTPS.</p>
        /// <p>If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is secure,
        /// (HTTPS or SSL), the listener's <code>InstanceProtocol</code> must also be secure.</p>
        /// <p>If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is HTTP or TCP,
        /// the listener's <code>InstanceProtocol</code> must be HTTP or TCP.</p>
        pub fn set_instance_protocol(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_protocol = input;
            self
        }
        /// <p>The port on which the instance is listening.</p>
        pub fn instance_port(mut self, input: i32) -> Self {
            self.instance_port = Some(input);
            self
        }
        /// <p>The port on which the instance is listening.</p>
        pub fn set_instance_port(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_port = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the server certificate.</p>
        pub fn ssl_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssl_certificate_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the server certificate.</p>
        pub fn set_ssl_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssl_certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Listener`](crate::model::Listener)
        pub fn build(self) -> crate::model::Listener {
            crate::model::Listener {
                protocol: self.protocol,
                load_balancer_port: self.load_balancer_port.unwrap_or_default(),
                instance_protocol: self.instance_protocol,
                instance_port: self.instance_port.unwrap_or_default(),
                ssl_certificate_id: self.ssl_certificate_id,
            }
        }
    }
}
impl Listener {
    /// Creates a new builder-style object to manufacture [`Listener`](crate::model::Listener)
    pub fn builder() -> crate::model::listener::Builder {
        crate::model::listener::Builder::default()
    }
}

/// <p>Information about a policy type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyTypeDescription {
    /// <p>The name of the policy type.</p>
    pub policy_type_name: std::option::Option<std::string::String>,
    /// <p>A description of the policy type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The description of the policy attributes associated with the policies defined by Elastic Load Balancing.</p>
    pub policy_attribute_type_descriptions:
        std::option::Option<std::vec::Vec<crate::model::PolicyAttributeTypeDescription>>,
}
impl PolicyTypeDescription {
    /// <p>The name of the policy type.</p>
    pub fn policy_type_name(&self) -> std::option::Option<&str> {
        self.policy_type_name.as_deref()
    }
    /// <p>A description of the policy type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The description of the policy attributes associated with the policies defined by Elastic Load Balancing.</p>
    pub fn policy_attribute_type_descriptions(
        &self,
    ) -> std::option::Option<&[crate::model::PolicyAttributeTypeDescription]> {
        self.policy_attribute_type_descriptions.as_deref()
    }
}
impl std::fmt::Debug for PolicyTypeDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyTypeDescription");
        formatter.field("policy_type_name", &self.policy_type_name);
        formatter.field("description", &self.description);
        formatter.field(
            "policy_attribute_type_descriptions",
            &self.policy_attribute_type_descriptions,
        );
        formatter.finish()
    }
}
/// See [`PolicyTypeDescription`](crate::model::PolicyTypeDescription)
pub mod policy_type_description {
    /// A builder for [`PolicyTypeDescription`](crate::model::PolicyTypeDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_type_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) policy_attribute_type_descriptions:
            std::option::Option<std::vec::Vec<crate::model::PolicyAttributeTypeDescription>>,
    }
    impl Builder {
        /// <p>The name of the policy type.</p>
        pub fn policy_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_type_name = Some(input.into());
            self
        }
        /// <p>The name of the policy type.</p>
        pub fn set_policy_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_type_name = input;
            self
        }
        /// <p>A description of the policy type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the policy type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `policy_attribute_type_descriptions`.
        ///
        /// To override the contents of this collection use [`set_policy_attribute_type_descriptions`](Self::set_policy_attribute_type_descriptions).
        ///
        /// <p>The description of the policy attributes associated with the policies defined by Elastic Load Balancing.</p>
        pub fn policy_attribute_type_descriptions(
            mut self,
            input: impl Into<crate::model::PolicyAttributeTypeDescription>,
        ) -> Self {
            let mut v = self.policy_attribute_type_descriptions.unwrap_or_default();
            v.push(input.into());
            self.policy_attribute_type_descriptions = Some(v);
            self
        }
        /// <p>The description of the policy attributes associated with the policies defined by Elastic Load Balancing.</p>
        pub fn set_policy_attribute_type_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyAttributeTypeDescription>>,
        ) -> Self {
            self.policy_attribute_type_descriptions = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyTypeDescription`](crate::model::PolicyTypeDescription)
        pub fn build(self) -> crate::model::PolicyTypeDescription {
            crate::model::PolicyTypeDescription {
                policy_type_name: self.policy_type_name,
                description: self.description,
                policy_attribute_type_descriptions: self.policy_attribute_type_descriptions,
            }
        }
    }
}
impl PolicyTypeDescription {
    /// Creates a new builder-style object to manufacture [`PolicyTypeDescription`](crate::model::PolicyTypeDescription)
    pub fn builder() -> crate::model::policy_type_description::Builder {
        crate::model::policy_type_description::Builder::default()
    }
}

/// <p>Information about a policy attribute type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyAttributeTypeDescription {
    /// <p>The name of the attribute.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The type of the attribute. For example, <code>Boolean</code> or <code>Integer</code>.</p>
    pub attribute_type: std::option::Option<std::string::String>,
    /// <p>A description of the attribute.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The default value of the attribute, if applicable.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>The cardinality of the attribute.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li>
    /// <p>ONE(1) : Single value required</p>
    /// </li>
    /// <li>
    /// <p>ZERO_OR_ONE(0..1) : Up to one value is allowed</p>
    /// </li>
    /// <li>
    /// <p>ZERO_OR_MORE(0..*) : Optional. Multiple values are allowed</p>
    /// </li>
    /// <li>
    /// <p>ONE_OR_MORE(1..*0) : Required. Multiple values are allowed</p>
    /// </li>
    /// </ul>
    pub cardinality: std::option::Option<std::string::String>,
}
impl PolicyAttributeTypeDescription {
    /// <p>The name of the attribute.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The type of the attribute. For example, <code>Boolean</code> or <code>Integer</code>.</p>
    pub fn attribute_type(&self) -> std::option::Option<&str> {
        self.attribute_type.as_deref()
    }
    /// <p>A description of the attribute.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The default value of the attribute, if applicable.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>The cardinality of the attribute.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li>
    /// <p>ONE(1) : Single value required</p>
    /// </li>
    /// <li>
    /// <p>ZERO_OR_ONE(0..1) : Up to one value is allowed</p>
    /// </li>
    /// <li>
    /// <p>ZERO_OR_MORE(0..*) : Optional. Multiple values are allowed</p>
    /// </li>
    /// <li>
    /// <p>ONE_OR_MORE(1..*0) : Required. Multiple values are allowed</p>
    /// </li>
    /// </ul>
    pub fn cardinality(&self) -> std::option::Option<&str> {
        self.cardinality.as_deref()
    }
}
impl std::fmt::Debug for PolicyAttributeTypeDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyAttributeTypeDescription");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("attribute_type", &self.attribute_type);
        formatter.field("description", &self.description);
        formatter.field("default_value", &self.default_value);
        formatter.field("cardinality", &self.cardinality);
        formatter.finish()
    }
}
/// See [`PolicyAttributeTypeDescription`](crate::model::PolicyAttributeTypeDescription)
pub mod policy_attribute_type_description {
    /// A builder for [`PolicyAttributeTypeDescription`](crate::model::PolicyAttributeTypeDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) cardinality: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the attribute.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the attribute.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The type of the attribute. For example, <code>Boolean</code> or <code>Integer</code>.</p>
        pub fn attribute_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_type = Some(input.into());
            self
        }
        /// <p>The type of the attribute. For example, <code>Boolean</code> or <code>Integer</code>.</p>
        pub fn set_attribute_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_type = input;
            self
        }
        /// <p>A description of the attribute.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the attribute.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The default value of the attribute, if applicable.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value of the attribute, if applicable.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The cardinality of the attribute.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>ONE(1) : Single value required</p>
        /// </li>
        /// <li>
        /// <p>ZERO_OR_ONE(0..1) : Up to one value is allowed</p>
        /// </li>
        /// <li>
        /// <p>ZERO_OR_MORE(0..*) : Optional. Multiple values are allowed</p>
        /// </li>
        /// <li>
        /// <p>ONE_OR_MORE(1..*0) : Required. Multiple values are allowed</p>
        /// </li>
        /// </ul>
        pub fn cardinality(mut self, input: impl Into<std::string::String>) -> Self {
            self.cardinality = Some(input.into());
            self
        }
        /// <p>The cardinality of the attribute.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>ONE(1) : Single value required</p>
        /// </li>
        /// <li>
        /// <p>ZERO_OR_ONE(0..1) : Up to one value is allowed</p>
        /// </li>
        /// <li>
        /// <p>ZERO_OR_MORE(0..*) : Optional. Multiple values are allowed</p>
        /// </li>
        /// <li>
        /// <p>ONE_OR_MORE(1..*0) : Required. Multiple values are allowed</p>
        /// </li>
        /// </ul>
        pub fn set_cardinality(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cardinality = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyAttributeTypeDescription`](crate::model::PolicyAttributeTypeDescription)
        pub fn build(self) -> crate::model::PolicyAttributeTypeDescription {
            crate::model::PolicyAttributeTypeDescription {
                attribute_name: self.attribute_name,
                attribute_type: self.attribute_type,
                description: self.description,
                default_value: self.default_value,
                cardinality: self.cardinality,
            }
        }
    }
}
impl PolicyAttributeTypeDescription {
    /// Creates a new builder-style object to manufacture [`PolicyAttributeTypeDescription`](crate::model::PolicyAttributeTypeDescription)
    pub fn builder() -> crate::model::policy_attribute_type_description::Builder {
        crate::model::policy_attribute_type_description::Builder::default()
    }
}

/// <p>Information about a policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyDescription {
    /// <p>The name of the policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The name of the policy type.</p>
    pub policy_type_name: std::option::Option<std::string::String>,
    /// <p>The policy attributes.</p>
    pub policy_attribute_descriptions:
        std::option::Option<std::vec::Vec<crate::model::PolicyAttributeDescription>>,
}
impl PolicyDescription {
    /// <p>The name of the policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The name of the policy type.</p>
    pub fn policy_type_name(&self) -> std::option::Option<&str> {
        self.policy_type_name.as_deref()
    }
    /// <p>The policy attributes.</p>
    pub fn policy_attribute_descriptions(
        &self,
    ) -> std::option::Option<&[crate::model::PolicyAttributeDescription]> {
        self.policy_attribute_descriptions.as_deref()
    }
}
impl std::fmt::Debug for PolicyDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyDescription");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_type_name", &self.policy_type_name);
        formatter.field(
            "policy_attribute_descriptions",
            &self.policy_attribute_descriptions,
        );
        formatter.finish()
    }
}
/// See [`PolicyDescription`](crate::model::PolicyDescription)
pub mod policy_description {
    /// A builder for [`PolicyDescription`](crate::model::PolicyDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_type_name: std::option::Option<std::string::String>,
        pub(crate) policy_attribute_descriptions:
            std::option::Option<std::vec::Vec<crate::model::PolicyAttributeDescription>>,
    }
    impl Builder {
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The name of the policy type.</p>
        pub fn policy_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_type_name = Some(input.into());
            self
        }
        /// <p>The name of the policy type.</p>
        pub fn set_policy_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_type_name = input;
            self
        }
        /// Appends an item to `policy_attribute_descriptions`.
        ///
        /// To override the contents of this collection use [`set_policy_attribute_descriptions`](Self::set_policy_attribute_descriptions).
        ///
        /// <p>The policy attributes.</p>
        pub fn policy_attribute_descriptions(
            mut self,
            input: impl Into<crate::model::PolicyAttributeDescription>,
        ) -> Self {
            let mut v = self.policy_attribute_descriptions.unwrap_or_default();
            v.push(input.into());
            self.policy_attribute_descriptions = Some(v);
            self
        }
        /// <p>The policy attributes.</p>
        pub fn set_policy_attribute_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyAttributeDescription>>,
        ) -> Self {
            self.policy_attribute_descriptions = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyDescription`](crate::model::PolicyDescription)
        pub fn build(self) -> crate::model::PolicyDescription {
            crate::model::PolicyDescription {
                policy_name: self.policy_name,
                policy_type_name: self.policy_type_name,
                policy_attribute_descriptions: self.policy_attribute_descriptions,
            }
        }
    }
}
impl PolicyDescription {
    /// Creates a new builder-style object to manufacture [`PolicyDescription`](crate::model::PolicyDescription)
    pub fn builder() -> crate::model::policy_description::Builder {
        crate::model::policy_description::Builder::default()
    }
}

/// <p>Information about a policy attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyAttributeDescription {
    /// <p>The name of the attribute.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The value of the attribute.</p>
    pub attribute_value: std::option::Option<std::string::String>,
}
impl PolicyAttributeDescription {
    /// <p>The name of the attribute.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The value of the attribute.</p>
    pub fn attribute_value(&self) -> std::option::Option<&str> {
        self.attribute_value.as_deref()
    }
}
impl std::fmt::Debug for PolicyAttributeDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyAttributeDescription");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("attribute_value", &self.attribute_value);
        formatter.finish()
    }
}
/// See [`PolicyAttributeDescription`](crate::model::PolicyAttributeDescription)
pub mod policy_attribute_description {
    /// A builder for [`PolicyAttributeDescription`](crate::model::PolicyAttributeDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the attribute.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the attribute.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn attribute_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_value = Some(input.into());
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn set_attribute_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_value = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyAttributeDescription`](crate::model::PolicyAttributeDescription)
        pub fn build(self) -> crate::model::PolicyAttributeDescription {
            crate::model::PolicyAttributeDescription {
                attribute_name: self.attribute_name,
                attribute_value: self.attribute_value,
            }
        }
    }
}
impl PolicyAttributeDescription {
    /// Creates a new builder-style object to manufacture [`PolicyAttributeDescription`](crate::model::PolicyAttributeDescription)
    pub fn builder() -> crate::model::policy_attribute_description::Builder {
        crate::model::policy_attribute_description::Builder::default()
    }
}

/// <p>Information about the state of an EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceState {
    /// <p>The ID of the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The current state of the instance.</p>
    /// <p>Valid values: <code>InService</code> | <code>OutOfService</code> | <code>Unknown</code>
    /// </p>
    pub state: std::option::Option<std::string::String>,
    /// <p>Information about the cause of <code>OutOfService</code> instances.
    /// Specifically, whether the cause is Elastic Load Balancing or the instance.</p>
    /// <p>Valid values: <code>ELB</code> | <code>Instance</code> | <code>N/A</code>
    /// </p>
    pub reason_code: std::option::Option<std::string::String>,
    /// <p>A description of the instance state. This string can contain one or more of the following messages.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>N/A</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>A transient error occurred. Please try again later.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance has failed at least the UnhealthyThreshold number of health checks consecutively.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance has not passed the configured HealthyThreshold number of health checks consecutively.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance registration is still in progress.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance is in the EC2 Availability Zone for which LoadBalancer is not configured to route traffic to.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance is not currently registered with the LoadBalancer.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance deregistration currently in progress.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disable Availability Zone is currently in progress.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance is in pending state.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance is in stopped state.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance is in terminated state.</code>
    /// </p>
    /// </li>
    /// </ul>
    pub description: std::option::Option<std::string::String>,
}
impl InstanceState {
    /// <p>The ID of the instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The current state of the instance.</p>
    /// <p>Valid values: <code>InService</code> | <code>OutOfService</code> | <code>Unknown</code>
    /// </p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>Information about the cause of <code>OutOfService</code> instances.
    /// Specifically, whether the cause is Elastic Load Balancing or the instance.</p>
    /// <p>Valid values: <code>ELB</code> | <code>Instance</code> | <code>N/A</code>
    /// </p>
    pub fn reason_code(&self) -> std::option::Option<&str> {
        self.reason_code.as_deref()
    }
    /// <p>A description of the instance state. This string can contain one or more of the following messages.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>N/A</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>A transient error occurred. Please try again later.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance has failed at least the UnhealthyThreshold number of health checks consecutively.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance has not passed the configured HealthyThreshold number of health checks consecutively.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance registration is still in progress.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance is in the EC2 Availability Zone for which LoadBalancer is not configured to route traffic to.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance is not currently registered with the LoadBalancer.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance deregistration currently in progress.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disable Availability Zone is currently in progress.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance is in pending state.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance is in stopped state.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Instance is in terminated state.</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for InstanceState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceState");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("state", &self.state);
        formatter.field("reason_code", &self.reason_code);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`InstanceState`](crate::model::InstanceState)
pub mod instance_state {
    /// A builder for [`InstanceState`](crate::model::InstanceState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) reason_code: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The current state of the instance.</p>
        /// <p>Valid values: <code>InService</code> | <code>OutOfService</code> | <code>Unknown</code>
        /// </p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The current state of the instance.</p>
        /// <p>Valid values: <code>InService</code> | <code>OutOfService</code> | <code>Unknown</code>
        /// </p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>Information about the cause of <code>OutOfService</code> instances.
        /// Specifically, whether the cause is Elastic Load Balancing or the instance.</p>
        /// <p>Valid values: <code>ELB</code> | <code>Instance</code> | <code>N/A</code>
        /// </p>
        pub fn reason_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason_code = Some(input.into());
            self
        }
        /// <p>Information about the cause of <code>OutOfService</code> instances.
        /// Specifically, whether the cause is Elastic Load Balancing or the instance.</p>
        /// <p>Valid values: <code>ELB</code> | <code>Instance</code> | <code>N/A</code>
        /// </p>
        pub fn set_reason_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason_code = input;
            self
        }
        /// <p>A description of the instance state. This string can contain one or more of the following messages.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>N/A</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>A transient error occurred. Please try again later.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance has failed at least the UnhealthyThreshold number of health checks consecutively.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance has not passed the configured HealthyThreshold number of health checks consecutively.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance registration is still in progress.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance is in the EC2 Availability Zone for which LoadBalancer is not configured to route traffic to.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance is not currently registered with the LoadBalancer.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance deregistration currently in progress.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disable Availability Zone is currently in progress.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance is in pending state.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance is in stopped state.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance is in terminated state.</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the instance state. This string can contain one or more of the following messages.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>N/A</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>A transient error occurred. Please try again later.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance has failed at least the UnhealthyThreshold number of health checks consecutively.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance has not passed the configured HealthyThreshold number of health checks consecutively.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance registration is still in progress.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance is in the EC2 Availability Zone for which LoadBalancer is not configured to route traffic to.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance is not currently registered with the LoadBalancer.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance deregistration currently in progress.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disable Availability Zone is currently in progress.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance is in pending state.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance is in stopped state.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instance is in terminated state.</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceState`](crate::model::InstanceState)
        pub fn build(self) -> crate::model::InstanceState {
            crate::model::InstanceState {
                instance_id: self.instance_id,
                state: self.state,
                reason_code: self.reason_code,
                description: self.description,
            }
        }
    }
}
impl InstanceState {
    /// Creates a new builder-style object to manufacture [`InstanceState`](crate::model::InstanceState)
    pub fn builder() -> crate::model::instance_state::Builder {
        crate::model::instance_state::Builder::default()
    }
}

/// <p>Information about an Elastic Load Balancing resource limit for your AWS account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Limit {
    /// <p>The name of the limit. The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>classic-listeners</p>
    /// </li>
    /// <li>
    /// <p>classic-load-balancers</p>
    /// </li>
    /// <li>
    /// <p>classic-registered-instances</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>The maximum value of the limit.</p>
    pub max: std::option::Option<std::string::String>,
}
impl Limit {
    /// <p>The name of the limit. The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>classic-listeners</p>
    /// </li>
    /// <li>
    /// <p>classic-load-balancers</p>
    /// </li>
    /// <li>
    /// <p>classic-registered-instances</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The maximum value of the limit.</p>
    pub fn max(&self) -> std::option::Option<&str> {
        self.max.as_deref()
    }
}
impl std::fmt::Debug for Limit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Limit");
        formatter.field("name", &self.name);
        formatter.field("max", &self.max);
        formatter.finish()
    }
}
/// See [`Limit`](crate::model::Limit)
pub mod limit {
    /// A builder for [`Limit`](crate::model::Limit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) max: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the limit. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>classic-listeners</p>
        /// </li>
        /// <li>
        /// <p>classic-load-balancers</p>
        /// </li>
        /// <li>
        /// <p>classic-registered-instances</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the limit. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>classic-listeners</p>
        /// </li>
        /// <li>
        /// <p>classic-load-balancers</p>
        /// </li>
        /// <li>
        /// <p>classic-registered-instances</p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The maximum value of the limit.</p>
        pub fn max(mut self, input: impl Into<std::string::String>) -> Self {
            self.max = Some(input.into());
            self
        }
        /// <p>The maximum value of the limit.</p>
        pub fn set_max(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max = input;
            self
        }
        /// Consumes the builder and constructs a [`Limit`](crate::model::Limit)
        pub fn build(self) -> crate::model::Limit {
            crate::model::Limit {
                name: self.name,
                max: self.max,
            }
        }
    }
}
impl Limit {
    /// Creates a new builder-style object to manufacture [`Limit`](crate::model::Limit)
    pub fn builder() -> crate::model::limit::Builder {
        crate::model::limit::Builder::default()
    }
}

/// <p>Information about a policy attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyAttribute {
    /// <p>The name of the attribute.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The value of the attribute.</p>
    pub attribute_value: std::option::Option<std::string::String>,
}
impl PolicyAttribute {
    /// <p>The name of the attribute.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The value of the attribute.</p>
    pub fn attribute_value(&self) -> std::option::Option<&str> {
        self.attribute_value.as_deref()
    }
}
impl std::fmt::Debug for PolicyAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyAttribute");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("attribute_value", &self.attribute_value);
        formatter.finish()
    }
}
/// See [`PolicyAttribute`](crate::model::PolicyAttribute)
pub mod policy_attribute {
    /// A builder for [`PolicyAttribute`](crate::model::PolicyAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the attribute.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the attribute.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn attribute_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_value = Some(input.into());
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn set_attribute_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_value = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyAttribute`](crate::model::PolicyAttribute)
        pub fn build(self) -> crate::model::PolicyAttribute {
            crate::model::PolicyAttribute {
                attribute_name: self.attribute_name,
                attribute_value: self.attribute_value,
            }
        }
    }
}
impl PolicyAttribute {
    /// Creates a new builder-style object to manufacture [`PolicyAttribute`](crate::model::PolicyAttribute)
    pub fn builder() -> crate::model::policy_attribute::Builder {
        crate::model::policy_attribute::Builder::default()
    }
}
