// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddTagsInput`](crate::input::AddTagsInput)
pub mod add_tags_input {
    /// A builder for [`AddTagsInput`](crate::input::AddTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `load_balancer_names`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_names`](Self::set_load_balancer_names).
        ///
        /// <p>The name of the load balancer. You can specify one load balancer only.</p>
        pub fn load_balancer_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.load_balancer_names.unwrap_or_default();
            v.push(input.into());
            self.load_balancer_names = Some(v);
            self
        }
        /// <p>The name of the load balancer. You can specify one load balancer only.</p>
        pub fn set_load_balancer_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.load_balancer_names = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsInput`](crate::input::AddTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::AddTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::AddTagsInput {
                load_balancer_names: self.load_balancer_names,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsInputOperationOutputAlias = crate::operation::AddTags;
#[doc(hidden)]
pub type AddTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsInput {
    /// Consumes the builder and constructs an Operation<[`AddTags`](crate::operation::AddTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_add_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::AddTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "AddTags",
                    "elasticloadbalancing",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
}

/// See [`ApplySecurityGroupsToLoadBalancerInput`](crate::input::ApplySecurityGroupsToLoadBalancerInput)
pub mod apply_security_groups_to_load_balancer_input {
    /// A builder for [`ApplySecurityGroupsToLoadBalancerInput`](crate::input::ApplySecurityGroupsToLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The IDs of the security groups to associate with the load balancer. Note that you cannot specify the name of the security group.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The IDs of the security groups to associate with the load balancer. Note that you cannot specify the name of the security group.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplySecurityGroupsToLoadBalancerInput`](crate::input::ApplySecurityGroupsToLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ApplySecurityGroupsToLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ApplySecurityGroupsToLoadBalancerInput {
                load_balancer_name: self.load_balancer_name,
                security_groups: self.security_groups,
            })
        }
    }
}
#[doc(hidden)]
pub type ApplySecurityGroupsToLoadBalancerInputOperationOutputAlias =
    crate::operation::ApplySecurityGroupsToLoadBalancer;
#[doc(hidden)]
pub type ApplySecurityGroupsToLoadBalancerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ApplySecurityGroupsToLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`ApplySecurityGroupsToLoadBalancer`](crate::operation::ApplySecurityGroupsToLoadBalancer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ApplySecurityGroupsToLoadBalancer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ApplySecurityGroupsToLoadBalancerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ApplySecurityGroupsToLoadBalancerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ApplySecurityGroupsToLoadBalancerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_apply_security_groups_to_load_balancer(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ApplySecurityGroupsToLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ApplySecurityGroupsToLoadBalancer",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ApplySecurityGroupsToLoadBalancerInput`](crate::input::ApplySecurityGroupsToLoadBalancerInput)
    pub fn builder() -> crate::input::apply_security_groups_to_load_balancer_input::Builder {
        crate::input::apply_security_groups_to_load_balancer_input::Builder::default()
    }
}

/// See [`AttachLoadBalancerToSubnetsInput`](crate::input::AttachLoadBalancerToSubnetsInput)
pub mod attach_load_balancer_to_subnets_input {
    /// A builder for [`AttachLoadBalancerToSubnetsInput`](crate::input::AttachLoadBalancerToSubnetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the subnets to add. You can add only one subnet per Availability Zone.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The IDs of the subnets to add. You can add only one subnet per Availability Zone.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachLoadBalancerToSubnetsInput`](crate::input::AttachLoadBalancerToSubnetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachLoadBalancerToSubnetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachLoadBalancerToSubnetsInput {
                load_balancer_name: self.load_balancer_name,
                subnets: self.subnets,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachLoadBalancerToSubnetsInputOperationOutputAlias =
    crate::operation::AttachLoadBalancerToSubnets;
#[doc(hidden)]
pub type AttachLoadBalancerToSubnetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AttachLoadBalancerToSubnetsInput {
    /// Consumes the builder and constructs an Operation<[`AttachLoadBalancerToSubnets`](crate::operation::AttachLoadBalancerToSubnets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachLoadBalancerToSubnets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AttachLoadBalancerToSubnetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AttachLoadBalancerToSubnetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AttachLoadBalancerToSubnetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_attach_load_balancer_to_subnets(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachLoadBalancerToSubnets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachLoadBalancerToSubnets",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AttachLoadBalancerToSubnetsInput`](crate::input::AttachLoadBalancerToSubnetsInput)
    pub fn builder() -> crate::input::attach_load_balancer_to_subnets_input::Builder {
        crate::input::attach_load_balancer_to_subnets_input::Builder::default()
    }
}

/// See [`ConfigureHealthCheckInput`](crate::input::ConfigureHealthCheckInput)
pub mod configure_health_check_input {
    /// A builder for [`ConfigureHealthCheckInput`](crate::input::ConfigureHealthCheckInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) health_check: std::option::Option<crate::model::HealthCheck>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The configuration information.</p>
        pub fn health_check(mut self, input: crate::model::HealthCheck) -> Self {
            self.health_check = Some(input);
            self
        }
        /// <p>The configuration information.</p>
        pub fn set_health_check(
            mut self,
            input: std::option::Option<crate::model::HealthCheck>,
        ) -> Self {
            self.health_check = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigureHealthCheckInput`](crate::input::ConfigureHealthCheckInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConfigureHealthCheckInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConfigureHealthCheckInput {
                load_balancer_name: self.load_balancer_name,
                health_check: self.health_check,
            })
        }
    }
}
#[doc(hidden)]
pub type ConfigureHealthCheckInputOperationOutputAlias = crate::operation::ConfigureHealthCheck;
#[doc(hidden)]
pub type ConfigureHealthCheckInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ConfigureHealthCheckInput {
    /// Consumes the builder and constructs an Operation<[`ConfigureHealthCheck`](crate::operation::ConfigureHealthCheck)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConfigureHealthCheck,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ConfigureHealthCheckInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ConfigureHealthCheckInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ConfigureHealthCheckInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_configure_health_check(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConfigureHealthCheck::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConfigureHealthCheck",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ConfigureHealthCheckInput`](crate::input::ConfigureHealthCheckInput)
    pub fn builder() -> crate::input::configure_health_check_input::Builder {
        crate::input::configure_health_check_input::Builder::default()
    }
}

/// See [`CreateAppCookieStickinessPolicyInput`](crate::input::CreateAppCookieStickinessPolicyInput)
pub mod create_app_cookie_stickiness_policy_input {
    /// A builder for [`CreateAppCookieStickinessPolicyInput`](crate::input::CreateAppCookieStickinessPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) cookie_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The name of the application cookie used for stickiness.</p>
        pub fn cookie_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cookie_name = Some(input.into());
            self
        }
        /// <p>The name of the application cookie used for stickiness.</p>
        pub fn set_cookie_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cookie_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppCookieStickinessPolicyInput`](crate::input::CreateAppCookieStickinessPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAppCookieStickinessPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAppCookieStickinessPolicyInput {
                load_balancer_name: self.load_balancer_name,
                policy_name: self.policy_name,
                cookie_name: self.cookie_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAppCookieStickinessPolicyInputOperationOutputAlias =
    crate::operation::CreateAppCookieStickinessPolicy;
#[doc(hidden)]
pub type CreateAppCookieStickinessPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAppCookieStickinessPolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreateAppCookieStickinessPolicy`](crate::operation::CreateAppCookieStickinessPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAppCookieStickinessPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAppCookieStickinessPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAppCookieStickinessPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAppCookieStickinessPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_app_cookie_stickiness_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAppCookieStickinessPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAppCookieStickinessPolicy",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAppCookieStickinessPolicyInput`](crate::input::CreateAppCookieStickinessPolicyInput)
    pub fn builder() -> crate::input::create_app_cookie_stickiness_policy_input::Builder {
        crate::input::create_app_cookie_stickiness_policy_input::Builder::default()
    }
}

/// See [`CreateLbCookieStickinessPolicyInput`](crate::input::CreateLbCookieStickinessPolicyInput)
pub mod create_lb_cookie_stickiness_policy_input {
    /// A builder for [`CreateLbCookieStickinessPolicyInput`](crate::input::CreateLbCookieStickinessPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) cookie_expiration_period: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The time period, in seconds, after which the cookie should be considered stale. If you do not specify this parameter, the default value is 0, which indicates that the sticky session should last for the duration of the browser session.</p>
        pub fn cookie_expiration_period(mut self, input: i64) -> Self {
            self.cookie_expiration_period = Some(input);
            self
        }
        /// <p>The time period, in seconds, after which the cookie should be considered stale. If you do not specify this parameter, the default value is 0, which indicates that the sticky session should last for the duration of the browser session.</p>
        pub fn set_cookie_expiration_period(mut self, input: std::option::Option<i64>) -> Self {
            self.cookie_expiration_period = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLbCookieStickinessPolicyInput`](crate::input::CreateLbCookieStickinessPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLbCookieStickinessPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLbCookieStickinessPolicyInput {
                load_balancer_name: self.load_balancer_name,
                policy_name: self.policy_name,
                cookie_expiration_period: self.cookie_expiration_period,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLbCookieStickinessPolicyInputOperationOutputAlias =
    crate::operation::CreateLBCookieStickinessPolicy;
#[doc(hidden)]
pub type CreateLbCookieStickinessPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLbCookieStickinessPolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreateLBCookieStickinessPolicy`](crate::operation::CreateLBCookieStickinessPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLBCookieStickinessPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLbCookieStickinessPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLbCookieStickinessPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLbCookieStickinessPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_lb_cookie_stickiness_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLBCookieStickinessPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLBCookieStickinessPolicy",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLbCookieStickinessPolicyInput`](crate::input::CreateLbCookieStickinessPolicyInput)
    pub fn builder() -> crate::input::create_lb_cookie_stickiness_policy_input::Builder {
        crate::input::create_lb_cookie_stickiness_policy_input::Builder::default()
    }
}

/// See [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
pub mod create_load_balancer_input {
    /// A builder for [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) scheme: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        /// <p>This name must be unique within your set of load balancers for the region, must have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        /// <p>This name must be unique within your set of load balancers for the region, must have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `listeners`.
        ///
        /// To override the contents of this collection use [`set_listeners`](Self::set_listeners).
        ///
        /// <p>The listeners.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn listeners(mut self, input: impl Into<crate::model::Listener>) -> Self {
            let mut v = self.listeners.unwrap_or_default();
            v.push(input.into());
            self.listeners = Some(v);
            self
        }
        /// <p>The listeners.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn set_listeners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Listener>>,
        ) -> Self {
            self.listeners = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>One or more Availability Zones from the same region as the load balancer.</p>
        /// <p>You must specify at least one Availability Zone.</p>
        /// <p>You can add more Availability Zones after you create the load balancer using
        /// <a>EnableAvailabilityZonesForLoadBalancer</a>.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>One or more Availability Zones from the same region as the load balancer.</p>
        /// <p>You must specify at least one Availability Zone.</p>
        /// <p>You can add more Availability Zones after you create the load balancer using
        /// <a>EnableAvailabilityZonesForLoadBalancer</a>.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the subnets in your VPC to attach to the load balancer.
        /// Specify one subnet per Availability Zone specified in <code>AvailabilityZones</code>.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The IDs of the subnets in your VPC to attach to the load balancer.
        /// Specify one subnet per Availability Zone specified in <code>AvailabilityZones</code>.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The IDs of the security groups to assign to the load balancer.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The IDs of the security groups to assign to the load balancer.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The type of a load balancer. Valid only for load balancers in a VPC.</p>          
        /// <p>By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that resolves to public IP addresses.
        /// For more information about Internet-facing and Internal load balancers, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme">Load Balancer Scheme</a>
        /// in the <i>Elastic Load Balancing User Guide</i>.</p>
        /// <p>Specify <code>internal</code> to create a load balancer with a DNS name that resolves to private IP addresses.</p>
        pub fn scheme(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheme = Some(input.into());
            self
        }
        /// <p>The type of a load balancer. Valid only for load balancers in a VPC.</p>          
        /// <p>By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that resolves to public IP addresses.
        /// For more information about Internet-facing and Internal load balancers, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme">Load Balancer Scheme</a>
        /// in the <i>Elastic Load Balancing User Guide</i>.</p>
        /// <p>Specify <code>internal</code> to create a load balancer with a DNS name that resolves to private IP addresses.</p>
        pub fn set_scheme(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scheme = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to assign to the load balancer.</p>
        /// <p>For more information about tagging your load balancer, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic Load Balancer</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to assign to the load balancer.</p>
        /// <p>For more information about tagging your load balancer, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic Load Balancer</a>
        /// in the <i>Classic Load Balancers Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLoadBalancerInput {
                load_balancer_name: self.load_balancer_name,
                listeners: self.listeners,
                availability_zones: self.availability_zones,
                subnets: self.subnets,
                security_groups: self.security_groups,
                scheme: self.scheme,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLoadBalancerInputOperationOutputAlias = crate::operation::CreateLoadBalancer;
#[doc(hidden)]
pub type CreateLoadBalancerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`CreateLoadBalancer`](crate::operation::CreateLoadBalancer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLoadBalancer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLoadBalancerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLoadBalancerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLoadBalancerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_load_balancer(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLoadBalancer",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
    pub fn builder() -> crate::input::create_load_balancer_input::Builder {
        crate::input::create_load_balancer_input::Builder::default()
    }
}

/// See [`CreateLoadBalancerListenersInput`](crate::input::CreateLoadBalancerListenersInput)
pub mod create_load_balancer_listeners_input {
    /// A builder for [`CreateLoadBalancerListenersInput`](crate::input::CreateLoadBalancerListenersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `listeners`.
        ///
        /// To override the contents of this collection use [`set_listeners`](Self::set_listeners).
        ///
        /// <p>The listeners.</p>
        pub fn listeners(mut self, input: impl Into<crate::model::Listener>) -> Self {
            let mut v = self.listeners.unwrap_or_default();
            v.push(input.into());
            self.listeners = Some(v);
            self
        }
        /// <p>The listeners.</p>
        pub fn set_listeners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Listener>>,
        ) -> Self {
            self.listeners = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLoadBalancerListenersInput`](crate::input::CreateLoadBalancerListenersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLoadBalancerListenersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLoadBalancerListenersInput {
                load_balancer_name: self.load_balancer_name,
                listeners: self.listeners,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLoadBalancerListenersInputOperationOutputAlias =
    crate::operation::CreateLoadBalancerListeners;
#[doc(hidden)]
pub type CreateLoadBalancerListenersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLoadBalancerListenersInput {
    /// Consumes the builder and constructs an Operation<[`CreateLoadBalancerListeners`](crate::operation::CreateLoadBalancerListeners)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLoadBalancerListeners,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLoadBalancerListenersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLoadBalancerListenersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLoadBalancerListenersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_load_balancer_listeners(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLoadBalancerListeners::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLoadBalancerListeners",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLoadBalancerListenersInput`](crate::input::CreateLoadBalancerListenersInput)
    pub fn builder() -> crate::input::create_load_balancer_listeners_input::Builder {
        crate::input::create_load_balancer_listeners_input::Builder::default()
    }
}

/// See [`CreateLoadBalancerPolicyInput`](crate::input::CreateLoadBalancerPolicyInput)
pub mod create_load_balancer_policy_input {
    /// A builder for [`CreateLoadBalancerPolicyInput`](crate::input::CreateLoadBalancerPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_type_name: std::option::Option<std::string::String>,
        pub(crate) policy_attributes:
            std::option::Option<std::vec::Vec<crate::model::PolicyAttribute>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The name of the load balancer policy to be created. This name must be unique within the set of policies for this load balancer.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer policy to be created. This name must be unique within the set of policies for this load balancer.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The name of the base policy type.
        /// To get the list of policy types, use <a>DescribeLoadBalancerPolicyTypes</a>.</p>
        pub fn policy_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_type_name = Some(input.into());
            self
        }
        /// <p>The name of the base policy type.
        /// To get the list of policy types, use <a>DescribeLoadBalancerPolicyTypes</a>.</p>
        pub fn set_policy_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_type_name = input;
            self
        }
        /// Appends an item to `policy_attributes`.
        ///
        /// To override the contents of this collection use [`set_policy_attributes`](Self::set_policy_attributes).
        ///
        /// <p>The policy attributes.</p>
        pub fn policy_attributes(
            mut self,
            input: impl Into<crate::model::PolicyAttribute>,
        ) -> Self {
            let mut v = self.policy_attributes.unwrap_or_default();
            v.push(input.into());
            self.policy_attributes = Some(v);
            self
        }
        /// <p>The policy attributes.</p>
        pub fn set_policy_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyAttribute>>,
        ) -> Self {
            self.policy_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLoadBalancerPolicyInput`](crate::input::CreateLoadBalancerPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLoadBalancerPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLoadBalancerPolicyInput {
                load_balancer_name: self.load_balancer_name,
                policy_name: self.policy_name,
                policy_type_name: self.policy_type_name,
                policy_attributes: self.policy_attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLoadBalancerPolicyInputOperationOutputAlias =
    crate::operation::CreateLoadBalancerPolicy;
#[doc(hidden)]
pub type CreateLoadBalancerPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLoadBalancerPolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreateLoadBalancerPolicy`](crate::operation::CreateLoadBalancerPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLoadBalancerPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLoadBalancerPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLoadBalancerPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLoadBalancerPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_load_balancer_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLoadBalancerPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLoadBalancerPolicy",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLoadBalancerPolicyInput`](crate::input::CreateLoadBalancerPolicyInput)
    pub fn builder() -> crate::input::create_load_balancer_policy_input::Builder {
        crate::input::create_load_balancer_policy_input::Builder::default()
    }
}

/// See [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
pub mod delete_load_balancer_input {
    /// A builder for [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLoadBalancerInput {
                load_balancer_name: self.load_balancer_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLoadBalancerInputOperationOutputAlias = crate::operation::DeleteLoadBalancer;
#[doc(hidden)]
pub type DeleteLoadBalancerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLoadBalancer`](crate::operation::DeleteLoadBalancer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLoadBalancer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLoadBalancerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLoadBalancerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLoadBalancerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_load_balancer(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLoadBalancer",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
    pub fn builder() -> crate::input::delete_load_balancer_input::Builder {
        crate::input::delete_load_balancer_input::Builder::default()
    }
}

/// See [`DeleteLoadBalancerListenersInput`](crate::input::DeleteLoadBalancerListenersInput)
pub mod delete_load_balancer_listeners_input {
    /// A builder for [`DeleteLoadBalancerListenersInput`](crate::input::DeleteLoadBalancerListenersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) load_balancer_ports: std::option::Option<std::vec::Vec<i32>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `load_balancer_ports`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_ports`](Self::set_load_balancer_ports).
        ///
        /// <p>The client port numbers of the listeners.</p>
        pub fn load_balancer_ports(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.load_balancer_ports.unwrap_or_default();
            v.push(input.into());
            self.load_balancer_ports = Some(v);
            self
        }
        /// <p>The client port numbers of the listeners.</p>
        pub fn set_load_balancer_ports(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.load_balancer_ports = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLoadBalancerListenersInput`](crate::input::DeleteLoadBalancerListenersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLoadBalancerListenersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLoadBalancerListenersInput {
                load_balancer_name: self.load_balancer_name,
                load_balancer_ports: self.load_balancer_ports,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLoadBalancerListenersInputOperationOutputAlias =
    crate::operation::DeleteLoadBalancerListeners;
#[doc(hidden)]
pub type DeleteLoadBalancerListenersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLoadBalancerListenersInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLoadBalancerListeners`](crate::operation::DeleteLoadBalancerListeners)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLoadBalancerListeners,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLoadBalancerListenersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLoadBalancerListenersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLoadBalancerListenersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_load_balancer_listeners(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLoadBalancerListeners::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLoadBalancerListeners",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLoadBalancerListenersInput`](crate::input::DeleteLoadBalancerListenersInput)
    pub fn builder() -> crate::input::delete_load_balancer_listeners_input::Builder {
        crate::input::delete_load_balancer_listeners_input::Builder::default()
    }
}

/// See [`DeleteLoadBalancerPolicyInput`](crate::input::DeleteLoadBalancerPolicyInput)
pub mod delete_load_balancer_policy_input {
    /// A builder for [`DeleteLoadBalancerPolicyInput`](crate::input::DeleteLoadBalancerPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLoadBalancerPolicyInput`](crate::input::DeleteLoadBalancerPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLoadBalancerPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLoadBalancerPolicyInput {
                load_balancer_name: self.load_balancer_name,
                policy_name: self.policy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLoadBalancerPolicyInputOperationOutputAlias =
    crate::operation::DeleteLoadBalancerPolicy;
#[doc(hidden)]
pub type DeleteLoadBalancerPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLoadBalancerPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLoadBalancerPolicy`](crate::operation::DeleteLoadBalancerPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLoadBalancerPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLoadBalancerPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLoadBalancerPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLoadBalancerPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_load_balancer_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLoadBalancerPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLoadBalancerPolicy",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLoadBalancerPolicyInput`](crate::input::DeleteLoadBalancerPolicyInput)
    pub fn builder() -> crate::input::delete_load_balancer_policy_input::Builder {
        crate::input::delete_load_balancer_policy_input::Builder::default()
    }
}

/// See [`DeregisterInstancesFromLoadBalancerInput`](crate::input::DeregisterInstancesFromLoadBalancerInput)
pub mod deregister_instances_from_load_balancer_input {
    /// A builder for [`DeregisterInstancesFromLoadBalancerInput`](crate::input::DeregisterInstancesFromLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>The IDs of the instances.</p>
        pub fn instances(mut self, input: impl Into<crate::model::Instance>) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input.into());
            self.instances = Some(v);
            self
        }
        /// <p>The IDs of the instances.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterInstancesFromLoadBalancerInput`](crate::input::DeregisterInstancesFromLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterInstancesFromLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterInstancesFromLoadBalancerInput {
                load_balancer_name: self.load_balancer_name,
                instances: self.instances,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterInstancesFromLoadBalancerInputOperationOutputAlias =
    crate::operation::DeregisterInstancesFromLoadBalancer;
#[doc(hidden)]
pub type DeregisterInstancesFromLoadBalancerInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeregisterInstancesFromLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterInstancesFromLoadBalancer`](crate::operation::DeregisterInstancesFromLoadBalancer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterInstancesFromLoadBalancer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterInstancesFromLoadBalancerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterInstancesFromLoadBalancerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterInstancesFromLoadBalancerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_instances_from_load_balancer(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterInstancesFromLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterInstancesFromLoadBalancer",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterInstancesFromLoadBalancerInput`](crate::input::DeregisterInstancesFromLoadBalancerInput)
    pub fn builder() -> crate::input::deregister_instances_from_load_balancer_input::Builder {
        crate::input::deregister_instances_from_load_balancer_input::Builder::default()
    }
}

/// See [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
pub mod describe_account_limits_input {
    /// A builder for [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of results to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountLimitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountLimitsInput {
                marker: self.marker,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountLimitsInputOperationOutputAlias = crate::operation::DescribeAccountLimits;
#[doc(hidden)]
pub type DescribeAccountLimitsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAccountLimitsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountLimits`](crate::operation::DescribeAccountLimits)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountLimits,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccountLimitsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccountLimitsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccountLimitsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_account_limits(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountLimits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountLimits",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    pub fn builder() -> crate::input::describe_account_limits_input::Builder {
        crate::input::describe_account_limits_input::Builder::default()
    }
}

/// See [`DescribeInstanceHealthInput`](crate::input::DescribeInstanceHealthInput)
pub mod describe_instance_health_input {
    /// A builder for [`DescribeInstanceHealthInput`](crate::input::DescribeInstanceHealthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>The IDs of the instances.</p>
        pub fn instances(mut self, input: impl Into<crate::model::Instance>) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input.into());
            self.instances = Some(v);
            self
        }
        /// <p>The IDs of the instances.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstanceHealthInput`](crate::input::DescribeInstanceHealthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstanceHealthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInstanceHealthInput {
                load_balancer_name: self.load_balancer_name,
                instances: self.instances,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInstanceHealthInputOperationOutputAlias = crate::operation::DescribeInstanceHealth;
#[doc(hidden)]
pub type DescribeInstanceHealthInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeInstanceHealthInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstanceHealth`](crate::operation::DescribeInstanceHealth)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstanceHealth,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInstanceHealthInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInstanceHealthInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInstanceHealthInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_instance_health(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstanceHealth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstanceHealth",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstanceHealthInput`](crate::input::DescribeInstanceHealthInput)
    pub fn builder() -> crate::input::describe_instance_health_input::Builder {
        crate::input::describe_instance_health_input::Builder::default()
    }
}

/// See [`DescribeLoadBalancerAttributesInput`](crate::input::DescribeLoadBalancerAttributesInput)
pub mod describe_load_balancer_attributes_input {
    /// A builder for [`DescribeLoadBalancerAttributesInput`](crate::input::DescribeLoadBalancerAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoadBalancerAttributesInput`](crate::input::DescribeLoadBalancerAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLoadBalancerAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLoadBalancerAttributesInput {
                load_balancer_name: self.load_balancer_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLoadBalancerAttributesInputOperationOutputAlias =
    crate::operation::DescribeLoadBalancerAttributes;
#[doc(hidden)]
pub type DescribeLoadBalancerAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLoadBalancerAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLoadBalancerAttributes`](crate::operation::DescribeLoadBalancerAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLoadBalancerAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLoadBalancerAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLoadBalancerAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLoadBalancerAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_load_balancer_attributes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLoadBalancerAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLoadBalancerAttributes",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancerAttributesInput`](crate::input::DescribeLoadBalancerAttributesInput)
    pub fn builder() -> crate::input::describe_load_balancer_attributes_input::Builder {
        crate::input::describe_load_balancer_attributes_input::Builder::default()
    }
}

/// See [`DescribeLoadBalancerPoliciesInput`](crate::input::DescribeLoadBalancerPoliciesInput)
pub mod describe_load_balancer_policies_input {
    /// A builder for [`DescribeLoadBalancerPoliciesInput`](crate::input::DescribeLoadBalancerPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `policy_names`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>The names of the policies.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_names.unwrap_or_default();
            v.push(input.into());
            self.policy_names = Some(v);
            self
        }
        /// <p>The names of the policies.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoadBalancerPoliciesInput`](crate::input::DescribeLoadBalancerPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLoadBalancerPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLoadBalancerPoliciesInput {
                load_balancer_name: self.load_balancer_name,
                policy_names: self.policy_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLoadBalancerPoliciesInputOperationOutputAlias =
    crate::operation::DescribeLoadBalancerPolicies;
#[doc(hidden)]
pub type DescribeLoadBalancerPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLoadBalancerPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLoadBalancerPolicies`](crate::operation::DescribeLoadBalancerPolicies)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLoadBalancerPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLoadBalancerPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLoadBalancerPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLoadBalancerPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_load_balancer_policies(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLoadBalancerPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLoadBalancerPolicies",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancerPoliciesInput`](crate::input::DescribeLoadBalancerPoliciesInput)
    pub fn builder() -> crate::input::describe_load_balancer_policies_input::Builder {
        crate::input::describe_load_balancer_policies_input::Builder::default()
    }
}

/// See [`DescribeLoadBalancerPolicyTypesInput`](crate::input::DescribeLoadBalancerPolicyTypesInput)
pub mod describe_load_balancer_policy_types_input {
    /// A builder for [`DescribeLoadBalancerPolicyTypesInput`](crate::input::DescribeLoadBalancerPolicyTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_type_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `policy_type_names`.
        ///
        /// To override the contents of this collection use [`set_policy_type_names`](Self::set_policy_type_names).
        ///
        /// <p>The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load Balancing.</p>
        pub fn policy_type_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_type_names.unwrap_or_default();
            v.push(input.into());
            self.policy_type_names = Some(v);
            self
        }
        /// <p>The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load Balancing.</p>
        pub fn set_policy_type_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_type_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoadBalancerPolicyTypesInput`](crate::input::DescribeLoadBalancerPolicyTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLoadBalancerPolicyTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLoadBalancerPolicyTypesInput {
                policy_type_names: self.policy_type_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLoadBalancerPolicyTypesInputOperationOutputAlias =
    crate::operation::DescribeLoadBalancerPolicyTypes;
#[doc(hidden)]
pub type DescribeLoadBalancerPolicyTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLoadBalancerPolicyTypesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLoadBalancerPolicyTypes`](crate::operation::DescribeLoadBalancerPolicyTypes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLoadBalancerPolicyTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLoadBalancerPolicyTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLoadBalancerPolicyTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLoadBalancerPolicyTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_load_balancer_policy_types(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLoadBalancerPolicyTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLoadBalancerPolicyTypes",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancerPolicyTypesInput`](crate::input::DescribeLoadBalancerPolicyTypesInput)
    pub fn builder() -> crate::input::describe_load_balancer_policy_types_input::Builder {
        crate::input::describe_load_balancer_policy_types_input::Builder::default()
    }
}

/// See [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
pub mod describe_load_balancers_input {
    /// A builder for [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `load_balancer_names`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_names`](Self::set_load_balancer_names).
        ///
        /// <p>The names of the load balancers.</p>
        pub fn load_balancer_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.load_balancer_names.unwrap_or_default();
            v.push(input.into());
            self.load_balancer_names = Some(v);
            self
        }
        /// <p>The names of the load balancers.</p>
        pub fn set_load_balancer_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.load_balancer_names = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of results to return with this call (a number from 1 to 400). The default is 400.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of results to return with this call (a number from 1 to 400). The default is 400.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLoadBalancersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLoadBalancersInput {
                load_balancer_names: self.load_balancer_names,
                marker: self.marker,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLoadBalancersInputOperationOutputAlias = crate::operation::DescribeLoadBalancers;
#[doc(hidden)]
pub type DescribeLoadBalancersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLoadBalancersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLoadBalancers`](crate::operation::DescribeLoadBalancers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLoadBalancers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLoadBalancersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLoadBalancersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLoadBalancersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_load_balancers(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLoadBalancers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLoadBalancers",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
    pub fn builder() -> crate::input::describe_load_balancers_input::Builder {
        crate::input::describe_load_balancers_input::Builder::default()
    }
}

/// See [`DescribeTagsInput`](crate::input::DescribeTagsInput)
pub mod describe_tags_input {
    /// A builder for [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `load_balancer_names`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_names`](Self::set_load_balancer_names).
        ///
        /// <p>The names of the load balancers.</p>
        pub fn load_balancer_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.load_balancer_names.unwrap_or_default();
            v.push(input.into());
            self.load_balancer_names = Some(v);
            self
        }
        /// <p>The names of the load balancers.</p>
        pub fn set_load_balancer_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.load_balancer_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsInput`](crate::input::DescribeTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTagsInput {
                load_balancer_names: self.load_balancer_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTagsInputOperationOutputAlias = crate::operation::DescribeTags;
#[doc(hidden)]
pub type DescribeTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTagsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTags`](crate::operation::DescribeTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTags",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
}

/// See [`DetachLoadBalancerFromSubnetsInput`](crate::input::DetachLoadBalancerFromSubnetsInput)
pub mod detach_load_balancer_from_subnets_input {
    /// A builder for [`DetachLoadBalancerFromSubnetsInput`](crate::input::DetachLoadBalancerFromSubnetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the subnets.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The IDs of the subnets.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachLoadBalancerFromSubnetsInput`](crate::input::DetachLoadBalancerFromSubnetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachLoadBalancerFromSubnetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachLoadBalancerFromSubnetsInput {
                load_balancer_name: self.load_balancer_name,
                subnets: self.subnets,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachLoadBalancerFromSubnetsInputOperationOutputAlias =
    crate::operation::DetachLoadBalancerFromSubnets;
#[doc(hidden)]
pub type DetachLoadBalancerFromSubnetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetachLoadBalancerFromSubnetsInput {
    /// Consumes the builder and constructs an Operation<[`DetachLoadBalancerFromSubnets`](crate::operation::DetachLoadBalancerFromSubnets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachLoadBalancerFromSubnets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetachLoadBalancerFromSubnetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetachLoadBalancerFromSubnetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetachLoadBalancerFromSubnetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detach_load_balancer_from_subnets(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachLoadBalancerFromSubnets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachLoadBalancerFromSubnets",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetachLoadBalancerFromSubnetsInput`](crate::input::DetachLoadBalancerFromSubnetsInput)
    pub fn builder() -> crate::input::detach_load_balancer_from_subnets_input::Builder {
        crate::input::detach_load_balancer_from_subnets_input::Builder::default()
    }
}

/// See [`DisableAvailabilityZonesForLoadBalancerInput`](crate::input::DisableAvailabilityZonesForLoadBalancerInput)
pub mod disable_availability_zones_for_load_balancer_input {
    /// A builder for [`DisableAvailabilityZonesForLoadBalancerInput`](crate::input::DisableAvailabilityZonesForLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zones.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>The Availability Zones.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableAvailabilityZonesForLoadBalancerInput`](crate::input::DisableAvailabilityZonesForLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableAvailabilityZonesForLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableAvailabilityZonesForLoadBalancerInput {
                load_balancer_name: self.load_balancer_name,
                availability_zones: self.availability_zones,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableAvailabilityZonesForLoadBalancerInputOperationOutputAlias =
    crate::operation::DisableAvailabilityZonesForLoadBalancer;
#[doc(hidden)]
pub type DisableAvailabilityZonesForLoadBalancerInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DisableAvailabilityZonesForLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`DisableAvailabilityZonesForLoadBalancer`](crate::operation::DisableAvailabilityZonesForLoadBalancer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableAvailabilityZonesForLoadBalancer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableAvailabilityZonesForLoadBalancerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableAvailabilityZonesForLoadBalancerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableAvailabilityZonesForLoadBalancerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_availability_zones_for_load_balancer(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableAvailabilityZonesForLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableAvailabilityZonesForLoadBalancer",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableAvailabilityZonesForLoadBalancerInput`](crate::input::DisableAvailabilityZonesForLoadBalancerInput)
    pub fn builder() -> crate::input::disable_availability_zones_for_load_balancer_input::Builder {
        crate::input::disable_availability_zones_for_load_balancer_input::Builder::default()
    }
}

/// See [`EnableAvailabilityZonesForLoadBalancerInput`](crate::input::EnableAvailabilityZonesForLoadBalancerInput)
pub mod enable_availability_zones_for_load_balancer_input {
    /// A builder for [`EnableAvailabilityZonesForLoadBalancerInput`](crate::input::EnableAvailabilityZonesForLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zones. These must be in the same region as the load balancer.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>The Availability Zones. These must be in the same region as the load balancer.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableAvailabilityZonesForLoadBalancerInput`](crate::input::EnableAvailabilityZonesForLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableAvailabilityZonesForLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableAvailabilityZonesForLoadBalancerInput {
                load_balancer_name: self.load_balancer_name,
                availability_zones: self.availability_zones,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableAvailabilityZonesForLoadBalancerInputOperationOutputAlias =
    crate::operation::EnableAvailabilityZonesForLoadBalancer;
#[doc(hidden)]
pub type EnableAvailabilityZonesForLoadBalancerInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl EnableAvailabilityZonesForLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`EnableAvailabilityZonesForLoadBalancer`](crate::operation::EnableAvailabilityZonesForLoadBalancer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableAvailabilityZonesForLoadBalancer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableAvailabilityZonesForLoadBalancerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableAvailabilityZonesForLoadBalancerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableAvailabilityZonesForLoadBalancerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_availability_zones_for_load_balancer(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableAvailabilityZonesForLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableAvailabilityZonesForLoadBalancer",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableAvailabilityZonesForLoadBalancerInput`](crate::input::EnableAvailabilityZonesForLoadBalancerInput)
    pub fn builder() -> crate::input::enable_availability_zones_for_load_balancer_input::Builder {
        crate::input::enable_availability_zones_for_load_balancer_input::Builder::default()
    }
}

/// See [`ModifyLoadBalancerAttributesInput`](crate::input::ModifyLoadBalancerAttributesInput)
pub mod modify_load_balancer_attributes_input {
    /// A builder for [`ModifyLoadBalancerAttributesInput`](crate::input::ModifyLoadBalancerAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) load_balancer_attributes:
            std::option::Option<crate::model::LoadBalancerAttributes>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The attributes for the load balancer.</p>
        pub fn load_balancer_attributes(
            mut self,
            input: crate::model::LoadBalancerAttributes,
        ) -> Self {
            self.load_balancer_attributes = Some(input);
            self
        }
        /// <p>The attributes for the load balancer.</p>
        pub fn set_load_balancer_attributes(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerAttributes>,
        ) -> Self {
            self.load_balancer_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyLoadBalancerAttributesInput`](crate::input::ModifyLoadBalancerAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyLoadBalancerAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyLoadBalancerAttributesInput {
                load_balancer_name: self.load_balancer_name,
                load_balancer_attributes: self.load_balancer_attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyLoadBalancerAttributesInputOperationOutputAlias =
    crate::operation::ModifyLoadBalancerAttributes;
#[doc(hidden)]
pub type ModifyLoadBalancerAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyLoadBalancerAttributesInput {
    /// Consumes the builder and constructs an Operation<[`ModifyLoadBalancerAttributes`](crate::operation::ModifyLoadBalancerAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyLoadBalancerAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyLoadBalancerAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyLoadBalancerAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyLoadBalancerAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_load_balancer_attributes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyLoadBalancerAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyLoadBalancerAttributes",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyLoadBalancerAttributesInput`](crate::input::ModifyLoadBalancerAttributesInput)
    pub fn builder() -> crate::input::modify_load_balancer_attributes_input::Builder {
        crate::input::modify_load_balancer_attributes_input::Builder::default()
    }
}

/// See [`RegisterInstancesWithLoadBalancerInput`](crate::input::RegisterInstancesWithLoadBalancerInput)
pub mod register_instances_with_load_balancer_input {
    /// A builder for [`RegisterInstancesWithLoadBalancerInput`](crate::input::RegisterInstancesWithLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>The IDs of the instances.</p>
        pub fn instances(mut self, input: impl Into<crate::model::Instance>) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input.into());
            self.instances = Some(v);
            self
        }
        /// <p>The IDs of the instances.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterInstancesWithLoadBalancerInput`](crate::input::RegisterInstancesWithLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterInstancesWithLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterInstancesWithLoadBalancerInput {
                load_balancer_name: self.load_balancer_name,
                instances: self.instances,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterInstancesWithLoadBalancerInputOperationOutputAlias =
    crate::operation::RegisterInstancesWithLoadBalancer;
#[doc(hidden)]
pub type RegisterInstancesWithLoadBalancerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterInstancesWithLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`RegisterInstancesWithLoadBalancer`](crate::operation::RegisterInstancesWithLoadBalancer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterInstancesWithLoadBalancer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterInstancesWithLoadBalancerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterInstancesWithLoadBalancerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterInstancesWithLoadBalancerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_instances_with_load_balancer(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterInstancesWithLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterInstancesWithLoadBalancer",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterInstancesWithLoadBalancerInput`](crate::input::RegisterInstancesWithLoadBalancerInput)
    pub fn builder() -> crate::input::register_instances_with_load_balancer_input::Builder {
        crate::input::register_instances_with_load_balancer_input::Builder::default()
    }
}

/// See [`RemoveTagsInput`](crate::input::RemoveTagsInput)
pub mod remove_tags_input {
    /// A builder for [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagKeyOnly>>,
    }
    impl Builder {
        /// Appends an item to `load_balancer_names`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_names`](Self::set_load_balancer_names).
        ///
        /// <p>The name of the load balancer. You can specify a maximum of one load balancer name.</p>
        pub fn load_balancer_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.load_balancer_names.unwrap_or_default();
            v.push(input.into());
            self.load_balancer_names = Some(v);
            self
        }
        /// <p>The name of the load balancer. You can specify a maximum of one load balancer name.</p>
        pub fn set_load_balancer_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.load_balancer_names = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tag keys to remove.</p>
        pub fn tags(mut self, input: impl Into<crate::model::TagKeyOnly>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of tag keys to remove.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagKeyOnly>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsInput`](crate::input::RemoveTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsInput {
                load_balancer_names: self.load_balancer_names,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsInputOperationOutputAlias = crate::operation::RemoveTags;
#[doc(hidden)]
pub type RemoveTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveTagsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTags`](crate::operation::RemoveTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_remove_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTags",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    pub fn builder() -> crate::input::remove_tags_input::Builder {
        crate::input::remove_tags_input::Builder::default()
    }
}

/// See [`SetLoadBalancerListenerSslCertificateInput`](crate::input::SetLoadBalancerListenerSslCertificateInput)
pub mod set_load_balancer_listener_ssl_certificate_input {
    /// A builder for [`SetLoadBalancerListenerSslCertificateInput`](crate::input::SetLoadBalancerListenerSslCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) load_balancer_port: std::option::Option<i32>,
        pub(crate) ssl_certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The port that uses the specified SSL certificate.</p>
        pub fn load_balancer_port(mut self, input: i32) -> Self {
            self.load_balancer_port = Some(input);
            self
        }
        /// <p>The port that uses the specified SSL certificate.</p>
        pub fn set_load_balancer_port(mut self, input: std::option::Option<i32>) -> Self {
            self.load_balancer_port = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SSL certificate.</p>
        pub fn ssl_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssl_certificate_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SSL certificate.</p>
        pub fn set_ssl_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssl_certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SetLoadBalancerListenerSslCertificateInput`](crate::input::SetLoadBalancerListenerSslCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetLoadBalancerListenerSslCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetLoadBalancerListenerSslCertificateInput {
                load_balancer_name: self.load_balancer_name,
                load_balancer_port: self.load_balancer_port.unwrap_or_default(),
                ssl_certificate_id: self.ssl_certificate_id,
            })
        }
    }
}
#[doc(hidden)]
pub type SetLoadBalancerListenerSslCertificateInputOperationOutputAlias =
    crate::operation::SetLoadBalancerListenerSSLCertificate;
#[doc(hidden)]
pub type SetLoadBalancerListenerSslCertificateInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl SetLoadBalancerListenerSslCertificateInput {
    /// Consumes the builder and constructs an Operation<[`SetLoadBalancerListenerSSLCertificate`](crate::operation::SetLoadBalancerListenerSSLCertificate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetLoadBalancerListenerSSLCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetLoadBalancerListenerSslCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetLoadBalancerListenerSslCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetLoadBalancerListenerSslCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_load_balancer_listener_ssl_certificate(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetLoadBalancerListenerSSLCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetLoadBalancerListenerSSLCertificate",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetLoadBalancerListenerSslCertificateInput`](crate::input::SetLoadBalancerListenerSslCertificateInput)
    pub fn builder() -> crate::input::set_load_balancer_listener_ssl_certificate_input::Builder {
        crate::input::set_load_balancer_listener_ssl_certificate_input::Builder::default()
    }
}

/// See [`SetLoadBalancerPoliciesForBackendServerInput`](crate::input::SetLoadBalancerPoliciesForBackendServerInput)
pub mod set_load_balancer_policies_for_backend_server_input {
    /// A builder for [`SetLoadBalancerPoliciesForBackendServerInput`](crate::input::SetLoadBalancerPoliciesForBackendServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) instance_port: std::option::Option<i32>,
        pub(crate) policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The port number associated with the EC2 instance.</p>
        pub fn instance_port(mut self, input: i32) -> Self {
            self.instance_port = Some(input);
            self
        }
        /// <p>The port number associated with the EC2 instance.</p>
        pub fn set_instance_port(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_port = input;
            self
        }
        /// Appends an item to `policy_names`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>The names of the policies. If the list is empty, then all current polices are removed from the EC2 instance.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_names.unwrap_or_default();
            v.push(input.into());
            self.policy_names = Some(v);
            self
        }
        /// <p>The names of the policies. If the list is empty, then all current polices are removed from the EC2 instance.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_names = input;
            self
        }
        /// Consumes the builder and constructs a [`SetLoadBalancerPoliciesForBackendServerInput`](crate::input::SetLoadBalancerPoliciesForBackendServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetLoadBalancerPoliciesForBackendServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetLoadBalancerPoliciesForBackendServerInput {
                load_balancer_name: self.load_balancer_name,
                instance_port: self.instance_port,
                policy_names: self.policy_names,
            })
        }
    }
}
#[doc(hidden)]
pub type SetLoadBalancerPoliciesForBackendServerInputOperationOutputAlias =
    crate::operation::SetLoadBalancerPoliciesForBackendServer;
#[doc(hidden)]
pub type SetLoadBalancerPoliciesForBackendServerInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl SetLoadBalancerPoliciesForBackendServerInput {
    /// Consumes the builder and constructs an Operation<[`SetLoadBalancerPoliciesForBackendServer`](crate::operation::SetLoadBalancerPoliciesForBackendServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetLoadBalancerPoliciesForBackendServer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetLoadBalancerPoliciesForBackendServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetLoadBalancerPoliciesForBackendServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetLoadBalancerPoliciesForBackendServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_load_balancer_policies_for_backend_server(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetLoadBalancerPoliciesForBackendServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetLoadBalancerPoliciesForBackendServer",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetLoadBalancerPoliciesForBackendServerInput`](crate::input::SetLoadBalancerPoliciesForBackendServerInput)
    pub fn builder() -> crate::input::set_load_balancer_policies_for_backend_server_input::Builder {
        crate::input::set_load_balancer_policies_for_backend_server_input::Builder::default()
    }
}

/// See [`SetLoadBalancerPoliciesOfListenerInput`](crate::input::SetLoadBalancerPoliciesOfListenerInput)
pub mod set_load_balancer_policies_of_listener_input {
    /// A builder for [`SetLoadBalancerPoliciesOfListenerInput`](crate::input::SetLoadBalancerPoliciesOfListenerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) load_balancer_port: std::option::Option<i32>,
        pub(crate) policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The external port of the load balancer.</p>
        pub fn load_balancer_port(mut self, input: i32) -> Self {
            self.load_balancer_port = Some(input);
            self
        }
        /// <p>The external port of the load balancer.</p>
        pub fn set_load_balancer_port(mut self, input: std::option::Option<i32>) -> Self {
            self.load_balancer_port = input;
            self
        }
        /// Appends an item to `policy_names`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>The names of the policies. This list must include all policies to be enabled. If you omit a policy that is currently enabled, it is disabled. If the list is empty, all current policies are disabled.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_names.unwrap_or_default();
            v.push(input.into());
            self.policy_names = Some(v);
            self
        }
        /// <p>The names of the policies. This list must include all policies to be enabled. If you omit a policy that is currently enabled, it is disabled. If the list is empty, all current policies are disabled.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_names = input;
            self
        }
        /// Consumes the builder and constructs a [`SetLoadBalancerPoliciesOfListenerInput`](crate::input::SetLoadBalancerPoliciesOfListenerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetLoadBalancerPoliciesOfListenerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetLoadBalancerPoliciesOfListenerInput {
                load_balancer_name: self.load_balancer_name,
                load_balancer_port: self.load_balancer_port.unwrap_or_default(),
                policy_names: self.policy_names,
            })
        }
    }
}
#[doc(hidden)]
pub type SetLoadBalancerPoliciesOfListenerInputOperationOutputAlias =
    crate::operation::SetLoadBalancerPoliciesOfListener;
#[doc(hidden)]
pub type SetLoadBalancerPoliciesOfListenerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetLoadBalancerPoliciesOfListenerInput {
    /// Consumes the builder and constructs an Operation<[`SetLoadBalancerPoliciesOfListener`](crate::operation::SetLoadBalancerPoliciesOfListener)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetLoadBalancerPoliciesOfListener,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetLoadBalancerPoliciesOfListenerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetLoadBalancerPoliciesOfListenerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetLoadBalancerPoliciesOfListenerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_load_balancer_policies_of_listener(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetLoadBalancerPoliciesOfListener::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetLoadBalancerPoliciesOfListener",
            "elasticloadbalancing",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetLoadBalancerPoliciesOfListenerInput`](crate::input::SetLoadBalancerPoliciesOfListenerInput)
    pub fn builder() -> crate::input::set_load_balancer_policies_of_listener_input::Builder {
        crate::input::set_load_balancer_policies_of_listener_input::Builder::default()
    }
}

/// <p>Contains the parameters for SetLoadBalancePoliciesOfListener.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetLoadBalancerPoliciesOfListenerInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The external port of the load balancer.</p>
    pub load_balancer_port: i32,
    /// <p>The names of the policies. This list must include all policies to be enabled. If you omit a policy that is currently enabled, it is disabled. If the list is empty, all current policies are disabled.</p>
    pub policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SetLoadBalancerPoliciesOfListenerInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The external port of the load balancer.</p>
    pub fn load_balancer_port(&self) -> i32 {
        self.load_balancer_port
    }
    /// <p>The names of the policies. This list must include all policies to be enabled. If you omit a policy that is currently enabled, it is disabled. If the list is empty, all current policies are disabled.</p>
    pub fn policy_names(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_names.as_deref()
    }
}
impl std::fmt::Debug for SetLoadBalancerPoliciesOfListenerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetLoadBalancerPoliciesOfListenerInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("load_balancer_port", &self.load_balancer_port);
        formatter.field("policy_names", &self.policy_names);
        formatter.finish()
    }
}

/// <p>Contains the parameters for SetLoadBalancerPoliciesForBackendServer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetLoadBalancerPoliciesForBackendServerInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The port number associated with the EC2 instance.</p>
    pub instance_port: std::option::Option<i32>,
    /// <p>The names of the policies. If the list is empty, then all current polices are removed from the EC2 instance.</p>
    pub policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SetLoadBalancerPoliciesForBackendServerInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The port number associated with the EC2 instance.</p>
    pub fn instance_port(&self) -> std::option::Option<i32> {
        self.instance_port
    }
    /// <p>The names of the policies. If the list is empty, then all current polices are removed from the EC2 instance.</p>
    pub fn policy_names(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_names.as_deref()
    }
}
impl std::fmt::Debug for SetLoadBalancerPoliciesForBackendServerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetLoadBalancerPoliciesForBackendServerInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("instance_port", &self.instance_port);
        formatter.field("policy_names", &self.policy_names);
        formatter.finish()
    }
}

/// <p>Contains the parameters for SetLoadBalancerListenerSSLCertificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetLoadBalancerListenerSslCertificateInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The port that uses the specified SSL certificate.</p>
    pub load_balancer_port: i32,
    /// <p>The Amazon Resource Name (ARN) of the SSL certificate.</p>
    pub ssl_certificate_id: std::option::Option<std::string::String>,
}
impl SetLoadBalancerListenerSslCertificateInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The port that uses the specified SSL certificate.</p>
    pub fn load_balancer_port(&self) -> i32 {
        self.load_balancer_port
    }
    /// <p>The Amazon Resource Name (ARN) of the SSL certificate.</p>
    pub fn ssl_certificate_id(&self) -> std::option::Option<&str> {
        self.ssl_certificate_id.as_deref()
    }
}
impl std::fmt::Debug for SetLoadBalancerListenerSslCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetLoadBalancerListenerSslCertificateInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("load_balancer_port", &self.load_balancer_port);
        formatter.field("ssl_certificate_id", &self.ssl_certificate_id);
        formatter.finish()
    }
}

/// <p>Contains the parameters for RemoveTags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsInput {
    /// <p>The name of the load balancer. You can specify a maximum of one load balancer name.</p>
    pub load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of tag keys to remove.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagKeyOnly>>,
}
impl RemoveTagsInput {
    /// <p>The name of the load balancer. You can specify a maximum of one load balancer name.</p>
    pub fn load_balancer_names(&self) -> std::option::Option<&[std::string::String]> {
        self.load_balancer_names.as_deref()
    }
    /// <p>The list of tag keys to remove.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagKeyOnly]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsInput");
        formatter.field("load_balancer_names", &self.load_balancer_names);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Contains the parameters for RegisterInstancesWithLoadBalancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterInstancesWithLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The IDs of the instances.</p>
    pub instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
}
impl RegisterInstancesWithLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The IDs of the instances.</p>
    pub fn instances(&self) -> std::option::Option<&[crate::model::Instance]> {
        self.instances.as_deref()
    }
}
impl std::fmt::Debug for RegisterInstancesWithLoadBalancerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterInstancesWithLoadBalancerInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("instances", &self.instances);
        formatter.finish()
    }
}

/// <p>Contains the parameters for ModifyLoadBalancerAttributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyLoadBalancerAttributesInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The attributes for the load balancer.</p>
    pub load_balancer_attributes: std::option::Option<crate::model::LoadBalancerAttributes>,
}
impl ModifyLoadBalancerAttributesInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The attributes for the load balancer.</p>
    pub fn load_balancer_attributes(
        &self,
    ) -> std::option::Option<&crate::model::LoadBalancerAttributes> {
        self.load_balancer_attributes.as_ref()
    }
}
impl std::fmt::Debug for ModifyLoadBalancerAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyLoadBalancerAttributesInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("load_balancer_attributes", &self.load_balancer_attributes);
        formatter.finish()
    }
}

/// <p>Contains the parameters for EnableAvailabilityZonesForLoadBalancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableAvailabilityZonesForLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The Availability Zones. These must be in the same region as the load balancer.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl EnableAvailabilityZonesForLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The Availability Zones. These must be in the same region as the load balancer.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
}
impl std::fmt::Debug for EnableAvailabilityZonesForLoadBalancerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableAvailabilityZonesForLoadBalancerInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.finish()
    }
}

/// <p>Contains the parameters for DisableAvailabilityZonesForLoadBalancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableAvailabilityZonesForLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The Availability Zones.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DisableAvailabilityZonesForLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The Availability Zones.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
}
impl std::fmt::Debug for DisableAvailabilityZonesForLoadBalancerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableAvailabilityZonesForLoadBalancerInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.finish()
    }
}

/// <p>Contains the parameters for DetachLoadBalancerFromSubnets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachLoadBalancerFromSubnetsInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The IDs of the subnets.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DetachLoadBalancerFromSubnetsInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The IDs of the subnets.</p>
    pub fn subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.subnets.as_deref()
    }
}
impl std::fmt::Debug for DetachLoadBalancerFromSubnetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachLoadBalancerFromSubnetsInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("subnets", &self.subnets);
        formatter.finish()
    }
}

/// <p>Contains the parameters for DescribeTags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagsInput {
    /// <p>The names of the load balancers.</p>
    pub load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeTagsInput {
    /// <p>The names of the load balancers.</p>
    pub fn load_balancer_names(&self) -> std::option::Option<&[std::string::String]> {
        self.load_balancer_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagsInput");
        formatter.field("load_balancer_names", &self.load_balancer_names);
        formatter.finish()
    }
}

/// <p>Contains the parameters for DescribeLoadBalancers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoadBalancersInput {
    /// <p>The names of the load balancers.</p>
    pub load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with this call (a number from 1 to 400). The default is 400.</p>
    pub page_size: std::option::Option<i32>,
}
impl DescribeLoadBalancersInput {
    /// <p>The names of the load balancers.</p>
    pub fn load_balancer_names(&self) -> std::option::Option<&[std::string::String]> {
        self.load_balancer_names.as_deref()
    }
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of results to return with this call (a number from 1 to 400). The default is 400.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
}
impl std::fmt::Debug for DescribeLoadBalancersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoadBalancersInput");
        formatter.field("load_balancer_names", &self.load_balancer_names);
        formatter.field("marker", &self.marker);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

/// <p>Contains the parameters for DescribeLoadBalancerPolicyTypes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoadBalancerPolicyTypesInput {
    /// <p>The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load Balancing.</p>
    pub policy_type_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeLoadBalancerPolicyTypesInput {
    /// <p>The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load Balancing.</p>
    pub fn policy_type_names(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_type_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeLoadBalancerPolicyTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoadBalancerPolicyTypesInput");
        formatter.field("policy_type_names", &self.policy_type_names);
        formatter.finish()
    }
}

/// <p>Contains the parameters for DescribeLoadBalancerPolicies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoadBalancerPoliciesInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The names of the policies.</p>
    pub policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeLoadBalancerPoliciesInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The names of the policies.</p>
    pub fn policy_names(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeLoadBalancerPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoadBalancerPoliciesInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("policy_names", &self.policy_names);
        formatter.finish()
    }
}

/// <p>Contains the parameters for DescribeLoadBalancerAttributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoadBalancerAttributesInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
}
impl DescribeLoadBalancerAttributesInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeLoadBalancerAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoadBalancerAttributesInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.finish()
    }
}

/// <p>Contains the parameters for DescribeInstanceHealth.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstanceHealthInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The IDs of the instances.</p>
    pub instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
}
impl DescribeInstanceHealthInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The IDs of the instances.</p>
    pub fn instances(&self) -> std::option::Option<&[crate::model::Instance]> {
        self.instances.as_deref()
    }
}
impl std::fmt::Debug for DescribeInstanceHealthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstanceHealthInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("instances", &self.instances);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountLimitsInput {
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with this call.</p>
    pub page_size: std::option::Option<i32>,
}
impl DescribeAccountLimitsInput {
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of results to return with this call.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
}
impl std::fmt::Debug for DescribeAccountLimitsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountLimitsInput");
        formatter.field("marker", &self.marker);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

/// <p>Contains the parameters for DeregisterInstancesFromLoadBalancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterInstancesFromLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The IDs of the instances.</p>
    pub instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
}
impl DeregisterInstancesFromLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The IDs of the instances.</p>
    pub fn instances(&self) -> std::option::Option<&[crate::model::Instance]> {
        self.instances.as_deref()
    }
}
impl std::fmt::Debug for DeregisterInstancesFromLoadBalancerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterInstancesFromLoadBalancerInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("instances", &self.instances);
        formatter.finish()
    }
}

/// <p>Contains the parameters for DeleteLoadBalancerPolicy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLoadBalancerPolicyInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The name of the policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
}
impl DeleteLoadBalancerPolicyInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The name of the policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteLoadBalancerPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLoadBalancerPolicyInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("policy_name", &self.policy_name);
        formatter.finish()
    }
}

/// <p>Contains the parameters for DeleteLoadBalancerListeners.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLoadBalancerListenersInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The client port numbers of the listeners.</p>
    pub load_balancer_ports: std::option::Option<std::vec::Vec<i32>>,
}
impl DeleteLoadBalancerListenersInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The client port numbers of the listeners.</p>
    pub fn load_balancer_ports(&self) -> std::option::Option<&[i32]> {
        self.load_balancer_ports.as_deref()
    }
}
impl std::fmt::Debug for DeleteLoadBalancerListenersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLoadBalancerListenersInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("load_balancer_ports", &self.load_balancer_ports);
        formatter.finish()
    }
}

/// <p>Contains the parameters for DeleteLoadBalancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
}
impl DeleteLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteLoadBalancerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLoadBalancerInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.finish()
    }
}

/// <p>Contains the parameters for CreateLoadBalancerPolicy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLoadBalancerPolicyInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The name of the load balancer policy to be created. This name must be unique within the set of policies for this load balancer.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The name of the base policy type.
    /// To get the list of policy types, use <a>DescribeLoadBalancerPolicyTypes</a>.</p>
    pub policy_type_name: std::option::Option<std::string::String>,
    /// <p>The policy attributes.</p>
    pub policy_attributes: std::option::Option<std::vec::Vec<crate::model::PolicyAttribute>>,
}
impl CreateLoadBalancerPolicyInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The name of the load balancer policy to be created. This name must be unique within the set of policies for this load balancer.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The name of the base policy type.
    /// To get the list of policy types, use <a>DescribeLoadBalancerPolicyTypes</a>.</p>
    pub fn policy_type_name(&self) -> std::option::Option<&str> {
        self.policy_type_name.as_deref()
    }
    /// <p>The policy attributes.</p>
    pub fn policy_attributes(&self) -> std::option::Option<&[crate::model::PolicyAttribute]> {
        self.policy_attributes.as_deref()
    }
}
impl std::fmt::Debug for CreateLoadBalancerPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLoadBalancerPolicyInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_type_name", &self.policy_type_name);
        formatter.field("policy_attributes", &self.policy_attributes);
        formatter.finish()
    }
}

/// <p>Contains the parameters for CreateLoadBalancerListeners.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLoadBalancerListenersInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The listeners.</p>
    pub listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
}
impl CreateLoadBalancerListenersInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The listeners.</p>
    pub fn listeners(&self) -> std::option::Option<&[crate::model::Listener]> {
        self.listeners.as_deref()
    }
}
impl std::fmt::Debug for CreateLoadBalancerListenersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLoadBalancerListenersInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("listeners", &self.listeners);
        formatter.finish()
    }
}

/// <p>Contains the parameters for CreateLoadBalancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    /// <p>This name must be unique within your set of load balancers for the region, must have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The listeners.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
    /// <p>One or more Availability Zones from the same region as the load balancer.</p>
    /// <p>You must specify at least one Availability Zone.</p>
    /// <p>You can add more Availability Zones after you create the load balancer using
    /// <a>EnableAvailabilityZonesForLoadBalancer</a>.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IDs of the subnets in your VPC to attach to the load balancer.
    /// Specify one subnet per Availability Zone specified in <code>AvailabilityZones</code>.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IDs of the security groups to assign to the load balancer.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type of a load balancer. Valid only for load balancers in a VPC.</p>          
    /// <p>By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that resolves to public IP addresses.
    /// For more information about Internet-facing and Internal load balancers, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme">Load Balancer Scheme</a>
    /// in the <i>Elastic Load Balancing User Guide</i>.</p>
    /// <p>Specify <code>internal</code> to create a load balancer with a DNS name that resolves to private IP addresses.</p>
    pub scheme: std::option::Option<std::string::String>,
    /// <p>A list of tags to assign to the load balancer.</p>
    /// <p>For more information about tagging your load balancer, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic Load Balancer</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    /// <p>This name must be unique within your set of load balancers for the region, must have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The listeners.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub fn listeners(&self) -> std::option::Option<&[crate::model::Listener]> {
        self.listeners.as_deref()
    }
    /// <p>One or more Availability Zones from the same region as the load balancer.</p>
    /// <p>You must specify at least one Availability Zone.</p>
    /// <p>You can add more Availability Zones after you create the load balancer using
    /// <a>EnableAvailabilityZonesForLoadBalancer</a>.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>The IDs of the subnets in your VPC to attach to the load balancer.
    /// Specify one subnet per Availability Zone specified in <code>AvailabilityZones</code>.</p>
    pub fn subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.subnets.as_deref()
    }
    /// <p>The IDs of the security groups to assign to the load balancer.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>The type of a load balancer. Valid only for load balancers in a VPC.</p>          
    /// <p>By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that resolves to public IP addresses.
    /// For more information about Internet-facing and Internal load balancers, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme">Load Balancer Scheme</a>
    /// in the <i>Elastic Load Balancing User Guide</i>.</p>
    /// <p>Specify <code>internal</code> to create a load balancer with a DNS name that resolves to private IP addresses.</p>
    pub fn scheme(&self) -> std::option::Option<&str> {
        self.scheme.as_deref()
    }
    /// <p>A list of tags to assign to the load balancer.</p>
    /// <p>For more information about tagging your load balancer, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic Load Balancer</a>
    /// in the <i>Classic Load Balancers Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateLoadBalancerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLoadBalancerInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("listeners", &self.listeners);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("subnets", &self.subnets);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("scheme", &self.scheme);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Contains the parameters for CreateLBCookieStickinessPolicy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLbCookieStickinessPolicyInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The time period, in seconds, after which the cookie should be considered stale. If you do not specify this parameter, the default value is 0, which indicates that the sticky session should last for the duration of the browser session.</p>
    pub cookie_expiration_period: std::option::Option<i64>,
}
impl CreateLbCookieStickinessPolicyInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The time period, in seconds, after which the cookie should be considered stale. If you do not specify this parameter, the default value is 0, which indicates that the sticky session should last for the duration of the browser session.</p>
    pub fn cookie_expiration_period(&self) -> std::option::Option<i64> {
        self.cookie_expiration_period
    }
}
impl std::fmt::Debug for CreateLbCookieStickinessPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLbCookieStickinessPolicyInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("cookie_expiration_period", &self.cookie_expiration_period);
        formatter.finish()
    }
}

/// <p>Contains the parameters for CreateAppCookieStickinessPolicy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAppCookieStickinessPolicyInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The name of the application cookie used for stickiness.</p>
    pub cookie_name: std::option::Option<std::string::String>,
}
impl CreateAppCookieStickinessPolicyInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The name of the application cookie used for stickiness.</p>
    pub fn cookie_name(&self) -> std::option::Option<&str> {
        self.cookie_name.as_deref()
    }
}
impl std::fmt::Debug for CreateAppCookieStickinessPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAppCookieStickinessPolicyInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("cookie_name", &self.cookie_name);
        formatter.finish()
    }
}

/// <p>Contains the parameters for ConfigureHealthCheck.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigureHealthCheckInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The configuration information.</p>
    pub health_check: std::option::Option<crate::model::HealthCheck>,
}
impl ConfigureHealthCheckInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The configuration information.</p>
    pub fn health_check(&self) -> std::option::Option<&crate::model::HealthCheck> {
        self.health_check.as_ref()
    }
}
impl std::fmt::Debug for ConfigureHealthCheckInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigureHealthCheckInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("health_check", &self.health_check);
        formatter.finish()
    }
}

/// <p>Contains the parameters for AttachLoaBalancerToSubnets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachLoadBalancerToSubnetsInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The IDs of the subnets to add. You can add only one subnet per Availability Zone.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AttachLoadBalancerToSubnetsInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The IDs of the subnets to add. You can add only one subnet per Availability Zone.</p>
    pub fn subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.subnets.as_deref()
    }
}
impl std::fmt::Debug for AttachLoadBalancerToSubnetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachLoadBalancerToSubnetsInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("subnets", &self.subnets);
        formatter.finish()
    }
}

/// <p>Contains the parameters for ApplySecurityGroupsToLoadBalancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplySecurityGroupsToLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The IDs of the security groups to associate with the load balancer. Note that you cannot specify the name of the security group.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ApplySecurityGroupsToLoadBalancerInput {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>The IDs of the security groups to associate with the load balancer. Note that you cannot specify the name of the security group.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
}
impl std::fmt::Debug for ApplySecurityGroupsToLoadBalancerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplySecurityGroupsToLoadBalancerInput");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("security_groups", &self.security_groups);
        formatter.finish()
    }
}

/// <p>Contains the parameters for AddTags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsInput {
    /// <p>The name of the load balancer. You can specify one load balancer only.</p>
    pub load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl AddTagsInput {
    /// <p>The name of the load balancer. You can specify one load balancer only.</p>
    pub fn load_balancer_names(&self) -> std::option::Option<&[std::string::String]> {
        self.load_balancer_names.as_deref()
    }
    /// <p>The tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for AddTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsInput");
        formatter.field("load_balancer_names", &self.load_balancer_names);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
