// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsError {
    /// Kind of error that occurred.
    pub kind: AddTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>The quota for the number of tags that can be assigned to a load balancer has been reached.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsErrorKind::AccessPointNotFoundException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::DuplicateTagKeysException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsError {
    fn code(&self) -> Option<&str> {
        AddTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsError {
    /// Creates a new `AddTagsError`.
    pub fn new(kind: AddTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::DuplicateTagKeysException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for AddTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsErrorKind::AccessPointNotFoundException(_inner) => Some(_inner),
            AddTagsErrorKind::DuplicateTagKeysException(_inner) => Some(_inner),
            AddTagsErrorKind::TooManyTagsException(_inner) => Some(_inner),
            AddTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ApplySecurityGroupsToLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ApplySecurityGroupsToLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: ApplySecurityGroupsToLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ApplySecurityGroupsToLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ApplySecurityGroupsToLoadBalancerErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>One or more of the specified security groups do not exist.</p>
    InvalidSecurityGroupException(crate::error::InvalidSecurityGroupException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ApplySecurityGroupsToLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ApplySecurityGroupsToLoadBalancerErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ApplySecurityGroupsToLoadBalancerErrorKind::InvalidConfigurationRequestException(
                _inner,
            ) => _inner.fmt(f),
            ApplySecurityGroupsToLoadBalancerErrorKind::InvalidSecurityGroupException(_inner) => {
                _inner.fmt(f)
            }
            ApplySecurityGroupsToLoadBalancerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ApplySecurityGroupsToLoadBalancerError {
    fn code(&self) -> Option<&str> {
        ApplySecurityGroupsToLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ApplySecurityGroupsToLoadBalancerError {
    /// Creates a new `ApplySecurityGroupsToLoadBalancerError`.
    pub fn new(
        kind: ApplySecurityGroupsToLoadBalancerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ApplySecurityGroupsToLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ApplySecurityGroupsToLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ApplySecurityGroupsToLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ApplySecurityGroupsToLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ApplySecurityGroupsToLoadBalancerErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ApplySecurityGroupsToLoadBalancerErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ApplySecurityGroupsToLoadBalancerErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ApplySecurityGroupsToLoadBalancerErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ApplySecurityGroupsToLoadBalancerErrorKind::InvalidSecurityGroupException`.
    pub fn is_invalid_security_group_exception(&self) -> bool {
        matches!(
            &self.kind,
            ApplySecurityGroupsToLoadBalancerErrorKind::InvalidSecurityGroupException(_)
        )
    }
}
impl std::error::Error for ApplySecurityGroupsToLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ApplySecurityGroupsToLoadBalancerErrorKind::AccessPointNotFoundException(_inner) => {
                Some(_inner)
            }
            ApplySecurityGroupsToLoadBalancerErrorKind::InvalidConfigurationRequestException(
                _inner,
            ) => Some(_inner),
            ApplySecurityGroupsToLoadBalancerErrorKind::InvalidSecurityGroupException(_inner) => {
                Some(_inner)
            }
            ApplySecurityGroupsToLoadBalancerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachLoadBalancerToSubnets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachLoadBalancerToSubnetsError {
    /// Kind of error that occurred.
    pub kind: AttachLoadBalancerToSubnetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachLoadBalancerToSubnets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachLoadBalancerToSubnetsErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The specified VPC has no associated Internet gateway.</p>
    InvalidSubnetException(crate::error::InvalidSubnetException),
    /// <p>One or more of the specified subnets do not exist.</p>
    SubnetNotFoundException(crate::error::SubnetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachLoadBalancerToSubnetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachLoadBalancerToSubnetsErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AttachLoadBalancerToSubnetsErrorKind::InvalidConfigurationRequestException(_inner) => {
                _inner.fmt(f)
            }
            AttachLoadBalancerToSubnetsErrorKind::InvalidSubnetException(_inner) => _inner.fmt(f),
            AttachLoadBalancerToSubnetsErrorKind::SubnetNotFoundException(_inner) => _inner.fmt(f),
            AttachLoadBalancerToSubnetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachLoadBalancerToSubnetsError {
    fn code(&self) -> Option<&str> {
        AttachLoadBalancerToSubnetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachLoadBalancerToSubnetsError {
    /// Creates a new `AttachLoadBalancerToSubnetsError`.
    pub fn new(kind: AttachLoadBalancerToSubnetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachLoadBalancerToSubnetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachLoadBalancerToSubnetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachLoadBalancerToSubnetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachLoadBalancerToSubnetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachLoadBalancerToSubnetsErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancerToSubnetsErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachLoadBalancerToSubnetsErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancerToSubnetsErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachLoadBalancerToSubnetsErrorKind::InvalidSubnetException`.
    pub fn is_invalid_subnet_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancerToSubnetsErrorKind::InvalidSubnetException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachLoadBalancerToSubnetsErrorKind::SubnetNotFoundException`.
    pub fn is_subnet_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancerToSubnetsErrorKind::SubnetNotFoundException(_)
        )
    }
}
impl std::error::Error for AttachLoadBalancerToSubnetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachLoadBalancerToSubnetsErrorKind::AccessPointNotFoundException(_inner) => {
                Some(_inner)
            }
            AttachLoadBalancerToSubnetsErrorKind::InvalidConfigurationRequestException(_inner) => {
                Some(_inner)
            }
            AttachLoadBalancerToSubnetsErrorKind::InvalidSubnetException(_inner) => Some(_inner),
            AttachLoadBalancerToSubnetsErrorKind::SubnetNotFoundException(_inner) => Some(_inner),
            AttachLoadBalancerToSubnetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ConfigureHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConfigureHealthCheckError {
    /// Kind of error that occurred.
    pub kind: ConfigureHealthCheckErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConfigureHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConfigureHealthCheckErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConfigureHealthCheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConfigureHealthCheckErrorKind::AccessPointNotFoundException(_inner) => _inner.fmt(f),
            ConfigureHealthCheckErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConfigureHealthCheckError {
    fn code(&self) -> Option<&str> {
        ConfigureHealthCheckError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ConfigureHealthCheckError {
    /// Creates a new `ConfigureHealthCheckError`.
    pub fn new(kind: ConfigureHealthCheckErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConfigureHealthCheckError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConfigureHealthCheckErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConfigureHealthCheckError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConfigureHealthCheckErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ConfigureHealthCheckErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfigureHealthCheckErrorKind::AccessPointNotFoundException(_)
        )
    }
}
impl std::error::Error for ConfigureHealthCheckError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConfigureHealthCheckErrorKind::AccessPointNotFoundException(_inner) => Some(_inner),
            ConfigureHealthCheckErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAppCookieStickinessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAppCookieStickinessPolicyError {
    /// Kind of error that occurred.
    pub kind: CreateAppCookieStickinessPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAppCookieStickinessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAppCookieStickinessPolicyErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>A policy with the specified name already exists for this load balancer.</p>
    DuplicatePolicyNameException(crate::error::DuplicatePolicyNameException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The quota for the number of policies for this load balancer has been reached.</p>
    TooManyPoliciesException(crate::error::TooManyPoliciesException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAppCookieStickinessPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAppCookieStickinessPolicyErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateAppCookieStickinessPolicyErrorKind::DuplicatePolicyNameException(_inner) => {
                _inner.fmt(f)
            }
            CreateAppCookieStickinessPolicyErrorKind::InvalidConfigurationRequestException(
                _inner,
            ) => _inner.fmt(f),
            CreateAppCookieStickinessPolicyErrorKind::TooManyPoliciesException(_inner) => {
                _inner.fmt(f)
            }
            CreateAppCookieStickinessPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAppCookieStickinessPolicyError {
    fn code(&self) -> Option<&str> {
        CreateAppCookieStickinessPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAppCookieStickinessPolicyError {
    /// Creates a new `CreateAppCookieStickinessPolicyError`.
    pub fn new(
        kind: CreateAppCookieStickinessPolicyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAppCookieStickinessPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAppCookieStickinessPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAppCookieStickinessPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAppCookieStickinessPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAppCookieStickinessPolicyErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppCookieStickinessPolicyErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppCookieStickinessPolicyErrorKind::DuplicatePolicyNameException`.
    pub fn is_duplicate_policy_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppCookieStickinessPolicyErrorKind::DuplicatePolicyNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppCookieStickinessPolicyErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppCookieStickinessPolicyErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppCookieStickinessPolicyErrorKind::TooManyPoliciesException`.
    pub fn is_too_many_policies_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppCookieStickinessPolicyErrorKind::TooManyPoliciesException(_)
        )
    }
}
impl std::error::Error for CreateAppCookieStickinessPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAppCookieStickinessPolicyErrorKind::AccessPointNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateAppCookieStickinessPolicyErrorKind::DuplicatePolicyNameException(_inner) => {
                Some(_inner)
            }
            CreateAppCookieStickinessPolicyErrorKind::InvalidConfigurationRequestException(
                _inner,
            ) => Some(_inner),
            CreateAppCookieStickinessPolicyErrorKind::TooManyPoliciesException(_inner) => {
                Some(_inner)
            }
            CreateAppCookieStickinessPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLBCookieStickinessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLBCookieStickinessPolicyError {
    /// Kind of error that occurred.
    pub kind: CreateLBCookieStickinessPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLBCookieStickinessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLBCookieStickinessPolicyErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>A policy with the specified name already exists for this load balancer.</p>
    DuplicatePolicyNameException(crate::error::DuplicatePolicyNameException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The quota for the number of policies for this load balancer has been reached.</p>
    TooManyPoliciesException(crate::error::TooManyPoliciesException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLBCookieStickinessPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLBCookieStickinessPolicyErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateLBCookieStickinessPolicyErrorKind::DuplicatePolicyNameException(_inner) => {
                _inner.fmt(f)
            }
            CreateLBCookieStickinessPolicyErrorKind::InvalidConfigurationRequestException(
                _inner,
            ) => _inner.fmt(f),
            CreateLBCookieStickinessPolicyErrorKind::TooManyPoliciesException(_inner) => {
                _inner.fmt(f)
            }
            CreateLBCookieStickinessPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLBCookieStickinessPolicyError {
    fn code(&self) -> Option<&str> {
        CreateLBCookieStickinessPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLBCookieStickinessPolicyError {
    /// Creates a new `CreateLBCookieStickinessPolicyError`.
    pub fn new(
        kind: CreateLBCookieStickinessPolicyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLBCookieStickinessPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLBCookieStickinessPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLBCookieStickinessPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLBCookieStickinessPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLBCookieStickinessPolicyErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLBCookieStickinessPolicyErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLBCookieStickinessPolicyErrorKind::DuplicatePolicyNameException`.
    pub fn is_duplicate_policy_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLBCookieStickinessPolicyErrorKind::DuplicatePolicyNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLBCookieStickinessPolicyErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLBCookieStickinessPolicyErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLBCookieStickinessPolicyErrorKind::TooManyPoliciesException`.
    pub fn is_too_many_policies_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLBCookieStickinessPolicyErrorKind::TooManyPoliciesException(_)
        )
    }
}
impl std::error::Error for CreateLBCookieStickinessPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLBCookieStickinessPolicyErrorKind::AccessPointNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateLBCookieStickinessPolicyErrorKind::DuplicatePolicyNameException(_inner) => {
                Some(_inner)
            }
            CreateLBCookieStickinessPolicyErrorKind::InvalidConfigurationRequestException(
                _inner,
            ) => Some(_inner),
            CreateLBCookieStickinessPolicyErrorKind::TooManyPoliciesException(_inner) => {
                Some(_inner)
            }
            CreateLBCookieStickinessPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: CreateLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLoadBalancerErrorKind {
    /// <p>The specified ARN does not refer to a valid SSL certificate in AWS Identity and Access Management (IAM)
    /// or AWS Certificate Manager (ACM). Note that if you recently uploaded the certificate to IAM, this error might
    /// indicate that the certificate is not fully available yet.</p>
    CertificateNotFoundException(crate::error::CertificateNotFoundException),
    /// <p>The specified load balancer name already exists for this account.</p>
    DuplicateAccessPointNameException(crate::error::DuplicateAccessPointNameException),
    /// <p>A tag key was specified more than once.</p>
    DuplicateTagKeysException(crate::error::DuplicateTagKeysException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The specified value for the schema is not valid. You can only specify a scheme for load balancers in a VPC.</p>
    InvalidSchemeException(crate::error::InvalidSchemeException),
    /// <p>One or more of the specified security groups do not exist.</p>
    InvalidSecurityGroupException(crate::error::InvalidSecurityGroupException),
    /// <p>The specified VPC has no associated Internet gateway.</p>
    InvalidSubnetException(crate::error::InvalidSubnetException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>One or more of the specified subnets do not exist.</p>
    SubnetNotFoundException(crate::error::SubnetNotFoundException),
    /// <p>The quota for the number of load balancers has been reached.</p>
    TooManyAccessPointsException(crate::error::TooManyAccessPointsException),
    /// <p>The quota for the number of tags that can be assigned to a load balancer has been reached.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>The specified protocol or signature version is not supported.</p>
    UnsupportedProtocolException(crate::error::UnsupportedProtocolException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLoadBalancerErrorKind::CertificateNotFoundException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::DuplicateAccessPointNameException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::DuplicateTagKeysException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::InvalidConfigurationRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerErrorKind::InvalidSchemeException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::InvalidSecurityGroupException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::InvalidSubnetException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::SubnetNotFoundException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::TooManyAccessPointsException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::UnsupportedProtocolException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLoadBalancerError {
    fn code(&self) -> Option<&str> {
        CreateLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLoadBalancerError {
    /// Creates a new `CreateLoadBalancerError`.
    pub fn new(kind: CreateLoadBalancerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::CertificateNotFoundException`.
    pub fn is_certificate_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::CertificateNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::DuplicateAccessPointNameException`.
    pub fn is_duplicate_access_point_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::DuplicateAccessPointNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::DuplicateTagKeysException`.
    pub fn is_duplicate_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::DuplicateTagKeysException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::InvalidSchemeException`.
    pub fn is_invalid_scheme_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::InvalidSchemeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::InvalidSecurityGroupException`.
    pub fn is_invalid_security_group_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::InvalidSecurityGroupException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::InvalidSubnetException`.
    pub fn is_invalid_subnet_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::InvalidSubnetException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::SubnetNotFoundException`.
    pub fn is_subnet_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::SubnetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::TooManyAccessPointsException`.
    pub fn is_too_many_access_points_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::TooManyAccessPointsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::TooManyTagsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::UnsupportedProtocolException`.
    pub fn is_unsupported_protocol_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::UnsupportedProtocolException(_)
        )
    }
}
impl std::error::Error for CreateLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLoadBalancerErrorKind::CertificateNotFoundException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::DuplicateAccessPointNameException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::DuplicateTagKeysException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::InvalidConfigurationRequestException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerErrorKind::InvalidSchemeException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::InvalidSecurityGroupException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::InvalidSubnetException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::SubnetNotFoundException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::TooManyAccessPointsException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::UnsupportedProtocolException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLoadBalancerListeners` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLoadBalancerListenersError {
    /// Kind of error that occurred.
    pub kind: CreateLoadBalancerListenersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLoadBalancerListeners` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLoadBalancerListenersErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The specified ARN does not refer to a valid SSL certificate in AWS Identity and Access Management (IAM)
    /// or AWS Certificate Manager (ACM). Note that if you recently uploaded the certificate to IAM, this error might
    /// indicate that the certificate is not fully available yet.</p>
    CertificateNotFoundException(crate::error::CertificateNotFoundException),
    /// <p>A listener already exists for the specified load balancer name and port, but with a different instance port, protocol, or SSL certificate.</p>
    DuplicateListenerException(crate::error::DuplicateListenerException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The specified protocol or signature version is not supported.</p>
    UnsupportedProtocolException(crate::error::UnsupportedProtocolException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLoadBalancerListenersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLoadBalancerListenersErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerListenersErrorKind::CertificateNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerListenersErrorKind::DuplicateListenerException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerListenersErrorKind::InvalidConfigurationRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerListenersErrorKind::UnsupportedProtocolException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerListenersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLoadBalancerListenersError {
    fn code(&self) -> Option<&str> {
        CreateLoadBalancerListenersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLoadBalancerListenersError {
    /// Creates a new `CreateLoadBalancerListenersError`.
    pub fn new(kind: CreateLoadBalancerListenersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLoadBalancerListenersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLoadBalancerListenersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLoadBalancerListenersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLoadBalancerListenersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerListenersErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerListenersErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerListenersErrorKind::CertificateNotFoundException`.
    pub fn is_certificate_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerListenersErrorKind::CertificateNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerListenersErrorKind::DuplicateListenerException`.
    pub fn is_duplicate_listener_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerListenersErrorKind::DuplicateListenerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerListenersErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerListenersErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerListenersErrorKind::UnsupportedProtocolException`.
    pub fn is_unsupported_protocol_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerListenersErrorKind::UnsupportedProtocolException(_)
        )
    }
}
impl std::error::Error for CreateLoadBalancerListenersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLoadBalancerListenersErrorKind::AccessPointNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerListenersErrorKind::CertificateNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerListenersErrorKind::DuplicateListenerException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerListenersErrorKind::InvalidConfigurationRequestException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerListenersErrorKind::UnsupportedProtocolException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerListenersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLoadBalancerPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLoadBalancerPolicyError {
    /// Kind of error that occurred.
    pub kind: CreateLoadBalancerPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLoadBalancerPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLoadBalancerPolicyErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>A policy with the specified name already exists for this load balancer.</p>
    DuplicatePolicyNameException(crate::error::DuplicatePolicyNameException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>One or more of the specified policy types do not exist.</p>
    PolicyTypeNotFoundException(crate::error::PolicyTypeNotFoundException),
    /// <p>The quota for the number of policies for this load balancer has been reached.</p>
    TooManyPoliciesException(crate::error::TooManyPoliciesException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLoadBalancerPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLoadBalancerPolicyErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerPolicyErrorKind::DuplicatePolicyNameException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerPolicyErrorKind::InvalidConfigurationRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerPolicyErrorKind::PolicyTypeNotFoundException(_inner) => _inner.fmt(f),
            CreateLoadBalancerPolicyErrorKind::TooManyPoliciesException(_inner) => _inner.fmt(f),
            CreateLoadBalancerPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLoadBalancerPolicyError {
    fn code(&self) -> Option<&str> {
        CreateLoadBalancerPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLoadBalancerPolicyError {
    /// Creates a new `CreateLoadBalancerPolicyError`.
    pub fn new(kind: CreateLoadBalancerPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLoadBalancerPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLoadBalancerPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLoadBalancerPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLoadBalancerPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerPolicyErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerPolicyErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerPolicyErrorKind::DuplicatePolicyNameException`.
    pub fn is_duplicate_policy_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerPolicyErrorKind::DuplicatePolicyNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerPolicyErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerPolicyErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerPolicyErrorKind::PolicyTypeNotFoundException`.
    pub fn is_policy_type_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerPolicyErrorKind::PolicyTypeNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerPolicyErrorKind::TooManyPoliciesException`.
    pub fn is_too_many_policies_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerPolicyErrorKind::TooManyPoliciesException(_)
        )
    }
}
impl std::error::Error for CreateLoadBalancerPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLoadBalancerPolicyErrorKind::AccessPointNotFoundException(_inner) => Some(_inner),
            CreateLoadBalancerPolicyErrorKind::DuplicatePolicyNameException(_inner) => Some(_inner),
            CreateLoadBalancerPolicyErrorKind::InvalidConfigurationRequestException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerPolicyErrorKind::PolicyTypeNotFoundException(_inner) => Some(_inner),
            CreateLoadBalancerPolicyErrorKind::TooManyPoliciesException(_inner) => Some(_inner),
            CreateLoadBalancerPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: DeleteLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLoadBalancerErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLoadBalancerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLoadBalancerError {
    fn code(&self) -> Option<&str> {
        DeleteLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLoadBalancerError {
    /// Creates a new `DeleteLoadBalancerError`.
    pub fn new(kind: DeleteLoadBalancerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DeleteLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLoadBalancerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLoadBalancerListeners` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLoadBalancerListenersError {
    /// Kind of error that occurred.
    pub kind: DeleteLoadBalancerListenersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLoadBalancerListeners` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLoadBalancerListenersErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLoadBalancerListenersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLoadBalancerListenersErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoadBalancerListenersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLoadBalancerListenersError {
    fn code(&self) -> Option<&str> {
        DeleteLoadBalancerListenersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLoadBalancerListenersError {
    /// Creates a new `DeleteLoadBalancerListenersError`.
    pub fn new(kind: DeleteLoadBalancerListenersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLoadBalancerListenersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLoadBalancerListenersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLoadBalancerListenersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLoadBalancerListenersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerListenersErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerListenersErrorKind::AccessPointNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteLoadBalancerListenersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLoadBalancerListenersErrorKind::AccessPointNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteLoadBalancerListenersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLoadBalancerPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLoadBalancerPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteLoadBalancerPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLoadBalancerPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLoadBalancerPolicyErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLoadBalancerPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLoadBalancerPolicyErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoadBalancerPolicyErrorKind::InvalidConfigurationRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoadBalancerPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLoadBalancerPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteLoadBalancerPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLoadBalancerPolicyError {
    /// Creates a new `DeleteLoadBalancerPolicyError`.
    pub fn new(kind: DeleteLoadBalancerPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLoadBalancerPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLoadBalancerPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLoadBalancerPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLoadBalancerPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerPolicyErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerPolicyErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerPolicyErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerPolicyErrorKind::InvalidConfigurationRequestException(_)
        )
    }
}
impl std::error::Error for DeleteLoadBalancerPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLoadBalancerPolicyErrorKind::AccessPointNotFoundException(_inner) => Some(_inner),
            DeleteLoadBalancerPolicyErrorKind::InvalidConfigurationRequestException(_inner) => {
                Some(_inner)
            }
            DeleteLoadBalancerPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterInstancesFromLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterInstancesFromLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: DeregisterInstancesFromLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterInstancesFromLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterInstancesFromLoadBalancerErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The specified endpoint is not valid.</p>
    InvalidEndPointException(crate::error::InvalidEndPointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterInstancesFromLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterInstancesFromLoadBalancerErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterInstancesFromLoadBalancerErrorKind::InvalidEndPointException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterInstancesFromLoadBalancerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterInstancesFromLoadBalancerError {
    fn code(&self) -> Option<&str> {
        DeregisterInstancesFromLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterInstancesFromLoadBalancerError {
    /// Creates a new `DeregisterInstancesFromLoadBalancerError`.
    pub fn new(
        kind: DeregisterInstancesFromLoadBalancerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterInstancesFromLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterInstancesFromLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterInstancesFromLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterInstancesFromLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterInstancesFromLoadBalancerErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterInstancesFromLoadBalancerErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterInstancesFromLoadBalancerErrorKind::InvalidEndPointException`.
    pub fn is_invalid_end_point_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterInstancesFromLoadBalancerErrorKind::InvalidEndPointException(_)
        )
    }
}
impl std::error::Error for DeregisterInstancesFromLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterInstancesFromLoadBalancerErrorKind::AccessPointNotFoundException(_inner) => {
                Some(_inner)
            }
            DeregisterInstancesFromLoadBalancerErrorKind::InvalidEndPointException(_inner) => {
                Some(_inner)
            }
            DeregisterInstancesFromLoadBalancerErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeAccountLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountLimitsError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountLimitsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountLimitsError {
    fn code(&self) -> Option<&str> {
        DescribeAccountLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountLimitsError {
    /// Creates a new `DescribeAccountLimitsError`.
    pub fn new(kind: DescribeAccountLimitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountLimitsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeAccountLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountLimitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInstanceHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstanceHealthError {
    /// Kind of error that occurred.
    pub kind: DescribeInstanceHealthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstanceHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstanceHealthErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The specified endpoint is not valid.</p>
    InvalidEndPointException(crate::error::InvalidEndPointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstanceHealthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstanceHealthErrorKind::AccessPointNotFoundException(_inner) => _inner.fmt(f),
            DescribeInstanceHealthErrorKind::InvalidEndPointException(_inner) => _inner.fmt(f),
            DescribeInstanceHealthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstanceHealthError {
    fn code(&self) -> Option<&str> {
        DescribeInstanceHealthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstanceHealthError {
    /// Creates a new `DescribeInstanceHealthError`.
    pub fn new(kind: DescribeInstanceHealthErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstanceHealthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstanceHealthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstanceHealthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstanceHealthErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInstanceHealthErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceHealthErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceHealthErrorKind::InvalidEndPointException`.
    pub fn is_invalid_end_point_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceHealthErrorKind::InvalidEndPointException(_)
        )
    }
}
impl std::error::Error for DescribeInstanceHealthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstanceHealthErrorKind::AccessPointNotFoundException(_inner) => Some(_inner),
            DescribeInstanceHealthErrorKind::InvalidEndPointException(_inner) => Some(_inner),
            DescribeInstanceHealthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLoadBalancerAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLoadBalancerAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeLoadBalancerAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLoadBalancerAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLoadBalancerAttributesErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The specified load balancer attribute does not exist.</p>
    LoadBalancerAttributeNotFoundException(crate::error::LoadBalancerAttributeNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLoadBalancerAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLoadBalancerAttributesErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeLoadBalancerAttributesErrorKind::LoadBalancerAttributeNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DescribeLoadBalancerAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLoadBalancerAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeLoadBalancerAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLoadBalancerAttributesError {
    /// Creates a new `DescribeLoadBalancerAttributesError`.
    pub fn new(
        kind: DescribeLoadBalancerAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLoadBalancerAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLoadBalancerAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLoadBalancerAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLoadBalancerAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLoadBalancerAttributesErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoadBalancerAttributesErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLoadBalancerAttributesErrorKind::LoadBalancerAttributeNotFoundException`.
    pub fn is_load_balancer_attribute_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoadBalancerAttributesErrorKind::LoadBalancerAttributeNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeLoadBalancerAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLoadBalancerAttributesErrorKind::AccessPointNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeLoadBalancerAttributesErrorKind::LoadBalancerAttributeNotFoundException(
                _inner,
            ) => Some(_inner),
            DescribeLoadBalancerAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLoadBalancerPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLoadBalancerPoliciesError {
    /// Kind of error that occurred.
    pub kind: DescribeLoadBalancerPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLoadBalancerPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLoadBalancerPoliciesErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>One or more of the specified policies do not exist.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLoadBalancerPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLoadBalancerPoliciesErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeLoadBalancerPoliciesErrorKind::PolicyNotFoundException(_inner) => _inner.fmt(f),
            DescribeLoadBalancerPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLoadBalancerPoliciesError {
    fn code(&self) -> Option<&str> {
        DescribeLoadBalancerPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLoadBalancerPoliciesError {
    /// Creates a new `DescribeLoadBalancerPoliciesError`.
    pub fn new(kind: DescribeLoadBalancerPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLoadBalancerPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLoadBalancerPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLoadBalancerPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLoadBalancerPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLoadBalancerPoliciesErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoadBalancerPoliciesErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLoadBalancerPoliciesErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoadBalancerPoliciesErrorKind::PolicyNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeLoadBalancerPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLoadBalancerPoliciesErrorKind::AccessPointNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeLoadBalancerPoliciesErrorKind::PolicyNotFoundException(_inner) => Some(_inner),
            DescribeLoadBalancerPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLoadBalancerPolicyTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLoadBalancerPolicyTypesError {
    /// Kind of error that occurred.
    pub kind: DescribeLoadBalancerPolicyTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLoadBalancerPolicyTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLoadBalancerPolicyTypesErrorKind {
    /// <p>One or more of the specified policy types do not exist.</p>
    PolicyTypeNotFoundException(crate::error::PolicyTypeNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLoadBalancerPolicyTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLoadBalancerPolicyTypesErrorKind::PolicyTypeNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeLoadBalancerPolicyTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLoadBalancerPolicyTypesError {
    fn code(&self) -> Option<&str> {
        DescribeLoadBalancerPolicyTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLoadBalancerPolicyTypesError {
    /// Creates a new `DescribeLoadBalancerPolicyTypesError`.
    pub fn new(
        kind: DescribeLoadBalancerPolicyTypesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLoadBalancerPolicyTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLoadBalancerPolicyTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLoadBalancerPolicyTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLoadBalancerPolicyTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLoadBalancerPolicyTypesErrorKind::PolicyTypeNotFoundException`.
    pub fn is_policy_type_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoadBalancerPolicyTypesErrorKind::PolicyTypeNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeLoadBalancerPolicyTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLoadBalancerPolicyTypesErrorKind::PolicyTypeNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeLoadBalancerPolicyTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLoadBalancers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLoadBalancersError {
    /// Kind of error that occurred.
    pub kind: DescribeLoadBalancersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLoadBalancers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLoadBalancersErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>A request made by Elastic Load Balancing to another service exceeds the maximum request rate permitted for your account.</p>
    DependencyThrottleException(crate::error::DependencyThrottleException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLoadBalancersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLoadBalancersErrorKind::AccessPointNotFoundException(_inner) => _inner.fmt(f),
            DescribeLoadBalancersErrorKind::DependencyThrottleException(_inner) => _inner.fmt(f),
            DescribeLoadBalancersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLoadBalancersError {
    fn code(&self) -> Option<&str> {
        DescribeLoadBalancersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLoadBalancersError {
    /// Creates a new `DescribeLoadBalancersError`.
    pub fn new(kind: DescribeLoadBalancersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLoadBalancersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLoadBalancersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLoadBalancersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLoadBalancersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLoadBalancersErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoadBalancersErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLoadBalancersErrorKind::DependencyThrottleException`.
    pub fn is_dependency_throttle_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoadBalancersErrorKind::DependencyThrottleException(_)
        )
    }
}
impl std::error::Error for DescribeLoadBalancersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLoadBalancersErrorKind::AccessPointNotFoundException(_inner) => Some(_inner),
            DescribeLoadBalancersErrorKind::DependencyThrottleException(_inner) => Some(_inner),
            DescribeLoadBalancersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTagsError {
    /// Kind of error that occurred.
    pub kind: DescribeTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTagsErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTagsErrorKind::AccessPointNotFoundException(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTagsError {
    fn code(&self) -> Option<&str> {
        DescribeTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTagsError {
    /// Creates a new `DescribeTagsError`.
    pub fn new(kind: DescribeTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTagsErrorKind::AccessPointNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTagsErrorKind::AccessPointNotFoundException(_inner) => Some(_inner),
            DescribeTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachLoadBalancerFromSubnets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachLoadBalancerFromSubnetsError {
    /// Kind of error that occurred.
    pub kind: DetachLoadBalancerFromSubnetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachLoadBalancerFromSubnets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachLoadBalancerFromSubnetsErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachLoadBalancerFromSubnetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachLoadBalancerFromSubnetsErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DetachLoadBalancerFromSubnetsErrorKind::InvalidConfigurationRequestException(
                _inner,
            ) => _inner.fmt(f),
            DetachLoadBalancerFromSubnetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachLoadBalancerFromSubnetsError {
    fn code(&self) -> Option<&str> {
        DetachLoadBalancerFromSubnetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachLoadBalancerFromSubnetsError {
    /// Creates a new `DetachLoadBalancerFromSubnetsError`.
    pub fn new(
        kind: DetachLoadBalancerFromSubnetsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachLoadBalancerFromSubnetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachLoadBalancerFromSubnetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachLoadBalancerFromSubnetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachLoadBalancerFromSubnetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachLoadBalancerFromSubnetsErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachLoadBalancerFromSubnetsErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachLoadBalancerFromSubnetsErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachLoadBalancerFromSubnetsErrorKind::InvalidConfigurationRequestException(_)
        )
    }
}
impl std::error::Error for DetachLoadBalancerFromSubnetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachLoadBalancerFromSubnetsErrorKind::AccessPointNotFoundException(_inner) => {
                Some(_inner)
            }
            DetachLoadBalancerFromSubnetsErrorKind::InvalidConfigurationRequestException(
                _inner,
            ) => Some(_inner),
            DetachLoadBalancerFromSubnetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableAvailabilityZonesForLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableAvailabilityZonesForLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: DisableAvailabilityZonesForLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableAvailabilityZonesForLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableAvailabilityZonesForLoadBalancerErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableAvailabilityZonesForLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableAvailabilityZonesForLoadBalancerErrorKind::AccessPointNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            DisableAvailabilityZonesForLoadBalancerErrorKind::InvalidConfigurationRequestException(_inner) =>
            _inner.fmt(f)
            ,
            DisableAvailabilityZonesForLoadBalancerErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableAvailabilityZonesForLoadBalancerError {
    fn code(&self) -> Option<&str> {
        DisableAvailabilityZonesForLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableAvailabilityZonesForLoadBalancerError {
    /// Creates a new `DisableAvailabilityZonesForLoadBalancerError`.
    pub fn new(
        kind: DisableAvailabilityZonesForLoadBalancerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableAvailabilityZonesForLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableAvailabilityZonesForLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableAvailabilityZonesForLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableAvailabilityZonesForLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableAvailabilityZonesForLoadBalancerErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAvailabilityZonesForLoadBalancerErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableAvailabilityZonesForLoadBalancerErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAvailabilityZonesForLoadBalancerErrorKind::InvalidConfigurationRequestException(
                _
            )
        )
    }
}
impl std::error::Error for DisableAvailabilityZonesForLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableAvailabilityZonesForLoadBalancerErrorKind::AccessPointNotFoundException(_inner) =>
            Some(_inner)
            ,
            DisableAvailabilityZonesForLoadBalancerErrorKind::InvalidConfigurationRequestException(_inner) =>
            Some(_inner)
            ,
            DisableAvailabilityZonesForLoadBalancerErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `EnableAvailabilityZonesForLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableAvailabilityZonesForLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: EnableAvailabilityZonesForLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableAvailabilityZonesForLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableAvailabilityZonesForLoadBalancerErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableAvailabilityZonesForLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableAvailabilityZonesForLoadBalancerErrorKind::AccessPointNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            EnableAvailabilityZonesForLoadBalancerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableAvailabilityZonesForLoadBalancerError {
    fn code(&self) -> Option<&str> {
        EnableAvailabilityZonesForLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableAvailabilityZonesForLoadBalancerError {
    /// Creates a new `EnableAvailabilityZonesForLoadBalancerError`.
    pub fn new(
        kind: EnableAvailabilityZonesForLoadBalancerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableAvailabilityZonesForLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableAvailabilityZonesForLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableAvailabilityZonesForLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableAvailabilityZonesForLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableAvailabilityZonesForLoadBalancerErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAvailabilityZonesForLoadBalancerErrorKind::AccessPointNotFoundException(_)
        )
    }
}
impl std::error::Error for EnableAvailabilityZonesForLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableAvailabilityZonesForLoadBalancerErrorKind::AccessPointNotFoundException(
                _inner,
            ) => Some(_inner),
            EnableAvailabilityZonesForLoadBalancerErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ModifyLoadBalancerAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyLoadBalancerAttributesError {
    /// Kind of error that occurred.
    pub kind: ModifyLoadBalancerAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyLoadBalancerAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyLoadBalancerAttributesErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The specified load balancer attribute does not exist.</p>
    LoadBalancerAttributeNotFoundException(crate::error::LoadBalancerAttributeNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyLoadBalancerAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyLoadBalancerAttributesErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ModifyLoadBalancerAttributesErrorKind::InvalidConfigurationRequestException(_inner) => {
                _inner.fmt(f)
            }
            ModifyLoadBalancerAttributesErrorKind::LoadBalancerAttributeNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            ModifyLoadBalancerAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyLoadBalancerAttributesError {
    fn code(&self) -> Option<&str> {
        ModifyLoadBalancerAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyLoadBalancerAttributesError {
    /// Creates a new `ModifyLoadBalancerAttributesError`.
    pub fn new(kind: ModifyLoadBalancerAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyLoadBalancerAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyLoadBalancerAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyLoadBalancerAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyLoadBalancerAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyLoadBalancerAttributesErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyLoadBalancerAttributesErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyLoadBalancerAttributesErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyLoadBalancerAttributesErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyLoadBalancerAttributesErrorKind::LoadBalancerAttributeNotFoundException`.
    pub fn is_load_balancer_attribute_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyLoadBalancerAttributesErrorKind::LoadBalancerAttributeNotFoundException(_)
        )
    }
}
impl std::error::Error for ModifyLoadBalancerAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyLoadBalancerAttributesErrorKind::AccessPointNotFoundException(_inner) => {
                Some(_inner)
            }
            ModifyLoadBalancerAttributesErrorKind::InvalidConfigurationRequestException(_inner) => {
                Some(_inner)
            }
            ModifyLoadBalancerAttributesErrorKind::LoadBalancerAttributeNotFoundException(
                _inner,
            ) => Some(_inner),
            ModifyLoadBalancerAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterInstancesWithLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterInstancesWithLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: RegisterInstancesWithLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterInstancesWithLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterInstancesWithLoadBalancerErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The specified endpoint is not valid.</p>
    InvalidEndPointException(crate::error::InvalidEndPointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterInstancesWithLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterInstancesWithLoadBalancerErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            RegisterInstancesWithLoadBalancerErrorKind::InvalidEndPointException(_inner) => {
                _inner.fmt(f)
            }
            RegisterInstancesWithLoadBalancerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterInstancesWithLoadBalancerError {
    fn code(&self) -> Option<&str> {
        RegisterInstancesWithLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterInstancesWithLoadBalancerError {
    /// Creates a new `RegisterInstancesWithLoadBalancerError`.
    pub fn new(
        kind: RegisterInstancesWithLoadBalancerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterInstancesWithLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterInstancesWithLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterInstancesWithLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterInstancesWithLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterInstancesWithLoadBalancerErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterInstancesWithLoadBalancerErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterInstancesWithLoadBalancerErrorKind::InvalidEndPointException`.
    pub fn is_invalid_end_point_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterInstancesWithLoadBalancerErrorKind::InvalidEndPointException(_)
        )
    }
}
impl std::error::Error for RegisterInstancesWithLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterInstancesWithLoadBalancerErrorKind::AccessPointNotFoundException(_inner) => {
                Some(_inner)
            }
            RegisterInstancesWithLoadBalancerErrorKind::InvalidEndPointException(_inner) => {
                Some(_inner)
            }
            RegisterInstancesWithLoadBalancerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsErrorKind::AccessPointNotFoundException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsError {
    fn code(&self) -> Option<&str> {
        RemoveTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsError {
    /// Creates a new `RemoveTagsError`.
    pub fn new(kind: RemoveTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::AccessPointNotFoundException(_)
        )
    }
}
impl std::error::Error for RemoveTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsErrorKind::AccessPointNotFoundException(_inner) => Some(_inner),
            RemoveTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetLoadBalancerListenerSSLCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetLoadBalancerListenerSSLCertificateError {
    /// Kind of error that occurred.
    pub kind: SetLoadBalancerListenerSSLCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetLoadBalancerListenerSSLCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetLoadBalancerListenerSSLCertificateErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The specified ARN does not refer to a valid SSL certificate in AWS Identity and Access Management (IAM)
    /// or AWS Certificate Manager (ACM). Note that if you recently uploaded the certificate to IAM, this error might
    /// indicate that the certificate is not fully available yet.</p>
    CertificateNotFoundException(crate::error::CertificateNotFoundException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The load balancer does not have a listener configured at the specified port.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// <p>The specified protocol or signature version is not supported.</p>
    UnsupportedProtocolException(crate::error::UnsupportedProtocolException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetLoadBalancerListenerSSLCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetLoadBalancerListenerSSLCertificateErrorKind::AccessPointNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            SetLoadBalancerListenerSSLCertificateErrorKind::CertificateNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            SetLoadBalancerListenerSSLCertificateErrorKind::InvalidConfigurationRequestException(_inner) =>
            _inner.fmt(f)
            ,
            SetLoadBalancerListenerSSLCertificateErrorKind::ListenerNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            SetLoadBalancerListenerSSLCertificateErrorKind::UnsupportedProtocolException(_inner) =>
            _inner.fmt(f)
            ,
            SetLoadBalancerListenerSSLCertificateErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetLoadBalancerListenerSSLCertificateError {
    fn code(&self) -> Option<&str> {
        SetLoadBalancerListenerSSLCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetLoadBalancerListenerSSLCertificateError {
    /// Creates a new `SetLoadBalancerListenerSSLCertificateError`.
    pub fn new(
        kind: SetLoadBalancerListenerSSLCertificateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetLoadBalancerListenerSSLCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetLoadBalancerListenerSSLCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetLoadBalancerListenerSSLCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetLoadBalancerListenerSSLCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetLoadBalancerListenerSSLCertificateErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetLoadBalancerListenerSSLCertificateErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetLoadBalancerListenerSSLCertificateErrorKind::CertificateNotFoundException`.
    pub fn is_certificate_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetLoadBalancerListenerSSLCertificateErrorKind::CertificateNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetLoadBalancerListenerSSLCertificateErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetLoadBalancerListenerSSLCertificateErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `SetLoadBalancerListenerSSLCertificateErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetLoadBalancerListenerSSLCertificateErrorKind::ListenerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetLoadBalancerListenerSSLCertificateErrorKind::UnsupportedProtocolException`.
    pub fn is_unsupported_protocol_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetLoadBalancerListenerSSLCertificateErrorKind::UnsupportedProtocolException(_)
        )
    }
}
impl std::error::Error for SetLoadBalancerListenerSSLCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetLoadBalancerListenerSSLCertificateErrorKind::AccessPointNotFoundException(_inner) =>
            Some(_inner)
            ,
            SetLoadBalancerListenerSSLCertificateErrorKind::CertificateNotFoundException(_inner) =>
            Some(_inner)
            ,
            SetLoadBalancerListenerSSLCertificateErrorKind::InvalidConfigurationRequestException(_inner) =>
            Some(_inner)
            ,
            SetLoadBalancerListenerSSLCertificateErrorKind::ListenerNotFoundException(_inner) =>
            Some(_inner)
            ,
            SetLoadBalancerListenerSSLCertificateErrorKind::UnsupportedProtocolException(_inner) =>
            Some(_inner)
            ,
            SetLoadBalancerListenerSSLCertificateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `SetLoadBalancerPoliciesForBackendServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetLoadBalancerPoliciesForBackendServerError {
    /// Kind of error that occurred.
    pub kind: SetLoadBalancerPoliciesForBackendServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetLoadBalancerPoliciesForBackendServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetLoadBalancerPoliciesForBackendServerErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>One or more of the specified policies do not exist.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetLoadBalancerPoliciesForBackendServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetLoadBalancerPoliciesForBackendServerErrorKind::AccessPointNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            SetLoadBalancerPoliciesForBackendServerErrorKind::InvalidConfigurationRequestException(_inner) =>
            _inner.fmt(f)
            ,
            SetLoadBalancerPoliciesForBackendServerErrorKind::PolicyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            SetLoadBalancerPoliciesForBackendServerErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetLoadBalancerPoliciesForBackendServerError {
    fn code(&self) -> Option<&str> {
        SetLoadBalancerPoliciesForBackendServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetLoadBalancerPoliciesForBackendServerError {
    /// Creates a new `SetLoadBalancerPoliciesForBackendServerError`.
    pub fn new(
        kind: SetLoadBalancerPoliciesForBackendServerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetLoadBalancerPoliciesForBackendServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetLoadBalancerPoliciesForBackendServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetLoadBalancerPoliciesForBackendServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetLoadBalancerPoliciesForBackendServerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetLoadBalancerPoliciesForBackendServerErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetLoadBalancerPoliciesForBackendServerErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetLoadBalancerPoliciesForBackendServerErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetLoadBalancerPoliciesForBackendServerErrorKind::InvalidConfigurationRequestException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `SetLoadBalancerPoliciesForBackendServerErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetLoadBalancerPoliciesForBackendServerErrorKind::PolicyNotFoundException(_)
        )
    }
}
impl std::error::Error for SetLoadBalancerPoliciesForBackendServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetLoadBalancerPoliciesForBackendServerErrorKind::AccessPointNotFoundException(_inner) =>
            Some(_inner)
            ,
            SetLoadBalancerPoliciesForBackendServerErrorKind::InvalidConfigurationRequestException(_inner) =>
            Some(_inner)
            ,
            SetLoadBalancerPoliciesForBackendServerErrorKind::PolicyNotFoundException(_inner) =>
            Some(_inner)
            ,
            SetLoadBalancerPoliciesForBackendServerErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `SetLoadBalancerPoliciesOfListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetLoadBalancerPoliciesOfListenerError {
    /// Kind of error that occurred.
    pub kind: SetLoadBalancerPoliciesOfListenerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetLoadBalancerPoliciesOfListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetLoadBalancerPoliciesOfListenerErrorKind {
    /// <p>The specified load balancer does not exist.</p>
    AccessPointNotFoundException(crate::error::AccessPointNotFoundException),
    /// <p>The requested configuration change is not valid.</p>
    InvalidConfigurationRequestException(crate::error::InvalidConfigurationRequestException),
    /// <p>The load balancer does not have a listener configured at the specified port.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// <p>One or more of the specified policies do not exist.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetLoadBalancerPoliciesOfListenerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetLoadBalancerPoliciesOfListenerErrorKind::AccessPointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            SetLoadBalancerPoliciesOfListenerErrorKind::InvalidConfigurationRequestException(
                _inner,
            ) => _inner.fmt(f),
            SetLoadBalancerPoliciesOfListenerErrorKind::ListenerNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            SetLoadBalancerPoliciesOfListenerErrorKind::PolicyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            SetLoadBalancerPoliciesOfListenerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetLoadBalancerPoliciesOfListenerError {
    fn code(&self) -> Option<&str> {
        SetLoadBalancerPoliciesOfListenerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetLoadBalancerPoliciesOfListenerError {
    /// Creates a new `SetLoadBalancerPoliciesOfListenerError`.
    pub fn new(
        kind: SetLoadBalancerPoliciesOfListenerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetLoadBalancerPoliciesOfListenerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetLoadBalancerPoliciesOfListenerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetLoadBalancerPoliciesOfListenerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetLoadBalancerPoliciesOfListenerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetLoadBalancerPoliciesOfListenerErrorKind::AccessPointNotFoundException`.
    pub fn is_access_point_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetLoadBalancerPoliciesOfListenerErrorKind::AccessPointNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetLoadBalancerPoliciesOfListenerErrorKind::InvalidConfigurationRequestException`.
    pub fn is_invalid_configuration_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetLoadBalancerPoliciesOfListenerErrorKind::InvalidConfigurationRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `SetLoadBalancerPoliciesOfListenerErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetLoadBalancerPoliciesOfListenerErrorKind::ListenerNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetLoadBalancerPoliciesOfListenerErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetLoadBalancerPoliciesOfListenerErrorKind::PolicyNotFoundException(_)
        )
    }
}
impl std::error::Error for SetLoadBalancerPoliciesOfListenerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetLoadBalancerPoliciesOfListenerErrorKind::AccessPointNotFoundException(_inner) => {
                Some(_inner)
            }
            SetLoadBalancerPoliciesOfListenerErrorKind::InvalidConfigurationRequestException(
                _inner,
            ) => Some(_inner),
            SetLoadBalancerPoliciesOfListenerErrorKind::ListenerNotFoundException(_inner) => {
                Some(_inner)
            }
            SetLoadBalancerPoliciesOfListenerErrorKind::PolicyNotFoundException(_inner) => {
                Some(_inner)
            }
            SetLoadBalancerPoliciesOfListenerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>One or more of the specified policies do not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyNotFoundException {}
/// See [`PolicyNotFoundException`](crate::error::PolicyNotFoundException)
pub mod policy_not_found_exception {
    /// A builder for [`PolicyNotFoundException`](crate::error::PolicyNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyNotFoundException`](crate::error::PolicyNotFoundException)
        pub fn build(self) -> crate::error::PolicyNotFoundException {
            crate::error::PolicyNotFoundException {
                message: self.message,
            }
        }
    }
}
impl PolicyNotFoundException {
    /// Creates a new builder-style object to manufacture [`PolicyNotFoundException`](crate::error::PolicyNotFoundException)
    pub fn builder() -> crate::error::policy_not_found_exception::Builder {
        crate::error::policy_not_found_exception::Builder::default()
    }
}

/// <p>The load balancer does not have a listener configured at the specified port.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListenerNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListenerNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListenerNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ListenerNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ListenerNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ListenerNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ListenerNotFoundException {}
/// See [`ListenerNotFoundException`](crate::error::ListenerNotFoundException)
pub mod listener_not_found_exception {
    /// A builder for [`ListenerNotFoundException`](crate::error::ListenerNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ListenerNotFoundException`](crate::error::ListenerNotFoundException)
        pub fn build(self) -> crate::error::ListenerNotFoundException {
            crate::error::ListenerNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ListenerNotFoundException {
    /// Creates a new builder-style object to manufacture [`ListenerNotFoundException`](crate::error::ListenerNotFoundException)
    pub fn builder() -> crate::error::listener_not_found_exception::Builder {
        crate::error::listener_not_found_exception::Builder::default()
    }
}

/// <p>The requested configuration change is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidConfigurationRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidConfigurationRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidConfigurationRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidConfigurationRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidConfigurationRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidConfigurationRequestException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidConfigurationRequestException {}
/// See [`InvalidConfigurationRequestException`](crate::error::InvalidConfigurationRequestException)
pub mod invalid_configuration_request_exception {
    /// A builder for [`InvalidConfigurationRequestException`](crate::error::InvalidConfigurationRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidConfigurationRequestException`](crate::error::InvalidConfigurationRequestException)
        pub fn build(self) -> crate::error::InvalidConfigurationRequestException {
            crate::error::InvalidConfigurationRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidConfigurationRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidConfigurationRequestException`](crate::error::InvalidConfigurationRequestException)
    pub fn builder() -> crate::error::invalid_configuration_request_exception::Builder {
        crate::error::invalid_configuration_request_exception::Builder::default()
    }
}

/// <p>The specified load balancer does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessPointNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessPointNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessPointNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessPointNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessPointNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessPointNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessPointNotFoundException {}
/// See [`AccessPointNotFoundException`](crate::error::AccessPointNotFoundException)
pub mod access_point_not_found_exception {
    /// A builder for [`AccessPointNotFoundException`](crate::error::AccessPointNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessPointNotFoundException`](crate::error::AccessPointNotFoundException)
        pub fn build(self) -> crate::error::AccessPointNotFoundException {
            crate::error::AccessPointNotFoundException {
                message: self.message,
            }
        }
    }
}
impl AccessPointNotFoundException {
    /// Creates a new builder-style object to manufacture [`AccessPointNotFoundException`](crate::error::AccessPointNotFoundException)
    pub fn builder() -> crate::error::access_point_not_found_exception::Builder {
        crate::error::access_point_not_found_exception::Builder::default()
    }
}

/// <p>The specified protocol or signature version is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedProtocolException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedProtocolException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedProtocolException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedProtocolException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedProtocolException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedProtocolException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedProtocolException {}
/// See [`UnsupportedProtocolException`](crate::error::UnsupportedProtocolException)
pub mod unsupported_protocol_exception {
    /// A builder for [`UnsupportedProtocolException`](crate::error::UnsupportedProtocolException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedProtocolException`](crate::error::UnsupportedProtocolException)
        pub fn build(self) -> crate::error::UnsupportedProtocolException {
            crate::error::UnsupportedProtocolException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedProtocolException {
    /// Creates a new builder-style object to manufacture [`UnsupportedProtocolException`](crate::error::UnsupportedProtocolException)
    pub fn builder() -> crate::error::unsupported_protocol_exception::Builder {
        crate::error::unsupported_protocol_exception::Builder::default()
    }
}

/// <p>The specified ARN does not refer to a valid SSL certificate in AWS Identity and Access Management (IAM)
/// or AWS Certificate Manager (ACM). Note that if you recently uploaded the certificate to IAM, this error might
/// indicate that the certificate is not fully available yet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CertificateNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CertificateNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CertificateNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CertificateNotFoundException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for CertificateNotFoundException {}
/// See [`CertificateNotFoundException`](crate::error::CertificateNotFoundException)
pub mod certificate_not_found_exception {
    /// A builder for [`CertificateNotFoundException`](crate::error::CertificateNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateNotFoundException`](crate::error::CertificateNotFoundException)
        pub fn build(self) -> crate::error::CertificateNotFoundException {
            crate::error::CertificateNotFoundException {
                message: self.message,
            }
        }
    }
}
impl CertificateNotFoundException {
    /// Creates a new builder-style object to manufacture [`CertificateNotFoundException`](crate::error::CertificateNotFoundException)
    pub fn builder() -> crate::error::certificate_not_found_exception::Builder {
        crate::error::certificate_not_found_exception::Builder::default()
    }
}

/// <p>The specified endpoint is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidEndPointException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidEndPointException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidEndPointException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidEndPointException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidEndPointException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidEndPointException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidEndPointException {}
/// See [`InvalidEndPointException`](crate::error::InvalidEndPointException)
pub mod invalid_end_point_exception {
    /// A builder for [`InvalidEndPointException`](crate::error::InvalidEndPointException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidEndPointException`](crate::error::InvalidEndPointException)
        pub fn build(self) -> crate::error::InvalidEndPointException {
            crate::error::InvalidEndPointException {
                message: self.message,
            }
        }
    }
}
impl InvalidEndPointException {
    /// Creates a new builder-style object to manufacture [`InvalidEndPointException`](crate::error::InvalidEndPointException)
    pub fn builder() -> crate::error::invalid_end_point_exception::Builder {
        crate::error::invalid_end_point_exception::Builder::default()
    }
}

/// <p>The specified load balancer attribute does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancerAttributeNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LoadBalancerAttributeNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancerAttributeNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LoadBalancerAttributeNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LoadBalancerAttributeNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LoadBalancerAttributeNotFoundException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for LoadBalancerAttributeNotFoundException {}
/// See [`LoadBalancerAttributeNotFoundException`](crate::error::LoadBalancerAttributeNotFoundException)
pub mod load_balancer_attribute_not_found_exception {
    /// A builder for [`LoadBalancerAttributeNotFoundException`](crate::error::LoadBalancerAttributeNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancerAttributeNotFoundException`](crate::error::LoadBalancerAttributeNotFoundException)
        pub fn build(self) -> crate::error::LoadBalancerAttributeNotFoundException {
            crate::error::LoadBalancerAttributeNotFoundException {
                message: self.message,
            }
        }
    }
}
impl LoadBalancerAttributeNotFoundException {
    /// Creates a new builder-style object to manufacture [`LoadBalancerAttributeNotFoundException`](crate::error::LoadBalancerAttributeNotFoundException)
    pub fn builder() -> crate::error::load_balancer_attribute_not_found_exception::Builder {
        crate::error::load_balancer_attribute_not_found_exception::Builder::default()
    }
}

/// <p>A request made by Elastic Load Balancing to another service exceeds the maximum request rate permitted for your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DependencyThrottleException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DependencyThrottleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DependencyThrottleException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DependencyThrottleException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DependencyThrottleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DependencyThrottleException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for DependencyThrottleException {}
/// See [`DependencyThrottleException`](crate::error::DependencyThrottleException)
pub mod dependency_throttle_exception {
    /// A builder for [`DependencyThrottleException`](crate::error::DependencyThrottleException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DependencyThrottleException`](crate::error::DependencyThrottleException)
        pub fn build(self) -> crate::error::DependencyThrottleException {
            crate::error::DependencyThrottleException {
                message: self.message,
            }
        }
    }
}
impl DependencyThrottleException {
    /// Creates a new builder-style object to manufacture [`DependencyThrottleException`](crate::error::DependencyThrottleException)
    pub fn builder() -> crate::error::dependency_throttle_exception::Builder {
        crate::error::dependency_throttle_exception::Builder::default()
    }
}

/// <p>One or more of the specified policy types do not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyTypeNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyTypeNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyTypeNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyTypeNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyTypeNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyTypeNotFoundException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyTypeNotFoundException {}
/// See [`PolicyTypeNotFoundException`](crate::error::PolicyTypeNotFoundException)
pub mod policy_type_not_found_exception {
    /// A builder for [`PolicyTypeNotFoundException`](crate::error::PolicyTypeNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyTypeNotFoundException`](crate::error::PolicyTypeNotFoundException)
        pub fn build(self) -> crate::error::PolicyTypeNotFoundException {
            crate::error::PolicyTypeNotFoundException {
                message: self.message,
            }
        }
    }
}
impl PolicyTypeNotFoundException {
    /// Creates a new builder-style object to manufacture [`PolicyTypeNotFoundException`](crate::error::PolicyTypeNotFoundException)
    pub fn builder() -> crate::error::policy_type_not_found_exception::Builder {
        crate::error::policy_type_not_found_exception::Builder::default()
    }
}

/// <p>The quota for the number of policies for this load balancer has been reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyPoliciesException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyPoliciesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyPoliciesException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyPoliciesException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyPoliciesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyPoliciesException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyPoliciesException {}
/// See [`TooManyPoliciesException`](crate::error::TooManyPoliciesException)
pub mod too_many_policies_exception {
    /// A builder for [`TooManyPoliciesException`](crate::error::TooManyPoliciesException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyPoliciesException`](crate::error::TooManyPoliciesException)
        pub fn build(self) -> crate::error::TooManyPoliciesException {
            crate::error::TooManyPoliciesException {
                message: self.message,
            }
        }
    }
}
impl TooManyPoliciesException {
    /// Creates a new builder-style object to manufacture [`TooManyPoliciesException`](crate::error::TooManyPoliciesException)
    pub fn builder() -> crate::error::too_many_policies_exception::Builder {
        crate::error::too_many_policies_exception::Builder::default()
    }
}

/// <p>A policy with the specified name already exists for this load balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicatePolicyNameException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicatePolicyNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicatePolicyNameException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicatePolicyNameException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicatePolicyNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicatePolicyNameException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicatePolicyNameException {}
/// See [`DuplicatePolicyNameException`](crate::error::DuplicatePolicyNameException)
pub mod duplicate_policy_name_exception {
    /// A builder for [`DuplicatePolicyNameException`](crate::error::DuplicatePolicyNameException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicatePolicyNameException`](crate::error::DuplicatePolicyNameException)
        pub fn build(self) -> crate::error::DuplicatePolicyNameException {
            crate::error::DuplicatePolicyNameException {
                message: self.message,
            }
        }
    }
}
impl DuplicatePolicyNameException {
    /// Creates a new builder-style object to manufacture [`DuplicatePolicyNameException`](crate::error::DuplicatePolicyNameException)
    pub fn builder() -> crate::error::duplicate_policy_name_exception::Builder {
        crate::error::duplicate_policy_name_exception::Builder::default()
    }
}

/// <p>A listener already exists for the specified load balancer name and port, but with a different instance port, protocol, or SSL certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateListenerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateListenerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateListenerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateListenerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateListenerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateListenerException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateListenerException {}
/// See [`DuplicateListenerException`](crate::error::DuplicateListenerException)
pub mod duplicate_listener_exception {
    /// A builder for [`DuplicateListenerException`](crate::error::DuplicateListenerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateListenerException`](crate::error::DuplicateListenerException)
        pub fn build(self) -> crate::error::DuplicateListenerException {
            crate::error::DuplicateListenerException {
                message: self.message,
            }
        }
    }
}
impl DuplicateListenerException {
    /// Creates a new builder-style object to manufacture [`DuplicateListenerException`](crate::error::DuplicateListenerException)
    pub fn builder() -> crate::error::duplicate_listener_exception::Builder {
        crate::error::duplicate_listener_exception::Builder::default()
    }
}

/// <p>The quota for the number of tags that can be assigned to a load balancer has been reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The quota for the number of load balancers has been reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyAccessPointsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyAccessPointsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyAccessPointsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyAccessPointsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyAccessPointsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyAccessPointsException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyAccessPointsException {}
/// See [`TooManyAccessPointsException`](crate::error::TooManyAccessPointsException)
pub mod too_many_access_points_exception {
    /// A builder for [`TooManyAccessPointsException`](crate::error::TooManyAccessPointsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyAccessPointsException`](crate::error::TooManyAccessPointsException)
        pub fn build(self) -> crate::error::TooManyAccessPointsException {
            crate::error::TooManyAccessPointsException {
                message: self.message,
            }
        }
    }
}
impl TooManyAccessPointsException {
    /// Creates a new builder-style object to manufacture [`TooManyAccessPointsException`](crate::error::TooManyAccessPointsException)
    pub fn builder() -> crate::error::too_many_access_points_exception::Builder {
        crate::error::too_many_access_points_exception::Builder::default()
    }
}

/// <p>One or more of the specified subnets do not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetNotFoundException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetNotFoundException {}
/// See [`SubnetNotFoundException`](crate::error::SubnetNotFoundException)
pub mod subnet_not_found_exception {
    /// A builder for [`SubnetNotFoundException`](crate::error::SubnetNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetNotFoundException`](crate::error::SubnetNotFoundException)
        pub fn build(self) -> crate::error::SubnetNotFoundException {
            crate::error::SubnetNotFoundException {
                message: self.message,
            }
        }
    }
}
impl SubnetNotFoundException {
    /// Creates a new builder-style object to manufacture [`SubnetNotFoundException`](crate::error::SubnetNotFoundException)
    pub fn builder() -> crate::error::subnet_not_found_exception::Builder {
        crate::error::subnet_not_found_exception::Builder::default()
    }
}

/// <p>This operation is not allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationNotPermittedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationNotPermittedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationNotPermittedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationNotPermittedException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationNotPermittedException {}
/// See [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
pub mod operation_not_permitted_exception {
    /// A builder for [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
        pub fn build(self) -> crate::error::OperationNotPermittedException {
            crate::error::OperationNotPermittedException {
                message: self.message,
            }
        }
    }
}
impl OperationNotPermittedException {
    /// Creates a new builder-style object to manufacture [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
    pub fn builder() -> crate::error::operation_not_permitted_exception::Builder {
        crate::error::operation_not_permitted_exception::Builder::default()
    }
}

/// <p>The specified VPC has no associated Internet gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSubnetException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSubnetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSubnetException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSubnetException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSubnetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSubnetException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSubnetException {}
/// See [`InvalidSubnetException`](crate::error::InvalidSubnetException)
pub mod invalid_subnet_exception {
    /// A builder for [`InvalidSubnetException`](crate::error::InvalidSubnetException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSubnetException`](crate::error::InvalidSubnetException)
        pub fn build(self) -> crate::error::InvalidSubnetException {
            crate::error::InvalidSubnetException {
                message: self.message,
            }
        }
    }
}
impl InvalidSubnetException {
    /// Creates a new builder-style object to manufacture [`InvalidSubnetException`](crate::error::InvalidSubnetException)
    pub fn builder() -> crate::error::invalid_subnet_exception::Builder {
        crate::error::invalid_subnet_exception::Builder::default()
    }
}

/// <p>One or more of the specified security groups do not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSecurityGroupException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSecurityGroupException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSecurityGroupException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSecurityGroupException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSecurityGroupException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSecurityGroupException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSecurityGroupException {}
/// See [`InvalidSecurityGroupException`](crate::error::InvalidSecurityGroupException)
pub mod invalid_security_group_exception {
    /// A builder for [`InvalidSecurityGroupException`](crate::error::InvalidSecurityGroupException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSecurityGroupException`](crate::error::InvalidSecurityGroupException)
        pub fn build(self) -> crate::error::InvalidSecurityGroupException {
            crate::error::InvalidSecurityGroupException {
                message: self.message,
            }
        }
    }
}
impl InvalidSecurityGroupException {
    /// Creates a new builder-style object to manufacture [`InvalidSecurityGroupException`](crate::error::InvalidSecurityGroupException)
    pub fn builder() -> crate::error::invalid_security_group_exception::Builder {
        crate::error::invalid_security_group_exception::Builder::default()
    }
}

/// <p>The specified value for the schema is not valid. You can only specify a scheme for load balancers in a VPC.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSchemeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSchemeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSchemeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSchemeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSchemeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSchemeException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSchemeException {}
/// See [`InvalidSchemeException`](crate::error::InvalidSchemeException)
pub mod invalid_scheme_exception {
    /// A builder for [`InvalidSchemeException`](crate::error::InvalidSchemeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSchemeException`](crate::error::InvalidSchemeException)
        pub fn build(self) -> crate::error::InvalidSchemeException {
            crate::error::InvalidSchemeException {
                message: self.message,
            }
        }
    }
}
impl InvalidSchemeException {
    /// Creates a new builder-style object to manufacture [`InvalidSchemeException`](crate::error::InvalidSchemeException)
    pub fn builder() -> crate::error::invalid_scheme_exception::Builder {
        crate::error::invalid_scheme_exception::Builder::default()
    }
}

/// <p>A tag key was specified more than once.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateTagKeysException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateTagKeysException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateTagKeysException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateTagKeysException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateTagKeysException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateTagKeysException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateTagKeysException {}
/// See [`DuplicateTagKeysException`](crate::error::DuplicateTagKeysException)
pub mod duplicate_tag_keys_exception {
    /// A builder for [`DuplicateTagKeysException`](crate::error::DuplicateTagKeysException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateTagKeysException`](crate::error::DuplicateTagKeysException)
        pub fn build(self) -> crate::error::DuplicateTagKeysException {
            crate::error::DuplicateTagKeysException {
                message: self.message,
            }
        }
    }
}
impl DuplicateTagKeysException {
    /// Creates a new builder-style object to manufacture [`DuplicateTagKeysException`](crate::error::DuplicateTagKeysException)
    pub fn builder() -> crate::error::duplicate_tag_keys_exception::Builder {
        crate::error::duplicate_tag_keys_exception::Builder::default()
    }
}

/// <p>The specified load balancer name already exists for this account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateAccessPointNameException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateAccessPointNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateAccessPointNameException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateAccessPointNameException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateAccessPointNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateAccessPointNameException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateAccessPointNameException {}
/// See [`DuplicateAccessPointNameException`](crate::error::DuplicateAccessPointNameException)
pub mod duplicate_access_point_name_exception {
    /// A builder for [`DuplicateAccessPointNameException`](crate::error::DuplicateAccessPointNameException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateAccessPointNameException`](crate::error::DuplicateAccessPointNameException)
        pub fn build(self) -> crate::error::DuplicateAccessPointNameException {
            crate::error::DuplicateAccessPointNameException {
                message: self.message,
            }
        }
    }
}
impl DuplicateAccessPointNameException {
    /// Creates a new builder-style object to manufacture [`DuplicateAccessPointNameException`](crate::error::DuplicateAccessPointNameException)
    pub fn builder() -> crate::error::duplicate_access_point_name_exception::Builder {
        crate::error::duplicate_access_point_name_exception::Builder::default()
    }
}
