// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Elastic Beanstalk
///
/// Client for invoking operations on AWS Elastic Beanstalk. Each operation on AWS Elastic Beanstalk is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_elasticbeanstalk::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_elasticbeanstalk::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_elasticbeanstalk::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AbortEnvironmentUpdate`](crate::client::fluent_builders::AbortEnvironmentUpdate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::AbortEnvironmentUpdate::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::AbortEnvironmentUpdate::set_environment_id): <p>This specifies the ID of the environment with the in-progress update that you want to cancel.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::AbortEnvironmentUpdate::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::AbortEnvironmentUpdate::set_environment_name): <p>This specifies the name of the environment with the in-progress update that you want to cancel.</p>
    /// - On success, responds with [`AbortEnvironmentUpdateOutput`](crate::output::AbortEnvironmentUpdateOutput)

    /// - On failure, responds with [`SdkError<AbortEnvironmentUpdateError>`](crate::error::AbortEnvironmentUpdateError)
    pub fn abort_environment_update(&self) -> fluent_builders::AbortEnvironmentUpdate {
        fluent_builders::AbortEnvironmentUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ApplyEnvironmentManagedAction`](crate::client::fluent_builders::ApplyEnvironmentManagedAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::ApplyEnvironmentManagedAction::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::ApplyEnvironmentManagedAction::set_environment_name): <p>The name of the target environment.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::ApplyEnvironmentManagedAction::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::ApplyEnvironmentManagedAction::set_environment_id): <p>The environment ID of the target environment.</p>
    ///   - [`action_id(impl Into<String>)`](crate::client::fluent_builders::ApplyEnvironmentManagedAction::action_id) / [`set_action_id(Option<String>)`](crate::client::fluent_builders::ApplyEnvironmentManagedAction::set_action_id): <p>The action ID of the scheduled managed action to execute.</p>
    /// - On success, responds with [`ApplyEnvironmentManagedActionOutput`](crate::output::ApplyEnvironmentManagedActionOutput) with field(s):
    ///   - [`action_id(Option<String>)`](crate::output::ApplyEnvironmentManagedActionOutput::action_id): <p>The action ID of the managed action.</p>
    ///   - [`action_description(Option<String>)`](crate::output::ApplyEnvironmentManagedActionOutput::action_description): <p>A description of the managed action.</p>
    ///   - [`action_type(Option<ActionType>)`](crate::output::ApplyEnvironmentManagedActionOutput::action_type): <p>The type of managed action.</p>
    ///   - [`status(Option<String>)`](crate::output::ApplyEnvironmentManagedActionOutput::status): <p>The status of the managed action.</p>
    /// - On failure, responds with [`SdkError<ApplyEnvironmentManagedActionError>`](crate::error::ApplyEnvironmentManagedActionError)
    pub fn apply_environment_managed_action(
        &self,
    ) -> fluent_builders::ApplyEnvironmentManagedAction {
        fluent_builders::ApplyEnvironmentManagedAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateEnvironmentOperationsRole`](crate::client::fluent_builders::AssociateEnvironmentOperationsRole) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::AssociateEnvironmentOperationsRole::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::AssociateEnvironmentOperationsRole::set_environment_name): <p>The name of the environment to which to set the operations role.</p>
    ///   - [`operations_role(impl Into<String>)`](crate::client::fluent_builders::AssociateEnvironmentOperationsRole::operations_role) / [`set_operations_role(Option<String>)`](crate::client::fluent_builders::AssociateEnvironmentOperationsRole::set_operations_role): <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role.</p>
    /// - On success, responds with [`AssociateEnvironmentOperationsRoleOutput`](crate::output::AssociateEnvironmentOperationsRoleOutput)

    /// - On failure, responds with [`SdkError<AssociateEnvironmentOperationsRoleError>`](crate::error::AssociateEnvironmentOperationsRoleError)
    pub fn associate_environment_operations_role(
        &self,
    ) -> fluent_builders::AssociateEnvironmentOperationsRole {
        fluent_builders::AssociateEnvironmentOperationsRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CheckDNSAvailability`](crate::client::fluent_builders::CheckDNSAvailability) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cname_prefix(impl Into<String>)`](crate::client::fluent_builders::CheckDNSAvailability::cname_prefix) / [`set_cname_prefix(Option<String>)`](crate::client::fluent_builders::CheckDNSAvailability::set_cname_prefix): <p>The prefix used when this CNAME is reserved.</p>
    /// - On success, responds with [`CheckDnsAvailabilityOutput`](crate::output::CheckDnsAvailabilityOutput) with field(s):
    ///   - [`available(Option<bool>)`](crate::output::CheckDnsAvailabilityOutput::available): <p>Indicates if the specified CNAME is available:</p>  <ul>   <li> <p> <code>true</code> : The CNAME is available.</p> </li>   <li> <p> <code>false</code> : The CNAME is not available.</p> </li>  </ul>
    ///   - [`fully_qualified_cname(Option<String>)`](crate::output::CheckDnsAvailabilityOutput::fully_qualified_cname): <p>The fully qualified CNAME to reserve when <code>CreateEnvironment</code> is called with the provided prefix.</p>
    /// - On failure, responds with [`SdkError<CheckDNSAvailabilityError>`](crate::error::CheckDNSAvailabilityError)
    pub fn check_dns_availability(&self) -> fluent_builders::CheckDNSAvailability {
        fluent_builders::CheckDNSAvailability::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ComposeEnvironments`](crate::client::fluent_builders::ComposeEnvironments) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::ComposeEnvironments::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::ComposeEnvironments::set_application_name): <p>The name of the application to which the specified source bundles belong.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::ComposeEnvironments::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::ComposeEnvironments::set_group_name): <p>The name of the group to which the target environments belong. Specify a group name only if the environment name defined in each target environment's manifest ends with a + (plus) character. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
    ///   - [`version_labels(Vec<String>)`](crate::client::fluent_builders::ComposeEnvironments::version_labels) / [`set_version_labels(Option<Vec<String>>)`](crate::client::fluent_builders::ComposeEnvironments::set_version_labels): <p>A list of version labels, specifying one or more application source bundles that belong to the target application. Each source bundle must include an environment manifest that specifies the name of the environment and the name of the solution stack to use, and optionally can specify environment links to create.</p>
    /// - On success, responds with [`ComposeEnvironmentsOutput`](crate::output::ComposeEnvironmentsOutput) with field(s):
    ///   - [`environments(Option<Vec<EnvironmentDescription>>)`](crate::output::ComposeEnvironmentsOutput::environments): <p> Returns an <code>EnvironmentDescription</code> list. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ComposeEnvironmentsOutput::next_token): <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
    /// - On failure, responds with [`SdkError<ComposeEnvironmentsError>`](crate::error::ComposeEnvironmentsError)
    pub fn compose_environments(&self) -> fluent_builders::ComposeEnvironments {
        fluent_builders::ComposeEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApplication`](crate::client::fluent_builders::CreateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_application_name): <p>The name of the application. Must be unique within your account.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_description): <p>Your description of the application.</p>
    ///   - [`resource_lifecycle_config(ApplicationResourceLifecycleConfig)`](crate::client::fluent_builders::CreateApplication::resource_lifecycle_config) / [`set_resource_lifecycle_config(Option<ApplicationResourceLifecycleConfig>)`](crate::client::fluent_builders::CreateApplication::set_resource_lifecycle_config): <p>Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateApplication::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateApplication::set_tags): <p>Specifies the tags applied to the application.</p>  <p>Elastic Beanstalk applies these tags only to the application. Environments that you create in the application don't inherit the tags.</p>
    /// - On success, responds with [`CreateApplicationOutput`](crate::output::CreateApplicationOutput) with field(s):
    ///   - [`application(Option<ApplicationDescription>)`](crate::output::CreateApplicationOutput::application): <p> The <code>ApplicationDescription</code> of the application. </p>
    /// - On failure, responds with [`SdkError<CreateApplicationError>`](crate::error::CreateApplicationError)
    pub fn create_application(&self) -> fluent_builders::CreateApplication {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApplicationVersion`](crate::client::fluent_builders::CreateApplicationVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::CreateApplicationVersion::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::CreateApplicationVersion::set_application_name): <p> The name of the application. If no application is found with this name, and <code>AutoCreateApplication</code> is <code>false</code>, returns an <code>InvalidParameterValue</code> error. </p>
    ///   - [`version_label(impl Into<String>)`](crate::client::fluent_builders::CreateApplicationVersion::version_label) / [`set_version_label(Option<String>)`](crate::client::fluent_builders::CreateApplicationVersion::set_version_label): <p>A label identifying this version.</p>  <p>Constraint: Must be unique per application. If an application version already exists with this label for the specified application, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateApplicationVersion::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateApplicationVersion::set_description): <p>A description of this application version.</p>
    ///   - [`source_build_information(SourceBuildInformation)`](crate::client::fluent_builders::CreateApplicationVersion::source_build_information) / [`set_source_build_information(Option<SourceBuildInformation>)`](crate::client::fluent_builders::CreateApplicationVersion::set_source_build_information): <p>Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application version.</p>
    ///   - [`source_bundle(S3Location)`](crate::client::fluent_builders::CreateApplicationVersion::source_bundle) / [`set_source_bundle(Option<S3Location>)`](crate::client::fluent_builders::CreateApplicationVersion::set_source_bundle): <p>The Amazon S3 bucket and key that identify the location of the source bundle for this version.</p> <note>   <p>The Amazon S3 bucket must be in the same region as the environment.</p>  </note>  <p>Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample application.</p>
    ///   - [`build_configuration(BuildConfiguration)`](crate::client::fluent_builders::CreateApplicationVersion::build_configuration) / [`set_build_configuration(Option<BuildConfiguration>)`](crate::client::fluent_builders::CreateApplicationVersion::set_build_configuration): <p>Settings for an AWS CodeBuild build.</p>
    ///   - [`auto_create_application(bool)`](crate::client::fluent_builders::CreateApplicationVersion::auto_create_application) / [`set_auto_create_application(Option<bool>)`](crate::client::fluent_builders::CreateApplicationVersion::set_auto_create_application): <p>Set to <code>true</code> to create an application with the specified name if it doesn't already exist.</p>
    ///   - [`process(bool)`](crate::client::fluent_builders::CreateApplicationVersion::process) / [`set_process(Option<bool>)`](crate::client::fluent_builders::CreateApplicationVersion::set_process): <p>Pre-processes and validates the environment manifest (<code>env.yaml</code>) and configuration files (<code>*.config</code> files in the <code>.ebextensions</code> folder) in the source bundle. Validating configuration files can identify issues prior to deploying the application version to an environment.</p>  <p>You must turn processing on for application versions that you create using AWS CodeBuild or AWS CodeCommit. For application versions built from a source bundle in Amazon S3, processing is optional.</p> <note>   <p>The <code>Process</code> option validates Elastic Beanstalk configuration files. It doesn't validate your application's configuration files, like proxy server or Docker configuration.</p>  </note>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateApplicationVersion::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateApplicationVersion::set_tags): <p>Specifies the tags applied to the application version.</p>  <p>Elastic Beanstalk applies these tags only to the application version. Environments that use the application version don't inherit the tags.</p>
    /// - On success, responds with [`CreateApplicationVersionOutput`](crate::output::CreateApplicationVersionOutput) with field(s):
    ///   - [`application_version(Option<ApplicationVersionDescription>)`](crate::output::CreateApplicationVersionOutput::application_version): <p> The <code>ApplicationVersionDescription</code> of the application version. </p>
    /// - On failure, responds with [`SdkError<CreateApplicationVersionError>`](crate::error::CreateApplicationVersionError)
    pub fn create_application_version(&self) -> fluent_builders::CreateApplicationVersion {
        fluent_builders::CreateApplicationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConfigurationTemplate`](crate::client::fluent_builders::CreateConfigurationTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationTemplate::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationTemplate::set_application_name): <p>The name of the Elastic Beanstalk application to associate with this configuration template.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationTemplate::set_template_name): <p>The name of the configuration template.</p>  <p>Constraint: This name must be unique per application.</p>
    ///   - [`solution_stack_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationTemplate::solution_stack_name) / [`set_solution_stack_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationTemplate::set_solution_stack_name): <p>The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses. For example, <code>64bit Amazon Linux 2013.09 running Tomcat 7 Java 7</code>. A solution stack specifies the operating system, runtime, and application server for a configuration template. It also determines the set of configuration options as well as the possible and default values. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Supported Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>  <p>You must specify <code>SolutionStackName</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SourceConfiguration</code>.</p>  <p>Use the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html"> <code>ListAvailableSolutionStacks</code> </a> API to obtain a list of available solution stacks.</p>
    ///   - [`platform_arn(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationTemplate::platform_arn) / [`set_platform_arn(Option<String>)`](crate::client::fluent_builders::CreateConfigurationTemplate::set_platform_arn): <p>The Amazon Resource Name (ARN) of the custom platform. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html"> Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>   <p>If you specify <code>PlatformArn</code>, then don't specify <code>SolutionStackName</code>.</p>  </note>
    ///   - [`source_configuration(SourceConfiguration)`](crate::client::fluent_builders::CreateConfigurationTemplate::source_configuration) / [`set_source_configuration(Option<SourceConfiguration>)`](crate::client::fluent_builders::CreateConfigurationTemplate::set_source_configuration): <p>An Elastic Beanstalk configuration template to base this one on. If specified, Elastic Beanstalk uses the configuration values from the specified configuration template to create a new configuration.</p>  <p>Values specified in <code>OptionSettings</code> override any values obtained from the <code>SourceConfiguration</code>.</p>  <p>You must specify <code>SourceConfiguration</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SolutionStackName</code>.</p>  <p>Constraint: If both solution stack name and source configuration are specified, the solution stack of the source configuration template must match the specified solution stack name.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationTemplate::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::CreateConfigurationTemplate::set_environment_id): <p>The ID of an environment whose settings you want to use to create the configuration template. You must specify <code>EnvironmentId</code> if you don't specify <code>PlatformArn</code>, <code>SolutionStackName</code>, or <code>SourceConfiguration</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationTemplate::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateConfigurationTemplate::set_description): <p>An optional description for this configuration.</p>
    ///   - [`option_settings(Vec<ConfigurationOptionSetting>)`](crate::client::fluent_builders::CreateConfigurationTemplate::option_settings) / [`set_option_settings(Option<Vec<ConfigurationOptionSetting>>)`](crate::client::fluent_builders::CreateConfigurationTemplate::set_option_settings): <p>Option values for the Elastic Beanstalk configuration, such as the instance type. If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html">Option Values</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateConfigurationTemplate::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateConfigurationTemplate::set_tags): <p>Specifies the tags applied to the configuration template.</p>
    /// - On success, responds with [`CreateConfigurationTemplateOutput`](crate::output::CreateConfigurationTemplateOutput) with field(s):
    ///   - [`solution_stack_name(Option<String>)`](crate::output::CreateConfigurationTemplateOutput::solution_stack_name): <p>The name of the solution stack this configuration set uses.</p>
    ///   - [`platform_arn(Option<String>)`](crate::output::CreateConfigurationTemplateOutput::platform_arn): <p>The ARN of the platform version.</p>
    ///   - [`application_name(Option<String>)`](crate::output::CreateConfigurationTemplateOutput::application_name): <p>The name of the application associated with this configuration set.</p>
    ///   - [`template_name(Option<String>)`](crate::output::CreateConfigurationTemplateOutput::template_name): <p> If not <code>null</code>, the name of the configuration template for this configuration set. </p>
    ///   - [`description(Option<String>)`](crate::output::CreateConfigurationTemplateOutput::description): <p>Describes this configuration set.</p>
    ///   - [`environment_name(Option<String>)`](crate::output::CreateConfigurationTemplateOutput::environment_name): <p> If not <code>null</code>, the name of the environment for this configuration set. </p>
    ///   - [`deployment_status(Option<ConfigurationDeploymentStatus>)`](crate::output::CreateConfigurationTemplateOutput::deployment_status): <p> If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter indicates the deployment status of this configuration set: </p>  <ul>   <li> <p> <code>null</code>: This configuration is not associated with a running environment.</p> </li>   <li> <p> <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is in the process of deploying.</p> </li>   <li> <p> <code>deployed</code>: This is the configuration that is currently deployed to the associated running environment.</p> </li>   <li> <p> <code>failed</code>: This is a draft configuration that failed to successfully deploy.</p> </li>  </ul>
    ///   - [`date_created(Option<DateTime>)`](crate::output::CreateConfigurationTemplateOutput::date_created): <p>The date (in UTC time) when this configuration set was created.</p>
    ///   - [`date_updated(Option<DateTime>)`](crate::output::CreateConfigurationTemplateOutput::date_updated): <p>The date (in UTC time) when this configuration set was last modified.</p>
    ///   - [`option_settings(Option<Vec<ConfigurationOptionSetting>>)`](crate::output::CreateConfigurationTemplateOutput::option_settings): <p>A list of the configuration options and their values in this configuration set.</p>
    /// - On failure, responds with [`SdkError<CreateConfigurationTemplateError>`](crate::error::CreateConfigurationTemplateError)
    pub fn create_configuration_template(&self) -> fluent_builders::CreateConfigurationTemplate {
        fluent_builders::CreateConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEnvironment`](crate::client::fluent_builders::CreateEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_application_name): <p>The name of the application that is associated with this environment.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_environment_name): <p>A unique name for the environment.</p>  <p>Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and hyphens. It can't start or end with a hyphen. This name must be unique within a region in your account. If the specified name already exists in the region, Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>  <p>If you don't specify the <code>CNAMEPrefix</code> parameter, the environment name becomes part of the CNAME, and therefore part of the visible URL for your application.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_group_name): <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name parameter. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_description): <p>Your description for this environment.</p>
    ///   - [`cname_prefix(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::cname_prefix) / [`set_cname_prefix(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_cname_prefix): <p>If specified, the environment attempts to use this value as the prefix for the CNAME in your Elastic Beanstalk environment URL. If not specified, the CNAME is generated automatically by appending a random alphanumeric string to the environment name.</p>
    ///   - [`tier(EnvironmentTier)`](crate::client::fluent_builders::CreateEnvironment::tier) / [`set_tier(Option<EnvironmentTier>)`](crate::client::fluent_builders::CreateEnvironment::set_tier): <p>Specifies the tier to use in creating this environment. The environment tier that you choose determines whether Elastic Beanstalk provisions resources to support a web application that handles HTTP(S) requests or a web application that handles background-processing tasks.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateEnvironment::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateEnvironment::set_tags): <p>Specifies the tags applied to resources in the environment.</p>
    ///   - [`version_label(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::version_label) / [`set_version_label(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_version_label): <p>The name of the application version to deploy.</p>  <p>Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_template_name): <p>The name of the Elastic Beanstalk configuration template to use with the environment.</p> <note>   <p>If you specify <code>TemplateName</code>, then don't specify <code>SolutionStackName</code>.</p>  </note>
    ///   - [`solution_stack_name(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::solution_stack_name) / [`set_solution_stack_name(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_solution_stack_name): <p>The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If specified, Elastic Beanstalk sets the configuration values to the default values associated with the specified solution stack. For a list of current solution stacks, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic Beanstalk Supported Platforms</a> in the <i>AWS Elastic Beanstalk Platforms</i> guide.</p> <note>   <p>If you specify <code>SolutionStackName</code>, don't specify <code>PlatformArn</code> or <code>TemplateName</code>.</p>  </note>
    ///   - [`platform_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::platform_arn) / [`set_platform_arn(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_platform_arn): <p>The Amazon Resource Name (ARN) of the custom platform to use with the environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>   <p>If you specify <code>PlatformArn</code>, don't specify <code>SolutionStackName</code>.</p>  </note>
    ///   - [`option_settings(Vec<ConfigurationOptionSetting>)`](crate::client::fluent_builders::CreateEnvironment::option_settings) / [`set_option_settings(Option<Vec<ConfigurationOptionSetting>>)`](crate::client::fluent_builders::CreateEnvironment::set_option_settings): <p>If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the configuration set for the new environment. These override the values obtained from the solution stack or the configuration template.</p>
    ///   - [`options_to_remove(Vec<OptionSpecification>)`](crate::client::fluent_builders::CreateEnvironment::options_to_remove) / [`set_options_to_remove(Option<Vec<OptionSpecification>>)`](crate::client::fluent_builders::CreateEnvironment::set_options_to_remove): <p>A list of custom user-defined configuration options to remove from the configuration set for this new environment.</p>
    ///   - [`operations_role(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::operations_role) / [`set_operations_role(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_operations_role): <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role. If specified, Elastic Beanstalk uses the operations role for permissions to downstream services during this call and during subsequent calls acting on this environment. To specify an operations role, you must have the <code>iam:PassRole</code> permission for the role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    /// - On success, responds with [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput) with field(s):
    ///   - [`environment_name(Option<String>)`](crate::output::CreateEnvironmentOutput::environment_name): <p>The name of this environment.</p>
    ///   - [`environment_id(Option<String>)`](crate::output::CreateEnvironmentOutput::environment_id): <p>The ID of this environment.</p>
    ///   - [`application_name(Option<String>)`](crate::output::CreateEnvironmentOutput::application_name): <p>The name of the application associated with this environment.</p>
    ///   - [`version_label(Option<String>)`](crate::output::CreateEnvironmentOutput::version_label): <p>The application version deployed in this environment.</p>
    ///   - [`solution_stack_name(Option<String>)`](crate::output::CreateEnvironmentOutput::solution_stack_name): <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
    ///   - [`platform_arn(Option<String>)`](crate::output::CreateEnvironmentOutput::platform_arn): <p>The ARN of the platform version.</p>
    ///   - [`template_name(Option<String>)`](crate::output::CreateEnvironmentOutput::template_name): <p>The name of the configuration template used to originally launch this environment.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateEnvironmentOutput::description): <p>Describes this environment.</p>
    ///   - [`endpoint_url(Option<String>)`](crate::output::CreateEnvironmentOutput::endpoint_url): <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
    ///   - [`cname(Option<String>)`](crate::output::CreateEnvironmentOutput::cname): <p>The URL to the CNAME for this environment.</p>
    ///   - [`date_created(Option<DateTime>)`](crate::output::CreateEnvironmentOutput::date_created): <p>The creation date for this environment.</p>
    ///   - [`date_updated(Option<DateTime>)`](crate::output::CreateEnvironmentOutput::date_updated): <p>The last modified date for this environment.</p>
    ///   - [`status(Option<EnvironmentStatus>)`](crate::output::CreateEnvironmentOutput::status): <p>The current operational status of the environment:</p>  <ul>   <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>   <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>   <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>   <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>   <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>  </ul>
    ///   - [`abortable_operation_in_progress(Option<bool>)`](crate::output::CreateEnvironmentOutput::abortable_operation_in_progress): <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>  <p> <code>true:</code> There is an update in progress. </p>  <p> <code>false:</code> There are no updates currently in progress. </p>
    ///   - [`health(Option<EnvironmentHealth>)`](crate::output::CreateEnvironmentOutput::health): <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>  <ul>   <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>   <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>   <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>   <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>  </ul>  <p> Default: <code>Grey</code> </p>
    ///   - [`health_status(Option<EnvironmentHealthStatus>)`](crate::output::CreateEnvironmentOutput::health_status): <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
    ///   - [`resources(Option<EnvironmentResourcesDescription>)`](crate::output::CreateEnvironmentOutput::resources): <p>The description of the AWS resources used by this environment.</p>
    ///   - [`tier(Option<EnvironmentTier>)`](crate::output::CreateEnvironmentOutput::tier): <p>Describes the current tier of this environment.</p>
    ///   - [`environment_links(Option<Vec<EnvironmentLink>>)`](crate::output::CreateEnvironmentOutput::environment_links): <p>A list of links to other environments in the same group.</p>
    ///   - [`environment_arn(Option<String>)`](crate::output::CreateEnvironmentOutput::environment_arn): <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
    ///   - [`operations_role(Option<String>)`](crate::output::CreateEnvironmentOutput::operations_role): <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<CreateEnvironmentError>`](crate::error::CreateEnvironmentError)
    pub fn create_environment(&self) -> fluent_builders::CreateEnvironment {
        fluent_builders::CreateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePlatformVersion`](crate::client::fluent_builders::CreatePlatformVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`platform_name(impl Into<String>)`](crate::client::fluent_builders::CreatePlatformVersion::platform_name) / [`set_platform_name(Option<String>)`](crate::client::fluent_builders::CreatePlatformVersion::set_platform_name): <p>The name of your custom platform.</p>
    ///   - [`platform_version(impl Into<String>)`](crate::client::fluent_builders::CreatePlatformVersion::platform_version) / [`set_platform_version(Option<String>)`](crate::client::fluent_builders::CreatePlatformVersion::set_platform_version): <p>The number, such as 1.0.2, for the new platform version.</p>
    ///   - [`platform_definition_bundle(S3Location)`](crate::client::fluent_builders::CreatePlatformVersion::platform_definition_bundle) / [`set_platform_definition_bundle(Option<S3Location>)`](crate::client::fluent_builders::CreatePlatformVersion::set_platform_definition_bundle): <p>The location of the platform definition archive in Amazon S3.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::CreatePlatformVersion::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::CreatePlatformVersion::set_environment_name): <p>The name of the builder environment.</p>
    ///   - [`option_settings(Vec<ConfigurationOptionSetting>)`](crate::client::fluent_builders::CreatePlatformVersion::option_settings) / [`set_option_settings(Option<Vec<ConfigurationOptionSetting>>)`](crate::client::fluent_builders::CreatePlatformVersion::set_option_settings): <p>The configuration option settings to apply to the builder environment.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreatePlatformVersion::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreatePlatformVersion::set_tags): <p>Specifies the tags applied to the new platform version.</p>  <p>Elastic Beanstalk applies these tags only to the platform version. Environments that you create using the platform version don't inherit the tags.</p>
    /// - On success, responds with [`CreatePlatformVersionOutput`](crate::output::CreatePlatformVersionOutput) with field(s):
    ///   - [`platform_summary(Option<PlatformSummary>)`](crate::output::CreatePlatformVersionOutput::platform_summary): <p>Detailed information about the new version of the custom platform.</p>
    ///   - [`builder_value(Option<Builder>)`](crate::output::CreatePlatformVersionOutput::builder_value): <p>The builder used to create the custom platform.</p>
    /// - On failure, responds with [`SdkError<CreatePlatformVersionError>`](crate::error::CreatePlatformVersionError)
    pub fn create_platform_version(&self) -> fluent_builders::CreatePlatformVersion {
        fluent_builders::CreatePlatformVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStorageLocation`](crate::client::fluent_builders::CreateStorageLocation) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::CreateStorageLocation::send) it.

    /// - On success, responds with [`CreateStorageLocationOutput`](crate::output::CreateStorageLocationOutput) with field(s):
    ///   - [`s3_bucket(Option<String>)`](crate::output::CreateStorageLocationOutput::s3_bucket): <p>The name of the Amazon S3 bucket created.</p>
    /// - On failure, responds with [`SdkError<CreateStorageLocationError>`](crate::error::CreateStorageLocationError)
    pub fn create_storage_location(&self) -> fluent_builders::CreateStorageLocation {
        fluent_builders::CreateStorageLocation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplication`](crate::client::fluent_builders::DeleteApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DeleteApplication::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DeleteApplication::set_application_name): <p>The name of the application to delete.</p>
    ///   - [`terminate_env_by_force(bool)`](crate::client::fluent_builders::DeleteApplication::terminate_env_by_force) / [`set_terminate_env_by_force(Option<bool>)`](crate::client::fluent_builders::DeleteApplication::set_terminate_env_by_force): <p>When set to true, running environments will be terminated before deleting the application.</p>
    /// - On success, responds with [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)

    /// - On failure, responds with [`SdkError<DeleteApplicationError>`](crate::error::DeleteApplicationError)
    pub fn delete_application(&self) -> fluent_builders::DeleteApplication {
        fluent_builders::DeleteApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplicationVersion`](crate::client::fluent_builders::DeleteApplicationVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DeleteApplicationVersion::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DeleteApplicationVersion::set_application_name): <p>The name of the application to which the version belongs.</p>
    ///   - [`version_label(impl Into<String>)`](crate::client::fluent_builders::DeleteApplicationVersion::version_label) / [`set_version_label(Option<String>)`](crate::client::fluent_builders::DeleteApplicationVersion::set_version_label): <p>The label of the version to delete.</p>
    ///   - [`delete_source_bundle(bool)`](crate::client::fluent_builders::DeleteApplicationVersion::delete_source_bundle) / [`set_delete_source_bundle(Option<bool>)`](crate::client::fluent_builders::DeleteApplicationVersion::set_delete_source_bundle): <p>Set to <code>true</code> to delete the source bundle from your storage bucket. Otherwise, the application version is deleted only from Elastic Beanstalk and the source bundle remains in Amazon S3.</p>
    /// - On success, responds with [`DeleteApplicationVersionOutput`](crate::output::DeleteApplicationVersionOutput)

    /// - On failure, responds with [`SdkError<DeleteApplicationVersionError>`](crate::error::DeleteApplicationVersionError)
    pub fn delete_application_version(&self) -> fluent_builders::DeleteApplicationVersion {
        fluent_builders::DeleteApplicationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConfigurationTemplate`](crate::client::fluent_builders::DeleteConfigurationTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationTemplate::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationTemplate::set_application_name): <p>The name of the application to delete the configuration template from.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationTemplate::set_template_name): <p>The name of the configuration template to delete.</p>
    /// - On success, responds with [`DeleteConfigurationTemplateOutput`](crate::output::DeleteConfigurationTemplateOutput)

    /// - On failure, responds with [`SdkError<DeleteConfigurationTemplateError>`](crate::error::DeleteConfigurationTemplateError)
    pub fn delete_configuration_template(&self) -> fluent_builders::DeleteConfigurationTemplate {
        fluent_builders::DeleteConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEnvironmentConfiguration`](crate::client::fluent_builders::DeleteEnvironmentConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEnvironmentConfiguration::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DeleteEnvironmentConfiguration::set_application_name): <p>The name of the application the environment is associated with.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEnvironmentConfiguration::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::DeleteEnvironmentConfiguration::set_environment_name): <p>The name of the environment to delete the draft configuration from.</p>
    /// - On success, responds with [`DeleteEnvironmentConfigurationOutput`](crate::output::DeleteEnvironmentConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteEnvironmentConfigurationError>`](crate::error::DeleteEnvironmentConfigurationError)
    pub fn delete_environment_configuration(
        &self,
    ) -> fluent_builders::DeleteEnvironmentConfiguration {
        fluent_builders::DeleteEnvironmentConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePlatformVersion`](crate::client::fluent_builders::DeletePlatformVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`platform_arn(impl Into<String>)`](crate::client::fluent_builders::DeletePlatformVersion::platform_arn) / [`set_platform_arn(Option<String>)`](crate::client::fluent_builders::DeletePlatformVersion::set_platform_arn): <p>The ARN of the version of the custom platform.</p>
    /// - On success, responds with [`DeletePlatformVersionOutput`](crate::output::DeletePlatformVersionOutput) with field(s):
    ///   - [`platform_summary(Option<PlatformSummary>)`](crate::output::DeletePlatformVersionOutput::platform_summary): <p>Detailed information about the version of the custom platform.</p>
    /// - On failure, responds with [`SdkError<DeletePlatformVersionError>`](crate::error::DeletePlatformVersionError)
    pub fn delete_platform_version(&self) -> fluent_builders::DeletePlatformVersion {
        fluent_builders::DeletePlatformVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountAttributes`](crate::client::fluent_builders::DescribeAccountAttributes) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeAccountAttributes::send) it.

    /// - On success, responds with [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput) with field(s):
    ///   - [`resource_quotas(Option<ResourceQuotas>)`](crate::output::DescribeAccountAttributesOutput::resource_quotas): <p>The Elastic Beanstalk resource quotas associated with the calling AWS account.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountAttributesError>`](crate::error::DescribeAccountAttributesError)
    pub fn describe_account_attributes(&self) -> fluent_builders::DescribeAccountAttributes {
        fluent_builders::DescribeAccountAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeApplications`](crate::client::fluent_builders::DescribeApplications) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_names(Vec<String>)`](crate::client::fluent_builders::DescribeApplications::application_names) / [`set_application_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeApplications::set_application_names): <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include those with the specified names.</p>
    /// - On success, responds with [`DescribeApplicationsOutput`](crate::output::DescribeApplicationsOutput) with field(s):
    ///   - [`applications(Option<Vec<ApplicationDescription>>)`](crate::output::DescribeApplicationsOutput::applications): <p>This parameter contains a list of <code>ApplicationDescription</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeApplicationsError>`](crate::error::DescribeApplicationsError)
    pub fn describe_applications(&self) -> fluent_builders::DescribeApplications {
        fluent_builders::DescribeApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeApplicationVersions`](crate::client::fluent_builders::DescribeApplicationVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DescribeApplicationVersions::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DescribeApplicationVersions::set_application_name): <p>Specify an application name to show only application versions for that application.</p>
    ///   - [`version_labels(Vec<String>)`](crate::client::fluent_builders::DescribeApplicationVersions::version_labels) / [`set_version_labels(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeApplicationVersions::set_version_labels): <p>Specify a version label to show a specific application version.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeApplicationVersions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeApplicationVersions::set_max_records): <p>For a paginated request. Specify a maximum number of application versions to include in each response.</p>  <p>If no <code>MaxRecords</code> is specified, all available application versions are retrieved in a single response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeApplicationVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeApplicationVersions::set_next_token): <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>  <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
    /// - On success, responds with [`DescribeApplicationVersionsOutput`](crate::output::DescribeApplicationVersionsOutput) with field(s):
    ///   - [`application_versions(Option<Vec<ApplicationVersionDescription>>)`](crate::output::DescribeApplicationVersionsOutput::application_versions): <p>List of <code>ApplicationVersionDescription</code> objects sorted in order of creation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeApplicationVersionsOutput::next_token): <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
    /// - On failure, responds with [`SdkError<DescribeApplicationVersionsError>`](crate::error::DescribeApplicationVersionsError)
    pub fn describe_application_versions(&self) -> fluent_builders::DescribeApplicationVersions {
        fluent_builders::DescribeApplicationVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConfigurationOptions`](crate::client::fluent_builders::DescribeConfigurationOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DescribeConfigurationOptions::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DescribeConfigurationOptions::set_application_name): <p>The name of the application associated with the configuration template or environment. Only needed if you want to describe the configuration options associated with either the configuration template or environment.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DescribeConfigurationOptions::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DescribeConfigurationOptions::set_template_name): <p>The name of the configuration template whose configuration options you want to describe.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::DescribeConfigurationOptions::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::DescribeConfigurationOptions::set_environment_name): <p>The name of the environment whose configuration options you want to describe.</p>
    ///   - [`solution_stack_name(impl Into<String>)`](crate::client::fluent_builders::DescribeConfigurationOptions::solution_stack_name) / [`set_solution_stack_name(Option<String>)`](crate::client::fluent_builders::DescribeConfigurationOptions::set_solution_stack_name): <p>The name of the solution stack whose configuration options you want to describe.</p>
    ///   - [`platform_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeConfigurationOptions::platform_arn) / [`set_platform_arn(Option<String>)`](crate::client::fluent_builders::DescribeConfigurationOptions::set_platform_arn): <p>The ARN of the custom platform.</p>
    ///   - [`options(Vec<OptionSpecification>)`](crate::client::fluent_builders::DescribeConfigurationOptions::options) / [`set_options(Option<Vec<OptionSpecification>>)`](crate::client::fluent_builders::DescribeConfigurationOptions::set_options): <p>If specified, restricts the descriptions to only the specified options.</p>
    /// - On success, responds with [`DescribeConfigurationOptionsOutput`](crate::output::DescribeConfigurationOptionsOutput) with field(s):
    ///   - [`solution_stack_name(Option<String>)`](crate::output::DescribeConfigurationOptionsOutput::solution_stack_name): <p>The name of the solution stack these configuration options belong to.</p>
    ///   - [`platform_arn(Option<String>)`](crate::output::DescribeConfigurationOptionsOutput::platform_arn): <p>The ARN of the platform version.</p>
    ///   - [`options(Option<Vec<ConfigurationOptionDescription>>)`](crate::output::DescribeConfigurationOptionsOutput::options): <p> A list of <code>ConfigurationOptionDescription</code>. </p>
    /// - On failure, responds with [`SdkError<DescribeConfigurationOptionsError>`](crate::error::DescribeConfigurationOptionsError)
    pub fn describe_configuration_options(&self) -> fluent_builders::DescribeConfigurationOptions {
        fluent_builders::DescribeConfigurationOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConfigurationSettings`](crate::client::fluent_builders::DescribeConfigurationSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DescribeConfigurationSettings::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DescribeConfigurationSettings::set_application_name): <p>The application for the environment or configuration template.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DescribeConfigurationSettings::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DescribeConfigurationSettings::set_template_name): <p>The name of the configuration template to describe.</p>  <p> Conditional: You must specify either this parameter or an EnvironmentName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns a <code>MissingRequiredParameter</code> error. </p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::DescribeConfigurationSettings::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::DescribeConfigurationSettings::set_environment_name): <p>The name of the environment to describe.</p>  <p> Condition: You must specify either this or a TemplateName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    /// - On success, responds with [`DescribeConfigurationSettingsOutput`](crate::output::DescribeConfigurationSettingsOutput) with field(s):
    ///   - [`configuration_settings(Option<Vec<ConfigurationSettingsDescription>>)`](crate::output::DescribeConfigurationSettingsOutput::configuration_settings): <p> A list of <code>ConfigurationSettingsDescription</code>. </p>
    /// - On failure, responds with [`SdkError<DescribeConfigurationSettingsError>`](crate::error::DescribeConfigurationSettingsError)
    pub fn describe_configuration_settings(
        &self,
    ) -> fluent_builders::DescribeConfigurationSettings {
        fluent_builders::DescribeConfigurationSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEnvironmentHealth`](crate::client::fluent_builders::DescribeEnvironmentHealth) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironmentHealth::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::DescribeEnvironmentHealth::set_environment_name): <p>Specify the environment by name.</p>  <p>You must specify either this or an EnvironmentName, or both.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironmentHealth::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::DescribeEnvironmentHealth::set_environment_id): <p>Specify the environment by ID.</p>  <p>You must specify either this or an EnvironmentName, or both.</p>
    ///   - [`attribute_names(Vec<EnvironmentHealthAttribute>)`](crate::client::fluent_builders::DescribeEnvironmentHealth::attribute_names) / [`set_attribute_names(Option<Vec<EnvironmentHealthAttribute>>)`](crate::client::fluent_builders::DescribeEnvironmentHealth::set_attribute_names): <p>Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns the name of the environment.</p>
    /// - On success, responds with [`DescribeEnvironmentHealthOutput`](crate::output::DescribeEnvironmentHealthOutput) with field(s):
    ///   - [`environment_name(Option<String>)`](crate::output::DescribeEnvironmentHealthOutput::environment_name): <p>The environment's name.</p>
    ///   - [`health_status(Option<String>)`](crate::output::DescribeEnvironmentHealthOutput::health_status): <p>The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health status</a> of the environment. For example, <code>Ok</code>.</p>
    ///   - [`status(Option<EnvironmentHealth>)`](crate::output::DescribeEnvironmentHealthOutput::status): <p>The environment's operational status. <code>Ready</code>, <code>Launching</code>, <code>Updating</code>, <code>Terminating</code>, or <code>Terminated</code>.</p>
    ///   - [`color(Option<String>)`](crate::output::DescribeEnvironmentHealthOutput::color): <p>The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health color</a> of the environment.</p>
    ///   - [`causes(Option<Vec<String>>)`](crate::output::DescribeEnvironmentHealthOutput::causes): <p>Descriptions of the data that contributed to the environment's current health status.</p>
    ///   - [`application_metrics(Option<ApplicationMetrics>)`](crate::output::DescribeEnvironmentHealthOutput::application_metrics): <p>Application request metrics for the environment.</p>
    ///   - [`instances_health(Option<InstanceHealthSummary>)`](crate::output::DescribeEnvironmentHealthOutput::instances_health): <p>Summary health information for the instances in the environment.</p>
    ///   - [`refreshed_at(Option<DateTime>)`](crate::output::DescribeEnvironmentHealthOutput::refreshed_at): <p>The date and time that the health information was retrieved.</p>
    /// - On failure, responds with [`SdkError<DescribeEnvironmentHealthError>`](crate::error::DescribeEnvironmentHealthError)
    pub fn describe_environment_health(&self) -> fluent_builders::DescribeEnvironmentHealth {
        fluent_builders::DescribeEnvironmentHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEnvironmentManagedActionHistory`](crate::client::fluent_builders::DescribeEnvironmentManagedActionHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEnvironmentManagedActionHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironmentManagedActionHistory::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::DescribeEnvironmentManagedActionHistory::set_environment_id): <p>The environment ID of the target environment.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironmentManagedActionHistory::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::DescribeEnvironmentManagedActionHistory::set_environment_name): <p>The name of the target environment.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironmentManagedActionHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEnvironmentManagedActionHistory::set_next_token): <p>The pagination token returned by a previous request.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::DescribeEnvironmentManagedActionHistory::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::DescribeEnvironmentManagedActionHistory::set_max_items): <p>The maximum number of items to return for a single request.</p>
    /// - On success, responds with [`DescribeEnvironmentManagedActionHistoryOutput`](crate::output::DescribeEnvironmentManagedActionHistoryOutput) with field(s):
    ///   - [`managed_action_history_items(Option<Vec<ManagedActionHistoryItem>>)`](crate::output::DescribeEnvironmentManagedActionHistoryOutput::managed_action_history_items): <p>A list of completed and failed managed actions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEnvironmentManagedActionHistoryOutput::next_token): <p>A pagination token that you pass to <code>DescribeEnvironmentManagedActionHistory</code> to get the next page of results.</p>
    /// - On failure, responds with [`SdkError<DescribeEnvironmentManagedActionHistoryError>`](crate::error::DescribeEnvironmentManagedActionHistoryError)
    pub fn describe_environment_managed_action_history(
        &self,
    ) -> fluent_builders::DescribeEnvironmentManagedActionHistory {
        fluent_builders::DescribeEnvironmentManagedActionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEnvironmentManagedActions`](crate::client::fluent_builders::DescribeEnvironmentManagedActions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironmentManagedActions::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::DescribeEnvironmentManagedActions::set_environment_name): <p>The name of the target environment.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironmentManagedActions::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::DescribeEnvironmentManagedActions::set_environment_id): <p>The environment ID of the target environment.</p>
    ///   - [`status(ActionStatus)`](crate::client::fluent_builders::DescribeEnvironmentManagedActions::status) / [`set_status(Option<ActionStatus>)`](crate::client::fluent_builders::DescribeEnvironmentManagedActions::set_status): <p>To show only actions with a particular status, specify a status.</p>
    /// - On success, responds with [`DescribeEnvironmentManagedActionsOutput`](crate::output::DescribeEnvironmentManagedActionsOutput) with field(s):
    ///   - [`managed_actions(Option<Vec<ManagedAction>>)`](crate::output::DescribeEnvironmentManagedActionsOutput::managed_actions): <p>A list of upcoming and in-progress managed actions.</p>
    /// - On failure, responds with [`SdkError<DescribeEnvironmentManagedActionsError>`](crate::error::DescribeEnvironmentManagedActionsError)
    pub fn describe_environment_managed_actions(
        &self,
    ) -> fluent_builders::DescribeEnvironmentManagedActions {
        fluent_builders::DescribeEnvironmentManagedActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEnvironmentResources`](crate::client::fluent_builders::DescribeEnvironmentResources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironmentResources::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::DescribeEnvironmentResources::set_environment_id): <p>The ID of the environment to retrieve AWS resource usage data.</p>  <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironmentResources::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::DescribeEnvironmentResources::set_environment_name): <p>The name of the environment to retrieve AWS resource usage data.</p>  <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    /// - On success, responds with [`DescribeEnvironmentResourcesOutput`](crate::output::DescribeEnvironmentResourcesOutput) with field(s):
    ///   - [`environment_resources(Option<EnvironmentResourceDescription>)`](crate::output::DescribeEnvironmentResourcesOutput::environment_resources): <p> A list of <code>EnvironmentResourceDescription</code>. </p>
    /// - On failure, responds with [`SdkError<DescribeEnvironmentResourcesError>`](crate::error::DescribeEnvironmentResourcesError)
    pub fn describe_environment_resources(&self) -> fluent_builders::DescribeEnvironmentResources {
        fluent_builders::DescribeEnvironmentResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEnvironments`](crate::client::fluent_builders::DescribeEnvironments) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironments::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DescribeEnvironments::set_application_name): <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application.</p>
    ///   - [`version_label(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironments::version_label) / [`set_version_label(Option<String>)`](crate::client::fluent_builders::DescribeEnvironments::set_version_label): <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application version.</p>
    ///   - [`environment_ids(Vec<String>)`](crate::client::fluent_builders::DescribeEnvironments::environment_ids) / [`set_environment_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeEnvironments::set_environment_ids): <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified IDs.</p>
    ///   - [`environment_names(Vec<String>)`](crate::client::fluent_builders::DescribeEnvironments::environment_names) / [`set_environment_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeEnvironments::set_environment_names): <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified names.</p>
    ///   - [`include_deleted(bool)`](crate::client::fluent_builders::DescribeEnvironments::include_deleted) / [`set_include_deleted(Option<bool>)`](crate::client::fluent_builders::DescribeEnvironments::set_include_deleted): <p>Indicates whether to include deleted environments:</p>  <p> <code>true</code>: Environments that have been deleted after <code>IncludedDeletedBackTo</code> are displayed.</p>  <p> <code>false</code>: Do not include deleted environments.</p>
    ///   - [`included_deleted_back_to(DateTime)`](crate::client::fluent_builders::DescribeEnvironments::included_deleted_back_to) / [`set_included_deleted_back_to(Option<DateTime>)`](crate::client::fluent_builders::DescribeEnvironments::set_included_deleted_back_to): <p> If specified when <code>IncludeDeleted</code> is set to <code>true</code>, then environments deleted after this date are displayed. </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEnvironments::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEnvironments::set_max_records): <p>For a paginated request. Specify a maximum number of environments to include in each response.</p>  <p>If no <code>MaxRecords</code> is specified, all available environments are retrieved in a single response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEnvironments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEnvironments::set_next_token): <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>  <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
    /// - On success, responds with [`DescribeEnvironmentsOutput`](crate::output::DescribeEnvironmentsOutput) with field(s):
    ///   - [`environments(Option<Vec<EnvironmentDescription>>)`](crate::output::DescribeEnvironmentsOutput::environments): <p> Returns an <code>EnvironmentDescription</code> list. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEnvironmentsOutput::next_token): <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
    /// - On failure, responds with [`SdkError<DescribeEnvironmentsError>`](crate::error::DescribeEnvironmentsError)
    pub fn describe_environments(&self) -> fluent_builders::DescribeEnvironments {
        fluent_builders::DescribeEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_application_name): <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those associated with this application.</p>
    ///   - [`version_label(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::version_label) / [`set_version_label(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_version_label): <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this application version.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_template_name): <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that are associated with this environment configuration.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_environment_id): <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_environment_name): <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
    ///   - [`platform_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::platform_arn) / [`set_platform_arn(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_platform_arn): <p>The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this custom platform version.</p>
    ///   - [`request_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::request_id) / [`set_request_id(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_request_id): <p>If specified, AWS Elastic Beanstalk restricts the described events to include only those associated with this request ID.</p>
    ///   - [`severity(EventSeverity)`](crate::client::fluent_builders::DescribeEvents::severity) / [`set_severity(Option<EventSeverity>)`](crate::client::fluent_builders::DescribeEvents::set_severity): <p>If specified, limits the events returned from this call to include only those with the specified severity or higher.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_start_time): <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur on or after this time.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_end_time): <p> If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur up to, but not including, the <code>EndTime</code>. </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEvents::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_max_records): <p>Specifies the maximum number of events that can be returned, beginning with the most recent event.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_next_token): <p>Pagination token. If specified, the events return the next batch of results.</p>
    /// - On success, responds with [`DescribeEventsOutput`](crate::output::DescribeEventsOutput) with field(s):
    ///   - [`events(Option<Vec<EventDescription>>)`](crate::output::DescribeEventsOutput::events): <p> A list of <code>EventDescription</code>. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEventsOutput::next_token): <p> If returned, this indicates that there are more results to obtain. Use this token in the next <code>DescribeEvents</code> call to get the next batch of events. </p>
    /// - On failure, responds with [`SdkError<DescribeEventsError>`](crate::error::DescribeEventsError)
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstancesHealth`](crate::client::fluent_builders::DescribeInstancesHealth) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::DescribeInstancesHealth::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::DescribeInstancesHealth::set_environment_name): <p>Specify the AWS Elastic Beanstalk environment by name.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::DescribeInstancesHealth::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::DescribeInstancesHealth::set_environment_id): <p>Specify the AWS Elastic Beanstalk environment by ID.</p>
    ///   - [`attribute_names(Vec<InstancesHealthAttribute>)`](crate::client::fluent_builders::DescribeInstancesHealth::attribute_names) / [`set_attribute_names(Option<Vec<InstancesHealthAttribute>>)`](crate::client::fluent_builders::DescribeInstancesHealth::set_attribute_names): <p>Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns a list of instances.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInstancesHealth::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInstancesHealth::set_next_token): <p>Specify the pagination token returned by a previous call.</p>
    /// - On success, responds with [`DescribeInstancesHealthOutput`](crate::output::DescribeInstancesHealthOutput) with field(s):
    ///   - [`instance_health_list(Option<Vec<SingleInstanceHealth>>)`](crate::output::DescribeInstancesHealthOutput::instance_health_list): <p>Detailed health information about each instance.</p>  <p>The output differs slightly between Linux and Windows environments. There is a difference in the members that are supported under the <code>   <cpuutilization></cpuutilization></code> type.</p>
    ///   - [`refreshed_at(Option<DateTime>)`](crate::output::DescribeInstancesHealthOutput::refreshed_at): <p>The date and time that the health information was retrieved.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInstancesHealthOutput::next_token): <p>Pagination token for the next page of results, if available.</p>
    /// - On failure, responds with [`SdkError<DescribeInstancesHealthError>`](crate::error::DescribeInstancesHealthError)
    pub fn describe_instances_health(&self) -> fluent_builders::DescribeInstancesHealth {
        fluent_builders::DescribeInstancesHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePlatformVersion`](crate::client::fluent_builders::DescribePlatformVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`platform_arn(impl Into<String>)`](crate::client::fluent_builders::DescribePlatformVersion::platform_arn) / [`set_platform_arn(Option<String>)`](crate::client::fluent_builders::DescribePlatformVersion::set_platform_arn): <p>The ARN of the platform version.</p>
    /// - On success, responds with [`DescribePlatformVersionOutput`](crate::output::DescribePlatformVersionOutput) with field(s):
    ///   - [`platform_description(Option<PlatformDescription>)`](crate::output::DescribePlatformVersionOutput::platform_description): <p>Detailed information about the platform version.</p>
    /// - On failure, responds with [`SdkError<DescribePlatformVersionError>`](crate::error::DescribePlatformVersionError)
    pub fn describe_platform_version(&self) -> fluent_builders::DescribePlatformVersion {
        fluent_builders::DescribePlatformVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateEnvironmentOperationsRole`](crate::client::fluent_builders::DisassociateEnvironmentOperationsRole) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateEnvironmentOperationsRole::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::DisassociateEnvironmentOperationsRole::set_environment_name): <p>The name of the environment from which to disassociate the operations role.</p>
    /// - On success, responds with [`DisassociateEnvironmentOperationsRoleOutput`](crate::output::DisassociateEnvironmentOperationsRoleOutput)

    /// - On failure, responds with [`SdkError<DisassociateEnvironmentOperationsRoleError>`](crate::error::DisassociateEnvironmentOperationsRoleError)
    pub fn disassociate_environment_operations_role(
        &self,
    ) -> fluent_builders::DisassociateEnvironmentOperationsRole {
        fluent_builders::DisassociateEnvironmentOperationsRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAvailableSolutionStacks`](crate::client::fluent_builders::ListAvailableSolutionStacks) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::ListAvailableSolutionStacks::send) it.

    /// - On success, responds with [`ListAvailableSolutionStacksOutput`](crate::output::ListAvailableSolutionStacksOutput) with field(s):
    ///   - [`solution_stacks(Option<Vec<String>>)`](crate::output::ListAvailableSolutionStacksOutput::solution_stacks): <p>A list of available solution stacks.</p>
    ///   - [`solution_stack_details(Option<Vec<SolutionStackDescription>>)`](crate::output::ListAvailableSolutionStacksOutput::solution_stack_details): <p> A list of available solution stacks and their <code>SolutionStackDescription</code>. </p>
    /// - On failure, responds with [`SdkError<ListAvailableSolutionStacksError>`](crate::error::ListAvailableSolutionStacksError)
    pub fn list_available_solution_stacks(&self) -> fluent_builders::ListAvailableSolutionStacks {
        fluent_builders::ListAvailableSolutionStacks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPlatformBranches`](crate::client::fluent_builders::ListPlatformBranches) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPlatformBranches::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<SearchFilter>)`](crate::client::fluent_builders::ListPlatformBranches::filters) / [`set_filters(Option<Vec<SearchFilter>>)`](crate::client::fluent_builders::ListPlatformBranches::set_filters): <p>Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical conjunction (AND) of the separate <code>SearchFilter</code> terms.</p>  <p>The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most operators take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple values.</p>  <ul>   <li> <p> <code>Attribute = BranchName</code>:</p>    <ul>     <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>    </ul> </li>   <li> <p> <code>Attribute = LifecycleState</code>:</p>    <ul>     <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code> </p> </li>     <li> <p> <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> | <code>retired</code> </p> </li>    </ul> </li>   <li> <p> <code>Attribute = PlatformName</code>:</p>    <ul>     <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>    </ul> </li>   <li> <p> <code>Attribute = TierType</code>:</p>    <ul>     <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> </p> </li>     <li> <p> <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code> </p> </li>    </ul> </li>  </ul>  <p>Array size: limited to 10 <code>SearchFilter</code> objects.</p>  <p>Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::ListPlatformBranches::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::ListPlatformBranches::set_max_records): <p>The maximum number of platform branch values returned in one call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPlatformBranches::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPlatformBranches::set_next_token): <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>  <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
    /// - On success, responds with [`ListPlatformBranchesOutput`](crate::output::ListPlatformBranchesOutput) with field(s):
    ///   - [`platform_branch_summary_list(Option<Vec<PlatformBranchSummary>>)`](crate::output::ListPlatformBranchesOutput::platform_branch_summary_list): <p>Summary information about the platform branches.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPlatformBranchesOutput::next_token): <p>In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a subsequent request to get the next response page.</p>
    /// - On failure, responds with [`SdkError<ListPlatformBranchesError>`](crate::error::ListPlatformBranchesError)
    pub fn list_platform_branches(&self) -> fluent_builders::ListPlatformBranches {
        fluent_builders::ListPlatformBranches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPlatformVersions`](crate::client::fluent_builders::ListPlatformVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPlatformVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<PlatformFilter>)`](crate::client::fluent_builders::ListPlatformVersions::filters) / [`set_filters(Option<Vec<PlatformFilter>>)`](crate::client::fluent_builders::ListPlatformVersions::set_filters): <p>Criteria for restricting the resulting list of platform versions. The filter is interpreted as a logical conjunction (AND) of the separate <code>PlatformFilter</code> terms.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::ListPlatformVersions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::ListPlatformVersions::set_max_records): <p>The maximum number of platform version values returned in one call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPlatformVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPlatformVersions::set_next_token): <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>  <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
    /// - On success, responds with [`ListPlatformVersionsOutput`](crate::output::ListPlatformVersionsOutput) with field(s):
    ///   - [`platform_summary_list(Option<Vec<PlatformSummary>>)`](crate::output::ListPlatformVersionsOutput::platform_summary_list): <p>Summary information about the platform versions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPlatformVersionsOutput::next_token): <p>In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a subsequent request to get the next response page.</p>
    /// - On failure, responds with [`SdkError<ListPlatformVersionsError>`](crate::error::ListPlatformVersionsError)
    pub fn list_platform_versions(&self) -> fluent_builders::ListPlatformVersions {
        fluent_builders::ListPlatformVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resouce for which a tag list is requested.</p>  <p>Must be the ARN of an Elastic Beanstalk resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::ListTagsForResourceOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the resource for which a tag list was requested.</p>
    ///   - [`resource_tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::resource_tags): <p>A list of tag key-value pairs.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RebuildEnvironment`](crate::client::fluent_builders::RebuildEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::RebuildEnvironment::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::RebuildEnvironment::set_environment_id): <p>The ID of the environment to rebuild.</p>  <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::RebuildEnvironment::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::RebuildEnvironment::set_environment_name): <p>The name of the environment to rebuild.</p>  <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    /// - On success, responds with [`RebuildEnvironmentOutput`](crate::output::RebuildEnvironmentOutput)

    /// - On failure, responds with [`SdkError<RebuildEnvironmentError>`](crate::error::RebuildEnvironmentError)
    pub fn rebuild_environment(&self) -> fluent_builders::RebuildEnvironment {
        fluent_builders::RebuildEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RequestEnvironmentInfo`](crate::client::fluent_builders::RequestEnvironmentInfo) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::RequestEnvironmentInfo::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::RequestEnvironmentInfo::set_environment_id): <p>The ID of the environment of the requested data.</p>  <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>  <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::RequestEnvironmentInfo::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::RequestEnvironmentInfo::set_environment_name): <p>The name of the environment of the requested data.</p>  <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>  <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    ///   - [`info_type(EnvironmentInfoType)`](crate::client::fluent_builders::RequestEnvironmentInfo::info_type) / [`set_info_type(Option<EnvironmentInfoType>)`](crate::client::fluent_builders::RequestEnvironmentInfo::set_info_type): <p>The type of information to request.</p>
    /// - On success, responds with [`RequestEnvironmentInfoOutput`](crate::output::RequestEnvironmentInfoOutput)

    /// - On failure, responds with [`SdkError<RequestEnvironmentInfoError>`](crate::error::RequestEnvironmentInfoError)
    pub fn request_environment_info(&self) -> fluent_builders::RequestEnvironmentInfo {
        fluent_builders::RequestEnvironmentInfo::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestartAppServer`](crate::client::fluent_builders::RestartAppServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::RestartAppServer::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::RestartAppServer::set_environment_id): <p>The ID of the environment to restart the server for.</p>  <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::RestartAppServer::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::RestartAppServer::set_environment_name): <p>The name of the environment to restart the server for.</p>  <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    /// - On success, responds with [`RestartAppServerOutput`](crate::output::RestartAppServerOutput)

    /// - On failure, responds with [`SdkError<RestartAppServerError>`](crate::error::RestartAppServerError)
    pub fn restart_app_server(&self) -> fluent_builders::RestartAppServer {
        fluent_builders::RestartAppServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RetrieveEnvironmentInfo`](crate::client::fluent_builders::RetrieveEnvironmentInfo) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::RetrieveEnvironmentInfo::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::RetrieveEnvironmentInfo::set_environment_id): <p>The ID of the data's environment.</p>  <p>If no such environment is found, returns an <code>InvalidParameterValue</code> error.</p>  <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::RetrieveEnvironmentInfo::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::RetrieveEnvironmentInfo::set_environment_name): <p>The name of the data's environment.</p>  <p> If no such environment is found, returns an <code>InvalidParameterValue</code> error. </p>  <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    ///   - [`info_type(EnvironmentInfoType)`](crate::client::fluent_builders::RetrieveEnvironmentInfo::info_type) / [`set_info_type(Option<EnvironmentInfoType>)`](crate::client::fluent_builders::RetrieveEnvironmentInfo::set_info_type): <p>The type of information to retrieve.</p>
    /// - On success, responds with [`RetrieveEnvironmentInfoOutput`](crate::output::RetrieveEnvironmentInfoOutput) with field(s):
    ///   - [`environment_info(Option<Vec<EnvironmentInfoDescription>>)`](crate::output::RetrieveEnvironmentInfoOutput::environment_info): <p> The <code>EnvironmentInfoDescription</code> of the environment. </p>
    /// - On failure, responds with [`SdkError<RetrieveEnvironmentInfoError>`](crate::error::RetrieveEnvironmentInfoError)
    pub fn retrieve_environment_info(&self) -> fluent_builders::RetrieveEnvironmentInfo {
        fluent_builders::RetrieveEnvironmentInfo::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SwapEnvironmentCNAMEs`](crate::client::fluent_builders::SwapEnvironmentCNAMEs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_environment_id(impl Into<String>)`](crate::client::fluent_builders::SwapEnvironmentCNAMEs::source_environment_id) / [`set_source_environment_id(Option<String>)`](crate::client::fluent_builders::SwapEnvironmentCNAMEs::set_source_environment_id): <p>The ID of the source environment.</p>  <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentId</code>, you must specify the <code>DestinationEnvironmentId</code>. </p>
    ///   - [`source_environment_name(impl Into<String>)`](crate::client::fluent_builders::SwapEnvironmentCNAMEs::source_environment_name) / [`set_source_environment_name(Option<String>)`](crate::client::fluent_builders::SwapEnvironmentCNAMEs::set_source_environment_name): <p>The name of the source environment.</p>  <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentName</code>, you must specify the <code>DestinationEnvironmentName</code>. </p>
    ///   - [`destination_environment_id(impl Into<String>)`](crate::client::fluent_builders::SwapEnvironmentCNAMEs::destination_environment_id) / [`set_destination_environment_id(Option<String>)`](crate::client::fluent_builders::SwapEnvironmentCNAMEs::set_destination_environment_id): <p>The ID of the destination environment.</p>  <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentId</code> with the <code>DestinationEnvironmentId</code>. </p>
    ///   - [`destination_environment_name(impl Into<String>)`](crate::client::fluent_builders::SwapEnvironmentCNAMEs::destination_environment_name) / [`set_destination_environment_name(Option<String>)`](crate::client::fluent_builders::SwapEnvironmentCNAMEs::set_destination_environment_name): <p>The name of the destination environment.</p>  <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentName</code> with the <code>DestinationEnvironmentName</code>. </p>
    /// - On success, responds with [`SwapEnvironmentCnamEsOutput`](crate::output::SwapEnvironmentCnamEsOutput)

    /// - On failure, responds with [`SdkError<SwapEnvironmentCNAMEsError>`](crate::error::SwapEnvironmentCNAMEsError)
    pub fn swap_environment_cnam_es(&self) -> fluent_builders::SwapEnvironmentCNAMEs {
        fluent_builders::SwapEnvironmentCNAMEs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TerminateEnvironment`](crate::client::fluent_builders::TerminateEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::TerminateEnvironment::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::TerminateEnvironment::set_environment_id): <p>The ID of the environment to terminate.</p>  <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::TerminateEnvironment::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::TerminateEnvironment::set_environment_name): <p>The name of the environment to terminate.</p>  <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    ///   - [`terminate_resources(bool)`](crate::client::fluent_builders::TerminateEnvironment::terminate_resources) / [`set_terminate_resources(Option<bool>)`](crate::client::fluent_builders::TerminateEnvironment::set_terminate_resources): <p>Indicates whether the associated AWS resources should shut down when the environment is terminated:</p>  <ul>   <li> <p> <code>true</code>: The specified environment as well as the associated AWS resources, such as Auto Scaling group and LoadBalancer, are terminated.</p> </li>   <li> <p> <code>false</code>: AWS Elastic Beanstalk resource management is removed from the environment, but the AWS resources continue to operate.</p> </li>  </ul>  <p> For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS Elastic Beanstalk User Guide. </a> </p>  <p> Default: <code>true</code> </p>  <p> Valid Values: <code>true</code> | <code>false</code> </p>
    ///   - [`force_terminate(bool)`](crate::client::fluent_builders::TerminateEnvironment::force_terminate) / [`set_force_terminate(Option<bool>)`](crate::client::fluent_builders::TerminateEnvironment::set_force_terminate): <p>Terminates the target environment even if another environment in the same group is dependent on it.</p>
    /// - On success, responds with [`TerminateEnvironmentOutput`](crate::output::TerminateEnvironmentOutput) with field(s):
    ///   - [`environment_name(Option<String>)`](crate::output::TerminateEnvironmentOutput::environment_name): <p>The name of this environment.</p>
    ///   - [`environment_id(Option<String>)`](crate::output::TerminateEnvironmentOutput::environment_id): <p>The ID of this environment.</p>
    ///   - [`application_name(Option<String>)`](crate::output::TerminateEnvironmentOutput::application_name): <p>The name of the application associated with this environment.</p>
    ///   - [`version_label(Option<String>)`](crate::output::TerminateEnvironmentOutput::version_label): <p>The application version deployed in this environment.</p>
    ///   - [`solution_stack_name(Option<String>)`](crate::output::TerminateEnvironmentOutput::solution_stack_name): <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
    ///   - [`platform_arn(Option<String>)`](crate::output::TerminateEnvironmentOutput::platform_arn): <p>The ARN of the platform version.</p>
    ///   - [`template_name(Option<String>)`](crate::output::TerminateEnvironmentOutput::template_name): <p>The name of the configuration template used to originally launch this environment.</p>
    ///   - [`description(Option<String>)`](crate::output::TerminateEnvironmentOutput::description): <p>Describes this environment.</p>
    ///   - [`endpoint_url(Option<String>)`](crate::output::TerminateEnvironmentOutput::endpoint_url): <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
    ///   - [`cname(Option<String>)`](crate::output::TerminateEnvironmentOutput::cname): <p>The URL to the CNAME for this environment.</p>
    ///   - [`date_created(Option<DateTime>)`](crate::output::TerminateEnvironmentOutput::date_created): <p>The creation date for this environment.</p>
    ///   - [`date_updated(Option<DateTime>)`](crate::output::TerminateEnvironmentOutput::date_updated): <p>The last modified date for this environment.</p>
    ///   - [`status(Option<EnvironmentStatus>)`](crate::output::TerminateEnvironmentOutput::status): <p>The current operational status of the environment:</p>  <ul>   <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>   <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>   <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>   <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>   <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>  </ul>
    ///   - [`abortable_operation_in_progress(Option<bool>)`](crate::output::TerminateEnvironmentOutput::abortable_operation_in_progress): <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>  <p> <code>true:</code> There is an update in progress. </p>  <p> <code>false:</code> There are no updates currently in progress. </p>
    ///   - [`health(Option<EnvironmentHealth>)`](crate::output::TerminateEnvironmentOutput::health): <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>  <ul>   <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>   <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>   <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>   <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>  </ul>  <p> Default: <code>Grey</code> </p>
    ///   - [`health_status(Option<EnvironmentHealthStatus>)`](crate::output::TerminateEnvironmentOutput::health_status): <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
    ///   - [`resources(Option<EnvironmentResourcesDescription>)`](crate::output::TerminateEnvironmentOutput::resources): <p>The description of the AWS resources used by this environment.</p>
    ///   - [`tier(Option<EnvironmentTier>)`](crate::output::TerminateEnvironmentOutput::tier): <p>Describes the current tier of this environment.</p>
    ///   - [`environment_links(Option<Vec<EnvironmentLink>>)`](crate::output::TerminateEnvironmentOutput::environment_links): <p>A list of links to other environments in the same group.</p>
    ///   - [`environment_arn(Option<String>)`](crate::output::TerminateEnvironmentOutput::environment_arn): <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
    ///   - [`operations_role(Option<String>)`](crate::output::TerminateEnvironmentOutput::operations_role): <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<TerminateEnvironmentError>`](crate::error::TerminateEnvironmentError)
    pub fn terminate_environment(&self) -> fluent_builders::TerminateEnvironment {
        fluent_builders::TerminateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_application_name): <p>The name of the application to update. If no such application is found, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_description): <p>A new description for the application.</p>  <p>Default: If not specified, AWS Elastic Beanstalk does not update the description.</p>
    /// - On success, responds with [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput) with field(s):
    ///   - [`application(Option<ApplicationDescription>)`](crate::output::UpdateApplicationOutput::application): <p> The <code>ApplicationDescription</code> of the application. </p>
    /// - On failure, responds with [`SdkError<UpdateApplicationError>`](crate::error::UpdateApplicationError)
    pub fn update_application(&self) -> fluent_builders::UpdateApplication {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplicationResourceLifecycle`](crate::client::fluent_builders::UpdateApplicationResourceLifecycle) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::UpdateApplicationResourceLifecycle::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::UpdateApplicationResourceLifecycle::set_application_name): <p>The name of the application.</p>
    ///   - [`resource_lifecycle_config(ApplicationResourceLifecycleConfig)`](crate::client::fluent_builders::UpdateApplicationResourceLifecycle::resource_lifecycle_config) / [`set_resource_lifecycle_config(Option<ApplicationResourceLifecycleConfig>)`](crate::client::fluent_builders::UpdateApplicationResourceLifecycle::set_resource_lifecycle_config): <p>The lifecycle configuration.</p>
    /// - On success, responds with [`UpdateApplicationResourceLifecycleOutput`](crate::output::UpdateApplicationResourceLifecycleOutput) with field(s):
    ///   - [`application_name(Option<String>)`](crate::output::UpdateApplicationResourceLifecycleOutput::application_name): <p>The name of the application.</p>
    ///   - [`resource_lifecycle_config(Option<ApplicationResourceLifecycleConfig>)`](crate::output::UpdateApplicationResourceLifecycleOutput::resource_lifecycle_config): <p>The lifecycle configuration.</p>
    /// - On failure, responds with [`SdkError<UpdateApplicationResourceLifecycleError>`](crate::error::UpdateApplicationResourceLifecycleError)
    pub fn update_application_resource_lifecycle(
        &self,
    ) -> fluent_builders::UpdateApplicationResourceLifecycle {
        fluent_builders::UpdateApplicationResourceLifecycle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplicationVersion`](crate::client::fluent_builders::UpdateApplicationVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::UpdateApplicationVersion::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::UpdateApplicationVersion::set_application_name): <p>The name of the application associated with this version.</p>  <p> If no application is found with this name, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error.</p>
    ///   - [`version_label(impl Into<String>)`](crate::client::fluent_builders::UpdateApplicationVersion::version_label) / [`set_version_label(Option<String>)`](crate::client::fluent_builders::UpdateApplicationVersion::set_version_label): <p>The name of the version to update.</p>  <p>If no application version is found with this label, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateApplicationVersion::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateApplicationVersion::set_description): <p>A new description for this version.</p>
    /// - On success, responds with [`UpdateApplicationVersionOutput`](crate::output::UpdateApplicationVersionOutput) with field(s):
    ///   - [`application_version(Option<ApplicationVersionDescription>)`](crate::output::UpdateApplicationVersionOutput::application_version): <p> The <code>ApplicationVersionDescription</code> of the application version. </p>
    /// - On failure, responds with [`SdkError<UpdateApplicationVersionError>`](crate::error::UpdateApplicationVersionError)
    pub fn update_application_version(&self) -> fluent_builders::UpdateApplicationVersion {
        fluent_builders::UpdateApplicationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConfigurationTemplate`](crate::client::fluent_builders::UpdateConfigurationTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationTemplate::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationTemplate::set_application_name): <p>The name of the application associated with the configuration template to update.</p>  <p> If no application is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationTemplate::set_template_name): <p>The name of the configuration template to update.</p>  <p> If no configuration template is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationTemplate::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationTemplate::set_description): <p>A new description for the configuration.</p>
    ///   - [`option_settings(Vec<ConfigurationOptionSetting>)`](crate::client::fluent_builders::UpdateConfigurationTemplate::option_settings) / [`set_option_settings(Option<Vec<ConfigurationOptionSetting>>)`](crate::client::fluent_builders::UpdateConfigurationTemplate::set_option_settings): <p>A list of configuration option settings to update with the new specified option value.</p>
    ///   - [`options_to_remove(Vec<OptionSpecification>)`](crate::client::fluent_builders::UpdateConfigurationTemplate::options_to_remove) / [`set_options_to_remove(Option<Vec<OptionSpecification>>)`](crate::client::fluent_builders::UpdateConfigurationTemplate::set_options_to_remove): <p>A list of configuration options to remove from the configuration set.</p>  <p> Constraint: You can remove only <code>UserDefined</code> configuration options. </p>
    /// - On success, responds with [`UpdateConfigurationTemplateOutput`](crate::output::UpdateConfigurationTemplateOutput) with field(s):
    ///   - [`solution_stack_name(Option<String>)`](crate::output::UpdateConfigurationTemplateOutput::solution_stack_name): <p>The name of the solution stack this configuration set uses.</p>
    ///   - [`platform_arn(Option<String>)`](crate::output::UpdateConfigurationTemplateOutput::platform_arn): <p>The ARN of the platform version.</p>
    ///   - [`application_name(Option<String>)`](crate::output::UpdateConfigurationTemplateOutput::application_name): <p>The name of the application associated with this configuration set.</p>
    ///   - [`template_name(Option<String>)`](crate::output::UpdateConfigurationTemplateOutput::template_name): <p> If not <code>null</code>, the name of the configuration template for this configuration set. </p>
    ///   - [`description(Option<String>)`](crate::output::UpdateConfigurationTemplateOutput::description): <p>Describes this configuration set.</p>
    ///   - [`environment_name(Option<String>)`](crate::output::UpdateConfigurationTemplateOutput::environment_name): <p> If not <code>null</code>, the name of the environment for this configuration set. </p>
    ///   - [`deployment_status(Option<ConfigurationDeploymentStatus>)`](crate::output::UpdateConfigurationTemplateOutput::deployment_status): <p> If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter indicates the deployment status of this configuration set: </p>  <ul>   <li> <p> <code>null</code>: This configuration is not associated with a running environment.</p> </li>   <li> <p> <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is in the process of deploying.</p> </li>   <li> <p> <code>deployed</code>: This is the configuration that is currently deployed to the associated running environment.</p> </li>   <li> <p> <code>failed</code>: This is a draft configuration that failed to successfully deploy.</p> </li>  </ul>
    ///   - [`date_created(Option<DateTime>)`](crate::output::UpdateConfigurationTemplateOutput::date_created): <p>The date (in UTC time) when this configuration set was created.</p>
    ///   - [`date_updated(Option<DateTime>)`](crate::output::UpdateConfigurationTemplateOutput::date_updated): <p>The date (in UTC time) when this configuration set was last modified.</p>
    ///   - [`option_settings(Option<Vec<ConfigurationOptionSetting>>)`](crate::output::UpdateConfigurationTemplateOutput::option_settings): <p>A list of the configuration options and their values in this configuration set.</p>
    /// - On failure, responds with [`SdkError<UpdateConfigurationTemplateError>`](crate::error::UpdateConfigurationTemplateError)
    pub fn update_configuration_template(&self) -> fluent_builders::UpdateConfigurationTemplate {
        fluent_builders::UpdateConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEnvironment`](crate::client::fluent_builders::UpdateEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_application_name): <p>The name of the application with which the environment is associated.</p>
    ///   - [`environment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::environment_id) / [`set_environment_id(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_environment_id): <p>The ID of the environment to update.</p>  <p>If no environment with this ID exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.</p>  <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_environment_name): <p>The name of the environment to update. If no environment with this name exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>  <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_group_name): <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name or environment ID parameters. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_description): <p>If this parameter is specified, AWS Elastic Beanstalk updates the description of this environment.</p>
    ///   - [`tier(EnvironmentTier)`](crate::client::fluent_builders::UpdateEnvironment::tier) / [`set_tier(Option<EnvironmentTier>)`](crate::client::fluent_builders::UpdateEnvironment::set_tier): <p>This specifies the tier to use to update the environment.</p>  <p>Condition: At this time, if you change the tier version, name, or type, AWS Elastic Beanstalk returns <code>InvalidParameterValue</code> error. </p>
    ///   - [`version_label(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::version_label) / [`set_version_label(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_version_label): <p>If this parameter is specified, AWS Elastic Beanstalk deploys the named application version to the environment. If no such application version is found, returns an <code>InvalidParameterValue</code> error. </p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_template_name): <p>If this parameter is specified, AWS Elastic Beanstalk deploys this configuration template to the environment. If no such configuration template is found, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
    ///   - [`solution_stack_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::solution_stack_name) / [`set_solution_stack_name(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_solution_stack_name): <p>This specifies the platform version that the environment will run after the environment is updated.</p>
    ///   - [`platform_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateEnvironment::platform_arn) / [`set_platform_arn(Option<String>)`](crate::client::fluent_builders::UpdateEnvironment::set_platform_arn): <p>The ARN of the platform, if used.</p>
    ///   - [`option_settings(Vec<ConfigurationOptionSetting>)`](crate::client::fluent_builders::UpdateEnvironment::option_settings) / [`set_option_settings(Option<Vec<ConfigurationOptionSetting>>)`](crate::client::fluent_builders::UpdateEnvironment::set_option_settings): <p>If specified, AWS Elastic Beanstalk updates the configuration set associated with the running environment and sets the specified configuration options to the requested value.</p>
    ///   - [`options_to_remove(Vec<OptionSpecification>)`](crate::client::fluent_builders::UpdateEnvironment::options_to_remove) / [`set_options_to_remove(Option<Vec<OptionSpecification>>)`](crate::client::fluent_builders::UpdateEnvironment::set_options_to_remove): <p>A list of custom user-defined configuration options to remove from the configuration set for this environment.</p>
    /// - On success, responds with [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput) with field(s):
    ///   - [`environment_name(Option<String>)`](crate::output::UpdateEnvironmentOutput::environment_name): <p>The name of this environment.</p>
    ///   - [`environment_id(Option<String>)`](crate::output::UpdateEnvironmentOutput::environment_id): <p>The ID of this environment.</p>
    ///   - [`application_name(Option<String>)`](crate::output::UpdateEnvironmentOutput::application_name): <p>The name of the application associated with this environment.</p>
    ///   - [`version_label(Option<String>)`](crate::output::UpdateEnvironmentOutput::version_label): <p>The application version deployed in this environment.</p>
    ///   - [`solution_stack_name(Option<String>)`](crate::output::UpdateEnvironmentOutput::solution_stack_name): <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
    ///   - [`platform_arn(Option<String>)`](crate::output::UpdateEnvironmentOutput::platform_arn): <p>The ARN of the platform version.</p>
    ///   - [`template_name(Option<String>)`](crate::output::UpdateEnvironmentOutput::template_name): <p>The name of the configuration template used to originally launch this environment.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateEnvironmentOutput::description): <p>Describes this environment.</p>
    ///   - [`endpoint_url(Option<String>)`](crate::output::UpdateEnvironmentOutput::endpoint_url): <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
    ///   - [`cname(Option<String>)`](crate::output::UpdateEnvironmentOutput::cname): <p>The URL to the CNAME for this environment.</p>
    ///   - [`date_created(Option<DateTime>)`](crate::output::UpdateEnvironmentOutput::date_created): <p>The creation date for this environment.</p>
    ///   - [`date_updated(Option<DateTime>)`](crate::output::UpdateEnvironmentOutput::date_updated): <p>The last modified date for this environment.</p>
    ///   - [`status(Option<EnvironmentStatus>)`](crate::output::UpdateEnvironmentOutput::status): <p>The current operational status of the environment:</p>  <ul>   <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>   <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>   <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>   <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>   <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>  </ul>
    ///   - [`abortable_operation_in_progress(Option<bool>)`](crate::output::UpdateEnvironmentOutput::abortable_operation_in_progress): <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>  <p> <code>true:</code> There is an update in progress. </p>  <p> <code>false:</code> There are no updates currently in progress. </p>
    ///   - [`health(Option<EnvironmentHealth>)`](crate::output::UpdateEnvironmentOutput::health): <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>  <ul>   <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>   <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>   <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>   <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>  </ul>  <p> Default: <code>Grey</code> </p>
    ///   - [`health_status(Option<EnvironmentHealthStatus>)`](crate::output::UpdateEnvironmentOutput::health_status): <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
    ///   - [`resources(Option<EnvironmentResourcesDescription>)`](crate::output::UpdateEnvironmentOutput::resources): <p>The description of the AWS resources used by this environment.</p>
    ///   - [`tier(Option<EnvironmentTier>)`](crate::output::UpdateEnvironmentOutput::tier): <p>Describes the current tier of this environment.</p>
    ///   - [`environment_links(Option<Vec<EnvironmentLink>>)`](crate::output::UpdateEnvironmentOutput::environment_links): <p>A list of links to other environments in the same group.</p>
    ///   - [`environment_arn(Option<String>)`](crate::output::UpdateEnvironmentOutput::environment_arn): <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
    ///   - [`operations_role(Option<String>)`](crate::output::UpdateEnvironmentOutput::operations_role): <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<UpdateEnvironmentError>`](crate::error::UpdateEnvironmentError)
    pub fn update_environment(&self) -> fluent_builders::UpdateEnvironment {
        fluent_builders::UpdateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTagsForResource`](crate::client::fluent_builders::UpdateTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UpdateTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resouce to be updated.</p>  <p>Must be the ARN of an Elastic Beanstalk resource.</p>
    ///   - [`tags_to_add(Vec<Tag>)`](crate::client::fluent_builders::UpdateTagsForResource::tags_to_add) / [`set_tags_to_add(Option<Vec<Tag>>)`](crate::client::fluent_builders::UpdateTagsForResource::set_tags_to_add): <p>A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.</p>  <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
    ///   - [`tags_to_remove(Vec<String>)`](crate::client::fluent_builders::UpdateTagsForResource::tags_to_remove) / [`set_tags_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateTagsForResource::set_tags_to_remove): <p>A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.</p>  <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
    /// - On success, responds with [`UpdateTagsForResourceOutput`](crate::output::UpdateTagsForResourceOutput)

    /// - On failure, responds with [`SdkError<UpdateTagsForResourceError>`](crate::error::UpdateTagsForResourceError)
    pub fn update_tags_for_resource(&self) -> fluent_builders::UpdateTagsForResource {
        fluent_builders::UpdateTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ValidateConfigurationSettings`](crate::client::fluent_builders::ValidateConfigurationSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::ValidateConfigurationSettings::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::ValidateConfigurationSettings::set_application_name): <p>The name of the application that the configuration template or environment belongs to.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::ValidateConfigurationSettings::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::ValidateConfigurationSettings::set_template_name): <p>The name of the configuration template to validate the settings against.</p>  <p>Condition: You cannot specify both this and an environment name.</p>
    ///   - [`environment_name(impl Into<String>)`](crate::client::fluent_builders::ValidateConfigurationSettings::environment_name) / [`set_environment_name(Option<String>)`](crate::client::fluent_builders::ValidateConfigurationSettings::set_environment_name): <p>The name of the environment to validate the settings against.</p>  <p>Condition: You cannot specify both this and a configuration template name.</p>
    ///   - [`option_settings(Vec<ConfigurationOptionSetting>)`](crate::client::fluent_builders::ValidateConfigurationSettings::option_settings) / [`set_option_settings(Option<Vec<ConfigurationOptionSetting>>)`](crate::client::fluent_builders::ValidateConfigurationSettings::set_option_settings): <p>A list of the options and desired values to evaluate.</p>
    /// - On success, responds with [`ValidateConfigurationSettingsOutput`](crate::output::ValidateConfigurationSettingsOutput) with field(s):
    ///   - [`messages(Option<Vec<ValidationMessage>>)`](crate::output::ValidateConfigurationSettingsOutput::messages): <p> A list of <code>ValidationMessage</code>. </p>
    /// - On failure, responds with [`SdkError<ValidateConfigurationSettingsError>`](crate::error::ValidateConfigurationSettingsError)
    pub fn validate_configuration_settings(
        &self,
    ) -> fluent_builders::ValidateConfigurationSettings {
        fluent_builders::ValidateConfigurationSettings::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AbortEnvironmentUpdate`.
    ///
    /// <p>Cancels in-progress environment configuration update or application version deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AbortEnvironmentUpdate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::abort_environment_update_input::Builder,
    }
    impl AbortEnvironmentUpdate {
        /// Creates a new `AbortEnvironmentUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AbortEnvironmentUpdateOutput,
            aws_smithy_http::result::SdkError<crate::error::AbortEnvironmentUpdateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This specifies the ID of the environment with the in-progress update that you want to cancel.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>This specifies the ID of the environment with the in-progress update that you want to cancel.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>This specifies the name of the environment with the in-progress update that you want to cancel.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>This specifies the name of the environment with the in-progress update that you want to cancel.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApplyEnvironmentManagedAction`.
    ///
    /// <p>Applies a scheduled managed action immediately. A managed action can be applied only if its status is <code>Scheduled</code>. Get the status and action ID of a managed action with <code>DescribeEnvironmentManagedActions</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ApplyEnvironmentManagedAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::apply_environment_managed_action_input::Builder,
    }
    impl ApplyEnvironmentManagedAction {
        /// Creates a new `ApplyEnvironmentManagedAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplyEnvironmentManagedActionOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplyEnvironmentManagedActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the target environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the target environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The action ID of the scheduled managed action to execute.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_id(input.into());
            self
        }
        /// <p>The action ID of the scheduled managed action to execute.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateEnvironmentOperationsRole`.
    ///
    /// <p>Add or change the operations role used by an environment. After this call is made, Elastic Beanstalk uses the associated operations role for permissions to downstream services during subsequent calls acting on this environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateEnvironmentOperationsRole {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_environment_operations_role_input::Builder,
    }
    impl AssociateEnvironmentOperationsRole {
        /// Creates a new `AssociateEnvironmentOperationsRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateEnvironmentOperationsRoleOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateEnvironmentOperationsRoleError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment to which to set the operations role.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the environment to which to set the operations role.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role.</p>
        pub fn operations_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operations_role(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role.</p>
        pub fn set_operations_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_operations_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckDNSAvailability`.
    ///
    /// <p>Checks if the specified CNAME is available.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CheckDNSAvailability {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::check_dns_availability_input::Builder,
    }
    impl CheckDNSAvailability {
        /// Creates a new `CheckDNSAvailability`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckDnsAvailabilityOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckDNSAvailabilityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The prefix used when this CNAME is reserved.</p>
        pub fn cname_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cname_prefix(input.into());
            self
        }
        /// <p>The prefix used when this CNAME is reserved.</p>
        pub fn set_cname_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cname_prefix(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ComposeEnvironments`.
    ///
    /// <p>Create or update a group of environments that each run a separate component of a single application. Takes a list of version labels that specify application source bundles for each of the environments to create or update. The name of each environment and other required information must be included in the source bundles in an environment manifest named <code>env.yaml</code>. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html">Compose Environments</a> for details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ComposeEnvironments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::compose_environments_input::Builder,
    }
    impl ComposeEnvironments {
        /// Creates a new `ComposeEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ComposeEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ComposeEnvironmentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application to which the specified source bundles belong.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application to which the specified source bundles belong.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the group to which the target environments belong. Specify a group name only if the environment name defined in each target environment's manifest ends with a + (plus) character. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group to which the target environments belong. Specify a group name only if the environment name defined in each target environment's manifest ends with a + (plus) character. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// Appends an item to `VersionLabels`.
        ///
        /// To override the contents of this collection use [`set_version_labels`](Self::set_version_labels).
        ///
        /// <p>A list of version labels, specifying one or more application source bundles that belong to the target application. Each source bundle must include an environment manifest that specifies the name of the environment and the name of the solution stack to use, and optionally can specify environment links to create.</p>
        pub fn version_labels(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_labels(input.into());
            self
        }
        /// <p>A list of version labels, specifying one or more application source bundles that belong to the target application. Each source bundle must include an environment manifest that specifies the name of the environment and the name of the solution stack to use, and optionally can specify environment links to create.</p>
        pub fn set_version_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_version_labels(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Creates an application that has one configuration template named <code>default</code> and no application versions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_application_input::Builder,
    }
    impl CreateApplication {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application. Must be unique within your account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application. Must be unique within your account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>Your description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Your description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions.</p>
        pub fn resource_lifecycle_config(
            mut self,
            input: crate::model::ApplicationResourceLifecycleConfig,
        ) -> Self {
            self.inner = self.inner.resource_lifecycle_config(input);
            self
        }
        /// <p>Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions.</p>
        pub fn set_resource_lifecycle_config(
            mut self,
            input: std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_lifecycle_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the application.</p>
        /// <p>Elastic Beanstalk applies these tags only to the application. Environments that you create in the application don't inherit the tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Specifies the tags applied to the application.</p>
        /// <p>Elastic Beanstalk applies these tags only to the application. Environments that you create in the application don't inherit the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApplicationVersion`.
    ///
    /// <p>Creates an application version for the specified application. You can create an application version from a source bundle in Amazon S3, a commit in AWS CodeCommit, or the output of an AWS CodeBuild build as follows:</p>
    /// <p>Specify a commit in an AWS CodeCommit repository with <code>SourceBuildInformation</code>.</p>
    /// <p>Specify a build in an AWS CodeBuild with <code>SourceBuildInformation</code> and <code>BuildConfiguration</code>.</p>
    /// <p>Specify a source bundle in S3 with <code>SourceBundle</code> </p>
    /// <p>Omit both <code>SourceBuildInformation</code> and <code>SourceBundle</code> to use the default sample application.</p> <note>
    /// <p>After you create an application version with a specified Amazon S3 bucket and key location, you can't change that Amazon S3 location. If you change the Amazon S3 location, you receive an exception when you attempt to launch an environment from the application version.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApplicationVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_application_version_input::Builder,
    }
    impl CreateApplicationVersion {
        /// Creates a new `CreateApplicationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the application. If no application is found with this name, and <code>AutoCreateApplication</code> is <code>false</code>, returns an <code>InvalidParameterValue</code> error. </p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p> The name of the application. If no application is found with this name, and <code>AutoCreateApplication</code> is <code>false</code>, returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>A label identifying this version.</p>
        /// <p>Constraint: Must be unique per application. If an application version already exists with this label for the specified application, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(input.into());
            self
        }
        /// <p>A label identifying this version.</p>
        /// <p>Constraint: Must be unique per application. If an application version already exists with this label for the specified application, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// <p>A description of this application version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of this application version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application version.</p>
        pub fn source_build_information(
            mut self,
            input: crate::model::SourceBuildInformation,
        ) -> Self {
            self.inner = self.inner.source_build_information(input);
            self
        }
        /// <p>Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application version.</p>
        pub fn set_source_build_information(
            mut self,
            input: std::option::Option<crate::model::SourceBuildInformation>,
        ) -> Self {
            self.inner = self.inner.set_source_build_information(input);
            self
        }
        /// <p>The Amazon S3 bucket and key that identify the location of the source bundle for this version.</p> <note>
        /// <p>The Amazon S3 bucket must be in the same region as the environment.</p>
        /// </note>
        /// <p>Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample application.</p>
        pub fn source_bundle(mut self, input: crate::model::S3Location) -> Self {
            self.inner = self.inner.source_bundle(input);
            self
        }
        /// <p>The Amazon S3 bucket and key that identify the location of the source bundle for this version.</p> <note>
        /// <p>The Amazon S3 bucket must be in the same region as the environment.</p>
        /// </note>
        /// <p>Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample application.</p>
        pub fn set_source_bundle(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.inner = self.inner.set_source_bundle(input);
            self
        }
        /// <p>Settings for an AWS CodeBuild build.</p>
        pub fn build_configuration(mut self, input: crate::model::BuildConfiguration) -> Self {
            self.inner = self.inner.build_configuration(input);
            self
        }
        /// <p>Settings for an AWS CodeBuild build.</p>
        pub fn set_build_configuration(
            mut self,
            input: std::option::Option<crate::model::BuildConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_build_configuration(input);
            self
        }
        /// <p>Set to <code>true</code> to create an application with the specified name if it doesn't already exist.</p>
        pub fn auto_create_application(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_create_application(input);
            self
        }
        /// <p>Set to <code>true</code> to create an application with the specified name if it doesn't already exist.</p>
        pub fn set_auto_create_application(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_create_application(input);
            self
        }
        /// <p>Pre-processes and validates the environment manifest (<code>env.yaml</code>) and configuration files (<code>*.config</code> files in the <code>.ebextensions</code> folder) in the source bundle. Validating configuration files can identify issues prior to deploying the application version to an environment.</p>
        /// <p>You must turn processing on for application versions that you create using AWS CodeBuild or AWS CodeCommit. For application versions built from a source bundle in Amazon S3, processing is optional.</p> <note>
        /// <p>The <code>Process</code> option validates Elastic Beanstalk configuration files. It doesn't validate your application's configuration files, like proxy server or Docker configuration.</p>
        /// </note>
        pub fn process(mut self, input: bool) -> Self {
            self.inner = self.inner.process(input);
            self
        }
        /// <p>Pre-processes and validates the environment manifest (<code>env.yaml</code>) and configuration files (<code>*.config</code> files in the <code>.ebextensions</code> folder) in the source bundle. Validating configuration files can identify issues prior to deploying the application version to an environment.</p>
        /// <p>You must turn processing on for application versions that you create using AWS CodeBuild or AWS CodeCommit. For application versions built from a source bundle in Amazon S3, processing is optional.</p> <note>
        /// <p>The <code>Process</code> option validates Elastic Beanstalk configuration files. It doesn't validate your application's configuration files, like proxy server or Docker configuration.</p>
        /// </note>
        pub fn set_process(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_process(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the application version.</p>
        /// <p>Elastic Beanstalk applies these tags only to the application version. Environments that use the application version don't inherit the tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Specifies the tags applied to the application version.</p>
        /// <p>Elastic Beanstalk applies these tags only to the application version. Environments that use the application version don't inherit the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationTemplate`.
    ///
    /// <p>Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk application. You define application configuration settings in a configuration template. You can then use the configuration template to deploy different versions of the application with the same configuration settings.</p>
    /// <p>Templates aren't associated with any environment. The <code>EnvironmentName</code> response element is always <code>null</code>.</p>
    /// <p>Related Topics</p>
    /// <ul>
    /// <li> <p> <code>DescribeConfigurationOptions</code> </p> </li>
    /// <li> <p> <code>DescribeConfigurationSettings</code> </p> </li>
    /// <li> <p> <code>ListAvailableSolutionStacks</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfigurationTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_configuration_template_input::Builder,
    }
    impl CreateConfigurationTemplate {
        /// Creates a new `CreateConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigurationTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Elastic Beanstalk application to associate with this configuration template.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the Elastic Beanstalk application to associate with this configuration template.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the configuration template.</p>
        /// <p>Constraint: This name must be unique per application.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the configuration template.</p>
        /// <p>Constraint: This name must be unique per application.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses. For example, <code>64bit Amazon Linux 2013.09 running Tomcat 7 Java 7</code>. A solution stack specifies the operating system, runtime, and application server for a configuration template. It also determines the set of configuration options as well as the possible and default values. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Supported Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        /// <p>You must specify <code>SolutionStackName</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SourceConfiguration</code>.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html"> <code>ListAvailableSolutionStacks</code> </a> API to obtain a list of available solution stacks.</p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_stack_name(input.into());
            self
        }
        /// <p>The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses. For example, <code>64bit Amazon Linux 2013.09 running Tomcat 7 Java 7</code>. A solution stack specifies the operating system, runtime, and application server for a configuration template. It also determines the set of configuration options as well as the possible and default values. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Supported Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        /// <p>You must specify <code>SolutionStackName</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SourceConfiguration</code>.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html"> <code>ListAvailableSolutionStacks</code> </a> API to obtain a list of available solution stacks.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_stack_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom platform. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html"> Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
        /// <p>If you specify <code>PlatformArn</code>, then don't specify <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom platform. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html"> Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
        /// <p>If you specify <code>PlatformArn</code>, then don't specify <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
        /// <p>An Elastic Beanstalk configuration template to base this one on. If specified, Elastic Beanstalk uses the configuration values from the specified configuration template to create a new configuration.</p>
        /// <p>Values specified in <code>OptionSettings</code> override any values obtained from the <code>SourceConfiguration</code>.</p>
        /// <p>You must specify <code>SourceConfiguration</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SolutionStackName</code>.</p>
        /// <p>Constraint: If both solution stack name and source configuration are specified, the solution stack of the source configuration template must match the specified solution stack name.</p>
        pub fn source_configuration(mut self, input: crate::model::SourceConfiguration) -> Self {
            self.inner = self.inner.source_configuration(input);
            self
        }
        /// <p>An Elastic Beanstalk configuration template to base this one on. If specified, Elastic Beanstalk uses the configuration values from the specified configuration template to create a new configuration.</p>
        /// <p>Values specified in <code>OptionSettings</code> override any values obtained from the <code>SourceConfiguration</code>.</p>
        /// <p>You must specify <code>SourceConfiguration</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SolutionStackName</code>.</p>
        /// <p>Constraint: If both solution stack name and source configuration are specified, the solution stack of the source configuration template must match the specified solution stack name.</p>
        pub fn set_source_configuration(
            mut self,
            input: std::option::Option<crate::model::SourceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_source_configuration(input);
            self
        }
        /// <p>The ID of an environment whose settings you want to use to create the configuration template. You must specify <code>EnvironmentId</code> if you don't specify <code>PlatformArn</code>, <code>SolutionStackName</code>, or <code>SourceConfiguration</code>.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of an environment whose settings you want to use to create the configuration template. You must specify <code>EnvironmentId</code> if you don't specify <code>PlatformArn</code>, <code>SolutionStackName</code>, or <code>SourceConfiguration</code>.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>An optional description for this configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description for this configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `OptionSettings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>Option values for the Elastic Beanstalk configuration, such as the instance type. If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html">Option Values</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            self.inner = self.inner.option_settings(input);
            self
        }
        /// <p>Option values for the Elastic Beanstalk configuration, such as the instance type. If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html">Option Values</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.inner = self.inner.set_option_settings(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the configuration template.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Specifies the tags applied to the configuration template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEnvironment`.
    ///
    /// <p>Launches an AWS Elastic Beanstalk environment for the specified application using the specified configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_environment_input::Builder,
    }
    impl CreateEnvironment {
        /// Creates a new `CreateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application that is associated with this environment.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application that is associated with this environment.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>A unique name for the environment.</p>
        /// <p>Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and hyphens. It can't start or end with a hyphen. This name must be unique within a region in your account. If the specified name already exists in the region, Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>If you don't specify the <code>CNAMEPrefix</code> parameter, the environment name becomes part of the CNAME, and therefore part of the visible URL for your application.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>A unique name for the environment.</p>
        /// <p>Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and hyphens. It can't start or end with a hyphen. This name must be unique within a region in your account. If the specified name already exists in the region, Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>If you don't specify the <code>CNAMEPrefix</code> parameter, the environment name becomes part of the CNAME, and therefore part of the visible URL for your application.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name parameter. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name parameter. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>Your description for this environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Your description for this environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>If specified, the environment attempts to use this value as the prefix for the CNAME in your Elastic Beanstalk environment URL. If not specified, the CNAME is generated automatically by appending a random alphanumeric string to the environment name.</p>
        pub fn cname_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cname_prefix(input.into());
            self
        }
        /// <p>If specified, the environment attempts to use this value as the prefix for the CNAME in your Elastic Beanstalk environment URL. If not specified, the CNAME is generated automatically by appending a random alphanumeric string to the environment name.</p>
        pub fn set_cname_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cname_prefix(input);
            self
        }
        /// <p>Specifies the tier to use in creating this environment. The environment tier that you choose determines whether Elastic Beanstalk provisions resources to support a web application that handles HTTP(S) requests or a web application that handles background-processing tasks.</p>
        pub fn tier(mut self, input: crate::model::EnvironmentTier) -> Self {
            self.inner = self.inner.tier(input);
            self
        }
        /// <p>Specifies the tier to use in creating this environment. The environment tier that you choose determines whether Elastic Beanstalk provisions resources to support a web application that handles HTTP(S) requests or a web application that handles background-processing tasks.</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTier>,
        ) -> Self {
            self.inner = self.inner.set_tier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to resources in the environment.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Specifies the tags applied to resources in the environment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the application version to deploy.</p>
        /// <p>Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(input.into());
            self
        }
        /// <p>The name of the application version to deploy.</p>
        /// <p>Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// <p>The name of the Elastic Beanstalk configuration template to use with the environment.</p> <note>
        /// <p>If you specify <code>TemplateName</code>, then don't specify <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the Elastic Beanstalk configuration template to use with the environment.</p> <note>
        /// <p>If you specify <code>TemplateName</code>, then don't specify <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If specified, Elastic Beanstalk sets the configuration values to the default values associated with the specified solution stack. For a list of current solution stacks, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic Beanstalk Supported Platforms</a> in the <i>AWS Elastic Beanstalk Platforms</i> guide.</p> <note>
        /// <p>If you specify <code>SolutionStackName</code>, don't specify <code>PlatformArn</code> or <code>TemplateName</code>.</p>
        /// </note>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_stack_name(input.into());
            self
        }
        /// <p>The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If specified, Elastic Beanstalk sets the configuration values to the default values associated with the specified solution stack. For a list of current solution stacks, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic Beanstalk Supported Platforms</a> in the <i>AWS Elastic Beanstalk Platforms</i> guide.</p> <note>
        /// <p>If you specify <code>SolutionStackName</code>, don't specify <code>PlatformArn</code> or <code>TemplateName</code>.</p>
        /// </note>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_stack_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom platform to use with the environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
        /// <p>If you specify <code>PlatformArn</code>, don't specify <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom platform to use with the environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
        /// <p>If you specify <code>PlatformArn</code>, don't specify <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
        /// Appends an item to `OptionSettings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the configuration set for the new environment. These override the values obtained from the solution stack or the configuration template.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            self.inner = self.inner.option_settings(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the configuration set for the new environment. These override the values obtained from the solution stack or the configuration template.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.inner = self.inner.set_option_settings(input);
            self
        }
        /// Appends an item to `OptionsToRemove`.
        ///
        /// To override the contents of this collection use [`set_options_to_remove`](Self::set_options_to_remove).
        ///
        /// <p>A list of custom user-defined configuration options to remove from the configuration set for this new environment.</p>
        pub fn options_to_remove(mut self, input: crate::model::OptionSpecification) -> Self {
            self.inner = self.inner.options_to_remove(input);
            self
        }
        /// <p>A list of custom user-defined configuration options to remove from the configuration set for this new environment.</p>
        pub fn set_options_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_options_to_remove(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role. If specified, Elastic Beanstalk uses the operations role for permissions to downstream services during this call and during subsequent calls acting on this environment. To specify an operations role, you must have the <code>iam:PassRole</code> permission for the role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn operations_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operations_role(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role. If specified, Elastic Beanstalk uses the operations role for permissions to downstream services during this call and during subsequent calls acting on this environment. To specify an operations role, you must have the <code>iam:PassRole</code> permission for the role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn set_operations_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_operations_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePlatformVersion`.
    ///
    /// <p>Create a new version of your custom platform.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePlatformVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_platform_version_input::Builder,
    }
    impl CreatePlatformVersion {
        /// Creates a new `CreatePlatformVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePlatformVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePlatformVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your custom platform.</p>
        pub fn platform_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_name(input.into());
            self
        }
        /// <p>The name of your custom platform.</p>
        pub fn set_platform_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_platform_name(input);
            self
        }
        /// <p>The number, such as 1.0.2, for the new platform version.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_version(input.into());
            self
        }
        /// <p>The number, such as 1.0.2, for the new platform version.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_platform_version(input);
            self
        }
        /// <p>The location of the platform definition archive in Amazon S3.</p>
        pub fn platform_definition_bundle(mut self, input: crate::model::S3Location) -> Self {
            self.inner = self.inner.platform_definition_bundle(input);
            self
        }
        /// <p>The location of the platform definition archive in Amazon S3.</p>
        pub fn set_platform_definition_bundle(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.inner = self.inner.set_platform_definition_bundle(input);
            self
        }
        /// <p>The name of the builder environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the builder environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// Appends an item to `OptionSettings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>The configuration option settings to apply to the builder environment.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            self.inner = self.inner.option_settings(input);
            self
        }
        /// <p>The configuration option settings to apply to the builder environment.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.inner = self.inner.set_option_settings(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the new platform version.</p>
        /// <p>Elastic Beanstalk applies these tags only to the platform version. Environments that you create using the platform version don't inherit the tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Specifies the tags applied to the new platform version.</p>
        /// <p>Elastic Beanstalk applies these tags only to the platform version. Environments that you create using the platform version don't inherit the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStorageLocation`.
    ///
    /// <p>Creates a bucket in Amazon S3 to store application versions, logs, and other files used by Elastic Beanstalk environments. The Elastic Beanstalk console and EB CLI call this API the first time you create an environment in a region. If the storage location already exists, <code>CreateStorageLocation</code> still returns the bucket name but does not create a new bucket.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStorageLocation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_storage_location_input::Builder,
    }
    impl CreateStorageLocation {
        /// Creates a new `CreateStorageLocation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStorageLocationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStorageLocationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteApplication`.
    ///
    /// <p>Deletes the specified application along with all associated versions and configurations. The application versions will not be deleted from your Amazon S3 bucket.</p> <note>
    /// <p>You cannot delete an application that has a running environment.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_application_input::Builder,
    }
    impl DeleteApplication {
        /// Creates a new `DeleteApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application to delete.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application to delete.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>When set to true, running environments will be terminated before deleting the application.</p>
        pub fn terminate_env_by_force(mut self, input: bool) -> Self {
            self.inner = self.inner.terminate_env_by_force(input);
            self
        }
        /// <p>When set to true, running environments will be terminated before deleting the application.</p>
        pub fn set_terminate_env_by_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_terminate_env_by_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplicationVersion`.
    ///
    /// <p>Deletes the specified version from the specified application.</p> <note>
    /// <p>You cannot delete an application version that is associated with a running environment.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplicationVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_application_version_input::Builder,
    }
    impl DeleteApplicationVersion {
        /// Creates a new `DeleteApplicationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application to which the version belongs.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application to which the version belongs.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The label of the version to delete.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(input.into());
            self
        }
        /// <p>The label of the version to delete.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// <p>Set to <code>true</code> to delete the source bundle from your storage bucket. Otherwise, the application version is deleted only from Elastic Beanstalk and the source bundle remains in Amazon S3.</p>
        pub fn delete_source_bundle(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_source_bundle(input);
            self
        }
        /// <p>Set to <code>true</code> to delete the source bundle from your storage bucket. Otherwise, the application version is deleted only from Elastic Beanstalk and the source bundle remains in Amazon S3.</p>
        pub fn set_delete_source_bundle(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_source_bundle(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationTemplate`.
    ///
    /// <p>Deletes the specified configuration template.</p> <note>
    /// <p>When you launch an environment using a configuration template, the environment gets a copy of the template. You can delete or modify the environment's copy of the template without affecting the running environment.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_configuration_template_input::Builder,
    }
    impl DeleteConfigurationTemplate {
        /// Creates a new `DeleteConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application to delete the configuration template from.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application to delete the configuration template from.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the configuration template to delete.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the configuration template to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEnvironmentConfiguration`.
    ///
    /// <p>Deletes the draft configuration associated with the running environment.</p>
    /// <p>Updating a running environment with any configuration changes creates a draft configuration set. You can get the draft configuration using <code>DescribeConfigurationSettings</code> while the update is in progress or if the update fails. The <code>DeploymentStatus</code> for the draft configuration indicates whether the deployment is in process or has failed. The draft configuration remains in existence until it is deleted with this action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEnvironmentConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_environment_configuration_input::Builder,
    }
    impl DeleteEnvironmentConfiguration {
        /// Creates a new `DeleteEnvironmentConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEnvironmentConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEnvironmentConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application the environment is associated with.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application the environment is associated with.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the environment to delete the draft configuration from.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the environment to delete the draft configuration from.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePlatformVersion`.
    ///
    /// <p>Deletes the specified version of a custom platform.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePlatformVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_platform_version_input::Builder,
    }
    impl DeletePlatformVersion {
        /// Creates a new `DeletePlatformVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePlatformVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePlatformVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the version of the custom platform.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(input.into());
            self
        }
        /// <p>The ARN of the version of the custom platform.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAttributes`.
    ///
    /// <p>Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS account.</p>
    /// <p>The result currently has one set of attributes—resource quotas.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_attributes_input::Builder,
    }
    impl DescribeAccountAttributes {
        /// Creates a new `DescribeAccountAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeApplications`.
    ///
    /// <p>Returns the descriptions of existing applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApplications {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_applications_input::Builder,
    }
    impl DescribeApplications {
        /// Creates a new `DescribeApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeApplicationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ApplicationNames`.
        ///
        /// To override the contents of this collection use [`set_application_names`](Self::set_application_names).
        ///
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include those with the specified names.</p>
        pub fn application_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_names(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include those with the specified names.</p>
        pub fn set_application_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_application_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApplicationVersions`.
    ///
    /// <p>Retrieve a list of application versions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApplicationVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_application_versions_input::Builder,
    }
    impl DescribeApplicationVersions {
        /// Creates a new `DescribeApplicationVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicationVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeApplicationVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify an application name to show only application versions for that application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>Specify an application name to show only application versions for that application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// Appends an item to `VersionLabels`.
        ///
        /// To override the contents of this collection use [`set_version_labels`](Self::set_version_labels).
        ///
        /// <p>Specify a version label to show a specific application version.</p>
        pub fn version_labels(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_labels(input.into());
            self
        }
        /// <p>Specify a version label to show a specific application version.</p>
        pub fn set_version_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_version_labels(input);
            self
        }
        /// <p>For a paginated request. Specify a maximum number of application versions to include in each response.</p>
        /// <p>If no <code>MaxRecords</code> is specified, all available application versions are retrieved in a single response.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>For a paginated request. Specify a maximum number of application versions to include in each response.</p>
        /// <p>If no <code>MaxRecords</code> is specified, all available application versions are retrieved in a single response.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurationOptions`.
    ///
    /// <p>Describes the configuration options that are used in a particular configuration template or environment, or that a specified solution stack defines. The description includes the values the options, their default values, and an indication of the required action on a running environment if an option value is changed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConfigurationOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_configuration_options_input::Builder,
    }
    impl DescribeConfigurationOptions {
        /// Creates a new `DescribeConfigurationOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application associated with the configuration template or environment. Only needed if you want to describe the configuration options associated with either the configuration template or environment.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application associated with the configuration template or environment. Only needed if you want to describe the configuration options associated with either the configuration template or environment.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the configuration template whose configuration options you want to describe.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the configuration template whose configuration options you want to describe.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The name of the environment whose configuration options you want to describe.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the environment whose configuration options you want to describe.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The name of the solution stack whose configuration options you want to describe.</p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_stack_name(input.into());
            self
        }
        /// <p>The name of the solution stack whose configuration options you want to describe.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_stack_name(input);
            self
        }
        /// <p>The ARN of the custom platform.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(input.into());
            self
        }
        /// <p>The ARN of the custom platform.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
        /// Appends an item to `Options`.
        ///
        /// To override the contents of this collection use [`set_options`](Self::set_options).
        ///
        /// <p>If specified, restricts the descriptions to only the specified options.</p>
        pub fn options(mut self, input: crate::model::OptionSpecification) -> Self {
            self.inner = self.inner.options(input);
            self
        }
        /// <p>If specified, restricts the descriptions to only the specified options.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurationSettings`.
    ///
    /// <p>Returns a description of the settings for the specified configuration set, that is, either a configuration template or the configuration set associated with a running environment.</p>
    /// <p>When describing the settings for the configuration set associated with a running environment, it is possible to receive two sets of setting descriptions. One is the deployed configuration set, and the other is a draft configuration of an environment that is either in the process of deployment or that failed to deploy.</p>
    /// <p>Related Topics</p>
    /// <ul>
    /// <li> <p> <code>DeleteEnvironmentConfiguration</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConfigurationSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_configuration_settings_input::Builder,
    }
    impl DescribeConfigurationSettings {
        /// Creates a new `DescribeConfigurationSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application for the environment or configuration template.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The application for the environment or configuration template.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the configuration template to describe.</p>
        /// <p> Conditional: You must specify either this parameter or an EnvironmentName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns a <code>MissingRequiredParameter</code> error. </p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the configuration template to describe.</p>
        /// <p> Conditional: You must specify either this parameter or an EnvironmentName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns a <code>MissingRequiredParameter</code> error. </p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The name of the environment to describe.</p>
        /// <p> Condition: You must specify either this or a TemplateName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the environment to describe.</p>
        /// <p> Condition: You must specify either this or a TemplateName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironmentHealth`.
    ///
    /// <p>Returns information about the overall health of the specified environment. The <b>DescribeEnvironmentHealth</b> operation is only available with AWS Elastic Beanstalk Enhanced Health.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEnvironmentHealth {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_environment_health_input::Builder,
    }
    impl DescribeEnvironmentHealth {
        /// Creates a new `DescribeEnvironmentHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentHealthOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentHealthError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the environment by name.</p>
        /// <p>You must specify either this or an EnvironmentName, or both.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>Specify the environment by name.</p>
        /// <p>You must specify either this or an EnvironmentName, or both.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>Specify the environment by ID.</p>
        /// <p>You must specify either this or an EnvironmentName, or both.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>Specify the environment by ID.</p>
        /// <p>You must specify either this or an EnvironmentName, or both.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// Appends an item to `AttributeNames`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns the name of the environment.</p>
        pub fn attribute_names(mut self, input: crate::model::EnvironmentHealthAttribute) -> Self {
            self.inner = self.inner.attribute_names(input);
            self
        }
        /// <p>Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns the name of the environment.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentHealthAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironmentManagedActionHistory`.
    ///
    /// <p>Lists an environment's completed and failed managed actions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEnvironmentManagedActionHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_environment_managed_action_history_input::Builder,
    }
    impl DescribeEnvironmentManagedActionHistory {
        /// Creates a new `DescribeEnvironmentManagedActionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentManagedActionHistoryOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeEnvironmentManagedActionHistoryError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEnvironmentManagedActionHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeEnvironmentManagedActionHistoryPaginator {
            crate::paginator::DescribeEnvironmentManagedActionHistoryPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the target environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the target environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The pagination token returned by a previous request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token returned by a previous request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for a single request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of items to return for a single request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironmentManagedActions`.
    ///
    /// <p>Lists an environment's upcoming and in-progress managed actions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEnvironmentManagedActions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_environment_managed_actions_input::Builder,
    }
    impl DescribeEnvironmentManagedActions {
        /// Creates a new `DescribeEnvironmentManagedActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentManagedActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentManagedActionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the target environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the target environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>To show only actions with a particular status, specify a status.</p>
        pub fn status(mut self, input: crate::model::ActionStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>To show only actions with a particular status, specify a status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ActionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironmentResources`.
    ///
    /// <p>Returns AWS resources for this environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEnvironmentResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_environment_resources_input::Builder,
    }
    impl DescribeEnvironmentResources {
        /// Creates a new `DescribeEnvironmentResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to retrieve AWS resource usage data.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment to retrieve AWS resource usage data.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the environment to retrieve AWS resource usage data.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the environment to retrieve AWS resource usage data.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironments`.
    ///
    /// <p>Returns descriptions for existing environments.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEnvironments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_environments_input::Builder,
    }
    impl DescribeEnvironments {
        /// Creates a new `DescribeEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application version.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application version.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// Appends an item to `EnvironmentIds`.
        ///
        /// To override the contents of this collection use [`set_environment_ids`](Self::set_environment_ids).
        ///
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified IDs.</p>
        pub fn environment_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_ids(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified IDs.</p>
        pub fn set_environment_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_environment_ids(input);
            self
        }
        /// Appends an item to `EnvironmentNames`.
        ///
        /// To override the contents of this collection use [`set_environment_names`](Self::set_environment_names).
        ///
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified names.</p>
        pub fn environment_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_names(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified names.</p>
        pub fn set_environment_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_environment_names(input);
            self
        }
        /// <p>Indicates whether to include deleted environments:</p>
        /// <p> <code>true</code>: Environments that have been deleted after <code>IncludedDeletedBackTo</code> are displayed.</p>
        /// <p> <code>false</code>: Do not include deleted environments.</p>
        pub fn include_deleted(mut self, input: bool) -> Self {
            self.inner = self.inner.include_deleted(input);
            self
        }
        /// <p>Indicates whether to include deleted environments:</p>
        /// <p> <code>true</code>: Environments that have been deleted after <code>IncludedDeletedBackTo</code> are displayed.</p>
        /// <p> <code>false</code>: Do not include deleted environments.</p>
        pub fn set_include_deleted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_deleted(input);
            self
        }
        /// <p> If specified when <code>IncludeDeleted</code> is set to <code>true</code>, then environments deleted after this date are displayed. </p>
        pub fn included_deleted_back_to(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.included_deleted_back_to(input);
            self
        }
        /// <p> If specified when <code>IncludeDeleted</code> is set to <code>true</code>, then environments deleted after this date are displayed. </p>
        pub fn set_included_deleted_back_to(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_included_deleted_back_to(input);
            self
        }
        /// <p>For a paginated request. Specify a maximum number of environments to include in each response.</p>
        /// <p>If no <code>MaxRecords</code> is specified, all available environments are retrieved in a single response.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>For a paginated request. Specify a maximum number of environments to include in each response.</p>
        /// <p>If no <code>MaxRecords</code> is specified, all available environments are retrieved in a single response.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p>Returns list of event descriptions matching criteria up to the last 6 weeks.</p> <note>
    /// <p>This action returns the most recent 1,000 events from the specified <code>NextToken</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl DescribeEvents {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEventsPaginator {
            crate::paginator::DescribeEventsPaginator::new(self.handle, self.inner)
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those associated with this application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those associated with this application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this application version.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this application version.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that are associated with this environment configuration.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that are associated with this environment configuration.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this custom platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(input.into());
            self
        }
        /// <p>The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this custom platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the described events to include only those associated with this request ID.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_id(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the described events to include only those associated with this request ID.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_request_id(input);
            self
        }
        /// <p>If specified, limits the events returned from this call to include only those with the specified severity or higher.</p>
        pub fn severity(mut self, input: crate::model::EventSeverity) -> Self {
            self.inner = self.inner.severity(input);
            self
        }
        /// <p>If specified, limits the events returned from this call to include only those with the specified severity or higher.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::EventSeverity>,
        ) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur on or after this time.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur on or after this time.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p> If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur up to, but not including, the <code>EndTime</code>. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p> If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur up to, but not including, the <code>EndTime</code>. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>Specifies the maximum number of events that can be returned, beginning with the most recent event.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>Specifies the maximum number of events that can be returned, beginning with the most recent event.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>Pagination token. If specified, the events return the next batch of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token. If specified, the events return the next batch of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstancesHealth`.
    ///
    /// <p>Retrieves detailed information about the health of instances in your AWS Elastic Beanstalk. This operation requires <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html">enhanced health reporting</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInstancesHealth {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_instances_health_input::Builder,
    }
    impl DescribeInstancesHealth {
        /// Creates a new `DescribeInstancesHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstancesHealthOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstancesHealthError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the AWS Elastic Beanstalk environment by name.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>Specify the AWS Elastic Beanstalk environment by name.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>Specify the AWS Elastic Beanstalk environment by ID.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>Specify the AWS Elastic Beanstalk environment by ID.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// Appends an item to `AttributeNames`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns a list of instances.</p>
        pub fn attribute_names(mut self, input: crate::model::InstancesHealthAttribute) -> Self {
            self.inner = self.inner.attribute_names(input);
            self
        }
        /// <p>Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns a list of instances.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstancesHealthAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_names(input);
            self
        }
        /// <p>Specify the pagination token returned by a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specify the pagination token returned by a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePlatformVersion`.
    ///
    /// <p>Describes a platform version. Provides full details. Compare to <code>ListPlatformVersions</code>, which provides summary information about a list of platform versions.</p>
    /// <p>For definitions of platform version and other platform-related terms, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk Platforms Glossary</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePlatformVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_platform_version_input::Builder,
    }
    impl DescribePlatformVersion {
        /// Creates a new `DescribePlatformVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePlatformVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePlatformVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(input.into());
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateEnvironmentOperationsRole`.
    ///
    /// <p>Disassociate the operations role from an environment. After this call is made, Elastic Beanstalk uses the caller's permissions for permissions to downstream services during subsequent calls acting on this environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateEnvironmentOperationsRole {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_environment_operations_role_input::Builder,
    }
    impl DisassociateEnvironmentOperationsRole {
        /// Creates a new `DisassociateEnvironmentOperationsRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateEnvironmentOperationsRoleOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateEnvironmentOperationsRoleError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment from which to disassociate the operations role.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the environment from which to disassociate the operations role.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAvailableSolutionStacks`.
    ///
    /// <p>Returns a list of the available solution stack names, with the public version first and then in reverse chronological order.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAvailableSolutionStacks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_available_solution_stacks_input::Builder,
    }
    impl ListAvailableSolutionStacks {
        /// Creates a new `ListAvailableSolutionStacks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAvailableSolutionStacksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAvailableSolutionStacksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListPlatformBranches`.
    ///
    /// <p>Lists the platform branches available for your account in an AWS Region. Provides summary information about each platform branch.</p>
    /// <p>For definitions of platform branch and other platform-related terms, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk Platforms Glossary</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPlatformBranches {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_platform_branches_input::Builder,
    }
    impl ListPlatformBranches {
        /// Creates a new `ListPlatformBranches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPlatformBranchesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPlatformBranchesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPlatformBranchesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPlatformBranchesPaginator {
            crate::paginator::ListPlatformBranchesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical conjunction (AND) of the separate <code>SearchFilter</code> terms.</p>
        /// <p>The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most operators take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple values.</p>
        /// <ul>
        /// <li> <p> <code>Attribute = BranchName</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Attribute = LifecycleState</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code> </p> </li>
        /// <li> <p> <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> | <code>retired</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Attribute = PlatformName</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Attribute = TierType</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> </p> </li>
        /// <li> <p> <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p>Array size: limited to 10 <code>SearchFilter</code> objects.</p>
        /// <p>Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.</p>
        pub fn filters(mut self, input: crate::model::SearchFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical conjunction (AND) of the separate <code>SearchFilter</code> terms.</p>
        /// <p>The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most operators take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple values.</p>
        /// <ul>
        /// <li> <p> <code>Attribute = BranchName</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Attribute = LifecycleState</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code> </p> </li>
        /// <li> <p> <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> | <code>retired</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Attribute = PlatformName</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Attribute = TierType</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> </p> </li>
        /// <li> <p> <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p>Array size: limited to 10 <code>SearchFilter</code> objects.</p>
        /// <p>Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SearchFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of platform branch values returned in one call.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of platform branch values returned in one call.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPlatformVersions`.
    ///
    /// <p>Lists the platform versions available for your account in an AWS Region. Provides summary information about each platform version. Compare to <code>DescribePlatformVersion</code>, which provides full details about a single platform version.</p>
    /// <p>For definitions of platform version and other platform-related terms, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk Platforms Glossary</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPlatformVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_platform_versions_input::Builder,
    }
    impl ListPlatformVersions {
        /// Creates a new `ListPlatformVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPlatformVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPlatformVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPlatformVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPlatformVersionsPaginator {
            crate::paginator::ListPlatformVersionsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Criteria for restricting the resulting list of platform versions. The filter is interpreted as a logical conjunction (AND) of the separate <code>PlatformFilter</code> terms.</p>
        pub fn filters(mut self, input: crate::model::PlatformFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Criteria for restricting the resulting list of platform versions. The filter is interpreted as a logical conjunction (AND) of the separate <code>PlatformFilter</code> terms.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of platform version values returned in one call.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of platform version values returned in one call.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Return the tags applied to an AWS Elastic Beanstalk resource. The response contains a list of tag key-value pairs.</p>
    /// <p>Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging Application Resources</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resouce for which a tag list is requested.</p>
        /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resouce for which a tag list is requested.</p>
        /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebuildEnvironment`.
    ///
    /// <p>Deletes and recreates all of the AWS resources (for example: the Auto Scaling group, load balancer, etc.) for a specified environment and forces a restart.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RebuildEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::rebuild_environment_input::Builder,
    }
    impl RebuildEnvironment {
        /// Creates a new `RebuildEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebuildEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::RebuildEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to rebuild.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment to rebuild.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the environment to rebuild.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the environment to rebuild.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RequestEnvironmentInfo`.
    ///
    /// <p>Initiates a request to compile the specified type of information of the deployed environment.</p>
    /// <p> Setting the <code>InfoType</code> to <code>tail</code> compiles the last lines from the application server log files of every Amazon EC2 instance in your environment. </p>
    /// <p> Setting the <code>InfoType</code> to <code>bundle</code> compresses the application server log files for every Amazon EC2 instance into a <code>.zip</code> file. Legacy and .NET containers do not support bundle logs. </p>
    /// <p> Use <code>RetrieveEnvironmentInfo</code> to obtain the set of logs. </p>
    /// <p>Related Topics</p>
    /// <ul>
    /// <li> <p> <code>RetrieveEnvironmentInfo</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RequestEnvironmentInfo {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::request_environment_info_input::Builder,
    }
    impl RequestEnvironmentInfo {
        /// Creates a new `RequestEnvironmentInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RequestEnvironmentInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::RequestEnvironmentInfoError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment of the requested data.</p>
        /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment of the requested data.</p>
        /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the environment of the requested data.</p>
        /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the environment of the requested data.</p>
        /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The type of information to request.</p>
        pub fn info_type(mut self, input: crate::model::EnvironmentInfoType) -> Self {
            self.inner = self.inner.info_type(input);
            self
        }
        /// <p>The type of information to request.</p>
        pub fn set_info_type(
            mut self,
            input: std::option::Option<crate::model::EnvironmentInfoType>,
        ) -> Self {
            self.inner = self.inner.set_info_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestartAppServer`.
    ///
    /// <p>Causes the environment to restart the application container server running on each Amazon EC2 instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestartAppServer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::restart_app_server_input::Builder,
    }
    impl RestartAppServer {
        /// Creates a new `RestartAppServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestartAppServerOutput,
            aws_smithy_http::result::SdkError<crate::error::RestartAppServerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to restart the server for.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment to restart the server for.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the environment to restart the server for.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the environment to restart the server for.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetrieveEnvironmentInfo`.
    ///
    /// <p>Retrieves the compiled information from a <code>RequestEnvironmentInfo</code> request.</p>
    /// <p>Related Topics</p>
    /// <ul>
    /// <li> <p> <code>RequestEnvironmentInfo</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RetrieveEnvironmentInfo {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::retrieve_environment_info_input::Builder,
    }
    impl RetrieveEnvironmentInfo {
        /// Creates a new `RetrieveEnvironmentInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetrieveEnvironmentInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::RetrieveEnvironmentInfoError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the data's environment.</p>
        /// <p>If no such environment is found, returns an <code>InvalidParameterValue</code> error.</p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the data's environment.</p>
        /// <p>If no such environment is found, returns an <code>InvalidParameterValue</code> error.</p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the data's environment.</p>
        /// <p> If no such environment is found, returns an <code>InvalidParameterValue</code> error. </p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the data's environment.</p>
        /// <p> If no such environment is found, returns an <code>InvalidParameterValue</code> error. </p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The type of information to retrieve.</p>
        pub fn info_type(mut self, input: crate::model::EnvironmentInfoType) -> Self {
            self.inner = self.inner.info_type(input);
            self
        }
        /// <p>The type of information to retrieve.</p>
        pub fn set_info_type(
            mut self,
            input: std::option::Option<crate::model::EnvironmentInfoType>,
        ) -> Self {
            self.inner = self.inner.set_info_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SwapEnvironmentCNAMEs`.
    ///
    /// <p>Swaps the CNAMEs of two environments.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SwapEnvironmentCNAMEs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::swap_environment_cnam_es_input::Builder,
    }
    impl SwapEnvironmentCNAMEs {
        /// Creates a new `SwapEnvironmentCNAMEs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SwapEnvironmentCnamEsOutput,
            aws_smithy_http::result::SdkError<crate::error::SwapEnvironmentCNAMEsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the source environment.</p>
        /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentId</code>, you must specify the <code>DestinationEnvironmentId</code>. </p>
        pub fn source_environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_environment_id(input.into());
            self
        }
        /// <p>The ID of the source environment.</p>
        /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentId</code>, you must specify the <code>DestinationEnvironmentId</code>. </p>
        pub fn set_source_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_environment_id(input);
            self
        }
        /// <p>The name of the source environment.</p>
        /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentName</code>, you must specify the <code>DestinationEnvironmentName</code>. </p>
        pub fn source_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_environment_name(input.into());
            self
        }
        /// <p>The name of the source environment.</p>
        /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentName</code>, you must specify the <code>DestinationEnvironmentName</code>. </p>
        pub fn set_source_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_environment_name(input);
            self
        }
        /// <p>The ID of the destination environment.</p>
        /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentId</code> with the <code>DestinationEnvironmentId</code>. </p>
        pub fn destination_environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_environment_id(input.into());
            self
        }
        /// <p>The ID of the destination environment.</p>
        /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentId</code> with the <code>DestinationEnvironmentId</code>. </p>
        pub fn set_destination_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_environment_id(input);
            self
        }
        /// <p>The name of the destination environment.</p>
        /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentName</code> with the <code>DestinationEnvironmentName</code>. </p>
        pub fn destination_environment_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_environment_name(input.into());
            self
        }
        /// <p>The name of the destination environment.</p>
        /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentName</code> with the <code>DestinationEnvironmentName</code>. </p>
        pub fn set_destination_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateEnvironment`.
    ///
    /// <p>Terminates the specified environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TerminateEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::terminate_environment_input::Builder,
    }
    impl TerminateEnvironment {
        /// Creates a new `TerminateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to terminate.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment to terminate.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the environment to terminate.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the environment to terminate.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>Indicates whether the associated AWS resources should shut down when the environment is terminated:</p>
        /// <ul>
        /// <li> <p> <code>true</code>: The specified environment as well as the associated AWS resources, such as Auto Scaling group and LoadBalancer, are terminated.</p> </li>
        /// <li> <p> <code>false</code>: AWS Elastic Beanstalk resource management is removed from the environment, but the AWS resources continue to operate.</p> </li>
        /// </ul>
        /// <p> For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS Elastic Beanstalk User Guide. </a> </p>
        /// <p> Default: <code>true</code> </p>
        /// <p> Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn terminate_resources(mut self, input: bool) -> Self {
            self.inner = self.inner.terminate_resources(input);
            self
        }
        /// <p>Indicates whether the associated AWS resources should shut down when the environment is terminated:</p>
        /// <ul>
        /// <li> <p> <code>true</code>: The specified environment as well as the associated AWS resources, such as Auto Scaling group and LoadBalancer, are terminated.</p> </li>
        /// <li> <p> <code>false</code>: AWS Elastic Beanstalk resource management is removed from the environment, but the AWS resources continue to operate.</p> </li>
        /// </ul>
        /// <p> For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS Elastic Beanstalk User Guide. </a> </p>
        /// <p> Default: <code>true</code> </p>
        /// <p> Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_terminate_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_terminate_resources(input);
            self
        }
        /// <p>Terminates the target environment even if another environment in the same group is dependent on it.</p>
        pub fn force_terminate(mut self, input: bool) -> Self {
            self.inner = self.inner.force_terminate(input);
            self
        }
        /// <p>Terminates the target environment even if another environment in the same group is dependent on it.</p>
        pub fn set_force_terminate(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_terminate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <p>Updates the specified application to have the specified properties.</p> <note>
    /// <p>If a property (for example, <code>description</code>) is not provided, the value remains unchanged. To clear these properties, specify an empty string.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_application_input::Builder,
    }
    impl UpdateApplication {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application to update. If no such application is found, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application to update. If no such application is found, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>A new description for the application.</p>
        /// <p>Default: If not specified, AWS Elastic Beanstalk does not update the description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A new description for the application.</p>
        /// <p>Default: If not specified, AWS Elastic Beanstalk does not update the description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplicationResourceLifecycle`.
    ///
    /// <p>Modifies lifecycle settings for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplicationResourceLifecycle {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_application_resource_lifecycle_input::Builder,
    }
    impl UpdateApplicationResourceLifecycle {
        /// Creates a new `UpdateApplicationResourceLifecycle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationResourceLifecycleOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateApplicationResourceLifecycleError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The lifecycle configuration.</p>
        pub fn resource_lifecycle_config(
            mut self,
            input: crate::model::ApplicationResourceLifecycleConfig,
        ) -> Self {
            self.inner = self.inner.resource_lifecycle_config(input);
            self
        }
        /// <p>The lifecycle configuration.</p>
        pub fn set_resource_lifecycle_config(
            mut self,
            input: std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_lifecycle_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplicationVersion`.
    ///
    /// <p>Updates the specified application version to have the specified properties.</p> <note>
    /// <p>If a property (for example, <code>description</code>) is not provided, the value remains unchanged. To clear properties, specify an empty string.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplicationVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_application_version_input::Builder,
    }
    impl UpdateApplicationVersion {
        /// Creates a new `UpdateApplicationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application associated with this version.</p>
        /// <p> If no application is found with this name, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application associated with this version.</p>
        /// <p> If no application is found with this name, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the version to update.</p>
        /// <p>If no application version is found with this label, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(input.into());
            self
        }
        /// <p>The name of the version to update.</p>
        /// <p>If no application version is found with this label, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// <p>A new description for this version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A new description for this version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationTemplate`.
    ///
    /// <p>Updates the specified configuration template to have the specified properties or configuration option values.</p> <note>
    /// <p>If a property (for example, <code>ApplicationName</code>) is not provided, its value remains unchanged. To clear such properties, specify an empty string.</p>
    /// </note>
    /// <p>Related Topics</p>
    /// <ul>
    /// <li> <p> <code>DescribeConfigurationOptions</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConfigurationTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_configuration_template_input::Builder,
    }
    impl UpdateConfigurationTemplate {
        /// Creates a new `UpdateConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConfigurationTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application associated with the configuration template to update.</p>
        /// <p> If no application is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application associated with the configuration template to update.</p>
        /// <p> If no application is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the configuration template to update.</p>
        /// <p> If no configuration template is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the configuration template to update.</p>
        /// <p> If no configuration template is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>A new description for the configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A new description for the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `OptionSettings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>A list of configuration option settings to update with the new specified option value.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            self.inner = self.inner.option_settings(input);
            self
        }
        /// <p>A list of configuration option settings to update with the new specified option value.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.inner = self.inner.set_option_settings(input);
            self
        }
        /// Appends an item to `OptionsToRemove`.
        ///
        /// To override the contents of this collection use [`set_options_to_remove`](Self::set_options_to_remove).
        ///
        /// <p>A list of configuration options to remove from the configuration set.</p>
        /// <p> Constraint: You can remove only <code>UserDefined</code> configuration options. </p>
        pub fn options_to_remove(mut self, input: crate::model::OptionSpecification) -> Self {
            self.inner = self.inner.options_to_remove(input);
            self
        }
        /// <p>A list of configuration options to remove from the configuration set.</p>
        /// <p> Constraint: You can remove only <code>UserDefined</code> configuration options. </p>
        pub fn set_options_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_options_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEnvironment`.
    ///
    /// <p>Updates the environment description, deploys a new application version, updates the configuration settings to an entirely new configuration template, or updates select configuration option values in the running environment.</p>
    /// <p> Attempting to update both the release and configuration is not allowed and AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. </p>
    /// <p> When updating the configuration settings to a new template or individual settings, a draft configuration is created and <code>DescribeConfigurationSettings</code> for this environment returns two setting descriptions with different <code>DeploymentStatus</code> values. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEnvironment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_environment_input::Builder,
    }
    impl UpdateEnvironment {
        /// Creates a new `UpdateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEnvironmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application with which the environment is associated.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application with which the environment is associated.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The ID of the environment to update.</p>
        /// <p>If no environment with this ID exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.</p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(input.into());
            self
        }
        /// <p>The ID of the environment to update.</p>
        /// <p>If no environment with this ID exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.</p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the environment to update. If no environment with this name exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the environment to update. If no environment with this name exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name or environment ID parameters. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name or environment ID parameters. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk updates the description of this environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk updates the description of this environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>This specifies the tier to use to update the environment.</p>
        /// <p>Condition: At this time, if you change the tier version, name, or type, AWS Elastic Beanstalk returns <code>InvalidParameterValue</code> error. </p>
        pub fn tier(mut self, input: crate::model::EnvironmentTier) -> Self {
            self.inner = self.inner.tier(input);
            self
        }
        /// <p>This specifies the tier to use to update the environment.</p>
        /// <p>Condition: At this time, if you change the tier version, name, or type, AWS Elastic Beanstalk returns <code>InvalidParameterValue</code> error. </p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTier>,
        ) -> Self {
            self.inner = self.inner.set_tier(input);
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys the named application version to the environment. If no such application version is found, returns an <code>InvalidParameterValue</code> error. </p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(input.into());
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys the named application version to the environment. If no such application version is found, returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys this configuration template to the environment. If no such configuration template is found, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys this configuration template to the environment. If no such configuration template is found, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>This specifies the platform version that the environment will run after the environment is updated.</p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_stack_name(input.into());
            self
        }
        /// <p>This specifies the platform version that the environment will run after the environment is updated.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_stack_name(input);
            self
        }
        /// <p>The ARN of the platform, if used.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(input.into());
            self
        }
        /// <p>The ARN of the platform, if used.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
        /// Appends an item to `OptionSettings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>If specified, AWS Elastic Beanstalk updates the configuration set associated with the running environment and sets the specified configuration options to the requested value.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            self.inner = self.inner.option_settings(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk updates the configuration set associated with the running environment and sets the specified configuration options to the requested value.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.inner = self.inner.set_option_settings(input);
            self
        }
        /// Appends an item to `OptionsToRemove`.
        ///
        /// To override the contents of this collection use [`set_options_to_remove`](Self::set_options_to_remove).
        ///
        /// <p>A list of custom user-defined configuration options to remove from the configuration set for this environment.</p>
        pub fn options_to_remove(mut self, input: crate::model::OptionSpecification) -> Self {
            self.inner = self.inner.options_to_remove(input);
            self
        }
        /// <p>A list of custom user-defined configuration options to remove from the configuration set for this environment.</p>
        pub fn set_options_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_options_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTagsForResource`.
    ///
    /// <p>Update the list of tags applied to an AWS Elastic Beanstalk resource. Two lists can be passed: <code>TagsToAdd</code> for tags to add or update, and <code>TagsToRemove</code>.</p>
    /// <p>Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging Application Resources</a>.</p>
    /// <p>If you create a custom IAM user policy to control permission to this operation, specify one of the following two virtual actions (or both) instead of the API operation name:</p>
    /// <dl>
    /// <dt>
    /// elasticbeanstalk:AddTags
    /// </dt>
    /// <dd>
    /// <p>Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tags to add in the <code>TagsToAdd</code> parameter.</p>
    /// </dd>
    /// <dt>
    /// elasticbeanstalk:RemoveTags
    /// </dt>
    /// <dd>
    /// <p>Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tag keys to remove in the <code>TagsToRemove</code> parameter.</p>
    /// </dd>
    /// </dl>
    /// <p>For details about creating a custom user policy, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies">Creating a Custom User Policy</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_tags_for_resource_input::Builder,
    }
    impl UpdateTagsForResource {
        /// Creates a new `UpdateTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resouce to be updated.</p>
        /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resouce to be updated.</p>
        /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagsToAdd`.
        ///
        /// To override the contents of this collection use [`set_tags_to_add`](Self::set_tags_to_add).
        ///
        /// <p>A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.</p>
        /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
        pub fn tags_to_add(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags_to_add(input);
            self
        }
        /// <p>A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.</p>
        /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
        pub fn set_tags_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags_to_add(input);
            self
        }
        /// Appends an item to `TagsToRemove`.
        ///
        /// To override the contents of this collection use [`set_tags_to_remove`](Self::set_tags_to_remove).
        ///
        /// <p>A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.</p>
        /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
        pub fn tags_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tags_to_remove(input.into());
            self
        }
        /// <p>A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.</p>
        /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
        pub fn set_tags_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tags_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ValidateConfigurationSettings`.
    ///
    /// <p>Takes a set of configuration settings and either a configuration template or environment, and determines whether those values are valid.</p>
    /// <p>This action returns a list of messages indicating any errors or warnings associated with the selection of option values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ValidateConfigurationSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::validate_configuration_settings_input::Builder,
    }
    impl ValidateConfigurationSettings {
        /// Creates a new `ValidateConfigurationSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ValidateConfigurationSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ValidateConfigurationSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application that the configuration template or environment belongs to.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The name of the application that the configuration template or environment belongs to.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the configuration template to validate the settings against.</p>
        /// <p>Condition: You cannot specify both this and an environment name.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the configuration template to validate the settings against.</p>
        /// <p>Condition: You cannot specify both this and an environment name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The name of the environment to validate the settings against.</p>
        /// <p>Condition: You cannot specify both this and a configuration template name.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(input.into());
            self
        }
        /// <p>The name of the environment to validate the settings against.</p>
        /// <p>Condition: You cannot specify both this and a configuration template name.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// Appends an item to `OptionSettings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>A list of the options and desired values to evaluate.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            self.inner = self.inner.option_settings(input);
            self
        }
        /// <p>A list of the options and desired values to evaluate.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.inner = self.inner.set_option_settings(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
