// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_abort_environment_update_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AbortEnvironmentUpdateOutput,
    crate::error::AbortEnvironmentUpdateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AbortEnvironmentUpdateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AbortEnvironmentUpdateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::AbortEnvironmentUpdateError {
            meta: generic,
            kind: crate::error::AbortEnvironmentUpdateErrorKind::InsufficientPrivilegesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AbortEnvironmentUpdateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AbortEnvironmentUpdateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_abort_environment_update_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AbortEnvironmentUpdateOutput,
    crate::error::AbortEnvironmentUpdateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::abort_environment_update_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_apply_environment_managed_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ApplyEnvironmentManagedActionOutput,
    crate::error::ApplyEnvironmentManagedActionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ApplyEnvironmentManagedActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ApplyEnvironmentManagedActionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ElasticBeanstalkServiceException" => crate::error::ApplyEnvironmentManagedActionError { meta: generic, kind: crate::error::ApplyEnvironmentManagedActionErrorKind::ElasticBeanstalkServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::elastic_beanstalk_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_elastic_beanstalk_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ApplyEnvironmentManagedActionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ManagedActionInvalidStateException" => crate::error::ApplyEnvironmentManagedActionError { meta: generic, kind: crate::error::ApplyEnvironmentManagedActionErrorKind::ManagedActionInvalidStateException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::managed_action_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_managed_action_invalid_state_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ApplyEnvironmentManagedActionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ApplyEnvironmentManagedActionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_apply_environment_managed_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ApplyEnvironmentManagedActionOutput,
    crate::error::ApplyEnvironmentManagedActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::apply_environment_managed_action_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_apply_environment_managed_action(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ApplyEnvironmentManagedActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_environment_operations_role_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateEnvironmentOperationsRoleOutput,
    crate::error::AssociateEnvironmentOperationsRoleError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateEnvironmentOperationsRoleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateEnvironmentOperationsRoleError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::AssociateEnvironmentOperationsRoleError { meta: generic, kind: crate::error::AssociateEnvironmentOperationsRoleErrorKind::InsufficientPrivilegesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AssociateEnvironmentOperationsRoleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AssociateEnvironmentOperationsRoleError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_environment_operations_role_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateEnvironmentOperationsRoleOutput,
    crate::error::AssociateEnvironmentOperationsRoleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::associate_environment_operations_role_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_check_dns_availability_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CheckDnsAvailabilityOutput,
    crate::error::CheckDNSAvailabilityError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CheckDNSAvailabilityError::unhandled)?;
    Err(crate::error::CheckDNSAvailabilityError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_check_dns_availability_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CheckDnsAvailabilityOutput,
    crate::error::CheckDNSAvailabilityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::check_dns_availability_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_check_dns_availability(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CheckDNSAvailabilityError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_compose_environments_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ComposeEnvironmentsOutput,
    crate::error::ComposeEnvironmentsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ComposeEnvironmentsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ComposeEnvironmentsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::ComposeEnvironmentsError {
            meta: generic,
            kind: crate::error::ComposeEnvironmentsErrorKind::InsufficientPrivilegesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ComposeEnvironmentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyEnvironmentsException" => crate::error::ComposeEnvironmentsError {
            meta: generic,
            kind: crate::error::ComposeEnvironmentsErrorKind::TooManyEnvironmentsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_environments_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_environments_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ComposeEnvironmentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ComposeEnvironmentsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_compose_environments_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ComposeEnvironmentsOutput,
    crate::error::ComposeEnvironmentsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::compose_environments_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_compose_environments(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ComposeEnvironmentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_application_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateApplicationOutput, crate::error::CreateApplicationError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateApplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateApplicationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "TooManyApplicationsException" => crate::error::CreateApplicationError {
            meta: generic,
            kind: crate::error::CreateApplicationErrorKind::TooManyApplicationsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_applications_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_applications_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateApplicationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_application_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateApplicationOutput, crate::error::CreateApplicationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_application_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_application(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateApplicationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_application_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateApplicationVersionOutput,
    crate::error::CreateApplicationVersionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateApplicationVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateApplicationVersionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeBuildNotInServiceRegionException" => crate::error::CreateApplicationVersionError { meta: generic, kind: crate::error::CreateApplicationVersionErrorKind::CodeBuildNotInServiceRegionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::code_build_not_in_service_region_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_code_build_not_in_service_region_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateApplicationVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientPrivilegesException" => crate::error::CreateApplicationVersionError { meta: generic, kind: crate::error::CreateApplicationVersionErrorKind::InsufficientPrivilegesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateApplicationVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "S3LocationNotInServiceRegionException" => crate::error::CreateApplicationVersionError { meta: generic, kind: crate::error::CreateApplicationVersionErrorKind::S3LocationNotInServiceRegionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::s3_location_not_in_service_region_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_s3_location_not_in_service_region_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateApplicationVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyApplicationsException" => crate::error::CreateApplicationVersionError { meta: generic, kind: crate::error::CreateApplicationVersionErrorKind::TooManyApplicationsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_applications_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_applications_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateApplicationVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyApplicationVersionsException" => crate::error::CreateApplicationVersionError { meta: generic, kind: crate::error::CreateApplicationVersionErrorKind::TooManyApplicationVersionsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_application_versions_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_application_versions_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateApplicationVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateApplicationVersionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_application_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateApplicationVersionOutput,
    crate::error::CreateApplicationVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_application_version_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_application_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateApplicationVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_configuration_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConfigurationTemplateOutput,
    crate::error::CreateConfigurationTemplateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateConfigurationTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateConfigurationTemplateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::CreateConfigurationTemplateError { meta: generic, kind: crate::error::CreateConfigurationTemplateErrorKind::InsufficientPrivilegesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationTemplateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyBucketsException" => crate::error::CreateConfigurationTemplateError { meta: generic, kind: crate::error::CreateConfigurationTemplateErrorKind::TooManyBucketsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_buckets_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_buckets_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationTemplateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyConfigurationTemplatesException" => crate::error::CreateConfigurationTemplateError { meta: generic, kind: crate::error::CreateConfigurationTemplateErrorKind::TooManyConfigurationTemplatesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_configuration_templates_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_configuration_templates_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationTemplateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateConfigurationTemplateError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_configuration_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConfigurationTemplateOutput,
    crate::error::CreateConfigurationTemplateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_configuration_template_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_configuration_template(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateConfigurationTemplateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_environment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateEnvironmentOutput, crate::error::CreateEnvironmentError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEnvironmentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateEnvironmentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::CreateEnvironmentError {
            meta: generic,
            kind: crate::error::CreateEnvironmentErrorKind::InsufficientPrivilegesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEnvironmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyEnvironmentsException" => crate::error::CreateEnvironmentError {
            meta: generic,
            kind: crate::error::CreateEnvironmentErrorKind::TooManyEnvironmentsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_environments_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_environments_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEnvironmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateEnvironmentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_environment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateEnvironmentOutput, crate::error::CreateEnvironmentError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_environment_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_environment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEnvironmentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_platform_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePlatformVersionOutput,
    crate::error::CreatePlatformVersionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePlatformVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePlatformVersionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ElasticBeanstalkServiceException" => crate::error::CreatePlatformVersionError {
            meta: generic,
            kind: crate::error::CreatePlatformVersionErrorKind::ElasticBeanstalkServiceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::elastic_beanstalk_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_elastic_beanstalk_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePlatformVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientPrivilegesException" => crate::error::CreatePlatformVersionError {
            meta: generic,
            kind: crate::error::CreatePlatformVersionErrorKind::InsufficientPrivilegesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePlatformVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyPlatformsException" => crate::error::CreatePlatformVersionError {
            meta: generic,
            kind: crate::error::CreatePlatformVersionErrorKind::TooManyPlatformsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_platforms_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_platforms_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePlatformVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePlatformVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_platform_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePlatformVersionOutput,
    crate::error::CreatePlatformVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_platform_version_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_platform_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePlatformVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_storage_location_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStorageLocationOutput,
    crate::error::CreateStorageLocationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateStorageLocationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateStorageLocationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::CreateStorageLocationError {
            meta: generic,
            kind: crate::error::CreateStorageLocationErrorKind::InsufficientPrivilegesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStorageLocationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "S3SubscriptionRequiredException" => crate::error::CreateStorageLocationError {
            meta: generic,
            kind: crate::error::CreateStorageLocationErrorKind::S3SubscriptionRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::s3_subscription_required_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_s3_subscription_required_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStorageLocationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyBucketsException" => crate::error::CreateStorageLocationError {
            meta: generic,
            kind: crate::error::CreateStorageLocationErrorKind::TooManyBucketsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_buckets_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_buckets_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStorageLocationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateStorageLocationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_storage_location_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStorageLocationOutput,
    crate::error::CreateStorageLocationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_storage_location_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_storage_location(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateStorageLocationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_application_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteApplicationOutput, crate::error::DeleteApplicationError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteApplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteApplicationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OperationInProgressFailure" => crate::error::DeleteApplicationError {
            meta: generic,
            kind: crate::error::DeleteApplicationErrorKind::OperationInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_in_progress_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteApplicationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_application_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteApplicationOutput, crate::error::DeleteApplicationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_application_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_application_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteApplicationVersionOutput,
    crate::error::DeleteApplicationVersionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteApplicationVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteApplicationVersionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::DeleteApplicationVersionError { meta: generic, kind: crate::error::DeleteApplicationVersionErrorKind::InsufficientPrivilegesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteApplicationVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationInProgressFailure" => crate::error::DeleteApplicationVersionError { meta: generic, kind: crate::error::DeleteApplicationVersionErrorKind::OperationInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_in_progress_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteApplicationVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "S3LocationNotInServiceRegionException" => crate::error::DeleteApplicationVersionError { meta: generic, kind: crate::error::DeleteApplicationVersionErrorKind::S3LocationNotInServiceRegionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::s3_location_not_in_service_region_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_s3_location_not_in_service_region_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteApplicationVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SourceBundleDeletionFailure" => crate::error::DeleteApplicationVersionError { meta: generic, kind: crate::error::DeleteApplicationVersionErrorKind::SourceBundleDeletionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::source_bundle_deletion_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_source_bundle_deletion_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteApplicationVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteApplicationVersionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_application_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteApplicationVersionOutput,
    crate::error::DeleteApplicationVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_application_version_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_configuration_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConfigurationTemplateOutput,
    crate::error::DeleteConfigurationTemplateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteConfigurationTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteConfigurationTemplateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OperationInProgressFailure" => crate::error::DeleteConfigurationTemplateError {
            meta: generic,
            kind: crate::error::DeleteConfigurationTemplateErrorKind::OperationInProgressException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_in_progress_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_operation_in_progress_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteConfigurationTemplateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteConfigurationTemplateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_configuration_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConfigurationTemplateOutput,
    crate::error::DeleteConfigurationTemplateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_configuration_template_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_environment_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEnvironmentConfigurationOutput,
    crate::error::DeleteEnvironmentConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEnvironmentConfigurationError::unhandled)?;
    Err(crate::error::DeleteEnvironmentConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_environment_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEnvironmentConfigurationOutput,
    crate::error::DeleteEnvironmentConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_environment_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_platform_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePlatformVersionOutput,
    crate::error::DeletePlatformVersionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePlatformVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePlatformVersionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ElasticBeanstalkServiceException" => crate::error::DeletePlatformVersionError { meta: generic, kind: crate::error::DeletePlatformVersionErrorKind::ElasticBeanstalkServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::elastic_beanstalk_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_elastic_beanstalk_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePlatformVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientPrivilegesException" => crate::error::DeletePlatformVersionError { meta: generic, kind: crate::error::DeletePlatformVersionErrorKind::InsufficientPrivilegesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePlatformVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationInProgressFailure" => crate::error::DeletePlatformVersionError { meta: generic, kind: crate::error::DeletePlatformVersionErrorKind::OperationInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_in_progress_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePlatformVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PlatformVersionStillReferencedException" => crate::error::DeletePlatformVersionError { meta: generic, kind: crate::error::DeletePlatformVersionErrorKind::PlatformVersionStillReferencedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::platform_version_still_referenced_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_platform_version_still_referenced_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePlatformVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeletePlatformVersionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_platform_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePlatformVersionOutput,
    crate::error::DeletePlatformVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_platform_version_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_platform_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeletePlatformVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountAttributesOutput,
    crate::error::DescribeAccountAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAccountAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeAccountAttributesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::DescribeAccountAttributesError {
            meta: generic,
            kind: crate::error::DescribeAccountAttributesErrorKind::InsufficientPrivilegesException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::insufficient_privileges_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccountAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeAccountAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountAttributesOutput,
    crate::error::DescribeAccountAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_account_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_account_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAccountAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_applications_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeApplicationsOutput,
    crate::error::DescribeApplicationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeApplicationsError::unhandled)?;
    Err(crate::error::DescribeApplicationsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_applications_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeApplicationsOutput,
    crate::error::DescribeApplicationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_applications_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_applications(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeApplicationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_application_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeApplicationVersionsOutput,
    crate::error::DescribeApplicationVersionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeApplicationVersionsError::unhandled)?;
    Err(crate::error::DescribeApplicationVersionsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_application_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeApplicationVersionsOutput,
    crate::error::DescribeApplicationVersionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_application_versions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_application_versions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeApplicationVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_configuration_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConfigurationOptionsOutput,
    crate::error::DescribeConfigurationOptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeConfigurationOptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeConfigurationOptionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "TooManyBucketsException" => crate::error::DescribeConfigurationOptionsError {
            meta: generic,
            kind: crate::error::DescribeConfigurationOptionsErrorKind::TooManyBucketsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_buckets_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_buckets_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeConfigurationOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeConfigurationOptionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_configuration_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConfigurationOptionsOutput,
    crate::error::DescribeConfigurationOptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_configuration_options_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_configuration_options(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeConfigurationOptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_configuration_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConfigurationSettingsOutput,
    crate::error::DescribeConfigurationSettingsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeConfigurationSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeConfigurationSettingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "TooManyBucketsException" => crate::error::DescribeConfigurationSettingsError {
            meta: generic,
            kind: crate::error::DescribeConfigurationSettingsErrorKind::TooManyBucketsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_buckets_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_buckets_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeConfigurationSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeConfigurationSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_configuration_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConfigurationSettingsOutput,
    crate::error::DescribeConfigurationSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_configuration_settings_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_configuration_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeConfigurationSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_environment_health_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEnvironmentHealthOutput,
    crate::error::DescribeEnvironmentHealthError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEnvironmentHealthError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeEnvironmentHealthError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ElasticBeanstalkServiceException" => crate::error::DescribeEnvironmentHealthError {
            meta: generic,
            kind:
                crate::error::DescribeEnvironmentHealthErrorKind::ElasticBeanstalkServiceException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::elastic_beanstalk_service_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_elastic_beanstalk_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEnvironmentHealthError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidRequestException" => crate::error::DescribeEnvironmentHealthError {
            meta: generic,
            kind: crate::error::DescribeEnvironmentHealthErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEnvironmentHealthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeEnvironmentHealthError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_environment_health_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEnvironmentHealthOutput,
    crate::error::DescribeEnvironmentHealthError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_environment_health_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_environment_health(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEnvironmentHealthError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_environment_managed_action_history_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEnvironmentManagedActionHistoryOutput,
    crate::error::DescribeEnvironmentManagedActionHistoryError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEnvironmentManagedActionHistoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DescribeEnvironmentManagedActionHistoryError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ElasticBeanstalkServiceException" => crate::error::DescribeEnvironmentManagedActionHistoryError { meta: generic, kind: crate::error::DescribeEnvironmentManagedActionHistoryErrorKind::ElasticBeanstalkServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::elastic_beanstalk_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_elastic_beanstalk_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEnvironmentManagedActionHistoryError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeEnvironmentManagedActionHistoryError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_environment_managed_action_history_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEnvironmentManagedActionHistoryOutput,
    crate::error::DescribeEnvironmentManagedActionHistoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_environment_managed_action_history_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_environment_managed_action_history(response.body().as_ref(), output).map_err(crate::error::DescribeEnvironmentManagedActionHistoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_environment_managed_actions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEnvironmentManagedActionsOutput,
    crate::error::DescribeEnvironmentManagedActionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEnvironmentManagedActionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeEnvironmentManagedActionsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ElasticBeanstalkServiceException" => crate::error::DescribeEnvironmentManagedActionsError { meta: generic, kind: crate::error::DescribeEnvironmentManagedActionsErrorKind::ElasticBeanstalkServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::elastic_beanstalk_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_elastic_beanstalk_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEnvironmentManagedActionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeEnvironmentManagedActionsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_environment_managed_actions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEnvironmentManagedActionsOutput,
    crate::error::DescribeEnvironmentManagedActionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_environment_managed_actions_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_environment_managed_actions(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeEnvironmentManagedActionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_environment_resources_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEnvironmentResourcesOutput,
    crate::error::DescribeEnvironmentResourcesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEnvironmentResourcesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeEnvironmentResourcesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::DescribeEnvironmentResourcesError {
            meta: generic,
            kind:
                crate::error::DescribeEnvironmentResourcesErrorKind::InsufficientPrivilegesException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::insufficient_privileges_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEnvironmentResourcesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeEnvironmentResourcesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_environment_resources_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEnvironmentResourcesOutput,
    crate::error::DescribeEnvironmentResourcesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_environment_resources_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_environment_resources(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEnvironmentResourcesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_environments_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEnvironmentsOutput,
    crate::error::DescribeEnvironmentsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEnvironmentsError::unhandled)?;
    Err(crate::error::DescribeEnvironmentsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_environments_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEnvironmentsOutput,
    crate::error::DescribeEnvironmentsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_environments_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_environments(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEnvironmentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_events_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEventsError::unhandled)?;
    Err(crate::error::DescribeEventsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_events_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_events_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_events(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEventsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_instances_health_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInstancesHealthOutput,
    crate::error::DescribeInstancesHealthError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeInstancesHealthError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeInstancesHealthError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ElasticBeanstalkServiceException" => crate::error::DescribeInstancesHealthError {
            meta: generic,
            kind: crate::error::DescribeInstancesHealthErrorKind::ElasticBeanstalkServiceException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::elastic_beanstalk_service_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_elastic_beanstalk_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeInstancesHealthError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidRequestException" => crate::error::DescribeInstancesHealthError {
            meta: generic,
            kind: crate::error::DescribeInstancesHealthErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeInstancesHealthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeInstancesHealthError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_instances_health_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInstancesHealthOutput,
    crate::error::DescribeInstancesHealthError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_instances_health_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_instances_health(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeInstancesHealthError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_platform_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePlatformVersionOutput,
    crate::error::DescribePlatformVersionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePlatformVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribePlatformVersionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ElasticBeanstalkServiceException" => crate::error::DescribePlatformVersionError {
            meta: generic,
            kind: crate::error::DescribePlatformVersionErrorKind::ElasticBeanstalkServiceException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::elastic_beanstalk_service_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_elastic_beanstalk_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribePlatformVersionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InsufficientPrivilegesException" => crate::error::DescribePlatformVersionError {
            meta: generic,
            kind: crate::error::DescribePlatformVersionErrorKind::InsufficientPrivilegesException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::insufficient_privileges_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribePlatformVersionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribePlatformVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_platform_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePlatformVersionOutput,
    crate::error::DescribePlatformVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_platform_version_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_platform_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribePlatformVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_environment_operations_role_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateEnvironmentOperationsRoleOutput,
    crate::error::DisassociateEnvironmentOperationsRoleError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateEnvironmentOperationsRoleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DisassociateEnvironmentOperationsRoleError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::DisassociateEnvironmentOperationsRoleError { meta: generic, kind: crate::error::DisassociateEnvironmentOperationsRoleErrorKind::InsufficientPrivilegesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DisassociateEnvironmentOperationsRoleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DisassociateEnvironmentOperationsRoleError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_environment_operations_role_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateEnvironmentOperationsRoleOutput,
    crate::error::DisassociateEnvironmentOperationsRoleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::disassociate_environment_operations_role_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_available_solution_stacks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAvailableSolutionStacksOutput,
    crate::error::ListAvailableSolutionStacksError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAvailableSolutionStacksError::unhandled)?;
    Err(crate::error::ListAvailableSolutionStacksError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_available_solution_stacks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAvailableSolutionStacksOutput,
    crate::error::ListAvailableSolutionStacksError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_available_solution_stacks_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_available_solution_stacks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAvailableSolutionStacksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_platform_branches_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPlatformBranchesOutput,
    crate::error::ListPlatformBranchesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPlatformBranchesError::unhandled)?;
    Err(crate::error::ListPlatformBranchesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_platform_branches_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPlatformBranchesOutput,
    crate::error::ListPlatformBranchesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_platform_branches_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_platform_branches(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPlatformBranchesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_platform_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPlatformVersionsOutput,
    crate::error::ListPlatformVersionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPlatformVersionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPlatformVersionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ElasticBeanstalkServiceException" => crate::error::ListPlatformVersionsError {
            meta: generic,
            kind: crate::error::ListPlatformVersionsErrorKind::ElasticBeanstalkServiceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::elastic_beanstalk_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_elastic_beanstalk_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPlatformVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientPrivilegesException" => crate::error::ListPlatformVersionsError {
            meta: generic,
            kind: crate::error::ListPlatformVersionsErrorKind::InsufficientPrivilegesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPlatformVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPlatformVersionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_platform_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPlatformVersionsOutput,
    crate::error::ListPlatformVersionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_platform_versions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_platform_versions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPlatformVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InsufficientPrivilegesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceTypeNotSupportedException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ResourceTypeNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_type_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_type_not_supported_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_rebuild_environment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RebuildEnvironmentOutput,
    crate::error::RebuildEnvironmentError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RebuildEnvironmentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RebuildEnvironmentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::RebuildEnvironmentError {
            meta: generic,
            kind: crate::error::RebuildEnvironmentErrorKind::InsufficientPrivilegesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RebuildEnvironmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RebuildEnvironmentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_rebuild_environment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RebuildEnvironmentOutput,
    crate::error::RebuildEnvironmentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::rebuild_environment_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_request_environment_info_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RequestEnvironmentInfoOutput,
    crate::error::RequestEnvironmentInfoError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RequestEnvironmentInfoError::unhandled)?;
    Err(crate::error::RequestEnvironmentInfoError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_request_environment_info_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RequestEnvironmentInfoOutput,
    crate::error::RequestEnvironmentInfoError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::request_environment_info_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restart_app_server_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RestartAppServerOutput, crate::error::RestartAppServerError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestartAppServerError::unhandled)?;
    Err(crate::error::RestartAppServerError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restart_app_server_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RestartAppServerOutput, crate::error::RestartAppServerError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::restart_app_server_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_retrieve_environment_info_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RetrieveEnvironmentInfoOutput,
    crate::error::RetrieveEnvironmentInfoError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RetrieveEnvironmentInfoError::unhandled)?;
    Err(crate::error::RetrieveEnvironmentInfoError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_retrieve_environment_info_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RetrieveEnvironmentInfoOutput,
    crate::error::RetrieveEnvironmentInfoError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::retrieve_environment_info_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_retrieve_environment_info(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RetrieveEnvironmentInfoError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_swap_environment_cnam_es_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SwapEnvironmentCnamEsOutput,
    crate::error::SwapEnvironmentCNAMEsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SwapEnvironmentCNAMEsError::unhandled)?;
    Err(crate::error::SwapEnvironmentCNAMEsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_swap_environment_cnam_es_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SwapEnvironmentCnamEsOutput,
    crate::error::SwapEnvironmentCNAMEsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::swap_environment_cnam_es_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_terminate_environment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TerminateEnvironmentOutput,
    crate::error::TerminateEnvironmentError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TerminateEnvironmentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TerminateEnvironmentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::TerminateEnvironmentError {
            meta: generic,
            kind: crate::error::TerminateEnvironmentErrorKind::InsufficientPrivilegesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TerminateEnvironmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TerminateEnvironmentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_terminate_environment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TerminateEnvironmentOutput,
    crate::error::TerminateEnvironmentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::terminate_environment_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_terminate_environment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::TerminateEnvironmentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_application_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateApplicationOutput, crate::error::UpdateApplicationError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateApplicationError::unhandled)?;
    Err(crate::error::UpdateApplicationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_application_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateApplicationOutput, crate::error::UpdateApplicationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_application_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_application(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateApplicationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_application_resource_lifecycle_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateApplicationResourceLifecycleOutput,
    crate::error::UpdateApplicationResourceLifecycleError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateApplicationResourceLifecycleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateApplicationResourceLifecycleError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::UpdateApplicationResourceLifecycleError { meta: generic, kind: crate::error::UpdateApplicationResourceLifecycleErrorKind::InsufficientPrivilegesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateApplicationResourceLifecycleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateApplicationResourceLifecycleError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_application_resource_lifecycle_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateApplicationResourceLifecycleOutput,
    crate::error::UpdateApplicationResourceLifecycleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_application_resource_lifecycle_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_application_resource_lifecycle(response.body().as_ref(), output).map_err(crate::error::UpdateApplicationResourceLifecycleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_application_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateApplicationVersionOutput,
    crate::error::UpdateApplicationVersionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateApplicationVersionError::unhandled)?;
    Err(crate::error::UpdateApplicationVersionError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_application_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateApplicationVersionOutput,
    crate::error::UpdateApplicationVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_application_version_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_application_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateApplicationVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_configuration_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConfigurationTemplateOutput,
    crate::error::UpdateConfigurationTemplateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateConfigurationTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateConfigurationTemplateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::UpdateConfigurationTemplateError {
            meta: generic,
            kind:
                crate::error::UpdateConfigurationTemplateErrorKind::InsufficientPrivilegesException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::insufficient_privileges_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateConfigurationTemplateError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "TooManyBucketsException" => crate::error::UpdateConfigurationTemplateError {
            meta: generic,
            kind: crate::error::UpdateConfigurationTemplateErrorKind::TooManyBucketsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_buckets_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_buckets_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateConfigurationTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateConfigurationTemplateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_configuration_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConfigurationTemplateOutput,
    crate::error::UpdateConfigurationTemplateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_configuration_template_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_configuration_template(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateConfigurationTemplateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_environment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateEnvironmentOutput, crate::error::UpdateEnvironmentError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateEnvironmentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateEnvironmentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::UpdateEnvironmentError {
            meta: generic,
            kind: crate::error::UpdateEnvironmentErrorKind::InsufficientPrivilegesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateEnvironmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyBucketsException" => crate::error::UpdateEnvironmentError {
            meta: generic,
            kind: crate::error::UpdateEnvironmentErrorKind::TooManyBucketsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_buckets_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_buckets_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateEnvironmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateEnvironmentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_environment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateEnvironmentOutput, crate::error::UpdateEnvironmentError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_environment_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_environment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateEnvironmentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateTagsForResourceOutput,
    crate::error::UpdateTagsForResourceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::UpdateTagsForResourceError {
            meta: generic,
            kind: crate::error::UpdateTagsForResourceErrorKind::InsufficientPrivilegesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationInProgressFailure" => crate::error::UpdateTagsForResourceError {
            meta: generic,
            kind: crate::error::UpdateTagsForResourceErrorKind::OperationInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_operation_in_progress_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateTagsForResourceError {
            meta: generic,
            kind: crate::error::UpdateTagsForResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceTypeNotSupportedException" => crate::error::UpdateTagsForResourceError {
            meta: generic,
            kind: crate::error::UpdateTagsForResourceErrorKind::ResourceTypeNotSupportedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_type_not_supported_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_resource_type_not_supported_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "TooManyTagsException" => crate::error::UpdateTagsForResourceError {
            meta: generic,
            kind: crate::error::UpdateTagsForResourceErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_tags_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateTagsForResourceOutput,
    crate::error::UpdateTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_tags_for_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_validate_configuration_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ValidateConfigurationSettingsOutput,
    crate::error::ValidateConfigurationSettingsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ValidateConfigurationSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ValidateConfigurationSettingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientPrivilegesException" => crate::error::ValidateConfigurationSettingsError { meta: generic, kind: crate::error::ValidateConfigurationSettingsErrorKind::InsufficientPrivilegesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_privileges_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_privileges_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ValidateConfigurationSettingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyBucketsException" => crate::error::ValidateConfigurationSettingsError { meta: generic, kind: crate::error::ValidateConfigurationSettingsErrorKind::TooManyBucketsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_buckets_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_buckets_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ValidateConfigurationSettingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ValidateConfigurationSettingsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_validate_configuration_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ValidateConfigurationSettingsOutput,
    crate::error::ValidateConfigurationSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::validate_configuration_settings_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_validate_configuration_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ValidateConfigurationSettingsError::unhandled)?;
        output.build()
    })
}
