// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub fn parse_http_generic_error(
    response: &http::Response<bytes::Bytes>,
) -> Result<aws_smithy_types::Error, aws_smithy_xml::decode::XmlError> {
    crate::rest_xml_wrapped_errors::parse_generic_error(response.body().as_ref())
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_insufficient_privileges_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::insufficient_privileges_exception::Builder,
) -> Result<
    crate::error::insufficient_privileges_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#InsufficientPrivilegesException$message */ =>  {
                let var_1 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_1);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_elastic_beanstalk_service_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::elastic_beanstalk_service_exception::Builder,
) -> Result<
    crate::error::elastic_beanstalk_service_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#ElasticBeanstalkServiceException$message */ =>  {
                let var_2 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_2);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_managed_action_invalid_state_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::managed_action_invalid_state_exception::Builder,
) -> Result<
    crate::error::managed_action_invalid_state_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#ManagedActionInvalidStateException$message */ =>  {
                let var_3 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_3);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_apply_environment_managed_action(
    inp: &[u8],
    mut builder: crate::output::apply_environment_managed_action_output::Builder,
) -> Result<
    crate::output::apply_environment_managed_action_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ApplyEnvironmentManagedActionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ApplyEnvironmentManagedActionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ApplyEnvironmentManagedActionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ApplyEnvironmentManagedActionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ActionId") /* ActionId com.amazonaws.elasticbeanstalk.synthetic#ApplyEnvironmentManagedActionOutput$ActionId */ =>  {
                let var_4 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_action_id(var_4);
            }
            ,
            s if s.matches("ActionDescription") /* ActionDescription com.amazonaws.elasticbeanstalk.synthetic#ApplyEnvironmentManagedActionOutput$ActionDescription */ =>  {
                let var_5 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_action_description(var_5);
            }
            ,
            s if s.matches("ActionType") /* ActionType com.amazonaws.elasticbeanstalk.synthetic#ApplyEnvironmentManagedActionOutput$ActionType */ =>  {
                let var_6 =
                    Some(
                        Result::<crate::model::ActionType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ActionType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_action_type(var_6);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.elasticbeanstalk.synthetic#ApplyEnvironmentManagedActionOutput$Status */ =>  {
                let var_7 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_7);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ApplyEnvironmentManagedActionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_check_dns_availability(
    inp: &[u8],
    mut builder: crate::output::check_dns_availability_output::Builder,
) -> Result<crate::output::check_dns_availability_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CheckDNSAvailabilityResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CheckDNSAvailabilityResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CheckDNSAvailabilityResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CheckDNSAvailabilityResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Available") /* Available com.amazonaws.elasticbeanstalk.synthetic#CheckDNSAvailabilityOutput$Available */ =>  {
                let var_8 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.elasticbeanstalk#CnameAvailability`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_available(var_8);
            }
            ,
            s if s.matches("FullyQualifiedCNAME") /* FullyQualifiedCNAME com.amazonaws.elasticbeanstalk.synthetic#CheckDNSAvailabilityOutput$FullyQualifiedCNAME */ =>  {
                let var_9 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_fully_qualified_cname(var_9);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CheckDNSAvailabilityResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_too_many_environments_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::too_many_environments_exception::Builder,
) -> Result<crate::error::too_many_environments_exception::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#TooManyEnvironmentsException$message */ =>  {
                let var_10 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_10);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_compose_environments(
    inp: &[u8],
    mut builder: crate::output::compose_environments_output::Builder,
) -> Result<crate::output::compose_environments_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ComposeEnvironmentsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ComposeEnvironmentsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ComposeEnvironmentsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ComposeEnvironmentsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Environments") /* Environments com.amazonaws.elasticbeanstalk.synthetic#ComposeEnvironmentsOutput$Environments */ =>  {
                let var_11 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_environment_descriptions_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_environments(var_11);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.elasticbeanstalk.synthetic#ComposeEnvironmentsOutput$NextToken */ =>  {
                let var_12 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_12);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ComposeEnvironmentsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_too_many_applications_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::too_many_applications_exception::Builder,
) -> Result<crate::error::too_many_applications_exception::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#TooManyApplicationsException$message */ =>  {
                let var_13 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_13);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_application(
    inp: &[u8],
    mut builder: crate::output::create_application_output::Builder,
) -> Result<crate::output::create_application_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateApplicationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateApplicationResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateApplicationResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateApplicationResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Application") /* Application com.amazonaws.elasticbeanstalk.synthetic#CreateApplicationOutput$Application */ =>  {
                let var_14 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_application_description(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_application(var_14);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateApplicationResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_code_build_not_in_service_region_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::code_build_not_in_service_region_exception::Builder,
) -> Result<
    crate::error::code_build_not_in_service_region_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#CodeBuildNotInServiceRegionException$message */ =>  {
                let var_15 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_15);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_s3_location_not_in_service_region_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::s3_location_not_in_service_region_exception::Builder,
) -> Result<
    crate::error::s3_location_not_in_service_region_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#S3LocationNotInServiceRegionException$message */ =>  {
                let var_16 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_16);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_too_many_application_versions_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::too_many_application_versions_exception::Builder,
) -> Result<
    crate::error::too_many_application_versions_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#TooManyApplicationVersionsException$message */ =>  {
                let var_17 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_17);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_application_version(
    inp: &[u8],
    mut builder: crate::output::create_application_version_output::Builder,
) -> Result<
    crate::output::create_application_version_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateApplicationVersionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateApplicationVersionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateApplicationVersionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateApplicationVersionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ApplicationVersion") /* ApplicationVersion com.amazonaws.elasticbeanstalk.synthetic#CreateApplicationVersionOutput$ApplicationVersion */ =>  {
                let var_18 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_application_version_description(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_application_version(var_18);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateApplicationVersionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_too_many_buckets_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::too_many_buckets_exception::Builder,
) -> Result<crate::error::too_many_buckets_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#TooManyBucketsException$message */ =>  {
                let var_19 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_19);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_too_many_configuration_templates_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::too_many_configuration_templates_exception::Builder,
) -> Result<
    crate::error::too_many_configuration_templates_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#TooManyConfigurationTemplatesException$message */ =>  {
                let var_20 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_20);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_configuration_template(
    inp: &[u8],
    mut builder: crate::output::create_configuration_template_output::Builder,
) -> Result<
    crate::output::create_configuration_template_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateConfigurationTemplateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateConfigurationTemplateResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateConfigurationTemplateResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateConfigurationTemplateResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SolutionStackName") /* SolutionStackName com.amazonaws.elasticbeanstalk.synthetic#CreateConfigurationTemplateOutput$SolutionStackName */ =>  {
                let var_21 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_solution_stack_name(var_21);
            }
            ,
            s if s.matches("PlatformArn") /* PlatformArn com.amazonaws.elasticbeanstalk.synthetic#CreateConfigurationTemplateOutput$PlatformArn */ =>  {
                let var_22 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_arn(var_22);
            }
            ,
            s if s.matches("ApplicationName") /* ApplicationName com.amazonaws.elasticbeanstalk.synthetic#CreateConfigurationTemplateOutput$ApplicationName */ =>  {
                let var_23 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_application_name(var_23);
            }
            ,
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.elasticbeanstalk.synthetic#CreateConfigurationTemplateOutput$TemplateName */ =>  {
                let var_24 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_24);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.elasticbeanstalk.synthetic#CreateConfigurationTemplateOutput$Description */ =>  {
                let var_25 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_25);
            }
            ,
            s if s.matches("EnvironmentName") /* EnvironmentName com.amazonaws.elasticbeanstalk.synthetic#CreateConfigurationTemplateOutput$EnvironmentName */ =>  {
                let var_26 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_name(var_26);
            }
            ,
            s if s.matches("DeploymentStatus") /* DeploymentStatus com.amazonaws.elasticbeanstalk.synthetic#CreateConfigurationTemplateOutput$DeploymentStatus */ =>  {
                let var_27 =
                    Some(
                        Result::<crate::model::ConfigurationDeploymentStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ConfigurationDeploymentStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_deployment_status(var_27);
            }
            ,
            s if s.matches("DateCreated") /* DateCreated com.amazonaws.elasticbeanstalk.synthetic#CreateConfigurationTemplateOutput$DateCreated */ =>  {
                let var_28 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_created(var_28);
            }
            ,
            s if s.matches("DateUpdated") /* DateUpdated com.amazonaws.elasticbeanstalk.synthetic#CreateConfigurationTemplateOutput$DateUpdated */ =>  {
                let var_29 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_updated(var_29);
            }
            ,
            s if s.matches("OptionSettings") /* OptionSettings com.amazonaws.elasticbeanstalk.synthetic#CreateConfigurationTemplateOutput$OptionSettings */ =>  {
                let var_30 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_configuration_option_settings_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_option_settings(var_30);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateConfigurationTemplateResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_environment(
    inp: &[u8],
    mut builder: crate::output::create_environment_output::Builder,
) -> Result<crate::output::create_environment_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateEnvironmentResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateEnvironmentResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateEnvironmentResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateEnvironmentResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("EnvironmentName") /* EnvironmentName com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$EnvironmentName */ =>  {
                let var_31 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_name(var_31);
            }
            ,
            s if s.matches("EnvironmentId") /* EnvironmentId com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$EnvironmentId */ =>  {
                let var_32 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_id(var_32);
            }
            ,
            s if s.matches("ApplicationName") /* ApplicationName com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$ApplicationName */ =>  {
                let var_33 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_application_name(var_33);
            }
            ,
            s if s.matches("VersionLabel") /* VersionLabel com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$VersionLabel */ =>  {
                let var_34 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version_label(var_34);
            }
            ,
            s if s.matches("SolutionStackName") /* SolutionStackName com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$SolutionStackName */ =>  {
                let var_35 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_solution_stack_name(var_35);
            }
            ,
            s if s.matches("PlatformArn") /* PlatformArn com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$PlatformArn */ =>  {
                let var_36 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_arn(var_36);
            }
            ,
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$TemplateName */ =>  {
                let var_37 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_37);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$Description */ =>  {
                let var_38 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_38);
            }
            ,
            s if s.matches("EndpointURL") /* EndpointURL com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$EndpointURL */ =>  {
                let var_39 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_endpoint_url(var_39);
            }
            ,
            s if s.matches("CNAME") /* CNAME com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$CNAME */ =>  {
                let var_40 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cname(var_40);
            }
            ,
            s if s.matches("DateCreated") /* DateCreated com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$DateCreated */ =>  {
                let var_41 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_created(var_41);
            }
            ,
            s if s.matches("DateUpdated") /* DateUpdated com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$DateUpdated */ =>  {
                let var_42 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_updated(var_42);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$Status */ =>  {
                let var_43 =
                    Some(
                        Result::<crate::model::EnvironmentStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_43);
            }
            ,
            s if s.matches("AbortableOperationInProgress") /* AbortableOperationInProgress com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$AbortableOperationInProgress */ =>  {
                let var_44 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.elasticbeanstalk#AbortableOperationInProgress`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_abortable_operation_in_progress(var_44);
            }
            ,
            s if s.matches("Health") /* Health com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$Health */ =>  {
                let var_45 =
                    Some(
                        Result::<crate::model::EnvironmentHealth, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentHealth::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_health(var_45);
            }
            ,
            s if s.matches("HealthStatus") /* HealthStatus com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$HealthStatus */ =>  {
                let var_46 =
                    Some(
                        Result::<crate::model::EnvironmentHealthStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentHealthStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_health_status(var_46);
            }
            ,
            s if s.matches("Resources") /* Resources com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$Resources */ =>  {
                let var_47 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_environment_resources_description(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resources(var_47);
            }
            ,
            s if s.matches("Tier") /* Tier com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$Tier */ =>  {
                let var_48 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_environment_tier(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tier(var_48);
            }
            ,
            s if s.matches("EnvironmentLinks") /* EnvironmentLinks com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$EnvironmentLinks */ =>  {
                let var_49 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_environment_links(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_environment_links(var_49);
            }
            ,
            s if s.matches("EnvironmentArn") /* EnvironmentArn com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$EnvironmentArn */ =>  {
                let var_50 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_arn(var_50);
            }
            ,
            s if s.matches("OperationsRole") /* OperationsRole com.amazonaws.elasticbeanstalk.synthetic#CreateEnvironmentOutput$OperationsRole */ =>  {
                let var_51 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_operations_role(var_51);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateEnvironmentResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_too_many_platforms_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::too_many_platforms_exception::Builder,
) -> Result<crate::error::too_many_platforms_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#TooManyPlatformsException$message */ =>  {
                let var_52 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_52);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_platform_version(
    inp: &[u8],
    mut builder: crate::output::create_platform_version_output::Builder,
) -> Result<crate::output::create_platform_version_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreatePlatformVersionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreatePlatformVersionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreatePlatformVersionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreatePlatformVersionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PlatformSummary") /* PlatformSummary com.amazonaws.elasticbeanstalk.synthetic#CreatePlatformVersionOutput$PlatformSummary */ =>  {
                let var_53 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_platform_summary(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_platform_summary(var_53);
            }
            ,
            s if s.matches("Builder") /* Builder com.amazonaws.elasticbeanstalk.synthetic#CreatePlatformVersionOutput$Builder */ =>  {
                let var_54 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_builder(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_builder(var_54);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreatePlatformVersionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_s3_subscription_required_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::s3_subscription_required_exception::Builder,
) -> Result<
    crate::error::s3_subscription_required_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#S3SubscriptionRequiredException$message */ =>  {
                let var_55 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_55);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_storage_location(
    inp: &[u8],
    mut builder: crate::output::create_storage_location_output::Builder,
) -> Result<crate::output::create_storage_location_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateStorageLocationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateStorageLocationResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateStorageLocationResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateStorageLocationResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("S3Bucket") /* S3Bucket com.amazonaws.elasticbeanstalk.synthetic#CreateStorageLocationOutput$S3Bucket */ =>  {
                let var_56 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_s3_bucket(var_56);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateStorageLocationResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_operation_in_progress_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::operation_in_progress_exception::Builder,
) -> Result<crate::error::operation_in_progress_exception::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#OperationInProgressException$message */ =>  {
                let var_57 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_57);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_source_bundle_deletion_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::source_bundle_deletion_exception::Builder,
) -> Result<crate::error::source_bundle_deletion_exception::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#SourceBundleDeletionException$message */ =>  {
                let var_58 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_58);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_platform_version_still_referenced_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::platform_version_still_referenced_exception::Builder,
) -> Result<
    crate::error::platform_version_still_referenced_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#PlatformVersionStillReferencedException$message */ =>  {
                let var_59 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_59);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_platform_version(
    inp: &[u8],
    mut builder: crate::output::delete_platform_version_output::Builder,
) -> Result<crate::output::delete_platform_version_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeletePlatformVersionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeletePlatformVersionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeletePlatformVersionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeletePlatformVersionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PlatformSummary") /* PlatformSummary com.amazonaws.elasticbeanstalk.synthetic#DeletePlatformVersionOutput$PlatformSummary */ =>  {
                let var_60 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_platform_summary(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_platform_summary(var_60);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeletePlatformVersionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_account_attributes(
    inp: &[u8],
    mut builder: crate::output::describe_account_attributes_output::Builder,
) -> Result<
    crate::output::describe_account_attributes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAccountAttributesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAccountAttributesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeAccountAttributesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeAccountAttributesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ResourceQuotas") /* ResourceQuotas com.amazonaws.elasticbeanstalk.synthetic#DescribeAccountAttributesOutput$ResourceQuotas */ =>  {
                let var_61 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_resource_quotas(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resource_quotas(var_61);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeAccountAttributesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_applications(
    inp: &[u8],
    mut builder: crate::output::describe_applications_output::Builder,
) -> Result<crate::output::describe_applications_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeApplicationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeApplicationsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeApplicationsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeApplicationsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Applications") /* Applications com.amazonaws.elasticbeanstalk.synthetic#DescribeApplicationsOutput$Applications */ =>  {
                let var_62 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_application_description_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_applications(var_62);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeApplicationsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_application_versions(
    inp: &[u8],
    mut builder: crate::output::describe_application_versions_output::Builder,
) -> Result<
    crate::output::describe_application_versions_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeApplicationVersionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeApplicationVersionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeApplicationVersionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeApplicationVersionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ApplicationVersions") /* ApplicationVersions com.amazonaws.elasticbeanstalk.synthetic#DescribeApplicationVersionsOutput$ApplicationVersions */ =>  {
                let var_63 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_application_version_description_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_application_versions(var_63);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.elasticbeanstalk.synthetic#DescribeApplicationVersionsOutput$NextToken */ =>  {
                let var_64 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_64);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeApplicationVersionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_configuration_options(
    inp: &[u8],
    mut builder: crate::output::describe_configuration_options_output::Builder,
) -> Result<
    crate::output::describe_configuration_options_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeConfigurationOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeConfigurationOptionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeConfigurationOptionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeConfigurationOptionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SolutionStackName") /* SolutionStackName com.amazonaws.elasticbeanstalk.synthetic#DescribeConfigurationOptionsOutput$SolutionStackName */ =>  {
                let var_65 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_solution_stack_name(var_65);
            }
            ,
            s if s.matches("PlatformArn") /* PlatformArn com.amazonaws.elasticbeanstalk.synthetic#DescribeConfigurationOptionsOutput$PlatformArn */ =>  {
                let var_66 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_arn(var_66);
            }
            ,
            s if s.matches("Options") /* Options com.amazonaws.elasticbeanstalk.synthetic#DescribeConfigurationOptionsOutput$Options */ =>  {
                let var_67 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_configuration_option_descriptions_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_options(var_67);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeConfigurationOptionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_configuration_settings(
    inp: &[u8],
    mut builder: crate::output::describe_configuration_settings_output::Builder,
) -> Result<
    crate::output::describe_configuration_settings_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeConfigurationSettingsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeConfigurationSettingsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeConfigurationSettingsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeConfigurationSettingsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ConfigurationSettings") /* ConfigurationSettings com.amazonaws.elasticbeanstalk.synthetic#DescribeConfigurationSettingsOutput$ConfigurationSettings */ =>  {
                let var_68 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_configuration_settings_description_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_configuration_settings(var_68);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeConfigurationSettingsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_request_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_request_exception::Builder,
) -> Result<crate::error::invalid_request_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#InvalidRequestException$message */ =>  {
                let var_69 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_69);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_environment_health(
    inp: &[u8],
    mut builder: crate::output::describe_environment_health_output::Builder,
) -> Result<
    crate::output::describe_environment_health_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeEnvironmentHealthResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeEnvironmentHealthResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeEnvironmentHealthResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeEnvironmentHealthResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("EnvironmentName") /* EnvironmentName com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentHealthOutput$EnvironmentName */ =>  {
                let var_70 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_name(var_70);
            }
            ,
            s if s.matches("HealthStatus") /* HealthStatus com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentHealthOutput$HealthStatus */ =>  {
                let var_71 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_health_status(var_71);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentHealthOutput$Status */ =>  {
                let var_72 =
                    Some(
                        Result::<crate::model::EnvironmentHealth, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentHealth::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_72);
            }
            ,
            s if s.matches("Color") /* Color com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentHealthOutput$Color */ =>  {
                let var_73 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_color(var_73);
            }
            ,
            s if s.matches("Causes") /* Causes com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentHealthOutput$Causes */ =>  {
                let var_74 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_causes(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_causes(var_74);
            }
            ,
            s if s.matches("ApplicationMetrics") /* ApplicationMetrics com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentHealthOutput$ApplicationMetrics */ =>  {
                let var_75 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_application_metrics(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_application_metrics(var_75);
            }
            ,
            s if s.matches("InstancesHealth") /* InstancesHealth com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentHealthOutput$InstancesHealth */ =>  {
                let var_76 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_health_summary(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instances_health(var_76);
            }
            ,
            s if s.matches("RefreshedAt") /* RefreshedAt com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentHealthOutput$RefreshedAt */ =>  {
                let var_77 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#RefreshedAt`)"))
                        ?
                    )
                ;
                builder = builder.set_refreshed_at(var_77);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeEnvironmentHealthResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_environment_managed_action_history(
    inp: &[u8],
    mut builder: crate::output::describe_environment_managed_action_history_output::Builder,
) -> Result<
    crate::output::describe_environment_managed_action_history_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeEnvironmentManagedActionHistoryResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeEnvironmentManagedActionHistoryResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeEnvironmentManagedActionHistoryResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeEnvironmentManagedActionHistoryResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ManagedActionHistoryItems") /* ManagedActionHistoryItems com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentManagedActionHistoryOutput$ManagedActionHistoryItems */ =>  {
                let var_78 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_managed_action_history_items(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_managed_action_history_items(var_78);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentManagedActionHistoryOutput$NextToken */ =>  {
                let var_79 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_79);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeEnvironmentManagedActionHistoryResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_environment_managed_actions(
    inp: &[u8],
    mut builder: crate::output::describe_environment_managed_actions_output::Builder,
) -> Result<
    crate::output::describe_environment_managed_actions_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeEnvironmentManagedActionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeEnvironmentManagedActionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeEnvironmentManagedActionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeEnvironmentManagedActionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ManagedActions") /* ManagedActions com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentManagedActionsOutput$ManagedActions */ =>  {
                let var_80 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_managed_actions(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_managed_actions(var_80);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeEnvironmentManagedActionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_environment_resources(
    inp: &[u8],
    mut builder: crate::output::describe_environment_resources_output::Builder,
) -> Result<
    crate::output::describe_environment_resources_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeEnvironmentResourcesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeEnvironmentResourcesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeEnvironmentResourcesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeEnvironmentResourcesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("EnvironmentResources") /* EnvironmentResources com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentResourcesOutput$EnvironmentResources */ =>  {
                let var_81 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_environment_resource_description(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_environment_resources(var_81);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeEnvironmentResourcesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_environments(
    inp: &[u8],
    mut builder: crate::output::describe_environments_output::Builder,
) -> Result<crate::output::describe_environments_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeEnvironmentsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeEnvironmentsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeEnvironmentsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeEnvironmentsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Environments") /* Environments com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentsOutput$Environments */ =>  {
                let var_82 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_environment_descriptions_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_environments(var_82);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.elasticbeanstalk.synthetic#DescribeEnvironmentsOutput$NextToken */ =>  {
                let var_83 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_83);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeEnvironmentsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_events(
    inp: &[u8],
    mut builder: crate::output::describe_events_output::Builder,
) -> Result<crate::output::describe_events_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeEventsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeEventsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeEventsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeEventsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Events") /* Events com.amazonaws.elasticbeanstalk.synthetic#DescribeEventsOutput$Events */ =>  {
                let var_84 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_event_description_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_events(var_84);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.elasticbeanstalk.synthetic#DescribeEventsOutput$NextToken */ =>  {
                let var_85 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_85);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeEventsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_instances_health(
    inp: &[u8],
    mut builder: crate::output::describe_instances_health_output::Builder,
) -> Result<
    crate::output::describe_instances_health_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeInstancesHealthResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeInstancesHealthResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeInstancesHealthResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeInstancesHealthResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("InstanceHealthList") /* InstanceHealthList com.amazonaws.elasticbeanstalk.synthetic#DescribeInstancesHealthOutput$InstanceHealthList */ =>  {
                let var_86 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_instance_health_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_health_list(var_86);
            }
            ,
            s if s.matches("RefreshedAt") /* RefreshedAt com.amazonaws.elasticbeanstalk.synthetic#DescribeInstancesHealthOutput$RefreshedAt */ =>  {
                let var_87 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#RefreshedAt`)"))
                        ?
                    )
                ;
                builder = builder.set_refreshed_at(var_87);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.elasticbeanstalk.synthetic#DescribeInstancesHealthOutput$NextToken */ =>  {
                let var_88 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_88);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeInstancesHealthResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_platform_version(
    inp: &[u8],
    mut builder: crate::output::describe_platform_version_output::Builder,
) -> Result<
    crate::output::describe_platform_version_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribePlatformVersionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribePlatformVersionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribePlatformVersionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribePlatformVersionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PlatformDescription") /* PlatformDescription com.amazonaws.elasticbeanstalk.synthetic#DescribePlatformVersionOutput$PlatformDescription */ =>  {
                let var_89 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_platform_description(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_platform_description(var_89);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribePlatformVersionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_available_solution_stacks(
    inp: &[u8],
    mut builder: crate::output::list_available_solution_stacks_output::Builder,
) -> Result<
    crate::output::list_available_solution_stacks_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListAvailableSolutionStacksResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListAvailableSolutionStacksResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListAvailableSolutionStacksResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListAvailableSolutionStacksResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SolutionStacks") /* SolutionStacks com.amazonaws.elasticbeanstalk.synthetic#ListAvailableSolutionStacksOutput$SolutionStacks */ =>  {
                let var_90 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_available_solution_stack_names_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_solution_stacks(var_90);
            }
            ,
            s if s.matches("SolutionStackDetails") /* SolutionStackDetails com.amazonaws.elasticbeanstalk.synthetic#ListAvailableSolutionStacksOutput$SolutionStackDetails */ =>  {
                let var_91 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_available_solution_stack_details_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_solution_stack_details(var_91);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListAvailableSolutionStacksResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_platform_branches(
    inp: &[u8],
    mut builder: crate::output::list_platform_branches_output::Builder,
) -> Result<crate::output::list_platform_branches_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListPlatformBranchesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListPlatformBranchesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListPlatformBranchesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListPlatformBranchesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PlatformBranchSummaryList") /* PlatformBranchSummaryList com.amazonaws.elasticbeanstalk.synthetic#ListPlatformBranchesOutput$PlatformBranchSummaryList */ =>  {
                let var_92 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_platform_branch_summary_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_platform_branch_summary_list(var_92);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.elasticbeanstalk.synthetic#ListPlatformBranchesOutput$NextToken */ =>  {
                let var_93 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_93);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListPlatformBranchesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_platform_versions(
    inp: &[u8],
    mut builder: crate::output::list_platform_versions_output::Builder,
) -> Result<crate::output::list_platform_versions_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListPlatformVersionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListPlatformVersionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListPlatformVersionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListPlatformVersionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PlatformSummaryList") /* PlatformSummaryList com.amazonaws.elasticbeanstalk.synthetic#ListPlatformVersionsOutput$PlatformSummaryList */ =>  {
                let var_94 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_platform_summary_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_platform_summary_list(var_94);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.elasticbeanstalk.synthetic#ListPlatformVersionsOutput$NextToken */ =>  {
                let var_95 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_95);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListPlatformVersionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_resource_not_found_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::resource_not_found_exception::Builder,
) -> Result<crate::error::resource_not_found_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#ResourceNotFoundException$message */ =>  {
                let var_96 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_96);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_resource_type_not_supported_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::resource_type_not_supported_exception::Builder,
) -> Result<
    crate::error::resource_type_not_supported_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#ResourceTypeNotSupportedException$message */ =>  {
                let var_97 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_97);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_tags_for_resource(
    inp: &[u8],
    mut builder: crate::output::list_tags_for_resource_output::Builder,
) -> Result<crate::output::list_tags_for_resource_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListTagsForResourceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListTagsForResourceResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListTagsForResourceResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListTagsForResourceResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ResourceArn") /* ResourceArn com.amazonaws.elasticbeanstalk.synthetic#ListTagsForResourceOutput$ResourceArn */ =>  {
                let var_98 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_arn(var_98);
            }
            ,
            s if s.matches("ResourceTags") /* ResourceTags com.amazonaws.elasticbeanstalk.synthetic#ListTagsForResourceOutput$ResourceTags */ =>  {
                let var_99 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resource_tags(var_99);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListTagsForResourceResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_retrieve_environment_info(
    inp: &[u8],
    mut builder: crate::output::retrieve_environment_info_output::Builder,
) -> Result<
    crate::output::retrieve_environment_info_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RetrieveEnvironmentInfoResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RetrieveEnvironmentInfoResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("RetrieveEnvironmentInfoResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected RetrieveEnvironmentInfoResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("EnvironmentInfo") /* EnvironmentInfo com.amazonaws.elasticbeanstalk.synthetic#RetrieveEnvironmentInfoOutput$EnvironmentInfo */ =>  {
                let var_100 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_environment_info_description_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_environment_info(var_100);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected RetrieveEnvironmentInfoResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_terminate_environment(
    inp: &[u8],
    mut builder: crate::output::terminate_environment_output::Builder,
) -> Result<crate::output::terminate_environment_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("TerminateEnvironmentResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected TerminateEnvironmentResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("TerminateEnvironmentResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected TerminateEnvironmentResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("EnvironmentName") /* EnvironmentName com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$EnvironmentName */ =>  {
                let var_101 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_name(var_101);
            }
            ,
            s if s.matches("EnvironmentId") /* EnvironmentId com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$EnvironmentId */ =>  {
                let var_102 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_id(var_102);
            }
            ,
            s if s.matches("ApplicationName") /* ApplicationName com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$ApplicationName */ =>  {
                let var_103 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_application_name(var_103);
            }
            ,
            s if s.matches("VersionLabel") /* VersionLabel com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$VersionLabel */ =>  {
                let var_104 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version_label(var_104);
            }
            ,
            s if s.matches("SolutionStackName") /* SolutionStackName com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$SolutionStackName */ =>  {
                let var_105 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_solution_stack_name(var_105);
            }
            ,
            s if s.matches("PlatformArn") /* PlatformArn com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$PlatformArn */ =>  {
                let var_106 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_arn(var_106);
            }
            ,
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$TemplateName */ =>  {
                let var_107 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_107);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$Description */ =>  {
                let var_108 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_108);
            }
            ,
            s if s.matches("EndpointURL") /* EndpointURL com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$EndpointURL */ =>  {
                let var_109 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_endpoint_url(var_109);
            }
            ,
            s if s.matches("CNAME") /* CNAME com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$CNAME */ =>  {
                let var_110 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cname(var_110);
            }
            ,
            s if s.matches("DateCreated") /* DateCreated com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$DateCreated */ =>  {
                let var_111 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_created(var_111);
            }
            ,
            s if s.matches("DateUpdated") /* DateUpdated com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$DateUpdated */ =>  {
                let var_112 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_updated(var_112);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$Status */ =>  {
                let var_113 =
                    Some(
                        Result::<crate::model::EnvironmentStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_113);
            }
            ,
            s if s.matches("AbortableOperationInProgress") /* AbortableOperationInProgress com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$AbortableOperationInProgress */ =>  {
                let var_114 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.elasticbeanstalk#AbortableOperationInProgress`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_abortable_operation_in_progress(var_114);
            }
            ,
            s if s.matches("Health") /* Health com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$Health */ =>  {
                let var_115 =
                    Some(
                        Result::<crate::model::EnvironmentHealth, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentHealth::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_health(var_115);
            }
            ,
            s if s.matches("HealthStatus") /* HealthStatus com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$HealthStatus */ =>  {
                let var_116 =
                    Some(
                        Result::<crate::model::EnvironmentHealthStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentHealthStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_health_status(var_116);
            }
            ,
            s if s.matches("Resources") /* Resources com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$Resources */ =>  {
                let var_117 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_environment_resources_description(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resources(var_117);
            }
            ,
            s if s.matches("Tier") /* Tier com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$Tier */ =>  {
                let var_118 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_environment_tier(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tier(var_118);
            }
            ,
            s if s.matches("EnvironmentLinks") /* EnvironmentLinks com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$EnvironmentLinks */ =>  {
                let var_119 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_environment_links(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_environment_links(var_119);
            }
            ,
            s if s.matches("EnvironmentArn") /* EnvironmentArn com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$EnvironmentArn */ =>  {
                let var_120 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_arn(var_120);
            }
            ,
            s if s.matches("OperationsRole") /* OperationsRole com.amazonaws.elasticbeanstalk.synthetic#TerminateEnvironmentOutput$OperationsRole */ =>  {
                let var_121 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_operations_role(var_121);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected TerminateEnvironmentResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_application(
    inp: &[u8],
    mut builder: crate::output::update_application_output::Builder,
) -> Result<crate::output::update_application_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateApplicationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateApplicationResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UpdateApplicationResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UpdateApplicationResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Application") /* Application com.amazonaws.elasticbeanstalk.synthetic#UpdateApplicationOutput$Application */ =>  {
                let var_122 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_application_description(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_application(var_122);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UpdateApplicationResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_application_resource_lifecycle(
    inp: &[u8],
    mut builder: crate::output::update_application_resource_lifecycle_output::Builder,
) -> Result<
    crate::output::update_application_resource_lifecycle_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateApplicationResourceLifecycleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateApplicationResourceLifecycleResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UpdateApplicationResourceLifecycleResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UpdateApplicationResourceLifecycleResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ApplicationName") /* ApplicationName com.amazonaws.elasticbeanstalk.synthetic#UpdateApplicationResourceLifecycleOutput$ApplicationName */ =>  {
                let var_123 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_application_name(var_123);
            }
            ,
            s if s.matches("ResourceLifecycleConfig") /* ResourceLifecycleConfig com.amazonaws.elasticbeanstalk.synthetic#UpdateApplicationResourceLifecycleOutput$ResourceLifecycleConfig */ =>  {
                let var_124 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_application_resource_lifecycle_config(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resource_lifecycle_config(var_124);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UpdateApplicationResourceLifecycleResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_application_version(
    inp: &[u8],
    mut builder: crate::output::update_application_version_output::Builder,
) -> Result<
    crate::output::update_application_version_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateApplicationVersionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateApplicationVersionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UpdateApplicationVersionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UpdateApplicationVersionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ApplicationVersion") /* ApplicationVersion com.amazonaws.elasticbeanstalk.synthetic#UpdateApplicationVersionOutput$ApplicationVersion */ =>  {
                let var_125 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_application_version_description(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_application_version(var_125);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UpdateApplicationVersionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_configuration_template(
    inp: &[u8],
    mut builder: crate::output::update_configuration_template_output::Builder,
) -> Result<
    crate::output::update_configuration_template_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateConfigurationTemplateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateConfigurationTemplateResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UpdateConfigurationTemplateResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UpdateConfigurationTemplateResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SolutionStackName") /* SolutionStackName com.amazonaws.elasticbeanstalk.synthetic#UpdateConfigurationTemplateOutput$SolutionStackName */ =>  {
                let var_126 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_solution_stack_name(var_126);
            }
            ,
            s if s.matches("PlatformArn") /* PlatformArn com.amazonaws.elasticbeanstalk.synthetic#UpdateConfigurationTemplateOutput$PlatformArn */ =>  {
                let var_127 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_arn(var_127);
            }
            ,
            s if s.matches("ApplicationName") /* ApplicationName com.amazonaws.elasticbeanstalk.synthetic#UpdateConfigurationTemplateOutput$ApplicationName */ =>  {
                let var_128 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_application_name(var_128);
            }
            ,
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.elasticbeanstalk.synthetic#UpdateConfigurationTemplateOutput$TemplateName */ =>  {
                let var_129 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_129);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.elasticbeanstalk.synthetic#UpdateConfigurationTemplateOutput$Description */ =>  {
                let var_130 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_130);
            }
            ,
            s if s.matches("EnvironmentName") /* EnvironmentName com.amazonaws.elasticbeanstalk.synthetic#UpdateConfigurationTemplateOutput$EnvironmentName */ =>  {
                let var_131 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_name(var_131);
            }
            ,
            s if s.matches("DeploymentStatus") /* DeploymentStatus com.amazonaws.elasticbeanstalk.synthetic#UpdateConfigurationTemplateOutput$DeploymentStatus */ =>  {
                let var_132 =
                    Some(
                        Result::<crate::model::ConfigurationDeploymentStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ConfigurationDeploymentStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_deployment_status(var_132);
            }
            ,
            s if s.matches("DateCreated") /* DateCreated com.amazonaws.elasticbeanstalk.synthetic#UpdateConfigurationTemplateOutput$DateCreated */ =>  {
                let var_133 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_created(var_133);
            }
            ,
            s if s.matches("DateUpdated") /* DateUpdated com.amazonaws.elasticbeanstalk.synthetic#UpdateConfigurationTemplateOutput$DateUpdated */ =>  {
                let var_134 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_updated(var_134);
            }
            ,
            s if s.matches("OptionSettings") /* OptionSettings com.amazonaws.elasticbeanstalk.synthetic#UpdateConfigurationTemplateOutput$OptionSettings */ =>  {
                let var_135 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_configuration_option_settings_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_option_settings(var_135);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UpdateConfigurationTemplateResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_environment(
    inp: &[u8],
    mut builder: crate::output::update_environment_output::Builder,
) -> Result<crate::output::update_environment_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateEnvironmentResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateEnvironmentResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UpdateEnvironmentResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UpdateEnvironmentResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("EnvironmentName") /* EnvironmentName com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$EnvironmentName */ =>  {
                let var_136 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_name(var_136);
            }
            ,
            s if s.matches("EnvironmentId") /* EnvironmentId com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$EnvironmentId */ =>  {
                let var_137 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_id(var_137);
            }
            ,
            s if s.matches("ApplicationName") /* ApplicationName com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$ApplicationName */ =>  {
                let var_138 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_application_name(var_138);
            }
            ,
            s if s.matches("VersionLabel") /* VersionLabel com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$VersionLabel */ =>  {
                let var_139 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version_label(var_139);
            }
            ,
            s if s.matches("SolutionStackName") /* SolutionStackName com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$SolutionStackName */ =>  {
                let var_140 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_solution_stack_name(var_140);
            }
            ,
            s if s.matches("PlatformArn") /* PlatformArn com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$PlatformArn */ =>  {
                let var_141 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_arn(var_141);
            }
            ,
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$TemplateName */ =>  {
                let var_142 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_142);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$Description */ =>  {
                let var_143 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_143);
            }
            ,
            s if s.matches("EndpointURL") /* EndpointURL com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$EndpointURL */ =>  {
                let var_144 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_endpoint_url(var_144);
            }
            ,
            s if s.matches("CNAME") /* CNAME com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$CNAME */ =>  {
                let var_145 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cname(var_145);
            }
            ,
            s if s.matches("DateCreated") /* DateCreated com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$DateCreated */ =>  {
                let var_146 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_created(var_146);
            }
            ,
            s if s.matches("DateUpdated") /* DateUpdated com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$DateUpdated */ =>  {
                let var_147 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_updated(var_147);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$Status */ =>  {
                let var_148 =
                    Some(
                        Result::<crate::model::EnvironmentStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_148);
            }
            ,
            s if s.matches("AbortableOperationInProgress") /* AbortableOperationInProgress com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$AbortableOperationInProgress */ =>  {
                let var_149 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.elasticbeanstalk#AbortableOperationInProgress`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_abortable_operation_in_progress(var_149);
            }
            ,
            s if s.matches("Health") /* Health com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$Health */ =>  {
                let var_150 =
                    Some(
                        Result::<crate::model::EnvironmentHealth, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentHealth::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_health(var_150);
            }
            ,
            s if s.matches("HealthStatus") /* HealthStatus com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$HealthStatus */ =>  {
                let var_151 =
                    Some(
                        Result::<crate::model::EnvironmentHealthStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentHealthStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_health_status(var_151);
            }
            ,
            s if s.matches("Resources") /* Resources com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$Resources */ =>  {
                let var_152 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_environment_resources_description(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resources(var_152);
            }
            ,
            s if s.matches("Tier") /* Tier com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$Tier */ =>  {
                let var_153 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_environment_tier(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tier(var_153);
            }
            ,
            s if s.matches("EnvironmentLinks") /* EnvironmentLinks com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$EnvironmentLinks */ =>  {
                let var_154 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_environment_links(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_environment_links(var_154);
            }
            ,
            s if s.matches("EnvironmentArn") /* EnvironmentArn com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$EnvironmentArn */ =>  {
                let var_155 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_arn(var_155);
            }
            ,
            s if s.matches("OperationsRole") /* OperationsRole com.amazonaws.elasticbeanstalk.synthetic#UpdateEnvironmentOutput$OperationsRole */ =>  {
                let var_156 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_operations_role(var_156);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UpdateEnvironmentResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_too_many_tags_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::too_many_tags_exception::Builder,
) -> Result<crate::error::too_many_tags_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.elasticbeanstalk#TooManyTagsException$message */ =>  {
                let var_157 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_157);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_validate_configuration_settings(
    inp: &[u8],
    mut builder: crate::output::validate_configuration_settings_output::Builder,
) -> Result<
    crate::output::validate_configuration_settings_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ValidateConfigurationSettingsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ValidateConfigurationSettingsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ValidateConfigurationSettingsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ValidateConfigurationSettingsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Messages") /* Messages com.amazonaws.elasticbeanstalk.synthetic#ValidateConfigurationSettingsOutput$Messages */ =>  {
                let var_158 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_validation_messages_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_messages(var_158);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ValidateConfigurationSettingsResult tag",
        ));
    };
    Ok(builder)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_environment_descriptions_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::EnvironmentDescription>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#EnvironmentDescriptionsList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_environment_description(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_application_description(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ApplicationDescription, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ApplicationDescription::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ApplicationArn") /* ApplicationArn com.amazonaws.elasticbeanstalk#ApplicationDescription$ApplicationArn */ =>  {
                let var_159 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_application_arn(var_159);
            }
            ,
            s if s.matches("ApplicationName") /* ApplicationName com.amazonaws.elasticbeanstalk#ApplicationDescription$ApplicationName */ =>  {
                let var_160 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_application_name(var_160);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.elasticbeanstalk#ApplicationDescription$Description */ =>  {
                let var_161 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_161);
            }
            ,
            s if s.matches("DateCreated") /* DateCreated com.amazonaws.elasticbeanstalk#ApplicationDescription$DateCreated */ =>  {
                let var_162 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_created(var_162);
            }
            ,
            s if s.matches("DateUpdated") /* DateUpdated com.amazonaws.elasticbeanstalk#ApplicationDescription$DateUpdated */ =>  {
                let var_163 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_updated(var_163);
            }
            ,
            s if s.matches("Versions") /* Versions com.amazonaws.elasticbeanstalk#ApplicationDescription$Versions */ =>  {
                let var_164 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_version_labels_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_versions(var_164);
            }
            ,
            s if s.matches("ConfigurationTemplates") /* ConfigurationTemplates com.amazonaws.elasticbeanstalk#ApplicationDescription$ConfigurationTemplates */ =>  {
                let var_165 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_configuration_template_names_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_configuration_templates(var_165);
            }
            ,
            s if s.matches("ResourceLifecycleConfig") /* ResourceLifecycleConfig com.amazonaws.elasticbeanstalk#ApplicationDescription$ResourceLifecycleConfig */ =>  {
                let var_166 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_application_resource_lifecycle_config(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resource_lifecycle_config(var_166);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_application_version_description(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ApplicationVersionDescription, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ApplicationVersionDescription::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ApplicationVersionArn") /* ApplicationVersionArn com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$ApplicationVersionArn */ =>  {
                let var_167 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_application_version_arn(var_167);
            }
            ,
            s if s.matches("ApplicationName") /* ApplicationName com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$ApplicationName */ =>  {
                let var_168 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_application_name(var_168);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$Description */ =>  {
                let var_169 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_169);
            }
            ,
            s if s.matches("VersionLabel") /* VersionLabel com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$VersionLabel */ =>  {
                let var_170 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version_label(var_170);
            }
            ,
            s if s.matches("SourceBuildInformation") /* SourceBuildInformation com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$SourceBuildInformation */ =>  {
                let var_171 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_source_build_information(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_source_build_information(var_171);
            }
            ,
            s if s.matches("BuildArn") /* BuildArn com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$BuildArn */ =>  {
                let var_172 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_build_arn(var_172);
            }
            ,
            s if s.matches("SourceBundle") /* SourceBundle com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$SourceBundle */ =>  {
                let var_173 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_location(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_source_bundle(var_173);
            }
            ,
            s if s.matches("DateCreated") /* DateCreated com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$DateCreated */ =>  {
                let var_174 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_created(var_174);
            }
            ,
            s if s.matches("DateUpdated") /* DateUpdated com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$DateUpdated */ =>  {
                let var_175 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_updated(var_175);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$Status */ =>  {
                let var_176 =
                    Some(
                        Result::<crate::model::ApplicationVersionStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ApplicationVersionStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_176);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_configuration_option_settings_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ConfigurationOptionSetting>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#ConfigurationOptionSettingsList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_configuration_option_setting(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_environment_resources_description(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EnvironmentResourcesDescription, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EnvironmentResourcesDescription::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("LoadBalancer") /* LoadBalancer com.amazonaws.elasticbeanstalk#EnvironmentResourcesDescription$LoadBalancer */ =>  {
                let var_177 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_load_balancer_description(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_load_balancer(var_177);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_environment_tier(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EnvironmentTier, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EnvironmentTier::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.elasticbeanstalk#EnvironmentTier$Name */ =>  {
                let var_178 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_178);
            }
            ,
            s if s.matches("Type") /* Type com.amazonaws.elasticbeanstalk#EnvironmentTier$Type */ =>  {
                let var_179 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_type(var_179);
            }
            ,
            s if s.matches("Version") /* Version com.amazonaws.elasticbeanstalk#EnvironmentTier$Version */ =>  {
                let var_180 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version(var_180);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_environment_links(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::EnvironmentLink>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#EnvironmentLinks$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_environment_link(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_platform_summary(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PlatformSummary, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PlatformSummary::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PlatformArn") /* PlatformArn com.amazonaws.elasticbeanstalk#PlatformSummary$PlatformArn */ =>  {
                let var_181 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_arn(var_181);
            }
            ,
            s if s.matches("PlatformOwner") /* PlatformOwner com.amazonaws.elasticbeanstalk#PlatformSummary$PlatformOwner */ =>  {
                let var_182 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_owner(var_182);
            }
            ,
            s if s.matches("PlatformStatus") /* PlatformStatus com.amazonaws.elasticbeanstalk#PlatformSummary$PlatformStatus */ =>  {
                let var_183 =
                    Some(
                        Result::<crate::model::PlatformStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::PlatformStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_status(var_183);
            }
            ,
            s if s.matches("PlatformCategory") /* PlatformCategory com.amazonaws.elasticbeanstalk#PlatformSummary$PlatformCategory */ =>  {
                let var_184 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_category(var_184);
            }
            ,
            s if s.matches("OperatingSystemName") /* OperatingSystemName com.amazonaws.elasticbeanstalk#PlatformSummary$OperatingSystemName */ =>  {
                let var_185 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_operating_system_name(var_185);
            }
            ,
            s if s.matches("OperatingSystemVersion") /* OperatingSystemVersion com.amazonaws.elasticbeanstalk#PlatformSummary$OperatingSystemVersion */ =>  {
                let var_186 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_operating_system_version(var_186);
            }
            ,
            s if s.matches("SupportedTierList") /* SupportedTierList com.amazonaws.elasticbeanstalk#PlatformSummary$SupportedTierList */ =>  {
                let var_187 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_supported_tier_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_supported_tier_list(var_187);
            }
            ,
            s if s.matches("SupportedAddonList") /* SupportedAddonList com.amazonaws.elasticbeanstalk#PlatformSummary$SupportedAddonList */ =>  {
                let var_188 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_supported_addon_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_supported_addon_list(var_188);
            }
            ,
            s if s.matches("PlatformLifecycleState") /* PlatformLifecycleState com.amazonaws.elasticbeanstalk#PlatformSummary$PlatformLifecycleState */ =>  {
                let var_189 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_lifecycle_state(var_189);
            }
            ,
            s if s.matches("PlatformVersion") /* PlatformVersion com.amazonaws.elasticbeanstalk#PlatformSummary$PlatformVersion */ =>  {
                let var_190 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_version(var_190);
            }
            ,
            s if s.matches("PlatformBranchName") /* PlatformBranchName com.amazonaws.elasticbeanstalk#PlatformSummary$PlatformBranchName */ =>  {
                let var_191 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_branch_name(var_191);
            }
            ,
            s if s.matches("PlatformBranchLifecycleState") /* PlatformBranchLifecycleState com.amazonaws.elasticbeanstalk#PlatformSummary$PlatformBranchLifecycleState */ =>  {
                let var_192 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_branch_lifecycle_state(var_192);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_builder(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Builder, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Builder::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ARN") /* ARN com.amazonaws.elasticbeanstalk#Builder$ARN */ =>  {
                let var_193 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_193);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_resource_quotas(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ResourceQuotas, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ResourceQuotas::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ApplicationQuota") /* ApplicationQuota com.amazonaws.elasticbeanstalk#ResourceQuotas$ApplicationQuota */ =>  {
                let var_194 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_resource_quota(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_application_quota(var_194);
            }
            ,
            s if s.matches("ApplicationVersionQuota") /* ApplicationVersionQuota com.amazonaws.elasticbeanstalk#ResourceQuotas$ApplicationVersionQuota */ =>  {
                let var_195 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_resource_quota(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_application_version_quota(var_195);
            }
            ,
            s if s.matches("EnvironmentQuota") /* EnvironmentQuota com.amazonaws.elasticbeanstalk#ResourceQuotas$EnvironmentQuota */ =>  {
                let var_196 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_resource_quota(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_environment_quota(var_196);
            }
            ,
            s if s.matches("ConfigurationTemplateQuota") /* ConfigurationTemplateQuota com.amazonaws.elasticbeanstalk#ResourceQuotas$ConfigurationTemplateQuota */ =>  {
                let var_197 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_resource_quota(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_configuration_template_quota(var_197);
            }
            ,
            s if s.matches("CustomPlatformQuota") /* CustomPlatformQuota com.amazonaws.elasticbeanstalk#ResourceQuotas$CustomPlatformQuota */ =>  {
                let var_198 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_resource_quota(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_custom_platform_quota(var_198);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_application_description_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ApplicationDescription>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#ApplicationDescriptionList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_application_description(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_application_version_description_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::ApplicationVersionDescription>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#ApplicationVersionDescriptionList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_application_version_description(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_configuration_option_descriptions_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::ConfigurationOptionDescription>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#ConfigurationOptionDescriptionsList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_configuration_option_description(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_configuration_settings_description_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::ConfigurationSettingsDescription>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescriptionList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_configuration_settings_description(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_causes(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#Causes$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_application_metrics(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ApplicationMetrics, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ApplicationMetrics::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Duration") /* Duration com.amazonaws.elasticbeanstalk#ApplicationMetrics$Duration */ =>  {
                let var_199 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#NullableInteger`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_duration(var_199);
            }
            ,
            s if s.matches("RequestCount") /* RequestCount com.amazonaws.elasticbeanstalk#ApplicationMetrics$RequestCount */ =>  {
                let var_200 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#RequestCount`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_request_count(var_200);
            }
            ,
            s if s.matches("StatusCodes") /* StatusCodes com.amazonaws.elasticbeanstalk#ApplicationMetrics$StatusCodes */ =>  {
                let var_201 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_status_codes(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status_codes(var_201);
            }
            ,
            s if s.matches("Latency") /* Latency com.amazonaws.elasticbeanstalk#ApplicationMetrics$Latency */ =>  {
                let var_202 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_latency(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_latency(var_202);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_instance_health_summary(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::InstanceHealthSummary, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::InstanceHealthSummary::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NoData") /* NoData com.amazonaws.elasticbeanstalk#InstanceHealthSummary$NoData */ =>  {
                let var_203 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#NullableInteger`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_no_data(var_203);
            }
            ,
            s if s.matches("Unknown") /* Unknown com.amazonaws.elasticbeanstalk#InstanceHealthSummary$Unknown */ =>  {
                let var_204 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#NullableInteger`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_unknown(var_204);
            }
            ,
            s if s.matches("Pending") /* Pending com.amazonaws.elasticbeanstalk#InstanceHealthSummary$Pending */ =>  {
                let var_205 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#NullableInteger`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_pending(var_205);
            }
            ,
            s if s.matches("Ok") /* Ok com.amazonaws.elasticbeanstalk#InstanceHealthSummary$Ok */ =>  {
                let var_206 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#NullableInteger`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_ok(var_206);
            }
            ,
            s if s.matches("Info") /* Info com.amazonaws.elasticbeanstalk#InstanceHealthSummary$Info */ =>  {
                let var_207 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#NullableInteger`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_info(var_207);
            }
            ,
            s if s.matches("Warning") /* Warning com.amazonaws.elasticbeanstalk#InstanceHealthSummary$Warning */ =>  {
                let var_208 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#NullableInteger`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_warning(var_208);
            }
            ,
            s if s.matches("Degraded") /* Degraded com.amazonaws.elasticbeanstalk#InstanceHealthSummary$Degraded */ =>  {
                let var_209 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#NullableInteger`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_degraded(var_209);
            }
            ,
            s if s.matches("Severe") /* Severe com.amazonaws.elasticbeanstalk#InstanceHealthSummary$Severe */ =>  {
                let var_210 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#NullableInteger`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_severe(var_210);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_managed_action_history_items(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ManagedActionHistoryItem>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#ManagedActionHistoryItems$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_managed_action_history_item(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_managed_actions(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ManagedAction>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#ManagedActions$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_managed_action(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_environment_resource_description(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EnvironmentResourceDescription, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EnvironmentResourceDescription::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EnvironmentName") /* EnvironmentName com.amazonaws.elasticbeanstalk#EnvironmentResourceDescription$EnvironmentName */ =>  {
                let var_211 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_name(var_211);
            }
            ,
            s if s.matches("AutoScalingGroups") /* AutoScalingGroups com.amazonaws.elasticbeanstalk#EnvironmentResourceDescription$AutoScalingGroups */ =>  {
                let var_212 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_auto_scaling_group_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_auto_scaling_groups(var_212);
            }
            ,
            s if s.matches("Instances") /* Instances com.amazonaws.elasticbeanstalk#EnvironmentResourceDescription$Instances */ =>  {
                let var_213 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_instance_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instances(var_213);
            }
            ,
            s if s.matches("LaunchConfigurations") /* LaunchConfigurations com.amazonaws.elasticbeanstalk#EnvironmentResourceDescription$LaunchConfigurations */ =>  {
                let var_214 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_launch_configuration_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_launch_configurations(var_214);
            }
            ,
            s if s.matches("LaunchTemplates") /* LaunchTemplates com.amazonaws.elasticbeanstalk#EnvironmentResourceDescription$LaunchTemplates */ =>  {
                let var_215 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_launch_template_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_launch_templates(var_215);
            }
            ,
            s if s.matches("LoadBalancers") /* LoadBalancers com.amazonaws.elasticbeanstalk#EnvironmentResourceDescription$LoadBalancers */ =>  {
                let var_216 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_load_balancer_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_load_balancers(var_216);
            }
            ,
            s if s.matches("Triggers") /* Triggers com.amazonaws.elasticbeanstalk#EnvironmentResourceDescription$Triggers */ =>  {
                let var_217 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_trigger_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_triggers(var_217);
            }
            ,
            s if s.matches("Queues") /* Queues com.amazonaws.elasticbeanstalk#EnvironmentResourceDescription$Queues */ =>  {
                let var_218 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_queue_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_queues(var_218);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_event_description_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::EventDescription>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#EventDescriptionList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_event_description(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_instance_health_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SingleInstanceHealth>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#InstanceHealthList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_single_instance_health(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_platform_description(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PlatformDescription, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PlatformDescription::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PlatformArn") /* PlatformArn com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformArn */ =>  {
                let var_219 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_arn(var_219);
            }
            ,
            s if s.matches("PlatformOwner") /* PlatformOwner com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformOwner */ =>  {
                let var_220 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_owner(var_220);
            }
            ,
            s if s.matches("PlatformName") /* PlatformName com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformName */ =>  {
                let var_221 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_name(var_221);
            }
            ,
            s if s.matches("PlatformVersion") /* PlatformVersion com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformVersion */ =>  {
                let var_222 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_version(var_222);
            }
            ,
            s if s.matches("SolutionStackName") /* SolutionStackName com.amazonaws.elasticbeanstalk#PlatformDescription$SolutionStackName */ =>  {
                let var_223 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_solution_stack_name(var_223);
            }
            ,
            s if s.matches("PlatformStatus") /* PlatformStatus com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformStatus */ =>  {
                let var_224 =
                    Some(
                        Result::<crate::model::PlatformStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::PlatformStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_status(var_224);
            }
            ,
            s if s.matches("DateCreated") /* DateCreated com.amazonaws.elasticbeanstalk#PlatformDescription$DateCreated */ =>  {
                let var_225 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_created(var_225);
            }
            ,
            s if s.matches("DateUpdated") /* DateUpdated com.amazonaws.elasticbeanstalk#PlatformDescription$DateUpdated */ =>  {
                let var_226 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_updated(var_226);
            }
            ,
            s if s.matches("PlatformCategory") /* PlatformCategory com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformCategory */ =>  {
                let var_227 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_category(var_227);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.elasticbeanstalk#PlatformDescription$Description */ =>  {
                let var_228 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_228);
            }
            ,
            s if s.matches("Maintainer") /* Maintainer com.amazonaws.elasticbeanstalk#PlatformDescription$Maintainer */ =>  {
                let var_229 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_maintainer(var_229);
            }
            ,
            s if s.matches("OperatingSystemName") /* OperatingSystemName com.amazonaws.elasticbeanstalk#PlatformDescription$OperatingSystemName */ =>  {
                let var_230 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_operating_system_name(var_230);
            }
            ,
            s if s.matches("OperatingSystemVersion") /* OperatingSystemVersion com.amazonaws.elasticbeanstalk#PlatformDescription$OperatingSystemVersion */ =>  {
                let var_231 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_operating_system_version(var_231);
            }
            ,
            s if s.matches("ProgrammingLanguages") /* ProgrammingLanguages com.amazonaws.elasticbeanstalk#PlatformDescription$ProgrammingLanguages */ =>  {
                let var_232 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_platform_programming_languages(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_programming_languages(var_232);
            }
            ,
            s if s.matches("Frameworks") /* Frameworks com.amazonaws.elasticbeanstalk#PlatformDescription$Frameworks */ =>  {
                let var_233 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_platform_frameworks(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_frameworks(var_233);
            }
            ,
            s if s.matches("CustomAmiList") /* CustomAmiList com.amazonaws.elasticbeanstalk#PlatformDescription$CustomAmiList */ =>  {
                let var_234 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_custom_ami_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_custom_ami_list(var_234);
            }
            ,
            s if s.matches("SupportedTierList") /* SupportedTierList com.amazonaws.elasticbeanstalk#PlatformDescription$SupportedTierList */ =>  {
                let var_235 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_supported_tier_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_supported_tier_list(var_235);
            }
            ,
            s if s.matches("SupportedAddonList") /* SupportedAddonList com.amazonaws.elasticbeanstalk#PlatformDescription$SupportedAddonList */ =>  {
                let var_236 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_supported_addon_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_supported_addon_list(var_236);
            }
            ,
            s if s.matches("PlatformLifecycleState") /* PlatformLifecycleState com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformLifecycleState */ =>  {
                let var_237 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_lifecycle_state(var_237);
            }
            ,
            s if s.matches("PlatformBranchName") /* PlatformBranchName com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformBranchName */ =>  {
                let var_238 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_branch_name(var_238);
            }
            ,
            s if s.matches("PlatformBranchLifecycleState") /* PlatformBranchLifecycleState com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformBranchLifecycleState */ =>  {
                let var_239 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_branch_lifecycle_state(var_239);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_available_solution_stack_names_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#AvailableSolutionStackNamesList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_available_solution_stack_details_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SolutionStackDescription>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#AvailableSolutionStackDetailsList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_solution_stack_description(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_platform_branch_summary_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::PlatformBranchSummary>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#PlatformBranchSummaryList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_platform_branch_summary(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_platform_summary_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::PlatformSummary>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#PlatformSummaryList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_platform_summary(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_tag_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Tag>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#TagList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_environment_info_description_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::EnvironmentInfoDescription>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#EnvironmentInfoDescriptionList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_environment_info_description(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_application_resource_lifecycle_config(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ApplicationResourceLifecycleConfig, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ApplicationResourceLifecycleConfig::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ServiceRole") /* ServiceRole com.amazonaws.elasticbeanstalk#ApplicationResourceLifecycleConfig$ServiceRole */ =>  {
                let var_240 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_role(var_240);
            }
            ,
            s if s.matches("VersionLifecycleConfig") /* VersionLifecycleConfig com.amazonaws.elasticbeanstalk#ApplicationResourceLifecycleConfig$VersionLifecycleConfig */ =>  {
                let var_241 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_application_version_lifecycle_config(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_version_lifecycle_config(var_241);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_validation_messages_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ValidationMessage>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#ValidationMessagesList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_validation_message(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_environment_description(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EnvironmentDescription, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EnvironmentDescription::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EnvironmentName") /* EnvironmentName com.amazonaws.elasticbeanstalk#EnvironmentDescription$EnvironmentName */ =>  {
                let var_242 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_name(var_242);
            }
            ,
            s if s.matches("EnvironmentId") /* EnvironmentId com.amazonaws.elasticbeanstalk#EnvironmentDescription$EnvironmentId */ =>  {
                let var_243 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_id(var_243);
            }
            ,
            s if s.matches("ApplicationName") /* ApplicationName com.amazonaws.elasticbeanstalk#EnvironmentDescription$ApplicationName */ =>  {
                let var_244 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_application_name(var_244);
            }
            ,
            s if s.matches("VersionLabel") /* VersionLabel com.amazonaws.elasticbeanstalk#EnvironmentDescription$VersionLabel */ =>  {
                let var_245 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version_label(var_245);
            }
            ,
            s if s.matches("SolutionStackName") /* SolutionStackName com.amazonaws.elasticbeanstalk#EnvironmentDescription$SolutionStackName */ =>  {
                let var_246 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_solution_stack_name(var_246);
            }
            ,
            s if s.matches("PlatformArn") /* PlatformArn com.amazonaws.elasticbeanstalk#EnvironmentDescription$PlatformArn */ =>  {
                let var_247 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_arn(var_247);
            }
            ,
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.elasticbeanstalk#EnvironmentDescription$TemplateName */ =>  {
                let var_248 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_248);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.elasticbeanstalk#EnvironmentDescription$Description */ =>  {
                let var_249 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_249);
            }
            ,
            s if s.matches("EndpointURL") /* EndpointURL com.amazonaws.elasticbeanstalk#EnvironmentDescription$EndpointURL */ =>  {
                let var_250 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_endpoint_url(var_250);
            }
            ,
            s if s.matches("CNAME") /* CNAME com.amazonaws.elasticbeanstalk#EnvironmentDescription$CNAME */ =>  {
                let var_251 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cname(var_251);
            }
            ,
            s if s.matches("DateCreated") /* DateCreated com.amazonaws.elasticbeanstalk#EnvironmentDescription$DateCreated */ =>  {
                let var_252 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_created(var_252);
            }
            ,
            s if s.matches("DateUpdated") /* DateUpdated com.amazonaws.elasticbeanstalk#EnvironmentDescription$DateUpdated */ =>  {
                let var_253 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_updated(var_253);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.elasticbeanstalk#EnvironmentDescription$Status */ =>  {
                let var_254 =
                    Some(
                        Result::<crate::model::EnvironmentStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_254);
            }
            ,
            s if s.matches("AbortableOperationInProgress") /* AbortableOperationInProgress com.amazonaws.elasticbeanstalk#EnvironmentDescription$AbortableOperationInProgress */ =>  {
                let var_255 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.elasticbeanstalk#AbortableOperationInProgress`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_abortable_operation_in_progress(var_255);
            }
            ,
            s if s.matches("Health") /* Health com.amazonaws.elasticbeanstalk#EnvironmentDescription$Health */ =>  {
                let var_256 =
                    Some(
                        Result::<crate::model::EnvironmentHealth, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentHealth::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_health(var_256);
            }
            ,
            s if s.matches("HealthStatus") /* HealthStatus com.amazonaws.elasticbeanstalk#EnvironmentDescription$HealthStatus */ =>  {
                let var_257 =
                    Some(
                        Result::<crate::model::EnvironmentHealthStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentHealthStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_health_status(var_257);
            }
            ,
            s if s.matches("Resources") /* Resources com.amazonaws.elasticbeanstalk#EnvironmentDescription$Resources */ =>  {
                let var_258 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_environment_resources_description(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resources(var_258);
            }
            ,
            s if s.matches("Tier") /* Tier com.amazonaws.elasticbeanstalk#EnvironmentDescription$Tier */ =>  {
                let var_259 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_environment_tier(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tier(var_259);
            }
            ,
            s if s.matches("EnvironmentLinks") /* EnvironmentLinks com.amazonaws.elasticbeanstalk#EnvironmentDescription$EnvironmentLinks */ =>  {
                let var_260 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_environment_links(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_environment_links(var_260);
            }
            ,
            s if s.matches("EnvironmentArn") /* EnvironmentArn com.amazonaws.elasticbeanstalk#EnvironmentDescription$EnvironmentArn */ =>  {
                let var_261 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_arn(var_261);
            }
            ,
            s if s.matches("OperationsRole") /* OperationsRole com.amazonaws.elasticbeanstalk#EnvironmentDescription$OperationsRole */ =>  {
                let var_262 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_operations_role(var_262);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_version_labels_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#VersionLabelsList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_configuration_template_names_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#ConfigurationTemplateNamesList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_source_build_information(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SourceBuildInformation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SourceBuildInformation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SourceType") /* SourceType com.amazonaws.elasticbeanstalk#SourceBuildInformation$SourceType */ =>  {
                let var_263 =
                    Some(
                        Result::<crate::model::SourceType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::SourceType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_source_type(var_263);
            }
            ,
            s if s.matches("SourceRepository") /* SourceRepository com.amazonaws.elasticbeanstalk#SourceBuildInformation$SourceRepository */ =>  {
                let var_264 =
                    Some(
                        Result::<crate::model::SourceRepository, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::SourceRepository::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_source_repository(var_264);
            }
            ,
            s if s.matches("SourceLocation") /* SourceLocation com.amazonaws.elasticbeanstalk#SourceBuildInformation$SourceLocation */ =>  {
                let var_265 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_location(var_265);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_location(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3Location, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3Location::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("S3Bucket") /* S3Bucket com.amazonaws.elasticbeanstalk#S3Location$S3Bucket */ =>  {
                let var_266 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_s3_bucket(var_266);
            }
            ,
            s if s.matches("S3Key") /* S3Key com.amazonaws.elasticbeanstalk#S3Location$S3Key */ =>  {
                let var_267 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_s3_key(var_267);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_configuration_option_setting(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ConfigurationOptionSetting, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ConfigurationOptionSetting::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ResourceName") /* ResourceName com.amazonaws.elasticbeanstalk#ConfigurationOptionSetting$ResourceName */ =>  {
                let var_268 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_name(var_268);
            }
            ,
            s if s.matches("Namespace") /* Namespace com.amazonaws.elasticbeanstalk#ConfigurationOptionSetting$Namespace */ =>  {
                let var_269 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_namespace(var_269);
            }
            ,
            s if s.matches("OptionName") /* OptionName com.amazonaws.elasticbeanstalk#ConfigurationOptionSetting$OptionName */ =>  {
                let var_270 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_option_name(var_270);
            }
            ,
            s if s.matches("Value") /* Value com.amazonaws.elasticbeanstalk#ConfigurationOptionSetting$Value */ =>  {
                let var_271 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_value(var_271);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_load_balancer_description(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LoadBalancerDescription, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LoadBalancerDescription::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("LoadBalancerName") /* LoadBalancerName com.amazonaws.elasticbeanstalk#LoadBalancerDescription$LoadBalancerName */ =>  {
                let var_272 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_load_balancer_name(var_272);
            }
            ,
            s if s.matches("Domain") /* Domain com.amazonaws.elasticbeanstalk#LoadBalancerDescription$Domain */ =>  {
                let var_273 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_domain(var_273);
            }
            ,
            s if s.matches("Listeners") /* Listeners com.amazonaws.elasticbeanstalk#LoadBalancerDescription$Listeners */ =>  {
                let var_274 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_load_balancer_listeners_description(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_listeners(var_274);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_environment_link(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EnvironmentLink, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EnvironmentLink::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("LinkName") /* LinkName com.amazonaws.elasticbeanstalk#EnvironmentLink$LinkName */ =>  {
                let var_275 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_link_name(var_275);
            }
            ,
            s if s.matches("EnvironmentName") /* EnvironmentName com.amazonaws.elasticbeanstalk#EnvironmentLink$EnvironmentName */ =>  {
                let var_276 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_name(var_276);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_supported_tier_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#SupportedTierList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_supported_addon_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#SupportedAddonList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_resource_quota(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ResourceQuota, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ResourceQuota::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Maximum") /* Maximum com.amazonaws.elasticbeanstalk#ResourceQuota$Maximum */ =>  {
                let var_277 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#BoxedInt`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_maximum(var_277);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_configuration_option_description(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ConfigurationOptionDescription, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ConfigurationOptionDescription::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Namespace") /* Namespace com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$Namespace */ =>  {
                let var_278 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_namespace(var_278);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$Name */ =>  {
                let var_279 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_279);
            }
            ,
            s if s.matches("DefaultValue") /* DefaultValue com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$DefaultValue */ =>  {
                let var_280 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_default_value(var_280);
            }
            ,
            s if s.matches("ChangeSeverity") /* ChangeSeverity com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$ChangeSeverity */ =>  {
                let var_281 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_change_severity(var_281);
            }
            ,
            s if s.matches("UserDefined") /* UserDefined com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$UserDefined */ =>  {
                let var_282 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.elasticbeanstalk#UserDefinedOption`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_user_defined(var_282);
            }
            ,
            s if s.matches("ValueType") /* ValueType com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$ValueType */ =>  {
                let var_283 =
                    Some(
                        Result::<crate::model::ConfigurationOptionValueType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ConfigurationOptionValueType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_value_type(var_283);
            }
            ,
            s if s.matches("ValueOptions") /* ValueOptions com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$ValueOptions */ =>  {
                let var_284 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_configuration_option_possible_values(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_value_options(var_284);
            }
            ,
            s if s.matches("MinValue") /* MinValue com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$MinValue */ =>  {
                let var_285 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#OptionRestrictionMinValue`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_min_value(var_285);
            }
            ,
            s if s.matches("MaxValue") /* MaxValue com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$MaxValue */ =>  {
                let var_286 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#OptionRestrictionMaxValue`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_value(var_286);
            }
            ,
            s if s.matches("MaxLength") /* MaxLength com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$MaxLength */ =>  {
                let var_287 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#OptionRestrictionMaxLength`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_length(var_287);
            }
            ,
            s if s.matches("Regex") /* Regex com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$Regex */ =>  {
                let var_288 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_option_restriction_regex(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_regex(var_288);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_configuration_settings_description(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ConfigurationSettingsDescription, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ConfigurationSettingsDescription::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SolutionStackName") /* SolutionStackName com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$SolutionStackName */ =>  {
                let var_289 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_solution_stack_name(var_289);
            }
            ,
            s if s.matches("PlatformArn") /* PlatformArn com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$PlatformArn */ =>  {
                let var_290 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_arn(var_290);
            }
            ,
            s if s.matches("ApplicationName") /* ApplicationName com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$ApplicationName */ =>  {
                let var_291 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_application_name(var_291);
            }
            ,
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$TemplateName */ =>  {
                let var_292 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_292);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$Description */ =>  {
                let var_293 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_293);
            }
            ,
            s if s.matches("EnvironmentName") /* EnvironmentName com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$EnvironmentName */ =>  {
                let var_294 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_name(var_294);
            }
            ,
            s if s.matches("DeploymentStatus") /* DeploymentStatus com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$DeploymentStatus */ =>  {
                let var_295 =
                    Some(
                        Result::<crate::model::ConfigurationDeploymentStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ConfigurationDeploymentStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_deployment_status(var_295);
            }
            ,
            s if s.matches("DateCreated") /* DateCreated com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$DateCreated */ =>  {
                let var_296 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_created(var_296);
            }
            ,
            s if s.matches("DateUpdated") /* DateUpdated com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$DateUpdated */ =>  {
                let var_297 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)"))
                        ?
                    )
                ;
                builder = builder.set_date_updated(var_297);
            }
            ,
            s if s.matches("OptionSettings") /* OptionSettings com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$OptionSettings */ =>  {
                let var_298 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_configuration_option_settings_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_option_settings(var_298);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_status_codes(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::StatusCodes, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::StatusCodes::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status2xx") /* Status2xx com.amazonaws.elasticbeanstalk#StatusCodes$Status2xx */ =>  {
                let var_299 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#NullableInteger`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_status2xx(var_299);
            }
            ,
            s if s.matches("Status3xx") /* Status3xx com.amazonaws.elasticbeanstalk#StatusCodes$Status3xx */ =>  {
                let var_300 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#NullableInteger`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_status3xx(var_300);
            }
            ,
            s if s.matches("Status4xx") /* Status4xx com.amazonaws.elasticbeanstalk#StatusCodes$Status4xx */ =>  {
                let var_301 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#NullableInteger`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_status4xx(var_301);
            }
            ,
            s if s.matches("Status5xx") /* Status5xx com.amazonaws.elasticbeanstalk#StatusCodes$Status5xx */ =>  {
                let var_302 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#NullableInteger`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_status5xx(var_302);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_latency(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Latency, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Latency::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("P999") /* P999 com.amazonaws.elasticbeanstalk#Latency$P999 */ =>  {
                let var_303 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_p999(var_303);
            }
            ,
            s if s.matches("P99") /* P99 com.amazonaws.elasticbeanstalk#Latency$P99 */ =>  {
                let var_304 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_p99(var_304);
            }
            ,
            s if s.matches("P95") /* P95 com.amazonaws.elasticbeanstalk#Latency$P95 */ =>  {
                let var_305 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_p95(var_305);
            }
            ,
            s if s.matches("P90") /* P90 com.amazonaws.elasticbeanstalk#Latency$P90 */ =>  {
                let var_306 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_p90(var_306);
            }
            ,
            s if s.matches("P85") /* P85 com.amazonaws.elasticbeanstalk#Latency$P85 */ =>  {
                let var_307 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_p85(var_307);
            }
            ,
            s if s.matches("P75") /* P75 com.amazonaws.elasticbeanstalk#Latency$P75 */ =>  {
                let var_308 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_p75(var_308);
            }
            ,
            s if s.matches("P50") /* P50 com.amazonaws.elasticbeanstalk#Latency$P50 */ =>  {
                let var_309 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_p50(var_309);
            }
            ,
            s if s.matches("P10") /* P10 com.amazonaws.elasticbeanstalk#Latency$P10 */ =>  {
                let var_310 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_p10(var_310);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_managed_action_history_item(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ManagedActionHistoryItem, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ManagedActionHistoryItem::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ActionId") /* ActionId com.amazonaws.elasticbeanstalk#ManagedActionHistoryItem$ActionId */ =>  {
                let var_311 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_action_id(var_311);
            }
            ,
            s if s.matches("ActionType") /* ActionType com.amazonaws.elasticbeanstalk#ManagedActionHistoryItem$ActionType */ =>  {
                let var_312 =
                    Some(
                        Result::<crate::model::ActionType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ActionType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_action_type(var_312);
            }
            ,
            s if s.matches("ActionDescription") /* ActionDescription com.amazonaws.elasticbeanstalk#ManagedActionHistoryItem$ActionDescription */ =>  {
                let var_313 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_action_description(var_313);
            }
            ,
            s if s.matches("FailureType") /* FailureType com.amazonaws.elasticbeanstalk#ManagedActionHistoryItem$FailureType */ =>  {
                let var_314 =
                    Some(
                        Result::<crate::model::FailureType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::FailureType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_failure_type(var_314);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.elasticbeanstalk#ManagedActionHistoryItem$Status */ =>  {
                let var_315 =
                    Some(
                        Result::<crate::model::ActionHistoryStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ActionHistoryStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_315);
            }
            ,
            s if s.matches("FailureDescription") /* FailureDescription com.amazonaws.elasticbeanstalk#ManagedActionHistoryItem$FailureDescription */ =>  {
                let var_316 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_failure_description(var_316);
            }
            ,
            s if s.matches("ExecutedTime") /* ExecutedTime com.amazonaws.elasticbeanstalk#ManagedActionHistoryItem$ExecutedTime */ =>  {
                let var_317 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_executed_time(var_317);
            }
            ,
            s if s.matches("FinishedTime") /* FinishedTime com.amazonaws.elasticbeanstalk#ManagedActionHistoryItem$FinishedTime */ =>  {
                let var_318 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_finished_time(var_318);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_managed_action(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ManagedAction, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ManagedAction::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ActionId") /* ActionId com.amazonaws.elasticbeanstalk#ManagedAction$ActionId */ =>  {
                let var_319 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_action_id(var_319);
            }
            ,
            s if s.matches("ActionDescription") /* ActionDescription com.amazonaws.elasticbeanstalk#ManagedAction$ActionDescription */ =>  {
                let var_320 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_action_description(var_320);
            }
            ,
            s if s.matches("ActionType") /* ActionType com.amazonaws.elasticbeanstalk#ManagedAction$ActionType */ =>  {
                let var_321 =
                    Some(
                        Result::<crate::model::ActionType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ActionType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_action_type(var_321);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.elasticbeanstalk#ManagedAction$Status */ =>  {
                let var_322 =
                    Some(
                        Result::<crate::model::ActionStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ActionStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_322);
            }
            ,
            s if s.matches("WindowStartTime") /* WindowStartTime com.amazonaws.elasticbeanstalk#ManagedAction$WindowStartTime */ =>  {
                let var_323 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_window_start_time(var_323);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_auto_scaling_group_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AutoScalingGroup>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#AutoScalingGroupList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_auto_scaling_group(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_instance_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Instance>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#InstanceList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_instance(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_launch_configuration_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::LaunchConfiguration>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#LaunchConfigurationList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_launch_configuration(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_launch_template_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::LaunchTemplate>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#LaunchTemplateList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_launch_template(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_load_balancer_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::LoadBalancer>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#LoadBalancerList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_load_balancer(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_trigger_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Trigger>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#TriggerList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_trigger(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_queue_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Queue>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#QueueList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_queue(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_event_description(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EventDescription, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EventDescription::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EventDate") /* EventDate com.amazonaws.elasticbeanstalk#EventDescription$EventDate */ =>  {
                let var_324 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#EventDate`)"))
                        ?
                    )
                ;
                builder = builder.set_event_date(var_324);
            }
            ,
            s if s.matches("Message") /* Message com.amazonaws.elasticbeanstalk#EventDescription$Message */ =>  {
                let var_325 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_325);
            }
            ,
            s if s.matches("ApplicationName") /* ApplicationName com.amazonaws.elasticbeanstalk#EventDescription$ApplicationName */ =>  {
                let var_326 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_application_name(var_326);
            }
            ,
            s if s.matches("VersionLabel") /* VersionLabel com.amazonaws.elasticbeanstalk#EventDescription$VersionLabel */ =>  {
                let var_327 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version_label(var_327);
            }
            ,
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.elasticbeanstalk#EventDescription$TemplateName */ =>  {
                let var_328 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_328);
            }
            ,
            s if s.matches("EnvironmentName") /* EnvironmentName com.amazonaws.elasticbeanstalk#EventDescription$EnvironmentName */ =>  {
                let var_329 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_environment_name(var_329);
            }
            ,
            s if s.matches("PlatformArn") /* PlatformArn com.amazonaws.elasticbeanstalk#EventDescription$PlatformArn */ =>  {
                let var_330 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_arn(var_330);
            }
            ,
            s if s.matches("RequestId") /* RequestId com.amazonaws.elasticbeanstalk#EventDescription$RequestId */ =>  {
                let var_331 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_request_id(var_331);
            }
            ,
            s if s.matches("Severity") /* Severity com.amazonaws.elasticbeanstalk#EventDescription$Severity */ =>  {
                let var_332 =
                    Some(
                        Result::<crate::model::EventSeverity, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EventSeverity::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_severity(var_332);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_single_instance_health(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SingleInstanceHealth, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SingleInstanceHealth::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("InstanceId") /* InstanceId com.amazonaws.elasticbeanstalk#SingleInstanceHealth$InstanceId */ =>  {
                let var_333 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_id(var_333);
            }
            ,
            s if s.matches("HealthStatus") /* HealthStatus com.amazonaws.elasticbeanstalk#SingleInstanceHealth$HealthStatus */ =>  {
                let var_334 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_health_status(var_334);
            }
            ,
            s if s.matches("Color") /* Color com.amazonaws.elasticbeanstalk#SingleInstanceHealth$Color */ =>  {
                let var_335 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_color(var_335);
            }
            ,
            s if s.matches("Causes") /* Causes com.amazonaws.elasticbeanstalk#SingleInstanceHealth$Causes */ =>  {
                let var_336 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_causes(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_causes(var_336);
            }
            ,
            s if s.matches("LaunchedAt") /* LaunchedAt com.amazonaws.elasticbeanstalk#SingleInstanceHealth$LaunchedAt */ =>  {
                let var_337 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#LaunchedAt`)"))
                        ?
                    )
                ;
                builder = builder.set_launched_at(var_337);
            }
            ,
            s if s.matches("ApplicationMetrics") /* ApplicationMetrics com.amazonaws.elasticbeanstalk#SingleInstanceHealth$ApplicationMetrics */ =>  {
                let var_338 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_application_metrics(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_application_metrics(var_338);
            }
            ,
            s if s.matches("System") /* System com.amazonaws.elasticbeanstalk#SingleInstanceHealth$System */ =>  {
                let var_339 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_system_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_system(var_339);
            }
            ,
            s if s.matches("Deployment") /* Deployment com.amazonaws.elasticbeanstalk#SingleInstanceHealth$Deployment */ =>  {
                let var_340 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_deployment(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_deployment(var_340);
            }
            ,
            s if s.matches("AvailabilityZone") /* AvailabilityZone com.amazonaws.elasticbeanstalk#SingleInstanceHealth$AvailabilityZone */ =>  {
                let var_341 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_availability_zone(var_341);
            }
            ,
            s if s.matches("InstanceType") /* InstanceType com.amazonaws.elasticbeanstalk#SingleInstanceHealth$InstanceType */ =>  {
                let var_342 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_type(var_342);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_platform_programming_languages(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::PlatformProgrammingLanguage>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#PlatformProgrammingLanguages$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_platform_programming_language(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_platform_frameworks(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::PlatformFramework>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#PlatformFrameworks$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_platform_framework(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_custom_ami_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::CustomAmi>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#CustomAmiList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_custom_ami(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_solution_stack_description(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SolutionStackDescription, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SolutionStackDescription::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SolutionStackName") /* SolutionStackName com.amazonaws.elasticbeanstalk#SolutionStackDescription$SolutionStackName */ =>  {
                let var_343 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_solution_stack_name(var_343);
            }
            ,
            s if s.matches("PermittedFileTypes") /* PermittedFileTypes com.amazonaws.elasticbeanstalk#SolutionStackDescription$PermittedFileTypes */ =>  {
                let var_344 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_solution_stack_file_type_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_permitted_file_types(var_344);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_platform_branch_summary(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PlatformBranchSummary, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PlatformBranchSummary::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PlatformName") /* PlatformName com.amazonaws.elasticbeanstalk#PlatformBranchSummary$PlatformName */ =>  {
                let var_345 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform_name(var_345);
            }
            ,
            s if s.matches("BranchName") /* BranchName com.amazonaws.elasticbeanstalk#PlatformBranchSummary$BranchName */ =>  {
                let var_346 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_branch_name(var_346);
            }
            ,
            s if s.matches("LifecycleState") /* LifecycleState com.amazonaws.elasticbeanstalk#PlatformBranchSummary$LifecycleState */ =>  {
                let var_347 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_lifecycle_state(var_347);
            }
            ,
            s if s.matches("BranchOrder") /* BranchOrder com.amazonaws.elasticbeanstalk#PlatformBranchSummary$BranchOrder */ =>  {
                let var_348 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#BranchOrder`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_branch_order(var_348);
            }
            ,
            s if s.matches("SupportedTierList") /* SupportedTierList com.amazonaws.elasticbeanstalk#PlatformBranchSummary$SupportedTierList */ =>  {
                let var_349 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_supported_tier_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_supported_tier_list(var_349);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_tag(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Tag, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Tag::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Key") /* Key com.amazonaws.elasticbeanstalk#Tag$Key */ =>  {
                let var_350 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_350);
            }
            ,
            s if s.matches("Value") /* Value com.amazonaws.elasticbeanstalk#Tag$Value */ =>  {
                let var_351 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_value(var_351);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_environment_info_description(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EnvironmentInfoDescription, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EnvironmentInfoDescription::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("InfoType") /* InfoType com.amazonaws.elasticbeanstalk#EnvironmentInfoDescription$InfoType */ =>  {
                let var_352 =
                    Some(
                        Result::<crate::model::EnvironmentInfoType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EnvironmentInfoType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_info_type(var_352);
            }
            ,
            s if s.matches("Ec2InstanceId") /* Ec2InstanceId com.amazonaws.elasticbeanstalk#EnvironmentInfoDescription$Ec2InstanceId */ =>  {
                let var_353 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_ec2_instance_id(var_353);
            }
            ,
            s if s.matches("SampleTimestamp") /* SampleTimestamp com.amazonaws.elasticbeanstalk#EnvironmentInfoDescription$SampleTimestamp */ =>  {
                let var_354 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#SampleTimestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_sample_timestamp(var_354);
            }
            ,
            s if s.matches("Message") /* Message com.amazonaws.elasticbeanstalk#EnvironmentInfoDescription$Message */ =>  {
                let var_355 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_355);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_application_version_lifecycle_config(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ApplicationVersionLifecycleConfig, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ApplicationVersionLifecycleConfig::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("MaxCountRule") /* MaxCountRule com.amazonaws.elasticbeanstalk#ApplicationVersionLifecycleConfig$MaxCountRule */ =>  {
                let var_356 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_max_count_rule(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_max_count_rule(var_356);
            }
            ,
            s if s.matches("MaxAgeRule") /* MaxAgeRule com.amazonaws.elasticbeanstalk#ApplicationVersionLifecycleConfig$MaxAgeRule */ =>  {
                let var_357 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_max_age_rule(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_max_age_rule(var_357);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_validation_message(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ValidationMessage, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ValidationMessage::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.elasticbeanstalk#ValidationMessage$Message */ =>  {
                let var_358 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_358);
            }
            ,
            s if s.matches("Severity") /* Severity com.amazonaws.elasticbeanstalk#ValidationMessage$Severity */ =>  {
                let var_359 =
                    Some(
                        Result::<crate::model::ValidationSeverity, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ValidationSeverity::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_severity(var_359);
            }
            ,
            s if s.matches("Namespace") /* Namespace com.amazonaws.elasticbeanstalk#ValidationMessage$Namespace */ =>  {
                let var_360 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_namespace(var_360);
            }
            ,
            s if s.matches("OptionName") /* OptionName com.amazonaws.elasticbeanstalk#ValidationMessage$OptionName */ =>  {
                let var_361 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_option_name(var_361);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_load_balancer_listeners_description(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Listener>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#LoadBalancerListenersDescription$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_listener(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_configuration_option_possible_values(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#ConfigurationOptionPossibleValues$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_option_restriction_regex(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::OptionRestrictionRegex, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::OptionRestrictionRegex::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Pattern") /* Pattern com.amazonaws.elasticbeanstalk#OptionRestrictionRegex$Pattern */ =>  {
                let var_362 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_pattern(var_362);
            }
            ,
            s if s.matches("Label") /* Label com.amazonaws.elasticbeanstalk#OptionRestrictionRegex$Label */ =>  {
                let var_363 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_label(var_363);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_auto_scaling_group(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AutoScalingGroup, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AutoScalingGroup::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.elasticbeanstalk#AutoScalingGroup$Name */ =>  {
                let var_364 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_364);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_instance(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Instance, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Instance::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.elasticbeanstalk#Instance$Id */ =>  {
                let var_365 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_365);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_launch_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LaunchConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LaunchConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.elasticbeanstalk#LaunchConfiguration$Name */ =>  {
                let var_366 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_366);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_launch_template(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LaunchTemplate, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LaunchTemplate::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.elasticbeanstalk#LaunchTemplate$Id */ =>  {
                let var_367 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_367);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_load_balancer(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LoadBalancer, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LoadBalancer::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.elasticbeanstalk#LoadBalancer$Name */ =>  {
                let var_368 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_368);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_trigger(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Trigger, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Trigger::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.elasticbeanstalk#Trigger$Name */ =>  {
                let var_369 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_369);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_queue(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Queue, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Queue::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.elasticbeanstalk#Queue$Name */ =>  {
                let var_370 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_370);
            }
            ,
            s if s.matches("URL") /* URL com.amazonaws.elasticbeanstalk#Queue$URL */ =>  {
                let var_371 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_url(var_371);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_system_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SystemStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SystemStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CPUUtilization") /* CPUUtilization com.amazonaws.elasticbeanstalk#SystemStatus$CPUUtilization */ =>  {
                let var_372 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cpu_utilization(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cpu_utilization(var_372);
            }
            ,
            s if s.matches("LoadAverage") /* LoadAverage com.amazonaws.elasticbeanstalk#SystemStatus$LoadAverage */ =>  {
                let var_373 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_elasticbeanstalk_load_average(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_load_average(var_373);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_deployment(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Deployment, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Deployment::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("VersionLabel") /* VersionLabel com.amazonaws.elasticbeanstalk#Deployment$VersionLabel */ =>  {
                let var_374 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version_label(var_374);
            }
            ,
            s if s.matches("DeploymentId") /* DeploymentId com.amazonaws.elasticbeanstalk#Deployment$DeploymentId */ =>  {
                let var_375 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.elasticbeanstalk#NullableLong`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_deployment_id(var_375);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.elasticbeanstalk#Deployment$Status */ =>  {
                let var_376 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_376);
            }
            ,
            s if s.matches("DeploymentTime") /* DeploymentTime com.amazonaws.elasticbeanstalk#Deployment$DeploymentTime */ =>  {
                let var_377 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.elasticbeanstalk#DeploymentTimestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_deployment_time(var_377);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_platform_programming_language(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PlatformProgrammingLanguage, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PlatformProgrammingLanguage::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.elasticbeanstalk#PlatformProgrammingLanguage$Name */ =>  {
                let var_378 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_378);
            }
            ,
            s if s.matches("Version") /* Version com.amazonaws.elasticbeanstalk#PlatformProgrammingLanguage$Version */ =>  {
                let var_379 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version(var_379);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_platform_framework(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PlatformFramework, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PlatformFramework::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.elasticbeanstalk#PlatformFramework$Name */ =>  {
                let var_380 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_380);
            }
            ,
            s if s.matches("Version") /* Version com.amazonaws.elasticbeanstalk#PlatformFramework$Version */ =>  {
                let var_381 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version(var_381);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_custom_ami(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CustomAmi, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CustomAmi::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("VirtualizationType") /* VirtualizationType com.amazonaws.elasticbeanstalk#CustomAmi$VirtualizationType */ =>  {
                let var_382 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_virtualization_type(var_382);
            }
            ,
            s if s.matches("ImageId") /* ImageId com.amazonaws.elasticbeanstalk#CustomAmi$ImageId */ =>  {
                let var_383 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_image_id(var_383);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_solution_stack_file_type_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#SolutionStackFileTypeList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_max_count_rule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MaxCountRule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MaxCountRule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Enabled") /* Enabled com.amazonaws.elasticbeanstalk#MaxCountRule$Enabled */ =>  {
                let var_384 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.elasticbeanstalk#BoxedBoolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_enabled(var_384);
            }
            ,
            s if s.matches("MaxCount") /* MaxCount com.amazonaws.elasticbeanstalk#MaxCountRule$MaxCount */ =>  {
                let var_385 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#BoxedInt`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_count(var_385);
            }
            ,
            s if s.matches("DeleteSourceFromS3") /* DeleteSourceFromS3 com.amazonaws.elasticbeanstalk#MaxCountRule$DeleteSourceFromS3 */ =>  {
                let var_386 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.elasticbeanstalk#BoxedBoolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_delete_source_from_s3(var_386);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_max_age_rule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MaxAgeRule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MaxAgeRule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Enabled") /* Enabled com.amazonaws.elasticbeanstalk#MaxAgeRule$Enabled */ =>  {
                let var_387 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.elasticbeanstalk#BoxedBoolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_enabled(var_387);
            }
            ,
            s if s.matches("MaxAgeInDays") /* MaxAgeInDays com.amazonaws.elasticbeanstalk#MaxAgeRule$MaxAgeInDays */ =>  {
                let var_388 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#BoxedInt`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_age_in_days(var_388);
            }
            ,
            s if s.matches("DeleteSourceFromS3") /* DeleteSourceFromS3 com.amazonaws.elasticbeanstalk#MaxAgeRule$DeleteSourceFromS3 */ =>  {
                let var_389 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.elasticbeanstalk#BoxedBoolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_delete_source_from_s3(var_389);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_listener(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Listener, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Listener::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Protocol") /* Protocol com.amazonaws.elasticbeanstalk#Listener$Protocol */ =>  {
                let var_390 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_protocol(var_390);
            }
            ,
            s if s.matches("Port") /* Port com.amazonaws.elasticbeanstalk#Listener$Port */ =>  {
                let var_391 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.elasticbeanstalk#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_port(var_391);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_cpu_utilization(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CpuUtilization, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CpuUtilization::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("User") /* User com.amazonaws.elasticbeanstalk#CPUUtilization$User */ =>  {
                let var_392 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_user(var_392);
            }
            ,
            s if s.matches("Nice") /* Nice com.amazonaws.elasticbeanstalk#CPUUtilization$Nice */ =>  {
                let var_393 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_nice(var_393);
            }
            ,
            s if s.matches("System") /* System com.amazonaws.elasticbeanstalk#CPUUtilization$System */ =>  {
                let var_394 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_system(var_394);
            }
            ,
            s if s.matches("Idle") /* Idle com.amazonaws.elasticbeanstalk#CPUUtilization$Idle */ =>  {
                let var_395 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_idle(var_395);
            }
            ,
            s if s.matches("IOWait") /* IOWait com.amazonaws.elasticbeanstalk#CPUUtilization$IOWait */ =>  {
                let var_396 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_io_wait(var_396);
            }
            ,
            s if s.matches("IRQ") /* IRQ com.amazonaws.elasticbeanstalk#CPUUtilization$IRQ */ =>  {
                let var_397 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_irq(var_397);
            }
            ,
            s if s.matches("SoftIRQ") /* SoftIRQ com.amazonaws.elasticbeanstalk#CPUUtilization$SoftIRQ */ =>  {
                let var_398 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_soft_irq(var_398);
            }
            ,
            s if s.matches("Privileged") /* Privileged com.amazonaws.elasticbeanstalk#CPUUtilization$Privileged */ =>  {
                let var_399 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#NullableDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_privileged(var_399);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_elasticbeanstalk_load_average(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<f64>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.elasticbeanstalk#LoadAverage$member */ =>  {
                out.push(
                     {
                        <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.elasticbeanstalk#LoadAverageValue`)"))
                    }
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}
