// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Provides a list of validation messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidateConfigurationSettingsOutput {
    /// <p> A list of <code>ValidationMessage</code>. </p>
    pub messages: std::option::Option<std::vec::Vec<crate::model::ValidationMessage>>,
}
impl ValidateConfigurationSettingsOutput {
    /// <p> A list of <code>ValidationMessage</code>. </p>
    pub fn messages(&self) -> std::option::Option<&[crate::model::ValidationMessage]> {
        self.messages.as_deref()
    }
}
impl std::fmt::Debug for ValidateConfigurationSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidateConfigurationSettingsOutput");
        formatter.field("messages", &self.messages);
        formatter.finish()
    }
}
/// See [`ValidateConfigurationSettingsOutput`](crate::output::ValidateConfigurationSettingsOutput)
pub mod validate_configuration_settings_output {
    /// A builder for [`ValidateConfigurationSettingsOutput`](crate::output::ValidateConfigurationSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) messages: std::option::Option<std::vec::Vec<crate::model::ValidationMessage>>,
    }
    impl Builder {
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p> A list of <code>ValidationMessage</code>. </p>
        pub fn messages(mut self, input: crate::model::ValidationMessage) -> Self {
            let mut v = self.messages.unwrap_or_default();
            v.push(input);
            self.messages = Some(v);
            self
        }
        /// <p> A list of <code>ValidationMessage</code>. </p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationMessage>>,
        ) -> Self {
            self.messages = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidateConfigurationSettingsOutput`](crate::output::ValidateConfigurationSettingsOutput)
        pub fn build(self) -> crate::output::ValidateConfigurationSettingsOutput {
            crate::output::ValidateConfigurationSettingsOutput {
                messages: self.messages,
            }
        }
    }
}
impl ValidateConfigurationSettingsOutput {
    /// Creates a new builder-style object to manufacture [`ValidateConfigurationSettingsOutput`](crate::output::ValidateConfigurationSettingsOutput)
    pub fn builder() -> crate::output::validate_configuration_settings_output::Builder {
        crate::output::validate_configuration_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTagsForResourceOutput {}
impl std::fmt::Debug for UpdateTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTagsForResourceOutput");
        formatter.finish()
    }
}
/// See [`UpdateTagsForResourceOutput`](crate::output::UpdateTagsForResourceOutput)
pub mod update_tags_for_resource_output {
    /// A builder for [`UpdateTagsForResourceOutput`](crate::output::UpdateTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateTagsForResourceOutput`](crate::output::UpdateTagsForResourceOutput)
        pub fn build(self) -> crate::output::UpdateTagsForResourceOutput {
            crate::output::UpdateTagsForResourceOutput {}
        }
    }
}
impl UpdateTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTagsForResourceOutput`](crate::output::UpdateTagsForResourceOutput)
    pub fn builder() -> crate::output::update_tags_for_resource_output::Builder {
        crate::output::update_tags_for_resource_output::Builder::default()
    }
}

/// <p>Describes the properties of an environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnvironmentOutput {
    /// <p>The name of this environment.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The ID of this environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the application associated with this environment.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The application version deployed in this environment.</p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the platform version.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>The name of the configuration template used to originally launch this environment.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>Describes this environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
    pub endpoint_url: std::option::Option<std::string::String>,
    /// <p>The URL to the CNAME for this environment.</p>
    pub cname: std::option::Option<std::string::String>,
    /// <p>The creation date for this environment.</p>
    pub date_created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last modified date for this environment.</p>
    pub date_updated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current operational status of the environment:</p>
    /// <ul>
    /// <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>
    /// <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>
    /// <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>
    /// <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>
    /// <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::EnvironmentStatus>,
    /// <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>
    /// <p> <code>true:</code> There is an update in progress. </p>
    /// <p> <code>false:</code> There are no updates currently in progress. </p>
    pub abortable_operation_in_progress: std::option::Option<bool>,
    /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>
    /// <ul>
    /// <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>
    /// <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>
    /// <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>
    /// <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>
    /// </ul>
    /// <p> Default: <code>Grey</code> </p>
    pub health: std::option::Option<crate::model::EnvironmentHealth>,
    /// <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
    pub health_status: std::option::Option<crate::model::EnvironmentHealthStatus>,
    /// <p>The description of the AWS resources used by this environment.</p>
    pub resources: std::option::Option<crate::model::EnvironmentResourcesDescription>,
    /// <p>Describes the current tier of this environment.</p>
    pub tier: std::option::Option<crate::model::EnvironmentTier>,
    /// <p>A list of links to other environments in the same group.</p>
    pub environment_links: std::option::Option<std::vec::Vec<crate::model::EnvironmentLink>>,
    /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
    pub environment_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    pub operations_role: std::option::Option<std::string::String>,
}
impl UpdateEnvironmentOutput {
    /// <p>The name of this environment.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The ID of this environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The name of the application associated with this environment.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The application version deployed in this environment.</p>
    pub fn version_label(&self) -> std::option::Option<&str> {
        self.version_label.as_deref()
    }
    /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
    pub fn solution_stack_name(&self) -> std::option::Option<&str> {
        self.solution_stack_name.as_deref()
    }
    /// <p>The ARN of the platform version.</p>
    pub fn platform_arn(&self) -> std::option::Option<&str> {
        self.platform_arn.as_deref()
    }
    /// <p>The name of the configuration template used to originally launch this environment.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>Describes this environment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
    pub fn endpoint_url(&self) -> std::option::Option<&str> {
        self.endpoint_url.as_deref()
    }
    /// <p>The URL to the CNAME for this environment.</p>
    pub fn cname(&self) -> std::option::Option<&str> {
        self.cname.as_deref()
    }
    /// <p>The creation date for this environment.</p>
    pub fn date_created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_created.as_ref()
    }
    /// <p>The last modified date for this environment.</p>
    pub fn date_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_updated.as_ref()
    }
    /// <p>The current operational status of the environment:</p>
    /// <ul>
    /// <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>
    /// <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>
    /// <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>
    /// <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>
    /// <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::EnvironmentStatus> {
        self.status.as_ref()
    }
    /// <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>
    /// <p> <code>true:</code> There is an update in progress. </p>
    /// <p> <code>false:</code> There are no updates currently in progress. </p>
    pub fn abortable_operation_in_progress(&self) -> std::option::Option<bool> {
        self.abortable_operation_in_progress
    }
    /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>
    /// <ul>
    /// <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>
    /// <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>
    /// <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>
    /// <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>
    /// </ul>
    /// <p> Default: <code>Grey</code> </p>
    pub fn health(&self) -> std::option::Option<&crate::model::EnvironmentHealth> {
        self.health.as_ref()
    }
    /// <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
    pub fn health_status(&self) -> std::option::Option<&crate::model::EnvironmentHealthStatus> {
        self.health_status.as_ref()
    }
    /// <p>The description of the AWS resources used by this environment.</p>
    pub fn resources(&self) -> std::option::Option<&crate::model::EnvironmentResourcesDescription> {
        self.resources.as_ref()
    }
    /// <p>Describes the current tier of this environment.</p>
    pub fn tier(&self) -> std::option::Option<&crate::model::EnvironmentTier> {
        self.tier.as_ref()
    }
    /// <p>A list of links to other environments in the same group.</p>
    pub fn environment_links(&self) -> std::option::Option<&[crate::model::EnvironmentLink]> {
        self.environment_links.as_deref()
    }
    /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
    pub fn environment_arn(&self) -> std::option::Option<&str> {
        self.environment_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    pub fn operations_role(&self) -> std::option::Option<&str> {
        self.operations_role.as_deref()
    }
}
impl std::fmt::Debug for UpdateEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnvironmentOutput");
        formatter.field("environment_name", &self.environment_name);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("application_name", &self.application_name);
        formatter.field("version_label", &self.version_label);
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("template_name", &self.template_name);
        formatter.field("description", &self.description);
        formatter.field("endpoint_url", &self.endpoint_url);
        formatter.field("cname", &self.cname);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("status", &self.status);
        formatter.field(
            "abortable_operation_in_progress",
            &self.abortable_operation_in_progress,
        );
        formatter.field("health", &self.health);
        formatter.field("health_status", &self.health_status);
        formatter.field("resources", &self.resources);
        formatter.field("tier", &self.tier);
        formatter.field("environment_links", &self.environment_links);
        formatter.field("environment_arn", &self.environment_arn);
        formatter.field("operations_role", &self.operations_role);
        formatter.finish()
    }
}
/// See [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
pub mod update_environment_output {
    /// A builder for [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) endpoint_url: std::option::Option<std::string::String>,
        pub(crate) cname: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) date_updated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::EnvironmentStatus>,
        pub(crate) abortable_operation_in_progress: std::option::Option<bool>,
        pub(crate) health: std::option::Option<crate::model::EnvironmentHealth>,
        pub(crate) health_status: std::option::Option<crate::model::EnvironmentHealthStatus>,
        pub(crate) resources: std::option::Option<crate::model::EnvironmentResourcesDescription>,
        pub(crate) tier: std::option::Option<crate::model::EnvironmentTier>,
        pub(crate) environment_links:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentLink>>,
        pub(crate) environment_arn: std::option::Option<std::string::String>,
        pub(crate) operations_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of this environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of this environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The ID of this environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of this environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The name of the application associated with this environment.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application associated with this environment.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The application version deployed in this environment.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>The application version deployed in this environment.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// <p>The name of the configuration template used to originally launch this environment.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration template used to originally launch this environment.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>Describes this environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Describes this environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
        pub fn endpoint_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_url = Some(input.into());
            self
        }
        /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
        pub fn set_endpoint_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_url = input;
            self
        }
        /// <p>The URL to the CNAME for this environment.</p>
        pub fn cname(mut self, input: impl Into<std::string::String>) -> Self {
            self.cname = Some(input.into());
            self
        }
        /// <p>The URL to the CNAME for this environment.</p>
        pub fn set_cname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cname = input;
            self
        }
        /// <p>The creation date for this environment.</p>
        pub fn date_created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The creation date for this environment.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The last modified date for this environment.</p>
        pub fn date_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_updated = Some(input);
            self
        }
        /// <p>The last modified date for this environment.</p>
        pub fn set_date_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_updated = input;
            self
        }
        /// <p>The current operational status of the environment:</p>
        /// <ul>
        /// <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>
        /// <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>
        /// <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>
        /// <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>
        /// <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::EnvironmentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current operational status of the environment:</p>
        /// <ul>
        /// <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>
        /// <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>
        /// <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>
        /// <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>
        /// <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EnvironmentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>
        /// <p> <code>true:</code> There is an update in progress. </p>
        /// <p> <code>false:</code> There are no updates currently in progress. </p>
        pub fn abortable_operation_in_progress(mut self, input: bool) -> Self {
            self.abortable_operation_in_progress = Some(input);
            self
        }
        /// <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>
        /// <p> <code>true:</code> There is an update in progress. </p>
        /// <p> <code>false:</code> There are no updates currently in progress. </p>
        pub fn set_abortable_operation_in_progress(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.abortable_operation_in_progress = input;
            self
        }
        /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>
        /// <ul>
        /// <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>
        /// <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>
        /// <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>
        /// <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>
        /// </ul>
        /// <p> Default: <code>Grey</code> </p>
        pub fn health(mut self, input: crate::model::EnvironmentHealth) -> Self {
            self.health = Some(input);
            self
        }
        /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>
        /// <ul>
        /// <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>
        /// <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>
        /// <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>
        /// <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>
        /// </ul>
        /// <p> Default: <code>Grey</code> </p>
        pub fn set_health(
            mut self,
            input: std::option::Option<crate::model::EnvironmentHealth>,
        ) -> Self {
            self.health = input;
            self
        }
        /// <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
        pub fn health_status(mut self, input: crate::model::EnvironmentHealthStatus) -> Self {
            self.health_status = Some(input);
            self
        }
        /// <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<crate::model::EnvironmentHealthStatus>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// <p>The description of the AWS resources used by this environment.</p>
        pub fn resources(mut self, input: crate::model::EnvironmentResourcesDescription) -> Self {
            self.resources = Some(input);
            self
        }
        /// <p>The description of the AWS resources used by this environment.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::EnvironmentResourcesDescription>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>Describes the current tier of this environment.</p>
        pub fn tier(mut self, input: crate::model::EnvironmentTier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>Describes the current tier of this environment.</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTier>,
        ) -> Self {
            self.tier = input;
            self
        }
        /// Appends an item to `environment_links`.
        ///
        /// To override the contents of this collection use [`set_environment_links`](Self::set_environment_links).
        ///
        /// <p>A list of links to other environments in the same group.</p>
        pub fn environment_links(mut self, input: crate::model::EnvironmentLink) -> Self {
            let mut v = self.environment_links.unwrap_or_default();
            v.push(input);
            self.environment_links = Some(v);
            self
        }
        /// <p>A list of links to other environments in the same group.</p>
        pub fn set_environment_links(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentLink>>,
        ) -> Self {
            self.environment_links = input;
            self
        }
        /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
        pub fn environment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_arn = Some(input.into());
            self
        }
        /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
        pub fn set_environment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn operations_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.operations_role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn set_operations_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operations_role = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
        pub fn build(self) -> crate::output::UpdateEnvironmentOutput {
            crate::output::UpdateEnvironmentOutput {
                environment_name: self.environment_name,
                environment_id: self.environment_id,
                application_name: self.application_name,
                version_label: self.version_label,
                solution_stack_name: self.solution_stack_name,
                platform_arn: self.platform_arn,
                template_name: self.template_name,
                description: self.description,
                endpoint_url: self.endpoint_url,
                cname: self.cname,
                date_created: self.date_created,
                date_updated: self.date_updated,
                status: self.status,
                abortable_operation_in_progress: self.abortable_operation_in_progress,
                health: self.health,
                health_status: self.health_status,
                resources: self.resources,
                tier: self.tier,
                environment_links: self.environment_links,
                environment_arn: self.environment_arn,
                operations_role: self.operations_role,
            }
        }
    }
}
impl UpdateEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
    pub fn builder() -> crate::output::update_environment_output::Builder {
        crate::output::update_environment_output::Builder::default()
    }
}

/// <p>Describes the settings for a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationTemplateOutput {
    /// <p>The name of the solution stack this configuration set uses.</p>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the platform version.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>The name of the application associated with this configuration set.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p> If not <code>null</code>, the name of the configuration template for this configuration set. </p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>Describes this configuration set.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> If not <code>null</code>, the name of the environment for this configuration set. </p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p> If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter indicates the deployment status of this configuration set: </p>
    /// <ul>
    /// <li> <p> <code>null</code>: This configuration is not associated with a running environment.</p> </li>
    /// <li> <p> <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is in the process of deploying.</p> </li>
    /// <li> <p> <code>deployed</code>: This is the configuration that is currently deployed to the associated running environment.</p> </li>
    /// <li> <p> <code>failed</code>: This is a draft configuration that failed to successfully deploy.</p> </li>
    /// </ul>
    pub deployment_status: std::option::Option<crate::model::ConfigurationDeploymentStatus>,
    /// <p>The date (in UTC time) when this configuration set was created.</p>
    pub date_created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date (in UTC time) when this configuration set was last modified.</p>
    pub date_updated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of the configuration options and their values in this configuration set.</p>
    pub option_settings:
        std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
}
impl UpdateConfigurationTemplateOutput {
    /// <p>The name of the solution stack this configuration set uses.</p>
    pub fn solution_stack_name(&self) -> std::option::Option<&str> {
        self.solution_stack_name.as_deref()
    }
    /// <p>The ARN of the platform version.</p>
    pub fn platform_arn(&self) -> std::option::Option<&str> {
        self.platform_arn.as_deref()
    }
    /// <p>The name of the application associated with this configuration set.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p> If not <code>null</code>, the name of the configuration template for this configuration set. </p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>Describes this configuration set.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> If not <code>null</code>, the name of the environment for this configuration set. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p> If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter indicates the deployment status of this configuration set: </p>
    /// <ul>
    /// <li> <p> <code>null</code>: This configuration is not associated with a running environment.</p> </li>
    /// <li> <p> <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is in the process of deploying.</p> </li>
    /// <li> <p> <code>deployed</code>: This is the configuration that is currently deployed to the associated running environment.</p> </li>
    /// <li> <p> <code>failed</code>: This is a draft configuration that failed to successfully deploy.</p> </li>
    /// </ul>
    pub fn deployment_status(
        &self,
    ) -> std::option::Option<&crate::model::ConfigurationDeploymentStatus> {
        self.deployment_status.as_ref()
    }
    /// <p>The date (in UTC time) when this configuration set was created.</p>
    pub fn date_created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_created.as_ref()
    }
    /// <p>The date (in UTC time) when this configuration set was last modified.</p>
    pub fn date_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_updated.as_ref()
    }
    /// <p>A list of the configuration options and their values in this configuration set.</p>
    pub fn option_settings(
        &self,
    ) -> std::option::Option<&[crate::model::ConfigurationOptionSetting]> {
        self.option_settings.as_deref()
    }
}
impl std::fmt::Debug for UpdateConfigurationTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationTemplateOutput");
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("application_name", &self.application_name);
        formatter.field("template_name", &self.template_name);
        formatter.field("description", &self.description);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("option_settings", &self.option_settings);
        formatter.finish()
    }
}
/// See [`UpdateConfigurationTemplateOutput`](crate::output::UpdateConfigurationTemplateOutput)
pub mod update_configuration_template_output {
    /// A builder for [`UpdateConfigurationTemplateOutput`](crate::output::UpdateConfigurationTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) deployment_status:
            std::option::Option<crate::model::ConfigurationDeploymentStatus>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) date_updated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) option_settings:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
    }
    impl Builder {
        /// <p>The name of the solution stack this configuration set uses.</p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p>The name of the solution stack this configuration set uses.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// <p>The name of the application associated with this configuration set.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application associated with this configuration set.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p> If not <code>null</code>, the name of the configuration template for this configuration set. </p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p> If not <code>null</code>, the name of the configuration template for this configuration set. </p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>Describes this configuration set.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Describes this configuration set.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> If not <code>null</code>, the name of the environment for this configuration set. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p> If not <code>null</code>, the name of the environment for this configuration set. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p> If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter indicates the deployment status of this configuration set: </p>
        /// <ul>
        /// <li> <p> <code>null</code>: This configuration is not associated with a running environment.</p> </li>
        /// <li> <p> <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is in the process of deploying.</p> </li>
        /// <li> <p> <code>deployed</code>: This is the configuration that is currently deployed to the associated running environment.</p> </li>
        /// <li> <p> <code>failed</code>: This is a draft configuration that failed to successfully deploy.</p> </li>
        /// </ul>
        pub fn deployment_status(
            mut self,
            input: crate::model::ConfigurationDeploymentStatus,
        ) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p> If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter indicates the deployment status of this configuration set: </p>
        /// <ul>
        /// <li> <p> <code>null</code>: This configuration is not associated with a running environment.</p> </li>
        /// <li> <p> <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is in the process of deploying.</p> </li>
        /// <li> <p> <code>deployed</code>: This is the configuration that is currently deployed to the associated running environment.</p> </li>
        /// <li> <p> <code>failed</code>: This is a draft configuration that failed to successfully deploy.</p> </li>
        /// </ul>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationDeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>The date (in UTC time) when this configuration set was created.</p>
        pub fn date_created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The date (in UTC time) when this configuration set was created.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The date (in UTC time) when this configuration set was last modified.</p>
        pub fn date_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_updated = Some(input);
            self
        }
        /// <p>The date (in UTC time) when this configuration set was last modified.</p>
        pub fn set_date_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_updated = input;
            self
        }
        /// Appends an item to `option_settings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>A list of the configuration options and their values in this configuration set.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            let mut v = self.option_settings.unwrap_or_default();
            v.push(input);
            self.option_settings = Some(v);
            self
        }
        /// <p>A list of the configuration options and their values in this configuration set.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.option_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigurationTemplateOutput`](crate::output::UpdateConfigurationTemplateOutput)
        pub fn build(self) -> crate::output::UpdateConfigurationTemplateOutput {
            crate::output::UpdateConfigurationTemplateOutput {
                solution_stack_name: self.solution_stack_name,
                platform_arn: self.platform_arn,
                application_name: self.application_name,
                template_name: self.template_name,
                description: self.description,
                environment_name: self.environment_name,
                deployment_status: self.deployment_status,
                date_created: self.date_created,
                date_updated: self.date_updated,
                option_settings: self.option_settings,
            }
        }
    }
}
impl UpdateConfigurationTemplateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationTemplateOutput`](crate::output::UpdateConfigurationTemplateOutput)
    pub fn builder() -> crate::output::update_configuration_template_output::Builder {
        crate::output::update_configuration_template_output::Builder::default()
    }
}

/// <p>Result message wrapping a single description of an application version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationVersionOutput {
    /// <p> The <code>ApplicationVersionDescription</code> of the application version. </p>
    pub application_version: std::option::Option<crate::model::ApplicationVersionDescription>,
}
impl UpdateApplicationVersionOutput {
    /// <p> The <code>ApplicationVersionDescription</code> of the application version. </p>
    pub fn application_version(
        &self,
    ) -> std::option::Option<&crate::model::ApplicationVersionDescription> {
        self.application_version.as_ref()
    }
}
impl std::fmt::Debug for UpdateApplicationVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationVersionOutput");
        formatter.field("application_version", &self.application_version);
        formatter.finish()
    }
}
/// See [`UpdateApplicationVersionOutput`](crate::output::UpdateApplicationVersionOutput)
pub mod update_application_version_output {
    /// A builder for [`UpdateApplicationVersionOutput`](crate::output::UpdateApplicationVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_version:
            std::option::Option<crate::model::ApplicationVersionDescription>,
    }
    impl Builder {
        /// <p> The <code>ApplicationVersionDescription</code> of the application version. </p>
        pub fn application_version(
            mut self,
            input: crate::model::ApplicationVersionDescription,
        ) -> Self {
            self.application_version = Some(input);
            self
        }
        /// <p> The <code>ApplicationVersionDescription</code> of the application version. </p>
        pub fn set_application_version(
            mut self,
            input: std::option::Option<crate::model::ApplicationVersionDescription>,
        ) -> Self {
            self.application_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationVersionOutput`](crate::output::UpdateApplicationVersionOutput)
        pub fn build(self) -> crate::output::UpdateApplicationVersionOutput {
            crate::output::UpdateApplicationVersionOutput {
                application_version: self.application_version,
            }
        }
    }
}
impl UpdateApplicationVersionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationVersionOutput`](crate::output::UpdateApplicationVersionOutput)
    pub fn builder() -> crate::output::update_application_version_output::Builder {
        crate::output::update_application_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationResourceLifecycleOutput {
    /// <p>The name of the application.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The lifecycle configuration.</p>
    pub resource_lifecycle_config:
        std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
}
impl UpdateApplicationResourceLifecycleOutput {
    /// <p>The name of the application.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The lifecycle configuration.</p>
    pub fn resource_lifecycle_config(
        &self,
    ) -> std::option::Option<&crate::model::ApplicationResourceLifecycleConfig> {
        self.resource_lifecycle_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateApplicationResourceLifecycleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationResourceLifecycleOutput");
        formatter.field("application_name", &self.application_name);
        formatter.field("resource_lifecycle_config", &self.resource_lifecycle_config);
        formatter.finish()
    }
}
/// See [`UpdateApplicationResourceLifecycleOutput`](crate::output::UpdateApplicationResourceLifecycleOutput)
pub mod update_application_resource_lifecycle_output {
    /// A builder for [`UpdateApplicationResourceLifecycleOutput`](crate::output::UpdateApplicationResourceLifecycleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) resource_lifecycle_config:
            std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
    }
    impl Builder {
        /// <p>The name of the application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The lifecycle configuration.</p>
        pub fn resource_lifecycle_config(
            mut self,
            input: crate::model::ApplicationResourceLifecycleConfig,
        ) -> Self {
            self.resource_lifecycle_config = Some(input);
            self
        }
        /// <p>The lifecycle configuration.</p>
        pub fn set_resource_lifecycle_config(
            mut self,
            input: std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
        ) -> Self {
            self.resource_lifecycle_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationResourceLifecycleOutput`](crate::output::UpdateApplicationResourceLifecycleOutput)
        pub fn build(self) -> crate::output::UpdateApplicationResourceLifecycleOutput {
            crate::output::UpdateApplicationResourceLifecycleOutput {
                application_name: self.application_name,
                resource_lifecycle_config: self.resource_lifecycle_config,
            }
        }
    }
}
impl UpdateApplicationResourceLifecycleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationResourceLifecycleOutput`](crate::output::UpdateApplicationResourceLifecycleOutput)
    pub fn builder() -> crate::output::update_application_resource_lifecycle_output::Builder {
        crate::output::update_application_resource_lifecycle_output::Builder::default()
    }
}

/// <p>Result message containing a single description of an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationOutput {
    /// <p> The <code>ApplicationDescription</code> of the application. </p>
    pub application: std::option::Option<crate::model::ApplicationDescription>,
}
impl UpdateApplicationOutput {
    /// <p> The <code>ApplicationDescription</code> of the application. </p>
    pub fn application(&self) -> std::option::Option<&crate::model::ApplicationDescription> {
        self.application.as_ref()
    }
}
impl std::fmt::Debug for UpdateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationOutput");
        formatter.field("application", &self.application);
        formatter.finish()
    }
}
/// See [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
pub mod update_application_output {
    /// A builder for [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<crate::model::ApplicationDescription>,
    }
    impl Builder {
        /// <p> The <code>ApplicationDescription</code> of the application. </p>
        pub fn application(mut self, input: crate::model::ApplicationDescription) -> Self {
            self.application = Some(input);
            self
        }
        /// <p> The <code>ApplicationDescription</code> of the application. </p>
        pub fn set_application(
            mut self,
            input: std::option::Option<crate::model::ApplicationDescription>,
        ) -> Self {
            self.application = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
        pub fn build(self) -> crate::output::UpdateApplicationOutput {
            crate::output::UpdateApplicationOutput {
                application: self.application,
            }
        }
    }
}
impl UpdateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    pub fn builder() -> crate::output::update_application_output::Builder {
        crate::output::update_application_output::Builder::default()
    }
}

/// <p>Describes the properties of an environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateEnvironmentOutput {
    /// <p>The name of this environment.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The ID of this environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the application associated with this environment.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The application version deployed in this environment.</p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the platform version.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>The name of the configuration template used to originally launch this environment.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>Describes this environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
    pub endpoint_url: std::option::Option<std::string::String>,
    /// <p>The URL to the CNAME for this environment.</p>
    pub cname: std::option::Option<std::string::String>,
    /// <p>The creation date for this environment.</p>
    pub date_created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last modified date for this environment.</p>
    pub date_updated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current operational status of the environment:</p>
    /// <ul>
    /// <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>
    /// <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>
    /// <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>
    /// <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>
    /// <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::EnvironmentStatus>,
    /// <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>
    /// <p> <code>true:</code> There is an update in progress. </p>
    /// <p> <code>false:</code> There are no updates currently in progress. </p>
    pub abortable_operation_in_progress: std::option::Option<bool>,
    /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>
    /// <ul>
    /// <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>
    /// <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>
    /// <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>
    /// <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>
    /// </ul>
    /// <p> Default: <code>Grey</code> </p>
    pub health: std::option::Option<crate::model::EnvironmentHealth>,
    /// <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
    pub health_status: std::option::Option<crate::model::EnvironmentHealthStatus>,
    /// <p>The description of the AWS resources used by this environment.</p>
    pub resources: std::option::Option<crate::model::EnvironmentResourcesDescription>,
    /// <p>Describes the current tier of this environment.</p>
    pub tier: std::option::Option<crate::model::EnvironmentTier>,
    /// <p>A list of links to other environments in the same group.</p>
    pub environment_links: std::option::Option<std::vec::Vec<crate::model::EnvironmentLink>>,
    /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
    pub environment_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    pub operations_role: std::option::Option<std::string::String>,
}
impl TerminateEnvironmentOutput {
    /// <p>The name of this environment.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The ID of this environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The name of the application associated with this environment.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The application version deployed in this environment.</p>
    pub fn version_label(&self) -> std::option::Option<&str> {
        self.version_label.as_deref()
    }
    /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
    pub fn solution_stack_name(&self) -> std::option::Option<&str> {
        self.solution_stack_name.as_deref()
    }
    /// <p>The ARN of the platform version.</p>
    pub fn platform_arn(&self) -> std::option::Option<&str> {
        self.platform_arn.as_deref()
    }
    /// <p>The name of the configuration template used to originally launch this environment.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>Describes this environment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
    pub fn endpoint_url(&self) -> std::option::Option<&str> {
        self.endpoint_url.as_deref()
    }
    /// <p>The URL to the CNAME for this environment.</p>
    pub fn cname(&self) -> std::option::Option<&str> {
        self.cname.as_deref()
    }
    /// <p>The creation date for this environment.</p>
    pub fn date_created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_created.as_ref()
    }
    /// <p>The last modified date for this environment.</p>
    pub fn date_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_updated.as_ref()
    }
    /// <p>The current operational status of the environment:</p>
    /// <ul>
    /// <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>
    /// <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>
    /// <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>
    /// <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>
    /// <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::EnvironmentStatus> {
        self.status.as_ref()
    }
    /// <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>
    /// <p> <code>true:</code> There is an update in progress. </p>
    /// <p> <code>false:</code> There are no updates currently in progress. </p>
    pub fn abortable_operation_in_progress(&self) -> std::option::Option<bool> {
        self.abortable_operation_in_progress
    }
    /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>
    /// <ul>
    /// <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>
    /// <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>
    /// <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>
    /// <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>
    /// </ul>
    /// <p> Default: <code>Grey</code> </p>
    pub fn health(&self) -> std::option::Option<&crate::model::EnvironmentHealth> {
        self.health.as_ref()
    }
    /// <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
    pub fn health_status(&self) -> std::option::Option<&crate::model::EnvironmentHealthStatus> {
        self.health_status.as_ref()
    }
    /// <p>The description of the AWS resources used by this environment.</p>
    pub fn resources(&self) -> std::option::Option<&crate::model::EnvironmentResourcesDescription> {
        self.resources.as_ref()
    }
    /// <p>Describes the current tier of this environment.</p>
    pub fn tier(&self) -> std::option::Option<&crate::model::EnvironmentTier> {
        self.tier.as_ref()
    }
    /// <p>A list of links to other environments in the same group.</p>
    pub fn environment_links(&self) -> std::option::Option<&[crate::model::EnvironmentLink]> {
        self.environment_links.as_deref()
    }
    /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
    pub fn environment_arn(&self) -> std::option::Option<&str> {
        self.environment_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    pub fn operations_role(&self) -> std::option::Option<&str> {
        self.operations_role.as_deref()
    }
}
impl std::fmt::Debug for TerminateEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateEnvironmentOutput");
        formatter.field("environment_name", &self.environment_name);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("application_name", &self.application_name);
        formatter.field("version_label", &self.version_label);
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("template_name", &self.template_name);
        formatter.field("description", &self.description);
        formatter.field("endpoint_url", &self.endpoint_url);
        formatter.field("cname", &self.cname);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("status", &self.status);
        formatter.field(
            "abortable_operation_in_progress",
            &self.abortable_operation_in_progress,
        );
        formatter.field("health", &self.health);
        formatter.field("health_status", &self.health_status);
        formatter.field("resources", &self.resources);
        formatter.field("tier", &self.tier);
        formatter.field("environment_links", &self.environment_links);
        formatter.field("environment_arn", &self.environment_arn);
        formatter.field("operations_role", &self.operations_role);
        formatter.finish()
    }
}
/// See [`TerminateEnvironmentOutput`](crate::output::TerminateEnvironmentOutput)
pub mod terminate_environment_output {
    /// A builder for [`TerminateEnvironmentOutput`](crate::output::TerminateEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) endpoint_url: std::option::Option<std::string::String>,
        pub(crate) cname: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) date_updated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::EnvironmentStatus>,
        pub(crate) abortable_operation_in_progress: std::option::Option<bool>,
        pub(crate) health: std::option::Option<crate::model::EnvironmentHealth>,
        pub(crate) health_status: std::option::Option<crate::model::EnvironmentHealthStatus>,
        pub(crate) resources: std::option::Option<crate::model::EnvironmentResourcesDescription>,
        pub(crate) tier: std::option::Option<crate::model::EnvironmentTier>,
        pub(crate) environment_links:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentLink>>,
        pub(crate) environment_arn: std::option::Option<std::string::String>,
        pub(crate) operations_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of this environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of this environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The ID of this environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of this environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The name of the application associated with this environment.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application associated with this environment.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The application version deployed in this environment.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>The application version deployed in this environment.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// <p>The name of the configuration template used to originally launch this environment.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration template used to originally launch this environment.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>Describes this environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Describes this environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
        pub fn endpoint_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_url = Some(input.into());
            self
        }
        /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
        pub fn set_endpoint_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_url = input;
            self
        }
        /// <p>The URL to the CNAME for this environment.</p>
        pub fn cname(mut self, input: impl Into<std::string::String>) -> Self {
            self.cname = Some(input.into());
            self
        }
        /// <p>The URL to the CNAME for this environment.</p>
        pub fn set_cname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cname = input;
            self
        }
        /// <p>The creation date for this environment.</p>
        pub fn date_created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The creation date for this environment.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The last modified date for this environment.</p>
        pub fn date_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_updated = Some(input);
            self
        }
        /// <p>The last modified date for this environment.</p>
        pub fn set_date_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_updated = input;
            self
        }
        /// <p>The current operational status of the environment:</p>
        /// <ul>
        /// <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>
        /// <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>
        /// <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>
        /// <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>
        /// <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::EnvironmentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current operational status of the environment:</p>
        /// <ul>
        /// <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>
        /// <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>
        /// <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>
        /// <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>
        /// <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EnvironmentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>
        /// <p> <code>true:</code> There is an update in progress. </p>
        /// <p> <code>false:</code> There are no updates currently in progress. </p>
        pub fn abortable_operation_in_progress(mut self, input: bool) -> Self {
            self.abortable_operation_in_progress = Some(input);
            self
        }
        /// <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>
        /// <p> <code>true:</code> There is an update in progress. </p>
        /// <p> <code>false:</code> There are no updates currently in progress. </p>
        pub fn set_abortable_operation_in_progress(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.abortable_operation_in_progress = input;
            self
        }
        /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>
        /// <ul>
        /// <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>
        /// <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>
        /// <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>
        /// <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>
        /// </ul>
        /// <p> Default: <code>Grey</code> </p>
        pub fn health(mut self, input: crate::model::EnvironmentHealth) -> Self {
            self.health = Some(input);
            self
        }
        /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>
        /// <ul>
        /// <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>
        /// <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>
        /// <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>
        /// <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>
        /// </ul>
        /// <p> Default: <code>Grey</code> </p>
        pub fn set_health(
            mut self,
            input: std::option::Option<crate::model::EnvironmentHealth>,
        ) -> Self {
            self.health = input;
            self
        }
        /// <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
        pub fn health_status(mut self, input: crate::model::EnvironmentHealthStatus) -> Self {
            self.health_status = Some(input);
            self
        }
        /// <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<crate::model::EnvironmentHealthStatus>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// <p>The description of the AWS resources used by this environment.</p>
        pub fn resources(mut self, input: crate::model::EnvironmentResourcesDescription) -> Self {
            self.resources = Some(input);
            self
        }
        /// <p>The description of the AWS resources used by this environment.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::EnvironmentResourcesDescription>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>Describes the current tier of this environment.</p>
        pub fn tier(mut self, input: crate::model::EnvironmentTier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>Describes the current tier of this environment.</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTier>,
        ) -> Self {
            self.tier = input;
            self
        }
        /// Appends an item to `environment_links`.
        ///
        /// To override the contents of this collection use [`set_environment_links`](Self::set_environment_links).
        ///
        /// <p>A list of links to other environments in the same group.</p>
        pub fn environment_links(mut self, input: crate::model::EnvironmentLink) -> Self {
            let mut v = self.environment_links.unwrap_or_default();
            v.push(input);
            self.environment_links = Some(v);
            self
        }
        /// <p>A list of links to other environments in the same group.</p>
        pub fn set_environment_links(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentLink>>,
        ) -> Self {
            self.environment_links = input;
            self
        }
        /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
        pub fn environment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_arn = Some(input.into());
            self
        }
        /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
        pub fn set_environment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn operations_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.operations_role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn set_operations_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operations_role = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateEnvironmentOutput`](crate::output::TerminateEnvironmentOutput)
        pub fn build(self) -> crate::output::TerminateEnvironmentOutput {
            crate::output::TerminateEnvironmentOutput {
                environment_name: self.environment_name,
                environment_id: self.environment_id,
                application_name: self.application_name,
                version_label: self.version_label,
                solution_stack_name: self.solution_stack_name,
                platform_arn: self.platform_arn,
                template_name: self.template_name,
                description: self.description,
                endpoint_url: self.endpoint_url,
                cname: self.cname,
                date_created: self.date_created,
                date_updated: self.date_updated,
                status: self.status,
                abortable_operation_in_progress: self.abortable_operation_in_progress,
                health: self.health,
                health_status: self.health_status,
                resources: self.resources,
                tier: self.tier,
                environment_links: self.environment_links,
                environment_arn: self.environment_arn,
                operations_role: self.operations_role,
            }
        }
    }
}
impl TerminateEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`TerminateEnvironmentOutput`](crate::output::TerminateEnvironmentOutput)
    pub fn builder() -> crate::output::terminate_environment_output::Builder {
        crate::output::terminate_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SwapEnvironmentCnamEsOutput {}
impl std::fmt::Debug for SwapEnvironmentCnamEsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SwapEnvironmentCnamEsOutput");
        formatter.finish()
    }
}
/// See [`SwapEnvironmentCnamEsOutput`](crate::output::SwapEnvironmentCnamEsOutput)
pub mod swap_environment_cnam_es_output {
    /// A builder for [`SwapEnvironmentCnamEsOutput`](crate::output::SwapEnvironmentCnamEsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SwapEnvironmentCnamEsOutput`](crate::output::SwapEnvironmentCnamEsOutput)
        pub fn build(self) -> crate::output::SwapEnvironmentCnamEsOutput {
            crate::output::SwapEnvironmentCnamEsOutput {}
        }
    }
}
impl SwapEnvironmentCnamEsOutput {
    /// Creates a new builder-style object to manufacture [`SwapEnvironmentCnamEsOutput`](crate::output::SwapEnvironmentCnamEsOutput)
    pub fn builder() -> crate::output::swap_environment_cnam_es_output::Builder {
        crate::output::swap_environment_cnam_es_output::Builder::default()
    }
}

/// <p>Result message containing a description of the requested environment info.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetrieveEnvironmentInfoOutput {
    /// <p> The <code>EnvironmentInfoDescription</code> of the environment. </p>
    pub environment_info:
        std::option::Option<std::vec::Vec<crate::model::EnvironmentInfoDescription>>,
}
impl RetrieveEnvironmentInfoOutput {
    /// <p> The <code>EnvironmentInfoDescription</code> of the environment. </p>
    pub fn environment_info(
        &self,
    ) -> std::option::Option<&[crate::model::EnvironmentInfoDescription]> {
        self.environment_info.as_deref()
    }
}
impl std::fmt::Debug for RetrieveEnvironmentInfoOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetrieveEnvironmentInfoOutput");
        formatter.field("environment_info", &self.environment_info);
        formatter.finish()
    }
}
/// See [`RetrieveEnvironmentInfoOutput`](crate::output::RetrieveEnvironmentInfoOutput)
pub mod retrieve_environment_info_output {
    /// A builder for [`RetrieveEnvironmentInfoOutput`](crate::output::RetrieveEnvironmentInfoOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_info:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentInfoDescription>>,
    }
    impl Builder {
        /// Appends an item to `environment_info`.
        ///
        /// To override the contents of this collection use [`set_environment_info`](Self::set_environment_info).
        ///
        /// <p> The <code>EnvironmentInfoDescription</code> of the environment. </p>
        pub fn environment_info(mut self, input: crate::model::EnvironmentInfoDescription) -> Self {
            let mut v = self.environment_info.unwrap_or_default();
            v.push(input);
            self.environment_info = Some(v);
            self
        }
        /// <p> The <code>EnvironmentInfoDescription</code> of the environment. </p>
        pub fn set_environment_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentInfoDescription>>,
        ) -> Self {
            self.environment_info = input;
            self
        }
        /// Consumes the builder and constructs a [`RetrieveEnvironmentInfoOutput`](crate::output::RetrieveEnvironmentInfoOutput)
        pub fn build(self) -> crate::output::RetrieveEnvironmentInfoOutput {
            crate::output::RetrieveEnvironmentInfoOutput {
                environment_info: self.environment_info,
            }
        }
    }
}
impl RetrieveEnvironmentInfoOutput {
    /// Creates a new builder-style object to manufacture [`RetrieveEnvironmentInfoOutput`](crate::output::RetrieveEnvironmentInfoOutput)
    pub fn builder() -> crate::output::retrieve_environment_info_output::Builder {
        crate::output::retrieve_environment_info_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestartAppServerOutput {}
impl std::fmt::Debug for RestartAppServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestartAppServerOutput");
        formatter.finish()
    }
}
/// See [`RestartAppServerOutput`](crate::output::RestartAppServerOutput)
pub mod restart_app_server_output {
    /// A builder for [`RestartAppServerOutput`](crate::output::RestartAppServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RestartAppServerOutput`](crate::output::RestartAppServerOutput)
        pub fn build(self) -> crate::output::RestartAppServerOutput {
            crate::output::RestartAppServerOutput {}
        }
    }
}
impl RestartAppServerOutput {
    /// Creates a new builder-style object to manufacture [`RestartAppServerOutput`](crate::output::RestartAppServerOutput)
    pub fn builder() -> crate::output::restart_app_server_output::Builder {
        crate::output::restart_app_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestEnvironmentInfoOutput {}
impl std::fmt::Debug for RequestEnvironmentInfoOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestEnvironmentInfoOutput");
        formatter.finish()
    }
}
/// See [`RequestEnvironmentInfoOutput`](crate::output::RequestEnvironmentInfoOutput)
pub mod request_environment_info_output {
    /// A builder for [`RequestEnvironmentInfoOutput`](crate::output::RequestEnvironmentInfoOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RequestEnvironmentInfoOutput`](crate::output::RequestEnvironmentInfoOutput)
        pub fn build(self) -> crate::output::RequestEnvironmentInfoOutput {
            crate::output::RequestEnvironmentInfoOutput {}
        }
    }
}
impl RequestEnvironmentInfoOutput {
    /// Creates a new builder-style object to manufacture [`RequestEnvironmentInfoOutput`](crate::output::RequestEnvironmentInfoOutput)
    pub fn builder() -> crate::output::request_environment_info_output::Builder {
        crate::output::request_environment_info_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebuildEnvironmentOutput {}
impl std::fmt::Debug for RebuildEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebuildEnvironmentOutput");
        formatter.finish()
    }
}
/// See [`RebuildEnvironmentOutput`](crate::output::RebuildEnvironmentOutput)
pub mod rebuild_environment_output {
    /// A builder for [`RebuildEnvironmentOutput`](crate::output::RebuildEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RebuildEnvironmentOutput`](crate::output::RebuildEnvironmentOutput)
        pub fn build(self) -> crate::output::RebuildEnvironmentOutput {
            crate::output::RebuildEnvironmentOutput {}
        }
    }
}
impl RebuildEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`RebuildEnvironmentOutput`](crate::output::RebuildEnvironmentOutput)
    pub fn builder() -> crate::output::rebuild_environment_output::Builder {
        crate::output::rebuild_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource for which a tag list was requested.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag key-value pairs.</p>
    pub resource_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource for which a tag list was requested.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tag key-value pairs.</p>
    pub fn resource_tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.resource_tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource for which a tag list was requested.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which a tag list was requested.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>A list of tag key-value pairs.</p>
        pub fn resource_tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.resource_tags.unwrap_or_default();
            v.push(input);
            self.resource_tags = Some(v);
            self
        }
        /// <p>A list of tag key-value pairs.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                resource_arn: self.resource_arn,
                resource_tags: self.resource_tags,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPlatformVersionsOutput {
    /// <p>Summary information about the platform versions.</p>
    pub platform_summary_list: std::option::Option<std::vec::Vec<crate::model::PlatformSummary>>,
    /// <p>In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a subsequent request to get the next response page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPlatformVersionsOutput {
    /// <p>Summary information about the platform versions.</p>
    pub fn platform_summary_list(&self) -> std::option::Option<&[crate::model::PlatformSummary]> {
        self.platform_summary_list.as_deref()
    }
    /// <p>In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a subsequent request to get the next response page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPlatformVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPlatformVersionsOutput");
        formatter.field("platform_summary_list", &self.platform_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPlatformVersionsOutput`](crate::output::ListPlatformVersionsOutput)
pub mod list_platform_versions_output {
    /// A builder for [`ListPlatformVersionsOutput`](crate::output::ListPlatformVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_summary_list:
            std::option::Option<std::vec::Vec<crate::model::PlatformSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `platform_summary_list`.
        ///
        /// To override the contents of this collection use [`set_platform_summary_list`](Self::set_platform_summary_list).
        ///
        /// <p>Summary information about the platform versions.</p>
        pub fn platform_summary_list(mut self, input: crate::model::PlatformSummary) -> Self {
            let mut v = self.platform_summary_list.unwrap_or_default();
            v.push(input);
            self.platform_summary_list = Some(v);
            self
        }
        /// <p>Summary information about the platform versions.</p>
        pub fn set_platform_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformSummary>>,
        ) -> Self {
            self.platform_summary_list = input;
            self
        }
        /// <p>In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a subsequent request to get the next response page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a subsequent request to get the next response page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPlatformVersionsOutput`](crate::output::ListPlatformVersionsOutput)
        pub fn build(self) -> crate::output::ListPlatformVersionsOutput {
            crate::output::ListPlatformVersionsOutput {
                platform_summary_list: self.platform_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPlatformVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListPlatformVersionsOutput`](crate::output::ListPlatformVersionsOutput)
    pub fn builder() -> crate::output::list_platform_versions_output::Builder {
        crate::output::list_platform_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPlatformBranchesOutput {
    /// <p>Summary information about the platform branches.</p>
    pub platform_branch_summary_list:
        std::option::Option<std::vec::Vec<crate::model::PlatformBranchSummary>>,
    /// <p>In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a subsequent request to get the next response page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPlatformBranchesOutput {
    /// <p>Summary information about the platform branches.</p>
    pub fn platform_branch_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::PlatformBranchSummary]> {
        self.platform_branch_summary_list.as_deref()
    }
    /// <p>In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a subsequent request to get the next response page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPlatformBranchesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPlatformBranchesOutput");
        formatter.field(
            "platform_branch_summary_list",
            &self.platform_branch_summary_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPlatformBranchesOutput`](crate::output::ListPlatformBranchesOutput)
pub mod list_platform_branches_output {
    /// A builder for [`ListPlatformBranchesOutput`](crate::output::ListPlatformBranchesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_branch_summary_list:
            std::option::Option<std::vec::Vec<crate::model::PlatformBranchSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `platform_branch_summary_list`.
        ///
        /// To override the contents of this collection use [`set_platform_branch_summary_list`](Self::set_platform_branch_summary_list).
        ///
        /// <p>Summary information about the platform branches.</p>
        pub fn platform_branch_summary_list(
            mut self,
            input: crate::model::PlatformBranchSummary,
        ) -> Self {
            let mut v = self.platform_branch_summary_list.unwrap_or_default();
            v.push(input);
            self.platform_branch_summary_list = Some(v);
            self
        }
        /// <p>Summary information about the platform branches.</p>
        pub fn set_platform_branch_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformBranchSummary>>,
        ) -> Self {
            self.platform_branch_summary_list = input;
            self
        }
        /// <p>In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a subsequent request to get the next response page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a subsequent request to get the next response page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPlatformBranchesOutput`](crate::output::ListPlatformBranchesOutput)
        pub fn build(self) -> crate::output::ListPlatformBranchesOutput {
            crate::output::ListPlatformBranchesOutput {
                platform_branch_summary_list: self.platform_branch_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPlatformBranchesOutput {
    /// Creates a new builder-style object to manufacture [`ListPlatformBranchesOutput`](crate::output::ListPlatformBranchesOutput)
    pub fn builder() -> crate::output::list_platform_branches_output::Builder {
        crate::output::list_platform_branches_output::Builder::default()
    }
}

/// <p>A list of available AWS Elastic Beanstalk solution stacks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAvailableSolutionStacksOutput {
    /// <p>A list of available solution stacks.</p>
    pub solution_stacks: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A list of available solution stacks and their <code>SolutionStackDescription</code>. </p>
    pub solution_stack_details:
        std::option::Option<std::vec::Vec<crate::model::SolutionStackDescription>>,
}
impl ListAvailableSolutionStacksOutput {
    /// <p>A list of available solution stacks.</p>
    pub fn solution_stacks(&self) -> std::option::Option<&[std::string::String]> {
        self.solution_stacks.as_deref()
    }
    /// <p> A list of available solution stacks and their <code>SolutionStackDescription</code>. </p>
    pub fn solution_stack_details(
        &self,
    ) -> std::option::Option<&[crate::model::SolutionStackDescription]> {
        self.solution_stack_details.as_deref()
    }
}
impl std::fmt::Debug for ListAvailableSolutionStacksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAvailableSolutionStacksOutput");
        formatter.field("solution_stacks", &self.solution_stacks);
        formatter.field("solution_stack_details", &self.solution_stack_details);
        formatter.finish()
    }
}
/// See [`ListAvailableSolutionStacksOutput`](crate::output::ListAvailableSolutionStacksOutput)
pub mod list_available_solution_stacks_output {
    /// A builder for [`ListAvailableSolutionStacksOutput`](crate::output::ListAvailableSolutionStacksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_stacks: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) solution_stack_details:
            std::option::Option<std::vec::Vec<crate::model::SolutionStackDescription>>,
    }
    impl Builder {
        /// Appends an item to `solution_stacks`.
        ///
        /// To override the contents of this collection use [`set_solution_stacks`](Self::set_solution_stacks).
        ///
        /// <p>A list of available solution stacks.</p>
        pub fn solution_stacks(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.solution_stacks.unwrap_or_default();
            v.push(input.into());
            self.solution_stacks = Some(v);
            self
        }
        /// <p>A list of available solution stacks.</p>
        pub fn set_solution_stacks(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.solution_stacks = input;
            self
        }
        /// Appends an item to `solution_stack_details`.
        ///
        /// To override the contents of this collection use [`set_solution_stack_details`](Self::set_solution_stack_details).
        ///
        /// <p> A list of available solution stacks and their <code>SolutionStackDescription</code>. </p>
        pub fn solution_stack_details(
            mut self,
            input: crate::model::SolutionStackDescription,
        ) -> Self {
            let mut v = self.solution_stack_details.unwrap_or_default();
            v.push(input);
            self.solution_stack_details = Some(v);
            self
        }
        /// <p> A list of available solution stacks and their <code>SolutionStackDescription</code>. </p>
        pub fn set_solution_stack_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SolutionStackDescription>>,
        ) -> Self {
            self.solution_stack_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAvailableSolutionStacksOutput`](crate::output::ListAvailableSolutionStacksOutput)
        pub fn build(self) -> crate::output::ListAvailableSolutionStacksOutput {
            crate::output::ListAvailableSolutionStacksOutput {
                solution_stacks: self.solution_stacks,
                solution_stack_details: self.solution_stack_details,
            }
        }
    }
}
impl ListAvailableSolutionStacksOutput {
    /// Creates a new builder-style object to manufacture [`ListAvailableSolutionStacksOutput`](crate::output::ListAvailableSolutionStacksOutput)
    pub fn builder() -> crate::output::list_available_solution_stacks_output::Builder {
        crate::output::list_available_solution_stacks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateEnvironmentOperationsRoleOutput {}
impl std::fmt::Debug for DisassociateEnvironmentOperationsRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateEnvironmentOperationsRoleOutput");
        formatter.finish()
    }
}
/// See [`DisassociateEnvironmentOperationsRoleOutput`](crate::output::DisassociateEnvironmentOperationsRoleOutput)
pub mod disassociate_environment_operations_role_output {
    /// A builder for [`DisassociateEnvironmentOperationsRoleOutput`](crate::output::DisassociateEnvironmentOperationsRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateEnvironmentOperationsRoleOutput`](crate::output::DisassociateEnvironmentOperationsRoleOutput)
        pub fn build(self) -> crate::output::DisassociateEnvironmentOperationsRoleOutput {
            crate::output::DisassociateEnvironmentOperationsRoleOutput {}
        }
    }
}
impl DisassociateEnvironmentOperationsRoleOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateEnvironmentOperationsRoleOutput`](crate::output::DisassociateEnvironmentOperationsRoleOutput)
    pub fn builder() -> crate::output::disassociate_environment_operations_role_output::Builder {
        crate::output::disassociate_environment_operations_role_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePlatformVersionOutput {
    /// <p>Detailed information about the platform version.</p>
    pub platform_description: std::option::Option<crate::model::PlatformDescription>,
}
impl DescribePlatformVersionOutput {
    /// <p>Detailed information about the platform version.</p>
    pub fn platform_description(&self) -> std::option::Option<&crate::model::PlatformDescription> {
        self.platform_description.as_ref()
    }
}
impl std::fmt::Debug for DescribePlatformVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePlatformVersionOutput");
        formatter.field("platform_description", &self.platform_description);
        formatter.finish()
    }
}
/// See [`DescribePlatformVersionOutput`](crate::output::DescribePlatformVersionOutput)
pub mod describe_platform_version_output {
    /// A builder for [`DescribePlatformVersionOutput`](crate::output::DescribePlatformVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_description: std::option::Option<crate::model::PlatformDescription>,
    }
    impl Builder {
        /// <p>Detailed information about the platform version.</p>
        pub fn platform_description(mut self, input: crate::model::PlatformDescription) -> Self {
            self.platform_description = Some(input);
            self
        }
        /// <p>Detailed information about the platform version.</p>
        pub fn set_platform_description(
            mut self,
            input: std::option::Option<crate::model::PlatformDescription>,
        ) -> Self {
            self.platform_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePlatformVersionOutput`](crate::output::DescribePlatformVersionOutput)
        pub fn build(self) -> crate::output::DescribePlatformVersionOutput {
            crate::output::DescribePlatformVersionOutput {
                platform_description: self.platform_description,
            }
        }
    }
}
impl DescribePlatformVersionOutput {
    /// Creates a new builder-style object to manufacture [`DescribePlatformVersionOutput`](crate::output::DescribePlatformVersionOutput)
    pub fn builder() -> crate::output::describe_platform_version_output::Builder {
        crate::output::describe_platform_version_output::Builder::default()
    }
}

/// <p>Detailed health information about the Amazon EC2 instances in an AWS Elastic Beanstalk environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstancesHealthOutput {
    /// <p>Detailed health information about each instance.</p>
    /// <p>The output differs slightly between Linux and Windows environments. There is a difference in the members that are supported under the <code>
    /// <cpuutilization></cpuutilization></code> type.</p>
    pub instance_health_list:
        std::option::Option<std::vec::Vec<crate::model::SingleInstanceHealth>>,
    /// <p>The date and time that the health information was retrieved.</p>
    pub refreshed_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Pagination token for the next page of results, if available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeInstancesHealthOutput {
    /// <p>Detailed health information about each instance.</p>
    /// <p>The output differs slightly between Linux and Windows environments. There is a difference in the members that are supported under the <code>
    /// <cpuutilization></cpuutilization></code> type.</p>
    pub fn instance_health_list(
        &self,
    ) -> std::option::Option<&[crate::model::SingleInstanceHealth]> {
        self.instance_health_list.as_deref()
    }
    /// <p>The date and time that the health information was retrieved.</p>
    pub fn refreshed_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.refreshed_at.as_ref()
    }
    /// <p>Pagination token for the next page of results, if available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeInstancesHealthOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstancesHealthOutput");
        formatter.field("instance_health_list", &self.instance_health_list);
        formatter.field("refreshed_at", &self.refreshed_at);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeInstancesHealthOutput`](crate::output::DescribeInstancesHealthOutput)
pub mod describe_instances_health_output {
    /// A builder for [`DescribeInstancesHealthOutput`](crate::output::DescribeInstancesHealthOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_health_list:
            std::option::Option<std::vec::Vec<crate::model::SingleInstanceHealth>>,
        pub(crate) refreshed_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_health_list`.
        ///
        /// To override the contents of this collection use [`set_instance_health_list`](Self::set_instance_health_list).
        ///
        /// <p>Detailed health information about each instance.</p>
        /// <p>The output differs slightly between Linux and Windows environments. There is a difference in the members that are supported under the <code>
        /// <cpuutilization></cpuutilization></code> type.</p>
        pub fn instance_health_list(mut self, input: crate::model::SingleInstanceHealth) -> Self {
            let mut v = self.instance_health_list.unwrap_or_default();
            v.push(input);
            self.instance_health_list = Some(v);
            self
        }
        /// <p>Detailed health information about each instance.</p>
        /// <p>The output differs slightly between Linux and Windows environments. There is a difference in the members that are supported under the <code>
        /// <cpuutilization></cpuutilization></code> type.</p>
        pub fn set_instance_health_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SingleInstanceHealth>>,
        ) -> Self {
            self.instance_health_list = input;
            self
        }
        /// <p>The date and time that the health information was retrieved.</p>
        pub fn refreshed_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.refreshed_at = Some(input);
            self
        }
        /// <p>The date and time that the health information was retrieved.</p>
        pub fn set_refreshed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.refreshed_at = input;
            self
        }
        /// <p>Pagination token for the next page of results, if available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token for the next page of results, if available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstancesHealthOutput`](crate::output::DescribeInstancesHealthOutput)
        pub fn build(self) -> crate::output::DescribeInstancesHealthOutput {
            crate::output::DescribeInstancesHealthOutput {
                instance_health_list: self.instance_health_list,
                refreshed_at: self.refreshed_at,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeInstancesHealthOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInstancesHealthOutput`](crate::output::DescribeInstancesHealthOutput)
    pub fn builder() -> crate::output::describe_instances_health_output::Builder {
        crate::output::describe_instances_health_output::Builder::default()
    }
}

/// <p>Result message wrapping a list of event descriptions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsOutput {
    /// <p> A list of <code>EventDescription</code>. </p>
    pub events: std::option::Option<std::vec::Vec<crate::model::EventDescription>>,
    /// <p> If returned, this indicates that there are more results to obtain. Use this token in the next <code>DescribeEvents</code> call to get the next batch of events. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeEventsOutput {
    /// <p> A list of <code>EventDescription</code>. </p>
    pub fn events(&self) -> std::option::Option<&[crate::model::EventDescription]> {
        self.events.as_deref()
    }
    /// <p> If returned, this indicates that there are more results to obtain. Use this token in the next <code>DescribeEvents</code> call to get the next batch of events. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsOutput");
        formatter.field("events", &self.events);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
pub mod describe_events_output {
    /// A builder for [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::EventDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p> A list of <code>EventDescription</code>. </p>
        pub fn events(mut self, input: crate::model::EventDescription) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p> A list of <code>EventDescription</code>. </p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventDescription>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p> If returned, this indicates that there are more results to obtain. Use this token in the next <code>DescribeEvents</code> call to get the next batch of events. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> If returned, this indicates that there are more results to obtain. Use this token in the next <code>DescribeEvents</code> call to get the next batch of events. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
        pub fn build(self) -> crate::output::DescribeEventsOutput {
            crate::output::DescribeEventsOutput {
                events: self.events,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeEventsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    pub fn builder() -> crate::output::describe_events_output::Builder {
        crate::output::describe_events_output::Builder::default()
    }
}

/// <p>Result message containing a list of environment descriptions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEnvironmentsOutput {
    /// <p> Returns an <code>EnvironmentDescription</code> list. </p>
    pub environments: std::option::Option<std::vec::Vec<crate::model::EnvironmentDescription>>,
    /// <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeEnvironmentsOutput {
    /// <p> Returns an <code>EnvironmentDescription</code> list. </p>
    pub fn environments(&self) -> std::option::Option<&[crate::model::EnvironmentDescription]> {
        self.environments.as_deref()
    }
    /// <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeEnvironmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEnvironmentsOutput");
        formatter.field("environments", &self.environments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeEnvironmentsOutput`](crate::output::DescribeEnvironmentsOutput)
pub mod describe_environments_output {
    /// A builder for [`DescribeEnvironmentsOutput`](crate::output::DescribeEnvironmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environments:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `environments`.
        ///
        /// To override the contents of this collection use [`set_environments`](Self::set_environments).
        ///
        /// <p> Returns an <code>EnvironmentDescription</code> list. </p>
        pub fn environments(mut self, input: crate::model::EnvironmentDescription) -> Self {
            let mut v = self.environments.unwrap_or_default();
            v.push(input);
            self.environments = Some(v);
            self
        }
        /// <p> Returns an <code>EnvironmentDescription</code> list. </p>
        pub fn set_environments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentDescription>>,
        ) -> Self {
            self.environments = input;
            self
        }
        /// <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEnvironmentsOutput`](crate::output::DescribeEnvironmentsOutput)
        pub fn build(self) -> crate::output::DescribeEnvironmentsOutput {
            crate::output::DescribeEnvironmentsOutput {
                environments: self.environments,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeEnvironmentsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentsOutput`](crate::output::DescribeEnvironmentsOutput)
    pub fn builder() -> crate::output::describe_environments_output::Builder {
        crate::output::describe_environments_output::Builder::default()
    }
}

/// <p>Result message containing a list of environment resource descriptions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEnvironmentResourcesOutput {
    /// <p> A list of <code>EnvironmentResourceDescription</code>. </p>
    pub environment_resources: std::option::Option<crate::model::EnvironmentResourceDescription>,
}
impl DescribeEnvironmentResourcesOutput {
    /// <p> A list of <code>EnvironmentResourceDescription</code>. </p>
    pub fn environment_resources(
        &self,
    ) -> std::option::Option<&crate::model::EnvironmentResourceDescription> {
        self.environment_resources.as_ref()
    }
}
impl std::fmt::Debug for DescribeEnvironmentResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEnvironmentResourcesOutput");
        formatter.field("environment_resources", &self.environment_resources);
        formatter.finish()
    }
}
/// See [`DescribeEnvironmentResourcesOutput`](crate::output::DescribeEnvironmentResourcesOutput)
pub mod describe_environment_resources_output {
    /// A builder for [`DescribeEnvironmentResourcesOutput`](crate::output::DescribeEnvironmentResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_resources:
            std::option::Option<crate::model::EnvironmentResourceDescription>,
    }
    impl Builder {
        /// <p> A list of <code>EnvironmentResourceDescription</code>. </p>
        pub fn environment_resources(
            mut self,
            input: crate::model::EnvironmentResourceDescription,
        ) -> Self {
            self.environment_resources = Some(input);
            self
        }
        /// <p> A list of <code>EnvironmentResourceDescription</code>. </p>
        pub fn set_environment_resources(
            mut self,
            input: std::option::Option<crate::model::EnvironmentResourceDescription>,
        ) -> Self {
            self.environment_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEnvironmentResourcesOutput`](crate::output::DescribeEnvironmentResourcesOutput)
        pub fn build(self) -> crate::output::DescribeEnvironmentResourcesOutput {
            crate::output::DescribeEnvironmentResourcesOutput {
                environment_resources: self.environment_resources,
            }
        }
    }
}
impl DescribeEnvironmentResourcesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentResourcesOutput`](crate::output::DescribeEnvironmentResourcesOutput)
    pub fn builder() -> crate::output::describe_environment_resources_output::Builder {
        crate::output::describe_environment_resources_output::Builder::default()
    }
}

/// <p>The result message containing a list of managed actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEnvironmentManagedActionsOutput {
    /// <p>A list of upcoming and in-progress managed actions.</p>
    pub managed_actions: std::option::Option<std::vec::Vec<crate::model::ManagedAction>>,
}
impl DescribeEnvironmentManagedActionsOutput {
    /// <p>A list of upcoming and in-progress managed actions.</p>
    pub fn managed_actions(&self) -> std::option::Option<&[crate::model::ManagedAction]> {
        self.managed_actions.as_deref()
    }
}
impl std::fmt::Debug for DescribeEnvironmentManagedActionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEnvironmentManagedActionsOutput");
        formatter.field("managed_actions", &self.managed_actions);
        formatter.finish()
    }
}
/// See [`DescribeEnvironmentManagedActionsOutput`](crate::output::DescribeEnvironmentManagedActionsOutput)
pub mod describe_environment_managed_actions_output {
    /// A builder for [`DescribeEnvironmentManagedActionsOutput`](crate::output::DescribeEnvironmentManagedActionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) managed_actions: std::option::Option<std::vec::Vec<crate::model::ManagedAction>>,
    }
    impl Builder {
        /// Appends an item to `managed_actions`.
        ///
        /// To override the contents of this collection use [`set_managed_actions`](Self::set_managed_actions).
        ///
        /// <p>A list of upcoming and in-progress managed actions.</p>
        pub fn managed_actions(mut self, input: crate::model::ManagedAction) -> Self {
            let mut v = self.managed_actions.unwrap_or_default();
            v.push(input);
            self.managed_actions = Some(v);
            self
        }
        /// <p>A list of upcoming and in-progress managed actions.</p>
        pub fn set_managed_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ManagedAction>>,
        ) -> Self {
            self.managed_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEnvironmentManagedActionsOutput`](crate::output::DescribeEnvironmentManagedActionsOutput)
        pub fn build(self) -> crate::output::DescribeEnvironmentManagedActionsOutput {
            crate::output::DescribeEnvironmentManagedActionsOutput {
                managed_actions: self.managed_actions,
            }
        }
    }
}
impl DescribeEnvironmentManagedActionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentManagedActionsOutput`](crate::output::DescribeEnvironmentManagedActionsOutput)
    pub fn builder() -> crate::output::describe_environment_managed_actions_output::Builder {
        crate::output::describe_environment_managed_actions_output::Builder::default()
    }
}

/// <p>A result message containing a list of completed and failed managed actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEnvironmentManagedActionHistoryOutput {
    /// <p>A list of completed and failed managed actions.</p>
    pub managed_action_history_items:
        std::option::Option<std::vec::Vec<crate::model::ManagedActionHistoryItem>>,
    /// <p>A pagination token that you pass to <code>DescribeEnvironmentManagedActionHistory</code> to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeEnvironmentManagedActionHistoryOutput {
    /// <p>A list of completed and failed managed actions.</p>
    pub fn managed_action_history_items(
        &self,
    ) -> std::option::Option<&[crate::model::ManagedActionHistoryItem]> {
        self.managed_action_history_items.as_deref()
    }
    /// <p>A pagination token that you pass to <code>DescribeEnvironmentManagedActionHistory</code> to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeEnvironmentManagedActionHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEnvironmentManagedActionHistoryOutput");
        formatter.field(
            "managed_action_history_items",
            &self.managed_action_history_items,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeEnvironmentManagedActionHistoryOutput`](crate::output::DescribeEnvironmentManagedActionHistoryOutput)
pub mod describe_environment_managed_action_history_output {
    /// A builder for [`DescribeEnvironmentManagedActionHistoryOutput`](crate::output::DescribeEnvironmentManagedActionHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) managed_action_history_items:
            std::option::Option<std::vec::Vec<crate::model::ManagedActionHistoryItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `managed_action_history_items`.
        ///
        /// To override the contents of this collection use [`set_managed_action_history_items`](Self::set_managed_action_history_items).
        ///
        /// <p>A list of completed and failed managed actions.</p>
        pub fn managed_action_history_items(
            mut self,
            input: crate::model::ManagedActionHistoryItem,
        ) -> Self {
            let mut v = self.managed_action_history_items.unwrap_or_default();
            v.push(input);
            self.managed_action_history_items = Some(v);
            self
        }
        /// <p>A list of completed and failed managed actions.</p>
        pub fn set_managed_action_history_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ManagedActionHistoryItem>>,
        ) -> Self {
            self.managed_action_history_items = input;
            self
        }
        /// <p>A pagination token that you pass to <code>DescribeEnvironmentManagedActionHistory</code> to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that you pass to <code>DescribeEnvironmentManagedActionHistory</code> to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEnvironmentManagedActionHistoryOutput`](crate::output::DescribeEnvironmentManagedActionHistoryOutput)
        pub fn build(self) -> crate::output::DescribeEnvironmentManagedActionHistoryOutput {
            crate::output::DescribeEnvironmentManagedActionHistoryOutput {
                managed_action_history_items: self.managed_action_history_items,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeEnvironmentManagedActionHistoryOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentManagedActionHistoryOutput`](crate::output::DescribeEnvironmentManagedActionHistoryOutput)
    pub fn builder() -> crate::output::describe_environment_managed_action_history_output::Builder {
        crate::output::describe_environment_managed_action_history_output::Builder::default()
    }
}

/// <p>Health details for an AWS Elastic Beanstalk environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEnvironmentHealthOutput {
    /// <p>The environment's name.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health status</a> of the environment. For example, <code>Ok</code>.</p>
    pub health_status: std::option::Option<std::string::String>,
    /// <p>The environment's operational status. <code>Ready</code>, <code>Launching</code>, <code>Updating</code>, <code>Terminating</code>, or <code>Terminated</code>.</p>
    pub status: std::option::Option<crate::model::EnvironmentHealth>,
    /// <p>The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health color</a> of the environment.</p>
    pub color: std::option::Option<std::string::String>,
    /// <p>Descriptions of the data that contributed to the environment's current health status.</p>
    pub causes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Application request metrics for the environment.</p>
    pub application_metrics: std::option::Option<crate::model::ApplicationMetrics>,
    /// <p>Summary health information for the instances in the environment.</p>
    pub instances_health: std::option::Option<crate::model::InstanceHealthSummary>,
    /// <p>The date and time that the health information was retrieved.</p>
    pub refreshed_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeEnvironmentHealthOutput {
    /// <p>The environment's name.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health status</a> of the environment. For example, <code>Ok</code>.</p>
    pub fn health_status(&self) -> std::option::Option<&str> {
        self.health_status.as_deref()
    }
    /// <p>The environment's operational status. <code>Ready</code>, <code>Launching</code>, <code>Updating</code>, <code>Terminating</code>, or <code>Terminated</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EnvironmentHealth> {
        self.status.as_ref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health color</a> of the environment.</p>
    pub fn color(&self) -> std::option::Option<&str> {
        self.color.as_deref()
    }
    /// <p>Descriptions of the data that contributed to the environment's current health status.</p>
    pub fn causes(&self) -> std::option::Option<&[std::string::String]> {
        self.causes.as_deref()
    }
    /// <p>Application request metrics for the environment.</p>
    pub fn application_metrics(&self) -> std::option::Option<&crate::model::ApplicationMetrics> {
        self.application_metrics.as_ref()
    }
    /// <p>Summary health information for the instances in the environment.</p>
    pub fn instances_health(&self) -> std::option::Option<&crate::model::InstanceHealthSummary> {
        self.instances_health.as_ref()
    }
    /// <p>The date and time that the health information was retrieved.</p>
    pub fn refreshed_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.refreshed_at.as_ref()
    }
}
impl std::fmt::Debug for DescribeEnvironmentHealthOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEnvironmentHealthOutput");
        formatter.field("environment_name", &self.environment_name);
        formatter.field("health_status", &self.health_status);
        formatter.field("status", &self.status);
        formatter.field("color", &self.color);
        formatter.field("causes", &self.causes);
        formatter.field("application_metrics", &self.application_metrics);
        formatter.field("instances_health", &self.instances_health);
        formatter.field("refreshed_at", &self.refreshed_at);
        formatter.finish()
    }
}
/// See [`DescribeEnvironmentHealthOutput`](crate::output::DescribeEnvironmentHealthOutput)
pub mod describe_environment_health_output {
    /// A builder for [`DescribeEnvironmentHealthOutput`](crate::output::DescribeEnvironmentHealthOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) health_status: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::EnvironmentHealth>,
        pub(crate) color: std::option::Option<std::string::String>,
        pub(crate) causes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) application_metrics: std::option::Option<crate::model::ApplicationMetrics>,
        pub(crate) instances_health: std::option::Option<crate::model::InstanceHealthSummary>,
        pub(crate) refreshed_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The environment's name.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The environment's name.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health status</a> of the environment. For example, <code>Ok</code>.</p>
        pub fn health_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_status = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health status</a> of the environment. For example, <code>Ok</code>.</p>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// <p>The environment's operational status. <code>Ready</code>, <code>Launching</code>, <code>Updating</code>, <code>Terminating</code>, or <code>Terminated</code>.</p>
        pub fn status(mut self, input: crate::model::EnvironmentHealth) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The environment's operational status. <code>Ready</code>, <code>Launching</code>, <code>Updating</code>, <code>Terminating</code>, or <code>Terminated</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EnvironmentHealth>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health color</a> of the environment.</p>
        pub fn color(mut self, input: impl Into<std::string::String>) -> Self {
            self.color = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health color</a> of the environment.</p>
        pub fn set_color(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.color = input;
            self
        }
        /// Appends an item to `causes`.
        ///
        /// To override the contents of this collection use [`set_causes`](Self::set_causes).
        ///
        /// <p>Descriptions of the data that contributed to the environment's current health status.</p>
        pub fn causes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.causes.unwrap_or_default();
            v.push(input.into());
            self.causes = Some(v);
            self
        }
        /// <p>Descriptions of the data that contributed to the environment's current health status.</p>
        pub fn set_causes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.causes = input;
            self
        }
        /// <p>Application request metrics for the environment.</p>
        pub fn application_metrics(mut self, input: crate::model::ApplicationMetrics) -> Self {
            self.application_metrics = Some(input);
            self
        }
        /// <p>Application request metrics for the environment.</p>
        pub fn set_application_metrics(
            mut self,
            input: std::option::Option<crate::model::ApplicationMetrics>,
        ) -> Self {
            self.application_metrics = input;
            self
        }
        /// <p>Summary health information for the instances in the environment.</p>
        pub fn instances_health(mut self, input: crate::model::InstanceHealthSummary) -> Self {
            self.instances_health = Some(input);
            self
        }
        /// <p>Summary health information for the instances in the environment.</p>
        pub fn set_instances_health(
            mut self,
            input: std::option::Option<crate::model::InstanceHealthSummary>,
        ) -> Self {
            self.instances_health = input;
            self
        }
        /// <p>The date and time that the health information was retrieved.</p>
        pub fn refreshed_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.refreshed_at = Some(input);
            self
        }
        /// <p>The date and time that the health information was retrieved.</p>
        pub fn set_refreshed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.refreshed_at = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEnvironmentHealthOutput`](crate::output::DescribeEnvironmentHealthOutput)
        pub fn build(self) -> crate::output::DescribeEnvironmentHealthOutput {
            crate::output::DescribeEnvironmentHealthOutput {
                environment_name: self.environment_name,
                health_status: self.health_status,
                status: self.status,
                color: self.color,
                causes: self.causes,
                application_metrics: self.application_metrics,
                instances_health: self.instances_health,
                refreshed_at: self.refreshed_at,
            }
        }
    }
}
impl DescribeEnvironmentHealthOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentHealthOutput`](crate::output::DescribeEnvironmentHealthOutput)
    pub fn builder() -> crate::output::describe_environment_health_output::Builder {
        crate::output::describe_environment_health_output::Builder::default()
    }
}

/// <p>The results from a request to change the configuration settings of an environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationSettingsOutput {
    /// <p> A list of <code>ConfigurationSettingsDescription</code>. </p>
    pub configuration_settings:
        std::option::Option<std::vec::Vec<crate::model::ConfigurationSettingsDescription>>,
}
impl DescribeConfigurationSettingsOutput {
    /// <p> A list of <code>ConfigurationSettingsDescription</code>. </p>
    pub fn configuration_settings(
        &self,
    ) -> std::option::Option<&[crate::model::ConfigurationSettingsDescription]> {
        self.configuration_settings.as_deref()
    }
}
impl std::fmt::Debug for DescribeConfigurationSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationSettingsOutput");
        formatter.field("configuration_settings", &self.configuration_settings);
        formatter.finish()
    }
}
/// See [`DescribeConfigurationSettingsOutput`](crate::output::DescribeConfigurationSettingsOutput)
pub mod describe_configuration_settings_output {
    /// A builder for [`DescribeConfigurationSettingsOutput`](crate::output::DescribeConfigurationSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_settings:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationSettingsDescription>>,
    }
    impl Builder {
        /// Appends an item to `configuration_settings`.
        ///
        /// To override the contents of this collection use [`set_configuration_settings`](Self::set_configuration_settings).
        ///
        /// <p> A list of <code>ConfigurationSettingsDescription</code>. </p>
        pub fn configuration_settings(
            mut self,
            input: crate::model::ConfigurationSettingsDescription,
        ) -> Self {
            let mut v = self.configuration_settings.unwrap_or_default();
            v.push(input);
            self.configuration_settings = Some(v);
            self
        }
        /// <p> A list of <code>ConfigurationSettingsDescription</code>. </p>
        pub fn set_configuration_settings(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ConfigurationSettingsDescription>,
            >,
        ) -> Self {
            self.configuration_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationSettingsOutput`](crate::output::DescribeConfigurationSettingsOutput)
        pub fn build(self) -> crate::output::DescribeConfigurationSettingsOutput {
            crate::output::DescribeConfigurationSettingsOutput {
                configuration_settings: self.configuration_settings,
            }
        }
    }
}
impl DescribeConfigurationSettingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationSettingsOutput`](crate::output::DescribeConfigurationSettingsOutput)
    pub fn builder() -> crate::output::describe_configuration_settings_output::Builder {
        crate::output::describe_configuration_settings_output::Builder::default()
    }
}

/// <p>Describes the settings for a specified configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationOptionsOutput {
    /// <p>The name of the solution stack these configuration options belong to.</p>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the platform version.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p> A list of <code>ConfigurationOptionDescription</code>. </p>
    pub options: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionDescription>>,
}
impl DescribeConfigurationOptionsOutput {
    /// <p>The name of the solution stack these configuration options belong to.</p>
    pub fn solution_stack_name(&self) -> std::option::Option<&str> {
        self.solution_stack_name.as_deref()
    }
    /// <p>The ARN of the platform version.</p>
    pub fn platform_arn(&self) -> std::option::Option<&str> {
        self.platform_arn.as_deref()
    }
    /// <p> A list of <code>ConfigurationOptionDescription</code>. </p>
    pub fn options(&self) -> std::option::Option<&[crate::model::ConfigurationOptionDescription]> {
        self.options.as_deref()
    }
}
impl std::fmt::Debug for DescribeConfigurationOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationOptionsOutput");
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("options", &self.options);
        formatter.finish()
    }
}
/// See [`DescribeConfigurationOptionsOutput`](crate::output::DescribeConfigurationOptionsOutput)
pub mod describe_configuration_options_output {
    /// A builder for [`DescribeConfigurationOptionsOutput`](crate::output::DescribeConfigurationOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) options:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionDescription>>,
    }
    impl Builder {
        /// <p>The name of the solution stack these configuration options belong to.</p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p>The name of the solution stack these configuration options belong to.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// Appends an item to `options`.
        ///
        /// To override the contents of this collection use [`set_options`](Self::set_options).
        ///
        /// <p> A list of <code>ConfigurationOptionDescription</code>. </p>
        pub fn options(mut self, input: crate::model::ConfigurationOptionDescription) -> Self {
            let mut v = self.options.unwrap_or_default();
            v.push(input);
            self.options = Some(v);
            self
        }
        /// <p> A list of <code>ConfigurationOptionDescription</code>. </p>
        pub fn set_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionDescription>>,
        ) -> Self {
            self.options = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationOptionsOutput`](crate::output::DescribeConfigurationOptionsOutput)
        pub fn build(self) -> crate::output::DescribeConfigurationOptionsOutput {
            crate::output::DescribeConfigurationOptionsOutput {
                solution_stack_name: self.solution_stack_name,
                platform_arn: self.platform_arn,
                options: self.options,
            }
        }
    }
}
impl DescribeConfigurationOptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationOptionsOutput`](crate::output::DescribeConfigurationOptionsOutput)
    pub fn builder() -> crate::output::describe_configuration_options_output::Builder {
        crate::output::describe_configuration_options_output::Builder::default()
    }
}

/// <p>Result message wrapping a list of application version descriptions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationVersionsOutput {
    /// <p>List of <code>ApplicationVersionDescription</code> objects sorted in order of creation.</p>
    pub application_versions:
        std::option::Option<std::vec::Vec<crate::model::ApplicationVersionDescription>>,
    /// <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeApplicationVersionsOutput {
    /// <p>List of <code>ApplicationVersionDescription</code> objects sorted in order of creation.</p>
    pub fn application_versions(
        &self,
    ) -> std::option::Option<&[crate::model::ApplicationVersionDescription]> {
        self.application_versions.as_deref()
    }
    /// <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeApplicationVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationVersionsOutput");
        formatter.field("application_versions", &self.application_versions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeApplicationVersionsOutput`](crate::output::DescribeApplicationVersionsOutput)
pub mod describe_application_versions_output {
    /// A builder for [`DescribeApplicationVersionsOutput`](crate::output::DescribeApplicationVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_versions:
            std::option::Option<std::vec::Vec<crate::model::ApplicationVersionDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `application_versions`.
        ///
        /// To override the contents of this collection use [`set_application_versions`](Self::set_application_versions).
        ///
        /// <p>List of <code>ApplicationVersionDescription</code> objects sorted in order of creation.</p>
        pub fn application_versions(
            mut self,
            input: crate::model::ApplicationVersionDescription,
        ) -> Self {
            let mut v = self.application_versions.unwrap_or_default();
            v.push(input);
            self.application_versions = Some(v);
            self
        }
        /// <p>List of <code>ApplicationVersionDescription</code> objects sorted in order of creation.</p>
        pub fn set_application_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationVersionDescription>>,
        ) -> Self {
            self.application_versions = input;
            self
        }
        /// <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationVersionsOutput`](crate::output::DescribeApplicationVersionsOutput)
        pub fn build(self) -> crate::output::DescribeApplicationVersionsOutput {
            crate::output::DescribeApplicationVersionsOutput {
                application_versions: self.application_versions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeApplicationVersionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeApplicationVersionsOutput`](crate::output::DescribeApplicationVersionsOutput)
    pub fn builder() -> crate::output::describe_application_versions_output::Builder {
        crate::output::describe_application_versions_output::Builder::default()
    }
}

/// <p>Result message containing a list of application descriptions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationsOutput {
    /// <p>This parameter contains a list of <code>ApplicationDescription</code>.</p>
    pub applications: std::option::Option<std::vec::Vec<crate::model::ApplicationDescription>>,
}
impl DescribeApplicationsOutput {
    /// <p>This parameter contains a list of <code>ApplicationDescription</code>.</p>
    pub fn applications(&self) -> std::option::Option<&[crate::model::ApplicationDescription]> {
        self.applications.as_deref()
    }
}
impl std::fmt::Debug for DescribeApplicationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationsOutput");
        formatter.field("applications", &self.applications);
        formatter.finish()
    }
}
/// See [`DescribeApplicationsOutput`](crate::output::DescribeApplicationsOutput)
pub mod describe_applications_output {
    /// A builder for [`DescribeApplicationsOutput`](crate::output::DescribeApplicationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) applications:
            std::option::Option<std::vec::Vec<crate::model::ApplicationDescription>>,
    }
    impl Builder {
        /// Appends an item to `applications`.
        ///
        /// To override the contents of this collection use [`set_applications`](Self::set_applications).
        ///
        /// <p>This parameter contains a list of <code>ApplicationDescription</code>.</p>
        pub fn applications(mut self, input: crate::model::ApplicationDescription) -> Self {
            let mut v = self.applications.unwrap_or_default();
            v.push(input);
            self.applications = Some(v);
            self
        }
        /// <p>This parameter contains a list of <code>ApplicationDescription</code>.</p>
        pub fn set_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationDescription>>,
        ) -> Self {
            self.applications = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationsOutput`](crate::output::DescribeApplicationsOutput)
        pub fn build(self) -> crate::output::DescribeApplicationsOutput {
            crate::output::DescribeApplicationsOutput {
                applications: self.applications,
            }
        }
    }
}
impl DescribeApplicationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeApplicationsOutput`](crate::output::DescribeApplicationsOutput)
    pub fn builder() -> crate::output::describe_applications_output::Builder {
        crate::output::describe_applications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountAttributesOutput {
    /// <p>The Elastic Beanstalk resource quotas associated with the calling AWS account.</p>
    pub resource_quotas: std::option::Option<crate::model::ResourceQuotas>,
}
impl DescribeAccountAttributesOutput {
    /// <p>The Elastic Beanstalk resource quotas associated with the calling AWS account.</p>
    pub fn resource_quotas(&self) -> std::option::Option<&crate::model::ResourceQuotas> {
        self.resource_quotas.as_ref()
    }
}
impl std::fmt::Debug for DescribeAccountAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountAttributesOutput");
        formatter.field("resource_quotas", &self.resource_quotas);
        formatter.finish()
    }
}
/// See [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
pub mod describe_account_attributes_output {
    /// A builder for [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_quotas: std::option::Option<crate::model::ResourceQuotas>,
    }
    impl Builder {
        /// <p>The Elastic Beanstalk resource quotas associated with the calling AWS account.</p>
        pub fn resource_quotas(mut self, input: crate::model::ResourceQuotas) -> Self {
            self.resource_quotas = Some(input);
            self
        }
        /// <p>The Elastic Beanstalk resource quotas associated with the calling AWS account.</p>
        pub fn set_resource_quotas(
            mut self,
            input: std::option::Option<crate::model::ResourceQuotas>,
        ) -> Self {
            self.resource_quotas = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
        pub fn build(self) -> crate::output::DescribeAccountAttributesOutput {
            crate::output::DescribeAccountAttributesOutput {
                resource_quotas: self.resource_quotas,
            }
        }
    }
}
impl DescribeAccountAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
    pub fn builder() -> crate::output::describe_account_attributes_output::Builder {
        crate::output::describe_account_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePlatformVersionOutput {
    /// <p>Detailed information about the version of the custom platform.</p>
    pub platform_summary: std::option::Option<crate::model::PlatformSummary>,
}
impl DeletePlatformVersionOutput {
    /// <p>Detailed information about the version of the custom platform.</p>
    pub fn platform_summary(&self) -> std::option::Option<&crate::model::PlatformSummary> {
        self.platform_summary.as_ref()
    }
}
impl std::fmt::Debug for DeletePlatformVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePlatformVersionOutput");
        formatter.field("platform_summary", &self.platform_summary);
        formatter.finish()
    }
}
/// See [`DeletePlatformVersionOutput`](crate::output::DeletePlatformVersionOutput)
pub mod delete_platform_version_output {
    /// A builder for [`DeletePlatformVersionOutput`](crate::output::DeletePlatformVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_summary: std::option::Option<crate::model::PlatformSummary>,
    }
    impl Builder {
        /// <p>Detailed information about the version of the custom platform.</p>
        pub fn platform_summary(mut self, input: crate::model::PlatformSummary) -> Self {
            self.platform_summary = Some(input);
            self
        }
        /// <p>Detailed information about the version of the custom platform.</p>
        pub fn set_platform_summary(
            mut self,
            input: std::option::Option<crate::model::PlatformSummary>,
        ) -> Self {
            self.platform_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePlatformVersionOutput`](crate::output::DeletePlatformVersionOutput)
        pub fn build(self) -> crate::output::DeletePlatformVersionOutput {
            crate::output::DeletePlatformVersionOutput {
                platform_summary: self.platform_summary,
            }
        }
    }
}
impl DeletePlatformVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeletePlatformVersionOutput`](crate::output::DeletePlatformVersionOutput)
    pub fn builder() -> crate::output::delete_platform_version_output::Builder {
        crate::output::delete_platform_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentConfigurationOutput {}
impl std::fmt::Debug for DeleteEnvironmentConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteEnvironmentConfigurationOutput`](crate::output::DeleteEnvironmentConfigurationOutput)
pub mod delete_environment_configuration_output {
    /// A builder for [`DeleteEnvironmentConfigurationOutput`](crate::output::DeleteEnvironmentConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteEnvironmentConfigurationOutput`](crate::output::DeleteEnvironmentConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteEnvironmentConfigurationOutput {
            crate::output::DeleteEnvironmentConfigurationOutput {}
        }
    }
}
impl DeleteEnvironmentConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentConfigurationOutput`](crate::output::DeleteEnvironmentConfigurationOutput)
    pub fn builder() -> crate::output::delete_environment_configuration_output::Builder {
        crate::output::delete_environment_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationTemplateOutput {}
impl std::fmt::Debug for DeleteConfigurationTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationTemplateOutput");
        formatter.finish()
    }
}
/// See [`DeleteConfigurationTemplateOutput`](crate::output::DeleteConfigurationTemplateOutput)
pub mod delete_configuration_template_output {
    /// A builder for [`DeleteConfigurationTemplateOutput`](crate::output::DeleteConfigurationTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteConfigurationTemplateOutput`](crate::output::DeleteConfigurationTemplateOutput)
        pub fn build(self) -> crate::output::DeleteConfigurationTemplateOutput {
            crate::output::DeleteConfigurationTemplateOutput {}
        }
    }
}
impl DeleteConfigurationTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationTemplateOutput`](crate::output::DeleteConfigurationTemplateOutput)
    pub fn builder() -> crate::output::delete_configuration_template_output::Builder {
        crate::output::delete_configuration_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationVersionOutput {}
impl std::fmt::Debug for DeleteApplicationVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationVersionOutput");
        formatter.finish()
    }
}
/// See [`DeleteApplicationVersionOutput`](crate::output::DeleteApplicationVersionOutput)
pub mod delete_application_version_output {
    /// A builder for [`DeleteApplicationVersionOutput`](crate::output::DeleteApplicationVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteApplicationVersionOutput`](crate::output::DeleteApplicationVersionOutput)
        pub fn build(self) -> crate::output::DeleteApplicationVersionOutput {
            crate::output::DeleteApplicationVersionOutput {}
        }
    }
}
impl DeleteApplicationVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteApplicationVersionOutput`](crate::output::DeleteApplicationVersionOutput)
    pub fn builder() -> crate::output::delete_application_version_output::Builder {
        crate::output::delete_application_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationOutput {}
impl std::fmt::Debug for DeleteApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationOutput");
        formatter.finish()
    }
}
/// See [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
pub mod delete_application_output {
    /// A builder for [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
        pub fn build(self) -> crate::output::DeleteApplicationOutput {
            crate::output::DeleteApplicationOutput {}
        }
    }
}
impl DeleteApplicationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    pub fn builder() -> crate::output::delete_application_output::Builder {
        crate::output::delete_application_output::Builder::default()
    }
}

/// <p>Results of a <code>CreateStorageLocationResult</code> call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStorageLocationOutput {
    /// <p>The name of the Amazon S3 bucket created.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
}
impl CreateStorageLocationOutput {
    /// <p>The name of the Amazon S3 bucket created.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
}
impl std::fmt::Debug for CreateStorageLocationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStorageLocationOutput");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.finish()
    }
}
/// See [`CreateStorageLocationOutput`](crate::output::CreateStorageLocationOutput)
pub mod create_storage_location_output {
    /// A builder for [`CreateStorageLocationOutput`](crate::output::CreateStorageLocationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket created.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket created.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStorageLocationOutput`](crate::output::CreateStorageLocationOutput)
        pub fn build(self) -> crate::output::CreateStorageLocationOutput {
            crate::output::CreateStorageLocationOutput {
                s3_bucket: self.s3_bucket,
            }
        }
    }
}
impl CreateStorageLocationOutput {
    /// Creates a new builder-style object to manufacture [`CreateStorageLocationOutput`](crate::output::CreateStorageLocationOutput)
    pub fn builder() -> crate::output::create_storage_location_output::Builder {
        crate::output::create_storage_location_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePlatformVersionOutput {
    /// <p>Detailed information about the new version of the custom platform.</p>
    pub platform_summary: std::option::Option<crate::model::PlatformSummary>,
    /// <p>The builder used to create the custom platform.</p>
    ///
    /// _Note: This member has been renamed from `builder`._
    pub builder_value: std::option::Option<crate::model::Builder>,
}
impl CreatePlatformVersionOutput {
    /// <p>Detailed information about the new version of the custom platform.</p>
    pub fn platform_summary(&self) -> std::option::Option<&crate::model::PlatformSummary> {
        self.platform_summary.as_ref()
    }
    /// <p>The builder used to create the custom platform.</p>
    ///
    /// _Note: This member has been renamed from `builder`._
    pub fn builder_value(&self) -> std::option::Option<&crate::model::Builder> {
        self.builder_value.as_ref()
    }
}
impl std::fmt::Debug for CreatePlatformVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePlatformVersionOutput");
        formatter.field("platform_summary", &self.platform_summary);
        formatter.field("builder_value", &self.builder_value);
        formatter.finish()
    }
}
/// See [`CreatePlatformVersionOutput`](crate::output::CreatePlatformVersionOutput)
pub mod create_platform_version_output {
    /// A builder for [`CreatePlatformVersionOutput`](crate::output::CreatePlatformVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_summary: std::option::Option<crate::model::PlatformSummary>,
        pub(crate) builder_value: std::option::Option<crate::model::Builder>,
    }
    impl Builder {
        /// <p>Detailed information about the new version of the custom platform.</p>
        pub fn platform_summary(mut self, input: crate::model::PlatformSummary) -> Self {
            self.platform_summary = Some(input);
            self
        }
        /// <p>Detailed information about the new version of the custom platform.</p>
        pub fn set_platform_summary(
            mut self,
            input: std::option::Option<crate::model::PlatformSummary>,
        ) -> Self {
            self.platform_summary = input;
            self
        }
        /// <p>The builder used to create the custom platform.</p>
        pub fn builder_value(mut self, input: crate::model::Builder) -> Self {
            self.builder_value = Some(input);
            self
        }
        /// <p>The builder used to create the custom platform.</p>
        pub fn set_builder(mut self, input: std::option::Option<crate::model::Builder>) -> Self {
            self.builder_value = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePlatformVersionOutput`](crate::output::CreatePlatformVersionOutput)
        pub fn build(self) -> crate::output::CreatePlatformVersionOutput {
            crate::output::CreatePlatformVersionOutput {
                platform_summary: self.platform_summary,
                builder_value: self.builder_value,
            }
        }
    }
}
impl CreatePlatformVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreatePlatformVersionOutput`](crate::output::CreatePlatformVersionOutput)
    pub fn builder() -> crate::output::create_platform_version_output::Builder {
        crate::output::create_platform_version_output::Builder::default()
    }
}

/// <p>Describes the properties of an environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentOutput {
    /// <p>The name of this environment.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The ID of this environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the application associated with this environment.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The application version deployed in this environment.</p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the platform version.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>The name of the configuration template used to originally launch this environment.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>Describes this environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
    pub endpoint_url: std::option::Option<std::string::String>,
    /// <p>The URL to the CNAME for this environment.</p>
    pub cname: std::option::Option<std::string::String>,
    /// <p>The creation date for this environment.</p>
    pub date_created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last modified date for this environment.</p>
    pub date_updated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current operational status of the environment:</p>
    /// <ul>
    /// <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>
    /// <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>
    /// <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>
    /// <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>
    /// <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::EnvironmentStatus>,
    /// <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>
    /// <p> <code>true:</code> There is an update in progress. </p>
    /// <p> <code>false:</code> There are no updates currently in progress. </p>
    pub abortable_operation_in_progress: std::option::Option<bool>,
    /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>
    /// <ul>
    /// <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>
    /// <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>
    /// <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>
    /// <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>
    /// </ul>
    /// <p> Default: <code>Grey</code> </p>
    pub health: std::option::Option<crate::model::EnvironmentHealth>,
    /// <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
    pub health_status: std::option::Option<crate::model::EnvironmentHealthStatus>,
    /// <p>The description of the AWS resources used by this environment.</p>
    pub resources: std::option::Option<crate::model::EnvironmentResourcesDescription>,
    /// <p>Describes the current tier of this environment.</p>
    pub tier: std::option::Option<crate::model::EnvironmentTier>,
    /// <p>A list of links to other environments in the same group.</p>
    pub environment_links: std::option::Option<std::vec::Vec<crate::model::EnvironmentLink>>,
    /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
    pub environment_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    pub operations_role: std::option::Option<std::string::String>,
}
impl CreateEnvironmentOutput {
    /// <p>The name of this environment.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The ID of this environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The name of the application associated with this environment.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The application version deployed in this environment.</p>
    pub fn version_label(&self) -> std::option::Option<&str> {
        self.version_label.as_deref()
    }
    /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
    pub fn solution_stack_name(&self) -> std::option::Option<&str> {
        self.solution_stack_name.as_deref()
    }
    /// <p>The ARN of the platform version.</p>
    pub fn platform_arn(&self) -> std::option::Option<&str> {
        self.platform_arn.as_deref()
    }
    /// <p>The name of the configuration template used to originally launch this environment.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>Describes this environment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
    pub fn endpoint_url(&self) -> std::option::Option<&str> {
        self.endpoint_url.as_deref()
    }
    /// <p>The URL to the CNAME for this environment.</p>
    pub fn cname(&self) -> std::option::Option<&str> {
        self.cname.as_deref()
    }
    /// <p>The creation date for this environment.</p>
    pub fn date_created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_created.as_ref()
    }
    /// <p>The last modified date for this environment.</p>
    pub fn date_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_updated.as_ref()
    }
    /// <p>The current operational status of the environment:</p>
    /// <ul>
    /// <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>
    /// <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>
    /// <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>
    /// <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>
    /// <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::EnvironmentStatus> {
        self.status.as_ref()
    }
    /// <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>
    /// <p> <code>true:</code> There is an update in progress. </p>
    /// <p> <code>false:</code> There are no updates currently in progress. </p>
    pub fn abortable_operation_in_progress(&self) -> std::option::Option<bool> {
        self.abortable_operation_in_progress
    }
    /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>
    /// <ul>
    /// <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>
    /// <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>
    /// <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>
    /// <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>
    /// </ul>
    /// <p> Default: <code>Grey</code> </p>
    pub fn health(&self) -> std::option::Option<&crate::model::EnvironmentHealth> {
        self.health.as_ref()
    }
    /// <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
    pub fn health_status(&self) -> std::option::Option<&crate::model::EnvironmentHealthStatus> {
        self.health_status.as_ref()
    }
    /// <p>The description of the AWS resources used by this environment.</p>
    pub fn resources(&self) -> std::option::Option<&crate::model::EnvironmentResourcesDescription> {
        self.resources.as_ref()
    }
    /// <p>Describes the current tier of this environment.</p>
    pub fn tier(&self) -> std::option::Option<&crate::model::EnvironmentTier> {
        self.tier.as_ref()
    }
    /// <p>A list of links to other environments in the same group.</p>
    pub fn environment_links(&self) -> std::option::Option<&[crate::model::EnvironmentLink]> {
        self.environment_links.as_deref()
    }
    /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
    pub fn environment_arn(&self) -> std::option::Option<&str> {
        self.environment_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    pub fn operations_role(&self) -> std::option::Option<&str> {
        self.operations_role.as_deref()
    }
}
impl std::fmt::Debug for CreateEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentOutput");
        formatter.field("environment_name", &self.environment_name);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("application_name", &self.application_name);
        formatter.field("version_label", &self.version_label);
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("template_name", &self.template_name);
        formatter.field("description", &self.description);
        formatter.field("endpoint_url", &self.endpoint_url);
        formatter.field("cname", &self.cname);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("status", &self.status);
        formatter.field(
            "abortable_operation_in_progress",
            &self.abortable_operation_in_progress,
        );
        formatter.field("health", &self.health);
        formatter.field("health_status", &self.health_status);
        formatter.field("resources", &self.resources);
        formatter.field("tier", &self.tier);
        formatter.field("environment_links", &self.environment_links);
        formatter.field("environment_arn", &self.environment_arn);
        formatter.field("operations_role", &self.operations_role);
        formatter.finish()
    }
}
/// See [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
pub mod create_environment_output {
    /// A builder for [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) endpoint_url: std::option::Option<std::string::String>,
        pub(crate) cname: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) date_updated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::EnvironmentStatus>,
        pub(crate) abortable_operation_in_progress: std::option::Option<bool>,
        pub(crate) health: std::option::Option<crate::model::EnvironmentHealth>,
        pub(crate) health_status: std::option::Option<crate::model::EnvironmentHealthStatus>,
        pub(crate) resources: std::option::Option<crate::model::EnvironmentResourcesDescription>,
        pub(crate) tier: std::option::Option<crate::model::EnvironmentTier>,
        pub(crate) environment_links:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentLink>>,
        pub(crate) environment_arn: std::option::Option<std::string::String>,
        pub(crate) operations_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of this environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of this environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The ID of this environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of this environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The name of the application associated with this environment.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application associated with this environment.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The application version deployed in this environment.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>The application version deployed in this environment.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// <p>The name of the configuration template used to originally launch this environment.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration template used to originally launch this environment.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>Describes this environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Describes this environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
        pub fn endpoint_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_url = Some(input.into());
            self
        }
        /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.</p>
        pub fn set_endpoint_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_url = input;
            self
        }
        /// <p>The URL to the CNAME for this environment.</p>
        pub fn cname(mut self, input: impl Into<std::string::String>) -> Self {
            self.cname = Some(input.into());
            self
        }
        /// <p>The URL to the CNAME for this environment.</p>
        pub fn set_cname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cname = input;
            self
        }
        /// <p>The creation date for this environment.</p>
        pub fn date_created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The creation date for this environment.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The last modified date for this environment.</p>
        pub fn date_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_updated = Some(input);
            self
        }
        /// <p>The last modified date for this environment.</p>
        pub fn set_date_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_updated = input;
            self
        }
        /// <p>The current operational status of the environment:</p>
        /// <ul>
        /// <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>
        /// <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>
        /// <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>
        /// <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>
        /// <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::EnvironmentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current operational status of the environment:</p>
        /// <ul>
        /// <li> <p> <code>Launching</code>: Environment is in the process of initial deployment.</p> </li>
        /// <li> <p> <code>Updating</code>: Environment is in the process of updating its configuration settings or application version.</p> </li>
        /// <li> <p> <code>Ready</code>: Environment is available to have an action performed on it, such as update or terminate.</p> </li>
        /// <li> <p> <code>Terminating</code>: Environment is in the shut-down process.</p> </li>
        /// <li> <p> <code>Terminated</code>: Environment is not running.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EnvironmentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>
        /// <p> <code>true:</code> There is an update in progress. </p>
        /// <p> <code>false:</code> There are no updates currently in progress. </p>
        pub fn abortable_operation_in_progress(mut self, input: bool) -> Self {
            self.abortable_operation_in_progress = Some(input);
            self
        }
        /// <p>Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.</p>
        /// <p> <code>true:</code> There is an update in progress. </p>
        /// <p> <code>false:</code> There are no updates currently in progress. </p>
        pub fn set_abortable_operation_in_progress(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.abortable_operation_in_progress = input;
            self
        }
        /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>
        /// <ul>
        /// <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>
        /// <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>
        /// <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>
        /// <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>
        /// </ul>
        /// <p> Default: <code>Grey</code> </p>
        pub fn health(mut self, input: crate::model::EnvironmentHealth) -> Self {
            self.health = Some(input);
            self
        }
        /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:</p>
        /// <ul>
        /// <li> <p> <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.</p> </li>
        /// <li> <p> <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.</p> </li>
        /// <li> <p> <code>Green</code>: Indicates the environment is healthy and fully functional.</p> </li>
        /// <li> <p> <code>Grey</code>: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p> </li>
        /// </ul>
        /// <p> Default: <code>Grey</code> </p>
        pub fn set_health(
            mut self,
            input: std::option::Option<crate::model::EnvironmentHealth>,
        ) -> Self {
            self.health = input;
            self
        }
        /// <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
        pub fn health_status(mut self, input: crate::model::EnvironmentHealthStatus) -> Self {
            self.health_status = Some(input);
            self
        }
        /// <p>Returns the health status of the application running in your environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<crate::model::EnvironmentHealthStatus>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// <p>The description of the AWS resources used by this environment.</p>
        pub fn resources(mut self, input: crate::model::EnvironmentResourcesDescription) -> Self {
            self.resources = Some(input);
            self
        }
        /// <p>The description of the AWS resources used by this environment.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::EnvironmentResourcesDescription>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>Describes the current tier of this environment.</p>
        pub fn tier(mut self, input: crate::model::EnvironmentTier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>Describes the current tier of this environment.</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTier>,
        ) -> Self {
            self.tier = input;
            self
        }
        /// Appends an item to `environment_links`.
        ///
        /// To override the contents of this collection use [`set_environment_links`](Self::set_environment_links).
        ///
        /// <p>A list of links to other environments in the same group.</p>
        pub fn environment_links(mut self, input: crate::model::EnvironmentLink) -> Self {
            let mut v = self.environment_links.unwrap_or_default();
            v.push(input);
            self.environment_links = Some(v);
            self
        }
        /// <p>A list of links to other environments in the same group.</p>
        pub fn set_environment_links(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentLink>>,
        ) -> Self {
            self.environment_links = input;
            self
        }
        /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
        pub fn environment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_arn = Some(input.into());
            self
        }
        /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
        pub fn set_environment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn operations_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.operations_role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn set_operations_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operations_role = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
        pub fn build(self) -> crate::output::CreateEnvironmentOutput {
            crate::output::CreateEnvironmentOutput {
                environment_name: self.environment_name,
                environment_id: self.environment_id,
                application_name: self.application_name,
                version_label: self.version_label,
                solution_stack_name: self.solution_stack_name,
                platform_arn: self.platform_arn,
                template_name: self.template_name,
                description: self.description,
                endpoint_url: self.endpoint_url,
                cname: self.cname,
                date_created: self.date_created,
                date_updated: self.date_updated,
                status: self.status,
                abortable_operation_in_progress: self.abortable_operation_in_progress,
                health: self.health,
                health_status: self.health_status,
                resources: self.resources,
                tier: self.tier,
                environment_links: self.environment_links,
                environment_arn: self.environment_arn,
                operations_role: self.operations_role,
            }
        }
    }
}
impl CreateEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
    pub fn builder() -> crate::output::create_environment_output::Builder {
        crate::output::create_environment_output::Builder::default()
    }
}

/// <p>Describes the settings for a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationTemplateOutput {
    /// <p>The name of the solution stack this configuration set uses.</p>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the platform version.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>The name of the application associated with this configuration set.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p> If not <code>null</code>, the name of the configuration template for this configuration set. </p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>Describes this configuration set.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> If not <code>null</code>, the name of the environment for this configuration set. </p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p> If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter indicates the deployment status of this configuration set: </p>
    /// <ul>
    /// <li> <p> <code>null</code>: This configuration is not associated with a running environment.</p> </li>
    /// <li> <p> <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is in the process of deploying.</p> </li>
    /// <li> <p> <code>deployed</code>: This is the configuration that is currently deployed to the associated running environment.</p> </li>
    /// <li> <p> <code>failed</code>: This is a draft configuration that failed to successfully deploy.</p> </li>
    /// </ul>
    pub deployment_status: std::option::Option<crate::model::ConfigurationDeploymentStatus>,
    /// <p>The date (in UTC time) when this configuration set was created.</p>
    pub date_created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date (in UTC time) when this configuration set was last modified.</p>
    pub date_updated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of the configuration options and their values in this configuration set.</p>
    pub option_settings:
        std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
}
impl CreateConfigurationTemplateOutput {
    /// <p>The name of the solution stack this configuration set uses.</p>
    pub fn solution_stack_name(&self) -> std::option::Option<&str> {
        self.solution_stack_name.as_deref()
    }
    /// <p>The ARN of the platform version.</p>
    pub fn platform_arn(&self) -> std::option::Option<&str> {
        self.platform_arn.as_deref()
    }
    /// <p>The name of the application associated with this configuration set.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p> If not <code>null</code>, the name of the configuration template for this configuration set. </p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>Describes this configuration set.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> If not <code>null</code>, the name of the environment for this configuration set. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p> If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter indicates the deployment status of this configuration set: </p>
    /// <ul>
    /// <li> <p> <code>null</code>: This configuration is not associated with a running environment.</p> </li>
    /// <li> <p> <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is in the process of deploying.</p> </li>
    /// <li> <p> <code>deployed</code>: This is the configuration that is currently deployed to the associated running environment.</p> </li>
    /// <li> <p> <code>failed</code>: This is a draft configuration that failed to successfully deploy.</p> </li>
    /// </ul>
    pub fn deployment_status(
        &self,
    ) -> std::option::Option<&crate::model::ConfigurationDeploymentStatus> {
        self.deployment_status.as_ref()
    }
    /// <p>The date (in UTC time) when this configuration set was created.</p>
    pub fn date_created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_created.as_ref()
    }
    /// <p>The date (in UTC time) when this configuration set was last modified.</p>
    pub fn date_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_updated.as_ref()
    }
    /// <p>A list of the configuration options and their values in this configuration set.</p>
    pub fn option_settings(
        &self,
    ) -> std::option::Option<&[crate::model::ConfigurationOptionSetting]> {
        self.option_settings.as_deref()
    }
}
impl std::fmt::Debug for CreateConfigurationTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationTemplateOutput");
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("application_name", &self.application_name);
        formatter.field("template_name", &self.template_name);
        formatter.field("description", &self.description);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("option_settings", &self.option_settings);
        formatter.finish()
    }
}
/// See [`CreateConfigurationTemplateOutput`](crate::output::CreateConfigurationTemplateOutput)
pub mod create_configuration_template_output {
    /// A builder for [`CreateConfigurationTemplateOutput`](crate::output::CreateConfigurationTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) deployment_status:
            std::option::Option<crate::model::ConfigurationDeploymentStatus>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) date_updated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) option_settings:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
    }
    impl Builder {
        /// <p>The name of the solution stack this configuration set uses.</p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p>The name of the solution stack this configuration set uses.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// <p>The name of the application associated with this configuration set.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application associated with this configuration set.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p> If not <code>null</code>, the name of the configuration template for this configuration set. </p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p> If not <code>null</code>, the name of the configuration template for this configuration set. </p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>Describes this configuration set.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Describes this configuration set.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> If not <code>null</code>, the name of the environment for this configuration set. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p> If not <code>null</code>, the name of the environment for this configuration set. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p> If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter indicates the deployment status of this configuration set: </p>
        /// <ul>
        /// <li> <p> <code>null</code>: This configuration is not associated with a running environment.</p> </li>
        /// <li> <p> <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is in the process of deploying.</p> </li>
        /// <li> <p> <code>deployed</code>: This is the configuration that is currently deployed to the associated running environment.</p> </li>
        /// <li> <p> <code>failed</code>: This is a draft configuration that failed to successfully deploy.</p> </li>
        /// </ul>
        pub fn deployment_status(
            mut self,
            input: crate::model::ConfigurationDeploymentStatus,
        ) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p> If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter indicates the deployment status of this configuration set: </p>
        /// <ul>
        /// <li> <p> <code>null</code>: This configuration is not associated with a running environment.</p> </li>
        /// <li> <p> <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is in the process of deploying.</p> </li>
        /// <li> <p> <code>deployed</code>: This is the configuration that is currently deployed to the associated running environment.</p> </li>
        /// <li> <p> <code>failed</code>: This is a draft configuration that failed to successfully deploy.</p> </li>
        /// </ul>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationDeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>The date (in UTC time) when this configuration set was created.</p>
        pub fn date_created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The date (in UTC time) when this configuration set was created.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The date (in UTC time) when this configuration set was last modified.</p>
        pub fn date_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_updated = Some(input);
            self
        }
        /// <p>The date (in UTC time) when this configuration set was last modified.</p>
        pub fn set_date_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_updated = input;
            self
        }
        /// Appends an item to `option_settings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>A list of the configuration options and their values in this configuration set.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            let mut v = self.option_settings.unwrap_or_default();
            v.push(input);
            self.option_settings = Some(v);
            self
        }
        /// <p>A list of the configuration options and their values in this configuration set.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.option_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationTemplateOutput`](crate::output::CreateConfigurationTemplateOutput)
        pub fn build(self) -> crate::output::CreateConfigurationTemplateOutput {
            crate::output::CreateConfigurationTemplateOutput {
                solution_stack_name: self.solution_stack_name,
                platform_arn: self.platform_arn,
                application_name: self.application_name,
                template_name: self.template_name,
                description: self.description,
                environment_name: self.environment_name,
                deployment_status: self.deployment_status,
                date_created: self.date_created,
                date_updated: self.date_updated,
                option_settings: self.option_settings,
            }
        }
    }
}
impl CreateConfigurationTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationTemplateOutput`](crate::output::CreateConfigurationTemplateOutput)
    pub fn builder() -> crate::output::create_configuration_template_output::Builder {
        crate::output::create_configuration_template_output::Builder::default()
    }
}

/// <p>Result message wrapping a single description of an application version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationVersionOutput {
    /// <p> The <code>ApplicationVersionDescription</code> of the application version. </p>
    pub application_version: std::option::Option<crate::model::ApplicationVersionDescription>,
}
impl CreateApplicationVersionOutput {
    /// <p> The <code>ApplicationVersionDescription</code> of the application version. </p>
    pub fn application_version(
        &self,
    ) -> std::option::Option<&crate::model::ApplicationVersionDescription> {
        self.application_version.as_ref()
    }
}
impl std::fmt::Debug for CreateApplicationVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationVersionOutput");
        formatter.field("application_version", &self.application_version);
        formatter.finish()
    }
}
/// See [`CreateApplicationVersionOutput`](crate::output::CreateApplicationVersionOutput)
pub mod create_application_version_output {
    /// A builder for [`CreateApplicationVersionOutput`](crate::output::CreateApplicationVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_version:
            std::option::Option<crate::model::ApplicationVersionDescription>,
    }
    impl Builder {
        /// <p> The <code>ApplicationVersionDescription</code> of the application version. </p>
        pub fn application_version(
            mut self,
            input: crate::model::ApplicationVersionDescription,
        ) -> Self {
            self.application_version = Some(input);
            self
        }
        /// <p> The <code>ApplicationVersionDescription</code> of the application version. </p>
        pub fn set_application_version(
            mut self,
            input: std::option::Option<crate::model::ApplicationVersionDescription>,
        ) -> Self {
            self.application_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationVersionOutput`](crate::output::CreateApplicationVersionOutput)
        pub fn build(self) -> crate::output::CreateApplicationVersionOutput {
            crate::output::CreateApplicationVersionOutput {
                application_version: self.application_version,
            }
        }
    }
}
impl CreateApplicationVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateApplicationVersionOutput`](crate::output::CreateApplicationVersionOutput)
    pub fn builder() -> crate::output::create_application_version_output::Builder {
        crate::output::create_application_version_output::Builder::default()
    }
}

/// <p>Result message containing a single description of an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationOutput {
    /// <p> The <code>ApplicationDescription</code> of the application. </p>
    pub application: std::option::Option<crate::model::ApplicationDescription>,
}
impl CreateApplicationOutput {
    /// <p> The <code>ApplicationDescription</code> of the application. </p>
    pub fn application(&self) -> std::option::Option<&crate::model::ApplicationDescription> {
        self.application.as_ref()
    }
}
impl std::fmt::Debug for CreateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationOutput");
        formatter.field("application", &self.application);
        formatter.finish()
    }
}
/// See [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
pub mod create_application_output {
    /// A builder for [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<crate::model::ApplicationDescription>,
    }
    impl Builder {
        /// <p> The <code>ApplicationDescription</code> of the application. </p>
        pub fn application(mut self, input: crate::model::ApplicationDescription) -> Self {
            self.application = Some(input);
            self
        }
        /// <p> The <code>ApplicationDescription</code> of the application. </p>
        pub fn set_application(
            mut self,
            input: std::option::Option<crate::model::ApplicationDescription>,
        ) -> Self {
            self.application = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
        pub fn build(self) -> crate::output::CreateApplicationOutput {
            crate::output::CreateApplicationOutput {
                application: self.application,
            }
        }
    }
}
impl CreateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    pub fn builder() -> crate::output::create_application_output::Builder {
        crate::output::create_application_output::Builder::default()
    }
}

/// <p>Result message containing a list of environment descriptions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComposeEnvironmentsOutput {
    /// <p> Returns an <code>EnvironmentDescription</code> list. </p>
    pub environments: std::option::Option<std::vec::Vec<crate::model::EnvironmentDescription>>,
    /// <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ComposeEnvironmentsOutput {
    /// <p> Returns an <code>EnvironmentDescription</code> list. </p>
    pub fn environments(&self) -> std::option::Option<&[crate::model::EnvironmentDescription]> {
        self.environments.as_deref()
    }
    /// <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ComposeEnvironmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComposeEnvironmentsOutput");
        formatter.field("environments", &self.environments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ComposeEnvironmentsOutput`](crate::output::ComposeEnvironmentsOutput)
pub mod compose_environments_output {
    /// A builder for [`ComposeEnvironmentsOutput`](crate::output::ComposeEnvironmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environments:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `environments`.
        ///
        /// To override the contents of this collection use [`set_environments`](Self::set_environments).
        ///
        /// <p> Returns an <code>EnvironmentDescription</code> list. </p>
        pub fn environments(mut self, input: crate::model::EnvironmentDescription) -> Self {
            let mut v = self.environments.unwrap_or_default();
            v.push(input);
            self.environments = Some(v);
            self
        }
        /// <p> Returns an <code>EnvironmentDescription</code> list. </p>
        pub fn set_environments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentDescription>>,
        ) -> Self {
            self.environments = input;
            self
        }
        /// <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>In a paginated request, the token that you can pass in a subsequent request to get the next response page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ComposeEnvironmentsOutput`](crate::output::ComposeEnvironmentsOutput)
        pub fn build(self) -> crate::output::ComposeEnvironmentsOutput {
            crate::output::ComposeEnvironmentsOutput {
                environments: self.environments,
                next_token: self.next_token,
            }
        }
    }
}
impl ComposeEnvironmentsOutput {
    /// Creates a new builder-style object to manufacture [`ComposeEnvironmentsOutput`](crate::output::ComposeEnvironmentsOutput)
    pub fn builder() -> crate::output::compose_environments_output::Builder {
        crate::output::compose_environments_output::Builder::default()
    }
}

/// <p>Indicates if the specified CNAME is available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CheckDnsAvailabilityOutput {
    /// <p>Indicates if the specified CNAME is available:</p>
    /// <ul>
    /// <li> <p> <code>true</code> : The CNAME is available.</p> </li>
    /// <li> <p> <code>false</code> : The CNAME is not available.</p> </li>
    /// </ul>
    pub available: std::option::Option<bool>,
    /// <p>The fully qualified CNAME to reserve when <code>CreateEnvironment</code> is called with the provided prefix.</p>
    pub fully_qualified_cname: std::option::Option<std::string::String>,
}
impl CheckDnsAvailabilityOutput {
    /// <p>Indicates if the specified CNAME is available:</p>
    /// <ul>
    /// <li> <p> <code>true</code> : The CNAME is available.</p> </li>
    /// <li> <p> <code>false</code> : The CNAME is not available.</p> </li>
    /// </ul>
    pub fn available(&self) -> std::option::Option<bool> {
        self.available
    }
    /// <p>The fully qualified CNAME to reserve when <code>CreateEnvironment</code> is called with the provided prefix.</p>
    pub fn fully_qualified_cname(&self) -> std::option::Option<&str> {
        self.fully_qualified_cname.as_deref()
    }
}
impl std::fmt::Debug for CheckDnsAvailabilityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CheckDnsAvailabilityOutput");
        formatter.field("available", &self.available);
        formatter.field("fully_qualified_cname", &self.fully_qualified_cname);
        formatter.finish()
    }
}
/// See [`CheckDnsAvailabilityOutput`](crate::output::CheckDnsAvailabilityOutput)
pub mod check_dns_availability_output {
    /// A builder for [`CheckDnsAvailabilityOutput`](crate::output::CheckDnsAvailabilityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) available: std::option::Option<bool>,
        pub(crate) fully_qualified_cname: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates if the specified CNAME is available:</p>
        /// <ul>
        /// <li> <p> <code>true</code> : The CNAME is available.</p> </li>
        /// <li> <p> <code>false</code> : The CNAME is not available.</p> </li>
        /// </ul>
        pub fn available(mut self, input: bool) -> Self {
            self.available = Some(input);
            self
        }
        /// <p>Indicates if the specified CNAME is available:</p>
        /// <ul>
        /// <li> <p> <code>true</code> : The CNAME is available.</p> </li>
        /// <li> <p> <code>false</code> : The CNAME is not available.</p> </li>
        /// </ul>
        pub fn set_available(mut self, input: std::option::Option<bool>) -> Self {
            self.available = input;
            self
        }
        /// <p>The fully qualified CNAME to reserve when <code>CreateEnvironment</code> is called with the provided prefix.</p>
        pub fn fully_qualified_cname(mut self, input: impl Into<std::string::String>) -> Self {
            self.fully_qualified_cname = Some(input.into());
            self
        }
        /// <p>The fully qualified CNAME to reserve when <code>CreateEnvironment</code> is called with the provided prefix.</p>
        pub fn set_fully_qualified_cname(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fully_qualified_cname = input;
            self
        }
        /// Consumes the builder and constructs a [`CheckDnsAvailabilityOutput`](crate::output::CheckDnsAvailabilityOutput)
        pub fn build(self) -> crate::output::CheckDnsAvailabilityOutput {
            crate::output::CheckDnsAvailabilityOutput {
                available: self.available,
                fully_qualified_cname: self.fully_qualified_cname,
            }
        }
    }
}
impl CheckDnsAvailabilityOutput {
    /// Creates a new builder-style object to manufacture [`CheckDnsAvailabilityOutput`](crate::output::CheckDnsAvailabilityOutput)
    pub fn builder() -> crate::output::check_dns_availability_output::Builder {
        crate::output::check_dns_availability_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateEnvironmentOperationsRoleOutput {}
impl std::fmt::Debug for AssociateEnvironmentOperationsRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateEnvironmentOperationsRoleOutput");
        formatter.finish()
    }
}
/// See [`AssociateEnvironmentOperationsRoleOutput`](crate::output::AssociateEnvironmentOperationsRoleOutput)
pub mod associate_environment_operations_role_output {
    /// A builder for [`AssociateEnvironmentOperationsRoleOutput`](crate::output::AssociateEnvironmentOperationsRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateEnvironmentOperationsRoleOutput`](crate::output::AssociateEnvironmentOperationsRoleOutput)
        pub fn build(self) -> crate::output::AssociateEnvironmentOperationsRoleOutput {
            crate::output::AssociateEnvironmentOperationsRoleOutput {}
        }
    }
}
impl AssociateEnvironmentOperationsRoleOutput {
    /// Creates a new builder-style object to manufacture [`AssociateEnvironmentOperationsRoleOutput`](crate::output::AssociateEnvironmentOperationsRoleOutput)
    pub fn builder() -> crate::output::associate_environment_operations_role_output::Builder {
        crate::output::associate_environment_operations_role_output::Builder::default()
    }
}

/// <p>The result message containing information about the managed action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplyEnvironmentManagedActionOutput {
    /// <p>The action ID of the managed action.</p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p>A description of the managed action.</p>
    pub action_description: std::option::Option<std::string::String>,
    /// <p>The type of managed action.</p>
    pub action_type: std::option::Option<crate::model::ActionType>,
    /// <p>The status of the managed action.</p>
    pub status: std::option::Option<std::string::String>,
}
impl ApplyEnvironmentManagedActionOutput {
    /// <p>The action ID of the managed action.</p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
    /// <p>A description of the managed action.</p>
    pub fn action_description(&self) -> std::option::Option<&str> {
        self.action_description.as_deref()
    }
    /// <p>The type of managed action.</p>
    pub fn action_type(&self) -> std::option::Option<&crate::model::ActionType> {
        self.action_type.as_ref()
    }
    /// <p>The status of the managed action.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for ApplyEnvironmentManagedActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplyEnvironmentManagedActionOutput");
        formatter.field("action_id", &self.action_id);
        formatter.field("action_description", &self.action_description);
        formatter.field("action_type", &self.action_type);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ApplyEnvironmentManagedActionOutput`](crate::output::ApplyEnvironmentManagedActionOutput)
pub mod apply_environment_managed_action_output {
    /// A builder for [`ApplyEnvironmentManagedActionOutput`](crate::output::ApplyEnvironmentManagedActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) action_description: std::option::Option<std::string::String>,
        pub(crate) action_type: std::option::Option<crate::model::ActionType>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action ID of the managed action.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>The action ID of the managed action.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p>A description of the managed action.</p>
        pub fn action_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_description = Some(input.into());
            self
        }
        /// <p>A description of the managed action.</p>
        pub fn set_action_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_description = input;
            self
        }
        /// <p>The type of managed action.</p>
        pub fn action_type(mut self, input: crate::model::ActionType) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>The type of managed action.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionType>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// <p>The status of the managed action.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the managed action.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplyEnvironmentManagedActionOutput`](crate::output::ApplyEnvironmentManagedActionOutput)
        pub fn build(self) -> crate::output::ApplyEnvironmentManagedActionOutput {
            crate::output::ApplyEnvironmentManagedActionOutput {
                action_id: self.action_id,
                action_description: self.action_description,
                action_type: self.action_type,
                status: self.status,
            }
        }
    }
}
impl ApplyEnvironmentManagedActionOutput {
    /// Creates a new builder-style object to manufacture [`ApplyEnvironmentManagedActionOutput`](crate::output::ApplyEnvironmentManagedActionOutput)
    pub fn builder() -> crate::output::apply_environment_managed_action_output::Builder {
        crate::output::apply_environment_managed_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortEnvironmentUpdateOutput {}
impl std::fmt::Debug for AbortEnvironmentUpdateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortEnvironmentUpdateOutput");
        formatter.finish()
    }
}
/// See [`AbortEnvironmentUpdateOutput`](crate::output::AbortEnvironmentUpdateOutput)
pub mod abort_environment_update_output {
    /// A builder for [`AbortEnvironmentUpdateOutput`](crate::output::AbortEnvironmentUpdateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AbortEnvironmentUpdateOutput`](crate::output::AbortEnvironmentUpdateOutput)
        pub fn build(self) -> crate::output::AbortEnvironmentUpdateOutput {
            crate::output::AbortEnvironmentUpdateOutput {}
        }
    }
}
impl AbortEnvironmentUpdateOutput {
    /// Creates a new builder-style object to manufacture [`AbortEnvironmentUpdateOutput`](crate::output::AbortEnvironmentUpdateOutput)
    pub fn builder() -> crate::output::abort_environment_update_output::Builder {
        crate::output::abort_environment_update_output::Builder::default()
    }
}
