// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Elastic Beanstalk
///
/// Client for invoking operations on AWS Elastic Beanstalk. Each operation on AWS Elastic Beanstalk is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_elasticbeanstalk::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_elasticbeanstalk::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_elasticbeanstalk::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AbortEnvironmentUpdate` operation.
    ///
    /// See [`AbortEnvironmentUpdate`](crate::client::fluent_builders::AbortEnvironmentUpdate) for more information about the
    /// operation and its arguments.
    pub fn abort_environment_update(&self) -> fluent_builders::AbortEnvironmentUpdate<C, M, R> {
        fluent_builders::AbortEnvironmentUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ApplyEnvironmentManagedAction` operation.
    ///
    /// See [`ApplyEnvironmentManagedAction`](crate::client::fluent_builders::ApplyEnvironmentManagedAction) for more information about the
    /// operation and its arguments.
    pub fn apply_environment_managed_action(
        &self,
    ) -> fluent_builders::ApplyEnvironmentManagedAction<C, M, R> {
        fluent_builders::ApplyEnvironmentManagedAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateEnvironmentOperationsRole` operation.
    ///
    /// See [`AssociateEnvironmentOperationsRole`](crate::client::fluent_builders::AssociateEnvironmentOperationsRole) for more information about the
    /// operation and its arguments.
    pub fn associate_environment_operations_role(
        &self,
    ) -> fluent_builders::AssociateEnvironmentOperationsRole<C, M, R> {
        fluent_builders::AssociateEnvironmentOperationsRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CheckDNSAvailability` operation.
    ///
    /// See [`CheckDNSAvailability`](crate::client::fluent_builders::CheckDNSAvailability) for more information about the
    /// operation and its arguments.
    pub fn check_dns_availability(&self) -> fluent_builders::CheckDNSAvailability<C, M, R> {
        fluent_builders::CheckDNSAvailability::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ComposeEnvironments` operation.
    ///
    /// See [`ComposeEnvironments`](crate::client::fluent_builders::ComposeEnvironments) for more information about the
    /// operation and its arguments.
    pub fn compose_environments(&self) -> fluent_builders::ComposeEnvironments<C, M, R> {
        fluent_builders::ComposeEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateApplication` operation.
    ///
    /// See [`CreateApplication`](crate::client::fluent_builders::CreateApplication) for more information about the
    /// operation and its arguments.
    pub fn create_application(&self) -> fluent_builders::CreateApplication<C, M, R> {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateApplicationVersion` operation.
    ///
    /// See [`CreateApplicationVersion`](crate::client::fluent_builders::CreateApplicationVersion) for more information about the
    /// operation and its arguments.
    pub fn create_application_version(&self) -> fluent_builders::CreateApplicationVersion<C, M, R> {
        fluent_builders::CreateApplicationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConfigurationTemplate` operation.
    ///
    /// See [`CreateConfigurationTemplate`](crate::client::fluent_builders::CreateConfigurationTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_configuration_template(
        &self,
    ) -> fluent_builders::CreateConfigurationTemplate<C, M, R> {
        fluent_builders::CreateConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEnvironment` operation.
    ///
    /// See [`CreateEnvironment`](crate::client::fluent_builders::CreateEnvironment) for more information about the
    /// operation and its arguments.
    pub fn create_environment(&self) -> fluent_builders::CreateEnvironment<C, M, R> {
        fluent_builders::CreateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePlatformVersion` operation.
    ///
    /// See [`CreatePlatformVersion`](crate::client::fluent_builders::CreatePlatformVersion) for more information about the
    /// operation and its arguments.
    pub fn create_platform_version(&self) -> fluent_builders::CreatePlatformVersion<C, M, R> {
        fluent_builders::CreatePlatformVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStorageLocation` operation.
    ///
    /// See [`CreateStorageLocation`](crate::client::fluent_builders::CreateStorageLocation) for more information about the
    /// operation and its arguments.
    pub fn create_storage_location(&self) -> fluent_builders::CreateStorageLocation<C, M, R> {
        fluent_builders::CreateStorageLocation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApplication` operation.
    ///
    /// See [`DeleteApplication`](crate::client::fluent_builders::DeleteApplication) for more information about the
    /// operation and its arguments.
    pub fn delete_application(&self) -> fluent_builders::DeleteApplication<C, M, R> {
        fluent_builders::DeleteApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApplicationVersion` operation.
    ///
    /// See [`DeleteApplicationVersion`](crate::client::fluent_builders::DeleteApplicationVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_application_version(&self) -> fluent_builders::DeleteApplicationVersion<C, M, R> {
        fluent_builders::DeleteApplicationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConfigurationTemplate` operation.
    ///
    /// See [`DeleteConfigurationTemplate`](crate::client::fluent_builders::DeleteConfigurationTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_configuration_template(
        &self,
    ) -> fluent_builders::DeleteConfigurationTemplate<C, M, R> {
        fluent_builders::DeleteConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEnvironmentConfiguration` operation.
    ///
    /// See [`DeleteEnvironmentConfiguration`](crate::client::fluent_builders::DeleteEnvironmentConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_environment_configuration(
        &self,
    ) -> fluent_builders::DeleteEnvironmentConfiguration<C, M, R> {
        fluent_builders::DeleteEnvironmentConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePlatformVersion` operation.
    ///
    /// See [`DeletePlatformVersion`](crate::client::fluent_builders::DeletePlatformVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_platform_version(&self) -> fluent_builders::DeletePlatformVersion<C, M, R> {
        fluent_builders::DeletePlatformVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountAttributes` operation.
    ///
    /// See [`DescribeAccountAttributes`](crate::client::fluent_builders::DescribeAccountAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_account_attributes(
        &self,
    ) -> fluent_builders::DescribeAccountAttributes<C, M, R> {
        fluent_builders::DescribeAccountAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeApplications` operation.
    ///
    /// See [`DescribeApplications`](crate::client::fluent_builders::DescribeApplications) for more information about the
    /// operation and its arguments.
    pub fn describe_applications(&self) -> fluent_builders::DescribeApplications<C, M, R> {
        fluent_builders::DescribeApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeApplicationVersions` operation.
    ///
    /// See [`DescribeApplicationVersions`](crate::client::fluent_builders::DescribeApplicationVersions) for more information about the
    /// operation and its arguments.
    pub fn describe_application_versions(
        &self,
    ) -> fluent_builders::DescribeApplicationVersions<C, M, R> {
        fluent_builders::DescribeApplicationVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConfigurationOptions` operation.
    ///
    /// See [`DescribeConfigurationOptions`](crate::client::fluent_builders::DescribeConfigurationOptions) for more information about the
    /// operation and its arguments.
    pub fn describe_configuration_options(
        &self,
    ) -> fluent_builders::DescribeConfigurationOptions<C, M, R> {
        fluent_builders::DescribeConfigurationOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConfigurationSettings` operation.
    ///
    /// See [`DescribeConfigurationSettings`](crate::client::fluent_builders::DescribeConfigurationSettings) for more information about the
    /// operation and its arguments.
    pub fn describe_configuration_settings(
        &self,
    ) -> fluent_builders::DescribeConfigurationSettings<C, M, R> {
        fluent_builders::DescribeConfigurationSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEnvironmentHealth` operation.
    ///
    /// See [`DescribeEnvironmentHealth`](crate::client::fluent_builders::DescribeEnvironmentHealth) for more information about the
    /// operation and its arguments.
    pub fn describe_environment_health(
        &self,
    ) -> fluent_builders::DescribeEnvironmentHealth<C, M, R> {
        fluent_builders::DescribeEnvironmentHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEnvironmentManagedActionHistory` operation.
    ///
    /// See [`DescribeEnvironmentManagedActionHistory`](crate::client::fluent_builders::DescribeEnvironmentManagedActionHistory) for more information about the
    /// operation and its arguments.
    pub fn describe_environment_managed_action_history(
        &self,
    ) -> fluent_builders::DescribeEnvironmentManagedActionHistory<C, M, R> {
        fluent_builders::DescribeEnvironmentManagedActionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEnvironmentManagedActions` operation.
    ///
    /// See [`DescribeEnvironmentManagedActions`](crate::client::fluent_builders::DescribeEnvironmentManagedActions) for more information about the
    /// operation and its arguments.
    pub fn describe_environment_managed_actions(
        &self,
    ) -> fluent_builders::DescribeEnvironmentManagedActions<C, M, R> {
        fluent_builders::DescribeEnvironmentManagedActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEnvironmentResources` operation.
    ///
    /// See [`DescribeEnvironmentResources`](crate::client::fluent_builders::DescribeEnvironmentResources) for more information about the
    /// operation and its arguments.
    pub fn describe_environment_resources(
        &self,
    ) -> fluent_builders::DescribeEnvironmentResources<C, M, R> {
        fluent_builders::DescribeEnvironmentResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEnvironments` operation.
    ///
    /// See [`DescribeEnvironments`](crate::client::fluent_builders::DescribeEnvironments) for more information about the
    /// operation and its arguments.
    pub fn describe_environments(&self) -> fluent_builders::DescribeEnvironments<C, M, R> {
        fluent_builders::DescribeEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEvents` operation.
    ///
    /// See [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) for more information about the
    /// operation and its arguments.
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents<C, M, R> {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstancesHealth` operation.
    ///
    /// See [`DescribeInstancesHealth`](crate::client::fluent_builders::DescribeInstancesHealth) for more information about the
    /// operation and its arguments.
    pub fn describe_instances_health(&self) -> fluent_builders::DescribeInstancesHealth<C, M, R> {
        fluent_builders::DescribeInstancesHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePlatformVersion` operation.
    ///
    /// See [`DescribePlatformVersion`](crate::client::fluent_builders::DescribePlatformVersion) for more information about the
    /// operation and its arguments.
    pub fn describe_platform_version(&self) -> fluent_builders::DescribePlatformVersion<C, M, R> {
        fluent_builders::DescribePlatformVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateEnvironmentOperationsRole` operation.
    ///
    /// See [`DisassociateEnvironmentOperationsRole`](crate::client::fluent_builders::DisassociateEnvironmentOperationsRole) for more information about the
    /// operation and its arguments.
    pub fn disassociate_environment_operations_role(
        &self,
    ) -> fluent_builders::DisassociateEnvironmentOperationsRole<C, M, R> {
        fluent_builders::DisassociateEnvironmentOperationsRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAvailableSolutionStacks` operation.
    ///
    /// See [`ListAvailableSolutionStacks`](crate::client::fluent_builders::ListAvailableSolutionStacks) for more information about the
    /// operation and its arguments.
    pub fn list_available_solution_stacks(
        &self,
    ) -> fluent_builders::ListAvailableSolutionStacks<C, M, R> {
        fluent_builders::ListAvailableSolutionStacks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPlatformBranches` operation.
    ///
    /// See [`ListPlatformBranches`](crate::client::fluent_builders::ListPlatformBranches) for more information about the
    /// operation and its arguments.
    pub fn list_platform_branches(&self) -> fluent_builders::ListPlatformBranches<C, M, R> {
        fluent_builders::ListPlatformBranches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPlatformVersions` operation.
    ///
    /// See [`ListPlatformVersions`](crate::client::fluent_builders::ListPlatformVersions) for more information about the
    /// operation and its arguments.
    pub fn list_platform_versions(&self) -> fluent_builders::ListPlatformVersions<C, M, R> {
        fluent_builders::ListPlatformVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RebuildEnvironment` operation.
    ///
    /// See [`RebuildEnvironment`](crate::client::fluent_builders::RebuildEnvironment) for more information about the
    /// operation and its arguments.
    pub fn rebuild_environment(&self) -> fluent_builders::RebuildEnvironment<C, M, R> {
        fluent_builders::RebuildEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RequestEnvironmentInfo` operation.
    ///
    /// See [`RequestEnvironmentInfo`](crate::client::fluent_builders::RequestEnvironmentInfo) for more information about the
    /// operation and its arguments.
    pub fn request_environment_info(&self) -> fluent_builders::RequestEnvironmentInfo<C, M, R> {
        fluent_builders::RequestEnvironmentInfo::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestartAppServer` operation.
    ///
    /// See [`RestartAppServer`](crate::client::fluent_builders::RestartAppServer) for more information about the
    /// operation and its arguments.
    pub fn restart_app_server(&self) -> fluent_builders::RestartAppServer<C, M, R> {
        fluent_builders::RestartAppServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RetrieveEnvironmentInfo` operation.
    ///
    /// See [`RetrieveEnvironmentInfo`](crate::client::fluent_builders::RetrieveEnvironmentInfo) for more information about the
    /// operation and its arguments.
    pub fn retrieve_environment_info(&self) -> fluent_builders::RetrieveEnvironmentInfo<C, M, R> {
        fluent_builders::RetrieveEnvironmentInfo::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SwapEnvironmentCNAMEs` operation.
    ///
    /// See [`SwapEnvironmentCNAMEs`](crate::client::fluent_builders::SwapEnvironmentCNAMEs) for more information about the
    /// operation and its arguments.
    pub fn swap_environment_cnam_es(&self) -> fluent_builders::SwapEnvironmentCNAMEs<C, M, R> {
        fluent_builders::SwapEnvironmentCNAMEs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TerminateEnvironment` operation.
    ///
    /// See [`TerminateEnvironment`](crate::client::fluent_builders::TerminateEnvironment) for more information about the
    /// operation and its arguments.
    pub fn terminate_environment(&self) -> fluent_builders::TerminateEnvironment<C, M, R> {
        fluent_builders::TerminateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApplication` operation.
    ///
    /// See [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) for more information about the
    /// operation and its arguments.
    pub fn update_application(&self) -> fluent_builders::UpdateApplication<C, M, R> {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApplicationResourceLifecycle` operation.
    ///
    /// See [`UpdateApplicationResourceLifecycle`](crate::client::fluent_builders::UpdateApplicationResourceLifecycle) for more information about the
    /// operation and its arguments.
    pub fn update_application_resource_lifecycle(
        &self,
    ) -> fluent_builders::UpdateApplicationResourceLifecycle<C, M, R> {
        fluent_builders::UpdateApplicationResourceLifecycle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApplicationVersion` operation.
    ///
    /// See [`UpdateApplicationVersion`](crate::client::fluent_builders::UpdateApplicationVersion) for more information about the
    /// operation and its arguments.
    pub fn update_application_version(&self) -> fluent_builders::UpdateApplicationVersion<C, M, R> {
        fluent_builders::UpdateApplicationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConfigurationTemplate` operation.
    ///
    /// See [`UpdateConfigurationTemplate`](crate::client::fluent_builders::UpdateConfigurationTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_configuration_template(
        &self,
    ) -> fluent_builders::UpdateConfigurationTemplate<C, M, R> {
        fluent_builders::UpdateConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEnvironment` operation.
    ///
    /// See [`UpdateEnvironment`](crate::client::fluent_builders::UpdateEnvironment) for more information about the
    /// operation and its arguments.
    pub fn update_environment(&self) -> fluent_builders::UpdateEnvironment<C, M, R> {
        fluent_builders::UpdateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTagsForResource` operation.
    ///
    /// See [`UpdateTagsForResource`](crate::client::fluent_builders::UpdateTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn update_tags_for_resource(&self) -> fluent_builders::UpdateTagsForResource<C, M, R> {
        fluent_builders::UpdateTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ValidateConfigurationSettings` operation.
    ///
    /// See [`ValidateConfigurationSettings`](crate::client::fluent_builders::ValidateConfigurationSettings) for more information about the
    /// operation and its arguments.
    pub fn validate_configuration_settings(
        &self,
    ) -> fluent_builders::ValidateConfigurationSettings<C, M, R> {
        fluent_builders::ValidateConfigurationSettings::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AbortEnvironmentUpdate`.
    ///
    /// <p>Cancels in-progress environment configuration update or application version
    /// deployment.</p>
    #[derive(std::fmt::Debug)]
    pub struct AbortEnvironmentUpdate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::abort_environment_update_input::Builder,
    }
    impl<C, M, R> AbortEnvironmentUpdate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AbortEnvironmentUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AbortEnvironmentUpdateOutput,
            aws_smithy_http::result::SdkError<crate::error::AbortEnvironmentUpdateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AbortEnvironmentUpdateInputOperationOutputAlias,
                crate::output::AbortEnvironmentUpdateOutput,
                crate::error::AbortEnvironmentUpdateError,
                crate::input::AbortEnvironmentUpdateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This specifies the ID of the environment with the in-progress update that you want to
        /// cancel.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>This specifies the ID of the environment with the in-progress update that you want to
        /// cancel.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>This specifies the name of the environment with the in-progress update that you want to
        /// cancel.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>This specifies the name of the environment with the in-progress update that you want to
        /// cancel.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApplyEnvironmentManagedAction`.
    ///
    /// <p>Applies a scheduled managed action immediately. A managed action can be applied only if
    /// its status is <code>Scheduled</code>. Get the status and action ID of a managed action with
    /// <a>DescribeEnvironmentManagedActions</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ApplyEnvironmentManagedAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::apply_environment_managed_action_input::Builder,
    }
    impl<C, M, R> ApplyEnvironmentManagedAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ApplyEnvironmentManagedAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplyEnvironmentManagedActionOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplyEnvironmentManagedActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ApplyEnvironmentManagedActionInputOperationOutputAlias,
                crate::output::ApplyEnvironmentManagedActionOutput,
                crate::error::ApplyEnvironmentManagedActionError,
                crate::input::ApplyEnvironmentManagedActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the target environment.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the target environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The action ID of the scheduled managed action to execute.</p>
        pub fn action_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_id(inp);
            self
        }
        /// <p>The action ID of the scheduled managed action to execute.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateEnvironmentOperationsRole`.
    ///
    /// <p>Add or change the operations role used by an environment. After this call is made, Elastic Beanstalk
    /// uses the associated operations role for permissions to downstream services during subsequent
    /// calls acting on this environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the
    /// <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateEnvironmentOperationsRole<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_environment_operations_role_input::Builder,
    }
    impl<C, M, R> AssociateEnvironmentOperationsRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateEnvironmentOperationsRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateEnvironmentOperationsRoleOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateEnvironmentOperationsRoleError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateEnvironmentOperationsRoleInputOperationOutputAlias,
                crate::output::AssociateEnvironmentOperationsRoleOutput,
                crate::error::AssociateEnvironmentOperationsRoleError,
                crate::input::AssociateEnvironmentOperationsRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment to which to set the operations role.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the environment to which to set the operations role.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's
        /// operations role.</p>
        pub fn operations_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operations_role(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's
        /// operations role.</p>
        pub fn set_operations_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_operations_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckDNSAvailability`.
    ///
    /// <p>Checks if the specified CNAME is available.</p>
    #[derive(std::fmt::Debug)]
    pub struct CheckDNSAvailability<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::check_dns_availability_input::Builder,
    }
    impl<C, M, R> CheckDNSAvailability<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CheckDNSAvailability`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckDnsAvailabilityOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckDNSAvailabilityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CheckDnsAvailabilityInputOperationOutputAlias,
                crate::output::CheckDnsAvailabilityOutput,
                crate::error::CheckDNSAvailabilityError,
                crate::input::CheckDnsAvailabilityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The prefix used when this CNAME is reserved.</p>
        pub fn cname_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cname_prefix(inp);
            self
        }
        /// <p>The prefix used when this CNAME is reserved.</p>
        pub fn set_cname_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cname_prefix(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ComposeEnvironments`.
    ///
    /// <p>Create or update a group of environments that each run a separate component of a single
    /// application. Takes a list of version labels that specify application source bundles for each
    /// of the environments to create or update. The name of each environment and other required
    /// information must be included in the source bundles in an environment manifest named
    /// <code>env.yaml</code>. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html">Compose Environments</a>
    /// for details.</p>
    #[derive(std::fmt::Debug)]
    pub struct ComposeEnvironments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::compose_environments_input::Builder,
    }
    impl<C, M, R> ComposeEnvironments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ComposeEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ComposeEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ComposeEnvironmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ComposeEnvironmentsInputOperationOutputAlias,
                crate::output::ComposeEnvironmentsOutput,
                crate::error::ComposeEnvironmentsError,
                crate::input::ComposeEnvironmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application to which the specified source bundles belong.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application to which the specified source bundles belong.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the group to which the target environments belong. Specify a group name
        /// only if the environment name defined in each target environment's manifest ends with a +
        /// (plus) character. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest
        /// (env.yaml)</a> for details.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group to which the target environments belong. Specify a group name
        /// only if the environment name defined in each target environment's manifest ends with a +
        /// (plus) character. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest
        /// (env.yaml)</a> for details.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// Appends an item to `VersionLabels`.
        ///
        /// To override the contents of this collection use [`set_version_labels`](Self::set_version_labels).
        ///
        /// <p>A list of version labels, specifying one or more application source bundles that belong
        /// to the target application. Each source bundle must include an environment manifest that
        /// specifies the name of the environment and the name of the solution stack to use, and
        /// optionally can specify environment links to create.</p>
        pub fn version_labels(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_labels(inp);
            self
        }
        /// <p>A list of version labels, specifying one or more application source bundles that belong
        /// to the target application. Each source bundle must include an environment manifest that
        /// specifies the name of the environment and the name of the solution stack to use, and
        /// optionally can specify environment links to create.</p>
        pub fn set_version_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_version_labels(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Creates an application that has one configuration template named <code>default</code>
    /// and no application versions.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_application_input::Builder,
    }
    impl<C, M, R> CreateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApplicationInputOperationOutputAlias,
                crate::output::CreateApplicationOutput,
                crate::error::CreateApplicationError,
                crate::input::CreateApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application. Must be unique within your account.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application. Must be unique within your account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>Your description of the application.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Your description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies an application resource lifecycle configuration to prevent your application
        /// from accumulating too many versions.</p>
        pub fn resource_lifecycle_config(
            mut self,
            inp: crate::model::ApplicationResourceLifecycleConfig,
        ) -> Self {
            self.inner = self.inner.resource_lifecycle_config(inp);
            self
        }
        /// <p>Specifies an application resource lifecycle configuration to prevent your application
        /// from accumulating too many versions.</p>
        pub fn set_resource_lifecycle_config(
            mut self,
            input: std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_lifecycle_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the application.</p>
        /// <p>Elastic Beanstalk applies these tags only to the application. Environments that you create in the
        /// application don't inherit the tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Specifies the tags applied to the application.</p>
        /// <p>Elastic Beanstalk applies these tags only to the application. Environments that you create in the
        /// application don't inherit the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApplicationVersion`.
    ///
    /// <p>Creates an application version for the specified application. You can create an
    /// application version from a source bundle in Amazon S3, a commit in AWS CodeCommit, or the
    /// output of an AWS CodeBuild build as follows:</p>
    /// <p>Specify a commit in an AWS CodeCommit repository with
    /// <code>SourceBuildInformation</code>.</p>
    /// <p>Specify a build in an AWS CodeBuild with <code>SourceBuildInformation</code> and
    /// <code>BuildConfiguration</code>.</p>
    /// <p>Specify a source bundle in S3 with <code>SourceBundle</code>
    /// </p>
    /// <p>Omit both <code>SourceBuildInformation</code> and <code>SourceBundle</code> to use the
    /// default sample application.</p>
    /// <note>
    /// <p>After you create an application version with a specified Amazon S3 bucket and key
    /// location, you can't change that Amazon S3 location. If you change the Amazon S3 location,
    /// you receive an exception when you attempt to launch an environment from the application
    /// version.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateApplicationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_application_version_input::Builder,
    }
    impl<C, M, R> CreateApplicationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApplicationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApplicationVersionInputOperationOutputAlias,
                crate::output::CreateApplicationVersionOutput,
                crate::error::CreateApplicationVersionError,
                crate::input::CreateApplicationVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the application. If no application is found with this name, and
        /// <code>AutoCreateApplication</code> is <code>false</code>, returns an
        /// <code>InvalidParameterValue</code> error. </p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p> The name of the application. If no application is found with this name, and
        /// <code>AutoCreateApplication</code> is <code>false</code>, returns an
        /// <code>InvalidParameterValue</code> error. </p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>A label identifying this version.</p>
        /// <p>Constraint: Must be unique per application. If an application version already exists
        /// with this label for the specified application, AWS Elastic Beanstalk returns an
        /// <code>InvalidParameterValue</code> error. </p>
        pub fn version_label(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(inp);
            self
        }
        /// <p>A label identifying this version.</p>
        /// <p>Constraint: Must be unique per application. If an application version already exists
        /// with this label for the specified application, AWS Elastic Beanstalk returns an
        /// <code>InvalidParameterValue</code> error. </p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// <p>A description of this application version.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of this application version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specify a commit in an AWS CodeCommit Git repository to use as the source code for the
        /// application version.</p>
        pub fn source_build_information(
            mut self,
            inp: crate::model::SourceBuildInformation,
        ) -> Self {
            self.inner = self.inner.source_build_information(inp);
            self
        }
        /// <p>Specify a commit in an AWS CodeCommit Git repository to use as the source code for the
        /// application version.</p>
        pub fn set_source_build_information(
            mut self,
            input: std::option::Option<crate::model::SourceBuildInformation>,
        ) -> Self {
            self.inner = self.inner.set_source_build_information(input);
            self
        }
        /// <p>The Amazon S3 bucket and key that identify the location of the source bundle for this
        /// version.</p>
        /// <note>
        /// <p>The Amazon S3 bucket must be in the same region as the
        /// environment.</p>
        /// </note>
        /// <p>Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with
        /// <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor
        /// <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample
        /// application.</p>
        pub fn source_bundle(mut self, inp: crate::model::S3Location) -> Self {
            self.inner = self.inner.source_bundle(inp);
            self
        }
        /// <p>The Amazon S3 bucket and key that identify the location of the source bundle for this
        /// version.</p>
        /// <note>
        /// <p>The Amazon S3 bucket must be in the same region as the
        /// environment.</p>
        /// </note>
        /// <p>Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with
        /// <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor
        /// <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample
        /// application.</p>
        pub fn set_source_bundle(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.inner = self.inner.set_source_bundle(input);
            self
        }
        /// <p>Settings for an AWS CodeBuild build.</p>
        pub fn build_configuration(mut self, inp: crate::model::BuildConfiguration) -> Self {
            self.inner = self.inner.build_configuration(inp);
            self
        }
        /// <p>Settings for an AWS CodeBuild build.</p>
        pub fn set_build_configuration(
            mut self,
            input: std::option::Option<crate::model::BuildConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_build_configuration(input);
            self
        }
        /// <p>Set to <code>true</code> to create an application with the specified name if it doesn't
        /// already exist.</p>
        pub fn auto_create_application(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_create_application(inp);
            self
        }
        /// <p>Set to <code>true</code> to create an application with the specified name if it doesn't
        /// already exist.</p>
        pub fn set_auto_create_application(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_create_application(input);
            self
        }
        /// <p>Pre-processes and validates the environment manifest (<code>env.yaml</code>) and
        /// configuration files (<code>*.config</code> files in the <code>.ebextensions</code> folder) in
        /// the source bundle. Validating configuration files can identify issues prior to deploying the
        /// application version to an environment.</p>
        /// <p>You must turn processing on for application versions that you create using AWS
        /// CodeBuild or AWS CodeCommit. For application versions built from a source bundle in Amazon S3,
        /// processing is optional.</p>
        /// <note>
        /// <p>The <code>Process</code> option validates Elastic Beanstalk configuration files. It
        /// doesn't validate your application's configuration files, like proxy server or Docker
        /// configuration.</p>
        /// </note>
        pub fn process(mut self, inp: bool) -> Self {
            self.inner = self.inner.process(inp);
            self
        }
        /// <p>Pre-processes and validates the environment manifest (<code>env.yaml</code>) and
        /// configuration files (<code>*.config</code> files in the <code>.ebextensions</code> folder) in
        /// the source bundle. Validating configuration files can identify issues prior to deploying the
        /// application version to an environment.</p>
        /// <p>You must turn processing on for application versions that you create using AWS
        /// CodeBuild or AWS CodeCommit. For application versions built from a source bundle in Amazon S3,
        /// processing is optional.</p>
        /// <note>
        /// <p>The <code>Process</code> option validates Elastic Beanstalk configuration files. It
        /// doesn't validate your application's configuration files, like proxy server or Docker
        /// configuration.</p>
        /// </note>
        pub fn set_process(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_process(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the application version.</p>
        /// <p>Elastic Beanstalk applies these tags only to the application version. Environments that use the
        /// application version don't inherit the tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Specifies the tags applied to the application version.</p>
        /// <p>Elastic Beanstalk applies these tags only to the application version. Environments that use the
        /// application version don't inherit the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationTemplate`.
    ///
    /// <p>Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk
    /// application. You define application configuration settings in a configuration template. You
    /// can then use the configuration template to deploy different versions of the application with
    /// the same configuration settings.</p>
    /// <p>Templates aren't associated with any environment. The <code>EnvironmentName</code>
    /// response element is always <code>null</code>.</p>
    /// <p>Related Topics</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>DescribeConfigurationOptions</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>DescribeConfigurationSettings</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>ListAvailableSolutionStacks</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateConfigurationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_configuration_template_input::Builder,
    }
    impl<C, M, R> CreateConfigurationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigurationTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConfigurationTemplateInputOperationOutputAlias,
                crate::output::CreateConfigurationTemplateOutput,
                crate::error::CreateConfigurationTemplateError,
                crate::input::CreateConfigurationTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Elastic Beanstalk application to associate with this configuration
        /// template.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the Elastic Beanstalk application to associate with this configuration
        /// template.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the configuration template.</p>
        /// <p>Constraint: This name must be unique per application.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the configuration template.</p>
        /// <p>Constraint: This name must be unique per application.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses. For
        /// example, <code>64bit Amazon Linux 2013.09 running Tomcat 7 Java 7</code>. A solution stack
        /// specifies the operating system, runtime, and application server for a configuration template.
        /// It also determines the set of configuration options as well as the possible and default
        /// values. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Supported Platforms</a> in the
        /// <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        /// <p>You must specify <code>SolutionStackName</code> if you don't specify
        /// <code>PlatformArn</code>, <code>EnvironmentId</code>, or
        /// <code>SourceConfiguration</code>.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html">
        /// <code>ListAvailableSolutionStacks</code>
        /// </a> API to obtain a list of available
        /// solution stacks.</p>
        pub fn solution_stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_stack_name(inp);
            self
        }
        /// <p>The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses. For
        /// example, <code>64bit Amazon Linux 2013.09 running Tomcat 7 Java 7</code>. A solution stack
        /// specifies the operating system, runtime, and application server for a configuration template.
        /// It also determines the set of configuration options as well as the possible and default
        /// values. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Supported Platforms</a> in the
        /// <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        /// <p>You must specify <code>SolutionStackName</code> if you don't specify
        /// <code>PlatformArn</code>, <code>EnvironmentId</code>, or
        /// <code>SourceConfiguration</code>.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html">
        /// <code>ListAvailableSolutionStacks</code>
        /// </a> API to obtain a list of available
        /// solution stacks.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_stack_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom platform. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html"> Custom
        /// Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        /// <note>
        ///
        /// <p>If you specify <code>PlatformArn</code>, then don't specify
        /// <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn platform_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom platform. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html"> Custom
        /// Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        /// <note>
        ///
        /// <p>If you specify <code>PlatformArn</code>, then don't specify
        /// <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
        /// <p>An Elastic Beanstalk configuration template to base this one on. If specified, Elastic Beanstalk uses the configuration values from the specified
        /// configuration template to create a new configuration.</p>
        /// <p>Values specified in <code>OptionSettings</code> override any values obtained from the
        /// <code>SourceConfiguration</code>.</p>
        /// <p>You must specify <code>SourceConfiguration</code> if you don't specify
        /// <code>PlatformArn</code>, <code>EnvironmentId</code>, or
        /// <code>SolutionStackName</code>.</p>
        /// <p>Constraint: If both solution stack name and source configuration are specified, the
        /// solution stack of the source configuration template must match the specified solution stack
        /// name.</p>
        pub fn source_configuration(mut self, inp: crate::model::SourceConfiguration) -> Self {
            self.inner = self.inner.source_configuration(inp);
            self
        }
        /// <p>An Elastic Beanstalk configuration template to base this one on. If specified, Elastic Beanstalk uses the configuration values from the specified
        /// configuration template to create a new configuration.</p>
        /// <p>Values specified in <code>OptionSettings</code> override any values obtained from the
        /// <code>SourceConfiguration</code>.</p>
        /// <p>You must specify <code>SourceConfiguration</code> if you don't specify
        /// <code>PlatformArn</code>, <code>EnvironmentId</code>, or
        /// <code>SolutionStackName</code>.</p>
        /// <p>Constraint: If both solution stack name and source configuration are specified, the
        /// solution stack of the source configuration template must match the specified solution stack
        /// name.</p>
        pub fn set_source_configuration(
            mut self,
            input: std::option::Option<crate::model::SourceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_source_configuration(input);
            self
        }
        /// <p>The ID of an environment whose settings you want to use to create the configuration
        /// template. You must specify <code>EnvironmentId</code> if you don't specify
        /// <code>PlatformArn</code>, <code>SolutionStackName</code>, or
        /// <code>SourceConfiguration</code>.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of an environment whose settings you want to use to create the configuration
        /// template. You must specify <code>EnvironmentId</code> if you don't specify
        /// <code>PlatformArn</code>, <code>SolutionStackName</code>, or
        /// <code>SourceConfiguration</code>.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>An optional description for this configuration.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description for this configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `OptionSettings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>Option values for the Elastic Beanstalk configuration, such as the instance type. If specified, these
        /// values override the values obtained from the solution stack or the source configuration
        /// template. For a complete list of Elastic Beanstalk configuration options, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html">Option Values</a> in the
        /// <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn option_settings(
            mut self,
            inp: impl Into<crate::model::ConfigurationOptionSetting>,
        ) -> Self {
            self.inner = self.inner.option_settings(inp);
            self
        }
        /// <p>Option values for the Elastic Beanstalk configuration, such as the instance type. If specified, these
        /// values override the values obtained from the solution stack or the source configuration
        /// template. For a complete list of Elastic Beanstalk configuration options, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html">Option Values</a> in the
        /// <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.inner = self.inner.set_option_settings(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the configuration template.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Specifies the tags applied to the configuration template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEnvironment`.
    ///
    /// <p>Launches an AWS Elastic Beanstalk environment for the specified application using the specified
    /// configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_environment_input::Builder,
    }
    impl<C, M, R> CreateEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEnvironmentInputOperationOutputAlias,
                crate::output::CreateEnvironmentOutput,
                crate::error::CreateEnvironmentError,
                crate::input::CreateEnvironmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application that is associated with this environment.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application that is associated with this environment.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>A unique name for the environment.</p>
        /// <p>Constraint: Must be from 4 to 40 characters in length. The name can contain only
        /// letters, numbers, and hyphens. It can't start or end with a hyphen. This name must be unique
        /// within a region in your account. If the specified name already exists in the region, Elastic Beanstalk returns an
        /// <code>InvalidParameterValue</code> error. </p>
        /// <p>If you don't specify the <code>CNAMEPrefix</code> parameter, the environment name becomes part of
        /// the CNAME, and therefore part of the visible URL for your application.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>A unique name for the environment.</p>
        /// <p>Constraint: Must be from 4 to 40 characters in length. The name can contain only
        /// letters, numbers, and hyphens. It can't start or end with a hyphen. This name must be unique
        /// within a region in your account. If the specified name already exists in the region, Elastic Beanstalk returns an
        /// <code>InvalidParameterValue</code> error. </p>
        /// <p>If you don't specify the <code>CNAMEPrefix</code> parameter, the environment name becomes part of
        /// the CNAME, and therefore part of the visible URL for your application.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The name of the group to which the target environment belongs. Specify a group name
        /// only if the environment's name is specified in an environment manifest and not with the
        /// environment name parameter. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest
        /// (env.yaml)</a> for details.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group to which the target environment belongs. Specify a group name
        /// only if the environment's name is specified in an environment manifest and not with the
        /// environment name parameter. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest
        /// (env.yaml)</a> for details.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>Your description for this environment.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Your description for this environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>If specified, the environment attempts to use this value as the prefix for the CNAME in
        /// your Elastic Beanstalk environment URL. If not specified, the CNAME is generated automatically by
        /// appending a random alphanumeric string to the environment name.</p>
        pub fn cname_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cname_prefix(inp);
            self
        }
        /// <p>If specified, the environment attempts to use this value as the prefix for the CNAME in
        /// your Elastic Beanstalk environment URL. If not specified, the CNAME is generated automatically by
        /// appending a random alphanumeric string to the environment name.</p>
        pub fn set_cname_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cname_prefix(input);
            self
        }
        /// <p>Specifies the tier to use in creating this environment. The environment tier that you
        /// choose determines whether Elastic Beanstalk provisions resources to support a web application that handles
        /// HTTP(S) requests or a web application that handles background-processing tasks.</p>
        pub fn tier(mut self, inp: crate::model::EnvironmentTier) -> Self {
            self.inner = self.inner.tier(inp);
            self
        }
        /// <p>Specifies the tier to use in creating this environment. The environment tier that you
        /// choose determines whether Elastic Beanstalk provisions resources to support a web application that handles
        /// HTTP(S) requests or a web application that handles background-processing tasks.</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTier>,
        ) -> Self {
            self.inner = self.inner.set_tier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to resources in the environment.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Specifies the tags applied to resources in the environment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the application version to deploy.</p>
        /// <p>Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.</p>
        pub fn version_label(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(inp);
            self
        }
        /// <p>The name of the application version to deploy.</p>
        /// <p>Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// <p>The name of the Elastic Beanstalk configuration template to use with the environment.</p>
        /// <note>
        /// <p>If you specify <code>TemplateName</code>, then don't specify
        /// <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the Elastic Beanstalk configuration template to use with the environment.</p>
        /// <note>
        /// <p>If you specify <code>TemplateName</code>, then don't specify
        /// <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If
        /// specified, Elastic Beanstalk sets the configuration values to the default values associated with the
        /// specified solution stack. For a list of current solution stacks, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic Beanstalk Supported Platforms</a> in the <i>AWS Elastic Beanstalk
        /// Platforms</i> guide.</p>
        /// <note>
        /// <p>If you specify <code>SolutionStackName</code>, don't specify <code>PlatformArn</code> or
        /// <code>TemplateName</code>.</p>
        /// </note>
        pub fn solution_stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_stack_name(inp);
            self
        }
        /// <p>The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If
        /// specified, Elastic Beanstalk sets the configuration values to the default values associated with the
        /// specified solution stack. For a list of current solution stacks, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic Beanstalk Supported Platforms</a> in the <i>AWS Elastic Beanstalk
        /// Platforms</i> guide.</p>
        /// <note>
        /// <p>If you specify <code>SolutionStackName</code>, don't specify <code>PlatformArn</code> or
        /// <code>TemplateName</code>.</p>
        /// </note>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_stack_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom platform to use with the environment. For
        /// more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms</a> in the
        /// <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        /// <note>
        ///
        /// <p>If you specify <code>PlatformArn</code>, don't specify
        /// <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn platform_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom platform to use with the environment. For
        /// more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms</a> in the
        /// <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        /// <note>
        ///
        /// <p>If you specify <code>PlatformArn</code>, don't specify
        /// <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
        /// Appends an item to `OptionSettings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>If specified, AWS Elastic Beanstalk sets the specified configuration options to the
        /// requested value in the configuration set for the new environment. These override the values
        /// obtained from the solution stack or the configuration template.</p>
        pub fn option_settings(
            mut self,
            inp: impl Into<crate::model::ConfigurationOptionSetting>,
        ) -> Self {
            self.inner = self.inner.option_settings(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk sets the specified configuration options to the
        /// requested value in the configuration set for the new environment. These override the values
        /// obtained from the solution stack or the configuration template.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.inner = self.inner.set_option_settings(input);
            self
        }
        /// Appends an item to `OptionsToRemove`.
        ///
        /// To override the contents of this collection use [`set_options_to_remove`](Self::set_options_to_remove).
        ///
        /// <p>A list of custom user-defined configuration options to remove from the configuration
        /// set for this new environment.</p>
        pub fn options_to_remove(
            mut self,
            inp: impl Into<crate::model::OptionSpecification>,
        ) -> Self {
            self.inner = self.inner.options_to_remove(inp);
            self
        }
        /// <p>A list of custom user-defined configuration options to remove from the configuration
        /// set for this new environment.</p>
        pub fn set_options_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_options_to_remove(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's
        /// operations role. If specified, Elastic Beanstalk uses the operations role for permissions to downstream
        /// services during this call and during subsequent calls acting on this environment. To specify
        /// an operations role, you must have the <code>iam:PassRole</code> permission for the role. For
        /// more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the
        /// <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn operations_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operations_role(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's
        /// operations role. If specified, Elastic Beanstalk uses the operations role for permissions to downstream
        /// services during this call and during subsequent calls acting on this environment. To specify
        /// an operations role, you must have the <code>iam:PassRole</code> permission for the role. For
        /// more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the
        /// <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn set_operations_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_operations_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePlatformVersion`.
    ///
    /// <p>Create a new version of your custom platform.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePlatformVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_platform_version_input::Builder,
    }
    impl<C, M, R> CreatePlatformVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePlatformVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePlatformVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePlatformVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePlatformVersionInputOperationOutputAlias,
                crate::output::CreatePlatformVersionOutput,
                crate::error::CreatePlatformVersionError,
                crate::input::CreatePlatformVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your custom platform.</p>
        pub fn platform_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_name(inp);
            self
        }
        /// <p>The name of your custom platform.</p>
        pub fn set_platform_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_platform_name(input);
            self
        }
        /// <p>The number, such as 1.0.2, for the new platform version.</p>
        pub fn platform_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_version(inp);
            self
        }
        /// <p>The number, such as 1.0.2, for the new platform version.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_platform_version(input);
            self
        }
        /// <p>The location of the platform definition archive in Amazon S3.</p>
        pub fn platform_definition_bundle(mut self, inp: crate::model::S3Location) -> Self {
            self.inner = self.inner.platform_definition_bundle(inp);
            self
        }
        /// <p>The location of the platform definition archive in Amazon S3.</p>
        pub fn set_platform_definition_bundle(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.inner = self.inner.set_platform_definition_bundle(input);
            self
        }
        /// <p>The name of the builder environment.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the builder environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// Appends an item to `OptionSettings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>The configuration option settings to apply to the builder environment.</p>
        pub fn option_settings(
            mut self,
            inp: impl Into<crate::model::ConfigurationOptionSetting>,
        ) -> Self {
            self.inner = self.inner.option_settings(inp);
            self
        }
        /// <p>The configuration option settings to apply to the builder environment.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.inner = self.inner.set_option_settings(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the new platform version.</p>
        /// <p>Elastic Beanstalk applies these tags only to the platform version. Environments that you create using
        /// the platform version don't inherit the tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Specifies the tags applied to the new platform version.</p>
        /// <p>Elastic Beanstalk applies these tags only to the platform version. Environments that you create using
        /// the platform version don't inherit the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStorageLocation`.
    ///
    /// <p>Creates a bucket in Amazon S3 to store application versions, logs, and other files used
    /// by Elastic Beanstalk environments. The Elastic Beanstalk console and EB CLI call this API the
    /// first time you create an environment in a region. If the storage location already exists,
    /// <code>CreateStorageLocation</code> still returns the bucket name but does not create a new
    /// bucket.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStorageLocation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_storage_location_input::Builder,
    }
    impl<C, M, R> CreateStorageLocation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStorageLocation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStorageLocationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStorageLocationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStorageLocationInputOperationOutputAlias,
                crate::output::CreateStorageLocationOutput,
                crate::error::CreateStorageLocationError,
                crate::input::CreateStorageLocationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteApplication`.
    ///
    /// <p>Deletes the specified application along with all associated versions and
    /// configurations. The application versions will not be deleted from your Amazon S3
    /// bucket.</p>
    /// <note>
    /// <p>You cannot delete an application that has a running environment.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_application_input::Builder,
    }
    impl<C, M, R> DeleteApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApplicationInputOperationOutputAlias,
                crate::output::DeleteApplicationOutput,
                crate::error::DeleteApplicationError,
                crate::input::DeleteApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application to delete.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application to delete.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>When set to true, running environments will be terminated before deleting the
        /// application.</p>
        pub fn terminate_env_by_force(mut self, inp: bool) -> Self {
            self.inner = self.inner.terminate_env_by_force(inp);
            self
        }
        /// <p>When set to true, running environments will be terminated before deleting the
        /// application.</p>
        pub fn set_terminate_env_by_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_terminate_env_by_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplicationVersion`.
    ///
    /// <p>Deletes the specified version from the specified application.</p>
    /// <note>
    /// <p>You cannot delete an application version that is associated with a running
    /// environment.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApplicationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_application_version_input::Builder,
    }
    impl<C, M, R> DeleteApplicationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApplicationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApplicationVersionInputOperationOutputAlias,
                crate::output::DeleteApplicationVersionOutput,
                crate::error::DeleteApplicationVersionError,
                crate::input::DeleteApplicationVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application to which the version belongs.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application to which the version belongs.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The label of the version to delete.</p>
        pub fn version_label(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(inp);
            self
        }
        /// <p>The label of the version to delete.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// <p>Set to <code>true</code> to delete the source bundle from your storage bucket.
        /// Otherwise, the application version is deleted only from Elastic Beanstalk and the source
        /// bundle remains in Amazon S3.</p>
        pub fn delete_source_bundle(mut self, inp: bool) -> Self {
            self.inner = self.inner.delete_source_bundle(inp);
            self
        }
        /// <p>Set to <code>true</code> to delete the source bundle from your storage bucket.
        /// Otherwise, the application version is deleted only from Elastic Beanstalk and the source
        /// bundle remains in Amazon S3.</p>
        pub fn set_delete_source_bundle(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_source_bundle(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationTemplate`.
    ///
    /// <p>Deletes the specified configuration template.</p>
    /// <note>
    /// <p>When you launch an environment using a configuration template, the environment gets a
    /// copy of the template. You can delete or modify the environment's copy of the template
    /// without affecting the running environment.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConfigurationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_configuration_template_input::Builder,
    }
    impl<C, M, R> DeleteConfigurationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConfigurationTemplateInputOperationOutputAlias,
                crate::output::DeleteConfigurationTemplateOutput,
                crate::error::DeleteConfigurationTemplateError,
                crate::input::DeleteConfigurationTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application to delete the configuration template from.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application to delete the configuration template from.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the configuration template to delete.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the configuration template to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEnvironmentConfiguration`.
    ///
    /// <p>Deletes the draft configuration associated with the running environment.</p>
    /// <p>Updating a running environment with any configuration changes creates a draft
    /// configuration set. You can get the draft configuration using <a>DescribeConfigurationSettings</a> while the update is in progress or if the update
    /// fails. The <code>DeploymentStatus</code> for the draft configuration indicates whether the
    /// deployment is in process or has failed. The draft configuration remains in existence until it
    /// is deleted with this action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEnvironmentConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_environment_configuration_input::Builder,
    }
    impl<C, M, R> DeleteEnvironmentConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEnvironmentConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEnvironmentConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEnvironmentConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEnvironmentConfigurationInputOperationOutputAlias,
                crate::output::DeleteEnvironmentConfigurationOutput,
                crate::error::DeleteEnvironmentConfigurationError,
                crate::input::DeleteEnvironmentConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application the environment is associated with.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application the environment is associated with.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the environment to delete the draft configuration from.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the environment to delete the draft configuration from.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePlatformVersion`.
    ///
    /// <p>Deletes the specified version of a custom platform.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePlatformVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_platform_version_input::Builder,
    }
    impl<C, M, R> DeletePlatformVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePlatformVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePlatformVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePlatformVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePlatformVersionInputOperationOutputAlias,
                crate::output::DeletePlatformVersionOutput,
                crate::error::DeletePlatformVersionError,
                crate::input::DeletePlatformVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the version of the custom platform.</p>
        pub fn platform_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(inp);
            self
        }
        /// <p>The ARN of the version of the custom platform.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAttributes`.
    ///
    /// <p>Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS
    /// account.</p>
    /// <p>The result currently has one set of attributes—resource quotas.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccountAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_attributes_input::Builder,
    }
    impl<C, M, R> DescribeAccountAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountAttributesInputOperationOutputAlias,
                crate::output::DescribeAccountAttributesOutput,
                crate::error::DescribeAccountAttributesError,
                crate::input::DescribeAccountAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeApplications`.
    ///
    /// <p>Returns the descriptions of existing applications.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_applications_input::Builder,
    }
    impl<C, M, R> DescribeApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeApplicationsInputOperationOutputAlias,
                crate::output::DescribeApplicationsOutput,
                crate::error::DescribeApplicationsError,
                crate::input::DescribeApplicationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ApplicationNames`.
        ///
        /// To override the contents of this collection use [`set_application_names`](Self::set_application_names).
        ///
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include
        /// those with the specified names.</p>
        pub fn application_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_names(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include
        /// those with the specified names.</p>
        pub fn set_application_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_application_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApplicationVersions`.
    ///
    /// <p>Retrieve a list of application versions.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeApplicationVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_application_versions_input::Builder,
    }
    impl<C, M, R> DescribeApplicationVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeApplicationVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicationVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeApplicationVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeApplicationVersionsInputOperationOutputAlias,
                crate::output::DescribeApplicationVersionsOutput,
                crate::error::DescribeApplicationVersionsError,
                crate::input::DescribeApplicationVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify an application name to show only application versions for that
        /// application.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>Specify an application name to show only application versions for that
        /// application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// Appends an item to `VersionLabels`.
        ///
        /// To override the contents of this collection use [`set_version_labels`](Self::set_version_labels).
        ///
        /// <p>Specify a version label to show a specific application version.</p>
        pub fn version_labels(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_labels(inp);
            self
        }
        /// <p>Specify a version label to show a specific application version.</p>
        pub fn set_version_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_version_labels(input);
            self
        }
        /// <p>For a paginated request. Specify a maximum number of application versions to include in
        /// each response.</p>
        /// <p>If no <code>MaxRecords</code> is specified, all available application versions are
        /// retrieved in a single response.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>For a paginated request. Specify a maximum number of application versions to include in
        /// each response.</p>
        /// <p>If no <code>MaxRecords</code> is specified, all available application versions are
        /// retrieved in a single response.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other
        /// parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other
        /// parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurationOptions`.
    ///
    /// <p>Describes the configuration options that are used in a particular configuration
    /// template or environment, or that a specified solution stack defines. The description includes
    /// the values the options, their default values, and an indication of the required action on a
    /// running environment if an option value is changed.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConfigurationOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_configuration_options_input::Builder,
    }
    impl<C, M, R> DescribeConfigurationOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfigurationOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigurationOptionsInputOperationOutputAlias,
                crate::output::DescribeConfigurationOptionsOutput,
                crate::error::DescribeConfigurationOptionsError,
                crate::input::DescribeConfigurationOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application associated with the configuration template or environment.
        /// Only needed if you want to describe the configuration options associated with either the
        /// configuration template or environment.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application associated with the configuration template or environment.
        /// Only needed if you want to describe the configuration options associated with either the
        /// configuration template or environment.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the configuration template whose configuration options you want to
        /// describe.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the configuration template whose configuration options you want to
        /// describe.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The name of the environment whose configuration options you want to describe.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the environment whose configuration options you want to describe.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The name of the solution stack whose configuration options you want to
        /// describe.</p>
        pub fn solution_stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_stack_name(inp);
            self
        }
        /// <p>The name of the solution stack whose configuration options you want to
        /// describe.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_stack_name(input);
            self
        }
        /// <p>The ARN of the custom platform.</p>
        pub fn platform_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(inp);
            self
        }
        /// <p>The ARN of the custom platform.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
        /// Appends an item to `Options`.
        ///
        /// To override the contents of this collection use [`set_options`](Self::set_options).
        ///
        /// <p>If specified, restricts the descriptions to only the specified options.</p>
        pub fn options(mut self, inp: impl Into<crate::model::OptionSpecification>) -> Self {
            self.inner = self.inner.options(inp);
            self
        }
        /// <p>If specified, restricts the descriptions to only the specified options.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurationSettings`.
    ///
    /// <p>Returns a description of the settings for the specified configuration set, that is,
    /// either a configuration template or the configuration set associated with a running
    /// environment.</p>
    /// <p>When describing the settings for the configuration set associated with a running
    /// environment, it is possible to receive two sets of setting descriptions. One is the deployed
    /// configuration set, and the other is a draft configuration of an environment that is either in
    /// the process of deployment or that failed to deploy.</p>
    /// <p>Related Topics</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>DeleteEnvironmentConfiguration</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConfigurationSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_configuration_settings_input::Builder,
    }
    impl<C, M, R> DescribeConfigurationSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfigurationSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigurationSettingsInputOperationOutputAlias,
                crate::output::DescribeConfigurationSettingsOutput,
                crate::error::DescribeConfigurationSettingsError,
                crate::input::DescribeConfigurationSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application for the environment or configuration template.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The application for the environment or configuration template.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the configuration template to describe.</p>
        /// <p> Conditional: You must specify either this parameter or an EnvironmentName, but not
        /// both. If you specify both, AWS Elastic Beanstalk returns an
        /// <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic
        /// Beanstalk returns a <code>MissingRequiredParameter</code> error. </p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the configuration template to describe.</p>
        /// <p> Conditional: You must specify either this parameter or an EnvironmentName, but not
        /// both. If you specify both, AWS Elastic Beanstalk returns an
        /// <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic
        /// Beanstalk returns a <code>MissingRequiredParameter</code> error. </p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The name of the environment to describe.</p>
        /// <p> Condition: You must specify either this or a TemplateName, but not both. If you
        /// specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error.
        /// If you do not specify either, AWS Elastic Beanstalk returns
        /// <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the environment to describe.</p>
        /// <p> Condition: You must specify either this or a TemplateName, but not both. If you
        /// specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error.
        /// If you do not specify either, AWS Elastic Beanstalk returns
        /// <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironmentHealth`.
    ///
    /// <p>Returns information about the overall health of the specified environment. The
    /// <b>DescribeEnvironmentHealth</b> operation is only available with
    /// AWS Elastic Beanstalk Enhanced Health.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEnvironmentHealth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_environment_health_input::Builder,
    }
    impl<C, M, R> DescribeEnvironmentHealth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEnvironmentHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentHealthOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentHealthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEnvironmentHealthInputOperationOutputAlias,
                crate::output::DescribeEnvironmentHealthOutput,
                crate::error::DescribeEnvironmentHealthError,
                crate::input::DescribeEnvironmentHealthInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the environment by name.</p>
        /// <p>You must specify either this or an EnvironmentName, or both.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>Specify the environment by name.</p>
        /// <p>You must specify either this or an EnvironmentName, or both.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>Specify the environment by ID.</p>
        /// <p>You must specify either this or an EnvironmentName, or both.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>Specify the environment by ID.</p>
        /// <p>You must specify either this or an EnvironmentName, or both.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// Appends an item to `AttributeNames`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>Specify the response elements to return. To retrieve all attributes, set to
        /// <code>All</code>. If no attribute names are specified, returns the name of the
        /// environment.</p>
        pub fn attribute_names(
            mut self,
            inp: impl Into<crate::model::EnvironmentHealthAttribute>,
        ) -> Self {
            self.inner = self.inner.attribute_names(inp);
            self
        }
        /// <p>Specify the response elements to return. To retrieve all attributes, set to
        /// <code>All</code>. If no attribute names are specified, returns the name of the
        /// environment.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentHealthAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironmentManagedActionHistory`.
    ///
    /// <p>Lists an environment's completed and failed managed actions.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEnvironmentManagedActionHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_environment_managed_action_history_input::Builder,
    }
    impl<C, M, R> DescribeEnvironmentManagedActionHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEnvironmentManagedActionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentManagedActionHistoryOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeEnvironmentManagedActionHistoryError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEnvironmentManagedActionHistoryInputOperationOutputAlias,
                crate::output::DescribeEnvironmentManagedActionHistoryOutput,
                crate::error::DescribeEnvironmentManagedActionHistoryError,
                crate::input::DescribeEnvironmentManagedActionHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the target environment.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the target environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The pagination token returned by a previous request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token returned by a previous request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for a single request.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of items to return for a single request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironmentManagedActions`.
    ///
    /// <p>Lists an environment's upcoming and in-progress managed actions.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEnvironmentManagedActions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_environment_managed_actions_input::Builder,
    }
    impl<C, M, R> DescribeEnvironmentManagedActions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEnvironmentManagedActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentManagedActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentManagedActionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEnvironmentManagedActionsInputOperationOutputAlias,
                crate::output::DescribeEnvironmentManagedActionsOutput,
                crate::error::DescribeEnvironmentManagedActionsError,
                crate::input::DescribeEnvironmentManagedActionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the target environment.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the target environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>To show only actions with a particular status, specify a status.</p>
        pub fn status(mut self, inp: crate::model::ActionStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>To show only actions with a particular status, specify a status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ActionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironmentResources`.
    ///
    /// <p>Returns AWS resources for this environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEnvironmentResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_environment_resources_input::Builder,
    }
    impl<C, M, R> DescribeEnvironmentResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEnvironmentResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEnvironmentResourcesInputOperationOutputAlias,
                crate::output::DescribeEnvironmentResourcesOutput,
                crate::error::DescribeEnvironmentResourcesError,
                crate::input::DescribeEnvironmentResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to retrieve AWS resource usage data.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the environment to retrieve AWS resource usage data.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the environment to retrieve AWS resource usage data.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the environment to retrieve AWS resource usage data.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEnvironments`.
    ///
    /// <p>Returns descriptions for existing environments.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEnvironments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_environments_input::Builder,
    }
    impl<C, M, R> DescribeEnvironments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEnvironmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEnvironmentsInputOperationOutputAlias,
                crate::output::DescribeEnvironmentsOutput,
                crate::error::DescribeEnvironmentsError,
                crate::input::DescribeEnvironmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only
        /// those that are associated with this application.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only
        /// those that are associated with this application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only
        /// those that are associated with this application version.</p>
        pub fn version_label(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only
        /// those that are associated with this application version.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// Appends an item to `EnvironmentIds`.
        ///
        /// To override the contents of this collection use [`set_environment_ids`](Self::set_environment_ids).
        ///
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only
        /// those that have the specified IDs.</p>
        pub fn environment_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_ids(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only
        /// those that have the specified IDs.</p>
        pub fn set_environment_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_environment_ids(input);
            self
        }
        /// Appends an item to `EnvironmentNames`.
        ///
        /// To override the contents of this collection use [`set_environment_names`](Self::set_environment_names).
        ///
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only
        /// those that have the specified names.</p>
        pub fn environment_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_names(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only
        /// those that have the specified names.</p>
        pub fn set_environment_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_environment_names(input);
            self
        }
        /// <p>Indicates whether to include deleted environments:</p>
        /// <p>
        /// <code>true</code>: Environments that have been deleted after
        /// <code>IncludedDeletedBackTo</code> are displayed.</p>
        /// <p>
        /// <code>false</code>: Do not include deleted environments.</p>
        pub fn include_deleted(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_deleted(inp);
            self
        }
        /// <p>Indicates whether to include deleted environments:</p>
        /// <p>
        /// <code>true</code>: Environments that have been deleted after
        /// <code>IncludedDeletedBackTo</code> are displayed.</p>
        /// <p>
        /// <code>false</code>: Do not include deleted environments.</p>
        pub fn set_include_deleted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_deleted(input);
            self
        }
        /// <p> If specified when <code>IncludeDeleted</code> is set to <code>true</code>, then
        /// environments deleted after this date are displayed. </p>
        pub fn included_deleted_back_to(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.included_deleted_back_to(inp);
            self
        }
        /// <p> If specified when <code>IncludeDeleted</code> is set to <code>true</code>, then
        /// environments deleted after this date are displayed. </p>
        pub fn set_included_deleted_back_to(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_included_deleted_back_to(input);
            self
        }
        /// <p>For a paginated request. Specify a maximum number of environments to include in
        /// each response.</p>
        /// <p>If no <code>MaxRecords</code> is specified, all available environments are
        /// retrieved in a single response.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>For a paginated request. Specify a maximum number of environments to include in
        /// each response.</p>
        /// <p>If no <code>MaxRecords</code> is specified, all available environments are
        /// retrieved in a single response.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other
        /// parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other
        /// parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p>Returns list of event descriptions matching criteria up to the last 6 weeks.</p>
    /// <note>
    /// <p>This action returns the most recent 1,000 events from the specified
    /// <code>NextToken</code>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl<C, M, R> DescribeEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventsInputOperationOutputAlias,
                crate::output::DescribeEventsOutput,
                crate::error::DescribeEventsError,
                crate::input::DescribeEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only
        /// those associated with this application.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only
        /// those associated with this application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those
        /// associated with this application version.</p>
        pub fn version_label(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those
        /// associated with this application version.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that
        /// are associated with this environment configuration.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that
        /// are associated with this environment configuration.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those
        /// associated with this environment.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those
        /// associated with this environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those
        /// associated with this environment.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those
        /// associated with this environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the
        /// returned descriptions to those associated with this custom platform version.</p>
        pub fn platform_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(inp);
            self
        }
        /// <p>The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the
        /// returned descriptions to those associated with this custom platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the described events to include only
        /// those associated with this request ID.</p>
        pub fn request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_id(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the described events to include only
        /// those associated with this request ID.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_request_id(input);
            self
        }
        /// <p>If specified, limits the events returned from this call to include only those with the
        /// specified severity or higher.</p>
        pub fn severity(mut self, inp: crate::model::EventSeverity) -> Self {
            self.inner = self.inner.severity(inp);
            self
        }
        /// <p>If specified, limits the events returned from this call to include only those with the
        /// specified severity or higher.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::EventSeverity>,
        ) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that
        /// occur on or after this time.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that
        /// occur on or after this time.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p> If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that
        /// occur up to, but not including, the <code>EndTime</code>. </p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p> If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that
        /// occur up to, but not including, the <code>EndTime</code>. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>Specifies the maximum number of events that can be returned, beginning with the most
        /// recent event.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>Specifies the maximum number of events that can be returned, beginning with the most
        /// recent event.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>Pagination token. If specified, the events return the next batch of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token. If specified, the events return the next batch of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstancesHealth`.
    ///
    /// <p>Retrieves detailed information about the health of instances in your AWS Elastic
    /// Beanstalk. This operation requires <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html">enhanced health
    /// reporting</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInstancesHealth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instances_health_input::Builder,
    }
    impl<C, M, R> DescribeInstancesHealth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstancesHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstancesHealthOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstancesHealthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstancesHealthInputOperationOutputAlias,
                crate::output::DescribeInstancesHealthOutput,
                crate::error::DescribeInstancesHealthError,
                crate::input::DescribeInstancesHealthInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the AWS Elastic Beanstalk environment by name.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>Specify the AWS Elastic Beanstalk environment by name.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>Specify the AWS Elastic Beanstalk environment by ID.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>Specify the AWS Elastic Beanstalk environment by ID.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// Appends an item to `AttributeNames`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>Specifies the response elements you wish to receive. To retrieve all attributes, set to
        /// <code>All</code>. If no attribute names are specified, returns a list of
        /// instances.</p>
        pub fn attribute_names(
            mut self,
            inp: impl Into<crate::model::InstancesHealthAttribute>,
        ) -> Self {
            self.inner = self.inner.attribute_names(inp);
            self
        }
        /// <p>Specifies the response elements you wish to receive. To retrieve all attributes, set to
        /// <code>All</code>. If no attribute names are specified, returns a list of
        /// instances.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstancesHealthAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_names(input);
            self
        }
        /// <p>Specify the pagination token returned by a previous call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Specify the pagination token returned by a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePlatformVersion`.
    ///
    /// <p>Describes a platform version. Provides full details. Compare to <a>ListPlatformVersions</a>, which provides summary information about a list of
    /// platform versions.</p>
    /// <p>For definitions of platform version and other platform-related terms, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
    /// Platforms Glossary</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePlatformVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_platform_version_input::Builder,
    }
    impl<C, M, R> DescribePlatformVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePlatformVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePlatformVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePlatformVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePlatformVersionInputOperationOutputAlias,
                crate::output::DescribePlatformVersionOutput,
                crate::error::DescribePlatformVersionError,
                crate::input::DescribePlatformVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(inp);
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateEnvironmentOperationsRole`.
    ///
    /// <p>Disassociate the operations role from an environment. After this call is made, Elastic Beanstalk uses
    /// the caller's permissions for permissions to downstream services during subsequent calls acting
    /// on this environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the
    /// <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateEnvironmentOperationsRole<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_environment_operations_role_input::Builder,
    }
    impl<C, M, R> DisassociateEnvironmentOperationsRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateEnvironmentOperationsRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateEnvironmentOperationsRoleOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateEnvironmentOperationsRoleError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateEnvironmentOperationsRoleInputOperationOutputAlias,
                crate::output::DisassociateEnvironmentOperationsRoleOutput,
                crate::error::DisassociateEnvironmentOperationsRoleError,
                crate::input::DisassociateEnvironmentOperationsRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment from which to disassociate the operations role.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the environment from which to disassociate the operations role.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAvailableSolutionStacks`.
    ///
    /// <p>Returns a list of the available solution stack names, with the public version first and
    /// then in reverse chronological order.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAvailableSolutionStacks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_available_solution_stacks_input::Builder,
    }
    impl<C, M, R> ListAvailableSolutionStacks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAvailableSolutionStacks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAvailableSolutionStacksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAvailableSolutionStacksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAvailableSolutionStacksInputOperationOutputAlias,
                crate::output::ListAvailableSolutionStacksOutput,
                crate::error::ListAvailableSolutionStacksError,
                crate::input::ListAvailableSolutionStacksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListPlatformBranches`.
    ///
    /// <p>Lists the platform branches available for your account in an AWS Region. Provides
    /// summary information about each platform branch.</p>
    /// <p>For definitions of platform branch and other platform-related terms, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
    /// Platforms Glossary</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPlatformBranches<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_platform_branches_input::Builder,
    }
    impl<C, M, R> ListPlatformBranches<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPlatformBranches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPlatformBranchesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPlatformBranchesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPlatformBranchesInputOperationOutputAlias,
                crate::output::ListPlatformBranchesOutput,
                crate::error::ListPlatformBranchesError,
                crate::input::ListPlatformBranchesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Criteria for restricting the resulting list of platform branches. The filter is evaluated
        /// as a logical conjunction (AND) of the separate <code>SearchFilter</code> terms.</p>
        /// <p>The following list shows valid attribute values for each of the <code>SearchFilter</code>
        /// terms. Most operators take a single value. The <code>in</code> and <code>not_in</code>
        /// operators can take multiple values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Attribute = BranchName</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code>
        /// | <code>ends_with</code> | <code>contains</code> | <code>in</code> |
        /// <code>not_in</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Attribute = LifecycleState</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> |
        /// <code>not_in</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Values</code>: <code>beta</code> | <code>supported</code> |
        /// <code>deprecated</code> | <code>retired</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Attribute = PlatformName</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code>
        /// | <code>ends_with</code> | <code>contains</code> | <code>in</code> |
        /// <code>not_in</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Attribute = TierType</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Operator</code>: <code>=</code> | <code>!=</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>Array size: limited to 10 <code>SearchFilter</code> objects.</p>
        /// <p>Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10
        /// items.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::SearchFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Criteria for restricting the resulting list of platform branches. The filter is evaluated
        /// as a logical conjunction (AND) of the separate <code>SearchFilter</code> terms.</p>
        /// <p>The following list shows valid attribute values for each of the <code>SearchFilter</code>
        /// terms. Most operators take a single value. The <code>in</code> and <code>not_in</code>
        /// operators can take multiple values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Attribute = BranchName</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code>
        /// | <code>ends_with</code> | <code>contains</code> | <code>in</code> |
        /// <code>not_in</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Attribute = LifecycleState</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> |
        /// <code>not_in</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Values</code>: <code>beta</code> | <code>supported</code> |
        /// <code>deprecated</code> | <code>retired</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Attribute = PlatformName</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code>
        /// | <code>ends_with</code> | <code>contains</code> | <code>in</code> |
        /// <code>not_in</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Attribute = TierType</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Operator</code>: <code>=</code> | <code>!=</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>Array size: limited to 10 <code>SearchFilter</code> objects.</p>
        /// <p>Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10
        /// items.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SearchFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of platform branch values returned in one call.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of platform branch values returned in one call.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the
        /// next response page. All other parameter values must be identical to the ones specified in the
        /// initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the
        /// next response page. All other parameter values must be identical to the ones specified in the
        /// initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPlatformVersions`.
    ///
    /// <p>Lists the platform versions available for your account in an AWS Region. Provides
    /// summary information about each platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
    /// version.</p>
    /// <p>For definitions of platform version and other platform-related terms, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
    /// Platforms Glossary</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPlatformVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_platform_versions_input::Builder,
    }
    impl<C, M, R> ListPlatformVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPlatformVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPlatformVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPlatformVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPlatformVersionsInputOperationOutputAlias,
                crate::output::ListPlatformVersionsOutput,
                crate::error::ListPlatformVersionsError,
                crate::input::ListPlatformVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Criteria for restricting the resulting list of platform versions. The filter is
        /// interpreted as a logical conjunction (AND) of the separate <code>PlatformFilter</code>
        /// terms.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::PlatformFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Criteria for restricting the resulting list of platform versions. The filter is
        /// interpreted as a logical conjunction (AND) of the separate <code>PlatformFilter</code>
        /// terms.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of platform version values returned in one call.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of platform version values returned in one call.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the
        /// next response page. All other parameter values must be identical to the ones specified in the
        /// initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the
        /// next response page. All other parameter values must be identical to the ones specified in the
        /// initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Return the tags applied to an AWS Elastic Beanstalk resource. The response contains a list of tag key-value pairs.</p>
    /// <p>Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see
    /// <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging Application
    /// Resources</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resouce for which a tag list is requested.</p>
        /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resouce for which a tag list is requested.</p>
        /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebuildEnvironment`.
    ///
    /// <p>Deletes and recreates all of the AWS resources (for example: the Auto Scaling group,
    /// load balancer, etc.) for a specified environment and forces a restart.</p>
    #[derive(std::fmt::Debug)]
    pub struct RebuildEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::rebuild_environment_input::Builder,
    }
    impl<C, M, R> RebuildEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RebuildEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebuildEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::RebuildEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RebuildEnvironmentInputOperationOutputAlias,
                crate::output::RebuildEnvironmentOutput,
                crate::error::RebuildEnvironmentError,
                crate::input::RebuildEnvironmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to rebuild.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the environment to rebuild.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the environment to rebuild.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the environment to rebuild.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RequestEnvironmentInfo`.
    ///
    /// <p>Initiates a request to compile the specified type of information of the deployed
    /// environment.</p>
    /// <p> Setting the <code>InfoType</code> to <code>tail</code> compiles the last lines from
    /// the application server log files of every Amazon EC2 instance in your environment. </p>
    /// <p> Setting the <code>InfoType</code> to <code>bundle</code> compresses the application
    /// server log files for every Amazon EC2 instance into a <code>.zip</code> file. Legacy and .NET
    /// containers do not support bundle logs. </p>
    /// <p> Use <a>RetrieveEnvironmentInfo</a> to obtain the set of logs. </p>
    /// <p>Related Topics</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>RetrieveEnvironmentInfo</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct RequestEnvironmentInfo<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::request_environment_info_input::Builder,
    }
    impl<C, M, R> RequestEnvironmentInfo<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RequestEnvironmentInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RequestEnvironmentInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::RequestEnvironmentInfoError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RequestEnvironmentInfoInputOperationOutputAlias,
                crate::output::RequestEnvironmentInfoOutput,
                crate::error::RequestEnvironmentInfoError,
                crate::input::RequestEnvironmentInfoInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment of the requested data.</p>
        /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an
        /// <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the environment of the requested data.</p>
        /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an
        /// <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the environment of the requested data.</p>
        /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an
        /// <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the environment of the requested data.</p>
        /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an
        /// <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The type of information to request.</p>
        pub fn info_type(mut self, inp: crate::model::EnvironmentInfoType) -> Self {
            self.inner = self.inner.info_type(inp);
            self
        }
        /// <p>The type of information to request.</p>
        pub fn set_info_type(
            mut self,
            input: std::option::Option<crate::model::EnvironmentInfoType>,
        ) -> Self {
            self.inner = self.inner.set_info_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestartAppServer`.
    ///
    /// <p>Causes the environment to restart the application container server running on each
    /// Amazon EC2 instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct RestartAppServer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restart_app_server_input::Builder,
    }
    impl<C, M, R> RestartAppServer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestartAppServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestartAppServerOutput,
            aws_smithy_http::result::SdkError<crate::error::RestartAppServerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestartAppServerInputOperationOutputAlias,
                crate::output::RestartAppServerOutput,
                crate::error::RestartAppServerError,
                crate::input::RestartAppServerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to restart the server for.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the environment to restart the server for.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the environment to restart the server for.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the environment to restart the server for.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetrieveEnvironmentInfo`.
    ///
    /// <p>Retrieves the compiled information from a <a>RequestEnvironmentInfo</a>
    /// request.</p>
    /// <p>Related Topics</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>RequestEnvironmentInfo</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct RetrieveEnvironmentInfo<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::retrieve_environment_info_input::Builder,
    }
    impl<C, M, R> RetrieveEnvironmentInfo<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RetrieveEnvironmentInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetrieveEnvironmentInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::RetrieveEnvironmentInfoError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RetrieveEnvironmentInfoInputOperationOutputAlias,
                crate::output::RetrieveEnvironmentInfoOutput,
                crate::error::RetrieveEnvironmentInfoError,
                crate::input::RetrieveEnvironmentInfoInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the data's environment.</p>
        /// <p>If no such environment is found, returns an <code>InvalidParameterValue</code>
        /// error.</p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code>
        /// error.</p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the data's environment.</p>
        /// <p>If no such environment is found, returns an <code>InvalidParameterValue</code>
        /// error.</p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code>
        /// error.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the data's environment.</p>
        /// <p> If no such environment is found, returns an <code>InvalidParameterValue</code> error. </p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the data's environment.</p>
        /// <p> If no such environment is found, returns an <code>InvalidParameterValue</code> error. </p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The type of information to retrieve.</p>
        pub fn info_type(mut self, inp: crate::model::EnvironmentInfoType) -> Self {
            self.inner = self.inner.info_type(inp);
            self
        }
        /// <p>The type of information to retrieve.</p>
        pub fn set_info_type(
            mut self,
            input: std::option::Option<crate::model::EnvironmentInfoType>,
        ) -> Self {
            self.inner = self.inner.set_info_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SwapEnvironmentCNAMEs`.
    ///
    /// <p>Swaps the CNAMEs of two environments.</p>
    #[derive(std::fmt::Debug)]
    pub struct SwapEnvironmentCNAMEs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::swap_environment_cnam_es_input::Builder,
    }
    impl<C, M, R> SwapEnvironmentCNAMEs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SwapEnvironmentCNAMEs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SwapEnvironmentCnamEsOutput,
            aws_smithy_http::result::SdkError<crate::error::SwapEnvironmentCNAMEsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SwapEnvironmentCnamEsInputOperationOutputAlias,
                crate::output::SwapEnvironmentCnamEsOutput,
                crate::error::SwapEnvironmentCNAMEsError,
                crate::input::SwapEnvironmentCnamEsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the source environment.</p>
        /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the
        /// <code>SourceEnvironmentName</code>. You may also specify both. If you specify the
        /// <code>SourceEnvironmentId</code>, you must specify the
        /// <code>DestinationEnvironmentId</code>. </p>
        pub fn source_environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_environment_id(inp);
            self
        }
        /// <p>The ID of the source environment.</p>
        /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the
        /// <code>SourceEnvironmentName</code>. You may also specify both. If you specify the
        /// <code>SourceEnvironmentId</code>, you must specify the
        /// <code>DestinationEnvironmentId</code>. </p>
        pub fn set_source_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_environment_id(input);
            self
        }
        /// <p>The name of the source environment.</p>
        /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the
        /// <code>SourceEnvironmentName</code>. You may also specify both. If you specify the
        /// <code>SourceEnvironmentName</code>, you must specify the
        /// <code>DestinationEnvironmentName</code>. </p>
        pub fn source_environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_environment_name(inp);
            self
        }
        /// <p>The name of the source environment.</p>
        /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the
        /// <code>SourceEnvironmentName</code>. You may also specify both. If you specify the
        /// <code>SourceEnvironmentName</code>, you must specify the
        /// <code>DestinationEnvironmentName</code>. </p>
        pub fn set_source_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_environment_name(input);
            self
        }
        /// <p>The ID of the destination environment.</p>
        /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the
        /// <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the
        /// <code>SourceEnvironmentId</code> with the <code>DestinationEnvironmentId</code>. </p>
        pub fn destination_environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_environment_id(inp);
            self
        }
        /// <p>The ID of the destination environment.</p>
        /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the
        /// <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the
        /// <code>SourceEnvironmentId</code> with the <code>DestinationEnvironmentId</code>. </p>
        pub fn set_destination_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_environment_id(input);
            self
        }
        /// <p>The name of the destination environment.</p>
        /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the
        /// <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the
        /// <code>SourceEnvironmentName</code> with the <code>DestinationEnvironmentName</code>.
        /// </p>
        pub fn destination_environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_environment_name(inp);
            self
        }
        /// <p>The name of the destination environment.</p>
        /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the
        /// <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the
        /// <code>SourceEnvironmentName</code> with the <code>DestinationEnvironmentName</code>.
        /// </p>
        pub fn set_destination_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateEnvironment`.
    ///
    /// <p>Terminates the specified environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct TerminateEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::terminate_environment_input::Builder,
    }
    impl<C, M, R> TerminateEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TerminateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TerminateEnvironmentInputOperationOutputAlias,
                crate::output::TerminateEnvironmentOutput,
                crate::error::TerminateEnvironmentError,
                crate::input::TerminateEnvironmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to terminate.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the environment to terminate.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the environment to terminate.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the environment to terminate.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>Indicates whether the associated AWS resources should shut down when the environment is
        /// terminated:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>true</code>: The specified environment as well as the associated AWS resources, such
        /// as Auto Scaling group and LoadBalancer, are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>false</code>: AWS Elastic Beanstalk resource management is removed from the
        /// environment, but the AWS resources continue to operate.</p>
        /// </li>
        /// </ul>
        /// <p> For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS Elastic Beanstalk User Guide. </a>
        /// </p>
        /// <p> Default: <code>true</code>
        /// </p>
        /// <p> Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn terminate_resources(mut self, inp: bool) -> Self {
            self.inner = self.inner.terminate_resources(inp);
            self
        }
        /// <p>Indicates whether the associated AWS resources should shut down when the environment is
        /// terminated:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>true</code>: The specified environment as well as the associated AWS resources, such
        /// as Auto Scaling group and LoadBalancer, are terminated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>false</code>: AWS Elastic Beanstalk resource management is removed from the
        /// environment, but the AWS resources continue to operate.</p>
        /// </li>
        /// </ul>
        /// <p> For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS Elastic Beanstalk User Guide. </a>
        /// </p>
        /// <p> Default: <code>true</code>
        /// </p>
        /// <p> Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_terminate_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_terminate_resources(input);
            self
        }
        /// <p>Terminates the target environment even if another environment in the same group is
        /// dependent on it.</p>
        pub fn force_terminate(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_terminate(inp);
            self
        }
        /// <p>Terminates the target environment even if another environment in the same group is
        /// dependent on it.</p>
        pub fn set_force_terminate(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_terminate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <p>Updates the specified application to have the specified properties.</p>
    /// <note>
    /// <p>If a property (for example, <code>description</code>) is not provided, the value
    /// remains unchanged. To clear these properties, specify an empty string.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_application_input::Builder,
    }
    impl<C, M, R> UpdateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApplicationInputOperationOutputAlias,
                crate::output::UpdateApplicationOutput,
                crate::error::UpdateApplicationError,
                crate::input::UpdateApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application to update. If no such application is found,
        /// <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error.
        /// </p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application to update. If no such application is found,
        /// <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error.
        /// </p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>A new description for the application.</p>
        /// <p>Default: If not specified, AWS Elastic Beanstalk does not update the
        /// description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A new description for the application.</p>
        /// <p>Default: If not specified, AWS Elastic Beanstalk does not update the
        /// description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplicationResourceLifecycle`.
    ///
    /// <p>Modifies lifecycle settings for an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApplicationResourceLifecycle<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_application_resource_lifecycle_input::Builder,
    }
    impl<C, M, R> UpdateApplicationResourceLifecycle<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApplicationResourceLifecycle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationResourceLifecycleOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateApplicationResourceLifecycleError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApplicationResourceLifecycleInputOperationOutputAlias,
                crate::output::UpdateApplicationResourceLifecycleOutput,
                crate::error::UpdateApplicationResourceLifecycleError,
                crate::input::UpdateApplicationResourceLifecycleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The lifecycle configuration.</p>
        pub fn resource_lifecycle_config(
            mut self,
            inp: crate::model::ApplicationResourceLifecycleConfig,
        ) -> Self {
            self.inner = self.inner.resource_lifecycle_config(inp);
            self
        }
        /// <p>The lifecycle configuration.</p>
        pub fn set_resource_lifecycle_config(
            mut self,
            input: std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_lifecycle_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplicationVersion`.
    ///
    /// <p>Updates the specified application version to have the specified properties.</p>
    /// <note>
    /// <p>If a property (for example, <code>description</code>) is not provided, the value
    /// remains unchanged. To clear properties, specify an empty string.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApplicationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_application_version_input::Builder,
    }
    impl<C, M, R> UpdateApplicationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApplicationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApplicationVersionInputOperationOutputAlias,
                crate::output::UpdateApplicationVersionOutput,
                crate::error::UpdateApplicationVersionError,
                crate::input::UpdateApplicationVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application associated with this version.</p>
        /// <p> If no application is found with this name, <code>UpdateApplication</code> returns an
        /// <code>InvalidParameterValue</code> error.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application associated with this version.</p>
        /// <p> If no application is found with this name, <code>UpdateApplication</code> returns an
        /// <code>InvalidParameterValue</code> error.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the version to update.</p>
        /// <p>If no application version is found with this label, <code>UpdateApplication</code>
        /// returns an <code>InvalidParameterValue</code> error. </p>
        pub fn version_label(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(inp);
            self
        }
        /// <p>The name of the version to update.</p>
        /// <p>If no application version is found with this label, <code>UpdateApplication</code>
        /// returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// <p>A new description for this version.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A new description for this version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationTemplate`.
    ///
    /// <p>Updates the specified configuration template to have the specified properties or
    /// configuration option values.</p>
    /// <note>
    /// <p>If a property (for example, <code>ApplicationName</code>) is not provided, its value
    /// remains unchanged. To clear such properties, specify an empty string.</p>
    /// </note>
    /// <p>Related Topics</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>DescribeConfigurationOptions</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConfigurationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_configuration_template_input::Builder,
    }
    impl<C, M, R> UpdateConfigurationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConfigurationTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConfigurationTemplateInputOperationOutputAlias,
                crate::output::UpdateConfigurationTemplateOutput,
                crate::error::UpdateConfigurationTemplateError,
                crate::input::UpdateConfigurationTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application associated with the configuration template to
        /// update.</p>
        /// <p> If no application is found with this name, <code>UpdateConfigurationTemplate</code>
        /// returns an <code>InvalidParameterValue</code> error. </p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application associated with the configuration template to
        /// update.</p>
        /// <p> If no application is found with this name, <code>UpdateConfigurationTemplate</code>
        /// returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the configuration template to update.</p>
        /// <p> If no configuration template is found with this name,
        /// <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code>
        /// error. </p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the configuration template to update.</p>
        /// <p> If no configuration template is found with this name,
        /// <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code>
        /// error. </p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>A new description for the configuration.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A new description for the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `OptionSettings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>A list of configuration option settings to update with the new specified option
        /// value.</p>
        pub fn option_settings(
            mut self,
            inp: impl Into<crate::model::ConfigurationOptionSetting>,
        ) -> Self {
            self.inner = self.inner.option_settings(inp);
            self
        }
        /// <p>A list of configuration option settings to update with the new specified option
        /// value.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.inner = self.inner.set_option_settings(input);
            self
        }
        /// Appends an item to `OptionsToRemove`.
        ///
        /// To override the contents of this collection use [`set_options_to_remove`](Self::set_options_to_remove).
        ///
        /// <p>A list of configuration options to remove from the configuration set.</p>
        /// <p> Constraint: You can remove only <code>UserDefined</code> configuration options.
        /// </p>
        pub fn options_to_remove(
            mut self,
            inp: impl Into<crate::model::OptionSpecification>,
        ) -> Self {
            self.inner = self.inner.options_to_remove(inp);
            self
        }
        /// <p>A list of configuration options to remove from the configuration set.</p>
        /// <p> Constraint: You can remove only <code>UserDefined</code> configuration options.
        /// </p>
        pub fn set_options_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_options_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEnvironment`.
    ///
    /// <p>Updates the environment description, deploys a new application version, updates the
    /// configuration settings to an entirely new configuration template, or updates select
    /// configuration option values in the running environment.</p>
    /// <p> Attempting to update both the release and configuration is not allowed and AWS Elastic
    /// Beanstalk returns an <code>InvalidParameterCombination</code> error. </p>
    /// <p> When updating the configuration settings to a new template or individual settings, a
    /// draft configuration is created and <a>DescribeConfigurationSettings</a> for this
    /// environment returns two setting descriptions with different <code>DeploymentStatus</code>
    /// values. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_environment_input::Builder,
    }
    impl<C, M, R> UpdateEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEnvironmentInputOperationOutputAlias,
                crate::output::UpdateEnvironmentOutput,
                crate::error::UpdateEnvironmentError,
                crate::input::UpdateEnvironmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application with which the environment is associated.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application with which the environment is associated.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The ID of the environment to update.</p>
        /// <p>If no environment with this ID exists, AWS Elastic Beanstalk returns an
        /// <code>InvalidParameterValue</code> error.</p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn environment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_id(inp);
            self
        }
        /// <p>The ID of the environment to update.</p>
        /// <p>If no environment with this ID exists, AWS Elastic Beanstalk returns an
        /// <code>InvalidParameterValue</code> error.</p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_id(input);
            self
        }
        /// <p>The name of the environment to update. If no environment with this name exists, AWS
        /// Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the environment to update. If no environment with this name exists, AWS
        /// Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not
        /// specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
        /// </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>The name of the group to which the target environment belongs. Specify a group name
        /// only if the environment's name is specified in an environment manifest and not with the
        /// environment name or environment ID parameters. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest
        /// (env.yaml)</a> for details.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group to which the target environment belongs. Specify a group name
        /// only if the environment's name is specified in an environment manifest and not with the
        /// environment name or environment ID parameters. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest
        /// (env.yaml)</a> for details.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk updates the description of this
        /// environment.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk updates the description of this
        /// environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>This specifies the tier to use to update the environment.</p>
        /// <p>Condition: At this time, if you change the tier version, name, or type, AWS Elastic
        /// Beanstalk returns <code>InvalidParameterValue</code> error. </p>
        pub fn tier(mut self, inp: crate::model::EnvironmentTier) -> Self {
            self.inner = self.inner.tier(inp);
            self
        }
        /// <p>This specifies the tier to use to update the environment.</p>
        /// <p>Condition: At this time, if you change the tier version, name, or type, AWS Elastic
        /// Beanstalk returns <code>InvalidParameterValue</code> error. </p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTier>,
        ) -> Self {
            self.inner = self.inner.set_tier(input);
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys the named application
        /// version to the environment. If no such application version is found, returns an
        /// <code>InvalidParameterValue</code> error. </p>
        pub fn version_label(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_label(inp);
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys the named application
        /// version to the environment. If no such application version is found, returns an
        /// <code>InvalidParameterValue</code> error. </p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_label(input);
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys this configuration
        /// template to the environment. If no such configuration template is found, AWS Elastic Beanstalk
        /// returns an <code>InvalidParameterValue</code> error. </p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys this configuration
        /// template to the environment. If no such configuration template is found, AWS Elastic Beanstalk
        /// returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>This specifies the platform version that the environment will run after the environment
        /// is updated.</p>
        pub fn solution_stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.solution_stack_name(inp);
            self
        }
        /// <p>This specifies the platform version that the environment will run after the environment
        /// is updated.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_solution_stack_name(input);
            self
        }
        /// <p>The ARN of the platform, if used.</p>
        pub fn platform_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_arn(inp);
            self
        }
        /// <p>The ARN of the platform, if used.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_arn(input);
            self
        }
        /// Appends an item to `OptionSettings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>If specified, AWS Elastic Beanstalk updates the configuration set associated with the
        /// running environment and sets the specified configuration options to the requested
        /// value.</p>
        pub fn option_settings(
            mut self,
            inp: impl Into<crate::model::ConfigurationOptionSetting>,
        ) -> Self {
            self.inner = self.inner.option_settings(inp);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk updates the configuration set associated with the
        /// running environment and sets the specified configuration options to the requested
        /// value.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.inner = self.inner.set_option_settings(input);
            self
        }
        /// Appends an item to `OptionsToRemove`.
        ///
        /// To override the contents of this collection use [`set_options_to_remove`](Self::set_options_to_remove).
        ///
        /// <p>A list of custom user-defined configuration options to remove from the configuration
        /// set for this environment.</p>
        pub fn options_to_remove(
            mut self,
            inp: impl Into<crate::model::OptionSpecification>,
        ) -> Self {
            self.inner = self.inner.options_to_remove(inp);
            self
        }
        /// <p>A list of custom user-defined configuration options to remove from the configuration
        /// set for this environment.</p>
        pub fn set_options_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_options_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTagsForResource`.
    ///
    /// <p>Update the list of tags applied to an AWS Elastic Beanstalk resource. Two lists can be passed: <code>TagsToAdd</code>
    /// for tags to add or update, and <code>TagsToRemove</code>.</p>
    /// <p>Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see
    /// <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging Application
    /// Resources</a>.</p>
    /// <p>If you create a custom IAM user policy to control permission to this operation, specify
    /// one of the following two virtual actions (or both) instead of the API operation name:</p>
    /// <dl>
    /// <dt>elasticbeanstalk:AddTags</dt>
    /// <dd>
    /// <p>Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tags to add in the <code>TagsToAdd</code>
    /// parameter.</p>
    /// </dd>
    /// <dt>elasticbeanstalk:RemoveTags</dt>
    /// <dd>
    /// <p>Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tag keys to remove in the <code>TagsToRemove</code>
    /// parameter.</p>
    /// </dd>
    /// </dl>
    /// <p>For details about creating a custom user policy, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies">Creating a Custom User Policy</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_tags_for_resource_input::Builder,
    }
    impl<C, M, R> UpdateTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTagsForResourceInputOperationOutputAlias,
                crate::output::UpdateTagsForResourceOutput,
                crate::error::UpdateTagsForResourceError,
                crate::input::UpdateTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resouce to be updated.</p>
        /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resouce to be updated.</p>
        /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagsToAdd`.
        ///
        /// To override the contents of this collection use [`set_tags_to_add`](Self::set_tags_to_add).
        ///
        /// <p>A list of tags to add or update. If a key of an existing tag is added, the tag's value is
        /// updated.</p>
        /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>,
        /// <code>TagsToRemove</code>.</p>
        pub fn tags_to_add(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags_to_add(inp);
            self
        }
        /// <p>A list of tags to add or update. If a key of an existing tag is added, the tag's value is
        /// updated.</p>
        /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>,
        /// <code>TagsToRemove</code>.</p>
        pub fn set_tags_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags_to_add(input);
            self
        }
        /// Appends an item to `TagsToRemove`.
        ///
        /// To override the contents of this collection use [`set_tags_to_remove`](Self::set_tags_to_remove).
        ///
        /// <p>A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.</p>
        /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>,
        /// <code>TagsToRemove</code>.</p>
        pub fn tags_to_remove(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tags_to_remove(inp);
            self
        }
        /// <p>A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.</p>
        /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>,
        /// <code>TagsToRemove</code>.</p>
        pub fn set_tags_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tags_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ValidateConfigurationSettings`.
    ///
    /// <p>Takes a set of configuration settings and either a configuration template or
    /// environment, and determines whether those values are valid.</p>
    /// <p>This action returns a list of messages indicating any errors or warnings associated
    /// with the selection of option values.</p>
    #[derive(std::fmt::Debug)]
    pub struct ValidateConfigurationSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::validate_configuration_settings_input::Builder,
    }
    impl<C, M, R> ValidateConfigurationSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ValidateConfigurationSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ValidateConfigurationSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ValidateConfigurationSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ValidateConfigurationSettingsInputOperationOutputAlias,
                crate::output::ValidateConfigurationSettingsOutput,
                crate::error::ValidateConfigurationSettingsError,
                crate::input::ValidateConfigurationSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application that the configuration template or environment belongs
        /// to.</p>
        pub fn application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(inp);
            self
        }
        /// <p>The name of the application that the configuration template or environment belongs
        /// to.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The name of the configuration template to validate the settings against.</p>
        /// <p>Condition: You cannot specify both this and an environment name.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the configuration template to validate the settings against.</p>
        /// <p>Condition: You cannot specify both this and an environment name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The name of the environment to validate the settings against.</p>
        /// <p>Condition: You cannot specify both this and a configuration template name.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the environment to validate the settings against.</p>
        /// <p>Condition: You cannot specify both this and a configuration template name.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// Appends an item to `OptionSettings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>A list of the options and desired values to evaluate.</p>
        pub fn option_settings(
            mut self,
            inp: impl Into<crate::model::ConfigurationOptionSetting>,
        ) -> Self {
            self.inner = self.inner.option_settings(inp);
            self
        }
        /// <p>A list of the options and desired values to evaluate.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.inner = self.inner.set_option_settings(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
