// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AbortEnvironmentUpdateInput`](crate::input::AbortEnvironmentUpdateInput)
pub mod abort_environment_update_input {
    /// A builder for [`AbortEnvironmentUpdateInput`](crate::input::AbortEnvironmentUpdateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>This specifies the ID of the environment with the in-progress update that you want to cancel.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>This specifies the ID of the environment with the in-progress update that you want to cancel.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>This specifies the name of the environment with the in-progress update that you want to cancel.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>This specifies the name of the environment with the in-progress update that you want to cancel.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AbortEnvironmentUpdateInput`](crate::input::AbortEnvironmentUpdateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AbortEnvironmentUpdateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AbortEnvironmentUpdateInput {
                environment_id: self.environment_id,
                environment_name: self.environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AbortEnvironmentUpdateInputOperationOutputAlias = crate::operation::AbortEnvironmentUpdate;
#[doc(hidden)]
pub type AbortEnvironmentUpdateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AbortEnvironmentUpdateInput {
    /// Consumes the builder and constructs an Operation<[`AbortEnvironmentUpdate`](crate::operation::AbortEnvironmentUpdate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AbortEnvironmentUpdate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AbortEnvironmentUpdateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AbortEnvironmentUpdateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_abort_environment_update(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AbortEnvironmentUpdate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AbortEnvironmentUpdate",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AbortEnvironmentUpdateInput`](crate::input::AbortEnvironmentUpdateInput)
    pub fn builder() -> crate::input::abort_environment_update_input::Builder {
        crate::input::abort_environment_update_input::Builder::default()
    }
}

/// See [`ApplyEnvironmentManagedActionInput`](crate::input::ApplyEnvironmentManagedActionInput)
pub mod apply_environment_managed_action_input {
    /// A builder for [`ApplyEnvironmentManagedActionInput`](crate::input::ApplyEnvironmentManagedActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) action_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the target environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the target environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The action ID of the scheduled managed action to execute.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>The action ID of the scheduled managed action to execute.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplyEnvironmentManagedActionInput`](crate::input::ApplyEnvironmentManagedActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ApplyEnvironmentManagedActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ApplyEnvironmentManagedActionInput {
                environment_name: self.environment_name,
                environment_id: self.environment_id,
                action_id: self.action_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ApplyEnvironmentManagedActionInputOperationOutputAlias =
    crate::operation::ApplyEnvironmentManagedAction;
#[doc(hidden)]
pub type ApplyEnvironmentManagedActionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ApplyEnvironmentManagedActionInput {
    /// Consumes the builder and constructs an Operation<[`ApplyEnvironmentManagedAction`](crate::operation::ApplyEnvironmentManagedAction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ApplyEnvironmentManagedAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ApplyEnvironmentManagedActionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ApplyEnvironmentManagedActionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_apply_environment_managed_action(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ApplyEnvironmentManagedAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ApplyEnvironmentManagedAction",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ApplyEnvironmentManagedActionInput`](crate::input::ApplyEnvironmentManagedActionInput)
    pub fn builder() -> crate::input::apply_environment_managed_action_input::Builder {
        crate::input::apply_environment_managed_action_input::Builder::default()
    }
}

/// See [`AssociateEnvironmentOperationsRoleInput`](crate::input::AssociateEnvironmentOperationsRoleInput)
pub mod associate_environment_operations_role_input {
    /// A builder for [`AssociateEnvironmentOperationsRoleInput`](crate::input::AssociateEnvironmentOperationsRoleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) operations_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the environment to which to set the operations role.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment to which to set the operations role.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role.</p>
        pub fn operations_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.operations_role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role.</p>
        pub fn set_operations_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operations_role = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateEnvironmentOperationsRoleInput`](crate::input::AssociateEnvironmentOperationsRoleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateEnvironmentOperationsRoleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateEnvironmentOperationsRoleInput {
                environment_name: self.environment_name,
                operations_role: self.operations_role,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateEnvironmentOperationsRoleInputOperationOutputAlias =
    crate::operation::AssociateEnvironmentOperationsRole;
#[doc(hidden)]
pub type AssociateEnvironmentOperationsRoleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateEnvironmentOperationsRoleInput {
    /// Consumes the builder and constructs an Operation<[`AssociateEnvironmentOperationsRole`](crate::operation::AssociateEnvironmentOperationsRole)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateEnvironmentOperationsRole,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateEnvironmentOperationsRoleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateEnvironmentOperationsRoleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_environment_operations_role(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateEnvironmentOperationsRole::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateEnvironmentOperationsRole",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateEnvironmentOperationsRoleInput`](crate::input::AssociateEnvironmentOperationsRoleInput)
    pub fn builder() -> crate::input::associate_environment_operations_role_input::Builder {
        crate::input::associate_environment_operations_role_input::Builder::default()
    }
}

/// See [`CheckDnsAvailabilityInput`](crate::input::CheckDnsAvailabilityInput)
pub mod check_dns_availability_input {
    /// A builder for [`CheckDnsAvailabilityInput`](crate::input::CheckDnsAvailabilityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cname_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The prefix used when this CNAME is reserved.</p>
        pub fn cname_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.cname_prefix = Some(input.into());
            self
        }
        /// <p>The prefix used when this CNAME is reserved.</p>
        pub fn set_cname_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cname_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`CheckDnsAvailabilityInput`](crate::input::CheckDnsAvailabilityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CheckDnsAvailabilityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CheckDnsAvailabilityInput {
                cname_prefix: self.cname_prefix,
            })
        }
    }
}
#[doc(hidden)]
pub type CheckDnsAvailabilityInputOperationOutputAlias = crate::operation::CheckDNSAvailability;
#[doc(hidden)]
pub type CheckDnsAvailabilityInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CheckDnsAvailabilityInput {
    /// Consumes the builder and constructs an Operation<[`CheckDNSAvailability`](crate::operation::CheckDNSAvailability)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CheckDNSAvailability,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CheckDnsAvailabilityInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CheckDnsAvailabilityInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_check_dns_availability(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CheckDNSAvailability::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CheckDNSAvailability",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CheckDnsAvailabilityInput`](crate::input::CheckDnsAvailabilityInput)
    pub fn builder() -> crate::input::check_dns_availability_input::Builder {
        crate::input::check_dns_availability_input::Builder::default()
    }
}

/// See [`ComposeEnvironmentsInput`](crate::input::ComposeEnvironmentsInput)
pub mod compose_environments_input {
    /// A builder for [`ComposeEnvironmentsInput`](crate::input::ComposeEnvironmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) version_labels: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the application to which the specified source bundles belong.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application to which the specified source bundles belong.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of the group to which the target environments belong. Specify a group name only if the environment name defined in each target environment's manifest ends with a + (plus) character. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group to which the target environments belong. Specify a group name only if the environment name defined in each target environment's manifest ends with a + (plus) character. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// Appends an item to `version_labels`.
        ///
        /// To override the contents of this collection use [`set_version_labels`](Self::set_version_labels).
        ///
        /// <p>A list of version labels, specifying one or more application source bundles that belong to the target application. Each source bundle must include an environment manifest that specifies the name of the environment and the name of the solution stack to use, and optionally can specify environment links to create.</p>
        pub fn version_labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.version_labels.unwrap_or_default();
            v.push(input.into());
            self.version_labels = Some(v);
            self
        }
        /// <p>A list of version labels, specifying one or more application source bundles that belong to the target application. Each source bundle must include an environment manifest that specifies the name of the environment and the name of the solution stack to use, and optionally can specify environment links to create.</p>
        pub fn set_version_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.version_labels = input;
            self
        }
        /// Consumes the builder and constructs a [`ComposeEnvironmentsInput`](crate::input::ComposeEnvironmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ComposeEnvironmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ComposeEnvironmentsInput {
                application_name: self.application_name,
                group_name: self.group_name,
                version_labels: self.version_labels,
            })
        }
    }
}
#[doc(hidden)]
pub type ComposeEnvironmentsInputOperationOutputAlias = crate::operation::ComposeEnvironments;
#[doc(hidden)]
pub type ComposeEnvironmentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ComposeEnvironmentsInput {
    /// Consumes the builder and constructs an Operation<[`ComposeEnvironments`](crate::operation::ComposeEnvironments)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ComposeEnvironments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ComposeEnvironmentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ComposeEnvironmentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_compose_environments(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ComposeEnvironments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ComposeEnvironments",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ComposeEnvironmentsInput`](crate::input::ComposeEnvironmentsInput)
    pub fn builder() -> crate::input::compose_environments_input::Builder {
        crate::input::compose_environments_input::Builder::default()
    }
}

/// See [`CreateApplicationInput`](crate::input::CreateApplicationInput)
pub mod create_application_input {
    /// A builder for [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) resource_lifecycle_config:
            std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the application. Must be unique within your account.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application. Must be unique within your account.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>Your description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Your description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions.</p>
        pub fn resource_lifecycle_config(
            mut self,
            input: crate::model::ApplicationResourceLifecycleConfig,
        ) -> Self {
            self.resource_lifecycle_config = Some(input);
            self
        }
        /// <p>Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions.</p>
        pub fn set_resource_lifecycle_config(
            mut self,
            input: std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
        ) -> Self {
            self.resource_lifecycle_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the application.</p>
        /// <p>Elastic Beanstalk applies these tags only to the application. Environments that you create in the application don't inherit the tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Specifies the tags applied to the application.</p>
        /// <p>Elastic Beanstalk applies these tags only to the application. Environments that you create in the application don't inherit the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationInput`](crate::input::CreateApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApplicationInput {
                application_name: self.application_name,
                description: self.description,
                resource_lifecycle_config: self.resource_lifecycle_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApplicationInputOperationOutputAlias = crate::operation::CreateApplication;
#[doc(hidden)]
pub type CreateApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateApplicationInput {
    /// Consumes the builder and constructs an Operation<[`CreateApplication`](crate::operation::CreateApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_application(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApplication",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    pub fn builder() -> crate::input::create_application_input::Builder {
        crate::input::create_application_input::Builder::default()
    }
}

/// See [`CreateApplicationVersionInput`](crate::input::CreateApplicationVersionInput)
pub mod create_application_version_input {
    /// A builder for [`CreateApplicationVersionInput`](crate::input::CreateApplicationVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source_build_information:
            std::option::Option<crate::model::SourceBuildInformation>,
        pub(crate) source_bundle: std::option::Option<crate::model::S3Location>,
        pub(crate) build_configuration: std::option::Option<crate::model::BuildConfiguration>,
        pub(crate) auto_create_application: std::option::Option<bool>,
        pub(crate) process: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p> The name of the application. If no application is found with this name, and <code>AutoCreateApplication</code> is <code>false</code>, returns an <code>InvalidParameterValue</code> error. </p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p> The name of the application. If no application is found with this name, and <code>AutoCreateApplication</code> is <code>false</code>, returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>A label identifying this version.</p>
        /// <p>Constraint: Must be unique per application. If an application version already exists with this label for the specified application, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>A label identifying this version.</p>
        /// <p>Constraint: Must be unique per application. If an application version already exists with this label for the specified application, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// <p>A description of this application version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of this application version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application version.</p>
        pub fn source_build_information(
            mut self,
            input: crate::model::SourceBuildInformation,
        ) -> Self {
            self.source_build_information = Some(input);
            self
        }
        /// <p>Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application version.</p>
        pub fn set_source_build_information(
            mut self,
            input: std::option::Option<crate::model::SourceBuildInformation>,
        ) -> Self {
            self.source_build_information = input;
            self
        }
        /// <p>The Amazon S3 bucket and key that identify the location of the source bundle for this version.</p> <note>
        /// <p>The Amazon S3 bucket must be in the same region as the environment.</p>
        /// </note>
        /// <p>Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample application.</p>
        pub fn source_bundle(mut self, input: crate::model::S3Location) -> Self {
            self.source_bundle = Some(input);
            self
        }
        /// <p>The Amazon S3 bucket and key that identify the location of the source bundle for this version.</p> <note>
        /// <p>The Amazon S3 bucket must be in the same region as the environment.</p>
        /// </note>
        /// <p>Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample application.</p>
        pub fn set_source_bundle(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.source_bundle = input;
            self
        }
        /// <p>Settings for an AWS CodeBuild build.</p>
        pub fn build_configuration(mut self, input: crate::model::BuildConfiguration) -> Self {
            self.build_configuration = Some(input);
            self
        }
        /// <p>Settings for an AWS CodeBuild build.</p>
        pub fn set_build_configuration(
            mut self,
            input: std::option::Option<crate::model::BuildConfiguration>,
        ) -> Self {
            self.build_configuration = input;
            self
        }
        /// <p>Set to <code>true</code> to create an application with the specified name if it doesn't already exist.</p>
        pub fn auto_create_application(mut self, input: bool) -> Self {
            self.auto_create_application = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to create an application with the specified name if it doesn't already exist.</p>
        pub fn set_auto_create_application(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_create_application = input;
            self
        }
        /// <p>Pre-processes and validates the environment manifest (<code>env.yaml</code>) and configuration files (<code>*.config</code> files in the <code>.ebextensions</code> folder) in the source bundle. Validating configuration files can identify issues prior to deploying the application version to an environment.</p>
        /// <p>You must turn processing on for application versions that you create using AWS CodeBuild or AWS CodeCommit. For application versions built from a source bundle in Amazon S3, processing is optional.</p> <note>
        /// <p>The <code>Process</code> option validates Elastic Beanstalk configuration files. It doesn't validate your application's configuration files, like proxy server or Docker configuration.</p>
        /// </note>
        pub fn process(mut self, input: bool) -> Self {
            self.process = Some(input);
            self
        }
        /// <p>Pre-processes and validates the environment manifest (<code>env.yaml</code>) and configuration files (<code>*.config</code> files in the <code>.ebextensions</code> folder) in the source bundle. Validating configuration files can identify issues prior to deploying the application version to an environment.</p>
        /// <p>You must turn processing on for application versions that you create using AWS CodeBuild or AWS CodeCommit. For application versions built from a source bundle in Amazon S3, processing is optional.</p> <note>
        /// <p>The <code>Process</code> option validates Elastic Beanstalk configuration files. It doesn't validate your application's configuration files, like proxy server or Docker configuration.</p>
        /// </note>
        pub fn set_process(mut self, input: std::option::Option<bool>) -> Self {
            self.process = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the application version.</p>
        /// <p>Elastic Beanstalk applies these tags only to the application version. Environments that use the application version don't inherit the tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Specifies the tags applied to the application version.</p>
        /// <p>Elastic Beanstalk applies these tags only to the application version. Environments that use the application version don't inherit the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationVersionInput`](crate::input::CreateApplicationVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApplicationVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApplicationVersionInput {
                application_name: self.application_name,
                version_label: self.version_label,
                description: self.description,
                source_build_information: self.source_build_information,
                source_bundle: self.source_bundle,
                build_configuration: self.build_configuration,
                auto_create_application: self.auto_create_application,
                process: self.process,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApplicationVersionInputOperationOutputAlias =
    crate::operation::CreateApplicationVersion;
#[doc(hidden)]
pub type CreateApplicationVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateApplicationVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateApplicationVersion`](crate::operation::CreateApplicationVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApplicationVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateApplicationVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateApplicationVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_application_version(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApplicationVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApplicationVersion",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateApplicationVersionInput`](crate::input::CreateApplicationVersionInput)
    pub fn builder() -> crate::input::create_application_version_input::Builder {
        crate::input::create_application_version_input::Builder::default()
    }
}

/// See [`CreateConfigurationTemplateInput`](crate::input::CreateConfigurationTemplateInput)
pub mod create_configuration_template_input {
    /// A builder for [`CreateConfigurationTemplateInput`](crate::input::CreateConfigurationTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) source_configuration: std::option::Option<crate::model::SourceConfiguration>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) option_settings:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the Elastic Beanstalk application to associate with this configuration template.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the Elastic Beanstalk application to associate with this configuration template.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of the configuration template.</p>
        /// <p>Constraint: This name must be unique per application.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration template.</p>
        /// <p>Constraint: This name must be unique per application.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses. For example, <code>64bit Amazon Linux 2013.09 running Tomcat 7 Java 7</code>. A solution stack specifies the operating system, runtime, and application server for a configuration template. It also determines the set of configuration options as well as the possible and default values. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Supported Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        /// <p>You must specify <code>SolutionStackName</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SourceConfiguration</code>.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html"> <code>ListAvailableSolutionStacks</code> </a> API to obtain a list of available solution stacks.</p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p>The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses. For example, <code>64bit Amazon Linux 2013.09 running Tomcat 7 Java 7</code>. A solution stack specifies the operating system, runtime, and application server for a configuration template. It also determines the set of configuration options as well as the possible and default values. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Supported Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        /// <p>You must specify <code>SolutionStackName</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SourceConfiguration</code>.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html"> <code>ListAvailableSolutionStacks</code> </a> API to obtain a list of available solution stacks.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom platform. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html"> Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
        /// <p>If you specify <code>PlatformArn</code>, then don't specify <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom platform. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html"> Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
        /// <p>If you specify <code>PlatformArn</code>, then don't specify <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// <p>An Elastic Beanstalk configuration template to base this one on. If specified, Elastic Beanstalk uses the configuration values from the specified configuration template to create a new configuration.</p>
        /// <p>Values specified in <code>OptionSettings</code> override any values obtained from the <code>SourceConfiguration</code>.</p>
        /// <p>You must specify <code>SourceConfiguration</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SolutionStackName</code>.</p>
        /// <p>Constraint: If both solution stack name and source configuration are specified, the solution stack of the source configuration template must match the specified solution stack name.</p>
        pub fn source_configuration(mut self, input: crate::model::SourceConfiguration) -> Self {
            self.source_configuration = Some(input);
            self
        }
        /// <p>An Elastic Beanstalk configuration template to base this one on. If specified, Elastic Beanstalk uses the configuration values from the specified configuration template to create a new configuration.</p>
        /// <p>Values specified in <code>OptionSettings</code> override any values obtained from the <code>SourceConfiguration</code>.</p>
        /// <p>You must specify <code>SourceConfiguration</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SolutionStackName</code>.</p>
        /// <p>Constraint: If both solution stack name and source configuration are specified, the solution stack of the source configuration template must match the specified solution stack name.</p>
        pub fn set_source_configuration(
            mut self,
            input: std::option::Option<crate::model::SourceConfiguration>,
        ) -> Self {
            self.source_configuration = input;
            self
        }
        /// <p>The ID of an environment whose settings you want to use to create the configuration template. You must specify <code>EnvironmentId</code> if you don't specify <code>PlatformArn</code>, <code>SolutionStackName</code>, or <code>SourceConfiguration</code>.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of an environment whose settings you want to use to create the configuration template. You must specify <code>EnvironmentId</code> if you don't specify <code>PlatformArn</code>, <code>SolutionStackName</code>, or <code>SourceConfiguration</code>.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>An optional description for this configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description for this configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `option_settings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>Option values for the Elastic Beanstalk configuration, such as the instance type. If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html">Option Values</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            let mut v = self.option_settings.unwrap_or_default();
            v.push(input);
            self.option_settings = Some(v);
            self
        }
        /// <p>Option values for the Elastic Beanstalk configuration, such as the instance type. If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html">Option Values</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.option_settings = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the configuration template.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Specifies the tags applied to the configuration template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationTemplateInput`](crate::input::CreateConfigurationTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConfigurationTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConfigurationTemplateInput {
                application_name: self.application_name,
                template_name: self.template_name,
                solution_stack_name: self.solution_stack_name,
                platform_arn: self.platform_arn,
                source_configuration: self.source_configuration,
                environment_id: self.environment_id,
                description: self.description,
                option_settings: self.option_settings,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConfigurationTemplateInputOperationOutputAlias =
    crate::operation::CreateConfigurationTemplate;
#[doc(hidden)]
pub type CreateConfigurationTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateConfigurationTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateConfigurationTemplate`](crate::operation::CreateConfigurationTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConfigurationTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateConfigurationTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateConfigurationTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_configuration_template(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConfigurationTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConfigurationTemplate",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateConfigurationTemplateInput`](crate::input::CreateConfigurationTemplateInput)
    pub fn builder() -> crate::input::create_configuration_template_input::Builder {
        crate::input::create_configuration_template_input::Builder::default()
    }
}

/// See [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
pub mod create_environment_input {
    /// A builder for [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) cname_prefix: std::option::Option<std::string::String>,
        pub(crate) tier: std::option::Option<crate::model::EnvironmentTier>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) option_settings:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        pub(crate) options_to_remove:
            std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
        pub(crate) operations_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the application that is associated with this environment.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application that is associated with this environment.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>A unique name for the environment.</p>
        /// <p>Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and hyphens. It can't start or end with a hyphen. This name must be unique within a region in your account. If the specified name already exists in the region, Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>If you don't specify the <code>CNAMEPrefix</code> parameter, the environment name becomes part of the CNAME, and therefore part of the visible URL for your application.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>A unique name for the environment.</p>
        /// <p>Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and hyphens. It can't start or end with a hyphen. This name must be unique within a region in your account. If the specified name already exists in the region, Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>If you don't specify the <code>CNAMEPrefix</code> parameter, the environment name becomes part of the CNAME, and therefore part of the visible URL for your application.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name parameter. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name parameter. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>Your description for this environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Your description for this environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>If specified, the environment attempts to use this value as the prefix for the CNAME in your Elastic Beanstalk environment URL. If not specified, the CNAME is generated automatically by appending a random alphanumeric string to the environment name.</p>
        pub fn cname_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.cname_prefix = Some(input.into());
            self
        }
        /// <p>If specified, the environment attempts to use this value as the prefix for the CNAME in your Elastic Beanstalk environment URL. If not specified, the CNAME is generated automatically by appending a random alphanumeric string to the environment name.</p>
        pub fn set_cname_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cname_prefix = input;
            self
        }
        /// <p>Specifies the tier to use in creating this environment. The environment tier that you choose determines whether Elastic Beanstalk provisions resources to support a web application that handles HTTP(S) requests or a web application that handles background-processing tasks.</p>
        pub fn tier(mut self, input: crate::model::EnvironmentTier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>Specifies the tier to use in creating this environment. The environment tier that you choose determines whether Elastic Beanstalk provisions resources to support a web application that handles HTTP(S) requests or a web application that handles background-processing tasks.</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTier>,
        ) -> Self {
            self.tier = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to resources in the environment.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Specifies the tags applied to resources in the environment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the application version to deploy.</p>
        /// <p>Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>The name of the application version to deploy.</p>
        /// <p>Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// <p>The name of the Elastic Beanstalk configuration template to use with the environment.</p> <note>
        /// <p>If you specify <code>TemplateName</code>, then don't specify <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the Elastic Beanstalk configuration template to use with the environment.</p> <note>
        /// <p>If you specify <code>TemplateName</code>, then don't specify <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If specified, Elastic Beanstalk sets the configuration values to the default values associated with the specified solution stack. For a list of current solution stacks, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic Beanstalk Supported Platforms</a> in the <i>AWS Elastic Beanstalk Platforms</i> guide.</p> <note>
        /// <p>If you specify <code>SolutionStackName</code>, don't specify <code>PlatformArn</code> or <code>TemplateName</code>.</p>
        /// </note>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p>The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If specified, Elastic Beanstalk sets the configuration values to the default values associated with the specified solution stack. For a list of current solution stacks, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic Beanstalk Supported Platforms</a> in the <i>AWS Elastic Beanstalk Platforms</i> guide.</p> <note>
        /// <p>If you specify <code>SolutionStackName</code>, don't specify <code>PlatformArn</code> or <code>TemplateName</code>.</p>
        /// </note>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom platform to use with the environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
        /// <p>If you specify <code>PlatformArn</code>, don't specify <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom platform to use with the environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
        /// <p>If you specify <code>PlatformArn</code>, don't specify <code>SolutionStackName</code>.</p>
        /// </note>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// Appends an item to `option_settings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the configuration set for the new environment. These override the values obtained from the solution stack or the configuration template.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            let mut v = self.option_settings.unwrap_or_default();
            v.push(input);
            self.option_settings = Some(v);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the configuration set for the new environment. These override the values obtained from the solution stack or the configuration template.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.option_settings = input;
            self
        }
        /// Appends an item to `options_to_remove`.
        ///
        /// To override the contents of this collection use [`set_options_to_remove`](Self::set_options_to_remove).
        ///
        /// <p>A list of custom user-defined configuration options to remove from the configuration set for this new environment.</p>
        pub fn options_to_remove(mut self, input: crate::model::OptionSpecification) -> Self {
            let mut v = self.options_to_remove.unwrap_or_default();
            v.push(input);
            self.options_to_remove = Some(v);
            self
        }
        /// <p>A list of custom user-defined configuration options to remove from the configuration set for this new environment.</p>
        pub fn set_options_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
        ) -> Self {
            self.options_to_remove = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role. If specified, Elastic Beanstalk uses the operations role for permissions to downstream services during this call and during subsequent calls acting on this environment. To specify an operations role, you must have the <code>iam:PassRole</code> permission for the role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn operations_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.operations_role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role. If specified, Elastic Beanstalk uses the operations role for permissions to downstream services during this call and during subsequent calls acting on this environment. To specify an operations role, you must have the <code>iam:PassRole</code> permission for the role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn set_operations_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operations_role = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEnvironmentInput {
                application_name: self.application_name,
                environment_name: self.environment_name,
                group_name: self.group_name,
                description: self.description,
                cname_prefix: self.cname_prefix,
                tier: self.tier,
                tags: self.tags,
                version_label: self.version_label,
                template_name: self.template_name,
                solution_stack_name: self.solution_stack_name,
                platform_arn: self.platform_arn,
                option_settings: self.option_settings,
                options_to_remove: self.options_to_remove,
                operations_role: self.operations_role,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEnvironmentInputOperationOutputAlias = crate::operation::CreateEnvironment;
#[doc(hidden)]
pub type CreateEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`CreateEnvironment`](crate::operation::CreateEnvironment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateEnvironmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateEnvironmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_environment(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEnvironment",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
    pub fn builder() -> crate::input::create_environment_input::Builder {
        crate::input::create_environment_input::Builder::default()
    }
}

/// See [`CreatePlatformVersionInput`](crate::input::CreatePlatformVersionInput)
pub mod create_platform_version_input {
    /// A builder for [`CreatePlatformVersionInput`](crate::input::CreatePlatformVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_name: std::option::Option<std::string::String>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) platform_definition_bundle: std::option::Option<crate::model::S3Location>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) option_settings:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of your custom platform.</p>
        pub fn platform_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_name = Some(input.into());
            self
        }
        /// <p>The name of your custom platform.</p>
        pub fn set_platform_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_name = input;
            self
        }
        /// <p>The number, such as 1.0.2, for the new platform version.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The number, such as 1.0.2, for the new platform version.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>The location of the platform definition archive in Amazon S3.</p>
        pub fn platform_definition_bundle(mut self, input: crate::model::S3Location) -> Self {
            self.platform_definition_bundle = Some(input);
            self
        }
        /// <p>The location of the platform definition archive in Amazon S3.</p>
        pub fn set_platform_definition_bundle(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.platform_definition_bundle = input;
            self
        }
        /// <p>The name of the builder environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the builder environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Appends an item to `option_settings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>The configuration option settings to apply to the builder environment.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            let mut v = self.option_settings.unwrap_or_default();
            v.push(input);
            self.option_settings = Some(v);
            self
        }
        /// <p>The configuration option settings to apply to the builder environment.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.option_settings = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the tags applied to the new platform version.</p>
        /// <p>Elastic Beanstalk applies these tags only to the platform version. Environments that you create using the platform version don't inherit the tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Specifies the tags applied to the new platform version.</p>
        /// <p>Elastic Beanstalk applies these tags only to the platform version. Environments that you create using the platform version don't inherit the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePlatformVersionInput`](crate::input::CreatePlatformVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePlatformVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePlatformVersionInput {
                platform_name: self.platform_name,
                platform_version: self.platform_version,
                platform_definition_bundle: self.platform_definition_bundle,
                environment_name: self.environment_name,
                option_settings: self.option_settings,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePlatformVersionInputOperationOutputAlias = crate::operation::CreatePlatformVersion;
#[doc(hidden)]
pub type CreatePlatformVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePlatformVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreatePlatformVersion`](crate::operation::CreatePlatformVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePlatformVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePlatformVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePlatformVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_platform_version(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePlatformVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePlatformVersion",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePlatformVersionInput`](crate::input::CreatePlatformVersionInput)
    pub fn builder() -> crate::input::create_platform_version_input::Builder {
        crate::input::create_platform_version_input::Builder::default()
    }
}

/// See [`CreateStorageLocationInput`](crate::input::CreateStorageLocationInput)
pub mod create_storage_location_input {
    /// A builder for [`CreateStorageLocationInput`](crate::input::CreateStorageLocationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateStorageLocationInput`](crate::input::CreateStorageLocationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStorageLocationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStorageLocationInput {})
        }
    }
}
#[doc(hidden)]
pub type CreateStorageLocationInputOperationOutputAlias = crate::operation::CreateStorageLocation;
#[doc(hidden)]
pub type CreateStorageLocationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateStorageLocationInput {
    /// Consumes the builder and constructs an Operation<[`CreateStorageLocation`](crate::operation::CreateStorageLocation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStorageLocation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStorageLocationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStorageLocationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_storage_location(
                &self,
            )?,
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStorageLocation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStorageLocation",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStorageLocationInput`](crate::input::CreateStorageLocationInput)
    pub fn builder() -> crate::input::create_storage_location_input::Builder {
        crate::input::create_storage_location_input::Builder::default()
    }
}

/// See [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
pub mod delete_application_input {
    /// A builder for [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) terminate_env_by_force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the application to delete.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application to delete.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>When set to true, running environments will be terminated before deleting the application.</p>
        pub fn terminate_env_by_force(mut self, input: bool) -> Self {
            self.terminate_env_by_force = Some(input);
            self
        }
        /// <p>When set to true, running environments will be terminated before deleting the application.</p>
        pub fn set_terminate_env_by_force(mut self, input: std::option::Option<bool>) -> Self {
            self.terminate_env_by_force = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApplicationInput {
                application_name: self.application_name,
                terminate_env_by_force: self.terminate_env_by_force,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApplicationInputOperationOutputAlias = crate::operation::DeleteApplication;
#[doc(hidden)]
pub type DeleteApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApplication`](crate::operation::DeleteApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_application(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApplication",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    pub fn builder() -> crate::input::delete_application_input::Builder {
        crate::input::delete_application_input::Builder::default()
    }
}

/// See [`DeleteApplicationVersionInput`](crate::input::DeleteApplicationVersionInput)
pub mod delete_application_version_input {
    /// A builder for [`DeleteApplicationVersionInput`](crate::input::DeleteApplicationVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) delete_source_bundle: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the application to which the version belongs.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application to which the version belongs.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The label of the version to delete.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>The label of the version to delete.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// <p>Set to <code>true</code> to delete the source bundle from your storage bucket. Otherwise, the application version is deleted only from Elastic Beanstalk and the source bundle remains in Amazon S3.</p>
        pub fn delete_source_bundle(mut self, input: bool) -> Self {
            self.delete_source_bundle = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to delete the source bundle from your storage bucket. Otherwise, the application version is deleted only from Elastic Beanstalk and the source bundle remains in Amazon S3.</p>
        pub fn set_delete_source_bundle(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_source_bundle = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationVersionInput`](crate::input::DeleteApplicationVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApplicationVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApplicationVersionInput {
                application_name: self.application_name,
                version_label: self.version_label,
                delete_source_bundle: self.delete_source_bundle,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApplicationVersionInputOperationOutputAlias =
    crate::operation::DeleteApplicationVersion;
#[doc(hidden)]
pub type DeleteApplicationVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApplicationVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApplicationVersion`](crate::operation::DeleteApplicationVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApplicationVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteApplicationVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteApplicationVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_application_version(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApplicationVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApplicationVersion",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteApplicationVersionInput`](crate::input::DeleteApplicationVersionInput)
    pub fn builder() -> crate::input::delete_application_version_input::Builder {
        crate::input::delete_application_version_input::Builder::default()
    }
}

/// See [`DeleteConfigurationTemplateInput`](crate::input::DeleteConfigurationTemplateInput)
pub mod delete_configuration_template_input {
    /// A builder for [`DeleteConfigurationTemplateInput`](crate::input::DeleteConfigurationTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the application to delete the configuration template from.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application to delete the configuration template from.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of the configuration template to delete.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration template to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigurationTemplateInput`](crate::input::DeleteConfigurationTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigurationTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigurationTemplateInput {
                application_name: self.application_name,
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigurationTemplateInputOperationOutputAlias =
    crate::operation::DeleteConfigurationTemplate;
#[doc(hidden)]
pub type DeleteConfigurationTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteConfigurationTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfigurationTemplate`](crate::operation::DeleteConfigurationTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfigurationTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteConfigurationTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteConfigurationTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_configuration_template(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfigurationTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfigurationTemplate",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationTemplateInput`](crate::input::DeleteConfigurationTemplateInput)
    pub fn builder() -> crate::input::delete_configuration_template_input::Builder {
        crate::input::delete_configuration_template_input::Builder::default()
    }
}

/// See [`DeleteEnvironmentConfigurationInput`](crate::input::DeleteEnvironmentConfigurationInput)
pub mod delete_environment_configuration_input {
    /// A builder for [`DeleteEnvironmentConfigurationInput`](crate::input::DeleteEnvironmentConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the application the environment is associated with.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application the environment is associated with.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of the environment to delete the draft configuration from.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment to delete the draft configuration from.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEnvironmentConfigurationInput`](crate::input::DeleteEnvironmentConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEnvironmentConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEnvironmentConfigurationInput {
                application_name: self.application_name,
                environment_name: self.environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEnvironmentConfigurationInputOperationOutputAlias =
    crate::operation::DeleteEnvironmentConfiguration;
#[doc(hidden)]
pub type DeleteEnvironmentConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEnvironmentConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEnvironmentConfiguration`](crate::operation::DeleteEnvironmentConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEnvironmentConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEnvironmentConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEnvironmentConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_environment_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEnvironmentConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEnvironmentConfiguration",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentConfigurationInput`](crate::input::DeleteEnvironmentConfigurationInput)
    pub fn builder() -> crate::input::delete_environment_configuration_input::Builder {
        crate::input::delete_environment_configuration_input::Builder::default()
    }
}

/// See [`DeletePlatformVersionInput`](crate::input::DeletePlatformVersionInput)
pub mod delete_platform_version_input {
    /// A builder for [`DeletePlatformVersionInput`](crate::input::DeletePlatformVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the version of the custom platform.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the version of the custom platform.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePlatformVersionInput`](crate::input::DeletePlatformVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePlatformVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePlatformVersionInput {
                platform_arn: self.platform_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePlatformVersionInputOperationOutputAlias = crate::operation::DeletePlatformVersion;
#[doc(hidden)]
pub type DeletePlatformVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePlatformVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeletePlatformVersion`](crate::operation::DeletePlatformVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePlatformVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePlatformVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePlatformVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_platform_version(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePlatformVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePlatformVersion",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePlatformVersionInput`](crate::input::DeletePlatformVersionInput)
    pub fn builder() -> crate::input::delete_platform_version_input::Builder {
        crate::input::delete_platform_version_input::Builder::default()
    }
}

/// See [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
pub mod describe_account_attributes_input {
    /// A builder for [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountAttributesInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountAttributesInputOperationOutputAlias =
    crate::operation::DescribeAccountAttributes;
#[doc(hidden)]
pub type DescribeAccountAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAccountAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountAttributes`](crate::operation::DescribeAccountAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAccountAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAccountAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_account_attributes(
                &self,
            )?,
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountAttributes",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    pub fn builder() -> crate::input::describe_account_attributes_input::Builder {
        crate::input::describe_account_attributes_input::Builder::default()
    }
}

/// See [`DescribeApplicationsInput`](crate::input::DescribeApplicationsInput)
pub mod describe_applications_input {
    /// A builder for [`DescribeApplicationsInput`](crate::input::DescribeApplicationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `application_names`.
        ///
        /// To override the contents of this collection use [`set_application_names`](Self::set_application_names).
        ///
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include those with the specified names.</p>
        pub fn application_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.application_names.unwrap_or_default();
            v.push(input.into());
            self.application_names = Some(v);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include those with the specified names.</p>
        pub fn set_application_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.application_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationsInput`](crate::input::DescribeApplicationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeApplicationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeApplicationsInput {
                application_names: self.application_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeApplicationsInputOperationOutputAlias = crate::operation::DescribeApplications;
#[doc(hidden)]
pub type DescribeApplicationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeApplicationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApplications`](crate::operation::DescribeApplications)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApplications,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeApplicationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeApplicationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_applications(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApplications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApplications",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeApplicationsInput`](crate::input::DescribeApplicationsInput)
    pub fn builder() -> crate::input::describe_applications_input::Builder {
        crate::input::describe_applications_input::Builder::default()
    }
}

/// See [`DescribeApplicationVersionsInput`](crate::input::DescribeApplicationVersionsInput)
pub mod describe_application_versions_input {
    /// A builder for [`DescribeApplicationVersionsInput`](crate::input::DescribeApplicationVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) version_labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specify an application name to show only application versions for that application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Specify an application name to show only application versions for that application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// Appends an item to `version_labels`.
        ///
        /// To override the contents of this collection use [`set_version_labels`](Self::set_version_labels).
        ///
        /// <p>Specify a version label to show a specific application version.</p>
        pub fn version_labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.version_labels.unwrap_or_default();
            v.push(input.into());
            self.version_labels = Some(v);
            self
        }
        /// <p>Specify a version label to show a specific application version.</p>
        pub fn set_version_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.version_labels = input;
            self
        }
        /// <p>For a paginated request. Specify a maximum number of application versions to include in each response.</p>
        /// <p>If no <code>MaxRecords</code> is specified, all available application versions are retrieved in a single response.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>For a paginated request. Specify a maximum number of application versions to include in each response.</p>
        /// <p>If no <code>MaxRecords</code> is specified, all available application versions are retrieved in a single response.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationVersionsInput`](crate::input::DescribeApplicationVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeApplicationVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeApplicationVersionsInput {
                application_name: self.application_name,
                version_labels: self.version_labels,
                max_records: self.max_records,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeApplicationVersionsInputOperationOutputAlias =
    crate::operation::DescribeApplicationVersions;
#[doc(hidden)]
pub type DescribeApplicationVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeApplicationVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApplicationVersions`](crate::operation::DescribeApplicationVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApplicationVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeApplicationVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeApplicationVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_application_versions(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApplicationVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApplicationVersions",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeApplicationVersionsInput`](crate::input::DescribeApplicationVersionsInput)
    pub fn builder() -> crate::input::describe_application_versions_input::Builder {
        crate::input::describe_application_versions_input::Builder::default()
    }
}

/// See [`DescribeConfigurationOptionsInput`](crate::input::DescribeConfigurationOptionsInput)
pub mod describe_configuration_options_input {
    /// A builder for [`DescribeConfigurationOptionsInput`](crate::input::DescribeConfigurationOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) options: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
    }
    impl Builder {
        /// <p>The name of the application associated with the configuration template or environment. Only needed if you want to describe the configuration options associated with either the configuration template or environment.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application associated with the configuration template or environment. Only needed if you want to describe the configuration options associated with either the configuration template or environment.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of the configuration template whose configuration options you want to describe.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration template whose configuration options you want to describe.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The name of the environment whose configuration options you want to describe.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment whose configuration options you want to describe.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The name of the solution stack whose configuration options you want to describe.</p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p>The name of the solution stack whose configuration options you want to describe.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// <p>The ARN of the custom platform.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the custom platform.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// Appends an item to `options`.
        ///
        /// To override the contents of this collection use [`set_options`](Self::set_options).
        ///
        /// <p>If specified, restricts the descriptions to only the specified options.</p>
        pub fn options(mut self, input: crate::model::OptionSpecification) -> Self {
            let mut v = self.options.unwrap_or_default();
            v.push(input);
            self.options = Some(v);
            self
        }
        /// <p>If specified, restricts the descriptions to only the specified options.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
        ) -> Self {
            self.options = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationOptionsInput`](crate::input::DescribeConfigurationOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConfigurationOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConfigurationOptionsInput {
                application_name: self.application_name,
                template_name: self.template_name,
                environment_name: self.environment_name,
                solution_stack_name: self.solution_stack_name,
                platform_arn: self.platform_arn,
                options: self.options,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConfigurationOptionsInputOperationOutputAlias =
    crate::operation::DescribeConfigurationOptions;
#[doc(hidden)]
pub type DescribeConfigurationOptionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConfigurationOptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConfigurationOptions`](crate::operation::DescribeConfigurationOptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConfigurationOptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeConfigurationOptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeConfigurationOptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_configuration_options(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConfigurationOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConfigurationOptions",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationOptionsInput`](crate::input::DescribeConfigurationOptionsInput)
    pub fn builder() -> crate::input::describe_configuration_options_input::Builder {
        crate::input::describe_configuration_options_input::Builder::default()
    }
}

/// See [`DescribeConfigurationSettingsInput`](crate::input::DescribeConfigurationSettingsInput)
pub mod describe_configuration_settings_input {
    /// A builder for [`DescribeConfigurationSettingsInput`](crate::input::DescribeConfigurationSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application for the environment or configuration template.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The application for the environment or configuration template.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of the configuration template to describe.</p>
        /// <p> Conditional: You must specify either this parameter or an EnvironmentName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns a <code>MissingRequiredParameter</code> error. </p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration template to describe.</p>
        /// <p> Conditional: You must specify either this parameter or an EnvironmentName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns a <code>MissingRequiredParameter</code> error. </p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The name of the environment to describe.</p>
        /// <p> Condition: You must specify either this or a TemplateName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment to describe.</p>
        /// <p> Condition: You must specify either this or a TemplateName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationSettingsInput`](crate::input::DescribeConfigurationSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConfigurationSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConfigurationSettingsInput {
                application_name: self.application_name,
                template_name: self.template_name,
                environment_name: self.environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConfigurationSettingsInputOperationOutputAlias =
    crate::operation::DescribeConfigurationSettings;
#[doc(hidden)]
pub type DescribeConfigurationSettingsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConfigurationSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConfigurationSettings`](crate::operation::DescribeConfigurationSettings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConfigurationSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeConfigurationSettingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeConfigurationSettingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_configuration_settings(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConfigurationSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConfigurationSettings",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationSettingsInput`](crate::input::DescribeConfigurationSettingsInput)
    pub fn builder() -> crate::input::describe_configuration_settings_input::Builder {
        crate::input::describe_configuration_settings_input::Builder::default()
    }
}

/// See [`DescribeEnvironmentHealthInput`](crate::input::DescribeEnvironmentHealthInput)
pub mod describe_environment_health_input {
    /// A builder for [`DescribeEnvironmentHealthInput`](crate::input::DescribeEnvironmentHealthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) attribute_names:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentHealthAttribute>>,
    }
    impl Builder {
        /// <p>Specify the environment by name.</p>
        /// <p>You must specify either this or an EnvironmentName, or both.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>Specify the environment by name.</p>
        /// <p>You must specify either this or an EnvironmentName, or both.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>Specify the environment by ID.</p>
        /// <p>You must specify either this or an EnvironmentName, or both.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>Specify the environment by ID.</p>
        /// <p>You must specify either this or an EnvironmentName, or both.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// Appends an item to `attribute_names`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns the name of the environment.</p>
        pub fn attribute_names(mut self, input: crate::model::EnvironmentHealthAttribute) -> Self {
            let mut v = self.attribute_names.unwrap_or_default();
            v.push(input);
            self.attribute_names = Some(v);
            self
        }
        /// <p>Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns the name of the environment.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentHealthAttribute>>,
        ) -> Self {
            self.attribute_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEnvironmentHealthInput`](crate::input::DescribeEnvironmentHealthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEnvironmentHealthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEnvironmentHealthInput {
                environment_name: self.environment_name,
                environment_id: self.environment_id,
                attribute_names: self.attribute_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEnvironmentHealthInputOperationOutputAlias =
    crate::operation::DescribeEnvironmentHealth;
#[doc(hidden)]
pub type DescribeEnvironmentHealthInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEnvironmentHealthInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEnvironmentHealth`](crate::operation::DescribeEnvironmentHealth)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEnvironmentHealth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEnvironmentHealthInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEnvironmentHealthInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_environment_health(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEnvironmentHealth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEnvironmentHealth",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentHealthInput`](crate::input::DescribeEnvironmentHealthInput)
    pub fn builder() -> crate::input::describe_environment_health_input::Builder {
        crate::input::describe_environment_health_input::Builder::default()
    }
}

/// See [`DescribeEnvironmentManagedActionHistoryInput`](crate::input::DescribeEnvironmentManagedActionHistoryInput)
pub mod describe_environment_managed_action_history_input {
    /// A builder for [`DescribeEnvironmentManagedActionHistoryInput`](crate::input::DescribeEnvironmentManagedActionHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The environment ID of the target environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The name of the target environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the target environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The pagination token returned by a previous request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token returned by a previous request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return for a single request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of items to return for a single request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEnvironmentManagedActionHistoryInput`](crate::input::DescribeEnvironmentManagedActionHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEnvironmentManagedActionHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEnvironmentManagedActionHistoryInput {
                environment_id: self.environment_id,
                environment_name: self.environment_name,
                next_token: self.next_token,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEnvironmentManagedActionHistoryInputOperationOutputAlias =
    crate::operation::DescribeEnvironmentManagedActionHistory;
#[doc(hidden)]
pub type DescribeEnvironmentManagedActionHistoryInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEnvironmentManagedActionHistoryInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEnvironmentManagedActionHistory`](crate::operation::DescribeEnvironmentManagedActionHistory)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEnvironmentManagedActionHistory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEnvironmentManagedActionHistoryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEnvironmentManagedActionHistoryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_environment_managed_action_history(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEnvironmentManagedActionHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEnvironmentManagedActionHistory",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentManagedActionHistoryInput`](crate::input::DescribeEnvironmentManagedActionHistoryInput)
    pub fn builder() -> crate::input::describe_environment_managed_action_history_input::Builder {
        crate::input::describe_environment_managed_action_history_input::Builder::default()
    }
}

/// See [`DescribeEnvironmentManagedActionsInput`](crate::input::DescribeEnvironmentManagedActionsInput)
pub mod describe_environment_managed_actions_input {
    /// A builder for [`DescribeEnvironmentManagedActionsInput`](crate::input::DescribeEnvironmentManagedActionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ActionStatus>,
    }
    impl Builder {
        /// <p>The name of the target environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the target environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The environment ID of the target environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>To show only actions with a particular status, specify a status.</p>
        pub fn status(mut self, input: crate::model::ActionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>To show only actions with a particular status, specify a status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ActionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEnvironmentManagedActionsInput`](crate::input::DescribeEnvironmentManagedActionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEnvironmentManagedActionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEnvironmentManagedActionsInput {
                environment_name: self.environment_name,
                environment_id: self.environment_id,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEnvironmentManagedActionsInputOperationOutputAlias =
    crate::operation::DescribeEnvironmentManagedActions;
#[doc(hidden)]
pub type DescribeEnvironmentManagedActionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEnvironmentManagedActionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEnvironmentManagedActions`](crate::operation::DescribeEnvironmentManagedActions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEnvironmentManagedActions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEnvironmentManagedActionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEnvironmentManagedActionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_environment_managed_actions(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEnvironmentManagedActions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEnvironmentManagedActions",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentManagedActionsInput`](crate::input::DescribeEnvironmentManagedActionsInput)
    pub fn builder() -> crate::input::describe_environment_managed_actions_input::Builder {
        crate::input::describe_environment_managed_actions_input::Builder::default()
    }
}

/// See [`DescribeEnvironmentResourcesInput`](crate::input::DescribeEnvironmentResourcesInput)
pub mod describe_environment_resources_input {
    /// A builder for [`DescribeEnvironmentResourcesInput`](crate::input::DescribeEnvironmentResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment to retrieve AWS resource usage data.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment to retrieve AWS resource usage data.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The name of the environment to retrieve AWS resource usage data.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment to retrieve AWS resource usage data.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEnvironmentResourcesInput`](crate::input::DescribeEnvironmentResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEnvironmentResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEnvironmentResourcesInput {
                environment_id: self.environment_id,
                environment_name: self.environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEnvironmentResourcesInputOperationOutputAlias =
    crate::operation::DescribeEnvironmentResources;
#[doc(hidden)]
pub type DescribeEnvironmentResourcesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEnvironmentResourcesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEnvironmentResources`](crate::operation::DescribeEnvironmentResources)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEnvironmentResources,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEnvironmentResourcesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEnvironmentResourcesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_environment_resources(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEnvironmentResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEnvironmentResources",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentResourcesInput`](crate::input::DescribeEnvironmentResourcesInput)
    pub fn builder() -> crate::input::describe_environment_resources_input::Builder {
        crate::input::describe_environment_resources_input::Builder::default()
    }
}

/// See [`DescribeEnvironmentsInput`](crate::input::DescribeEnvironmentsInput)
pub mod describe_environments_input {
    /// A builder for [`DescribeEnvironmentsInput`](crate::input::DescribeEnvironmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) environment_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) environment_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) include_deleted: std::option::Option<bool>,
        pub(crate) included_deleted_back_to: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application version.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application version.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// Appends an item to `environment_ids`.
        ///
        /// To override the contents of this collection use [`set_environment_ids`](Self::set_environment_ids).
        ///
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified IDs.</p>
        pub fn environment_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.environment_ids.unwrap_or_default();
            v.push(input.into());
            self.environment_ids = Some(v);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified IDs.</p>
        pub fn set_environment_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.environment_ids = input;
            self
        }
        /// Appends an item to `environment_names`.
        ///
        /// To override the contents of this collection use [`set_environment_names`](Self::set_environment_names).
        ///
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified names.</p>
        pub fn environment_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.environment_names.unwrap_or_default();
            v.push(input.into());
            self.environment_names = Some(v);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified names.</p>
        pub fn set_environment_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.environment_names = input;
            self
        }
        /// <p>Indicates whether to include deleted environments:</p>
        /// <p> <code>true</code>: Environments that have been deleted after <code>IncludedDeletedBackTo</code> are displayed.</p>
        /// <p> <code>false</code>: Do not include deleted environments.</p>
        pub fn include_deleted(mut self, input: bool) -> Self {
            self.include_deleted = Some(input);
            self
        }
        /// <p>Indicates whether to include deleted environments:</p>
        /// <p> <code>true</code>: Environments that have been deleted after <code>IncludedDeletedBackTo</code> are displayed.</p>
        /// <p> <code>false</code>: Do not include deleted environments.</p>
        pub fn set_include_deleted(mut self, input: std::option::Option<bool>) -> Self {
            self.include_deleted = input;
            self
        }
        /// <p> If specified when <code>IncludeDeleted</code> is set to <code>true</code>, then environments deleted after this date are displayed. </p>
        pub fn included_deleted_back_to(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.included_deleted_back_to = Some(input);
            self
        }
        /// <p> If specified when <code>IncludeDeleted</code> is set to <code>true</code>, then environments deleted after this date are displayed. </p>
        pub fn set_included_deleted_back_to(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.included_deleted_back_to = input;
            self
        }
        /// <p>For a paginated request. Specify a maximum number of environments to include in each response.</p>
        /// <p>If no <code>MaxRecords</code> is specified, all available environments are retrieved in a single response.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>For a paginated request. Specify a maximum number of environments to include in each response.</p>
        /// <p>If no <code>MaxRecords</code> is specified, all available environments are retrieved in a single response.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEnvironmentsInput`](crate::input::DescribeEnvironmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEnvironmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEnvironmentsInput {
                application_name: self.application_name,
                version_label: self.version_label,
                environment_ids: self.environment_ids,
                environment_names: self.environment_names,
                include_deleted: self.include_deleted,
                included_deleted_back_to: self.included_deleted_back_to,
                max_records: self.max_records,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEnvironmentsInputOperationOutputAlias = crate::operation::DescribeEnvironments;
#[doc(hidden)]
pub type DescribeEnvironmentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEnvironmentsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEnvironments`](crate::operation::DescribeEnvironments)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEnvironments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEnvironmentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEnvironmentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_environments(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEnvironments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEnvironments",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentsInput`](crate::input::DescribeEnvironmentsInput)
    pub fn builder() -> crate::input::describe_environments_input::Builder {
        crate::input::describe_environments_input::Builder::default()
    }
}

/// See [`DescribeEventsInput`](crate::input::DescribeEventsInput)
pub mod describe_events_input {
    /// A builder for [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::EventSeverity>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those associated with this application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those associated with this application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this application version.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this application version.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that are associated with this environment configuration.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that are associated with this environment configuration.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this custom platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this custom platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the described events to include only those associated with this request ID.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the described events to include only those associated with this request ID.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>If specified, limits the events returned from this call to include only those with the specified severity or higher.</p>
        pub fn severity(mut self, input: crate::model::EventSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>If specified, limits the events returned from this call to include only those with the specified severity or higher.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::EventSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur on or after this time.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur on or after this time.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p> If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur up to, but not including, the <code>EndTime</code>. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p> If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur up to, but not including, the <code>EndTime</code>. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Specifies the maximum number of events that can be returned, beginning with the most recent event.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>Specifies the maximum number of events that can be returned, beginning with the most recent event.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>Pagination token. If specified, the events return the next batch of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token. If specified, the events return the next batch of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsInput`](crate::input::DescribeEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventsInput {
                application_name: self.application_name,
                version_label: self.version_label,
                template_name: self.template_name,
                environment_id: self.environment_id,
                environment_name: self.environment_name,
                platform_arn: self.platform_arn,
                request_id: self.request_id,
                severity: self.severity,
                start_time: self.start_time,
                end_time: self.end_time,
                max_records: self.max_records,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventsInputOperationOutputAlias = crate::operation::DescribeEvents;
#[doc(hidden)]
pub type DescribeEventsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEventsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEvents`](crate::operation::DescribeEvents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEvents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEventsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEventsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_events(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEvents",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
}

/// See [`DescribeInstancesHealthInput`](crate::input::DescribeInstancesHealthInput)
pub mod describe_instances_health_input {
    /// A builder for [`DescribeInstancesHealthInput`](crate::input::DescribeInstancesHealthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) attribute_names:
            std::option::Option<std::vec::Vec<crate::model::InstancesHealthAttribute>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specify the AWS Elastic Beanstalk environment by name.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>Specify the AWS Elastic Beanstalk environment by name.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>Specify the AWS Elastic Beanstalk environment by ID.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>Specify the AWS Elastic Beanstalk environment by ID.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// Appends an item to `attribute_names`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns a list of instances.</p>
        pub fn attribute_names(mut self, input: crate::model::InstancesHealthAttribute) -> Self {
            let mut v = self.attribute_names.unwrap_or_default();
            v.push(input);
            self.attribute_names = Some(v);
            self
        }
        /// <p>Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns a list of instances.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstancesHealthAttribute>>,
        ) -> Self {
            self.attribute_names = input;
            self
        }
        /// <p>Specify the pagination token returned by a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token returned by a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstancesHealthInput`](crate::input::DescribeInstancesHealthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstancesHealthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInstancesHealthInput {
                environment_name: self.environment_name,
                environment_id: self.environment_id,
                attribute_names: self.attribute_names,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInstancesHealthInputOperationOutputAlias =
    crate::operation::DescribeInstancesHealth;
#[doc(hidden)]
pub type DescribeInstancesHealthInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInstancesHealthInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstancesHealth`](crate::operation::DescribeInstancesHealth)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstancesHealth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeInstancesHealthInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeInstancesHealthInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_instances_health(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstancesHealth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstancesHealth",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstancesHealthInput`](crate::input::DescribeInstancesHealthInput)
    pub fn builder() -> crate::input::describe_instances_health_input::Builder {
        crate::input::describe_instances_health_input::Builder::default()
    }
}

/// See [`DescribePlatformVersionInput`](crate::input::DescribePlatformVersionInput)
pub mod describe_platform_version_input {
    /// A builder for [`DescribePlatformVersionInput`](crate::input::DescribePlatformVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePlatformVersionInput`](crate::input::DescribePlatformVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePlatformVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePlatformVersionInput {
                platform_arn: self.platform_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePlatformVersionInputOperationOutputAlias =
    crate::operation::DescribePlatformVersion;
#[doc(hidden)]
pub type DescribePlatformVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePlatformVersionInput {
    /// Consumes the builder and constructs an Operation<[`DescribePlatformVersion`](crate::operation::DescribePlatformVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePlatformVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribePlatformVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribePlatformVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_platform_version(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePlatformVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePlatformVersion",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribePlatformVersionInput`](crate::input::DescribePlatformVersionInput)
    pub fn builder() -> crate::input::describe_platform_version_input::Builder {
        crate::input::describe_platform_version_input::Builder::default()
    }
}

/// See [`DisassociateEnvironmentOperationsRoleInput`](crate::input::DisassociateEnvironmentOperationsRoleInput)
pub mod disassociate_environment_operations_role_input {
    /// A builder for [`DisassociateEnvironmentOperationsRoleInput`](crate::input::DisassociateEnvironmentOperationsRoleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the environment from which to disassociate the operations role.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment from which to disassociate the operations role.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateEnvironmentOperationsRoleInput`](crate::input::DisassociateEnvironmentOperationsRoleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateEnvironmentOperationsRoleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateEnvironmentOperationsRoleInput {
                environment_name: self.environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateEnvironmentOperationsRoleInputOperationOutputAlias =
    crate::operation::DisassociateEnvironmentOperationsRole;
#[doc(hidden)]
pub type DisassociateEnvironmentOperationsRoleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateEnvironmentOperationsRoleInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateEnvironmentOperationsRole`](crate::operation::DisassociateEnvironmentOperationsRole)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateEnvironmentOperationsRole,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisassociateEnvironmentOperationsRoleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisassociateEnvironmentOperationsRoleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disassociate_environment_operations_role(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateEnvironmentOperationsRole::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateEnvironmentOperationsRole",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisassociateEnvironmentOperationsRoleInput`](crate::input::DisassociateEnvironmentOperationsRoleInput)
    pub fn builder() -> crate::input::disassociate_environment_operations_role_input::Builder {
        crate::input::disassociate_environment_operations_role_input::Builder::default()
    }
}

/// See [`ListAvailableSolutionStacksInput`](crate::input::ListAvailableSolutionStacksInput)
pub mod list_available_solution_stacks_input {
    /// A builder for [`ListAvailableSolutionStacksInput`](crate::input::ListAvailableSolutionStacksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ListAvailableSolutionStacksInput`](crate::input::ListAvailableSolutionStacksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAvailableSolutionStacksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAvailableSolutionStacksInput {})
        }
    }
}
#[doc(hidden)]
pub type ListAvailableSolutionStacksInputOperationOutputAlias =
    crate::operation::ListAvailableSolutionStacks;
#[doc(hidden)]
pub type ListAvailableSolutionStacksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAvailableSolutionStacksInput {
    /// Consumes the builder and constructs an Operation<[`ListAvailableSolutionStacks`](crate::operation::ListAvailableSolutionStacks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAvailableSolutionStacks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAvailableSolutionStacksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAvailableSolutionStacksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_available_solution_stacks(&self)?
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAvailableSolutionStacks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAvailableSolutionStacks",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAvailableSolutionStacksInput`](crate::input::ListAvailableSolutionStacksInput)
    pub fn builder() -> crate::input::list_available_solution_stacks_input::Builder {
        crate::input::list_available_solution_stacks_input::Builder::default()
    }
}

/// See [`ListPlatformBranchesInput`](crate::input::ListPlatformBranchesInput)
pub mod list_platform_branches_input {
    /// A builder for [`ListPlatformBranchesInput`](crate::input::ListPlatformBranchesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::SearchFilter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical conjunction (AND) of the separate <code>SearchFilter</code> terms.</p>
        /// <p>The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most operators take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple values.</p>
        /// <ul>
        /// <li> <p> <code>Attribute = BranchName</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Attribute = LifecycleState</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code> </p> </li>
        /// <li> <p> <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> | <code>retired</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Attribute = PlatformName</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Attribute = TierType</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> </p> </li>
        /// <li> <p> <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p>Array size: limited to 10 <code>SearchFilter</code> objects.</p>
        /// <p>Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.</p>
        pub fn filters(mut self, input: crate::model::SearchFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical conjunction (AND) of the separate <code>SearchFilter</code> terms.</p>
        /// <p>The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most operators take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple values.</p>
        /// <ul>
        /// <li> <p> <code>Attribute = BranchName</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Attribute = LifecycleState</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code> </p> </li>
        /// <li> <p> <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> | <code>retired</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Attribute = PlatformName</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>Attribute = TierType</code>:</p>
        /// <ul>
        /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> </p> </li>
        /// <li> <p> <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p>Array size: limited to 10 <code>SearchFilter</code> objects.</p>
        /// <p>Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SearchFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of platform branch values returned in one call.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of platform branch values returned in one call.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPlatformBranchesInput`](crate::input::ListPlatformBranchesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPlatformBranchesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPlatformBranchesInput {
                filters: self.filters,
                max_records: self.max_records,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPlatformBranchesInputOperationOutputAlias = crate::operation::ListPlatformBranches;
#[doc(hidden)]
pub type ListPlatformBranchesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPlatformBranchesInput {
    /// Consumes the builder and constructs an Operation<[`ListPlatformBranches`](crate::operation::ListPlatformBranches)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPlatformBranches,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPlatformBranchesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPlatformBranchesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_platform_branches(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPlatformBranches::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPlatformBranches",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPlatformBranchesInput`](crate::input::ListPlatformBranchesInput)
    pub fn builder() -> crate::input::list_platform_branches_input::Builder {
        crate::input::list_platform_branches_input::Builder::default()
    }
}

/// See [`ListPlatformVersionsInput`](crate::input::ListPlatformVersionsInput)
pub mod list_platform_versions_input {
    /// A builder for [`ListPlatformVersionsInput`](crate::input::ListPlatformVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::PlatformFilter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Criteria for restricting the resulting list of platform versions. The filter is interpreted as a logical conjunction (AND) of the separate <code>PlatformFilter</code> terms.</p>
        pub fn filters(mut self, input: crate::model::PlatformFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Criteria for restricting the resulting list of platform versions. The filter is interpreted as a logical conjunction (AND) of the separate <code>PlatformFilter</code> terms.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of platform version values returned in one call.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of platform version values returned in one call.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
        /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPlatformVersionsInput`](crate::input::ListPlatformVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPlatformVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPlatformVersionsInput {
                filters: self.filters,
                max_records: self.max_records,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPlatformVersionsInputOperationOutputAlias = crate::operation::ListPlatformVersions;
#[doc(hidden)]
pub type ListPlatformVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPlatformVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListPlatformVersions`](crate::operation::ListPlatformVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPlatformVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPlatformVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPlatformVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_platform_versions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPlatformVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPlatformVersions",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPlatformVersionsInput`](crate::input::ListPlatformVersionsInput)
    pub fn builder() -> crate::input::list_platform_versions_input::Builder {
        crate::input::list_platform_versions_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resouce for which a tag list is requested.</p>
        /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resouce for which a tag list is requested.</p>
        /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`RebuildEnvironmentInput`](crate::input::RebuildEnvironmentInput)
pub mod rebuild_environment_input {
    /// A builder for [`RebuildEnvironmentInput`](crate::input::RebuildEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment to rebuild.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment to rebuild.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The name of the environment to rebuild.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment to rebuild.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RebuildEnvironmentInput`](crate::input::RebuildEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RebuildEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RebuildEnvironmentInput {
                environment_id: self.environment_id,
                environment_name: self.environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type RebuildEnvironmentInputOperationOutputAlias = crate::operation::RebuildEnvironment;
#[doc(hidden)]
pub type RebuildEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RebuildEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`RebuildEnvironment`](crate::operation::RebuildEnvironment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RebuildEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RebuildEnvironmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RebuildEnvironmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_rebuild_environment(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RebuildEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RebuildEnvironment",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RebuildEnvironmentInput`](crate::input::RebuildEnvironmentInput)
    pub fn builder() -> crate::input::rebuild_environment_input::Builder {
        crate::input::rebuild_environment_input::Builder::default()
    }
}

/// See [`RequestEnvironmentInfoInput`](crate::input::RequestEnvironmentInfoInput)
pub mod request_environment_info_input {
    /// A builder for [`RequestEnvironmentInfoInput`](crate::input::RequestEnvironmentInfoInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) info_type: std::option::Option<crate::model::EnvironmentInfoType>,
    }
    impl Builder {
        /// <p>The ID of the environment of the requested data.</p>
        /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment of the requested data.</p>
        /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The name of the environment of the requested data.</p>
        /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment of the requested data.</p>
        /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The type of information to request.</p>
        pub fn info_type(mut self, input: crate::model::EnvironmentInfoType) -> Self {
            self.info_type = Some(input);
            self
        }
        /// <p>The type of information to request.</p>
        pub fn set_info_type(
            mut self,
            input: std::option::Option<crate::model::EnvironmentInfoType>,
        ) -> Self {
            self.info_type = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestEnvironmentInfoInput`](crate::input::RequestEnvironmentInfoInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RequestEnvironmentInfoInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RequestEnvironmentInfoInput {
                environment_id: self.environment_id,
                environment_name: self.environment_name,
                info_type: self.info_type,
            })
        }
    }
}
#[doc(hidden)]
pub type RequestEnvironmentInfoInputOperationOutputAlias = crate::operation::RequestEnvironmentInfo;
#[doc(hidden)]
pub type RequestEnvironmentInfoInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RequestEnvironmentInfoInput {
    /// Consumes the builder and constructs an Operation<[`RequestEnvironmentInfo`](crate::operation::RequestEnvironmentInfo)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RequestEnvironmentInfo,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RequestEnvironmentInfoInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RequestEnvironmentInfoInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_request_environment_info(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RequestEnvironmentInfo::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RequestEnvironmentInfo",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RequestEnvironmentInfoInput`](crate::input::RequestEnvironmentInfoInput)
    pub fn builder() -> crate::input::request_environment_info_input::Builder {
        crate::input::request_environment_info_input::Builder::default()
    }
}

/// See [`RestartAppServerInput`](crate::input::RestartAppServerInput)
pub mod restart_app_server_input {
    /// A builder for [`RestartAppServerInput`](crate::input::RestartAppServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment to restart the server for.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment to restart the server for.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The name of the environment to restart the server for.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment to restart the server for.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RestartAppServerInput`](crate::input::RestartAppServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestartAppServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestartAppServerInput {
                environment_id: self.environment_id,
                environment_name: self.environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type RestartAppServerInputOperationOutputAlias = crate::operation::RestartAppServer;
#[doc(hidden)]
pub type RestartAppServerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RestartAppServerInput {
    /// Consumes the builder and constructs an Operation<[`RestartAppServer`](crate::operation::RestartAppServer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestartAppServer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RestartAppServerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RestartAppServerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_restart_app_server(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestartAppServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestartAppServer",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RestartAppServerInput`](crate::input::RestartAppServerInput)
    pub fn builder() -> crate::input::restart_app_server_input::Builder {
        crate::input::restart_app_server_input::Builder::default()
    }
}

/// See [`RetrieveEnvironmentInfoInput`](crate::input::RetrieveEnvironmentInfoInput)
pub mod retrieve_environment_info_input {
    /// A builder for [`RetrieveEnvironmentInfoInput`](crate::input::RetrieveEnvironmentInfoInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) info_type: std::option::Option<crate::model::EnvironmentInfoType>,
    }
    impl Builder {
        /// <p>The ID of the data's environment.</p>
        /// <p>If no such environment is found, returns an <code>InvalidParameterValue</code> error.</p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the data's environment.</p>
        /// <p>If no such environment is found, returns an <code>InvalidParameterValue</code> error.</p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The name of the data's environment.</p>
        /// <p> If no such environment is found, returns an <code>InvalidParameterValue</code> error. </p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the data's environment.</p>
        /// <p> If no such environment is found, returns an <code>InvalidParameterValue</code> error. </p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The type of information to retrieve.</p>
        pub fn info_type(mut self, input: crate::model::EnvironmentInfoType) -> Self {
            self.info_type = Some(input);
            self
        }
        /// <p>The type of information to retrieve.</p>
        pub fn set_info_type(
            mut self,
            input: std::option::Option<crate::model::EnvironmentInfoType>,
        ) -> Self {
            self.info_type = input;
            self
        }
        /// Consumes the builder and constructs a [`RetrieveEnvironmentInfoInput`](crate::input::RetrieveEnvironmentInfoInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RetrieveEnvironmentInfoInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RetrieveEnvironmentInfoInput {
                environment_id: self.environment_id,
                environment_name: self.environment_name,
                info_type: self.info_type,
            })
        }
    }
}
#[doc(hidden)]
pub type RetrieveEnvironmentInfoInputOperationOutputAlias =
    crate::operation::RetrieveEnvironmentInfo;
#[doc(hidden)]
pub type RetrieveEnvironmentInfoInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RetrieveEnvironmentInfoInput {
    /// Consumes the builder and constructs an Operation<[`RetrieveEnvironmentInfo`](crate::operation::RetrieveEnvironmentInfo)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RetrieveEnvironmentInfo,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RetrieveEnvironmentInfoInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RetrieveEnvironmentInfoInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_retrieve_environment_info(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RetrieveEnvironmentInfo::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RetrieveEnvironmentInfo",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RetrieveEnvironmentInfoInput`](crate::input::RetrieveEnvironmentInfoInput)
    pub fn builder() -> crate::input::retrieve_environment_info_input::Builder {
        crate::input::retrieve_environment_info_input::Builder::default()
    }
}

/// See [`SwapEnvironmentCnamEsInput`](crate::input::SwapEnvironmentCnamEsInput)
pub mod swap_environment_cnam_es_input {
    /// A builder for [`SwapEnvironmentCnamEsInput`](crate::input::SwapEnvironmentCnamEsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_environment_id: std::option::Option<std::string::String>,
        pub(crate) source_environment_name: std::option::Option<std::string::String>,
        pub(crate) destination_environment_id: std::option::Option<std::string::String>,
        pub(crate) destination_environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the source environment.</p>
        /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentId</code>, you must specify the <code>DestinationEnvironmentId</code>. </p>
        pub fn source_environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the source environment.</p>
        /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentId</code>, you must specify the <code>DestinationEnvironmentId</code>. </p>
        pub fn set_source_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_environment_id = input;
            self
        }
        /// <p>The name of the source environment.</p>
        /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentName</code>, you must specify the <code>DestinationEnvironmentName</code>. </p>
        pub fn source_environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the source environment.</p>
        /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentName</code>, you must specify the <code>DestinationEnvironmentName</code>. </p>
        pub fn set_source_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_environment_name = input;
            self
        }
        /// <p>The ID of the destination environment.</p>
        /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentId</code> with the <code>DestinationEnvironmentId</code>. </p>
        pub fn destination_environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the destination environment.</p>
        /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentId</code> with the <code>DestinationEnvironmentId</code>. </p>
        pub fn set_destination_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_environment_id = input;
            self
        }
        /// <p>The name of the destination environment.</p>
        /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentName</code> with the <code>DestinationEnvironmentName</code>. </p>
        pub fn destination_environment_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_environment_name = Some(input.into());
            self
        }
        /// <p>The name of the destination environment.</p>
        /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentName</code> with the <code>DestinationEnvironmentName</code>. </p>
        pub fn set_destination_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SwapEnvironmentCnamEsInput`](crate::input::SwapEnvironmentCnamEsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SwapEnvironmentCnamEsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SwapEnvironmentCnamEsInput {
                source_environment_id: self.source_environment_id,
                source_environment_name: self.source_environment_name,
                destination_environment_id: self.destination_environment_id,
                destination_environment_name: self.destination_environment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type SwapEnvironmentCnamEsInputOperationOutputAlias = crate::operation::SwapEnvironmentCNAMEs;
#[doc(hidden)]
pub type SwapEnvironmentCnamEsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SwapEnvironmentCnamEsInput {
    /// Consumes the builder and constructs an Operation<[`SwapEnvironmentCNAMEs`](crate::operation::SwapEnvironmentCNAMEs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SwapEnvironmentCNAMEs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SwapEnvironmentCnamEsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SwapEnvironmentCnamEsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_swap_environment_cnam_es(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SwapEnvironmentCNAMEs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SwapEnvironmentCNAMEs",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SwapEnvironmentCnamEsInput`](crate::input::SwapEnvironmentCnamEsInput)
    pub fn builder() -> crate::input::swap_environment_cnam_es_input::Builder {
        crate::input::swap_environment_cnam_es_input::Builder::default()
    }
}

/// See [`TerminateEnvironmentInput`](crate::input::TerminateEnvironmentInput)
pub mod terminate_environment_input {
    /// A builder for [`TerminateEnvironmentInput`](crate::input::TerminateEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) terminate_resources: std::option::Option<bool>,
        pub(crate) force_terminate: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the environment to terminate.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment to terminate.</p>
        /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The name of the environment to terminate.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment to terminate.</p>
        /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>Indicates whether the associated AWS resources should shut down when the environment is terminated:</p>
        /// <ul>
        /// <li> <p> <code>true</code>: The specified environment as well as the associated AWS resources, such as Auto Scaling group and LoadBalancer, are terminated.</p> </li>
        /// <li> <p> <code>false</code>: AWS Elastic Beanstalk resource management is removed from the environment, but the AWS resources continue to operate.</p> </li>
        /// </ul>
        /// <p> For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS Elastic Beanstalk User Guide. </a> </p>
        /// <p> Default: <code>true</code> </p>
        /// <p> Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn terminate_resources(mut self, input: bool) -> Self {
            self.terminate_resources = Some(input);
            self
        }
        /// <p>Indicates whether the associated AWS resources should shut down when the environment is terminated:</p>
        /// <ul>
        /// <li> <p> <code>true</code>: The specified environment as well as the associated AWS resources, such as Auto Scaling group and LoadBalancer, are terminated.</p> </li>
        /// <li> <p> <code>false</code>: AWS Elastic Beanstalk resource management is removed from the environment, but the AWS resources continue to operate.</p> </li>
        /// </ul>
        /// <p> For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS Elastic Beanstalk User Guide. </a> </p>
        /// <p> Default: <code>true</code> </p>
        /// <p> Valid Values: <code>true</code> | <code>false</code> </p>
        pub fn set_terminate_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.terminate_resources = input;
            self
        }
        /// <p>Terminates the target environment even if another environment in the same group is dependent on it.</p>
        pub fn force_terminate(mut self, input: bool) -> Self {
            self.force_terminate = Some(input);
            self
        }
        /// <p>Terminates the target environment even if another environment in the same group is dependent on it.</p>
        pub fn set_force_terminate(mut self, input: std::option::Option<bool>) -> Self {
            self.force_terminate = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateEnvironmentInput`](crate::input::TerminateEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TerminateEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TerminateEnvironmentInput {
                environment_id: self.environment_id,
                environment_name: self.environment_name,
                terminate_resources: self.terminate_resources,
                force_terminate: self.force_terminate,
            })
        }
    }
}
#[doc(hidden)]
pub type TerminateEnvironmentInputOperationOutputAlias = crate::operation::TerminateEnvironment;
#[doc(hidden)]
pub type TerminateEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TerminateEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`TerminateEnvironment`](crate::operation::TerminateEnvironment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TerminateEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TerminateEnvironmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TerminateEnvironmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_terminate_environment(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TerminateEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TerminateEnvironment",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TerminateEnvironmentInput`](crate::input::TerminateEnvironmentInput)
    pub fn builder() -> crate::input::terminate_environment_input::Builder {
        crate::input::terminate_environment_input::Builder::default()
    }
}

/// See [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
pub mod update_application_input {
    /// A builder for [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the application to update. If no such application is found, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application to update. If no such application is found, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>A new description for the application.</p>
        /// <p>Default: If not specified, AWS Elastic Beanstalk does not update the description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A new description for the application.</p>
        /// <p>Default: If not specified, AWS Elastic Beanstalk does not update the description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApplicationInput {
                application_name: self.application_name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApplicationInputOperationOutputAlias = crate::operation::UpdateApplication;
#[doc(hidden)]
pub type UpdateApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApplicationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApplication`](crate::operation::UpdateApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_application(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApplication",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    pub fn builder() -> crate::input::update_application_input::Builder {
        crate::input::update_application_input::Builder::default()
    }
}

/// See [`UpdateApplicationResourceLifecycleInput`](crate::input::UpdateApplicationResourceLifecycleInput)
pub mod update_application_resource_lifecycle_input {
    /// A builder for [`UpdateApplicationResourceLifecycleInput`](crate::input::UpdateApplicationResourceLifecycleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) resource_lifecycle_config:
            std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
    }
    impl Builder {
        /// <p>The name of the application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The lifecycle configuration.</p>
        pub fn resource_lifecycle_config(
            mut self,
            input: crate::model::ApplicationResourceLifecycleConfig,
        ) -> Self {
            self.resource_lifecycle_config = Some(input);
            self
        }
        /// <p>The lifecycle configuration.</p>
        pub fn set_resource_lifecycle_config(
            mut self,
            input: std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
        ) -> Self {
            self.resource_lifecycle_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationResourceLifecycleInput`](crate::input::UpdateApplicationResourceLifecycleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApplicationResourceLifecycleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApplicationResourceLifecycleInput {
                application_name: self.application_name,
                resource_lifecycle_config: self.resource_lifecycle_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApplicationResourceLifecycleInputOperationOutputAlias =
    crate::operation::UpdateApplicationResourceLifecycle;
#[doc(hidden)]
pub type UpdateApplicationResourceLifecycleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApplicationResourceLifecycleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApplicationResourceLifecycle`](crate::operation::UpdateApplicationResourceLifecycle)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApplicationResourceLifecycle,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateApplicationResourceLifecycleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateApplicationResourceLifecycleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_application_resource_lifecycle(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApplicationResourceLifecycle::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApplicationResourceLifecycle",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateApplicationResourceLifecycleInput`](crate::input::UpdateApplicationResourceLifecycleInput)
    pub fn builder() -> crate::input::update_application_resource_lifecycle_input::Builder {
        crate::input::update_application_resource_lifecycle_input::Builder::default()
    }
}

/// See [`UpdateApplicationVersionInput`](crate::input::UpdateApplicationVersionInput)
pub mod update_application_version_input {
    /// A builder for [`UpdateApplicationVersionInput`](crate::input::UpdateApplicationVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the application associated with this version.</p>
        /// <p> If no application is found with this name, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application associated with this version.</p>
        /// <p> If no application is found with this name, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of the version to update.</p>
        /// <p>If no application version is found with this label, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>The name of the version to update.</p>
        /// <p>If no application version is found with this label, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// <p>A new description for this version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A new description for this version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationVersionInput`](crate::input::UpdateApplicationVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApplicationVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApplicationVersionInput {
                application_name: self.application_name,
                version_label: self.version_label,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApplicationVersionInputOperationOutputAlias =
    crate::operation::UpdateApplicationVersion;
#[doc(hidden)]
pub type UpdateApplicationVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApplicationVersionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApplicationVersion`](crate::operation::UpdateApplicationVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApplicationVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateApplicationVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateApplicationVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_application_version(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApplicationVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApplicationVersion",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateApplicationVersionInput`](crate::input::UpdateApplicationVersionInput)
    pub fn builder() -> crate::input::update_application_version_input::Builder {
        crate::input::update_application_version_input::Builder::default()
    }
}

/// See [`UpdateConfigurationTemplateInput`](crate::input::UpdateConfigurationTemplateInput)
pub mod update_configuration_template_input {
    /// A builder for [`UpdateConfigurationTemplateInput`](crate::input::UpdateConfigurationTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) option_settings:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        pub(crate) options_to_remove:
            std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
    }
    impl Builder {
        /// <p>The name of the application associated with the configuration template to update.</p>
        /// <p> If no application is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application associated with the configuration template to update.</p>
        /// <p> If no application is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of the configuration template to update.</p>
        /// <p> If no configuration template is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration template to update.</p>
        /// <p> If no configuration template is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>A new description for the configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A new description for the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `option_settings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>A list of configuration option settings to update with the new specified option value.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            let mut v = self.option_settings.unwrap_or_default();
            v.push(input);
            self.option_settings = Some(v);
            self
        }
        /// <p>A list of configuration option settings to update with the new specified option value.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.option_settings = input;
            self
        }
        /// Appends an item to `options_to_remove`.
        ///
        /// To override the contents of this collection use [`set_options_to_remove`](Self::set_options_to_remove).
        ///
        /// <p>A list of configuration options to remove from the configuration set.</p>
        /// <p> Constraint: You can remove only <code>UserDefined</code> configuration options. </p>
        pub fn options_to_remove(mut self, input: crate::model::OptionSpecification) -> Self {
            let mut v = self.options_to_remove.unwrap_or_default();
            v.push(input);
            self.options_to_remove = Some(v);
            self
        }
        /// <p>A list of configuration options to remove from the configuration set.</p>
        /// <p> Constraint: You can remove only <code>UserDefined</code> configuration options. </p>
        pub fn set_options_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
        ) -> Self {
            self.options_to_remove = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigurationTemplateInput`](crate::input::UpdateConfigurationTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConfigurationTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConfigurationTemplateInput {
                application_name: self.application_name,
                template_name: self.template_name,
                description: self.description,
                option_settings: self.option_settings,
                options_to_remove: self.options_to_remove,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConfigurationTemplateInputOperationOutputAlias =
    crate::operation::UpdateConfigurationTemplate;
#[doc(hidden)]
pub type UpdateConfigurationTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateConfigurationTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConfigurationTemplate`](crate::operation::UpdateConfigurationTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConfigurationTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateConfigurationTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateConfigurationTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_configuration_template(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConfigurationTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConfigurationTemplate",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationTemplateInput`](crate::input::UpdateConfigurationTemplateInput)
    pub fn builder() -> crate::input::update_configuration_template_input::Builder {
        crate::input::update_configuration_template_input::Builder::default()
    }
}

/// See [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
pub mod update_environment_input {
    /// A builder for [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tier: std::option::Option<crate::model::EnvironmentTier>,
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) option_settings:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        pub(crate) options_to_remove:
            std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
    }
    impl Builder {
        /// <p>The name of the application with which the environment is associated.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application with which the environment is associated.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The ID of the environment to update.</p>
        /// <p>If no environment with this ID exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.</p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment to update.</p>
        /// <p>If no environment with this ID exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.</p>
        /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The name of the environment to update. If no environment with this name exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment to update. If no environment with this name exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name or environment ID parameters. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name or environment ID parameters. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk updates the description of this environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk updates the description of this environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>This specifies the tier to use to update the environment.</p>
        /// <p>Condition: At this time, if you change the tier version, name, or type, AWS Elastic Beanstalk returns <code>InvalidParameterValue</code> error. </p>
        pub fn tier(mut self, input: crate::model::EnvironmentTier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>This specifies the tier to use to update the environment.</p>
        /// <p>Condition: At this time, if you change the tier version, name, or type, AWS Elastic Beanstalk returns <code>InvalidParameterValue</code> error. </p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTier>,
        ) -> Self {
            self.tier = input;
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys the named application version to the environment. If no such application version is found, returns an <code>InvalidParameterValue</code> error. </p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys the named application version to the environment. If no such application version is found, returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys this configuration template to the environment. If no such configuration template is found, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys this configuration template to the environment. If no such configuration template is found, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>This specifies the platform version that the environment will run after the environment is updated.</p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p>This specifies the platform version that the environment will run after the environment is updated.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// <p>The ARN of the platform, if used.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the platform, if used.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// Appends an item to `option_settings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>If specified, AWS Elastic Beanstalk updates the configuration set associated with the running environment and sets the specified configuration options to the requested value.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            let mut v = self.option_settings.unwrap_or_default();
            v.push(input);
            self.option_settings = Some(v);
            self
        }
        /// <p>If specified, AWS Elastic Beanstalk updates the configuration set associated with the running environment and sets the specified configuration options to the requested value.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.option_settings = input;
            self
        }
        /// Appends an item to `options_to_remove`.
        ///
        /// To override the contents of this collection use [`set_options_to_remove`](Self::set_options_to_remove).
        ///
        /// <p>A list of custom user-defined configuration options to remove from the configuration set for this environment.</p>
        pub fn options_to_remove(mut self, input: crate::model::OptionSpecification) -> Self {
            let mut v = self.options_to_remove.unwrap_or_default();
            v.push(input);
            self.options_to_remove = Some(v);
            self
        }
        /// <p>A list of custom user-defined configuration options to remove from the configuration set for this environment.</p>
        pub fn set_options_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
        ) -> Self {
            self.options_to_remove = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEnvironmentInput {
                application_name: self.application_name,
                environment_id: self.environment_id,
                environment_name: self.environment_name,
                group_name: self.group_name,
                description: self.description,
                tier: self.tier,
                version_label: self.version_label,
                template_name: self.template_name,
                solution_stack_name: self.solution_stack_name,
                platform_arn: self.platform_arn,
                option_settings: self.option_settings,
                options_to_remove: self.options_to_remove,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEnvironmentInputOperationOutputAlias = crate::operation::UpdateEnvironment;
#[doc(hidden)]
pub type UpdateEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEnvironment`](crate::operation::UpdateEnvironment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateEnvironmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateEnvironmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_environment(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEnvironment",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
    pub fn builder() -> crate::input::update_environment_input::Builder {
        crate::input::update_environment_input::Builder::default()
    }
}

/// See [`UpdateTagsForResourceInput`](crate::input::UpdateTagsForResourceInput)
pub mod update_tags_for_resource_input {
    /// A builder for [`UpdateTagsForResourceInput`](crate::input::UpdateTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags_to_add: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) tags_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resouce to be updated.</p>
        /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resouce to be updated.</p>
        /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags_to_add`.
        ///
        /// To override the contents of this collection use [`set_tags_to_add`](Self::set_tags_to_add).
        ///
        /// <p>A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.</p>
        /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
        pub fn tags_to_add(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags_to_add.unwrap_or_default();
            v.push(input);
            self.tags_to_add = Some(v);
            self
        }
        /// <p>A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.</p>
        /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
        pub fn set_tags_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags_to_add = input;
            self
        }
        /// Appends an item to `tags_to_remove`.
        ///
        /// To override the contents of this collection use [`set_tags_to_remove`](Self::set_tags_to_remove).
        ///
        /// <p>A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.</p>
        /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
        pub fn tags_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tags_to_remove.unwrap_or_default();
            v.push(input.into());
            self.tags_to_remove = Some(v);
            self
        }
        /// <p>A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.</p>
        /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
        pub fn set_tags_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tags_to_remove = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTagsForResourceInput`](crate::input::UpdateTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTagsForResourceInput {
                resource_arn: self.resource_arn,
                tags_to_add: self.tags_to_add,
                tags_to_remove: self.tags_to_remove,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTagsForResourceInputOperationOutputAlias = crate::operation::UpdateTagsForResource;
#[doc(hidden)]
pub type UpdateTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTagsForResource`](crate::operation::UpdateTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_tags_for_resource(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTagsForResource",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateTagsForResourceInput`](crate::input::UpdateTagsForResourceInput)
    pub fn builder() -> crate::input::update_tags_for_resource_input::Builder {
        crate::input::update_tags_for_resource_input::Builder::default()
    }
}

/// See [`ValidateConfigurationSettingsInput`](crate::input::ValidateConfigurationSettingsInput)
pub mod validate_configuration_settings_input {
    /// A builder for [`ValidateConfigurationSettingsInput`](crate::input::ValidateConfigurationSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) option_settings:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
    }
    impl Builder {
        /// <p>The name of the application that the configuration template or environment belongs to.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application that the configuration template or environment belongs to.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of the configuration template to validate the settings against.</p>
        /// <p>Condition: You cannot specify both this and an environment name.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration template to validate the settings against.</p>
        /// <p>Condition: You cannot specify both this and an environment name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The name of the environment to validate the settings against.</p>
        /// <p>Condition: You cannot specify both this and a configuration template name.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment to validate the settings against.</p>
        /// <p>Condition: You cannot specify both this and a configuration template name.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Appends an item to `option_settings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>A list of the options and desired values to evaluate.</p>
        pub fn option_settings(mut self, input: crate::model::ConfigurationOptionSetting) -> Self {
            let mut v = self.option_settings.unwrap_or_default();
            v.push(input);
            self.option_settings = Some(v);
            self
        }
        /// <p>A list of the options and desired values to evaluate.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.option_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidateConfigurationSettingsInput`](crate::input::ValidateConfigurationSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ValidateConfigurationSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ValidateConfigurationSettingsInput {
                application_name: self.application_name,
                template_name: self.template_name,
                environment_name: self.environment_name,
                option_settings: self.option_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type ValidateConfigurationSettingsInputOperationOutputAlias =
    crate::operation::ValidateConfigurationSettings;
#[doc(hidden)]
pub type ValidateConfigurationSettingsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ValidateConfigurationSettingsInput {
    /// Consumes the builder and constructs an Operation<[`ValidateConfigurationSettings`](crate::operation::ValidateConfigurationSettings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ValidateConfigurationSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ValidateConfigurationSettingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ValidateConfigurationSettingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_validate_configuration_settings(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ValidateConfigurationSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ValidateConfigurationSettings",
            "elasticbeanstalk",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ValidateConfigurationSettingsInput`](crate::input::ValidateConfigurationSettingsInput)
    pub fn builder() -> crate::input::validate_configuration_settings_input::Builder {
        crate::input::validate_configuration_settings_input::Builder::default()
    }
}

/// <p>A list of validation messages for a specified configuration template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidateConfigurationSettingsInput {
    /// <p>The name of the application that the configuration template or environment belongs to.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of the configuration template to validate the settings against.</p>
    /// <p>Condition: You cannot specify both this and an environment name.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The name of the environment to validate the settings against.</p>
    /// <p>Condition: You cannot specify both this and a configuration template name.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>A list of the options and desired values to evaluate.</p>
    pub option_settings:
        std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
}
impl ValidateConfigurationSettingsInput {
    /// <p>The name of the application that the configuration template or environment belongs to.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of the configuration template to validate the settings against.</p>
    /// <p>Condition: You cannot specify both this and an environment name.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The name of the environment to validate the settings against.</p>
    /// <p>Condition: You cannot specify both this and a configuration template name.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>A list of the options and desired values to evaluate.</p>
    pub fn option_settings(
        &self,
    ) -> std::option::Option<&[crate::model::ConfigurationOptionSetting]> {
        self.option_settings.as_deref()
    }
}
impl std::fmt::Debug for ValidateConfigurationSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidateConfigurationSettingsInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("template_name", &self.template_name);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("option_settings", &self.option_settings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resouce to be updated.</p>
    /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.</p>
    /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
    pub tags_to_add: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.</p>
    /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
    pub tags_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resouce to be updated.</p>
    /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.</p>
    /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
    pub fn tags_to_add(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags_to_add.as_deref()
    }
    /// <p>A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.</p>
    /// <p>Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.</p>
    pub fn tags_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.tags_to_remove.as_deref()
    }
}
impl std::fmt::Debug for UpdateTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags_to_add", &self.tags_to_add);
        formatter.field("tags_to_remove", &self.tags_to_remove);
        formatter.finish()
    }
}

/// <p>Request to update an environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnvironmentInput {
    /// <p>The name of the application with which the environment is associated.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The ID of the environment to update.</p>
    /// <p>If no environment with this ID exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.</p>
    /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the environment to update. If no environment with this name exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
    /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name or environment ID parameters. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>If this parameter is specified, AWS Elastic Beanstalk updates the description of this environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>This specifies the tier to use to update the environment.</p>
    /// <p>Condition: At this time, if you change the tier version, name, or type, AWS Elastic Beanstalk returns <code>InvalidParameterValue</code> error. </p>
    pub tier: std::option::Option<crate::model::EnvironmentTier>,
    /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys the named application version to the environment. If no such application version is found, returns an <code>InvalidParameterValue</code> error. </p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys this configuration template to the environment. If no such configuration template is found, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>This specifies the platform version that the environment will run after the environment is updated.</p>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the platform, if used.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>If specified, AWS Elastic Beanstalk updates the configuration set associated with the running environment and sets the specified configuration options to the requested value.</p>
    pub option_settings:
        std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
    /// <p>A list of custom user-defined configuration options to remove from the configuration set for this environment.</p>
    pub options_to_remove: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
}
impl UpdateEnvironmentInput {
    /// <p>The name of the application with which the environment is associated.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The ID of the environment to update.</p>
    /// <p>If no environment with this ID exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.</p>
    /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The name of the environment to update. If no environment with this name exists, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
    /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name or environment ID parameters. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>If this parameter is specified, AWS Elastic Beanstalk updates the description of this environment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>This specifies the tier to use to update the environment.</p>
    /// <p>Condition: At this time, if you change the tier version, name, or type, AWS Elastic Beanstalk returns <code>InvalidParameterValue</code> error. </p>
    pub fn tier(&self) -> std::option::Option<&crate::model::EnvironmentTier> {
        self.tier.as_ref()
    }
    /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys the named application version to the environment. If no such application version is found, returns an <code>InvalidParameterValue</code> error. </p>
    pub fn version_label(&self) -> std::option::Option<&str> {
        self.version_label.as_deref()
    }
    /// <p>If this parameter is specified, AWS Elastic Beanstalk deploys this configuration template to the environment. If no such configuration template is found, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>This specifies the platform version that the environment will run after the environment is updated.</p>
    pub fn solution_stack_name(&self) -> std::option::Option<&str> {
        self.solution_stack_name.as_deref()
    }
    /// <p>The ARN of the platform, if used.</p>
    pub fn platform_arn(&self) -> std::option::Option<&str> {
        self.platform_arn.as_deref()
    }
    /// <p>If specified, AWS Elastic Beanstalk updates the configuration set associated with the running environment and sets the specified configuration options to the requested value.</p>
    pub fn option_settings(
        &self,
    ) -> std::option::Option<&[crate::model::ConfigurationOptionSetting]> {
        self.option_settings.as_deref()
    }
    /// <p>A list of custom user-defined configuration options to remove from the configuration set for this environment.</p>
    pub fn options_to_remove(&self) -> std::option::Option<&[crate::model::OptionSpecification]> {
        self.options_to_remove.as_deref()
    }
}
impl std::fmt::Debug for UpdateEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnvironmentInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("group_name", &self.group_name);
        formatter.field("description", &self.description);
        formatter.field("tier", &self.tier);
        formatter.field("version_label", &self.version_label);
        formatter.field("template_name", &self.template_name);
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("option_settings", &self.option_settings);
        formatter.field("options_to_remove", &self.options_to_remove);
        formatter.finish()
    }
}

/// <p>The result message containing the options for the specified solution stack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationTemplateInput {
    /// <p>The name of the application associated with the configuration template to update.</p>
    /// <p> If no application is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of the configuration template to update.</p>
    /// <p> If no configuration template is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>A new description for the configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of configuration option settings to update with the new specified option value.</p>
    pub option_settings:
        std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
    /// <p>A list of configuration options to remove from the configuration set.</p>
    /// <p> Constraint: You can remove only <code>UserDefined</code> configuration options. </p>
    pub options_to_remove: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
}
impl UpdateConfigurationTemplateInput {
    /// <p>The name of the application associated with the configuration template to update.</p>
    /// <p> If no application is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of the configuration template to update.</p>
    /// <p> If no configuration template is found with this name, <code>UpdateConfigurationTemplate</code> returns an <code>InvalidParameterValue</code> error. </p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>A new description for the configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of configuration option settings to update with the new specified option value.</p>
    pub fn option_settings(
        &self,
    ) -> std::option::Option<&[crate::model::ConfigurationOptionSetting]> {
        self.option_settings.as_deref()
    }
    /// <p>A list of configuration options to remove from the configuration set.</p>
    /// <p> Constraint: You can remove only <code>UserDefined</code> configuration options. </p>
    pub fn options_to_remove(&self) -> std::option::Option<&[crate::model::OptionSpecification]> {
        self.options_to_remove.as_deref()
    }
}
impl std::fmt::Debug for UpdateConfigurationTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationTemplateInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("template_name", &self.template_name);
        formatter.field("description", &self.description);
        formatter.field("option_settings", &self.option_settings);
        formatter.field("options_to_remove", &self.options_to_remove);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationVersionInput {
    /// <p>The name of the application associated with this version.</p>
    /// <p> If no application is found with this name, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of the version to update.</p>
    /// <p>If no application version is found with this label, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p>A new description for this version.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateApplicationVersionInput {
    /// <p>The name of the application associated with this version.</p>
    /// <p> If no application is found with this name, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of the version to update.</p>
    /// <p>If no application version is found with this label, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
    pub fn version_label(&self) -> std::option::Option<&str> {
        self.version_label.as_deref()
    }
    /// <p>A new description for this version.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateApplicationVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationVersionInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("version_label", &self.version_label);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationResourceLifecycleInput {
    /// <p>The name of the application.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The lifecycle configuration.</p>
    pub resource_lifecycle_config:
        std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
}
impl UpdateApplicationResourceLifecycleInput {
    /// <p>The name of the application.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The lifecycle configuration.</p>
    pub fn resource_lifecycle_config(
        &self,
    ) -> std::option::Option<&crate::model::ApplicationResourceLifecycleConfig> {
        self.resource_lifecycle_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateApplicationResourceLifecycleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationResourceLifecycleInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("resource_lifecycle_config", &self.resource_lifecycle_config);
        formatter.finish()
    }
}

/// <p>Request to update an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationInput {
    /// <p>The name of the application to update. If no such application is found, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>A new description for the application.</p>
    /// <p>Default: If not specified, AWS Elastic Beanstalk does not update the description.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateApplicationInput {
    /// <p>The name of the application to update. If no such application is found, <code>UpdateApplication</code> returns an <code>InvalidParameterValue</code> error. </p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>A new description for the application.</p>
    /// <p>Default: If not specified, AWS Elastic Beanstalk does not update the description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

/// <p>Request to terminate an environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateEnvironmentInput {
    /// <p>The ID of the environment to terminate.</p>
    /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the environment to terminate.</p>
    /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the associated AWS resources should shut down when the environment is terminated:</p>
    /// <ul>
    /// <li> <p> <code>true</code>: The specified environment as well as the associated AWS resources, such as Auto Scaling group and LoadBalancer, are terminated.</p> </li>
    /// <li> <p> <code>false</code>: AWS Elastic Beanstalk resource management is removed from the environment, but the AWS resources continue to operate.</p> </li>
    /// </ul>
    /// <p> For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS Elastic Beanstalk User Guide. </a> </p>
    /// <p> Default: <code>true</code> </p>
    /// <p> Valid Values: <code>true</code> | <code>false</code> </p>
    pub terminate_resources: std::option::Option<bool>,
    /// <p>Terminates the target environment even if another environment in the same group is dependent on it.</p>
    pub force_terminate: std::option::Option<bool>,
}
impl TerminateEnvironmentInput {
    /// <p>The ID of the environment to terminate.</p>
    /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The name of the environment to terminate.</p>
    /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>Indicates whether the associated AWS resources should shut down when the environment is terminated:</p>
    /// <ul>
    /// <li> <p> <code>true</code>: The specified environment as well as the associated AWS resources, such as Auto Scaling group and LoadBalancer, are terminated.</p> </li>
    /// <li> <p> <code>false</code>: AWS Elastic Beanstalk resource management is removed from the environment, but the AWS resources continue to operate.</p> </li>
    /// </ul>
    /// <p> For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS Elastic Beanstalk User Guide. </a> </p>
    /// <p> Default: <code>true</code> </p>
    /// <p> Valid Values: <code>true</code> | <code>false</code> </p>
    pub fn terminate_resources(&self) -> std::option::Option<bool> {
        self.terminate_resources
    }
    /// <p>Terminates the target environment even if another environment in the same group is dependent on it.</p>
    pub fn force_terminate(&self) -> std::option::Option<bool> {
        self.force_terminate
    }
}
impl std::fmt::Debug for TerminateEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateEnvironmentInput");
        formatter.field("environment_id", &self.environment_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("terminate_resources", &self.terminate_resources);
        formatter.field("force_terminate", &self.force_terminate);
        formatter.finish()
    }
}

/// <p>Swaps the CNAMEs of two environments.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SwapEnvironmentCnamEsInput {
    /// <p>The ID of the source environment.</p>
    /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentId</code>, you must specify the <code>DestinationEnvironmentId</code>. </p>
    pub source_environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the source environment.</p>
    /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentName</code>, you must specify the <code>DestinationEnvironmentName</code>. </p>
    pub source_environment_name: std::option::Option<std::string::String>,
    /// <p>The ID of the destination environment.</p>
    /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentId</code> with the <code>DestinationEnvironmentId</code>. </p>
    pub destination_environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the destination environment.</p>
    /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentName</code> with the <code>DestinationEnvironmentName</code>. </p>
    pub destination_environment_name: std::option::Option<std::string::String>,
}
impl SwapEnvironmentCnamEsInput {
    /// <p>The ID of the source environment.</p>
    /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentId</code>, you must specify the <code>DestinationEnvironmentId</code>. </p>
    pub fn source_environment_id(&self) -> std::option::Option<&str> {
        self.source_environment_id.as_deref()
    }
    /// <p>The name of the source environment.</p>
    /// <p> Condition: You must specify at least the <code>SourceEnvironmentID</code> or the <code>SourceEnvironmentName</code>. You may also specify both. If you specify the <code>SourceEnvironmentName</code>, you must specify the <code>DestinationEnvironmentName</code>. </p>
    pub fn source_environment_name(&self) -> std::option::Option<&str> {
        self.source_environment_name.as_deref()
    }
    /// <p>The ID of the destination environment.</p>
    /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentId</code> with the <code>DestinationEnvironmentId</code>. </p>
    pub fn destination_environment_id(&self) -> std::option::Option<&str> {
        self.destination_environment_id.as_deref()
    }
    /// <p>The name of the destination environment.</p>
    /// <p> Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the <code>SourceEnvironmentName</code> with the <code>DestinationEnvironmentName</code>. </p>
    pub fn destination_environment_name(&self) -> std::option::Option<&str> {
        self.destination_environment_name.as_deref()
    }
}
impl std::fmt::Debug for SwapEnvironmentCnamEsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SwapEnvironmentCnamEsInput");
        formatter.field("source_environment_id", &self.source_environment_id);
        formatter.field("source_environment_name", &self.source_environment_name);
        formatter.field(
            "destination_environment_id",
            &self.destination_environment_id,
        );
        formatter.field(
            "destination_environment_name",
            &self.destination_environment_name,
        );
        formatter.finish()
    }
}

/// <p>Request to download logs retrieved with <code>RequestEnvironmentInfo</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetrieveEnvironmentInfoInput {
    /// <p>The ID of the data's environment.</p>
    /// <p>If no such environment is found, returns an <code>InvalidParameterValue</code> error.</p>
    /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the data's environment.</p>
    /// <p> If no such environment is found, returns an <code>InvalidParameterValue</code> error. </p>
    /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The type of information to retrieve.</p>
    pub info_type: std::option::Option<crate::model::EnvironmentInfoType>,
}
impl RetrieveEnvironmentInfoInput {
    /// <p>The ID of the data's environment.</p>
    /// <p>If no such environment is found, returns an <code>InvalidParameterValue</code> error.</p>
    /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The name of the data's environment.</p>
    /// <p> If no such environment is found, returns an <code>InvalidParameterValue</code> error. </p>
    /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The type of information to retrieve.</p>
    pub fn info_type(&self) -> std::option::Option<&crate::model::EnvironmentInfoType> {
        self.info_type.as_ref()
    }
}
impl std::fmt::Debug for RetrieveEnvironmentInfoInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetrieveEnvironmentInfoInput");
        formatter.field("environment_id", &self.environment_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("info_type", &self.info_type);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestartAppServerInput {
    /// <p>The ID of the environment to restart the server for.</p>
    /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the environment to restart the server for.</p>
    /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_name: std::option::Option<std::string::String>,
}
impl RestartAppServerInput {
    /// <p>The ID of the environment to restart the server for.</p>
    /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The name of the environment to restart the server for.</p>
    /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
}
impl std::fmt::Debug for RestartAppServerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestartAppServerInput");
        formatter.field("environment_id", &self.environment_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.finish()
    }
}

/// <p>Request to retrieve logs from an environment and store them in your Elastic Beanstalk storage bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestEnvironmentInfoInput {
    /// <p>The ID of the environment of the requested data.</p>
    /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>
    /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the environment of the requested data.</p>
    /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>
    /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The type of information to request.</p>
    pub info_type: std::option::Option<crate::model::EnvironmentInfoType>,
}
impl RequestEnvironmentInfoInput {
    /// <p>The ID of the environment of the requested data.</p>
    /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>
    /// <p>Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The name of the environment of the requested data.</p>
    /// <p>If no such environment is found, <code>RequestEnvironmentInfo</code> returns an <code>InvalidParameterValue</code> error. </p>
    /// <p>Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The type of information to request.</p>
    pub fn info_type(&self) -> std::option::Option<&crate::model::EnvironmentInfoType> {
        self.info_type.as_ref()
    }
}
impl std::fmt::Debug for RequestEnvironmentInfoInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestEnvironmentInfoInput");
        formatter.field("environment_id", &self.environment_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("info_type", &self.info_type);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebuildEnvironmentInput {
    /// <p>The ID of the environment to rebuild.</p>
    /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the environment to rebuild.</p>
    /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_name: std::option::Option<std::string::String>,
}
impl RebuildEnvironmentInput {
    /// <p>The ID of the environment to rebuild.</p>
    /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The name of the environment to rebuild.</p>
    /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
}
impl std::fmt::Debug for RebuildEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebuildEnvironmentInput");
        formatter.field("environment_id", &self.environment_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resouce for which a tag list is requested.</p>
    /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resouce for which a tag list is requested.</p>
    /// <p>Must be the ARN of an Elastic Beanstalk resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPlatformVersionsInput {
    /// <p>Criteria for restricting the resulting list of platform versions. The filter is interpreted as a logical conjunction (AND) of the separate <code>PlatformFilter</code> terms.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::PlatformFilter>>,
    /// <p>The maximum number of platform version values returned in one call.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
    /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPlatformVersionsInput {
    /// <p>Criteria for restricting the resulting list of platform versions. The filter is interpreted as a logical conjunction (AND) of the separate <code>PlatformFilter</code> terms.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::PlatformFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of platform version values returned in one call.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
    /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPlatformVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPlatformVersionsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPlatformBranchesInput {
    /// <p>Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical conjunction (AND) of the separate <code>SearchFilter</code> terms.</p>
    /// <p>The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most operators take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple values.</p>
    /// <ul>
    /// <li> <p> <code>Attribute = BranchName</code>:</p>
    /// <ul>
    /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>
    /// </ul> </li>
    /// <li> <p> <code>Attribute = LifecycleState</code>:</p>
    /// <ul>
    /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code> </p> </li>
    /// <li> <p> <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> | <code>retired</code> </p> </li>
    /// </ul> </li>
    /// <li> <p> <code>Attribute = PlatformName</code>:</p>
    /// <ul>
    /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>
    /// </ul> </li>
    /// <li> <p> <code>Attribute = TierType</code>:</p>
    /// <ul>
    /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> </p> </li>
    /// <li> <p> <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code> </p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>Array size: limited to 10 <code>SearchFilter</code> objects.</p>
    /// <p>Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::SearchFilter>>,
    /// <p>The maximum number of platform branch values returned in one call.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
    /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPlatformBranchesInput {
    /// <p>Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical conjunction (AND) of the separate <code>SearchFilter</code> terms.</p>
    /// <p>The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most operators take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple values.</p>
    /// <ul>
    /// <li> <p> <code>Attribute = BranchName</code>:</p>
    /// <ul>
    /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>
    /// </ul> </li>
    /// <li> <p> <code>Attribute = LifecycleState</code>:</p>
    /// <ul>
    /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code> </p> </li>
    /// <li> <p> <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> | <code>retired</code> </p> </li>
    /// </ul> </li>
    /// <li> <p> <code>Attribute = PlatformName</code>:</p>
    /// <ul>
    /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code> </p> </li>
    /// </ul> </li>
    /// <li> <p> <code>Attribute = TierType</code>:</p>
    /// <ul>
    /// <li> <p> <code>Operator</code>: <code>=</code> | <code>!=</code> </p> </li>
    /// <li> <p> <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code> </p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>Array size: limited to 10 <code>SearchFilter</code> objects.</p>
    /// <p>Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::SearchFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of platform branch values returned in one call.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
    /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPlatformBranchesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPlatformBranchesInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAvailableSolutionStacksInput {}
impl std::fmt::Debug for ListAvailableSolutionStacksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAvailableSolutionStacksInput");
        formatter.finish()
    }
}

/// <p>Request to disassociate the operations role from an environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateEnvironmentOperationsRoleInput {
    /// <p>The name of the environment from which to disassociate the operations role.</p>
    pub environment_name: std::option::Option<std::string::String>,
}
impl DisassociateEnvironmentOperationsRoleInput {
    /// <p>The name of the environment from which to disassociate the operations role.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
}
impl std::fmt::Debug for DisassociateEnvironmentOperationsRoleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateEnvironmentOperationsRoleInput");
        formatter.field("environment_name", &self.environment_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePlatformVersionInput {
    /// <p>The ARN of the platform version.</p>
    pub platform_arn: std::option::Option<std::string::String>,
}
impl DescribePlatformVersionInput {
    /// <p>The ARN of the platform version.</p>
    pub fn platform_arn(&self) -> std::option::Option<&str> {
        self.platform_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribePlatformVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePlatformVersionInput");
        formatter.field("platform_arn", &self.platform_arn);
        formatter.finish()
    }
}

/// <p>Parameters for a call to <code>DescribeInstancesHealth</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstancesHealthInput {
    /// <p>Specify the AWS Elastic Beanstalk environment by name.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>Specify the AWS Elastic Beanstalk environment by ID.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns a list of instances.</p>
    pub attribute_names: std::option::Option<std::vec::Vec<crate::model::InstancesHealthAttribute>>,
    /// <p>Specify the pagination token returned by a previous call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeInstancesHealthInput {
    /// <p>Specify the AWS Elastic Beanstalk environment by name.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>Specify the AWS Elastic Beanstalk environment by ID.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns a list of instances.</p>
    pub fn attribute_names(
        &self,
    ) -> std::option::Option<&[crate::model::InstancesHealthAttribute]> {
        self.attribute_names.as_deref()
    }
    /// <p>Specify the pagination token returned by a previous call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeInstancesHealthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstancesHealthInput");
        formatter.field("environment_name", &self.environment_name);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("attribute_names", &self.attribute_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Request to retrieve a list of events for an environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsInput {
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those associated with this application.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this application version.</p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that are associated with this environment configuration.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this custom platform version.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>If specified, AWS Elastic Beanstalk restricts the described events to include only those associated with this request ID.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>If specified, limits the events returned from this call to include only those with the specified severity or higher.</p>
    pub severity: std::option::Option<crate::model::EventSeverity>,
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur on or after this time.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur up to, but not including, the <code>EndTime</code>. </p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the maximum number of events that can be returned, beginning with the most recent event.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>Pagination token. If specified, the events return the next batch of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeEventsInput {
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those associated with this application.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this application version.</p>
    pub fn version_label(&self) -> std::option::Option<&str> {
        self.version_label.as_deref()
    }
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that are associated with this environment configuration.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this custom platform version.</p>
    pub fn platform_arn(&self) -> std::option::Option<&str> {
        self.platform_arn.as_deref()
    }
    /// <p>If specified, AWS Elastic Beanstalk restricts the described events to include only those associated with this request ID.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>If specified, limits the events returned from this call to include only those with the specified severity or higher.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::EventSeverity> {
        self.severity.as_ref()
    }
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur on or after this time.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p> If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur up to, but not including, the <code>EndTime</code>. </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>Specifies the maximum number of events that can be returned, beginning with the most recent event.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>Pagination token. If specified, the events return the next batch of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("version_label", &self.version_label);
        formatter.field("template_name", &self.template_name);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("request_id", &self.request_id);
        formatter.field("severity", &self.severity);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("max_records", &self.max_records);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Request to describe one or more environments.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEnvironmentsInput {
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application version.</p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified IDs.</p>
    pub environment_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified names.</p>
    pub environment_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether to include deleted environments:</p>
    /// <p> <code>true</code>: Environments that have been deleted after <code>IncludedDeletedBackTo</code> are displayed.</p>
    /// <p> <code>false</code>: Do not include deleted environments.</p>
    pub include_deleted: std::option::Option<bool>,
    /// <p> If specified when <code>IncludeDeleted</code> is set to <code>true</code>, then environments deleted after this date are displayed. </p>
    pub included_deleted_back_to: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>For a paginated request. Specify a maximum number of environments to include in each response.</p>
    /// <p>If no <code>MaxRecords</code> is specified, all available environments are retrieved in a single response.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
    /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeEnvironmentsInput {
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application version.</p>
    pub fn version_label(&self) -> std::option::Option<&str> {
        self.version_label.as_deref()
    }
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified IDs.</p>
    pub fn environment_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.environment_ids.as_deref()
    }
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified names.</p>
    pub fn environment_names(&self) -> std::option::Option<&[std::string::String]> {
        self.environment_names.as_deref()
    }
    /// <p>Indicates whether to include deleted environments:</p>
    /// <p> <code>true</code>: Environments that have been deleted after <code>IncludedDeletedBackTo</code> are displayed.</p>
    /// <p> <code>false</code>: Do not include deleted environments.</p>
    pub fn include_deleted(&self) -> std::option::Option<bool> {
        self.include_deleted
    }
    /// <p> If specified when <code>IncludeDeleted</code> is set to <code>true</code>, then environments deleted after this date are displayed. </p>
    pub fn included_deleted_back_to(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.included_deleted_back_to.as_ref()
    }
    /// <p>For a paginated request. Specify a maximum number of environments to include in each response.</p>
    /// <p>If no <code>MaxRecords</code> is specified, all available environments are retrieved in a single response.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
    /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeEnvironmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEnvironmentsInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("version_label", &self.version_label);
        formatter.field("environment_ids", &self.environment_ids);
        formatter.field("environment_names", &self.environment_names);
        formatter.field("include_deleted", &self.include_deleted);
        formatter.field("included_deleted_back_to", &self.included_deleted_back_to);
        formatter.field("max_records", &self.max_records);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Request to describe the resources in an environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEnvironmentResourcesInput {
    /// <p>The ID of the environment to retrieve AWS resource usage data.</p>
    /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the environment to retrieve AWS resource usage data.</p>
    /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_name: std::option::Option<std::string::String>,
}
impl DescribeEnvironmentResourcesInput {
    /// <p>The ID of the environment to retrieve AWS resource usage data.</p>
    /// <p> Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The name of the environment to retrieve AWS resource usage data.</p>
    /// <p> Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeEnvironmentResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEnvironmentResourcesInput");
        formatter.field("environment_id", &self.environment_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.finish()
    }
}

/// <p>Request to list an environment's upcoming and in-progress managed actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEnvironmentManagedActionsInput {
    /// <p>The name of the target environment.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The environment ID of the target environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>To show only actions with a particular status, specify a status.</p>
    pub status: std::option::Option<crate::model::ActionStatus>,
}
impl DescribeEnvironmentManagedActionsInput {
    /// <p>The name of the target environment.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The environment ID of the target environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>To show only actions with a particular status, specify a status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ActionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DescribeEnvironmentManagedActionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEnvironmentManagedActionsInput");
        formatter.field("environment_name", &self.environment_name);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

/// <p>Request to list completed and failed managed actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEnvironmentManagedActionHistoryInput {
    /// <p>The environment ID of the target environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the target environment.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The pagination token returned by a previous request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return for a single request.</p>
    pub max_items: std::option::Option<i32>,
}
impl DescribeEnvironmentManagedActionHistoryInput {
    /// <p>The environment ID of the target environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The name of the target environment.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The pagination token returned by a previous request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return for a single request.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for DescribeEnvironmentManagedActionHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEnvironmentManagedActionHistoryInput");
        formatter.field("environment_id", &self.environment_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>See the example below to learn how to create a request body.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEnvironmentHealthInput {
    /// <p>Specify the environment by name.</p>
    /// <p>You must specify either this or an EnvironmentName, or both.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>Specify the environment by ID.</p>
    /// <p>You must specify either this or an EnvironmentName, or both.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns the name of the environment.</p>
    pub attribute_names:
        std::option::Option<std::vec::Vec<crate::model::EnvironmentHealthAttribute>>,
}
impl DescribeEnvironmentHealthInput {
    /// <p>Specify the environment by name.</p>
    /// <p>You must specify either this or an EnvironmentName, or both.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>Specify the environment by ID.</p>
    /// <p>You must specify either this or an EnvironmentName, or both.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no attribute names are specified, returns the name of the environment.</p>
    pub fn attribute_names(
        &self,
    ) -> std::option::Option<&[crate::model::EnvironmentHealthAttribute]> {
        self.attribute_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeEnvironmentHealthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEnvironmentHealthInput");
        formatter.field("environment_name", &self.environment_name);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("attribute_names", &self.attribute_names);
        formatter.finish()
    }
}

/// <p>Result message containing all of the configuration settings for a specified solution stack or configuration template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationSettingsInput {
    /// <p>The application for the environment or configuration template.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of the configuration template to describe.</p>
    /// <p> Conditional: You must specify either this parameter or an EnvironmentName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns a <code>MissingRequiredParameter</code> error. </p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The name of the environment to describe.</p>
    /// <p> Condition: You must specify either this or a TemplateName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub environment_name: std::option::Option<std::string::String>,
}
impl DescribeConfigurationSettingsInput {
    /// <p>The application for the environment or configuration template.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of the configuration template to describe.</p>
    /// <p> Conditional: You must specify either this parameter or an EnvironmentName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns a <code>MissingRequiredParameter</code> error. </p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The name of the environment to describe.</p>
    /// <p> Condition: You must specify either this or a TemplateName, but not both. If you specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error. </p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeConfigurationSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationSettingsInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("template_name", &self.template_name);
        formatter.field("environment_name", &self.environment_name);
        formatter.finish()
    }
}

/// <p>Result message containing a list of application version descriptions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationOptionsInput {
    /// <p>The name of the application associated with the configuration template or environment. Only needed if you want to describe the configuration options associated with either the configuration template or environment.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of the configuration template whose configuration options you want to describe.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The name of the environment whose configuration options you want to describe.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The name of the solution stack whose configuration options you want to describe.</p>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the custom platform.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>If specified, restricts the descriptions to only the specified options.</p>
    pub options: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
}
impl DescribeConfigurationOptionsInput {
    /// <p>The name of the application associated with the configuration template or environment. Only needed if you want to describe the configuration options associated with either the configuration template or environment.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of the configuration template whose configuration options you want to describe.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The name of the environment whose configuration options you want to describe.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The name of the solution stack whose configuration options you want to describe.</p>
    pub fn solution_stack_name(&self) -> std::option::Option<&str> {
        self.solution_stack_name.as_deref()
    }
    /// <p>The ARN of the custom platform.</p>
    pub fn platform_arn(&self) -> std::option::Option<&str> {
        self.platform_arn.as_deref()
    }
    /// <p>If specified, restricts the descriptions to only the specified options.</p>
    pub fn options(&self) -> std::option::Option<&[crate::model::OptionSpecification]> {
        self.options.as_deref()
    }
}
impl std::fmt::Debug for DescribeConfigurationOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationOptionsInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("template_name", &self.template_name);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("options", &self.options);
        formatter.finish()
    }
}

/// <p>Request to describe application versions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationVersionsInput {
    /// <p>Specify an application name to show only application versions for that application.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Specify a version label to show a specific application version.</p>
    pub version_labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>For a paginated request. Specify a maximum number of application versions to include in each response.</p>
    /// <p>If no <code>MaxRecords</code> is specified, all available application versions are retrieved in a single response.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
    /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeApplicationVersionsInput {
    /// <p>Specify an application name to show only application versions for that application.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>Specify a version label to show a specific application version.</p>
    pub fn version_labels(&self) -> std::option::Option<&[std::string::String]> {
        self.version_labels.as_deref()
    }
    /// <p>For a paginated request. Specify a maximum number of application versions to include in each response.</p>
    /// <p>If no <code>MaxRecords</code> is specified, all available application versions are retrieved in a single response.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.</p>
    /// <p>If no <code>NextToken</code> is specified, the first page is retrieved.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeApplicationVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationVersionsInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("version_labels", &self.version_labels);
        formatter.field("max_records", &self.max_records);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Request to describe one or more applications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationsInput {
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include those with the specified names.</p>
    pub application_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeApplicationsInput {
    /// <p>If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include those with the specified names.</p>
    pub fn application_names(&self) -> std::option::Option<&[std::string::String]> {
        self.application_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeApplicationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationsInput");
        formatter.field("application_names", &self.application_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountAttributesInput {}
impl std::fmt::Debug for DescribeAccountAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountAttributesInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePlatformVersionInput {
    /// <p>The ARN of the version of the custom platform.</p>
    pub platform_arn: std::option::Option<std::string::String>,
}
impl DeletePlatformVersionInput {
    /// <p>The ARN of the version of the custom platform.</p>
    pub fn platform_arn(&self) -> std::option::Option<&str> {
        self.platform_arn.as_deref()
    }
}
impl std::fmt::Debug for DeletePlatformVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePlatformVersionInput");
        formatter.field("platform_arn", &self.platform_arn);
        formatter.finish()
    }
}

/// <p>Request to delete a draft environment configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentConfigurationInput {
    /// <p>The name of the application the environment is associated with.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of the environment to delete the draft configuration from.</p>
    pub environment_name: std::option::Option<std::string::String>,
}
impl DeleteEnvironmentConfigurationInput {
    /// <p>The name of the application the environment is associated with.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of the environment to delete the draft configuration from.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteEnvironmentConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentConfigurationInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("environment_name", &self.environment_name);
        formatter.finish()
    }
}

/// <p>Request to delete a configuration template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationTemplateInput {
    /// <p>The name of the application to delete the configuration template from.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of the configuration template to delete.</p>
    pub template_name: std::option::Option<std::string::String>,
}
impl DeleteConfigurationTemplateInput {
    /// <p>The name of the application to delete the configuration template from.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of the configuration template to delete.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConfigurationTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationTemplateInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("template_name", &self.template_name);
        formatter.finish()
    }
}

/// <p>Request to delete an application version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationVersionInput {
    /// <p>The name of the application to which the version belongs.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The label of the version to delete.</p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p>Set to <code>true</code> to delete the source bundle from your storage bucket. Otherwise, the application version is deleted only from Elastic Beanstalk and the source bundle remains in Amazon S3.</p>
    pub delete_source_bundle: std::option::Option<bool>,
}
impl DeleteApplicationVersionInput {
    /// <p>The name of the application to which the version belongs.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The label of the version to delete.</p>
    pub fn version_label(&self) -> std::option::Option<&str> {
        self.version_label.as_deref()
    }
    /// <p>Set to <code>true</code> to delete the source bundle from your storage bucket. Otherwise, the application version is deleted only from Elastic Beanstalk and the source bundle remains in Amazon S3.</p>
    pub fn delete_source_bundle(&self) -> std::option::Option<bool> {
        self.delete_source_bundle
    }
}
impl std::fmt::Debug for DeleteApplicationVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationVersionInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("version_label", &self.version_label);
        formatter.field("delete_source_bundle", &self.delete_source_bundle);
        formatter.finish()
    }
}

/// <p>Request to delete an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationInput {
    /// <p>The name of the application to delete.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>When set to true, running environments will be terminated before deleting the application.</p>
    pub terminate_env_by_force: std::option::Option<bool>,
}
impl DeleteApplicationInput {
    /// <p>The name of the application to delete.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>When set to true, running environments will be terminated before deleting the application.</p>
    pub fn terminate_env_by_force(&self) -> std::option::Option<bool> {
        self.terminate_env_by_force
    }
}
impl std::fmt::Debug for DeleteApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("terminate_env_by_force", &self.terminate_env_by_force);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStorageLocationInput {}
impl std::fmt::Debug for CreateStorageLocationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStorageLocationInput");
        formatter.finish()
    }
}

/// <p>Request to create a new platform version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePlatformVersionInput {
    /// <p>The name of your custom platform.</p>
    pub platform_name: std::option::Option<std::string::String>,
    /// <p>The number, such as 1.0.2, for the new platform version.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>The location of the platform definition archive in Amazon S3.</p>
    pub platform_definition_bundle: std::option::Option<crate::model::S3Location>,
    /// <p>The name of the builder environment.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The configuration option settings to apply to the builder environment.</p>
    pub option_settings:
        std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
    /// <p>Specifies the tags applied to the new platform version.</p>
    /// <p>Elastic Beanstalk applies these tags only to the platform version. Environments that you create using the platform version don't inherit the tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreatePlatformVersionInput {
    /// <p>The name of your custom platform.</p>
    pub fn platform_name(&self) -> std::option::Option<&str> {
        self.platform_name.as_deref()
    }
    /// <p>The number, such as 1.0.2, for the new platform version.</p>
    pub fn platform_version(&self) -> std::option::Option<&str> {
        self.platform_version.as_deref()
    }
    /// <p>The location of the platform definition archive in Amazon S3.</p>
    pub fn platform_definition_bundle(&self) -> std::option::Option<&crate::model::S3Location> {
        self.platform_definition_bundle.as_ref()
    }
    /// <p>The name of the builder environment.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The configuration option settings to apply to the builder environment.</p>
    pub fn option_settings(
        &self,
    ) -> std::option::Option<&[crate::model::ConfigurationOptionSetting]> {
        self.option_settings.as_deref()
    }
    /// <p>Specifies the tags applied to the new platform version.</p>
    /// <p>Elastic Beanstalk applies these tags only to the platform version. Environments that you create using the platform version don't inherit the tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreatePlatformVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePlatformVersionInput");
        formatter.field("platform_name", &self.platform_name);
        formatter.field("platform_version", &self.platform_version);
        formatter.field(
            "platform_definition_bundle",
            &self.platform_definition_bundle,
        );
        formatter.field("environment_name", &self.environment_name);
        formatter.field("option_settings", &self.option_settings);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentInput {
    /// <p>The name of the application that is associated with this environment.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>A unique name for the environment.</p>
    /// <p>Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and hyphens. It can't start or end with a hyphen. This name must be unique within a region in your account. If the specified name already exists in the region, Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
    /// <p>If you don't specify the <code>CNAMEPrefix</code> parameter, the environment name becomes part of the CNAME, and therefore part of the visible URL for your application.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name parameter. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>Your description for this environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>If specified, the environment attempts to use this value as the prefix for the CNAME in your Elastic Beanstalk environment URL. If not specified, the CNAME is generated automatically by appending a random alphanumeric string to the environment name.</p>
    pub cname_prefix: std::option::Option<std::string::String>,
    /// <p>Specifies the tier to use in creating this environment. The environment tier that you choose determines whether Elastic Beanstalk provisions resources to support a web application that handles HTTP(S) requests or a web application that handles background-processing tasks.</p>
    pub tier: std::option::Option<crate::model::EnvironmentTier>,
    /// <p>Specifies the tags applied to resources in the environment.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the application version to deploy.</p>
    /// <p>Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.</p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p>The name of the Elastic Beanstalk configuration template to use with the environment.</p> <note>
    /// <p>If you specify <code>TemplateName</code>, then don't specify <code>SolutionStackName</code>.</p>
    /// </note>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If specified, Elastic Beanstalk sets the configuration values to the default values associated with the specified solution stack. For a list of current solution stacks, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic Beanstalk Supported Platforms</a> in the <i>AWS Elastic Beanstalk Platforms</i> guide.</p> <note>
    /// <p>If you specify <code>SolutionStackName</code>, don't specify <code>PlatformArn</code> or <code>TemplateName</code>.</p>
    /// </note>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the custom platform to use with the environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
    /// <p>If you specify <code>PlatformArn</code>, don't specify <code>SolutionStackName</code>.</p>
    /// </note>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the configuration set for the new environment. These override the values obtained from the solution stack or the configuration template.</p>
    pub option_settings:
        std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
    /// <p>A list of custom user-defined configuration options to remove from the configuration set for this new environment.</p>
    pub options_to_remove: std::option::Option<std::vec::Vec<crate::model::OptionSpecification>>,
    /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role. If specified, Elastic Beanstalk uses the operations role for permissions to downstream services during this call and during subsequent calls acting on this environment. To specify an operations role, you must have the <code>iam:PassRole</code> permission for the role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    pub operations_role: std::option::Option<std::string::String>,
}
impl CreateEnvironmentInput {
    /// <p>The name of the application that is associated with this environment.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>A unique name for the environment.</p>
    /// <p>Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and hyphens. It can't start or end with a hyphen. This name must be unique within a region in your account. If the specified name already exists in the region, Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
    /// <p>If you don't specify the <code>CNAMEPrefix</code> parameter, the environment name becomes part of the CNAME, and therefore part of the visible URL for your application.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name parameter. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>Your description for this environment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>If specified, the environment attempts to use this value as the prefix for the CNAME in your Elastic Beanstalk environment URL. If not specified, the CNAME is generated automatically by appending a random alphanumeric string to the environment name.</p>
    pub fn cname_prefix(&self) -> std::option::Option<&str> {
        self.cname_prefix.as_deref()
    }
    /// <p>Specifies the tier to use in creating this environment. The environment tier that you choose determines whether Elastic Beanstalk provisions resources to support a web application that handles HTTP(S) requests or a web application that handles background-processing tasks.</p>
    pub fn tier(&self) -> std::option::Option<&crate::model::EnvironmentTier> {
        self.tier.as_ref()
    }
    /// <p>Specifies the tags applied to resources in the environment.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The name of the application version to deploy.</p>
    /// <p>Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.</p>
    pub fn version_label(&self) -> std::option::Option<&str> {
        self.version_label.as_deref()
    }
    /// <p>The name of the Elastic Beanstalk configuration template to use with the environment.</p> <note>
    /// <p>If you specify <code>TemplateName</code>, then don't specify <code>SolutionStackName</code>.</p>
    /// </note>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If specified, Elastic Beanstalk sets the configuration values to the default values associated with the specified solution stack. For a list of current solution stacks, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic Beanstalk Supported Platforms</a> in the <i>AWS Elastic Beanstalk Platforms</i> guide.</p> <note>
    /// <p>If you specify <code>SolutionStackName</code>, don't specify <code>PlatformArn</code> or <code>TemplateName</code>.</p>
    /// </note>
    pub fn solution_stack_name(&self) -> std::option::Option<&str> {
        self.solution_stack_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the custom platform to use with the environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
    /// <p>If you specify <code>PlatformArn</code>, don't specify <code>SolutionStackName</code>.</p>
    /// </note>
    pub fn platform_arn(&self) -> std::option::Option<&str> {
        self.platform_arn.as_deref()
    }
    /// <p>If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the configuration set for the new environment. These override the values obtained from the solution stack or the configuration template.</p>
    pub fn option_settings(
        &self,
    ) -> std::option::Option<&[crate::model::ConfigurationOptionSetting]> {
        self.option_settings.as_deref()
    }
    /// <p>A list of custom user-defined configuration options to remove from the configuration set for this new environment.</p>
    pub fn options_to_remove(&self) -> std::option::Option<&[crate::model::OptionSpecification]> {
        self.options_to_remove.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role. If specified, Elastic Beanstalk uses the operations role for permissions to downstream services during this call and during subsequent calls acting on this environment. To specify an operations role, you must have the <code>iam:PassRole</code> permission for the role. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    pub fn operations_role(&self) -> std::option::Option<&str> {
        self.operations_role.as_deref()
    }
}
impl std::fmt::Debug for CreateEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("group_name", &self.group_name);
        formatter.field("description", &self.description);
        formatter.field("cname_prefix", &self.cname_prefix);
        formatter.field("tier", &self.tier);
        formatter.field("tags", &self.tags);
        formatter.field("version_label", &self.version_label);
        formatter.field("template_name", &self.template_name);
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("option_settings", &self.option_settings);
        formatter.field("options_to_remove", &self.options_to_remove);
        formatter.field("operations_role", &self.operations_role);
        formatter.finish()
    }
}

/// <p>Request to create a configuration template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationTemplateInput {
    /// <p>The name of the Elastic Beanstalk application to associate with this configuration template.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of the configuration template.</p>
    /// <p>Constraint: This name must be unique per application.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses. For example, <code>64bit Amazon Linux 2013.09 running Tomcat 7 Java 7</code>. A solution stack specifies the operating system, runtime, and application server for a configuration template. It also determines the set of configuration options as well as the possible and default values. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Supported Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    /// <p>You must specify <code>SolutionStackName</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SourceConfiguration</code>.</p>
    /// <p>Use the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html"> <code>ListAvailableSolutionStacks</code> </a> API to obtain a list of available solution stacks.</p>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the custom platform. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html"> Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
    /// <p>If you specify <code>PlatformArn</code>, then don't specify <code>SolutionStackName</code>.</p>
    /// </note>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>An Elastic Beanstalk configuration template to base this one on. If specified, Elastic Beanstalk uses the configuration values from the specified configuration template to create a new configuration.</p>
    /// <p>Values specified in <code>OptionSettings</code> override any values obtained from the <code>SourceConfiguration</code>.</p>
    /// <p>You must specify <code>SourceConfiguration</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SolutionStackName</code>.</p>
    /// <p>Constraint: If both solution stack name and source configuration are specified, the solution stack of the source configuration template must match the specified solution stack name.</p>
    pub source_configuration: std::option::Option<crate::model::SourceConfiguration>,
    /// <p>The ID of an environment whose settings you want to use to create the configuration template. You must specify <code>EnvironmentId</code> if you don't specify <code>PlatformArn</code>, <code>SolutionStackName</code>, or <code>SourceConfiguration</code>.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>An optional description for this configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Option values for the Elastic Beanstalk configuration, such as the instance type. If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html">Option Values</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    pub option_settings:
        std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
    /// <p>Specifies the tags applied to the configuration template.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateConfigurationTemplateInput {
    /// <p>The name of the Elastic Beanstalk application to associate with this configuration template.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of the configuration template.</p>
    /// <p>Constraint: This name must be unique per application.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses. For example, <code>64bit Amazon Linux 2013.09 running Tomcat 7 Java 7</code>. A solution stack specifies the operating system, runtime, and application server for a configuration template. It also determines the set of configuration options as well as the possible and default values. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Supported Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    /// <p>You must specify <code>SolutionStackName</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SourceConfiguration</code>.</p>
    /// <p>Use the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html"> <code>ListAvailableSolutionStacks</code> </a> API to obtain a list of available solution stacks.</p>
    pub fn solution_stack_name(&self) -> std::option::Option<&str> {
        self.solution_stack_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the custom platform. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html"> Custom Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
    /// <p>If you specify <code>PlatformArn</code>, then don't specify <code>SolutionStackName</code>.</p>
    /// </note>
    pub fn platform_arn(&self) -> std::option::Option<&str> {
        self.platform_arn.as_deref()
    }
    /// <p>An Elastic Beanstalk configuration template to base this one on. If specified, Elastic Beanstalk uses the configuration values from the specified configuration template to create a new configuration.</p>
    /// <p>Values specified in <code>OptionSettings</code> override any values obtained from the <code>SourceConfiguration</code>.</p>
    /// <p>You must specify <code>SourceConfiguration</code> if you don't specify <code>PlatformArn</code>, <code>EnvironmentId</code>, or <code>SolutionStackName</code>.</p>
    /// <p>Constraint: If both solution stack name and source configuration are specified, the solution stack of the source configuration template must match the specified solution stack name.</p>
    pub fn source_configuration(&self) -> std::option::Option<&crate::model::SourceConfiguration> {
        self.source_configuration.as_ref()
    }
    /// <p>The ID of an environment whose settings you want to use to create the configuration template. You must specify <code>EnvironmentId</code> if you don't specify <code>PlatformArn</code>, <code>SolutionStackName</code>, or <code>SourceConfiguration</code>.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>An optional description for this configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Option values for the Elastic Beanstalk configuration, such as the instance type. If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html">Option Values</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    pub fn option_settings(
        &self,
    ) -> std::option::Option<&[crate::model::ConfigurationOptionSetting]> {
        self.option_settings.as_deref()
    }
    /// <p>Specifies the tags applied to the configuration template.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateConfigurationTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationTemplateInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("template_name", &self.template_name);
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("source_configuration", &self.source_configuration);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("description", &self.description);
        formatter.field("option_settings", &self.option_settings);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationVersionInput {
    /// <p> The name of the application. If no application is found with this name, and <code>AutoCreateApplication</code> is <code>false</code>, returns an <code>InvalidParameterValue</code> error. </p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>A label identifying this version.</p>
    /// <p>Constraint: Must be unique per application. If an application version already exists with this label for the specified application, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p>A description of this application version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application version.</p>
    pub source_build_information: std::option::Option<crate::model::SourceBuildInformation>,
    /// <p>The Amazon S3 bucket and key that identify the location of the source bundle for this version.</p> <note>
    /// <p>The Amazon S3 bucket must be in the same region as the environment.</p>
    /// </note>
    /// <p>Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample application.</p>
    pub source_bundle: std::option::Option<crate::model::S3Location>,
    /// <p>Settings for an AWS CodeBuild build.</p>
    pub build_configuration: std::option::Option<crate::model::BuildConfiguration>,
    /// <p>Set to <code>true</code> to create an application with the specified name if it doesn't already exist.</p>
    pub auto_create_application: std::option::Option<bool>,
    /// <p>Pre-processes and validates the environment manifest (<code>env.yaml</code>) and configuration files (<code>*.config</code> files in the <code>.ebextensions</code> folder) in the source bundle. Validating configuration files can identify issues prior to deploying the application version to an environment.</p>
    /// <p>You must turn processing on for application versions that you create using AWS CodeBuild or AWS CodeCommit. For application versions built from a source bundle in Amazon S3, processing is optional.</p> <note>
    /// <p>The <code>Process</code> option validates Elastic Beanstalk configuration files. It doesn't validate your application's configuration files, like proxy server or Docker configuration.</p>
    /// </note>
    pub process: std::option::Option<bool>,
    /// <p>Specifies the tags applied to the application version.</p>
    /// <p>Elastic Beanstalk applies these tags only to the application version. Environments that use the application version don't inherit the tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateApplicationVersionInput {
    /// <p> The name of the application. If no application is found with this name, and <code>AutoCreateApplication</code> is <code>false</code>, returns an <code>InvalidParameterValue</code> error. </p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>A label identifying this version.</p>
    /// <p>Constraint: Must be unique per application. If an application version already exists with this label for the specified application, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error. </p>
    pub fn version_label(&self) -> std::option::Option<&str> {
        self.version_label.as_deref()
    }
    /// <p>A description of this application version.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application version.</p>
    pub fn source_build_information(
        &self,
    ) -> std::option::Option<&crate::model::SourceBuildInformation> {
        self.source_build_information.as_ref()
    }
    /// <p>The Amazon S3 bucket and key that identify the location of the source bundle for this version.</p> <note>
    /// <p>The Amazon S3 bucket must be in the same region as the environment.</p>
    /// </note>
    /// <p>Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample application.</p>
    pub fn source_bundle(&self) -> std::option::Option<&crate::model::S3Location> {
        self.source_bundle.as_ref()
    }
    /// <p>Settings for an AWS CodeBuild build.</p>
    pub fn build_configuration(&self) -> std::option::Option<&crate::model::BuildConfiguration> {
        self.build_configuration.as_ref()
    }
    /// <p>Set to <code>true</code> to create an application with the specified name if it doesn't already exist.</p>
    pub fn auto_create_application(&self) -> std::option::Option<bool> {
        self.auto_create_application
    }
    /// <p>Pre-processes and validates the environment manifest (<code>env.yaml</code>) and configuration files (<code>*.config</code> files in the <code>.ebextensions</code> folder) in the source bundle. Validating configuration files can identify issues prior to deploying the application version to an environment.</p>
    /// <p>You must turn processing on for application versions that you create using AWS CodeBuild or AWS CodeCommit. For application versions built from a source bundle in Amazon S3, processing is optional.</p> <note>
    /// <p>The <code>Process</code> option validates Elastic Beanstalk configuration files. It doesn't validate your application's configuration files, like proxy server or Docker configuration.</p>
    /// </note>
    pub fn process(&self) -> std::option::Option<bool> {
        self.process
    }
    /// <p>Specifies the tags applied to the application version.</p>
    /// <p>Elastic Beanstalk applies these tags only to the application version. Environments that use the application version don't inherit the tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateApplicationVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationVersionInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("version_label", &self.version_label);
        formatter.field("description", &self.description);
        formatter.field("source_build_information", &self.source_build_information);
        formatter.field("source_bundle", &self.source_bundle);
        formatter.field("build_configuration", &self.build_configuration);
        formatter.field("auto_create_application", &self.auto_create_application);
        formatter.field("process", &self.process);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Request to create an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationInput {
    /// <p>The name of the application. Must be unique within your account.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Your description of the application.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions.</p>
    pub resource_lifecycle_config:
        std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
    /// <p>Specifies the tags applied to the application.</p>
    /// <p>Elastic Beanstalk applies these tags only to the application. Environments that you create in the application don't inherit the tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateApplicationInput {
    /// <p>The name of the application. Must be unique within your account.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>Your description of the application.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions.</p>
    pub fn resource_lifecycle_config(
        &self,
    ) -> std::option::Option<&crate::model::ApplicationResourceLifecycleConfig> {
        self.resource_lifecycle_config.as_ref()
    }
    /// <p>Specifies the tags applied to the application.</p>
    /// <p>Elastic Beanstalk applies these tags only to the application. Environments that you create in the application don't inherit the tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("description", &self.description);
        formatter.field("resource_lifecycle_config", &self.resource_lifecycle_config);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Request to create or update a group of environments.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComposeEnvironmentsInput {
    /// <p>The name of the application to which the specified source bundles belong.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of the group to which the target environments belong. Specify a group name only if the environment name defined in each target environment's manifest ends with a + (plus) character. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>A list of version labels, specifying one or more application source bundles that belong to the target application. Each source bundle must include an environment manifest that specifies the name of the environment and the name of the solution stack to use, and optionally can specify environment links to create.</p>
    pub version_labels: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ComposeEnvironmentsInput {
    /// <p>The name of the application to which the specified source bundles belong.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The name of the group to which the target environments belong. Specify a group name only if the environment name defined in each target environment's manifest ends with a + (plus) character. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest (env.yaml)</a> for details.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>A list of version labels, specifying one or more application source bundles that belong to the target application. Each source bundle must include an environment manifest that specifies the name of the environment and the name of the solution stack to use, and optionally can specify environment links to create.</p>
    pub fn version_labels(&self) -> std::option::Option<&[std::string::String]> {
        self.version_labels.as_deref()
    }
}
impl std::fmt::Debug for ComposeEnvironmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComposeEnvironmentsInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("group_name", &self.group_name);
        formatter.field("version_labels", &self.version_labels);
        formatter.finish()
    }
}

/// <p>Results message indicating whether a CNAME is available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CheckDnsAvailabilityInput {
    /// <p>The prefix used when this CNAME is reserved.</p>
    pub cname_prefix: std::option::Option<std::string::String>,
}
impl CheckDnsAvailabilityInput {
    /// <p>The prefix used when this CNAME is reserved.</p>
    pub fn cname_prefix(&self) -> std::option::Option<&str> {
        self.cname_prefix.as_deref()
    }
}
impl std::fmt::Debug for CheckDnsAvailabilityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CheckDnsAvailabilityInput");
        formatter.field("cname_prefix", &self.cname_prefix);
        formatter.finish()
    }
}

/// <p>Request to add or change the operations role used by an environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateEnvironmentOperationsRoleInput {
    /// <p>The name of the environment to which to set the operations role.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role.</p>
    pub operations_role: std::option::Option<std::string::String>,
}
impl AssociateEnvironmentOperationsRoleInput {
    /// <p>The name of the environment to which to set the operations role.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role.</p>
    pub fn operations_role(&self) -> std::option::Option<&str> {
        self.operations_role.as_deref()
    }
}
impl std::fmt::Debug for AssociateEnvironmentOperationsRoleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateEnvironmentOperationsRoleInput");
        formatter.field("environment_name", &self.environment_name);
        formatter.field("operations_role", &self.operations_role);
        formatter.finish()
    }
}

/// <p>Request to execute a scheduled managed action immediately.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplyEnvironmentManagedActionInput {
    /// <p>The name of the target environment.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The environment ID of the target environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The action ID of the scheduled managed action to execute.</p>
    pub action_id: std::option::Option<std::string::String>,
}
impl ApplyEnvironmentManagedActionInput {
    /// <p>The name of the target environment.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The environment ID of the target environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The action ID of the scheduled managed action to execute.</p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
}
impl std::fmt::Debug for ApplyEnvironmentManagedActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplyEnvironmentManagedActionInput");
        formatter.field("environment_name", &self.environment_name);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("action_id", &self.action_id);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortEnvironmentUpdateInput {
    /// <p>This specifies the ID of the environment with the in-progress update that you want to cancel.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>This specifies the name of the environment with the in-progress update that you want to cancel.</p>
    pub environment_name: std::option::Option<std::string::String>,
}
impl AbortEnvironmentUpdateInput {
    /// <p>This specifies the ID of the environment with the in-progress update that you want to cancel.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>This specifies the name of the environment with the in-progress update that you want to cancel.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
}
impl std::fmt::Debug for AbortEnvironmentUpdateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortEnvironmentUpdateInput");
        formatter.field("environment_id", &self.environment_id);
        formatter.field("environment_name", &self.environment_name);
        formatter.finish()
    }
}
