// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AbortEnvironmentUpdate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`abort_environment_update`](crate::client::Client::abort_environment_update).
///
/// See [`crate::client::fluent_builders::AbortEnvironmentUpdate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AbortEnvironmentUpdate {
    _private: (),
}
impl AbortEnvironmentUpdate {
    /// Creates a new builder-style object to manufacture [`AbortEnvironmentUpdateInput`](crate::input::AbortEnvironmentUpdateInput)
    pub fn builder() -> crate::input::abort_environment_update_input::Builder {
        crate::input::abort_environment_update_input::Builder::default()
    }
    /// Creates a new `AbortEnvironmentUpdate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AbortEnvironmentUpdate {
    type Output = std::result::Result<
        crate::output::AbortEnvironmentUpdateOutput,
        crate::error::AbortEnvironmentUpdateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_abort_environment_update_error(response)
        } else {
            crate::operation_deser::parse_abort_environment_update_response(response)
        }
    }
}

/// Operation shape for `ApplyEnvironmentManagedAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`apply_environment_managed_action`](crate::client::Client::apply_environment_managed_action).
///
/// See [`crate::client::fluent_builders::ApplyEnvironmentManagedAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ApplyEnvironmentManagedAction {
    _private: (),
}
impl ApplyEnvironmentManagedAction {
    /// Creates a new builder-style object to manufacture [`ApplyEnvironmentManagedActionInput`](crate::input::ApplyEnvironmentManagedActionInput)
    pub fn builder() -> crate::input::apply_environment_managed_action_input::Builder {
        crate::input::apply_environment_managed_action_input::Builder::default()
    }
    /// Creates a new `ApplyEnvironmentManagedAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ApplyEnvironmentManagedAction {
    type Output = std::result::Result<
        crate::output::ApplyEnvironmentManagedActionOutput,
        crate::error::ApplyEnvironmentManagedActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_apply_environment_managed_action_error(response)
        } else {
            crate::operation_deser::parse_apply_environment_managed_action_response(response)
        }
    }
}

/// Operation shape for `AssociateEnvironmentOperationsRole`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_environment_operations_role`](crate::client::Client::associate_environment_operations_role).
///
/// See [`crate::client::fluent_builders::AssociateEnvironmentOperationsRole`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateEnvironmentOperationsRole {
    _private: (),
}
impl AssociateEnvironmentOperationsRole {
    /// Creates a new builder-style object to manufacture [`AssociateEnvironmentOperationsRoleInput`](crate::input::AssociateEnvironmentOperationsRoleInput)
    pub fn builder() -> crate::input::associate_environment_operations_role_input::Builder {
        crate::input::associate_environment_operations_role_input::Builder::default()
    }
    /// Creates a new `AssociateEnvironmentOperationsRole` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateEnvironmentOperationsRole {
    type Output = std::result::Result<
        crate::output::AssociateEnvironmentOperationsRoleOutput,
        crate::error::AssociateEnvironmentOperationsRoleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_environment_operations_role_error(response)
        } else {
            crate::operation_deser::parse_associate_environment_operations_role_response(response)
        }
    }
}

/// Operation shape for `CheckDNSAvailability`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`check_dns_availability`](crate::client::Client::check_dns_availability).
///
/// See [`crate::client::fluent_builders::CheckDNSAvailability`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CheckDNSAvailability {
    _private: (),
}
impl CheckDNSAvailability {
    /// Creates a new builder-style object to manufacture [`CheckDnsAvailabilityInput`](crate::input::CheckDnsAvailabilityInput)
    pub fn builder() -> crate::input::check_dns_availability_input::Builder {
        crate::input::check_dns_availability_input::Builder::default()
    }
    /// Creates a new `CheckDNSAvailability` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CheckDNSAvailability {
    type Output = std::result::Result<
        crate::output::CheckDnsAvailabilityOutput,
        crate::error::CheckDNSAvailabilityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_check_dns_availability_error(response)
        } else {
            crate::operation_deser::parse_check_dns_availability_response(response)
        }
    }
}

/// Operation shape for `ComposeEnvironments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`compose_environments`](crate::client::Client::compose_environments).
///
/// See [`crate::client::fluent_builders::ComposeEnvironments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ComposeEnvironments {
    _private: (),
}
impl ComposeEnvironments {
    /// Creates a new builder-style object to manufacture [`ComposeEnvironmentsInput`](crate::input::ComposeEnvironmentsInput)
    pub fn builder() -> crate::input::compose_environments_input::Builder {
        crate::input::compose_environments_input::Builder::default()
    }
    /// Creates a new `ComposeEnvironments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ComposeEnvironments {
    type Output = std::result::Result<
        crate::output::ComposeEnvironmentsOutput,
        crate::error::ComposeEnvironmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_compose_environments_error(response)
        } else {
            crate::operation_deser::parse_compose_environments_response(response)
        }
    }
}

/// Operation shape for `CreateApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_application`](crate::client::Client::create_application).
///
/// See [`crate::client::fluent_builders::CreateApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApplication {
    _private: (),
}
impl CreateApplication {
    /// Creates a new builder-style object to manufacture [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    pub fn builder() -> crate::input::create_application_input::Builder {
        crate::input::create_application_input::Builder::default()
    }
    /// Creates a new `CreateApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApplication {
    type Output = std::result::Result<
        crate::output::CreateApplicationOutput,
        crate::error::CreateApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_application_error(response)
        } else {
            crate::operation_deser::parse_create_application_response(response)
        }
    }
}

/// Operation shape for `CreateApplicationVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_application_version`](crate::client::Client::create_application_version).
///
/// See [`crate::client::fluent_builders::CreateApplicationVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApplicationVersion {
    _private: (),
}
impl CreateApplicationVersion {
    /// Creates a new builder-style object to manufacture [`CreateApplicationVersionInput`](crate::input::CreateApplicationVersionInput)
    pub fn builder() -> crate::input::create_application_version_input::Builder {
        crate::input::create_application_version_input::Builder::default()
    }
    /// Creates a new `CreateApplicationVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApplicationVersion {
    type Output = std::result::Result<
        crate::output::CreateApplicationVersionOutput,
        crate::error::CreateApplicationVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_application_version_error(response)
        } else {
            crate::operation_deser::parse_create_application_version_response(response)
        }
    }
}

/// Operation shape for `CreateConfigurationTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_configuration_template`](crate::client::Client::create_configuration_template).
///
/// See [`crate::client::fluent_builders::CreateConfigurationTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConfigurationTemplate {
    _private: (),
}
impl CreateConfigurationTemplate {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationTemplateInput`](crate::input::CreateConfigurationTemplateInput)
    pub fn builder() -> crate::input::create_configuration_template_input::Builder {
        crate::input::create_configuration_template_input::Builder::default()
    }
    /// Creates a new `CreateConfigurationTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConfigurationTemplate {
    type Output = std::result::Result<
        crate::output::CreateConfigurationTemplateOutput,
        crate::error::CreateConfigurationTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_configuration_template_error(response)
        } else {
            crate::operation_deser::parse_create_configuration_template_response(response)
        }
    }
}

/// Operation shape for `CreateEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_environment`](crate::client::Client::create_environment).
///
/// See [`crate::client::fluent_builders::CreateEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEnvironment {
    _private: (),
}
impl CreateEnvironment {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
    pub fn builder() -> crate::input::create_environment_input::Builder {
        crate::input::create_environment_input::Builder::default()
    }
    /// Creates a new `CreateEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEnvironment {
    type Output = std::result::Result<
        crate::output::CreateEnvironmentOutput,
        crate::error::CreateEnvironmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_environment_error(response)
        } else {
            crate::operation_deser::parse_create_environment_response(response)
        }
    }
}

/// Operation shape for `CreatePlatformVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_platform_version`](crate::client::Client::create_platform_version).
///
/// See [`crate::client::fluent_builders::CreatePlatformVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePlatformVersion {
    _private: (),
}
impl CreatePlatformVersion {
    /// Creates a new builder-style object to manufacture [`CreatePlatformVersionInput`](crate::input::CreatePlatformVersionInput)
    pub fn builder() -> crate::input::create_platform_version_input::Builder {
        crate::input::create_platform_version_input::Builder::default()
    }
    /// Creates a new `CreatePlatformVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePlatformVersion {
    type Output = std::result::Result<
        crate::output::CreatePlatformVersionOutput,
        crate::error::CreatePlatformVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_platform_version_error(response)
        } else {
            crate::operation_deser::parse_create_platform_version_response(response)
        }
    }
}

/// Operation shape for `CreateStorageLocation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_storage_location`](crate::client::Client::create_storage_location).
///
/// See [`crate::client::fluent_builders::CreateStorageLocation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStorageLocation {
    _private: (),
}
impl CreateStorageLocation {
    /// Creates a new builder-style object to manufacture [`CreateStorageLocationInput`](crate::input::CreateStorageLocationInput)
    pub fn builder() -> crate::input::create_storage_location_input::Builder {
        crate::input::create_storage_location_input::Builder::default()
    }
    /// Creates a new `CreateStorageLocation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStorageLocation {
    type Output = std::result::Result<
        crate::output::CreateStorageLocationOutput,
        crate::error::CreateStorageLocationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_storage_location_error(response)
        } else {
            crate::operation_deser::parse_create_storage_location_response(response)
        }
    }
}

/// Operation shape for `DeleteApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_application`](crate::client::Client::delete_application).
///
/// See [`crate::client::fluent_builders::DeleteApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApplication {
    _private: (),
}
impl DeleteApplication {
    /// Creates a new builder-style object to manufacture [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    pub fn builder() -> crate::input::delete_application_input::Builder {
        crate::input::delete_application_input::Builder::default()
    }
    /// Creates a new `DeleteApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApplication {
    type Output = std::result::Result<
        crate::output::DeleteApplicationOutput,
        crate::error::DeleteApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_application_error(response)
        } else {
            crate::operation_deser::parse_delete_application_response(response)
        }
    }
}

/// Operation shape for `DeleteApplicationVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_application_version`](crate::client::Client::delete_application_version).
///
/// See [`crate::client::fluent_builders::DeleteApplicationVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApplicationVersion {
    _private: (),
}
impl DeleteApplicationVersion {
    /// Creates a new builder-style object to manufacture [`DeleteApplicationVersionInput`](crate::input::DeleteApplicationVersionInput)
    pub fn builder() -> crate::input::delete_application_version_input::Builder {
        crate::input::delete_application_version_input::Builder::default()
    }
    /// Creates a new `DeleteApplicationVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApplicationVersion {
    type Output = std::result::Result<
        crate::output::DeleteApplicationVersionOutput,
        crate::error::DeleteApplicationVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_application_version_error(response)
        } else {
            crate::operation_deser::parse_delete_application_version_response(response)
        }
    }
}

/// Operation shape for `DeleteConfigurationTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_configuration_template`](crate::client::Client::delete_configuration_template).
///
/// See [`crate::client::fluent_builders::DeleteConfigurationTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConfigurationTemplate {
    _private: (),
}
impl DeleteConfigurationTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationTemplateInput`](crate::input::DeleteConfigurationTemplateInput)
    pub fn builder() -> crate::input::delete_configuration_template_input::Builder {
        crate::input::delete_configuration_template_input::Builder::default()
    }
    /// Creates a new `DeleteConfigurationTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConfigurationTemplate {
    type Output = std::result::Result<
        crate::output::DeleteConfigurationTemplateOutput,
        crate::error::DeleteConfigurationTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_configuration_template_error(response)
        } else {
            crate::operation_deser::parse_delete_configuration_template_response(response)
        }
    }
}

/// Operation shape for `DeleteEnvironmentConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_environment_configuration`](crate::client::Client::delete_environment_configuration).
///
/// See [`crate::client::fluent_builders::DeleteEnvironmentConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEnvironmentConfiguration {
    _private: (),
}
impl DeleteEnvironmentConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentConfigurationInput`](crate::input::DeleteEnvironmentConfigurationInput)
    pub fn builder() -> crate::input::delete_environment_configuration_input::Builder {
        crate::input::delete_environment_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteEnvironmentConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEnvironmentConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteEnvironmentConfigurationOutput,
        crate::error::DeleteEnvironmentConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_environment_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_environment_configuration_response(response)
        }
    }
}

/// Operation shape for `DeletePlatformVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_platform_version`](crate::client::Client::delete_platform_version).
///
/// See [`crate::client::fluent_builders::DeletePlatformVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePlatformVersion {
    _private: (),
}
impl DeletePlatformVersion {
    /// Creates a new builder-style object to manufacture [`DeletePlatformVersionInput`](crate::input::DeletePlatformVersionInput)
    pub fn builder() -> crate::input::delete_platform_version_input::Builder {
        crate::input::delete_platform_version_input::Builder::default()
    }
    /// Creates a new `DeletePlatformVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePlatformVersion {
    type Output = std::result::Result<
        crate::output::DeletePlatformVersionOutput,
        crate::error::DeletePlatformVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_platform_version_error(response)
        } else {
            crate::operation_deser::parse_delete_platform_version_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_attributes`](crate::client::Client::describe_account_attributes).
///
/// See [`crate::client::fluent_builders::DescribeAccountAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountAttributes {
    _private: (),
}
impl DescribeAccountAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    pub fn builder() -> crate::input::describe_account_attributes_input::Builder {
        crate::input::describe_account_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeAccountAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountAttributes {
    type Output = std::result::Result<
        crate::output::DescribeAccountAttributesOutput,
        crate::error::DescribeAccountAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_account_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeApplications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_applications`](crate::client::Client::describe_applications).
///
/// See [`crate::client::fluent_builders::DescribeApplications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeApplications {
    _private: (),
}
impl DescribeApplications {
    /// Creates a new builder-style object to manufacture [`DescribeApplicationsInput`](crate::input::DescribeApplicationsInput)
    pub fn builder() -> crate::input::describe_applications_input::Builder {
        crate::input::describe_applications_input::Builder::default()
    }
    /// Creates a new `DescribeApplications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeApplications {
    type Output = std::result::Result<
        crate::output::DescribeApplicationsOutput,
        crate::error::DescribeApplicationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_applications_error(response)
        } else {
            crate::operation_deser::parse_describe_applications_response(response)
        }
    }
}

/// Operation shape for `DescribeApplicationVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_application_versions`](crate::client::Client::describe_application_versions).
///
/// See [`crate::client::fluent_builders::DescribeApplicationVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeApplicationVersions {
    _private: (),
}
impl DescribeApplicationVersions {
    /// Creates a new builder-style object to manufacture [`DescribeApplicationVersionsInput`](crate::input::DescribeApplicationVersionsInput)
    pub fn builder() -> crate::input::describe_application_versions_input::Builder {
        crate::input::describe_application_versions_input::Builder::default()
    }
    /// Creates a new `DescribeApplicationVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeApplicationVersions {
    type Output = std::result::Result<
        crate::output::DescribeApplicationVersionsOutput,
        crate::error::DescribeApplicationVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_application_versions_error(response)
        } else {
            crate::operation_deser::parse_describe_application_versions_response(response)
        }
    }
}

/// Operation shape for `DescribeConfigurationOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_configuration_options`](crate::client::Client::describe_configuration_options).
///
/// See [`crate::client::fluent_builders::DescribeConfigurationOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConfigurationOptions {
    _private: (),
}
impl DescribeConfigurationOptions {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationOptionsInput`](crate::input::DescribeConfigurationOptionsInput)
    pub fn builder() -> crate::input::describe_configuration_options_input::Builder {
        crate::input::describe_configuration_options_input::Builder::default()
    }
    /// Creates a new `DescribeConfigurationOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConfigurationOptions {
    type Output = std::result::Result<
        crate::output::DescribeConfigurationOptionsOutput,
        crate::error::DescribeConfigurationOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_configuration_options_error(response)
        } else {
            crate::operation_deser::parse_describe_configuration_options_response(response)
        }
    }
}

/// Operation shape for `DescribeConfigurationSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_configuration_settings`](crate::client::Client::describe_configuration_settings).
///
/// See [`crate::client::fluent_builders::DescribeConfigurationSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConfigurationSettings {
    _private: (),
}
impl DescribeConfigurationSettings {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationSettingsInput`](crate::input::DescribeConfigurationSettingsInput)
    pub fn builder() -> crate::input::describe_configuration_settings_input::Builder {
        crate::input::describe_configuration_settings_input::Builder::default()
    }
    /// Creates a new `DescribeConfigurationSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConfigurationSettings {
    type Output = std::result::Result<
        crate::output::DescribeConfigurationSettingsOutput,
        crate::error::DescribeConfigurationSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_configuration_settings_error(response)
        } else {
            crate::operation_deser::parse_describe_configuration_settings_response(response)
        }
    }
}

/// Operation shape for `DescribeEnvironmentHealth`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_environment_health`](crate::client::Client::describe_environment_health).
///
/// See [`crate::client::fluent_builders::DescribeEnvironmentHealth`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEnvironmentHealth {
    _private: (),
}
impl DescribeEnvironmentHealth {
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentHealthInput`](crate::input::DescribeEnvironmentHealthInput)
    pub fn builder() -> crate::input::describe_environment_health_input::Builder {
        crate::input::describe_environment_health_input::Builder::default()
    }
    /// Creates a new `DescribeEnvironmentHealth` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEnvironmentHealth {
    type Output = std::result::Result<
        crate::output::DescribeEnvironmentHealthOutput,
        crate::error::DescribeEnvironmentHealthError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_environment_health_error(response)
        } else {
            crate::operation_deser::parse_describe_environment_health_response(response)
        }
    }
}

/// Operation shape for `DescribeEnvironmentManagedActionHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_environment_managed_action_history`](crate::client::Client::describe_environment_managed_action_history).
///
/// See [`crate::client::fluent_builders::DescribeEnvironmentManagedActionHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEnvironmentManagedActionHistory {
    _private: (),
}
impl DescribeEnvironmentManagedActionHistory {
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentManagedActionHistoryInput`](crate::input::DescribeEnvironmentManagedActionHistoryInput)
    pub fn builder() -> crate::input::describe_environment_managed_action_history_input::Builder {
        crate::input::describe_environment_managed_action_history_input::Builder::default()
    }
    /// Creates a new `DescribeEnvironmentManagedActionHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEnvironmentManagedActionHistory {
    type Output = std::result::Result<
        crate::output::DescribeEnvironmentManagedActionHistoryOutput,
        crate::error::DescribeEnvironmentManagedActionHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_environment_managed_action_history_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_environment_managed_action_history_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeEnvironmentManagedActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_environment_managed_actions`](crate::client::Client::describe_environment_managed_actions).
///
/// See [`crate::client::fluent_builders::DescribeEnvironmentManagedActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEnvironmentManagedActions {
    _private: (),
}
impl DescribeEnvironmentManagedActions {
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentManagedActionsInput`](crate::input::DescribeEnvironmentManagedActionsInput)
    pub fn builder() -> crate::input::describe_environment_managed_actions_input::Builder {
        crate::input::describe_environment_managed_actions_input::Builder::default()
    }
    /// Creates a new `DescribeEnvironmentManagedActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEnvironmentManagedActions {
    type Output = std::result::Result<
        crate::output::DescribeEnvironmentManagedActionsOutput,
        crate::error::DescribeEnvironmentManagedActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_environment_managed_actions_error(response)
        } else {
            crate::operation_deser::parse_describe_environment_managed_actions_response(response)
        }
    }
}

/// Operation shape for `DescribeEnvironmentResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_environment_resources`](crate::client::Client::describe_environment_resources).
///
/// See [`crate::client::fluent_builders::DescribeEnvironmentResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEnvironmentResources {
    _private: (),
}
impl DescribeEnvironmentResources {
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentResourcesInput`](crate::input::DescribeEnvironmentResourcesInput)
    pub fn builder() -> crate::input::describe_environment_resources_input::Builder {
        crate::input::describe_environment_resources_input::Builder::default()
    }
    /// Creates a new `DescribeEnvironmentResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEnvironmentResources {
    type Output = std::result::Result<
        crate::output::DescribeEnvironmentResourcesOutput,
        crate::error::DescribeEnvironmentResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_environment_resources_error(response)
        } else {
            crate::operation_deser::parse_describe_environment_resources_response(response)
        }
    }
}

/// Operation shape for `DescribeEnvironments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_environments`](crate::client::Client::describe_environments).
///
/// See [`crate::client::fluent_builders::DescribeEnvironments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEnvironments {
    _private: (),
}
impl DescribeEnvironments {
    /// Creates a new builder-style object to manufacture [`DescribeEnvironmentsInput`](crate::input::DescribeEnvironmentsInput)
    pub fn builder() -> crate::input::describe_environments_input::Builder {
        crate::input::describe_environments_input::Builder::default()
    }
    /// Creates a new `DescribeEnvironments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEnvironments {
    type Output = std::result::Result<
        crate::output::DescribeEnvironmentsOutput,
        crate::error::DescribeEnvironmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_environments_error(response)
        } else {
            crate::operation_deser::parse_describe_environments_response(response)
        }
    }
}

/// Operation shape for `DescribeEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_events`](crate::client::Client::describe_events).
///
/// See [`crate::client::fluent_builders::DescribeEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEvents {
    _private: (),
}
impl DescribeEvents {
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
    /// Creates a new `DescribeEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEvents {
    type Output =
        std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_events_error(response)
        } else {
            crate::operation_deser::parse_describe_events_response(response)
        }
    }
}

/// Operation shape for `DescribeInstancesHealth`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instances_health`](crate::client::Client::describe_instances_health).
///
/// See [`crate::client::fluent_builders::DescribeInstancesHealth`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstancesHealth {
    _private: (),
}
impl DescribeInstancesHealth {
    /// Creates a new builder-style object to manufacture [`DescribeInstancesHealthInput`](crate::input::DescribeInstancesHealthInput)
    pub fn builder() -> crate::input::describe_instances_health_input::Builder {
        crate::input::describe_instances_health_input::Builder::default()
    }
    /// Creates a new `DescribeInstancesHealth` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstancesHealth {
    type Output = std::result::Result<
        crate::output::DescribeInstancesHealthOutput,
        crate::error::DescribeInstancesHealthError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instances_health_error(response)
        } else {
            crate::operation_deser::parse_describe_instances_health_response(response)
        }
    }
}

/// Operation shape for `DescribePlatformVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_platform_version`](crate::client::Client::describe_platform_version).
///
/// See [`crate::client::fluent_builders::DescribePlatformVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePlatformVersion {
    _private: (),
}
impl DescribePlatformVersion {
    /// Creates a new builder-style object to manufacture [`DescribePlatformVersionInput`](crate::input::DescribePlatformVersionInput)
    pub fn builder() -> crate::input::describe_platform_version_input::Builder {
        crate::input::describe_platform_version_input::Builder::default()
    }
    /// Creates a new `DescribePlatformVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePlatformVersion {
    type Output = std::result::Result<
        crate::output::DescribePlatformVersionOutput,
        crate::error::DescribePlatformVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_platform_version_error(response)
        } else {
            crate::operation_deser::parse_describe_platform_version_response(response)
        }
    }
}

/// Operation shape for `DisassociateEnvironmentOperationsRole`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_environment_operations_role`](crate::client::Client::disassociate_environment_operations_role).
///
/// See [`crate::client::fluent_builders::DisassociateEnvironmentOperationsRole`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateEnvironmentOperationsRole {
    _private: (),
}
impl DisassociateEnvironmentOperationsRole {
    /// Creates a new builder-style object to manufacture [`DisassociateEnvironmentOperationsRoleInput`](crate::input::DisassociateEnvironmentOperationsRoleInput)
    pub fn builder() -> crate::input::disassociate_environment_operations_role_input::Builder {
        crate::input::disassociate_environment_operations_role_input::Builder::default()
    }
    /// Creates a new `DisassociateEnvironmentOperationsRole` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateEnvironmentOperationsRole {
    type Output = std::result::Result<
        crate::output::DisassociateEnvironmentOperationsRoleOutput,
        crate::error::DisassociateEnvironmentOperationsRoleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_environment_operations_role_error(response)
        } else {
            crate::operation_deser::parse_disassociate_environment_operations_role_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListAvailableSolutionStacks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_available_solution_stacks`](crate::client::Client::list_available_solution_stacks).
///
/// See [`crate::client::fluent_builders::ListAvailableSolutionStacks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAvailableSolutionStacks {
    _private: (),
}
impl ListAvailableSolutionStacks {
    /// Creates a new builder-style object to manufacture [`ListAvailableSolutionStacksInput`](crate::input::ListAvailableSolutionStacksInput)
    pub fn builder() -> crate::input::list_available_solution_stacks_input::Builder {
        crate::input::list_available_solution_stacks_input::Builder::default()
    }
    /// Creates a new `ListAvailableSolutionStacks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAvailableSolutionStacks {
    type Output = std::result::Result<
        crate::output::ListAvailableSolutionStacksOutput,
        crate::error::ListAvailableSolutionStacksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_available_solution_stacks_error(response)
        } else {
            crate::operation_deser::parse_list_available_solution_stacks_response(response)
        }
    }
}

/// Operation shape for `ListPlatformBranches`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_platform_branches`](crate::client::Client::list_platform_branches).
///
/// See [`crate::client::fluent_builders::ListPlatformBranches`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPlatformBranches {
    _private: (),
}
impl ListPlatformBranches {
    /// Creates a new builder-style object to manufacture [`ListPlatformBranchesInput`](crate::input::ListPlatformBranchesInput)
    pub fn builder() -> crate::input::list_platform_branches_input::Builder {
        crate::input::list_platform_branches_input::Builder::default()
    }
    /// Creates a new `ListPlatformBranches` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPlatformBranches {
    type Output = std::result::Result<
        crate::output::ListPlatformBranchesOutput,
        crate::error::ListPlatformBranchesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_platform_branches_error(response)
        } else {
            crate::operation_deser::parse_list_platform_branches_response(response)
        }
    }
}

/// Operation shape for `ListPlatformVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_platform_versions`](crate::client::Client::list_platform_versions).
///
/// See [`crate::client::fluent_builders::ListPlatformVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPlatformVersions {
    _private: (),
}
impl ListPlatformVersions {
    /// Creates a new builder-style object to manufacture [`ListPlatformVersionsInput`](crate::input::ListPlatformVersionsInput)
    pub fn builder() -> crate::input::list_platform_versions_input::Builder {
        crate::input::list_platform_versions_input::Builder::default()
    }
    /// Creates a new `ListPlatformVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPlatformVersions {
    type Output = std::result::Result<
        crate::output::ListPlatformVersionsOutput,
        crate::error::ListPlatformVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_platform_versions_error(response)
        } else {
            crate::operation_deser::parse_list_platform_versions_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `RebuildEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`rebuild_environment`](crate::client::Client::rebuild_environment).
///
/// See [`crate::client::fluent_builders::RebuildEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RebuildEnvironment {
    _private: (),
}
impl RebuildEnvironment {
    /// Creates a new builder-style object to manufacture [`RebuildEnvironmentInput`](crate::input::RebuildEnvironmentInput)
    pub fn builder() -> crate::input::rebuild_environment_input::Builder {
        crate::input::rebuild_environment_input::Builder::default()
    }
    /// Creates a new `RebuildEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RebuildEnvironment {
    type Output = std::result::Result<
        crate::output::RebuildEnvironmentOutput,
        crate::error::RebuildEnvironmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_rebuild_environment_error(response)
        } else {
            crate::operation_deser::parse_rebuild_environment_response(response)
        }
    }
}

/// Operation shape for `RequestEnvironmentInfo`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`request_environment_info`](crate::client::Client::request_environment_info).
///
/// See [`crate::client::fluent_builders::RequestEnvironmentInfo`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RequestEnvironmentInfo {
    _private: (),
}
impl RequestEnvironmentInfo {
    /// Creates a new builder-style object to manufacture [`RequestEnvironmentInfoInput`](crate::input::RequestEnvironmentInfoInput)
    pub fn builder() -> crate::input::request_environment_info_input::Builder {
        crate::input::request_environment_info_input::Builder::default()
    }
    /// Creates a new `RequestEnvironmentInfo` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RequestEnvironmentInfo {
    type Output = std::result::Result<
        crate::output::RequestEnvironmentInfoOutput,
        crate::error::RequestEnvironmentInfoError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_request_environment_info_error(response)
        } else {
            crate::operation_deser::parse_request_environment_info_response(response)
        }
    }
}

/// Operation shape for `RestartAppServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restart_app_server`](crate::client::Client::restart_app_server).
///
/// See [`crate::client::fluent_builders::RestartAppServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestartAppServer {
    _private: (),
}
impl RestartAppServer {
    /// Creates a new builder-style object to manufacture [`RestartAppServerInput`](crate::input::RestartAppServerInput)
    pub fn builder() -> crate::input::restart_app_server_input::Builder {
        crate::input::restart_app_server_input::Builder::default()
    }
    /// Creates a new `RestartAppServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestartAppServer {
    type Output = std::result::Result<
        crate::output::RestartAppServerOutput,
        crate::error::RestartAppServerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restart_app_server_error(response)
        } else {
            crate::operation_deser::parse_restart_app_server_response(response)
        }
    }
}

/// Operation shape for `RetrieveEnvironmentInfo`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`retrieve_environment_info`](crate::client::Client::retrieve_environment_info).
///
/// See [`crate::client::fluent_builders::RetrieveEnvironmentInfo`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RetrieveEnvironmentInfo {
    _private: (),
}
impl RetrieveEnvironmentInfo {
    /// Creates a new builder-style object to manufacture [`RetrieveEnvironmentInfoInput`](crate::input::RetrieveEnvironmentInfoInput)
    pub fn builder() -> crate::input::retrieve_environment_info_input::Builder {
        crate::input::retrieve_environment_info_input::Builder::default()
    }
    /// Creates a new `RetrieveEnvironmentInfo` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RetrieveEnvironmentInfo {
    type Output = std::result::Result<
        crate::output::RetrieveEnvironmentInfoOutput,
        crate::error::RetrieveEnvironmentInfoError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_retrieve_environment_info_error(response)
        } else {
            crate::operation_deser::parse_retrieve_environment_info_response(response)
        }
    }
}

/// Operation shape for `SwapEnvironmentCNAMEs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`swap_environment_cnam_es`](crate::client::Client::swap_environment_cnam_es).
///
/// See [`crate::client::fluent_builders::SwapEnvironmentCNAMEs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SwapEnvironmentCNAMEs {
    _private: (),
}
impl SwapEnvironmentCNAMEs {
    /// Creates a new builder-style object to manufacture [`SwapEnvironmentCnamEsInput`](crate::input::SwapEnvironmentCnamEsInput)
    pub fn builder() -> crate::input::swap_environment_cnam_es_input::Builder {
        crate::input::swap_environment_cnam_es_input::Builder::default()
    }
    /// Creates a new `SwapEnvironmentCNAMEs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SwapEnvironmentCNAMEs {
    type Output = std::result::Result<
        crate::output::SwapEnvironmentCnamEsOutput,
        crate::error::SwapEnvironmentCNAMEsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_swap_environment_cnam_es_error(response)
        } else {
            crate::operation_deser::parse_swap_environment_cnam_es_response(response)
        }
    }
}

/// Operation shape for `TerminateEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`terminate_environment`](crate::client::Client::terminate_environment).
///
/// See [`crate::client::fluent_builders::TerminateEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TerminateEnvironment {
    _private: (),
}
impl TerminateEnvironment {
    /// Creates a new builder-style object to manufacture [`TerminateEnvironmentInput`](crate::input::TerminateEnvironmentInput)
    pub fn builder() -> crate::input::terminate_environment_input::Builder {
        crate::input::terminate_environment_input::Builder::default()
    }
    /// Creates a new `TerminateEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TerminateEnvironment {
    type Output = std::result::Result<
        crate::output::TerminateEnvironmentOutput,
        crate::error::TerminateEnvironmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_terminate_environment_error(response)
        } else {
            crate::operation_deser::parse_terminate_environment_response(response)
        }
    }
}

/// Operation shape for `UpdateApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_application`](crate::client::Client::update_application).
///
/// See [`crate::client::fluent_builders::UpdateApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApplication {
    _private: (),
}
impl UpdateApplication {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    pub fn builder() -> crate::input::update_application_input::Builder {
        crate::input::update_application_input::Builder::default()
    }
    /// Creates a new `UpdateApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApplication {
    type Output = std::result::Result<
        crate::output::UpdateApplicationOutput,
        crate::error::UpdateApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_application_error(response)
        } else {
            crate::operation_deser::parse_update_application_response(response)
        }
    }
}

/// Operation shape for `UpdateApplicationResourceLifecycle`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_application_resource_lifecycle`](crate::client::Client::update_application_resource_lifecycle).
///
/// See [`crate::client::fluent_builders::UpdateApplicationResourceLifecycle`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApplicationResourceLifecycle {
    _private: (),
}
impl UpdateApplicationResourceLifecycle {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationResourceLifecycleInput`](crate::input::UpdateApplicationResourceLifecycleInput)
    pub fn builder() -> crate::input::update_application_resource_lifecycle_input::Builder {
        crate::input::update_application_resource_lifecycle_input::Builder::default()
    }
    /// Creates a new `UpdateApplicationResourceLifecycle` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApplicationResourceLifecycle {
    type Output = std::result::Result<
        crate::output::UpdateApplicationResourceLifecycleOutput,
        crate::error::UpdateApplicationResourceLifecycleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_application_resource_lifecycle_error(response)
        } else {
            crate::operation_deser::parse_update_application_resource_lifecycle_response(response)
        }
    }
}

/// Operation shape for `UpdateApplicationVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_application_version`](crate::client::Client::update_application_version).
///
/// See [`crate::client::fluent_builders::UpdateApplicationVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApplicationVersion {
    _private: (),
}
impl UpdateApplicationVersion {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationVersionInput`](crate::input::UpdateApplicationVersionInput)
    pub fn builder() -> crate::input::update_application_version_input::Builder {
        crate::input::update_application_version_input::Builder::default()
    }
    /// Creates a new `UpdateApplicationVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApplicationVersion {
    type Output = std::result::Result<
        crate::output::UpdateApplicationVersionOutput,
        crate::error::UpdateApplicationVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_application_version_error(response)
        } else {
            crate::operation_deser::parse_update_application_version_response(response)
        }
    }
}

/// Operation shape for `UpdateConfigurationTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_configuration_template`](crate::client::Client::update_configuration_template).
///
/// See [`crate::client::fluent_builders::UpdateConfigurationTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConfigurationTemplate {
    _private: (),
}
impl UpdateConfigurationTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationTemplateInput`](crate::input::UpdateConfigurationTemplateInput)
    pub fn builder() -> crate::input::update_configuration_template_input::Builder {
        crate::input::update_configuration_template_input::Builder::default()
    }
    /// Creates a new `UpdateConfigurationTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConfigurationTemplate {
    type Output = std::result::Result<
        crate::output::UpdateConfigurationTemplateOutput,
        crate::error::UpdateConfigurationTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_configuration_template_error(response)
        } else {
            crate::operation_deser::parse_update_configuration_template_response(response)
        }
    }
}

/// Operation shape for `UpdateEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_environment`](crate::client::Client::update_environment).
///
/// See [`crate::client::fluent_builders::UpdateEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEnvironment {
    _private: (),
}
impl UpdateEnvironment {
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
    pub fn builder() -> crate::input::update_environment_input::Builder {
        crate::input::update_environment_input::Builder::default()
    }
    /// Creates a new `UpdateEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEnvironment {
    type Output = std::result::Result<
        crate::output::UpdateEnvironmentOutput,
        crate::error::UpdateEnvironmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_environment_error(response)
        } else {
            crate::operation_deser::parse_update_environment_response(response)
        }
    }
}

/// Operation shape for `UpdateTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_tags_for_resource`](crate::client::Client::update_tags_for_resource).
///
/// See [`crate::client::fluent_builders::UpdateTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTagsForResource {
    _private: (),
}
impl UpdateTagsForResource {
    /// Creates a new builder-style object to manufacture [`UpdateTagsForResourceInput`](crate::input::UpdateTagsForResourceInput)
    pub fn builder() -> crate::input::update_tags_for_resource_input::Builder {
        crate::input::update_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `UpdateTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTagsForResource {
    type Output = std::result::Result<
        crate::output::UpdateTagsForResourceOutput,
        crate::error::UpdateTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_update_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ValidateConfigurationSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`validate_configuration_settings`](crate::client::Client::validate_configuration_settings).
///
/// See [`crate::client::fluent_builders::ValidateConfigurationSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ValidateConfigurationSettings {
    _private: (),
}
impl ValidateConfigurationSettings {
    /// Creates a new builder-style object to manufacture [`ValidateConfigurationSettingsInput`](crate::input::ValidateConfigurationSettingsInput)
    pub fn builder() -> crate::input::validate_configuration_settings_input::Builder {
        crate::input::validate_configuration_settings_input::Builder::default()
    }
    /// Creates a new `ValidateConfigurationSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ValidateConfigurationSettings {
    type Output = std::result::Result<
        crate::output::ValidateConfigurationSettingsOutput,
        crate::error::ValidateConfigurationSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_validate_configuration_settings_error(response)
        } else {
            crate::operation_deser::parse_validate_configuration_settings_response(response)
        }
    }
}
