// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An error or warning for a desired configuration option value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationMessage {
    /// <p>A message describing the error or warning.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>An indication of the severity of this message:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>error</code>: This message indicates that this is not a valid setting for an
    /// option.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>warning</code>: This message is providing information you should take into
    /// account.</p>
    /// </li>
    /// </ul>
    pub severity: std::option::Option<crate::model::ValidationSeverity>,
    /// <p>The namespace to which the option belongs.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The name of the option.</p>
    pub option_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationMessage");
        formatter.field("message", &self.message);
        formatter.field("severity", &self.severity);
        formatter.field("namespace", &self.namespace);
        formatter.field("option_name", &self.option_name);
        formatter.finish()
    }
}
/// See [`ValidationMessage`](crate::model::ValidationMessage)
pub mod validation_message {
    /// A builder for [`ValidationMessage`](crate::model::ValidationMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::ValidationSeverity>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) option_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the error or warning.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the error or warning.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>An indication of the severity of this message:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>error</code>: This message indicates that this is not a valid setting for an
        /// option.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>warning</code>: This message is providing information you should take into
        /// account.</p>
        /// </li>
        /// </ul>
        pub fn severity(mut self, input: crate::model::ValidationSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>An indication of the severity of this message:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>error</code>: This message indicates that this is not a valid setting for an
        /// option.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>warning</code>: This message is providing information you should take into
        /// account.</p>
        /// </li>
        /// </ul>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::ValidationSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>The namespace to which the option belongs.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace to which the option belongs.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The name of the option.</p>
        pub fn option_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_name = Some(input.into());
            self
        }
        /// <p>The name of the option.</p>
        pub fn set_option_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.option_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationMessage`](crate::model::ValidationMessage)
        pub fn build(self) -> crate::model::ValidationMessage {
            crate::model::ValidationMessage {
                message: self.message,
                severity: self.severity,
                namespace: self.namespace,
                option_name: self.option_name,
            }
        }
    }
}
impl ValidationMessage {
    /// Creates a new builder-style object to manufacture [`ValidationMessage`](crate::model::ValidationMessage)
    pub fn builder() -> crate::model::validation_message::Builder {
        crate::model::validation_message::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationSeverity {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Warning,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationSeverity {
    fn from(s: &str) -> Self {
        match s {
            "error" => ValidationSeverity::Error,
            "warning" => ValidationSeverity::Warning,
            other => ValidationSeverity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationSeverity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationSeverity::from(s))
    }
}
impl ValidationSeverity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationSeverity::Error => "error",
            ValidationSeverity::Warning => "warning",
            ValidationSeverity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["error", "warning"]
    }
}
impl AsRef<str> for ValidationSeverity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A specification identifying an individual configuration option along with its current
/// value. For a list of possible namespaces and option values, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html">Option Values</a> in the
/// <i>AWS Elastic Beanstalk Developer Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationOptionSetting {
    /// <p>A unique resource name for the option setting. Use it for a time–based scaling configuration option.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>A unique namespace that identifies the option's associated AWS resource.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The name of the configuration option.</p>
    pub option_name: std::option::Option<std::string::String>,
    /// <p>The current value for the configuration option.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConfigurationOptionSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationOptionSetting");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("namespace", &self.namespace);
        formatter.field("option_name", &self.option_name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ConfigurationOptionSetting`](crate::model::ConfigurationOptionSetting)
pub mod configuration_option_setting {
    /// A builder for [`ConfigurationOptionSetting`](crate::model::ConfigurationOptionSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) option_name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique resource name for the option setting. Use it for a time–based scaling configuration option.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>A unique resource name for the option setting. Use it for a time–based scaling configuration option.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>A unique namespace that identifies the option's associated AWS resource.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>A unique namespace that identifies the option's associated AWS resource.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The name of the configuration option.</p>
        pub fn option_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration option.</p>
        pub fn set_option_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.option_name = input;
            self
        }
        /// <p>The current value for the configuration option.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The current value for the configuration option.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationOptionSetting`](crate::model::ConfigurationOptionSetting)
        pub fn build(self) -> crate::model::ConfigurationOptionSetting {
            crate::model::ConfigurationOptionSetting {
                resource_name: self.resource_name,
                namespace: self.namespace,
                option_name: self.option_name,
                value: self.value,
            }
        }
    }
}
impl ConfigurationOptionSetting {
    /// Creates a new builder-style object to manufacture [`ConfigurationOptionSetting`](crate::model::ConfigurationOptionSetting)
    pub fn builder() -> crate::model::configuration_option_setting::Builder {
        crate::model::configuration_option_setting::Builder::default()
    }
}

/// <p>Describes a tag applied to a resource in an environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>A link to another environment, defined in the environment's manifest. Links provide
/// connection information in system properties that can be used to connect to another environment
/// in the same group. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest
/// (env.yaml)</a> for details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentLink {
    /// <p>The name of the link.</p>
    pub link_name: std::option::Option<std::string::String>,
    /// <p>The name of the linked environment (the dependency).</p>
    pub environment_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EnvironmentLink {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentLink");
        formatter.field("link_name", &self.link_name);
        formatter.field("environment_name", &self.environment_name);
        formatter.finish()
    }
}
/// See [`EnvironmentLink`](crate::model::EnvironmentLink)
pub mod environment_link {
    /// A builder for [`EnvironmentLink`](crate::model::EnvironmentLink)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) link_name: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the link.</p>
        pub fn link_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_name = Some(input.into());
            self
        }
        /// <p>The name of the link.</p>
        pub fn set_link_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_name = input;
            self
        }
        /// <p>The name of the linked environment (the dependency).</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the linked environment (the dependency).</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentLink`](crate::model::EnvironmentLink)
        pub fn build(self) -> crate::model::EnvironmentLink {
            crate::model::EnvironmentLink {
                link_name: self.link_name,
                environment_name: self.environment_name,
            }
        }
    }
}
impl EnvironmentLink {
    /// Creates a new builder-style object to manufacture [`EnvironmentLink`](crate::model::EnvironmentLink)
    pub fn builder() -> crate::model::environment_link::Builder {
        crate::model::environment_link::Builder::default()
    }
}

/// <p>Describes the properties of an environment tier</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentTier {
    /// <p>The name of this environment tier.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li>
    /// <p>For <i>Web server tier</i> – <code>WebServer</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For <i>Worker tier</i> – <code>Worker</code>
    /// </p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of this environment tier.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li>
    /// <p>For <i>Web server tier</i> – <code>Standard</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For <i>Worker tier</i> – <code>SQS/HTTP</code>
    /// </p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The version of this environment tier. When you don't set a value to it, Elastic Beanstalk uses the
    /// latest compatible worker tier version.</p>
    /// <note>
    /// <p>This member is deprecated. Any specific version that you set may become out of date.
    /// We recommend leaving it unspecified.</p>
    /// </note>
    pub version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EnvironmentTier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentTier");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`EnvironmentTier`](crate::model::EnvironmentTier)
pub mod environment_tier {
    /// A builder for [`EnvironmentTier`](crate::model::EnvironmentTier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of this environment tier.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>For <i>Web server tier</i> – <code>WebServer</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For <i>Worker tier</i> – <code>Worker</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of this environment tier.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>For <i>Web server tier</i> – <code>WebServer</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For <i>Worker tier</i> – <code>Worker</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of this environment tier.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>For <i>Web server tier</i> – <code>Standard</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For <i>Worker tier</i> – <code>SQS/HTTP</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of this environment tier.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>For <i>Web server tier</i> – <code>Standard</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For <i>Worker tier</i> – <code>SQS/HTTP</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The version of this environment tier. When you don't set a value to it, Elastic Beanstalk uses the
        /// latest compatible worker tier version.</p>
        /// <note>
        /// <p>This member is deprecated. Any specific version that you set may become out of date.
        /// We recommend leaving it unspecified.</p>
        /// </note>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of this environment tier. When you don't set a value to it, Elastic Beanstalk uses the
        /// latest compatible worker tier version.</p>
        /// <note>
        /// <p>This member is deprecated. Any specific version that you set may become out of date.
        /// We recommend leaving it unspecified.</p>
        /// </note>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentTier`](crate::model::EnvironmentTier)
        pub fn build(self) -> crate::model::EnvironmentTier {
            crate::model::EnvironmentTier {
                name: self.name,
                r#type: self.r#type,
                version: self.version,
            }
        }
    }
}
impl EnvironmentTier {
    /// Creates a new builder-style object to manufacture [`EnvironmentTier`](crate::model::EnvironmentTier)
    pub fn builder() -> crate::model::environment_tier::Builder {
        crate::model::environment_tier::Builder::default()
    }
}

/// <p>Describes the AWS resources in use by this environment. This data is not live
/// data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentResourcesDescription {
    /// <p>Describes the LoadBalancer.</p>
    pub load_balancer: std::option::Option<crate::model::LoadBalancerDescription>,
}
impl std::fmt::Debug for EnvironmentResourcesDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentResourcesDescription");
        formatter.field("load_balancer", &self.load_balancer);
        formatter.finish()
    }
}
/// See [`EnvironmentResourcesDescription`](crate::model::EnvironmentResourcesDescription)
pub mod environment_resources_description {
    /// A builder for [`EnvironmentResourcesDescription`](crate::model::EnvironmentResourcesDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer: std::option::Option<crate::model::LoadBalancerDescription>,
    }
    impl Builder {
        /// <p>Describes the LoadBalancer.</p>
        pub fn load_balancer(mut self, input: crate::model::LoadBalancerDescription) -> Self {
            self.load_balancer = Some(input);
            self
        }
        /// <p>Describes the LoadBalancer.</p>
        pub fn set_load_balancer(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerDescription>,
        ) -> Self {
            self.load_balancer = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentResourcesDescription`](crate::model::EnvironmentResourcesDescription)
        pub fn build(self) -> crate::model::EnvironmentResourcesDescription {
            crate::model::EnvironmentResourcesDescription {
                load_balancer: self.load_balancer,
            }
        }
    }
}
impl EnvironmentResourcesDescription {
    /// Creates a new builder-style object to manufacture [`EnvironmentResourcesDescription`](crate::model::EnvironmentResourcesDescription)
    pub fn builder() -> crate::model::environment_resources_description::Builder {
        crate::model::environment_resources_description::Builder::default()
    }
}

/// <p>Describes the details of a LoadBalancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancerDescription {
    /// <p>The name of the LoadBalancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The domain name of the LoadBalancer.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>A list of Listeners used by the LoadBalancer.</p>
    pub listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
}
impl std::fmt::Debug for LoadBalancerDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancerDescription");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("domain", &self.domain);
        formatter.field("listeners", &self.listeners);
        formatter.finish()
    }
}
/// See [`LoadBalancerDescription`](crate::model::LoadBalancerDescription)
pub mod load_balancer_description {
    /// A builder for [`LoadBalancerDescription`](crate::model::LoadBalancerDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) listeners: std::option::Option<std::vec::Vec<crate::model::Listener>>,
    }
    impl Builder {
        /// <p>The name of the LoadBalancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the LoadBalancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The domain name of the LoadBalancer.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain name of the LoadBalancer.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// Appends an item to `listeners`.
        ///
        /// To override the contents of this collection use [`set_listeners`](Self::set_listeners).
        ///
        /// <p>A list of Listeners used by the LoadBalancer.</p>
        pub fn listeners(mut self, input: impl Into<crate::model::Listener>) -> Self {
            let mut v = self.listeners.unwrap_or_default();
            v.push(input.into());
            self.listeners = Some(v);
            self
        }
        /// <p>A list of Listeners used by the LoadBalancer.</p>
        pub fn set_listeners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Listener>>,
        ) -> Self {
            self.listeners = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancerDescription`](crate::model::LoadBalancerDescription)
        pub fn build(self) -> crate::model::LoadBalancerDescription {
            crate::model::LoadBalancerDescription {
                load_balancer_name: self.load_balancer_name,
                domain: self.domain,
                listeners: self.listeners,
            }
        }
    }
}
impl LoadBalancerDescription {
    /// Creates a new builder-style object to manufacture [`LoadBalancerDescription`](crate::model::LoadBalancerDescription)
    pub fn builder() -> crate::model::load_balancer_description::Builder {
        crate::model::load_balancer_description::Builder::default()
    }
}

/// <p>Describes the properties of a Listener for the LoadBalancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Listener {
    /// <p>The protocol that is used by the Listener.</p>
    pub protocol: std::option::Option<std::string::String>,
    /// <p>The port that is used by the Listener.</p>
    pub port: i32,
}
impl std::fmt::Debug for Listener {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Listener");
        formatter.field("protocol", &self.protocol);
        formatter.field("port", &self.port);
        formatter.finish()
    }
}
/// See [`Listener`](crate::model::Listener)
pub mod listener {
    /// A builder for [`Listener`](crate::model::Listener)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) protocol: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The protocol that is used by the Listener.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The protocol that is used by the Listener.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The port that is used by the Listener.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port that is used by the Listener.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`Listener`](crate::model::Listener)
        pub fn build(self) -> crate::model::Listener {
            crate::model::Listener {
                protocol: self.protocol,
                port: self.port.unwrap_or_default(),
            }
        }
    }
}
impl Listener {
    /// Creates a new builder-style object to manufacture [`Listener`](crate::model::Listener)
    pub fn builder() -> crate::model::listener::Builder {
        crate::model::listener::Builder::default()
    }
}

/// _Note: `EnvironmentHealthStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnvironmentHealthStatus {
    #[allow(missing_docs)] // documentation missing in model
    Degraded,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    #[allow(missing_docs)] // documentation missing in model
    NoData,
    #[allow(missing_docs)] // documentation missing in model
    Ok,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Severe,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    #[allow(missing_docs)] // documentation missing in model
    Warning,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnvironmentHealthStatus {
    fn from(s: &str) -> Self {
        match s {
            "Degraded" => EnvironmentHealthStatus::Degraded,
            "Info" => EnvironmentHealthStatus::Info,
            "NoData" => EnvironmentHealthStatus::NoData,
            "Ok" => EnvironmentHealthStatus::Ok,
            "Pending" => EnvironmentHealthStatus::Pending,
            "Severe" => EnvironmentHealthStatus::Severe,
            "Suspended" => EnvironmentHealthStatus::Suspended,
            "Unknown" => EnvironmentHealthStatus::UnknownValue,
            "Warning" => EnvironmentHealthStatus::Warning,
            other => EnvironmentHealthStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnvironmentHealthStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnvironmentHealthStatus::from(s))
    }
}
impl EnvironmentHealthStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnvironmentHealthStatus::Degraded => "Degraded",
            EnvironmentHealthStatus::Info => "Info",
            EnvironmentHealthStatus::NoData => "NoData",
            EnvironmentHealthStatus::Ok => "Ok",
            EnvironmentHealthStatus::Pending => "Pending",
            EnvironmentHealthStatus::Severe => "Severe",
            EnvironmentHealthStatus::Suspended => "Suspended",
            EnvironmentHealthStatus::UnknownValue => "Unknown",
            EnvironmentHealthStatus::Warning => "Warning",
            EnvironmentHealthStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Degraded",
            "Info",
            "NoData",
            "Ok",
            "Pending",
            "Severe",
            "Suspended",
            "Unknown",
            "Warning",
        ]
    }
}
impl AsRef<str> for EnvironmentHealthStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnvironmentHealth {
    #[allow(missing_docs)] // documentation missing in model
    Green,
    #[allow(missing_docs)] // documentation missing in model
    Grey,
    #[allow(missing_docs)] // documentation missing in model
    Red,
    #[allow(missing_docs)] // documentation missing in model
    Yellow,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnvironmentHealth {
    fn from(s: &str) -> Self {
        match s {
            "Green" => EnvironmentHealth::Green,
            "Grey" => EnvironmentHealth::Grey,
            "Red" => EnvironmentHealth::Red,
            "Yellow" => EnvironmentHealth::Yellow,
            other => EnvironmentHealth::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnvironmentHealth {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnvironmentHealth::from(s))
    }
}
impl EnvironmentHealth {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnvironmentHealth::Green => "Green",
            EnvironmentHealth::Grey => "Grey",
            EnvironmentHealth::Red => "Red",
            EnvironmentHealth::Yellow => "Yellow",
            EnvironmentHealth::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Green", "Grey", "Red", "Yellow"]
    }
}
impl AsRef<str> for EnvironmentHealth {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnvironmentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Aborting,
    #[allow(missing_docs)] // documentation missing in model
    Launching,
    #[allow(missing_docs)] // documentation missing in model
    LinkingFrom,
    #[allow(missing_docs)] // documentation missing in model
    LinkingTo,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnvironmentStatus {
    fn from(s: &str) -> Self {
        match s {
            "Aborting" => EnvironmentStatus::Aborting,
            "Launching" => EnvironmentStatus::Launching,
            "LinkingFrom" => EnvironmentStatus::LinkingFrom,
            "LinkingTo" => EnvironmentStatus::LinkingTo,
            "Ready" => EnvironmentStatus::Ready,
            "Terminated" => EnvironmentStatus::Terminated,
            "Terminating" => EnvironmentStatus::Terminating,
            "Updating" => EnvironmentStatus::Updating,
            other => EnvironmentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnvironmentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnvironmentStatus::from(s))
    }
}
impl EnvironmentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnvironmentStatus::Aborting => "Aborting",
            EnvironmentStatus::Launching => "Launching",
            EnvironmentStatus::LinkingFrom => "LinkingFrom",
            EnvironmentStatus::LinkingTo => "LinkingTo",
            EnvironmentStatus::Ready => "Ready",
            EnvironmentStatus::Terminated => "Terminated",
            EnvironmentStatus::Terminating => "Terminating",
            EnvironmentStatus::Updating => "Updating",
            EnvironmentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Aborting",
            "Launching",
            "LinkingFrom",
            "LinkingTo",
            "Ready",
            "Terminated",
            "Terminating",
            "Updating",
        ]
    }
}
impl AsRef<str> for EnvironmentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A specification identifying an individual configuration option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionSpecification {
    /// <p>A unique resource name for a time-based scaling configuration option.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>A unique namespace identifying the option's associated AWS resource.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The name of the configuration option.</p>
    pub option_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OptionSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionSpecification");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("namespace", &self.namespace);
        formatter.field("option_name", &self.option_name);
        formatter.finish()
    }
}
/// See [`OptionSpecification`](crate::model::OptionSpecification)
pub mod option_specification {
    /// A builder for [`OptionSpecification`](crate::model::OptionSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) option_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique resource name for a time-based scaling configuration option.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>A unique resource name for a time-based scaling configuration option.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>A unique namespace identifying the option's associated AWS resource.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>A unique namespace identifying the option's associated AWS resource.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The name of the configuration option.</p>
        pub fn option_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration option.</p>
        pub fn set_option_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.option_name = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionSpecification`](crate::model::OptionSpecification)
        pub fn build(self) -> crate::model::OptionSpecification {
            crate::model::OptionSpecification {
                resource_name: self.resource_name,
                namespace: self.namespace,
                option_name: self.option_name,
            }
        }
    }
}
impl OptionSpecification {
    /// Creates a new builder-style object to manufacture [`OptionSpecification`](crate::model::OptionSpecification)
    pub fn builder() -> crate::model::option_specification::Builder {
        crate::model::option_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigurationDeploymentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deployed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigurationDeploymentStatus {
    fn from(s: &str) -> Self {
        match s {
            "deployed" => ConfigurationDeploymentStatus::Deployed,
            "failed" => ConfigurationDeploymentStatus::Failed,
            "pending" => ConfigurationDeploymentStatus::Pending,
            other => ConfigurationDeploymentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigurationDeploymentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigurationDeploymentStatus::from(s))
    }
}
impl ConfigurationDeploymentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigurationDeploymentStatus::Deployed => "deployed",
            ConfigurationDeploymentStatus::Failed => "failed",
            ConfigurationDeploymentStatus::Pending => "pending",
            ConfigurationDeploymentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["deployed", "failed", "pending"]
    }
}
impl AsRef<str> for ConfigurationDeploymentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the properties of an application version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationVersionDescription {
    /// <p>The Amazon Resource Name (ARN) of the application version.</p>
    pub application_version_arn: std::option::Option<std::string::String>,
    /// <p>The name of the application to which the application version belongs.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The description of the application version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the application version.</p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p>If the version's source code was retrieved from AWS CodeCommit, the location of the
    /// source code for the application version.</p>
    pub source_build_information: std::option::Option<crate::model::SourceBuildInformation>,
    /// <p>Reference to the artifact from the AWS CodeBuild build.</p>
    pub build_arn: std::option::Option<std::string::String>,
    /// <p>The storage location of the application version's source bundle in Amazon S3.</p>
    pub source_bundle: std::option::Option<crate::model::S3Location>,
    /// <p>The creation date of the application version.</p>
    pub date_created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last modified date of the application version.</p>
    pub date_updated: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The processing status of the application version. Reflects the state of the application
    /// version during its creation. Many of the values are only applicable if you specified
    /// <code>True</code> for the <code>Process</code> parameter of the
    /// <code>CreateApplicationVersion</code> action. The following list describes the possible
    /// values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Unprocessed</code> – Application version wasn't pre-processed or validated.
    /// Elastic Beanstalk will validate configuration files during deployment of the application version to an
    /// environment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Processing</code> – Elastic Beanstalk is currently processing the application version.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Building</code> – Application version is currently undergoing an AWS CodeBuild build.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Processed</code> – Elastic Beanstalk was successfully pre-processed and validated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code> – Either the AWS CodeBuild build failed or configuration files didn't
    /// pass validation. This application version isn't usable.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ApplicationVersionStatus>,
}
impl std::fmt::Debug for ApplicationVersionDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationVersionDescription");
        formatter.field("application_version_arn", &self.application_version_arn);
        formatter.field("application_name", &self.application_name);
        formatter.field("description", &self.description);
        formatter.field("version_label", &self.version_label);
        formatter.field("source_build_information", &self.source_build_information);
        formatter.field("build_arn", &self.build_arn);
        formatter.field("source_bundle", &self.source_bundle);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ApplicationVersionDescription`](crate::model::ApplicationVersionDescription)
pub mod application_version_description {
    /// A builder for [`ApplicationVersionDescription`](crate::model::ApplicationVersionDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_version_arn: std::option::Option<std::string::String>,
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) source_build_information:
            std::option::Option<crate::model::SourceBuildInformation>,
        pub(crate) build_arn: std::option::Option<std::string::String>,
        pub(crate) source_bundle: std::option::Option<crate::model::S3Location>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) date_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::ApplicationVersionStatus>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application version.</p>
        pub fn application_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application version.</p>
        pub fn set_application_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_version_arn = input;
            self
        }
        /// <p>The name of the application to which the application version belongs.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application to which the application version belongs.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The description of the application version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A unique identifier for the application version.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>A unique identifier for the application version.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// <p>If the version's source code was retrieved from AWS CodeCommit, the location of the
        /// source code for the application version.</p>
        pub fn source_build_information(
            mut self,
            input: crate::model::SourceBuildInformation,
        ) -> Self {
            self.source_build_information = Some(input);
            self
        }
        /// <p>If the version's source code was retrieved from AWS CodeCommit, the location of the
        /// source code for the application version.</p>
        pub fn set_source_build_information(
            mut self,
            input: std::option::Option<crate::model::SourceBuildInformation>,
        ) -> Self {
            self.source_build_information = input;
            self
        }
        /// <p>Reference to the artifact from the AWS CodeBuild build.</p>
        pub fn build_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_arn = Some(input.into());
            self
        }
        /// <p>Reference to the artifact from the AWS CodeBuild build.</p>
        pub fn set_build_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_arn = input;
            self
        }
        /// <p>The storage location of the application version's source bundle in Amazon S3.</p>
        pub fn source_bundle(mut self, input: crate::model::S3Location) -> Self {
            self.source_bundle = Some(input);
            self
        }
        /// <p>The storage location of the application version's source bundle in Amazon S3.</p>
        pub fn set_source_bundle(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.source_bundle = input;
            self
        }
        /// <p>The creation date of the application version.</p>
        pub fn date_created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The creation date of the application version.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The last modified date of the application version.</p>
        pub fn date_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date_updated = Some(input);
            self
        }
        /// <p>The last modified date of the application version.</p>
        pub fn set_date_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.date_updated = input;
            self
        }
        /// <p>The processing status of the application version. Reflects the state of the application
        /// version during its creation. Many of the values are only applicable if you specified
        /// <code>True</code> for the <code>Process</code> parameter of the
        /// <code>CreateApplicationVersion</code> action. The following list describes the possible
        /// values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Unprocessed</code> – Application version wasn't pre-processed or validated.
        /// Elastic Beanstalk will validate configuration files during deployment of the application version to an
        /// environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Processing</code> – Elastic Beanstalk is currently processing the application version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Building</code> – Application version is currently undergoing an AWS CodeBuild build.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Processed</code> – Elastic Beanstalk was successfully pre-processed and validated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> – Either the AWS CodeBuild build failed or configuration files didn't
        /// pass validation. This application version isn't usable.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ApplicationVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The processing status of the application version. Reflects the state of the application
        /// version during its creation. Many of the values are only applicable if you specified
        /// <code>True</code> for the <code>Process</code> parameter of the
        /// <code>CreateApplicationVersion</code> action. The following list describes the possible
        /// values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Unprocessed</code> – Application version wasn't pre-processed or validated.
        /// Elastic Beanstalk will validate configuration files during deployment of the application version to an
        /// environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Processing</code> – Elastic Beanstalk is currently processing the application version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Building</code> – Application version is currently undergoing an AWS CodeBuild build.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Processed</code> – Elastic Beanstalk was successfully pre-processed and validated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> – Either the AWS CodeBuild build failed or configuration files didn't
        /// pass validation. This application version isn't usable.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ApplicationVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationVersionDescription`](crate::model::ApplicationVersionDescription)
        pub fn build(self) -> crate::model::ApplicationVersionDescription {
            crate::model::ApplicationVersionDescription {
                application_version_arn: self.application_version_arn,
                application_name: self.application_name,
                description: self.description,
                version_label: self.version_label,
                source_build_information: self.source_build_information,
                build_arn: self.build_arn,
                source_bundle: self.source_bundle,
                date_created: self.date_created,
                date_updated: self.date_updated,
                status: self.status,
            }
        }
    }
}
impl ApplicationVersionDescription {
    /// Creates a new builder-style object to manufacture [`ApplicationVersionDescription`](crate::model::ApplicationVersionDescription)
    pub fn builder() -> crate::model::application_version_description::Builder {
        crate::model::application_version_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApplicationVersionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Building,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Processed,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    #[allow(missing_docs)] // documentation missing in model
    Unprocessed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApplicationVersionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Building" => ApplicationVersionStatus::Building,
            "Failed" => ApplicationVersionStatus::Failed,
            "Processed" => ApplicationVersionStatus::Processed,
            "Processing" => ApplicationVersionStatus::Processing,
            "Unprocessed" => ApplicationVersionStatus::Unprocessed,
            other => ApplicationVersionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApplicationVersionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApplicationVersionStatus::from(s))
    }
}
impl ApplicationVersionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApplicationVersionStatus::Building => "Building",
            ApplicationVersionStatus::Failed => "Failed",
            ApplicationVersionStatus::Processed => "Processed",
            ApplicationVersionStatus::Processing => "Processing",
            ApplicationVersionStatus::Unprocessed => "Unprocessed",
            ApplicationVersionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Building",
            "Failed",
            "Processed",
            "Processing",
            "Unprocessed",
        ]
    }
}
impl AsRef<str> for ApplicationVersionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The bucket and key of an item stored in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>The Amazon S3 bucket where the data is located.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 key where the data is located.</p>
    pub s3_key: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_key", &self.s3_key);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket where the data is located.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket where the data is located.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The Amazon S3 key where the data is located.</p>
        pub fn s3_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key = Some(input.into());
            self
        }
        /// <p>The Amazon S3 key where the data is located.</p>
        pub fn set_s3_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                s3_bucket: self.s3_bucket,
                s3_key: self.s3_key,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

/// <p>Location of the source code for an application version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceBuildInformation {
    /// <p>The type of repository.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Git</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Zip</code>
    /// </p>
    /// </li>
    /// </ul>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>Location where the repository is stored.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CodeCommit</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>S3</code>
    /// </p>
    /// </li>
    /// </ul>
    pub source_repository: std::option::Option<crate::model::SourceRepository>,
    /// <p>The location of the source code, as a formatted string, depending on the value of <code>SourceRepository</code>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>For <code>CodeCommit</code>,
    /// the format is the repository name and commit ID, separated by a forward slash.
    /// For example,
    /// <code>my-git-repo/265cfa0cf6af46153527f55d6503ec030551f57a</code>.</p>
    /// </li>
    /// <li>
    /// <p>For <code>S3</code>,
    /// the format is the S3 bucket name and object key, separated by a forward slash.
    /// For example,
    /// <code>my-s3-bucket/Folders/my-source-file</code>.</p>
    /// </li>
    /// </ul>
    pub source_location: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SourceBuildInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceBuildInformation");
        formatter.field("source_type", &self.source_type);
        formatter.field("source_repository", &self.source_repository);
        formatter.field("source_location", &self.source_location);
        formatter.finish()
    }
}
/// See [`SourceBuildInformation`](crate::model::SourceBuildInformation)
pub mod source_build_information {
    /// A builder for [`SourceBuildInformation`](crate::model::SourceBuildInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) source_repository: std::option::Option<crate::model::SourceRepository>,
        pub(crate) source_location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of repository.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Git</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Zip</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The type of repository.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Git</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Zip</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>Location where the repository is stored.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CodeCommit</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>S3</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn source_repository(mut self, input: crate::model::SourceRepository) -> Self {
            self.source_repository = Some(input);
            self
        }
        /// <p>Location where the repository is stored.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CodeCommit</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>S3</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_source_repository(
            mut self,
            input: std::option::Option<crate::model::SourceRepository>,
        ) -> Self {
            self.source_repository = input;
            self
        }
        /// <p>The location of the source code, as a formatted string, depending on the value of <code>SourceRepository</code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>For <code>CodeCommit</code>,
        /// the format is the repository name and commit ID, separated by a forward slash.
        /// For example,
        /// <code>my-git-repo/265cfa0cf6af46153527f55d6503ec030551f57a</code>.</p>
        /// </li>
        /// <li>
        /// <p>For <code>S3</code>,
        /// the format is the S3 bucket name and object key, separated by a forward slash.
        /// For example,
        /// <code>my-s3-bucket/Folders/my-source-file</code>.</p>
        /// </li>
        /// </ul>
        pub fn source_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_location = Some(input.into());
            self
        }
        /// <p>The location of the source code, as a formatted string, depending on the value of <code>SourceRepository</code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>For <code>CodeCommit</code>,
        /// the format is the repository name and commit ID, separated by a forward slash.
        /// For example,
        /// <code>my-git-repo/265cfa0cf6af46153527f55d6503ec030551f57a</code>.</p>
        /// </li>
        /// <li>
        /// <p>For <code>S3</code>,
        /// the format is the S3 bucket name and object key, separated by a forward slash.
        /// For example,
        /// <code>my-s3-bucket/Folders/my-source-file</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_location = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceBuildInformation`](crate::model::SourceBuildInformation)
        pub fn build(self) -> crate::model::SourceBuildInformation {
            crate::model::SourceBuildInformation {
                source_type: self.source_type,
                source_repository: self.source_repository,
                source_location: self.source_location,
            }
        }
    }
}
impl SourceBuildInformation {
    /// Creates a new builder-style object to manufacture [`SourceBuildInformation`](crate::model::SourceBuildInformation)
    pub fn builder() -> crate::model::source_build_information::Builder {
        crate::model::source_build_information::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceRepository {
    #[allow(missing_docs)] // documentation missing in model
    CodeCommit,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceRepository {
    fn from(s: &str) -> Self {
        match s {
            "CodeCommit" => SourceRepository::CodeCommit,
            "S3" => SourceRepository::S3,
            other => SourceRepository::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceRepository {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceRepository::from(s))
    }
}
impl SourceRepository {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceRepository::CodeCommit => "CodeCommit",
            SourceRepository::S3 => "S3",
            SourceRepository::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CodeCommit", "S3"]
    }
}
impl AsRef<str> for SourceRepository {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    Git,
    #[allow(missing_docs)] // documentation missing in model
    Zip,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "Git" => SourceType::Git,
            "Zip" => SourceType::Zip,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::Git => "Git",
            SourceType::Zip => "Zip",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Git", "Zip"]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The resource lifecycle configuration for an application. Defines lifecycle settings for
/// resources that belong to the application, and the service role that AWS Elastic Beanstalk assumes
/// in order to apply lifecycle settings. The version lifecycle configuration defines lifecycle
/// settings for application versions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationResourceLifecycleConfig {
    /// <p>The ARN of an IAM service role that Elastic Beanstalk has permission to
    /// assume.</p>
    /// <p>The <code>ServiceRole</code> property is required the first time that you provide a
    /// <code>VersionLifecycleConfig</code> for the application in one of the supporting calls
    /// (<code>CreateApplication</code> or <code>UpdateApplicationResourceLifecycle</code>). After
    /// you provide it once, in either one of the calls, Elastic Beanstalk persists the Service Role with the
    /// application, and you don't need to specify it again in subsequent
    /// <code>UpdateApplicationResourceLifecycle</code> calls. You can, however, specify it in
    /// subsequent calls to change the Service Role to another value.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>Defines lifecycle settings for application versions.</p>
    pub version_lifecycle_config:
        std::option::Option<crate::model::ApplicationVersionLifecycleConfig>,
}
impl std::fmt::Debug for ApplicationResourceLifecycleConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationResourceLifecycleConfig");
        formatter.field("service_role", &self.service_role);
        formatter.field("version_lifecycle_config", &self.version_lifecycle_config);
        formatter.finish()
    }
}
/// See [`ApplicationResourceLifecycleConfig`](crate::model::ApplicationResourceLifecycleConfig)
pub mod application_resource_lifecycle_config {
    /// A builder for [`ApplicationResourceLifecycleConfig`](crate::model::ApplicationResourceLifecycleConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) version_lifecycle_config:
            std::option::Option<crate::model::ApplicationVersionLifecycleConfig>,
    }
    impl Builder {
        /// <p>The ARN of an IAM service role that Elastic Beanstalk has permission to
        /// assume.</p>
        /// <p>The <code>ServiceRole</code> property is required the first time that you provide a
        /// <code>VersionLifecycleConfig</code> for the application in one of the supporting calls
        /// (<code>CreateApplication</code> or <code>UpdateApplicationResourceLifecycle</code>). After
        /// you provide it once, in either one of the calls, Elastic Beanstalk persists the Service Role with the
        /// application, and you don't need to specify it again in subsequent
        /// <code>UpdateApplicationResourceLifecycle</code> calls. You can, however, specify it in
        /// subsequent calls to change the Service Role to another value.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM service role that Elastic Beanstalk has permission to
        /// assume.</p>
        /// <p>The <code>ServiceRole</code> property is required the first time that you provide a
        /// <code>VersionLifecycleConfig</code> for the application in one of the supporting calls
        /// (<code>CreateApplication</code> or <code>UpdateApplicationResourceLifecycle</code>). After
        /// you provide it once, in either one of the calls, Elastic Beanstalk persists the Service Role with the
        /// application, and you don't need to specify it again in subsequent
        /// <code>UpdateApplicationResourceLifecycle</code> calls. You can, however, specify it in
        /// subsequent calls to change the Service Role to another value.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>Defines lifecycle settings for application versions.</p>
        pub fn version_lifecycle_config(
            mut self,
            input: crate::model::ApplicationVersionLifecycleConfig,
        ) -> Self {
            self.version_lifecycle_config = Some(input);
            self
        }
        /// <p>Defines lifecycle settings for application versions.</p>
        pub fn set_version_lifecycle_config(
            mut self,
            input: std::option::Option<crate::model::ApplicationVersionLifecycleConfig>,
        ) -> Self {
            self.version_lifecycle_config = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationResourceLifecycleConfig`](crate::model::ApplicationResourceLifecycleConfig)
        pub fn build(self) -> crate::model::ApplicationResourceLifecycleConfig {
            crate::model::ApplicationResourceLifecycleConfig {
                service_role: self.service_role,
                version_lifecycle_config: self.version_lifecycle_config,
            }
        }
    }
}
impl ApplicationResourceLifecycleConfig {
    /// Creates a new builder-style object to manufacture [`ApplicationResourceLifecycleConfig`](crate::model::ApplicationResourceLifecycleConfig)
    pub fn builder() -> crate::model::application_resource_lifecycle_config::Builder {
        crate::model::application_resource_lifecycle_config::Builder::default()
    }
}

/// <p>The application version lifecycle settings for an application. Defines the rules that
/// Elastic Beanstalk applies to an application's versions in order to avoid hitting the
/// per-region limit for application versions.</p>
/// <p>When Elastic Beanstalk deletes an application version from its database, you can no
/// longer deploy that version to an environment. The source bundle remains in S3 unless you
/// configure the rule to delete it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationVersionLifecycleConfig {
    /// <p>Specify a max count rule to restrict the number of application versions that are
    /// retained for an application.</p>
    pub max_count_rule: std::option::Option<crate::model::MaxCountRule>,
    /// <p>Specify a max age rule to restrict the length of time that application versions are
    /// retained for an application.</p>
    pub max_age_rule: std::option::Option<crate::model::MaxAgeRule>,
}
impl std::fmt::Debug for ApplicationVersionLifecycleConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationVersionLifecycleConfig");
        formatter.field("max_count_rule", &self.max_count_rule);
        formatter.field("max_age_rule", &self.max_age_rule);
        formatter.finish()
    }
}
/// See [`ApplicationVersionLifecycleConfig`](crate::model::ApplicationVersionLifecycleConfig)
pub mod application_version_lifecycle_config {
    /// A builder for [`ApplicationVersionLifecycleConfig`](crate::model::ApplicationVersionLifecycleConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_count_rule: std::option::Option<crate::model::MaxCountRule>,
        pub(crate) max_age_rule: std::option::Option<crate::model::MaxAgeRule>,
    }
    impl Builder {
        /// <p>Specify a max count rule to restrict the number of application versions that are
        /// retained for an application.</p>
        pub fn max_count_rule(mut self, input: crate::model::MaxCountRule) -> Self {
            self.max_count_rule = Some(input);
            self
        }
        /// <p>Specify a max count rule to restrict the number of application versions that are
        /// retained for an application.</p>
        pub fn set_max_count_rule(
            mut self,
            input: std::option::Option<crate::model::MaxCountRule>,
        ) -> Self {
            self.max_count_rule = input;
            self
        }
        /// <p>Specify a max age rule to restrict the length of time that application versions are
        /// retained for an application.</p>
        pub fn max_age_rule(mut self, input: crate::model::MaxAgeRule) -> Self {
            self.max_age_rule = Some(input);
            self
        }
        /// <p>Specify a max age rule to restrict the length of time that application versions are
        /// retained for an application.</p>
        pub fn set_max_age_rule(
            mut self,
            input: std::option::Option<crate::model::MaxAgeRule>,
        ) -> Self {
            self.max_age_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationVersionLifecycleConfig`](crate::model::ApplicationVersionLifecycleConfig)
        pub fn build(self) -> crate::model::ApplicationVersionLifecycleConfig {
            crate::model::ApplicationVersionLifecycleConfig {
                max_count_rule: self.max_count_rule,
                max_age_rule: self.max_age_rule,
            }
        }
    }
}
impl ApplicationVersionLifecycleConfig {
    /// Creates a new builder-style object to manufacture [`ApplicationVersionLifecycleConfig`](crate::model::ApplicationVersionLifecycleConfig)
    pub fn builder() -> crate::model::application_version_lifecycle_config::Builder {
        crate::model::application_version_lifecycle_config::Builder::default()
    }
}

/// <p>A lifecycle rule that deletes application versions after the specified number of
/// days.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxAgeRule {
    /// <p>Specify <code>true</code> to apply the rule, or <code>false</code> to disable
    /// it.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>Specify the number of days to retain an application versions.</p>
    pub max_age_in_days: std::option::Option<i32>,
    /// <p>Set to <code>true</code> to delete a version's source bundle from Amazon S3 when
    /// Elastic Beanstalk deletes the application version.</p>
    pub delete_source_from_s3: std::option::Option<bool>,
}
impl std::fmt::Debug for MaxAgeRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaxAgeRule");
        formatter.field("enabled", &self.enabled);
        formatter.field("max_age_in_days", &self.max_age_in_days);
        formatter.field("delete_source_from_s3", &self.delete_source_from_s3);
        formatter.finish()
    }
}
/// See [`MaxAgeRule`](crate::model::MaxAgeRule)
pub mod max_age_rule {
    /// A builder for [`MaxAgeRule`](crate::model::MaxAgeRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) max_age_in_days: std::option::Option<i32>,
        pub(crate) delete_source_from_s3: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specify <code>true</code> to apply the rule, or <code>false</code> to disable
        /// it.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specify <code>true</code> to apply the rule, or <code>false</code> to disable
        /// it.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Specify the number of days to retain an application versions.</p>
        pub fn max_age_in_days(mut self, input: i32) -> Self {
            self.max_age_in_days = Some(input);
            self
        }
        /// <p>Specify the number of days to retain an application versions.</p>
        pub fn set_max_age_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.max_age_in_days = input;
            self
        }
        /// <p>Set to <code>true</code> to delete a version's source bundle from Amazon S3 when
        /// Elastic Beanstalk deletes the application version.</p>
        pub fn delete_source_from_s3(mut self, input: bool) -> Self {
            self.delete_source_from_s3 = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to delete a version's source bundle from Amazon S3 when
        /// Elastic Beanstalk deletes the application version.</p>
        pub fn set_delete_source_from_s3(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_source_from_s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxAgeRule`](crate::model::MaxAgeRule)
        pub fn build(self) -> crate::model::MaxAgeRule {
            crate::model::MaxAgeRule {
                enabled: self.enabled,
                max_age_in_days: self.max_age_in_days,
                delete_source_from_s3: self.delete_source_from_s3,
            }
        }
    }
}
impl MaxAgeRule {
    /// Creates a new builder-style object to manufacture [`MaxAgeRule`](crate::model::MaxAgeRule)
    pub fn builder() -> crate::model::max_age_rule::Builder {
        crate::model::max_age_rule::Builder::default()
    }
}

/// <p>A lifecycle rule that deletes the oldest application version when the maximum count is
/// exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxCountRule {
    /// <p>Specify <code>true</code> to apply the rule, or <code>false</code> to disable
    /// it.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>Specify the maximum number of application versions to retain.</p>
    pub max_count: std::option::Option<i32>,
    /// <p>Set to <code>true</code> to delete a version's source bundle from Amazon S3 when
    /// Elastic Beanstalk deletes the application version.</p>
    pub delete_source_from_s3: std::option::Option<bool>,
}
impl std::fmt::Debug for MaxCountRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaxCountRule");
        formatter.field("enabled", &self.enabled);
        formatter.field("max_count", &self.max_count);
        formatter.field("delete_source_from_s3", &self.delete_source_from_s3);
        formatter.finish()
    }
}
/// See [`MaxCountRule`](crate::model::MaxCountRule)
pub mod max_count_rule {
    /// A builder for [`MaxCountRule`](crate::model::MaxCountRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) max_count: std::option::Option<i32>,
        pub(crate) delete_source_from_s3: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specify <code>true</code> to apply the rule, or <code>false</code> to disable
        /// it.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specify <code>true</code> to apply the rule, or <code>false</code> to disable
        /// it.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Specify the maximum number of application versions to retain.</p>
        pub fn max_count(mut self, input: i32) -> Self {
            self.max_count = Some(input);
            self
        }
        /// <p>Specify the maximum number of application versions to retain.</p>
        pub fn set_max_count(mut self, input: std::option::Option<i32>) -> Self {
            self.max_count = input;
            self
        }
        /// <p>Set to <code>true</code> to delete a version's source bundle from Amazon S3 when
        /// Elastic Beanstalk deletes the application version.</p>
        pub fn delete_source_from_s3(mut self, input: bool) -> Self {
            self.delete_source_from_s3 = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to delete a version's source bundle from Amazon S3 when
        /// Elastic Beanstalk deletes the application version.</p>
        pub fn set_delete_source_from_s3(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_source_from_s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxCountRule`](crate::model::MaxCountRule)
        pub fn build(self) -> crate::model::MaxCountRule {
            crate::model::MaxCountRule {
                enabled: self.enabled,
                max_count: self.max_count,
                delete_source_from_s3: self.delete_source_from_s3,
            }
        }
    }
}
impl MaxCountRule {
    /// Creates a new builder-style object to manufacture [`MaxCountRule`](crate::model::MaxCountRule)
    pub fn builder() -> crate::model::max_count_rule::Builder {
        crate::model::max_count_rule::Builder::default()
    }
}

/// <p>Describes the properties of an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationDescription {
    /// <p>The Amazon Resource Name (ARN) of the application.</p>
    pub application_arn: std::option::Option<std::string::String>,
    /// <p>The name of the application.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>User-defined description of the application.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date when the application was created.</p>
    pub date_created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date when the application was last modified.</p>
    pub date_updated: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The names of the versions for this application.</p>
    pub versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of the configuration templates associated with this application.</p>
    pub configuration_templates: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The lifecycle settings for the application.</p>
    pub resource_lifecycle_config:
        std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
}
impl std::fmt::Debug for ApplicationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationDescription");
        formatter.field("application_arn", &self.application_arn);
        formatter.field("application_name", &self.application_name);
        formatter.field("description", &self.description);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("versions", &self.versions);
        formatter.field("configuration_templates", &self.configuration_templates);
        formatter.field("resource_lifecycle_config", &self.resource_lifecycle_config);
        formatter.finish()
    }
}
/// See [`ApplicationDescription`](crate::model::ApplicationDescription)
pub mod application_description {
    /// A builder for [`ApplicationDescription`](crate::model::ApplicationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_arn: std::option::Option<std::string::String>,
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) date_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) configuration_templates: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_lifecycle_config:
            std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_arn = input;
            self
        }
        /// <p>The name of the application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>User-defined description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>User-defined description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date when the application was created.</p>
        pub fn date_created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The date when the application was created.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The date when the application was last modified.</p>
        pub fn date_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date_updated = Some(input);
            self
        }
        /// <p>The date when the application was last modified.</p>
        pub fn set_date_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.date_updated = input;
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>The names of the versions for this application.</p>
        pub fn versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input.into());
            self.versions = Some(v);
            self
        }
        /// <p>The names of the versions for this application.</p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.versions = input;
            self
        }
        /// Appends an item to `configuration_templates`.
        ///
        /// To override the contents of this collection use [`set_configuration_templates`](Self::set_configuration_templates).
        ///
        /// <p>The names of the configuration templates associated with this application.</p>
        pub fn configuration_templates(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.configuration_templates.unwrap_or_default();
            v.push(input.into());
            self.configuration_templates = Some(v);
            self
        }
        /// <p>The names of the configuration templates associated with this application.</p>
        pub fn set_configuration_templates(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.configuration_templates = input;
            self
        }
        /// <p>The lifecycle settings for the application.</p>
        pub fn resource_lifecycle_config(
            mut self,
            input: crate::model::ApplicationResourceLifecycleConfig,
        ) -> Self {
            self.resource_lifecycle_config = Some(input);
            self
        }
        /// <p>The lifecycle settings for the application.</p>
        pub fn set_resource_lifecycle_config(
            mut self,
            input: std::option::Option<crate::model::ApplicationResourceLifecycleConfig>,
        ) -> Self {
            self.resource_lifecycle_config = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationDescription`](crate::model::ApplicationDescription)
        pub fn build(self) -> crate::model::ApplicationDescription {
            crate::model::ApplicationDescription {
                application_arn: self.application_arn,
                application_name: self.application_name,
                description: self.description,
                date_created: self.date_created,
                date_updated: self.date_updated,
                versions: self.versions,
                configuration_templates: self.configuration_templates,
                resource_lifecycle_config: self.resource_lifecycle_config,
            }
        }
    }
}
impl ApplicationDescription {
    /// Creates a new builder-style object to manufacture [`ApplicationDescription`](crate::model::ApplicationDescription)
    pub fn builder() -> crate::model::application_description::Builder {
        crate::model::application_description::Builder::default()
    }
}

/// <p>The information retrieved from the Amazon EC2 instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentInfoDescription {
    /// <p>The type of information retrieved.</p>
    pub info_type: std::option::Option<crate::model::EnvironmentInfoType>,
    /// <p>The Amazon EC2 Instance ID for this information.</p>
    pub ec2_instance_id: std::option::Option<std::string::String>,
    /// <p>The time stamp when this information was retrieved.</p>
    pub sample_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The retrieved information. Currently contains a presigned Amazon S3 URL. The files are
    /// deleted after 15 minutes.</p>
    /// <p>Anyone in possession of this URL can access the files before they are deleted. Make the
    /// URL available only to trusted parties.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EnvironmentInfoDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentInfoDescription");
        formatter.field("info_type", &self.info_type);
        formatter.field("ec2_instance_id", &self.ec2_instance_id);
        formatter.field("sample_timestamp", &self.sample_timestamp);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`EnvironmentInfoDescription`](crate::model::EnvironmentInfoDescription)
pub mod environment_info_description {
    /// A builder for [`EnvironmentInfoDescription`](crate::model::EnvironmentInfoDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) info_type: std::option::Option<crate::model::EnvironmentInfoType>,
        pub(crate) ec2_instance_id: std::option::Option<std::string::String>,
        pub(crate) sample_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of information retrieved.</p>
        pub fn info_type(mut self, input: crate::model::EnvironmentInfoType) -> Self {
            self.info_type = Some(input);
            self
        }
        /// <p>The type of information retrieved.</p>
        pub fn set_info_type(
            mut self,
            input: std::option::Option<crate::model::EnvironmentInfoType>,
        ) -> Self {
            self.info_type = input;
            self
        }
        /// <p>The Amazon EC2 Instance ID for this information.</p>
        pub fn ec2_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_instance_id = Some(input.into());
            self
        }
        /// <p>The Amazon EC2 Instance ID for this information.</p>
        pub fn set_ec2_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_instance_id = input;
            self
        }
        /// <p>The time stamp when this information was retrieved.</p>
        pub fn sample_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.sample_timestamp = Some(input);
            self
        }
        /// <p>The time stamp when this information was retrieved.</p>
        pub fn set_sample_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.sample_timestamp = input;
            self
        }
        /// <p>The retrieved information. Currently contains a presigned Amazon S3 URL. The files are
        /// deleted after 15 minutes.</p>
        /// <p>Anyone in possession of this URL can access the files before they are deleted. Make the
        /// URL available only to trusted parties.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The retrieved information. Currently contains a presigned Amazon S3 URL. The files are
        /// deleted after 15 minutes.</p>
        /// <p>Anyone in possession of this URL can access the files before they are deleted. Make the
        /// URL available only to trusted parties.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentInfoDescription`](crate::model::EnvironmentInfoDescription)
        pub fn build(self) -> crate::model::EnvironmentInfoDescription {
            crate::model::EnvironmentInfoDescription {
                info_type: self.info_type,
                ec2_instance_id: self.ec2_instance_id,
                sample_timestamp: self.sample_timestamp,
                message: self.message,
            }
        }
    }
}
impl EnvironmentInfoDescription {
    /// Creates a new builder-style object to manufacture [`EnvironmentInfoDescription`](crate::model::EnvironmentInfoDescription)
    pub fn builder() -> crate::model::environment_info_description::Builder {
        crate::model::environment_info_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnvironmentInfoType {
    #[allow(missing_docs)] // documentation missing in model
    Bundle,
    #[allow(missing_docs)] // documentation missing in model
    Tail,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnvironmentInfoType {
    fn from(s: &str) -> Self {
        match s {
            "bundle" => EnvironmentInfoType::Bundle,
            "tail" => EnvironmentInfoType::Tail,
            other => EnvironmentInfoType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnvironmentInfoType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnvironmentInfoType::from(s))
    }
}
impl EnvironmentInfoType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnvironmentInfoType::Bundle => "bundle",
            EnvironmentInfoType::Tail => "tail",
            EnvironmentInfoType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["bundle", "tail"]
    }
}
impl AsRef<str> for EnvironmentInfoType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about a platform version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlatformSummary {
    /// <p>The ARN of the platform version.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>The AWS account ID of the person who created the platform version.</p>
    pub platform_owner: std::option::Option<std::string::String>,
    /// <p>The status of the platform version. You can create an environment from the platform
    /// version once it is ready.</p>
    pub platform_status: std::option::Option<crate::model::PlatformStatus>,
    /// <p>The category of platform version.</p>
    pub platform_category: std::option::Option<std::string::String>,
    /// <p>The operating system used by the platform version.</p>
    pub operating_system_name: std::option::Option<std::string::String>,
    /// <p>The version of the operating system used by the platform version.</p>
    pub operating_system_version: std::option::Option<std::string::String>,
    /// <p>The tiers in which the platform version runs.</p>
    pub supported_tier_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The additions associated with the platform version.</p>
    pub supported_addon_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The state of the platform version in its lifecycle.</p>
    /// <p>Possible values: <code>recommended</code> | empty</p>
    /// <p>If an empty value is returned, the platform version is supported but isn't the recommended
    /// one for its branch.</p>
    pub platform_lifecycle_state: std::option::Option<std::string::String>,
    /// <p>The version string of the platform version.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>The platform branch to which the platform version belongs.</p>
    pub platform_branch_name: std::option::Option<std::string::String>,
    /// <p>The state of the platform version's branch in its lifecycle.</p>
    /// <p>Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
    /// <code>retired</code>
    /// </p>
    pub platform_branch_lifecycle_state: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PlatformSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlatformSummary");
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("platform_owner", &self.platform_owner);
        formatter.field("platform_status", &self.platform_status);
        formatter.field("platform_category", &self.platform_category);
        formatter.field("operating_system_name", &self.operating_system_name);
        formatter.field("operating_system_version", &self.operating_system_version);
        formatter.field("supported_tier_list", &self.supported_tier_list);
        formatter.field("supported_addon_list", &self.supported_addon_list);
        formatter.field("platform_lifecycle_state", &self.platform_lifecycle_state);
        formatter.field("platform_version", &self.platform_version);
        formatter.field("platform_branch_name", &self.platform_branch_name);
        formatter.field(
            "platform_branch_lifecycle_state",
            &self.platform_branch_lifecycle_state,
        );
        formatter.finish()
    }
}
/// See [`PlatformSummary`](crate::model::PlatformSummary)
pub mod platform_summary {
    /// A builder for [`PlatformSummary`](crate::model::PlatformSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) platform_owner: std::option::Option<std::string::String>,
        pub(crate) platform_status: std::option::Option<crate::model::PlatformStatus>,
        pub(crate) platform_category: std::option::Option<std::string::String>,
        pub(crate) operating_system_name: std::option::Option<std::string::String>,
        pub(crate) operating_system_version: std::option::Option<std::string::String>,
        pub(crate) supported_tier_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supported_addon_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) platform_lifecycle_state: std::option::Option<std::string::String>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) platform_branch_name: std::option::Option<std::string::String>,
        pub(crate) platform_branch_lifecycle_state: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// <p>The AWS account ID of the person who created the platform version.</p>
        pub fn platform_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_owner = Some(input.into());
            self
        }
        /// <p>The AWS account ID of the person who created the platform version.</p>
        pub fn set_platform_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_owner = input;
            self
        }
        /// <p>The status of the platform version. You can create an environment from the platform
        /// version once it is ready.</p>
        pub fn platform_status(mut self, input: crate::model::PlatformStatus) -> Self {
            self.platform_status = Some(input);
            self
        }
        /// <p>The status of the platform version. You can create an environment from the platform
        /// version once it is ready.</p>
        pub fn set_platform_status(
            mut self,
            input: std::option::Option<crate::model::PlatformStatus>,
        ) -> Self {
            self.platform_status = input;
            self
        }
        /// <p>The category of platform version.</p>
        pub fn platform_category(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_category = Some(input.into());
            self
        }
        /// <p>The category of platform version.</p>
        pub fn set_platform_category(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_category = input;
            self
        }
        /// <p>The operating system used by the platform version.</p>
        pub fn operating_system_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operating_system_name = Some(input.into());
            self
        }
        /// <p>The operating system used by the platform version.</p>
        pub fn set_operating_system_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operating_system_name = input;
            self
        }
        /// <p>The version of the operating system used by the platform version.</p>
        pub fn operating_system_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.operating_system_version = Some(input.into());
            self
        }
        /// <p>The version of the operating system used by the platform version.</p>
        pub fn set_operating_system_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operating_system_version = input;
            self
        }
        /// Appends an item to `supported_tier_list`.
        ///
        /// To override the contents of this collection use [`set_supported_tier_list`](Self::set_supported_tier_list).
        ///
        /// <p>The tiers in which the platform version runs.</p>
        pub fn supported_tier_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_tier_list.unwrap_or_default();
            v.push(input.into());
            self.supported_tier_list = Some(v);
            self
        }
        /// <p>The tiers in which the platform version runs.</p>
        pub fn set_supported_tier_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_tier_list = input;
            self
        }
        /// Appends an item to `supported_addon_list`.
        ///
        /// To override the contents of this collection use [`set_supported_addon_list`](Self::set_supported_addon_list).
        ///
        /// <p>The additions associated with the platform version.</p>
        pub fn supported_addon_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_addon_list.unwrap_or_default();
            v.push(input.into());
            self.supported_addon_list = Some(v);
            self
        }
        /// <p>The additions associated with the platform version.</p>
        pub fn set_supported_addon_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_addon_list = input;
            self
        }
        /// <p>The state of the platform version in its lifecycle.</p>
        /// <p>Possible values: <code>recommended</code> | empty</p>
        /// <p>If an empty value is returned, the platform version is supported but isn't the recommended
        /// one for its branch.</p>
        pub fn platform_lifecycle_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_lifecycle_state = Some(input.into());
            self
        }
        /// <p>The state of the platform version in its lifecycle.</p>
        /// <p>Possible values: <code>recommended</code> | empty</p>
        /// <p>If an empty value is returned, the platform version is supported but isn't the recommended
        /// one for its branch.</p>
        pub fn set_platform_lifecycle_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_lifecycle_state = input;
            self
        }
        /// <p>The version string of the platform version.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The version string of the platform version.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>The platform branch to which the platform version belongs.</p>
        pub fn platform_branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_branch_name = Some(input.into());
            self
        }
        /// <p>The platform branch to which the platform version belongs.</p>
        pub fn set_platform_branch_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_branch_name = input;
            self
        }
        /// <p>The state of the platform version's branch in its lifecycle.</p>
        /// <p>Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
        /// <code>retired</code>
        /// </p>
        pub fn platform_branch_lifecycle_state(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.platform_branch_lifecycle_state = Some(input.into());
            self
        }
        /// <p>The state of the platform version's branch in its lifecycle.</p>
        /// <p>Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
        /// <code>retired</code>
        /// </p>
        pub fn set_platform_branch_lifecycle_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_branch_lifecycle_state = input;
            self
        }
        /// Consumes the builder and constructs a [`PlatformSummary`](crate::model::PlatformSummary)
        pub fn build(self) -> crate::model::PlatformSummary {
            crate::model::PlatformSummary {
                platform_arn: self.platform_arn,
                platform_owner: self.platform_owner,
                platform_status: self.platform_status,
                platform_category: self.platform_category,
                operating_system_name: self.operating_system_name,
                operating_system_version: self.operating_system_version,
                supported_tier_list: self.supported_tier_list,
                supported_addon_list: self.supported_addon_list,
                platform_lifecycle_state: self.platform_lifecycle_state,
                platform_version: self.platform_version,
                platform_branch_name: self.platform_branch_name,
                platform_branch_lifecycle_state: self.platform_branch_lifecycle_state,
            }
        }
    }
}
impl PlatformSummary {
    /// Creates a new builder-style object to manufacture [`PlatformSummary`](crate::model::PlatformSummary)
    pub fn builder() -> crate::model::platform_summary::Builder {
        crate::model::platform_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlatformStatus {
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlatformStatus {
    fn from(s: &str) -> Self {
        match s {
            "Creating" => PlatformStatus::Creating,
            "Deleted" => PlatformStatus::Deleted,
            "Deleting" => PlatformStatus::Deleting,
            "Failed" => PlatformStatus::Failed,
            "Ready" => PlatformStatus::Ready,
            other => PlatformStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlatformStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlatformStatus::from(s))
    }
}
impl PlatformStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlatformStatus::Creating => "Creating",
            PlatformStatus::Deleted => "Deleted",
            PlatformStatus::Deleting => "Deleting",
            PlatformStatus::Failed => "Failed",
            PlatformStatus::Ready => "Ready",
            PlatformStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Creating", "Deleted", "Deleting", "Failed", "Ready"]
    }
}
impl AsRef<str> for PlatformStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes criteria to restrict the results when listing platform versions.</p>
/// <p>The filter is evaluated as follows: <code>Type Operator Values[1]</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlatformFilter {
    /// <p>The platform version attribute to which the filter values are applied.</p>
    /// <p>Valid values: <code>PlatformName</code> | <code>PlatformVersion</code> |
    /// <code>PlatformStatus</code> | <code>PlatformBranchName</code> |
    /// <code>PlatformLifecycleState</code> | <code>PlatformOwner</code> |
    /// <code>SupportedTier</code> | <code>SupportedAddon</code> |
    /// <code>ProgrammingLanguageName</code> | <code>OperatingSystemName</code>
    /// </p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The operator to apply to the <code>Type</code> with each of the
    /// <code>Values</code>.</p>
    /// <p>Valid values: <code>=</code> | <code>!=</code> |
    /// <code><</code> | <code><=</code> |
    /// <code>></code> | <code>>=</code> |
    /// <code>contains</code> | <code>begins_with</code> | <code>ends_with</code>
    /// </p>
    pub operator: std::option::Option<std::string::String>,
    /// <p>The list of values applied to the filtering platform version attribute. Only one value is supported
    /// for all current operators.</p>
    /// <p>The following list shows valid filter values for some filter attributes.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PlatformStatus</code>: <code>Creating</code> | <code>Failed</code> |
    /// <code>Ready</code> | <code>Deleting</code> | <code>Deleted</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PlatformLifecycleState</code>: <code>recommended</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SupportedTier</code>: <code>WebServer/Standard</code> |
    /// <code>Worker/SQS/HTTP</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SupportedAddon</code>: <code>Log/S3</code> | <code>Monitoring/Healthd</code> |
    /// <code>WorkerDaemon/SQSD</code>
    /// </p>
    /// </li>
    /// </ul>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for PlatformFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlatformFilter");
        formatter.field("r#type", &self.r#type);
        formatter.field("operator", &self.operator);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`PlatformFilter`](crate::model::PlatformFilter)
pub mod platform_filter {
    /// A builder for [`PlatformFilter`](crate::model::PlatformFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) operator: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The platform version attribute to which the filter values are applied.</p>
        /// <p>Valid values: <code>PlatformName</code> | <code>PlatformVersion</code> |
        /// <code>PlatformStatus</code> | <code>PlatformBranchName</code> |
        /// <code>PlatformLifecycleState</code> | <code>PlatformOwner</code> |
        /// <code>SupportedTier</code> | <code>SupportedAddon</code> |
        /// <code>ProgrammingLanguageName</code> | <code>OperatingSystemName</code>
        /// </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The platform version attribute to which the filter values are applied.</p>
        /// <p>Valid values: <code>PlatformName</code> | <code>PlatformVersion</code> |
        /// <code>PlatformStatus</code> | <code>PlatformBranchName</code> |
        /// <code>PlatformLifecycleState</code> | <code>PlatformOwner</code> |
        /// <code>SupportedTier</code> | <code>SupportedAddon</code> |
        /// <code>ProgrammingLanguageName</code> | <code>OperatingSystemName</code>
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The operator to apply to the <code>Type</code> with each of the
        /// <code>Values</code>.</p>
        /// <p>Valid values: <code>=</code> | <code>!=</code> |
        /// <code><</code> | <code><=</code> |
        /// <code>></code> | <code>>=</code> |
        /// <code>contains</code> | <code>begins_with</code> | <code>ends_with</code>
        /// </p>
        pub fn operator(mut self, input: impl Into<std::string::String>) -> Self {
            self.operator = Some(input.into());
            self
        }
        /// <p>The operator to apply to the <code>Type</code> with each of the
        /// <code>Values</code>.</p>
        /// <p>Valid values: <code>=</code> | <code>!=</code> |
        /// <code><</code> | <code><=</code> |
        /// <code>></code> | <code>>=</code> |
        /// <code>contains</code> | <code>begins_with</code> | <code>ends_with</code>
        /// </p>
        pub fn set_operator(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operator = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The list of values applied to the filtering platform version attribute. Only one value is supported
        /// for all current operators.</p>
        /// <p>The following list shows valid filter values for some filter attributes.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PlatformStatus</code>: <code>Creating</code> | <code>Failed</code> |
        /// <code>Ready</code> | <code>Deleting</code> | <code>Deleted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PlatformLifecycleState</code>: <code>recommended</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SupportedTier</code>: <code>WebServer/Standard</code> |
        /// <code>Worker/SQS/HTTP</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SupportedAddon</code>: <code>Log/S3</code> | <code>Monitoring/Healthd</code> |
        /// <code>WorkerDaemon/SQSD</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The list of values applied to the filtering platform version attribute. Only one value is supported
        /// for all current operators.</p>
        /// <p>The following list shows valid filter values for some filter attributes.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PlatformStatus</code>: <code>Creating</code> | <code>Failed</code> |
        /// <code>Ready</code> | <code>Deleting</code> | <code>Deleted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PlatformLifecycleState</code>: <code>recommended</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SupportedTier</code>: <code>WebServer/Standard</code> |
        /// <code>Worker/SQS/HTTP</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SupportedAddon</code>: <code>Log/S3</code> | <code>Monitoring/Healthd</code> |
        /// <code>WorkerDaemon/SQSD</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`PlatformFilter`](crate::model::PlatformFilter)
        pub fn build(self) -> crate::model::PlatformFilter {
            crate::model::PlatformFilter {
                r#type: self.r#type,
                operator: self.operator,
                values: self.values,
            }
        }
    }
}
impl PlatformFilter {
    /// Creates a new builder-style object to manufacture [`PlatformFilter`](crate::model::PlatformFilter)
    pub fn builder() -> crate::model::platform_filter::Builder {
        crate::model::platform_filter::Builder::default()
    }
}

/// <p>Summary information about a platform branch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlatformBranchSummary {
    /// <p>The name of the platform to which this platform branch belongs.</p>
    pub platform_name: std::option::Option<std::string::String>,
    /// <p>The name of the platform branch.</p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p>The support life cycle state of the platform branch.</p>
    /// <p>Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
    /// <code>retired</code>
    /// </p>
    pub lifecycle_state: std::option::Option<std::string::String>,
    /// <p>An ordinal number that designates the order in which platform branches have been added to
    /// a platform. This can be helpful, for example, if your code calls the
    /// <code>ListPlatformBranches</code> action and then displays a list of platform
    /// branches.</p>
    /// <p>A larger <code>BranchOrder</code> value designates a newer platform branch within the
    /// platform.</p>
    pub branch_order: i32,
    /// <p>The environment tiers that platform versions in this branch support.</p>
    /// <p>Possible values: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
    /// </p>
    pub supported_tier_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for PlatformBranchSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlatformBranchSummary");
        formatter.field("platform_name", &self.platform_name);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("lifecycle_state", &self.lifecycle_state);
        formatter.field("branch_order", &self.branch_order);
        formatter.field("supported_tier_list", &self.supported_tier_list);
        formatter.finish()
    }
}
/// See [`PlatformBranchSummary`](crate::model::PlatformBranchSummary)
pub mod platform_branch_summary {
    /// A builder for [`PlatformBranchSummary`](crate::model::PlatformBranchSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_name: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_state: std::option::Option<std::string::String>,
        pub(crate) branch_order: std::option::Option<i32>,
        pub(crate) supported_tier_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the platform to which this platform branch belongs.</p>
        pub fn platform_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_name = Some(input.into());
            self
        }
        /// <p>The name of the platform to which this platform branch belongs.</p>
        pub fn set_platform_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_name = input;
            self
        }
        /// <p>The name of the platform branch.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p>The name of the platform branch.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p>The support life cycle state of the platform branch.</p>
        /// <p>Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
        /// <code>retired</code>
        /// </p>
        pub fn lifecycle_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_state = Some(input.into());
            self
        }
        /// <p>The support life cycle state of the platform branch.</p>
        /// <p>Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
        /// <code>retired</code>
        /// </p>
        pub fn set_lifecycle_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_state = input;
            self
        }
        /// <p>An ordinal number that designates the order in which platform branches have been added to
        /// a platform. This can be helpful, for example, if your code calls the
        /// <code>ListPlatformBranches</code> action and then displays a list of platform
        /// branches.</p>
        /// <p>A larger <code>BranchOrder</code> value designates a newer platform branch within the
        /// platform.</p>
        pub fn branch_order(mut self, input: i32) -> Self {
            self.branch_order = Some(input);
            self
        }
        /// <p>An ordinal number that designates the order in which platform branches have been added to
        /// a platform. This can be helpful, for example, if your code calls the
        /// <code>ListPlatformBranches</code> action and then displays a list of platform
        /// branches.</p>
        /// <p>A larger <code>BranchOrder</code> value designates a newer platform branch within the
        /// platform.</p>
        pub fn set_branch_order(mut self, input: std::option::Option<i32>) -> Self {
            self.branch_order = input;
            self
        }
        /// Appends an item to `supported_tier_list`.
        ///
        /// To override the contents of this collection use [`set_supported_tier_list`](Self::set_supported_tier_list).
        ///
        /// <p>The environment tiers that platform versions in this branch support.</p>
        /// <p>Possible values: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
        /// </p>
        pub fn supported_tier_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_tier_list.unwrap_or_default();
            v.push(input.into());
            self.supported_tier_list = Some(v);
            self
        }
        /// <p>The environment tiers that platform versions in this branch support.</p>
        /// <p>Possible values: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
        /// </p>
        pub fn set_supported_tier_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_tier_list = input;
            self
        }
        /// Consumes the builder and constructs a [`PlatformBranchSummary`](crate::model::PlatformBranchSummary)
        pub fn build(self) -> crate::model::PlatformBranchSummary {
            crate::model::PlatformBranchSummary {
                platform_name: self.platform_name,
                branch_name: self.branch_name,
                lifecycle_state: self.lifecycle_state,
                branch_order: self.branch_order.unwrap_or_default(),
                supported_tier_list: self.supported_tier_list,
            }
        }
    }
}
impl PlatformBranchSummary {
    /// Creates a new builder-style object to manufacture [`PlatformBranchSummary`](crate::model::PlatformBranchSummary)
    pub fn builder() -> crate::model::platform_branch_summary::Builder {
        crate::model::platform_branch_summary::Builder::default()
    }
}

/// <p>Describes criteria to restrict a list of results.</p>
/// <p>For operators that apply a single value to the attribute, the filter is evaluated as
/// follows: <code>Attribute Operator Values[1]</code>
/// </p>
/// <p>Some operators, e.g. <code>in</code>, can apply multiple values. In this case, the filter
/// is evaluated as a logical union (OR) of applications of the operator to the attribute with
/// each one of the values: <code>(Attribute Operator Values[1]) OR (Attribute Operator Values[2])
/// OR ...</code>
/// </p>
/// <p>The valid values for attributes of <code>SearchFilter</code> depend on the API action. For
/// valid values, see the reference page for the API action you're calling that takes a
/// <code>SearchFilter</code> parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchFilter {
    /// <p>The result attribute to which the filter values are applied. Valid values vary by API
    /// action.</p>
    pub attribute: std::option::Option<std::string::String>,
    /// <p>The operator to apply to the <code>Attribute</code> with each of the <code>Values</code>.
    /// Valid values vary by <code>Attribute</code>.</p>
    pub operator: std::option::Option<std::string::String>,
    /// <p>The list of values applied to the <code>Attribute</code> and <code>Operator</code>
    /// attributes. Number of values and valid values vary by <code>Attribute</code>.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for SearchFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchFilter");
        formatter.field("attribute", &self.attribute);
        formatter.field("operator", &self.operator);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`SearchFilter`](crate::model::SearchFilter)
pub mod search_filter {
    /// A builder for [`SearchFilter`](crate::model::SearchFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<std::string::String>,
        pub(crate) operator: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The result attribute to which the filter values are applied. Valid values vary by API
        /// action.</p>
        pub fn attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute = Some(input.into());
            self
        }
        /// <p>The result attribute to which the filter values are applied. Valid values vary by API
        /// action.</p>
        pub fn set_attribute(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The operator to apply to the <code>Attribute</code> with each of the <code>Values</code>.
        /// Valid values vary by <code>Attribute</code>.</p>
        pub fn operator(mut self, input: impl Into<std::string::String>) -> Self {
            self.operator = Some(input.into());
            self
        }
        /// <p>The operator to apply to the <code>Attribute</code> with each of the <code>Values</code>.
        /// Valid values vary by <code>Attribute</code>.</p>
        pub fn set_operator(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operator = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The list of values applied to the <code>Attribute</code> and <code>Operator</code>
        /// attributes. Number of values and valid values vary by <code>Attribute</code>.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The list of values applied to the <code>Attribute</code> and <code>Operator</code>
        /// attributes. Number of values and valid values vary by <code>Attribute</code>.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchFilter`](crate::model::SearchFilter)
        pub fn build(self) -> crate::model::SearchFilter {
            crate::model::SearchFilter {
                attribute: self.attribute,
                operator: self.operator,
                values: self.values,
            }
        }
    }
}
impl SearchFilter {
    /// Creates a new builder-style object to manufacture [`SearchFilter`](crate::model::SearchFilter)
    pub fn builder() -> crate::model::search_filter::Builder {
        crate::model::search_filter::Builder::default()
    }
}

/// <p>Describes the solution stack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SolutionStackDescription {
    /// <p>The name of the solution stack.</p>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The permitted file types allowed for a solution stack.</p>
    pub permitted_file_types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for SolutionStackDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SolutionStackDescription");
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("permitted_file_types", &self.permitted_file_types);
        formatter.finish()
    }
}
/// See [`SolutionStackDescription`](crate::model::SolutionStackDescription)
pub mod solution_stack_description {
    /// A builder for [`SolutionStackDescription`](crate::model::SolutionStackDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) permitted_file_types: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the solution stack.</p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p>The name of the solution stack.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// Appends an item to `permitted_file_types`.
        ///
        /// To override the contents of this collection use [`set_permitted_file_types`](Self::set_permitted_file_types).
        ///
        /// <p>The permitted file types allowed for a solution stack.</p>
        pub fn permitted_file_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.permitted_file_types.unwrap_or_default();
            v.push(input.into());
            self.permitted_file_types = Some(v);
            self
        }
        /// <p>The permitted file types allowed for a solution stack.</p>
        pub fn set_permitted_file_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.permitted_file_types = input;
            self
        }
        /// Consumes the builder and constructs a [`SolutionStackDescription`](crate::model::SolutionStackDescription)
        pub fn build(self) -> crate::model::SolutionStackDescription {
            crate::model::SolutionStackDescription {
                solution_stack_name: self.solution_stack_name,
                permitted_file_types: self.permitted_file_types,
            }
        }
    }
}
impl SolutionStackDescription {
    /// Creates a new builder-style object to manufacture [`SolutionStackDescription`](crate::model::SolutionStackDescription)
    pub fn builder() -> crate::model::solution_stack_description::Builder {
        crate::model::solution_stack_description::Builder::default()
    }
}

/// <p>Detailed information about a platform version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlatformDescription {
    /// <p>The ARN of the platform version.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>The AWS account ID of the person who created the platform version.</p>
    pub platform_owner: std::option::Option<std::string::String>,
    /// <p>The name of the platform version.</p>
    pub platform_name: std::option::Option<std::string::String>,
    /// <p>The version of the platform version.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>The name of the solution stack used by the platform version.</p>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The status of the platform version.</p>
    pub platform_status: std::option::Option<crate::model::PlatformStatus>,
    /// <p>The date when the platform version was created.</p>
    pub date_created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date when the platform version was last updated.</p>
    pub date_updated: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The category of the platform version.</p>
    pub platform_category: std::option::Option<std::string::String>,
    /// <p>The description of the platform version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the maintainer of the platform version.</p>
    pub maintainer: std::option::Option<std::string::String>,
    /// <p>The operating system used by the platform version.</p>
    pub operating_system_name: std::option::Option<std::string::String>,
    /// <p>The version of the operating system used by the platform version.</p>
    pub operating_system_version: std::option::Option<std::string::String>,
    /// <p>The programming languages supported by the platform version.</p>
    pub programming_languages:
        std::option::Option<std::vec::Vec<crate::model::PlatformProgrammingLanguage>>,
    /// <p>The frameworks supported by the platform version.</p>
    pub frameworks: std::option::Option<std::vec::Vec<crate::model::PlatformFramework>>,
    /// <p>The custom AMIs supported by the platform version.</p>
    pub custom_ami_list: std::option::Option<std::vec::Vec<crate::model::CustomAmi>>,
    /// <p>The tiers supported by the platform version.</p>
    pub supported_tier_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The additions supported by the platform version.</p>
    pub supported_addon_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The state of the platform version in its lifecycle.</p>
    /// <p>Possible values: <code>Recommended</code> | <code>null</code>
    /// </p>
    /// <p>If a null value is returned, the platform version isn't the recommended one for its
    /// branch. Each platform branch has a single recommended platform version, typically the most
    /// recent one.</p>
    pub platform_lifecycle_state: std::option::Option<std::string::String>,
    /// <p>The platform branch to which the platform version belongs.</p>
    pub platform_branch_name: std::option::Option<std::string::String>,
    /// <p>The state of the platform version's branch in its lifecycle.</p>
    /// <p>Possible values: <code>Beta</code> | <code>Supported</code> | <code>Deprecated</code> |
    /// <code>Retired</code>
    /// </p>
    pub platform_branch_lifecycle_state: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PlatformDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlatformDescription");
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("platform_owner", &self.platform_owner);
        formatter.field("platform_name", &self.platform_name);
        formatter.field("platform_version", &self.platform_version);
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("platform_status", &self.platform_status);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("platform_category", &self.platform_category);
        formatter.field("description", &self.description);
        formatter.field("maintainer", &self.maintainer);
        formatter.field("operating_system_name", &self.operating_system_name);
        formatter.field("operating_system_version", &self.operating_system_version);
        formatter.field("programming_languages", &self.programming_languages);
        formatter.field("frameworks", &self.frameworks);
        formatter.field("custom_ami_list", &self.custom_ami_list);
        formatter.field("supported_tier_list", &self.supported_tier_list);
        formatter.field("supported_addon_list", &self.supported_addon_list);
        formatter.field("platform_lifecycle_state", &self.platform_lifecycle_state);
        formatter.field("platform_branch_name", &self.platform_branch_name);
        formatter.field(
            "platform_branch_lifecycle_state",
            &self.platform_branch_lifecycle_state,
        );
        formatter.finish()
    }
}
/// See [`PlatformDescription`](crate::model::PlatformDescription)
pub mod platform_description {
    /// A builder for [`PlatformDescription`](crate::model::PlatformDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) platform_owner: std::option::Option<std::string::String>,
        pub(crate) platform_name: std::option::Option<std::string::String>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) platform_status: std::option::Option<crate::model::PlatformStatus>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) date_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) platform_category: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) maintainer: std::option::Option<std::string::String>,
        pub(crate) operating_system_name: std::option::Option<std::string::String>,
        pub(crate) operating_system_version: std::option::Option<std::string::String>,
        pub(crate) programming_languages:
            std::option::Option<std::vec::Vec<crate::model::PlatformProgrammingLanguage>>,
        pub(crate) frameworks: std::option::Option<std::vec::Vec<crate::model::PlatformFramework>>,
        pub(crate) custom_ami_list: std::option::Option<std::vec::Vec<crate::model::CustomAmi>>,
        pub(crate) supported_tier_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supported_addon_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) platform_lifecycle_state: std::option::Option<std::string::String>,
        pub(crate) platform_branch_name: std::option::Option<std::string::String>,
        pub(crate) platform_branch_lifecycle_state: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// <p>The AWS account ID of the person who created the platform version.</p>
        pub fn platform_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_owner = Some(input.into());
            self
        }
        /// <p>The AWS account ID of the person who created the platform version.</p>
        pub fn set_platform_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_owner = input;
            self
        }
        /// <p>The name of the platform version.</p>
        pub fn platform_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_name = Some(input.into());
            self
        }
        /// <p>The name of the platform version.</p>
        pub fn set_platform_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_name = input;
            self
        }
        /// <p>The version of the platform version.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The version of the platform version.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>The name of the solution stack used by the platform version.</p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p>The name of the solution stack used by the platform version.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// <p>The status of the platform version.</p>
        pub fn platform_status(mut self, input: crate::model::PlatformStatus) -> Self {
            self.platform_status = Some(input);
            self
        }
        /// <p>The status of the platform version.</p>
        pub fn set_platform_status(
            mut self,
            input: std::option::Option<crate::model::PlatformStatus>,
        ) -> Self {
            self.platform_status = input;
            self
        }
        /// <p>The date when the platform version was created.</p>
        pub fn date_created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The date when the platform version was created.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The date when the platform version was last updated.</p>
        pub fn date_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date_updated = Some(input);
            self
        }
        /// <p>The date when the platform version was last updated.</p>
        pub fn set_date_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.date_updated = input;
            self
        }
        /// <p>The category of the platform version.</p>
        pub fn platform_category(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_category = Some(input.into());
            self
        }
        /// <p>The category of the platform version.</p>
        pub fn set_platform_category(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_category = input;
            self
        }
        /// <p>The description of the platform version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the platform version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Information about the maintainer of the platform version.</p>
        pub fn maintainer(mut self, input: impl Into<std::string::String>) -> Self {
            self.maintainer = Some(input.into());
            self
        }
        /// <p>Information about the maintainer of the platform version.</p>
        pub fn set_maintainer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.maintainer = input;
            self
        }
        /// <p>The operating system used by the platform version.</p>
        pub fn operating_system_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operating_system_name = Some(input.into());
            self
        }
        /// <p>The operating system used by the platform version.</p>
        pub fn set_operating_system_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operating_system_name = input;
            self
        }
        /// <p>The version of the operating system used by the platform version.</p>
        pub fn operating_system_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.operating_system_version = Some(input.into());
            self
        }
        /// <p>The version of the operating system used by the platform version.</p>
        pub fn set_operating_system_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operating_system_version = input;
            self
        }
        /// Appends an item to `programming_languages`.
        ///
        /// To override the contents of this collection use [`set_programming_languages`](Self::set_programming_languages).
        ///
        /// <p>The programming languages supported by the platform version.</p>
        pub fn programming_languages(
            mut self,
            input: impl Into<crate::model::PlatformProgrammingLanguage>,
        ) -> Self {
            let mut v = self.programming_languages.unwrap_or_default();
            v.push(input.into());
            self.programming_languages = Some(v);
            self
        }
        /// <p>The programming languages supported by the platform version.</p>
        pub fn set_programming_languages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformProgrammingLanguage>>,
        ) -> Self {
            self.programming_languages = input;
            self
        }
        /// Appends an item to `frameworks`.
        ///
        /// To override the contents of this collection use [`set_frameworks`](Self::set_frameworks).
        ///
        /// <p>The frameworks supported by the platform version.</p>
        pub fn frameworks(mut self, input: impl Into<crate::model::PlatformFramework>) -> Self {
            let mut v = self.frameworks.unwrap_or_default();
            v.push(input.into());
            self.frameworks = Some(v);
            self
        }
        /// <p>The frameworks supported by the platform version.</p>
        pub fn set_frameworks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformFramework>>,
        ) -> Self {
            self.frameworks = input;
            self
        }
        /// Appends an item to `custom_ami_list`.
        ///
        /// To override the contents of this collection use [`set_custom_ami_list`](Self::set_custom_ami_list).
        ///
        /// <p>The custom AMIs supported by the platform version.</p>
        pub fn custom_ami_list(mut self, input: impl Into<crate::model::CustomAmi>) -> Self {
            let mut v = self.custom_ami_list.unwrap_or_default();
            v.push(input.into());
            self.custom_ami_list = Some(v);
            self
        }
        /// <p>The custom AMIs supported by the platform version.</p>
        pub fn set_custom_ami_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomAmi>>,
        ) -> Self {
            self.custom_ami_list = input;
            self
        }
        /// Appends an item to `supported_tier_list`.
        ///
        /// To override the contents of this collection use [`set_supported_tier_list`](Self::set_supported_tier_list).
        ///
        /// <p>The tiers supported by the platform version.</p>
        pub fn supported_tier_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_tier_list.unwrap_or_default();
            v.push(input.into());
            self.supported_tier_list = Some(v);
            self
        }
        /// <p>The tiers supported by the platform version.</p>
        pub fn set_supported_tier_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_tier_list = input;
            self
        }
        /// Appends an item to `supported_addon_list`.
        ///
        /// To override the contents of this collection use [`set_supported_addon_list`](Self::set_supported_addon_list).
        ///
        /// <p>The additions supported by the platform version.</p>
        pub fn supported_addon_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_addon_list.unwrap_or_default();
            v.push(input.into());
            self.supported_addon_list = Some(v);
            self
        }
        /// <p>The additions supported by the platform version.</p>
        pub fn set_supported_addon_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_addon_list = input;
            self
        }
        /// <p>The state of the platform version in its lifecycle.</p>
        /// <p>Possible values: <code>Recommended</code> | <code>null</code>
        /// </p>
        /// <p>If a null value is returned, the platform version isn't the recommended one for its
        /// branch. Each platform branch has a single recommended platform version, typically the most
        /// recent one.</p>
        pub fn platform_lifecycle_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_lifecycle_state = Some(input.into());
            self
        }
        /// <p>The state of the platform version in its lifecycle.</p>
        /// <p>Possible values: <code>Recommended</code> | <code>null</code>
        /// </p>
        /// <p>If a null value is returned, the platform version isn't the recommended one for its
        /// branch. Each platform branch has a single recommended platform version, typically the most
        /// recent one.</p>
        pub fn set_platform_lifecycle_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_lifecycle_state = input;
            self
        }
        /// <p>The platform branch to which the platform version belongs.</p>
        pub fn platform_branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_branch_name = Some(input.into());
            self
        }
        /// <p>The platform branch to which the platform version belongs.</p>
        pub fn set_platform_branch_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_branch_name = input;
            self
        }
        /// <p>The state of the platform version's branch in its lifecycle.</p>
        /// <p>Possible values: <code>Beta</code> | <code>Supported</code> | <code>Deprecated</code> |
        /// <code>Retired</code>
        /// </p>
        pub fn platform_branch_lifecycle_state(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.platform_branch_lifecycle_state = Some(input.into());
            self
        }
        /// <p>The state of the platform version's branch in its lifecycle.</p>
        /// <p>Possible values: <code>Beta</code> | <code>Supported</code> | <code>Deprecated</code> |
        /// <code>Retired</code>
        /// </p>
        pub fn set_platform_branch_lifecycle_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_branch_lifecycle_state = input;
            self
        }
        /// Consumes the builder and constructs a [`PlatformDescription`](crate::model::PlatformDescription)
        pub fn build(self) -> crate::model::PlatformDescription {
            crate::model::PlatformDescription {
                platform_arn: self.platform_arn,
                platform_owner: self.platform_owner,
                platform_name: self.platform_name,
                platform_version: self.platform_version,
                solution_stack_name: self.solution_stack_name,
                platform_status: self.platform_status,
                date_created: self.date_created,
                date_updated: self.date_updated,
                platform_category: self.platform_category,
                description: self.description,
                maintainer: self.maintainer,
                operating_system_name: self.operating_system_name,
                operating_system_version: self.operating_system_version,
                programming_languages: self.programming_languages,
                frameworks: self.frameworks,
                custom_ami_list: self.custom_ami_list,
                supported_tier_list: self.supported_tier_list,
                supported_addon_list: self.supported_addon_list,
                platform_lifecycle_state: self.platform_lifecycle_state,
                platform_branch_name: self.platform_branch_name,
                platform_branch_lifecycle_state: self.platform_branch_lifecycle_state,
            }
        }
    }
}
impl PlatformDescription {
    /// Creates a new builder-style object to manufacture [`PlatformDescription`](crate::model::PlatformDescription)
    pub fn builder() -> crate::model::platform_description::Builder {
        crate::model::platform_description::Builder::default()
    }
}

/// <p>A custom AMI available to platforms.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomAmi {
    /// <p>The type of virtualization used to create the custom AMI.</p>
    pub virtualization_type: std::option::Option<std::string::String>,
    /// <p>THe ID of the image used to create the custom AMI.</p>
    pub image_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CustomAmi {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomAmi");
        formatter.field("virtualization_type", &self.virtualization_type);
        formatter.field("image_id", &self.image_id);
        formatter.finish()
    }
}
/// See [`CustomAmi`](crate::model::CustomAmi)
pub mod custom_ami {
    /// A builder for [`CustomAmi`](crate::model::CustomAmi)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtualization_type: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of virtualization used to create the custom AMI.</p>
        pub fn virtualization_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtualization_type = Some(input.into());
            self
        }
        /// <p>The type of virtualization used to create the custom AMI.</p>
        pub fn set_virtualization_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtualization_type = input;
            self
        }
        /// <p>THe ID of the image used to create the custom AMI.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>THe ID of the image used to create the custom AMI.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomAmi`](crate::model::CustomAmi)
        pub fn build(self) -> crate::model::CustomAmi {
            crate::model::CustomAmi {
                virtualization_type: self.virtualization_type,
                image_id: self.image_id,
            }
        }
    }
}
impl CustomAmi {
    /// Creates a new builder-style object to manufacture [`CustomAmi`](crate::model::CustomAmi)
    pub fn builder() -> crate::model::custom_ami::Builder {
        crate::model::custom_ami::Builder::default()
    }
}

/// <p>A framework supported by the platform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlatformFramework {
    /// <p>The name of the framework.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the framework.</p>
    pub version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PlatformFramework {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlatformFramework");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`PlatformFramework`](crate::model::PlatformFramework)
pub mod platform_framework {
    /// A builder for [`PlatformFramework`](crate::model::PlatformFramework)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the framework.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the framework.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the framework.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the framework.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`PlatformFramework`](crate::model::PlatformFramework)
        pub fn build(self) -> crate::model::PlatformFramework {
            crate::model::PlatformFramework {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl PlatformFramework {
    /// Creates a new builder-style object to manufacture [`PlatformFramework`](crate::model::PlatformFramework)
    pub fn builder() -> crate::model::platform_framework::Builder {
        crate::model::platform_framework::Builder::default()
    }
}

/// <p>A programming language supported by the platform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlatformProgrammingLanguage {
    /// <p>The name of the programming language.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the programming language.</p>
    pub version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PlatformProgrammingLanguage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlatformProgrammingLanguage");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`PlatformProgrammingLanguage`](crate::model::PlatformProgrammingLanguage)
pub mod platform_programming_language {
    /// A builder for [`PlatformProgrammingLanguage`](crate::model::PlatformProgrammingLanguage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the programming language.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the programming language.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the programming language.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the programming language.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`PlatformProgrammingLanguage`](crate::model::PlatformProgrammingLanguage)
        pub fn build(self) -> crate::model::PlatformProgrammingLanguage {
            crate::model::PlatformProgrammingLanguage {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl PlatformProgrammingLanguage {
    /// Creates a new builder-style object to manufacture [`PlatformProgrammingLanguage`](crate::model::PlatformProgrammingLanguage)
    pub fn builder() -> crate::model::platform_programming_language::Builder {
        crate::model::platform_programming_language::Builder::default()
    }
}

/// <p>Detailed health information about an Amazon EC2 instance in your Elastic Beanstalk
/// environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SingleInstanceHealth {
    /// <p>The ID of the Amazon EC2 instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>Returns the health status of the specified instance. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health
    /// Colors and Statuses</a>.</p>
    pub health_status: std::option::Option<std::string::String>,
    /// <p>Represents the color indicator that gives you information about the health of the EC2
    /// instance. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and
    /// Statuses</a>.</p>
    pub color: std::option::Option<std::string::String>,
    /// <p>Represents the causes, which provide more information about the current health
    /// status.</p>
    pub causes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time at which the EC2 instance was launched.</p>
    pub launched_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Request metrics from your application.</p>
    pub application_metrics: std::option::Option<crate::model::ApplicationMetrics>,
    /// <p>Operating system metrics from the instance.</p>
    pub system: std::option::Option<crate::model::SystemStatus>,
    /// <p>Information about the most recent deployment to an instance.</p>
    pub deployment: std::option::Option<crate::model::Deployment>,
    /// <p>The availability zone in which the instance runs.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The instance's type.</p>
    pub instance_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SingleInstanceHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SingleInstanceHealth");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("health_status", &self.health_status);
        formatter.field("color", &self.color);
        formatter.field("causes", &self.causes);
        formatter.field("launched_at", &self.launched_at);
        formatter.field("application_metrics", &self.application_metrics);
        formatter.field("system", &self.system);
        formatter.field("deployment", &self.deployment);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("instance_type", &self.instance_type);
        formatter.finish()
    }
}
/// See [`SingleInstanceHealth`](crate::model::SingleInstanceHealth)
pub mod single_instance_health {
    /// A builder for [`SingleInstanceHealth`](crate::model::SingleInstanceHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) health_status: std::option::Option<std::string::String>,
        pub(crate) color: std::option::Option<std::string::String>,
        pub(crate) causes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) launched_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) application_metrics: std::option::Option<crate::model::ApplicationMetrics>,
        pub(crate) system: std::option::Option<crate::model::SystemStatus>,
        pub(crate) deployment: std::option::Option<crate::model::Deployment>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon EC2 instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EC2 instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>Returns the health status of the specified instance. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health
        /// Colors and Statuses</a>.</p>
        pub fn health_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_status = Some(input.into());
            self
        }
        /// <p>Returns the health status of the specified instance. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health
        /// Colors and Statuses</a>.</p>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// <p>Represents the color indicator that gives you information about the health of the EC2
        /// instance. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and
        /// Statuses</a>.</p>
        pub fn color(mut self, input: impl Into<std::string::String>) -> Self {
            self.color = Some(input.into());
            self
        }
        /// <p>Represents the color indicator that gives you information about the health of the EC2
        /// instance. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and
        /// Statuses</a>.</p>
        pub fn set_color(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.color = input;
            self
        }
        /// Appends an item to `causes`.
        ///
        /// To override the contents of this collection use [`set_causes`](Self::set_causes).
        ///
        /// <p>Represents the causes, which provide more information about the current health
        /// status.</p>
        pub fn causes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.causes.unwrap_or_default();
            v.push(input.into());
            self.causes = Some(v);
            self
        }
        /// <p>Represents the causes, which provide more information about the current health
        /// status.</p>
        pub fn set_causes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.causes = input;
            self
        }
        /// <p>The time at which the EC2 instance was launched.</p>
        pub fn launched_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.launched_at = Some(input);
            self
        }
        /// <p>The time at which the EC2 instance was launched.</p>
        pub fn set_launched_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.launched_at = input;
            self
        }
        /// <p>Request metrics from your application.</p>
        pub fn application_metrics(mut self, input: crate::model::ApplicationMetrics) -> Self {
            self.application_metrics = Some(input);
            self
        }
        /// <p>Request metrics from your application.</p>
        pub fn set_application_metrics(
            mut self,
            input: std::option::Option<crate::model::ApplicationMetrics>,
        ) -> Self {
            self.application_metrics = input;
            self
        }
        /// <p>Operating system metrics from the instance.</p>
        pub fn system(mut self, input: crate::model::SystemStatus) -> Self {
            self.system = Some(input);
            self
        }
        /// <p>Operating system metrics from the instance.</p>
        pub fn set_system(
            mut self,
            input: std::option::Option<crate::model::SystemStatus>,
        ) -> Self {
            self.system = input;
            self
        }
        /// <p>Information about the most recent deployment to an instance.</p>
        pub fn deployment(mut self, input: crate::model::Deployment) -> Self {
            self.deployment = Some(input);
            self
        }
        /// <p>Information about the most recent deployment to an instance.</p>
        pub fn set_deployment(
            mut self,
            input: std::option::Option<crate::model::Deployment>,
        ) -> Self {
            self.deployment = input;
            self
        }
        /// <p>The availability zone in which the instance runs.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The availability zone in which the instance runs.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The instance's type.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance's type.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SingleInstanceHealth`](crate::model::SingleInstanceHealth)
        pub fn build(self) -> crate::model::SingleInstanceHealth {
            crate::model::SingleInstanceHealth {
                instance_id: self.instance_id,
                health_status: self.health_status,
                color: self.color,
                causes: self.causes,
                launched_at: self.launched_at,
                application_metrics: self.application_metrics,
                system: self.system,
                deployment: self.deployment,
                availability_zone: self.availability_zone,
                instance_type: self.instance_type,
            }
        }
    }
}
impl SingleInstanceHealth {
    /// Creates a new builder-style object to manufacture [`SingleInstanceHealth`](crate::model::SingleInstanceHealth)
    pub fn builder() -> crate::model::single_instance_health::Builder {
        crate::model::single_instance_health::Builder::default()
    }
}

/// <p>Information about an application version deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Deployment {
    /// <p>The version label of the application version in the deployment.</p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p>The ID of the deployment. This number increases by one each time that you deploy source
    /// code or change instance configuration settings.</p>
    pub deployment_id: std::option::Option<i64>,
    /// <p>The status of the deployment:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>In Progress</code> : The deployment is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Deployed</code> : The deployment succeeded.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code> : The deployment failed.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>For in-progress deployments, the time that the deployment started.</p>
    /// <p>For completed deployments, the time that the deployment ended.</p>
    pub deployment_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for Deployment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Deployment");
        formatter.field("version_label", &self.version_label);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("status", &self.status);
        formatter.field("deployment_time", &self.deployment_time);
        formatter.finish()
    }
}
/// See [`Deployment`](crate::model::Deployment)
pub mod deployment {
    /// A builder for [`Deployment`](crate::model::Deployment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<i64>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) deployment_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The version label of the application version in the deployment.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>The version label of the application version in the deployment.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// <p>The ID of the deployment. This number increases by one each time that you deploy source
        /// code or change instance configuration settings.</p>
        pub fn deployment_id(mut self, input: i64) -> Self {
            self.deployment_id = Some(input);
            self
        }
        /// <p>The ID of the deployment. This number increases by one each time that you deploy source
        /// code or change instance configuration settings.</p>
        pub fn set_deployment_id(mut self, input: std::option::Option<i64>) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The status of the deployment:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>In Progress</code> : The deployment is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deployed</code> : The deployment succeeded.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> : The deployment failed.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the deployment:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>In Progress</code> : The deployment is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deployed</code> : The deployment succeeded.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> : The deployment failed.</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>For in-progress deployments, the time that the deployment started.</p>
        /// <p>For completed deployments, the time that the deployment ended.</p>
        pub fn deployment_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.deployment_time = Some(input);
            self
        }
        /// <p>For in-progress deployments, the time that the deployment started.</p>
        /// <p>For completed deployments, the time that the deployment ended.</p>
        pub fn set_deployment_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.deployment_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Deployment`](crate::model::Deployment)
        pub fn build(self) -> crate::model::Deployment {
            crate::model::Deployment {
                version_label: self.version_label,
                deployment_id: self.deployment_id,
                status: self.status,
                deployment_time: self.deployment_time,
            }
        }
    }
}
impl Deployment {
    /// Creates a new builder-style object to manufacture [`Deployment`](crate::model::Deployment)
    pub fn builder() -> crate::model::deployment::Builder {
        crate::model::deployment::Builder::default()
    }
}

/// <p>CPU utilization and load average metrics for an Amazon EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemStatus {
    /// <p>CPU utilization metrics for the instance.</p>
    pub cpu_utilization: std::option::Option<crate::model::CpuUtilization>,
    /// <p>Load average in the last 1-minute, 5-minute, and 15-minute periods.
    /// For more information, see
    /// <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-metrics.html#health-enhanced-metrics-os">Operating System Metrics</a>.</p>
    pub load_average: std::option::Option<std::vec::Vec<f64>>,
}
impl std::fmt::Debug for SystemStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemStatus");
        formatter.field("cpu_utilization", &self.cpu_utilization);
        formatter.field("load_average", &self.load_average);
        formatter.finish()
    }
}
/// See [`SystemStatus`](crate::model::SystemStatus)
pub mod system_status {
    /// A builder for [`SystemStatus`](crate::model::SystemStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpu_utilization: std::option::Option<crate::model::CpuUtilization>,
        pub(crate) load_average: std::option::Option<std::vec::Vec<f64>>,
    }
    impl Builder {
        /// <p>CPU utilization metrics for the instance.</p>
        pub fn cpu_utilization(mut self, input: crate::model::CpuUtilization) -> Self {
            self.cpu_utilization = Some(input);
            self
        }
        /// <p>CPU utilization metrics for the instance.</p>
        pub fn set_cpu_utilization(
            mut self,
            input: std::option::Option<crate::model::CpuUtilization>,
        ) -> Self {
            self.cpu_utilization = input;
            self
        }
        /// Appends an item to `load_average`.
        ///
        /// To override the contents of this collection use [`set_load_average`](Self::set_load_average).
        ///
        /// <p>Load average in the last 1-minute, 5-minute, and 15-minute periods.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-metrics.html#health-enhanced-metrics-os">Operating System Metrics</a>.</p>
        pub fn load_average(mut self, input: impl Into<f64>) -> Self {
            let mut v = self.load_average.unwrap_or_default();
            v.push(input.into());
            self.load_average = Some(v);
            self
        }
        /// <p>Load average in the last 1-minute, 5-minute, and 15-minute periods.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-metrics.html#health-enhanced-metrics-os">Operating System Metrics</a>.</p>
        pub fn set_load_average(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.load_average = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemStatus`](crate::model::SystemStatus)
        pub fn build(self) -> crate::model::SystemStatus {
            crate::model::SystemStatus {
                cpu_utilization: self.cpu_utilization,
                load_average: self.load_average,
            }
        }
    }
}
impl SystemStatus {
    /// Creates a new builder-style object to manufacture [`SystemStatus`](crate::model::SystemStatus)
    pub fn builder() -> crate::model::system_status::Builder {
        crate::model::system_status::Builder::default()
    }
}

/// <p>CPU utilization metrics for an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CpuUtilization {
    /// <p>Percentage of time that the CPU has spent in the <code>User</code> state over the last
    /// 10 seconds.</p>
    pub user: std::option::Option<f64>,
    /// <p>Available on Linux environments only.</p>
    /// <p>Percentage of time that the CPU has spent in the <code>Nice</code> state over the last
    /// 10 seconds.</p>
    pub nice: std::option::Option<f64>,
    /// <p>Available on Linux environments only.</p>
    /// <p>Percentage of time that the CPU has spent in the <code>System</code> state over the
    /// last 10 seconds.</p>
    pub system: std::option::Option<f64>,
    /// <p>Percentage of time that the CPU has spent in the <code>Idle</code> state over the last
    /// 10 seconds.</p>
    pub idle: std::option::Option<f64>,
    /// <p>Available on Linux environments only.</p>
    /// <p>Percentage of time that the CPU has spent in the <code>I/O Wait</code> state over the
    /// last 10 seconds.</p>
    pub io_wait: std::option::Option<f64>,
    /// <p>Available on Linux environments only.</p>
    /// <p>Percentage of time that the CPU has spent in the <code>IRQ</code> state over the last
    /// 10 seconds.</p>
    pub irq: std::option::Option<f64>,
    /// <p>Available on Linux environments only.</p>
    /// <p>Percentage of time that the CPU has spent in the <code>SoftIRQ</code> state over the
    /// last 10 seconds.</p>
    pub soft_irq: std::option::Option<f64>,
    /// <p>Available on Windows environments only.</p>
    /// <p>Percentage of time that the CPU has spent in the <code>Privileged</code> state over the
    /// last 10 seconds.</p>
    pub privileged: std::option::Option<f64>,
}
impl std::fmt::Debug for CpuUtilization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CpuUtilization");
        formatter.field("user", &self.user);
        formatter.field("nice", &self.nice);
        formatter.field("system", &self.system);
        formatter.field("idle", &self.idle);
        formatter.field("io_wait", &self.io_wait);
        formatter.field("irq", &self.irq);
        formatter.field("soft_irq", &self.soft_irq);
        formatter.field("privileged", &self.privileged);
        formatter.finish()
    }
}
/// See [`CpuUtilization`](crate::model::CpuUtilization)
pub mod cpu_utilization {
    /// A builder for [`CpuUtilization`](crate::model::CpuUtilization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user: std::option::Option<f64>,
        pub(crate) nice: std::option::Option<f64>,
        pub(crate) system: std::option::Option<f64>,
        pub(crate) idle: std::option::Option<f64>,
        pub(crate) io_wait: std::option::Option<f64>,
        pub(crate) irq: std::option::Option<f64>,
        pub(crate) soft_irq: std::option::Option<f64>,
        pub(crate) privileged: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>Percentage of time that the CPU has spent in the <code>User</code> state over the last
        /// 10 seconds.</p>
        pub fn user(mut self, input: f64) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>Percentage of time that the CPU has spent in the <code>User</code> state over the last
        /// 10 seconds.</p>
        pub fn set_user(mut self, input: std::option::Option<f64>) -> Self {
            self.user = input;
            self
        }
        /// <p>Available on Linux environments only.</p>
        /// <p>Percentage of time that the CPU has spent in the <code>Nice</code> state over the last
        /// 10 seconds.</p>
        pub fn nice(mut self, input: f64) -> Self {
            self.nice = Some(input);
            self
        }
        /// <p>Available on Linux environments only.</p>
        /// <p>Percentage of time that the CPU has spent in the <code>Nice</code> state over the last
        /// 10 seconds.</p>
        pub fn set_nice(mut self, input: std::option::Option<f64>) -> Self {
            self.nice = input;
            self
        }
        /// <p>Available on Linux environments only.</p>
        /// <p>Percentage of time that the CPU has spent in the <code>System</code> state over the
        /// last 10 seconds.</p>
        pub fn system(mut self, input: f64) -> Self {
            self.system = Some(input);
            self
        }
        /// <p>Available on Linux environments only.</p>
        /// <p>Percentage of time that the CPU has spent in the <code>System</code> state over the
        /// last 10 seconds.</p>
        pub fn set_system(mut self, input: std::option::Option<f64>) -> Self {
            self.system = input;
            self
        }
        /// <p>Percentage of time that the CPU has spent in the <code>Idle</code> state over the last
        /// 10 seconds.</p>
        pub fn idle(mut self, input: f64) -> Self {
            self.idle = Some(input);
            self
        }
        /// <p>Percentage of time that the CPU has spent in the <code>Idle</code> state over the last
        /// 10 seconds.</p>
        pub fn set_idle(mut self, input: std::option::Option<f64>) -> Self {
            self.idle = input;
            self
        }
        /// <p>Available on Linux environments only.</p>
        /// <p>Percentage of time that the CPU has spent in the <code>I/O Wait</code> state over the
        /// last 10 seconds.</p>
        pub fn io_wait(mut self, input: f64) -> Self {
            self.io_wait = Some(input);
            self
        }
        /// <p>Available on Linux environments only.</p>
        /// <p>Percentage of time that the CPU has spent in the <code>I/O Wait</code> state over the
        /// last 10 seconds.</p>
        pub fn set_io_wait(mut self, input: std::option::Option<f64>) -> Self {
            self.io_wait = input;
            self
        }
        /// <p>Available on Linux environments only.</p>
        /// <p>Percentage of time that the CPU has spent in the <code>IRQ</code> state over the last
        /// 10 seconds.</p>
        pub fn irq(mut self, input: f64) -> Self {
            self.irq = Some(input);
            self
        }
        /// <p>Available on Linux environments only.</p>
        /// <p>Percentage of time that the CPU has spent in the <code>IRQ</code> state over the last
        /// 10 seconds.</p>
        pub fn set_irq(mut self, input: std::option::Option<f64>) -> Self {
            self.irq = input;
            self
        }
        /// <p>Available on Linux environments only.</p>
        /// <p>Percentage of time that the CPU has spent in the <code>SoftIRQ</code> state over the
        /// last 10 seconds.</p>
        pub fn soft_irq(mut self, input: f64) -> Self {
            self.soft_irq = Some(input);
            self
        }
        /// <p>Available on Linux environments only.</p>
        /// <p>Percentage of time that the CPU has spent in the <code>SoftIRQ</code> state over the
        /// last 10 seconds.</p>
        pub fn set_soft_irq(mut self, input: std::option::Option<f64>) -> Self {
            self.soft_irq = input;
            self
        }
        /// <p>Available on Windows environments only.</p>
        /// <p>Percentage of time that the CPU has spent in the <code>Privileged</code> state over the
        /// last 10 seconds.</p>
        pub fn privileged(mut self, input: f64) -> Self {
            self.privileged = Some(input);
            self
        }
        /// <p>Available on Windows environments only.</p>
        /// <p>Percentage of time that the CPU has spent in the <code>Privileged</code> state over the
        /// last 10 seconds.</p>
        pub fn set_privileged(mut self, input: std::option::Option<f64>) -> Self {
            self.privileged = input;
            self
        }
        /// Consumes the builder and constructs a [`CpuUtilization`](crate::model::CpuUtilization)
        pub fn build(self) -> crate::model::CpuUtilization {
            crate::model::CpuUtilization {
                user: self.user,
                nice: self.nice,
                system: self.system,
                idle: self.idle,
                io_wait: self.io_wait,
                irq: self.irq,
                soft_irq: self.soft_irq,
                privileged: self.privileged,
            }
        }
    }
}
impl CpuUtilization {
    /// Creates a new builder-style object to manufacture [`CpuUtilization`](crate::model::CpuUtilization)
    pub fn builder() -> crate::model::cpu_utilization::Builder {
        crate::model::cpu_utilization::Builder::default()
    }
}

/// <p>Application request metrics for an AWS Elastic Beanstalk environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationMetrics {
    /// <p>The amount of time that the metrics cover (usually 10 seconds). For example, you might
    /// have 5 requests (<code>request_count</code>) within the most recent time slice of 10 seconds
    /// (<code>duration</code>).</p>
    pub duration: std::option::Option<i32>,
    /// <p>Average number of requests handled by the web server per second over the last 10
    /// seconds.</p>
    pub request_count: i32,
    /// <p>Represents the percentage of requests over the last 10 seconds that resulted in each
    /// type of status code response.</p>
    pub status_codes: std::option::Option<crate::model::StatusCodes>,
    /// <p>Represents the average latency for the slowest X percent of requests over the last 10
    /// seconds. Latencies are in seconds with one millisecond resolution.</p>
    pub latency: std::option::Option<crate::model::Latency>,
}
impl std::fmt::Debug for ApplicationMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationMetrics");
        formatter.field("duration", &self.duration);
        formatter.field("request_count", &self.request_count);
        formatter.field("status_codes", &self.status_codes);
        formatter.field("latency", &self.latency);
        formatter.finish()
    }
}
/// See [`ApplicationMetrics`](crate::model::ApplicationMetrics)
pub mod application_metrics {
    /// A builder for [`ApplicationMetrics`](crate::model::ApplicationMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) request_count: std::option::Option<i32>,
        pub(crate) status_codes: std::option::Option<crate::model::StatusCodes>,
        pub(crate) latency: std::option::Option<crate::model::Latency>,
    }
    impl Builder {
        /// <p>The amount of time that the metrics cover (usually 10 seconds). For example, you might
        /// have 5 requests (<code>request_count</code>) within the most recent time slice of 10 seconds
        /// (<code>duration</code>).</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The amount of time that the metrics cover (usually 10 seconds). For example, you might
        /// have 5 requests (<code>request_count</code>) within the most recent time slice of 10 seconds
        /// (<code>duration</code>).</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>Average number of requests handled by the web server per second over the last 10
        /// seconds.</p>
        pub fn request_count(mut self, input: i32) -> Self {
            self.request_count = Some(input);
            self
        }
        /// <p>Average number of requests handled by the web server per second over the last 10
        /// seconds.</p>
        pub fn set_request_count(mut self, input: std::option::Option<i32>) -> Self {
            self.request_count = input;
            self
        }
        /// <p>Represents the percentage of requests over the last 10 seconds that resulted in each
        /// type of status code response.</p>
        pub fn status_codes(mut self, input: crate::model::StatusCodes) -> Self {
            self.status_codes = Some(input);
            self
        }
        /// <p>Represents the percentage of requests over the last 10 seconds that resulted in each
        /// type of status code response.</p>
        pub fn set_status_codes(
            mut self,
            input: std::option::Option<crate::model::StatusCodes>,
        ) -> Self {
            self.status_codes = input;
            self
        }
        /// <p>Represents the average latency for the slowest X percent of requests over the last 10
        /// seconds. Latencies are in seconds with one millisecond resolution.</p>
        pub fn latency(mut self, input: crate::model::Latency) -> Self {
            self.latency = Some(input);
            self
        }
        /// <p>Represents the average latency for the slowest X percent of requests over the last 10
        /// seconds. Latencies are in seconds with one millisecond resolution.</p>
        pub fn set_latency(mut self, input: std::option::Option<crate::model::Latency>) -> Self {
            self.latency = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationMetrics`](crate::model::ApplicationMetrics)
        pub fn build(self) -> crate::model::ApplicationMetrics {
            crate::model::ApplicationMetrics {
                duration: self.duration,
                request_count: self.request_count.unwrap_or_default(),
                status_codes: self.status_codes,
                latency: self.latency,
            }
        }
    }
}
impl ApplicationMetrics {
    /// Creates a new builder-style object to manufacture [`ApplicationMetrics`](crate::model::ApplicationMetrics)
    pub fn builder() -> crate::model::application_metrics::Builder {
        crate::model::application_metrics::Builder::default()
    }
}

/// <p>Represents the average latency for the slowest X percent of requests over the last 10
/// seconds.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Latency {
    /// <p>The average latency for the slowest 0.1 percent of requests over the last 10
    /// seconds.</p>
    pub p999: std::option::Option<f64>,
    /// <p>The average latency for the slowest 1 percent of requests over the last 10
    /// seconds.</p>
    pub p99: std::option::Option<f64>,
    /// <p>The average latency for the slowest 5 percent of requests over the last 10
    /// seconds.</p>
    pub p95: std::option::Option<f64>,
    /// <p>The average latency for the slowest 10 percent of requests over the last 10
    /// seconds.</p>
    pub p90: std::option::Option<f64>,
    /// <p>The average latency for the slowest 15 percent of requests over the last 10
    /// seconds.</p>
    pub p85: std::option::Option<f64>,
    /// <p>The average latency for the slowest 25 percent of requests over the last 10
    /// seconds.</p>
    pub p75: std::option::Option<f64>,
    /// <p>The average latency for the slowest 50 percent of requests over the last 10
    /// seconds.</p>
    pub p50: std::option::Option<f64>,
    /// <p>The average latency for the slowest 90 percent of requests over the last 10
    /// seconds.</p>
    pub p10: std::option::Option<f64>,
}
impl std::fmt::Debug for Latency {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Latency");
        formatter.field("p999", &self.p999);
        formatter.field("p99", &self.p99);
        formatter.field("p95", &self.p95);
        formatter.field("p90", &self.p90);
        formatter.field("p85", &self.p85);
        formatter.field("p75", &self.p75);
        formatter.field("p50", &self.p50);
        formatter.field("p10", &self.p10);
        formatter.finish()
    }
}
/// See [`Latency`](crate::model::Latency)
pub mod latency {
    /// A builder for [`Latency`](crate::model::Latency)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) p999: std::option::Option<f64>,
        pub(crate) p99: std::option::Option<f64>,
        pub(crate) p95: std::option::Option<f64>,
        pub(crate) p90: std::option::Option<f64>,
        pub(crate) p85: std::option::Option<f64>,
        pub(crate) p75: std::option::Option<f64>,
        pub(crate) p50: std::option::Option<f64>,
        pub(crate) p10: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The average latency for the slowest 0.1 percent of requests over the last 10
        /// seconds.</p>
        pub fn p999(mut self, input: f64) -> Self {
            self.p999 = Some(input);
            self
        }
        /// <p>The average latency for the slowest 0.1 percent of requests over the last 10
        /// seconds.</p>
        pub fn set_p999(mut self, input: std::option::Option<f64>) -> Self {
            self.p999 = input;
            self
        }
        /// <p>The average latency for the slowest 1 percent of requests over the last 10
        /// seconds.</p>
        pub fn p99(mut self, input: f64) -> Self {
            self.p99 = Some(input);
            self
        }
        /// <p>The average latency for the slowest 1 percent of requests over the last 10
        /// seconds.</p>
        pub fn set_p99(mut self, input: std::option::Option<f64>) -> Self {
            self.p99 = input;
            self
        }
        /// <p>The average latency for the slowest 5 percent of requests over the last 10
        /// seconds.</p>
        pub fn p95(mut self, input: f64) -> Self {
            self.p95 = Some(input);
            self
        }
        /// <p>The average latency for the slowest 5 percent of requests over the last 10
        /// seconds.</p>
        pub fn set_p95(mut self, input: std::option::Option<f64>) -> Self {
            self.p95 = input;
            self
        }
        /// <p>The average latency for the slowest 10 percent of requests over the last 10
        /// seconds.</p>
        pub fn p90(mut self, input: f64) -> Self {
            self.p90 = Some(input);
            self
        }
        /// <p>The average latency for the slowest 10 percent of requests over the last 10
        /// seconds.</p>
        pub fn set_p90(mut self, input: std::option::Option<f64>) -> Self {
            self.p90 = input;
            self
        }
        /// <p>The average latency for the slowest 15 percent of requests over the last 10
        /// seconds.</p>
        pub fn p85(mut self, input: f64) -> Self {
            self.p85 = Some(input);
            self
        }
        /// <p>The average latency for the slowest 15 percent of requests over the last 10
        /// seconds.</p>
        pub fn set_p85(mut self, input: std::option::Option<f64>) -> Self {
            self.p85 = input;
            self
        }
        /// <p>The average latency for the slowest 25 percent of requests over the last 10
        /// seconds.</p>
        pub fn p75(mut self, input: f64) -> Self {
            self.p75 = Some(input);
            self
        }
        /// <p>The average latency for the slowest 25 percent of requests over the last 10
        /// seconds.</p>
        pub fn set_p75(mut self, input: std::option::Option<f64>) -> Self {
            self.p75 = input;
            self
        }
        /// <p>The average latency for the slowest 50 percent of requests over the last 10
        /// seconds.</p>
        pub fn p50(mut self, input: f64) -> Self {
            self.p50 = Some(input);
            self
        }
        /// <p>The average latency for the slowest 50 percent of requests over the last 10
        /// seconds.</p>
        pub fn set_p50(mut self, input: std::option::Option<f64>) -> Self {
            self.p50 = input;
            self
        }
        /// <p>The average latency for the slowest 90 percent of requests over the last 10
        /// seconds.</p>
        pub fn p10(mut self, input: f64) -> Self {
            self.p10 = Some(input);
            self
        }
        /// <p>The average latency for the slowest 90 percent of requests over the last 10
        /// seconds.</p>
        pub fn set_p10(mut self, input: std::option::Option<f64>) -> Self {
            self.p10 = input;
            self
        }
        /// Consumes the builder and constructs a [`Latency`](crate::model::Latency)
        pub fn build(self) -> crate::model::Latency {
            crate::model::Latency {
                p999: self.p999,
                p99: self.p99,
                p95: self.p95,
                p90: self.p90,
                p85: self.p85,
                p75: self.p75,
                p50: self.p50,
                p10: self.p10,
            }
        }
    }
}
impl Latency {
    /// Creates a new builder-style object to manufacture [`Latency`](crate::model::Latency)
    pub fn builder() -> crate::model::latency::Builder {
        crate::model::latency::Builder::default()
    }
}

/// <p>Represents the percentage of requests over the last 10 seconds that resulted in each
/// type of status code response. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html">Status Code
/// Definitions</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatusCodes {
    /// <p>The percentage of requests over the last 10 seconds that resulted in a 2xx (200, 201,
    /// etc.) status code.</p>
    pub status2xx: std::option::Option<i32>,
    /// <p>The percentage of requests over the last 10 seconds that resulted in a 3xx (300, 301,
    /// etc.) status code.</p>
    pub status3xx: std::option::Option<i32>,
    /// <p>The percentage of requests over the last 10 seconds that resulted in a 4xx (400, 401,
    /// etc.) status code.</p>
    pub status4xx: std::option::Option<i32>,
    /// <p>The percentage of requests over the last 10 seconds that resulted in a 5xx (500, 501,
    /// etc.) status code.</p>
    pub status5xx: std::option::Option<i32>,
}
impl std::fmt::Debug for StatusCodes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatusCodes");
        formatter.field("status2xx", &self.status2xx);
        formatter.field("status3xx", &self.status3xx);
        formatter.field("status4xx", &self.status4xx);
        formatter.field("status5xx", &self.status5xx);
        formatter.finish()
    }
}
/// See [`StatusCodes`](crate::model::StatusCodes)
pub mod status_codes {
    /// A builder for [`StatusCodes`](crate::model::StatusCodes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status2xx: std::option::Option<i32>,
        pub(crate) status3xx: std::option::Option<i32>,
        pub(crate) status4xx: std::option::Option<i32>,
        pub(crate) status5xx: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The percentage of requests over the last 10 seconds that resulted in a 2xx (200, 201,
        /// etc.) status code.</p>
        pub fn status2xx(mut self, input: i32) -> Self {
            self.status2xx = Some(input);
            self
        }
        /// <p>The percentage of requests over the last 10 seconds that resulted in a 2xx (200, 201,
        /// etc.) status code.</p>
        pub fn set_status2xx(mut self, input: std::option::Option<i32>) -> Self {
            self.status2xx = input;
            self
        }
        /// <p>The percentage of requests over the last 10 seconds that resulted in a 3xx (300, 301,
        /// etc.) status code.</p>
        pub fn status3xx(mut self, input: i32) -> Self {
            self.status3xx = Some(input);
            self
        }
        /// <p>The percentage of requests over the last 10 seconds that resulted in a 3xx (300, 301,
        /// etc.) status code.</p>
        pub fn set_status3xx(mut self, input: std::option::Option<i32>) -> Self {
            self.status3xx = input;
            self
        }
        /// <p>The percentage of requests over the last 10 seconds that resulted in a 4xx (400, 401,
        /// etc.) status code.</p>
        pub fn status4xx(mut self, input: i32) -> Self {
            self.status4xx = Some(input);
            self
        }
        /// <p>The percentage of requests over the last 10 seconds that resulted in a 4xx (400, 401,
        /// etc.) status code.</p>
        pub fn set_status4xx(mut self, input: std::option::Option<i32>) -> Self {
            self.status4xx = input;
            self
        }
        /// <p>The percentage of requests over the last 10 seconds that resulted in a 5xx (500, 501,
        /// etc.) status code.</p>
        pub fn status5xx(mut self, input: i32) -> Self {
            self.status5xx = Some(input);
            self
        }
        /// <p>The percentage of requests over the last 10 seconds that resulted in a 5xx (500, 501,
        /// etc.) status code.</p>
        pub fn set_status5xx(mut self, input: std::option::Option<i32>) -> Self {
            self.status5xx = input;
            self
        }
        /// Consumes the builder and constructs a [`StatusCodes`](crate::model::StatusCodes)
        pub fn build(self) -> crate::model::StatusCodes {
            crate::model::StatusCodes {
                status2xx: self.status2xx,
                status3xx: self.status3xx,
                status4xx: self.status4xx,
                status5xx: self.status5xx,
            }
        }
    }
}
impl StatusCodes {
    /// Creates a new builder-style object to manufacture [`StatusCodes`](crate::model::StatusCodes)
    pub fn builder() -> crate::model::status_codes::Builder {
        crate::model::status_codes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstancesHealthAttribute {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    ApplicationMetrics,
    #[allow(missing_docs)] // documentation missing in model
    AvailabilityZone,
    #[allow(missing_docs)] // documentation missing in model
    Causes,
    #[allow(missing_docs)] // documentation missing in model
    Color,
    #[allow(missing_docs)] // documentation missing in model
    Deployment,
    #[allow(missing_docs)] // documentation missing in model
    HealthStatus,
    #[allow(missing_docs)] // documentation missing in model
    InstanceType,
    #[allow(missing_docs)] // documentation missing in model
    LaunchedAt,
    #[allow(missing_docs)] // documentation missing in model
    RefreshedAt,
    #[allow(missing_docs)] // documentation missing in model
    System,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstancesHealthAttribute {
    fn from(s: &str) -> Self {
        match s {
            "All" => InstancesHealthAttribute::All,
            "ApplicationMetrics" => InstancesHealthAttribute::ApplicationMetrics,
            "AvailabilityZone" => InstancesHealthAttribute::AvailabilityZone,
            "Causes" => InstancesHealthAttribute::Causes,
            "Color" => InstancesHealthAttribute::Color,
            "Deployment" => InstancesHealthAttribute::Deployment,
            "HealthStatus" => InstancesHealthAttribute::HealthStatus,
            "InstanceType" => InstancesHealthAttribute::InstanceType,
            "LaunchedAt" => InstancesHealthAttribute::LaunchedAt,
            "RefreshedAt" => InstancesHealthAttribute::RefreshedAt,
            "System" => InstancesHealthAttribute::System,
            other => InstancesHealthAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstancesHealthAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstancesHealthAttribute::from(s))
    }
}
impl InstancesHealthAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstancesHealthAttribute::All => "All",
            InstancesHealthAttribute::ApplicationMetrics => "ApplicationMetrics",
            InstancesHealthAttribute::AvailabilityZone => "AvailabilityZone",
            InstancesHealthAttribute::Causes => "Causes",
            InstancesHealthAttribute::Color => "Color",
            InstancesHealthAttribute::Deployment => "Deployment",
            InstancesHealthAttribute::HealthStatus => "HealthStatus",
            InstancesHealthAttribute::InstanceType => "InstanceType",
            InstancesHealthAttribute::LaunchedAt => "LaunchedAt",
            InstancesHealthAttribute::RefreshedAt => "RefreshedAt",
            InstancesHealthAttribute::System => "System",
            InstancesHealthAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "All",
            "ApplicationMetrics",
            "AvailabilityZone",
            "Causes",
            "Color",
            "Deployment",
            "HealthStatus",
            "InstanceType",
            "LaunchedAt",
            "RefreshedAt",
            "System",
        ]
    }
}
impl AsRef<str> for InstancesHealthAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDescription {
    /// <p>The date when the event occurred.</p>
    pub event_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The event message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The application associated with the event.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The release label for the application version associated with this event.</p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p>The name of the configuration associated with this event.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The name of the environment associated with this event.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the platform version.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>The web service request ID for the activity of this event.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The severity level of this event.</p>
    pub severity: std::option::Option<crate::model::EventSeverity>,
}
impl std::fmt::Debug for EventDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDescription");
        formatter.field("event_date", &self.event_date);
        formatter.field("message", &self.message);
        formatter.field("application_name", &self.application_name);
        formatter.field("version_label", &self.version_label);
        formatter.field("template_name", &self.template_name);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("request_id", &self.request_id);
        formatter.field("severity", &self.severity);
        formatter.finish()
    }
}
/// See [`EventDescription`](crate::model::EventDescription)
pub mod event_description {
    /// A builder for [`EventDescription`](crate::model::EventDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::EventSeverity>,
    }
    impl Builder {
        /// <p>The date when the event occurred.</p>
        pub fn event_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_date = Some(input);
            self
        }
        /// <p>The date when the event occurred.</p>
        pub fn set_event_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_date = input;
            self
        }
        /// <p>The event message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The event message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The application associated with the event.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The application associated with the event.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The release label for the application version associated with this event.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>The release label for the application version associated with this event.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// <p>The name of the configuration associated with this event.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration associated with this event.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The name of the environment associated with this event.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment associated with this event.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// <p>The web service request ID for the activity of this event.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The web service request ID for the activity of this event.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The severity level of this event.</p>
        pub fn severity(mut self, input: crate::model::EventSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity level of this event.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::EventSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDescription`](crate::model::EventDescription)
        pub fn build(self) -> crate::model::EventDescription {
            crate::model::EventDescription {
                event_date: self.event_date,
                message: self.message,
                application_name: self.application_name,
                version_label: self.version_label,
                template_name: self.template_name,
                environment_name: self.environment_name,
                platform_arn: self.platform_arn,
                request_id: self.request_id,
                severity: self.severity,
            }
        }
    }
}
impl EventDescription {
    /// Creates a new builder-style object to manufacture [`EventDescription`](crate::model::EventDescription)
    pub fn builder() -> crate::model::event_description::Builder {
        crate::model::event_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventSeverity {
    #[allow(missing_docs)] // documentation missing in model
    Debug,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Fatal,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    #[allow(missing_docs)] // documentation missing in model
    Trace,
    #[allow(missing_docs)] // documentation missing in model
    Warn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventSeverity {
    fn from(s: &str) -> Self {
        match s {
            "DEBUG" => EventSeverity::Debug,
            "ERROR" => EventSeverity::Error,
            "FATAL" => EventSeverity::Fatal,
            "INFO" => EventSeverity::Info,
            "TRACE" => EventSeverity::Trace,
            "WARN" => EventSeverity::Warn,
            other => EventSeverity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventSeverity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventSeverity::from(s))
    }
}
impl EventSeverity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventSeverity::Debug => "DEBUG",
            EventSeverity::Error => "ERROR",
            EventSeverity::Fatal => "FATAL",
            EventSeverity::Info => "INFO",
            EventSeverity::Trace => "TRACE",
            EventSeverity::Warn => "WARN",
            EventSeverity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEBUG", "ERROR", "FATAL", "INFO", "TRACE", "WARN"]
    }
}
impl AsRef<str> for EventSeverity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the properties of an environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentDescription {
    /// <p>The name of this environment.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The ID of this environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The name of the application associated with this environment.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The application version deployed in this environment.</p>
    pub version_label: std::option::Option<std::string::String>,
    /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the platform version.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>The name of the configuration template used to originally launch this
    /// environment.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>Describes this environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For
    /// single-instance environments, the IP address of the instance.</p>
    pub endpoint_url: std::option::Option<std::string::String>,
    /// <p>The URL to the CNAME for this environment.</p>
    pub cname: std::option::Option<std::string::String>,
    /// <p>The creation date for this environment.</p>
    pub date_created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last modified date for this environment.</p>
    pub date_updated: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current operational status of the environment:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Launching</code>: Environment is in the process of initial deployment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Updating</code>: Environment is in the process of updating its configuration
    /// settings or application version.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Ready</code>: Environment is available to have an action performed on it, such as
    /// update or terminate.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Terminating</code>: Environment is in the shut-down process.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Terminated</code>: Environment is not running.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::EnvironmentStatus>,
    /// <p>Indicates if there is an in-progress environment configuration update or application
    /// version deployment that you can cancel.</p>
    /// <p>
    /// <code>true:</code> There is an update in progress. </p>
    /// <p>
    /// <code>false:</code> There are no updates currently in progress. </p>
    pub abortable_operation_in_progress: std::option::Option<bool>,
    /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the
    /// failure levels for a running environment:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more
    /// consecutive failures occur for an environment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive
    /// failures occur for an environment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Green</code>: Indicates the environment is healthy and fully functional.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Grey</code>: Default health for a new environment. The environment is not fully
    /// launched and health checks have not started or health checks are suspended during an
    /// <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p>
    /// </li>
    /// </ul>
    /// <p> Default: <code>Grey</code>
    /// </p>
    pub health: std::option::Option<crate::model::EnvironmentHealth>,
    /// <p>Returns the health status of the application running in your environment. For more
    /// information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and
    /// Statuses</a>.</p>
    pub health_status: std::option::Option<crate::model::EnvironmentHealthStatus>,
    /// <p>The description of the AWS resources used by this environment.</p>
    pub resources: std::option::Option<crate::model::EnvironmentResourcesDescription>,
    /// <p>Describes the current tier of this environment.</p>
    pub tier: std::option::Option<crate::model::EnvironmentTier>,
    /// <p>A list of links to other environments in the same group.</p>
    pub environment_links: std::option::Option<std::vec::Vec<crate::model::EnvironmentLink>>,
    /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
    pub environment_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information,
    /// see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
    pub operations_role: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EnvironmentDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentDescription");
        formatter.field("environment_name", &self.environment_name);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("application_name", &self.application_name);
        formatter.field("version_label", &self.version_label);
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("template_name", &self.template_name);
        formatter.field("description", &self.description);
        formatter.field("endpoint_url", &self.endpoint_url);
        formatter.field("cname", &self.cname);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("status", &self.status);
        formatter.field(
            "abortable_operation_in_progress",
            &self.abortable_operation_in_progress,
        );
        formatter.field("health", &self.health);
        formatter.field("health_status", &self.health_status);
        formatter.field("resources", &self.resources);
        formatter.field("tier", &self.tier);
        formatter.field("environment_links", &self.environment_links);
        formatter.field("environment_arn", &self.environment_arn);
        formatter.field("operations_role", &self.operations_role);
        formatter.finish()
    }
}
/// See [`EnvironmentDescription`](crate::model::EnvironmentDescription)
pub mod environment_description {
    /// A builder for [`EnvironmentDescription`](crate::model::EnvironmentDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) version_label: std::option::Option<std::string::String>,
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) endpoint_url: std::option::Option<std::string::String>,
        pub(crate) cname: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) date_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::EnvironmentStatus>,
        pub(crate) abortable_operation_in_progress: std::option::Option<bool>,
        pub(crate) health: std::option::Option<crate::model::EnvironmentHealth>,
        pub(crate) health_status: std::option::Option<crate::model::EnvironmentHealthStatus>,
        pub(crate) resources: std::option::Option<crate::model::EnvironmentResourcesDescription>,
        pub(crate) tier: std::option::Option<crate::model::EnvironmentTier>,
        pub(crate) environment_links:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentLink>>,
        pub(crate) environment_arn: std::option::Option<std::string::String>,
        pub(crate) operations_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of this environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of this environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The ID of this environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of this environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The name of the application associated with this environment.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application associated with this environment.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The application version deployed in this environment.</p>
        pub fn version_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_label = Some(input.into());
            self
        }
        /// <p>The application version deployed in this environment.</p>
        pub fn set_version_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_label = input;
            self
        }
        /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p> The name of the <code>SolutionStack</code> deployed with this environment. </p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// <p>The name of the configuration template used to originally launch this
        /// environment.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration template used to originally launch this
        /// environment.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>Describes this environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Describes this environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For
        /// single-instance environments, the IP address of the instance.</p>
        pub fn endpoint_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_url = Some(input.into());
            self
        }
        /// <p>For load-balanced, autoscaling environments, the URL to the LoadBalancer. For
        /// single-instance environments, the IP address of the instance.</p>
        pub fn set_endpoint_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_url = input;
            self
        }
        /// <p>The URL to the CNAME for this environment.</p>
        pub fn cname(mut self, input: impl Into<std::string::String>) -> Self {
            self.cname = Some(input.into());
            self
        }
        /// <p>The URL to the CNAME for this environment.</p>
        pub fn set_cname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cname = input;
            self
        }
        /// <p>The creation date for this environment.</p>
        pub fn date_created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The creation date for this environment.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The last modified date for this environment.</p>
        pub fn date_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date_updated = Some(input);
            self
        }
        /// <p>The last modified date for this environment.</p>
        pub fn set_date_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.date_updated = input;
            self
        }
        /// <p>The current operational status of the environment:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Launching</code>: Environment is in the process of initial deployment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Updating</code>: Environment is in the process of updating its configuration
        /// settings or application version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Ready</code>: Environment is available to have an action performed on it, such as
        /// update or terminate.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Terminating</code>: Environment is in the shut-down process.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Terminated</code>: Environment is not running.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::EnvironmentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current operational status of the environment:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Launching</code>: Environment is in the process of initial deployment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Updating</code>: Environment is in the process of updating its configuration
        /// settings or application version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Ready</code>: Environment is available to have an action performed on it, such as
        /// update or terminate.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Terminating</code>: Environment is in the shut-down process.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Terminated</code>: Environment is not running.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EnvironmentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Indicates if there is an in-progress environment configuration update or application
        /// version deployment that you can cancel.</p>
        /// <p>
        /// <code>true:</code> There is an update in progress. </p>
        /// <p>
        /// <code>false:</code> There are no updates currently in progress. </p>
        pub fn abortable_operation_in_progress(mut self, input: bool) -> Self {
            self.abortable_operation_in_progress = Some(input);
            self
        }
        /// <p>Indicates if there is an in-progress environment configuration update or application
        /// version deployment that you can cancel.</p>
        /// <p>
        /// <code>true:</code> There is an update in progress. </p>
        /// <p>
        /// <code>false:</code> There are no updates currently in progress. </p>
        pub fn set_abortable_operation_in_progress(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.abortable_operation_in_progress = input;
            self
        }
        /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the
        /// failure levels for a running environment:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more
        /// consecutive failures occur for an environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive
        /// failures occur for an environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Green</code>: Indicates the environment is healthy and fully functional.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Grey</code>: Default health for a new environment. The environment is not fully
        /// launched and health checks have not started or health checks are suspended during an
        /// <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p>
        /// </li>
        /// </ul>
        /// <p> Default: <code>Grey</code>
        /// </p>
        pub fn health(mut self, input: crate::model::EnvironmentHealth) -> Self {
            self.health = Some(input);
            self
        }
        /// <p>Describes the health status of the environment. AWS Elastic Beanstalk indicates the
        /// failure levels for a running environment:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Red</code>: Indicates the environment is not responsive. Occurs when three or more
        /// consecutive failures occur for an environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Yellow</code>: Indicates that something is wrong. Occurs when two consecutive
        /// failures occur for an environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Green</code>: Indicates the environment is healthy and fully functional.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Grey</code>: Default health for a new environment. The environment is not fully
        /// launched and health checks have not started or health checks are suspended during an
        /// <code>UpdateEnvironment</code> or <code>RestartEnvironment</code> request.</p>
        /// </li>
        /// </ul>
        /// <p> Default: <code>Grey</code>
        /// </p>
        pub fn set_health(
            mut self,
            input: std::option::Option<crate::model::EnvironmentHealth>,
        ) -> Self {
            self.health = input;
            self
        }
        /// <p>Returns the health status of the application running in your environment. For more
        /// information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and
        /// Statuses</a>.</p>
        pub fn health_status(mut self, input: crate::model::EnvironmentHealthStatus) -> Self {
            self.health_status = Some(input);
            self
        }
        /// <p>Returns the health status of the application running in your environment. For more
        /// information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and
        /// Statuses</a>.</p>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<crate::model::EnvironmentHealthStatus>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// <p>The description of the AWS resources used by this environment.</p>
        pub fn resources(mut self, input: crate::model::EnvironmentResourcesDescription) -> Self {
            self.resources = Some(input);
            self
        }
        /// <p>The description of the AWS resources used by this environment.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::EnvironmentResourcesDescription>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>Describes the current tier of this environment.</p>
        pub fn tier(mut self, input: crate::model::EnvironmentTier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>Describes the current tier of this environment.</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTier>,
        ) -> Self {
            self.tier = input;
            self
        }
        /// Appends an item to `environment_links`.
        ///
        /// To override the contents of this collection use [`set_environment_links`](Self::set_environment_links).
        ///
        /// <p>A list of links to other environments in the same group.</p>
        pub fn environment_links(
            mut self,
            input: impl Into<crate::model::EnvironmentLink>,
        ) -> Self {
            let mut v = self.environment_links.unwrap_or_default();
            v.push(input.into());
            self.environment_links = Some(v);
            self
        }
        /// <p>A list of links to other environments in the same group.</p>
        pub fn set_environment_links(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentLink>>,
        ) -> Self {
            self.environment_links = input;
            self
        }
        /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
        pub fn environment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_arn = Some(input.into());
            self
        }
        /// <p>The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.</p>
        pub fn set_environment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information,
        /// see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn operations_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.operations_role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment's operations role. For more information,
        /// see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p>
        pub fn set_operations_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operations_role = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentDescription`](crate::model::EnvironmentDescription)
        pub fn build(self) -> crate::model::EnvironmentDescription {
            crate::model::EnvironmentDescription {
                environment_name: self.environment_name,
                environment_id: self.environment_id,
                application_name: self.application_name,
                version_label: self.version_label,
                solution_stack_name: self.solution_stack_name,
                platform_arn: self.platform_arn,
                template_name: self.template_name,
                description: self.description,
                endpoint_url: self.endpoint_url,
                cname: self.cname,
                date_created: self.date_created,
                date_updated: self.date_updated,
                status: self.status,
                abortable_operation_in_progress: self.abortable_operation_in_progress,
                health: self.health,
                health_status: self.health_status,
                resources: self.resources,
                tier: self.tier,
                environment_links: self.environment_links,
                environment_arn: self.environment_arn,
                operations_role: self.operations_role,
            }
        }
    }
}
impl EnvironmentDescription {
    /// Creates a new builder-style object to manufacture [`EnvironmentDescription`](crate::model::EnvironmentDescription)
    pub fn builder() -> crate::model::environment_description::Builder {
        crate::model::environment_description::Builder::default()
    }
}

/// <p>Describes the AWS resources in use by this environment. This data is live.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentResourceDescription {
    /// <p>The name of the environment.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p> The <code>AutoScalingGroups</code> used by this environment. </p>
    pub auto_scaling_groups: std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
    /// <p>The Amazon EC2 instances used by this environment.</p>
    pub instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
    /// <p>The Auto Scaling launch configurations in use by this environment.</p>
    pub launch_configurations:
        std::option::Option<std::vec::Vec<crate::model::LaunchConfiguration>>,
    /// <p>The Amazon EC2 launch templates in use by this environment.</p>
    pub launch_templates: std::option::Option<std::vec::Vec<crate::model::LaunchTemplate>>,
    /// <p>The LoadBalancers in use by this environment.</p>
    pub load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
    /// <p>The <code>AutoScaling</code> triggers in use by this environment. </p>
    pub triggers: std::option::Option<std::vec::Vec<crate::model::Trigger>>,
    /// <p>The queues used by this environment.</p>
    pub queues: std::option::Option<std::vec::Vec<crate::model::Queue>>,
}
impl std::fmt::Debug for EnvironmentResourceDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentResourceDescription");
        formatter.field("environment_name", &self.environment_name);
        formatter.field("auto_scaling_groups", &self.auto_scaling_groups);
        formatter.field("instances", &self.instances);
        formatter.field("launch_configurations", &self.launch_configurations);
        formatter.field("launch_templates", &self.launch_templates);
        formatter.field("load_balancers", &self.load_balancers);
        formatter.field("triggers", &self.triggers);
        formatter.field("queues", &self.queues);
        formatter.finish()
    }
}
/// See [`EnvironmentResourceDescription`](crate::model::EnvironmentResourceDescription)
pub mod environment_resource_description {
    /// A builder for [`EnvironmentResourceDescription`](crate::model::EnvironmentResourceDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_groups:
            std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        pub(crate) launch_configurations:
            std::option::Option<std::vec::Vec<crate::model::LaunchConfiguration>>,
        pub(crate) launch_templates:
            std::option::Option<std::vec::Vec<crate::model::LaunchTemplate>>,
        pub(crate) load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        pub(crate) triggers: std::option::Option<std::vec::Vec<crate::model::Trigger>>,
        pub(crate) queues: std::option::Option<std::vec::Vec<crate::model::Queue>>,
    }
    impl Builder {
        /// <p>The name of the environment.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// Appends an item to `auto_scaling_groups`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_groups`](Self::set_auto_scaling_groups).
        ///
        /// <p> The <code>AutoScalingGroups</code> used by this environment. </p>
        pub fn auto_scaling_groups(
            mut self,
            input: impl Into<crate::model::AutoScalingGroup>,
        ) -> Self {
            let mut v = self.auto_scaling_groups.unwrap_or_default();
            v.push(input.into());
            self.auto_scaling_groups = Some(v);
            self
        }
        /// <p> The <code>AutoScalingGroups</code> used by this environment. </p>
        pub fn set_auto_scaling_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
        ) -> Self {
            self.auto_scaling_groups = input;
            self
        }
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>The Amazon EC2 instances used by this environment.</p>
        pub fn instances(mut self, input: impl Into<crate::model::Instance>) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input.into());
            self.instances = Some(v);
            self
        }
        /// <p>The Amazon EC2 instances used by this environment.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// Appends an item to `launch_configurations`.
        ///
        /// To override the contents of this collection use [`set_launch_configurations`](Self::set_launch_configurations).
        ///
        /// <p>The Auto Scaling launch configurations in use by this environment.</p>
        pub fn launch_configurations(
            mut self,
            input: impl Into<crate::model::LaunchConfiguration>,
        ) -> Self {
            let mut v = self.launch_configurations.unwrap_or_default();
            v.push(input.into());
            self.launch_configurations = Some(v);
            self
        }
        /// <p>The Auto Scaling launch configurations in use by this environment.</p>
        pub fn set_launch_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchConfiguration>>,
        ) -> Self {
            self.launch_configurations = input;
            self
        }
        /// Appends an item to `launch_templates`.
        ///
        /// To override the contents of this collection use [`set_launch_templates`](Self::set_launch_templates).
        ///
        /// <p>The Amazon EC2 launch templates in use by this environment.</p>
        pub fn launch_templates(mut self, input: impl Into<crate::model::LaunchTemplate>) -> Self {
            let mut v = self.launch_templates.unwrap_or_default();
            v.push(input.into());
            self.launch_templates = Some(v);
            self
        }
        /// <p>The Amazon EC2 launch templates in use by this environment.</p>
        pub fn set_launch_templates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchTemplate>>,
        ) -> Self {
            self.launch_templates = input;
            self
        }
        /// Appends an item to `load_balancers`.
        ///
        /// To override the contents of this collection use [`set_load_balancers`](Self::set_load_balancers).
        ///
        /// <p>The LoadBalancers in use by this environment.</p>
        pub fn load_balancers(mut self, input: impl Into<crate::model::LoadBalancer>) -> Self {
            let mut v = self.load_balancers.unwrap_or_default();
            v.push(input.into());
            self.load_balancers = Some(v);
            self
        }
        /// <p>The LoadBalancers in use by this environment.</p>
        pub fn set_load_balancers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        ) -> Self {
            self.load_balancers = input;
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>The <code>AutoScaling</code> triggers in use by this environment. </p>
        pub fn triggers(mut self, input: impl Into<crate::model::Trigger>) -> Self {
            let mut v = self.triggers.unwrap_or_default();
            v.push(input.into());
            self.triggers = Some(v);
            self
        }
        /// <p>The <code>AutoScaling</code> triggers in use by this environment. </p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Trigger>>,
        ) -> Self {
            self.triggers = input;
            self
        }
        /// Appends an item to `queues`.
        ///
        /// To override the contents of this collection use [`set_queues`](Self::set_queues).
        ///
        /// <p>The queues used by this environment.</p>
        pub fn queues(mut self, input: impl Into<crate::model::Queue>) -> Self {
            let mut v = self.queues.unwrap_or_default();
            v.push(input.into());
            self.queues = Some(v);
            self
        }
        /// <p>The queues used by this environment.</p>
        pub fn set_queues(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Queue>>,
        ) -> Self {
            self.queues = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentResourceDescription`](crate::model::EnvironmentResourceDescription)
        pub fn build(self) -> crate::model::EnvironmentResourceDescription {
            crate::model::EnvironmentResourceDescription {
                environment_name: self.environment_name,
                auto_scaling_groups: self.auto_scaling_groups,
                instances: self.instances,
                launch_configurations: self.launch_configurations,
                launch_templates: self.launch_templates,
                load_balancers: self.load_balancers,
                triggers: self.triggers,
                queues: self.queues,
            }
        }
    }
}
impl EnvironmentResourceDescription {
    /// Creates a new builder-style object to manufacture [`EnvironmentResourceDescription`](crate::model::EnvironmentResourceDescription)
    pub fn builder() -> crate::model::environment_resource_description::Builder {
        crate::model::environment_resource_description::Builder::default()
    }
}

/// <p>Describes a queue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Queue {
    /// <p>The name of the queue.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The URL of the queue.</p>
    pub url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Queue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Queue");
        formatter.field("name", &self.name);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`Queue`](crate::model::Queue)
pub mod queue {
    /// A builder for [`Queue`](crate::model::Queue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the queue.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the queue.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The URL of the queue.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL of the queue.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`Queue`](crate::model::Queue)
        pub fn build(self) -> crate::model::Queue {
            crate::model::Queue {
                name: self.name,
                url: self.url,
            }
        }
    }
}
impl Queue {
    /// Creates a new builder-style object to manufacture [`Queue`](crate::model::Queue)
    pub fn builder() -> crate::model::queue::Builder {
        crate::model::queue::Builder::default()
    }
}

/// <p>Describes a trigger.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Trigger {
    /// <p>The name of the trigger.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Trigger {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Trigger");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`Trigger`](crate::model::Trigger)
pub mod trigger {
    /// A builder for [`Trigger`](crate::model::Trigger)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the trigger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the trigger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`Trigger`](crate::model::Trigger)
        pub fn build(self) -> crate::model::Trigger {
            crate::model::Trigger { name: self.name }
        }
    }
}
impl Trigger {
    /// Creates a new builder-style object to manufacture [`Trigger`](crate::model::Trigger)
    pub fn builder() -> crate::model::trigger::Builder {
        crate::model::trigger::Builder::default()
    }
}

/// <p>Describes a LoadBalancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancer {
    /// <p>The name of the LoadBalancer.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LoadBalancer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancer");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`LoadBalancer`](crate::model::LoadBalancer)
pub mod load_balancer {
    /// A builder for [`LoadBalancer`](crate::model::LoadBalancer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the LoadBalancer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the LoadBalancer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancer`](crate::model::LoadBalancer)
        pub fn build(self) -> crate::model::LoadBalancer {
            crate::model::LoadBalancer { name: self.name }
        }
    }
}
impl LoadBalancer {
    /// Creates a new builder-style object to manufacture [`LoadBalancer`](crate::model::LoadBalancer)
    pub fn builder() -> crate::model::load_balancer::Builder {
        crate::model::load_balancer::Builder::default()
    }
}

/// <p>Describes an Amazon EC2 launch template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchTemplate {
    /// <p>The ID of the launch template.</p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LaunchTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchTemplate");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`LaunchTemplate`](crate::model::LaunchTemplate)
pub mod launch_template {
    /// A builder for [`LaunchTemplate`](crate::model::LaunchTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the launch template.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the launch template.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchTemplate`](crate::model::LaunchTemplate)
        pub fn build(self) -> crate::model::LaunchTemplate {
            crate::model::LaunchTemplate { id: self.id }
        }
    }
}
impl LaunchTemplate {
    /// Creates a new builder-style object to manufacture [`LaunchTemplate`](crate::model::LaunchTemplate)
    pub fn builder() -> crate::model::launch_template::Builder {
        crate::model::launch_template::Builder::default()
    }
}

/// <p>Describes an Auto Scaling launch configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchConfiguration {
    /// <p>The name of the launch configuration.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LaunchConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchConfiguration");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`LaunchConfiguration`](crate::model::LaunchConfiguration)
pub mod launch_configuration {
    /// A builder for [`LaunchConfiguration`](crate::model::LaunchConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the launch configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchConfiguration`](crate::model::LaunchConfiguration)
        pub fn build(self) -> crate::model::LaunchConfiguration {
            crate::model::LaunchConfiguration { name: self.name }
        }
    }
}
impl LaunchConfiguration {
    /// Creates a new builder-style object to manufacture [`LaunchConfiguration`](crate::model::LaunchConfiguration)
    pub fn builder() -> crate::model::launch_configuration::Builder {
        crate::model::launch_configuration::Builder::default()
    }
}

/// <p>The description of an Amazon EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Instance {
    /// <p>The ID of the Amazon EC2 instance.</p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Instance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Instance");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`Instance`](crate::model::Instance)
pub mod instance {
    /// A builder for [`Instance`](crate::model::Instance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon EC2 instance.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EC2 instance.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`Instance`](crate::model::Instance)
        pub fn build(self) -> crate::model::Instance {
            crate::model::Instance { id: self.id }
        }
    }
}
impl Instance {
    /// Creates a new builder-style object to manufacture [`Instance`](crate::model::Instance)
    pub fn builder() -> crate::model::instance::Builder {
        crate::model::instance::Builder::default()
    }
}

/// <p>Describes an Auto Scaling launch configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingGroup {
    /// <p>The name of the <code>AutoScalingGroup</code> . </p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AutoScalingGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingGroup");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AutoScalingGroup`](crate::model::AutoScalingGroup)
pub mod auto_scaling_group {
    /// A builder for [`AutoScalingGroup`](crate::model::AutoScalingGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the <code>AutoScalingGroup</code> . </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>AutoScalingGroup</code> . </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingGroup`](crate::model::AutoScalingGroup)
        pub fn build(self) -> crate::model::AutoScalingGroup {
            crate::model::AutoScalingGroup { name: self.name }
        }
    }
}
impl AutoScalingGroup {
    /// Creates a new builder-style object to manufacture [`AutoScalingGroup`](crate::model::AutoScalingGroup)
    pub fn builder() -> crate::model::auto_scaling_group::Builder {
        crate::model::auto_scaling_group::Builder::default()
    }
}

/// <p>The record of an upcoming or in-progress managed action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManagedAction {
    /// <p>A unique identifier for the managed action.</p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p>A description of the managed action.</p>
    pub action_description: std::option::Option<std::string::String>,
    /// <p>The type of managed action.</p>
    pub action_type: std::option::Option<crate::model::ActionType>,
    /// <p>The status of the managed action. If the action is <code>Scheduled</code>, you can
    /// apply it immediately with <a>ApplyEnvironmentManagedAction</a>.</p>
    pub status: std::option::Option<crate::model::ActionStatus>,
    /// <p>The start time of the maintenance window in which the managed action will
    /// execute.</p>
    pub window_start_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ManagedAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManagedAction");
        formatter.field("action_id", &self.action_id);
        formatter.field("action_description", &self.action_description);
        formatter.field("action_type", &self.action_type);
        formatter.field("status", &self.status);
        formatter.field("window_start_time", &self.window_start_time);
        formatter.finish()
    }
}
/// See [`ManagedAction`](crate::model::ManagedAction)
pub mod managed_action {
    /// A builder for [`ManagedAction`](crate::model::ManagedAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) action_description: std::option::Option<std::string::String>,
        pub(crate) action_type: std::option::Option<crate::model::ActionType>,
        pub(crate) status: std::option::Option<crate::model::ActionStatus>,
        pub(crate) window_start_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>A unique identifier for the managed action.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the managed action.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p>A description of the managed action.</p>
        pub fn action_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_description = Some(input.into());
            self
        }
        /// <p>A description of the managed action.</p>
        pub fn set_action_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_description = input;
            self
        }
        /// <p>The type of managed action.</p>
        pub fn action_type(mut self, input: crate::model::ActionType) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>The type of managed action.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionType>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// <p>The status of the managed action. If the action is <code>Scheduled</code>, you can
        /// apply it immediately with <a>ApplyEnvironmentManagedAction</a>.</p>
        pub fn status(mut self, input: crate::model::ActionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the managed action. If the action is <code>Scheduled</code>, you can
        /// apply it immediately with <a>ApplyEnvironmentManagedAction</a>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ActionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The start time of the maintenance window in which the managed action will
        /// execute.</p>
        pub fn window_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.window_start_time = Some(input);
            self
        }
        /// <p>The start time of the maintenance window in which the managed action will
        /// execute.</p>
        pub fn set_window_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.window_start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ManagedAction`](crate::model::ManagedAction)
        pub fn build(self) -> crate::model::ManagedAction {
            crate::model::ManagedAction {
                action_id: self.action_id,
                action_description: self.action_description,
                action_type: self.action_type,
                status: self.status,
                window_start_time: self.window_start_time,
            }
        }
    }
}
impl ManagedAction {
    /// Creates a new builder-style object to manufacture [`ManagedAction`](crate::model::ManagedAction)
    pub fn builder() -> crate::model::managed_action::Builder {
        crate::model::managed_action::Builder::default()
    }
}

/// _Note: `ActionStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Pending" => ActionStatus::Pending,
            "Running" => ActionStatus::Running,
            "Scheduled" => ActionStatus::Scheduled,
            "Unknown" => ActionStatus::UnknownValue,
            other => ActionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionStatus::from(s))
    }
}
impl ActionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionStatus::Pending => "Pending",
            ActionStatus::Running => "Running",
            ActionStatus::Scheduled => "Scheduled",
            ActionStatus::UnknownValue => "Unknown",
            ActionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Pending", "Running", "Scheduled", "Unknown"]
    }
}
impl AsRef<str> for ActionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// _Note: `ActionType::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionType {
    #[allow(missing_docs)] // documentation missing in model
    InstanceRefresh,
    #[allow(missing_docs)] // documentation missing in model
    PlatformUpdate,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionType {
    fn from(s: &str) -> Self {
        match s {
            "InstanceRefresh" => ActionType::InstanceRefresh,
            "PlatformUpdate" => ActionType::PlatformUpdate,
            "Unknown" => ActionType::UnknownValue,
            other => ActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionType::from(s))
    }
}
impl ActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionType::InstanceRefresh => "InstanceRefresh",
            ActionType::PlatformUpdate => "PlatformUpdate",
            ActionType::UnknownValue => "Unknown",
            ActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["InstanceRefresh", "PlatformUpdate", "Unknown"]
    }
}
impl AsRef<str> for ActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The record of a completed or failed managed action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManagedActionHistoryItem {
    /// <p>A unique identifier for the managed action.</p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p>The type of the managed action.</p>
    pub action_type: std::option::Option<crate::model::ActionType>,
    /// <p>A description of the managed action.</p>
    pub action_description: std::option::Option<std::string::String>,
    /// <p>If the action failed, the type of failure.</p>
    pub failure_type: std::option::Option<crate::model::FailureType>,
    /// <p>The status of the action.</p>
    pub status: std::option::Option<crate::model::ActionHistoryStatus>,
    /// <p>If the action failed, a description of the failure.</p>
    pub failure_description: std::option::Option<std::string::String>,
    /// <p>The date and time that the action started executing.</p>
    pub executed_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the action finished executing.</p>
    pub finished_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ManagedActionHistoryItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManagedActionHistoryItem");
        formatter.field("action_id", &self.action_id);
        formatter.field("action_type", &self.action_type);
        formatter.field("action_description", &self.action_description);
        formatter.field("failure_type", &self.failure_type);
        formatter.field("status", &self.status);
        formatter.field("failure_description", &self.failure_description);
        formatter.field("executed_time", &self.executed_time);
        formatter.field("finished_time", &self.finished_time);
        formatter.finish()
    }
}
/// See [`ManagedActionHistoryItem`](crate::model::ManagedActionHistoryItem)
pub mod managed_action_history_item {
    /// A builder for [`ManagedActionHistoryItem`](crate::model::ManagedActionHistoryItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) action_type: std::option::Option<crate::model::ActionType>,
        pub(crate) action_description: std::option::Option<std::string::String>,
        pub(crate) failure_type: std::option::Option<crate::model::FailureType>,
        pub(crate) status: std::option::Option<crate::model::ActionHistoryStatus>,
        pub(crate) failure_description: std::option::Option<std::string::String>,
        pub(crate) executed_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) finished_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>A unique identifier for the managed action.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the managed action.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p>The type of the managed action.</p>
        pub fn action_type(mut self, input: crate::model::ActionType) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>The type of the managed action.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionType>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// <p>A description of the managed action.</p>
        pub fn action_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_description = Some(input.into());
            self
        }
        /// <p>A description of the managed action.</p>
        pub fn set_action_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_description = input;
            self
        }
        /// <p>If the action failed, the type of failure.</p>
        pub fn failure_type(mut self, input: crate::model::FailureType) -> Self {
            self.failure_type = Some(input);
            self
        }
        /// <p>If the action failed, the type of failure.</p>
        pub fn set_failure_type(
            mut self,
            input: std::option::Option<crate::model::FailureType>,
        ) -> Self {
            self.failure_type = input;
            self
        }
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: crate::model::ActionHistoryStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ActionHistoryStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>If the action failed, a description of the failure.</p>
        pub fn failure_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_description = Some(input.into());
            self
        }
        /// <p>If the action failed, a description of the failure.</p>
        pub fn set_failure_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_description = input;
            self
        }
        /// <p>The date and time that the action started executing.</p>
        pub fn executed_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.executed_time = Some(input);
            self
        }
        /// <p>The date and time that the action started executing.</p>
        pub fn set_executed_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.executed_time = input;
            self
        }
        /// <p>The date and time that the action finished executing.</p>
        pub fn finished_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.finished_time = Some(input);
            self
        }
        /// <p>The date and time that the action finished executing.</p>
        pub fn set_finished_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.finished_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ManagedActionHistoryItem`](crate::model::ManagedActionHistoryItem)
        pub fn build(self) -> crate::model::ManagedActionHistoryItem {
            crate::model::ManagedActionHistoryItem {
                action_id: self.action_id,
                action_type: self.action_type,
                action_description: self.action_description,
                failure_type: self.failure_type,
                status: self.status,
                failure_description: self.failure_description,
                executed_time: self.executed_time,
                finished_time: self.finished_time,
            }
        }
    }
}
impl ManagedActionHistoryItem {
    /// Creates a new builder-style object to manufacture [`ManagedActionHistoryItem`](crate::model::ManagedActionHistoryItem)
    pub fn builder() -> crate::model::managed_action_history_item::Builder {
        crate::model::managed_action_history_item::Builder::default()
    }
}

/// _Note: `ActionHistoryStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionHistoryStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionHistoryStatus {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => ActionHistoryStatus::Completed,
            "Failed" => ActionHistoryStatus::Failed,
            "Unknown" => ActionHistoryStatus::UnknownValue,
            other => ActionHistoryStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionHistoryStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionHistoryStatus::from(s))
    }
}
impl ActionHistoryStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionHistoryStatus::Completed => "Completed",
            ActionHistoryStatus::Failed => "Failed",
            ActionHistoryStatus::UnknownValue => "Unknown",
            ActionHistoryStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Completed", "Failed", "Unknown"]
    }
}
impl AsRef<str> for ActionHistoryStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FailureType {
    #[allow(missing_docs)] // documentation missing in model
    CancellationFailed,
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    InvalidEnvironmentState,
    #[allow(missing_docs)] // documentation missing in model
    PermissionsError,
    #[allow(missing_docs)] // documentation missing in model
    RollbackFailed,
    #[allow(missing_docs)] // documentation missing in model
    RollbackSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    UpdateCancelled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FailureType {
    fn from(s: &str) -> Self {
        match s {
            "CancellationFailed" => FailureType::CancellationFailed,
            "InternalFailure" => FailureType::InternalFailure,
            "InvalidEnvironmentState" => FailureType::InvalidEnvironmentState,
            "PermissionsError" => FailureType::PermissionsError,
            "RollbackFailed" => FailureType::RollbackFailed,
            "RollbackSuccessful" => FailureType::RollbackSuccessful,
            "UpdateCancelled" => FailureType::UpdateCancelled,
            other => FailureType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FailureType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FailureType::from(s))
    }
}
impl FailureType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FailureType::CancellationFailed => "CancellationFailed",
            FailureType::InternalFailure => "InternalFailure",
            FailureType::InvalidEnvironmentState => "InvalidEnvironmentState",
            FailureType::PermissionsError => "PermissionsError",
            FailureType::RollbackFailed => "RollbackFailed",
            FailureType::RollbackSuccessful => "RollbackSuccessful",
            FailureType::UpdateCancelled => "UpdateCancelled",
            FailureType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CancellationFailed",
            "InternalFailure",
            "InvalidEnvironmentState",
            "PermissionsError",
            "RollbackFailed",
            "RollbackSuccessful",
            "UpdateCancelled",
        ]
    }
}
impl AsRef<str> for FailureType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents summary information about the health of an instance. For more information,
/// see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceHealthSummary {
    /// <p>
    /// <b>Grey.</b> AWS Elastic Beanstalk and the health agent are
    /// reporting no data on an instance.</p>
    pub no_data: std::option::Option<i32>,
    /// <p>
    /// <b>Grey.</b> AWS Elastic Beanstalk and the health agent are
    /// reporting an insufficient amount of data on an instance.</p>
    pub unknown: std::option::Option<i32>,
    /// <p>
    /// <b>Grey.</b> An operation is in progress on an instance within the
    /// command timeout.</p>
    pub pending: std::option::Option<i32>,
    /// <p>
    /// <b>Green.</b> An instance is passing health checks and the health
    /// agent is not reporting any problems.</p>
    pub ok: std::option::Option<i32>,
    /// <p>
    /// <b>Green.</b> An operation is in progress on an instance.</p>
    pub info: std::option::Option<i32>,
    /// <p>
    /// <b>Yellow.</b> The health agent is reporting a moderate number of
    /// request failures or other issues for an instance or environment.</p>
    pub warning: std::option::Option<i32>,
    /// <p>
    /// <b>Red.</b> The health agent is reporting a high number of request
    /// failures or other issues for an instance or environment.</p>
    pub degraded: std::option::Option<i32>,
    /// <p>
    /// <b>Red.</b> The health agent is reporting a very high number of
    /// request failures or other issues for an instance or environment.</p>
    pub severe: std::option::Option<i32>,
}
impl std::fmt::Debug for InstanceHealthSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceHealthSummary");
        formatter.field("no_data", &self.no_data);
        formatter.field("unknown", &self.unknown);
        formatter.field("pending", &self.pending);
        formatter.field("ok", &self.ok);
        formatter.field("info", &self.info);
        formatter.field("warning", &self.warning);
        formatter.field("degraded", &self.degraded);
        formatter.field("severe", &self.severe);
        formatter.finish()
    }
}
/// See [`InstanceHealthSummary`](crate::model::InstanceHealthSummary)
pub mod instance_health_summary {
    /// A builder for [`InstanceHealthSummary`](crate::model::InstanceHealthSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) no_data: std::option::Option<i32>,
        pub(crate) unknown: std::option::Option<i32>,
        pub(crate) pending: std::option::Option<i32>,
        pub(crate) ok: std::option::Option<i32>,
        pub(crate) info: std::option::Option<i32>,
        pub(crate) warning: std::option::Option<i32>,
        pub(crate) degraded: std::option::Option<i32>,
        pub(crate) severe: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>
        /// <b>Grey.</b> AWS Elastic Beanstalk and the health agent are
        /// reporting no data on an instance.</p>
        pub fn no_data(mut self, input: i32) -> Self {
            self.no_data = Some(input);
            self
        }
        /// <p>
        /// <b>Grey.</b> AWS Elastic Beanstalk and the health agent are
        /// reporting no data on an instance.</p>
        pub fn set_no_data(mut self, input: std::option::Option<i32>) -> Self {
            self.no_data = input;
            self
        }
        /// <p>
        /// <b>Grey.</b> AWS Elastic Beanstalk and the health agent are
        /// reporting an insufficient amount of data on an instance.</p>
        pub fn unknown(mut self, input: i32) -> Self {
            self.unknown = Some(input);
            self
        }
        /// <p>
        /// <b>Grey.</b> AWS Elastic Beanstalk and the health agent are
        /// reporting an insufficient amount of data on an instance.</p>
        pub fn set_unknown(mut self, input: std::option::Option<i32>) -> Self {
            self.unknown = input;
            self
        }
        /// <p>
        /// <b>Grey.</b> An operation is in progress on an instance within the
        /// command timeout.</p>
        pub fn pending(mut self, input: i32) -> Self {
            self.pending = Some(input);
            self
        }
        /// <p>
        /// <b>Grey.</b> An operation is in progress on an instance within the
        /// command timeout.</p>
        pub fn set_pending(mut self, input: std::option::Option<i32>) -> Self {
            self.pending = input;
            self
        }
        /// <p>
        /// <b>Green.</b> An instance is passing health checks and the health
        /// agent is not reporting any problems.</p>
        pub fn ok(mut self, input: i32) -> Self {
            self.ok = Some(input);
            self
        }
        /// <p>
        /// <b>Green.</b> An instance is passing health checks and the health
        /// agent is not reporting any problems.</p>
        pub fn set_ok(mut self, input: std::option::Option<i32>) -> Self {
            self.ok = input;
            self
        }
        /// <p>
        /// <b>Green.</b> An operation is in progress on an instance.</p>
        pub fn info(mut self, input: i32) -> Self {
            self.info = Some(input);
            self
        }
        /// <p>
        /// <b>Green.</b> An operation is in progress on an instance.</p>
        pub fn set_info(mut self, input: std::option::Option<i32>) -> Self {
            self.info = input;
            self
        }
        /// <p>
        /// <b>Yellow.</b> The health agent is reporting a moderate number of
        /// request failures or other issues for an instance or environment.</p>
        pub fn warning(mut self, input: i32) -> Self {
            self.warning = Some(input);
            self
        }
        /// <p>
        /// <b>Yellow.</b> The health agent is reporting a moderate number of
        /// request failures or other issues for an instance or environment.</p>
        pub fn set_warning(mut self, input: std::option::Option<i32>) -> Self {
            self.warning = input;
            self
        }
        /// <p>
        /// <b>Red.</b> The health agent is reporting a high number of request
        /// failures or other issues for an instance or environment.</p>
        pub fn degraded(mut self, input: i32) -> Self {
            self.degraded = Some(input);
            self
        }
        /// <p>
        /// <b>Red.</b> The health agent is reporting a high number of request
        /// failures or other issues for an instance or environment.</p>
        pub fn set_degraded(mut self, input: std::option::Option<i32>) -> Self {
            self.degraded = input;
            self
        }
        /// <p>
        /// <b>Red.</b> The health agent is reporting a very high number of
        /// request failures or other issues for an instance or environment.</p>
        pub fn severe(mut self, input: i32) -> Self {
            self.severe = Some(input);
            self
        }
        /// <p>
        /// <b>Red.</b> The health agent is reporting a very high number of
        /// request failures or other issues for an instance or environment.</p>
        pub fn set_severe(mut self, input: std::option::Option<i32>) -> Self {
            self.severe = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceHealthSummary`](crate::model::InstanceHealthSummary)
        pub fn build(self) -> crate::model::InstanceHealthSummary {
            crate::model::InstanceHealthSummary {
                no_data: self.no_data,
                unknown: self.unknown,
                pending: self.pending,
                ok: self.ok,
                info: self.info,
                warning: self.warning,
                degraded: self.degraded,
                severe: self.severe,
            }
        }
    }
}
impl InstanceHealthSummary {
    /// Creates a new builder-style object to manufacture [`InstanceHealthSummary`](crate::model::InstanceHealthSummary)
    pub fn builder() -> crate::model::instance_health_summary::Builder {
        crate::model::instance_health_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnvironmentHealthAttribute {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    ApplicationMetrics,
    #[allow(missing_docs)] // documentation missing in model
    Causes,
    #[allow(missing_docs)] // documentation missing in model
    Color,
    #[allow(missing_docs)] // documentation missing in model
    HealthStatus,
    #[allow(missing_docs)] // documentation missing in model
    InstancesHealth,
    #[allow(missing_docs)] // documentation missing in model
    RefreshedAt,
    #[allow(missing_docs)] // documentation missing in model
    Status,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnvironmentHealthAttribute {
    fn from(s: &str) -> Self {
        match s {
            "All" => EnvironmentHealthAttribute::All,
            "ApplicationMetrics" => EnvironmentHealthAttribute::ApplicationMetrics,
            "Causes" => EnvironmentHealthAttribute::Causes,
            "Color" => EnvironmentHealthAttribute::Color,
            "HealthStatus" => EnvironmentHealthAttribute::HealthStatus,
            "InstancesHealth" => EnvironmentHealthAttribute::InstancesHealth,
            "RefreshedAt" => EnvironmentHealthAttribute::RefreshedAt,
            "Status" => EnvironmentHealthAttribute::Status,
            other => EnvironmentHealthAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnvironmentHealthAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnvironmentHealthAttribute::from(s))
    }
}
impl EnvironmentHealthAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnvironmentHealthAttribute::All => "All",
            EnvironmentHealthAttribute::ApplicationMetrics => "ApplicationMetrics",
            EnvironmentHealthAttribute::Causes => "Causes",
            EnvironmentHealthAttribute::Color => "Color",
            EnvironmentHealthAttribute::HealthStatus => "HealthStatus",
            EnvironmentHealthAttribute::InstancesHealth => "InstancesHealth",
            EnvironmentHealthAttribute::RefreshedAt => "RefreshedAt",
            EnvironmentHealthAttribute::Status => "Status",
            EnvironmentHealthAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "All",
            "ApplicationMetrics",
            "Causes",
            "Color",
            "HealthStatus",
            "InstancesHealth",
            "RefreshedAt",
            "Status",
        ]
    }
}
impl AsRef<str> for EnvironmentHealthAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the settings for a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationSettingsDescription {
    /// <p>The name of the solution stack this configuration set uses.</p>
    pub solution_stack_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the platform version.</p>
    pub platform_arn: std::option::Option<std::string::String>,
    /// <p>The name of the application associated with this configuration set.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p> If not <code>null</code>, the name of the configuration template for this
    /// configuration set. </p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>Describes this configuration set.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> If not <code>null</code>, the name of the environment for this configuration set.
    /// </p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p> If this configuration set is associated with an environment, the
    /// <code>DeploymentStatus</code> parameter indicates the deployment status of this
    /// configuration set: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>null</code>: This configuration is not associated with a running
    /// environment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code>: This is a draft configuration that is not deployed to the associated
    /// environment but is in the process of deploying.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>deployed</code>: This is the configuration that is currently deployed to the
    /// associated running environment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>failed</code>: This is a draft configuration that failed to successfully
    /// deploy.</p>
    /// </li>
    /// </ul>
    pub deployment_status: std::option::Option<crate::model::ConfigurationDeploymentStatus>,
    /// <p>The date (in UTC time) when this configuration set was created.</p>
    pub date_created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date (in UTC time) when this configuration set was last modified.</p>
    pub date_updated: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of the configuration options and their values in this configuration
    /// set.</p>
    pub option_settings:
        std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
}
impl std::fmt::Debug for ConfigurationSettingsDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationSettingsDescription");
        formatter.field("solution_stack_name", &self.solution_stack_name);
        formatter.field("platform_arn", &self.platform_arn);
        formatter.field("application_name", &self.application_name);
        formatter.field("template_name", &self.template_name);
        formatter.field("description", &self.description);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("option_settings", &self.option_settings);
        formatter.finish()
    }
}
/// See [`ConfigurationSettingsDescription`](crate::model::ConfigurationSettingsDescription)
pub mod configuration_settings_description {
    /// A builder for [`ConfigurationSettingsDescription`](crate::model::ConfigurationSettingsDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) solution_stack_name: std::option::Option<std::string::String>,
        pub(crate) platform_arn: std::option::Option<std::string::String>,
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) deployment_status:
            std::option::Option<crate::model::ConfigurationDeploymentStatus>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) date_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) option_settings:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
    }
    impl Builder {
        /// <p>The name of the solution stack this configuration set uses.</p>
        pub fn solution_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.solution_stack_name = Some(input.into());
            self
        }
        /// <p>The name of the solution stack this configuration set uses.</p>
        pub fn set_solution_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.solution_stack_name = input;
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn platform_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the platform version.</p>
        pub fn set_platform_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_arn = input;
            self
        }
        /// <p>The name of the application associated with this configuration set.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application associated with this configuration set.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p> If not <code>null</code>, the name of the configuration template for this
        /// configuration set. </p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p> If not <code>null</code>, the name of the configuration template for this
        /// configuration set. </p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>Describes this configuration set.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Describes this configuration set.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> If not <code>null</code>, the name of the environment for this configuration set.
        /// </p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p> If not <code>null</code>, the name of the environment for this configuration set.
        /// </p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p> If this configuration set is associated with an environment, the
        /// <code>DeploymentStatus</code> parameter indicates the deployment status of this
        /// configuration set: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>null</code>: This configuration is not associated with a running
        /// environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: This is a draft configuration that is not deployed to the associated
        /// environment but is in the process of deploying.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deployed</code>: This is the configuration that is currently deployed to the
        /// associated running environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>failed</code>: This is a draft configuration that failed to successfully
        /// deploy.</p>
        /// </li>
        /// </ul>
        pub fn deployment_status(
            mut self,
            input: crate::model::ConfigurationDeploymentStatus,
        ) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p> If this configuration set is associated with an environment, the
        /// <code>DeploymentStatus</code> parameter indicates the deployment status of this
        /// configuration set: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>null</code>: This configuration is not associated with a running
        /// environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>: This is a draft configuration that is not deployed to the associated
        /// environment but is in the process of deploying.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deployed</code>: This is the configuration that is currently deployed to the
        /// associated running environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>failed</code>: This is a draft configuration that failed to successfully
        /// deploy.</p>
        /// </li>
        /// </ul>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationDeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>The date (in UTC time) when this configuration set was created.</p>
        pub fn date_created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The date (in UTC time) when this configuration set was created.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The date (in UTC time) when this configuration set was last modified.</p>
        pub fn date_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date_updated = Some(input);
            self
        }
        /// <p>The date (in UTC time) when this configuration set was last modified.</p>
        pub fn set_date_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.date_updated = input;
            self
        }
        /// Appends an item to `option_settings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>A list of the configuration options and their values in this configuration
        /// set.</p>
        pub fn option_settings(
            mut self,
            input: impl Into<crate::model::ConfigurationOptionSetting>,
        ) -> Self {
            let mut v = self.option_settings.unwrap_or_default();
            v.push(input.into());
            self.option_settings = Some(v);
            self
        }
        /// <p>A list of the configuration options and their values in this configuration
        /// set.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationOptionSetting>>,
        ) -> Self {
            self.option_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationSettingsDescription`](crate::model::ConfigurationSettingsDescription)
        pub fn build(self) -> crate::model::ConfigurationSettingsDescription {
            crate::model::ConfigurationSettingsDescription {
                solution_stack_name: self.solution_stack_name,
                platform_arn: self.platform_arn,
                application_name: self.application_name,
                template_name: self.template_name,
                description: self.description,
                environment_name: self.environment_name,
                deployment_status: self.deployment_status,
                date_created: self.date_created,
                date_updated: self.date_updated,
                option_settings: self.option_settings,
            }
        }
    }
}
impl ConfigurationSettingsDescription {
    /// Creates a new builder-style object to manufacture [`ConfigurationSettingsDescription`](crate::model::ConfigurationSettingsDescription)
    pub fn builder() -> crate::model::configuration_settings_description::Builder {
        crate::model::configuration_settings_description::Builder::default()
    }
}

/// <p>Describes the possible values for a configuration option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationOptionDescription {
    /// <p>A unique namespace identifying the option's associated AWS resource.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The name of the configuration option.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The default value for this configuration option.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>An indication of which action is required if the value for this configuration option
    /// changes:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NoInterruption</code> : There is no interruption to the environment or application
    /// availability.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RestartEnvironment</code> : The environment is entirely restarted, all AWS resources
    /// are deleted and recreated, and the environment is unavailable during the
    /// process.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RestartApplicationServer</code> : The environment is available the entire time.
    /// However, a short application outage occurs when the application servers on the running
    /// Amazon EC2 instances are restarted.</p>
    /// </li>
    /// </ul>
    pub change_severity: std::option::Option<std::string::String>,
    /// <p>An indication of whether the user defined this configuration option:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>true</code> : This configuration option was defined by the user. It is a valid
    /// choice for specifying if this as an <code>Option to Remove</code> when updating
    /// configuration settings. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>false</code> : This configuration was not defined by the user.</p>
    /// </li>
    /// </ul>
    /// <p> Constraint: You can remove only <code>UserDefined</code> options from a configuration. </p>
    /// <p> Valid Values: <code>true</code> | <code>false</code>
    /// </p>
    pub user_defined: std::option::Option<bool>,
    /// <p>An indication of which type of values this option has and whether it is allowable to
    /// select one or more than one of the possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Scalar</code> : Values for this option are a single selection from the possible
    /// values, or an unformatted string, or numeric value governed by the
    /// <code>MIN/MAX/Regex</code> constraints.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>List</code> : Values for this option are multiple selections from the possible
    /// values.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Boolean</code> : Values for this option are either <code>true</code> or
    /// <code>false</code> .</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Json</code> : Values for this option are a JSON representation of a
    /// <code>ConfigDocument</code>.</p>
    /// </li>
    /// </ul>
    pub value_type: std::option::Option<crate::model::ConfigurationOptionValueType>,
    /// <p>If specified, values for the configuration option are selected from this
    /// list.</p>
    pub value_options: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If specified, the configuration option must be a numeric value greater than this
    /// value.</p>
    pub min_value: std::option::Option<i32>,
    /// <p>If specified, the configuration option must be a numeric value less than this
    /// value.</p>
    pub max_value: std::option::Option<i32>,
    /// <p>If specified, the configuration option must be a string value no longer than this
    /// value.</p>
    pub max_length: std::option::Option<i32>,
    /// <p>If specified, the configuration option must be a string value that satisfies this
    /// regular expression.</p>
    pub regex: std::option::Option<crate::model::OptionRestrictionRegex>,
}
impl std::fmt::Debug for ConfigurationOptionDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationOptionDescription");
        formatter.field("namespace", &self.namespace);
        formatter.field("name", &self.name);
        formatter.field("default_value", &self.default_value);
        formatter.field("change_severity", &self.change_severity);
        formatter.field("user_defined", &self.user_defined);
        formatter.field("value_type", &self.value_type);
        formatter.field("value_options", &self.value_options);
        formatter.field("min_value", &self.min_value);
        formatter.field("max_value", &self.max_value);
        formatter.field("max_length", &self.max_length);
        formatter.field("regex", &self.regex);
        formatter.finish()
    }
}
/// See [`ConfigurationOptionDescription`](crate::model::ConfigurationOptionDescription)
pub mod configuration_option_description {
    /// A builder for [`ConfigurationOptionDescription`](crate::model::ConfigurationOptionDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) change_severity: std::option::Option<std::string::String>,
        pub(crate) user_defined: std::option::Option<bool>,
        pub(crate) value_type: std::option::Option<crate::model::ConfigurationOptionValueType>,
        pub(crate) value_options: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) min_value: std::option::Option<i32>,
        pub(crate) max_value: std::option::Option<i32>,
        pub(crate) max_length: std::option::Option<i32>,
        pub(crate) regex: std::option::Option<crate::model::OptionRestrictionRegex>,
    }
    impl Builder {
        /// <p>A unique namespace identifying the option's associated AWS resource.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>A unique namespace identifying the option's associated AWS resource.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The name of the configuration option.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the configuration option.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The default value for this configuration option.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value for this configuration option.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>An indication of which action is required if the value for this configuration option
        /// changes:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NoInterruption</code> : There is no interruption to the environment or application
        /// availability.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RestartEnvironment</code> : The environment is entirely restarted, all AWS resources
        /// are deleted and recreated, and the environment is unavailable during the
        /// process.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RestartApplicationServer</code> : The environment is available the entire time.
        /// However, a short application outage occurs when the application servers on the running
        /// Amazon EC2 instances are restarted.</p>
        /// </li>
        /// </ul>
        pub fn change_severity(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_severity = Some(input.into());
            self
        }
        /// <p>An indication of which action is required if the value for this configuration option
        /// changes:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NoInterruption</code> : There is no interruption to the environment or application
        /// availability.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RestartEnvironment</code> : The environment is entirely restarted, all AWS resources
        /// are deleted and recreated, and the environment is unavailable during the
        /// process.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RestartApplicationServer</code> : The environment is available the entire time.
        /// However, a short application outage occurs when the application servers on the running
        /// Amazon EC2 instances are restarted.</p>
        /// </li>
        /// </ul>
        pub fn set_change_severity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_severity = input;
            self
        }
        /// <p>An indication of whether the user defined this configuration option:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>true</code> : This configuration option was defined by the user. It is a valid
        /// choice for specifying if this as an <code>Option to Remove</code> when updating
        /// configuration settings. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>false</code> : This configuration was not defined by the user.</p>
        /// </li>
        /// </ul>
        /// <p> Constraint: You can remove only <code>UserDefined</code> options from a configuration. </p>
        /// <p> Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn user_defined(mut self, input: bool) -> Self {
            self.user_defined = Some(input);
            self
        }
        /// <p>An indication of whether the user defined this configuration option:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>true</code> : This configuration option was defined by the user. It is a valid
        /// choice for specifying if this as an <code>Option to Remove</code> when updating
        /// configuration settings. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>false</code> : This configuration was not defined by the user.</p>
        /// </li>
        /// </ul>
        /// <p> Constraint: You can remove only <code>UserDefined</code> options from a configuration. </p>
        /// <p> Valid Values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_user_defined(mut self, input: std::option::Option<bool>) -> Self {
            self.user_defined = input;
            self
        }
        /// <p>An indication of which type of values this option has and whether it is allowable to
        /// select one or more than one of the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Scalar</code> : Values for this option are a single selection from the possible
        /// values, or an unformatted string, or numeric value governed by the
        /// <code>MIN/MAX/Regex</code> constraints.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>List</code> : Values for this option are multiple selections from the possible
        /// values.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Boolean</code> : Values for this option are either <code>true</code> or
        /// <code>false</code> .</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Json</code> : Values for this option are a JSON representation of a
        /// <code>ConfigDocument</code>.</p>
        /// </li>
        /// </ul>
        pub fn value_type(mut self, input: crate::model::ConfigurationOptionValueType) -> Self {
            self.value_type = Some(input);
            self
        }
        /// <p>An indication of which type of values this option has and whether it is allowable to
        /// select one or more than one of the possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Scalar</code> : Values for this option are a single selection from the possible
        /// values, or an unformatted string, or numeric value governed by the
        /// <code>MIN/MAX/Regex</code> constraints.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>List</code> : Values for this option are multiple selections from the possible
        /// values.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Boolean</code> : Values for this option are either <code>true</code> or
        /// <code>false</code> .</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Json</code> : Values for this option are a JSON representation of a
        /// <code>ConfigDocument</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_value_type(
            mut self,
            input: std::option::Option<crate::model::ConfigurationOptionValueType>,
        ) -> Self {
            self.value_type = input;
            self
        }
        /// Appends an item to `value_options`.
        ///
        /// To override the contents of this collection use [`set_value_options`](Self::set_value_options).
        ///
        /// <p>If specified, values for the configuration option are selected from this
        /// list.</p>
        pub fn value_options(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.value_options.unwrap_or_default();
            v.push(input.into());
            self.value_options = Some(v);
            self
        }
        /// <p>If specified, values for the configuration option are selected from this
        /// list.</p>
        pub fn set_value_options(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.value_options = input;
            self
        }
        /// <p>If specified, the configuration option must be a numeric value greater than this
        /// value.</p>
        pub fn min_value(mut self, input: i32) -> Self {
            self.min_value = Some(input);
            self
        }
        /// <p>If specified, the configuration option must be a numeric value greater than this
        /// value.</p>
        pub fn set_min_value(mut self, input: std::option::Option<i32>) -> Self {
            self.min_value = input;
            self
        }
        /// <p>If specified, the configuration option must be a numeric value less than this
        /// value.</p>
        pub fn max_value(mut self, input: i32) -> Self {
            self.max_value = Some(input);
            self
        }
        /// <p>If specified, the configuration option must be a numeric value less than this
        /// value.</p>
        pub fn set_max_value(mut self, input: std::option::Option<i32>) -> Self {
            self.max_value = input;
            self
        }
        /// <p>If specified, the configuration option must be a string value no longer than this
        /// value.</p>
        pub fn max_length(mut self, input: i32) -> Self {
            self.max_length = Some(input);
            self
        }
        /// <p>If specified, the configuration option must be a string value no longer than this
        /// value.</p>
        pub fn set_max_length(mut self, input: std::option::Option<i32>) -> Self {
            self.max_length = input;
            self
        }
        /// <p>If specified, the configuration option must be a string value that satisfies this
        /// regular expression.</p>
        pub fn regex(mut self, input: crate::model::OptionRestrictionRegex) -> Self {
            self.regex = Some(input);
            self
        }
        /// <p>If specified, the configuration option must be a string value that satisfies this
        /// regular expression.</p>
        pub fn set_regex(
            mut self,
            input: std::option::Option<crate::model::OptionRestrictionRegex>,
        ) -> Self {
            self.regex = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationOptionDescription`](crate::model::ConfigurationOptionDescription)
        pub fn build(self) -> crate::model::ConfigurationOptionDescription {
            crate::model::ConfigurationOptionDescription {
                namespace: self.namespace,
                name: self.name,
                default_value: self.default_value,
                change_severity: self.change_severity,
                user_defined: self.user_defined,
                value_type: self.value_type,
                value_options: self.value_options,
                min_value: self.min_value,
                max_value: self.max_value,
                max_length: self.max_length,
                regex: self.regex,
            }
        }
    }
}
impl ConfigurationOptionDescription {
    /// Creates a new builder-style object to manufacture [`ConfigurationOptionDescription`](crate::model::ConfigurationOptionDescription)
    pub fn builder() -> crate::model::configuration_option_description::Builder {
        crate::model::configuration_option_description::Builder::default()
    }
}

/// <p>A regular expression representing a restriction on a string configuration option
/// value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionRestrictionRegex {
    /// <p>The regular expression pattern that a string configuration option value with this
    /// restriction must match.</p>
    pub pattern: std::option::Option<std::string::String>,
    /// <p>A unique name representing this regular expression.</p>
    pub label: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OptionRestrictionRegex {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionRestrictionRegex");
        formatter.field("pattern", &self.pattern);
        formatter.field("label", &self.label);
        formatter.finish()
    }
}
/// See [`OptionRestrictionRegex`](crate::model::OptionRestrictionRegex)
pub mod option_restriction_regex {
    /// A builder for [`OptionRestrictionRegex`](crate::model::OptionRestrictionRegex)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pattern: std::option::Option<std::string::String>,
        pub(crate) label: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The regular expression pattern that a string configuration option value with this
        /// restriction must match.</p>
        pub fn pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern = Some(input.into());
            self
        }
        /// <p>The regular expression pattern that a string configuration option value with this
        /// restriction must match.</p>
        pub fn set_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pattern = input;
            self
        }
        /// <p>A unique name representing this regular expression.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>A unique name representing this regular expression.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionRestrictionRegex`](crate::model::OptionRestrictionRegex)
        pub fn build(self) -> crate::model::OptionRestrictionRegex {
            crate::model::OptionRestrictionRegex {
                pattern: self.pattern,
                label: self.label,
            }
        }
    }
}
impl OptionRestrictionRegex {
    /// Creates a new builder-style object to manufacture [`OptionRestrictionRegex`](crate::model::OptionRestrictionRegex)
    pub fn builder() -> crate::model::option_restriction_regex::Builder {
        crate::model::option_restriction_regex::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigurationOptionValueType {
    #[allow(missing_docs)] // documentation missing in model
    List,
    #[allow(missing_docs)] // documentation missing in model
    Scalar,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigurationOptionValueType {
    fn from(s: &str) -> Self {
        match s {
            "List" => ConfigurationOptionValueType::List,
            "Scalar" => ConfigurationOptionValueType::Scalar,
            other => ConfigurationOptionValueType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigurationOptionValueType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigurationOptionValueType::from(s))
    }
}
impl ConfigurationOptionValueType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigurationOptionValueType::List => "List",
            ConfigurationOptionValueType::Scalar => "Scalar",
            ConfigurationOptionValueType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["List", "Scalar"]
    }
}
impl AsRef<str> for ConfigurationOptionValueType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A set of per-resource AWS Elastic Beanstalk quotas associated with an AWS account. They reflect
/// Elastic Beanstalk resource limits for this account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceQuotas {
    /// <p>The quota for applications in the AWS account.</p>
    pub application_quota: std::option::Option<crate::model::ResourceQuota>,
    /// <p>The quota for application versions in the AWS account.</p>
    pub application_version_quota: std::option::Option<crate::model::ResourceQuota>,
    /// <p>The quota for environments in the AWS account.</p>
    pub environment_quota: std::option::Option<crate::model::ResourceQuota>,
    /// <p>The quota for configuration templates in the AWS account.</p>
    pub configuration_template_quota: std::option::Option<crate::model::ResourceQuota>,
    /// <p>The quota for custom platforms in the AWS account.</p>
    pub custom_platform_quota: std::option::Option<crate::model::ResourceQuota>,
}
impl std::fmt::Debug for ResourceQuotas {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceQuotas");
        formatter.field("application_quota", &self.application_quota);
        formatter.field("application_version_quota", &self.application_version_quota);
        formatter.field("environment_quota", &self.environment_quota);
        formatter.field(
            "configuration_template_quota",
            &self.configuration_template_quota,
        );
        formatter.field("custom_platform_quota", &self.custom_platform_quota);
        formatter.finish()
    }
}
/// See [`ResourceQuotas`](crate::model::ResourceQuotas)
pub mod resource_quotas {
    /// A builder for [`ResourceQuotas`](crate::model::ResourceQuotas)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_quota: std::option::Option<crate::model::ResourceQuota>,
        pub(crate) application_version_quota: std::option::Option<crate::model::ResourceQuota>,
        pub(crate) environment_quota: std::option::Option<crate::model::ResourceQuota>,
        pub(crate) configuration_template_quota: std::option::Option<crate::model::ResourceQuota>,
        pub(crate) custom_platform_quota: std::option::Option<crate::model::ResourceQuota>,
    }
    impl Builder {
        /// <p>The quota for applications in the AWS account.</p>
        pub fn application_quota(mut self, input: crate::model::ResourceQuota) -> Self {
            self.application_quota = Some(input);
            self
        }
        /// <p>The quota for applications in the AWS account.</p>
        pub fn set_application_quota(
            mut self,
            input: std::option::Option<crate::model::ResourceQuota>,
        ) -> Self {
            self.application_quota = input;
            self
        }
        /// <p>The quota for application versions in the AWS account.</p>
        pub fn application_version_quota(mut self, input: crate::model::ResourceQuota) -> Self {
            self.application_version_quota = Some(input);
            self
        }
        /// <p>The quota for application versions in the AWS account.</p>
        pub fn set_application_version_quota(
            mut self,
            input: std::option::Option<crate::model::ResourceQuota>,
        ) -> Self {
            self.application_version_quota = input;
            self
        }
        /// <p>The quota for environments in the AWS account.</p>
        pub fn environment_quota(mut self, input: crate::model::ResourceQuota) -> Self {
            self.environment_quota = Some(input);
            self
        }
        /// <p>The quota for environments in the AWS account.</p>
        pub fn set_environment_quota(
            mut self,
            input: std::option::Option<crate::model::ResourceQuota>,
        ) -> Self {
            self.environment_quota = input;
            self
        }
        /// <p>The quota for configuration templates in the AWS account.</p>
        pub fn configuration_template_quota(mut self, input: crate::model::ResourceQuota) -> Self {
            self.configuration_template_quota = Some(input);
            self
        }
        /// <p>The quota for configuration templates in the AWS account.</p>
        pub fn set_configuration_template_quota(
            mut self,
            input: std::option::Option<crate::model::ResourceQuota>,
        ) -> Self {
            self.configuration_template_quota = input;
            self
        }
        /// <p>The quota for custom platforms in the AWS account.</p>
        pub fn custom_platform_quota(mut self, input: crate::model::ResourceQuota) -> Self {
            self.custom_platform_quota = Some(input);
            self
        }
        /// <p>The quota for custom platforms in the AWS account.</p>
        pub fn set_custom_platform_quota(
            mut self,
            input: std::option::Option<crate::model::ResourceQuota>,
        ) -> Self {
            self.custom_platform_quota = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceQuotas`](crate::model::ResourceQuotas)
        pub fn build(self) -> crate::model::ResourceQuotas {
            crate::model::ResourceQuotas {
                application_quota: self.application_quota,
                application_version_quota: self.application_version_quota,
                environment_quota: self.environment_quota,
                configuration_template_quota: self.configuration_template_quota,
                custom_platform_quota: self.custom_platform_quota,
            }
        }
    }
}
impl ResourceQuotas {
    /// Creates a new builder-style object to manufacture [`ResourceQuotas`](crate::model::ResourceQuotas)
    pub fn builder() -> crate::model::resource_quotas::Builder {
        crate::model::resource_quotas::Builder::default()
    }
}

/// <p>The AWS Elastic Beanstalk quota information for a single resource type in an AWS account. It
/// reflects the resource's limits for this account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceQuota {
    /// <p>The maximum number of instances of this Elastic Beanstalk resource type that an AWS account can
    /// use.</p>
    pub maximum: std::option::Option<i32>,
}
impl std::fmt::Debug for ResourceQuota {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceQuota");
        formatter.field("maximum", &self.maximum);
        formatter.finish()
    }
}
/// See [`ResourceQuota`](crate::model::ResourceQuota)
pub mod resource_quota {
    /// A builder for [`ResourceQuota`](crate::model::ResourceQuota)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maximum: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The maximum number of instances of this Elastic Beanstalk resource type that an AWS account can
        /// use.</p>
        pub fn maximum(mut self, input: i32) -> Self {
            self.maximum = Some(input);
            self
        }
        /// <p>The maximum number of instances of this Elastic Beanstalk resource type that an AWS account can
        /// use.</p>
        pub fn set_maximum(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceQuota`](crate::model::ResourceQuota)
        pub fn build(self) -> crate::model::ResourceQuota {
            crate::model::ResourceQuota {
                maximum: self.maximum,
            }
        }
    }
}
impl ResourceQuota {
    /// Creates a new builder-style object to manufacture [`ResourceQuota`](crate::model::ResourceQuota)
    pub fn builder() -> crate::model::resource_quota::Builder {
        crate::model::resource_quota::Builder::default()
    }
}

/// <p>The builder used to build the custom platform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Builder {
    /// <p>The ARN of the builder.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Builder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Builder");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`Builder`](crate::model::Builder)
pub mod builder {
    /// A builder for [`Builder`](crate::model::Builder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the builder.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the builder.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Builder`](crate::model::Builder)
        pub fn build(self) -> crate::model::Builder {
            crate::model::Builder { arn: self.arn }
        }
    }
}
impl Builder {
    /// Creates a new builder-style object to manufacture [`Builder`](crate::model::Builder)
    pub fn builder() -> crate::model::builder::Builder {
        crate::model::builder::Builder::default()
    }
}

/// <p>A specification for an environment configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceConfiguration {
    /// <p>The name of the application associated with the configuration.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The name of the configuration template.</p>
    pub template_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SourceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceConfiguration");
        formatter.field("application_name", &self.application_name);
        formatter.field("template_name", &self.template_name);
        formatter.finish()
    }
}
/// See [`SourceConfiguration`](crate::model::SourceConfiguration)
pub mod source_configuration {
    /// A builder for [`SourceConfiguration`](crate::model::SourceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the application associated with the configuration.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The name of the application associated with the configuration.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The name of the configuration template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceConfiguration`](crate::model::SourceConfiguration)
        pub fn build(self) -> crate::model::SourceConfiguration {
            crate::model::SourceConfiguration {
                application_name: self.application_name,
                template_name: self.template_name,
            }
        }
    }
}
impl SourceConfiguration {
    /// Creates a new builder-style object to manufacture [`SourceConfiguration`](crate::model::SourceConfiguration)
    pub fn builder() -> crate::model::source_configuration::Builder {
        crate::model::source_configuration::Builder::default()
    }
}

/// <p>Settings for an AWS CodeBuild build.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuildConfiguration {
    /// <p>The name of the artifact of the CodeBuild build.
    /// If provided, Elastic Beanstalk stores the build artifact in the S3 location
    /// <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version-label</i>-<i>artifact-name</i>.zip.
    /// If not provided, Elastic Beanstalk stores the build artifact in the S3 location
    /// <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version-label</i>.zip.
    /// </p>
    pub artifact_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.</p>
    pub code_build_service_role: std::option::Option<std::string::String>,
    /// <p>Information about the compute resources the build project will use.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds</code>
    /// </p>
    /// </li>
    /// </ul>
    pub compute_type: std::option::Option<crate::model::ComputeType>,
    /// <p>The ID of the Docker image to use for this build project.</p>
    pub image: std::option::Option<std::string::String>,
    /// <p>How long in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.</p>
    pub timeout_in_minutes: std::option::Option<i32>,
}
impl std::fmt::Debug for BuildConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuildConfiguration");
        formatter.field("artifact_name", &self.artifact_name);
        formatter.field("code_build_service_role", &self.code_build_service_role);
        formatter.field("compute_type", &self.compute_type);
        formatter.field("image", &self.image);
        formatter.field("timeout_in_minutes", &self.timeout_in_minutes);
        formatter.finish()
    }
}
/// See [`BuildConfiguration`](crate::model::BuildConfiguration)
pub mod build_configuration {
    /// A builder for [`BuildConfiguration`](crate::model::BuildConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) artifact_name: std::option::Option<std::string::String>,
        pub(crate) code_build_service_role: std::option::Option<std::string::String>,
        pub(crate) compute_type: std::option::Option<crate::model::ComputeType>,
        pub(crate) image: std::option::Option<std::string::String>,
        pub(crate) timeout_in_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the artifact of the CodeBuild build.
        /// If provided, Elastic Beanstalk stores the build artifact in the S3 location
        /// <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version-label</i>-<i>artifact-name</i>.zip.
        /// If not provided, Elastic Beanstalk stores the build artifact in the S3 location
        /// <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version-label</i>.zip.
        /// </p>
        pub fn artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_name = Some(input.into());
            self
        }
        /// <p>The name of the artifact of the CodeBuild build.
        /// If provided, Elastic Beanstalk stores the build artifact in the S3 location
        /// <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version-label</i>-<i>artifact-name</i>.zip.
        /// If not provided, Elastic Beanstalk stores the build artifact in the S3 location
        /// <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version-label</i>.zip.
        /// </p>
        pub fn set_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifact_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.</p>
        pub fn code_build_service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_build_service_role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.</p>
        pub fn set_code_build_service_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_build_service_role = input;
            self
        }
        /// <p>Information about the compute resources the build project will use.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn compute_type(mut self, input: crate::model::ComputeType) -> Self {
            self.compute_type = Some(input);
            self
        }
        /// <p>Information about the compute resources the build project will use.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_compute_type(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.compute_type = input;
            self
        }
        /// <p>The ID of the Docker image to use for this build project.</p>
        pub fn image(mut self, input: impl Into<std::string::String>) -> Self {
            self.image = Some(input.into());
            self
        }
        /// <p>The ID of the Docker image to use for this build project.</p>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image = input;
            self
        }
        /// <p>How long in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.</p>
        pub fn timeout_in_minutes(mut self, input: i32) -> Self {
            self.timeout_in_minutes = Some(input);
            self
        }
        /// <p>How long in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.</p>
        pub fn set_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`BuildConfiguration`](crate::model::BuildConfiguration)
        pub fn build(self) -> crate::model::BuildConfiguration {
            crate::model::BuildConfiguration {
                artifact_name: self.artifact_name,
                code_build_service_role: self.code_build_service_role,
                compute_type: self.compute_type,
                image: self.image,
                timeout_in_minutes: self.timeout_in_minutes,
            }
        }
    }
}
impl BuildConfiguration {
    /// Creates a new builder-style object to manufacture [`BuildConfiguration`](crate::model::BuildConfiguration)
    pub fn builder() -> crate::model::build_configuration::Builder {
        crate::model::build_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComputeType {
    #[allow(missing_docs)] // documentation missing in model
    BuildGeneral1Large,
    #[allow(missing_docs)] // documentation missing in model
    BuildGeneral1Medium,
    #[allow(missing_docs)] // documentation missing in model
    BuildGeneral1Small,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComputeType {
    fn from(s: &str) -> Self {
        match s {
            "BUILD_GENERAL1_LARGE" => ComputeType::BuildGeneral1Large,
            "BUILD_GENERAL1_MEDIUM" => ComputeType::BuildGeneral1Medium,
            "BUILD_GENERAL1_SMALL" => ComputeType::BuildGeneral1Small,
            other => ComputeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComputeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComputeType::from(s))
    }
}
impl ComputeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComputeType::BuildGeneral1Large => "BUILD_GENERAL1_LARGE",
            ComputeType::BuildGeneral1Medium => "BUILD_GENERAL1_MEDIUM",
            ComputeType::BuildGeneral1Small => "BUILD_GENERAL1_SMALL",
            ComputeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BUILD_GENERAL1_LARGE",
            "BUILD_GENERAL1_MEDIUM",
            "BUILD_GENERAL1_SMALL",
        ]
    }
}
impl AsRef<str> for ComputeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
