// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AbortEnvironmentUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AbortEnvironmentUpdateError {
    /// Kind of error that occurred.
    pub kind: AbortEnvironmentUpdateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AbortEnvironmentUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AbortEnvironmentUpdateErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AbortEnvironmentUpdateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AbortEnvironmentUpdateErrorKind::InsufficientPrivilegesException(_inner) => {
                _inner.fmt(f)
            }
            AbortEnvironmentUpdateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AbortEnvironmentUpdateError {
    fn code(&self) -> Option<&str> {
        AbortEnvironmentUpdateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AbortEnvironmentUpdateError {
    /// Creates a new `AbortEnvironmentUpdateError`.
    pub fn new(kind: AbortEnvironmentUpdateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AbortEnvironmentUpdateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AbortEnvironmentUpdateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AbortEnvironmentUpdateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AbortEnvironmentUpdateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AbortEnvironmentUpdateErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            AbortEnvironmentUpdateErrorKind::InsufficientPrivilegesException(_)
        )
    }
}
impl std::error::Error for AbortEnvironmentUpdateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AbortEnvironmentUpdateErrorKind::InsufficientPrivilegesException(_inner) => {
                Some(_inner)
            }
            AbortEnvironmentUpdateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ApplyEnvironmentManagedAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ApplyEnvironmentManagedActionError {
    /// Kind of error that occurred.
    pub kind: ApplyEnvironmentManagedActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ApplyEnvironmentManagedAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ApplyEnvironmentManagedActionErrorKind {
    /// <p>A generic service exception has occurred.</p>
    ElasticBeanstalkServiceException(crate::error::ElasticBeanstalkServiceException),
    /// <p>Cannot modify the managed action in its current state.</p>
    ManagedActionInvalidStateException(crate::error::ManagedActionInvalidStateException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ApplyEnvironmentManagedActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ApplyEnvironmentManagedActionErrorKind::ElasticBeanstalkServiceException(_inner) => {
                _inner.fmt(f)
            }
            ApplyEnvironmentManagedActionErrorKind::ManagedActionInvalidStateException(_inner) => {
                _inner.fmt(f)
            }
            ApplyEnvironmentManagedActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ApplyEnvironmentManagedActionError {
    fn code(&self) -> Option<&str> {
        ApplyEnvironmentManagedActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ApplyEnvironmentManagedActionError {
    /// Creates a new `ApplyEnvironmentManagedActionError`.
    pub fn new(
        kind: ApplyEnvironmentManagedActionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ApplyEnvironmentManagedActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ApplyEnvironmentManagedActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ApplyEnvironmentManagedActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ApplyEnvironmentManagedActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ApplyEnvironmentManagedActionErrorKind::ElasticBeanstalkServiceException`.
    pub fn is_elastic_beanstalk_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ApplyEnvironmentManagedActionErrorKind::ElasticBeanstalkServiceException(_)
        )
    }
    /// Returns true if the error kind is `ApplyEnvironmentManagedActionErrorKind::ManagedActionInvalidStateException`.
    pub fn is_managed_action_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ApplyEnvironmentManagedActionErrorKind::ManagedActionInvalidStateException(_)
        )
    }
}
impl std::error::Error for ApplyEnvironmentManagedActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ApplyEnvironmentManagedActionErrorKind::ElasticBeanstalkServiceException(_inner) => {
                Some(_inner)
            }
            ApplyEnvironmentManagedActionErrorKind::ManagedActionInvalidStateException(_inner) => {
                Some(_inner)
            }
            ApplyEnvironmentManagedActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateEnvironmentOperationsRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateEnvironmentOperationsRoleError {
    /// Kind of error that occurred.
    pub kind: AssociateEnvironmentOperationsRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateEnvironmentOperationsRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateEnvironmentOperationsRoleErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateEnvironmentOperationsRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateEnvironmentOperationsRoleErrorKind::InsufficientPrivilegesException(
                _inner,
            ) => _inner.fmt(f),
            AssociateEnvironmentOperationsRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateEnvironmentOperationsRoleError {
    fn code(&self) -> Option<&str> {
        AssociateEnvironmentOperationsRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateEnvironmentOperationsRoleError {
    /// Creates a new `AssociateEnvironmentOperationsRoleError`.
    pub fn new(
        kind: AssociateEnvironmentOperationsRoleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateEnvironmentOperationsRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateEnvironmentOperationsRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateEnvironmentOperationsRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateEnvironmentOperationsRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateEnvironmentOperationsRoleErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateEnvironmentOperationsRoleErrorKind::InsufficientPrivilegesException(_)
        )
    }
}
impl std::error::Error for AssociateEnvironmentOperationsRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateEnvironmentOperationsRoleErrorKind::InsufficientPrivilegesException(
                _inner,
            ) => Some(_inner),
            AssociateEnvironmentOperationsRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CheckDNSAvailability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CheckDNSAvailabilityError {
    /// Kind of error that occurred.
    pub kind: CheckDNSAvailabilityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CheckDNSAvailability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CheckDNSAvailabilityErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CheckDNSAvailabilityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CheckDNSAvailabilityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CheckDNSAvailabilityError {
    fn code(&self) -> Option<&str> {
        CheckDNSAvailabilityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CheckDNSAvailabilityError {
    /// Creates a new `CheckDNSAvailabilityError`.
    pub fn new(kind: CheckDNSAvailabilityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CheckDNSAvailabilityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CheckDNSAvailabilityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CheckDNSAvailabilityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CheckDNSAvailabilityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for CheckDNSAvailabilityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CheckDNSAvailabilityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ComposeEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ComposeEnvironmentsError {
    /// Kind of error that occurred.
    pub kind: ComposeEnvironmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ComposeEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ComposeEnvironmentsErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// <p>The specified account has reached its limit of environments.</p>
    TooManyEnvironmentsException(crate::error::TooManyEnvironmentsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ComposeEnvironmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ComposeEnvironmentsErrorKind::InsufficientPrivilegesException(_inner) => _inner.fmt(f),
            ComposeEnvironmentsErrorKind::TooManyEnvironmentsException(_inner) => _inner.fmt(f),
            ComposeEnvironmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ComposeEnvironmentsError {
    fn code(&self) -> Option<&str> {
        ComposeEnvironmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ComposeEnvironmentsError {
    /// Creates a new `ComposeEnvironmentsError`.
    pub fn new(kind: ComposeEnvironmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ComposeEnvironmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ComposeEnvironmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ComposeEnvironmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ComposeEnvironmentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ComposeEnvironmentsErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            ComposeEnvironmentsErrorKind::InsufficientPrivilegesException(_)
        )
    }
    /// Returns true if the error kind is `ComposeEnvironmentsErrorKind::TooManyEnvironmentsException`.
    pub fn is_too_many_environments_exception(&self) -> bool {
        matches!(
            &self.kind,
            ComposeEnvironmentsErrorKind::TooManyEnvironmentsException(_)
        )
    }
}
impl std::error::Error for ComposeEnvironmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ComposeEnvironmentsErrorKind::InsufficientPrivilegesException(_inner) => Some(_inner),
            ComposeEnvironmentsErrorKind::TooManyEnvironmentsException(_inner) => Some(_inner),
            ComposeEnvironmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApplicationError {
    /// Kind of error that occurred.
    pub kind: CreateApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApplicationErrorKind {
    /// <p>The specified account has reached its limit of applications.</p>
    TooManyApplicationsException(crate::error::TooManyApplicationsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApplicationErrorKind::TooManyApplicationsException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApplicationError {
    fn code(&self) -> Option<&str> {
        CreateApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApplicationError {
    /// Creates a new `CreateApplicationError`.
    pub fn new(kind: CreateApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApplicationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateApplicationErrorKind::TooManyApplicationsException`.
    pub fn is_too_many_applications_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::TooManyApplicationsException(_)
        )
    }
}
impl std::error::Error for CreateApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApplicationErrorKind::TooManyApplicationsException(_inner) => Some(_inner),
            CreateApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateApplicationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApplicationVersionError {
    /// Kind of error that occurred.
    pub kind: CreateApplicationVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApplicationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApplicationVersionErrorKind {
    /// <p>AWS CodeBuild is not available in the specified region.</p>
    CodeBuildNotInServiceRegionException(crate::error::CodeBuildNotInServiceRegionException),
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// <p>The specified S3 bucket does not belong to the S3 region in which the service is
    /// running. The following regions are supported:</p>
    /// <ul>
    /// <li>
    /// <p>IAD/us-east-1</p>
    /// </li>
    /// <li>
    /// <p>PDX/us-west-2</p>
    /// </li>
    /// <li>
    /// <p>DUB/eu-west-1</p>
    /// </li>
    /// </ul>
    S3LocationNotInServiceRegionException(crate::error::S3LocationNotInServiceRegionException),
    /// <p>The specified account has reached its limit of applications.</p>
    TooManyApplicationsException(crate::error::TooManyApplicationsException),
    /// <p>The specified account has reached its limit of application versions.</p>
    TooManyApplicationVersionsException(crate::error::TooManyApplicationVersionsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApplicationVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApplicationVersionErrorKind::CodeBuildNotInServiceRegionException(_inner) => {
                _inner.fmt(f)
            }
            CreateApplicationVersionErrorKind::InsufficientPrivilegesException(_inner) => {
                _inner.fmt(f)
            }
            CreateApplicationVersionErrorKind::S3LocationNotInServiceRegionException(_inner) => {
                _inner.fmt(f)
            }
            CreateApplicationVersionErrorKind::TooManyApplicationsException(_inner) => {
                _inner.fmt(f)
            }
            CreateApplicationVersionErrorKind::TooManyApplicationVersionsException(_inner) => {
                _inner.fmt(f)
            }
            CreateApplicationVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApplicationVersionError {
    fn code(&self) -> Option<&str> {
        CreateApplicationVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApplicationVersionError {
    /// Creates a new `CreateApplicationVersionError`.
    pub fn new(kind: CreateApplicationVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApplicationVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApplicationVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApplicationVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApplicationVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateApplicationVersionErrorKind::CodeBuildNotInServiceRegionException`.
    pub fn is_code_build_not_in_service_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationVersionErrorKind::CodeBuildNotInServiceRegionException(_)
        )
    }
    /// Returns true if the error kind is `CreateApplicationVersionErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationVersionErrorKind::InsufficientPrivilegesException(_)
        )
    }
    /// Returns true if the error kind is `CreateApplicationVersionErrorKind::S3LocationNotInServiceRegionException`.
    pub fn is_s3_location_not_in_service_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationVersionErrorKind::S3LocationNotInServiceRegionException(_)
        )
    }
    /// Returns true if the error kind is `CreateApplicationVersionErrorKind::TooManyApplicationsException`.
    pub fn is_too_many_applications_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationVersionErrorKind::TooManyApplicationsException(_)
        )
    }
    /// Returns true if the error kind is `CreateApplicationVersionErrorKind::TooManyApplicationVersionsException`.
    pub fn is_too_many_application_versions_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationVersionErrorKind::TooManyApplicationVersionsException(_)
        )
    }
}
impl std::error::Error for CreateApplicationVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApplicationVersionErrorKind::CodeBuildNotInServiceRegionException(_inner) => {
                Some(_inner)
            }
            CreateApplicationVersionErrorKind::InsufficientPrivilegesException(_inner) => {
                Some(_inner)
            }
            CreateApplicationVersionErrorKind::S3LocationNotInServiceRegionException(_inner) => {
                Some(_inner)
            }
            CreateApplicationVersionErrorKind::TooManyApplicationsException(_inner) => Some(_inner),
            CreateApplicationVersionErrorKind::TooManyApplicationVersionsException(_inner) => {
                Some(_inner)
            }
            CreateApplicationVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConfigurationTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateConfigurationTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConfigurationTemplateErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// <p>The specified account has reached its limit of Amazon S3 buckets.</p>
    TooManyBucketsException(crate::error::TooManyBucketsException),
    /// <p>The specified account has reached its limit of configuration templates.</p>
    TooManyConfigurationTemplatesException(crate::error::TooManyConfigurationTemplatesException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConfigurationTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConfigurationTemplateErrorKind::InsufficientPrivilegesException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationTemplateErrorKind::TooManyBucketsException(_inner) => _inner.fmt(f),
            CreateConfigurationTemplateErrorKind::TooManyConfigurationTemplatesException(
                _inner,
            ) => _inner.fmt(f),
            CreateConfigurationTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConfigurationTemplateError {
    fn code(&self) -> Option<&str> {
        CreateConfigurationTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConfigurationTemplateError {
    /// Creates a new `CreateConfigurationTemplateError`.
    pub fn new(kind: CreateConfigurationTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConfigurationTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConfigurationTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConfigurationTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConfigurationTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateConfigurationTemplateErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationTemplateErrorKind::InsufficientPrivilegesException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationTemplateErrorKind::TooManyBucketsException`.
    pub fn is_too_many_buckets_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationTemplateErrorKind::TooManyBucketsException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationTemplateErrorKind::TooManyConfigurationTemplatesException`.
    pub fn is_too_many_configuration_templates_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationTemplateErrorKind::TooManyConfigurationTemplatesException(_)
        )
    }
}
impl std::error::Error for CreateConfigurationTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConfigurationTemplateErrorKind::InsufficientPrivilegesException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationTemplateErrorKind::TooManyBucketsException(_inner) => Some(_inner),
            CreateConfigurationTemplateErrorKind::TooManyConfigurationTemplatesException(
                _inner,
            ) => Some(_inner),
            CreateConfigurationTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEnvironmentError {
    /// Kind of error that occurred.
    pub kind: CreateEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEnvironmentErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// <p>The specified account has reached its limit of environments.</p>
    TooManyEnvironmentsException(crate::error::TooManyEnvironmentsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEnvironmentErrorKind::InsufficientPrivilegesException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::TooManyEnvironmentsException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEnvironmentError {
    fn code(&self) -> Option<&str> {
        CreateEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEnvironmentError {
    /// Creates a new `CreateEnvironmentError`.
    pub fn new(kind: CreateEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateEnvironmentErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::InsufficientPrivilegesException(_)
        )
    }
    /// Returns true if the error kind is `CreateEnvironmentErrorKind::TooManyEnvironmentsException`.
    pub fn is_too_many_environments_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::TooManyEnvironmentsException(_)
        )
    }
}
impl std::error::Error for CreateEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEnvironmentErrorKind::InsufficientPrivilegesException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::TooManyEnvironmentsException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePlatformVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePlatformVersionError {
    /// Kind of error that occurred.
    pub kind: CreatePlatformVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePlatformVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePlatformVersionErrorKind {
    /// <p>A generic service exception has occurred.</p>
    ElasticBeanstalkServiceException(crate::error::ElasticBeanstalkServiceException),
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// <p>You have exceeded the maximum number of allowed platforms associated with the account.</p>
    TooManyPlatformsException(crate::error::TooManyPlatformsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePlatformVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePlatformVersionErrorKind::ElasticBeanstalkServiceException(_inner) => {
                _inner.fmt(f)
            }
            CreatePlatformVersionErrorKind::InsufficientPrivilegesException(_inner) => {
                _inner.fmt(f)
            }
            CreatePlatformVersionErrorKind::TooManyPlatformsException(_inner) => _inner.fmt(f),
            CreatePlatformVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePlatformVersionError {
    fn code(&self) -> Option<&str> {
        CreatePlatformVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePlatformVersionError {
    /// Creates a new `CreatePlatformVersionError`.
    pub fn new(kind: CreatePlatformVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePlatformVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePlatformVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePlatformVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePlatformVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreatePlatformVersionErrorKind::ElasticBeanstalkServiceException`.
    pub fn is_elastic_beanstalk_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlatformVersionErrorKind::ElasticBeanstalkServiceException(_)
        )
    }
    /// Returns true if the error kind is `CreatePlatformVersionErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlatformVersionErrorKind::InsufficientPrivilegesException(_)
        )
    }
    /// Returns true if the error kind is `CreatePlatformVersionErrorKind::TooManyPlatformsException`.
    pub fn is_too_many_platforms_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlatformVersionErrorKind::TooManyPlatformsException(_)
        )
    }
}
impl std::error::Error for CreatePlatformVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePlatformVersionErrorKind::ElasticBeanstalkServiceException(_inner) => {
                Some(_inner)
            }
            CreatePlatformVersionErrorKind::InsufficientPrivilegesException(_inner) => Some(_inner),
            CreatePlatformVersionErrorKind::TooManyPlatformsException(_inner) => Some(_inner),
            CreatePlatformVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStorageLocation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStorageLocationError {
    /// Kind of error that occurred.
    pub kind: CreateStorageLocationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStorageLocation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStorageLocationErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// <p>The specified account does not have a subscription to Amazon S3.</p>
    S3SubscriptionRequiredException(crate::error::S3SubscriptionRequiredException),
    /// <p>The specified account has reached its limit of Amazon S3 buckets.</p>
    TooManyBucketsException(crate::error::TooManyBucketsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStorageLocationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStorageLocationErrorKind::InsufficientPrivilegesException(_inner) => {
                _inner.fmt(f)
            }
            CreateStorageLocationErrorKind::S3SubscriptionRequiredException(_inner) => {
                _inner.fmt(f)
            }
            CreateStorageLocationErrorKind::TooManyBucketsException(_inner) => _inner.fmt(f),
            CreateStorageLocationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStorageLocationError {
    fn code(&self) -> Option<&str> {
        CreateStorageLocationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStorageLocationError {
    /// Creates a new `CreateStorageLocationError`.
    pub fn new(kind: CreateStorageLocationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStorageLocationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStorageLocationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStorageLocationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStorageLocationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateStorageLocationErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStorageLocationErrorKind::InsufficientPrivilegesException(_)
        )
    }
    /// Returns true if the error kind is `CreateStorageLocationErrorKind::S3SubscriptionRequiredException`.
    pub fn is_s3_subscription_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStorageLocationErrorKind::S3SubscriptionRequiredException(_)
        )
    }
    /// Returns true if the error kind is `CreateStorageLocationErrorKind::TooManyBucketsException`.
    pub fn is_too_many_buckets_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStorageLocationErrorKind::TooManyBucketsException(_)
        )
    }
}
impl std::error::Error for CreateStorageLocationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStorageLocationErrorKind::InsufficientPrivilegesException(_inner) => Some(_inner),
            CreateStorageLocationErrorKind::S3SubscriptionRequiredException(_inner) => Some(_inner),
            CreateStorageLocationErrorKind::TooManyBucketsException(_inner) => Some(_inner),
            CreateStorageLocationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApplicationError {
    /// Kind of error that occurred.
    pub kind: DeleteApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApplicationErrorKind {
    /// <p>Unable to perform the specified operation because another operation that effects an
    /// element in this activity is already in progress.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApplicationErrorKind::OperationInProgressException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApplicationError {
    fn code(&self) -> Option<&str> {
        DeleteApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApplicationError {
    /// Creates a new `DeleteApplicationError`.
    pub fn new(kind: DeleteApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApplicationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteApplicationErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::OperationInProgressException(_)
        )
    }
}
impl std::error::Error for DeleteApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApplicationErrorKind::OperationInProgressException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApplicationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApplicationVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteApplicationVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApplicationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApplicationVersionErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// <p>Unable to perform the specified operation because another operation that effects an
    /// element in this activity is already in progress.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>The specified S3 bucket does not belong to the S3 region in which the service is
    /// running. The following regions are supported:</p>
    /// <ul>
    /// <li>
    /// <p>IAD/us-east-1</p>
    /// </li>
    /// <li>
    /// <p>PDX/us-west-2</p>
    /// </li>
    /// <li>
    /// <p>DUB/eu-west-1</p>
    /// </li>
    /// </ul>
    S3LocationNotInServiceRegionException(crate::error::S3LocationNotInServiceRegionException),
    /// <p>Unable to delete the Amazon S3 source bundle associated with the application version.
    /// The application version was deleted successfully.</p>
    SourceBundleDeletionException(crate::error::SourceBundleDeletionException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApplicationVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApplicationVersionErrorKind::InsufficientPrivilegesException(_inner) => {
                _inner.fmt(f)
            }
            DeleteApplicationVersionErrorKind::OperationInProgressException(_inner) => {
                _inner.fmt(f)
            }
            DeleteApplicationVersionErrorKind::S3LocationNotInServiceRegionException(_inner) => {
                _inner.fmt(f)
            }
            DeleteApplicationVersionErrorKind::SourceBundleDeletionException(_inner) => {
                _inner.fmt(f)
            }
            DeleteApplicationVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApplicationVersionError {
    fn code(&self) -> Option<&str> {
        DeleteApplicationVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApplicationVersionError {
    /// Creates a new `DeleteApplicationVersionError`.
    pub fn new(kind: DeleteApplicationVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApplicationVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApplicationVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApplicationVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApplicationVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteApplicationVersionErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationVersionErrorKind::InsufficientPrivilegesException(_)
        )
    }
    /// Returns true if the error kind is `DeleteApplicationVersionErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationVersionErrorKind::OperationInProgressException(_)
        )
    }
    /// Returns true if the error kind is `DeleteApplicationVersionErrorKind::S3LocationNotInServiceRegionException`.
    pub fn is_s3_location_not_in_service_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationVersionErrorKind::S3LocationNotInServiceRegionException(_)
        )
    }
    /// Returns true if the error kind is `DeleteApplicationVersionErrorKind::SourceBundleDeletionException`.
    pub fn is_source_bundle_deletion_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationVersionErrorKind::SourceBundleDeletionException(_)
        )
    }
}
impl std::error::Error for DeleteApplicationVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApplicationVersionErrorKind::InsufficientPrivilegesException(_inner) => {
                Some(_inner)
            }
            DeleteApplicationVersionErrorKind::OperationInProgressException(_inner) => Some(_inner),
            DeleteApplicationVersionErrorKind::S3LocationNotInServiceRegionException(_inner) => {
                Some(_inner)
            }
            DeleteApplicationVersionErrorKind::SourceBundleDeletionException(_inner) => {
                Some(_inner)
            }
            DeleteApplicationVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigurationTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigurationTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigurationTemplateErrorKind {
    /// <p>Unable to perform the specified operation because another operation that effects an
    /// element in this activity is already in progress.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigurationTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigurationTemplateErrorKind::OperationInProgressException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConfigurationTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigurationTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteConfigurationTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConfigurationTemplateError {
    /// Creates a new `DeleteConfigurationTemplateError`.
    pub fn new(kind: DeleteConfigurationTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigurationTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigurationTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigurationTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigurationTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteConfigurationTemplateErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationTemplateErrorKind::OperationInProgressException(_)
        )
    }
}
impl std::error::Error for DeleteConfigurationTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigurationTemplateErrorKind::OperationInProgressException(_inner) => {
                Some(_inner)
            }
            DeleteConfigurationTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEnvironmentConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEnvironmentConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteEnvironmentConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEnvironmentConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEnvironmentConfigurationErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEnvironmentConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEnvironmentConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEnvironmentConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteEnvironmentConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEnvironmentConfigurationError {
    /// Creates a new `DeleteEnvironmentConfigurationError`.
    pub fn new(
        kind: DeleteEnvironmentConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEnvironmentConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEnvironmentConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEnvironmentConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEnvironmentConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DeleteEnvironmentConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEnvironmentConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePlatformVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePlatformVersionError {
    /// Kind of error that occurred.
    pub kind: DeletePlatformVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePlatformVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePlatformVersionErrorKind {
    /// <p>A generic service exception has occurred.</p>
    ElasticBeanstalkServiceException(crate::error::ElasticBeanstalkServiceException),
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// <p>Unable to perform the specified operation because another operation that effects an
    /// element in this activity is already in progress.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>You cannot delete the platform version because there are still environments running on it.</p>
    PlatformVersionStillReferencedException(crate::error::PlatformVersionStillReferencedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePlatformVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePlatformVersionErrorKind::ElasticBeanstalkServiceException(_inner) => {
                _inner.fmt(f)
            }
            DeletePlatformVersionErrorKind::InsufficientPrivilegesException(_inner) => {
                _inner.fmt(f)
            }
            DeletePlatformVersionErrorKind::OperationInProgressException(_inner) => _inner.fmt(f),
            DeletePlatformVersionErrorKind::PlatformVersionStillReferencedException(_inner) => {
                _inner.fmt(f)
            }
            DeletePlatformVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePlatformVersionError {
    fn code(&self) -> Option<&str> {
        DeletePlatformVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePlatformVersionError {
    /// Creates a new `DeletePlatformVersionError`.
    pub fn new(kind: DeletePlatformVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePlatformVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePlatformVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePlatformVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePlatformVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeletePlatformVersionErrorKind::ElasticBeanstalkServiceException`.
    pub fn is_elastic_beanstalk_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePlatformVersionErrorKind::ElasticBeanstalkServiceException(_)
        )
    }
    /// Returns true if the error kind is `DeletePlatformVersionErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePlatformVersionErrorKind::InsufficientPrivilegesException(_)
        )
    }
    /// Returns true if the error kind is `DeletePlatformVersionErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePlatformVersionErrorKind::OperationInProgressException(_)
        )
    }
    /// Returns true if the error kind is `DeletePlatformVersionErrorKind::PlatformVersionStillReferencedException`.
    pub fn is_platform_version_still_referenced_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePlatformVersionErrorKind::PlatformVersionStillReferencedException(_)
        )
    }
}
impl std::error::Error for DeletePlatformVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePlatformVersionErrorKind::ElasticBeanstalkServiceException(_inner) => {
                Some(_inner)
            }
            DeletePlatformVersionErrorKind::InsufficientPrivilegesException(_inner) => Some(_inner),
            DeletePlatformVersionErrorKind::OperationInProgressException(_inner) => Some(_inner),
            DeletePlatformVersionErrorKind::PlatformVersionStillReferencedException(_inner) => {
                Some(_inner)
            }
            DeletePlatformVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountAttributesErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountAttributesErrorKind::InsufficientPrivilegesException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeAccountAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountAttributesError {
    /// Creates a new `DescribeAccountAttributesError`.
    pub fn new(kind: DescribeAccountAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAccountAttributesErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAttributesErrorKind::InsufficientPrivilegesException(_)
        )
    }
}
impl std::error::Error for DescribeAccountAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountAttributesErrorKind::InsufficientPrivilegesException(_inner) => {
                Some(_inner)
            }
            DescribeAccountAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeApplicationsError {
    /// Kind of error that occurred.
    pub kind: DescribeApplicationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeApplicationsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeApplicationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeApplicationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeApplicationsError {
    fn code(&self) -> Option<&str> {
        DescribeApplicationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeApplicationsError {
    /// Creates a new `DescribeApplicationsError`.
    pub fn new(kind: DescribeApplicationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeApplicationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeApplicationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeApplicationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeApplicationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeApplicationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeApplicationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeApplicationVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeApplicationVersionsError {
    /// Kind of error that occurred.
    pub kind: DescribeApplicationVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeApplicationVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeApplicationVersionsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeApplicationVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeApplicationVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeApplicationVersionsError {
    fn code(&self) -> Option<&str> {
        DescribeApplicationVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeApplicationVersionsError {
    /// Creates a new `DescribeApplicationVersionsError`.
    pub fn new(kind: DescribeApplicationVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeApplicationVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeApplicationVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeApplicationVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeApplicationVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeApplicationVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeApplicationVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConfigurationOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConfigurationOptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeConfigurationOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConfigurationOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConfigurationOptionsErrorKind {
    /// <p>The specified account has reached its limit of Amazon S3 buckets.</p>
    TooManyBucketsException(crate::error::TooManyBucketsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConfigurationOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConfigurationOptionsErrorKind::TooManyBucketsException(_inner) => _inner.fmt(f),
            DescribeConfigurationOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConfigurationOptionsError {
    fn code(&self) -> Option<&str> {
        DescribeConfigurationOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConfigurationOptionsError {
    /// Creates a new `DescribeConfigurationOptionsError`.
    pub fn new(kind: DescribeConfigurationOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConfigurationOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConfigurationOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConfigurationOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConfigurationOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeConfigurationOptionsErrorKind::TooManyBucketsException`.
    pub fn is_too_many_buckets_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationOptionsErrorKind::TooManyBucketsException(_)
        )
    }
}
impl std::error::Error for DescribeConfigurationOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConfigurationOptionsErrorKind::TooManyBucketsException(_inner) => Some(_inner),
            DescribeConfigurationOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConfigurationSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConfigurationSettingsError {
    /// Kind of error that occurred.
    pub kind: DescribeConfigurationSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConfigurationSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConfigurationSettingsErrorKind {
    /// <p>The specified account has reached its limit of Amazon S3 buckets.</p>
    TooManyBucketsException(crate::error::TooManyBucketsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConfigurationSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConfigurationSettingsErrorKind::TooManyBucketsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConfigurationSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConfigurationSettingsError {
    fn code(&self) -> Option<&str> {
        DescribeConfigurationSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConfigurationSettingsError {
    /// Creates a new `DescribeConfigurationSettingsError`.
    pub fn new(
        kind: DescribeConfigurationSettingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConfigurationSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConfigurationSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConfigurationSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConfigurationSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeConfigurationSettingsErrorKind::TooManyBucketsException`.
    pub fn is_too_many_buckets_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationSettingsErrorKind::TooManyBucketsException(_)
        )
    }
}
impl std::error::Error for DescribeConfigurationSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConfigurationSettingsErrorKind::TooManyBucketsException(_inner) => Some(_inner),
            DescribeConfigurationSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEnvironmentHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEnvironmentHealthError {
    /// Kind of error that occurred.
    pub kind: DescribeEnvironmentHealthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEnvironmentHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEnvironmentHealthErrorKind {
    /// <p>A generic service exception has occurred.</p>
    ElasticBeanstalkServiceException(crate::error::ElasticBeanstalkServiceException),
    /// <p>One or more input parameters is not valid. Please correct the input parameters and try
    /// the operation again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEnvironmentHealthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEnvironmentHealthErrorKind::ElasticBeanstalkServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEnvironmentHealthErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeEnvironmentHealthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEnvironmentHealthError {
    fn code(&self) -> Option<&str> {
        DescribeEnvironmentHealthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEnvironmentHealthError {
    /// Creates a new `DescribeEnvironmentHealthError`.
    pub fn new(kind: DescribeEnvironmentHealthErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEnvironmentHealthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEnvironmentHealthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEnvironmentHealthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEnvironmentHealthErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeEnvironmentHealthErrorKind::ElasticBeanstalkServiceException`.
    pub fn is_elastic_beanstalk_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentHealthErrorKind::ElasticBeanstalkServiceException(_)
        )
    }
    /// Returns true if the error kind is `DescribeEnvironmentHealthErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentHealthErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeEnvironmentHealthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEnvironmentHealthErrorKind::ElasticBeanstalkServiceException(_inner) => {
                Some(_inner)
            }
            DescribeEnvironmentHealthErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeEnvironmentHealthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEnvironmentManagedActionHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEnvironmentManagedActionHistoryError {
    /// Kind of error that occurred.
    pub kind: DescribeEnvironmentManagedActionHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEnvironmentManagedActionHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEnvironmentManagedActionHistoryErrorKind {
    /// <p>A generic service exception has occurred.</p>
    ElasticBeanstalkServiceException(crate::error::ElasticBeanstalkServiceException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEnvironmentManagedActionHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEnvironmentManagedActionHistoryErrorKind::ElasticBeanstalkServiceException(
                _inner,
            ) => _inner.fmt(f),
            DescribeEnvironmentManagedActionHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEnvironmentManagedActionHistoryError {
    fn code(&self) -> Option<&str> {
        DescribeEnvironmentManagedActionHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEnvironmentManagedActionHistoryError {
    /// Creates a new `DescribeEnvironmentManagedActionHistoryError`.
    pub fn new(
        kind: DescribeEnvironmentManagedActionHistoryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEnvironmentManagedActionHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEnvironmentManagedActionHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEnvironmentManagedActionHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEnvironmentManagedActionHistoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeEnvironmentManagedActionHistoryErrorKind::ElasticBeanstalkServiceException`.
    pub fn is_elastic_beanstalk_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentManagedActionHistoryErrorKind::ElasticBeanstalkServiceException(_)
        )
    }
}
impl std::error::Error for DescribeEnvironmentManagedActionHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEnvironmentManagedActionHistoryErrorKind::ElasticBeanstalkServiceException(
                _inner,
            ) => Some(_inner),
            DescribeEnvironmentManagedActionHistoryErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeEnvironmentManagedActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEnvironmentManagedActionsError {
    /// Kind of error that occurred.
    pub kind: DescribeEnvironmentManagedActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEnvironmentManagedActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEnvironmentManagedActionsErrorKind {
    /// <p>A generic service exception has occurred.</p>
    ElasticBeanstalkServiceException(crate::error::ElasticBeanstalkServiceException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEnvironmentManagedActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEnvironmentManagedActionsErrorKind::ElasticBeanstalkServiceException(
                _inner,
            ) => _inner.fmt(f),
            DescribeEnvironmentManagedActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEnvironmentManagedActionsError {
    fn code(&self) -> Option<&str> {
        DescribeEnvironmentManagedActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEnvironmentManagedActionsError {
    /// Creates a new `DescribeEnvironmentManagedActionsError`.
    pub fn new(
        kind: DescribeEnvironmentManagedActionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEnvironmentManagedActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEnvironmentManagedActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEnvironmentManagedActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEnvironmentManagedActionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeEnvironmentManagedActionsErrorKind::ElasticBeanstalkServiceException`.
    pub fn is_elastic_beanstalk_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentManagedActionsErrorKind::ElasticBeanstalkServiceException(_)
        )
    }
}
impl std::error::Error for DescribeEnvironmentManagedActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEnvironmentManagedActionsErrorKind::ElasticBeanstalkServiceException(
                _inner,
            ) => Some(_inner),
            DescribeEnvironmentManagedActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEnvironmentResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEnvironmentResourcesError {
    /// Kind of error that occurred.
    pub kind: DescribeEnvironmentResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEnvironmentResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEnvironmentResourcesErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEnvironmentResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEnvironmentResourcesErrorKind::InsufficientPrivilegesException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEnvironmentResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEnvironmentResourcesError {
    fn code(&self) -> Option<&str> {
        DescribeEnvironmentResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEnvironmentResourcesError {
    /// Creates a new `DescribeEnvironmentResourcesError`.
    pub fn new(kind: DescribeEnvironmentResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEnvironmentResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEnvironmentResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEnvironmentResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEnvironmentResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeEnvironmentResourcesErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEnvironmentResourcesErrorKind::InsufficientPrivilegesException(_)
        )
    }
}
impl std::error::Error for DescribeEnvironmentResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEnvironmentResourcesErrorKind::InsufficientPrivilegesException(_inner) => {
                Some(_inner)
            }
            DescribeEnvironmentResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEnvironmentsError {
    /// Kind of error that occurred.
    pub kind: DescribeEnvironmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEnvironmentsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEnvironmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEnvironmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEnvironmentsError {
    fn code(&self) -> Option<&str> {
        DescribeEnvironmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEnvironmentsError {
    /// Creates a new `DescribeEnvironmentsError`.
    pub fn new(kind: DescribeEnvironmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEnvironmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEnvironmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEnvironmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEnvironmentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEnvironmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEnvironmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventsError {
    fn code(&self) -> Option<&str> {
        DescribeEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventsError {
    /// Creates a new `DescribeEventsError`.
    pub fn new(kind: DescribeEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInstancesHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstancesHealthError {
    /// Kind of error that occurred.
    pub kind: DescribeInstancesHealthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstancesHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstancesHealthErrorKind {
    /// <p>A generic service exception has occurred.</p>
    ElasticBeanstalkServiceException(crate::error::ElasticBeanstalkServiceException),
    /// <p>One or more input parameters is not valid. Please correct the input parameters and try
    /// the operation again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstancesHealthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstancesHealthErrorKind::ElasticBeanstalkServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeInstancesHealthErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeInstancesHealthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstancesHealthError {
    fn code(&self) -> Option<&str> {
        DescribeInstancesHealthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstancesHealthError {
    /// Creates a new `DescribeInstancesHealthError`.
    pub fn new(kind: DescribeInstancesHealthErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstancesHealthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstancesHealthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstancesHealthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstancesHealthErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeInstancesHealthErrorKind::ElasticBeanstalkServiceException`.
    pub fn is_elastic_beanstalk_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancesHealthErrorKind::ElasticBeanstalkServiceException(_)
        )
    }
    /// Returns true if the error kind is `DescribeInstancesHealthErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancesHealthErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeInstancesHealthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstancesHealthErrorKind::ElasticBeanstalkServiceException(_inner) => {
                Some(_inner)
            }
            DescribeInstancesHealthErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeInstancesHealthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePlatformVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePlatformVersionError {
    /// Kind of error that occurred.
    pub kind: DescribePlatformVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePlatformVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePlatformVersionErrorKind {
    /// <p>A generic service exception has occurred.</p>
    ElasticBeanstalkServiceException(crate::error::ElasticBeanstalkServiceException),
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePlatformVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePlatformVersionErrorKind::ElasticBeanstalkServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribePlatformVersionErrorKind::InsufficientPrivilegesException(_inner) => {
                _inner.fmt(f)
            }
            DescribePlatformVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePlatformVersionError {
    fn code(&self) -> Option<&str> {
        DescribePlatformVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePlatformVersionError {
    /// Creates a new `DescribePlatformVersionError`.
    pub fn new(kind: DescribePlatformVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePlatformVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePlatformVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePlatformVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePlatformVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribePlatformVersionErrorKind::ElasticBeanstalkServiceException`.
    pub fn is_elastic_beanstalk_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePlatformVersionErrorKind::ElasticBeanstalkServiceException(_)
        )
    }
    /// Returns true if the error kind is `DescribePlatformVersionErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePlatformVersionErrorKind::InsufficientPrivilegesException(_)
        )
    }
}
impl std::error::Error for DescribePlatformVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePlatformVersionErrorKind::ElasticBeanstalkServiceException(_inner) => {
                Some(_inner)
            }
            DescribePlatformVersionErrorKind::InsufficientPrivilegesException(_inner) => {
                Some(_inner)
            }
            DescribePlatformVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateEnvironmentOperationsRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateEnvironmentOperationsRoleError {
    /// Kind of error that occurred.
    pub kind: DisassociateEnvironmentOperationsRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateEnvironmentOperationsRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateEnvironmentOperationsRoleErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateEnvironmentOperationsRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateEnvironmentOperationsRoleErrorKind::InsufficientPrivilegesException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateEnvironmentOperationsRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateEnvironmentOperationsRoleError {
    fn code(&self) -> Option<&str> {
        DisassociateEnvironmentOperationsRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateEnvironmentOperationsRoleError {
    /// Creates a new `DisassociateEnvironmentOperationsRoleError`.
    pub fn new(
        kind: DisassociateEnvironmentOperationsRoleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateEnvironmentOperationsRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateEnvironmentOperationsRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateEnvironmentOperationsRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateEnvironmentOperationsRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateEnvironmentOperationsRoleErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateEnvironmentOperationsRoleErrorKind::InsufficientPrivilegesException(_)
        )
    }
}
impl std::error::Error for DisassociateEnvironmentOperationsRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateEnvironmentOperationsRoleErrorKind::InsufficientPrivilegesException(
                _inner,
            ) => Some(_inner),
            DisassociateEnvironmentOperationsRoleErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListAvailableSolutionStacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAvailableSolutionStacksError {
    /// Kind of error that occurred.
    pub kind: ListAvailableSolutionStacksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAvailableSolutionStacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAvailableSolutionStacksErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAvailableSolutionStacksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAvailableSolutionStacksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAvailableSolutionStacksError {
    fn code(&self) -> Option<&str> {
        ListAvailableSolutionStacksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAvailableSolutionStacksError {
    /// Creates a new `ListAvailableSolutionStacksError`.
    pub fn new(kind: ListAvailableSolutionStacksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAvailableSolutionStacksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAvailableSolutionStacksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAvailableSolutionStacksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAvailableSolutionStacksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListAvailableSolutionStacksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAvailableSolutionStacksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPlatformBranches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPlatformBranchesError {
    /// Kind of error that occurred.
    pub kind: ListPlatformBranchesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPlatformBranches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPlatformBranchesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPlatformBranchesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPlatformBranchesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPlatformBranchesError {
    fn code(&self) -> Option<&str> {
        ListPlatformBranchesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPlatformBranchesError {
    /// Creates a new `ListPlatformBranchesError`.
    pub fn new(kind: ListPlatformBranchesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPlatformBranchesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPlatformBranchesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPlatformBranchesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPlatformBranchesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListPlatformBranchesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPlatformBranchesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPlatformVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPlatformVersionsError {
    /// Kind of error that occurred.
    pub kind: ListPlatformVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPlatformVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPlatformVersionsErrorKind {
    /// <p>A generic service exception has occurred.</p>
    ElasticBeanstalkServiceException(crate::error::ElasticBeanstalkServiceException),
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPlatformVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPlatformVersionsErrorKind::ElasticBeanstalkServiceException(_inner) => {
                _inner.fmt(f)
            }
            ListPlatformVersionsErrorKind::InsufficientPrivilegesException(_inner) => _inner.fmt(f),
            ListPlatformVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPlatformVersionsError {
    fn code(&self) -> Option<&str> {
        ListPlatformVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPlatformVersionsError {
    /// Creates a new `ListPlatformVersionsError`.
    pub fn new(kind: ListPlatformVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPlatformVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPlatformVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPlatformVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPlatformVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPlatformVersionsErrorKind::ElasticBeanstalkServiceException`.
    pub fn is_elastic_beanstalk_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPlatformVersionsErrorKind::ElasticBeanstalkServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListPlatformVersionsErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPlatformVersionsErrorKind::InsufficientPrivilegesException(_)
        )
    }
}
impl std::error::Error for ListPlatformVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPlatformVersionsErrorKind::ElasticBeanstalkServiceException(_inner) => Some(_inner),
            ListPlatformVersionsErrorKind::InsufficientPrivilegesException(_inner) => Some(_inner),
            ListPlatformVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN).</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The type of the specified Amazon Resource Name (ARN) isn't supported for this operation.</p>
    ResourceTypeNotSupportedException(crate::error::ResourceTypeNotSupportedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InsufficientPrivilegesException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceTypeNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InsufficientPrivilegesException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceTypeNotSupportedException`.
    pub fn is_resource_type_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceTypeNotSupportedException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InsufficientPrivilegesException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceTypeNotSupportedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RebuildEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RebuildEnvironmentError {
    /// Kind of error that occurred.
    pub kind: RebuildEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RebuildEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RebuildEnvironmentErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RebuildEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RebuildEnvironmentErrorKind::InsufficientPrivilegesException(_inner) => _inner.fmt(f),
            RebuildEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RebuildEnvironmentError {
    fn code(&self) -> Option<&str> {
        RebuildEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RebuildEnvironmentError {
    /// Creates a new `RebuildEnvironmentError`.
    pub fn new(kind: RebuildEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RebuildEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RebuildEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RebuildEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RebuildEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RebuildEnvironmentErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebuildEnvironmentErrorKind::InsufficientPrivilegesException(_)
        )
    }
}
impl std::error::Error for RebuildEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RebuildEnvironmentErrorKind::InsufficientPrivilegesException(_inner) => Some(_inner),
            RebuildEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RequestEnvironmentInfo` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RequestEnvironmentInfoError {
    /// Kind of error that occurred.
    pub kind: RequestEnvironmentInfoErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RequestEnvironmentInfo` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RequestEnvironmentInfoErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RequestEnvironmentInfoError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RequestEnvironmentInfoErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RequestEnvironmentInfoError {
    fn code(&self) -> Option<&str> {
        RequestEnvironmentInfoError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RequestEnvironmentInfoError {
    /// Creates a new `RequestEnvironmentInfoError`.
    pub fn new(kind: RequestEnvironmentInfoErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RequestEnvironmentInfoError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RequestEnvironmentInfoErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RequestEnvironmentInfoError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RequestEnvironmentInfoErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for RequestEnvironmentInfoError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RequestEnvironmentInfoErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestartAppServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestartAppServerError {
    /// Kind of error that occurred.
    pub kind: RestartAppServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestartAppServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestartAppServerErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestartAppServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestartAppServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestartAppServerError {
    fn code(&self) -> Option<&str> {
        RestartAppServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestartAppServerError {
    /// Creates a new `RestartAppServerError`.
    pub fn new(kind: RestartAppServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestartAppServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestartAppServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestartAppServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestartAppServerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for RestartAppServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestartAppServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RetrieveEnvironmentInfo` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RetrieveEnvironmentInfoError {
    /// Kind of error that occurred.
    pub kind: RetrieveEnvironmentInfoErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RetrieveEnvironmentInfo` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RetrieveEnvironmentInfoErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RetrieveEnvironmentInfoError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RetrieveEnvironmentInfoErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RetrieveEnvironmentInfoError {
    fn code(&self) -> Option<&str> {
        RetrieveEnvironmentInfoError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RetrieveEnvironmentInfoError {
    /// Creates a new `RetrieveEnvironmentInfoError`.
    pub fn new(kind: RetrieveEnvironmentInfoErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RetrieveEnvironmentInfoError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RetrieveEnvironmentInfoErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RetrieveEnvironmentInfoError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RetrieveEnvironmentInfoErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for RetrieveEnvironmentInfoError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RetrieveEnvironmentInfoErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SwapEnvironmentCNAMEs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SwapEnvironmentCNAMEsError {
    /// Kind of error that occurred.
    pub kind: SwapEnvironmentCNAMEsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SwapEnvironmentCNAMEs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SwapEnvironmentCNAMEsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SwapEnvironmentCNAMEsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SwapEnvironmentCNAMEsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SwapEnvironmentCNAMEsError {
    fn code(&self) -> Option<&str> {
        SwapEnvironmentCNAMEsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SwapEnvironmentCNAMEsError {
    /// Creates a new `SwapEnvironmentCNAMEsError`.
    pub fn new(kind: SwapEnvironmentCNAMEsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SwapEnvironmentCNAMEsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SwapEnvironmentCNAMEsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SwapEnvironmentCNAMEsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SwapEnvironmentCNAMEsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SwapEnvironmentCNAMEsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SwapEnvironmentCNAMEsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TerminateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TerminateEnvironmentError {
    /// Kind of error that occurred.
    pub kind: TerminateEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TerminateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TerminateEnvironmentErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TerminateEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TerminateEnvironmentErrorKind::InsufficientPrivilegesException(_inner) => _inner.fmt(f),
            TerminateEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TerminateEnvironmentError {
    fn code(&self) -> Option<&str> {
        TerminateEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TerminateEnvironmentError {
    /// Creates a new `TerminateEnvironmentError`.
    pub fn new(kind: TerminateEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TerminateEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TerminateEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TerminateEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TerminateEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TerminateEnvironmentErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateEnvironmentErrorKind::InsufficientPrivilegesException(_)
        )
    }
}
impl std::error::Error for TerminateEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TerminateEnvironmentErrorKind::InsufficientPrivilegesException(_inner) => Some(_inner),
            TerminateEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApplicationError {
    /// Kind of error that occurred.
    pub kind: UpdateApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApplicationErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApplicationError {
    fn code(&self) -> Option<&str> {
        UpdateApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApplicationError {
    /// Creates a new `UpdateApplicationError`.
    pub fn new(kind: UpdateApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApplicationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for UpdateApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApplicationResourceLifecycle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApplicationResourceLifecycleError {
    /// Kind of error that occurred.
    pub kind: UpdateApplicationResourceLifecycleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApplicationResourceLifecycle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApplicationResourceLifecycleErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApplicationResourceLifecycleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApplicationResourceLifecycleErrorKind::InsufficientPrivilegesException(
                _inner,
            ) => _inner.fmt(f),
            UpdateApplicationResourceLifecycleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApplicationResourceLifecycleError {
    fn code(&self) -> Option<&str> {
        UpdateApplicationResourceLifecycleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApplicationResourceLifecycleError {
    /// Creates a new `UpdateApplicationResourceLifecycleError`.
    pub fn new(
        kind: UpdateApplicationResourceLifecycleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApplicationResourceLifecycleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApplicationResourceLifecycleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApplicationResourceLifecycleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApplicationResourceLifecycleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateApplicationResourceLifecycleErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationResourceLifecycleErrorKind::InsufficientPrivilegesException(_)
        )
    }
}
impl std::error::Error for UpdateApplicationResourceLifecycleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApplicationResourceLifecycleErrorKind::InsufficientPrivilegesException(
                _inner,
            ) => Some(_inner),
            UpdateApplicationResourceLifecycleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApplicationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApplicationVersionError {
    /// Kind of error that occurred.
    pub kind: UpdateApplicationVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApplicationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApplicationVersionErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApplicationVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApplicationVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApplicationVersionError {
    fn code(&self) -> Option<&str> {
        UpdateApplicationVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApplicationVersionError {
    /// Creates a new `UpdateApplicationVersionError`.
    pub fn new(kind: UpdateApplicationVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApplicationVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApplicationVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApplicationVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApplicationVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for UpdateApplicationVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApplicationVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConfigurationTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdateConfigurationTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConfigurationTemplateErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// <p>The specified account has reached its limit of Amazon S3 buckets.</p>
    TooManyBucketsException(crate::error::TooManyBucketsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConfigurationTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConfigurationTemplateErrorKind::InsufficientPrivilegesException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConfigurationTemplateErrorKind::TooManyBucketsException(_inner) => _inner.fmt(f),
            UpdateConfigurationTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConfigurationTemplateError {
    fn code(&self) -> Option<&str> {
        UpdateConfigurationTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConfigurationTemplateError {
    /// Creates a new `UpdateConfigurationTemplateError`.
    pub fn new(kind: UpdateConfigurationTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConfigurationTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConfigurationTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConfigurationTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConfigurationTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateConfigurationTemplateErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationTemplateErrorKind::InsufficientPrivilegesException(_)
        )
    }
    /// Returns true if the error kind is `UpdateConfigurationTemplateErrorKind::TooManyBucketsException`.
    pub fn is_too_many_buckets_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationTemplateErrorKind::TooManyBucketsException(_)
        )
    }
}
impl std::error::Error for UpdateConfigurationTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConfigurationTemplateErrorKind::InsufficientPrivilegesException(_inner) => {
                Some(_inner)
            }
            UpdateConfigurationTemplateErrorKind::TooManyBucketsException(_inner) => Some(_inner),
            UpdateConfigurationTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEnvironmentError {
    /// Kind of error that occurred.
    pub kind: UpdateEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEnvironmentErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// <p>The specified account has reached its limit of Amazon S3 buckets.</p>
    TooManyBucketsException(crate::error::TooManyBucketsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEnvironmentErrorKind::InsufficientPrivilegesException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::TooManyBucketsException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEnvironmentError {
    fn code(&self) -> Option<&str> {
        UpdateEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEnvironmentError {
    /// Creates a new `UpdateEnvironmentError`.
    pub fn new(kind: UpdateEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateEnvironmentErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::InsufficientPrivilegesException(_)
        )
    }
    /// Returns true if the error kind is `UpdateEnvironmentErrorKind::TooManyBucketsException`.
    pub fn is_too_many_buckets_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::TooManyBucketsException(_)
        )
    }
}
impl std::error::Error for UpdateEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEnvironmentErrorKind::InsufficientPrivilegesException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::TooManyBucketsException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: UpdateTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTagsForResourceErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// <p>Unable to perform the specified operation because another operation that effects an
    /// element in this activity is already in progress.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN).</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The type of the specified Amazon Resource Name (ARN) isn't supported for this operation.</p>
    ResourceTypeNotSupportedException(crate::error::ResourceTypeNotSupportedException),
    /// <p>The number of tags in the resource would exceed the number of tags that each resource
    /// can have.</p>
    /// <p>To calculate this, the operation considers both the number of tags the resource already has
    /// and the tags this operation would add if it succeeded.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTagsForResourceErrorKind::InsufficientPrivilegesException(_inner) => {
                _inner.fmt(f)
            }
            UpdateTagsForResourceErrorKind::OperationInProgressException(_inner) => _inner.fmt(f),
            UpdateTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateTagsForResourceErrorKind::ResourceTypeNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateTagsForResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            UpdateTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTagsForResourceError {
    fn code(&self) -> Option<&str> {
        UpdateTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTagsForResourceError {
    /// Creates a new `UpdateTagsForResourceError`.
    pub fn new(kind: UpdateTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateTagsForResourceErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTagsForResourceErrorKind::InsufficientPrivilegesException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTagsForResourceErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTagsForResourceErrorKind::OperationInProgressException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTagsForResourceErrorKind::ResourceTypeNotSupportedException`.
    pub fn is_resource_type_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTagsForResourceErrorKind::ResourceTypeNotSupportedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTagsForResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTagsForResourceErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for UpdateTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTagsForResourceErrorKind::InsufficientPrivilegesException(_inner) => Some(_inner),
            UpdateTagsForResourceErrorKind::OperationInProgressException(_inner) => Some(_inner),
            UpdateTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateTagsForResourceErrorKind::ResourceTypeNotSupportedException(_inner) => {
                Some(_inner)
            }
            UpdateTagsForResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            UpdateTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ValidateConfigurationSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ValidateConfigurationSettingsError {
    /// Kind of error that occurred.
    pub kind: ValidateConfigurationSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ValidateConfigurationSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ValidateConfigurationSettingsErrorKind {
    /// <p>The specified account does not have sufficient privileges for one or more AWS
    /// services.</p>
    InsufficientPrivilegesException(crate::error::InsufficientPrivilegesException),
    /// <p>The specified account has reached its limit of Amazon S3 buckets.</p>
    TooManyBucketsException(crate::error::TooManyBucketsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ValidateConfigurationSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ValidateConfigurationSettingsErrorKind::InsufficientPrivilegesException(_inner) => {
                _inner.fmt(f)
            }
            ValidateConfigurationSettingsErrorKind::TooManyBucketsException(_inner) => {
                _inner.fmt(f)
            }
            ValidateConfigurationSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ValidateConfigurationSettingsError {
    fn code(&self) -> Option<&str> {
        ValidateConfigurationSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ValidateConfigurationSettingsError {
    /// Creates a new `ValidateConfigurationSettingsError`.
    pub fn new(
        kind: ValidateConfigurationSettingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ValidateConfigurationSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ValidateConfigurationSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ValidateConfigurationSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ValidateConfigurationSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ValidateConfigurationSettingsErrorKind::InsufficientPrivilegesException`.
    pub fn is_insufficient_privileges_exception(&self) -> bool {
        matches!(
            &self.kind,
            ValidateConfigurationSettingsErrorKind::InsufficientPrivilegesException(_)
        )
    }
    /// Returns true if the error kind is `ValidateConfigurationSettingsErrorKind::TooManyBucketsException`.
    pub fn is_too_many_buckets_exception(&self) -> bool {
        matches!(
            &self.kind,
            ValidateConfigurationSettingsErrorKind::TooManyBucketsException(_)
        )
    }
}
impl std::error::Error for ValidateConfigurationSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ValidateConfigurationSettingsErrorKind::InsufficientPrivilegesException(_inner) => {
                Some(_inner)
            }
            ValidateConfigurationSettingsErrorKind::TooManyBucketsException(_inner) => Some(_inner),
            ValidateConfigurationSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified account has reached its limit of Amazon S3 buckets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyBucketsException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyBucketsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyBucketsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyBucketsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyBucketsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyBucketsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyBucketsException {}
/// See [`TooManyBucketsException`](crate::error::TooManyBucketsException)
pub mod too_many_buckets_exception {
    /// A builder for [`TooManyBucketsException`](crate::error::TooManyBucketsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyBucketsException`](crate::error::TooManyBucketsException)
        pub fn build(self) -> crate::error::TooManyBucketsException {
            crate::error::TooManyBucketsException {
                message: self.message,
            }
        }
    }
}
impl TooManyBucketsException {
    /// Creates a new builder-style object to manufacture [`TooManyBucketsException`](crate::error::TooManyBucketsException)
    pub fn builder() -> crate::error::too_many_buckets_exception::Builder {
        crate::error::too_many_buckets_exception::Builder::default()
    }
}

/// <p>The specified account does not have sufficient privileges for one or more AWS
/// services.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientPrivilegesException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientPrivilegesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientPrivilegesException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientPrivilegesException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientPrivilegesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientPrivilegesException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientPrivilegesException {}
/// See [`InsufficientPrivilegesException`](crate::error::InsufficientPrivilegesException)
pub mod insufficient_privileges_exception {
    /// A builder for [`InsufficientPrivilegesException`](crate::error::InsufficientPrivilegesException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientPrivilegesException`](crate::error::InsufficientPrivilegesException)
        pub fn build(self) -> crate::error::InsufficientPrivilegesException {
            crate::error::InsufficientPrivilegesException {
                message: self.message,
            }
        }
    }
}
impl InsufficientPrivilegesException {
    /// Creates a new builder-style object to manufacture [`InsufficientPrivilegesException`](crate::error::InsufficientPrivilegesException)
    pub fn builder() -> crate::error::insufficient_privileges_exception::Builder {
        crate::error::insufficient_privileges_exception::Builder::default()
    }
}

/// <p>The number of tags in the resource would exceed the number of tags that each resource
/// can have.</p>
/// <p>To calculate this, the operation considers both the number of tags the resource already has
/// and the tags this operation would add if it succeeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The type of the specified Amazon Resource Name (ARN) isn't supported for this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceTypeNotSupportedException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceTypeNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceTypeNotSupportedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceTypeNotSupportedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceTypeNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceTypeNotSupportedException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceTypeNotSupportedException {}
/// See [`ResourceTypeNotSupportedException`](crate::error::ResourceTypeNotSupportedException)
pub mod resource_type_not_supported_exception {
    /// A builder for [`ResourceTypeNotSupportedException`](crate::error::ResourceTypeNotSupportedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceTypeNotSupportedException`](crate::error::ResourceTypeNotSupportedException)
        pub fn build(self) -> crate::error::ResourceTypeNotSupportedException {
            crate::error::ResourceTypeNotSupportedException {
                message: self.message,
            }
        }
    }
}
impl ResourceTypeNotSupportedException {
    /// Creates a new builder-style object to manufacture [`ResourceTypeNotSupportedException`](crate::error::ResourceTypeNotSupportedException)
    pub fn builder() -> crate::error::resource_type_not_supported_exception::Builder {
        crate::error::resource_type_not_supported_exception::Builder::default()
    }
}

/// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>Unable to perform the specified operation because another operation that effects an
/// element in this activity is already in progress.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationInProgressException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationInProgressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationInProgressException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationInProgressException {}
/// See [`OperationInProgressException`](crate::error::OperationInProgressException)
pub mod operation_in_progress_exception {
    /// A builder for [`OperationInProgressException`](crate::error::OperationInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationInProgressException`](crate::error::OperationInProgressException)
        pub fn build(self) -> crate::error::OperationInProgressException {
            crate::error::OperationInProgressException {
                message: self.message,
            }
        }
    }
}
impl OperationInProgressException {
    /// Creates a new builder-style object to manufacture [`OperationInProgressException`](crate::error::OperationInProgressException)
    pub fn builder() -> crate::error::operation_in_progress_exception::Builder {
        crate::error::operation_in_progress_exception::Builder::default()
    }
}

/// <p>A generic service exception has occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticBeanstalkServiceException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ElasticBeanstalkServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticBeanstalkServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ElasticBeanstalkServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ElasticBeanstalkServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ElasticBeanstalkServiceException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ElasticBeanstalkServiceException {}
/// See [`ElasticBeanstalkServiceException`](crate::error::ElasticBeanstalkServiceException)
pub mod elastic_beanstalk_service_exception {
    /// A builder for [`ElasticBeanstalkServiceException`](crate::error::ElasticBeanstalkServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticBeanstalkServiceException`](crate::error::ElasticBeanstalkServiceException)
        pub fn build(self) -> crate::error::ElasticBeanstalkServiceException {
            crate::error::ElasticBeanstalkServiceException {
                message: self.message,
            }
        }
    }
}
impl ElasticBeanstalkServiceException {
    /// Creates a new builder-style object to manufacture [`ElasticBeanstalkServiceException`](crate::error::ElasticBeanstalkServiceException)
    pub fn builder() -> crate::error::elastic_beanstalk_service_exception::Builder {
        crate::error::elastic_beanstalk_service_exception::Builder::default()
    }
}

/// <p>One or more input parameters is not valid. Please correct the input parameters and try
/// the operation again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>You cannot delete the platform version because there are still environments running on it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlatformVersionStillReferencedException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PlatformVersionStillReferencedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlatformVersionStillReferencedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PlatformVersionStillReferencedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PlatformVersionStillReferencedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PlatformVersionStillReferencedException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for PlatformVersionStillReferencedException {}
/// See [`PlatformVersionStillReferencedException`](crate::error::PlatformVersionStillReferencedException)
pub mod platform_version_still_referenced_exception {
    /// A builder for [`PlatformVersionStillReferencedException`](crate::error::PlatformVersionStillReferencedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PlatformVersionStillReferencedException`](crate::error::PlatformVersionStillReferencedException)
        pub fn build(self) -> crate::error::PlatformVersionStillReferencedException {
            crate::error::PlatformVersionStillReferencedException {
                message: self.message,
            }
        }
    }
}
impl PlatformVersionStillReferencedException {
    /// Creates a new builder-style object to manufacture [`PlatformVersionStillReferencedException`](crate::error::PlatformVersionStillReferencedException)
    pub fn builder() -> crate::error::platform_version_still_referenced_exception::Builder {
        crate::error::platform_version_still_referenced_exception::Builder::default()
    }
}

/// <p>Unable to delete the Amazon S3 source bundle associated with the application version.
/// The application version was deleted successfully.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceBundleDeletionException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SourceBundleDeletionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceBundleDeletionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SourceBundleDeletionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SourceBundleDeletionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SourceBundleDeletionException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for SourceBundleDeletionException {}
/// See [`SourceBundleDeletionException`](crate::error::SourceBundleDeletionException)
pub mod source_bundle_deletion_exception {
    /// A builder for [`SourceBundleDeletionException`](crate::error::SourceBundleDeletionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceBundleDeletionException`](crate::error::SourceBundleDeletionException)
        pub fn build(self) -> crate::error::SourceBundleDeletionException {
            crate::error::SourceBundleDeletionException {
                message: self.message,
            }
        }
    }
}
impl SourceBundleDeletionException {
    /// Creates a new builder-style object to manufacture [`SourceBundleDeletionException`](crate::error::SourceBundleDeletionException)
    pub fn builder() -> crate::error::source_bundle_deletion_exception::Builder {
        crate::error::source_bundle_deletion_exception::Builder::default()
    }
}

/// <p>The specified S3 bucket does not belong to the S3 region in which the service is
/// running. The following regions are supported:</p>
/// <ul>
/// <li>
/// <p>IAD/us-east-1</p>
/// </li>
/// <li>
/// <p>PDX/us-west-2</p>
/// </li>
/// <li>
/// <p>DUB/eu-west-1</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3LocationNotInServiceRegionException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3LocationNotInServiceRegionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3LocationNotInServiceRegionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl S3LocationNotInServiceRegionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for S3LocationNotInServiceRegionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "S3LocationNotInServiceRegionException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for S3LocationNotInServiceRegionException {}
/// See [`S3LocationNotInServiceRegionException`](crate::error::S3LocationNotInServiceRegionException)
pub mod s3_location_not_in_service_region_exception {
    /// A builder for [`S3LocationNotInServiceRegionException`](crate::error::S3LocationNotInServiceRegionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`S3LocationNotInServiceRegionException`](crate::error::S3LocationNotInServiceRegionException)
        pub fn build(self) -> crate::error::S3LocationNotInServiceRegionException {
            crate::error::S3LocationNotInServiceRegionException {
                message: self.message,
            }
        }
    }
}
impl S3LocationNotInServiceRegionException {
    /// Creates a new builder-style object to manufacture [`S3LocationNotInServiceRegionException`](crate::error::S3LocationNotInServiceRegionException)
    pub fn builder() -> crate::error::s3_location_not_in_service_region_exception::Builder {
        crate::error::s3_location_not_in_service_region_exception::Builder::default()
    }
}

/// <p>The specified account does not have a subscription to Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3SubscriptionRequiredException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3SubscriptionRequiredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3SubscriptionRequiredException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl S3SubscriptionRequiredException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for S3SubscriptionRequiredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "S3SubscriptionRequiredException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for S3SubscriptionRequiredException {}
/// See [`S3SubscriptionRequiredException`](crate::error::S3SubscriptionRequiredException)
pub mod s3_subscription_required_exception {
    /// A builder for [`S3SubscriptionRequiredException`](crate::error::S3SubscriptionRequiredException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`S3SubscriptionRequiredException`](crate::error::S3SubscriptionRequiredException)
        pub fn build(self) -> crate::error::S3SubscriptionRequiredException {
            crate::error::S3SubscriptionRequiredException {
                message: self.message,
            }
        }
    }
}
impl S3SubscriptionRequiredException {
    /// Creates a new builder-style object to manufacture [`S3SubscriptionRequiredException`](crate::error::S3SubscriptionRequiredException)
    pub fn builder() -> crate::error::s3_subscription_required_exception::Builder {
        crate::error::s3_subscription_required_exception::Builder::default()
    }
}

/// <p>You have exceeded the maximum number of allowed platforms associated with the account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyPlatformsException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyPlatformsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyPlatformsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyPlatformsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyPlatformsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyPlatformsException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyPlatformsException {}
/// See [`TooManyPlatformsException`](crate::error::TooManyPlatformsException)
pub mod too_many_platforms_exception {
    /// A builder for [`TooManyPlatformsException`](crate::error::TooManyPlatformsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyPlatformsException`](crate::error::TooManyPlatformsException)
        pub fn build(self) -> crate::error::TooManyPlatformsException {
            crate::error::TooManyPlatformsException {
                message: self.message,
            }
        }
    }
}
impl TooManyPlatformsException {
    /// Creates a new builder-style object to manufacture [`TooManyPlatformsException`](crate::error::TooManyPlatformsException)
    pub fn builder() -> crate::error::too_many_platforms_exception::Builder {
        crate::error::too_many_platforms_exception::Builder::default()
    }
}

/// <p>The specified account has reached its limit of environments.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyEnvironmentsException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyEnvironmentsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyEnvironmentsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyEnvironmentsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyEnvironmentsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyEnvironmentsException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyEnvironmentsException {}
/// See [`TooManyEnvironmentsException`](crate::error::TooManyEnvironmentsException)
pub mod too_many_environments_exception {
    /// A builder for [`TooManyEnvironmentsException`](crate::error::TooManyEnvironmentsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyEnvironmentsException`](crate::error::TooManyEnvironmentsException)
        pub fn build(self) -> crate::error::TooManyEnvironmentsException {
            crate::error::TooManyEnvironmentsException {
                message: self.message,
            }
        }
    }
}
impl TooManyEnvironmentsException {
    /// Creates a new builder-style object to manufacture [`TooManyEnvironmentsException`](crate::error::TooManyEnvironmentsException)
    pub fn builder() -> crate::error::too_many_environments_exception::Builder {
        crate::error::too_many_environments_exception::Builder::default()
    }
}

/// <p>The specified account has reached its limit of configuration templates.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyConfigurationTemplatesException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyConfigurationTemplatesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyConfigurationTemplatesException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyConfigurationTemplatesException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyConfigurationTemplatesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyConfigurationTemplatesException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyConfigurationTemplatesException {}
/// See [`TooManyConfigurationTemplatesException`](crate::error::TooManyConfigurationTemplatesException)
pub mod too_many_configuration_templates_exception {
    /// A builder for [`TooManyConfigurationTemplatesException`](crate::error::TooManyConfigurationTemplatesException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyConfigurationTemplatesException`](crate::error::TooManyConfigurationTemplatesException)
        pub fn build(self) -> crate::error::TooManyConfigurationTemplatesException {
            crate::error::TooManyConfigurationTemplatesException {
                message: self.message,
            }
        }
    }
}
impl TooManyConfigurationTemplatesException {
    /// Creates a new builder-style object to manufacture [`TooManyConfigurationTemplatesException`](crate::error::TooManyConfigurationTemplatesException)
    pub fn builder() -> crate::error::too_many_configuration_templates_exception::Builder {
        crate::error::too_many_configuration_templates_exception::Builder::default()
    }
}

/// <p>The specified account has reached its limit of application versions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyApplicationVersionsException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyApplicationVersionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyApplicationVersionsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyApplicationVersionsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyApplicationVersionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyApplicationVersionsException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyApplicationVersionsException {}
/// See [`TooManyApplicationVersionsException`](crate::error::TooManyApplicationVersionsException)
pub mod too_many_application_versions_exception {
    /// A builder for [`TooManyApplicationVersionsException`](crate::error::TooManyApplicationVersionsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyApplicationVersionsException`](crate::error::TooManyApplicationVersionsException)
        pub fn build(self) -> crate::error::TooManyApplicationVersionsException {
            crate::error::TooManyApplicationVersionsException {
                message: self.message,
            }
        }
    }
}
impl TooManyApplicationVersionsException {
    /// Creates a new builder-style object to manufacture [`TooManyApplicationVersionsException`](crate::error::TooManyApplicationVersionsException)
    pub fn builder() -> crate::error::too_many_application_versions_exception::Builder {
        crate::error::too_many_application_versions_exception::Builder::default()
    }
}

/// <p>The specified account has reached its limit of applications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyApplicationsException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyApplicationsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyApplicationsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyApplicationsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyApplicationsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyApplicationsException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyApplicationsException {}
/// See [`TooManyApplicationsException`](crate::error::TooManyApplicationsException)
pub mod too_many_applications_exception {
    /// A builder for [`TooManyApplicationsException`](crate::error::TooManyApplicationsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyApplicationsException`](crate::error::TooManyApplicationsException)
        pub fn build(self) -> crate::error::TooManyApplicationsException {
            crate::error::TooManyApplicationsException {
                message: self.message,
            }
        }
    }
}
impl TooManyApplicationsException {
    /// Creates a new builder-style object to manufacture [`TooManyApplicationsException`](crate::error::TooManyApplicationsException)
    pub fn builder() -> crate::error::too_many_applications_exception::Builder {
        crate::error::too_many_applications_exception::Builder::default()
    }
}

/// <p>AWS CodeBuild is not available in the specified region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeBuildNotInServiceRegionException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CodeBuildNotInServiceRegionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeBuildNotInServiceRegionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CodeBuildNotInServiceRegionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CodeBuildNotInServiceRegionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CodeBuildNotInServiceRegionException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for CodeBuildNotInServiceRegionException {}
/// See [`CodeBuildNotInServiceRegionException`](crate::error::CodeBuildNotInServiceRegionException)
pub mod code_build_not_in_service_region_exception {
    /// A builder for [`CodeBuildNotInServiceRegionException`](crate::error::CodeBuildNotInServiceRegionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeBuildNotInServiceRegionException`](crate::error::CodeBuildNotInServiceRegionException)
        pub fn build(self) -> crate::error::CodeBuildNotInServiceRegionException {
            crate::error::CodeBuildNotInServiceRegionException {
                message: self.message,
            }
        }
    }
}
impl CodeBuildNotInServiceRegionException {
    /// Creates a new builder-style object to manufacture [`CodeBuildNotInServiceRegionException`](crate::error::CodeBuildNotInServiceRegionException)
    pub fn builder() -> crate::error::code_build_not_in_service_region_exception::Builder {
        crate::error::code_build_not_in_service_region_exception::Builder::default()
    }
}

/// <p>Cannot modify the managed action in its current state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManagedActionInvalidStateException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ManagedActionInvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManagedActionInvalidStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ManagedActionInvalidStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ManagedActionInvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ManagedActionInvalidStateException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for ManagedActionInvalidStateException {}
/// See [`ManagedActionInvalidStateException`](crate::error::ManagedActionInvalidStateException)
pub mod managed_action_invalid_state_exception {
    /// A builder for [`ManagedActionInvalidStateException`](crate::error::ManagedActionInvalidStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ManagedActionInvalidStateException`](crate::error::ManagedActionInvalidStateException)
        pub fn build(self) -> crate::error::ManagedActionInvalidStateException {
            crate::error::ManagedActionInvalidStateException {
                message: self.message,
            }
        }
    }
}
impl ManagedActionInvalidStateException {
    /// Creates a new builder-style object to manufacture [`ManagedActionInvalidStateException`](crate::error::ManagedActionInvalidStateException)
    pub fn builder() -> crate::error::managed_action_invalid_state_exception::Builder {
        crate::error::managed_action_invalid_state_exception::Builder::default()
    }
}
