// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
pub mod add_tags_to_resource_input {
    /// A builder for [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>. ElastiCache resources are <i>cluster</i> and <i>snapshot</i>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>. ElastiCache resources are <i>cluster</i> and <i>snapshot</i>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddTagsToResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddTagsToResourceInput {
                resource_name: self.resource_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsToResourceInputOperationOutputAlias = crate::operation::AddTagsToResource;
#[doc(hidden)]
pub type AddTagsToResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddTagsToResourceInput {
    /// Consumes the builder and constructs an Operation<[`AddTagsToResource`](crate::operation::AddTagsToResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTagsToResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsToResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsToResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsToResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_tags_to_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddTagsToResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddTagsToResource",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
}

/// See [`AuthorizeCacheSecurityGroupIngressInput`](crate::input::AuthorizeCacheSecurityGroupIngressInput)
pub mod authorize_cache_security_group_ingress_input {
    /// A builder for [`AuthorizeCacheSecurityGroupIngressInput`](crate::input::AuthorizeCacheSecurityGroupIngressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_security_group_name: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_name: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_owner_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cache security group that allows network ingress.</p>
        pub fn cache_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_security_group_name = Some(input.into());
            self
        }
        /// <p>The cache security group that allows network ingress.</p>
        pub fn set_cache_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_security_group_name = input;
            self
        }
        /// <p>The Amazon EC2 security group to be authorized for ingress to the cache security group.</p>
        pub fn ec2_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_security_group_name = Some(input.into());
            self
        }
        /// <p>The Amazon EC2 security group to be authorized for ingress to the cache security group.</p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_name = input;
            self
        }
        /// <p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>
        pub fn ec2_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeCacheSecurityGroupIngressInput`](crate::input::AuthorizeCacheSecurityGroupIngressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AuthorizeCacheSecurityGroupIngressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AuthorizeCacheSecurityGroupIngressInput {
                cache_security_group_name: self.cache_security_group_name,
                ec2_security_group_name: self.ec2_security_group_name,
                ec2_security_group_owner_id: self.ec2_security_group_owner_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AuthorizeCacheSecurityGroupIngressInputOperationOutputAlias =
    crate::operation::AuthorizeCacheSecurityGroupIngress;
#[doc(hidden)]
pub type AuthorizeCacheSecurityGroupIngressInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AuthorizeCacheSecurityGroupIngressInput {
    /// Consumes the builder and constructs an Operation<[`AuthorizeCacheSecurityGroupIngress`](crate::operation::AuthorizeCacheSecurityGroupIngress)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AuthorizeCacheSecurityGroupIngress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AuthorizeCacheSecurityGroupIngressInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AuthorizeCacheSecurityGroupIngressInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AuthorizeCacheSecurityGroupIngressInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_authorize_cache_security_group_ingress(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AuthorizeCacheSecurityGroupIngress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AuthorizeCacheSecurityGroupIngress",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AuthorizeCacheSecurityGroupIngressInput`](crate::input::AuthorizeCacheSecurityGroupIngressInput)
    pub fn builder() -> crate::input::authorize_cache_security_group_ingress_input::Builder {
        crate::input::authorize_cache_security_group_ingress_input::Builder::default()
    }
}

/// See [`BatchApplyUpdateActionInput`](crate::input::BatchApplyUpdateActionInput)
pub mod batch_apply_update_action_input {
    /// A builder for [`BatchApplyUpdateActionInput`](crate::input::BatchApplyUpdateActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cache_cluster_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) service_update_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `replication_group_ids`.
        ///
        /// To override the contents of this collection use [`set_replication_group_ids`](Self::set_replication_group_ids).
        ///
        /// <p>The replication group IDs</p>
        pub fn replication_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.replication_group_ids.unwrap_or_default();
            v.push(input.into());
            self.replication_group_ids = Some(v);
            self
        }
        /// <p>The replication group IDs</p>
        pub fn set_replication_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_group_ids = input;
            self
        }
        /// Appends an item to `cache_cluster_ids`.
        ///
        /// To override the contents of this collection use [`set_cache_cluster_ids`](Self::set_cache_cluster_ids).
        ///
        /// <p>The cache cluster IDs</p>
        pub fn cache_cluster_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_cluster_ids.unwrap_or_default();
            v.push(input.into());
            self.cache_cluster_ids = Some(v);
            self
        }
        /// <p>The cache cluster IDs</p>
        pub fn set_cache_cluster_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_cluster_ids = input;
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_update_name = Some(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_update_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchApplyUpdateActionInput`](crate::input::BatchApplyUpdateActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchApplyUpdateActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchApplyUpdateActionInput {
                replication_group_ids: self.replication_group_ids,
                cache_cluster_ids: self.cache_cluster_ids,
                service_update_name: self.service_update_name,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchApplyUpdateActionInputOperationOutputAlias = crate::operation::BatchApplyUpdateAction;
#[doc(hidden)]
pub type BatchApplyUpdateActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchApplyUpdateActionInput {
    /// Consumes the builder and constructs an Operation<[`BatchApplyUpdateAction`](crate::operation::BatchApplyUpdateAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchApplyUpdateAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchApplyUpdateActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchApplyUpdateActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchApplyUpdateActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_apply_update_action(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchApplyUpdateAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchApplyUpdateAction",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchApplyUpdateActionInput`](crate::input::BatchApplyUpdateActionInput)
    pub fn builder() -> crate::input::batch_apply_update_action_input::Builder {
        crate::input::batch_apply_update_action_input::Builder::default()
    }
}

/// See [`BatchStopUpdateActionInput`](crate::input::BatchStopUpdateActionInput)
pub mod batch_stop_update_action_input {
    /// A builder for [`BatchStopUpdateActionInput`](crate::input::BatchStopUpdateActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cache_cluster_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) service_update_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `replication_group_ids`.
        ///
        /// To override the contents of this collection use [`set_replication_group_ids`](Self::set_replication_group_ids).
        ///
        /// <p>The replication group IDs</p>
        pub fn replication_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.replication_group_ids.unwrap_or_default();
            v.push(input.into());
            self.replication_group_ids = Some(v);
            self
        }
        /// <p>The replication group IDs</p>
        pub fn set_replication_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_group_ids = input;
            self
        }
        /// Appends an item to `cache_cluster_ids`.
        ///
        /// To override the contents of this collection use [`set_cache_cluster_ids`](Self::set_cache_cluster_ids).
        ///
        /// <p>The cache cluster IDs</p>
        pub fn cache_cluster_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_cluster_ids.unwrap_or_default();
            v.push(input.into());
            self.cache_cluster_ids = Some(v);
            self
        }
        /// <p>The cache cluster IDs</p>
        pub fn set_cache_cluster_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_cluster_ids = input;
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_update_name = Some(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_update_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchStopUpdateActionInput`](crate::input::BatchStopUpdateActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchStopUpdateActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchStopUpdateActionInput {
                replication_group_ids: self.replication_group_ids,
                cache_cluster_ids: self.cache_cluster_ids,
                service_update_name: self.service_update_name,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchStopUpdateActionInputOperationOutputAlias = crate::operation::BatchStopUpdateAction;
#[doc(hidden)]
pub type BatchStopUpdateActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchStopUpdateActionInput {
    /// Consumes the builder and constructs an Operation<[`BatchStopUpdateAction`](crate::operation::BatchStopUpdateAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchStopUpdateAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchStopUpdateActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchStopUpdateActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchStopUpdateActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_stop_update_action(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchStopUpdateAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchStopUpdateAction",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchStopUpdateActionInput`](crate::input::BatchStopUpdateActionInput)
    pub fn builder() -> crate::input::batch_stop_update_action_input::Builder {
        crate::input::batch_stop_update_action_input::Builder::default()
    }
}

/// See [`CompleteMigrationInput`](crate::input::CompleteMigrationInput)
pub mod complete_migration_input {
    /// A builder for [`CompleteMigrationInput`](crate::input::CompleteMigrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the replication group to which data is being migrated.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication group to which data is being migrated.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>Forces the migration to stop without ensuring that data is in sync. It is recommended to use this option only to abort the migration and not recommended when application wants to continue migration to ElastiCache.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>Forces the migration to stop without ensuring that data is in sync. It is recommended to use this option only to abort the migration and not recommended when application wants to continue migration to ElastiCache.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteMigrationInput`](crate::input::CompleteMigrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CompleteMigrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CompleteMigrationInput {
                replication_group_id: self.replication_group_id,
                force: self.force.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CompleteMigrationInputOperationOutputAlias = crate::operation::CompleteMigration;
#[doc(hidden)]
pub type CompleteMigrationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CompleteMigrationInput {
    /// Consumes the builder and constructs an Operation<[`CompleteMigration`](crate::operation::CompleteMigration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CompleteMigration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CompleteMigrationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CompleteMigrationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CompleteMigrationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_complete_migration(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CompleteMigration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CompleteMigration",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CompleteMigrationInput`](crate::input::CompleteMigrationInput)
    pub fn builder() -> crate::input::complete_migration_input::Builder {
        crate::input::complete_migration_input::Builder::default()
    }
}

/// See [`CopySnapshotInput`](crate::input::CopySnapshotInput)
pub mod copy_snapshot_input {
    /// A builder for [`CopySnapshotInput`](crate::input::CopySnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_snapshot_name: std::option::Option<std::string::String>,
        pub(crate) target_snapshot_name: std::option::Option<std::string::String>,
        pub(crate) target_bucket: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of an existing snapshot from which to make a copy.</p>
        pub fn source_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of an existing snapshot from which to make a copy.</p>
        pub fn set_source_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_snapshot_name = input;
            self
        }
        /// <p>A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name must be unique within its context - ElastiCache or an Amazon S3 bucket if exporting.</p>
        pub fn target_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_snapshot_name = Some(input.into());
            self
        }
        /// <p>A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name must be unique within its context - ElastiCache or an Amazon S3 bucket if exporting.</p>
        pub fn set_target_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_snapshot_name = input;
            self
        }
        /// <p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.</p>
        /// <p>When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions to this S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the <i>Amazon ElastiCache User Guide</i>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html">Exporting a Snapshot</a> in the <i>Amazon ElastiCache User Guide</i>.</p>
        pub fn target_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.</p>
        /// <p>When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions to this S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the <i>Amazon ElastiCache User Guide</i>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html">Exporting a Snapshot</a> in the <i>Amazon ElastiCache User Guide</i>.</p>
        pub fn set_target_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_bucket = input;
            self
        }
        /// <p>The ID of the KMS key used to encrypt the target snapshot.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the target snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CopySnapshotInput`](crate::input::CopySnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopySnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopySnapshotInput {
                source_snapshot_name: self.source_snapshot_name,
                target_snapshot_name: self.target_snapshot_name,
                target_bucket: self.target_bucket,
                kms_key_id: self.kms_key_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CopySnapshotInputOperationOutputAlias = crate::operation::CopySnapshot;
#[doc(hidden)]
pub type CopySnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopySnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CopySnapshot`](crate::operation::CopySnapshot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopySnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CopySnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CopySnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CopySnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_copy_snapshot(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopySnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopySnapshot",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CopySnapshotInput`](crate::input::CopySnapshotInput)
    pub fn builder() -> crate::input::copy_snapshot_input::Builder {
        crate::input::copy_snapshot_input::Builder::default()
    }
}

/// See [`CreateCacheClusterInput`](crate::input::CreateCacheClusterInput)
pub mod create_cache_cluster_input {
    /// A builder for [`CreateCacheClusterInput`](crate::input::CreateCacheClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) az_mode: std::option::Option<crate::model::AzMode>,
        pub(crate) preferred_availability_zone: std::option::Option<std::string::String>,
        pub(crate) preferred_availability_zones:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) num_cache_nodes: std::option::Option<i32>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) cache_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) cache_security_group_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) snapshot_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) snapshot_name: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) notification_topic_arn: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) snapshot_retention_limit: std::option::Option<i32>,
        pub(crate) snapshot_window: std::option::Option<std::string::String>,
        pub(crate) auth_token: std::option::Option<std::string::String>,
        pub(crate) outpost_mode: std::option::Option<crate::model::OutpostMode>,
        pub(crate) preferred_outpost_arn: std::option::Option<std::string::String>,
        pub(crate) preferred_outpost_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) log_delivery_configurations:
            std::option::Option<std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>>,
    }
    impl Builder {
        /// <p>The node group (shard) identifier. This parameter is stored as a lowercase string.</p>
        /// <p> <b>Constraints:</b> </p>
        /// <ul>
        /// <li> <p>A name must contain from 1 to 50 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>The first character must be a letter.</p> </li>
        /// <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The node group (shard) identifier. This parameter is stored as a lowercase string.</p>
        /// <p> <b>Constraints:</b> </p>
        /// <ul>
        /// <li> <p>A name must contain from 1 to 50 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>The first character must be a letter.</p> </li>
        /// <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>The ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.</p>
        /// <p>If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the cluster is created in Availability Zones that provide the best spread of read replicas across Availability Zones.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.</p>
        /// <p>If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the cluster is created in Availability Zones that provide the best spread of read replicas across Availability Zones.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region.</p>
        /// <p>This parameter is only supported for Memcached clusters.</p>
        /// <p>If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes <code>single-az</code> mode.</p>
        pub fn az_mode(mut self, input: crate::model::AzMode) -> Self {
            self.az_mode = Some(input);
            self
        }
        /// <p>Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region.</p>
        /// <p>This parameter is only supported for Memcached clusters.</p>
        /// <p>If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes <code>single-az</code> mode.</p>
        pub fn set_az_mode(mut self, input: std::option::Option<crate::model::AzMode>) -> Self {
            self.az_mode = input;
            self
        }
        /// <p>The EC2 Availability Zone in which the cluster is created.</p>
        /// <p>All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.</p>
        /// <p>Default: System chosen Availability Zone.</p>
        pub fn preferred_availability_zone(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_availability_zone = Some(input.into());
            self
        }
        /// <p>The EC2 Availability Zone in which the cluster is created.</p>
        /// <p>All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.</p>
        /// <p>Default: System chosen Availability Zone.</p>
        pub fn set_preferred_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_availability_zone = input;
            self
        }
        /// Appends an item to `preferred_availability_zones`.
        ///
        /// To override the contents of this collection use [`set_preferred_availability_zones`](Self::set_preferred_availability_zones).
        ///
        /// <p>A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not important.</p>
        /// <p>This option is only supported on Memcached.</p> <note>
        /// <p>If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.</p>
        /// <p>The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.</p>
        /// </note>
        /// <p>If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or repeat the Availability Zone multiple times in the list.</p>
        /// <p>Default: System chosen Availability Zones.</p>
        pub fn preferred_availability_zones(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.preferred_availability_zones.unwrap_or_default();
            v.push(input.into());
            self.preferred_availability_zones = Some(v);
            self
        }
        /// <p>A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not important.</p>
        /// <p>This option is only supported on Memcached.</p> <note>
        /// <p>If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.</p>
        /// <p>The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.</p>
        /// </note>
        /// <p>If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or repeat the Availability Zone multiple times in the list.</p>
        /// <p>Default: System chosen Availability Zones.</p>
        pub fn set_preferred_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.preferred_availability_zones = input;
            self
        }
        /// <p>The initial number of cache nodes that the cluster has.</p>
        /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p>
        /// <p>If you need more than 40 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase Request form at <a href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http://aws.amazon.com/contact-us/elasticache-node-limit-request/</a>.</p>
        pub fn num_cache_nodes(mut self, input: i32) -> Self {
            self.num_cache_nodes = Some(input);
            self
        }
        /// <p>The initial number of cache nodes that the cluster has.</p>
        /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p>
        /// <p>If you need more than 40 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase Request form at <a href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http://aws.amazon.com/contact-us/elasticache-node-limit-request/</a>.</p>
        pub fn set_num_cache_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.num_cache_nodes = input;
            self
        }
        /// <p>The compute and memory capacity of the nodes in the node group (shard).</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 6.0 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of the nodes in the node group (shard).</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 6.0 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>The name of the cache engine to be used for this cluster.</p>
        /// <p>Valid values for this parameter are: <code>memcached</code> | <code>redis</code> </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the cache engine to be used for this cluster.</p>
        /// <p>Valid values for this parameter are: <code>memcached</code> | <code>redis</code> </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the cache engine to be used for this cluster. To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the cache engine to be used for this cluster. To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of the parameter group to associate with this cluster. If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has <code>cluster-enabled='yes'</code> when creating a cluster.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group to associate with this cluster. If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has <code>cluster-enabled='yes'</code> when creating a cluster.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// <p>The name of the subnet group to be used for the cluster.</p>
        /// <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p> <important>
        /// <p>If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet Groups</a>.</p>
        /// </important>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group to be used for the cluster.</p>
        /// <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p> <important>
        /// <p>If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet Groups</a>.</p>
        /// </important>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_name = input;
            self
        }
        /// Appends an item to `cache_security_group_names`.
        ///
        /// To override the contents of this collection use [`set_cache_security_group_names`](Self::set_cache_security_group_names).
        ///
        /// <p>A list of security group names to associate with this cluster.</p>
        /// <p>Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn cache_security_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_security_group_names.unwrap_or_default();
            v.push(input.into());
            self.cache_security_group_names = Some(v);
            self
        }
        /// <p>A list of security group names to associate with this cluster.</p>
        /// <p>Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn set_cache_security_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_security_group_names = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>One or more VPC security groups associated with the cluster.</p>
        /// <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>One or more VPC security groups associated with the cluster.</p>
        /// <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `snapshot_arns`.
        ///
        /// To override the contents of this collection use [`set_snapshot_arns`](Self::set_snapshot_arns).
        ///
        /// <p>A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        /// <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>
        pub fn snapshot_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.snapshot_arns.unwrap_or_default();
            v.push(input.into());
            self.snapshot_arns = Some(v);
            self
        }
        /// <p>A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        /// <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>
        pub fn set_snapshot_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.snapshot_arns = input;
            self
        }
        /// <p>The name of a Redis snapshot from which to restore data into the new node group (shard). The snapshot status changes to <code>restoring</code> while the new node group (shard) is being created.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of a Redis snapshot from which to restore data into the new node group (shard). The snapshot status changes to <code>restoring</code> while the new node group (shard) is being created.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_name = input;
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. </p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. </p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The port number on which each of the cache nodes accepts connections.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which each of the cache nodes accepts connections.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be the same as the cluster owner.</p>
        /// </note>
        pub fn notification_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be the same as the cluster owner.</p>
        /// </note>
        pub fn set_notification_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_topic_arn = input;
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        /// <p>Default: 0 (i.e., automatic backups are disabled for this cache cluster).</p>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.snapshot_retention_limit = Some(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        /// <p>Default: 0 (i.e., automatic backups are disabled for this cache cluster).</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.snapshot_retention_limit = input;
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p>
        /// <p>Example: <code>05:00-09:00</code> </p>
        /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_window = Some(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p>
        /// <p>Example: <code>05:00-09:00</code> </p>
        /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_window = input;
            self
        }
        /// <p> <b>Reserved parameter.</b> The password used to access a password protected server.</p>
        /// <p>Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters.</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li>
        /// <li> <p>The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special characters cannot be used in the AUTH token.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.</p>
        pub fn auth_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_token = Some(input.into());
            self
        }
        /// <p> <b>Reserved parameter.</b> The password used to access a password protected server.</p>
        /// <p>Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters.</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li>
        /// <li> <p>The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special characters cannot be used in the AUTH token.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.</p>
        pub fn set_auth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_token = input;
            self
        }
        /// <p>Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.</p>
        pub fn outpost_mode(mut self, input: crate::model::OutpostMode) -> Self {
            self.outpost_mode = Some(input);
            self
        }
        /// <p>Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.</p>
        pub fn set_outpost_mode(
            mut self,
            input: std::option::Option<crate::model::OutpostMode>,
        ) -> Self {
            self.outpost_mode = input;
            self
        }
        /// <p>The outpost ARN in which the cache cluster is created.</p>
        pub fn preferred_outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_outpost_arn = Some(input.into());
            self
        }
        /// <p>The outpost ARN in which the cache cluster is created.</p>
        pub fn set_preferred_outpost_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_outpost_arn = input;
            self
        }
        /// Appends an item to `preferred_outpost_arns`.
        ///
        /// To override the contents of this collection use [`set_preferred_outpost_arns`](Self::set_preferred_outpost_arns).
        ///
        /// <p>The outpost ARNs in which the cache cluster is created.</p>
        pub fn preferred_outpost_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.preferred_outpost_arns.unwrap_or_default();
            v.push(input.into());
            self.preferred_outpost_arns = Some(v);
            self
        }
        /// <p>The outpost ARNs in which the cache cluster is created.</p>
        pub fn set_preferred_outpost_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.preferred_outpost_arns = input;
            self
        }
        /// Appends an item to `log_delivery_configurations`.
        ///
        /// To override the contents of this collection use [`set_log_delivery_configurations`](Self::set_log_delivery_configurations).
        ///
        /// <p>Specifies the destination, format and type of the logs. </p>
        pub fn log_delivery_configurations(
            mut self,
            input: crate::model::LogDeliveryConfigurationRequest,
        ) -> Self {
            let mut v = self.log_delivery_configurations.unwrap_or_default();
            v.push(input);
            self.log_delivery_configurations = Some(v);
            self
        }
        /// <p>Specifies the destination, format and type of the logs. </p>
        pub fn set_log_delivery_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>,
            >,
        ) -> Self {
            self.log_delivery_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCacheClusterInput`](crate::input::CreateCacheClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCacheClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCacheClusterInput {
                cache_cluster_id: self.cache_cluster_id,
                replication_group_id: self.replication_group_id,
                az_mode: self.az_mode,
                preferred_availability_zone: self.preferred_availability_zone,
                preferred_availability_zones: self.preferred_availability_zones,
                num_cache_nodes: self.num_cache_nodes,
                cache_node_type: self.cache_node_type,
                engine: self.engine,
                engine_version: self.engine_version,
                cache_parameter_group_name: self.cache_parameter_group_name,
                cache_subnet_group_name: self.cache_subnet_group_name,
                cache_security_group_names: self.cache_security_group_names,
                security_group_ids: self.security_group_ids,
                tags: self.tags,
                snapshot_arns: self.snapshot_arns,
                snapshot_name: self.snapshot_name,
                preferred_maintenance_window: self.preferred_maintenance_window,
                port: self.port,
                notification_topic_arn: self.notification_topic_arn,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
                snapshot_retention_limit: self.snapshot_retention_limit,
                snapshot_window: self.snapshot_window,
                auth_token: self.auth_token,
                outpost_mode: self.outpost_mode,
                preferred_outpost_arn: self.preferred_outpost_arn,
                preferred_outpost_arns: self.preferred_outpost_arns,
                log_delivery_configurations: self.log_delivery_configurations,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCacheClusterInputOperationOutputAlias = crate::operation::CreateCacheCluster;
#[doc(hidden)]
pub type CreateCacheClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCacheClusterInput {
    /// Consumes the builder and constructs an Operation<[`CreateCacheCluster`](crate::operation::CreateCacheCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCacheCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCacheClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCacheClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCacheClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_cache_cluster(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCacheCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCacheCluster",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCacheClusterInput`](crate::input::CreateCacheClusterInput)
    pub fn builder() -> crate::input::create_cache_cluster_input::Builder {
        crate::input::create_cache_cluster_input::Builder::default()
    }
}

/// See [`CreateCacheParameterGroupInput`](crate::input::CreateCacheParameterGroupInput)
pub mod create_cache_parameter_group_input {
    /// A builder for [`CreateCacheParameterGroupInput`](crate::input::CreateCacheParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) cache_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A user-specified name for the cache parameter group.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>A user-specified name for the cache parameter group.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// <p>The name of the cache parameter group family that the cache parameter group can be used with.</p>
        /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> </p>
        pub fn cache_parameter_group_family(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group family that the cache parameter group can be used with.</p>
        /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> </p>
        pub fn set_cache_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_family = input;
            self
        }
        /// <p>A user-specified description for the cache parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A user-specified description for the cache parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCacheParameterGroupInput`](crate::input::CreateCacheParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCacheParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCacheParameterGroupInput {
                cache_parameter_group_name: self.cache_parameter_group_name,
                cache_parameter_group_family: self.cache_parameter_group_family,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCacheParameterGroupInputOperationOutputAlias =
    crate::operation::CreateCacheParameterGroup;
#[doc(hidden)]
pub type CreateCacheParameterGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCacheParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateCacheParameterGroup`](crate::operation::CreateCacheParameterGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCacheParameterGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCacheParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCacheParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCacheParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_cache_parameter_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCacheParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCacheParameterGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCacheParameterGroupInput`](crate::input::CreateCacheParameterGroupInput)
    pub fn builder() -> crate::input::create_cache_parameter_group_input::Builder {
        crate::input::create_cache_parameter_group_input::Builder::default()
    }
}

/// See [`CreateCacheSecurityGroupInput`](crate::input::CreateCacheSecurityGroupInput)
pub mod create_cache_security_group_input {
    /// A builder for [`CreateCacheSecurityGroupInput`](crate::input::CreateCacheSecurityGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_security_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A name for the cache security group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Cannot be the word "Default".</p>
        /// <p>Example: <code>mysecuritygroup</code> </p>
        pub fn cache_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_security_group_name = Some(input.into());
            self
        }
        /// <p>A name for the cache security group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Cannot be the word "Default".</p>
        /// <p>Example: <code>mysecuritygroup</code> </p>
        pub fn set_cache_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_security_group_name = input;
            self
        }
        /// <p>A description for the cache security group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the cache security group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCacheSecurityGroupInput`](crate::input::CreateCacheSecurityGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCacheSecurityGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCacheSecurityGroupInput {
                cache_security_group_name: self.cache_security_group_name,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCacheSecurityGroupInputOperationOutputAlias =
    crate::operation::CreateCacheSecurityGroup;
#[doc(hidden)]
pub type CreateCacheSecurityGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCacheSecurityGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateCacheSecurityGroup`](crate::operation::CreateCacheSecurityGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCacheSecurityGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCacheSecurityGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCacheSecurityGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCacheSecurityGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_cache_security_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCacheSecurityGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCacheSecurityGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCacheSecurityGroupInput`](crate::input::CreateCacheSecurityGroupInput)
    pub fn builder() -> crate::input::create_cache_security_group_input::Builder {
        crate::input::create_cache_security_group_input::Builder::default()
    }
}

/// See [`CreateCacheSubnetGroupInput`](crate::input::CreateCacheSubnetGroupInput)
pub mod create_cache_subnet_group_input {
    /// A builder for [`CreateCacheSubnetGroupInput`](crate::input::CreateCacheSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) cache_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A name for the cache subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// <p>Example: <code>mysubnetgroup</code> </p>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_subnet_group_name = Some(input.into());
            self
        }
        /// <p>A name for the cache subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// <p>Example: <code>mysubnetgroup</code> </p>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_name = input;
            self
        }
        /// <p>A description for the cache subnet group.</p>
        pub fn cache_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_description = Some(input.into());
            self
        }
        /// <p>A description for the cache subnet group.</p>
        pub fn set_cache_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of VPC subnet IDs for the cache subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of VPC subnet IDs for the cache subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCacheSubnetGroupInput`](crate::input::CreateCacheSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCacheSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCacheSubnetGroupInput {
                cache_subnet_group_name: self.cache_subnet_group_name,
                cache_subnet_group_description: self.cache_subnet_group_description,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCacheSubnetGroupInputOperationOutputAlias = crate::operation::CreateCacheSubnetGroup;
#[doc(hidden)]
pub type CreateCacheSubnetGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCacheSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateCacheSubnetGroup`](crate::operation::CreateCacheSubnetGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCacheSubnetGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCacheSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCacheSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCacheSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_cache_subnet_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCacheSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCacheSubnetGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCacheSubnetGroupInput`](crate::input::CreateCacheSubnetGroupInput)
    pub fn builder() -> crate::input::create_cache_subnet_group_input::Builder {
        crate::input::create_cache_subnet_group_input::Builder::default()
    }
}

/// See [`CreateGlobalReplicationGroupInput`](crate::input::CreateGlobalReplicationGroupInput)
pub mod create_global_replication_group_input {
    /// A builder for [`CreateGlobalReplicationGroupInput`](crate::input::CreateGlobalReplicationGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group_id_suffix: std::option::Option<std::string::String>,
        pub(crate) global_replication_group_description: std::option::Option<std::string::String>,
        pub(crate) primary_replication_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The suffix name of a Global datastore. Amazon ElastiCache automatically applies a prefix to the Global datastore ID when it is created. Each Amazon Region has its own prefix. For instance, a Global datastore ID created in the US-West-1 region will begin with "dsdfu" along with the suffix name you provide. The suffix, combined with the auto-generated prefix, guarantees uniqueness of the Global datastore name across multiple regions. </p>
        /// <p>For a full list of Amazon Regions and their respective Global datastore iD prefixes, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastores-CLI.html">Using the Amazon CLI with Global datastores </a>.</p>
        pub fn global_replication_group_id_suffix(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_id_suffix = Some(input.into());
            self
        }
        /// <p>The suffix name of a Global datastore. Amazon ElastiCache automatically applies a prefix to the Global datastore ID when it is created. Each Amazon Region has its own prefix. For instance, a Global datastore ID created in the US-West-1 region will begin with "dsdfu" along with the suffix name you provide. The suffix, combined with the auto-generated prefix, guarantees uniqueness of the Global datastore name across multiple regions. </p>
        /// <p>For a full list of Amazon Regions and their respective Global datastore iD prefixes, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastores-CLI.html">Using the Amazon CLI with Global datastores </a>.</p>
        pub fn set_global_replication_group_id_suffix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_id_suffix = input;
            self
        }
        /// <p>Provides details of the Global datastore</p>
        pub fn global_replication_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_description = Some(input.into());
            self
        }
        /// <p>Provides details of the Global datastore</p>
        pub fn set_global_replication_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_description = input;
            self
        }
        /// <p>The name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.</p>
        pub fn primary_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.primary_replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.</p>
        pub fn set_primary_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_replication_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGlobalReplicationGroupInput`](crate::input::CreateGlobalReplicationGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGlobalReplicationGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGlobalReplicationGroupInput {
                global_replication_group_id_suffix: self.global_replication_group_id_suffix,
                global_replication_group_description: self.global_replication_group_description,
                primary_replication_group_id: self.primary_replication_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGlobalReplicationGroupInputOperationOutputAlias =
    crate::operation::CreateGlobalReplicationGroup;
#[doc(hidden)]
pub type CreateGlobalReplicationGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateGlobalReplicationGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateGlobalReplicationGroup`](crate::operation::CreateGlobalReplicationGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGlobalReplicationGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGlobalReplicationGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGlobalReplicationGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGlobalReplicationGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_global_replication_group(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGlobalReplicationGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGlobalReplicationGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGlobalReplicationGroupInput`](crate::input::CreateGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::create_global_replication_group_input::Builder {
        crate::input::create_global_replication_group_input::Builder::default()
    }
}

/// See [`CreateReplicationGroupInput`](crate::input::CreateReplicationGroupInput)
pub mod create_replication_group_input {
    /// A builder for [`CreateReplicationGroupInput`](crate::input::CreateReplicationGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) replication_group_description: std::option::Option<std::string::String>,
        pub(crate) global_replication_group_id: std::option::Option<std::string::String>,
        pub(crate) primary_cluster_id: std::option::Option<std::string::String>,
        pub(crate) automatic_failover_enabled: std::option::Option<bool>,
        pub(crate) multi_az_enabled: std::option::Option<bool>,
        pub(crate) num_cache_clusters: std::option::Option<i32>,
        pub(crate) preferred_cache_cluster_a_zs:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) num_node_groups: std::option::Option<i32>,
        pub(crate) replicas_per_node_group: std::option::Option<i32>,
        pub(crate) node_group_configuration:
            std::option::Option<std::vec::Vec<crate::model::NodeGroupConfiguration>>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) cache_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) cache_security_group_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) snapshot_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) snapshot_name: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) notification_topic_arn: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) snapshot_retention_limit: std::option::Option<i32>,
        pub(crate) snapshot_window: std::option::Option<std::string::String>,
        pub(crate) auth_token: std::option::Option<std::string::String>,
        pub(crate) transit_encryption_enabled: std::option::Option<bool>,
        pub(crate) at_rest_encryption_enabled: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) user_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) log_delivery_configurations:
            std::option::Option<std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>>,
        pub(crate) data_tiering_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The replication group identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>A name must contain from 1 to 40 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>The first character must be a letter.</p> </li>
        /// <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The replication group identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>A name must contain from 1 to 40 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>The first character must be a letter.</p> </li>
        /// <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>A user-created description for the replication group.</p>
        pub fn replication_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_group_description = Some(input.into());
            self
        }
        /// <p>A user-created description for the replication group.</p>
        pub fn set_replication_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_description = input;
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = input;
            self
        }
        /// <p>The identifier of the cluster that serves as the primary for this replication group. This cluster must already exist and have a status of <code>available</code>.</p>
        /// <p>This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or <code>ReplicasPerNodeGroup</code> is specified.</p>
        pub fn primary_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_cluster_id = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster that serves as the primary for this replication group. This cluster must already exist and have a status of <code>available</code>.</p>
        /// <p>This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or <code>ReplicasPerNodeGroup</code> is specified.</p>
        pub fn set_primary_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_cluster_id = input;
            self
        }
        /// <p>Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.</p>
        /// <p> <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.</p>
        /// <p>Default: false</p>
        pub fn automatic_failover_enabled(mut self, input: bool) -> Self {
            self.automatic_failover_enabled = Some(input);
            self
        }
        /// <p>Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.</p>
        /// <p> <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.</p>
        /// <p>Default: false</p>
        pub fn set_automatic_failover_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.automatic_failover_enabled = input;
            self
        }
        /// <p>A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a>.</p>
        pub fn multi_az_enabled(mut self, input: bool) -> Self {
            self.multi_az_enabled = Some(input);
            self
        }
        /// <p>A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a>.</p>
        pub fn set_multi_az_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az_enabled = input;
            self
        }
        /// <p>The number of clusters this replication group initially has.</p>
        /// <p>This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.</p>
        /// <p>If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.</p>
        /// <p>The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).</p>
        pub fn num_cache_clusters(mut self, input: i32) -> Self {
            self.num_cache_clusters = Some(input);
            self
        }
        /// <p>The number of clusters this replication group initially has.</p>
        /// <p>This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.</p>
        /// <p>If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.</p>
        /// <p>The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).</p>
        pub fn set_num_cache_clusters(mut self, input: std::option::Option<i32>) -> Self {
            self.num_cache_clusters = input;
            self
        }
        /// Appends an item to `preferred_cache_cluster_a_zs`.
        ///
        /// To override the contents of this collection use [`set_preferred_cache_cluster_a_zs`](Self::set_preferred_cache_cluster_a_zs).
        ///
        /// <p>A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.</p>
        /// <p>This parameter is not used if there is more than one node group (shard). You should use <code>NodeGroupConfiguration</code> instead.</p> <note>
        /// <p>If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.</p>
        /// <p>The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.</p>
        /// </note>
        /// <p>Default: system chosen Availability Zones.</p>
        pub fn preferred_cache_cluster_a_zs(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.preferred_cache_cluster_a_zs.unwrap_or_default();
            v.push(input.into());
            self.preferred_cache_cluster_a_zs = Some(v);
            self
        }
        /// <p>A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.</p>
        /// <p>This parameter is not used if there is more than one node group (shard). You should use <code>NodeGroupConfiguration</code> instead.</p> <note>
        /// <p>If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.</p>
        /// <p>The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.</p>
        /// </note>
        /// <p>Default: system chosen Availability Zones.</p>
        pub fn set_preferred_cache_cluster_a_zs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.preferred_cache_cluster_a_zs = input;
            self
        }
        /// <p>An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.</p>
        /// <p>Default: 1</p>
        pub fn num_node_groups(mut self, input: i32) -> Self {
            self.num_node_groups = Some(input);
            self
        }
        /// <p>An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.</p>
        /// <p>Default: 1</p>
        pub fn set_num_node_groups(mut self, input: std::option::Option<i32>) -> Self {
            self.num_node_groups = input;
            self
        }
        /// <p>An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0 to 5.</p>
        pub fn replicas_per_node_group(mut self, input: i32) -> Self {
            self.replicas_per_node_group = Some(input);
            self
        }
        /// <p>An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0 to 5.</p>
        pub fn set_replicas_per_node_group(mut self, input: std::option::Option<i32>) -> Self {
            self.replicas_per_node_group = input;
            self
        }
        /// Appends an item to `node_group_configuration`.
        ///
        /// To override the contents of this collection use [`set_node_group_configuration`](Self::set_node_group_configuration).
        ///
        /// <p>A list of node group (shard) configuration options. Each node group (shard) configuration has the following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>, and <code>Slots</code>.</p>
        /// <p>If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node group (shard) using this parameter because you must specify the slots for each node group.</p>
        pub fn node_group_configuration(
            mut self,
            input: crate::model::NodeGroupConfiguration,
        ) -> Self {
            let mut v = self.node_group_configuration.unwrap_or_default();
            v.push(input);
            self.node_group_configuration = Some(v);
            self
        }
        /// <p>A list of node group (shard) configuration options. Each node group (shard) configuration has the following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>, and <code>Slots</code>.</p>
        /// <p>If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node group (shard) using this parameter because you must specify the slots for each node group.</p>
        pub fn set_node_group_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeGroupConfiguration>>,
        ) -> Self {
            self.node_group_configuration = input;
            self
        }
        /// <p>The compute and memory capacity of the nodes in the node group (shard).</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 6.0 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of the nodes in the node group (shard).</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 6.0 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>The name of the cache engine to be used for the clusters in this replication group. Must be Redis.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the cache engine to be used for the clusters in this replication group. Must be Redis.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the cache engine to be used for the clusters in this replication group. To view the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the cache engine to be used for the clusters in this replication group. To view the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used.</p>
        /// <p>If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name. </p>
        /// <ul>
        /// <li> <p>To create a Redis (cluster mode disabled) replication group, use <code>CacheParameterGroupName=default.redis3.2</code>.</p> </li>
        /// <li> <p>To create a Redis (cluster mode enabled) replication group, use <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.</p> </li>
        /// </ul>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used.</p>
        /// <p>If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name. </p>
        /// <ul>
        /// <li> <p>To create a Redis (cluster mode disabled) replication group, use <code>CacheParameterGroupName=default.redis3.2</code>.</p> </li>
        /// <li> <p>To create a Redis (cluster mode enabled) replication group, use <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.</p> </li>
        /// </ul>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// <p>The name of the cache subnet group to be used for the replication group.</p> <important>
        /// <p>If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet Groups</a>.</p>
        /// </important>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache subnet group to be used for the replication group.</p> <important>
        /// <p>If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet Groups</a>.</p>
        /// </important>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_name = input;
            self
        }
        /// Appends an item to `cache_security_group_names`.
        ///
        /// To override the contents of this collection use [`set_cache_security_group_names`](Self::set_cache_security_group_names).
        ///
        /// <p>A list of cache security group names to associate with this replication group.</p>
        pub fn cache_security_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_security_group_names.unwrap_or_default();
            v.push(input.into());
            self.cache_security_group_names = Some(v);
            self
        }
        /// <p>A list of cache security group names to associate with this replication group.</p>
        pub fn set_cache_security_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_security_group_names = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>One or more Amazon VPC security groups associated with this replication group.</p>
        /// <p>Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>One or more Amazon VPC security groups associated with this replication group.</p>
        /// <p>Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=<code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=<code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=<code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=<code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=<code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=<code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `snapshot_arns`.
        ///
        /// To override the contents of this collection use [`set_snapshot_arns`](Self::set_snapshot_arns).
        ///
        /// <p>A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
        /// <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>
        pub fn snapshot_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.snapshot_arns.unwrap_or_default();
            v.push(input.into());
            self.snapshot_arns = Some(v);
            self
        }
        /// <p>A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
        /// <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>
        pub fn set_snapshot_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.snapshot_arns = input;
            self
        }
        /// <p>The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to <code>restoring</code> while the new replication group is being created.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to <code>restoring</code> while the new replication group is being created.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_name = input;
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for <code>ddd</code> are:</p>
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for <code>ddd</code> are:</p>
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The port number on which each member of the replication group accepts connections.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which each member of the replication group accepts connections.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be the same as the cluster owner.</p>
        /// </note>
        pub fn notification_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be the same as the cluster owner.</p>
        /// </note>
        pub fn set_notification_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_topic_arn = input;
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        /// <p>Default: 0 (i.e., automatic backups are disabled for this cluster).</p>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.snapshot_retention_limit = Some(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        /// <p>Default: 0 (i.e., automatic backups are disabled for this cluster).</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.snapshot_retention_limit = input;
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p>
        /// <p>Example: <code>05:00-09:00</code> </p>
        /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_window = Some(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p>
        /// <p>Example: <code>05:00-09:00</code> </p>
        /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_window = input;
            self
        }
        /// <p> <b>Reserved parameter.</b> The password used to access a password protected server.</p>
        /// <p> <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is <code>true</code>.</p> <important>
        /// <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p>
        /// </important>
        /// <p>Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters.</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li>
        /// <li> <p>The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special characters cannot be used in the AUTH token.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.</p>
        pub fn auth_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_token = Some(input.into());
            self
        }
        /// <p> <b>Reserved parameter.</b> The password used to access a password protected server.</p>
        /// <p> <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is <code>true</code>.</p> <important>
        /// <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p>
        /// </important>
        /// <p>Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters.</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li>
        /// <li> <p>The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special characters cannot be used in the AUTH token.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.</p>
        pub fn set_auth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_token = input;
            self
        }
        /// <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.</p>
        /// <p>This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being created in an Amazon VPC.</p>
        /// <p>If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.</p>
        /// <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code> </p> <important>
        /// <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p>
        /// </important>
        pub fn transit_encryption_enabled(mut self, input: bool) -> Self {
            self.transit_encryption_enabled = Some(input);
            self
        }
        /// <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.</p>
        /// <p>This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being created in an Amazon VPC.</p>
        /// <p>If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.</p>
        /// <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code> </p> <important>
        /// <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p>
        /// </important>
        pub fn set_transit_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.transit_encryption_enabled = input;
            self
        }
        /// <p>A flag that enables encryption at rest when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group. </p>
        /// <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn at_rest_encryption_enabled(mut self, input: bool) -> Self {
            self.at_rest_encryption_enabled = Some(input);
            self
        }
        /// <p>A flag that enables encryption at rest when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group. </p>
        /// <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_at_rest_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.at_rest_encryption_enabled = input;
            self
        }
        /// <p>The ID of the KMS key used to encrypt the disk in the cluster.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the disk in the cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `user_group_ids`.
        ///
        /// To override the contents of this collection use [`set_user_group_ids`](Self::set_user_group_ids).
        ///
        /// <p>The user group to associate with the replication group.</p>
        pub fn user_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_group_ids.unwrap_or_default();
            v.push(input.into());
            self.user_group_ids = Some(v);
            self
        }
        /// <p>The user group to associate with the replication group.</p>
        pub fn set_user_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_group_ids = input;
            self
        }
        /// Appends an item to `log_delivery_configurations`.
        ///
        /// To override the contents of this collection use [`set_log_delivery_configurations`](Self::set_log_delivery_configurations).
        ///
        /// <p>Specifies the destination, format and type of the logs.</p>
        pub fn log_delivery_configurations(
            mut self,
            input: crate::model::LogDeliveryConfigurationRequest,
        ) -> Self {
            let mut v = self.log_delivery_configurations.unwrap_or_default();
            v.push(input);
            self.log_delivery_configurations = Some(v);
            self
        }
        /// <p>Specifies the destination, format and type of the logs.</p>
        pub fn set_log_delivery_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>,
            >,
        ) -> Self {
            self.log_delivery_configurations = input;
            self
        }
        /// <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
        pub fn data_tiering_enabled(mut self, input: bool) -> Self {
            self.data_tiering_enabled = Some(input);
            self
        }
        /// <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
        pub fn set_data_tiering_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.data_tiering_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicationGroupInput`](crate::input::CreateReplicationGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReplicationGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReplicationGroupInput {
                replication_group_id: self.replication_group_id,
                replication_group_description: self.replication_group_description,
                global_replication_group_id: self.global_replication_group_id,
                primary_cluster_id: self.primary_cluster_id,
                automatic_failover_enabled: self.automatic_failover_enabled,
                multi_az_enabled: self.multi_az_enabled,
                num_cache_clusters: self.num_cache_clusters,
                preferred_cache_cluster_a_zs: self.preferred_cache_cluster_a_zs,
                num_node_groups: self.num_node_groups,
                replicas_per_node_group: self.replicas_per_node_group,
                node_group_configuration: self.node_group_configuration,
                cache_node_type: self.cache_node_type,
                engine: self.engine,
                engine_version: self.engine_version,
                cache_parameter_group_name: self.cache_parameter_group_name,
                cache_subnet_group_name: self.cache_subnet_group_name,
                cache_security_group_names: self.cache_security_group_names,
                security_group_ids: self.security_group_ids,
                tags: self.tags,
                snapshot_arns: self.snapshot_arns,
                snapshot_name: self.snapshot_name,
                preferred_maintenance_window: self.preferred_maintenance_window,
                port: self.port,
                notification_topic_arn: self.notification_topic_arn,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
                snapshot_retention_limit: self.snapshot_retention_limit,
                snapshot_window: self.snapshot_window,
                auth_token: self.auth_token,
                transit_encryption_enabled: self.transit_encryption_enabled,
                at_rest_encryption_enabled: self.at_rest_encryption_enabled,
                kms_key_id: self.kms_key_id,
                user_group_ids: self.user_group_ids,
                log_delivery_configurations: self.log_delivery_configurations,
                data_tiering_enabled: self.data_tiering_enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReplicationGroupInputOperationOutputAlias = crate::operation::CreateReplicationGroup;
#[doc(hidden)]
pub type CreateReplicationGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateReplicationGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateReplicationGroup`](crate::operation::CreateReplicationGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReplicationGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReplicationGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReplicationGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReplicationGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_replication_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReplicationGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReplicationGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReplicationGroupInput`](crate::input::CreateReplicationGroupInput)
    pub fn builder() -> crate::input::create_replication_group_input::Builder {
        crate::input::create_replication_group_input::Builder::default()
    }
}

/// See [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
pub mod create_snapshot_input {
    /// A builder for [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_name: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of an existing replication group. The snapshot is created from this replication group.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of an existing replication group. The snapshot is created from this replication group.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The identifier of an existing cluster. The snapshot is created from this cluster.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The identifier of an existing cluster. The snapshot is created from this cluster.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>A name for the snapshot being created.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_name = Some(input.into());
            self
        }
        /// <p>A name for the snapshot being created.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_name = input;
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSnapshotInput {
                replication_group_id: self.replication_group_id,
                cache_cluster_id: self.cache_cluster_id,
                snapshot_name: self.snapshot_name,
                kms_key_id: self.kms_key_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSnapshotInputOperationOutputAlias = crate::operation::CreateSnapshot;
#[doc(hidden)]
pub type CreateSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateSnapshot`](crate::operation::CreateSnapshot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_snapshot(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSnapshot",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    pub fn builder() -> crate::input::create_snapshot_input::Builder {
        crate::input::create_snapshot_input::Builder::default()
    }
}

/// See [`CreateUserInput`](crate::input::CreateUserInput)
pub mod create_user_input {
    /// A builder for [`CreateUserInput`](crate::input::CreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) passwords: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) access_string: std::option::Option<std::string::String>,
        pub(crate) no_password_required: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The username of the user.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The username of the user.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// Appends an item to `passwords`.
        ///
        /// To override the contents of this collection use [`set_passwords`](Self::set_passwords).
        ///
        /// <p>Passwords used for this user. You can create up to two passwords for each user.</p>
        pub fn passwords(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.passwords.unwrap_or_default();
            v.push(input.into());
            self.passwords = Some(v);
            self
        }
        /// <p>Passwords used for this user. You can create up to two passwords for each user.</p>
        pub fn set_passwords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.passwords = input;
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_string = Some(input.into());
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_string = input;
            self
        }
        /// <p>Indicates a password is not required for this user.</p>
        pub fn no_password_required(mut self, input: bool) -> Self {
            self.no_password_required = Some(input);
            self
        }
        /// <p>Indicates a password is not required for this user.</p>
        pub fn set_no_password_required(mut self, input: std::option::Option<bool>) -> Self {
            self.no_password_required = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserInput`](crate::input::CreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserInput {
                user_id: self.user_id,
                user_name: self.user_name,
                engine: self.engine,
                passwords: self.passwords,
                access_string: self.access_string,
                no_password_required: self.no_password_required,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserInputOperationOutputAlias = crate::operation::CreateUser;
#[doc(hidden)]
pub type CreateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateUser`](crate::operation::CreateUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_user(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUser",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
}

/// See [`CreateUserGroupInput`](crate::input::CreateUserGroupInput)
pub mod create_user_group_input {
    /// A builder for [`CreateUserGroupInput`](crate::input::CreateUserGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_group_id: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the user group.</p>
        pub fn user_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the user group.</p>
        pub fn set_user_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_group_id = input;
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// Appends an item to `user_ids`.
        ///
        /// To override the contents of this collection use [`set_user_ids`](Self::set_user_ids).
        ///
        /// <p>The list of user IDs that belong to the user group.</p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_ids.unwrap_or_default();
            v.push(input.into());
            self.user_ids = Some(v);
            self
        }
        /// <p>The list of user IDs that belong to the user group.</p>
        pub fn set_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserGroupInput`](crate::input::CreateUserGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserGroupInput {
                user_group_id: self.user_group_id,
                engine: self.engine,
                user_ids: self.user_ids,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserGroupInputOperationOutputAlias = crate::operation::CreateUserGroup;
#[doc(hidden)]
pub type CreateUserGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateUserGroup`](crate::operation::CreateUserGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUserGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_user_group(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUserGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUserGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserGroupInput`](crate::input::CreateUserGroupInput)
    pub fn builder() -> crate::input::create_user_group_input::Builder {
        crate::input::create_user_group_input::Builder::default()
    }
}

/// See [`DecreaseNodeGroupsInGlobalReplicationGroupInput`](crate::input::DecreaseNodeGroupsInGlobalReplicationGroupInput)
pub mod decrease_node_groups_in_global_replication_group_input {
    /// A builder for [`DecreaseNodeGroupsInGlobalReplicationGroupInput`](crate::input::DecreaseNodeGroupsInGlobalReplicationGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group_id: std::option::Option<std::string::String>,
        pub(crate) node_group_count: std::option::Option<i32>,
        pub(crate) global_node_groups_to_remove:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) global_node_groups_to_retain:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) apply_immediately: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = input;
            self
        }
        /// <p>The number of node groups (shards) that results from the modification of the shard configuration</p>
        pub fn node_group_count(mut self, input: i32) -> Self {
            self.node_group_count = Some(input);
            self
        }
        /// <p>The number of node groups (shards) that results from the modification of the shard configuration</p>
        pub fn set_node_group_count(mut self, input: std::option::Option<i32>) -> Self {
            self.node_group_count = input;
            self
        }
        /// Appends an item to `global_node_groups_to_remove`.
        ///
        /// To override the contents of this collection use [`set_global_node_groups_to_remove`](Self::set_global_node_groups_to_remove).
        ///
        /// <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by GlobalNodeGroupsToRemove from the cluster. </p>
        pub fn global_node_groups_to_remove(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.global_node_groups_to_remove.unwrap_or_default();
            v.push(input.into());
            self.global_node_groups_to_remove = Some(v);
            self
        }
        /// <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by GlobalNodeGroupsToRemove from the cluster. </p>
        pub fn set_global_node_groups_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.global_node_groups_to_remove = input;
            self
        }
        /// Appends an item to `global_node_groups_to_retain`.
        ///
        /// To override the contents of this collection use [`set_global_node_groups_to_retain`](Self::set_global_node_groups_to_retain).
        ///
        /// <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRetain is a list of NodeGroupIds to retain from the cluster. ElastiCache for Redis will attempt to retain all node groups listed by GlobalNodeGroupsToRetain from the cluster. </p>
        pub fn global_node_groups_to_retain(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.global_node_groups_to_retain.unwrap_or_default();
            v.push(input.into());
            self.global_node_groups_to_retain = Some(v);
            self
        }
        /// <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRetain is a list of NodeGroupIds to retain from the cluster. ElastiCache for Redis will attempt to retain all node groups listed by GlobalNodeGroupsToRetain from the cluster. </p>
        pub fn set_global_node_groups_to_retain(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.global_node_groups_to_retain = input;
            self
        }
        /// <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is true. </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is true. </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// Consumes the builder and constructs a [`DecreaseNodeGroupsInGlobalReplicationGroupInput`](crate::input::DecreaseNodeGroupsInGlobalReplicationGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DecreaseNodeGroupsInGlobalReplicationGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DecreaseNodeGroupsInGlobalReplicationGroupInput {
                    global_replication_group_id: self.global_replication_group_id,
                    node_group_count: self.node_group_count.unwrap_or_default(),
                    global_node_groups_to_remove: self.global_node_groups_to_remove,
                    global_node_groups_to_retain: self.global_node_groups_to_retain,
                    apply_immediately: self.apply_immediately.unwrap_or_default(),
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DecreaseNodeGroupsInGlobalReplicationGroupInputOperationOutputAlias =
    crate::operation::DecreaseNodeGroupsInGlobalReplicationGroup;
#[doc(hidden)]
pub type DecreaseNodeGroupsInGlobalReplicationGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DecreaseNodeGroupsInGlobalReplicationGroupInput {
    /// Consumes the builder and constructs an Operation<[`DecreaseNodeGroupsInGlobalReplicationGroup`](crate::operation::DecreaseNodeGroupsInGlobalReplicationGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DecreaseNodeGroupsInGlobalReplicationGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DecreaseNodeGroupsInGlobalReplicationGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DecreaseNodeGroupsInGlobalReplicationGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DecreaseNodeGroupsInGlobalReplicationGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_decrease_node_groups_in_global_replication_group(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DecreaseNodeGroupsInGlobalReplicationGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DecreaseNodeGroupsInGlobalReplicationGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DecreaseNodeGroupsInGlobalReplicationGroupInput`](crate::input::DecreaseNodeGroupsInGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::decrease_node_groups_in_global_replication_group_input::Builder
    {
        crate::input::decrease_node_groups_in_global_replication_group_input::Builder::default()
    }
}

/// See [`DecreaseReplicaCountInput`](crate::input::DecreaseReplicaCountInput)
pub mod decrease_replica_count_input {
    /// A builder for [`DecreaseReplicaCountInput`](crate::input::DecreaseReplicaCountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) new_replica_count: std::option::Option<i32>,
        pub(crate) replica_configuration:
            std::option::Option<std::vec::Vec<crate::model::ConfigureShard>>,
        pub(crate) replicas_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) apply_immediately: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The id of the replication group from which you want to remove replica nodes.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The id of the replication group from which you want to remove replica nodes.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>
        /// <p>The minimum number of replicas in a shard or replication group is:</p>
        /// <ul>
        /// <li> <p>Redis (cluster mode disabled)</p>
        /// <ul>
        /// <li> <p>If Multi-AZ is enabled: 1</p> </li>
        /// <li> <p>If Multi-AZ is not enabled: 0</p> </li>
        /// </ul> </li>
        /// <li> <p>Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)</p> </li>
        /// </ul>
        pub fn new_replica_count(mut self, input: i32) -> Self {
            self.new_replica_count = Some(input);
            self
        }
        /// <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>
        /// <p>The minimum number of replicas in a shard or replication group is:</p>
        /// <ul>
        /// <li> <p>Redis (cluster mode disabled)</p>
        /// <ul>
        /// <li> <p>If Multi-AZ is enabled: 1</p> </li>
        /// <li> <p>If Multi-AZ is not enabled: 0</p> </li>
        /// </ul> </li>
        /// <li> <p>Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)</p> </li>
        /// </ul>
        pub fn set_new_replica_count(mut self, input: std::option::Option<i32>) -> Self {
            self.new_replica_count = input;
            self
        }
        /// Appends an item to `replica_configuration`.
        ///
        /// To override the contents of this collection use [`set_replica_configuration`](Self::set_replica_configuration).
        ///
        /// <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
        pub fn replica_configuration(mut self, input: crate::model::ConfigureShard) -> Self {
            let mut v = self.replica_configuration.unwrap_or_default();
            v.push(input);
            self.replica_configuration = Some(v);
            self
        }
        /// <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
        pub fn set_replica_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigureShard>>,
        ) -> Self {
            self.replica_configuration = input;
            self
        }
        /// Appends an item to `replicas_to_remove`.
        ///
        /// To override the contents of this collection use [`set_replicas_to_remove`](Self::set_replicas_to_remove).
        ///
        /// <p>A list of the node ids to remove from the replication group or node group (shard).</p>
        pub fn replicas_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.replicas_to_remove.unwrap_or_default();
            v.push(input.into());
            self.replicas_to_remove = Some(v);
            self
        }
        /// <p>A list of the node ids to remove from the replication group or node group (shard).</p>
        pub fn set_replicas_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replicas_to_remove = input;
            self
        }
        /// <p>If <code>True</code>, the number of replica nodes is decreased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>If <code>True</code>, the number of replica nodes is decreased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// Consumes the builder and constructs a [`DecreaseReplicaCountInput`](crate::input::DecreaseReplicaCountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DecreaseReplicaCountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DecreaseReplicaCountInput {
                replication_group_id: self.replication_group_id,
                new_replica_count: self.new_replica_count,
                replica_configuration: self.replica_configuration,
                replicas_to_remove: self.replicas_to_remove,
                apply_immediately: self.apply_immediately.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DecreaseReplicaCountInputOperationOutputAlias = crate::operation::DecreaseReplicaCount;
#[doc(hidden)]
pub type DecreaseReplicaCountInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DecreaseReplicaCountInput {
    /// Consumes the builder and constructs an Operation<[`DecreaseReplicaCount`](crate::operation::DecreaseReplicaCount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DecreaseReplicaCount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DecreaseReplicaCountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DecreaseReplicaCountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DecreaseReplicaCountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_decrease_replica_count(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DecreaseReplicaCount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DecreaseReplicaCount",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DecreaseReplicaCountInput`](crate::input::DecreaseReplicaCountInput)
    pub fn builder() -> crate::input::decrease_replica_count_input::Builder {
        crate::input::decrease_replica_count_input::Builder::default()
    }
}

/// See [`DeleteCacheClusterInput`](crate::input::DeleteCacheClusterInput)
pub mod delete_cache_cluster_input {
    /// A builder for [`DeleteCacheClusterInput`](crate::input::DeleteCacheClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) final_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The cluster identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. ElastiCache creates the snapshot, and then deletes the cluster immediately afterward.</p>
        pub fn final_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.final_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. ElastiCache creates the snapshot, and then deletes the cluster immediately afterward.</p>
        pub fn set_final_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCacheClusterInput`](crate::input::DeleteCacheClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCacheClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCacheClusterInput {
                cache_cluster_id: self.cache_cluster_id,
                final_snapshot_identifier: self.final_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCacheClusterInputOperationOutputAlias = crate::operation::DeleteCacheCluster;
#[doc(hidden)]
pub type DeleteCacheClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCacheClusterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCacheCluster`](crate::operation::DeleteCacheCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCacheCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCacheClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCacheClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCacheClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_cache_cluster(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCacheCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCacheCluster",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCacheClusterInput`](crate::input::DeleteCacheClusterInput)
    pub fn builder() -> crate::input::delete_cache_cluster_input::Builder {
        crate::input::delete_cache_cluster_input::Builder::default()
    }
}

/// See [`DeleteCacheParameterGroupInput`](crate::input::DeleteCacheParameterGroupInput)
pub mod delete_cache_parameter_group_input {
    /// A builder for [`DeleteCacheParameterGroupInput`](crate::input::DeleteCacheParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cache parameter group to delete.</p> <note>
        /// <p>The specified cache security group must not be associated with any clusters.</p>
        /// </note>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group to delete.</p> <note>
        /// <p>The specified cache security group must not be associated with any clusters.</p>
        /// </note>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCacheParameterGroupInput`](crate::input::DeleteCacheParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCacheParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCacheParameterGroupInput {
                cache_parameter_group_name: self.cache_parameter_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCacheParameterGroupInputOperationOutputAlias =
    crate::operation::DeleteCacheParameterGroup;
#[doc(hidden)]
pub type DeleteCacheParameterGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCacheParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCacheParameterGroup`](crate::operation::DeleteCacheParameterGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCacheParameterGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCacheParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCacheParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCacheParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_cache_parameter_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCacheParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCacheParameterGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCacheParameterGroupInput`](crate::input::DeleteCacheParameterGroupInput)
    pub fn builder() -> crate::input::delete_cache_parameter_group_input::Builder {
        crate::input::delete_cache_parameter_group_input::Builder::default()
    }
}

/// See [`DeleteCacheSecurityGroupInput`](crate::input::DeleteCacheSecurityGroupInput)
pub mod delete_cache_security_group_input {
    /// A builder for [`DeleteCacheSecurityGroupInput`](crate::input::DeleteCacheSecurityGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_security_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cache security group to delete.</p> <note>
        /// <p>You cannot delete the default security group.</p>
        /// </note>
        pub fn cache_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache security group to delete.</p> <note>
        /// <p>You cannot delete the default security group.</p>
        /// </note>
        pub fn set_cache_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_security_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCacheSecurityGroupInput`](crate::input::DeleteCacheSecurityGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCacheSecurityGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCacheSecurityGroupInput {
                cache_security_group_name: self.cache_security_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCacheSecurityGroupInputOperationOutputAlias =
    crate::operation::DeleteCacheSecurityGroup;
#[doc(hidden)]
pub type DeleteCacheSecurityGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCacheSecurityGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCacheSecurityGroup`](crate::operation::DeleteCacheSecurityGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCacheSecurityGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCacheSecurityGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCacheSecurityGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCacheSecurityGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_cache_security_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCacheSecurityGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCacheSecurityGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCacheSecurityGroupInput`](crate::input::DeleteCacheSecurityGroupInput)
    pub fn builder() -> crate::input::delete_cache_security_group_input::Builder {
        crate::input::delete_cache_security_group_input::Builder::default()
    }
}

/// See [`DeleteCacheSubnetGroupInput`](crate::input::DeleteCacheSubnetGroupInput)
pub mod delete_cache_subnet_group_input {
    /// A builder for [`DeleteCacheSubnetGroupInput`](crate::input::DeleteCacheSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_subnet_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cache subnet group to delete.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache subnet group to delete.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCacheSubnetGroupInput`](crate::input::DeleteCacheSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCacheSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCacheSubnetGroupInput {
                cache_subnet_group_name: self.cache_subnet_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCacheSubnetGroupInputOperationOutputAlias = crate::operation::DeleteCacheSubnetGroup;
#[doc(hidden)]
pub type DeleteCacheSubnetGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCacheSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCacheSubnetGroup`](crate::operation::DeleteCacheSubnetGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCacheSubnetGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCacheSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCacheSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCacheSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_cache_subnet_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCacheSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCacheSubnetGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCacheSubnetGroupInput`](crate::input::DeleteCacheSubnetGroupInput)
    pub fn builder() -> crate::input::delete_cache_subnet_group_input::Builder {
        crate::input::delete_cache_subnet_group_input::Builder::default()
    }
}

/// See [`DeleteGlobalReplicationGroupInput`](crate::input::DeleteGlobalReplicationGroupInput)
pub mod delete_global_replication_group_input {
    /// A builder for [`DeleteGlobalReplicationGroupInput`](crate::input::DeleteGlobalReplicationGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group_id: std::option::Option<std::string::String>,
        pub(crate) retain_primary_replication_group: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = input;
            self
        }
        /// <p>The primary replication group is retained as a standalone replication group. </p>
        pub fn retain_primary_replication_group(mut self, input: bool) -> Self {
            self.retain_primary_replication_group = Some(input);
            self
        }
        /// <p>The primary replication group is retained as a standalone replication group. </p>
        pub fn set_retain_primary_replication_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.retain_primary_replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGlobalReplicationGroupInput`](crate::input::DeleteGlobalReplicationGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGlobalReplicationGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGlobalReplicationGroupInput {
                global_replication_group_id: self.global_replication_group_id,
                retain_primary_replication_group: self
                    .retain_primary_replication_group
                    .unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGlobalReplicationGroupInputOperationOutputAlias =
    crate::operation::DeleteGlobalReplicationGroup;
#[doc(hidden)]
pub type DeleteGlobalReplicationGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGlobalReplicationGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGlobalReplicationGroup`](crate::operation::DeleteGlobalReplicationGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGlobalReplicationGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGlobalReplicationGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGlobalReplicationGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGlobalReplicationGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_global_replication_group(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGlobalReplicationGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGlobalReplicationGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGlobalReplicationGroupInput`](crate::input::DeleteGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::delete_global_replication_group_input::Builder {
        crate::input::delete_global_replication_group_input::Builder::default()
    }
}

/// See [`DeleteReplicationGroupInput`](crate::input::DeleteReplicationGroupInput)
pub mod delete_replication_group_input {
    /// A builder for [`DeleteReplicationGroupInput`](crate::input::DeleteReplicationGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) retain_primary_cluster: std::option::Option<bool>,
        pub(crate) final_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>If set to <code>true</code>, all of the read replicas are deleted, but the primary node is retained.</p>
        pub fn retain_primary_cluster(mut self, input: bool) -> Self {
            self.retain_primary_cluster = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, all of the read replicas are deleted, but the primary node is retained.</p>
        pub fn set_retain_primary_cluster(mut self, input: std::option::Option<bool>) -> Self {
            self.retain_primary_cluster = input;
            self
        }
        /// <p>The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster, rather than one of the replicas; this is to ensure that it captures the freshest data. After the final snapshot is taken, the replication group is immediately deleted.</p>
        pub fn final_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.final_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster, rather than one of the replicas; this is to ensure that it captures the freshest data. After the final snapshot is taken, the replication group is immediately deleted.</p>
        pub fn set_final_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReplicationGroupInput`](crate::input::DeleteReplicationGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReplicationGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReplicationGroupInput {
                replication_group_id: self.replication_group_id,
                retain_primary_cluster: self.retain_primary_cluster,
                final_snapshot_identifier: self.final_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReplicationGroupInputOperationOutputAlias = crate::operation::DeleteReplicationGroup;
#[doc(hidden)]
pub type DeleteReplicationGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteReplicationGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReplicationGroup`](crate::operation::DeleteReplicationGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReplicationGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReplicationGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReplicationGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReplicationGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_replication_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReplicationGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReplicationGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReplicationGroupInput`](crate::input::DeleteReplicationGroupInput)
    pub fn builder() -> crate::input::delete_replication_group_input::Builder {
        crate::input::delete_replication_group_input::Builder::default()
    }
}

/// See [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
pub mod delete_snapshot_input {
    /// A builder for [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the snapshot to be deleted.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the snapshot to be deleted.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSnapshotInput {
                snapshot_name: self.snapshot_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSnapshotInputOperationOutputAlias = crate::operation::DeleteSnapshot;
#[doc(hidden)]
pub type DeleteSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSnapshot`](crate::operation::DeleteSnapshot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_snapshot(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSnapshot",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
    pub fn builder() -> crate::input::delete_snapshot_input::Builder {
        crate::input::delete_snapshot_input::Builder::default()
    }
}

/// See [`DeleteUserInput`](crate::input::DeleteUserInput)
pub mod delete_user_input {
    /// A builder for [`DeleteUserInput`](crate::input::DeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserInput`](crate::input::DeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserInput {
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserInputOperationOutputAlias = crate::operation::DeleteUser;
#[doc(hidden)]
pub type DeleteUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUser`](crate::operation::DeleteUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_user(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUser",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
}

/// See [`DeleteUserGroupInput`](crate::input::DeleteUserGroupInput)
pub mod delete_user_group_input {
    /// A builder for [`DeleteUserGroupInput`](crate::input::DeleteUserGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user group.</p>
        pub fn user_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the user group.</p>
        pub fn set_user_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserGroupInput`](crate::input::DeleteUserGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserGroupInput {
                user_group_id: self.user_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserGroupInputOperationOutputAlias = crate::operation::DeleteUserGroup;
#[doc(hidden)]
pub type DeleteUserGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUserGroup`](crate::operation::DeleteUserGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUserGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_user_group(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUserGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUserGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserGroupInput`](crate::input::DeleteUserGroupInput)
    pub fn builder() -> crate::input::delete_user_group_input::Builder {
        crate::input::delete_user_group_input::Builder::default()
    }
}

/// See [`DescribeCacheClustersInput`](crate::input::DescribeCacheClustersInput)
pub mod describe_cache_clusters_input {
    /// A builder for [`DescribeCacheClustersInput`](crate::input::DescribeCacheClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) show_cache_node_info: std::option::Option<bool>,
        pub(crate) show_cache_clusters_not_in_replication_groups: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The user-supplied cluster identifier. If this parameter is specified, only information about that specific cluster is returned. This parameter isn't case sensitive.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The user-supplied cluster identifier. If this parameter is specified, only information about that specific cluster is returned. This parameter isn't case sensitive.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to retrieve information about the individual cache nodes.</p>
        pub fn show_cache_node_info(mut self, input: bool) -> Self {
            self.show_cache_node_info = Some(input);
            self
        }
        /// <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to retrieve information about the individual cache nodes.</p>
        pub fn set_show_cache_node_info(mut self, input: std::option::Option<bool>) -> Self {
            self.show_cache_node_info = input;
            self
        }
        /// <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to show only nodes (API/CLI: clusters) that are not members of a replication group. In practice, this mean Memcached and single node Redis clusters.</p>
        pub fn show_cache_clusters_not_in_replication_groups(mut self, input: bool) -> Self {
            self.show_cache_clusters_not_in_replication_groups = Some(input);
            self
        }
        /// <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to show only nodes (API/CLI: clusters) that are not members of a replication group. In practice, this mean Memcached and single node Redis clusters.</p>
        pub fn set_show_cache_clusters_not_in_replication_groups(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.show_cache_clusters_not_in_replication_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheClustersInput`](crate::input::DescribeCacheClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCacheClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCacheClustersInput {
                cache_cluster_id: self.cache_cluster_id,
                max_records: self.max_records,
                marker: self.marker,
                show_cache_node_info: self.show_cache_node_info,
                show_cache_clusters_not_in_replication_groups: self
                    .show_cache_clusters_not_in_replication_groups,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCacheClustersInputOperationOutputAlias = crate::operation::DescribeCacheClusters;
#[doc(hidden)]
pub type DescribeCacheClustersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCacheClustersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCacheClusters`](crate::operation::DescribeCacheClusters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCacheClusters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCacheClustersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCacheClustersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCacheClustersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_cache_clusters(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCacheClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCacheClusters",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCacheClustersInput`](crate::input::DescribeCacheClustersInput)
    pub fn builder() -> crate::input::describe_cache_clusters_input::Builder {
        crate::input::describe_cache_clusters_input::Builder::default()
    }
}

/// See [`DescribeCacheEngineVersionsInput`](crate::input::DescribeCacheEngineVersionsInput)
pub mod describe_cache_engine_versions_input {
    /// A builder for [`DescribeCacheEngineVersionsInput`](crate::input::DescribeCacheEngineVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) cache_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) default_only: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The cache engine to return. Valid values: <code>memcached</code> | <code>redis</code> </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The cache engine to return. Valid values: <code>memcached</code> | <code>redis</code> </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The cache engine version to return.</p>
        /// <p>Example: <code>1.4.14</code> </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The cache engine version to return.</p>
        /// <p>Example: <code>1.4.14</code> </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of a specific cache parameter group family to return details for.</p>
        /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn cache_parameter_group_family(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of a specific cache parameter group family to return details for.</p>
        /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn set_cache_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_family = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>If <code>true</code>, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
        pub fn default_only(mut self, input: bool) -> Self {
            self.default_only = Some(input);
            self
        }
        /// <p>If <code>true</code>, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
        pub fn set_default_only(mut self, input: std::option::Option<bool>) -> Self {
            self.default_only = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheEngineVersionsInput`](crate::input::DescribeCacheEngineVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCacheEngineVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCacheEngineVersionsInput {
                engine: self.engine,
                engine_version: self.engine_version,
                cache_parameter_group_family: self.cache_parameter_group_family,
                max_records: self.max_records,
                marker: self.marker,
                default_only: self.default_only.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCacheEngineVersionsInputOperationOutputAlias =
    crate::operation::DescribeCacheEngineVersions;
#[doc(hidden)]
pub type DescribeCacheEngineVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCacheEngineVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCacheEngineVersions`](crate::operation::DescribeCacheEngineVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCacheEngineVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCacheEngineVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCacheEngineVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCacheEngineVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_cache_engine_versions(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCacheEngineVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCacheEngineVersions",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCacheEngineVersionsInput`](crate::input::DescribeCacheEngineVersionsInput)
    pub fn builder() -> crate::input::describe_cache_engine_versions_input::Builder {
        crate::input::describe_cache_engine_versions_input::Builder::default()
    }
}

/// See [`DescribeCacheParameterGroupsInput`](crate::input::DescribeCacheParameterGroupsInput)
pub mod describe_cache_parameter_groups_input {
    /// A builder for [`DescribeCacheParameterGroupsInput`](crate::input::DescribeCacheParameterGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a specific cache parameter group to return details for.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific cache parameter group to return details for.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheParameterGroupsInput`](crate::input::DescribeCacheParameterGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCacheParameterGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCacheParameterGroupsInput {
                cache_parameter_group_name: self.cache_parameter_group_name,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCacheParameterGroupsInputOperationOutputAlias =
    crate::operation::DescribeCacheParameterGroups;
#[doc(hidden)]
pub type DescribeCacheParameterGroupsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCacheParameterGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCacheParameterGroups`](crate::operation::DescribeCacheParameterGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCacheParameterGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCacheParameterGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCacheParameterGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCacheParameterGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_cache_parameter_groups(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCacheParameterGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCacheParameterGroups",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCacheParameterGroupsInput`](crate::input::DescribeCacheParameterGroupsInput)
    pub fn builder() -> crate::input::describe_cache_parameter_groups_input::Builder {
        crate::input::describe_cache_parameter_groups_input::Builder::default()
    }
}

/// See [`DescribeCacheParametersInput`](crate::input::DescribeCacheParametersInput)
pub mod describe_cache_parameters_input {
    /// A builder for [`DescribeCacheParametersInput`](crate::input::DescribeCacheParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a specific cache parameter group to return details for.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific cache parameter group to return details for.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Valid values: <code>user</code> | <code>system</code> | <code>engine-default</code> </p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Valid values: <code>user</code> | <code>system</code> | <code>engine-default</code> </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheParametersInput`](crate::input::DescribeCacheParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCacheParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCacheParametersInput {
                cache_parameter_group_name: self.cache_parameter_group_name,
                source: self.source,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCacheParametersInputOperationOutputAlias =
    crate::operation::DescribeCacheParameters;
#[doc(hidden)]
pub type DescribeCacheParametersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCacheParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCacheParameters`](crate::operation::DescribeCacheParameters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCacheParameters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCacheParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCacheParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCacheParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_cache_parameters(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCacheParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCacheParameters",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCacheParametersInput`](crate::input::DescribeCacheParametersInput)
    pub fn builder() -> crate::input::describe_cache_parameters_input::Builder {
        crate::input::describe_cache_parameters_input::Builder::default()
    }
}

/// See [`DescribeCacheSecurityGroupsInput`](crate::input::DescribeCacheSecurityGroupsInput)
pub mod describe_cache_security_groups_input {
    /// A builder for [`DescribeCacheSecurityGroupsInput`](crate::input::DescribeCacheSecurityGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_security_group_name: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cache security group to return details for.</p>
        pub fn cache_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache security group to return details for.</p>
        pub fn set_cache_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_security_group_name = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheSecurityGroupsInput`](crate::input::DescribeCacheSecurityGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCacheSecurityGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCacheSecurityGroupsInput {
                cache_security_group_name: self.cache_security_group_name,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCacheSecurityGroupsInputOperationOutputAlias =
    crate::operation::DescribeCacheSecurityGroups;
#[doc(hidden)]
pub type DescribeCacheSecurityGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCacheSecurityGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCacheSecurityGroups`](crate::operation::DescribeCacheSecurityGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCacheSecurityGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCacheSecurityGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCacheSecurityGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCacheSecurityGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_cache_security_groups(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCacheSecurityGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCacheSecurityGroups",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCacheSecurityGroupsInput`](crate::input::DescribeCacheSecurityGroupsInput)
    pub fn builder() -> crate::input::describe_cache_security_groups_input::Builder {
        crate::input::describe_cache_security_groups_input::Builder::default()
    }
}

/// See [`DescribeCacheSubnetGroupsInput`](crate::input::DescribeCacheSubnetGroupsInput)
pub mod describe_cache_subnet_groups_input {
    /// A builder for [`DescribeCacheSubnetGroupsInput`](crate::input::DescribeCacheSubnetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cache subnet group to return details for.</p>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache subnet group to return details for.</p>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_name = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheSubnetGroupsInput`](crate::input::DescribeCacheSubnetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCacheSubnetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCacheSubnetGroupsInput {
                cache_subnet_group_name: self.cache_subnet_group_name,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCacheSubnetGroupsInputOperationOutputAlias =
    crate::operation::DescribeCacheSubnetGroups;
#[doc(hidden)]
pub type DescribeCacheSubnetGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCacheSubnetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCacheSubnetGroups`](crate::operation::DescribeCacheSubnetGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCacheSubnetGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCacheSubnetGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCacheSubnetGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCacheSubnetGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_cache_subnet_groups(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCacheSubnetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCacheSubnetGroups",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCacheSubnetGroupsInput`](crate::input::DescribeCacheSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_cache_subnet_groups_input::Builder {
        crate::input::describe_cache_subnet_groups_input::Builder::default()
    }
}

/// See [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
pub mod describe_engine_default_parameters_input {
    /// A builder for [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cache parameter group family.</p>
        /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>
        pub fn cache_parameter_group_family(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group family.</p>
        /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>
        pub fn set_cache_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_family = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEngineDefaultParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEngineDefaultParametersInput {
                cache_parameter_group_family: self.cache_parameter_group_family,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEngineDefaultParametersInputOperationOutputAlias =
    crate::operation::DescribeEngineDefaultParameters;
#[doc(hidden)]
pub type DescribeEngineDefaultParametersInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEngineDefaultParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEngineDefaultParameters`](crate::operation::DescribeEngineDefaultParameters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEngineDefaultParameters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEngineDefaultParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEngineDefaultParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEngineDefaultParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_engine_default_parameters(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEngineDefaultParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEngineDefaultParameters",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
    pub fn builder() -> crate::input::describe_engine_default_parameters_input::Builder {
        crate::input::describe_engine_default_parameters_input::Builder::default()
    }
}

/// See [`DescribeEventsInput`](crate::input::DescribeEventsInput)
pub mod describe_events_input {
    /// A builder for [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_identifier: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.</p>
        /// <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.</p>
        /// <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.</p>
        /// <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.</p>
        /// <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The number of minutes worth of events to retrieve.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The number of minutes worth of events to retrieve.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsInput`](crate::input::DescribeEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventsInput {
                source_identifier: self.source_identifier,
                source_type: self.source_type,
                start_time: self.start_time,
                end_time: self.end_time,
                duration: self.duration,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventsInputOperationOutputAlias = crate::operation::DescribeEvents;
#[doc(hidden)]
pub type DescribeEventsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEventsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEvents`](crate::operation::DescribeEvents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEvents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_events(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEvents",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
}

/// See [`DescribeGlobalReplicationGroupsInput`](crate::input::DescribeGlobalReplicationGroupsInput)
pub mod describe_global_replication_groups_input {
    /// A builder for [`DescribeGlobalReplicationGroupsInput`](crate::input::DescribeGlobalReplicationGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group_id: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) show_member_info: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Returns the list of members that comprise the Global datastore.</p>
        pub fn show_member_info(mut self, input: bool) -> Self {
            self.show_member_info = Some(input);
            self
        }
        /// <p>Returns the list of members that comprise the Global datastore.</p>
        pub fn set_show_member_info(mut self, input: std::option::Option<bool>) -> Self {
            self.show_member_info = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGlobalReplicationGroupsInput`](crate::input::DescribeGlobalReplicationGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGlobalReplicationGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGlobalReplicationGroupsInput {
                global_replication_group_id: self.global_replication_group_id,
                max_records: self.max_records,
                marker: self.marker,
                show_member_info: self.show_member_info,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGlobalReplicationGroupsInputOperationOutputAlias =
    crate::operation::DescribeGlobalReplicationGroups;
#[doc(hidden)]
pub type DescribeGlobalReplicationGroupsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeGlobalReplicationGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGlobalReplicationGroups`](crate::operation::DescribeGlobalReplicationGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGlobalReplicationGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGlobalReplicationGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGlobalReplicationGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGlobalReplicationGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_global_replication_groups(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGlobalReplicationGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGlobalReplicationGroups",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGlobalReplicationGroupsInput`](crate::input::DescribeGlobalReplicationGroupsInput)
    pub fn builder() -> crate::input::describe_global_replication_groups_input::Builder {
        crate::input::describe_global_replication_groups_input::Builder::default()
    }
}

/// See [`DescribeReplicationGroupsInput`](crate::input::DescribeReplicationGroupsInput)
pub mod describe_replication_groups_input {
    /// A builder for [`DescribeReplicationGroupsInput`](crate::input::DescribeReplicationGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the replication group to be described. This parameter is not case sensitive.</p>
        /// <p>If you do not specify this parameter, information about all replication groups is returned.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The identifier for the replication group to be described. This parameter is not case sensitive.</p>
        /// <p>If you do not specify this parameter, information about all replication groups is returned.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplicationGroupsInput`](crate::input::DescribeReplicationGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReplicationGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReplicationGroupsInput {
                replication_group_id: self.replication_group_id,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReplicationGroupsInputOperationOutputAlias =
    crate::operation::DescribeReplicationGroups;
#[doc(hidden)]
pub type DescribeReplicationGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeReplicationGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReplicationGroups`](crate::operation::DescribeReplicationGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReplicationGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReplicationGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReplicationGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReplicationGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_replication_groups(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReplicationGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReplicationGroups",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReplicationGroupsInput`](crate::input::DescribeReplicationGroupsInput)
    pub fn builder() -> crate::input::describe_replication_groups_input::Builder {
        crate::input::describe_replication_groups_input::Builder::default()
    }
}

/// See [`DescribeReservedCacheNodesInput`](crate::input::DescribeReservedCacheNodesInput)
pub mod describe_reserved_cache_nodes_input {
    /// A builder for [`DescribeReservedCacheNodesInput`](crate::input::DescribeReservedCacheNodesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_cache_node_id: std::option::Option<std::string::String>,
        pub(crate) reserved_cache_nodes_offering_id: std::option::Option<std::string::String>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<std::string::String>,
        pub(crate) product_description: std::option::Option<std::string::String>,
        pub(crate) offering_type: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The reserved cache node identifier filter value. Use this parameter to show only the reservation that matches the specified reservation ID.</p>
        pub fn reserved_cache_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_cache_node_id = Some(input.into());
            self
        }
        /// <p>The reserved cache node identifier filter value. Use this parameter to show only the reservation that matches the specified reservation ID.</p>
        pub fn set_reserved_cache_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_cache_node_id = input;
            self
        }
        /// <p>The offering identifier filter value. Use this parameter to show only purchased reservations matching the specified offering identifier.</p>
        pub fn reserved_cache_nodes_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_cache_nodes_offering_id = Some(input.into());
            self
        }
        /// <p>The offering identifier filter value. Use this parameter to show only purchased reservations matching the specified offering identifier.</p>
        pub fn set_reserved_cache_nodes_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_cache_nodes_offering_id = input;
            self
        }
        /// <p>The cache node type filter value. Use this parameter to show only those reservations matching the specified cache node type.</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 6.0 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>The cache node type filter value. Use this parameter to show only those reservations matching the specified cache node type.</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 6.0 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>The duration filter value, specified in years or seconds. Use this parameter to show only reservations for this duration.</p>
        /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
        pub fn duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.duration = Some(input.into());
            self
        }
        /// <p>The duration filter value, specified in years or seconds. Use this parameter to show only reservations for this duration.</p>
        /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
        pub fn set_duration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The product description filter value. Use this parameter to show only those reservations matching the specified product description.</p>
        pub fn product_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_description = Some(input.into());
            self
        }
        /// <p>The product description filter value. Use this parameter to show only those reservations matching the specified product description.</p>
        pub fn set_product_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.product_description = input;
            self
        }
        /// <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>
        /// <p>Valid values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization"|"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
        pub fn offering_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_type = Some(input.into());
            self
        }
        /// <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>
        /// <p>Valid values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization"|"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_type = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedCacheNodesInput`](crate::input::DescribeReservedCacheNodesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReservedCacheNodesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReservedCacheNodesInput {
                reserved_cache_node_id: self.reserved_cache_node_id,
                reserved_cache_nodes_offering_id: self.reserved_cache_nodes_offering_id,
                cache_node_type: self.cache_node_type,
                duration: self.duration,
                product_description: self.product_description,
                offering_type: self.offering_type,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReservedCacheNodesInputOperationOutputAlias =
    crate::operation::DescribeReservedCacheNodes;
#[doc(hidden)]
pub type DescribeReservedCacheNodesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeReservedCacheNodesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReservedCacheNodes`](crate::operation::DescribeReservedCacheNodes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReservedCacheNodes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReservedCacheNodesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReservedCacheNodesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReservedCacheNodesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_reserved_cache_nodes(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReservedCacheNodes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReservedCacheNodes",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReservedCacheNodesInput`](crate::input::DescribeReservedCacheNodesInput)
    pub fn builder() -> crate::input::describe_reserved_cache_nodes_input::Builder {
        crate::input::describe_reserved_cache_nodes_input::Builder::default()
    }
}

/// See [`DescribeReservedCacheNodesOfferingsInput`](crate::input::DescribeReservedCacheNodesOfferingsInput)
pub mod describe_reserved_cache_nodes_offerings_input {
    /// A builder for [`DescribeReservedCacheNodesOfferingsInput`](crate::input::DescribeReservedCacheNodesOfferingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_cache_nodes_offering_id: std::option::Option<std::string::String>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<std::string::String>,
        pub(crate) product_description: std::option::Option<std::string::String>,
        pub(crate) offering_type: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
        /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
        pub fn reserved_cache_nodes_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_cache_nodes_offering_id = Some(input.into());
            self
        }
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
        /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
        pub fn set_reserved_cache_nodes_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_cache_nodes_offering_id = input;
            self
        }
        /// <p>The cache node type filter value. Use this parameter to show only the available offerings matching the specified cache node type.</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward) <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 6.0 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>The cache node type filter value. Use this parameter to show only the available offerings matching the specified cache node type.</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward) <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 6.0 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>Duration filter value, specified in years or seconds. Use this parameter to show only reservations for a given duration.</p>
        /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
        pub fn duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.duration = Some(input.into());
            self
        }
        /// <p>Duration filter value, specified in years or seconds. Use this parameter to show only reservations for a given duration.</p>
        /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
        pub fn set_duration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The product description filter value. Use this parameter to show only the available offerings matching the specified product description.</p>
        pub fn product_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_description = Some(input.into());
            self
        }
        /// <p>The product description filter value. Use this parameter to show only the available offerings matching the specified product description.</p>
        pub fn set_product_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.product_description = input;
            self
        }
        /// <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>
        /// <p>Valid Values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization" |"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
        pub fn offering_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_type = Some(input.into());
            self
        }
        /// <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>
        /// <p>Valid Values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization" |"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_type = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedCacheNodesOfferingsInput`](crate::input::DescribeReservedCacheNodesOfferingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReservedCacheNodesOfferingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReservedCacheNodesOfferingsInput {
                reserved_cache_nodes_offering_id: self.reserved_cache_nodes_offering_id,
                cache_node_type: self.cache_node_type,
                duration: self.duration,
                product_description: self.product_description,
                offering_type: self.offering_type,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReservedCacheNodesOfferingsInputOperationOutputAlias =
    crate::operation::DescribeReservedCacheNodesOfferings;
#[doc(hidden)]
pub type DescribeReservedCacheNodesOfferingsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeReservedCacheNodesOfferingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReservedCacheNodesOfferings`](crate::operation::DescribeReservedCacheNodesOfferings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReservedCacheNodesOfferings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReservedCacheNodesOfferingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReservedCacheNodesOfferingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReservedCacheNodesOfferingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_reserved_cache_nodes_offerings(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReservedCacheNodesOfferings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReservedCacheNodesOfferings",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReservedCacheNodesOfferingsInput`](crate::input::DescribeReservedCacheNodesOfferingsInput)
    pub fn builder() -> crate::input::describe_reserved_cache_nodes_offerings_input::Builder {
        crate::input::describe_reserved_cache_nodes_offerings_input::Builder::default()
    }
}

/// See [`DescribeServiceUpdatesInput`](crate::input::DescribeServiceUpdatesInput)
pub mod describe_service_updates_input {
    /// A builder for [`DescribeServiceUpdatesInput`](crate::input::DescribeServiceUpdatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_update_name: std::option::Option<std::string::String>,
        pub(crate) service_update_status:
            std::option::Option<std::vec::Vec<crate::model::ServiceUpdateStatus>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_update_name = Some(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_update_name = input;
            self
        }
        /// Appends an item to `service_update_status`.
        ///
        /// To override the contents of this collection use [`set_service_update_status`](Self::set_service_update_status).
        ///
        /// <p>The status of the service update</p>
        pub fn service_update_status(mut self, input: crate::model::ServiceUpdateStatus) -> Self {
            let mut v = self.service_update_status.unwrap_or_default();
            v.push(input);
            self.service_update_status = Some(v);
            self
        }
        /// <p>The status of the service update</p>
        pub fn set_service_update_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceUpdateStatus>>,
        ) -> Self {
            self.service_update_status = input;
            self
        }
        /// <p>The maximum number of records to include in the response</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServiceUpdatesInput`](crate::input::DescribeServiceUpdatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeServiceUpdatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeServiceUpdatesInput {
                service_update_name: self.service_update_name,
                service_update_status: self.service_update_status,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeServiceUpdatesInputOperationOutputAlias = crate::operation::DescribeServiceUpdates;
#[doc(hidden)]
pub type DescribeServiceUpdatesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeServiceUpdatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeServiceUpdates`](crate::operation::DescribeServiceUpdates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeServiceUpdates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeServiceUpdatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeServiceUpdatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeServiceUpdatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_service_updates(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeServiceUpdates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeServiceUpdates",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeServiceUpdatesInput`](crate::input::DescribeServiceUpdatesInput)
    pub fn builder() -> crate::input::describe_service_updates_input::Builder {
        crate::input::describe_service_updates_input::Builder::default()
    }
}

/// See [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
pub mod describe_snapshots_input {
    /// A builder for [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_name: std::option::Option<std::string::String>,
        pub(crate) snapshot_source: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) show_node_group_config: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with that specific replication group are described.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with that specific replication group are described.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_name = Some(input.into());
            self
        }
        /// <p>A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_name = input;
            self
        }
        /// <p>If set to <code>system</code>, the output shows snapshots that were automatically created by ElastiCache. If set to <code>user</code> the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
        pub fn snapshot_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_source = Some(input.into());
            self
        }
        /// <p>If set to <code>system</code>, the output shows snapshots that were automatically created by ElastiCache. If set to <code>user</code> the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
        pub fn set_snapshot_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_source = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 50</p>
        /// <p>Constraints: minimum 20; maximum 50.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 50</p>
        /// <p>Constraints: minimum 20; maximum 50.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>A Boolean value which if true, the node group (shard) configuration is included in the snapshot description.</p>
        pub fn show_node_group_config(mut self, input: bool) -> Self {
            self.show_node_group_config = Some(input);
            self
        }
        /// <p>A Boolean value which if true, the node group (shard) configuration is included in the snapshot description.</p>
        pub fn set_show_node_group_config(mut self, input: std::option::Option<bool>) -> Self {
            self.show_node_group_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSnapshotsInput {
                replication_group_id: self.replication_group_id,
                cache_cluster_id: self.cache_cluster_id,
                snapshot_name: self.snapshot_name,
                snapshot_source: self.snapshot_source,
                marker: self.marker,
                max_records: self.max_records,
                show_node_group_config: self.show_node_group_config,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSnapshotsInputOperationOutputAlias = crate::operation::DescribeSnapshots;
#[doc(hidden)]
pub type DescribeSnapshotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSnapshots`](crate::operation::DescribeSnapshots)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSnapshots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSnapshotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSnapshotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSnapshotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_snapshots(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSnapshots",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
    pub fn builder() -> crate::input::describe_snapshots_input::Builder {
        crate::input::describe_snapshots_input::Builder::default()
    }
}

/// See [`DescribeUpdateActionsInput`](crate::input::DescribeUpdateActionsInput)
pub mod describe_update_actions_input {
    /// A builder for [`DescribeUpdateActionsInput`](crate::input::DescribeUpdateActionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_update_name: std::option::Option<std::string::String>,
        pub(crate) replication_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cache_cluster_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) service_update_status:
            std::option::Option<std::vec::Vec<crate::model::ServiceUpdateStatus>>,
        pub(crate) service_update_time_range: std::option::Option<crate::model::TimeRangeFilter>,
        pub(crate) update_action_status:
            std::option::Option<std::vec::Vec<crate::model::UpdateActionStatus>>,
        pub(crate) show_node_level_update_status: std::option::Option<bool>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_update_name = Some(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_update_name = input;
            self
        }
        /// Appends an item to `replication_group_ids`.
        ///
        /// To override the contents of this collection use [`set_replication_group_ids`](Self::set_replication_group_ids).
        ///
        /// <p>The replication group IDs</p>
        pub fn replication_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.replication_group_ids.unwrap_or_default();
            v.push(input.into());
            self.replication_group_ids = Some(v);
            self
        }
        /// <p>The replication group IDs</p>
        pub fn set_replication_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_group_ids = input;
            self
        }
        /// Appends an item to `cache_cluster_ids`.
        ///
        /// To override the contents of this collection use [`set_cache_cluster_ids`](Self::set_cache_cluster_ids).
        ///
        /// <p>The cache cluster IDs</p>
        pub fn cache_cluster_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_cluster_ids.unwrap_or_default();
            v.push(input.into());
            self.cache_cluster_ids = Some(v);
            self
        }
        /// <p>The cache cluster IDs</p>
        pub fn set_cache_cluster_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_cluster_ids = input;
            self
        }
        /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// Appends an item to `service_update_status`.
        ///
        /// To override the contents of this collection use [`set_service_update_status`](Self::set_service_update_status).
        ///
        /// <p>The status of the service update</p>
        pub fn service_update_status(mut self, input: crate::model::ServiceUpdateStatus) -> Self {
            let mut v = self.service_update_status.unwrap_or_default();
            v.push(input);
            self.service_update_status = Some(v);
            self
        }
        /// <p>The status of the service update</p>
        pub fn set_service_update_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceUpdateStatus>>,
        ) -> Self {
            self.service_update_status = input;
            self
        }
        /// <p>The range of time specified to search for service updates that are in available status</p>
        pub fn service_update_time_range(mut self, input: crate::model::TimeRangeFilter) -> Self {
            self.service_update_time_range = Some(input);
            self
        }
        /// <p>The range of time specified to search for service updates that are in available status</p>
        pub fn set_service_update_time_range(
            mut self,
            input: std::option::Option<crate::model::TimeRangeFilter>,
        ) -> Self {
            self.service_update_time_range = input;
            self
        }
        /// Appends an item to `update_action_status`.
        ///
        /// To override the contents of this collection use [`set_update_action_status`](Self::set_update_action_status).
        ///
        /// <p>The status of the update action.</p>
        pub fn update_action_status(mut self, input: crate::model::UpdateActionStatus) -> Self {
            let mut v = self.update_action_status.unwrap_or_default();
            v.push(input);
            self.update_action_status = Some(v);
            self
        }
        /// <p>The status of the update action.</p>
        pub fn set_update_action_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateActionStatus>>,
        ) -> Self {
            self.update_action_status = input;
            self
        }
        /// <p>Dictates whether to include node level update status in the response </p>
        pub fn show_node_level_update_status(mut self, input: bool) -> Self {
            self.show_node_level_update_status = Some(input);
            self
        }
        /// <p>Dictates whether to include node level update status in the response </p>
        pub fn set_show_node_level_update_status(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.show_node_level_update_status = input;
            self
        }
        /// <p>The maximum number of records to include in the response</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUpdateActionsInput`](crate::input::DescribeUpdateActionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUpdateActionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUpdateActionsInput {
                service_update_name: self.service_update_name,
                replication_group_ids: self.replication_group_ids,
                cache_cluster_ids: self.cache_cluster_ids,
                engine: self.engine,
                service_update_status: self.service_update_status,
                service_update_time_range: self.service_update_time_range,
                update_action_status: self.update_action_status,
                show_node_level_update_status: self.show_node_level_update_status,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUpdateActionsInputOperationOutputAlias = crate::operation::DescribeUpdateActions;
#[doc(hidden)]
pub type DescribeUpdateActionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUpdateActionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUpdateActions`](crate::operation::DescribeUpdateActions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUpdateActions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUpdateActionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUpdateActionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUpdateActionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_update_actions(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUpdateActions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUpdateActions",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUpdateActionsInput`](crate::input::DescribeUpdateActionsInput)
    pub fn builder() -> crate::input::describe_update_actions_input::Builder {
        crate::input::describe_update_actions_input::Builder::default()
    }
}

/// See [`DescribeUserGroupsInput`](crate::input::DescribeUserGroupsInput)
pub mod describe_user_groups_input {
    /// A builder for [`DescribeUserGroupsInput`](crate::input::DescribeUserGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_group_id: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user group.</p>
        pub fn user_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the user group.</p>
        pub fn set_user_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_group_id = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserGroupsInput`](crate::input::DescribeUserGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserGroupsInput {
                user_group_id: self.user_group_id,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserGroupsInputOperationOutputAlias = crate::operation::DescribeUserGroups;
#[doc(hidden)]
pub type DescribeUserGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUserGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUserGroups`](crate::operation::DescribeUserGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUserGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUserGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUserGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUserGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_user_groups(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUserGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUserGroups",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserGroupsInput`](crate::input::DescribeUserGroupsInput)
    pub fn builder() -> crate::input::describe_user_groups_input::Builder {
        crate::input::describe_user_groups_input::Builder::default()
    }
}

/// See [`DescribeUsersInput`](crate::input::DescribeUsersInput)
pub mod describe_users_input {
    /// A builder for [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Redis engine. </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The Redis engine. </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filter to determine the list of User IDs to return.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Filter to determine the list of User IDs to return.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUsersInput`](crate::input::DescribeUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUsersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUsersInput {
                engine: self.engine,
                user_id: self.user_id,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUsersInputOperationOutputAlias = crate::operation::DescribeUsers;
#[doc(hidden)]
pub type DescribeUsersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUsersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUsers`](crate::operation::DescribeUsers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUsers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_users(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUsers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUsers",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    pub fn builder() -> crate::input::describe_users_input::Builder {
        crate::input::describe_users_input::Builder::default()
    }
}

/// See [`DisassociateGlobalReplicationGroupInput`](crate::input::DisassociateGlobalReplicationGroupInput)
pub mod disassociate_global_replication_group_input {
    /// A builder for [`DisassociateGlobalReplicationGroupInput`](crate::input::DisassociateGlobalReplicationGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group_id: std::option::Option<std::string::String>,
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) replication_group_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = input;
            self
        }
        /// <p>The name of the secondary cluster you wish to remove from the Global datastore</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the secondary cluster you wish to remove from the Global datastore</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The Amazon region of secondary cluster you wish to remove from the Global datastore</p>
        pub fn replication_group_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_region = Some(input.into());
            self
        }
        /// <p>The Amazon region of secondary cluster you wish to remove from the Global datastore</p>
        pub fn set_replication_group_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_region = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateGlobalReplicationGroupInput`](crate::input::DisassociateGlobalReplicationGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateGlobalReplicationGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateGlobalReplicationGroupInput {
                global_replication_group_id: self.global_replication_group_id,
                replication_group_id: self.replication_group_id,
                replication_group_region: self.replication_group_region,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateGlobalReplicationGroupInputOperationOutputAlias =
    crate::operation::DisassociateGlobalReplicationGroup;
#[doc(hidden)]
pub type DisassociateGlobalReplicationGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateGlobalReplicationGroupInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateGlobalReplicationGroup`](crate::operation::DisassociateGlobalReplicationGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateGlobalReplicationGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateGlobalReplicationGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateGlobalReplicationGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateGlobalReplicationGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disassociate_global_replication_group(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateGlobalReplicationGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateGlobalReplicationGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateGlobalReplicationGroupInput`](crate::input::DisassociateGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::disassociate_global_replication_group_input::Builder {
        crate::input::disassociate_global_replication_group_input::Builder::default()
    }
}

/// See [`FailoverGlobalReplicationGroupInput`](crate::input::FailoverGlobalReplicationGroupInput)
pub mod failover_global_replication_group_input {
    /// A builder for [`FailoverGlobalReplicationGroupInput`](crate::input::FailoverGlobalReplicationGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group_id: std::option::Option<std::string::String>,
        pub(crate) primary_region: std::option::Option<std::string::String>,
        pub(crate) primary_replication_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = input;
            self
        }
        /// <p>The Amazon region of the primary cluster of the Global datastore</p>
        pub fn primary_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_region = Some(input.into());
            self
        }
        /// <p>The Amazon region of the primary cluster of the Global datastore</p>
        pub fn set_primary_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_region = input;
            self
        }
        /// <p>The name of the primary replication group</p>
        pub fn primary_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.primary_replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the primary replication group</p>
        pub fn set_primary_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_replication_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`FailoverGlobalReplicationGroupInput`](crate::input::FailoverGlobalReplicationGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::FailoverGlobalReplicationGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::FailoverGlobalReplicationGroupInput {
                global_replication_group_id: self.global_replication_group_id,
                primary_region: self.primary_region,
                primary_replication_group_id: self.primary_replication_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type FailoverGlobalReplicationGroupInputOperationOutputAlias =
    crate::operation::FailoverGlobalReplicationGroup;
#[doc(hidden)]
pub type FailoverGlobalReplicationGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl FailoverGlobalReplicationGroupInput {
    /// Consumes the builder and constructs an Operation<[`FailoverGlobalReplicationGroup`](crate::operation::FailoverGlobalReplicationGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::FailoverGlobalReplicationGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::FailoverGlobalReplicationGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::FailoverGlobalReplicationGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::FailoverGlobalReplicationGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_failover_global_replication_group(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::FailoverGlobalReplicationGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "FailoverGlobalReplicationGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`FailoverGlobalReplicationGroupInput`](crate::input::FailoverGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::failover_global_replication_group_input::Builder {
        crate::input::failover_global_replication_group_input::Builder::default()
    }
}

/// See [`IncreaseNodeGroupsInGlobalReplicationGroupInput`](crate::input::IncreaseNodeGroupsInGlobalReplicationGroupInput)
pub mod increase_node_groups_in_global_replication_group_input {
    /// A builder for [`IncreaseNodeGroupsInGlobalReplicationGroupInput`](crate::input::IncreaseNodeGroupsInGlobalReplicationGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group_id: std::option::Option<std::string::String>,
        pub(crate) node_group_count: std::option::Option<i32>,
        pub(crate) regional_configurations:
            std::option::Option<std::vec::Vec<crate::model::RegionalConfiguration>>,
        pub(crate) apply_immediately: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = input;
            self
        }
        /// <p>The number of node groups you wish to add</p>
        pub fn node_group_count(mut self, input: i32) -> Self {
            self.node_group_count = Some(input);
            self
        }
        /// <p>The number of node groups you wish to add</p>
        pub fn set_node_group_count(mut self, input: std::option::Option<i32>) -> Self {
            self.node_group_count = input;
            self
        }
        /// Appends an item to `regional_configurations`.
        ///
        /// To override the contents of this collection use [`set_regional_configurations`](Self::set_regional_configurations).
        ///
        /// <p>Describes the replication group IDs, the Amazon regions where they are stored and the shard configuration for each that comprise the Global datastore</p>
        pub fn regional_configurations(
            mut self,
            input: crate::model::RegionalConfiguration,
        ) -> Self {
            let mut v = self.regional_configurations.unwrap_or_default();
            v.push(input);
            self.regional_configurations = Some(v);
            self
        }
        /// <p>Describes the replication group IDs, the Amazon regions where they are stored and the shard configuration for each that comprise the Global datastore</p>
        pub fn set_regional_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegionalConfiguration>>,
        ) -> Self {
            self.regional_configurations = input;
            self
        }
        /// <p>Indicates that the process begins immediately. At present, the only permitted value for this parameter is true.</p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>Indicates that the process begins immediately. At present, the only permitted value for this parameter is true.</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// Consumes the builder and constructs a [`IncreaseNodeGroupsInGlobalReplicationGroupInput`](crate::input::IncreaseNodeGroupsInGlobalReplicationGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::IncreaseNodeGroupsInGlobalReplicationGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::IncreaseNodeGroupsInGlobalReplicationGroupInput {
                    global_replication_group_id: self.global_replication_group_id,
                    node_group_count: self.node_group_count.unwrap_or_default(),
                    regional_configurations: self.regional_configurations,
                    apply_immediately: self.apply_immediately.unwrap_or_default(),
                },
            )
        }
    }
}
#[doc(hidden)]
pub type IncreaseNodeGroupsInGlobalReplicationGroupInputOperationOutputAlias =
    crate::operation::IncreaseNodeGroupsInGlobalReplicationGroup;
#[doc(hidden)]
pub type IncreaseNodeGroupsInGlobalReplicationGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl IncreaseNodeGroupsInGlobalReplicationGroupInput {
    /// Consumes the builder and constructs an Operation<[`IncreaseNodeGroupsInGlobalReplicationGroup`](crate::operation::IncreaseNodeGroupsInGlobalReplicationGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::IncreaseNodeGroupsInGlobalReplicationGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::IncreaseNodeGroupsInGlobalReplicationGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::IncreaseNodeGroupsInGlobalReplicationGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::IncreaseNodeGroupsInGlobalReplicationGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_increase_node_groups_in_global_replication_group(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::IncreaseNodeGroupsInGlobalReplicationGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "IncreaseNodeGroupsInGlobalReplicationGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`IncreaseNodeGroupsInGlobalReplicationGroupInput`](crate::input::IncreaseNodeGroupsInGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::increase_node_groups_in_global_replication_group_input::Builder
    {
        crate::input::increase_node_groups_in_global_replication_group_input::Builder::default()
    }
}

/// See [`IncreaseReplicaCountInput`](crate::input::IncreaseReplicaCountInput)
pub mod increase_replica_count_input {
    /// A builder for [`IncreaseReplicaCountInput`](crate::input::IncreaseReplicaCountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) new_replica_count: std::option::Option<i32>,
        pub(crate) replica_configuration:
            std::option::Option<std::vec::Vec<crate::model::ConfigureShard>>,
        pub(crate) apply_immediately: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The id of the replication group to which you want to add replica nodes.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The id of the replication group to which you want to add replica nodes.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>
        pub fn new_replica_count(mut self, input: i32) -> Self {
            self.new_replica_count = Some(input);
            self
        }
        /// <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>
        pub fn set_new_replica_count(mut self, input: std::option::Option<i32>) -> Self {
            self.new_replica_count = input;
            self
        }
        /// Appends an item to `replica_configuration`.
        ///
        /// To override the contents of this collection use [`set_replica_configuration`](Self::set_replica_configuration).
        ///
        /// <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
        pub fn replica_configuration(mut self, input: crate::model::ConfigureShard) -> Self {
            let mut v = self.replica_configuration.unwrap_or_default();
            v.push(input);
            self.replica_configuration = Some(v);
            self
        }
        /// <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
        pub fn set_replica_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigureShard>>,
        ) -> Self {
            self.replica_configuration = input;
            self
        }
        /// <p>If <code>True</code>, the number of replica nodes is increased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>If <code>True</code>, the number of replica nodes is increased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// Consumes the builder and constructs a [`IncreaseReplicaCountInput`](crate::input::IncreaseReplicaCountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::IncreaseReplicaCountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::IncreaseReplicaCountInput {
                replication_group_id: self.replication_group_id,
                new_replica_count: self.new_replica_count,
                replica_configuration: self.replica_configuration,
                apply_immediately: self.apply_immediately.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type IncreaseReplicaCountInputOperationOutputAlias = crate::operation::IncreaseReplicaCount;
#[doc(hidden)]
pub type IncreaseReplicaCountInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl IncreaseReplicaCountInput {
    /// Consumes the builder and constructs an Operation<[`IncreaseReplicaCount`](crate::operation::IncreaseReplicaCount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::IncreaseReplicaCount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::IncreaseReplicaCountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::IncreaseReplicaCountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::IncreaseReplicaCountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_increase_replica_count(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::IncreaseReplicaCount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "IncreaseReplicaCount",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`IncreaseReplicaCountInput`](crate::input::IncreaseReplicaCountInput)
    pub fn builder() -> crate::input::increase_replica_count_input::Builder {
        crate::input::increase_replica_count_input::Builder::default()
    }
}

/// See [`ListAllowedNodeTypeModificationsInput`](crate::input::ListAllowedNodeTypeModificationsInput)
pub mod list_allowed_node_type_modifications_input {
    /// A builder for [`ListAllowedNodeTypeModificationsInput`](crate::input::ListAllowedNodeTypeModificationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster you want to scale up to a larger node instanced type. ElastiCache uses the cluster id to identify the current node type of this cluster and from that to create a list of node types you can scale up to.</p> <important>
        /// <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>
        /// </important>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The name of the cluster you want to scale up to a larger node instanced type. ElastiCache uses the cluster id to identify the current node type of this cluster and from that to create a list of node types you can scale up to.</p> <important>
        /// <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>
        /// </important>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>The name of the replication group want to scale up to a larger node type. ElastiCache uses the replication group id to identify the current node type being used by this replication group, and from that to create a list of node types you can scale up to.</p> <important>
        /// <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>
        /// </important>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the replication group want to scale up to a larger node type. ElastiCache uses the replication group id to identify the current node type being used by this replication group, and from that to create a list of node types you can scale up to.</p> <important>
        /// <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>
        /// </important>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAllowedNodeTypeModificationsInput`](crate::input::ListAllowedNodeTypeModificationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAllowedNodeTypeModificationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAllowedNodeTypeModificationsInput {
                cache_cluster_id: self.cache_cluster_id,
                replication_group_id: self.replication_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAllowedNodeTypeModificationsInputOperationOutputAlias =
    crate::operation::ListAllowedNodeTypeModifications;
#[doc(hidden)]
pub type ListAllowedNodeTypeModificationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListAllowedNodeTypeModificationsInput {
    /// Consumes the builder and constructs an Operation<[`ListAllowedNodeTypeModifications`](crate::operation::ListAllowedNodeTypeModifications)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAllowedNodeTypeModifications,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAllowedNodeTypeModificationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAllowedNodeTypeModificationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAllowedNodeTypeModificationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_allowed_node_type_modifications(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAllowedNodeTypeModifications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAllowedNodeTypeModifications",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAllowedNodeTypeModificationsInput`](crate::input::ListAllowedNodeTypeModificationsInput)
    pub fn builder() -> crate::input::list_allowed_node_type_modifications_input::Builder {
        crate::input::list_allowed_node_type_modifications_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ModifyCacheClusterInput`](crate::input::ModifyCacheClusterInput)
pub mod modify_cache_cluster_input {
    /// A builder for [`ModifyCacheClusterInput`](crate::input::ModifyCacheClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) num_cache_nodes: std::option::Option<i32>,
        pub(crate) cache_node_ids_to_remove:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) az_mode: std::option::Option<crate::model::AzMode>,
        pub(crate) new_availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cache_security_group_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) notification_topic_arn: std::option::Option<std::string::String>,
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) notification_topic_status: std::option::Option<std::string::String>,
        pub(crate) apply_immediately: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) snapshot_retention_limit: std::option::Option<i32>,
        pub(crate) snapshot_window: std::option::Option<std::string::String>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) auth_token: std::option::Option<std::string::String>,
        pub(crate) auth_token_update_strategy:
            std::option::Option<crate::model::AuthTokenUpdateStrategyType>,
        pub(crate) log_delivery_configurations:
            std::option::Option<std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>>,
    }
    impl Builder {
        /// <p>The cluster identifier. This value is stored as a lowercase string.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The cluster identifier. This value is stored as a lowercase string.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>The number of cache nodes that the cluster should have. If the value for <code>NumCacheNodes</code> is greater than the sum of the number of current cache nodes and the number of cache nodes pending creation (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes, nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove requests are canceled.</p>
        /// <p>If you are removing cache nodes, you must use the <code>CacheNodeIdsToRemove</code> parameter to provide the IDs of the specific cache nodes to remove.</p>
        /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p> <note>
        /// <p>Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see <code>ApplyImmediately</code>).</p>
        /// <p>A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The customer's latest request to add or remove nodes to the cluster overrides any previous pending operations to modify the number of cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache nodes may now be provisioned in different Availability Zones with flexible cache node placement, a request to add nodes does not automatically override a previous pending operation to add nodes. The customer can modify the previous pending operation to add more nodes or explicitly cancel the pending request and retry the new request. To cancel pending operations to modify the number of cache nodes in a cluster, use the <code>ModifyCacheCluster</code> request and set <code>NumCacheNodes</code> equal to the number of cache nodes currently in the cluster.</p>
        /// </note>
        pub fn num_cache_nodes(mut self, input: i32) -> Self {
            self.num_cache_nodes = Some(input);
            self
        }
        /// <p>The number of cache nodes that the cluster should have. If the value for <code>NumCacheNodes</code> is greater than the sum of the number of current cache nodes and the number of cache nodes pending creation (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes, nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove requests are canceled.</p>
        /// <p>If you are removing cache nodes, you must use the <code>CacheNodeIdsToRemove</code> parameter to provide the IDs of the specific cache nodes to remove.</p>
        /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p> <note>
        /// <p>Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see <code>ApplyImmediately</code>).</p>
        /// <p>A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The customer's latest request to add or remove nodes to the cluster overrides any previous pending operations to modify the number of cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache nodes may now be provisioned in different Availability Zones with flexible cache node placement, a request to add nodes does not automatically override a previous pending operation to add nodes. The customer can modify the previous pending operation to add more nodes or explicitly cancel the pending request and retry the new request. To cancel pending operations to modify the number of cache nodes in a cluster, use the <code>ModifyCacheCluster</code> request and set <code>NumCacheNodes</code> equal to the number of cache nodes currently in the cluster.</p>
        /// </note>
        pub fn set_num_cache_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.num_cache_nodes = input;
            self
        }
        /// Appends an item to `cache_node_ids_to_remove`.
        ///
        /// To override the contents of this collection use [`set_cache_node_ids_to_remove`](Self::set_cache_node_ids_to_remove).
        ///
        /// <p>A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter is only valid when <code>NumCacheNodes</code> is less than the existing number of cache nodes. The number of cache node IDs supplied in this parameter must match the difference between the existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the value of <code>NumCacheNodes</code> in the request.</p>
        /// <p>For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.</p>
        pub fn cache_node_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_node_ids_to_remove.unwrap_or_default();
            v.push(input.into());
            self.cache_node_ids_to_remove = Some(v);
            self
        }
        /// <p>A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter is only valid when <code>NumCacheNodes</code> is less than the existing number of cache nodes. The number of cache node IDs supplied in this parameter must match the difference between the existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the value of <code>NumCacheNodes</code> in the request.</p>
        /// <p>For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.</p>
        pub fn set_cache_node_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_node_ids_to_remove = input;
            self
        }
        /// <p>Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or created across multiple Availability Zones.</p>
        /// <p>Valid values: <code>single-az</code> | <code>cross-az</code>.</p>
        /// <p>This option is only supported for Memcached clusters.</p> <note>
        /// <p>You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone.</p>
        /// <p>Only newly created nodes are located in different Availability Zones. </p>
        /// </note>
        pub fn az_mode(mut self, input: crate::model::AzMode) -> Self {
            self.az_mode = Some(input);
            self
        }
        /// <p>Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or created across multiple Availability Zones.</p>
        /// <p>Valid values: <code>single-az</code> | <code>cross-az</code>.</p>
        /// <p>This option is only supported for Memcached clusters.</p> <note>
        /// <p>You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone.</p>
        /// <p>Only newly created nodes are located in different Availability Zones. </p>
        /// </note>
        pub fn set_az_mode(mut self, input: std::option::Option<crate::model::AzMode>) -> Self {
            self.az_mode = input;
            self
        }
        /// Appends an item to `new_availability_zones`.
        ///
        /// To override the contents of this collection use [`set_new_availability_zones`](Self::set_new_availability_zones).
        ///
        /// <note>
        /// <p>This option is only supported on Memcached clusters.</p>
        /// </note>
        /// <p>The list of Availability Zones where the new Memcached cache nodes are created.</p>
        /// <p>This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of the number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number of Availability Zones supplied in this list must match the cache nodes being added in this request.</p>
        /// <p>Scenarios:</p>
        /// <ul>
        /// <li> <p> <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify <code>NumCacheNodes=5</code> (3 + 2) and optionally specify two Availability Zones for the two new nodes.</p> </li>
        /// <li> <p> <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an Availability Zone for the new node.</p> </li>
        /// <li> <p> <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to cancel all pending operations.</p> </li>
        /// </ul>
        /// <p>The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current nodes.</p>
        /// <p>If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing Memcached nodes to different Availability Zones, see the <b>Availability Zone Considerations</b> section of <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html">Cache Node Considerations for Memcached</a>.</p>
        /// <p> <b>Impact of new add/remove requests upon pending requests</b> </p>
        /// <ul>
        /// <li> <p>Scenario-1</p>
        /// <ul>
        /// <li> <p>Pending Action: Delete</p> </li>
        /// <li> <p>New Request: Delete</p> </li>
        /// <li> <p>Result: The new delete, pending or immediate, replaces the pending delete.</p> </li>
        /// </ul> </li>
        /// <li> <p>Scenario-2</p>
        /// <ul>
        /// <li> <p>Pending Action: Delete</p> </li>
        /// <li> <p>New Request: Create</p> </li>
        /// <li> <p>Result: The new create, pending or immediate, replaces the pending delete.</p> </li>
        /// </ul> </li>
        /// <li> <p>Scenario-3</p>
        /// <ul>
        /// <li> <p>Pending Action: Create</p> </li>
        /// <li> <p>New Request: Delete</p> </li>
        /// <li> <p>Result: The new delete, pending or immediate, replaces the pending create.</p> </li>
        /// </ul> </li>
        /// <li> <p>Scenario-4</p>
        /// <ul>
        /// <li> <p>Pending Action: Create</p> </li>
        /// <li> <p>New Request: Create</p> </li>
        /// <li> <p>Result: The new create is added to the pending create.</p> <important>
        /// <p> <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are performed immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are pending.</p>
        /// </important> </li>
        /// </ul> </li>
        /// </ul>
        pub fn new_availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.new_availability_zones.unwrap_or_default();
            v.push(input.into());
            self.new_availability_zones = Some(v);
            self
        }
        /// <note>
        /// <p>This option is only supported on Memcached clusters.</p>
        /// </note>
        /// <p>The list of Availability Zones where the new Memcached cache nodes are created.</p>
        /// <p>This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of the number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number of Availability Zones supplied in this list must match the cache nodes being added in this request.</p>
        /// <p>Scenarios:</p>
        /// <ul>
        /// <li> <p> <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify <code>NumCacheNodes=5</code> (3 + 2) and optionally specify two Availability Zones for the two new nodes.</p> </li>
        /// <li> <p> <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an Availability Zone for the new node.</p> </li>
        /// <li> <p> <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to cancel all pending operations.</p> </li>
        /// </ul>
        /// <p>The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current nodes.</p>
        /// <p>If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing Memcached nodes to different Availability Zones, see the <b>Availability Zone Considerations</b> section of <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html">Cache Node Considerations for Memcached</a>.</p>
        /// <p> <b>Impact of new add/remove requests upon pending requests</b> </p>
        /// <ul>
        /// <li> <p>Scenario-1</p>
        /// <ul>
        /// <li> <p>Pending Action: Delete</p> </li>
        /// <li> <p>New Request: Delete</p> </li>
        /// <li> <p>Result: The new delete, pending or immediate, replaces the pending delete.</p> </li>
        /// </ul> </li>
        /// <li> <p>Scenario-2</p>
        /// <ul>
        /// <li> <p>Pending Action: Delete</p> </li>
        /// <li> <p>New Request: Create</p> </li>
        /// <li> <p>Result: The new create, pending or immediate, replaces the pending delete.</p> </li>
        /// </ul> </li>
        /// <li> <p>Scenario-3</p>
        /// <ul>
        /// <li> <p>Pending Action: Create</p> </li>
        /// <li> <p>New Request: Delete</p> </li>
        /// <li> <p>Result: The new delete, pending or immediate, replaces the pending create.</p> </li>
        /// </ul> </li>
        /// <li> <p>Scenario-4</p>
        /// <ul>
        /// <li> <p>Pending Action: Create</p> </li>
        /// <li> <p>New Request: Create</p> </li>
        /// <li> <p>Result: The new create is added to the pending create.</p> <important>
        /// <p> <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are performed immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are pending.</p>
        /// </important> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_new_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.new_availability_zones = input;
            self
        }
        /// Appends an item to `cache_security_group_names`.
        ///
        /// To override the contents of this collection use [`set_cache_security_group_names`](Self::set_cache_security_group_names).
        ///
        /// <p>A list of cache security group names to authorize on this cluster. This change is asynchronously applied as soon as possible.</p>
        /// <p>You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".</p>
        pub fn cache_security_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_security_group_names.unwrap_or_default();
            v.push(input.into());
            self.cache_security_group_names = Some(v);
            self
        }
        /// <p>A list of cache security group names to authorize on this cluster. This change is asynchronously applied as soon as possible.</p>
        /// <p>You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".</p>
        pub fn set_cache_security_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_security_group_names = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>Specifies the VPC Security Groups associated with the cluster.</p>
        /// <p>This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>Specifies the VPC Security Groups associated with the cluster.</p>
        /// <p>This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be same as the cluster owner.</p>
        /// </note>
        pub fn notification_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be same as the cluster owner.</p>
        /// </note>
        pub fn set_notification_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_topic_arn = input;
            self
        }
        /// <p>The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is <code>active</code>.</p>
        /// <p>Valid values: <code>active</code> | <code>inactive</code> </p>
        pub fn notification_topic_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_topic_status = Some(input.into());
            self
        }
        /// <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is <code>active</code>.</p>
        /// <p>Valid values: <code>active</code> | <code>inactive</code> </p>
        pub fn set_notification_topic_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_topic_status = input;
            self
        }
        /// <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the cluster.</p>
        /// <p>If <code>false</code>, changes to the cluster are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p> <important>
        /// <p>If you perform a <code>ModifyCacheCluster</code> before a pending modification is applied, the pending modification is replaced by the newer modification.</p>
        /// </important>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        /// <p>Default: <code>false</code> </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the cluster.</p>
        /// <p>If <code>false</code>, changes to the cluster are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p> <important>
        /// <p>If you perform a <code>ModifyCacheCluster</code> before a pending modification is applied, the pending modification is replaced by the newer modification.</p>
        /// </important>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// <p>The upgraded version of the cache engine to be run on the cache nodes.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The upgraded version of the cache engine to be run on the cache nodes.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <note>
        /// <p>If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p>
        /// </note>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.snapshot_retention_limit = Some(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <note>
        /// <p>If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p>
        /// </note>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.snapshot_retention_limit = input;
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster. </p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_window = Some(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster. </p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_window = input;
            self
        }
        /// <p>A valid cache node type that you want to scale this cluster up to.</p>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>A valid cache node type that you want to scale this cluster up to.</p>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update</code> parameter. Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>
        /// <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>
        /// </ul>
        /// <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
        pub fn auth_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_token = Some(input.into());
            self
        }
        /// <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update</code> parameter. Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>
        /// <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>
        /// </ul>
        /// <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
        pub fn set_auth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_token = input;
            self
        }
        /// <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>
        /// <ul>
        /// <li> <p>Rotate</p> </li>
        /// <li> <p>Set</p> </li>
        /// </ul>
        /// <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
        pub fn auth_token_update_strategy(
            mut self,
            input: crate::model::AuthTokenUpdateStrategyType,
        ) -> Self {
            self.auth_token_update_strategy = Some(input);
            self
        }
        /// <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>
        /// <ul>
        /// <li> <p>Rotate</p> </li>
        /// <li> <p>Set</p> </li>
        /// </ul>
        /// <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
        pub fn set_auth_token_update_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthTokenUpdateStrategyType>,
        ) -> Self {
            self.auth_token_update_strategy = input;
            self
        }
        /// Appends an item to `log_delivery_configurations`.
        ///
        /// To override the contents of this collection use [`set_log_delivery_configurations`](Self::set_log_delivery_configurations).
        ///
        /// <p>Specifies the destination, format and type of the logs.</p>
        pub fn log_delivery_configurations(
            mut self,
            input: crate::model::LogDeliveryConfigurationRequest,
        ) -> Self {
            let mut v = self.log_delivery_configurations.unwrap_or_default();
            v.push(input);
            self.log_delivery_configurations = Some(v);
            self
        }
        /// <p>Specifies the destination, format and type of the logs.</p>
        pub fn set_log_delivery_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>,
            >,
        ) -> Self {
            self.log_delivery_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyCacheClusterInput`](crate::input::ModifyCacheClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyCacheClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyCacheClusterInput {
                cache_cluster_id: self.cache_cluster_id,
                num_cache_nodes: self.num_cache_nodes,
                cache_node_ids_to_remove: self.cache_node_ids_to_remove,
                az_mode: self.az_mode,
                new_availability_zones: self.new_availability_zones,
                cache_security_group_names: self.cache_security_group_names,
                security_group_ids: self.security_group_ids,
                preferred_maintenance_window: self.preferred_maintenance_window,
                notification_topic_arn: self.notification_topic_arn,
                cache_parameter_group_name: self.cache_parameter_group_name,
                notification_topic_status: self.notification_topic_status,
                apply_immediately: self.apply_immediately.unwrap_or_default(),
                engine_version: self.engine_version,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
                snapshot_retention_limit: self.snapshot_retention_limit,
                snapshot_window: self.snapshot_window,
                cache_node_type: self.cache_node_type,
                auth_token: self.auth_token,
                auth_token_update_strategy: self.auth_token_update_strategy,
                log_delivery_configurations: self.log_delivery_configurations,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyCacheClusterInputOperationOutputAlias = crate::operation::ModifyCacheCluster;
#[doc(hidden)]
pub type ModifyCacheClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ModifyCacheClusterInput {
    /// Consumes the builder and constructs an Operation<[`ModifyCacheCluster`](crate::operation::ModifyCacheCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyCacheCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyCacheClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyCacheClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyCacheClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_modify_cache_cluster(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyCacheCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyCacheCluster",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyCacheClusterInput`](crate::input::ModifyCacheClusterInput)
    pub fn builder() -> crate::input::modify_cache_cluster_input::Builder {
        crate::input::modify_cache_cluster_input::Builder::default()
    }
}

/// See [`ModifyCacheParameterGroupInput`](crate::input::ModifyCacheParameterGroupInput)
pub mod modify_cache_parameter_group_input {
    /// A builder for [`ModifyCacheParameterGroupInput`](crate::input::ModifyCacheParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameter_name_values:
            std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
    }
    impl Builder {
        /// <p>The name of the cache parameter group to modify.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group to modify.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// Appends an item to `parameter_name_values`.
        ///
        /// To override the contents of this collection use [`set_parameter_name_values`](Self::set_parameter_name_values).
        ///
        /// <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.</p>
        pub fn parameter_name_values(mut self, input: crate::model::ParameterNameValue) -> Self {
            let mut v = self.parameter_name_values.unwrap_or_default();
            v.push(input);
            self.parameter_name_values = Some(v);
            self
        }
        /// <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.</p>
        pub fn set_parameter_name_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
        ) -> Self {
            self.parameter_name_values = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyCacheParameterGroupInput`](crate::input::ModifyCacheParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyCacheParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyCacheParameterGroupInput {
                cache_parameter_group_name: self.cache_parameter_group_name,
                parameter_name_values: self.parameter_name_values,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyCacheParameterGroupInputOperationOutputAlias =
    crate::operation::ModifyCacheParameterGroup;
#[doc(hidden)]
pub type ModifyCacheParameterGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ModifyCacheParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyCacheParameterGroup`](crate::operation::ModifyCacheParameterGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyCacheParameterGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyCacheParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyCacheParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyCacheParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_modify_cache_parameter_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyCacheParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyCacheParameterGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyCacheParameterGroupInput`](crate::input::ModifyCacheParameterGroupInput)
    pub fn builder() -> crate::input::modify_cache_parameter_group_input::Builder {
        crate::input::modify_cache_parameter_group_input::Builder::default()
    }
}

/// See [`ModifyCacheSubnetGroupInput`](crate::input::ModifyCacheSubnetGroupInput)
pub mod modify_cache_subnet_group_input {
    /// A builder for [`ModifyCacheSubnetGroupInput`](crate::input::ModifyCacheSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) cache_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name for the cache subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// <p>Example: <code>mysubnetgroup</code> </p>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name for the cache subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// <p>Example: <code>mysubnetgroup</code> </p>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_name = input;
            self
        }
        /// <p>A description of the cache subnet group.</p>
        pub fn cache_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_description = Some(input.into());
            self
        }
        /// <p>A description of the cache subnet group.</p>
        pub fn set_cache_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The EC2 subnet IDs for the cache subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The EC2 subnet IDs for the cache subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyCacheSubnetGroupInput`](crate::input::ModifyCacheSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyCacheSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyCacheSubnetGroupInput {
                cache_subnet_group_name: self.cache_subnet_group_name,
                cache_subnet_group_description: self.cache_subnet_group_description,
                subnet_ids: self.subnet_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyCacheSubnetGroupInputOperationOutputAlias = crate::operation::ModifyCacheSubnetGroup;
#[doc(hidden)]
pub type ModifyCacheSubnetGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ModifyCacheSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyCacheSubnetGroup`](crate::operation::ModifyCacheSubnetGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyCacheSubnetGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyCacheSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyCacheSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyCacheSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_modify_cache_subnet_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyCacheSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyCacheSubnetGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyCacheSubnetGroupInput`](crate::input::ModifyCacheSubnetGroupInput)
    pub fn builder() -> crate::input::modify_cache_subnet_group_input::Builder {
        crate::input::modify_cache_subnet_group_input::Builder::default()
    }
}

/// See [`ModifyGlobalReplicationGroupInput`](crate::input::ModifyGlobalReplicationGroupInput)
pub mod modify_global_replication_group_input {
    /// A builder for [`ModifyGlobalReplicationGroupInput`](crate::input::ModifyGlobalReplicationGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group_id: std::option::Option<std::string::String>,
        pub(crate) apply_immediately: std::option::Option<bool>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) global_replication_group_description: std::option::Option<std::string::String>,
        pub(crate) automatic_failover_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = input;
            self
        }
        /// <p>This parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to be applied in PreferredMaintenceWindow. </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>This parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to be applied in PreferredMaintenceWindow. </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// <p>A valid cache node type that you want to scale this Global datastore to.</p>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>A valid cache node type that you want to scale this Global datastore to.</p>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>The upgraded version of the cache engine to be run on the clusters in the Global datastore. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The upgraded version of the cache engine to be run on the clusters in the Global datastore. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of the cache parameter group to use with the Global datastore. It must be compatible with the major engine version used by the Global datastore.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group to use with the Global datastore. It must be compatible with the major engine version used by the Global datastore.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// <p>A description of the Global datastore</p>
        pub fn global_replication_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_description = Some(input.into());
            self
        }
        /// <p>A description of the Global datastore</p>
        pub fn set_global_replication_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_description = input;
            self
        }
        /// <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure. </p>
        pub fn automatic_failover_enabled(mut self, input: bool) -> Self {
            self.automatic_failover_enabled = Some(input);
            self
        }
        /// <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure. </p>
        pub fn set_automatic_failover_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.automatic_failover_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyGlobalReplicationGroupInput`](crate::input::ModifyGlobalReplicationGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyGlobalReplicationGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyGlobalReplicationGroupInput {
                global_replication_group_id: self.global_replication_group_id,
                apply_immediately: self.apply_immediately.unwrap_or_default(),
                cache_node_type: self.cache_node_type,
                engine_version: self.engine_version,
                cache_parameter_group_name: self.cache_parameter_group_name,
                global_replication_group_description: self.global_replication_group_description,
                automatic_failover_enabled: self.automatic_failover_enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyGlobalReplicationGroupInputOperationOutputAlias =
    crate::operation::ModifyGlobalReplicationGroup;
#[doc(hidden)]
pub type ModifyGlobalReplicationGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ModifyGlobalReplicationGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyGlobalReplicationGroup`](crate::operation::ModifyGlobalReplicationGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyGlobalReplicationGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyGlobalReplicationGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyGlobalReplicationGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyGlobalReplicationGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_modify_global_replication_group(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyGlobalReplicationGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyGlobalReplicationGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyGlobalReplicationGroupInput`](crate::input::ModifyGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::modify_global_replication_group_input::Builder {
        crate::input::modify_global_replication_group_input::Builder::default()
    }
}

/// See [`ModifyReplicationGroupInput`](crate::input::ModifyReplicationGroupInput)
pub mod modify_replication_group_input {
    /// A builder for [`ModifyReplicationGroupInput`](crate::input::ModifyReplicationGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) replication_group_description: std::option::Option<std::string::String>,
        pub(crate) primary_cluster_id: std::option::Option<std::string::String>,
        pub(crate) snapshotting_cluster_id: std::option::Option<std::string::String>,
        pub(crate) automatic_failover_enabled: std::option::Option<bool>,
        pub(crate) multi_az_enabled: std::option::Option<bool>,
        pub(crate) node_group_id: std::option::Option<std::string::String>,
        pub(crate) cache_security_group_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) notification_topic_arn: std::option::Option<std::string::String>,
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) notification_topic_status: std::option::Option<std::string::String>,
        pub(crate) apply_immediately: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) snapshot_retention_limit: std::option::Option<i32>,
        pub(crate) snapshot_window: std::option::Option<std::string::String>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) auth_token: std::option::Option<std::string::String>,
        pub(crate) auth_token_update_strategy:
            std::option::Option<crate::model::AuthTokenUpdateStrategyType>,
        pub(crate) user_group_ids_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_group_ids_to_remove:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) remove_user_groups: std::option::Option<bool>,
        pub(crate) log_delivery_configurations:
            std::option::Option<std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>>,
    }
    impl Builder {
        /// <p>The identifier of the replication group to modify.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the replication group to modify.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>A description for the replication group. Maximum length is 255 characters.</p>
        pub fn replication_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_group_description = Some(input.into());
            self
        }
        /// <p>A description for the replication group. Maximum length is 255 characters.</p>
        pub fn set_replication_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_description = input;
            self
        }
        /// <p>For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the specified cluster in the specified replication group to the primary role. The nodes of all other clusters in the replication group are read replicas.</p>
        pub fn primary_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_cluster_id = Some(input.into());
            self
        }
        /// <p>For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the specified cluster in the specified replication group to the primary role. The nodes of all other clusters in the replication group are read replicas.</p>
        pub fn set_primary_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_cluster_id = input;
            self
        }
        /// <p>The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be set for Redis (cluster mode enabled) replication groups.</p>
        pub fn snapshotting_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshotting_cluster_id = Some(input.into());
            self
        }
        /// <p>The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be set for Redis (cluster mode enabled) replication groups.</p>
        pub fn set_snapshotting_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshotting_cluster_id = input;
            self
        }
        /// <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure.</p>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        pub fn automatic_failover_enabled(mut self, input: bool) -> Self {
            self.automatic_failover_enabled = Some(input);
            self
        }
        /// <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure.</p>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        pub fn set_automatic_failover_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.automatic_failover_enabled = input;
            self
        }
        /// <p>A flag to indicate MultiAZ is enabled.</p>
        pub fn multi_az_enabled(mut self, input: bool) -> Self {
            self.multi_az_enabled = Some(input);
            self
        }
        /// <p>A flag to indicate MultiAZ is enabled.</p>
        pub fn set_multi_az_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az_enabled = input;
            self
        }
        /// <p>Deprecated. This parameter is not used.</p>
        pub fn node_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_group_id = Some(input.into());
            self
        }
        /// <p>Deprecated. This parameter is not used.</p>
        pub fn set_node_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.node_group_id = input;
            self
        }
        /// Appends an item to `cache_security_group_names`.
        ///
        /// To override the contents of this collection use [`set_cache_security_group_names`](Self::set_cache_security_group_names).
        ///
        /// <p>A list of cache security group names to authorize for the clusters in this replication group. This change is asynchronously applied as soon as possible.</p>
        /// <p>This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.</p>
        pub fn cache_security_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_security_group_names.unwrap_or_default();
            v.push(input.into());
            self.cache_security_group_names = Some(v);
            self
        }
        /// <p>A list of cache security group names to authorize for the clusters in this replication group. This change is asynchronously applied as soon as possible.</p>
        /// <p>This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.</p>
        pub fn set_cache_security_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_security_group_names = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>Specifies the VPC Security Groups associated with the clusters in the replication group.</p>
        /// <p>This parameter can be used only with replication group containing clusters running in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>Specifies the VPC Security Groups associated with the clusters in the replication group.</p>
        /// <p>This parameter can be used only with replication group containing clusters running in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be same as the replication group owner. </p>
        /// </note>
        pub fn notification_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be same as the replication group owner. </p>
        /// </note>
        pub fn set_notification_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_topic_arn = input;
            self
        }
        /// <p>The name of the cache parameter group to apply to all of the clusters in this replication group. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group to apply to all of the clusters in this replication group. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// <p>The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the status is <code>active</code>.</p>
        /// <p>Valid values: <code>active</code> | <code>inactive</code> </p>
        pub fn notification_topic_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_topic_status = Some(input.into());
            self
        }
        /// <p>The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the status is <code>active</code>.</p>
        /// <p>Valid values: <code>active</code> | <code>inactive</code> </p>
        pub fn set_notification_topic_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_topic_status = input;
            self
        }
        /// <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the replication group.</p>
        /// <p>If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        /// <p>Default: <code>false</code> </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the replication group.</p>
        /// <p>If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// <p>The upgraded version of the cache engine to be run on the clusters in the replication group.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing replication group and create it anew with the earlier engine version. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The upgraded version of the cache engine to be run on the clusters in the replication group.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing replication group and create it anew with the earlier engine version. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        /// <p> <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.snapshot_retention_limit = Some(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        /// <p> <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.snapshot_retention_limit = input;
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group (shard) specified by <code>SnapshottingClusterId</code>.</p>
        /// <p>Example: <code>05:00-09:00</code> </p>
        /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_window = Some(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group (shard) specified by <code>SnapshottingClusterId</code>.</p>
        /// <p>Example: <code>05:00-09:00</code> </p>
        /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_window = input;
            self
        }
        /// <p>A valid cache node type that you want to scale this replication group to.</p>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>A valid cache node type that you want to scale this replication group to.</p>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update-strategy </code> parameter. Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>
        /// <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>
        /// </ul>
        /// <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
        pub fn auth_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_token = Some(input.into());
            self
        }
        /// <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update-strategy </code> parameter. Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>
        /// <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>
        /// </ul>
        /// <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
        pub fn set_auth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_token = input;
            self
        }
        /// <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>
        /// <ul>
        /// <li> <p>Rotate</p> </li>
        /// <li> <p>Set</p> </li>
        /// </ul>
        /// <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
        pub fn auth_token_update_strategy(
            mut self,
            input: crate::model::AuthTokenUpdateStrategyType,
        ) -> Self {
            self.auth_token_update_strategy = Some(input);
            self
        }
        /// <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>
        /// <ul>
        /// <li> <p>Rotate</p> </li>
        /// <li> <p>Set</p> </li>
        /// </ul>
        /// <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
        pub fn set_auth_token_update_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthTokenUpdateStrategyType>,
        ) -> Self {
            self.auth_token_update_strategy = input;
            self
        }
        /// Appends an item to `user_group_ids_to_add`.
        ///
        /// To override the contents of this collection use [`set_user_group_ids_to_add`](Self::set_user_group_ids_to_add).
        ///
        /// <p>The ID of the user group you are associating with the replication group.</p>
        pub fn user_group_ids_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_group_ids_to_add.unwrap_or_default();
            v.push(input.into());
            self.user_group_ids_to_add = Some(v);
            self
        }
        /// <p>The ID of the user group you are associating with the replication group.</p>
        pub fn set_user_group_ids_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_group_ids_to_add = input;
            self
        }
        /// Appends an item to `user_group_ids_to_remove`.
        ///
        /// To override the contents of this collection use [`set_user_group_ids_to_remove`](Self::set_user_group_ids_to_remove).
        ///
        /// <p>The ID of the user group to disassociate from the replication group, meaning the users in the group no longer can access the replication group.</p>
        pub fn user_group_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_group_ids_to_remove.unwrap_or_default();
            v.push(input.into());
            self.user_group_ids_to_remove = Some(v);
            self
        }
        /// <p>The ID of the user group to disassociate from the replication group, meaning the users in the group no longer can access the replication group.</p>
        pub fn set_user_group_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_group_ids_to_remove = input;
            self
        }
        /// <p>Removes the user group associated with this replication group.</p>
        pub fn remove_user_groups(mut self, input: bool) -> Self {
            self.remove_user_groups = Some(input);
            self
        }
        /// <p>Removes the user group associated with this replication group.</p>
        pub fn set_remove_user_groups(mut self, input: std::option::Option<bool>) -> Self {
            self.remove_user_groups = input;
            self
        }
        /// Appends an item to `log_delivery_configurations`.
        ///
        /// To override the contents of this collection use [`set_log_delivery_configurations`](Self::set_log_delivery_configurations).
        ///
        /// <p>Specifies the destination, format and type of the logs.</p>
        pub fn log_delivery_configurations(
            mut self,
            input: crate::model::LogDeliveryConfigurationRequest,
        ) -> Self {
            let mut v = self.log_delivery_configurations.unwrap_or_default();
            v.push(input);
            self.log_delivery_configurations = Some(v);
            self
        }
        /// <p>Specifies the destination, format and type of the logs.</p>
        pub fn set_log_delivery_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>,
            >,
        ) -> Self {
            self.log_delivery_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyReplicationGroupInput`](crate::input::ModifyReplicationGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyReplicationGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyReplicationGroupInput {
                replication_group_id: self.replication_group_id,
                replication_group_description: self.replication_group_description,
                primary_cluster_id: self.primary_cluster_id,
                snapshotting_cluster_id: self.snapshotting_cluster_id,
                automatic_failover_enabled: self.automatic_failover_enabled,
                multi_az_enabled: self.multi_az_enabled,
                node_group_id: self.node_group_id,
                cache_security_group_names: self.cache_security_group_names,
                security_group_ids: self.security_group_ids,
                preferred_maintenance_window: self.preferred_maintenance_window,
                notification_topic_arn: self.notification_topic_arn,
                cache_parameter_group_name: self.cache_parameter_group_name,
                notification_topic_status: self.notification_topic_status,
                apply_immediately: self.apply_immediately.unwrap_or_default(),
                engine_version: self.engine_version,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
                snapshot_retention_limit: self.snapshot_retention_limit,
                snapshot_window: self.snapshot_window,
                cache_node_type: self.cache_node_type,
                auth_token: self.auth_token,
                auth_token_update_strategy: self.auth_token_update_strategy,
                user_group_ids_to_add: self.user_group_ids_to_add,
                user_group_ids_to_remove: self.user_group_ids_to_remove,
                remove_user_groups: self.remove_user_groups,
                log_delivery_configurations: self.log_delivery_configurations,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyReplicationGroupInputOperationOutputAlias = crate::operation::ModifyReplicationGroup;
#[doc(hidden)]
pub type ModifyReplicationGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ModifyReplicationGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyReplicationGroup`](crate::operation::ModifyReplicationGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyReplicationGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyReplicationGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyReplicationGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyReplicationGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_modify_replication_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyReplicationGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyReplicationGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyReplicationGroupInput`](crate::input::ModifyReplicationGroupInput)
    pub fn builder() -> crate::input::modify_replication_group_input::Builder {
        crate::input::modify_replication_group_input::Builder::default()
    }
}

/// See [`ModifyReplicationGroupShardConfigurationInput`](crate::input::ModifyReplicationGroupShardConfigurationInput)
pub mod modify_replication_group_shard_configuration_input {
    /// A builder for [`ModifyReplicationGroupShardConfigurationInput`](crate::input::ModifyReplicationGroupShardConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) node_group_count: std::option::Option<i32>,
        pub(crate) apply_immediately: std::option::Option<bool>,
        pub(crate) resharding_configuration:
            std::option::Option<std::vec::Vec<crate::model::ReshardingConfiguration>>,
        pub(crate) node_groups_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) node_groups_to_retain: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Redis (cluster mode enabled) cluster (replication group) on which the shards are to be configured.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the Redis (cluster mode enabled) cluster (replication group) on which the shards are to be configured.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The number of node groups (shards) that results from the modification of the shard configuration.</p>
        pub fn node_group_count(mut self, input: i32) -> Self {
            self.node_group_count = Some(input);
            self
        }
        /// <p>The number of node groups (shards) that results from the modification of the shard configuration.</p>
        pub fn set_node_group_count(mut self, input: std::option::Option<i32>) -> Self {
            self.node_group_count = input;
            self
        }
        /// <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is <code>true</code>.</p>
        /// <p>Value: true</p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is <code>true</code>.</p>
        /// <p>Value: true</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// Appends an item to `resharding_configuration`.
        ///
        /// To override the contents of this collection use [`set_resharding_configuration`](Self::set_resharding_configuration).
        ///
        /// <p>Specifies the preferred availability zones for each node group in the cluster. If the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use this parameter to specify the preferred availability zones of the cluster's shards. If you omit this parameter ElastiCache selects availability zones for you.</p>
        /// <p>You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards).</p>
        pub fn resharding_configuration(
            mut self,
            input: crate::model::ReshardingConfiguration,
        ) -> Self {
            let mut v = self.resharding_configuration.unwrap_or_default();
            v.push(input);
            self.resharding_configuration = Some(v);
            self
        }
        /// <p>Specifies the preferred availability zones for each node group in the cluster. If the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use this parameter to specify the preferred availability zones of the cluster's shards. If you omit this parameter ElastiCache selects availability zones for you.</p>
        /// <p>You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards).</p>
        pub fn set_resharding_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReshardingConfiguration>>,
        ) -> Self {
            self.resharding_configuration = input;
            self
        }
        /// Appends an item to `node_groups_to_remove`.
        ///
        /// To override the contents of this collection use [`set_node_groups_to_remove`](Self::set_node_groups_to_remove).
        ///
        /// <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRemove</code> is a list of <code>NodeGroupId</code>s to remove from the cluster.</p>
        /// <p>ElastiCache for Redis will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the cluster.</p>
        pub fn node_groups_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.node_groups_to_remove.unwrap_or_default();
            v.push(input.into());
            self.node_groups_to_remove = Some(v);
            self
        }
        /// <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRemove</code> is a list of <code>NodeGroupId</code>s to remove from the cluster.</p>
        /// <p>ElastiCache for Redis will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the cluster.</p>
        pub fn set_node_groups_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.node_groups_to_remove = input;
            self
        }
        /// Appends an item to `node_groups_to_retain`.
        ///
        /// To override the contents of this collection use [`set_node_groups_to_retain`](Self::set_node_groups_to_retain).
        ///
        /// <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRetain</code> is a list of <code>NodeGroupId</code>s to retain in the cluster.</p>
        /// <p>ElastiCache for Redis will attempt to remove all node groups except those listed by <code>NodeGroupsToRetain</code> from the cluster.</p>
        pub fn node_groups_to_retain(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.node_groups_to_retain.unwrap_or_default();
            v.push(input.into());
            self.node_groups_to_retain = Some(v);
            self
        }
        /// <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRetain</code> is a list of <code>NodeGroupId</code>s to retain in the cluster.</p>
        /// <p>ElastiCache for Redis will attempt to remove all node groups except those listed by <code>NodeGroupsToRetain</code> from the cluster.</p>
        pub fn set_node_groups_to_retain(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.node_groups_to_retain = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyReplicationGroupShardConfigurationInput`](crate::input::ModifyReplicationGroupShardConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyReplicationGroupShardConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ModifyReplicationGroupShardConfigurationInput {
                    replication_group_id: self.replication_group_id,
                    node_group_count: self.node_group_count.unwrap_or_default(),
                    apply_immediately: self.apply_immediately.unwrap_or_default(),
                    resharding_configuration: self.resharding_configuration,
                    node_groups_to_remove: self.node_groups_to_remove,
                    node_groups_to_retain: self.node_groups_to_retain,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ModifyReplicationGroupShardConfigurationInputOperationOutputAlias =
    crate::operation::ModifyReplicationGroupShardConfiguration;
#[doc(hidden)]
pub type ModifyReplicationGroupShardConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ModifyReplicationGroupShardConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`ModifyReplicationGroupShardConfiguration`](crate::operation::ModifyReplicationGroupShardConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyReplicationGroupShardConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyReplicationGroupShardConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyReplicationGroupShardConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyReplicationGroupShardConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_modify_replication_group_shard_configuration(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyReplicationGroupShardConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyReplicationGroupShardConfiguration",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyReplicationGroupShardConfigurationInput`](crate::input::ModifyReplicationGroupShardConfigurationInput)
    pub fn builder() -> crate::input::modify_replication_group_shard_configuration_input::Builder {
        crate::input::modify_replication_group_shard_configuration_input::Builder::default()
    }
}

/// See [`ModifyUserInput`](crate::input::ModifyUserInput)
pub mod modify_user_input {
    /// A builder for [`ModifyUserInput`](crate::input::ModifyUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) access_string: std::option::Option<std::string::String>,
        pub(crate) append_access_string: std::option::Option<std::string::String>,
        pub(crate) passwords: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) no_password_required: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_string = Some(input.into());
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_string = input;
            self
        }
        /// <p>Adds additional user permissions to the access string.</p>
        pub fn append_access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.append_access_string = Some(input.into());
            self
        }
        /// <p>Adds additional user permissions to the access string.</p>
        pub fn set_append_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.append_access_string = input;
            self
        }
        /// Appends an item to `passwords`.
        ///
        /// To override the contents of this collection use [`set_passwords`](Self::set_passwords).
        ///
        /// <p>The passwords belonging to the user. You are allowed up to two.</p>
        pub fn passwords(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.passwords.unwrap_or_default();
            v.push(input.into());
            self.passwords = Some(v);
            self
        }
        /// <p>The passwords belonging to the user. You are allowed up to two.</p>
        pub fn set_passwords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.passwords = input;
            self
        }
        /// <p>Indicates no password is required for the user.</p>
        pub fn no_password_required(mut self, input: bool) -> Self {
            self.no_password_required = Some(input);
            self
        }
        /// <p>Indicates no password is required for the user.</p>
        pub fn set_no_password_required(mut self, input: std::option::Option<bool>) -> Self {
            self.no_password_required = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyUserInput`](crate::input::ModifyUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyUserInput {
                user_id: self.user_id,
                access_string: self.access_string,
                append_access_string: self.append_access_string,
                passwords: self.passwords,
                no_password_required: self.no_password_required,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyUserInputOperationOutputAlias = crate::operation::ModifyUser;
#[doc(hidden)]
pub type ModifyUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ModifyUserInput {
    /// Consumes the builder and constructs an Operation<[`ModifyUser`](crate::operation::ModifyUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_modify_user(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyUser",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyUserInput`](crate::input::ModifyUserInput)
    pub fn builder() -> crate::input::modify_user_input::Builder {
        crate::input::modify_user_input::Builder::default()
    }
}

/// See [`ModifyUserGroupInput`](crate::input::ModifyUserGroupInput)
pub mod modify_user_group_input {
    /// A builder for [`ModifyUserGroupInput`](crate::input::ModifyUserGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_group_id: std::option::Option<std::string::String>,
        pub(crate) user_ids_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_ids_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the user group.</p>
        pub fn user_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the user group.</p>
        pub fn set_user_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_group_id = input;
            self
        }
        /// Appends an item to `user_ids_to_add`.
        ///
        /// To override the contents of this collection use [`set_user_ids_to_add`](Self::set_user_ids_to_add).
        ///
        /// <p>The list of user IDs to add to the user group.</p>
        pub fn user_ids_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_ids_to_add.unwrap_or_default();
            v.push(input.into());
            self.user_ids_to_add = Some(v);
            self
        }
        /// <p>The list of user IDs to add to the user group.</p>
        pub fn set_user_ids_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_ids_to_add = input;
            self
        }
        /// Appends an item to `user_ids_to_remove`.
        ///
        /// To override the contents of this collection use [`set_user_ids_to_remove`](Self::set_user_ids_to_remove).
        ///
        /// <p>The list of user IDs to remove from the user group.</p>
        pub fn user_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_ids_to_remove.unwrap_or_default();
            v.push(input.into());
            self.user_ids_to_remove = Some(v);
            self
        }
        /// <p>The list of user IDs to remove from the user group.</p>
        pub fn set_user_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_ids_to_remove = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyUserGroupInput`](crate::input::ModifyUserGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyUserGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyUserGroupInput {
                user_group_id: self.user_group_id,
                user_ids_to_add: self.user_ids_to_add,
                user_ids_to_remove: self.user_ids_to_remove,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyUserGroupInputOperationOutputAlias = crate::operation::ModifyUserGroup;
#[doc(hidden)]
pub type ModifyUserGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ModifyUserGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyUserGroup`](crate::operation::ModifyUserGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyUserGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyUserGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyUserGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyUserGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_modify_user_group(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyUserGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyUserGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyUserGroupInput`](crate::input::ModifyUserGroupInput)
    pub fn builder() -> crate::input::modify_user_group_input::Builder {
        crate::input::modify_user_group_input::Builder::default()
    }
}

/// See [`PurchaseReservedCacheNodesOfferingInput`](crate::input::PurchaseReservedCacheNodesOfferingInput)
pub mod purchase_reserved_cache_nodes_offering_input {
    /// A builder for [`PurchaseReservedCacheNodesOfferingInput`](crate::input::PurchaseReservedCacheNodesOfferingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_cache_nodes_offering_id: std::option::Option<std::string::String>,
        pub(crate) reserved_cache_node_id: std::option::Option<std::string::String>,
        pub(crate) cache_node_count: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the reserved cache node offering to purchase.</p>
        /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
        pub fn reserved_cache_nodes_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_cache_nodes_offering_id = Some(input.into());
            self
        }
        /// <p>The ID of the reserved cache node offering to purchase.</p>
        /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
        pub fn set_reserved_cache_nodes_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_cache_nodes_offering_id = input;
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p> <note>
        /// <p>The Reserved Cache Node ID is an unique customer-specified identifier to track this reservation. If this parameter is not specified, ElastiCache automatically generates an identifier for the reservation.</p>
        /// </note>
        /// <p>Example: myreservationID</p>
        pub fn reserved_cache_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_cache_node_id = Some(input.into());
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p> <note>
        /// <p>The Reserved Cache Node ID is an unique customer-specified identifier to track this reservation. If this parameter is not specified, ElastiCache automatically generates an identifier for the reservation.</p>
        /// </note>
        /// <p>Example: myreservationID</p>
        pub fn set_reserved_cache_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_cache_node_id = input;
            self
        }
        /// <p>The number of cache node instances to reserve.</p>
        /// <p>Default: <code>1</code> </p>
        pub fn cache_node_count(mut self, input: i32) -> Self {
            self.cache_node_count = Some(input);
            self
        }
        /// <p>The number of cache node instances to reserve.</p>
        /// <p>Default: <code>1</code> </p>
        pub fn set_cache_node_count(mut self, input: std::option::Option<i32>) -> Self {
            self.cache_node_count = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseReservedCacheNodesOfferingInput`](crate::input::PurchaseReservedCacheNodesOfferingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PurchaseReservedCacheNodesOfferingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PurchaseReservedCacheNodesOfferingInput {
                reserved_cache_nodes_offering_id: self.reserved_cache_nodes_offering_id,
                reserved_cache_node_id: self.reserved_cache_node_id,
                cache_node_count: self.cache_node_count,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PurchaseReservedCacheNodesOfferingInputOperationOutputAlias =
    crate::operation::PurchaseReservedCacheNodesOffering;
#[doc(hidden)]
pub type PurchaseReservedCacheNodesOfferingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PurchaseReservedCacheNodesOfferingInput {
    /// Consumes the builder and constructs an Operation<[`PurchaseReservedCacheNodesOffering`](crate::operation::PurchaseReservedCacheNodesOffering)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PurchaseReservedCacheNodesOffering,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PurchaseReservedCacheNodesOfferingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PurchaseReservedCacheNodesOfferingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PurchaseReservedCacheNodesOfferingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_purchase_reserved_cache_nodes_offering(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PurchaseReservedCacheNodesOffering::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PurchaseReservedCacheNodesOffering",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PurchaseReservedCacheNodesOfferingInput`](crate::input::PurchaseReservedCacheNodesOfferingInput)
    pub fn builder() -> crate::input::purchase_reserved_cache_nodes_offering_input::Builder {
        crate::input::purchase_reserved_cache_nodes_offering_input::Builder::default()
    }
}

/// See [`RebalanceSlotsInGlobalReplicationGroupInput`](crate::input::RebalanceSlotsInGlobalReplicationGroupInput)
pub mod rebalance_slots_in_global_replication_group_input {
    /// A builder for [`RebalanceSlotsInGlobalReplicationGroupInput`](crate::input::RebalanceSlotsInGlobalReplicationGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group_id: std::option::Option<std::string::String>,
        pub(crate) apply_immediately: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = input;
            self
        }
        /// <p>If <code>True</code>, redistribution is applied immediately.</p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>If <code>True</code>, redistribution is applied immediately.</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// Consumes the builder and constructs a [`RebalanceSlotsInGlobalReplicationGroupInput`](crate::input::RebalanceSlotsInGlobalReplicationGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RebalanceSlotsInGlobalReplicationGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RebalanceSlotsInGlobalReplicationGroupInput {
                global_replication_group_id: self.global_replication_group_id,
                apply_immediately: self.apply_immediately.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type RebalanceSlotsInGlobalReplicationGroupInputOperationOutputAlias =
    crate::operation::RebalanceSlotsInGlobalReplicationGroup;
#[doc(hidden)]
pub type RebalanceSlotsInGlobalReplicationGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl RebalanceSlotsInGlobalReplicationGroupInput {
    /// Consumes the builder and constructs an Operation<[`RebalanceSlotsInGlobalReplicationGroup`](crate::operation::RebalanceSlotsInGlobalReplicationGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RebalanceSlotsInGlobalReplicationGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RebalanceSlotsInGlobalReplicationGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RebalanceSlotsInGlobalReplicationGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RebalanceSlotsInGlobalReplicationGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_rebalance_slots_in_global_replication_group(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RebalanceSlotsInGlobalReplicationGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RebalanceSlotsInGlobalReplicationGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RebalanceSlotsInGlobalReplicationGroupInput`](crate::input::RebalanceSlotsInGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::rebalance_slots_in_global_replication_group_input::Builder {
        crate::input::rebalance_slots_in_global_replication_group_input::Builder::default()
    }
}

/// See [`RebootCacheClusterInput`](crate::input::RebootCacheClusterInput)
pub mod reboot_cache_cluster_input {
    /// A builder for [`RebootCacheClusterInput`](crate::input::RebootCacheClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) cache_node_ids_to_reboot:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The cluster identifier. This parameter is stored as a lowercase string.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is stored as a lowercase string.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// Appends an item to `cache_node_ids_to_reboot`.
        ///
        /// To override the contents of this collection use [`set_cache_node_ids_to_reboot`](Self::set_cache_node_ids_to_reboot).
        ///
        /// <p>A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an entire cluster, specify all of the cache node IDs.</p>
        pub fn cache_node_ids_to_reboot(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_node_ids_to_reboot.unwrap_or_default();
            v.push(input.into());
            self.cache_node_ids_to_reboot = Some(v);
            self
        }
        /// <p>A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an entire cluster, specify all of the cache node IDs.</p>
        pub fn set_cache_node_ids_to_reboot(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_node_ids_to_reboot = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootCacheClusterInput`](crate::input::RebootCacheClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RebootCacheClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RebootCacheClusterInput {
                cache_cluster_id: self.cache_cluster_id,
                cache_node_ids_to_reboot: self.cache_node_ids_to_reboot,
            })
        }
    }
}
#[doc(hidden)]
pub type RebootCacheClusterInputOperationOutputAlias = crate::operation::RebootCacheCluster;
#[doc(hidden)]
pub type RebootCacheClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RebootCacheClusterInput {
    /// Consumes the builder and constructs an Operation<[`RebootCacheCluster`](crate::operation::RebootCacheCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RebootCacheCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RebootCacheClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RebootCacheClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RebootCacheClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_reboot_cache_cluster(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RebootCacheCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RebootCacheCluster",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RebootCacheClusterInput`](crate::input::RebootCacheClusterInput)
    pub fn builder() -> crate::input::reboot_cache_cluster_input::Builder {
        crate::input::reboot_cache_cluster_input::Builder::default()
    }
}

/// See [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
pub mod remove_tags_from_resource_input {
    /// A builder for [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource from which you want the tags removed, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which you want the tags removed, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of <code>TagKeys</code> identifying the tags you want removed from the named resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of <code>TagKeys</code> identifying the tags you want removed from the named resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsFromResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsFromResourceInput {
                resource_name: self.resource_name,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationOutputAlias = crate::operation::RemoveTagsFromResource;
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RemoveTagsFromResourceInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTagsFromResource`](crate::operation::RemoveTagsFromResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTagsFromResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTagsFromResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTagsFromResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTagsFromResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_remove_tags_from_resource(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTagsFromResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTagsFromResource",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
}

/// See [`ResetCacheParameterGroupInput`](crate::input::ResetCacheParameterGroupInput)
pub mod reset_cache_parameter_group_input {
    /// A builder for [`ResetCacheParameterGroupInput`](crate::input::ResetCacheParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) reset_all_parameters: std::option::Option<bool>,
        pub(crate) parameter_name_values:
            std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
    }
    impl Builder {
        /// <p>The name of the cache parameter group to reset.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group to reset.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// <p>If <code>true</code>, all parameters in the cache parameter group are reset to their default values. If <code>false</code>, only the parameters listed by <code>ParameterNameValues</code> are reset to their default values.</p>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        pub fn reset_all_parameters(mut self, input: bool) -> Self {
            self.reset_all_parameters = Some(input);
            self
        }
        /// <p>If <code>true</code>, all parameters in the cache parameter group are reset to their default values. If <code>false</code>, only the parameters listed by <code>ParameterNameValues</code> are reset to their default values.</p>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        pub fn set_reset_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.reset_all_parameters = input;
            self
        }
        /// Appends an item to `parameter_name_values`.
        ///
        /// To override the contents of this collection use [`set_parameter_name_values`](Self::set_parameter_name_values).
        ///
        /// <p>An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is <code>false</code>, you must specify the name of at least one parameter to reset.</p>
        pub fn parameter_name_values(mut self, input: crate::model::ParameterNameValue) -> Self {
            let mut v = self.parameter_name_values.unwrap_or_default();
            v.push(input);
            self.parameter_name_values = Some(v);
            self
        }
        /// <p>An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is <code>false</code>, you must specify the name of at least one parameter to reset.</p>
        pub fn set_parameter_name_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
        ) -> Self {
            self.parameter_name_values = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetCacheParameterGroupInput`](crate::input::ResetCacheParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResetCacheParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResetCacheParameterGroupInput {
                cache_parameter_group_name: self.cache_parameter_group_name,
                reset_all_parameters: self.reset_all_parameters.unwrap_or_default(),
                parameter_name_values: self.parameter_name_values,
            })
        }
    }
}
#[doc(hidden)]
pub type ResetCacheParameterGroupInputOperationOutputAlias =
    crate::operation::ResetCacheParameterGroup;
#[doc(hidden)]
pub type ResetCacheParameterGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ResetCacheParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`ResetCacheParameterGroup`](crate::operation::ResetCacheParameterGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResetCacheParameterGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResetCacheParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResetCacheParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResetCacheParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_reset_cache_parameter_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResetCacheParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResetCacheParameterGroup",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResetCacheParameterGroupInput`](crate::input::ResetCacheParameterGroupInput)
    pub fn builder() -> crate::input::reset_cache_parameter_group_input::Builder {
        crate::input::reset_cache_parameter_group_input::Builder::default()
    }
}

/// See [`RevokeCacheSecurityGroupIngressInput`](crate::input::RevokeCacheSecurityGroupIngressInput)
pub mod revoke_cache_security_group_ingress_input {
    /// A builder for [`RevokeCacheSecurityGroupIngressInput`](crate::input::RevokeCacheSecurityGroupIngressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_security_group_name: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_name: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_owner_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cache security group to revoke ingress from.</p>
        pub fn cache_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache security group to revoke ingress from.</p>
        pub fn set_cache_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_security_group_name = input;
            self
        }
        /// <p>The name of the Amazon EC2 security group to revoke access from.</p>
        pub fn ec2_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon EC2 security group to revoke access from.</p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_name = input;
            self
        }
        /// <p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>
        pub fn ec2_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeCacheSecurityGroupIngressInput`](crate::input::RevokeCacheSecurityGroupIngressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RevokeCacheSecurityGroupIngressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RevokeCacheSecurityGroupIngressInput {
                cache_security_group_name: self.cache_security_group_name,
                ec2_security_group_name: self.ec2_security_group_name,
                ec2_security_group_owner_id: self.ec2_security_group_owner_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RevokeCacheSecurityGroupIngressInputOperationOutputAlias =
    crate::operation::RevokeCacheSecurityGroupIngress;
#[doc(hidden)]
pub type RevokeCacheSecurityGroupIngressInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl RevokeCacheSecurityGroupIngressInput {
    /// Consumes the builder and constructs an Operation<[`RevokeCacheSecurityGroupIngress`](crate::operation::RevokeCacheSecurityGroupIngress)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RevokeCacheSecurityGroupIngress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RevokeCacheSecurityGroupIngressInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RevokeCacheSecurityGroupIngressInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RevokeCacheSecurityGroupIngressInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_revoke_cache_security_group_ingress(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RevokeCacheSecurityGroupIngress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RevokeCacheSecurityGroupIngress",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RevokeCacheSecurityGroupIngressInput`](crate::input::RevokeCacheSecurityGroupIngressInput)
    pub fn builder() -> crate::input::revoke_cache_security_group_ingress_input::Builder {
        crate::input::revoke_cache_security_group_ingress_input::Builder::default()
    }
}

/// See [`StartMigrationInput`](crate::input::StartMigrationInput)
pub mod start_migration_input {
    /// A builder for [`StartMigrationInput`](crate::input::StartMigrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) customer_node_endpoint_list:
            std::option::Option<std::vec::Vec<crate::model::CustomerNodeEndpoint>>,
    }
    impl Builder {
        /// <p>The ID of the replication group to which data should be migrated.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication group to which data should be migrated.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// Appends an item to `customer_node_endpoint_list`.
        ///
        /// To override the contents of this collection use [`set_customer_node_endpoint_list`](Self::set_customer_node_endpoint_list).
        ///
        /// <p>List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should have only one element.</p>
        pub fn customer_node_endpoint_list(
            mut self,
            input: crate::model::CustomerNodeEndpoint,
        ) -> Self {
            let mut v = self.customer_node_endpoint_list.unwrap_or_default();
            v.push(input);
            self.customer_node_endpoint_list = Some(v);
            self
        }
        /// <p>List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should have only one element.</p>
        pub fn set_customer_node_endpoint_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomerNodeEndpoint>>,
        ) -> Self {
            self.customer_node_endpoint_list = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMigrationInput`](crate::input::StartMigrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartMigrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartMigrationInput {
                replication_group_id: self.replication_group_id,
                customer_node_endpoint_list: self.customer_node_endpoint_list,
            })
        }
    }
}
#[doc(hidden)]
pub type StartMigrationInputOperationOutputAlias = crate::operation::StartMigration;
#[doc(hidden)]
pub type StartMigrationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartMigrationInput {
    /// Consumes the builder and constructs an Operation<[`StartMigration`](crate::operation::StartMigration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartMigration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartMigrationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartMigrationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartMigrationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_migration(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartMigration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartMigration",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartMigrationInput`](crate::input::StartMigrationInput)
    pub fn builder() -> crate::input::start_migration_input::Builder {
        crate::input::start_migration_input::Builder::default()
    }
}

/// See [`TestFailoverInput`](crate::input::TestFailoverInput)
pub mod test_failover_input {
    /// A builder for [`TestFailoverInput`](crate::input::TestFailoverInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) node_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the replication group (console: cluster) whose automatic failover is being tested by this operation.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the replication group (console: cluster) whose automatic failover is being tested by this operation.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The name of the node group (called shard in the console) in this replication group on which automatic failover is to be tested. You may test automatic failover on up to 5 node groups in any rolling 24-hour period.</p>
        pub fn node_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_group_id = Some(input.into());
            self
        }
        /// <p>The name of the node group (called shard in the console) in this replication group on which automatic failover is to be tested. You may test automatic failover on up to 5 node groups in any rolling 24-hour period.</p>
        pub fn set_node_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.node_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TestFailoverInput`](crate::input::TestFailoverInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TestFailoverInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TestFailoverInput {
                replication_group_id: self.replication_group_id,
                node_group_id: self.node_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type TestFailoverInputOperationOutputAlias = crate::operation::TestFailover;
#[doc(hidden)]
pub type TestFailoverInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TestFailoverInput {
    /// Consumes the builder and constructs an Operation<[`TestFailover`](crate::operation::TestFailover)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestFailover,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TestFailoverInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TestFailoverInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TestFailoverInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_test_failover(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TestFailover::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TestFailover",
            "elasticache",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TestFailoverInput`](crate::input::TestFailoverInput)
    pub fn builder() -> crate::input::test_failover_input::Builder {
        crate::input::test_failover_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestFailoverInput {
    /// <p>The name of the replication group (console: cluster) whose automatic failover is being tested by this operation.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The name of the node group (called shard in the console) in this replication group on which automatic failover is to be tested. You may test automatic failover on up to 5 node groups in any rolling 24-hour period.</p>
    pub node_group_id: std::option::Option<std::string::String>,
}
impl TestFailoverInput {
    /// <p>The name of the replication group (console: cluster) whose automatic failover is being tested by this operation.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The name of the node group (called shard in the console) in this replication group on which automatic failover is to be tested. You may test automatic failover on up to 5 node groups in any rolling 24-hour period.</p>
    pub fn node_group_id(&self) -> std::option::Option<&str> {
        self.node_group_id.as_deref()
    }
}
impl std::fmt::Debug for TestFailoverInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestFailoverInput");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("node_group_id", &self.node_group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMigrationInput {
    /// <p>The ID of the replication group to which data should be migrated.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should have only one element.</p>
    pub customer_node_endpoint_list:
        std::option::Option<std::vec::Vec<crate::model::CustomerNodeEndpoint>>,
}
impl StartMigrationInput {
    /// <p>The ID of the replication group to which data should be migrated.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should have only one element.</p>
    pub fn customer_node_endpoint_list(
        &self,
    ) -> std::option::Option<&[crate::model::CustomerNodeEndpoint]> {
        self.customer_node_endpoint_list.as_deref()
    }
}
impl std::fmt::Debug for StartMigrationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMigrationInput");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field(
            "customer_node_endpoint_list",
            &self.customer_node_endpoint_list,
        );
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>RevokeCacheSecurityGroupIngress</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeCacheSecurityGroupIngressInput {
    /// <p>The name of the cache security group to revoke ingress from.</p>
    pub cache_security_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon EC2 security group to revoke access from.</p>
    pub ec2_security_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>
    pub ec2_security_group_owner_id: std::option::Option<std::string::String>,
}
impl RevokeCacheSecurityGroupIngressInput {
    /// <p>The name of the cache security group to revoke ingress from.</p>
    pub fn cache_security_group_name(&self) -> std::option::Option<&str> {
        self.cache_security_group_name.as_deref()
    }
    /// <p>The name of the Amazon EC2 security group to revoke access from.</p>
    pub fn ec2_security_group_name(&self) -> std::option::Option<&str> {
        self.ec2_security_group_name.as_deref()
    }
    /// <p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>
    pub fn ec2_security_group_owner_id(&self) -> std::option::Option<&str> {
        self.ec2_security_group_owner_id.as_deref()
    }
}
impl std::fmt::Debug for RevokeCacheSecurityGroupIngressInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeCacheSecurityGroupIngressInput");
        formatter.field("cache_security_group_name", &self.cache_security_group_name);
        formatter.field("ec2_security_group_name", &self.ec2_security_group_name);
        formatter.field(
            "ec2_security_group_owner_id",
            &self.ec2_security_group_owner_id,
        );
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ResetCacheParameterGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetCacheParameterGroupInput {
    /// <p>The name of the cache parameter group to reset.</p>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>If <code>true</code>, all parameters in the cache parameter group are reset to their default values. If <code>false</code>, only the parameters listed by <code>ParameterNameValues</code> are reset to their default values.</p>
    /// <p>Valid values: <code>true</code> | <code>false</code> </p>
    pub reset_all_parameters: bool,
    /// <p>An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is <code>false</code>, you must specify the name of at least one parameter to reset.</p>
    pub parameter_name_values: std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
}
impl ResetCacheParameterGroupInput {
    /// <p>The name of the cache parameter group to reset.</p>
    pub fn cache_parameter_group_name(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_name.as_deref()
    }
    /// <p>If <code>true</code>, all parameters in the cache parameter group are reset to their default values. If <code>false</code>, only the parameters listed by <code>ParameterNameValues</code> are reset to their default values.</p>
    /// <p>Valid values: <code>true</code> | <code>false</code> </p>
    pub fn reset_all_parameters(&self) -> bool {
        self.reset_all_parameters
    }
    /// <p>An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is <code>false</code>, you must specify the name of at least one parameter to reset.</p>
    pub fn parameter_name_values(
        &self,
    ) -> std::option::Option<&[crate::model::ParameterNameValue]> {
        self.parameter_name_values.as_deref()
    }
}
impl std::fmt::Debug for ResetCacheParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetCacheParameterGroupInput");
        formatter.field(
            "cache_parameter_group_name",
            &self.cache_parameter_group_name,
        );
        formatter.field("reset_all_parameters", &self.reset_all_parameters);
        formatter.field("parameter_name_values", &self.parameter_name_values);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>RemoveTagsFromResource</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource from which you want the tags removed, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>
    /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>A list of <code>TagKeys</code> identifying the tags you want removed from the named resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RemoveTagsFromResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource from which you want the tags removed, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>
    /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>A list of <code>TagKeys</code> identifying the tags you want removed from the named resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsFromResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceInput");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>RebootCacheCluster</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootCacheClusterInput {
    /// <p>The cluster identifier. This parameter is stored as a lowercase string.</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an entire cluster, specify all of the cache node IDs.</p>
    pub cache_node_ids_to_reboot: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RebootCacheClusterInput {
    /// <p>The cluster identifier. This parameter is stored as a lowercase string.</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an entire cluster, specify all of the cache node IDs.</p>
    pub fn cache_node_ids_to_reboot(&self) -> std::option::Option<&[std::string::String]> {
        self.cache_node_ids_to_reboot.as_deref()
    }
}
impl std::fmt::Debug for RebootCacheClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootCacheClusterInput");
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("cache_node_ids_to_reboot", &self.cache_node_ids_to_reboot);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebalanceSlotsInGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub global_replication_group_id: std::option::Option<std::string::String>,
    /// <p>If <code>True</code>, redistribution is applied immediately.</p>
    pub apply_immediately: bool,
}
impl RebalanceSlotsInGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub fn global_replication_group_id(&self) -> std::option::Option<&str> {
        self.global_replication_group_id.as_deref()
    }
    /// <p>If <code>True</code>, redistribution is applied immediately.</p>
    pub fn apply_immediately(&self) -> bool {
        self.apply_immediately
    }
}
impl std::fmt::Debug for RebalanceSlotsInGlobalReplicationGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebalanceSlotsInGlobalReplicationGroupInput");
        formatter.field(
            "global_replication_group_id",
            &self.global_replication_group_id,
        );
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>PurchaseReservedCacheNodesOffering</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseReservedCacheNodesOfferingInput {
    /// <p>The ID of the reserved cache node offering to purchase.</p>
    /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
    pub reserved_cache_nodes_offering_id: std::option::Option<std::string::String>,
    /// <p>A customer-specified identifier to track this reservation.</p> <note>
    /// <p>The Reserved Cache Node ID is an unique customer-specified identifier to track this reservation. If this parameter is not specified, ElastiCache automatically generates an identifier for the reservation.</p>
    /// </note>
    /// <p>Example: myreservationID</p>
    pub reserved_cache_node_id: std::option::Option<std::string::String>,
    /// <p>The number of cache node instances to reserve.</p>
    /// <p>Default: <code>1</code> </p>
    pub cache_node_count: std::option::Option<i32>,
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl PurchaseReservedCacheNodesOfferingInput {
    /// <p>The ID of the reserved cache node offering to purchase.</p>
    /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
    pub fn reserved_cache_nodes_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_cache_nodes_offering_id.as_deref()
    }
    /// <p>A customer-specified identifier to track this reservation.</p> <note>
    /// <p>The Reserved Cache Node ID is an unique customer-specified identifier to track this reservation. If this parameter is not specified, ElastiCache automatically generates an identifier for the reservation.</p>
    /// </note>
    /// <p>Example: myreservationID</p>
    pub fn reserved_cache_node_id(&self) -> std::option::Option<&str> {
        self.reserved_cache_node_id.as_deref()
    }
    /// <p>The number of cache node instances to reserve.</p>
    /// <p>Default: <code>1</code> </p>
    pub fn cache_node_count(&self) -> std::option::Option<i32> {
        self.cache_node_count
    }
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PurchaseReservedCacheNodesOfferingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseReservedCacheNodesOfferingInput");
        formatter.field(
            "reserved_cache_nodes_offering_id",
            &self.reserved_cache_nodes_offering_id,
        );
        formatter.field("reserved_cache_node_id", &self.reserved_cache_node_id);
        formatter.field("cache_node_count", &self.cache_node_count);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyUserGroupInput {
    /// <p>The ID of the user group.</p>
    pub user_group_id: std::option::Option<std::string::String>,
    /// <p>The list of user IDs to add to the user group.</p>
    pub user_ids_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of user IDs to remove from the user group.</p>
    pub user_ids_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ModifyUserGroupInput {
    /// <p>The ID of the user group.</p>
    pub fn user_group_id(&self) -> std::option::Option<&str> {
        self.user_group_id.as_deref()
    }
    /// <p>The list of user IDs to add to the user group.</p>
    pub fn user_ids_to_add(&self) -> std::option::Option<&[std::string::String]> {
        self.user_ids_to_add.as_deref()
    }
    /// <p>The list of user IDs to remove from the user group.</p>
    pub fn user_ids_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.user_ids_to_remove.as_deref()
    }
}
impl std::fmt::Debug for ModifyUserGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyUserGroupInput");
        formatter.field("user_group_id", &self.user_group_id);
        formatter.field("user_ids_to_add", &self.user_ids_to_add);
        formatter.field("user_ids_to_remove", &self.user_ids_to_remove);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyUserInput {
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>Access permissions string used for this user.</p>
    pub access_string: std::option::Option<std::string::String>,
    /// <p>Adds additional user permissions to the access string.</p>
    pub append_access_string: std::option::Option<std::string::String>,
    /// <p>The passwords belonging to the user. You are allowed up to two.</p>
    pub passwords: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates no password is required for the user.</p>
    pub no_password_required: std::option::Option<bool>,
}
impl ModifyUserInput {
    /// <p>The ID of the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>Access permissions string used for this user.</p>
    pub fn access_string(&self) -> std::option::Option<&str> {
        self.access_string.as_deref()
    }
    /// <p>Adds additional user permissions to the access string.</p>
    pub fn append_access_string(&self) -> std::option::Option<&str> {
        self.append_access_string.as_deref()
    }
    /// <p>The passwords belonging to the user. You are allowed up to two.</p>
    pub fn passwords(&self) -> std::option::Option<&[std::string::String]> {
        self.passwords.as_deref()
    }
    /// <p>Indicates no password is required for the user.</p>
    pub fn no_password_required(&self) -> std::option::Option<bool> {
        self.no_password_required
    }
}
impl std::fmt::Debug for ModifyUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyUserInput");
        formatter.field("user_id", &self.user_id);
        formatter.field("access_string", &self.access_string);
        formatter.field("append_access_string", &self.append_access_string);
        formatter.field("passwords", &self.passwords);
        formatter.field("no_password_required", &self.no_password_required);
        formatter.finish()
    }
}

/// <p>Represents the input for a <code>ModifyReplicationGroupShardConfiguration</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyReplicationGroupShardConfigurationInput {
    /// <p>The name of the Redis (cluster mode enabled) cluster (replication group) on which the shards are to be configured.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The number of node groups (shards) that results from the modification of the shard configuration.</p>
    pub node_group_count: i32,
    /// <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is <code>true</code>.</p>
    /// <p>Value: true</p>
    pub apply_immediately: bool,
    /// <p>Specifies the preferred availability zones for each node group in the cluster. If the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use this parameter to specify the preferred availability zones of the cluster's shards. If you omit this parameter ElastiCache selects availability zones for you.</p>
    /// <p>You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards).</p>
    pub resharding_configuration:
        std::option::Option<std::vec::Vec<crate::model::ReshardingConfiguration>>,
    /// <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRemove</code> is a list of <code>NodeGroupId</code>s to remove from the cluster.</p>
    /// <p>ElastiCache for Redis will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the cluster.</p>
    pub node_groups_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRetain</code> is a list of <code>NodeGroupId</code>s to retain in the cluster.</p>
    /// <p>ElastiCache for Redis will attempt to remove all node groups except those listed by <code>NodeGroupsToRetain</code> from the cluster.</p>
    pub node_groups_to_retain: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ModifyReplicationGroupShardConfigurationInput {
    /// <p>The name of the Redis (cluster mode enabled) cluster (replication group) on which the shards are to be configured.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The number of node groups (shards) that results from the modification of the shard configuration.</p>
    pub fn node_group_count(&self) -> i32 {
        self.node_group_count
    }
    /// <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is <code>true</code>.</p>
    /// <p>Value: true</p>
    pub fn apply_immediately(&self) -> bool {
        self.apply_immediately
    }
    /// <p>Specifies the preferred availability zones for each node group in the cluster. If the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use this parameter to specify the preferred availability zones of the cluster's shards. If you omit this parameter ElastiCache selects availability zones for you.</p>
    /// <p>You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards).</p>
    pub fn resharding_configuration(
        &self,
    ) -> std::option::Option<&[crate::model::ReshardingConfiguration]> {
        self.resharding_configuration.as_deref()
    }
    /// <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRemove</code> is a list of <code>NodeGroupId</code>s to remove from the cluster.</p>
    /// <p>ElastiCache for Redis will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the cluster.</p>
    pub fn node_groups_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.node_groups_to_remove.as_deref()
    }
    /// <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRetain</code> is a list of <code>NodeGroupId</code>s to retain in the cluster.</p>
    /// <p>ElastiCache for Redis will attempt to remove all node groups except those listed by <code>NodeGroupsToRetain</code> from the cluster.</p>
    pub fn node_groups_to_retain(&self) -> std::option::Option<&[std::string::String]> {
        self.node_groups_to_retain.as_deref()
    }
}
impl std::fmt::Debug for ModifyReplicationGroupShardConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyReplicationGroupShardConfigurationInput");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("node_group_count", &self.node_group_count);
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.field("resharding_configuration", &self.resharding_configuration);
        formatter.field("node_groups_to_remove", &self.node_groups_to_remove);
        formatter.field("node_groups_to_retain", &self.node_groups_to_retain);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ModifyReplicationGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyReplicationGroupInput {
    /// <p>The identifier of the replication group to modify.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>A description for the replication group. Maximum length is 255 characters.</p>
    pub replication_group_description: std::option::Option<std::string::String>,
    /// <p>For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the specified cluster in the specified replication group to the primary role. The nodes of all other clusters in the replication group are read replicas.</p>
    pub primary_cluster_id: std::option::Option<std::string::String>,
    /// <p>The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be set for Redis (cluster mode enabled) replication groups.</p>
    pub snapshotting_cluster_id: std::option::Option<std::string::String>,
    /// <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure.</p>
    /// <p>Valid values: <code>true</code> | <code>false</code> </p>
    pub automatic_failover_enabled: std::option::Option<bool>,
    /// <p>A flag to indicate MultiAZ is enabled.</p>
    pub multi_az_enabled: std::option::Option<bool>,
    /// <p>Deprecated. This parameter is not used.</p>
    pub node_group_id: std::option::Option<std::string::String>,
    /// <p>A list of cache security group names to authorize for the clusters in this replication group. This change is asynchronously applied as soon as possible.</p>
    /// <p>This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
    /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.</p>
    pub cache_security_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the VPC Security Groups associated with the clusters in the replication group.</p>
    /// <p>This parameter can be used only with replication group containing clusters running in an Amazon Virtual Private Cloud (Amazon VPC).</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
    /// <p>Valid values for <code>ddd</code> are:</p>
    /// <ul>
    /// <li> <p> <code>sun</code> </p> </li>
    /// <li> <p> <code>mon</code> </p> </li>
    /// <li> <p> <code>tue</code> </p> </li>
    /// <li> <p> <code>wed</code> </p> </li>
    /// <li> <p> <code>thu</code> </p> </li>
    /// <li> <p> <code>fri</code> </p> </li>
    /// <li> <p> <code>sat</code> </p> </li>
    /// </ul>
    /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
    /// <p>The Amazon SNS topic owner must be same as the replication group owner. </p>
    /// </note>
    pub notification_topic_arn: std::option::Option<std::string::String>,
    /// <p>The name of the cache parameter group to apply to all of the clusters in this replication group. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the status is <code>active</code>.</p>
    /// <p>Valid values: <code>active</code> | <code>inactive</code> </p>
    pub notification_topic_status: std::option::Option<std::string::String>,
    /// <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the replication group.</p>
    /// <p>If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p>
    /// <p>Valid values: <code>true</code> | <code>false</code> </p>
    /// <p>Default: <code>false</code> </p>
    pub apply_immediately: bool,
    /// <p>The upgraded version of the cache engine to be run on the clusters in the replication group.</p>
    /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing replication group and create it anew with the earlier engine version. </p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
    pub auto_minor_version_upgrade: std::option::Option<bool>,
    /// <p>The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
    /// <p> <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
    pub snapshot_retention_limit: std::option::Option<i32>,
    /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group (shard) specified by <code>SnapshottingClusterId</code>.</p>
    /// <p>Example: <code>05:00-09:00</code> </p>
    /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>
    pub snapshot_window: std::option::Option<std::string::String>,
    /// <p>A valid cache node type that you want to scale this replication group to.</p>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update-strategy </code> parameter. Password constraints:</p>
    /// <ul>
    /// <li> <p>Must be only printable ASCII characters</p> </li>
    /// <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>
    /// <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>
    /// </ul>
    /// <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
    pub auth_token: std::option::Option<std::string::String>,
    /// <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>
    /// <ul>
    /// <li> <p>Rotate</p> </li>
    /// <li> <p>Set</p> </li>
    /// </ul>
    /// <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
    pub auth_token_update_strategy: std::option::Option<crate::model::AuthTokenUpdateStrategyType>,
    /// <p>The ID of the user group you are associating with the replication group.</p>
    pub user_group_ids_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the user group to disassociate from the replication group, meaning the users in the group no longer can access the replication group.</p>
    pub user_group_ids_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Removes the user group associated with this replication group.</p>
    pub remove_user_groups: std::option::Option<bool>,
    /// <p>Specifies the destination, format and type of the logs.</p>
    pub log_delivery_configurations:
        std::option::Option<std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>>,
}
impl ModifyReplicationGroupInput {
    /// <p>The identifier of the replication group to modify.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>A description for the replication group. Maximum length is 255 characters.</p>
    pub fn replication_group_description(&self) -> std::option::Option<&str> {
        self.replication_group_description.as_deref()
    }
    /// <p>For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the specified cluster in the specified replication group to the primary role. The nodes of all other clusters in the replication group are read replicas.</p>
    pub fn primary_cluster_id(&self) -> std::option::Option<&str> {
        self.primary_cluster_id.as_deref()
    }
    /// <p>The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be set for Redis (cluster mode enabled) replication groups.</p>
    pub fn snapshotting_cluster_id(&self) -> std::option::Option<&str> {
        self.snapshotting_cluster_id.as_deref()
    }
    /// <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure.</p>
    /// <p>Valid values: <code>true</code> | <code>false</code> </p>
    pub fn automatic_failover_enabled(&self) -> std::option::Option<bool> {
        self.automatic_failover_enabled
    }
    /// <p>A flag to indicate MultiAZ is enabled.</p>
    pub fn multi_az_enabled(&self) -> std::option::Option<bool> {
        self.multi_az_enabled
    }
    /// <p>Deprecated. This parameter is not used.</p>
    pub fn node_group_id(&self) -> std::option::Option<&str> {
        self.node_group_id.as_deref()
    }
    /// <p>A list of cache security group names to authorize for the clusters in this replication group. This change is asynchronously applied as soon as possible.</p>
    /// <p>This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
    /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.</p>
    pub fn cache_security_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.cache_security_group_names.as_deref()
    }
    /// <p>Specifies the VPC Security Groups associated with the clusters in the replication group.</p>
    /// <p>This parameter can be used only with replication group containing clusters running in an Amazon Virtual Private Cloud (Amazon VPC).</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
    /// <p>Valid values for <code>ddd</code> are:</p>
    /// <ul>
    /// <li> <p> <code>sun</code> </p> </li>
    /// <li> <p> <code>mon</code> </p> </li>
    /// <li> <p> <code>tue</code> </p> </li>
    /// <li> <p> <code>wed</code> </p> </li>
    /// <li> <p> <code>thu</code> </p> </li>
    /// <li> <p> <code>fri</code> </p> </li>
    /// <li> <p> <code>sat</code> </p> </li>
    /// </ul>
    /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
    /// <p>The Amazon SNS topic owner must be same as the replication group owner. </p>
    /// </note>
    pub fn notification_topic_arn(&self) -> std::option::Option<&str> {
        self.notification_topic_arn.as_deref()
    }
    /// <p>The name of the cache parameter group to apply to all of the clusters in this replication group. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
    pub fn cache_parameter_group_name(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_name.as_deref()
    }
    /// <p>The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the status is <code>active</code>.</p>
    /// <p>Valid values: <code>active</code> | <code>inactive</code> </p>
    pub fn notification_topic_status(&self) -> std::option::Option<&str> {
        self.notification_topic_status.as_deref()
    }
    /// <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the replication group.</p>
    /// <p>If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p>
    /// <p>Valid values: <code>true</code> | <code>false</code> </p>
    /// <p>Default: <code>false</code> </p>
    pub fn apply_immediately(&self) -> bool {
        self.apply_immediately
    }
    /// <p>The upgraded version of the cache engine to be run on the clusters in the replication group.</p>
    /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing replication group and create it anew with the earlier engine version. </p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
    pub fn auto_minor_version_upgrade(&self) -> std::option::Option<bool> {
        self.auto_minor_version_upgrade
    }
    /// <p>The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
    /// <p> <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
    pub fn snapshot_retention_limit(&self) -> std::option::Option<i32> {
        self.snapshot_retention_limit
    }
    /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group (shard) specified by <code>SnapshottingClusterId</code>.</p>
    /// <p>Example: <code>05:00-09:00</code> </p>
    /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>
    pub fn snapshot_window(&self) -> std::option::Option<&str> {
        self.snapshot_window.as_deref()
    }
    /// <p>A valid cache node type that you want to scale this replication group to.</p>
    pub fn cache_node_type(&self) -> std::option::Option<&str> {
        self.cache_node_type.as_deref()
    }
    /// <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update-strategy </code> parameter. Password constraints:</p>
    /// <ul>
    /// <li> <p>Must be only printable ASCII characters</p> </li>
    /// <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>
    /// <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>
    /// </ul>
    /// <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
    pub fn auth_token(&self) -> std::option::Option<&str> {
        self.auth_token.as_deref()
    }
    /// <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>
    /// <ul>
    /// <li> <p>Rotate</p> </li>
    /// <li> <p>Set</p> </li>
    /// </ul>
    /// <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
    pub fn auth_token_update_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AuthTokenUpdateStrategyType> {
        self.auth_token_update_strategy.as_ref()
    }
    /// <p>The ID of the user group you are associating with the replication group.</p>
    pub fn user_group_ids_to_add(&self) -> std::option::Option<&[std::string::String]> {
        self.user_group_ids_to_add.as_deref()
    }
    /// <p>The ID of the user group to disassociate from the replication group, meaning the users in the group no longer can access the replication group.</p>
    pub fn user_group_ids_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.user_group_ids_to_remove.as_deref()
    }
    /// <p>Removes the user group associated with this replication group.</p>
    pub fn remove_user_groups(&self) -> std::option::Option<bool> {
        self.remove_user_groups
    }
    /// <p>Specifies the destination, format and type of the logs.</p>
    pub fn log_delivery_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::LogDeliveryConfigurationRequest]> {
        self.log_delivery_configurations.as_deref()
    }
}
impl std::fmt::Debug for ModifyReplicationGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyReplicationGroupInput");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field(
            "replication_group_description",
            &self.replication_group_description,
        );
        formatter.field("primary_cluster_id", &self.primary_cluster_id);
        formatter.field("snapshotting_cluster_id", &self.snapshotting_cluster_id);
        formatter.field(
            "automatic_failover_enabled",
            &self.automatic_failover_enabled,
        );
        formatter.field("multi_az_enabled", &self.multi_az_enabled);
        formatter.field("node_group_id", &self.node_group_id);
        formatter.field(
            "cache_security_group_names",
            &self.cache_security_group_names,
        );
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("notification_topic_arn", &self.notification_topic_arn);
        formatter.field(
            "cache_parameter_group_name",
            &self.cache_parameter_group_name,
        );
        formatter.field("notification_topic_status", &self.notification_topic_status);
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("snapshot_retention_limit", &self.snapshot_retention_limit);
        formatter.field("snapshot_window", &self.snapshot_window);
        formatter.field("cache_node_type", &self.cache_node_type);
        formatter.field("auth_token", &self.auth_token);
        formatter.field(
            "auth_token_update_strategy",
            &self.auth_token_update_strategy,
        );
        formatter.field("user_group_ids_to_add", &self.user_group_ids_to_add);
        formatter.field("user_group_ids_to_remove", &self.user_group_ids_to_remove);
        formatter.field("remove_user_groups", &self.remove_user_groups);
        formatter.field(
            "log_delivery_configurations",
            &self.log_delivery_configurations,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub global_replication_group_id: std::option::Option<std::string::String>,
    /// <p>This parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to be applied in PreferredMaintenceWindow. </p>
    pub apply_immediately: bool,
    /// <p>A valid cache node type that you want to scale this Global datastore to.</p>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>The upgraded version of the cache engine to be run on the clusters in the Global datastore. </p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The name of the cache parameter group to use with the Global datastore. It must be compatible with the major engine version used by the Global datastore.</p>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A description of the Global datastore</p>
    pub global_replication_group_description: std::option::Option<std::string::String>,
    /// <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure. </p>
    pub automatic_failover_enabled: std::option::Option<bool>,
}
impl ModifyGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub fn global_replication_group_id(&self) -> std::option::Option<&str> {
        self.global_replication_group_id.as_deref()
    }
    /// <p>This parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to be applied in PreferredMaintenceWindow. </p>
    pub fn apply_immediately(&self) -> bool {
        self.apply_immediately
    }
    /// <p>A valid cache node type that you want to scale this Global datastore to.</p>
    pub fn cache_node_type(&self) -> std::option::Option<&str> {
        self.cache_node_type.as_deref()
    }
    /// <p>The upgraded version of the cache engine to be run on the clusters in the Global datastore. </p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The name of the cache parameter group to use with the Global datastore. It must be compatible with the major engine version used by the Global datastore.</p>
    pub fn cache_parameter_group_name(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_name.as_deref()
    }
    /// <p>A description of the Global datastore</p>
    pub fn global_replication_group_description(&self) -> std::option::Option<&str> {
        self.global_replication_group_description.as_deref()
    }
    /// <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure. </p>
    pub fn automatic_failover_enabled(&self) -> std::option::Option<bool> {
        self.automatic_failover_enabled
    }
}
impl std::fmt::Debug for ModifyGlobalReplicationGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyGlobalReplicationGroupInput");
        formatter.field(
            "global_replication_group_id",
            &self.global_replication_group_id,
        );
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.field("cache_node_type", &self.cache_node_type);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "cache_parameter_group_name",
            &self.cache_parameter_group_name,
        );
        formatter.field(
            "global_replication_group_description",
            &self.global_replication_group_description,
        );
        formatter.field(
            "automatic_failover_enabled",
            &self.automatic_failover_enabled,
        );
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ModifyCacheSubnetGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyCacheSubnetGroupInput {
    /// <p>The name for the cache subnet group. This value is stored as a lowercase string.</p>
    /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
    /// <p>Example: <code>mysubnetgroup</code> </p>
    pub cache_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A description of the cache subnet group.</p>
    pub cache_subnet_group_description: std::option::Option<std::string::String>,
    /// <p>The EC2 subnet IDs for the cache subnet group.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ModifyCacheSubnetGroupInput {
    /// <p>The name for the cache subnet group. This value is stored as a lowercase string.</p>
    /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
    /// <p>Example: <code>mysubnetgroup</code> </p>
    pub fn cache_subnet_group_name(&self) -> std::option::Option<&str> {
        self.cache_subnet_group_name.as_deref()
    }
    /// <p>A description of the cache subnet group.</p>
    pub fn cache_subnet_group_description(&self) -> std::option::Option<&str> {
        self.cache_subnet_group_description.as_deref()
    }
    /// <p>The EC2 subnet IDs for the cache subnet group.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
}
impl std::fmt::Debug for ModifyCacheSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyCacheSubnetGroupInput");
        formatter.field("cache_subnet_group_name", &self.cache_subnet_group_name);
        formatter.field(
            "cache_subnet_group_description",
            &self.cache_subnet_group_description,
        );
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ModifyCacheParameterGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyCacheParameterGroupInput {
    /// <p>The name of the cache parameter group to modify.</p>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.</p>
    pub parameter_name_values: std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
}
impl ModifyCacheParameterGroupInput {
    /// <p>The name of the cache parameter group to modify.</p>
    pub fn cache_parameter_group_name(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_name.as_deref()
    }
    /// <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.</p>
    pub fn parameter_name_values(
        &self,
    ) -> std::option::Option<&[crate::model::ParameterNameValue]> {
        self.parameter_name_values.as_deref()
    }
}
impl std::fmt::Debug for ModifyCacheParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyCacheParameterGroupInput");
        formatter.field(
            "cache_parameter_group_name",
            &self.cache_parameter_group_name,
        );
        formatter.field("parameter_name_values", &self.parameter_name_values);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ModifyCacheCluster</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyCacheClusterInput {
    /// <p>The cluster identifier. This value is stored as a lowercase string.</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>The number of cache nodes that the cluster should have. If the value for <code>NumCacheNodes</code> is greater than the sum of the number of current cache nodes and the number of cache nodes pending creation (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes, nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove requests are canceled.</p>
    /// <p>If you are removing cache nodes, you must use the <code>CacheNodeIdsToRemove</code> parameter to provide the IDs of the specific cache nodes to remove.</p>
    /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p> <note>
    /// <p>Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see <code>ApplyImmediately</code>).</p>
    /// <p>A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The customer's latest request to add or remove nodes to the cluster overrides any previous pending operations to modify the number of cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache nodes may now be provisioned in different Availability Zones with flexible cache node placement, a request to add nodes does not automatically override a previous pending operation to add nodes. The customer can modify the previous pending operation to add more nodes or explicitly cancel the pending request and retry the new request. To cancel pending operations to modify the number of cache nodes in a cluster, use the <code>ModifyCacheCluster</code> request and set <code>NumCacheNodes</code> equal to the number of cache nodes currently in the cluster.</p>
    /// </note>
    pub num_cache_nodes: std::option::Option<i32>,
    /// <p>A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter is only valid when <code>NumCacheNodes</code> is less than the existing number of cache nodes. The number of cache node IDs supplied in this parameter must match the difference between the existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the value of <code>NumCacheNodes</code> in the request.</p>
    /// <p>For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.</p>
    pub cache_node_ids_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or created across multiple Availability Zones.</p>
    /// <p>Valid values: <code>single-az</code> | <code>cross-az</code>.</p>
    /// <p>This option is only supported for Memcached clusters.</p> <note>
    /// <p>You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone.</p>
    /// <p>Only newly created nodes are located in different Availability Zones. </p>
    /// </note>
    pub az_mode: std::option::Option<crate::model::AzMode>,
    /// <note>
    /// <p>This option is only supported on Memcached clusters.</p>
    /// </note>
    /// <p>The list of Availability Zones where the new Memcached cache nodes are created.</p>
    /// <p>This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of the number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number of Availability Zones supplied in this list must match the cache nodes being added in this request.</p>
    /// <p>Scenarios:</p>
    /// <ul>
    /// <li> <p> <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify <code>NumCacheNodes=5</code> (3 + 2) and optionally specify two Availability Zones for the two new nodes.</p> </li>
    /// <li> <p> <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an Availability Zone for the new node.</p> </li>
    /// <li> <p> <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to cancel all pending operations.</p> </li>
    /// </ul>
    /// <p>The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current nodes.</p>
    /// <p>If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing Memcached nodes to different Availability Zones, see the <b>Availability Zone Considerations</b> section of <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html">Cache Node Considerations for Memcached</a>.</p>
    /// <p> <b>Impact of new add/remove requests upon pending requests</b> </p>
    /// <ul>
    /// <li> <p>Scenario-1</p>
    /// <ul>
    /// <li> <p>Pending Action: Delete</p> </li>
    /// <li> <p>New Request: Delete</p> </li>
    /// <li> <p>Result: The new delete, pending or immediate, replaces the pending delete.</p> </li>
    /// </ul> </li>
    /// <li> <p>Scenario-2</p>
    /// <ul>
    /// <li> <p>Pending Action: Delete</p> </li>
    /// <li> <p>New Request: Create</p> </li>
    /// <li> <p>Result: The new create, pending or immediate, replaces the pending delete.</p> </li>
    /// </ul> </li>
    /// <li> <p>Scenario-3</p>
    /// <ul>
    /// <li> <p>Pending Action: Create</p> </li>
    /// <li> <p>New Request: Delete</p> </li>
    /// <li> <p>Result: The new delete, pending or immediate, replaces the pending create.</p> </li>
    /// </ul> </li>
    /// <li> <p>Scenario-4</p>
    /// <ul>
    /// <li> <p>Pending Action: Create</p> </li>
    /// <li> <p>New Request: Create</p> </li>
    /// <li> <p>Result: The new create is added to the pending create.</p> <important>
    /// <p> <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are performed immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are pending.</p>
    /// </important> </li>
    /// </ul> </li>
    /// </ul>
    pub new_availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of cache security group names to authorize on this cluster. This change is asynchronously applied as soon as possible.</p>
    /// <p>You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
    /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".</p>
    pub cache_security_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the VPC Security Groups associated with the cluster.</p>
    /// <p>This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon VPC).</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
    /// <p>Valid values for <code>ddd</code> are:</p>
    /// <ul>
    /// <li> <p> <code>sun</code> </p> </li>
    /// <li> <p> <code>mon</code> </p> </li>
    /// <li> <p> <code>tue</code> </p> </li>
    /// <li> <p> <code>wed</code> </p> </li>
    /// <li> <p> <code>thu</code> </p> </li>
    /// <li> <p> <code>fri</code> </p> </li>
    /// <li> <p> <code>sat</code> </p> </li>
    /// </ul>
    /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
    /// <p>The Amazon SNS topic owner must be same as the cluster owner.</p>
    /// </note>
    pub notification_topic_arn: std::option::Option<std::string::String>,
    /// <p>The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is <code>active</code>.</p>
    /// <p>Valid values: <code>active</code> | <code>inactive</code> </p>
    pub notification_topic_status: std::option::Option<std::string::String>,
    /// <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the cluster.</p>
    /// <p>If <code>false</code>, changes to the cluster are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p> <important>
    /// <p>If you perform a <code>ModifyCacheCluster</code> before a pending modification is applied, the pending modification is replaced by the newer modification.</p>
    /// </important>
    /// <p>Valid values: <code>true</code> | <code>false</code> </p>
    /// <p>Default: <code>false</code> </p>
    pub apply_immediately: bool,
    /// <p>The upgraded version of the cache engine to be run on the cache nodes.</p>
    /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version. </p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
    pub auto_minor_version_upgrade: std::option::Option<bool>,
    /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <note>
    /// <p>If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p>
    /// </note>
    pub snapshot_retention_limit: std::option::Option<i32>,
    /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster. </p>
    pub snapshot_window: std::option::Option<std::string::String>,
    /// <p>A valid cache node type that you want to scale this cluster up to.</p>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update</code> parameter. Password constraints:</p>
    /// <ul>
    /// <li> <p>Must be only printable ASCII characters</p> </li>
    /// <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>
    /// <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>
    /// </ul>
    /// <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
    pub auth_token: std::option::Option<std::string::String>,
    /// <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>
    /// <ul>
    /// <li> <p>Rotate</p> </li>
    /// <li> <p>Set</p> </li>
    /// </ul>
    /// <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
    pub auth_token_update_strategy: std::option::Option<crate::model::AuthTokenUpdateStrategyType>,
    /// <p>Specifies the destination, format and type of the logs.</p>
    pub log_delivery_configurations:
        std::option::Option<std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>>,
}
impl ModifyCacheClusterInput {
    /// <p>The cluster identifier. This value is stored as a lowercase string.</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>The number of cache nodes that the cluster should have. If the value for <code>NumCacheNodes</code> is greater than the sum of the number of current cache nodes and the number of cache nodes pending creation (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes, nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove requests are canceled.</p>
    /// <p>If you are removing cache nodes, you must use the <code>CacheNodeIdsToRemove</code> parameter to provide the IDs of the specific cache nodes to remove.</p>
    /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p> <note>
    /// <p>Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see <code>ApplyImmediately</code>).</p>
    /// <p>A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The customer's latest request to add or remove nodes to the cluster overrides any previous pending operations to modify the number of cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache nodes may now be provisioned in different Availability Zones with flexible cache node placement, a request to add nodes does not automatically override a previous pending operation to add nodes. The customer can modify the previous pending operation to add more nodes or explicitly cancel the pending request and retry the new request. To cancel pending operations to modify the number of cache nodes in a cluster, use the <code>ModifyCacheCluster</code> request and set <code>NumCacheNodes</code> equal to the number of cache nodes currently in the cluster.</p>
    /// </note>
    pub fn num_cache_nodes(&self) -> std::option::Option<i32> {
        self.num_cache_nodes
    }
    /// <p>A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter is only valid when <code>NumCacheNodes</code> is less than the existing number of cache nodes. The number of cache node IDs supplied in this parameter must match the difference between the existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the value of <code>NumCacheNodes</code> in the request.</p>
    /// <p>For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.</p>
    pub fn cache_node_ids_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.cache_node_ids_to_remove.as_deref()
    }
    /// <p>Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or created across multiple Availability Zones.</p>
    /// <p>Valid values: <code>single-az</code> | <code>cross-az</code>.</p>
    /// <p>This option is only supported for Memcached clusters.</p> <note>
    /// <p>You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone.</p>
    /// <p>Only newly created nodes are located in different Availability Zones. </p>
    /// </note>
    pub fn az_mode(&self) -> std::option::Option<&crate::model::AzMode> {
        self.az_mode.as_ref()
    }
    /// <note>
    /// <p>This option is only supported on Memcached clusters.</p>
    /// </note>
    /// <p>The list of Availability Zones where the new Memcached cache nodes are created.</p>
    /// <p>This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of the number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number of Availability Zones supplied in this list must match the cache nodes being added in this request.</p>
    /// <p>Scenarios:</p>
    /// <ul>
    /// <li> <p> <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify <code>NumCacheNodes=5</code> (3 + 2) and optionally specify two Availability Zones for the two new nodes.</p> </li>
    /// <li> <p> <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an Availability Zone for the new node.</p> </li>
    /// <li> <p> <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to cancel all pending operations.</p> </li>
    /// </ul>
    /// <p>The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current nodes.</p>
    /// <p>If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing Memcached nodes to different Availability Zones, see the <b>Availability Zone Considerations</b> section of <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html">Cache Node Considerations for Memcached</a>.</p>
    /// <p> <b>Impact of new add/remove requests upon pending requests</b> </p>
    /// <ul>
    /// <li> <p>Scenario-1</p>
    /// <ul>
    /// <li> <p>Pending Action: Delete</p> </li>
    /// <li> <p>New Request: Delete</p> </li>
    /// <li> <p>Result: The new delete, pending or immediate, replaces the pending delete.</p> </li>
    /// </ul> </li>
    /// <li> <p>Scenario-2</p>
    /// <ul>
    /// <li> <p>Pending Action: Delete</p> </li>
    /// <li> <p>New Request: Create</p> </li>
    /// <li> <p>Result: The new create, pending or immediate, replaces the pending delete.</p> </li>
    /// </ul> </li>
    /// <li> <p>Scenario-3</p>
    /// <ul>
    /// <li> <p>Pending Action: Create</p> </li>
    /// <li> <p>New Request: Delete</p> </li>
    /// <li> <p>Result: The new delete, pending or immediate, replaces the pending create.</p> </li>
    /// </ul> </li>
    /// <li> <p>Scenario-4</p>
    /// <ul>
    /// <li> <p>Pending Action: Create</p> </li>
    /// <li> <p>New Request: Create</p> </li>
    /// <li> <p>Result: The new create is added to the pending create.</p> <important>
    /// <p> <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are performed immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are pending.</p>
    /// </important> </li>
    /// </ul> </li>
    /// </ul>
    pub fn new_availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.new_availability_zones.as_deref()
    }
    /// <p>A list of cache security group names to authorize on this cluster. This change is asynchronously applied as soon as possible.</p>
    /// <p>You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
    /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".</p>
    pub fn cache_security_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.cache_security_group_names.as_deref()
    }
    /// <p>Specifies the VPC Security Groups associated with the cluster.</p>
    /// <p>This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon VPC).</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
    /// <p>Valid values for <code>ddd</code> are:</p>
    /// <ul>
    /// <li> <p> <code>sun</code> </p> </li>
    /// <li> <p> <code>mon</code> </p> </li>
    /// <li> <p> <code>tue</code> </p> </li>
    /// <li> <p> <code>wed</code> </p> </li>
    /// <li> <p> <code>thu</code> </p> </li>
    /// <li> <p> <code>fri</code> </p> </li>
    /// <li> <p> <code>sat</code> </p> </li>
    /// </ul>
    /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
    /// <p>The Amazon SNS topic owner must be same as the cluster owner.</p>
    /// </note>
    pub fn notification_topic_arn(&self) -> std::option::Option<&str> {
        self.notification_topic_arn.as_deref()
    }
    /// <p>The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
    pub fn cache_parameter_group_name(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_name.as_deref()
    }
    /// <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is <code>active</code>.</p>
    /// <p>Valid values: <code>active</code> | <code>inactive</code> </p>
    pub fn notification_topic_status(&self) -> std::option::Option<&str> {
        self.notification_topic_status.as_deref()
    }
    /// <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the cluster.</p>
    /// <p>If <code>false</code>, changes to the cluster are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p> <important>
    /// <p>If you perform a <code>ModifyCacheCluster</code> before a pending modification is applied, the pending modification is replaced by the newer modification.</p>
    /// </important>
    /// <p>Valid values: <code>true</code> | <code>false</code> </p>
    /// <p>Default: <code>false</code> </p>
    pub fn apply_immediately(&self) -> bool {
        self.apply_immediately
    }
    /// <p>The upgraded version of the cache engine to be run on the cache nodes.</p>
    /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version. </p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
    pub fn auto_minor_version_upgrade(&self) -> std::option::Option<bool> {
        self.auto_minor_version_upgrade
    }
    /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <note>
    /// <p>If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p>
    /// </note>
    pub fn snapshot_retention_limit(&self) -> std::option::Option<i32> {
        self.snapshot_retention_limit
    }
    /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster. </p>
    pub fn snapshot_window(&self) -> std::option::Option<&str> {
        self.snapshot_window.as_deref()
    }
    /// <p>A valid cache node type that you want to scale this cluster up to.</p>
    pub fn cache_node_type(&self) -> std::option::Option<&str> {
        self.cache_node_type.as_deref()
    }
    /// <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update</code> parameter. Password constraints:</p>
    /// <ul>
    /// <li> <p>Must be only printable ASCII characters</p> </li>
    /// <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>
    /// <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>
    /// </ul>
    /// <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
    pub fn auth_token(&self) -> std::option::Option<&str> {
        self.auth_token.as_deref()
    }
    /// <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>
    /// <ul>
    /// <li> <p>Rotate</p> </li>
    /// <li> <p>Set</p> </li>
    /// </ul>
    /// <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
    pub fn auth_token_update_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AuthTokenUpdateStrategyType> {
        self.auth_token_update_strategy.as_ref()
    }
    /// <p>Specifies the destination, format and type of the logs.</p>
    pub fn log_delivery_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::LogDeliveryConfigurationRequest]> {
        self.log_delivery_configurations.as_deref()
    }
}
impl std::fmt::Debug for ModifyCacheClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyCacheClusterInput");
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("num_cache_nodes", &self.num_cache_nodes);
        formatter.field("cache_node_ids_to_remove", &self.cache_node_ids_to_remove);
        formatter.field("az_mode", &self.az_mode);
        formatter.field("new_availability_zones", &self.new_availability_zones);
        formatter.field(
            "cache_security_group_names",
            &self.cache_security_group_names,
        );
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("notification_topic_arn", &self.notification_topic_arn);
        formatter.field(
            "cache_parameter_group_name",
            &self.cache_parameter_group_name,
        );
        formatter.field("notification_topic_status", &self.notification_topic_status);
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("snapshot_retention_limit", &self.snapshot_retention_limit);
        formatter.field("snapshot_window", &self.snapshot_window);
        formatter.field("cache_node_type", &self.cache_node_type);
        formatter.field("auth_token", &self.auth_token);
        formatter.field(
            "auth_token_update_strategy",
            &self.auth_token_update_strategy,
        );
        formatter.field(
            "log_delivery_configurations",
            &self.log_delivery_configurations,
        );
        formatter.finish()
    }
}

/// <p>The input parameters for the <code>ListTagsForResource</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>
    /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>
    /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

/// <p>The input parameters for the <code>ListAllowedNodeTypeModifications</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAllowedNodeTypeModificationsInput {
    /// <p>The name of the cluster you want to scale up to a larger node instanced type. ElastiCache uses the cluster id to identify the current node type of this cluster and from that to create a list of node types you can scale up to.</p> <important>
    /// <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>
    /// </important>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>The name of the replication group want to scale up to a larger node type. ElastiCache uses the replication group id to identify the current node type being used by this replication group, and from that to create a list of node types you can scale up to.</p> <important>
    /// <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>
    /// </important>
    pub replication_group_id: std::option::Option<std::string::String>,
}
impl ListAllowedNodeTypeModificationsInput {
    /// <p>The name of the cluster you want to scale up to a larger node instanced type. ElastiCache uses the cluster id to identify the current node type of this cluster and from that to create a list of node types you can scale up to.</p> <important>
    /// <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>
    /// </important>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>The name of the replication group want to scale up to a larger node type. ElastiCache uses the replication group id to identify the current node type being used by this replication group, and from that to create a list of node types you can scale up to.</p> <important>
    /// <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>
    /// </important>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
}
impl std::fmt::Debug for ListAllowedNodeTypeModificationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAllowedNodeTypeModificationsInput");
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncreaseReplicaCountInput {
    /// <p>The id of the replication group to which you want to add replica nodes.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>
    pub new_replica_count: std::option::Option<i32>,
    /// <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
    pub replica_configuration: std::option::Option<std::vec::Vec<crate::model::ConfigureShard>>,
    /// <p>If <code>True</code>, the number of replica nodes is increased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
    pub apply_immediately: bool,
}
impl IncreaseReplicaCountInput {
    /// <p>The id of the replication group to which you want to add replica nodes.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>
    pub fn new_replica_count(&self) -> std::option::Option<i32> {
        self.new_replica_count
    }
    /// <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
    pub fn replica_configuration(&self) -> std::option::Option<&[crate::model::ConfigureShard]> {
        self.replica_configuration.as_deref()
    }
    /// <p>If <code>True</code>, the number of replica nodes is increased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
    pub fn apply_immediately(&self) -> bool {
        self.apply_immediately
    }
}
impl std::fmt::Debug for IncreaseReplicaCountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncreaseReplicaCountInput");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("new_replica_count", &self.new_replica_count);
        formatter.field("replica_configuration", &self.replica_configuration);
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncreaseNodeGroupsInGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub global_replication_group_id: std::option::Option<std::string::String>,
    /// <p>The number of node groups you wish to add</p>
    pub node_group_count: i32,
    /// <p>Describes the replication group IDs, the Amazon regions where they are stored and the shard configuration for each that comprise the Global datastore</p>
    pub regional_configurations:
        std::option::Option<std::vec::Vec<crate::model::RegionalConfiguration>>,
    /// <p>Indicates that the process begins immediately. At present, the only permitted value for this parameter is true.</p>
    pub apply_immediately: bool,
}
impl IncreaseNodeGroupsInGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub fn global_replication_group_id(&self) -> std::option::Option<&str> {
        self.global_replication_group_id.as_deref()
    }
    /// <p>The number of node groups you wish to add</p>
    pub fn node_group_count(&self) -> i32 {
        self.node_group_count
    }
    /// <p>Describes the replication group IDs, the Amazon regions where they are stored and the shard configuration for each that comprise the Global datastore</p>
    pub fn regional_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::RegionalConfiguration]> {
        self.regional_configurations.as_deref()
    }
    /// <p>Indicates that the process begins immediately. At present, the only permitted value for this parameter is true.</p>
    pub fn apply_immediately(&self) -> bool {
        self.apply_immediately
    }
}
impl std::fmt::Debug for IncreaseNodeGroupsInGlobalReplicationGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncreaseNodeGroupsInGlobalReplicationGroupInput");
        formatter.field(
            "global_replication_group_id",
            &self.global_replication_group_id,
        );
        formatter.field("node_group_count", &self.node_group_count);
        formatter.field("regional_configurations", &self.regional_configurations);
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailoverGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub global_replication_group_id: std::option::Option<std::string::String>,
    /// <p>The Amazon region of the primary cluster of the Global datastore</p>
    pub primary_region: std::option::Option<std::string::String>,
    /// <p>The name of the primary replication group</p>
    pub primary_replication_group_id: std::option::Option<std::string::String>,
}
impl FailoverGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub fn global_replication_group_id(&self) -> std::option::Option<&str> {
        self.global_replication_group_id.as_deref()
    }
    /// <p>The Amazon region of the primary cluster of the Global datastore</p>
    pub fn primary_region(&self) -> std::option::Option<&str> {
        self.primary_region.as_deref()
    }
    /// <p>The name of the primary replication group</p>
    pub fn primary_replication_group_id(&self) -> std::option::Option<&str> {
        self.primary_replication_group_id.as_deref()
    }
}
impl std::fmt::Debug for FailoverGlobalReplicationGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailoverGlobalReplicationGroupInput");
        formatter.field(
            "global_replication_group_id",
            &self.global_replication_group_id,
        );
        formatter.field("primary_region", &self.primary_region);
        formatter.field(
            "primary_replication_group_id",
            &self.primary_replication_group_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub global_replication_group_id: std::option::Option<std::string::String>,
    /// <p>The name of the secondary cluster you wish to remove from the Global datastore</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The Amazon region of secondary cluster you wish to remove from the Global datastore</p>
    pub replication_group_region: std::option::Option<std::string::String>,
}
impl DisassociateGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub fn global_replication_group_id(&self) -> std::option::Option<&str> {
        self.global_replication_group_id.as_deref()
    }
    /// <p>The name of the secondary cluster you wish to remove from the Global datastore</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The Amazon region of secondary cluster you wish to remove from the Global datastore</p>
    pub fn replication_group_region(&self) -> std::option::Option<&str> {
        self.replication_group_region.as_deref()
    }
}
impl std::fmt::Debug for DisassociateGlobalReplicationGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateGlobalReplicationGroupInput");
        formatter.field(
            "global_replication_group_id",
            &self.global_replication_group_id,
        );
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("replication_group_region", &self.replication_group_region);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUsersInput {
    /// <p>The Redis engine. </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>Filter to determine the list of User IDs to return.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeUsersInput {
    /// <p>The Redis engine. </p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The ID of the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>Filter to determine the list of User IDs to return.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeUsersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUsersInput");
        formatter.field("engine", &self.engine);
        formatter.field("user_id", &self.user_id);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserGroupsInput {
    /// <p>The ID of the user group.</p>
    pub user_group_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeUserGroupsInput {
    /// <p>The ID of the user group.</p>
    pub fn user_group_id(&self) -> std::option::Option<&str> {
        self.user_group_id.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeUserGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserGroupsInput");
        formatter.field("user_group_id", &self.user_group_id);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUpdateActionsInput {
    /// <p>The unique ID of the service update</p>
    pub service_update_name: std::option::Option<std::string::String>,
    /// <p>The replication group IDs</p>
    pub replication_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The cache cluster IDs</p>
    pub cache_cluster_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The status of the service update</p>
    pub service_update_status:
        std::option::Option<std::vec::Vec<crate::model::ServiceUpdateStatus>>,
    /// <p>The range of time specified to search for service updates that are in available status</p>
    pub service_update_time_range: std::option::Option<crate::model::TimeRangeFilter>,
    /// <p>The status of the update action.</p>
    pub update_action_status: std::option::Option<std::vec::Vec<crate::model::UpdateActionStatus>>,
    /// <p>Dictates whether to include node level update status in the response </p>
    pub show_node_level_update_status: std::option::Option<bool>,
    /// <p>The maximum number of records to include in the response</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeUpdateActionsInput {
    /// <p>The unique ID of the service update</p>
    pub fn service_update_name(&self) -> std::option::Option<&str> {
        self.service_update_name.as_deref()
    }
    /// <p>The replication group IDs</p>
    pub fn replication_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.replication_group_ids.as_deref()
    }
    /// <p>The cache cluster IDs</p>
    pub fn cache_cluster_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.cache_cluster_ids.as_deref()
    }
    /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached </p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The status of the service update</p>
    pub fn service_update_status(
        &self,
    ) -> std::option::Option<&[crate::model::ServiceUpdateStatus]> {
        self.service_update_status.as_deref()
    }
    /// <p>The range of time specified to search for service updates that are in available status</p>
    pub fn service_update_time_range(&self) -> std::option::Option<&crate::model::TimeRangeFilter> {
        self.service_update_time_range.as_ref()
    }
    /// <p>The status of the update action.</p>
    pub fn update_action_status(&self) -> std::option::Option<&[crate::model::UpdateActionStatus]> {
        self.update_action_status.as_deref()
    }
    /// <p>Dictates whether to include node level update status in the response </p>
    pub fn show_node_level_update_status(&self) -> std::option::Option<bool> {
        self.show_node_level_update_status
    }
    /// <p>The maximum number of records to include in the response</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeUpdateActionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUpdateActionsInput");
        formatter.field("service_update_name", &self.service_update_name);
        formatter.field("replication_group_ids", &self.replication_group_ids);
        formatter.field("cache_cluster_ids", &self.cache_cluster_ids);
        formatter.field("engine", &self.engine);
        formatter.field("service_update_status", &self.service_update_status);
        formatter.field("service_update_time_range", &self.service_update_time_range);
        formatter.field("update_action_status", &self.update_action_status);
        formatter.field(
            "show_node_level_update_status",
            &self.show_node_level_update_status,
        );
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeSnapshotsMessage</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSnapshotsInput {
    /// <p>A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with that specific replication group are described.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.</p>
    pub snapshot_name: std::option::Option<std::string::String>,
    /// <p>If set to <code>system</code>, the output shows snapshots that were automatically created by ElastiCache. If set to <code>user</code> the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
    pub snapshot_source: std::option::Option<std::string::String>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 50</p>
    /// <p>Constraints: minimum 20; maximum 50.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>A Boolean value which if true, the node group (shard) configuration is included in the snapshot description.</p>
    pub show_node_group_config: std::option::Option<bool>,
}
impl DescribeSnapshotsInput {
    /// <p>A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with that specific replication group are described.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.</p>
    pub fn snapshot_name(&self) -> std::option::Option<&str> {
        self.snapshot_name.as_deref()
    }
    /// <p>If set to <code>system</code>, the output shows snapshots that were automatically created by ElastiCache. If set to <code>user</code> the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
    pub fn snapshot_source(&self) -> std::option::Option<&str> {
        self.snapshot_source.as_deref()
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 50</p>
    /// <p>Constraints: minimum 20; maximum 50.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>A Boolean value which if true, the node group (shard) configuration is included in the snapshot description.</p>
    pub fn show_node_group_config(&self) -> std::option::Option<bool> {
        self.show_node_group_config
    }
}
impl std::fmt::Debug for DescribeSnapshotsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSnapshotsInput");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("snapshot_name", &self.snapshot_name);
        formatter.field("snapshot_source", &self.snapshot_source);
        formatter.field("marker", &self.marker);
        formatter.field("max_records", &self.max_records);
        formatter.field("show_node_group_config", &self.show_node_group_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServiceUpdatesInput {
    /// <p>The unique ID of the service update</p>
    pub service_update_name: std::option::Option<std::string::String>,
    /// <p>The status of the service update</p>
    pub service_update_status:
        std::option::Option<std::vec::Vec<crate::model::ServiceUpdateStatus>>,
    /// <p>The maximum number of records to include in the response</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeServiceUpdatesInput {
    /// <p>The unique ID of the service update</p>
    pub fn service_update_name(&self) -> std::option::Option<&str> {
        self.service_update_name.as_deref()
    }
    /// <p>The status of the service update</p>
    pub fn service_update_status(
        &self,
    ) -> std::option::Option<&[crate::model::ServiceUpdateStatus]> {
        self.service_update_status.as_deref()
    }
    /// <p>The maximum number of records to include in the response</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeServiceUpdatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServiceUpdatesInput");
        formatter.field("service_update_name", &self.service_update_name);
        formatter.field("service_update_status", &self.service_update_status);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeReservedCacheNodesOfferings</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedCacheNodesOfferingsInput {
    /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
    /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
    pub reserved_cache_nodes_offering_id: std::option::Option<std::string::String>,
    /// <p>The cache node type filter value. Use this parameter to show only the available offerings matching the specified cache node type.</p>
    /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
    /// <ul>
    /// <li> <p>General purpose:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward) <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
    /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 6.0 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Compute optimized:</p>
    /// <ul>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Memory optimized with data tiering:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Memory optimized:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
    /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p> <b>Additional node type info</b> </p>
    /// <ul>
    /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
    /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
    /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
    /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
    /// </ul>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>Duration filter value, specified in years or seconds. Use this parameter to show only reservations for a given duration.</p>
    /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
    pub duration: std::option::Option<std::string::String>,
    /// <p>The product description filter value. Use this parameter to show only the available offerings matching the specified product description.</p>
    pub product_description: std::option::Option<std::string::String>,
    /// <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>
    /// <p>Valid Values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization" |"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
    pub offering_type: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeReservedCacheNodesOfferingsInput {
    /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
    /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
    pub fn reserved_cache_nodes_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_cache_nodes_offering_id.as_deref()
    }
    /// <p>The cache node type filter value. Use this parameter to show only the available offerings matching the specified cache node type.</p>
    /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
    /// <ul>
    /// <li> <p>General purpose:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward) <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
    /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 6.0 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Compute optimized:</p>
    /// <ul>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Memory optimized with data tiering:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Memory optimized:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
    /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p> <b>Additional node type info</b> </p>
    /// <ul>
    /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
    /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
    /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
    /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
    /// </ul>
    pub fn cache_node_type(&self) -> std::option::Option<&str> {
        self.cache_node_type.as_deref()
    }
    /// <p>Duration filter value, specified in years or seconds. Use this parameter to show only reservations for a given duration.</p>
    /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
    pub fn duration(&self) -> std::option::Option<&str> {
        self.duration.as_deref()
    }
    /// <p>The product description filter value. Use this parameter to show only the available offerings matching the specified product description.</p>
    pub fn product_description(&self) -> std::option::Option<&str> {
        self.product_description.as_deref()
    }
    /// <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>
    /// <p>Valid Values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization" |"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
    pub fn offering_type(&self) -> std::option::Option<&str> {
        self.offering_type.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservedCacheNodesOfferingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedCacheNodesOfferingsInput");
        formatter.field(
            "reserved_cache_nodes_offering_id",
            &self.reserved_cache_nodes_offering_id,
        );
        formatter.field("cache_node_type", &self.cache_node_type);
        formatter.field("duration", &self.duration);
        formatter.field("product_description", &self.product_description);
        formatter.field("offering_type", &self.offering_type);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeReservedCacheNodes</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedCacheNodesInput {
    /// <p>The reserved cache node identifier filter value. Use this parameter to show only the reservation that matches the specified reservation ID.</p>
    pub reserved_cache_node_id: std::option::Option<std::string::String>,
    /// <p>The offering identifier filter value. Use this parameter to show only purchased reservations matching the specified offering identifier.</p>
    pub reserved_cache_nodes_offering_id: std::option::Option<std::string::String>,
    /// <p>The cache node type filter value. Use this parameter to show only those reservations matching the specified cache node type.</p>
    /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
    /// <ul>
    /// <li> <p>General purpose:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
    /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 6.0 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Compute optimized:</p>
    /// <ul>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Memory optimized with data tiering:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Memory optimized:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
    /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p> <b>Additional node type info</b> </p>
    /// <ul>
    /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
    /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
    /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
    /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
    /// </ul>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>The duration filter value, specified in years or seconds. Use this parameter to show only reservations for this duration.</p>
    /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
    pub duration: std::option::Option<std::string::String>,
    /// <p>The product description filter value. Use this parameter to show only those reservations matching the specified product description.</p>
    pub product_description: std::option::Option<std::string::String>,
    /// <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>
    /// <p>Valid values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization"|"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
    pub offering_type: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeReservedCacheNodesInput {
    /// <p>The reserved cache node identifier filter value. Use this parameter to show only the reservation that matches the specified reservation ID.</p>
    pub fn reserved_cache_node_id(&self) -> std::option::Option<&str> {
        self.reserved_cache_node_id.as_deref()
    }
    /// <p>The offering identifier filter value. Use this parameter to show only purchased reservations matching the specified offering identifier.</p>
    pub fn reserved_cache_nodes_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_cache_nodes_offering_id.as_deref()
    }
    /// <p>The cache node type filter value. Use this parameter to show only those reservations matching the specified cache node type.</p>
    /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
    /// <ul>
    /// <li> <p>General purpose:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
    /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 6.0 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Compute optimized:</p>
    /// <ul>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Memory optimized with data tiering:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Memory optimized:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
    /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p> <b>Additional node type info</b> </p>
    /// <ul>
    /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
    /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
    /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
    /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
    /// </ul>
    pub fn cache_node_type(&self) -> std::option::Option<&str> {
        self.cache_node_type.as_deref()
    }
    /// <p>The duration filter value, specified in years or seconds. Use this parameter to show only reservations for this duration.</p>
    /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
    pub fn duration(&self) -> std::option::Option<&str> {
        self.duration.as_deref()
    }
    /// <p>The product description filter value. Use this parameter to show only those reservations matching the specified product description.</p>
    pub fn product_description(&self) -> std::option::Option<&str> {
        self.product_description.as_deref()
    }
    /// <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>
    /// <p>Valid values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization"|"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
    pub fn offering_type(&self) -> std::option::Option<&str> {
        self.offering_type.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservedCacheNodesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedCacheNodesInput");
        formatter.field("reserved_cache_node_id", &self.reserved_cache_node_id);
        formatter.field(
            "reserved_cache_nodes_offering_id",
            &self.reserved_cache_nodes_offering_id,
        );
        formatter.field("cache_node_type", &self.cache_node_type);
        formatter.field("duration", &self.duration);
        formatter.field("product_description", &self.product_description);
        formatter.field("offering_type", &self.offering_type);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeReplicationGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplicationGroupsInput {
    /// <p>The identifier for the replication group to be described. This parameter is not case sensitive.</p>
    /// <p>If you do not specify this parameter, information about all replication groups is returned.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeReplicationGroupsInput {
    /// <p>The identifier for the replication group to be described. This parameter is not case sensitive.</p>
    /// <p>If you do not specify this parameter, information about all replication groups is returned.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeReplicationGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplicationGroupsInput");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGlobalReplicationGroupsInput {
    /// <p>The name of the Global datastore</p>
    pub global_replication_group_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Returns the list of members that comprise the Global datastore.</p>
    pub show_member_info: std::option::Option<bool>,
}
impl DescribeGlobalReplicationGroupsInput {
    /// <p>The name of the Global datastore</p>
    pub fn global_replication_group_id(&self) -> std::option::Option<&str> {
        self.global_replication_group_id.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Returns the list of members that comprise the Global datastore.</p>
    pub fn show_member_info(&self) -> std::option::Option<bool> {
        self.show_member_info
    }
}
impl std::fmt::Debug for DescribeGlobalReplicationGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGlobalReplicationGroupsInput");
        formatter.field(
            "global_replication_group_id",
            &self.global_replication_group_id,
        );
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.field("show_member_info", &self.show_member_info);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeEvents</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsInput {
    /// <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
    pub source_identifier: std::option::Option<std::string::String>,
    /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.</p>
    /// <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.</p>
    /// <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The number of minutes worth of events to retrieve.</p>
    pub duration: std::option::Option<i32>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeEventsInput {
    /// <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
    pub fn source_identifier(&self) -> std::option::Option<&str> {
        self.source_identifier.as_deref()
    }
    /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
    pub fn source_type(&self) -> std::option::Option<&crate::model::SourceType> {
        self.source_type.as_ref()
    }
    /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.</p>
    /// <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.</p>
    /// <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The number of minutes worth of events to retrieve.</p>
    pub fn duration(&self) -> std::option::Option<i32> {
        self.duration
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsInput");
        formatter.field("source_identifier", &self.source_identifier);
        formatter.field("source_type", &self.source_type);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("duration", &self.duration);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeEngineDefaultParameters</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEngineDefaultParametersInput {
    /// <p>The name of the cache parameter group family.</p>
    /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>
    pub cache_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeEngineDefaultParametersInput {
    /// <p>The name of the cache parameter group family.</p>
    /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>
    pub fn cache_parameter_group_family(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_family.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeEngineDefaultParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEngineDefaultParametersInput");
        formatter.field(
            "cache_parameter_group_family",
            &self.cache_parameter_group_family,
        );
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeCacheSubnetGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheSubnetGroupsInput {
    /// <p>The name of the cache subnet group to return details for.</p>
    pub cache_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeCacheSubnetGroupsInput {
    /// <p>The name of the cache subnet group to return details for.</p>
    pub fn cache_subnet_group_name(&self) -> std::option::Option<&str> {
        self.cache_subnet_group_name.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeCacheSubnetGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheSubnetGroupsInput");
        formatter.field("cache_subnet_group_name", &self.cache_subnet_group_name);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeCacheSecurityGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheSecurityGroupsInput {
    /// <p>The name of the cache security group to return details for.</p>
    pub cache_security_group_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeCacheSecurityGroupsInput {
    /// <p>The name of the cache security group to return details for.</p>
    pub fn cache_security_group_name(&self) -> std::option::Option<&str> {
        self.cache_security_group_name.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeCacheSecurityGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheSecurityGroupsInput");
        formatter.field("cache_security_group_name", &self.cache_security_group_name);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeCacheParameters</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheParametersInput {
    /// <p>The name of a specific cache parameter group to return details for.</p>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The parameter types to return.</p>
    /// <p>Valid values: <code>user</code> | <code>system</code> | <code>engine-default</code> </p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeCacheParametersInput {
    /// <p>The name of a specific cache parameter group to return details for.</p>
    pub fn cache_parameter_group_name(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_name.as_deref()
    }
    /// <p>The parameter types to return.</p>
    /// <p>Valid values: <code>user</code> | <code>system</code> | <code>engine-default</code> </p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeCacheParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheParametersInput");
        formatter.field(
            "cache_parameter_group_name",
            &self.cache_parameter_group_name,
        );
        formatter.field("source", &self.source);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeCacheParameterGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheParameterGroupsInput {
    /// <p>The name of a specific cache parameter group to return details for.</p>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeCacheParameterGroupsInput {
    /// <p>The name of a specific cache parameter group to return details for.</p>
    pub fn cache_parameter_group_name(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_name.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeCacheParameterGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheParameterGroupsInput");
        formatter.field(
            "cache_parameter_group_name",
            &self.cache_parameter_group_name,
        );
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeCacheEngineVersions</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheEngineVersionsInput {
    /// <p>The cache engine to return. Valid values: <code>memcached</code> | <code>redis</code> </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The cache engine version to return.</p>
    /// <p>Example: <code>1.4.14</code> </p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The name of a specific cache parameter group family to return details for.</p>
    /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li> <p>Must be 1 to 255 alphanumeric characters</p> </li>
    /// <li> <p>First character must be a letter</p> </li>
    /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
    /// </ul>
    pub cache_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>If <code>true</code>, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
    pub default_only: bool,
}
impl DescribeCacheEngineVersionsInput {
    /// <p>The cache engine to return. Valid values: <code>memcached</code> | <code>redis</code> </p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The cache engine version to return.</p>
    /// <p>Example: <code>1.4.14</code> </p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The name of a specific cache parameter group family to return details for.</p>
    /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li> <p>Must be 1 to 255 alphanumeric characters</p> </li>
    /// <li> <p>First character must be a letter</p> </li>
    /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
    /// </ul>
    pub fn cache_parameter_group_family(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_family.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>If <code>true</code>, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
    pub fn default_only(&self) -> bool {
        self.default_only
    }
}
impl std::fmt::Debug for DescribeCacheEngineVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheEngineVersionsInput");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "cache_parameter_group_family",
            &self.cache_parameter_group_family,
        );
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.field("default_only", &self.default_only);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeCacheClusters</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheClustersInput {
    /// <p>The user-supplied cluster identifier. If this parameter is specified, only information about that specific cluster is returned. This parameter isn't case sensitive.</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to retrieve information about the individual cache nodes.</p>
    pub show_cache_node_info: std::option::Option<bool>,
    /// <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to show only nodes (API/CLI: clusters) that are not members of a replication group. In practice, this mean Memcached and single node Redis clusters.</p>
    pub show_cache_clusters_not_in_replication_groups: std::option::Option<bool>,
}
impl DescribeCacheClustersInput {
    /// <p>The user-supplied cluster identifier. If this parameter is specified, only information about that specific cluster is returned. This parameter isn't case sensitive.</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: minimum 20; maximum 100.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to retrieve information about the individual cache nodes.</p>
    pub fn show_cache_node_info(&self) -> std::option::Option<bool> {
        self.show_cache_node_info
    }
    /// <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to show only nodes (API/CLI: clusters) that are not members of a replication group. In practice, this mean Memcached and single node Redis clusters.</p>
    pub fn show_cache_clusters_not_in_replication_groups(&self) -> std::option::Option<bool> {
        self.show_cache_clusters_not_in_replication_groups
    }
}
impl std::fmt::Debug for DescribeCacheClustersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheClustersInput");
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.field("show_cache_node_info", &self.show_cache_node_info);
        formatter.field(
            "show_cache_clusters_not_in_replication_groups",
            &self.show_cache_clusters_not_in_replication_groups,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserGroupInput {
    /// <p>The ID of the user group.</p>
    pub user_group_id: std::option::Option<std::string::String>,
}
impl DeleteUserGroupInput {
    /// <p>The ID of the user group.</p>
    pub fn user_group_id(&self) -> std::option::Option<&str> {
        self.user_group_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteUserGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserGroupInput");
        formatter.field("user_group_id", &self.user_group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserInput {
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl DeleteUserInput {
    /// <p>The ID of the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserInput");
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteSnapshot</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSnapshotInput {
    /// <p>The name of the snapshot to be deleted.</p>
    pub snapshot_name: std::option::Option<std::string::String>,
}
impl DeleteSnapshotInput {
    /// <p>The name of the snapshot to be deleted.</p>
    pub fn snapshot_name(&self) -> std::option::Option<&str> {
        self.snapshot_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSnapshotInput");
        formatter.field("snapshot_name", &self.snapshot_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteReplicationGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationGroupInput {
    /// <p>The identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>If set to <code>true</code>, all of the read replicas are deleted, but the primary node is retained.</p>
    pub retain_primary_cluster: std::option::Option<bool>,
    /// <p>The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster, rather than one of the replicas; this is to ensure that it captures the freshest data. After the final snapshot is taken, the replication group is immediately deleted.</p>
    pub final_snapshot_identifier: std::option::Option<std::string::String>,
}
impl DeleteReplicationGroupInput {
    /// <p>The identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>If set to <code>true</code>, all of the read replicas are deleted, but the primary node is retained.</p>
    pub fn retain_primary_cluster(&self) -> std::option::Option<bool> {
        self.retain_primary_cluster
    }
    /// <p>The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster, rather than one of the replicas; this is to ensure that it captures the freshest data. After the final snapshot is taken, the replication group is immediately deleted.</p>
    pub fn final_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.final_snapshot_identifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteReplicationGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationGroupInput");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("retain_primary_cluster", &self.retain_primary_cluster);
        formatter.field("final_snapshot_identifier", &self.final_snapshot_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub global_replication_group_id: std::option::Option<std::string::String>,
    /// <p>The primary replication group is retained as a standalone replication group. </p>
    pub retain_primary_replication_group: bool,
}
impl DeleteGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub fn global_replication_group_id(&self) -> std::option::Option<&str> {
        self.global_replication_group_id.as_deref()
    }
    /// <p>The primary replication group is retained as a standalone replication group. </p>
    pub fn retain_primary_replication_group(&self) -> bool {
        self.retain_primary_replication_group
    }
}
impl std::fmt::Debug for DeleteGlobalReplicationGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGlobalReplicationGroupInput");
        formatter.field(
            "global_replication_group_id",
            &self.global_replication_group_id,
        );
        formatter.field(
            "retain_primary_replication_group",
            &self.retain_primary_replication_group,
        );
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteCacheSubnetGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCacheSubnetGroupInput {
    /// <p>The name of the cache subnet group to delete.</p>
    /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
    pub cache_subnet_group_name: std::option::Option<std::string::String>,
}
impl DeleteCacheSubnetGroupInput {
    /// <p>The name of the cache subnet group to delete.</p>
    /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
    pub fn cache_subnet_group_name(&self) -> std::option::Option<&str> {
        self.cache_subnet_group_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteCacheSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCacheSubnetGroupInput");
        formatter.field("cache_subnet_group_name", &self.cache_subnet_group_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteCacheSecurityGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCacheSecurityGroupInput {
    /// <p>The name of the cache security group to delete.</p> <note>
    /// <p>You cannot delete the default security group.</p>
    /// </note>
    pub cache_security_group_name: std::option::Option<std::string::String>,
}
impl DeleteCacheSecurityGroupInput {
    /// <p>The name of the cache security group to delete.</p> <note>
    /// <p>You cannot delete the default security group.</p>
    /// </note>
    pub fn cache_security_group_name(&self) -> std::option::Option<&str> {
        self.cache_security_group_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteCacheSecurityGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCacheSecurityGroupInput");
        formatter.field("cache_security_group_name", &self.cache_security_group_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteCacheParameterGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCacheParameterGroupInput {
    /// <p>The name of the cache parameter group to delete.</p> <note>
    /// <p>The specified cache security group must not be associated with any clusters.</p>
    /// </note>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
}
impl DeleteCacheParameterGroupInput {
    /// <p>The name of the cache parameter group to delete.</p> <note>
    /// <p>The specified cache security group must not be associated with any clusters.</p>
    /// </note>
    pub fn cache_parameter_group_name(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteCacheParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCacheParameterGroupInput");
        formatter.field(
            "cache_parameter_group_name",
            &self.cache_parameter_group_name,
        );
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteCacheCluster</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCacheClusterInput {
    /// <p>The cluster identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. ElastiCache creates the snapshot, and then deletes the cluster immediately afterward.</p>
    pub final_snapshot_identifier: std::option::Option<std::string::String>,
}
impl DeleteCacheClusterInput {
    /// <p>The cluster identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. ElastiCache creates the snapshot, and then deletes the cluster immediately afterward.</p>
    pub fn final_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.final_snapshot_identifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteCacheClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCacheClusterInput");
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("final_snapshot_identifier", &self.final_snapshot_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecreaseReplicaCountInput {
    /// <p>The id of the replication group from which you want to remove replica nodes.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>
    /// <p>The minimum number of replicas in a shard or replication group is:</p>
    /// <ul>
    /// <li> <p>Redis (cluster mode disabled)</p>
    /// <ul>
    /// <li> <p>If Multi-AZ is enabled: 1</p> </li>
    /// <li> <p>If Multi-AZ is not enabled: 0</p> </li>
    /// </ul> </li>
    /// <li> <p>Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)</p> </li>
    /// </ul>
    pub new_replica_count: std::option::Option<i32>,
    /// <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
    pub replica_configuration: std::option::Option<std::vec::Vec<crate::model::ConfigureShard>>,
    /// <p>A list of the node ids to remove from the replication group or node group (shard).</p>
    pub replicas_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If <code>True</code>, the number of replica nodes is decreased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
    pub apply_immediately: bool,
}
impl DecreaseReplicaCountInput {
    /// <p>The id of the replication group from which you want to remove replica nodes.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>
    /// <p>The minimum number of replicas in a shard or replication group is:</p>
    /// <ul>
    /// <li> <p>Redis (cluster mode disabled)</p>
    /// <ul>
    /// <li> <p>If Multi-AZ is enabled: 1</p> </li>
    /// <li> <p>If Multi-AZ is not enabled: 0</p> </li>
    /// </ul> </li>
    /// <li> <p>Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)</p> </li>
    /// </ul>
    pub fn new_replica_count(&self) -> std::option::Option<i32> {
        self.new_replica_count
    }
    /// <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
    pub fn replica_configuration(&self) -> std::option::Option<&[crate::model::ConfigureShard]> {
        self.replica_configuration.as_deref()
    }
    /// <p>A list of the node ids to remove from the replication group or node group (shard).</p>
    pub fn replicas_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.replicas_to_remove.as_deref()
    }
    /// <p>If <code>True</code>, the number of replica nodes is decreased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
    pub fn apply_immediately(&self) -> bool {
        self.apply_immediately
    }
}
impl std::fmt::Debug for DecreaseReplicaCountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecreaseReplicaCountInput");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("new_replica_count", &self.new_replica_count);
        formatter.field("replica_configuration", &self.replica_configuration);
        formatter.field("replicas_to_remove", &self.replicas_to_remove);
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecreaseNodeGroupsInGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub global_replication_group_id: std::option::Option<std::string::String>,
    /// <p>The number of node groups (shards) that results from the modification of the shard configuration</p>
    pub node_group_count: i32,
    /// <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by GlobalNodeGroupsToRemove from the cluster. </p>
    pub global_node_groups_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRetain is a list of NodeGroupIds to retain from the cluster. ElastiCache for Redis will attempt to retain all node groups listed by GlobalNodeGroupsToRetain from the cluster. </p>
    pub global_node_groups_to_retain: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is true. </p>
    pub apply_immediately: bool,
}
impl DecreaseNodeGroupsInGlobalReplicationGroupInput {
    /// <p>The name of the Global datastore</p>
    pub fn global_replication_group_id(&self) -> std::option::Option<&str> {
        self.global_replication_group_id.as_deref()
    }
    /// <p>The number of node groups (shards) that results from the modification of the shard configuration</p>
    pub fn node_group_count(&self) -> i32 {
        self.node_group_count
    }
    /// <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by GlobalNodeGroupsToRemove from the cluster. </p>
    pub fn global_node_groups_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.global_node_groups_to_remove.as_deref()
    }
    /// <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRetain is a list of NodeGroupIds to retain from the cluster. ElastiCache for Redis will attempt to retain all node groups listed by GlobalNodeGroupsToRetain from the cluster. </p>
    pub fn global_node_groups_to_retain(&self) -> std::option::Option<&[std::string::String]> {
        self.global_node_groups_to_retain.as_deref()
    }
    /// <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is true. </p>
    pub fn apply_immediately(&self) -> bool {
        self.apply_immediately
    }
}
impl std::fmt::Debug for DecreaseNodeGroupsInGlobalReplicationGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecreaseNodeGroupsInGlobalReplicationGroupInput");
        formatter.field(
            "global_replication_group_id",
            &self.global_replication_group_id,
        );
        formatter.field("node_group_count", &self.node_group_count);
        formatter.field(
            "global_node_groups_to_remove",
            &self.global_node_groups_to_remove,
        );
        formatter.field(
            "global_node_groups_to_retain",
            &self.global_node_groups_to_retain,
        );
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserGroupInput {
    /// <p>The ID of the user group.</p>
    pub user_group_id: std::option::Option<std::string::String>,
    /// <p>The current supported value is Redis. </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The list of user IDs that belong to the user group.</p>
    pub user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateUserGroupInput {
    /// <p>The ID of the user group.</p>
    pub fn user_group_id(&self) -> std::option::Option<&str> {
        self.user_group_id.as_deref()
    }
    /// <p>The current supported value is Redis. </p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The list of user IDs that belong to the user group.</p>
    pub fn user_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.user_ids.as_deref()
    }
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateUserGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserGroupInput");
        formatter.field("user_group_id", &self.user_group_id);
        formatter.field("engine", &self.engine);
        formatter.field("user_ids", &self.user_ids);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserInput {
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The username of the user.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The current supported value is Redis. </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>Passwords used for this user. You can create up to two passwords for each user.</p>
    pub passwords: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Access permissions string used for this user.</p>
    pub access_string: std::option::Option<std::string::String>,
    /// <p>Indicates a password is not required for this user.</p>
    pub no_password_required: std::option::Option<bool>,
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateUserInput {
    /// <p>The ID of the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The username of the user.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The current supported value is Redis. </p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>Passwords used for this user. You can create up to two passwords for each user.</p>
    pub fn passwords(&self) -> std::option::Option<&[std::string::String]> {
        self.passwords.as_deref()
    }
    /// <p>Access permissions string used for this user.</p>
    pub fn access_string(&self) -> std::option::Option<&str> {
        self.access_string.as_deref()
    }
    /// <p>Indicates a password is not required for this user.</p>
    pub fn no_password_required(&self) -> std::option::Option<bool> {
        self.no_password_required
    }
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserInput");
        formatter.field("user_id", &self.user_id);
        formatter.field("user_name", &self.user_name);
        formatter.field("engine", &self.engine);
        formatter.field("passwords", &self.passwords);
        formatter.field("access_string", &self.access_string);
        formatter.field("no_password_required", &self.no_password_required);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>CreateSnapshot</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSnapshotInput {
    /// <p>The identifier of an existing replication group. The snapshot is created from this replication group.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The identifier of an existing cluster. The snapshot is created from this cluster.</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>A name for the snapshot being created.</p>
    pub snapshot_name: std::option::Option<std::string::String>,
    /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateSnapshotInput {
    /// <p>The identifier of an existing replication group. The snapshot is created from this replication group.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The identifier of an existing cluster. The snapshot is created from this cluster.</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>A name for the snapshot being created.</p>
    pub fn snapshot_name(&self) -> std::option::Option<&str> {
        self.snapshot_name.as_deref()
    }
    /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSnapshotInput");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("snapshot_name", &self.snapshot_name);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>CreateReplicationGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicationGroupInput {
    /// <p>The replication group identifier. This parameter is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li> <p>A name must contain from 1 to 40 alphanumeric characters or hyphens.</p> </li>
    /// <li> <p>The first character must be a letter.</p> </li>
    /// <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
    /// </ul>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>A user-created description for the replication group.</p>
    pub replication_group_description: std::option::Option<std::string::String>,
    /// <p>The name of the Global datastore</p>
    pub global_replication_group_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the cluster that serves as the primary for this replication group. This cluster must already exist and have a status of <code>available</code>.</p>
    /// <p>This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or <code>ReplicasPerNodeGroup</code> is specified.</p>
    pub primary_cluster_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.</p>
    /// <p> <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.</p>
    /// <p>Default: false</p>
    pub automatic_failover_enabled: std::option::Option<bool>,
    /// <p>A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a>.</p>
    pub multi_az_enabled: std::option::Option<bool>,
    /// <p>The number of clusters this replication group initially has.</p>
    /// <p>This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.</p>
    /// <p>If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.</p>
    /// <p>The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).</p>
    pub num_cache_clusters: std::option::Option<i32>,
    /// <p>A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.</p>
    /// <p>This parameter is not used if there is more than one node group (shard). You should use <code>NodeGroupConfiguration</code> instead.</p> <note>
    /// <p>If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.</p>
    /// <p>The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.</p>
    /// </note>
    /// <p>Default: system chosen Availability Zones.</p>
    pub preferred_cache_cluster_a_zs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.</p>
    /// <p>Default: 1</p>
    pub num_node_groups: std::option::Option<i32>,
    /// <p>An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0 to 5.</p>
    pub replicas_per_node_group: std::option::Option<i32>,
    /// <p>A list of node group (shard) configuration options. Each node group (shard) configuration has the following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>, and <code>Slots</code>.</p>
    /// <p>If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node group (shard) using this parameter because you must specify the slots for each node group.</p>
    pub node_group_configuration:
        std::option::Option<std::vec::Vec<crate::model::NodeGroupConfiguration>>,
    /// <p>The compute and memory capacity of the nodes in the node group (shard).</p>
    /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
    /// <ul>
    /// <li> <p>General purpose:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
    /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 6.0 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Compute optimized:</p>
    /// <ul>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Memory optimized with data tiering:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Memory optimized:</p>
    /// <ul>
    /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
    /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
    /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p> <b>Additional node type info</b> </p>
    /// <ul>
    /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
    /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
    /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
    /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
    /// </ul>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>The name of the cache engine to be used for the clusters in this replication group. Must be Redis.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version number of the cache engine to be used for the clusters in this replication group. To view the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p>
    /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. </p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used.</p>
    /// <p>If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name. </p>
    /// <ul>
    /// <li> <p>To create a Redis (cluster mode disabled) replication group, use <code>CacheParameterGroupName=default.redis3.2</code>.</p> </li>
    /// <li> <p>To create a Redis (cluster mode enabled) replication group, use <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.</p> </li>
    /// </ul>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the cache subnet group to be used for the replication group.</p> <important>
    /// <p>If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet Groups</a>.</p>
    /// </important>
    pub cache_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A list of cache security group names to associate with this replication group.</p>
    pub cache_security_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more Amazon VPC security groups associated with this replication group.</p>
    /// <p>Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=<code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=<code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=<code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
    /// <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>
    pub snapshot_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to <code>restoring</code> while the new replication group is being created.</p>
    pub snapshot_name: std::option::Option<std::string::String>,
    /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for <code>ddd</code> are:</p>
    /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
    /// <p>Valid values for <code>ddd</code> are:</p>
    /// <ul>
    /// <li> <p> <code>sun</code> </p> </li>
    /// <li> <p> <code>mon</code> </p> </li>
    /// <li> <p> <code>tue</code> </p> </li>
    /// <li> <p> <code>wed</code> </p> </li>
    /// <li> <p> <code>thu</code> </p> </li>
    /// <li> <p> <code>fri</code> </p> </li>
    /// <li> <p> <code>sat</code> </p> </li>
    /// </ul>
    /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>The port number on which each member of the replication group accepts connections.</p>
    pub port: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note>
    /// <p>The Amazon SNS topic owner must be the same as the cluster owner.</p>
    /// </note>
    pub notification_topic_arn: std::option::Option<std::string::String>,
    /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
    pub auto_minor_version_upgrade: std::option::Option<bool>,
    /// <p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
    /// <p>Default: 0 (i.e., automatic backups are disabled for this cluster).</p>
    pub snapshot_retention_limit: std::option::Option<i32>,
    /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p>
    /// <p>Example: <code>05:00-09:00</code> </p>
    /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>
    pub snapshot_window: std::option::Option<std::string::String>,
    /// <p> <b>Reserved parameter.</b> The password used to access a password protected server.</p>
    /// <p> <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is <code>true</code>.</p> <important>
    /// <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p>
    /// </important>
    /// <p>Password constraints:</p>
    /// <ul>
    /// <li> <p>Must be only printable ASCII characters.</p> </li>
    /// <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li>
    /// <li> <p>The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special characters cannot be used in the AUTH token.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.</p>
    pub auth_token: std::option::Option<std::string::String>,
    /// <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>
    /// <p>You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.</p>
    /// <p>This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being created in an Amazon VPC.</p>
    /// <p>If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.</p>
    /// <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    /// <p>Default: <code>false</code> </p> <important>
    /// <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p>
    /// </important>
    pub transit_encryption_enabled: std::option::Option<bool>,
    /// <p>A flag that enables encryption at rest when set to <code>true</code>.</p>
    /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group. </p>
    /// <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    /// <p>Default: <code>false</code> </p>
    pub at_rest_encryption_enabled: std::option::Option<bool>,
    /// <p>The ID of the KMS key used to encrypt the disk in the cluster.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The user group to associate with the replication group.</p>
    pub user_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the destination, format and type of the logs.</p>
    pub log_delivery_configurations:
        std::option::Option<std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>>,
    /// <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
    pub data_tiering_enabled: std::option::Option<bool>,
}
impl CreateReplicationGroupInput {
    /// <p>The replication group identifier. This parameter is stored as a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li> <p>A name must contain from 1 to 40 alphanumeric characters or hyphens.</p> </li>
    /// <li> <p>The first character must be a letter.</p> </li>
    /// <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
    /// </ul>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>A user-created description for the replication group.</p>
    pub fn replication_group_description(&self) -> std::option::Option<&str> {
        self.replication_group_description.as_deref()
    }
    /// <p>The name of the Global datastore</p>
    pub fn global_replication_group_id(&self) -> std::option::Option<&str> {
        self.global_replication_group_id.as_deref()
    }
    /// <p>The identifier of the cluster that serves as the primary for this replication group. This cluster must already exist and have a status of <code>available</code>.</p>
    /// <p>This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or <code>ReplicasPerNodeGroup</code> is specified.</p>
    pub fn primary_cluster_id(&self) -> std::option::Option<&str> {
        self.primary_cluster_id.as_deref()
    }
    /// <p>Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.</p>
    /// <p> <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.</p>
    /// <p>Default: false</p>
    pub fn automatic_failover_enabled(&self) -> std::option::Option<bool> {
        self.automatic_failover_enabled
    }
    /// <p>A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a>.</p>
    pub fn multi_az_enabled(&self) -> std::option::Option<bool> {
        self.multi_az_enabled
    }
    /// <p>The number of clusters this replication group initially has.</p>
    /// <p>This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.</p>
    /// <p>If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code