// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_to_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsToResourceOutput, crate::error::AddTagsToResourceError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddTagsToResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddTagsToResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheClusterNotFound" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::CacheClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheParameterGroupNotFound" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::CacheParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheSecurityGroupNotFound" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::CacheSecurityGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheSubnetGroupNotFoundFault" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::CacheSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidARN" => {
            crate::error::AddTagsToResourceError {
                meta: generic,
                kind: crate::error::AddTagsToResourceErrorKind::InvalidArnFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_arn_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_arn_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidReplicationGroupState" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::InvalidReplicationGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicationGroupNotFoundFault" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::ReplicationGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReservedCacheNodeNotFound" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::ReservedCacheNodeNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::reserved_cache_node_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_cache_node_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotNotFoundFault" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::SnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagQuotaPerResourceExceeded" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::TagQuotaPerResourceExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_quota_per_resource_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_quota_per_resource_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserGroupNotFound" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::UserGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_user_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFound" => {
            crate::error::AddTagsToResourceError {
                meta: generic,
                kind: crate::error::AddTagsToResourceErrorKind::UserNotFoundFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::user_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_user_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::AddTagsToResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_to_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsToResourceOutput, crate::error::AddTagsToResourceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_tags_to_resource_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_add_tags_to_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AddTagsToResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_cache_security_group_ingress_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AuthorizeCacheSecurityGroupIngressOutput,
    crate::error::AuthorizeCacheSecurityGroupIngressError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AuthorizeCacheSecurityGroupIngressError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AuthorizeCacheSecurityGroupIngressError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationAlreadyExists" => crate::error::AuthorizeCacheSecurityGroupIngressError { meta: generic, kind: crate::error::AuthorizeCacheSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeCacheSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CacheSecurityGroupNotFound" => crate::error::AuthorizeCacheSecurityGroupIngressError { meta: generic, kind: crate::error::AuthorizeCacheSecurityGroupIngressErrorKind::CacheSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeCacheSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCacheSecurityGroupState" => crate::error::AuthorizeCacheSecurityGroupIngressError { meta: generic, kind: crate::error::AuthorizeCacheSecurityGroupIngressErrorKind::InvalidCacheSecurityGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cache_security_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeCacheSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::AuthorizeCacheSecurityGroupIngressError { meta: generic, kind: crate::error::AuthorizeCacheSecurityGroupIngressErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeCacheSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::AuthorizeCacheSecurityGroupIngressError { meta: generic, kind: crate::error::AuthorizeCacheSecurityGroupIngressErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeCacheSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AuthorizeCacheSecurityGroupIngressError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_cache_security_group_ingress_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AuthorizeCacheSecurityGroupIngressOutput,
    crate::error::AuthorizeCacheSecurityGroupIngressError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::authorize_cache_security_group_ingress_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_authorize_cache_security_group_ingress(response.body().as_ref(), output).map_err(crate::error::AuthorizeCacheSecurityGroupIngressError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_apply_update_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchApplyUpdateActionOutput,
    crate::error::BatchApplyUpdateActionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchApplyUpdateActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::BatchApplyUpdateActionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValue" => crate::error::BatchApplyUpdateActionError {
            meta: generic,
            kind: crate::error::BatchApplyUpdateActionErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::BatchApplyUpdateActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUpdateNotFoundFault" => crate::error::BatchApplyUpdateActionError {
            meta: generic,
            kind: crate::error::BatchApplyUpdateActionErrorKind::ServiceUpdateNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_update_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_update_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::BatchApplyUpdateActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::BatchApplyUpdateActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_apply_update_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchApplyUpdateActionOutput,
    crate::error::BatchApplyUpdateActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_apply_update_action_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_batch_apply_update_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchApplyUpdateActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_stop_update_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchStopUpdateActionOutput,
    crate::error::BatchStopUpdateActionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchStopUpdateActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BatchStopUpdateActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValue" => crate::error::BatchStopUpdateActionError {
            meta: generic,
            kind: crate::error::BatchStopUpdateActionErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::BatchStopUpdateActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUpdateNotFoundFault" => crate::error::BatchStopUpdateActionError {
            meta: generic,
            kind: crate::error::BatchStopUpdateActionErrorKind::ServiceUpdateNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_update_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_update_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::BatchStopUpdateActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::BatchStopUpdateActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_stop_update_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchStopUpdateActionOutput,
    crate::error::BatchStopUpdateActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_stop_update_action_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_batch_stop_update_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchStopUpdateActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_migration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CompleteMigrationOutput, crate::error::CompleteMigrationError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CompleteMigrationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CompleteMigrationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidReplicationGroupState" => crate::error::CompleteMigrationError {
            meta: generic,
            kind: crate::error::CompleteMigrationErrorKind::InvalidReplicationGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CompleteMigrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicationGroupNotFoundFault" => crate::error::CompleteMigrationError {
            meta: generic,
            kind: crate::error::CompleteMigrationErrorKind::ReplicationGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CompleteMigrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicationGroupNotUnderMigrationFault" => crate::error::CompleteMigrationError {
            meta: generic,
            kind: crate::error::CompleteMigrationErrorKind::ReplicationGroupNotUnderMigrationFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::replication_group_not_under_migration_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_replication_group_not_under_migration_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CompleteMigrationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::CompleteMigrationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_migration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CompleteMigrationOutput, crate::error::CompleteMigrationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::complete_migration_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_complete_migration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CompleteMigrationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopySnapshotOutput, crate::error::CopySnapshotError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CopySnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CopySnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => crate::error::CopySnapshotError {
            meta: generic,
            kind: crate::error::CopySnapshotErrorKind::InvalidParameterCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::CopySnapshotError {
            meta: generic,
            kind: crate::error::CopySnapshotErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSnapshotState" => crate::error::CopySnapshotError {
            meta: generic,
            kind: crate::error::CopySnapshotErrorKind::InvalidSnapshotStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotAlreadyExistsFault" => crate::error::CopySnapshotError {
            meta: generic,
            kind: crate::error::CopySnapshotErrorKind::SnapshotAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotNotFoundFault" => crate::error::CopySnapshotError {
            meta: generic,
            kind: crate::error::CopySnapshotErrorKind::SnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotQuotaExceededFault" => crate::error::CopySnapshotError {
            meta: generic,
            kind: crate::error::CopySnapshotErrorKind::SnapshotQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagQuotaPerResourceExceeded" => crate::error::CopySnapshotError {
            meta: generic,
            kind: crate::error::CopySnapshotErrorKind::TagQuotaPerResourceExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_quota_per_resource_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_quota_per_resource_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CopySnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopySnapshotOutput, crate::error::CopySnapshotError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::copy_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_copy_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CopySnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cache_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCacheClusterOutput,
    crate::error::CreateCacheClusterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCacheClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateCacheClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheClusterAlreadyExists" => crate::error::CreateCacheClusterError {
            meta: generic,
            kind: crate::error::CreateCacheClusterErrorKind::CacheClusterAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_cluster_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_cluster_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheParameterGroupNotFound" => crate::error::CreateCacheClusterError {
            meta: generic,
            kind: crate::error::CreateCacheClusterErrorKind::CacheParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheSecurityGroupNotFound" => crate::error::CreateCacheClusterError {
            meta: generic,
            kind: crate::error::CreateCacheClusterErrorKind::CacheSecurityGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheSubnetGroupNotFoundFault" => crate::error::CreateCacheClusterError {
            meta: generic,
            kind: crate::error::CreateCacheClusterErrorKind::CacheSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterQuotaForCustomerExceeded" => crate::error::CreateCacheClusterError {
            meta: generic,
            kind: crate::error::CreateCacheClusterErrorKind::ClusterQuotaForCustomerExceededFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::cluster_quota_for_customer_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_cluster_quota_for_customer_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InsufficientCacheClusterCapacity" => crate::error::CreateCacheClusterError {
            meta: generic,
            kind: crate::error::CreateCacheClusterErrorKind::InsufficientCacheClusterCapacityFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::insufficient_cache_cluster_capacity_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_insufficient_cache_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidParameterCombination" => {
            crate::error::CreateCacheClusterError {
                meta: generic,
                kind:
                    crate::error::CreateCacheClusterErrorKind::InvalidParameterCombinationException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InvalidParameterValue" => crate::error::CreateCacheClusterError {
            meta: generic,
            kind: crate::error::CreateCacheClusterErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidReplicationGroupState" => crate::error::CreateCacheClusterError {
            meta: generic,
            kind: crate::error::CreateCacheClusterErrorKind::InvalidReplicationGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidVPCNetworkStateFault" => crate::error::CreateCacheClusterError {
            meta: generic,
            kind: crate::error::CreateCacheClusterErrorKind::InvalidVpcNetworkStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NodeQuotaForClusterExceeded" => crate::error::CreateCacheClusterError {
            meta: generic,
            kind: crate::error::CreateCacheClusterErrorKind::NodeQuotaForClusterExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::node_quota_for_cluster_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_quota_for_cluster_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NodeQuotaForCustomerExceeded" => crate::error::CreateCacheClusterError {
            meta: generic,
            kind: crate::error::CreateCacheClusterErrorKind::NodeQuotaForCustomerExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::node_quota_for_customer_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_quota_for_customer_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicationGroupNotFoundFault" => crate::error::CreateCacheClusterError {
            meta: generic,
            kind: crate::error::CreateCacheClusterErrorKind::ReplicationGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagQuotaPerResourceExceeded" => crate::error::CreateCacheClusterError {
            meta: generic,
            kind: crate::error::CreateCacheClusterErrorKind::TagQuotaPerResourceExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_quota_per_resource_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_quota_per_resource_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateCacheClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cache_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCacheClusterOutput,
    crate::error::CreateCacheClusterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cache_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_cache_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCacheClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cache_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCacheParameterGroupOutput,
    crate::error::CreateCacheParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCacheParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateCacheParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheParameterGroupAlreadyExists" => crate::error::CreateCacheParameterGroupError { meta: generic, kind: crate::error::CreateCacheParameterGroupErrorKind::CacheParameterGroupAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_parameter_group_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CacheParameterGroupQuotaExceeded" => crate::error::CreateCacheParameterGroupError { meta: generic, kind: crate::error::CreateCacheParameterGroupErrorKind::CacheParameterGroupQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_parameter_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCacheParameterGroupState" => crate::error::CreateCacheParameterGroupError { meta: generic, kind: crate::error::CreateCacheParameterGroupErrorKind::InvalidCacheParameterGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cache_parameter_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_parameter_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::CreateCacheParameterGroupError { meta: generic, kind: crate::error::CreateCacheParameterGroupErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::CreateCacheParameterGroupError { meta: generic, kind: crate::error::CreateCacheParameterGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TagQuotaPerResourceExceeded" => crate::error::CreateCacheParameterGroupError { meta: generic, kind: crate::error::CreateCacheParameterGroupErrorKind::TagQuotaPerResourceExceeded({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tag_quota_per_resource_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_quota_per_resource_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateCacheParameterGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cache_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCacheParameterGroupOutput,
    crate::error::CreateCacheParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cache_parameter_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_cache_parameter_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCacheParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cache_security_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCacheSecurityGroupOutput,
    crate::error::CreateCacheSecurityGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCacheSecurityGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateCacheSecurityGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheSecurityGroupAlreadyExists" => crate::error::CreateCacheSecurityGroupError { meta: generic, kind: crate::error::CreateCacheSecurityGroupErrorKind::CacheSecurityGroupAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_security_group_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_security_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "QuotaExceeded.CacheSecurityGroup" => crate::error::CreateCacheSecurityGroupError { meta: generic, kind: crate::error::CreateCacheSecurityGroupErrorKind::CacheSecurityGroupQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_security_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_security_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::CreateCacheSecurityGroupError { meta: generic, kind: crate::error::CreateCacheSecurityGroupErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::CreateCacheSecurityGroupError { meta: generic, kind: crate::error::CreateCacheSecurityGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TagQuotaPerResourceExceeded" => crate::error::CreateCacheSecurityGroupError { meta: generic, kind: crate::error::CreateCacheSecurityGroupErrorKind::TagQuotaPerResourceExceeded({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tag_quota_per_resource_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_quota_per_resource_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateCacheSecurityGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cache_security_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCacheSecurityGroupOutput,
    crate::error::CreateCacheSecurityGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cache_security_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_cache_security_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCacheSecurityGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cache_subnet_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCacheSubnetGroupOutput,
    crate::error::CreateCacheSubnetGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCacheSubnetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateCacheSubnetGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheSubnetGroupAlreadyExists" => crate::error::CreateCacheSubnetGroupError {
            meta: generic,
            kind: crate::error::CreateCacheSubnetGroupErrorKind::CacheSubnetGroupAlreadyExistsFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::cache_subnet_group_already_exists_fault::Builder::default(
                            );
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_cache_subnet_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheSubnetGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "CacheSubnetGroupQuotaExceeded" => crate::error::CreateCacheSubnetGroupError {
            meta: generic,
            kind: crate::error::CreateCacheSubnetGroupErrorKind::CacheSubnetGroupQuotaExceededFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::cache_subnet_group_quota_exceeded_fault::Builder::default(
                            );
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_cache_subnet_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheSubnetGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "CacheSubnetQuotaExceededFault" => crate::error::CreateCacheSubnetGroupError {
            meta: generic,
            kind: crate::error::CreateCacheSubnetGroupErrorKind::CacheSubnetQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_subnet_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_subnet_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::CreateCacheSubnetGroupError {
            meta: generic,
            kind: crate::error::CreateCacheSubnetGroupErrorKind::InvalidSubnet({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateCacheSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubnetNotAllowedFault" => crate::error::CreateCacheSubnetGroupError {
            meta: generic,
            kind: crate::error::CreateCacheSubnetGroupErrorKind::SubnetNotAllowedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::subnet_not_allowed_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subnet_not_allowed_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagQuotaPerResourceExceeded" => crate::error::CreateCacheSubnetGroupError {
            meta: generic,
            kind: crate::error::CreateCacheSubnetGroupErrorKind::TagQuotaPerResourceExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_quota_per_resource_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_quota_per_resource_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCacheSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateCacheSubnetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cache_subnet_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCacheSubnetGroupOutput,
    crate::error::CreateCacheSubnetGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cache_subnet_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_cache_subnet_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCacheSubnetGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_global_replication_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateGlobalReplicationGroupOutput,
    crate::error::CreateGlobalReplicationGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateGlobalReplicationGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateGlobalReplicationGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalReplicationGroupAlreadyExistsFault" => crate::error::CreateGlobalReplicationGroupError { meta: generic, kind: crate::error::CreateGlobalReplicationGroupErrorKind::GlobalReplicationGroupAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::global_replication_group_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_replication_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::CreateGlobalReplicationGroupError { meta: generic, kind: crate::error::CreateGlobalReplicationGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidReplicationGroupState" => crate::error::CreateGlobalReplicationGroupError { meta: generic, kind: crate::error::CreateGlobalReplicationGroupErrorKind::InvalidReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReplicationGroupNotFoundFault" => crate::error::CreateGlobalReplicationGroupError { meta: generic, kind: crate::error::CreateGlobalReplicationGroupErrorKind::ReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceLinkedRoleNotFoundFault" => crate::error::CreateGlobalReplicationGroupError { meta: generic, kind: crate::error::CreateGlobalReplicationGroupErrorKind::ServiceLinkedRoleNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_linked_role_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateGlobalReplicationGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_global_replication_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateGlobalReplicationGroupOutput,
    crate::error::CreateGlobalReplicationGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_global_replication_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_global_replication_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateGlobalReplicationGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_replication_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReplicationGroupOutput,
    crate::error::CreateReplicationGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateReplicationGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateReplicationGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheClusterNotFound" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::CacheClusterNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CacheParameterGroupNotFound" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::CacheParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CacheSecurityGroupNotFound" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::CacheSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CacheSubnetGroupNotFoundFault" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::CacheSubnetGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterQuotaForCustomerExceeded" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::ClusterQuotaForCustomerExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_quota_for_customer_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_quota_for_customer_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "GlobalReplicationGroupNotFoundFault" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::global_replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientCacheClusterCapacity" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::InsufficientCacheClusterCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_cache_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_cache_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCacheClusterState" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::InvalidCacheClusterStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cache_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGlobalReplicationGroupState" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_global_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidUserGroupState" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::InvalidUserGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_user_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_user_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidVPCNetworkStateFault" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::InvalidVpcNetworkStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NodeGroupsPerReplicationGroupQuotaExceeded" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::NodeGroupsPerReplicationGroupQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::node_groups_per_replication_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_groups_per_replication_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NodeQuotaForClusterExceeded" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::NodeQuotaForClusterExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::node_quota_for_cluster_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_quota_for_cluster_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NodeQuotaForCustomerExceeded" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::NodeQuotaForCustomerExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::node_quota_for_customer_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_quota_for_customer_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReplicationGroupAlreadyExists" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::ReplicationGroupAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::replication_group_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TagQuotaPerResourceExceeded" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::TagQuotaPerResourceExceeded({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tag_quota_per_resource_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_quota_per_resource_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserGroupNotFound" => crate::error::CreateReplicationGroupError { meta: generic, kind: crate::error::CreateReplicationGroupErrorKind::UserGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_user_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateReplicationGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_replication_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReplicationGroupOutput,
    crate::error::CreateReplicationGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_replication_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_replication_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateReplicationGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateSnapshotOutput, crate::error::CreateSnapshotError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheClusterNotFound" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::CacheClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCacheClusterState" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::InvalidCacheClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_cache_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::InvalidParameterCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidReplicationGroupState" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::InvalidReplicationGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicationGroupNotFoundFault" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::ReplicationGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotAlreadyExistsFault" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::SnapshotAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotFeatureNotSupportedFault" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::SnapshotFeatureNotSupportedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_feature_not_supported_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_feature_not_supported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotQuotaExceededFault" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::SnapshotQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagQuotaPerResourceExceeded" => crate::error::CreateSnapshotError {
            meta: generic,
            kind: crate::error::CreateSnapshotErrorKind::TagQuotaPerResourceExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_quota_per_resource_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_quota_per_resource_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateSnapshotOutput, crate::error::CreateSnapshotError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateUserName" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::DuplicateUserNameFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_user_name_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_user_name_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::InvalidParameterCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleNotFoundFault" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::ServiceLinkedRoleNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_linked_role_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagQuotaPerResourceExceeded" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::TagQuotaPerResourceExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_quota_per_resource_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_quota_per_resource_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserAlreadyExists" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::UserAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_user_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserQuotaExceeded" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::UserQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_user_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_user_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_user(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserGroupOutput, crate::error::CreateUserGroupError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateUserGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateUserGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DefaultUserRequired" => crate::error::CreateUserGroupError {
            meta: generic,
            kind: crate::error::CreateUserGroupErrorKind::DefaultUserRequired({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::default_user_required::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_default_user_required_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateUserName" => crate::error::CreateUserGroupError {
            meta: generic,
            kind: crate::error::CreateUserGroupErrorKind::DuplicateUserNameFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_user_name_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_user_name_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::CreateUserGroupError {
            meta: generic,
            kind: crate::error::CreateUserGroupErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleNotFoundFault" => crate::error::CreateUserGroupError {
            meta: generic,
            kind: crate::error::CreateUserGroupErrorKind::ServiceLinkedRoleNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_linked_role_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagQuotaPerResourceExceeded" => crate::error::CreateUserGroupError {
            meta: generic,
            kind: crate::error::CreateUserGroupErrorKind::TagQuotaPerResourceExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_quota_per_resource_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_quota_per_resource_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserGroupAlreadyExists" => crate::error::CreateUserGroupError {
            meta: generic,
            kind: crate::error::CreateUserGroupErrorKind::UserGroupAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_group_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_user_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserGroupQuotaExceeded" => crate::error::CreateUserGroupError {
            meta: generic,
            kind: crate::error::CreateUserGroupErrorKind::UserGroupQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_user_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFound" => {
            crate::error::CreateUserGroupError {
                meta: generic,
                kind: crate::error::CreateUserGroupErrorKind::UserNotFoundFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::user_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_user_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateUserGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserGroupOutput, crate::error::CreateUserGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_user_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_user_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateUserGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_decrease_node_groups_in_global_replication_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DecreaseNodeGroupsInGlobalReplicationGroupOutput,
    crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalReplicationGroupNotFoundFault" => crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError { meta: generic, kind: crate::error::DecreaseNodeGroupsInGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::global_replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGlobalReplicationGroupState" => crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError { meta: generic, kind: crate::error::DecreaseNodeGroupsInGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_global_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError { meta: generic, kind: crate::error::DecreaseNodeGroupsInGlobalReplicationGroupErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError { meta: generic, kind: crate::error::DecreaseNodeGroupsInGlobalReplicationGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_decrease_node_groups_in_global_replication_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DecreaseNodeGroupsInGlobalReplicationGroupOutput,
    crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::decrease_node_groups_in_global_replication_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_decrease_node_groups_in_global_replication_group(response.body().as_ref(), output).map_err(crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_decrease_replica_count_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DecreaseReplicaCountOutput,
    crate::error::DecreaseReplicaCountError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DecreaseReplicaCountError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterQuotaForCustomerExceeded" => crate::error::DecreaseReplicaCountError { meta: generic, kind: crate::error::DecreaseReplicaCountErrorKind::ClusterQuotaForCustomerExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_quota_for_customer_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_quota_for_customer_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientCacheClusterCapacity" => crate::error::DecreaseReplicaCountError { meta: generic, kind: crate::error::DecreaseReplicaCountErrorKind::InsufficientCacheClusterCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_cache_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_cache_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCacheClusterState" => crate::error::DecreaseReplicaCountError { meta: generic, kind: crate::error::DecreaseReplicaCountErrorKind::InvalidCacheClusterStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cache_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::DecreaseReplicaCountError { meta: generic, kind: crate::error::DecreaseReplicaCountErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DecreaseReplicaCountError { meta: generic, kind: crate::error::DecreaseReplicaCountErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidReplicationGroupState" => crate::error::DecreaseReplicaCountError { meta: generic, kind: crate::error::DecreaseReplicaCountErrorKind::InvalidReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidVPCNetworkStateFault" => crate::error::DecreaseReplicaCountError { meta: generic, kind: crate::error::DecreaseReplicaCountErrorKind::InvalidVpcNetworkStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NodeGroupsPerReplicationGroupQuotaExceeded" => crate::error::DecreaseReplicaCountError { meta: generic, kind: crate::error::DecreaseReplicaCountErrorKind::NodeGroupsPerReplicationGroupQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::node_groups_per_replication_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_groups_per_replication_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NodeQuotaForCustomerExceeded" => crate::error::DecreaseReplicaCountError { meta: generic, kind: crate::error::DecreaseReplicaCountErrorKind::NodeQuotaForCustomerExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::node_quota_for_customer_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_quota_for_customer_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoOperationFault" => crate::error::DecreaseReplicaCountError { meta: generic, kind: crate::error::DecreaseReplicaCountErrorKind::NoOperationFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReplicationGroupNotFoundFault" => crate::error::DecreaseReplicaCountError { meta: generic, kind: crate::error::DecreaseReplicaCountErrorKind::ReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceLinkedRoleNotFoundFault" => crate::error::DecreaseReplicaCountError { meta: generic, kind: crate::error::DecreaseReplicaCountErrorKind::ServiceLinkedRoleNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_linked_role_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DecreaseReplicaCountError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_decrease_replica_count_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DecreaseReplicaCountOutput,
    crate::error::DecreaseReplicaCountError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::decrease_replica_count_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_decrease_replica_count(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DecreaseReplicaCountError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cache_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCacheClusterOutput,
    crate::error::DeleteCacheClusterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCacheClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteCacheClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheClusterNotFound" => crate::error::DeleteCacheClusterError {
            meta: generic,
            kind: crate::error::DeleteCacheClusterErrorKind::CacheClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCacheClusterState" => crate::error::DeleteCacheClusterError {
            meta: generic,
            kind: crate::error::DeleteCacheClusterErrorKind::InvalidCacheClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_cache_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => {
            crate::error::DeleteCacheClusterError {
                meta: generic,
                kind:
                    crate::error::DeleteCacheClusterErrorKind::InvalidParameterCombinationException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheClusterError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InvalidParameterValue" => crate::error::DeleteCacheClusterError {
            meta: generic,
            kind: crate::error::DeleteCacheClusterErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotAlreadyExistsFault" => crate::error::DeleteCacheClusterError {
            meta: generic,
            kind: crate::error::DeleteCacheClusterErrorKind::SnapshotAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotFeatureNotSupportedFault" => crate::error::DeleteCacheClusterError {
            meta: generic,
            kind: crate::error::DeleteCacheClusterErrorKind::SnapshotFeatureNotSupportedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_feature_not_supported_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_feature_not_supported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotQuotaExceededFault" => crate::error::DeleteCacheClusterError {
            meta: generic,
            kind: crate::error::DeleteCacheClusterErrorKind::SnapshotQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteCacheClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cache_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCacheClusterOutput,
    crate::error::DeleteCacheClusterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_cache_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_cache_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteCacheClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cache_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCacheParameterGroupOutput,
    crate::error::DeleteCacheParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCacheParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteCacheParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheParameterGroupNotFound" => crate::error::DeleteCacheParameterGroupError { meta: generic, kind: crate::error::DeleteCacheParameterGroupErrorKind::CacheParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCacheParameterGroupState" => crate::error::DeleteCacheParameterGroupError { meta: generic, kind: crate::error::DeleteCacheParameterGroupErrorKind::InvalidCacheParameterGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cache_parameter_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_parameter_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::DeleteCacheParameterGroupError { meta: generic, kind: crate::error::DeleteCacheParameterGroupErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DeleteCacheParameterGroupError { meta: generic, kind: crate::error::DeleteCacheParameterGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteCacheParameterGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cache_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCacheParameterGroupOutput,
    crate::error::DeleteCacheParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_cache_parameter_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cache_security_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCacheSecurityGroupOutput,
    crate::error::DeleteCacheSecurityGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCacheSecurityGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteCacheSecurityGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheSecurityGroupNotFound" => crate::error::DeleteCacheSecurityGroupError { meta: generic, kind: crate::error::DeleteCacheSecurityGroupErrorKind::CacheSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCacheSecurityGroupState" => crate::error::DeleteCacheSecurityGroupError { meta: generic, kind: crate::error::DeleteCacheSecurityGroupErrorKind::InvalidCacheSecurityGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cache_security_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::DeleteCacheSecurityGroupError { meta: generic, kind: crate::error::DeleteCacheSecurityGroupErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DeleteCacheSecurityGroupError { meta: generic, kind: crate::error::DeleteCacheSecurityGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteCacheSecurityGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cache_security_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCacheSecurityGroupOutput,
    crate::error::DeleteCacheSecurityGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_cache_security_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cache_subnet_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCacheSubnetGroupOutput,
    crate::error::DeleteCacheSubnetGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCacheSubnetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteCacheSubnetGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheSubnetGroupInUse" => crate::error::DeleteCacheSubnetGroupError {
            meta: generic,
            kind: crate::error::DeleteCacheSubnetGroupErrorKind::CacheSubnetGroupInUse({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cache_subnet_group_in_use::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_subnet_group_in_use_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheSubnetGroupNotFoundFault" => crate::error::DeleteCacheSubnetGroupError {
            meta: generic,
            kind: crate::error::DeleteCacheSubnetGroupErrorKind::CacheSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCacheSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteCacheSubnetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cache_subnet_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCacheSubnetGroupOutput,
    crate::error::DeleteCacheSubnetGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_cache_subnet_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_global_replication_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteGlobalReplicationGroupOutput,
    crate::error::DeleteGlobalReplicationGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteGlobalReplicationGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteGlobalReplicationGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalReplicationGroupNotFoundFault" => crate::error::DeleteGlobalReplicationGroupError { meta: generic, kind: crate::error::DeleteGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::global_replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGlobalReplicationGroupState" => crate::error::DeleteGlobalReplicationGroupError { meta: generic, kind: crate::error::DeleteGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_global_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DeleteGlobalReplicationGroupError { meta: generic, kind: crate::error::DeleteGlobalReplicationGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteGlobalReplicationGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_global_replication_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteGlobalReplicationGroupOutput,
    crate::error::DeleteGlobalReplicationGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_global_replication_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_global_replication_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteGlobalReplicationGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_replication_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReplicationGroupOutput,
    crate::error::DeleteReplicationGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteReplicationGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteReplicationGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => crate::error::DeleteReplicationGroupError {
            meta: generic,
            kind:
                crate::error::DeleteReplicationGroupErrorKind::InvalidParameterCombinationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationGroupError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidParameterValue" => crate::error::DeleteReplicationGroupError {
            meta: generic,
            kind: crate::error::DeleteReplicationGroupErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidReplicationGroupState" => crate::error::DeleteReplicationGroupError {
            meta: generic,
            kind: crate::error::DeleteReplicationGroupErrorKind::InvalidReplicationGroupStateFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_replication_group_state_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ReplicationGroupNotFoundFault" => crate::error::DeleteReplicationGroupError {
            meta: generic,
            kind: crate::error::DeleteReplicationGroupErrorKind::ReplicationGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotAlreadyExistsFault" => crate::error::DeleteReplicationGroupError {
            meta: generic,
            kind: crate::error::DeleteReplicationGroupErrorKind::SnapshotAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotFeatureNotSupportedFault" => crate::error::DeleteReplicationGroupError {
            meta: generic,
            kind: crate::error::DeleteReplicationGroupErrorKind::SnapshotFeatureNotSupportedFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::snapshot_feature_not_supported_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_snapshot_feature_not_supported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "SnapshotQuotaExceededFault" => crate::error::DeleteReplicationGroupError {
            meta: generic,
            kind: crate::error::DeleteReplicationGroupErrorKind::SnapshotQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteReplicationGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_replication_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReplicationGroupOutput,
    crate::error::DeleteReplicationGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_replication_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_replication_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteReplicationGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSnapshotOutput, crate::error::DeleteSnapshotError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => crate::error::DeleteSnapshotError {
            meta: generic,
            kind: crate::error::DeleteSnapshotErrorKind::InvalidParameterCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::DeleteSnapshotError {
            meta: generic,
            kind: crate::error::DeleteSnapshotErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSnapshotState" => crate::error::DeleteSnapshotError {
            meta: generic,
            kind: crate::error::DeleteSnapshotErrorKind::InvalidSnapshotStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotNotFoundFault" => crate::error::DeleteSnapshotError {
            meta: generic,
            kind: crate::error::DeleteSnapshotErrorKind::SnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSnapshotOutput, crate::error::DeleteSnapshotError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DefaultUserAssociatedToUserGroup" => {
            crate::error::DeleteUserError {
                meta: generic,
                kind: crate::error::DeleteUserErrorKind::DefaultUserAssociatedToUserGroupFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::default_user_associated_to_user_group_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_default_user_associated_to_user_group_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterValue" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserState" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::InvalidUserStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_user_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_user_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleNotFoundFault" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::ServiceLinkedRoleNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_linked_role_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFound" => {
            crate::error::DeleteUserError {
                meta: generic,
                kind: crate::error::DeleteUserErrorKind::UserNotFoundFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::user_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_user_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_user(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserGroupOutput, crate::error::DeleteUserGroupError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUserGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValue" => crate::error::DeleteUserGroupError {
            meta: generic,
            kind: crate::error::DeleteUserGroupErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserGroupState" => crate::error::DeleteUserGroupError {
            meta: generic,
            kind: crate::error::DeleteUserGroupErrorKind::InvalidUserGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_user_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_user_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleNotFoundFault" => crate::error::DeleteUserGroupError {
            meta: generic,
            kind: crate::error::DeleteUserGroupErrorKind::ServiceLinkedRoleNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_linked_role_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserGroupNotFound" => crate::error::DeleteUserGroupError {
            meta: generic,
            kind: crate::error::DeleteUserGroupErrorKind::UserGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_user_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteUserGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserGroupOutput, crate::error::DeleteUserGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_user_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteUserGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_clusters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCacheClustersOutput,
    crate::error::DescribeCacheClustersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCacheClustersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeCacheClustersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheClusterNotFound" => crate::error::DescribeCacheClustersError {
            meta: generic,
            kind: crate::error::DescribeCacheClustersErrorKind::CacheClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheClustersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => crate::error::DescribeCacheClustersError {
            meta: generic,
            kind:
                crate::error::DescribeCacheClustersErrorKind::InvalidParameterCombinationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheClustersError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidParameterValue" => crate::error::DescribeCacheClustersError {
            meta: generic,
            kind: crate::error::DescribeCacheClustersErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheClustersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeCacheClustersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_clusters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCacheClustersOutput,
    crate::error::DescribeCacheClustersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cache_clusters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_cache_clusters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCacheClustersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_engine_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCacheEngineVersionsOutput,
    crate::error::DescribeCacheEngineVersionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCacheEngineVersionsError::unhandled)?;
    Err(crate::error::DescribeCacheEngineVersionsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_engine_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCacheEngineVersionsOutput,
    crate::error::DescribeCacheEngineVersionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cache_engine_versions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_cache_engine_versions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCacheEngineVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_parameter_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCacheParameterGroupsOutput,
    crate::error::DescribeCacheParameterGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCacheParameterGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeCacheParameterGroupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheParameterGroupNotFound" => crate::error::DescribeCacheParameterGroupsError { meta: generic, kind: crate::error::DescribeCacheParameterGroupsErrorKind::CacheParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheParameterGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::DescribeCacheParameterGroupsError { meta: generic, kind: crate::error::DescribeCacheParameterGroupsErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheParameterGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DescribeCacheParameterGroupsError { meta: generic, kind: crate::error::DescribeCacheParameterGroupsErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheParameterGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeCacheParameterGroupsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_parameter_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCacheParameterGroupsOutput,
    crate::error::DescribeCacheParameterGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cache_parameter_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_cache_parameter_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCacheParameterGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_parameters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCacheParametersOutput,
    crate::error::DescribeCacheParametersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCacheParametersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeCacheParametersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheParameterGroupNotFound" => crate::error::DescribeCacheParametersError {
            meta: generic,
            kind: crate::error::DescribeCacheParametersErrorKind::CacheParameterGroupNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::cache_parameter_group_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheParametersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidParameterCombination" => crate::error::DescribeCacheParametersError {
            meta: generic,
            kind:
                crate::error::DescribeCacheParametersErrorKind::InvalidParameterCombinationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheParametersError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidParameterValue" => crate::error::DescribeCacheParametersError {
            meta: generic,
            kind: crate::error::DescribeCacheParametersErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheParametersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeCacheParametersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_parameters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCacheParametersOutput,
    crate::error::DescribeCacheParametersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cache_parameters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_cache_parameters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCacheParametersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_security_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCacheSecurityGroupsOutput,
    crate::error::DescribeCacheSecurityGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCacheSecurityGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeCacheSecurityGroupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheSecurityGroupNotFound" => crate::error::DescribeCacheSecurityGroupsError { meta: generic, kind: crate::error::DescribeCacheSecurityGroupsErrorKind::CacheSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheSecurityGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::DescribeCacheSecurityGroupsError { meta: generic, kind: crate::error::DescribeCacheSecurityGroupsErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheSecurityGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DescribeCacheSecurityGroupsError { meta: generic, kind: crate::error::DescribeCacheSecurityGroupsErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheSecurityGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeCacheSecurityGroupsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_security_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCacheSecurityGroupsOutput,
    crate::error::DescribeCacheSecurityGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cache_security_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_cache_security_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCacheSecurityGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_subnet_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCacheSubnetGroupsOutput,
    crate::error::DescribeCacheSubnetGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCacheSubnetGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeCacheSubnetGroupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheSubnetGroupNotFoundFault" => crate::error::DescribeCacheSubnetGroupsError {
            meta: generic,
            kind: crate::error::DescribeCacheSubnetGroupsErrorKind::CacheSubnetGroupNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::cache_subnet_group_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_cache_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCacheSubnetGroupsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeCacheSubnetGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cache_subnet_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCacheSubnetGroupsOutput,
    crate::error::DescribeCacheSubnetGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cache_subnet_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_cache_subnet_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCacheSubnetGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_engine_default_parameters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEngineDefaultParametersOutput,
    crate::error::DescribeEngineDefaultParametersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEngineDefaultParametersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeEngineDefaultParametersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => crate::error::DescribeEngineDefaultParametersError { meta: generic, kind: crate::error::DescribeEngineDefaultParametersErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEngineDefaultParametersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DescribeEngineDefaultParametersError { meta: generic, kind: crate::error::DescribeEngineDefaultParametersErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEngineDefaultParametersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeEngineDefaultParametersError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_engine_default_parameters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEngineDefaultParametersOutput,
    crate::error::DescribeEngineDefaultParametersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_engine_default_parameters_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_engine_default_parameters(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeEngineDefaultParametersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_events_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEventsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeEventsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => crate::error::DescribeEventsError {
            meta: generic,
            kind: crate::error::DescribeEventsErrorKind::InvalidParameterCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::DescribeEventsError {
            meta: generic,
            kind: crate::error::DescribeEventsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeEventsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_events_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_events_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_events(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEventsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_global_replication_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeGlobalReplicationGroupsOutput,
    crate::error::DescribeGlobalReplicationGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeGlobalReplicationGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeGlobalReplicationGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalReplicationGroupNotFoundFault" => crate::error::DescribeGlobalReplicationGroupsError { meta: generic, kind: crate::error::DescribeGlobalReplicationGroupsErrorKind::GlobalReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::global_replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeGlobalReplicationGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::DescribeGlobalReplicationGroupsError { meta: generic, kind: crate::error::DescribeGlobalReplicationGroupsErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeGlobalReplicationGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DescribeGlobalReplicationGroupsError { meta: generic, kind: crate::error::DescribeGlobalReplicationGroupsErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeGlobalReplicationGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeGlobalReplicationGroupsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_global_replication_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeGlobalReplicationGroupsOutput,
    crate::error::DescribeGlobalReplicationGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_global_replication_groups_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_global_replication_groups(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeGlobalReplicationGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationGroupsOutput,
    crate::error::DescribeReplicationGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReplicationGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeReplicationGroupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => crate::error::DescribeReplicationGroupsError { meta: generic, kind: crate::error::DescribeReplicationGroupsErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DescribeReplicationGroupsError { meta: generic, kind: crate::error::DescribeReplicationGroupsErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReplicationGroupNotFoundFault" => crate::error::DescribeReplicationGroupsError { meta: generic, kind: crate::error::DescribeReplicationGroupsErrorKind::ReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeReplicationGroupsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationGroupsOutput,
    crate::error::DescribeReplicationGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_replication_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_replication_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeReplicationGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_cache_nodes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedCacheNodesOutput,
    crate::error::DescribeReservedCacheNodesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReservedCacheNodesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeReservedCacheNodesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => crate::error::DescribeReservedCacheNodesError { meta: generic, kind: crate::error::DescribeReservedCacheNodesErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedCacheNodesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DescribeReservedCacheNodesError { meta: generic, kind: crate::error::DescribeReservedCacheNodesErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedCacheNodesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReservedCacheNodeNotFound" => crate::error::DescribeReservedCacheNodesError { meta: generic, kind: crate::error::DescribeReservedCacheNodesErrorKind::ReservedCacheNodeNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_cache_node_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_cache_node_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedCacheNodesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeReservedCacheNodesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_cache_nodes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedCacheNodesOutput,
    crate::error::DescribeReservedCacheNodesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_reserved_cache_nodes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_reserved_cache_nodes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeReservedCacheNodesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_cache_nodes_offerings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedCacheNodesOfferingsOutput,
    crate::error::DescribeReservedCacheNodesOfferingsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReservedCacheNodesOfferingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeReservedCacheNodesOfferingsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => crate::error::DescribeReservedCacheNodesOfferingsError { meta: generic, kind: crate::error::DescribeReservedCacheNodesOfferingsErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedCacheNodesOfferingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DescribeReservedCacheNodesOfferingsError { meta: generic, kind: crate::error::DescribeReservedCacheNodesOfferingsErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedCacheNodesOfferingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReservedCacheNodesOfferingNotFound" => crate::error::DescribeReservedCacheNodesOfferingsError { meta: generic, kind: crate::error::DescribeReservedCacheNodesOfferingsErrorKind::ReservedCacheNodesOfferingNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_cache_nodes_offering_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_cache_nodes_offering_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedCacheNodesOfferingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeReservedCacheNodesOfferingsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_cache_nodes_offerings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedCacheNodesOfferingsOutput,
    crate::error::DescribeReservedCacheNodesOfferingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_reserved_cache_nodes_offerings_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_reserved_cache_nodes_offerings(response.body().as_ref(), output).map_err(crate::error::DescribeReservedCacheNodesOfferingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_service_updates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeServiceUpdatesOutput,
    crate::error::DescribeServiceUpdatesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeServiceUpdatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeServiceUpdatesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => crate::error::DescribeServiceUpdatesError {
            meta: generic,
            kind:
                crate::error::DescribeServiceUpdatesErrorKind::InvalidParameterCombinationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeServiceUpdatesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidParameterValue" => crate::error::DescribeServiceUpdatesError {
            meta: generic,
            kind: crate::error::DescribeServiceUpdatesErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeServiceUpdatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUpdateNotFoundFault" => crate::error::DescribeServiceUpdatesError {
            meta: generic,
            kind: crate::error::DescribeServiceUpdatesErrorKind::ServiceUpdateNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_update_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_update_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeServiceUpdatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeServiceUpdatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_service_updates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeServiceUpdatesOutput,
    crate::error::DescribeServiceUpdatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_service_updates_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_service_updates(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeServiceUpdatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_snapshots_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeSnapshotsOutput, crate::error::DescribeSnapshotsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSnapshotsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeSnapshotsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheClusterNotFound" => crate::error::DescribeSnapshotsError {
            meta: generic,
            kind: crate::error::DescribeSnapshotsErrorKind::CacheClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => crate::error::DescribeSnapshotsError {
            meta: generic,
            kind: crate::error::DescribeSnapshotsErrorKind::InvalidParameterCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::DescribeSnapshotsError {
            meta: generic,
            kind: crate::error::DescribeSnapshotsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotNotFoundFault" => crate::error::DescribeSnapshotsError {
            meta: generic,
            kind: crate::error::DescribeSnapshotsErrorKind::SnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeSnapshotsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_snapshots_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeSnapshotsOutput, crate::error::DescribeSnapshotsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_snapshots_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_snapshots(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSnapshotsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_update_actions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUpdateActionsOutput,
    crate::error::DescribeUpdateActionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeUpdateActionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeUpdateActionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => crate::error::DescribeUpdateActionsError {
            meta: generic,
            kind:
                crate::error::DescribeUpdateActionsErrorKind::InvalidParameterCombinationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeUpdateActionsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidParameterValue" => crate::error::DescribeUpdateActionsError {
            meta: generic,
            kind: crate::error::DescribeUpdateActionsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeUpdateActionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeUpdateActionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_update_actions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUpdateActionsOutput,
    crate::error::DescribeUpdateActionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_update_actions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_update_actions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeUpdateActionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUserGroupsOutput,
    crate::error::DescribeUserGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeUserGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeUserGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => {
            crate::error::DescribeUserGroupsError {
                meta: generic,
                kind:
                    crate::error::DescribeUserGroupsErrorKind::InvalidParameterCombinationException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserGroupsError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "ServiceLinkedRoleNotFoundFault" => crate::error::DescribeUserGroupsError {
            meta: generic,
            kind: crate::error::DescribeUserGroupsErrorKind::ServiceLinkedRoleNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_linked_role_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserGroupNotFound" => crate::error::DescribeUserGroupsError {
            meta: generic,
            kind: crate::error::DescribeUserGroupsErrorKind::UserGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_user_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeUserGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUserGroupsOutput,
    crate::error::DescribeUserGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_user_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_user_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeUserGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_users_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeUsersOutput, crate::error::DescribeUsersError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeUsersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeUsersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => crate::error::DescribeUsersError {
            meta: generic,
            kind: crate::error::DescribeUsersErrorKind::InvalidParameterCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeUsersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleNotFoundFault" => crate::error::DescribeUsersError {
            meta: generic,
            kind: crate::error::DescribeUsersErrorKind::ServiceLinkedRoleNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_linked_role_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeUsersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFound" => {
            crate::error::DescribeUsersError {
                meta: generic,
                kind: crate::error::DescribeUsersErrorKind::UserNotFoundFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::user_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_user_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeUsersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeUsersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_users_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeUsersOutput, crate::error::DescribeUsersError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_users_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_users(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeUsersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_global_replication_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateGlobalReplicationGroupOutput,
    crate::error::DisassociateGlobalReplicationGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateGlobalReplicationGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateGlobalReplicationGroupError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalReplicationGroupNotFoundFault" => crate::error::DisassociateGlobalReplicationGroupError { meta: generic, kind: crate::error::DisassociateGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::global_replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DisassociateGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGlobalReplicationGroupState" => crate::error::DisassociateGlobalReplicationGroupError { meta: generic, kind: crate::error::DisassociateGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_global_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DisassociateGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::DisassociateGlobalReplicationGroupError { meta: generic, kind: crate::error::DisassociateGlobalReplicationGroupErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DisassociateGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DisassociateGlobalReplicationGroupError { meta: generic, kind: crate::error::DisassociateGlobalReplicationGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DisassociateGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DisassociateGlobalReplicationGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_global_replication_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateGlobalReplicationGroupOutput,
    crate::error::DisassociateGlobalReplicationGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::disassociate_global_replication_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_disassociate_global_replication_group(response.body().as_ref(), output).map_err(crate::error::DisassociateGlobalReplicationGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_failover_global_replication_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::FailoverGlobalReplicationGroupOutput,
    crate::error::FailoverGlobalReplicationGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::FailoverGlobalReplicationGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::FailoverGlobalReplicationGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalReplicationGroupNotFoundFault" => crate::error::FailoverGlobalReplicationGroupError { meta: generic, kind: crate::error::FailoverGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::global_replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::FailoverGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGlobalReplicationGroupState" => crate::error::FailoverGlobalReplicationGroupError { meta: generic, kind: crate::error::FailoverGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_global_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::FailoverGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::FailoverGlobalReplicationGroupError { meta: generic, kind: crate::error::FailoverGlobalReplicationGroupErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::FailoverGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::FailoverGlobalReplicationGroupError { meta: generic, kind: crate::error::FailoverGlobalReplicationGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::FailoverGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::FailoverGlobalReplicationGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_failover_global_replication_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::FailoverGlobalReplicationGroupOutput,
    crate::error::FailoverGlobalReplicationGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::failover_global_replication_group_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_failover_global_replication_group(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::FailoverGlobalReplicationGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_increase_node_groups_in_global_replication_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::IncreaseNodeGroupsInGlobalReplicationGroupOutput,
    crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalReplicationGroupNotFoundFault" => crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError { meta: generic, kind: crate::error::IncreaseNodeGroupsInGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::global_replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGlobalReplicationGroupState" => crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError { meta: generic, kind: crate::error::IncreaseNodeGroupsInGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_global_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError { meta: generic, kind: crate::error::IncreaseNodeGroupsInGlobalReplicationGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_increase_node_groups_in_global_replication_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::IncreaseNodeGroupsInGlobalReplicationGroupOutput,
    crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::increase_node_groups_in_global_replication_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_increase_node_groups_in_global_replication_group(response.body().as_ref(), output).map_err(crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_increase_replica_count_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::IncreaseReplicaCountOutput,
    crate::error::IncreaseReplicaCountError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::IncreaseReplicaCountError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterQuotaForCustomerExceeded" => crate::error::IncreaseReplicaCountError { meta: generic, kind: crate::error::IncreaseReplicaCountErrorKind::ClusterQuotaForCustomerExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_quota_for_customer_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_quota_for_customer_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientCacheClusterCapacity" => crate::error::IncreaseReplicaCountError { meta: generic, kind: crate::error::IncreaseReplicaCountErrorKind::InsufficientCacheClusterCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_cache_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_cache_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCacheClusterState" => crate::error::IncreaseReplicaCountError { meta: generic, kind: crate::error::IncreaseReplicaCountErrorKind::InvalidCacheClusterStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cache_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidKMSKeyFault" => crate::error::IncreaseReplicaCountError { meta: generic, kind: crate::error::IncreaseReplicaCountErrorKind::InvalidKmsKeyFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_kms_key_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_kms_key_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::IncreaseReplicaCountError { meta: generic, kind: crate::error::IncreaseReplicaCountErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::IncreaseReplicaCountError { meta: generic, kind: crate::error::IncreaseReplicaCountErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidReplicationGroupState" => crate::error::IncreaseReplicaCountError { meta: generic, kind: crate::error::IncreaseReplicaCountErrorKind::InvalidReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidVPCNetworkStateFault" => crate::error::IncreaseReplicaCountError { meta: generic, kind: crate::error::IncreaseReplicaCountErrorKind::InvalidVpcNetworkStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NodeGroupsPerReplicationGroupQuotaExceeded" => crate::error::IncreaseReplicaCountError { meta: generic, kind: crate::error::IncreaseReplicaCountErrorKind::NodeGroupsPerReplicationGroupQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::node_groups_per_replication_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_groups_per_replication_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NodeQuotaForCustomerExceeded" => crate::error::IncreaseReplicaCountError { meta: generic, kind: crate::error::IncreaseReplicaCountErrorKind::NodeQuotaForCustomerExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::node_quota_for_customer_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_quota_for_customer_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoOperationFault" => crate::error::IncreaseReplicaCountError { meta: generic, kind: crate::error::IncreaseReplicaCountErrorKind::NoOperationFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReplicationGroupNotFoundFault" => crate::error::IncreaseReplicaCountError { meta: generic, kind: crate::error::IncreaseReplicaCountErrorKind::ReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::IncreaseReplicaCountError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_increase_replica_count_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::IncreaseReplicaCountOutput,
    crate::error::IncreaseReplicaCountError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::increase_replica_count_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_increase_replica_count(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::IncreaseReplicaCountError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_allowed_node_type_modifications_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAllowedNodeTypeModificationsOutput,
    crate::error::ListAllowedNodeTypeModificationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAllowedNodeTypeModificationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListAllowedNodeTypeModificationsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheClusterNotFound" => crate::error::ListAllowedNodeTypeModificationsError { meta: generic, kind: crate::error::ListAllowedNodeTypeModificationsErrorKind::CacheClusterNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAllowedNodeTypeModificationsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::ListAllowedNodeTypeModificationsError { meta: generic, kind: crate::error::ListAllowedNodeTypeModificationsErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAllowedNodeTypeModificationsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::ListAllowedNodeTypeModificationsError { meta: generic, kind: crate::error::ListAllowedNodeTypeModificationsErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAllowedNodeTypeModificationsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReplicationGroupNotFoundFault" => crate::error::ListAllowedNodeTypeModificationsError { meta: generic, kind: crate::error::ListAllowedNodeTypeModificationsErrorKind::ReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAllowedNodeTypeModificationsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListAllowedNodeTypeModificationsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_allowed_node_type_modifications_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAllowedNodeTypeModificationsOutput,
    crate::error::ListAllowedNodeTypeModificationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_allowed_node_type_modifications_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_list_allowed_node_type_modifications(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListAllowedNodeTypeModificationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheClusterNotFound" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::CacheClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheParameterGroupNotFound" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::CacheParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheSecurityGroupNotFound" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::CacheSecurityGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheSubnetGroupNotFoundFault" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::CacheSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidARN" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::InvalidArnFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_arn_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_arn_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidReplicationGroupState" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidReplicationGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicationGroupNotFoundFault" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ReplicationGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReservedCacheNodeNotFound" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ReservedCacheNodeNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::reserved_cache_node_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_cache_node_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotNotFoundFault" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::SnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserGroupNotFound" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::UserGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_user_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFound" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::UserNotFoundFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::user_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_user_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cache_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyCacheClusterOutput,
    crate::error::ModifyCacheClusterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyCacheClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyCacheClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheClusterNotFound" => crate::error::ModifyCacheClusterError {
            meta: generic,
            kind: crate::error::ModifyCacheClusterErrorKind::CacheClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheParameterGroupNotFound" => crate::error::ModifyCacheClusterError {
            meta: generic,
            kind: crate::error::ModifyCacheClusterErrorKind::CacheParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheSecurityGroupNotFound" => crate::error::ModifyCacheClusterError {
            meta: generic,
            kind: crate::error::ModifyCacheClusterErrorKind::CacheSecurityGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientCacheClusterCapacity" => crate::error::ModifyCacheClusterError {
            meta: generic,
            kind: crate::error::ModifyCacheClusterErrorKind::InsufficientCacheClusterCapacityFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::insufficient_cache_cluster_capacity_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_insufficient_cache_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidCacheClusterState" => crate::error::ModifyCacheClusterError {
            meta: generic,
            kind: crate::error::ModifyCacheClusterErrorKind::InvalidCacheClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_cache_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCacheSecurityGroupState" => crate::error::ModifyCacheClusterError {
            meta: generic,
            kind: crate::error::ModifyCacheClusterErrorKind::InvalidCacheSecurityGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_cache_security_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => {
            crate::error::ModifyCacheClusterError {
                meta: generic,
                kind:
                    crate::error::ModifyCacheClusterErrorKind::InvalidParameterCombinationException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheClusterError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InvalidParameterValue" => crate::error::ModifyCacheClusterError {
            meta: generic,
            kind: crate::error::ModifyCacheClusterErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidVPCNetworkStateFault" => crate::error::ModifyCacheClusterError {
            meta: generic,
            kind: crate::error::ModifyCacheClusterErrorKind::InvalidVpcNetworkStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NodeQuotaForClusterExceeded" => crate::error::ModifyCacheClusterError {
            meta: generic,
            kind: crate::error::ModifyCacheClusterErrorKind::NodeQuotaForClusterExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::node_quota_for_cluster_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_quota_for_cluster_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NodeQuotaForCustomerExceeded" => crate::error::ModifyCacheClusterError {
            meta: generic,
            kind: crate::error::ModifyCacheClusterErrorKind::NodeQuotaForCustomerExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::node_quota_for_customer_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_quota_for_customer_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyCacheClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cache_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyCacheClusterOutput,
    crate::error::ModifyCacheClusterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_cache_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_cache_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyCacheClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cache_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyCacheParameterGroupOutput,
    crate::error::ModifyCacheParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyCacheParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyCacheParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheParameterGroupNotFound" => crate::error::ModifyCacheParameterGroupError { meta: generic, kind: crate::error::ModifyCacheParameterGroupErrorKind::CacheParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCacheParameterGroupState" => crate::error::ModifyCacheParameterGroupError { meta: generic, kind: crate::error::ModifyCacheParameterGroupErrorKind::InvalidCacheParameterGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cache_parameter_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_parameter_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGlobalReplicationGroupState" => crate::error::ModifyCacheParameterGroupError { meta: generic, kind: crate::error::ModifyCacheParameterGroupErrorKind::InvalidGlobalReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_global_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::ModifyCacheParameterGroupError { meta: generic, kind: crate::error::ModifyCacheParameterGroupErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::ModifyCacheParameterGroupError { meta: generic, kind: crate::error::ModifyCacheParameterGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyCacheParameterGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cache_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyCacheParameterGroupOutput,
    crate::error::ModifyCacheParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_cache_parameter_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_cache_parameter_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyCacheParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cache_subnet_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyCacheSubnetGroupOutput,
    crate::error::ModifyCacheSubnetGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyCacheSubnetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyCacheSubnetGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheSubnetGroupNotFoundFault" => crate::error::ModifyCacheSubnetGroupError {
            meta: generic,
            kind: crate::error::ModifyCacheSubnetGroupErrorKind::CacheSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheSubnetQuotaExceededFault" => crate::error::ModifyCacheSubnetGroupError {
            meta: generic,
            kind: crate::error::ModifyCacheSubnetGroupErrorKind::CacheSubnetQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_subnet_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_subnet_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::ModifyCacheSubnetGroupError {
            meta: generic,
            kind: crate::error::ModifyCacheSubnetGroupErrorKind::InvalidSubnet({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ModifyCacheSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubnetInUse" => crate::error::ModifyCacheSubnetGroupError {
            meta: generic,
            kind: crate::error::ModifyCacheSubnetGroupErrorKind::SubnetInUse({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::subnet_in_use::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subnet_in_use_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ModifyCacheSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubnetNotAllowedFault" => crate::error::ModifyCacheSubnetGroupError {
            meta: generic,
            kind: crate::error::ModifyCacheSubnetGroupErrorKind::SubnetNotAllowedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::subnet_not_allowed_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subnet_not_allowed_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCacheSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyCacheSubnetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cache_subnet_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyCacheSubnetGroupOutput,
    crate::error::ModifyCacheSubnetGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_cache_subnet_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_cache_subnet_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyCacheSubnetGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_global_replication_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyGlobalReplicationGroupOutput,
    crate::error::ModifyGlobalReplicationGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyGlobalReplicationGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyGlobalReplicationGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalReplicationGroupNotFoundFault" => crate::error::ModifyGlobalReplicationGroupError { meta: generic, kind: crate::error::ModifyGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::global_replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGlobalReplicationGroupState" => crate::error::ModifyGlobalReplicationGroupError { meta: generic, kind: crate::error::ModifyGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_global_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::ModifyGlobalReplicationGroupError { meta: generic, kind: crate::error::ModifyGlobalReplicationGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyGlobalReplicationGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_global_replication_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyGlobalReplicationGroupOutput,
    crate::error::ModifyGlobalReplicationGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_global_replication_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_global_replication_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyGlobalReplicationGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_replication_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyReplicationGroupOutput,
    crate::error::ModifyReplicationGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyReplicationGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheClusterNotFound" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind: crate::error::ModifyReplicationGroupErrorKind::CacheClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheParameterGroupNotFound" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind: crate::error::ModifyReplicationGroupErrorKind::CacheParameterGroupNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::cache_parameter_group_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "CacheSecurityGroupNotFound" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind: crate::error::ModifyReplicationGroupErrorKind::CacheSecurityGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientCacheClusterCapacity" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind:
                crate::error::ModifyReplicationGroupErrorKind::InsufficientCacheClusterCapacityFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::insufficient_cache_cluster_capacity_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_insufficient_cache_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidCacheClusterState" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind: crate::error::ModifyReplicationGroupErrorKind::InvalidCacheClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_cache_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCacheSecurityGroupState" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind:
                crate::error::ModifyReplicationGroupErrorKind::InvalidCacheSecurityGroupStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_cache_security_group_state_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_cache_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidKMSKeyFault" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind: crate::error::ModifyReplicationGroupErrorKind::InvalidKmsKeyFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_kms_key_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_kms_key_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind:
                crate::error::ModifyReplicationGroupErrorKind::InvalidParameterCombinationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidParameterValue" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind: crate::error::ModifyReplicationGroupErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidReplicationGroupState" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind: crate::error::ModifyReplicationGroupErrorKind::InvalidReplicationGroupStateFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_replication_group_state_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidUserGroupState" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind: crate::error::ModifyReplicationGroupErrorKind::InvalidUserGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_user_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_user_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidVPCNetworkStateFault" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind: crate::error::ModifyReplicationGroupErrorKind::InvalidVpcNetworkStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NodeQuotaForClusterExceeded" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind: crate::error::ModifyReplicationGroupErrorKind::NodeQuotaForClusterExceededFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::node_quota_for_cluster_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_node_quota_for_cluster_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NodeQuotaForCustomerExceeded" => {
            crate::error::ModifyReplicationGroupError {
                meta: generic,
                kind:
                    crate::error::ModifyReplicationGroupErrorKind::NodeQuotaForCustomerExceededFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::node_quota_for_customer_exceeded_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_node_quota_for_customer_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "ReplicationGroupNotFoundFault" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind: crate::error::ModifyReplicationGroupErrorKind::ReplicationGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserGroupNotFound" => crate::error::ModifyReplicationGroupError {
            meta: generic,
            kind: crate::error::ModifyReplicationGroupErrorKind::UserGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_user_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyReplicationGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_replication_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyReplicationGroupOutput,
    crate::error::ModifyReplicationGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_replication_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_replication_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyReplicationGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_replication_group_shard_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyReplicationGroupShardConfigurationOutput,
    crate::error::ModifyReplicationGroupShardConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyReplicationGroupShardConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ModifyReplicationGroupShardConfigurationError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientCacheClusterCapacity" => crate::error::ModifyReplicationGroupShardConfigurationError { meta: generic, kind: crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InsufficientCacheClusterCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_cache_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_cache_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupShardConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCacheClusterState" => crate::error::ModifyReplicationGroupShardConfigurationError { meta: generic, kind: crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InvalidCacheClusterStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cache_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupShardConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidKMSKeyFault" => crate::error::ModifyReplicationGroupShardConfigurationError { meta: generic, kind: crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InvalidKmsKeyFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_kms_key_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_kms_key_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupShardConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::ModifyReplicationGroupShardConfigurationError { meta: generic, kind: crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupShardConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::ModifyReplicationGroupShardConfigurationError { meta: generic, kind: crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupShardConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidReplicationGroupState" => crate::error::ModifyReplicationGroupShardConfigurationError { meta: generic, kind: crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InvalidReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupShardConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidVPCNetworkStateFault" => crate::error::ModifyReplicationGroupShardConfigurationError { meta: generic, kind: crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InvalidVpcNetworkStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupShardConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NodeGroupsPerReplicationGroupQuotaExceeded" => crate::error::ModifyReplicationGroupShardConfigurationError { meta: generic, kind: crate::error::ModifyReplicationGroupShardConfigurationErrorKind::NodeGroupsPerReplicationGroupQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::node_groups_per_replication_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_groups_per_replication_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupShardConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NodeQuotaForCustomerExceeded" => crate::error::ModifyReplicationGroupShardConfigurationError { meta: generic, kind: crate::error::ModifyReplicationGroupShardConfigurationErrorKind::NodeQuotaForCustomerExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::node_quota_for_customer_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_quota_for_customer_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupShardConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReplicationGroupNotFoundFault" => crate::error::ModifyReplicationGroupShardConfigurationError { meta: generic, kind: crate::error::ModifyReplicationGroupShardConfigurationErrorKind::ReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupShardConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyReplicationGroupShardConfigurationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_replication_group_shard_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyReplicationGroupShardConfigurationOutput,
    crate::error::ModifyReplicationGroupShardConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::modify_replication_group_shard_configuration_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_replication_group_shard_configuration(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationGroupShardConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyUserOutput, crate::error::ModifyUserError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => crate::error::ModifyUserError {
            meta: generic,
            kind: crate::error::ModifyUserErrorKind::InvalidParameterCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::ModifyUserError {
            meta: generic,
            kind: crate::error::ModifyUserErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserState" => crate::error::ModifyUserError {
            meta: generic,
            kind: crate::error::ModifyUserErrorKind::InvalidUserStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_user_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_user_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleNotFoundFault" => crate::error::ModifyUserError {
            meta: generic,
            kind: crate::error::ModifyUserErrorKind::ServiceLinkedRoleNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_linked_role_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFound" => {
            crate::error::ModifyUserError {
                meta: generic,
                kind: crate::error::ModifyUserErrorKind::UserNotFoundFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::user_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_user_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUserError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ModifyUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyUserOutput, crate::error::ModifyUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_user_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_user(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_user_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyUserGroupOutput, crate::error::ModifyUserGroupError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyUserGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyUserGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DefaultUserRequired" => crate::error::ModifyUserGroupError {
            meta: generic,
            kind: crate::error::ModifyUserGroupErrorKind::DefaultUserRequired({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::default_user_required::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_default_user_required_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateUserName" => crate::error::ModifyUserGroupError {
            meta: generic,
            kind: crate::error::ModifyUserGroupErrorKind::DuplicateUserNameFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_user_name_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_user_name_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => crate::error::ModifyUserGroupError {
            meta: generic,
            kind: crate::error::ModifyUserGroupErrorKind::InvalidParameterCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::ModifyUserGroupError {
            meta: generic,
            kind: crate::error::ModifyUserGroupErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserGroupState" => crate::error::ModifyUserGroupError {
            meta: generic,
            kind: crate::error::ModifyUserGroupErrorKind::InvalidUserGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_user_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_user_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleNotFoundFault" => crate::error::ModifyUserGroupError {
            meta: generic,
            kind: crate::error::ModifyUserGroupErrorKind::ServiceLinkedRoleNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_linked_role_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserGroupNotFound" => crate::error::ModifyUserGroupError {
            meta: generic,
            kind: crate::error::ModifyUserGroupErrorKind::UserGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_user_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUserGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFound" => {
            crate::error::ModifyUserGroupError {
                meta: generic,
                kind: crate::error::ModifyUserGroupErrorKind::UserNotFoundFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::user_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_user_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUserGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ModifyUserGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_user_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyUserGroupOutput, crate::error::ModifyUserGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_user_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_user_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyUserGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_purchase_reserved_cache_nodes_offering_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PurchaseReservedCacheNodesOfferingOutput,
    crate::error::PurchaseReservedCacheNodesOfferingError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PurchaseReservedCacheNodesOfferingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PurchaseReservedCacheNodesOfferingError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterCombination" => crate::error::PurchaseReservedCacheNodesOfferingError { meta: generic, kind: crate::error::PurchaseReservedCacheNodesOfferingErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedCacheNodesOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::PurchaseReservedCacheNodesOfferingError { meta: generic, kind: crate::error::PurchaseReservedCacheNodesOfferingErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedCacheNodesOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReservedCacheNodeAlreadyExists" => crate::error::PurchaseReservedCacheNodesOfferingError { meta: generic, kind: crate::error::PurchaseReservedCacheNodesOfferingErrorKind::ReservedCacheNodeAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_cache_node_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_cache_node_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedCacheNodesOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReservedCacheNodeQuotaExceeded" => crate::error::PurchaseReservedCacheNodesOfferingError { meta: generic, kind: crate::error::PurchaseReservedCacheNodesOfferingErrorKind::ReservedCacheNodeQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_cache_node_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_cache_node_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedCacheNodesOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReservedCacheNodesOfferingNotFound" => crate::error::PurchaseReservedCacheNodesOfferingError { meta: generic, kind: crate::error::PurchaseReservedCacheNodesOfferingErrorKind::ReservedCacheNodesOfferingNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_cache_nodes_offering_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_cache_nodes_offering_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedCacheNodesOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TagQuotaPerResourceExceeded" => crate::error::PurchaseReservedCacheNodesOfferingError { meta: generic, kind: crate::error::PurchaseReservedCacheNodesOfferingErrorKind::TagQuotaPerResourceExceeded({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tag_quota_per_resource_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_quota_per_resource_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedCacheNodesOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::PurchaseReservedCacheNodesOfferingError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_purchase_reserved_cache_nodes_offering_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PurchaseReservedCacheNodesOfferingOutput,
    crate::error::PurchaseReservedCacheNodesOfferingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::purchase_reserved_cache_nodes_offering_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_purchase_reserved_cache_nodes_offering(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedCacheNodesOfferingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_rebalance_slots_in_global_replication_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RebalanceSlotsInGlobalReplicationGroupOutput,
    crate::error::RebalanceSlotsInGlobalReplicationGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RebalanceSlotsInGlobalReplicationGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::RebalanceSlotsInGlobalReplicationGroupError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalReplicationGroupNotFoundFault" => crate::error::RebalanceSlotsInGlobalReplicationGroupError { meta: generic, kind: crate::error::RebalanceSlotsInGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::global_replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RebalanceSlotsInGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGlobalReplicationGroupState" => crate::error::RebalanceSlotsInGlobalReplicationGroupError { meta: generic, kind: crate::error::RebalanceSlotsInGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_global_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RebalanceSlotsInGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::RebalanceSlotsInGlobalReplicationGroupError { meta: generic, kind: crate::error::RebalanceSlotsInGlobalReplicationGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RebalanceSlotsInGlobalReplicationGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RebalanceSlotsInGlobalReplicationGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_rebalance_slots_in_global_replication_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RebalanceSlotsInGlobalReplicationGroupOutput,
    crate::error::RebalanceSlotsInGlobalReplicationGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::rebalance_slots_in_global_replication_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_rebalance_slots_in_global_replication_group(response.body().as_ref(), output).map_err(crate::error::RebalanceSlotsInGlobalReplicationGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_cache_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RebootCacheClusterOutput,
    crate::error::RebootCacheClusterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RebootCacheClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RebootCacheClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheClusterNotFound" => crate::error::RebootCacheClusterError {
            meta: generic,
            kind: crate::error::RebootCacheClusterErrorKind::CacheClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RebootCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCacheClusterState" => crate::error::RebootCacheClusterError {
            meta: generic,
            kind: crate::error::RebootCacheClusterErrorKind::InvalidCacheClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_cache_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RebootCacheClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RebootCacheClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_cache_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RebootCacheClusterOutput,
    crate::error::RebootCacheClusterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reboot_cache_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_reboot_cache_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RebootCacheClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_from_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveTagsFromResourceOutput,
    crate::error::RemoveTagsFromResourceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveTagsFromResourceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheClusterNotFound" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::CacheClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheParameterGroupNotFound" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::CacheParameterGroupNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::cache_parameter_group_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "CacheSecurityGroupNotFound" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::CacheSecurityGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CacheSubnetGroupNotFoundFault" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::CacheSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cache_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidARN" => {
            crate::error::RemoveTagsFromResourceError {
                meta: generic,
                kind: crate::error::RemoveTagsFromResourceErrorKind::InvalidArnFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_arn_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_arn_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidReplicationGroupState" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::InvalidReplicationGroupStateFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_replication_group_state_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ReplicationGroupNotFoundFault" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::ReplicationGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReservedCacheNodeNotFound" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::ReservedCacheNodeNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::reserved_cache_node_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_cache_node_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotNotFoundFault" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::SnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagNotFound" => {
            crate::error::RemoveTagsFromResourceError {
                meta: generic,
                kind: crate::error::RemoveTagsFromResourceErrorKind::TagNotFoundFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::tag_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_tag_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UserGroupNotFound" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::UserGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_user_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFound" => {
            crate::error::RemoveTagsFromResourceError {
                meta: generic,
                kind: crate::error::RemoveTagsFromResourceErrorKind::UserNotFoundFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::user_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_user_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RemoveTagsFromResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_from_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveTagsFromResourceOutput,
    crate::error::RemoveTagsFromResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_tags_from_resource_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_remove_tags_from_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_cache_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetCacheParameterGroupOutput,
    crate::error::ResetCacheParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResetCacheParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ResetCacheParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CacheParameterGroupNotFound" => crate::error::ResetCacheParameterGroupError { meta: generic, kind: crate::error::ResetCacheParameterGroupErrorKind::CacheParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResetCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCacheParameterGroupState" => crate::error::ResetCacheParameterGroupError { meta: generic, kind: crate::error::ResetCacheParameterGroupErrorKind::InvalidCacheParameterGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cache_parameter_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_parameter_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResetCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGlobalReplicationGroupState" => crate::error::ResetCacheParameterGroupError { meta: generic, kind: crate::error::ResetCacheParameterGroupErrorKind::InvalidGlobalReplicationGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_global_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResetCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::ResetCacheParameterGroupError { meta: generic, kind: crate::error::ResetCacheParameterGroupErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ResetCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::ResetCacheParameterGroupError { meta: generic, kind: crate::error::ResetCacheParameterGroupErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ResetCacheParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ResetCacheParameterGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_cache_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetCacheParameterGroupOutput,
    crate::error::ResetCacheParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reset_cache_parameter_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_reset_cache_parameter_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ResetCacheParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_cache_security_group_ingress_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RevokeCacheSecurityGroupIngressOutput,
    crate::error::RevokeCacheSecurityGroupIngressError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RevokeCacheSecurityGroupIngressError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RevokeCacheSecurityGroupIngressError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationNotFound" => crate::error::RevokeCacheSecurityGroupIngressError { meta: generic, kind: crate::error::RevokeCacheSecurityGroupIngressErrorKind::AuthorizationNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeCacheSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CacheSecurityGroupNotFound" => crate::error::RevokeCacheSecurityGroupIngressError { meta: generic, kind: crate::error::RevokeCacheSecurityGroupIngressErrorKind::CacheSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cache_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeCacheSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCacheSecurityGroupState" => crate::error::RevokeCacheSecurityGroupIngressError { meta: generic, kind: crate::error::RevokeCacheSecurityGroupIngressErrorKind::InvalidCacheSecurityGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cache_security_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeCacheSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::RevokeCacheSecurityGroupIngressError { meta: generic, kind: crate::error::RevokeCacheSecurityGroupIngressErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeCacheSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::RevokeCacheSecurityGroupIngressError { meta: generic, kind: crate::error::RevokeCacheSecurityGroupIngressErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeCacheSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RevokeCacheSecurityGroupIngressError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_cache_security_group_ingress_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RevokeCacheSecurityGroupIngressOutput,
    crate::error::RevokeCacheSecurityGroupIngressError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::revoke_cache_security_group_ingress_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_revoke_cache_security_group_ingress(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::RevokeCacheSecurityGroupIngressError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_migration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartMigrationOutput, crate::error::StartMigrationError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartMigrationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartMigrationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValue" => crate::error::StartMigrationError {
            meta: generic,
            kind: crate::error::StartMigrationErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::StartMigrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidReplicationGroupState" => crate::error::StartMigrationError {
            meta: generic,
            kind: crate::error::StartMigrationErrorKind::InvalidReplicationGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartMigrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicationGroupAlreadyUnderMigrationFault" => crate::error::StartMigrationError {
            meta: generic,
            kind: crate::error::StartMigrationErrorKind::ReplicationGroupAlreadyUnderMigrationFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::replication_group_already_under_migration_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_replication_group_already_under_migration_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartMigrationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ReplicationGroupNotFoundFault" => crate::error::StartMigrationError {
            meta: generic,
            kind: crate::error::StartMigrationErrorKind::ReplicationGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartMigrationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartMigrationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_migration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartMigrationOutput, crate::error::StartMigrationError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_migration_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_start_migration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartMigrationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_test_failover_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TestFailoverOutput, crate::error::TestFailoverError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TestFailoverError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TestFailoverError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "APICallRateForCustomerExceeded" => {
            crate::error::TestFailoverError {
                meta: generic,
                kind: crate::error::TestFailoverErrorKind::ApiCallRateForCustomerExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::api_call_rate_for_customer_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_api_call_rate_for_customer_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::TestFailoverError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidCacheClusterState" => crate::error::TestFailoverError {
            meta: generic,
            kind: crate::error::TestFailoverErrorKind::InvalidCacheClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_cache_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cache_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::TestFailoverError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidKMSKeyFault" => crate::error::TestFailoverError {
            meta: generic,
            kind: crate::error::TestFailoverErrorKind::InvalidKmsKeyFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_kms_key_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_kms_key_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::TestFailoverError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => crate::error::TestFailoverError {
            meta: generic,
            kind: crate::error::TestFailoverErrorKind::InvalidParameterCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TestFailoverError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::TestFailoverError {
            meta: generic,
            kind: crate::error::TestFailoverErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TestFailoverError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidReplicationGroupState" => crate::error::TestFailoverError {
            meta: generic,
            kind: crate::error::TestFailoverErrorKind::InvalidReplicationGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_replication_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_replication_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::TestFailoverError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NodeGroupNotFoundFault" => crate::error::TestFailoverError {
            meta: generic,
            kind: crate::error::TestFailoverErrorKind::NodeGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::node_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_node_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::TestFailoverError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicationGroupNotFoundFault" => crate::error::TestFailoverError {
            meta: generic,
            kind: crate::error::TestFailoverErrorKind::ReplicationGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::replication_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_replication_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::TestFailoverError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TestFailoverNotAvailableFault" => crate::error::TestFailoverError {
            meta: generic,
            kind: crate::error::TestFailoverErrorKind::TestFailoverNotAvailableFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::test_failover_not_available_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_test_failover_not_available_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::TestFailoverError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TestFailoverError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_test_failover_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TestFailoverOutput, crate::error::TestFailoverError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::test_failover_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_test_failover(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::TestFailoverError::unhandled)?;
        output.build()
    })
}
