// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestFailoverOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub replication_group: std::option::Option<crate::model::ReplicationGroup>,
}
impl TestFailoverOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub fn replication_group(&self) -> std::option::Option<&crate::model::ReplicationGroup> {
        self.replication_group.as_ref()
    }
}
impl std::fmt::Debug for TestFailoverOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestFailoverOutput");
        formatter.field("replication_group", &self.replication_group);
        formatter.finish()
    }
}
/// See [`TestFailoverOutput`](crate::output::TestFailoverOutput)
pub mod test_failover_output {
    /// A builder for [`TestFailoverOutput`](crate::output::TestFailoverOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group: std::option::Option<crate::model::ReplicationGroup>,
    }
    impl Builder {
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn replication_group(mut self, input: crate::model::ReplicationGroup) -> Self {
            self.replication_group = Some(input);
            self
        }
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<crate::model::ReplicationGroup>,
        ) -> Self {
            self.replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`TestFailoverOutput`](crate::output::TestFailoverOutput)
        pub fn build(self) -> crate::output::TestFailoverOutput {
            crate::output::TestFailoverOutput {
                replication_group: self.replication_group,
            }
        }
    }
}
impl TestFailoverOutput {
    /// Creates a new builder-style object to manufacture [`TestFailoverOutput`](crate::output::TestFailoverOutput)
    pub fn builder() -> crate::output::test_failover_output::Builder {
        crate::output::test_failover_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMigrationOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub replication_group: std::option::Option<crate::model::ReplicationGroup>,
}
impl StartMigrationOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub fn replication_group(&self) -> std::option::Option<&crate::model::ReplicationGroup> {
        self.replication_group.as_ref()
    }
}
impl std::fmt::Debug for StartMigrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMigrationOutput");
        formatter.field("replication_group", &self.replication_group);
        formatter.finish()
    }
}
/// See [`StartMigrationOutput`](crate::output::StartMigrationOutput)
pub mod start_migration_output {
    /// A builder for [`StartMigrationOutput`](crate::output::StartMigrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group: std::option::Option<crate::model::ReplicationGroup>,
    }
    impl Builder {
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn replication_group(mut self, input: crate::model::ReplicationGroup) -> Self {
            self.replication_group = Some(input);
            self
        }
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<crate::model::ReplicationGroup>,
        ) -> Self {
            self.replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMigrationOutput`](crate::output::StartMigrationOutput)
        pub fn build(self) -> crate::output::StartMigrationOutput {
            crate::output::StartMigrationOutput {
                replication_group: self.replication_group,
            }
        }
    }
}
impl StartMigrationOutput {
    /// Creates a new builder-style object to manufacture [`StartMigrationOutput`](crate::output::StartMigrationOutput)
    pub fn builder() -> crate::output::start_migration_output::Builder {
        crate::output::start_migration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeCacheSecurityGroupIngressOutput {
    /// <p>Represents the output of one of the following operations:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AuthorizeCacheSecurityGroupIngress</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreateCacheSecurityGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RevokeCacheSecurityGroupIngress</code>
    /// </p>
    /// </li>
    /// </ul>
    pub cache_security_group: std::option::Option<crate::model::CacheSecurityGroup>,
}
impl RevokeCacheSecurityGroupIngressOutput {
    /// <p>Represents the output of one of the following operations:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AuthorizeCacheSecurityGroupIngress</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreateCacheSecurityGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RevokeCacheSecurityGroupIngress</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn cache_security_group(&self) -> std::option::Option<&crate::model::CacheSecurityGroup> {
        self.cache_security_group.as_ref()
    }
}
impl std::fmt::Debug for RevokeCacheSecurityGroupIngressOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeCacheSecurityGroupIngressOutput");
        formatter.field("cache_security_group", &self.cache_security_group);
        formatter.finish()
    }
}
/// See [`RevokeCacheSecurityGroupIngressOutput`](crate::output::RevokeCacheSecurityGroupIngressOutput)
pub mod revoke_cache_security_group_ingress_output {
    /// A builder for [`RevokeCacheSecurityGroupIngressOutput`](crate::output::RevokeCacheSecurityGroupIngressOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_security_group: std::option::Option<crate::model::CacheSecurityGroup>,
    }
    impl Builder {
        /// <p>Represents the output of one of the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AuthorizeCacheSecurityGroupIngress</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreateCacheSecurityGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RevokeCacheSecurityGroupIngress</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn cache_security_group(mut self, input: crate::model::CacheSecurityGroup) -> Self {
            self.cache_security_group = Some(input);
            self
        }
        /// <p>Represents the output of one of the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AuthorizeCacheSecurityGroupIngress</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreateCacheSecurityGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RevokeCacheSecurityGroupIngress</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_cache_security_group(
            mut self,
            input: std::option::Option<crate::model::CacheSecurityGroup>,
        ) -> Self {
            self.cache_security_group = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeCacheSecurityGroupIngressOutput`](crate::output::RevokeCacheSecurityGroupIngressOutput)
        pub fn build(self) -> crate::output::RevokeCacheSecurityGroupIngressOutput {
            crate::output::RevokeCacheSecurityGroupIngressOutput {
                cache_security_group: self.cache_security_group,
            }
        }
    }
}
impl RevokeCacheSecurityGroupIngressOutput {
    /// Creates a new builder-style object to manufacture [`RevokeCacheSecurityGroupIngressOutput`](crate::output::RevokeCacheSecurityGroupIngressOutput)
    pub fn builder() -> crate::output::revoke_cache_security_group_ingress_output::Builder {
        crate::output::revoke_cache_security_group_ingress_output::Builder::default()
    }
}

/// <p>Represents the output of one of the following operations:</p>
/// <ul>
/// <li>
/// <p>
/// <code>ModifyCacheParameterGroup</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>ResetCacheParameterGroup</code>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetCacheParameterGroupOutput {
    /// <p>The name of the cache parameter group.</p>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
}
impl ResetCacheParameterGroupOutput {
    /// <p>The name of the cache parameter group.</p>
    pub fn cache_parameter_group_name(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_name.as_deref()
    }
}
impl std::fmt::Debug for ResetCacheParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetCacheParameterGroupOutput");
        formatter.field(
            "cache_parameter_group_name",
            &self.cache_parameter_group_name,
        );
        formatter.finish()
    }
}
/// See [`ResetCacheParameterGroupOutput`](crate::output::ResetCacheParameterGroupOutput)
pub mod reset_cache_parameter_group_output {
    /// A builder for [`ResetCacheParameterGroupOutput`](crate::output::ResetCacheParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cache parameter group.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetCacheParameterGroupOutput`](crate::output::ResetCacheParameterGroupOutput)
        pub fn build(self) -> crate::output::ResetCacheParameterGroupOutput {
            crate::output::ResetCacheParameterGroupOutput {
                cache_parameter_group_name: self.cache_parameter_group_name,
            }
        }
    }
}
impl ResetCacheParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`ResetCacheParameterGroupOutput`](crate::output::ResetCacheParameterGroupOutput)
    pub fn builder() -> crate::output::reset_cache_parameter_group_output::Builder {
        crate::output::reset_cache_parameter_group_output::Builder::default()
    }
}

/// <p>Represents the output from the <code>AddTagsToResource</code>,
/// <code>ListTagsForResource</code>, and <code>RemoveTagsFromResource</code> operations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceOutput {
    /// <p>A list of tags as key-value pairs.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl RemoveTagsFromResourceOutput {
    /// <p>A list of tags as key-value pairs.</p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsFromResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceOutput");
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
pub mod remove_tags_from_resource_output {
    /// A builder for [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of tags as key-value pairs.</p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>A list of tags as key-value pairs.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
        pub fn build(self) -> crate::output::RemoveTagsFromResourceOutput {
            crate::output::RemoveTagsFromResourceOutput {
                tag_list: self.tag_list,
            }
        }
    }
}
impl RemoveTagsFromResourceOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    pub fn builder() -> crate::output::remove_tags_from_resource_output::Builder {
        crate::output::remove_tags_from_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootCacheClusterOutput {
    /// <p>Contains all of the attributes of a specific cluster.</p>
    pub cache_cluster: std::option::Option<crate::model::CacheCluster>,
}
impl RebootCacheClusterOutput {
    /// <p>Contains all of the attributes of a specific cluster.</p>
    pub fn cache_cluster(&self) -> std::option::Option<&crate::model::CacheCluster> {
        self.cache_cluster.as_ref()
    }
}
impl std::fmt::Debug for RebootCacheClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootCacheClusterOutput");
        formatter.field("cache_cluster", &self.cache_cluster);
        formatter.finish()
    }
}
/// See [`RebootCacheClusterOutput`](crate::output::RebootCacheClusterOutput)
pub mod reboot_cache_cluster_output {
    /// A builder for [`RebootCacheClusterOutput`](crate::output::RebootCacheClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster: std::option::Option<crate::model::CacheCluster>,
    }
    impl Builder {
        /// <p>Contains all of the attributes of a specific cluster.</p>
        pub fn cache_cluster(mut self, input: crate::model::CacheCluster) -> Self {
            self.cache_cluster = Some(input);
            self
        }
        /// <p>Contains all of the attributes of a specific cluster.</p>
        pub fn set_cache_cluster(
            mut self,
            input: std::option::Option<crate::model::CacheCluster>,
        ) -> Self {
            self.cache_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootCacheClusterOutput`](crate::output::RebootCacheClusterOutput)
        pub fn build(self) -> crate::output::RebootCacheClusterOutput {
            crate::output::RebootCacheClusterOutput {
                cache_cluster: self.cache_cluster,
            }
        }
    }
}
impl RebootCacheClusterOutput {
    /// Creates a new builder-style object to manufacture [`RebootCacheClusterOutput`](crate::output::RebootCacheClusterOutput)
    pub fn builder() -> crate::output::reboot_cache_cluster_output::Builder {
        crate::output::reboot_cache_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebalanceSlotsInGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub global_replication_group: std::option::Option<crate::model::GlobalReplicationGroup>,
}
impl RebalanceSlotsInGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub fn global_replication_group(
        &self,
    ) -> std::option::Option<&crate::model::GlobalReplicationGroup> {
        self.global_replication_group.as_ref()
    }
}
impl std::fmt::Debug for RebalanceSlotsInGlobalReplicationGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebalanceSlotsInGlobalReplicationGroupOutput");
        formatter.field("global_replication_group", &self.global_replication_group);
        formatter.finish()
    }
}
/// See [`RebalanceSlotsInGlobalReplicationGroupOutput`](crate::output::RebalanceSlotsInGlobalReplicationGroupOutput)
pub mod rebalance_slots_in_global_replication_group_output {
    /// A builder for [`RebalanceSlotsInGlobalReplicationGroupOutput`](crate::output::RebalanceSlotsInGlobalReplicationGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group:
            std::option::Option<crate::model::GlobalReplicationGroup>,
    }
    impl Builder {
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn global_replication_group(
            mut self,
            input: crate::model::GlobalReplicationGroup,
        ) -> Self {
            self.global_replication_group = Some(input);
            self
        }
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_global_replication_group(
            mut self,
            input: std::option::Option<crate::model::GlobalReplicationGroup>,
        ) -> Self {
            self.global_replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`RebalanceSlotsInGlobalReplicationGroupOutput`](crate::output::RebalanceSlotsInGlobalReplicationGroupOutput)
        pub fn build(self) -> crate::output::RebalanceSlotsInGlobalReplicationGroupOutput {
            crate::output::RebalanceSlotsInGlobalReplicationGroupOutput {
                global_replication_group: self.global_replication_group,
            }
        }
    }
}
impl RebalanceSlotsInGlobalReplicationGroupOutput {
    /// Creates a new builder-style object to manufacture [`RebalanceSlotsInGlobalReplicationGroupOutput`](crate::output::RebalanceSlotsInGlobalReplicationGroupOutput)
    pub fn builder() -> crate::output::rebalance_slots_in_global_replication_group_output::Builder {
        crate::output::rebalance_slots_in_global_replication_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseReservedCacheNodesOfferingOutput {
    /// <p>Represents the output of a <code>PurchaseReservedCacheNodesOffering</code> operation.</p>
    pub reserved_cache_node: std::option::Option<crate::model::ReservedCacheNode>,
}
impl PurchaseReservedCacheNodesOfferingOutput {
    /// <p>Represents the output of a <code>PurchaseReservedCacheNodesOffering</code> operation.</p>
    pub fn reserved_cache_node(&self) -> std::option::Option<&crate::model::ReservedCacheNode> {
        self.reserved_cache_node.as_ref()
    }
}
impl std::fmt::Debug for PurchaseReservedCacheNodesOfferingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseReservedCacheNodesOfferingOutput");
        formatter.field("reserved_cache_node", &self.reserved_cache_node);
        formatter.finish()
    }
}
/// See [`PurchaseReservedCacheNodesOfferingOutput`](crate::output::PurchaseReservedCacheNodesOfferingOutput)
pub mod purchase_reserved_cache_nodes_offering_output {
    /// A builder for [`PurchaseReservedCacheNodesOfferingOutput`](crate::output::PurchaseReservedCacheNodesOfferingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_cache_node: std::option::Option<crate::model::ReservedCacheNode>,
    }
    impl Builder {
        /// <p>Represents the output of a <code>PurchaseReservedCacheNodesOffering</code> operation.</p>
        pub fn reserved_cache_node(mut self, input: crate::model::ReservedCacheNode) -> Self {
            self.reserved_cache_node = Some(input);
            self
        }
        /// <p>Represents the output of a <code>PurchaseReservedCacheNodesOffering</code> operation.</p>
        pub fn set_reserved_cache_node(
            mut self,
            input: std::option::Option<crate::model::ReservedCacheNode>,
        ) -> Self {
            self.reserved_cache_node = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseReservedCacheNodesOfferingOutput`](crate::output::PurchaseReservedCacheNodesOfferingOutput)
        pub fn build(self) -> crate::output::PurchaseReservedCacheNodesOfferingOutput {
            crate::output::PurchaseReservedCacheNodesOfferingOutput {
                reserved_cache_node: self.reserved_cache_node,
            }
        }
    }
}
impl PurchaseReservedCacheNodesOfferingOutput {
    /// Creates a new builder-style object to manufacture [`PurchaseReservedCacheNodesOfferingOutput`](crate::output::PurchaseReservedCacheNodesOfferingOutput)
    pub fn builder() -> crate::output::purchase_reserved_cache_nodes_offering_output::Builder {
        crate::output::purchase_reserved_cache_nodes_offering_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyUserGroupOutput {
    /// <p>The ID of the user group.</p>
    pub user_group_id: std::option::Option<std::string::String>,
    /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The current supported value is Redis. </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The list of user IDs that belong to the user group.</p>
    pub user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>A list of updates being applied to the user group.</p>
    pub pending_changes: std::option::Option<crate::model::UserGroupPendingChanges>,
    /// <p>A list of replication groups that the user group can access.</p>
    pub replication_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the user group.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl ModifyUserGroupOutput {
    /// <p>The ID of the user group.</p>
    pub fn user_group_id(&self) -> std::option::Option<&str> {
        self.user_group_id.as_deref()
    }
    /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The current supported value is Redis. </p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The list of user IDs that belong to the user group.</p>
    pub fn user_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.user_ids.as_deref()
    }
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>A list of updates being applied to the user group.</p>
    pub fn pending_changes(&self) -> std::option::Option<&crate::model::UserGroupPendingChanges> {
        self.pending_changes.as_ref()
    }
    /// <p>A list of replication groups that the user group can access.</p>
    pub fn replication_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.replication_groups.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for ModifyUserGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyUserGroupOutput");
        formatter.field("user_group_id", &self.user_group_id);
        formatter.field("status", &self.status);
        formatter.field("engine", &self.engine);
        formatter.field("user_ids", &self.user_ids);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("pending_changes", &self.pending_changes);
        formatter.field("replication_groups", &self.replication_groups);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`ModifyUserGroupOutput`](crate::output::ModifyUserGroupOutput)
pub mod modify_user_group_output {
    /// A builder for [`ModifyUserGroupOutput`](crate::output::ModifyUserGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_group_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) pending_changes: std::option::Option<crate::model::UserGroupPendingChanges>,
        pub(crate) replication_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user group.</p>
        pub fn user_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the user group.</p>
        pub fn set_user_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_group_id = input;
            self
        }
        /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// Appends an item to `user_ids`.
        ///
        /// To override the contents of this collection use [`set_user_ids`](Self::set_user_ids).
        ///
        /// <p>The list of user IDs that belong to the user group.</p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_ids.unwrap_or_default();
            v.push(input.into());
            self.user_ids = Some(v);
            self
        }
        /// <p>The list of user IDs that belong to the user group.</p>
        pub fn set_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_ids = input;
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>A list of updates being applied to the user group.</p>
        pub fn pending_changes(mut self, input: crate::model::UserGroupPendingChanges) -> Self {
            self.pending_changes = Some(input);
            self
        }
        /// <p>A list of updates being applied to the user group.</p>
        pub fn set_pending_changes(
            mut self,
            input: std::option::Option<crate::model::UserGroupPendingChanges>,
        ) -> Self {
            self.pending_changes = input;
            self
        }
        /// Appends an item to `replication_groups`.
        ///
        /// To override the contents of this collection use [`set_replication_groups`](Self::set_replication_groups).
        ///
        /// <p>A list of replication groups that the user group can access.</p>
        pub fn replication_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.replication_groups.unwrap_or_default();
            v.push(input.into());
            self.replication_groups = Some(v);
            self
        }
        /// <p>A list of replication groups that the user group can access.</p>
        pub fn set_replication_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_groups = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyUserGroupOutput`](crate::output::ModifyUserGroupOutput)
        pub fn build(self) -> crate::output::ModifyUserGroupOutput {
            crate::output::ModifyUserGroupOutput {
                user_group_id: self.user_group_id,
                status: self.status,
                engine: self.engine,
                user_ids: self.user_ids,
                minimum_engine_version: self.minimum_engine_version,
                pending_changes: self.pending_changes,
                replication_groups: self.replication_groups,
                arn: self.arn,
            }
        }
    }
}
impl ModifyUserGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyUserGroupOutput`](crate::output::ModifyUserGroupOutput)
    pub fn builder() -> crate::output::modify_user_group_output::Builder {
        crate::output::modify_user_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyUserOutput {
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The username of the user.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The current supported value is Redis.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>Access permissions string used for this user.</p>
    pub access_string: std::option::Option<std::string::String>,
    /// <p>Returns a list of the user group IDs the user belongs to.</p>
    pub user_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Denotes whether the user requires a password to authenticate.</p>
    pub authentication: std::option::Option<crate::model::Authentication>,
    /// <p>The Amazon Resource Name (ARN) of the user.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl ModifyUserOutput {
    /// <p>The ID of the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The username of the user.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The current supported value is Redis.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>Access permissions string used for this user.</p>
    pub fn access_string(&self) -> std::option::Option<&str> {
        self.access_string.as_deref()
    }
    /// <p>Returns a list of the user group IDs the user belongs to.</p>
    pub fn user_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.user_group_ids.as_deref()
    }
    /// <p>Denotes whether the user requires a password to authenticate.</p>
    pub fn authentication(&self) -> std::option::Option<&crate::model::Authentication> {
        self.authentication.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for ModifyUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyUserOutput");
        formatter.field("user_id", &self.user_id);
        formatter.field("user_name", &self.user_name);
        formatter.field("status", &self.status);
        formatter.field("engine", &self.engine);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("access_string", &self.access_string);
        formatter.field("user_group_ids", &self.user_group_ids);
        formatter.field("authentication", &self.authentication);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`ModifyUserOutput`](crate::output::ModifyUserOutput)
pub mod modify_user_output {
    /// A builder for [`ModifyUserOutput`](crate::output::ModifyUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) access_string: std::option::Option<std::string::String>,
        pub(crate) user_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) authentication: std::option::Option<crate::model::Authentication>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The username of the user.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The username of the user.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The current supported value is Redis.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The current supported value is Redis.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_string = Some(input.into());
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_string = input;
            self
        }
        /// Appends an item to `user_group_ids`.
        ///
        /// To override the contents of this collection use [`set_user_group_ids`](Self::set_user_group_ids).
        ///
        /// <p>Returns a list of the user group IDs the user belongs to.</p>
        pub fn user_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_group_ids.unwrap_or_default();
            v.push(input.into());
            self.user_group_ids = Some(v);
            self
        }
        /// <p>Returns a list of the user group IDs the user belongs to.</p>
        pub fn set_user_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_group_ids = input;
            self
        }
        /// <p>Denotes whether the user requires a password to authenticate.</p>
        pub fn authentication(mut self, input: crate::model::Authentication) -> Self {
            self.authentication = Some(input);
            self
        }
        /// <p>Denotes whether the user requires a password to authenticate.</p>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<crate::model::Authentication>,
        ) -> Self {
            self.authentication = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyUserOutput`](crate::output::ModifyUserOutput)
        pub fn build(self) -> crate::output::ModifyUserOutput {
            crate::output::ModifyUserOutput {
                user_id: self.user_id,
                user_name: self.user_name,
                status: self.status,
                engine: self.engine,
                minimum_engine_version: self.minimum_engine_version,
                access_string: self.access_string,
                user_group_ids: self.user_group_ids,
                authentication: self.authentication,
                arn: self.arn,
            }
        }
    }
}
impl ModifyUserOutput {
    /// Creates a new builder-style object to manufacture [`ModifyUserOutput`](crate::output::ModifyUserOutput)
    pub fn builder() -> crate::output::modify_user_output::Builder {
        crate::output::modify_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyReplicationGroupShardConfigurationOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub replication_group: std::option::Option<crate::model::ReplicationGroup>,
}
impl ModifyReplicationGroupShardConfigurationOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub fn replication_group(&self) -> std::option::Option<&crate::model::ReplicationGroup> {
        self.replication_group.as_ref()
    }
}
impl std::fmt::Debug for ModifyReplicationGroupShardConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyReplicationGroupShardConfigurationOutput");
        formatter.field("replication_group", &self.replication_group);
        formatter.finish()
    }
}
/// See [`ModifyReplicationGroupShardConfigurationOutput`](crate::output::ModifyReplicationGroupShardConfigurationOutput)
pub mod modify_replication_group_shard_configuration_output {
    /// A builder for [`ModifyReplicationGroupShardConfigurationOutput`](crate::output::ModifyReplicationGroupShardConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group: std::option::Option<crate::model::ReplicationGroup>,
    }
    impl Builder {
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn replication_group(mut self, input: crate::model::ReplicationGroup) -> Self {
            self.replication_group = Some(input);
            self
        }
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<crate::model::ReplicationGroup>,
        ) -> Self {
            self.replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyReplicationGroupShardConfigurationOutput`](crate::output::ModifyReplicationGroupShardConfigurationOutput)
        pub fn build(self) -> crate::output::ModifyReplicationGroupShardConfigurationOutput {
            crate::output::ModifyReplicationGroupShardConfigurationOutput {
                replication_group: self.replication_group,
            }
        }
    }
}
impl ModifyReplicationGroupShardConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`ModifyReplicationGroupShardConfigurationOutput`](crate::output::ModifyReplicationGroupShardConfigurationOutput)
    pub fn builder() -> crate::output::modify_replication_group_shard_configuration_output::Builder
    {
        crate::output::modify_replication_group_shard_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyReplicationGroupOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub replication_group: std::option::Option<crate::model::ReplicationGroup>,
}
impl ModifyReplicationGroupOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub fn replication_group(&self) -> std::option::Option<&crate::model::ReplicationGroup> {
        self.replication_group.as_ref()
    }
}
impl std::fmt::Debug for ModifyReplicationGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyReplicationGroupOutput");
        formatter.field("replication_group", &self.replication_group);
        formatter.finish()
    }
}
/// See [`ModifyReplicationGroupOutput`](crate::output::ModifyReplicationGroupOutput)
pub mod modify_replication_group_output {
    /// A builder for [`ModifyReplicationGroupOutput`](crate::output::ModifyReplicationGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group: std::option::Option<crate::model::ReplicationGroup>,
    }
    impl Builder {
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn replication_group(mut self, input: crate::model::ReplicationGroup) -> Self {
            self.replication_group = Some(input);
            self
        }
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<crate::model::ReplicationGroup>,
        ) -> Self {
            self.replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyReplicationGroupOutput`](crate::output::ModifyReplicationGroupOutput)
        pub fn build(self) -> crate::output::ModifyReplicationGroupOutput {
            crate::output::ModifyReplicationGroupOutput {
                replication_group: self.replication_group,
            }
        }
    }
}
impl ModifyReplicationGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyReplicationGroupOutput`](crate::output::ModifyReplicationGroupOutput)
    pub fn builder() -> crate::output::modify_replication_group_output::Builder {
        crate::output::modify_replication_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub global_replication_group: std::option::Option<crate::model::GlobalReplicationGroup>,
}
impl ModifyGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub fn global_replication_group(
        &self,
    ) -> std::option::Option<&crate::model::GlobalReplicationGroup> {
        self.global_replication_group.as_ref()
    }
}
impl std::fmt::Debug for ModifyGlobalReplicationGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyGlobalReplicationGroupOutput");
        formatter.field("global_replication_group", &self.global_replication_group);
        formatter.finish()
    }
}
/// See [`ModifyGlobalReplicationGroupOutput`](crate::output::ModifyGlobalReplicationGroupOutput)
pub mod modify_global_replication_group_output {
    /// A builder for [`ModifyGlobalReplicationGroupOutput`](crate::output::ModifyGlobalReplicationGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group:
            std::option::Option<crate::model::GlobalReplicationGroup>,
    }
    impl Builder {
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn global_replication_group(
            mut self,
            input: crate::model::GlobalReplicationGroup,
        ) -> Self {
            self.global_replication_group = Some(input);
            self
        }
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_global_replication_group(
            mut self,
            input: std::option::Option<crate::model::GlobalReplicationGroup>,
        ) -> Self {
            self.global_replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyGlobalReplicationGroupOutput`](crate::output::ModifyGlobalReplicationGroupOutput)
        pub fn build(self) -> crate::output::ModifyGlobalReplicationGroupOutput {
            crate::output::ModifyGlobalReplicationGroupOutput {
                global_replication_group: self.global_replication_group,
            }
        }
    }
}
impl ModifyGlobalReplicationGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyGlobalReplicationGroupOutput`](crate::output::ModifyGlobalReplicationGroupOutput)
    pub fn builder() -> crate::output::modify_global_replication_group_output::Builder {
        crate::output::modify_global_replication_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyCacheSubnetGroupOutput {
    /// <p>Represents the output of one of the following operations:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreateCacheSubnetGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ModifyCacheSubnetGroup</code>
    /// </p>
    /// </li>
    /// </ul>
    pub cache_subnet_group: std::option::Option<crate::model::CacheSubnetGroup>,
}
impl ModifyCacheSubnetGroupOutput {
    /// <p>Represents the output of one of the following operations:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreateCacheSubnetGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ModifyCacheSubnetGroup</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn cache_subnet_group(&self) -> std::option::Option<&crate::model::CacheSubnetGroup> {
        self.cache_subnet_group.as_ref()
    }
}
impl std::fmt::Debug for ModifyCacheSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyCacheSubnetGroupOutput");
        formatter.field("cache_subnet_group", &self.cache_subnet_group);
        formatter.finish()
    }
}
/// See [`ModifyCacheSubnetGroupOutput`](crate::output::ModifyCacheSubnetGroupOutput)
pub mod modify_cache_subnet_group_output {
    /// A builder for [`ModifyCacheSubnetGroupOutput`](crate::output::ModifyCacheSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_subnet_group: std::option::Option<crate::model::CacheSubnetGroup>,
    }
    impl Builder {
        /// <p>Represents the output of one of the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreateCacheSubnetGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ModifyCacheSubnetGroup</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn cache_subnet_group(mut self, input: crate::model::CacheSubnetGroup) -> Self {
            self.cache_subnet_group = Some(input);
            self
        }
        /// <p>Represents the output of one of the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreateCacheSubnetGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ModifyCacheSubnetGroup</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_cache_subnet_group(
            mut self,
            input: std::option::Option<crate::model::CacheSubnetGroup>,
        ) -> Self {
            self.cache_subnet_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyCacheSubnetGroupOutput`](crate::output::ModifyCacheSubnetGroupOutput)
        pub fn build(self) -> crate::output::ModifyCacheSubnetGroupOutput {
            crate::output::ModifyCacheSubnetGroupOutput {
                cache_subnet_group: self.cache_subnet_group,
            }
        }
    }
}
impl ModifyCacheSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyCacheSubnetGroupOutput`](crate::output::ModifyCacheSubnetGroupOutput)
    pub fn builder() -> crate::output::modify_cache_subnet_group_output::Builder {
        crate::output::modify_cache_subnet_group_output::Builder::default()
    }
}

/// <p>Represents the output of one of the following operations:</p>
/// <ul>
/// <li>
/// <p>
/// <code>ModifyCacheParameterGroup</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>ResetCacheParameterGroup</code>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyCacheParameterGroupOutput {
    /// <p>The name of the cache parameter group.</p>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
}
impl ModifyCacheParameterGroupOutput {
    /// <p>The name of the cache parameter group.</p>
    pub fn cache_parameter_group_name(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_name.as_deref()
    }
}
impl std::fmt::Debug for ModifyCacheParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyCacheParameterGroupOutput");
        formatter.field(
            "cache_parameter_group_name",
            &self.cache_parameter_group_name,
        );
        formatter.finish()
    }
}
/// See [`ModifyCacheParameterGroupOutput`](crate::output::ModifyCacheParameterGroupOutput)
pub mod modify_cache_parameter_group_output {
    /// A builder for [`ModifyCacheParameterGroupOutput`](crate::output::ModifyCacheParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cache parameter group.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyCacheParameterGroupOutput`](crate::output::ModifyCacheParameterGroupOutput)
        pub fn build(self) -> crate::output::ModifyCacheParameterGroupOutput {
            crate::output::ModifyCacheParameterGroupOutput {
                cache_parameter_group_name: self.cache_parameter_group_name,
            }
        }
    }
}
impl ModifyCacheParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyCacheParameterGroupOutput`](crate::output::ModifyCacheParameterGroupOutput)
    pub fn builder() -> crate::output::modify_cache_parameter_group_output::Builder {
        crate::output::modify_cache_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyCacheClusterOutput {
    /// <p>Contains all of the attributes of a specific cluster.</p>
    pub cache_cluster: std::option::Option<crate::model::CacheCluster>,
}
impl ModifyCacheClusterOutput {
    /// <p>Contains all of the attributes of a specific cluster.</p>
    pub fn cache_cluster(&self) -> std::option::Option<&crate::model::CacheCluster> {
        self.cache_cluster.as_ref()
    }
}
impl std::fmt::Debug for ModifyCacheClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyCacheClusterOutput");
        formatter.field("cache_cluster", &self.cache_cluster);
        formatter.finish()
    }
}
/// See [`ModifyCacheClusterOutput`](crate::output::ModifyCacheClusterOutput)
pub mod modify_cache_cluster_output {
    /// A builder for [`ModifyCacheClusterOutput`](crate::output::ModifyCacheClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster: std::option::Option<crate::model::CacheCluster>,
    }
    impl Builder {
        /// <p>Contains all of the attributes of a specific cluster.</p>
        pub fn cache_cluster(mut self, input: crate::model::CacheCluster) -> Self {
            self.cache_cluster = Some(input);
            self
        }
        /// <p>Contains all of the attributes of a specific cluster.</p>
        pub fn set_cache_cluster(
            mut self,
            input: std::option::Option<crate::model::CacheCluster>,
        ) -> Self {
            self.cache_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyCacheClusterOutput`](crate::output::ModifyCacheClusterOutput)
        pub fn build(self) -> crate::output::ModifyCacheClusterOutput {
            crate::output::ModifyCacheClusterOutput {
                cache_cluster: self.cache_cluster,
            }
        }
    }
}
impl ModifyCacheClusterOutput {
    /// Creates a new builder-style object to manufacture [`ModifyCacheClusterOutput`](crate::output::ModifyCacheClusterOutput)
    pub fn builder() -> crate::output::modify_cache_cluster_output::Builder {
        crate::output::modify_cache_cluster_output::Builder::default()
    }
}

/// <p>Represents the output from the <code>AddTagsToResource</code>,
/// <code>ListTagsForResource</code>, and <code>RemoveTagsFromResource</code> operations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A list of tags as key-value pairs.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>A list of tags as key-value pairs.</p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of tags as key-value pairs.</p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>A list of tags as key-value pairs.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tag_list: self.tag_list,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p>Represents the allowed node types you can use to modify your cluster or replication group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAllowedNodeTypeModificationsOutput {
    /// <p>A string list, each element of which specifies a cache node type which you can use
    /// to scale your cluster or replication group.</p>
    /// <p>When scaling up a Redis cluster or replication group using <code>ModifyCacheCluster</code> or
    /// <code>ModifyReplicationGroup</code>,
    /// use a value from this list for the <code>CacheNodeType</code> parameter.</p>
    pub scale_up_modifications: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A string list, each element of which specifies a cache node type which you can use to scale your cluster or replication group.
    ///
    /// When scaling down a Redis cluster or replication group using ModifyCacheCluster or ModifyReplicationGroup, use a value from this list for the CacheNodeType parameter. </p>
    pub scale_down_modifications: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListAllowedNodeTypeModificationsOutput {
    /// <p>A string list, each element of which specifies a cache node type which you can use
    /// to scale your cluster or replication group.</p>
    /// <p>When scaling up a Redis cluster or replication group using <code>ModifyCacheCluster</code> or
    /// <code>ModifyReplicationGroup</code>,
    /// use a value from this list for the <code>CacheNodeType</code> parameter.</p>
    pub fn scale_up_modifications(&self) -> std::option::Option<&[std::string::String]> {
        self.scale_up_modifications.as_deref()
    }
    /// <p>A string list, each element of which specifies a cache node type which you can use to scale your cluster or replication group.
    ///
    /// When scaling down a Redis cluster or replication group using ModifyCacheCluster or ModifyReplicationGroup, use a value from this list for the CacheNodeType parameter. </p>
    pub fn scale_down_modifications(&self) -> std::option::Option<&[std::string::String]> {
        self.scale_down_modifications.as_deref()
    }
}
impl std::fmt::Debug for ListAllowedNodeTypeModificationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAllowedNodeTypeModificationsOutput");
        formatter.field("scale_up_modifications", &self.scale_up_modifications);
        formatter.field("scale_down_modifications", &self.scale_down_modifications);
        formatter.finish()
    }
}
/// See [`ListAllowedNodeTypeModificationsOutput`](crate::output::ListAllowedNodeTypeModificationsOutput)
pub mod list_allowed_node_type_modifications_output {
    /// A builder for [`ListAllowedNodeTypeModificationsOutput`](crate::output::ListAllowedNodeTypeModificationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scale_up_modifications: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) scale_down_modifications:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `scale_up_modifications`.
        ///
        /// To override the contents of this collection use [`set_scale_up_modifications`](Self::set_scale_up_modifications).
        ///
        /// <p>A string list, each element of which specifies a cache node type which you can use
        /// to scale your cluster or replication group.</p>
        /// <p>When scaling up a Redis cluster or replication group using <code>ModifyCacheCluster</code> or
        /// <code>ModifyReplicationGroup</code>,
        /// use a value from this list for the <code>CacheNodeType</code> parameter.</p>
        pub fn scale_up_modifications(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.scale_up_modifications.unwrap_or_default();
            v.push(input.into());
            self.scale_up_modifications = Some(v);
            self
        }
        /// <p>A string list, each element of which specifies a cache node type which you can use
        /// to scale your cluster or replication group.</p>
        /// <p>When scaling up a Redis cluster or replication group using <code>ModifyCacheCluster</code> or
        /// <code>ModifyReplicationGroup</code>,
        /// use a value from this list for the <code>CacheNodeType</code> parameter.</p>
        pub fn set_scale_up_modifications(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.scale_up_modifications = input;
            self
        }
        /// Appends an item to `scale_down_modifications`.
        ///
        /// To override the contents of this collection use [`set_scale_down_modifications`](Self::set_scale_down_modifications).
        ///
        /// <p>A string list, each element of which specifies a cache node type which you can use to scale your cluster or replication group.
        ///
        /// When scaling down a Redis cluster or replication group using ModifyCacheCluster or ModifyReplicationGroup, use a value from this list for the CacheNodeType parameter. </p>
        pub fn scale_down_modifications(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.scale_down_modifications.unwrap_or_default();
            v.push(input.into());
            self.scale_down_modifications = Some(v);
            self
        }
        /// <p>A string list, each element of which specifies a cache node type which you can use to scale your cluster or replication group.
        ///
        /// When scaling down a Redis cluster or replication group using ModifyCacheCluster or ModifyReplicationGroup, use a value from this list for the CacheNodeType parameter. </p>
        pub fn set_scale_down_modifications(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.scale_down_modifications = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAllowedNodeTypeModificationsOutput`](crate::output::ListAllowedNodeTypeModificationsOutput)
        pub fn build(self) -> crate::output::ListAllowedNodeTypeModificationsOutput {
            crate::output::ListAllowedNodeTypeModificationsOutput {
                scale_up_modifications: self.scale_up_modifications,
                scale_down_modifications: self.scale_down_modifications,
            }
        }
    }
}
impl ListAllowedNodeTypeModificationsOutput {
    /// Creates a new builder-style object to manufacture [`ListAllowedNodeTypeModificationsOutput`](crate::output::ListAllowedNodeTypeModificationsOutput)
    pub fn builder() -> crate::output::list_allowed_node_type_modifications_output::Builder {
        crate::output::list_allowed_node_type_modifications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncreaseReplicaCountOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub replication_group: std::option::Option<crate::model::ReplicationGroup>,
}
impl IncreaseReplicaCountOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub fn replication_group(&self) -> std::option::Option<&crate::model::ReplicationGroup> {
        self.replication_group.as_ref()
    }
}
impl std::fmt::Debug for IncreaseReplicaCountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncreaseReplicaCountOutput");
        formatter.field("replication_group", &self.replication_group);
        formatter.finish()
    }
}
/// See [`IncreaseReplicaCountOutput`](crate::output::IncreaseReplicaCountOutput)
pub mod increase_replica_count_output {
    /// A builder for [`IncreaseReplicaCountOutput`](crate::output::IncreaseReplicaCountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group: std::option::Option<crate::model::ReplicationGroup>,
    }
    impl Builder {
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn replication_group(mut self, input: crate::model::ReplicationGroup) -> Self {
            self.replication_group = Some(input);
            self
        }
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<crate::model::ReplicationGroup>,
        ) -> Self {
            self.replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`IncreaseReplicaCountOutput`](crate::output::IncreaseReplicaCountOutput)
        pub fn build(self) -> crate::output::IncreaseReplicaCountOutput {
            crate::output::IncreaseReplicaCountOutput {
                replication_group: self.replication_group,
            }
        }
    }
}
impl IncreaseReplicaCountOutput {
    /// Creates a new builder-style object to manufacture [`IncreaseReplicaCountOutput`](crate::output::IncreaseReplicaCountOutput)
    pub fn builder() -> crate::output::increase_replica_count_output::Builder {
        crate::output::increase_replica_count_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncreaseNodeGroupsInGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub global_replication_group: std::option::Option<crate::model::GlobalReplicationGroup>,
}
impl IncreaseNodeGroupsInGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub fn global_replication_group(
        &self,
    ) -> std::option::Option<&crate::model::GlobalReplicationGroup> {
        self.global_replication_group.as_ref()
    }
}
impl std::fmt::Debug for IncreaseNodeGroupsInGlobalReplicationGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncreaseNodeGroupsInGlobalReplicationGroupOutput");
        formatter.field("global_replication_group", &self.global_replication_group);
        formatter.finish()
    }
}
/// See [`IncreaseNodeGroupsInGlobalReplicationGroupOutput`](crate::output::IncreaseNodeGroupsInGlobalReplicationGroupOutput)
pub mod increase_node_groups_in_global_replication_group_output {
    /// A builder for [`IncreaseNodeGroupsInGlobalReplicationGroupOutput`](crate::output::IncreaseNodeGroupsInGlobalReplicationGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group:
            std::option::Option<crate::model::GlobalReplicationGroup>,
    }
    impl Builder {
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn global_replication_group(
            mut self,
            input: crate::model::GlobalReplicationGroup,
        ) -> Self {
            self.global_replication_group = Some(input);
            self
        }
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_global_replication_group(
            mut self,
            input: std::option::Option<crate::model::GlobalReplicationGroup>,
        ) -> Self {
            self.global_replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`IncreaseNodeGroupsInGlobalReplicationGroupOutput`](crate::output::IncreaseNodeGroupsInGlobalReplicationGroupOutput)
        pub fn build(self) -> crate::output::IncreaseNodeGroupsInGlobalReplicationGroupOutput {
            crate::output::IncreaseNodeGroupsInGlobalReplicationGroupOutput {
                global_replication_group: self.global_replication_group,
            }
        }
    }
}
impl IncreaseNodeGroupsInGlobalReplicationGroupOutput {
    /// Creates a new builder-style object to manufacture [`IncreaseNodeGroupsInGlobalReplicationGroupOutput`](crate::output::IncreaseNodeGroupsInGlobalReplicationGroupOutput)
    pub fn builder(
    ) -> crate::output::increase_node_groups_in_global_replication_group_output::Builder {
        crate::output::increase_node_groups_in_global_replication_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailoverGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub global_replication_group: std::option::Option<crate::model::GlobalReplicationGroup>,
}
impl FailoverGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub fn global_replication_group(
        &self,
    ) -> std::option::Option<&crate::model::GlobalReplicationGroup> {
        self.global_replication_group.as_ref()
    }
}
impl std::fmt::Debug for FailoverGlobalReplicationGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailoverGlobalReplicationGroupOutput");
        formatter.field("global_replication_group", &self.global_replication_group);
        formatter.finish()
    }
}
/// See [`FailoverGlobalReplicationGroupOutput`](crate::output::FailoverGlobalReplicationGroupOutput)
pub mod failover_global_replication_group_output {
    /// A builder for [`FailoverGlobalReplicationGroupOutput`](crate::output::FailoverGlobalReplicationGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group:
            std::option::Option<crate::model::GlobalReplicationGroup>,
    }
    impl Builder {
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn global_replication_group(
            mut self,
            input: crate::model::GlobalReplicationGroup,
        ) -> Self {
            self.global_replication_group = Some(input);
            self
        }
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_global_replication_group(
            mut self,
            input: std::option::Option<crate::model::GlobalReplicationGroup>,
        ) -> Self {
            self.global_replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`FailoverGlobalReplicationGroupOutput`](crate::output::FailoverGlobalReplicationGroupOutput)
        pub fn build(self) -> crate::output::FailoverGlobalReplicationGroupOutput {
            crate::output::FailoverGlobalReplicationGroupOutput {
                global_replication_group: self.global_replication_group,
            }
        }
    }
}
impl FailoverGlobalReplicationGroupOutput {
    /// Creates a new builder-style object to manufacture [`FailoverGlobalReplicationGroupOutput`](crate::output::FailoverGlobalReplicationGroupOutput)
    pub fn builder() -> crate::output::failover_global_replication_group_output::Builder {
        crate::output::failover_global_replication_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub global_replication_group: std::option::Option<crate::model::GlobalReplicationGroup>,
}
impl DisassociateGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub fn global_replication_group(
        &self,
    ) -> std::option::Option<&crate::model::GlobalReplicationGroup> {
        self.global_replication_group.as_ref()
    }
}
impl std::fmt::Debug for DisassociateGlobalReplicationGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateGlobalReplicationGroupOutput");
        formatter.field("global_replication_group", &self.global_replication_group);
        formatter.finish()
    }
}
/// See [`DisassociateGlobalReplicationGroupOutput`](crate::output::DisassociateGlobalReplicationGroupOutput)
pub mod disassociate_global_replication_group_output {
    /// A builder for [`DisassociateGlobalReplicationGroupOutput`](crate::output::DisassociateGlobalReplicationGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group:
            std::option::Option<crate::model::GlobalReplicationGroup>,
    }
    impl Builder {
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn global_replication_group(
            mut self,
            input: crate::model::GlobalReplicationGroup,
        ) -> Self {
            self.global_replication_group = Some(input);
            self
        }
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_global_replication_group(
            mut self,
            input: std::option::Option<crate::model::GlobalReplicationGroup>,
        ) -> Self {
            self.global_replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateGlobalReplicationGroupOutput`](crate::output::DisassociateGlobalReplicationGroupOutput)
        pub fn build(self) -> crate::output::DisassociateGlobalReplicationGroupOutput {
            crate::output::DisassociateGlobalReplicationGroupOutput {
                global_replication_group: self.global_replication_group,
            }
        }
    }
}
impl DisassociateGlobalReplicationGroupOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateGlobalReplicationGroupOutput`](crate::output::DisassociateGlobalReplicationGroupOutput)
    pub fn builder() -> crate::output::disassociate_global_replication_group_output::Builder {
        crate::output::disassociate_global_replication_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUsersOutput {
    /// <p>A list of users.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::User>>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. ></p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeUsersOutput {
    /// <p>A list of users.</p>
    pub fn users(&self) -> std::option::Option<&[crate::model::User]> {
        self.users.as_deref()
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. ></p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeUsersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUsersOutput");
        formatter.field("users", &self.users);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeUsersOutput`](crate::output::DescribeUsersOutput)
pub mod describe_users_output {
    /// A builder for [`DescribeUsersOutput`](crate::output::DescribeUsersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::User>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>A list of users.</p>
        pub fn users(mut self, input: impl Into<crate::model::User>) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input.into());
            self.users = Some(v);
            self
        }
        /// <p>A list of users.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::User>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. ></p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. ></p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUsersOutput`](crate::output::DescribeUsersOutput)
        pub fn build(self) -> crate::output::DescribeUsersOutput {
            crate::output::DescribeUsersOutput {
                users: self.users,
                marker: self.marker,
            }
        }
    }
}
impl DescribeUsersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUsersOutput`](crate::output::DescribeUsersOutput)
    pub fn builder() -> crate::output::describe_users_output::Builder {
        crate::output::describe_users_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserGroupsOutput {
    /// <p>Returns a list of user groups.</p>
    pub user_groups: std::option::Option<std::vec::Vec<crate::model::UserGroup>>,
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. ></p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeUserGroupsOutput {
    /// <p>Returns a list of user groups.</p>
    pub fn user_groups(&self) -> std::option::Option<&[crate::model::UserGroup]> {
        self.user_groups.as_deref()
    }
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. ></p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeUserGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserGroupsOutput");
        formatter.field("user_groups", &self.user_groups);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeUserGroupsOutput`](crate::output::DescribeUserGroupsOutput)
pub mod describe_user_groups_output {
    /// A builder for [`DescribeUserGroupsOutput`](crate::output::DescribeUserGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_groups: std::option::Option<std::vec::Vec<crate::model::UserGroup>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `user_groups`.
        ///
        /// To override the contents of this collection use [`set_user_groups`](Self::set_user_groups).
        ///
        /// <p>Returns a list of user groups.</p>
        pub fn user_groups(mut self, input: impl Into<crate::model::UserGroup>) -> Self {
            let mut v = self.user_groups.unwrap_or_default();
            v.push(input.into());
            self.user_groups = Some(v);
            self
        }
        /// <p>Returns a list of user groups.</p>
        pub fn set_user_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserGroup>>,
        ) -> Self {
            self.user_groups = input;
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. ></p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. ></p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserGroupsOutput`](crate::output::DescribeUserGroupsOutput)
        pub fn build(self) -> crate::output::DescribeUserGroupsOutput {
            crate::output::DescribeUserGroupsOutput {
                user_groups: self.user_groups,
                marker: self.marker,
            }
        }
    }
}
impl DescribeUserGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUserGroupsOutput`](crate::output::DescribeUserGroupsOutput)
    pub fn builder() -> crate::output::describe_user_groups_output::Builder {
        crate::output::describe_user_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUpdateActionsOutput {
    /// <p>An optional marker returned from a prior request.
    /// Use this marker for pagination of results from this operation. If this
    /// parameter is specified, the response includes only records beyond the marker, up to the
    /// value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Returns a list of update actions</p>
    pub update_actions: std::option::Option<std::vec::Vec<crate::model::UpdateAction>>,
}
impl DescribeUpdateActionsOutput {
    /// <p>An optional marker returned from a prior request.
    /// Use this marker for pagination of results from this operation. If this
    /// parameter is specified, the response includes only records beyond the marker, up to the
    /// value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Returns a list of update actions</p>
    pub fn update_actions(&self) -> std::option::Option<&[crate::model::UpdateAction]> {
        self.update_actions.as_deref()
    }
}
impl std::fmt::Debug for DescribeUpdateActionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUpdateActionsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("update_actions", &self.update_actions);
        formatter.finish()
    }
}
/// See [`DescribeUpdateActionsOutput`](crate::output::DescribeUpdateActionsOutput)
pub mod describe_update_actions_output {
    /// A builder for [`DescribeUpdateActionsOutput`](crate::output::DescribeUpdateActionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) update_actions: std::option::Option<std::vec::Vec<crate::model::UpdateAction>>,
    }
    impl Builder {
        /// <p>An optional marker returned from a prior request.
        /// Use this marker for pagination of results from this operation. If this
        /// parameter is specified, the response includes only records beyond the marker, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request.
        /// Use this marker for pagination of results from this operation. If this
        /// parameter is specified, the response includes only records beyond the marker, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `update_actions`.
        ///
        /// To override the contents of this collection use [`set_update_actions`](Self::set_update_actions).
        ///
        /// <p>Returns a list of update actions</p>
        pub fn update_actions(mut self, input: impl Into<crate::model::UpdateAction>) -> Self {
            let mut v = self.update_actions.unwrap_or_default();
            v.push(input.into());
            self.update_actions = Some(v);
            self
        }
        /// <p>Returns a list of update actions</p>
        pub fn set_update_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateAction>>,
        ) -> Self {
            self.update_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUpdateActionsOutput`](crate::output::DescribeUpdateActionsOutput)
        pub fn build(self) -> crate::output::DescribeUpdateActionsOutput {
            crate::output::DescribeUpdateActionsOutput {
                marker: self.marker,
                update_actions: self.update_actions,
            }
        }
    }
}
impl DescribeUpdateActionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUpdateActionsOutput`](crate::output::DescribeUpdateActionsOutput)
    pub fn builder() -> crate::output::describe_update_actions_output::Builder {
        crate::output::describe_update_actions_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeSnapshots</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSnapshotsOutput {
    /// <p>An optional marker returned from a prior request.
    /// Use this marker for pagination of results from this operation.
    /// If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of snapshots. Each item in the list contains detailed information about one snapshot.</p>
    pub snapshots: std::option::Option<std::vec::Vec<crate::model::Snapshot>>,
}
impl DescribeSnapshotsOutput {
    /// <p>An optional marker returned from a prior request.
    /// Use this marker for pagination of results from this operation.
    /// If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of snapshots. Each item in the list contains detailed information about one snapshot.</p>
    pub fn snapshots(&self) -> std::option::Option<&[crate::model::Snapshot]> {
        self.snapshots.as_deref()
    }
}
impl std::fmt::Debug for DescribeSnapshotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSnapshotsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("snapshots", &self.snapshots);
        formatter.finish()
    }
}
/// See [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput)
pub mod describe_snapshots_output {
    /// A builder for [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) snapshots: std::option::Option<std::vec::Vec<crate::model::Snapshot>>,
    }
    impl Builder {
        /// <p>An optional marker returned from a prior request.
        /// Use this marker for pagination of results from this operation.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request.
        /// Use this marker for pagination of results from this operation.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `snapshots`.
        ///
        /// To override the contents of this collection use [`set_snapshots`](Self::set_snapshots).
        ///
        /// <p>A list of snapshots. Each item in the list contains detailed information about one snapshot.</p>
        pub fn snapshots(mut self, input: impl Into<crate::model::Snapshot>) -> Self {
            let mut v = self.snapshots.unwrap_or_default();
            v.push(input.into());
            self.snapshots = Some(v);
            self
        }
        /// <p>A list of snapshots. Each item in the list contains detailed information about one snapshot.</p>
        pub fn set_snapshots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Snapshot>>,
        ) -> Self {
            self.snapshots = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput)
        pub fn build(self) -> crate::output::DescribeSnapshotsOutput {
            crate::output::DescribeSnapshotsOutput {
                marker: self.marker,
                snapshots: self.snapshots,
            }
        }
    }
}
impl DescribeSnapshotsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput)
    pub fn builder() -> crate::output::describe_snapshots_output::Builder {
        crate::output::describe_snapshots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServiceUpdatesOutput {
    /// <p>An optional marker returned from a prior request.
    /// Use this marker for pagination of results from this operation. If this
    /// parameter is specified, the response includes only records beyond the marker, up to the
    /// value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of service updates</p>
    pub service_updates: std::option::Option<std::vec::Vec<crate::model::ServiceUpdate>>,
}
impl DescribeServiceUpdatesOutput {
    /// <p>An optional marker returned from a prior request.
    /// Use this marker for pagination of results from this operation. If this
    /// parameter is specified, the response includes only records beyond the marker, up to the
    /// value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of service updates</p>
    pub fn service_updates(&self) -> std::option::Option<&[crate::model::ServiceUpdate]> {
        self.service_updates.as_deref()
    }
}
impl std::fmt::Debug for DescribeServiceUpdatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServiceUpdatesOutput");
        formatter.field("marker", &self.marker);
        formatter.field("service_updates", &self.service_updates);
        formatter.finish()
    }
}
/// See [`DescribeServiceUpdatesOutput`](crate::output::DescribeServiceUpdatesOutput)
pub mod describe_service_updates_output {
    /// A builder for [`DescribeServiceUpdatesOutput`](crate::output::DescribeServiceUpdatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) service_updates: std::option::Option<std::vec::Vec<crate::model::ServiceUpdate>>,
    }
    impl Builder {
        /// <p>An optional marker returned from a prior request.
        /// Use this marker for pagination of results from this operation. If this
        /// parameter is specified, the response includes only records beyond the marker, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request.
        /// Use this marker for pagination of results from this operation. If this
        /// parameter is specified, the response includes only records beyond the marker, up to the
        /// value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `service_updates`.
        ///
        /// To override the contents of this collection use [`set_service_updates`](Self::set_service_updates).
        ///
        /// <p>A list of service updates</p>
        pub fn service_updates(mut self, input: impl Into<crate::model::ServiceUpdate>) -> Self {
            let mut v = self.service_updates.unwrap_or_default();
            v.push(input.into());
            self.service_updates = Some(v);
            self
        }
        /// <p>A list of service updates</p>
        pub fn set_service_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceUpdate>>,
        ) -> Self {
            self.service_updates = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServiceUpdatesOutput`](crate::output::DescribeServiceUpdatesOutput)
        pub fn build(self) -> crate::output::DescribeServiceUpdatesOutput {
            crate::output::DescribeServiceUpdatesOutput {
                marker: self.marker,
                service_updates: self.service_updates,
            }
        }
    }
}
impl DescribeServiceUpdatesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeServiceUpdatesOutput`](crate::output::DescribeServiceUpdatesOutput)
    pub fn builder() -> crate::output::describe_service_updates_output::Builder {
        crate::output::describe_service_updates_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeReservedCacheNodesOfferings</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedCacheNodesOfferingsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of reserved cache node offerings. Each element in the list contains detailed information about one offering.</p>
    pub reserved_cache_nodes_offerings:
        std::option::Option<std::vec::Vec<crate::model::ReservedCacheNodesOffering>>,
}
impl DescribeReservedCacheNodesOfferingsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of reserved cache node offerings. Each element in the list contains detailed information about one offering.</p>
    pub fn reserved_cache_nodes_offerings(
        &self,
    ) -> std::option::Option<&[crate::model::ReservedCacheNodesOffering]> {
        self.reserved_cache_nodes_offerings.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservedCacheNodesOfferingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedCacheNodesOfferingsOutput");
        formatter.field("marker", &self.marker);
        formatter.field(
            "reserved_cache_nodes_offerings",
            &self.reserved_cache_nodes_offerings,
        );
        formatter.finish()
    }
}
/// See [`DescribeReservedCacheNodesOfferingsOutput`](crate::output::DescribeReservedCacheNodesOfferingsOutput)
pub mod describe_reserved_cache_nodes_offerings_output {
    /// A builder for [`DescribeReservedCacheNodesOfferingsOutput`](crate::output::DescribeReservedCacheNodesOfferingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) reserved_cache_nodes_offerings:
            std::option::Option<std::vec::Vec<crate::model::ReservedCacheNodesOffering>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `reserved_cache_nodes_offerings`.
        ///
        /// To override the contents of this collection use [`set_reserved_cache_nodes_offerings`](Self::set_reserved_cache_nodes_offerings).
        ///
        /// <p>A list of reserved cache node offerings. Each element in the list contains detailed information about one offering.</p>
        pub fn reserved_cache_nodes_offerings(
            mut self,
            input: impl Into<crate::model::ReservedCacheNodesOffering>,
        ) -> Self {
            let mut v = self.reserved_cache_nodes_offerings.unwrap_or_default();
            v.push(input.into());
            self.reserved_cache_nodes_offerings = Some(v);
            self
        }
        /// <p>A list of reserved cache node offerings. Each element in the list contains detailed information about one offering.</p>
        pub fn set_reserved_cache_nodes_offerings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReservedCacheNodesOffering>>,
        ) -> Self {
            self.reserved_cache_nodes_offerings = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedCacheNodesOfferingsOutput`](crate::output::DescribeReservedCacheNodesOfferingsOutput)
        pub fn build(self) -> crate::output::DescribeReservedCacheNodesOfferingsOutput {
            crate::output::DescribeReservedCacheNodesOfferingsOutput {
                marker: self.marker,
                reserved_cache_nodes_offerings: self.reserved_cache_nodes_offerings,
            }
        }
    }
}
impl DescribeReservedCacheNodesOfferingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReservedCacheNodesOfferingsOutput`](crate::output::DescribeReservedCacheNodesOfferingsOutput)
    pub fn builder() -> crate::output::describe_reserved_cache_nodes_offerings_output::Builder {
        crate::output::describe_reserved_cache_nodes_offerings_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeReservedCacheNodes</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedCacheNodesOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of reserved cache nodes. Each element in the list contains detailed information about one node.</p>
    pub reserved_cache_nodes: std::option::Option<std::vec::Vec<crate::model::ReservedCacheNode>>,
}
impl DescribeReservedCacheNodesOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of reserved cache nodes. Each element in the list contains detailed information about one node.</p>
    pub fn reserved_cache_nodes(&self) -> std::option::Option<&[crate::model::ReservedCacheNode]> {
        self.reserved_cache_nodes.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservedCacheNodesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedCacheNodesOutput");
        formatter.field("marker", &self.marker);
        formatter.field("reserved_cache_nodes", &self.reserved_cache_nodes);
        formatter.finish()
    }
}
/// See [`DescribeReservedCacheNodesOutput`](crate::output::DescribeReservedCacheNodesOutput)
pub mod describe_reserved_cache_nodes_output {
    /// A builder for [`DescribeReservedCacheNodesOutput`](crate::output::DescribeReservedCacheNodesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) reserved_cache_nodes:
            std::option::Option<std::vec::Vec<crate::model::ReservedCacheNode>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `reserved_cache_nodes`.
        ///
        /// To override the contents of this collection use [`set_reserved_cache_nodes`](Self::set_reserved_cache_nodes).
        ///
        /// <p>A list of reserved cache nodes. Each element in the list contains detailed information about one node.</p>
        pub fn reserved_cache_nodes(
            mut self,
            input: impl Into<crate::model::ReservedCacheNode>,
        ) -> Self {
            let mut v = self.reserved_cache_nodes.unwrap_or_default();
            v.push(input.into());
            self.reserved_cache_nodes = Some(v);
            self
        }
        /// <p>A list of reserved cache nodes. Each element in the list contains detailed information about one node.</p>
        pub fn set_reserved_cache_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReservedCacheNode>>,
        ) -> Self {
            self.reserved_cache_nodes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedCacheNodesOutput`](crate::output::DescribeReservedCacheNodesOutput)
        pub fn build(self) -> crate::output::DescribeReservedCacheNodesOutput {
            crate::output::DescribeReservedCacheNodesOutput {
                marker: self.marker,
                reserved_cache_nodes: self.reserved_cache_nodes,
            }
        }
    }
}
impl DescribeReservedCacheNodesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReservedCacheNodesOutput`](crate::output::DescribeReservedCacheNodesOutput)
    pub fn builder() -> crate::output::describe_reserved_cache_nodes_output::Builder {
        crate::output::describe_reserved_cache_nodes_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeReplicationGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplicationGroupsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of replication groups. Each item in the list contains detailed information about one replication group.</p>
    pub replication_groups: std::option::Option<std::vec::Vec<crate::model::ReplicationGroup>>,
}
impl DescribeReplicationGroupsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of replication groups. Each item in the list contains detailed information about one replication group.</p>
    pub fn replication_groups(&self) -> std::option::Option<&[crate::model::ReplicationGroup]> {
        self.replication_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeReplicationGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplicationGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("replication_groups", &self.replication_groups);
        formatter.finish()
    }
}
/// See [`DescribeReplicationGroupsOutput`](crate::output::DescribeReplicationGroupsOutput)
pub mod describe_replication_groups_output {
    /// A builder for [`DescribeReplicationGroupsOutput`](crate::output::DescribeReplicationGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) replication_groups:
            std::option::Option<std::vec::Vec<crate::model::ReplicationGroup>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `replication_groups`.
        ///
        /// To override the contents of this collection use [`set_replication_groups`](Self::set_replication_groups).
        ///
        /// <p>A list of replication groups. Each item in the list contains detailed information about one replication group.</p>
        pub fn replication_groups(
            mut self,
            input: impl Into<crate::model::ReplicationGroup>,
        ) -> Self {
            let mut v = self.replication_groups.unwrap_or_default();
            v.push(input.into());
            self.replication_groups = Some(v);
            self
        }
        /// <p>A list of replication groups. Each item in the list contains detailed information about one replication group.</p>
        pub fn set_replication_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationGroup>>,
        ) -> Self {
            self.replication_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplicationGroupsOutput`](crate::output::DescribeReplicationGroupsOutput)
        pub fn build(self) -> crate::output::DescribeReplicationGroupsOutput {
            crate::output::DescribeReplicationGroupsOutput {
                marker: self.marker,
                replication_groups: self.replication_groups,
            }
        }
    }
}
impl DescribeReplicationGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationGroupsOutput`](crate::output::DescribeReplicationGroupsOutput)
    pub fn builder() -> crate::output::describe_replication_groups_output::Builder {
        crate::output::describe_replication_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGlobalReplicationGroupsOutput {
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. ></p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Indicates the slot configuration and global identifier for each slice group.</p>
    pub global_replication_groups:
        std::option::Option<std::vec::Vec<crate::model::GlobalReplicationGroup>>,
}
impl DescribeGlobalReplicationGroupsOutput {
    /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. ></p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Indicates the slot configuration and global identifier for each slice group.</p>
    pub fn global_replication_groups(
        &self,
    ) -> std::option::Option<&[crate::model::GlobalReplicationGroup]> {
        self.global_replication_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeGlobalReplicationGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGlobalReplicationGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("global_replication_groups", &self.global_replication_groups);
        formatter.finish()
    }
}
/// See [`DescribeGlobalReplicationGroupsOutput`](crate::output::DescribeGlobalReplicationGroupsOutput)
pub mod describe_global_replication_groups_output {
    /// A builder for [`DescribeGlobalReplicationGroupsOutput`](crate::output::DescribeGlobalReplicationGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) global_replication_groups:
            std::option::Option<std::vec::Vec<crate::model::GlobalReplicationGroup>>,
    }
    impl Builder {
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. ></p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. ></p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `global_replication_groups`.
        ///
        /// To override the contents of this collection use [`set_global_replication_groups`](Self::set_global_replication_groups).
        ///
        /// <p>Indicates the slot configuration and global identifier for each slice group.</p>
        pub fn global_replication_groups(
            mut self,
            input: impl Into<crate::model::GlobalReplicationGroup>,
        ) -> Self {
            let mut v = self.global_replication_groups.unwrap_or_default();
            v.push(input.into());
            self.global_replication_groups = Some(v);
            self
        }
        /// <p>Indicates the slot configuration and global identifier for each slice group.</p>
        pub fn set_global_replication_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalReplicationGroup>>,
        ) -> Self {
            self.global_replication_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGlobalReplicationGroupsOutput`](crate::output::DescribeGlobalReplicationGroupsOutput)
        pub fn build(self) -> crate::output::DescribeGlobalReplicationGroupsOutput {
            crate::output::DescribeGlobalReplicationGroupsOutput {
                marker: self.marker,
                global_replication_groups: self.global_replication_groups,
            }
        }
    }
}
impl DescribeGlobalReplicationGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalReplicationGroupsOutput`](crate::output::DescribeGlobalReplicationGroupsOutput)
    pub fn builder() -> crate::output::describe_global_replication_groups_output::Builder {
        crate::output::describe_global_replication_groups_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeEvents</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of events. Each element in the list contains detailed information about one event.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
}
impl DescribeEventsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of events. Each element in the list contains detailed information about one event.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::Event]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
pub mod describe_events_output {
    /// A builder for [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>A list of events. Each element in the list contains detailed information about one event.</p>
        pub fn events(mut self, input: impl Into<crate::model::Event>) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>A list of events. Each element in the list contains detailed information about one event.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
        pub fn build(self) -> crate::output::DescribeEventsOutput {
            crate::output::DescribeEventsOutput {
                marker: self.marker,
                events: self.events,
            }
        }
    }
}
impl DescribeEventsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    pub fn builder() -> crate::output::describe_events_output::Builder {
        crate::output::describe_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEngineDefaultParametersOutput {
    /// <p>Represents the output of a <code>DescribeEngineDefaultParameters</code> operation.</p>
    pub engine_defaults: std::option::Option<crate::model::EngineDefaults>,
}
impl DescribeEngineDefaultParametersOutput {
    /// <p>Represents the output of a <code>DescribeEngineDefaultParameters</code> operation.</p>
    pub fn engine_defaults(&self) -> std::option::Option<&crate::model::EngineDefaults> {
        self.engine_defaults.as_ref()
    }
}
impl std::fmt::Debug for DescribeEngineDefaultParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEngineDefaultParametersOutput");
        formatter.field("engine_defaults", &self.engine_defaults);
        formatter.finish()
    }
}
/// See [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput)
pub mod describe_engine_default_parameters_output {
    /// A builder for [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_defaults: std::option::Option<crate::model::EngineDefaults>,
    }
    impl Builder {
        /// <p>Represents the output of a <code>DescribeEngineDefaultParameters</code> operation.</p>
        pub fn engine_defaults(mut self, input: crate::model::EngineDefaults) -> Self {
            self.engine_defaults = Some(input);
            self
        }
        /// <p>Represents the output of a <code>DescribeEngineDefaultParameters</code> operation.</p>
        pub fn set_engine_defaults(
            mut self,
            input: std::option::Option<crate::model::EngineDefaults>,
        ) -> Self {
            self.engine_defaults = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput)
        pub fn build(self) -> crate::output::DescribeEngineDefaultParametersOutput {
            crate::output::DescribeEngineDefaultParametersOutput {
                engine_defaults: self.engine_defaults,
            }
        }
    }
}
impl DescribeEngineDefaultParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput)
    pub fn builder() -> crate::output::describe_engine_default_parameters_output::Builder {
        crate::output::describe_engine_default_parameters_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeCacheSubnetGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheSubnetGroupsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of cache subnet groups. Each element in the list contains detailed information about one group.</p>
    pub cache_subnet_groups: std::option::Option<std::vec::Vec<crate::model::CacheSubnetGroup>>,
}
impl DescribeCacheSubnetGroupsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of cache subnet groups. Each element in the list contains detailed information about one group.</p>
    pub fn cache_subnet_groups(&self) -> std::option::Option<&[crate::model::CacheSubnetGroup]> {
        self.cache_subnet_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeCacheSubnetGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheSubnetGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("cache_subnet_groups", &self.cache_subnet_groups);
        formatter.finish()
    }
}
/// See [`DescribeCacheSubnetGroupsOutput`](crate::output::DescribeCacheSubnetGroupsOutput)
pub mod describe_cache_subnet_groups_output {
    /// A builder for [`DescribeCacheSubnetGroupsOutput`](crate::output::DescribeCacheSubnetGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) cache_subnet_groups:
            std::option::Option<std::vec::Vec<crate::model::CacheSubnetGroup>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `cache_subnet_groups`.
        ///
        /// To override the contents of this collection use [`set_cache_subnet_groups`](Self::set_cache_subnet_groups).
        ///
        /// <p>A list of cache subnet groups. Each element in the list contains detailed information about one group.</p>
        pub fn cache_subnet_groups(
            mut self,
            input: impl Into<crate::model::CacheSubnetGroup>,
        ) -> Self {
            let mut v = self.cache_subnet_groups.unwrap_or_default();
            v.push(input.into());
            self.cache_subnet_groups = Some(v);
            self
        }
        /// <p>A list of cache subnet groups. Each element in the list contains detailed information about one group.</p>
        pub fn set_cache_subnet_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheSubnetGroup>>,
        ) -> Self {
            self.cache_subnet_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheSubnetGroupsOutput`](crate::output::DescribeCacheSubnetGroupsOutput)
        pub fn build(self) -> crate::output::DescribeCacheSubnetGroupsOutput {
            crate::output::DescribeCacheSubnetGroupsOutput {
                marker: self.marker,
                cache_subnet_groups: self.cache_subnet_groups,
            }
        }
    }
}
impl DescribeCacheSubnetGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCacheSubnetGroupsOutput`](crate::output::DescribeCacheSubnetGroupsOutput)
    pub fn builder() -> crate::output::describe_cache_subnet_groups_output::Builder {
        crate::output::describe_cache_subnet_groups_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeCacheSecurityGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheSecurityGroupsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of cache security groups. Each element in the list contains detailed information about one group.</p>
    pub cache_security_groups: std::option::Option<std::vec::Vec<crate::model::CacheSecurityGroup>>,
}
impl DescribeCacheSecurityGroupsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of cache security groups. Each element in the list contains detailed information about one group.</p>
    pub fn cache_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::CacheSecurityGroup]> {
        self.cache_security_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeCacheSecurityGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheSecurityGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("cache_security_groups", &self.cache_security_groups);
        formatter.finish()
    }
}
/// See [`DescribeCacheSecurityGroupsOutput`](crate::output::DescribeCacheSecurityGroupsOutput)
pub mod describe_cache_security_groups_output {
    /// A builder for [`DescribeCacheSecurityGroupsOutput`](crate::output::DescribeCacheSecurityGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) cache_security_groups:
            std::option::Option<std::vec::Vec<crate::model::CacheSecurityGroup>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `cache_security_groups`.
        ///
        /// To override the contents of this collection use [`set_cache_security_groups`](Self::set_cache_security_groups).
        ///
        /// <p>A list of cache security groups. Each element in the list contains detailed information about one group.</p>
        pub fn cache_security_groups(
            mut self,
            input: impl Into<crate::model::CacheSecurityGroup>,
        ) -> Self {
            let mut v = self.cache_security_groups.unwrap_or_default();
            v.push(input.into());
            self.cache_security_groups = Some(v);
            self
        }
        /// <p>A list of cache security groups. Each element in the list contains detailed information about one group.</p>
        pub fn set_cache_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheSecurityGroup>>,
        ) -> Self {
            self.cache_security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheSecurityGroupsOutput`](crate::output::DescribeCacheSecurityGroupsOutput)
        pub fn build(self) -> crate::output::DescribeCacheSecurityGroupsOutput {
            crate::output::DescribeCacheSecurityGroupsOutput {
                marker: self.marker,
                cache_security_groups: self.cache_security_groups,
            }
        }
    }
}
impl DescribeCacheSecurityGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCacheSecurityGroupsOutput`](crate::output::DescribeCacheSecurityGroupsOutput)
    pub fn builder() -> crate::output::describe_cache_security_groups_output::Builder {
        crate::output::describe_cache_security_groups_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeCacheParameters</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheParametersOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of <a>Parameter</a> instances.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>A list of parameters specific to a particular cache node type.
    /// Each element in the list contains detailed information about one parameter.</p>
    pub cache_node_type_specific_parameters:
        std::option::Option<std::vec::Vec<crate::model::CacheNodeTypeSpecificParameter>>,
}
impl DescribeCacheParametersOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of <a>Parameter</a> instances.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
    /// <p>A list of parameters specific to a particular cache node type.
    /// Each element in the list contains detailed information about one parameter.</p>
    pub fn cache_node_type_specific_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::CacheNodeTypeSpecificParameter]> {
        self.cache_node_type_specific_parameters.as_deref()
    }
}
impl std::fmt::Debug for DescribeCacheParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheParametersOutput");
        formatter.field("marker", &self.marker);
        formatter.field("parameters", &self.parameters);
        formatter.field(
            "cache_node_type_specific_parameters",
            &self.cache_node_type_specific_parameters,
        );
        formatter.finish()
    }
}
/// See [`DescribeCacheParametersOutput`](crate::output::DescribeCacheParametersOutput)
pub mod describe_cache_parameters_output {
    /// A builder for [`DescribeCacheParametersOutput`](crate::output::DescribeCacheParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) cache_node_type_specific_parameters:
            std::option::Option<std::vec::Vec<crate::model::CacheNodeTypeSpecificParameter>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of <a>Parameter</a> instances.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A list of <a>Parameter</a> instances.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `cache_node_type_specific_parameters`.
        ///
        /// To override the contents of this collection use [`set_cache_node_type_specific_parameters`](Self::set_cache_node_type_specific_parameters).
        ///
        /// <p>A list of parameters specific to a particular cache node type.
        /// Each element in the list contains detailed information about one parameter.</p>
        pub fn cache_node_type_specific_parameters(
            mut self,
            input: impl Into<crate::model::CacheNodeTypeSpecificParameter>,
        ) -> Self {
            let mut v = self.cache_node_type_specific_parameters.unwrap_or_default();
            v.push(input.into());
            self.cache_node_type_specific_parameters = Some(v);
            self
        }
        /// <p>A list of parameters specific to a particular cache node type.
        /// Each element in the list contains detailed information about one parameter.</p>
        pub fn set_cache_node_type_specific_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheNodeTypeSpecificParameter>>,
        ) -> Self {
            self.cache_node_type_specific_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheParametersOutput`](crate::output::DescribeCacheParametersOutput)
        pub fn build(self) -> crate::output::DescribeCacheParametersOutput {
            crate::output::DescribeCacheParametersOutput {
                marker: self.marker,
                parameters: self.parameters,
                cache_node_type_specific_parameters: self.cache_node_type_specific_parameters,
            }
        }
    }
}
impl DescribeCacheParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCacheParametersOutput`](crate::output::DescribeCacheParametersOutput)
    pub fn builder() -> crate::output::describe_cache_parameters_output::Builder {
        crate::output::describe_cache_parameters_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeCacheParameterGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheParameterGroupsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of cache parameter groups. Each element in the list contains detailed information
    /// about one cache parameter group.</p>
    pub cache_parameter_groups:
        std::option::Option<std::vec::Vec<crate::model::CacheParameterGroup>>,
}
impl DescribeCacheParameterGroupsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of cache parameter groups. Each element in the list contains detailed information
    /// about one cache parameter group.</p>
    pub fn cache_parameter_groups(
        &self,
    ) -> std::option::Option<&[crate::model::CacheParameterGroup]> {
        self.cache_parameter_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeCacheParameterGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheParameterGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("cache_parameter_groups", &self.cache_parameter_groups);
        formatter.finish()
    }
}
/// See [`DescribeCacheParameterGroupsOutput`](crate::output::DescribeCacheParameterGroupsOutput)
pub mod describe_cache_parameter_groups_output {
    /// A builder for [`DescribeCacheParameterGroupsOutput`](crate::output::DescribeCacheParameterGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) cache_parameter_groups:
            std::option::Option<std::vec::Vec<crate::model::CacheParameterGroup>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `cache_parameter_groups`.
        ///
        /// To override the contents of this collection use [`set_cache_parameter_groups`](Self::set_cache_parameter_groups).
        ///
        /// <p>A list of cache parameter groups. Each element in the list contains detailed information
        /// about one cache parameter group.</p>
        pub fn cache_parameter_groups(
            mut self,
            input: impl Into<crate::model::CacheParameterGroup>,
        ) -> Self {
            let mut v = self.cache_parameter_groups.unwrap_or_default();
            v.push(input.into());
            self.cache_parameter_groups = Some(v);
            self
        }
        /// <p>A list of cache parameter groups. Each element in the list contains detailed information
        /// about one cache parameter group.</p>
        pub fn set_cache_parameter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheParameterGroup>>,
        ) -> Self {
            self.cache_parameter_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheParameterGroupsOutput`](crate::output::DescribeCacheParameterGroupsOutput)
        pub fn build(self) -> crate::output::DescribeCacheParameterGroupsOutput {
            crate::output::DescribeCacheParameterGroupsOutput {
                marker: self.marker,
                cache_parameter_groups: self.cache_parameter_groups,
            }
        }
    }
}
impl DescribeCacheParameterGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCacheParameterGroupsOutput`](crate::output::DescribeCacheParameterGroupsOutput)
    pub fn builder() -> crate::output::describe_cache_parameter_groups_output::Builder {
        crate::output::describe_cache_parameter_groups_output::Builder::default()
    }
}

/// <p>Represents the output of a <a>DescribeCacheEngineVersions</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheEngineVersionsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of cache engine version details.
    /// Each element in the list contains detailed information about one cache engine version.</p>
    pub cache_engine_versions: std::option::Option<std::vec::Vec<crate::model::CacheEngineVersion>>,
}
impl DescribeCacheEngineVersionsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of cache engine version details.
    /// Each element in the list contains detailed information about one cache engine version.</p>
    pub fn cache_engine_versions(
        &self,
    ) -> std::option::Option<&[crate::model::CacheEngineVersion]> {
        self.cache_engine_versions.as_deref()
    }
}
impl std::fmt::Debug for DescribeCacheEngineVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheEngineVersionsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("cache_engine_versions", &self.cache_engine_versions);
        formatter.finish()
    }
}
/// See [`DescribeCacheEngineVersionsOutput`](crate::output::DescribeCacheEngineVersionsOutput)
pub mod describe_cache_engine_versions_output {
    /// A builder for [`DescribeCacheEngineVersionsOutput`](crate::output::DescribeCacheEngineVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) cache_engine_versions:
            std::option::Option<std::vec::Vec<crate::model::CacheEngineVersion>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `cache_engine_versions`.
        ///
        /// To override the contents of this collection use [`set_cache_engine_versions`](Self::set_cache_engine_versions).
        ///
        /// <p>A list of cache engine version details.
        /// Each element in the list contains detailed information about one cache engine version.</p>
        pub fn cache_engine_versions(
            mut self,
            input: impl Into<crate::model::CacheEngineVersion>,
        ) -> Self {
            let mut v = self.cache_engine_versions.unwrap_or_default();
            v.push(input.into());
            self.cache_engine_versions = Some(v);
            self
        }
        /// <p>A list of cache engine version details.
        /// Each element in the list contains detailed information about one cache engine version.</p>
        pub fn set_cache_engine_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheEngineVersion>>,
        ) -> Self {
            self.cache_engine_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheEngineVersionsOutput`](crate::output::DescribeCacheEngineVersionsOutput)
        pub fn build(self) -> crate::output::DescribeCacheEngineVersionsOutput {
            crate::output::DescribeCacheEngineVersionsOutput {
                marker: self.marker,
                cache_engine_versions: self.cache_engine_versions,
            }
        }
    }
}
impl DescribeCacheEngineVersionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCacheEngineVersionsOutput`](crate::output::DescribeCacheEngineVersionsOutput)
    pub fn builder() -> crate::output::describe_cache_engine_versions_output::Builder {
        crate::output::describe_cache_engine_versions_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeCacheClusters</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCacheClustersOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of clusters. Each item in the list contains detailed information about one cluster.</p>
    pub cache_clusters: std::option::Option<std::vec::Vec<crate::model::CacheCluster>>,
}
impl DescribeCacheClustersOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of clusters. Each item in the list contains detailed information about one cluster.</p>
    pub fn cache_clusters(&self) -> std::option::Option<&[crate::model::CacheCluster]> {
        self.cache_clusters.as_deref()
    }
}
impl std::fmt::Debug for DescribeCacheClustersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCacheClustersOutput");
        formatter.field("marker", &self.marker);
        formatter.field("cache_clusters", &self.cache_clusters);
        formatter.finish()
    }
}
/// See [`DescribeCacheClustersOutput`](crate::output::DescribeCacheClustersOutput)
pub mod describe_cache_clusters_output {
    /// A builder for [`DescribeCacheClustersOutput`](crate::output::DescribeCacheClustersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) cache_clusters: std::option::Option<std::vec::Vec<crate::model::CacheCluster>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `cache_clusters`.
        ///
        /// To override the contents of this collection use [`set_cache_clusters`](Self::set_cache_clusters).
        ///
        /// <p>A list of clusters. Each item in the list contains detailed information about one cluster.</p>
        pub fn cache_clusters(mut self, input: impl Into<crate::model::CacheCluster>) -> Self {
            let mut v = self.cache_clusters.unwrap_or_default();
            v.push(input.into());
            self.cache_clusters = Some(v);
            self
        }
        /// <p>A list of clusters. Each item in the list contains detailed information about one cluster.</p>
        pub fn set_cache_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheCluster>>,
        ) -> Self {
            self.cache_clusters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCacheClustersOutput`](crate::output::DescribeCacheClustersOutput)
        pub fn build(self) -> crate::output::DescribeCacheClustersOutput {
            crate::output::DescribeCacheClustersOutput {
                marker: self.marker,
                cache_clusters: self.cache_clusters,
            }
        }
    }
}
impl DescribeCacheClustersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCacheClustersOutput`](crate::output::DescribeCacheClustersOutput)
    pub fn builder() -> crate::output::describe_cache_clusters_output::Builder {
        crate::output::describe_cache_clusters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserGroupOutput {
    /// <p>The ID of the user group.</p>
    pub user_group_id: std::option::Option<std::string::String>,
    /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The current supported value is Redis. </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The list of user IDs that belong to the user group.</p>
    pub user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>A list of updates being applied to the user group.</p>
    pub pending_changes: std::option::Option<crate::model::UserGroupPendingChanges>,
    /// <p>A list of replication groups that the user group can access.</p>
    pub replication_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the user group.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteUserGroupOutput {
    /// <p>The ID of the user group.</p>
    pub fn user_group_id(&self) -> std::option::Option<&str> {
        self.user_group_id.as_deref()
    }
    /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The current supported value is Redis. </p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The list of user IDs that belong to the user group.</p>
    pub fn user_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.user_ids.as_deref()
    }
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>A list of updates being applied to the user group.</p>
    pub fn pending_changes(&self) -> std::option::Option<&crate::model::UserGroupPendingChanges> {
        self.pending_changes.as_ref()
    }
    /// <p>A list of replication groups that the user group can access.</p>
    pub fn replication_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.replication_groups.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteUserGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserGroupOutput");
        formatter.field("user_group_id", &self.user_group_id);
        formatter.field("status", &self.status);
        formatter.field("engine", &self.engine);
        formatter.field("user_ids", &self.user_ids);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("pending_changes", &self.pending_changes);
        formatter.field("replication_groups", &self.replication_groups);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DeleteUserGroupOutput`](crate::output::DeleteUserGroupOutput)
pub mod delete_user_group_output {
    /// A builder for [`DeleteUserGroupOutput`](crate::output::DeleteUserGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_group_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) pending_changes: std::option::Option<crate::model::UserGroupPendingChanges>,
        pub(crate) replication_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user group.</p>
        pub fn user_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the user group.</p>
        pub fn set_user_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_group_id = input;
            self
        }
        /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// Appends an item to `user_ids`.
        ///
        /// To override the contents of this collection use [`set_user_ids`](Self::set_user_ids).
        ///
        /// <p>The list of user IDs that belong to the user group.</p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_ids.unwrap_or_default();
            v.push(input.into());
            self.user_ids = Some(v);
            self
        }
        /// <p>The list of user IDs that belong to the user group.</p>
        pub fn set_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_ids = input;
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>A list of updates being applied to the user group.</p>
        pub fn pending_changes(mut self, input: crate::model::UserGroupPendingChanges) -> Self {
            self.pending_changes = Some(input);
            self
        }
        /// <p>A list of updates being applied to the user group.</p>
        pub fn set_pending_changes(
            mut self,
            input: std::option::Option<crate::model::UserGroupPendingChanges>,
        ) -> Self {
            self.pending_changes = input;
            self
        }
        /// Appends an item to `replication_groups`.
        ///
        /// To override the contents of this collection use [`set_replication_groups`](Self::set_replication_groups).
        ///
        /// <p>A list of replication groups that the user group can access.</p>
        pub fn replication_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.replication_groups.unwrap_or_default();
            v.push(input.into());
            self.replication_groups = Some(v);
            self
        }
        /// <p>A list of replication groups that the user group can access.</p>
        pub fn set_replication_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_groups = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserGroupOutput`](crate::output::DeleteUserGroupOutput)
        pub fn build(self) -> crate::output::DeleteUserGroupOutput {
            crate::output::DeleteUserGroupOutput {
                user_group_id: self.user_group_id,
                status: self.status,
                engine: self.engine,
                user_ids: self.user_ids,
                minimum_engine_version: self.minimum_engine_version,
                pending_changes: self.pending_changes,
                replication_groups: self.replication_groups,
                arn: self.arn,
            }
        }
    }
}
impl DeleteUserGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserGroupOutput`](crate::output::DeleteUserGroupOutput)
    pub fn builder() -> crate::output::delete_user_group_output::Builder {
        crate::output::delete_user_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserOutput {
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The username of the user.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The current supported value is Redis.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>Access permissions string used for this user.</p>
    pub access_string: std::option::Option<std::string::String>,
    /// <p>Returns a list of the user group IDs the user belongs to.</p>
    pub user_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Denotes whether the user requires a password to authenticate.</p>
    pub authentication: std::option::Option<crate::model::Authentication>,
    /// <p>The Amazon Resource Name (ARN) of the user.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteUserOutput {
    /// <p>The ID of the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The username of the user.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The current supported value is Redis.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>Access permissions string used for this user.</p>
    pub fn access_string(&self) -> std::option::Option<&str> {
        self.access_string.as_deref()
    }
    /// <p>Returns a list of the user group IDs the user belongs to.</p>
    pub fn user_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.user_group_ids.as_deref()
    }
    /// <p>Denotes whether the user requires a password to authenticate.</p>
    pub fn authentication(&self) -> std::option::Option<&crate::model::Authentication> {
        self.authentication.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserOutput");
        formatter.field("user_id", &self.user_id);
        formatter.field("user_name", &self.user_name);
        formatter.field("status", &self.status);
        formatter.field("engine", &self.engine);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("access_string", &self.access_string);
        formatter.field("user_group_ids", &self.user_group_ids);
        formatter.field("authentication", &self.authentication);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DeleteUserOutput`](crate::output::DeleteUserOutput)
pub mod delete_user_output {
    /// A builder for [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) access_string: std::option::Option<std::string::String>,
        pub(crate) user_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) authentication: std::option::Option<crate::model::Authentication>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The username of the user.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The username of the user.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The current supported value is Redis.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The current supported value is Redis.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_string = Some(input.into());
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_string = input;
            self
        }
        /// Appends an item to `user_group_ids`.
        ///
        /// To override the contents of this collection use [`set_user_group_ids`](Self::set_user_group_ids).
        ///
        /// <p>Returns a list of the user group IDs the user belongs to.</p>
        pub fn user_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_group_ids.unwrap_or_default();
            v.push(input.into());
            self.user_group_ids = Some(v);
            self
        }
        /// <p>Returns a list of the user group IDs the user belongs to.</p>
        pub fn set_user_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_group_ids = input;
            self
        }
        /// <p>Denotes whether the user requires a password to authenticate.</p>
        pub fn authentication(mut self, input: crate::model::Authentication) -> Self {
            self.authentication = Some(input);
            self
        }
        /// <p>Denotes whether the user requires a password to authenticate.</p>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<crate::model::Authentication>,
        ) -> Self {
            self.authentication = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserOutput`](crate::output::DeleteUserOutput)
        pub fn build(self) -> crate::output::DeleteUserOutput {
            crate::output::DeleteUserOutput {
                user_id: self.user_id,
                user_name: self.user_name,
                status: self.status,
                engine: self.engine,
                minimum_engine_version: self.minimum_engine_version,
                access_string: self.access_string,
                user_group_ids: self.user_group_ids,
                authentication: self.authentication,
                arn: self.arn,
            }
        }
    }
}
impl DeleteUserOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    pub fn builder() -> crate::output::delete_user_output::Builder {
        crate::output::delete_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSnapshotOutput {
    /// <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
    pub snapshot: std::option::Option<crate::model::Snapshot>,
}
impl DeleteSnapshotOutput {
    /// <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::Snapshot> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for DeleteSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSnapshotOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput)
pub mod delete_snapshot_output {
    /// A builder for [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::Snapshot>,
    }
    impl Builder {
        /// <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
        pub fn snapshot(mut self, input: crate::model::Snapshot) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
        pub fn set_snapshot(mut self, input: std::option::Option<crate::model::Snapshot>) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput)
        pub fn build(self) -> crate::output::DeleteSnapshotOutput {
            crate::output::DeleteSnapshotOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl DeleteSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput)
    pub fn builder() -> crate::output::delete_snapshot_output::Builder {
        crate::output::delete_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationGroupOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub replication_group: std::option::Option<crate::model::ReplicationGroup>,
}
impl DeleteReplicationGroupOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub fn replication_group(&self) -> std::option::Option<&crate::model::ReplicationGroup> {
        self.replication_group.as_ref()
    }
}
impl std::fmt::Debug for DeleteReplicationGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationGroupOutput");
        formatter.field("replication_group", &self.replication_group);
        formatter.finish()
    }
}
/// See [`DeleteReplicationGroupOutput`](crate::output::DeleteReplicationGroupOutput)
pub mod delete_replication_group_output {
    /// A builder for [`DeleteReplicationGroupOutput`](crate::output::DeleteReplicationGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group: std::option::Option<crate::model::ReplicationGroup>,
    }
    impl Builder {
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn replication_group(mut self, input: crate::model::ReplicationGroup) -> Self {
            self.replication_group = Some(input);
            self
        }
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<crate::model::ReplicationGroup>,
        ) -> Self {
            self.replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReplicationGroupOutput`](crate::output::DeleteReplicationGroupOutput)
        pub fn build(self) -> crate::output::DeleteReplicationGroupOutput {
            crate::output::DeleteReplicationGroupOutput {
                replication_group: self.replication_group,
            }
        }
    }
}
impl DeleteReplicationGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationGroupOutput`](crate::output::DeleteReplicationGroupOutput)
    pub fn builder() -> crate::output::delete_replication_group_output::Builder {
        crate::output::delete_replication_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub global_replication_group: std::option::Option<crate::model::GlobalReplicationGroup>,
}
impl DeleteGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub fn global_replication_group(
        &self,
    ) -> std::option::Option<&crate::model::GlobalReplicationGroup> {
        self.global_replication_group.as_ref()
    }
}
impl std::fmt::Debug for DeleteGlobalReplicationGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGlobalReplicationGroupOutput");
        formatter.field("global_replication_group", &self.global_replication_group);
        formatter.finish()
    }
}
/// See [`DeleteGlobalReplicationGroupOutput`](crate::output::DeleteGlobalReplicationGroupOutput)
pub mod delete_global_replication_group_output {
    /// A builder for [`DeleteGlobalReplicationGroupOutput`](crate::output::DeleteGlobalReplicationGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group:
            std::option::Option<crate::model::GlobalReplicationGroup>,
    }
    impl Builder {
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn global_replication_group(
            mut self,
            input: crate::model::GlobalReplicationGroup,
        ) -> Self {
            self.global_replication_group = Some(input);
            self
        }
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_global_replication_group(
            mut self,
            input: std::option::Option<crate::model::GlobalReplicationGroup>,
        ) -> Self {
            self.global_replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGlobalReplicationGroupOutput`](crate::output::DeleteGlobalReplicationGroupOutput)
        pub fn build(self) -> crate::output::DeleteGlobalReplicationGroupOutput {
            crate::output::DeleteGlobalReplicationGroupOutput {
                global_replication_group: self.global_replication_group,
            }
        }
    }
}
impl DeleteGlobalReplicationGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGlobalReplicationGroupOutput`](crate::output::DeleteGlobalReplicationGroupOutput)
    pub fn builder() -> crate::output::delete_global_replication_group_output::Builder {
        crate::output::delete_global_replication_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCacheSubnetGroupOutput {}
impl std::fmt::Debug for DeleteCacheSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCacheSubnetGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteCacheSubnetGroupOutput`](crate::output::DeleteCacheSubnetGroupOutput)
pub mod delete_cache_subnet_group_output {
    /// A builder for [`DeleteCacheSubnetGroupOutput`](crate::output::DeleteCacheSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCacheSubnetGroupOutput`](crate::output::DeleteCacheSubnetGroupOutput)
        pub fn build(self) -> crate::output::DeleteCacheSubnetGroupOutput {
            crate::output::DeleteCacheSubnetGroupOutput {}
        }
    }
}
impl DeleteCacheSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCacheSubnetGroupOutput`](crate::output::DeleteCacheSubnetGroupOutput)
    pub fn builder() -> crate::output::delete_cache_subnet_group_output::Builder {
        crate::output::delete_cache_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCacheSecurityGroupOutput {}
impl std::fmt::Debug for DeleteCacheSecurityGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCacheSecurityGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteCacheSecurityGroupOutput`](crate::output::DeleteCacheSecurityGroupOutput)
pub mod delete_cache_security_group_output {
    /// A builder for [`DeleteCacheSecurityGroupOutput`](crate::output::DeleteCacheSecurityGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCacheSecurityGroupOutput`](crate::output::DeleteCacheSecurityGroupOutput)
        pub fn build(self) -> crate::output::DeleteCacheSecurityGroupOutput {
            crate::output::DeleteCacheSecurityGroupOutput {}
        }
    }
}
impl DeleteCacheSecurityGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCacheSecurityGroupOutput`](crate::output::DeleteCacheSecurityGroupOutput)
    pub fn builder() -> crate::output::delete_cache_security_group_output::Builder {
        crate::output::delete_cache_security_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCacheParameterGroupOutput {}
impl std::fmt::Debug for DeleteCacheParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCacheParameterGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteCacheParameterGroupOutput`](crate::output::DeleteCacheParameterGroupOutput)
pub mod delete_cache_parameter_group_output {
    /// A builder for [`DeleteCacheParameterGroupOutput`](crate::output::DeleteCacheParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCacheParameterGroupOutput`](crate::output::DeleteCacheParameterGroupOutput)
        pub fn build(self) -> crate::output::DeleteCacheParameterGroupOutput {
            crate::output::DeleteCacheParameterGroupOutput {}
        }
    }
}
impl DeleteCacheParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCacheParameterGroupOutput`](crate::output::DeleteCacheParameterGroupOutput)
    pub fn builder() -> crate::output::delete_cache_parameter_group_output::Builder {
        crate::output::delete_cache_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCacheClusterOutput {
    /// <p>Contains all of the attributes of a specific cluster.</p>
    pub cache_cluster: std::option::Option<crate::model::CacheCluster>,
}
impl DeleteCacheClusterOutput {
    /// <p>Contains all of the attributes of a specific cluster.</p>
    pub fn cache_cluster(&self) -> std::option::Option<&crate::model::CacheCluster> {
        self.cache_cluster.as_ref()
    }
}
impl std::fmt::Debug for DeleteCacheClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCacheClusterOutput");
        formatter.field("cache_cluster", &self.cache_cluster);
        formatter.finish()
    }
}
/// See [`DeleteCacheClusterOutput`](crate::output::DeleteCacheClusterOutput)
pub mod delete_cache_cluster_output {
    /// A builder for [`DeleteCacheClusterOutput`](crate::output::DeleteCacheClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster: std::option::Option<crate::model::CacheCluster>,
    }
    impl Builder {
        /// <p>Contains all of the attributes of a specific cluster.</p>
        pub fn cache_cluster(mut self, input: crate::model::CacheCluster) -> Self {
            self.cache_cluster = Some(input);
            self
        }
        /// <p>Contains all of the attributes of a specific cluster.</p>
        pub fn set_cache_cluster(
            mut self,
            input: std::option::Option<crate::model::CacheCluster>,
        ) -> Self {
            self.cache_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCacheClusterOutput`](crate::output::DeleteCacheClusterOutput)
        pub fn build(self) -> crate::output::DeleteCacheClusterOutput {
            crate::output::DeleteCacheClusterOutput {
                cache_cluster: self.cache_cluster,
            }
        }
    }
}
impl DeleteCacheClusterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCacheClusterOutput`](crate::output::DeleteCacheClusterOutput)
    pub fn builder() -> crate::output::delete_cache_cluster_output::Builder {
        crate::output::delete_cache_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecreaseReplicaCountOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub replication_group: std::option::Option<crate::model::ReplicationGroup>,
}
impl DecreaseReplicaCountOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub fn replication_group(&self) -> std::option::Option<&crate::model::ReplicationGroup> {
        self.replication_group.as_ref()
    }
}
impl std::fmt::Debug for DecreaseReplicaCountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecreaseReplicaCountOutput");
        formatter.field("replication_group", &self.replication_group);
        formatter.finish()
    }
}
/// See [`DecreaseReplicaCountOutput`](crate::output::DecreaseReplicaCountOutput)
pub mod decrease_replica_count_output {
    /// A builder for [`DecreaseReplicaCountOutput`](crate::output::DecreaseReplicaCountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group: std::option::Option<crate::model::ReplicationGroup>,
    }
    impl Builder {
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn replication_group(mut self, input: crate::model::ReplicationGroup) -> Self {
            self.replication_group = Some(input);
            self
        }
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<crate::model::ReplicationGroup>,
        ) -> Self {
            self.replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DecreaseReplicaCountOutput`](crate::output::DecreaseReplicaCountOutput)
        pub fn build(self) -> crate::output::DecreaseReplicaCountOutput {
            crate::output::DecreaseReplicaCountOutput {
                replication_group: self.replication_group,
            }
        }
    }
}
impl DecreaseReplicaCountOutput {
    /// Creates a new builder-style object to manufacture [`DecreaseReplicaCountOutput`](crate::output::DecreaseReplicaCountOutput)
    pub fn builder() -> crate::output::decrease_replica_count_output::Builder {
        crate::output::decrease_replica_count_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecreaseNodeGroupsInGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub global_replication_group: std::option::Option<crate::model::GlobalReplicationGroup>,
}
impl DecreaseNodeGroupsInGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub fn global_replication_group(
        &self,
    ) -> std::option::Option<&crate::model::GlobalReplicationGroup> {
        self.global_replication_group.as_ref()
    }
}
impl std::fmt::Debug for DecreaseNodeGroupsInGlobalReplicationGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecreaseNodeGroupsInGlobalReplicationGroupOutput");
        formatter.field("global_replication_group", &self.global_replication_group);
        formatter.finish()
    }
}
/// See [`DecreaseNodeGroupsInGlobalReplicationGroupOutput`](crate::output::DecreaseNodeGroupsInGlobalReplicationGroupOutput)
pub mod decrease_node_groups_in_global_replication_group_output {
    /// A builder for [`DecreaseNodeGroupsInGlobalReplicationGroupOutput`](crate::output::DecreaseNodeGroupsInGlobalReplicationGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group:
            std::option::Option<crate::model::GlobalReplicationGroup>,
    }
    impl Builder {
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn global_replication_group(
            mut self,
            input: crate::model::GlobalReplicationGroup,
        ) -> Self {
            self.global_replication_group = Some(input);
            self
        }
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_global_replication_group(
            mut self,
            input: std::option::Option<crate::model::GlobalReplicationGroup>,
        ) -> Self {
            self.global_replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DecreaseNodeGroupsInGlobalReplicationGroupOutput`](crate::output::DecreaseNodeGroupsInGlobalReplicationGroupOutput)
        pub fn build(self) -> crate::output::DecreaseNodeGroupsInGlobalReplicationGroupOutput {
            crate::output::DecreaseNodeGroupsInGlobalReplicationGroupOutput {
                global_replication_group: self.global_replication_group,
            }
        }
    }
}
impl DecreaseNodeGroupsInGlobalReplicationGroupOutput {
    /// Creates a new builder-style object to manufacture [`DecreaseNodeGroupsInGlobalReplicationGroupOutput`](crate::output::DecreaseNodeGroupsInGlobalReplicationGroupOutput)
    pub fn builder(
    ) -> crate::output::decrease_node_groups_in_global_replication_group_output::Builder {
        crate::output::decrease_node_groups_in_global_replication_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserGroupOutput {
    /// <p>The ID of the user group.</p>
    pub user_group_id: std::option::Option<std::string::String>,
    /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The current supported value is Redis. </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The list of user IDs that belong to the user group.</p>
    pub user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>A list of updates being applied to the user group.</p>
    pub pending_changes: std::option::Option<crate::model::UserGroupPendingChanges>,
    /// <p>A list of replication groups that the user group can access.</p>
    pub replication_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the user group.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl CreateUserGroupOutput {
    /// <p>The ID of the user group.</p>
    pub fn user_group_id(&self) -> std::option::Option<&str> {
        self.user_group_id.as_deref()
    }
    /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The current supported value is Redis. </p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The list of user IDs that belong to the user group.</p>
    pub fn user_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.user_ids.as_deref()
    }
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>A list of updates being applied to the user group.</p>
    pub fn pending_changes(&self) -> std::option::Option<&crate::model::UserGroupPendingChanges> {
        self.pending_changes.as_ref()
    }
    /// <p>A list of replication groups that the user group can access.</p>
    pub fn replication_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.replication_groups.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for CreateUserGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserGroupOutput");
        formatter.field("user_group_id", &self.user_group_id);
        formatter.field("status", &self.status);
        formatter.field("engine", &self.engine);
        formatter.field("user_ids", &self.user_ids);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("pending_changes", &self.pending_changes);
        formatter.field("replication_groups", &self.replication_groups);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CreateUserGroupOutput`](crate::output::CreateUserGroupOutput)
pub mod create_user_group_output {
    /// A builder for [`CreateUserGroupOutput`](crate::output::CreateUserGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_group_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) pending_changes: std::option::Option<crate::model::UserGroupPendingChanges>,
        pub(crate) replication_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user group.</p>
        pub fn user_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the user group.</p>
        pub fn set_user_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_group_id = input;
            self
        }
        /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// Appends an item to `user_ids`.
        ///
        /// To override the contents of this collection use [`set_user_ids`](Self::set_user_ids).
        ///
        /// <p>The list of user IDs that belong to the user group.</p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_ids.unwrap_or_default();
            v.push(input.into());
            self.user_ids = Some(v);
            self
        }
        /// <p>The list of user IDs that belong to the user group.</p>
        pub fn set_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_ids = input;
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>A list of updates being applied to the user group.</p>
        pub fn pending_changes(mut self, input: crate::model::UserGroupPendingChanges) -> Self {
            self.pending_changes = Some(input);
            self
        }
        /// <p>A list of updates being applied to the user group.</p>
        pub fn set_pending_changes(
            mut self,
            input: std::option::Option<crate::model::UserGroupPendingChanges>,
        ) -> Self {
            self.pending_changes = input;
            self
        }
        /// Appends an item to `replication_groups`.
        ///
        /// To override the contents of this collection use [`set_replication_groups`](Self::set_replication_groups).
        ///
        /// <p>A list of replication groups that the user group can access.</p>
        pub fn replication_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.replication_groups.unwrap_or_default();
            v.push(input.into());
            self.replication_groups = Some(v);
            self
        }
        /// <p>A list of replication groups that the user group can access.</p>
        pub fn set_replication_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_groups = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserGroupOutput`](crate::output::CreateUserGroupOutput)
        pub fn build(self) -> crate::output::CreateUserGroupOutput {
            crate::output::CreateUserGroupOutput {
                user_group_id: self.user_group_id,
                status: self.status,
                engine: self.engine,
                user_ids: self.user_ids,
                minimum_engine_version: self.minimum_engine_version,
                pending_changes: self.pending_changes,
                replication_groups: self.replication_groups,
                arn: self.arn,
            }
        }
    }
}
impl CreateUserGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserGroupOutput`](crate::output::CreateUserGroupOutput)
    pub fn builder() -> crate::output::create_user_group_output::Builder {
        crate::output::create_user_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserOutput {
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The username of the user.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The current supported value is Redis.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>Access permissions string used for this user.</p>
    pub access_string: std::option::Option<std::string::String>,
    /// <p>Returns a list of the user group IDs the user belongs to.</p>
    pub user_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Denotes whether the user requires a password to authenticate.</p>
    pub authentication: std::option::Option<crate::model::Authentication>,
    /// <p>The Amazon Resource Name (ARN) of the user.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl CreateUserOutput {
    /// <p>The ID of the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The username of the user.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The current supported value is Redis.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>Access permissions string used for this user.</p>
    pub fn access_string(&self) -> std::option::Option<&str> {
        self.access_string.as_deref()
    }
    /// <p>Returns a list of the user group IDs the user belongs to.</p>
    pub fn user_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.user_group_ids.as_deref()
    }
    /// <p>Denotes whether the user requires a password to authenticate.</p>
    pub fn authentication(&self) -> std::option::Option<&crate::model::Authentication> {
        self.authentication.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for CreateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserOutput");
        formatter.field("user_id", &self.user_id);
        formatter.field("user_name", &self.user_name);
        formatter.field("status", &self.status);
        formatter.field("engine", &self.engine);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("access_string", &self.access_string);
        formatter.field("user_group_ids", &self.user_group_ids);
        formatter.field("authentication", &self.authentication);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CreateUserOutput`](crate::output::CreateUserOutput)
pub mod create_user_output {
    /// A builder for [`CreateUserOutput`](crate::output::CreateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) access_string: std::option::Option<std::string::String>,
        pub(crate) user_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) authentication: std::option::Option<crate::model::Authentication>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The username of the user.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The username of the user.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The current supported value is Redis.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The current supported value is Redis.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_string = Some(input.into());
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_string = input;
            self
        }
        /// Appends an item to `user_group_ids`.
        ///
        /// To override the contents of this collection use [`set_user_group_ids`](Self::set_user_group_ids).
        ///
        /// <p>Returns a list of the user group IDs the user belongs to.</p>
        pub fn user_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_group_ids.unwrap_or_default();
            v.push(input.into());
            self.user_group_ids = Some(v);
            self
        }
        /// <p>Returns a list of the user group IDs the user belongs to.</p>
        pub fn set_user_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_group_ids = input;
            self
        }
        /// <p>Denotes whether the user requires a password to authenticate.</p>
        pub fn authentication(mut self, input: crate::model::Authentication) -> Self {
            self.authentication = Some(input);
            self
        }
        /// <p>Denotes whether the user requires a password to authenticate.</p>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<crate::model::Authentication>,
        ) -> Self {
            self.authentication = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserOutput`](crate::output::CreateUserOutput)
        pub fn build(self) -> crate::output::CreateUserOutput {
            crate::output::CreateUserOutput {
                user_id: self.user_id,
                user_name: self.user_name,
                status: self.status,
                engine: self.engine,
                minimum_engine_version: self.minimum_engine_version,
                access_string: self.access_string,
                user_group_ids: self.user_group_ids,
                authentication: self.authentication,
                arn: self.arn,
            }
        }
    }
}
impl CreateUserOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserOutput`](crate::output::CreateUserOutput)
    pub fn builder() -> crate::output::create_user_output::Builder {
        crate::output::create_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSnapshotOutput {
    /// <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
    pub snapshot: std::option::Option<crate::model::Snapshot>,
}
impl CreateSnapshotOutput {
    /// <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::Snapshot> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for CreateSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSnapshotOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
pub mod create_snapshot_output {
    /// A builder for [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::Snapshot>,
    }
    impl Builder {
        /// <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
        pub fn snapshot(mut self, input: crate::model::Snapshot) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
        pub fn set_snapshot(mut self, input: std::option::Option<crate::model::Snapshot>) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
        pub fn build(self) -> crate::output::CreateSnapshotOutput {
            crate::output::CreateSnapshotOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl CreateSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
    pub fn builder() -> crate::output::create_snapshot_output::Builder {
        crate::output::create_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicationGroupOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub replication_group: std::option::Option<crate::model::ReplicationGroup>,
}
impl CreateReplicationGroupOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub fn replication_group(&self) -> std::option::Option<&crate::model::ReplicationGroup> {
        self.replication_group.as_ref()
    }
}
impl std::fmt::Debug for CreateReplicationGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReplicationGroupOutput");
        formatter.field("replication_group", &self.replication_group);
        formatter.finish()
    }
}
/// See [`CreateReplicationGroupOutput`](crate::output::CreateReplicationGroupOutput)
pub mod create_replication_group_output {
    /// A builder for [`CreateReplicationGroupOutput`](crate::output::CreateReplicationGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group: std::option::Option<crate::model::ReplicationGroup>,
    }
    impl Builder {
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn replication_group(mut self, input: crate::model::ReplicationGroup) -> Self {
            self.replication_group = Some(input);
            self
        }
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<crate::model::ReplicationGroup>,
        ) -> Self {
            self.replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicationGroupOutput`](crate::output::CreateReplicationGroupOutput)
        pub fn build(self) -> crate::output::CreateReplicationGroupOutput {
            crate::output::CreateReplicationGroupOutput {
                replication_group: self.replication_group,
            }
        }
    }
}
impl CreateReplicationGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateReplicationGroupOutput`](crate::output::CreateReplicationGroupOutput)
    pub fn builder() -> crate::output::create_replication_group_output::Builder {
        crate::output::create_replication_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub global_replication_group: std::option::Option<crate::model::GlobalReplicationGroup>,
}
impl CreateGlobalReplicationGroupOutput {
    /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
    /// cluster automatically replicates updates to the secondary cluster.</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
    /// which is what you use to associate a secondary cluster.</p>
    /// </li>
    /// </ul>
    pub fn global_replication_group(
        &self,
    ) -> std::option::Option<&crate::model::GlobalReplicationGroup> {
        self.global_replication_group.as_ref()
    }
}
impl std::fmt::Debug for CreateGlobalReplicationGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGlobalReplicationGroupOutput");
        formatter.field("global_replication_group", &self.global_replication_group);
        formatter.finish()
    }
}
/// See [`CreateGlobalReplicationGroupOutput`](crate::output::CreateGlobalReplicationGroupOutput)
pub mod create_global_replication_group_output {
    /// A builder for [`CreateGlobalReplicationGroupOutput`](crate::output::CreateGlobalReplicationGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group:
            std::option::Option<crate::model::GlobalReplicationGroup>,
    }
    impl Builder {
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn global_replication_group(
            mut self,
            input: crate::model::GlobalReplicationGroup,
        ) -> Self {
            self.global_replication_group = Some(input);
            self
        }
        /// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
        /// cluster automatically replicates updates to the secondary cluster.</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
        /// which is what you use to associate a secondary cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_global_replication_group(
            mut self,
            input: std::option::Option<crate::model::GlobalReplicationGroup>,
        ) -> Self {
            self.global_replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGlobalReplicationGroupOutput`](crate::output::CreateGlobalReplicationGroupOutput)
        pub fn build(self) -> crate::output::CreateGlobalReplicationGroupOutput {
            crate::output::CreateGlobalReplicationGroupOutput {
                global_replication_group: self.global_replication_group,
            }
        }
    }
}
impl CreateGlobalReplicationGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateGlobalReplicationGroupOutput`](crate::output::CreateGlobalReplicationGroupOutput)
    pub fn builder() -> crate::output::create_global_replication_group_output::Builder {
        crate::output::create_global_replication_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCacheSubnetGroupOutput {
    /// <p>Represents the output of one of the following operations:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreateCacheSubnetGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ModifyCacheSubnetGroup</code>
    /// </p>
    /// </li>
    /// </ul>
    pub cache_subnet_group: std::option::Option<crate::model::CacheSubnetGroup>,
}
impl CreateCacheSubnetGroupOutput {
    /// <p>Represents the output of one of the following operations:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreateCacheSubnetGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ModifyCacheSubnetGroup</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn cache_subnet_group(&self) -> std::option::Option<&crate::model::CacheSubnetGroup> {
        self.cache_subnet_group.as_ref()
    }
}
impl std::fmt::Debug for CreateCacheSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCacheSubnetGroupOutput");
        formatter.field("cache_subnet_group", &self.cache_subnet_group);
        formatter.finish()
    }
}
/// See [`CreateCacheSubnetGroupOutput`](crate::output::CreateCacheSubnetGroupOutput)
pub mod create_cache_subnet_group_output {
    /// A builder for [`CreateCacheSubnetGroupOutput`](crate::output::CreateCacheSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_subnet_group: std::option::Option<crate::model::CacheSubnetGroup>,
    }
    impl Builder {
        /// <p>Represents the output of one of the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreateCacheSubnetGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ModifyCacheSubnetGroup</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn cache_subnet_group(mut self, input: crate::model::CacheSubnetGroup) -> Self {
            self.cache_subnet_group = Some(input);
            self
        }
        /// <p>Represents the output of one of the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreateCacheSubnetGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ModifyCacheSubnetGroup</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_cache_subnet_group(
            mut self,
            input: std::option::Option<crate::model::CacheSubnetGroup>,
        ) -> Self {
            self.cache_subnet_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCacheSubnetGroupOutput`](crate::output::CreateCacheSubnetGroupOutput)
        pub fn build(self) -> crate::output::CreateCacheSubnetGroupOutput {
            crate::output::CreateCacheSubnetGroupOutput {
                cache_subnet_group: self.cache_subnet_group,
            }
        }
    }
}
impl CreateCacheSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateCacheSubnetGroupOutput`](crate::output::CreateCacheSubnetGroupOutput)
    pub fn builder() -> crate::output::create_cache_subnet_group_output::Builder {
        crate::output::create_cache_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCacheSecurityGroupOutput {
    /// <p>Represents the output of one of the following operations:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AuthorizeCacheSecurityGroupIngress</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreateCacheSecurityGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RevokeCacheSecurityGroupIngress</code>
    /// </p>
    /// </li>
    /// </ul>
    pub cache_security_group: std::option::Option<crate::model::CacheSecurityGroup>,
}
impl CreateCacheSecurityGroupOutput {
    /// <p>Represents the output of one of the following operations:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AuthorizeCacheSecurityGroupIngress</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreateCacheSecurityGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RevokeCacheSecurityGroupIngress</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn cache_security_group(&self) -> std::option::Option<&crate::model::CacheSecurityGroup> {
        self.cache_security_group.as_ref()
    }
}
impl std::fmt::Debug for CreateCacheSecurityGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCacheSecurityGroupOutput");
        formatter.field("cache_security_group", &self.cache_security_group);
        formatter.finish()
    }
}
/// See [`CreateCacheSecurityGroupOutput`](crate::output::CreateCacheSecurityGroupOutput)
pub mod create_cache_security_group_output {
    /// A builder for [`CreateCacheSecurityGroupOutput`](crate::output::CreateCacheSecurityGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_security_group: std::option::Option<crate::model::CacheSecurityGroup>,
    }
    impl Builder {
        /// <p>Represents the output of one of the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AuthorizeCacheSecurityGroupIngress</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreateCacheSecurityGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RevokeCacheSecurityGroupIngress</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn cache_security_group(mut self, input: crate::model::CacheSecurityGroup) -> Self {
            self.cache_security_group = Some(input);
            self
        }
        /// <p>Represents the output of one of the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AuthorizeCacheSecurityGroupIngress</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreateCacheSecurityGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RevokeCacheSecurityGroupIngress</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_cache_security_group(
            mut self,
            input: std::option::Option<crate::model::CacheSecurityGroup>,
        ) -> Self {
            self.cache_security_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCacheSecurityGroupOutput`](crate::output::CreateCacheSecurityGroupOutput)
        pub fn build(self) -> crate::output::CreateCacheSecurityGroupOutput {
            crate::output::CreateCacheSecurityGroupOutput {
                cache_security_group: self.cache_security_group,
            }
        }
    }
}
impl CreateCacheSecurityGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateCacheSecurityGroupOutput`](crate::output::CreateCacheSecurityGroupOutput)
    pub fn builder() -> crate::output::create_cache_security_group_output::Builder {
        crate::output::create_cache_security_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCacheParameterGroupOutput {
    /// <p>Represents the output of a <code>CreateCacheParameterGroup</code> operation.</p>
    pub cache_parameter_group: std::option::Option<crate::model::CacheParameterGroup>,
}
impl CreateCacheParameterGroupOutput {
    /// <p>Represents the output of a <code>CreateCacheParameterGroup</code> operation.</p>
    pub fn cache_parameter_group(&self) -> std::option::Option<&crate::model::CacheParameterGroup> {
        self.cache_parameter_group.as_ref()
    }
}
impl std::fmt::Debug for CreateCacheParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCacheParameterGroupOutput");
        formatter.field("cache_parameter_group", &self.cache_parameter_group);
        formatter.finish()
    }
}
/// See [`CreateCacheParameterGroupOutput`](crate::output::CreateCacheParameterGroupOutput)
pub mod create_cache_parameter_group_output {
    /// A builder for [`CreateCacheParameterGroupOutput`](crate::output::CreateCacheParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_parameter_group: std::option::Option<crate::model::CacheParameterGroup>,
    }
    impl Builder {
        /// <p>Represents the output of a <code>CreateCacheParameterGroup</code> operation.</p>
        pub fn cache_parameter_group(mut self, input: crate::model::CacheParameterGroup) -> Self {
            self.cache_parameter_group = Some(input);
            self
        }
        /// <p>Represents the output of a <code>CreateCacheParameterGroup</code> operation.</p>
        pub fn set_cache_parameter_group(
            mut self,
            input: std::option::Option<crate::model::CacheParameterGroup>,
        ) -> Self {
            self.cache_parameter_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCacheParameterGroupOutput`](crate::output::CreateCacheParameterGroupOutput)
        pub fn build(self) -> crate::output::CreateCacheParameterGroupOutput {
            crate::output::CreateCacheParameterGroupOutput {
                cache_parameter_group: self.cache_parameter_group,
            }
        }
    }
}
impl CreateCacheParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateCacheParameterGroupOutput`](crate::output::CreateCacheParameterGroupOutput)
    pub fn builder() -> crate::output::create_cache_parameter_group_output::Builder {
        crate::output::create_cache_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCacheClusterOutput {
    /// <p>Contains all of the attributes of a specific cluster.</p>
    pub cache_cluster: std::option::Option<crate::model::CacheCluster>,
}
impl CreateCacheClusterOutput {
    /// <p>Contains all of the attributes of a specific cluster.</p>
    pub fn cache_cluster(&self) -> std::option::Option<&crate::model::CacheCluster> {
        self.cache_cluster.as_ref()
    }
}
impl std::fmt::Debug for CreateCacheClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCacheClusterOutput");
        formatter.field("cache_cluster", &self.cache_cluster);
        formatter.finish()
    }
}
/// See [`CreateCacheClusterOutput`](crate::output::CreateCacheClusterOutput)
pub mod create_cache_cluster_output {
    /// A builder for [`CreateCacheClusterOutput`](crate::output::CreateCacheClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster: std::option::Option<crate::model::CacheCluster>,
    }
    impl Builder {
        /// <p>Contains all of the attributes of a specific cluster.</p>
        pub fn cache_cluster(mut self, input: crate::model::CacheCluster) -> Self {
            self.cache_cluster = Some(input);
            self
        }
        /// <p>Contains all of the attributes of a specific cluster.</p>
        pub fn set_cache_cluster(
            mut self,
            input: std::option::Option<crate::model::CacheCluster>,
        ) -> Self {
            self.cache_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCacheClusterOutput`](crate::output::CreateCacheClusterOutput)
        pub fn build(self) -> crate::output::CreateCacheClusterOutput {
            crate::output::CreateCacheClusterOutput {
                cache_cluster: self.cache_cluster,
            }
        }
    }
}
impl CreateCacheClusterOutput {
    /// Creates a new builder-style object to manufacture [`CreateCacheClusterOutput`](crate::output::CreateCacheClusterOutput)
    pub fn builder() -> crate::output::create_cache_cluster_output::Builder {
        crate::output::create_cache_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopySnapshotOutput {
    /// <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
    pub snapshot: std::option::Option<crate::model::Snapshot>,
}
impl CopySnapshotOutput {
    /// <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::Snapshot> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for CopySnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopySnapshotOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`CopySnapshotOutput`](crate::output::CopySnapshotOutput)
pub mod copy_snapshot_output {
    /// A builder for [`CopySnapshotOutput`](crate::output::CopySnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::Snapshot>,
    }
    impl Builder {
        /// <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
        pub fn snapshot(mut self, input: crate::model::Snapshot) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
        pub fn set_snapshot(mut self, input: std::option::Option<crate::model::Snapshot>) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CopySnapshotOutput`](crate::output::CopySnapshotOutput)
        pub fn build(self) -> crate::output::CopySnapshotOutput {
            crate::output::CopySnapshotOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl CopySnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CopySnapshotOutput`](crate::output::CopySnapshotOutput)
    pub fn builder() -> crate::output::copy_snapshot_output::Builder {
        crate::output::copy_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteMigrationOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub replication_group: std::option::Option<crate::model::ReplicationGroup>,
}
impl CompleteMigrationOutput {
    /// <p>Contains all of the attributes of a specific Redis replication group.</p>
    pub fn replication_group(&self) -> std::option::Option<&crate::model::ReplicationGroup> {
        self.replication_group.as_ref()
    }
}
impl std::fmt::Debug for CompleteMigrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteMigrationOutput");
        formatter.field("replication_group", &self.replication_group);
        formatter.finish()
    }
}
/// See [`CompleteMigrationOutput`](crate::output::CompleteMigrationOutput)
pub mod complete_migration_output {
    /// A builder for [`CompleteMigrationOutput`](crate::output::CompleteMigrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group: std::option::Option<crate::model::ReplicationGroup>,
    }
    impl Builder {
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn replication_group(mut self, input: crate::model::ReplicationGroup) -> Self {
            self.replication_group = Some(input);
            self
        }
        /// <p>Contains all of the attributes of a specific Redis replication group.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<crate::model::ReplicationGroup>,
        ) -> Self {
            self.replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteMigrationOutput`](crate::output::CompleteMigrationOutput)
        pub fn build(self) -> crate::output::CompleteMigrationOutput {
            crate::output::CompleteMigrationOutput {
                replication_group: self.replication_group,
            }
        }
    }
}
impl CompleteMigrationOutput {
    /// Creates a new builder-style object to manufacture [`CompleteMigrationOutput`](crate::output::CompleteMigrationOutput)
    pub fn builder() -> crate::output::complete_migration_output::Builder {
        crate::output::complete_migration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchStopUpdateActionOutput {
    /// <p>Update actions that have been processed successfully</p>
    pub processed_update_actions:
        std::option::Option<std::vec::Vec<crate::model::ProcessedUpdateAction>>,
    /// <p>Update actions that haven't been processed successfully</p>
    pub unprocessed_update_actions:
        std::option::Option<std::vec::Vec<crate::model::UnprocessedUpdateAction>>,
}
impl BatchStopUpdateActionOutput {
    /// <p>Update actions that have been processed successfully</p>
    pub fn processed_update_actions(
        &self,
    ) -> std::option::Option<&[crate::model::ProcessedUpdateAction]> {
        self.processed_update_actions.as_deref()
    }
    /// <p>Update actions that haven't been processed successfully</p>
    pub fn unprocessed_update_actions(
        &self,
    ) -> std::option::Option<&[crate::model::UnprocessedUpdateAction]> {
        self.unprocessed_update_actions.as_deref()
    }
}
impl std::fmt::Debug for BatchStopUpdateActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchStopUpdateActionOutput");
        formatter.field("processed_update_actions", &self.processed_update_actions);
        formatter.field(
            "unprocessed_update_actions",
            &self.unprocessed_update_actions,
        );
        formatter.finish()
    }
}
/// See [`BatchStopUpdateActionOutput`](crate::output::BatchStopUpdateActionOutput)
pub mod batch_stop_update_action_output {
    /// A builder for [`BatchStopUpdateActionOutput`](crate::output::BatchStopUpdateActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) processed_update_actions:
            std::option::Option<std::vec::Vec<crate::model::ProcessedUpdateAction>>,
        pub(crate) unprocessed_update_actions:
            std::option::Option<std::vec::Vec<crate::model::UnprocessedUpdateAction>>,
    }
    impl Builder {
        /// Appends an item to `processed_update_actions`.
        ///
        /// To override the contents of this collection use [`set_processed_update_actions`](Self::set_processed_update_actions).
        ///
        /// <p>Update actions that have been processed successfully</p>
        pub fn processed_update_actions(
            mut self,
            input: impl Into<crate::model::ProcessedUpdateAction>,
        ) -> Self {
            let mut v = self.processed_update_actions.unwrap_or_default();
            v.push(input.into());
            self.processed_update_actions = Some(v);
            self
        }
        /// <p>Update actions that have been processed successfully</p>
        pub fn set_processed_update_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessedUpdateAction>>,
        ) -> Self {
            self.processed_update_actions = input;
            self
        }
        /// Appends an item to `unprocessed_update_actions`.
        ///
        /// To override the contents of this collection use [`set_unprocessed_update_actions`](Self::set_unprocessed_update_actions).
        ///
        /// <p>Update actions that haven't been processed successfully</p>
        pub fn unprocessed_update_actions(
            mut self,
            input: impl Into<crate::model::UnprocessedUpdateAction>,
        ) -> Self {
            let mut v = self.unprocessed_update_actions.unwrap_or_default();
            v.push(input.into());
            self.unprocessed_update_actions = Some(v);
            self
        }
        /// <p>Update actions that haven't been processed successfully</p>
        pub fn set_unprocessed_update_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UnprocessedUpdateAction>>,
        ) -> Self {
            self.unprocessed_update_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchStopUpdateActionOutput`](crate::output::BatchStopUpdateActionOutput)
        pub fn build(self) -> crate::output::BatchStopUpdateActionOutput {
            crate::output::BatchStopUpdateActionOutput {
                processed_update_actions: self.processed_update_actions,
                unprocessed_update_actions: self.unprocessed_update_actions,
            }
        }
    }
}
impl BatchStopUpdateActionOutput {
    /// Creates a new builder-style object to manufacture [`BatchStopUpdateActionOutput`](crate::output::BatchStopUpdateActionOutput)
    pub fn builder() -> crate::output::batch_stop_update_action_output::Builder {
        crate::output::batch_stop_update_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchApplyUpdateActionOutput {
    /// <p>Update actions that have been processed successfully</p>
    pub processed_update_actions:
        std::option::Option<std::vec::Vec<crate::model::ProcessedUpdateAction>>,
    /// <p>Update actions that haven't been processed successfully</p>
    pub unprocessed_update_actions:
        std::option::Option<std::vec::Vec<crate::model::UnprocessedUpdateAction>>,
}
impl BatchApplyUpdateActionOutput {
    /// <p>Update actions that have been processed successfully</p>
    pub fn processed_update_actions(
        &self,
    ) -> std::option::Option<&[crate::model::ProcessedUpdateAction]> {
        self.processed_update_actions.as_deref()
    }
    /// <p>Update actions that haven't been processed successfully</p>
    pub fn unprocessed_update_actions(
        &self,
    ) -> std::option::Option<&[crate::model::UnprocessedUpdateAction]> {
        self.unprocessed_update_actions.as_deref()
    }
}
impl std::fmt::Debug for BatchApplyUpdateActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchApplyUpdateActionOutput");
        formatter.field("processed_update_actions", &self.processed_update_actions);
        formatter.field(
            "unprocessed_update_actions",
            &self.unprocessed_update_actions,
        );
        formatter.finish()
    }
}
/// See [`BatchApplyUpdateActionOutput`](crate::output::BatchApplyUpdateActionOutput)
pub mod batch_apply_update_action_output {
    /// A builder for [`BatchApplyUpdateActionOutput`](crate::output::BatchApplyUpdateActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) processed_update_actions:
            std::option::Option<std::vec::Vec<crate::model::ProcessedUpdateAction>>,
        pub(crate) unprocessed_update_actions:
            std::option::Option<std::vec::Vec<crate::model::UnprocessedUpdateAction>>,
    }
    impl Builder {
        /// Appends an item to `processed_update_actions`.
        ///
        /// To override the contents of this collection use [`set_processed_update_actions`](Self::set_processed_update_actions).
        ///
        /// <p>Update actions that have been processed successfully</p>
        pub fn processed_update_actions(
            mut self,
            input: impl Into<crate::model::ProcessedUpdateAction>,
        ) -> Self {
            let mut v = self.processed_update_actions.unwrap_or_default();
            v.push(input.into());
            self.processed_update_actions = Some(v);
            self
        }
        /// <p>Update actions that have been processed successfully</p>
        pub fn set_processed_update_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessedUpdateAction>>,
        ) -> Self {
            self.processed_update_actions = input;
            self
        }
        /// Appends an item to `unprocessed_update_actions`.
        ///
        /// To override the contents of this collection use [`set_unprocessed_update_actions`](Self::set_unprocessed_update_actions).
        ///
        /// <p>Update actions that haven't been processed successfully</p>
        pub fn unprocessed_update_actions(
            mut self,
            input: impl Into<crate::model::UnprocessedUpdateAction>,
        ) -> Self {
            let mut v = self.unprocessed_update_actions.unwrap_or_default();
            v.push(input.into());
            self.unprocessed_update_actions = Some(v);
            self
        }
        /// <p>Update actions that haven't been processed successfully</p>
        pub fn set_unprocessed_update_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UnprocessedUpdateAction>>,
        ) -> Self {
            self.unprocessed_update_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchApplyUpdateActionOutput`](crate::output::BatchApplyUpdateActionOutput)
        pub fn build(self) -> crate::output::BatchApplyUpdateActionOutput {
            crate::output::BatchApplyUpdateActionOutput {
                processed_update_actions: self.processed_update_actions,
                unprocessed_update_actions: self.unprocessed_update_actions,
            }
        }
    }
}
impl BatchApplyUpdateActionOutput {
    /// Creates a new builder-style object to manufacture [`BatchApplyUpdateActionOutput`](crate::output::BatchApplyUpdateActionOutput)
    pub fn builder() -> crate::output::batch_apply_update_action_output::Builder {
        crate::output::batch_apply_update_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizeCacheSecurityGroupIngressOutput {
    /// <p>Represents the output of one of the following operations:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AuthorizeCacheSecurityGroupIngress</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreateCacheSecurityGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RevokeCacheSecurityGroupIngress</code>
    /// </p>
    /// </li>
    /// </ul>
    pub cache_security_group: std::option::Option<crate::model::CacheSecurityGroup>,
}
impl AuthorizeCacheSecurityGroupIngressOutput {
    /// <p>Represents the output of one of the following operations:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AuthorizeCacheSecurityGroupIngress</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreateCacheSecurityGroup</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RevokeCacheSecurityGroupIngress</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn cache_security_group(&self) -> std::option::Option<&crate::model::CacheSecurityGroup> {
        self.cache_security_group.as_ref()
    }
}
impl std::fmt::Debug for AuthorizeCacheSecurityGroupIngressOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizeCacheSecurityGroupIngressOutput");
        formatter.field("cache_security_group", &self.cache_security_group);
        formatter.finish()
    }
}
/// See [`AuthorizeCacheSecurityGroupIngressOutput`](crate::output::AuthorizeCacheSecurityGroupIngressOutput)
pub mod authorize_cache_security_group_ingress_output {
    /// A builder for [`AuthorizeCacheSecurityGroupIngressOutput`](crate::output::AuthorizeCacheSecurityGroupIngressOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_security_group: std::option::Option<crate::model::CacheSecurityGroup>,
    }
    impl Builder {
        /// <p>Represents the output of one of the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AuthorizeCacheSecurityGroupIngress</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreateCacheSecurityGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RevokeCacheSecurityGroupIngress</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn cache_security_group(mut self, input: crate::model::CacheSecurityGroup) -> Self {
            self.cache_security_group = Some(input);
            self
        }
        /// <p>Represents the output of one of the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AuthorizeCacheSecurityGroupIngress</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreateCacheSecurityGroup</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RevokeCacheSecurityGroupIngress</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_cache_security_group(
            mut self,
            input: std::option::Option<crate::model::CacheSecurityGroup>,
        ) -> Self {
            self.cache_security_group = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeCacheSecurityGroupIngressOutput`](crate::output::AuthorizeCacheSecurityGroupIngressOutput)
        pub fn build(self) -> crate::output::AuthorizeCacheSecurityGroupIngressOutput {
            crate::output::AuthorizeCacheSecurityGroupIngressOutput {
                cache_security_group: self.cache_security_group,
            }
        }
    }
}
impl AuthorizeCacheSecurityGroupIngressOutput {
    /// Creates a new builder-style object to manufacture [`AuthorizeCacheSecurityGroupIngressOutput`](crate::output::AuthorizeCacheSecurityGroupIngressOutput)
    pub fn builder() -> crate::output::authorize_cache_security_group_ingress_output::Builder {
        crate::output::authorize_cache_security_group_ingress_output::Builder::default()
    }
}

/// <p>Represents the output from the <code>AddTagsToResource</code>,
/// <code>ListTagsForResource</code>, and <code>RemoveTagsFromResource</code> operations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToResourceOutput {
    /// <p>A list of tags as key-value pairs.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl AddTagsToResourceOutput {
    /// <p>A list of tags as key-value pairs.</p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for AddTagsToResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToResourceOutput");
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
pub mod add_tags_to_resource_output {
    /// A builder for [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of tags as key-value pairs.</p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>A list of tags as key-value pairs.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
        pub fn build(self) -> crate::output::AddTagsToResourceOutput {
            crate::output::AddTagsToResourceOutput {
                tag_list: self.tag_list,
            }
        }
    }
}
impl AddTagsToResourceOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    pub fn builder() -> crate::output::add_tags_to_resource_output::Builder {
        crate::output::add_tags_to_resource_output::Builder::default()
    }
}
