// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains all of the attributes of a specific Redis replication group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationGroup {
    /// <p>The identifier for the replication group.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The user supplied description of the replication group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the Global datastore and role of this replication group in the Global datastore.</p>
    pub global_replication_group_info:
        std::option::Option<crate::model::GlobalReplicationGroupInfo>,
    /// <p>The current state of this replication group -
    /// <code>creating</code>,
    /// <code>available</code>,
    /// <code>modifying</code>,
    /// <code>deleting</code>,
    /// <code>create-failed</code>,
    /// <code>snapshotting</code>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>A group of settings to be applied to the replication group,
    /// either immediately or during the next maintenance window.</p>
    pub pending_modified_values:
        std::option::Option<crate::model::ReplicationGroupPendingModifiedValues>,
    /// <p>The names of all the cache clusters that are part of this replication group.</p>
    pub member_clusters: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of node groups in this replication group.
    /// For Redis (cluster mode disabled) replication groups, this is a single-element list.
    /// For Redis (cluster mode enabled) replication groups, the list contains an entry for each
    /// node group (shard).</p>
    pub node_groups: std::option::Option<std::vec::Vec<crate::model::NodeGroup>>,
    /// <p>The cluster ID that is used as the daily snapshot source for the replication group.</p>
    pub snapshotting_cluster_id: std::option::Option<std::string::String>,
    /// <p>Indicates the status of automatic failover for this Redis replication group.</p>
    pub automatic_failover: std::option::Option<crate::model::AutomaticFailoverStatus>,
    /// <p>A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a>
    /// </p>
    pub multi_az: std::option::Option<crate::model::MultiAzStatus>,
    /// <p>The configuration endpoint for this replication group.
    /// Use the configuration endpoint to connect to this replication group.</p>
    pub configuration_endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before
    /// deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a
    /// snapshot that was taken today is retained for 5 days before being deleted.</p>
    /// <important>
    /// <p>
    /// If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p>
    /// </important>
    pub snapshot_retention_limit: std::option::Option<i32>,
    /// <p>The daily time range (in UTC) during which ElastiCache  begins taking a daily snapshot of your node group (shard).</p>
    /// <p>Example: <code>05:00-09:00</code>
    /// </p>
    /// <p>If you do not specify this parameter, ElastiCache  automatically chooses an appropriate time range.</p>
    /// <note>
    /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
    /// </note>
    pub snapshot_window: std::option::Option<std::string::String>,
    /// <p>A flag indicating whether or not this replication group is cluster enabled;
    /// i.e., whether its data can be partitioned across multiple shards (API/CLI: node groups).</p>
    /// <p>Valid values: <code>true</code> | <code>false</code>
    /// </p>
    pub cluster_enabled: std::option::Option<bool>,
    /// <p>The name of the compute and memory capacity node type for each node in the replication group.</p>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>A flag that enables using an <code>AuthToken</code> (password)
    /// when issuing Redis commands.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub auth_token_enabled: std::option::Option<bool>,
    /// <p>The date the auth token was last modified</p>
    pub auth_token_last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>
    /// <p>You cannot modify the value of <code>TransitEncryptionEnabled</code>
    /// after the cluster is created. To enable in-transit encryption on a cluster
    /// you must set <code>TransitEncryptionEnabled</code> to <code>true</code>
    /// when you create a cluster.</p>
    /// <p>
    /// <b>Required:</b>
    /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub transit_encryption_enabled: std::option::Option<bool>,
    /// <p>A flag that enables encryption at-rest when set to <code>true</code>.</p>
    /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code>
    /// after the cluster is created. To enable encryption at-rest on a cluster
    /// you must set <code>AtRestEncryptionEnabled</code> to <code>true</code>
    /// when you create a cluster.</p>
    /// <p>
    /// <b>Required:</b>
    /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub at_rest_encryption_enabled: std::option::Option<bool>,
    /// <p>The outpost ARNs of the replication group's member clusters.</p>
    pub member_clusters_outpost_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the KMS key used to encrypt the disk in the cluster.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The ARN (Amazon Resource Name) of the replication group.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the user group associated to the replication group.</p>
    pub user_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Returns the destination, format and type of the logs. </p>
    pub log_delivery_configurations:
        std::option::Option<std::vec::Vec<crate::model::LogDeliveryConfiguration>>,
    /// <p>The date and time when the cluster was created.</p>
    pub replication_group_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
    pub data_tiering: std::option::Option<crate::model::DataTieringStatus>,
}
impl ReplicationGroup {
    /// <p>The identifier for the replication group.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The user supplied description of the replication group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the Global datastore and role of this replication group in the Global datastore.</p>
    pub fn global_replication_group_info(
        &self,
    ) -> std::option::Option<&crate::model::GlobalReplicationGroupInfo> {
        self.global_replication_group_info.as_ref()
    }
    /// <p>The current state of this replication group -
    /// <code>creating</code>,
    /// <code>available</code>,
    /// <code>modifying</code>,
    /// <code>deleting</code>,
    /// <code>create-failed</code>,
    /// <code>snapshotting</code>.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>A group of settings to be applied to the replication group,
    /// either immediately or during the next maintenance window.</p>
    pub fn pending_modified_values(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationGroupPendingModifiedValues> {
        self.pending_modified_values.as_ref()
    }
    /// <p>The names of all the cache clusters that are part of this replication group.</p>
    pub fn member_clusters(&self) -> std::option::Option<&[std::string::String]> {
        self.member_clusters.as_deref()
    }
    /// <p>A list of node groups in this replication group.
    /// For Redis (cluster mode disabled) replication groups, this is a single-element list.
    /// For Redis (cluster mode enabled) replication groups, the list contains an entry for each
    /// node group (shard).</p>
    pub fn node_groups(&self) -> std::option::Option<&[crate::model::NodeGroup]> {
        self.node_groups.as_deref()
    }
    /// <p>The cluster ID that is used as the daily snapshot source for the replication group.</p>
    pub fn snapshotting_cluster_id(&self) -> std::option::Option<&str> {
        self.snapshotting_cluster_id.as_deref()
    }
    /// <p>Indicates the status of automatic failover for this Redis replication group.</p>
    pub fn automatic_failover(
        &self,
    ) -> std::option::Option<&crate::model::AutomaticFailoverStatus> {
        self.automatic_failover.as_ref()
    }
    /// <p>A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a>
    /// </p>
    pub fn multi_az(&self) -> std::option::Option<&crate::model::MultiAzStatus> {
        self.multi_az.as_ref()
    }
    /// <p>The configuration endpoint for this replication group.
    /// Use the configuration endpoint to connect to this replication group.</p>
    pub fn configuration_endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.configuration_endpoint.as_ref()
    }
    /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before
    /// deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a
    /// snapshot that was taken today is retained for 5 days before being deleted.</p>
    /// <important>
    /// <p>
    /// If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p>
    /// </important>
    pub fn snapshot_retention_limit(&self) -> std::option::Option<i32> {
        self.snapshot_retention_limit
    }
    /// <p>The daily time range (in UTC) during which ElastiCache  begins taking a daily snapshot of your node group (shard).</p>
    /// <p>Example: <code>05:00-09:00</code>
    /// </p>
    /// <p>If you do not specify this parameter, ElastiCache  automatically chooses an appropriate time range.</p>
    /// <note>
    /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
    /// </note>
    pub fn snapshot_window(&self) -> std::option::Option<&str> {
        self.snapshot_window.as_deref()
    }
    /// <p>A flag indicating whether or not this replication group is cluster enabled;
    /// i.e., whether its data can be partitioned across multiple shards (API/CLI: node groups).</p>
    /// <p>Valid values: <code>true</code> | <code>false</code>
    /// </p>
    pub fn cluster_enabled(&self) -> std::option::Option<bool> {
        self.cluster_enabled
    }
    /// <p>The name of the compute and memory capacity node type for each node in the replication group.</p>
    pub fn cache_node_type(&self) -> std::option::Option<&str> {
        self.cache_node_type.as_deref()
    }
    /// <p>A flag that enables using an <code>AuthToken</code> (password)
    /// when issuing Redis commands.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub fn auth_token_enabled(&self) -> std::option::Option<bool> {
        self.auth_token_enabled
    }
    /// <p>The date the auth token was last modified</p>
    pub fn auth_token_last_modified_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.auth_token_last_modified_date.as_ref()
    }
    /// <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>
    /// <p>You cannot modify the value of <code>TransitEncryptionEnabled</code>
    /// after the cluster is created. To enable in-transit encryption on a cluster
    /// you must set <code>TransitEncryptionEnabled</code> to <code>true</code>
    /// when you create a cluster.</p>
    /// <p>
    /// <b>Required:</b>
    /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub fn transit_encryption_enabled(&self) -> std::option::Option<bool> {
        self.transit_encryption_enabled
    }
    /// <p>A flag that enables encryption at-rest when set to <code>true</code>.</p>
    /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code>
    /// after the cluster is created. To enable encryption at-rest on a cluster
    /// you must set <code>AtRestEncryptionEnabled</code> to <code>true</code>
    /// when you create a cluster.</p>
    /// <p>
    /// <b>Required:</b>
    /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub fn at_rest_encryption_enabled(&self) -> std::option::Option<bool> {
        self.at_rest_encryption_enabled
    }
    /// <p>The outpost ARNs of the replication group's member clusters.</p>
    pub fn member_clusters_outpost_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.member_clusters_outpost_arns.as_deref()
    }
    /// <p>The ID of the KMS key used to encrypt the disk in the cluster.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The ARN (Amazon Resource Name) of the replication group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the user group associated to the replication group.</p>
    pub fn user_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.user_group_ids.as_deref()
    }
    /// <p>Returns the destination, format and type of the logs. </p>
    pub fn log_delivery_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::LogDeliveryConfiguration]> {
        self.log_delivery_configurations.as_deref()
    }
    /// <p>The date and time when the cluster was created.</p>
    pub fn replication_group_create_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.replication_group_create_time.as_ref()
    }
    /// <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
    pub fn data_tiering(&self) -> std::option::Option<&crate::model::DataTieringStatus> {
        self.data_tiering.as_ref()
    }
}
impl std::fmt::Debug for ReplicationGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationGroup");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("description", &self.description);
        formatter.field(
            "global_replication_group_info",
            &self.global_replication_group_info,
        );
        formatter.field("status", &self.status);
        formatter.field("pending_modified_values", &self.pending_modified_values);
        formatter.field("member_clusters", &self.member_clusters);
        formatter.field("node_groups", &self.node_groups);
        formatter.field("snapshotting_cluster_id", &self.snapshotting_cluster_id);
        formatter.field("automatic_failover", &self.automatic_failover);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("configuration_endpoint", &self.configuration_endpoint);
        formatter.field("snapshot_retention_limit", &self.snapshot_retention_limit);
        formatter.field("snapshot_window", &self.snapshot_window);
        formatter.field("cluster_enabled", &self.cluster_enabled);
        formatter.field("cache_node_type", &self.cache_node_type);
        formatter.field("auth_token_enabled", &self.auth_token_enabled);
        formatter.field(
            "auth_token_last_modified_date",
            &self.auth_token_last_modified_date,
        );
        formatter.field(
            "transit_encryption_enabled",
            &self.transit_encryption_enabled,
        );
        formatter.field(
            "at_rest_encryption_enabled",
            &self.at_rest_encryption_enabled,
        );
        formatter.field(
            "member_clusters_outpost_arns",
            &self.member_clusters_outpost_arns,
        );
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("arn", &self.arn);
        formatter.field("user_group_ids", &self.user_group_ids);
        formatter.field(
            "log_delivery_configurations",
            &self.log_delivery_configurations,
        );
        formatter.field(
            "replication_group_create_time",
            &self.replication_group_create_time,
        );
        formatter.field("data_tiering", &self.data_tiering);
        formatter.finish()
    }
}
/// See [`ReplicationGroup`](crate::model::ReplicationGroup)
pub mod replication_group {
    /// A builder for [`ReplicationGroup`](crate::model::ReplicationGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) global_replication_group_info:
            std::option::Option<crate::model::GlobalReplicationGroupInfo>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) pending_modified_values:
            std::option::Option<crate::model::ReplicationGroupPendingModifiedValues>,
        pub(crate) member_clusters: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) node_groups: std::option::Option<std::vec::Vec<crate::model::NodeGroup>>,
        pub(crate) snapshotting_cluster_id: std::option::Option<std::string::String>,
        pub(crate) automatic_failover: std::option::Option<crate::model::AutomaticFailoverStatus>,
        pub(crate) multi_az: std::option::Option<crate::model::MultiAzStatus>,
        pub(crate) configuration_endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) snapshot_retention_limit: std::option::Option<i32>,
        pub(crate) snapshot_window: std::option::Option<std::string::String>,
        pub(crate) cluster_enabled: std::option::Option<bool>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) auth_token_enabled: std::option::Option<bool>,
        pub(crate) auth_token_last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) transit_encryption_enabled: std::option::Option<bool>,
        pub(crate) at_rest_encryption_enabled: std::option::Option<bool>,
        pub(crate) member_clusters_outpost_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) user_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) log_delivery_configurations:
            std::option::Option<std::vec::Vec<crate::model::LogDeliveryConfiguration>>,
        pub(crate) replication_group_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) data_tiering: std::option::Option<crate::model::DataTieringStatus>,
    }
    impl Builder {
        /// <p>The identifier for the replication group.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The identifier for the replication group.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The user supplied description of the replication group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The user supplied description of the replication group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the Global datastore and role of this replication group in the Global datastore.</p>
        pub fn global_replication_group_info(
            mut self,
            input: crate::model::GlobalReplicationGroupInfo,
        ) -> Self {
            self.global_replication_group_info = Some(input);
            self
        }
        /// <p>The name of the Global datastore and role of this replication group in the Global datastore.</p>
        pub fn set_global_replication_group_info(
            mut self,
            input: std::option::Option<crate::model::GlobalReplicationGroupInfo>,
        ) -> Self {
            self.global_replication_group_info = input;
            self
        }
        /// <p>The current state of this replication group -
        /// <code>creating</code>,
        /// <code>available</code>,
        /// <code>modifying</code>,
        /// <code>deleting</code>,
        /// <code>create-failed</code>,
        /// <code>snapshotting</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current state of this replication group -
        /// <code>creating</code>,
        /// <code>available</code>,
        /// <code>modifying</code>,
        /// <code>deleting</code>,
        /// <code>create-failed</code>,
        /// <code>snapshotting</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>A group of settings to be applied to the replication group,
        /// either immediately or during the next maintenance window.</p>
        pub fn pending_modified_values(
            mut self,
            input: crate::model::ReplicationGroupPendingModifiedValues,
        ) -> Self {
            self.pending_modified_values = Some(input);
            self
        }
        /// <p>A group of settings to be applied to the replication group,
        /// either immediately or during the next maintenance window.</p>
        pub fn set_pending_modified_values(
            mut self,
            input: std::option::Option<crate::model::ReplicationGroupPendingModifiedValues>,
        ) -> Self {
            self.pending_modified_values = input;
            self
        }
        /// Appends an item to `member_clusters`.
        ///
        /// To override the contents of this collection use [`set_member_clusters`](Self::set_member_clusters).
        ///
        /// <p>The names of all the cache clusters that are part of this replication group.</p>
        pub fn member_clusters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.member_clusters.unwrap_or_default();
            v.push(input.into());
            self.member_clusters = Some(v);
            self
        }
        /// <p>The names of all the cache clusters that are part of this replication group.</p>
        pub fn set_member_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.member_clusters = input;
            self
        }
        /// Appends an item to `node_groups`.
        ///
        /// To override the contents of this collection use [`set_node_groups`](Self::set_node_groups).
        ///
        /// <p>A list of node groups in this replication group.
        /// For Redis (cluster mode disabled) replication groups, this is a single-element list.
        /// For Redis (cluster mode enabled) replication groups, the list contains an entry for each
        /// node group (shard).</p>
        pub fn node_groups(mut self, input: impl Into<crate::model::NodeGroup>) -> Self {
            let mut v = self.node_groups.unwrap_or_default();
            v.push(input.into());
            self.node_groups = Some(v);
            self
        }
        /// <p>A list of node groups in this replication group.
        /// For Redis (cluster mode disabled) replication groups, this is a single-element list.
        /// For Redis (cluster mode enabled) replication groups, the list contains an entry for each
        /// node group (shard).</p>
        pub fn set_node_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeGroup>>,
        ) -> Self {
            self.node_groups = input;
            self
        }
        /// <p>The cluster ID that is used as the daily snapshot source for the replication group.</p>
        pub fn snapshotting_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshotting_cluster_id = Some(input.into());
            self
        }
        /// <p>The cluster ID that is used as the daily snapshot source for the replication group.</p>
        pub fn set_snapshotting_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshotting_cluster_id = input;
            self
        }
        /// <p>Indicates the status of automatic failover for this Redis replication group.</p>
        pub fn automatic_failover(mut self, input: crate::model::AutomaticFailoverStatus) -> Self {
            self.automatic_failover = Some(input);
            self
        }
        /// <p>Indicates the status of automatic failover for this Redis replication group.</p>
        pub fn set_automatic_failover(
            mut self,
            input: std::option::Option<crate::model::AutomaticFailoverStatus>,
        ) -> Self {
            self.automatic_failover = input;
            self
        }
        /// <p>A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a>
        /// </p>
        pub fn multi_az(mut self, input: crate::model::MultiAzStatus) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a>
        /// </p>
        pub fn set_multi_az(
            mut self,
            input: std::option::Option<crate::model::MultiAzStatus>,
        ) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>The configuration endpoint for this replication group.
        /// Use the configuration endpoint to connect to this replication group.</p>
        pub fn configuration_endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.configuration_endpoint = Some(input);
            self
        }
        /// <p>The configuration endpoint for this replication group.
        /// Use the configuration endpoint to connect to this replication group.</p>
        pub fn set_configuration_endpoint(
            mut self,
            input: std::option::Option<crate::model::Endpoint>,
        ) -> Self {
            self.configuration_endpoint = input;
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before
        /// deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a
        /// snapshot that was taken today is retained for 5 days before being deleted.</p>
        /// <important>
        /// <p>
        /// If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p>
        /// </important>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.snapshot_retention_limit = Some(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before
        /// deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a
        /// snapshot that was taken today is retained for 5 days before being deleted.</p>
        /// <important>
        /// <p>
        /// If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p>
        /// </important>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.snapshot_retention_limit = input;
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache  begins taking a daily snapshot of your node group (shard).</p>
        /// <p>Example: <code>05:00-09:00</code>
        /// </p>
        /// <p>If you do not specify this parameter, ElastiCache  automatically chooses an appropriate time range.</p>
        /// <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_window = Some(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache  begins taking a daily snapshot of your node group (shard).</p>
        /// <p>Example: <code>05:00-09:00</code>
        /// </p>
        /// <p>If you do not specify this parameter, ElastiCache  automatically chooses an appropriate time range.</p>
        /// <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_window = input;
            self
        }
        /// <p>A flag indicating whether or not this replication group is cluster enabled;
        /// i.e., whether its data can be partitioned across multiple shards (API/CLI: node groups).</p>
        /// <p>Valid values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn cluster_enabled(mut self, input: bool) -> Self {
            self.cluster_enabled = Some(input);
            self
        }
        /// <p>A flag indicating whether or not this replication group is cluster enabled;
        /// i.e., whether its data can be partitioned across multiple shards (API/CLI: node groups).</p>
        /// <p>Valid values: <code>true</code> | <code>false</code>
        /// </p>
        pub fn set_cluster_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cluster_enabled = input;
            self
        }
        /// <p>The name of the compute and memory capacity node type for each node in the replication group.</p>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>The name of the compute and memory capacity node type for each node in the replication group.</p>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>A flag that enables using an <code>AuthToken</code> (password)
        /// when issuing Redis commands.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn auth_token_enabled(mut self, input: bool) -> Self {
            self.auth_token_enabled = Some(input);
            self
        }
        /// <p>A flag that enables using an <code>AuthToken</code> (password)
        /// when issuing Redis commands.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_auth_token_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.auth_token_enabled = input;
            self
        }
        /// <p>The date the auth token was last modified</p>
        pub fn auth_token_last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.auth_token_last_modified_date = Some(input);
            self
        }
        /// <p>The date the auth token was last modified</p>
        pub fn set_auth_token_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.auth_token_last_modified_date = input;
            self
        }
        /// <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>TransitEncryptionEnabled</code>
        /// after the cluster is created. To enable in-transit encryption on a cluster
        /// you must set <code>TransitEncryptionEnabled</code> to <code>true</code>
        /// when you create a cluster.</p>
        /// <p>
        /// <b>Required:</b>
        /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn transit_encryption_enabled(mut self, input: bool) -> Self {
            self.transit_encryption_enabled = Some(input);
            self
        }
        /// <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>TransitEncryptionEnabled</code>
        /// after the cluster is created. To enable in-transit encryption on a cluster
        /// you must set <code>TransitEncryptionEnabled</code> to <code>true</code>
        /// when you create a cluster.</p>
        /// <p>
        /// <b>Required:</b>
        /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_transit_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.transit_encryption_enabled = input;
            self
        }
        /// <p>A flag that enables encryption at-rest when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code>
        /// after the cluster is created. To enable encryption at-rest on a cluster
        /// you must set <code>AtRestEncryptionEnabled</code> to <code>true</code>
        /// when you create a cluster.</p>
        /// <p>
        /// <b>Required:</b>
        /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn at_rest_encryption_enabled(mut self, input: bool) -> Self {
            self.at_rest_encryption_enabled = Some(input);
            self
        }
        /// <p>A flag that enables encryption at-rest when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code>
        /// after the cluster is created. To enable encryption at-rest on a cluster
        /// you must set <code>AtRestEncryptionEnabled</code> to <code>true</code>
        /// when you create a cluster.</p>
        /// <p>
        /// <b>Required:</b>
        /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_at_rest_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.at_rest_encryption_enabled = input;
            self
        }
        /// Appends an item to `member_clusters_outpost_arns`.
        ///
        /// To override the contents of this collection use [`set_member_clusters_outpost_arns`](Self::set_member_clusters_outpost_arns).
        ///
        /// <p>The outpost ARNs of the replication group's member clusters.</p>
        pub fn member_clusters_outpost_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.member_clusters_outpost_arns.unwrap_or_default();
            v.push(input.into());
            self.member_clusters_outpost_arns = Some(v);
            self
        }
        /// <p>The outpost ARNs of the replication group's member clusters.</p>
        pub fn set_member_clusters_outpost_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.member_clusters_outpost_arns = input;
            self
        }
        /// <p>The ID of the KMS key used to encrypt the disk in the cluster.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the disk in the cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the replication group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the replication group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `user_group_ids`.
        ///
        /// To override the contents of this collection use [`set_user_group_ids`](Self::set_user_group_ids).
        ///
        /// <p>The ID of the user group associated to the replication group.</p>
        pub fn user_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_group_ids.unwrap_or_default();
            v.push(input.into());
            self.user_group_ids = Some(v);
            self
        }
        /// <p>The ID of the user group associated to the replication group.</p>
        pub fn set_user_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_group_ids = input;
            self
        }
        /// Appends an item to `log_delivery_configurations`.
        ///
        /// To override the contents of this collection use [`set_log_delivery_configurations`](Self::set_log_delivery_configurations).
        ///
        /// <p>Returns the destination, format and type of the logs. </p>
        pub fn log_delivery_configurations(
            mut self,
            input: impl Into<crate::model::LogDeliveryConfiguration>,
        ) -> Self {
            let mut v = self.log_delivery_configurations.unwrap_or_default();
            v.push(input.into());
            self.log_delivery_configurations = Some(v);
            self
        }
        /// <p>Returns the destination, format and type of the logs. </p>
        pub fn set_log_delivery_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LogDeliveryConfiguration>>,
        ) -> Self {
            self.log_delivery_configurations = input;
            self
        }
        /// <p>The date and time when the cluster was created.</p>
        pub fn replication_group_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.replication_group_create_time = Some(input);
            self
        }
        /// <p>The date and time when the cluster was created.</p>
        pub fn set_replication_group_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.replication_group_create_time = input;
            self
        }
        /// <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
        pub fn data_tiering(mut self, input: crate::model::DataTieringStatus) -> Self {
            self.data_tiering = Some(input);
            self
        }
        /// <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
        pub fn set_data_tiering(
            mut self,
            input: std::option::Option<crate::model::DataTieringStatus>,
        ) -> Self {
            self.data_tiering = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationGroup`](crate::model::ReplicationGroup)
        pub fn build(self) -> crate::model::ReplicationGroup {
            crate::model::ReplicationGroup {
                replication_group_id: self.replication_group_id,
                description: self.description,
                global_replication_group_info: self.global_replication_group_info,
                status: self.status,
                pending_modified_values: self.pending_modified_values,
                member_clusters: self.member_clusters,
                node_groups: self.node_groups,
                snapshotting_cluster_id: self.snapshotting_cluster_id,
                automatic_failover: self.automatic_failover,
                multi_az: self.multi_az,
                configuration_endpoint: self.configuration_endpoint,
                snapshot_retention_limit: self.snapshot_retention_limit,
                snapshot_window: self.snapshot_window,
                cluster_enabled: self.cluster_enabled,
                cache_node_type: self.cache_node_type,
                auth_token_enabled: self.auth_token_enabled,
                auth_token_last_modified_date: self.auth_token_last_modified_date,
                transit_encryption_enabled: self.transit_encryption_enabled,
                at_rest_encryption_enabled: self.at_rest_encryption_enabled,
                member_clusters_outpost_arns: self.member_clusters_outpost_arns,
                kms_key_id: self.kms_key_id,
                arn: self.arn,
                user_group_ids: self.user_group_ids,
                log_delivery_configurations: self.log_delivery_configurations,
                replication_group_create_time: self.replication_group_create_time,
                data_tiering: self.data_tiering,
            }
        }
    }
}
impl ReplicationGroup {
    /// Creates a new builder-style object to manufacture [`ReplicationGroup`](crate::model::ReplicationGroup)
    pub fn builder() -> crate::model::replication_group::Builder {
        crate::model::replication_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataTieringStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataTieringStatus {
    fn from(s: &str) -> Self {
        match s {
            "disabled" => DataTieringStatus::Disabled,
            "enabled" => DataTieringStatus::Enabled,
            other => DataTieringStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataTieringStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataTieringStatus::from(s))
    }
}
impl DataTieringStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataTieringStatus::Disabled => "disabled",
            DataTieringStatus::Enabled => "enabled",
            DataTieringStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["disabled", "enabled"]
    }
}
impl AsRef<str> for DataTieringStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns the destination, format and type of the logs. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogDeliveryConfiguration {
    /// <p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.</p>
    pub log_type: std::option::Option<crate::model::LogType>,
    /// <p>Returns the destination type, either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code>.</p>
    pub destination_type: std::option::Option<crate::model::DestinationType>,
    /// <p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>
    pub destination_details: std::option::Option<crate::model::DestinationDetails>,
    /// <p>Returns the log format, either JSON or TEXT.</p>
    pub log_format: std::option::Option<crate::model::LogFormat>,
    /// <p>Returns the log delivery configuration status. Values are one of <code>enabling</code> | <code>disabling</code> | <code>modifying</code> | <code>active</code> | <code>error</code>
    /// </p>
    pub status: std::option::Option<crate::model::LogDeliveryConfigurationStatus>,
    /// <p>Returns an error message for the log delivery configuration.</p>
    pub message: std::option::Option<std::string::String>,
}
impl LogDeliveryConfiguration {
    /// <p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.</p>
    pub fn log_type(&self) -> std::option::Option<&crate::model::LogType> {
        self.log_type.as_ref()
    }
    /// <p>Returns the destination type, either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code>.</p>
    pub fn destination_type(&self) -> std::option::Option<&crate::model::DestinationType> {
        self.destination_type.as_ref()
    }
    /// <p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>
    pub fn destination_details(&self) -> std::option::Option<&crate::model::DestinationDetails> {
        self.destination_details.as_ref()
    }
    /// <p>Returns the log format, either JSON or TEXT.</p>
    pub fn log_format(&self) -> std::option::Option<&crate::model::LogFormat> {
        self.log_format.as_ref()
    }
    /// <p>Returns the log delivery configuration status. Values are one of <code>enabling</code> | <code>disabling</code> | <code>modifying</code> | <code>active</code> | <code>error</code>
    /// </p>
    pub fn status(&self) -> std::option::Option<&crate::model::LogDeliveryConfigurationStatus> {
        self.status.as_ref()
    }
    /// <p>Returns an error message for the log delivery configuration.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for LogDeliveryConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogDeliveryConfiguration");
        formatter.field("log_type", &self.log_type);
        formatter.field("destination_type", &self.destination_type);
        formatter.field("destination_details", &self.destination_details);
        formatter.field("log_format", &self.log_format);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`LogDeliveryConfiguration`](crate::model::LogDeliveryConfiguration)
pub mod log_delivery_configuration {
    /// A builder for [`LogDeliveryConfiguration`](crate::model::LogDeliveryConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_type: std::option::Option<crate::model::LogType>,
        pub(crate) destination_type: std::option::Option<crate::model::DestinationType>,
        pub(crate) destination_details: std::option::Option<crate::model::DestinationDetails>,
        pub(crate) log_format: std::option::Option<crate::model::LogFormat>,
        pub(crate) status: std::option::Option<crate::model::LogDeliveryConfigurationStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.</p>
        pub fn log_type(mut self, input: crate::model::LogType) -> Self {
            self.log_type = Some(input);
            self
        }
        /// <p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.</p>
        pub fn set_log_type(mut self, input: std::option::Option<crate::model::LogType>) -> Self {
            self.log_type = input;
            self
        }
        /// <p>Returns the destination type, either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code>.</p>
        pub fn destination_type(mut self, input: crate::model::DestinationType) -> Self {
            self.destination_type = Some(input);
            self
        }
        /// <p>Returns the destination type, either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code>.</p>
        pub fn set_destination_type(
            mut self,
            input: std::option::Option<crate::model::DestinationType>,
        ) -> Self {
            self.destination_type = input;
            self
        }
        /// <p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>
        pub fn destination_details(mut self, input: crate::model::DestinationDetails) -> Self {
            self.destination_details = Some(input);
            self
        }
        /// <p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>
        pub fn set_destination_details(
            mut self,
            input: std::option::Option<crate::model::DestinationDetails>,
        ) -> Self {
            self.destination_details = input;
            self
        }
        /// <p>Returns the log format, either JSON or TEXT.</p>
        pub fn log_format(mut self, input: crate::model::LogFormat) -> Self {
            self.log_format = Some(input);
            self
        }
        /// <p>Returns the log format, either JSON or TEXT.</p>
        pub fn set_log_format(
            mut self,
            input: std::option::Option<crate::model::LogFormat>,
        ) -> Self {
            self.log_format = input;
            self
        }
        /// <p>Returns the log delivery configuration status. Values are one of <code>enabling</code> | <code>disabling</code> | <code>modifying</code> | <code>active</code> | <code>error</code>
        /// </p>
        pub fn status(mut self, input: crate::model::LogDeliveryConfigurationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Returns the log delivery configuration status. Values are one of <code>enabling</code> | <code>disabling</code> | <code>modifying</code> | <code>active</code> | <code>error</code>
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LogDeliveryConfigurationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Returns an error message for the log delivery configuration.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Returns an error message for the log delivery configuration.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LogDeliveryConfiguration`](crate::model::LogDeliveryConfiguration)
        pub fn build(self) -> crate::model::LogDeliveryConfiguration {
            crate::model::LogDeliveryConfiguration {
                log_type: self.log_type,
                destination_type: self.destination_type,
                destination_details: self.destination_details,
                log_format: self.log_format,
                status: self.status,
                message: self.message,
            }
        }
    }
}
impl LogDeliveryConfiguration {
    /// Creates a new builder-style object to manufacture [`LogDeliveryConfiguration`](crate::model::LogDeliveryConfiguration)
    pub fn builder() -> crate::model::log_delivery_configuration::Builder {
        crate::model::log_delivery_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogDeliveryConfigurationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Disabling,
    #[allow(missing_docs)] // documentation missing in model
    Enabling,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Modifying,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogDeliveryConfigurationStatus {
    fn from(s: &str) -> Self {
        match s {
            "active" => LogDeliveryConfigurationStatus::Active,
            "disabling" => LogDeliveryConfigurationStatus::Disabling,
            "enabling" => LogDeliveryConfigurationStatus::Enabling,
            "error" => LogDeliveryConfigurationStatus::Error,
            "modifying" => LogDeliveryConfigurationStatus::Modifying,
            other => LogDeliveryConfigurationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogDeliveryConfigurationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogDeliveryConfigurationStatus::from(s))
    }
}
impl LogDeliveryConfigurationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogDeliveryConfigurationStatus::Active => "active",
            LogDeliveryConfigurationStatus::Disabling => "disabling",
            LogDeliveryConfigurationStatus::Enabling => "enabling",
            LogDeliveryConfigurationStatus::Error => "error",
            LogDeliveryConfigurationStatus::Modifying => "modifying",
            LogDeliveryConfigurationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["active", "disabling", "enabling", "error", "modifying"]
    }
}
impl AsRef<str> for LogDeliveryConfigurationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogFormat {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Text,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogFormat {
    fn from(s: &str) -> Self {
        match s {
            "json" => LogFormat::Json,
            "text" => LogFormat::Text,
            other => LogFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogFormat::from(s))
    }
}
impl LogFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogFormat::Json => "json",
            LogFormat::Text => "text",
            LogFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["json", "text"]
    }
}
impl AsRef<str> for LogFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationDetails {
    /// <p>The configuration details of the CloudWatch Logs destination.</p>
    pub cloud_watch_logs_details:
        std::option::Option<crate::model::CloudWatchLogsDestinationDetails>,
    /// <p>The configuration details of the Kinesis Data Firehose destination.</p>
    pub kinesis_firehose_details:
        std::option::Option<crate::model::KinesisFirehoseDestinationDetails>,
}
impl DestinationDetails {
    /// <p>The configuration details of the CloudWatch Logs destination.</p>
    pub fn cloud_watch_logs_details(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsDestinationDetails> {
        self.cloud_watch_logs_details.as_ref()
    }
    /// <p>The configuration details of the Kinesis Data Firehose destination.</p>
    pub fn kinesis_firehose_details(
        &self,
    ) -> std::option::Option<&crate::model::KinesisFirehoseDestinationDetails> {
        self.kinesis_firehose_details.as_ref()
    }
}
impl std::fmt::Debug for DestinationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationDetails");
        formatter.field("cloud_watch_logs_details", &self.cloud_watch_logs_details);
        formatter.field("kinesis_firehose_details", &self.kinesis_firehose_details);
        formatter.finish()
    }
}
/// See [`DestinationDetails`](crate::model::DestinationDetails)
pub mod destination_details {
    /// A builder for [`DestinationDetails`](crate::model::DestinationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_logs_details:
            std::option::Option<crate::model::CloudWatchLogsDestinationDetails>,
        pub(crate) kinesis_firehose_details:
            std::option::Option<crate::model::KinesisFirehoseDestinationDetails>,
    }
    impl Builder {
        /// <p>The configuration details of the CloudWatch Logs destination.</p>
        pub fn cloud_watch_logs_details(
            mut self,
            input: crate::model::CloudWatchLogsDestinationDetails,
        ) -> Self {
            self.cloud_watch_logs_details = Some(input);
            self
        }
        /// <p>The configuration details of the CloudWatch Logs destination.</p>
        pub fn set_cloud_watch_logs_details(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsDestinationDetails>,
        ) -> Self {
            self.cloud_watch_logs_details = input;
            self
        }
        /// <p>The configuration details of the Kinesis Data Firehose destination.</p>
        pub fn kinesis_firehose_details(
            mut self,
            input: crate::model::KinesisFirehoseDestinationDetails,
        ) -> Self {
            self.kinesis_firehose_details = Some(input);
            self
        }
        /// <p>The configuration details of the Kinesis Data Firehose destination.</p>
        pub fn set_kinesis_firehose_details(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseDestinationDetails>,
        ) -> Self {
            self.kinesis_firehose_details = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationDetails`](crate::model::DestinationDetails)
        pub fn build(self) -> crate::model::DestinationDetails {
            crate::model::DestinationDetails {
                cloud_watch_logs_details: self.cloud_watch_logs_details,
                kinesis_firehose_details: self.kinesis_firehose_details,
            }
        }
    }
}
impl DestinationDetails {
    /// Creates a new builder-style object to manufacture [`DestinationDetails`](crate::model::DestinationDetails)
    pub fn builder() -> crate::model::destination_details::Builder {
        crate::model::destination_details::Builder::default()
    }
}

/// <p>The configuration details of the Kinesis Data Firehose destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisFirehoseDestinationDetails {
    /// <p>The name of the Kinesis Data Firehose delivery stream.</p>
    pub delivery_stream: std::option::Option<std::string::String>,
}
impl KinesisFirehoseDestinationDetails {
    /// <p>The name of the Kinesis Data Firehose delivery stream.</p>
    pub fn delivery_stream(&self) -> std::option::Option<&str> {
        self.delivery_stream.as_deref()
    }
}
impl std::fmt::Debug for KinesisFirehoseDestinationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisFirehoseDestinationDetails");
        formatter.field("delivery_stream", &self.delivery_stream);
        formatter.finish()
    }
}
/// See [`KinesisFirehoseDestinationDetails`](crate::model::KinesisFirehoseDestinationDetails)
pub mod kinesis_firehose_destination_details {
    /// A builder for [`KinesisFirehoseDestinationDetails`](crate::model::KinesisFirehoseDestinationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Kinesis Data Firehose delivery stream.</p>
        pub fn delivery_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream = Some(input.into());
            self
        }
        /// <p>The name of the Kinesis Data Firehose delivery stream.</p>
        pub fn set_delivery_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisFirehoseDestinationDetails`](crate::model::KinesisFirehoseDestinationDetails)
        pub fn build(self) -> crate::model::KinesisFirehoseDestinationDetails {
            crate::model::KinesisFirehoseDestinationDetails {
                delivery_stream: self.delivery_stream,
            }
        }
    }
}
impl KinesisFirehoseDestinationDetails {
    /// Creates a new builder-style object to manufacture [`KinesisFirehoseDestinationDetails`](crate::model::KinesisFirehoseDestinationDetails)
    pub fn builder() -> crate::model::kinesis_firehose_destination_details::Builder {
        crate::model::kinesis_firehose_destination_details::Builder::default()
    }
}

/// <p>The configuration details of the CloudWatch Logs destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLogsDestinationDetails {
    /// <p>The name of the CloudWatch Logs log group.</p>
    pub log_group: std::option::Option<std::string::String>,
}
impl CloudWatchLogsDestinationDetails {
    /// <p>The name of the CloudWatch Logs log group.</p>
    pub fn log_group(&self) -> std::option::Option<&str> {
        self.log_group.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchLogsDestinationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLogsDestinationDetails");
        formatter.field("log_group", &self.log_group);
        formatter.finish()
    }
}
/// See [`CloudWatchLogsDestinationDetails`](crate::model::CloudWatchLogsDestinationDetails)
pub mod cloud_watch_logs_destination_details {
    /// A builder for [`CloudWatchLogsDestinationDetails`](crate::model::CloudWatchLogsDestinationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the CloudWatch Logs log group.</p>
        pub fn log_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch Logs log group.</p>
        pub fn set_log_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLogsDestinationDetails`](crate::model::CloudWatchLogsDestinationDetails)
        pub fn build(self) -> crate::model::CloudWatchLogsDestinationDetails {
            crate::model::CloudWatchLogsDestinationDetails {
                log_group: self.log_group,
            }
        }
    }
}
impl CloudWatchLogsDestinationDetails {
    /// Creates a new builder-style object to manufacture [`CloudWatchLogsDestinationDetails`](crate::model::CloudWatchLogsDestinationDetails)
    pub fn builder() -> crate::model::cloud_watch_logs_destination_details::Builder {
        crate::model::cloud_watch_logs_destination_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DestinationType {
    #[allow(missing_docs)] // documentation missing in model
    CloudWatchLogs,
    #[allow(missing_docs)] // documentation missing in model
    KinesisFirehose,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DestinationType {
    fn from(s: &str) -> Self {
        match s {
            "cloudwatch-logs" => DestinationType::CloudWatchLogs,
            "kinesis-firehose" => DestinationType::KinesisFirehose,
            other => DestinationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DestinationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DestinationType::from(s))
    }
}
impl DestinationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DestinationType::CloudWatchLogs => "cloudwatch-logs",
            DestinationType::KinesisFirehose => "kinesis-firehose",
            DestinationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["cloudwatch-logs", "kinesis-firehose"]
    }
}
impl AsRef<str> for DestinationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogType {
    #[allow(missing_docs)] // documentation missing in model
    SlowLog,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogType {
    fn from(s: &str) -> Self {
        match s {
            "slow-log" => LogType::SlowLog,
            other => LogType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogType::from(s))
    }
}
impl LogType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogType::SlowLog => "slow-log",
            LogType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["slow-log"]
    }
}
impl AsRef<str> for LogType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the information required for client programs to connect to a cache node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Endpoint {
    /// <p>The DNS hostname of the cache node.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The port number that the cache engine is listening on.</p>
    pub port: i32,
}
impl Endpoint {
    /// <p>The DNS hostname of the cache node.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The port number that the cache engine is listening on.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
}
impl std::fmt::Debug for Endpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Endpoint");
        formatter.field("address", &self.address);
        formatter.field("port", &self.port);
        formatter.finish()
    }
}
/// See [`Endpoint`](crate::model::Endpoint)
pub mod endpoint {
    /// A builder for [`Endpoint`](crate::model::Endpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The DNS hostname of the cache node.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The DNS hostname of the cache node.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The port number that the cache engine is listening on.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number that the cache engine is listening on.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`Endpoint`](crate::model::Endpoint)
        pub fn build(self) -> crate::model::Endpoint {
            crate::model::Endpoint {
                address: self.address,
                port: self.port.unwrap_or_default(),
            }
        }
    }
}
impl Endpoint {
    /// Creates a new builder-style object to manufacture [`Endpoint`](crate::model::Endpoint)
    pub fn builder() -> crate::model::endpoint::Builder {
        crate::model::endpoint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MultiAzStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MultiAzStatus {
    fn from(s: &str) -> Self {
        match s {
            "disabled" => MultiAzStatus::Disabled,
            "enabled" => MultiAzStatus::Enabled,
            other => MultiAzStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MultiAzStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MultiAzStatus::from(s))
    }
}
impl MultiAzStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MultiAzStatus::Disabled => "disabled",
            MultiAzStatus::Enabled => "enabled",
            MultiAzStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["disabled", "enabled"]
    }
}
impl AsRef<str> for MultiAzStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutomaticFailoverStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Disabling,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutomaticFailoverStatus {
    fn from(s: &str) -> Self {
        match s {
            "disabled" => AutomaticFailoverStatus::Disabled,
            "disabling" => AutomaticFailoverStatus::Disabling,
            "enabled" => AutomaticFailoverStatus::Enabled,
            "enabling" => AutomaticFailoverStatus::Enabling,
            other => AutomaticFailoverStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutomaticFailoverStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutomaticFailoverStatus::from(s))
    }
}
impl AutomaticFailoverStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutomaticFailoverStatus::Disabled => "disabled",
            AutomaticFailoverStatus::Disabling => "disabling",
            AutomaticFailoverStatus::Enabled => "enabled",
            AutomaticFailoverStatus::Enabling => "enabling",
            AutomaticFailoverStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["disabled", "disabling", "enabled", "enabling"]
    }
}
impl AsRef<str> for AutomaticFailoverStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a collection of cache nodes in a replication group.
/// One node in the node group is the read/write primary node.
/// All the other nodes are read-only Replica nodes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeGroup {
    /// <p>The identifier for the node group (shard). A Redis (cluster mode disabled) replication group contains only 1 node group; therefore, the node group ID is 0001.
    /// A Redis (cluster mode enabled) replication group contains 1 to 90 node groups numbered 0001 to 0090. Optionally, the user can provide the id for
    /// a node group. </p>
    pub node_group_id: std::option::Option<std::string::String>,
    /// <p>The current state of this replication group - <code>creating</code>,
    /// <code>available</code>, <code>modifying</code>, <code>deleting</code>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The endpoint of the primary node in this node group (shard).</p>
    pub primary_endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>The endpoint of the replica nodes in this node group (shard).</p>
    pub reader_endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>The keyspace for this node group (shard).</p>
    pub slots: std::option::Option<std::string::String>,
    /// <p>A list containing information about individual nodes within the node group (shard).</p>
    pub node_group_members: std::option::Option<std::vec::Vec<crate::model::NodeGroupMember>>,
}
impl NodeGroup {
    /// <p>The identifier for the node group (shard). A Redis (cluster mode disabled) replication group contains only 1 node group; therefore, the node group ID is 0001.
    /// A Redis (cluster mode enabled) replication group contains 1 to 90 node groups numbered 0001 to 0090. Optionally, the user can provide the id for
    /// a node group. </p>
    pub fn node_group_id(&self) -> std::option::Option<&str> {
        self.node_group_id.as_deref()
    }
    /// <p>The current state of this replication group - <code>creating</code>,
    /// <code>available</code>, <code>modifying</code>, <code>deleting</code>.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The endpoint of the primary node in this node group (shard).</p>
    pub fn primary_endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.primary_endpoint.as_ref()
    }
    /// <p>The endpoint of the replica nodes in this node group (shard).</p>
    pub fn reader_endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.reader_endpoint.as_ref()
    }
    /// <p>The keyspace for this node group (shard).</p>
    pub fn slots(&self) -> std::option::Option<&str> {
        self.slots.as_deref()
    }
    /// <p>A list containing information about individual nodes within the node group (shard).</p>
    pub fn node_group_members(&self) -> std::option::Option<&[crate::model::NodeGroupMember]> {
        self.node_group_members.as_deref()
    }
}
impl std::fmt::Debug for NodeGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeGroup");
        formatter.field("node_group_id", &self.node_group_id);
        formatter.field("status", &self.status);
        formatter.field("primary_endpoint", &self.primary_endpoint);
        formatter.field("reader_endpoint", &self.reader_endpoint);
        formatter.field("slots", &self.slots);
        formatter.field("node_group_members", &self.node_group_members);
        formatter.finish()
    }
}
/// See [`NodeGroup`](crate::model::NodeGroup)
pub mod node_group {
    /// A builder for [`NodeGroup`](crate::model::NodeGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_group_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) primary_endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) reader_endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) slots: std::option::Option<std::string::String>,
        pub(crate) node_group_members:
            std::option::Option<std::vec::Vec<crate::model::NodeGroupMember>>,
    }
    impl Builder {
        /// <p>The identifier for the node group (shard). A Redis (cluster mode disabled) replication group contains only 1 node group; therefore, the node group ID is 0001.
        /// A Redis (cluster mode enabled) replication group contains 1 to 90 node groups numbered 0001 to 0090. Optionally, the user can provide the id for
        /// a node group. </p>
        pub fn node_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_group_id = Some(input.into());
            self
        }
        /// <p>The identifier for the node group (shard). A Redis (cluster mode disabled) replication group contains only 1 node group; therefore, the node group ID is 0001.
        /// A Redis (cluster mode enabled) replication group contains 1 to 90 node groups numbered 0001 to 0090. Optionally, the user can provide the id for
        /// a node group. </p>
        pub fn set_node_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.node_group_id = input;
            self
        }
        /// <p>The current state of this replication group - <code>creating</code>,
        /// <code>available</code>, <code>modifying</code>, <code>deleting</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current state of this replication group - <code>creating</code>,
        /// <code>available</code>, <code>modifying</code>, <code>deleting</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The endpoint of the primary node in this node group (shard).</p>
        pub fn primary_endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.primary_endpoint = Some(input);
            self
        }
        /// <p>The endpoint of the primary node in this node group (shard).</p>
        pub fn set_primary_endpoint(
            mut self,
            input: std::option::Option<crate::model::Endpoint>,
        ) -> Self {
            self.primary_endpoint = input;
            self
        }
        /// <p>The endpoint of the replica nodes in this node group (shard).</p>
        pub fn reader_endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.reader_endpoint = Some(input);
            self
        }
        /// <p>The endpoint of the replica nodes in this node group (shard).</p>
        pub fn set_reader_endpoint(
            mut self,
            input: std::option::Option<crate::model::Endpoint>,
        ) -> Self {
            self.reader_endpoint = input;
            self
        }
        /// <p>The keyspace for this node group (shard).</p>
        pub fn slots(mut self, input: impl Into<std::string::String>) -> Self {
            self.slots = Some(input.into());
            self
        }
        /// <p>The keyspace for this node group (shard).</p>
        pub fn set_slots(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slots = input;
            self
        }
        /// Appends an item to `node_group_members`.
        ///
        /// To override the contents of this collection use [`set_node_group_members`](Self::set_node_group_members).
        ///
        /// <p>A list containing information about individual nodes within the node group (shard).</p>
        pub fn node_group_members(
            mut self,
            input: impl Into<crate::model::NodeGroupMember>,
        ) -> Self {
            let mut v = self.node_group_members.unwrap_or_default();
            v.push(input.into());
            self.node_group_members = Some(v);
            self
        }
        /// <p>A list containing information about individual nodes within the node group (shard).</p>
        pub fn set_node_group_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeGroupMember>>,
        ) -> Self {
            self.node_group_members = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeGroup`](crate::model::NodeGroup)
        pub fn build(self) -> crate::model::NodeGroup {
            crate::model::NodeGroup {
                node_group_id: self.node_group_id,
                status: self.status,
                primary_endpoint: self.primary_endpoint,
                reader_endpoint: self.reader_endpoint,
                slots: self.slots,
                node_group_members: self.node_group_members,
            }
        }
    }
}
impl NodeGroup {
    /// Creates a new builder-style object to manufacture [`NodeGroup`](crate::model::NodeGroup)
    pub fn builder() -> crate::model::node_group::Builder {
        crate::model::node_group::Builder::default()
    }
}

/// <p>Represents a single node within a node group (shard).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeGroupMember {
    /// <p>The ID of the cluster to which the node belongs.</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>The ID of the node within its cluster. A node ID is a numeric identifier (0001, 0002, etc.).</p>
    pub cache_node_id: std::option::Option<std::string::String>,
    /// <p>The information required for client programs to connect to a node for read operations.
    /// The read endpoint is only applicable on Redis (cluster mode disabled) clusters.</p>
    pub read_endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>The name of the Availability Zone in which the node is located.</p>
    pub preferred_availability_zone: std::option::Option<std::string::String>,
    /// <p>The outpost ARN of the node group member.</p>
    pub preferred_outpost_arn: std::option::Option<std::string::String>,
    /// <p>The role that is currently assigned to the node - <code>primary</code> or
    /// <code>replica</code>. This member is only applicable for Redis (cluster mode disabled)
    /// replication groups.</p>
    pub current_role: std::option::Option<std::string::String>,
}
impl NodeGroupMember {
    /// <p>The ID of the cluster to which the node belongs.</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>The ID of the node within its cluster. A node ID is a numeric identifier (0001, 0002, etc.).</p>
    pub fn cache_node_id(&self) -> std::option::Option<&str> {
        self.cache_node_id.as_deref()
    }
    /// <p>The information required for client programs to connect to a node for read operations.
    /// The read endpoint is only applicable on Redis (cluster mode disabled) clusters.</p>
    pub fn read_endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.read_endpoint.as_ref()
    }
    /// <p>The name of the Availability Zone in which the node is located.</p>
    pub fn preferred_availability_zone(&self) -> std::option::Option<&str> {
        self.preferred_availability_zone.as_deref()
    }
    /// <p>The outpost ARN of the node group member.</p>
    pub fn preferred_outpost_arn(&self) -> std::option::Option<&str> {
        self.preferred_outpost_arn.as_deref()
    }
    /// <p>The role that is currently assigned to the node - <code>primary</code> or
    /// <code>replica</code>. This member is only applicable for Redis (cluster mode disabled)
    /// replication groups.</p>
    pub fn current_role(&self) -> std::option::Option<&str> {
        self.current_role.as_deref()
    }
}
impl std::fmt::Debug for NodeGroupMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeGroupMember");
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("cache_node_id", &self.cache_node_id);
        formatter.field("read_endpoint", &self.read_endpoint);
        formatter.field(
            "preferred_availability_zone",
            &self.preferred_availability_zone,
        );
        formatter.field("preferred_outpost_arn", &self.preferred_outpost_arn);
        formatter.field("current_role", &self.current_role);
        formatter.finish()
    }
}
/// See [`NodeGroupMember`](crate::model::NodeGroupMember)
pub mod node_group_member {
    /// A builder for [`NodeGroupMember`](crate::model::NodeGroupMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) cache_node_id: std::option::Option<std::string::String>,
        pub(crate) read_endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) preferred_availability_zone: std::option::Option<std::string::String>,
        pub(crate) preferred_outpost_arn: std::option::Option<std::string::String>,
        pub(crate) current_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the cluster to which the node belongs.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the cluster to which the node belongs.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>The ID of the node within its cluster. A node ID is a numeric identifier (0001, 0002, etc.).</p>
        pub fn cache_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_id = Some(input.into());
            self
        }
        /// <p>The ID of the node within its cluster. A node ID is a numeric identifier (0001, 0002, etc.).</p>
        pub fn set_cache_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_id = input;
            self
        }
        /// <p>The information required for client programs to connect to a node for read operations.
        /// The read endpoint is only applicable on Redis (cluster mode disabled) clusters.</p>
        pub fn read_endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.read_endpoint = Some(input);
            self
        }
        /// <p>The information required for client programs to connect to a node for read operations.
        /// The read endpoint is only applicable on Redis (cluster mode disabled) clusters.</p>
        pub fn set_read_endpoint(
            mut self,
            input: std::option::Option<crate::model::Endpoint>,
        ) -> Self {
            self.read_endpoint = input;
            self
        }
        /// <p>The name of the Availability Zone in which the node is located.</p>
        pub fn preferred_availability_zone(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_availability_zone = Some(input.into());
            self
        }
        /// <p>The name of the Availability Zone in which the node is located.</p>
        pub fn set_preferred_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_availability_zone = input;
            self
        }
        /// <p>The outpost ARN of the node group member.</p>
        pub fn preferred_outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_outpost_arn = Some(input.into());
            self
        }
        /// <p>The outpost ARN of the node group member.</p>
        pub fn set_preferred_outpost_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_outpost_arn = input;
            self
        }
        /// <p>The role that is currently assigned to the node - <code>primary</code> or
        /// <code>replica</code>. This member is only applicable for Redis (cluster mode disabled)
        /// replication groups.</p>
        pub fn current_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_role = Some(input.into());
            self
        }
        /// <p>The role that is currently assigned to the node - <code>primary</code> or
        /// <code>replica</code>. This member is only applicable for Redis (cluster mode disabled)
        /// replication groups.</p>
        pub fn set_current_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.current_role = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeGroupMember`](crate::model::NodeGroupMember)
        pub fn build(self) -> crate::model::NodeGroupMember {
            crate::model::NodeGroupMember {
                cache_cluster_id: self.cache_cluster_id,
                cache_node_id: self.cache_node_id,
                read_endpoint: self.read_endpoint,
                preferred_availability_zone: self.preferred_availability_zone,
                preferred_outpost_arn: self.preferred_outpost_arn,
                current_role: self.current_role,
            }
        }
    }
}
impl NodeGroupMember {
    /// Creates a new builder-style object to manufacture [`NodeGroupMember`](crate::model::NodeGroupMember)
    pub fn builder() -> crate::model::node_group_member::Builder {
        crate::model::node_group_member::Builder::default()
    }
}

/// <p>The settings to be applied to the Redis replication group,
/// either immediately or during the next maintenance window.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationGroupPendingModifiedValues {
    /// <p>The primary cluster ID that is applied immediately (if <code>--apply-immediately</code>
    /// was specified), or during the next maintenance window.</p>
    pub primary_cluster_id: std::option::Option<std::string::String>,
    /// <p>Indicates the status of automatic failover for this Redis replication group.</p>
    pub automatic_failover_status:
        std::option::Option<crate::model::PendingAutomaticFailoverStatus>,
    /// <p>The status of an online resharding operation.</p>
    pub resharding: std::option::Option<crate::model::ReshardingStatus>,
    /// <p>The auth token status</p>
    pub auth_token_status: std::option::Option<crate::model::AuthTokenUpdateStatus>,
    /// <p>The user group being modified.</p>
    pub user_groups: std::option::Option<crate::model::UserGroupsUpdateStatus>,
    /// <p>The log delivery configurations being modified </p>
    pub log_delivery_configurations:
        std::option::Option<std::vec::Vec<crate::model::PendingLogDeliveryConfiguration>>,
}
impl ReplicationGroupPendingModifiedValues {
    /// <p>The primary cluster ID that is applied immediately (if <code>--apply-immediately</code>
    /// was specified), or during the next maintenance window.</p>
    pub fn primary_cluster_id(&self) -> std::option::Option<&str> {
        self.primary_cluster_id.as_deref()
    }
    /// <p>Indicates the status of automatic failover for this Redis replication group.</p>
    pub fn automatic_failover_status(
        &self,
    ) -> std::option::Option<&crate::model::PendingAutomaticFailoverStatus> {
        self.automatic_failover_status.as_ref()
    }
    /// <p>The status of an online resharding operation.</p>
    pub fn resharding(&self) -> std::option::Option<&crate::model::ReshardingStatus> {
        self.resharding.as_ref()
    }
    /// <p>The auth token status</p>
    pub fn auth_token_status(&self) -> std::option::Option<&crate::model::AuthTokenUpdateStatus> {
        self.auth_token_status.as_ref()
    }
    /// <p>The user group being modified.</p>
    pub fn user_groups(&self) -> std::option::Option<&crate::model::UserGroupsUpdateStatus> {
        self.user_groups.as_ref()
    }
    /// <p>The log delivery configurations being modified </p>
    pub fn log_delivery_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::PendingLogDeliveryConfiguration]> {
        self.log_delivery_configurations.as_deref()
    }
}
impl std::fmt::Debug for ReplicationGroupPendingModifiedValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationGroupPendingModifiedValues");
        formatter.field("primary_cluster_id", &self.primary_cluster_id);
        formatter.field("automatic_failover_status", &self.automatic_failover_status);
        formatter.field("resharding", &self.resharding);
        formatter.field("auth_token_status", &self.auth_token_status);
        formatter.field("user_groups", &self.user_groups);
        formatter.field(
            "log_delivery_configurations",
            &self.log_delivery_configurations,
        );
        formatter.finish()
    }
}
/// See [`ReplicationGroupPendingModifiedValues`](crate::model::ReplicationGroupPendingModifiedValues)
pub mod replication_group_pending_modified_values {
    /// A builder for [`ReplicationGroupPendingModifiedValues`](crate::model::ReplicationGroupPendingModifiedValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) primary_cluster_id: std::option::Option<std::string::String>,
        pub(crate) automatic_failover_status:
            std::option::Option<crate::model::PendingAutomaticFailoverStatus>,
        pub(crate) resharding: std::option::Option<crate::model::ReshardingStatus>,
        pub(crate) auth_token_status: std::option::Option<crate::model::AuthTokenUpdateStatus>,
        pub(crate) user_groups: std::option::Option<crate::model::UserGroupsUpdateStatus>,
        pub(crate) log_delivery_configurations:
            std::option::Option<std::vec::Vec<crate::model::PendingLogDeliveryConfiguration>>,
    }
    impl Builder {
        /// <p>The primary cluster ID that is applied immediately (if <code>--apply-immediately</code>
        /// was specified), or during the next maintenance window.</p>
        pub fn primary_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_cluster_id = Some(input.into());
            self
        }
        /// <p>The primary cluster ID that is applied immediately (if <code>--apply-immediately</code>
        /// was specified), or during the next maintenance window.</p>
        pub fn set_primary_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_cluster_id = input;
            self
        }
        /// <p>Indicates the status of automatic failover for this Redis replication group.</p>
        pub fn automatic_failover_status(
            mut self,
            input: crate::model::PendingAutomaticFailoverStatus,
        ) -> Self {
            self.automatic_failover_status = Some(input);
            self
        }
        /// <p>Indicates the status of automatic failover for this Redis replication group.</p>
        pub fn set_automatic_failover_status(
            mut self,
            input: std::option::Option<crate::model::PendingAutomaticFailoverStatus>,
        ) -> Self {
            self.automatic_failover_status = input;
            self
        }
        /// <p>The status of an online resharding operation.</p>
        pub fn resharding(mut self, input: crate::model::ReshardingStatus) -> Self {
            self.resharding = Some(input);
            self
        }
        /// <p>The status of an online resharding operation.</p>
        pub fn set_resharding(
            mut self,
            input: std::option::Option<crate::model::ReshardingStatus>,
        ) -> Self {
            self.resharding = input;
            self
        }
        /// <p>The auth token status</p>
        pub fn auth_token_status(mut self, input: crate::model::AuthTokenUpdateStatus) -> Self {
            self.auth_token_status = Some(input);
            self
        }
        /// <p>The auth token status</p>
        pub fn set_auth_token_status(
            mut self,
            input: std::option::Option<crate::model::AuthTokenUpdateStatus>,
        ) -> Self {
            self.auth_token_status = input;
            self
        }
        /// <p>The user group being modified.</p>
        pub fn user_groups(mut self, input: crate::model::UserGroupsUpdateStatus) -> Self {
            self.user_groups = Some(input);
            self
        }
        /// <p>The user group being modified.</p>
        pub fn set_user_groups(
            mut self,
            input: std::option::Option<crate::model::UserGroupsUpdateStatus>,
        ) -> Self {
            self.user_groups = input;
            self
        }
        /// Appends an item to `log_delivery_configurations`.
        ///
        /// To override the contents of this collection use [`set_log_delivery_configurations`](Self::set_log_delivery_configurations).
        ///
        /// <p>The log delivery configurations being modified </p>
        pub fn log_delivery_configurations(
            mut self,
            input: impl Into<crate::model::PendingLogDeliveryConfiguration>,
        ) -> Self {
            let mut v = self.log_delivery_configurations.unwrap_or_default();
            v.push(input.into());
            self.log_delivery_configurations = Some(v);
            self
        }
        /// <p>The log delivery configurations being modified </p>
        pub fn set_log_delivery_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::PendingLogDeliveryConfiguration>,
            >,
        ) -> Self {
            self.log_delivery_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationGroupPendingModifiedValues`](crate::model::ReplicationGroupPendingModifiedValues)
        pub fn build(self) -> crate::model::ReplicationGroupPendingModifiedValues {
            crate::model::ReplicationGroupPendingModifiedValues {
                primary_cluster_id: self.primary_cluster_id,
                automatic_failover_status: self.automatic_failover_status,
                resharding: self.resharding,
                auth_token_status: self.auth_token_status,
                user_groups: self.user_groups,
                log_delivery_configurations: self.log_delivery_configurations,
            }
        }
    }
}
impl ReplicationGroupPendingModifiedValues {
    /// Creates a new builder-style object to manufacture [`ReplicationGroupPendingModifiedValues`](crate::model::ReplicationGroupPendingModifiedValues)
    pub fn builder() -> crate::model::replication_group_pending_modified_values::Builder {
        crate::model::replication_group_pending_modified_values::Builder::default()
    }
}

/// <p>The log delivery configurations being modified </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingLogDeliveryConfiguration {
    /// <p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.</p>
    pub log_type: std::option::Option<crate::model::LogType>,
    /// <p>Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.</p>
    pub destination_type: std::option::Option<crate::model::DestinationType>,
    /// <p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>
    pub destination_details: std::option::Option<crate::model::DestinationDetails>,
    /// <p>Returns the log format, either JSON or TEXT</p>
    pub log_format: std::option::Option<crate::model::LogFormat>,
}
impl PendingLogDeliveryConfiguration {
    /// <p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.</p>
    pub fn log_type(&self) -> std::option::Option<&crate::model::LogType> {
        self.log_type.as_ref()
    }
    /// <p>Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.</p>
    pub fn destination_type(&self) -> std::option::Option<&crate::model::DestinationType> {
        self.destination_type.as_ref()
    }
    /// <p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>
    pub fn destination_details(&self) -> std::option::Option<&crate::model::DestinationDetails> {
        self.destination_details.as_ref()
    }
    /// <p>Returns the log format, either JSON or TEXT</p>
    pub fn log_format(&self) -> std::option::Option<&crate::model::LogFormat> {
        self.log_format.as_ref()
    }
}
impl std::fmt::Debug for PendingLogDeliveryConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingLogDeliveryConfiguration");
        formatter.field("log_type", &self.log_type);
        formatter.field("destination_type", &self.destination_type);
        formatter.field("destination_details", &self.destination_details);
        formatter.field("log_format", &self.log_format);
        formatter.finish()
    }
}
/// See [`PendingLogDeliveryConfiguration`](crate::model::PendingLogDeliveryConfiguration)
pub mod pending_log_delivery_configuration {
    /// A builder for [`PendingLogDeliveryConfiguration`](crate::model::PendingLogDeliveryConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_type: std::option::Option<crate::model::LogType>,
        pub(crate) destination_type: std::option::Option<crate::model::DestinationType>,
        pub(crate) destination_details: std::option::Option<crate::model::DestinationDetails>,
        pub(crate) log_format: std::option::Option<crate::model::LogFormat>,
    }
    impl Builder {
        /// <p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.</p>
        pub fn log_type(mut self, input: crate::model::LogType) -> Self {
            self.log_type = Some(input);
            self
        }
        /// <p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.</p>
        pub fn set_log_type(mut self, input: std::option::Option<crate::model::LogType>) -> Self {
            self.log_type = input;
            self
        }
        /// <p>Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.</p>
        pub fn destination_type(mut self, input: crate::model::DestinationType) -> Self {
            self.destination_type = Some(input);
            self
        }
        /// <p>Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.</p>
        pub fn set_destination_type(
            mut self,
            input: std::option::Option<crate::model::DestinationType>,
        ) -> Self {
            self.destination_type = input;
            self
        }
        /// <p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>
        pub fn destination_details(mut self, input: crate::model::DestinationDetails) -> Self {
            self.destination_details = Some(input);
            self
        }
        /// <p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>
        pub fn set_destination_details(
            mut self,
            input: std::option::Option<crate::model::DestinationDetails>,
        ) -> Self {
            self.destination_details = input;
            self
        }
        /// <p>Returns the log format, either JSON or TEXT</p>
        pub fn log_format(mut self, input: crate::model::LogFormat) -> Self {
            self.log_format = Some(input);
            self
        }
        /// <p>Returns the log format, either JSON or TEXT</p>
        pub fn set_log_format(
            mut self,
            input: std::option::Option<crate::model::LogFormat>,
        ) -> Self {
            self.log_format = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingLogDeliveryConfiguration`](crate::model::PendingLogDeliveryConfiguration)
        pub fn build(self) -> crate::model::PendingLogDeliveryConfiguration {
            crate::model::PendingLogDeliveryConfiguration {
                log_type: self.log_type,
                destination_type: self.destination_type,
                destination_details: self.destination_details,
                log_format: self.log_format,
            }
        }
    }
}
impl PendingLogDeliveryConfiguration {
    /// Creates a new builder-style object to manufacture [`PendingLogDeliveryConfiguration`](crate::model::PendingLogDeliveryConfiguration)
    pub fn builder() -> crate::model::pending_log_delivery_configuration::Builder {
        crate::model::pending_log_delivery_configuration::Builder::default()
    }
}

/// <p>The status of the user group update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserGroupsUpdateStatus {
    /// <p>The ID of the user group to add.</p>
    pub user_group_ids_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the user group to remove.</p>
    pub user_group_ids_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UserGroupsUpdateStatus {
    /// <p>The ID of the user group to add.</p>
    pub fn user_group_ids_to_add(&self) -> std::option::Option<&[std::string::String]> {
        self.user_group_ids_to_add.as_deref()
    }
    /// <p>The ID of the user group to remove.</p>
    pub fn user_group_ids_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.user_group_ids_to_remove.as_deref()
    }
}
impl std::fmt::Debug for UserGroupsUpdateStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserGroupsUpdateStatus");
        formatter.field("user_group_ids_to_add", &self.user_group_ids_to_add);
        formatter.field("user_group_ids_to_remove", &self.user_group_ids_to_remove);
        formatter.finish()
    }
}
/// See [`UserGroupsUpdateStatus`](crate::model::UserGroupsUpdateStatus)
pub mod user_groups_update_status {
    /// A builder for [`UserGroupsUpdateStatus`](crate::model::UserGroupsUpdateStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_group_ids_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_group_ids_to_remove:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `user_group_ids_to_add`.
        ///
        /// To override the contents of this collection use [`set_user_group_ids_to_add`](Self::set_user_group_ids_to_add).
        ///
        /// <p>The ID of the user group to add.</p>
        pub fn user_group_ids_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_group_ids_to_add.unwrap_or_default();
            v.push(input.into());
            self.user_group_ids_to_add = Some(v);
            self
        }
        /// <p>The ID of the user group to add.</p>
        pub fn set_user_group_ids_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_group_ids_to_add = input;
            self
        }
        /// Appends an item to `user_group_ids_to_remove`.
        ///
        /// To override the contents of this collection use [`set_user_group_ids_to_remove`](Self::set_user_group_ids_to_remove).
        ///
        /// <p>The ID of the user group to remove.</p>
        pub fn user_group_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_group_ids_to_remove.unwrap_or_default();
            v.push(input.into());
            self.user_group_ids_to_remove = Some(v);
            self
        }
        /// <p>The ID of the user group to remove.</p>
        pub fn set_user_group_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_group_ids_to_remove = input;
            self
        }
        /// Consumes the builder and constructs a [`UserGroupsUpdateStatus`](crate::model::UserGroupsUpdateStatus)
        pub fn build(self) -> crate::model::UserGroupsUpdateStatus {
            crate::model::UserGroupsUpdateStatus {
                user_group_ids_to_add: self.user_group_ids_to_add,
                user_group_ids_to_remove: self.user_group_ids_to_remove,
            }
        }
    }
}
impl UserGroupsUpdateStatus {
    /// Creates a new builder-style object to manufacture [`UserGroupsUpdateStatus`](crate::model::UserGroupsUpdateStatus)
    pub fn builder() -> crate::model::user_groups_update_status::Builder {
        crate::model::user_groups_update_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthTokenUpdateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Rotating,
    #[allow(missing_docs)] // documentation missing in model
    Setting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthTokenUpdateStatus {
    fn from(s: &str) -> Self {
        match s {
            "ROTATING" => AuthTokenUpdateStatus::Rotating,
            "SETTING" => AuthTokenUpdateStatus::Setting,
            other => AuthTokenUpdateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthTokenUpdateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthTokenUpdateStatus::from(s))
    }
}
impl AuthTokenUpdateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthTokenUpdateStatus::Rotating => "ROTATING",
            AuthTokenUpdateStatus::Setting => "SETTING",
            AuthTokenUpdateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ROTATING", "SETTING"]
    }
}
impl AsRef<str> for AuthTokenUpdateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status of an online resharding operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReshardingStatus {
    /// <p>Represents the progress of an online resharding operation.</p>
    pub slot_migration: std::option::Option<crate::model::SlotMigration>,
}
impl ReshardingStatus {
    /// <p>Represents the progress of an online resharding operation.</p>
    pub fn slot_migration(&self) -> std::option::Option<&crate::model::SlotMigration> {
        self.slot_migration.as_ref()
    }
}
impl std::fmt::Debug for ReshardingStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReshardingStatus");
        formatter.field("slot_migration", &self.slot_migration);
        formatter.finish()
    }
}
/// See [`ReshardingStatus`](crate::model::ReshardingStatus)
pub mod resharding_status {
    /// A builder for [`ReshardingStatus`](crate::model::ReshardingStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_migration: std::option::Option<crate::model::SlotMigration>,
    }
    impl Builder {
        /// <p>Represents the progress of an online resharding operation.</p>
        pub fn slot_migration(mut self, input: crate::model::SlotMigration) -> Self {
            self.slot_migration = Some(input);
            self
        }
        /// <p>Represents the progress of an online resharding operation.</p>
        pub fn set_slot_migration(
            mut self,
            input: std::option::Option<crate::model::SlotMigration>,
        ) -> Self {
            self.slot_migration = input;
            self
        }
        /// Consumes the builder and constructs a [`ReshardingStatus`](crate::model::ReshardingStatus)
        pub fn build(self) -> crate::model::ReshardingStatus {
            crate::model::ReshardingStatus {
                slot_migration: self.slot_migration,
            }
        }
    }
}
impl ReshardingStatus {
    /// Creates a new builder-style object to manufacture [`ReshardingStatus`](crate::model::ReshardingStatus)
    pub fn builder() -> crate::model::resharding_status::Builder {
        crate::model::resharding_status::Builder::default()
    }
}

/// <p>Represents the progress of an online resharding operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotMigration {
    /// <p>The percentage of the slot migration that is complete.</p>
    pub progress_percentage: f64,
}
impl SlotMigration {
    /// <p>The percentage of the slot migration that is complete.</p>
    pub fn progress_percentage(&self) -> f64 {
        self.progress_percentage
    }
}
impl std::fmt::Debug for SlotMigration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotMigration");
        formatter.field("progress_percentage", &self.progress_percentage);
        formatter.finish()
    }
}
/// See [`SlotMigration`](crate::model::SlotMigration)
pub mod slot_migration {
    /// A builder for [`SlotMigration`](crate::model::SlotMigration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_percentage: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The percentage of the slot migration that is complete.</p>
        pub fn progress_percentage(mut self, input: f64) -> Self {
            self.progress_percentage = Some(input);
            self
        }
        /// <p>The percentage of the slot migration that is complete.</p>
        pub fn set_progress_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.progress_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotMigration`](crate::model::SlotMigration)
        pub fn build(self) -> crate::model::SlotMigration {
            crate::model::SlotMigration {
                progress_percentage: self.progress_percentage.unwrap_or_default(),
            }
        }
    }
}
impl SlotMigration {
    /// Creates a new builder-style object to manufacture [`SlotMigration`](crate::model::SlotMigration)
    pub fn builder() -> crate::model::slot_migration::Builder {
        crate::model::slot_migration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PendingAutomaticFailoverStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PendingAutomaticFailoverStatus {
    fn from(s: &str) -> Self {
        match s {
            "disabled" => PendingAutomaticFailoverStatus::Disabled,
            "enabled" => PendingAutomaticFailoverStatus::Enabled,
            other => PendingAutomaticFailoverStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PendingAutomaticFailoverStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PendingAutomaticFailoverStatus::from(s))
    }
}
impl PendingAutomaticFailoverStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PendingAutomaticFailoverStatus::Disabled => "disabled",
            PendingAutomaticFailoverStatus::Enabled => "enabled",
            PendingAutomaticFailoverStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["disabled", "enabled"]
    }
}
impl AsRef<str> for PendingAutomaticFailoverStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The name of the Global datastore and role of this replication group in the Global datastore.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalReplicationGroupInfo {
    /// <p>The name of the Global datastore</p>
    pub global_replication_group_id: std::option::Option<std::string::String>,
    /// <p>The role of the replication group in a Global datastore. Can be primary or secondary.</p>
    pub global_replication_group_member_role: std::option::Option<std::string::String>,
}
impl GlobalReplicationGroupInfo {
    /// <p>The name of the Global datastore</p>
    pub fn global_replication_group_id(&self) -> std::option::Option<&str> {
        self.global_replication_group_id.as_deref()
    }
    /// <p>The role of the replication group in a Global datastore. Can be primary or secondary.</p>
    pub fn global_replication_group_member_role(&self) -> std::option::Option<&str> {
        self.global_replication_group_member_role.as_deref()
    }
}
impl std::fmt::Debug for GlobalReplicationGroupInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalReplicationGroupInfo");
        formatter.field(
            "global_replication_group_id",
            &self.global_replication_group_id,
        );
        formatter.field(
            "global_replication_group_member_role",
            &self.global_replication_group_member_role,
        );
        formatter.finish()
    }
}
/// See [`GlobalReplicationGroupInfo`](crate::model::GlobalReplicationGroupInfo)
pub mod global_replication_group_info {
    /// A builder for [`GlobalReplicationGroupInfo`](crate::model::GlobalReplicationGroupInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group_id: std::option::Option<std::string::String>,
        pub(crate) global_replication_group_member_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = input;
            self
        }
        /// <p>The role of the replication group in a Global datastore. Can be primary or secondary.</p>
        pub fn global_replication_group_member_role(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_member_role = Some(input.into());
            self
        }
        /// <p>The role of the replication group in a Global datastore. Can be primary or secondary.</p>
        pub fn set_global_replication_group_member_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_member_role = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalReplicationGroupInfo`](crate::model::GlobalReplicationGroupInfo)
        pub fn build(self) -> crate::model::GlobalReplicationGroupInfo {
            crate::model::GlobalReplicationGroupInfo {
                global_replication_group_id: self.global_replication_group_id,
                global_replication_group_member_role: self.global_replication_group_member_role,
            }
        }
    }
}
impl GlobalReplicationGroupInfo {
    /// Creates a new builder-style object to manufacture [`GlobalReplicationGroupInfo`](crate::model::GlobalReplicationGroupInfo)
    pub fn builder() -> crate::model::global_replication_group_info::Builder {
        crate::model::global_replication_group_info::Builder::default()
    }
}

/// <p>The endpoint from which data should be migrated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerNodeEndpoint {
    /// <p>The address of the node endpoint</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The port of the node endpoint</p>
    pub port: std::option::Option<i32>,
}
impl CustomerNodeEndpoint {
    /// <p>The address of the node endpoint</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The port of the node endpoint</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
}
impl std::fmt::Debug for CustomerNodeEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerNodeEndpoint");
        formatter.field("address", &self.address);
        formatter.field("port", &self.port);
        formatter.finish()
    }
}
/// See [`CustomerNodeEndpoint`](crate::model::CustomerNodeEndpoint)
pub mod customer_node_endpoint {
    /// A builder for [`CustomerNodeEndpoint`](crate::model::CustomerNodeEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The address of the node endpoint</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The address of the node endpoint</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The port of the node endpoint</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port of the node endpoint</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerNodeEndpoint`](crate::model::CustomerNodeEndpoint)
        pub fn build(self) -> crate::model::CustomerNodeEndpoint {
            crate::model::CustomerNodeEndpoint {
                address: self.address,
                port: self.port,
            }
        }
    }
}
impl CustomerNodeEndpoint {
    /// Creates a new builder-style object to manufacture [`CustomerNodeEndpoint`](crate::model::CustomerNodeEndpoint)
    pub fn builder() -> crate::model::customer_node_endpoint::Builder {
        crate::model::customer_node_endpoint::Builder::default()
    }
}

/// <p>Represents the output of one of the following operations:</p>
/// <ul>
/// <li>
/// <p>
/// <code>AuthorizeCacheSecurityGroupIngress</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>CreateCacheSecurityGroup</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>RevokeCacheSecurityGroupIngress</code>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheSecurityGroup {
    /// <p>The Amazon account ID of the cache security group owner.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>The name of the cache security group.</p>
    pub cache_security_group_name: std::option::Option<std::string::String>,
    /// <p>The description of the cache security group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of Amazon EC2 security groups that are associated with this cache security group.</p>
    pub ec2_security_groups: std::option::Option<std::vec::Vec<crate::model::Ec2SecurityGroup>>,
    /// <p>The ARN of the cache security group,</p>
    pub arn: std::option::Option<std::string::String>,
}
impl CacheSecurityGroup {
    /// <p>The Amazon account ID of the cache security group owner.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
    /// <p>The name of the cache security group.</p>
    pub fn cache_security_group_name(&self) -> std::option::Option<&str> {
        self.cache_security_group_name.as_deref()
    }
    /// <p>The description of the cache security group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of Amazon EC2 security groups that are associated with this cache security group.</p>
    pub fn ec2_security_groups(&self) -> std::option::Option<&[crate::model::Ec2SecurityGroup]> {
        self.ec2_security_groups.as_deref()
    }
    /// <p>The ARN of the cache security group,</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for CacheSecurityGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheSecurityGroup");
        formatter.field("owner_id", &self.owner_id);
        formatter.field("cache_security_group_name", &self.cache_security_group_name);
        formatter.field("description", &self.description);
        formatter.field("ec2_security_groups", &self.ec2_security_groups);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CacheSecurityGroup`](crate::model::CacheSecurityGroup)
pub mod cache_security_group {
    /// A builder for [`CacheSecurityGroup`](crate::model::CacheSecurityGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) cache_security_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ec2_security_groups:
            std::option::Option<std::vec::Vec<crate::model::Ec2SecurityGroup>>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon account ID of the cache security group owner.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon account ID of the cache security group owner.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>The name of the cache security group.</p>
        pub fn cache_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache security group.</p>
        pub fn set_cache_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_security_group_name = input;
            self
        }
        /// <p>The description of the cache security group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the cache security group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `ec2_security_groups`.
        ///
        /// To override the contents of this collection use [`set_ec2_security_groups`](Self::set_ec2_security_groups).
        ///
        /// <p>A list of Amazon EC2 security groups that are associated with this cache security group.</p>
        pub fn ec2_security_groups(
            mut self,
            input: impl Into<crate::model::Ec2SecurityGroup>,
        ) -> Self {
            let mut v = self.ec2_security_groups.unwrap_or_default();
            v.push(input.into());
            self.ec2_security_groups = Some(v);
            self
        }
        /// <p>A list of Amazon EC2 security groups that are associated with this cache security group.</p>
        pub fn set_ec2_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2SecurityGroup>>,
        ) -> Self {
            self.ec2_security_groups = input;
            self
        }
        /// <p>The ARN of the cache security group,</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the cache security group,</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheSecurityGroup`](crate::model::CacheSecurityGroup)
        pub fn build(self) -> crate::model::CacheSecurityGroup {
            crate::model::CacheSecurityGroup {
                owner_id: self.owner_id,
                cache_security_group_name: self.cache_security_group_name,
                description: self.description,
                ec2_security_groups: self.ec2_security_groups,
                arn: self.arn,
            }
        }
    }
}
impl CacheSecurityGroup {
    /// Creates a new builder-style object to manufacture [`CacheSecurityGroup`](crate::model::CacheSecurityGroup)
    pub fn builder() -> crate::model::cache_security_group::Builder {
        crate::model::cache_security_group::Builder::default()
    }
}

/// <p>Provides ownership and status information for an Amazon EC2 security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2SecurityGroup {
    /// <p>The status of the Amazon EC2 security group.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon EC2 security group.</p>
    pub ec2_security_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon account ID of the Amazon EC2 security group owner.</p>
    pub ec2_security_group_owner_id: std::option::Option<std::string::String>,
}
impl Ec2SecurityGroup {
    /// <p>The status of the Amazon EC2 security group.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The name of the Amazon EC2 security group.</p>
    pub fn ec2_security_group_name(&self) -> std::option::Option<&str> {
        self.ec2_security_group_name.as_deref()
    }
    /// <p>The Amazon account ID of the Amazon EC2 security group owner.</p>
    pub fn ec2_security_group_owner_id(&self) -> std::option::Option<&str> {
        self.ec2_security_group_owner_id.as_deref()
    }
}
impl std::fmt::Debug for Ec2SecurityGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2SecurityGroup");
        formatter.field("status", &self.status);
        formatter.field("ec2_security_group_name", &self.ec2_security_group_name);
        formatter.field(
            "ec2_security_group_owner_id",
            &self.ec2_security_group_owner_id,
        );
        formatter.finish()
    }
}
/// See [`Ec2SecurityGroup`](crate::model::Ec2SecurityGroup)
pub mod ec2_security_group {
    /// A builder for [`Ec2SecurityGroup`](crate::model::Ec2SecurityGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_name: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_owner_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the Amazon EC2 security group.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the Amazon EC2 security group.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The name of the Amazon EC2 security group.</p>
        pub fn ec2_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon EC2 security group.</p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_name = input;
            self
        }
        /// <p>The Amazon account ID of the Amazon EC2 security group owner.</p>
        pub fn ec2_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon account ID of the Amazon EC2 security group owner.</p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2SecurityGroup`](crate::model::Ec2SecurityGroup)
        pub fn build(self) -> crate::model::Ec2SecurityGroup {
            crate::model::Ec2SecurityGroup {
                status: self.status,
                ec2_security_group_name: self.ec2_security_group_name,
                ec2_security_group_owner_id: self.ec2_security_group_owner_id,
            }
        }
    }
}
impl Ec2SecurityGroup {
    /// Creates a new builder-style object to manufacture [`Ec2SecurityGroup`](crate::model::Ec2SecurityGroup)
    pub fn builder() -> crate::model::ec2_security_group::Builder {
        crate::model::ec2_security_group::Builder::default()
    }
}

/// <p>Describes a name-value pair that is used to update the value of a parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterNameValue {
    /// <p>The name of the parameter.</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>The value of the parameter.</p>
    pub parameter_value: std::option::Option<std::string::String>,
}
impl ParameterNameValue {
    /// <p>The name of the parameter.</p>
    pub fn parameter_name(&self) -> std::option::Option<&str> {
        self.parameter_name.as_deref()
    }
    /// <p>The value of the parameter.</p>
    pub fn parameter_value(&self) -> std::option::Option<&str> {
        self.parameter_value.as_deref()
    }
}
impl std::fmt::Debug for ParameterNameValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterNameValue");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.finish()
    }
}
/// See [`ParameterNameValue`](crate::model::ParameterNameValue)
pub mod parameter_name_value {
    /// A builder for [`ParameterNameValue`](crate::model::ParameterNameValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter.</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>The value of the parameter.</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>The value of the parameter.</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterNameValue`](crate::model::ParameterNameValue)
        pub fn build(self) -> crate::model::ParameterNameValue {
            crate::model::ParameterNameValue {
                parameter_name: self.parameter_name,
                parameter_value: self.parameter_value,
            }
        }
    }
}
impl ParameterNameValue {
    /// Creates a new builder-style object to manufacture [`ParameterNameValue`](crate::model::ParameterNameValue)
    pub fn builder() -> crate::model::parameter_name_value::Builder {
        crate::model::parameter_name_value::Builder::default()
    }
}

/// <p>A tag that can be added to an ElastiCache cluster or replication group.
/// Tags are composed of a Key/Value pair. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. A tag with a null Value is permitted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key for the tag. May not be null.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag's value. May be null.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key for the tag. May not be null.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag's value. May be null.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key for the tag. May not be null.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for the tag. May not be null.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag's value. May be null.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag's value. May be null.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Contains all of the attributes of a specific cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheCluster {
    /// <p>The user-supplied identifier of the cluster.
    /// This identifier is a unique key that identifies a cluster.</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>Represents a Memcached cluster endpoint which can be used by an application to connect to any node in the cluster.
    /// The configuration endpoint will always have <code>.cfg</code> in it.</p>
    /// <p>Example: <code>mem-3.9dvc4r<u>.cfg</u>.usw2.cache.amazonaws.com:11211</code>
    /// </p>
    pub configuration_endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>The URL of the web page where you can download the latest ElastiCache client library.</p>
    pub client_download_landing_page: std::option::Option<std::string::String>,
    /// <p>The name of the compute and memory capacity node type for the cluster.</p>
    ///
    /// <p>The following node types are supported by ElastiCache.
    /// Generally speaking, the current generation types provide more memory and computational power
    /// at lower cost when compared to their equivalent previous generation counterparts.</p>
    /// <ul>
    /// <li>
    /// <p>General purpose:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    ///
    ///
    /// <p>
    /// <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):   <code>cache.m6g.large</code>,
    /// <code>cache.m6g.xlarge</code>,
    /// <code>cache.m6g.2xlarge</code>,
    /// <code>cache.m6g.4xlarge</code>,
    /// <code>cache.m6g.8xlarge</code>,
    /// <code>cache.m6g.12xlarge</code>,
    /// <code>cache.m6g.16xlarge</code>
    ///
    ///
    ///
    /// </p>  
    ///
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    ///
    ///
    /// <p>
    /// <b>M5 node types:</b>
    /// <code>cache.m5.large</code>,
    /// <code>cache.m5.xlarge</code>,
    /// <code>cache.m5.2xlarge</code>,
    /// <code>cache.m5.4xlarge</code>,
    /// <code>cache.m5.12xlarge</code>,
    /// <code>cache.m5.24xlarge</code>
    ///
    ///
    /// </p>  
    ///
    ///
    /// <p>
    /// <b>M4 node types:</b>
    /// <code>cache.m4.large</code>,
    /// <code>cache.m4.xlarge</code>,
    /// <code>cache.m4.2xlarge</code>,
    /// <code>cache.m4.4xlarge</code>,
    /// <code>cache.m4.10xlarge</code>
    /// </p>
    ///
    ///
    /// <p>
    /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):
    /// <code>cache.t4g.micro</code>,
    /// <code>cache.t4g.small</code>,
    /// <code>cache.t4g.medium</code>
    /// </p>
    ///
    /// <p>
    /// <b>T3 node types:</b>
    /// <code>cache.t3.micro</code>,
    /// <code>cache.t3.small</code>,
    /// <code>cache.t3.medium</code>
    /// </p>
    ///
    ///
    /// <p>
    /// <b>T2 node types:</b>
    /// <code>cache.t2.micro</code>,
    /// <code>cache.t2.small</code>,
    /// <code>cache.t2.medium</code>
    /// </p>
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>T1 node types:</b>
    /// <code>cache.t1.micro</code>
    /// </p>
    ///
    /// <p>
    /// <b>M1 node types:</b>
    /// <code>cache.m1.small</code>,
    /// <code>cache.m1.medium</code>,
    /// <code>cache.m1.large</code>,
    /// <code>cache.m1.xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>M3 node types:</b>
    /// <code>cache.m3.medium</code>,
    /// <code>cache.m3.large</code>,
    /// <code>cache.m3.xlarge</code>,
    /// <code>cache.m3.2xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Compute optimized:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>C1 node types:</b>
    /// <code>cache.c1.xlarge</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized with data tiering:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    /// <p>
    /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
    ///
    ///
    ///
    ///
    /// <p>  
    ///
    /// <code>cache.r6gd.xlarge</code>,
    /// <code>cache.r6gd.2xlarge</code>,
    /// <code>cache.r6gd.4xlarge</code>,
    /// <code>cache.r6gd.8xlarge</code>,
    /// <code>cache.r6gd.12xlarge</code>,
    /// <code>cache.r6gd.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>              
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    /// <p>
    /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
    ///
    ///
    ///
    ///
    ///
    /// <p>  
    /// <code>cache.r6g.large</code>,
    /// <code>cache.r6g.xlarge</code>,
    /// <code>cache.r6g.2xlarge</code>,
    /// <code>cache.r6g.4xlarge</code>,
    /// <code>cache.r6g.8xlarge</code>,
    /// <code>cache.r6g.12xlarge</code>,
    /// <code>cache.r6g.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>  
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    /// <p>
    /// <b>R5 node types:</b>
    /// <code>cache.r5.large</code>,
    /// <code>cache.r5.xlarge</code>,
    /// <code>cache.r5.2xlarge</code>,
    /// <code>cache.r5.4xlarge</code>,
    /// <code>cache.r5.12xlarge</code>,
    /// <code>cache.r5.24xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R4 node types:</b>
    /// <code>cache.r4.large</code>,
    /// <code>cache.r4.xlarge</code>,
    /// <code>cache.r4.2xlarge</code>,
    /// <code>cache.r4.4xlarge</code>,
    /// <code>cache.r4.8xlarge</code>,
    /// <code>cache.r4.16xlarge</code>
    /// </p>
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>M2 node types:</b>            
    /// <code>cache.m2.xlarge</code>,
    /// <code>cache.m2.2xlarge</code>,
    /// <code>cache.m2.4xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R3 node types:</b>
    /// <code>cache.r3.large</code>,
    /// <code>cache.r3.xlarge</code>,
    /// <code>cache.r3.2xlarge</code>,  
    /// <code>cache.r3.4xlarge</code>,
    /// <code>cache.r3.8xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    ///
    /// <p>
    /// <b>Additional node type info</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>All current generation instance types are created in Amazon VPC by default.</p>
    /// </li>
    /// <li>
    /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis configuration variables <code>appendonly</code> and
    /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
    /// </li>
    /// </ul>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>The name of the cache engine (<code>memcached</code> or
    /// <code>redis</code>) to be used for this cluster.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version of the cache engine that is used in this cluster.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The current state of this cluster, one of the following values:
    /// <code>available</code>,
    /// <code>creating</code>,
    /// <code>deleted</code>,
    /// <code>deleting</code>,
    /// <code>incompatible-network</code>,
    /// <code>modifying</code>,
    /// <code>rebooting cluster nodes</code>,
    /// <code>restore-failed</code>, or
    /// <code>snapshotting</code>.</p>
    pub cache_cluster_status: std::option::Option<std::string::String>,
    /// <p>The number of cache nodes in the cluster.</p>
    /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached,
    /// this value must be between 1 and 40.</p>
    pub num_cache_nodes: std::option::Option<i32>,
    /// <p>The name of the Availability Zone in which the cluster is located or "Multiple"
    /// if the cache nodes are located in different Availability Zones.</p>
    pub preferred_availability_zone: std::option::Option<std::string::String>,
    /// <p>The outpost ARN in which the cache cluster is created.</p>
    pub preferred_outpost_arn: std::option::Option<std::string::String>,
    /// <p>The date and time when the cluster was created.</p>
    pub cache_cluster_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the weekly time range during which maintenance
    /// on the cluster is performed. It is specified as a range in
    /// the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum
    /// maintenance window is a 60 minute period.</p>
    /// <p>Valid values for <code>ddd</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sun</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>mon</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tue</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>wed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>thu</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>fri</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sat</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>sun:23:00-mon:01:30</code>
    /// </p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>A group of settings that are applied to the cluster in the future,
    /// or that are currently being applied.</p>
    pub pending_modified_values: std::option::Option<crate::model::PendingModifiedValues>,
    /// <p>Describes a notification topic and its status.
    /// Notification topics are used for publishing ElastiCache events to subscribers using Amazon Simple Notification Service (SNS). </p>
    pub notification_configuration: std::option::Option<crate::model::NotificationConfiguration>,
    /// <p>A list of cache security group elements, composed of name and status sub-elements.</p>
    pub cache_security_groups:
        std::option::Option<std::vec::Vec<crate::model::CacheSecurityGroupMembership>>,
    /// <p>Status of the cache parameter group.</p>
    pub cache_parameter_group: std::option::Option<crate::model::CacheParameterGroupStatus>,
    /// <p>The name of the cache subnet group associated with the cluster.</p>
    pub cache_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A list of cache nodes that are members of the cluster.</p>
    pub cache_nodes: std::option::Option<std::vec::Vec<crate::model::CacheNode>>,
    /// <p> If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
    /// </p>
    pub auto_minor_version_upgrade: bool,
    /// <p>A list of VPC Security Groups associated with the cluster.</p>
    pub security_groups: std::option::Option<std::vec::Vec<crate::model::SecurityGroupMembership>>,
    /// <p>The replication group to which this cluster belongs.
    /// If this field is empty, the cluster is not associated with any replication group.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before
    /// deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5,  a
    /// snapshot that was taken today is retained for 5 days before being deleted.</p>
    /// <important>
    /// <p>
    /// If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
    /// </important>
    pub snapshot_retention_limit: std::option::Option<i32>,
    /// <p>The daily time range (in UTC) during which ElastiCache begins taking a
    /// daily snapshot of your cluster.</p>
    /// <p>Example: <code>05:00-09:00</code>
    /// </p>
    pub snapshot_window: std::option::Option<std::string::String>,
    /// <p>A flag that enables using an <code>AuthToken</code> (password)
    /// when issuing Redis commands.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub auth_token_enabled: std::option::Option<bool>,
    /// <p>The date the auth token was last modified</p>
    pub auth_token_last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>
    /// <p>You cannot modify the value of <code>TransitEncryptionEnabled</code>
    /// after the cluster is created. To enable in-transit encryption on a cluster
    /// you must set <code>TransitEncryptionEnabled</code> to <code>true</code>
    /// when you create a cluster.</p>
    /// <p>
    /// <b>Required:</b>
    /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub transit_encryption_enabled: std::option::Option<bool>,
    /// <p>A flag that enables encryption at-rest when set to <code>true</code>.</p>
    /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code>
    /// after the cluster is created. To enable at-rest encryption on a cluster
    /// you must set <code>AtRestEncryptionEnabled</code> to <code>true</code>
    /// when you create a cluster.</p>
    /// <p>
    /// <b>Required:</b>
    /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub at_rest_encryption_enabled: std::option::Option<bool>,
    /// <p>The ARN (Amazon Resource Name) of the cache cluster.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A boolean value indicating whether log delivery is enabled for the replication group.</p>
    pub replication_group_log_delivery_enabled: bool,
    /// <p>Returns the destination, format and type of the logs.</p>
    pub log_delivery_configurations:
        std::option::Option<std::vec::Vec<crate::model::LogDeliveryConfiguration>>,
}
impl CacheCluster {
    /// <p>The user-supplied identifier of the cluster.
    /// This identifier is a unique key that identifies a cluster.</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>Represents a Memcached cluster endpoint which can be used by an application to connect to any node in the cluster.
    /// The configuration endpoint will always have <code>.cfg</code> in it.</p>
    /// <p>Example: <code>mem-3.9dvc4r<u>.cfg</u>.usw2.cache.amazonaws.com:11211</code>
    /// </p>
    pub fn configuration_endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.configuration_endpoint.as_ref()
    }
    /// <p>The URL of the web page where you can download the latest ElastiCache client library.</p>
    pub fn client_download_landing_page(&self) -> std::option::Option<&str> {
        self.client_download_landing_page.as_deref()
    }
    /// <p>The name of the compute and memory capacity node type for the cluster.</p>
    ///
    /// <p>The following node types are supported by ElastiCache.
    /// Generally speaking, the current generation types provide more memory and computational power
    /// at lower cost when compared to their equivalent previous generation counterparts.</p>
    /// <ul>
    /// <li>
    /// <p>General purpose:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    ///
    ///
    /// <p>
    /// <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):   <code>cache.m6g.large</code>,
    /// <code>cache.m6g.xlarge</code>,
    /// <code>cache.m6g.2xlarge</code>,
    /// <code>cache.m6g.4xlarge</code>,
    /// <code>cache.m6g.8xlarge</code>,
    /// <code>cache.m6g.12xlarge</code>,
    /// <code>cache.m6g.16xlarge</code>
    ///
    ///
    ///
    /// </p>  
    ///
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    ///
    ///
    /// <p>
    /// <b>M5 node types:</b>
    /// <code>cache.m5.large</code>,
    /// <code>cache.m5.xlarge</code>,
    /// <code>cache.m5.2xlarge</code>,
    /// <code>cache.m5.4xlarge</code>,
    /// <code>cache.m5.12xlarge</code>,
    /// <code>cache.m5.24xlarge</code>
    ///
    ///
    /// </p>  
    ///
    ///
    /// <p>
    /// <b>M4 node types:</b>
    /// <code>cache.m4.large</code>,
    /// <code>cache.m4.xlarge</code>,
    /// <code>cache.m4.2xlarge</code>,
    /// <code>cache.m4.4xlarge</code>,
    /// <code>cache.m4.10xlarge</code>
    /// </p>
    ///
    ///
    /// <p>
    /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):
    /// <code>cache.t4g.micro</code>,
    /// <code>cache.t4g.small</code>,
    /// <code>cache.t4g.medium</code>
    /// </p>
    ///
    /// <p>
    /// <b>T3 node types:</b>
    /// <code>cache.t3.micro</code>,
    /// <code>cache.t3.small</code>,
    /// <code>cache.t3.medium</code>
    /// </p>
    ///
    ///
    /// <p>
    /// <b>T2 node types:</b>
    /// <code>cache.t2.micro</code>,
    /// <code>cache.t2.small</code>,
    /// <code>cache.t2.medium</code>
    /// </p>
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>T1 node types:</b>
    /// <code>cache.t1.micro</code>
    /// </p>
    ///
    /// <p>
    /// <b>M1 node types:</b>
    /// <code>cache.m1.small</code>,
    /// <code>cache.m1.medium</code>,
    /// <code>cache.m1.large</code>,
    /// <code>cache.m1.xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>M3 node types:</b>
    /// <code>cache.m3.medium</code>,
    /// <code>cache.m3.large</code>,
    /// <code>cache.m3.xlarge</code>,
    /// <code>cache.m3.2xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Compute optimized:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>C1 node types:</b>
    /// <code>cache.c1.xlarge</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized with data tiering:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    /// <p>
    /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
    ///
    ///
    ///
    ///
    /// <p>  
    ///
    /// <code>cache.r6gd.xlarge</code>,
    /// <code>cache.r6gd.2xlarge</code>,
    /// <code>cache.r6gd.4xlarge</code>,
    /// <code>cache.r6gd.8xlarge</code>,
    /// <code>cache.r6gd.12xlarge</code>,
    /// <code>cache.r6gd.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>              
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    /// <p>
    /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
    ///
    ///
    ///
    ///
    ///
    /// <p>  
    /// <code>cache.r6g.large</code>,
    /// <code>cache.r6g.xlarge</code>,
    /// <code>cache.r6g.2xlarge</code>,
    /// <code>cache.r6g.4xlarge</code>,
    /// <code>cache.r6g.8xlarge</code>,
    /// <code>cache.r6g.12xlarge</code>,
    /// <code>cache.r6g.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>  
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    /// <p>
    /// <b>R5 node types:</b>
    /// <code>cache.r5.large</code>,
    /// <code>cache.r5.xlarge</code>,
    /// <code>cache.r5.2xlarge</code>,
    /// <code>cache.r5.4xlarge</code>,
    /// <code>cache.r5.12xlarge</code>,
    /// <code>cache.r5.24xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R4 node types:</b>
    /// <code>cache.r4.large</code>,
    /// <code>cache.r4.xlarge</code>,
    /// <code>cache.r4.2xlarge</code>,
    /// <code>cache.r4.4xlarge</code>,
    /// <code>cache.r4.8xlarge</code>,
    /// <code>cache.r4.16xlarge</code>
    /// </p>
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>M2 node types:</b>            
    /// <code>cache.m2.xlarge</code>,
    /// <code>cache.m2.2xlarge</code>,
    /// <code>cache.m2.4xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R3 node types:</b>
    /// <code>cache.r3.large</code>,
    /// <code>cache.r3.xlarge</code>,
    /// <code>cache.r3.2xlarge</code>,  
    /// <code>cache.r3.4xlarge</code>,
    /// <code>cache.r3.8xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    ///
    /// <p>
    /// <b>Additional node type info</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>All current generation instance types are created in Amazon VPC by default.</p>
    /// </li>
    /// <li>
    /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis configuration variables <code>appendonly</code> and
    /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
    /// </li>
    /// </ul>
    pub fn cache_node_type(&self) -> std::option::Option<&str> {
        self.cache_node_type.as_deref()
    }
    /// <p>The name of the cache engine (<code>memcached</code> or
    /// <code>redis</code>) to be used for this cluster.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The version of the cache engine that is used in this cluster.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The current state of this cluster, one of the following values:
    /// <code>available</code>,
    /// <code>creating</code>,
    /// <code>deleted</code>,
    /// <code>deleting</code>,
    /// <code>incompatible-network</code>,
    /// <code>modifying</code>,
    /// <code>rebooting cluster nodes</code>,
    /// <code>restore-failed</code>, or
    /// <code>snapshotting</code>.</p>
    pub fn cache_cluster_status(&self) -> std::option::Option<&str> {
        self.cache_cluster_status.as_deref()
    }
    /// <p>The number of cache nodes in the cluster.</p>
    /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached,
    /// this value must be between 1 and 40.</p>
    pub fn num_cache_nodes(&self) -> std::option::Option<i32> {
        self.num_cache_nodes
    }
    /// <p>The name of the Availability Zone in which the cluster is located or "Multiple"
    /// if the cache nodes are located in different Availability Zones.</p>
    pub fn preferred_availability_zone(&self) -> std::option::Option<&str> {
        self.preferred_availability_zone.as_deref()
    }
    /// <p>The outpost ARN in which the cache cluster is created.</p>
    pub fn preferred_outpost_arn(&self) -> std::option::Option<&str> {
        self.preferred_outpost_arn.as_deref()
    }
    /// <p>The date and time when the cluster was created.</p>
    pub fn cache_cluster_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.cache_cluster_create_time.as_ref()
    }
    /// <p>Specifies the weekly time range during which maintenance
    /// on the cluster is performed. It is specified as a range in
    /// the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum
    /// maintenance window is a 60 minute period.</p>
    /// <p>Valid values for <code>ddd</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sun</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>mon</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tue</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>wed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>thu</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>fri</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sat</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>sun:23:00-mon:01:30</code>
    /// </p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>A group of settings that are applied to the cluster in the future,
    /// or that are currently being applied.</p>
    pub fn pending_modified_values(
        &self,
    ) -> std::option::Option<&crate::model::PendingModifiedValues> {
        self.pending_modified_values.as_ref()
    }
    /// <p>Describes a notification topic and its status.
    /// Notification topics are used for publishing ElastiCache events to subscribers using Amazon Simple Notification Service (SNS). </p>
    pub fn notification_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NotificationConfiguration> {
        self.notification_configuration.as_ref()
    }
    /// <p>A list of cache security group elements, composed of name and status sub-elements.</p>
    pub fn cache_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::CacheSecurityGroupMembership]> {
        self.cache_security_groups.as_deref()
    }
    /// <p>Status of the cache parameter group.</p>
    pub fn cache_parameter_group(
        &self,
    ) -> std::option::Option<&crate::model::CacheParameterGroupStatus> {
        self.cache_parameter_group.as_ref()
    }
    /// <p>The name of the cache subnet group associated with the cluster.</p>
    pub fn cache_subnet_group_name(&self) -> std::option::Option<&str> {
        self.cache_subnet_group_name.as_deref()
    }
    /// <p>A list of cache nodes that are members of the cluster.</p>
    pub fn cache_nodes(&self) -> std::option::Option<&[crate::model::CacheNode]> {
        self.cache_nodes.as_deref()
    }
    /// <p> If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
    /// </p>
    pub fn auto_minor_version_upgrade(&self) -> bool {
        self.auto_minor_version_upgrade
    }
    /// <p>A list of VPC Security Groups associated with the cluster.</p>
    pub fn security_groups(&self) -> std::option::Option<&[crate::model::SecurityGroupMembership]> {
        self.security_groups.as_deref()
    }
    /// <p>The replication group to which this cluster belongs.
    /// If this field is empty, the cluster is not associated with any replication group.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before
    /// deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5,  a
    /// snapshot that was taken today is retained for 5 days before being deleted.</p>
    /// <important>
    /// <p>
    /// If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
    /// </important>
    pub fn snapshot_retention_limit(&self) -> std::option::Option<i32> {
        self.snapshot_retention_limit
    }
    /// <p>The daily time range (in UTC) during which ElastiCache begins taking a
    /// daily snapshot of your cluster.</p>
    /// <p>Example: <code>05:00-09:00</code>
    /// </p>
    pub fn snapshot_window(&self) -> std::option::Option<&str> {
        self.snapshot_window.as_deref()
    }
    /// <p>A flag that enables using an <code>AuthToken</code> (password)
    /// when issuing Redis commands.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub fn auth_token_enabled(&self) -> std::option::Option<bool> {
        self.auth_token_enabled
    }
    /// <p>The date the auth token was last modified</p>
    pub fn auth_token_last_modified_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.auth_token_last_modified_date.as_ref()
    }
    /// <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>
    /// <p>You cannot modify the value of <code>TransitEncryptionEnabled</code>
    /// after the cluster is created. To enable in-transit encryption on a cluster
    /// you must set <code>TransitEncryptionEnabled</code> to <code>true</code>
    /// when you create a cluster.</p>
    /// <p>
    /// <b>Required:</b>
    /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub fn transit_encryption_enabled(&self) -> std::option::Option<bool> {
        self.transit_encryption_enabled
    }
    /// <p>A flag that enables encryption at-rest when set to <code>true</code>.</p>
    /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code>
    /// after the cluster is created. To enable at-rest encryption on a cluster
    /// you must set <code>AtRestEncryptionEnabled</code> to <code>true</code>
    /// when you create a cluster.</p>
    /// <p>
    /// <b>Required:</b>
    /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub fn at_rest_encryption_enabled(&self) -> std::option::Option<bool> {
        self.at_rest_encryption_enabled
    }
    /// <p>The ARN (Amazon Resource Name) of the cache cluster.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A boolean value indicating whether log delivery is enabled for the replication group.</p>
    pub fn replication_group_log_delivery_enabled(&self) -> bool {
        self.replication_group_log_delivery_enabled
    }
    /// <p>Returns the destination, format and type of the logs.</p>
    pub fn log_delivery_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::LogDeliveryConfiguration]> {
        self.log_delivery_configurations.as_deref()
    }
}
impl std::fmt::Debug for CacheCluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheCluster");
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("configuration_endpoint", &self.configuration_endpoint);
        formatter.field(
            "client_download_landing_page",
            &self.client_download_landing_page,
        );
        formatter.field("cache_node_type", &self.cache_node_type);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("cache_cluster_status", &self.cache_cluster_status);
        formatter.field("num_cache_nodes", &self.num_cache_nodes);
        formatter.field(
            "preferred_availability_zone",
            &self.preferred_availability_zone,
        );
        formatter.field("preferred_outpost_arn", &self.preferred_outpost_arn);
        formatter.field("cache_cluster_create_time", &self.cache_cluster_create_time);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("pending_modified_values", &self.pending_modified_values);
        formatter.field(
            "notification_configuration",
            &self.notification_configuration,
        );
        formatter.field("cache_security_groups", &self.cache_security_groups);
        formatter.field("cache_parameter_group", &self.cache_parameter_group);
        formatter.field("cache_subnet_group_name", &self.cache_subnet_group_name);
        formatter.field("cache_nodes", &self.cache_nodes);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("security_groups", &self.security_groups);
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("snapshot_retention_limit", &self.snapshot_retention_limit);
        formatter.field("snapshot_window", &self.snapshot_window);
        formatter.field("auth_token_enabled", &self.auth_token_enabled);
        formatter.field(
            "auth_token_last_modified_date",
            &self.auth_token_last_modified_date,
        );
        formatter.field(
            "transit_encryption_enabled",
            &self.transit_encryption_enabled,
        );
        formatter.field(
            "at_rest_encryption_enabled",
            &self.at_rest_encryption_enabled,
        );
        formatter.field("arn", &self.arn);
        formatter.field(
            "replication_group_log_delivery_enabled",
            &self.replication_group_log_delivery_enabled,
        );
        formatter.field(
            "log_delivery_configurations",
            &self.log_delivery_configurations,
        );
        formatter.finish()
    }
}
/// See [`CacheCluster`](crate::model::CacheCluster)
pub mod cache_cluster {
    /// A builder for [`CacheCluster`](crate::model::CacheCluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) configuration_endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) client_download_landing_page: std::option::Option<std::string::String>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_status: std::option::Option<std::string::String>,
        pub(crate) num_cache_nodes: std::option::Option<i32>,
        pub(crate) preferred_availability_zone: std::option::Option<std::string::String>,
        pub(crate) preferred_outpost_arn: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) pending_modified_values:
            std::option::Option<crate::model::PendingModifiedValues>,
        pub(crate) notification_configuration:
            std::option::Option<crate::model::NotificationConfiguration>,
        pub(crate) cache_security_groups:
            std::option::Option<std::vec::Vec<crate::model::CacheSecurityGroupMembership>>,
        pub(crate) cache_parameter_group:
            std::option::Option<crate::model::CacheParameterGroupStatus>,
        pub(crate) cache_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) cache_nodes: std::option::Option<std::vec::Vec<crate::model::CacheNode>>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) security_groups:
            std::option::Option<std::vec::Vec<crate::model::SecurityGroupMembership>>,
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_retention_limit: std::option::Option<i32>,
        pub(crate) snapshot_window: std::option::Option<std::string::String>,
        pub(crate) auth_token_enabled: std::option::Option<bool>,
        pub(crate) auth_token_last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) transit_encryption_enabled: std::option::Option<bool>,
        pub(crate) at_rest_encryption_enabled: std::option::Option<bool>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) replication_group_log_delivery_enabled: std::option::Option<bool>,
        pub(crate) log_delivery_configurations:
            std::option::Option<std::vec::Vec<crate::model::LogDeliveryConfiguration>>,
    }
    impl Builder {
        /// <p>The user-supplied identifier of the cluster.
        /// This identifier is a unique key that identifies a cluster.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The user-supplied identifier of the cluster.
        /// This identifier is a unique key that identifies a cluster.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>Represents a Memcached cluster endpoint which can be used by an application to connect to any node in the cluster.
        /// The configuration endpoint will always have <code>.cfg</code> in it.</p>
        /// <p>Example: <code>mem-3.9dvc4r<u>.cfg</u>.usw2.cache.amazonaws.com:11211</code>
        /// </p>
        pub fn configuration_endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.configuration_endpoint = Some(input);
            self
        }
        /// <p>Represents a Memcached cluster endpoint which can be used by an application to connect to any node in the cluster.
        /// The configuration endpoint will always have <code>.cfg</code> in it.</p>
        /// <p>Example: <code>mem-3.9dvc4r<u>.cfg</u>.usw2.cache.amazonaws.com:11211</code>
        /// </p>
        pub fn set_configuration_endpoint(
            mut self,
            input: std::option::Option<crate::model::Endpoint>,
        ) -> Self {
            self.configuration_endpoint = input;
            self
        }
        /// <p>The URL of the web page where you can download the latest ElastiCache client library.</p>
        pub fn client_download_landing_page(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.client_download_landing_page = Some(input.into());
            self
        }
        /// <p>The URL of the web page where you can download the latest ElastiCache client library.</p>
        pub fn set_client_download_landing_page(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_download_landing_page = input;
            self
        }
        /// <p>The name of the compute and memory capacity node type for the cluster.</p>
        ///
        /// <p>The following node types are supported by ElastiCache.
        /// Generally speaking, the current generation types provide more memory and computational power
        /// at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li>
        /// <p>General purpose:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        ///
        ///
        /// <p>
        /// <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):   <code>cache.m6g.large</code>,
        /// <code>cache.m6g.xlarge</code>,
        /// <code>cache.m6g.2xlarge</code>,
        /// <code>cache.m6g.4xlarge</code>,
        /// <code>cache.m6g.8xlarge</code>,
        /// <code>cache.m6g.12xlarge</code>,
        /// <code>cache.m6g.16xlarge</code>
        ///
        ///
        ///
        /// </p>  
        ///
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        ///
        ///
        /// <p>
        /// <b>M5 node types:</b>
        /// <code>cache.m5.large</code>,
        /// <code>cache.m5.xlarge</code>,
        /// <code>cache.m5.2xlarge</code>,
        /// <code>cache.m5.4xlarge</code>,
        /// <code>cache.m5.12xlarge</code>,
        /// <code>cache.m5.24xlarge</code>
        ///
        ///
        /// </p>  
        ///
        ///
        /// <p>
        /// <b>M4 node types:</b>
        /// <code>cache.m4.large</code>,
        /// <code>cache.m4.xlarge</code>,
        /// <code>cache.m4.2xlarge</code>,
        /// <code>cache.m4.4xlarge</code>,
        /// <code>cache.m4.10xlarge</code>
        /// </p>
        ///
        ///
        /// <p>
        /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):
        /// <code>cache.t4g.micro</code>,
        /// <code>cache.t4g.small</code>,
        /// <code>cache.t4g.medium</code>
        /// </p>
        ///
        /// <p>
        /// <b>T3 node types:</b>
        /// <code>cache.t3.micro</code>,
        /// <code>cache.t3.small</code>,
        /// <code>cache.t3.medium</code>
        /// </p>
        ///
        ///
        /// <p>
        /// <b>T2 node types:</b>
        /// <code>cache.t2.micro</code>,
        /// <code>cache.t2.small</code>,
        /// <code>cache.t2.medium</code>
        /// </p>
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>T1 node types:</b>
        /// <code>cache.t1.micro</code>
        /// </p>
        ///
        /// <p>
        /// <b>M1 node types:</b>
        /// <code>cache.m1.small</code>,
        /// <code>cache.m1.medium</code>,
        /// <code>cache.m1.large</code>,
        /// <code>cache.m1.xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>M3 node types:</b>
        /// <code>cache.m3.medium</code>,
        /// <code>cache.m3.large</code>,
        /// <code>cache.m3.xlarge</code>,
        /// <code>cache.m3.2xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Compute optimized:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>C1 node types:</b>
        /// <code>cache.c1.xlarge</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        /// <p>
        /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
        ///
        ///
        ///
        ///
        /// <p>  
        ///
        /// <code>cache.r6gd.xlarge</code>,
        /// <code>cache.r6gd.2xlarge</code>,
        /// <code>cache.r6gd.4xlarge</code>,
        /// <code>cache.r6gd.8xlarge</code>,
        /// <code>cache.r6gd.12xlarge</code>,
        /// <code>cache.r6gd.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>              
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        /// <p>
        /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
        ///
        ///
        ///
        ///
        ///
        /// <p>  
        /// <code>cache.r6g.large</code>,
        /// <code>cache.r6g.xlarge</code>,
        /// <code>cache.r6g.2xlarge</code>,
        /// <code>cache.r6g.4xlarge</code>,
        /// <code>cache.r6g.8xlarge</code>,
        /// <code>cache.r6g.12xlarge</code>,
        /// <code>cache.r6g.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>  
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        /// <p>
        /// <b>R5 node types:</b>
        /// <code>cache.r5.large</code>,
        /// <code>cache.r5.xlarge</code>,
        /// <code>cache.r5.2xlarge</code>,
        /// <code>cache.r5.4xlarge</code>,
        /// <code>cache.r5.12xlarge</code>,
        /// <code>cache.r5.24xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R4 node types:</b>
        /// <code>cache.r4.large</code>,
        /// <code>cache.r4.xlarge</code>,
        /// <code>cache.r4.2xlarge</code>,
        /// <code>cache.r4.4xlarge</code>,
        /// <code>cache.r4.8xlarge</code>,
        /// <code>cache.r4.16xlarge</code>
        /// </p>
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>M2 node types:</b>            
        /// <code>cache.m2.xlarge</code>,
        /// <code>cache.m2.2xlarge</code>,
        /// <code>cache.m2.4xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R3 node types:</b>
        /// <code>cache.r3.large</code>,
        /// <code>cache.r3.xlarge</code>,
        /// <code>cache.r3.2xlarge</code>,  
        /// <code>cache.r3.4xlarge</code>,
        /// <code>cache.r3.8xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Additional node type info</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>All current generation instance types are created in Amazon VPC by default.</p>
        /// </li>
        /// <li>
        /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis configuration variables <code>appendonly</code> and
        /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
        /// </li>
        /// </ul>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>The name of the compute and memory capacity node type for the cluster.</p>
        ///
        /// <p>The following node types are supported by ElastiCache.
        /// Generally speaking, the current generation types provide more memory and computational power
        /// at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li>
        /// <p>General purpose:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        ///
        ///
        /// <p>
        /// <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):   <code>cache.m6g.large</code>,
        /// <code>cache.m6g.xlarge</code>,
        /// <code>cache.m6g.2xlarge</code>,
        /// <code>cache.m6g.4xlarge</code>,
        /// <code>cache.m6g.8xlarge</code>,
        /// <code>cache.m6g.12xlarge</code>,
        /// <code>cache.m6g.16xlarge</code>
        ///
        ///
        ///
        /// </p>  
        ///
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        ///
        ///
        /// <p>
        /// <b>M5 node types:</b>
        /// <code>cache.m5.large</code>,
        /// <code>cache.m5.xlarge</code>,
        /// <code>cache.m5.2xlarge</code>,
        /// <code>cache.m5.4xlarge</code>,
        /// <code>cache.m5.12xlarge</code>,
        /// <code>cache.m5.24xlarge</code>
        ///
        ///
        /// </p>  
        ///
        ///
        /// <p>
        /// <b>M4 node types:</b>
        /// <code>cache.m4.large</code>,
        /// <code>cache.m4.xlarge</code>,
        /// <code>cache.m4.2xlarge</code>,
        /// <code>cache.m4.4xlarge</code>,
        /// <code>cache.m4.10xlarge</code>
        /// </p>
        ///
        ///
        /// <p>
        /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):
        /// <code>cache.t4g.micro</code>,
        /// <code>cache.t4g.small</code>,
        /// <code>cache.t4g.medium</code>
        /// </p>
        ///
        /// <p>
        /// <b>T3 node types:</b>
        /// <code>cache.t3.micro</code>,
        /// <code>cache.t3.small</code>,
        /// <code>cache.t3.medium</code>
        /// </p>
        ///
        ///
        /// <p>
        /// <b>T2 node types:</b>
        /// <code>cache.t2.micro</code>,
        /// <code>cache.t2.small</code>,
        /// <code>cache.t2.medium</code>
        /// </p>
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>T1 node types:</b>
        /// <code>cache.t1.micro</code>
        /// </p>
        ///
        /// <p>
        /// <b>M1 node types:</b>
        /// <code>cache.m1.small</code>,
        /// <code>cache.m1.medium</code>,
        /// <code>cache.m1.large</code>,
        /// <code>cache.m1.xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>M3 node types:</b>
        /// <code>cache.m3.medium</code>,
        /// <code>cache.m3.large</code>,
        /// <code>cache.m3.xlarge</code>,
        /// <code>cache.m3.2xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Compute optimized:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>C1 node types:</b>
        /// <code>cache.c1.xlarge</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        /// <p>
        /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
        ///
        ///
        ///
        ///
        /// <p>  
        ///
        /// <code>cache.r6gd.xlarge</code>,
        /// <code>cache.r6gd.2xlarge</code>,
        /// <code>cache.r6gd.4xlarge</code>,
        /// <code>cache.r6gd.8xlarge</code>,
        /// <code>cache.r6gd.12xlarge</code>,
        /// <code>cache.r6gd.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>              
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        /// <p>
        /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
        ///
        ///
        ///
        ///
        ///
        /// <p>  
        /// <code>cache.r6g.large</code>,
        /// <code>cache.r6g.xlarge</code>,
        /// <code>cache.r6g.2xlarge</code>,
        /// <code>cache.r6g.4xlarge</code>,
        /// <code>cache.r6g.8xlarge</code>,
        /// <code>cache.r6g.12xlarge</code>,
        /// <code>cache.r6g.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>  
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        /// <p>
        /// <b>R5 node types:</b>
        /// <code>cache.r5.large</code>,
        /// <code>cache.r5.xlarge</code>,
        /// <code>cache.r5.2xlarge</code>,
        /// <code>cache.r5.4xlarge</code>,
        /// <code>cache.r5.12xlarge</code>,
        /// <code>cache.r5.24xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R4 node types:</b>
        /// <code>cache.r4.large</code>,
        /// <code>cache.r4.xlarge</code>,
        /// <code>cache.r4.2xlarge</code>,
        /// <code>cache.r4.4xlarge</code>,
        /// <code>cache.r4.8xlarge</code>,
        /// <code>cache.r4.16xlarge</code>
        /// </p>
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>M2 node types:</b>            
        /// <code>cache.m2.xlarge</code>,
        /// <code>cache.m2.2xlarge</code>,
        /// <code>cache.m2.4xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R3 node types:</b>
        /// <code>cache.r3.large</code>,
        /// <code>cache.r3.xlarge</code>,
        /// <code>cache.r3.2xlarge</code>,  
        /// <code>cache.r3.4xlarge</code>,
        /// <code>cache.r3.8xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Additional node type info</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>All current generation instance types are created in Amazon VPC by default.</p>
        /// </li>
        /// <li>
        /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis configuration variables <code>appendonly</code> and
        /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
        /// </li>
        /// </ul>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>The name of the cache engine (<code>memcached</code> or
        /// <code>redis</code>) to be used for this cluster.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the cache engine (<code>memcached</code> or
        /// <code>redis</code>) to be used for this cluster.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version of the cache engine that is used in this cluster.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version of the cache engine that is used in this cluster.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The current state of this cluster, one of the following values:
        /// <code>available</code>,
        /// <code>creating</code>,
        /// <code>deleted</code>,
        /// <code>deleting</code>,
        /// <code>incompatible-network</code>,
        /// <code>modifying</code>,
        /// <code>rebooting cluster nodes</code>,
        /// <code>restore-failed</code>, or
        /// <code>snapshotting</code>.</p>
        pub fn cache_cluster_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_status = Some(input.into());
            self
        }
        /// <p>The current state of this cluster, one of the following values:
        /// <code>available</code>,
        /// <code>creating</code>,
        /// <code>deleted</code>,
        /// <code>deleting</code>,
        /// <code>incompatible-network</code>,
        /// <code>modifying</code>,
        /// <code>rebooting cluster nodes</code>,
        /// <code>restore-failed</code>, or
        /// <code>snapshotting</code>.</p>
        pub fn set_cache_cluster_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_status = input;
            self
        }
        /// <p>The number of cache nodes in the cluster.</p>
        /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached,
        /// this value must be between 1 and 40.</p>
        pub fn num_cache_nodes(mut self, input: i32) -> Self {
            self.num_cache_nodes = Some(input);
            self
        }
        /// <p>The number of cache nodes in the cluster.</p>
        /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached,
        /// this value must be between 1 and 40.</p>
        pub fn set_num_cache_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.num_cache_nodes = input;
            self
        }
        /// <p>The name of the Availability Zone in which the cluster is located or "Multiple"
        /// if the cache nodes are located in different Availability Zones.</p>
        pub fn preferred_availability_zone(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_availability_zone = Some(input.into());
            self
        }
        /// <p>The name of the Availability Zone in which the cluster is located or "Multiple"
        /// if the cache nodes are located in different Availability Zones.</p>
        pub fn set_preferred_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_availability_zone = input;
            self
        }
        /// <p>The outpost ARN in which the cache cluster is created.</p>
        pub fn preferred_outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_outpost_arn = Some(input.into());
            self
        }
        /// <p>The outpost ARN in which the cache cluster is created.</p>
        pub fn set_preferred_outpost_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_outpost_arn = input;
            self
        }
        /// <p>The date and time when the cluster was created.</p>
        pub fn cache_cluster_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.cache_cluster_create_time = Some(input);
            self
        }
        /// <p>The date and time when the cluster was created.</p>
        pub fn set_cache_cluster_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.cache_cluster_create_time = input;
            self
        }
        /// <p>Specifies the weekly time range during which maintenance
        /// on the cluster is performed. It is specified as a range in
        /// the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum
        /// maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sun</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tue</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>wed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>thu</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>fri</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sat</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code>
        /// </p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance
        /// on the cluster is performed. It is specified as a range in
        /// the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum
        /// maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sun</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tue</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>wed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>thu</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>fri</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sat</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code>
        /// </p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>A group of settings that are applied to the cluster in the future,
        /// or that are currently being applied.</p>
        pub fn pending_modified_values(
            mut self,
            input: crate::model::PendingModifiedValues,
        ) -> Self {
            self.pending_modified_values = Some(input);
            self
        }
        /// <p>A group of settings that are applied to the cluster in the future,
        /// or that are currently being applied.</p>
        pub fn set_pending_modified_values(
            mut self,
            input: std::option::Option<crate::model::PendingModifiedValues>,
        ) -> Self {
            self.pending_modified_values = input;
            self
        }
        /// <p>Describes a notification topic and its status.
        /// Notification topics are used for publishing ElastiCache events to subscribers using Amazon Simple Notification Service (SNS). </p>
        pub fn notification_configuration(
            mut self,
            input: crate::model::NotificationConfiguration,
        ) -> Self {
            self.notification_configuration = Some(input);
            self
        }
        /// <p>Describes a notification topic and its status.
        /// Notification topics are used for publishing ElastiCache events to subscribers using Amazon Simple Notification Service (SNS). </p>
        pub fn set_notification_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationConfiguration>,
        ) -> Self {
            self.notification_configuration = input;
            self
        }
        /// Appends an item to `cache_security_groups`.
        ///
        /// To override the contents of this collection use [`set_cache_security_groups`](Self::set_cache_security_groups).
        ///
        /// <p>A list of cache security group elements, composed of name and status sub-elements.</p>
        pub fn cache_security_groups(
            mut self,
            input: impl Into<crate::model::CacheSecurityGroupMembership>,
        ) -> Self {
            let mut v = self.cache_security_groups.unwrap_or_default();
            v.push(input.into());
            self.cache_security_groups = Some(v);
            self
        }
        /// <p>A list of cache security group elements, composed of name and status sub-elements.</p>
        pub fn set_cache_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheSecurityGroupMembership>>,
        ) -> Self {
            self.cache_security_groups = input;
            self
        }
        /// <p>Status of the cache parameter group.</p>
        pub fn cache_parameter_group(
            mut self,
            input: crate::model::CacheParameterGroupStatus,
        ) -> Self {
            self.cache_parameter_group = Some(input);
            self
        }
        /// <p>Status of the cache parameter group.</p>
        pub fn set_cache_parameter_group(
            mut self,
            input: std::option::Option<crate::model::CacheParameterGroupStatus>,
        ) -> Self {
            self.cache_parameter_group = input;
            self
        }
        /// <p>The name of the cache subnet group associated with the cluster.</p>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache subnet group associated with the cluster.</p>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_name = input;
            self
        }
        /// Appends an item to `cache_nodes`.
        ///
        /// To override the contents of this collection use [`set_cache_nodes`](Self::set_cache_nodes).
        ///
        /// <p>A list of cache nodes that are members of the cluster.</p>
        pub fn cache_nodes(mut self, input: impl Into<crate::model::CacheNode>) -> Self {
            let mut v = self.cache_nodes.unwrap_or_default();
            v.push(input.into());
            self.cache_nodes = Some(v);
            self
        }
        /// <p>A list of cache nodes that are members of the cluster.</p>
        pub fn set_cache_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheNode>>,
        ) -> Self {
            self.cache_nodes = input;
            self
        }
        /// <p> If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
        /// </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p> If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
        /// </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>A list of VPC Security Groups associated with the cluster.</p>
        pub fn security_groups(
            mut self,
            input: impl Into<crate::model::SecurityGroupMembership>,
        ) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>A list of VPC Security Groups associated with the cluster.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecurityGroupMembership>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The replication group to which this cluster belongs.
        /// If this field is empty, the cluster is not associated with any replication group.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The replication group to which this cluster belongs.
        /// If this field is empty, the cluster is not associated with any replication group.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before
        /// deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5,  a
        /// snapshot that was taken today is retained for 5 days before being deleted.</p>
        /// <important>
        /// <p>
        /// If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
        /// </important>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.snapshot_retention_limit = Some(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before
        /// deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5,  a
        /// snapshot that was taken today is retained for 5 days before being deleted.</p>
        /// <important>
        /// <p>
        /// If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
        /// </important>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.snapshot_retention_limit = input;
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a
        /// daily snapshot of your cluster.</p>
        /// <p>Example: <code>05:00-09:00</code>
        /// </p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_window = Some(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a
        /// daily snapshot of your cluster.</p>
        /// <p>Example: <code>05:00-09:00</code>
        /// </p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_window = input;
            self
        }
        /// <p>A flag that enables using an <code>AuthToken</code> (password)
        /// when issuing Redis commands.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn auth_token_enabled(mut self, input: bool) -> Self {
            self.auth_token_enabled = Some(input);
            self
        }
        /// <p>A flag that enables using an <code>AuthToken</code> (password)
        /// when issuing Redis commands.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_auth_token_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.auth_token_enabled = input;
            self
        }
        /// <p>The date the auth token was last modified</p>
        pub fn auth_token_last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.auth_token_last_modified_date = Some(input);
            self
        }
        /// <p>The date the auth token was last modified</p>
        pub fn set_auth_token_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.auth_token_last_modified_date = input;
            self
        }
        /// <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>TransitEncryptionEnabled</code>
        /// after the cluster is created. To enable in-transit encryption on a cluster
        /// you must set <code>TransitEncryptionEnabled</code> to <code>true</code>
        /// when you create a cluster.</p>
        /// <p>
        /// <b>Required:</b>
        /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn transit_encryption_enabled(mut self, input: bool) -> Self {
            self.transit_encryption_enabled = Some(input);
            self
        }
        /// <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>TransitEncryptionEnabled</code>
        /// after the cluster is created. To enable in-transit encryption on a cluster
        /// you must set <code>TransitEncryptionEnabled</code> to <code>true</code>
        /// when you create a cluster.</p>
        /// <p>
        /// <b>Required:</b>
        /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_transit_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.transit_encryption_enabled = input;
            self
        }
        /// <p>A flag that enables encryption at-rest when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code>
        /// after the cluster is created. To enable at-rest encryption on a cluster
        /// you must set <code>AtRestEncryptionEnabled</code> to <code>true</code>
        /// when you create a cluster.</p>
        /// <p>
        /// <b>Required:</b>
        /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn at_rest_encryption_enabled(mut self, input: bool) -> Self {
            self.at_rest_encryption_enabled = Some(input);
            self
        }
        /// <p>A flag that enables encryption at-rest when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code>
        /// after the cluster is created. To enable at-rest encryption on a cluster
        /// you must set <code>AtRestEncryptionEnabled</code> to <code>true</code>
        /// when you create a cluster.</p>
        /// <p>
        /// <b>Required:</b>
        /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_at_rest_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.at_rest_encryption_enabled = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the cache cluster.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the cache cluster.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>A boolean value indicating whether log delivery is enabled for the replication group.</p>
        pub fn replication_group_log_delivery_enabled(mut self, input: bool) -> Self {
            self.replication_group_log_delivery_enabled = Some(input);
            self
        }
        /// <p>A boolean value indicating whether log delivery is enabled for the replication group.</p>
        pub fn set_replication_group_log_delivery_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.replication_group_log_delivery_enabled = input;
            self
        }
        /// Appends an item to `log_delivery_configurations`.
        ///
        /// To override the contents of this collection use [`set_log_delivery_configurations`](Self::set_log_delivery_configurations).
        ///
        /// <p>Returns the destination, format and type of the logs.</p>
        pub fn log_delivery_configurations(
            mut self,
            input: impl Into<crate::model::LogDeliveryConfiguration>,
        ) -> Self {
            let mut v = self.log_delivery_configurations.unwrap_or_default();
            v.push(input.into());
            self.log_delivery_configurations = Some(v);
            self
        }
        /// <p>Returns the destination, format and type of the logs.</p>
        pub fn set_log_delivery_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LogDeliveryConfiguration>>,
        ) -> Self {
            self.log_delivery_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheCluster`](crate::model::CacheCluster)
        pub fn build(self) -> crate::model::CacheCluster {
            crate::model::CacheCluster {
                cache_cluster_id: self.cache_cluster_id,
                configuration_endpoint: self.configuration_endpoint,
                client_download_landing_page: self.client_download_landing_page,
                cache_node_type: self.cache_node_type,
                engine: self.engine,
                engine_version: self.engine_version,
                cache_cluster_status: self.cache_cluster_status,
                num_cache_nodes: self.num_cache_nodes,
                preferred_availability_zone: self.preferred_availability_zone,
                preferred_outpost_arn: self.preferred_outpost_arn,
                cache_cluster_create_time: self.cache_cluster_create_time,
                preferred_maintenance_window: self.preferred_maintenance_window,
                pending_modified_values: self.pending_modified_values,
                notification_configuration: self.notification_configuration,
                cache_security_groups: self.cache_security_groups,
                cache_parameter_group: self.cache_parameter_group,
                cache_subnet_group_name: self.cache_subnet_group_name,
                cache_nodes: self.cache_nodes,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade.unwrap_or_default(),
                security_groups: self.security_groups,
                replication_group_id: self.replication_group_id,
                snapshot_retention_limit: self.snapshot_retention_limit,
                snapshot_window: self.snapshot_window,
                auth_token_enabled: self.auth_token_enabled,
                auth_token_last_modified_date: self.auth_token_last_modified_date,
                transit_encryption_enabled: self.transit_encryption_enabled,
                at_rest_encryption_enabled: self.at_rest_encryption_enabled,
                arn: self.arn,
                replication_group_log_delivery_enabled: self
                    .replication_group_log_delivery_enabled
                    .unwrap_or_default(),
                log_delivery_configurations: self.log_delivery_configurations,
            }
        }
    }
}
impl CacheCluster {
    /// Creates a new builder-style object to manufacture [`CacheCluster`](crate::model::CacheCluster)
    pub fn builder() -> crate::model::cache_cluster::Builder {
        crate::model::cache_cluster::Builder::default()
    }
}

/// <p>Represents a single cache security group and its status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityGroupMembership {
    /// <p>The identifier of the cache security group.</p>
    pub security_group_id: std::option::Option<std::string::String>,
    /// <p>The status of the cache security group membership.
    /// The status changes whenever a cache security group is modified,
    /// or when the cache security groups assigned to a cluster are modified.</p>
    pub status: std::option::Option<std::string::String>,
}
impl SecurityGroupMembership {
    /// <p>The identifier of the cache security group.</p>
    pub fn security_group_id(&self) -> std::option::Option<&str> {
        self.security_group_id.as_deref()
    }
    /// <p>The status of the cache security group membership.
    /// The status changes whenever a cache security group is modified,
    /// or when the cache security groups assigned to a cluster are modified.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for SecurityGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityGroupMembership");
        formatter.field("security_group_id", &self.security_group_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`SecurityGroupMembership`](crate::model::SecurityGroupMembership)
pub mod security_group_membership {
    /// A builder for [`SecurityGroupMembership`](crate::model::SecurityGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cache security group.</p>
        pub fn security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the cache security group.</p>
        pub fn set_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_group_id = input;
            self
        }
        /// <p>The status of the cache security group membership.
        /// The status changes whenever a cache security group is modified,
        /// or when the cache security groups assigned to a cluster are modified.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the cache security group membership.
        /// The status changes whenever a cache security group is modified,
        /// or when the cache security groups assigned to a cluster are modified.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityGroupMembership`](crate::model::SecurityGroupMembership)
        pub fn build(self) -> crate::model::SecurityGroupMembership {
            crate::model::SecurityGroupMembership {
                security_group_id: self.security_group_id,
                status: self.status,
            }
        }
    }
}
impl SecurityGroupMembership {
    /// Creates a new builder-style object to manufacture [`SecurityGroupMembership`](crate::model::SecurityGroupMembership)
    pub fn builder() -> crate::model::security_group_membership::Builder {
        crate::model::security_group_membership::Builder::default()
    }
}

/// <p>Represents an individual cache node within a cluster. Each cache node runs its own
/// instance of the cluster's protocol-compliant caching software - either Memcached or
/// Redis.</p>
///
/// <p>The following node types are supported by ElastiCache.
/// Generally speaking, the current generation types provide more memory and computational power
/// at lower cost when compared to their equivalent previous generation counterparts.</p>
/// <ul>
/// <li>
/// <p>General purpose:</p>
/// <ul>
/// <li>
/// <p>Current generation: </p>
///
///
///
///
///
/// <p>
/// <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):   <code>cache.m6g.large</code>,
/// <code>cache.m6g.xlarge</code>,
/// <code>cache.m6g.2xlarge</code>,
/// <code>cache.m6g.4xlarge</code>,
/// <code>cache.m6g.8xlarge</code>,
/// <code>cache.m6g.12xlarge</code>,
/// <code>cache.m6g.16xlarge</code>
///
///
///
/// </p>  
///
/// <note>
/// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
/// </p>
/// </note>
///
///
/// <p>
/// <b>M5 node types:</b>
/// <code>cache.m5.large</code>,
/// <code>cache.m5.xlarge</code>,
/// <code>cache.m5.2xlarge</code>,
/// <code>cache.m5.4xlarge</code>,
/// <code>cache.m5.12xlarge</code>,
/// <code>cache.m5.24xlarge</code>
///
///
/// </p>  
///
///
/// <p>
/// <b>M4 node types:</b>
/// <code>cache.m4.large</code>,
/// <code>cache.m4.xlarge</code>,
/// <code>cache.m4.2xlarge</code>,
/// <code>cache.m4.4xlarge</code>,
/// <code>cache.m4.10xlarge</code>
/// </p>
///
/// <p>
/// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):
/// <code>cache.t4g.micro</code>,
/// <code>cache.t4g.small</code>,
/// <code>cache.t4g.medium</code>
/// </p>                  
///
/// <p>
/// <b>T3 node types:</b>
/// <code>cache.t3.micro</code>,
/// <code>cache.t3.small</code>,
/// <code>cache.t3.medium</code>
/// </p>
///
///
/// <p>
/// <b>T2 node types:</b>
/// <code>cache.t2.micro</code>,
/// <code>cache.t2.small</code>,
/// <code>cache.t2.medium</code>
/// </p>
///
///
///
///
/// </li>
/// <li>
/// <p>Previous generation: (not recommended)</p>
/// <p>
/// <b>T1 node types:</b>
/// <code>cache.t1.micro</code>
/// </p>
///
/// <p>
/// <b>M1 node types:</b>
/// <code>cache.m1.small</code>,
/// <code>cache.m1.medium</code>,
/// <code>cache.m1.large</code>,
/// <code>cache.m1.xlarge</code>
/// </p>
///
/// <p>
/// <b>M3 node types:</b>
/// <code>cache.m3.medium</code>,
/// <code>cache.m3.large</code>,
/// <code>cache.m3.xlarge</code>,
/// <code>cache.m3.2xlarge</code>
/// </p>
///
/// </li>
/// </ul>
/// </li>
/// <li>
/// <p>Compute optimized:</p>
///
/// <ul>
/// <li>
/// <p>Previous generation: (not recommended)</p>
/// <p>
/// <b>C1 node types:</b>
/// <code>cache.c1.xlarge</code>
/// </p>
/// </li>
/// </ul>
/// </li>
/// <li>
/// <p>Memory optimized with data tiering:</p>
/// <ul>
/// <li>
/// <p>Current generation: </p>
///
/// <p>
/// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
///
///
///
///
/// <p>  
///
/// <code>cache.r6gd.xlarge</code>,
/// <code>cache.r6gd.2xlarge</code>,
/// <code>cache.r6gd.4xlarge</code>,
/// <code>cache.r6gd.8xlarge</code>,
/// <code>cache.r6gd.12xlarge</code>,
/// <code>cache.r6gd.16xlarge</code>
///
///
///
///
///
///
/// </p>              
///
/// </li>
/// </ul>
/// </li>
/// <li>
/// <p>Memory optimized:</p>
/// <ul>
/// <li>
/// <p>Current generation: </p>
///
///
///
/// <p>
/// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
///
///
///
///
/// <p>  
/// <code>cache.r6g.large</code>,
/// <code>cache.r6g.xlarge</code>,
/// <code>cache.r6g.2xlarge</code>,
/// <code>cache.r6g.4xlarge</code>,
/// <code>cache.r6g.8xlarge</code>,
/// <code>cache.r6g.12xlarge</code>,
/// <code>cache.r6g.16xlarge</code>
///
///
///
///
///
///
/// </p>  
/// <note>
/// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
/// </p>
/// </note>
/// <p>
/// <b>R5 node types:</b>
/// <code>cache.r5.large</code>,
/// <code>cache.r5.xlarge</code>,
/// <code>cache.r5.2xlarge</code>,
/// <code>cache.r5.4xlarge</code>,
/// <code>cache.r5.12xlarge</code>,
/// <code>cache.r5.24xlarge</code>
/// </p>
///
/// <p>
/// <b>R4 node types:</b>
/// <code>cache.r4.large</code>,
/// <code>cache.r4.xlarge</code>,
/// <code>cache.r4.2xlarge</code>,
/// <code>cache.r4.4xlarge</code>,
/// <code>cache.r4.8xlarge</code>,
/// <code>cache.r4.16xlarge</code>
/// </p>
///
///
///
///
///
///
///
///
///
///
///
/// </li>
/// <li>
/// <p>Previous generation: (not recommended)</p>
/// <p>
/// <b>M2 node types:</b>            
/// <code>cache.m2.xlarge</code>,
/// <code>cache.m2.2xlarge</code>,
/// <code>cache.m2.4xlarge</code>
/// </p>
///
/// <p>
/// <b>R3 node types:</b>
/// <code>cache.r3.large</code>,
/// <code>cache.r3.xlarge</code>,
/// <code>cache.r3.2xlarge</code>,  
/// <code>cache.r3.4xlarge</code>,
/// <code>cache.r3.8xlarge</code>
/// </p>
///
/// </li>
/// </ul>
/// </li>
/// </ul>
///
/// <p>
/// <b>Additional node type info</b>
/// </p>
/// <ul>
/// <li>
/// <p>All current generation instance types are created in Amazon VPC by default.</p>
/// </li>
/// <li>
/// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
/// </li>
/// <li>
/// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
/// </li>
/// <li>
/// <p>Redis configuration variables <code>appendonly</code> and
/// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheNode {
    /// <p>The cache node identifier. A node ID is a numeric identifier (0001, 0002, etc.). The combination of cluster ID and node ID uniquely identifies every cache node used in a customer's Amazon account.</p>
    pub cache_node_id: std::option::Option<std::string::String>,
    /// <p>The current state of this cache node, one of the following values: <code>available</code>, <code>creating</code>, <code>rebooting</code>, or <code>deleting</code>.</p>
    pub cache_node_status: std::option::Option<std::string::String>,
    /// <p>The date and time when the cache node was created.</p>
    pub cache_node_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The hostname for connecting to this cache node.</p>
    pub endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>The status of the parameter group applied to this cache node.</p>
    pub parameter_group_status: std::option::Option<std::string::String>,
    /// <p>The ID of the primary node to which this read replica node is synchronized.
    /// If this field is empty, this node is not associated with a primary cluster.</p>
    pub source_cache_node_id: std::option::Option<std::string::String>,
    /// <p>The Availability Zone where this node was created and now resides.</p>
    pub customer_availability_zone: std::option::Option<std::string::String>,
    /// <p>The customer outpost ARN of the cache node.</p>
    pub customer_outpost_arn: std::option::Option<std::string::String>,
}
impl CacheNode {
    /// <p>The cache node identifier. A node ID is a numeric identifier (0001, 0002, etc.). The combination of cluster ID and node ID uniquely identifies every cache node used in a customer's Amazon account.</p>
    pub fn cache_node_id(&self) -> std::option::Option<&str> {
        self.cache_node_id.as_deref()
    }
    /// <p>The current state of this cache node, one of the following values: <code>available</code>, <code>creating</code>, <code>rebooting</code>, or <code>deleting</code>.</p>
    pub fn cache_node_status(&self) -> std::option::Option<&str> {
        self.cache_node_status.as_deref()
    }
    /// <p>The date and time when the cache node was created.</p>
    pub fn cache_node_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.cache_node_create_time.as_ref()
    }
    /// <p>The hostname for connecting to this cache node.</p>
    pub fn endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.endpoint.as_ref()
    }
    /// <p>The status of the parameter group applied to this cache node.</p>
    pub fn parameter_group_status(&self) -> std::option::Option<&str> {
        self.parameter_group_status.as_deref()
    }
    /// <p>The ID of the primary node to which this read replica node is synchronized.
    /// If this field is empty, this node is not associated with a primary cluster.</p>
    pub fn source_cache_node_id(&self) -> std::option::Option<&str> {
        self.source_cache_node_id.as_deref()
    }
    /// <p>The Availability Zone where this node was created and now resides.</p>
    pub fn customer_availability_zone(&self) -> std::option::Option<&str> {
        self.customer_availability_zone.as_deref()
    }
    /// <p>The customer outpost ARN of the cache node.</p>
    pub fn customer_outpost_arn(&self) -> std::option::Option<&str> {
        self.customer_outpost_arn.as_deref()
    }
}
impl std::fmt::Debug for CacheNode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheNode");
        formatter.field("cache_node_id", &self.cache_node_id);
        formatter.field("cache_node_status", &self.cache_node_status);
        formatter.field("cache_node_create_time", &self.cache_node_create_time);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("parameter_group_status", &self.parameter_group_status);
        formatter.field("source_cache_node_id", &self.source_cache_node_id);
        formatter.field(
            "customer_availability_zone",
            &self.customer_availability_zone,
        );
        formatter.field("customer_outpost_arn", &self.customer_outpost_arn);
        formatter.finish()
    }
}
/// See [`CacheNode`](crate::model::CacheNode)
pub mod cache_node {
    /// A builder for [`CacheNode`](crate::model::CacheNode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_node_id: std::option::Option<std::string::String>,
        pub(crate) cache_node_status: std::option::Option<std::string::String>,
        pub(crate) cache_node_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) parameter_group_status: std::option::Option<std::string::String>,
        pub(crate) source_cache_node_id: std::option::Option<std::string::String>,
        pub(crate) customer_availability_zone: std::option::Option<std::string::String>,
        pub(crate) customer_outpost_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cache node identifier. A node ID is a numeric identifier (0001, 0002, etc.). The combination of cluster ID and node ID uniquely identifies every cache node used in a customer's Amazon account.</p>
        pub fn cache_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_id = Some(input.into());
            self
        }
        /// <p>The cache node identifier. A node ID is a numeric identifier (0001, 0002, etc.). The combination of cluster ID and node ID uniquely identifies every cache node used in a customer's Amazon account.</p>
        pub fn set_cache_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_id = input;
            self
        }
        /// <p>The current state of this cache node, one of the following values: <code>available</code>, <code>creating</code>, <code>rebooting</code>, or <code>deleting</code>.</p>
        pub fn cache_node_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_status = Some(input.into());
            self
        }
        /// <p>The current state of this cache node, one of the following values: <code>available</code>, <code>creating</code>, <code>rebooting</code>, or <code>deleting</code>.</p>
        pub fn set_cache_node_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_status = input;
            self
        }
        /// <p>The date and time when the cache node was created.</p>
        pub fn cache_node_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.cache_node_create_time = Some(input);
            self
        }
        /// <p>The date and time when the cache node was created.</p>
        pub fn set_cache_node_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.cache_node_create_time = input;
            self
        }
        /// <p>The hostname for connecting to this cache node.</p>
        pub fn endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.endpoint = Some(input);
            self
        }
        /// <p>The hostname for connecting to this cache node.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<crate::model::Endpoint>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The status of the parameter group applied to this cache node.</p>
        pub fn parameter_group_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_status = Some(input.into());
            self
        }
        /// <p>The status of the parameter group applied to this cache node.</p>
        pub fn set_parameter_group_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_status = input;
            self
        }
        /// <p>The ID of the primary node to which this read replica node is synchronized.
        /// If this field is empty, this node is not associated with a primary cluster.</p>
        pub fn source_cache_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_cache_node_id = Some(input.into());
            self
        }
        /// <p>The ID of the primary node to which this read replica node is synchronized.
        /// If this field is empty, this node is not associated with a primary cluster.</p>
        pub fn set_source_cache_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_cache_node_id = input;
            self
        }
        /// <p>The Availability Zone where this node was created and now resides.</p>
        pub fn customer_availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone where this node was created and now resides.</p>
        pub fn set_customer_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_availability_zone = input;
            self
        }
        /// <p>The customer outpost ARN of the cache node.</p>
        pub fn customer_outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_outpost_arn = Some(input.into());
            self
        }
        /// <p>The customer outpost ARN of the cache node.</p>
        pub fn set_customer_outpost_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_outpost_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheNode`](crate::model::CacheNode)
        pub fn build(self) -> crate::model::CacheNode {
            crate::model::CacheNode {
                cache_node_id: self.cache_node_id,
                cache_node_status: self.cache_node_status,
                cache_node_create_time: self.cache_node_create_time,
                endpoint: self.endpoint,
                parameter_group_status: self.parameter_group_status,
                source_cache_node_id: self.source_cache_node_id,
                customer_availability_zone: self.customer_availability_zone,
                customer_outpost_arn: self.customer_outpost_arn,
            }
        }
    }
}
impl CacheNode {
    /// Creates a new builder-style object to manufacture [`CacheNode`](crate::model::CacheNode)
    pub fn builder() -> crate::model::cache_node::Builder {
        crate::model::cache_node::Builder::default()
    }
}

/// <p>Status of the cache parameter group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheParameterGroupStatus {
    /// <p>The name of the cache parameter group.</p>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The status of parameter updates.</p>
    pub parameter_apply_status: std::option::Option<std::string::String>,
    /// <p>A list of the cache node IDs which need to be rebooted for parameter changes to be applied.
    /// A node ID is a numeric identifier (0001, 0002, etc.).</p>
    pub cache_node_ids_to_reboot: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CacheParameterGroupStatus {
    /// <p>The name of the cache parameter group.</p>
    pub fn cache_parameter_group_name(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_name.as_deref()
    }
    /// <p>The status of parameter updates.</p>
    pub fn parameter_apply_status(&self) -> std::option::Option<&str> {
        self.parameter_apply_status.as_deref()
    }
    /// <p>A list of the cache node IDs which need to be rebooted for parameter changes to be applied.
    /// A node ID is a numeric identifier (0001, 0002, etc.).</p>
    pub fn cache_node_ids_to_reboot(&self) -> std::option::Option<&[std::string::String]> {
        self.cache_node_ids_to_reboot.as_deref()
    }
}
impl std::fmt::Debug for CacheParameterGroupStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheParameterGroupStatus");
        formatter.field(
            "cache_parameter_group_name",
            &self.cache_parameter_group_name,
        );
        formatter.field("parameter_apply_status", &self.parameter_apply_status);
        formatter.field("cache_node_ids_to_reboot", &self.cache_node_ids_to_reboot);
        formatter.finish()
    }
}
/// See [`CacheParameterGroupStatus`](crate::model::CacheParameterGroupStatus)
pub mod cache_parameter_group_status {
    /// A builder for [`CacheParameterGroupStatus`](crate::model::CacheParameterGroupStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameter_apply_status: std::option::Option<std::string::String>,
        pub(crate) cache_node_ids_to_reboot:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the cache parameter group.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// <p>The status of parameter updates.</p>
        pub fn parameter_apply_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_apply_status = Some(input.into());
            self
        }
        /// <p>The status of parameter updates.</p>
        pub fn set_parameter_apply_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_apply_status = input;
            self
        }
        /// Appends an item to `cache_node_ids_to_reboot`.
        ///
        /// To override the contents of this collection use [`set_cache_node_ids_to_reboot`](Self::set_cache_node_ids_to_reboot).
        ///
        /// <p>A list of the cache node IDs which need to be rebooted for parameter changes to be applied.
        /// A node ID is a numeric identifier (0001, 0002, etc.).</p>
        pub fn cache_node_ids_to_reboot(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_node_ids_to_reboot.unwrap_or_default();
            v.push(input.into());
            self.cache_node_ids_to_reboot = Some(v);
            self
        }
        /// <p>A list of the cache node IDs which need to be rebooted for parameter changes to be applied.
        /// A node ID is a numeric identifier (0001, 0002, etc.).</p>
        pub fn set_cache_node_ids_to_reboot(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_node_ids_to_reboot = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheParameterGroupStatus`](crate::model::CacheParameterGroupStatus)
        pub fn build(self) -> crate::model::CacheParameterGroupStatus {
            crate::model::CacheParameterGroupStatus {
                cache_parameter_group_name: self.cache_parameter_group_name,
                parameter_apply_status: self.parameter_apply_status,
                cache_node_ids_to_reboot: self.cache_node_ids_to_reboot,
            }
        }
    }
}
impl CacheParameterGroupStatus {
    /// Creates a new builder-style object to manufacture [`CacheParameterGroupStatus`](crate::model::CacheParameterGroupStatus)
    pub fn builder() -> crate::model::cache_parameter_group_status::Builder {
        crate::model::cache_parameter_group_status::Builder::default()
    }
}

/// <p>Represents a cluster's status within a particular cache security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheSecurityGroupMembership {
    /// <p>The name of the cache security group.</p>
    pub cache_security_group_name: std::option::Option<std::string::String>,
    /// <p>The membership status in the cache security group. The status changes when a cache security group is modified, or when the cache security groups assigned to a cluster are modified.</p>
    pub status: std::option::Option<std::string::String>,
}
impl CacheSecurityGroupMembership {
    /// <p>The name of the cache security group.</p>
    pub fn cache_security_group_name(&self) -> std::option::Option<&str> {
        self.cache_security_group_name.as_deref()
    }
    /// <p>The membership status in the cache security group. The status changes when a cache security group is modified, or when the cache security groups assigned to a cluster are modified.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for CacheSecurityGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheSecurityGroupMembership");
        formatter.field("cache_security_group_name", &self.cache_security_group_name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CacheSecurityGroupMembership`](crate::model::CacheSecurityGroupMembership)
pub mod cache_security_group_membership {
    /// A builder for [`CacheSecurityGroupMembership`](crate::model::CacheSecurityGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_security_group_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cache security group.</p>
        pub fn cache_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache security group.</p>
        pub fn set_cache_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_security_group_name = input;
            self
        }
        /// <p>The membership status in the cache security group. The status changes when a cache security group is modified, or when the cache security groups assigned to a cluster are modified.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The membership status in the cache security group. The status changes when a cache security group is modified, or when the cache security groups assigned to a cluster are modified.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheSecurityGroupMembership`](crate::model::CacheSecurityGroupMembership)
        pub fn build(self) -> crate::model::CacheSecurityGroupMembership {
            crate::model::CacheSecurityGroupMembership {
                cache_security_group_name: self.cache_security_group_name,
                status: self.status,
            }
        }
    }
}
impl CacheSecurityGroupMembership {
    /// Creates a new builder-style object to manufacture [`CacheSecurityGroupMembership`](crate::model::CacheSecurityGroupMembership)
    pub fn builder() -> crate::model::cache_security_group_membership::Builder {
        crate::model::cache_security_group_membership::Builder::default()
    }
}

/// <p>Describes a notification topic and its status.
/// Notification topics are used for publishing ElastiCache events to subscribers
/// using Amazon Simple Notification Service (SNS).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationConfiguration {
    /// <p>The Amazon Resource Name (ARN) that identifies the topic.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The current state of the topic.</p>
    pub topic_status: std::option::Option<std::string::String>,
}
impl NotificationConfiguration {
    /// <p>The Amazon Resource Name (ARN) that identifies the topic.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>The current state of the topic.</p>
    pub fn topic_status(&self) -> std::option::Option<&str> {
        self.topic_status.as_deref()
    }
}
impl std::fmt::Debug for NotificationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationConfiguration");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("topic_status", &self.topic_status);
        formatter.finish()
    }
}
/// See [`NotificationConfiguration`](crate::model::NotificationConfiguration)
pub mod notification_configuration {
    /// A builder for [`NotificationConfiguration`](crate::model::NotificationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) topic_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the topic.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the topic.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>The current state of the topic.</p>
        pub fn topic_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_status = Some(input.into());
            self
        }
        /// <p>The current state of the topic.</p>
        pub fn set_topic_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_status = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationConfiguration`](crate::model::NotificationConfiguration)
        pub fn build(self) -> crate::model::NotificationConfiguration {
            crate::model::NotificationConfiguration {
                topic_arn: self.topic_arn,
                topic_status: self.topic_status,
            }
        }
    }
}
impl NotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`NotificationConfiguration`](crate::model::NotificationConfiguration)
    pub fn builder() -> crate::model::notification_configuration::Builder {
        crate::model::notification_configuration::Builder::default()
    }
}

/// <p>A group of settings that are applied to the cluster in the future,
/// or that are currently being applied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingModifiedValues {
    /// <p>The new number of cache nodes for the cluster.</p>
    /// <p>For clusters running Redis, this value must be 1.
    /// For clusters running Memcached, this value must be between 1 and 40.</p>
    pub num_cache_nodes: std::option::Option<i32>,
    /// <p>A list of cache node IDs that are being removed (or will be removed) from the cluster.
    /// A node ID is a 4-digit numeric identifier (0001, 0002, etc.).</p>
    pub cache_node_ids_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The new cache engine version that the cluster  runs.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The cache node type that this cluster or replication group is scaled to.</p>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>The auth token status</p>
    pub auth_token_status: std::option::Option<crate::model::AuthTokenUpdateStatus>,
    /// <p>The log delivery configurations being modified </p>
    pub log_delivery_configurations:
        std::option::Option<std::vec::Vec<crate::model::PendingLogDeliveryConfiguration>>,
}
impl PendingModifiedValues {
    /// <p>The new number of cache nodes for the cluster.</p>
    /// <p>For clusters running Redis, this value must be 1.
    /// For clusters running Memcached, this value must be between 1 and 40.</p>
    pub fn num_cache_nodes(&self) -> std::option::Option<i32> {
        self.num_cache_nodes
    }
    /// <p>A list of cache node IDs that are being removed (or will be removed) from the cluster.
    /// A node ID is a 4-digit numeric identifier (0001, 0002, etc.).</p>
    pub fn cache_node_ids_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.cache_node_ids_to_remove.as_deref()
    }
    /// <p>The new cache engine version that the cluster  runs.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The cache node type that this cluster or replication group is scaled to.</p>
    pub fn cache_node_type(&self) -> std::option::Option<&str> {
        self.cache_node_type.as_deref()
    }
    /// <p>The auth token status</p>
    pub fn auth_token_status(&self) -> std::option::Option<&crate::model::AuthTokenUpdateStatus> {
        self.auth_token_status.as_ref()
    }
    /// <p>The log delivery configurations being modified </p>
    pub fn log_delivery_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::PendingLogDeliveryConfiguration]> {
        self.log_delivery_configurations.as_deref()
    }
}
impl std::fmt::Debug for PendingModifiedValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingModifiedValues");
        formatter.field("num_cache_nodes", &self.num_cache_nodes);
        formatter.field("cache_node_ids_to_remove", &self.cache_node_ids_to_remove);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("cache_node_type", &self.cache_node_type);
        formatter.field("auth_token_status", &self.auth_token_status);
        formatter.field(
            "log_delivery_configurations",
            &self.log_delivery_configurations,
        );
        formatter.finish()
    }
}
/// See [`PendingModifiedValues`](crate::model::PendingModifiedValues)
pub mod pending_modified_values {
    /// A builder for [`PendingModifiedValues`](crate::model::PendingModifiedValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) num_cache_nodes: std::option::Option<i32>,
        pub(crate) cache_node_ids_to_remove:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) auth_token_status: std::option::Option<crate::model::AuthTokenUpdateStatus>,
        pub(crate) log_delivery_configurations:
            std::option::Option<std::vec::Vec<crate::model::PendingLogDeliveryConfiguration>>,
    }
    impl Builder {
        /// <p>The new number of cache nodes for the cluster.</p>
        /// <p>For clusters running Redis, this value must be 1.
        /// For clusters running Memcached, this value must be between 1 and 40.</p>
        pub fn num_cache_nodes(mut self, input: i32) -> Self {
            self.num_cache_nodes = Some(input);
            self
        }
        /// <p>The new number of cache nodes for the cluster.</p>
        /// <p>For clusters running Redis, this value must be 1.
        /// For clusters running Memcached, this value must be between 1 and 40.</p>
        pub fn set_num_cache_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.num_cache_nodes = input;
            self
        }
        /// Appends an item to `cache_node_ids_to_remove`.
        ///
        /// To override the contents of this collection use [`set_cache_node_ids_to_remove`](Self::set_cache_node_ids_to_remove).
        ///
        /// <p>A list of cache node IDs that are being removed (or will be removed) from the cluster.
        /// A node ID is a 4-digit numeric identifier (0001, 0002, etc.).</p>
        pub fn cache_node_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cache_node_ids_to_remove.unwrap_or_default();
            v.push(input.into());
            self.cache_node_ids_to_remove = Some(v);
            self
        }
        /// <p>A list of cache node IDs that are being removed (or will be removed) from the cluster.
        /// A node ID is a 4-digit numeric identifier (0001, 0002, etc.).</p>
        pub fn set_cache_node_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cache_node_ids_to_remove = input;
            self
        }
        /// <p>The new cache engine version that the cluster  runs.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The new cache engine version that the cluster  runs.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The cache node type that this cluster or replication group is scaled to.</p>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>The cache node type that this cluster or replication group is scaled to.</p>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>The auth token status</p>
        pub fn auth_token_status(mut self, input: crate::model::AuthTokenUpdateStatus) -> Self {
            self.auth_token_status = Some(input);
            self
        }
        /// <p>The auth token status</p>
        pub fn set_auth_token_status(
            mut self,
            input: std::option::Option<crate::model::AuthTokenUpdateStatus>,
        ) -> Self {
            self.auth_token_status = input;
            self
        }
        /// Appends an item to `log_delivery_configurations`.
        ///
        /// To override the contents of this collection use [`set_log_delivery_configurations`](Self::set_log_delivery_configurations).
        ///
        /// <p>The log delivery configurations being modified </p>
        pub fn log_delivery_configurations(
            mut self,
            input: impl Into<crate::model::PendingLogDeliveryConfiguration>,
        ) -> Self {
            let mut v = self.log_delivery_configurations.unwrap_or_default();
            v.push(input.into());
            self.log_delivery_configurations = Some(v);
            self
        }
        /// <p>The log delivery configurations being modified </p>
        pub fn set_log_delivery_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::PendingLogDeliveryConfiguration>,
            >,
        ) -> Self {
            self.log_delivery_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingModifiedValues`](crate::model::PendingModifiedValues)
        pub fn build(self) -> crate::model::PendingModifiedValues {
            crate::model::PendingModifiedValues {
                num_cache_nodes: self.num_cache_nodes,
                cache_node_ids_to_remove: self.cache_node_ids_to_remove,
                engine_version: self.engine_version,
                cache_node_type: self.cache_node_type,
                auth_token_status: self.auth_token_status,
                log_delivery_configurations: self.log_delivery_configurations,
            }
        }
    }
}
impl PendingModifiedValues {
    /// Creates a new builder-style object to manufacture [`PendingModifiedValues`](crate::model::PendingModifiedValues)
    pub fn builder() -> crate::model::pending_modified_values::Builder {
        crate::model::pending_modified_values::Builder::default()
    }
}

/// <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
/// cluster automatically replicates updates to the secondary cluster.</p>
///
///
/// <ul>
/// <li>
/// <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore,
/// which is what you use to associate a secondary cluster.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalReplicationGroup {
    /// <p>The name of the Global datastore</p>
    pub global_replication_group_id: std::option::Option<std::string::String>,
    /// <p>The optional description of the Global datastore</p>
    pub global_replication_group_description: std::option::Option<std::string::String>,
    /// <p>The status of the Global datastore</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The cache node type of the Global datastore</p>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>The Elasticache engine. For Redis only.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The Elasticache Redis engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The replication groups that comprise the Global datastore.</p>
    pub members: std::option::Option<std::vec::Vec<crate::model::GlobalReplicationGroupMember>>,
    /// <p>A flag that indicates whether the Global datastore is cluster enabled.</p>
    pub cluster_enabled: std::option::Option<bool>,
    /// <p>Indicates the slot configuration and global identifier for each slice group.</p>
    pub global_node_groups: std::option::Option<std::vec::Vec<crate::model::GlobalNodeGroup>>,
    /// <p>A flag that enables using an <code>AuthToken</code> (password)
    /// when issuing Redis commands.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub auth_token_enabled: std::option::Option<bool>,
    /// <p>A flag that enables in-transit encryption when set to true.
    ///
    /// You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to true when you create a cluster. </p>
    /// <p>
    /// <b>Required:</b>
    /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    pub transit_encryption_enabled: std::option::Option<bool>,
    /// <p>A flag that enables encryption at rest when set to <code>true</code>.</p>
    /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication
    /// group is created.
    /// To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
    /// <code>true</code> when you create the replication group. </p>
    /// <p>
    /// <b>Required:</b>
    /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    pub at_rest_encryption_enabled: std::option::Option<bool>,
    /// <p>The ARN (Amazon Resource Name) of the global replication group.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GlobalReplicationGroup {
    /// <p>The name of the Global datastore</p>
    pub fn global_replication_group_id(&self) -> std::option::Option<&str> {
        self.global_replication_group_id.as_deref()
    }
    /// <p>The optional description of the Global datastore</p>
    pub fn global_replication_group_description(&self) -> std::option::Option<&str> {
        self.global_replication_group_description.as_deref()
    }
    /// <p>The status of the Global datastore</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The cache node type of the Global datastore</p>
    pub fn cache_node_type(&self) -> std::option::Option<&str> {
        self.cache_node_type.as_deref()
    }
    /// <p>The Elasticache engine. For Redis only.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The Elasticache Redis engine version.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The replication groups that comprise the Global datastore.</p>
    pub fn members(&self) -> std::option::Option<&[crate::model::GlobalReplicationGroupMember]> {
        self.members.as_deref()
    }
    /// <p>A flag that indicates whether the Global datastore is cluster enabled.</p>
    pub fn cluster_enabled(&self) -> std::option::Option<bool> {
        self.cluster_enabled
    }
    /// <p>Indicates the slot configuration and global identifier for each slice group.</p>
    pub fn global_node_groups(&self) -> std::option::Option<&[crate::model::GlobalNodeGroup]> {
        self.global_node_groups.as_deref()
    }
    /// <p>A flag that enables using an <code>AuthToken</code> (password)
    /// when issuing Redis commands.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub fn auth_token_enabled(&self) -> std::option::Option<bool> {
        self.auth_token_enabled
    }
    /// <p>A flag that enables in-transit encryption when set to true.
    ///
    /// You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to true when you create a cluster. </p>
    /// <p>
    /// <b>Required:</b>
    /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    pub fn transit_encryption_enabled(&self) -> std::option::Option<bool> {
        self.transit_encryption_enabled
    }
    /// <p>A flag that enables encryption at rest when set to <code>true</code>.</p>
    /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication
    /// group is created.
    /// To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
    /// <code>true</code> when you create the replication group. </p>
    /// <p>
    /// <b>Required:</b>
    /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
    pub fn at_rest_encryption_enabled(&self) -> std::option::Option<bool> {
        self.at_rest_encryption_enabled
    }
    /// <p>The ARN (Amazon Resource Name) of the global replication group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GlobalReplicationGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalReplicationGroup");
        formatter.field(
            "global_replication_group_id",
            &self.global_replication_group_id,
        );
        formatter.field(
            "global_replication_group_description",
            &self.global_replication_group_description,
        );
        formatter.field("status", &self.status);
        formatter.field("cache_node_type", &self.cache_node_type);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("members", &self.members);
        formatter.field("cluster_enabled", &self.cluster_enabled);
        formatter.field("global_node_groups", &self.global_node_groups);
        formatter.field("auth_token_enabled", &self.auth_token_enabled);
        formatter.field(
            "transit_encryption_enabled",
            &self.transit_encryption_enabled,
        );
        formatter.field(
            "at_rest_encryption_enabled",
            &self.at_rest_encryption_enabled,
        );
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`GlobalReplicationGroup`](crate::model::GlobalReplicationGroup)
pub mod global_replication_group {
    /// A builder for [`GlobalReplicationGroup`](crate::model::GlobalReplicationGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_replication_group_id: std::option::Option<std::string::String>,
        pub(crate) global_replication_group_description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) members:
            std::option::Option<std::vec::Vec<crate::model::GlobalReplicationGroupMember>>,
        pub(crate) cluster_enabled: std::option::Option<bool>,
        pub(crate) global_node_groups:
            std::option::Option<std::vec::Vec<crate::model::GlobalNodeGroup>>,
        pub(crate) auth_token_enabled: std::option::Option<bool>,
        pub(crate) transit_encryption_enabled: std::option::Option<bool>,
        pub(crate) at_rest_encryption_enabled: std::option::Option<bool>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_id = input;
            self
        }
        /// <p>The optional description of the Global datastore</p>
        pub fn global_replication_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.global_replication_group_description = Some(input.into());
            self
        }
        /// <p>The optional description of the Global datastore</p>
        pub fn set_global_replication_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_replication_group_description = input;
            self
        }
        /// <p>The status of the Global datastore</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the Global datastore</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The cache node type of the Global datastore</p>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>The cache node type of the Global datastore</p>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>The Elasticache engine. For Redis only.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The Elasticache engine. For Redis only.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The Elasticache Redis engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The Elasticache Redis engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// Appends an item to `members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>The replication groups that comprise the Global datastore.</p>
        pub fn members(
            mut self,
            input: impl Into<crate::model::GlobalReplicationGroupMember>,
        ) -> Self {
            let mut v = self.members.unwrap_or_default();
            v.push(input.into());
            self.members = Some(v);
            self
        }
        /// <p>The replication groups that comprise the Global datastore.</p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalReplicationGroupMember>>,
        ) -> Self {
            self.members = input;
            self
        }
        /// <p>A flag that indicates whether the Global datastore is cluster enabled.</p>
        pub fn cluster_enabled(mut self, input: bool) -> Self {
            self.cluster_enabled = Some(input);
            self
        }
        /// <p>A flag that indicates whether the Global datastore is cluster enabled.</p>
        pub fn set_cluster_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cluster_enabled = input;
            self
        }
        /// Appends an item to `global_node_groups`.
        ///
        /// To override the contents of this collection use [`set_global_node_groups`](Self::set_global_node_groups).
        ///
        /// <p>Indicates the slot configuration and global identifier for each slice group.</p>
        pub fn global_node_groups(
            mut self,
            input: impl Into<crate::model::GlobalNodeGroup>,
        ) -> Self {
            let mut v = self.global_node_groups.unwrap_or_default();
            v.push(input.into());
            self.global_node_groups = Some(v);
            self
        }
        /// <p>Indicates the slot configuration and global identifier for each slice group.</p>
        pub fn set_global_node_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalNodeGroup>>,
        ) -> Self {
            self.global_node_groups = input;
            self
        }
        /// <p>A flag that enables using an <code>AuthToken</code> (password)
        /// when issuing Redis commands.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn auth_token_enabled(mut self, input: bool) -> Self {
            self.auth_token_enabled = Some(input);
            self
        }
        /// <p>A flag that enables using an <code>AuthToken</code> (password)
        /// when issuing Redis commands.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_auth_token_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.auth_token_enabled = input;
            self
        }
        /// <p>A flag that enables in-transit encryption when set to true.
        ///
        /// You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to true when you create a cluster. </p>
        /// <p>
        /// <b>Required:</b>
        /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        pub fn transit_encryption_enabled(mut self, input: bool) -> Self {
            self.transit_encryption_enabled = Some(input);
            self
        }
        /// <p>A flag that enables in-transit encryption when set to true.
        ///
        /// You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to true when you create a cluster. </p>
        /// <p>
        /// <b>Required:</b>
        /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        pub fn set_transit_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.transit_encryption_enabled = input;
            self
        }
        /// <p>A flag that enables encryption at rest when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication
        /// group is created.
        /// To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
        /// <code>true</code> when you create the replication group. </p>
        /// <p>
        /// <b>Required:</b>
        /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        pub fn at_rest_encryption_enabled(mut self, input: bool) -> Self {
            self.at_rest_encryption_enabled = Some(input);
            self
        }
        /// <p>A flag that enables encryption at rest when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication
        /// group is created.
        /// To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
        /// <code>true</code> when you create the replication group. </p>
        /// <p>
        /// <b>Required:</b>
        /// Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        pub fn set_at_rest_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.at_rest_encryption_enabled = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the global replication group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the global replication group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalReplicationGroup`](crate::model::GlobalReplicationGroup)
        pub fn build(self) -> crate::model::GlobalReplicationGroup {
            crate::model::GlobalReplicationGroup {
                global_replication_group_id: self.global_replication_group_id,
                global_replication_group_description: self.global_replication_group_description,
                status: self.status,
                cache_node_type: self.cache_node_type,
                engine: self.engine,
                engine_version: self.engine_version,
                members: self.members,
                cluster_enabled: self.cluster_enabled,
                global_node_groups: self.global_node_groups,
                auth_token_enabled: self.auth_token_enabled,
                transit_encryption_enabled: self.transit_encryption_enabled,
                at_rest_encryption_enabled: self.at_rest_encryption_enabled,
                arn: self.arn,
            }
        }
    }
}
impl GlobalReplicationGroup {
    /// Creates a new builder-style object to manufacture [`GlobalReplicationGroup`](crate::model::GlobalReplicationGroup)
    pub fn builder() -> crate::model::global_replication_group::Builder {
        crate::model::global_replication_group::Builder::default()
    }
}

/// <p>Indicates the slot configuration and global identifier for a slice group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalNodeGroup {
    /// <p>The name of the global node group</p>
    pub global_node_group_id: std::option::Option<std::string::String>,
    /// <p>The keyspace for this node group</p>
    pub slots: std::option::Option<std::string::String>,
}
impl GlobalNodeGroup {
    /// <p>The name of the global node group</p>
    pub fn global_node_group_id(&self) -> std::option::Option<&str> {
        self.global_node_group_id.as_deref()
    }
    /// <p>The keyspace for this node group</p>
    pub fn slots(&self) -> std::option::Option<&str> {
        self.slots.as_deref()
    }
}
impl std::fmt::Debug for GlobalNodeGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalNodeGroup");
        formatter.field("global_node_group_id", &self.global_node_group_id);
        formatter.field("slots", &self.slots);
        formatter.finish()
    }
}
/// See [`GlobalNodeGroup`](crate::model::GlobalNodeGroup)
pub mod global_node_group {
    /// A builder for [`GlobalNodeGroup`](crate::model::GlobalNodeGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_node_group_id: std::option::Option<std::string::String>,
        pub(crate) slots: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the global node group</p>
        pub fn global_node_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_node_group_id = Some(input.into());
            self
        }
        /// <p>The name of the global node group</p>
        pub fn set_global_node_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_node_group_id = input;
            self
        }
        /// <p>The keyspace for this node group</p>
        pub fn slots(mut self, input: impl Into<std::string::String>) -> Self {
            self.slots = Some(input.into());
            self
        }
        /// <p>The keyspace for this node group</p>
        pub fn set_slots(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slots = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalNodeGroup`](crate::model::GlobalNodeGroup)
        pub fn build(self) -> crate::model::GlobalNodeGroup {
            crate::model::GlobalNodeGroup {
                global_node_group_id: self.global_node_group_id,
                slots: self.slots,
            }
        }
    }
}
impl GlobalNodeGroup {
    /// Creates a new builder-style object to manufacture [`GlobalNodeGroup`](crate::model::GlobalNodeGroup)
    pub fn builder() -> crate::model::global_node_group::Builder {
        crate::model::global_node_group::Builder::default()
    }
}

/// <p>A member of a Global datastore. It contains the Replication Group Id, the Amazon region and the role of the replication group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalReplicationGroupMember {
    /// <p>The replication group id of the Global datastore member.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The Amazon region of the Global datastore member.</p>
    pub replication_group_region: std::option::Option<std::string::String>,
    /// <p>Indicates the role of the replication group, primary or secondary.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>Indicates whether automatic failover is enabled for the replication group.</p>
    pub automatic_failover: std::option::Option<crate::model::AutomaticFailoverStatus>,
    /// <p>The status of the membership of the replication group.</p>
    pub status: std::option::Option<std::string::String>,
}
impl GlobalReplicationGroupMember {
    /// <p>The replication group id of the Global datastore member.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The Amazon region of the Global datastore member.</p>
    pub fn replication_group_region(&self) -> std::option::Option<&str> {
        self.replication_group_region.as_deref()
    }
    /// <p>Indicates the role of the replication group, primary or secondary.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>Indicates whether automatic failover is enabled for the replication group.</p>
    pub fn automatic_failover(
        &self,
    ) -> std::option::Option<&crate::model::AutomaticFailoverStatus> {
        self.automatic_failover.as_ref()
    }
    /// <p>The status of the membership of the replication group.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for GlobalReplicationGroupMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalReplicationGroupMember");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("replication_group_region", &self.replication_group_region);
        formatter.field("role", &self.role);
        formatter.field("automatic_failover", &self.automatic_failover);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GlobalReplicationGroupMember`](crate::model::GlobalReplicationGroupMember)
pub mod global_replication_group_member {
    /// A builder for [`GlobalReplicationGroupMember`](crate::model::GlobalReplicationGroupMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) replication_group_region: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) automatic_failover: std::option::Option<crate::model::AutomaticFailoverStatus>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The replication group id of the Global datastore member.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The replication group id of the Global datastore member.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The Amazon region of the Global datastore member.</p>
        pub fn replication_group_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_region = Some(input.into());
            self
        }
        /// <p>The Amazon region of the Global datastore member.</p>
        pub fn set_replication_group_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_region = input;
            self
        }
        /// <p>Indicates the role of the replication group, primary or secondary.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>Indicates the role of the replication group, primary or secondary.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>Indicates whether automatic failover is enabled for the replication group.</p>
        pub fn automatic_failover(mut self, input: crate::model::AutomaticFailoverStatus) -> Self {
            self.automatic_failover = Some(input);
            self
        }
        /// <p>Indicates whether automatic failover is enabled for the replication group.</p>
        pub fn set_automatic_failover(
            mut self,
            input: std::option::Option<crate::model::AutomaticFailoverStatus>,
        ) -> Self {
            self.automatic_failover = input;
            self
        }
        /// <p>The status of the membership of the replication group.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the membership of the replication group.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalReplicationGroupMember`](crate::model::GlobalReplicationGroupMember)
        pub fn build(self) -> crate::model::GlobalReplicationGroupMember {
            crate::model::GlobalReplicationGroupMember {
                replication_group_id: self.replication_group_id,
                replication_group_region: self.replication_group_region,
                role: self.role,
                automatic_failover: self.automatic_failover,
                status: self.status,
            }
        }
    }
}
impl GlobalReplicationGroupMember {
    /// Creates a new builder-style object to manufacture [`GlobalReplicationGroupMember`](crate::model::GlobalReplicationGroupMember)
    pub fn builder() -> crate::model::global_replication_group_member::Builder {
        crate::model::global_replication_group_member::Builder::default()
    }
}

/// <p>Represents the output of a <code>PurchaseReservedCacheNodesOffering</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedCacheNode {
    /// <p>The unique identifier for the reservation.</p>
    pub reserved_cache_node_id: std::option::Option<std::string::String>,
    /// <p>The offering identifier.</p>
    pub reserved_cache_nodes_offering_id: std::option::Option<std::string::String>,
    /// <p>The cache node type for the reserved cache nodes.</p>        
    ///
    /// <p>The following node types are supported by ElastiCache.
    /// Generally speaking, the current generation types provide more memory and computational power
    /// at lower cost when compared to their equivalent previous generation counterparts.</p>
    /// <ul>
    /// <li>
    /// <p>General purpose:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    ///
    ///
    /// <p>
    /// <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):  <code>cache.m6g.large</code>,
    /// <code>cache.m6g.xlarge</code>,
    /// <code>cache.m6g.2xlarge</code>,
    /// <code>cache.m6g.4xlarge</code>,
    /// <code>cache.m6g.8xlarge</code>,
    /// <code>cache.m6g.12xlarge</code>,
    /// <code>cache.m6g.16xlarge</code>
    ///
    ///
    ///
    /// </p>  
    ///
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    ///
    ///
    /// <p>
    /// <b>M5 node types:</b>
    /// <code>cache.m5.large</code>,
    /// <code>cache.m5.xlarge</code>,
    /// <code>cache.m5.2xlarge</code>,
    /// <code>cache.m5.4xlarge</code>,
    /// <code>cache.m5.12xlarge</code>,
    /// <code>cache.m5.24xlarge</code>
    ///
    ///
    /// </p>  
    ///
    ///
    /// <p>
    /// <b>M4 node types:</b>
    /// <code>cache.m4.large</code>,
    /// <code>cache.m4.xlarge</code>,
    /// <code>cache.m4.2xlarge</code>,
    /// <code>cache.m4.4xlarge</code>,
    /// <code>cache.m4.10xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
    /// <code>cache.t4g.micro</code>,
    /// <code>cache.t4g.small</code>,
    /// <code>cache.t4g.medium</code>
    /// </p>             
    /// <p>
    /// <b>T3 node types:</b>
    /// <code>cache.t3.micro</code>,
    /// <code>cache.t3.small</code>,
    /// <code>cache.t3.medium</code>
    /// </p>
    ///
    ///
    /// <p>
    /// <b>T2 node types:</b>
    /// <code>cache.t2.micro</code>,
    /// <code>cache.t2.small</code>,
    /// <code>cache.t2.medium</code>
    /// </p>
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>T1 node types:</b>
    /// <code>cache.t1.micro</code>
    /// </p>
    ///
    /// <p>
    /// <b>M1 node types:</b>
    /// <code>cache.m1.small</code>,
    /// <code>cache.m1.medium</code>,
    /// <code>cache.m1.large</code>,
    /// <code>cache.m1.xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>M3 node types:</b>
    /// <code>cache.m3.medium</code>,
    /// <code>cache.m3.large</code>,
    /// <code>cache.m3.xlarge</code>,
    /// <code>cache.m3.2xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Compute optimized:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>C1 node types:</b>
    /// <code>cache.c1.xlarge</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized with data tiering:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    /// <p>
    /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
    ///
    ///
    ///
    ///
    /// <p>  
    ///
    /// <code>cache.r6gd.xlarge</code>,
    /// <code>cache.r6gd.2xlarge</code>,
    /// <code>cache.r6gd.4xlarge</code>,
    /// <code>cache.r6gd.8xlarge</code>,
    /// <code>cache.r6gd.12xlarge</code>,
    /// <code>cache.r6gd.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>              
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    /// <p>
    /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
    ///
    ///
    ///
    ///
    /// <p>  
    /// <code>cache.r6g.large</code>,
    /// <code>cache.r6g.xlarge</code>,
    /// <code>cache.r6g.2xlarge</code>,
    /// <code>cache.r6g.4xlarge</code>,
    /// <code>cache.r6g.8xlarge</code>,
    /// <code>cache.r6g.12xlarge</code>,
    /// <code>cache.r6g.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>  
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    /// <p>
    /// <b>R5 node types:</b>
    /// <code>cache.r5.large</code>,
    /// <code>cache.r5.xlarge</code>,
    /// <code>cache.r5.2xlarge</code>,
    /// <code>cache.r5.4xlarge</code>,
    /// <code>cache.r5.12xlarge</code>,
    /// <code>cache.r5.24xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R4 node types:</b>
    /// <code>cache.r4.large</code>,
    /// <code>cache.r4.xlarge</code>,
    /// <code>cache.r4.2xlarge</code>,
    /// <code>cache.r4.4xlarge</code>,
    /// <code>cache.r4.8xlarge</code>,
    /// <code>cache.r4.16xlarge</code>
    /// </p>
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>M2 node types:</b>            
    /// <code>cache.m2.xlarge</code>,
    /// <code>cache.m2.2xlarge</code>,
    /// <code>cache.m2.4xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R3 node types:</b>
    /// <code>cache.r3.large</code>,
    /// <code>cache.r3.xlarge</code>,
    /// <code>cache.r3.2xlarge</code>,  
    /// <code>cache.r3.4xlarge</code>,
    /// <code>cache.r3.8xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    ///
    /// <p>
    /// <b>Additional node type info</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>All current generation instance types are created in Amazon VPC by default.</p>
    /// </li>
    /// <li>
    /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis configuration variables <code>appendonly</code> and
    /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
    /// </li>
    /// </ul>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>The time the reservation started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The duration of the reservation in seconds.</p>
    pub duration: i32,
    /// <p>The fixed price charged for this reserved cache node.</p>
    pub fixed_price: f64,
    /// <p>The hourly price charged for this reserved cache node.</p>
    pub usage_price: f64,
    /// <p>The number of cache nodes that have been reserved.</p>
    pub cache_node_count: i32,
    /// <p>The description of the reserved cache node.</p>
    pub product_description: std::option::Option<std::string::String>,
    /// <p>The offering type of this reserved cache node.</p>
    pub offering_type: std::option::Option<std::string::String>,
    /// <p>The state of the reserved cache node.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>The recurring price charged to run this reserved cache node.</p>
    pub recurring_charges: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
    /// <p>The Amazon Resource Name (ARN) of the reserved cache node.</p>
    /// <p>Example: <code>arn:aws:elasticache:us-east-1:123456789012:reserved-instance:ri-2017-03-27-08-33-25-582</code>
    /// </p>
    pub reservation_arn: std::option::Option<std::string::String>,
}
impl ReservedCacheNode {
    /// <p>The unique identifier for the reservation.</p>
    pub fn reserved_cache_node_id(&self) -> std::option::Option<&str> {
        self.reserved_cache_node_id.as_deref()
    }
    /// <p>The offering identifier.</p>
    pub fn reserved_cache_nodes_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_cache_nodes_offering_id.as_deref()
    }
    /// <p>The cache node type for the reserved cache nodes.</p>        
    ///
    /// <p>The following node types are supported by ElastiCache.
    /// Generally speaking, the current generation types provide more memory and computational power
    /// at lower cost when compared to their equivalent previous generation counterparts.</p>
    /// <ul>
    /// <li>
    /// <p>General purpose:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    ///
    ///
    /// <p>
    /// <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):  <code>cache.m6g.large</code>,
    /// <code>cache.m6g.xlarge</code>,
    /// <code>cache.m6g.2xlarge</code>,
    /// <code>cache.m6g.4xlarge</code>,
    /// <code>cache.m6g.8xlarge</code>,
    /// <code>cache.m6g.12xlarge</code>,
    /// <code>cache.m6g.16xlarge</code>
    ///
    ///
    ///
    /// </p>  
    ///
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    ///
    ///
    /// <p>
    /// <b>M5 node types:</b>
    /// <code>cache.m5.large</code>,
    /// <code>cache.m5.xlarge</code>,
    /// <code>cache.m5.2xlarge</code>,
    /// <code>cache.m5.4xlarge</code>,
    /// <code>cache.m5.12xlarge</code>,
    /// <code>cache.m5.24xlarge</code>
    ///
    ///
    /// </p>  
    ///
    ///
    /// <p>
    /// <b>M4 node types:</b>
    /// <code>cache.m4.large</code>,
    /// <code>cache.m4.xlarge</code>,
    /// <code>cache.m4.2xlarge</code>,
    /// <code>cache.m4.4xlarge</code>,
    /// <code>cache.m4.10xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
    /// <code>cache.t4g.micro</code>,
    /// <code>cache.t4g.small</code>,
    /// <code>cache.t4g.medium</code>
    /// </p>             
    /// <p>
    /// <b>T3 node types:</b>
    /// <code>cache.t3.micro</code>,
    /// <code>cache.t3.small</code>,
    /// <code>cache.t3.medium</code>
    /// </p>
    ///
    ///
    /// <p>
    /// <b>T2 node types:</b>
    /// <code>cache.t2.micro</code>,
    /// <code>cache.t2.small</code>,
    /// <code>cache.t2.medium</code>
    /// </p>
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>T1 node types:</b>
    /// <code>cache.t1.micro</code>
    /// </p>
    ///
    /// <p>
    /// <b>M1 node types:</b>
    /// <code>cache.m1.small</code>,
    /// <code>cache.m1.medium</code>,
    /// <code>cache.m1.large</code>,
    /// <code>cache.m1.xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>M3 node types:</b>
    /// <code>cache.m3.medium</code>,
    /// <code>cache.m3.large</code>,
    /// <code>cache.m3.xlarge</code>,
    /// <code>cache.m3.2xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Compute optimized:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>C1 node types:</b>
    /// <code>cache.c1.xlarge</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized with data tiering:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    /// <p>
    /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
    ///
    ///
    ///
    ///
    /// <p>  
    ///
    /// <code>cache.r6gd.xlarge</code>,
    /// <code>cache.r6gd.2xlarge</code>,
    /// <code>cache.r6gd.4xlarge</code>,
    /// <code>cache.r6gd.8xlarge</code>,
    /// <code>cache.r6gd.12xlarge</code>,
    /// <code>cache.r6gd.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>              
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    /// <p>
    /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
    ///
    ///
    ///
    ///
    /// <p>  
    /// <code>cache.r6g.large</code>,
    /// <code>cache.r6g.xlarge</code>,
    /// <code>cache.r6g.2xlarge</code>,
    /// <code>cache.r6g.4xlarge</code>,
    /// <code>cache.r6g.8xlarge</code>,
    /// <code>cache.r6g.12xlarge</code>,
    /// <code>cache.r6g.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>  
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    /// <p>
    /// <b>R5 node types:</b>
    /// <code>cache.r5.large</code>,
    /// <code>cache.r5.xlarge</code>,
    /// <code>cache.r5.2xlarge</code>,
    /// <code>cache.r5.4xlarge</code>,
    /// <code>cache.r5.12xlarge</code>,
    /// <code>cache.r5.24xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R4 node types:</b>
    /// <code>cache.r4.large</code>,
    /// <code>cache.r4.xlarge</code>,
    /// <code>cache.r4.2xlarge</code>,
    /// <code>cache.r4.4xlarge</code>,
    /// <code>cache.r4.8xlarge</code>,
    /// <code>cache.r4.16xlarge</code>
    /// </p>
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>M2 node types:</b>            
    /// <code>cache.m2.xlarge</code>,
    /// <code>cache.m2.2xlarge</code>,
    /// <code>cache.m2.4xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R3 node types:</b>
    /// <code>cache.r3.large</code>,
    /// <code>cache.r3.xlarge</code>,
    /// <code>cache.r3.2xlarge</code>,  
    /// <code>cache.r3.4xlarge</code>,
    /// <code>cache.r3.8xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    ///
    /// <p>
    /// <b>Additional node type info</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>All current generation instance types are created in Amazon VPC by default.</p>
    /// </li>
    /// <li>
    /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis configuration variables <code>appendonly</code> and
    /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
    /// </li>
    /// </ul>
    pub fn cache_node_type(&self) -> std::option::Option<&str> {
        self.cache_node_type.as_deref()
    }
    /// <p>The time the reservation started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The duration of the reservation in seconds.</p>
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// <p>The fixed price charged for this reserved cache node.</p>
    pub fn fixed_price(&self) -> f64 {
        self.fixed_price
    }
    /// <p>The hourly price charged for this reserved cache node.</p>
    pub fn usage_price(&self) -> f64 {
        self.usage_price
    }
    /// <p>The number of cache nodes that have been reserved.</p>
    pub fn cache_node_count(&self) -> i32 {
        self.cache_node_count
    }
    /// <p>The description of the reserved cache node.</p>
    pub fn product_description(&self) -> std::option::Option<&str> {
        self.product_description.as_deref()
    }
    /// <p>The offering type of this reserved cache node.</p>
    pub fn offering_type(&self) -> std::option::Option<&str> {
        self.offering_type.as_deref()
    }
    /// <p>The state of the reserved cache node.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>The recurring price charged to run this reserved cache node.</p>
    pub fn recurring_charges(&self) -> std::option::Option<&[crate::model::RecurringCharge]> {
        self.recurring_charges.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the reserved cache node.</p>
    /// <p>Example: <code>arn:aws:elasticache:us-east-1:123456789012:reserved-instance:ri-2017-03-27-08-33-25-582</code>
    /// </p>
    pub fn reservation_arn(&self) -> std::option::Option<&str> {
        self.reservation_arn.as_deref()
    }
}
impl std::fmt::Debug for ReservedCacheNode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedCacheNode");
        formatter.field("reserved_cache_node_id", &self.reserved_cache_node_id);
        formatter.field(
            "reserved_cache_nodes_offering_id",
            &self.reserved_cache_nodes_offering_id,
        );
        formatter.field("cache_node_type", &self.cache_node_type);
        formatter.field("start_time", &self.start_time);
        formatter.field("duration", &self.duration);
        formatter.field("fixed_price", &self.fixed_price);
        formatter.field("usage_price", &self.usage_price);
        formatter.field("cache_node_count", &self.cache_node_count);
        formatter.field("product_description", &self.product_description);
        formatter.field("offering_type", &self.offering_type);
        formatter.field("state", &self.state);
        formatter.field("recurring_charges", &self.recurring_charges);
        formatter.field("reservation_arn", &self.reservation_arn);
        formatter.finish()
    }
}
/// See [`ReservedCacheNode`](crate::model::ReservedCacheNode)
pub mod reserved_cache_node {
    /// A builder for [`ReservedCacheNode`](crate::model::ReservedCacheNode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_cache_node_id: std::option::Option<std::string::String>,
        pub(crate) reserved_cache_nodes_offering_id: std::option::Option<std::string::String>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) fixed_price: std::option::Option<f64>,
        pub(crate) usage_price: std::option::Option<f64>,
        pub(crate) cache_node_count: std::option::Option<i32>,
        pub(crate) product_description: std::option::Option<std::string::String>,
        pub(crate) offering_type: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) recurring_charges:
            std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
        pub(crate) reservation_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the reservation.</p>
        pub fn reserved_cache_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_cache_node_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the reservation.</p>
        pub fn set_reserved_cache_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_cache_node_id = input;
            self
        }
        /// <p>The offering identifier.</p>
        pub fn reserved_cache_nodes_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_cache_nodes_offering_id = Some(input.into());
            self
        }
        /// <p>The offering identifier.</p>
        pub fn set_reserved_cache_nodes_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_cache_nodes_offering_id = input;
            self
        }
        /// <p>The cache node type for the reserved cache nodes.</p>        
        ///
        /// <p>The following node types are supported by ElastiCache.
        /// Generally speaking, the current generation types provide more memory and computational power
        /// at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li>
        /// <p>General purpose:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        ///
        ///
        /// <p>
        /// <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):  <code>cache.m6g.large</code>,
        /// <code>cache.m6g.xlarge</code>,
        /// <code>cache.m6g.2xlarge</code>,
        /// <code>cache.m6g.4xlarge</code>,
        /// <code>cache.m6g.8xlarge</code>,
        /// <code>cache.m6g.12xlarge</code>,
        /// <code>cache.m6g.16xlarge</code>
        ///
        ///
        ///
        /// </p>  
        ///
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        ///
        ///
        /// <p>
        /// <b>M5 node types:</b>
        /// <code>cache.m5.large</code>,
        /// <code>cache.m5.xlarge</code>,
        /// <code>cache.m5.2xlarge</code>,
        /// <code>cache.m5.4xlarge</code>,
        /// <code>cache.m5.12xlarge</code>,
        /// <code>cache.m5.24xlarge</code>
        ///
        ///
        /// </p>  
        ///
        ///
        /// <p>
        /// <b>M4 node types:</b>
        /// <code>cache.m4.large</code>,
        /// <code>cache.m4.xlarge</code>,
        /// <code>cache.m4.2xlarge</code>,
        /// <code>cache.m4.4xlarge</code>,
        /// <code>cache.m4.10xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
        /// <code>cache.t4g.micro</code>,
        /// <code>cache.t4g.small</code>,
        /// <code>cache.t4g.medium</code>
        /// </p>             
        /// <p>
        /// <b>T3 node types:</b>
        /// <code>cache.t3.micro</code>,
        /// <code>cache.t3.small</code>,
        /// <code>cache.t3.medium</code>
        /// </p>
        ///
        ///
        /// <p>
        /// <b>T2 node types:</b>
        /// <code>cache.t2.micro</code>,
        /// <code>cache.t2.small</code>,
        /// <code>cache.t2.medium</code>
        /// </p>
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>T1 node types:</b>
        /// <code>cache.t1.micro</code>
        /// </p>
        ///
        /// <p>
        /// <b>M1 node types:</b>
        /// <code>cache.m1.small</code>,
        /// <code>cache.m1.medium</code>,
        /// <code>cache.m1.large</code>,
        /// <code>cache.m1.xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>M3 node types:</b>
        /// <code>cache.m3.medium</code>,
        /// <code>cache.m3.large</code>,
        /// <code>cache.m3.xlarge</code>,
        /// <code>cache.m3.2xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Compute optimized:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>C1 node types:</b>
        /// <code>cache.c1.xlarge</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        /// <p>
        /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
        ///
        ///
        ///
        ///
        /// <p>  
        ///
        /// <code>cache.r6gd.xlarge</code>,
        /// <code>cache.r6gd.2xlarge</code>,
        /// <code>cache.r6gd.4xlarge</code>,
        /// <code>cache.r6gd.8xlarge</code>,
        /// <code>cache.r6gd.12xlarge</code>,
        /// <code>cache.r6gd.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>              
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        /// <p>
        /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
        ///
        ///
        ///
        ///
        /// <p>  
        /// <code>cache.r6g.large</code>,
        /// <code>cache.r6g.xlarge</code>,
        /// <code>cache.r6g.2xlarge</code>,
        /// <code>cache.r6g.4xlarge</code>,
        /// <code>cache.r6g.8xlarge</code>,
        /// <code>cache.r6g.12xlarge</code>,
        /// <code>cache.r6g.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>  
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        /// <p>
        /// <b>R5 node types:</b>
        /// <code>cache.r5.large</code>,
        /// <code>cache.r5.xlarge</code>,
        /// <code>cache.r5.2xlarge</code>,
        /// <code>cache.r5.4xlarge</code>,
        /// <code>cache.r5.12xlarge</code>,
        /// <code>cache.r5.24xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R4 node types:</b>
        /// <code>cache.r4.large</code>,
        /// <code>cache.r4.xlarge</code>,
        /// <code>cache.r4.2xlarge</code>,
        /// <code>cache.r4.4xlarge</code>,
        /// <code>cache.r4.8xlarge</code>,
        /// <code>cache.r4.16xlarge</code>
        /// </p>
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>M2 node types:</b>            
        /// <code>cache.m2.xlarge</code>,
        /// <code>cache.m2.2xlarge</code>,
        /// <code>cache.m2.4xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R3 node types:</b>
        /// <code>cache.r3.large</code>,
        /// <code>cache.r3.xlarge</code>,
        /// <code>cache.r3.2xlarge</code>,  
        /// <code>cache.r3.4xlarge</code>,
        /// <code>cache.r3.8xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Additional node type info</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>All current generation instance types are created in Amazon VPC by default.</p>
        /// </li>
        /// <li>
        /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis configuration variables <code>appendonly</code> and
        /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
        /// </li>
        /// </ul>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>The cache node type for the reserved cache nodes.</p>        
        ///
        /// <p>The following node types are supported by ElastiCache.
        /// Generally speaking, the current generation types provide more memory and computational power
        /// at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li>
        /// <p>General purpose:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        ///
        ///
        /// <p>
        /// <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):  <code>cache.m6g.large</code>,
        /// <code>cache.m6g.xlarge</code>,
        /// <code>cache.m6g.2xlarge</code>,
        /// <code>cache.m6g.4xlarge</code>,
        /// <code>cache.m6g.8xlarge</code>,
        /// <code>cache.m6g.12xlarge</code>,
        /// <code>cache.m6g.16xlarge</code>
        ///
        ///
        ///
        /// </p>  
        ///
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        ///
        ///
        /// <p>
        /// <b>M5 node types:</b>
        /// <code>cache.m5.large</code>,
        /// <code>cache.m5.xlarge</code>,
        /// <code>cache.m5.2xlarge</code>,
        /// <code>cache.m5.4xlarge</code>,
        /// <code>cache.m5.12xlarge</code>,
        /// <code>cache.m5.24xlarge</code>
        ///
        ///
        /// </p>  
        ///
        ///
        /// <p>
        /// <b>M4 node types:</b>
        /// <code>cache.m4.large</code>,
        /// <code>cache.m4.xlarge</code>,
        /// <code>cache.m4.2xlarge</code>,
        /// <code>cache.m4.4xlarge</code>,
        /// <code>cache.m4.10xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
        /// <code>cache.t4g.micro</code>,
        /// <code>cache.t4g.small</code>,
        /// <code>cache.t4g.medium</code>
        /// </p>             
        /// <p>
        /// <b>T3 node types:</b>
        /// <code>cache.t3.micro</code>,
        /// <code>cache.t3.small</code>,
        /// <code>cache.t3.medium</code>
        /// </p>
        ///
        ///
        /// <p>
        /// <b>T2 node types:</b>
        /// <code>cache.t2.micro</code>,
        /// <code>cache.t2.small</code>,
        /// <code>cache.t2.medium</code>
        /// </p>
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>T1 node types:</b>
        /// <code>cache.t1.micro</code>
        /// </p>
        ///
        /// <p>
        /// <b>M1 node types:</b>
        /// <code>cache.m1.small</code>,
        /// <code>cache.m1.medium</code>,
        /// <code>cache.m1.large</code>,
        /// <code>cache.m1.xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>M3 node types:</b>
        /// <code>cache.m3.medium</code>,
        /// <code>cache.m3.large</code>,
        /// <code>cache.m3.xlarge</code>,
        /// <code>cache.m3.2xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Compute optimized:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>C1 node types:</b>
        /// <code>cache.c1.xlarge</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        /// <p>
        /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
        ///
        ///
        ///
        ///
        /// <p>  
        ///
        /// <code>cache.r6gd.xlarge</code>,
        /// <code>cache.r6gd.2xlarge</code>,
        /// <code>cache.r6gd.4xlarge</code>,
        /// <code>cache.r6gd.8xlarge</code>,
        /// <code>cache.r6gd.12xlarge</code>,
        /// <code>cache.r6gd.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>              
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        /// <p>
        /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
        ///
        ///
        ///
        ///
        /// <p>  
        /// <code>cache.r6g.large</code>,
        /// <code>cache.r6g.xlarge</code>,
        /// <code>cache.r6g.2xlarge</code>,
        /// <code>cache.r6g.4xlarge</code>,
        /// <code>cache.r6g.8xlarge</code>,
        /// <code>cache.r6g.12xlarge</code>,
        /// <code>cache.r6g.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>  
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        /// <p>
        /// <b>R5 node types:</b>
        /// <code>cache.r5.large</code>,
        /// <code>cache.r5.xlarge</code>,
        /// <code>cache.r5.2xlarge</code>,
        /// <code>cache.r5.4xlarge</code>,
        /// <code>cache.r5.12xlarge</code>,
        /// <code>cache.r5.24xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R4 node types:</b>
        /// <code>cache.r4.large</code>,
        /// <code>cache.r4.xlarge</code>,
        /// <code>cache.r4.2xlarge</code>,
        /// <code>cache.r4.4xlarge</code>,
        /// <code>cache.r4.8xlarge</code>,
        /// <code>cache.r4.16xlarge</code>
        /// </p>
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>M2 node types:</b>            
        /// <code>cache.m2.xlarge</code>,
        /// <code>cache.m2.2xlarge</code>,
        /// <code>cache.m2.4xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R3 node types:</b>
        /// <code>cache.r3.large</code>,
        /// <code>cache.r3.xlarge</code>,
        /// <code>cache.r3.2xlarge</code>,  
        /// <code>cache.r3.4xlarge</code>,
        /// <code>cache.r3.8xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Additional node type info</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>All current generation instance types are created in Amazon VPC by default.</p>
        /// </li>
        /// <li>
        /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis configuration variables <code>appendonly</code> and
        /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
        /// </li>
        /// </ul>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>The time the reservation started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time the reservation started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The duration of the reservation in seconds.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The duration of the reservation in seconds.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The fixed price charged for this reserved cache node.</p>
        pub fn fixed_price(mut self, input: f64) -> Self {
            self.fixed_price = Some(input);
            self
        }
        /// <p>The fixed price charged for this reserved cache node.</p>
        pub fn set_fixed_price(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_price = input;
            self
        }
        /// <p>The hourly price charged for this reserved cache node.</p>
        pub fn usage_price(mut self, input: f64) -> Self {
            self.usage_price = Some(input);
            self
        }
        /// <p>The hourly price charged for this reserved cache node.</p>
        pub fn set_usage_price(mut self, input: std::option::Option<f64>) -> Self {
            self.usage_price = input;
            self
        }
        /// <p>The number of cache nodes that have been reserved.</p>
        pub fn cache_node_count(mut self, input: i32) -> Self {
            self.cache_node_count = Some(input);
            self
        }
        /// <p>The number of cache nodes that have been reserved.</p>
        pub fn set_cache_node_count(mut self, input: std::option::Option<i32>) -> Self {
            self.cache_node_count = input;
            self
        }
        /// <p>The description of the reserved cache node.</p>
        pub fn product_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_description = Some(input.into());
            self
        }
        /// <p>The description of the reserved cache node.</p>
        pub fn set_product_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.product_description = input;
            self
        }
        /// <p>The offering type of this reserved cache node.</p>
        pub fn offering_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_type = Some(input.into());
            self
        }
        /// <p>The offering type of this reserved cache node.</p>
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_type = input;
            self
        }
        /// <p>The state of the reserved cache node.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the reserved cache node.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `recurring_charges`.
        ///
        /// To override the contents of this collection use [`set_recurring_charges`](Self::set_recurring_charges).
        ///
        /// <p>The recurring price charged to run this reserved cache node.</p>
        pub fn recurring_charges(
            mut self,
            input: impl Into<crate::model::RecurringCharge>,
        ) -> Self {
            let mut v = self.recurring_charges.unwrap_or_default();
            v.push(input.into());
            self.recurring_charges = Some(v);
            self
        }
        /// <p>The recurring price charged to run this reserved cache node.</p>
        pub fn set_recurring_charges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
        ) -> Self {
            self.recurring_charges = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the reserved cache node.</p>
        /// <p>Example: <code>arn:aws:elasticache:us-east-1:123456789012:reserved-instance:ri-2017-03-27-08-33-25-582</code>
        /// </p>
        pub fn reservation_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the reserved cache node.</p>
        /// <p>Example: <code>arn:aws:elasticache:us-east-1:123456789012:reserved-instance:ri-2017-03-27-08-33-25-582</code>
        /// </p>
        pub fn set_reservation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedCacheNode`](crate::model::ReservedCacheNode)
        pub fn build(self) -> crate::model::ReservedCacheNode {
            crate::model::ReservedCacheNode {
                reserved_cache_node_id: self.reserved_cache_node_id,
                reserved_cache_nodes_offering_id: self.reserved_cache_nodes_offering_id,
                cache_node_type: self.cache_node_type,
                start_time: self.start_time,
                duration: self.duration.unwrap_or_default(),
                fixed_price: self.fixed_price.unwrap_or_default(),
                usage_price: self.usage_price.unwrap_or_default(),
                cache_node_count: self.cache_node_count.unwrap_or_default(),
                product_description: self.product_description,
                offering_type: self.offering_type,
                state: self.state,
                recurring_charges: self.recurring_charges,
                reservation_arn: self.reservation_arn,
            }
        }
    }
}
impl ReservedCacheNode {
    /// Creates a new builder-style object to manufacture [`ReservedCacheNode`](crate::model::ReservedCacheNode)
    pub fn builder() -> crate::model::reserved_cache_node::Builder {
        crate::model::reserved_cache_node::Builder::default()
    }
}

/// <p>Contains the specific price and frequency of a recurring charges for a reserved cache node,
/// or for a reserved cache node offering.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecurringCharge {
    /// <p>The monetary amount of the recurring charge.</p>
    pub recurring_charge_amount: f64,
    /// <p>The frequency of the recurring charge.</p>
    pub recurring_charge_frequency: std::option::Option<std::string::String>,
}
impl RecurringCharge {
    /// <p>The monetary amount of the recurring charge.</p>
    pub fn recurring_charge_amount(&self) -> f64 {
        self.recurring_charge_amount
    }
    /// <p>The frequency of the recurring charge.</p>
    pub fn recurring_charge_frequency(&self) -> std::option::Option<&str> {
        self.recurring_charge_frequency.as_deref()
    }
}
impl std::fmt::Debug for RecurringCharge {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecurringCharge");
        formatter.field("recurring_charge_amount", &self.recurring_charge_amount);
        formatter.field(
            "recurring_charge_frequency",
            &self.recurring_charge_frequency,
        );
        formatter.finish()
    }
}
/// See [`RecurringCharge`](crate::model::RecurringCharge)
pub mod recurring_charge {
    /// A builder for [`RecurringCharge`](crate::model::RecurringCharge)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recurring_charge_amount: std::option::Option<f64>,
        pub(crate) recurring_charge_frequency: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The monetary amount of the recurring charge.</p>
        pub fn recurring_charge_amount(mut self, input: f64) -> Self {
            self.recurring_charge_amount = Some(input);
            self
        }
        /// <p>The monetary amount of the recurring charge.</p>
        pub fn set_recurring_charge_amount(mut self, input: std::option::Option<f64>) -> Self {
            self.recurring_charge_amount = input;
            self
        }
        /// <p>The frequency of the recurring charge.</p>
        pub fn recurring_charge_frequency(mut self, input: impl Into<std::string::String>) -> Self {
            self.recurring_charge_frequency = Some(input.into());
            self
        }
        /// <p>The frequency of the recurring charge.</p>
        pub fn set_recurring_charge_frequency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recurring_charge_frequency = input;
            self
        }
        /// Consumes the builder and constructs a [`RecurringCharge`](crate::model::RecurringCharge)
        pub fn build(self) -> crate::model::RecurringCharge {
            crate::model::RecurringCharge {
                recurring_charge_amount: self.recurring_charge_amount.unwrap_or_default(),
                recurring_charge_frequency: self.recurring_charge_frequency,
            }
        }
    }
}
impl RecurringCharge {
    /// Creates a new builder-style object to manufacture [`RecurringCharge`](crate::model::RecurringCharge)
    pub fn builder() -> crate::model::recurring_charge::Builder {
        crate::model::recurring_charge::Builder::default()
    }
}

/// <p>Returns the updates being applied to the user group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserGroupPendingChanges {
    /// <p>The list of user IDs to remove.</p>
    pub user_ids_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of user IDs to add.</p>
    pub user_ids_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UserGroupPendingChanges {
    /// <p>The list of user IDs to remove.</p>
    pub fn user_ids_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.user_ids_to_remove.as_deref()
    }
    /// <p>The list of user IDs to add.</p>
    pub fn user_ids_to_add(&self) -> std::option::Option<&[std::string::String]> {
        self.user_ids_to_add.as_deref()
    }
}
impl std::fmt::Debug for UserGroupPendingChanges {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserGroupPendingChanges");
        formatter.field("user_ids_to_remove", &self.user_ids_to_remove);
        formatter.field("user_ids_to_add", &self.user_ids_to_add);
        formatter.finish()
    }
}
/// See [`UserGroupPendingChanges`](crate::model::UserGroupPendingChanges)
pub mod user_group_pending_changes {
    /// A builder for [`UserGroupPendingChanges`](crate::model::UserGroupPendingChanges)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_ids_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_ids_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `user_ids_to_remove`.
        ///
        /// To override the contents of this collection use [`set_user_ids_to_remove`](Self::set_user_ids_to_remove).
        ///
        /// <p>The list of user IDs to remove.</p>
        pub fn user_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_ids_to_remove.unwrap_or_default();
            v.push(input.into());
            self.user_ids_to_remove = Some(v);
            self
        }
        /// <p>The list of user IDs to remove.</p>
        pub fn set_user_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_ids_to_remove = input;
            self
        }
        /// Appends an item to `user_ids_to_add`.
        ///
        /// To override the contents of this collection use [`set_user_ids_to_add`](Self::set_user_ids_to_add).
        ///
        /// <p>The list of user IDs to add.</p>
        pub fn user_ids_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_ids_to_add.unwrap_or_default();
            v.push(input.into());
            self.user_ids_to_add = Some(v);
            self
        }
        /// <p>The list of user IDs to add.</p>
        pub fn set_user_ids_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_ids_to_add = input;
            self
        }
        /// Consumes the builder and constructs a [`UserGroupPendingChanges`](crate::model::UserGroupPendingChanges)
        pub fn build(self) -> crate::model::UserGroupPendingChanges {
            crate::model::UserGroupPendingChanges {
                user_ids_to_remove: self.user_ids_to_remove,
                user_ids_to_add: self.user_ids_to_add,
            }
        }
    }
}
impl UserGroupPendingChanges {
    /// Creates a new builder-style object to manufacture [`UserGroupPendingChanges`](crate::model::UserGroupPendingChanges)
    pub fn builder() -> crate::model::user_group_pending_changes::Builder {
        crate::model::user_group_pending_changes::Builder::default()
    }
}

/// <p>Indicates whether the user requires a password to authenticate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Authentication {
    /// <p>Indicates whether the user requires a password to authenticate.</p>
    pub r#type: std::option::Option<crate::model::AuthenticationType>,
    /// <p>The number of passwords belonging to the user. The maximum is two.</p>
    pub password_count: std::option::Option<i32>,
}
impl Authentication {
    /// <p>Indicates whether the user requires a password to authenticate.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.r#type.as_ref()
    }
    /// <p>The number of passwords belonging to the user. The maximum is two.</p>
    pub fn password_count(&self) -> std::option::Option<i32> {
        self.password_count
    }
}
impl std::fmt::Debug for Authentication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Authentication");
        formatter.field("r#type", &self.r#type);
        formatter.field("password_count", &self.password_count);
        formatter.finish()
    }
}
/// See [`Authentication`](crate::model::Authentication)
pub mod authentication {
    /// A builder for [`Authentication`](crate::model::Authentication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::AuthenticationType>,
        pub(crate) password_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Indicates whether the user requires a password to authenticate.</p>
        pub fn r#type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Indicates whether the user requires a password to authenticate.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The number of passwords belonging to the user. The maximum is two.</p>
        pub fn password_count(mut self, input: i32) -> Self {
            self.password_count = Some(input);
            self
        }
        /// <p>The number of passwords belonging to the user. The maximum is two.</p>
        pub fn set_password_count(mut self, input: std::option::Option<i32>) -> Self {
            self.password_count = input;
            self
        }
        /// Consumes the builder and constructs a [`Authentication`](crate::model::Authentication)
        pub fn build(self) -> crate::model::Authentication {
            crate::model::Authentication {
                r#type: self.r#type,
                password_count: self.password_count,
            }
        }
    }
}
impl Authentication {
    /// Creates a new builder-style object to manufacture [`Authentication`](crate::model::Authentication)
    pub fn builder() -> crate::model::authentication::Builder {
        crate::model::authentication::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthenticationType {
    #[allow(missing_docs)] // documentation missing in model
    NoPassword,
    #[allow(missing_docs)] // documentation missing in model
    Password,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthenticationType {
    fn from(s: &str) -> Self {
        match s {
            "no-password" => AuthenticationType::NoPassword,
            "password" => AuthenticationType::Password,
            other => AuthenticationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthenticationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthenticationType::from(s))
    }
}
impl AuthenticationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthenticationType::NoPassword => "no-password",
            AuthenticationType::Password => "password",
            AuthenticationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["no-password", "password"]
    }
}
impl AsRef<str> for AuthenticationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A list of <code>PreferredAvailabilityZones</code> objects that specifies
/// the configuration of a node group in the resharded cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReshardingConfiguration {
    /// <p>Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for the node group these
    /// configuration values apply to.</p>
    pub node_group_id: std::option::Option<std::string::String>,
    /// <p>A list of preferred availability zones for the nodes in this cluster.</p>
    pub preferred_availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ReshardingConfiguration {
    /// <p>Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for the node group these
    /// configuration values apply to.</p>
    pub fn node_group_id(&self) -> std::option::Option<&str> {
        self.node_group_id.as_deref()
    }
    /// <p>A list of preferred availability zones for the nodes in this cluster.</p>
    pub fn preferred_availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.preferred_availability_zones.as_deref()
    }
}
impl std::fmt::Debug for ReshardingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReshardingConfiguration");
        formatter.field("node_group_id", &self.node_group_id);
        formatter.field(
            "preferred_availability_zones",
            &self.preferred_availability_zones,
        );
        formatter.finish()
    }
}
/// See [`ReshardingConfiguration`](crate::model::ReshardingConfiguration)
pub mod resharding_configuration {
    /// A builder for [`ReshardingConfiguration`](crate::model::ReshardingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_group_id: std::option::Option<std::string::String>,
        pub(crate) preferred_availability_zones:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for the node group these
        /// configuration values apply to.</p>
        pub fn node_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_group_id = Some(input.into());
            self
        }
        /// <p>Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for the node group these
        /// configuration values apply to.</p>
        pub fn set_node_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.node_group_id = input;
            self
        }
        /// Appends an item to `preferred_availability_zones`.
        ///
        /// To override the contents of this collection use [`set_preferred_availability_zones`](Self::set_preferred_availability_zones).
        ///
        /// <p>A list of preferred availability zones for the nodes in this cluster.</p>
        pub fn preferred_availability_zones(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.preferred_availability_zones.unwrap_or_default();
            v.push(input.into());
            self.preferred_availability_zones = Some(v);
            self
        }
        /// <p>A list of preferred availability zones for the nodes in this cluster.</p>
        pub fn set_preferred_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.preferred_availability_zones = input;
            self
        }
        /// Consumes the builder and constructs a [`ReshardingConfiguration`](crate::model::ReshardingConfiguration)
        pub fn build(self) -> crate::model::ReshardingConfiguration {
            crate::model::ReshardingConfiguration {
                node_group_id: self.node_group_id,
                preferred_availability_zones: self.preferred_availability_zones,
            }
        }
    }
}
impl ReshardingConfiguration {
    /// Creates a new builder-style object to manufacture [`ReshardingConfiguration`](crate::model::ReshardingConfiguration)
    pub fn builder() -> crate::model::resharding_configuration::Builder {
        crate::model::resharding_configuration::Builder::default()
    }
}

/// <p>Specifies the destination, format and type of the logs. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogDeliveryConfigurationRequest {
    /// <p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.</p>
    pub log_type: std::option::Option<crate::model::LogType>,
    /// <p>Specify either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> as the destination type.</p>
    pub destination_type: std::option::Option<crate::model::DestinationType>,
    /// <p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>
    pub destination_details: std::option::Option<crate::model::DestinationDetails>,
    /// <p>Specifies either JSON or TEXT</p>
    pub log_format: std::option::Option<crate::model::LogFormat>,
    /// <p>Specify if log delivery is enabled. Default <code>true</code>.</p>
    pub enabled: std::option::Option<bool>,
}
impl LogDeliveryConfigurationRequest {
    /// <p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.</p>
    pub fn log_type(&self) -> std::option::Option<&crate::model::LogType> {
        self.log_type.as_ref()
    }
    /// <p>Specify either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> as the destination type.</p>
    pub fn destination_type(&self) -> std::option::Option<&crate::model::DestinationType> {
        self.destination_type.as_ref()
    }
    /// <p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>
    pub fn destination_details(&self) -> std::option::Option<&crate::model::DestinationDetails> {
        self.destination_details.as_ref()
    }
    /// <p>Specifies either JSON or TEXT</p>
    pub fn log_format(&self) -> std::option::Option<&crate::model::LogFormat> {
        self.log_format.as_ref()
    }
    /// <p>Specify if log delivery is enabled. Default <code>true</code>.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for LogDeliveryConfigurationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogDeliveryConfigurationRequest");
        formatter.field("log_type", &self.log_type);
        formatter.field("destination_type", &self.destination_type);
        formatter.field("destination_details", &self.destination_details);
        formatter.field("log_format", &self.log_format);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`LogDeliveryConfigurationRequest`](crate::model::LogDeliveryConfigurationRequest)
pub mod log_delivery_configuration_request {
    /// A builder for [`LogDeliveryConfigurationRequest`](crate::model::LogDeliveryConfigurationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_type: std::option::Option<crate::model::LogType>,
        pub(crate) destination_type: std::option::Option<crate::model::DestinationType>,
        pub(crate) destination_details: std::option::Option<crate::model::DestinationDetails>,
        pub(crate) log_format: std::option::Option<crate::model::LogFormat>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.</p>
        pub fn log_type(mut self, input: crate::model::LogType) -> Self {
            self.log_type = Some(input);
            self
        }
        /// <p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.</p>
        pub fn set_log_type(mut self, input: std::option::Option<crate::model::LogType>) -> Self {
            self.log_type = input;
            self
        }
        /// <p>Specify either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> as the destination type.</p>
        pub fn destination_type(mut self, input: crate::model::DestinationType) -> Self {
            self.destination_type = Some(input);
            self
        }
        /// <p>Specify either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> as the destination type.</p>
        pub fn set_destination_type(
            mut self,
            input: std::option::Option<crate::model::DestinationType>,
        ) -> Self {
            self.destination_type = input;
            self
        }
        /// <p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>
        pub fn destination_details(mut self, input: crate::model::DestinationDetails) -> Self {
            self.destination_details = Some(input);
            self
        }
        /// <p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>
        pub fn set_destination_details(
            mut self,
            input: std::option::Option<crate::model::DestinationDetails>,
        ) -> Self {
            self.destination_details = input;
            self
        }
        /// <p>Specifies either JSON or TEXT</p>
        pub fn log_format(mut self, input: crate::model::LogFormat) -> Self {
            self.log_format = Some(input);
            self
        }
        /// <p>Specifies either JSON or TEXT</p>
        pub fn set_log_format(
            mut self,
            input: std::option::Option<crate::model::LogFormat>,
        ) -> Self {
            self.log_format = input;
            self
        }
        /// <p>Specify if log delivery is enabled. Default <code>true</code>.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specify if log delivery is enabled. Default <code>true</code>.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`LogDeliveryConfigurationRequest`](crate::model::LogDeliveryConfigurationRequest)
        pub fn build(self) -> crate::model::LogDeliveryConfigurationRequest {
            crate::model::LogDeliveryConfigurationRequest {
                log_type: self.log_type,
                destination_type: self.destination_type,
                destination_details: self.destination_details,
                log_format: self.log_format,
                enabled: self.enabled,
            }
        }
    }
}
impl LogDeliveryConfigurationRequest {
    /// Creates a new builder-style object to manufacture [`LogDeliveryConfigurationRequest`](crate::model::LogDeliveryConfigurationRequest)
    pub fn builder() -> crate::model::log_delivery_configuration_request::Builder {
        crate::model::log_delivery_configuration_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthTokenUpdateStrategyType {
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Rotate,
    #[allow(missing_docs)] // documentation missing in model
    Set,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthTokenUpdateStrategyType {
    fn from(s: &str) -> Self {
        match s {
            "DELETE" => AuthTokenUpdateStrategyType::Delete,
            "ROTATE" => AuthTokenUpdateStrategyType::Rotate,
            "SET" => AuthTokenUpdateStrategyType::Set,
            other => AuthTokenUpdateStrategyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthTokenUpdateStrategyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthTokenUpdateStrategyType::from(s))
    }
}
impl AuthTokenUpdateStrategyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthTokenUpdateStrategyType::Delete => "DELETE",
            AuthTokenUpdateStrategyType::Rotate => "ROTATE",
            AuthTokenUpdateStrategyType::Set => "SET",
            AuthTokenUpdateStrategyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE", "ROTATE", "SET"]
    }
}
impl AsRef<str> for AuthTokenUpdateStrategyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the output of one of the following operations:</p>
/// <ul>
/// <li>
/// <p>
/// <code>CreateCacheSubnetGroup</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>ModifyCacheSubnetGroup</code>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheSubnetGroup {
    /// <p>The name of the cache subnet group.</p>
    pub cache_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The description of the cache subnet group.</p>
    pub cache_subnet_group_description: std::option::Option<std::string::String>,
    /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>A list of subnets associated with the cache subnet group.</p>
    pub subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
    /// <p>The ARN (Amazon Resource Name) of the cache subnet group.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl CacheSubnetGroup {
    /// <p>The name of the cache subnet group.</p>
    pub fn cache_subnet_group_name(&self) -> std::option::Option<&str> {
        self.cache_subnet_group_name.as_deref()
    }
    /// <p>The description of the cache subnet group.</p>
    pub fn cache_subnet_group_description(&self) -> std::option::Option<&str> {
        self.cache_subnet_group_description.as_deref()
    }
    /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>A list of subnets associated with the cache subnet group.</p>
    pub fn subnets(&self) -> std::option::Option<&[crate::model::Subnet]> {
        self.subnets.as_deref()
    }
    /// <p>The ARN (Amazon Resource Name) of the cache subnet group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for CacheSubnetGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheSubnetGroup");
        formatter.field("cache_subnet_group_name", &self.cache_subnet_group_name);
        formatter.field(
            "cache_subnet_group_description",
            &self.cache_subnet_group_description,
        );
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnets", &self.subnets);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CacheSubnetGroup`](crate::model::CacheSubnetGroup)
pub mod cache_subnet_group {
    /// A builder for [`CacheSubnetGroup`](crate::model::CacheSubnetGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) cache_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cache subnet group.</p>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache subnet group.</p>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_name = input;
            self
        }
        /// <p>The description of the cache subnet group.</p>
        pub fn cache_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_description = Some(input.into());
            self
        }
        /// <p>The description of the cache subnet group.</p>
        pub fn set_cache_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_description = input;
            self
        }
        /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>A list of subnets associated with the cache subnet group.</p>
        pub fn subnets(mut self, input: impl Into<crate::model::Subnet>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>A list of subnets associated with the cache subnet group.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the cache subnet group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the cache subnet group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheSubnetGroup`](crate::model::CacheSubnetGroup)
        pub fn build(self) -> crate::model::CacheSubnetGroup {
            crate::model::CacheSubnetGroup {
                cache_subnet_group_name: self.cache_subnet_group_name,
                cache_subnet_group_description: self.cache_subnet_group_description,
                vpc_id: self.vpc_id,
                subnets: self.subnets,
                arn: self.arn,
            }
        }
    }
}
impl CacheSubnetGroup {
    /// Creates a new builder-style object to manufacture [`CacheSubnetGroup`](crate::model::CacheSubnetGroup)
    pub fn builder() -> crate::model::cache_subnet_group::Builder {
        crate::model::cache_subnet_group::Builder::default()
    }
}

/// <p>Represents the subnet associated with a cluster.
/// This parameter refers to subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used with ElastiCache.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subnet {
    /// <p>The unique identifier for the subnet.</p>
    pub subnet_identifier: std::option::Option<std::string::String>,
    /// <p>The Availability Zone associated with the subnet.</p>
    pub subnet_availability_zone: std::option::Option<crate::model::AvailabilityZone>,
    /// <p>The outpost ARN of the subnet.</p>
    pub subnet_outpost: std::option::Option<crate::model::SubnetOutpost>,
}
impl Subnet {
    /// <p>The unique identifier for the subnet.</p>
    pub fn subnet_identifier(&self) -> std::option::Option<&str> {
        self.subnet_identifier.as_deref()
    }
    /// <p>The Availability Zone associated with the subnet.</p>
    pub fn subnet_availability_zone(&self) -> std::option::Option<&crate::model::AvailabilityZone> {
        self.subnet_availability_zone.as_ref()
    }
    /// <p>The outpost ARN of the subnet.</p>
    pub fn subnet_outpost(&self) -> std::option::Option<&crate::model::SubnetOutpost> {
        self.subnet_outpost.as_ref()
    }
}
impl std::fmt::Debug for Subnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subnet");
        formatter.field("subnet_identifier", &self.subnet_identifier);
        formatter.field("subnet_availability_zone", &self.subnet_availability_zone);
        formatter.field("subnet_outpost", &self.subnet_outpost);
        formatter.finish()
    }
}
/// See [`Subnet`](crate::model::Subnet)
pub mod subnet {
    /// A builder for [`Subnet`](crate::model::Subnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_identifier: std::option::Option<std::string::String>,
        pub(crate) subnet_availability_zone: std::option::Option<crate::model::AvailabilityZone>,
        pub(crate) subnet_outpost: std::option::Option<crate::model::SubnetOutpost>,
    }
    impl Builder {
        /// <p>The unique identifier for the subnet.</p>
        pub fn subnet_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier for the subnet.</p>
        pub fn set_subnet_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_identifier = input;
            self
        }
        /// <p>The Availability Zone associated with the subnet.</p>
        pub fn subnet_availability_zone(mut self, input: crate::model::AvailabilityZone) -> Self {
            self.subnet_availability_zone = Some(input);
            self
        }
        /// <p>The Availability Zone associated with the subnet.</p>
        pub fn set_subnet_availability_zone(
            mut self,
            input: std::option::Option<crate::model::AvailabilityZone>,
        ) -> Self {
            self.subnet_availability_zone = input;
            self
        }
        /// <p>The outpost ARN of the subnet.</p>
        pub fn subnet_outpost(mut self, input: crate::model::SubnetOutpost) -> Self {
            self.subnet_outpost = Some(input);
            self
        }
        /// <p>The outpost ARN of the subnet.</p>
        pub fn set_subnet_outpost(
            mut self,
            input: std::option::Option<crate::model::SubnetOutpost>,
        ) -> Self {
            self.subnet_outpost = input;
            self
        }
        /// Consumes the builder and constructs a [`Subnet`](crate::model::Subnet)
        pub fn build(self) -> crate::model::Subnet {
            crate::model::Subnet {
                subnet_identifier: self.subnet_identifier,
                subnet_availability_zone: self.subnet_availability_zone,
                subnet_outpost: self.subnet_outpost,
            }
        }
    }
}
impl Subnet {
    /// Creates a new builder-style object to manufacture [`Subnet`](crate::model::Subnet)
    pub fn builder() -> crate::model::subnet::Builder {
        crate::model::subnet::Builder::default()
    }
}

/// <p>The ID of the outpost subnet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetOutpost {
    /// <p>The outpost ARN of the subnet.</p>
    pub subnet_outpost_arn: std::option::Option<std::string::String>,
}
impl SubnetOutpost {
    /// <p>The outpost ARN of the subnet.</p>
    pub fn subnet_outpost_arn(&self) -> std::option::Option<&str> {
        self.subnet_outpost_arn.as_deref()
    }
}
impl std::fmt::Debug for SubnetOutpost {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetOutpost");
        formatter.field("subnet_outpost_arn", &self.subnet_outpost_arn);
        formatter.finish()
    }
}
/// See [`SubnetOutpost`](crate::model::SubnetOutpost)
pub mod subnet_outpost {
    /// A builder for [`SubnetOutpost`](crate::model::SubnetOutpost)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_outpost_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The outpost ARN of the subnet.</p>
        pub fn subnet_outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_outpost_arn = Some(input.into());
            self
        }
        /// <p>The outpost ARN of the subnet.</p>
        pub fn set_subnet_outpost_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_outpost_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetOutpost`](crate::model::SubnetOutpost)
        pub fn build(self) -> crate::model::SubnetOutpost {
            crate::model::SubnetOutpost {
                subnet_outpost_arn: self.subnet_outpost_arn,
            }
        }
    }
}
impl SubnetOutpost {
    /// Creates a new builder-style object to manufacture [`SubnetOutpost`](crate::model::SubnetOutpost)
    pub fn builder() -> crate::model::subnet_outpost::Builder {
        crate::model::subnet_outpost::Builder::default()
    }
}

/// <p>Describes an Availability Zone in which the cluster is launched.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailabilityZone {
    /// <p>The name of the Availability Zone.</p>
    pub name: std::option::Option<std::string::String>,
}
impl AvailabilityZone {
    /// <p>The name of the Availability Zone.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for AvailabilityZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailabilityZone");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AvailabilityZone`](crate::model::AvailabilityZone)
pub mod availability_zone {
    /// A builder for [`AvailabilityZone`](crate::model::AvailabilityZone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Availability Zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Availability Zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailabilityZone`](crate::model::AvailabilityZone)
        pub fn build(self) -> crate::model::AvailabilityZone {
            crate::model::AvailabilityZone { name: self.name }
        }
    }
}
impl AvailabilityZone {
    /// Creates a new builder-style object to manufacture [`AvailabilityZone`](crate::model::AvailabilityZone)
    pub fn builder() -> crate::model::availability_zone::Builder {
        crate::model::availability_zone::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AzMode {
    #[allow(missing_docs)] // documentation missing in model
    CrossAz,
    #[allow(missing_docs)] // documentation missing in model
    SingleAz,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AzMode {
    fn from(s: &str) -> Self {
        match s {
            "cross-az" => AzMode::CrossAz,
            "single-az" => AzMode::SingleAz,
            other => AzMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AzMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AzMode::from(s))
    }
}
impl AzMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AzMode::CrossAz => "cross-az",
            AzMode::SingleAz => "single-az",
            AzMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["cross-az", "single-az"]
    }
}
impl AsRef<str> for AzMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Node group (shard) configuration options when adding or removing replicas.
/// Each node group (shard) configuration has the following members: NodeGroupId, NewReplicaCount, and PreferredAvailabilityZones. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigureShard {
    /// <p>The 4-digit id for the node group you are configuring. For Redis (cluster mode disabled)
    /// replication groups, the node group id is always 0001. To find a Redis (cluster mode enabled)'s
    /// node group's (shard's) id, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/shard-find-id.html">Finding a Shard's Id</a>.</p>
    pub node_group_id: std::option::Option<std::string::String>,
    /// <p>The number of replicas you want  in this node group at the end of this operation.
    /// The maximum value for <code>NewReplicaCount</code> is 5.
    /// The minimum value depends upon the type of Redis replication group you are working with.</p>
    /// <p>The minimum number of replicas in a shard or replication group is:</p>
    /// <ul>
    /// <li>
    /// <p>Redis (cluster mode disabled)</p>
    /// <ul>
    /// <li>
    /// <p>If Multi-AZ: 1</p>
    /// </li>
    /// <li>
    /// <p>If Multi-AZ: 0</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)</p>
    /// </li>
    /// </ul>
    pub new_replica_count: i32,
    /// <p>A list of <code>PreferredAvailabilityZone</code> strings that specify which availability zones the
    /// replication group's nodes are to be in. The nummber of <code>PreferredAvailabilityZone</code> values must
    /// equal the value of <code>NewReplicaCount</code> plus 1 to account for the primary node. If this member of
    /// <code>ReplicaConfiguration</code> is omitted, ElastiCache for Redis selects the availability zone for  
    /// each of the replicas.</p>
    pub preferred_availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The outpost ARNs in which the cache cluster is created.</p>
    pub preferred_outpost_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ConfigureShard {
    /// <p>The 4-digit id for the node group you are configuring. For Redis (cluster mode disabled)
    /// replication groups, the node group id is always 0001. To find a Redis (cluster mode enabled)'s
    /// node group's (shard's) id, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/shard-find-id.html">Finding a Shard's Id</a>.</p>
    pub fn node_group_id(&self) -> std::option::Option<&str> {
        self.node_group_id.as_deref()
    }
    /// <p>The number of replicas you want  in this node group at the end of this operation.
    /// The maximum value for <code>NewReplicaCount</code> is 5.
    /// The minimum value depends upon the type of Redis replication group you are working with.</p>
    /// <p>The minimum number of replicas in a shard or replication group is:</p>
    /// <ul>
    /// <li>
    /// <p>Redis (cluster mode disabled)</p>
    /// <ul>
    /// <li>
    /// <p>If Multi-AZ: 1</p>
    /// </li>
    /// <li>
    /// <p>If Multi-AZ: 0</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)</p>
    /// </li>
    /// </ul>
    pub fn new_replica_count(&self) -> i32 {
        self.new_replica_count
    }
    /// <p>A list of <code>PreferredAvailabilityZone</code> strings that specify which availability zones the
    /// replication group's nodes are to be in. The nummber of <code>PreferredAvailabilityZone</code> values must
    /// equal the value of <code>NewReplicaCount</code> plus 1 to account for the primary node. If this member of
    /// <code>ReplicaConfiguration</code> is omitted, ElastiCache for Redis selects the availability zone for  
    /// each of the replicas.</p>
    pub fn preferred_availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.preferred_availability_zones.as_deref()
    }
    /// <p>The outpost ARNs in which the cache cluster is created.</p>
    pub fn preferred_outpost_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.preferred_outpost_arns.as_deref()
    }
}
impl std::fmt::Debug for ConfigureShard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigureShard");
        formatter.field("node_group_id", &self.node_group_id);
        formatter.field("new_replica_count", &self.new_replica_count);
        formatter.field(
            "preferred_availability_zones",
            &self.preferred_availability_zones,
        );
        formatter.field("preferred_outpost_arns", &self.preferred_outpost_arns);
        formatter.finish()
    }
}
/// See [`ConfigureShard`](crate::model::ConfigureShard)
pub mod configure_shard {
    /// A builder for [`ConfigureShard`](crate::model::ConfigureShard)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_group_id: std::option::Option<std::string::String>,
        pub(crate) new_replica_count: std::option::Option<i32>,
        pub(crate) preferred_availability_zones:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) preferred_outpost_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The 4-digit id for the node group you are configuring. For Redis (cluster mode disabled)
        /// replication groups, the node group id is always 0001. To find a Redis (cluster mode enabled)'s
        /// node group's (shard's) id, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/shard-find-id.html">Finding a Shard's Id</a>.</p>
        pub fn node_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_group_id = Some(input.into());
            self
        }
        /// <p>The 4-digit id for the node group you are configuring. For Redis (cluster mode disabled)
        /// replication groups, the node group id is always 0001. To find a Redis (cluster mode enabled)'s
        /// node group's (shard's) id, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/shard-find-id.html">Finding a Shard's Id</a>.</p>
        pub fn set_node_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.node_group_id = input;
            self
        }
        /// <p>The number of replicas you want  in this node group at the end of this operation.
        /// The maximum value for <code>NewReplicaCount</code> is 5.
        /// The minimum value depends upon the type of Redis replication group you are working with.</p>
        /// <p>The minimum number of replicas in a shard or replication group is:</p>
        /// <ul>
        /// <li>
        /// <p>Redis (cluster mode disabled)</p>
        /// <ul>
        /// <li>
        /// <p>If Multi-AZ: 1</p>
        /// </li>
        /// <li>
        /// <p>If Multi-AZ: 0</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)</p>
        /// </li>
        /// </ul>
        pub fn new_replica_count(mut self, input: i32) -> Self {
            self.new_replica_count = Some(input);
            self
        }
        /// <p>The number of replicas you want  in this node group at the end of this operation.
        /// The maximum value for <code>NewReplicaCount</code> is 5.
        /// The minimum value depends upon the type of Redis replication group you are working with.</p>
        /// <p>The minimum number of replicas in a shard or replication group is:</p>
        /// <ul>
        /// <li>
        /// <p>Redis (cluster mode disabled)</p>
        /// <ul>
        /// <li>
        /// <p>If Multi-AZ: 1</p>
        /// </li>
        /// <li>
        /// <p>If Multi-AZ: 0</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)</p>
        /// </li>
        /// </ul>
        pub fn set_new_replica_count(mut self, input: std::option::Option<i32>) -> Self {
            self.new_replica_count = input;
            self
        }
        /// Appends an item to `preferred_availability_zones`.
        ///
        /// To override the contents of this collection use [`set_preferred_availability_zones`](Self::set_preferred_availability_zones).
        ///
        /// <p>A list of <code>PreferredAvailabilityZone</code> strings that specify which availability zones the
        /// replication group's nodes are to be in. The nummber of <code>PreferredAvailabilityZone</code> values must
        /// equal the value of <code>NewReplicaCount</code> plus 1 to account for the primary node. If this member of
        /// <code>ReplicaConfiguration</code> is omitted, ElastiCache for Redis selects the availability zone for  
        /// each of the replicas.</p>
        pub fn preferred_availability_zones(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.preferred_availability_zones.unwrap_or_default();
            v.push(input.into());
            self.preferred_availability_zones = Some(v);
            self
        }
        /// <p>A list of <code>PreferredAvailabilityZone</code> strings that specify which availability zones the
        /// replication group's nodes are to be in. The nummber of <code>PreferredAvailabilityZone</code> values must
        /// equal the value of <code>NewReplicaCount</code> plus 1 to account for the primary node. If this member of
        /// <code>ReplicaConfiguration</code> is omitted, ElastiCache for Redis selects the availability zone for  
        /// each of the replicas.</p>
        pub fn set_preferred_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.preferred_availability_zones = input;
            self
        }
        /// Appends an item to `preferred_outpost_arns`.
        ///
        /// To override the contents of this collection use [`set_preferred_outpost_arns`](Self::set_preferred_outpost_arns).
        ///
        /// <p>The outpost ARNs in which the cache cluster is created.</p>
        pub fn preferred_outpost_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.preferred_outpost_arns.unwrap_or_default();
            v.push(input.into());
            self.preferred_outpost_arns = Some(v);
            self
        }
        /// <p>The outpost ARNs in which the cache cluster is created.</p>
        pub fn set_preferred_outpost_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.preferred_outpost_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigureShard`](crate::model::ConfigureShard)
        pub fn build(self) -> crate::model::ConfigureShard {
            crate::model::ConfigureShard {
                node_group_id: self.node_group_id,
                new_replica_count: self.new_replica_count.unwrap_or_default(),
                preferred_availability_zones: self.preferred_availability_zones,
                preferred_outpost_arns: self.preferred_outpost_arns,
            }
        }
    }
}
impl ConfigureShard {
    /// Creates a new builder-style object to manufacture [`ConfigureShard`](crate::model::ConfigureShard)
    pub fn builder() -> crate::model::configure_shard::Builder {
        crate::model::configure_shard::Builder::default()
    }
}

/// <p>A list of the replication groups </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegionalConfiguration {
    /// <p>The name of the secondary cluster</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The Amazon region where the cluster is stored</p>
    pub replication_group_region: std::option::Option<std::string::String>,
    /// <p>A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node group in the resharded cluster. </p>
    pub resharding_configuration:
        std::option::Option<std::vec::Vec<crate::model::ReshardingConfiguration>>,
}
impl RegionalConfiguration {
    /// <p>The name of the secondary cluster</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The Amazon region where the cluster is stored</p>
    pub fn replication_group_region(&self) -> std::option::Option<&str> {
        self.replication_group_region.as_deref()
    }
    /// <p>A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node group in the resharded cluster. </p>
    pub fn resharding_configuration(
        &self,
    ) -> std::option::Option<&[crate::model::ReshardingConfiguration]> {
        self.resharding_configuration.as_deref()
    }
}
impl std::fmt::Debug for RegionalConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegionalConfiguration");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("replication_group_region", &self.replication_group_region);
        formatter.field("resharding_configuration", &self.resharding_configuration);
        formatter.finish()
    }
}
/// See [`RegionalConfiguration`](crate::model::RegionalConfiguration)
pub mod regional_configuration {
    /// A builder for [`RegionalConfiguration`](crate::model::RegionalConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) replication_group_region: std::option::Option<std::string::String>,
        pub(crate) resharding_configuration:
            std::option::Option<std::vec::Vec<crate::model::ReshardingConfiguration>>,
    }
    impl Builder {
        /// <p>The name of the secondary cluster</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The name of the secondary cluster</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The Amazon region where the cluster is stored</p>
        pub fn replication_group_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_region = Some(input.into());
            self
        }
        /// <p>The Amazon region where the cluster is stored</p>
        pub fn set_replication_group_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_region = input;
            self
        }
        /// Appends an item to `resharding_configuration`.
        ///
        /// To override the contents of this collection use [`set_resharding_configuration`](Self::set_resharding_configuration).
        ///
        /// <p>A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node group in the resharded cluster. </p>
        pub fn resharding_configuration(
            mut self,
            input: impl Into<crate::model::ReshardingConfiguration>,
        ) -> Self {
            let mut v = self.resharding_configuration.unwrap_or_default();
            v.push(input.into());
            self.resharding_configuration = Some(v);
            self
        }
        /// <p>A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node group in the resharded cluster. </p>
        pub fn set_resharding_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReshardingConfiguration>>,
        ) -> Self {
            self.resharding_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`RegionalConfiguration`](crate::model::RegionalConfiguration)
        pub fn build(self) -> crate::model::RegionalConfiguration {
            crate::model::RegionalConfiguration {
                replication_group_id: self.replication_group_id,
                replication_group_region: self.replication_group_region,
                resharding_configuration: self.resharding_configuration,
            }
        }
    }
}
impl RegionalConfiguration {
    /// Creates a new builder-style object to manufacture [`RegionalConfiguration`](crate::model::RegionalConfiguration)
    pub fn builder() -> crate::model::regional_configuration::Builder {
        crate::model::regional_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct User {
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The username of the user.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The current supported value is Redis.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>Access permissions string used for this user.</p>
    pub access_string: std::option::Option<std::string::String>,
    /// <p>Returns a list of the user group IDs the user belongs to.</p>
    pub user_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Denotes whether the user requires a password to authenticate.</p>
    pub authentication: std::option::Option<crate::model::Authentication>,
    /// <p>The Amazon Resource Name (ARN) of the user.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl User {
    /// <p>The ID of the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The username of the user.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The current supported value is Redis.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>Access permissions string used for this user.</p>
    pub fn access_string(&self) -> std::option::Option<&str> {
        self.access_string.as_deref()
    }
    /// <p>Returns a list of the user group IDs the user belongs to.</p>
    pub fn user_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.user_group_ids.as_deref()
    }
    /// <p>Denotes whether the user requires a password to authenticate.</p>
    pub fn authentication(&self) -> std::option::Option<&crate::model::Authentication> {
        self.authentication.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for User {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("User");
        formatter.field("user_id", &self.user_id);
        formatter.field("user_name", &self.user_name);
        formatter.field("status", &self.status);
        formatter.field("engine", &self.engine);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("access_string", &self.access_string);
        formatter.field("user_group_ids", &self.user_group_ids);
        formatter.field("authentication", &self.authentication);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`User`](crate::model::User)
pub mod user {
    /// A builder for [`User`](crate::model::User)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) access_string: std::option::Option<std::string::String>,
        pub(crate) user_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) authentication: std::option::Option<crate::model::Authentication>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The username of the user.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The username of the user.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The current supported value is Redis.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The current supported value is Redis.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_string = Some(input.into());
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_string = input;
            self
        }
        /// Appends an item to `user_group_ids`.
        ///
        /// To override the contents of this collection use [`set_user_group_ids`](Self::set_user_group_ids).
        ///
        /// <p>Returns a list of the user group IDs the user belongs to.</p>
        pub fn user_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_group_ids.unwrap_or_default();
            v.push(input.into());
            self.user_group_ids = Some(v);
            self
        }
        /// <p>Returns a list of the user group IDs the user belongs to.</p>
        pub fn set_user_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_group_ids = input;
            self
        }
        /// <p>Denotes whether the user requires a password to authenticate.</p>
        pub fn authentication(mut self, input: crate::model::Authentication) -> Self {
            self.authentication = Some(input);
            self
        }
        /// <p>Denotes whether the user requires a password to authenticate.</p>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<crate::model::Authentication>,
        ) -> Self {
            self.authentication = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`User`](crate::model::User)
        pub fn build(self) -> crate::model::User {
            crate::model::User {
                user_id: self.user_id,
                user_name: self.user_name,
                status: self.status,
                engine: self.engine,
                minimum_engine_version: self.minimum_engine_version,
                access_string: self.access_string,
                user_group_ids: self.user_group_ids,
                authentication: self.authentication,
                arn: self.arn,
            }
        }
    }
}
impl User {
    /// Creates a new builder-style object to manufacture [`User`](crate::model::User)
    pub fn builder() -> crate::model::user::Builder {
        crate::model::user::Builder::default()
    }
}

/// <p>Used to streamline results of a search based on the property being filtered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The property being filtered. For example, UserId.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The property values to filter on. For example, "user-123".</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Filter {
    /// <p>The property being filtered. For example, UserId.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The property values to filter on. For example, "user-123".</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The property being filtered. For example, UserId.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The property being filtered. For example, UserId.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The property values to filter on. For example, "user-123".</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The property values to filter on. For example, "user-123".</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserGroup {
    /// <p>The ID of the user group.</p>
    pub user_group_id: std::option::Option<std::string::String>,
    /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The current supported value is Redis. </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The list of user IDs that belong to the user group.</p>
    pub user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>A list of updates being applied to the user group.</p>
    pub pending_changes: std::option::Option<crate::model::UserGroupPendingChanges>,
    /// <p>A list of replication groups that the user group can access.</p>
    pub replication_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the user group.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl UserGroup {
    /// <p>The ID of the user group.</p>
    pub fn user_group_id(&self) -> std::option::Option<&str> {
        self.user_group_id.as_deref()
    }
    /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The current supported value is Redis. </p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The list of user IDs that belong to the user group.</p>
    pub fn user_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.user_ids.as_deref()
    }
    /// <p>The minimum engine version required, which is Redis 6.0</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>A list of updates being applied to the user group.</p>
    pub fn pending_changes(&self) -> std::option::Option<&crate::model::UserGroupPendingChanges> {
        self.pending_changes.as_ref()
    }
    /// <p>A list of replication groups that the user group can access.</p>
    pub fn replication_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.replication_groups.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for UserGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserGroup");
        formatter.field("user_group_id", &self.user_group_id);
        formatter.field("status", &self.status);
        formatter.field("engine", &self.engine);
        formatter.field("user_ids", &self.user_ids);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("pending_changes", &self.pending_changes);
        formatter.field("replication_groups", &self.replication_groups);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`UserGroup`](crate::model::UserGroup)
pub mod user_group {
    /// A builder for [`UserGroup`](crate::model::UserGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_group_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) pending_changes: std::option::Option<crate::model::UserGroupPendingChanges>,
        pub(crate) replication_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user group.</p>
        pub fn user_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the user group.</p>
        pub fn set_user_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_group_id = input;
            self
        }
        /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// Appends an item to `user_ids`.
        ///
        /// To override the contents of this collection use [`set_user_ids`](Self::set_user_ids).
        ///
        /// <p>The list of user IDs that belong to the user group.</p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_ids.unwrap_or_default();
            v.push(input.into());
            self.user_ids = Some(v);
            self
        }
        /// <p>The list of user IDs that belong to the user group.</p>
        pub fn set_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_ids = input;
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The minimum engine version required, which is Redis 6.0</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>A list of updates being applied to the user group.</p>
        pub fn pending_changes(mut self, input: crate::model::UserGroupPendingChanges) -> Self {
            self.pending_changes = Some(input);
            self
        }
        /// <p>A list of updates being applied to the user group.</p>
        pub fn set_pending_changes(
            mut self,
            input: std::option::Option<crate::model::UserGroupPendingChanges>,
        ) -> Self {
            self.pending_changes = input;
            self
        }
        /// Appends an item to `replication_groups`.
        ///
        /// To override the contents of this collection use [`set_replication_groups`](Self::set_replication_groups).
        ///
        /// <p>A list of replication groups that the user group can access.</p>
        pub fn replication_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.replication_groups.unwrap_or_default();
            v.push(input.into());
            self.replication_groups = Some(v);
            self
        }
        /// <p>A list of replication groups that the user group can access.</p>
        pub fn set_replication_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_groups = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UserGroup`](crate::model::UserGroup)
        pub fn build(self) -> crate::model::UserGroup {
            crate::model::UserGroup {
                user_group_id: self.user_group_id,
                status: self.status,
                engine: self.engine,
                user_ids: self.user_ids,
                minimum_engine_version: self.minimum_engine_version,
                pending_changes: self.pending_changes,
                replication_groups: self.replication_groups,
                arn: self.arn,
            }
        }
    }
}
impl UserGroup {
    /// Creates a new builder-style object to manufacture [`UserGroup`](crate::model::UserGroup)
    pub fn builder() -> crate::model::user_group::Builder {
        crate::model::user_group::Builder::default()
    }
}

/// <p>The status of the service update for a specific replication group</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAction {
    /// <p>The ID of the replication group</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The ID of the cache cluster</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>The unique ID of the service update</p>
    pub service_update_name: std::option::Option<std::string::String>,
    /// <p>The date the update is first available</p>
    pub service_update_release_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The severity of the service update</p>
    pub service_update_severity: std::option::Option<crate::model::ServiceUpdateSeverity>,
    /// <p>The status of the service update</p>
    pub service_update_status: std::option::Option<crate::model::ServiceUpdateStatus>,
    /// <p>The recommended date to apply the service update to ensure compliance. For information on compliance, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service">Self-Service Security Updates for Compliance</a>.</p>
    pub service_update_recommended_apply_by_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Reflects the nature of the service update  </p>
    pub service_update_type: std::option::Option<crate::model::ServiceUpdateType>,
    /// <p>The date that the service update is available to a replication group</p>
    pub update_action_available_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the update action</p>
    pub update_action_status: std::option::Option<crate::model::UpdateActionStatus>,
    /// <p>The progress of the service update on the replication group</p>
    pub nodes_updated: std::option::Option<std::string::String>,
    /// <p>The date when the UpdateActionStatus was last modified</p>
    pub update_action_status_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If yes, all nodes in the replication group have been updated by the recommended apply-by date. If no, at least one node in the replication group have not been updated by the recommended apply-by date. If N/A, the replication group was created after the
    /// recommended apply-by date.</p>
    pub sla_met: std::option::Option<crate::model::SlaMet>,
    /// <p>The status of the service update on the node group</p>
    pub node_group_update_status:
        std::option::Option<std::vec::Vec<crate::model::NodeGroupUpdateStatus>>,
    /// <p>The status of the service update on the cache node</p>
    pub cache_node_update_status:
        std::option::Option<std::vec::Vec<crate::model::CacheNodeUpdateStatus>>,
    /// <p>The estimated length of time for the update to complete</p>
    pub estimated_update_time: std::option::Option<std::string::String>,
    /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached</p>
    pub engine: std::option::Option<std::string::String>,
}
impl UpdateAction {
    /// <p>The ID of the replication group</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The ID of the cache cluster</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>The unique ID of the service update</p>
    pub fn service_update_name(&self) -> std::option::Option<&str> {
        self.service_update_name.as_deref()
    }
    /// <p>The date the update is first available</p>
    pub fn service_update_release_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.service_update_release_date.as_ref()
    }
    /// <p>The severity of the service update</p>
    pub fn service_update_severity(
        &self,
    ) -> std::option::Option<&crate::model::ServiceUpdateSeverity> {
        self.service_update_severity.as_ref()
    }
    /// <p>The status of the service update</p>
    pub fn service_update_status(&self) -> std::option::Option<&crate::model::ServiceUpdateStatus> {
        self.service_update_status.as_ref()
    }
    /// <p>The recommended date to apply the service update to ensure compliance. For information on compliance, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service">Self-Service Security Updates for Compliance</a>.</p>
    pub fn service_update_recommended_apply_by_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.service_update_recommended_apply_by_date.as_ref()
    }
    /// <p>Reflects the nature of the service update  </p>
    pub fn service_update_type(&self) -> std::option::Option<&crate::model::ServiceUpdateType> {
        self.service_update_type.as_ref()
    }
    /// <p>The date that the service update is available to a replication group</p>
    pub fn update_action_available_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_action_available_date.as_ref()
    }
    /// <p>The status of the update action</p>
    pub fn update_action_status(&self) -> std::option::Option<&crate::model::UpdateActionStatus> {
        self.update_action_status.as_ref()
    }
    /// <p>The progress of the service update on the replication group</p>
    pub fn nodes_updated(&self) -> std::option::Option<&str> {
        self.nodes_updated.as_deref()
    }
    /// <p>The date when the UpdateActionStatus was last modified</p>
    pub fn update_action_status_modified_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_action_status_modified_date.as_ref()
    }
    /// <p>If yes, all nodes in the replication group have been updated by the recommended apply-by date. If no, at least one node in the replication group have not been updated by the recommended apply-by date. If N/A, the replication group was created after the
    /// recommended apply-by date.</p>
    pub fn sla_met(&self) -> std::option::Option<&crate::model::SlaMet> {
        self.sla_met.as_ref()
    }
    /// <p>The status of the service update on the node group</p>
    pub fn node_group_update_status(
        &self,
    ) -> std::option::Option<&[crate::model::NodeGroupUpdateStatus]> {
        self.node_group_update_status.as_deref()
    }
    /// <p>The status of the service update on the cache node</p>
    pub fn cache_node_update_status(
        &self,
    ) -> std::option::Option<&[crate::model::CacheNodeUpdateStatus]> {
        self.cache_node_update_status.as_deref()
    }
    /// <p>The estimated length of time for the update to complete</p>
    pub fn estimated_update_time(&self) -> std::option::Option<&str> {
        self.estimated_update_time.as_deref()
    }
    /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
}
impl std::fmt::Debug for UpdateAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAction");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("service_update_name", &self.service_update_name);
        formatter.field(
            "service_update_release_date",
            &self.service_update_release_date,
        );
        formatter.field("service_update_severity", &self.service_update_severity);
        formatter.field("service_update_status", &self.service_update_status);
        formatter.field(
            "service_update_recommended_apply_by_date",
            &self.service_update_recommended_apply_by_date,
        );
        formatter.field("service_update_type", &self.service_update_type);
        formatter.field(
            "update_action_available_date",
            &self.update_action_available_date,
        );
        formatter.field("update_action_status", &self.update_action_status);
        formatter.field("nodes_updated", &self.nodes_updated);
        formatter.field(
            "update_action_status_modified_date",
            &self.update_action_status_modified_date,
        );
        formatter.field("sla_met", &self.sla_met);
        formatter.field("node_group_update_status", &self.node_group_update_status);
        formatter.field("cache_node_update_status", &self.cache_node_update_status);
        formatter.field("estimated_update_time", &self.estimated_update_time);
        formatter.field("engine", &self.engine);
        formatter.finish()
    }
}
/// See [`UpdateAction`](crate::model::UpdateAction)
pub mod update_action {
    /// A builder for [`UpdateAction`](crate::model::UpdateAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) service_update_name: std::option::Option<std::string::String>,
        pub(crate) service_update_release_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) service_update_severity:
            std::option::Option<crate::model::ServiceUpdateSeverity>,
        pub(crate) service_update_status: std::option::Option<crate::model::ServiceUpdateStatus>,
        pub(crate) service_update_recommended_apply_by_date:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) service_update_type: std::option::Option<crate::model::ServiceUpdateType>,
        pub(crate) update_action_available_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_action_status: std::option::Option<crate::model::UpdateActionStatus>,
        pub(crate) nodes_updated: std::option::Option<std::string::String>,
        pub(crate) update_action_status_modified_date:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) sla_met: std::option::Option<crate::model::SlaMet>,
        pub(crate) node_group_update_status:
            std::option::Option<std::vec::Vec<crate::model::NodeGroupUpdateStatus>>,
        pub(crate) cache_node_update_status:
            std::option::Option<std::vec::Vec<crate::model::CacheNodeUpdateStatus>>,
        pub(crate) estimated_update_time: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the replication group</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication group</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The ID of the cache cluster</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the cache cluster</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_update_name = Some(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_update_name = input;
            self
        }
        /// <p>The date the update is first available</p>
        pub fn service_update_release_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.service_update_release_date = Some(input);
            self
        }
        /// <p>The date the update is first available</p>
        pub fn set_service_update_release_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.service_update_release_date = input;
            self
        }
        /// <p>The severity of the service update</p>
        pub fn service_update_severity(
            mut self,
            input: crate::model::ServiceUpdateSeverity,
        ) -> Self {
            self.service_update_severity = Some(input);
            self
        }
        /// <p>The severity of the service update</p>
        pub fn set_service_update_severity(
            mut self,
            input: std::option::Option<crate::model::ServiceUpdateSeverity>,
        ) -> Self {
            self.service_update_severity = input;
            self
        }
        /// <p>The status of the service update</p>
        pub fn service_update_status(mut self, input: crate::model::ServiceUpdateStatus) -> Self {
            self.service_update_status = Some(input);
            self
        }
        /// <p>The status of the service update</p>
        pub fn set_service_update_status(
            mut self,
            input: std::option::Option<crate::model::ServiceUpdateStatus>,
        ) -> Self {
            self.service_update_status = input;
            self
        }
        /// <p>The recommended date to apply the service update to ensure compliance. For information on compliance, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service">Self-Service Security Updates for Compliance</a>.</p>
        pub fn service_update_recommended_apply_by_date(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.service_update_recommended_apply_by_date = Some(input);
            self
        }
        /// <p>The recommended date to apply the service update to ensure compliance. For information on compliance, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service">Self-Service Security Updates for Compliance</a>.</p>
        pub fn set_service_update_recommended_apply_by_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.service_update_recommended_apply_by_date = input;
            self
        }
        /// <p>Reflects the nature of the service update  </p>
        pub fn service_update_type(mut self, input: crate::model::ServiceUpdateType) -> Self {
            self.service_update_type = Some(input);
            self
        }
        /// <p>Reflects the nature of the service update  </p>
        pub fn set_service_update_type(
            mut self,
            input: std::option::Option<crate::model::ServiceUpdateType>,
        ) -> Self {
            self.service_update_type = input;
            self
        }
        /// <p>The date that the service update is available to a replication group</p>
        pub fn update_action_available_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_action_available_date = Some(input);
            self
        }
        /// <p>The date that the service update is available to a replication group</p>
        pub fn set_update_action_available_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_action_available_date = input;
            self
        }
        /// <p>The status of the update action</p>
        pub fn update_action_status(mut self, input: crate::model::UpdateActionStatus) -> Self {
            self.update_action_status = Some(input);
            self
        }
        /// <p>The status of the update action</p>
        pub fn set_update_action_status(
            mut self,
            input: std::option::Option<crate::model::UpdateActionStatus>,
        ) -> Self {
            self.update_action_status = input;
            self
        }
        /// <p>The progress of the service update on the replication group</p>
        pub fn nodes_updated(mut self, input: impl Into<std::string::String>) -> Self {
            self.nodes_updated = Some(input.into());
            self
        }
        /// <p>The progress of the service update on the replication group</p>
        pub fn set_nodes_updated(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nodes_updated = input;
            self
        }
        /// <p>The date when the UpdateActionStatus was last modified</p>
        pub fn update_action_status_modified_date(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.update_action_status_modified_date = Some(input);
            self
        }
        /// <p>The date when the UpdateActionStatus was last modified</p>
        pub fn set_update_action_status_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_action_status_modified_date = input;
            self
        }
        /// <p>If yes, all nodes in the replication group have been updated by the recommended apply-by date. If no, at least one node in the replication group have not been updated by the recommended apply-by date. If N/A, the replication group was created after the
        /// recommended apply-by date.</p>
        pub fn sla_met(mut self, input: crate::model::SlaMet) -> Self {
            self.sla_met = Some(input);
            self
        }
        /// <p>If yes, all nodes in the replication group have been updated by the recommended apply-by date. If no, at least one node in the replication group have not been updated by the recommended apply-by date. If N/A, the replication group was created after the
        /// recommended apply-by date.</p>
        pub fn set_sla_met(mut self, input: std::option::Option<crate::model::SlaMet>) -> Self {
            self.sla_met = input;
            self
        }
        /// Appends an item to `node_group_update_status`.
        ///
        /// To override the contents of this collection use [`set_node_group_update_status`](Self::set_node_group_update_status).
        ///
        /// <p>The status of the service update on the node group</p>
        pub fn node_group_update_status(
            mut self,
            input: impl Into<crate::model::NodeGroupUpdateStatus>,
        ) -> Self {
            let mut v = self.node_group_update_status.unwrap_or_default();
            v.push(input.into());
            self.node_group_update_status = Some(v);
            self
        }
        /// <p>The status of the service update on the node group</p>
        pub fn set_node_group_update_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeGroupUpdateStatus>>,
        ) -> Self {
            self.node_group_update_status = input;
            self
        }
        /// Appends an item to `cache_node_update_status`.
        ///
        /// To override the contents of this collection use [`set_cache_node_update_status`](Self::set_cache_node_update_status).
        ///
        /// <p>The status of the service update on the cache node</p>
        pub fn cache_node_update_status(
            mut self,
            input: impl Into<crate::model::CacheNodeUpdateStatus>,
        ) -> Self {
            let mut v = self.cache_node_update_status.unwrap_or_default();
            v.push(input.into());
            self.cache_node_update_status = Some(v);
            self
        }
        /// <p>The status of the service update on the cache node</p>
        pub fn set_cache_node_update_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheNodeUpdateStatus>>,
        ) -> Self {
            self.cache_node_update_status = input;
            self
        }
        /// <p>The estimated length of time for the update to complete</p>
        pub fn estimated_update_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_update_time = Some(input.into());
            self
        }
        /// <p>The estimated length of time for the update to complete</p>
        pub fn set_estimated_update_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_update_time = input;
            self
        }
        /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAction`](crate::model::UpdateAction)
        pub fn build(self) -> crate::model::UpdateAction {
            crate::model::UpdateAction {
                replication_group_id: self.replication_group_id,
                cache_cluster_id: self.cache_cluster_id,
                service_update_name: self.service_update_name,
                service_update_release_date: self.service_update_release_date,
                service_update_severity: self.service_update_severity,
                service_update_status: self.service_update_status,
                service_update_recommended_apply_by_date: self
                    .service_update_recommended_apply_by_date,
                service_update_type: self.service_update_type,
                update_action_available_date: self.update_action_available_date,
                update_action_status: self.update_action_status,
                nodes_updated: self.nodes_updated,
                update_action_status_modified_date: self.update_action_status_modified_date,
                sla_met: self.sla_met,
                node_group_update_status: self.node_group_update_status,
                cache_node_update_status: self.cache_node_update_status,
                estimated_update_time: self.estimated_update_time,
                engine: self.engine,
            }
        }
    }
}
impl UpdateAction {
    /// Creates a new builder-style object to manufacture [`UpdateAction`](crate::model::UpdateAction)
    pub fn builder() -> crate::model::update_action::Builder {
        crate::model::update_action::Builder::default()
    }
}

/// <p>The status of the service update on the cache node</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheNodeUpdateStatus {
    /// <p>The node ID of the cache cluster</p>
    pub cache_node_id: std::option::Option<std::string::String>,
    /// <p>The update status of the node</p>
    pub node_update_status: std::option::Option<crate::model::NodeUpdateStatus>,
    /// <p>The deletion date of the node</p>
    pub node_deletion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The start date of the update for a node</p>
    pub node_update_start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end date of the update for a node</p>
    pub node_update_end_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Reflects whether the update was initiated by the customer or automatically applied</p>
    pub node_update_initiated_by: std::option::Option<crate::model::NodeUpdateInitiatedBy>,
    /// <p>The date when the update is triggered</p>
    pub node_update_initiated_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the NodeUpdateStatus was last modified></p>
    pub node_update_status_modified_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl CacheNodeUpdateStatus {
    /// <p>The node ID of the cache cluster</p>
    pub fn cache_node_id(&self) -> std::option::Option<&str> {
        self.cache_node_id.as_deref()
    }
    /// <p>The update status of the node</p>
    pub fn node_update_status(&self) -> std::option::Option<&crate::model::NodeUpdateStatus> {
        self.node_update_status.as_ref()
    }
    /// <p>The deletion date of the node</p>
    pub fn node_deletion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.node_deletion_date.as_ref()
    }
    /// <p>The start date of the update for a node</p>
    pub fn node_update_start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.node_update_start_date.as_ref()
    }
    /// <p>The end date of the update for a node</p>
    pub fn node_update_end_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.node_update_end_date.as_ref()
    }
    /// <p>Reflects whether the update was initiated by the customer or automatically applied</p>
    pub fn node_update_initiated_by(
        &self,
    ) -> std::option::Option<&crate::model::NodeUpdateInitiatedBy> {
        self.node_update_initiated_by.as_ref()
    }
    /// <p>The date when the update is triggered</p>
    pub fn node_update_initiated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.node_update_initiated_date.as_ref()
    }
    /// <p>The date when the NodeUpdateStatus was last modified></p>
    pub fn node_update_status_modified_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.node_update_status_modified_date.as_ref()
    }
}
impl std::fmt::Debug for CacheNodeUpdateStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheNodeUpdateStatus");
        formatter.field("cache_node_id", &self.cache_node_id);
        formatter.field("node_update_status", &self.node_update_status);
        formatter.field("node_deletion_date", &self.node_deletion_date);
        formatter.field("node_update_start_date", &self.node_update_start_date);
        formatter.field("node_update_end_date", &self.node_update_end_date);
        formatter.field("node_update_initiated_by", &self.node_update_initiated_by);
        formatter.field(
            "node_update_initiated_date",
            &self.node_update_initiated_date,
        );
        formatter.field(
            "node_update_status_modified_date",
            &self.node_update_status_modified_date,
        );
        formatter.finish()
    }
}
/// See [`CacheNodeUpdateStatus`](crate::model::CacheNodeUpdateStatus)
pub mod cache_node_update_status {
    /// A builder for [`CacheNodeUpdateStatus`](crate::model::CacheNodeUpdateStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_node_id: std::option::Option<std::string::String>,
        pub(crate) node_update_status: std::option::Option<crate::model::NodeUpdateStatus>,
        pub(crate) node_deletion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) node_update_start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) node_update_end_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) node_update_initiated_by:
            std::option::Option<crate::model::NodeUpdateInitiatedBy>,
        pub(crate) node_update_initiated_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) node_update_status_modified_date:
            std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The node ID of the cache cluster</p>
        pub fn cache_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_id = Some(input.into());
            self
        }
        /// <p>The node ID of the cache cluster</p>
        pub fn set_cache_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_id = input;
            self
        }
        /// <p>The update status of the node</p>
        pub fn node_update_status(mut self, input: crate::model::NodeUpdateStatus) -> Self {
            self.node_update_status = Some(input);
            self
        }
        /// <p>The update status of the node</p>
        pub fn set_node_update_status(
            mut self,
            input: std::option::Option<crate::model::NodeUpdateStatus>,
        ) -> Self {
            self.node_update_status = input;
            self
        }
        /// <p>The deletion date of the node</p>
        pub fn node_deletion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.node_deletion_date = Some(input);
            self
        }
        /// <p>The deletion date of the node</p>
        pub fn set_node_deletion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.node_deletion_date = input;
            self
        }
        /// <p>The start date of the update for a node</p>
        pub fn node_update_start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.node_update_start_date = Some(input);
            self
        }
        /// <p>The start date of the update for a node</p>
        pub fn set_node_update_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.node_update_start_date = input;
            self
        }
        /// <p>The end date of the update for a node</p>
        pub fn node_update_end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.node_update_end_date = Some(input);
            self
        }
        /// <p>The end date of the update for a node</p>
        pub fn set_node_update_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.node_update_end_date = input;
            self
        }
        /// <p>Reflects whether the update was initiated by the customer or automatically applied</p>
        pub fn node_update_initiated_by(
            mut self,
            input: crate::model::NodeUpdateInitiatedBy,
        ) -> Self {
            self.node_update_initiated_by = Some(input);
            self
        }
        /// <p>Reflects whether the update was initiated by the customer or automatically applied</p>
        pub fn set_node_update_initiated_by(
            mut self,
            input: std::option::Option<crate::model::NodeUpdateInitiatedBy>,
        ) -> Self {
            self.node_update_initiated_by = input;
            self
        }
        /// <p>The date when the update is triggered</p>
        pub fn node_update_initiated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.node_update_initiated_date = Some(input);
            self
        }
        /// <p>The date when the update is triggered</p>
        pub fn set_node_update_initiated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.node_update_initiated_date = input;
            self
        }
        /// <p>The date when the NodeUpdateStatus was last modified></p>
        pub fn node_update_status_modified_date(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.node_update_status_modified_date = Some(input);
            self
        }
        /// <p>The date when the NodeUpdateStatus was last modified></p>
        pub fn set_node_update_status_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.node_update_status_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheNodeUpdateStatus`](crate::model::CacheNodeUpdateStatus)
        pub fn build(self) -> crate::model::CacheNodeUpdateStatus {
            crate::model::CacheNodeUpdateStatus {
                cache_node_id: self.cache_node_id,
                node_update_status: self.node_update_status,
                node_deletion_date: self.node_deletion_date,
                node_update_start_date: self.node_update_start_date,
                node_update_end_date: self.node_update_end_date,
                node_update_initiated_by: self.node_update_initiated_by,
                node_update_initiated_date: self.node_update_initiated_date,
                node_update_status_modified_date: self.node_update_status_modified_date,
            }
        }
    }
}
impl CacheNodeUpdateStatus {
    /// Creates a new builder-style object to manufacture [`CacheNodeUpdateStatus`](crate::model::CacheNodeUpdateStatus)
    pub fn builder() -> crate::model::cache_node_update_status::Builder {
        crate::model::cache_node_update_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NodeUpdateInitiatedBy {
    #[allow(missing_docs)] // documentation missing in model
    Customer,
    #[allow(missing_docs)] // documentation missing in model
    System,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NodeUpdateInitiatedBy {
    fn from(s: &str) -> Self {
        match s {
            "customer" => NodeUpdateInitiatedBy::Customer,
            "system" => NodeUpdateInitiatedBy::System,
            other => NodeUpdateInitiatedBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NodeUpdateInitiatedBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NodeUpdateInitiatedBy::from(s))
    }
}
impl NodeUpdateInitiatedBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NodeUpdateInitiatedBy::Customer => "customer",
            NodeUpdateInitiatedBy::System => "system",
            NodeUpdateInitiatedBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["customer", "system"]
    }
}
impl AsRef<str> for NodeUpdateInitiatedBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NodeUpdateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotApplied,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    WaitingToStart,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NodeUpdateStatus {
    fn from(s: &str) -> Self {
        match s {
            "complete" => NodeUpdateStatus::Complete,
            "in-progress" => NodeUpdateStatus::InProgress,
            "not-applied" => NodeUpdateStatus::NotApplied,
            "stopped" => NodeUpdateStatus::Stopped,
            "stopping" => NodeUpdateStatus::Stopping,
            "waiting-to-start" => NodeUpdateStatus::WaitingToStart,
            other => NodeUpdateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NodeUpdateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NodeUpdateStatus::from(s))
    }
}
impl NodeUpdateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NodeUpdateStatus::Complete => "complete",
            NodeUpdateStatus::InProgress => "in-progress",
            NodeUpdateStatus::NotApplied => "not-applied",
            NodeUpdateStatus::Stopped => "stopped",
            NodeUpdateStatus::Stopping => "stopping",
            NodeUpdateStatus::WaitingToStart => "waiting-to-start",
            NodeUpdateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "complete",
            "in-progress",
            "not-applied",
            "stopped",
            "stopping",
            "waiting-to-start",
        ]
    }
}
impl AsRef<str> for NodeUpdateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status of the service update on the node group </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeGroupUpdateStatus {
    /// <p>The ID of the node group</p>
    pub node_group_id: std::option::Option<std::string::String>,
    /// <p>The status of the service update on the node group member</p>
    pub node_group_member_update_status:
        std::option::Option<std::vec::Vec<crate::model::NodeGroupMemberUpdateStatus>>,
}
impl NodeGroupUpdateStatus {
    /// <p>The ID of the node group</p>
    pub fn node_group_id(&self) -> std::option::Option<&str> {
        self.node_group_id.as_deref()
    }
    /// <p>The status of the service update on the node group member</p>
    pub fn node_group_member_update_status(
        &self,
    ) -> std::option::Option<&[crate::model::NodeGroupMemberUpdateStatus]> {
        self.node_group_member_update_status.as_deref()
    }
}
impl std::fmt::Debug for NodeGroupUpdateStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeGroupUpdateStatus");
        formatter.field("node_group_id", &self.node_group_id);
        formatter.field(
            "node_group_member_update_status",
            &self.node_group_member_update_status,
        );
        formatter.finish()
    }
}
/// See [`NodeGroupUpdateStatus`](crate::model::NodeGroupUpdateStatus)
pub mod node_group_update_status {
    /// A builder for [`NodeGroupUpdateStatus`](crate::model::NodeGroupUpdateStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_group_id: std::option::Option<std::string::String>,
        pub(crate) node_group_member_update_status:
            std::option::Option<std::vec::Vec<crate::model::NodeGroupMemberUpdateStatus>>,
    }
    impl Builder {
        /// <p>The ID of the node group</p>
        pub fn node_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the node group</p>
        pub fn set_node_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.node_group_id = input;
            self
        }
        /// Appends an item to `node_group_member_update_status`.
        ///
        /// To override the contents of this collection use [`set_node_group_member_update_status`](Self::set_node_group_member_update_status).
        ///
        /// <p>The status of the service update on the node group member</p>
        pub fn node_group_member_update_status(
            mut self,
            input: impl Into<crate::model::NodeGroupMemberUpdateStatus>,
        ) -> Self {
            let mut v = self.node_group_member_update_status.unwrap_or_default();
            v.push(input.into());
            self.node_group_member_update_status = Some(v);
            self
        }
        /// <p>The status of the service update on the node group member</p>
        pub fn set_node_group_member_update_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeGroupMemberUpdateStatus>>,
        ) -> Self {
            self.node_group_member_update_status = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeGroupUpdateStatus`](crate::model::NodeGroupUpdateStatus)
        pub fn build(self) -> crate::model::NodeGroupUpdateStatus {
            crate::model::NodeGroupUpdateStatus {
                node_group_id: self.node_group_id,
                node_group_member_update_status: self.node_group_member_update_status,
            }
        }
    }
}
impl NodeGroupUpdateStatus {
    /// Creates a new builder-style object to manufacture [`NodeGroupUpdateStatus`](crate::model::NodeGroupUpdateStatus)
    pub fn builder() -> crate::model::node_group_update_status::Builder {
        crate::model::node_group_update_status::Builder::default()
    }
}

/// <p>The status of the service update on the node group member  </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeGroupMemberUpdateStatus {
    /// <p>The cache cluster ID</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>The node ID of the cache cluster</p>
    pub cache_node_id: std::option::Option<std::string::String>,
    /// <p>The update status of the node</p>
    pub node_update_status: std::option::Option<crate::model::NodeUpdateStatus>,
    /// <p>The deletion date of the node</p>
    pub node_deletion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The start date of the update for a node</p>
    pub node_update_start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end date of the update for a node</p>
    pub node_update_end_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Reflects whether the update was initiated by the customer or automatically applied</p>
    pub node_update_initiated_by: std::option::Option<crate::model::NodeUpdateInitiatedBy>,
    /// <p>The date when the update is triggered</p>
    pub node_update_initiated_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the NodeUpdateStatus was last modified</p>
    pub node_update_status_modified_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl NodeGroupMemberUpdateStatus {
    /// <p>The cache cluster ID</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>The node ID of the cache cluster</p>
    pub fn cache_node_id(&self) -> std::option::Option<&str> {
        self.cache_node_id.as_deref()
    }
    /// <p>The update status of the node</p>
    pub fn node_update_status(&self) -> std::option::Option<&crate::model::NodeUpdateStatus> {
        self.node_update_status.as_ref()
    }
    /// <p>The deletion date of the node</p>
    pub fn node_deletion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.node_deletion_date.as_ref()
    }
    /// <p>The start date of the update for a node</p>
    pub fn node_update_start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.node_update_start_date.as_ref()
    }
    /// <p>The end date of the update for a node</p>
    pub fn node_update_end_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.node_update_end_date.as_ref()
    }
    /// <p>Reflects whether the update was initiated by the customer or automatically applied</p>
    pub fn node_update_initiated_by(
        &self,
    ) -> std::option::Option<&crate::model::NodeUpdateInitiatedBy> {
        self.node_update_initiated_by.as_ref()
    }
    /// <p>The date when the update is triggered</p>
    pub fn node_update_initiated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.node_update_initiated_date.as_ref()
    }
    /// <p>The date when the NodeUpdateStatus was last modified</p>
    pub fn node_update_status_modified_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.node_update_status_modified_date.as_ref()
    }
}
impl std::fmt::Debug for NodeGroupMemberUpdateStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeGroupMemberUpdateStatus");
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("cache_node_id", &self.cache_node_id);
        formatter.field("node_update_status", &self.node_update_status);
        formatter.field("node_deletion_date", &self.node_deletion_date);
        formatter.field("node_update_start_date", &self.node_update_start_date);
        formatter.field("node_update_end_date", &self.node_update_end_date);
        formatter.field("node_update_initiated_by", &self.node_update_initiated_by);
        formatter.field(
            "node_update_initiated_date",
            &self.node_update_initiated_date,
        );
        formatter.field(
            "node_update_status_modified_date",
            &self.node_update_status_modified_date,
        );
        formatter.finish()
    }
}
/// See [`NodeGroupMemberUpdateStatus`](crate::model::NodeGroupMemberUpdateStatus)
pub mod node_group_member_update_status {
    /// A builder for [`NodeGroupMemberUpdateStatus`](crate::model::NodeGroupMemberUpdateStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) cache_node_id: std::option::Option<std::string::String>,
        pub(crate) node_update_status: std::option::Option<crate::model::NodeUpdateStatus>,
        pub(crate) node_deletion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) node_update_start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) node_update_end_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) node_update_initiated_by:
            std::option::Option<crate::model::NodeUpdateInitiatedBy>,
        pub(crate) node_update_initiated_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) node_update_status_modified_date:
            std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The cache cluster ID</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The cache cluster ID</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>The node ID of the cache cluster</p>
        pub fn cache_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_id = Some(input.into());
            self
        }
        /// <p>The node ID of the cache cluster</p>
        pub fn set_cache_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_id = input;
            self
        }
        /// <p>The update status of the node</p>
        pub fn node_update_status(mut self, input: crate::model::NodeUpdateStatus) -> Self {
            self.node_update_status = Some(input);
            self
        }
        /// <p>The update status of the node</p>
        pub fn set_node_update_status(
            mut self,
            input: std::option::Option<crate::model::NodeUpdateStatus>,
        ) -> Self {
            self.node_update_status = input;
            self
        }
        /// <p>The deletion date of the node</p>
        pub fn node_deletion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.node_deletion_date = Some(input);
            self
        }
        /// <p>The deletion date of the node</p>
        pub fn set_node_deletion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.node_deletion_date = input;
            self
        }
        /// <p>The start date of the update for a node</p>
        pub fn node_update_start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.node_update_start_date = Some(input);
            self
        }
        /// <p>The start date of the update for a node</p>
        pub fn set_node_update_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.node_update_start_date = input;
            self
        }
        /// <p>The end date of the update for a node</p>
        pub fn node_update_end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.node_update_end_date = Some(input);
            self
        }
        /// <p>The end date of the update for a node</p>
        pub fn set_node_update_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.node_update_end_date = input;
            self
        }
        /// <p>Reflects whether the update was initiated by the customer or automatically applied</p>
        pub fn node_update_initiated_by(
            mut self,
            input: crate::model::NodeUpdateInitiatedBy,
        ) -> Self {
            self.node_update_initiated_by = Some(input);
            self
        }
        /// <p>Reflects whether the update was initiated by the customer or automatically applied</p>
        pub fn set_node_update_initiated_by(
            mut self,
            input: std::option::Option<crate::model::NodeUpdateInitiatedBy>,
        ) -> Self {
            self.node_update_initiated_by = input;
            self
        }
        /// <p>The date when the update is triggered</p>
        pub fn node_update_initiated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.node_update_initiated_date = Some(input);
            self
        }
        /// <p>The date when the update is triggered</p>
        pub fn set_node_update_initiated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.node_update_initiated_date = input;
            self
        }
        /// <p>The date when the NodeUpdateStatus was last modified</p>
        pub fn node_update_status_modified_date(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.node_update_status_modified_date = Some(input);
            self
        }
        /// <p>The date when the NodeUpdateStatus was last modified</p>
        pub fn set_node_update_status_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.node_update_status_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeGroupMemberUpdateStatus`](crate::model::NodeGroupMemberUpdateStatus)
        pub fn build(self) -> crate::model::NodeGroupMemberUpdateStatus {
            crate::model::NodeGroupMemberUpdateStatus {
                cache_cluster_id: self.cache_cluster_id,
                cache_node_id: self.cache_node_id,
                node_update_status: self.node_update_status,
                node_deletion_date: self.node_deletion_date,
                node_update_start_date: self.node_update_start_date,
                node_update_end_date: self.node_update_end_date,
                node_update_initiated_by: self.node_update_initiated_by,
                node_update_initiated_date: self.node_update_initiated_date,
                node_update_status_modified_date: self.node_update_status_modified_date,
            }
        }
    }
}
impl NodeGroupMemberUpdateStatus {
    /// Creates a new builder-style object to manufacture [`NodeGroupMemberUpdateStatus`](crate::model::NodeGroupMemberUpdateStatus)
    pub fn builder() -> crate::model::node_group_member_update_status::Builder {
        crate::model::node_group_member_update_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SlaMet {
    #[allow(missing_docs)] // documentation missing in model
    Na,
    #[allow(missing_docs)] // documentation missing in model
    No,
    #[allow(missing_docs)] // documentation missing in model
    Yes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SlaMet {
    fn from(s: &str) -> Self {
        match s {
            "n/a" => SlaMet::Na,
            "no" => SlaMet::No,
            "yes" => SlaMet::Yes,
            other => SlaMet::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SlaMet {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SlaMet::from(s))
    }
}
impl SlaMet {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SlaMet::Na => "n/a",
            SlaMet::No => "no",
            SlaMet::Yes => "yes",
            SlaMet::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["n/a", "no", "yes"]
    }
}
impl AsRef<str> for SlaMet {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateActionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotApplicable,
    #[allow(missing_docs)] // documentation missing in model
    NotApplied,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    #[allow(missing_docs)] // documentation missing in model
    Scheduling,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    WaitingToStart,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateActionStatus {
    fn from(s: &str) -> Self {
        match s {
            "complete" => UpdateActionStatus::Complete,
            "in-progress" => UpdateActionStatus::InProgress,
            "not-applicable" => UpdateActionStatus::NotApplicable,
            "not-applied" => UpdateActionStatus::NotApplied,
            "scheduled" => UpdateActionStatus::Scheduled,
            "scheduling" => UpdateActionStatus::Scheduling,
            "stopped" => UpdateActionStatus::Stopped,
            "stopping" => UpdateActionStatus::Stopping,
            "waiting-to-start" => UpdateActionStatus::WaitingToStart,
            other => UpdateActionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateActionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateActionStatus::from(s))
    }
}
impl UpdateActionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateActionStatus::Complete => "complete",
            UpdateActionStatus::InProgress => "in-progress",
            UpdateActionStatus::NotApplicable => "not-applicable",
            UpdateActionStatus::NotApplied => "not-applied",
            UpdateActionStatus::Scheduled => "scheduled",
            UpdateActionStatus::Scheduling => "scheduling",
            UpdateActionStatus::Stopped => "stopped",
            UpdateActionStatus::Stopping => "stopping",
            UpdateActionStatus::WaitingToStart => "waiting-to-start",
            UpdateActionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "complete",
            "in-progress",
            "not-applicable",
            "not-applied",
            "scheduled",
            "scheduling",
            "stopped",
            "stopping",
            "waiting-to-start",
        ]
    }
}
impl AsRef<str> for UpdateActionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceUpdateType {
    #[allow(missing_docs)] // documentation missing in model
    SecurityUpdate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceUpdateType {
    fn from(s: &str) -> Self {
        match s {
            "security-update" => ServiceUpdateType::SecurityUpdate,
            other => ServiceUpdateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceUpdateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceUpdateType::from(s))
    }
}
impl ServiceUpdateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceUpdateType::SecurityUpdate => "security-update",
            ServiceUpdateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["security-update"]
    }
}
impl AsRef<str> for ServiceUpdateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceUpdateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceUpdateStatus {
    fn from(s: &str) -> Self {
        match s {
            "available" => ServiceUpdateStatus::Available,
            "cancelled" => ServiceUpdateStatus::Cancelled,
            "expired" => ServiceUpdateStatus::Expired,
            other => ServiceUpdateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceUpdateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceUpdateStatus::from(s))
    }
}
impl ServiceUpdateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceUpdateStatus::Available => "available",
            ServiceUpdateStatus::Cancelled => "cancelled",
            ServiceUpdateStatus::Expired => "expired",
            ServiceUpdateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["available", "cancelled", "expired"]
    }
}
impl AsRef<str> for ServiceUpdateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceUpdateSeverity {
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    Important,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceUpdateSeverity {
    fn from(s: &str) -> Self {
        match s {
            "critical" => ServiceUpdateSeverity::Critical,
            "important" => ServiceUpdateSeverity::Important,
            "low" => ServiceUpdateSeverity::Low,
            "medium" => ServiceUpdateSeverity::Medium,
            other => ServiceUpdateSeverity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceUpdateSeverity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceUpdateSeverity::from(s))
    }
}
impl ServiceUpdateSeverity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceUpdateSeverity::Critical => "critical",
            ServiceUpdateSeverity::Important => "important",
            ServiceUpdateSeverity::Low => "low",
            ServiceUpdateSeverity::Medium => "medium",
            ServiceUpdateSeverity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["critical", "important", "low", "medium"]
    }
}
impl AsRef<str> for ServiceUpdateSeverity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Filters update actions from the service updates that are in available status during the time range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeRangeFilter {
    /// <p>The start time of the time range filter</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end time of the time range filter</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl TimeRangeFilter {
    /// <p>The start time of the time range filter</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end time of the time range filter</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for TimeRangeFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeRangeFilter");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`TimeRangeFilter`](crate::model::TimeRangeFilter)
pub mod time_range_filter {
    /// A builder for [`TimeRangeFilter`](crate::model::TimeRangeFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The start time of the time range filter</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the time range filter</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the time range filter</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the time range filter</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeRangeFilter`](crate::model::TimeRangeFilter)
        pub fn build(self) -> crate::model::TimeRangeFilter {
            crate::model::TimeRangeFilter {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl TimeRangeFilter {
    /// Creates a new builder-style object to manufacture [`TimeRangeFilter`](crate::model::TimeRangeFilter)
    pub fn builder() -> crate::model::time_range_filter::Builder {
        crate::model::time_range_filter::Builder::default()
    }
}

/// <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Snapshot {
    /// <p>The name of a snapshot.
    /// For an automatic snapshot, the name is system-generated.  
    /// For a manual snapshot, this is the user-provided name.</p>
    pub snapshot_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the source replication group.</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>A description of the source replication group.</p>
    pub replication_group_description: std::option::Option<std::string::String>,
    /// <p>The user-supplied identifier of the source cluster.</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>The status of the snapshot. Valid values: <code>creating</code> | <code>available</code>
    /// | <code>restoring</code> | <code>copying</code> | <code>deleting</code>.</p>
    pub snapshot_status: std::option::Option<std::string::String>,
    /// <p>Indicates whether the snapshot is from an automatic backup (<code>automated</code>)
    /// or was created manually (<code>manual</code>).</p>
    pub snapshot_source: std::option::Option<std::string::String>,
    /// <p>The name of the compute and memory capacity node type for the source cluster.</p>
    ///
    /// <p>The following node types are supported by ElastiCache.
    /// Generally speaking, the current generation types provide more memory and computational power
    /// at lower cost when compared to their equivalent previous generation counterparts.</p>
    /// <ul>
    /// <li>
    /// <p>General purpose:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    /// <p>
    /// <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
    ///
    ///
    ///
    ///
    /// <p>  
    /// <code>cache.m6g.large</code>,
    /// <code>cache.m6g.xlarge</code>,
    /// <code>cache.m6g.2xlarge</code>,
    /// <code>cache.m6g.4xlarge</code>,
    /// <code>cache.m6g.8xlarge</code>,
    /// <code>cache.m6g.12xlarge</code>,
    /// <code>cache.m6g.16xlarge</code>
    ///
    /// </p>
    ///
    ///
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    ///
    ///
    /// <p>
    /// <b>M5 node types:</b>
    /// <code>cache.m5.large</code>,
    /// <code>cache.m5.xlarge</code>,
    /// <code>cache.m5.2xlarge</code>,
    /// <code>cache.m5.4xlarge</code>,
    /// <code>cache.m5.12xlarge</code>,
    /// <code>cache.m5.24xlarge</code>
    ///
    ///
    /// </p>  
    ///
    ///
    /// <p>
    /// <b>M4 node types:</b>
    /// <code>cache.m4.large</code>,
    /// <code>cache.m4.xlarge</code>,
    /// <code>cache.m4.2xlarge</code>,
    /// <code>cache.m4.4xlarge</code>,
    /// <code>cache.m4.10xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):</p>
    ///
    ///
    /// <p>
    /// <code>cache.t4g.micro</code>,
    /// <code>cache.t4g.small</code>,
    /// <code>cache.t4g.medium</code>
    /// </p>               
    ///
    ///
    ///
    /// <p>
    /// <b>T3 node types:</b>
    /// <code>cache.t3.micro</code>,
    /// <code>cache.t3.small</code>,
    /// <code>cache.t3.medium</code>
    /// </p>
    ///
    ///
    /// <p>
    /// <b>T2 node types:</b>
    /// <code>cache.t2.micro</code>,
    /// <code>cache.t2.small</code>,
    /// <code>cache.t2.medium</code>
    /// </p>
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>T1 node types:</b>
    /// <code>cache.t1.micro</code>
    /// </p>
    ///
    /// <p>
    /// <b>M1 node types:</b>
    /// <code>cache.m1.small</code>,
    /// <code>cache.m1.medium</code>,
    /// <code>cache.m1.large</code>,
    /// <code>cache.m1.xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>M3 node types:</b>
    /// <code>cache.m3.medium</code>,
    /// <code>cache.m3.large</code>,
    /// <code>cache.m3.xlarge</code>,
    /// <code>cache.m3.2xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Compute optimized:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>C1 node types:</b>
    /// <code>cache.c1.xlarge</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized with data tiering:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    /// <p>
    /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
    ///
    ///
    ///
    ///
    /// <p>  
    ///
    /// <code>cache.r6gd.xlarge</code>,
    /// <code>cache.r6gd.2xlarge</code>,
    /// <code>cache.r6gd.4xlarge</code>,
    /// <code>cache.r6gd.8xlarge</code>,
    /// <code>cache.r6gd.12xlarge</code>,
    /// <code>cache.r6gd.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>              
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized:</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    ///
    /// <p>
    /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
    ///
    ///
    ///
    /// <p>  
    /// <code>cache.r6g.large</code>,
    /// <code>cache.r6g.xlarge</code>,
    /// <code>cache.r6g.2xlarge</code>,
    /// <code>cache.r6g.4xlarge</code>,
    /// <code>cache.r6g.8xlarge</code>,
    /// <code>cache.r6g.12xlarge</code>,
    /// <code>cache.r6g.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>  
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    ///
    ///
    ///
    ///
    ///
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    /// <p>
    /// <b>R5 node types:</b>
    /// <code>cache.r5.large</code>,
    /// <code>cache.r5.xlarge</code>,
    /// <code>cache.r5.2xlarge</code>,
    /// <code>cache.r5.4xlarge</code>,
    /// <code>cache.r5.12xlarge</code>,
    /// <code>cache.r5.24xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R4 node types:</b>
    /// <code>cache.r4.large</code>,
    /// <code>cache.r4.xlarge</code>,
    /// <code>cache.r4.2xlarge</code>,
    /// <code>cache.r4.4xlarge</code>,
    /// <code>cache.r4.8xlarge</code>,
    /// <code>cache.r4.16xlarge</code>
    /// </p>
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>M2 node types:</b>            
    /// <code>cache.m2.xlarge</code>,
    /// <code>cache.m2.2xlarge</code>,
    /// <code>cache.m2.4xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R3 node types:</b>
    /// <code>cache.r3.large</code>,
    /// <code>cache.r3.xlarge</code>,
    /// <code>cache.r3.2xlarge</code>,  
    /// <code>cache.r3.4xlarge</code>,
    /// <code>cache.r3.8xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    ///
    /// <p>
    /// <b>Additional node type info</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>All current generation instance types are created in Amazon VPC by default.</p>
    /// </li>
    /// <li>
    /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis configuration variables <code>appendonly</code> and
    /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
    /// </li>
    /// </ul>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>The name of the cache engine (<code>memcached</code> or
    /// <code>redis</code>) used by the source cluster.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version of the cache engine version that is used by the source cluster.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The number of cache nodes in the source cluster.</p>
    /// <p>For clusters running Redis, this value must be 1.
    /// For clusters running Memcached, this value must be between 1 and 40.</p>
    pub num_cache_nodes: std::option::Option<i32>,
    /// <p>The name of the Availability Zone in which the source cluster is located.</p>
    pub preferred_availability_zone: std::option::Option<std::string::String>,
    /// <p>The ARN (Amazon Resource Name) of the preferred outpost.</p>
    pub preferred_outpost_arn: std::option::Option<std::string::String>,
    /// <p>The date and time when the source cluster was created.</p>
    pub cache_cluster_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the weekly time range during which maintenance
    /// on the cluster is performed. It is specified as a range in
    /// the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum
    /// maintenance window is a 60 minute period.</p>
    /// <p>Valid values for <code>ddd</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sun</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>mon</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tue</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>wed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>thu</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>fri</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sat</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>sun:23:00-mon:01:30</code>
    /// </p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the topic used by the source cluster for publishing notifications.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The port number used by each cache nodes in the source cluster.</p>
    pub port: std::option::Option<i32>,
    /// <p>The cache parameter group that is associated with the source cluster.</p>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the cache subnet group associated with the source cluster.</p>
    pub cache_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group for the source cluster.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p> If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
    /// </p>
    pub auto_minor_version_upgrade: bool,
    /// <p>For an automatic snapshot, the number of days for which ElastiCache retains the snapshot before deleting it.</p>
    /// <p>For manual snapshots, this field reflects the <code>SnapshotRetentionLimit</code> for the
    /// source cluster when the snapshot was created. This field is otherwise ignored:
    /// Manual snapshots do not expire, and can only be deleted using the <code>DeleteSnapshot</code>
    /// operation. </p>
    /// <p>
    /// <b>Important</b>
    /// If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
    pub snapshot_retention_limit: std::option::Option<i32>,
    /// <p>The daily time range during which ElastiCache takes daily snapshots of the source cluster.</p>
    pub snapshot_window: std::option::Option<std::string::String>,
    /// <p>The number of node groups (shards) in this snapshot.
    /// When restoring from a snapshot, the number of node groups (shards) in the snapshot and in the restored
    /// replication group must be the same.</p>
    pub num_node_groups: std::option::Option<i32>,
    /// <p>Indicates the status of automatic failover for the source Redis replication group.</p>
    pub automatic_failover: std::option::Option<crate::model::AutomaticFailoverStatus>,
    /// <p>A list of the cache nodes in the source cluster.</p>
    pub node_snapshots: std::option::Option<std::vec::Vec<crate::model::NodeSnapshot>>,
    /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The ARN (Amazon Resource Name) of the snapshot.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
    pub data_tiering: std::option::Option<crate::model::DataTieringStatus>,
}
impl Snapshot {
    /// <p>The name of a snapshot.
    /// For an automatic snapshot, the name is system-generated.  
    /// For a manual snapshot, this is the user-provided name.</p>
    pub fn snapshot_name(&self) -> std::option::Option<&str> {
        self.snapshot_name.as_deref()
    }
    /// <p>The unique identifier of the source replication group.</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>A description of the source replication group.</p>
    pub fn replication_group_description(&self) -> std::option::Option<&str> {
        self.replication_group_description.as_deref()
    }
    /// <p>The user-supplied identifier of the source cluster.</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>The status of the snapshot. Valid values: <code>creating</code> | <code>available</code>
    /// | <code>restoring</code> | <code>copying</code> | <code>deleting</code>.</p>
    pub fn snapshot_status(&self) -> std::option::Option<&str> {
        self.snapshot_status.as_deref()
    }
    /// <p>Indicates whether the snapshot is from an automatic backup (<code>automated</code>)
    /// or was created manually (<code>manual</code>).</p>
    pub fn snapshot_source(&self) -> std::option::Option<&str> {
        self.snapshot_source.as_deref()
    }
    /// <p>The name of the compute and memory capacity node type for the source cluster.</p>
    ///
    /// <p>The following node types are supported by ElastiCache.
    /// Generally speaking, the current generation types provide more memory and computational power
    /// at lower cost when compared to their equivalent previous generation counterparts.</p>
    /// <ul>
    /// <li>
    /// <p>General purpose:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    /// <p>
    /// <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
    ///
    ///
    ///
    ///
    /// <p>  
    /// <code>cache.m6g.large</code>,
    /// <code>cache.m6g.xlarge</code>,
    /// <code>cache.m6g.2xlarge</code>,
    /// <code>cache.m6g.4xlarge</code>,
    /// <code>cache.m6g.8xlarge</code>,
    /// <code>cache.m6g.12xlarge</code>,
    /// <code>cache.m6g.16xlarge</code>
    ///
    /// </p>
    ///
    ///
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    ///
    ///
    /// <p>
    /// <b>M5 node types:</b>
    /// <code>cache.m5.large</code>,
    /// <code>cache.m5.xlarge</code>,
    /// <code>cache.m5.2xlarge</code>,
    /// <code>cache.m5.4xlarge</code>,
    /// <code>cache.m5.12xlarge</code>,
    /// <code>cache.m5.24xlarge</code>
    ///
    ///
    /// </p>  
    ///
    ///
    /// <p>
    /// <b>M4 node types:</b>
    /// <code>cache.m4.large</code>,
    /// <code>cache.m4.xlarge</code>,
    /// <code>cache.m4.2xlarge</code>,
    /// <code>cache.m4.4xlarge</code>,
    /// <code>cache.m4.10xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):</p>
    ///
    ///
    /// <p>
    /// <code>cache.t4g.micro</code>,
    /// <code>cache.t4g.small</code>,
    /// <code>cache.t4g.medium</code>
    /// </p>               
    ///
    ///
    ///
    /// <p>
    /// <b>T3 node types:</b>
    /// <code>cache.t3.micro</code>,
    /// <code>cache.t3.small</code>,
    /// <code>cache.t3.medium</code>
    /// </p>
    ///
    ///
    /// <p>
    /// <b>T2 node types:</b>
    /// <code>cache.t2.micro</code>,
    /// <code>cache.t2.small</code>,
    /// <code>cache.t2.medium</code>
    /// </p>
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>T1 node types:</b>
    /// <code>cache.t1.micro</code>
    /// </p>
    ///
    /// <p>
    /// <b>M1 node types:</b>
    /// <code>cache.m1.small</code>,
    /// <code>cache.m1.medium</code>,
    /// <code>cache.m1.large</code>,
    /// <code>cache.m1.xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>M3 node types:</b>
    /// <code>cache.m3.medium</code>,
    /// <code>cache.m3.large</code>,
    /// <code>cache.m3.xlarge</code>,
    /// <code>cache.m3.2xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Compute optimized:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>C1 node types:</b>
    /// <code>cache.c1.xlarge</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized with data tiering:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    /// <p>
    /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
    ///
    ///
    ///
    ///
    /// <p>  
    ///
    /// <code>cache.r6gd.xlarge</code>,
    /// <code>cache.r6gd.2xlarge</code>,
    /// <code>cache.r6gd.4xlarge</code>,
    /// <code>cache.r6gd.8xlarge</code>,
    /// <code>cache.r6gd.12xlarge</code>,
    /// <code>cache.r6gd.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>              
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized:</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    ///
    /// <p>
    /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
    ///
    ///
    ///
    /// <p>  
    /// <code>cache.r6g.large</code>,
    /// <code>cache.r6g.xlarge</code>,
    /// <code>cache.r6g.2xlarge</code>,
    /// <code>cache.r6g.4xlarge</code>,
    /// <code>cache.r6g.8xlarge</code>,
    /// <code>cache.r6g.12xlarge</code>,
    /// <code>cache.r6g.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>  
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    ///
    ///
    ///
    ///
    ///
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    /// <p>
    /// <b>R5 node types:</b>
    /// <code>cache.r5.large</code>,
    /// <code>cache.r5.xlarge</code>,
    /// <code>cache.r5.2xlarge</code>,
    /// <code>cache.r5.4xlarge</code>,
    /// <code>cache.r5.12xlarge</code>,
    /// <code>cache.r5.24xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R4 node types:</b>
    /// <code>cache.r4.large</code>,
    /// <code>cache.r4.xlarge</code>,
    /// <code>cache.r4.2xlarge</code>,
    /// <code>cache.r4.4xlarge</code>,
    /// <code>cache.r4.8xlarge</code>,
    /// <code>cache.r4.16xlarge</code>
    /// </p>
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>M2 node types:</b>            
    /// <code>cache.m2.xlarge</code>,
    /// <code>cache.m2.2xlarge</code>,
    /// <code>cache.m2.4xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R3 node types:</b>
    /// <code>cache.r3.large</code>,
    /// <code>cache.r3.xlarge</code>,
    /// <code>cache.r3.2xlarge</code>,  
    /// <code>cache.r3.4xlarge</code>,
    /// <code>cache.r3.8xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    ///
    /// <p>
    /// <b>Additional node type info</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>All current generation instance types are created in Amazon VPC by default.</p>
    /// </li>
    /// <li>
    /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis configuration variables <code>appendonly</code> and
    /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
    /// </li>
    /// </ul>
    pub fn cache_node_type(&self) -> std::option::Option<&str> {
        self.cache_node_type.as_deref()
    }
    /// <p>The name of the cache engine (<code>memcached</code> or
    /// <code>redis</code>) used by the source cluster.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The version of the cache engine version that is used by the source cluster.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The number of cache nodes in the source cluster.</p>
    /// <p>For clusters running Redis, this value must be 1.
    /// For clusters running Memcached, this value must be between 1 and 40.</p>
    pub fn num_cache_nodes(&self) -> std::option::Option<i32> {
        self.num_cache_nodes
    }
    /// <p>The name of the Availability Zone in which the source cluster is located.</p>
    pub fn preferred_availability_zone(&self) -> std::option::Option<&str> {
        self.preferred_availability_zone.as_deref()
    }
    /// <p>The ARN (Amazon Resource Name) of the preferred outpost.</p>
    pub fn preferred_outpost_arn(&self) -> std::option::Option<&str> {
        self.preferred_outpost_arn.as_deref()
    }
    /// <p>The date and time when the source cluster was created.</p>
    pub fn cache_cluster_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.cache_cluster_create_time.as_ref()
    }
    /// <p>Specifies the weekly time range during which maintenance
    /// on the cluster is performed. It is specified as a range in
    /// the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum
    /// maintenance window is a 60 minute period.</p>
    /// <p>Valid values for <code>ddd</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sun</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>mon</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tue</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>wed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>thu</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>fri</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sat</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>sun:23:00-mon:01:30</code>
    /// </p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the topic used by the source cluster for publishing notifications.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>The port number used by each cache nodes in the source cluster.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The cache parameter group that is associated with the source cluster.</p>
    pub fn cache_parameter_group_name(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_name.as_deref()
    }
    /// <p>The name of the cache subnet group associated with the source cluster.</p>
    pub fn cache_subnet_group_name(&self) -> std::option::Option<&str> {
        self.cache_subnet_group_name.as_deref()
    }
    /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group for the source cluster.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p> If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
    /// </p>
    pub fn auto_minor_version_upgrade(&self) -> bool {
        self.auto_minor_version_upgrade
    }
    /// <p>For an automatic snapshot, the number of days for which ElastiCache retains the snapshot before deleting it.</p>
    /// <p>For manual snapshots, this field reflects the <code>SnapshotRetentionLimit</code> for the
    /// source cluster when the snapshot was created. This field is otherwise ignored:
    /// Manual snapshots do not expire, and can only be deleted using the <code>DeleteSnapshot</code>
    /// operation. </p>
    /// <p>
    /// <b>Important</b>
    /// If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
    pub fn snapshot_retention_limit(&self) -> std::option::Option<i32> {
        self.snapshot_retention_limit
    }
    /// <p>The daily time range during which ElastiCache takes daily snapshots of the source cluster.</p>
    pub fn snapshot_window(&self) -> std::option::Option<&str> {
        self.snapshot_window.as_deref()
    }
    /// <p>The number of node groups (shards) in this snapshot.
    /// When restoring from a snapshot, the number of node groups (shards) in the snapshot and in the restored
    /// replication group must be the same.</p>
    pub fn num_node_groups(&self) -> std::option::Option<i32> {
        self.num_node_groups
    }
    /// <p>Indicates the status of automatic failover for the source Redis replication group.</p>
    pub fn automatic_failover(
        &self,
    ) -> std::option::Option<&crate::model::AutomaticFailoverStatus> {
        self.automatic_failover.as_ref()
    }
    /// <p>A list of the cache nodes in the source cluster.</p>
    pub fn node_snapshots(&self) -> std::option::Option<&[crate::model::NodeSnapshot]> {
        self.node_snapshots.as_deref()
    }
    /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The ARN (Amazon Resource Name) of the snapshot.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
    pub fn data_tiering(&self) -> std::option::Option<&crate::model::DataTieringStatus> {
        self.data_tiering.as_ref()
    }
}
impl std::fmt::Debug for Snapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Snapshot");
        formatter.field("snapshot_name", &self.snapshot_name);
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field(
            "replication_group_description",
            &self.replication_group_description,
        );
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("snapshot_status", &self.snapshot_status);
        formatter.field("snapshot_source", &self.snapshot_source);
        formatter.field("cache_node_type", &self.cache_node_type);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("num_cache_nodes", &self.num_cache_nodes);
        formatter.field(
            "preferred_availability_zone",
            &self.preferred_availability_zone,
        );
        formatter.field("preferred_outpost_arn", &self.preferred_outpost_arn);
        formatter.field("cache_cluster_create_time", &self.cache_cluster_create_time);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("port", &self.port);
        formatter.field(
            "cache_parameter_group_name",
            &self.cache_parameter_group_name,
        );
        formatter.field("cache_subnet_group_name", &self.cache_subnet_group_name);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("snapshot_retention_limit", &self.snapshot_retention_limit);
        formatter.field("snapshot_window", &self.snapshot_window);
        formatter.field("num_node_groups", &self.num_node_groups);
        formatter.field("automatic_failover", &self.automatic_failover);
        formatter.field("node_snapshots", &self.node_snapshots);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("arn", &self.arn);
        formatter.field("data_tiering", &self.data_tiering);
        formatter.finish()
    }
}
/// See [`Snapshot`](crate::model::Snapshot)
pub mod snapshot {
    /// A builder for [`Snapshot`](crate::model::Snapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_name: std::option::Option<std::string::String>,
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) replication_group_description: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_status: std::option::Option<std::string::String>,
        pub(crate) snapshot_source: std::option::Option<std::string::String>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) num_cache_nodes: std::option::Option<i32>,
        pub(crate) preferred_availability_zone: std::option::Option<std::string::String>,
        pub(crate) preferred_outpost_arn: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) cache_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) snapshot_retention_limit: std::option::Option<i32>,
        pub(crate) snapshot_window: std::option::Option<std::string::String>,
        pub(crate) num_node_groups: std::option::Option<i32>,
        pub(crate) automatic_failover: std::option::Option<crate::model::AutomaticFailoverStatus>,
        pub(crate) node_snapshots: std::option::Option<std::vec::Vec<crate::model::NodeSnapshot>>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) data_tiering: std::option::Option<crate::model::DataTieringStatus>,
    }
    impl Builder {
        /// <p>The name of a snapshot.
        /// For an automatic snapshot, the name is system-generated.  
        /// For a manual snapshot, this is the user-provided name.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of a snapshot.
        /// For an automatic snapshot, the name is system-generated.  
        /// For a manual snapshot, this is the user-provided name.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_name = input;
            self
        }
        /// <p>The unique identifier of the source replication group.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the source replication group.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>A description of the source replication group.</p>
        pub fn replication_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_group_description = Some(input.into());
            self
        }
        /// <p>A description of the source replication group.</p>
        pub fn set_replication_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_description = input;
            self
        }
        /// <p>The user-supplied identifier of the source cluster.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The user-supplied identifier of the source cluster.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>The status of the snapshot. Valid values: <code>creating</code> | <code>available</code>
        /// | <code>restoring</code> | <code>copying</code> | <code>deleting</code>.</p>
        pub fn snapshot_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_status = Some(input.into());
            self
        }
        /// <p>The status of the snapshot. Valid values: <code>creating</code> | <code>available</code>
        /// | <code>restoring</code> | <code>copying</code> | <code>deleting</code>.</p>
        pub fn set_snapshot_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_status = input;
            self
        }
        /// <p>Indicates whether the snapshot is from an automatic backup (<code>automated</code>)
        /// or was created manually (<code>manual</code>).</p>
        pub fn snapshot_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_source = Some(input.into());
            self
        }
        /// <p>Indicates whether the snapshot is from an automatic backup (<code>automated</code>)
        /// or was created manually (<code>manual</code>).</p>
        pub fn set_snapshot_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_source = input;
            self
        }
        /// <p>The name of the compute and memory capacity node type for the source cluster.</p>
        ///
        /// <p>The following node types are supported by ElastiCache.
        /// Generally speaking, the current generation types provide more memory and computational power
        /// at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li>
        /// <p>General purpose:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        /// <p>
        /// <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
        ///
        ///
        ///
        ///
        /// <p>  
        /// <code>cache.m6g.large</code>,
        /// <code>cache.m6g.xlarge</code>,
        /// <code>cache.m6g.2xlarge</code>,
        /// <code>cache.m6g.4xlarge</code>,
        /// <code>cache.m6g.8xlarge</code>,
        /// <code>cache.m6g.12xlarge</code>,
        /// <code>cache.m6g.16xlarge</code>
        ///
        /// </p>
        ///
        ///
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        ///
        ///
        /// <p>
        /// <b>M5 node types:</b>
        /// <code>cache.m5.large</code>,
        /// <code>cache.m5.xlarge</code>,
        /// <code>cache.m5.2xlarge</code>,
        /// <code>cache.m5.4xlarge</code>,
        /// <code>cache.m5.12xlarge</code>,
        /// <code>cache.m5.24xlarge</code>
        ///
        ///
        /// </p>  
        ///
        ///
        /// <p>
        /// <b>M4 node types:</b>
        /// <code>cache.m4.large</code>,
        /// <code>cache.m4.xlarge</code>,
        /// <code>cache.m4.2xlarge</code>,
        /// <code>cache.m4.4xlarge</code>,
        /// <code>cache.m4.10xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):</p>
        ///
        ///
        /// <p>
        /// <code>cache.t4g.micro</code>,
        /// <code>cache.t4g.small</code>,
        /// <code>cache.t4g.medium</code>
        /// </p>               
        ///
        ///
        ///
        /// <p>
        /// <b>T3 node types:</b>
        /// <code>cache.t3.micro</code>,
        /// <code>cache.t3.small</code>,
        /// <code>cache.t3.medium</code>
        /// </p>
        ///
        ///
        /// <p>
        /// <b>T2 node types:</b>
        /// <code>cache.t2.micro</code>,
        /// <code>cache.t2.small</code>,
        /// <code>cache.t2.medium</code>
        /// </p>
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>T1 node types:</b>
        /// <code>cache.t1.micro</code>
        /// </p>
        ///
        /// <p>
        /// <b>M1 node types:</b>
        /// <code>cache.m1.small</code>,
        /// <code>cache.m1.medium</code>,
        /// <code>cache.m1.large</code>,
        /// <code>cache.m1.xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>M3 node types:</b>
        /// <code>cache.m3.medium</code>,
        /// <code>cache.m3.large</code>,
        /// <code>cache.m3.xlarge</code>,
        /// <code>cache.m3.2xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Compute optimized:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>C1 node types:</b>
        /// <code>cache.c1.xlarge</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        /// <p>
        /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
        ///
        ///
        ///
        ///
        /// <p>  
        ///
        /// <code>cache.r6gd.xlarge</code>,
        /// <code>cache.r6gd.2xlarge</code>,
        /// <code>cache.r6gd.4xlarge</code>,
        /// <code>cache.r6gd.8xlarge</code>,
        /// <code>cache.r6gd.12xlarge</code>,
        /// <code>cache.r6gd.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>              
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized:</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        ///
        /// <p>
        /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
        ///
        ///
        ///
        /// <p>  
        /// <code>cache.r6g.large</code>,
        /// <code>cache.r6g.xlarge</code>,
        /// <code>cache.r6g.2xlarge</code>,
        /// <code>cache.r6g.4xlarge</code>,
        /// <code>cache.r6g.8xlarge</code>,
        /// <code>cache.r6g.12xlarge</code>,
        /// <code>cache.r6g.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>  
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        ///
        ///
        ///
        ///
        ///
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        /// <p>
        /// <b>R5 node types:</b>
        /// <code>cache.r5.large</code>,
        /// <code>cache.r5.xlarge</code>,
        /// <code>cache.r5.2xlarge</code>,
        /// <code>cache.r5.4xlarge</code>,
        /// <code>cache.r5.12xlarge</code>,
        /// <code>cache.r5.24xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R4 node types:</b>
        /// <code>cache.r4.large</code>,
        /// <code>cache.r4.xlarge</code>,
        /// <code>cache.r4.2xlarge</code>,
        /// <code>cache.r4.4xlarge</code>,
        /// <code>cache.r4.8xlarge</code>,
        /// <code>cache.r4.16xlarge</code>
        /// </p>
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>M2 node types:</b>            
        /// <code>cache.m2.xlarge</code>,
        /// <code>cache.m2.2xlarge</code>,
        /// <code>cache.m2.4xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R3 node types:</b>
        /// <code>cache.r3.large</code>,
        /// <code>cache.r3.xlarge</code>,
        /// <code>cache.r3.2xlarge</code>,  
        /// <code>cache.r3.4xlarge</code>,
        /// <code>cache.r3.8xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Additional node type info</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>All current generation instance types are created in Amazon VPC by default.</p>
        /// </li>
        /// <li>
        /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis configuration variables <code>appendonly</code> and
        /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
        /// </li>
        /// </ul>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>The name of the compute and memory capacity node type for the source cluster.</p>
        ///
        /// <p>The following node types are supported by ElastiCache.
        /// Generally speaking, the current generation types provide more memory and computational power
        /// at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li>
        /// <p>General purpose:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        /// <p>
        /// <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
        ///
        ///
        ///
        ///
        /// <p>  
        /// <code>cache.m6g.large</code>,
        /// <code>cache.m6g.xlarge</code>,
        /// <code>cache.m6g.2xlarge</code>,
        /// <code>cache.m6g.4xlarge</code>,
        /// <code>cache.m6g.8xlarge</code>,
        /// <code>cache.m6g.12xlarge</code>,
        /// <code>cache.m6g.16xlarge</code>
        ///
        /// </p>
        ///
        ///
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        ///
        ///
        /// <p>
        /// <b>M5 node types:</b>
        /// <code>cache.m5.large</code>,
        /// <code>cache.m5.xlarge</code>,
        /// <code>cache.m5.2xlarge</code>,
        /// <code>cache.m5.4xlarge</code>,
        /// <code>cache.m5.12xlarge</code>,
        /// <code>cache.m5.24xlarge</code>
        ///
        ///
        /// </p>  
        ///
        ///
        /// <p>
        /// <b>M4 node types:</b>
        /// <code>cache.m4.large</code>,
        /// <code>cache.m4.xlarge</code>,
        /// <code>cache.m4.2xlarge</code>,
        /// <code>cache.m4.4xlarge</code>,
        /// <code>cache.m4.10xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):</p>
        ///
        ///
        /// <p>
        /// <code>cache.t4g.micro</code>,
        /// <code>cache.t4g.small</code>,
        /// <code>cache.t4g.medium</code>
        /// </p>               
        ///
        ///
        ///
        /// <p>
        /// <b>T3 node types:</b>
        /// <code>cache.t3.micro</code>,
        /// <code>cache.t3.small</code>,
        /// <code>cache.t3.medium</code>
        /// </p>
        ///
        ///
        /// <p>
        /// <b>T2 node types:</b>
        /// <code>cache.t2.micro</code>,
        /// <code>cache.t2.small</code>,
        /// <code>cache.t2.medium</code>
        /// </p>
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>T1 node types:</b>
        /// <code>cache.t1.micro</code>
        /// </p>
        ///
        /// <p>
        /// <b>M1 node types:</b>
        /// <code>cache.m1.small</code>,
        /// <code>cache.m1.medium</code>,
        /// <code>cache.m1.large</code>,
        /// <code>cache.m1.xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>M3 node types:</b>
        /// <code>cache.m3.medium</code>,
        /// <code>cache.m3.large</code>,
        /// <code>cache.m3.xlarge</code>,
        /// <code>cache.m3.2xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Compute optimized:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>C1 node types:</b>
        /// <code>cache.c1.xlarge</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        /// <p>
        /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
        ///
        ///
        ///
        ///
        /// <p>  
        ///
        /// <code>cache.r6gd.xlarge</code>,
        /// <code>cache.r6gd.2xlarge</code>,
        /// <code>cache.r6gd.4xlarge</code>,
        /// <code>cache.r6gd.8xlarge</code>,
        /// <code>cache.r6gd.12xlarge</code>,
        /// <code>cache.r6gd.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>              
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized:</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        ///
        /// <p>
        /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
        ///
        ///
        ///
        /// <p>  
        /// <code>cache.r6g.large</code>,
        /// <code>cache.r6g.xlarge</code>,
        /// <code>cache.r6g.2xlarge</code>,
        /// <code>cache.r6g.4xlarge</code>,
        /// <code>cache.r6g.8xlarge</code>,
        /// <code>cache.r6g.12xlarge</code>,
        /// <code>cache.r6g.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>  
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        ///
        ///
        ///
        ///
        ///
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        /// <p>
        /// <b>R5 node types:</b>
        /// <code>cache.r5.large</code>,
        /// <code>cache.r5.xlarge</code>,
        /// <code>cache.r5.2xlarge</code>,
        /// <code>cache.r5.4xlarge</code>,
        /// <code>cache.r5.12xlarge</code>,
        /// <code>cache.r5.24xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R4 node types:</b>
        /// <code>cache.r4.large</code>,
        /// <code>cache.r4.xlarge</code>,
        /// <code>cache.r4.2xlarge</code>,
        /// <code>cache.r4.4xlarge</code>,
        /// <code>cache.r4.8xlarge</code>,
        /// <code>cache.r4.16xlarge</code>
        /// </p>
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>M2 node types:</b>            
        /// <code>cache.m2.xlarge</code>,
        /// <code>cache.m2.2xlarge</code>,
        /// <code>cache.m2.4xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R3 node types:</b>
        /// <code>cache.r3.large</code>,
        /// <code>cache.r3.xlarge</code>,
        /// <code>cache.r3.2xlarge</code>,  
        /// <code>cache.r3.4xlarge</code>,
        /// <code>cache.r3.8xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Additional node type info</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>All current generation instance types are created in Amazon VPC by default.</p>
        /// </li>
        /// <li>
        /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis configuration variables <code>appendonly</code> and
        /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
        /// </li>
        /// </ul>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>The name of the cache engine (<code>memcached</code> or
        /// <code>redis</code>) used by the source cluster.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the cache engine (<code>memcached</code> or
        /// <code>redis</code>) used by the source cluster.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version of the cache engine version that is used by the source cluster.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version of the cache engine version that is used by the source cluster.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The number of cache nodes in the source cluster.</p>
        /// <p>For clusters running Redis, this value must be 1.
        /// For clusters running Memcached, this value must be between 1 and 40.</p>
        pub fn num_cache_nodes(mut self, input: i32) -> Self {
            self.num_cache_nodes = Some(input);
            self
        }
        /// <p>The number of cache nodes in the source cluster.</p>
        /// <p>For clusters running Redis, this value must be 1.
        /// For clusters running Memcached, this value must be between 1 and 40.</p>
        pub fn set_num_cache_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.num_cache_nodes = input;
            self
        }
        /// <p>The name of the Availability Zone in which the source cluster is located.</p>
        pub fn preferred_availability_zone(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_availability_zone = Some(input.into());
            self
        }
        /// <p>The name of the Availability Zone in which the source cluster is located.</p>
        pub fn set_preferred_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_availability_zone = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the preferred outpost.</p>
        pub fn preferred_outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_outpost_arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the preferred outpost.</p>
        pub fn set_preferred_outpost_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_outpost_arn = input;
            self
        }
        /// <p>The date and time when the source cluster was created.</p>
        pub fn cache_cluster_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.cache_cluster_create_time = Some(input);
            self
        }
        /// <p>The date and time when the source cluster was created.</p>
        pub fn set_cache_cluster_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.cache_cluster_create_time = input;
            self
        }
        /// <p>Specifies the weekly time range during which maintenance
        /// on the cluster is performed. It is specified as a range in
        /// the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum
        /// maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sun</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tue</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>wed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>thu</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>fri</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sat</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code>
        /// </p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance
        /// on the cluster is performed. It is specified as a range in
        /// the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum
        /// maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sun</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tue</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>wed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>thu</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>fri</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sat</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code>
        /// </p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the topic used by the source cluster for publishing notifications.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the topic used by the source cluster for publishing notifications.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>The port number used by each cache nodes in the source cluster.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number used by each cache nodes in the source cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The cache parameter group that is associated with the source cluster.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The cache parameter group that is associated with the source cluster.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// <p>The name of the cache subnet group associated with the source cluster.</p>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache subnet group associated with the source cluster.</p>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_subnet_group_name = input;
            self
        }
        /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group for the source cluster.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group for the source cluster.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p> If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
        /// </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p> If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
        /// </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>For an automatic snapshot, the number of days for which ElastiCache retains the snapshot before deleting it.</p>
        /// <p>For manual snapshots, this field reflects the <code>SnapshotRetentionLimit</code> for the
        /// source cluster when the snapshot was created. This field is otherwise ignored:
        /// Manual snapshots do not expire, and can only be deleted using the <code>DeleteSnapshot</code>
        /// operation. </p>
        /// <p>
        /// <b>Important</b>
        /// If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.snapshot_retention_limit = Some(input);
            self
        }
        /// <p>For an automatic snapshot, the number of days for which ElastiCache retains the snapshot before deleting it.</p>
        /// <p>For manual snapshots, this field reflects the <code>SnapshotRetentionLimit</code> for the
        /// source cluster when the snapshot was created. This field is otherwise ignored:
        /// Manual snapshots do not expire, and can only be deleted using the <code>DeleteSnapshot</code>
        /// operation. </p>
        /// <p>
        /// <b>Important</b>
        /// If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.snapshot_retention_limit = input;
            self
        }
        /// <p>The daily time range during which ElastiCache takes daily snapshots of the source cluster.</p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_window = Some(input.into());
            self
        }
        /// <p>The daily time range during which ElastiCache takes daily snapshots of the source cluster.</p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_window = input;
            self
        }
        /// <p>The number of node groups (shards) in this snapshot.
        /// When restoring from a snapshot, the number of node groups (shards) in the snapshot and in the restored
        /// replication group must be the same.</p>
        pub fn num_node_groups(mut self, input: i32) -> Self {
            self.num_node_groups = Some(input);
            self
        }
        /// <p>The number of node groups (shards) in this snapshot.
        /// When restoring from a snapshot, the number of node groups (shards) in the snapshot and in the restored
        /// replication group must be the same.</p>
        pub fn set_num_node_groups(mut self, input: std::option::Option<i32>) -> Self {
            self.num_node_groups = input;
            self
        }
        /// <p>Indicates the status of automatic failover for the source Redis replication group.</p>
        pub fn automatic_failover(mut self, input: crate::model::AutomaticFailoverStatus) -> Self {
            self.automatic_failover = Some(input);
            self
        }
        /// <p>Indicates the status of automatic failover for the source Redis replication group.</p>
        pub fn set_automatic_failover(
            mut self,
            input: std::option::Option<crate::model::AutomaticFailoverStatus>,
        ) -> Self {
            self.automatic_failover = input;
            self
        }
        /// Appends an item to `node_snapshots`.
        ///
        /// To override the contents of this collection use [`set_node_snapshots`](Self::set_node_snapshots).
        ///
        /// <p>A list of the cache nodes in the source cluster.</p>
        pub fn node_snapshots(mut self, input: impl Into<crate::model::NodeSnapshot>) -> Self {
            let mut v = self.node_snapshots.unwrap_or_default();
            v.push(input.into());
            self.node_snapshots = Some(v);
            self
        }
        /// <p>A list of the cache nodes in the source cluster.</p>
        pub fn set_node_snapshots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeSnapshot>>,
        ) -> Self {
            self.node_snapshots = input;
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the snapshot.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the snapshot.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
        pub fn data_tiering(mut self, input: crate::model::DataTieringStatus) -> Self {
            self.data_tiering = Some(input);
            self
        }
        /// <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
        pub fn set_data_tiering(
            mut self,
            input: std::option::Option<crate::model::DataTieringStatus>,
        ) -> Self {
            self.data_tiering = input;
            self
        }
        /// Consumes the builder and constructs a [`Snapshot`](crate::model::Snapshot)
        pub fn build(self) -> crate::model::Snapshot {
            crate::model::Snapshot {
                snapshot_name: self.snapshot_name,
                replication_group_id: self.replication_group_id,
                replication_group_description: self.replication_group_description,
                cache_cluster_id: self.cache_cluster_id,
                snapshot_status: self.snapshot_status,
                snapshot_source: self.snapshot_source,
                cache_node_type: self.cache_node_type,
                engine: self.engine,
                engine_version: self.engine_version,
                num_cache_nodes: self.num_cache_nodes,
                preferred_availability_zone: self.preferred_availability_zone,
                preferred_outpost_arn: self.preferred_outpost_arn,
                cache_cluster_create_time: self.cache_cluster_create_time,
                preferred_maintenance_window: self.preferred_maintenance_window,
                topic_arn: self.topic_arn,
                port: self.port,
                cache_parameter_group_name: self.cache_parameter_group_name,
                cache_subnet_group_name: self.cache_subnet_group_name,
                vpc_id: self.vpc_id,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade.unwrap_or_default(),
                snapshot_retention_limit: self.snapshot_retention_limit,
                snapshot_window: self.snapshot_window,
                num_node_groups: self.num_node_groups,
                automatic_failover: self.automatic_failover,
                node_snapshots: self.node_snapshots,
                kms_key_id: self.kms_key_id,
                arn: self.arn,
                data_tiering: self.data_tiering,
            }
        }
    }
}
impl Snapshot {
    /// Creates a new builder-style object to manufacture [`Snapshot`](crate::model::Snapshot)
    pub fn builder() -> crate::model::snapshot::Builder {
        crate::model::snapshot::Builder::default()
    }
}

/// <p>Represents an individual cache node in a snapshot of a cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeSnapshot {
    /// <p>A unique identifier for the source cluster.</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the source node group (shard).</p>
    pub node_group_id: std::option::Option<std::string::String>,
    /// <p>The cache node identifier for the node in the source cluster.</p>
    pub cache_node_id: std::option::Option<std::string::String>,
    /// <p>The configuration for the source node group (shard).</p>
    pub node_group_configuration: std::option::Option<crate::model::NodeGroupConfiguration>,
    /// <p>The size of the cache on the source cache node.</p>
    pub cache_size: std::option::Option<std::string::String>,
    /// <p>The date and time when the cache node was created in the source cluster.</p>
    pub cache_node_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the source node's metadata and cache data set was obtained for the snapshot.</p>
    pub snapshot_create_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl NodeSnapshot {
    /// <p>A unique identifier for the source cluster.</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>A unique identifier for the source node group (shard).</p>
    pub fn node_group_id(&self) -> std::option::Option<&str> {
        self.node_group_id.as_deref()
    }
    /// <p>The cache node identifier for the node in the source cluster.</p>
    pub fn cache_node_id(&self) -> std::option::Option<&str> {
        self.cache_node_id.as_deref()
    }
    /// <p>The configuration for the source node group (shard).</p>
    pub fn node_group_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NodeGroupConfiguration> {
        self.node_group_configuration.as_ref()
    }
    /// <p>The size of the cache on the source cache node.</p>
    pub fn cache_size(&self) -> std::option::Option<&str> {
        self.cache_size.as_deref()
    }
    /// <p>The date and time when the cache node was created in the source cluster.</p>
    pub fn cache_node_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.cache_node_create_time.as_ref()
    }
    /// <p>The date and time when the source node's metadata and cache data set was obtained for the snapshot.</p>
    pub fn snapshot_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.snapshot_create_time.as_ref()
    }
}
impl std::fmt::Debug for NodeSnapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeSnapshot");
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("node_group_id", &self.node_group_id);
        formatter.field("cache_node_id", &self.cache_node_id);
        formatter.field("node_group_configuration", &self.node_group_configuration);
        formatter.field("cache_size", &self.cache_size);
        formatter.field("cache_node_create_time", &self.cache_node_create_time);
        formatter.field("snapshot_create_time", &self.snapshot_create_time);
        formatter.finish()
    }
}
/// See [`NodeSnapshot`](crate::model::NodeSnapshot)
pub mod node_snapshot {
    /// A builder for [`NodeSnapshot`](crate::model::NodeSnapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) node_group_id: std::option::Option<std::string::String>,
        pub(crate) cache_node_id: std::option::Option<std::string::String>,
        pub(crate) node_group_configuration:
            std::option::Option<crate::model::NodeGroupConfiguration>,
        pub(crate) cache_size: std::option::Option<std::string::String>,
        pub(crate) cache_node_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) snapshot_create_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A unique identifier for the source cluster.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the source cluster.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>A unique identifier for the source node group (shard).</p>
        pub fn node_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_group_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the source node group (shard).</p>
        pub fn set_node_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.node_group_id = input;
            self
        }
        /// <p>The cache node identifier for the node in the source cluster.</p>
        pub fn cache_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_id = Some(input.into());
            self
        }
        /// <p>The cache node identifier for the node in the source cluster.</p>
        pub fn set_cache_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_id = input;
            self
        }
        /// <p>The configuration for the source node group (shard).</p>
        pub fn node_group_configuration(
            mut self,
            input: crate::model::NodeGroupConfiguration,
        ) -> Self {
            self.node_group_configuration = Some(input);
            self
        }
        /// <p>The configuration for the source node group (shard).</p>
        pub fn set_node_group_configuration(
            mut self,
            input: std::option::Option<crate::model::NodeGroupConfiguration>,
        ) -> Self {
            self.node_group_configuration = input;
            self
        }
        /// <p>The size of the cache on the source cache node.</p>
        pub fn cache_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_size = Some(input.into());
            self
        }
        /// <p>The size of the cache on the source cache node.</p>
        pub fn set_cache_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cache_size = input;
            self
        }
        /// <p>The date and time when the cache node was created in the source cluster.</p>
        pub fn cache_node_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.cache_node_create_time = Some(input);
            self
        }
        /// <p>The date and time when the cache node was created in the source cluster.</p>
        pub fn set_cache_node_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.cache_node_create_time = input;
            self
        }
        /// <p>The date and time when the source node's metadata and cache data set was obtained for the snapshot.</p>
        pub fn snapshot_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.snapshot_create_time = Some(input);
            self
        }
        /// <p>The date and time when the source node's metadata and cache data set was obtained for the snapshot.</p>
        pub fn set_snapshot_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.snapshot_create_time = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeSnapshot`](crate::model::NodeSnapshot)
        pub fn build(self) -> crate::model::NodeSnapshot {
            crate::model::NodeSnapshot {
                cache_cluster_id: self.cache_cluster_id,
                node_group_id: self.node_group_id,
                cache_node_id: self.cache_node_id,
                node_group_configuration: self.node_group_configuration,
                cache_size: self.cache_size,
                cache_node_create_time: self.cache_node_create_time,
                snapshot_create_time: self.snapshot_create_time,
            }
        }
    }
}
impl NodeSnapshot {
    /// Creates a new builder-style object to manufacture [`NodeSnapshot`](crate::model::NodeSnapshot)
    pub fn builder() -> crate::model::node_snapshot::Builder {
        crate::model::node_snapshot::Builder::default()
    }
}

/// <p>Node group (shard) configuration options.
/// Each node group (shard) configuration has the following: <code>Slots</code>, <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeGroupConfiguration {
    /// <p>Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for the node group these
    /// configuration values apply to.</p>
    pub node_group_id: std::option::Option<std::string::String>,
    /// <p>A string that specifies the keyspace for a particular node group.
    /// Keyspaces range from 0 to 16,383.
    /// The string is in the format <code>startkey-endkey</code>.</p>
    /// <p>Example: <code>"0-3999"</code>
    /// </p>
    pub slots: std::option::Option<std::string::String>,
    /// <p>The number of read replica nodes in this node group (shard).</p>
    pub replica_count: std::option::Option<i32>,
    /// <p>The Availability Zone where the primary node of this node group (shard) is launched.</p>
    pub primary_availability_zone: std::option::Option<std::string::String>,
    /// <p>A list of Availability Zones to be used for the read replicas.
    /// The number of Availability Zones in this list must match the value of <code>ReplicaCount</code>
    /// or <code>ReplicasPerNodeGroup</code> if not specified.</p>
    pub replica_availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The outpost ARN of the primary node.</p>
    pub primary_outpost_arn: std::option::Option<std::string::String>,
    /// <p>The outpost ARN of the node replicas.</p>
    pub replica_outpost_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl NodeGroupConfiguration {
    /// <p>Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for the node group these
    /// configuration values apply to.</p>
    pub fn node_group_id(&self) -> std::option::Option<&str> {
        self.node_group_id.as_deref()
    }
    /// <p>A string that specifies the keyspace for a particular node group.
    /// Keyspaces range from 0 to 16,383.
    /// The string is in the format <code>startkey-endkey</code>.</p>
    /// <p>Example: <code>"0-3999"</code>
    /// </p>
    pub fn slots(&self) -> std::option::Option<&str> {
        self.slots.as_deref()
    }
    /// <p>The number of read replica nodes in this node group (shard).</p>
    pub fn replica_count(&self) -> std::option::Option<i32> {
        self.replica_count
    }
    /// <p>The Availability Zone where the primary node of this node group (shard) is launched.</p>
    pub fn primary_availability_zone(&self) -> std::option::Option<&str> {
        self.primary_availability_zone.as_deref()
    }
    /// <p>A list of Availability Zones to be used for the read replicas.
    /// The number of Availability Zones in this list must match the value of <code>ReplicaCount</code>
    /// or <code>ReplicasPerNodeGroup</code> if not specified.</p>
    pub fn replica_availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.replica_availability_zones.as_deref()
    }
    /// <p>The outpost ARN of the primary node.</p>
    pub fn primary_outpost_arn(&self) -> std::option::Option<&str> {
        self.primary_outpost_arn.as_deref()
    }
    /// <p>The outpost ARN of the node replicas.</p>
    pub fn replica_outpost_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.replica_outpost_arns.as_deref()
    }
}
impl std::fmt::Debug for NodeGroupConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeGroupConfiguration");
        formatter.field("node_group_id", &self.node_group_id);
        formatter.field("slots", &self.slots);
        formatter.field("replica_count", &self.replica_count);
        formatter.field("primary_availability_zone", &self.primary_availability_zone);
        formatter.field(
            "replica_availability_zones",
            &self.replica_availability_zones,
        );
        formatter.field("primary_outpost_arn", &self.primary_outpost_arn);
        formatter.field("replica_outpost_arns", &self.replica_outpost_arns);
        formatter.finish()
    }
}
/// See [`NodeGroupConfiguration`](crate::model::NodeGroupConfiguration)
pub mod node_group_configuration {
    /// A builder for [`NodeGroupConfiguration`](crate::model::NodeGroupConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_group_id: std::option::Option<std::string::String>,
        pub(crate) slots: std::option::Option<std::string::String>,
        pub(crate) replica_count: std::option::Option<i32>,
        pub(crate) primary_availability_zone: std::option::Option<std::string::String>,
        pub(crate) replica_availability_zones:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) primary_outpost_arn: std::option::Option<std::string::String>,
        pub(crate) replica_outpost_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for the node group these
        /// configuration values apply to.</p>
        pub fn node_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_group_id = Some(input.into());
            self
        }
        /// <p>Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for the node group these
        /// configuration values apply to.</p>
        pub fn set_node_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.node_group_id = input;
            self
        }
        /// <p>A string that specifies the keyspace for a particular node group.
        /// Keyspaces range from 0 to 16,383.
        /// The string is in the format <code>startkey-endkey</code>.</p>
        /// <p>Example: <code>"0-3999"</code>
        /// </p>
        pub fn slots(mut self, input: impl Into<std::string::String>) -> Self {
            self.slots = Some(input.into());
            self
        }
        /// <p>A string that specifies the keyspace for a particular node group.
        /// Keyspaces range from 0 to 16,383.
        /// The string is in the format <code>startkey-endkey</code>.</p>
        /// <p>Example: <code>"0-3999"</code>
        /// </p>
        pub fn set_slots(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slots = input;
            self
        }
        /// <p>The number of read replica nodes in this node group (shard).</p>
        pub fn replica_count(mut self, input: i32) -> Self {
            self.replica_count = Some(input);
            self
        }
        /// <p>The number of read replica nodes in this node group (shard).</p>
        pub fn set_replica_count(mut self, input: std::option::Option<i32>) -> Self {
            self.replica_count = input;
            self
        }
        /// <p>The Availability Zone where the primary node of this node group (shard) is launched.</p>
        pub fn primary_availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone where the primary node of this node group (shard) is launched.</p>
        pub fn set_primary_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_availability_zone = input;
            self
        }
        /// Appends an item to `replica_availability_zones`.
        ///
        /// To override the contents of this collection use [`set_replica_availability_zones`](Self::set_replica_availability_zones).
        ///
        /// <p>A list of Availability Zones to be used for the read replicas.
        /// The number of Availability Zones in this list must match the value of <code>ReplicaCount</code>
        /// or <code>ReplicasPerNodeGroup</code> if not specified.</p>
        pub fn replica_availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.replica_availability_zones.unwrap_or_default();
            v.push(input.into());
            self.replica_availability_zones = Some(v);
            self
        }
        /// <p>A list of Availability Zones to be used for the read replicas.
        /// The number of Availability Zones in this list must match the value of <code>ReplicaCount</code>
        /// or <code>ReplicasPerNodeGroup</code> if not specified.</p>
        pub fn set_replica_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replica_availability_zones = input;
            self
        }
        /// <p>The outpost ARN of the primary node.</p>
        pub fn primary_outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_outpost_arn = Some(input.into());
            self
        }
        /// <p>The outpost ARN of the primary node.</p>
        pub fn set_primary_outpost_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_outpost_arn = input;
            self
        }
        /// Appends an item to `replica_outpost_arns`.
        ///
        /// To override the contents of this collection use [`set_replica_outpost_arns`](Self::set_replica_outpost_arns).
        ///
        /// <p>The outpost ARN of the node replicas.</p>
        pub fn replica_outpost_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.replica_outpost_arns.unwrap_or_default();
            v.push(input.into());
            self.replica_outpost_arns = Some(v);
            self
        }
        /// <p>The outpost ARN of the node replicas.</p>
        pub fn set_replica_outpost_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replica_outpost_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeGroupConfiguration`](crate::model::NodeGroupConfiguration)
        pub fn build(self) -> crate::model::NodeGroupConfiguration {
            crate::model::NodeGroupConfiguration {
                node_group_id: self.node_group_id,
                slots: self.slots,
                replica_count: self.replica_count,
                primary_availability_zone: self.primary_availability_zone,
                replica_availability_zones: self.replica_availability_zones,
                primary_outpost_arn: self.primary_outpost_arn,
                replica_outpost_arns: self.replica_outpost_arns,
            }
        }
    }
}
impl NodeGroupConfiguration {
    /// Creates a new builder-style object to manufacture [`NodeGroupConfiguration`](crate::model::NodeGroupConfiguration)
    pub fn builder() -> crate::model::node_group_configuration::Builder {
        crate::model::node_group_configuration::Builder::default()
    }
}

/// <p>An update that you can apply to your Redis clusters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUpdate {
    /// <p>The unique ID of the service update</p>
    pub service_update_name: std::option::Option<std::string::String>,
    /// <p>The date when the service update is initially available</p>
    pub service_update_release_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date after which the service update is no longer available</p>
    pub service_update_end_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The severity of the service update</p>
    pub service_update_severity: std::option::Option<crate::model::ServiceUpdateSeverity>,
    /// <p>The recommendend date to apply the service update in order to ensure compliance. For information on compliance, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service">Self-Service Security Updates for Compliance</a>.</p>
    pub service_update_recommended_apply_by_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the service update</p>
    pub service_update_status: std::option::Option<crate::model::ServiceUpdateStatus>,
    /// <p>Provides details of the service update</p>
    pub service_update_description: std::option::Option<std::string::String>,
    /// <p>Reflects the nature of the service update</p>
    pub service_update_type: std::option::Option<crate::model::ServiceUpdateType>,
    /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The Elasticache engine version to which the update applies. Either Redis or Memcached engine version</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Indicates whether the service update will be automatically applied once the recommended apply-by date has expired. </p>
    pub auto_update_after_recommended_apply_by_date: std::option::Option<bool>,
    /// <p>The estimated length of time the service update will take</p>
    pub estimated_update_time: std::option::Option<std::string::String>,
}
impl ServiceUpdate {
    /// <p>The unique ID of the service update</p>
    pub fn service_update_name(&self) -> std::option::Option<&str> {
        self.service_update_name.as_deref()
    }
    /// <p>The date when the service update is initially available</p>
    pub fn service_update_release_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.service_update_release_date.as_ref()
    }
    /// <p>The date after which the service update is no longer available</p>
    pub fn service_update_end_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.service_update_end_date.as_ref()
    }
    /// <p>The severity of the service update</p>
    pub fn service_update_severity(
        &self,
    ) -> std::option::Option<&crate::model::ServiceUpdateSeverity> {
        self.service_update_severity.as_ref()
    }
    /// <p>The recommendend date to apply the service update in order to ensure compliance. For information on compliance, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service">Self-Service Security Updates for Compliance</a>.</p>
    pub fn service_update_recommended_apply_by_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.service_update_recommended_apply_by_date.as_ref()
    }
    /// <p>The status of the service update</p>
    pub fn service_update_status(&self) -> std::option::Option<&crate::model::ServiceUpdateStatus> {
        self.service_update_status.as_ref()
    }
    /// <p>Provides details of the service update</p>
    pub fn service_update_description(&self) -> std::option::Option<&str> {
        self.service_update_description.as_deref()
    }
    /// <p>Reflects the nature of the service update</p>
    pub fn service_update_type(&self) -> std::option::Option<&crate::model::ServiceUpdateType> {
        self.service_update_type.as_ref()
    }
    /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The Elasticache engine version to which the update applies. Either Redis or Memcached engine version</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>Indicates whether the service update will be automatically applied once the recommended apply-by date has expired. </p>
    pub fn auto_update_after_recommended_apply_by_date(&self) -> std::option::Option<bool> {
        self.auto_update_after_recommended_apply_by_date
    }
    /// <p>The estimated length of time the service update will take</p>
    pub fn estimated_update_time(&self) -> std::option::Option<&str> {
        self.estimated_update_time.as_deref()
    }
}
impl std::fmt::Debug for ServiceUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUpdate");
        formatter.field("service_update_name", &self.service_update_name);
        formatter.field(
            "service_update_release_date",
            &self.service_update_release_date,
        );
        formatter.field("service_update_end_date", &self.service_update_end_date);
        formatter.field("service_update_severity", &self.service_update_severity);
        formatter.field(
            "service_update_recommended_apply_by_date",
            &self.service_update_recommended_apply_by_date,
        );
        formatter.field("service_update_status", &self.service_update_status);
        formatter.field(
            "service_update_description",
            &self.service_update_description,
        );
        formatter.field("service_update_type", &self.service_update_type);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "auto_update_after_recommended_apply_by_date",
            &self.auto_update_after_recommended_apply_by_date,
        );
        formatter.field("estimated_update_time", &self.estimated_update_time);
        formatter.finish()
    }
}
/// See [`ServiceUpdate`](crate::model::ServiceUpdate)
pub mod service_update {
    /// A builder for [`ServiceUpdate`](crate::model::ServiceUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_update_name: std::option::Option<std::string::String>,
        pub(crate) service_update_release_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) service_update_end_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) service_update_severity:
            std::option::Option<crate::model::ServiceUpdateSeverity>,
        pub(crate) service_update_recommended_apply_by_date:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) service_update_status: std::option::Option<crate::model::ServiceUpdateStatus>,
        pub(crate) service_update_description: std::option::Option<std::string::String>,
        pub(crate) service_update_type: std::option::Option<crate::model::ServiceUpdateType>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) auto_update_after_recommended_apply_by_date: std::option::Option<bool>,
        pub(crate) estimated_update_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_update_name = Some(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_update_name = input;
            self
        }
        /// <p>The date when the service update is initially available</p>
        pub fn service_update_release_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.service_update_release_date = Some(input);
            self
        }
        /// <p>The date when the service update is initially available</p>
        pub fn set_service_update_release_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.service_update_release_date = input;
            self
        }
        /// <p>The date after which the service update is no longer available</p>
        pub fn service_update_end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.service_update_end_date = Some(input);
            self
        }
        /// <p>The date after which the service update is no longer available</p>
        pub fn set_service_update_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.service_update_end_date = input;
            self
        }
        /// <p>The severity of the service update</p>
        pub fn service_update_severity(
            mut self,
            input: crate::model::ServiceUpdateSeverity,
        ) -> Self {
            self.service_update_severity = Some(input);
            self
        }
        /// <p>The severity of the service update</p>
        pub fn set_service_update_severity(
            mut self,
            input: std::option::Option<crate::model::ServiceUpdateSeverity>,
        ) -> Self {
            self.service_update_severity = input;
            self
        }
        /// <p>The recommendend date to apply the service update in order to ensure compliance. For information on compliance, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service">Self-Service Security Updates for Compliance</a>.</p>
        pub fn service_update_recommended_apply_by_date(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.service_update_recommended_apply_by_date = Some(input);
            self
        }
        /// <p>The recommendend date to apply the service update in order to ensure compliance. For information on compliance, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service">Self-Service Security Updates for Compliance</a>.</p>
        pub fn set_service_update_recommended_apply_by_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.service_update_recommended_apply_by_date = input;
            self
        }
        /// <p>The status of the service update</p>
        pub fn service_update_status(mut self, input: crate::model::ServiceUpdateStatus) -> Self {
            self.service_update_status = Some(input);
            self
        }
        /// <p>The status of the service update</p>
        pub fn set_service_update_status(
            mut self,
            input: std::option::Option<crate::model::ServiceUpdateStatus>,
        ) -> Self {
            self.service_update_status = input;
            self
        }
        /// <p>Provides details of the service update</p>
        pub fn service_update_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_update_description = Some(input.into());
            self
        }
        /// <p>Provides details of the service update</p>
        pub fn set_service_update_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_update_description = input;
            self
        }
        /// <p>Reflects the nature of the service update</p>
        pub fn service_update_type(mut self, input: crate::model::ServiceUpdateType) -> Self {
            self.service_update_type = Some(input);
            self
        }
        /// <p>Reflects the nature of the service update</p>
        pub fn set_service_update_type(
            mut self,
            input: std::option::Option<crate::model::ServiceUpdateType>,
        ) -> Self {
            self.service_update_type = input;
            self
        }
        /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The Elasticache engine version to which the update applies. Either Redis or Memcached engine version</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The Elasticache engine version to which the update applies. Either Redis or Memcached engine version</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Indicates whether the service update will be automatically applied once the recommended apply-by date has expired. </p>
        pub fn auto_update_after_recommended_apply_by_date(mut self, input: bool) -> Self {
            self.auto_update_after_recommended_apply_by_date = Some(input);
            self
        }
        /// <p>Indicates whether the service update will be automatically applied once the recommended apply-by date has expired. </p>
        pub fn set_auto_update_after_recommended_apply_by_date(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.auto_update_after_recommended_apply_by_date = input;
            self
        }
        /// <p>The estimated length of time the service update will take</p>
        pub fn estimated_update_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_update_time = Some(input.into());
            self
        }
        /// <p>The estimated length of time the service update will take</p>
        pub fn set_estimated_update_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUpdate`](crate::model::ServiceUpdate)
        pub fn build(self) -> crate::model::ServiceUpdate {
            crate::model::ServiceUpdate {
                service_update_name: self.service_update_name,
                service_update_release_date: self.service_update_release_date,
                service_update_end_date: self.service_update_end_date,
                service_update_severity: self.service_update_severity,
                service_update_recommended_apply_by_date: self
                    .service_update_recommended_apply_by_date,
                service_update_status: self.service_update_status,
                service_update_description: self.service_update_description,
                service_update_type: self.service_update_type,
                engine: self.engine,
                engine_version: self.engine_version,
                auto_update_after_recommended_apply_by_date: self
                    .auto_update_after_recommended_apply_by_date,
                estimated_update_time: self.estimated_update_time,
            }
        }
    }
}
impl ServiceUpdate {
    /// Creates a new builder-style object to manufacture [`ServiceUpdate`](crate::model::ServiceUpdate)
    pub fn builder() -> crate::model::service_update::Builder {
        crate::model::service_update::Builder::default()
    }
}

/// <p>Describes all of the attributes of a reserved cache node offering.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedCacheNodesOffering {
    /// <p>A unique identifier for the reserved cache node offering.</p>
    pub reserved_cache_nodes_offering_id: std::option::Option<std::string::String>,
    /// <p>The cache node type for the reserved cache node.</p>
    /// <p>The following node types are supported by ElastiCache.
    /// Generally speaking, the current generation types provide more memory and computational power
    /// at lower cost when compared to their equivalent previous generation counterparts.</p>
    /// <ul>
    /// <li>
    /// <p>General purpose:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    ///
    ///
    ///
    /// <p>
    /// <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):   <code>cache.m6g.large</code>,
    /// <code>cache.m6g.xlarge</code>,
    /// <code>cache.m6g.2xlarge</code>,
    /// <code>cache.m6g.4xlarge</code>,
    /// <code>cache.m6g.8xlarge</code>,
    /// <code>cache.m6g.12xlarge</code>,
    /// <code>cache.m6g.16xlarge</code>
    ///
    ///
    ///
    /// </p>  
    ///
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    ///
    ///
    /// <p>
    /// <b>M5 node types:</b>
    /// <code>cache.m5.large</code>,
    /// <code>cache.m5.xlarge</code>,
    /// <code>cache.m5.2xlarge</code>,
    /// <code>cache.m5.4xlarge</code>,
    /// <code>cache.m5.12xlarge</code>,
    /// <code>cache.m5.24xlarge</code>
    ///
    ///
    /// </p>  
    ///
    ///
    /// <p>
    /// <b>M4 node types:</b>
    /// <code>cache.m4.large</code>,
    /// <code>cache.m4.xlarge</code>,
    /// <code>cache.m4.2xlarge</code>,
    /// <code>cache.m4.4xlarge</code>,
    /// <code>cache.m4.10xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
    /// <code>cache.t4g.micro</code>,
    /// <code>cache.t4g.small</code>,
    /// <code>cache.t4g.medium</code>
    /// </p>            
    ///
    /// <p>
    /// <b>T3 node types:</b>
    /// <code>cache.t3.micro</code>,
    /// <code>cache.t3.small</code>,
    /// <code>cache.t3.medium</code>
    /// </p>
    ///
    ///
    /// <p>
    /// <b>T2 node types:</b>
    /// <code>cache.t2.micro</code>,
    /// <code>cache.t2.small</code>,
    /// <code>cache.t2.medium</code>
    /// </p>
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>T1 node types:</b>
    /// <code>cache.t1.micro</code>
    /// </p>
    ///
    /// <p>
    /// <b>M1 node types:</b>
    /// <code>cache.m1.small</code>,
    /// <code>cache.m1.medium</code>,
    /// <code>cache.m1.large</code>,
    /// <code>cache.m1.xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>M3 node types:</b>
    /// <code>cache.m3.medium</code>,
    /// <code>cache.m3.large</code>,
    /// <code>cache.m3.xlarge</code>,
    /// <code>cache.m3.2xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Compute optimized:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>C1 node types:</b>
    /// <code>cache.c1.xlarge</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized with data tiering:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    /// <p>
    /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
    ///
    ///
    ///
    ///
    /// <p>  
    ///
    /// <code>cache.r6gd.xlarge</code>,
    /// <code>cache.r6gd.2xlarge</code>,
    /// <code>cache.r6gd.4xlarge</code>,
    /// <code>cache.r6gd.8xlarge</code>,
    /// <code>cache.r6gd.12xlarge</code>,
    /// <code>cache.r6gd.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>              
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    ///
    /// <p>
    /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
    ///
    ///
    ///
    ///
    ///
    /// <p>  
    /// <code>cache.r6g.large</code>,
    /// <code>cache.r6g.xlarge</code>,
    /// <code>cache.r6g.2xlarge</code>,
    /// <code>cache.r6g.4xlarge</code>,
    /// <code>cache.r6g.8xlarge</code>,
    /// <code>cache.r6g.12xlarge</code>,
    /// <code>cache.r6g.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>  
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    /// <p>
    /// <b>R5 node types:</b>
    /// <code>cache.r5.large</code>,
    /// <code>cache.r5.xlarge</code>,
    /// <code>cache.r5.2xlarge</code>,
    /// <code>cache.r5.4xlarge</code>,
    /// <code>cache.r5.12xlarge</code>,
    /// <code>cache.r5.24xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R4 node types:</b>
    /// <code>cache.r4.large</code>,
    /// <code>cache.r4.xlarge</code>,
    /// <code>cache.r4.2xlarge</code>,
    /// <code>cache.r4.4xlarge</code>,
    /// <code>cache.r4.8xlarge</code>,
    /// <code>cache.r4.16xlarge</code>
    /// </p>
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>M2 node types:</b>            
    /// <code>cache.m2.xlarge</code>,
    /// <code>cache.m2.2xlarge</code>,
    /// <code>cache.m2.4xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R3 node types:</b>
    /// <code>cache.r3.large</code>,
    /// <code>cache.r3.xlarge</code>,
    /// <code>cache.r3.2xlarge</code>,  
    /// <code>cache.r3.4xlarge</code>,
    /// <code>cache.r3.8xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    ///
    /// <p>
    /// <b>Additional node type info</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>All current generation instance types are created in Amazon VPC by default.</p>
    /// </li>
    /// <li>
    /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis configuration variables <code>appendonly</code> and
    /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
    /// </li>
    /// </ul>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>The duration of the offering. in seconds.</p>
    pub duration: i32,
    /// <p>The fixed price charged for this offering.</p>
    pub fixed_price: f64,
    /// <p>The hourly price charged for this offering.</p>
    pub usage_price: f64,
    /// <p>The cache engine used by the offering.</p>
    pub product_description: std::option::Option<std::string::String>,
    /// <p>The offering type.</p>
    pub offering_type: std::option::Option<std::string::String>,
    /// <p>The recurring price charged to run this reserved cache node.</p>
    pub recurring_charges: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
}
impl ReservedCacheNodesOffering {
    /// <p>A unique identifier for the reserved cache node offering.</p>
    pub fn reserved_cache_nodes_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_cache_nodes_offering_id.as_deref()
    }
    /// <p>The cache node type for the reserved cache node.</p>
    /// <p>The following node types are supported by ElastiCache.
    /// Generally speaking, the current generation types provide more memory and computational power
    /// at lower cost when compared to their equivalent previous generation counterparts.</p>
    /// <ul>
    /// <li>
    /// <p>General purpose:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    ///
    ///
    ///
    /// <p>
    /// <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):   <code>cache.m6g.large</code>,
    /// <code>cache.m6g.xlarge</code>,
    /// <code>cache.m6g.2xlarge</code>,
    /// <code>cache.m6g.4xlarge</code>,
    /// <code>cache.m6g.8xlarge</code>,
    /// <code>cache.m6g.12xlarge</code>,
    /// <code>cache.m6g.16xlarge</code>
    ///
    ///
    ///
    /// </p>  
    ///
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    ///
    ///
    /// <p>
    /// <b>M5 node types:</b>
    /// <code>cache.m5.large</code>,
    /// <code>cache.m5.xlarge</code>,
    /// <code>cache.m5.2xlarge</code>,
    /// <code>cache.m5.4xlarge</code>,
    /// <code>cache.m5.12xlarge</code>,
    /// <code>cache.m5.24xlarge</code>
    ///
    ///
    /// </p>  
    ///
    ///
    /// <p>
    /// <b>M4 node types:</b>
    /// <code>cache.m4.large</code>,
    /// <code>cache.m4.xlarge</code>,
    /// <code>cache.m4.2xlarge</code>,
    /// <code>cache.m4.4xlarge</code>,
    /// <code>cache.m4.10xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
    /// <code>cache.t4g.micro</code>,
    /// <code>cache.t4g.small</code>,
    /// <code>cache.t4g.medium</code>
    /// </p>            
    ///
    /// <p>
    /// <b>T3 node types:</b>
    /// <code>cache.t3.micro</code>,
    /// <code>cache.t3.small</code>,
    /// <code>cache.t3.medium</code>
    /// </p>
    ///
    ///
    /// <p>
    /// <b>T2 node types:</b>
    /// <code>cache.t2.micro</code>,
    /// <code>cache.t2.small</code>,
    /// <code>cache.t2.medium</code>
    /// </p>
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>T1 node types:</b>
    /// <code>cache.t1.micro</code>
    /// </p>
    ///
    /// <p>
    /// <b>M1 node types:</b>
    /// <code>cache.m1.small</code>,
    /// <code>cache.m1.medium</code>,
    /// <code>cache.m1.large</code>,
    /// <code>cache.m1.xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>M3 node types:</b>
    /// <code>cache.m3.medium</code>,
    /// <code>cache.m3.large</code>,
    /// <code>cache.m3.xlarge</code>,
    /// <code>cache.m3.2xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Compute optimized:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>C1 node types:</b>
    /// <code>cache.c1.xlarge</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized with data tiering:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    /// <p>
    /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
    ///
    ///
    ///
    ///
    /// <p>  
    ///
    /// <code>cache.r6gd.xlarge</code>,
    /// <code>cache.r6gd.2xlarge</code>,
    /// <code>cache.r6gd.4xlarge</code>,
    /// <code>cache.r6gd.8xlarge</code>,
    /// <code>cache.r6gd.12xlarge</code>,
    /// <code>cache.r6gd.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>              
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Memory optimized:</p>
    /// <ul>
    /// <li>
    /// <p>Current generation: </p>
    ///
    ///
    ///
    ///
    /// <p>
    /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
    ///
    ///
    ///
    ///
    ///
    /// <p>  
    /// <code>cache.r6g.large</code>,
    /// <code>cache.r6g.xlarge</code>,
    /// <code>cache.r6g.2xlarge</code>,
    /// <code>cache.r6g.4xlarge</code>,
    /// <code>cache.r6g.8xlarge</code>,
    /// <code>cache.r6g.12xlarge</code>,
    /// <code>cache.r6g.16xlarge</code>
    ///
    ///
    ///
    ///
    ///
    ///
    /// </p>  
    /// <note>
    /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
    /// </p>
    /// </note>
    /// <p>
    /// <b>R5 node types:</b>
    /// <code>cache.r5.large</code>,
    /// <code>cache.r5.xlarge</code>,
    /// <code>cache.r5.2xlarge</code>,
    /// <code>cache.r5.4xlarge</code>,
    /// <code>cache.r5.12xlarge</code>,
    /// <code>cache.r5.24xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R4 node types:</b>
    /// <code>cache.r4.large</code>,
    /// <code>cache.r4.xlarge</code>,
    /// <code>cache.r4.2xlarge</code>,
    /// <code>cache.r4.4xlarge</code>,
    /// <code>cache.r4.8xlarge</code>,
    /// <code>cache.r4.16xlarge</code>
    /// </p>
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    /// </li>
    /// <li>
    /// <p>Previous generation: (not recommended)</p>
    /// <p>
    /// <b>M2 node types:</b>            
    /// <code>cache.m2.xlarge</code>,
    /// <code>cache.m2.2xlarge</code>,
    /// <code>cache.m2.4xlarge</code>
    /// </p>
    ///
    /// <p>
    /// <b>R3 node types:</b>
    /// <code>cache.r3.large</code>,
    /// <code>cache.r3.xlarge</code>,
    /// <code>cache.r3.2xlarge</code>,  
    /// <code>cache.r3.4xlarge</code>,
    /// <code>cache.r3.8xlarge</code>
    /// </p>
    ///
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    ///
    /// <p>
    /// <b>Additional node type info</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>All current generation instance types are created in Amazon VPC by default.</p>
    /// </li>
    /// <li>
    /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
    /// </li>
    /// <li>
    /// <p>Redis configuration variables <code>appendonly</code> and
    /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
    /// </li>
    /// </ul>
    pub fn cache_node_type(&self) -> std::option::Option<&str> {
        self.cache_node_type.as_deref()
    }
    /// <p>The duration of the offering. in seconds.</p>
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// <p>The fixed price charged for this offering.</p>
    pub fn fixed_price(&self) -> f64 {
        self.fixed_price
    }
    /// <p>The hourly price charged for this offering.</p>
    pub fn usage_price(&self) -> f64 {
        self.usage_price
    }
    /// <p>The cache engine used by the offering.</p>
    pub fn product_description(&self) -> std::option::Option<&str> {
        self.product_description.as_deref()
    }
    /// <p>The offering type.</p>
    pub fn offering_type(&self) -> std::option::Option<&str> {
        self.offering_type.as_deref()
    }
    /// <p>The recurring price charged to run this reserved cache node.</p>
    pub fn recurring_charges(&self) -> std::option::Option<&[crate::model::RecurringCharge]> {
        self.recurring_charges.as_deref()
    }
}
impl std::fmt::Debug for ReservedCacheNodesOffering {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedCacheNodesOffering");
        formatter.field(
            "reserved_cache_nodes_offering_id",
            &self.reserved_cache_nodes_offering_id,
        );
        formatter.field("cache_node_type", &self.cache_node_type);
        formatter.field("duration", &self.duration);
        formatter.field("fixed_price", &self.fixed_price);
        formatter.field("usage_price", &self.usage_price);
        formatter.field("product_description", &self.product_description);
        formatter.field("offering_type", &self.offering_type);
        formatter.field("recurring_charges", &self.recurring_charges);
        formatter.finish()
    }
}
/// See [`ReservedCacheNodesOffering`](crate::model::ReservedCacheNodesOffering)
pub mod reserved_cache_nodes_offering {
    /// A builder for [`ReservedCacheNodesOffering`](crate::model::ReservedCacheNodesOffering)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_cache_nodes_offering_id: std::option::Option<std::string::String>,
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) fixed_price: std::option::Option<f64>,
        pub(crate) usage_price: std::option::Option<f64>,
        pub(crate) product_description: std::option::Option<std::string::String>,
        pub(crate) offering_type: std::option::Option<std::string::String>,
        pub(crate) recurring_charges:
            std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
    }
    impl Builder {
        /// <p>A unique identifier for the reserved cache node offering.</p>
        pub fn reserved_cache_nodes_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_cache_nodes_offering_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the reserved cache node offering.</p>
        pub fn set_reserved_cache_nodes_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_cache_nodes_offering_id = input;
            self
        }
        /// <p>The cache node type for the reserved cache node.</p>
        /// <p>The following node types are supported by ElastiCache.
        /// Generally speaking, the current generation types provide more memory and computational power
        /// at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li>
        /// <p>General purpose:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        ///
        ///
        ///
        /// <p>
        /// <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):   <code>cache.m6g.large</code>,
        /// <code>cache.m6g.xlarge</code>,
        /// <code>cache.m6g.2xlarge</code>,
        /// <code>cache.m6g.4xlarge</code>,
        /// <code>cache.m6g.8xlarge</code>,
        /// <code>cache.m6g.12xlarge</code>,
        /// <code>cache.m6g.16xlarge</code>
        ///
        ///
        ///
        /// </p>  
        ///
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        ///
        ///
        /// <p>
        /// <b>M5 node types:</b>
        /// <code>cache.m5.large</code>,
        /// <code>cache.m5.xlarge</code>,
        /// <code>cache.m5.2xlarge</code>,
        /// <code>cache.m5.4xlarge</code>,
        /// <code>cache.m5.12xlarge</code>,
        /// <code>cache.m5.24xlarge</code>
        ///
        ///
        /// </p>  
        ///
        ///
        /// <p>
        /// <b>M4 node types:</b>
        /// <code>cache.m4.large</code>,
        /// <code>cache.m4.xlarge</code>,
        /// <code>cache.m4.2xlarge</code>,
        /// <code>cache.m4.4xlarge</code>,
        /// <code>cache.m4.10xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
        /// <code>cache.t4g.micro</code>,
        /// <code>cache.t4g.small</code>,
        /// <code>cache.t4g.medium</code>
        /// </p>            
        ///
        /// <p>
        /// <b>T3 node types:</b>
        /// <code>cache.t3.micro</code>,
        /// <code>cache.t3.small</code>,
        /// <code>cache.t3.medium</code>
        /// </p>
        ///
        ///
        /// <p>
        /// <b>T2 node types:</b>
        /// <code>cache.t2.micro</code>,
        /// <code>cache.t2.small</code>,
        /// <code>cache.t2.medium</code>
        /// </p>
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>T1 node types:</b>
        /// <code>cache.t1.micro</code>
        /// </p>
        ///
        /// <p>
        /// <b>M1 node types:</b>
        /// <code>cache.m1.small</code>,
        /// <code>cache.m1.medium</code>,
        /// <code>cache.m1.large</code>,
        /// <code>cache.m1.xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>M3 node types:</b>
        /// <code>cache.m3.medium</code>,
        /// <code>cache.m3.large</code>,
        /// <code>cache.m3.xlarge</code>,
        /// <code>cache.m3.2xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Compute optimized:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>C1 node types:</b>
        /// <code>cache.c1.xlarge</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        /// <p>
        /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
        ///
        ///
        ///
        ///
        /// <p>  
        ///
        /// <code>cache.r6gd.xlarge</code>,
        /// <code>cache.r6gd.2xlarge</code>,
        /// <code>cache.r6gd.4xlarge</code>,
        /// <code>cache.r6gd.8xlarge</code>,
        /// <code>cache.r6gd.12xlarge</code>,
        /// <code>cache.r6gd.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>              
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        ///
        /// <p>
        /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
        ///
        ///
        ///
        ///
        ///
        /// <p>  
        /// <code>cache.r6g.large</code>,
        /// <code>cache.r6g.xlarge</code>,
        /// <code>cache.r6g.2xlarge</code>,
        /// <code>cache.r6g.4xlarge</code>,
        /// <code>cache.r6g.8xlarge</code>,
        /// <code>cache.r6g.12xlarge</code>,
        /// <code>cache.r6g.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>  
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        /// <p>
        /// <b>R5 node types:</b>
        /// <code>cache.r5.large</code>,
        /// <code>cache.r5.xlarge</code>,
        /// <code>cache.r5.2xlarge</code>,
        /// <code>cache.r5.4xlarge</code>,
        /// <code>cache.r5.12xlarge</code>,
        /// <code>cache.r5.24xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R4 node types:</b>
        /// <code>cache.r4.large</code>,
        /// <code>cache.r4.xlarge</code>,
        /// <code>cache.r4.2xlarge</code>,
        /// <code>cache.r4.4xlarge</code>,
        /// <code>cache.r4.8xlarge</code>,
        /// <code>cache.r4.16xlarge</code>
        /// </p>
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>M2 node types:</b>            
        /// <code>cache.m2.xlarge</code>,
        /// <code>cache.m2.2xlarge</code>,
        /// <code>cache.m2.4xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R3 node types:</b>
        /// <code>cache.r3.large</code>,
        /// <code>cache.r3.xlarge</code>,
        /// <code>cache.r3.2xlarge</code>,  
        /// <code>cache.r3.4xlarge</code>,
        /// <code>cache.r3.8xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Additional node type info</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>All current generation instance types are created in Amazon VPC by default.</p>
        /// </li>
        /// <li>
        /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis configuration variables <code>appendonly</code> and
        /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
        /// </li>
        /// </ul>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>The cache node type for the reserved cache node.</p>
        /// <p>The following node types are supported by ElastiCache.
        /// Generally speaking, the current generation types provide more memory and computational power
        /// at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li>
        /// <p>General purpose:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        ///
        ///
        ///
        /// <p>
        /// <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):   <code>cache.m6g.large</code>,
        /// <code>cache.m6g.xlarge</code>,
        /// <code>cache.m6g.2xlarge</code>,
        /// <code>cache.m6g.4xlarge</code>,
        /// <code>cache.m6g.8xlarge</code>,
        /// <code>cache.m6g.12xlarge</code>,
        /// <code>cache.m6g.16xlarge</code>
        ///
        ///
        ///
        /// </p>  
        ///
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        ///
        ///
        /// <p>
        /// <b>M5 node types:</b>
        /// <code>cache.m5.large</code>,
        /// <code>cache.m5.xlarge</code>,
        /// <code>cache.m5.2xlarge</code>,
        /// <code>cache.m5.4xlarge</code>,
        /// <code>cache.m5.12xlarge</code>,
        /// <code>cache.m5.24xlarge</code>
        ///
        ///
        /// </p>  
        ///
        ///
        /// <p>
        /// <b>M4 node types:</b>
        /// <code>cache.m4.large</code>,
        /// <code>cache.m4.xlarge</code>,
        /// <code>cache.m4.2xlarge</code>,
        /// <code>cache.m4.4xlarge</code>,
        /// <code>cache.m4.10xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
        /// <code>cache.t4g.micro</code>,
        /// <code>cache.t4g.small</code>,
        /// <code>cache.t4g.medium</code>
        /// </p>            
        ///
        /// <p>
        /// <b>T3 node types:</b>
        /// <code>cache.t3.micro</code>,
        /// <code>cache.t3.small</code>,
        /// <code>cache.t3.medium</code>
        /// </p>
        ///
        ///
        /// <p>
        /// <b>T2 node types:</b>
        /// <code>cache.t2.micro</code>,
        /// <code>cache.t2.small</code>,
        /// <code>cache.t2.medium</code>
        /// </p>
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>T1 node types:</b>
        /// <code>cache.t1.micro</code>
        /// </p>
        ///
        /// <p>
        /// <b>M1 node types:</b>
        /// <code>cache.m1.small</code>,
        /// <code>cache.m1.medium</code>,
        /// <code>cache.m1.large</code>,
        /// <code>cache.m1.xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>M3 node types:</b>
        /// <code>cache.m3.medium</code>,
        /// <code>cache.m3.large</code>,
        /// <code>cache.m3.xlarge</code>,
        /// <code>cache.m3.2xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Compute optimized:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>C1 node types:</b>
        /// <code>cache.c1.xlarge</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        /// <p>
        /// <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p>
        ///
        ///
        ///
        ///
        /// <p>  
        ///
        /// <code>cache.r6gd.xlarge</code>,
        /// <code>cache.r6gd.2xlarge</code>,
        /// <code>cache.r6gd.4xlarge</code>,
        /// <code>cache.r6gd.8xlarge</code>,
        /// <code>cache.r6gd.12xlarge</code>,
        /// <code>cache.r6gd.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>              
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Memory optimized:</p>
        /// <ul>
        /// <li>
        /// <p>Current generation: </p>
        ///
        ///
        ///
        ///
        /// <p>
        /// <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p>
        ///
        ///
        ///
        ///
        ///
        /// <p>  
        /// <code>cache.r6g.large</code>,
        /// <code>cache.r6g.xlarge</code>,
        /// <code>cache.r6g.2xlarge</code>,
        /// <code>cache.r6g.4xlarge</code>,
        /// <code>cache.r6g.8xlarge</code>,
        /// <code>cache.r6g.12xlarge</code>,
        /// <code>cache.r6g.16xlarge</code>
        ///
        ///
        ///
        ///
        ///
        ///
        /// </p>  
        /// <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a>
        /// </p>
        /// </note>
        /// <p>
        /// <b>R5 node types:</b>
        /// <code>cache.r5.large</code>,
        /// <code>cache.r5.xlarge</code>,
        /// <code>cache.r5.2xlarge</code>,
        /// <code>cache.r5.4xlarge</code>,
        /// <code>cache.r5.12xlarge</code>,
        /// <code>cache.r5.24xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R4 node types:</b>
        /// <code>cache.r4.large</code>,
        /// <code>cache.r4.xlarge</code>,
        /// <code>cache.r4.2xlarge</code>,
        /// <code>cache.r4.4xlarge</code>,
        /// <code>cache.r4.8xlarge</code>,
        /// <code>cache.r4.16xlarge</code>
        /// </p>
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        ///
        /// </li>
        /// <li>
        /// <p>Previous generation: (not recommended)</p>
        /// <p>
        /// <b>M2 node types:</b>            
        /// <code>cache.m2.xlarge</code>,
        /// <code>cache.m2.2xlarge</code>,
        /// <code>cache.m2.4xlarge</code>
        /// </p>
        ///
        /// <p>
        /// <b>R3 node types:</b>
        /// <code>cache.r3.large</code>,
        /// <code>cache.r3.xlarge</code>,
        /// <code>cache.r3.2xlarge</code>,  
        /// <code>cache.r3.4xlarge</code>,
        /// <code>cache.r3.8xlarge</code>
        /// </p>
        ///
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Additional node type info</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>All current generation instance types are created in Amazon VPC by default.</p>
        /// </li>
        /// <li>
        /// <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p>
        /// </li>
        /// <li>
        /// <p>Redis configuration variables <code>appendonly</code> and
        /// <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p>
        /// </li>
        /// </ul>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>The duration of the offering. in seconds.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The duration of the offering. in seconds.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The fixed price charged for this offering.</p>
        pub fn fixed_price(mut self, input: f64) -> Self {
            self.fixed_price = Some(input);
            self
        }
        /// <p>The fixed price charged for this offering.</p>
        pub fn set_fixed_price(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_price = input;
            self
        }
        /// <p>The hourly price charged for this offering.</p>
        pub fn usage_price(mut self, input: f64) -> Self {
            self.usage_price = Some(input);
            self
        }
        /// <p>The hourly price charged for this offering.</p>
        pub fn set_usage_price(mut self, input: std::option::Option<f64>) -> Self {
            self.usage_price = input;
            self
        }
        /// <p>The cache engine used by the offering.</p>
        pub fn product_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_description = Some(input.into());
            self
        }
        /// <p>The cache engine used by the offering.</p>
        pub fn set_product_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.product_description = input;
            self
        }
        /// <p>The offering type.</p>
        pub fn offering_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_type = Some(input.into());
            self
        }
        /// <p>The offering type.</p>
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_type = input;
            self
        }
        /// Appends an item to `recurring_charges`.
        ///
        /// To override the contents of this collection use [`set_recurring_charges`](Self::set_recurring_charges).
        ///
        /// <p>The recurring price charged to run this reserved cache node.</p>
        pub fn recurring_charges(
            mut self,
            input: impl Into<crate::model::RecurringCharge>,
        ) -> Self {
            let mut v = self.recurring_charges.unwrap_or_default();
            v.push(input.into());
            self.recurring_charges = Some(v);
            self
        }
        /// <p>The recurring price charged to run this reserved cache node.</p>
        pub fn set_recurring_charges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
        ) -> Self {
            self.recurring_charges = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedCacheNodesOffering`](crate::model::ReservedCacheNodesOffering)
        pub fn build(self) -> crate::model::ReservedCacheNodesOffering {
            crate::model::ReservedCacheNodesOffering {
                reserved_cache_nodes_offering_id: self.reserved_cache_nodes_offering_id,
                cache_node_type: self.cache_node_type,
                duration: self.duration.unwrap_or_default(),
                fixed_price: self.fixed_price.unwrap_or_default(),
                usage_price: self.usage_price.unwrap_or_default(),
                product_description: self.product_description,
                offering_type: self.offering_type,
                recurring_charges: self.recurring_charges,
            }
        }
    }
}
impl ReservedCacheNodesOffering {
    /// Creates a new builder-style object to manufacture [`ReservedCacheNodesOffering`](crate::model::ReservedCacheNodesOffering)
    pub fn builder() -> crate::model::reserved_cache_nodes_offering::Builder {
        crate::model::reserved_cache_nodes_offering::Builder::default()
    }
}

/// <p>Represents a single occurrence of something interesting within the system.
/// Some examples of events are creating a cluster, adding or removing a cache node, or rebooting a node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>The identifier for the source of the event.
    /// For example, if the event occurred at the cluster level,
    /// the identifier would be the name of the cluster.</p>
    pub source_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the origin of this event - a cluster, a parameter group, a security group, etc.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>The text of the event.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The date and time when the event occurred.</p>
    pub date: std::option::Option<aws_smithy_types::DateTime>,
}
impl Event {
    /// <p>The identifier for the source of the event.
    /// For example, if the event occurred at the cluster level,
    /// the identifier would be the name of the cluster.</p>
    pub fn source_identifier(&self) -> std::option::Option<&str> {
        self.source_identifier.as_deref()
    }
    /// <p>Specifies the origin of this event - a cluster, a parameter group, a security group, etc.</p>
    pub fn source_type(&self) -> std::option::Option<&crate::model::SourceType> {
        self.source_type.as_ref()
    }
    /// <p>The text of the event.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The date and time when the event occurred.</p>
    pub fn date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date.as_ref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("source_identifier", &self.source_identifier);
        formatter.field("source_type", &self.source_type);
        formatter.field("message", &self.message);
        formatter.field("date", &self.date);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_identifier: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier for the source of the event.
        /// For example, if the event occurred at the cluster level,
        /// the identifier would be the name of the cluster.</p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the source of the event.
        /// For example, if the event occurred at the cluster level,
        /// the identifier would be the name of the cluster.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// <p>Specifies the origin of this event - a cluster, a parameter group, a security group, etc.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>Specifies the origin of this event - a cluster, a parameter group, a security group, etc.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The text of the event.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The text of the event.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The date and time when the event occurred.</p>
        pub fn date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>The date and time when the event occurred.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.date = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                source_identifier: self.source_identifier,
                source_type: self.source_type,
                message: self.message,
                date: self.date,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    CacheCluster,
    #[allow(missing_docs)] // documentation missing in model
    CacheParameterGroup,
    #[allow(missing_docs)] // documentation missing in model
    CacheSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    CacheSubnetGroup,
    #[allow(missing_docs)] // documentation missing in model
    ReplicationGroup,
    #[allow(missing_docs)] // documentation missing in model
    User,
    #[allow(missing_docs)] // documentation missing in model
    UserGroup,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "cache-cluster" => SourceType::CacheCluster,
            "cache-parameter-group" => SourceType::CacheParameterGroup,
            "cache-security-group" => SourceType::CacheSecurityGroup,
            "cache-subnet-group" => SourceType::CacheSubnetGroup,
            "replication-group" => SourceType::ReplicationGroup,
            "user" => SourceType::User,
            "user-group" => SourceType::UserGroup,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::CacheCluster => "cache-cluster",
            SourceType::CacheParameterGroup => "cache-parameter-group",
            SourceType::CacheSecurityGroup => "cache-security-group",
            SourceType::CacheSubnetGroup => "cache-subnet-group",
            SourceType::ReplicationGroup => "replication-group",
            SourceType::User => "user",
            SourceType::UserGroup => "user-group",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "cache-cluster",
            "cache-parameter-group",
            "cache-security-group",
            "cache-subnet-group",
            "replication-group",
            "user",
            "user-group",
        ]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the output of a <code>DescribeEngineDefaultParameters</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EngineDefaults {
    /// <p>Specifies the name of the cache parameter group family to which the engine default parameters apply.</p>
    /// <p>Valid values are:
    /// <code>memcached1.4</code> |
    /// <code>memcached1.5</code> |
    /// <code>memcached1.6</code> |
    /// <code>redis2.6</code> |
    /// <code>redis2.8</code> |
    /// <code>redis3.2</code> |
    /// <code>redis4.0</code> |
    /// <code>redis5.0</code> |
    /// <code>redis6.0</code> |
    /// <code>redis6.2</code>
    /// </p>
    pub cache_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Contains a list of engine default parameters.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>A list of parameters specific to a particular cache node type. Each element in the list contains detailed information about one parameter.</p>
    pub cache_node_type_specific_parameters:
        std::option::Option<std::vec::Vec<crate::model::CacheNodeTypeSpecificParameter>>,
}
impl EngineDefaults {
    /// <p>Specifies the name of the cache parameter group family to which the engine default parameters apply.</p>
    /// <p>Valid values are:
    /// <code>memcached1.4</code> |
    /// <code>memcached1.5</code> |
    /// <code>memcached1.6</code> |
    /// <code>redis2.6</code> |
    /// <code>redis2.8</code> |
    /// <code>redis3.2</code> |
    /// <code>redis4.0</code> |
    /// <code>redis5.0</code> |
    /// <code>redis6.0</code> |
    /// <code>redis6.2</code>
    /// </p>
    pub fn cache_parameter_group_family(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_family.as_deref()
    }
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Contains a list of engine default parameters.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
    /// <p>A list of parameters specific to a particular cache node type. Each element in the list contains detailed information about one parameter.</p>
    pub fn cache_node_type_specific_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::CacheNodeTypeSpecificParameter]> {
        self.cache_node_type_specific_parameters.as_deref()
    }
}
impl std::fmt::Debug for EngineDefaults {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EngineDefaults");
        formatter.field(
            "cache_parameter_group_family",
            &self.cache_parameter_group_family,
        );
        formatter.field("marker", &self.marker);
        formatter.field("parameters", &self.parameters);
        formatter.field(
            "cache_node_type_specific_parameters",
            &self.cache_node_type_specific_parameters,
        );
        formatter.finish()
    }
}
/// See [`EngineDefaults`](crate::model::EngineDefaults)
pub mod engine_defaults {
    /// A builder for [`EngineDefaults`](crate::model::EngineDefaults)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) cache_node_type_specific_parameters:
            std::option::Option<std::vec::Vec<crate::model::CacheNodeTypeSpecificParameter>>,
    }
    impl Builder {
        /// <p>Specifies the name of the cache parameter group family to which the engine default parameters apply.</p>
        /// <p>Valid values are:
        /// <code>memcached1.4</code> |
        /// <code>memcached1.5</code> |
        /// <code>memcached1.6</code> |
        /// <code>redis2.6</code> |
        /// <code>redis2.8</code> |
        /// <code>redis3.2</code> |
        /// <code>redis4.0</code> |
        /// <code>redis5.0</code> |
        /// <code>redis6.0</code> |
        /// <code>redis6.2</code>
        /// </p>
        pub fn cache_parameter_group_family(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_family = Some(input.into());
            self
        }
        /// <p>Specifies the name of the cache parameter group family to which the engine default parameters apply.</p>
        /// <p>Valid values are:
        /// <code>memcached1.4</code> |
        /// <code>memcached1.5</code> |
        /// <code>memcached1.6</code> |
        /// <code>redis2.6</code> |
        /// <code>redis2.8</code> |
        /// <code>redis3.2</code> |
        /// <code>redis4.0</code> |
        /// <code>redis5.0</code> |
        /// <code>redis6.0</code> |
        /// <code>redis6.2</code>
        /// </p>
        pub fn set_cache_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_family = input;
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Contains a list of engine default parameters.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>Contains a list of engine default parameters.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `cache_node_type_specific_parameters`.
        ///
        /// To override the contents of this collection use [`set_cache_node_type_specific_parameters`](Self::set_cache_node_type_specific_parameters).
        ///
        /// <p>A list of parameters specific to a particular cache node type. Each element in the list contains detailed information about one parameter.</p>
        pub fn cache_node_type_specific_parameters(
            mut self,
            input: impl Into<crate::model::CacheNodeTypeSpecificParameter>,
        ) -> Self {
            let mut v = self.cache_node_type_specific_parameters.unwrap_or_default();
            v.push(input.into());
            self.cache_node_type_specific_parameters = Some(v);
            self
        }
        /// <p>A list of parameters specific to a particular cache node type. Each element in the list contains detailed information about one parameter.</p>
        pub fn set_cache_node_type_specific_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheNodeTypeSpecificParameter>>,
        ) -> Self {
            self.cache_node_type_specific_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`EngineDefaults`](crate::model::EngineDefaults)
        pub fn build(self) -> crate::model::EngineDefaults {
            crate::model::EngineDefaults {
                cache_parameter_group_family: self.cache_parameter_group_family,
                marker: self.marker,
                parameters: self.parameters,
                cache_node_type_specific_parameters: self.cache_node_type_specific_parameters,
            }
        }
    }
}
impl EngineDefaults {
    /// Creates a new builder-style object to manufacture [`EngineDefaults`](crate::model::EngineDefaults)
    pub fn builder() -> crate::model::engine_defaults::Builder {
        crate::model::engine_defaults::Builder::default()
    }
}

/// <p>A parameter that has a different value for each cache node type it is applied to. For
/// example, in a Redis cluster, a <code>cache.m1.large</code> cache node type would have a
/// larger <code>maxmemory</code> value than a <code>cache.m1.small</code> type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheNodeTypeSpecificParameter {
    /// <p>The name of the parameter.</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>A description of the parameter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The source of the parameter value.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The valid data type for the parameter.</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>The valid range of values for the parameter.</p>
    pub allowed_values: std::option::Option<std::string::String>,
    /// <p>Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be
    /// modified. Some parameters have security or operational implications that prevent them
    /// from being changed.</p>
    pub is_modifiable: bool,
    /// <p>The earliest cache engine version to which the parameter can apply.</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>A list of cache node types and their corresponding values for this parameter.</p>
    pub cache_node_type_specific_values:
        std::option::Option<std::vec::Vec<crate::model::CacheNodeTypeSpecificValue>>,
    /// <p>Indicates whether a change to the parameter is applied immediately
    /// or requires a reboot for the change to be applied.
    /// You can force a reboot or wait until the next maintenance window's reboot.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a Cluster</a>.</p>
    pub change_type: std::option::Option<crate::model::ChangeType>,
}
impl CacheNodeTypeSpecificParameter {
    /// <p>The name of the parameter.</p>
    pub fn parameter_name(&self) -> std::option::Option<&str> {
        self.parameter_name.as_deref()
    }
    /// <p>A description of the parameter.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The source of the parameter value.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The valid data type for the parameter.</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
    /// <p>The valid range of values for the parameter.</p>
    pub fn allowed_values(&self) -> std::option::Option<&str> {
        self.allowed_values.as_deref()
    }
    /// <p>Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be
    /// modified. Some parameters have security or operational implications that prevent them
    /// from being changed.</p>
    pub fn is_modifiable(&self) -> bool {
        self.is_modifiable
    }
    /// <p>The earliest cache engine version to which the parameter can apply.</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>A list of cache node types and their corresponding values for this parameter.</p>
    pub fn cache_node_type_specific_values(
        &self,
    ) -> std::option::Option<&[crate::model::CacheNodeTypeSpecificValue]> {
        self.cache_node_type_specific_values.as_deref()
    }
    /// <p>Indicates whether a change to the parameter is applied immediately
    /// or requires a reboot for the change to be applied.
    /// You can force a reboot or wait until the next maintenance window's reboot.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a Cluster</a>.</p>
    pub fn change_type(&self) -> std::option::Option<&crate::model::ChangeType> {
        self.change_type.as_ref()
    }
}
impl std::fmt::Debug for CacheNodeTypeSpecificParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheNodeTypeSpecificParameter");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("description", &self.description);
        formatter.field("source", &self.source);
        formatter.field("data_type", &self.data_type);
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("is_modifiable", &self.is_modifiable);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field(
            "cache_node_type_specific_values",
            &self.cache_node_type_specific_values,
        );
        formatter.field("change_type", &self.change_type);
        formatter.finish()
    }
}
/// See [`CacheNodeTypeSpecificParameter`](crate::model::CacheNodeTypeSpecificParameter)
pub mod cache_node_type_specific_parameter {
    /// A builder for [`CacheNodeTypeSpecificParameter`](crate::model::CacheNodeTypeSpecificParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) allowed_values: std::option::Option<std::string::String>,
        pub(crate) is_modifiable: std::option::Option<bool>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) cache_node_type_specific_values:
            std::option::Option<std::vec::Vec<crate::model::CacheNodeTypeSpecificValue>>,
        pub(crate) change_type: std::option::Option<crate::model::ChangeType>,
    }
    impl Builder {
        /// <p>The name of the parameter.</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>A description of the parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The source of the parameter value.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source of the parameter value.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The valid data type for the parameter.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>The valid data type for the parameter.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The valid range of values for the parameter.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_values = Some(input.into());
            self
        }
        /// <p>The valid range of values for the parameter.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p>Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be
        /// modified. Some parameters have security or operational implications that prevent them
        /// from being changed.</p>
        pub fn is_modifiable(mut self, input: bool) -> Self {
            self.is_modifiable = Some(input);
            self
        }
        /// <p>Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be
        /// modified. Some parameters have security or operational implications that prevent them
        /// from being changed.</p>
        pub fn set_is_modifiable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_modifiable = input;
            self
        }
        /// <p>The earliest cache engine version to which the parameter can apply.</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The earliest cache engine version to which the parameter can apply.</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// Appends an item to `cache_node_type_specific_values`.
        ///
        /// To override the contents of this collection use [`set_cache_node_type_specific_values`](Self::set_cache_node_type_specific_values).
        ///
        /// <p>A list of cache node types and their corresponding values for this parameter.</p>
        pub fn cache_node_type_specific_values(
            mut self,
            input: impl Into<crate::model::CacheNodeTypeSpecificValue>,
        ) -> Self {
            let mut v = self.cache_node_type_specific_values.unwrap_or_default();
            v.push(input.into());
            self.cache_node_type_specific_values = Some(v);
            self
        }
        /// <p>A list of cache node types and their corresponding values for this parameter.</p>
        pub fn set_cache_node_type_specific_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheNodeTypeSpecificValue>>,
        ) -> Self {
            self.cache_node_type_specific_values = input;
            self
        }
        /// <p>Indicates whether a change to the parameter is applied immediately
        /// or requires a reboot for the change to be applied.
        /// You can force a reboot or wait until the next maintenance window's reboot.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a Cluster</a>.</p>
        pub fn change_type(mut self, input: crate::model::ChangeType) -> Self {
            self.change_type = Some(input);
            self
        }
        /// <p>Indicates whether a change to the parameter is applied immediately
        /// or requires a reboot for the change to be applied.
        /// You can force a reboot or wait until the next maintenance window's reboot.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a Cluster</a>.</p>
        pub fn set_change_type(
            mut self,
            input: std::option::Option<crate::model::ChangeType>,
        ) -> Self {
            self.change_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheNodeTypeSpecificParameter`](crate::model::CacheNodeTypeSpecificParameter)
        pub fn build(self) -> crate::model::CacheNodeTypeSpecificParameter {
            crate::model::CacheNodeTypeSpecificParameter {
                parameter_name: self.parameter_name,
                description: self.description,
                source: self.source,
                data_type: self.data_type,
                allowed_values: self.allowed_values,
                is_modifiable: self.is_modifiable.unwrap_or_default(),
                minimum_engine_version: self.minimum_engine_version,
                cache_node_type_specific_values: self.cache_node_type_specific_values,
                change_type: self.change_type,
            }
        }
    }
}
impl CacheNodeTypeSpecificParameter {
    /// Creates a new builder-style object to manufacture [`CacheNodeTypeSpecificParameter`](crate::model::CacheNodeTypeSpecificParameter)
    pub fn builder() -> crate::model::cache_node_type_specific_parameter::Builder {
        crate::model::cache_node_type_specific_parameter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeType {
    #[allow(missing_docs)] // documentation missing in model
    Immediate,
    #[allow(missing_docs)] // documentation missing in model
    RequiresReboot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeType {
    fn from(s: &str) -> Self {
        match s {
            "immediate" => ChangeType::Immediate,
            "requires-reboot" => ChangeType::RequiresReboot,
            other => ChangeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeType::from(s))
    }
}
impl ChangeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeType::Immediate => "immediate",
            ChangeType::RequiresReboot => "requires-reboot",
            ChangeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["immediate", "requires-reboot"]
    }
}
impl AsRef<str> for ChangeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A value that applies only to a certain cache node type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheNodeTypeSpecificValue {
    /// <p>The cache node type for which this value applies.</p>
    pub cache_node_type: std::option::Option<std::string::String>,
    /// <p>The value for the cache node type.</p>
    pub value: std::option::Option<std::string::String>,
}
impl CacheNodeTypeSpecificValue {
    /// <p>The cache node type for which this value applies.</p>
    pub fn cache_node_type(&self) -> std::option::Option<&str> {
        self.cache_node_type.as_deref()
    }
    /// <p>The value for the cache node type.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for CacheNodeTypeSpecificValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheNodeTypeSpecificValue");
        formatter.field("cache_node_type", &self.cache_node_type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`CacheNodeTypeSpecificValue`](crate::model::CacheNodeTypeSpecificValue)
pub mod cache_node_type_specific_value {
    /// A builder for [`CacheNodeTypeSpecificValue`](crate::model::CacheNodeTypeSpecificValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_node_type: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cache node type for which this value applies.</p>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_node_type = Some(input.into());
            self
        }
        /// <p>The cache node type for which this value applies.</p>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_node_type = input;
            self
        }
        /// <p>The value for the cache node type.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for the cache node type.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheNodeTypeSpecificValue`](crate::model::CacheNodeTypeSpecificValue)
        pub fn build(self) -> crate::model::CacheNodeTypeSpecificValue {
            crate::model::CacheNodeTypeSpecificValue {
                cache_node_type: self.cache_node_type,
                value: self.value,
            }
        }
    }
}
impl CacheNodeTypeSpecificValue {
    /// Creates a new builder-style object to manufacture [`CacheNodeTypeSpecificValue`](crate::model::CacheNodeTypeSpecificValue)
    pub fn builder() -> crate::model::cache_node_type_specific_value::Builder {
        crate::model::cache_node_type_specific_value::Builder::default()
    }
}

/// <p>Describes an individual setting that controls some aspect of ElastiCache behavior.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parameter {
    /// <p>The name of the parameter.</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>The value of the parameter.</p>
    pub parameter_value: std::option::Option<std::string::String>,
    /// <p>A description of the parameter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The source of the parameter.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The valid data type for the parameter.</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>The valid range of values for the parameter.</p>
    pub allowed_values: std::option::Option<std::string::String>,
    /// <p>Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified.
    /// Some parameters have security or operational implications that prevent them from being changed.</p>
    pub is_modifiable: bool,
    /// <p>The earliest cache engine version to which the parameter can apply.</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>Indicates whether a change to the parameter is applied immediately
    /// or requires a reboot for the change to be applied.
    /// You can force a reboot or wait until the next maintenance window's reboot.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a Cluster</a>.</p>
    pub change_type: std::option::Option<crate::model::ChangeType>,
}
impl Parameter {
    /// <p>The name of the parameter.</p>
    pub fn parameter_name(&self) -> std::option::Option<&str> {
        self.parameter_name.as_deref()
    }
    /// <p>The value of the parameter.</p>
    pub fn parameter_value(&self) -> std::option::Option<&str> {
        self.parameter_value.as_deref()
    }
    /// <p>A description of the parameter.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The source of the parameter.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The valid data type for the parameter.</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
    /// <p>The valid range of values for the parameter.</p>
    pub fn allowed_values(&self) -> std::option::Option<&str> {
        self.allowed_values.as_deref()
    }
    /// <p>Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified.
    /// Some parameters have security or operational implications that prevent them from being changed.</p>
    pub fn is_modifiable(&self) -> bool {
        self.is_modifiable
    }
    /// <p>The earliest cache engine version to which the parameter can apply.</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>Indicates whether a change to the parameter is applied immediately
    /// or requires a reboot for the change to be applied.
    /// You can force a reboot or wait until the next maintenance window's reboot.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a Cluster</a>.</p>
    pub fn change_type(&self) -> std::option::Option<&crate::model::ChangeType> {
        self.change_type.as_ref()
    }
}
impl std::fmt::Debug for Parameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parameter");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.field("description", &self.description);
        formatter.field("source", &self.source);
        formatter.field("data_type", &self.data_type);
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("is_modifiable", &self.is_modifiable);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("change_type", &self.change_type);
        formatter.finish()
    }
}
/// See [`Parameter`](crate::model::Parameter)
pub mod parameter {
    /// A builder for [`Parameter`](crate::model::Parameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) allowed_values: std::option::Option<std::string::String>,
        pub(crate) is_modifiable: std::option::Option<bool>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) change_type: std::option::Option<crate::model::ChangeType>,
    }
    impl Builder {
        /// <p>The name of the parameter.</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>The value of the parameter.</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>The value of the parameter.</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// <p>A description of the parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The source of the parameter.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source of the parameter.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The valid data type for the parameter.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>The valid data type for the parameter.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The valid range of values for the parameter.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_values = Some(input.into());
            self
        }
        /// <p>The valid range of values for the parameter.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p>Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified.
        /// Some parameters have security or operational implications that prevent them from being changed.</p>
        pub fn is_modifiable(mut self, input: bool) -> Self {
            self.is_modifiable = Some(input);
            self
        }
        /// <p>Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified.
        /// Some parameters have security or operational implications that prevent them from being changed.</p>
        pub fn set_is_modifiable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_modifiable = input;
            self
        }
        /// <p>The earliest cache engine version to which the parameter can apply.</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The earliest cache engine version to which the parameter can apply.</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>Indicates whether a change to the parameter is applied immediately
        /// or requires a reboot for the change to be applied.
        /// You can force a reboot or wait until the next maintenance window's reboot.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a Cluster</a>.</p>
        pub fn change_type(mut self, input: crate::model::ChangeType) -> Self {
            self.change_type = Some(input);
            self
        }
        /// <p>Indicates whether a change to the parameter is applied immediately
        /// or requires a reboot for the change to be applied.
        /// You can force a reboot or wait until the next maintenance window's reboot.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a Cluster</a>.</p>
        pub fn set_change_type(
            mut self,
            input: std::option::Option<crate::model::ChangeType>,
        ) -> Self {
            self.change_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Parameter`](crate::model::Parameter)
        pub fn build(self) -> crate::model::Parameter {
            crate::model::Parameter {
                parameter_name: self.parameter_name,
                parameter_value: self.parameter_value,
                description: self.description,
                source: self.source,
                data_type: self.data_type,
                allowed_values: self.allowed_values,
                is_modifiable: self.is_modifiable.unwrap_or_default(),
                minimum_engine_version: self.minimum_engine_version,
                change_type: self.change_type,
            }
        }
    }
}
impl Parameter {
    /// Creates a new builder-style object to manufacture [`Parameter`](crate::model::Parameter)
    pub fn builder() -> crate::model::parameter::Builder {
        crate::model::parameter::Builder::default()
    }
}

/// <p>Represents the output of a <code>CreateCacheParameterGroup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheParameterGroup {
    /// <p>The name of the cache parameter group.</p>
    pub cache_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the cache parameter group family that this cache parameter group is compatible with.</p>
    /// <p>Valid values are:
    /// <code>memcached1.4</code> |
    /// <code>memcached1.5</code> |
    /// <code>memcached1.6</code> |
    /// <code>redis2.6</code> |
    /// <code>redis2.8</code> |
    /// <code>redis3.2</code> |
    /// <code>redis4.0</code> |
    /// <code>redis5.0</code> |
    /// <code>redis6.0</code> |
    /// </p>
    pub cache_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The description for this cache parameter group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Indicates whether the parameter group is associated with a Global datastore</p>
    pub is_global: bool,
    /// <p>The ARN (Amazon Resource Name) of the cache parameter group.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl CacheParameterGroup {
    /// <p>The name of the cache parameter group.</p>
    pub fn cache_parameter_group_name(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_name.as_deref()
    }
    /// <p>The name of the cache parameter group family that this cache parameter group is compatible with.</p>
    /// <p>Valid values are:
    /// <code>memcached1.4</code> |
    /// <code>memcached1.5</code> |
    /// <code>memcached1.6</code> |
    /// <code>redis2.6</code> |
    /// <code>redis2.8</code> |
    /// <code>redis3.2</code> |
    /// <code>redis4.0</code> |
    /// <code>redis5.0</code> |
    /// <code>redis6.0</code> |
    /// </p>
    pub fn cache_parameter_group_family(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_family.as_deref()
    }
    /// <p>The description for this cache parameter group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Indicates whether the parameter group is associated with a Global datastore</p>
    pub fn is_global(&self) -> bool {
        self.is_global
    }
    /// <p>The ARN (Amazon Resource Name) of the cache parameter group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for CacheParameterGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheParameterGroup");
        formatter.field(
            "cache_parameter_group_name",
            &self.cache_parameter_group_name,
        );
        formatter.field(
            "cache_parameter_group_family",
            &self.cache_parameter_group_family,
        );
        formatter.field("description", &self.description);
        formatter.field("is_global", &self.is_global);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CacheParameterGroup`](crate::model::CacheParameterGroup)
pub mod cache_parameter_group {
    /// A builder for [`CacheParameterGroup`](crate::model::CacheParameterGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) cache_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) is_global: std::option::Option<bool>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cache parameter group.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_name = input;
            self
        }
        /// <p>The name of the cache parameter group family that this cache parameter group is compatible with.</p>
        /// <p>Valid values are:
        /// <code>memcached1.4</code> |
        /// <code>memcached1.5</code> |
        /// <code>memcached1.6</code> |
        /// <code>redis2.6</code> |
        /// <code>redis2.8</code> |
        /// <code>redis3.2</code> |
        /// <code>redis4.0</code> |
        /// <code>redis5.0</code> |
        /// <code>redis6.0</code> |
        /// </p>
        pub fn cache_parameter_group_family(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group family that this cache parameter group is compatible with.</p>
        /// <p>Valid values are:
        /// <code>memcached1.4</code> |
        /// <code>memcached1.5</code> |
        /// <code>memcached1.6</code> |
        /// <code>redis2.6</code> |
        /// <code>redis2.8</code> |
        /// <code>redis3.2</code> |
        /// <code>redis4.0</code> |
        /// <code>redis5.0</code> |
        /// <code>redis6.0</code> |
        /// </p>
        pub fn set_cache_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_family = input;
            self
        }
        /// <p>The description for this cache parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for this cache parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Indicates whether the parameter group is associated with a Global datastore</p>
        pub fn is_global(mut self, input: bool) -> Self {
            self.is_global = Some(input);
            self
        }
        /// <p>Indicates whether the parameter group is associated with a Global datastore</p>
        pub fn set_is_global(mut self, input: std::option::Option<bool>) -> Self {
            self.is_global = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the cache parameter group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the cache parameter group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheParameterGroup`](crate::model::CacheParameterGroup)
        pub fn build(self) -> crate::model::CacheParameterGroup {
            crate::model::CacheParameterGroup {
                cache_parameter_group_name: self.cache_parameter_group_name,
                cache_parameter_group_family: self.cache_parameter_group_family,
                description: self.description,
                is_global: self.is_global.unwrap_or_default(),
                arn: self.arn,
            }
        }
    }
}
impl CacheParameterGroup {
    /// Creates a new builder-style object to manufacture [`CacheParameterGroup`](crate::model::CacheParameterGroup)
    pub fn builder() -> crate::model::cache_parameter_group::Builder {
        crate::model::cache_parameter_group::Builder::default()
    }
}

/// <p>Provides all of the details about a particular cache engine version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheEngineVersion {
    /// <p>The name of the cache engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version number of the cache engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The name of the cache parameter group family associated with this cache engine.</p>
    /// <p>Valid values are:
    /// <code>memcached1.4</code> |
    /// <code>memcached1.5</code> |
    /// <code>memcached1.6</code> |
    /// <code>redis2.6</code> |
    /// <code>redis2.8</code> |
    /// <code>redis3.2</code> |
    /// <code>redis4.0</code> |
    /// <code>redis5.0</code> |
    /// <code>redis6.0</code> |
    /// <code>redis6.2</code>
    /// </p>
    pub cache_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The description of the cache engine.</p>
    pub cache_engine_description: std::option::Option<std::string::String>,
    /// <p>The description of the cache engine version.</p>
    pub cache_engine_version_description: std::option::Option<std::string::String>,
}
impl CacheEngineVersion {
    /// <p>The name of the cache engine.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The version number of the cache engine.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The name of the cache parameter group family associated with this cache engine.</p>
    /// <p>Valid values are:
    /// <code>memcached1.4</code> |
    /// <code>memcached1.5</code> |
    /// <code>memcached1.6</code> |
    /// <code>redis2.6</code> |
    /// <code>redis2.8</code> |
    /// <code>redis3.2</code> |
    /// <code>redis4.0</code> |
    /// <code>redis5.0</code> |
    /// <code>redis6.0</code> |
    /// <code>redis6.2</code>
    /// </p>
    pub fn cache_parameter_group_family(&self) -> std::option::Option<&str> {
        self.cache_parameter_group_family.as_deref()
    }
    /// <p>The description of the cache engine.</p>
    pub fn cache_engine_description(&self) -> std::option::Option<&str> {
        self.cache_engine_description.as_deref()
    }
    /// <p>The description of the cache engine version.</p>
    pub fn cache_engine_version_description(&self) -> std::option::Option<&str> {
        self.cache_engine_version_description.as_deref()
    }
}
impl std::fmt::Debug for CacheEngineVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheEngineVersion");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "cache_parameter_group_family",
            &self.cache_parameter_group_family,
        );
        formatter.field("cache_engine_description", &self.cache_engine_description);
        formatter.field(
            "cache_engine_version_description",
            &self.cache_engine_version_description,
        );
        formatter.finish()
    }
}
/// See [`CacheEngineVersion`](crate::model::CacheEngineVersion)
pub mod cache_engine_version {
    /// A builder for [`CacheEngineVersion`](crate::model::CacheEngineVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) cache_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) cache_engine_description: std::option::Option<std::string::String>,
        pub(crate) cache_engine_version_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cache engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the cache engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the cache engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the cache engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of the cache parameter group family associated with this cache engine.</p>
        /// <p>Valid values are:
        /// <code>memcached1.4</code> |
        /// <code>memcached1.5</code> |
        /// <code>memcached1.6</code> |
        /// <code>redis2.6</code> |
        /// <code>redis2.8</code> |
        /// <code>redis3.2</code> |
        /// <code>redis4.0</code> |
        /// <code>redis5.0</code> |
        /// <code>redis6.0</code> |
        /// <code>redis6.2</code>
        /// </p>
        pub fn cache_parameter_group_family(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the cache parameter group family associated with this cache engine.</p>
        /// <p>Valid values are:
        /// <code>memcached1.4</code> |
        /// <code>memcached1.5</code> |
        /// <code>memcached1.6</code> |
        /// <code>redis2.6</code> |
        /// <code>redis2.8</code> |
        /// <code>redis3.2</code> |
        /// <code>redis4.0</code> |
        /// <code>redis5.0</code> |
        /// <code>redis6.0</code> |
        /// <code>redis6.2</code>
        /// </p>
        pub fn set_cache_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_parameter_group_family = input;
            self
        }
        /// <p>The description of the cache engine.</p>
        pub fn cache_engine_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_engine_description = Some(input.into());
            self
        }
        /// <p>The description of the cache engine.</p>
        pub fn set_cache_engine_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_engine_description = input;
            self
        }
        /// <p>The description of the cache engine version.</p>
        pub fn cache_engine_version_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cache_engine_version_description = Some(input.into());
            self
        }
        /// <p>The description of the cache engine version.</p>
        pub fn set_cache_engine_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_engine_version_description = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheEngineVersion`](crate::model::CacheEngineVersion)
        pub fn build(self) -> crate::model::CacheEngineVersion {
            crate::model::CacheEngineVersion {
                engine: self.engine,
                engine_version: self.engine_version,
                cache_parameter_group_family: self.cache_parameter_group_family,
                cache_engine_description: self.cache_engine_description,
                cache_engine_version_description: self.cache_engine_version_description,
            }
        }
    }
}
impl CacheEngineVersion {
    /// Creates a new builder-style object to manufacture [`CacheEngineVersion`](crate::model::CacheEngineVersion)
    pub fn builder() -> crate::model::cache_engine_version::Builder {
        crate::model::cache_engine_version::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OutpostMode {
    #[allow(missing_docs)] // documentation missing in model
    CrossOutpost,
    #[allow(missing_docs)] // documentation missing in model
    SingleOutpost,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OutpostMode {
    fn from(s: &str) -> Self {
        match s {
            "cross-outpost" => OutpostMode::CrossOutpost,
            "single-outpost" => OutpostMode::SingleOutpost,
            other => OutpostMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OutpostMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OutpostMode::from(s))
    }
}
impl OutpostMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OutpostMode::CrossOutpost => "cross-outpost",
            OutpostMode::SingleOutpost => "single-outpost",
            OutpostMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["cross-outpost", "single-outpost"]
    }
}
impl AsRef<str> for OutpostMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Update action that has failed to be processed for the corresponding apply/stop request</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnprocessedUpdateAction {
    /// <p>The replication group ID</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The ID of the cache cluster</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>The unique ID of the service update</p>
    pub service_update_name: std::option::Option<std::string::String>,
    /// <p>The error type for requests that are not processed</p>
    pub error_type: std::option::Option<std::string::String>,
    /// <p>The error message that describes the reason the request was not processed</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl UnprocessedUpdateAction {
    /// <p>The replication group ID</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The ID of the cache cluster</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>The unique ID of the service update</p>
    pub fn service_update_name(&self) -> std::option::Option<&str> {
        self.service_update_name.as_deref()
    }
    /// <p>The error type for requests that are not processed</p>
    pub fn error_type(&self) -> std::option::Option<&str> {
        self.error_type.as_deref()
    }
    /// <p>The error message that describes the reason the request was not processed</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for UnprocessedUpdateAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnprocessedUpdateAction");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("service_update_name", &self.service_update_name);
        formatter.field("error_type", &self.error_type);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`UnprocessedUpdateAction`](crate::model::UnprocessedUpdateAction)
pub mod unprocessed_update_action {
    /// A builder for [`UnprocessedUpdateAction`](crate::model::UnprocessedUpdateAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) service_update_name: std::option::Option<std::string::String>,
        pub(crate) error_type: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The replication group ID</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The replication group ID</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The ID of the cache cluster</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the cache cluster</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_update_name = Some(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_update_name = input;
            self
        }
        /// <p>The error type for requests that are not processed</p>
        pub fn error_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_type = Some(input.into());
            self
        }
        /// <p>The error type for requests that are not processed</p>
        pub fn set_error_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_type = input;
            self
        }
        /// <p>The error message that describes the reason the request was not processed</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message that describes the reason the request was not processed</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnprocessedUpdateAction`](crate::model::UnprocessedUpdateAction)
        pub fn build(self) -> crate::model::UnprocessedUpdateAction {
            crate::model::UnprocessedUpdateAction {
                replication_group_id: self.replication_group_id,
                cache_cluster_id: self.cache_cluster_id,
                service_update_name: self.service_update_name,
                error_type: self.error_type,
                error_message: self.error_message,
            }
        }
    }
}
impl UnprocessedUpdateAction {
    /// Creates a new builder-style object to manufacture [`UnprocessedUpdateAction`](crate::model::UnprocessedUpdateAction)
    pub fn builder() -> crate::model::unprocessed_update_action::Builder {
        crate::model::unprocessed_update_action::Builder::default()
    }
}

/// <p>Update action that has been processed for the corresponding apply/stop request</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProcessedUpdateAction {
    /// <p>The ID of the replication group</p>
    pub replication_group_id: std::option::Option<std::string::String>,
    /// <p>The ID of the cache cluster</p>
    pub cache_cluster_id: std::option::Option<std::string::String>,
    /// <p>The unique ID of the service update</p>
    pub service_update_name: std::option::Option<std::string::String>,
    /// <p>The status of the update action on the Redis cluster</p>
    pub update_action_status: std::option::Option<crate::model::UpdateActionStatus>,
}
impl ProcessedUpdateAction {
    /// <p>The ID of the replication group</p>
    pub fn replication_group_id(&self) -> std::option::Option<&str> {
        self.replication_group_id.as_deref()
    }
    /// <p>The ID of the cache cluster</p>
    pub fn cache_cluster_id(&self) -> std::option::Option<&str> {
        self.cache_cluster_id.as_deref()
    }
    /// <p>The unique ID of the service update</p>
    pub fn service_update_name(&self) -> std::option::Option<&str> {
        self.service_update_name.as_deref()
    }
    /// <p>The status of the update action on the Redis cluster</p>
    pub fn update_action_status(&self) -> std::option::Option<&crate::model::UpdateActionStatus> {
        self.update_action_status.as_ref()
    }
}
impl std::fmt::Debug for ProcessedUpdateAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProcessedUpdateAction");
        formatter.field("replication_group_id", &self.replication_group_id);
        formatter.field("cache_cluster_id", &self.cache_cluster_id);
        formatter.field("service_update_name", &self.service_update_name);
        formatter.field("update_action_status", &self.update_action_status);
        formatter.finish()
    }
}
/// See [`ProcessedUpdateAction`](crate::model::ProcessedUpdateAction)
pub mod processed_update_action {
    /// A builder for [`ProcessedUpdateAction`](crate::model::ProcessedUpdateAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group_id: std::option::Option<std::string::String>,
        pub(crate) cache_cluster_id: std::option::Option<std::string::String>,
        pub(crate) service_update_name: std::option::Option<std::string::String>,
        pub(crate) update_action_status: std::option::Option<crate::model::UpdateActionStatus>,
    }
    impl Builder {
        /// <p>The ID of the replication group</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication group</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_group_id = input;
            self
        }
        /// <p>The ID of the cache cluster</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of the cache cluster</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_cluster_id = input;
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_update_name = Some(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_update_name = input;
            self
        }
        /// <p>The status of the update action on the Redis cluster</p>
        pub fn update_action_status(mut self, input: crate::model::UpdateActionStatus) -> Self {
            self.update_action_status = Some(input);
            self
        }
        /// <p>The status of the update action on the Redis cluster</p>
        pub fn set_update_action_status(
            mut self,
            input: std::option::Option<crate::model::UpdateActionStatus>,
        ) -> Self {
            self.update_action_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ProcessedUpdateAction`](crate::model::ProcessedUpdateAction)
        pub fn build(self) -> crate::model::ProcessedUpdateAction {
            crate::model::ProcessedUpdateAction {
                replication_group_id: self.replication_group_id,
                cache_cluster_id: self.cache_cluster_id,
                service_update_name: self.service_update_name,
                update_action_status: self.update_action_status,
            }
        }
    }
}
impl ProcessedUpdateAction {
    /// Creates a new builder-style object to manufacture [`ProcessedUpdateAction`](crate::model::ProcessedUpdateAction)
    pub fn builder() -> crate::model::processed_update_action::Builder {
        crate::model::processed_update_action::Builder::default()
    }
}
